import { RotationType } from './rotation-type';
import type { Vector } from './vector';
/**
 * Linear interpolation between `a` and `b`, at `time = 0` the value will be `a` at `time = 1` the value will be `b`
 * @param a
 * @param b
 * @param time
 */
export declare function lerp(a: number, b: number, time: number): number;
/**
 * Linear interpolation between angles in radians
 * @param startAngle
 * @param endAngle
 * @param rotationType
 * @param time
 */
export declare function lerpAngle(startAngle: number, endAngle: number, rotationType: RotationType, time: number): number;
/**
 * Linear interpolation between `a` and `b`, at `time = 0` the value will be `a` at `time = 1` the value will be `b`
 * @param a
 * @param b
 * @param time
 */
export declare function lerpVector(a: Vector, b: Vector, time: number): Vector;
/**
 * Inverse of a linear interpolation, given a `value` in between `a` and `b` return how close to `a` or `b` the `value` is.
 *
 * Example: `a=1`, `b=5`, `value=4` will return `.75`
 * @param a
 * @param b
 * @param value
 */
export declare function inverseLerp(a: number, b: number, value: number): number;
/**
 * Inverse of a linear interpolation, given a `value` in between `a` and `b` return how close to `a` or `b` the `value` is.
 *
 * **Warning** assumes that the `value` vector is co-linear with vector `a` and `b`
 *
 * Example: `a=1`, `b=5`, `value=4` will return `.75`
 * @param a
 * @param b
 * @param value
 */
export declare function inverseLerpVector(a: Vector, b: Vector, value: Vector): number;
/**
 * Remaps a value from a source domain to a destination
 * @param minSource
 * @param maxSource
 * @param minDestination
 * @param maxDestination
 * @param value
 */
export declare function remap(minSource: number, maxSource: number, minDestination: number, maxDestination: number, value: number): number;
/**
 * Remaps a value from a source domain to a destination
 *
 * **Warning** assumes that the `value` vector is co-linear with vector `minSource` and `maxSource`
 * @param minSource
 * @param maxSource
 * @param minDestination
 * @param maxDestination
 * @param value
 */
export declare function remapVector(minSource: Vector, maxSource: Vector, minDestination: Vector, maxDestination: Vector, value: Vector): Vector;
