import type { ExcaliburGraphicsContextWebGL } from '../Graphics/Context/ExcaliburGraphicsContextWebGL';
import type { GpuParticleEmitter } from './GpuParticleEmitter';
import type { ParticleConfig } from './Particles';
import type { Random } from '../Math/Random';
import type { Sprite } from '../Graphics/Sprite';
export interface GpuParticleConfig extends ParticleConfig {
    /**
     * Only Sprite graphics are supported in GPU particles at the moment
     */
    graphic?: Sprite;
    /**
     * Set the maximum particles to use for this emitter
     */
    maxParticles?: number;
}
/**
 * Container for the GPU Particle State contains the internal state needed for the GPU
 * to render particles and maintain state.
 */
export declare class GpuParticleRenderer {
    static readonly GPU_MAX_PARTICLES: number;
    emitter: GpuParticleEmitter;
    emitRate: number;
    particle: GpuParticleConfig;
    private _initialized;
    private _vaos;
    private _buffers;
    private _random;
    private _drawIndex;
    private _currentVao;
    private _currentBuffer;
    private _numInputFloats;
    private _particleData;
    private _particleIndex;
    private _uploadIndex;
    private _wrappedLife;
    private _wrappedParticles;
    private _particleLife;
    constructor(emitter: GpuParticleEmitter, random: Random, options: GpuParticleConfig);
    get isInitialized(): boolean;
    get maxParticles(): number;
    initialize(gl: WebGL2RenderingContext, context: ExcaliburGraphicsContextWebGL): void;
    private _clearRequested;
    clearParticles(): void;
    private _emitted;
    emitParticles(particleCount: number): void;
    private _uploadEmitted;
    update(elapsed: number): void;
    draw(gl: WebGL2RenderingContext): void;
}
