import type { Engine } from '../Engine';
import { Color } from '../Color';
import { Vector } from '../Math/vector';
import type { Random } from '../Math/Random';
import { TransformComponent } from '../EntityComponentSystem/Components/TransformComponent';
import { GraphicsComponent } from '../Graphics/GraphicsComponent';
import { Entity } from '../EntityComponentSystem/Entity';
import type { Graphic } from '../Graphics';
import type { EmitterType } from './EmitterType';
import { MotionComponent } from '../EntityComponentSystem';
import type { ParticleEmitter } from './ParticleEmitter';
/**
/**
 * CPU Particle is used in a {@apilink ParticleEmitter}
 */
export declare class Particle extends Entity {
    static DefaultConfig: ParticleConfig;
    focus?: Vector;
    focusAccel?: number;
    beginColor: Color;
    endColor: Color;
    life: number;
    fade: boolean;
    private _rRate;
    private _gRate;
    private _bRate;
    private _aRate;
    private _currentColor;
    size: number;
    graphic?: Graphic;
    startSize?: number;
    endSize?: number;
    sizeRate: number;
    visible: boolean;
    isOffscreen: boolean;
    transform: TransformComponent;
    motion: MotionComponent;
    graphics: GraphicsComponent;
    particleTransform: ParticleTransform;
    name: string;
    constructor(options: ParticleConfig);
    private _emitter?;
    registerEmitter(emitter: ParticleEmitter): void;
    configure(options: ParticleConfig): void;
    kill(): void;
    update(engine: Engine, elapsed: number): void;
}
export interface ParticleConfig {
    /**
     * Optionally set the emitted particle transform style, {@apilink ParticleTransform.Global} is the default and emits particles as if
     * they were world space objects, useful for most effects.
     *
     * If set to {@apilink ParticleTransform.Local} particles are children of the emitter and move relative to the emitter
     * as they would in a parent/child actor relationship.
     */
    transform?: ParticleTransform;
    /**
     * Starting position of the particle
     */
    pos?: Vector;
    /**
     * Starting velocity of the particle
     */
    vel?: Vector;
    /**
     * Starting acceleration of the particle
     */
    acc?: Vector;
    /**
     * Starting angular velocity of the particle
     */
    angularVelocity?: number;
    /**
     * Starting rotation of the particle
     */
    rotation?: number;
    /**
     * Size of the particle in pixels
     */
    size?: number;
    /**
     * Optionally set a graphic
     */
    graphic?: Graphic;
    /**
     * Totally life of the particle in milliseconds
     */
    life?: number;
    /**
     * Starting opacity of the particle
     */
    opacity?: number;
    /**
     * Should the particle fade out to fully transparent over their life
     */
    fade?: boolean;
    /**
     * Ending color of the particle over its life
     */
    endColor?: Color;
    /**
     * Beginning color of the particle over its life
     */
    beginColor?: Color;
    /**
     * Set the start size when you want to change particle size over their life
     */
    startSize?: number;
    /**
     * Set the end size when you want to change particle size over their life
     */
    endSize?: number;
    /**
     * Smallest possible starting size of the particle
     */
    minSize?: number;
    /**
     * Largest possible starting size of the particle
     */
    maxSize?: number;
    /**
     * Minimum magnitude of the particle starting speed
     */
    minSpeed?: number;
    /**
     * Maximum magnitude of the particle starting speed
     */
    maxSpeed?: number;
    /**
     * Minimum angle to use for the particles starting rotation
     */
    minAngle?: number;
    /**
     * Maximum angle to use for the particles starting rotation
     */
    maxAngle?: number;
    /**
     * Gets or sets the optional focus where all particles should accelerate towards
     *
     * If the particle transform is global the focus is in world space, otherwise it is relative to the emitter
     */
    focus?: Vector;
    /**
     * Gets or sets the optional acceleration for focusing particles if a focus has been specified
     */
    focusAccel?: number;
    /**
     * Indicates whether particles should start with a random rotation
     */
    randomRotation?: boolean;
}
export declare enum ParticleTransform {
    /**
     * {@apilink ParticleTransform.Global} is the default and emits particles as if
     * they were world space objects, useful for most effects.
     */
    Global = "global",
    /**
     * {@apilink ParticleTransform.Local} particles are children of the emitter and move relative to the emitter
     * as they would in a parent/child actor relationship.
     */
    Local = "local"
}
export interface ParticleEmitterArgs {
    particle?: ParticleConfig;
    x?: number;
    y?: number;
    z?: number;
    pos?: Vector;
    width?: number;
    height?: number;
    /**
     * Is emitting currently
     */
    isEmitting?: boolean;
    /**
     * Particles per second
     */
    emitRate?: number;
    focus?: Vector;
    focusAccel?: number;
    /**
     * Emitter shape
     */
    emitterType?: EmitterType;
    /**
     * Radius of the emitter if the emitter type is EmitterType.Circle
     */
    radius?: number;
    random?: Random;
}
