import type { Vector } from './Math/vector';
import type { CollisionEndEvent, CollisionStartEvent } from './Events';
import { ExitTriggerEvent, EnterTriggerEvent } from './Events';
import type { Entity } from './EntityComponentSystem';
import type { ActorArgs, ActorEvents } from './Actor';
import { Actor } from './Actor';
import { EventEmitter } from './EventEmitter';
export type TriggerEvents = ActorEvents & {
    exit: ExitTriggerEvent;
    enter: EnterTriggerEvent;
};
export declare const TriggerEvents: {
    ExitTrigger: string;
    EnterTrigger: string;
};
/**
 * TriggerOptions
 */
export interface TriggerOptions {
    pos?: Vector;
    width?: number;
    height?: number;
    visible?: boolean;
    action?: (entity: Entity) => void;
    target?: Entity;
    filter?: (entity: Entity) => boolean;
    repeat?: number;
}
/**
 * Triggers are a method of firing arbitrary code on collision. These are useful
 * as 'buttons', 'switches', or to trigger effects in a game. By default triggers
 * are invisible, and can only be seen when {@apilink Trigger.visible} is set to `true`.
 */
export declare class Trigger extends Actor {
    events: EventEmitter<import("./EntityComponentSystem").EntityEvents & {
        collisionstart: CollisionStartEvent;
        collisionend: CollisionEndEvent;
        precollision: import("./Events").PreCollisionEvent;
        postcollision: import("./Events").PostCollisionEvent;
        kill: import("./Events").KillEvent;
        prekill: import("./Events").PreKillEvent;
        postkill: import("./Events").PostKillEvent;
        predraw: import("./Events").PreDrawEvent;
        postdraw: import("./Events").PostDrawEvent;
        pretransformdraw: import("./Events").PreDrawEvent;
        posttransformdraw: import("./Events").PostDrawEvent;
        predebugdraw: import("./Events").PreDebugDrawEvent;
        postdebugdraw: import("./Events").PostDebugDrawEvent;
        pointerup: import(".").PointerEvent;
        pointerdown: import(".").PointerEvent;
        pointerenter: import(".").PointerEvent;
        pointerleave: import(".").PointerEvent;
        pointermove: import(".").PointerEvent;
        pointercancel: import(".").PointerEvent;
        pointerwheel: import(".").WheelEvent;
        pointerdragstart: import(".").PointerEvent;
        pointerdragend: import(".").PointerEvent;
        pointerdragenter: import(".").PointerEvent;
        pointerdragleave: import(".").PointerEvent;
        pointerdragmove: import(".").PointerEvent;
        enterviewport: import("./Events").EnterViewPortEvent;
        exitviewport: import("./Events").ExitViewPortEvent;
        actionstart: import("./Events").ActionStartEvent;
        actioncomplete: import("./Events").ActionCompleteEvent;
    } & {
        exit: ExitTriggerEvent;
        enter: EnterTriggerEvent;
    }>;
    target?: Entity;
    /**
     * Action to fire when triggered by collision
     */
    action: (entity: Entity) => void;
    /**
     * Filter to add additional granularity to action dispatch, if a filter is specified the action will only fire when
     * filter return true for the collided entity.
     */
    filter: (entity: Entity) => boolean;
    /**
     * Number of times to repeat before killing the trigger,
     */
    repeat: number;
    /**
     * @param options Trigger options
     */
    constructor(options: TriggerOptions & ActorArgs);
    private _matchesTarget;
    private _dispatchAction;
}
