/*!
 * excalibur - 0.31.0-alpha.1401+c3082a6 - 2025-5-6
 * https://github.com/excaliburjs/Excalibur
 * Copyright (c) 2025 Excalibur.js <https://github.com/excaliburjs/Excalibur/graphs/contributors>
 * Licensed BSD-2-Clause
 * @preserve
 */
/******/ var __webpack_modules__ = ({

/***/ "../../node_modules/css-loader/dist/runtime/api.js":
/*!*********************************************************!*\
  !*** ../../node_modules/css-loader/dist/runtime/api.js ***!
  \*********************************************************/
/***/ ((module) => {



/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
*/
module.exports = function (cssWithMappingToString) {
  var list = [];

  // return the list of modules as css string
  list.toString = function toString() {
    return this.map(function (item) {
      var content = "";
      var needLayer = typeof item[5] !== "undefined";
      if (item[4]) {
        content += "@supports (".concat(item[4], ") {");
      }
      if (item[2]) {
        content += "@media ".concat(item[2], " {");
      }
      if (needLayer) {
        content += "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {");
      }
      content += cssWithMappingToString(item);
      if (needLayer) {
        content += "}";
      }
      if (item[2]) {
        content += "}";
      }
      if (item[4]) {
        content += "}";
      }
      return content;
    }).join("");
  };

  // import a list of modules into the list
  list.i = function i(modules, media, dedupe, supports, layer) {
    if (typeof modules === "string") {
      modules = [[null, modules, undefined]];
    }
    var alreadyImportedModules = {};
    if (dedupe) {
      for (var k = 0; k < this.length; k++) {
        var id = this[k][0];
        if (id != null) {
          alreadyImportedModules[id] = true;
        }
      }
    }
    for (var _k = 0; _k < modules.length; _k++) {
      var item = [].concat(modules[_k]);
      if (dedupe && alreadyImportedModules[item[0]]) {
        continue;
      }
      if (typeof layer !== "undefined") {
        if (typeof item[5] === "undefined") {
          item[5] = layer;
        } else {
          item[1] = "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {").concat(item[1], "}");
          item[5] = layer;
        }
      }
      if (media) {
        if (!item[2]) {
          item[2] = media;
        } else {
          item[1] = "@media ".concat(item[2], " {").concat(item[1], "}");
          item[2] = media;
        }
      }
      if (supports) {
        if (!item[4]) {
          item[4] = "".concat(supports);
        } else {
          item[1] = "@supports (".concat(item[4], ") {").concat(item[1], "}");
          item[4] = supports;
        }
      }
      list.push(item);
    }
  };
  return list;
};

/***/ }),

/***/ "../../node_modules/css-loader/dist/runtime/sourceMaps.js":
/*!****************************************************************!*\
  !*** ../../node_modules/css-loader/dist/runtime/sourceMaps.js ***!
  \****************************************************************/
/***/ ((module) => {



module.exports = function (item) {
  var content = item[1];
  var cssMapping = item[3];
  if (!cssMapping) {
    return content;
  }
  if (typeof btoa === "function") {
    var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(cssMapping))));
    var data = "sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);
    var sourceMapping = "/*# ".concat(data, " */");
    return [content].concat([sourceMapping]).join("\n");
  }
  return [content].join("\n");
};

/***/ }),

/***/ "./Actions/Action.ts":
/*!***************************!*\
  !*** ./Actions/Action.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   nextActionId: () => (/* binding */ nextActionId)
/* harmony export */ });
let _ACTION_ID = 0;
/**
 *
 */
function nextActionId() {
    return _ACTION_ID++;
}


/***/ }),

/***/ "./Actions/Action/ActionSequence.ts":
/*!******************************************!*\
  !*** ./Actions/Action/ActionSequence.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionSequence: () => (/* binding */ ActionSequence)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");
/* harmony import */ var _ActionContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ActionContext */ "./Actions/ActionContext.ts");


/**
 * Action that can represent a sequence of actions, this can be useful in conjunction with
 * {@apilink ParallelActions} to run multiple sequences in parallel.
 */
class ActionSequence {
    constructor(entity, actionBuilder) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._stopped = false;
        this._sequenceBuilder = actionBuilder;
        this._sequenceContext = new _ActionContext__WEBPACK_IMPORTED_MODULE_1__.ActionContext(entity);
        this._actionQueue = this._sequenceContext.getQueue();
        this._sequenceBuilder(this._sequenceContext);
    }
    update(elapsed) {
        this._actionQueue.update(elapsed);
    }
    isComplete() {
        return this._stopped || this._actionQueue.isComplete();
    }
    stop() {
        this._stopped = true;
    }
    reset() {
        this._stopped = false;
        this._actionQueue.reset();
    }
    clone(entity) {
        return new ActionSequence(entity, this._sequenceBuilder);
    }
}


/***/ }),

/***/ "./Actions/Action/Blink.ts":
/*!*********************************!*\
  !*** ./Actions/Action/Blink.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Blink: () => (/* binding */ Blink)
/* harmony export */ });
/* harmony import */ var _Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Graphics/GraphicsComponent */ "./Graphics/GraphicsComponent.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");


class Blink {
    constructor(entity, timeVisible, timeNotVisible, numBlinks = 1) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._timeVisible = 0;
        this._timeNotVisible = 0;
        this._elapsedTime = 0;
        this._totalTime = 0;
        this._stopped = false;
        this._started = false;
        this._graphics = entity.get(_Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_1__.GraphicsComponent);
        this._timeVisible = timeVisible;
        this._timeNotVisible = timeNotVisible;
        this._duration = (timeVisible + timeNotVisible) * numBlinks;
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
            this._elapsedTime = 0;
            this._totalTime = 0;
        }
        if (!this._graphics) {
            return;
        }
        this._elapsedTime += elapsed;
        this._totalTime += elapsed;
        if (this._graphics.isVisible && this._elapsedTime >= this._timeVisible) {
            this._graphics.isVisible = false;
            this._elapsedTime = 0;
        }
        if (!this._graphics.isVisible && this._elapsedTime >= this._timeNotVisible) {
            this._graphics.isVisible = true;
            this._elapsedTime = 0;
        }
        if (this.isComplete()) {
            this._graphics.isVisible = true;
        }
    }
    isComplete() {
        return this._stopped || this._totalTime >= this._duration;
    }
    stop() {
        if (this._graphics) {
            this._graphics.isVisible = true;
        }
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
        this._elapsedTime = 0;
        this._totalTime = 0;
    }
}


/***/ }),

/***/ "./Actions/Action/CallMethod.ts":
/*!**************************************!*\
  !*** ./Actions/Action/CallMethod.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CallMethod: () => (/* binding */ CallMethod)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");

class CallMethod {
    constructor(method) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._hasBeenCalled = false;
        this._method = method;
    }
    update(elapsed) {
        this._method();
        this._hasBeenCalled = true;
    }
    isComplete() {
        return this._hasBeenCalled;
    }
    reset() {
        this._hasBeenCalled = false;
    }
    stop() {
        this._hasBeenCalled = true;
    }
}


/***/ }),

/***/ "./Actions/Action/CurveBy.ts":
/*!***********************************!*\
  !*** ./Actions/Action/CurveBy.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CurveBy: () => (/* binding */ CurveBy)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../EntityComponentSystem */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Math */ "./Math/bezier-curve.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math */ "./Math/vector.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Math */ "./Math/util.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Math */ "./Math/lerp.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");



class CurveBy {
    constructor(entity, options) {
        var _a;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._mode = 'dynamic';
        this._entity = entity;
        this._tx = this._entity.get(_EntityComponentSystem__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        if (!this._tx) {
            throw new Error(`Entity ${entity.name} has no TransformComponent, can only curveTo on Entities with TransformComponents.`);
        }
        this._curve = this._curve = new _Math__WEBPACK_IMPORTED_MODULE_2__.BezierCurve({
            controlPoints: [(0,_Math__WEBPACK_IMPORTED_MODULE_3__.vec)(0, 0), ...options.controlPoints],
            quality: options.quality
        });
        this._durationMs = options.duration;
        this._mode = (_a = options.mode) !== null && _a !== void 0 ? _a : this._mode;
        this._currentMs = this._durationMs;
    }
    update(elapsed) {
        if (!this._started) {
            this._curve.setControlPoint(0, this._tx.globalPos);
            this._curve.setControlPoint(1, this._curve.controlPoints[1].add(this._tx.globalPos));
            this._curve.setControlPoint(2, this._curve.controlPoints[2].add(this._tx.globalPos));
            this._curve.setControlPoint(3, this._curve.controlPoints[3].add(this._tx.globalPos));
            this._started = true;
        }
        this._currentMs -= elapsed;
        const t = (0,_Math__WEBPACK_IMPORTED_MODULE_4__.clamp)((0,_Math__WEBPACK_IMPORTED_MODULE_5__.remap)(0, this._durationMs, 0, 1, this._durationMs - this._currentMs), 0, 1);
        if (this._mode === 'dynamic') {
            this._tx.pos = this._curve.getPoint(t);
        }
        else {
            this._tx.pos = this._curve.getUniformPoint(t);
        }
        if (this.isComplete(this._entity)) {
            if (this._mode === 'dynamic') {
                this._tx.pos = this._curve.getPoint(1);
            }
            else {
                this._tx.pos = this._curve.getUniformPoint(1);
            }
        }
    }
    isComplete(entity) {
        return this._stopped || this._currentMs < 0;
    }
    reset() {
        this._currentMs = this._durationMs;
        this._started = false;
        this._stopped = false;
    }
    stop() {
        this._stopped = true;
    }
}


/***/ }),

/***/ "./Actions/Action/CurveTo.ts":
/*!***********************************!*\
  !*** ./Actions/Action/CurveTo.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CurveTo: () => (/* binding */ CurveTo)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../EntityComponentSystem */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Math */ "./Math/bezier-curve.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math */ "./Math/vector.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Math */ "./Math/util.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Math */ "./Math/lerp.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");



class CurveTo {
    constructor(entity, options) {
        var _a;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._mode = 'dynamic';
        this._entity = entity;
        this._tx = this._entity.get(_EntityComponentSystem__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        if (!this._tx) {
            throw new Error(`Entity ${entity.name} has no TransformComponent, can only curveTo on Entities with TransformComponents.`);
        }
        this._curve = new _Math__WEBPACK_IMPORTED_MODULE_2__.BezierCurve({
            controlPoints: [(0,_Math__WEBPACK_IMPORTED_MODULE_3__.vec)(0, 0), ...options.controlPoints],
            quality: options.quality
        });
        this._durationMs = options.duration;
        this._mode = (_a = options.mode) !== null && _a !== void 0 ? _a : this._mode;
        this._currentMs = this._durationMs;
    }
    update(elapsed) {
        if (!this._started) {
            this._curve.setControlPoint(0, this._tx.globalPos.clone());
            this._started = true;
        }
        this._currentMs -= elapsed;
        const t = (0,_Math__WEBPACK_IMPORTED_MODULE_4__.clamp)((0,_Math__WEBPACK_IMPORTED_MODULE_5__.remap)(0, this._durationMs, 0, 1, this._durationMs - this._currentMs), 0, 1);
        if (this._mode === 'dynamic') {
            this._tx.pos = this._curve.getPoint(t);
        }
        else {
            this._tx.pos = this._curve.getUniformPoint(t);
        }
        if (this.isComplete(this._entity)) {
            if (this._mode === 'dynamic') {
                this._tx.pos = this._curve.getPoint(1);
            }
            else {
                this._tx.pos = this._curve.getUniformPoint(1);
            }
        }
    }
    isComplete(entity) {
        return this._stopped || this._currentMs < 0;
    }
    reset() {
        this._currentMs = this._durationMs;
        this._started = false;
        this._stopped = false;
    }
    stop() {
        this._stopped = true;
        this._currentMs = 0;
    }
}


/***/ }),

/***/ "./Actions/Action/Delay.ts":
/*!*********************************!*\
  !*** ./Actions/Action/Delay.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Delay: () => (/* binding */ Delay)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");

class Delay {
    constructor(duration) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._elapsedTime = 0;
        this._started = false;
        this._stopped = false;
        this._delay = duration;
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
        }
        this._elapsedTime += elapsed;
    }
    isComplete() {
        return this._stopped || this._elapsedTime >= this._delay;
    }
    stop() {
        this._stopped = true;
    }
    reset() {
        this._elapsedTime = 0;
        this._started = false;
        this._stopped = false;
    }
}


/***/ }),

/***/ "./Actions/Action/Die.ts":
/*!*******************************!*\
  !*** ./Actions/Action/Die.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Die: () => (/* binding */ Die)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");
/* harmony import */ var _ActionsComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ActionsComponent */ "./Actions/ActionsComponent.ts");


class Die {
    constructor(entity) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._stopped = false;
        this._entity = entity;
    }
    update(elapsed) {
        this._entity.get(_ActionsComponent__WEBPACK_IMPORTED_MODULE_1__.ActionsComponent).clearActions();
        this._entity.kill();
        this._stopped = true;
    }
    isComplete() {
        return this._stopped;
    }
    stop() {
        return;
    }
    reset() {
        return;
    }
}


/***/ }),

/***/ "./Actions/Action/EaseBy.ts":
/*!**********************************!*\
  !*** ./Actions/Action/EaseBy.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EaseBy: () => (/* binding */ EaseBy)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");




/**
 * @deprecated use moveBy({offset: Vector, duration: number, easing: EasingFunction})
 */
class EaseBy {
    constructor(entity, offsetX, offsetY, duration, easingFcn) {
        this.easingFcn = easingFcn;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._currentLerpTime = 0;
        this._lerpDuration = 1 * 1000; // 1 second
        this._lerpStart = new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(0, 0);
        this._lerpEnd = new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(0, 0);
        this._initialized = false;
        this._stopped = false;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__.MotionComponent);
        this._lerpDuration = duration;
        this._offset = new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(offsetX, offsetY);
    }
    _initialize() {
        this._lerpStart = new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this._tx.pos.x, this._tx.pos.y);
        this._currentLerpTime = 0;
        this._lerpEnd = this._lerpStart.add(this._offset);
    }
    update(elapsed) {
        if (!this._initialized) {
            this._initialize();
            this._initialized = true;
        }
        // Need to update lerp time first, otherwise the first update will always be zero
        this._currentLerpTime += elapsed;
        let newX = this._tx.pos.x;
        let newY = this._tx.pos.y;
        if (this._currentLerpTime < this._lerpDuration) {
            if (this._lerpEnd.x < this._lerpStart.x) {
                newX =
                    this._lerpStart.x -
                        (this.easingFcn(this._currentLerpTime, this._lerpEnd.x, this._lerpStart.x, this._lerpDuration) - this._lerpEnd.x);
            }
            else {
                newX = this.easingFcn(this._currentLerpTime, this._lerpStart.x, this._lerpEnd.x, this._lerpDuration);
            }
            if (this._lerpEnd.y < this._lerpStart.y) {
                newY =
                    this._lerpStart.y -
                        (this.easingFcn(this._currentLerpTime, this._lerpEnd.y, this._lerpStart.y, this._lerpDuration) - this._lerpEnd.y);
            }
            else {
                newY = this.easingFcn(this._currentLerpTime, this._lerpStart.y, this._lerpEnd.y, this._lerpDuration);
            }
            // Given the lerp position figure out the velocity in pixels per second
            const seconds = elapsed / 1000;
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(seconds === 0 ? 0 : (newX - this._tx.pos.x) / seconds, seconds === 0 ? 0 : (newY - this._tx.pos.y) / seconds);
        }
        else {
            this._tx.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(this._lerpEnd.x, this._lerpEnd.y);
            this._motion.vel = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        }
    }
    isComplete() {
        return this._stopped || this._currentLerpTime >= this._lerpDuration;
    }
    reset() {
        this._initialized = false;
        this._stopped = false;
        this._currentLerpTime = 0;
    }
    stop() {
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(0, 0);
        this._stopped = true;
    }
}


/***/ }),

/***/ "./Actions/Action/EaseTo.ts":
/*!**********************************!*\
  !*** ./Actions/Action/EaseTo.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EaseTo: () => (/* binding */ EaseTo)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");




/**
 * @deprecated use moveTo({pos: Vector, duration: number, easing: EasingFunction})
 */
class EaseTo {
    constructor(entity, x, y, duration, easingFcn) {
        this.easingFcn = easingFcn;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._currentLerpTime = 0;
        this._lerpDuration = 1 * 1000; // 1 second
        this._lerpStart = new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(0, 0);
        this._lerpEnd = new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(0, 0);
        this._initialized = false;
        this._stopped = false;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__.MotionComponent);
        this._lerpDuration = duration;
        this._lerpEnd = new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(x, y);
    }
    _initialize() {
        this._lerpStart = new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this._tx.pos.x, this._tx.pos.y);
        this._currentLerpTime = 0;
    }
    update(elapsed) {
        if (!this._initialized) {
            this._initialize();
            this._initialized = true;
        }
        // Need to update lerp time first, otherwise the first update will always be zero
        this._currentLerpTime += elapsed;
        let newX = this._tx.pos.x;
        let newY = this._tx.pos.y;
        if (this._currentLerpTime < this._lerpDuration) {
            if (this._lerpEnd.x < this._lerpStart.x) {
                newX =
                    this._lerpStart.x -
                        (this.easingFcn(this._currentLerpTime, this._lerpEnd.x, this._lerpStart.x, this._lerpDuration) - this._lerpEnd.x);
            }
            else {
                newX = this.easingFcn(this._currentLerpTime, this._lerpStart.x, this._lerpEnd.x, this._lerpDuration);
            }
            if (this._lerpEnd.y < this._lerpStart.y) {
                newY =
                    this._lerpStart.y -
                        (this.easingFcn(this._currentLerpTime, this._lerpEnd.y, this._lerpStart.y, this._lerpDuration) - this._lerpEnd.y);
            }
            else {
                newY = this.easingFcn(this._currentLerpTime, this._lerpStart.y, this._lerpEnd.y, this._lerpDuration);
            }
            // Given the lerp position figure out the velocity in pixels per second
            const seconds = elapsed / 1000;
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(seconds === 0 ? 0 : (newX - this._tx.pos.x) / seconds, seconds === 0 ? 0 : (newY - this._tx.pos.y) / seconds);
        }
        else {
            this._tx.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(this._lerpEnd.x, this._lerpEnd.y);
            this._motion.vel = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        }
    }
    isComplete() {
        return this._stopped || this._currentLerpTime >= this._lerpDuration;
    }
    reset() {
        this._initialized = false;
        this._stopped = false;
        this._currentLerpTime = 0;
    }
    stop() {
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(0, 0);
        this._stopped = true;
    }
}


/***/ }),

/***/ "./Actions/Action/Fade.ts":
/*!********************************!*\
  !*** ./Actions/Action/Fade.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Fade: () => (/* binding */ Fade)
/* harmony export */ });
/* harmony import */ var _Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Graphics/GraphicsComponent */ "./Graphics/GraphicsComponent.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");



class Fade {
    constructor(entity, endOpacity, duration) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._multiplier = 1;
        this._started = false;
        this._stopped = false;
        this._graphics = entity.get(_Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_1__.GraphicsComponent);
        this._endOpacity = endOpacity;
        this._remainingTime = this._originalTime = duration;
    }
    update(elapsed) {
        if (!this._graphics) {
            return;
        }
        if (!this._started) {
            this._started = true;
            this._remainingTime = this._originalTime;
            // determine direction when we start
            if (this._endOpacity < this._graphics.opacity) {
                this._multiplier = -1;
            }
            else {
                this._multiplier = 1;
            }
        }
        if (this._remainingTime > 0) {
            this._graphics.opacity += (this._multiplier * (Math.abs(this._graphics.opacity - this._endOpacity) * elapsed)) / this._remainingTime;
        }
        this._remainingTime -= elapsed;
        if (this.isComplete()) {
            this._graphics.opacity = this._endOpacity;
        }
        _Util_Log__WEBPACK_IMPORTED_MODULE_2__.Logger.getInstance().debug('[Action fade] Actor opacity:', this._graphics.opacity);
    }
    isComplete() {
        return this._stopped || this._remainingTime <= 0;
    }
    stop() {
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
        this._remainingTime = this._originalTime;
    }
}


/***/ }),

/***/ "./Actions/Action/Flash.ts":
/*!*********************************!*\
  !*** ./Actions/Action/Flash.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Flash: () => (/* binding */ Flash)
/* harmony export */ });
/* harmony import */ var _Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Graphics/GraphicsComponent */ "./Graphics/GraphicsComponent.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");


class Flash {
    constructor(entity, color, duration = 1000) {
        var _a;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._stopped = false;
        this._started = false;
        this._total = 0;
        this._currentDuration = 0;
        this._graphics = entity.get(_Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_1__.GraphicsComponent);
        this._duration = duration;
        this._entity = entity;
        this._material = (_a = entity.scene) === null || _a === void 0 ? void 0 : _a.engine.graphicsContext.createMaterial({
            name: 'flash-material',
            color,
            fragmentSource: `#version 300 es
    
        precision mediump float;
        uniform float u_blend;
        uniform sampler2D u_graphic;
        uniform vec4 u_color;
    
        in vec2 v_uv; 
        out vec4 color;
    
        void main() { 
            vec4 textureColor = texture(u_graphic, v_uv); 
            color = mix(textureColor, u_color, u_blend * textureColor.a);
            color.rgb = color.rgb * color.a;
        }`
        });
        this._total = duration;
    }
    update(elapsed) {
        var _a;
        if (!this._started) {
            this._started = true;
            this._total = this._duration;
            this._currentDuration = this._duration;
            this._entity.graphics.material = this._material;
        }
        if (!this._graphics) {
            return;
        }
        this._currentDuration -= elapsed;
        if (this._graphics) {
            (_a = this._material) === null || _a === void 0 ? void 0 : _a.update((shader) => {
                shader.trySetUniformFloat('u_blend', this._currentDuration / this._total);
            });
        }
        if (this.isComplete()) {
            this._entity.graphics.material = null;
        }
    }
    isComplete() {
        return this._stopped || this._currentDuration <= 0;
    }
    stop() {
        if (this._graphics) {
            this._graphics.isVisible = true;
        }
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
    }
}


/***/ }),

/***/ "./Actions/Action/Follow.ts":
/*!**********************************!*\
  !*** ./Actions/Action/Follow.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Follow: () => (/* binding */ Follow)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");




class Follow {
    constructor(entity, entityToFollow, followDistance) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
        this._followTx = entityToFollow.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        this._followMotion = entityToFollow.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
        this._current = new _Math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector(this._tx.pos.x, this._tx.pos.y);
        this._end = new _Math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector(this._followTx.pos.x, this._followTx.pos.y);
        this._maximumDistance = followDistance !== undefined ? followDistance : this._current.distance(this._end);
        this._speed = 0;
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
            this._distanceBetween = this._current.distance(this._end);
            this._dir = this._end.sub(this._current).normalize();
        }
        const actorToFollowSpeed = Math.sqrt(Math.pow(this._followMotion.vel.x, 2) + Math.pow(this._followMotion.vel.y, 2));
        if (actorToFollowSpeed !== 0) {
            this._speed = actorToFollowSpeed;
        }
        this._current = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(this._tx.pos.x, this._tx.pos.y);
        this._end = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(this._followTx.pos.x, this._followTx.pos.y);
        this._distanceBetween = this._current.distance(this._end);
        this._dir = this._end.sub(this._current).normalize();
        if (this._distanceBetween >= this._maximumDistance) {
            const m = this._dir.scale(this._speed);
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(m.x, m.y);
        }
        else {
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(0, 0);
        }
        if (this.isComplete()) {
            this._tx.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(this._end.x, this._end.y);
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(0, 0);
        }
    }
    stop() {
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(0, 0);
        this._stopped = true;
    }
    isComplete() {
        // the actor following should never stop unless specified to do so
        return this._stopped;
    }
    reset() {
        this._started = false;
        this._stopped = false;
    }
}


/***/ }),

/***/ "./Actions/Action/Meet.ts":
/*!********************************!*\
  !*** ./Actions/Action/Meet.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Meet: () => (/* binding */ Meet)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");




class Meet {
    constructor(actor, actorToMeet, speed) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._speedWasSpecified = false;
        this._tx = actor.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        this._motion = actor.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
        this._meetTx = actorToMeet.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        this._meetMotion = actorToMeet.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
        this._current = new _Math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector(this._tx.pos.x, this._tx.pos.y);
        this._end = new _Math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector(this._meetTx.pos.x, this._meetTx.pos.y);
        this._speed = speed || 0;
        if (speed !== undefined) {
            this._speedWasSpecified = true;
        }
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
            this._distanceBetween = this._current.distance(this._end);
            this._dir = this._end.sub(this._current).normalize();
        }
        const actorToMeetSpeed = Math.sqrt(Math.pow(this._meetMotion.vel.x, 2) + Math.pow(this._meetMotion.vel.y, 2));
        if (actorToMeetSpeed !== 0 && !this._speedWasSpecified) {
            this._speed = actorToMeetSpeed;
        }
        this._current = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(this._tx.pos.x, this._tx.pos.y);
        this._end = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(this._meetTx.pos.x, this._meetTx.pos.y);
        this._distanceBetween = this._current.distance(this._end);
        this._dir = this._end.sub(this._current).normalize();
        const m = this._dir.scale(this._speed);
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(m.x, m.y);
        if (this.isComplete()) {
            this._tx.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(this._end.x, this._end.y);
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(0, 0);
        }
    }
    isComplete() {
        return this._stopped || this._distanceBetween <= 1;
    }
    stop() {
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(0, 0);
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
        this._distanceBetween = Infinity;
    }
}


/***/ }),

/***/ "./Actions/Action/MoveBy.ts":
/*!**********************************!*\
  !*** ./Actions/Action/MoveBy.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MoveBy: () => (/* binding */ MoveBy),
/* harmony export */   MoveByWithOptions: () => (/* binding */ MoveByWithOptions),
/* harmony export */   isMoveByOptions: () => (/* binding */ isMoveByOptions)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Math */ "./Math/util.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Math */ "./Math/lerp.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Util/EasingFunctions */ "./Util/EasingFunctions.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");







/**
 *
 */
function isMoveByOptions(x) {
    return x.offset instanceof _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector && typeof x.duration === 'number';
}
class MoveByWithOptions {
    constructor(entity, options) {
        var _a;
        this.entity = entity;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_1__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._easing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_2__.EasingFunctions.Linear;
        this._offset = options.offset;
        this._easing = (_a = options.easing) !== null && _a !== void 0 ? _a : this._easing;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_4__.MotionComponent);
        if (!this._tx) {
            throw new Error(`Entity ${entity.name} has no TransformComponent, can only MoveBy on Entities with TransformComponents.`);
        }
        this._durationMs = options.duration;
        this._currentMs = this._durationMs;
    }
    update(elapsed) {
        if (!this._started) {
            this._start = this._tx.pos.clone();
            this._end = this._start.add(this._offset);
            this._started = true;
        }
        this._currentMs -= elapsed;
        const t = (0,_Math__WEBPACK_IMPORTED_MODULE_5__.clamp)((0,_Math__WEBPACK_IMPORTED_MODULE_6__.remap)(0, this._durationMs, 0, 1, this._durationMs - this._currentMs), 0, 1);
        const currentPos = this._tx.pos;
        const newPosX = this._easing(t, this._start.x, this._end.x, 1);
        const newPosY = this._easing(t, this._start.y, this._end.y, 1);
        const seconds = elapsed / 1000;
        const velX = seconds === 0 ? 0 : (newPosX - currentPos.x) / seconds;
        const velY = seconds === 0 ? 0 : (newPosY - currentPos.y) / seconds;
        this._motion.vel.x = velX;
        this._motion.vel.y = velY;
        if (this.isComplete(this.entity)) {
            this._tx.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(this._end.x, this._end.y);
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        }
    }
    isComplete(entity) {
        return this._stopped || this._currentMs < 0;
    }
    stop() {
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        this._stopped = true;
        this._currentMs = 0;
    }
    reset() {
        this._currentMs = this._durationMs;
        this._started = false;
        this._stopped = false;
    }
}
class MoveBy {
    constructor(entity, offsetX, offsetY, speed) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_1__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._entity = entity;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_4__.MotionComponent);
        this._speed = speed;
        this._offset = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(offsetX, offsetY);
        if (speed <= 0) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_7__.Logger.getInstance().error('Attempted to moveBy with speed less than or equal to zero : ' + speed);
            throw new Error('Speed must be greater than 0 pixels per second');
        }
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
            this._start = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(this._tx.pos.x, this._tx.pos.y);
            this._end = this._start.add(this._offset);
            this._distance = this._offset.magnitude;
            this._dir = this._end.sub(this._start).normalize();
        }
        if (this.isComplete(this._entity)) {
            this._tx.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(this._end.x, this._end.y);
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        }
        else {
            this._motion.vel = this._dir.scale(this._speed);
        }
    }
    isComplete(entity) {
        const tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__.TransformComponent);
        return this._stopped || tx.pos.distance(this._start) >= this._distance;
    }
    stop() {
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
    }
}


/***/ }),

/***/ "./Actions/Action/MoveTo.ts":
/*!**********************************!*\
  !*** ./Actions/Action/MoveTo.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MoveTo: () => (/* binding */ MoveTo),
/* harmony export */   MoveToWithOptions: () => (/* binding */ MoveToWithOptions),
/* harmony export */   isMoveToOptions: () => (/* binding */ isMoveToOptions)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Math */ "./Math/util.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Math */ "./Math/lerp.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Util/EasingFunctions */ "./Util/EasingFunctions.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");






/**
 *
 */
function isMoveToOptions(x) {
    return x.pos instanceof _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector && typeof x.duration === 'number';
}
class MoveToWithOptions {
    constructor(entity, options) {
        var _a;
        this.entity = entity;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_1__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._easing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_2__.EasingFunctions.Linear;
        this._end = options.pos;
        this._easing = (_a = options.easing) !== null && _a !== void 0 ? _a : this._easing;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_4__.MotionComponent);
        if (!this._tx) {
            throw new Error(`Entity ${entity.name} has no TransformComponent, can only moveTo on Entities with TransformComponents.`);
        }
        this._durationMs = options.duration;
        this._currentMs = this._durationMs;
    }
    update(elapsed) {
        if (!this._started) {
            this._start = this._tx.pos.clone();
            this._started = true;
        }
        this._currentMs -= elapsed;
        const t = (0,_Math__WEBPACK_IMPORTED_MODULE_5__.clamp)((0,_Math__WEBPACK_IMPORTED_MODULE_6__.remap)(0, this._durationMs, 0, 1, this._durationMs - this._currentMs), 0, 1);
        const currentPos = this._tx.pos;
        const newPosX = this._easing(t, this._start.x, this._end.x, 1);
        const newPosY = this._easing(t, this._start.y, this._end.y, 1);
        const seconds = elapsed / 1000;
        const velX = seconds === 0 ? 0 : (newPosX - currentPos.x) / seconds;
        const velY = seconds === 0 ? 0 : (newPosY - currentPos.y) / seconds;
        this._motion.vel.x = velX;
        this._motion.vel.y = velY;
        if (this.isComplete(this.entity)) {
            this._tx.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(this._end.x, this._end.y);
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        }
    }
    isComplete(entity) {
        return this._stopped || this._currentMs < 0;
    }
    stop() {
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        this._stopped = true;
        this._currentMs = 0;
    }
    reset() {
        this._currentMs = this._durationMs;
        this._started = false;
        this._stopped = false;
    }
}
class MoveTo {
    constructor(entity, destX, destY, speed) {
        this.entity = entity;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_1__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_4__.MotionComponent);
        this._end = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(destX, destY);
        this._speed = speed;
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
            this._start = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(this._tx.pos.x, this._tx.pos.y);
            this._distance = this._start.distance(this._end);
            this._dir = this._end.sub(this._start).normalize();
        }
        const m = this._dir.scale(this._speed);
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(m.x, m.y);
        if (this.isComplete(this.entity)) {
            this._tx.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(this._end.x, this._end.y);
            this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        }
    }
    isComplete(entity) {
        const tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__.TransformComponent);
        return this._stopped || new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(tx.pos.x, tx.pos.y).distance(this._start) >= this._distance;
    }
    stop() {
        this._motion.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
    }
}


/***/ }),

/***/ "./Actions/Action/ParallelActions.ts":
/*!*******************************************!*\
  !*** ./Actions/Action/ParallelActions.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ParallelActions: () => (/* binding */ ParallelActions)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");

/**
 * Action that can run multiple {@apilink Action}s or {@apilink ActionSequence}s at the same time
 */
class ParallelActions {
    constructor(parallelActions) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._actions = parallelActions;
    }
    update(elapsed) {
        for (let i = 0; i < this._actions.length; i++) {
            this._actions[i].update(elapsed);
        }
    }
    isComplete(entity) {
        return this._actions.every((a) => a.isComplete(entity));
    }
    reset() {
        this._actions.forEach((a) => a.reset());
    }
    stop() {
        this._actions.forEach((a) => a.stop());
    }
}


/***/ }),

/***/ "./Actions/Action/Repeat.ts":
/*!**********************************!*\
  !*** ./Actions/Action/Repeat.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Repeat: () => (/* binding */ Repeat)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");
/* harmony import */ var _ActionContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ActionContext */ "./Actions/ActionContext.ts");


class Repeat {
    constructor(entity, repeatBuilder, repeat) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._stopped = false;
        this._repeatBuilder = repeatBuilder;
        this._repeatContext = new _ActionContext__WEBPACK_IMPORTED_MODULE_1__.ActionContext(entity);
        this._actionQueue = this._repeatContext.getQueue();
        this._repeat = repeat;
        this._originalRepeat = repeat;
        this._repeatBuilder(this._repeatContext);
        this._repeat--; // current execution is the first repeat
    }
    update(elapsed) {
        if (this._actionQueue.isComplete()) {
            this._actionQueue.clearActions();
            this._repeatBuilder(this._repeatContext);
            this._repeat--;
        }
        this._actionQueue.update(elapsed);
    }
    isComplete() {
        return this._stopped || (this._repeat <= 0 && this._actionQueue.isComplete());
    }
    stop() {
        this._stopped = true;
    }
    reset() {
        this._repeat = this._originalRepeat;
    }
}


/***/ }),

/***/ "./Actions/Action/RepeatForever.ts":
/*!*****************************************!*\
  !*** ./Actions/Action/RepeatForever.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RepeatForever: () => (/* binding */ RepeatForever)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");
/* harmony import */ var _ActionContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ActionContext */ "./Actions/ActionContext.ts");


/**
 * RepeatForever Action implementation, it is recommended you use the fluent action
 * context API.
 *
 *
 */
class RepeatForever {
    constructor(entity, repeatBuilder) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._stopped = false;
        this._repeatBuilder = repeatBuilder;
        this._repeatContext = new _ActionContext__WEBPACK_IMPORTED_MODULE_1__.ActionContext(entity);
        this._actionQueue = this._repeatContext.getQueue();
        this._repeatBuilder(this._repeatContext);
    }
    update(elapsed) {
        if (this._stopped) {
            return;
        }
        if (this._actionQueue.isComplete()) {
            this._actionQueue.clearActions();
            this._repeatBuilder(this._repeatContext);
        }
        this._actionQueue.update(elapsed);
    }
    isComplete() {
        return this._stopped;
    }
    stop() {
        this._stopped = true;
        this._actionQueue.clearActions();
    }
    reset() {
        return;
    }
}


/***/ }),

/***/ "./Actions/Action/RotateBy.ts":
/*!************************************!*\
  !*** ./Actions/Action/RotateBy.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RotateBy: () => (/* binding */ RotateBy),
/* harmony export */   RotateByWithOptions: () => (/* binding */ RotateByWithOptions),
/* harmony export */   isRotateByOptions: () => (/* binding */ isRotateByOptions)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Math/util */ "./Math/util.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math */ "./Math/rotation-type.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Math */ "./Math/lerp.ts");





/**
 *
 */
function isRotateByOptions(x) {
    return typeof x.angleRadiansOffset === 'number' && typeof x.duration === 'number';
}
class RotateByWithOptions {
    constructor(entity, options) {
        var _a;
        this.entity = entity;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._offset = 0;
        this._startAngle = 0;
        this._endAngle = 0;
        this._offset = options.angleRadiansOffset;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
        if (!this._tx) {
            throw new Error(`Entity ${entity.name} has no TransformComponent, can only RotateBy on Entities with TransformComponents.`);
        }
        this._durationMs = options.duration;
        this._rotationType = (_a = options.rotationType) !== null && _a !== void 0 ? _a : _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.ShortestPath;
        this._currentMs = this._durationMs;
    }
    update(elapsed) {
        if (!this._started) {
            this._startAngle = this._tx.rotation;
            this._endAngle = (0,_Math_util__WEBPACK_IMPORTED_MODULE_4__.canonicalizeAngle)(this._startAngle + this._offset);
            this._started = true;
        }
        this._currentMs -= elapsed;
        const t = (0,_Math_util__WEBPACK_IMPORTED_MODULE_4__.clamp)((0,_Math__WEBPACK_IMPORTED_MODULE_5__.remap)(0, this._durationMs, 0, 1, this._durationMs - this._currentMs), 0, 1);
        const newAngle = (0,_Math__WEBPACK_IMPORTED_MODULE_5__.lerpAngle)(this._startAngle, this._endAngle, this._rotationType, t);
        const currentAngle = this._tx.rotation;
        const seconds = elapsed / 1000;
        const rx = seconds === 0 ? 0 : (newAngle - currentAngle) / seconds;
        this._motion.angularVelocity = rx;
        if (this.isComplete()) {
            this._tx.rotation = this._endAngle;
            this._motion.angularVelocity = 0;
        }
    }
    isComplete() {
        return this._stopped || this._currentMs < 0;
    }
    stop() {
        this._motion.angularVelocity = 0;
        this._stopped = true;
        this._currentMs = 0;
    }
    reset() {
        this._currentMs = this._durationMs;
        this._started = false;
        this._stopped = false;
    }
}
class RotateBy {
    constructor(entity, angleRadiansOffset, speed, rotationType) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
        this._speed = speed;
        this._offset = angleRadiansOffset;
        this._rotationType = rotationType || _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.ShortestPath;
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
            this._start = this._tx.rotation;
            this._currentNonCannonAngle = this._tx.rotation;
            this._end = this._start + this._offset;
            const distance1 = Math.abs(this._end - this._start);
            const distance2 = _Math_util__WEBPACK_IMPORTED_MODULE_4__.TwoPI - distance1;
            if (distance1 > distance2) {
                this._shortDistance = distance2;
                this._longDistance = distance1;
            }
            else {
                this._shortDistance = distance1;
                this._longDistance = distance2;
            }
            this._shortestPathIsPositive = (this._start - this._end + _Math_util__WEBPACK_IMPORTED_MODULE_4__.TwoPI) % _Math_util__WEBPACK_IMPORTED_MODULE_4__.TwoPI >= Math.PI;
            switch (this._rotationType) {
                case _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.ShortestPath:
                    this._distance = this._shortDistance;
                    if (this._shortestPathIsPositive) {
                        this._direction = 1;
                    }
                    else {
                        this._direction = -1;
                    }
                    break;
                case _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.LongestPath:
                    this._distance = this._longDistance;
                    if (this._shortestPathIsPositive) {
                        this._direction = -1;
                    }
                    else {
                        this._direction = 1;
                    }
                    break;
                case _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.Clockwise:
                    this._direction = 1;
                    if (this._shortDistance >= 0) {
                        this._distance = this._shortDistance;
                    }
                    else {
                        this._distance = this._longDistance;
                    }
                    break;
                case _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.CounterClockwise:
                    this._direction = -1;
                    if (this._shortDistance <= 0) {
                        this._distance = this._shortDistance;
                    }
                    else {
                        this._distance = this._longDistance;
                    }
                    break;
            }
        }
        this._motion.angularVelocity = this._direction * this._speed;
        this._currentNonCannonAngle += this._direction * this._speed * (elapsed / 1000);
        if (this.isComplete()) {
            this._tx.rotation = this._end;
            this._motion.angularVelocity = 0;
            this._stopped = true;
        }
    }
    isComplete() {
        const distanceTraveled = Math.abs(this._currentNonCannonAngle - this._start);
        return this._stopped || distanceTraveled >= Math.abs(this._distance);
    }
    stop() {
        this._motion.angularVelocity = 0;
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
        this._start = undefined;
        this._currentNonCannonAngle = undefined;
        this._distance = undefined;
    }
}


/***/ }),

/***/ "./Actions/Action/RotateTo.ts":
/*!************************************!*\
  !*** ./Actions/Action/RotateTo.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RotateTo: () => (/* binding */ RotateTo),
/* harmony export */   RotateToWithOptions: () => (/* binding */ RotateToWithOptions),
/* harmony export */   isRotateToOptions: () => (/* binding */ isRotateToOptions)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math */ "./Math/rotation-type.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Math/util */ "./Math/util.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Math */ "./Math/lerp.ts");






/**
 *
 */
function isRotateToOptions(x) {
    return typeof x.angle === 'number' && typeof x.duration === 'number';
}
class RotateToWithOptions {
    constructor(entity, options) {
        var _a;
        this.entity = entity;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._endAngle = 0;
        this._startAngle = 0;
        this._endAngle = options.angle;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
        if (!this._tx) {
            throw new Error(`Entity ${entity.name} has no TransformComponent, can only RotateTo on Entities with TransformComponents.`);
        }
        this._durationMs = options.duration;
        this._rotationType = (_a = options.rotationType) !== null && _a !== void 0 ? _a : _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.ShortestPath;
        this._currentMs = this._durationMs;
    }
    update(elapsed) {
        if (!this._started) {
            this._startAngle = this._tx.rotation;
            this._started = true;
        }
        this._currentMs -= elapsed;
        const t = (0,_Math_util__WEBPACK_IMPORTED_MODULE_4__.clamp)((0,_Math__WEBPACK_IMPORTED_MODULE_5__.remap)(0, this._durationMs, 0, 1, this._durationMs - this._currentMs), 0, 1);
        const newAngle = (0,_Math__WEBPACK_IMPORTED_MODULE_5__.lerpAngle)(this._startAngle, this._endAngle, this._rotationType, t);
        const currentAngle = this._tx.rotation;
        const seconds = elapsed / 1000;
        const rx = seconds === 0 ? 0 : (newAngle - currentAngle) / seconds;
        this._motion.angularVelocity = rx;
        if (this.isComplete(this.entity)) {
            this._tx.rotation = this._endAngle;
            this._motion.angularVelocity = 0;
        }
    }
    isComplete(entity) {
        return this._stopped || this._currentMs < 0;
    }
    stop() {
        this._motion.angularVelocity = 0;
        this._stopped = true;
        this._currentMs = 0;
    }
    reset() {
        this._currentMs = this._durationMs;
        this._started = false;
        this._stopped = false;
    }
}
class RotateTo {
    constructor(entity, angle, speed, rotationType) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
        this._end = angle;
        this._speed = speed;
        this._rotationType = rotationType || _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.ShortestPath;
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
            this._start = this._tx.rotation;
            this._currentNonCannonAngle = this._tx.rotation;
            const distance1 = Math.abs(this._end - this._start);
            const distance2 = _Math_util__WEBPACK_IMPORTED_MODULE_4__.TwoPI - distance1;
            if (distance1 > distance2) {
                this._shortDistance = distance2;
                this._longDistance = distance1;
            }
            else {
                this._shortDistance = distance1;
                this._longDistance = distance2;
            }
            this._shortestPathIsPositive = (this._start - this._end + _Math_util__WEBPACK_IMPORTED_MODULE_4__.TwoPI) % _Math_util__WEBPACK_IMPORTED_MODULE_4__.TwoPI >= Math.PI;
            switch (this._rotationType) {
                case _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.ShortestPath:
                    this._distance = this._shortDistance;
                    if (this._shortestPathIsPositive) {
                        this._direction = 1;
                    }
                    else {
                        this._direction = -1;
                    }
                    break;
                case _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.LongestPath:
                    this._distance = this._longDistance;
                    if (this._shortestPathIsPositive) {
                        this._direction = -1;
                    }
                    else {
                        this._direction = 1;
                    }
                    break;
                case _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.Clockwise:
                    this._direction = 1;
                    if (this._shortestPathIsPositive) {
                        this._distance = this._shortDistance;
                    }
                    else {
                        this._distance = this._longDistance;
                    }
                    break;
                case _Math__WEBPACK_IMPORTED_MODULE_3__.RotationType.CounterClockwise:
                    this._direction = -1;
                    if (!this._shortestPathIsPositive) {
                        this._distance = this._shortDistance;
                    }
                    else {
                        this._distance = this._longDistance;
                    }
                    break;
            }
        }
        this._motion.angularVelocity = this._direction * this._speed;
        this._currentNonCannonAngle += this._direction * this._speed * (elapsed / 1000);
        if (this.isComplete()) {
            this._tx.rotation = this._end;
            this._motion.angularVelocity = 0;
            this._stopped = true;
        }
    }
    isComplete() {
        const distanceTraveled = Math.abs(this._currentNonCannonAngle - this._start);
        return this._stopped || distanceTraveled >= Math.abs(this._distance);
    }
    stop() {
        this._motion.angularVelocity = 0;
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
    }
}


/***/ }),

/***/ "./Actions/Action/ScaleBy.ts":
/*!***********************************!*\
  !*** ./Actions/Action/ScaleBy.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ScaleBy: () => (/* binding */ ScaleBy),
/* harmony export */   ScaleByWithOptions: () => (/* binding */ ScaleByWithOptions),
/* harmony export */   isScaleByOptions: () => (/* binding */ isScaleByOptions)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Math */ "./Math/util.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Math */ "./Math/lerp.ts");





/**
 *
 */
function isScaleByOptions(x) {
    return typeof x.scaleOffset === 'object' && typeof x.duration === 'number';
}
class ScaleByWithOptions {
    constructor(entity, options) {
        this.entity = entity;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._endScale = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(1, 1);
        this._scaleOffset = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(0, 0);
        this._startScale = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(1, 1);
        this._scaleOffset = options.scaleOffset;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__.MotionComponent);
        if (!this._tx) {
            throw new Error(`Entity ${entity.name} has no TransformComponent, can only ScaleBy on Entities with TransformComponents.`);
        }
        this._durationMs = options.duration;
        this._currentMs = this._durationMs;
    }
    update(elapsed) {
        if (!this._started) {
            this._startScale = this._tx.scale;
            this._endScale = this._startScale.add(this._scaleOffset);
            this._started = true;
        }
        this._currentMs -= elapsed;
        const t = (0,_Math__WEBPACK_IMPORTED_MODULE_4__.clamp)((0,_Math__WEBPACK_IMPORTED_MODULE_5__.remap)(0, this._durationMs, 0, 1, this._durationMs - this._currentMs), 0, 1);
        const newScale = (0,_Math__WEBPACK_IMPORTED_MODULE_5__.lerpVector)(this._startScale, this._endScale, t);
        const currentScale = this._tx.scale;
        const seconds = elapsed / 1000;
        const sx = newScale.sub(currentScale).scale(seconds === 0 ? 0 : 1 / seconds);
        this._motion.scaleFactor = sx;
        if (this.isComplete()) {
            this._tx.scale = this._endScale;
            this._motion.angularVelocity = 0;
        }
    }
    isComplete() {
        return this._stopped || this._currentMs < 0;
    }
    stop() {
        this._motion.scaleFactor = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        this._stopped = true;
        this._currentMs = 0;
    }
    reset() {
        this._currentMs = this._durationMs;
        this._started = false;
        this._stopped = false;
    }
}
class ScaleBy {
    constructor(entity, scaleOffsetX, scaleOffsetY, speed) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__.MotionComponent);
        this._offset = new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(scaleOffsetX, scaleOffsetY);
        this._speedX = this._speedY = speed;
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
            this._startScale = this._tx.scale.clone();
            this._endScale = this._startScale.add(this._offset);
            this._distanceX = Math.abs(this._endScale.x - this._startScale.x);
            this._distanceY = Math.abs(this._endScale.y - this._startScale.y);
            this._directionX = this._endScale.x < this._startScale.x ? -1 : 1;
            this._directionY = this._endScale.y < this._startScale.y ? -1 : 1;
        }
        this._motion.scaleFactor.x = this._speedX * this._directionX;
        this._motion.scaleFactor.y = this._speedY * this._directionY;
        if (this.isComplete()) {
            this._tx.scale = this._endScale;
            this._motion.scaleFactor.x = 0;
            this._motion.scaleFactor.y = 0;
        }
    }
    isComplete() {
        return (this._stopped ||
            (Math.abs(this._tx.scale.x - this._startScale.x) >= this._distanceX - 0.01 &&
                Math.abs(this._tx.scale.y - this._startScale.y) >= this._distanceY - 0.01));
    }
    stop() {
        this._motion.scaleFactor.x = 0;
        this._motion.scaleFactor.y = 0;
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
    }
}


/***/ }),

/***/ "./Actions/Action/ScaleTo.ts":
/*!***********************************!*\
  !*** ./Actions/Action/ScaleTo.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ScaleTo: () => (/* binding */ ScaleTo),
/* harmony export */   ScaleToWithOptions: () => (/* binding */ ScaleToWithOptions),
/* harmony export */   isScaleToOptions: () => (/* binding */ isScaleToOptions)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Action */ "./Actions/Action.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Math */ "./Math/util.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Math */ "./Math/lerp.ts");





/**
 *
 */
function isScaleToOptions(x) {
    return typeof x.scale === 'object' && typeof x.duration === 'number';
}
class ScaleToWithOptions {
    constructor(entity, options) {
        this.entity = entity;
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._endScale = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(1, 1);
        this._startScale = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(1, 1);
        this._endScale = options.scale;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__.MotionComponent);
        if (!this._tx) {
            throw new Error(`Entity ${entity.name} has no TransformComponent, can only ScaleTo on Entities with TransformComponents.`);
        }
        this._durationMs = options.duration;
        this._currentMs = this._durationMs;
    }
    update(elapsed) {
        if (!this._started) {
            this._startScale = this._tx.scale;
            this._started = true;
        }
        this._currentMs -= elapsed;
        const t = (0,_Math__WEBPACK_IMPORTED_MODULE_4__.clamp)((0,_Math__WEBPACK_IMPORTED_MODULE_5__.remap)(0, this._durationMs, 0, 1, this._durationMs - this._currentMs), 0, 1);
        const newScale = (0,_Math__WEBPACK_IMPORTED_MODULE_5__.lerpVector)(this._startScale, this._endScale, t);
        const currentScale = this._tx.scale;
        const seconds = elapsed / 1000;
        const sx = newScale.sub(currentScale).scale(seconds === 0 ? 0 : 1 / seconds);
        this._motion.scaleFactor = sx;
        if (this.isComplete()) {
            this._tx.scale = this._endScale;
            this._motion.angularVelocity = 0;
        }
    }
    isComplete() {
        return this._stopped || this._currentMs < 0;
    }
    stop() {
        this._motion.scaleFactor = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        this._stopped = true;
        this._currentMs = 0;
    }
    reset() {
        this._currentMs = this._durationMs;
        this._started = false;
        this._stopped = false;
    }
}
class ScaleTo {
    constructor(entity, scaleX, scaleY, speedX, speedY) {
        this.id = (0,_Action__WEBPACK_IMPORTED_MODULE_0__.nextActionId)();
        this._started = false;
        this._stopped = false;
        this._tx = entity.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_2__.TransformComponent);
        this._motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_3__.MotionComponent);
        this._endX = scaleX;
        this._endY = scaleY;
        this._speedX = speedX;
        this._speedY = speedY;
    }
    update(elapsed) {
        if (!this._started) {
            this._started = true;
            this._startX = this._tx.scale.x;
            this._startY = this._tx.scale.y;
            this._distanceX = Math.abs(this._endX - this._startX);
            this._distanceY = Math.abs(this._endY - this._startY);
        }
        if (!(Math.abs(this._tx.scale.x - this._startX) >= this._distanceX)) {
            const directionX = this._endY < this._startY ? -1 : 1;
            this._motion.scaleFactor.x = this._speedX * directionX;
        }
        else {
            this._motion.scaleFactor.x = 0;
        }
        if (!(Math.abs(this._tx.scale.y - this._startY) >= this._distanceY)) {
            const directionY = this._endY < this._startY ? -1 : 1;
            this._motion.scaleFactor.y = this._speedY * directionY;
        }
        else {
            this._motion.scaleFactor.y = 0;
        }
        if (this.isComplete()) {
            this._tx.scale = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(this._endX, this._endY);
            this._motion.scaleFactor.x = 0;
            this._motion.scaleFactor.y = 0;
        }
    }
    isComplete() {
        return (this._stopped ||
            (Math.abs(this._tx.scale.x - this._startX) >= this._distanceX - 0.01 &&
                Math.abs(this._tx.scale.y - this._startY) >= this._distanceY - 0.01));
    }
    stop() {
        this._motion.scaleFactor.x = 0;
        this._motion.scaleFactor.y = 0;
        this._stopped = true;
    }
    reset() {
        this._started = false;
        this._stopped = false;
    }
}


/***/ }),

/***/ "./Actions/ActionContext.ts":
/*!**********************************!*\
  !*** ./Actions/ActionContext.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionContext: () => (/* binding */ ActionContext)
/* harmony export */ });
/* harmony import */ var _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Util/EasingFunctions */ "./Util/EasingFunctions.ts");
/* harmony import */ var _ActionQueue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ActionQueue */ "./Actions/ActionQueue.ts");
/* harmony import */ var _Action_Repeat__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Action/Repeat */ "./Actions/Action/Repeat.ts");
/* harmony import */ var _Action_RepeatForever__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Action/RepeatForever */ "./Actions/Action/RepeatForever.ts");
/* harmony import */ var _Action_MoveBy__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Action/MoveBy */ "./Actions/Action/MoveBy.ts");
/* harmony import */ var _Action_MoveTo__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Action/MoveTo */ "./Actions/Action/MoveTo.ts");
/* harmony import */ var _Action_RotateTo__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Action/RotateTo */ "./Actions/Action/RotateTo.ts");
/* harmony import */ var _Action_RotateBy__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Action/RotateBy */ "./Actions/Action/RotateBy.ts");
/* harmony import */ var _Action_ScaleTo__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Action/ScaleTo */ "./Actions/Action/ScaleTo.ts");
/* harmony import */ var _Action_ScaleBy__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Action/ScaleBy */ "./Actions/Action/ScaleBy.ts");
/* harmony import */ var _Action_CallMethod__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Action/CallMethod */ "./Actions/Action/CallMethod.ts");
/* harmony import */ var _Action_EaseTo__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Action/EaseTo */ "./Actions/Action/EaseTo.ts");
/* harmony import */ var _Action_EaseBy__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Action/EaseBy */ "./Actions/Action/EaseBy.ts");
/* harmony import */ var _Action_Blink__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Action/Blink */ "./Actions/Action/Blink.ts");
/* harmony import */ var _Action_Fade__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Action/Fade */ "./Actions/Action/Fade.ts");
/* harmony import */ var _Action_Delay__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Action/Delay */ "./Actions/Action/Delay.ts");
/* harmony import */ var _Action_Die__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Action/Die */ "./Actions/Action/Die.ts");
/* harmony import */ var _Action_Follow__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Action/Follow */ "./Actions/Action/Follow.ts");
/* harmony import */ var _Action_Meet__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Action/Meet */ "./Actions/Action/Meet.ts");
/* harmony import */ var _Math__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Math */ "./Math/vector.ts");
/* harmony import */ var _Action_Flash__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Action/Flash */ "./Actions/Action/Flash.ts");
/* harmony import */ var _Action_CurveTo__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Action/CurveTo */ "./Actions/Action/CurveTo.ts");
/* harmony import */ var _Action_CurveBy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Action/CurveBy */ "./Actions/Action/CurveBy.ts");























/**
 * The fluent Action API allows you to perform "actions" on
 * {@apilink Actor | `actors`} such as following, moving, rotating, and
 * more. You can implement your own actions by implementing
 * the {@apilink Action} interface.
 */
class ActionContext {
    constructor(entity) {
        this._entity = entity;
        this._queue = new _ActionQueue__WEBPACK_IMPORTED_MODULE_0__.ActionQueue(entity);
    }
    getQueue() {
        return this._queue;
    }
    update(elapsed) {
        this._queue.update(elapsed);
    }
    /**
     * Clears all queued actions from the Actor
     */
    clearActions() {
        this._queue.clearActions();
    }
    runAction(action) {
        action.reset();
        this._queue.add(action);
        return this;
    }
    /**
     * Animates an actor with a specified bezier curve by an offset to the current position, the start point is assumed
     * to be the actors current position
     * @param options
     */
    curveBy(options) {
        this._queue.add(new _Action_CurveBy__WEBPACK_IMPORTED_MODULE_1__.CurveBy(this._entity, options));
        return this;
    }
    /**
     * Animates an actor with a specified bezier curve to an absolute world space coordinate, the start point is assumed
     * to be the actors current position
     * @param options
     */
    curveTo(options) {
        this._queue.add(new _Action_CurveTo__WEBPACK_IMPORTED_MODULE_2__.CurveTo(this._entity, options));
        return this;
    }
    easeTo(...args) {
        var _a, _b;
        let x = 0;
        let y = 0;
        let duration = 0;
        let easingFcn = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_3__.EasingFunctions.Linear;
        if (args[0] instanceof _Math__WEBPACK_IMPORTED_MODULE_4__.Vector) {
            x = args[0].x;
            y = args[0].y;
            duration = args[1];
            easingFcn = (_a = args[2]) !== null && _a !== void 0 ? _a : easingFcn;
        }
        else {
            x = args[0];
            y = args[1];
            duration = args[2];
            easingFcn = (_b = args[3]) !== null && _b !== void 0 ? _b : easingFcn;
        }
        this._queue.add(new _Action_EaseTo__WEBPACK_IMPORTED_MODULE_5__.EaseTo(this._entity, x, y, duration, easingFcn));
        return this;
    }
    easeBy(...args) {
        var _a, _b;
        let offsetX = 0;
        let offsetY = 0;
        let duration = 0;
        let easingFcn = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_3__.EasingFunctions.Linear;
        if (args[0] instanceof _Math__WEBPACK_IMPORTED_MODULE_4__.Vector) {
            offsetX = args[0].x;
            offsetY = args[0].y;
            duration = args[1];
            easingFcn = (_a = args[2]) !== null && _a !== void 0 ? _a : easingFcn;
        }
        else {
            offsetX = args[0];
            offsetY = args[1];
            duration = args[2];
            easingFcn = (_b = args[3]) !== null && _b !== void 0 ? _b : easingFcn;
        }
        this._queue.add(new _Action_EaseBy__WEBPACK_IMPORTED_MODULE_6__.EaseBy(this._entity, offsetX, offsetY, duration, easingFcn));
        return this;
    }
    moveTo(xOrPosOrOptions, yOrSpeed, speedOrUndefined) {
        let x = 0;
        let y = 0;
        let speed = 0;
        if (xOrPosOrOptions instanceof _Math__WEBPACK_IMPORTED_MODULE_4__.Vector) {
            x = xOrPosOrOptions.x;
            y = xOrPosOrOptions.y;
            speed = +(yOrSpeed !== null && yOrSpeed !== void 0 ? yOrSpeed : 0);
            this._queue.add(new _Action_MoveTo__WEBPACK_IMPORTED_MODULE_7__.MoveTo(this._entity, x, y, speed));
        }
        else if (typeof xOrPosOrOptions === 'number' && typeof yOrSpeed === 'number' && typeof speedOrUndefined === 'number') {
            x = xOrPosOrOptions;
            y = yOrSpeed;
            speed = speedOrUndefined;
            this._queue.add(new _Action_MoveTo__WEBPACK_IMPORTED_MODULE_7__.MoveTo(this._entity, x, y, speed));
        }
        else if ((0,_Action_MoveTo__WEBPACK_IMPORTED_MODULE_7__.isMoveToOptions)(xOrPosOrOptions)) {
            this._queue.add(new _Action_MoveTo__WEBPACK_IMPORTED_MODULE_7__.MoveToWithOptions(this._entity, xOrPosOrOptions));
        }
        return this;
    }
    moveBy(xOffsetOrVectorOrOptions, yOffsetOrSpeed, speedOrUndefined) {
        let xOffset = 0;
        let yOffset = 0;
        let speed = 0;
        if (xOffsetOrVectorOrOptions instanceof _Math__WEBPACK_IMPORTED_MODULE_4__.Vector && typeof yOffsetOrSpeed === 'number') {
            xOffset = xOffsetOrVectorOrOptions.x;
            yOffset = xOffsetOrVectorOrOptions.y;
            speed = yOffsetOrSpeed;
            this._queue.add(new _Action_MoveBy__WEBPACK_IMPORTED_MODULE_8__.MoveBy(this._entity, xOffset, yOffset, speed));
        }
        else if (typeof xOffsetOrVectorOrOptions === 'number' && typeof yOffsetOrSpeed === 'number' && typeof speedOrUndefined === 'number') {
            xOffset = xOffsetOrVectorOrOptions;
            yOffset = yOffsetOrSpeed;
            speed = speedOrUndefined;
            this._queue.add(new _Action_MoveBy__WEBPACK_IMPORTED_MODULE_8__.MoveBy(this._entity, xOffset, yOffset, speed));
        }
        else if ((0,_Action_MoveBy__WEBPACK_IMPORTED_MODULE_8__.isMoveByOptions)(xOffsetOrVectorOrOptions)) {
            this._queue.add(new _Action_MoveBy__WEBPACK_IMPORTED_MODULE_8__.MoveByWithOptions(this._entity, xOffsetOrVectorOrOptions));
        }
        return this;
    }
    rotateTo(angleRadiansOrOptions, speed, rotationType) {
        if (typeof angleRadiansOrOptions === 'number' && typeof speed === 'number') {
            this._queue.add(new _Action_RotateTo__WEBPACK_IMPORTED_MODULE_9__.RotateTo(this._entity, angleRadiansOrOptions, speed, rotationType));
        }
        else if (typeof angleRadiansOrOptions === 'object') {
            this._queue.add(new _Action_RotateTo__WEBPACK_IMPORTED_MODULE_9__.RotateToWithOptions(this._entity, angleRadiansOrOptions));
        }
        return this;
    }
    rotateBy(angleRadiansOffsetOrOptions, speed, rotationType) {
        if (typeof angleRadiansOffsetOrOptions === 'object') {
            this._queue.add(new _Action_RotateBy__WEBPACK_IMPORTED_MODULE_10__.RotateByWithOptions(this._entity, angleRadiansOffsetOrOptions));
        }
        else {
            this._queue.add(new _Action_RotateBy__WEBPACK_IMPORTED_MODULE_10__.RotateBy(this._entity, angleRadiansOffsetOrOptions, speed, rotationType));
        }
        return this;
    }
    scaleTo(sizeXOrVectorOrOptions, sizeYOrSpeed, speedXOrUndefined, speedYOrUndefined) {
        let sizeX = 1;
        let sizeY = 1;
        let speedX = 0;
        let speedY = 0;
        if ((0,_Action_ScaleTo__WEBPACK_IMPORTED_MODULE_11__.isScaleToOptions)(sizeXOrVectorOrOptions)) {
            this._queue.add(new _Action_ScaleTo__WEBPACK_IMPORTED_MODULE_11__.ScaleToWithOptions(this._entity, sizeXOrVectorOrOptions));
            return this;
        }
        if (sizeXOrVectorOrOptions instanceof _Math__WEBPACK_IMPORTED_MODULE_4__.Vector && sizeYOrSpeed instanceof _Math__WEBPACK_IMPORTED_MODULE_4__.Vector) {
            sizeX = sizeXOrVectorOrOptions.x;
            sizeY = sizeXOrVectorOrOptions.y;
            speedX = sizeYOrSpeed.x;
            speedY = sizeYOrSpeed.y;
        }
        if (typeof sizeXOrVectorOrOptions === 'number' && typeof sizeYOrSpeed === 'number') {
            sizeX = sizeXOrVectorOrOptions;
            sizeY = sizeYOrSpeed;
            speedX = speedXOrUndefined;
            speedY = speedYOrUndefined;
        }
        this._queue.add(new _Action_ScaleTo__WEBPACK_IMPORTED_MODULE_11__.ScaleTo(this._entity, sizeX, sizeY, speedX, speedY));
        return this;
    }
    scaleBy(sizeOffsetXOrVectorOrOptions, sizeOffsetYOrSpeed, speed) {
        if ((0,_Action_ScaleBy__WEBPACK_IMPORTED_MODULE_12__.isScaleByOptions)(sizeOffsetXOrVectorOrOptions)) {
            this._queue.add(new _Action_ScaleBy__WEBPACK_IMPORTED_MODULE_12__.ScaleByWithOptions(this._entity, sizeOffsetXOrVectorOrOptions));
            return this;
        }
        let sizeOffsetX = 1;
        let sizeOffsetY = 1;
        if (sizeOffsetXOrVectorOrOptions instanceof _Math__WEBPACK_IMPORTED_MODULE_4__.Vector) {
            sizeOffsetX = sizeOffsetXOrVectorOrOptions.x;
            sizeOffsetY = sizeOffsetXOrVectorOrOptions.y;
            speed = sizeOffsetYOrSpeed;
        }
        if (typeof sizeOffsetXOrVectorOrOptions === 'number' && typeof sizeOffsetYOrSpeed === 'number') {
            sizeOffsetX = sizeOffsetXOrVectorOrOptions;
            sizeOffsetY = sizeOffsetYOrSpeed;
        }
        this._queue.add(new _Action_ScaleBy__WEBPACK_IMPORTED_MODULE_12__.ScaleBy(this._entity, sizeOffsetX, sizeOffsetY, speed));
        return this;
    }
    /**
     * This method will cause an actor to blink (become visible and not
     * visible). Optionally, you may specify the number of blinks. Specify the amount of time
     * the actor should be visible per blink, and the amount of time not visible.
     * This method is part of the actor 'Action' fluent API allowing action chaining.
     * @param timeVisible     The amount of time to stay visible per blink in milliseconds
     * @param timeNotVisible  The amount of time to stay not visible per blink in milliseconds
     * @param numBlinks       The number of times to blink
     */
    blink(timeVisible, timeNotVisible, numBlinks = 1) {
        this._queue.add(new _Action_Blink__WEBPACK_IMPORTED_MODULE_13__.Blink(this._entity, timeVisible, timeNotVisible, numBlinks));
        return this;
    }
    /**
     * This method will cause an actor's opacity to change from its current value
     * to the provided value by a specified time (in milliseconds). This method is
     * part of the actor 'Action' fluent API allowing action chaining.
     * @param opacity  The ending opacity
     * @param duration     The time it should take to fade the actor (in milliseconds)
     */
    fade(opacity, duration) {
        this._queue.add(new _Action_Fade__WEBPACK_IMPORTED_MODULE_14__.Fade(this._entity, opacity, duration));
        return this;
    }
    /**
     * This will cause an actor to flash a specific color for a period of time
     * @param color
     * @param duration The duration in milliseconds
     */
    flash(color, duration = 1000) {
        this._queue.add(new _Action_Flash__WEBPACK_IMPORTED_MODULE_15__.Flash(this._entity, color, duration));
        return this;
    }
    /**
     * This method will delay the next action from executing for a certain
     * amount of time (in milliseconds). This method is part of the actor
     * 'Action' fluent API allowing action chaining.
     * @param duration  The amount of time to delay the next action in the queue from executing in milliseconds
     */
    delay(duration) {
        this._queue.add(new _Action_Delay__WEBPACK_IMPORTED_MODULE_16__.Delay(duration));
        return this;
    }
    /**
     * This method will add an action to the queue that will remove the actor from the
     * scene once it has completed its previous  Any actions on the
     * action queue after this action will not be executed.
     */
    die() {
        this._queue.add(new _Action_Die__WEBPACK_IMPORTED_MODULE_17__.Die(this._entity));
        return this;
    }
    /**
     * This method allows you to call an arbitrary method as the next action in the
     * action queue. This is useful if you want to execute code in after a specific
     * action, i.e An actor arrives at a destination after traversing a path
     */
    callMethod(method) {
        this._queue.add(new _Action_CallMethod__WEBPACK_IMPORTED_MODULE_18__.CallMethod(method));
        return this;
    }
    /**
     * This method will cause the actor to repeat all of the actions built in
     * the `repeatBuilder` callback. If the number of repeats
     * is not specified it will repeat forever. This method is part of
     * the actor 'Action' fluent API allowing action chaining
     *
     * ```typescript
     * // Move up in a zig-zag by repeated moveBy's
     * actor.actions.repeat(repeatCtx => {
     * repeatCtx.moveBy(10, 0, 10);
     * repeatCtx.moveBy(0, 10, 10);
     * }, 5);
     * ```
     * @param repeatBuilder The builder to specify the repeatable list of actions
     * @param times  The number of times to repeat all the previous actions in the action queue. If nothing is specified the actions
     * will repeat forever
     */
    repeat(repeatBuilder, times) {
        if (!times) {
            this.repeatForever(repeatBuilder);
            return this;
        }
        this._queue.add(new _Action_Repeat__WEBPACK_IMPORTED_MODULE_19__.Repeat(this._entity, repeatBuilder, times));
        return this;
    }
    /**
     * This method will cause the actor to repeat all of the actions built in
     * the `repeatBuilder` callback. If the number of repeats
     * is not specified it will repeat forever. This method is part of
     * the actor 'Action' fluent API allowing action chaining
     *
     * ```typescript
     * // Move up in a zig-zag by repeated moveBy's
     * actor.actions.repeat(repeatCtx => {
     * repeatCtx.moveBy(10, 0, 10);
     * repeatCtx.moveBy(0, 10, 10);
     * }, 5);
     * ```
     * @param repeatBuilder The builder to specify the repeatable list of actions
     */
    repeatForever(repeatBuilder) {
        this._queue.add(new _Action_RepeatForever__WEBPACK_IMPORTED_MODULE_20__.RepeatForever(this._entity, repeatBuilder));
        return this;
    }
    /**
     * This method will cause the entity to follow another at a specified distance
     * @param entity           The entity to follow
     * @param followDistance  The distance to maintain when following, if not specified the actor will follow at the current distance.
     */
    follow(entity, followDistance) {
        if (followDistance === undefined) {
            this._queue.add(new _Action_Follow__WEBPACK_IMPORTED_MODULE_21__.Follow(this._entity, entity));
        }
        else {
            this._queue.add(new _Action_Follow__WEBPACK_IMPORTED_MODULE_21__.Follow(this._entity, entity, followDistance));
        }
        return this;
    }
    /**
     * This method will cause the entity to move towards another until they
     * collide "meet" at a specified speed.
     * @param entity  The entity to meet
     * @param speed  The speed in pixels per second to move, if not specified it will match the speed of the other actor
     */
    meet(entity, speed) {
        if (speed === undefined) {
            this._queue.add(new _Action_Meet__WEBPACK_IMPORTED_MODULE_22__.Meet(this._entity, entity));
        }
        else {
            this._queue.add(new _Action_Meet__WEBPACK_IMPORTED_MODULE_22__.Meet(this._entity, entity, speed));
        }
        return this;
    }
    /**
     * Returns a promise that resolves when the current action queue up to now
     * is finished.
     */
    toPromise() {
        const temp = new Promise((resolve) => {
            this._queue.add(new _Action_CallMethod__WEBPACK_IMPORTED_MODULE_18__.CallMethod(() => {
                resolve();
            }));
        });
        return temp;
    }
}


/***/ }),

/***/ "./Actions/ActionQueue.ts":
/*!********************************!*\
  !*** ./Actions/ActionQueue.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionQueue: () => (/* binding */ ActionQueue)
/* harmony export */ });
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Events */ "./Events.ts");

/**
 * Action Queues represent an ordered sequence of actions
 *
 * Action queues are part of the {@apilink ActionContext | `Action API`} and
 * store the list of actions to be executed for an {@apilink Actor}.
 *
 * Actors implement {@apilink Actor.actions} which can be manipulated by
 * advanced users to adjust the actions currently being executed in the
 * queue.
 */
class ActionQueue {
    constructor(entity) {
        this._actions = [];
        this._currentAction = null;
        this._completedActions = [];
        this._entity = entity;
    }
    /**
     * Add an action to the sequence
     * @param action
     */
    add(action) {
        this._actions.push(action);
    }
    /**
     * Remove an action by reference from the sequence
     * @param action
     */
    remove(action) {
        const index = this._actions.indexOf(action);
        this._actions.splice(index, 1);
    }
    /**
     * Removes all actions from this sequence
     */
    clearActions() {
        this._actions.length = 0;
        this._completedActions.length = 0;
        if (this._currentAction) {
            this._currentAction.stop();
        }
    }
    /**
     *
     * @returns The total list of actions in this sequence complete or not
     */
    getActions() {
        return this._actions.concat(this._completedActions);
    }
    getIncompleteActions() {
        return this._actions;
    }
    getCurrentAction() {
        return this._currentAction;
    }
    /**
     *
     * @returns `true` if there are more actions to process in the sequence
     */
    hasNext() {
        return this._actions.length > 0;
    }
    /**
     * @returns `true` if the current sequence of actions is done
     */
    isComplete() {
        return this._actions.length === 0;
    }
    /**
     * Resets the sequence of actions, this is used to restart a sequence from the beginning
     */
    reset() {
        this._actions = this.getActions();
        const len = this._actions.length;
        for (let i = 0; i < len; i++) {
            this._actions[i].reset();
        }
        this._completedActions = [];
    }
    /**
     * Update the queue which updates actions and handles completing actions
     * @param elapsed
     */
    update(elapsed) {
        if (this._actions.length > 0) {
            if (this._currentAction !== this._actions[0]) {
                this._currentAction = this._actions[0];
                this._entity.emit('actionstart', new _Events__WEBPACK_IMPORTED_MODULE_0__.ActionStartEvent(this._currentAction, this._entity));
            }
            this._currentAction.update(elapsed);
            if (this._currentAction.isComplete(this._entity)) {
                this._entity.emit('actioncomplete', new _Events__WEBPACK_IMPORTED_MODULE_0__.ActionCompleteEvent(this._currentAction, this._entity));
                const complete = this._actions.shift();
                if (complete) {
                    this._completedActions.push(complete);
                }
            }
        }
    }
}


/***/ }),

/***/ "./Actions/ActionsComponent.ts":
/*!*************************************!*\
  !*** ./Actions/ActionsComponent.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionsComponent: () => (/* binding */ ActionsComponent)
/* harmony export */ });
/* harmony import */ var _ActionContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ActionContext */ "./Actions/ActionContext.ts");
/* harmony import */ var _EntityComponentSystem_Component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EntityComponentSystem/Component */ "./EntityComponentSystem/Component.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");




class ActionsComponent extends _EntityComponentSystem_Component__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.dependencies = [_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent, _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent];
        this._ctx = null;
    }
    onAdd(entity) {
        this._ctx = new _ActionContext__WEBPACK_IMPORTED_MODULE_3__.ActionContext(entity);
    }
    onRemove() {
        this._ctx = null;
    }
    _getCtx() {
        if (!this._ctx) {
            throw new Error('Actions component not attached to an entity, no context available');
        }
        return this._ctx;
    }
    /**
     * Returns the internal action queue
     * @returns action queue
     */
    getQueue() {
        if (!this._ctx) {
            throw new Error('Actions component not attached to an entity, no queue available');
        }
        return this._ctx.getQueue();
    }
    /**
     * Runs a specific action in the action queue
     * @param action
     */
    runAction(action) {
        if (!this._ctx) {
            throw new Error('Actions component not attached to an entity, cannot run action');
        }
        return this._ctx.runAction(action);
    }
    /**
     * Updates the internal action context, performing action and moving through the internal queue
     * @param elapsed
     */
    update(elapsed) {
        var _a;
        return (_a = this._ctx) === null || _a === void 0 ? void 0 : _a.update(elapsed);
    }
    /**
     * Clears all queued actions from the Actor
     */
    clearActions() {
        var _a;
        (_a = this._ctx) === null || _a === void 0 ? void 0 : _a.clearActions();
    }
    /**
     * Animates an actor with a specified bezier curve by an offset to the current position, the start point is assumed
     * to be the actors current position
     * @param options
     */
    curveBy(options) {
        return this._getCtx().curveBy.apply(this._ctx, [options]);
    }
    /**
     * Animates an actor with a specified bezier curve to an absolute world space coordinate, the start point is assumed
     * to be the actors current position
     * @param options
     */
    curveTo(options) {
        return this._getCtx().curveTo.apply(this._ctx, [options]);
    }
    easeTo(...args) {
        return this._getCtx().easeTo.apply(this._ctx, args);
    }
    easeBy(...args) {
        return this._getCtx().easeBy.apply(this._ctx, args);
    }
    moveTo(xOrPosOrOptions, yOrSpeed, speedOrUndefined) {
        return this._getCtx().moveTo.apply(this._ctx, [xOrPosOrOptions, yOrSpeed, speedOrUndefined]);
    }
    moveBy(xOffsetOrVectorOptions, yOffsetOrSpeed, speedOrUndefined) {
        return this._getCtx().moveBy.apply(this._ctx, [xOffsetOrVectorOptions, yOffsetOrSpeed, speedOrUndefined]);
    }
    rotateTo(angle, speed, rotationType) {
        return this._getCtx().rotateTo.apply(this._ctx, [angle, speed, rotationType]);
    }
    rotateBy(angleRadiansOffsetOrOptions, speed, rotationType) {
        return this._getCtx().rotateBy.apply(this._ctx, [angleRadiansOffsetOrOptions, speed, rotationType]);
    }
    scaleTo(sizeXOrVectorOrOptions, sizeYOrSpeed, speedXOrUndefined, speedYOrUndefined) {
        return this._getCtx().scaleTo.apply(this._ctx, [sizeXOrVectorOrOptions, sizeYOrSpeed, speedXOrUndefined, speedYOrUndefined]);
    }
    scaleBy(sizeOffsetXOrVectorOrOptions, sizeOffsetYOrSpeed, speed) {
        return this._getCtx().scaleBy.apply(this._ctx, [sizeOffsetXOrVectorOrOptions, sizeOffsetYOrSpeed, speed]);
    }
    /**
     * This method will cause an actor to blink (become visible and not
     * visible). Optionally, you may specify the number of blinks. Specify the amount of time
     * the actor should be visible per blink, and the amount of time not visible.
     * This method is part of the actor 'Action' fluent API allowing action chaining.
     * @param timeVisible     The amount of time to stay visible per blink in milliseconds
     * @param timeNotVisible  The amount of time to stay not visible per blink in milliseconds
     * @param numBlinks       The number of times to blink
     */
    blink(timeVisible, timeNotVisible, numBlinks) {
        return this._getCtx().blink(timeVisible, timeNotVisible, numBlinks);
    }
    /**
     * This method will cause an actor's opacity to change from its current value
     * to the provided value by a specified time (in milliseconds). This method is
     * part of the actor 'Action' fluent API allowing action chaining.
     * @param opacity  The ending opacity
     * @param duration     The time it should take to fade the actor (in milliseconds)
     */
    fade(opacity, duration) {
        return this._getCtx().fade(opacity, duration);
    }
    /**
     * This will cause an actor to flash a specific color for a period of time
     * @param color
     * @param duration The duration in milliseconds
     */
    flash(color, duration = 1000) {
        return this._getCtx().flash(color, duration);
    }
    /**
     * This method will delay the next action from executing for a certain
     * amount of time (in milliseconds). This method is part of the actor
     * 'Action' fluent API allowing action chaining.
     * @param duration  The amount of time to delay the next action in the queue from executing in milliseconds
     */
    delay(duration) {
        return this._getCtx().delay(duration);
    }
    /**
     * This method will add an action to the queue that will remove the actor from the
     * scene once it has completed its previous  Any actions on the
     * action queue after this action will not be executed.
     */
    die() {
        return this._getCtx().die();
    }
    /**
     * This method allows you to call an arbitrary method as the next action in the
     * action queue. This is useful if you want to execute code in after a specific
     * action, i.e An actor arrives at a destination after traversing a path
     */
    callMethod(method) {
        return this._getCtx().callMethod(method);
    }
    /**
     * This method will cause the actor to repeat all of the actions built in
     * the `repeatBuilder` callback. If the number of repeats
     * is not specified it will repeat forever. This method is part of
     * the actor 'Action' fluent API allowing action chaining
     *
     * ```typescript
     * // Move up in a zig-zag by repeated moveBy's
     * actor.actions.repeat(repeatCtx => {
     * repeatCtx.moveBy(10, 0, 10);
     * repeatCtx.moveBy(0, 10, 10);
     * }, 5);
     * ```
     * @param repeatBuilder The builder to specify the repeatable list of actions
     * @param times  The number of times to repeat all the previous actions in the action queue. If nothing is specified the actions
     * will repeat forever
     */
    repeat(repeatBuilder, times) {
        return this._getCtx().repeat(repeatBuilder, times);
    }
    /**
     * This method will cause the actor to repeat all of the actions built in
     * the `repeatBuilder` callback. If the number of repeats
     * is not specified it will repeat forever. This method is part of
     * the actor 'Action' fluent API allowing action chaining
     *
     * ```typescript
     * // Move up in a zig-zag by repeated moveBy's
     * actor.actions.repeat(repeatCtx => {
     * repeatCtx.moveBy(10, 0, 10);
     * repeatCtx.moveBy(0, 10, 10);
     * }, 5);
     * ```
     * @param repeatBuilder The builder to specify the repeatable list of actions
     */
    repeatForever(repeatBuilder) {
        return this._getCtx().repeatForever(repeatBuilder);
    }
    /**
     * This method will cause the entity to follow another at a specified distance
     * @param entity           The entity to follow
     * @param followDistance  The distance to maintain when following, if not specified the actor will follow at the current distance.
     */
    follow(entity, followDistance) {
        return this._getCtx().follow(entity, followDistance);
    }
    /**
     * This method will cause the entity to move towards another until they
     * collide "meet" at a specified speed.
     * @param entity  The entity to meet
     * @param speed  The speed in pixels per second to move, if not specified it will match the speed of the other actor
     */
    meet(entity, speed) {
        return this._getCtx().meet(entity, speed);
    }
    /**
     * Returns a promise that resolves when the current action queue up to now
     * is finished.
     */
    toPromise() {
        return this._getCtx().toPromise();
    }
}


/***/ }),

/***/ "./Actions/ActionsSystem.ts":
/*!**********************************!*\
  !*** ./Actions/ActionsSystem.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionsSystem: () => (/* binding */ ActionsSystem)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../EntityComponentSystem */ "./EntityComponentSystem/Priority.ts");
/* harmony import */ var _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EntityComponentSystem/System */ "./EntityComponentSystem/System.ts");
/* harmony import */ var _ActionsComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ActionsComponent */ "./Actions/ActionsComponent.ts");



class ActionsSystem extends _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__.System {
    constructor(world) {
        super();
        this.world = world;
        this.systemType = _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__.SystemType.Update;
        this._actions = [];
        this.query = this.world.query([_ActionsComponent__WEBPACK_IMPORTED_MODULE_1__.ActionsComponent]);
        this.query.entityAdded$.subscribe((e) => this._actions.push(e.get(_ActionsComponent__WEBPACK_IMPORTED_MODULE_1__.ActionsComponent)));
        this.query.entityRemoved$.subscribe((e) => {
            const action = e.get(_ActionsComponent__WEBPACK_IMPORTED_MODULE_1__.ActionsComponent);
            const index = this._actions.indexOf(action);
            if (index > -1) {
                this._actions.splice(index, 1);
            }
        });
    }
    update(elapsed) {
        for (let i = 0; i < this._actions.length; i++) {
            const action = this._actions[i];
            action.update(elapsed);
        }
    }
}
ActionsSystem.priority = _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_2__.SystemPriority.Higher;


/***/ }),

/***/ "./Actions/index.ts":
/*!**************************!*\
  !*** ./Actions/index.ts ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionContext: () => (/* reexport safe */ _ActionContext__WEBPACK_IMPORTED_MODULE_0__.ActionContext),
/* harmony export */   ActionQueue: () => (/* reexport safe */ _ActionQueue__WEBPACK_IMPORTED_MODULE_1__.ActionQueue),
/* harmony export */   ActionSequence: () => (/* reexport safe */ _Action_ActionSequence__WEBPACK_IMPORTED_MODULE_3__.ActionSequence),
/* harmony export */   ActionsComponent: () => (/* reexport safe */ _ActionsComponent__WEBPACK_IMPORTED_MODULE_24__.ActionsComponent),
/* harmony export */   ActionsSystem: () => (/* reexport safe */ _ActionsSystem__WEBPACK_IMPORTED_MODULE_25__.ActionsSystem),
/* harmony export */   Blink: () => (/* reexport safe */ _Action_Blink__WEBPACK_IMPORTED_MODULE_7__.Blink),
/* harmony export */   CurveBy: () => (/* reexport safe */ _Action_CurveBy__WEBPACK_IMPORTED_MODULE_23__.CurveBy),
/* harmony export */   CurveTo: () => (/* reexport safe */ _Action_CurveTo__WEBPACK_IMPORTED_MODULE_22__.CurveTo),
/* harmony export */   Delay: () => (/* reexport safe */ _Action_Delay__WEBPACK_IMPORTED_MODULE_20__.Delay),
/* harmony export */   Die: () => (/* reexport safe */ _Action_Die__WEBPACK_IMPORTED_MODULE_8__.Die),
/* harmony export */   EaseBy: () => (/* reexport safe */ _Action_EaseBy__WEBPACK_IMPORTED_MODULE_10__.EaseBy),
/* harmony export */   EaseTo: () => (/* reexport safe */ _Action_EaseTo__WEBPACK_IMPORTED_MODULE_9__.EaseTo),
/* harmony export */   Fade: () => (/* reexport safe */ _Action_Fade__WEBPACK_IMPORTED_MODULE_11__.Fade),
/* harmony export */   Flash: () => (/* reexport safe */ _Action_Flash__WEBPACK_IMPORTED_MODULE_21__.Flash),
/* harmony export */   Follow: () => (/* reexport safe */ _Action_Follow__WEBPACK_IMPORTED_MODULE_12__.Follow),
/* harmony export */   Meet: () => (/* reexport safe */ _Action_Meet__WEBPACK_IMPORTED_MODULE_13__.Meet),
/* harmony export */   MoveBy: () => (/* reexport safe */ _Action_MoveBy__WEBPACK_IMPORTED_MODULE_14__.MoveBy),
/* harmony export */   MoveByWithOptions: () => (/* reexport safe */ _Action_MoveBy__WEBPACK_IMPORTED_MODULE_14__.MoveByWithOptions),
/* harmony export */   MoveTo: () => (/* reexport safe */ _Action_MoveTo__WEBPACK_IMPORTED_MODULE_15__.MoveTo),
/* harmony export */   MoveToWithOptions: () => (/* reexport safe */ _Action_MoveTo__WEBPACK_IMPORTED_MODULE_15__.MoveToWithOptions),
/* harmony export */   ParallelActions: () => (/* reexport safe */ _Action_ParallelActions__WEBPACK_IMPORTED_MODULE_4__.ParallelActions),
/* harmony export */   Repeat: () => (/* reexport safe */ _Action_Repeat__WEBPACK_IMPORTED_MODULE_5__.Repeat),
/* harmony export */   RepeatForever: () => (/* reexport safe */ _Action_RepeatForever__WEBPACK_IMPORTED_MODULE_6__.RepeatForever),
/* harmony export */   RotateBy: () => (/* reexport safe */ _Action_RotateBy__WEBPACK_IMPORTED_MODULE_16__.RotateBy),
/* harmony export */   RotateByWithOptions: () => (/* reexport safe */ _Action_RotateBy__WEBPACK_IMPORTED_MODULE_16__.RotateByWithOptions),
/* harmony export */   RotateTo: () => (/* reexport safe */ _Action_RotateTo__WEBPACK_IMPORTED_MODULE_17__.RotateTo),
/* harmony export */   RotateToWithOptions: () => (/* reexport safe */ _Action_RotateTo__WEBPACK_IMPORTED_MODULE_17__.RotateToWithOptions),
/* harmony export */   ScaleBy: () => (/* reexport safe */ _Action_ScaleBy__WEBPACK_IMPORTED_MODULE_18__.ScaleBy),
/* harmony export */   ScaleByWithOptions: () => (/* reexport safe */ _Action_ScaleBy__WEBPACK_IMPORTED_MODULE_18__.ScaleByWithOptions),
/* harmony export */   ScaleTo: () => (/* reexport safe */ _Action_ScaleTo__WEBPACK_IMPORTED_MODULE_19__.ScaleTo),
/* harmony export */   ScaleToWithOptions: () => (/* reexport safe */ _Action_ScaleTo__WEBPACK_IMPORTED_MODULE_19__.ScaleToWithOptions),
/* harmony export */   isMoveByOptions: () => (/* reexport safe */ _Action_MoveBy__WEBPACK_IMPORTED_MODULE_14__.isMoveByOptions),
/* harmony export */   isMoveToOptions: () => (/* reexport safe */ _Action_MoveTo__WEBPACK_IMPORTED_MODULE_15__.isMoveToOptions),
/* harmony export */   isRotateByOptions: () => (/* reexport safe */ _Action_RotateBy__WEBPACK_IMPORTED_MODULE_16__.isRotateByOptions),
/* harmony export */   isRotateToOptions: () => (/* reexport safe */ _Action_RotateTo__WEBPACK_IMPORTED_MODULE_17__.isRotateToOptions),
/* harmony export */   isScaleByOptions: () => (/* reexport safe */ _Action_ScaleBy__WEBPACK_IMPORTED_MODULE_18__.isScaleByOptions),
/* harmony export */   isScaleToOptions: () => (/* reexport safe */ _Action_ScaleTo__WEBPACK_IMPORTED_MODULE_19__.isScaleToOptions),
/* harmony export */   nextActionId: () => (/* reexport safe */ _Action__WEBPACK_IMPORTED_MODULE_2__.nextActionId)
/* harmony export */ });
/* harmony import */ var _ActionContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ActionContext */ "./Actions/ActionContext.ts");
/* harmony import */ var _ActionQueue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ActionQueue */ "./Actions/ActionQueue.ts");
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Action */ "./Actions/Action.ts");
/* harmony import */ var _Action_ActionSequence__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Action/ActionSequence */ "./Actions/Action/ActionSequence.ts");
/* harmony import */ var _Action_ParallelActions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Action/ParallelActions */ "./Actions/Action/ParallelActions.ts");
/* harmony import */ var _Action_Repeat__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Action/Repeat */ "./Actions/Action/Repeat.ts");
/* harmony import */ var _Action_RepeatForever__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Action/RepeatForever */ "./Actions/Action/RepeatForever.ts");
/* harmony import */ var _Action_Blink__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Action/Blink */ "./Actions/Action/Blink.ts");
/* harmony import */ var _Action_Die__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Action/Die */ "./Actions/Action/Die.ts");
/* harmony import */ var _Action_EaseTo__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Action/EaseTo */ "./Actions/Action/EaseTo.ts");
/* harmony import */ var _Action_EaseBy__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Action/EaseBy */ "./Actions/Action/EaseBy.ts");
/* harmony import */ var _Action_Fade__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Action/Fade */ "./Actions/Action/Fade.ts");
/* harmony import */ var _Action_Follow__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Action/Follow */ "./Actions/Action/Follow.ts");
/* harmony import */ var _Action_Meet__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Action/Meet */ "./Actions/Action/Meet.ts");
/* harmony import */ var _Action_MoveBy__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Action/MoveBy */ "./Actions/Action/MoveBy.ts");
/* harmony import */ var _Action_MoveTo__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Action/MoveTo */ "./Actions/Action/MoveTo.ts");
/* harmony import */ var _Action_RotateBy__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Action/RotateBy */ "./Actions/Action/RotateBy.ts");
/* harmony import */ var _Action_RotateTo__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Action/RotateTo */ "./Actions/Action/RotateTo.ts");
/* harmony import */ var _Action_ScaleBy__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Action/ScaleBy */ "./Actions/Action/ScaleBy.ts");
/* harmony import */ var _Action_ScaleTo__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Action/ScaleTo */ "./Actions/Action/ScaleTo.ts");
/* harmony import */ var _Action_Delay__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Action/Delay */ "./Actions/Action/Delay.ts");
/* harmony import */ var _Action_Flash__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Action/Flash */ "./Actions/Action/Flash.ts");
/* harmony import */ var _Action_CurveTo__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Action/CurveTo */ "./Actions/Action/CurveTo.ts");
/* harmony import */ var _Action_CurveBy__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./Action/CurveBy */ "./Actions/Action/CurveBy.ts");
/* harmony import */ var _ActionsComponent__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./ActionsComponent */ "./Actions/ActionsComponent.ts");
/* harmony import */ var _ActionsSystem__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./ActionsSystem */ "./Actions/ActionsSystem.ts");





























/***/ }),

/***/ "./Actor.ts":
/*!******************!*\
  !*** ./Actor.ts ***!
  \******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Actor: () => (/* binding */ Actor),
/* harmony export */   ActorEvents: () => (/* binding */ ActorEvents),
/* harmony export */   isActor: () => (/* binding */ isActor)
/* harmony export */ });
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Collision_BodyComponent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Collision/BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var _Collision_CollisionType__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Collision/CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _EntityComponentSystem_Entity__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityComponentSystem/Entity */ "./EntityComponentSystem/Entity.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Graphics/GraphicsComponent */ "./Graphics/GraphicsComponent.ts");
/* harmony import */ var _Graphics_Rectangle__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Graphics/Rectangle */ "./Graphics/Rectangle.ts");
/* harmony import */ var _Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Collision/ColliderComponent */ "./Collision/ColliderComponent.ts");
/* harmony import */ var _Collision_Colliders_Shape__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Collision/Colliders/Shape */ "./Collision/Colliders/Shape.ts");
/* harmony import */ var _Util_Watch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Util/Watch */ "./Util/Watch.ts");
/* harmony import */ var _Graphics_Circle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Graphics/Circle */ "./Graphics/Circle.ts");
/* harmony import */ var _Input_PointerComponent__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Input/PointerComponent */ "./Input/PointerComponent.ts");
/* harmony import */ var _Actions_ActionsComponent__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Actions/ActionsComponent */ "./Actions/ActionsComponent.ts");
/* harmony import */ var _Math_coord_plane__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Math/coord-plane */ "./Math/coord-plane.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./EventEmitter */ "./EventEmitter.ts");


















/**
 * Type guard for checking if something is an Actor
 * @param x
 */
function isActor(x) {
    return x instanceof Actor;
}
const ActorEvents = {
    CollisionStart: 'collisionstart',
    CollisionEnd: 'collisionend',
    PreCollision: 'precollision',
    PostCollision: 'postcollision',
    Kill: 'kill',
    PreKill: 'prekill',
    PostKill: 'postkill',
    PreDraw: 'predraw',
    PostDraw: 'postdraw',
    PreTransformDraw: 'pretransformdraw',
    PostTransformDraw: 'posttransformdraw',
    PreDebugDraw: 'predebugdraw',
    PostDebugDraw: 'postdebugdraw',
    PointerUp: 'pointerup',
    PointerDown: 'pointerdown',
    PointerEnter: 'pointerenter',
    PointerLeave: 'pointerleave',
    PointerMove: 'pointermove',
    PointerCancel: 'pointercancel',
    Wheel: 'pointerwheel',
    PointerDrag: 'pointerdragstart',
    PointerDragEnd: 'pointerdragend',
    PointerDragEnter: 'pointerdragenter',
    PointerDragLeave: 'pointerdragleave',
    PointerDragMove: 'pointerdragmove',
    EnterViewPort: 'enterviewport',
    ExitViewPort: 'exitviewport',
    ActionStart: 'actionstart',
    ActionComplete: 'actioncomplete'
};
/**
 * The most important primitive in Excalibur is an `Actor`. Anything that
 * can move on the screen, collide with another `Actor`, respond to events,
 * or interact with the current scene, must be an actor. An `Actor` **must**
 * be part of a {@apilink Scene} for it to be drawn to the screen.
 */
class Actor extends _EntityComponentSystem_Entity__WEBPACK_IMPORTED_MODULE_0__.Entity {
    /**
     * Gets the position vector of the actor in pixels
     */
    get pos() {
        return this.transform.pos;
    }
    /**
     * Sets the position vector of the actor in pixels
     */
    set pos(thePos) {
        this.transform.pos = thePos.clone();
    }
    /**
     * Gets the position vector of the actor from the last frame
     */
    get oldPos() {
        return this.body.oldPos;
    }
    /**
     * Gets the global position vector of the actor from the last frame
     */
    get oldGlobalPos() {
        return this.body.oldGlobalPos;
    }
    /**
     * Sets the position vector of the actor in the last frame
     */
    set oldPos(thePos) {
        this.body.oldPos.setTo(thePos.x, thePos.y);
    }
    /**
     * Gets the velocity vector of the actor in pixels/sec
     */
    get vel() {
        return this.motion.vel;
    }
    /**
     * Sets the velocity vector of the actor in pixels/sec
     */
    set vel(theVel) {
        this.motion.vel = theVel.clone();
    }
    /**
     * Gets the velocity vector of the actor from the last frame
     */
    get oldVel() {
        return this.body.oldVel;
    }
    /**
     * Sets the velocity vector of the actor from the last frame
     */
    set oldVel(theVel) {
        this.body.oldVel.setTo(theVel.x, theVel.y);
    }
    /**
     * Gets the acceleration vector of the actor in pixels/second/second. An acceleration pointing down such as (0, 100) may be
     * useful to simulate a gravitational effect.
     */
    get acc() {
        return this.motion.acc;
    }
    /**
     * Sets the acceleration vector of teh actor in pixels/second/second
     */
    set acc(theAcc) {
        this.motion.acc = theAcc.clone();
    }
    /**
     * Sets the acceleration of the actor from the last frame. This does not include the global acc {@apilink Physics.acc}.
     */
    set oldAcc(theAcc) {
        this.body.oldAcc.setTo(theAcc.x, theAcc.y);
    }
    /**
     * Gets the acceleration of the actor from the last frame. This does not include the global acc {@apilink Physics.acc}.
     */
    get oldAcc() {
        return this.body.oldAcc;
    }
    /**
     * Gets the rotation of the actor in radians. 1 radian = 180/PI Degrees.
     */
    get rotation() {
        return this.transform.rotation;
    }
    /**
     * Sets the rotation of the actor in radians. 1 radian = 180/PI Degrees.
     */
    set rotation(theAngle) {
        this.transform.rotation = theAngle;
    }
    /**
     * Gets the rotational velocity of the actor in radians/second
     */
    get angularVelocity() {
        return this.motion.angularVelocity;
    }
    /**
     * Sets the rotational velocity of the actor in radians/sec
     */
    set angularVelocity(angularVelocity) {
        this.motion.angularVelocity = angularVelocity;
    }
    get scale() {
        return this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).scale;
    }
    set scale(scale) {
        this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).scale = scale;
    }
    /**
     * The anchor to apply all actor related transformations like rotation,
     * translation, and scaling. By default the anchor is in the center of
     * the actor. By default it is set to the center of the actor (.5, .5)
     *
     * An anchor of (.5, .5) will ensure that drawings are centered.
     *
     * Use `anchor.setTo` to set the anchor to a different point using
     * values between 0 and 1. For example, anchoring to the top-left would be
     * `Actor.anchor.setTo(0, 0)` and top-right would be `Actor.anchor.setTo(0, 1)`.
     */
    get anchor() {
        return this._anchor;
    }
    set anchor(vec) {
        this._anchor = (0,_Util_Watch__WEBPACK_IMPORTED_MODULE_2__.watch)(vec, (v) => this._handleAnchorChange(v));
        this._handleAnchorChange(vec);
    }
    _handleAnchorChange(v) {
        if (this.graphics) {
            this.graphics.anchor = v;
        }
    }
    /**
     * The offset in pixels to apply to all actor graphics
     *
     * Default offset of (0, 0)
     */
    get offset() {
        return this._offset;
    }
    set offset(vec) {
        this._offset = (0,_Util_Watch__WEBPACK_IMPORTED_MODULE_2__.watch)(vec, (v) => this._handleOffsetChange(v));
        this._handleOffsetChange(vec);
    }
    _handleOffsetChange(v) {
        if (this.graphics) {
            this.graphics.offset = v;
        }
    }
    /**
     * Indicates whether the actor is physically in the viewport
     */
    get isOffScreen() {
        return this.hasTag('ex.offscreen');
    }
    get draggable() {
        return this._draggable;
    }
    set draggable(isDraggable) {
        if (isDraggable) {
            if (isDraggable && !this._draggable) {
                this.events.on('pointerdragstart', this._pointerDragStartHandler);
                this.events.on('pointerdragend', this._pointerDragEndHandler);
                this.events.on('pointerdragmove', this._pointerDragMoveHandler);
                this.events.on('pointerdragleave', this._pointerDragLeaveHandler);
            }
            else if (!isDraggable && this._draggable) {
                this.events.off('pointerdragstart', this._pointerDragStartHandler);
                this.events.off('pointerdragend', this._pointerDragEndHandler);
                this.events.off('pointerdragmove', this._pointerDragMoveHandler);
                this.events.off('pointerdragleave', this._pointerDragLeaveHandler);
            }
            this._draggable = isDraggable;
        }
    }
    /**
     * Sets the color of the actor's current graphic
     */
    get color() {
        return this.graphics.color;
    }
    set color(v) {
        this.graphics.color = v;
    }
    // #endregion
    /**
     *
     * @param config
     */
    constructor(config) {
        super();
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this._anchor = (0,_Util_Watch__WEBPACK_IMPORTED_MODULE_2__.watch)(_Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Half, (v) => this._handleAnchorChange(v));
        this._offset = (0,_Util_Watch__WEBPACK_IMPORTED_MODULE_2__.watch)(_Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero, (v) => this._handleOffsetChange(v));
        /**
         * Convenience reference to the global logger
         */
        this.logger = _Util_Log__WEBPACK_IMPORTED_MODULE_5__.Logger.getInstance();
        /**
         * Draggable helper
         */
        this._draggable = false;
        this._dragging = false;
        this._pointerDragStartHandler = () => {
            this._dragging = true;
        };
        this._pointerDragEndHandler = () => {
            this._dragging = false;
        };
        this._pointerDragMoveHandler = (pe) => {
            if (this._dragging) {
                this.pos = pe.worldPos;
            }
        };
        this._pointerDragLeaveHandler = (pe) => {
            if (this._dragging) {
                this.pos = pe.worldPos;
            }
        };
        const { name, x, y, pos, coordPlane, scale, width, height, radius, collider, vel, acc, rotation, angularVelocity, z, color, visible, opacity, anchor, offset, collisionType, collisionGroup, silenceWarnings } = {
            ...config
        };
        this.name = name !== null && name !== void 0 ? name : this.name;
        this.anchor = anchor !== null && anchor !== void 0 ? anchor : Actor.defaults.anchor.clone();
        this.offset = offset !== null && offset !== void 0 ? offset : _Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero;
        this.transform = new _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent();
        this.addComponent(this.transform);
        this.pos = pos !== null && pos !== void 0 ? pos : (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(x !== null && x !== void 0 ? x : 0, y !== null && y !== void 0 ? y : 0);
        this.rotation = rotation !== null && rotation !== void 0 ? rotation : 0;
        this.scale = scale !== null && scale !== void 0 ? scale : (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(1, 1);
        this.z = z !== null && z !== void 0 ? z : 0;
        this.transform.coordPlane = coordPlane !== null && coordPlane !== void 0 ? coordPlane : _Math_coord_plane__WEBPACK_IMPORTED_MODULE_6__.CoordPlane.World;
        this._silenceWarnings = silenceWarnings !== null && silenceWarnings !== void 0 ? silenceWarnings : false;
        this.pointer = new _Input_PointerComponent__WEBPACK_IMPORTED_MODULE_7__.PointerComponent();
        this.addComponent(this.pointer);
        this.graphics = new _Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_8__.GraphicsComponent({
            anchor: this.anchor,
            offset: this.offset,
            opacity: opacity
        });
        this.addComponent(this.graphics);
        this.motion = new _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_9__.MotionComponent();
        this.addComponent(this.motion);
        this.vel = vel !== null && vel !== void 0 ? vel : _Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero;
        this.acc = acc !== null && acc !== void 0 ? acc : _Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero;
        this.angularVelocity = angularVelocity !== null && angularVelocity !== void 0 ? angularVelocity : 0;
        this.actions = new _Actions_ActionsComponent__WEBPACK_IMPORTED_MODULE_10__.ActionsComponent();
        this.addComponent(this.actions);
        this.body = new _Collision_BodyComponent__WEBPACK_IMPORTED_MODULE_11__.BodyComponent();
        this.addComponent(this.body);
        this.body.collisionType = collisionType !== null && collisionType !== void 0 ? collisionType : _Collision_CollisionType__WEBPACK_IMPORTED_MODULE_12__.CollisionType.Passive;
        if (collisionGroup) {
            this.body.group = collisionGroup;
        }
        if (color) {
            this.color = color;
        }
        if (collider) {
            this.collider = new _Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_13__.ColliderComponent(collider);
            this.addComponent(this.collider);
        }
        else if (radius) {
            this.collider = new _Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_13__.ColliderComponent(_Collision_Colliders_Shape__WEBPACK_IMPORTED_MODULE_14__.Shape.Circle(radius));
            this.addComponent(this.collider);
            if (color) {
                this.graphics.add(new _Graphics_Circle__WEBPACK_IMPORTED_MODULE_15__.Circle({
                    color: color,
                    radius
                }));
            }
        }
        else {
            if (width > 0 && height > 0) {
                this.collider = new _Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_13__.ColliderComponent(_Collision_Colliders_Shape__WEBPACK_IMPORTED_MODULE_14__.Shape.Box(width, height, this.anchor));
                this.addComponent(this.collider);
                if (color && width && height) {
                    this.graphics.add(new _Graphics_Rectangle__WEBPACK_IMPORTED_MODULE_16__.Rectangle({
                        color: color,
                        width,
                        height
                    }));
                }
            }
            else {
                this.collider = new _Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_13__.ColliderComponent();
                this.addComponent(this.collider); // no collider
            }
        }
        this.graphics.isVisible = visible !== null && visible !== void 0 ? visible : true;
    }
    clone() {
        const clone = new Actor({
            silenceWarnings: this._silenceWarnings,
            color: this.color.clone(),
            anchor: this.anchor.clone(),
            offset: this.offset.clone()
        });
        clone.clearComponents();
        clone.processComponentRemoval();
        // Clone builtins, order is important, same as ctor
        clone.addComponent((clone.transform = this.transform.clone()), true);
        clone.addComponent((clone.pointer = this.pointer.clone()), true);
        clone.addComponent((clone.graphics = this.graphics.clone()), true);
        clone.addComponent((clone.motion = this.motion.clone()), true);
        clone.addComponent((clone.actions = this.actions.clone()), true);
        clone.addComponent((clone.body = this.body.clone()), true);
        if (this.collider.get()) {
            clone.addComponent((clone.collider = this.collider.clone()), true);
        }
        const builtInComponents = [
            this.transform,
            this.pointer,
            this.graphics,
            this.motion,
            this.actions,
            this.body,
            this.collider
        ];
        // Clone non-builtin the current actors components
        const components = this.getComponents();
        for (const c of components) {
            if (!builtInComponents.includes(c)) {
                clone.addComponent(c.clone(), true);
            }
        }
        return clone;
    }
    /**
     * `onInitialize` is called before the first update of the actor. This method is meant to be
     * overridden. This is where initialization of child actors should take place.
     *
     * Synonymous with the event handler `.on('initialize', (evt) => {...})`
     */
    onInitialize(engine) {
        // Override me
    }
    /**
     * Initializes this actor and all it's child actors, meant to be called by the Scene before first update not by users of Excalibur.
     *
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     * @internal
     */
    _initialize(engine) {
        super._initialize(engine);
        for (const child of this.children) {
            child._initialize(engine);
        }
    }
    emit(eventName, event) {
        this.events.emit(eventName, event);
    }
    on(eventName, handler) {
        return this.events.on(eventName, handler);
    }
    once(eventName, handler) {
        return this.events.once(eventName, handler);
    }
    off(eventName, handler) {
        this.events.off(eventName, handler);
    }
    // #endregion
    /**
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     *
     * Internal _prekill handler for {@apilink onPreKill} lifecycle event
     * @internal
     */
    _prekill(scene) {
        this.events.emit('prekill', new _Events__WEBPACK_IMPORTED_MODULE_17__.PreKillEvent(this));
        this.onPreKill(scene);
    }
    /**
     * Safe to override onPreKill lifecycle event handler. Synonymous with `.on('prekill', (evt) =>{...})`
     *
     * `onPreKill` is called directly before an actor is killed and removed from its current {@apilink Scene}.
     */
    onPreKill(scene) {
        // Override me
    }
    /**
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     *
     * Internal _prekill handler for {@apilink onPostKill} lifecycle event
     * @internal
     */
    _postkill(scene) {
        this.events.emit('postkill', new _Events__WEBPACK_IMPORTED_MODULE_17__.PostKillEvent(this));
        this.onPostKill(scene);
    }
    /**
     * Safe to override onPostKill lifecycle event handler. Synonymous with `.on('postkill', (evt) => {...})`
     *
     * `onPostKill` is called directly after an actor is killed and remove from its current {@apilink Scene}.
     */
    onPostKill(scene) {
        // Override me
    }
    /**
     * If the current actor is a member of the scene, this will remove
     * it from the scene graph. It will no longer be drawn or updated.
     */
    kill() {
        if (this.scene) {
            this._prekill(this.scene);
            this.events.emit('kill', new _Events__WEBPACK_IMPORTED_MODULE_17__.KillEvent(this));
            super.kill();
            this._postkill(this.scene);
        }
        else {
            if (true) {
                this.logger.warn(`Cannot kill actor named "${this.name}", it was never added to the Scene`);
            }
        }
    }
    /**
     * If the current actor is killed, it will now not be killed.
     */
    unkill() {
        this.isActive = true;
    }
    /**
     * Indicates wether the actor has been killed.
     */
    isKilled() {
        return !this.isActive;
    }
    /**
     * Gets the z-index of an actor. The z-index determines the relative order an actor is drawn in.
     * Actors with a higher z-index are drawn on top of actors with a lower z-index
     */
    get z() {
        return this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).z;
    }
    /**
     * Sets the z-index of an actor and updates it in the drawing list for the scene.
     * The z-index determines the relative order an actor is drawn in.
     * Actors with a higher z-index are drawn on top of actors with a lower z-index
     * @param newZ new z-index to assign
     */
    set z(newZ) {
        this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).z = newZ;
    }
    /**
     * Get the center point of an actor (global position)
     */
    get center() {
        const globalPos = this.getGlobalPos();
        return new _Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector(globalPos.x + this.width / 2 - this.anchor.x * this.width, globalPos.y + this.height / 2 - this.anchor.y * this.height);
    }
    /**
     * Get the local center point of an actor
     */
    get localCenter() {
        return new _Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector(this.pos.x + this.width / 2 - this.anchor.x * this.width, this.pos.y + this.height / 2 - this.anchor.y * this.height);
    }
    get width() {
        return this.collider.localBounds.width * this.getGlobalScale().x;
    }
    get height() {
        return this.collider.localBounds.height * this.getGlobalScale().y;
    }
    /**
     * Gets this actor's rotation taking into account any parent relationships
     * @returns Rotation angle in radians
     * @deprecated Use {@apilink globalRotation} instead
     */
    getGlobalRotation() {
        return this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).globalRotation;
    }
    /**
     * The actor's rotation (in radians) taking into account any parent relationships
     */
    get globalRotation() {
        return this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).globalRotation;
    }
    /**
     * Gets an actor's world position taking into account parent relationships, scaling, rotation, and translation
     * @returns Position in world coordinates
     * @deprecated Use {@apilink globalPos} instead
     */
    getGlobalPos() {
        return this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).globalPos;
    }
    /**
     * The actor's world position taking into account parent relationships, scaling, rotation, and translation
     */
    get globalPos() {
        return this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).globalPos;
    }
    /**
     * Gets the global scale of the Actor
     * @deprecated Use {@apilink globalScale} instead
     */
    getGlobalScale() {
        return this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).globalScale;
    }
    /**
     * The global scale of the Actor
     */
    get globalScale() {
        return this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).globalScale;
    }
    /**
     * The global z-index of the actor
     */
    get globalZ() {
        return this.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent).globalZ;
    }
    // #region Collision
    /**
     * Tests whether the x/y specified are contained in the actor
     * @param x  X coordinate to test (in world coordinates)
     * @param y  Y coordinate to test (in world coordinates)
     * @param recurse checks whether the x/y are contained in any child actors (if they exist).
     */
    contains(x, y, recurse = false) {
        const point = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(x, y);
        const collider = this.get(_Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_13__.ColliderComponent);
        collider.update();
        const geom = collider.get();
        if (!geom) {
            return false;
        }
        const containment = geom.contains(point);
        if (recurse) {
            return (containment ||
                this.children.some((child) => {
                    return child.contains(x, y, true);
                }));
        }
        return containment;
    }
    /**
     * Returns true if the two actor.collider's surfaces are less than or equal to the distance specified from each other
     * @param actor     Actor to test
     * @param distance  Distance in pixels to test
     */
    within(actor, distance) {
        const collider = this.get(_Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_13__.ColliderComponent);
        const otherCollider = actor.get(_Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_13__.ColliderComponent);
        const me = collider.get();
        const other = otherCollider.get();
        if (me && other) {
            return me.getClosestLineBetween(other).getLength() <= distance;
        }
        return false;
    }
    // #endregion
    // #region Update
    /**
     * Called by the Engine, updates the state of the actor
     * @internal
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     */
    update(engine, elapsed) {
        this._initialize(engine);
        this._add(engine);
        this._preupdate(engine, elapsed);
        this._postupdate(engine, elapsed);
        this._remove(engine);
    }
    /**
     * Safe to override onPreUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPreUpdate` is called directly before an actor is updated.
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     */
    onPreUpdate(engine, elapsed) {
        // Override me
    }
    /**
     * Safe to override onPostUpdate lifecycle event handler. Synonymous with `.on('postupdate', (evt) =>{...})`
     *
     * `onPostUpdate` is called directly after an actor is updated.
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     */
    onPostUpdate(engine, elapsed) {
        // Override me
    }
    /**
     * Fires before every collision resolution for a confirmed contact
     * @param self
     * @param other
     * @param side
     * @param contact
     */
    onPreCollisionResolve(self, other, side, contact) {
        // Override me
    }
    /**
     * Fires after every resolution for a confirmed contact.
     * @param self
     * @param other
     * @param side
     * @param contact
     */
    onPostCollisionResolve(self, other, side, contact) {
        // Override me
    }
    /**
     * Fires once when 2 entities with a ColliderComponent first start colliding or touching, if the Colliders stay in contact this
     * does not continue firing until they separate and re-collide.
     * @param self
     * @param other
     * @param side
     * @param contact
     */
    onCollisionStart(self, other, side, contact) {
        // Override me
    }
    /**
     * Fires once when 2 entities with a ColliderComponent separate after having been in contact.
     * @param self
     * @param other
     * @param side
     * @param lastContact
     */
    onCollisionEnd(self, other, side, lastContact) {
        // Override me
    }
    /**
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     *
     * Internal _preupdate handler for {@apilink onPreUpdate} lifecycle event
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     * @internal
     */
    _preupdate(engine, elapsed) {
        this.events.emit('preupdate', new _Events__WEBPACK_IMPORTED_MODULE_17__.PreUpdateEvent(engine, elapsed, this));
        this.onPreUpdate(engine, elapsed);
    }
    /**
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     *
     * Internal _preupdate handler for {@apilink onPostUpdate} lifecycle event
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     * @internal
     */
    _postupdate(engine, elapsed) {
        this.events.emit('postupdate', new _Events__WEBPACK_IMPORTED_MODULE_17__.PostUpdateEvent(engine, elapsed, this));
        this.onPostUpdate(engine, elapsed);
    }
}
// #region Properties
/**
 * Set defaults for all Actors
 */
Actor.defaults = {
    anchor: _Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Half
};


/***/ }),

/***/ "./Camera.ts":
/*!*******************!*\
  !*** ./Camera.ts ***!
  \*******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Axis: () => (/* binding */ Axis),
/* harmony export */   Camera: () => (/* binding */ Camera),
/* harmony export */   CameraEvents: () => (/* binding */ CameraEvents),
/* harmony export */   ElasticToActorStrategy: () => (/* binding */ ElasticToActorStrategy),
/* harmony export */   LimitCameraBoundsStrategy: () => (/* binding */ LimitCameraBoundsStrategy),
/* harmony export */   LockCameraToActorAxisStrategy: () => (/* binding */ LockCameraToActorAxisStrategy),
/* harmony export */   LockCameraToActorStrategy: () => (/* binding */ LockCameraToActorStrategy),
/* harmony export */   RadiusAroundActorStrategy: () => (/* binding */ RadiusAroundActorStrategy),
/* harmony export */   StrategyContainer: () => (/* binding */ StrategyContainer)
/* harmony export */ });
/* harmony import */ var _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Util/EasingFunctions */ "./Util/EasingFunctions.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Util/Util */ "./Util/Util.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony import */ var _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Collision/BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Math/affine-matrix */ "./Math/affine-matrix.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./EventEmitter */ "./EventEmitter.ts");
/* harmony import */ var _Graphics__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Graphics */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Math/util */ "./Math/util.ts");
/* harmony import */ var _Math_watch_vector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Math/watch-vector */ "./Math/watch-vector.ts");











/**
 * Container to house convenience strategy methods
 * @internal
 */
class StrategyContainer {
    constructor(camera) {
        this.camera = camera;
    }
    /**
     * Creates and adds the {@apilink LockCameraToActorStrategy} on the current camera.
     * @param actor The actor to lock the camera to
     */
    lockToActor(actor) {
        this.camera.addStrategy(new LockCameraToActorStrategy(actor));
    }
    /**
     * Creates and adds the {@apilink LockCameraToActorAxisStrategy} on the current camera
     * @param actor The actor to lock the camera to
     * @param axis The axis to follow the actor on
     */
    lockToActorAxis(actor, axis) {
        this.camera.addStrategy(new LockCameraToActorAxisStrategy(actor, axis));
    }
    /**
     * Creates and adds the {@apilink ElasticToActorStrategy} on the current camera
     * If cameraElasticity < cameraFriction < 1.0, the behavior will be a dampened spring that will slowly end at the target without bouncing
     * If cameraFriction < cameraElasticity < 1.0, the behavior will be an oscillating spring that will over
     * correct and bounce around the target
     * @param actor Target actor to elastically follow
     * @param cameraElasticity [0 - 1.0] The higher the elasticity the more force that will drive the camera towards the target
     * @param cameraFriction [0 - 1.0] The higher the friction the more that the camera will resist motion towards the target
     */
    elasticToActor(actor, cameraElasticity, cameraFriction) {
        this.camera.addStrategy(new ElasticToActorStrategy(actor, cameraElasticity, cameraFriction));
    }
    /**
     * Creates and adds the {@apilink RadiusAroundActorStrategy} on the current camera
     * @param actor Target actor to follow when it is "radius" pixels away
     * @param radius Number of pixels away before the camera will follow
     */
    radiusAroundActor(actor, radius) {
        this.camera.addStrategy(new RadiusAroundActorStrategy(actor, radius));
    }
    /**
     * Creates and adds the {@apilink LimitCameraBoundsStrategy} on the current camera
     * @param box The bounding box to limit the camera to.
     */
    limitCameraBounds(box) {
        this.camera.addStrategy(new LimitCameraBoundsStrategy(box));
    }
}
/**
 * Camera axis enum
 */
var Axis;
(function (Axis) {
    Axis[Axis["X"] = 0] = "X";
    Axis[Axis["Y"] = 1] = "Y";
})(Axis || (Axis = {}));
/**
 * Lock a camera to the exact x/y position of an actor.
 */
class LockCameraToActorStrategy {
    constructor(target) {
        this.target = target;
        this.action = (target, camera, engine, elapsed) => {
            const center = target.center;
            return center;
        };
    }
}
/**
 * Lock a camera to a specific axis around an actor.
 */
class LockCameraToActorAxisStrategy {
    constructor(target, axis) {
        this.target = target;
        this.axis = axis;
        this.action = (target, cam, _eng, elapsed) => {
            const center = target.center;
            const currentFocus = cam.getFocus();
            if (this.axis === Axis.X) {
                return new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(center.x, currentFocus.y);
            }
            else {
                return new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(currentFocus.x, center.y);
            }
        };
    }
}
/**
 * Using [Hook's law](https://en.wikipedia.org/wiki/Hooke's_law), elastically move the camera towards the target actor.
 */
class ElasticToActorStrategy {
    /**
     * If cameraElasticity < cameraFriction < 1.0, the behavior will be a dampened spring that will slowly end at the target without bouncing
     * If cameraFriction < cameraElasticity < 1.0, the behavior will be an oscillating spring that will over
     * correct and bounce around the target
     * @param target Target actor to elastically follow
     * @param cameraElasticity [0 - 1.0] The higher the elasticity the more force that will drive the camera towards the target
     * @param cameraFriction [0 - 1.0] The higher the friction the more that the camera will resist motion towards the target
     */
    constructor(target, cameraElasticity, cameraFriction) {
        this.target = target;
        this.cameraElasticity = cameraElasticity;
        this.cameraFriction = cameraFriction;
        this.action = (target, cam, _eng, elapsed) => {
            const position = target.center;
            let focus = cam.getFocus();
            let cameraVel = cam.vel.clone();
            // Calculate the stretch vector, using the spring equation
            // F = kX
            // https://en.wikipedia.org/wiki/Hooke's_law
            // Apply to the current camera velocity
            const stretch = position.sub(focus).scale(this.cameraElasticity); // stretch is X
            cameraVel = cameraVel.add(stretch);
            // Calculate the friction (-1 to apply a force in the opposition of motion)
            // Apply to the current camera velocity
            const friction = cameraVel.scale(-1).scale(this.cameraFriction);
            cameraVel = cameraVel.add(friction);
            // Update position by velocity deltas
            focus = focus.add(cameraVel);
            return focus;
        };
    }
}
class RadiusAroundActorStrategy {
    /**
     *
     * @param target Target actor to follow when it is "radius" pixels away
     * @param radius Number of pixels away before the camera will follow
     */
    constructor(target, radius) {
        this.target = target;
        this.radius = radius;
        this.action = (target, cam, _eng, elapsed) => {
            const position = target.center;
            const focus = cam.getFocus();
            const direction = position.sub(focus);
            const distance = direction.magnitude;
            if (distance >= this.radius) {
                const offset = distance - this.radius;
                return focus.add(direction.normalize().scale(offset));
            }
            return focus;
        };
    }
}
/**
 * Prevent a camera from going beyond the given camera dimensions.
 */
class LimitCameraBoundsStrategy {
    constructor(target) {
        this.target = target;
        /**
         * Useful for limiting the camera to a {@apilink TileMap}'s dimensions, or a specific area inside the map.
         *
         * Note that this strategy does not perform any movement by itself.
         * It only sets the camera position to within the given bounds when the camera has gone beyond them.
         * Thus, it is a good idea to combine it with other camera strategies and set this strategy as the last one.
         *
         * Make sure that the camera bounds are at least as large as the viewport size.
         * @param target The bounding box to limit the camera to
         */
        this.boundSizeChecked = false; // Check and warn only once
        this.action = (target, cam, _eng, elapsed) => {
            const focus = cam.getFocus();
            if (!this.boundSizeChecked) {
                if (target.bottom - target.top < _eng.drawHeight || target.right - target.left < _eng.drawWidth) {
                    _Util_Log__WEBPACK_IMPORTED_MODULE_1__.Logger.getInstance().warn('Camera bounds should not be smaller than the engine viewport');
                }
                this.boundSizeChecked = true;
            }
            let focusX = focus.x;
            let focusY = focus.y;
            if (focus.x < target.left + _eng.halfDrawWidth) {
                focusX = target.left + _eng.halfDrawWidth;
            }
            else if (focus.x > target.right - _eng.halfDrawWidth) {
                focusX = target.right - _eng.halfDrawWidth;
            }
            if (focus.y < target.top + _eng.halfDrawHeight) {
                focusY = target.top + _eng.halfDrawHeight;
            }
            else if (focus.y > target.bottom - _eng.halfDrawHeight) {
                focusY = target.bottom - _eng.halfDrawHeight;
            }
            return (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(focusX, focusY);
        };
    }
}
const CameraEvents = {
    Initialize: 'initialize',
    PreUpdate: 'preupdate',
    PostUpdate: 'postupdate'
};
/**
 * Cameras
 *
 * {@apilink Camera} is the base class for all Excalibur cameras. Cameras are used
 * to move around your game and set focus. They are used to determine
 * what is "off screen" and can be used to scale the game.
 *
 */
class Camera {
    constructor() {
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.transform = _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_3__.AffineMatrix.identity();
        this.inverse = _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_3__.AffineMatrix.identity();
        this._cameraStrategies = [];
        this.strategy = new StrategyContainer(this);
        /**
         * Get or set current zoom of the camera, defaults to 1
         */
        this._z = 1;
        /**
         * Get or set rate of change in zoom, defaults to 0
         */
        this.dz = 0;
        /**
         * Get or set zoom acceleration
         */
        this.az = 0;
        /**
         * Current rotation of the camera
         */
        this.rotation = 0;
        this._angularVelocity = 0;
        this._posChanged = false;
        this._pos = new _Math_watch_vector__WEBPACK_IMPORTED_MODULE_4__.WatchVector(_Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero, () => {
            this._posChanged = true;
        });
        /**
         * Interpolated camera position if more draws are running than updates
         *
         * Enabled when `Engine.fixedUpdateFps` is enabled, in all other cases this will be the same as pos
         */
        this.drawPos = this.pos.clone();
        this._oldPos = this.pos.clone();
        /**
         * Get or set the camera's velocity
         */
        this.vel = _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero;
        /**
         * Get or set the camera's acceleration
         */
        this.acc = _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero;
        this._cameraMoving = false;
        this._currentLerpTime = 0;
        this._lerpDuration = 1000; // 1 second
        this._lerpStart = null;
        this._lerpEnd = null;
        //camera effects
        this._isShaking = false;
        this._shakeMagnitudeX = 0;
        this._shakeMagnitudeY = 0;
        this._shakeDuration = 0;
        this._elapsedShakeTime = 0;
        this._xShake = 0;
        this._yShake = 0;
        this._isZooming = false;
        this._zoomStart = 1;
        this._zoomEnd = 1;
        this._currentZoomTime = 0;
        this._zoomDuration = 0;
        this._zoomEasing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_5__.EasingFunctions.EaseInOutCubic;
        this._easing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_5__.EasingFunctions.EaseInOutCubic;
        this._halfWidth = 0;
        this._halfHeight = 0;
        this._viewport = null;
        this._isInitialized = false;
        this._snapPos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
    }
    get zoom() {
        return this._z;
    }
    set zoom(val) {
        this._z = val;
        if (this._engine) {
            this._halfWidth = this._engine.halfDrawWidth;
            this._halfHeight = this._engine.halfDrawHeight;
        }
    }
    /**
     * Get or set the camera's angular velocity
     */
    get angularVelocity() {
        return this._angularVelocity;
    }
    set angularVelocity(value) {
        this._angularVelocity = value;
    }
    /**
     * Get or set the camera's position
     */
    get pos() {
        return this._pos;
    }
    set pos(vec) {
        this._posChanged = true;
        this._pos = new _Math_watch_vector__WEBPACK_IMPORTED_MODULE_4__.WatchVector(vec, () => {
            this._posChanged = true;
        });
    }
    /**
     * Has the position changed since the last update
     */
    hasChanged() {
        return this._posChanged;
    }
    /**
     * Get the camera's x position
     */
    get x() {
        return this.pos.x;
    }
    /**
     * Set the camera's x position (cannot be set when following an {@apilink Actor} or when moving)
     */
    set x(value) {
        if (!this._follow && !this._cameraMoving) {
            this.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(value, this.pos.y);
        }
    }
    /**
     * Get the camera's y position
     */
    get y() {
        return this.pos.y;
    }
    /**
     * Set the camera's y position (cannot be set when following an {@apilink Actor} or when moving)
     */
    set y(value) {
        if (!this._follow && !this._cameraMoving) {
            this.pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(this.pos.x, value);
        }
    }
    /**
     * Get or set the camera's x velocity
     */
    get dx() {
        return this.vel.x;
    }
    set dx(value) {
        this.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(value, this.vel.y);
    }
    /**
     * Get or set the camera's y velocity
     */
    get dy() {
        return this.vel.y;
    }
    set dy(value) {
        this.vel = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(this.vel.x, value);
    }
    /**
     * Get or set the camera's x acceleration
     */
    get ax() {
        return this.acc.x;
    }
    set ax(value) {
        this.acc = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(value, this.acc.y);
    }
    /**
     * Get or set the camera's y acceleration
     */
    get ay() {
        return this.acc.y;
    }
    set ay(value) {
        this.acc = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(this.acc.x, value);
    }
    /**
     * Returns the focal point of the camera, a new point giving the x and y position of the camera
     */
    getFocus() {
        return this.pos;
    }
    /**
     * This moves the camera focal point to the specified position using specified easing function. Cannot move when following an Actor.
     * @param pos The target position to move to
     * @param duration The duration in milliseconds the move should last
     * @param [easingFn] An optional easing function ({@apilink EasingFunctions.EaseInOutCubic} by default)
     * @returns A {@apilink Promise} that resolves when movement is finished, including if it's interrupted.
     *          The {@apilink Promise} value is the {@apilink Vector} of the target position. It will be rejected if a move cannot be made.
     */
    move(pos, duration, easingFn = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_5__.EasingFunctions.EaseInOutCubic) {
        if (typeof easingFn !== 'function') {
            throw 'Please specify an EasingFunction';
        }
        // cannot move when following an actor
        if (this._follow) {
            return Promise.reject(pos);
        }
        // resolve existing promise, if any
        if (this._lerpPromise && this._lerpResolve) {
            this._lerpResolve(pos);
        }
        this._lerpPromise = new Promise((resolve) => {
            this._lerpResolve = resolve;
        });
        this._lerpStart = this.getFocus().clone();
        this._lerpDuration = duration;
        this._lerpEnd = pos;
        this._currentLerpTime = 0;
        this._cameraMoving = true;
        this._easing = easingFn;
        return this._lerpPromise;
    }
    /**
     * Sets the camera to shake at the specified magnitudes for the specified duration
     * @param magnitudeX  The x magnitude of the shake
     * @param magnitudeY  The y magnitude of the shake
     * @param duration    The duration of the shake in milliseconds
     */
    shake(magnitudeX, magnitudeY, duration) {
        this._isShaking = true;
        this._shakeMagnitudeX = magnitudeX;
        this._shakeMagnitudeY = magnitudeY;
        this._shakeDuration = duration;
    }
    /**
     * Zooms the camera in or out by the specified scale over the specified duration.
     * If no duration is specified, it take effect immediately.
     * @param scale    The scale of the zoom
     * @param duration The duration of the zoom in milliseconds
     */
    zoomOverTime(scale, duration = 0, easingFn = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_5__.EasingFunctions.EaseInOutCubic) {
        this._zoomPromise = new Promise((resolve) => {
            this._zoomResolve = resolve;
        });
        if (duration) {
            this._isZooming = true;
            this._zoomEasing = easingFn;
            this._currentZoomTime = 0;
            this._zoomDuration = duration;
            this._zoomStart = this.zoom;
            this._zoomEnd = scale;
        }
        else {
            this._isZooming = false;
            this.zoom = scale;
            return Promise.resolve(true);
        }
        return this._zoomPromise;
    }
    /**
     * Gets the bounding box of the viewport of this camera in world coordinates
     */
    get viewport() {
        if (this._viewport) {
            return this._viewport;
        }
        return new _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_6__.BoundingBox(0, 0, 0, 0);
    }
    /**
     * Adds a new camera strategy to this camera
     * @param cameraStrategy Instance of an {@apilink CameraStrategy}
     */
    addStrategy(cameraStrategy) {
        this._cameraStrategies.push(cameraStrategy);
    }
    /**
     * Removes a camera strategy by reference
     * @param cameraStrategy Instance of an {@apilink CameraStrategy}
     */
    removeStrategy(cameraStrategy) {
        (0,_Util_Util__WEBPACK_IMPORTED_MODULE_7__.removeItemFromArray)(cameraStrategy, this._cameraStrategies);
    }
    /**
     * Clears all camera strategies from the camera
     */
    clearAllStrategies() {
        this._cameraStrategies.length = 0;
    }
    /**
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     *
     * Internal _preupdate handler for {@apilink onPreUpdate} lifecycle event
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     * @internal
     */
    _preupdate(engine, elapsed) {
        this.events.emit('preupdate', new _Events__WEBPACK_IMPORTED_MODULE_8__.PreUpdateEvent(engine, elapsed, this));
        this.onPreUpdate(engine, elapsed);
    }
    /**
     * Safe to override onPreUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPreUpdate` is called directly before a scene is updated.
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     */
    onPreUpdate(engine, elapsed) {
        // Overridable
    }
    /**
     *  It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     *
     * Internal _preupdate handler for {@apilink onPostUpdate} lifecycle event
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     * @internal
     */
    _postupdate(engine, elapsed) {
        this.events.emit('postupdate', new _Events__WEBPACK_IMPORTED_MODULE_8__.PostUpdateEvent(engine, elapsed, this));
        this.onPostUpdate(engine, elapsed);
    }
    /**
     * Safe to override onPostUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPostUpdate` is called directly after a scene is updated.
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     */
    onPostUpdate(engine, elapsed) {
        // Overridable
    }
    get isInitialized() {
        return this._isInitialized;
    }
    _initialize(engine) {
        if (!this.isInitialized) {
            this._engine = engine;
            this._screen = engine.screen;
            const currentRes = this._screen.contentArea;
            let center = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(currentRes.width / 2, currentRes.height / 2);
            if (!this._engine.loadingComplete) {
                // If there was a loading screen, we peek the configured resolution
                const res = this._screen.peekResolution();
                if (res) {
                    center = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(res.width / 2, res.height / 2);
                }
            }
            this._halfWidth = center.x;
            this._halfHeight = center.y;
            // If the user has not set the camera pos, apply default center screen position
            if (!this._posChanged) {
                this.pos = center;
            }
            this.pos.clone(this.drawPos);
            // First frame bootstrap
            // Ensure camera tx is correct
            // Run update twice to ensure properties are init'd
            this.updateTransform(this.pos);
            // Run strategies for first frame
            this.runStrategies(engine, engine.clock.elapsed());
            // Setup the first frame viewport
            this.updateViewport();
            // It's important to update the camera after strategies
            // This prevents jitter
            this.updateTransform(this.pos);
            this.pos.clone(this._oldPos);
            this.onInitialize(engine);
            this.events.emit('initialize', new _Events__WEBPACK_IMPORTED_MODULE_8__.InitializeEvent(engine, this));
            this._isInitialized = true;
        }
    }
    /**
     * Safe to override onPostUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPostUpdate` is called directly after a scene is updated.
     */
    onInitialize(engine) {
        // Overridable
    }
    emit(eventName, event) {
        this.events.emit(eventName, event);
    }
    on(eventName, handler) {
        return this.events.on(eventName, handler);
    }
    once(eventName, handler) {
        return this.events.once(eventName, handler);
    }
    off(eventName, handler) {
        this.events.off(eventName, handler);
    }
    runStrategies(engine, elapsed) {
        for (const s of this._cameraStrategies) {
            this.pos = s.action.call(s, s.target, this, engine, elapsed);
        }
    }
    updateViewport() {
        // recalculate viewport
        this._viewport = new _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_6__.BoundingBox(this.x - this._halfWidth, this.y - this._halfHeight, this.x + this._halfWidth, this.y + this._halfHeight);
    }
    update(engine, elapsed) {
        this._initialize(engine);
        this._preupdate(engine, elapsed);
        this.pos.clone(this._oldPos);
        // Update placements based on linear algebra
        this.pos = this.pos.add(this.vel.scale(elapsed / 1000));
        this.zoom += (this.dz * elapsed) / 1000;
        this.vel = this.vel.add(this.acc.scale(elapsed / 1000));
        this.dz += (this.az * elapsed) / 1000;
        this.rotation += (this.angularVelocity * elapsed) / 1000;
        if (this._isZooming) {
            if (this._currentZoomTime < this._zoomDuration) {
                const zoomEasing = this._zoomEasing;
                const newZoom = zoomEasing(this._currentZoomTime, this._zoomStart, this._zoomEnd, this._zoomDuration);
                this.zoom = newZoom;
                this._currentZoomTime += elapsed;
            }
            else {
                this._isZooming = false;
                this.zoom = this._zoomEnd;
                this._currentZoomTime = 0;
                this._zoomResolve(true);
            }
        }
        if (this._cameraMoving) {
            if (this._currentLerpTime < this._lerpDuration) {
                const moveEasing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_5__.EasingFunctions.CreateVectorEasingFunction(this._easing);
                const lerpPoint = moveEasing(this._currentLerpTime, this._lerpStart, this._lerpEnd, this._lerpDuration);
                this.pos = lerpPoint;
                this._currentLerpTime += elapsed;
            }
            else {
                this.pos = this._lerpEnd;
                const end = this._lerpEnd.clone();
                this._lerpStart = null;
                this._lerpEnd = null;
                this._currentLerpTime = 0;
                this._cameraMoving = false;
                // Order matters here, resolve should be last so any chain promises have a clean slate
                this._lerpResolve(end);
            }
        }
        if (this._isDoneShaking()) {
            this._isShaking = false;
            this._elapsedShakeTime = 0;
            this._shakeMagnitudeX = 0;
            this._shakeMagnitudeY = 0;
            this._shakeDuration = 0;
            this._xShake = 0;
            this._yShake = 0;
        }
        else {
            this._elapsedShakeTime += elapsed;
            this._xShake = ((Math.random() * this._shakeMagnitudeX) | 0) + 1;
            this._yShake = ((Math.random() * this._shakeMagnitudeY) | 0) + 1;
        }
        this.runStrategies(engine, elapsed);
        this.updateViewport();
        // It's important to update the camera after strategies
        // This prevents jitter
        this.updateTransform(this.pos);
        this._postupdate(engine, elapsed);
        this._posChanged = false;
    }
    /**
     * Applies the relevant transformations to the game canvas to "move" or apply effects to the Camera
     * @param ctx Canvas context to apply transformations
     */
    draw(ctx) {
        // default to the current position
        this.pos.clone(this.drawPos);
        // interpolation if fixed update is on
        // must happen on the draw, because more draws are potentially happening than updates
        if (this._engine.fixedUpdateTimestep) {
            const blend = this._engine.currentFrameLagMs / this._engine.fixedUpdateTimestep;
            const interpolatedPos = this.pos.scale(blend).add(this._oldPos.scale(1.0 - blend));
            interpolatedPos.clone(this.drawPos);
            this.updateTransform(interpolatedPos);
        }
        // Snap camera to pixel
        if (ctx.snapToPixel) {
            const snapPos = this.drawPos.clone(this._snapPos);
            snapPos.x = ~~(snapPos.x + _Graphics__WEBPACK_IMPORTED_MODULE_9__.pixelSnapEpsilon * (0,_Math_util__WEBPACK_IMPORTED_MODULE_10__.sign)(snapPos.x));
            snapPos.y = ~~(snapPos.y + _Graphics__WEBPACK_IMPORTED_MODULE_9__.pixelSnapEpsilon * (0,_Math_util__WEBPACK_IMPORTED_MODULE_10__.sign)(snapPos.y));
            snapPos.clone(this.drawPos);
            this.updateTransform(snapPos);
        }
        ctx.multiply(this.transform);
    }
    updateTransform(pos) {
        // center the camera
        const newCanvasWidth = this._screen.resolution.width / this.zoom;
        const newCanvasHeight = this._screen.resolution.height / this.zoom;
        const cameraPos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(-pos.x + newCanvasWidth / 2 + this._xShake, -pos.y + newCanvasHeight / 2 + this._yShake);
        // Calculate camera transform
        this.transform.reset();
        this.transform.scale(this.zoom, this.zoom);
        // rotate about the focus
        this.transform.translate(newCanvasWidth / 2, newCanvasHeight / 2);
        this.transform.rotate(this.rotation);
        this.transform.translate(-newCanvasWidth / 2, -newCanvasHeight / 2);
        this.transform.translate(cameraPos.x, cameraPos.y);
        this.transform.inverse(this.inverse);
    }
    _isDoneShaking() {
        return !this._isShaking || this._elapsedShakeTime >= this._shakeDuration;
    }
}


/***/ }),

/***/ "./Collision/BodyComponent.ts":
/*!************************************!*\
  !*** ./Collision/BodyComponent.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BodyComponent: () => (/* binding */ BodyComponent),
/* harmony export */   DegreeOfFreedom: () => (/* binding */ DegreeOfFreedom)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _CollisionType__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EntityComponentSystem/Component */ "./EntityComponentSystem/Component.ts");
/* harmony import */ var _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Group/CollisionGroup */ "./Collision/Group/CollisionGroup.ts");
/* harmony import */ var _Id__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Id */ "./Id.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Math/util */ "./Math/util.ts");
/* harmony import */ var _ColliderComponent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ColliderComponent */ "./Collision/ColliderComponent.ts");
/* harmony import */ var _Math_transform__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Math/transform */ "./Math/transform.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../EventEmitter */ "./EventEmitter.ts");
/* harmony import */ var _PhysicsConfig__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./PhysicsConfig */ "./Collision/PhysicsConfig.ts");












var DegreeOfFreedom;
(function (DegreeOfFreedom) {
    DegreeOfFreedom["Rotation"] = "rotation";
    DegreeOfFreedom["X"] = "x";
    DegreeOfFreedom["Y"] = "y";
})(DegreeOfFreedom || (DegreeOfFreedom = {}));
/**
 * Body describes all the physical properties pos, vel, acc, rotation, angular velocity for the purpose of
 * of physics simulation.
 */
class BodyComponent extends _EntityComponentSystem_Component__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(options) {
        var _a, _b, _c;
        super();
        this.dependencies = [_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent, _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent];
        this.id = (0,_Id__WEBPACK_IMPORTED_MODULE_3__.createId)('body', BodyComponent._ID++);
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
        this.oldTransform = new _Math_transform__WEBPACK_IMPORTED_MODULE_5__.Transform();
        /**
         * Indicates whether the old transform has been captured at least once for interpolation
         * @internal
         */
        this.__oldTransformCaptured = false;
        /**
         * Enable or disabled the fixed update interpolation, by default interpolation is on.
         */
        this.enableFixedUpdateInterpolate = true;
        /**
         * Collision type for the rigidbody physics simulation, by default {@apilink CollisionType.PreventCollision}
         */
        this.collisionType = _CollisionType__WEBPACK_IMPORTED_MODULE_6__.CollisionType.PreventCollision;
        /**
         * The collision group for the body's colliders, by default body colliders collide with everything
         */
        this.group = _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_7__.CollisionGroup.All;
        this._sleeping = false;
        /**
         * The also known as coefficient of restitution of this actor, represents the amount of energy preserved after collision or the
         * bounciness. If 1, it is 100% bouncy, 0 it completely absorbs.
         */
        this.bounciness = 0.2;
        /**
         * The coefficient of friction on this actor.
         *
         * The {@apilink SolverStrategy.Arcade} does not support this property.
         *
         */
        this.friction = 0.99;
        /**
         * Should use global gravity {@apilink Physics.gravity} in it's physics simulation, default is true
         */
        this.useGravity = true;
        /**
         * Degrees of freedom to limit
         *
         * Note: this only limits responses in the realistic solver, if velocity/angularVelocity is set the actor will still respond
         */
        this.limitDegreeOfFreedom = [];
        this._oldGlobalPos = _Math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector.Zero;
        /**
         * The velocity of the actor last frame (vx, vy) in pixels/second
         */
        this.oldVel = new _Math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector(0, 0);
        /**
         * Gets/sets the acceleration of the actor from the last frame. This does not include the global acc {@apilink Physics.acc}.
         */
        this.oldAcc = _Math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector.Zero;
        this._impulseScratch = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_8__.vec)(0, 0);
        this._distanceFromCenterScratch = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_8__.vec)(0, 0);
        if (options) {
            this.collisionType = (_a = options.type) !== null && _a !== void 0 ? _a : this.collisionType;
            this.group = (_b = options.group) !== null && _b !== void 0 ? _b : this.group;
            this.useGravity = (_c = options.useGravity) !== null && _c !== void 0 ? _c : this.useGravity;
            this._bodyConfig = {
                ...(0,_PhysicsConfig__WEBPACK_IMPORTED_MODULE_9__.getDefaultPhysicsConfig)().bodies,
                ...options.config
            };
        }
        else {
            this._bodyConfig = {
                ...(0,_PhysicsConfig__WEBPACK_IMPORTED_MODULE_9__.getDefaultPhysicsConfig)().bodies
            };
        }
        this.updatePhysicsConfig(this._bodyConfig);
        this._mass = BodyComponent._DEFAULT_CONFIG.defaultMass;
    }
    get matrix() {
        return this.transform.get().matrix;
    }
    /**
     * Called by excalibur to update physics config defaults if they change
     * @param config
     */
    updatePhysicsConfig(config) {
        this._bodyConfig = {
            ...(0,_PhysicsConfig__WEBPACK_IMPORTED_MODULE_9__.getDefaultPhysicsConfig)().bodies,
            ...config
        };
        this.canSleep = this._bodyConfig.canSleepByDefault;
        this.sleepMotion = this._bodyConfig.sleepEpsilon * 5;
        this.wakeThreshold = this._bodyConfig.wakeThreshold;
    }
    /**
     * Called by excalibur to update defaults
     * @param config
     */
    static updateDefaultPhysicsConfig(config) {
        BodyComponent._DEFAULT_CONFIG = config;
    }
    get mass() {
        return this._mass;
    }
    set mass(newMass) {
        this._mass = newMass;
        this._cachedInertia = undefined;
        this._cachedInverseInertia = undefined;
    }
    /**
     * The inverse mass (1/mass) of the body. If {@apilink CollisionType.Fixed} this is 0, meaning "infinite" mass
     */
    get inverseMass() {
        return this.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_6__.CollisionType.Fixed ? 0 : 1 / this.mass;
    }
    /**
     * Whether this body is sleeping or not
     * @deprecated use isSleeping
     */
    get sleeping() {
        return this.isSleeping;
    }
    /**
     * Whether this body is sleeping or not
     */
    get isSleeping() {
        return this._sleeping;
    }
    /**
     * Set the sleep state of the body
     * @param sleeping
     * @deprecated use isSleeping
     */
    setSleeping(sleeping) {
        this.isSleeping = sleeping;
    }
    set isSleeping(sleeping) {
        this._sleeping = sleeping;
        if (!sleeping) {
            // Give it a kick to keep it from falling asleep immediately
            this.sleepMotion = this._bodyConfig.sleepEpsilon * 5;
        }
        else {
            this.vel = _Math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector.Zero;
            this.acc = _Math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector.Zero;
            this.angularVelocity = 0;
            this.sleepMotion = 0;
        }
    }
    /**
     * Update body's {@apilink BodyComponent.sleepMotion} for the purpose of sleeping
     */
    updateMotion() {
        if (this._sleeping) {
            this.isSleeping = true;
        }
        const currentMotion = this.vel.magnitude * this.vel.magnitude + Math.abs(this.angularVelocity * this.angularVelocity);
        const bias = this._bodyConfig.sleepBias;
        this.sleepMotion = bias * this.sleepMotion + (1 - bias) * currentMotion;
        this.sleepMotion = (0,_Math_util__WEBPACK_IMPORTED_MODULE_10__.clamp)(this.sleepMotion, 0, 10 * this._bodyConfig.sleepEpsilon);
        if (this.canSleep && this.sleepMotion < this._bodyConfig.sleepEpsilon) {
            this.isSleeping = true;
        }
    }
    /**
     * Get the moment of inertia from the {@apilink ColliderComponent}
     */
    get inertia() {
        if (this._cachedInertia) {
            return this._cachedInertia;
        }
        // Inertia is a property of the geometry, so this is a little goofy but seems to be okay?
        const collider = this.owner.get(_ColliderComponent__WEBPACK_IMPORTED_MODULE_11__.ColliderComponent);
        if (collider) {
            collider.$colliderAdded.subscribe(() => {
                this._cachedInertia = null;
            });
            collider.$colliderRemoved.subscribe(() => {
                this._cachedInertia = null;
            });
            const maybeCollider = collider.get();
            if (maybeCollider) {
                return (this._cachedInertia = maybeCollider.getInertia(this.mass));
            }
        }
        return 0;
    }
    /**
     * Get the inverse moment of inertial from the {@apilink ColliderComponent}. If {@apilink CollisionType.Fixed} this is 0, meaning "infinite" mass
     */
    get inverseInertia() {
        if (this._cachedInverseInertia) {
            return this._cachedInverseInertia;
        }
        return (this._cachedInverseInertia = this.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_6__.CollisionType.Fixed ? 0 : 1 / this.inertia);
    }
    /**
     * Returns if the owner is active
     * @deprecated use isActive
     */
    get active() {
        var _a;
        return !!((_a = this.owner) === null || _a === void 0 ? void 0 : _a.isActive);
    }
    /**
     * Returns if the owner is active
     */
    get isActive() {
        var _a;
        return !!((_a = this.owner) === null || _a === void 0 ? void 0 : _a.isActive);
    }
    /**
     * @deprecated Use globalPos
     */
    get center() {
        return this.globalPos;
    }
    onAdd(owner) {
        var _a, _b;
        this.transform = (_a = this.owner) === null || _a === void 0 ? void 0 : _a.get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
        this.motion = (_b = this.owner) === null || _b === void 0 ? void 0 : _b.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
    }
    get pos() {
        return this.transform.pos;
    }
    set pos(val) {
        this.transform.pos = val;
    }
    /**
     * The (x, y) position of the actor this will be in the middle of the actor if the
     * {@apilink Actor.anchor} is set to (0.5, 0.5) which is default.
     * If you want the (x, y) position to be the top left of the actor specify an anchor of (0, 0).
     */
    get globalPos() {
        return this.transform.globalPos;
    }
    set globalPos(val) {
        this.transform.globalPos = val;
    }
    /**
     * The position of the actor last frame (x, y) in pixels
     */
    get oldPos() {
        return this.oldTransform.pos;
    }
    /**
     * The global position of the actor last frame (x, y) in pixels
     */
    get oldGlobalPos() {
        return this._oldGlobalPos;
    }
    /**
     * The current velocity vector (vx, vy) of the actor in pixels/second
     */
    get vel() {
        return this.motion.vel;
    }
    set vel(val) {
        this.motion.vel = val;
    }
    /**
     * The current acceleration vector (ax, ay) of the actor in pixels/second/second. An acceleration pointing down such as (0, 100) may
     * be useful to simulate a gravitational effect.
     */
    get acc() {
        return this.motion.acc;
    }
    set acc(val) {
        this.motion.acc = val;
    }
    /**
     * The current torque applied to the actor
     */
    get torque() {
        return this.motion.torque;
    }
    set torque(val) {
        this.motion.torque = val;
    }
    /**
     * Gets/sets the rotation of the body from the last frame.
     */
    get oldRotation() {
        return this.oldTransform.rotation;
    }
    /**
     * The rotation of the body in radians
     */
    get rotation() {
        return this.transform.globalRotation;
    }
    set rotation(val) {
        this.transform.globalRotation = val;
    }
    /**
     * The scale vector of the actor
     */
    get scale() {
        return this.transform.globalScale;
    }
    set scale(val) {
        this.transform.globalScale = val;
    }
    /**
     * The scale of the actor last frame
     */
    get oldScale() {
        return this.oldTransform.scale;
    }
    /**
     * The scale rate of change of the actor in scale/second
     */
    get scaleFactor() {
        return this.motion.scaleFactor;
    }
    set scaleFactor(scaleFactor) {
        this.motion.scaleFactor = scaleFactor;
    }
    /**
     * Get the angular velocity in radians/second
     */
    get angularVelocity() {
        return this.motion.angularVelocity;
    }
    /**
     * Set the angular velocity in radians/second
     */
    set angularVelocity(value) {
        this.motion.angularVelocity = value;
    }
    /**
     * Apply a specific impulse to the body
     * @param point
     * @param impulse
     */
    applyImpulse(point, impulse) {
        if (this.collisionType !== _CollisionType__WEBPACK_IMPORTED_MODULE_6__.CollisionType.Active) {
            return; // only active objects participate in the simulation
        }
        const finalImpulse = impulse.scale(this.inverseMass, this._impulseScratch);
        if (this.limitDegreeOfFreedom.indexOf(DegreeOfFreedom.X) > -1) {
            finalImpulse.x = 0;
        }
        if (this.limitDegreeOfFreedom.indexOf(DegreeOfFreedom.Y) > -1) {
            finalImpulse.y = 0;
        }
        this.vel.addEqual(finalImpulse);
        if (!this.limitDegreeOfFreedom.includes(DegreeOfFreedom.Rotation)) {
            const distanceFromCenter = point.sub(this.globalPos, this._distanceFromCenterScratch);
            this.angularVelocity += this.inverseInertia * distanceFromCenter.cross(impulse);
        }
    }
    /**
     * Apply only linear impulse to the body
     * @param impulse
     */
    applyLinearImpulse(impulse) {
        if (this.collisionType !== _CollisionType__WEBPACK_IMPORTED_MODULE_6__.CollisionType.Active) {
            return; // only active objects participate in the simulation
        }
        const finalImpulse = impulse.scale(this.inverseMass);
        if (this.limitDegreeOfFreedom.includes(DegreeOfFreedom.X)) {
            finalImpulse.x = 0;
        }
        if (this.limitDegreeOfFreedom.includes(DegreeOfFreedom.Y)) {
            finalImpulse.y = 0;
        }
        this.vel = this.vel.add(finalImpulse);
    }
    /**
     * Apply only angular impulse to the body
     * @param point
     * @param impulse
     */
    applyAngularImpulse(point, impulse) {
        if (this.collisionType !== _CollisionType__WEBPACK_IMPORTED_MODULE_6__.CollisionType.Active) {
            return; // only active objects participate in the simulation
        }
        if (!this.limitDegreeOfFreedom.includes(DegreeOfFreedom.Rotation)) {
            const distanceFromCenter = point.sub(this.globalPos);
            this.angularVelocity += this.inverseInertia * distanceFromCenter.cross(impulse);
        }
    }
    /**
     * Sets the old versions of pos, vel, acc, and scale.
     */
    captureOldTransform() {
        // Capture old values before integration step updates them
        this.__oldTransformCaptured = true;
        const tx = this.transform.get();
        tx.clone(this.oldTransform);
        this.oldTransform.parent = tx.parent; // also grab parent
        this.oldVel.setTo(this.vel.x, this.vel.y);
        this.oldAcc.setTo(this.acc.x, this.acc.y);
        this.oldGlobalPos.setTo(this.globalPos.x, this.globalPos.y);
    }
    clone() {
        const component = super.clone();
        return component;
    }
}
BodyComponent._ID = 0;
BodyComponent._DEFAULT_CONFIG = {
    ...(0,_PhysicsConfig__WEBPACK_IMPORTED_MODULE_9__.getDefaultPhysicsConfig)().bodies
};


/***/ }),

/***/ "./Collision/BoundingBox.ts":
/*!**********************************!*\
  !*** ./Collision/BoundingBox.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BoundingBox: () => (/* binding */ BoundingBox)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Color */ "./Color.ts");
/* harmony import */ var _Side__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Side */ "./Collision/Side.ts");



/**
 * Axis Aligned collision primitive for Excalibur.
 */
class BoundingBox {
    /**
     * Constructor allows passing of either an object with all coordinate components,
     * or the coordinate components passed separately.
     * @param leftOrOptions    Either x coordinate of the left edge or an options object
     * containing the four coordinate components.
     * @param top     y coordinate of the top edge
     * @param right   x coordinate of the right edge
     * @param bottom  y coordinate of the bottom edge
     */
    constructor(leftOrOptions = 0, top = 0, right = 0, bottom = 0) {
        // Cache bounding box point returns
        this._points = [];
        if (typeof leftOrOptions === 'object') {
            this.left = leftOrOptions.left;
            this.top = leftOrOptions.top;
            this.right = leftOrOptions.right;
            this.bottom = leftOrOptions.bottom;
        }
        else if (typeof leftOrOptions === 'number') {
            this.left = leftOrOptions;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }
    /**
     * Returns a new instance of {@apilink BoundingBox} that is a copy of the current instance
     */
    clone(dest) {
        const result = dest || new BoundingBox(0, 0, 0, 0);
        result.left = this.left;
        result.right = this.right;
        result.top = this.top;
        result.bottom = this.bottom;
        return result;
    }
    /**
     * Resets the bounds to a zero width/height box
     */
    reset() {
        this.left = 0;
        this.top = 0;
        this.bottom = 0;
        this.right = 0;
    }
    /**
     * Given bounding box A & B, returns the side relative to A when intersection is performed.
     * @param intersection Intersection vector between 2 bounding boxes
     */
    static getSideFromIntersection(intersection) {
        if (!intersection) {
            return _Side__WEBPACK_IMPORTED_MODULE_0__.Side.None;
        }
        if (intersection) {
            if (Math.abs(intersection.x) > Math.abs(intersection.y)) {
                if (intersection.x < 0) {
                    return _Side__WEBPACK_IMPORTED_MODULE_0__.Side.Right;
                }
                return _Side__WEBPACK_IMPORTED_MODULE_0__.Side.Left;
            }
            else {
                if (intersection.y < 0) {
                    return _Side__WEBPACK_IMPORTED_MODULE_0__.Side.Bottom;
                }
                return _Side__WEBPACK_IMPORTED_MODULE_0__.Side.Top;
            }
        }
        return _Side__WEBPACK_IMPORTED_MODULE_0__.Side.None;
    }
    static fromPoints(points) {
        let minX = Infinity;
        let minY = Infinity;
        let maxX = -Infinity;
        let maxY = -Infinity;
        for (let i = 0; i < points.length; i++) {
            if (points[i].x < minX) {
                minX = points[i].x;
            }
            if (points[i].x > maxX) {
                maxX = points[i].x;
            }
            if (points[i].y < minY) {
                minY = points[i].y;
            }
            if (points[i].y > maxY) {
                maxY = points[i].y;
            }
        }
        return new BoundingBox(minX, minY, maxX, maxY);
    }
    /**
     * Creates a bounding box from a width and height
     * @param width
     * @param height
     * @param anchor Default Vector.Half
     * @param pos Default Vector.Zero
     */
    static fromDimension(width, height, anchor = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Half, pos = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero) {
        return new BoundingBox(-width * anchor.x + pos.x, -height * anchor.y + pos.y, width - width * anchor.x + pos.x, height - height * anchor.y + pos.y);
    }
    /**
     * Returns the calculated width of the bounding box
     */
    get width() {
        return this.right - this.left;
    }
    /**
     * Returns the calculated height of the bounding box
     */
    get height() {
        return this.bottom - this.top;
    }
    /**
     * Return whether the bounding box has zero dimensions in height,width or both
     */
    hasZeroDimensions() {
        return this.width === 0 || this.height === 0;
    }
    /**
     * Returns the center of the bounding box
     */
    get center() {
        return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector((this.left + this.right) / 2, (this.top + this.bottom) / 2);
    }
    get topLeft() {
        return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this.left, this.top);
    }
    get bottomRight() {
        return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this.right, this.bottom);
    }
    get topRight() {
        return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this.right, this.top);
    }
    get bottomLeft() {
        return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this.left, this.bottom);
    }
    translate(pos) {
        return new BoundingBox(this.left + pos.x, this.top + pos.y, this.right + pos.x, this.bottom + pos.y);
    }
    /**
     * Rotates a bounding box by and angle and around a point, if no point is specified (0, 0) is used by default. The resulting bounding
     * box is also axis-align. This is useful when a new axis-aligned bounding box is needed for rotated geometry.
     */
    rotate(angle, point = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero) {
        const points = this.getPoints().map((p) => p.rotate(angle, point));
        return BoundingBox.fromPoints(points);
    }
    /**
     * Scale a bounding box by a scale factor, optionally provide a point
     * @param scale
     * @param point
     */
    scale(scale, point = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero) {
        const shifted = this.translate(point);
        return new BoundingBox(shifted.left * scale.x, shifted.top * scale.y, shifted.right * scale.x, shifted.bottom * scale.y);
    }
    /**
     * Transform the axis aligned bounding box by a {@apilink Matrix}, producing a new axis aligned bounding box
     * @param matrix
     */
    transform(matrix) {
        // inlined these calculations to not use vectors would speed it up slightly
        // const matFirstColumn = vec(matrix.data[0], matrix.data[1]);
        // const xa = matFirstColumn.scale(this.left);
        const xa1 = matrix.data[0] * this.left;
        const xa2 = matrix.data[1] * this.left;
        // const xb = matFirstColumn.scale(this.right);
        const xb1 = matrix.data[0] * this.right;
        const xb2 = matrix.data[1] * this.right;
        // const matSecondColumn = vec(matrix.data[2], matrix.data[3]);
        // const ya = matSecondColumn.scale(this.top);
        const ya1 = matrix.data[2] * this.top;
        const ya2 = matrix.data[3] * this.top;
        // const yb = matSecondColumn.scale(this.bottom);
        const yb1 = matrix.data[2] * this.bottom;
        const yb2 = matrix.data[3] * this.bottom;
        const matrixPos = matrix.getPosition();
        // const topLeft = Vector.min(xa, xb).add(Vector.min(ya, yb)).add(matrixPos);
        // const bottomRight = Vector.max(xa, xb).add(Vector.max(ya, yb)).add(matrixPos);
        const left = Math.min(xa1, xb1) + Math.min(ya1, yb1) + matrixPos.x;
        const top = Math.min(xa2, xb2) + Math.min(ya2, yb2) + matrixPos.y;
        const right = Math.max(xa1, xb1) + Math.max(ya1, yb1) + matrixPos.x;
        const bottom = Math.max(xa2, xb2) + Math.max(ya2, yb2) + matrixPos.y;
        return new BoundingBox({
            left, //: topLeft.x,
            top, //: topLeft.y,
            right, //: bottomRight.x,
            bottom //: bottomRight.y
        });
    }
    /**
     * Returns the perimeter of the bounding box
     */
    getPerimeter() {
        const wx = this.width;
        const wy = this.height;
        return 2 * (wx + wy);
    }
    /**
     * Returns the world space points that make up the corners of the bounding box as a polygon
     */
    getPoints() {
        if (this._left !== this.left || this._right !== this.right || this._top !== this.top || this._bottom !== this.bottom) {
            this._points.length = 0;
            this._points.push(new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this.left, this.top));
            this._points.push(new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this.right, this.top));
            this._points.push(new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this.right, this.bottom));
            this._points.push(new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this.left, this.bottom));
            this._left = this.left;
            this._right = this.right;
            this._top = this.top;
            this._bottom = this.bottom;
        }
        return this._points;
    }
    /**
     * Determines whether a ray intersects with a bounding box
     */
    rayCast(ray, farClipDistance = Infinity) {
        // algorithm from https://tavianator.com/fast-branchless-raybounding-box-intersections/
        let tMin = -Infinity;
        let tMax = +Infinity;
        const xInv = ray.dir.x === 0 ? Number.MAX_VALUE : 1 / ray.dir.x;
        const yInv = ray.dir.y === 0 ? Number.MAX_VALUE : 1 / ray.dir.y;
        const tx1 = (this.left - ray.pos.x) * xInv;
        const tx2 = (this.right - ray.pos.x) * xInv;
        tMin = Math.min(tx1, tx2);
        tMax = Math.max(tx1, tx2);
        const ty1 = (this.top - ray.pos.y) * yInv;
        const ty2 = (this.bottom - ray.pos.y) * yInv;
        tMin = Math.max(tMin, Math.min(ty1, ty2));
        tMax = Math.min(tMax, Math.max(ty1, ty2));
        return tMax >= Math.max(0, tMin) && tMin < farClipDistance;
    }
    rayCastTime(ray, farClipDistance = Infinity) {
        // algorithm from https://tavianator.com/fast-branchless-raybounding-box-intersections/
        let tMin = -Infinity;
        let tMax = +Infinity;
        const xInv = ray.dir.x === 0 ? Number.MAX_VALUE : 1 / ray.dir.x;
        const yInv = ray.dir.y === 0 ? Number.MAX_VALUE : 1 / ray.dir.y;
        const tx1 = (this.left - ray.pos.x) * xInv;
        const tx2 = (this.right - ray.pos.x) * xInv;
        tMin = Math.min(tx1, tx2);
        tMax = Math.max(tx1, tx2);
        const ty1 = (this.top - ray.pos.y) * yInv;
        const ty2 = (this.bottom - ray.pos.y) * yInv;
        tMin = Math.max(tMin, Math.min(ty1, ty2));
        tMax = Math.min(tMax, Math.max(ty1, ty2));
        if (tMax >= Math.max(0, tMin) && tMin < farClipDistance) {
            return tMin;
        }
        return -1;
    }
    contains(val) {
        if (val instanceof _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector) {
            return this.left <= val.x && this.top <= val.y && val.y <= this.bottom && val.x <= this.right;
        }
        else if (val instanceof BoundingBox) {
            return this.left <= val.left && this.top <= val.top && val.bottom <= this.bottom && val.right <= this.right;
        }
        return false;
    }
    /**
     * Combines this bounding box and another together returning a new bounding box
     * @param other  The bounding box to combine
     */
    combine(other, dest) {
        const compositeBB = dest || new BoundingBox(0, 0, 0, 0);
        const left = Math.min(this.left, other.left);
        const top = Math.min(this.top, other.top);
        const right = Math.max(this.right, other.right);
        const bottom = Math.max(this.bottom, other.bottom);
        compositeBB.left = left;
        compositeBB.top = top;
        compositeBB.right = right;
        compositeBB.bottom = bottom;
        return compositeBB;
    }
    get dimensions() {
        return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(this.width, this.height);
    }
    /**
     * Returns true if the bounding boxes overlap.
     * @param other
     * @param epsilon Optionally specify a small epsilon (default 0) as amount of overlap to ignore as overlap.
     * This epsilon is useful in stable collision simulations.
     */
    overlaps(other, epsilon) {
        const e = epsilon || 0;
        if (other.hasZeroDimensions()) {
            return this.contains(other);
        }
        if (this.hasZeroDimensions()) {
            return other.contains(this);
        }
        const totalBoundingBox = this.combine(other);
        return totalBoundingBox.width + e < other.width + this.width && totalBoundingBox.height + e < other.height + this.height;
    }
    /**
     * Test wether this bounding box intersects with another returning
     * the intersection vector that can be used to resolve the collision. If there
     * is no intersection null is returned.
     * @param other  Other {@apilink BoundingBox} to test intersection with
     * @returns A Vector in the direction of the current BoundingBox, this <- other
     */
    intersect(other) {
        const totalBoundingBox = this.combine(other);
        // If the total bounding box is less than or equal the sum of the 2 bounds then there is collision
        if (totalBoundingBox.width < other.width + this.width &&
            totalBoundingBox.height < other.height + this.height &&
            !totalBoundingBox.dimensions.equals(other.dimensions) &&
            !totalBoundingBox.dimensions.equals(this.dimensions)) {
            // collision
            let overlapX = 0;
            // right edge is between the other's left and right edge
            /**
             *     +-this-+
             *     |      |
             *     |    +-other-+
             *     +----|-+     |
             *          |       |
             *          +-------+
             *         <---
             *          ^ overlap
             */
            if (this.right >= other.left && this.right <= other.right) {
                overlapX = other.left - this.right;
                // right edge is past the other's right edge
                /**
                 *     +-other-+
                 *     |       |
                 *     |    +-this-+
                 *     +----|--+   |
                 *          |      |
                 *          +------+
                 *          --->
                 *          ^ overlap
                 */
            }
            else {
                overlapX = other.right - this.left;
            }
            let overlapY = 0;
            // top edge is between the other's top and bottom edge
            /**
             *     +-other-+
             *     |       |
             *     |    +-this-+   | <- overlap
             *     +----|--+   |   |
             *          |      |  \ /
             *          +------+   '
             */
            if (this.top <= other.bottom && this.top >= other.top) {
                overlapY = other.bottom - this.top;
                // top edge is above the other top edge
                /**
                 *     +-this-+         .
                 *     |      |        / \
                 *     |    +-other-+   | <- overlap
                 *     +----|-+     |   |
                 *          |       |
                 *          +-------+
                 */
            }
            else {
                overlapY = other.top - this.bottom;
            }
            if (Math.abs(overlapX) < Math.abs(overlapY)) {
                return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(overlapX, 0);
            }
            else {
                return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(0, overlapY);
            }
            // Case of total containment of one bounding box by another
        }
        else if (totalBoundingBox.dimensions.equals(other.dimensions) || totalBoundingBox.dimensions.equals(this.dimensions)) {
            let overlapX = 0;
            // this is wider than the other
            if (this.width - other.width >= 0) {
                // This right edge is closest to the others right edge
                if (this.right - other.right <= other.left - this.left) {
                    overlapX = other.left - this.right;
                    // This left edge is closest to the others left edge
                }
                else {
                    overlapX = other.right - this.left;
                }
                // other is wider than this
            }
            else {
                // This right edge is closest to the others right edge
                if (other.right - this.right <= this.left - other.left) {
                    overlapX = this.left - other.right;
                    // This left edge is closest to the others left edge
                }
                else {
                    overlapX = this.right - other.left;
                }
            }
            let overlapY = 0;
            // this is taller than other
            if (this.height - other.height >= 0) {
                // The bottom edge is closest to the others bottom edge
                if (this.bottom - other.bottom <= other.top - this.top) {
                    overlapY = other.top - this.bottom;
                }
                else {
                    overlapY = other.bottom - this.top;
                }
                // other is taller than this
            }
            else {
                // The bottom edge is closest to the others bottom edge
                if (other.bottom - this.bottom <= this.top - other.top) {
                    overlapY = this.top - other.bottom;
                }
                else {
                    overlapY = this.bottom - other.top;
                }
            }
            if (Math.abs(overlapX) < Math.abs(overlapY)) {
                return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(overlapX, 0);
            }
            else {
                return new _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector(0, overlapY);
            }
        }
        else {
            return null;
        }
    }
    /**
     * Test whether the bounding box has intersected with another bounding box, returns the side of the current bb that intersected.
     * @param bb The other actor to test
     */
    intersectWithSide(bb) {
        const intersect = this.intersect(bb);
        return BoundingBox.getSideFromIntersection(intersect);
    }
    /**
     * Draw a debug bounding box
     * @param ex
     * @param color
     */
    draw(ex, color = _Color__WEBPACK_IMPORTED_MODULE_2__.Color.Yellow) {
        ex.debug.drawRect(this.left, this.top, this.width, this.height, { color });
    }
}


/***/ }),

/***/ "./Collision/ColliderComponent.ts":
/*!****************************************!*\
  !*** ./Collision/ColliderComponent.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColliderComponent: () => (/* binding */ ColliderComponent)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../EntityComponentSystem */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _EntityComponentSystem_Component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EntityComponentSystem/Component */ "./EntityComponentSystem/Component.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Events */ "./Events.ts");
/* harmony import */ var _Util_Observable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util/Observable */ "./Util/Observable.ts");
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Colliders/CompositeCollider */ "./Collision/Colliders/CompositeCollider.ts");
/* harmony import */ var _Colliders_Shape__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Colliders/Shape */ "./Collision/Colliders/Shape.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../EventEmitter */ "./EventEmitter.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Actor */ "./Actor.ts");










class ColliderComponent extends _EntityComponentSystem_Component__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(collider) {
        super();
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        /**
         * Observable that notifies when a collider is added to the body
         */
        this.$colliderAdded = new _Util_Observable__WEBPACK_IMPORTED_MODULE_2__.Observable();
        /**
         * Observable that notifies when a collider is removed from the body
         */
        this.$colliderRemoved = new _Util_Observable__WEBPACK_IMPORTED_MODULE_2__.Observable();
        this._collidersToRemove = [];
        this.set(collider);
    }
    /**
     * Get the current collider geometry
     */
    get() {
        return this._collider;
    }
    /**
     * Set the collider geometry
     * @param collider
     * @returns the collider you set
     */
    set(collider) {
        this.clear();
        if (collider) {
            this._collider = collider;
            this._collider.owner = this.owner;
            collider.events.pipe(this.events);
            this.$colliderAdded.notifyAll(collider);
            this.update();
        }
        return collider;
    }
    /**
     * Remove collider geometry from collider component
     */
    clear() {
        if (this._collider) {
            this._collidersToRemove.push(this._collider);
            this._collider = null;
        }
    }
    processColliderRemoval() {
        for (const collider of this._collidersToRemove) {
            collider.events.unpipe(this.events);
            this.$colliderRemoved.notifyAll(collider);
            collider.owner = null;
        }
    }
    clone() {
        const clone = new ColliderComponent(this._collider.clone());
        return clone;
    }
    /**
     * Return world space bounds
     */
    get bounds() {
        var _a, _b;
        return (_b = (_a = this._collider) === null || _a === void 0 ? void 0 : _a.bounds) !== null && _b !== void 0 ? _b : new _BoundingBox__WEBPACK_IMPORTED_MODULE_3__.BoundingBox();
    }
    /**
     * Return local space bounds
     */
    get localBounds() {
        var _a, _b;
        return (_b = (_a = this._collider) === null || _a === void 0 ? void 0 : _a.localBounds) !== null && _b !== void 0 ? _b : new _BoundingBox__WEBPACK_IMPORTED_MODULE_3__.BoundingBox();
    }
    /**
     * Update the collider's transformed geometry
     */
    update() {
        var _a;
        const tx = (_a = this.owner) === null || _a === void 0 ? void 0 : _a.get(_EntityComponentSystem__WEBPACK_IMPORTED_MODULE_4__.TransformComponent);
        if (this._collider) {
            this._collider.owner = this.owner;
            if (tx) {
                this._collider.update(tx.get());
            }
        }
    }
    /**
     * Collide component with another
     * @param other
     */
    collide(other) {
        let colliderA = this._collider;
        let colliderB = other._collider;
        if (!colliderA || !colliderB) {
            return [];
        }
        // If we have a composite left hand side :(
        // Might bite us, but to avoid updating all the handlers make composite always left side
        let flipped = false;
        if (colliderB instanceof _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_5__.CompositeCollider) {
            colliderA = colliderB;
            colliderB = this._collider;
            flipped = true;
        }
        if (this._collider) {
            const contacts = colliderA.collide(colliderB);
            if (contacts) {
                if (flipped) {
                    contacts.forEach((contact) => {
                        contact.mtv = contact.mtv.negate();
                        contact.normal = contact.normal.negate();
                        contact.tangent = contact.normal.perpendicular();
                        contact.colliderA = this._collider;
                        contact.colliderB = other._collider;
                    });
                }
                return contacts;
            }
            return [];
        }
        return [];
    }
    onAdd(entity) {
        if (this._collider) {
            this.update();
        }
        // Wire up the collider events to the owning entity
        this.events.on('precollision', (evt) => {
            const precollision = evt;
            entity.events.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_6__.PreCollisionEvent(precollision.self, precollision.other, precollision.side, precollision.intersection, precollision.contact));
            if (entity instanceof _Actor__WEBPACK_IMPORTED_MODULE_7__.Actor) {
                entity.onPreCollisionResolve(precollision.self, precollision.other, precollision.side, precollision.contact);
            }
        });
        this.events.on('postcollision', (evt) => {
            const postcollision = evt;
            entity.events.emit('postcollision', new _Events__WEBPACK_IMPORTED_MODULE_6__.PostCollisionEvent(postcollision.self, postcollision.other, postcollision.side, postcollision.intersection, postcollision.contact));
            if (entity instanceof _Actor__WEBPACK_IMPORTED_MODULE_7__.Actor) {
                entity.onPostCollisionResolve(postcollision.self, postcollision.other, postcollision.side, postcollision.contact);
            }
        });
        this.events.on('collisionstart', (evt) => {
            const start = evt;
            entity.events.emit('collisionstart', new _Events__WEBPACK_IMPORTED_MODULE_6__.CollisionStartEvent(start.self, start.other, start.side, start.contact));
            if (entity instanceof _Actor__WEBPACK_IMPORTED_MODULE_7__.Actor) {
                entity.onCollisionStart(start.self, start.other, start.side, start.contact);
            }
        });
        this.events.on('collisionend', (evt) => {
            const end = evt;
            entity.events.emit('collisionend', new _Events__WEBPACK_IMPORTED_MODULE_6__.CollisionEndEvent(end.self, end.other, end.side, end.lastContact));
            if (entity instanceof _Actor__WEBPACK_IMPORTED_MODULE_7__.Actor) {
                entity.onCollisionEnd(end.self, end.other, end.side, end.lastContact);
            }
        });
    }
    onRemove() {
        this.events.clear();
        this.$colliderRemoved.notifyAll(this._collider);
    }
    /**
     * Sets up a box geometry based on the current bounds of the associated actor of this physics body.
     *
     * If no width/height are specified the body will attempt to use the associated actor's width/height.
     *
     * By default, the box is center is at (0, 0) which means it is centered around the actors anchor.
     */
    useBoxCollider(width, height, anchor = _Math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector.Half, center = _Math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector.Zero) {
        const collider = _Colliders_Shape__WEBPACK_IMPORTED_MODULE_9__.Shape.Box(width, height, anchor, center);
        return this.set(collider);
    }
    /**
     * Sets up a {@apilink PolygonCollider | `polygon`} collision geometry based on a list of of points relative
     *  to the anchor of the associated actor
     * of this physics body.
     *
     * Only [convex polygon](https://en.wikipedia.org/wiki/Convex_polygon) definitions are supported.
     *
     * By default, the box is center is at (0, 0) which means it is centered around the actors anchor.
     */
    usePolygonCollider(points, center = _Math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector.Zero) {
        const poly = _Colliders_Shape__WEBPACK_IMPORTED_MODULE_9__.Shape.Polygon(points, center);
        return this.set(poly);
    }
    /**
     * Sets up a {@apilink Circle | `circle collision geometry`} as the only collider with a specified radius in pixels.
     *
     * By default, the box is center is at (0, 0) which means it is centered around the actors anchor.
     */
    useCircleCollider(radius, center = _Math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector.Zero) {
        const collider = _Colliders_Shape__WEBPACK_IMPORTED_MODULE_9__.Shape.Circle(radius, center);
        return this.set(collider);
    }
    /**
     * Sets up an {@apilink Edge | `edge collision geometry`} with a start point and an end point relative to the anchor of the associated actor
     * of this physics body.
     *
     * By default, the box is center is at (0, 0) which means it is centered around the actors anchor.
     */
    useEdgeCollider(begin, end) {
        const collider = _Colliders_Shape__WEBPACK_IMPORTED_MODULE_9__.Shape.Edge(begin, end);
        return this.set(collider);
    }
    /**
     * Setups up a {@apilink CompositeCollider} which can define any arbitrary set of excalibur colliders
     * @param colliders
     */
    useCompositeCollider(colliders) {
        return this.set(new _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_5__.CompositeCollider(colliders));
    }
}


/***/ }),

/***/ "./Collision/Colliders/CircleCollider.ts":
/*!***********************************************!*\
  !*** ./Collision/Colliders/CircleCollider.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CircleCollider: () => (/* binding */ CircleCollider)
/* harmony export */ });
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./CollisionJumpTable */ "./Collision/Colliders/CollisionJumpTable.ts");
/* harmony import */ var _PolygonCollider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./PolygonCollider */ "./Collision/Colliders/PolygonCollider.ts");
/* harmony import */ var _EdgeCollider__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./EdgeCollider */ "./Collision/Colliders/EdgeCollider.ts");
/* harmony import */ var _Math_projection__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../Math/projection */ "./Math/projection.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../Color */ "./Color.ts");
/* harmony import */ var _Collider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Collider */ "./Collision/Colliders/Collider.ts");
/* harmony import */ var _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ClosestLineJumpTable */ "./Collision/Colliders/ClosestLineJumpTable.ts");
/* harmony import */ var _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Math/affine-matrix */ "./Math/affine-matrix.ts");
/* harmony import */ var _Index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Index */ "./Collision/BodyComponent.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math/util */ "./Math/util.ts");












/**
 * This is a circle collider for the excalibur rigid body physics simulation
 */
class CircleCollider extends _Collider__WEBPACK_IMPORTED_MODULE_0__.Collider {
    get worldPos() {
        return this._globalMatrix.getPosition();
    }
    /**
     * Get the radius of the circle
     */
    get radius() {
        var _a;
        if (this._radius) {
            return this._radius;
        }
        const tx = this._transform;
        const scale = (_a = tx === null || tx === void 0 ? void 0 : tx.globalScale) !== null && _a !== void 0 ? _a : _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.One;
        // This is a trade off, the alternative is retooling circles to support ellipse collisions
        return (this._radius = this._naturalRadius * Math.min(scale.x, scale.y));
    }
    /**
     * Set the radius of the circle
     */
    set radius(val) {
        var _a;
        const tx = this._transform;
        const scale = (_a = tx === null || tx === void 0 ? void 0 : tx.globalScale) !== null && _a !== void 0 ? _a : _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.One;
        // This is a trade off, the alternative is retooling circles to support ellipse collisions
        this._naturalRadius = val / Math.min(scale.x, scale.y);
        this._localBoundsDirty = true;
        this._radius = val;
    }
    constructor(options) {
        super();
        /**
         * Position of the circle relative to the collider, by default (0, 0).
         */
        this.offset = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        this._globalMatrix = _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_2__.AffineMatrix.identity();
        this._localBoundsDirty = true;
        this.offset = options.offset || _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        this.radius = options.radius || 0;
        this._globalMatrix.translate(this.offset.x, this.offset.y);
    }
    /**
     * Returns a clone of this shape, not associated with any collider
     */
    clone() {
        return new CircleCollider({
            offset: this.offset.clone(),
            radius: this.radius
        });
    }
    /**
     * Get the center of the collider in world coordinates
     */
    get center() {
        return this._globalMatrix.getPosition();
    }
    /**
     * Tests if a point is contained in this collider
     */
    contains(point) {
        var _a, _b;
        const pos = (_b = (_a = this._transform) === null || _a === void 0 ? void 0 : _a.pos) !== null && _b !== void 0 ? _b : this.offset;
        const distance = pos.distance(point);
        if (distance <= this.radius) {
            return true;
        }
        return false;
    }
    /**
     * Casts a ray at the Circle collider and returns the nearest point of collision
     * @param ray
     */
    rayCast(ray, max = Infinity) {
        var _a, _b;
        // https://en.wikipedia.org/wiki/Intersection_(geometry)#A_line_and_a_circle
        const c = this.center;
        const dir = ray.dir;
        const orig = ray.pos;
        const u = c.sub(orig);
        const u1 = dir.scale(u.dot(dir));
        const u2 = u.sub(u1);
        const d = u2.magnitude;
        if (d > this.radius) {
            return null;
        }
        else {
            // tangent case
            let toi = 0;
            if ((0,_Math_util__WEBPACK_IMPORTED_MODULE_3__.approximatelyEqual)(d, this.radius, 0.0001)) {
                toi = -dir.dot(orig.sub(c));
                if (toi > 0 && toi < max) {
                    const point = ray.getPoint(toi);
                    return {
                        point,
                        normal: point.sub(c).normalize(),
                        collider: this,
                        body: (_a = this.owner) === null || _a === void 0 ? void 0 : _a.get(_Index__WEBPACK_IMPORTED_MODULE_4__.BodyComponent),
                        distance: toi
                    };
                }
                return null;
            }
            else {
                // two point
                const discriminant = Math.sqrt(Math.pow(dir.dot(orig.sub(c)), 2) - Math.pow(orig.sub(c).distance(), 2) + Math.pow(this.radius, 2));
                const toi1 = -dir.dot(orig.sub(c)) + discriminant;
                const toi2 = -dir.dot(orig.sub(c)) - discriminant;
                const positiveToi = [];
                if (toi1 >= 0) {
                    positiveToi.push(toi1);
                }
                if (toi2 >= 0) {
                    positiveToi.push(toi2);
                }
                const minToi = Math.min(...positiveToi);
                if (minToi <= max) {
                    const point = ray.getPoint(minToi);
                    return {
                        point,
                        normal: point.sub(c).normalize(),
                        collider: this,
                        body: (_b = this.owner) === null || _b === void 0 ? void 0 : _b.get(_Index__WEBPACK_IMPORTED_MODULE_4__.BodyComponent),
                        distance: minToi
                    };
                }
                return null;
            }
        }
    }
    getClosestLineBetween(shape) {
        if (shape instanceof CircleCollider) {
            return _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_5__.ClosestLineJumpTable.CircleCircleClosestLine(this, shape);
        }
        else if (shape instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_6__.PolygonCollider) {
            return _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_5__.ClosestLineJumpTable.PolygonCircleClosestLine(shape, this).flip();
        }
        else if (shape instanceof _EdgeCollider__WEBPACK_IMPORTED_MODULE_7__.EdgeCollider) {
            return _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_5__.ClosestLineJumpTable.CircleEdgeClosestLine(this, shape).flip();
        }
        else {
            throw new Error(`Polygon could not collide with unknown CollisionShape ${typeof shape}`);
        }
    }
    /**
     * @inheritdoc
     */
    collide(collider) {
        if (collider instanceof CircleCollider) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_8__.CollisionJumpTable.CollideCircleCircle(this, collider);
        }
        else if (collider instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_6__.PolygonCollider) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_8__.CollisionJumpTable.CollideCirclePolygon(this, collider);
        }
        else if (collider instanceof _EdgeCollider__WEBPACK_IMPORTED_MODULE_7__.EdgeCollider) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_8__.CollisionJumpTable.CollideCircleEdge(this, collider);
        }
        else {
            throw new Error(`Circle could not collide with unknown CollisionShape ${typeof collider}`);
        }
    }
    /**
     * Find the point on the collider furthest in the direction specified
     */
    getFurthestPoint(direction) {
        return this.center.add(direction.normalize().scale(this.radius));
    }
    /**
     * Find the local point on the shape in the direction specified
     * @param direction
     */
    getFurthestLocalPoint(direction) {
        const dir = direction.normalize();
        return dir.scale(this.radius);
    }
    /**
     * Get the axis aligned bounding box for the circle collider in world coordinates
     */
    get bounds() {
        return this.localBounds.transform(this._globalMatrix);
    }
    /**
     * Get the axis aligned bounding box for the circle collider in local coordinates
     */
    get localBounds() {
        if (this._localBoundsDirty) {
            this._localBounds = new _BoundingBox__WEBPACK_IMPORTED_MODULE_9__.BoundingBox(-this._naturalRadius, -this._naturalRadius, +this._naturalRadius, +this._naturalRadius);
            this._localBoundsDirty = false;
        }
        return this._localBounds;
    }
    /**
     * Get axis not implemented on circles, since there are infinite axis in a circle
     */
    get axes() {
        return [];
    }
    /**
     * Returns the moment of inertia of a circle given it's mass
     * https://en.wikipedia.org/wiki/List_of_moments_of_inertia
     */
    getInertia(mass) {
        return (mass * this.radius * this.radius) / 2;
    }
    /* istanbul ignore next */
    update(transform) {
        var _a;
        this._transform = transform;
        const globalMat = (_a = transform.matrix) !== null && _a !== void 0 ? _a : this._globalMatrix;
        globalMat.clone(this._globalMatrix);
        this._globalMatrix.translate(this.offset.x, this.offset.y);
        this._radius = undefined;
    }
    /**
     * Project the circle along a specified axis
     */
    project(axis) {
        const scalars = [];
        const point = this.center;
        const dotProduct = point.dot(axis);
        scalars.push(dotProduct);
        scalars.push(dotProduct + this.radius);
        scalars.push(dotProduct - this.radius);
        return new _Math_projection__WEBPACK_IMPORTED_MODULE_10__.Projection(Math.min.apply(Math, scalars), Math.max.apply(Math, scalars));
    }
    debug(ex, color, options) {
        var _a, _b, _c, _d;
        const { lineWidth } = { ...{ lineWidth: 1 }, ...options };
        const tx = this._transform;
        const scale = (_a = tx === null || tx === void 0 ? void 0 : tx.globalScale) !== null && _a !== void 0 ? _a : _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.One;
        const rotation = (_b = tx === null || tx === void 0 ? void 0 : tx.globalRotation) !== null && _b !== void 0 ? _b : 0;
        const pos = (_c = tx === null || tx === void 0 ? void 0 : tx.globalPos) !== null && _c !== void 0 ? _c : _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        ex.save();
        ex.translate(pos.x, pos.y);
        ex.rotate(rotation);
        ex.scale(scale.x, scale.y);
        ex.drawCircle((_d = this.offset) !== null && _d !== void 0 ? _d : _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero, this._naturalRadius, _Color__WEBPACK_IMPORTED_MODULE_11__.Color.Transparent, color, lineWidth);
        ex.restore();
    }
}


/***/ }),

/***/ "./Collision/Colliders/ClosestLineJumpTable.ts":
/*!*****************************************************!*\
  !*** ./Collision/Colliders/ClosestLineJumpTable.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ClosestLineJumpTable: () => (/* binding */ ClosestLineJumpTable)
/* harmony export */ });
/* harmony import */ var _Math_line_segment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Math/line-segment */ "./Math/line-segment.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Math_ray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Math/ray */ "./Math/ray.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/util */ "./Math/util.ts");




/**
 * Finds the closest line segment between two given line segments.
 */
function ClosestLine(line1, line2) {
    // https://math.stackexchange.com/questions/1993953/closest-points-between-2-lines-in-2d
    const EPSILON = 1e-9;
    const line1Dir = line1.dir();
    const line2Dir = line2.dir();
    const d1Squared = line1Dir.dot(line1Dir);
    const d2Squared = line2Dir.dot(line2Dir);
    if (d1Squared < EPSILON && d2Squared < EPSILON) {
        return new _Math_line_segment__WEBPACK_IMPORTED_MODULE_0__.LineSegment(line1.begin, line2.begin);
    }
    if (d1Squared < EPSILON) {
        const t = (0,_Math_util__WEBPACK_IMPORTED_MODULE_1__.clamp)(line2Dir.dot(line1.begin.sub(line2.begin)) / d2Squared, 0, 1);
        const closestPoint = line2.begin.add(line2Dir.scale(t));
        return new _Math_line_segment__WEBPACK_IMPORTED_MODULE_0__.LineSegment(line1.begin, closestPoint);
    }
    if (d2Squared < EPSILON) {
        const t = (0,_Math_util__WEBPACK_IMPORTED_MODULE_1__.clamp)(line1Dir.dot(line2.begin.sub(line1.begin)) / d1Squared, 0, 1);
        const closestPoint = line1.begin.add(line1Dir.scale(t));
        return new _Math_line_segment__WEBPACK_IMPORTED_MODULE_0__.LineSegment(closestPoint, line2.begin);
    }
    const r = line1.begin.sub(line2.begin);
    const a = d1Squared;
    const e = d2Squared;
    const f = line2Dir.dot(r);
    const denom = a * e - Math.pow(line1Dir.dot(line2Dir), 2);
    let s = 0;
    let t = 0;
    if (Math.abs(denom) > EPSILON) {
        s = (0,_Math_util__WEBPACK_IMPORTED_MODULE_1__.clamp)((line1Dir.dot(line2Dir) * f - e * line1Dir.dot(r)) / denom, 0, 1);
    }
    else {
        // lines are parallel
        s = (0,_Math_util__WEBPACK_IMPORTED_MODULE_1__.clamp)(line1Dir.dot(r) / a, 0, 1);
    }
    if (Math.abs(e) > EPSILON) {
        t = (0,_Math_util__WEBPACK_IMPORTED_MODULE_1__.clamp)((line1Dir.dot(line2Dir) * s + f) / e, 0, 1);
    }
    else {
        // line2 is a degenerate point
        t = 0;
    }
    const closestPointOnLine1 = line1.begin.add(line1Dir.scale(s));
    const closestPointOnLine2 = line2.begin.add(line2Dir.scale(t));
    return new _Math_line_segment__WEBPACK_IMPORTED_MODULE_0__.LineSegment(closestPointOnLine1, closestPointOnLine2);
}
const ClosestLineJumpTable = {
    PolygonPolygonClosestLine(polygonA, polygonB) {
        const aSides = polygonA.getSides();
        const bSides = polygonB.getSides();
        let minDistance = Number.MAX_VALUE;
        let closestLine = null;
        for (let i = 0; i < aSides.length; i++) {
            for (let j = 0; j < bSides.length; j++) {
                const line = ClosestLine(aSides[i], bSides[j]);
                const distance = line.getLength();
                if (distance < minDistance) {
                    minDistance = distance;
                    closestLine = line;
                }
            }
        }
        return closestLine;
    },
    PolygonEdgeClosestLine(polygon, edge) {
        // Find the 2 closest faces on each polygon
        const otherWorldPos = edge.worldPos;
        const otherDirection = otherWorldPos.sub(polygon.worldPos);
        const rayTowardsOther = new _Math_ray__WEBPACK_IMPORTED_MODULE_2__.Ray(polygon.worldPos, otherDirection);
        const thisPoint = polygon.rayCast(rayTowardsOther).point.add(rayTowardsOther.dir.scale(0.1));
        const thisFace = polygon.getClosestFace(thisPoint);
        // L1 = P(s) = p0 + s * u, where s is time and p0 is the start of the line
        // L2 = Q(t) = q0 + t * v, where t is time and q0 is the start of the line
        const edgeLine = edge.asLine();
        return ClosestLine(thisFace.face, edgeLine);
    },
    PolygonCircleClosestLine(polygon, circle) {
        // https://math.stackexchange.com/questions/1919177/how-to-find-point-on-line-closest-to-sphere
        // Find the 2 closest faces on each polygon
        const otherWorldPos = circle.worldPos;
        const otherDirection = otherWorldPos.sub(polygon.worldPos);
        const rayTowardsOther = new _Math_ray__WEBPACK_IMPORTED_MODULE_2__.Ray(polygon.worldPos, otherDirection.normalize());
        const thisPoint = polygon.rayCast(rayTowardsOther).point.add(rayTowardsOther.dir.scale(0.1));
        const thisFace = polygon.getClosestFace(thisPoint);
        // L1 = P(s) = p0 + s * u, where s is time and p0 is the start of the line
        const p0 = thisFace.face.begin;
        const u = thisFace.face.getEdge();
        // Time of minimum distance
        let t = (u.x * (otherWorldPos.x - p0.x) + u.y * (otherWorldPos.y - p0.y)) / (u.x * u.x + u.y * u.y);
        // If time of minimum is past the edge clamp
        if (t > 1) {
            t = 1;
        }
        else if (t < 0) {
            t = 0;
        }
        // Minimum distance
        const d = Math.sqrt(Math.pow(p0.x + u.x * t - otherWorldPos.x, 2) + Math.pow(p0.y + u.y * t - otherWorldPos.y, 2)) - circle.radius;
        const circlex = ((p0.x + u.x * t - otherWorldPos.x) * circle.radius) / (circle.radius + d);
        const circley = ((p0.y + u.y * t - otherWorldPos.y) * circle.radius) / (circle.radius + d);
        return new _Math_line_segment__WEBPACK_IMPORTED_MODULE_0__.LineSegment(u.scale(t).add(p0), new _Math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector(otherWorldPos.x + circlex, otherWorldPos.y + circley));
    },
    CircleCircleClosestLine(circleA, circleB) {
        // Find the 2 closest faces on each polygon
        const otherWorldPos = circleB.worldPos;
        const otherDirection = otherWorldPos.sub(circleA.worldPos);
        const thisWorldPos = circleA.worldPos;
        const thisDirection = thisWorldPos.sub(circleB.worldPos);
        const rayTowardsOther = new _Math_ray__WEBPACK_IMPORTED_MODULE_2__.Ray(circleA.worldPos, otherDirection);
        const rayTowardsThis = new _Math_ray__WEBPACK_IMPORTED_MODULE_2__.Ray(circleB.worldPos, thisDirection);
        const thisPoint = circleA.rayCast(rayTowardsOther);
        const otherPoint = circleB.rayCast(rayTowardsThis);
        return new _Math_line_segment__WEBPACK_IMPORTED_MODULE_0__.LineSegment(thisPoint.point, otherPoint.point);
    },
    CircleEdgeClosestLine(circle, edge) {
        // https://math.stackexchange.com/questions/1919177/how-to-find-point-on-line-closest-to-sphere
        const circleWorldPos = circle.worldPos;
        // L1 = P(s) = p0 + s * u, where s is time and p0 is the start of the line
        const edgeLine = edge.asLine();
        const edgeStart = edgeLine.begin;
        const edgeVector = edgeLine.getEdge();
        const p0 = edgeStart;
        const u = edgeVector;
        // Time of minimum distance
        let t = (u.x * (circleWorldPos.x - p0.x) + u.y * (circleWorldPos.y - p0.y)) / (u.x * u.x + u.y * u.y);
        // If time of minimum is past the edge clamp to edge
        if (t > 1) {
            t = 1;
        }
        else if (t < 0) {
            t = 0;
        }
        // Minimum distance
        const d = Math.sqrt(Math.pow(p0.x + u.x * t - circleWorldPos.x, 2) + Math.pow(p0.y + u.y * t - circleWorldPos.y, 2)) - circle.radius;
        const circlex = ((p0.x + u.x * t - circleWorldPos.x) * circle.radius) / (circle.radius + d);
        const circley = ((p0.y + u.y * t - circleWorldPos.y) * circle.radius) / (circle.radius + d);
        return new _Math_line_segment__WEBPACK_IMPORTED_MODULE_0__.LineSegment(u.scale(t).add(p0), new _Math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector(circleWorldPos.x + circlex, circleWorldPos.y + circley));
    },
    EdgeEdgeClosestLine(edgeA, edgeB) {
        // L1 = P(s) = p0 + s * u, where s is time and p0 is the start of the line
        const edgeLineA = edgeA.asLine();
        // L2 = Q(t) = q0 + t * v, where t is time and q0 is the start of the line
        const edgeLineB = edgeB.asLine();
        return ClosestLine(edgeLineA, edgeLineB);
    }
};


/***/ }),

/***/ "./Collision/Colliders/Collider.ts":
/*!*****************************************!*\
  !*** ./Collision/Colliders/Collider.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Collider: () => (/* binding */ Collider)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Id__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Id */ "./Id.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../EventEmitter */ "./EventEmitter.ts");



/**
 * A collision collider specifies the geometry that can detect when other collision colliders intersect
 * for the purposes of colliding 2 objects in excalibur.
 */
class Collider {
    constructor() {
        this.id = (0,_Id__WEBPACK_IMPORTED_MODULE_0__.createId)('collider', Collider._ID++);
        /**
         * Composite collider if any this collider is attached to
         *
         * **WARNING** do not tamper with this property
         */
        this.composite = null;
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        /**
         * Pixel offset of the collision collider relative to the collider, by default (0, 0) meaning the collider is positioned
         * on top of the collider.
         */
        this.offset = _Math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector.Zero;
    }
    /**
     * Returns a boolean indicating whether this body collided with
     * or was in stationary contact with
     * the body of the other {@apilink Collider}
     */
    touching(other) {
        const contact = this.collide(other);
        if (contact) {
            return true;
        }
        return false;
    }
}
Collider._ID = 0;


/***/ }),

/***/ "./Collision/Colliders/CollisionJumpTable.ts":
/*!***************************************************!*\
  !*** ./Collision/Colliders/CollisionJumpTable.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CollisionJumpTable: () => (/* binding */ CollisionJumpTable)
/* harmony export */ });
/* harmony import */ var _CircleCollider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./CircleCollider */ "./Collision/Colliders/CircleCollider.ts");
/* harmony import */ var _Detection_CollisionContact__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Detection/CollisionContact */ "./Collision/Detection/CollisionContact.ts");
/* harmony import */ var _PolygonCollider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./PolygonCollider */ "./Collision/Colliders/PolygonCollider.ts");
/* harmony import */ var _EdgeCollider__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./EdgeCollider */ "./Collision/Colliders/EdgeCollider.ts");
/* harmony import */ var _SeparatingAxis__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SeparatingAxis */ "./Collision/Colliders/SeparatingAxis.ts");
/* harmony import */ var _Math_line_segment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../Math/line-segment */ "./Math/line-segment.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../EntityComponentSystem */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Detection_Pair__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Detection/Pair */ "./Collision/Detection/Pair.ts");
/* harmony import */ var _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/affine-matrix */ "./Math/affine-matrix.ts");










const ScratchZero = _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero; // TODO constant vector
const ScratchNormal = _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero; // TODO constant vector
const ScratchMatrix = _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_1__.AffineMatrix.identity();
const CollisionJumpTable = {
    CollideCircleCircle(circleA, circleB) {
        const circleAPos = circleA.worldPos;
        const circleBPos = circleB.worldPos;
        const combinedRadius = circleA.radius + circleB.radius;
        const distance = circleAPos.distance(circleBPos);
        if (distance > combinedRadius) {
            return [];
        }
        // negative means overlap
        const separation = combinedRadius - distance;
        // Normal points from A -> B
        const normal = circleBPos.sub(circleAPos).normalize();
        const tangent = normal.perpendicular();
        const mvt = normal.scale(separation);
        const point = circleA.getFurthestPoint(normal);
        const local = circleA.getFurthestLocalPoint(normal);
        const info = {
            collider: circleA,
            separation,
            axis: normal,
            point: point
        };
        return [new _Detection_CollisionContact__WEBPACK_IMPORTED_MODULE_2__.CollisionContact(circleA, circleB, mvt, normal, tangent, [point], [local], info)];
    },
    CollideCirclePolygon(circle, polygon) {
        var _a, _b;
        let minAxis = _SeparatingAxis__WEBPACK_IMPORTED_MODULE_3__.SeparatingAxis.findCirclePolygonSeparation(circle, polygon);
        if (!minAxis) {
            return [];
        }
        // make sure that the minAxis is pointing away from circle
        const sameDir = minAxis.dot(polygon.center.sub(circle.center));
        minAxis = sameDir < 0 ? minAxis.negate() : minAxis;
        const point = circle.getFurthestPoint(minAxis);
        const xf = (_b = (_a = circle.owner) === null || _a === void 0 ? void 0 : _a.get(_EntityComponentSystem__WEBPACK_IMPORTED_MODULE_4__.TransformComponent)) !== null && _b !== void 0 ? _b : new _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_4__.TransformComponent();
        const local = xf.applyInverse(point);
        const normal = minAxis.normalize();
        const info = {
            collider: circle,
            separation: -minAxis.magnitude,
            axis: normal,
            point: point,
            localPoint: local,
            side: polygon.findSide(normal.negate()),
            localSide: polygon.findLocalSide(normal.negate())
        };
        return [new _Detection_CollisionContact__WEBPACK_IMPORTED_MODULE_2__.CollisionContact(circle, polygon, minAxis, normal, normal.perpendicular(), [point], [local], info)];
    },
    CollideCircleEdge(circle, edge) {
        // TODO not sure this actually abides by local/world collisions
        // Are edge.begin and edge.end local space or world space? I think they should be local
        // center of the circle in world pos
        const cc = circle.center;
        // vector in the direction of the edge
        const edgeWorld = edge.asLine();
        const e = edgeWorld.end.sub(edgeWorld.begin);
        // amount of overlap with the circle's center along the edge direction
        const u = e.dot(edgeWorld.end.sub(cc));
        const v = e.dot(cc.sub(edgeWorld.begin));
        const side = edge.asLine();
        const localSide = edge.asLocalLine();
        // Potential region A collision (circle is on the left side of the edge, before the beginning)
        if (v <= 0) {
            const da = edgeWorld.begin.sub(cc);
            const dda = da.dot(da); // quick and dirty way of calc'n distance in r^2 terms saves some sqrts
            // save some sqrts
            if (dda > circle.radius * circle.radius) {
                return []; // no collision
            }
            const normal = da.normalize();
            const separation = circle.radius - Math.sqrt(dda);
            const info = {
                collider: circle,
                separation: separation,
                axis: normal,
                point: side.begin,
                side: side,
                localSide: localSide
            };
            return [
                new _Detection_CollisionContact__WEBPACK_IMPORTED_MODULE_2__.CollisionContact(circle, edge, normal.scale(separation), normal, normal.perpendicular(), [side.begin], [localSide.begin], info)
            ];
        }
        // Potential region B collision (circle is on the right side of the edge, after the end)
        if (u <= 0) {
            const db = edgeWorld.end.sub(cc);
            const ddb = db.dot(db);
            if (ddb > circle.radius * circle.radius) {
                return [];
            }
            const normal = db.normalize();
            const separation = circle.radius - Math.sqrt(ddb);
            const info = {
                collider: circle,
                separation: separation,
                axis: normal,
                point: side.end,
                side: side,
                localSide: localSide
            };
            return [
                new _Detection_CollisionContact__WEBPACK_IMPORTED_MODULE_2__.CollisionContact(circle, edge, normal.scale(separation), normal, normal.perpendicular(), [side.end], [localSide.end], info)
            ];
        }
        // Otherwise potential region AB collision (circle is in the middle of the edge between the beginning and end)
        const den = e.dot(e);
        const pointOnEdge = edgeWorld.begin
            .scale(u)
            .add(edgeWorld.end.scale(v))
            .scale(1 / den);
        const d = cc.sub(pointOnEdge);
        const dd = d.dot(d);
        if (dd > circle.radius * circle.radius) {
            return []; // no collision
        }
        let normal = e.perpendicular();
        // flip correct direction
        if (normal.dot(cc.sub(edgeWorld.begin)) < 0) {
            normal.x = -normal.x;
            normal.y = -normal.y;
        }
        normal = normal.normalize();
        const separation = circle.radius - Math.sqrt(dd);
        const mvt = normal.scale(separation);
        const info = {
            collider: circle,
            separation: separation,
            axis: normal,
            point: pointOnEdge,
            side: side,
            localSide: localSide
        };
        return [
            new _Detection_CollisionContact__WEBPACK_IMPORTED_MODULE_2__.CollisionContact(circle, edge, mvt, normal.negate(), normal.negate().perpendicular(), [pointOnEdge], [pointOnEdge.sub(edge.worldPos)], info)
        ];
    },
    CollideEdgeEdge() {
        // Edge-edge collision doesn't make sense
        return [];
    },
    CollidePolygonEdge(polygon, edge) {
        var _a;
        const pc = polygon.center;
        const ec = edge.center;
        const dir = ec.sub(pc).normalize();
        // build a temporary polygon from the edge to use SAT
        const linePoly = new _PolygonCollider__WEBPACK_IMPORTED_MODULE_5__.PolygonCollider({
            points: [edge.begin, edge.end, edge.end.add(dir.scale(100)), edge.begin.add(dir.scale(100))],
            offset: edge.offset
        });
        linePoly.owner = edge.owner;
        const tx = (_a = edge.owner) === null || _a === void 0 ? void 0 : _a.get(_EntityComponentSystem__WEBPACK_IMPORTED_MODULE_4__.TransformComponent);
        if (tx) {
            linePoly.update(edge.owner.get(_EntityComponentSystem__WEBPACK_IMPORTED_MODULE_4__.TransformComponent).get());
        }
        // Gross hack but poly-poly works well
        const contact = this.CollidePolygonPolygon(polygon, linePoly);
        if (contact.length) {
            // Fudge the contact back to edge
            contact[0].colliderB = edge;
            contact[0].id = _Detection_Pair__WEBPACK_IMPORTED_MODULE_6__.Pair.calculatePairHash(polygon.id, edge.id);
        }
        return contact;
    },
    CollidePolygonPolygon(polyA, polyB) {
        // Multi contact from SAT
        // https://gamedev.stackexchange.com/questions/111390/multiple-contacts-for-sat-collision-detection
        // do a SAT test to find a min axis if it exists
        const separationA = _SeparatingAxis__WEBPACK_IMPORTED_MODULE_3__.SeparatingAxis.findPolygonPolygonSeparation(polyA, polyB);
        // If there is no overlap from boxA's perspective we can end early
        if (separationA.separation > 0) {
            return [];
        }
        const separationB = _SeparatingAxis__WEBPACK_IMPORTED_MODULE_3__.SeparatingAxis.findPolygonPolygonSeparation(polyB, polyA);
        // If there is no overlap from boxB's perspective exit now
        if (separationB.separation > 0) {
            return [];
        }
        // Separations are both negative, we want to pick the least negative (minimal movement)
        const separation = separationA.separation > separationB.separation ? separationA : separationB;
        // The incident side is the most opposite from the axes of collision on the other collider
        const other = separation.collider === polyA ? polyB : polyA;
        const main = separation.collider === polyA ? polyA : polyB;
        const toIncidentFrame = other.transform.inverse.multiply(main.transform.matrix, ScratchMatrix);
        const toIncidentFrameRotation = toIncidentFrame.getRotation();
        const referenceEdgeNormal = main.normals[separation.sideId].rotate(toIncidentFrameRotation, ScratchZero, ScratchNormal);
        let minEdge = Number.MAX_VALUE;
        let incidentEdgeIndex = 0;
        for (let i = 0; i < other.normals.length; i++) {
            const value = referenceEdgeNormal.dot(other.normals[i]);
            if (value < minEdge) {
                minEdge = value;
                incidentEdgeIndex = i;
            }
        }
        // FIXME temporary to prevent a crash, invalid separation
        if (!separation.localSide || !separation.localAxis || !separation.axis) {
            return [];
        }
        // Clip incident side by the perpendicular lines at each end of the reference side
        // https://en.wikipedia.org/wiki/Sutherland%E2%80%93Hodgman_algorithm
        const referenceSide = separation.localSide.transform(toIncidentFrame);
        const referenceDirection = separation.localAxis.perpendicular().negate().rotate(toIncidentFrameRotation);
        const incidentSide = new _Math_line_segment__WEBPACK_IMPORTED_MODULE_7__.LineSegment(other.points[incidentEdgeIndex], other.points[(incidentEdgeIndex + 1) % other.points.length]);
        const clipRight = incidentSide.clip(referenceDirection.negate(), -referenceDirection.dot(referenceSide.begin), false);
        let clipLeft = null;
        if (clipRight) {
            clipLeft = clipRight.clip(referenceDirection, referenceDirection.dot(referenceSide.end), false);
        }
        if (clipLeft) {
            const localPoints = [];
            const points = [];
            const clipPoints = clipLeft.getPoints();
            for (let i = 0; i < clipPoints.length; i++) {
                const p = clipPoints[i];
                if (referenceSide.below(p)) {
                    localPoints.push(p);
                    points.push(other.transform.apply(p));
                }
            }
            let normal = separation.axis;
            let tangent = normal.perpendicular();
            // Point Contact A -> B
            if (polyB.center.sub(polyA.center).dot(normal) < 0) {
                normal = normal.negate();
                tangent = normal.perpendicular();
            }
            return [new _Detection_CollisionContact__WEBPACK_IMPORTED_MODULE_2__.CollisionContact(polyA, polyB, normal.scale(-separation.separation), normal, tangent, points, localPoints, separation)];
        }
        return [];
    },
    FindContactSeparation(contact, localPoint) {
        var _a, _b, _c, _d;
        const shapeA = contact.colliderA;
        const txA = (_b = (_a = contact.bodyA) === null || _a === void 0 ? void 0 : _a.transform) !== null && _b !== void 0 ? _b : new _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_4__.TransformComponent();
        const shapeB = contact.colliderB;
        const txB = (_d = (_c = contact.bodyB) === null || _c === void 0 ? void 0 : _c.transform) !== null && _d !== void 0 ? _d : new _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_4__.TransformComponent();
        // both are circles
        if (shapeA instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_8__.CircleCollider && shapeB instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_8__.CircleCollider) {
            const combinedRadius = shapeA.radius + shapeB.radius;
            const distance = txA.pos.distance(txB.pos);
            const separation = combinedRadius - distance;
            return -separation;
        }
        // both are polygons
        if (shapeA instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_5__.PolygonCollider && shapeB instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_5__.PolygonCollider) {
            if (contact.info.localSide) {
                let side;
                let worldPoint;
                if (contact.info.collider === shapeA) {
                    side = new _Math_line_segment__WEBPACK_IMPORTED_MODULE_7__.LineSegment(txA.apply(contact.info.localSide.begin).add(shapeA.offset), txA.apply(contact.info.localSide.end).add(shapeA.offset));
                    worldPoint = txB.apply(localPoint).add(shapeB.offset);
                }
                else {
                    side = new _Math_line_segment__WEBPACK_IMPORTED_MODULE_7__.LineSegment(txB.apply(contact.info.localSide.begin).add(shapeB.offset), txB.apply(contact.info.localSide.end).add(shapeB.offset));
                    worldPoint = txA.apply(localPoint).add(shapeA.offset);
                }
                return side.distanceToPoint(worldPoint, true);
            }
        }
        // polygon v circle
        if ((shapeA instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_5__.PolygonCollider && shapeB instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_8__.CircleCollider) ||
            (shapeB instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_5__.PolygonCollider && shapeA instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_8__.CircleCollider)) {
            const worldPoint = txA.apply(localPoint);
            if (contact.info.side) {
                return contact.info.side.distanceToPoint(worldPoint, true);
            }
        }
        // polygon v edge
        if ((shapeA instanceof _EdgeCollider__WEBPACK_IMPORTED_MODULE_9__.EdgeCollider && shapeB instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_5__.PolygonCollider) ||
            (shapeB instanceof _EdgeCollider__WEBPACK_IMPORTED_MODULE_9__.EdgeCollider && shapeA instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_5__.PolygonCollider)) {
            let worldPoint;
            if (contact.info.collider === shapeA) {
                worldPoint = txB.apply(localPoint);
            }
            else {
                worldPoint = txA.apply(localPoint);
            }
            if (contact.info.side) {
                return contact.info.side.distanceToPoint(worldPoint, true);
            }
        }
        // circle v edge
        if ((shapeA instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_8__.CircleCollider && shapeB instanceof _EdgeCollider__WEBPACK_IMPORTED_MODULE_9__.EdgeCollider) ||
            (shapeB instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_8__.CircleCollider && shapeA instanceof _EdgeCollider__WEBPACK_IMPORTED_MODULE_9__.EdgeCollider)) {
            // Local point is always on the edge which is always shapeB
            const worldPoint = txB.apply(localPoint);
            let circlePoint;
            if (shapeA instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_8__.CircleCollider) {
                circlePoint = shapeA.getFurthestPoint(contact.normal);
            }
            const dist = worldPoint.distance(circlePoint);
            if (contact.info.side) {
                return dist > 0 ? -dist : 0;
            }
        }
        return 0;
    }
};


/***/ }),

/***/ "./Collision/Colliders/CompositeCollider.ts":
/*!**************************************************!*\
  !*** ./Collision/Colliders/CompositeCollider.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CompositeCollider: () => (/* binding */ CompositeCollider)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../.. */ "./Util/Util.ts");
/* harmony import */ var _Detection_Pair__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Detection/Pair */ "./Collision/Detection/Pair.ts");
/* harmony import */ var _Math_projection__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../Math/projection */ "./Math/projection.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Detection_DynamicTree__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Detection/DynamicTree */ "./Collision/Detection/DynamicTree.ts");
/* harmony import */ var _Detection_DynamicTreeCollisionProcessor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Detection/DynamicTreeCollisionProcessor */ "./Collision/Detection/DynamicTreeCollisionProcessor.ts");
/* harmony import */ var _Collider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Collider */ "./Collision/Colliders/Collider.ts");
/* harmony import */ var _PhysicsConfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../PhysicsConfig */ "./Collision/PhysicsConfig.ts");









class CompositeCollider extends _Collider__WEBPACK_IMPORTED_MODULE_0__.Collider {
    /**
     * Treat composite collider's member colliders as either separate colliders for the purposes of onCollisionStart/onCollision
     * or as a single collider together.
     *
     * This property can be overridden on individual {@apilink CompositeColliders}.
     *
     * For composites without gaps or small groups of colliders, you probably want 'together'
     *
     * For composites with deliberate gaps, like a platforming level layout, you probably want 'separate'
     *
     * Default is 'together' if unset
     */
    set compositeStrategy(value) {
        this._compositeStrategy = value;
    }
    get compositeStrategy() {
        return this._compositeStrategy;
    }
    constructor(colliders) {
        super();
        this._collisionProcessor = new _Detection_DynamicTreeCollisionProcessor__WEBPACK_IMPORTED_MODULE_1__.DynamicTreeCollisionProcessor({
            ...(0,_PhysicsConfig__WEBPACK_IMPORTED_MODULE_2__.getDefaultPhysicsConfig)()
        });
        this._dynamicAABBTree = new _Detection_DynamicTree__WEBPACK_IMPORTED_MODULE_3__.DynamicTree({
            boundsPadding: 5,
            velocityMultiplier: 2
        });
        this._colliders = [];
        for (const c of colliders) {
            this.addCollider(c);
        }
    }
    clearColliders() {
        this._colliders = [];
    }
    addCollider(collider) {
        let colliders;
        if (collider instanceof CompositeCollider) {
            colliders = collider.getColliders();
            colliders.forEach((c) => c.offset.addEqual(collider.offset));
        }
        else {
            colliders = [collider];
        }
        // Flatten composites
        for (const c of colliders) {
            c.events.pipe(this.events);
            c.composite = this;
            this._colliders.push(c);
            this._collisionProcessor.track(c);
            this._dynamicAABBTree.trackCollider(c);
        }
    }
    removeCollider(collider) {
        collider.events.pipe(this.events);
        collider.composite = null;
        ___WEBPACK_IMPORTED_MODULE_4__.removeItemFromArray(collider, this._colliders);
        this._collisionProcessor.untrack(collider);
        this._dynamicAABBTree.untrackCollider(collider);
    }
    getColliders() {
        return this._colliders;
    }
    get worldPos() {
        var _a, _b;
        return ((_b = (_a = this._transform) === null || _a === void 0 ? void 0 : _a.pos) !== null && _b !== void 0 ? _b : _Math_vector__WEBPACK_IMPORTED_MODULE_5__.Vector.Zero).add(this.offset);
    }
    get center() {
        var _a, _b;
        return ((_b = (_a = this._transform) === null || _a === void 0 ? void 0 : _a.pos) !== null && _b !== void 0 ? _b : _Math_vector__WEBPACK_IMPORTED_MODULE_5__.Vector.Zero).add(this.offset);
    }
    get bounds() {
        var _a, _b;
        // TODO cache this
        const colliders = this.getColliders();
        const results = colliders.reduce((acc, collider) => acc.combine(collider.bounds), (_b = (_a = colliders[0]) === null || _a === void 0 ? void 0 : _a.bounds) !== null && _b !== void 0 ? _b : new _BoundingBox__WEBPACK_IMPORTED_MODULE_6__.BoundingBox().translate(this.worldPos));
        return results.translate(this.offset);
    }
    get localBounds() {
        var _a, _b;
        // TODO cache this
        const colliders = this.getColliders();
        const results = colliders.reduce((acc, collider) => acc.combine(collider.localBounds), (_b = (_a = colliders[0]) === null || _a === void 0 ? void 0 : _a.localBounds) !== null && _b !== void 0 ? _b : new _BoundingBox__WEBPACK_IMPORTED_MODULE_6__.BoundingBox());
        return results;
    }
    get axes() {
        // TODO cache this
        const colliders = this.getColliders();
        let axes = [];
        for (const collider of colliders) {
            axes = axes.concat(collider.axes);
        }
        return axes;
    }
    getFurthestPoint(direction) {
        const colliders = this.getColliders();
        const furthestPoints = [];
        for (const collider of colliders) {
            furthestPoints.push(collider.getFurthestPoint(direction));
        }
        // Pick best point from all colliders
        let bestPoint = furthestPoints[0];
        let maxDistance = -Number.MAX_VALUE;
        for (const point of furthestPoints) {
            const distance = point.dot(direction);
            if (distance > maxDistance) {
                bestPoint = point;
                maxDistance = distance;
            }
        }
        return bestPoint;
    }
    getInertia(mass) {
        const colliders = this.getColliders();
        let totalInertia = 0;
        for (const collider of colliders) {
            totalInertia += collider.getInertia(mass);
        }
        return totalInertia;
    }
    collide(other) {
        let otherColliders = [other];
        if (other instanceof CompositeCollider) {
            otherColliders = other.getColliders();
        }
        const pairs = [];
        for (const c of otherColliders) {
            this._dynamicAABBTree.query(c, (potentialCollider) => {
                pairs.push(new _Detection_Pair__WEBPACK_IMPORTED_MODULE_7__.Pair(c, potentialCollider));
                return false;
            });
        }
        let contacts = [];
        for (const p of pairs) {
            contacts = contacts.concat(p.collide());
        }
        return contacts;
    }
    getClosestLineBetween(other) {
        const colliders = this.getColliders();
        const lines = [];
        if (other instanceof CompositeCollider) {
            const otherColliders = other.getColliders();
            for (const colliderA of colliders) {
                for (const colliderB of otherColliders) {
                    const maybeLine = colliderA.getClosestLineBetween(colliderB);
                    if (maybeLine) {
                        lines.push(maybeLine);
                    }
                }
            }
        }
        else {
            for (const collider of colliders) {
                const maybeLine = other.getClosestLineBetween(collider);
                if (maybeLine) {
                    lines.push(maybeLine);
                }
            }
        }
        if (lines.length) {
            let minLength = lines[0].getLength();
            let minLine = lines[0];
            for (const line of lines) {
                const length = line.getLength();
                if (length < minLength) {
                    minLength = length;
                    minLine = line;
                }
            }
            return minLine;
        }
        return null;
    }
    contains(point) {
        const colliders = this.getColliders();
        for (const collider of colliders) {
            if (collider.contains(point)) {
                return true;
            }
        }
        return false;
    }
    rayCast(ray, max) {
        const colliders = this.getColliders();
        const hits = [];
        for (const collider of colliders) {
            const hit = collider.rayCast(ray, max);
            if (hit) {
                hits.push(hit);
            }
        }
        if (hits.length) {
            let minHit = hits[0];
            let minDistance = minHit.point.dot(ray.dir);
            for (const hit of hits) {
                const distance = ray.dir.dot(hit.point);
                if (distance < minDistance) {
                    minHit = hit;
                    minDistance = distance;
                }
            }
            return minHit;
        }
        return null;
    }
    project(axis) {
        const colliders = this.getColliders();
        const projections = [];
        for (const collider of colliders) {
            const proj = collider.project(axis);
            if (proj) {
                projections.push(proj);
            }
        }
        // Merge all proj's on the same axis
        if (projections.length) {
            const newProjection = new _Math_projection__WEBPACK_IMPORTED_MODULE_8__.Projection(projections[0].min, projections[0].max);
            for (const proj of projections) {
                newProjection.min = Math.min(proj.min, newProjection.min);
                newProjection.max = Math.max(proj.max, newProjection.max);
            }
            return newProjection;
        }
        return null;
    }
    update(transform) {
        if (transform) {
            const colliders = this.getColliders();
            for (const collider of colliders) {
                collider.owner = this.owner;
                collider.update(transform);
            }
        }
    }
    debug(ex, color, options) {
        const colliders = this.getColliders();
        ex.save();
        ex.translate(this.offset.x, this.offset.y);
        for (const collider of colliders) {
            collider.debug(ex, color, options);
        }
        ex.restore();
    }
    clone() {
        const result = new CompositeCollider(this._colliders.map((c) => c.clone()));
        result.offset = this.offset.clone();
        return result;
    }
}


/***/ }),

/***/ "./Collision/Colliders/EdgeCollider.ts":
/*!*********************************************!*\
  !*** ./Collision/Colliders/EdgeCollider.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EdgeCollider: () => (/* binding */ EdgeCollider)
/* harmony export */ });
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CollisionJumpTable */ "./Collision/Colliders/CollisionJumpTable.ts");
/* harmony import */ var _CircleCollider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CircleCollider */ "./Collision/Colliders/CircleCollider.ts");
/* harmony import */ var _PolygonCollider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./PolygonCollider */ "./Collision/Colliders/PolygonCollider.ts");
/* harmony import */ var _Math_projection__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../Math/projection */ "./Math/projection.ts");
/* harmony import */ var _Math_line_segment__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../Math/line-segment */ "./Math/line-segment.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Collider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Collider */ "./Collision/Colliders/Collider.ts");
/* harmony import */ var _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ClosestLineJumpTable */ "./Collision/Colliders/ClosestLineJumpTable.ts");
/* harmony import */ var _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/affine-matrix */ "./Math/affine-matrix.ts");
/* harmony import */ var _Index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Index */ "./Collision/BodyComponent.ts");











/**
 * Edge is a single line collider to create collisions with a single line.
 */
class EdgeCollider extends _Collider__WEBPACK_IMPORTED_MODULE_0__.Collider {
    constructor(options) {
        var _a;
        super();
        this._globalMatrix = _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_1__.AffineMatrix.identity();
        this.begin = options.begin || _Math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector.Zero;
        this.end = options.end || _Math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector.Zero;
        this.offset = (_a = options.offset) !== null && _a !== void 0 ? _a : _Math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector.Zero;
    }
    /**
     * Returns a clone of this Edge, not associated with any collider
     */
    clone() {
        return new EdgeCollider({
            begin: this.begin.clone(),
            end: this.end.clone()
        });
    }
    get worldPos() {
        var _a;
        const tx = this._transform;
        return (_a = tx === null || tx === void 0 ? void 0 : tx.globalPos.add(this.offset)) !== null && _a !== void 0 ? _a : this.offset;
    }
    /**
     * Get the center of the collision area in world coordinates
     */
    get center() {
        const begin = this._getTransformedBegin();
        const end = this._getTransformedEnd();
        const pos = begin.average(end);
        return pos;
    }
    _getTransformedBegin() {
        return this._globalMatrix.multiply(this.begin);
    }
    _getTransformedEnd() {
        return this._globalMatrix.multiply(this.end);
    }
    /**
     * Returns the slope of the line in the form of a vector
     */
    getSlope() {
        const begin = this._getTransformedBegin();
        const end = this._getTransformedEnd();
        const distance = begin.distance(end);
        return end.sub(begin).scale(1 / distance);
    }
    /**
     * Returns the length of the line segment in pixels
     */
    getLength() {
        const begin = this._getTransformedBegin();
        const end = this._getTransformedEnd();
        const distance = begin.distance(end);
        return distance;
    }
    /**
     * Tests if a point is contained in this collision area
     */
    contains() {
        return false;
    }
    /**
     * @inheritdoc
     */
    rayCast(ray, max = Infinity) {
        var _a;
        const numerator = this._getTransformedBegin().sub(ray.pos);
        // Test is line and ray are parallel and non intersecting
        if (ray.dir.cross(this.getSlope()) === 0 && numerator.cross(ray.dir) !== 0) {
            return null;
        }
        // Lines are parallel
        const divisor = ray.dir.cross(this.getSlope());
        if (divisor === 0) {
            return null;
        }
        const t = numerator.cross(this.getSlope()) / divisor;
        if (t >= 0 && t <= max) {
            const u = numerator.cross(ray.dir) / divisor / this.getLength();
            if (u >= 0 && u <= 1) {
                return {
                    distance: t,
                    normal: this.asLine().normal(),
                    collider: this,
                    body: (_a = this.owner) === null || _a === void 0 ? void 0 : _a.get(_Index__WEBPACK_IMPORTED_MODULE_3__.BodyComponent),
                    point: ray.getPoint(t)
                };
            }
        }
        return null;
    }
    /**
     * Returns the closes line between this and another collider, from this -> collider
     * @param shape
     */
    getClosestLineBetween(shape) {
        if (shape instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_4__.CircleCollider) {
            return _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_5__.ClosestLineJumpTable.CircleEdgeClosestLine(shape, this);
        }
        else if (shape instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_6__.PolygonCollider) {
            return _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_5__.ClosestLineJumpTable.PolygonEdgeClosestLine(shape, this).flip();
        }
        else if (shape instanceof EdgeCollider) {
            return _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_5__.ClosestLineJumpTable.EdgeEdgeClosestLine(this, shape);
        }
        else {
            throw new Error(`Polygon could not collide with unknown CollisionShape ${typeof shape}`);
        }
    }
    /**
     * @inheritdoc
     */
    collide(shape) {
        if (shape instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_4__.CircleCollider) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_7__.CollisionJumpTable.CollideCircleEdge(shape, this);
        }
        else if (shape instanceof _PolygonCollider__WEBPACK_IMPORTED_MODULE_6__.PolygonCollider) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_7__.CollisionJumpTable.CollidePolygonEdge(shape, this);
        }
        else if (shape instanceof EdgeCollider) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_7__.CollisionJumpTable.CollideEdgeEdge();
        }
        else {
            throw new Error(`Edge could not collide with unknown CollisionShape ${typeof shape}`);
        }
    }
    /**
     * Find the point on the collider furthest in the direction specified
     */
    getFurthestPoint(direction) {
        const transformedBegin = this._getTransformedBegin();
        const transformedEnd = this._getTransformedEnd();
        if (direction.dot(transformedBegin) > 0) {
            return transformedBegin;
        }
        else {
            return transformedEnd;
        }
    }
    _boundsFromBeginEnd(begin, end, padding = 10) {
        // A perfectly vertical or horizontal edge would have a bounds 0 width or height
        // this causes problems for the collision system so we give them some padding
        return new _BoundingBox__WEBPACK_IMPORTED_MODULE_8__.BoundingBox(Math.min(begin.x, end.x) - padding, Math.min(begin.y, end.y) - padding, Math.max(begin.x, end.x) + padding, Math.max(begin.y, end.y) + padding);
    }
    /**
     * Get the axis aligned bounding box for the edge collider in world space
     */
    get bounds() {
        const transformedBegin = this._getTransformedBegin();
        const transformedEnd = this._getTransformedEnd();
        return this._boundsFromBeginEnd(transformedBegin, transformedEnd);
    }
    /**
     * Get the axis aligned bounding box for the edge collider in local space
     */
    get localBounds() {
        return this._boundsFromBeginEnd(this.begin, this.end);
    }
    /**
     * Returns this edge represented as a line in world coordinates
     */
    asLine() {
        return new _Math_line_segment__WEBPACK_IMPORTED_MODULE_9__.LineSegment(this._getTransformedBegin(), this._getTransformedEnd());
    }
    /**
     * Return this edge as a line in local line coordinates (relative to the position)
     */
    asLocalLine() {
        return new _Math_line_segment__WEBPACK_IMPORTED_MODULE_9__.LineSegment(this.begin, this.end);
    }
    /**
     * Get the axis associated with the edge
     */
    get axes() {
        const e = this._getTransformedEnd().sub(this._getTransformedBegin());
        const edgeNormal = e.normal();
        const axes = [];
        axes.push(edgeNormal);
        axes.push(edgeNormal.negate());
        axes.push(edgeNormal.normal());
        axes.push(edgeNormal.normal().negate());
        return axes;
    }
    /**
     * Get the moment of inertia for an edge
     * https://en.wikipedia.org/wiki/List_of_moments_of_inertia
     */
    getInertia(mass) {
        const length = this.end.sub(this.begin).distance() / 2;
        return mass * length * length;
    }
    /**
     * @inheritdoc
     */
    update(transform) {
        var _a;
        this._transform = transform;
        const globalMat = (_a = transform.matrix) !== null && _a !== void 0 ? _a : this._globalMatrix;
        globalMat.clone(this._globalMatrix);
        this._globalMatrix.translate(this.offset.x, this.offset.y);
    }
    /**
     * Project the edge along a specified axis
     */
    project(axis) {
        const scalars = [];
        const points = [this._getTransformedBegin(), this._getTransformedEnd()];
        const len = points.length;
        for (let i = 0; i < len; i++) {
            scalars.push(points[i].dot(axis));
        }
        return new _Math_projection__WEBPACK_IMPORTED_MODULE_10__.Projection(Math.min.apply(Math, scalars), Math.max.apply(Math, scalars));
    }
    debug(ex, color) {
        const begin = this._getTransformedBegin();
        const end = this._getTransformedEnd();
        ex.drawLine(begin, end, color, 2);
        ex.drawCircle(begin, 2, color);
        ex.drawCircle(end, 2, color);
    }
}


/***/ }),

/***/ "./Collision/Colliders/PolygonCollider.ts":
/*!************************************************!*\
  !*** ./Collision/Colliders/PolygonCollider.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PolygonCollider: () => (/* binding */ PolygonCollider)
/* harmony export */ });
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _EdgeCollider__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./EdgeCollider */ "./Collision/Colliders/EdgeCollider.ts");
/* harmony import */ var _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./CollisionJumpTable */ "./Collision/Colliders/CollisionJumpTable.ts");
/* harmony import */ var _CircleCollider__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./CircleCollider */ "./Collision/Colliders/CircleCollider.ts");
/* harmony import */ var _Math_projection__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../Math/projection */ "./Math/projection.ts");
/* harmony import */ var _Math_line_segment__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Math/line-segment */ "./Math/line-segment.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Math_ray__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../Math/ray */ "./Math/ray.ts");
/* harmony import */ var _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ClosestLineJumpTable */ "./Collision/Colliders/ClosestLineJumpTable.ts");
/* harmony import */ var _Collider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Collider */ "./Collision/Colliders/Collider.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../.. */ "./Util/Log.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../.. */ "./Math/util.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../.. */ "./Collision/BodyComponent.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../.. */ "./Graphics/Debug.ts");
/* harmony import */ var _CompositeCollider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CompositeCollider */ "./Collision/Colliders/CompositeCollider.ts");
/* harmony import */ var _Shape__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Shape */ "./Collision/Colliders/Shape.ts");
/* harmony import */ var _Math_transform__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Math/transform */ "./Math/transform.ts");














/**
 * Polygon collider for detecting collisions
 */
class PolygonCollider extends _Collider__WEBPACK_IMPORTED_MODULE_0__.Collider {
    flagDirty() {
        this._localBoundsDirty = true;
        this._localSidesDirty = true;
        this._transformedPointsDirty = true;
        this._sidesDirty = true;
    }
    get normals() {
        return this._normals;
    }
    /**
     * Points in the polygon in order around the perimeter in local coordinates. These are relative from the body transform position.
     * Excalibur stores these in counter-clockwise order
     */
    set points(points) {
        if (points.length < 3) {
            throw new Error('PolygonCollider cannot be created with less that 3 points');
        }
        this._points = points;
        this._checkAndUpdateWinding(this._points);
        this._calculateNormals();
        this.flagDirty();
    }
    _calculateNormals() {
        const normals = [];
        for (let i = 0; i < this._points.length; i++) {
            normals.push(this._points[(i + 1) % this._points.length].sub(this._points[i]).normal());
        }
        this._normals = normals;
    }
    /**
     * Points in the polygon in order around the perimeter in local coordinates. These are relative from the body transform position.
     * Excalibur stores these in counter-clockwise order
     */
    get points() {
        return this._points;
    }
    get transform() {
        return this._transform;
    }
    constructor(options) {
        var _a;
        super();
        this._logger = ___WEBPACK_IMPORTED_MODULE_1__.Logger.getInstance();
        this._transform = new _Math_transform__WEBPACK_IMPORTED_MODULE_2__.Transform();
        this._transformedPoints = [];
        this._sides = [];
        this._localSides = [];
        this._transformedPointsDirty = true;
        this._sidesDirty = true;
        this._localSidesDirty = true;
        this._localBoundsDirty = true;
        this.offset = (_a = options.offset) !== null && _a !== void 0 ? _a : _Math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector.Zero;
        this._transform.pos.x += this.offset.x;
        this._transform.pos.y += this.offset.y;
        this.points = options.points;
        if (!this.isConvex()) {
            if (!options.suppressConvexWarning) {
                this._logger.warn('Excalibur only supports convex polygon colliders and will not behave properly.' +
                    'Call PolygonCollider.triangulate() to build a new collider composed of smaller convex triangles');
            }
        }
        // calculate initial transformation
        this._calculateTransformation();
    }
    _checkAndUpdateWinding(points) {
        const counterClockwise = this._isCounterClockwiseWinding(points);
        if (!counterClockwise) {
            points.reverse();
        }
    }
    _isCounterClockwiseWinding(points) {
        // https://stackoverflow.com/a/1165943
        let sum = 0;
        for (let i = 0; i < points.length; i++) {
            sum += (points[(i + 1) % points.length].x - points[i].x) * (points[(i + 1) % points.length].y + points[i].y);
        }
        return sum < 0;
    }
    /**
     * Returns if the polygon collider is convex, Excalibur does not handle non-convex collision shapes.
     * Call {@apilink Polygon.triangulate} to generate a {@apilink CompositeCollider} from this non-convex shape
     */
    isConvex() {
        // From SO: https://stackoverflow.com/a/45372025
        if (this.points.length < 3) {
            return false;
        }
        let oldPoint = this.points[this.points.length - 2];
        let newPoint = this.points[this.points.length - 1];
        let direction = Math.atan2(newPoint.y - oldPoint.y, newPoint.x - oldPoint.x);
        let oldDirection = 0;
        let orientation = 0;
        let angleSum = 0;
        for (const [i, point] of this.points.entries()) {
            oldPoint = newPoint;
            oldDirection = direction;
            newPoint = point;
            direction = Math.atan2(newPoint.y - oldPoint.y, newPoint.x - oldPoint.x);
            if (oldPoint.equals(newPoint)) {
                return false; // repeat point
            }
            let angle = direction - oldDirection;
            if (angle <= -Math.PI) {
                angle += Math.PI * 2;
            }
            else if (angle > Math.PI) {
                angle -= Math.PI * 2;
            }
            if (i === 0) {
                if (angle === 0.0) {
                    return false;
                }
                orientation = angle > 0 ? 1 : -1;
            }
            else {
                if (orientation * angle <= 0) {
                    return false;
                }
            }
            angleSum += angle;
        }
        return Math.abs(Math.round(angleSum / (Math.PI * 2))) === 1;
    }
    /**
     * Tessellates the polygon into a triangle fan as a {@apilink CompositeCollider} of triangle polygons
     */
    tessellate() {
        const polygons = [];
        for (let i = 1; i < this.points.length - 2; i++) {
            polygons.push([this.points[0], this.points[i + 1], this.points[i + 2]]);
        }
        polygons.push([this.points[0], this.points[1], this.points[2]]);
        return new _CompositeCollider__WEBPACK_IMPORTED_MODULE_4__.CompositeCollider(polygons.map((points) => _Shape__WEBPACK_IMPORTED_MODULE_5__.Shape.Polygon(points)));
    }
    /**
     * Triangulate the polygon collider using the "Ear Clipping" algorithm.
     * Returns a new {@apilink CompositeCollider} made up of smaller triangles.
     */
    triangulate() {
        // https://www.youtube.com/watch?v=hTJFcHutls8
        if (this.points.length < 3) {
            throw Error('Invalid polygon');
        }
        const triangles = [];
        // algorithm likes clockwise
        const vertices = [...this.points].reverse();
        let vertexCount = vertices.length;
        /**
         * Returns the previous index based on the current vertex
         */
        function getPrevIndex(index) {
            return index === 0 ? vertexCount - 1 : index - 1;
        }
        /**
         * Retrieves the next index based on the current vertex
         */
        function getNextIndex(index) {
            return index === vertexCount - 1 ? 0 : index + 1;
        }
        /**
         * Whether or not the angle at this vertex index is convex
         */
        function isConvex(index) {
            const prev = getPrevIndex(index);
            const next = getNextIndex(index);
            const va = vertices[prev];
            const vb = vertices[index];
            const vc = vertices[next];
            // Check convexity
            const leftArm = va.sub(vb);
            const rightArm = vc.sub(vb);
            // Positive cross product is convex
            if (leftArm.cross(rightArm) < 0) {
                return false;
            }
            return true;
        }
        const convexVertices = vertices.map((_, i) => isConvex(i));
        /**
         * Quick test for point in triangle
         */
        function isPointInTriangle(point, a, b, c) {
            const ab = b.sub(a);
            const bc = c.sub(b);
            const ca = a.sub(c);
            const ap = point.sub(a);
            const bp = point.sub(b);
            const cp = point.sub(c);
            const cross1 = ab.cross(ap);
            const cross2 = bc.cross(bp);
            const cross3 = ca.cross(cp);
            if (cross1 > 0 || cross2 > 0 || cross3 > 0) {
                return false;
            }
            return true;
        }
        /**
         * Calculate the area of the triangle
         */
        // function triangleArea(a: Vector, b: Vector, c: Vector) {
        //   return Math.abs(a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - c.y))/2;
        // }
        /**
         * Find the next suitable ear tip
         */
        function findEarTip() {
            for (let i = 0; i < vertexCount; i++) {
                if (convexVertices[i]) {
                    const prev = getPrevIndex(i);
                    const next = getNextIndex(i);
                    const va = vertices[prev];
                    const vb = vertices[i];
                    const vc = vertices[next];
                    let isEar = true;
                    // Check that if any vertices are in the triangle a, b, c
                    for (let j = 0; j < vertexCount; j++) {
                        // We can skip these verts because they are the triangle we are testing
                        if (j === i || j === prev || j === next) {
                            continue;
                        }
                        const point = vertices[j];
                        if (isPointInTriangle(point, va, vb, vc)) {
                            isEar = false;
                            break;
                        }
                    }
                    // Add ear to polygon list and remove from list
                    if (isEar) {
                        return i;
                    }
                }
            }
            // Fall back to any convex vertex
            for (let i = 0; i < vertexCount; i++) {
                if (convexVertices[i]) {
                    return i;
                }
            }
            // bail and return the first one?
            return 0;
        }
        /**
         * Cut the ear and produce a triangle, update internal state
         */
        function cutEarTip(index) {
            const prev = getPrevIndex(index);
            const next = getNextIndex(index);
            const va = vertices[prev];
            const vb = vertices[index];
            const vc = vertices[next];
            // Clockwise winding
            // if (triangleArea(va, vb, vc) > 0) {
            triangles.push([va, vb, vc]);
            // }
            vertices.splice(index, 1);
            convexVertices.splice(index, 1);
            vertexCount--;
        }
        // Loop over all the vertices finding ears
        while (vertexCount > 3) {
            const earIndex = findEarTip();
            cutEarTip(earIndex);
            // reclassify vertices
            for (let i = 0; i < vertexCount; i++) {
                convexVertices[i] = isConvex(i);
            }
        }
        // Last triangle after the loop
        triangles.push([vertices[0], vertices[1], vertices[2]]);
        // FIXME: there is a colinear triangle that sneaks in here sometimes
        return new _CompositeCollider__WEBPACK_IMPORTED_MODULE_4__.CompositeCollider(triangles.map((points) => _Shape__WEBPACK_IMPORTED_MODULE_5__.Shape.Polygon(points, _Math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector.Zero, true)));
    }
    /**
     * Returns a clone of this ConvexPolygon, not associated with any collider
     */
    clone() {
        return new PolygonCollider({
            offset: this.offset.clone(),
            points: this.points.map((p) => p.clone())
        });
    }
    /**
     * Returns the world position of the collider, which is the current body transform plus any defined offset
     */
    get worldPos() {
        return this._transform.pos;
    }
    /**
     * Get the center of the collider in world coordinates
     */
    get center() {
        return this.bounds.center;
    }
    /**
     * Calculates the underlying transformation from the body relative space to world space
     */
    _calculateTransformation() {
        const points = this.points;
        const len = points.length;
        this._transformedPoints.length = 0; // clear out old transform
        for (let i = 0; i < len; i++) {
            this._transformedPoints[i] = this._transform.apply(points[i].clone());
        }
    }
    /**
     * Gets the points that make up the polygon in world space, from actor relative space (if specified)
     */
    getTransformedPoints() {
        if (this._transformedPointsDirty) {
            this._calculateTransformation();
            this._transformedPointsDirty = false;
        }
        return this._transformedPoints;
    }
    /**
     * Gets the sides of the polygon in world space
     */
    getSides() {
        if (this._sidesDirty) {
            const lines = [];
            const points = this.getTransformedPoints();
            const len = points.length;
            for (let i = 0; i < len; i++) {
                // This winding is important
                lines.push(new _Math_line_segment__WEBPACK_IMPORTED_MODULE_6__.LineSegment(points[i], points[(i + 1) % len]));
            }
            this._sides = lines;
            this._sidesDirty = false;
        }
        return this._sides;
    }
    /**
     * Returns the local coordinate space sides
     */
    getLocalSides() {
        if (this._localSidesDirty) {
            const lines = [];
            const points = this.points;
            const len = points.length;
            for (let i = 0; i < len; i++) {
                // This winding is important
                lines.push(new _Math_line_segment__WEBPACK_IMPORTED_MODULE_6__.LineSegment(points[i], points[(i + 1) % len]));
            }
            this._localSides = lines;
            this._localSidesDirty = false;
        }
        return this._localSides;
    }
    /**
     * Given a direction vector find the world space side that is most in that direction
     * @param direction
     */
    findSide(direction) {
        const sides = this.getSides();
        let bestSide = sides[0];
        let maxDistance = -Number.MAX_VALUE;
        for (let side = 0; side < sides.length; side++) {
            const currentSide = sides[side];
            const sideNormal = currentSide.normal();
            const mostDirection = sideNormal.dot(direction);
            if (mostDirection > maxDistance) {
                bestSide = currentSide;
                maxDistance = mostDirection;
            }
        }
        return bestSide;
    }
    /**
     * Given a direction vector find the local space side that is most in that direction
     * @param direction
     */
    findLocalSide(direction) {
        const sides = this.getLocalSides();
        let bestSide = sides[0];
        let maxDistance = -Number.MAX_VALUE;
        for (let side = 0; side < sides.length; side++) {
            const currentSide = sides[side];
            const sideNormal = currentSide.normal();
            const mostDirection = sideNormal.dot(direction);
            if (mostDirection > maxDistance) {
                bestSide = currentSide;
                maxDistance = mostDirection;
            }
        }
        return bestSide;
    }
    /**
     * Get the axis associated with the convex polygon
     */
    get axes() {
        const axes = [];
        const sides = this.getSides();
        for (let i = 0; i < sides.length; i++) {
            axes.push(sides[i].normal());
        }
        return axes;
    }
    /**
     * Updates the transform for the collision geometry
     *
     * Collision geometry (points/bounds) will not change until this is called.
     * @param transform
     */
    update(transform) {
        if (transform) {
            // This change means an update must be performed in order for geometry to update
            transform.cloneWithParent(this._transform);
            this._transformedPointsDirty = true;
            this._sidesDirty = true;
            if (this.offset.x !== 0 || this.offset.y !== 0) {
                this._transform.pos.x += this.offset.x;
                this._transform.pos.y += this.offset.y;
            }
            if (this._transform.isMirrored()) {
                // negative transforms really mess with things in collision local space
                // flatten out the negatives by applying to geometry
                this.points = this.points.map((p) => (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(p.x * (0,___WEBPACK_IMPORTED_MODULE_7__.sign)(this._transform.scale.x), p.y * (0,___WEBPACK_IMPORTED_MODULE_7__.sign)(this._transform.scale.y)));
                this._transform.scale.x = Math.abs(this._transform.scale.x);
                this._transform.scale.y = Math.abs(this._transform.scale.y);
            }
        }
    }
    /**
     * Tests if a point is contained in this collider in world space
     */
    contains(point) {
        // Always cast to the right, as long as we cast in a consistent fixed direction we
        // will be fine
        const localPoint = this._transform.applyInverse(point);
        const testRay = new _Math_ray__WEBPACK_IMPORTED_MODULE_8__.Ray(localPoint, new _Math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector(1, 0));
        let intersectCount = 0;
        const sides = this.getLocalSides();
        for (let sideIndex = 0; sideIndex < sides.length; sideIndex++) {
            const side = sides[sideIndex];
            if (testRay.intersect(side) >= 0) {
                intersectCount++;
            }
        }
        if (intersectCount % 2 === 0) {
            return false;
        }
        return true;
    }
    getClosestLineBetween(collider) {
        if (collider instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_9__.CircleCollider) {
            return _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_10__.ClosestLineJumpTable.PolygonCircleClosestLine(this, collider);
        }
        else if (collider instanceof PolygonCollider) {
            return _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_10__.ClosestLineJumpTable.PolygonPolygonClosestLine(this, collider);
        }
        else if (collider instanceof _EdgeCollider__WEBPACK_IMPORTED_MODULE_11__.EdgeCollider) {
            return _ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_10__.ClosestLineJumpTable.PolygonEdgeClosestLine(this, collider);
        }
        else {
            throw new Error(`Polygon could not collide with unknown CollisionShape ${typeof collider}`);
        }
    }
    /**
     * Returns a collision contact if the 2 colliders collide, otherwise collide will
     * return null.
     * @param collider
     */
    collide(collider) {
        if (collider instanceof _CircleCollider__WEBPACK_IMPORTED_MODULE_9__.CircleCollider) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_12__.CollisionJumpTable.CollideCirclePolygon(collider, this);
        }
        else if (collider instanceof PolygonCollider) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_12__.CollisionJumpTable.CollidePolygonPolygon(this, collider);
        }
        else if (collider instanceof _EdgeCollider__WEBPACK_IMPORTED_MODULE_11__.EdgeCollider) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_12__.CollisionJumpTable.CollidePolygonEdge(this, collider);
        }
        else {
            throw new Error(`Polygon could not collide with unknown CollisionShape ${typeof collider}`);
        }
    }
    /**
     * Find the point on the collider furthest in the direction specified
     */
    getFurthestPoint(direction) {
        const pts = this.getTransformedPoints();
        let furthestPoint = null;
        let maxDistance = -Number.MAX_VALUE;
        for (let i = 0; i < pts.length; i++) {
            const distance = direction.dot(pts[i]);
            if (distance > maxDistance) {
                maxDistance = distance;
                furthestPoint = pts[i];
            }
        }
        return furthestPoint;
    }
    /**
     * Find the local point on the collider furthest in the direction specified
     * @param direction
     */
    getFurthestLocalPoint(direction) {
        const pts = this.points;
        let furthestPoint = pts[0];
        let maxDistance = -Number.MAX_VALUE;
        for (let i = 0; i < pts.length; i++) {
            const distance = direction.dot(pts[i]);
            if (distance > maxDistance) {
                maxDistance = distance;
                furthestPoint = pts[i];
            }
        }
        return furthestPoint;
    }
    /**
     * Finds the closes face to the point using perpendicular distance
     * @param point point to test against polygon
     */
    getClosestFace(point) {
        const sides = this.getSides();
        let min = Number.POSITIVE_INFINITY;
        let faceIndex = -1;
        let distance = -1;
        for (let i = 0; i < sides.length; i++) {
            const dist = sides[i].distanceToPoint(point);
            if (dist < min) {
                min = dist;
                faceIndex = i;
                distance = dist;
            }
        }
        if (faceIndex !== -1) {
            return {
                distance: sides[faceIndex].normal().scale(distance),
                face: sides[faceIndex]
            };
        }
        return null;
    }
    /**
     * Get the axis aligned bounding box for the polygon collider in world coordinates
     */
    get bounds() {
        return this.localBounds.transform(this._transform.matrix);
    }
    /**
     * Get the axis aligned bounding box for the polygon collider in local coordinates
     */
    get localBounds() {
        if (this._localBoundsDirty) {
            this._localBounds = _BoundingBox__WEBPACK_IMPORTED_MODULE_13__.BoundingBox.fromPoints(this.points);
            this._localBoundsDirty = false;
        }
        return this._localBounds;
    }
    /**
     * Get the moment of inertia for an arbitrary polygon
     * https://en.wikipedia.org/wiki/List_of_moments_of_inertia
     */
    getInertia(mass) {
        if (this._cachedMass === mass && this._cachedInertia) {
            return this._cachedInertia;
        }
        let numerator = 0;
        let denominator = 0;
        const points = this.points;
        for (let i = 0; i < points.length; i++) {
            const iplusone = (i + 1) % points.length;
            const crossTerm = points[iplusone].cross(points[i]);
            numerator += crossTerm * (points[i].dot(points[i]) + points[i].dot(points[iplusone]) + points[iplusone].dot(points[iplusone]));
            denominator += crossTerm;
        }
        this._cachedMass = mass;
        return (this._cachedInertia = (mass / 6) * (numerator / denominator));
    }
    /**
     * Casts a ray into the polygon and returns a vector representing the point of contact (in world space) or null if no collision.
     */
    rayCast(ray, max = Infinity) {
        var _a;
        // find the minimum contact time greater than 0
        // contact times less than 0 are behind the ray and we don't want those
        const sides = this.getSides();
        const len = sides.length;
        let minContactTime = Number.MAX_VALUE;
        let contactSide;
        let contactIndex = -1;
        for (let i = 0; i < len; i++) {
            const contactTime = ray.intersect(sides[i]);
            if (contactTime >= 0 && contactTime < minContactTime && contactTime <= max) {
                minContactTime = contactTime;
                contactSide = sides[i];
                contactIndex = i;
            }
        }
        // contact was found
        if (contactIndex >= 0) {
            return {
                collider: this,
                distance: minContactTime,
                body: (_a = this.owner) === null || _a === void 0 ? void 0 : _a.get(___WEBPACK_IMPORTED_MODULE_14__.BodyComponent),
                point: ray.getPoint(minContactTime),
                normal: contactSide.normal()
            };
        }
        // no contact found
        return null;
    }
    /**
     * Project the edges of the polygon along a specified axis
     */
    project(axis) {
        const points = this.getTransformedPoints();
        const len = points.length;
        let min = Number.MAX_VALUE;
        let max = -Number.MAX_VALUE;
        for (let i = 0; i < len; i++) {
            const scalar = points[i].dot(axis);
            min = Math.min(min, scalar);
            max = Math.max(max, scalar);
        }
        return new _Math_projection__WEBPACK_IMPORTED_MODULE_15__.Projection(min, max);
    }
    debug(ex, color, options) {
        const points = this.getTransformedPoints();
        ___WEBPACK_IMPORTED_MODULE_16__.Debug.drawPolygon(points, { color });
    }
}


/***/ }),

/***/ "./Collision/Colliders/SeparatingAxis.ts":
/*!***********************************************!*\
  !*** ./Collision/Colliders/SeparatingAxis.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SeparatingAxis: () => (/* binding */ SeparatingAxis),
/* harmony export */   SeparationInfo: () => (/* binding */ SeparationInfo)
/* harmony export */ });
/* harmony import */ var _Math_line_segment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/line-segment */ "./Math/line-segment.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math/affine-matrix */ "./Math/affine-matrix.ts");
/* harmony import */ var _Util_Pool__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Util/Pool */ "./Util/Pool.ts");




/**
 * Specific information about a contact and it's separation
 */
class SeparationInfo {
    constructor() {
        /**
         * Axis of separation from the collider's perspective
         */
        this.axis = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        /**
         * Local axis of separation from the collider's perspective
         */
        this.localAxis = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        /**
         * Side of separation (reference) from the collider's perspective
         */
        this.side = new _Math_line_segment__WEBPACK_IMPORTED_MODULE_1__.LineSegment((0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0), (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0));
        /**
         * Local side of separation (reference) from the collider's perspective
         */
        this.localSide = new _Math_line_segment__WEBPACK_IMPORTED_MODULE_1__.LineSegment((0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0), (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0));
        /**
         * Point on collider B (incident point)
         */
        this.point = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        /**
         * Local point on collider B (incident point)
         */
        this.localPoint = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
    }
}
class SeparatingAxis {
    static findPolygonPolygonSeparation(polyA, polyB) {
        // if polyB has 0 scale we need to hop back to degenerate separation
        if (polyB.transform.matrix.determinant() === 0) {
            return SeparatingAxis.findPolygonPolygonSeparationDegenerate(polyA, polyB);
        }
        // Multi contact from SAT
        // https://gamedev.stackexchange.com/questions/111390/multiple-contacts-for-sat-collision-detection
        // do a SAT test to find a min axis if it exists
        let bestSeparation = -Number.MAX_VALUE;
        let bestSideIndex = -1;
        let localPoint;
        // Work inside polyB reference frame
        // inv polyB converts to local space from polyA world space
        const toPolyBSpace = polyB.transform.inverse.multiply(polyA.transform.matrix, SeparatingAxis._SCRATCH_MATRIX);
        const toPolyBSpaceRotation = toPolyBSpace.getRotation();
        const normalsA = polyA.normals;
        const pointsA = polyA.points;
        const pointsB = polyB.points;
        for (let pointsAIndex = 0; pointsAIndex < pointsA.length; pointsAIndex++) {
            const normal = normalsA[pointsAIndex].rotate(toPolyBSpaceRotation, SeparatingAxis._ZERO, SeparatingAxis._SCRATCH_NORMAL);
            const point = toPolyBSpace.multiply(pointsA[pointsAIndex], SeparatingAxis._SCRATCH_POINT);
            // For every point in polyB
            // We want to see how much overlap there is on the axis provided by the normal
            // We want to find the minimum overlap among all points
            let smallestPointDistance = Number.MAX_VALUE;
            let smallestLocalPoint;
            for (let pointsBIndex = 0; pointsBIndex < pointsB.length; pointsBIndex++) {
                const distance = normal.dot(pointsB[pointsBIndex].sub(point, SeparatingAxis._SCRATCH_SUB_POINT));
                if (distance < smallestPointDistance) {
                    smallestPointDistance = distance;
                    smallestLocalPoint = pointsB[pointsBIndex];
                }
            }
            // We take the maximum overlap as the separation between the
            // A negative separation means there were no gaps between the two shapes
            if (smallestPointDistance > bestSeparation) {
                bestSeparation = smallestPointDistance;
                bestSideIndex = pointsAIndex;
                localPoint = smallestLocalPoint;
            }
        }
        // TODO can we avoid applying world space transforms?
        const bestSide2 = (bestSideIndex + 1) % pointsA.length;
        const separationInfo = SeparatingAxis.SeparationPool.get();
        separationInfo.collider = polyA;
        separationInfo.separation = bestSeparation;
        if (bestSeparation > 0) {
            // early out because if separation is > 0 then no local point
            return separationInfo;
        }
        normalsA[bestSideIndex].clone(separationInfo.localAxis);
        normalsA[bestSideIndex].rotate(polyA.transform.rotation, SeparatingAxis._ZERO, separationInfo.axis);
        polyA.transform.matrix.multiply(pointsA[bestSideIndex], separationInfo.side.begin);
        polyA.transform.matrix.multiply(pointsA[bestSide2], separationInfo.side.end);
        polyB.transform.matrix.multiply(localPoint, separationInfo.point);
        separationInfo.sideId = bestSideIndex;
        localPoint.clone(separationInfo.localPoint);
        pointsA[bestSideIndex].clone(separationInfo.localSide.begin);
        pointsA[bestSide2].clone(separationInfo.localSide.end);
        return separationInfo;
    }
    static findCirclePolygonSeparation(circle, polygon) {
        const axes = polygon.axes;
        const pc = polygon.center;
        // Special SAT with circles
        const polyDir = pc.sub(circle.worldPos);
        const closestPointOnPoly = polygon.getFurthestPoint(polyDir.negate());
        axes.push(closestPointOnPoly.sub(circle.worldPos).normalize());
        let minOverlap = Number.MAX_VALUE;
        let minAxis = null;
        let minIndex = -1;
        for (let i = 0; i < axes.length; i++) {
            const proj1 = polygon.project(axes[i]);
            const proj2 = circle.project(axes[i]);
            const overlap = proj1.getOverlap(proj2);
            if (overlap <= 0) {
                return null;
            }
            else {
                if (overlap < minOverlap) {
                    minOverlap = overlap;
                    minAxis = axes[i];
                    minIndex = i;
                }
            }
        }
        if (minIndex < 0) {
            return null;
        }
        return minAxis.normalize().scale(minOverlap);
    }
    static findPolygonPolygonSeparationDegenerate(polyA, polyB) {
        let bestSeparation = -Number.MAX_VALUE;
        let bestSide = null;
        let bestAxis = null;
        let bestSideIndex = -1;
        let bestOtherPoint = null;
        const sides = polyA.getSides();
        const localSides = polyA.getLocalSides();
        for (let i = 0; i < sides.length; i++) {
            const side = sides[i];
            const axis = side.normal();
            const vertB = polyB.getFurthestPoint(axis.negate());
            // Separation on side i's axis
            // We are looking for the largest separation between poly A's sides
            const vertSeparation = side.distanceToPoint(vertB, true);
            if (vertSeparation > bestSeparation) {
                bestSeparation = vertSeparation;
                bestSide = side;
                bestAxis = axis;
                bestSideIndex = i;
                bestOtherPoint = vertB;
            }
        }
        return {
            collider: polyA,
            separation: bestAxis ? bestSeparation : 99,
            axis: bestAxis,
            side: bestSide,
            localSide: localSides[bestSideIndex],
            sideId: bestSideIndex,
            point: bestOtherPoint,
            localPoint: bestAxis ? polyB.getFurthestLocalPoint(bestAxis.negate()) : null
        };
    }
}
SeparatingAxis.SeparationPool = new _Util_Pool__WEBPACK_IMPORTED_MODULE_2__.Pool(() => new SeparationInfo(), (i) => i, // no recycle
500);
SeparatingAxis._ZERO = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
SeparatingAxis._SCRATCH_POINT = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
SeparatingAxis._SCRATCH_SUB_POINT = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
SeparatingAxis._SCRATCH_NORMAL = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
SeparatingAxis._SCRATCH_MATRIX = _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_3__.AffineMatrix.identity();
SeparatingAxis.SeparationPool.disableWarnings = true;


/***/ }),

/***/ "./Collision/Colliders/Shape.ts":
/*!**************************************!*\
  !*** ./Collision/Colliders/Shape.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Shape: () => (/* binding */ Shape)
/* harmony export */ });
/* harmony import */ var _PolygonCollider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PolygonCollider */ "./Collision/Colliders/PolygonCollider.ts");
/* harmony import */ var _CircleCollider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CircleCollider */ "./Collision/Colliders/CircleCollider.ts");
/* harmony import */ var _EdgeCollider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./EdgeCollider */ "./Collision/Colliders/EdgeCollider.ts");
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _CompositeCollider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./CompositeCollider */ "./Collision/Colliders/CompositeCollider.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../.. */ "./Util/Log.ts");







/**
 * Excalibur helper for defining colliders quickly
 */
class Shape {
    /**
     * Creates a box collider, under the hood defines a {@apilink PolygonCollider} collider
     * @param width Width of the box
     * @param height Height of the box
     * @param anchor Anchor of the box (default (.5, .5)) which positions the box relative to the center of the collider's position
     * @param offset Optional offset relative to the collider in local coordinates
     */
    static Box(width, height, anchor = _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Half, offset = _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero) {
        return new _PolygonCollider__WEBPACK_IMPORTED_MODULE_1__.PolygonCollider({
            points: new _BoundingBox__WEBPACK_IMPORTED_MODULE_2__.BoundingBox(-width * anchor.x, -height * anchor.y, width - width * anchor.x, height - height * anchor.y).getPoints(),
            offset: offset
        });
    }
    /**
     * Creates a new {@apilink PolygonCollider | `arbitrary polygon`} collider
     *
     * PolygonColliders are useful for creating convex polygon shapes
     * @param points Points specified in counter clockwise
     * @param offset Optional offset relative to the collider in local coordinates
     */
    static Polygon(points, offset = _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero, suppressConvexWarning = false) {
        return new _PolygonCollider__WEBPACK_IMPORTED_MODULE_1__.PolygonCollider({
            points: points,
            offset: offset,
            suppressConvexWarning
        });
    }
    /**
     * Creates a new {@apilink CircleCollider | `circle`} collider
     *
     * Circle colliders are useful for balls, or to make collisions more forgiving on sharp edges
     * @param radius Radius of the circle collider
     * @param offset Optional offset relative to the collider in local coordinates
     */
    static Circle(radius, offset = _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero) {
        return new _CircleCollider__WEBPACK_IMPORTED_MODULE_3__.CircleCollider({
            radius: radius,
            offset: offset
        });
    }
    /**
     * Creates a new {@apilink EdgeCollider | `edge`} collider
     *
     * Edge colliders are useful for  floors, walls, and other barriers
     * @param begin Beginning of the edge in local coordinates to the collider
     * @param end Ending of the edge in local coordinates to the collider
     */
    static Edge(begin, end) {
        return new _EdgeCollider__WEBPACK_IMPORTED_MODULE_4__.EdgeCollider({
            begin: begin,
            end: end
        });
    }
    /**
     * Creates a new capsule shaped {@apilink CompositeCollider} using 2 circles and a box
     *
     * Capsule colliders are useful for platformers with incline or jagged floors to have a smooth
     * player experience.
     * @param width
     * @param height
     * @param offset Optional offset
     */
    static Capsule(width, height, offset = _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero) {
        const logger = ___WEBPACK_IMPORTED_MODULE_5__.Logger.getInstance();
        if (width === height) {
            logger.warn('A capsule collider with equal width and height is a circle, consider using a ex.Shape.Circle or ex.CircleCollider');
        }
        const vertical = height >= width;
        if (vertical) {
            // height > width, if equal maybe use a circle
            const capsule = new _CompositeCollider__WEBPACK_IMPORTED_MODULE_6__.CompositeCollider([
                Shape.Circle(width / 2, (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, -height / 2 + width / 2).add(offset)),
                Shape.Box(width, height - width, _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Half, offset),
                Shape.Circle(width / 2, (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, height / 2 - width / 2).add(offset))
            ]);
            capsule.compositeStrategy = 'together';
            return capsule;
        }
        else {
            // width > height, if equal maybe use a circle
            const capsule = new _CompositeCollider__WEBPACK_IMPORTED_MODULE_6__.CompositeCollider([
                Shape.Circle(height / 2, (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(-width / 2 + height / 2, 0).add(offset)),
                Shape.Box(width - height, height, _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Half, offset),
                Shape.Circle(height / 2, (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(width / 2 - height / 2, 0).add(offset))
            ]);
            capsule.compositeStrategy = 'together';
            return capsule;
        }
    }
}


/***/ }),

/***/ "./Collision/CollisionSystem.ts":
/*!**************************************!*\
  !*** ./Collision/CollisionSystem.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CollisionSystem: () => (/* binding */ CollisionSystem)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../EntityComponentSystem */ "./EntityComponentSystem/Priority.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EntityComponentSystem/System */ "./EntityComponentSystem/System.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Events */ "./Events.ts");
/* harmony import */ var _SolverStrategy__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./SolverStrategy */ "./Collision/SolverStrategy.ts");
/* harmony import */ var _Solver_ArcadeSolver__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Solver/ArcadeSolver */ "./Collision/Solver/ArcadeSolver.ts");
/* harmony import */ var _Solver_RealisticSolver__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Solver/RealisticSolver */ "./Collision/Solver/RealisticSolver.ts");
/* harmony import */ var _ColliderComponent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ColliderComponent */ "./Collision/ColliderComponent.ts");
/* harmony import */ var _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Colliders/CompositeCollider */ "./Collision/Colliders/CompositeCollider.ts");
/* harmony import */ var _Collision_Side__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Collision/Side */ "./Collision/Side.ts");
/* harmony import */ var _Colliders_SeparatingAxis__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Colliders/SeparatingAxis */ "./Collision/Colliders/SeparatingAxis.ts");
/* harmony import */ var _MotionSystem__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./MotionSystem */ "./Collision/MotionSystem.ts");
/* harmony import */ var _Detection_Pair__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Detection/Pair */ "./Collision/Detection/Pair.ts");














class CollisionSystem extends _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__.System {
    get _processor() {
        return this._physics.collisionProcessor;
    }
    constructor(world, _physics) {
        super();
        this._physics = _physics;
        this.systemType = _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__.SystemType.Update;
        this._configDirty = false;
        this._lastFrameContacts = new Map();
        this._currentFrameContacts = new Map();
        this._arcadeSolver = new _Solver_ArcadeSolver__WEBPACK_IMPORTED_MODULE_1__.ArcadeSolver(_physics.config.arcade);
        this._realisticSolver = new _Solver_RealisticSolver__WEBPACK_IMPORTED_MODULE_2__.RealisticSolver(_physics.config.realistic);
        this._physics.$configUpdate.subscribe(() => (this._configDirty = true));
        this._trackCollider = (c) => this._processor.track(c);
        this._untrackCollider = (c) => this._processor.untrack(c);
        this.query = world.query([_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_3__.TransformComponent, _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_4__.MotionComponent, _ColliderComponent__WEBPACK_IMPORTED_MODULE_5__.ColliderComponent]);
        this.query.entityAdded$.subscribe((e) => {
            const colliderComponent = e.get(_ColliderComponent__WEBPACK_IMPORTED_MODULE_5__.ColliderComponent);
            colliderComponent.$colliderAdded.subscribe(this._trackCollider);
            colliderComponent.$colliderRemoved.subscribe(this._untrackCollider);
            const collider = colliderComponent.get();
            if (collider) {
                this._processor.track(collider);
            }
        });
        this.query.entityRemoved$.subscribe((e) => {
            const colliderComponent = e.get(_ColliderComponent__WEBPACK_IMPORTED_MODULE_5__.ColliderComponent);
            const collider = colliderComponent.get();
            if (colliderComponent && collider) {
                this._processor.untrack(collider);
            }
        });
        this._motionSystem = world.get(_MotionSystem__WEBPACK_IMPORTED_MODULE_6__.MotionSystem);
    }
    initialize(world, scene) {
        this._engine = scene.engine;
    }
    update(elapsed) {
        var _a, _b, _c, _d;
        if (!this._physics.config.enabled) {
            return;
        }
        // TODO do we need to do this every frame?
        // Collect up all the colliders and update them
        let colliders = [];
        for (let entityIndex = 0; entityIndex < this.query.entities.length; entityIndex++) {
            const entity = this.query.entities[entityIndex];
            const colliderComp = entity.get(_ColliderComponent__WEBPACK_IMPORTED_MODULE_5__.ColliderComponent);
            const collider = colliderComp === null || colliderComp === void 0 ? void 0 : colliderComp.get();
            if (colliderComp && ((_a = colliderComp.owner) === null || _a === void 0 ? void 0 : _a.isActive) && collider) {
                colliderComp.update();
                // Flatten composite colliders
                if (collider instanceof _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_7__.CompositeCollider) {
                    const compositeColliders = collider.getColliders();
                    if (!collider.compositeStrategy) {
                        collider.compositeStrategy = this._physics.config.colliders.compositeStrategy;
                    }
                    colliders = colliders.concat(compositeColliders);
                }
                else {
                    colliders.push(collider);
                }
            }
        }
        // Update the spatial partitioning data structures
        // TODO if collider invalid it will break the processor
        // TODO rename "update" to something more specific
        this._processor.update(colliders, elapsed);
        // Run broadphase on all colliders and locates potential collisions
        let pairs = this._processor.broadphase(colliders, elapsed);
        this._currentFrameContacts.clear();
        // Given possible pairs find actual contacts
        let contacts = [];
        const solver = this.getSolver();
        // Solve, this resolves the position/velocity so entities aren't overlapping
        const substep = this._physics.config.substep;
        for (let step = 0; step < substep; step++) {
            if (step > 0) {
                // first step is run by the MotionSystem when configured, so skip
                this._motionSystem.update(elapsed);
            }
            // Re-use pairs from previous collision
            if (contacts.length) {
                pairs = contacts.map((c) => new _Detection_Pair__WEBPACK_IMPORTED_MODULE_8__.Pair(c.colliderA, c.colliderB));
            }
            if (pairs.length) {
                contacts = this._processor.narrowphase(pairs, (_d = (_c = (_b = this._engine) === null || _b === void 0 ? void 0 : _b.debug) === null || _c === void 0 ? void 0 : _c.stats) === null || _d === void 0 ? void 0 : _d.currFrame);
                contacts = solver.solve(contacts);
                // Record contacts for start/end
                for (const contact of contacts) {
                    if (contact.isCanceled()) {
                        continue;
                    }
                    // Process composite ids, things with the same composite id are treated as the same collider for start/end
                    const index = contact.id.indexOf('|');
                    if (index > 0) {
                        const compositeId = contact.id.substring(index + 1);
                        this._currentFrameContacts.set(compositeId, contact);
                    }
                    else {
                        this._currentFrameContacts.set(contact.id, contact);
                    }
                }
            }
        }
        // Emit contact start/end events
        this.runContactStartEnd();
        // reset the last frame cache
        this._lastFrameContacts.clear();
        // Keep track of collisions contacts that have started or ended
        this._lastFrameContacts = new Map(this._currentFrameContacts);
        // Process deferred collider removals
        for (const entity of this.query.entities) {
            const collider = entity.get(_ColliderComponent__WEBPACK_IMPORTED_MODULE_5__.ColliderComponent);
            if (collider) {
                collider.processColliderRemoval();
            }
        }
    }
    postupdate() {
        _Colliders_SeparatingAxis__WEBPACK_IMPORTED_MODULE_9__.SeparatingAxis.SeparationPool.done();
    }
    getSolver() {
        if (this._configDirty) {
            this._configDirty = false;
            this._arcadeSolver = new _Solver_ArcadeSolver__WEBPACK_IMPORTED_MODULE_1__.ArcadeSolver(this._physics.config.arcade);
            this._realisticSolver = new _Solver_RealisticSolver__WEBPACK_IMPORTED_MODULE_2__.RealisticSolver(this._physics.config.realistic);
        }
        return this._physics.config.solver === _SolverStrategy__WEBPACK_IMPORTED_MODULE_10__.SolverStrategy.Realistic ? this._realisticSolver : this._arcadeSolver;
    }
    debug(ex) {
        this._processor.debug(ex, 0);
    }
    runContactStartEnd() {
        // If composite colliders are 'together' collisions may have a duplicate id because we want to treat those as a singular start/end
        for (const [id, c] of this._currentFrameContacts) {
            // find all new contacts
            if (!this._lastFrameContacts.has(id)) {
                const colliderA = c.colliderA;
                const colliderB = c.colliderB;
                const side = _Collision_Side__WEBPACK_IMPORTED_MODULE_11__.Side.fromDirection(c.mtv);
                const opposite = _Collision_Side__WEBPACK_IMPORTED_MODULE_11__.Side.getOpposite(side);
                colliderA.events.emit('collisionstart', new _Events__WEBPACK_IMPORTED_MODULE_12__.CollisionStartEvent(colliderA, colliderB, side, c));
                colliderA.events.emit('contactstart', new _Events__WEBPACK_IMPORTED_MODULE_12__.ContactStartEvent(colliderA, colliderB, side, c));
                colliderB.events.emit('collisionstart', new _Events__WEBPACK_IMPORTED_MODULE_12__.CollisionStartEvent(colliderB, colliderA, opposite, c));
                colliderB.events.emit('contactstart', new _Events__WEBPACK_IMPORTED_MODULE_12__.ContactStartEvent(colliderB, colliderA, opposite, c));
            }
        }
        // find all contacts that have ceased
        for (const [id, c] of this._lastFrameContacts) {
            if (!this._currentFrameContacts.has(id)) {
                const colliderA = c.colliderA;
                const colliderB = c.colliderB;
                const side = _Collision_Side__WEBPACK_IMPORTED_MODULE_11__.Side.fromDirection(c.mtv);
                const opposite = _Collision_Side__WEBPACK_IMPORTED_MODULE_11__.Side.getOpposite(side);
                colliderA.events.emit('collisionend', new _Events__WEBPACK_IMPORTED_MODULE_12__.CollisionEndEvent(colliderA, colliderB, side, c));
                colliderA.events.emit('contactend', new _Events__WEBPACK_IMPORTED_MODULE_12__.ContactEndEvent(colliderA, colliderB, side, c));
                colliderB.events.emit('collisionend', new _Events__WEBPACK_IMPORTED_MODULE_12__.CollisionEndEvent(colliderB, colliderA, opposite, c));
                colliderB.events.emit('contactend', new _Events__WEBPACK_IMPORTED_MODULE_12__.ContactEndEvent(colliderB, colliderA, opposite, c));
            }
        }
    }
}
CollisionSystem.priority = _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_13__.SystemPriority.Higher;


/***/ }),

/***/ "./Collision/CollisionType.ts":
/*!************************************!*\
  !*** ./Collision/CollisionType.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CollisionType: () => (/* binding */ CollisionType)
/* harmony export */ });
/**
 * An enum that describes the types of collisions bodies can participate in
 */
var CollisionType;
(function (CollisionType) {
    /**
     * Bodies with the `PreventCollision` setting do not participate in any
     * collisions and do not raise collision events.
     */
    CollisionType["PreventCollision"] = "PreventCollision";
    /**
     * Bodies with the `Passive` setting only raise collision events, but are not
     * influenced or moved by other bodies and do not influence or move other bodies.
     * This is useful for use in trigger type behavior.
     */
    CollisionType["Passive"] = "Passive";
    /**
     * Bodies with the `Active` setting raise collision events and participate
     * in collisions with other bodies and will be push or moved by bodies sharing
     * the `Active` or `Fixed` setting.
     */
    CollisionType["Active"] = "Active";
    /**
     * Bodies with the `Fixed` setting raise collision events and participate in
     * collisions with other bodies. Actors with the `Fixed` setting will not be
     * pushed or moved by other bodies sharing the `Fixed`. Think of Fixed
     * bodies as "immovable/unstoppable" objects. If two `Fixed` bodies meet they will
     * not be pushed or moved by each other, they will not interact except to throw
     * collision events.
     */
    CollisionType["Fixed"] = "Fixed";
})(CollisionType || (CollisionType = {}));


/***/ }),

/***/ "./Collision/Detection/CollisionContact.ts":
/*!*************************************************!*\
  !*** ./Collision/Detection/CollisionContact.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CollisionContact: () => (/* binding */ CollisionContact)
/* harmony export */ });
/* harmony import */ var _CollisionType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _Pair__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Pair */ "./Collision/Detection/Pair.ts");
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../BodyComponent */ "./Collision/BodyComponent.ts");



/**
 * Collision contacts are used internally by Excalibur to resolve collision between colliders. This
 * Pair prevents collisions from being evaluated more than one time
 */
class CollisionContact {
    constructor(colliderA, colliderB, mtv, normal, tangent, points, localPoints, info) {
        var _a, _b, _c, _d, _e, _f;
        this._canceled = false;
        this.bodyA = null;
        this.bodyB = null;
        this.colliderA = colliderA;
        this.colliderB = colliderB;
        this.mtv = mtv;
        this.normal = normal;
        this.tangent = tangent;
        this.points = points;
        this.localPoints = localPoints;
        this.info = info;
        this.id = _Pair__WEBPACK_IMPORTED_MODULE_0__.Pair.calculatePairHash(colliderA.id, colliderB.id);
        if (colliderA.composite || colliderB.composite) {
            // Add on the parent composite pair for start/end contact if 'together'
            const colliderAId = ((_a = colliderA.composite) === null || _a === void 0 ? void 0 : _a.compositeStrategy) === 'separate' ? colliderA.id : (_c = (_b = colliderA.composite) === null || _b === void 0 ? void 0 : _b.id) !== null && _c !== void 0 ? _c : colliderA.id;
            const colliderBId = ((_d = colliderB.composite) === null || _d === void 0 ? void 0 : _d.compositeStrategy) === 'separate' ? colliderB.id : (_f = (_e = colliderB.composite) === null || _e === void 0 ? void 0 : _e.id) !== null && _f !== void 0 ? _f : colliderB.id;
            this.id += '|' + _Pair__WEBPACK_IMPORTED_MODULE_0__.Pair.calculatePairHash(colliderAId, colliderBId);
        }
        if (this.colliderA.owner) {
            this.bodyA = this.colliderA.owner.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_1__.BodyComponent);
        }
        if (this.colliderB.owner) {
            this.bodyB = this.colliderB.owner.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_1__.BodyComponent);
        }
    }
    /**
     * Match contact awake state, except if body's are Fixed
     */
    matchAwake() {
        const bodyA = this.bodyA;
        const bodyB = this.bodyB;
        if (bodyA && bodyB) {
            if (bodyA.isSleeping !== bodyB.isSleeping) {
                if (bodyA.isSleeping && bodyA.collisionType !== _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType.Fixed && bodyB.sleepMotion >= bodyA.wakeThreshold) {
                    bodyA.isSleeping = false;
                }
                if (bodyB.isSleeping && bodyB.collisionType !== _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType.Fixed && bodyA.sleepMotion >= bodyB.wakeThreshold) {
                    bodyB.isSleeping = false;
                }
            }
        }
    }
    isCanceled() {
        return this._canceled;
    }
    cancel() {
        this._canceled = true;
    }
    /**
     * Biases the contact so that the given collider is colliderA
     */
    bias(collider) {
        if (collider !== this.colliderA && collider !== this.colliderB) {
            throw new Error('Collider must be either colliderA or colliderB from this contact');
        }
        if (collider === this.colliderA) {
            return this;
        }
        const colliderA = this.colliderA;
        const colliderB = this.colliderB;
        this.colliderB = colliderA;
        this.colliderA = colliderB;
        this.mtv = this.mtv.negate();
        this.normal = this.normal.negate();
        this.tangent = this.tangent.negate();
        return this;
    }
}


/***/ }),

/***/ "./Collision/Detection/DynamicTree.ts":
/*!********************************************!*\
  !*** ./Collision/Detection/DynamicTree.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DynamicTree: () => (/* binding */ DynamicTree),
/* harmony export */   TreeNode: () => (/* binding */ TreeNode)
/* harmony export */ });
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../.. */ "./Color.ts");




/**
 * Dynamic Tree Node used for tracking bounds within the tree
 */
class TreeNode {
    constructor(parent) {
        this.parent = parent;
        this.parent = parent || null;
        this.data = null;
        this.bounds = new _BoundingBox__WEBPACK_IMPORTED_MODULE_0__.BoundingBox();
        this.left = null;
        this.right = null;
        this.height = 0;
    }
    isLeaf() {
        return !this.left && !this.right;
    }
}
/**
 * The DynamicTrees provides a spatial partitioning data structure for quickly querying for overlapping bounding boxes for
 * all tracked bodies. The worst case performance of this is O(n*log(n)) where n is the number of bodies in the tree.
 *
 * Internally the bounding boxes are organized as a balanced binary tree of bounding boxes, where the leaf nodes are tracked bodies.
 * Every non-leaf node is a bounding box that contains child bounding boxes.
 */
class DynamicTree {
    constructor(_config, worldBounds = new _BoundingBox__WEBPACK_IMPORTED_MODULE_0__.BoundingBox(-Number.MAX_VALUE, -Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE)) {
        this._config = _config;
        this.worldBounds = worldBounds;
        this.root = null;
        this.nodes = {};
    }
    /**
     * Inserts a node into the dynamic tree
     */
    _insert(leaf) {
        // If there are no nodes in the tree, make this the root leaf
        if (this.root === null) {
            this.root = leaf;
            this.root.parent = null;
            return;
        }
        // Search the tree for a node that is not a leaf and find the best place to insert
        const leafAABB = leaf.bounds;
        let currentRoot = this.root;
        while (!currentRoot.isLeaf()) {
            const left = currentRoot.left;
            const right = currentRoot.right;
            const area = currentRoot.bounds.getPerimeter();
            const combinedAABB = currentRoot.bounds.combine(leafAABB);
            const combinedArea = combinedAABB.getPerimeter();
            // Calculate cost heuristic for creating a new parent and leaf
            const cost = 2 * combinedArea;
            // Minimum cost of pushing the leaf down the tree
            const inheritanceCost = 2 * (combinedArea - area);
            // Cost of descending
            let leftCost = 0;
            const leftCombined = leafAABB.combine(left.bounds);
            let newArea;
            let oldArea;
            if (left.isLeaf()) {
                leftCost = leftCombined.getPerimeter() + inheritanceCost;
            }
            else {
                oldArea = left.bounds.getPerimeter();
                newArea = leftCombined.getPerimeter();
                leftCost = newArea - oldArea + inheritanceCost;
            }
            let rightCost = 0;
            const rightCombined = leafAABB.combine(right.bounds);
            if (right.isLeaf()) {
                rightCost = rightCombined.getPerimeter() + inheritanceCost;
            }
            else {
                oldArea = right.bounds.getPerimeter();
                newArea = rightCombined.getPerimeter();
                rightCost = newArea - oldArea + inheritanceCost;
            }
            // cost is acceptable
            if (cost < leftCost && cost < rightCost) {
                break;
            }
            // Descend to the depths
            if (leftCost < rightCost) {
                currentRoot = left;
            }
            else {
                currentRoot = right;
            }
        }
        // Create the new parent node and insert into the tree
        const oldParent = currentRoot.parent;
        const newParent = new TreeNode(oldParent);
        newParent.bounds = leafAABB.combine(currentRoot.bounds);
        newParent.height = currentRoot.height + 1;
        if (oldParent !== null) {
            // The sibling node was not the root
            if (oldParent.left === currentRoot) {
                oldParent.left = newParent;
            }
            else {
                oldParent.right = newParent;
            }
            newParent.left = currentRoot;
            newParent.right = leaf;
            currentRoot.parent = newParent;
            leaf.parent = newParent;
        }
        else {
            // The sibling node was the root
            newParent.left = currentRoot;
            newParent.right = leaf;
            currentRoot.parent = newParent;
            leaf.parent = newParent;
            this.root = newParent;
        }
        // Walk up the tree fixing heights and AABBs
        let currentNode = leaf.parent;
        while (currentNode) {
            currentNode = this._balance(currentNode);
            if (!currentNode.left) {
                throw new Error('Parent of current leaf cannot have a null left child' + currentNode);
            }
            if (!currentNode.right) {
                throw new Error('Parent of current leaf cannot have a null right child' + currentNode);
            }
            currentNode.height = 1 + Math.max(currentNode.left.height, currentNode.right.height);
            currentNode.bounds = currentNode.left.bounds.combine(currentNode.right.bounds);
            currentNode = currentNode.parent;
        }
    }
    /**
     * Removes a node from the dynamic tree
     */
    _remove(leaf) {
        if (leaf === this.root) {
            this.root = null;
            return;
        }
        const parent = leaf.parent;
        const grandParent = parent.parent;
        let sibling;
        if (parent.left === leaf) {
            sibling = parent.right;
        }
        else {
            sibling = parent.left;
        }
        if (grandParent) {
            if (grandParent.left === parent) {
                grandParent.left = sibling;
            }
            else {
                grandParent.right = sibling;
            }
            sibling.parent = grandParent;
            let currentNode = grandParent;
            while (currentNode) {
                currentNode = this._balance(currentNode);
                currentNode.bounds = currentNode.left.bounds.combine(currentNode.right.bounds);
                currentNode.height = 1 + Math.max(currentNode.left.height, currentNode.right.height);
                currentNode = currentNode.parent;
            }
        }
        else {
            this.root = sibling;
            sibling.parent = null;
        }
    }
    /**
     * Tracks a body in the dynamic tree
     */
    trackCollider(collider) {
        const node = new TreeNode();
        node.data = collider;
        node.bounds = collider.bounds;
        node.bounds.left -= 2;
        node.bounds.top -= 2;
        node.bounds.right += 2;
        node.bounds.bottom += 2;
        this.nodes[collider.id.value] = node;
        this._insert(node);
    }
    /**
     * Updates the dynamic tree given the current bounds of each body being tracked
     */
    updateCollider(collider) {
        var _a;
        const node = this.nodes[collider.id.value];
        if (!node) {
            return false;
        }
        const b = collider.bounds;
        // if the body is outside the world no longer update it
        if (!this.worldBounds.contains(b)) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_1__.Logger.getInstance().warn('Collider with id ' + collider.id.value + ' is outside the world bounds and will no longer be tracked for physics');
            this.untrackCollider(collider);
            return false;
        }
        if (node.bounds.contains(b)) {
            return false;
        }
        this._remove(node);
        b.left -= this._config.boundsPadding;
        b.top -= this._config.boundsPadding;
        b.right += this._config.boundsPadding;
        b.bottom += this._config.boundsPadding;
        // THIS IS CAUSING UNNECESSARY CHECKS
        if (collider.owner) {
            const body = (_a = collider.owner) === null || _a === void 0 ? void 0 : _a.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_2__.BodyComponent);
            if (body) {
                const multdx = ((body.vel.x * 32) / 1000) * this._config.velocityMultiplier;
                const multdy = ((body.vel.y * 32) / 1000) * this._config.velocityMultiplier;
                if (multdx < 0) {
                    b.left += multdx;
                }
                else {
                    b.right += multdx;
                }
                if (multdy < 0) {
                    b.top += multdy;
                }
                else {
                    b.bottom += multdy;
                }
            }
        }
        node.bounds = b;
        this._insert(node);
        return true;
    }
    /**
     * Untracks a body from the dynamic tree
     */
    untrackCollider(collider) {
        const node = this.nodes[collider.id.value];
        if (!node) {
            return;
        }
        this._remove(node);
        this.nodes[collider.id.value] = null;
        delete this.nodes[collider.id.value];
    }
    /**
     * Balances the tree about a node
     */
    _balance(node) {
        if (node === null) {
            throw new Error('Cannot balance at null node');
        }
        if (node.isLeaf() || node.height < 2) {
            return node;
        }
        const left = node.left;
        const right = node.right;
        const a = node;
        const b = left;
        const c = right;
        const d = left.left;
        const e = left.right;
        const f = right.left;
        const g = right.right;
        const balance = c.height - b.height;
        // Rotate c node up
        if (balance > 1) {
            // Swap the right node with it's parent
            c.left = a;
            c.parent = a.parent;
            a.parent = c;
            // The original node's old parent should point to the right node
            // this is mega confusing
            if (c.parent) {
                if (c.parent.left === a) {
                    c.parent.left = c;
                }
                else {
                    c.parent.right = c;
                }
            }
            else {
                this.root = c;
            }
            // Rotate
            if (f.height > g.height) {
                c.right = f;
                a.right = g;
                g.parent = a;
                a.bounds = b.bounds.combine(g.bounds);
                c.bounds = a.bounds.combine(f.bounds);
                a.height = 1 + Math.max(b.height, g.height);
                c.height = 1 + Math.max(a.height, f.height);
            }
            else {
                c.right = g;
                a.right = f;
                f.parent = a;
                a.bounds = b.bounds.combine(f.bounds);
                c.bounds = a.bounds.combine(g.bounds);
                a.height = 1 + Math.max(b.height, f.height);
                c.height = 1 + Math.max(a.height, g.height);
            }
            return c;
        }
        // Rotate left node up
        if (balance < -1) {
            // swap
            b.left = a;
            b.parent = a.parent;
            a.parent = b;
            // node's old parent should point to b
            if (b.parent) {
                if (b.parent.left === a) {
                    b.parent.left = b;
                }
                else {
                    if (b.parent.right !== a) {
                        throw 'Error rotating Dynamic Tree';
                    }
                    b.parent.right = b;
                }
            }
            else {
                this.root = b;
            }
            // rotate
            if (d.height > e.height) {
                b.right = d;
                a.left = e;
                e.parent = a;
                a.bounds = c.bounds.combine(e.bounds);
                b.bounds = a.bounds.combine(d.bounds);
                a.height = 1 + Math.max(c.height, e.height);
                b.height = 1 + Math.max(a.height, d.height);
            }
            else {
                b.right = e;
                a.left = d;
                d.parent = a;
                a.bounds = c.bounds.combine(d.bounds);
                b.bounds = a.bounds.combine(e.bounds);
                a.height = 1 + Math.max(c.height, d.height);
                b.height = 1 + Math.max(a.height, e.height);
            }
            return b;
        }
        return node;
    }
    /**
     * Returns the internal height of the tree, shorter trees are better. Performance drops as the tree grows
     */
    getHeight() {
        if (this.root === null) {
            return 0;
        }
        return this.root.height;
    }
    /**
     * Queries the Dynamic Axis Aligned Tree for bodies that could be colliding with the provided body.
     *
     * In the query callback, it will be passed a potential collider. Returning true from this callback indicates
     * that you are complete with your query and you do not want to continue. Returning false will continue searching
     * the tree until all possible colliders have been returned.
     */
    query(collider, callback) {
        const bounds = collider.bounds;
        const helper = (currentNode) => {
            if (currentNode && currentNode.bounds.overlaps(bounds)) {
                if (currentNode.isLeaf() && currentNode.data !== collider) {
                    if (callback.call(collider, currentNode.data)) {
                        return true;
                    }
                }
                else {
                    return helper(currentNode.left) || helper(currentNode.right);
                }
            }
            return false;
        };
        helper(this.root);
    }
    /**
     * Queries the Dynamic Axis Aligned Tree for bodies that could be intersecting. By default the raycast query uses an infinitely
     * long ray to test the tree specified by `max`.
     *
     * In the query callback, it will be passed a potential body that intersects with the raycast. Returning true from this
     * callback indicates that your are complete with your query and do not want to continue. Return false will continue searching
     * the tree until all possible bodies that would intersect with the ray have been returned.
     */
    rayCastQuery(ray, max = Infinity, callback) {
        const helper = (currentNode) => {
            if (currentNode && currentNode.bounds.rayCast(ray, max)) {
                if (currentNode.isLeaf()) {
                    if (callback.call(ray, currentNode.data)) {
                        // ray hit a leaf! return the body
                        return true;
                    }
                }
                else {
                    // ray hit but not at a leaf, recurse deeper
                    return helper(currentNode.left) || helper(currentNode.right);
                }
            }
            return false; // ray missed
        };
        helper(this.root);
    }
    getNodes() {
        const helper = (currentNode) => {
            if (currentNode) {
                return [currentNode].concat(helper(currentNode.left), helper(currentNode.right));
            }
            else {
                return [];
            }
        };
        return helper(this.root);
    }
    debug(ex) {
        // draw all the nodes in the Dynamic Tree
        const helper = (currentNode) => {
            if (currentNode) {
                if (currentNode.isLeaf()) {
                    currentNode.bounds.draw(ex, ___WEBPACK_IMPORTED_MODULE_3__.Color.Green);
                }
                else {
                    currentNode.bounds.draw(ex, ___WEBPACK_IMPORTED_MODULE_3__.Color.White);
                }
                if (currentNode.left) {
                    helper(currentNode.left);
                }
                if (currentNode.right) {
                    helper(currentNode.right);
                }
            }
        };
        helper(this.root);
    }
}


/***/ }),

/***/ "./Collision/Detection/DynamicTreeCollisionProcessor.ts":
/*!**************************************************************!*\
  !*** ./Collision/Detection/DynamicTreeCollisionProcessor.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DynamicTreeCollisionProcessor: () => (/* binding */ DynamicTreeCollisionProcessor)
/* harmony export */ });
/* harmony import */ var _DynamicTree__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DynamicTree */ "./Collision/Detection/DynamicTree.ts");
/* harmony import */ var _Pair__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Pair */ "./Collision/Detection/Pair.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Math_ray__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../Math/ray */ "./Math/ray.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _CollisionType__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Colliders/CompositeCollider */ "./Collision/Colliders/CompositeCollider.ts");
/* harmony import */ var _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Group/CollisionGroup */ "./Collision/Group/CollisionGroup.ts");
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Id__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Id */ "./Id.ts");











/**
 * Responsible for performing the collision broadphase (locating potential collisions) and
 * the narrowphase (actual collision contacts)
 */
class DynamicTreeCollisionProcessor {
    constructor(_config) {
        this._config = _config;
        this._pairs = new Set();
        this._collisionPairCache = [];
        this._colliders = [];
        this._dynamicCollisionTree = new _DynamicTree__WEBPACK_IMPORTED_MODULE_0__.DynamicTree(_config.dynamicTree);
    }
    getColliders() {
        return this._colliders;
    }
    query(pointOrBounds) {
        const results = [];
        if (pointOrBounds instanceof _BoundingBox__WEBPACK_IMPORTED_MODULE_1__.BoundingBox) {
            this._dynamicCollisionTree.query({
                id: (0,_Id__WEBPACK_IMPORTED_MODULE_2__.createId)('collider', -1),
                owner: null,
                bounds: pointOrBounds
            }, (other) => {
                results.push(other);
                return false;
            });
        }
        else {
            this._dynamicCollisionTree.query({
                id: (0,_Id__WEBPACK_IMPORTED_MODULE_2__.createId)('collider', -1),
                owner: null,
                bounds: new _BoundingBox__WEBPACK_IMPORTED_MODULE_1__.BoundingBox(pointOrBounds.x, pointOrBounds.y, pointOrBounds.x, pointOrBounds.y)
            }, (other) => {
                results.push(other);
                return false;
            });
        }
        return results;
    }
    rayCast(ray, options) {
        var _a, _b, _c;
        const results = [];
        const maxDistance = (_a = options === null || options === void 0 ? void 0 : options.maxDistance) !== null && _a !== void 0 ? _a : Infinity;
        const collisionGroup = options === null || options === void 0 ? void 0 : options.collisionGroup;
        const collisionMask = !collisionGroup ? (_b = options === null || options === void 0 ? void 0 : options.collisionMask) !== null && _b !== void 0 ? _b : _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_3__.CollisionGroup.All.category : collisionGroup.category;
        const searchAllColliders = (_c = options === null || options === void 0 ? void 0 : options.searchAllColliders) !== null && _c !== void 0 ? _c : false;
        this._dynamicCollisionTree.rayCastQuery(ray, maxDistance, (collider) => {
            const owner = collider.owner;
            const maybeBody = owner.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_4__.BodyComponent);
            if ((options === null || options === void 0 ? void 0 : options.ignoreCollisionGroupAll) && maybeBody.group === _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_3__.CollisionGroup.All) {
                return false;
            }
            const canCollide = (collisionMask & maybeBody.group.category) !== 0;
            // Early exit if not the right group
            if ((maybeBody === null || maybeBody === void 0 ? void 0 : maybeBody.group) && !canCollide) {
                return false;
            }
            const hit = collider.rayCast(ray, maxDistance);
            if (hit) {
                if (options === null || options === void 0 ? void 0 : options.filter) {
                    if (options.filter(hit)) {
                        results.push(hit);
                        if (!searchAllColliders) {
                            // returning true exits the search
                            return true;
                        }
                    }
                }
                else {
                    results.push(hit);
                    if (!searchAllColliders) {
                        // returning true exits the search
                        return true;
                    }
                }
            }
            return false;
        });
        return results;
    }
    /**
     * Tracks a physics body for collisions
     */
    track(target) {
        if (!target) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_5__.Logger.getInstance().warn('Cannot track null collider');
            return;
        }
        if (target instanceof _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_6__.CompositeCollider) {
            const colliders = target.getColliders();
            for (const c of colliders) {
                c.owner = target.owner;
                this._colliders.push(c);
                this._dynamicCollisionTree.trackCollider(c);
            }
        }
        else {
            this._colliders.push(target);
            this._dynamicCollisionTree.trackCollider(target);
        }
    }
    /**
     * Untracks a physics body
     */
    untrack(target) {
        if (!target) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_5__.Logger.getInstance().warn('Cannot untrack a null collider');
            return;
        }
        if (target instanceof _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_6__.CompositeCollider) {
            const colliders = target.getColliders();
            for (const c of colliders) {
                const index = this._colliders.indexOf(c);
                if (index !== -1) {
                    this._colliders.splice(index, 1);
                }
                this._dynamicCollisionTree.untrackCollider(c);
            }
        }
        else {
            const index = this._colliders.indexOf(target);
            if (index !== -1) {
                this._colliders.splice(index, 1);
            }
            this._dynamicCollisionTree.untrackCollider(target);
        }
    }
    _pairExists(colliderA, colliderB) {
        // if the collision pair has been calculated already short circuit
        const hash = _Pair__WEBPACK_IMPORTED_MODULE_7__.Pair.calculatePairHash(colliderA.id, colliderB.id);
        return this._pairs.has(hash);
    }
    /**
     * Detects potential collision pairs in a broadphase approach with the dynamic AABB tree strategy
     */
    broadphase(targets, elapsed, stats) {
        const seconds = elapsed / 1000;
        // Retrieve the list of potential colliders, exclude killed, prevented, and self
        const potentialColliders = targets.filter((other) => {
            var _a, _b;
            const body = (_a = other.owner) === null || _a === void 0 ? void 0 : _a.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_4__.BodyComponent);
            return ((_b = other.owner) === null || _b === void 0 ? void 0 : _b.isActive) && body.collisionType !== _CollisionType__WEBPACK_IMPORTED_MODULE_8__.CollisionType.PreventCollision;
        });
        // clear old list of collision pairs
        this._collisionPairCache = [];
        this._pairs.clear();
        // check for normal collision pairs
        let collider;
        for (let j = 0, l = potentialColliders.length; j < l; j++) {
            collider = potentialColliders[j];
            // Query the collision tree for potential colliders
            this._dynamicCollisionTree.query(collider, (other) => {
                if (!this._pairExists(collider, other) && _Pair__WEBPACK_IMPORTED_MODULE_7__.Pair.canCollide(collider, other)) {
                    const pair = new _Pair__WEBPACK_IMPORTED_MODULE_7__.Pair(collider, other);
                    this._pairs.add(pair.id);
                    this._collisionPairCache.push(pair);
                }
                // Always return false, to query whole tree. Returning true in the query method stops searching
                return false;
            });
        }
        if (stats) {
            stats.physics.pairs = this._collisionPairCache.length;
        }
        // Check dynamic tree for fast moving objects
        // Fast moving objects are those moving at least there smallest bound per frame
        if (this._config.continuous.checkForFastBodies) {
            for (const collider of potentialColliders) {
                const body = collider.owner.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_4__.BodyComponent);
                // Skip non-active objects. Does not make sense on other collision types
                if (body.collisionType !== _CollisionType__WEBPACK_IMPORTED_MODULE_8__.CollisionType.Active) {
                    continue;
                }
                // Maximum travel distance next frame
                const updateDistance = body.vel.magnitude * seconds + // velocity term
                    body.acc.magnitude * 0.5 * seconds * seconds; // acc term
                // Find the minimum dimension
                const minDimension = Math.min(collider.bounds.height, collider.bounds.width);
                if (this._config.continuous.disableMinimumSpeedForFastBody || updateDistance > minDimension / 2) {
                    if (stats) {
                        stats.physics.fastBodies++;
                    }
                    // start with the oldPos because the integration for actors has already happened
                    // objects resting on a surface may be slightly penetrating in the current position
                    const updateVec = body.globalPos.sub(body.oldPos);
                    const centerPoint = collider.center;
                    const furthestPoint = collider.getFurthestPoint(body.vel);
                    const origin = furthestPoint.sub(updateVec);
                    const ray = new _Math_ray__WEBPACK_IMPORTED_MODULE_9__.Ray(origin, body.vel);
                    // back the ray up by -2x surfaceEpsilon to account for fast moving objects starting on the surface
                    ray.pos = ray.pos.add(ray.dir.scale(-2 * this._config.continuous.surfaceEpsilon));
                    let minCollider;
                    let minTranslate = new _Math_vector__WEBPACK_IMPORTED_MODULE_10__.Vector(Infinity, Infinity);
                    this._dynamicCollisionTree.rayCastQuery(ray, updateDistance + this._config.continuous.surfaceEpsilon * 2, (other) => {
                        if (!this._pairExists(collider, other) && _Pair__WEBPACK_IMPORTED_MODULE_7__.Pair.canCollide(collider, other)) {
                            const hit = other.rayCast(ray, updateDistance + this._config.continuous.surfaceEpsilon * 10);
                            if (hit) {
                                const translate = hit.point.sub(origin);
                                if (translate.magnitude < minTranslate.magnitude) {
                                    minTranslate = translate;
                                    minCollider = other;
                                }
                            }
                        }
                        return false;
                    });
                    if (minCollider && _Math_vector__WEBPACK_IMPORTED_MODULE_10__.Vector.isValid(minTranslate)) {
                        const pair = new _Pair__WEBPACK_IMPORTED_MODULE_7__.Pair(collider, minCollider);
                        if (!this._pairs.has(pair.id)) {
                            this._pairs.add(pair.id);
                            this._collisionPairCache.push(pair);
                        }
                        // move the fast moving object to the other body
                        // need to push into the surface by ex.Physics.surfaceEpsilon
                        const shift = centerPoint.sub(furthestPoint);
                        body.globalPos = origin
                            .add(shift)
                            .add(minTranslate)
                            .add(ray.dir.scale(10 * this._config.continuous.surfaceEpsilon)); // needed to push the shape slightly into contact
                        collider.update(body.transform.get());
                        if (stats) {
                            stats.physics.fastBodyCollisions++;
                        }
                    }
                }
            }
        }
        // return cache
        return this._collisionPairCache;
    }
    /**
     * Applies narrow phase on collision pairs to find actual area intersections
     * Adds actual colliding pairs to stats' Frame data
     */
    narrowphase(pairs, stats) {
        let contacts = [];
        for (let i = 0; i < pairs.length; i++) {
            const newContacts = pairs[i].collide();
            contacts = contacts.concat(newContacts);
            if (stats && newContacts.length > 0) {
                for (const c of newContacts) {
                    stats.physics.contacts.set(c.id, c);
                }
            }
        }
        if (stats) {
            stats.physics.collisions += contacts.length;
        }
        return contacts;
    }
    /**
     * Update the dynamic tree positions
     */
    update(targets) {
        let updated = 0;
        const len = targets.length;
        for (let i = 0; i < len; i++) {
            if (this._dynamicCollisionTree.updateCollider(targets[i])) {
                updated++;
            }
        }
        return updated;
    }
    debug(ex) {
        this._dynamicCollisionTree.debug(ex);
    }
}


/***/ }),

/***/ "./Collision/Detection/Pair.ts":
/*!*************************************!*\
  !*** ./Collision/Detection/Pair.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Pair: () => (/* binding */ Pair)
/* harmony export */ });
/* harmony import */ var _CollisionType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../BodyComponent */ "./Collision/BodyComponent.ts");


/**
 * Models a potential collision between 2 colliders
 */
class Pair {
    constructor(colliderA, colliderB) {
        this.colliderA = colliderA;
        this.colliderB = colliderB;
        this.id = null;
        this.id = Pair.calculatePairHash(colliderA.id, colliderB.id);
    }
    /**
     * Returns whether a it is allowed for 2 colliders in a Pair to collide
     * @param colliderA
     * @param colliderB
     */
    static canCollide(colliderA, colliderB) {
        var _a, _b;
        // Prevent self collision
        if (colliderA.id === colliderB.id) {
            return false;
        }
        // Colliders with the same owner do not collide (composite colliders)
        if (colliderA.owner && colliderB.owner && colliderA.owner.id === colliderB.owner.id) {
            return false;
        }
        // if the pair has a member with zero dimension don't collide
        if (colliderA.localBounds.hasZeroDimensions() || colliderB.localBounds.hasZeroDimensions()) {
            return false;
        }
        const bodyA = (_a = colliderA === null || colliderA === void 0 ? void 0 : colliderA.owner) === null || _a === void 0 ? void 0 : _a.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_0__.BodyComponent);
        const bodyB = (_b = colliderB === null || colliderB === void 0 ? void 0 : colliderB.owner) === null || _b === void 0 ? void 0 : _b.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_0__.BodyComponent);
        // Body's needed for collision in the current state
        // TODO can we collide without a body?
        if (!bodyA || !bodyB) {
            return false;
        }
        // If both are in the same collision group short circuit
        if (!bodyA.group.canCollide(bodyB.group)) {
            return false;
        }
        // if both are fixed short circuit
        if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_1__.CollisionType.Fixed && bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_1__.CollisionType.Fixed) {
            return false;
        }
        // if the either is prevent collision short circuit
        if (bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_1__.CollisionType.PreventCollision || bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_1__.CollisionType.PreventCollision) {
            return false;
        }
        // if either is dead short circuit
        if (!bodyA.isActive || !bodyB.isActive) {
            return false;
        }
        return true;
    }
    /**
     * Returns whether or not it is possible for the pairs to collide
     */
    get canCollide() {
        const colliderA = this.colliderA;
        const colliderB = this.colliderB;
        return Pair.canCollide(colliderA, colliderB);
    }
    /**
     * Runs the collision intersection logic on the members of this pair
     */
    collide() {
        return this.colliderA.collide(this.colliderB);
    }
    /**
     * Check if the collider is part of the pair
     * @param collider
     */
    hasCollider(collider) {
        return collider === this.colliderA || collider === this.colliderB;
    }
    /**
     * Calculates the unique pair hash id for this collision pair (owning id)
     */
    static calculatePairHash(idA, idB) {
        if (idA.value < idB.value) {
            return `#${idA.value}+${idB.value}`;
        }
        else {
            return `#${idB.value}+${idA.value}`;
        }
    }
}


/***/ }),

/***/ "./Collision/Detection/QuadTree.ts":
/*!*****************************************!*\
  !*** ./Collision/Detection/QuadTree.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   QuadTree: () => (/* binding */ QuadTree)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Color */ "./Color.ts");
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../BoundingBox */ "./Collision/BoundingBox.ts");


/**
 * QuadTree spatial data structure. Useful for quickly retrieving all objects that might
 * be in a specific location.
 */
class QuadTree {
    constructor(bounds, options) {
        this.bounds = bounds;
        this.options = options;
        this._defaultOptions = {
            maxDepth: 10,
            capacity: 10,
            level: 0
        };
        this.items = [];
        this._isDivided = false;
        this.topLeft = null;
        this.topRight = null;
        this.bottomLeft = null;
        this.bottomRight = null;
        this.options = { ...this._defaultOptions, ...options };
        this.halfWidth = bounds.width / 2;
        this.halfHeight = bounds.height / 2;
    }
    /**
     * Splits the quad tree one level deeper
     */
    _split() {
        this._isDivided = true;
        const newLevelOptions = {
            maxDepth: this.options.maxDepth,
            capacity: this.options.capacity,
            level: this.options.level + 1
        };
        this.topLeft = new QuadTree(new _BoundingBox__WEBPACK_IMPORTED_MODULE_0__.BoundingBox({
            left: this.bounds.left,
            top: this.bounds.top,
            right: this.bounds.left + this.halfWidth,
            bottom: this.bounds.top + this.halfHeight
        }), newLevelOptions);
        this.topRight = new QuadTree(new _BoundingBox__WEBPACK_IMPORTED_MODULE_0__.BoundingBox({
            left: this.bounds.left + this.halfWidth,
            top: this.bounds.top,
            right: this.bounds.right,
            bottom: this.bounds.top + this.halfHeight
        }), newLevelOptions);
        this.bottomLeft = new QuadTree(new _BoundingBox__WEBPACK_IMPORTED_MODULE_0__.BoundingBox({
            left: this.bounds.left,
            top: this.bounds.top + this.halfHeight,
            right: this.bounds.left + this.halfWidth,
            bottom: this.bounds.bottom
        }), newLevelOptions);
        this.bottomRight = new QuadTree(new _BoundingBox__WEBPACK_IMPORTED_MODULE_0__.BoundingBox({
            left: this.bounds.left + this.halfWidth,
            top: this.bounds.top + this.halfHeight,
            right: this.bounds.right,
            bottom: this.bounds.bottom
        }), newLevelOptions);
    }
    _insertIntoSubNodes(item) {
        var _a, _b, _c, _d;
        if ((_a = this.topLeft) === null || _a === void 0 ? void 0 : _a.bounds.overlaps(item.bounds)) {
            this.topLeft.insert(item);
        }
        if ((_b = this.topRight) === null || _b === void 0 ? void 0 : _b.bounds.overlaps(item.bounds)) {
            this.topRight.insert(item);
        }
        if ((_c = this.bottomLeft) === null || _c === void 0 ? void 0 : _c.bounds.overlaps(item.bounds)) {
            this.bottomLeft.insert(item);
        }
        if ((_d = this.bottomRight) === null || _d === void 0 ? void 0 : _d.bounds.overlaps(item.bounds)) {
            this.bottomRight.insert(item);
        }
    }
    /**
     * Insert an item to be tracked in the QuadTree
     * @param item
     */
    insert(item) {
        // add to subnodes if it matches
        if (this._isDivided) {
            this._insertIntoSubNodes(item);
            return;
        }
        // leaf case
        this.items.push(item);
        // capacity
        if (this.items.length > this.options.capacity && this.options.level < this.options.maxDepth) {
            if (!this._isDivided) {
                this._split();
            }
            // divide this level's items into it's subnodes
            for (const item of this.items) {
                this._insertIntoSubNodes(item);
            }
            // clear this level
            this.items.length = 0;
        }
    }
    /**
     * Remove a tracked item in the QuadTree
     * @param item
     */
    remove(item) {
        var _a, _b, _c, _d;
        if (!this.bounds.overlaps(item.bounds)) {
            return;
        }
        if (!this._isDivided) {
            const index = this.items.indexOf(item);
            if (index > -1) {
                this.items.splice(index, 1);
            }
            return;
        }
        if ((_a = this.topLeft) === null || _a === void 0 ? void 0 : _a.bounds.overlaps(item.bounds)) {
            this.topLeft.remove(item);
        }
        if ((_b = this.topRight) === null || _b === void 0 ? void 0 : _b.bounds.overlaps(item.bounds)) {
            this.topRight.remove(item);
        }
        if ((_c = this.bottomLeft) === null || _c === void 0 ? void 0 : _c.bounds.overlaps(item.bounds)) {
            this.bottomLeft.remove(item);
        }
        if ((_d = this.bottomRight) === null || _d === void 0 ? void 0 : _d.bounds.overlaps(item.bounds)) {
            this.bottomRight.remove(item);
        }
    }
    /**
     * Query the structure for all objects that intersect the bounding box
     * @param boundingBox
     * @returns items
     */
    query(boundingBox) {
        let results = this.items;
        if (this._isDivided) {
            if (this.topLeft.bounds.overlaps(boundingBox)) {
                results = results.concat(this.topLeft.query(boundingBox));
            }
            if (this.topRight.bounds.overlaps(boundingBox)) {
                results = results.concat(this.topRight.query(boundingBox));
            }
            if (this.bottomLeft.bounds.overlaps(boundingBox)) {
                results = results.concat(this.bottomLeft.query(boundingBox));
            }
            if (this.bottomRight.bounds.overlaps(boundingBox)) {
                results = results.concat(this.bottomRight.query(boundingBox));
            }
        }
        results = results.filter((item, index) => {
            return results.indexOf(item) >= index;
        });
        return results;
    }
    clear() {
        this.items = [];
        this._isDivided = false;
        this.topLeft = null;
        this.topRight = null;
        this.bottomLeft = null;
        this.bottomRight = null;
    }
    getAllItems() {
        let results = this.items;
        if (this._isDivided) {
            results = results.concat(this.topLeft.getAllItems());
            results = results.concat(this.topRight.getAllItems());
            results = results.concat(this.bottomLeft.getAllItems());
            results = results.concat(this.bottomRight.getAllItems());
        }
        results = results.filter((item, index) => {
            return results.indexOf(item) >= index;
        });
        return results;
    }
    getTreeDepth() {
        if (!this._isDivided) {
            return 0;
        }
        return (1 +
            Math.max(this.topLeft.getTreeDepth(), this.topRight.getTreeDepth(), this.bottomLeft.getTreeDepth(), this.bottomRight.getTreeDepth()));
    }
    debug(ctx) {
        this.bounds.draw(ctx, _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Yellow);
        if (this._isDivided) {
            this.topLeft.bounds.draw(ctx, _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Yellow);
            this.topRight.bounds.draw(ctx, _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Yellow);
            this.bottomLeft.bounds.draw(ctx, _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Yellow);
            this.bottomRight.bounds.draw(ctx, _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Yellow);
        }
    }
}


/***/ }),

/***/ "./Collision/Detection/SparseHashGrid.ts":
/*!***********************************************!*\
  !*** ./Collision/Detection/SparseHashGrid.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HashGridCell: () => (/* binding */ HashGridCell),
/* harmony export */   HashGridProxy: () => (/* binding */ HashGridProxy),
/* harmony export */   SparseHashGrid: () => (/* binding */ SparseHashGrid)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Color */ "./Color.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Util_RentalPool__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Util/RentalPool */ "./Util/RentalPool.ts");
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../BoundingBox */ "./Collision/BoundingBox.ts");




class HashGridProxy {
    constructor(object, gridSize) {
        this.object = object;
        this.id = -1;
        this.cells = [];
        this.hasZeroBounds = false;
        this.gridSize = gridSize;
        this.bounds = object.bounds;
        this.hasZeroBounds = this.bounds.hasZeroDimensions();
        this.leftX = Math.floor(this.bounds.left / this.gridSize);
        this.rightX = Math.floor(this.bounds.right / this.gridSize);
        this.bottomY = Math.floor(this.bounds.bottom / this.gridSize);
        this.topY = Math.floor(this.bounds.top / this.gridSize);
    }
    /**
     * Has the hashed bounds changed
     */
    hasChanged() {
        const bounds = this.object.bounds;
        const leftX = Math.floor(bounds.left / this.gridSize);
        const rightX = Math.floor(bounds.right / this.gridSize);
        const bottomY = Math.floor(bounds.bottom / this.gridSize);
        const topY = Math.floor(bounds.top / this.gridSize);
        if (this.leftX !== leftX || this.rightX !== rightX || this.bottomY !== bottomY || this.topY !== topY) {
            return true;
        }
        return false;
    }
    /**
     * Clears all collider references
     */
    clear() {
        for (const cell of this.cells) {
            const index = cell.proxies.indexOf(this);
            if (index > -1) {
                cell.proxies.splice(index, 1);
            }
            // TODO reclaim cell in pool if empty?
        }
    }
    /**
     * Update bounds of the proxy
     */
    updateBounds() {
        this.bounds = this.object.bounds;
    }
    /**
     * Updates the hashed bounds coordinates
     */
    update() {
        this.bounds = this.object.bounds;
        this.leftX = Math.floor(this.bounds.left / this.gridSize);
        this.rightX = Math.floor(this.bounds.right / this.gridSize);
        this.bottomY = Math.floor(this.bounds.bottom / this.gridSize);
        this.topY = Math.floor(this.bounds.top / this.gridSize);
        this.hasZeroBounds = this.object.bounds.hasZeroDimensions();
    }
}
class HashGridCell {
    constructor() {
        this.proxies = [];
    }
    configure(x, y) {
        this.x = x;
        this.y = y;
        this.key = HashGridCell.calculateHashKey(x, y);
    }
    static calculateHashKey(x, y) {
        return `${x}+${y}`;
    }
}
class SparseHashGrid {
    constructor(options) {
        this.bounds = new _BoundingBox__WEBPACK_IMPORTED_MODULE_0__.BoundingBox();
        this._hashGridCellPool = new _Util_RentalPool__WEBPACK_IMPORTED_MODULE_1__.RentalPool(() => new HashGridCell(), (instance) => {
            instance.configure(0, 0);
            instance.proxies.length = 0;
            return instance;
        }, 1000);
        this.gridSize = options.size;
        this.sparseHashGrid = new Map();
        this.objectToProxy = new Map();
        if (options.proxyFactory) {
            this._buildProxy = (object) => options.proxyFactory(object, this.gridSize);
        }
        else {
            this._buildProxy = (object) => new HashGridProxy(object, this.gridSize);
        }
        // TODO dynamic grid size potentially larger than the largest collider
        // TODO Re-hash the objects if the median proves to be different
    }
    query(boundsOrPoint) {
        const results = new Set();
        if (boundsOrPoint instanceof _BoundingBox__WEBPACK_IMPORTED_MODULE_0__.BoundingBox) {
            const bounds = boundsOrPoint;
            const leftX = Math.floor(bounds.left / this.gridSize);
            const rightX = Math.floor(bounds.right / this.gridSize);
            const bottomY = Math.floor(bounds.bottom / this.gridSize);
            const topY = Math.floor(bounds.top / this.gridSize);
            for (let x = leftX; x <= rightX; x++) {
                for (let y = topY; y <= bottomY; y++) {
                    const key = HashGridCell.calculateHashKey(x, y);
                    // Hash bounds into appropriate cell
                    const cell = this.sparseHashGrid.get(key);
                    if (cell) {
                        for (let i = 0; i < cell.proxies.length; i++) {
                            cell.proxies[i].updateBounds();
                            if (cell.proxies[i].bounds.intersect(bounds)) {
                                results.add(cell.proxies[i].object);
                            }
                        }
                    }
                }
            }
        }
        else {
            const point = boundsOrPoint;
            const key = HashGridCell.calculateHashKey(Math.floor(point.x / this.gridSize), Math.floor(point.y / this.gridSize));
            // Hash points into appropriate cell
            const cell = this.sparseHashGrid.get(key);
            if (cell) {
                for (let i = 0; i < cell.proxies.length; i++) {
                    cell.proxies[i].updateBounds();
                    if (cell.proxies[i].bounds.contains(point)) {
                        results.add(cell.proxies[i].object);
                    }
                }
            }
        }
        return Array.from(results);
    }
    get(xCoord, yCoord) {
        const key = HashGridCell.calculateHashKey(xCoord, yCoord);
        const cell = this.sparseHashGrid.get(key);
        return cell;
    }
    _insert(x, y, proxy) {
        const key = HashGridCell.calculateHashKey(x, y);
        // Hash collider into appropriate cell
        let cell = this.sparseHashGrid.get(key);
        if (!cell) {
            cell = this._hashGridCellPool.rent();
            cell.configure(x, y);
            this.sparseHashGrid.set(cell.key, cell);
        }
        cell.proxies.push(proxy);
        proxy.cells.push(cell); // TODO dupes, doesn't seem to be a problem
        this.bounds.combine(proxy.bounds, this.bounds);
    }
    _remove(x, y, proxy) {
        const key = HashGridCell.calculateHashKey(x, y);
        // Hash collider into appropriate cell
        const cell = this.sparseHashGrid.get(key);
        if (cell) {
            const proxyIndex = cell.proxies.indexOf(proxy);
            if (proxyIndex > -1) {
                cell.proxies.splice(proxyIndex, 1);
            }
            const cellIndex = proxy.cells.indexOf(cell);
            if (cellIndex > -1) {
                proxy.cells.splice(cellIndex, 1);
            }
            if (cell.proxies.length === 0) {
                this._hashGridCellPool.return(cell);
                this.sparseHashGrid.delete(key);
            }
        }
    }
    track(target) {
        const proxy = this._buildProxy(target);
        this.objectToProxy.set(target, proxy);
        for (let x = proxy.leftX; x <= proxy.rightX; x++) {
            for (let y = proxy.topY; y <= proxy.bottomY; y++) {
                this._insert(x, y, proxy);
            }
        }
    }
    untrack(target) {
        const proxy = this.objectToProxy.get(target);
        if (proxy) {
            proxy.clear();
            this.objectToProxy.delete(target);
        }
    }
    update(targets) {
        let updated = 0;
        // FIXME resetting bounds is wrong, if nothing has updated then
        // the bounds stay 0
        // this.bounds.reset();
        for (const target of targets) {
            const proxy = this.objectToProxy.get(target);
            if (!proxy) {
                continue;
            }
            if (proxy.hasChanged()) {
                // TODO slightly wasteful only remove from changed
                for (let x = proxy.leftX; x <= proxy.rightX; x++) {
                    for (let y = proxy.topY; y <= proxy.bottomY; y++) {
                        this._remove(x, y, proxy);
                    }
                }
                proxy.update();
                // TODO slightly wasteful only add new
                for (let x = proxy.leftX; x <= proxy.rightX; x++) {
                    for (let y = proxy.topY; y <= proxy.bottomY; y++) {
                        this._insert(x, y, proxy);
                    }
                }
                updated++;
            }
        }
        return updated;
    }
    debug(ex, elapsed) {
        const transparent = _Color__WEBPACK_IMPORTED_MODULE_2__.Color.Transparent;
        const color = _Color__WEBPACK_IMPORTED_MODULE_2__.Color.White;
        for (const cell of this.sparseHashGrid.values()) {
            ex.drawRectangle((0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(cell.x * this.gridSize, cell.y * this.gridSize), this.gridSize, this.gridSize, transparent, color, 2);
        }
    }
}


/***/ }),

/***/ "./Collision/Detection/SparseHashGridCollisionProcessor.ts":
/*!*****************************************************************!*\
  !*** ./Collision/Detection/SparseHashGridCollisionProcessor.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HashColliderProxy: () => (/* binding */ HashColliderProxy),
/* harmony export */   SparseHashGridCollisionProcessor: () => (/* binding */ SparseHashGridCollisionProcessor)
/* harmony export */ });
/* harmony import */ var _Id__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Id */ "./Id.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Util_Pool__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Util/Pool */ "./Util/Pool.ts");
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Colliders/CompositeCollider */ "./Collision/Colliders/CompositeCollider.ts");
/* harmony import */ var _CollisionType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Group/CollisionGroup */ "./Collision/Group/CollisionGroup.ts");
/* harmony import */ var _Pair__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Pair */ "./Collision/Detection/Pair.ts");
/* harmony import */ var _SparseHashGrid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SparseHashGrid */ "./Collision/Detection/SparseHashGrid.ts");









/**
 * Proxy type to stash collision info
 */
class HashColliderProxy extends _SparseHashGrid__WEBPACK_IMPORTED_MODULE_0__.HashGridProxy {
    constructor(collider, gridSize) {
        var _a, _b;
        super(collider, gridSize);
        this.collider = collider;
        this.id = -1;
        this.hasZeroBounds = false;
        /**
         * References to the hash cell the collider is a current member of
         */
        this.cells = [];
        this.gridSize = gridSize;
        const bounds = collider.bounds;
        this.hasZeroBounds = bounds.hasZeroDimensions();
        this.leftX = Math.floor(bounds.left / this.gridSize);
        this.rightX = Math.floor(bounds.right / this.gridSize);
        this.bottomY = Math.floor(bounds.bottom / this.gridSize);
        this.topY = Math.floor(bounds.top / this.gridSize);
        this.owner = collider.owner;
        this.body = (_a = this.owner) === null || _a === void 0 ? void 0 : _a.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_1__.BodyComponent);
        this.collisionType = (_b = this.body.collisionType) !== null && _b !== void 0 ? _b : _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType.PreventCollision;
    }
    /**
     * Updates the hashed bounds coordinates
     */
    update() {
        var _a, _b;
        super.update();
        this.body = (_a = this.owner) === null || _a === void 0 ? void 0 : _a.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_1__.BodyComponent);
        this.collisionType = (_b = this.body.collisionType) !== null && _b !== void 0 ? _b : _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType.PreventCollision;
        this.hasZeroBounds = this.collider.localBounds.hasZeroDimensions();
    }
}
/**
 * This collision processor uses a sparsely populated grid of uniform cells to bucket potential
 * colliders together for the purpose of detecting collision pairs and collisions.
 */
class SparseHashGridCollisionProcessor {
    constructor(options) {
        this._pairs = new Set();
        this._nonPairs = new Set();
        this._pairPool = new _Util_Pool__WEBPACK_IMPORTED_MODULE_3__.Pool(() => new _Pair__WEBPACK_IMPORTED_MODULE_4__.Pair({ id: (0,_Id__WEBPACK_IMPORTED_MODULE_5__.createId)('collider', 0) }, { id: (0,_Id__WEBPACK_IMPORTED_MODULE_5__.createId)('collider', 0) }), (instance) => {
            instance.colliderA = null;
            instance.colliderB = null;
            return instance;
        }, 200);
        this.gridSize = options.size;
        this.hashGrid = new _SparseHashGrid__WEBPACK_IMPORTED_MODULE_0__.SparseHashGrid({
            size: this.gridSize,
            proxyFactory: (collider, size) => new HashColliderProxy(collider, size)
        });
        this._pairPool.disableWarnings = true;
        // TODO dynamic grid size potentially larger than the largest collider
        // TODO Re-hash the objects if the median proves to be different
    }
    getColliders() {
        return Array.from(this.hashGrid.objectToProxy.keys());
    }
    query(boundsOrPoint) {
        // FIXME workaround TS: https://github.com/microsoft/TypeScript/issues/14107
        return this.hashGrid.query(boundsOrPoint);
    }
    rayCast(ray, options) {
        var _a, _b, _c;
        // DDA raycast algo
        const results = [];
        const maxDistance = (_a = options === null || options === void 0 ? void 0 : options.maxDistance) !== null && _a !== void 0 ? _a : Infinity;
        const collisionGroup = options === null || options === void 0 ? void 0 : options.collisionGroup;
        const collisionMask = !collisionGroup ? (_b = options === null || options === void 0 ? void 0 : options.collisionMask) !== null && _b !== void 0 ? _b : _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_6__.CollisionGroup.All.category : collisionGroup.category;
        const searchAllColliders = (_c = options === null || options === void 0 ? void 0 : options.searchAllColliders) !== null && _c !== void 0 ? _c : false;
        const unitRay = ray.dir.normalize();
        const dydx = unitRay.y / unitRay.x;
        const dxdy = unitRay.x / unitRay.y;
        const unitStepX = Math.sqrt(1 + dydx * dydx) * this.gridSize;
        const unitStepY = Math.sqrt(1 + dxdy * dxdy) * this.gridSize;
        const startXCoord = ray.pos.x / this.gridSize;
        const startYCoord = ray.pos.y / this.gridSize;
        const stepDir = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_7__.vec)(1, 1);
        let currentXCoord = ~~startXCoord;
        let currentYCoord = ~~startYCoord;
        let currentRayLengthX = 0;
        let currentRayLengthY = 0;
        if (unitRay.x < 0) {
            stepDir.x = -1;
            currentRayLengthX = (startXCoord - currentXCoord) * unitStepX;
        }
        else {
            stepDir.x = 1;
            currentRayLengthX = (currentXCoord + 1 - startXCoord) * unitStepX;
        }
        if (unitRay.y < 0) {
            stepDir.y = -1;
            currentRayLengthY = (startYCoord - currentYCoord) * unitStepY;
        }
        else {
            stepDir.y = 1;
            currentRayLengthY = (currentYCoord + 1 - startYCoord) * unitStepY;
        }
        const collidersVisited = new Set();
        let done = false;
        let maxIterations = 9999;
        while (!done && maxIterations > 0) {
            maxIterations--; // safety exit
            // exit if exhausted max hash grid coordinate, bounds of the sparse grid
            if (!this.hashGrid.bounds.contains((0,_Math_vector__WEBPACK_IMPORTED_MODULE_7__.vec)(currentXCoord * this.gridSize, currentYCoord * this.gridSize))) {
                break;
            }
            // Test colliders at cell
            const key = _SparseHashGrid__WEBPACK_IMPORTED_MODULE_0__.HashGridCell.calculateHashKey(currentXCoord, currentYCoord);
            const cell = this.hashGrid.sparseHashGrid.get(key);
            if (cell) {
                const cellHits = [];
                for (let colliderIndex = 0; colliderIndex < cell.proxies.length; colliderIndex++) {
                    const collider = cell.proxies[colliderIndex];
                    if (!collidersVisited.has(collider.collider.id.value)) {
                        collidersVisited.add(collider.collider.id.value);
                        if ((options === null || options === void 0 ? void 0 : options.ignoreCollisionGroupAll) && collider.body.group === _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_6__.CollisionGroup.All) {
                            continue;
                        }
                        const canCollide = (collisionMask & collider.body.group.category) !== 0;
                        // Early exit if not the right group
                        if (collider.body.group && !canCollide) {
                            continue;
                        }
                        const hit = collider.collider.rayCast(ray, maxDistance);
                        // Collect up all the colliders that hit inside a cell
                        // they can be in any order so we need to sort them next
                        if (hit) {
                            cellHits.push(hit);
                        }
                    }
                }
                cellHits.sort((hit1, hit2) => hit1.distance - hit2.distance);
                for (let i = 0; i < cellHits.length; i++) {
                    const hit = cellHits[i];
                    if (options === null || options === void 0 ? void 0 : options.filter) {
                        if (options.filter(hit)) {
                            results.push(hit);
                            if (!searchAllColliders) {
                                done = true;
                                break;
                            }
                        }
                    }
                    else {
                        results.push(hit);
                        if (!searchAllColliders) {
                            done = true;
                            break;
                        }
                    }
                }
            }
            if (currentRayLengthX < currentRayLengthY) {
                currentXCoord += stepDir.x;
                currentRayLengthX += unitStepX;
            }
            else {
                currentYCoord += stepDir.y;
                currentRayLengthY += unitStepY;
            }
        }
        // Sort by distance
        results.sort((hit1, hit2) => hit1.distance - hit2.distance);
        if (!searchAllColliders && results.length) {
            return [results[0]];
        }
        return results;
    }
    /**
     * Adds the collider to the internal data structure for collision tracking
     * @param target
     */
    track(target) {
        let colliders = [target];
        if (target instanceof _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_8__.CompositeCollider) {
            const compColliders = target.getColliders();
            for (const c of compColliders) {
                c.owner = target.owner;
            }
            colliders = compColliders;
        }
        for (const target of colliders) {
            this.hashGrid.track(target);
        }
    }
    /**
     * Removes a collider from the internal data structure for tracking collisions
     * @param target
     */
    untrack(target) {
        let colliders = [target];
        if (target instanceof _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_8__.CompositeCollider) {
            colliders = target.getColliders();
        }
        for (const target of colliders) {
            this.hashGrid.untrack(target);
        }
    }
    _canCollide(colliderA, colliderB) {
        // Prevent self collision
        if (colliderA.collider.id === colliderB.collider.id) {
            return false;
        }
        // Colliders with the same owner do not collide (composite colliders)
        if (colliderA.owner && colliderB.owner && colliderA.owner.id === colliderB.owner.id) {
            return false;
        }
        // if the pair has a member with zero dimension don't collide
        if (colliderA.hasZeroBounds || colliderB.hasZeroBounds) {
            return false;
        }
        // If both are in the same collision group short circuit
        if (!colliderA.body.group.canCollide(colliderB.body.group)) {
            return false;
        }
        // if both are fixed short circuit
        if (colliderA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType.Fixed && colliderB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType.Fixed) {
            return false;
        }
        // if the either is prevent collision short circuit
        if (colliderA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType.PreventCollision || colliderB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType.PreventCollision) {
            return false;
        }
        // if either is dead short circuit
        if (!colliderA.owner.isActive || !colliderB.owner.isActive) {
            return false;
        }
        return true;
    }
    /**
     * Runs the broadphase sweep over tracked colliders and returns possible collision pairs
     * @param targets
     * @param elapsed
     */
    broadphase(targets, elapsed) {
        const pairs = [];
        this._pairs.clear();
        this._nonPairs.clear();
        let proxyId = 0;
        for (const proxy of this.hashGrid.objectToProxy.values()) {
            proxy.id = proxyId++; // track proxies we've already processed
            if (!proxy.owner.isActive || proxy.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType.PreventCollision) {
                continue;
            }
            // for every cell proxy collider is member of
            for (let cellIndex = 0; cellIndex < proxy.cells.length; cellIndex++) {
                const cell = proxy.cells[cellIndex];
                // TODO Can we skip any cells or make this iteration faster?
                // maybe a linked list here
                for (let otherIndex = 0; otherIndex < cell.proxies.length; otherIndex++) {
                    const other = cell.proxies[otherIndex];
                    if (other.id === proxy.id) {
                        // skip duplicates
                        continue;
                    }
                    const id = _Pair__WEBPACK_IMPORTED_MODULE_4__.Pair.calculatePairHash(proxy.collider.id, other.collider.id);
                    if (this._nonPairs.has(id)) {
                        continue; // Is there a way we can re-use the non-pair cache
                    }
                    if (!this._pairs.has(id) && this._canCollide(proxy, other) && proxy.object.bounds.overlaps(other.object.bounds)) {
                        const pair = this._pairPool.get();
                        pair.colliderA = proxy.collider;
                        pair.colliderB = other.collider;
                        pair.id = id;
                        this._pairs.add(id);
                        pairs.push(pair);
                    }
                    else {
                        this._nonPairs.add(id);
                    }
                }
            }
        }
        return pairs;
    }
    /**
     * Runs a fine grain pass on collision pairs and does geometry intersection tests producing any contacts
     * @param pairs
     * @param stats
     */
    narrowphase(pairs, stats) {
        const contacts = [];
        for (let i = 0; i < pairs.length; i++) {
            const newContacts = pairs[i].collide();
            for (let j = 0; j < newContacts.length; j++) {
                const c = newContacts[j];
                contacts.push(c);
                if (stats) {
                    stats.physics.contacts.set(c.id, c);
                }
            }
        }
        this._pairPool.done();
        if (stats) {
            stats.physics.collisions += contacts.length;
        }
        return contacts; // TODO maybe we can re-use contacts as likely pairs next frame
    }
    /**
     * Perform data structure maintenance, returns number of colliders updated
     */
    update(targets, elapsed) {
        return this.hashGrid.update(targets);
    }
    /**
     * Draws the internal data structure
     * @param ex
     * @param elapsed
     */
    debug(ex, elapsed) {
        this.hashGrid.debug(ex, elapsed);
    }
}


/***/ }),

/***/ "./Collision/Detection/SpatialPartitionStrategy.ts":
/*!*********************************************************!*\
  !*** ./Collision/Detection/SpatialPartitionStrategy.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SpatialPartitionStrategy: () => (/* binding */ SpatialPartitionStrategy)
/* harmony export */ });
/**
 * Possible collision resolution strategies
 *
 * The default is {@apilink SolverStrategy.Arcade} which performs simple axis aligned arcade style physics. This is useful for things
 * like platformers or top down games.
 *
 * More advanced rigid body physics are enabled by setting {@apilink SolverStrategy.Realistic} which allows for complicated
 * simulated physical interactions.
 */
var SpatialPartitionStrategy;
(function (SpatialPartitionStrategy) {
    SpatialPartitionStrategy["DynamicTree"] = "dynamic-tree";
    SpatialPartitionStrategy["SparseHashGrid"] = "sparse-hash-grid";
})(SpatialPartitionStrategy || (SpatialPartitionStrategy = {}));


/***/ }),

/***/ "./Collision/Group/CollisionGroup.ts":
/*!*******************************************!*\
  !*** ./Collision/Group/CollisionGroup.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CollisionGroup: () => (/* binding */ CollisionGroup)
/* harmony export */ });
/* harmony import */ var _CollisionGroupManager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CollisionGroupManager */ "./Collision/Group/CollisionGroupManager.ts");

/**
 * CollisionGroups indicate like members that do not collide with each other. Use {@apilink CollisionGroupManager} to create {@apilink CollisionGroup}s
 *
 * For example:
 *
 * Players have collision group "player"
 *
 * ![Player Collision Group](/assets/images/docs/CollisionGroupsPlayer.png)
 *
 * Enemies have collision group "enemy"
 *
 * ![Enemy Collision Group](/assets/images/docs/CollisionGroupsEnemy.png)
 *
 * Blocks have collision group "ground"
 *
 * ![Ground collision group](/assets/images/docs/CollisionGroupsGround.png)
 *
 * Players don't collide with each other, but enemies and blocks. Likewise, enemies don't collide with each other but collide
 * with players and blocks.
 *
 * This is done with bitmasking, see the following pseudo-code
 *
 * PlayerGroup = `0b001`
 * PlayerGroupMask = `0b110`
 *
 * EnemyGroup = `0b010`
 * EnemyGroupMask = `0b101`
 *
 * BlockGroup = `0b100`
 * BlockGroupMask = `0b011`
 *
 * Should Players collide? No because the bitwise mask evaluates to 0
 * `(player1.group & player2.mask) === 0`
 * `(0b001 & 0b110) === 0`
 *
 * Should Players and Enemies collide? Yes because the bitwise mask is non-zero
 * `(player1.group & enemy1.mask) === 1`
 * `(0b001 & 0b101) === 1`
 *
 * Should Players and Blocks collide? Yes because the bitwise mask is non-zero
 * `(player1.group & blocks1.mask) === 1`
 * `(0b001 & 0b011) === 1`
 */
class CollisionGroup {
    /**
     * STOP!!** It is preferred that {@apilink CollisionGroupManager.create} is used to create collision groups
     *  unless you know how to construct the proper bitmasks. See https://github.com/excaliburjs/Excalibur/issues/1091 for more info.
     * @param name Name of the collision group
     * @param category 32 bit category for the group, should be a unique power of 2. For example `0b001` or `0b010`
     * @param mask 32 bit mask of category, or `~category` generally. For a category of `0b001`, the mask would be `0b110`
     */
    constructor(name, category, mask) {
        this._name = name;
        this._category = category;
        this._mask = mask;
    }
    /**
     * Get the name of the collision group
     */
    get name() {
        return this._name;
    }
    /**
     * Get the category of the collision group, a 32 bit number which should be a unique power of 2
     */
    get category() {
        return this._category;
    }
    /**
     * Get the mask for this collision group
     */
    get mask() {
        return this._mask;
    }
    /**
     * Evaluates whether 2 collision groups can collide
     *
     * This means the mask has the same bit set the other category and vice versa
     * @param other  CollisionGroup
     */
    canCollide(other) {
        const overlap1 = this.category & other.mask;
        const overlap2 = this.mask & other.category;
        return overlap1 !== 0 && overlap2 !== 0;
    }
    /**
     * Inverts the collision group. For example, if before the group specified "players",
     * inverting would specify all groups except players
     * @returns CollisionGroup
     */
    invert() {
        const group = _CollisionGroupManager__WEBPACK_IMPORTED_MODULE_0__.CollisionGroupManager.create('~(' + this.name + ')', ~this.mask | 0);
        group._category = ~this.category;
        return group;
    }
    /**
     * Combine collision groups with each other. The new group includes all of the previous groups.
     * @param collisionGroups
     */
    static combine(collisionGroups) {
        const combinedName = collisionGroups.map((c) => c.name).join('+');
        const combinedCategory = collisionGroups.reduce((current, g) => g.category | current, 0b0);
        const combinedMask = ~combinedCategory;
        return _CollisionGroupManager__WEBPACK_IMPORTED_MODULE_0__.CollisionGroupManager.create(combinedName, combinedMask);
    }
    /**
     * Creates a collision group that collides with the listed groups
     * @param collisionGroups
     */
    static collidesWith(collisionGroups) {
        const combinedName = `collidesWith(${collisionGroups.map((c) => c.name).join('+')})`;
        const combinedMask = collisionGroups.reduce((current, g) => g.category | current, 0b0);
        return _CollisionGroupManager__WEBPACK_IMPORTED_MODULE_0__.CollisionGroupManager.create(combinedName, combinedMask);
    }
    toString() {
        return `
category: ${this.category.toString(2).padStart(32, '0')}
mask:     ${(this.mask >>> 0).toString(2).padStart(32, '0')}
    `;
    }
}
/**
 * The `All` {@apilink CollisionGroup} is a special group that collides with all other groups including itself,
 * it is the default collision group on colliders.
 */
CollisionGroup.All = new CollisionGroup('Collide with all groups', -1, -1);


/***/ }),

/***/ "./Collision/Group/CollisionGroupManager.ts":
/*!**************************************************!*\
  !*** ./Collision/Group/CollisionGroupManager.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CollisionGroupManager: () => (/* binding */ CollisionGroupManager)
/* harmony export */ });
/* harmony import */ var _CollisionGroup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CollisionGroup */ "./Collision/Group/CollisionGroup.ts");

/**
 * Static class for managing collision groups in excalibur, there is a maximum of 32 collision groups possible in excalibur
 */
class CollisionGroupManager {
    /**
     * Create a new named collision group up to a max of 32.
     * @param name Name for the collision group
     * @param mask Optionally provide your own 32-bit mask, if none is provide the manager will generate one
     */
    static create(name, mask) {
        if (this._CURRENT_GROUP > this._MAX_GROUPS) {
            throw new Error(`Cannot have more than ${this._MAX_GROUPS} collision groups`);
        }
        if (this._GROUPS.get(name)) {
            const existingGroup = this._GROUPS.get(name);
            if (existingGroup.mask === mask) {
                return existingGroup;
            }
            throw new Error(`Collision group ${name} already exists with a different mask!`);
        }
        const group = new _CollisionGroup__WEBPACK_IMPORTED_MODULE_0__.CollisionGroup(name, this._CURRENT_BIT, mask !== undefined ? mask : ~this._CURRENT_BIT);
        this._CURRENT_BIT = (this._CURRENT_BIT << 1) | 0;
        this._CURRENT_GROUP++;
        this._GROUPS.set(name, group);
        return group;
    }
    /**
     * Get all collision groups currently tracked by excalibur
     */
    static get groups() {
        return Array.from(this._GROUPS.values());
    }
    /**
     * Get a collision group by it's name
     * @param name
     */
    static groupByName(name) {
        return this._GROUPS.get(name);
    }
    /**
     * Resets the managers internal group management state
     */
    static reset() {
        this._GROUPS = new Map();
        this._CURRENT_BIT = this._STARTING_BIT;
        this._CURRENT_GROUP = 1;
    }
}
// using bitmasking the maximum number of groups is 32, because that is the highest 32bit integer that JS can present.
CollisionGroupManager._STARTING_BIT = 0b1 | 0;
CollisionGroupManager._MAX_GROUPS = 32;
CollisionGroupManager._CURRENT_GROUP = 1;
CollisionGroupManager._CURRENT_BIT = CollisionGroupManager._STARTING_BIT;
CollisionGroupManager._GROUPS = new Map();


/***/ }),

/***/ "./Collision/Index.ts":
/*!****************************!*\
  !*** ./Collision/Index.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArcadeSolver: () => (/* reexport safe */ _Solver_ArcadeSolver__WEBPACK_IMPORTED_MODULE_24__.ArcadeSolver),
/* harmony export */   BodyComponent: () => (/* reexport safe */ _BodyComponent__WEBPACK_IMPORTED_MODULE_0__.BodyComponent),
/* harmony export */   BoundingBox: () => (/* reexport safe */ _BoundingBox__WEBPACK_IMPORTED_MODULE_5__.BoundingBox),
/* harmony export */   CircleCollider: () => (/* reexport safe */ _Colliders_CircleCollider__WEBPACK_IMPORTED_MODULE_8__.CircleCollider),
/* harmony export */   ClosestLineJumpTable: () => (/* reexport safe */ _Colliders_ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_12__.ClosestLineJumpTable),
/* harmony export */   Collider: () => (/* reexport safe */ _Colliders_Collider__WEBPACK_IMPORTED_MODULE_4__.Collider),
/* harmony export */   ColliderComponent: () => (/* reexport safe */ _ColliderComponent__WEBPACK_IMPORTED_MODULE_1__.ColliderComponent),
/* harmony export */   CollisionContact: () => (/* reexport safe */ _Detection_CollisionContact__WEBPACK_IMPORTED_MODULE_17__.CollisionContact),
/* harmony export */   CollisionGroup: () => (/* reexport safe */ _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_14__.CollisionGroup),
/* harmony export */   CollisionGroupManager: () => (/* reexport safe */ _Group_CollisionGroupManager__WEBPACK_IMPORTED_MODULE_15__.CollisionGroupManager),
/* harmony export */   CollisionJumpTable: () => (/* reexport safe */ _Colliders_CollisionJumpTable__WEBPACK_IMPORTED_MODULE_11__.CollisionJumpTable),
/* harmony export */   CollisionSystem: () => (/* reexport safe */ _CollisionSystem__WEBPACK_IMPORTED_MODULE_28__.CollisionSystem),
/* harmony export */   CollisionType: () => (/* reexport safe */ _CollisionType__WEBPACK_IMPORTED_MODULE_2__.CollisionType),
/* harmony export */   CompositeCollider: () => (/* reexport safe */ _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_7__.CompositeCollider),
/* harmony export */   ContactConstraintPoint: () => (/* reexport safe */ _Solver_ContactConstraintPoint__WEBPACK_IMPORTED_MODULE_26__.ContactConstraintPoint),
/* harmony export */   ContactSolveBias: () => (/* reexport safe */ _Solver_ContactBias__WEBPACK_IMPORTED_MODULE_25__.ContactSolveBias),
/* harmony export */   DegreeOfFreedom: () => (/* reexport safe */ _BodyComponent__WEBPACK_IMPORTED_MODULE_0__.DegreeOfFreedom),
/* harmony export */   DynamicTree: () => (/* reexport safe */ _Detection_DynamicTree__WEBPACK_IMPORTED_MODULE_18__.DynamicTree),
/* harmony export */   DynamicTreeCollisionProcessor: () => (/* reexport safe */ _Detection_DynamicTreeCollisionProcessor__WEBPACK_IMPORTED_MODULE_19__.DynamicTreeCollisionProcessor),
/* harmony export */   EdgeCollider: () => (/* reexport safe */ _Colliders_EdgeCollider__WEBPACK_IMPORTED_MODULE_9__.EdgeCollider),
/* harmony export */   HashColliderProxy: () => (/* reexport safe */ _Detection_SparseHashGridCollisionProcessor__WEBPACK_IMPORTED_MODULE_20__.HashColliderProxy),
/* harmony export */   HashGridCell: () => (/* reexport safe */ _Detection_SparseHashGrid__WEBPACK_IMPORTED_MODULE_21__.HashGridCell),
/* harmony export */   HashGridProxy: () => (/* reexport safe */ _Detection_SparseHashGrid__WEBPACK_IMPORTED_MODULE_21__.HashGridProxy),
/* harmony export */   HorizontalFirst: () => (/* reexport safe */ _Solver_ContactBias__WEBPACK_IMPORTED_MODULE_25__.HorizontalFirst),
/* harmony export */   MotionSystem: () => (/* reexport safe */ _MotionSystem__WEBPACK_IMPORTED_MODULE_29__.MotionSystem),
/* harmony export */   None: () => (/* reexport safe */ _Solver_ContactBias__WEBPACK_IMPORTED_MODULE_25__.None),
/* harmony export */   Pair: () => (/* reexport safe */ _Detection_Pair__WEBPACK_IMPORTED_MODULE_16__.Pair),
/* harmony export */   PhysicsWorld: () => (/* reexport safe */ _PhysicsWorld__WEBPACK_IMPORTED_MODULE_30__.PhysicsWorld),
/* harmony export */   PolygonCollider: () => (/* reexport safe */ _Colliders_PolygonCollider__WEBPACK_IMPORTED_MODULE_10__.PolygonCollider),
/* harmony export */   QuadTree: () => (/* reexport safe */ _Detection_QuadTree__WEBPACK_IMPORTED_MODULE_23__.QuadTree),
/* harmony export */   RealisticSolver: () => (/* reexport safe */ _Solver_RealisticSolver__WEBPACK_IMPORTED_MODULE_27__.RealisticSolver),
/* harmony export */   SeparatingAxis: () => (/* reexport safe */ _Colliders_SeparatingAxis__WEBPACK_IMPORTED_MODULE_13__.SeparatingAxis),
/* harmony export */   SeparationInfo: () => (/* reexport safe */ _Colliders_SeparatingAxis__WEBPACK_IMPORTED_MODULE_13__.SeparationInfo),
/* harmony export */   Shape: () => (/* reexport safe */ _Colliders_Shape__WEBPACK_IMPORTED_MODULE_6__.Shape),
/* harmony export */   Side: () => (/* reexport safe */ _Side__WEBPACK_IMPORTED_MODULE_32__.Side),
/* harmony export */   SolverStrategy: () => (/* reexport safe */ _SolverStrategy__WEBPACK_IMPORTED_MODULE_3__.SolverStrategy),
/* harmony export */   SparseHashGrid: () => (/* reexport safe */ _Detection_SparseHashGrid__WEBPACK_IMPORTED_MODULE_21__.SparseHashGrid),
/* harmony export */   SparseHashGridCollisionProcessor: () => (/* reexport safe */ _Detection_SparseHashGridCollisionProcessor__WEBPACK_IMPORTED_MODULE_20__.SparseHashGridCollisionProcessor),
/* harmony export */   SpatialPartitionStrategy: () => (/* reexport safe */ _Detection_SpatialPartitionStrategy__WEBPACK_IMPORTED_MODULE_22__.SpatialPartitionStrategy),
/* harmony export */   TreeNode: () => (/* reexport safe */ _Detection_DynamicTree__WEBPACK_IMPORTED_MODULE_18__.TreeNode),
/* harmony export */   VerticalFirst: () => (/* reexport safe */ _Solver_ContactBias__WEBPACK_IMPORTED_MODULE_25__.VerticalFirst),
/* harmony export */   getDefaultPhysicsConfig: () => (/* reexport safe */ _PhysicsConfig__WEBPACK_IMPORTED_MODULE_31__.getDefaultPhysicsConfig)
/* harmony export */ });
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var _ColliderComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ColliderComponent */ "./Collision/ColliderComponent.ts");
/* harmony import */ var _CollisionType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _SolverStrategy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SolverStrategy */ "./Collision/SolverStrategy.ts");
/* harmony import */ var _Colliders_Collider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Colliders/Collider */ "./Collision/Colliders/Collider.ts");
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Colliders_Shape__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Colliders/Shape */ "./Collision/Colliders/Shape.ts");
/* harmony import */ var _Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Colliders/CompositeCollider */ "./Collision/Colliders/CompositeCollider.ts");
/* harmony import */ var _Colliders_CircleCollider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Colliders/CircleCollider */ "./Collision/Colliders/CircleCollider.ts");
/* harmony import */ var _Colliders_EdgeCollider__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Colliders/EdgeCollider */ "./Collision/Colliders/EdgeCollider.ts");
/* harmony import */ var _Colliders_PolygonCollider__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Colliders/PolygonCollider */ "./Collision/Colliders/PolygonCollider.ts");
/* harmony import */ var _Colliders_CollisionJumpTable__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Colliders/CollisionJumpTable */ "./Collision/Colliders/CollisionJumpTable.ts");
/* harmony import */ var _Colliders_ClosestLineJumpTable__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Colliders/ClosestLineJumpTable */ "./Collision/Colliders/ClosestLineJumpTable.ts");
/* harmony import */ var _Colliders_SeparatingAxis__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Colliders/SeparatingAxis */ "./Collision/Colliders/SeparatingAxis.ts");
/* harmony import */ var _Group_CollisionGroup__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Group/CollisionGroup */ "./Collision/Group/CollisionGroup.ts");
/* harmony import */ var _Group_CollisionGroupManager__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Group/CollisionGroupManager */ "./Collision/Group/CollisionGroupManager.ts");
/* harmony import */ var _Detection_Pair__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Detection/Pair */ "./Collision/Detection/Pair.ts");
/* harmony import */ var _Detection_CollisionContact__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Detection/CollisionContact */ "./Collision/Detection/CollisionContact.ts");
/* harmony import */ var _Detection_DynamicTree__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Detection/DynamicTree */ "./Collision/Detection/DynamicTree.ts");
/* harmony import */ var _Detection_DynamicTreeCollisionProcessor__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Detection/DynamicTreeCollisionProcessor */ "./Collision/Detection/DynamicTreeCollisionProcessor.ts");
/* harmony import */ var _Detection_SparseHashGridCollisionProcessor__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Detection/SparseHashGridCollisionProcessor */ "./Collision/Detection/SparseHashGridCollisionProcessor.ts");
/* harmony import */ var _Detection_SparseHashGrid__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Detection/SparseHashGrid */ "./Collision/Detection/SparseHashGrid.ts");
/* harmony import */ var _Detection_SpatialPartitionStrategy__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Detection/SpatialPartitionStrategy */ "./Collision/Detection/SpatialPartitionStrategy.ts");
/* harmony import */ var _Detection_QuadTree__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./Detection/QuadTree */ "./Collision/Detection/QuadTree.ts");
/* harmony import */ var _Solver_ArcadeSolver__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./Solver/ArcadeSolver */ "./Collision/Solver/ArcadeSolver.ts");
/* harmony import */ var _Solver_ContactBias__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./Solver/ContactBias */ "./Collision/Solver/ContactBias.ts");
/* harmony import */ var _Solver_ContactConstraintPoint__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./Solver/ContactConstraintPoint */ "./Collision/Solver/ContactConstraintPoint.ts");
/* harmony import */ var _Solver_RealisticSolver__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./Solver/RealisticSolver */ "./Collision/Solver/RealisticSolver.ts");
/* harmony import */ var _CollisionSystem__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./CollisionSystem */ "./Collision/CollisionSystem.ts");
/* harmony import */ var _MotionSystem__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./MotionSystem */ "./Collision/MotionSystem.ts");
/* harmony import */ var _PhysicsWorld__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./PhysicsWorld */ "./Collision/PhysicsWorld.ts");
/* harmony import */ var _PhysicsConfig__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./PhysicsConfig */ "./Collision/PhysicsConfig.ts");
/* harmony import */ var _Side__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./Side */ "./Collision/Side.ts");








































/***/ }),

/***/ "./Collision/Integrator.ts":
/*!*********************************!*\
  !*** ./Collision/Integrator.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EulerIntegrator: () => (/* binding */ EulerIntegrator)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Math/vector */ "./Math/vector.ts");

class EulerIntegrator {
    static integrate(transform, motion, totalAcc, elapsed) {
        const seconds = elapsed / 1000;
        // This code looks a little wild, but it's to avoid creating any new Vector instances
        // integration is done in a tight loop so this is key to avoid GC'ing
        motion.vel.addEqual(totalAcc.scale(seconds, EulerIntegrator._ACC));
        transform.pos
            .add(motion.vel.scale(seconds, EulerIntegrator._VEL), EulerIntegrator._POS)
            .addEqual(totalAcc.scale(0.5 * seconds * seconds, EulerIntegrator._VEL_ACC));
        motion.angularVelocity += motion.torque * (1.0 / motion.inertia) * seconds;
        const rotation = transform.rotation + motion.angularVelocity * seconds;
        transform.scale.add(motion.scaleFactor.scale(seconds, this._SCALE_FACTOR), EulerIntegrator._SCALE);
        const tx = transform.get();
        tx.setTransform(EulerIntegrator._POS, rotation, EulerIntegrator._SCALE);
    }
}
// Scratch vectors to avoid allocation
EulerIntegrator._POS = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(0, 0);
EulerIntegrator._SCALE = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(1, 1);
EulerIntegrator._ACC = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(0, 0);
EulerIntegrator._VEL = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(0, 0);
EulerIntegrator._VEL_ACC = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(0, 0);
EulerIntegrator._SCALE_FACTOR = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(0, 0);


/***/ }),

/***/ "./Collision/MotionSystem.ts":
/*!***********************************!*\
  !*** ./Collision/MotionSystem.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MotionSystem: () => (/* binding */ MotionSystem)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../EntityComponentSystem */ "./EntityComponentSystem/Priority.ts");
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../EntityComponentSystem/Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EntityComponentSystem/System */ "./EntityComponentSystem/System.ts");
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var _CollisionType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _Integrator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Integrator */ "./Collision/Integrator.ts");







class MotionSystem extends _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__.System {
    constructor(world, physics) {
        super();
        this.world = world;
        this.physics = physics;
        this.systemType = _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__.SystemType.Update;
        this._physicsConfigDirty = false;
        physics.$configUpdate.subscribe(() => (this._physicsConfigDirty = true));
        this.query = this.world.query([_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent, _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent]);
    }
    update(elapsed) {
        let transform;
        let motion;
        const entities = this.query.entities;
        const substep = this.physics.config.substep;
        for (let i = 0; i < entities.length; i++) {
            transform = entities[i].get(_EntityComponentSystem_Components_TransformComponent__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
            motion = entities[i].get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_2__.MotionComponent);
            const optionalBody = entities[i].get(_BodyComponent__WEBPACK_IMPORTED_MODULE_3__.BodyComponent);
            if (this._physicsConfigDirty && optionalBody) {
                optionalBody.updatePhysicsConfig(this.physics.config.bodies);
            }
            if (optionalBody === null || optionalBody === void 0 ? void 0 : optionalBody.isSleeping) {
                continue;
            }
            const totalAcc = motion.acc.clone();
            if ((optionalBody === null || optionalBody === void 0 ? void 0 : optionalBody.collisionType) === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Active && (optionalBody === null || optionalBody === void 0 ? void 0 : optionalBody.useGravity)) {
                totalAcc.addEqual(this.physics.config.gravity);
            }
            // capture old transform of this entity and all of its children so that
            // any transform properties that derived from their parents are properly captured
            if (!entities[i].parent) {
                this.captureOldTransformWithChildren(entities[i]);
            }
            // Update transform and motion based on Euler linear algebra
            _Integrator__WEBPACK_IMPORTED_MODULE_5__.EulerIntegrator.integrate(transform, motion, totalAcc, elapsed / substep);
        }
        this._physicsConfigDirty = false;
    }
    captureOldTransformWithChildren(entity) {
        var _a;
        (_a = entity.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_3__.BodyComponent)) === null || _a === void 0 ? void 0 : _a.captureOldTransform();
        for (let i = 0; i < entity.children.length; i++) {
            this.captureOldTransformWithChildren(entity.children[i]);
        }
    }
}
MotionSystem.priority = _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_6__.SystemPriority.Higher;


/***/ }),

/***/ "./Collision/PhysicsConfig.ts":
/*!************************************!*\
  !*** ./Collision/PhysicsConfig.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getDefaultPhysicsConfig: () => (/* binding */ getDefaultPhysicsConfig)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _SolverStrategy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SolverStrategy */ "./Collision/SolverStrategy.ts");
/* harmony import */ var _Solver_ContactBias__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Solver/ContactBias */ "./Collision/Solver/ContactBias.ts");
/* harmony import */ var _Detection_SpatialPartitionStrategy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Detection/SpatialPartitionStrategy */ "./Collision/Detection/SpatialPartitionStrategy.ts");




const getDefaultPhysicsConfig = () => ({
    enabled: true,
    gravity: (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0).clone(),
    solver: _SolverStrategy__WEBPACK_IMPORTED_MODULE_1__.SolverStrategy.Arcade,
    substep: 1,
    colliders: {
        compositeStrategy: 'together'
    },
    continuous: {
        checkForFastBodies: true,
        disableMinimumSpeedForFastBody: false,
        surfaceEpsilon: 0.1
    },
    bodies: {
        canSleepByDefault: false,
        sleepEpsilon: 0.07,
        wakeThreshold: 0.07 * 3,
        sleepBias: 0.9,
        defaultMass: 10
    },
    spatialPartition: _Detection_SpatialPartitionStrategy__WEBPACK_IMPORTED_MODULE_2__.SpatialPartitionStrategy.SparseHashGrid,
    sparseHashGrid: {
        size: 100
    },
    dynamicTree: {
        boundsPadding: 5,
        velocityMultiplier: 2
    },
    arcade: {
        contactSolveBias: _Solver_ContactBias__WEBPACK_IMPORTED_MODULE_3__.ContactSolveBias.None
    },
    realistic: {
        contactSolveBias: _Solver_ContactBias__WEBPACK_IMPORTED_MODULE_3__.ContactSolveBias.None,
        positionIterations: 3,
        velocityIterations: 8,
        slop: 1,
        steeringFactor: 0.2,
        warmStart: true
    }
});


/***/ }),

/***/ "./Collision/PhysicsWorld.ts":
/*!***********************************!*\
  !*** ./Collision/PhysicsWorld.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PhysicsWorld: () => (/* binding */ PhysicsWorld)
/* harmony export */ });
/* harmony import */ var _Util_Observable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Util/Observable */ "./Util/Observable.ts");
/* harmony import */ var _Index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Index */ "./Collision/Detection/SparseHashGridCollisionProcessor.ts");
/* harmony import */ var _Index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Index */ "./Collision/Detection/DynamicTreeCollisionProcessor.ts");
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var _Util_Watch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Util/Watch */ "./Util/Watch.ts");
/* harmony import */ var _Detection_SpatialPartitionStrategy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Detection/SpatialPartitionStrategy */ "./Collision/Detection/SpatialPartitionStrategy.ts");





class PhysicsWorld {
    get config() {
        return (0,_Util_Watch__WEBPACK_IMPORTED_MODULE_0__.watchDeep)(this._config, (change) => {
            this.$configUpdate.notifyAll(change);
        });
    }
    set config(newConfig) {
        this._config = newConfig;
        this.$configUpdate.notifyAll(newConfig);
    }
    /**
     * Spatial data structure for locating potential collision pairs and ray casts
     */
    get collisionProcessor() {
        if (this._configDirty) {
            this._configDirty = false;
            // preserve tracked colliders if config updates
            const colliders = this._collisionProcessor.getColliders();
            if (this._config.spatialPartition === _Detection_SpatialPartitionStrategy__WEBPACK_IMPORTED_MODULE_1__.SpatialPartitionStrategy.SparseHashGrid) {
                this._collisionProcessor = new _Index__WEBPACK_IMPORTED_MODULE_2__.SparseHashGridCollisionProcessor(this._config.sparseHashGrid);
            }
            else {
                this._collisionProcessor = new _Index__WEBPACK_IMPORTED_MODULE_3__.DynamicTreeCollisionProcessor(this._config);
            }
            for (const collider of colliders) {
                this._collisionProcessor.track(collider);
            }
        }
        return this._collisionProcessor;
    }
    constructor(config) {
        this.$configUpdate = new _Util_Observable__WEBPACK_IMPORTED_MODULE_4__.Observable();
        this._configDirty = false;
        this.config = config;
        this.$configUpdate.subscribe((config) => {
            this._configDirty = true;
            _BodyComponent__WEBPACK_IMPORTED_MODULE_5__.BodyComponent.updateDefaultPhysicsConfig(config.bodies);
        });
        if (this._config.spatialPartition === _Detection_SpatialPartitionStrategy__WEBPACK_IMPORTED_MODULE_1__.SpatialPartitionStrategy.SparseHashGrid) {
            this._collisionProcessor = new _Index__WEBPACK_IMPORTED_MODULE_2__.SparseHashGridCollisionProcessor(this._config.sparseHashGrid);
        }
        else {
            this._collisionProcessor = new _Index__WEBPACK_IMPORTED_MODULE_3__.DynamicTreeCollisionProcessor(this._config);
        }
    }
    /**
     * Raycast into the scene's physics world
     * @param ray
     * @param options
     */
    rayCast(ray, options) {
        return this.collisionProcessor.rayCast(ray, options);
    }
    query(pointOrBounds) {
        // FIXME workaround TS: https://github.com/microsoft/TypeScript/issues/14107
        return this._collisionProcessor.query(pointOrBounds);
    }
}


/***/ }),

/***/ "./Collision/Side.ts":
/*!***************************!*\
  !*** ./Collision/Side.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Side: () => (/* binding */ Side)
/* harmony export */ });
/**
 * An enum that describes the sides of an axis aligned box for collision
 */
var Side;
(function (Side) {
    Side["None"] = "None";
    Side["Top"] = "Top";
    Side["Bottom"] = "Bottom";
    Side["Left"] = "Left";
    Side["Right"] = "Right";
})(Side || (Side = {}));
(function (Side) {
    /**
     * Returns the opposite side from the current
     */
    function getOpposite(side) {
        if (side === Side.Top) {
            return Side.Bottom;
        }
        if (side === Side.Bottom) {
            return Side.Top;
        }
        if (side === Side.Left) {
            return Side.Right;
        }
        if (side === Side.Right) {
            return Side.Left;
        }
        return Side.None;
    }
    Side.getOpposite = getOpposite;
    /**
     * Given a vector, return the Side most in that direction
     */
    function fromDirection(direction) {
        if (Math.abs(direction.x) >= Math.abs(direction.y)) {
            if (direction.x <= 0) {
                return Side.Left;
            }
            return Side.Right;
        }
        if (direction.y <= 0) {
            return Side.Top;
        }
        return Side.Bottom;
    }
    Side.fromDirection = fromDirection;
})(Side || (Side = {}));


/***/ }),

/***/ "./Collision/Solver/ArcadeSolver.ts":
/*!******************************************!*\
  !*** ./Collision/Solver/ArcadeSolver.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArcadeSolver: () => (/* binding */ ArcadeSolver)
/* harmony export */ });
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events */ "./Events.ts");
/* harmony import */ var _CollisionType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _Side__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Side */ "./Collision/Side.ts");
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var _ContactBias__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ContactBias */ "./Collision/Solver/ContactBias.ts");





/**
 * ArcadeSolver is the default in Excalibur. It solves collisions so that there is no overlap between contacts,
 * and negates velocity along the collision normal.
 *
 * This is usually the type of collisions used for 2D games that don't need a more realistic collision simulation.
 *
 */
class ArcadeSolver {
    constructor(config) {
        this.config = config;
        this.directionMap = new Map();
        this.distanceMap = new Map();
        this._compositeContactsIds = new Set();
    }
    solve(contacts) {
        // Events and init
        this.preSolve(contacts);
        // Remove any canceled contacts
        contacts = contacts.filter((c) => !c.isCanceled());
        // Locate collision bias order
        let bias;
        switch (this.config.contactSolveBias) {
            case _ContactBias__WEBPACK_IMPORTED_MODULE_0__.ContactSolveBias.HorizontalFirst: {
                bias = _ContactBias__WEBPACK_IMPORTED_MODULE_0__.HorizontalFirst;
                break;
            }
            case _ContactBias__WEBPACK_IMPORTED_MODULE_0__.ContactSolveBias.VerticalFirst: {
                bias = _ContactBias__WEBPACK_IMPORTED_MODULE_0__.VerticalFirst;
                break;
            }
            default: {
                bias = _ContactBias__WEBPACK_IMPORTED_MODULE_0__.None;
            }
        }
        // Sort by bias (None, VerticalFirst, HorizontalFirst) to avoid artifacts with seams
        // Sort contacts by distance to avoid artifacts with seams
        // It's important to solve in a specific order
        contacts.sort((a, b) => {
            const aDir = this.directionMap.get(a.id);
            const bDir = this.directionMap.get(b.id);
            const aDist = this.distanceMap.get(a.id);
            const bDist = this.distanceMap.get(b.id);
            return bias[aDir] - bias[bDir] || aDist - bDist;
        });
        for (const contact of contacts) {
            // Solve position first in arcade
            this.solvePosition(contact);
            // Solve velocity second in arcade
            this.solveVelocity(contact);
        }
        // Events and any contact house-keeping the solver needs
        this.postSolve(contacts);
        return contacts;
    }
    preSolve(contacts) {
        const epsilon = 0.0001;
        for (let i = 0; i < contacts.length; i++) {
            const contact = contacts[i];
            // Cancel dup composite together strategy contacts
            const index = contact.id.indexOf('|');
            if (index > 0) {
                const compositeId = contact.id.substring(index + 1);
                if (this._compositeContactsIds.has(compositeId)) {
                    contact.cancel();
                    continue;
                }
                this._compositeContactsIds.add(compositeId);
            }
            // Cancel near 0 mtv collisions
            if (Math.abs(contact.mtv.x) < epsilon && Math.abs(contact.mtv.y) < epsilon) {
                contact.cancel();
                continue;
            }
            // Record distance/direction for sorting
            const side = _Side__WEBPACK_IMPORTED_MODULE_1__.Side.fromDirection(contact.mtv);
            const mtv = contact.mtv.negate();
            const distance = Math.abs(contact.info.separation);
            this.distanceMap.set(contact.id, distance);
            this.directionMap.set(contact.id, side === _Side__WEBPACK_IMPORTED_MODULE_1__.Side.Left || side === _Side__WEBPACK_IMPORTED_MODULE_1__.Side.Right ? 'horizontal' : 'vertical');
            // Publish collision events on both participants
            contact.colliderA.events.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_2__.PreCollisionEvent(contact.colliderA, contact.colliderB, side, mtv, contact));
            contact.colliderB.events.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_2__.PreCollisionEvent(contact.colliderB, contact.colliderA, _Side__WEBPACK_IMPORTED_MODULE_1__.Side.getOpposite(side), mtv.negate(), contact));
        }
        this._compositeContactsIds.clear();
    }
    postSolve(contacts) {
        var _a, _b;
        for (let i = 0; i < contacts.length; i++) {
            const contact = contacts[i];
            if (contact.isCanceled()) {
                continue;
            }
            const colliderA = contact.colliderA;
            const colliderB = contact.colliderB;
            const bodyA = (_a = colliderA.owner) === null || _a === void 0 ? void 0 : _a.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_3__.BodyComponent);
            const bodyB = (_b = colliderB.owner) === null || _b === void 0 ? void 0 : _b.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_3__.BodyComponent);
            if (bodyA && bodyB) {
                if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive || bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive) {
                    continue;
                }
            }
            const side = _Side__WEBPACK_IMPORTED_MODULE_1__.Side.fromDirection(contact.mtv);
            const mtv = contact.mtv.negate();
            // Publish collision events on both participants
            contact.colliderA.events.emit('postcollision', new _Events__WEBPACK_IMPORTED_MODULE_2__.PostCollisionEvent(contact.colliderA, contact.colliderB, side, mtv, contact));
            contact.colliderB.events.emit('postcollision', new _Events__WEBPACK_IMPORTED_MODULE_2__.PostCollisionEvent(contact.colliderB, contact.colliderA, _Side__WEBPACK_IMPORTED_MODULE_1__.Side.getOpposite(side), mtv.negate(), contact));
        }
    }
    solvePosition(contact) {
        var _a, _b;
        const epsilon = 0.0001;
        // if bounds no longer intersect skip to the next
        // this removes jitter from overlapping/stacked solid tiles or a wall of solid tiles
        if (!contact.colliderA.bounds.overlaps(contact.colliderB.bounds, epsilon)) {
            // Cancel the contact to prevent and solving
            contact.cancel();
            return;
        }
        if (Math.abs(contact.mtv.x) < epsilon && Math.abs(contact.mtv.y) < epsilon) {
            // Cancel near 0 mtv collisions
            contact.cancel();
            return;
        }
        let mtv = contact.mtv;
        const colliderA = contact.colliderA;
        const colliderB = contact.colliderB;
        const bodyA = (_a = colliderA.owner) === null || _a === void 0 ? void 0 : _a.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_3__.BodyComponent);
        const bodyB = (_b = colliderB.owner) === null || _b === void 0 ? void 0 : _b.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_3__.BodyComponent);
        if (bodyA && bodyB) {
            if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive || bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive) {
                return;
            }
            if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Active && bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Active) {
                // split overlaps if both are Active
                mtv = mtv.scale(0.5);
            }
            // Resolve overlaps
            if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Active) {
                bodyA.globalPos.x -= mtv.x;
                bodyA.globalPos.y -= mtv.y;
                colliderA.update(bodyA.transform.get());
            }
            if (bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Active) {
                bodyB.globalPos.x += mtv.x;
                bodyB.globalPos.y += mtv.y;
                colliderB.update(bodyB.transform.get());
            }
        }
    }
    solveVelocity(contact) {
        var _a, _b;
        if (contact.isCanceled()) {
            return;
        }
        const colliderA = contact.colliderA;
        const colliderB = contact.colliderB;
        const bodyA = (_a = colliderA.owner) === null || _a === void 0 ? void 0 : _a.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_3__.BodyComponent);
        const bodyB = (_b = colliderB.owner) === null || _b === void 0 ? void 0 : _b.get(_BodyComponent__WEBPACK_IMPORTED_MODULE_3__.BodyComponent);
        if (bodyA && bodyB) {
            if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive || bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive) {
                return;
            }
            const normal = contact.normal;
            const opposite = normal.negate();
            if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Active) {
                // only adjust velocity if the contact normal is opposite to the current velocity
                // this avoids catching edges on a platform when sliding off
                if (bodyA.vel.normalize().dot(opposite) < 0) {
                    // Cancel out velocity opposite direction of collision normal
                    const velAdj = normal.scale(normal.dot(bodyA.vel.negate()));
                    bodyA.vel = bodyA.vel.add(velAdj);
                }
            }
            if (bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Active) {
                // only adjust velocity if the contact normal is opposite to the current velocity
                // this avoids catching edges on a platform
                if (bodyB.vel.normalize().dot(normal) < 0) {
                    const velAdj = opposite.scale(opposite.dot(bodyB.vel.negate()));
                    bodyB.vel = bodyB.vel.add(velAdj);
                }
            }
        }
    }
}


/***/ }),

/***/ "./Collision/Solver/ContactBias.ts":
/*!*****************************************!*\
  !*** ./Collision/Solver/ContactBias.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ContactSolveBias: () => (/* binding */ ContactSolveBias),
/* harmony export */   HorizontalFirst: () => (/* binding */ HorizontalFirst),
/* harmony export */   None: () => (/* binding */ None),
/* harmony export */   VerticalFirst: () => (/* binding */ VerticalFirst)
/* harmony export */ });
/**
 * Tells the Arcade collision solver to prefer certain contacts over others
 */
var ContactSolveBias;
(function (ContactSolveBias) {
    ContactSolveBias["None"] = "none";
    ContactSolveBias["VerticalFirst"] = "vertical-first";
    ContactSolveBias["HorizontalFirst"] = "horizontal-first";
})(ContactSolveBias || (ContactSolveBias = {}));
/**
 * Vertical First contact solve bias Used by the {@apilink ArcadeSolver} to sort contacts
 */
const VerticalFirst = {
    vertical: 1,
    horizontal: 2
};
/**
 * Horizontal First contact solve bias Used by the {@apilink ArcadeSolver} to sort contacts
 */
const HorizontalFirst = {
    horizontal: 1,
    vertical: 2
};
/**
 * None value, {@apilink ArcadeSolver} sorts contacts using distance by default
 */
const None = {
    horizontal: 0,
    vertical: 0
};


/***/ }),

/***/ "./Collision/Solver/ContactConstraintPoint.ts":
/*!****************************************************!*\
  !*** ./Collision/Solver/ContactConstraintPoint.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ContactConstraintPoint: () => (/* binding */ ContactConstraintPoint)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");

/**
 * Holds information about contact points, meant to be reused over multiple frames of contact
 */
class ContactConstraintPoint {
    constructor(point, local, contact) {
        this.point = point;
        this.local = local;
        this.contact = contact;
        /**
         * Impulse accumulated over time in normal direction
         */
        this.normalImpulse = 0;
        /**
         * Impulse accumulated over time in the tangent direction
         */
        this.tangentImpulse = 0;
        /**
         * Effective mass seen in the normal direction
         */
        this.normalMass = 0;
        /**
         * Effective mass seen in the tangent direction
         */
        this.tangentMass = 0;
        /**
         * Direction from center of mass of bodyA to contact point
         */
        this.aToContact = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(0, 0);
        /**
         * Direction from center of mass of bodyB to contact point
         */
        this.bToContact = new _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector(0, 0);
        /**
         * Original contact velocity combined with bounciness
         */
        this.originalVelocityAndRestitution = 0;
        this.update();
    }
    /**
     * Updates the contact information
     */
    update() {
        const bodyA = this.contact.bodyA;
        const colliderA = this.contact.colliderA;
        const bodyB = this.contact.bodyB;
        const colliderB = this.contact.colliderB;
        if (bodyA && bodyB) {
            const normal = this.contact.normal;
            const tangent = this.contact.tangent;
            this.aToContact = this.point.sub(colliderA.center);
            this.bToContact = this.point.sub(colliderB.center);
            const aToContactNormal = this.aToContact.cross(normal);
            const bToContactNormal = this.bToContact.cross(normal);
            this.normalMass =
                bodyA.inverseMass +
                    bodyB.inverseMass +
                    bodyA.inverseInertia * aToContactNormal * aToContactNormal +
                    bodyB.inverseInertia * bToContactNormal * bToContactNormal;
            const aToContactTangent = this.aToContact.cross(tangent);
            const bToContactTangent = this.bToContact.cross(tangent);
            this.tangentMass =
                bodyA.inverseMass +
                    bodyB.inverseMass +
                    bodyA.inverseInertia * aToContactTangent * aToContactTangent +
                    bodyB.inverseInertia * bToContactTangent * bToContactTangent;
        }
        return this;
    }
    /**
     * Returns the relative velocity between bodyA and bodyB
     */
    getRelativeVelocity() {
        const bodyA = this.contact.bodyA;
        const bodyB = this.contact.bodyB;
        if (bodyA && bodyB) {
            // Relative velocity in linear terms
            // Angular to linear velocity formula -> omega = velocity/radius so omega x radius = velocity
            const velA = bodyA.vel.add(_Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.cross(bodyA.angularVelocity, this.aToContact));
            const velB = bodyB.vel.add(_Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.cross(bodyB.angularVelocity, this.bToContact));
            return velB.sub(velA);
        }
        return _Math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector.Zero;
    }
}


/***/ }),

/***/ "./Collision/Solver/RealisticSolver.ts":
/*!*********************************************!*\
  !*** ./Collision/Solver/RealisticSolver.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RealisticSolver: () => (/* binding */ RealisticSolver)
/* harmony export */ });
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events */ "./Events.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Math/util */ "./Math/util.ts");
/* harmony import */ var _CollisionType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../CollisionType */ "./Collision/CollisionType.ts");
/* harmony import */ var _ContactConstraintPoint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ContactConstraintPoint */ "./Collision/Solver/ContactConstraintPoint.ts");
/* harmony import */ var _Side__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Side */ "./Collision/Side.ts");
/* harmony import */ var _BodyComponent__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var _Colliders_CollisionJumpTable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Colliders/CollisionJumpTable */ "./Collision/Colliders/CollisionJumpTable.ts");
/* harmony import */ var _ContactBias__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ContactBias */ "./Collision/Solver/ContactBias.ts");








class RealisticSolver {
    constructor(config) {
        this.config = config;
        this.directionMap = new Map();
        this.distanceMap = new Map();
        this.lastFrameContacts = new Map();
        // map contact id to contact points
        this.idToContactConstraint = new Map();
    }
    getContactConstraints(id) {
        var _a;
        return (_a = this.idToContactConstraint.get(id)) !== null && _a !== void 0 ? _a : [];
    }
    solve(contacts) {
        // Events and init
        this.preSolve(contacts);
        // Remove any canceled contacts
        contacts = contacts.filter((c) => !c.isCanceled());
        // Locate collision bias order
        let bias;
        switch (this.config.contactSolveBias) {
            case _ContactBias__WEBPACK_IMPORTED_MODULE_0__.ContactSolveBias.HorizontalFirst: {
                bias = _ContactBias__WEBPACK_IMPORTED_MODULE_0__.HorizontalFirst;
                break;
            }
            case _ContactBias__WEBPACK_IMPORTED_MODULE_0__.ContactSolveBias.VerticalFirst: {
                bias = _ContactBias__WEBPACK_IMPORTED_MODULE_0__.VerticalFirst;
                break;
            }
            default: {
                bias = _ContactBias__WEBPACK_IMPORTED_MODULE_0__.None;
            }
        }
        // Sort by bias (None, VerticalFirst, HorizontalFirst) to avoid artifacts with seams
        // Sort contacts by distance to avoid artifacts with seams
        // It's important to solve in a specific order
        contacts.sort((a, b) => {
            const aDir = this.directionMap.get(a.id);
            const bDir = this.directionMap.get(b.id);
            const aDist = this.distanceMap.get(a.id);
            const bDist = this.distanceMap.get(b.id);
            return bias[aDir] - bias[bDir] || aDist - bDist;
        });
        // Solve velocity first
        this.solveVelocity(contacts);
        // Solve position last because non-overlap is the most important
        this.solvePosition(contacts);
        // Events and any contact house-keeping the solver needs
        this.postSolve(contacts);
        return contacts;
    }
    preSolve(contacts) {
        var _a, _b, _c, _d;
        const epsilon = 0.0001;
        for (let i = 0; i < contacts.length; i++) {
            const contact = contacts[i];
            if (Math.abs(contact.mtv.x) < epsilon && Math.abs(contact.mtv.y) < epsilon) {
                // Cancel near 0 mtv collisions
                contact.cancel();
                continue;
            }
            // Publish collision events on both participants
            const side = _Side__WEBPACK_IMPORTED_MODULE_1__.Side.fromDirection(contact.mtv);
            const distance = Math.abs(((_a = contact === null || contact === void 0 ? void 0 : contact.info) === null || _a === void 0 ? void 0 : _a.separation) || 0);
            this.distanceMap.set(contact.id, distance);
            this.directionMap.set(contact.id, side === _Side__WEBPACK_IMPORTED_MODULE_1__.Side.Left || side === _Side__WEBPACK_IMPORTED_MODULE_1__.Side.Right ? 'horizontal' : 'vertical');
            contact.colliderA.events.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_2__.PreCollisionEvent(contact.colliderA, contact.colliderB, side, contact.mtv, contact));
            contact.colliderA.events.emit('beforecollisionresolve', new _Events__WEBPACK_IMPORTED_MODULE_2__.CollisionPreSolveEvent(contact.colliderA, contact.colliderB, side, contact.mtv, contact));
            contact.colliderB.events.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_2__.PreCollisionEvent(contact.colliderB, contact.colliderA, _Side__WEBPACK_IMPORTED_MODULE_1__.Side.getOpposite(side), contact.mtv.negate(), contact));
            contact.colliderB.events.emit('beforecollisionresolve', new _Events__WEBPACK_IMPORTED_MODULE_2__.CollisionPreSolveEvent(contact.colliderB, contact.colliderA, _Side__WEBPACK_IMPORTED_MODULE_1__.Side.getOpposite(side), contact.mtv.negate(), contact));
            // Match awake state for sleeping
            contact.matchAwake();
        }
        // Keep track of contacts that done
        const finishedContactIds = Array.from(this.idToContactConstraint.keys());
        for (let i = 0; i < contacts.length; i++) {
            const contact = contacts[i];
            // Remove all current contacts that are not done
            const index = finishedContactIds.indexOf(contact.id);
            if (index > -1) {
                finishedContactIds.splice(index, 1);
            }
            const contactPoints = (_b = this.idToContactConstraint.get(contact.id)) !== null && _b !== void 0 ? _b : [];
            let pointIndex = 0;
            const bodyA = contact.bodyA;
            const colliderA = contact.colliderA;
            const bodyB = contact.bodyB;
            const colliderB = contact.colliderB;
            if (bodyA && bodyB) {
                for (let j = 0; j < contact.points.length; j++) {
                    const point = contact.points[j];
                    const normal = contact.normal;
                    const tangent = contact.tangent;
                    const aToContact = point.sub(colliderA.center);
                    const bToContact = point.sub(colliderB.center);
                    const aToContactNormal = aToContact.cross(normal);
                    const bToContactNormal = bToContact.cross(normal);
                    const normalMass = bodyA.inverseMass +
                        bodyB.inverseMass +
                        bodyA.inverseInertia * aToContactNormal * aToContactNormal +
                        bodyB.inverseInertia * bToContactNormal * bToContactNormal;
                    const aToContactTangent = aToContact.cross(tangent);
                    const bToContactTangent = bToContact.cross(tangent);
                    const tangentMass = bodyA.inverseMass +
                        bodyB.inverseMass +
                        bodyA.inverseInertia * aToContactTangent * aToContactTangent +
                        bodyB.inverseInertia * bToContactTangent * bToContactTangent;
                    // Preserve normal/tangent impulse by re-using the contact point if it's close
                    if (contactPoints[pointIndex] && ((_d = (_c = contactPoints[pointIndex]) === null || _c === void 0 ? void 0 : _c.point) === null || _d === void 0 ? void 0 : _d.squareDistance(point)) < 4) {
                        contactPoints[pointIndex].point = point;
                        contactPoints[pointIndex].local = contact.localPoints[pointIndex];
                    }
                    else {
                        // new contact if it's not close or doesn't exist
                        contactPoints[pointIndex] = new _ContactConstraintPoint__WEBPACK_IMPORTED_MODULE_3__.ContactConstraintPoint(point, contact.localPoints[pointIndex], contact);
                    }
                    // Update contact point calculations
                    contactPoints[pointIndex].aToContact = aToContact;
                    contactPoints[pointIndex].bToContact = bToContact;
                    contactPoints[pointIndex].normalMass = 1.0 / normalMass;
                    contactPoints[pointIndex].tangentMass = 1.0 / tangentMass;
                    // Calculate relative velocity before solving to accurately do restitution
                    const restitution = bodyA.bounciness > bodyB.bounciness ? bodyA.bounciness : bodyB.bounciness;
                    const relativeVelocity = contact.normal.dot(contactPoints[pointIndex].getRelativeVelocity());
                    contactPoints[pointIndex].originalVelocityAndRestitution = 0;
                    if (relativeVelocity < -0.1) {
                        // TODO what's a good threshold here?
                        contactPoints[pointIndex].originalVelocityAndRestitution = -restitution * relativeVelocity;
                    }
                    pointIndex++;
                }
            }
            this.idToContactConstraint.set(contact.id, contactPoints);
        }
        // Clean up any contacts that did not occur last frame
        for (const id of finishedContactIds) {
            this.idToContactConstraint.delete(id);
        }
        // Warm contacts with accumulated impulse
        // Useful for tall stacks
        if (this.config.warmStart) {
            this.warmStart(contacts);
        }
        else {
            for (let i = 0; i < contacts.length; i++) {
                const contact = contacts[i];
                const contactPoints = this.getContactConstraints(contact.id);
                for (const point of contactPoints) {
                    point.normalImpulse = 0;
                    point.tangentImpulse = 0;
                }
            }
        }
    }
    postSolve(contacts) {
        for (let i = 0; i < contacts.length; i++) {
            const contact = contacts[i];
            const bodyA = contact.bodyA;
            const bodyB = contact.bodyB;
            if (bodyA && bodyB) {
                // Skip post solve for active+passive collisions
                if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive || bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive) {
                    continue;
                }
                // Update motion values for sleeping
                bodyA.updateMotion();
                bodyB.updateMotion();
            }
            // Publish collision events on both participants
            const side = _Side__WEBPACK_IMPORTED_MODULE_1__.Side.fromDirection(contact.mtv);
            contact.colliderA.events.emit('postcollision', new _Events__WEBPACK_IMPORTED_MODULE_2__.PostCollisionEvent(contact.colliderA, contact.colliderB, side, contact.mtv, contact));
            contact.colliderA.events.emit('aftercollisionresolve', new _Events__WEBPACK_IMPORTED_MODULE_2__.CollisionPostSolveEvent(contact.colliderA, contact.colliderB, side, contact.mtv, contact));
            contact.colliderB.events.emit('postcollision', new _Events__WEBPACK_IMPORTED_MODULE_2__.PostCollisionEvent(contact.colliderB, contact.colliderA, _Side__WEBPACK_IMPORTED_MODULE_1__.Side.getOpposite(side), contact.mtv.negate(), contact));
            contact.colliderB.events.emit('aftercollisionresolve', new _Events__WEBPACK_IMPORTED_MODULE_2__.CollisionPostSolveEvent(contact.colliderB, contact.colliderA, _Side__WEBPACK_IMPORTED_MODULE_1__.Side.getOpposite(side), contact.mtv.negate(), contact));
        }
        // Store contacts
        this.lastFrameContacts.clear();
        for (let i = 0; i < contacts.length; i++) {
            const c = contacts[i];
            this.lastFrameContacts.set(c.id, c);
        }
    }
    /**
     * Warm up body's based on previous frame contact points
     * @param contacts
     */
    warmStart(contacts) {
        var _a;
        for (let i = 0; i < contacts.length; i++) {
            const contact = contacts[i];
            const bodyA = contact.bodyA;
            const bodyB = contact.bodyB;
            if (bodyA && bodyB) {
                const contactPoints = (_a = this.idToContactConstraint.get(contact.id)) !== null && _a !== void 0 ? _a : [];
                for (const point of contactPoints) {
                    if (this.config.warmStart) {
                        const normalImpulse = contact.normal.scale(point.normalImpulse);
                        const tangentImpulse = contact.tangent.scale(point.tangentImpulse);
                        const impulse = normalImpulse.add(tangentImpulse);
                        bodyA.applyImpulse(point.point, impulse.negate());
                        bodyB.applyImpulse(point.point, impulse);
                    }
                    else {
                        point.normalImpulse = 0;
                        point.tangentImpulse = 0;
                    }
                }
            }
        }
    }
    /**
     * Iteratively solve the position overlap constraint
     * @param contacts
     */
    solvePosition(contacts) {
        var _a;
        for (let i = 0; i < this.config.positionIterations; i++) {
            for (let i = 0; i < contacts.length; i++) {
                const contact = contacts[i];
                const bodyA = contact.bodyA;
                const bodyB = contact.bodyB;
                if (bodyA && bodyB) {
                    // Skip solving active+passive
                    if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive || bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive) {
                        continue;
                    }
                    const constraints = (_a = this.idToContactConstraint.get(contact.id)) !== null && _a !== void 0 ? _a : [];
                    for (const point of constraints) {
                        const normal = contact.normal;
                        const separation = _Colliders_CollisionJumpTable__WEBPACK_IMPORTED_MODULE_5__.CollisionJumpTable.FindContactSeparation(contact, point.local);
                        const steeringConstant = this.config.steeringFactor; //0.2;
                        const maxCorrection = -5;
                        const slop = this.config.slop; //1;
                        // Clamp to avoid over-correction
                        // Remember that we are shooting for 0 overlap in the end
                        const steeringForce = (0,_Math_util__WEBPACK_IMPORTED_MODULE_6__.clamp)(steeringConstant * (separation + slop), maxCorrection, 0);
                        const impulse = normal.scale(-steeringForce * point.normalMass);
                        // This is a pseudo impulse, meaning we aren't doing a real impulse calculation
                        // We adjust position and rotation instead of doing the velocity
                        if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Active) {
                            // TODO make applyPseudoImpulse function?
                            const impulseForce = impulse.negate().scale(bodyA.inverseMass);
                            if (bodyA.limitDegreeOfFreedom.includes(_BodyComponent__WEBPACK_IMPORTED_MODULE_7__.DegreeOfFreedom.X)) {
                                impulseForce.x = 0;
                            }
                            if (bodyA.limitDegreeOfFreedom.includes(_BodyComponent__WEBPACK_IMPORTED_MODULE_7__.DegreeOfFreedom.Y)) {
                                impulseForce.y = 0;
                            }
                            bodyA.globalPos = bodyA.globalPos.add(impulseForce);
                            if (!bodyA.limitDegreeOfFreedom.includes(_BodyComponent__WEBPACK_IMPORTED_MODULE_7__.DegreeOfFreedom.Rotation)) {
                                bodyA.rotation -= point.aToContact.cross(impulse) * bodyA.inverseInertia;
                            }
                        }
                        if (bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Active) {
                            const impulseForce = impulse.scale(bodyB.inverseMass);
                            if (bodyB.limitDegreeOfFreedom.includes(_BodyComponent__WEBPACK_IMPORTED_MODULE_7__.DegreeOfFreedom.X)) {
                                impulseForce.x = 0;
                            }
                            if (bodyB.limitDegreeOfFreedom.includes(_BodyComponent__WEBPACK_IMPORTED_MODULE_7__.DegreeOfFreedom.Y)) {
                                impulseForce.y = 0;
                            }
                            bodyB.globalPos = bodyB.globalPos.add(impulseForce);
                            if (!bodyB.limitDegreeOfFreedom.includes(_BodyComponent__WEBPACK_IMPORTED_MODULE_7__.DegreeOfFreedom.Rotation)) {
                                bodyB.rotation += point.bToContact.cross(impulse) * bodyB.inverseInertia;
                            }
                        }
                    }
                }
            }
        }
    }
    solveVelocity(contacts) {
        var _a;
        for (let i = 0; i < this.config.velocityIterations; i++) {
            for (let i = 0; i < contacts.length; i++) {
                const contact = contacts[i];
                const bodyA = contact.bodyA;
                const bodyB = contact.bodyB;
                if (bodyA && bodyB) {
                    // Skip solving active+passive
                    if (bodyA.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive || bodyB.collisionType === _CollisionType__WEBPACK_IMPORTED_MODULE_4__.CollisionType.Passive) {
                        continue;
                    }
                    const friction = Math.min(bodyA.friction, bodyB.friction);
                    const constraints = (_a = this.idToContactConstraint.get(contact.id)) !== null && _a !== void 0 ? _a : [];
                    // Friction constraint
                    for (const point of constraints) {
                        const relativeVelocity = point.getRelativeVelocity();
                        // Negate velocity in tangent direction to simulate friction
                        const tangentVelocity = -relativeVelocity.dot(contact.tangent);
                        let impulseDelta = tangentVelocity * point.tangentMass;
                        // Clamping based in Erin Catto's GDC 2006 talk
                        // Correct clamping https://github.com/erincatto/box2d-lite/blob/master/docs/GDC2006_Catto_Erin_PhysicsTutorial.pdf
                        // Accumulated fiction impulse is always between -uMaxFriction < dT < uMaxFriction
                        // But deltas can vary
                        const maxFriction = friction * point.normalImpulse;
                        const newImpulse = (0,_Math_util__WEBPACK_IMPORTED_MODULE_6__.clamp)(point.tangentImpulse + impulseDelta, -maxFriction, maxFriction);
                        impulseDelta = newImpulse - point.tangentImpulse;
                        point.tangentImpulse = newImpulse;
                        const impulse = contact.tangent.scale(impulseDelta);
                        bodyA.applyImpulse(point.point, impulse.negate());
                        bodyB.applyImpulse(point.point, impulse);
                    }
                    // Bounce constraint
                    for (const point of constraints) {
                        // Need to recalc relative velocity because the previous step could have changed vel
                        const relativeVelocity = point.getRelativeVelocity();
                        // Compute impulse in normal direction
                        const normalVelocity = relativeVelocity.dot(contact.normal);
                        // Per Erin it is a mistake to apply the restitution inside the iteration
                        // From Erin Catto's Box2D we keep original contact velocity and adjust by small impulses
                        let impulseDelta = -point.normalMass * (normalVelocity - point.originalVelocityAndRestitution);
                        // Clamping based in Erin Catto's GDC 2014 talk
                        // Accumulated impulse stored in the contact is always positive (dV > 0)
                        // But deltas can be negative
                        const newImpulse = Math.max(point.normalImpulse + impulseDelta, 0);
                        impulseDelta = newImpulse - point.normalImpulse;
                        point.normalImpulse = newImpulse;
                        const impulse = contact.normal.scale(impulseDelta);
                        bodyA.applyImpulse(point.point, impulse.negate());
                        bodyB.applyImpulse(point.point, impulse);
                    }
                }
            }
        }
    }
}


/***/ }),

/***/ "./Collision/SolverStrategy.ts":
/*!*************************************!*\
  !*** ./Collision/SolverStrategy.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SolverStrategy: () => (/* binding */ SolverStrategy)
/* harmony export */ });
/**
 * Possible collision resolution strategies
 *
 * The default is {@apilink SolverStrategy.Arcade} which performs simple axis aligned arcade style physics. This is useful for things
 * like platformers or top down games.
 *
 * More advanced rigid body physics are enabled by setting {@apilink SolverStrategy.Realistic} which allows for complicated
 * simulated physical interactions.
 */
var SolverStrategy;
(function (SolverStrategy) {
    SolverStrategy["Arcade"] = "arcade";
    SolverStrategy["Realistic"] = "realistic";
})(SolverStrategy || (SolverStrategy = {}));


/***/ }),

/***/ "./Color.ts":
/*!******************!*\
  !*** ./Color.ts ***!
  \******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Color: () => (/* binding */ Color)
/* harmony export */ });
/**
 * Provides standard colors (e.g. {@apilink Color.Black})
 * but you can also create custom colors using RGB, HSL, or Hex. Also provides
 * useful color operations like {@apilink Color.lighten}, {@apilink Color.darken}, and more.
 */
class Color {
    /**
     * Creates a new instance of Color from an r, g, b, a
     * @param r  The red component of color (0-255)
     * @param g  The green component of color (0-255)
     * @param b  The blue component of color (0-255)
     * @param a  The alpha component of color (0-1.0)
     */
    constructor(r, g, b, a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a != null ? a : 1;
    }
    /**
     * Creates a new instance of Color from an r, g, b, a
     * @param r  The red component of color (0-255)
     * @param g  The green component of color (0-255)
     * @param b  The blue component of color (0-255)
     * @param a  The alpha component of color (0-1.0)
     */
    static fromRGB(r, g, b, a) {
        return new Color(r, g, b, a);
    }
    /**
     * Creates a new instance of Color from a rgb string
     * @param string  CSS color string of the form rgba(255, 255, 255, 1) or rgb(255, 255, 255)
     */
    static fromRGBString(string) {
        const rgbaRegEx = /^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)/i;
        let match = null;
        if ((match = string.match(rgbaRegEx))) {
            const r = parseInt(match[1], 10);
            const g = parseInt(match[2], 10);
            const b = parseInt(match[3], 10);
            let a = 1;
            if (match[4]) {
                a = parseFloat(match[4]);
            }
            return new Color(r, g, b, a);
        }
        else {
            throw new Error('Invalid rgb/a string: ' + string);
        }
    }
    /**
     * Creates a new instance of Color from a hex string
     * @param hex  CSS color string of the form #ffffff, the alpha component is optional
     */
    static fromHex(hex) {
        const hexRegEx = /^#?([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i;
        let match = null;
        if ((match = hex.match(hexRegEx))) {
            const r = parseInt(match[1], 16);
            const g = parseInt(match[2], 16);
            const b = parseInt(match[3], 16);
            let a = 1;
            if (match[4]) {
                a = parseInt(match[4], 16) / 255;
            }
            return new Color(r, g, b, a);
        }
        else {
            throw new Error('Invalid hex string: ' + hex);
        }
    }
    /**
     * Creates a new instance of Color from hsla values
     * @param h  Hue is represented [0-1]
     * @param s  Saturation is represented [0-1]
     * @param l  Luminance is represented [0-1]
     * @param a  Alpha is represented [0-1]
     */
    static fromHSL(h, s, l, a = 1.0) {
        const temp = new HSLColor(h, s, l, a);
        return temp.toRGBA();
    }
    /**
     * Lightens the current color by a specified amount
     * @param factor  The amount to lighten by [0-1]
     */
    lighten(factor = 0.1) {
        const temp = HSLColor.fromRGBA(this.r, this.g, this.b, this.a);
        temp.l += (1 - temp.l) * factor;
        return temp.toRGBA();
    }
    /**
     * Darkens the current color by a specified amount
     * @param factor  The amount to darken by [0-1]
     */
    darken(factor = 0.1) {
        const temp = HSLColor.fromRGBA(this.r, this.g, this.b, this.a);
        temp.l -= temp.l * factor;
        return temp.toRGBA();
    }
    /**
     * Saturates the current color by a specified amount
     * @param factor  The amount to saturate by [0-1]
     */
    saturate(factor = 0.1) {
        const temp = HSLColor.fromRGBA(this.r, this.g, this.b, this.a);
        temp.s += temp.s * factor;
        return temp.toRGBA();
    }
    /**
     * Desaturates the current color by a specified amount
     * @param factor  The amount to desaturate by [0-1]
     */
    desaturate(factor = 0.1) {
        const temp = HSLColor.fromRGBA(this.r, this.g, this.b, this.a);
        temp.s -= temp.s * factor;
        return temp.toRGBA();
    }
    /**
     * Multiplies a color by another, results in a darker color
     * @param color  The other color
     */
    multiply(color) {
        const newR = (((color.r / 255) * this.r) / 255) * 255;
        const newG = (((color.g / 255) * this.g) / 255) * 255;
        const newB = (((color.b / 255) * this.b) / 255) * 255;
        const newA = color.a * this.a;
        return new Color(newR, newG, newB, newA);
    }
    /**
     * Screens a color by another, results in a lighter color
     * @param color  The other color
     */
    screen(color) {
        const color1 = color.invert();
        const color2 = color.invert();
        return color1.multiply(color2).invert();
    }
    /**
     * Inverts the current color
     */
    invert() {
        return new Color(255 - this.r, 255 - this.g, 255 - this.b, 1.0 - this.a);
    }
    /**
     * Averages the current color with another
     * @param color  The other color
     */
    average(color) {
        const newR = (color.r + this.r) / 2;
        const newG = (color.g + this.g) / 2;
        const newB = (color.b + this.b) / 2;
        const newA = (color.a + this.a) / 2;
        return new Color(newR, newG, newB, newA);
    }
    equal(color) {
        return this.toString() === color.toString();
    }
    /**
     * Returns a CSS string representation of a color.
     * @param format Color representation, accepts: rgb, hsl, or hex
     */
    toString(format = 'rgb') {
        switch (format) {
            case 'rgb':
                return this.toRGBA();
            case 'hsl':
                return this.toHSLA();
            case 'hex':
                return this.toHex();
            default:
                throw new Error('Invalid Color format');
        }
    }
    /**
     * Returns Hex Value of a color component
     * @param c color component
     * @see https://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb
     */
    _componentToHex(c) {
        // Handle negative and fractional numbers
        const hex = Math.max(Math.round(c), 0).toString(16);
        return hex.length === 1 ? '0' + hex : hex;
    }
    /**
     * Return Hex representation of a color.
     */
    toHex() {
        let hexRepresentation = '#' + this._componentToHex(this.r) + this._componentToHex(this.g) + this._componentToHex(this.b);
        if (this.a !== 1) {
            hexRepresentation += this._componentToHex(this.a * 255);
        }
        return hexRepresentation;
    }
    /**
     * Return RGBA representation of a color.
     */
    toRGBA() {
        const result = String(this.r.toFixed(0)) + ', ' + String(this.g.toFixed(0)) + ', ' + String(this.b.toFixed(0));
        if (this.a !== undefined || this.a !== null) {
            return 'rgba(' + result + ', ' + String(this.a) + ')';
        }
        return 'rgb(' + result + ')';
    }
    /**
     * Return HSLA representation of a color.
     */
    toHSLA() {
        return HSLColor.fromRGBA(this.r, this.g, this.b, this.a).toString();
    }
    /**
     * Returns a CSS string representation of a color.
     */
    fillStyle() {
        return this.toString();
    }
    /**
     * Returns a clone of the current color.
     */
    clone(dest) {
        const result = dest || new Color(this.r, this.g, this.b, this.a);
        result.r = this.r;
        result.g = this.g;
        result.b = this.b;
        result.a = this.a;
        return result;
    }
    /**
     * Black (#000000)
     */
    static get Black() {
        return Color.fromHex('#000000');
    }
    /**
     * White (#FFFFFF)
     */
    static get White() {
        return Color.fromHex('#FFFFFF');
    }
    /**
     * Gray (#808080)
     */
    static get Gray() {
        return Color.fromHex('#808080');
    }
    /**
     * Light gray (#D3D3D3)
     */
    static get LightGray() {
        return Color.fromHex('#D3D3D3');
    }
    /**
     * Dark gray (#A9A9A9)
     */
    static get DarkGray() {
        return Color.fromHex('#A9A9A9');
    }
    /**
     * Yellow (#FFFF00)
     */
    static get Yellow() {
        return Color.fromHex('#FFFF00');
    }
    /**
     * Orange (#FFA500)
     */
    static get Orange() {
        return Color.fromHex('#FFA500');
    }
    /**
     * Red (#FF0000)
     */
    static get Red() {
        return Color.fromHex('#FF0000');
    }
    /**
     * Vermilion (#FF5B31)
     */
    static get Vermilion() {
        return Color.fromHex('#FF5B31');
    }
    /**
     * Rose (#FF007F)
     */
    static get Rose() {
        return Color.fromHex('#FF007F');
    }
    /**
     * Pink (#FFC0CB)
     */
    static get Pink() {
        return Color.fromHex('#FFC0CB');
    }
    /**
     * Magenta (#FF00FF)
     */
    static get Magenta() {
        return Color.fromHex('#FF00FF');
    }
    /**
     * Violet (#7F00FF)
     */
    static get Violet() {
        return Color.fromHex('#7F00FF');
    }
    /**
     * Purple (#800080)
     */
    static get Purple() {
        return Color.fromHex('#800080');
    }
    /**
     * Blue (#0000FF)
     */
    static get Blue() {
        return Color.fromHex('#0000FF');
    }
    /**
     * Azure (#007FFF)
     */
    static get Azure() {
        return Color.fromHex('#007FFF');
    }
    /**
     * Cyan (#00FFFF)
     */
    static get Cyan() {
        return Color.fromHex('#00FFFF');
    }
    /**
     * Viridian (#59978F)
     */
    static get Viridian() {
        return Color.fromHex('#59978F');
    }
    /**
     * Teal (#008080)
     */
    static get Teal() {
        return Color.fromHex('#008080');
    }
    /**
     * Green (#00FF00)
     */
    static get Green() {
        return Color.fromHex('#00FF00');
    }
    /**
     * Chartreuse (#7FFF00)
     */
    static get Chartreuse() {
        return Color.fromHex('#7FFF00');
    }
    /**
     * Transparent (#FFFFFF00)
     */
    static get Transparent() {
        return Color.fromHex('#FFFFFF00');
    }
    /**
     * ExcaliburBlue (#176BAA)
     */
    static get ExcaliburBlue() {
        return Color.fromHex('#176BAA');
    }
    /**
     * Brown (#964B00)
     */
    static get Brown() {
        return Color.fromHex('#964B00');
    }
}
/**
 * Internal HSL Color representation
 *
 * http://en.wikipedia.org/wiki/HSL_and_HSV
 * http://axonflux.com/handy-rgb-to-hsl-and-rgb-to-hsv-color-model-c
 */
class HSLColor {
    constructor(h, s, l, a) {
        this.h = h;
        this.s = s;
        this.l = l;
        this.a = a;
    }
    static hue2rgb(p, q, t) {
        if (t < 0) {
            t += 1;
        }
        if (t > 1) {
            t -= 1;
        }
        if (t < 1 / 6) {
            return p + (q - p) * 6 * t;
        }
        if (t < 1 / 2) {
            return q;
        }
        if (t < 2 / 3) {
            return p + (q - p) * (2 / 3 - t) * 6;
        }
        return p;
    }
    static fromRGBA(r, g, b, a) {
        r /= 255;
        g /= 255;
        b /= 255;
        const max = Math.max(r, g, b), min = Math.min(r, g, b);
        let h, s;
        const l = (max + min) / 2;
        if (max === min) {
            h = s = 0; // achromatic
        }
        else {
            const d = max - min;
            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
            switch (max) {
                case r:
                    h = (g - b) / d + (g < b ? 6 : 0);
                    break;
                case g:
                    h = (b - r) / d + 2;
                    break;
                case b:
                    h = (r - g) / d + 4;
                    break;
            }
            h /= 6;
        }
        return new HSLColor(h, s, l, a);
    }
    toRGBA() {
        let r, g, b;
        if (this.s === 0) {
            r = g = b = this.l; // achromatic
        }
        else {
            const q = this.l < 0.5 ? this.l * (1 + this.s) : this.l + this.s - this.l * this.s;
            const p = 2 * this.l - q;
            r = HSLColor.hue2rgb(p, q, this.h + 1 / 3);
            g = HSLColor.hue2rgb(p, q, this.h);
            b = HSLColor.hue2rgb(p, q, this.h - 1 / 3);
        }
        return new Color(r * 255, g * 255, b * 255, this.a);
    }
    toString() {
        const h = this.h.toFixed(0), s = this.s.toFixed(0), l = this.l.toFixed(0), a = this.a.toFixed(0);
        return `hsla(${h}, ${s}, ${l}, ${a})`;
    }
}


/***/ }),

/***/ "./Context.ts":
/*!********************!*\
  !*** ./Context.ts ***!
  \********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createContext: () => (/* binding */ createContext),
/* harmony export */   useContext: () => (/* binding */ useContext)
/* harmony export */ });
/**
 * Creates a injectable context that can be retrieved later with `useContext(context)`
 *
 * Example
 * ```typescript
 *
 * const AppContext = createContext({some: 'value'});
 * context.scope(val, () => {
 *    const value = useContext(AppContext);
 * })
 *
 * ```
 */
function createContext() {
    const ctx = {
        scope: (value, cb) => {
            const old = ctx.value;
            ctx.value = value;
            try {
                return cb();
            }
            catch (e) {
                throw e;
            }
            finally {
                ctx.value = old;
            }
        },
        value: undefined
    };
    return ctx;
}
/**
 * Retrieves the value from the current context
 */
function useContext(context) {
    return context.value;
}


/***/ }),

/***/ "./Debug/DebugConfig.ts":
/*!******************************!*\
  !*** ./Debug/DebugConfig.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DebugConfig: () => (/* binding */ DebugConfig),
/* harmony export */   FrameStats: () => (/* binding */ FrameStats),
/* harmony export */   PhysicsStats: () => (/* binding */ PhysicsStats)
/* harmony export */ });
/* harmony import */ var _DebugFlags__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DebugFlags */ "./Debug/DebugFlags.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Color */ "./Color.ts");


/**
 * Debug statistics and flags for Excalibur. If polling these values, it would be
 * best to do so on the `postupdate` event for {@apilink Engine}, after all values have been
 * updated during a frame.
 */
class DebugConfig {
    constructor(engine) {
        /**
         * Performance statistics
         */
        this.stats = {
            /**
             * Current frame statistics. Engine reuses this instance, use {@apilink FrameStats.clone} to copy frame stats.
             * Best accessed on {@apilink postframe} event. See {@apilink FrameStats}
             */
            currFrame: new FrameStats(),
            /**
             * Previous frame statistics. Engine reuses this instance, use {@apilink FrameStats.clone} to copy frame stats.
             * Best accessed on {@apilink preframe} event. Best inspected on engine event `preframe`. See {@apilink FrameStats}
             */
            prevFrame: new FrameStats()
        };
        /**
         * Filter debug context to named entities or entity ids
         */
        this.filter = {
            /**
             * Toggle filter on or off (default off) must be on for DebugDraw to use filters
             */
            useFilter: false,
            /**
             * Query for entities by name, if the entity name contains `nameQuery` it will be included
             */
            nameQuery: '',
            /**
             * Query for Entity ids, if the id matches it will be included
             */
            ids: []
        };
        /**
         * Entity debug settings
         */
        this.entity = {
            showAll: false,
            showId: false,
            showName: false
        };
        /**
         * Transform component debug settings
         */
        this.transform = {
            showAll: false,
            debugZIndex: 10000000,
            showPosition: false,
            showPositionLabel: false,
            positionColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Yellow,
            showZIndex: false,
            showScale: false,
            scaleColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Green,
            showRotation: false,
            rotationColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Blue
        };
        /**
         * Graphics component debug settings
         */
        this.graphics = {
            showAll: false,
            showBounds: false,
            boundsColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Yellow
        };
        /**
         * Collider component debug settings
         */
        this.collider = {
            showAll: false,
            showBounds: false,
            boundsColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Blue,
            showOwner: false,
            showGeometry: true,
            geometryColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Green,
            geometryLineWidth: 1,
            geometryPointSize: 0.5
        };
        /**
         * Physics simulation debug settings
         */
        this.physics = {
            showAll: false,
            showBroadphaseSpacePartitionDebug: false,
            showCollisionNormals: false,
            collisionNormalColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Cyan,
            showCollisionContacts: true,
            contactSize: 2,
            collisionContactColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Red
        };
        /**
         * Motion component debug settings
         */
        this.motion = {
            showAll: false,
            showVelocity: false,
            velocityColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Yellow,
            showAcceleration: false,
            accelerationColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Red
        };
        /**
         * Body component debug settings
         */
        this.body = {
            showAll: false,
            showCollisionGroup: false,
            showCollisionType: false,
            showSleeping: false,
            showMotion: false,
            showMass: false
        };
        /**
         * Camera debug settings
         */
        this.camera = {
            showAll: false,
            showFocus: false,
            focusColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Red,
            showZoom: false
        };
        this.tilemap = {
            showAll: false,
            showGrid: false,
            gridColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Red,
            gridWidth: 0.5,
            showSolidBounds: false,
            solidBoundsColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.fromHex('#8080807F'), // grayish
            showColliderGeometry: true
        };
        this.isometric = {
            showAll: false,
            showPosition: false,
            positionColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Yellow,
            positionSize: 1,
            showGrid: false,
            gridColor: _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Red,
            gridWidth: 1,
            showColliderGeometry: true
        };
        this._engine = engine;
        this.colorBlindMode = new _DebugFlags__WEBPACK_IMPORTED_MODULE_1__.ColorBlindFlags(this._engine);
    }
    /**
     * Switch the current excalibur clock with the {@apilink TestClock} and return
     * it in the same running state.
     *
     * This is useful when you need to debug frame by frame.
     */
    useTestClock() {
        const clock = this._engine.clock;
        const wasRunning = clock.isRunning();
        clock.stop();
        const testClock = clock.toTestClock();
        if (wasRunning) {
            testClock.start();
        }
        this._engine.clock = testClock;
        return testClock;
    }
    /**
     * Switch the current excalibur clock with the {@apilink StandardClock} and
     * return it in the same running state.
     *
     * This is useful when you need to switch back to normal mode after
     * debugging.
     */
    useStandardClock() {
        const currentClock = this._engine.clock;
        const wasRunning = currentClock.isRunning();
        currentClock.stop();
        const standardClock = currentClock.toStandardClock();
        if (wasRunning) {
            standardClock.start();
        }
        this._engine.clock = standardClock;
        return standardClock;
    }
}
/**
 * Implementation of a frame's stats. Meant to have values copied via {@apilink FrameStats.reset}, avoid
 * creating instances of this every frame.
 */
class FrameStats {
    constructor() {
        this._id = 0;
        this._elapsedMs = 0;
        this._fps = 0;
        this._actorStats = {
            alive: 0,
            killed: 0,
            ui: 0,
            get remaining() {
                return this.alive - this.killed;
            },
            get total() {
                return this.remaining + this.ui;
            }
        };
        this._durationStats = {
            update: 0,
            draw: 0,
            get total() {
                return this.update + this.draw;
            }
        };
        this._physicsStats = new PhysicsStats();
        this._graphicsStats = {
            drawCalls: 0,
            drawnImages: 0
        };
    }
    /**
     * Zero out values or clone other IFrameStat stats. Allows instance reuse.
     * @param [otherStats] Optional stats to clone
     */
    reset(otherStats) {
        if (otherStats) {
            this.id = otherStats.id;
            this.elapsedMs = otherStats.elapsedMs;
            this.fps = otherStats.fps;
            this.actors.alive = otherStats.actors.alive;
            this.actors.killed = otherStats.actors.killed;
            this.actors.ui = otherStats.actors.ui;
            this.duration.update = otherStats.duration.update;
            this.duration.draw = otherStats.duration.draw;
            this._physicsStats.reset(otherStats.physics);
            this.graphics.drawCalls = otherStats.graphics.drawCalls;
            this.graphics.drawnImages = otherStats.graphics.drawnImages;
        }
        else {
            this.id = this.elapsedMs = this.fps = 0;
            this.actors.alive = this.actors.killed = this.actors.ui = 0;
            this.duration.update = this.duration.draw = 0;
            this._physicsStats.reset();
            this.graphics.drawnImages = this.graphics.drawCalls = 0;
        }
    }
    /**
     * Provides a clone of this instance.
     */
    clone() {
        const fs = new FrameStats();
        fs.reset(this);
        return fs;
    }
    /**
     * Gets the frame's id
     */
    get id() {
        return this._id;
    }
    /**
     * Sets the frame's id
     */
    set id(value) {
        this._id = value;
    }
    /**
     * Gets the frame's delta (time since last frame)
     */
    get elapsedMs() {
        return this._elapsedMs;
    }
    /**
     * Sets the frame's delta (time since last frame). Internal use only.
     * @internal
     */
    set elapsedMs(value) {
        this._elapsedMs = value;
    }
    /**
     * Gets the frame's frames-per-second (FPS)
     */
    get fps() {
        return this._fps;
    }
    /**
     * Sets the frame's frames-per-second (FPS). Internal use only.
     * @internal
     */
    set fps(value) {
        this._fps = value;
    }
    /**
     * Gets the frame's actor statistics
     */
    get actors() {
        return this._actorStats;
    }
    /**
     * Gets the frame's duration statistics
     */
    get duration() {
        return this._durationStats;
    }
    /**
     * Gets the frame's physics statistics
     */
    get physics() {
        return this._physicsStats;
    }
    /**
     * Gets the frame's graphics statistics
     */
    get graphics() {
        return this._graphicsStats;
    }
}
class PhysicsStats {
    constructor() {
        this._pairs = 0;
        this._collisions = 0;
        this._contacts = new Map();
        this._fastBodies = 0;
        this._fastBodyCollisions = 0;
        this._broadphase = 0;
        this._narrowphase = 0;
    }
    /**
     * Zero out values or clone other IPhysicsStats stats. Allows instance reuse.
     * @param [otherStats] Optional stats to clone
     */
    reset(otherStats) {
        if (otherStats) {
            this.pairs = otherStats.pairs;
            this.collisions = otherStats.collisions;
            this.contacts = otherStats.contacts;
            this.fastBodies = otherStats.fastBodies;
            this.fastBodyCollisions = otherStats.fastBodyCollisions;
            this.broadphase = otherStats.broadphase;
            this.narrowphase = otherStats.narrowphase;
        }
        else {
            this.pairs = this.collisions = this.fastBodies = 0;
            this.fastBodyCollisions = this.broadphase = this.narrowphase = 0;
            this.contacts.clear();
        }
    }
    /**
     * Provides a clone of this instance.
     */
    clone() {
        const ps = new PhysicsStats();
        ps.reset(this);
        return ps;
    }
    get pairs() {
        return this._pairs;
    }
    set pairs(value) {
        this._pairs = value;
    }
    get collisions() {
        return this._collisions;
    }
    set collisions(value) {
        this._collisions = value;
    }
    get contacts() {
        return this._contacts;
    }
    set contacts(contacts) {
        this._contacts = contacts;
    }
    get fastBodies() {
        return this._fastBodies;
    }
    set fastBodies(value) {
        this._fastBodies = value;
    }
    get fastBodyCollisions() {
        return this._fastBodyCollisions;
    }
    set fastBodyCollisions(value) {
        this._fastBodyCollisions = value;
    }
    get broadphase() {
        return this._broadphase;
    }
    set broadphase(value) {
        this._broadphase = value;
    }
    get narrowphase() {
        return this._narrowphase;
    }
    set narrowphase(value) {
        this._narrowphase = value;
    }
}


/***/ }),

/***/ "./Debug/DebugFlags.ts":
/*!*****************************!*\
  !*** ./Debug/DebugFlags.ts ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColorBlindFlags: () => (/* binding */ ColorBlindFlags)
/* harmony export */ });
/* harmony import */ var _Graphics_PostProcessor_ColorBlindnessMode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Graphics/PostProcessor/ColorBlindnessMode */ "./Graphics/PostProcessor/ColorBlindnessMode.ts");
/* harmony import */ var _Graphics_PostProcessor_ColorBlindnessPostProcessor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Graphics/PostProcessor/ColorBlindnessPostProcessor */ "./Graphics/PostProcessor/ColorBlindnessPostProcessor.ts");
/* harmony import */ var _Graphics_Context_ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Graphics/Context/ExcaliburGraphicsContextWebGL */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");



class ColorBlindFlags {
    constructor(engine) {
        this._engine = engine;
        this._colorBlindPostProcessor = new _Graphics_PostProcessor_ColorBlindnessPostProcessor__WEBPACK_IMPORTED_MODULE_0__.ColorBlindnessPostProcessor(_Graphics_PostProcessor_ColorBlindnessMode__WEBPACK_IMPORTED_MODULE_1__.ColorBlindnessMode.Protanope);
    }
    /**
     * Correct colors for a specified color blindness
     * @param colorBlindness
     */
    correct(colorBlindness) {
        if (this._engine.graphicsContext instanceof _Graphics_Context_ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_2__.ExcaliburGraphicsContextWebGL) {
            this.clear();
            this._colorBlindPostProcessor.colorBlindnessMode = colorBlindness;
            this._colorBlindPostProcessor.simulate = false;
            this._engine.graphicsContext.addPostProcessor(this._colorBlindPostProcessor);
        }
    }
    /**
     * Simulate colors for a specified color blindness
     * @param colorBlindness
     */
    simulate(colorBlindness) {
        if (this._engine.graphicsContext instanceof _Graphics_Context_ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_2__.ExcaliburGraphicsContextWebGL) {
            this.clear();
            this._colorBlindPostProcessor.colorBlindnessMode = colorBlindness;
            this._colorBlindPostProcessor.simulate = true;
            this._engine.graphicsContext.addPostProcessor(this._colorBlindPostProcessor);
        }
    }
    /**
     * Remove color blindness post processor
     */
    clear() {
        this._engine.graphicsContext.removePostProcessor(this._colorBlindPostProcessor);
    }
}


/***/ }),

/***/ "./Debug/DebugSystem.ts":
/*!******************************!*\
  !*** ./Debug/DebugSystem.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DebugSystem: () => (/* binding */ DebugSystem)
/* harmony export */ });
/* harmony import */ var _EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../EntityComponentSystem/Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");
/* harmony import */ var _Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Collision/ColliderComponent */ "./Collision/ColliderComponent.ts");
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../EntityComponentSystem */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../EntityComponentSystem */ "./EntityComponentSystem/Priority.ts");
/* harmony import */ var _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EntityComponentSystem/System */ "./EntityComponentSystem/System.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Math/util */ "./Math/util.ts");
/* harmony import */ var _Collision_BodyComponent__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Collision/BodyComponent */ "./Collision/BodyComponent.ts");
/* harmony import */ var _Collision_CollisionSystem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Collision/CollisionSystem */ "./Collision/CollisionSystem.ts");
/* harmony import */ var _Collision_Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Collision/Colliders/CompositeCollider */ "./Collision/Colliders/CompositeCollider.ts");
/* harmony import */ var _Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Graphics/GraphicsComponent */ "./Graphics/GraphicsComponent.ts");
/* harmony import */ var _Particles_Particles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Particles/Particles */ "./Particles/Particles.ts");
/* harmony import */ var _Graphics_DebugGraphicsComponent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Graphics/DebugGraphicsComponent */ "./Graphics/DebugGraphicsComponent.ts");
/* harmony import */ var _Math_coord_plane__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Math/coord-plane */ "./Math/coord-plane.ts");
/* harmony import */ var _Graphics_Debug__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../Graphics/Debug */ "./Graphics/Debug.ts");














class DebugSystem extends _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__.System {
    constructor(world) {
        super();
        this.world = world;
        this.systemType = _EntityComponentSystem_System__WEBPACK_IMPORTED_MODULE_0__.SystemType.Draw;
        this.query = this.world.query([_EntityComponentSystem__WEBPACK_IMPORTED_MODULE_1__.TransformComponent]);
    }
    initialize(world, scene) {
        this._graphicsContext = scene.engine.graphicsContext;
        this._camera = scene.camera;
        this._engine = scene.engine;
        this._collisionSystem = world.systemManager.get(_Collision_CollisionSystem__WEBPACK_IMPORTED_MODULE_2__.CollisionSystem);
    }
    update() {
        var _a;
        if (!this._engine.isDebug) {
            return;
        }
        const filterSettings = this._engine.debug.filter;
        let id;
        let name;
        const entitySettings = this._engine.debug.entity;
        let tx;
        const txSettings = this._engine.debug.transform;
        let motion;
        const motionSettings = this._engine.debug.motion;
        let colliderComp;
        const colliderSettings = this._engine.debug.collider;
        const physicsSettings = this._engine.debug.physics;
        let graphics;
        const graphicsSettings = this._engine.debug.graphics;
        let debugDraw;
        let body;
        const bodySettings = this._engine.debug.body;
        const cameraSettings = this._engine.debug.camera;
        for (let i = 0; i < this.query.entities.length; i++) {
            const entity = this.query.entities[i];
            if (entity.hasTag('offscreen')) {
                // skip offscreen entities
                continue;
            }
            if (entity instanceof _Particles_Particles__WEBPACK_IMPORTED_MODULE_3__.Particle) {
                // Particles crush the renderer :(
                continue;
            }
            if (filterSettings.useFilter) {
                const allIds = filterSettings.ids.length === 0;
                const idMatch = allIds || filterSettings.ids.includes(entity.id);
                if (!idMatch) {
                    continue;
                }
                const allNames = filterSettings.nameQuery === '';
                const nameMatch = allNames || entity.name.includes(filterSettings.nameQuery);
                if (!nameMatch) {
                    continue;
                }
            }
            let cursor = _Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero;
            const lineHeight = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(0, 16);
            id = entity.id;
            name = entity.name;
            tx = entity.get(_EntityComponentSystem__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
            // This optionally sets our camera based on the entity coord plan (world vs. screen)
            this._pushCameraTransform(tx);
            this._graphicsContext.save();
            if (tx.coordPlane === _Math_coord_plane__WEBPACK_IMPORTED_MODULE_5__.CoordPlane.Screen) {
                this._graphicsContext.translate(this._engine.screen.contentArea.left, this._engine.screen.contentArea.top);
            }
            this._graphicsContext.z = txSettings.debugZIndex;
            this._applyTransform(entity);
            if (tx) {
                if (txSettings.showAll || txSettings.showPosition) {
                    this._graphicsContext.debug.drawPoint(_Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero, { size: 4, color: txSettings.positionColor });
                }
                if (txSettings.showAll || txSettings.showPositionLabel) {
                    this._graphicsContext.debug.drawText(`pos${tx.pos.toString(2)}`, cursor);
                    cursor = cursor.add(lineHeight);
                }
                if (txSettings.showAll || txSettings.showZIndex) {
                    this._graphicsContext.debug.drawText(`z(${tx.z.toFixed(1)})`, cursor);
                    cursor = cursor.add(lineHeight);
                }
                if (entitySettings.showAll || entitySettings.showId) {
                    this._graphicsContext.debug.drawText(`id(${id}) ${entity.parent ? 'child of id(' + ((_a = entity.parent) === null || _a === void 0 ? void 0 : _a.id) + ')' : ''}`, cursor);
                    cursor = cursor.add(lineHeight);
                }
                if (entitySettings.showAll || entitySettings.showName) {
                    this._graphicsContext.debug.drawText(`name(${name})`, cursor);
                    cursor = cursor.add(lineHeight);
                }
                if (txSettings.showAll || txSettings.showRotation) {
                    this._graphicsContext.drawLine(_Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero, _Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.fromAngle(tx.rotation).scale(50).add(_Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero), txSettings.rotationColor, 2);
                    this._graphicsContext.debug.drawText(`rot deg(${(0,_Math_util__WEBPACK_IMPORTED_MODULE_6__.toDegrees)(tx.rotation).toFixed(2)})`, cursor);
                    cursor = cursor.add(lineHeight);
                }
                if (txSettings.showAll || txSettings.showScale) {
                    this._graphicsContext.drawLine(_Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero, tx.scale.add(_Math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector.Zero), txSettings.scaleColor, 2);
                }
            }
            graphics = entity.get(_Graphics_GraphicsComponent__WEBPACK_IMPORTED_MODULE_7__.GraphicsComponent);
            if (graphics) {
                if (graphicsSettings.showAll || graphicsSettings.showBounds) {
                    const bounds = graphics.localBounds;
                    bounds.draw(this._graphicsContext, graphicsSettings.boundsColor);
                }
            }
            debugDraw = entity.get(_Graphics_DebugGraphicsComponent__WEBPACK_IMPORTED_MODULE_8__.DebugGraphicsComponent);
            if (debugDraw) {
                if (!debugDraw.useTransform) {
                    this._graphicsContext.restore();
                }
                debugDraw.draw(this._graphicsContext, this._engine.debug);
                if (!debugDraw.useTransform) {
                    this._graphicsContext.save();
                    this._applyTransform(entity);
                }
            }
            body = entity.get(_Collision_BodyComponent__WEBPACK_IMPORTED_MODULE_9__.BodyComponent);
            if (body) {
                if (bodySettings.showAll || bodySettings.showCollisionGroup) {
                    this._graphicsContext.debug.drawText(`collision group(${body.group.name})`, cursor);
                    cursor = cursor.add(lineHeight);
                }
                if (bodySettings.showAll || bodySettings.showCollisionType) {
                    this._graphicsContext.debug.drawText(`collision type(${body.collisionType})`, cursor);
                    cursor = cursor.add(lineHeight);
                }
                if (bodySettings.showAll || bodySettings.showMass) {
                    this._graphicsContext.debug.drawText(`mass(${body.mass})`, cursor);
                    cursor = cursor.add(lineHeight);
                }
                if (bodySettings.showAll || bodySettings.showMotion) {
                    this._graphicsContext.debug.drawText(`motion(${body.sleepMotion})`, cursor);
                    cursor = cursor.add(lineHeight);
                }
                if (bodySettings.showAll || bodySettings.showSleeping) {
                    this._graphicsContext.debug.drawText(`sleeping(${body.canSleep ? body.isSleeping : 'cant sleep'})`, cursor);
                    cursor = cursor.add(lineHeight);
                }
            }
            this._graphicsContext.restore();
            // World space
            this._graphicsContext.save();
            if (tx.coordPlane === _Math_coord_plane__WEBPACK_IMPORTED_MODULE_5__.CoordPlane.Screen) {
                this._graphicsContext.translate(this._engine.screen.contentArea.left, this._engine.screen.contentArea.top);
            }
            this._graphicsContext.z = txSettings.debugZIndex;
            motion = entity.get(_EntityComponentSystem_Components_MotionComponent__WEBPACK_IMPORTED_MODULE_10__.MotionComponent);
            if (motion) {
                if (motionSettings.showAll || motionSettings.showVelocity) {
                    this._graphicsContext.debug.drawText(`vel${motion.vel.toString(2)}`, cursor.add(tx.globalPos));
                    this._graphicsContext.drawLine(tx.globalPos, tx.globalPos.add(motion.vel), motionSettings.velocityColor, 2);
                    cursor = cursor.add(lineHeight);
                }
                if (motionSettings.showAll || motionSettings.showAcceleration) {
                    this._graphicsContext.drawLine(tx.globalPos, tx.globalPos.add(motion.acc), motionSettings.accelerationColor, 2);
                }
            }
            // Colliders live in world space already so after the restore()
            colliderComp = entity.get(_Collision_ColliderComponent__WEBPACK_IMPORTED_MODULE_11__.ColliderComponent);
            if (colliderComp) {
                const collider = colliderComp.get();
                if ((colliderSettings.showAll || colliderSettings.showGeometry) && collider) {
                    collider.debug(this._graphicsContext, colliderSettings.geometryColor, {
                        lineWidth: colliderSettings.geometryLineWidth,
                        pointSize: colliderSettings.geometryPointSize
                    });
                }
                if (colliderSettings.showAll || colliderSettings.showBounds) {
                    if (collider instanceof _Collision_Colliders_CompositeCollider__WEBPACK_IMPORTED_MODULE_12__.CompositeCollider) {
                        const colliders = collider.getColliders();
                        for (const collider of colliders) {
                            const bounds = collider.bounds;
                            const pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(bounds.left, bounds.top);
                            this._graphicsContext.debug.drawRect(pos.x, pos.y, bounds.width, bounds.height, { color: colliderSettings.boundsColor });
                            if (colliderSettings.showAll || colliderSettings.showOwner) {
                                this._graphicsContext.debug.drawText(`owner id(${collider.owner.id})`, pos);
                            }
                        }
                        colliderComp.bounds.draw(this._graphicsContext, colliderSettings.boundsColor);
                    }
                    else if (collider) {
                        const bounds = colliderComp.bounds;
                        const pos = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(bounds.left, bounds.top);
                        this._graphicsContext.debug.drawRect(pos.x, pos.y, bounds.width, bounds.height, { color: colliderSettings.boundsColor });
                        if (colliderSettings.showAll || colliderSettings.showOwner) {
                            this._graphicsContext.debug.drawText(`owner id(${colliderComp.owner.id})`, pos);
                        }
                    }
                }
            }
            this._graphicsContext.restore();
            this._popCameraTransform(tx);
        }
        this._graphicsContext.save();
        this._camera.draw(this._graphicsContext);
        if (physicsSettings.showAll || physicsSettings.showBroadphaseSpacePartitionDebug) {
            this._collisionSystem.debug(this._graphicsContext);
        }
        if (physicsSettings.showAll || physicsSettings.showCollisionContacts || physicsSettings.showCollisionNormals) {
            for (const [_, contact] of this._engine.debug.stats.currFrame.physics.contacts) {
                if (physicsSettings.showAll || physicsSettings.showCollisionContacts) {
                    for (const point of contact.points) {
                        this._graphicsContext.debug.drawPoint(point, {
                            size: physicsSettings.contactSize,
                            color: physicsSettings.collisionContactColor
                        });
                    }
                }
                if (physicsSettings.showAll || physicsSettings.showCollisionNormals) {
                    for (const point of contact.points) {
                        this._graphicsContext.debug.drawLine(point, contact.normal.scale(30).add(point), {
                            color: physicsSettings.collisionNormalColor
                        });
                    }
                }
            }
        }
        this._graphicsContext.restore();
        if (cameraSettings) {
            this._graphicsContext.save();
            this._camera.draw(this._graphicsContext);
            if (cameraSettings.showAll || cameraSettings.showFocus) {
                this._graphicsContext.drawCircle(this._camera.pos, 4, cameraSettings.focusColor);
            }
            if (cameraSettings.showAll || cameraSettings.showZoom) {
                this._graphicsContext.debug.drawText(`zoom(${this._camera.zoom})`, this._camera.pos);
            }
            this._graphicsContext.restore();
        }
        this._graphicsContext.flush();
    }
    postupdate(engine, elapsed) {
        if (this._engine.isDebug) {
            this._graphicsContext.save();
            if (this._camera) {
                this._camera.draw(this._graphicsContext);
            }
            _Graphics_Debug__WEBPACK_IMPORTED_MODULE_13__.Debug.flush(this._graphicsContext);
            this._graphicsContext.restore();
        }
    }
    /**
     * This applies the current entity transform to the graphics context
     * @param entity
     */
    _applyTransform(entity) {
        const ancestors = entity.getAncestors();
        for (const ancestor of ancestors) {
            const transform = ancestor === null || ancestor === void 0 ? void 0 : ancestor.get(_EntityComponentSystem__WEBPACK_IMPORTED_MODULE_1__.TransformComponent);
            if (transform) {
                this._graphicsContext.translate(transform.pos.x, transform.pos.y);
                this._graphicsContext.scale(transform.scale.x, transform.scale.y);
                this._graphicsContext.rotate(transform.rotation);
            }
        }
    }
    /**
     * Applies the current camera transform if in world coordinates
     * @param transform
     */
    _pushCameraTransform(transform) {
        // Establish camera offset per entity
        if (transform.coordPlane === _Math_coord_plane__WEBPACK_IMPORTED_MODULE_5__.CoordPlane.World) {
            this._graphicsContext.save();
            if (this._camera) {
                this._camera.draw(this._graphicsContext);
            }
        }
    }
    /**
     * Resets the current camera transform if in world coordinates
     * @param transform
     */
    _popCameraTransform(transform) {
        if (transform.coordPlane === _Math_coord_plane__WEBPACK_IMPORTED_MODULE_5__.CoordPlane.World) {
            // Apply camera world offset
            this._graphicsContext.restore();
        }
    }
}
DebugSystem.priority = _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_14__.SystemPriority.Lowest;


/***/ }),

/***/ "./Debug/index.ts":
/*!************************!*\
  !*** ./Debug/index.ts ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColorBlindFlags: () => (/* reexport safe */ _DebugFlags__WEBPACK_IMPORTED_MODULE_1__.ColorBlindFlags),
/* harmony export */   DebugConfig: () => (/* reexport safe */ _DebugConfig__WEBPACK_IMPORTED_MODULE_0__.DebugConfig),
/* harmony export */   DebugSystem: () => (/* reexport safe */ _DebugSystem__WEBPACK_IMPORTED_MODULE_2__.DebugSystem),
/* harmony export */   FrameStats: () => (/* reexport safe */ _DebugConfig__WEBPACK_IMPORTED_MODULE_0__.FrameStats),
/* harmony export */   PhysicsStats: () => (/* reexport safe */ _DebugConfig__WEBPACK_IMPORTED_MODULE_0__.PhysicsStats)
/* harmony export */ });
/* harmony import */ var _DebugConfig__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DebugConfig */ "./Debug/DebugConfig.ts");
/* harmony import */ var _DebugFlags__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DebugFlags */ "./Debug/DebugFlags.ts");
/* harmony import */ var _DebugSystem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DebugSystem */ "./Debug/DebugSystem.ts");





/***/ }),

/***/ "./Director/CrossFade.ts":
/*!*******************************!*\
  !*** ./Director/CrossFade.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CrossFade: () => (/* binding */ CrossFade)
/* harmony export */ });
/* harmony import */ var _Graphics__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Graphics */ "./Graphics/ImageSource.ts");
/* harmony import */ var _Transition__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Transition */ "./Director/Transition.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Math/vector */ "./Math/vector.ts");



/**
 * CrossFades between the previous scene and the destination scene
 *
 * Note: CrossFade only works as an "in" transition
 */
class CrossFade extends _Transition__WEBPACK_IMPORTED_MODULE_0__.Transition {
    constructor(options) {
        super({ direction: 'in', ...options }); // default the correct direction
        this.name = `CrossFade#${this.id}`;
    }
    async onPreviousSceneDeactivate(scene) {
        this.image = await scene.engine.screenshot(true);
        // Firefox is particularly slow
        // needed in case the image isn't ready yet
        await this.image.decode();
    }
    onInitialize(engine) {
        this.engine = engine;
        this.transform.pos = engine.screen.unsafeArea.topLeft;
        this.screenCover = _Graphics__WEBPACK_IMPORTED_MODULE_1__.ImageSource.fromHtmlImageElement(this.image).toSprite();
        this.graphics.add(this.screenCover);
        // This is because we preserve hidpi res on the screen shot which COULD be bigger than the logical resolution
        this.transform.scale = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(1 / engine.screen.pixelRatio, 1 / engine.screen.pixelRatio);
        this.graphics.opacity = this.progress;
    }
    onStart(_progress) {
        this.graphics.opacity = this.progress;
    }
    onReset() {
        this.graphics.opacity = this.progress;
    }
    onEnd(progress) {
        this.graphics.opacity = progress;
    }
    onUpdate(progress) {
        this.graphics.opacity = progress;
    }
}


/***/ }),

/***/ "./Director/DefaultLoader.ts":
/*!***********************************!*\
  !*** ./Director/DefaultLoader.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultLoader: () => (/* binding */ DefaultLoader),
/* harmony export */   LoaderEvents: () => (/* binding */ LoaderEvents),
/* harmony export */   isLoaderConstructor: () => (/* binding */ isLoaderConstructor)
/* harmony export */ });
/* harmony import */ var _Util_WebAudio__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Util/WebAudio */ "./Util/WebAudio.ts");
/* harmony import */ var _Graphics_Canvas__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Graphics/Canvas */ "./Graphics/Canvas.ts");
/* harmony import */ var _Graphics_Filtering__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Graphics/Filtering */ "./Graphics/Filtering.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Math/util */ "./Math/util.ts");
/* harmony import */ var _Resources_Sound_Sound__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Resources/Sound/Sound */ "./Resources/Sound/Sound.ts");
/* harmony import */ var _Util_Future__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Util/Future */ "./Util/Future.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EventEmitter */ "./EventEmitter.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Color */ "./Color.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");









const LoaderEvents = {
    // Add event types here
    BeforeLoad: 'beforeload',
    AfterLoad: 'afterload',
    UserAction: 'useraction',
    LoadResourceStart: 'loadresourcestart',
    LoadResourceEnd: 'loadresourceend'
};
/**
 * Returns true if the constructor is for an Excalibur Loader
 */
function isLoaderConstructor(x) {
    var _a, _b;
    return !!(x === null || x === void 0 ? void 0 : x.prototype) && !!((_b = (_a = x === null || x === void 0 ? void 0 : x.prototype) === null || _a === void 0 ? void 0 : _a.constructor) === null || _b === void 0 ? void 0 : _b.name);
}
class DefaultLoader {
    get resources() {
        return this._resources;
    }
    /**
     * @param options Optionally provide the list of resources you want to load at constructor time
     */
    constructor(options) {
        var _a;
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.canvas = new _Graphics_Canvas__WEBPACK_IMPORTED_MODULE_1__.Canvas({
            filtering: _Graphics_Filtering__WEBPACK_IMPORTED_MODULE_2__.ImageFiltering.Blended,
            smoothing: true,
            cache: false,
            draw: this.onDraw.bind(this)
        });
        this._resources = [];
        this._numLoaded = 0;
        this._totalTimeMs = 0;
        this._loadingFuture = new _Util_Future__WEBPACK_IMPORTED_MODULE_3__.Future();
        if (options && ((_a = options.loadables) === null || _a === void 0 ? void 0 : _a.length)) {
            this.addResources(options.loadables);
        }
    }
    /**
     * Called by the engine before loading
     * @param engine
     */
    onInitialize(engine) {
        this.engine = engine;
        this.canvas.width = this.engine.screen.resolution.width;
        this.canvas.height = this.engine.screen.resolution.height;
    }
    /**
     * Return a promise that resolves when the user interacts with the loading screen in some way, usually a click.
     *
     * It's important to implement this in order to unlock the audio context in the browser. Browsers automatically prevent
     * audio from playing until the user performs an action.
     *
     */
    async onUserAction() {
        return await Promise.resolve();
    }
    /**
     * Overridable lifecycle method, called directly before loading starts
     */
    async onBeforeLoad() {
        // override me
    }
    /**
     * Overridable lifecycle method, called after loading has completed
     */
    async onAfterLoad() {
        // override me
        await (0,_Util_Util__WEBPACK_IMPORTED_MODULE_4__.delay)(500, this.engine.clock); // avoid a flicker
    }
    /**
     * Add a resource to the loader to load
     * @param loadable  Resource to add
     */
    addResource(loadable) {
        this._resources.push(loadable);
    }
    /**
     * Add a list of resources to the loader to load
     * @param loadables  The list of resources to load
     */
    addResources(loadables) {
        let i = 0;
        const len = loadables.length;
        for (i; i < len; i++) {
            this.addResource(loadables[i]);
        }
    }
    markResourceComplete() {
        this._numLoaded++;
    }
    /**
     * Returns the progress of the loader as a number between [0, 1] inclusive.
     */
    get progress() {
        const total = this._resources.length;
        return total > 0 ? (0,_Math_util__WEBPACK_IMPORTED_MODULE_5__.clamp)(this._numLoaded, 0, total) / total : 1;
    }
    /**
     * Returns true if the loader has completely loaded all resources
     */
    isLoaded() {
        return this._numLoaded === this._resources.length;
    }
    /**
     * Optionally override the onUpdate
     * @param engine
     * @param elapsed
     */
    onUpdate(engine, elapsed) {
        this._totalTimeMs += elapsed;
        // override me
    }
    /**
     * Optionally override the onDraw
     */
    onDraw(ctx) {
        const seconds = this._totalTimeMs / 1000;
        ctx.fillStyle = _Color__WEBPACK_IMPORTED_MODULE_6__.Color.Black.toRGBA();
        ctx.fillRect(0, 0, this.engine.screen.resolution.width, this.engine.screen.resolution.height);
        ctx.save();
        ctx.translate(this.engine.screen.resolution.width / 2, this.engine.screen.resolution.height / 2);
        const speed = seconds * 10;
        ctx.strokeStyle = 'white';
        ctx.lineWidth = 10;
        ctx.lineCap = 'round';
        ctx.arc(0, 0, 40, speed, speed + (Math.PI * 3) / 2);
        ctx.stroke();
        ctx.fillStyle = 'white';
        ctx.font = '16px sans-serif';
        const text = (this.progress * 100).toFixed(0) + '%';
        const textbox = ctx.measureText(text);
        const width = Math.abs(textbox.actualBoundingBoxLeft) + Math.abs(textbox.actualBoundingBoxRight);
        const height = Math.abs(textbox.actualBoundingBoxAscent) + Math.abs(textbox.actualBoundingBoxDescent);
        ctx.fillText(text, -width / 2, height / 2); // center
        ctx.restore();
    }
    areResourcesLoaded() {
        if (this._resources.length === 0) {
            // special case no resources mean loaded;
            return Promise.resolve();
        }
        return this._loadingFuture.promise;
    }
    /**
     * Not meant to be overridden
     *
     * Begin loading all of the supplied resources, returning a promise
     * that resolves when loading of all is complete AND the user has interacted with the loading screen
     */
    async load() {
        await this.onBeforeLoad();
        this.events.emit('beforeload');
        this.canvas.flagDirty();
        await Promise.all(this._resources.map(async (r) => {
            this.events.emit('loadresourcestart', r);
            await r.load().finally(() => {
                // capture progress
                this._numLoaded++;
                this.canvas.flagDirty();
                this.events.emit('loadresourceend', r);
            });
        }));
        // Wire all sound to the engine
        for (const resource of this._resources) {
            if (resource instanceof _Resources_Sound_Sound__WEBPACK_IMPORTED_MODULE_7__.Sound) {
                resource.wireEngine(this.engine);
            }
        }
        this._loadingFuture.resolve();
        this.canvas.flagDirty();
        // Unlock browser AudioContext in after user gesture
        // See: https://github.com/excaliburjs/Excalibur/issues/262
        // See: https://github.com/excaliburjs/Excalibur/issues/1031
        await this.onUserAction();
        this.events.emit('useraction');
        await _Util_WebAudio__WEBPACK_IMPORTED_MODULE_8__.WebAudio.unlock();
        await this.onAfterLoad();
        this.events.emit('afterload');
        return (this.data = this._resources);
    }
    emit(eventName, event) {
        this.events.emit(eventName, event);
    }
    on(eventName, handler) {
        return this.events.on(eventName, handler);
    }
    once(eventName, handler) {
        return this.events.once(eventName, handler);
    }
    off(eventName, handler) {
        this.events.off(eventName, handler);
    }
}


/***/ }),

/***/ "./Director/Director.ts":
/*!******************************!*\
  !*** ./Director/Director.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Director: () => (/* binding */ Director),
/* harmony export */   DirectorEvents: () => (/* binding */ DirectorEvents)
/* harmony export */ });
/* harmony import */ var _DefaultLoader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DefaultLoader */ "./Director/DefaultLoader.ts");
/* harmony import */ var _Scene__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Scene */ "./Scene.ts");
/* harmony import */ var _Loader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Loader */ "./Director/Loader.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Events */ "./Events.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EventEmitter */ "./EventEmitter.ts");






const DirectorEvents = {
    NavigationStart: 'navigationstart',
    Navigation: 'navigation',
    NavigationEnd: 'navigationend'
};
/**
 * The Director is responsible for managing scenes and changing scenes in Excalibur.
 *
 * It deals with transitions, scene loaders, switching scenes
 *
 * This is used internally by Excalibur, generally not mean to
 * be instantiated end users directly.
 */
class Director {
    /**
     * Gets whether the director currently transitioning between scenes
     *
     * Useful if you need to block behavior during transition
     */
    get isTransitioning() {
        return this._isTransitioning;
    }
    constructor(_engine, scenes) {
        this._engine = _engine;
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_1__.Logger.getInstance();
        this._initialized = false;
        /**
         * All registered scenes in Excalibur
         */
        this.scenes = {};
        /**
         * Holds all instantiated scenes
         */
        this._sceneToInstance = new Map();
        this._sceneToLoader = new Map();
        this._sceneToTransition = new Map();
        /**
         * Used to keep track of scenes that have already been loaded so we don't load multiple times
         */
        this._loadedScenes = new Set();
        this._isTransitioning = false;
        this.rootScene = this.currentScene = new _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene();
        this.add('root', this.rootScene);
        this.currentScene = this.rootScene;
        this.currentSceneName = 'root';
        for (const sceneKey in scenes) {
            const sceneOrOptions = scenes[sceneKey];
            this.add(sceneKey, sceneOrOptions);
            if (sceneKey === 'root') {
                this.rootScene = this.getSceneInstance('root'); // always a root scene
                this.currentScene = this.rootScene;
            }
        }
    }
    /**
     * Initialize the director's internal state
     */
    async onInitialize() {
        if (!this._initialized) {
            this._initialized = true;
            if (this._deferredGoto) {
                const deferredScene = this._deferredGoto;
                this._deferredGoto = undefined;
                const deferredTransition = this._deferredTransition;
                this._deferredTransition = undefined;
                const deferredSceneInstance = this.getSceneInstance(deferredScene);
                if (deferredSceneInstance && deferredTransition) {
                    deferredTransition._addToTargetScene(this._engine, deferredSceneInstance);
                }
                await this.swapScene(deferredScene);
                if (deferredSceneInstance && deferredTransition) {
                    await this.playTransition(deferredTransition, deferredSceneInstance);
                }
            }
            else {
                await this.swapScene('root');
            }
        }
    }
    get isInitialized() {
        return this._initialized;
    }
    /**
     * Configures the start scene, and optionally the transition & loader for the director
     *
     * Typically this is called at the beginning of the game to the start scene and transition and never again.
     * @param startScene
     * @param options
     */
    configureStart(startScene, options) {
        const maybeLoaderOrCtor = options === null || options === void 0 ? void 0 : options.loader;
        if (maybeLoaderOrCtor instanceof _DefaultLoader__WEBPACK_IMPORTED_MODULE_3__.DefaultLoader) {
            this.mainLoader = maybeLoaderOrCtor;
        }
        else if ((0,_DefaultLoader__WEBPACK_IMPORTED_MODULE_3__.isLoaderConstructor)(maybeLoaderOrCtor)) {
            this.mainLoader = new maybeLoaderOrCtor();
        }
        else {
            this.mainLoader = new _Loader__WEBPACK_IMPORTED_MODULE_4__.Loader();
        }
        let maybeStartTransition;
        if (options === null || options === void 0 ? void 0 : options.inTransition) {
            const { inTransition } = options;
            maybeStartTransition = inTransition;
        }
        this.startScene = startScene;
        // Fire and forget promise for the initial scene
        if (maybeStartTransition) {
            const startSceneInstance = this.getSceneInstance(this.startScene);
            if (startSceneInstance) {
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                maybeStartTransition._addToTargetScene(this._engine, startSceneInstance);
                this.swapScene(this.startScene).then(() => {
                    startSceneInstance.onTransition('in');
                    // eslint-disable-next-line @typescript-eslint/no-floating-promises
                    return this.playTransition(maybeStartTransition, startSceneInstance);
                });
            }
        }
        else {
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            this.swapScene(this.startScene);
        }
        this.currentSceneName = this.startScene;
    }
    _getLoader(sceneName) {
        return this._sceneToLoader.get(sceneName);
    }
    _getInTransition(sceneName) {
        var _a;
        const sceneOrRoute = this.scenes[sceneName];
        if (sceneOrRoute instanceof _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene || (0,_Scene__WEBPACK_IMPORTED_MODULE_2__.isSceneConstructor)(sceneOrRoute)) {
            return undefined;
        }
        return (_a = sceneOrRoute === null || sceneOrRoute === void 0 ? void 0 : sceneOrRoute.transitions) === null || _a === void 0 ? void 0 : _a.in;
    }
    _getOutTransition(sceneName) {
        var _a;
        const sceneOrRoute = this.scenes[sceneName];
        if (sceneOrRoute instanceof _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene || (0,_Scene__WEBPACK_IMPORTED_MODULE_2__.isSceneConstructor)(sceneOrRoute)) {
            return undefined;
        }
        return (_a = sceneOrRoute === null || sceneOrRoute === void 0 ? void 0 : sceneOrRoute.transitions) === null || _a === void 0 ? void 0 : _a.out;
    }
    getDeferredScene() {
        const maybeDeferred = this.getSceneDefinition(this._deferredGoto);
        if (this._deferredGoto && maybeDeferred) {
            return maybeDeferred;
        }
        return null;
    }
    /**
     * Returns a scene by name if it exists, might be the constructor and not the instance of a scene
     * @param name
     */
    getSceneDefinition(name) {
        const maybeScene = this.scenes[name];
        if (maybeScene instanceof _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene || (0,_Scene__WEBPACK_IMPORTED_MODULE_2__.isSceneConstructor)(maybeScene)) {
            return maybeScene;
        }
        else if (maybeScene) {
            return maybeScene.scene;
        }
        return undefined;
    }
    /**
     * Returns the name of the registered scene, null if none can be found
     * @param scene
     */
    getSceneName(scene) {
        for (const [name, maybeScene] of Object.entries(this.scenes)) {
            if (maybeScene instanceof _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene) {
                if (scene === maybeScene) {
                    return name;
                }
            }
            else if (!(0,_Scene__WEBPACK_IMPORTED_MODULE_2__.isSceneConstructor)(maybeScene)) {
                if (scene === maybeScene.scene) {
                    return name;
                }
            }
        }
        for (const [name, maybeScene] of Object.entries(this.scenes)) {
            if ((0,_Scene__WEBPACK_IMPORTED_MODULE_2__.isSceneConstructor)(maybeScene)) {
                if (scene.constructor === maybeScene) {
                    return name;
                }
            }
            else if (!(maybeScene instanceof _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene)) {
                if (scene.constructor === maybeScene.scene) {
                    return name;
                }
            }
        }
        return null;
    }
    /**
     * Returns the same Director, but asserts a scene DOES exist to the type system
     * @param name
     */
    assertAdded(name) {
        return this;
    }
    /**
     * Returns the same Director, but asserts a scene DOES NOT exist to the type system
     * @param name
     */
    assertRemoved(name) {
        return this;
    }
    /**
     * Adds additional Scenes to the game!
     * @param name
     * @param sceneOrRoute
     */
    add(name, sceneOrRoute) {
        if (!(sceneOrRoute instanceof _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene) && !(0,_Scene__WEBPACK_IMPORTED_MODULE_2__.isSceneConstructor)(sceneOrRoute)) {
            const { loader, transitions } = sceneOrRoute;
            const { in: inTransition, out: outTransition } = transitions !== null && transitions !== void 0 ? transitions : {};
            this._sceneToTransition.set(name, { in: inTransition, out: outTransition });
            if ((0,_DefaultLoader__WEBPACK_IMPORTED_MODULE_3__.isLoaderConstructor)(loader)) {
                this._sceneToLoader.set(name, new loader());
            }
            else if (loader) {
                this._sceneToLoader.set(name, loader);
            }
        }
        if (this.scenes[name]) {
            this._logger.warn('Scene', name, 'already exists overwriting');
        }
        this.scenes[name] = sceneOrRoute;
        return this.assertAdded(name);
    }
    remove(nameOrScene) {
        if (nameOrScene instanceof _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene || (0,_Scene__WEBPACK_IMPORTED_MODULE_2__.isSceneConstructor)(nameOrScene)) {
            const sceneOrCtor = nameOrScene;
            // remove scene
            for (const key in this.scenes) {
                if (this.scenes.hasOwnProperty(key)) {
                    const potentialSceneOrOptions = this.scenes[key];
                    let scene;
                    if (potentialSceneOrOptions instanceof _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene || (0,_Scene__WEBPACK_IMPORTED_MODULE_2__.isSceneConstructor)(potentialSceneOrOptions)) {
                        scene = potentialSceneOrOptions;
                    }
                    else {
                        scene = potentialSceneOrOptions.scene;
                    }
                    if (scene === sceneOrCtor) {
                        if (key === this.currentSceneName) {
                            throw new Error(`Cannot remove a currently active scene: ${key}`);
                        }
                        this._sceneToInstance.delete(key);
                        this._sceneToTransition.delete(key);
                        this._sceneToLoader.delete(key);
                        delete this.scenes[key];
                    }
                }
            }
        }
        if (typeof nameOrScene === 'string') {
            if (nameOrScene === this.currentSceneName) {
                throw new Error(`Cannot remove a currently active scene: ${nameOrScene}`);
            }
            // remove scene
            this._sceneToInstance.delete(nameOrScene);
            this._sceneToTransition.delete(nameOrScene);
            this._sceneToLoader.delete(nameOrScene);
            delete this.scenes[nameOrScene];
        }
    }
    /**
     * Go to a specific scene, and optionally override loaders and transitions
     * @param destinationScene
     * @param options
     */
    async goToScene(destinationScene, options) {
        var _a, _b, _c, _d, _e, _f;
        const maybeDest = this.getSceneInstance(destinationScene);
        if (!maybeDest) {
            this._logger.warn(`Scene ${destinationScene} does not exist! Check the name, are you sure you added it?`);
            return;
        }
        const sourceSceneInstance = this.currentScene;
        const sourceScene = this.currentSceneName;
        const engineInputEnabled = (_b = (_a = this._engine.input) === null || _a === void 0 ? void 0 : _a.enabled) !== null && _b !== void 0 ? _b : true;
        this._isTransitioning = true;
        const maybeSourceOut = (_c = this.getSceneInstance(sourceScene)) === null || _c === void 0 ? void 0 : _c.onTransition('out');
        const maybeDestinationIn = maybeDest === null || maybeDest === void 0 ? void 0 : maybeDest.onTransition('in');
        options = {
            // Engine configuration then dynamic scene transitions
            ...{ sourceOut: (_d = this._getOutTransition(this.currentSceneName)) !== null && _d !== void 0 ? _d : maybeSourceOut },
            ...{ destinationIn: (_e = this._getInTransition(destinationScene)) !== null && _e !== void 0 ? _e : maybeDestinationIn },
            // Goto options
            ...options
        };
        const { sourceOut, destinationIn, sceneActivationData } = options;
        const outTransition = sourceOut !== null && sourceOut !== void 0 ? sourceOut : this._getOutTransition(this.currentSceneName);
        const inTransition = destinationIn !== null && destinationIn !== void 0 ? destinationIn : this._getInTransition(destinationScene);
        const hideLoader = (outTransition === null || outTransition === void 0 ? void 0 : outTransition.hideLoader) || (inTransition === null || inTransition === void 0 ? void 0 : inTransition.hideLoader);
        if (hideLoader) {
            // Start hidden loader early and take advantage of the transition
            // Don't await and block on a hidden loader
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            this.maybeLoadScene(destinationScene, hideLoader);
        }
        this._emitEvent('navigationstart', sourceScene, destinationScene);
        // Run the out transition on the current scene if present
        if (outTransition) {
            await this.playTransition(outTransition, sourceSceneInstance);
        }
        // Run the loader if present
        await this.maybeLoadScene(destinationScene, hideLoader);
        // Give incoming transition a chance to grab info from previous
        if (inTransition) {
            await inTransition.onPreviousSceneDeactivate(this.currentScene);
        }
        // Setup the in transition on the destination scene if present
        // this is important to it can be initialized with the
        if (inTransition) {
            inTransition._addToTargetScene(this._engine, maybeDest);
        }
        // Swap to the new scene
        // Runs scene lifecycle init and activate
        await this.swapScene(destinationScene, sceneActivationData);
        this._emitEvent('navigation', sourceScene, destinationScene);
        // Run the in transition on the new scene if present
        if (inTransition) {
            await this.playTransition(inTransition, maybeDest);
        }
        this._emitEvent('navigationend', sourceScene, destinationScene);
        (_f = this._engine.input) === null || _f === void 0 ? void 0 : _f.toggleEnabled(engineInputEnabled);
        this._isTransitioning = false;
    }
    /**
     * Retrieves a scene instance by key if it's registered.
     *
     * This will call any constructors that were given as a definition
     * @param scene
     */
    getSceneInstance(scene) {
        const sceneDefinition = this.getSceneDefinition(scene);
        if (!sceneDefinition) {
            return undefined;
        }
        if (this._sceneToInstance.has(scene)) {
            return this._sceneToInstance.get(scene);
        }
        if (sceneDefinition instanceof _Scene__WEBPACK_IMPORTED_MODULE_2__.Scene) {
            this._sceneToInstance.set(scene, sceneDefinition);
            return sceneDefinition;
        }
        const newScene = new sceneDefinition();
        this._sceneToInstance.set(scene, newScene);
        return newScene;
    }
    /**
     * Triggers scene loading if has not already been loaded
     * @param scene
     * @param hideLoader
     */
    async maybeLoadScene(scene, hideLoader = false) {
        var _a;
        const loader = (_a = this._getLoader(scene)) !== null && _a !== void 0 ? _a : new _DefaultLoader__WEBPACK_IMPORTED_MODULE_3__.DefaultLoader();
        const sceneToLoad = this.getSceneDefinition(scene);
        const sceneToLoadInstance = this.getSceneInstance(scene);
        if (sceneToLoad && sceneToLoadInstance && !this._loadedScenes.has(sceneToLoadInstance)) {
            sceneToLoadInstance.onPreLoad(loader);
            sceneToLoadInstance.events.emit('preload', { loader });
            if (hideLoader) {
                // Don't await a hidden loader
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                this._engine.load(loader, hideLoader);
            }
            else {
                await this._engine.load(loader);
            }
            this._loadedScenes.add(sceneToLoadInstance);
        }
    }
    /**
     * Plays a transition in the current scene and does book keeping for input.
     * @param transition
     */
    async playTransition(transition, targetScene) {
        var _a, _b, _c, _d, _e, _f, _g;
        if (!this.isInitialized) {
            this._deferredTransition = transition;
            return;
        }
        if (transition) {
            this.currentTransition = transition;
            const sceneInputEnabled = (_b = (_a = targetScene.input) === null || _a === void 0 ? void 0 : _a.enabled) !== null && _b !== void 0 ? _b : true;
            (_c = targetScene.input) === null || _c === void 0 ? void 0 : _c.toggleEnabled(!transition.blockInput);
            (_d = this._engine.input) === null || _d === void 0 ? void 0 : _d.toggleEnabled(!transition.blockInput);
            targetScene.events.emit('transitionstart', transition);
            this.currentTransition._addToTargetScene(this._engine, targetScene);
            await this.currentTransition._play();
            targetScene.events.emit('transitionend', transition);
            (_e = targetScene.input) === null || _e === void 0 ? void 0 : _e.toggleEnabled(sceneInputEnabled);
        }
        (_f = this.currentTransition) === null || _f === void 0 ? void 0 : _f.kill();
        (_g = this.currentTransition) === null || _g === void 0 ? void 0 : _g.reset();
        this.currentTransition = undefined;
    }
    /**
     * Swaps the current and destination scene after performing required lifecycle events
     * @param destinationScene
     * @param data
     */
    async swapScene(destinationScene, data) {
        const engine = this._engine;
        // if not yet initialized defer goToScene
        if (!this.isInitialized) {
            this._deferredGoto = destinationScene;
            return;
        }
        const maybeDest = this.getSceneInstance(destinationScene);
        if (maybeDest) {
            const previousScene = this.currentScene;
            const nextScene = maybeDest;
            this._logger.debug('Going to scene:', destinationScene);
            // only deactivate when initialized
            if (this.currentScene.isInitialized) {
                const context = { engine, previousScene, nextScene };
                await this.currentScene._deactivate(context);
                this.currentScene.events.emit('deactivate', new _Events__WEBPACK_IMPORTED_MODULE_5__.DeactivateEvent(context, this.currentScene));
                this.currentScene.input.clear();
            }
            // wait for the scene to be loaded if needed
            const destLoader = this._sceneToLoader.get(destinationScene);
            await (destLoader === null || destLoader === void 0 ? void 0 : destLoader.areResourcesLoaded());
            // set current scene to new one
            this.currentScene = nextScene;
            this.currentSceneName = destinationScene;
            engine.screen.setCurrentCamera(nextScene.camera);
            // initialize the current scene if has not been already
            await this.currentScene._initialize(engine);
            const context = { engine, previousScene, nextScene, data };
            await this.currentScene._activate(context);
            this.currentScene.events.emit('activate', new _Events__WEBPACK_IMPORTED_MODULE_5__.ActivateEvent(context, this.currentScene));
        }
        else {
            this._logger.error('Scene', destinationScene, 'does not exist!');
        }
    }
    _emitEvent(eventName, sourceScene, destinationScene) {
        const source = this.getSceneDefinition(sourceScene);
        const dest = this.getSceneDefinition(destinationScene);
        this.events.emit(eventName, {
            sourceScene: source,
            sourceName: sourceScene,
            destinationScene: dest,
            destinationName: destinationScene
        });
    }
}


/***/ }),

/***/ "./Director/FadeInOut.ts":
/*!*******************************!*\
  !*** ./Director/FadeInOut.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FadeInOut: () => (/* binding */ FadeInOut)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Color */ "./Color.ts");
/* harmony import */ var _Graphics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Graphics */ "./Graphics/Rectangle.ts");
/* harmony import */ var _Transition__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Transition */ "./Director/Transition.ts");



class FadeInOut extends _Transition__WEBPACK_IMPORTED_MODULE_0__.Transition {
    constructor(options) {
        var _a, _b;
        super({
            ...options,
            duration: (_a = options.duration) !== null && _a !== void 0 ? _a : 2000
        });
        this.name = `FadeInOut#${this.id}`;
        this.color = (_b = options.color) !== null && _b !== void 0 ? _b : _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Black;
    }
    onInitialize(engine) {
        this.transform.pos = engine.screen.unsafeArea.topLeft;
        this.screenCover = new _Graphics__WEBPACK_IMPORTED_MODULE_2__.Rectangle({
            width: engine.screen.resolution.width,
            height: engine.screen.resolution.height,
            color: this.color
        });
        this.graphics.add(this.screenCover);
        this.graphics.opacity = this.progress;
    }
    onReset() {
        this.graphics.opacity = this.progress;
    }
    onStart(progress) {
        this.graphics.opacity = progress;
    }
    onEnd(progress) {
        this.graphics.opacity = progress;
    }
    onUpdate(progress) {
        this.graphics.opacity = progress;
    }
}


/***/ }),

/***/ "./Director/Loader.css":
/*!*****************************!*\
  !*** ./Director/Loader.css ***!
  \*****************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/* Buttons styles start */

button#excalibur-play {
  display: inline-block;
  position: relative;
  z-index: 999;
  border-radius: 6px;
  border: none;
  /*border: 3px solid;
    border-color: white;
    box-shadow: 0 0 10px #ccc;*/
  padding: 1rem 1.5rem 1rem 4rem;
  margin: 0;
  text-decoration: none;
  background: #00b233;
  color: #ffffff;
  font-family: sans-serif;
  font-size: 2rem;
  white-space: nowrap;
  line-height: 1;
  cursor: pointer;
  text-align: center;
  transition:
    background 250ms ease-in-out,
    transform 150ms ease;
  -webkit-appearance: none;
  -moz-appearance: none;

  -webkit-animation: excalibur-button-fadein 200ms; /* Safari, Chrome and Opera > 12.1 */
  -moz-animation: excalibur-button-fadein 200ms; /* Firefox < 16 */
  -ms-animation: excalibur-button-fadein 200ms; /* Internet Explorer */
  -o-animation: excalibur-button-fadein 200ms; /* Opera < 12.1 */
  animation: excalibur-button-fadein 200ms;
}

/*
button#excalibur-play {
  display: none;
}*/

button#excalibur-play:after {
  position: absolute;
  content: '';
  border: 8px solid;
  border-color: transparent transparent transparent white;
  left: 35px;
  top: 24px;
  width: 0;
  height: 0;
}

button#excalibur-play:before {
  position: absolute;
  content: '';
  border: 3px solid;
  left: 19px;
  top: 14px;
  border-radius: 20px;
  width: 30px;
  height: 30px;
}

button#excalibur-play:hover,
button#excalibur-play:focus {
  background: #00982c;
}

button#excalibur-play:focus {
  outline: 1px solid #fff;
  outline-offset: -4px;
}

button#excalibur-play:active {
  transform: scale(0.99);
}

@keyframes excalibur-button-fadein {
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
}

/* Firefox < 16 */
@-moz-keyframes excalibur-button-fadein {
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
}

/* Safari, Chrome and Opera > 12.1 */
@-webkit-keyframes excalibur-button-fadein {
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
}

/* Internet Explorer */
@-ms-keyframes excalibur-button-fadein {
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
}

/* Opera < 12.1 */
@-o-keyframes excalibur-button-fadein {
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
}
`, "",{"version":3,"sources":["webpack://./Director/Loader.css"],"names":[],"mappings":"AAAA,yBAAyB;;AAEzB;EACE,qBAAqB;EACrB,kBAAkB;EAClB,YAAY;EACZ,kBAAkB;EAClB,YAAY;EACZ;;+BAE6B;EAC7B,8BAA8B;EAC9B,SAAS;EACT,qBAAqB;EACrB,mBAAmB;EACnB,cAAc;EACd,uBAAuB;EACvB,eAAe;EACf,mBAAmB;EACnB,cAAc;EACd,eAAe;EACf,kBAAkB;EAClB;;wBAEsB;EACtB,wBAAwB;EACxB,qBAAqB;;EAErB,gDAAgD,EAAE,oCAAoC;EACtF,6CAA6C,EAAE,iBAAiB;EAChE,4CAA4C,EAAE,sBAAsB;EACpE,2CAA2C,EAAE,iBAAiB;EAC9D,wCAAwC;AAC1C;;AAEA;;;EAGE;;AAEF;EACE,kBAAkB;EAClB,WAAW;EACX,iBAAiB;EACjB,uDAAuD;EACvD,UAAU;EACV,SAAS;EACT,QAAQ;EACR,SAAS;AACX;;AAEA;EACE,kBAAkB;EAClB,WAAW;EACX,iBAAiB;EACjB,UAAU;EACV,SAAS;EACT,mBAAmB;EACnB,WAAW;EACX,YAAY;AACd;;AAEA;;EAEE,mBAAmB;AACrB;;AAEA;EACE,uBAAuB;EACvB,oBAAoB;AACtB;;AAEA;EACE,sBAAsB;AACxB;;AAEA;EACE;IACE,UAAU;EACZ;EACA;IACE,UAAU;EACZ;AACF;;AAEA,iBAAiB;AACjB;EACE;IACE,UAAU;EACZ;EACA;IACE,UAAU;EACZ;AACF;;AAEA,oCAAoC;AACpC;EACE;IACE,UAAU;EACZ;EACA;IACE,UAAU;EACZ;AACF;;AAEA,sBAAsB;AACtB;EACE;IACE,UAAU;EACZ;EACA;IACE,UAAU;EACZ;AACF;;AAEA,iBAAiB;AACjB;EACE;IACE,UAAU;EACZ;EACA;IACE,UAAU;EACZ;AACF","sourcesContent":["/* Buttons styles start */\n\nbutton#excalibur-play {\n  display: inline-block;\n  position: relative;\n  z-index: 999;\n  border-radius: 6px;\n  border: none;\n  /*border: 3px solid;\n    border-color: white;\n    box-shadow: 0 0 10px #ccc;*/\n  padding: 1rem 1.5rem 1rem 4rem;\n  margin: 0;\n  text-decoration: none;\n  background: #00b233;\n  color: #ffffff;\n  font-family: sans-serif;\n  font-size: 2rem;\n  white-space: nowrap;\n  line-height: 1;\n  cursor: pointer;\n  text-align: center;\n  transition:\n    background 250ms ease-in-out,\n    transform 150ms ease;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n\n  -webkit-animation: excalibur-button-fadein 200ms; /* Safari, Chrome and Opera > 12.1 */\n  -moz-animation: excalibur-button-fadein 200ms; /* Firefox < 16 */\n  -ms-animation: excalibur-button-fadein 200ms; /* Internet Explorer */\n  -o-animation: excalibur-button-fadein 200ms; /* Opera < 12.1 */\n  animation: excalibur-button-fadein 200ms;\n}\n\n/*\nbutton#excalibur-play {\n  display: none;\n}*/\n\nbutton#excalibur-play:after {\n  position: absolute;\n  content: '';\n  border: 8px solid;\n  border-color: transparent transparent transparent white;\n  left: 35px;\n  top: 24px;\n  width: 0;\n  height: 0;\n}\n\nbutton#excalibur-play:before {\n  position: absolute;\n  content: '';\n  border: 3px solid;\n  left: 19px;\n  top: 14px;\n  border-radius: 20px;\n  width: 30px;\n  height: 30px;\n}\n\nbutton#excalibur-play:hover,\nbutton#excalibur-play:focus {\n  background: #00982c;\n}\n\nbutton#excalibur-play:focus {\n  outline: 1px solid #fff;\n  outline-offset: -4px;\n}\n\nbutton#excalibur-play:active {\n  transform: scale(0.99);\n}\n\n@keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n/* Firefox < 16 */\n@-moz-keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n/* Safari, Chrome and Opera > 12.1 */\n@-webkit-keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n/* Internet Explorer */\n@-ms-keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n/* Opera < 12.1 */\n@-o-keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./Director/Loader.logo.png":
/*!**********************************!*\
  !*** ./Director/Loader.logo.png ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/png;base64,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");

/***/ }),

/***/ "./Director/Loader.ts":
/*!****************************!*\
  !*** ./Director/Loader.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Loader: () => (/* binding */ Loader)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Color */ "./Color.ts");
/* harmony import */ var _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Util/DrawUtil */ "./Util/DrawUtil.ts");
/* harmony import */ var _Loader_logo_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Loader.logo.png */ "./Director/Loader.logo.png");
/* harmony import */ var _Loader_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Loader.css */ "./Director/Loader.css");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../EventEmitter */ "./EventEmitter.ts");
/* harmony import */ var _DefaultLoader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DefaultLoader */ "./Director/DefaultLoader.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Util_Future__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Util/Future */ "./Util/Future.ts");









/**
 * Pre-loading assets
 *
 * The loader provides a mechanism to preload multiple resources at
 * one time. The loader must be passed to the engine in order to
 * trigger the loading progress bar.
 *
 * The {@apilink Loader} itself implements {@apilink Loadable} so you can load loaders.
 *
 * ## Example: Pre-loading resources for a game
 *
 * ```js
 * // create a loader
 * var loader = new ex.Loader();
 *
 * // create a resource dictionary (best practice is to keep a separate file)
 * var resources = {
 *   TextureGround: new ex.Texture("/images/textures/ground.png"),
 *   SoundDeath: new ex.Sound("/sound/death.wav", "/sound/death.mp3")
 * };
 *
 * // loop through dictionary and add to loader
 * for (var loadable in resources) {
 *   if (resources.hasOwnProperty(loadable)) {
 *     loader.addResource(resources[loadable]);
 *   }
 * }
 *
 * // start game
 * game.start(loader).then(function () {
 *   console.log("Game started!");
 * });
 * ```
 *
 * ## Customize the Loader
 *
 * The loader can be customized to show different, text, logo, background color, and button.
 *
 * ```typescript
 * const loader = new ex.Loader([playerTexture]);
 *
 * // The loaders button text can simply modified using this
 * loader.playButtonText = 'Start the best game ever';
 *
 * // The logo can be changed by inserting a base64 image string here
 *
 * loader.logo = 'data:image/png;base64,iVBORw...';
 * loader.logoWidth = 15;
 * loader.logoHeight = 14;
 *
 * // The background color can be changed like so by supplying a valid CSS color string
 *
 * loader.backgroundColor = 'red'
 * loader.backgroundColor = '#176BAA'
 *
 * // To build a completely new button
 * loader.startButtonFactory = () => {
 *     let myButton = document.createElement('button');
 *     myButton.textContent = 'The best button';
 *     return myButton;
 * };
 *
 * engine.start(loader).then(() => {});
 * ```
 */
class Loader extends _DefaultLoader__WEBPACK_IMPORTED_MODULE_0__.DefaultLoader {
    get _image() {
        if (!this._imageElement) {
            this._imageElement = new Image();
            this._imageElement.onload = () => this._imageLoaded.resolve();
            this._imageElement.src = this.logo;
        }
        return this._imageElement;
    }
    get playButtonRootElement() {
        return this._playButtonRootElement;
    }
    get playButtonElement() {
        return this._playButtonElement;
    }
    get _playButton() {
        const existingRoot = document.getElementById('excalibur-play-root');
        if (existingRoot) {
            this._playButtonRootElement = existingRoot;
        }
        if (!this._playButtonRootElement) {
            this._playButtonRootElement = document.createElement('div');
            this._playButtonRootElement.id = 'excalibur-play-root';
            this._playButtonRootElement.style.position = 'absolute';
            document.body.appendChild(this._playButtonRootElement);
        }
        if (!this._styleBlock) {
            this._styleBlock = document.createElement('style');
            this._styleBlock.textContent = this._playButtonStyles;
            document.head.appendChild(this._styleBlock);
        }
        if (!this._playButtonElement) {
            this._playButtonElement = this.startButtonFactory();
            this._playButtonRootElement.appendChild(this._playButtonElement);
        }
        return this._playButtonElement;
    }
    constructor(loadablesOrOptions) {
        const options = Array.isArray(loadablesOrOptions)
            ? {
                loadables: loadablesOrOptions
            }
            : loadablesOrOptions;
        super(options);
        this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_1__.Logger.getInstance();
        this._originalOptions = { loadables: [] };
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this._playButtonShown = false;
        // logo drawing stuff
        // base64 string encoding of the excalibur logo (logo-white.png)
        this.logo = _Loader_logo_png__WEBPACK_IMPORTED_MODULE_3__["default"];
        this.logoWidth = 468;
        this.logoHeight = 118;
        /**
         * Gets or sets the color of the loading bar, default is {@apilink Color.White}
         */
        this.loadingBarColor = _Color__WEBPACK_IMPORTED_MODULE_4__.Color.White;
        /**
         * Gets or sets the background color of the loader as a hex string
         */
        this.backgroundColor = '#176BAA';
        this._imageLoaded = new _Util_Future__WEBPACK_IMPORTED_MODULE_5__.Future();
        this.suppressPlayButton = false;
        /** Loads the css from Loader.css */
        this._playButtonStyles = _Loader_css__WEBPACK_IMPORTED_MODULE_6__["default"].toString();
        /**
         * Get/set play button text
         */
        this.playButtonText = 'Play game';
        /**
         * Return a html button element for excalibur to use as a play button
         */
        this.startButtonFactory = () => {
            let buttonElement = document.getElementById('excalibur-play');
            if (!buttonElement) {
                buttonElement = document.createElement('button');
            }
            buttonElement.id = 'excalibur-play';
            buttonElement.textContent = this.playButtonText;
            buttonElement.style.display = 'none';
            return buttonElement;
        };
        this._originalOptions = { ...Loader._DEFAULT_LOADER_OPTIONS, ...options };
    }
    onInitialize(engine) {
        this.engine = engine;
        this.screen = engine.screen;
        this.canvas.width = this.engine.canvas.width;
        this.canvas.height = this.engine.canvas.height;
        this.screen.events.on('resize', () => {
            this.canvas.width = this.engine.canvas.width;
            this.canvas.height = this.engine.canvas.height;
        });
    }
    /**
     * Shows the play button and returns a promise that resolves when clicked
     */
    async showPlayButton() {
        var _a, _b;
        if (this.suppressPlayButton) {
            this.hidePlayButton();
            // Delay is to give the logo a chance to show, otherwise don't delay
            await (0,_Util_Util__WEBPACK_IMPORTED_MODULE_7__.delay)(500, (_a = this.engine) === null || _a === void 0 ? void 0 : _a.clock);
        }
        else {
            const resizeHandler = () => {
                try {
                    this._positionPlayButton();
                }
                catch (_a) {
                    // swallow if can't position
                }
            };
            if ((_b = this.engine) === null || _b === void 0 ? void 0 : _b.browser) {
                this.engine.browser.window.on('resize', resizeHandler);
            }
            this._playButtonShown = true;
            this._playButton.style.display = 'block';
            document.body.addEventListener('keyup', (evt) => {
                if (evt.key === 'Enter') {
                    this._playButton.click();
                }
            });
            this._positionPlayButton();
            const playButtonClicked = new Promise((resolve) => {
                const startButtonHandler = (e) => {
                    var _a;
                    // We want to stop propagation to keep bubbling to the engine pointer handlers
                    e.stopPropagation();
                    // Hide Button after click
                    this.hidePlayButton();
                    if ((_a = this.engine) === null || _a === void 0 ? void 0 : _a.browser) {
                        this.engine.browser.window.off('resize', resizeHandler);
                    }
                    if (this._originalOptions.fullscreenAfterLoad) {
                        try {
                            this._logger.info('requesting fullscreen');
                            if (this._originalOptions.fullscreenContainer instanceof HTMLElement) {
                                this._originalOptions.fullscreenContainer.requestFullscreen();
                            }
                            else {
                                this.engine.screen.enterFullscreen(this._originalOptions.fullscreenContainer);
                            }
                        }
                        catch (error) {
                            this._logger.error('could not go fullscreen', error);
                        }
                    }
                    resolve();
                };
                this._playButton.addEventListener('click', startButtonHandler);
                this._playButton.addEventListener('touchend', startButtonHandler);
                this._playButton.addEventListener('pointerup', startButtonHandler);
                if (this.engine) {
                    this.engine.input.gamepads.once('button', () => startButtonHandler(new Event('button')));
                }
            });
            return await playButtonClicked;
        }
    }
    hidePlayButton() {
        this._playButtonShown = false;
        this._playButton.style.display = 'none';
    }
    /**
     * Clean up generated elements for the loader
     */
    dispose() {
        if (this._playButtonRootElement.parentElement) {
            this._playButtonRootElement.removeChild(this._playButtonElement);
            document.body.removeChild(this._playButtonRootElement);
            document.head.removeChild(this._styleBlock);
            this._playButtonRootElement = null;
            this._playButtonElement = null;
            this._styleBlock = null;
        }
    }
    async onUserAction() {
        var _a;
        // short delay in showing the button for aesthetics
        await (0,_Util_Util__WEBPACK_IMPORTED_MODULE_7__.delay)(200, (_a = this.engine) === null || _a === void 0 ? void 0 : _a.clock);
        this.canvas.flagDirty();
        // show play button
        await this.showPlayButton();
    }
    async onBeforeLoad() {
        this.screen.pushResolutionAndViewport();
        this.screen.resolution = { width: this.canvas.width, height: this.canvas.height };
        this.screen.applyResolutionAndViewport();
        const image = this._image;
        await this._imageLoaded.promise;
        await (image === null || image === void 0 ? void 0 : image.decode()); // decode logo if it exists
    }
    // eslint-disable-next-line require-await
    async onAfterLoad() {
        this.screen.popResolutionAndViewport();
        this.screen.applyResolutionAndViewport();
        this.dispose();
    }
    _positionPlayButton() {
        if (this.engine) {
            const { x: left, y: top, width: screenWidth, height: screenHeight } = this.engine.canvas.getBoundingClientRect();
            if (this._playButtonRootElement) {
                const buttonWidth = this._playButton.clientWidth;
                const buttonHeight = this._playButton.clientHeight;
                if (this.playButtonPosition) {
                    this._playButtonRootElement.style.left = `${this.playButtonPosition.x}px`;
                    this._playButtonRootElement.style.top = `${this.playButtonPosition.y}px`;
                }
                else {
                    this._playButtonRootElement.style.left = `${left + screenWidth / 2 - buttonWidth / 2}px`;
                    this._playButtonRootElement.style.top = `${top + screenHeight / 2 - buttonHeight / 2 + 100}px`;
                }
            }
        }
    }
    /**
     * Loader draw function. Draws the default Excalibur loading screen.
     * Override `logo`, `logoWidth`, `logoHeight` and `backgroundColor` properties
     * to customize the drawing, or just override entire method.
     */
    onDraw(ctx) {
        const canvasHeight = this.engine.canvasHeight / this.engine.pixelRatio;
        const canvasWidth = this.engine.canvasWidth / this.engine.pixelRatio;
        this._positionPlayButton();
        ctx.fillStyle = this.backgroundColor;
        ctx.fillRect(0, 0, canvasWidth, canvasHeight);
        let logoY = canvasHeight / 2;
        const width = Math.min(this.logoWidth, canvasWidth * 0.75);
        let logoX = canvasWidth / 2 - width / 2;
        if (this.logoPosition) {
            logoX = this.logoPosition.x;
            logoY = this.logoPosition.y;
        }
        const imageHeight = Math.floor(width * (this.logoHeight / this.logoWidth)); // OG height/width factor
        const oldAntialias = this.engine.screen.antialiasing;
        this.engine.screen.antialiasing = true;
        if (!this.logoPosition) {
            ctx.drawImage(this._image, 0, 0, this.logoWidth, this.logoHeight, logoX, logoY - imageHeight - 20, width, imageHeight);
        }
        else {
            ctx.drawImage(this._image, 0, 0, this.logoWidth, this.logoHeight, logoX, logoY, width, imageHeight);
        }
        // loading box
        if (!this.suppressPlayButton && this._playButtonShown) {
            this.engine.screen.antialiasing = oldAntialias;
            return;
        }
        let loadingX = logoX;
        let loadingY = logoY;
        if (this.loadingBarPosition) {
            loadingX = this.loadingBarPosition.x;
            loadingY = this.loadingBarPosition.y;
        }
        ctx.lineWidth = 2;
        _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_8__.roundRect(ctx, loadingX, loadingY, width, 20, 10, this.loadingBarColor);
        const progress = width * this.progress;
        const margin = 5;
        const progressWidth = progress - margin * 2;
        const height = 20 - margin * 2;
        _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_8__.roundRect(ctx, loadingX + margin, loadingY + margin, progressWidth > 10 ? progressWidth : 10, height, 5, null, this.loadingBarColor);
        this.engine.screen.antialiasing = oldAntialias;
    }
}
Loader._DEFAULT_LOADER_OPTIONS = {
    loadables: [],
    fullscreenAfterLoad: false,
    fullscreenContainer: undefined
};


/***/ }),

/***/ "./Director/Slide.ts":
/*!***************************!*\
  !*** ./Director/Slide.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Slide: () => (/* binding */ Slide)
/* harmony export */ });
/* harmony import */ var _Graphics__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Graphics */ "./Graphics/ImageSource.ts");
/* harmony import */ var _Transition__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Transition */ "./Director/Transition.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util/EasingFunctions */ "./Util/EasingFunctions.ts");
/* harmony import */ var _Math_coord_plane__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Math/coord-plane */ "./Math/coord-plane.ts");





/**
 * Slide`s between the previous scene and the destination scene
 *
 * Note: Slide` only works as an "in" transition
 */
class Slide extends _Transition__WEBPACK_IMPORTED_MODULE_0__.Transition {
    constructor(options) {
        var _a;
        super({ direction: 'in', ...options }); // default the correct direction
        this._easing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_1__.EasingFunctions.Linear;
        this.name = `Slide#${this.id}`;
        this.slideDirection = options.slideDirection;
        this.transform.coordPlane = _Math_coord_plane__WEBPACK_IMPORTED_MODULE_2__.CoordPlane.World;
        this.graphics.forceOnScreen = true;
        this._easing = (_a = options.easingFunction) !== null && _a !== void 0 ? _a : this._easing;
        this._vectorEasing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_1__.EasingFunctions.CreateVectorEasingFunction(this._easing);
    }
    async onPreviousSceneDeactivate(scene) {
        this._image = await scene.engine.screenshot(true);
        // Firefox is particularly slow
        // needed in case the image isn't ready yet
        await this._image.decode();
        this._screenCover = _Graphics__WEBPACK_IMPORTED_MODULE_3__.ImageSource.fromHtmlImageElement(this._image).toSprite();
    }
    onInitialize(engine) {
        this._engine = engine;
        switch (this.slideDirection) {
            case 'up': {
                this._directionOffset = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(0, -engine.screen.resolution.height);
                break;
            }
            case 'down': {
                this._directionOffset = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(0, engine.screen.resolution.height);
                break;
            }
            case 'left': {
                this._directionOffset = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(-engine.screen.resolution.width, 0);
                break;
            }
            case 'right': {
                this._directionOffset = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(engine.screen.resolution.width, 0);
                break;
            }
        }
        this._camera = this._engine.currentScene.camera;
        this._destinationCameraPosition = this._camera.pos.clone();
        // For sliding shift the camera and the transition slide by offset
        this._camera.pos = this._camera.pos.add(this._directionOffset);
        this.transform.pos = this.transform.pos.add(this._directionOffset);
        this._startCameraPosition = this._camera.pos.clone();
        this.graphics.use(this._screenCover);
        // This is because we preserve hidpi res on the screen shot which COULD be bigger than the logical resolution
        this.transform.scale = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_4__.vec)(1 / engine.screen.pixelRatio, 1 / engine.screen.pixelRatio);
    }
    onUpdate(progress) {
        // in-transitions count down from 1 -> 0, so our "end" is swapped
        this._camera.pos = this._vectorEasing(progress, this._destinationCameraPosition, this._startCameraPosition, 1);
    }
}


/***/ }),

/***/ "./Director/Transition.ts":
/*!********************************!*\
  !*** ./Director/Transition.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Transition: () => (/* binding */ Transition)
/* harmony export */ });
/* harmony import */ var _Util_Future__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Util/Future */ "./Util/Future.ts");
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EntityComponentSystem */ "./EntityComponentSystem/Entity.ts");
/* harmony import */ var _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../EntityComponentSystem */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Graphics__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Graphics */ "./Graphics/GraphicsComponent.ts");
/* harmony import */ var _Math_coord_plane__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Math/coord-plane */ "./Math/coord-plane.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Math/util */ "./Math/util.ts");
/* harmony import */ var _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Util/EasingFunctions */ "./Util/EasingFunctions.ts");
/* harmony import */ var _Util_Coroutine__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Util/Coroutine */ "./Util/Coroutine.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");









/**
 * Base Transition that can be extended to provide custom scene transitions in Excalibur.
 */
class Transition extends _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_0__.Entity {
    /**
     * Returns a number between [0, 1] indicating what state the transition is in.
     *
     * * For 'out' direction transitions start at 0 and end at 1
     * * For 'in' direction transitions start at 1 and end at 0
     */
    get progress() {
        return this._currentProgress;
    }
    get complete() {
        if (this.direction === 'out') {
            return this.progress >= 1;
        }
        else {
            return this.progress <= 0;
        }
    }
    constructor(options) {
        var _a, _b, _c, _d;
        super();
        this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_1__.Logger.getInstance();
        this.transform = new _EntityComponentSystem__WEBPACK_IMPORTED_MODULE_2__.TransformComponent();
        this.graphics = new _Graphics__WEBPACK_IMPORTED_MODULE_3__.GraphicsComponent();
        this._completeFuture = new _Util_Future__WEBPACK_IMPORTED_MODULE_4__.Future();
        // State needs to be reset between uses
        this.started = false;
        this._currentDistance = 0;
        this._currentProgress = 0;
        this.done = this._completeFuture.promise;
        this.name = `Transition#${this.id}`;
        this.duration = options.duration;
        this.easing = (_a = options.easing) !== null && _a !== void 0 ? _a : _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_5__.EasingFunctions.Linear;
        this.direction = (_b = options.direction) !== null && _b !== void 0 ? _b : 'out';
        this.hideLoader = (_c = options.hideLoader) !== null && _c !== void 0 ? _c : false;
        this.blockInput = (_d = options.blockInput) !== null && _d !== void 0 ? _d : false;
        this.transform.coordPlane = _Math_coord_plane__WEBPACK_IMPORTED_MODULE_6__.CoordPlane.Screen;
        this.transform.pos = _Math_vector__WEBPACK_IMPORTED_MODULE_7__.Vector.Zero;
        this.transform.z = Infinity; // Transitions sit on top of everything
        this.graphics.anchor = _Math_vector__WEBPACK_IMPORTED_MODULE_7__.Vector.Zero;
        this.addComponent(this.transform);
        this.addComponent(this.graphics);
        if (this.direction === 'out') {
            this._currentProgress = 0;
        }
        else {
            this._currentProgress = 1;
        }
    }
    /**
     * Overridable lifecycle method, called before each update.
     *
     * **WARNING BE SURE** to call `super.updateTransition()` if overriding in your own custom implementation
     * @param engine
     * @param elapsed
     */
    updateTransition(engine, elapsed) {
        if (this.complete) {
            return;
        }
        this._currentDistance += (0,_Math_util__WEBPACK_IMPORTED_MODULE_8__.clamp)(elapsed / this.duration, 0, 1);
        if (this._currentDistance >= 1) {
            this._currentDistance = 1;
        }
        if (this.direction === 'out') {
            this._currentProgress = (0,_Math_util__WEBPACK_IMPORTED_MODULE_8__.clamp)(this.easing(this._currentDistance, 0, 1, 1), 0, 1);
        }
        else {
            this._currentProgress = (0,_Math_util__WEBPACK_IMPORTED_MODULE_8__.clamp)(this.easing(this._currentDistance, 1, 0, 1), 0, 1);
        }
    }
    /**
     * Overridable lifecycle method, called right before the previous scene has deactivated.
     *
     * This gives incoming transition a chance to grab info from previous scene if desired
     * @param scene
     */
    async onPreviousSceneDeactivate(scene) {
        // override me
    }
    /**
     * Overridable lifecycle method, called once at the beginning of the transition
     *
     * `progress` is given between 0 and 1
     * @param progress
     */
    onStart(progress) {
        // override me
    }
    /**
     * Overridable lifecycle method, called every frame of the transition
     *
     * `progress` is given between 0 and 1
     * @param progress
     */
    onUpdate(progress) {
        // override me
    }
    /**
     * Overridable lifecycle method, called at the end of the transition,
     *
     * `progress` is given between 0 and 1
     * @param progress
     */
    onEnd(progress) {
        // override me
    }
    /**
     * Overridable lifecycle method, called when the transition is reset
     *
     * Use this to override and provide your own reset logic for internal state in custom transition implementations
     */
    onReset() {
        // override me
    }
    /**
     * reset() is called by the engine to reset transitions
     */
    reset() {
        this.started = false;
        this._completeFuture = new _Util_Future__WEBPACK_IMPORTED_MODULE_4__.Future();
        this.done = this._completeFuture.promise;
        this._currentDistance = 0;
        if (this.direction === 'out') {
            this._currentProgress = 0;
        }
        else {
            this._currentProgress = 1;
        }
        this.onReset();
    }
    /**
     * @internal
     */
    _addToTargetScene(engine, targetScene) {
        const currentScene = targetScene;
        if (this.started) {
            this._logger.warn(`Attempted to add a transition ${this.name} that is already playing.`);
        }
        if (currentScene.world.entityManager.getById(this.id)) {
            return this._co;
        }
        this._engine = engine;
        currentScene.add(this);
        const self = this;
        this._co = (0,_Util_Coroutine__WEBPACK_IMPORTED_MODULE_9__.coroutine)(engine, function* () {
            while (!self.complete) {
                const elapsed = yield; // per frame
                self.updateTransition(self._engine, elapsed);
                self._execute();
            }
        }, {
            autostart: false
        });
        return this._co;
    }
    /**
     * Called internally by excalibur to swap scenes with transition
     * @internal
     */
    async _play() {
        if (this.started) {
            this.reset();
            this._logger.warn(`Attempted to play a transition ${this.name} that is already playing, reset transition.`);
        }
        if (!this._engine || !this._co) {
            this.reset();
            this._logger.warn(`Attempted to play a transition ${this.name} that hasn't been added`);
        }
        if (this._co) {
            await this._co.start();
        }
    }
    /**
     * execute() is called by the engine every frame to update the Transition lifecycle onStart/onUpdate/onEnd
     * @internal
     */
    _execute() {
        if (!this.isInitialized) {
            return;
        }
        if (!this.started) {
            this.started = true;
            this.onStart(this.progress);
        }
        this.onUpdate(this.progress);
        if (this.complete && !this._completeFuture.isCompleted) {
            this.onEnd(this.progress);
            this._completeFuture.resolve();
        }
    }
}


/***/ }),

/***/ "./Director/index.ts":
/*!***************************!*\
  !*** ./Director/index.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CrossFade: () => (/* reexport safe */ _CrossFade__WEBPACK_IMPORTED_MODULE_2__.CrossFade),
/* harmony export */   DefaultLoader: () => (/* reexport safe */ _DefaultLoader__WEBPACK_IMPORTED_MODULE_6__.DefaultLoader),
/* harmony export */   Director: () => (/* reexport safe */ _Director__WEBPACK_IMPORTED_MODULE_4__.Director),
/* harmony export */   DirectorEvents: () => (/* reexport safe */ _Director__WEBPACK_IMPORTED_MODULE_4__.DirectorEvents),
/* harmony export */   FadeInOut: () => (/* reexport safe */ _FadeInOut__WEBPACK_IMPORTED_MODULE_1__.FadeInOut),
/* harmony export */   Loader: () => (/* reexport safe */ _Loader__WEBPACK_IMPORTED_MODULE_5__.Loader),
/* harmony export */   LoaderEvents: () => (/* reexport safe */ _DefaultLoader__WEBPACK_IMPORTED_MODULE_6__.LoaderEvents),
/* harmony export */   Slide: () => (/* reexport safe */ _Slide__WEBPACK_IMPORTED_MODULE_3__.Slide),
/* harmony export */   Transition: () => (/* reexport safe */ _Transition__WEBPACK_IMPORTED_MODULE_0__.Transition),
/* harmony export */   isLoaderConstructor: () => (/* reexport safe */ _DefaultLoader__WEBPACK_IMPORTED_MODULE_6__.isLoaderConstructor)
/* harmony export */ });
/* harmony import */ var _Transition__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Transition */ "./Director/Transition.ts");
/* harmony import */ var _FadeInOut__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FadeInOut */ "./Director/FadeInOut.ts");
/* harmony import */ var _CrossFade__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CrossFade */ "./Director/CrossFade.ts");
/* harmony import */ var _Slide__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Slide */ "./Director/Slide.ts");
/* harmony import */ var _Director__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Director */ "./Director/Director.ts");
/* harmony import */ var _Loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Loader */ "./Director/Loader.ts");
/* harmony import */ var _DefaultLoader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DefaultLoader */ "./Director/DefaultLoader.ts");









/***/ }),

/***/ "./Engine.ts":
/*!*******************!*\
  !*** ./Engine.ts ***!
  \*******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Engine: () => (/* binding */ Engine),
/* harmony export */   EngineEvents: () => (/* binding */ EngineEvents),
/* harmony export */   ScrollPreventionMode: () => (/* binding */ ScrollPreventionMode)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ */ "./index.ts");
/* harmony import */ var _Util_Future__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Util/Future */ "./Util/Future.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./EventEmitter */ "./EventEmitter.ts");
/* harmony import */ var _Input_PointerScope__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Input/PointerScope */ "./Input/PointerScope.ts");
/* harmony import */ var _Flags__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Flags */ "./Flags.ts");
/* harmony import */ var _Polyfill__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Polyfill */ "./Polyfill.ts");
/* harmony import */ var _Screen__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Screen */ "./Screen.ts");
/* harmony import */ var _Director_DefaultLoader__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./Director/DefaultLoader */ "./Director/DefaultLoader.ts");
/* harmony import */ var _Director_Loader__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./Director/Loader */ "./Director/Loader.ts");
/* harmony import */ var _Util_Detector__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Util/Detector */ "./Util/Detector.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./Color */ "./Color.ts");
/* harmony import */ var _Scene__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./Scene */ "./Scene.ts");
/* harmony import */ var _EntityComponentSystem_Entity__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./EntityComponentSystem/Entity */ "./EntityComponentSystem/Entity.ts");
/* harmony import */ var _Debug_DebugConfig__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Debug/DebugConfig */ "./Debug/DebugConfig.ts");
/* harmony import */ var _Util_Browser__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Util/Browser */ "./Util/Browser.ts");
/* harmony import */ var _Graphics__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Graphics */ "./Graphics/Context/ExcaliburGraphicsContext.ts");
/* harmony import */ var _Graphics__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Graphics */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");
/* harmony import */ var _Graphics__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Graphics */ "./Graphics/Context/ExcaliburGraphicsContext2DCanvas.ts");
/* harmony import */ var _Graphics__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Graphics */ "./Graphics/Context/texture-loader.ts");
/* harmony import */ var _Util_Clock__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Util/Clock */ "./Util/Clock.ts");
/* harmony import */ var _Graphics_Filtering__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Graphics/Filtering */ "./Graphics/Filtering.ts");
/* harmony import */ var _Graphics_GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./Graphics/GraphicsDiagnostics */ "./Graphics/GraphicsDiagnostics.ts");
/* harmony import */ var _Util_Toaster__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Util/Toaster */ "./Util/Toaster.ts");
/* harmony import */ var _Director_Director__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Director/Director */ "./Director/Director.ts");
/* harmony import */ var _Input_InputHost__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./Input/InputHost */ "./Input/InputHost.ts");
/* harmony import */ var _Collision_PhysicsConfig__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Collision/PhysicsConfig */ "./Collision/PhysicsConfig.ts");
/* harmony import */ var _Context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Context */ "./Context.ts");
/* harmony import */ var _GarbageCollector__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./GarbageCollector */ "./GarbageCollector.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Util/Util */ "./Util/Util.ts");






(0,_Polyfill__WEBPACK_IMPORTED_MODULE_0__.polyfill)();






















const EngineEvents = {
    FallbackGraphicsContext: 'fallbackgraphicscontext',
    Initialize: 'initialize',
    Visible: 'visible',
    Hidden: 'hidden',
    Start: 'start',
    Stop: 'stop',
    PreUpdate: 'preupdate',
    PostUpdate: 'postupdate',
    PreFrame: 'preframe',
    PostFrame: 'postframe',
    PreDraw: 'predraw',
    PostDraw: 'postdraw',
    ..._Director_Director__WEBPACK_IMPORTED_MODULE_1__.DirectorEvents
};
/**
 * Enum representing the different mousewheel event bubble prevention
 */
var ScrollPreventionMode;
(function (ScrollPreventionMode) {
    /**
     * Do not prevent any page scrolling
     */
    ScrollPreventionMode[ScrollPreventionMode["None"] = 0] = "None";
    /**
     * Prevent page scroll if mouse is over the game canvas
     */
    ScrollPreventionMode[ScrollPreventionMode["Canvas"] = 1] = "Canvas";
    /**
     * Prevent all page scrolling via mouse wheel
     */
    ScrollPreventionMode[ScrollPreventionMode["All"] = 2] = "All";
})(ScrollPreventionMode || (ScrollPreventionMode = {}));
/**
 * The Excalibur Engine
 *
 * The {@apilink Engine} is the main driver for a game. It is responsible for
 * starting/stopping the game, maintaining state, transmitting events,
 * loading resources, and managing the scene.
 */
class Engine {
    static useEngine() {
        const value = (0,_Context__WEBPACK_IMPORTED_MODULE_2__.useContext)(Engine.Context);
        if (!value) {
            throw new Error('Cannot inject engine with `useEngine()`, `useEngine()` was called outside of Engine lifecycle scope.');
        }
        return value;
    }
    /**
     * The width of the game canvas in pixels (physical width component of the
     * resolution of the canvas element)
     */
    get canvasWidth() {
        return this.screen.canvasWidth;
    }
    /**
     * Returns half width of the game canvas in pixels (half physical width component)
     */
    get halfCanvasWidth() {
        return this.screen.halfCanvasWidth;
    }
    /**
     * The height of the game canvas in pixels, (physical height component of
     * the resolution of the canvas element)
     */
    get canvasHeight() {
        return this.screen.canvasHeight;
    }
    /**
     * Returns half height of the game canvas in pixels (half physical height component)
     */
    get halfCanvasHeight() {
        return this.screen.halfCanvasHeight;
    }
    /**
     * Returns the width of the engine's visible drawing surface in pixels including zoom and device pixel ratio.
     */
    get drawWidth() {
        return this.screen.drawWidth;
    }
    /**
     * Returns half the width of the engine's visible drawing surface in pixels including zoom and device pixel ratio.
     */
    get halfDrawWidth() {
        return this.screen.halfDrawWidth;
    }
    /**
     * Returns the height of the engine's visible drawing surface in pixels including zoom and device pixel ratio.
     */
    get drawHeight() {
        return this.screen.drawHeight;
    }
    /**
     * Returns half the height of the engine's visible drawing surface in pixels including zoom and device pixel ratio.
     */
    get halfDrawHeight() {
        return this.screen.halfDrawHeight;
    }
    /**
     * Returns whether excalibur detects the current screen to be HiDPI
     */
    get isHiDpi() {
        return this.screen.isHiDpi;
    }
    /**
     * Access {@apilink stats} that holds frame statistics.
     */
    get stats() {
        return this.debug.stats;
    }
    /**
     * The current {@apilink Scene} being drawn and updated on screen
     */
    get currentScene() {
        return this.director.currentScene;
    }
    /**
     * The current {@apilink Scene} being drawn and updated on screen
     */
    get currentSceneName() {
        return this.director.currentSceneName;
    }
    /**
     * The default {@apilink Scene} of the game, use {@apilink Engine.goToScene} to transition to different scenes.
     */
    get rootScene() {
        return this.director.rootScene;
    }
    /**
     * Contains all the scenes currently registered with Excalibur
     */
    get scenes() {
        return this.director.scenes;
    }
    /**
     * Indicates whether the engine is set to fullscreen or not
     */
    get isFullscreen() {
        return this.screen.isFullScreen;
    }
    /**
     * Indicates the current {@apilink DisplayMode} of the engine.
     */
    get displayMode() {
        return this.screen.displayMode;
    }
    /**
     * Returns the calculated pixel ration for use in rendering
     */
    get pixelRatio() {
        return this.screen.pixelRatio;
    }
    get isDebug() {
        return this._isDebug;
    }
    /**
     * Hints the graphics context to truncate fractional world space coordinates
     */
    get snapToPixel() {
        return this.graphicsContext.snapToPixel;
    }
    set snapToPixel(shouldSnapToPixel) {
        this.graphicsContext.snapToPixel = shouldSnapToPixel;
    }
    emit(eventName, event) {
        this.events.emit(eventName, event);
    }
    on(eventName, handler) {
        return this.events.on(eventName, handler);
    }
    once(eventName, handler) {
        return this.events.once(eventName, handler);
    }
    off(eventName, handler) {
        this.events.off(eventName, handler);
    }
    /**
     * Creates a new game using the given {@apilink EngineOptions}. By default, if no options are provided,
     * the game will be rendered full screen (taking up all available browser window space).
     * You can customize the game rendering through {@apilink EngineOptions}.
     *
     * Example:
     *
     * ```js
     * var game = new ex.Engine({
     *   width: 0, // the width of the canvas
     *   height: 0, // the height of the canvas
     *   enableCanvasTransparency: true, // the transparencySection of the canvas
     *   canvasElementId: '', // the DOM canvas element ID, if you are providing your own
     *   displayMode: ex.DisplayMode.FullScreen, // the display mode
     *   pointerScope: ex.PointerScope.Document, // the scope of capturing pointer (mouse/touch) events
     *   backgroundColor: ex.Color.fromHex('#2185d0') // background color of the engine
     * });
     *
     * // call game.start, which is a Promise
     * game.start().then(function () {
     *   // ready, set, go!
     * });
     * ```
     */
    constructor(options) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        /**
         * Anything run under scope can use `useEngine()` to inject the current engine
         * @param cb
         */
        this.scope = (cb) => Engine.Context.scope(this, cb);
        /**
         * Current Excalibur version string
         *
         * Useful for plugins or other tools that need to know what features are available
         */
        this.version = ___WEBPACK_IMPORTED_MODULE_3__.EX_VERSION;
        /**
         * Listen to and emit events on the Engine
         */
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
        /**
         * Optionally set the maximum fps if not set Excalibur will go as fast as the device allows.
         *
         * You may want to constrain max fps if your game cannot maintain fps consistently, it can look and feel better to have a 30fps game than
         * one that bounces between 30fps and 60fps
         */
        this.maxFps = Number.POSITIVE_INFINITY;
        this._inputEnabled = true;
        this._suppressPlayButton = false;
        /**
         * Indicates whether audio should be paused when the game is no longer visible.
         */
        this.pauseAudioWhenHidden = true;
        /**
         * Indicates whether the engine should draw with debug information
         */
        this._isDebug = false;
        /**
         * Sets the Transparency for the engine.
         */
        this.enableCanvasTransparency = true;
        /**
         * The action to take when a fatal exception is thrown
         */
        this.onFatalException = (e) => {
            _Util_Log__WEBPACK_IMPORTED_MODULE_5__.Logger.getInstance().fatal(e, e.stack);
        };
        this._toaster = new _Util_Toaster__WEBPACK_IMPORTED_MODULE_6__.Toaster();
        this._timescale = 1.0;
        this._isInitialized = false;
        this._originalOptions = {};
        this._handleWebGLContextLost = (e) => {
            var _a;
            e.preventDefault();
            this.clock.stop();
            this._logger.fatalOnce('WebGL Graphics Lost', e);
            const container = document.createElement('div');
            container.id = 'ex-webgl-graphics-context-lost';
            container.style.position = 'absolute';
            container.style.zIndex = '99';
            container.style.left = '50%';
            container.style.top = '50%';
            container.style.display = 'flex';
            container.style.flexDirection = 'column';
            container.style.transform = 'translate(-50%, -50%)';
            container.style.backgroundColor = 'white';
            container.style.padding = '10px';
            container.style.borderStyle = 'solid 1px';
            const div = document.createElement('div');
            div.innerHTML = `
      <h1>There was an issue rendering, please refresh the page.</h1>
      <div>
        <p>WebGL Graphics Context Lost</p>

        <button id="ex-webgl-graphics-reload">Refresh Page</button>

        <p>There are a few reasons this might happen:</p>
        <ul>
          <li>Two or more pages are placing a high demand on the GPU</li>
          <li>Another page or operation has stalled the GPU and the browser has decided to reset the GPU</li>
          <li>The computer has multiple GPUs and the user has switched between them</li>
          <li>Graphics driver has crashed or restarted</li>
          <li>Graphics driver was updated</li>
        </ul>
      </div>
    `;
            container.appendChild(div);
            if ((_a = this.canvas) === null || _a === void 0 ? void 0 : _a.parentElement) {
                this.canvas.parentElement.appendChild(container);
                const button = div.querySelector('#ex-webgl-graphics-reload');
                button === null || button === void 0 ? void 0 : button.addEventListener('click', () => location.reload());
            }
        };
        this._performanceThresholdTriggered = false;
        this._fpsSamples = [];
        this._disposed = false;
        this._isLoading = false;
        this._hideLoader = false;
        this._isReadyFuture = new _Util_Future__WEBPACK_IMPORTED_MODULE_7__.Future();
        /**
         * Returns the current frames elapsed milliseconds
         */
        this.currentFrameElapsedMs = 0;
        /**
         * Returns the current frame lag when in fixed update mode
         */
        this.currentFrameLagMs = 0;
        this._lagMs = 0;
        this._screenShotRequests = [];
        options = { ...Engine._DEFAULT_ENGINE_OPTIONS, ...options };
        this._originalOptions = options;
        _Flags__WEBPACK_IMPORTED_MODULE_8__.Flags.freeze();
        // Initialize browser events facade
        this.browser = new _Util_Browser__WEBPACK_IMPORTED_MODULE_9__.BrowserEvents(window, document);
        // Check compatibility
        const detector = new _Util_Detector__WEBPACK_IMPORTED_MODULE_10__.Detector();
        if (!options.suppressMinimumBrowserFeatureDetection && !(this._compatible = detector.test())) {
            const message = document.createElement('div');
            message.innerText = 'Sorry, your browser does not support all the features needed for Excalibur';
            document.body.appendChild(message);
            detector.failedTests.forEach(function (test) {
                const testMessage = document.createElement('div');
                testMessage.innerText = 'Browser feature missing ' + test;
                document.body.appendChild(testMessage);
            });
            if (options.canvasElementId) {
                const canvas = document.getElementById(options.canvasElementId);
                if (canvas) {
                    canvas.parentElement.removeChild(canvas);
                }
            }
            return;
        }
        else {
            this._compatible = true;
        }
        // Use native console API for color fun
        // eslint-disable-next-line no-console
        if (console.log && !options.suppressConsoleBootMessage) {
            // eslint-disable-next-line no-console
            console.log(`%cPowered by Excalibur.js (v${___WEBPACK_IMPORTED_MODULE_3__.EX_VERSION})`, 'background: #176BAA; color: white; border-radius: 5px; padding: 15px; font-size: 1.5em; line-height: 80px;');
            // eslint-disable-next-line no-console
            console.log('\n\
      /| ________________\n\
O|===|* >________________>\n\
      \\|');
            // eslint-disable-next-line no-console
            console.log('Visit', 'http://excaliburjs.com', 'for more information');
        }
        // Suppress play button
        if (options.suppressPlayButton) {
            this._suppressPlayButton = true;
        }
        this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_5__.Logger.getInstance();
        // If debug is enabled, let's log browser features to the console.
        if (this._logger.defaultLevel === _Util_Log__WEBPACK_IMPORTED_MODULE_5__.LogLevel.Debug) {
            detector.logBrowserFeatures();
        }
        this._logger.debug('Building engine...');
        if (options.garbageCollection === true) {
            this.garbageCollectorConfig = {
                ..._GarbageCollector__WEBPACK_IMPORTED_MODULE_11__.DefaultGarbageCollectionOptions
            };
        }
        else if (options.garbageCollection === false) {
            this._logger.warn('WebGL Garbage Collection Disabled!!! If you leak any images over time your game will crash when GPU memory is exhausted');
            this.garbageCollectorConfig = null;
        }
        else {
            this.garbageCollectorConfig = {
                ..._GarbageCollector__WEBPACK_IMPORTED_MODULE_11__.DefaultGarbageCollectionOptions,
                ...options.garbageCollection
            };
        }
        this._garbageCollector = new _GarbageCollector__WEBPACK_IMPORTED_MODULE_11__.GarbageCollector({ getTimestamp: Date.now });
        this.canvasElementId = options.canvasElementId;
        if (options.canvasElementId) {
            this._logger.debug('Using Canvas element specified: ' + options.canvasElementId);
            //test for existence of element
            if (document.getElementById(options.canvasElementId) === null) {
                throw new Error('Cannot find existing element in the DOM, please ensure element is created prior to engine creation.');
            }
            this.canvas = document.getElementById(options.canvasElementId);
        }
        else if (options.canvasElement) {
            this._logger.debug('Using Canvas element specified:', options.canvasElement);
            this.canvas = options.canvasElement;
        }
        else {
            this._logger.debug('Using generated canvas element');
            this.canvas = document.createElement('canvas');
        }
        if (this.canvas && !options.enableCanvasContextMenu) {
            this.canvas.addEventListener('contextmenu', (evt) => {
                evt.preventDefault();
            });
        }
        let displayMode = (_a = options.displayMode) !== null && _a !== void 0 ? _a : _Screen__WEBPACK_IMPORTED_MODULE_12__.DisplayMode.Fixed;
        if ((options.width && options.height) || options.viewport) {
            if (options.displayMode === undefined) {
                displayMode = _Screen__WEBPACK_IMPORTED_MODULE_12__.DisplayMode.Fixed;
            }
            this._logger.debug('Engine viewport is size ' + options.width + ' x ' + options.height);
        }
        else if (!options.displayMode) {
            this._logger.debug('Engine viewport is fit');
            displayMode = _Screen__WEBPACK_IMPORTED_MODULE_12__.DisplayMode.FitScreen;
        }
        this.grabWindowFocus = options.grabWindowFocus;
        this.pointerScope = options.pointerScope;
        this._originalDisplayMode = displayMode;
        let pixelArtSampler;
        let uvPadding;
        let nativeContextAntialiasing;
        let canvasImageRendering;
        let filtering;
        let multiSampleAntialiasing;
        if (typeof options.antialiasing === 'object') {
            ({ pixelArtSampler, nativeContextAntialiasing, multiSampleAntialiasing, filtering, canvasImageRendering } = {
                ...(options.pixelArt ? _Graphics__WEBPACK_IMPORTED_MODULE_13__.DefaultPixelArtOptions : _Graphics__WEBPACK_IMPORTED_MODULE_13__.DefaultAntialiasOptions),
                ...options.antialiasing
            });
        }
        else {
            pixelArtSampler = !!options.pixelArt;
            nativeContextAntialiasing = false;
            multiSampleAntialiasing = options.antialiasing;
            canvasImageRendering = options.antialiasing ? 'auto' : 'pixelated';
            filtering = options.antialiasing ? _Graphics_Filtering__WEBPACK_IMPORTED_MODULE_14__.ImageFiltering.Blended : _Graphics_Filtering__WEBPACK_IMPORTED_MODULE_14__.ImageFiltering.Pixel;
        }
        if (nativeContextAntialiasing && multiSampleAntialiasing) {
            this._logger.warnOnce(`Cannot use antialias setting nativeContextAntialiasing and multiSampleAntialiasing` +
                ` at the same time, they are incompatible settings. If you aren\'t sure use multiSampleAntialiasing`);
        }
        if (options.pixelArt) {
            uvPadding = 0.25;
        }
        if (!options.antialiasing || filtering === _Graphics_Filtering__WEBPACK_IMPORTED_MODULE_14__.ImageFiltering.Pixel) {
            uvPadding = 0;
        }
        // Override with any user option, if non default to .25 for pixel art, 0.01 for everything else
        uvPadding = (_c = (_b = options.uvPadding) !== null && _b !== void 0 ? _b : uvPadding) !== null && _c !== void 0 ? _c : 0.01;
        // Canvas 2D fallback can be flagged on
        let useCanvasGraphicsContext = _Flags__WEBPACK_IMPORTED_MODULE_8__.Flags.isEnabled('use-canvas-context');
        if (!useCanvasGraphicsContext) {
            // Attempt webgl first
            try {
                this.graphicsContext = new _Graphics__WEBPACK_IMPORTED_MODULE_15__.ExcaliburGraphicsContextWebGL({
                    canvasElement: this.canvas,
                    enableTransparency: this.enableCanvasTransparency,
                    pixelArtSampler: pixelArtSampler,
                    antialiasing: nativeContextAntialiasing,
                    multiSampleAntialiasing: multiSampleAntialiasing,
                    uvPadding: uvPadding,
                    powerPreference: options.powerPreference,
                    backgroundColor: options.backgroundColor,
                    snapToPixel: options.snapToPixel,
                    useDrawSorting: options.useDrawSorting,
                    garbageCollector: this.garbageCollectorConfig
                        ? {
                            garbageCollector: this._garbageCollector,
                            collectionInterval: this.garbageCollectorConfig.textureCollectInterval
                        }
                        : null,
                    handleContextLost: (_d = options.handleContextLost) !== null && _d !== void 0 ? _d : this._handleWebGLContextLost,
                    handleContextRestored: options.handleContextRestored
                });
            }
            catch (e) {
                this._logger.warn(`Excalibur could not load webgl for some reason (${e.message}) and loaded a Canvas 2D fallback. ` +
                    `Some features of Excalibur will not work in this mode. \n\n` +
                    'Read more about this issue at https://excaliburjs.com/docs/performance');
                // fallback to canvas in case of failure
                useCanvasGraphicsContext = true;
            }
        }
        if (useCanvasGraphicsContext) {
            this.graphicsContext = new _Graphics__WEBPACK_IMPORTED_MODULE_16__.ExcaliburGraphicsContext2DCanvas({
                canvasElement: this.canvas,
                enableTransparency: this.enableCanvasTransparency,
                antialiasing: nativeContextAntialiasing,
                backgroundColor: options.backgroundColor,
                snapToPixel: options.snapToPixel,
                useDrawSorting: options.useDrawSorting
            });
        }
        this.screen = new _Screen__WEBPACK_IMPORTED_MODULE_12__.Screen({
            canvas: this.canvas,
            context: this.graphicsContext,
            antialiasing: nativeContextAntialiasing,
            canvasImageRendering: canvasImageRendering,
            browser: this.browser,
            viewport: (_e = options.viewport) !== null && _e !== void 0 ? _e : (options.width && options.height ? { width: options.width, height: options.height } : _Screen__WEBPACK_IMPORTED_MODULE_12__.Resolution.SVGA),
            resolution: options.resolution,
            displayMode,
            pixelRatio: options.suppressHiDPIScaling ? 1 : (_f = options.pixelRatio) !== null && _f !== void 0 ? _f : null
        });
        // TODO REMOVE STATIC!!!
        // Set default filtering based on antialiasing
        _Graphics__WEBPACK_IMPORTED_MODULE_17__.TextureLoader.filtering = filtering;
        if (options.backgroundColor) {
            this.backgroundColor = options.backgroundColor.clone();
        }
        this.maxFps = (_g = options.maxFps) !== null && _g !== void 0 ? _g : this.maxFps;
        this.fixedUpdateTimestep = (_h = options.fixedUpdateTimestep) !== null && _h !== void 0 ? _h : this.fixedUpdateTimestep;
        this.fixedUpdateFps = (_j = options.fixedUpdateFps) !== null && _j !== void 0 ? _j : this.fixedUpdateFps;
        this.fixedUpdateTimestep = this.fixedUpdateTimestep || 1000 / this.fixedUpdateFps;
        this.clock = new _Util_Clock__WEBPACK_IMPORTED_MODULE_18__.StandardClock({
            maxFps: this.maxFps,
            tick: this._mainloop.bind(this),
            onFatalException: (e) => this.onFatalException(e)
        });
        this.enableCanvasTransparency = options.enableCanvasTransparency;
        if (typeof options.physics === 'boolean') {
            this.physics = {
                ...(0,_Collision_PhysicsConfig__WEBPACK_IMPORTED_MODULE_19__.getDefaultPhysicsConfig)(),
                enabled: options.physics
            };
        }
        else {
            this.physics = {
                ...(0,_Collision_PhysicsConfig__WEBPACK_IMPORTED_MODULE_19__.getDefaultPhysicsConfig)()
            };
            (0,_Util_Util__WEBPACK_IMPORTED_MODULE_20__.mergeDeep)(this.physics, options.physics);
        }
        this.debug = new _Debug_DebugConfig__WEBPACK_IMPORTED_MODULE_21__.DebugConfig(this);
        this.director = new _Director_Director__WEBPACK_IMPORTED_MODULE_1__.Director(this, options.scenes);
        this.director.events.pipe(this.events);
        this._initialize(options);
        window.___EXCALIBUR_DEVTOOL = this;
        Engine.InstanceCount++;
    }
    _monitorPerformanceThresholdAndTriggerFallback() {
        const { allow } = this._originalOptions.configurePerformanceCanvas2DFallback;
        let { threshold, showPlayerMessage } = this._originalOptions.configurePerformanceCanvas2DFallback;
        if (threshold === undefined) {
            threshold = Engine._DEFAULT_ENGINE_OPTIONS.configurePerformanceCanvas2DFallback.threshold;
        }
        if (showPlayerMessage === undefined) {
            showPlayerMessage = Engine._DEFAULT_ENGINE_OPTIONS.configurePerformanceCanvas2DFallback.showPlayerMessage;
        }
        if (!_Flags__WEBPACK_IMPORTED_MODULE_8__.Flags.isEnabled('use-canvas-context') && allow && this.ready && !this._performanceThresholdTriggered) {
            // Calculate Average fps for last X number of frames after start
            if (this._fpsSamples.length === threshold.numberOfFrames) {
                this._fpsSamples.splice(0, 1);
            }
            this._fpsSamples.push(this.clock.fpsSampler.fps);
            let total = 0;
            for (let i = 0; i < this._fpsSamples.length; i++) {
                total += this._fpsSamples[i];
            }
            const average = total / this._fpsSamples.length;
            if (this._fpsSamples.length === threshold.numberOfFrames) {
                if (average <= threshold.fps) {
                    this._performanceThresholdTriggered = true;
                    this._logger.warn(`Switching to browser 2D Canvas fallback due to performance. Some features of Excalibur will not work in this mode.\n` +
                        "this might mean your browser doesn't have webgl enabled or hardware acceleration is unavailable.\n\n" +
                        'If in Chrome:\n' +
                        '  * Visit Settings > Advanced > System, and ensure "Use Hardware Acceleration" is checked.\n' +
                        '  * Visit chrome://flags/#ignore-gpu-blocklist and ensure "Override software rendering list" is "enabled"\n' +
                        'If in Firefox, visit about:config\n' +
                        '  * Ensure webgl.disabled = false\n' +
                        '  * Ensure webgl.force-enabled = true\n' +
                        '  * Ensure layers.acceleration.force-enabled = true\n\n' +
                        'Read more about this issue at https://excaliburjs.com/docs/performance');
                    if (showPlayerMessage) {
                        this._toaster.toast('Excalibur is encountering performance issues. ' +
                            "It's possible that your browser doesn't have hardware acceleration enabled. " +
                            'Visit [LINK] for more information and potential solutions.', 'https://excaliburjs.com/docs/performance');
                    }
                    this.useCanvas2DFallback();
                    this.emit('fallbackgraphicscontext', this.graphicsContext);
                }
            }
        }
    }
    /**
     * Switches the engine's graphics context to the 2D Canvas.
     * @warning Some features of Excalibur will not work in this mode.
     */
    useCanvas2DFallback() {
        var _a, _b, _c;
        // Swap out the canvas
        const newCanvas = this.canvas.cloneNode(false);
        this.canvas.parentNode.replaceChild(newCanvas, this.canvas);
        this.canvas = newCanvas;
        const options = { ...this._originalOptions, antialiasing: this.screen.antialiasing };
        const displayMode = this._originalDisplayMode;
        // New graphics context
        this.graphicsContext = new _Graphics__WEBPACK_IMPORTED_MODULE_16__.ExcaliburGraphicsContext2DCanvas({
            canvasElement: this.canvas,
            enableTransparency: this.enableCanvasTransparency,
            antialiasing: options.antialiasing,
            backgroundColor: options.backgroundColor,
            snapToPixel: options.snapToPixel,
            useDrawSorting: options.useDrawSorting
        });
        // Reset screen
        if (this.screen) {
            this.screen.dispose();
        }
        this.screen = new _Screen__WEBPACK_IMPORTED_MODULE_12__.Screen({
            canvas: this.canvas,
            context: this.graphicsContext,
            antialiasing: (_a = options.antialiasing) !== null && _a !== void 0 ? _a : true,
            browser: this.browser,
            viewport: (_b = options.viewport) !== null && _b !== void 0 ? _b : (options.width && options.height ? { width: options.width, height: options.height } : _Screen__WEBPACK_IMPORTED_MODULE_12__.Resolution.SVGA),
            resolution: options.resolution,
            displayMode,
            pixelRatio: options.suppressHiDPIScaling ? 1 : (_c = options.pixelRatio) !== null && _c !== void 0 ? _c : null
        });
        this.screen.setCurrentCamera(this.currentScene.camera);
        // Reset pointers
        this.input.pointers.detach();
        const pointerTarget = options && options.pointerScope === _Input_PointerScope__WEBPACK_IMPORTED_MODULE_22__.PointerScope.Document ? document : this.canvas;
        this.input.pointers = this.input.pointers.recreate(pointerTarget, this);
        this.input.pointers.init();
    }
    /**
     * Attempts to completely clean up excalibur resources, including removing the canvas from the dom.
     *
     * To start again you will need to new up an Engine.
     */
    dispose() {
        if (!this._disposed) {
            this._disposed = true;
            this.stop();
            this._garbageCollector.forceCollectAll();
            this.input.toggleEnabled(false);
            this.canvas.parentNode.removeChild(this.canvas);
            this.canvas = null;
            this.screen.dispose();
            this.graphicsContext.dispose();
            this.graphicsContext = null;
            Engine.InstanceCount--;
        }
    }
    isDisposed() {
        return this._disposed;
    }
    /**
     * Returns a BoundingBox of the top left corner of the screen
     * and the bottom right corner of the screen.
     */
    getWorldBounds() {
        return this.screen.getWorldBounds();
    }
    /**
     * Gets the current engine timescale factor (default is 1.0 which is 1:1 time)
     */
    get timescale() {
        return this._timescale;
    }
    /**
     * Sets the current engine timescale factor. Useful for creating slow-motion effects or fast-forward effects
     * when using time-based movement.
     */
    set timescale(value) {
        if (value < 0) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_5__.Logger.getInstance().warnOnce('engine.timescale to a value less than 0 are ignored');
            return;
        }
        this._timescale = value;
    }
    /**
     * Adds a {@apilink Timer} to the {@apilink currentScene}.
     * @param timer  The timer to add to the {@apilink currentScene}.
     */
    addTimer(timer) {
        return this.currentScene.addTimer(timer);
    }
    /**
     * Removes a {@apilink Timer} from the {@apilink currentScene}.
     * @param timer  The timer to remove to the {@apilink currentScene}.
     */
    removeTimer(timer) {
        return this.currentScene.removeTimer(timer);
    }
    /**
     * Adds a {@apilink Scene} to the engine, think of scenes in Excalibur as you
     * would levels or menus.
     * @param key  The name of the scene, must be unique
     * @param scene The scene to add to the engine
     */
    addScene(key, scene) {
        this.director.add(key, scene);
        return this;
    }
    /**
     * @internal
     */
    removeScene(entity) {
        this.director.remove(entity);
    }
    add(entity) {
        if (arguments.length === 2) {
            this.director.add(arguments[0], arguments[1]);
            return;
        }
        const maybeDeferred = this.director.getDeferredScene();
        if (maybeDeferred instanceof _Scene__WEBPACK_IMPORTED_MODULE_23__.Scene) {
            maybeDeferred.add(entity);
        }
        else {
            this.currentScene.add(entity);
        }
    }
    remove(entity) {
        if (entity instanceof _EntityComponentSystem_Entity__WEBPACK_IMPORTED_MODULE_24__.Entity) {
            this.currentScene.remove(entity);
        }
        if (entity instanceof _Scene__WEBPACK_IMPORTED_MODULE_23__.Scene || (0,_Scene__WEBPACK_IMPORTED_MODULE_23__.isSceneConstructor)(entity)) {
            this.removeScene(entity);
        }
        if (typeof entity === 'string') {
            this.removeScene(entity);
        }
    }
    /**
     * Changes the current scene with optionally supplied:
     * * Activation data
     * * Transitions
     * * Loaders
     *
     * Example:
     * ```typescript
     * game.goToScene('myScene', {
     *   sceneActivationData: {any: 'thing at all'},
     *   destinationIn: new FadeInOut({duration: 1000, direction: 'in'}),
     *   sourceOut: new FadeInOut({duration: 1000, direction: 'out'}),
     *   loader: MyLoader
     * });
     * ```
     *
     * Scenes are defined in the Engine constructor
     * ```typescript
     * const engine = new ex.Engine({
        scenes: {...}
      });
     * ```
     * Or by adding dynamically
     *
     * ```typescript
     * engine.addScene('myScene', new ex.Scene());
     * ```
     * @param destinationScene
     * @param options
     */
    async goToScene(destinationScene, options) {
        await this.scope(async () => {
            await this.director.goToScene(destinationScene, options);
        });
    }
    /**
     * Transforms the current x, y from screen coordinates to world coordinates
     * @param point  Screen coordinate to convert
     */
    screenToWorldCoordinates(point) {
        return this.screen.screenToWorldCoordinates(point);
    }
    /**
     * Transforms a world coordinate, to a screen coordinate
     * @param point  World coordinate to convert
     */
    worldToScreenCoordinates(point) {
        return this.screen.worldToScreenCoordinates(point);
    }
    /**
     * Initializes the internal canvas, rendering context, display mode, and native event listeners
     */
    _initialize(options) {
        var _a, _b;
        this.pageScrollPreventionMode = options.scrollPreventionMode;
        // initialize inputs
        const pointerTarget = options && options.pointerScope === _Input_PointerScope__WEBPACK_IMPORTED_MODULE_22__.PointerScope.Document ? document : this.canvas;
        const grabWindowFocus = (_b = (_a = this._originalOptions) === null || _a === void 0 ? void 0 : _a.grabWindowFocus) !== null && _b !== void 0 ? _b : true;
        this.input = new _Input_InputHost__WEBPACK_IMPORTED_MODULE_25__.InputHost({
            pointerTarget,
            grabWindowFocus,
            engine: this
        });
        this.inputMapper = this.input.inputMapper;
        // Issue #385 make use of the visibility api
        // https://developer.mozilla.org/en-US/docs/Web/Guide/User_experience/Using_the_Page_Visibility_API
        this.browser.document.on('visibilitychange', () => {
            if (document.visibilityState === 'hidden') {
                this.events.emit('hidden', new _Events__WEBPACK_IMPORTED_MODULE_26__.HiddenEvent(this));
                this._logger.debug('Window hidden');
            }
            else if (document.visibilityState === 'visible') {
                this.events.emit('visible', new _Events__WEBPACK_IMPORTED_MODULE_26__.VisibleEvent(this));
                this._logger.debug('Window visible');
            }
        });
        if (!this.canvasElementId && !options.canvasElement) {
            document.body.appendChild(this.canvas);
        }
    }
    toggleInputEnabled(enabled) {
        this._inputEnabled = enabled;
        this.input.toggleEnabled(this._inputEnabled);
    }
    onInitialize(engine) {
        // Override me
    }
    /**
     * Gets whether the actor is Initialized
     */
    get isInitialized() {
        return this._isInitialized;
    }
    async _overrideInitialize(engine) {
        if (!this.isInitialized) {
            await this.director.onInitialize();
            await this.onInitialize(engine);
            this.events.emit('initialize', new _Events__WEBPACK_IMPORTED_MODULE_26__.InitializeEvent(engine, this));
            this._isInitialized = true;
        }
    }
    /**
     * Updates the entire state of the game
     * @param elapsed  Number of milliseconds elapsed since the last update.
     */
    _update(elapsed) {
        var _a;
        if (this._isLoading) {
            // suspend updates until loading is finished
            (_a = this._loader) === null || _a === void 0 ? void 0 : _a.onUpdate(this, elapsed);
            // Update input listeners
            this.input.update();
            return;
        }
        // Publish preupdate events
        this.clock.__runScheduledCbs('preupdate');
        this._preupdate(elapsed);
        // process engine level events
        this.currentScene.update(this, elapsed);
        // Update graphics postprocessors
        this.graphicsContext.updatePostProcessors(elapsed);
        // Publish update event
        this.clock.__runScheduledCbs('postupdate');
        this._postupdate(elapsed);
        // Update input listeners
        this.input.update();
    }
    /**
     * @internal
     */
    _preupdate(elapsed) {
        this.emit('preupdate', new _Events__WEBPACK_IMPORTED_MODULE_26__.PreUpdateEvent(this, elapsed, this));
        this.onPreUpdate(this, elapsed);
    }
    /**
     * Safe to override method
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     */
    onPreUpdate(engine, elapsed) {
        // Override me
    }
    /**
     * @internal
     */
    _postupdate(elapsed) {
        this.emit('postupdate', new _Events__WEBPACK_IMPORTED_MODULE_26__.PostUpdateEvent(this, elapsed, this));
        this.onPostUpdate(this, elapsed);
    }
    /**
     * Safe to override method
     * @param engine The reference to the current game engine
     * @param elapsed  The time elapsed since the last update in milliseconds
     */
    onPostUpdate(engine, elapsed) {
        // Override me
    }
    /**
     * Draws the entire game
     * @param elapsed  Number of milliseconds elapsed since the last draw.
     */
    _draw(elapsed) {
        var _a, _b;
        // Use scene background color if present, fallback to engine
        this.graphicsContext.backgroundColor = (_a = this.currentScene.backgroundColor) !== null && _a !== void 0 ? _a : this.backgroundColor;
        this.graphicsContext.beginDrawLifecycle();
        this.graphicsContext.clear();
        this.clock.__runScheduledCbs('predraw');
        this._predraw(this.graphicsContext, elapsed);
        // Drawing nothing else while loading
        if (this._isLoading) {
            if (!this._hideLoader) {
                (_b = this._loader) === null || _b === void 0 ? void 0 : _b.canvas.draw(this.graphicsContext, 0, 0);
                this.clock.__runScheduledCbs('postdraw');
                this.graphicsContext.flush();
                this.graphicsContext.endDrawLifecycle();
            }
            return;
        }
        this.currentScene.draw(this.graphicsContext, elapsed);
        this.clock.__runScheduledCbs('postdraw');
        this._postdraw(this.graphicsContext, elapsed);
        // Flush any pending drawings
        this.graphicsContext.flush();
        this.graphicsContext.endDrawLifecycle();
        this._checkForScreenShots();
    }
    /**
     * @internal
     */
    _predraw(ctx, elapsed) {
        this.emit('predraw', new _Events__WEBPACK_IMPORTED_MODULE_26__.PreDrawEvent(ctx, elapsed, this));
        this.onPreDraw(ctx, elapsed);
    }
    /**
     * Safe to override method to hook into pre draw
     * @param ctx {@link ExcaliburGraphicsContext} for drawing
     * @param elapsed  Number of milliseconds elapsed since the last draw.
     */
    onPreDraw(ctx, elapsed) {
        // Override me
    }
    /**
     * @internal
     */
    _postdraw(ctx, elapsed) {
        this.emit('postdraw', new _Events__WEBPACK_IMPORTED_MODULE_26__.PostDrawEvent(ctx, elapsed, this));
        this.onPostDraw(ctx, elapsed);
    }
    /**
     * Safe to override method to hook into pre draw
     * @param ctx {@link ExcaliburGraphicsContext} for drawing
     * @param elapsed  Number of milliseconds elapsed since the last draw.
     */
    onPostDraw(ctx, elapsed) {
        // Override me
    }
    /**
     * Enable or disable Excalibur debugging functionality.
     * @param toggle a value that debug drawing will be changed to
     */
    showDebug(toggle) {
        this._isDebug = toggle;
    }
    /**
     * Toggle Excalibur debugging functionality.
     */
    toggleDebug() {
        this._isDebug = !this._isDebug;
        return this._isDebug;
    }
    /**
     * Returns true when loading is totally complete and the player has clicked start
     */
    get loadingComplete() {
        return !this._isLoading;
    }
    get ready() {
        return this._isReadyFuture.isCompleted;
    }
    isReady() {
        return this._isReadyFuture.promise;
    }
    async start(sceneNameOrLoader, options) {
        await this.scope(async () => {
            if (!this._compatible) {
                throw new Error('Excalibur is incompatible with your browser');
            }
            this._isLoading = true;
            let loader;
            if (sceneNameOrLoader instanceof _Director_DefaultLoader__WEBPACK_IMPORTED_MODULE_27__.DefaultLoader) {
                loader = sceneNameOrLoader;
            }
            else if (typeof sceneNameOrLoader === 'string') {
                this.director.configureStart(sceneNameOrLoader, options);
                loader = this.director.mainLoader;
            }
            // Start the excalibur clock which drives the mainloop
            this._logger.debug('Starting game clock...');
            this.browser.resume();
            this.clock.start();
            if (this.garbageCollectorConfig) {
                this._garbageCollector.start();
            }
            this._logger.debug('Game clock started');
            await this.load(loader !== null && loader !== void 0 ? loader : new _Director_Loader__WEBPACK_IMPORTED_MODULE_28__.Loader());
            // Initialize before ready
            await this._overrideInitialize(this);
            this._isReadyFuture.resolve();
            this.emit('start', new _Events__WEBPACK_IMPORTED_MODULE_26__.GameStartEvent(this));
            return this._isReadyFuture.promise;
        });
    }
    _mainloop(elapsed) {
        this.scope(() => {
            this.emit('preframe', new _Events__WEBPACK_IMPORTED_MODULE_26__.PreFrameEvent(this, this.stats.prevFrame));
            const elapsedMs = elapsed * this.timescale;
            this.currentFrameElapsedMs = elapsedMs;
            // reset frame stats (reuse existing instances)
            const frameId = this.stats.prevFrame.id + 1;
            this.stats.currFrame.reset();
            this.stats.currFrame.id = frameId;
            this.stats.currFrame.elapsedMs = elapsedMs;
            this.stats.currFrame.fps = this.clock.fpsSampler.fps;
            _Graphics_GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_29__.GraphicsDiagnostics.clear();
            const beforeUpdate = this.clock.now();
            const fixedTimestepMs = this.fixedUpdateTimestep;
            if (this.fixedUpdateTimestep) {
                this._lagMs += elapsedMs;
                while (this._lagMs >= fixedTimestepMs) {
                    this._update(fixedTimestepMs);
                    this._lagMs -= fixedTimestepMs;
                }
            }
            else {
                this._update(elapsedMs);
            }
            const afterUpdate = this.clock.now();
            this.currentFrameLagMs = this._lagMs;
            this._draw(elapsedMs);
            const afterDraw = this.clock.now();
            this.stats.currFrame.duration.update = afterUpdate - beforeUpdate;
            this.stats.currFrame.duration.draw = afterDraw - afterUpdate;
            this.stats.currFrame.graphics.drawnImages = _Graphics_GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_29__.GraphicsDiagnostics.DrawnImagesCount;
            this.stats.currFrame.graphics.drawCalls = _Graphics_GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_29__.GraphicsDiagnostics.DrawCallCount;
            this.emit('postframe', new _Events__WEBPACK_IMPORTED_MODULE_26__.PostFrameEvent(this, this.stats.currFrame));
            this.stats.prevFrame.reset(this.stats.currFrame);
            this._monitorPerformanceThresholdAndTriggerFallback();
        });
    }
    /**
     * Stops Excalibur's main loop, useful for pausing the game.
     */
    stop() {
        if (this.clock.isRunning()) {
            this.emit('stop', new _Events__WEBPACK_IMPORTED_MODULE_26__.GameStopEvent(this));
            this.browser.pause();
            this.clock.stop();
            this._garbageCollector.stop();
            this._logger.debug('Game stopped');
        }
    }
    /**
     * Returns the Engine's running status, Useful for checking whether engine is running or paused.
     */
    isRunning() {
        return this.clock.isRunning();
    }
    /**
     * Takes a screen shot of the current viewport and returns it as an
     * HTML Image Element.
     * @param preserveHiDPIResolution in the case of HiDPI return the full scaled backing image, by default false
     */
    screenshot(preserveHiDPIResolution = false) {
        const screenShotPromise = new Promise((resolve) => {
            this._screenShotRequests.push({ preserveHiDPIResolution, resolve });
        });
        return screenShotPromise;
    }
    _checkForScreenShots() {
        // We must grab the draw buffer before we yield to the browser
        // the draw buffer is cleared after compositing
        // the reason for the asynchrony is setting `preserveDrawingBuffer: true`
        // forces the browser to copy buffers which can have a mass perf impact on mobile
        for (const request of this._screenShotRequests) {
            const finalWidth = request.preserveHiDPIResolution ? this.canvas.width : this.screen.resolution.width;
            const finalHeight = request.preserveHiDPIResolution ? this.canvas.height : this.screen.resolution.height;
            const screenshot = document.createElement('canvas');
            screenshot.width = finalWidth;
            screenshot.height = finalHeight;
            const ctx = screenshot.getContext('2d');
            ctx.imageSmoothingEnabled = this.screen.antialiasing;
            ctx.drawImage(this.canvas, 0, 0, finalWidth, finalHeight);
            const result = new Image();
            const raw = screenshot.toDataURL('image/png');
            result.onload = () => {
                request.resolve(result);
            };
            result.src = raw;
        }
        // Reset state
        this._screenShotRequests.length = 0;
    }
    /**
     * Another option available to you to load resources into the game.
     * Immediately after calling this the game will pause and the loading screen
     * will appear.
     * @param loader  Some {@apilink Loadable} such as a {@apilink Loader} collection, {@apilink Sound}, or {@apilink Texture}.
     */
    async load(loader, hideLoader = false) {
        await this.scope(async () => {
            try {
                // early exit if loaded
                if (loader.isLoaded()) {
                    return;
                }
                this._loader = loader;
                this._isLoading = true;
                this._hideLoader = hideLoader;
                if (loader instanceof _Director_Loader__WEBPACK_IMPORTED_MODULE_28__.Loader) {
                    loader.suppressPlayButton = loader.suppressPlayButton || this._suppressPlayButton;
                }
                this._loader.onInitialize(this);
                await loader.load();
            }
            catch (e) {
                this._logger.error('Error loading resources, things may not behave properly', e);
                await Promise.resolve();
            }
            finally {
                this._isLoading = false;
                this._hideLoader = false;
                this._loader = null;
            }
        });
    }
}
Engine.Context = (0,_Context__WEBPACK_IMPORTED_MODULE_2__.createContext)();
Engine.InstanceCount = 0;
/**
 * Default {@apilink EngineOptions}
 */
Engine._DEFAULT_ENGINE_OPTIONS = {
    width: 0,
    height: 0,
    enableCanvasTransparency: true,
    useDrawSorting: true,
    configurePerformanceCanvas2DFallback: {
        allow: false,
        showPlayerMessage: false,
        threshold: { fps: 20, numberOfFrames: 100 }
    },
    canvasElementId: '',
    canvasElement: undefined,
    enableCanvasContextMenu: false,
    snapToPixel: false,
    antialiasing: true,
    pixelArt: false,
    garbageCollection: true,
    powerPreference: 'high-performance',
    pointerScope: _Input_PointerScope__WEBPACK_IMPORTED_MODULE_22__.PointerScope.Canvas,
    suppressConsoleBootMessage: null,
    suppressMinimumBrowserFeatureDetection: null,
    suppressHiDPIScaling: null,
    suppressPlayButton: null,
    grabWindowFocus: true,
    scrollPreventionMode: ScrollPreventionMode.Canvas,
    backgroundColor: _Color__WEBPACK_IMPORTED_MODULE_30__.Color.fromHex('#2185d0') // Excalibur blue
};


/***/ }),

/***/ "./EntityComponentSystem/Component.ts":
/*!********************************************!*\
  !*** ./EntityComponentSystem/Component.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Component: () => (/* binding */ Component),
/* harmony export */   isComponentCtor: () => (/* binding */ isComponentCtor)
/* harmony export */ });
/**
 *
 */
function isComponentCtor(value) {
    return !!value && !!value.prototype && !!value.prototype.constructor;
}
/**
 * Type guard to check if a component implements clone
 * @param x
 */
function hasClone(x) {
    return !!(x === null || x === void 0 ? void 0 : x.clone);
}
/**
 * Components are containers for state in Excalibur, the are meant to convey capabilities that an Entity possesses
 *
 * Implementations of Component must have a zero-arg constructor to support dependencies
 *
 * ```typescript
 * class MyComponent extends ex.Component {
 *   // zero arg support required if you want to use component dependencies
 *   constructor(public optionalPos?: ex.Vector) {}
 * }
 * ```
 */
class Component {
    constructor() {
        // TODO maybe generate a unique id?
        /**
         * Current owning {@apilink Entity}, if any, of this component. Null if not added to any {@apilink Entity}
         */
        this.owner = undefined;
    }
    /**
     * Clones any properties on this component, if that property value has a `clone()` method it will be called
     */
    clone() {
        const newComponent = new this.constructor();
        for (const prop in this) {
            if (this.hasOwnProperty(prop)) {
                const val = this[prop];
                if (hasClone(val) && prop !== 'owner' && prop !== 'clone') {
                    newComponent[prop] = val.clone();
                }
                else {
                    newComponent[prop] = val;
                }
            }
        }
        return newComponent;
    }
}


/***/ }),

/***/ "./EntityComponentSystem/Components/MotionComponent.ts":
/*!*************************************************************!*\
  !*** ./EntityComponentSystem/Components/MotionComponent.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MotionComponent: () => (/* binding */ MotionComponent)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Component */ "./EntityComponentSystem/Component.ts");


class MotionComponent extends _Component__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        /**
         * The velocity of an entity in pixels per second
         */
        this.vel = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        /**
         * The acceleration of entity in pixels per second^2
         */
        this.acc = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        /**
         * The scale rate of change in scale units per second
         */
        this.scaleFactor = _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector.Zero;
        /**
         * The angular velocity which is how quickly the entity is rotating in radians per second
         */
        this.angularVelocity = 0;
        /**
         * The amount of torque applied to the entity, angular acceleration is torque * inertia
         */
        this.torque = 0;
        /**
         * Inertia can be thought of as the resistance to motion
         */
        this.inertia = 1;
    }
}


/***/ }),

/***/ "./EntityComponentSystem/Components/TransformComponent.ts":
/*!****************************************************************!*\
  !*** ./EntityComponentSystem/Components/TransformComponent.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TransformComponent: () => (/* binding */ TransformComponent)
/* harmony export */ });
/* harmony import */ var _Math_coord_plane__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Math/coord-plane */ "./Math/coord-plane.ts");
/* harmony import */ var _Math_transform__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Math/transform */ "./Math/transform.ts");
/* harmony import */ var _Component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Component */ "./EntityComponentSystem/Component.ts");
/* harmony import */ var _Util_Observable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Util/Observable */ "./Util/Observable.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Util/Log */ "./Util/Log.ts");





class TransformComponent extends _Component__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_1__.Logger.getInstance();
        this._parentComponent = null;
        this._transform = new _Math_transform__WEBPACK_IMPORTED_MODULE_2__.Transform();
        this._addChildTransform = (child) => {
            const childTxComponent = child.get(TransformComponent);
            if (childTxComponent) {
                childTxComponent._transform.parent = this._transform;
                childTxComponent._parentComponent = this;
            }
        };
        /**
         * Observable that emits when the z index changes on this component
         */
        this.zIndexChanged$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_3__.Observable();
        this._coordPlane = _Math_coord_plane__WEBPACK_IMPORTED_MODULE_4__.CoordPlane.World;
    }
    get() {
        return this._transform;
    }
    onAdd(owner) {
        for (const child of owner.children) {
            this._addChildTransform(child);
        }
        owner.childrenAdded$.subscribe((child) => this._addChildTransform(child));
        owner.childrenRemoved$.subscribe((child) => {
            const childTxComponent = child.get(TransformComponent);
            if (childTxComponent) {
                childTxComponent._transform.parent = null;
                childTxComponent._parentComponent = null;
            }
        });
    }
    onRemove(_previousOwner) {
        this._transform.parent = null;
        this._parentComponent = null;
    }
    /**
     * The z-index ordering of the entity, a higher values are drawn on top of lower values.
     * For example z=99 would be drawn on top of z=0.
     */
    get z() {
        return this._transform.z;
    }
    set z(val) {
        const oldz = this._transform.z;
        this._transform.z = val;
        if (oldz !== val) {
            this.zIndexChanged$.notifyAll(val);
        }
    }
    get globalZ() {
        return this._transform.globalZ;
    }
    set globalZ(z) {
        this._transform.globalZ = z;
    }
    /**
     * The {@apilink CoordPlane | `coordinate plane`} for this transform for the entity.
     */
    get coordPlane() {
        if (this._parentComponent) {
            return this._parentComponent.coordPlane;
        }
        return this._coordPlane;
    }
    set coordPlane(value) {
        var _a;
        if (!this._parentComponent) {
            this._coordPlane = value;
        }
        else {
            this._logger.warn(`Cannot set coordinate plane on child entity ${(_a = this.owner) === null || _a === void 0 ? void 0 : _a.name}, children inherit their coordinate plane from their parents.`);
        }
    }
    get pos() {
        return this._transform.pos;
    }
    set pos(v) {
        this._transform.pos = v;
    }
    get globalPos() {
        return this._transform.globalPos;
    }
    set globalPos(v) {
        this._transform.globalPos = v;
    }
    get rotation() {
        return this._transform.rotation;
    }
    set rotation(rotation) {
        this._transform.rotation = rotation;
    }
    get globalRotation() {
        return this._transform.globalRotation;
    }
    set globalRotation(rotation) {
        this._transform.globalRotation = rotation;
    }
    get scale() {
        return this._transform.scale;
    }
    set scale(v) {
        this._transform.scale = v;
    }
    get globalScale() {
        return this._transform.globalScale;
    }
    set globalScale(v) {
        this._transform.globalScale = v;
    }
    applyInverse(v) {
        return this._transform.applyInverse(v);
    }
    apply(v) {
        return this._transform.apply(v);
    }
    clone() {
        const component = new TransformComponent();
        component._transform = this._transform.clone();
        return component;
    }
}


/***/ }),

/***/ "./EntityComponentSystem/Entity.ts":
/*!*****************************************!*\
  !*** ./EntityComponentSystem/Entity.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddedComponent: () => (/* binding */ AddedComponent),
/* harmony export */   Entity: () => (/* binding */ Entity),
/* harmony export */   EntityEvents: () => (/* binding */ EntityEvents),
/* harmony export */   RemovedComponent: () => (/* binding */ RemovedComponent),
/* harmony export */   isAddedComponent: () => (/* binding */ isAddedComponent),
/* harmony export */   isRemovedComponent: () => (/* binding */ isRemovedComponent)
/* harmony export */ });
/* harmony import */ var _Component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Component */ "./EntityComponentSystem/Component.ts");
/* harmony import */ var _Util_Observable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util/Observable */ "./Util/Observable.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Events */ "./Events.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EventEmitter */ "./EventEmitter.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");







/**
 * AddedComponent message
 */
class AddedComponent {
    constructor(data) {
        this.data = data;
        this.type = 'Component Added';
    }
}
/**
 * Type guard to know if message is f an Added Component
 */
function isAddedComponent(x) {
    return !!x && x.type === 'Component Added';
}
/**
 * RemovedComponent message
 */
class RemovedComponent {
    constructor(data) {
        this.data = data;
        this.type = 'Component Removed';
    }
}
/**
 * Type guard to know if message is for a Removed Component
 */
function isRemovedComponent(x) {
    return !!x && x.type === 'Component Removed';
}
const EntityEvents = {
    Add: 'add',
    Remove: 'remove',
    Initialize: 'initialize',
    PreUpdate: 'preupdate',
    PostUpdate: 'postupdate',
    Kill: 'kill'
};
/**
 * An Entity is the base type of anything that can have behavior in Excalibur, they are part of the built in entity component system
 *
 * Entities can be strongly typed with the components they contain
 *
 * ```typescript
 * const entity = new Entity<ComponentA | ComponentB>();
 * entity.components.a; // Type ComponentA
 * entity.components.b; // Type ComponentB
 * ```
 */
class Entity {
    constructor(componentsOrOptions, name) {
        /**
         * The unique identifier for the entity
         */
        this.id = Entity._ID++;
        this.name = `Entity#${this.id}`;
        /**
         * Listen to or emit events for an entity
         */
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this._tags = new Set();
        this.componentAdded$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        this.componentRemoved$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        this.tagAdded$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        this.tagRemoved$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Current components on the entity
         *
         * **Do not modify**
         *
         * Use addComponent/removeComponent otherwise the ECS will not be notified of changes.
         */
        this.components = new Map();
        this.componentValues = [];
        this._componentsToRemove = [];
        /**
         * The current scene that the entity is in, if any
         */
        this.scene = null;
        /**
         * Whether this entity is active, if set to false it will be reclaimed
         */
        this.isActive = true;
        this._parent = null;
        this.childrenAdded$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        this.childrenRemoved$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        this._children = [];
        this._isInitialized = false;
        this._isAdded = false;
        let componentsToAdd;
        let nameToAdd;
        let silence = false;
        if (Array.isArray(componentsOrOptions)) {
            componentsToAdd = componentsOrOptions;
            nameToAdd = name;
        }
        else if (componentsOrOptions && typeof componentsOrOptions === 'object') {
            const { components, name, silenceWarnings } = componentsOrOptions;
            componentsToAdd = components !== null && components !== void 0 ? components : [];
            nameToAdd = name;
            silence = !!silenceWarnings;
        }
        if (nameToAdd) {
            this.name = nameToAdd;
        }
        if (componentsToAdd) {
            for (const component of componentsToAdd) {
                this.addComponent(component);
            }
        }
        if (true) {
            if (!silence) {
                setTimeout(() => {
                    if (!this.scene && !this.isInitialized) {
                        _Util_Log__WEBPACK_IMPORTED_MODULE_2__.Logger.getInstance().warn(`Entity "${this.name || this.id}" was not added to a scene.`);
                    }
                }, 5000);
            }
        }
    }
    /**
     * Whether this entity is active, if set to false it will be reclaimed
     * @deprecated use isActive
     */
    get active() {
        return this.isActive;
    }
    /**
     * Whether this entity is active, if set to false it will be reclaimed
     * @deprecated use isActive
     */
    set active(val) {
        this.isActive = val;
    }
    /**
     * Kill the entity, means it will no longer be updated. Kills are deferred to the end of the update.
     * If parented it will be removed from the parent when killed.
     */
    kill() {
        if (this.isActive) {
            this.isActive = false;
            this.unparent();
        }
        this.emit('kill', new _Events__WEBPACK_IMPORTED_MODULE_3__.KillEvent(this));
    }
    isKilled() {
        return !this.isActive;
    }
    /**
     * Specifically get the tags on the entity from {@apilink TagsComponent}
     */
    get tags() {
        return this._tags;
    }
    /**
     * Check if a tag exists on the entity
     * @param tag name to check for
     */
    hasTag(tag) {
        return this._tags.has(tag);
    }
    /**
     * Adds a tag to an entity
     * @param tag
     */
    addTag(tag) {
        this._tags.add(tag);
        this.tagAdded$.notifyAll(tag);
        return this;
    }
    /**
     * Removes a tag on the entity
     *
     * Removals are deferred until the end of update
     * @param tag
     */
    removeTag(tag) {
        this._tags.delete(tag);
        this.tagRemoved$.notifyAll(tag);
        return this;
    }
    /**
     * The types of the components on the Entity
     */
    get types() {
        return Array.from(this.components.keys());
    }
    /**
     * Returns all component instances on entity
     */
    getComponents() {
        return Array.from(this.components.values());
    }
    /**
     * Verifies that an entity has all the required types
     * @param requiredTypes
     */
    hasAll(requiredTypes) {
        for (let i = 0; i < requiredTypes.length; i++) {
            if (!this.components.has(requiredTypes[i])) {
                return false;
            }
        }
        return true;
    }
    /**
     * Verifies that an entity has all the required tags
     * @param requiredTags
     */
    hasAllTags(requiredTags) {
        for (let i = 0; i < requiredTags.length; i++) {
            if (!this.tags.has(requiredTags[i])) {
                return false;
            }
        }
        return true;
    }
    get(type) {
        return this.components.get(type);
    }
    get parent() {
        return this._parent;
    }
    /**
     * Get the direct children of this entity
     */
    get children() {
        return this._children;
    }
    /**
     * Unparents this entity, if there is a parent. Otherwise it does nothing.
     */
    unparent() {
        if (this._parent) {
            this._parent.removeChild(this);
            this._parent = null;
        }
    }
    /**
     * Adds an entity to be a child of this entity
     * @param entity
     */
    addChild(entity) {
        if (entity.parent === null) {
            if (this.getAncestors().includes(entity)) {
                throw new Error('Cycle detected, cannot add entity');
            }
            this._children.push(entity);
            entity._parent = this;
            this.childrenAdded$.notifyAll(entity);
        }
        else {
            throw new Error('Entity already has a parent, cannot add without unparenting');
        }
        return this;
    }
    /**
     * Remove an entity from children if it exists
     * @param entity
     */
    removeChild(entity) {
        if (entity.parent === this) {
            (0,_Util_Util__WEBPACK_IMPORTED_MODULE_4__.removeItemFromArray)(entity, this._children);
            entity._parent = null;
            this.childrenRemoved$.notifyAll(entity);
        }
        return this;
    }
    /**
     * Removes all children from this entity
     */
    removeAllChildren() {
        // Avoid modifying the array issue by walking backwards
        for (let i = this.children.length - 1; i >= 0; i--) {
            this.removeChild(this.children[i]);
        }
        return this;
    }
    /**
     * Returns a list of parent entities starting with the topmost parent. Includes the current entity.
     */
    getAncestors() {
        const result = [this];
        let current = this.parent;
        while (current) {
            result.push(current);
            current = current.parent;
        }
        return result.reverse();
    }
    /**
     * Returns a list of all the entities that descend from this entity. Includes the current entity.
     */
    getDescendants() {
        let result = [this];
        let queue = [this];
        while (queue.length > 0) {
            const curr = queue.pop();
            if (curr) {
                queue = queue.concat(curr.children);
                result = result.concat(curr.children);
            }
        }
        return result;
    }
    /**
     * Creates a deep copy of the entity and a copy of all its components
     */
    clone() {
        const newEntity = new Entity();
        for (const c of this.types) {
            const componentInstance = this.get(c);
            if (componentInstance) {
                newEntity.addComponent(componentInstance.clone());
            }
        }
        for (const child of this.children) {
            newEntity.addChild(child.clone());
        }
        return newEntity;
    }
    /**
     * Adds a copy of all the components from another template entity as a "prefab"
     * @param templateEntity Entity to use as a template
     * @param force Force component replacement if it already exists on the target entity
     */
    addTemplate(templateEntity, force = false) {
        for (const c of templateEntity.getComponents()) {
            this.addComponent(c.clone(), force);
        }
        for (const child of templateEntity.children) {
            this.addChild(child.clone().addTemplate(child));
        }
        return this;
    }
    _getClassHierarchyRoot(componentType) {
        var _a, _b;
        let current = componentType;
        let parent = (_a = Object.getPrototypeOf(current.prototype)) === null || _a === void 0 ? void 0 : _a.constructor;
        while (parent && parent !== Object && parent !== _Component__WEBPACK_IMPORTED_MODULE_5__.Component) {
            current = parent;
            parent = (_b = Object.getPrototypeOf(current.prototype)) === null || _b === void 0 ? void 0 : _b.constructor;
        }
        return current;
    }
    /**
     * Adds a component to the entity
     * @param component Component or Entity to add copy of components from
     * @param force Optionally overwrite any existing components of the same type
     */
    addComponent(component, force = false) {
        // if component already exists, skip if not forced
        if (this.has(component.constructor)) {
            if (force) {
                // Remove existing component type if exists when forced
                this.removeComponent(component.constructor, true);
            }
            else {
                // early exit component exits
                return this;
            }
        }
        // TODO circular dependencies will be a problem
        if (component.dependencies && component.dependencies.length) {
            for (const ctor of component.dependencies) {
                this.addComponent(new ctor());
            }
        }
        component.owner = this;
        const rootComponent = this._getClassHierarchyRoot(component.constructor);
        this.components.set(rootComponent, component);
        this.components.set(component.constructor, component);
        this.componentValues.push(component);
        if (component.onAdd) {
            component.onAdd(this);
        }
        this.componentAdded$.notifyAll(component);
        return this;
    }
    /**
     * Removes a component from the entity, by default removals are deferred to the end of entity update to avoid consistency issues
     *
     * Components can be force removed with the `force` flag, the removal is not deferred and happens immediately
     * @param typeOrInstance
     * @param force
     */
    removeComponent(typeOrInstance, force = false) {
        let type;
        if ((0,_Component__WEBPACK_IMPORTED_MODULE_5__.isComponentCtor)(typeOrInstance)) {
            type = typeOrInstance;
        }
        else {
            type = typeOrInstance.constructor;
        }
        if (force) {
            const componentToRemove = this.components.get(type);
            if (componentToRemove) {
                this.componentRemoved$.notifyAll(componentToRemove);
                componentToRemove.owner = undefined;
                if (componentToRemove.onRemove) {
                    componentToRemove.onRemove(this);
                }
                const componentIndex = this.componentValues.indexOf(componentToRemove);
                if (componentIndex > -1) {
                    this.componentValues.splice(componentIndex, 1);
                }
            }
            const rootComponent = this._getClassHierarchyRoot(type);
            this.components.delete(rootComponent);
            this.components.delete(type); // remove after the notify to preserve typing
        }
        else {
            this._componentsToRemove.push(type);
        }
        return this;
    }
    clearComponents() {
        const components = this.types;
        for (const c of components) {
            this.removeComponent(c);
        }
    }
    /**
     * @hidden
     * @internal
     */
    processComponentRemoval() {
        for (const type of this._componentsToRemove) {
            this.removeComponent(type, true);
        }
        this._componentsToRemove.length = 0;
    }
    /**
     * Check if a component type exists
     * @param type
     */
    has(type) {
        return this.components.has(type);
    }
    /**
     * Gets whether the actor is Initialized
     */
    get isInitialized() {
        return this._isInitialized;
    }
    get isAdded() {
        return this._isAdded;
    }
    /**
     * Initializes this entity, meant to be called by the Scene before first update not by users of Excalibur.
     *
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     * @internal
     */
    _initialize(engine) {
        if (!this.isInitialized) {
            this.onInitialize(engine);
            this.events.emit('initialize', new _Events__WEBPACK_IMPORTED_MODULE_3__.InitializeEvent(engine, this));
            this._isInitialized = true;
        }
    }
    /**
     * Adds this Actor, meant to be called by the Scene when Actor is added.
     *
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     * @internal
     */
    _add(engine) {
        if (!this.isAdded && this.isActive) {
            this.onAdd(engine);
            this.events.emit('add', new _Events__WEBPACK_IMPORTED_MODULE_3__.AddEvent(engine, this));
            this._isAdded = true;
        }
    }
    /**
     * Removes Actor, meant to be called by the Scene when Actor is added.
     *
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     * @internal
     */
    _remove(engine) {
        if (this.isAdded && !this.isActive) {
            this.onRemove(engine);
            this.events.emit('remove', new _Events__WEBPACK_IMPORTED_MODULE_3__.RemoveEvent(engine, this));
            this._isAdded = false;
        }
    }
    /**
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     *
     * Internal _preupdate handler for {@apilink onPreUpdate} lifecycle event
     * @internal
     */
    _preupdate(engine, elapsed) {
        this.events.emit('preupdate', new _Events__WEBPACK_IMPORTED_MODULE_3__.PreUpdateEvent(engine, elapsed, this));
        this.onPreUpdate(engine, elapsed);
    }
    /**
     * It is not recommended that internal excalibur methods be overridden, do so at your own risk.
     *
     * Internal _preupdate handler for {@apilink onPostUpdate} lifecycle event
     * @internal
     */
    _postupdate(engine, elapsed) {
        this.events.emit('postupdate', new _Events__WEBPACK_IMPORTED_MODULE_3__.PostUpdateEvent(engine, elapsed, this));
        this.onPostUpdate(engine, elapsed);
    }
    /**
     * `onInitialize` is called before the first update of the entity. This method is meant to be
     * overridden.
     *
     * Synonymous with the event handler `.on('initialize', (evt) => {...})`
     */
    onInitialize(engine) {
        // Override me
    }
    /**
     * `onAdd` is called when Actor is added to scene. This method is meant to be
     * overridden.
     *
     * Synonymous with the event handler `.on('add', (evt) => {...})`
     */
    onAdd(engine) {
        // Override me
    }
    /**
     * `onRemove` is called when Actor is added to scene. This method is meant to be
     * overridden.
     *
     * Synonymous with the event handler `.on('remove', (evt) => {...})`
     */
    onRemove(engine) {
        // Override me
    }
    /**
     * Safe to override onPreUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPreUpdate` is called directly before an entity is updated.
     */
    onPreUpdate(engine, elapsed) {
        // Override me
    }
    /**
     * Safe to override onPostUpdate lifecycle event handler. Synonymous with `.on('postupdate', (evt) =>{...})`
     *
     * `onPostUpdate` is called directly after an entity is updated.
     */
    onPostUpdate(engine, elapsed) {
        // Override me
    }
    /**
     *
     * Entity update lifecycle, called internally
     * @internal
     * @param engine
     * @param elapsed
     */
    update(engine, elapsed) {
        this._initialize(engine);
        this._add(engine);
        this._preupdate(engine, elapsed);
        for (const child of this.children) {
            child.update(engine, elapsed);
        }
        this._postupdate(engine, elapsed);
        this._remove(engine);
    }
    emit(eventName, event) {
        this.events.emit(eventName, event);
    }
    on(eventName, handler) {
        return this.events.on(eventName, handler);
    }
    once(eventName, handler) {
        return this.events.once(eventName, handler);
    }
    off(eventName, handler) {
        if (handler) {
            this.events.off(eventName, handler);
        }
        else {
            this.events.off(eventName);
        }
    }
}
Entity._ID = 0;


/***/ }),

/***/ "./EntityComponentSystem/EntityManager.ts":
/*!************************************************!*\
  !*** ./EntityComponentSystem/EntityManager.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EntityManager: () => (/* binding */ EntityManager)
/* harmony export */ });
/* harmony import */ var _Entity__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Entity */ "./EntityComponentSystem/Entity.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");


// Add/Remove entities and components
class EntityManager {
    constructor(_world) {
        this._world = _world;
        this.entities = [];
        this._entityIndex = {};
        this._childAddedHandlerMap = new Map();
        this._childRemovedHandlerMap = new Map();
        this._createChildAddedHandler = () => (e) => {
            this.addEntity(e);
        };
        this._createChildRemovedHandler = () => (e) => {
            this.removeEntity(e, false);
        };
        this._entitiesToRemove = [];
    }
    /**
     * Runs the entity lifecycle
     * @param scene
     * @param elapsed
     */
    updateEntities(scene, elapsed) {
        for (let entityIndex = 0; entityIndex < this.entities.length; entityIndex++) {
            const entity = this.entities[entityIndex];
            entity.update(scene.engine, elapsed);
            if (!entity.isActive) {
                this.removeEntity(entity);
            }
        }
    }
    findEntitiesForRemoval() {
        for (let entityIndex = 0; entityIndex < this.entities.length; entityIndex++) {
            const entity = this.entities[entityIndex];
            if (!entity.isActive) {
                this.removeEntity(entity);
            }
        }
    }
    /**
     * Adds an entity to be tracked by the EntityManager
     * @param entity
     */
    addEntity(entity) {
        entity.isActive = true;
        entity.scene = this._world.scene;
        if (entity && !this._entityIndex[entity.id]) {
            this._entityIndex[entity.id] = entity;
            this.entities.push(entity);
            this._world.queryManager.addEntity(entity);
            // if entity has children
            entity.children.forEach((c) => {
                c.scene = entity.scene;
                this.addEntity(c);
            });
            const childAdded = this._createChildAddedHandler();
            this._childAddedHandlerMap.set(entity, childAdded);
            const childRemoved = this._createChildRemovedHandler();
            this._childRemovedHandlerMap.set(entity, childRemoved);
            entity.childrenAdded$.subscribe(childAdded);
            entity.childrenRemoved$.subscribe(childRemoved);
        }
    }
    removeEntity(idOrEntity, deferred = true) {
        var _a, _b;
        let id = 0;
        if (idOrEntity instanceof _Entity__WEBPACK_IMPORTED_MODULE_0__.Entity) {
            id = idOrEntity.id;
        }
        else {
            id = idOrEntity;
        }
        const entity = this._entityIndex[id];
        if (entity && entity.isActive) {
            entity.isActive = false;
        }
        if (entity && deferred) {
            this._entitiesToRemove.push(entity);
            return;
        }
        delete this._entityIndex[id];
        if (entity) {
            entity.scene = null;
            (0,_Util_Util__WEBPACK_IMPORTED_MODULE_1__.removeItemFromArray)(entity, this.entities);
            this._world.queryManager.removeEntity(entity);
            // if entity has children
            entity.children.forEach((c) => {
                c.scene = null;
                this.removeEntity(c, deferred);
            });
            const childAddedHandler = this._childAddedHandlerMap.get(entity);
            if (childAddedHandler) {
                entity.childrenAdded$.unsubscribe(childAddedHandler);
            }
            const childRemovedHandler = this._childRemovedHandlerMap.get(entity);
            if (childRemovedHandler) {
                entity.childrenRemoved$.unsubscribe(childRemovedHandler);
            }
            // stats
            if ((_b = (_a = this._world) === null || _a === void 0 ? void 0 : _a.scene) === null || _b === void 0 ? void 0 : _b.engine) {
                this._world.scene.engine.stats.currFrame.actors.killed++;
            }
        }
    }
    processEntityRemovals() {
        for (let entityIndex = 0; entityIndex < this._entitiesToRemove.length; entityIndex++) {
            const entity = this._entitiesToRemove[entityIndex];
            if (entity.isActive) {
                continue;
            }
            this.removeEntity(entity, false);
        }
        this._entitiesToRemove.length = 0;
    }
    processComponentRemovals() {
        for (let entityIndex = 0; entityIndex < this.entities.length; entityIndex++) {
            const entity = this.entities[entityIndex];
            entity.processComponentRemoval();
        }
    }
    getById(id) {
        return this._entityIndex[id];
    }
    getByName(name) {
        return this.entities.filter((e) => e.name === name);
    }
    clear() {
        for (let i = this.entities.length - 1; i >= 0; i--) {
            this.removeEntity(this.entities[i]);
        }
    }
}


/***/ }),

/***/ "./EntityComponentSystem/Priority.ts":
/*!*******************************************!*\
  !*** ./EntityComponentSystem/Priority.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SystemPriority: () => (/* binding */ SystemPriority)
/* harmony export */ });
/**
 * Higher priorities run earlier than others in the system update
 */
const SystemPriority = {
    Highest: -Infinity,
    Higher: -5,
    Average: 0,
    Lower: 5,
    Lowest: Infinity
};


/***/ }),

/***/ "./EntityComponentSystem/Query.ts":
/*!****************************************!*\
  !*** ./EntityComponentSystem/Query.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Query: () => (/* binding */ Query)
/* harmony export */ });
/* harmony import */ var _Util_Observable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Util/Observable */ "./Util/Observable.ts");

/**
 * Represents query for entities that match a list of types that is cached and observable
 *
 * Queries can be strongly typed by supplying a type union in the optional type parameter
 * ```typescript
 * const queryAB = new ex.Query<ComponentTypeA | ComponentTypeB>(['A', 'B']);
 * ```
 */
class Query {
    constructor(requiredComponents) {
        this.requiredComponents = requiredComponents;
        this.components = new Set();
        this.entities = [];
        /**
         * This fires right after the component is added
         */
        this.entityAdded$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_0__.Observable();
        /**
         * This fires right before the component is actually removed from the entity, it will still be available for cleanup purposes
         */
        this.entityRemoved$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_0__.Observable();
        if (requiredComponents.length === 0) {
            throw new Error('Cannot create query without components');
        }
        for (const type of requiredComponents) {
            this.components.add(type);
        }
        this.id = Query.createId(requiredComponents);
    }
    static createId(requiredComponents) {
        // TODO what happens if a user defines the same type name as a built in type
        // ! TODO this could be dangerous depending on the bundler's settings for names
        // Maybe some kind of hash function is better here?
        return requiredComponents
            .slice()
            .map((c) => c.name)
            .sort()
            .join('-');
    }
    /**
     * Potentially adds an entity to a query index, returns true if added, false if not
     * @param entity
     */
    checkAndAdd(entity) {
        if (!this.entities.includes(entity) && entity.hasAll(Array.from(this.components))) {
            this.entities.push(entity);
            this.entityAdded$.notifyAll(entity);
            return true;
        }
        return false;
    }
    removeEntity(entity) {
        const index = this.entities.indexOf(entity);
        if (index > -1) {
            this.entities.splice(index, 1);
            this.entityRemoved$.notifyAll(entity);
        }
    }
    /**
     * Returns a list of entities that match the query
     * @param sort Optional sorting function to sort entities returned from the query
     */
    getEntities(sort) {
        if (sort) {
            this.entities.sort(sort);
        }
        return this.entities;
    }
}


/***/ }),

/***/ "./EntityComponentSystem/QueryManager.ts":
/*!***********************************************!*\
  !*** ./EntityComponentSystem/QueryManager.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   QueryManager: () => (/* binding */ QueryManager)
/* harmony export */ });
/* harmony import */ var _Query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Query */ "./EntityComponentSystem/Query.ts");
/* harmony import */ var _TagQuery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TagQuery */ "./EntityComponentSystem/TagQuery.ts");


/**
 * The query manager is responsible for updating all queries when entities/components change
 */
class QueryManager {
    constructor(_world) {
        this._world = _world;
        this._queries = new Map();
        this._addComponentHandlers = new Map();
        this._removeComponentHandlers = new Map();
        this._componentToQueriesIndex = new Map();
        this._tagQueries = new Map();
        this._addTagHandlers = new Map();
        this._removeTagHandlers = new Map();
        this._tagToQueriesIndex = new Map();
        this._createAddComponentHandler = (entity) => (c) => {
            this.addComponent(entity, c);
        };
        this._createRemoveComponentHandler = (entity) => (c) => {
            this.removeComponent(entity, c);
        };
        this._createAddTagHandler = (entity) => (tag) => {
            this.addTag(entity, tag);
        };
        this._createRemoveTagHandler = (entity) => (tag) => {
            this.removeTag(entity, tag);
        };
    }
    createQuery(requiredComponents) {
        const id = _Query__WEBPACK_IMPORTED_MODULE_0__.Query.createId(requiredComponents);
        if (this._queries.has(id)) {
            // short circuit if query is already created
            return this._queries.get(id);
        }
        const query = new _Query__WEBPACK_IMPORTED_MODULE_0__.Query(requiredComponents);
        this._queries.set(query.id, query);
        // index maintenance
        for (const component of requiredComponents) {
            const queries = this._componentToQueriesIndex.get(component);
            if (!queries) {
                this._componentToQueriesIndex.set(component, [query]);
            }
            else {
                queries.push(query);
            }
        }
        for (const entity of this._world.entities) {
            this.addEntity(entity);
        }
        return query;
    }
    createTagQuery(requiredTags) {
        const id = _TagQuery__WEBPACK_IMPORTED_MODULE_1__.TagQuery.createId(requiredTags);
        if (this._tagQueries.has(id)) {
            // short circuit if query is already created
            return this._tagQueries.get(id);
        }
        const query = new _TagQuery__WEBPACK_IMPORTED_MODULE_1__.TagQuery(requiredTags);
        this._tagQueries.set(query.id, query);
        // index maintenance
        for (const tag of requiredTags) {
            const queries = this._tagToQueriesIndex.get(tag);
            if (!queries) {
                this._tagToQueriesIndex.set(tag, [query]);
            }
            else {
                queries.push(query);
            }
        }
        for (const entity of this._world.entities) {
            this.addEntity(entity);
        }
        return query;
    }
    /**
     * Scans queries and locates any that need this entity added
     * @param entity
     */
    addEntity(entity) {
        const maybeAddComponent = this._addComponentHandlers.get(entity);
        const maybeRemoveComponent = this._removeComponentHandlers.get(entity);
        const addComponent = maybeAddComponent !== null && maybeAddComponent !== void 0 ? maybeAddComponent : this._createAddComponentHandler(entity);
        const removeComponent = maybeRemoveComponent !== null && maybeRemoveComponent !== void 0 ? maybeRemoveComponent : this._createRemoveComponentHandler(entity);
        this._addComponentHandlers.set(entity, addComponent);
        this._removeComponentHandlers.set(entity, removeComponent);
        const maybeAddTag = this._addTagHandlers.get(entity);
        const maybeRemoveTag = this._removeTagHandlers.get(entity);
        const addTag = maybeAddTag !== null && maybeAddTag !== void 0 ? maybeAddTag : this._createAddTagHandler(entity);
        const removeTag = maybeRemoveTag !== null && maybeRemoveTag !== void 0 ? maybeRemoveTag : this._createRemoveTagHandler(entity);
        this._addTagHandlers.set(entity, addTag);
        this._removeTagHandlers.set(entity, removeTag);
        for (const query of this._queries.values()) {
            query.checkAndAdd(entity);
        }
        for (const tagQuery of this._tagQueries.values()) {
            tagQuery.checkAndAdd(entity);
        }
        entity.componentAdded$.subscribe(addComponent);
        entity.componentRemoved$.subscribe(removeComponent);
        entity.tagAdded$.subscribe(addTag);
        entity.tagRemoved$.subscribe(removeTag);
    }
    /**
     * Scans queries and locates any that need this entity removed
     * @param entity
     */
    removeEntity(entity) {
        // Handle components
        const addComponent = this._addComponentHandlers.get(entity);
        const removeComponent = this._removeComponentHandlers.get(entity);
        for (const query of this._queries.values()) {
            query.removeEntity(entity);
        }
        if (addComponent) {
            entity.componentAdded$.unsubscribe(addComponent);
        }
        if (removeComponent) {
            entity.componentRemoved$.unsubscribe(removeComponent);
        }
        // Handle tags
        const addTag = this._addTagHandlers.get(entity);
        const removeTag = this._removeTagHandlers.get(entity);
        for (const tagQuery of this._tagQueries.values()) {
            tagQuery.removeEntity(entity);
        }
        if (addTag) {
            entity.tagAdded$.unsubscribe(addTag);
        }
        if (removeTag) {
            entity.tagRemoved$.unsubscribe(removeTag);
        }
    }
    /**
     * Updates any queries when a component is added to an entity
     * @param entity
     * @param component
     */
    addComponent(entity, component) {
        var _a;
        const queries = (_a = this._componentToQueriesIndex.get(component.constructor)) !== null && _a !== void 0 ? _a : [];
        for (const query of queries) {
            query.checkAndAdd(entity);
        }
    }
    /**
     * Updates any queries when a component is removed from an entity
     * @param entity
     * @param component
     */
    removeComponent(entity, component) {
        var _a;
        const queries = (_a = this._componentToQueriesIndex.get(component.constructor)) !== null && _a !== void 0 ? _a : [];
        for (const query of queries) {
            query.removeEntity(entity);
        }
    }
    /**
     * Updates any queries when a tag is added to an entity
     * @param entity
     * @param tag
     */
    addTag(entity, tag) {
        var _a;
        const queries = (_a = this._tagToQueriesIndex.get(tag)) !== null && _a !== void 0 ? _a : [];
        for (const query of queries) {
            query.checkAndAdd(entity);
        }
    }
    /**
     * Updates any queries when a component is removed from an entity
     * @param entity
     * @param tag
     */
    removeTag(entity, tag) {
        var _a;
        const queries = (_a = this._tagToQueriesIndex.get(tag)) !== null && _a !== void 0 ? _a : [];
        for (const query of queries) {
            query.removeEntity(entity);
        }
    }
}


/***/ }),

/***/ "./EntityComponentSystem/System.ts":
/*!*****************************************!*\
  !*** ./EntityComponentSystem/System.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   System: () => (/* binding */ System),
/* harmony export */   SystemType: () => (/* binding */ SystemType)
/* harmony export */ });
/* harmony import */ var _Priority__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Priority */ "./EntityComponentSystem/Priority.ts");

/**
 * Enum that determines whether to run the system in the update or draw phase
 */
var SystemType;
(function (SystemType) {
    SystemType["Update"] = "update";
    SystemType["Draw"] = "draw";
})(SystemType || (SystemType = {}));
/**
 * An Excalibur {@apilink System} that updates entities of certain types.
 * Systems are scene specific
 *
 *
 *
 * Excalibur Systems currently require at least 1 Component type to operated
 *
 * Multiple types are declared as a type union
 * For example:
 *
 * ```typescript
 * class MySystem extends System {
 *   static priority = SystemPriority.Lowest;
 *   public readonly systemType = SystemType.Update;
 *   public query: Query<typeof TransformComponent>;
 *   constructor(public world: World) {
 *   super();
 *      this.query = this.world.query([TransformComponent]);
 *   }
 *   public update(elapsed: number) {
 *      ...
 *   }
 * }
 * ```
 */
class System {
}
/**
 * System can execute in priority order, by default all systems are priority 0. Lower values indicated higher priority.
 * For a system to execute before all other a lower priority value (-1 for example) must be set.
 * For a system to execute after all other a higher priority value (10 for example) must be set.
 */
System.priority = _Priority__WEBPACK_IMPORTED_MODULE_0__.SystemPriority.Average;


/***/ }),

/***/ "./EntityComponentSystem/SystemManager.ts":
/*!************************************************!*\
  !*** ./EntityComponentSystem/SystemManager.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SystemManager: () => (/* binding */ SystemManager),
/* harmony export */   isSystemConstructor: () => (/* binding */ isSystemConstructor)
/* harmony export */ });
/* harmony import */ var _System__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./System */ "./EntityComponentSystem/System.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");


/**
 *
 */
function isSystemConstructor(x) {
    var _a, _b;
    return !!(x === null || x === void 0 ? void 0 : x.prototype) && !!((_b = (_a = x === null || x === void 0 ? void 0 : x.prototype) === null || _a === void 0 ? void 0 : _a.constructor) === null || _b === void 0 ? void 0 : _b.name);
}
/**
 * The SystemManager is responsible for keeping track of all systems in a scene.
 * Systems are scene specific
 */
class SystemManager {
    constructor(_world) {
        this._world = _world;
        /**
         * List of systems, to add a new system call {@apilink SystemManager.addSystem}
         */
        this.systems = [];
        this.initialized = false;
    }
    /**
     * Get a system registered in the manager by type
     * @param systemType
     */
    get(systemType) {
        return this.systems.find((s) => s instanceof systemType);
    }
    /**
     * Adds a system to the manager, it will now be updated every frame
     * @param systemOrCtor
     */
    addSystem(systemOrCtor) {
        let system;
        if (systemOrCtor instanceof _System__WEBPACK_IMPORTED_MODULE_0__.System) {
            system = systemOrCtor;
        }
        else {
            system = new systemOrCtor(this._world);
        }
        this.systems.push(system);
        this.systems.sort((a, b) => a.constructor.priority - b.constructor.priority);
        // If systems are added and the manager has already been init'd
        // then immediately init the system
        if (this.initialized && system.initialize) {
            system.initialize(this._world, this._world.scene);
        }
    }
    /**
     * Removes a system from the manager, it will no longer be updated
     * @param system
     */
    removeSystem(system) {
        (0,_Util_Util__WEBPACK_IMPORTED_MODULE_1__.removeItemFromArray)(system, this.systems);
    }
    /**
     * Initialize all systems in the manager
     *
     * Systems added after initialize() will be initialized on add
     */
    initialize() {
        if (!this.initialized) {
            this.initialized = true;
            for (const s of this.systems) {
                if (s.initialize) {
                    s.initialize(this._world, this._world.scene);
                }
            }
        }
    }
    /**
     * Updates all systems
     * @param type whether this is an update or draw system
     * @param scene context reference
     * @param elapsed time in milliseconds
     */
    updateSystems(type, scene, elapsed) {
        const systems = this.systems.filter((s) => s.systemType === type);
        for (const s of systems) {
            if (s.preupdate) {
                s.preupdate(scene, elapsed);
            }
        }
        for (const s of systems) {
            s.update(elapsed);
        }
        for (const s of systems) {
            if (s.postupdate) {
                s.postupdate(scene, elapsed);
            }
        }
    }
    clear() {
        for (let i = this.systems.length - 1; i >= 0; i--) {
            this.removeSystem(this.systems[i]);
        }
    }
}


/***/ }),

/***/ "./EntityComponentSystem/TagQuery.ts":
/*!*******************************************!*\
  !*** ./EntityComponentSystem/TagQuery.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TagQuery: () => (/* binding */ TagQuery)
/* harmony export */ });
/* harmony import */ var _Util_Observable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Util/Observable */ "./Util/Observable.ts");

class TagQuery {
    constructor(requiredTags) {
        this.requiredTags = requiredTags;
        this.tags = new Set();
        this.entities = [];
        /**
         * This fires right after the component is added
         */
        this.entityAdded$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_0__.Observable();
        /**
         * This fires right before the component is actually removed from the entity, it will still be available for cleanup purposes
         */
        this.entityRemoved$ = new _Util_Observable__WEBPACK_IMPORTED_MODULE_0__.Observable();
        if (requiredTags.length === 0) {
            throw new Error('Cannot create tag query without tags');
        }
        for (const tag of requiredTags) {
            this.tags.add(tag);
        }
        this.id = TagQuery.createId(requiredTags);
    }
    static createId(requiredComponents) {
        return requiredComponents.slice().sort().join('-');
    }
    checkAndAdd(entity) {
        if (!this.entities.includes(entity) && entity.hasAllTags(Array.from(this.tags))) {
            this.entities.push(entity);
            this.entityAdded$.notifyAll(entity);
            return true;
        }
        return false;
    }
    removeEntity(entity) {
        const index = this.entities.indexOf(entity);
        if (index > -1) {
            this.entities.splice(index, 1);
            this.entityRemoved$.notifyAll(entity);
        }
    }
    /**
     * Returns a list of entities that match the query
     * @param sort Optional sorting function to sort entities returned from the query
     */
    getEntities(sort) {
        if (sort) {
            this.entities.sort(sort);
        }
        return this.entities;
    }
}


/***/ }),

/***/ "./EntityComponentSystem/World.ts":
/*!****************************************!*\
  !*** ./EntityComponentSystem/World.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   World: () => (/* binding */ World)
/* harmony export */ });
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Entity__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Entity */ "./EntityComponentSystem/Entity.ts");
/* harmony import */ var _EntityManager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./EntityManager */ "./EntityComponentSystem/EntityManager.ts");
/* harmony import */ var _QueryManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./QueryManager */ "./EntityComponentSystem/QueryManager.ts");
/* harmony import */ var _System__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./System */ "./EntityComponentSystem/System.ts");
/* harmony import */ var _SystemManager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SystemManager */ "./EntityComponentSystem/SystemManager.ts");






/**
 * The World is a self-contained entity component system for a particular context.
 */
class World {
    /**
     * The context type is passed to the system updates
     * @param scene
     */
    constructor(scene) {
        this.scene = scene;
        this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_0__.Logger.getInstance();
        this.queryManager = new _QueryManager__WEBPACK_IMPORTED_MODULE_1__.QueryManager(this);
        this.entityManager = new _EntityManager__WEBPACK_IMPORTED_MODULE_2__.EntityManager(this);
        this.systemManager = new _SystemManager__WEBPACK_IMPORTED_MODULE_3__.SystemManager(this);
    }
    /**
     * Query the ECS world for entities that match your components
     * @param requiredTypes
     */
    query(requiredTypes) {
        return this.queryManager.createQuery(requiredTypes);
    }
    queryTags(requiredTags) {
        return this.queryManager.createTagQuery(requiredTags);
    }
    /**
     * Update systems by type and time elapsed in milliseconds
     */
    update(type, elapsed) {
        if (type === _System__WEBPACK_IMPORTED_MODULE_4__.SystemType.Update) {
            this.entityManager.updateEntities(this.scene, elapsed);
        }
        this.systemManager.updateSystems(type, this.scene, elapsed);
        this.entityManager.findEntitiesForRemoval();
        this.entityManager.processComponentRemovals();
        this.entityManager.processEntityRemovals();
    }
    add(entityOrSystem) {
        if (entityOrSystem instanceof _Entity__WEBPACK_IMPORTED_MODULE_5__.Entity) {
            this.entityManager.addEntity(entityOrSystem);
            return;
        }
        if (entityOrSystem instanceof _System__WEBPACK_IMPORTED_MODULE_4__.System || (0,_SystemManager__WEBPACK_IMPORTED_MODULE_3__.isSystemConstructor)(entityOrSystem)) {
            this.systemManager.addSystem(entityOrSystem);
            return;
        }
        this._logger.warn(`Could not add entity/system ${entityOrSystem.constructor.name} to Excalibur!\n\n` +
            `If this looks like an Excalibur type, this can be caused by 2 versions of excalibur being included on the page.\n\n` +
            `Check your bundler settings to make sure this is not the case! Excalibur has ESM & UMD bundles be sure one 1 is loaded.`);
    }
    /**
     * Get a system out of the ECS world
     */
    get(system) {
        return this.systemManager.get(system);
    }
    remove(entityOrSystem, deferred = true) {
        if (entityOrSystem instanceof _Entity__WEBPACK_IMPORTED_MODULE_5__.Entity) {
            this.entityManager.removeEntity(entityOrSystem, deferred);
            return;
        }
        if (entityOrSystem instanceof _System__WEBPACK_IMPORTED_MODULE_4__.System) {
            this.systemManager.removeSystem(entityOrSystem);
            return;
        }
        this._logger.warn(`Could not remove entity/system ${entityOrSystem.constructor.name} to Excalibur!\n\n` +
            `If this looks like an Excalibur type, this can be caused by 2 versions of excalibur being included on the page.\n\n` +
            `Check your bundler settings to make sure this is not the case! Excalibur has ESM & UMD bundles be sure one 1 is loaded.`);
    }
    get entities() {
        return this.entityManager.entities;
    }
    clearEntities() {
        this.entityManager.clear();
    }
    clearSystems() {
        this.systemManager.clear();
    }
}


/***/ }),

/***/ "./EntityComponentSystem/index.ts":
/*!****************************************!*\
  !*** ./EntityComponentSystem/index.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddedComponent: () => (/* reexport safe */ _Entity__WEBPACK_IMPORTED_MODULE_1__.AddedComponent),
/* harmony export */   Component: () => (/* reexport safe */ _Component__WEBPACK_IMPORTED_MODULE_0__.Component),
/* harmony export */   Entity: () => (/* reexport safe */ _Entity__WEBPACK_IMPORTED_MODULE_1__.Entity),
/* harmony export */   EntityEvents: () => (/* reexport safe */ _Entity__WEBPACK_IMPORTED_MODULE_1__.EntityEvents),
/* harmony export */   EntityManager: () => (/* reexport safe */ _EntityManager__WEBPACK_IMPORTED_MODULE_2__.EntityManager),
/* harmony export */   MotionComponent: () => (/* reexport safe */ _Components_MotionComponent__WEBPACK_IMPORTED_MODULE_11__.MotionComponent),
/* harmony export */   Query: () => (/* reexport safe */ _Query__WEBPACK_IMPORTED_MODULE_3__.Query),
/* harmony export */   QueryManager: () => (/* reexport safe */ _QueryManager__WEBPACK_IMPORTED_MODULE_5__.QueryManager),
/* harmony export */   RemovedComponent: () => (/* reexport safe */ _Entity__WEBPACK_IMPORTED_MODULE_1__.RemovedComponent),
/* harmony export */   System: () => (/* reexport safe */ _System__WEBPACK_IMPORTED_MODULE_6__.System),
/* harmony export */   SystemManager: () => (/* reexport safe */ _SystemManager__WEBPACK_IMPORTED_MODULE_7__.SystemManager),
/* harmony export */   SystemPriority: () => (/* reexport safe */ _Priority__WEBPACK_IMPORTED_MODULE_9__.SystemPriority),
/* harmony export */   SystemType: () => (/* reexport safe */ _System__WEBPACK_IMPORTED_MODULE_6__.SystemType),
/* harmony export */   TagQuery: () => (/* reexport safe */ _TagQuery__WEBPACK_IMPORTED_MODULE_4__.TagQuery),
/* harmony export */   TransformComponent: () => (/* reexport safe */ _Components_TransformComponent__WEBPACK_IMPORTED_MODULE_10__.TransformComponent),
/* harmony export */   World: () => (/* reexport safe */ _World__WEBPACK_IMPORTED_MODULE_8__.World),
/* harmony export */   isAddedComponent: () => (/* reexport safe */ _Entity__WEBPACK_IMPORTED_MODULE_1__.isAddedComponent),
/* harmony export */   isComponentCtor: () => (/* reexport safe */ _Component__WEBPACK_IMPORTED_MODULE_0__.isComponentCtor),
/* harmony export */   isRemovedComponent: () => (/* reexport safe */ _Entity__WEBPACK_IMPORTED_MODULE_1__.isRemovedComponent),
/* harmony export */   isSystemConstructor: () => (/* reexport safe */ _SystemManager__WEBPACK_IMPORTED_MODULE_7__.isSystemConstructor)
/* harmony export */ });
/* harmony import */ var _Component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Component */ "./EntityComponentSystem/Component.ts");
/* harmony import */ var _Entity__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Entity */ "./EntityComponentSystem/Entity.ts");
/* harmony import */ var _EntityManager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./EntityManager */ "./EntityComponentSystem/EntityManager.ts");
/* harmony import */ var _Query__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Query */ "./EntityComponentSystem/Query.ts");
/* harmony import */ var _TagQuery__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./TagQuery */ "./EntityComponentSystem/TagQuery.ts");
/* harmony import */ var _QueryManager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./QueryManager */ "./EntityComponentSystem/QueryManager.ts");
/* harmony import */ var _System__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./System */ "./EntityComponentSystem/System.ts");
/* harmony import */ var _SystemManager__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SystemManager */ "./EntityComponentSystem/SystemManager.ts");
/* harmony import */ var _World__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./World */ "./EntityComponentSystem/World.ts");
/* harmony import */ var _Priority__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Priority */ "./EntityComponentSystem/Priority.ts");
/* harmony import */ var _Components_TransformComponent__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Components/TransformComponent */ "./EntityComponentSystem/Components/TransformComponent.ts");
/* harmony import */ var _Components_MotionComponent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Components/MotionComponent */ "./EntityComponentSystem/Components/MotionComponent.ts");















/***/ }),

/***/ "./EventEmitter.ts":
/*!*************************!*\
  !*** ./EventEmitter.ts ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EventEmitter: () => (/* binding */ EventEmitter)
/* harmony export */ });
/**
 * Excalibur's typed event emitter, this allows events to be sent with any string to Type mapping
 */
class EventEmitter {
    constructor() {
        this._paused = false;
        this._empty = true;
        this._listeners = {};
        this._listenersOnce = {};
        this._pipes = [];
    }
    /**
     * Removes all listeners and pipes
     */
    clear() {
        this._listeners = {};
        this._listenersOnce = {};
        this._pipes.length = 0;
        this._empty = true;
    }
    on(eventName, handler) {
        var _a;
        this._empty = false;
        this._listeners[eventName] = (_a = this._listeners[eventName]) !== null && _a !== void 0 ? _a : [];
        this._listeners[eventName].push(handler);
        return {
            close: () => this.off(eventName, handler)
        };
    }
    once(eventName, handler) {
        var _a;
        this._empty = false;
        this._listenersOnce[eventName] = (_a = this._listenersOnce[eventName]) !== null && _a !== void 0 ? _a : [];
        this._listenersOnce[eventName].push(handler);
        return {
            close: () => this.off(eventName, handler)
        };
    }
    off(eventName, handler) {
        var _a, _b;
        if (handler) {
            const newListeners = (_a = this._listeners[eventName]) === null || _a === void 0 ? void 0 : _a.filter((h) => h !== handler);
            this._listeners[eventName] = newListeners;
            const newOnceListeners = (_b = this._listenersOnce[eventName]) === null || _b === void 0 ? void 0 : _b.filter((h) => h !== handler);
            this._listenersOnce[eventName] = newOnceListeners;
        }
        else {
            delete this._listeners[eventName];
        }
    }
    emit(eventName, event) {
        if (this._empty) {
            return;
        }
        if (this._paused) {
            return;
        }
        const listeners = this._listeners[eventName];
        if (listeners) {
            for (let i = 0; i < listeners.length; i++) {
                listeners[i](event);
            }
        }
        const onces = this._listenersOnce[eventName];
        this._listenersOnce[eventName] = [];
        if (onces) {
            for (let i = 0; i < onces.length; i++) {
                onces[i](event);
            }
        }
        for (let i = 0; i < this._pipes.length; i++) {
            this._pipes[i].emit(eventName, event);
        }
    }
    /**
     * Replay events from this emitter to another
     * @param emitter
     */
    pipe(emitter) {
        if (this === emitter) {
            throw Error('Cannot pipe to self');
        }
        this._empty = false;
        this._pipes.push(emitter);
        return {
            close: () => {
                const i = this._pipes.indexOf(emitter);
                if (i > -1) {
                    this._pipes.splice(i, 1);
                }
            }
        };
    }
    /**
     * Remove any piped emitters
     * @param emitter
     */
    unpipe(emitter) {
        const i = this._pipes.indexOf(emitter);
        if (i > -1) {
            this._pipes.splice(i, 1);
        }
    }
    /**
     * Paused event emitters do not emit events
     */
    pause() {
        this._paused = true;
    }
    /**
     * Unpaused event emitter do emit events
     */
    unpause() {
        this._paused = false;
    }
}


/***/ }),

/***/ "./Events.ts":
/*!*******************!*\
  !*** ./Events.ts ***!
  \*******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionCompleteEvent: () => (/* binding */ ActionCompleteEvent),
/* harmony export */   ActionStartEvent: () => (/* binding */ ActionStartEvent),
/* harmony export */   ActivateEvent: () => (/* binding */ ActivateEvent),
/* harmony export */   AddEvent: () => (/* binding */ AddEvent),
/* harmony export */   CollisionEndEvent: () => (/* binding */ CollisionEndEvent),
/* harmony export */   CollisionPostSolveEvent: () => (/* binding */ CollisionPostSolveEvent),
/* harmony export */   CollisionPreSolveEvent: () => (/* binding */ CollisionPreSolveEvent),
/* harmony export */   CollisionStartEvent: () => (/* binding */ CollisionStartEvent),
/* harmony export */   ContactEndEvent: () => (/* binding */ ContactEndEvent),
/* harmony export */   ContactStartEvent: () => (/* binding */ ContactStartEvent),
/* harmony export */   DeactivateEvent: () => (/* binding */ DeactivateEvent),
/* harmony export */   EnterTriggerEvent: () => (/* binding */ EnterTriggerEvent),
/* harmony export */   EnterViewPortEvent: () => (/* binding */ EnterViewPortEvent),
/* harmony export */   EventTypes: () => (/* binding */ EventTypes),
/* harmony export */   ExitTriggerEvent: () => (/* binding */ ExitTriggerEvent),
/* harmony export */   ExitViewPortEvent: () => (/* binding */ ExitViewPortEvent),
/* harmony export */   GameEvent: () => (/* binding */ GameEvent),
/* harmony export */   GameStartEvent: () => (/* binding */ GameStartEvent),
/* harmony export */   GameStopEvent: () => (/* binding */ GameStopEvent),
/* harmony export */   GamepadAxisEvent: () => (/* binding */ GamepadAxisEvent),
/* harmony export */   GamepadButtonEvent: () => (/* binding */ GamepadButtonEvent),
/* harmony export */   GamepadConnectEvent: () => (/* binding */ GamepadConnectEvent),
/* harmony export */   GamepadDisconnectEvent: () => (/* binding */ GamepadDisconnectEvent),
/* harmony export */   HiddenEvent: () => (/* binding */ HiddenEvent),
/* harmony export */   InitializeEvent: () => (/* binding */ InitializeEvent),
/* harmony export */   KillEvent: () => (/* binding */ KillEvent),
/* harmony export */   PostCollisionEvent: () => (/* binding */ PostCollisionEvent),
/* harmony export */   PostDebugDrawEvent: () => (/* binding */ PostDebugDrawEvent),
/* harmony export */   PostDrawEvent: () => (/* binding */ PostDrawEvent),
/* harmony export */   PostFrameEvent: () => (/* binding */ PostFrameEvent),
/* harmony export */   PostKillEvent: () => (/* binding */ PostKillEvent),
/* harmony export */   PostTransformDrawEvent: () => (/* binding */ PostTransformDrawEvent),
/* harmony export */   PostUpdateEvent: () => (/* binding */ PostUpdateEvent),
/* harmony export */   PreCollisionEvent: () => (/* binding */ PreCollisionEvent),
/* harmony export */   PreDebugDrawEvent: () => (/* binding */ PreDebugDrawEvent),
/* harmony export */   PreDrawEvent: () => (/* binding */ PreDrawEvent),
/* harmony export */   PreFrameEvent: () => (/* binding */ PreFrameEvent),
/* harmony export */   PreKillEvent: () => (/* binding */ PreKillEvent),
/* harmony export */   PreTransformDrawEvent: () => (/* binding */ PreTransformDrawEvent),
/* harmony export */   PreUpdateEvent: () => (/* binding */ PreUpdateEvent),
/* harmony export */   RemoveEvent: () => (/* binding */ RemoveEvent),
/* harmony export */   VisibleEvent: () => (/* binding */ VisibleEvent)
/* harmony export */ });
var EventTypes;
(function (EventTypes) {
    EventTypes["Kill"] = "kill";
    EventTypes["PreKill"] = "prekill";
    EventTypes["PostKill"] = "postkill";
    EventTypes["PreDraw"] = "predraw";
    EventTypes["PostDraw"] = "postdraw";
    EventTypes["PreDebugDraw"] = "predebugdraw";
    EventTypes["PostDebugDraw"] = "postdebugdraw";
    EventTypes["PreUpdate"] = "preupdate";
    EventTypes["PostUpdate"] = "postupdate";
    EventTypes["PreFrame"] = "preframe";
    EventTypes["PostFrame"] = "postframe";
    EventTypes["PreCollision"] = "precollision";
    EventTypes["CollisionStart"] = "collisionstart";
    EventTypes["CollisionEnd"] = "collisionend";
    EventTypes["PostCollision"] = "postcollision";
    EventTypes["Initialize"] = "initialize";
    EventTypes["Activate"] = "activate";
    EventTypes["Deactivate"] = "deactivate";
    EventTypes["ExitViewport"] = "exitviewport";
    EventTypes["EnterViewport"] = "enterviewport";
    EventTypes["ExitTrigger"] = "exit";
    EventTypes["EnterTrigger"] = "enter";
    EventTypes["Connect"] = "connect";
    EventTypes["Disconnect"] = "disconnect";
    EventTypes["Button"] = "button";
    EventTypes["Axis"] = "axis";
    EventTypes["Visible"] = "visible";
    EventTypes["Hidden"] = "hidden";
    EventTypes["Start"] = "start";
    EventTypes["Stop"] = "stop";
    EventTypes["PointerUp"] = "pointerup";
    EventTypes["PointerDown"] = "pointerdown";
    EventTypes["PointerMove"] = "pointermove";
    EventTypes["PointerEnter"] = "pointerenter";
    EventTypes["PointerLeave"] = "pointerleave";
    EventTypes["PointerCancel"] = "pointercancel";
    EventTypes["PointerWheel"] = "pointerwheel";
    EventTypes["Up"] = "up";
    EventTypes["Down"] = "down";
    EventTypes["Move"] = "move";
    EventTypes["Enter"] = "enter";
    EventTypes["Leave"] = "leave";
    EventTypes["Cancel"] = "cancel";
    EventTypes["Wheel"] = "wheel";
    EventTypes["Press"] = "press";
    EventTypes["Release"] = "release";
    EventTypes["Hold"] = "hold";
    EventTypes["PointerDragStart"] = "pointerdragstart";
    EventTypes["PointerDragEnd"] = "pointerdragend";
    EventTypes["PointerDragEnter"] = "pointerdragenter";
    EventTypes["PointerDragLeave"] = "pointerdragleave";
    EventTypes["PointerDragMove"] = "pointerdragmove";
    EventTypes["ActionStart"] = "actionstart";
    EventTypes["ActionComplete"] = "actioncomplete";
    EventTypes["Add"] = "add";
    EventTypes["Remove"] = "remove";
})(EventTypes || (EventTypes = {}));
/**
 * Base event type in Excalibur that all other event types derive from. Not all event types are thrown on all Excalibur game objects,
 * some events are unique to a type, others are not.
 *
 */
class GameEvent {
    constructor() {
        /**
         * Other target object for this event
         */
        this.other = null;
        this._bubbles = true;
    }
    /**
     * If set to false, prevents event from propagating to other actors. If true it will be propagated
     * to all actors that apply.
     */
    get bubbles() {
        return this._bubbles;
    }
    set bubbles(value) {
        this._bubbles = value;
    }
    /**
     * Prevents event from bubbling
     */
    stopPropagation() {
        this.bubbles = false;
    }
}
/**
 * The 'kill' event is emitted on actors when it is killed. The target is the actor that was killed.
 */
class KillEvent extends GameEvent {
    constructor(self) {
        super();
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'prekill' event is emitted directly before an actor is killed.
 */
class PreKillEvent extends GameEvent {
    constructor(self) {
        super();
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'postkill' event is emitted directly after the actor is killed.
 */
class PostKillEvent extends GameEvent {
    constructor(self) {
        super();
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'start' event is emitted on engine when has started and is ready for interaction.
 */
class GameStartEvent extends GameEvent {
    constructor(self) {
        super();
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'stop' event is emitted on engine when has been stopped and will no longer take input, update or draw.
 */
class GameStopEvent extends GameEvent {
    constructor(self) {
        super();
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'predraw' event is emitted on actors, scenes, and engine before drawing starts. Actors' predraw happens inside their graphics
 * transform so that all drawing takes place with the actor as the origin.
 *
 */
class PreDrawEvent extends GameEvent {
    constructor(ctx, elapsed, self) {
        super();
        this.ctx = ctx;
        this.elapsed = elapsed;
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'postdraw' event is emitted on actors, scenes, and engine after drawing finishes. Actors' postdraw happens inside their graphics
 * transform so that all drawing takes place with the actor as the origin.
 *
 */
class PostDrawEvent extends GameEvent {
    constructor(ctx, elapsed, self) {
        super();
        this.ctx = ctx;
        this.elapsed = elapsed;
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'pretransformdraw' event is emitted on actors/entities before any graphics transforms have taken place.
 * Useful if you need to completely customize the draw or modify the transform before drawing in the draw step (for example needing
 * latest camera positions)
 *
 */
class PreTransformDrawEvent extends GameEvent {
    constructor(ctx, elapsed, self) {
        super();
        this.ctx = ctx;
        this.elapsed = elapsed;
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'posttransformdraw' event is emitted on actors/entities after all graphics have been draw and transforms reset.
 * Useful if you need to completely custom the draw after everything is done.
 *
 */
class PostTransformDrawEvent extends GameEvent {
    constructor(ctx, elapsed, self) {
        super();
        this.ctx = ctx;
        this.elapsed = elapsed;
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'predebugdraw' event is emitted on actors, scenes, and engine before debug drawing starts.
 */
class PreDebugDrawEvent extends GameEvent {
    constructor(ctx, self) {
        super();
        this.ctx = ctx;
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'postdebugdraw' event is emitted on actors, scenes, and engine after debug drawing starts.
 */
class PostDebugDrawEvent extends GameEvent {
    constructor(ctx, self) {
        super();
        this.ctx = ctx;
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'preupdate' event is emitted on actors, scenes, camera, and engine before the update starts.
 */
class PreUpdateEvent extends GameEvent {
    constructor(engine, elapsed, self) {
        super();
        this.engine = engine;
        this.elapsed = elapsed;
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'postupdate' event is emitted on actors, scenes, camera, and engine after the update ends.
 */
class PostUpdateEvent extends GameEvent {
    constructor(engine, elapsed, self) {
        super();
        this.engine = engine;
        this.elapsed = elapsed;
        this.self = self;
        this.target = self;
    }
}
/**
 * The 'preframe' event is emitted on the engine, before the frame begins.
 */
class PreFrameEvent extends GameEvent {
    constructor(engine, prevStats) {
        super();
        this.engine = engine;
        this.prevStats = prevStats;
        this.target = engine;
    }
}
/**
 * The 'postframe' event is emitted on the engine, after a frame ends.
 */
class PostFrameEvent extends GameEvent {
    constructor(engine, stats) {
        super();
        this.engine = engine;
        this.stats = stats;
        this.target = engine;
    }
}
/**
 * Event received when a gamepad is connected to Excalibur. {@apilink Gamepads} receives this event.
 */
class GamepadConnectEvent extends GameEvent {
    constructor(index, gamepad) {
        super();
        this.index = index;
        this.gamepad = gamepad;
        this.target = gamepad;
    }
}
/**
 * Event received when a gamepad is disconnected from Excalibur. {@apilink Gamepads} receives this event.
 */
class GamepadDisconnectEvent extends GameEvent {
    constructor(index, gamepad) {
        super();
        this.index = index;
        this.gamepad = gamepad;
        this.target = gamepad;
    }
}
/**
 * Gamepad button event. See {@apilink Gamepads} for information on responding to controller input. {@apilink Gamepad} instances receive this event;
 */
class GamepadButtonEvent extends GameEvent {
    /**
     * @param button  The Gamepad {@apilink Buttons} if not known by excalibur {@apilink Buttons.Unknown} is returned, use index to disambiguate.
     * @param index   The canonical index of the gamepad button from the system
     * @param value   A numeric value between 0 and 1
     * @param self    Reference to the gamepad
     */
    constructor(
    /**
     * The Gamepad {@apilink Buttons} if not known by excalibur {@apilink Buttons.Unknown} is returned, use index to disambiguate.
     */
    button, 
    /**
     * The canonical index of the gamepad button from the system
     */
    index, 
    /**
     * A numeric value between 0 and 1
     */
    value, 
    /**
     * Reference to the gamepad
     */
    self) {
        super();
        this.button = button;
        this.index = index;
        this.value = value;
        this.self = self;
        this.target = self;
    }
}
/**
 * Gamepad axis event. See {@apilink Gamepads} for information on responding to controller input. {@apilink Gamepad} instances receive this event;
 */
class GamepadAxisEvent extends GameEvent {
    /**
     * @param axis  The Gamepad axis
     * @param value A numeric value between -1 and 1
     * @param self Reference to the gamepad
     */
    constructor(
    /**
     * The Gamepad {@apilink Axis}
     */
    axis, 
    /**
     * A numeric value between -1 and 1, 0 is the neutral axis position.
     */
    value, 
    /**
     * Reference to the gamepad
     */
    self) {
        super();
        this.axis = axis;
        this.value = value;
        this.self = self;
        this.target = self;
    }
}
/**
 * Event received by the {@apilink Engine} when the browser window is visible on a screen.
 */
class VisibleEvent extends GameEvent {
    constructor(self) {
        super();
        this.self = self;
        this.target = self;
    }
}
/**
 * Event received by the {@apilink Engine} when the browser window is hidden from all screens.
 */
class HiddenEvent extends GameEvent {
    constructor(self) {
        super();
        this.self = self;
        this.target = self;
    }
}
/**
 * Event thrown on an {@apilink Actor | `actor`} when a collision will occur this frame if it resolves
 */
class PreCollisionEvent extends GameEvent {
    /**
     * @param self          The actor the event was thrown on
     * @param other         The actor that will collided with the current actor
     * @param side          The side that will be collided with the current actor
     * @param intersection  Intersection vector
     */
    constructor(self, other, side, intersection, contact) {
        super();
        this.self = self;
        this.other = other;
        this.side = side;
        this.intersection = intersection;
        this.contact = contact;
        this.target = self;
    }
}
/**
 * Event thrown on an {@apilink Actor | `actor`} when a collision has been resolved (body reacted) this frame
 */
class PostCollisionEvent extends GameEvent {
    /**
     * @param self          The actor the event was thrown on
     * @param other         The actor that did collide with the current actor
     * @param side          The side that did collide with the current actor
     * @param intersection  Intersection vector
     */
    constructor(self, other, side, intersection, contact) {
        super();
        this.self = self;
        this.other = other;
        this.side = side;
        this.intersection = intersection;
        this.contact = contact;
        this.target = self;
    }
}
class ContactStartEvent {
    constructor(self, other, side, contact) {
        this.self = self;
        this.other = other;
        this.side = side;
        this.contact = contact;
    }
}
class ContactEndEvent {
    constructor(self, other, side, lastContact) {
        this.self = self;
        this.other = other;
        this.side = side;
        this.lastContact = lastContact;
    }
}
class CollisionPreSolveEvent {
    constructor(self, other, side, intersection, contact) {
        this.self = self;
        this.other = other;
        this.side = side;
        this.intersection = intersection;
        this.contact = contact;
    }
}
class CollisionPostSolveEvent {
    constructor(self, other, side, intersection, contact) {
        this.self = self;
        this.other = other;
        this.side = side;
        this.intersection = intersection;
        this.contact = contact;
    }
}
/**
 * Event thrown the first time an {@apilink Actor | `actor`} collides with another, after an actor is in contact normal collision events are fired.
 */
class CollisionStartEvent extends GameEvent {
    /**
     *
     * @param self
     * @param other
     * @param side
     * @param contact
     */
    constructor(self, other, side, contact) {
        super();
        this.self = self;
        this.other = other;
        this.side = side;
        this.contact = contact;
        this.target = self;
    }
}
/**
 * Event thrown when the {@apilink Actor | `actor`} is no longer colliding with another
 */
class CollisionEndEvent extends GameEvent {
    /**
     *
     */
    constructor(self, other, side, lastContact) {
        super();
        this.self = self;
        this.other = other;
        this.side = side;
        this.lastContact = lastContact;
        this.target = self;
    }
}
/**
 * Event thrown on an {@apilink Actor}, {@apilink Scene}, and {@apilink Engine} only once before the first update call
 */
class InitializeEvent extends GameEvent {
    /**
     * @param engine  The reference to the current engine
     */
    constructor(engine, self) {
        super();
        this.engine = engine;
        this.self = self;
        this.target = self;
    }
}
/**
 * Event thrown on a {@apilink Scene} on activation
 */
class ActivateEvent extends GameEvent {
    /**
     * @param context  The context for the scene activation
     */
    constructor(context, self) {
        super();
        this.context = context;
        this.self = self;
        this.target = self;
    }
}
/**
 * Event thrown on a {@apilink Scene} on deactivation
 */
class DeactivateEvent extends GameEvent {
    /**
     * @param context  The context for the scene deactivation
     */
    constructor(context, self) {
        super();
        this.context = context;
        this.self = self;
        this.target = self;
    }
}
/**
 * Event thrown on an {@apilink Actor} when the graphics bounds completely leaves the screen.
 */
class ExitViewPortEvent extends GameEvent {
    constructor(self) {
        super();
        this.self = self;
        this.target = self;
    }
}
/**
 * Event thrown on an {@apilink Actor} when any part of the graphics bounds are on screen.
 */
class EnterViewPortEvent extends GameEvent {
    constructor(self) {
        super();
        this.self = self;
        this.target = self;
    }
}
class EnterTriggerEvent extends GameEvent {
    constructor(self, entity) {
        super();
        this.self = self;
        this.entity = entity;
        this.target = self;
    }
}
class ExitTriggerEvent extends GameEvent {
    constructor(self, entity) {
        super();
        this.self = self;
        this.entity = entity;
        this.target = self;
    }
}
/**
 * Event thrown on an {@apilink Actor} when an action starts.
 */
class ActionStartEvent extends GameEvent {
    constructor(action, self) {
        super();
        this.action = action;
        this.self = self;
        this.target = self;
    }
}
/**
 * Event thrown on an {@apilink Actor} when an action completes.
 */
class ActionCompleteEvent extends GameEvent {
    constructor(action, self) {
        super();
        this.action = action;
        this.self = self;
        this.target = self;
    }
}
/**
 * Event thrown on an [[Actor]] when an Actor added to scene.
 */
class AddEvent extends GameEvent {
    constructor(engine, self) {
        super();
        this.engine = engine;
        this.self = self;
        this.target = self;
    }
}
/**
 * Event thrown on an [[Actor]] when an Actor removed from scene.
 */
class RemoveEvent extends GameEvent {
    constructor(engine, self) {
        super();
        this.engine = engine;
        this.self = self;
        this.target = self;
    }
}


/***/ }),

/***/ "./Events/MediaEvents.ts":
/*!*******************************!*\
  !*** ./Events/MediaEvents.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MediaEvent: () => (/* binding */ MediaEvent),
/* harmony export */   NativeSoundEvent: () => (/* binding */ NativeSoundEvent),
/* harmony export */   NativeSoundProcessedEvent: () => (/* binding */ NativeSoundProcessedEvent)
/* harmony export */ });
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Events */ "./Events.ts");

class MediaEvent extends _Events__WEBPACK_IMPORTED_MODULE_0__.GameEvent {
    /**
     * Media event cannot bubble
     */
    set bubbles(_value) {
        // stubbed
    }
    /**
     * Media event cannot bubble
     */
    get bubbles() {
        return false;
    }
    /**
     * Media event cannot bubble, so they have no path
     */
    get _path() {
        return null;
    }
    /**
     * Media event cannot bubble, so they have no path
     */
    set _path(_val) {
        // stubbed
    }
    constructor(target, _name = 'MediaEvent') {
        super();
        this.target = target;
        this._name = _name;
    }
    /**
     * Prevents event from bubbling
     */
    stopPropagation() {
        /**
         * Stub
         */
    }
    /**
     * Action, that calls when event happens
     */
    action() {
        /**
         * Stub
         */
    }
    /**
     * Propagate event further through event path
     */
    propagate() {
        /**
         * Stub
         */
    }
    layPath(_actor) {
        /**
         * Stub
         */
    }
}
class NativeSoundEvent extends MediaEvent {
    constructor(target, track) {
        super(target, 'NativeSoundEvent');
        this.track = track;
    }
}
class NativeSoundProcessedEvent extends MediaEvent {
    constructor(target, _processedData) {
        super(target, 'NativeSoundProcessedEvent');
        this._processedData = _processedData;
        this.data = this._processedData;
    }
}


/***/ }),

/***/ "./Flags.ts":
/*!******************!*\
  !*** ./Flags.ts ***!
  \******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Flags: () => (/* binding */ Flags)
/* harmony export */ });
/**
 * Flags is a feature flag implementation for Excalibur. They can only be operated **before {@apilink Engine} construction**
 * after which they are frozen and are read-only.
 *
 * Flags are used to enable experimental or preview features in Excalibur.
 */
class Flags {
    /**
     * Force excalibur to load the Canvas 2D graphics context fallback
     * @warning not all features of excalibur are supported in the Canvas 2D fallback
     */
    static useCanvasGraphicsContext() {
        Flags.enable('use-canvas-context');
    }
    /**
     * Force excalibur to use the less optimized image renderer
     */
    static useLegacyImageRenderer() {
        Flags.enable('use-legacy-image-renderer');
    }
    /**
     * Freeze all flag modifications making them readonly
     */
    static freeze() {
        Flags._FROZEN = true;
    }
    /**
     * Resets internal flag state, not meant to be called by users. Only used for testing.
     *
     * Calling this in your game is UNSUPPORTED
     * @internal
     */
    static _reset() {
        Flags._FROZEN = false;
        Flags._FLAGS = {};
    }
    /**
     * Enable a specific feature flag by name. **Note: can only be set before {@apilink Engine} constructor time**
     * @param flagName
     */
    static enable(flagName) {
        if (this._FROZEN) {
            throw Error('Feature flags can only be enabled before Engine constructor time');
        }
        Flags._FLAGS[flagName] = true;
    }
    /**
     * Disable a specific feature flag by name. **Note: can only be set before {@apilink Engine} constructor time**
     * @param flagName
     */
    static disable(flagName) {
        if (this._FROZEN) {
            throw Error('Feature flags can only be disabled before Engine constructor time');
        }
        Flags._FLAGS[flagName] = false;
    }
    /**
     * Check if a flag is enabled. If the flag is disabled or does not exist `false` is returned
     * @param flagName
     */
    static isEnabled(flagName) {
        return !!Flags._FLAGS[flagName];
    }
    /**
     * Show a list of currently known flags
     */
    static show() {
        return Object.keys(Flags._FLAGS);
    }
}
Flags._FROZEN = false;
Flags._FLAGS = {};


/***/ }),

/***/ "./GarbageCollector.ts":
/*!*****************************!*\
  !*** ./GarbageCollector.ts ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultGarbageCollectionOptions: () => (/* binding */ DefaultGarbageCollectionOptions),
/* harmony export */   GarbageCollector: () => (/* binding */ GarbageCollector)
/* harmony export */ });
const DefaultGarbageCollectionOptions = {
    textureCollectInterval: 60000
    // TODO future work to integrate the font and text configuration, refactor existing collection mechanism
    // fontCollectInterval: 60_000,
    // textMeasurementCollectInterval: 60_000,
};
class GarbageCollector {
    constructor(options) {
        this.options = options;
        this._running = false;
        this._collectionMap = new Map();
        this._collectors = new Map();
        /**
         * Runs the collection loop to cleanup any stale resources given the registered collect handlers
         */
        this.collectStaleResources = (deadline) => {
            if (!this._running) {
                return;
            }
            for (const [type, [collector, timeoutInterval]] of this._collectors.entries()) {
                const now = this.options.getTimestamp();
                for (const [resource, [resourceType, time]] of this._collectionMap.entries()) {
                    if (type !== resourceType || time + timeoutInterval >= now) {
                        continue;
                    }
                    const collected = collector(resource);
                    if (collected) {
                        this._collectionMap.delete(resource);
                    }
                }
            }
            this._collectHandle = requestIdleCallback(this.collectStaleResources);
        };
    }
    /**
     *
     * @param type Resource type
     * @param timeoutInterval If resource type exceeds interval in milliseconds collect() is called
     * @param collect Collection implementation, returns true if collected
     */
    registerCollector(type, timeoutInterval, collect) {
        this._collectors.set(type, [collect, timeoutInterval]);
    }
    /**
     * Add a resource to be tracked for collection
     * @param type
     * @param resource
     */
    addCollectableResource(type, resource) {
        this._collectionMap.set(resource, [type, this.options.getTimestamp()]);
    }
    /**
     * Update the resource last used timestamp preventing collection
     * @param resource
     */
    touch(resource) {
        const collectionData = this._collectionMap.get(resource);
        if (collectionData) {
            this._collectionMap.set(resource, [collectionData[0], this.options.getTimestamp()]);
        }
    }
    /**
     * Force collect all resources, useful for shutting down a game
     * or if you know that you will not use anything you've allocated before now
     */
    forceCollectAll() {
        for (const [_, [collector]] of this._collectors.entries()) {
            for (const [resource] of this._collectionMap.entries()) {
                const collected = collector(resource);
                if (collected) {
                    this._collectionMap.delete(resource);
                }
            }
        }
    }
    running() {
        return this._running;
    }
    /**
     * Starts the garbage collection loop
     */
    start() {
        this._running = true;
        this.collectStaleResources();
    }
    /**
     * Stops the garbage collection loop
     */
    stop() {
        this._running = false;
        cancelIdleCallback(this._collectHandle);
    }
}


/***/ }),

/***/ "./Graphics/Animation.ts":
/*!*******************************!*\
  !*** ./Graphics/Animation.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Animation: () => (/* binding */ Animation),
/* harmony export */   AnimationDirection: () => (/* binding */ AnimationDirection),
/* harmony export */   AnimationEvents: () => (/* binding */ AnimationEvents),
/* harmony export */   AnimationStrategy: () => (/* binding */ AnimationStrategy)
/* harmony export */ });
/* harmony import */ var _Graphic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Graphic */ "./Graphics/Graphic.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Math/util */ "./Math/util.ts");
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../EventEmitter */ "./EventEmitter.ts");




var AnimationDirection;
(function (AnimationDirection) {
    /**
     * Animation is playing forwards
     */
    AnimationDirection["Forward"] = "forward";
    /**
     * Animation is playing backwards
     */
    AnimationDirection["Backward"] = "backward";
})(AnimationDirection || (AnimationDirection = {}));
var AnimationStrategy;
(function (AnimationStrategy) {
    /**
     * Animation ends without displaying anything
     */
    AnimationStrategy["End"] = "end";
    /**
     * Animation loops to the first frame after the last frame
     */
    AnimationStrategy["Loop"] = "loop";
    /**
     * Animation plays to the last frame, then backwards to the first frame, then repeats
     */
    AnimationStrategy["PingPong"] = "pingpong";
    /**
     * Animation ends stopping on the last frame
     */
    AnimationStrategy["Freeze"] = "freeze";
})(AnimationStrategy || (AnimationStrategy = {}));
const AnimationEvents = {
    Frame: 'frame',
    Loop: 'loop',
    End: 'end'
};
/**
 * Create an Animation given a list of {@apilink Frame | `frames`} in {@apilink AnimationOptions}
 *
 * To create an Animation from a {@apilink SpriteSheet}, use {@apilink Animation.fromSpriteSheet}
 */
class Animation extends _Graphic__WEBPACK_IMPORTED_MODULE_0__.Graphic {
    constructor(options) {
        var _a, _b, _c;
        super(options);
        this.events = new _EventEmitter__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.frames = [];
        this.strategy = AnimationStrategy.Loop;
        this.frameDuration = 100;
        this._idempotencyToken = -1;
        this._firstTick = true;
        this._currentFrame = 0;
        this._timeLeftInFrame = 0;
        this._pingPongDirection = 1;
        this._done = false;
        this._playing = true;
        this._speed = 1;
        this._reversed = false;
        this.frames = options.frames;
        this.speed = (_a = options.speed) !== null && _a !== void 0 ? _a : this.speed;
        this.strategy = (_b = options.strategy) !== null && _b !== void 0 ? _b : this.strategy;
        this.frameDuration = options.totalDuration ? options.totalDuration / this.frames.length : (_c = options.frameDuration) !== null && _c !== void 0 ? _c : this.frameDuration;
        if (options.reverse) {
            this.reverse();
        }
        this.goToFrame(0);
    }
    clone() {
        return new Animation({
            frames: this.frames.map((f) => ({ ...f })),
            frameDuration: this.frameDuration,
            speed: this.speed,
            reverse: this._reversed,
            strategy: this.strategy,
            ...this.cloneGraphicOptions()
        });
    }
    get width() {
        const maybeFrame = this.currentFrame;
        if (maybeFrame && maybeFrame.graphic) {
            return Math.abs(maybeFrame.graphic.width * this.scale.x);
        }
        return 0;
    }
    get height() {
        const maybeFrame = this.currentFrame;
        if (maybeFrame && maybeFrame.graphic) {
            return Math.abs(maybeFrame.graphic.height * this.scale.y);
        }
        return 0;
    }
    /**
     * Create an Animation from a {@apilink SpriteSheet}, a list of indices into the sprite sheet, a duration per frame
     * and optional {@apilink AnimationStrategy}
     *
     * Example:
     * ```typescript
     * const spriteSheet = SpriteSheet.fromImageSource({...});
     *
     * const anim = Animation.fromSpriteSheet(spriteSheet, range(0, 5), 200, AnimationStrategy.Loop);
     * ```
     * @param spriteSheet ex.SpriteSheet
     * @param spriteSheetIndex 0 based index from left to right, top down (row major order) of the ex.SpriteSheet
     * @param durationPerFrame duration per frame in milliseconds
     * @param strategy Optional strategy, default AnimationStrategy.Loop
     */
    static fromSpriteSheet(spriteSheet, spriteSheetIndex, durationPerFrame, strategy = AnimationStrategy.Loop) {
        const maxIndex = spriteSheet.sprites.length - 1;
        const invalidIndices = spriteSheetIndex.filter((index) => index < 0 || index > maxIndex);
        if (invalidIndices.length) {
            Animation._LOGGER.warn(`Indices into SpriteSheet were provided that don\'t exist: ${invalidIndices.join(',')} no frame will be shown`);
        }
        return new Animation({
            frames: spriteSheet.sprites
                .filter((_, index) => spriteSheetIndex.indexOf(index) > -1)
                .map((f) => ({
                graphic: f,
                duration: durationPerFrame
            })),
            strategy: strategy
        });
    }
    /**
     * Create an {@apilink Animation} from a {@apilink SpriteSheet} given a list of coordinates
     *
     * Example:
     * ```typescript
     * const spriteSheet = SpriteSheet.fromImageSource({...});
     *
     * const anim = Animation.fromSpriteSheetCoordinates({
     *  spriteSheet,
     *  frameCoordinates: [
     *    {x: 0, y: 5, duration: 100, options { flipHorizontal: true }},
     *    {x: 1, y: 5, duration: 200},
     *    {x: 2, y: 5},
     *    {x: 3, y: 5}
     *  ],
     *  strategy: AnimationStrategy.PingPong
     * });
     * ```
     * @param options
     * @returns Animation
     */
    static fromSpriteSheetCoordinates(options) {
        var _a;
        const { spriteSheet, frameCoordinates, durationPerFrame, durationPerFrameMs, speed, strategy, reverse } = options;
        const defaultDuration = (_a = durationPerFrame !== null && durationPerFrame !== void 0 ? durationPerFrame : durationPerFrameMs) !== null && _a !== void 0 ? _a : 100;
        const frames = [];
        for (const coord of frameCoordinates) {
            const { x, y, duration, options } = coord;
            const sprite = spriteSheet.getSprite(x, y, options);
            if (sprite) {
                frames.push({
                    graphic: sprite,
                    duration: duration !== null && duration !== void 0 ? duration : defaultDuration
                });
            }
            else {
                Animation._LOGGER.warn(`Skipping frame! SpriteSheet does not have coordinate (${x}, ${y}), please check your SpriteSheet to confirm that sprite exists`);
            }
        }
        return new Animation({
            frames,
            strategy,
            speed,
            reverse
        });
    }
    /**
     * Current animation speed
     *
     * 1 meaning normal 1x speed.
     * 2 meaning 2x speed and so on.
     */
    get speed() {
        return this._speed;
    }
    /**
     * Current animation speed
     *
     * 1 meaning normal 1x speed.
     * 2 meaning 2x speed and so on.
     */
    set speed(val) {
        this._speed = (0,_Math_util__WEBPACK_IMPORTED_MODULE_2__.clamp)(Math.abs(val), 0, Infinity);
    }
    /**
     * Returns the current Frame of the animation
     *
     * Use {@apilink Animation.currentFrameIndex} to get the frame number and
     * {@apilink Animation.goToFrame} to set the current frame index
     */
    get currentFrame() {
        if (this._currentFrame >= 0 && this._currentFrame < this.frames.length) {
            return this.frames[this._currentFrame];
        }
        return null;
    }
    /**
     * Returns the current frame index of the animation
     *
     * Use {@apilink Animation.currentFrame} to grab the current {@apilink Frame} object
     */
    get currentFrameIndex() {
        return this._currentFrame;
    }
    /**
     * Returns the amount of time in milliseconds left in the current frame
     */
    get currentFrameTimeLeft() {
        return this._timeLeftInFrame;
    }
    /**
     * Returns `true` if the animation is playing
     */
    get isPlaying() {
        return this._playing;
    }
    get isReversed() {
        return this._reversed;
    }
    /**
     * Reverses the play direction of the Animation, this preserves the current frame
     */
    reverse() {
        // Don't mutate with the original frame list, create a copy
        this.frames = this.frames.slice().reverse();
        this._reversed = !this._reversed;
    }
    /**
     * Returns the current play direction of the animation
     */
    get direction() {
        // Keep logically consistent with ping-pong direction
        // If ping-pong is forward = 1 and reversed is true then we are logically reversed
        const reversed = this._reversed && this._pingPongDirection === 1 ? true : false;
        return reversed ? AnimationDirection.Backward : AnimationDirection.Forward;
    }
    /**
     * Plays or resumes the animation from the current frame
     */
    play() {
        this._playing = true;
    }
    /**
     * Pauses the animation on the current frame
     */
    pause() {
        this._playing = false;
        this._firstTick = true; // firstTick must be set to emit the proper frame event
    }
    /**
     * Reset the animation back to the beginning, including if the animation were done
     */
    reset() {
        this._done = false;
        this._firstTick = true;
        this._currentFrame = 0;
        this._timeLeftInFrame = this.frameDuration;
        const maybeFrame = this.frames[this._currentFrame];
        if (maybeFrame) {
            this._timeLeftInFrame = (maybeFrame === null || maybeFrame === void 0 ? void 0 : maybeFrame.duration) || this.frameDuration;
        }
    }
    /**
     * Returns `true` if the animation can end
     */
    get canFinish() {
        switch (this.strategy) {
            case AnimationStrategy.End:
            case AnimationStrategy.Freeze: {
                return true;
            }
            default: {
                return false;
            }
        }
    }
    /**
     * Returns `true` if the animation is done, for looping type animations
     * `ex.AnimationStrategy.PingPong` and `ex.AnimationStrategy.Loop` this will always return `false`
     *
     * See the `ex.Animation.canFinish()` method to know if an animation type can end
     */
    get done() {
        return this._done;
    }
    /**
     * Jump the animation immediately to a specific frame if it exists
     *
     * Optionally specify an override for the duration of the frame, useful for
     * keeping multiple animations in sync with one another.
     * @param frameNumber
     * @param duration
     */
    goToFrame(frameNumber, duration) {
        this._currentFrame = frameNumber;
        this._timeLeftInFrame = duration !== null && duration !== void 0 ? duration : this.frameDuration;
        const maybeFrame = this.frames[this._currentFrame];
        if (maybeFrame && !this._done) {
            this._timeLeftInFrame = duration !== null && duration !== void 0 ? duration : ((maybeFrame === null || maybeFrame === void 0 ? void 0 : maybeFrame.duration) || this.frameDuration);
            this.events.emit('frame', { ...maybeFrame, frameIndex: this.currentFrameIndex });
        }
    }
    _nextFrame() {
        const currentFrame = this._currentFrame;
        if (this._done) {
            return currentFrame;
        }
        let next = -1;
        switch (this.strategy) {
            case AnimationStrategy.Loop: {
                next = (currentFrame + 1) % this.frames.length;
                if (next === 0) {
                    this.events.emit('loop', this);
                }
                break;
            }
            case AnimationStrategy.End: {
                next = currentFrame + 1;
                if (next >= this.frames.length) {
                    this._done = true;
                    this._currentFrame = this.frames.length;
                    this.events.emit('end', this);
                }
                break;
            }
            case AnimationStrategy.Freeze: {
                next = (0,_Math_util__WEBPACK_IMPORTED_MODULE_2__.clamp)(currentFrame + 1, 0, this.frames.length - 1);
                if (next >= this.frames.length - 1) {
                    this._done = true;
                    this.events.emit('end', this);
                }
                break;
            }
            case AnimationStrategy.PingPong: {
                if (currentFrame + this._pingPongDirection >= this.frames.length) {
                    this._pingPongDirection = -1;
                    this.events.emit('loop', this);
                }
                if (currentFrame + this._pingPongDirection < 0) {
                    this._pingPongDirection = 1;
                    this.events.emit('loop', this);
                }
                next = currentFrame + (this._pingPongDirection % this.frames.length);
                break;
            }
        }
        return next;
    }
    /**
     * Called internally by Excalibur to update the state of the animation potential update the current frame
     * @param elapsed Milliseconds elapsed
     * @param idempotencyToken Prevents double ticking in a frame by passing a unique token to the frame
     */
    tick(elapsed, idempotencyToken = 0) {
        if (this._idempotencyToken === idempotencyToken) {
            return;
        }
        this._idempotencyToken = idempotencyToken;
        if (!this._playing) {
            return;
        }
        // if it's the first frame emit frame event
        if (this._firstTick) {
            this._firstTick = false;
            this.events.emit('frame', { ...this.currentFrame, frameIndex: this.currentFrameIndex });
        }
        this._timeLeftInFrame -= elapsed * this._speed;
        if (this._timeLeftInFrame <= 0) {
            this.goToFrame(this._nextFrame());
        }
    }
    _drawImage(ctx, x, y) {
        if (this.currentFrame && this.currentFrame.graphic) {
            this.currentFrame.graphic.draw(ctx, x, y);
        }
    }
}
Animation._LOGGER = _Util_Log__WEBPACK_IMPORTED_MODULE_3__.Logger.getInstance();


/***/ }),

/***/ "./Graphics/Canvas.ts":
/*!****************************!*\
  !*** ./Graphics/Canvas.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Canvas: () => (/* binding */ Canvas)
/* harmony export */ });
/* harmony import */ var _Raster__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Raster */ "./Graphics/Raster.ts");

/**
 * A canvas {@apilink Graphic} to provide an adapter between the 2D Canvas API and the {@apilink ExcaliburGraphicsContext}.
 *
 * The {@apilink Canvas} works by re-rastering a draw handler to a HTMLCanvasElement for every draw which is then passed
 * to the {@apilink ExcaliburGraphicsContext} implementation as a rendered image.
 *
 * **Low performance API**
 */
class Canvas extends _Raster__WEBPACK_IMPORTED_MODULE_0__.Raster {
    /**
     * Return the 2D graphics context of this canvas
     */
    get ctx() {
        return this._ctx;
    }
    constructor(_options = {}) {
        super(_options);
        this._options = _options;
    }
    clone() {
        return new Canvas({
            ...this._options,
            ...this.cloneGraphicOptions(),
            ...this.cloneRasterOptions()
        });
    }
    execute(ctx) {
        var _a, _b;
        if ((_a = this._options) === null || _a === void 0 ? void 0 : _a.draw) {
            (_b = this._options) === null || _b === void 0 ? void 0 : _b.draw(ctx);
        }
        if (!this._options.cache) {
            this.flagDirty();
        }
    }
}


/***/ }),

/***/ "./Graphics/Circle.ts":
/*!****************************!*\
  !*** ./Graphics/Circle.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Circle: () => (/* binding */ Circle)
/* harmony export */ });
/* harmony import */ var _Filtering__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Filtering */ "./Graphics/Filtering.ts");
/* harmony import */ var _Raster__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Raster */ "./Graphics/Raster.ts");


/**
 * A circle {@apilink Graphic} for drawing circles to the {@apilink ExcaliburGraphicsContext}
 *
 * Circles default to {@apilink ImageFiltering.Blended}
 */
class Circle extends _Raster__WEBPACK_IMPORTED_MODULE_0__.Raster {
    get radius() {
        return this._radius;
    }
    set radius(value) {
        this._radius = value;
        this.width = this._radius * 2;
        this.height = this._radius * 2;
        this.flagDirty();
    }
    constructor(options) {
        var _a, _b, _c;
        super(options);
        this._radius = 0;
        const lineWidth = (_a = options.lineWidth) !== null && _a !== void 0 ? _a : (options.strokeColor ? 1 : 0); // default lineWidth in canvas is 1px
        this.padding = (_b = options.padding) !== null && _b !== void 0 ? _b : 2 + lineWidth / 2; // default 2 padding for circles looks nice
        this.radius = options.radius;
        this.filtering = (_c = options.filtering) !== null && _c !== void 0 ? _c : _Filtering__WEBPACK_IMPORTED_MODULE_1__.ImageFiltering.Blended;
        this.rasterize();
    }
    clone() {
        return new Circle({
            radius: this.radius,
            ...this.cloneGraphicOptions(),
            ...this.cloneRasterOptions()
        });
    }
    execute(ctx) {
        if (this.radius > 0) {
            ctx.beginPath();
            ctx.arc(this.radius, this.radius, this.radius, 0, Math.PI * 2);
            if (this.color) {
                ctx.fill();
            }
            if (this.strokeColor) {
                ctx.stroke();
            }
        }
    }
}


/***/ }),

/***/ "./Graphics/Context/ExcaliburGraphicsContext.ts":
/*!******************************************************!*\
  !*** ./Graphics/Context/ExcaliburGraphicsContext.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultAntialiasOptions: () => (/* binding */ DefaultAntialiasOptions),
/* harmony export */   DefaultPixelArtOptions: () => (/* binding */ DefaultPixelArtOptions)
/* harmony export */ });
/* harmony import */ var _Filtering__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Filtering */ "./Graphics/Filtering.ts");

const DefaultAntialiasOptions = {
    pixelArtSampler: false,
    nativeContextAntialiasing: false,
    multiSampleAntialiasing: true,
    filtering: _Filtering__WEBPACK_IMPORTED_MODULE_0__.ImageFiltering.Blended,
    canvasImageRendering: 'auto'
};
const DefaultPixelArtOptions = {
    pixelArtSampler: true,
    nativeContextAntialiasing: false,
    multiSampleAntialiasing: true,
    filtering: _Filtering__WEBPACK_IMPORTED_MODULE_0__.ImageFiltering.Blended,
    canvasImageRendering: 'auto'
};


/***/ }),

/***/ "./Graphics/Context/ExcaliburGraphicsContext2DCanvas.ts":
/*!**************************************************************!*\
  !*** ./Graphics/Context/ExcaliburGraphicsContext2DCanvas.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ExcaliburGraphicsContext2DCanvas: () => (/* binding */ ExcaliburGraphicsContext2DCanvas)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Color */ "./Color.ts");
/* harmony import */ var _state_stack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./state-stack */ "./Graphics/Context/state-stack.ts");
/* harmony import */ var _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../GraphicsDiagnostics */ "./Graphics/GraphicsDiagnostics.ts");
/* harmony import */ var _debug_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./debug-text */ "./Graphics/Context/debug-text.ts");




const pixelSnapEpsilon = 0.0001;
class ExcaliburGraphicsContext2DCanvasDebug {
    constructor(_ex) {
        this._ex = _ex;
        this._debugText = new _debug_text__WEBPACK_IMPORTED_MODULE_0__.DebugText();
    }
    /**
     * Draw a debug rectangle to the context
     * @param x
     * @param y
     * @param width
     * @param height
     */
    drawRect(x, y, width, height) {
        this._ex.__ctx.save();
        this._ex.__ctx.strokeStyle = 'red';
        this._ex.__ctx.strokeRect(this._ex.snapToPixel ? ~~(x + pixelSnapEpsilon) : x, this._ex.snapToPixel ? ~~(y + pixelSnapEpsilon) : y, this._ex.snapToPixel ? ~~(width + pixelSnapEpsilon) : width, this._ex.snapToPixel ? ~~(height + pixelSnapEpsilon) : height);
        this._ex.__ctx.restore();
    }
    drawLine(start, end, lineOptions = { color: _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Black }) {
        var _a, _b;
        this._ex.__ctx.save();
        this._ex.__ctx.beginPath();
        this._ex.__ctx.strokeStyle = (_b = (_a = lineOptions.color) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : '';
        this._ex.__ctx.moveTo(this._ex.snapToPixel ? ~~(start.x + pixelSnapEpsilon) : start.x, this._ex.snapToPixel ? ~~(start.y + pixelSnapEpsilon) : start.y);
        this._ex.__ctx.lineTo(this._ex.snapToPixel ? ~~(end.x + pixelSnapEpsilon) : end.x, this._ex.snapToPixel ? ~~(end.y + pixelSnapEpsilon) : end.y);
        this._ex.__ctx.lineWidth = 2;
        this._ex.__ctx.stroke();
        this._ex.__ctx.closePath();
        this._ex.__ctx.restore();
    }
    drawPoint(point, pointOptions = { color: _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Black, size: 5 }) {
        this._ex.__ctx.save();
        this._ex.__ctx.beginPath();
        this._ex.__ctx.fillStyle = pointOptions.color.toString();
        this._ex.__ctx.arc(this._ex.snapToPixel ? ~~(point.x + pixelSnapEpsilon) : point.x, this._ex.snapToPixel ? ~~(point.y + pixelSnapEpsilon) : point.y, pointOptions.size, 0, Math.PI * 2);
        this._ex.__ctx.fill();
        this._ex.__ctx.closePath();
        this._ex.__ctx.restore();
    }
    drawText(text, pos) {
        this._debugText.write(this._ex, text, pos);
    }
}
class ExcaliburGraphicsContext2DCanvas {
    get width() {
        return this.__ctx.canvas.width;
    }
    get height() {
        return this.__ctx.canvas.height;
    }
    get opacity() {
        return this._state.current.opacity;
    }
    set opacity(value) {
        this._state.current.opacity = value;
    }
    get tint() {
        return this._state.current.tint;
    }
    set tint(color) {
        this._state.current.tint = color;
    }
    get smoothing() {
        return this.__ctx.imageSmoothingEnabled;
    }
    set smoothing(value) {
        this.__ctx.imageSmoothingEnabled = value;
    }
    constructor(options) {
        /**
         * Unused in Canvas implementation
         */
        this.useDrawSorting = false;
        /**
         * Unused in Canvas implementation
         */
        this.z = 0;
        this.backgroundColor = _Color__WEBPACK_IMPORTED_MODULE_1__.Color.ExcaliburBlue;
        this._state = new _state_stack__WEBPACK_IMPORTED_MODULE_2__.StateStack();
        this.snapToPixel = false;
        this.debug = new ExcaliburGraphicsContext2DCanvasDebug(this);
        const { canvasElement, context, enableTransparency, snapToPixel, antialiasing: smoothing, backgroundColor } = options;
        this.__ctx =
            context !== null && context !== void 0 ? context : canvasElement.getContext('2d', {
                alpha: enableTransparency !== null && enableTransparency !== void 0 ? enableTransparency : true
            });
        if (!this.__ctx) {
            throw new Error('Cannot build new ExcaliburGraphicsContext2D for some reason!');
        }
        this.backgroundColor = backgroundColor !== null && backgroundColor !== void 0 ? backgroundColor : this.backgroundColor;
        this.snapToPixel = snapToPixel !== null && snapToPixel !== void 0 ? snapToPixel : this.snapToPixel;
        this.smoothing = smoothing !== null && smoothing !== void 0 ? smoothing : this.smoothing;
    }
    resetTransform() {
        this.__ctx.resetTransform();
    }
    updateViewport(_resolution) {
        // pass
    }
    drawImage(image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight) {
        if (swidth === 0 || sheight === 0) {
            return; // zero dimension dest exit early
        }
        else if (dwidth === 0 || dheight === 0) {
            return; // zero dimension dest exit early
        }
        else if (image.width === 0 || image.height === 0) {
            return; // zero dimension source exit early
        }
        this.__ctx.globalAlpha = this.opacity;
        const args = [image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight]
            .filter((a) => a !== undefined)
            .map((a) => (typeof a === 'number' && this.snapToPixel ? ~~a : a));
        this.__ctx.drawImage.apply(this.__ctx, args);
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_3__.GraphicsDiagnostics.DrawCallCount++;
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_3__.GraphicsDiagnostics.DrawnImagesCount = 1;
    }
    drawLine(start, end, color, thickness = 1) {
        this.__ctx.save();
        this.__ctx.beginPath();
        this.__ctx.strokeStyle = color.toString();
        this.__ctx.moveTo(this.snapToPixel ? ~~(start.x + pixelSnapEpsilon) : start.x, this.snapToPixel ? ~~(start.y + pixelSnapEpsilon) : start.y);
        this.__ctx.lineTo(this.snapToPixel ? ~~(end.x + pixelSnapEpsilon) : end.x, this.snapToPixel ? ~~(end.y + pixelSnapEpsilon) : end.y);
        this.__ctx.lineWidth = thickness;
        this.__ctx.stroke();
        this.__ctx.closePath();
        this.__ctx.restore();
    }
    drawRectangle(pos, width, height, color) {
        this.__ctx.save();
        this.__ctx.fillStyle = color.toString();
        this.__ctx.fillRect(this.snapToPixel ? ~~(pos.x + pixelSnapEpsilon) : pos.x, this.snapToPixel ? ~~(pos.y + pixelSnapEpsilon) : pos.y, this.snapToPixel ? ~~(width + pixelSnapEpsilon) : width, this.snapToPixel ? ~~(height + pixelSnapEpsilon) : height);
        this.__ctx.restore();
    }
    drawCircle(pos, radius, color, stroke, thickness) {
        this.__ctx.save();
        this.__ctx.beginPath();
        if (stroke) {
            this.__ctx.strokeStyle = stroke.toString();
        }
        if (thickness) {
            this.__ctx.lineWidth = thickness;
        }
        this.__ctx.fillStyle = color.toString();
        this.__ctx.arc(this.snapToPixel ? ~~(pos.x + pixelSnapEpsilon) : pos.x, this.snapToPixel ? ~~(pos.y + pixelSnapEpsilon) : pos.y, radius, 0, Math.PI * 2);
        this.__ctx.fill();
        if (stroke) {
            this.__ctx.stroke();
        }
        this.__ctx.closePath();
        this.__ctx.restore();
    }
    /**
     * Save the current state of the canvas to the stack (transforms and opacity)
     */
    save() {
        this.__ctx.save();
        this._state.save();
    }
    /**
     * Restore the state of the canvas from the stack
     */
    restore() {
        this.__ctx.restore();
        this._state.restore();
    }
    /**
     * Translate the origin of the context by an x and y
     * @param x
     * @param y
     */
    translate(x, y) {
        this.__ctx.translate(this.snapToPixel ? ~~(x + pixelSnapEpsilon) : x, this.snapToPixel ? ~~(y + pixelSnapEpsilon) : y);
    }
    /**
     * Rotate the context about the current origin
     */
    rotate(angle) {
        this.__ctx.rotate(angle);
    }
    /**
     * Scale the context by an x and y factor
     * @param x
     * @param y
     */
    scale(x, y) {
        this.__ctx.scale(x, y);
    }
    getTransform() {
        throw new Error('Not implemented');
    }
    multiply(_m) {
        this.__ctx.setTransform(this.__ctx.getTransform().multiply(_m.toDOMMatrix()));
    }
    addPostProcessor(_postprocessor) {
        // pass
    }
    removePostProcessor(_postprocessor) {
        // pass
    }
    clearPostProcessors() {
        // pass
    }
    updatePostProcessors(elapsed) {
        // pass
    }
    beginDrawLifecycle() {
        // pass
    }
    endDrawLifecycle() {
        // pass
    }
    set material(material) {
        this._state.current.material = material;
    }
    get material() {
        return this._state.current.material;
    }
    createMaterial(options) {
        // pass
        return null;
    }
    clear() {
        // Clear frame
        this.__ctx.clearRect(0, 0, this.width, this.height);
        this.__ctx.fillStyle = this.backgroundColor.toString();
        this.__ctx.fillRect(0, 0, this.width, this.height);
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_3__.GraphicsDiagnostics.clear();
    }
    /**
     * Flushes the batched draw calls to the screen
     */
    flush() {
        // pass
    }
    dispose() {
        this.__ctx = undefined;
    }
}


/***/ }),

/***/ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts":
/*!***********************************************************!*\
  !*** ./Graphics/Context/ExcaliburGraphicsContextWebGL.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ExcaliburGraphicsContextWebGL: () => (/* binding */ ExcaliburGraphicsContextWebGL),
/* harmony export */   pixelSnapEpsilon: () => (/* binding */ pixelSnapEpsilon)
/* harmony export */ });
/* harmony import */ var _Math_matrix__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../Math/matrix */ "./Math/matrix.ts");
/* harmony import */ var _transform_stack__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./transform-stack */ "./Graphics/Context/transform-stack.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Color */ "./Color.ts");
/* harmony import */ var _state_stack__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./state-stack */ "./Graphics/Context/state-stack.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _debug_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./debug-text */ "./Graphics/Context/debug-text.ts");
/* harmony import */ var _render_target__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./render-target */ "./Graphics/Context/render-target.ts");
/* harmony import */ var _texture_loader__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./texture-loader */ "./Graphics/Context/texture-loader.ts");
/* harmony import */ var _line_renderer_line_renderer__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./line-renderer/line-renderer */ "./Graphics/Context/line-renderer/line-renderer.ts");
/* harmony import */ var _point_renderer_point_renderer__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./point-renderer/point-renderer */ "./Graphics/Context/point-renderer/point-renderer.ts");
/* harmony import */ var _screen_pass_painter_screen_pass_painter__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./screen-pass-painter/screen-pass-painter */ "./Graphics/Context/screen-pass-painter/screen-pass-painter.ts");
/* harmony import */ var _image_renderer_image_renderer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./image-renderer/image-renderer */ "./Graphics/Context/image-renderer/image-renderer.ts");
/* harmony import */ var _rectangle_renderer_rectangle_renderer__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./rectangle-renderer/rectangle-renderer */ "./Graphics/Context/rectangle-renderer/rectangle-renderer.ts");
/* harmony import */ var _circle_renderer_circle_renderer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./circle-renderer/circle-renderer */ "./Graphics/Context/circle-renderer/circle-renderer.ts");
/* harmony import */ var _Util_Pool__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Util/Pool */ "./Util/Pool.ts");
/* harmony import */ var _draw_call__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./draw-call */ "./Graphics/Context/draw-call.ts");
/* harmony import */ var _material__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./material */ "./Graphics/Context/material.ts");
/* harmony import */ var _material_renderer_material_renderer__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./material-renderer/material-renderer */ "./Graphics/Context/material-renderer/material-renderer.ts");
/* harmony import */ var _shader__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./shader */ "./Graphics/Context/shader.ts");
/* harmony import */ var _particle_renderer_particle_renderer__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./particle-renderer/particle-renderer */ "./Graphics/Context/particle-renderer/particle-renderer.ts");
/* harmony import */ var _image_renderer_v2_image_renderer_v2__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./image-renderer-v2/image-renderer-v2 */ "./Graphics/Context/image-renderer-v2/image-renderer-v2.ts");
/* harmony import */ var _Flags__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Flags */ "./Flags.ts");









// renderers














const pixelSnapEpsilon = 0.0001;
class ExcaliburGraphicsContextWebGLDebug {
    constructor(_webglCtx) {
        this._webglCtx = _webglCtx;
        this._debugText = new _debug_text__WEBPACK_IMPORTED_MODULE_0__.DebugText();
    }
    /**
     * Draw a debugging rectangle to the context
     * @param x
     * @param y
     * @param width
     * @param height
     */
    drawRect(x, y, width, height, rectOptions = { color: _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Black }) {
        this.drawLine((0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(x, y), (0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(x + width, y), { ...rectOptions });
        this.drawLine((0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(x + width, y), (0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(x + width, y + height), { ...rectOptions });
        this.drawLine((0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(x + width, y + height), (0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(x, y + height), { ...rectOptions });
        this.drawLine((0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(x, y + height), (0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(x, y), { ...rectOptions });
    }
    /**
     * Draw a debugging line to the context
     * @param start
     * @param end
     * @param lineOptions
     */
    drawLine(start, end, lineOptions) {
        var _a;
        this._webglCtx.draw('ex.line', start, end, (_a = lineOptions === null || lineOptions === void 0 ? void 0 : lineOptions.color) !== null && _a !== void 0 ? _a : _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Black);
    }
    /**
     * Draw a debugging point to the context
     * @param point
     * @param pointOptions
     */
    drawPoint(point, pointOptions = { color: _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Black, size: 5 }) {
        this._webglCtx.draw('ex.point', point, pointOptions.color, pointOptions.size);
    }
    drawText(text, pos) {
        this._debugText.write(this._webglCtx, text, pos);
    }
}
class ExcaliburGraphicsContextWebGL {
    get z() {
        return this._state.current.z;
    }
    set z(value) {
        this._state.current.z = value;
    }
    get opacity() {
        return this._state.current.opacity;
    }
    set opacity(value) {
        this._state.current.opacity = value;
    }
    get tint() {
        return this._state.current.tint;
    }
    set tint(color) {
        this._state.current.tint = color;
    }
    get width() {
        return this.__gl.canvas.width;
    }
    get height() {
        return this.__gl.canvas.height;
    }
    get ortho() {
        return this._ortho;
    }
    /**
     * Checks the underlying webgl implementation if the requested internal resolution is supported
     * @param dim
     */
    checkIfResolutionSupported(dim) {
        // Slight hack based on this thread https://groups.google.com/g/webgl-dev-list/c/AHONvz3oQTo
        let supported = true;
        if (dim.width > 4096 || dim.height > 4096) {
            supported = false;
        }
        return supported;
    }
    constructor(options) {
        this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_3__.Logger.getInstance();
        this._renderers = new Map();
        this._lazyRenderersFactory = new Map();
        this.imageRenderer = _Flags__WEBPACK_IMPORTED_MODULE_4__.Flags.isEnabled('use-legacy-image-renderer') ? 'ex.image' : 'ex.image-v2';
        this._isDrawLifecycle = false;
        this.useDrawSorting = true;
        this._drawCallPool = new _Util_Pool__WEBPACK_IMPORTED_MODULE_5__.Pool(() => new _draw_call__WEBPACK_IMPORTED_MODULE_6__.DrawCall(), undefined, 4000);
        this._drawCallIndex = 0;
        this._drawCalls = new Array(4000).fill(null);
        // Postprocessing is a tuple with 2 render targets, these are flip-flopped during the postprocessing process
        this._postProcessTargets = [];
        this._postprocessors = [];
        this._transform = new _transform_stack__WEBPACK_IMPORTED_MODULE_7__.TransformStack();
        this._state = new _state_stack__WEBPACK_IMPORTED_MODULE_8__.StateStack();
        /**
         * Snaps the drawing x/y coordinate to the nearest whole pixel
         */
        this.snapToPixel = false;
        /**
         * Native context smoothing
         */
        this.smoothing = false;
        /**
         * Whether the pixel art sampler is enabled for smooth sub pixel anti-aliasing
         */
        this.pixelArtSampler = false;
        /**
         * UV padding in pixels to use in internal image rendering to prevent texture bleed
         *
         */
        this.uvPadding = 0.01;
        this.backgroundColor = _Color__WEBPACK_IMPORTED_MODULE_1__.Color.ExcaliburBlue;
        this.multiSampleAntialiasing = true;
        this.transparency = true;
        this._isContextLost = false;
        this._disposed = false;
        this._imageToWidth = new Map();
        this._imageToHeight = new Map();
        this.debug = new ExcaliburGraphicsContextWebGLDebug(this);
        this._totalPostProcessorTime = 0;
        const { canvasElement, context, enableTransparency, antialiasing, uvPadding, multiSampleAntialiasing, pixelArtSampler, powerPreference, snapToPixel, backgroundColor, useDrawSorting, garbageCollector, handleContextLost, handleContextRestored } = options;
        this.__gl =
            context !== null && context !== void 0 ? context : canvasElement.getContext('webgl2', {
                antialias: antialiasing !== null && antialiasing !== void 0 ? antialiasing : this.smoothing,
                premultipliedAlpha: false,
                alpha: enableTransparency !== null && enableTransparency !== void 0 ? enableTransparency : this.transparency,
                depth: false,
                powerPreference: powerPreference !== null && powerPreference !== void 0 ? powerPreference : 'high-performance'
            });
        if (!this.__gl) {
            throw Error('Failed to retrieve webgl context from browser');
        }
        if (handleContextLost) {
            this.__gl.canvas.addEventListener('webglcontextlost', handleContextLost, false);
        }
        if (handleContextRestored) {
            this.__gl.canvas.addEventListener('webglcontextrestored', handleContextRestored, false);
        }
        this.__gl.canvas.addEventListener('webglcontextlost', () => {
            this._isContextLost = true;
        });
        this.__gl.canvas.addEventListener('webglcontextrestored', () => {
            this._isContextLost = false;
        });
        this.textureLoader = new _texture_loader__WEBPACK_IMPORTED_MODULE_9__.TextureLoader(this.__gl, garbageCollector);
        this.snapToPixel = snapToPixel !== null && snapToPixel !== void 0 ? snapToPixel : this.snapToPixel;
        this.smoothing = antialiasing !== null && antialiasing !== void 0 ? antialiasing : this.smoothing;
        this.transparency = enableTransparency !== null && enableTransparency !== void 0 ? enableTransparency : this.transparency;
        this.pixelArtSampler = pixelArtSampler !== null && pixelArtSampler !== void 0 ? pixelArtSampler : this.pixelArtSampler;
        this.uvPadding = uvPadding !== null && uvPadding !== void 0 ? uvPadding : this.uvPadding;
        this.multiSampleAntialiasing = typeof multiSampleAntialiasing === 'boolean' ? multiSampleAntialiasing : this.multiSampleAntialiasing;
        this.samples = typeof multiSampleAntialiasing === 'object' ? multiSampleAntialiasing.samples : undefined;
        this.backgroundColor = backgroundColor !== null && backgroundColor !== void 0 ? backgroundColor : this.backgroundColor;
        this.useDrawSorting = useDrawSorting !== null && useDrawSorting !== void 0 ? useDrawSorting : this.useDrawSorting;
        this._drawCallPool.disableWarnings = true;
        this._drawCallPool.preallocate();
        this._init();
    }
    dispose() {
        if (!this._disposed) {
            this._disposed = true;
            this.textureLoader.dispose();
            for (const renderer of this._renderers.values()) {
                renderer.dispose();
            }
            this._renderers.clear();
            this._drawCallPool.dispose();
            this._drawCalls.length = 0;
            this.__gl = null;
        }
    }
    _init() {
        const gl = this.__gl;
        // Setup viewport and view matrix
        this._ortho = _Math_matrix__WEBPACK_IMPORTED_MODULE_10__.Matrix.ortho(0, gl.canvas.width, gl.canvas.height, 0, 400, -400);
        gl.viewport(0, 0, gl.canvas.width, gl.canvas.height);
        // Clear background
        gl.clearColor(this.backgroundColor.r / 255, this.backgroundColor.g / 255, this.backgroundColor.b / 255, this.backgroundColor.a);
        gl.clear(gl.COLOR_BUFFER_BIT);
        // Enable alpha blending
        // https://www.realtimerendering.com/blog/gpus-prefer-premultiplication/
        gl.enable(gl.BLEND);
        gl.blendEquation(gl.FUNC_ADD);
        gl.blendFunc(gl.ONE, gl.ONE_MINUS_SRC_ALPHA);
        gl.blendEquationSeparate(gl.FUNC_ADD, gl.FUNC_ADD);
        gl.blendFuncSeparate(gl.ONE, gl.ONE_MINUS_SRC_ALPHA, gl.ONE, gl.ONE_MINUS_SRC_ALPHA);
        gl.depthMask(false);
        // Setup builtin renderers
        this.register(new _image_renderer_image_renderer__WEBPACK_IMPORTED_MODULE_11__.ImageRenderer({
            uvPadding: this.uvPadding,
            pixelArtSampler: this.pixelArtSampler
        }));
        this.register(new _material_renderer_material_renderer__WEBPACK_IMPORTED_MODULE_12__.MaterialRenderer());
        this.register(new _rectangle_renderer_rectangle_renderer__WEBPACK_IMPORTED_MODULE_13__.RectangleRenderer());
        this.register(new _circle_renderer_circle_renderer__WEBPACK_IMPORTED_MODULE_14__.CircleRenderer());
        this.register(new _point_renderer_point_renderer__WEBPACK_IMPORTED_MODULE_15__.PointRenderer());
        this.register(new _line_renderer_line_renderer__WEBPACK_IMPORTED_MODULE_16__.LineRenderer());
        this.lazyRegister('ex.particle', () => new _particle_renderer_particle_renderer__WEBPACK_IMPORTED_MODULE_17__.ParticleRenderer());
        this.register(new _image_renderer_v2_image_renderer_v2__WEBPACK_IMPORTED_MODULE_18__.ImageRendererV2({
            uvPadding: this.uvPadding,
            pixelArtSampler: this.pixelArtSampler
        }));
        this.materialScreenTexture = gl.createTexture();
        if (!this.materialScreenTexture) {
            throw new Error('Could not create screen texture!');
        }
        gl.bindTexture(gl.TEXTURE_2D, this.materialScreenTexture);
        gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, this.width, this.height, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.REPEAT);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.REPEAT);
        gl.bindTexture(gl.TEXTURE_2D, null);
        this._screenRenderer = new _screen_pass_painter_screen_pass_painter__WEBPACK_IMPORTED_MODULE_19__.ScreenPassPainter(this);
        this._renderTarget = new _render_target__WEBPACK_IMPORTED_MODULE_20__.RenderTarget({
            gl,
            transparency: this.transparency,
            width: gl.canvas.width,
            height: gl.canvas.height
        });
        this._postProcessTargets = [
            new _render_target__WEBPACK_IMPORTED_MODULE_20__.RenderTarget({
                gl,
                transparency: this.transparency,
                width: gl.canvas.width,
                height: gl.canvas.height
            }),
            new _render_target__WEBPACK_IMPORTED_MODULE_20__.RenderTarget({
                gl,
                transparency: this.transparency,
                width: gl.canvas.width,
                height: gl.canvas.height
            })
        ];
        this._msaaTarget = new _render_target__WEBPACK_IMPORTED_MODULE_20__.RenderTarget({
            gl,
            transparency: this.transparency,
            width: gl.canvas.width,
            height: gl.canvas.height,
            antialias: this.multiSampleAntialiasing,
            samples: this.samples
        });
    }
    register(renderer) {
        this._renderers.set(renderer.type, renderer);
        renderer.initialize(this.__gl, this);
    }
    lazyRegister(type, renderer) {
        this._lazyRenderersFactory.set(type, renderer);
    }
    get(rendererName) {
        let maybeRenderer = this._renderers.get(rendererName);
        if (!maybeRenderer) {
            const lazyFactory = this._lazyRenderersFactory.get(rendererName);
            if (lazyFactory) {
                this._logger.debug('lazy init renderer:', rendererName);
                maybeRenderer = lazyFactory();
                this.register(maybeRenderer);
            }
        }
        return maybeRenderer;
    }
    _isCurrentRenderer(renderer) {
        if (!this._currentRenderer || this._currentRenderer === renderer) {
            return true;
        }
        return false;
    }
    beginDrawLifecycle() {
        this._isDrawLifecycle = true;
    }
    endDrawLifecycle() {
        this._isDrawLifecycle = false;
    }
    draw(rendererName, ...args) {
        if (true) {
            if (args.length > 9) {
                throw new Error('Only 10 or less renderer arguments are supported!;');
            }
        }
        if (!this._isDrawLifecycle) {
            this._logger.warnOnce(`Attempting to draw outside the the drawing lifecycle (preDraw/postDraw) is not supported and is a source of bugs/errors.\n` +
                `If you want to do custom drawing, use Actor.graphics, or any onPreDraw or onPostDraw handler.`);
        }
        if (this._isContextLost) {
            this._logger.errorOnce(`Unable to draw ${rendererName}, the webgl context is lost`);
            return;
        }
        const renderer = this.get(rendererName);
        if (renderer) {
            if (this.useDrawSorting) {
                const drawCall = this._drawCallPool.get();
                drawCall.z = this._state.current.z;
                drawCall.priority = renderer.priority;
                drawCall.renderer = rendererName;
                this.getTransform().clone(drawCall.transform);
                drawCall.state.z = this._state.current.z;
                drawCall.state.opacity = this._state.current.opacity;
                drawCall.state.tint = this._state.current.tint;
                drawCall.state.material = this._state.current.material;
                drawCall.args[0] = args[0];
                drawCall.args[1] = args[1];
                drawCall.args[2] = args[2];
                drawCall.args[3] = args[3];
                drawCall.args[4] = args[4];
                drawCall.args[5] = args[5];
                drawCall.args[6] = args[6];
                drawCall.args[7] = args[7];
                drawCall.args[8] = args[8];
                drawCall.args[9] = args[9];
                this._drawCalls[this._drawCallIndex++] = drawCall;
            }
            else {
                // Set the current renderer if not defined
                if (!this._currentRenderer) {
                    this._currentRenderer = renderer;
                }
                if (!this._isCurrentRenderer(renderer)) {
                    // switching graphics means we must flush the previous
                    this._currentRenderer.flush();
                }
                // If we are still using the same renderer we can add to the current batch
                renderer.draw(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
                this._currentRenderer = renderer;
            }
        }
        else {
            throw Error(`No renderer with name ${rendererName} has been registered`);
        }
    }
    resetTransform() {
        this._transform.reset();
    }
    updateViewport(resolution) {
        const gl = this.__gl;
        this._ortho = this._ortho = _Math_matrix__WEBPACK_IMPORTED_MODULE_10__.Matrix.ortho(0, resolution.width, resolution.height, 0, 400, -400);
        this._renderTarget.setResolution(gl.canvas.width, gl.canvas.height);
        this._msaaTarget.setResolution(gl.canvas.width, gl.canvas.height);
        this._postProcessTargets[0].setResolution(gl.canvas.width, gl.canvas.height);
        this._postProcessTargets[1].setResolution(gl.canvas.width, gl.canvas.height);
    }
    _getImageWidth(image) {
        let maybeWidth = this._imageToWidth.get(image);
        if (maybeWidth === undefined) {
            maybeWidth = image.width;
            this._imageToWidth.set(image, maybeWidth);
        }
        return maybeWidth;
    }
    _getImageHeight(image) {
        let maybeHeight = this._imageToHeight.get(image);
        if (maybeHeight === undefined) {
            maybeHeight = image.height;
            this._imageToHeight.set(image, maybeHeight);
        }
        return maybeHeight;
    }
    drawImage(image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight) {
        if (swidth === 0 || sheight === 0) {
            return; // zero dimension dest exit early
        }
        else if (dwidth === 0 || dheight === 0) {
            return; // zero dimension dest exit early
        }
        else if (this._getImageWidth(image) === 0 || this._getImageHeight(image) === 0) {
            return; // zero dimension source exit early
        }
        if (!image) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_3__.Logger.getInstance().warn('Cannot draw a null or undefined image');
            // tslint:disable-next-line: no-console
            if (console.trace) {
                // tslint:disable-next-line: no-console
                console.trace();
            }
            return;
        }
        if (this._state.current.material) {
            this.draw('ex.material', image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight);
        }
        else {
            if (this.imageRenderer === 'ex.image') {
                this.draw(this.imageRenderer, image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight);
            }
            else {
                this.draw(this.imageRenderer, image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight);
            }
        }
    }
    drawLine(start, end, color, thickness = 1) {
        this.draw('ex.rectangle', start, end, color, thickness);
    }
    drawRectangle(pos, width, height, color, stroke, strokeThickness) {
        this.draw('ex.rectangle', pos, width, height, color, stroke, strokeThickness);
    }
    drawCircle(pos, radius, color, stroke, thickness) {
        this.draw('ex.circle', pos, radius, color, stroke, thickness);
    }
    save() {
        this._transform.save();
        this._state.save();
    }
    restore() {
        this._transform.restore();
        this._state.restore();
    }
    translate(x, y) {
        this._transform.translate(this.snapToPixel ? ~~(x + pixelSnapEpsilon) : x, this.snapToPixel ? ~~(y + pixelSnapEpsilon) : y);
    }
    rotate(angle) {
        this._transform.rotate(angle);
    }
    scale(x, y) {
        this._transform.scale(x, y);
    }
    transform(matrix) {
        this._transform.current = matrix;
    }
    getTransform() {
        return this._transform.current;
    }
    multiply(m) {
        this._transform.current.multiply(m, this._transform.current);
    }
    addPostProcessor(postprocessor) {
        this._postprocessors.push(postprocessor);
        postprocessor.initialize(this);
    }
    removePostProcessor(postprocessor) {
        const index = this._postprocessors.indexOf(postprocessor);
        if (index !== -1) {
            this._postprocessors.splice(index, 1);
        }
    }
    clearPostProcessors() {
        this._postprocessors.length = 0;
    }
    updatePostProcessors(elapsed) {
        for (const postprocessor of this._postprocessors) {
            const shader = postprocessor.getShader();
            shader.use();
            const uniforms = shader.getUniformDefinitions();
            this._totalPostProcessorTime += elapsed;
            if (uniforms.find((u) => u.name === 'u_time_ms')) {
                shader.setUniformFloat('u_time_ms', this._totalPostProcessorTime);
            }
            if (uniforms.find((u) => u.name === 'u_elapsed_ms')) {
                shader.setUniformFloat('u_elapsed_ms', elapsed);
            }
            if (uniforms.find((u) => u.name === 'u_resolution')) {
                shader.setUniformFloatVector('u_resolution', (0,_Math_vector__WEBPACK_IMPORTED_MODULE_2__.vec)(this.width, this.height));
            }
            if (postprocessor.onUpdate) {
                postprocessor.onUpdate(elapsed);
            }
        }
    }
    set material(material) {
        this._state.current.material = material;
    }
    get material() {
        return this._state.current.material;
    }
    /**
     * Creates and initializes the material which compiles the internal shader
     * @param options
     * @returns Material
     */
    createMaterial(options) {
        const material = new _material__WEBPACK_IMPORTED_MODULE_21__.Material({ ...options, graphicsContext: this });
        return material;
    }
    createShader(options) {
        const { name, vertexSource, fragmentSource, uniforms, images, startingTextureSlot } = options;
        const shader = new _shader__WEBPACK_IMPORTED_MODULE_22__.Shader({
            name,
            graphicsContext: this,
            vertexSource,
            fragmentSource,
            uniforms,
            images,
            startingTextureSlot
        });
        shader.compile();
        return shader;
    }
    clear() {
        const gl = this.__gl;
        const currentTarget = this.multiSampleAntialiasing ? this._msaaTarget : this._renderTarget;
        currentTarget.use();
        gl.clearColor(this.backgroundColor.r / 255, this.backgroundColor.g / 255, this.backgroundColor.b / 255, this.backgroundColor.a);
        // Clear the context with the newly set color. This is
        // the function call that actually does the drawing.
        gl.clear(gl.COLOR_BUFFER_BIT);
    }
    /**
     * Flushes all batched rendering to the screen
     */
    flush() {
        var _a;
        if (this._isContextLost) {
            this._logger.errorOnce(`Unable to flush the webgl context is lost`);
            return;
        }
        // render target captures all draws and redirects to the render target
        let currentTarget = this.multiSampleAntialiasing ? this._msaaTarget : this._renderTarget;
        currentTarget.use();
        if (this.useDrawSorting) {
            // null out unused draw calls
            for (let i = this._drawCallIndex; i < this._drawCalls.length; i++) {
                this._drawCalls[i] = null;
            }
            // sort draw calls
            // Find the original order of the first instance of the draw call
            const originalSort = new Map();
            for (const [name] of this._renderers) {
                let firstIndex = 0;
                for (firstIndex = 0; firstIndex < this._drawCallIndex; firstIndex++) {
                    if (this._drawCalls[firstIndex].renderer === name) {
                        break;
                    }
                }
                originalSort.set(name, firstIndex);
            }
            this._drawCalls.sort((a, b) => {
                if (a === null || b === null) {
                    return 0;
                }
                const zIndex = a.z - b.z;
                const originalSortOrder = originalSort.get(a.renderer) - originalSort.get(b.renderer);
                const priority = a.priority - b.priority;
                if (zIndex === 0) {
                    // sort by z first
                    if (priority === 0) {
                        // sort by priority
                        return originalSortOrder; // use the original order to inform draw call packing to maximally preserve painter order
                    }
                    return priority;
                }
                return zIndex;
            });
            const oldTransform = this._transform.current;
            const oldState = this._state.current;
            if (this._drawCalls.length && this._drawCallIndex) {
                let currentRendererName = this._drawCalls[0].renderer;
                let currentRenderer = this.get(currentRendererName);
                for (let i = 0; i < this._drawCallIndex; i++) {
                    // hydrate the state for renderers
                    this._transform.current = this._drawCalls[i].transform;
                    this._state.current = this._drawCalls[i].state;
                    if (this._drawCalls[i].renderer !== currentRendererName) {
                        // switching graphics renderer means we must flush the previous
                        currentRenderer.flush();
                        currentRendererName = this._drawCalls[i].renderer;
                        currentRenderer = this.get(currentRendererName);
                    }
                    // ! hack to grab screen texture before materials run because they might want it
                    if (currentRenderer instanceof _material_renderer_material_renderer__WEBPACK_IMPORTED_MODULE_12__.MaterialRenderer && ((_a = this.material) === null || _a === void 0 ? void 0 : _a.isUsingScreenTexture)) {
                        currentTarget.copyToTexture(this.materialScreenTexture);
                        currentTarget.use();
                    }
                    // If we are still using the same renderer we can add to the current batch
                    currentRenderer.draw(...this._drawCalls[i].args);
                }
                if (currentRenderer.hasPendingDraws()) {
                    currentRenderer.flush();
                }
            }
            // reset state
            this._transform.current = oldTransform;
            this._state.current = oldState;
            // reclaim draw calls
            this._drawCallPool.done();
            this._drawCallIndex = 0;
            this._imageToHeight.clear();
            this._imageToWidth.clear();
        }
        else {
            // This is the final flush at the moment to draw any leftover pending draw
            for (const renderer of this._renderers.values()) {
                if (renderer.hasPendingDraws()) {
                    renderer.flush();
                }
            }
        }
        currentTarget.disable();
        // post process step
        if (this._postprocessors.length > 0) {
            currentTarget.toRenderSource().use();
        }
        // flip flop render targets for post processing
        for (let i = 0; i < this._postprocessors.length; i++) {
            currentTarget = this._postProcessTargets[i % 2];
            this._postProcessTargets[i % 2].use();
            this._screenRenderer.renderWithPostProcessor(this._postprocessors[i]);
            this._postProcessTargets[i % 2].toRenderSource().use();
        }
        // Final blit to the screen
        currentTarget.blitToScreen();
    }
}


/***/ }),

/***/ "./Graphics/Context/circle-renderer/circle-renderer.frag.glsl":
/*!********************************************************************!*\
  !*** ./Graphics/Context/circle-renderer/circle-renderer.frag.glsl ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nprecision highp float;\n\n// UV coord\nin vec2 v_uv;\n\n// Color coord to blend with image\nin lowp vec4 v_color;\n\n// Stroke color if used\nin lowp vec4 v_strokeColor;\n\n// Stroke thickness if used\nin lowp float v_strokeThickness;\n\n// Opacity\nin float v_opacity;\n\nout vec4 fragColor;\n\nvoid main() {\n  // make (0, 0) the center the uv \n  vec2 uv = v_uv * 2.0 - 1.0;\n\n  vec4 color = v_color;\n  vec4 strokeColor = v_strokeColor;\n\n  // circle border is at radius 1.0 \n  // dist is > 0 when inside the circle \n  float d = length(uv);\n  float dist = 1.0 - length(uv);\n\n  // Fade based on fwidth\n  float fade = fwidth(dot(uv, uv));\n\n  // if dist is greater than 0 step to 1;\n  // when we cross this 0 threshold add a smooth fade\n  float fill = smoothstep(-fade/2.0, fade/2.0, dist);\n\n  // if dist is greater than the stroke thickness step to 1\n  float stroke = 1.0 - smoothstep(v_strokeThickness, v_strokeThickness + fade, dist);\n\n  strokeColor.a *= fill * stroke;\n  strokeColor.rgb *= strokeColor.a;\n\n  color.a *= fill * (1.0 - stroke);\n  color.rgb *= color.a;\n\n  vec4 finalColor = mix(vec4(0.0), (color + strokeColor), fill);\n  finalColor.rgb = finalColor.rgb * v_opacity;\n  finalColor.a = finalColor.a * v_opacity;\n  fragColor = finalColor;\n}");

/***/ }),

/***/ "./Graphics/Context/circle-renderer/circle-renderer.ts":
/*!*************************************************************!*\
  !*** ./Graphics/Context/circle-renderer/circle-renderer.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CircleRenderer: () => (/* binding */ CircleRenderer)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../Color */ "./Color.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../GraphicsDiagnostics */ "./Graphics/GraphicsDiagnostics.ts");
/* harmony import */ var _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ExcaliburGraphicsContextWebGL */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");
/* harmony import */ var _quad_index_buffer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../quad-index-buffer */ "./Graphics/Context/quad-index-buffer.ts");
/* harmony import */ var _shader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../shader */ "./Graphics/Context/shader.ts");
/* harmony import */ var _vertex_buffer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../vertex-buffer */ "./Graphics/Context/vertex-buffer.ts");
/* harmony import */ var _vertex_layout__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vertex-layout */ "./Graphics/Context/vertex-layout.ts");
/* harmony import */ var _circle_renderer_frag_glsl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./circle-renderer.frag.glsl */ "./Graphics/Context/circle-renderer/circle-renderer.frag.glsl");
/* harmony import */ var _circle_renderer_vert_glsl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./circle-renderer.vert.glsl */ "./Graphics/Context/circle-renderer/circle-renderer.vert.glsl");










class CircleRenderer {
    constructor() {
        this.type = 'ex.circle';
        this.priority = 0;
        this._maxCircles = 10922; // max(uint16) / 6 verts
        this._circleCount = 0;
        this._vertexIndex = 0;
    }
    initialize(gl, context) {
        this._gl = gl;
        this._context = context;
        this._shader = new _shader__WEBPACK_IMPORTED_MODULE_0__.Shader({
            graphicsContext: context,
            fragmentSource: _circle_renderer_frag_glsl__WEBPACK_IMPORTED_MODULE_1__["default"],
            vertexSource: _circle_renderer_vert_glsl__WEBPACK_IMPORTED_MODULE_2__["default"]
        });
        this._shader.compile();
        // setup uniforms
        this._shader.use();
        this._shader.setUniformMatrix('u_matrix', context.ortho);
        this._buffer = new _vertex_buffer__WEBPACK_IMPORTED_MODULE_3__.VertexBuffer({
            gl,
            size: 14 * 4 * this._maxCircles,
            type: 'dynamic'
        });
        this._layout = new _vertex_layout__WEBPACK_IMPORTED_MODULE_4__.VertexLayout({
            gl,
            shader: this._shader,
            vertexBuffer: this._buffer,
            attributes: [
                ['a_position', 2],
                ['a_uv', 2],
                ['a_opacity', 1],
                ['a_color', 4],
                ['a_strokeColor', 4],
                ['a_strokeThickness', 1]
            ]
        });
        this._quads = new _quad_index_buffer__WEBPACK_IMPORTED_MODULE_5__.QuadIndexBuffer(gl, this._maxCircles, true);
    }
    dispose() {
        this._buffer.dispose();
        this._quads.dispose();
        this._shader.dispose();
        this._context = null;
        this._gl = null;
    }
    _isFull() {
        if (this._circleCount >= this._maxCircles) {
            return true;
        }
        return false;
    }
    draw(pos, radius, color, stroke = _Color__WEBPACK_IMPORTED_MODULE_6__.Color.Transparent, strokeThickness = 0) {
        if (this._isFull()) {
            this.flush();
        }
        this._circleCount++;
        // transform based on current context
        const transform = this._context.getTransform();
        const opacity = this._context.opacity;
        const snapToPixel = this._context.snapToPixel;
        const topLeft = transform.multiply(pos.add((0,_Math_vector__WEBPACK_IMPORTED_MODULE_7__.vec)(-radius, -radius)));
        const topRight = transform.multiply(pos.add((0,_Math_vector__WEBPACK_IMPORTED_MODULE_7__.vec)(radius, -radius)));
        const bottomRight = transform.multiply(pos.add((0,_Math_vector__WEBPACK_IMPORTED_MODULE_7__.vec)(radius, radius)));
        const bottomLeft = transform.multiply(pos.add((0,_Math_vector__WEBPACK_IMPORTED_MODULE_7__.vec)(-radius, radius)));
        if (snapToPixel) {
            topLeft.x = ~~(topLeft.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            topLeft.y = ~~(topLeft.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            topRight.x = ~~(topRight.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            topRight.y = ~~(topRight.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            bottomLeft.x = ~~(bottomLeft.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            bottomLeft.y = ~~(bottomLeft.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            bottomRight.x = ~~(bottomRight.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            bottomRight.y = ~~(bottomRight.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
        }
        // TODO UV could be static vertex buffer
        const uvx0 = 0;
        const uvy0 = 0;
        const uvx1 = 1;
        const uvy1 = 1;
        // update data
        const vertexBuffer = this._layout.vertexBuffer.bufferData;
        // (0, 0) - 0
        vertexBuffer[this._vertexIndex++] = topLeft.x;
        vertexBuffer[this._vertexIndex++] = topLeft.y;
        vertexBuffer[this._vertexIndex++] = uvx0;
        vertexBuffer[this._vertexIndex++] = uvy0;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness / radius;
        // (0, 1) - 1
        vertexBuffer[this._vertexIndex++] = bottomLeft.x;
        vertexBuffer[this._vertexIndex++] = bottomLeft.y;
        vertexBuffer[this._vertexIndex++] = uvx0;
        vertexBuffer[this._vertexIndex++] = uvy1;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness / radius;
        // (1, 0) - 2
        vertexBuffer[this._vertexIndex++] = topRight.x;
        vertexBuffer[this._vertexIndex++] = topRight.y;
        vertexBuffer[this._vertexIndex++] = uvx1;
        vertexBuffer[this._vertexIndex++] = uvy0;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness / radius;
        // (1, 1) - 3
        vertexBuffer[this._vertexIndex++] = bottomRight.x;
        vertexBuffer[this._vertexIndex++] = bottomRight.y;
        vertexBuffer[this._vertexIndex++] = uvx1;
        vertexBuffer[this._vertexIndex++] = uvy1;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness / radius;
    }
    hasPendingDraws() {
        return this._circleCount !== 0;
    }
    flush() {
        // nothing to draw early exit
        if (this._circleCount === 0) {
            return;
        }
        const gl = this._gl;
        // Bind the shader
        this._shader.use();
        // Bind the memory layout and upload data
        this._layout.use(true);
        // Update ortho matrix uniform
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
        // Bind index buffer
        this._quads.bind();
        // Draw all the quads
        gl.drawElements(gl.TRIANGLES, this._circleCount * 6, this._quads.bufferGlType, 0);
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_9__.GraphicsDiagnostics.DrawnImagesCount += this._circleCount;
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_9__.GraphicsDiagnostics.DrawCallCount++;
        // Reset
        this._circleCount = 0;
        this._vertexIndex = 0;
    }
}


/***/ }),

/***/ "./Graphics/Context/circle-renderer/circle-renderer.vert.glsl":
/*!********************************************************************!*\
  !*** ./Graphics/Context/circle-renderer/circle-renderer.vert.glsl ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nin vec2 a_position;\n\n// UV coordinate\nin vec2 a_uv;\nout vec2 v_uv;\n\n// Opacity \nin float a_opacity;\nout float v_opacity;\n\nin vec4 a_color;\nout vec4 v_color;\n\nin vec4 a_strokeColor;\nout vec4 v_strokeColor;\n\nin float a_strokeThickness;\nout float v_strokeThickness;\n\nuniform mat4 u_matrix;\n\n\nvoid main() {\n   // Set the vertex position using the ortho transform matrix\n   gl_Position = u_matrix * vec4(a_position, 0.0, 1.0);\n\n   // Pass through UV coords\n   v_uv = a_uv;\n   // Pass through the Opacity to the fragment shader\n   v_opacity = a_opacity;\n   // Pass through the color to the fragment shader\n   v_color = a_color;\n   // Pass through the stroke color to the fragment shader\n   v_strokeColor = a_strokeColor;\n   // Pass through the stroke thickenss to the fragment shader\n   v_strokeThickness = a_strokeThickness;\n}");

/***/ }),

/***/ "./Graphics/Context/debug-font.png":
/*!*****************************************!*\
  !*** ./Graphics/Context/debug-font.png ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAQAAAABACAYAAAD1Xam+AAAAAXNSR0IArs4c6QAABlFJREFUeJztndmy4yoMRcWt/v9fdr8EWoDAaDD4JntVpeqcxBrMIGQDNhEAAAAAAAAAAAAAAOCrSbMfr+u6yoEpTY+906GV57YtPkjyXj9WZZ+wHWHfo2N3/bU6Tte9Rv6ptruqRyMvKvvIX/zY3I/vjLeqsg6l/CWdp0KHKO/1Y1H2EdsR9j06Ntdfp+N03SvkH2u7i3pu5XkQ+DNTkgNJSok+/183xpcdWZHjgUzpQ2pGD67vaf//KRAGAq3tdhCy2tcMQKPyXyz7iPqrdBjbX5h9g7xbtvWf4ZJvM4D/BKG24Sd+IkQ0TC9aW5NM5FbO2HgrPVzW2vmN50DZNv/QWtl5bfPy85SBtdy9dFmjsf2F2SehTBVE+u+tkE5+lAGcJlFwGuodwRRU2Qe3rx0FhPNflc3HWC7BEh8EDGVR5IMCiLnDONtPp87qhxVH/S/LvzUAuDs/kyGimA5oSONKR1w8vsLpv+v+S9vhmS71JRiX1xB5CWZNw7m6rMrllMag/RJyWb67BEgpDVMWSydc+K47pr35w05kWd7ReEq6116KaG4CsbJ7OmV9PdZLEKkONiC1/7ZONVgDsajLIJPYp2OUAXRpnPcGmnIE6eSK4nv5YQqqSYO52JqnYfYj/PdQXQIY7XszuMofMgZRT/1LdeC5h2I5/0EdWDMY2Yb05WDE1RodVdpSA5r85slArAVnSf+89iP896St0f5bZKVA7Gk/3ja8q+152/+wrLqBWZTem3IBADbRBoDuHgAA4HdAAADgh0EAAOCHQQAA4IdBAADgh0EAAOCHuVsKbJ3P9M7jjuxHzGfv8j9iDt47Dx7hP8cjq5F/o/0T62Aer//ZOgDrajBp6aNlOWTEajKLjgj/Pcs/vfZD/a++3Pc8hNfZ966EVeh5vP75luDRJUAl0KzJfnopaqbaTuzZiulc2BS5lltFXntu3dcQsXadl59Wn1H+dfYNtrt2d6D/LDF9HkCQw6eXFbr8P9X5W/un5Ol8gz1t39p5pWOPn0vLynbgdnfe8maEQw+UIPJdfxdOd/4oTtVD0IYg8wDywGas0I04T5O3P8/qf2UWwPpkn1PbOT1bN2tFe59EM7TvKf+TRFw+erZ2ey4hpS3hp9qBkqq/tjsSU1OYqucBWB1yynt5QxC42Mdk30pAEIio//zRG3feBzLUX+TTjCKwlH83aI/KbpQBVEHgUGF0j/SitcLofHem8q6AyH0wBhFv4WszuOjy0yK2vc/oRWQoP2X9ve78jfaLnpncbBqQSC6s0HnIRT0a2yNZjfxT8+ir8t+yDsDTWaS6X70GP33+d77stp+I5HtBdwEAAPBl8ECApcAA/DBvfSowAGAB7/05ZAAA/DAIAADMMU3fOuS2ggAAwBjrorKoxWiPBxHMAgAg490Ts0VeePdA+ZfJDKcCh7sBqY88mmjklZeOt9iXPrvx2I2QPRnN2/qzyJ84h4gNcbtfasq5mM1rZr+bBWh2A+bIIX13Z9wqL+nQvFno7v3oq4tJItCed7isUT6C/I7BUn9KP95wDicYBYpcjncrO2c/dmW4tBtw4RiRld1IDxDyYsoXMHxF1w3dyz0Nne8033AOFsT6VgRCafl89fenTZUfbm8CGhrgdDcS7anAsvnkkP0IeCfQ+JzYunky6jhNYj5bl7++4fJvN9WDSKS/292A0wyANyKDI91bfkm3kcH7ckaP/SKW/VHKRZAcI14pP3beu0fPyn/DuZQbWMogNnsc16sziE96f7H/iai7uTf0/3N8lwFz/e13T00Djt4OrInCnkeChXT+qOcKOLA21tJpsv/G8/COnGnw97J9QwbTvd6djYSv7fxEVTuV/LzNhj7nOawv6bfbAGCYEpQ6HxFtuxs6sq9tzOYHobQ6Nje+6vo5BwFrPZ4OgMayS4PPt1NlzdLfbRCYBoBc+NaO4JWPwLEf33oN3unY3InKPQBW6Z7nEZzEmrl4iZjC804lqgePPEOguQcwWghUphxm343wyt/pWpWR0OrR+jvyxavHajfb9pTjbt9bH07Z5/expM4TLWfwb7QQqMoC+UDWXZo/4RgA38LOgUvLJAAQ1Td9y9//0ylxAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB+g79apuVUsS5ZmwAAAABJRU5ErkJggg==");

/***/ }),

/***/ "./Graphics/Context/debug-text.ts":
/*!****************************************!*\
  !*** ./Graphics/Context/debug-text.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DebugText: () => (/* binding */ DebugText)
/* harmony export */ });
/* harmony import */ var _ImageSource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ImageSource */ "./Graphics/ImageSource.ts");
/* harmony import */ var _SpriteFont__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../SpriteFont */ "./Graphics/SpriteFont.ts");
/* harmony import */ var _SpriteSheet__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../SpriteSheet */ "./Graphics/SpriteSheet.ts");
/* harmony import */ var _debug_font_png__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./debug-font.png */ "./Graphics/Context/debug-font.png");




/**
 * Internal debug text helper
 */
class DebugText {
    constructor() {
        /**
         * base64 font
         */
        this.fontSheet = _debug_font_png__WEBPACK_IMPORTED_MODULE_0__["default"];
        this.size = 16;
        // We fire and forget, we don't care if it's loaded or not
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.load();
    }
    load() {
        this._imageSource = new _ImageSource__WEBPACK_IMPORTED_MODULE_1__.ImageSource(this.fontSheet);
        return this._imageSource.load().then(() => {
            this._spriteSheet = _SpriteSheet__WEBPACK_IMPORTED_MODULE_2__.SpriteSheet.fromImageSource({
                image: this._imageSource,
                grid: {
                    rows: 4,
                    columns: 16,
                    spriteWidth: 16,
                    spriteHeight: 16
                }
            });
            this._spriteFont = new _SpriteFont__WEBPACK_IMPORTED_MODULE_3__.SpriteFont({
                alphabet: '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ,!\'&."?-()+# ',
                caseInsensitive: true,
                spriteSheet: this._spriteSheet,
                spacing: -6
            });
        });
    }
    /**
     * Writes debug text using the built in sprint font
     * @param ctx
     * @param text
     * @param pos
     */
    write(ctx, text, pos) {
        if (this._imageSource.isLoaded()) {
            this._spriteFont.render(ctx, text, null, pos.x, pos.y);
        }
    }
}


/***/ }),

/***/ "./Graphics/Context/draw-call.ts":
/*!***************************************!*\
  !*** ./Graphics/Context/draw-call.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DrawCall: () => (/* binding */ DrawCall)
/* harmony export */ });
/* harmony import */ var _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Math/affine-matrix */ "./Math/affine-matrix.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Color */ "./Color.ts");


class DrawCall {
    constructor() {
        this.z = 0;
        this.priority = 0;
        this.renderer = '';
        this.transform = _Math_affine_matrix__WEBPACK_IMPORTED_MODULE_0__.AffineMatrix.identity();
        this.state = {
            z: 0,
            opacity: 1,
            tint: _Color__WEBPACK_IMPORTED_MODULE_1__.Color.White,
            material: null
        };
        this.args = new Array(10);
    }
}


/***/ }),

/***/ "./Graphics/Context/image-renderer-v2/image-renderer-v2.frag.glsl":
/*!************************************************************************!*\
  !*** ./Graphics/Context/image-renderer-v2/image-renderer-v2.frag.glsl ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nprecision mediump float;\n\n// UV coord\nin vec2 v_texcoord;\n\n// Textures in the current draw\nuniform sampler2D u_textures[%%count%%];\n\nuniform bool u_pixelart;\n\nin float v_texture_index;\n\nin float v_opacity;\n\nin vec4 v_tint;\n\n// texture resolution\nin vec2 v_res;\n\nin vec2 v_size;\n\nin vec2 v_uv_min;\nin vec2 v_uv_max;\n\nout vec4 fragColor;\n\n// Inigo Quilez pixel art filter https://jorenjoestar.github.io/post/pixel_art_filtering/\nvec2 uv_iq(in vec2 uv, in vec2 texture_size) {\n  vec2 pixel = uv * texture_size;\n\n  vec2 seam=floor(pixel+.5);\n  vec2 dudv=fwidth(pixel);\n  pixel=seam+clamp((pixel-seam)/dudv,-.5,.5);\n\n  return pixel/texture_size;\n}\n\nfloat lerp(float from, float to, float rel){\n  return ((1. - rel) * from) + (rel * to);\n}\n\nfloat invLerp(float from, float to, float value){\n  return (value - from) / (to - from);\n}\n\nfloat remap(float origFrom, float origTo, float targetFrom, float targetTo, float value){\n  float rel = invLerp(origFrom, origTo, value);\n  return lerp(targetFrom, targetTo, rel);\n}\n\nvoid main(){\n  // In order to support the most efficient sprite batching, we have multiple\n  // textures loaded into the gpu (usually 8) this picker logic skips over textures\n  // that do not apply to a particular sprite.\n\n  vec4 color=vec4(1.,0,0,1.);\n  vec2 remapped_uv = v_texcoord;\n  remapped_uv.x = remap(0.,1., v_uv_min.x, v_uv_max.x, v_texcoord.x);\n  remapped_uv.y = remap(0.,1., v_uv_min.y, v_uv_max.y, v_texcoord.y);\n  vec2 uv = u_pixelart ? uv_iq(remapped_uv, v_size) : remapped_uv;\n\n  // GLSL is templated out to pick the right texture and set the vec4 color\n  %%texture_picker%%\n\n  color.rgb = color.rgb * v_opacity;\n  color.a = color.a * v_opacity;\n  fragColor = color * v_tint;\n}");

/***/ }),

/***/ "./Graphics/Context/image-renderer-v2/image-renderer-v2.ts":
/*!*****************************************************************!*\
  !*** ./Graphics/Context/image-renderer-v2/image-renderer-v2.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ImageRendererV2: () => (/* binding */ ImageRendererV2)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../Color */ "./Color.ts");
/* harmony import */ var _Filtering__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../Filtering */ "./Graphics/Filtering.ts");
/* harmony import */ var _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../GraphicsDiagnostics */ "./Graphics/GraphicsDiagnostics.ts");
/* harmony import */ var _ImageSource__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../ImageSource */ "./Graphics/ImageSource.ts");
/* harmony import */ var _Wrapping__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../Wrapping */ "./Graphics/Wrapping.ts");
/* harmony import */ var _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../ExcaliburGraphicsContextWebGL */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");
/* harmony import */ var _shader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../shader */ "./Graphics/Context/shader.ts");
/* harmony import */ var _vertex_buffer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../vertex-buffer */ "./Graphics/Context/vertex-buffer.ts");
/* harmony import */ var _webgl_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../webgl-util */ "./Graphics/Context/webgl-util.ts");
/* harmony import */ var _image_renderer_v2_frag_glsl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./image-renderer-v2.frag.glsl */ "./Graphics/Context/image-renderer-v2/image-renderer-v2.frag.glsl");
/* harmony import */ var _image_renderer_v2_vert_glsl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./image-renderer-v2.vert.glsl */ "./Graphics/Context/image-renderer-v2/image-renderer-v2.vert.glsl");
// import { Color } from '../../../Color';
// import { parseImageFiltering } from '../../Filtering';











class ImageRendererV2 {
    constructor(options) {
        this.type = 'ex.image-v2';
        this.priority = 0;
        // TODO this could be bigger probably
        this._maxImages = 20000; // max(uint16) / 6 verts
        this._maxTextures = 0;
        this._components = 2 + 2 + 2 + 2 + 1 + 2 + 2 + 1 + 2 + 2 + 4;
        // Per flush vars
        this._imageCount = 0;
        this._textures = [];
        this._textureIndex = 0;
        this._textureToIndex = new Map();
        this._images = new Set();
        this._vertexIndex = 0;
        this._imageToWidth = new Map();
        this._imageToHeight = new Map();
        this._view = [0, 0, 0, 0];
        this._dest = [0, 0];
        this._defaultTint = _Color__WEBPACK_IMPORTED_MODULE_0__.Color.White;
        this.pixelArtSampler = options.pixelArtSampler;
        this.uvPadding = options.uvPadding;
    }
    initialize(gl, context) {
        this._gl = gl;
        this._context = context;
        // Transform shader source
        const maxTexture = gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS);
        const maxComplexity = (0,_webgl_util__WEBPACK_IMPORTED_MODULE_1__.getMaxShaderComplexity)(gl, maxTexture);
        this._maxTextures = Math.min(maxTexture, maxComplexity);
        const transformedFrag = this._transformFragmentSource(_image_renderer_v2_frag_glsl__WEBPACK_IMPORTED_MODULE_2__["default"], this._maxTextures);
        // Compile shader
        this._shader = new _shader__WEBPACK_IMPORTED_MODULE_3__.Shader({
            graphicsContext: context,
            fragmentSource: transformedFrag,
            vertexSource: _image_renderer_v2_vert_glsl__WEBPACK_IMPORTED_MODULE_4__["default"]
        });
        this._shader.compile();
        // setup uniforms
        this._shader.use();
        this._shader.setUniformMatrix('u_matrix', context.ortho);
        // Initialize texture slots to [0, 1, 2, 3, 4, .... maxGPUTextures]
        this._shader.setUniformIntArray('u_textures', [...Array(this._maxTextures)].map((_, i) => i));
        this._vao = gl.createVertexArray();
        gl.bindVertexArray(this._vao);
        this._quadMesh = new Float32Array([
            // pos       uv
            0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0,
            1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1
        ]);
        this._meshBuffer = gl.createBuffer();
        gl.bindBuffer(gl.ARRAY_BUFFER, this._meshBuffer);
        gl.bufferData(gl.ARRAY_BUFFER, this._quadMesh, gl.STATIC_DRAW);
        gl.vertexAttribPointer(0, 2, gl.FLOAT, false, 16, 0);
        gl.enableVertexAttribArray(0);
        gl.vertexAttribPointer(1, 2, gl.FLOAT, false, 16, 8);
        gl.enableVertexAttribArray(1);
        gl.bindBuffer(gl.ARRAY_BUFFER, null);
        // Setup memory layout
        const components = this._components;
        this._transformData = new _vertex_buffer__WEBPACK_IMPORTED_MODULE_5__.VertexBuffer({
            gl,
            size: components * this._maxImages, // components * images
            type: 'dynamic'
        });
        this._transformData.bind();
        // attributes
        let offset = 0;
        let start = 2;
        const bytesPerFloat = 4;
        const totalSize = components * 4;
        // a_offset vec2 - 2
        gl.vertexAttribPointer(start++, 2, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(2);
        offset += 2 * bytesPerFloat;
        // a_mat_column1 vec2 - 2
        gl.vertexAttribPointer(start++, 2, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(3);
        offset += 2 * bytesPerFloat;
        // a_mat_column2 vec2 - 2
        gl.vertexAttribPointer(start++, 2, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(4);
        offset += 2 * bytesPerFloat;
        // a_mat_column3 vec2 - 2
        gl.vertexAttribPointer(start++, 2, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(5);
        offset += 2 * bytesPerFloat;
        // a_opacity float - 1
        gl.vertexAttribPointer(start++, 1, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(6);
        offset += 1 * bytesPerFloat;
        // a_res vec2 - 2
        gl.vertexAttribPointer(start++, 2, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(7);
        offset += 2 * bytesPerFloat;
        // a_size vec2 - 2
        gl.vertexAttribPointer(start++, 2, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(8);
        offset += 2 * bytesPerFloat;
        // a_texture_index - 1
        gl.vertexAttribPointer(start++, 1, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(9);
        offset += 1 * bytesPerFloat;
        // a_uv_min - 2
        gl.vertexAttribPointer(start++, 2, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(10);
        offset += 2 * bytesPerFloat;
        // a_uv_max - 2
        gl.vertexAttribPointer(start++, 2, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(11);
        offset += 2 * bytesPerFloat;
        // a_tint - 4
        gl.vertexAttribPointer(start++, 4, gl.FLOAT, false, totalSize, offset);
        gl.enableVertexAttribArray(12);
        offset += 4 * bytesPerFloat;
        gl.vertexAttribDivisor(2, 1);
        gl.vertexAttribDivisor(3, 1);
        gl.vertexAttribDivisor(4, 1);
        gl.vertexAttribDivisor(5, 1);
        gl.vertexAttribDivisor(6, 1);
        gl.vertexAttribDivisor(7, 1);
        gl.vertexAttribDivisor(8, 1);
        gl.vertexAttribDivisor(9, 1);
        gl.vertexAttribDivisor(10, 1);
        gl.vertexAttribDivisor(11, 1);
        gl.vertexAttribDivisor(12, 1);
        gl.bindVertexArray(null);
    }
    _bindData(gl) {
        // Setup memory layout
        const components = this._components;
        this._transformData.bind();
        this._transformData.upload(components * this._imageCount);
        gl.bindVertexArray(this._vao);
    }
    dispose() {
        this._transformData.dispose();
        this._shader.dispose();
        this._textures.length = 0;
        this._context = null;
        this._gl = null;
    }
    _transformFragmentSource(source, maxTextures) {
        let newSource = source.replace('%%count%%', maxTextures.toString());
        let texturePickerBuilder = '';
        for (let i = 0; i < maxTextures; i++) {
            if (i === 0) {
                texturePickerBuilder += `if (v_texture_index <= ${i}.5) {\n`;
            }
            else {
                texturePickerBuilder += `   else if (v_texture_index <= ${i}.5) {\n`;
            }
            texturePickerBuilder += `      color = texture(u_textures[${i}], uv);\n`;
            texturePickerBuilder += `   }\n`;
        }
        newSource = newSource.replace('%%texture_picker%%', texturePickerBuilder);
        return newSource;
    }
    _addImageAsTexture(image) {
        if (this._images.has(image)) {
            return;
        }
        const maybeFiltering = image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_6__.ImageSourceAttributeConstants.Filtering);
        const filtering = maybeFiltering ? (0,_Filtering__WEBPACK_IMPORTED_MODULE_7__.parseImageFiltering)(maybeFiltering) : undefined;
        const wrapX = (0,_Wrapping__WEBPACK_IMPORTED_MODULE_8__.parseImageWrapping)(image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_6__.ImageSourceAttributeConstants.WrappingX));
        const wrapY = (0,_Wrapping__WEBPACK_IMPORTED_MODULE_8__.parseImageWrapping)(image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_6__.ImageSourceAttributeConstants.WrappingY));
        const force = image.getAttribute('forceUpload') === 'true' ? true : false;
        const texture = this._context.textureLoader.load(image, {
            filtering,
            wrapping: { x: wrapX, y: wrapY }
        }, force);
        // remove force attribute after upload
        image.removeAttribute('forceUpload');
        if (this._textures.indexOf(texture) === -1) {
            this._textures.push(texture);
            this._textureToIndex.set(texture, this._textureIndex++);
            this._images.add(image);
        }
    }
    _bindTextures(gl) {
        // Bind textures in the correct order
        const max = Math.min(this._textureIndex, this._maxTextures);
        for (let i = 0; i < max; i++) {
            gl.activeTexture(gl.TEXTURE0 + i);
            gl.bindTexture(gl.TEXTURE_2D, this._textures[i] || this._textures[0]);
        }
    }
    _getTextureIdForImage(image) {
        var _a;
        if (image) {
            const maybeTexture = this._context.textureLoader.get(image);
            return (_a = this._textureToIndex.get(maybeTexture)) !== null && _a !== void 0 ? _a : -1; //this._textures.indexOf(maybeTexture);
        }
        return -1;
    }
    _isFull() {
        if (this._imageCount >= this._maxImages) {
            return true;
        }
        if (this._textures.length >= this._maxTextures) {
            return true;
        }
        return false;
    }
    _getImageWidth(image) {
        let maybeWidth = this._imageToWidth.get(image);
        if (maybeWidth === undefined) {
            maybeWidth = image.width;
            this._imageToWidth.set(image, maybeWidth);
        }
        return maybeWidth;
    }
    _getImageHeight(image) {
        let maybeHeight = this._imageToHeight.get(image);
        if (maybeHeight === undefined) {
            maybeHeight = image.height;
            this._imageToHeight.set(image, maybeHeight);
        }
        return maybeHeight;
    }
    draw(image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight) {
        var _a, _b, _c, _d;
        // Force a render if the batch is full
        if (this._isFull()) {
            this.flush();
        }
        this._imageCount++;
        // This creates and uploads the texture if not already done
        this._addImageAsTexture(image);
        const maybeImageWidth = this._getImageWidth(image);
        const maybeImageHeight = this._getImageHeight(image);
        let width = maybeImageWidth || swidth || 0;
        let height = maybeImageHeight || sheight || 0;
        this._view[0] = 0;
        this._view[1] = 0;
        this._view[2] = (_a = swidth !== null && swidth !== void 0 ? swidth : maybeImageWidth) !== null && _a !== void 0 ? _a : 0;
        this._view[3] = (_b = sheight !== null && sheight !== void 0 ? sheight : maybeImageHeight) !== null && _b !== void 0 ? _b : 0;
        this._dest[0] = sx !== null && sx !== void 0 ? sx : 1;
        this._dest[1] = sy !== null && sy !== void 0 ? sy : 1;
        // If destination is specified, update view and dest
        if (dx !== undefined && dy !== undefined && dwidth !== undefined && dheight !== undefined) {
            this._view[0] = sx !== null && sx !== void 0 ? sx : 1;
            this._view[1] = sy !== null && sy !== void 0 ? sy : 1;
            this._view[2] = (_c = swidth !== null && swidth !== void 0 ? swidth : maybeImageWidth) !== null && _c !== void 0 ? _c : 0;
            this._view[3] = (_d = sheight !== null && sheight !== void 0 ? sheight : maybeImageHeight) !== null && _d !== void 0 ? _d : 0;
            this._dest[0] = dx;
            this._dest[1] = dy;
            width = dwidth;
            height = dheight;
        }
        sx = this._view[0];
        sy = this._view[1];
        const sw = this._view[2];
        const sh = this._view[3];
        // transform based on current context
        const transform = this._context.getTransform();
        const opacity = this._context.opacity;
        const snapToPixel = this._context.snapToPixel;
        if (snapToPixel) {
            this._dest[0] = ~~(this._dest[0] + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_9__.pixelSnapEpsilon);
            this._dest[1] = ~~(this._dest[1] + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_9__.pixelSnapEpsilon);
        }
        const tint = this._context.tint || this._defaultTint;
        const textureId = this._getTextureIdForImage(image);
        const imageWidth = maybeImageWidth || width;
        const imageHeight = maybeImageHeight || height;
        const uvx0 = (sx + this.uvPadding) / imageWidth;
        const uvy0 = (sy + this.uvPadding) / imageHeight;
        const uvx1 = (sx + sw - this.uvPadding) / imageWidth;
        const uvy1 = (sy + sh - this.uvPadding) / imageHeight;
        const txWidth = maybeImageWidth;
        const txHeight = maybeImageHeight;
        // update data
        const vertexBuffer = this._transformData.bufferData;
        vertexBuffer[this._vertexIndex++] = this._dest[0];
        vertexBuffer[this._vertexIndex++] = this._dest[1];
        vertexBuffer[this._vertexIndex++] = transform.data[0];
        vertexBuffer[this._vertexIndex++] = transform.data[1];
        vertexBuffer[this._vertexIndex++] = transform.data[2];
        vertexBuffer[this._vertexIndex++] = transform.data[3];
        vertexBuffer[this._vertexIndex++] = transform.data[4];
        vertexBuffer[this._vertexIndex++] = transform.data[5];
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = width;
        vertexBuffer[this._vertexIndex++] = height;
        vertexBuffer[this._vertexIndex++] = txWidth;
        vertexBuffer[this._vertexIndex++] = txHeight;
        vertexBuffer[this._vertexIndex++] = textureId;
        vertexBuffer[this._vertexIndex++] = uvx0;
        vertexBuffer[this._vertexIndex++] = uvy0;
        vertexBuffer[this._vertexIndex++] = uvx1;
        vertexBuffer[this._vertexIndex++] = uvy1;
        vertexBuffer[this._vertexIndex++] = tint.r / 255;
        vertexBuffer[this._vertexIndex++] = tint.g / 255;
        vertexBuffer[this._vertexIndex++] = tint.b / 255;
        vertexBuffer[this._vertexIndex++] = tint.a;
    }
    hasPendingDraws() {
        return this._imageCount !== 0;
    }
    flush() {
        // nothing to draw early exit
        if (this._imageCount === 0) {
            return;
        }
        const gl = this._gl;
        // Bind the shader
        this._shader.use();
        // Bind the memory layout and upload data
        this._bindData(gl);
        // Update ortho matrix uniform
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
        // Turn on pixel art aa sampler
        this._shader.setUniformBoolean('u_pixelart', this.pixelArtSampler);
        // Bind textures to
        this._bindTextures(gl);
        // Draw all the quads
        gl.drawArraysInstanced(gl.TRIANGLES, 0, 6, this._imageCount);
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_10__.GraphicsDiagnostics.DrawnImagesCount += this._imageCount;
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_10__.GraphicsDiagnostics.DrawCallCount++;
        gl.bindVertexArray(null);
        // Reset
        this._imageCount = 0;
        this._vertexIndex = 0;
        this._textures.length = 0;
        this._textureIndex = 0;
        this._textureToIndex.clear();
        this._images.clear();
        this._imageToWidth.clear();
        this._imageToHeight.clear();
    }
}


/***/ }),

/***/ "./Graphics/Context/image-renderer-v2/image-renderer-v2.vert.glsl":
/*!************************************************************************!*\
  !*** ./Graphics/Context/image-renderer-v2/image-renderer-v2.vert.glsl ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nlayout(location=0) in vec2 pos;\nlayout(location=1) in vec2 a_texcoord;\nout vec2 v_texcoord;\n\nlayout(location=2) in vec2 a_offset;\nlayout(location=3) in vec2 a_mat_column1;\nlayout(location=4) in vec2 a_mat_column2;\nlayout(location=5) in vec2 a_mat_column3;\n\nlayout(location=6) in float a_opacity;\nout float v_opacity;\n\n// Texture resolution (could be bigger than a_size)\nlayout(location=7) in vec2 a_res;\nout vec2 v_res;\n\n// Final size of graphic\nlayout(location=8) in vec2 a_size;\nout vec2 v_size;\n\nlayout(location=9) in lowp float a_texture_index;\nout lowp float v_texture_index;\n\nlayout(location=10) in vec2 a_uv_min;\nout vec2 v_uv_min;\n\nlayout(location=11) in vec2 a_uv_max;\nout vec2 v_uv_max;\n\nlayout(location=12) in vec4 a_tint;\nout vec4 v_tint;\n\nuniform mat4 u_matrix;\n\nvoid main(){\n  mat4 world_mat = mat4(\n    a_mat_column1.x, a_mat_column1.y, 0., 0.,\n    a_mat_column2.x, a_mat_column2.y, 0., 0.,\n    0.             , 0.             , 1., 0.,\n    a_mat_column3.x, a_mat_column3.y, 0., 1.\n  );\n\n  vec2 newPos = vec2(pos.x * a_res.x, pos.y * a_res.y);\n  gl_Position = u_matrix * world_mat * vec4(newPos + a_offset, 0., 1.);\n\n  v_opacity = a_opacity;\n  v_texcoord = a_texcoord;\n  v_uv_min = a_uv_min;\n  v_uv_max = a_uv_max;\n  v_res = a_res;\n  v_size = a_size;\n  v_texture_index = a_texture_index;\n  v_tint = a_tint;\n}");

/***/ }),

/***/ "./Graphics/Context/image-renderer/image-renderer.frag.glsl":
/*!******************************************************************!*\
  !*** ./Graphics/Context/image-renderer/image-renderer.frag.glsl ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nprecision mediump float;\n\n// UV coord\nin vec2 v_texcoord;\n\n// Texture index\nin lowp float v_textureIndex;\n\n// Textures in the current draw\nuniform sampler2D u_textures[%%count%%];\n\nuniform bool u_pixelart;\n\n// Opacity\nin float v_opacity;\n\nin vec4 v_tint;\n\nin vec2 v_res;\n\nout vec4 fragColor;\n\n// Inigo Quilez pixel art filter https://jorenjoestar.github.io/post/pixel_art_filtering/\nvec2 uv_iq(in vec2 uv, in vec2 texture_size) {\n  vec2 pixel = uv * texture_size;\n  \n  vec2 seam=floor(pixel+.5);\n  vec2 dudv=fwidth(pixel);\n  pixel=seam+clamp((pixel-seam)/dudv,-.5,.5);\n  \n  return pixel/texture_size;\n}\n\nvoid main(){\n  // In order to support the most efficient sprite batching, we have multiple\n  // textures loaded into the gpu (usually 8) this picker logic skips over textures\n  // that do not apply to a particular sprite.\n  \n  vec4 color=vec4(1.,0,0,1.);\n  \n  // GLSL is templated out to pick the right texture and set the vec4 color\n  %%texture_picker%%\n  \n  color.rgb=color.rgb*v_opacity;\n  color.a=color.a*v_opacity;\n  fragColor=color*v_tint;\n}");

/***/ }),

/***/ "./Graphics/Context/image-renderer/image-renderer.ts":
/*!***********************************************************!*\
  !*** ./Graphics/Context/image-renderer/image-renderer.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ImageRenderer: () => (/* binding */ ImageRenderer)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../Color */ "./Color.ts");
/* harmony import */ var _Math_util__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../Math/util */ "./Math/util.ts");
/* harmony import */ var _Filtering__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../Filtering */ "./Graphics/Filtering.ts");
/* harmony import */ var _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../GraphicsDiagnostics */ "./Graphics/GraphicsDiagnostics.ts");
/* harmony import */ var _ImageSource__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../ImageSource */ "./Graphics/ImageSource.ts");
/* harmony import */ var _Wrapping__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../Wrapping */ "./Graphics/Wrapping.ts");
/* harmony import */ var _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../ExcaliburGraphicsContextWebGL */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");
/* harmony import */ var _quad_index_buffer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../quad-index-buffer */ "./Graphics/Context/quad-index-buffer.ts");
/* harmony import */ var _shader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../shader */ "./Graphics/Context/shader.ts");
/* harmony import */ var _vertex_buffer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../vertex-buffer */ "./Graphics/Context/vertex-buffer.ts");
/* harmony import */ var _vertex_layout__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../vertex-layout */ "./Graphics/Context/vertex-layout.ts");
/* harmony import */ var _webgl_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../webgl-util */ "./Graphics/Context/webgl-util.ts");
/* harmony import */ var _image_renderer_frag_glsl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./image-renderer.frag.glsl */ "./Graphics/Context/image-renderer/image-renderer.frag.glsl");
/* harmony import */ var _image_renderer_vert_glsl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./image-renderer.vert.glsl */ "./Graphics/Context/image-renderer/image-renderer.vert.glsl");














class ImageRenderer {
    constructor(options) {
        this.type = 'ex.image';
        this.priority = 0;
        this._maxImages = 10922; // max(uint16) / 6 verts
        this._maxTextures = 0;
        // Per flush vars
        this._imageCount = 0;
        this._textures = [];
        this._textureIndex = 0;
        this._textureToIndex = new Map();
        this._images = new Set();
        this._vertexIndex = 0;
        this._imageToWidth = new Map();
        this._imageToHeight = new Map();
        this._view = [0, 0, 0, 0];
        this._dest = [0, 0];
        this._quad = [0, 0, 0, 0, 0, 0, 0, 0];
        this._defaultTint = _Color__WEBPACK_IMPORTED_MODULE_0__.Color.White;
        this.pixelArtSampler = options.pixelArtSampler;
        this.uvPadding = options.uvPadding;
    }
    initialize(gl, context) {
        this._gl = gl;
        this._context = context;
        const maxTexture = gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS);
        const maxComplexity = (0,_webgl_util__WEBPACK_IMPORTED_MODULE_1__.getMaxShaderComplexity)(gl, maxTexture);
        this._maxTextures = Math.min(maxTexture, maxComplexity);
        const transformedFrag = this._transformFragmentSource(_image_renderer_frag_glsl__WEBPACK_IMPORTED_MODULE_2__["default"], this._maxTextures);
        // Compile shader
        this._shader = new _shader__WEBPACK_IMPORTED_MODULE_3__.Shader({
            graphicsContext: context,
            fragmentSource: transformedFrag,
            vertexSource: _image_renderer_vert_glsl__WEBPACK_IMPORTED_MODULE_4__["default"]
        });
        this._shader.compile();
        // setup uniforms
        this._shader.use();
        this._shader.setUniformMatrix('u_matrix', context.ortho);
        // Initialize texture slots to [0, 1, 2, 3, 4, .... maxGPUTextures]
        this._shader.setUniformIntArray('u_textures', [...Array(this._maxTextures)].map((_, i) => i));
        // Setup memory layout
        this._buffer = new _vertex_buffer__WEBPACK_IMPORTED_MODULE_5__.VertexBuffer({
            gl,
            size: 12 * 4 * this._maxImages, // 12 components * 4 verts
            type: 'dynamic'
        });
        this._layout = new _vertex_layout__WEBPACK_IMPORTED_MODULE_6__.VertexLayout({
            gl,
            shader: this._shader,
            vertexBuffer: this._buffer,
            attributes: [
                ['a_position', 2],
                ['a_opacity', 1],
                ['a_res', 2],
                ['a_texcoord', 2],
                ['a_textureIndex', 1],
                ['a_tint', 4]
            ]
        });
        // Setup index buffer
        this._quads = new _quad_index_buffer__WEBPACK_IMPORTED_MODULE_7__.QuadIndexBuffer(gl, this._maxImages, true);
    }
    dispose() {
        this._buffer.dispose();
        this._quads.dispose();
        this._shader.dispose();
        this._textures.length = 0;
        this._context = null;
        this._gl = null;
    }
    _transformFragmentSource(source, maxTextures) {
        let newSource = source.replace('%%count%%', maxTextures.toString());
        let texturePickerBuilder = '';
        for (let i = 0; i < maxTextures; i++) {
            if (i === 0) {
                texturePickerBuilder += `if (v_textureIndex <= ${i}.5) {\n`;
            }
            else {
                texturePickerBuilder += `   else if (v_textureIndex <= ${i}.5) {\n`;
            }
            texturePickerBuilder += `      vec2 uv = u_pixelart ? uv_iq(v_texcoord, v_res) : v_texcoord;\n`;
            texturePickerBuilder += `      color = texture(u_textures[${i}], uv);\n`;
            texturePickerBuilder += `   }\n`;
        }
        newSource = newSource.replace('%%texture_picker%%', texturePickerBuilder);
        return newSource;
    }
    _addImageAsTexture(image) {
        if (this._images.has(image)) {
            return;
        }
        const maybeFiltering = image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_8__.ImageSourceAttributeConstants.Filtering);
        const filtering = maybeFiltering ? (0,_Filtering__WEBPACK_IMPORTED_MODULE_9__.parseImageFiltering)(maybeFiltering) : undefined;
        const wrapX = (0,_Wrapping__WEBPACK_IMPORTED_MODULE_10__.parseImageWrapping)(image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_8__.ImageSourceAttributeConstants.WrappingX));
        const wrapY = (0,_Wrapping__WEBPACK_IMPORTED_MODULE_10__.parseImageWrapping)(image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_8__.ImageSourceAttributeConstants.WrappingY));
        const force = image.getAttribute('forceUpload') === 'true' ? true : false;
        const texture = this._context.textureLoader.load(image, {
            filtering,
            wrapping: { x: wrapX, y: wrapY }
        }, force);
        // remove force attribute after upload
        image.removeAttribute('forceUpload');
        if (this._textures.indexOf(texture) === -1) {
            this._textures.push(texture);
            this._textureToIndex.set(texture, this._textureIndex++);
            this._images.add(image);
        }
    }
    _bindTextures(gl) {
        // Bind textures in the correct order
        for (let i = 0; i < this._maxTextures; i++) {
            gl.activeTexture(gl.TEXTURE0 + i);
            gl.bindTexture(gl.TEXTURE_2D, this._textures[i] || this._textures[0]);
        }
    }
    _getTextureIdForImage(image) {
        var _a;
        if (image) {
            const maybeTexture = this._context.textureLoader.get(image);
            return (_a = this._textureToIndex.get(maybeTexture)) !== null && _a !== void 0 ? _a : -1; //this._textures.indexOf(maybeTexture);
        }
        return -1;
    }
    _isFull() {
        if (this._imageCount >= this._maxImages) {
            return true;
        }
        if (this._textures.length >= this._maxTextures) {
            return true;
        }
        return false;
    }
    _getImageWidth(image) {
        let maybeWidth = this._imageToWidth.get(image);
        if (maybeWidth === undefined) {
            maybeWidth = image.width;
            this._imageToWidth.set(image, maybeWidth);
        }
        return maybeWidth;
    }
    _getImageHeight(image) {
        let maybeHeight = this._imageToHeight.get(image);
        if (maybeHeight === undefined) {
            maybeHeight = image.height;
            this._imageToHeight.set(image, maybeHeight);
        }
        return maybeHeight;
    }
    draw(image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight) {
        var _a, _b, _c, _d;
        // Force a render if the batch is full
        if (this._isFull()) {
            this.flush();
        }
        this._imageCount++;
        // This creates and uploads the texture if not already done
        this._addImageAsTexture(image);
        const maybeImageWidth = this._getImageWidth(image);
        const maybeImageHeight = this._getImageHeight(image);
        let width = maybeImageWidth || swidth || 0;
        let height = maybeImageHeight || sheight || 0;
        this._view[0] = 0;
        this._view[1] = 0;
        this._view[2] = (_a = swidth !== null && swidth !== void 0 ? swidth : maybeImageWidth) !== null && _a !== void 0 ? _a : 0;
        this._view[3] = (_b = sheight !== null && sheight !== void 0 ? sheight : maybeImageHeight) !== null && _b !== void 0 ? _b : 0;
        this._dest[0] = sx !== null && sx !== void 0 ? sx : 1;
        this._dest[1] = sy !== null && sy !== void 0 ? sy : 1;
        // If destination is specified, update view and dest
        if (dx !== undefined && dy !== undefined && dwidth !== undefined && dheight !== undefined) {
            this._view[0] = sx !== null && sx !== void 0 ? sx : 1;
            this._view[1] = sy !== null && sy !== void 0 ? sy : 1;
            this._view[2] = (_c = swidth !== null && swidth !== void 0 ? swidth : maybeImageWidth) !== null && _c !== void 0 ? _c : 0;
            this._view[3] = (_d = sheight !== null && sheight !== void 0 ? sheight : maybeImageHeight) !== null && _d !== void 0 ? _d : 0;
            this._dest[0] = dx;
            this._dest[1] = dy;
            width = dwidth;
            height = dheight;
        }
        sx = this._view[0];
        sy = this._view[1];
        const sw = this._view[2];
        const sh = this._view[3];
        // transform based on current context
        const transform = this._context.getTransform();
        const opacity = this._context.opacity;
        const snapToPixel = this._context.snapToPixel;
        // top left
        this._quad[0] = this._dest[0];
        this._quad[1] = this._dest[1];
        // top right
        this._quad[2] = this._dest[0] + width;
        this._quad[3] = this._dest[1];
        // bottom left
        this._quad[4] = this._dest[0];
        this._quad[5] = this._dest[1] + height;
        // bottom right
        this._quad[6] = this._dest[0] + width;
        this._quad[7] = this._dest[1] + height;
        transform.multiplyQuadInPlace(this._quad);
        if (snapToPixel) {
            this._quad[0] = ~~(this._quad[0] + (0,_Math_util__WEBPACK_IMPORTED_MODULE_11__.sign)(this._quad[0]) * _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_12__.pixelSnapEpsilon);
            this._quad[1] = ~~(this._quad[1] + (0,_Math_util__WEBPACK_IMPORTED_MODULE_11__.sign)(this._quad[1]) * _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_12__.pixelSnapEpsilon);
            this._quad[2] = ~~(this._quad[2] + (0,_Math_util__WEBPACK_IMPORTED_MODULE_11__.sign)(this._quad[2]) * _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_12__.pixelSnapEpsilon);
            this._quad[3] = ~~(this._quad[3] + (0,_Math_util__WEBPACK_IMPORTED_MODULE_11__.sign)(this._quad[3]) * _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_12__.pixelSnapEpsilon);
            this._quad[4] = ~~(this._quad[4] + (0,_Math_util__WEBPACK_IMPORTED_MODULE_11__.sign)(this._quad[4]) * _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_12__.pixelSnapEpsilon);
            this._quad[5] = ~~(this._quad[5] + (0,_Math_util__WEBPACK_IMPORTED_MODULE_11__.sign)(this._quad[5]) * _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_12__.pixelSnapEpsilon);
            this._quad[6] = ~~(this._quad[6] + (0,_Math_util__WEBPACK_IMPORTED_MODULE_11__.sign)(this._quad[6]) * _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_12__.pixelSnapEpsilon);
            this._quad[7] = ~~(this._quad[7] + (0,_Math_util__WEBPACK_IMPORTED_MODULE_11__.sign)(this._quad[7]) * _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_12__.pixelSnapEpsilon);
        }
        const tint = this._context.tint || this._defaultTint;
        const textureId = this._getTextureIdForImage(image);
        const imageWidth = maybeImageWidth || width;
        const imageHeight = maybeImageHeight || height;
        const uvx0 = (sx + this.uvPadding) / imageWidth;
        const uvy0 = (sy + this.uvPadding) / imageHeight;
        const uvx1 = (sx + sw - this.uvPadding) / imageWidth;
        const uvy1 = (sy + sh - this.uvPadding) / imageHeight;
        const txWidth = maybeImageWidth;
        const txHeight = maybeImageHeight;
        // update data
        const vertexBuffer = this._layout.vertexBuffer.bufferData;
        // (0, 0) - 0
        vertexBuffer[this._vertexIndex++] = this._quad[0];
        vertexBuffer[this._vertexIndex++] = this._quad[1];
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = txWidth;
        vertexBuffer[this._vertexIndex++] = txHeight;
        vertexBuffer[this._vertexIndex++] = uvx0;
        vertexBuffer[this._vertexIndex++] = uvy0;
        vertexBuffer[this._vertexIndex++] = textureId;
        vertexBuffer[this._vertexIndex++] = tint.r / 255;
        vertexBuffer[this._vertexIndex++] = tint.g / 255;
        vertexBuffer[this._vertexIndex++] = tint.b / 255;
        vertexBuffer[this._vertexIndex++] = tint.a;
        // (0, 1) - 1
        vertexBuffer[this._vertexIndex++] = this._quad[4];
        vertexBuffer[this._vertexIndex++] = this._quad[5];
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = txWidth;
        vertexBuffer[this._vertexIndex++] = txHeight;
        vertexBuffer[this._vertexIndex++] = uvx0;
        vertexBuffer[this._vertexIndex++] = uvy1;
        vertexBuffer[this._vertexIndex++] = textureId;
        vertexBuffer[this._vertexIndex++] = tint.r / 255;
        vertexBuffer[this._vertexIndex++] = tint.g / 255;
        vertexBuffer[this._vertexIndex++] = tint.b / 255;
        vertexBuffer[this._vertexIndex++] = tint.a;
        // (1, 0) - 2
        vertexBuffer[this._vertexIndex++] = this._quad[2];
        vertexBuffer[this._vertexIndex++] = this._quad[3];
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = txWidth;
        vertexBuffer[this._vertexIndex++] = txHeight;
        vertexBuffer[this._vertexIndex++] = uvx1;
        vertexBuffer[this._vertexIndex++] = uvy0;
        vertexBuffer[this._vertexIndex++] = textureId;
        vertexBuffer[this._vertexIndex++] = tint.r / 255;
        vertexBuffer[this._vertexIndex++] = tint.g / 255;
        vertexBuffer[this._vertexIndex++] = tint.b / 255;
        vertexBuffer[this._vertexIndex++] = tint.a;
        // (1, 1) - 3
        vertexBuffer[this._vertexIndex++] = this._quad[6];
        vertexBuffer[this._vertexIndex++] = this._quad[7];
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = txWidth;
        vertexBuffer[this._vertexIndex++] = txHeight;
        vertexBuffer[this._vertexIndex++] = uvx1;
        vertexBuffer[this._vertexIndex++] = uvy1;
        vertexBuffer[this._vertexIndex++] = textureId;
        vertexBuffer[this._vertexIndex++] = tint.r / 255;
        vertexBuffer[this._vertexIndex++] = tint.g / 255;
        vertexBuffer[this._vertexIndex++] = tint.b / 255;
        vertexBuffer[this._vertexIndex++] = tint.a;
    }
    hasPendingDraws() {
        return this._imageCount !== 0;
    }
    flush() {
        // nothing to draw early exit
        if (this._imageCount === 0) {
            return;
        }
        const gl = this._gl;
        // Bind the shader
        this._shader.use();
        // Bind the memory layout and upload data
        this._layout.use(true, 4 * 12 * this._imageCount); // 4 verts * 12 components
        // Update ortho matrix uniform
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
        // Turn on pixel art aa sampler
        this._shader.setUniformBoolean('u_pixelart', this.pixelArtSampler);
        // Bind textures to
        this._bindTextures(gl);
        // Bind index buffer
        this._quads.bind();
        // Draw all the quads
        gl.drawElements(gl.TRIANGLES, this._imageCount * 6, this._quads.bufferGlType, 0);
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_13__.GraphicsDiagnostics.DrawnImagesCount += this._imageCount;
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_13__.GraphicsDiagnostics.DrawCallCount++;
        // Reset
        this._imageCount = 0;
        this._vertexIndex = 0;
        this._textures.length = 0;
        this._textureIndex = 0;
        this._textureToIndex.clear();
        this._images.clear();
        this._imageToWidth.clear();
        this._imageToHeight.clear();
    }
}


/***/ }),

/***/ "./Graphics/Context/image-renderer/image-renderer.vert.glsl":
/*!******************************************************************!*\
  !*** ./Graphics/Context/image-renderer/image-renderer.vert.glsl ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nin vec2 a_position;\n\n// Opacity\nin float a_opacity;\nout float v_opacity;\n\n// UV coordinate\nin vec2 a_texcoord;\nout vec2 v_texcoord;\n\n// Texture res\nin vec2 a_res;\nout vec2 v_res;\n\n// Texture number\nin lowp float a_textureIndex;\nout lowp float v_textureIndex;\n\nin vec4 a_tint;\nout vec4 v_tint;\n\nuniform mat4 u_matrix;\n\nvoid main(){\n  // Set the vertex position using the ortho transform matrix\n  gl_Position=u_matrix*vec4(a_position,0.,1.);\n  \n  // Pass through the Opacity to the fragment shader\n  v_opacity=a_opacity;\n  // Pass through the UV coord to the fragment shader\n  v_texcoord=a_texcoord;\n\n  v_res = a_res;\n\n  // Pass through the texture number to the fragment shader\n  v_textureIndex=a_textureIndex;\n  // Pass through the tint\n  v_tint=a_tint;\n}");

/***/ }),

/***/ "./Graphics/Context/line-renderer/line-fragment.glsl":
/*!***********************************************************!*\
  !*** ./Graphics/Context/line-renderer/line-fragment.glsl ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nprecision mediump float;\n\n// Color\nin lowp vec4 v_color;\n\nout vec4 fragColor;\n\nvoid main() {\n  fragColor = v_color;\n}");

/***/ }),

/***/ "./Graphics/Context/line-renderer/line-renderer.ts":
/*!*********************************************************!*\
  !*** ./Graphics/Context/line-renderer/line-renderer.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LineRenderer: () => (/* binding */ LineRenderer)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _line_vertex_glsl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./line-vertex.glsl */ "./Graphics/Context/line-renderer/line-vertex.glsl");
/* harmony import */ var _line_fragment_glsl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./line-fragment.glsl */ "./Graphics/Context/line-renderer/line-fragment.glsl");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../.. */ "./Graphics/Context/shader.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../.. */ "./Graphics/Context/vertex-buffer.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../.. */ "./Graphics/Context/vertex-layout.ts");
/* harmony import */ var _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../GraphicsDiagnostics */ "./Graphics/GraphicsDiagnostics.ts");





class LineRenderer {
    constructor() {
        this.type = 'ex.line';
        this.priority = 0;
        this._maxLines = 10922;
        this._vertexIndex = 0;
        this._lineCount = 0;
        this._startScratch = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
        this._endScratch = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_0__.vec)(0, 0);
    }
    initialize(gl, context) {
        this._gl = gl;
        this._context = context;
        this._shader = new ___WEBPACK_IMPORTED_MODULE_1__.Shader({
            graphicsContext: context,
            vertexSource: _line_vertex_glsl__WEBPACK_IMPORTED_MODULE_2__["default"],
            fragmentSource: _line_fragment_glsl__WEBPACK_IMPORTED_MODULE_3__["default"]
        });
        this._shader.compile();
        this._shader.use();
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
        this._vertexBuffer = new ___WEBPACK_IMPORTED_MODULE_4__.VertexBuffer({
            gl,
            size: 6 * 2 * this._maxLines,
            type: 'dynamic'
        });
        this._layout = new ___WEBPACK_IMPORTED_MODULE_5__.VertexLayout({
            gl,
            vertexBuffer: this._vertexBuffer,
            shader: this._shader,
            attributes: [
                ['a_position', 2],
                ['a_color', 4]
            ]
        });
    }
    dispose() {
        this._vertexBuffer.dispose();
        this._shader.dispose();
        this._context = null;
        this._gl = null;
    }
    draw(start, end, color) {
        // Force a render if the batch is full
        if (this._isFull()) {
            this.flush();
        }
        this._lineCount++;
        const transform = this._context.getTransform();
        const finalStart = transform.multiply(start, this._startScratch);
        const finalEnd = transform.multiply(end, this._endScratch);
        const vertexBuffer = this._vertexBuffer.bufferData;
        // Start
        vertexBuffer[this._vertexIndex++] = finalStart.x;
        vertexBuffer[this._vertexIndex++] = finalStart.y;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        // End
        vertexBuffer[this._vertexIndex++] = finalEnd.x;
        vertexBuffer[this._vertexIndex++] = finalEnd.y;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
    }
    _isFull() {
        if (this._lineCount >= this._maxLines) {
            return true;
        }
        return false;
    }
    hasPendingDraws() {
        return this._lineCount !== 0;
    }
    flush() {
        // nothing to draw early exit
        if (this._lineCount === 0) {
            return;
        }
        const gl = this._gl;
        this._shader.use();
        this._layout.use(true);
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
        gl.drawArrays(gl.LINES, 0, this._lineCount * 2); // 2 verts per line
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_6__.GraphicsDiagnostics.DrawnImagesCount += this._lineCount;
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_6__.GraphicsDiagnostics.DrawCallCount++;
        // reset
        this._vertexIndex = 0;
        this._lineCount = 0;
    }
}


/***/ }),

/***/ "./Graphics/Context/line-renderer/line-vertex.glsl":
/*!*********************************************************!*\
  !*** ./Graphics/Context/line-renderer/line-vertex.glsl ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nin vec2 a_position;\nin vec4 a_color;\n\nout lowp vec4 v_color;\n\nuniform mat4 u_matrix;\n\nvoid main() {\n   // Set the vertex position using the ortho transform matrix\n   gl_Position = u_matrix * vec4(a_position, 0.0, 1.0);\n\n   // Passthrough the color\n   v_color = a_color;\n}");

/***/ }),

/***/ "./Graphics/Context/material-renderer/material-renderer.ts":
/*!*****************************************************************!*\
  !*** ./Graphics/Context/material-renderer/material-renderer.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MaterialRenderer: () => (/* binding */ MaterialRenderer)
/* harmony export */ });
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Filtering__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Filtering */ "./Graphics/Filtering.ts");
/* harmony import */ var _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../GraphicsDiagnostics */ "./Graphics/GraphicsDiagnostics.ts");
/* harmony import */ var _ImageSource__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../ImageSource */ "./Graphics/ImageSource.ts");
/* harmony import */ var _Wrapping__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../Wrapping */ "./Graphics/Wrapping.ts");
/* harmony import */ var _quad_index_buffer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../quad-index-buffer */ "./Graphics/Context/quad-index-buffer.ts");
/* harmony import */ var _vertex_buffer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../vertex-buffer */ "./Graphics/Context/vertex-buffer.ts");
/* harmony import */ var _vertex_layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../vertex-layout */ "./Graphics/Context/vertex-layout.ts");








class MaterialRenderer {
    constructor() {
        this.type = 'ex.material';
        this.priority = 0;
        this._textures = [];
    }
    initialize(gl, context) {
        this._gl = gl;
        this._context = context;
        // Setup memory layout
        this._buffer = new _vertex_buffer__WEBPACK_IMPORTED_MODULE_0__.VertexBuffer({
            gl,
            size: 6 * 4, // 6 components * 4 verts
            type: 'dynamic'
        });
        // Setup a vertex layout/buffer to the material
        this._layout = new _vertex_layout__WEBPACK_IMPORTED_MODULE_1__.VertexLayout({
            gl,
            vertexBuffer: this._buffer,
            attributes: [
                ['a_position', 2],
                ['a_uv', 2],
                ['a_screenuv', 2]
            ],
            suppressWarnings: true
        });
        // Setup index buffer
        this._quads = new _quad_index_buffer__WEBPACK_IMPORTED_MODULE_2__.QuadIndexBuffer(gl, 1, true);
    }
    dispose() {
        this._buffer.dispose();
        this._quads.dispose();
        this._textures.length = 0;
        this._context = null;
        this._gl = null;
    }
    draw(image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight) {
        var _a, _b, _c, _d;
        const gl = this._gl;
        // Extract context info
        const material = this._context.material;
        if (!material) {
            return;
        }
        const transform = this._context.getTransform();
        const opacity = this._context.opacity;
        // material shader
        const shader = material.getShader();
        // construct geometry, or hold on to it in the material?
        // geometry primitive for drawing rectangles?
        // update data
        const vertexBuffer = this._layout.vertexBuffer.bufferData;
        let vertexIndex = 0;
        let width = (image === null || image === void 0 ? void 0 : image.width) || swidth || 0;
        let height = (image === null || image === void 0 ? void 0 : image.height) || sheight || 0;
        let view = [0, 0, (_a = swidth !== null && swidth !== void 0 ? swidth : image === null || image === void 0 ? void 0 : image.width) !== null && _a !== void 0 ? _a : 0, (_b = sheight !== null && sheight !== void 0 ? sheight : image === null || image === void 0 ? void 0 : image.height) !== null && _b !== void 0 ? _b : 0];
        let dest = [sx !== null && sx !== void 0 ? sx : 1, sy !== null && sy !== void 0 ? sy : 1];
        // If destination is specified, update view and dest
        if (dx !== undefined && dy !== undefined && dwidth !== undefined && dheight !== undefined) {
            view = [sx !== null && sx !== void 0 ? sx : 1, sy !== null && sy !== void 0 ? sy : 1, (_c = swidth !== null && swidth !== void 0 ? swidth : image === null || image === void 0 ? void 0 : image.width) !== null && _c !== void 0 ? _c : 0, (_d = sheight !== null && sheight !== void 0 ? sheight : image === null || image === void 0 ? void 0 : image.height) !== null && _d !== void 0 ? _d : 0];
            dest = [dx, dy];
            width = dwidth;
            height = dheight;
        }
        sx = view[0];
        sy = view[1];
        const sw = view[2];
        const sh = view[3];
        const topLeft = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(dest[0], dest[1]);
        const topRight = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(dest[0] + width, dest[1]);
        const bottomLeft = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(dest[0], dest[1] + height);
        const bottomRight = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(dest[0] + width, dest[1] + height);
        const imageWidth = image.width || width;
        const imageHeight = image.height || height;
        const uvx0 = sx / imageWidth;
        const uvy0 = sy / imageHeight;
        const uvx1 = (sx + sw - 0.01) / imageWidth;
        const uvy1 = (sy + sh - 0.01) / imageHeight;
        const topLeftScreen = transform.getPosition();
        const bottomRightScreen = topLeftScreen.add(bottomRight);
        const screenUVX0 = topLeftScreen.x / this._context.width;
        const screenUVY0 = topLeftScreen.y / this._context.height;
        const screenUVX1 = bottomRightScreen.x / this._context.width;
        const screenUVY1 = bottomRightScreen.y / this._context.height;
        // (0, 0) - 0
        vertexBuffer[vertexIndex++] = topLeft.x;
        vertexBuffer[vertexIndex++] = topLeft.y;
        vertexBuffer[vertexIndex++] = uvx0;
        vertexBuffer[vertexIndex++] = uvy0;
        vertexBuffer[vertexIndex++] = screenUVX0;
        vertexBuffer[vertexIndex++] = screenUVY0;
        // (0, 1) - 1
        vertexBuffer[vertexIndex++] = bottomLeft.x;
        vertexBuffer[vertexIndex++] = bottomLeft.y;
        vertexBuffer[vertexIndex++] = uvx0;
        vertexBuffer[vertexIndex++] = uvy1;
        vertexBuffer[vertexIndex++] = screenUVX0;
        vertexBuffer[vertexIndex++] = screenUVY1;
        // (1, 0) - 2
        vertexBuffer[vertexIndex++] = topRight.x;
        vertexBuffer[vertexIndex++] = topRight.y;
        vertexBuffer[vertexIndex++] = uvx1;
        vertexBuffer[vertexIndex++] = uvy0;
        vertexBuffer[vertexIndex++] = screenUVX1;
        vertexBuffer[vertexIndex++] = screenUVY0;
        // (1, 1) - 3
        vertexBuffer[vertexIndex++] = bottomRight.x;
        vertexBuffer[vertexIndex++] = bottomRight.y;
        vertexBuffer[vertexIndex++] = uvx1;
        vertexBuffer[vertexIndex++] = uvy1;
        vertexBuffer[vertexIndex++] = screenUVX1;
        vertexBuffer[vertexIndex++] = screenUVY1;
        // This creates and uploads the texture if not already done
        const texture = this._addImageAsTexture(image);
        // apply material
        material.use();
        this._layout.shader = shader;
        // apply layout and geometry
        this._layout.use(true);
        // apply time in ms since the page (performance.now())
        shader.trySetUniformFloat('u_time_ms', performance.now());
        // apply opacity
        shader.trySetUniformFloat('u_opacity', opacity);
        // apply resolution
        shader.trySetUniformFloatVector('u_resolution', (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(this._context.width, this._context.height));
        // apply graphic resolution
        shader.trySetUniformFloatVector('u_graphic_resolution', (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(imageWidth, imageHeight));
        // apply size
        shader.trySetUniformFloatVector('u_size', (0,_Math_vector__WEBPACK_IMPORTED_MODULE_3__.vec)(sw, sh));
        // apply orthographic projection
        shader.trySetUniformMatrix('u_matrix', this._context.ortho);
        // apply geometry transform
        shader.trySetUniformMatrix('u_transform', transform.to4x4());
        // bind graphic image texture 'uniform sampler2D u_graphic;'
        gl.activeTexture(gl.TEXTURE0 + 0);
        gl.bindTexture(gl.TEXTURE_2D, texture);
        shader.trySetUniformInt('u_graphic', 0);
        // bind the screen texture
        if (material.isUsingScreenTexture) {
            gl.activeTexture(gl.TEXTURE0 + 1);
            gl.bindTexture(gl.TEXTURE_2D, this._context.materialScreenTexture);
            shader.trySetUniformInt('u_screen_texture', 1);
        }
        // bind quad index buffer
        this._quads.bind();
        // Draw a single quad
        gl.drawElements(gl.TRIANGLES, 6, this._quads.bufferGlType, 0);
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_4__.GraphicsDiagnostics.DrawnImagesCount++;
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_4__.GraphicsDiagnostics.DrawCallCount++;
    }
    _addImageAsTexture(image) {
        const maybeFiltering = image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_5__.ImageSourceAttributeConstants.Filtering);
        const filtering = maybeFiltering ? (0,_Filtering__WEBPACK_IMPORTED_MODULE_6__.parseImageFiltering)(maybeFiltering) : undefined;
        const wrapX = (0,_Wrapping__WEBPACK_IMPORTED_MODULE_7__.parseImageWrapping)(image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_5__.ImageSourceAttributeConstants.WrappingX));
        const wrapY = (0,_Wrapping__WEBPACK_IMPORTED_MODULE_7__.parseImageWrapping)(image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_5__.ImageSourceAttributeConstants.WrappingY));
        const force = image.getAttribute('forceUpload') === 'true' ? true : false;
        const texture = this._context.textureLoader.load(image, {
            filtering,
            wrapping: { x: wrapX, y: wrapY }
        }, force);
        // remove force attribute after upload
        image.removeAttribute('forceUpload');
        if (this._textures.indexOf(texture) === -1) {
            this._textures.push(texture);
        }
        return texture;
    }
    hasPendingDraws() {
        return false;
    }
    flush() {
        // flush does not do anything, material renderer renders immediately per draw
    }
}


/***/ }),

/***/ "./Graphics/Context/material.ts":
/*!**************************************!*\
  !*** ./Graphics/Context/material.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Material: () => (/* binding */ Material)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Color */ "./Color.ts");
/* harmony import */ var _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ExcaliburGraphicsContextWebGL */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Util/Log */ "./Util/Log.ts");



const defaultVertexSource = `#version 300 es
in vec2 a_position;

in vec2 a_uv;
out vec2 v_uv;

in vec2 a_screenuv;
out vec2 v_screenuv;

uniform mat4 u_matrix;
uniform mat4 u_transform;

void main() {
  // Set the vertex position using the ortho & transform matrix
  gl_Position = u_matrix * u_transform * vec4(a_position, 0.0, 1.0);

  // Pass through the UV coord to the fragment shader
  v_uv = a_uv;
  v_screenuv = a_screenuv;
}
`;
class Material {
    constructor(options) {
        this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_0__.Logger.getInstance();
        this._color = _Color__WEBPACK_IMPORTED_MODULE_1__.Color.Transparent;
        this._initialized = false;
        this._images = {};
        this._uniforms = {};
        const { color, name, vertexSource, fragmentSource, graphicsContext, images, uniforms } = options;
        this._name = name !== null && name !== void 0 ? name : 'anonymous material';
        this._vertexSource = vertexSource !== null && vertexSource !== void 0 ? vertexSource : defaultVertexSource;
        this._fragmentSource = fragmentSource;
        this._color = color !== null && color !== void 0 ? color : this._color;
        this._uniforms = uniforms !== null && uniforms !== void 0 ? uniforms : this._uniforms;
        this._images = images !== null && images !== void 0 ? images : this._images;
        if (!graphicsContext) {
            throw Error(`Material ${name} must be provided an excalibur webgl graphics context`);
        }
        if (graphicsContext instanceof _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_2__.ExcaliburGraphicsContextWebGL) {
            this._initialize(graphicsContext);
        }
        else {
            this._logger.warn(`Material ${name} was created in 2D Canvas mode, currently only WebGL is supported`);
        }
    }
    _initialize(graphicsContextWebGL) {
        if (this._initialized) {
            return;
        }
        this._shader = graphicsContextWebGL.createShader({
            name: this._name,
            vertexSource: this._vertexSource,
            fragmentSource: this._fragmentSource,
            uniforms: this._uniforms,
            images: this._images,
            // max texture slots
            // - 2 for the graphic texture and screen texture
            // - 1 if just graphic
            startingTextureSlot: this.isUsingScreenTexture ? 2 : 1
        });
        this._initialized = true;
    }
    get uniforms() {
        return this._shader.uniforms;
    }
    get images() {
        return this._shader.images;
    }
    get color() {
        return this._color;
    }
    set color(c) {
        this._color = c;
    }
    get name() {
        return this._name;
    }
    get isUsingScreenTexture() {
        return this._fragmentSource.includes('u_screen_texture');
    }
    update(callback) {
        if (this._shader) {
            this._shader.use();
            callback(this._shader);
        }
    }
    getShader() {
        return this._shader;
    }
    addImageSource(samplerName, image) {
        this._shader.addImageSource(samplerName, image);
    }
    removeImageSource(samplerName) {
        this._shader.removeImageSource(samplerName);
    }
    use() {
        if (this._initialized) {
            // bind the shader
            this._shader.use();
            // Apply standard uniforms
            this._shader.trySetUniformFloatColor('u_color', this._color);
        }
        else {
            throw Error(`Material ${this.name} not yet initialized, use the ExcaliburGraphicsContext.createMaterial() to work around this.`);
        }
    }
}


/***/ }),

/***/ "./Graphics/Context/particle-renderer/particle-fragment.glsl":
/*!*******************************************************************!*\
  !*** ./Graphics/Context/particle-renderer/particle-fragment.glsl ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nprecision mediump float;\n\nuniform sampler2D graphic;\nuniform bool useTexture;\nuniform float maxLifeMs;\n\nuniform vec4 beginColor;\nuniform vec4 endColor;\nuniform bool fade;\nuniform float startOpacity;\n\nin float finalRotation;\nin float finalLifeMs;\nout vec4 fragColor;\n\nvoid main(){\n\n  float lifePct = finalLifeMs / maxLifeMs;\n\n  if (useTexture) {\n    /** Draw texture */\n    if (lifePct <= 0.) discard;\n    float mid = .5;\n    float cosine = cos(finalRotation);\n    float sine = sin(finalRotation);\n    vec2 rotated = vec2(cosine * (gl_PointCoord.x - mid) + sine * (gl_PointCoord.y - mid) + mid,\n                        cosine * (gl_PointCoord.y - mid) - sine * (gl_PointCoord.x - mid) + mid);\n    vec4 color = texture(graphic, rotated);\n    fragColor = color * (fade ? lifePct : 1.0);\n  } else {\n    /** Draw circle */\n    if (lifePct <= 0.) discard;\n    vec2 uv = gl_PointCoord.xy * 2.0 - 1.0;\n    float dist = 1.0 - length(uv);\n    float edge = fwidth(dot(uv, uv));\n    float circle = smoothstep(-edge/2.0, edge/2.0, dist);\n    vec3 color = mix(beginColor.rgb, endColor.rgb, 1.0 - lifePct);\n    fragColor.rgb = color;\n    fragColor.a = startOpacity * circle * (fade ? lifePct : 1.0);// * mix(beginColor.a, endColor.a, 1.0 - lifePct);\n    fragColor.rgb *= fragColor.a;\n  }\n}");

/***/ }),

/***/ "./Graphics/Context/particle-renderer/particle-renderer.ts":
/*!*****************************************************************!*\
  !*** ./Graphics/Context/particle-renderer/particle-renderer.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ParticleRenderer: () => (/* binding */ ParticleRenderer)
/* harmony export */ });
/* harmony import */ var _shader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../shader */ "./Graphics/Context/shader.ts");
/* harmony import */ var _particle_vertex_glsl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./particle-vertex.glsl */ "./Graphics/Context/particle-renderer/particle-vertex.glsl");
/* harmony import */ var _particle_fragment_glsl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./particle-fragment.glsl */ "./Graphics/Context/particle-renderer/particle-fragment.glsl");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../Color */ "./Color.ts");
/* harmony import */ var _ImageSource__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../ImageSource */ "./Graphics/ImageSource.ts");
/* harmony import */ var _Wrapping__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Wrapping */ "./Graphics/Wrapping.ts");
/* harmony import */ var _Filtering__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Filtering */ "./Graphics/Filtering.ts");
/* harmony import */ var _Particles_Particles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../Particles/Particles */ "./Particles/Particles.ts");









class ParticleRenderer {
    constructor() {
        this.type = 'ex.particle';
        this.priority = 0;
    }
    initialize(gl, context) {
        this._gl = gl;
        this._context = context;
        this._shader = new _shader__WEBPACK_IMPORTED_MODULE_0__.Shader({
            graphicsContext: context,
            vertexSource: _particle_vertex_glsl__WEBPACK_IMPORTED_MODULE_1__["default"],
            fragmentSource: _particle_fragment_glsl__WEBPACK_IMPORTED_MODULE_2__["default"],
            onPreLink: (program) => {
                gl.transformFeedbackVaryings(program, ['finalPosition', 'finalVelocity', 'finalRotation', 'finalAngularVelocity', 'finalLifeMs'], gl.INTERLEAVED_ATTRIBS);
            }
        });
        this._shader.compile();
        this._shader.use();
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
    }
    _getTexture(image) {
        const maybeFiltering = image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_3__.ImageSourceAttributeConstants.Filtering);
        const filtering = maybeFiltering ? (0,_Filtering__WEBPACK_IMPORTED_MODULE_4__.parseImageFiltering)(maybeFiltering) : undefined;
        const wrapX = (0,_Wrapping__WEBPACK_IMPORTED_MODULE_5__.parseImageWrapping)(image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_3__.ImageSourceAttributeConstants.WrappingX));
        const wrapY = (0,_Wrapping__WEBPACK_IMPORTED_MODULE_5__.parseImageWrapping)(image.getAttribute(_ImageSource__WEBPACK_IMPORTED_MODULE_3__.ImageSourceAttributeConstants.WrappingY));
        const force = image.getAttribute('forceUpload') === 'true' ? true : false;
        const texture = this._context.textureLoader.load(image, {
            filtering,
            wrapping: { x: wrapX, y: wrapY }
        }, force);
        // remove force attribute after upload
        image.removeAttribute('forceUpload');
        return texture;
    }
    draw(renderer, elapsed) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const gl = this._gl;
        this._shader.use();
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
        const transform = renderer.particle.transform === _Particles_Particles__WEBPACK_IMPORTED_MODULE_6__.ParticleTransform.Local
            ? this._context.getTransform()
            : this._context.getTransform().multiply(renderer.emitter.transform.get().inverse);
        this._shader.setUniformAffineMatrix('u_transform', transform);
        this._shader.setUniformBoolean('fade', renderer.particle.fade ? true : false);
        this._shader.setUniformBoolean('useTexture', renderer.particle.graphic ? true : false);
        this._shader.setUniformFloat('maxLifeMs', (_a = renderer.particle.life) !== null && _a !== void 0 ? _a : 2000);
        this._shader.setUniformFloat('deltaMs', elapsed);
        this._shader.setUniformFloatVector('gravity', (_b = renderer.particle.acc) !== null && _b !== void 0 ? _b : (0,_Math_vector__WEBPACK_IMPORTED_MODULE_7__.vec)(0, 0));
        this._shader.setUniformFloatColor('beginColor', (_c = renderer.particle.beginColor) !== null && _c !== void 0 ? _c : _Color__WEBPACK_IMPORTED_MODULE_8__.Color.Transparent);
        this._shader.setUniformFloatColor('endColor', (_d = renderer.particle.endColor) !== null && _d !== void 0 ? _d : _Color__WEBPACK_IMPORTED_MODULE_8__.Color.Transparent);
        let startSize = (_e = renderer.particle.startSize) !== null && _e !== void 0 ? _e : 0;
        let endSize = (_f = renderer.particle.endSize) !== null && _f !== void 0 ? _f : 0;
        const size = (_g = renderer.particle.size) !== null && _g !== void 0 ? _g : 0;
        if (size > 0) {
            startSize = size;
            endSize = size;
        }
        this._shader.setUniformFloat('startSize', startSize !== null && startSize !== void 0 ? startSize : 10);
        this._shader.setUniformFloat('endSize', endSize !== null && endSize !== void 0 ? endSize : 10);
        this._shader.setUniformFloat('startOpacity', (_h = renderer.particle.opacity) !== null && _h !== void 0 ? _h : 1);
        if (renderer.particle.focus) {
            this._shader.setUniformFloatVector('focus', renderer.particle.focus);
            this._shader.setUniformFloat('focusAccel', (_j = renderer.particle.focusAccel) !== null && _j !== void 0 ? _j : 0);
        }
        // Particle Graphic (only Sprites right now)
        if (renderer.particle.graphic) {
            const graphic = renderer.particle.graphic;
            const texture = this._getTexture(graphic.image.image);
            gl.activeTexture(gl.TEXTURE0);
            gl.bindTexture(gl.TEXTURE_2D, texture);
            this._shader.setUniformInt('graphic', 0);
        }
        // Collision Mask
        // gl.activeTexture(gl.TEXTURE0 + 1);
        // gl.bindTexture(gl.TEXTURE_2D, obstacleTex);
        // gl.uniform1i(u_obstacle, 1);
        renderer.draw(gl);
    }
    hasPendingDraws() {
        return false;
    }
    flush() {
        // pass
    }
    dispose() {
        // pass
    }
}


/***/ }),

/***/ "./Graphics/Context/particle-renderer/particle-vertex.glsl":
/*!*****************************************************************!*\
  !*** ./Graphics/Context/particle-renderer/particle-vertex.glsl ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nprecision mediump float;\n\nuniform float deltaMs;\nuniform float maxLifeMs;\nuniform vec2 gravity;\nuniform vec2 focus;\nuniform float focusAccel;\nuniform mat4 u_matrix;\nuniform mat4 u_transform;\nuniform float startSize;\nuniform float endSize;\n// uniform sampler2D obstacle;\n\nlayout(location=0)in vec2 position;\nlayout(location=1)in vec2 velocity;\nlayout(location=2)in float rotation;\nlayout(location=3)in float angularVelocity;\nlayout(location=4)in float lifeMs;\n\n// TODO z index to handle buffer wrapping?\n\n// DO NOT RE-ORDER\nout vec2 finalPosition;\nout vec2 finalVelocity;\nout float finalRotation;\nout float finalAngularVelocity;\nout float finalLifeMs;\nvoid main(){\n  // Evolve particle\n  float seconds = deltaMs / 1000.;\n  // euler integration\n  // Weird artifact of re-using the same buffer layout for update/draw\n  // we need differently named variables\n  vec2 finalGravity = gravity + normalize(focus - position) * focusAccel;\n  finalVelocity = velocity + finalGravity * seconds;\n  finalPosition = position + velocity * seconds + finalGravity * .5 * seconds * seconds;\n  finalRotation = rotation + angularVelocity * seconds;\n  finalAngularVelocity = angularVelocity;\n  finalLifeMs = clamp(lifeMs - deltaMs, 0., maxLifeMs);\n\n  // Collision mask sampling\n  // vec2 samplePoint = finalPosition / vec2(width, height);\n  // vec4 collides = texture(obstacle, samplePoint);\n  // if (distance(collides,vec4(0.)) > .01) {\n  //   // non opaque means we collide! recalc final pos/vel\n  //   vec2 newVelocity = velocity * -.1;// lose energy\n  //   finalVelocity = newVelocity + gravity * seconds;\n  //   finalPosition = position + newVelocity * seconds + gravity * .5 * seconds * seconds;\n  // }\n\n  float lifePercent = finalLifeMs / maxLifeMs;\n  vec2 transformedPos = (u_matrix * u_transform * vec4(finalPosition,0.,1.)).xy;\n  float scale = sqrt(u_transform[0][0] * u_transform[0][0] + u_transform[1][1] * u_transform[1][1]);\n  gl_Position = vec4(transformedPos, 1.0 - lifePercent, 1.); // use life percent to sort z\n  gl_PointSize = mix(startSize, endSize, 1.0 - lifePercent) * scale;\n}");

/***/ }),

/***/ "./Graphics/Context/point-renderer/point-fragment.glsl":
/*!*************************************************************!*\
  !*** ./Graphics/Context/point-renderer/point-fragment.glsl ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\n\nprecision mediump float;\nin lowp vec4 v_color;\n\nout vec4 fragColor;\n\nvoid main() {\n  float r = 0.0, delta = 0.0, alpha = 1.0;\n  vec2 cxy = 2.0 * gl_PointCoord - 1.0;\n  r = dot(cxy, cxy);\n\n  delta = fwidth(r);\n  alpha = 1.0 - smoothstep(1.0 - delta, 1.0 + delta, r);\n  // \"premultiply\" the color by alpha\n  vec4 color = v_color;\n  color.a = color.a * alpha;\n  color.rgb = color.rgb * color.a;\n  fragColor = color;\n}");

/***/ }),

/***/ "./Graphics/Context/point-renderer/point-renderer.ts":
/*!***********************************************************!*\
  !*** ./Graphics/Context/point-renderer/point-renderer.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PointRenderer: () => (/* binding */ PointRenderer)
/* harmony export */ });
/* harmony import */ var _point_vertex_glsl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./point-vertex.glsl */ "./Graphics/Context/point-renderer/point-vertex.glsl");
/* harmony import */ var _point_fragment_glsl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./point-fragment.glsl */ "./Graphics/Context/point-renderer/point-fragment.glsl");
/* harmony import */ var _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../ExcaliburGraphicsContextWebGL */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");
/* harmony import */ var _shader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../shader */ "./Graphics/Context/shader.ts");
/* harmony import */ var _vertex_buffer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../vertex-buffer */ "./Graphics/Context/vertex-buffer.ts");
/* harmony import */ var _vertex_layout__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vertex-layout */ "./Graphics/Context/vertex-layout.ts");
/* harmony import */ var _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../GraphicsDiagnostics */ "./Graphics/GraphicsDiagnostics.ts");







class PointRenderer {
    constructor() {
        this.type = 'ex.point';
        this.priority = 0;
        this._maxPoints = 10922;
        this._pointCount = 0;
        this._vertexIndex = 0;
    }
    initialize(gl, context) {
        this._gl = gl;
        this._context = context;
        this._shader = new _shader__WEBPACK_IMPORTED_MODULE_0__.Shader({
            graphicsContext: context,
            vertexSource: _point_vertex_glsl__WEBPACK_IMPORTED_MODULE_1__["default"],
            fragmentSource: _point_fragment_glsl__WEBPACK_IMPORTED_MODULE_2__["default"]
        });
        this._shader.compile();
        this._shader.use();
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
        this._buffer = new _vertex_buffer__WEBPACK_IMPORTED_MODULE_3__.VertexBuffer({
            gl,
            size: 7 * this._maxPoints,
            type: 'dynamic'
        });
        this._layout = new _vertex_layout__WEBPACK_IMPORTED_MODULE_4__.VertexLayout({
            gl,
            shader: this._shader,
            vertexBuffer: this._buffer,
            attributes: [
                ['a_position', 2],
                ['a_color', 4],
                ['a_size', 1]
            ]
        });
    }
    dispose() {
        this._buffer.dispose();
        this._shader.dispose();
        this._context = null;
        this._gl = null;
    }
    draw(point, color, size) {
        // Force a render if the batch is full
        if (this._isFull()) {
            this.flush();
        }
        this._pointCount++;
        const transform = this._context.getTransform();
        const opacity = this._context.opacity;
        const snapToPixel = this._context.snapToPixel;
        const finalPoint = transform.multiply(point);
        if (snapToPixel) {
            finalPoint.x = ~~(finalPoint.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_5__.pixelSnapEpsilon);
            finalPoint.y = ~~(finalPoint.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_5__.pixelSnapEpsilon);
        }
        const vertexBuffer = this._buffer.bufferData;
        vertexBuffer[this._vertexIndex++] = finalPoint.x;
        vertexBuffer[this._vertexIndex++] = finalPoint.y;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a * opacity;
        vertexBuffer[this._vertexIndex++] = size * Math.max(transform.getScaleX(), transform.getScaleY());
    }
    _isFull() {
        if (this._pointCount >= this._maxPoints) {
            return true;
        }
        return false;
    }
    hasPendingDraws() {
        return this._pointCount !== 0;
    }
    flush() {
        // nothing to draw early exit
        if (this._pointCount === 0) {
            return;
        }
        const gl = this._gl;
        this._shader.use();
        this._layout.use(true);
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
        gl.drawArrays(gl.POINTS, 0, this._pointCount);
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_6__.GraphicsDiagnostics.DrawnImagesCount += this._pointCount;
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_6__.GraphicsDiagnostics.DrawCallCount++;
        this._pointCount = 0;
        this._vertexIndex = 0;
    }
}


/***/ }),

/***/ "./Graphics/Context/point-renderer/point-vertex.glsl":
/*!***********************************************************!*\
  !*** ./Graphics/Context/point-renderer/point-vertex.glsl ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nin vec2 a_position;\nin vec4 a_color;\nin float a_size;\nout lowp vec4 v_color;\nuniform mat4 u_matrix;\n\nvoid main() {\n  gl_Position = u_matrix * vec4(a_position, 0.0, 1.0);\n  gl_PointSize = a_size * 2.0;\n  v_color = a_color;\n}");

/***/ }),

/***/ "./Graphics/Context/quad-index-buffer.ts":
/*!***********************************************!*\
  !*** ./Graphics/Context/quad-index-buffer.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   QuadIndexBuffer: () => (/* binding */ QuadIndexBuffer)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../.. */ "./Util/Log.ts");

/**
 * Helper that defines and index buffer for quad geometry
 *
 * Index buffers allow you to save space in vertex buffers when you share vertices in geometry
 * it is almost always worth it in terms of performance to use an index buffer.
 */
class QuadIndexBuffer {
    /**
     * @param gl WebGL2RenderingContext this layout will be attached to, these cannot be reused across contexts.
     * @param numberOfQuads Specify the max number of quads you want to draw
     * @param useUint16 Optionally force a uint16 buffer
     */
    constructor(gl, numberOfQuads, useUint16) {
        this._logger = ___WEBPACK_IMPORTED_MODULE_0__.Logger.getInstance();
        this._gl = gl;
        this.buffer = gl.createBuffer();
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this.buffer);
        const totalVertices = numberOfQuads * 6;
        if (!useUint16) {
            this.bufferData = new Uint32Array(totalVertices);
        }
        else {
            // fall back to using gl.UNSIGNED_SHORT or tell the user they are out of luck
            const maxUint16 = 65535;
            const maxUint16Index = Math.floor((maxUint16 - 1) / 4); // max quads
            this.bufferGlType = gl.UNSIGNED_SHORT;
            this.bufferData = new Uint16Array(totalVertices);
            // TODO Should we error if this happens?? maybe not might crash mid game
            if (numberOfQuads > maxUint16Index) {
                this._logger.warn(`Total quads exceeds hardware index buffer limit (uint16), max(${maxUint16Index}) requested quads(${numberOfQuads})`);
            }
        }
        let currentQuad = 0;
        for (let i = 0; i < totalVertices; i += 6) {
            // first triangle
            this.bufferData[i + 0] = currentQuad + 0;
            this.bufferData[i + 1] = currentQuad + 1;
            this.bufferData[i + 2] = currentQuad + 2;
            // second triangle
            this.bufferData[i + 3] = currentQuad + 2;
            this.bufferData[i + 4] = currentQuad + 1;
            this.bufferData[i + 5] = currentQuad + 3;
            currentQuad += 4;
        }
        gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, this.bufferData, gl.STATIC_DRAW);
    }
    get size() {
        return this.bufferData.length;
    }
    /**
     * Upload data to the GPU
     */
    upload() {
        const gl = this._gl;
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this.buffer);
        gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, this.bufferData, gl.STATIC_DRAW);
    }
    /**
     * Bind this index buffer
     */
    bind() {
        const gl = this._gl;
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this.buffer);
    }
    dispose() {
        const gl = this._gl;
        gl.deleteBuffer(this.buffer);
        this._gl = null;
    }
}


/***/ }),

/***/ "./Graphics/Context/rectangle-renderer/rectangle-renderer.frag.glsl":
/*!**************************************************************************!*\
  !*** ./Graphics/Context/rectangle-renderer/rectangle-renderer.frag.glsl ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\n\nprecision mediump float;\n\n// UV coord\nin vec2 v_uv;\n\nin vec2 v_size; // in pixels\n\n// Color coord to blend with image\nin lowp vec4 v_color;\n\n// Stroke color if used\nin lowp vec4 v_strokeColor;\n\n// Stroke thickness if used\nin lowp float v_strokeThickness; // in pixels\n\n// Opacity\nin float v_opacity;\n\nout vec4 fragColor;\n\nvoid main() {\n    // modified from https://stackoverflow.com/questions/59197671/glsl-rounded-rectangle-with-variable-border\n    vec2 uv = v_uv;\n    vec2 fragCoord = uv * v_size;\n    float maxX = v_size.x - v_strokeThickness;\n    float minX = v_strokeThickness;\n    float maxY = v_size.y - v_strokeThickness;\n    float minY = v_strokeThickness;\n\n    if (fragCoord.x < maxX && fragCoord.x > minX &&\n        fragCoord.y < maxY && fragCoord.y > minY) {\n      fragColor = v_color;\n    } else {\n      fragColor = v_strokeColor;\n    }\n    fragColor.a *= v_opacity;\n    fragColor.rgb *= fragColor.a;\n\n    // vec2 v2CenteredPos     = abs(fragCoord - v_size.xy / 2.0);\n    // vec2 v2HalfShapeSizePx = v_size.xy/2.0 - v_strokeThickness/2.0;\n\n    // float fHalfBorderDist      = 0.0;\n    // float fHalfBorderThickness = 0.0;\n\n    // if (fragCoord.x > max(v_radius, v_strokeThickness) && \n    //     fragCoord.x < v_size.x - max(v_radius, v_strokeThickness))\n    // {\n    //     fHalfBorderDist      = v2CenteredPos.y - v2HalfShapeSizePx.y;\n    //     fHalfBorderThickness = v_strokeThickness / 2.0;\n    // }\n    // else if (fragCoord.y > max(v_radius, v_strokeThickness) && \n    //          fragCoord.y < v_size.y - max(v_radius, v_strokeThickness))\n    // {\n    //     fHalfBorderDist      = v2CenteredPos.x - v2HalfShapeSizePx.x;\n    //     fHalfBorderThickness = v_strokeThickness / 2.0;\n    // }\n    // else\n    // {\n    //     vec2 edgeVec = max(vec2(0.0), v_radius - vec2(\n    //         uv.x > 0.5 ? v_size.x - fragCoord.x : fragCoord.x,\n    //         uv.y > 0.5 ? v_size.y - fragCoord.y : fragCoord.y));\n        \n    //     float ellipse_ab    = v_radius-v_strokeThickness;\n    //     vec2 ellipse_isect = (v_strokeThickness > v_radius || v_strokeThickness > v_radius) ? vec2(0.0) :\n    //                             edgeVec.xy * ellipse_ab*ellipse_ab / length(ellipse_ab*edgeVec.yx); \n            \n    //     fHalfBorderThickness = (v_radius - length(ellipse_isect)) / 2.0;\n    //     fHalfBorderDist      = length(edgeVec) - (v_radius - fHalfBorderThickness);\n    // }\n\n    // vec4 v4FromColor = v_strokeColor;\n    // v4FromColor.rgb *= v4FromColor.a;\n    // vec4 v4ToColor   = vec4(0.0); // background color is transparent\n    // if (fHalfBorderDist < 0.0) {\n    //     v4ToColor = v_color;\n    //     v4ToColor.rgb *= v4ToColor.a;\n    // }\n\n    // float mixPct = abs(fHalfBorderDist) - fHalfBorderThickness;\n\n    // vec4 finalColor = mix(v4FromColor, v4ToColor, mixPct);\n    // gl_FragColor = finalColor;\n}");

/***/ }),

/***/ "./Graphics/Context/rectangle-renderer/rectangle-renderer.ts":
/*!*******************************************************************!*\
  !*** ./Graphics/Context/rectangle-renderer/rectangle-renderer.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RectangleRenderer: () => (/* binding */ RectangleRenderer)
/* harmony export */ });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../Color */ "./Color.ts");
/* harmony import */ var _Math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Math/vector */ "./Math/vector.ts");
/* harmony import */ var _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../GraphicsDiagnostics */ "./Graphics/GraphicsDiagnostics.ts");
/* harmony import */ var _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ExcaliburGraphicsContextWebGL */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");
/* harmony import */ var _quad_index_buffer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../quad-index-buffer */ "./Graphics/Context/quad-index-buffer.ts");
/* harmony import */ var _shader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../shader */ "./Graphics/Context/shader.ts");
/* harmony import */ var _vertex_buffer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../vertex-buffer */ "./Graphics/Context/vertex-buffer.ts");
/* harmony import */ var _vertex_layout__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../vertex-layout */ "./Graphics/Context/vertex-layout.ts");
/* harmony import */ var _rectangle_renderer_frag_glsl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./rectangle-renderer.frag.glsl */ "./Graphics/Context/rectangle-renderer/rectangle-renderer.frag.glsl");
/* harmony import */ var _rectangle_renderer_vert_glsl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./rectangle-renderer.vert.glsl */ "./Graphics/Context/rectangle-renderer/rectangle-renderer.vert.glsl");










class RectangleRenderer {
    constructor() {
        this.type = 'ex.rectangle';
        this.priority = 0;
        this._maxRectangles = 10922; // max(uint16) / 6 verts
        this._rectangleCount = 0;
        this._vertexIndex = 0;
        this._transparent = _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Transparent;
        this._scratch1 = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(0, 0);
        this._scratch2 = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(0, 0);
        this._scratch3 = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(0, 0);
        this._scratch4 = (0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(0, 0);
    }
    initialize(gl, context) {
        this._gl = gl;
        this._context = context;
        // https://stackoverflow.com/questions/59197671/glsl-rounded-rectangle-with-variable-border
        this._shader = new _shader__WEBPACK_IMPORTED_MODULE_2__.Shader({
            graphicsContext: context,
            fragmentSource: _rectangle_renderer_frag_glsl__WEBPACK_IMPORTED_MODULE_3__["default"],
            vertexSource: _rectangle_renderer_vert_glsl__WEBPACK_IMPORTED_MODULE_4__["default"]
        });
        this._shader.compile();
        // setup uniforms
        this._shader.use();
        this._shader.setUniformMatrix('u_matrix', context.ortho);
        this._buffer = new _vertex_buffer__WEBPACK_IMPORTED_MODULE_5__.VertexBuffer({
            gl,
            size: 16 * 4 * this._maxRectangles,
            type: 'dynamic'
        });
        this._layout = new _vertex_layout__WEBPACK_IMPORTED_MODULE_6__.VertexLayout({
            gl,
            shader: this._shader,
            vertexBuffer: this._buffer,
            attributes: [
                ['a_position', 2],
                ['a_uv', 2],
                ['a_size', 2],
                ['a_opacity', 1],
                ['a_color', 4],
                ['a_strokeColor', 4],
                ['a_strokeThickness', 1]
            ]
        });
        this._quads = new _quad_index_buffer__WEBPACK_IMPORTED_MODULE_7__.QuadIndexBuffer(gl, this._maxRectangles, true);
    }
    dispose() {
        this._buffer.dispose();
        this._quads.dispose();
        this._shader.dispose();
        this._context = null;
        this._gl = null;
    }
    _isFull() {
        if (this._rectangleCount >= this._maxRectangles) {
            return true;
        }
        return false;
    }
    draw(...args) {
        if (args[0] instanceof _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector && args[1] instanceof _Math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector) {
            this.drawLine.apply(this, args);
        }
        else {
            this.drawRectangle.apply(this, args);
        }
    }
    drawLine(start, end, color, thickness = 1) {
        if (this._isFull()) {
            this.flush();
        }
        this._rectangleCount++;
        // transform based on current context
        const transform = this._context.getTransform();
        const opacity = this._context.opacity;
        const snapToPixel = this._context.snapToPixel;
        const dir = end.sub(start);
        const length = dir.magnitude;
        const normal = dir.normalize().perpendicular();
        const halfThick = thickness / 2;
        /**
         *    +---------------------^----------------------+
         *    |                     | (normal)             |
         *   (startX, startY)------------------>(endX, endY)
         *    |                                            |
         *    + -------------------------------------------+
         */
        const startTop = transform.multiply(normal.scale(halfThick, this._scratch1).add(start, this._scratch1), this._scratch1);
        const startBottom = transform.multiply(normal.scale(-halfThick, this._scratch2).add(start, this._scratch2), this._scratch2);
        const endTop = transform.multiply(normal.scale(halfThick, this._scratch3).add(end, this._scratch3), this._scratch3);
        const endBottom = transform.multiply(normal.scale(-halfThick, this._scratch4).add(end, this._scratch4), this._scratch4);
        if (snapToPixel) {
            startTop.x = ~~(startTop.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            startTop.y = ~~(startTop.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            endTop.x = ~~(endTop.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            endTop.y = ~~(endTop.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            startBottom.x = ~~(startBottom.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            startBottom.y = ~~(startBottom.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            endBottom.x = ~~(endBottom.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            endBottom.y = ~~(endBottom.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
        }
        // TODO uv could be static vertex buffer
        const uvx0 = 0;
        const uvy0 = 0;
        const uvx1 = 1;
        const uvy1 = 1;
        const stroke = this._transparent;
        const strokeThickness = 0;
        const width = 1;
        // update data
        const vertexBuffer = this._layout.vertexBuffer.bufferData;
        // (0, 0) - 0
        vertexBuffer[this._vertexIndex++] = startTop.x;
        vertexBuffer[this._vertexIndex++] = startTop.y;
        vertexBuffer[this._vertexIndex++] = uvx0;
        vertexBuffer[this._vertexIndex++] = uvy0;
        vertexBuffer[this._vertexIndex++] = length;
        vertexBuffer[this._vertexIndex++] = thickness;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness / width;
        // (0, 1) - 1
        vertexBuffer[this._vertexIndex++] = startBottom.x;
        vertexBuffer[this._vertexIndex++] = startBottom.y;
        vertexBuffer[this._vertexIndex++] = uvx0;
        vertexBuffer[this._vertexIndex++] = uvy1;
        vertexBuffer[this._vertexIndex++] = length;
        vertexBuffer[this._vertexIndex++] = thickness;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness / width;
        // (1, 0) - 2
        vertexBuffer[this._vertexIndex++] = endTop.x;
        vertexBuffer[this._vertexIndex++] = endTop.y;
        vertexBuffer[this._vertexIndex++] = uvx1;
        vertexBuffer[this._vertexIndex++] = uvy0;
        vertexBuffer[this._vertexIndex++] = length;
        vertexBuffer[this._vertexIndex++] = thickness;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness / width;
        // (1, 1) - 3
        vertexBuffer[this._vertexIndex++] = endBottom.x;
        vertexBuffer[this._vertexIndex++] = endBottom.y;
        vertexBuffer[this._vertexIndex++] = uvx1;
        vertexBuffer[this._vertexIndex++] = uvy1;
        vertexBuffer[this._vertexIndex++] = length;
        vertexBuffer[this._vertexIndex++] = thickness;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness / width;
    }
    drawRectangle(pos, width, height, color, stroke = _Color__WEBPACK_IMPORTED_MODULE_0__.Color.Transparent, strokeThickness = 0) {
        if (this._isFull()) {
            this.flush();
        }
        this._rectangleCount++;
        // transform based on current context
        const transform = this._context.getTransform();
        const opacity = this._context.opacity;
        const snapToPixel = this._context.snapToPixel;
        const topLeft = transform.multiply(pos.add((0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(0, 0)));
        const topRight = transform.multiply(pos.add((0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(width, 0)));
        const bottomRight = transform.multiply(pos.add((0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(width, height)));
        const bottomLeft = transform.multiply(pos.add((0,_Math_vector__WEBPACK_IMPORTED_MODULE_1__.vec)(0, height)));
        if (snapToPixel) {
            topLeft.x = ~~(topLeft.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            topLeft.y = ~~(topLeft.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            topRight.x = ~~(topRight.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            topRight.y = ~~(topRight.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            bottomLeft.x = ~~(bottomLeft.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            bottomLeft.y = ~~(bottomLeft.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            bottomRight.x = ~~(bottomRight.x + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
            bottomRight.y = ~~(bottomRight.y + _ExcaliburGraphicsContextWebGL__WEBPACK_IMPORTED_MODULE_8__.pixelSnapEpsilon);
        }
        // TODO uv could be static vertex buffer
        const uvx0 = 0;
        const uvy0 = 0;
        const uvx1 = 1;
        const uvy1 = 1;
        // update data
        const vertexBuffer = this._layout.vertexBuffer.bufferData;
        // (0, 0) - 0
        vertexBuffer[this._vertexIndex++] = topLeft.x;
        vertexBuffer[this._vertexIndex++] = topLeft.y;
        vertexBuffer[this._vertexIndex++] = uvx0;
        vertexBuffer[this._vertexIndex++] = uvy0;
        vertexBuffer[this._vertexIndex++] = width;
        vertexBuffer[this._vertexIndex++] = height;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness;
        // (0, 1) - 1
        vertexBuffer[this._vertexIndex++] = bottomLeft.x;
        vertexBuffer[this._vertexIndex++] = bottomLeft.y;
        vertexBuffer[this._vertexIndex++] = uvx0;
        vertexBuffer[this._vertexIndex++] = uvy1;
        vertexBuffer[this._vertexIndex++] = width;
        vertexBuffer[this._vertexIndex++] = height;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness;
        // (1, 0) - 2
        vertexBuffer[this._vertexIndex++] = topRight.x;
        vertexBuffer[this._vertexIndex++] = topRight.y;
        vertexBuffer[this._vertexIndex++] = uvx1;
        vertexBuffer[this._vertexIndex++] = uvy0;
        vertexBuffer[this._vertexIndex++] = width;
        vertexBuffer[this._vertexIndex++] = height;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness;
        // (1, 1) - 3
        vertexBuffer[this._vertexIndex++] = bottomRight.x;
        vertexBuffer[this._vertexIndex++] = bottomRight.y;
        vertexBuffer[this._vertexIndex++] = uvx1;
        vertexBuffer[this._vertexIndex++] = uvy1;
        vertexBuffer[this._vertexIndex++] = width;
        vertexBuffer[this._vertexIndex++] = height;
        vertexBuffer[this._vertexIndex++] = opacity;
        vertexBuffer[this._vertexIndex++] = color.r / 255;
        vertexBuffer[this._vertexIndex++] = color.g / 255;
        vertexBuffer[this._vertexIndex++] = color.b / 255;
        vertexBuffer[this._vertexIndex++] = color.a;
        vertexBuffer[this._vertexIndex++] = stroke.r / 255;
        vertexBuffer[this._vertexIndex++] = stroke.g / 255;
        vertexBuffer[this._vertexIndex++] = stroke.b / 255;
        vertexBuffer[this._vertexIndex++] = stroke.a;
        vertexBuffer[this._vertexIndex++] = strokeThickness;
    }
    hasPendingDraws() {
        return this._rectangleCount !== 0;
    }
    flush() {
        // nothing to draw early exit
        if (this._rectangleCount === 0) {
            return;
        }
        const gl = this._gl;
        // Bind the shader
        this._shader.use();
        // Bind the memory layout and upload data
        this._layout.use(true);
        // Update ortho matrix uniform
        this._shader.setUniformMatrix('u_matrix', this._context.ortho);
        // Bind index buffer
        this._quads.bind();
        // Draw all the quads
        gl.drawElements(gl.TRIANGLES, this._rectangleCount * 6, this._quads.bufferGlType, 0);
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_9__.GraphicsDiagnostics.DrawnImagesCount += this._rectangleCount;
        _GraphicsDiagnostics__WEBPACK_IMPORTED_MODULE_9__.GraphicsDiagnostics.DrawCallCount++;
        // Reset
        this._rectangleCount = 0;
        this._vertexIndex = 0;
    }
}


/***/ }),

/***/ "./Graphics/Context/rectangle-renderer/rectangle-renderer.vert.glsl":
/*!**************************************************************************!*\
  !*** ./Graphics/Context/rectangle-renderer/rectangle-renderer.vert.glsl ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nin vec2 a_position;\n\n// UV coordinate\nin vec2 a_uv;\nout vec2 v_uv;\n\nin vec2 a_size;\nout vec2 v_size;\n\n// Opacity \nin float a_opacity;\nout float v_opacity;\n\nin vec4 a_color;\nout vec4 v_color;\n\nin vec4 a_strokeColor;\nout vec4 v_strokeColor;\n\nin float a_strokeThickness;\nout float v_strokeThickness;\n\nuniform mat4 u_matrix;\n\n\nvoid main() {\n   // Set the vertex position using the ortho transform matrix\n   gl_Position = u_matrix * vec4(a_position, 0.0, 1.0);\n\n   // Pass through UV coords\n   v_uv = a_uv;\n   // Pass through size\n   v_size = a_size;\n   // Pass through the Opacity to the fragment shader\n   v_opacity = a_opacity;\n   // Pass through the color to the fragment shader\n   v_color = a_color;\n   // Pass through the stroke color to the fragment shader\n   v_strokeColor = a_strokeColor;\n   // Pass through the stroke thickenss to the fragment shader\n   v_strokeThickness = a_strokeThickness;\n}");

/***/ }),

/***/ "./Graphics/Context/render-source.ts":
/*!*******************************************!*\
  !*** ./Graphics/Context/render-source.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RenderSource: () => (/* binding */ RenderSource)
/* harmony export */ });
class RenderSource {
    constructor(_gl, _texture) {
        this._gl = _gl;
        this._texture = _texture;
    }
    use() {
        const gl = this._gl;
        gl.activeTexture(gl.TEXTURE0);
        gl.bindTexture(gl.TEXTURE_2D, this._texture);
    }
    disable() {
        const gl = this._gl;
        gl.bindTexture(gl.TEXTURE_2D, null);
    }
}


/***/ }),

/***/ "./Graphics/Context/render-target.ts":
/*!*******************************************!*\
  !*** ./Graphics/Context/render-target.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RenderTarget: () => (/* binding */ RenderTarget)
/* harmony export */ });
/* harmony import */ var _render_source__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./render-source */ "./Graphics/Context/render-source.ts");

class RenderTarget {
    constructor(options) {
        var _a, _b;
        this.antialias = false;
        this.samples = 1;
        this._gl = options.gl;
        this.width = options.width;
        this.height = options.height;
        this.transparency = options.transparency;
        this.antialias = (_a = options.antialias) !== null && _a !== void 0 ? _a : this.antialias;
        this.samples = (_b = options.samples) !== null && _b !== void 0 ? _b : this._gl.getParameter(this._gl.MAX_SAMPLES);
        const gl = this._gl;
        // Determine current context format for blitting later needs to match
        if (gl.drawingBufferFormat) {
            this.bufferFormat = gl.drawingBufferFormat;
        }
        else {
            // Documented in webgl spec
            // https://registry.khronos.org/webgl/specs/latest/1.0/
            if (this.transparency) {
                this.bufferFormat = gl.RGBA8;
            }
            else {
                this.bufferFormat = gl.RGB8;
            }
        }
        this._setupRenderBuffer();
        this._setupFramebuffer();
    }
    setResolution(width, height) {
        const gl = this._gl;
        this.width = width;
        this.height = height;
        // update backing texture size
        gl.bindTexture(gl.TEXTURE_2D, this._frameTexture);
        gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, this.width, this.height, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);
        // update render buffer size
        if (this._renderBuffer) {
            gl.bindRenderbuffer(gl.RENDERBUFFER, this._renderBuffer);
            gl.renderbufferStorageMultisample(gl.RENDERBUFFER, Math.min(this.samples, gl.getParameter(gl.MAX_SAMPLES)), this.bufferFormat, this.width, this.height);
        }
    }
    get renderBuffer() {
        return this._renderBuffer;
    }
    get renderFrameBuffer() {
        return this._renderFrameBuffer;
    }
    get frameBuffer() {
        return this._frameBuffer;
    }
    get frameTexture() {
        return this._frameTexture;
    }
    _setupRenderBuffer() {
        if (this.antialias) {
            const gl = this._gl;
            // Render buffers can be used as an input to a shader
            this._renderBuffer = gl.createRenderbuffer();
            this._renderFrameBuffer = gl.createFramebuffer();
            gl.bindRenderbuffer(gl.RENDERBUFFER, this._renderBuffer);
            gl.renderbufferStorageMultisample(gl.RENDERBUFFER, Math.min(this.samples, gl.getParameter(gl.MAX_SAMPLES)), this.bufferFormat, this.width, this.height);
            gl.bindFramebuffer(gl.FRAMEBUFFER, this._renderFrameBuffer);
            gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.RENDERBUFFER, this._renderBuffer);
        }
    }
    _setupFramebuffer() {
        // Allocates frame buffer
        const gl = this._gl;
        this._frameTexture = gl.createTexture();
        gl.bindTexture(gl.TEXTURE_2D, this._frameTexture);
        gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, this.width, this.height, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);
        // set the filtering so we don't need mips
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
        // attach the texture as the first color attachment
        const attachmentPoint = gl.COLOR_ATTACHMENT0;
        // After this bind all draw calls will draw to this framebuffer texture
        this._frameBuffer = gl.createFramebuffer();
        gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
        gl.framebufferTexture2D(gl.FRAMEBUFFER, attachmentPoint, gl.TEXTURE_2D, this._frameTexture, 0);
        // Reset after initialized
        this.disable();
    }
    toRenderSource() {
        if (this.renderBuffer) {
            this.blitRenderBufferToFrameBuffer();
        }
        const source = new _render_source__WEBPACK_IMPORTED_MODULE_0__.RenderSource(this._gl, this._frameTexture);
        return source;
    }
    blitToScreen() {
        const gl = this._gl;
        // set to size of canvas's drawingBuffer
        if (this._renderBuffer) {
            gl.bindFramebuffer(gl.READ_FRAMEBUFFER, this.renderFrameBuffer);
            gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, null);
            gl.clearBufferfv(gl.COLOR, 0, [0.0, 0.0, 1.0, 1.0]);
            gl.blitFramebuffer(0, 0, this.width, this.height, 0, 0, this.width, this.height, gl.COLOR_BUFFER_BIT, gl.LINEAR);
        }
        else {
            gl.bindFramebuffer(gl.READ_FRAMEBUFFER, this.frameBuffer);
            gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, null);
            gl.clearBufferfv(gl.COLOR, 0, [0.0, 0.0, 1.0, 1.0]);
            gl.blitFramebuffer(0, 0, this.width, this.height, 0, 0, this.width, this.height, gl.COLOR_BUFFER_BIT, gl.LINEAR);
        }
    }
    blitRenderBufferToFrameBuffer() {
        if (this._renderBuffer) {
            const gl = this._gl;
            gl.bindFramebuffer(gl.READ_FRAMEBUFFER, this.renderFrameBuffer);
            gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, this.frameBuffer);
            gl.clearBufferfv(gl.COLOR, 0, [0.0, 0.0, 1.0, 1.0]);
            gl.blitFramebuffer(0, 0, this.width, this.height, 0, 0, this.width, this.height, gl.COLOR_BUFFER_BIT, gl.LINEAR);
        }
    }
    copyToTexture(texture) {
        const gl = this._gl;
        if (this._renderBuffer) {
            this.blitRenderBufferToFrameBuffer();
        }
        gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
        gl.bindTexture(gl.TEXTURE_2D, texture);
        gl.copyTexImage2D(gl.TEXTURE_2D, 0, gl.RGBA, 0, 0, this.width, this.height, 0);
    }
    /**
     * When called, all drawing gets redirected to this render target
     */
    use() {
        const gl = this._gl;
        if (this.antialias) {
            gl.bindFramebuffer(gl.FRAMEBUFFER, this._renderFrameBuffer);
        }
        else {
            gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
        }
        // very important to set the viewport to the size of the framebuffer texture
        gl.viewport(0, 0, this.width, this.height);
    }
    /**
     * When called, all drawing is sent back to the canvas
     */
    disable() {
        const gl = this._gl;
        // passing null switches rendering back to the canvas
        gl.bindFramebuffer(gl.FRAMEBUFFER, null);
        gl.bindTexture(gl.TEXTURE_2D, null);
    }
}


/***/ }),

/***/ "./Graphics/Context/screen-pass-painter/screen-fragment.glsl":
/*!*******************************************************************!*\
  !*** ./Graphics/Context/screen-pass-painter/screen-fragment.glsl ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nprecision mediump float;\n\n// Passed in from the vertex shader.\nin vec2 v_texcoord;\n\n// The texture.\nuniform sampler2D u_texture;\n\nout vec4 fragColor;\n\nvoid main() {\n   fragColor = texture(u_texture, v_texcoord);\n}");

/***/ }),

/***/ "./Graphics/Context/screen-pass-painter/screen-pass-painter.ts":
/*!*********************************************************************!*\
  !*** ./Graphics/Context/screen-pass-painter/screen-pass-painter.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ScreenPassPainter: () => (/* binding */ ScreenPassPainter)
/* harmony export */ });
/* harmony import */ var _screen_vertex_glsl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./screen-vertex.glsl */ "./Graphics/Context/screen-pass-painter/screen-vertex.glsl");
/* harmony import */ var _screen_fragment_glsl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./screen-fragment.glsl */ "./Graphics/Context/screen-pass-painter/screen-fragment.glsl");
/* harmony import */ var _shader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../shader */ "./Graphics/Context/shader.ts");
/* harmony import */ var _vertex_buffer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../vertex-buffer */ "./Graphics/Context/vertex-buffer.ts");
/* harmony import */ var _vertex_layout__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vertex-layout */ "./Graphics/Context/vertex-layout.ts");





/**
 * This is responsible for painting the entire screen during the render passes
 */
class ScreenPassPainter {
    constructor(context) {
        const gl = context.__gl;
        this._gl = gl;
        this._shader = new _shader__WEBPACK_IMPORTED_MODULE_0__.Shader({
            graphicsContext: context,
            vertexSource: _screen_vertex_glsl__WEBPACK_IMPORTED_MODULE_1__["default"],
            fragmentSource: _screen_fragment_glsl__WEBPACK_IMPORTED_MODULE_2__["default"]
        });
        this._shader.compile();
        // Setup memory layout
        this._buffer = new _vertex_buffer__WEBPACK_IMPORTED_MODULE_3__.VertexBuffer({
            gl,
            type: 'static',
            // clip space quad + uv since we don't need a camera
            data: new Float32Array([
                -1, -1, 0, 0, -1, 1, 0, 1, 1, -1, 1, 0,
                1, -1, 1, 0, -1, 1, 0, 1, 1, 1, 1, 1
            ])
        });
        this._layout = new _vertex_layout__WEBPACK_IMPORTED_MODULE_4__.VertexLayout({
            gl,
            shader: this._shader,
            vertexBuffer: this._buffer,
            attributes: [
                ['a_position', 2],
                ['a_texcoord', 2]
            ]
        });
        this._buffer.upload();
    }
    renderWithPostProcessor(postprocessor) {
        const gl = this._gl;
        const shader = postprocessor.getShader();
        shader.use();
        postprocessor.getLayout().use();
        gl.activeTexture(gl.TEXTURE0);
        shader.trySetUniformInt('u_image', 0);
        if (postprocessor.onDraw) {
            postprocessor.onDraw();
        }
        gl.drawArrays(gl.TRIANGLES, 0, 6);
    }
    renderToScreen() {
        const gl = this._gl;
        this._shader.use();
        this._layout.use();
        gl.drawArrays(gl.TRIANGLES, 0, 6);
    }
}


/***/ }),

/***/ "./Graphics/Context/screen-pass-painter/screen-vertex.glsl":
/*!*****************************************************************!*\
  !*** ./Graphics/Context/screen-pass-painter/screen-vertex.glsl ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("#version 300 es\nin vec2 a_position;\n\nin vec2 a_texcoord;\nout vec2 v_texcoord;\n\nvoid main() {\n  gl_Position = vec4(a_position, 0.0, 1.0);\n\n  // Pass the texcoord to the fragment shader.\n  v_texcoord = a_texcoord;\n}");

/***/ }),

/***/ "./Graphics/Context/shader.ts":
/*!************************************!*\
  !*** ./Graphics/Context/shader.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Shader: () => (/* binding */ Shader),
/* harmony export */   glTypeToUniformTypeName: () => (/* binding */ glTypeToUniformTypeName)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../.. */ "./Util/Log.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../.. */ "./Graphics/Context/ExcaliburGraphicsContextWebGL.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../.. */ "./Math/vector.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../.. */ "./Color.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../.. */ "./Math/affine-matrix.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../.. */ "./Graphics/ImageSource.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../.. */ "./Graphics/Filtering.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../.. */ "./Graphics/Wrapping.ts");
/* harmony import */ var _Util_Watch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Util/Watch */ "./Util/Watch.ts");
/* harmony import */ var _uniform_buffer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./uniform-buffer */ "./Graphics/Context/uniform-buffer.ts");
/* harmony import */ var _webgl_util__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./webgl-util */ "./Graphics/Context/webgl-util.ts");




/**
 *
 */
function glTypeToUniformTypeName(gl, glType) {
    switch (glType) {
        case gl.FLOAT: {
            return 'uniform1f';
        }
        case gl.FLOAT_VEC2: {
            return 'uniform2f';
        }
        case gl.FLOAT_VEC3: {
            return 'uniform3f';
        }
        case gl.FLOAT_VEC4: {
            return 'uniform4f';
        }
        case gl.INT: {
            return 'uniform1i';
        }
        case gl.INT_VEC2: {
            return 'uniform2i';
        }
        case gl.INT_VEC3: {
            return 'uniform3i';
        }
        case gl.INT_VEC4: {
            return 'uniform4i';
        }
        case gl.BOOL: {
            return 'uniform1i';
        }
        case gl.BOOL_VEC2: {
            return 'uniform2i';
        }
        case gl.BOOL_VEC3: {
            return 'uniform3i';
        }
        case gl.BOOL_VEC4: {
            return 'uniform4i';
        }
        case gl.FLOAT_MAT2: {
            return 'uniform1f';
        }
        case gl.FLOAT_MAT3: {
            return 'uniform1f';
        }
        case gl.FLOAT_MAT4: {
            return 'uniform1f';
        }
        case gl.SAMPLER_2D: {
            return 'uniform1f';
        }
        case gl.SAMPLER_CUBE: {
            return 'uniform1f';
        }
        case gl.UNSIGNED_INT: {
            return 'uniform1ui';
        }
        case gl.UNSIGNED_INT_VEC2: {
            return 'uniform2ui';
        }
        case gl.UNSIGNED_INT_VEC3: {
            return 'uniform3ui';
        }
        case gl.UNSIGNED_INT_VEC4: {
            return 'uniform4ui';
        }
        case gl.FLOAT_MAT2x3: {
            return 'uniformMatrix2x3fv';
        }
        case gl.FLOAT_MAT2x4: {
            return 'uniformMatrix2x4fv';
        }
        case gl.FLOAT_MAT3x2: {
            return 'uniformMatrix3x2fv';
        }
        case gl.FLOAT_MAT3x4: {
            return 'uniformMatrix3x4fv';
        }
        case gl.FLOAT_MAT4x2: {
            return 'uniformMatrix4x2fv';
        }
        case gl.FLOAT_MAT4x3: {
            return 'uniformMatrix4x3fv';
        }
        case gl.SAMPLER_2D_ARRAY: {
            return 'uniform1fv';
        }
        case gl.SAMPLER_2D_ARRAY_SHADOW: {
            return 'uniform1f';
        }
        case gl.SAMPLER_CUBE_SHADOW: {
            return 'uniform1f';
        }
        case gl.INT_SAMPLER_2D: {
            return 'uniform1f';
        }
        case gl.INT_SAMPLER_3D: {
            return 'uniform1f';
        }
        case gl.INT_SAMPLER_CUBE: {
            return 'uniform1f';
        }
        case gl.INT_SAMPLER_2D_ARRAY: {
            return 'uniform1f';
        }
        case gl.UNSIGNED_INT_SAMPLER_2D: {
            return 'uniform1ui';
        }
        default: {
            throw new Error(`Unknown uniform type: ${glType}`);
        }
    }
}
class Shader {
    /**
     * Flags uniforms need to be re-uploaded on the next call to .use()
     */
    flagUniformsDirty() {
        this._dirtyUniforms = true;
    }
    /**
     * Returns whether the shader is compiled
     */
    get compiled() {
        return this._compiled;
    }
    /**
     * Create a shader program in excalibur
     * @param options specify shader vertex and fragment source
     */
    constructor(options) {
        this.name = 'anonymous shader';
        this._logger = ___WEBPACK_IMPORTED_MODULE_0__.Logger.getInstance();
        this._textures = new Map();
        this.attributes = {};
        this._uniforms = {};
        this._uniformBuffers = {};
        this._compiled = false;
        this._dirtyUniforms = true;
        this._startingTextureSlot = 0;
        /**
         * Set uniforms key value pairs
         */
        this.uniforms = (0,_Util_Watch__WEBPACK_IMPORTED_MODULE_1__.watch)({}, () => this.flagUniformsDirty());
        /**
         * Set images to load into the shader as a sampler2d
         */
        this.images = {};
        const { name, graphicsContext, vertexSource, fragmentSource, onPreLink, onPostCompile, uniforms, images, startingTextureSlot } = options;
        this.name = name !== null && name !== void 0 ? name : this.name;
        if (!(graphicsContext instanceof ___WEBPACK_IMPORTED_MODULE_2__.ExcaliburGraphicsContextWebGL)) {
            throw new Error(`ExcaliburGraphicsContext provided to a shader ${this.name} must be WebGL`);
        }
        this._gl = graphicsContext.__gl;
        this._startingTextureSlot = startingTextureSlot !== null && startingTextureSlot !== void 0 ? startingTextureSlot : this._startingTextureSlot;
        this._maxTextureSlots = this._gl.getParameter(this._gl.MAX_TEXTURE_IMAGE_UNITS) - this._startingTextureSlot;
        this.vertexSource = vertexSource;
        this.fragmentSource = fragmentSource;
    