"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var TextXform = require('./text-xform');

var RichTextXform = require('./rich-text-xform');

var PhoneticTextXform = require('./phonetic-text-xform');

var BaseXform = require('../base-xform'); // <si>
//   <r></r><r></r>...
// </si>
// <si>
//   <t></t>
// </si>


var SharedStringXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(SharedStringXform, _BaseXform);

  function SharedStringXform(model) {
    var _this;

    _classCallCheck(this, SharedStringXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SharedStringXform).call(this));
    _this.model = model;
    _this.map = {
      r: new RichTextXform(),
      t: new TextXform(),
      rPh: new PhoneticTextXform()
    };
    return _this;
  }

  _createClass(SharedStringXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);

      if (model && model.hasOwnProperty('richText') && model.richText) {
        var r = this.map.r;
        model.richText.forEach(function (text) {
          r.render(xmlStream, text);
        });
      } else if (model !== undefined && model !== null) {
        this.map.t.render(xmlStream, model);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var name = node.name;

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (name === this.tag) {
        this.model = {};
        return true;
      }

      this.parser = this.map[name];

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          switch (name) {
            case 'r':
              {
                var rt = this.model.richText;

                if (!rt) {
                  rt = this.model.richText = [];
                }

                rt.push(this.parser.model);
                break;
              }

            case 't':
              this.model = this.parser.model;
              break;

            default:
              break;
          }

          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'si';
    }
  }]);

  return SharedStringXform;
}(BaseXform);

module.exports = SharedStringXform;
//# sourceMappingURL=shared-string-xform.js.map
