"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { return function () { var Super = _getPrototypeOf(Derived), result; if (_isNativeReflectConstruct()) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var TextXform = require('./text-xform');

var RichTextXform = require('./rich-text-xform');

var PhoneticTextXform = require('./phonetic-text-xform');

var BaseXform = require('../base-xform'); // <si>
//   <r></r><r></r>...
// </si>
// <si>
//   <t></t>
// </si>


var SharedStringXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(SharedStringXform, _BaseXform);

  var _super = _createSuper(SharedStringXform);

  function SharedStringXform(model) {
    var _this;

    _classCallCheck(this, SharedStringXform);

    _this = _super.call(this);
    _this.model = model;
    _this.map = {
      r: new RichTextXform(),
      t: new TextXform(),
      rPh: new PhoneticTextXform()
    };
    return _this;
  }

  _createClass(SharedStringXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      xmlStream.openNode(this.tag);

      if (model && model.hasOwnProperty('richText') && model.richText) {
        if (model.richText.length) {
          model.richText.forEach(function (text) {
            _this2.map.r.render(xmlStream, text);
          });
        } else {
          this.map.t.render(xmlStream, '');
        }
      } else if (model !== undefined && model !== null) {
        this.map.t.render(xmlStream, model);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var name = node.name;

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (name === this.tag) {
        this.model = {};
        return true;
      }

      this.parser = this.map[name];

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          switch (name) {
            case 'r':
              {
                var rt = this.model.richText;

                if (!rt) {
                  rt = this.model.richText = [];
                }

                rt.push(this.parser.model);
                break;
              }

            case 't':
              this.model = this.parser.model;
              break;

            default:
              break;
          }

          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'si';
    }
  }]);

  return SharedStringXform;
}(BaseXform);

module.exports = SharedStringXform;
//# sourceMappingURL=shared-string-xform.js.map
