# {%= name %} {%= badge("fury") %}

> {%= description %}

## Install
{%= include("install") %}

## Run benchmarks

```bash
node benchmark
```

## Run tests

```bash
npm test
```

## Usage

```js
var expand = require('{%= name %}');
```

Pass an array or list of strings:

```js
expand('{foo,bar}', '{baz,quux}');
// or
expand(['{foo,bar}', '{baz,quux}']);
// both yield => [ 'foo', 'bar', 'baz', 'quux' ];
```

Pass a function as the last argument to customize output:

```js
expand(['{a..e}', '{f..h}'], function (str) {
  return '_' + str;
});

//=> ['_a', '_b', '_c', '_d', '_e', '_f', '_g', '_h']
```

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue]({%= bugs.url %})

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}
