# expand-braces [![NPM version](https://badge.fury.io/js/expand-braces.svg)](http://badge.fury.io/js/expand-braces)

> Wrapper for [braces] to enable brace expansion for arrays of patterns.

## Install
#### Install with [npm](npmjs.org):

```bash
npm i expand-braces --save-dev
```

## Run benchmarks

```bash
node benchmark
```

## Run tests

```bash
npm test
```

## Usage

```js
var expand = require('expand-braces');
```

Pass an array or list of strings:

```js
expand('{foo,bar}', '{baz,quux}');
// or
expand(['{foo,bar}', '{baz,quux}']);
// both yield => [ 'foo', 'bar', 'baz', 'quux' ];
```

Pass a function as the last argument to customize output:

```js
expand(['{a..e}', '{f..h}'], function (str) {
  return '_' + str;
});

//=> ['_a', '_b', '_c', '_d', '_e', '_f', '_g', '_h']
```

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/expand-braces/issues)

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2014 Jon Schlinkert, contributors.  
Released under the MIT license

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on October 26, 2014._