# expand-brackets [![NPM version](https://badge.fury.io/js/expand-brackets.svg)](http://badge.fury.io/js/expand-brackets)

> Expand POSIX bracket expressions (character classes) in glob patterns.

## Install with [npm](npmjs.org)

```bash
npm i expand-brackets --save
```

## Usage

```js
var brackets = require('expand-brackets');

brackets('[![:lower:]]');
//=> '[^a-z]'
```

## .isMatch

Return true if the given string matches the bracket expression:

```js
brackets.isMatch('A', '[![:lower:]]');
//=> true

brackets.isMatch('a', '[![:lower:]]');
//=> false
```

## .makeRe

Make a regular expression from a bracket expression:

```js
brackets.makeRe('[![:lower:]]');
//=> /[^a-z]/
```

The following named POSIX bracket expressions are supported:

- `[:alnum:]`: Alphanumeric characters (`a-zA-Z0-9]`)
- `[:alpha:]`: Alphabetic characters (`a-zA-Z]`)
- `[:blank:]`: Space and tab (`[ t]`)
- `[:digit:]`: Digits (`[0-9]`)
- `[:lower:]`: Lowercase letters (`[a-z]`)
- `[:punct:]`: Punctuation and symbols. (`[!"#$%&'()*+, -./:;<=>?@ [\]^_``{|}~]`)
- `[:upper:]`: Uppercase letters (`[A-Z]`)
- `[:word:]`: Word characters (letters, numbers and underscores) (`[A-Za-z0-9_]`)
- `[:xdigit:]`: Hexadecimal digits (`[A-Fa-f0-9]`)

Collating sequences are not supported, and probably won't be.

## Run tests

Install dev dependencies:

```bash
npm i -d && npm test
```

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/expand-brackets/issues)

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2015 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb](https://github.com/assemble/verb) on February 11, 2015._
