# expand-tilde [![NPM version](https://badge.fury.io/js/expand-tilde.svg)](http://badge.fury.io/js/expand-tilde)

> Bash-like tilde expansion for node.js. Expands a leading tilde in a file path to the user home directory, or `~+` to the cwd.

## Install with [npm](npmjs.org)

```bash
npm i expand-tilde --save
```

See the [Bash documentation for Tilde Expansion][docs].

## Usage

```js
var expandTilde = require('expand-tilde');

expandTilde('~')
//=> '/Users/jonschlinkert'

expandTilde('~+')
//=> process.cwd()
```

## Run tests

Install dev dependencies:

```bash
npm i -d && npm test
```

## Related

- [braces](https://github.com/jonschlinkert/braces): Bash-like brace expansion for node.js
- [tildify](https://github.com/sindresorhus/tildify): converts file paths to tildes

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/expand-tilde/issues)

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2015 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb](https://github.com/assemble/verb) on January 21, 2015._

[docs]: https://www.gnu.org/software/bash/manual/html_node/Tilde-Expansion.html
