import { TOP, LEFT } from '../../constants';

export const stateProperties = [
  TOP,
  LEFT,
  'scaleX',
  'scaleY',
  'flipX',
  'flipY',
  'originX',
  'originY',
  'angle',
  'opacity',
  'globalCompositeOperation',
  'shadow',
  'visible',
  'skewX',
  'skewY',
];

export const cacheProperties = [
  'fill',
  'stroke',
  'strokeWidth',
  'strokeDashArray',
  'width',
  'height',
  'paintFirst',
  'strokeUniform',
  'strokeLineCap',
  'strokeDashOffset',
  'strokeLineJoin',
  'strokeMiterLimit',
  'backgroundColor',
  'clipPath',
];

export const fabricObjectDefaultValues = {
  originX: LEFT,
  originY: TOP,
  top: 0,
  left: 0,
  width: 0,
  height: 0,
  scaleX: 1,
  scaleY: 1,
  flipX: false,
  flipY: false,
  opacity: 1,
  angle: 0,
  skewX: 0,
  skewY: 0,
  cornerSize: 13,
  touchCornerSize: 24,
  transparentCorners: true,
  hoverCursor: null,
  moveCursor: null,
  padding: 0,
  borderColor: 'rgb(178,204,255)',
  borderDashArray: null,
  cornerColor: 'rgb(178,204,255)',
  cornerStrokeColor: '',
  cornerStyle: 'rect',
  cornerDashArray: null,
  centeredScaling: false,
  centeredRotation: true,
  fill: 'rgb(0,0,0)',
  fillRule: 'nonzero',
  globalCompositeOperation: 'source-over',
  backgroundColor: '',
  selectionBackgroundColor: '',
  stroke: null,
  strokeWidth: 1,
  strokeDashArray: null,
  strokeDashOffset: 0,
  strokeLineCap: 'butt',
  strokeLineJoin: 'miter',
  strokeMiterLimit: 4,
  shadow: null,
  borderOpacityWhenMoving: 0.4,
  borderScaleFactor: 1,
  minScaleLimit: 0,
  selectable: true,
  evented: true,
  visible: true,
  hasControls: true,
  hasBorders: true,
  perPixelTargetFind: false,
  includeDefaultValues: true,
  lockMovementX: false,
  lockMovementY: false,
  lockRotation: false,
  lockScalingX: false,
  lockScalingY: false,
  lockSkewingX: false,
  lockSkewingY: false,
  lockScalingFlip: false,
  excludeFromExport: false,
  objectCaching: true,
  noScaleCache: true,
  strokeUniform: false,
  dirty: true,
  paintFirst: 'fill',
  activeOn: 'down',
  colorProperties: ['fill', 'stroke', 'backgroundColor'],
  clipPath: undefined,
  inverted: false,
  absolutePositioned: false,
  FX_DURATION: 500,
} as const;
