# fast-isnumeric

The fast way to check if a JS object is numeric

### Install

```
npm install fast-isnumeric
```

### API

```js
var isNumeric = require('fast-isnumeric');

isNumeric(/* any JS object */);
```

### How fast

Run comparison on jsperf: http://jsperf.com/isnumeric-jquery-and-alternate/5

![](http://i.imgur.com/dczrlVE.png)

### Warning

Please look up the test cases in
[test.js](https://github.com/plotly/fast-isnumeric/blob/master/test.js) before
using this module.

Most importantly, `fast-isnumeric` returns false on number and string
constructors. That is, `isNumeric(new Number(1))` and `isNumeric(new
String('1'))` are **false**.

### Tests

Test locally with karma:

```
npm test
```

### Why?

In [plotly](https://plot.ly/)'s javascript graphing library
[plotly.js](https://plot.ly/javascript/) numerical objects must be accounted
for in numerous hot code paths. Inspired by Jon Schlinkert's
[is-number](https://github.com/jonschlinkert/is-number), `fast-isnumeric` is
significantly simplified and sped up by ignoring number and string constructors.

### Author

Alex Johnson | https://github.com/alexcjohnson

### License

Copyright (c) 2015 Alex Johnson Released under the MIT license.
