import { Operation } from './core';
export { applyOperation, applyPatch, applyReducer, getValueByPointer, Operation, validate, validator, OperationResult } from './core';
export { PatchError as JsonPatchError, _deepClone as deepClone, escapePathComponent, unescapePathComponent } from './helpers';
export interface Observer<T> {
    object: T;
    patches: Operation[];
    unobserve: () => void;
    callback: (patches: Operation[]) => void;
}
/**
 * Detach an observer from an object
 */
export declare function unobserve<T>(root: T, observer: Observer<T>): void;
/**
 * Observes changes made to an object, which can then be retrieved using generate
 */
export declare function observe<T>(obj: any, callback?: (patches: Operation[]) => void): Observer<T>;
/**
 * Generate an array of patches from an observer
 */
export declare function generate<T>(observer: Observer<T>): Operation[];
/**
 * Create an array of patches from the differences in two objects
 */
export declare function compare(tree1: any, tree2: any): Operation[];
