export declare type GenericIndexable<T> = {
    [key: number]: T;
    readonly length: number;
};
declare type TypedArray = Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Float32Array | Float64Array;
export declare type Indexable<T> = string | T[] | TypedArray | GenericIndexable<T>;
export interface Sliceable<T> extends GenericIndexable<T> {
    slice(start: number, end?: number): this;
}
declare type Vec4 = [number, number, number, number];
declare type Vec3 = [number, number, number];
declare type Comparator = (i: number, j: number) => boolean;
export declare function diff_core(i: number, N: number, j: number, M: number, eq: Comparator): IterableIterator<Vec4>;
export declare function diff<T extends Indexable<unknown>>(xs: T, ys: T, eq?: Comparator): IterableIterator<Vec4>;
export declare function lcs<T extends Indexable<unknown>>(xs: T, ys: T, eq?: Comparator): IterableIterator<Vec3>;
export declare function calcPatch<T, S extends Sliceable<T>>(xs: S, ys: S, eq?: Comparator): Generator<[number, number, S]>;
export declare function applyPatch<T, S extends Sliceable<T>>(xs: S, patch: Iterable<[number, number, S]>): Generator<S>;
export declare function calcSlices<T, S extends Sliceable<T>>(xs: S, ys: S, eq?: Comparator): Generator<[-1 | 0 | 1, S]>;
export {};
