(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@babel/runtime/regenerator'), require('@babel/runtime/helpers/asyncToGenerator'), require('@babel/runtime/helpers/toConsumableArray'), require('@babel/runtime/helpers/objectSpread'), require('lodash.get'), require('lodash.values'), require('lodash.kebabcase'), require('lodash.isempty'), require('@babel/runtime/helpers/slicedToArray'), require('@babel/runtime/helpers/possibleConstructorReturn'), require('@babel/runtime/helpers/getPrototypeOf'), require('@babel/runtime/helpers/inherits'), require('@babel/runtime/helpers/classCallCheck'), require('@babel/runtime/helpers/createClass')) :
  typeof define === 'function' && define.amd ? define(['exports', '@babel/runtime/regenerator', '@babel/runtime/helpers/asyncToGenerator', '@babel/runtime/helpers/toConsumableArray', '@babel/runtime/helpers/objectSpread', 'lodash.get', 'lodash.values', 'lodash.kebabcase', 'lodash.isempty', '@babel/runtime/helpers/slicedToArray', '@babel/runtime/helpers/possibleConstructorReturn', '@babel/runtime/helpers/getPrototypeOf', '@babel/runtime/helpers/inherits', '@babel/runtime/helpers/classCallCheck', '@babel/runtime/helpers/createClass'], factory) :
  (global = global || self, factory(global.ElDataTable = {}, global._regeneratorRuntime, global._asyncToGenerator, global._toConsumableArray, global._objectSpread, global._get, global._values, global._kebabcase, global._isEmpty, global._slicedToArray, global._possibleConstructorReturn, global._getPrototypeOf, global._inherits, global._classCallCheck, global._createClass));
}(this, function (exports, _regeneratorRuntime, _asyncToGenerator, _toConsumableArray, _objectSpread, _get, _values, _kebabcase, _isEmpty, _slicedToArray, _possibleConstructorReturn, _getPrototypeOf, _inherits, _classCallCheck, _createClass) { 'use strict';

  _regeneratorRuntime = _regeneratorRuntime && _regeneratorRuntime.hasOwnProperty('default') ? _regeneratorRuntime['default'] : _regeneratorRuntime;
  _asyncToGenerator = _asyncToGenerator && _asyncToGenerator.hasOwnProperty('default') ? _asyncToGenerator['default'] : _asyncToGenerator;
  _toConsumableArray = _toConsumableArray && _toConsumableArray.hasOwnProperty('default') ? _toConsumableArray['default'] : _toConsumableArray;
  _objectSpread = _objectSpread && _objectSpread.hasOwnProperty('default') ? _objectSpread['default'] : _objectSpread;
  _get = _get && _get.hasOwnProperty('default') ? _get['default'] : _get;
  _values = _values && _values.hasOwnProperty('default') ? _values['default'] : _values;
  _kebabcase = _kebabcase && _kebabcase.hasOwnProperty('default') ? _kebabcase['default'] : _kebabcase;
  _isEmpty = _isEmpty && _isEmpty.hasOwnProperty('default') ? _isEmpty['default'] : _isEmpty;
  _slicedToArray = _slicedToArray && _slicedToArray.hasOwnProperty('default') ? _slicedToArray['default'] : _slicedToArray;
  _possibleConstructorReturn = _possibleConstructorReturn && _possibleConstructorReturn.hasOwnProperty('default') ? _possibleConstructorReturn['default'] : _possibleConstructorReturn;
  _getPrototypeOf = _getPrototypeOf && _getPrototypeOf.hasOwnProperty('default') ? _getPrototypeOf['default'] : _getPrototypeOf;
  _inherits = _inherits && _inherits.hasOwnProperty('default') ? _inherits['default'] : _inherits;
  _classCallCheck = _classCallCheck && _classCallCheck.hasOwnProperty('default') ? _classCallCheck['default'] : _classCallCheck;
  _createClass = _createClass && _createClass.hasOwnProperty('default') ? _createClass['default'] : _createClass;

  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  var script = {
    data: function data() {
      return {
        style: {
          border: 'none',
          background: 'inherit',
          padding: '9px 0',
          color: '',
          pointerEvents: ''
        }
      };
    },
    watch: {
      '$attrs.disabled': 'fixHoverColor'
    },
    mounted: function mounted() {
      this.style.color = getComputedStyle(this.$el).color;
    },
    methods: {
      // 将 color 写到 style 里是为了覆盖 hover 效果
      fixHoverColor: function () {
        var _fixHoverColor = _asyncToGenerator(
        /*#__PURE__*/
        _regeneratorRuntime.mark(function _callee() {
          return _regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  this.style.color = '';
                  this.style.pointerEvents = 'none';
                  _context.next = 4;
                  return new Promise(function (r) {
                    return setTimeout(r, 300);
                  });

                case 4:
                  this.style.color = getComputedStyle(this.$el).color;
                  this.style.pointerEvents = '';

                case 6:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee, this);
        }));

        function fixHoverColor() {
          return _fixHoverColor.apply(this, arguments);
        }

        return fixHoverColor;
      }()
    }
  };

  function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier
  /* server only */
  , shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
    if (typeof shadowMode !== 'boolean') {
      createInjectorSSR = createInjector;
      createInjector = shadowMode;
      shadowMode = false;
    } // Vue.extend constructor export interop.


    var options = typeof script === 'function' ? script.options : script; // render functions

    if (template && template.render) {
      options.render = template.render;
      options.staticRenderFns = template.staticRenderFns;
      options._compiled = true; // functional template

      if (isFunctionalTemplate) {
        options.functional = true;
      }
    } // scopedId


    if (scopeId) {
      options._scopeId = scopeId;
    }

    var hook;

    if (moduleIdentifier) {
      // server build
      hook = function hook(context) {
        // 2.3 injection
        context = context || // cached call
        this.$vnode && this.$vnode.ssrContext || // stateful
        this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext; // functional
        // 2.2 with runInNewContext: true

        if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
          context = __VUE_SSR_CONTEXT__;
        } // inject component styles


        if (style) {
          style.call(this, createInjectorSSR(context));
        } // register component module identifier for async chunk inference


        if (context && context._registeredComponents) {
          context._registeredComponents.add(moduleIdentifier);
        }
      }; // used by ssr in case component is cached and beforeCreate
      // never gets called


      options._ssrRegister = hook;
    } else if (style) {
      hook = shadowMode ? function () {
        style.call(this, createInjectorShadow(this.$root.$options.shadowRoot));
      } : function (context) {
        style.call(this, createInjector(context));
      };
    }

    if (hook) {
      if (options.functional) {
        // register for functional component in vue file
        var originalRender = options.render;

        options.render = function renderWithStyleInjection(h, context) {
          hook.call(context);
          return originalRender(h, context);
        };
      } else {
        // inject component registration as beforeCreate hook
        var existing = options.beforeCreate;
        options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
      }
    }

    return script;
  }

  var normalizeComponent_1 = normalizeComponent;

  /* script */
  const __vue_script__ = script;

  /* template */
  var __vue_render__ = function() {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
      "el-button",
      _vm._g(
        _vm._b(
          {
            style: _vm.style,
            attrs: { type: _vm.$attrs.type || "primary", plain: "" }
          },
          "el-button",
          _vm.$attrs,
          false
        ),
        _vm.$listeners
      ),
      [_vm._t("default")],
      2
    )
  };
  var __vue_staticRenderFns__ = [];
  __vue_render__._withStripped = true;

    /* style */
    const __vue_inject_styles__ = undefined;
    /* scoped */
    const __vue_scope_id__ = undefined;
    /* module identifier */
    const __vue_module_identifier__ = undefined;
    /* functional template */
    const __vue_is_functional_template__ = false;
    /* style inject */
    
    /* style inject SSR */
    

    
    var TextButton = normalizeComponent_1(
      { render: __vue_render__, staticRenderFns: __vue_staticRenderFns__ },
      __vue_inject_styles__,
      __vue_script__,
      __vue_scope_id__,
      __vue_is_functional_template__,
      __vue_module_identifier__,
      undefined,
      undefined
    );

  //
  var script$1 = {
    components: {
      TextButton: TextButton
    },
    props: {
      /**
       * 是否是文字按钮。
       */
      isText: {
        type: Boolean,
        "default": false
      },

      /**
       * 如果没有这个props，则通过attrs传`type`时，会导致el-button的`native-type`也被改变
       */
      type: String,

      /**
       * 点击按钮绑定的函数
       */
      click: {
        type: Function
      },

      /**
       * click函数的参数
       */
      params: {},

      /**
       * 点击事件的回调函数
       */
      callback: {
        type: Function,
        "default": function _default() {}
      }
    },
    data: function data() {
      return {
        loading: false
      };
    },
    methods: {
      // 监控按钮的Promise进程
      handleClick: function handleClick() {
        var _this = this;

        if (!this.click) return;
        this.loading = true;
        Promise.resolve(this.click(this.params)).then(function (flag) {
          if (flag === false) return; // 调用父组件中的数据刷新方法

          _this.callback();
        })["catch"](function (e) {})["finally"](function (e) {
          _this.loading = false;
        });
      }
    }
  };

  /* script */
  const __vue_script__$1 = script$1;

  /* template */
  var __vue_render__$1 = function() {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
      _vm.isText ? "text-button" : "el-button",
      _vm._g(
        _vm._b(
          {
            tag: "component",
            attrs: { loading: _vm.loading, type: _vm.type },
            on: { click: _vm.handleClick }
          },
          "component",
          _vm.$attrs,
          false
        ),
        _vm.$listeners
      ),
      [_vm._t("default")],
      2
    )
  };
  var __vue_staticRenderFns__$1 = [];
  __vue_render__$1._withStripped = true;

    /* style */
    const __vue_inject_styles__$1 = undefined;
    /* scoped */
    const __vue_scope_id__$1 = undefined;
    /* module identifier */
    const __vue_module_identifier__$1 = undefined;
    /* functional template */
    const __vue_is_functional_template__$1 = false;
    /* style inject */
    
    /* style inject SSR */
    

    
    var SelfLoadingButton = normalizeComponent_1(
      { render: __vue_render__$1, staticRenderFns: __vue_staticRenderFns__$1 },
      __vue_inject_styles__$1,
      __vue_script__$1,
      __vue_scope_id__$1,
      __vue_is_functional_template__$1,
      __vue_module_identifier__$1,
      undefined,
      undefined
    );

  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  var dialogModes = {
    "new": 'new',
    edit: 'edit',
    view: 'view'
  };
  var script$2 = {
    props: {
      newTitle: {
        type: String,
        required: true
      },
      editTitle: {
        type: String,
        required: true
      },
      viewTitle: {
        type: String,
        required: true
      },
      form: {
        type: Array,
        required: true
      },
      formAttrs: {
        type: Object,
        required: true
      },
      dialogAttrs: {
        type: Object,
        required: true
      },
      buttonSize: String
    },
    data: function data() {
      return {
        mode: dialogModes["new"],
        visible: false,
        confirmLoading: false,
        slotData: null
      };
    },
    computed: {
      title: function title() {
        switch (this.mode) {
          case dialogModes.edit:
            return this.editTitle;

          case dialogModes.view:
            return this.viewTitle;

          default:
            return this.newTitle;
        }
      },
      isView: function isView() {
        return this.mode === dialogModes.view;
      }
    },
    methods: {
      /**
       * 显示dialog
       * @public
       */
      show: function show(mode, formValue) {
        var _this = this;

        this.mode = mode;
        this.visible = true;

        if (formValue) {
          // $nextTick 有时也拿不到 form ，这样是稳妥的做法
          this.$refs.dialog.$once('opened', function () {
            _this.$refs.form.updateForm(formValue);

            _this.slotData = formValue;
          });
        }
      },
      confirm: function () {
        var _confirm = _asyncToGenerator(
        /*#__PURE__*/
        _regeneratorRuntime.mark(function _callee() {
          var _this2 = this;

          var valid, formValue, isNew, done;
          return _regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  _context.next = 2;
                  return new Promise(this.$refs.form.validate);

                case 2:
                  valid = _context.sent;

                  if (valid) {
                    _context.next = 5;
                    break;
                  }

                  return _context.abrupt("return");

                case 5:
                  formValue = this.$refs.form.getFormValue();
                  isNew = this.mode === dialogModes["new"];
                  this.confirmLoading = true;

                  done = function done() {
                    var close = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                    _this2.confirmLoading = false;
                    if (close) _this2.visible = false;
                  };

                  this.$emit('confirm', isNew, formValue, done);

                case 10:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee, this);
        }));

        function confirm() {
          return _confirm.apply(this, arguments);
        }

        return confirm;
      }(),
      resetFields: function resetFields() {
        this.$refs.form.resetFields();
        this.slotData = null;
      }
    }
  };

  var isOldIE = typeof navigator !== 'undefined' && /msie [6-9]\\b/.test(navigator.userAgent.toLowerCase());
  function createInjector(context) {
    return function (id, style) {
      return addStyle(id, style);
    };
  }
  var HEAD = document.head || document.getElementsByTagName('head')[0];
  var styles = {};

  function addStyle(id, css) {
    var group = isOldIE ? css.media || 'default' : id;
    var style = styles[group] || (styles[group] = {
      ids: new Set(),
      styles: []
    });

    if (!style.ids.has(id)) {
      style.ids.add(id);
      var code = css.source;

      if (css.map) {
        // https://developer.chrome.com/devtools/docs/javascript-debugging
        // this makes source maps inside style tags work properly in Chrome
        code += '\n/*# sourceURL=' + css.map.sources[0] + ' */'; // http://stackoverflow.com/a/26603875

        code += '\n/*# sourceMappingURL=data:application/json;base64,' + btoa(unescape(encodeURIComponent(JSON.stringify(css.map)))) + ' */';
      }

      if (!style.element) {
        style.element = document.createElement('style');
        style.element.type = 'text/css';
        if (css.media) style.element.setAttribute('media', css.media);
        HEAD.appendChild(style.element);
      }

      if ('styleSheet' in style.element) {
        style.styles.push(code);
        style.element.styleSheet.cssText = style.styles.filter(Boolean).join('\n');
      } else {
        var index = style.ids.size - 1;
        var textNode = document.createTextNode(code);
        var nodes = style.element.childNodes;
        if (nodes[index]) style.element.removeChild(nodes[index]);
        if (nodes.length) style.element.insertBefore(textNode, nodes[index]);else style.element.appendChild(textNode);
      }
    }
  }

  var browser = createInjector;

  /* script */
  const __vue_script__$2 = script$2;

  /* template */
  var __vue_render__$2 = function() {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
      "el-dialog",
      _vm._b(
        {
          ref: "dialog",
          attrs: { title: _vm.title, visible: _vm.visible },
          on: {
            "update:visible": function($event) {
              _vm.visible = $event;
            },
            close: _vm.resetFields
          }
        },
        "el-dialog",
        _vm.dialogAttrs,
        false
      ),
      [
        _c(
          "el-form-renderer",
          _vm._b(
            { ref: "form", attrs: { content: _vm.form, disabled: _vm.isView } },
            "el-form-renderer",
            _vm.formAttrs,
            false
          ),
          [_vm._t("default", null, { row: _vm.slotData })],
          2
        ),
        _vm._v(" "),
        _c(
          "div",
          {
            directives: [
              {
                name: "show",
                rawName: "v-show",
                value: !_vm.isView,
                expression: "!isView"
              }
            ],
            attrs: { slot: "footer" },
            slot: "footer"
          },
          [
            _c(
              "el-button",
              {
                attrs: { size: _vm.buttonSize },
                on: {
                  click: function($event) {
                    _vm.visible = false;
                  }
                }
              },
              [_vm._v("取 消")]
            ),
            _vm._v(" "),
            _c(
              "el-button",
              {
                attrs: {
                  type: "primary",
                  loading: _vm.confirmLoading,
                  size: _vm.buttonSize
                },
                on: { click: _vm.confirm }
              },
              [_vm._v("确 定")]
            )
          ],
          1
        )
      ],
      1
    )
  };
  var __vue_staticRenderFns__$2 = [];
  __vue_render__$2._withStripped = true;

    /* style */
    const __vue_inject_styles__$2 = function (inject) {
      if (!inject) return
      inject("data-v-14329366_0", { source: "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n", map: {"version":3,"sources":[],"names":[],"mappings":"","file":"the-dialog.vue"}, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$2 = undefined;
    /* module identifier */
    const __vue_module_identifier__$2 = undefined;
    /* functional template */
    const __vue_is_functional_template__$2 = false;
    /* style inject SSR */
    

    
    var TheDialog = normalizeComponent_1(
      { render: __vue_render__$2, staticRenderFns: __vue_staticRenderFns__$2 },
      __vue_inject_styles__$2,
      __vue_script__$2,
      __vue_scope_id__$2,
      __vue_is_functional_template__$2,
      __vue_module_identifier__$2,
      browser,
      undefined
    );

  var ElDataTableColumn = {
    name: 'el-data-table-column',
    functional: true,
    render: function render(h, _ref) {
      var data = _ref.data,
          props = _ref.props;
      var children = [];
      var align = props.align;

      if (props.columns) {
        children = props.columns.map(function (column) {
          return h('el-data-table-column', {
            props: Object.assign({}, {
              align: align
            }, column)
          });
        });
      }

      data.props = _objectSpread({}, data.props);
      return h('el-table-column', data, children);
    }
  };

  var valueSeparator = '~';
  var paramSeparator = ',';
  var paramInnerSeparator = '|';
  var queryFlag = 'q=';
  var queryPattern = new RegExp(queryFlag + '.*' + paramSeparator);
  /**
   * 在浏览器地址栏的 URL 需要做额外处理：兼容持久化数组
   * 直接将数组 encode 时，数组[1,2]会先转成'1,2'再 encode 成 '1%2C2'。但 vue-router 会自动转义 url 参数，导致数组的 ',' 无法和键值对分隔符 ',' 区分开。解决方法：改变数组的分隔符
   * {a: 'a&b', b: true, d: [1,2,3]} => 'a~a%26b,b~true,d~%5B1%7C2%7C3%5D'
   * @param {object} query
   * @param {string} equal - 键和值的分隔符
   * @param {string} delimiter - 键值对之间的分隔符
   * @param {string} arrayDelimiter - 数组项之间的分隔符
   * @return {string}
   */

  function stringify(query) {
    var equal = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : valueSeparator;
    var delimiter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : paramSeparator;
    var arrayDelimiter = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : paramInnerSeparator;
    return Object.keys(query).map(function (k) {
      // 数组即便 encode 也会被自动转义，使用别的分割符
      var v = JSON.stringify(query[k]).split(',').join(arrayDelimiter);
      return "".concat(k).concat(equal).concat(encodeURIComponent(v));
    }).join(delimiter);
  }
  /**
   * 转换附在url上的字符串成query对象
   * qs.parse只能自定义delimiter，不能自定义equal
   * 'a~a%26b,b~true' => {a: 'a&b', b: true}
   *
   * @param {string} query
   * @param {string} equal - 键和值的分隔符
   * @param {string} delimiter - 键值对之间的分隔符
   * @return {object}
   */

  function parse(query) {
    var equal = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : valueSeparator;
    var delimiter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : paramSeparator;
    var arrayDelimiter = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : paramInnerSeparator;
    return query.split(delimiter).map(function (param) {
      return param.split(equal);
    }).reduce(function (obj, _ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          k = _ref2[0],
          v = _ref2[1];

      // 替换回逗号
      var value = decodeURIComponent(v).split(arrayDelimiter).join(',');
      obj[k] = JSON.parse(value);
      return obj;
    }, {});
  }
  /**
   * 将query对象转换成str插入到url上
   *
   * @param {string} url
   * @param {object} query
   * @param {'history'|'hash'} routerMode
   * @returns {string} 插入了query的url
   */

  function set(url, query, routerMode) {
    var queryStr = queryFlag + stringify(query) + paramSeparator;

    var queryPrefix = function queryPrefix(str) {
      return str.indexOf('?') > -1 ? '&' : '?';
    };

    if (queryPattern.test(url)) {
      return url.replace(queryPattern, queryStr);
    } else if (url.indexOf('#') === -1) {
      return url + queryPrefix(url) + queryStr;
    } else {
      var _url$split = url.split('#'),
          _url$split2 = _slicedToArray(_url$split, 2),
          path = _url$split2[0],
          hash = _url$split2[1];

      if (routerMode === 'history') {
        return path + queryPrefix(path) + queryStr + '#' + hash;
      } else {
        return url + queryPrefix(hash) + queryStr;
      }
    }
  }
  /**
   * 从url中取出query对象，如果没有，返回null
   *
   * @param {string} url
   * @return {object|null} 对象类型的query参数
   */

  function get(url) {
    var found = url.match(queryPattern);
    if (!found) return null;
    var queryStr = found[0].replace(queryFlag, '').slice(0, -1); // 移除末尾的paramSeparator

    return parse(queryStr);
  }
  /**
   * 从url中移除(?||&)queryPattern
   * @param {string} url
   */

  function clear(url) {
    if (queryPattern.test(url)) {
      var replacePattern = RegExp('[?&]' + queryPattern.source);
      return url.replace(replacePattern, '');
    } else {
      return url;
    }
  }

  /**
   * 两种多选策略：Normal 和 PersistSelection
   */

  /**
   * 多选策略接口
   */
  var StrategyAbstract =
  /*#__PURE__*/
  function () {
    function StrategyAbstract(elDataTable) {
      _classCallCheck(this, StrategyAbstract);

      this.elDataTable = elDataTable; // 绑定this后可直接在template中使用

      this.onSelectionChange = this.onSelectionChange.bind(this);
      this.onSelect = this.onSelect.bind(this);
      this.onSelectAll = this.onSelectAll.bind(this);
    }

    _createClass(StrategyAbstract, [{
      key: "onSelectionChange",
      value: function onSelectionChange() {}
    }, {
      key: "onSelect",
      value: function onSelect() {}
    }, {
      key: "onSelectAll",
      value: function onSelectAll() {}
    }, {
      key: "toggleRowSelection",
      value: function toggleRowSelection() {}
    }, {
      key: "clearSelection",
      value: function clearSelection() {}
    }, {
      key: "updateElTableSelection",
      value: function updateElTableSelection() {}
    }, {
      key: "elTable",
      get: function get() {
        return this.elDataTable.$refs.table || {
          onSelectionChange: function onSelectionChange() {},
          onSelect: function onSelect() {},
          onSelectAll: function onSelectAll() {},
          toggleRowSelection: function toggleRowSelection() {},
          clearSelection: function clearSelection() {},
          updateElTableSelection: function updateElTableSelection() {}
        };
      }
    }]);

    return StrategyAbstract;
  }();
  /**
   * 普通策略。由el-table维护selected
   */


  var StrategyNormal =
  /*#__PURE__*/
  function (_StrategyAbstract) {
    _inherits(StrategyNormal, _StrategyAbstract);

    function StrategyNormal() {
      _classCallCheck(this, StrategyNormal);

      return _possibleConstructorReturn(this, _getPrototypeOf(StrategyNormal).apply(this, arguments));
    }

    _createClass(StrategyNormal, [{
      key: "onSelectionChange",

      /**
       * normal模式下只需要监听selection-change事件
       */
      value: function onSelectionChange(val) {
        this.elDataTable.selected = val;
      }
      /**
       * toggleRowSelection和clearSelection的表现与el-table一致
       */

    }, {
      key: "toggleRowSelection",
      value: function toggleRowSelection() {
        var _this$elTable;

        return (_this$elTable = this.elTable).toggleRowSelection.apply(_this$elTable, arguments);
      }
    }, {
      key: "clearSelection",
      value: function clearSelection() {
        return this.elTable.clearSelection();
      }
    }]);

    return StrategyNormal;
  }(StrategyAbstract);
  /**
   * 跨页保存多选策略。手动维护selected数组
   */


  var StrategyPersistSelection =
  /*#__PURE__*/
  function (_StrategyAbstract2) {
    _inherits(StrategyPersistSelection, _StrategyAbstract2);

    function StrategyPersistSelection() {
      _classCallCheck(this, StrategyPersistSelection);

      return _possibleConstructorReturn(this, _getPrototypeOf(StrategyPersistSelection).apply(this, arguments));
    }

    _createClass(StrategyPersistSelection, [{
      key: "onSelect",

      /**
       * el-table的selection-change事件不适用于开启跨页保存的情况。
       * 比如，当开启persistSelection时，发生以下两个场景：
       * 1. 用户点击翻页
       * 2. 用户点击行首的切换全选项按钮，清空当前页多选项数据
       * 其中场景1应该保持selected不变；而场景2只应该从selected移除当前页所有行，保留其他页面的多选状态。
       * 但el-table的selection-change事件在两个场景中无差别发生，所以这里不处理这个事件
       */

      /**
       * 用户切换某一行的多选
       */
      value: function onSelect(selection, row) {
        var isChosen = selection.indexOf(row) > -1;
        this.toggleRowSelection(row, isChosen);
      }
      /**
       * 用户切换当前页的多选
       */

    }, {
      key: "onSelectAll",
      value: function onSelectAll(selection) {
        var _this = this;

        var selectable = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {
          return true;
        };
        var isSelected = !!selection.length;
        this.elDataTable.data.forEach(function (r) {
          if (selectable(r)) {
            _this.toggleRowSelection(r, isSelected);
          }
        });
      }
      /**
       * toggleRowSelection和clearSelection管理elDataTable的selected数组
       * 记得最后要将状态同步到el-table中
       */

    }, {
      key: "toggleRowSelection",
      value: function toggleRowSelection(row, isSelected) {
        var _this$elDataTable = this.elDataTable,
            id = _this$elDataTable.id,
            selected = _this$elDataTable.selected;
        var foundIndex = selected.findIndex(function (r) {
          return r[id] === row[id];
        });

        if (typeof isSelected === 'undefined') {
          if (foundIndex > -1) {
            selected.splice(foundIndex, 1);
          } else {
            selected.push(row);
          }
        } else if (isSelected && foundIndex === -1) {
          selected.push(row);
        } else if (!isSelected && foundIndex > -1) {
          selected.splice(foundIndex, 1);
        }

        this.updateElTableSelection();
      }
    }, {
      key: "clearSelection",
      value: function clearSelection() {
        this.elDataTable.selected = [];
        this.updateElTableSelection();
      }
      /**
       * 将selected状态同步到el-table中
       */

    }, {
      key: "updateElTableSelection",
      value: function updateElTableSelection() {
        var _this2 = this;

        var _this$elDataTable2 = this.elDataTable,
            data = _this$elDataTable2.data,
            id = _this$elDataTable2.id,
            selected = _this$elDataTable2.selected;
        data.forEach(function (r) {
          var isSelected = !!selected.find(function (r2) {
            return r[id] === r2[id];
          });

          _this2.elTable.toggleRowSelection(r, isSelected);
        });
      }
    }]);

    return StrategyPersistSelection;
  }(StrategyAbstract);

  function getSelectStrategy(elDataTable) {
    return elDataTable.persistSelection ? new StrategyPersistSelection(elDataTable) : new StrategyNormal(elDataTable);
  }

  var getLocatedSlotKeys = (function ($slots, name) {
    var keys = Object.keys($slots);
    return keys.filter(function (key) {
      return key.indexOf(name) > -1;
    });
  });

  function transformSearchImmediatelyItem (content, vm) {
    return content.map(function (item) {
      var origOnInput = item.on && item.on.input;

      if (item.searchImmediately) {
        return Object.assign(item, {
          on: Object.assign({}, item.on, {
            input: function input() {
              if (typeof origOnInput === 'function') {
                for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                  args[_key] = arguments[_key];
                }

                origOnInput.call.apply(origOnInput, [item].concat(args));
              }

              vm.search();
            }
          })
        });
      }

      return item;
    });
  }

  var isFalsey = function isFalsey(value) {
    return ['', undefined, null].indexOf(value) > -1 || Array.isArray(value) && value.length === 0;
  };
  var removeEmptyKeys = function removeEmptyKeys(query) {
    return Object.keys(query).filter(function (k) {
      var value = query[k];
      return Array.isArray(value) ? value.length !== 0 : !['', undefined, null].includes(value);
    }).reduce(function (obj, k) {
      return obj[k] = query[k], obj;
    }, {});
  };

  var defaultFirstPage = 1;
  var noPaginationDataPath = 'payload';
  var script$3 = {
    name: 'ElDataTable',
    components: {
      SelfLoadingButton: SelfLoadingButton,
      TheDialog: TheDialog,
      ElDataTableColumn: ElDataTableColumn
    },
    props: {
      /**
       * 请求url, 如果为空, 则不会发送请求; 改变url, 则table会重新发送请求
       */
      url: {
        type: String,
        "default": ''
      },

      /**
       * 主键，默认值 id，
       * 修改/删除时会用到,请求会根据定义的属性值获取主键,即row[this.id]
       */
      id: {
        type: String,
        "default": 'id'
      },

      /**
       * 分页请求的第一页的值(有的接口0是第一页)
       */
      firstPage: {
        type: Number,
        "default": defaultFirstPage
      },

      /**
       * 渲染组件的分页数据在接口返回的数据中的路径, 嵌套对象使用.表示即可
       */
      dataPath: {
        type: String,
        "default": 'payload.content'
      },

      /**
       * 分页数据的总数在接口返回的数据中的路径, 嵌套对象使用.表示即可
       */
      totalPath: {
        type: String,
        "default": 'payload.totalElements'
      },

      /**
       * 请求的时候如果接口需要的页码的查询 key 不同的时候可以指定
       */
      pageKey: {
        type: String,
        "default": 'page'
      },

      /**
       * 请求的时候如果接口需要的分页数量的查询 key 不同的时候可以指定
       */
      pageSizeKey: {
        type: String,
        "default": 'size'
      },

      /**
       * 列属性设置, 详情见element-ui官网
       * @link https://element.eleme.cn/2.4/#/zh-CN/component/table#table-column-attributes
       */
      columns: {
        type: Array,
        "default": function _default() {
          return [];
        }
      },

      /**
       * 查询字段渲染, 配置参考el-form-renderer
       * @link https://femessage.github.io/el-form-renderer/
       */
      searchForm: {
        type: Array,
        "default": function _default() {
          return [];
        }
      },

      /**
       * 是否开启搜索栏折叠功能
       */
      canSearchCollapse: {
        type: Boolean,
        "default": false
      },

      /**
       * 点击查询按钮, 查询前执行的函数，参数form表单数据，需要返回Promise
       */
      beforeSearch: {
        type: Function,
        "default": function _default() {}
      },

      /**
       * 单选, 适用场景: 不可以批量删除
       */
      single: {
        type: Boolean,
        "default": false
      },

      /**
       * 切换页面时，已勾选项不会丢失
       */
      persistSelection: {
        type: Boolean,
        "default": false
      },

      /**
       * 是否有操作列
       */
      hasOperation: {
        type: Boolean,
        "default": true
      },

      /**
       * 操作列的自定义按钮, 渲染的是element-ui的button, 支持包括style在内的以下属性:
       * {type: '', text: '', atClick: row => Promise.resolve(), show: row => return true时显示, disabled: row => return true时禁用 }
       * 点击事件 row参数 表示当前行数据, 需要返回Promise, 默认点击后会刷新table, resolve(false) 则不刷新
       */
      extraButtons: {
        type: Array,
        "default": function _default() {
          return [];
        }
      },

      /**
       * 头部的自定义按钮, 渲染的是element-ui的button, 支持包括style在内的以下属性:
       * {type: '', text: '', atClick: selected => Promise.resolve(), show: selected => return true时显示, disabled: selected => return true时禁用}
       * 点击事件 selected参数 表示选中行所组成的数组, 函数需要返回Promise, 默认点击后会刷新table, resolve(false) 则不刷新
       */
      headerButtons: {
        type: Array,
        "default": function _default() {
          return [];
        }
      },

      /**
       * 是否有新增按钮
       */
      hasNew: {
        type: Boolean,
        "default": true
      },

      /**
       * 是否有编辑按钮
       */
      hasEdit: {
        type: Boolean,
        "default": true
      },

      /**
       * 是否有查看按钮
       */
      hasView: {
        type: Boolean,
        "default": false
      },

      /**
       * table头部是否有删除按钮(该按钮要多选时才会出现)
       */
      hasDelete: {
        type: Boolean,
        "default": true
      },

      /**
       * 新增按钮文案
       */
      newText: {
        type: String,
        "default": '新增'
      },

      /**
       * 修改按钮文案
       */
      editText: {
        type: String,
        "default": '修改'
      },

      /**
       * 查看按钮文案
       */
      viewText: {
        type: String,
        "default": '查看'
      },

      /**
       * 删除按钮文案
       */
      deleteText: {
        type: String,
        "default": '删除'
      },

      /**
       * 删除提示语。接受要删除的数据（单个对象或数组）；返回字符串
       * @param {object|object[]} 要删除的数据 - 单个对象或数组
       * @return {string}
       */
      deleteMessage: {
        type: Function,
        "default": function _default() {
          return "\u786E\u8BA4".concat(this.deleteText, "\u5417?");
        }
      },

      /**
       * 某行数据是否可以删除, 返回true表示可以, 控制的是单选时单行的删除按钮
       */
      canDelete: {
        type: Function,
        "default": function _default() {
          return true;
        }
      },

      /**
       * 点击新增按钮时的方法, 当默认新增方法不满足需求时使用, 需要返回promise
       * 参数(data, row) data 是form表单的数据, row 是当前行的数据, 只有isTree为true时, 点击操作列的新增按钮才会有值
       */
      onNew: {
        type: Function,
        "default": function _default(data) {
          return this.$axios.post(this.url, data, this.axiosConfig);
        }
      },

      /**
       * 点击修改按钮时的方法, 当默认修改方法不满足需求时使用, 需要返回promise
       * 参数(data, row) data 是form表单的数据, row 是当前行的数据
       */
      onEdit: {
        type: Function,
        "default": function _default(data) {
          return this.$axios.put("".concat(this.url, "/").concat(this.row[this.id]), data, this.axiosConfig);
        }
      },

      /**
       * 点击删除按钮时的方法, 当默认删除方法不满足需求时使用, 需要返回promise
       * 多选时, 参数为selected, 代表选中的行组成的数组; 非多选时参数为row, 代表单行的数据
       */
      onDelete: {
        type: Function,
        "default": function _default(data) {
          var _this = this;

          var ids = Array.isArray(data) ? data.map(function (v) {
            return v[_this.id];
          }).join(',') : data[this.id];
          return this.$axios["delete"](this.url + '/' + ids, this.axiosConfig);
        }
      },

      /**
       * crud 操作成功后会调用的函数，默认是 this.$message.success('操作成功')
       * 接受两个参数：
       * type，操作的类型，可能的值有 new | edit | delete；
       * data，操作的数据对象
       */
      onSuccess: {
        type: Function,
        "default": function _default() {
          return this.$message.success('操作成功');
        }
      },

      /**
       * 是否分页。如果不分页，则请求传参page=-1
       */
      hasPagination: {
        type: Boolean,
        "default": true
      },

      /**
       * 分页组件的子组件布局，子组件名用逗号分隔，对应element-ui pagination的layout属性
       * @link https://element.eleme.cn/2.4/#/zh-CN/component/pagination
       */
      paginationLayout: {
        type: String,
        "default": 'total, sizes, prev, pager, next, jumper'
      },

      /**
       * 分页组件的每页显示个数选择器的选项设置，对应element-ui pagination的page-sizes属性
       * @link https://element.eleme.cn/2.4/#/zh-CN/component/pagination
       */
      paginationSizes: {
        type: Array,
        "default": function _default() {
          return [10, 20, 30, 40, 50];
        }
      },

      /**
       * 分页组件的每页显示个数选择器默认选项，对应element-ui pagination的page-size属性
       * @link https://element.eleme.cn/2.4/#/zh-CN/component/pagination
       */
      paginationSize: {
        type: Number,
        "default": 20
      },

      /**
       * @deprecated
       * 不分页时的size的大小(建议接口约定，不分页时传参page=-1，故一般不会用到此属性)
       */
      noPaginationSize: {
        type: Number,
        "default": 999
      },

      /**
       * 要渲染的数据是否是树形结构
       */
      isTree: {
        type: Boolean,
        "default": false
      },

      /**
       * 树形结构相关: 子节点的字段名
       */
      treeChildKey: {
        type: String,
        "default": 'children'
      },

      /**
       * 树形结构相关: 父节点的字段名
       */
      treeParentKey: {
        type: String,
        "default": 'parentId'
      },

      /**
       * 树形结构相关: 父节点字段值的来源字段。
       * 新增/修改时会用到, 例如, 在id为2的节点新增子节点, 则子节点的parentId为2, 也即parentId的值来源于字段id, 故treeParentValue为id
       */
      treeParentValue: {
        type: String,
        "default": 'id'
      },

      /**
       * 树形结构相关: 是否展开所有节点
       */
      expandAll: {
        type: Boolean,
        "default": false
      },

      /**
       * el-table 的 prop 配置，详情配置参考element-ui官网
       * @link https://element.eleme.cn/2.4/#/zh-CN/component/table#table-attributes
       */
      tableAttrs: {
        type: Object,
        "default": function _default() {
          return {};
        }
      },

      /**
       * el-table 的 eventHandler 配置，详情配置参考element-ui官网
       * @link https://element.eleme.cn/2.4/#/zh-CN/component/table#table-attributes
       */
      tableEventHandlers: {
        type: Object,
        "default": function _default() {
          return {};
        }
      },

      /**
       * 操作列属性
       * @link https://element.eleme.cn/2.4/#/zh-CN/component/table#table-column-attributes
       */
      operationAttrs: {
        type: Object,
        "default": function _default() {
          return {
            width: '',
            fixed: 'right'
          };
        }
      },

      /**
       * 新增弹窗的标题，默认为newText的值
       */
      dialogNewTitle: {
        type: String,
        "default": function _default() {
          return this.newText;
        }
      },

      /**
       * 修改弹窗的标题，默认为editText的值
       */
      dialogEditTitle: {
        type: String,
        "default": function _default() {
          return this.editText;
        }
      },

      /**
       * 查看弹窗的标题，默认为viewText的值
       */
      dialogViewTitle: {
        type: String,
        "default": function _default() {
          return this.viewText;
        }
      },

      /**
       * 弹窗表单, 用于新增与修改, 详情配置参考el-form-renderer
       * @link https://femessage.github.io/el-form-renderer/
       */
      form: {
        type: Array,
        "default": function _default() {
          return [];
        }
      },

      /**
       * 弹窗表单属性设置, 详情配置参考element-ui官网
       * @link https://element.eleme.cn/2.4/#/zh-CN/component/form#form-attributes
       */
      formAttrs: {
        type: Object,
        "default": function _default() {
          return {};
        }
      },

      /**
       * 对话框属性设置, 详情配置参考element-ui官网
       * @link https://element.eleme.cn/2.4/#/zh-CN/component/dialog#attributes
       */
      dialogAttrs: {
        type: Object,
        "default": function _default() {
          return {};
        }
      },

      /**
       * 同extraBody
       * @deprecated
       */
      extraParams: {
        type: Object,
        "default": function _default() {
          return undefined;
        }
      },

      /**
       * 新增/修改提交时，请求体带上额外的参数。
       */
      extraBody: {
        type: Object,
        "default": function _default() {
          return undefined;
        }
      },

      /**
       * 在新增/修改弹窗 点击确认时调用，返回Promise, 如果reject, 则不会发送新增/修改请求
       * 参数: (data, isNew) data为表单数据, isNew true 表示是新增弹窗, false 为 编辑弹窗
       */
      beforeConfirm: {
        type: Function,
        "default": function _default() {
          return Promise.resolve();
        }
      },

      /**
       * 同extraQuery
       * @deprecated
       */
      customQuery: {
        type: Object,
        "default": function _default() {
          return undefined;
        }
      },

      /**
       * 向请求url添加的额外参数。
       * 可用.sync修饰，此时点击重置按钮后该参数也会被重置
       */
      extraQuery: {
        type: Object,
        "default": function _default() {
          return undefined;
        }
      },

      /**
       * 是否开启使用url保存query参数的功能
       */
      saveQuery: {
        type: Boolean,
        "default": true
      },

      /**
       * 操作栏按钮类型
       * `text` 为文本按钮, `button` 为普通按钮
       */
      operationButtonType: {
        type: String,
        "default": 'text'
      },

      /**
       * 设置 `按钮` 大小
       * @see https://element.eleme.cn/#/zh-CN/component/button#bu-tong-chi-cun
       */
      buttonSize: {
        type: String,
        "default": 'small'
      },

      /**
       * 设置axios的config参数
       */
      axiosConfig: {
        type: Object,
        "default": function _default() {
          return {};
        }
      }
    },
    data: function data() {
      return {
        data: [],
        size: this.paginationSize || this.paginationSizes[0],
        page: defaultFirstPage,
        // https://github.com/ElemeFE/element/issues/1153
        total: null,
        loading: false,
        // 多选项的数组
        selected: [],
        // 要修改的那一行
        row: {},
        // 初始的extraQuery值, 重置查询时, 会用到
        // JSON.stringify是为了后面深拷贝作准备
        initExtraQuery: JSON.stringify(this.extraQuery || this.customQuery || {}),
        isSearchCollapse: false,
        showNoData: false
      };
    },
    computed: {
      tableEventHandlersInner: function tableEventHandlersInner() {
        var handlers = {};

        for (var key in this.tableEventHandlers) {
          var kebab = _kebabcase(key);

          handlers[kebab] = this.tableEventHandlers[key];
        }

        return handlers;
      },
      hasSelect: function hasSelect() {
        return this.columns.length && this.columns[0].type == 'selection';
      },
      selectable: function selectable() {
        if (this.hasSelect && this.columns[0].selectable) {
          return this.columns[0].selectable;
        }

        return function () {
          return true;
        };
      },
      columnsAlign: function columnsAlign() {
        if (this.columns.some(function (col) {
          return col.columns && col.columns.length;
        })) {
          // 多级表头默认居中
          return 'center';
        } else {
          return '';
        }
      },
      routerMode: function routerMode() {
        return this.$router ? this.$router.mode : 'hash';
      },
      hasSearchForm: function hasSearchForm() {
        return this.searchForm.length || this.$slots.search;
      },
      hasHeader: function hasHeader() {
        return this.hasNew || this.hasSelect && this.hasDelete || this.headerButtons.length || this.canSearchCollapse || this.$scopedSlots.header;
      },
      _extraBody: function _extraBody() {
        return this.extraBody || this.extraParams || {};
      },
      _extraQuery: function _extraQuery() {
        return this.extraQuery || this.customQuery || {};
      },
      selectStrategy: function selectStrategy() {
        return getSelectStrategy(this);
      },
      searchLocatedSlotKeys: function searchLocatedSlotKeys() {
        return getLocatedSlotKeys(this.$slots, 'search:');
      },
      collapseForm: function collapseForm() {
        var _this2 = this;

        return this.searchForm.map(function (item) {
          if ('collapsible' in item && !item.collapsible) {
            return item;
          }

          var itemHidden = item.hidden || function () {
            return false;
          };

          return _objectSpread({}, item, {
            hidden: function hidden(data) {
              return _this2.isSearchCollapse || itemHidden(data);
            }
          });
        });
      },
      _searchForm: function _searchForm() {
        return transformSearchImmediatelyItem(this.collapseForm, this);
      }
    },
    watch: {
      url: {
        handler: function handler(val) {
          if (!val) return;
          this.page = defaultFirstPage; // mounted处有updateForm的行为，所以至少在初始执行时要等到nextTick

          this.$nextTick(this.getList);
        },
        immediate: true
      },
      selected: function selected(val) {
        /**
         * 多选项发生变化
         * @property {array} rows - 已选中的行数据的数组
         */
        this.$emit('selection-change', val);
      }
    },
    mounted: function mounted() {
      if (this.saveQuery) {
        var query = get(location.href);

        if (query) {
          this.page = parseInt(query[this.pageKey]);
          this.size = parseInt(query[this.pageSizeKey]); // 恢复查询条件，但对slot=search无效

          if (this.$refs.searchForm) {
            delete query[this.pageKey];
            delete query[this.pageSizeKey];
            this.$refs.searchForm.updateForm(query);
          }
        }
      }
    },
    methods: {
      /**
       * 手动刷新列表数据，选项的默认值为: { loading: true }
       * @public
       * @param {object} options 方法选项
       */
      getList: function getList() {
        var _this3 = this,
            _arguments = arguments;

        var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
            _ref$loading = _ref.loading,
            loading = _ref$loading === void 0 ? true : _ref$loading;

        var url = this.url;

        if (!url) {
          console.warn('DataTable: url 为空, 不发送请求');
          return;
        } // 构造query对象


        var query = {};
        var formValue = {};

        if (this.$refs.searchForm) {
          formValue = this.$refs.searchForm.getFormValue();
          Object.assign(query, formValue);
        }

        Object.assign(query, this._extraQuery);
        query[this.pageSizeKey] = this.hasPagination ? this.size : this.noPaginationSize; // 根据偏移值计算接口正确的页数

        var pageOffset = this.firstPage - defaultFirstPage;
        query[this.pageKey] = this.hasPagination ? this.page + pageOffset : -1; // 无效值过滤，注意0是有效值

        query = Object.keys(query).filter(function (k) {
          return ![undefined, null].includes(query[k]);
        }).reduce(function (obj, k) {
          return obj[k] = query[k], obj;
        }, {}); // 请求开始

        this.loading = loading; // 存储query记录, 便于后面恢复

        if (this.saveQuery) {
          // 存储的page是table的页码，无需偏移
          query[this.pageKey] = this.page;
          var newUrl = set(location.href, query, this.routerMode);
          history.replaceState(history.state, 'el-data-table search', newUrl);
        } // 当查询参数为数组时，需要将参数转化为字符串才发送请求


        query = Object.keys(query).reduce(function (obj, k) {
          return obj[k] = Array.isArray(query[k]) ? query[k].toString().trim() : query[k], obj;
        }, {});

        var params = _objectSpread({}, removeEmptyKeys(query), _get(this.axiosConfig, 'params', {}));

        this.$axios(_objectSpread({
          method: 'get',
          url: url,
          params: params
        }, this.axiosConfig)).then(function (_ref2) {
          var resp = _ref2.data;
          var data = []; // 不分页

          if (!_this3.hasPagination) {
            data = _get(resp, _this3.dataPath) || _get(resp, noPaginationDataPath) || [];
            _this3.total = data.length;
          } else {
            data = _get(resp, _this3.dataPath) || []; // 获取不到值得时候返回 undefined, el-pagination 接收一个 null 或者 undefined 会导致没数据但是下一页可点击

            _this3.total = _get(resp, _this3.totalPath) || 0;
            var lastPage = Math.ceil(_this3.total / _this3.size);

            if (0 < lastPage && lastPage < _this3.page) {
              _this3.page = lastPage;

              _this3.getList.apply(_this3, _toConsumableArray(_arguments));

              return;
            }
          }

          _this3.data = data; // 树形结构逻辑

          if (_this3.isTree) {
            _this3.data = _this3.tree2Array(data, _this3.expandAll);
          }

          _this3.showNoData = _this3.$slots['no-data'] && _this3.total === 0 && (_isEmpty(formValue) || _values(formValue).every(isFalsey));
          _this3.loading = false;
          /**
           * 请求返回, 数据更新后触发
           * @property {object} data - table的数据
           * @property {object} resp - 请求返回的完整response
           */

          _this3.$emit('update', data, resp); // 开启persistSelection时，需要同步selected状态到el-table中


          _this3.$nextTick(function () {
            _this3.selectStrategy.updateElTableSelection();
          });
        })["catch"](function (err) {
          /**
           * 请求数据失败，返回err对象
           * @event error
           */
          _this3.$emit('error', err);

          _this3.total = 0;
          _this3.loading = false;
        });
      },
      search: function () {
        var _search = _asyncToGenerator(
        /*#__PURE__*/
        _regeneratorRuntime.mark(function _callee() {
          var form, valid;
          return _regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  form = this.$refs.searchForm;
                  _context.next = 3;
                  return new Promise(function (r) {
                    return form.validate(r);
                  });

                case 3:
                  valid = _context.sent;

                  if (valid) {
                    _context.next = 6;
                    break;
                  }

                  return _context.abrupt("return");

                case 6:
                  _context.prev = 6;
                  _context.next = 9;
                  return this.beforeSearch(form.getFormValue());

                case 9:
                  this.page = defaultFirstPage;
                  this.getList();
                  _context.next = 16;
                  break;

                case 13:
                  _context.prev = 13;
                  _context.t0 = _context["catch"](6);
                  this.$emit('error', _context.t0);

                case 16:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee, this, [[6, 13]]);
        }));

        function search() {
          return _search.apply(this, arguments);
        }

        return search;
      }(),

      /**
       * 重置查询，相当于点击「重置」按钮
       *
       * @public
       */
      resetSearch: function resetSearch() {
        var _this4 = this;

        // reset后, form里的值会变成 undefined, 在下一次查询会赋值给query
        this.$refs.searchForm.resetFields();
        this.page = defaultFirstPage; // 重置

        if (this.saveQuery) {
          var newUrl = clear(location.href);
          history.replaceState(history.state, '', newUrl);
        }
        /**
         * 按下重置按钮后触发
         */


        this.$emit('reset');
        this.$emit('update:customQuery', JSON.parse(this.initExtraQuery));
        this.$emit('update:extraQuery', JSON.parse(this.initExtraQuery));
        this.$nextTick(function () {
          _this4.getList();
        });
      },
      handleSizeChange: function handleSizeChange(val) {
        if (this.size === val) return;
        this.page = defaultFirstPage;
        this.size = val;
        this.getList();
      },
      handleCurrentChange: function handleCurrentChange(val) {
        if (this.page === val) return;
        this.page = val;
        this.getList();
      },

      /**
       * 切换某一行的选中状态，如果使用了第二个参数，则是设置这一行选中与否
       *
       * @public
       * @param {object} row - 要更新的数据行
       * @param {boolean} isSelected - 是否被勾选
       */
      toggleRowSelection: function toggleRowSelection(row, isSelected) {
        return this.selectStrategy.toggleRowSelection(row, isSelected);
      },

      /**
       * 清空多选项
       *
       * @public
       */
      clearSelection: function clearSelection() {
        return this.selectStrategy.clearSelection();
      },
      // 弹窗相关
      // 除非树形结构在操作列点击新增, 否则 row 是 MouseEvent
      onDefaultNew: function onDefaultNew(row) {
        this.row = row;
        this.$refs.dialog.show(dialogModes["new"]);
      },
      onDefaultView: function onDefaultView(row) {
        this.row = row;
        this.$refs.dialog.show(dialogModes.view, row);
      },
      onDefaultEdit: function onDefaultEdit(row) {
        this.row = row;
        this.$refs.dialog.show(dialogModes.edit, row);
      },
      onConfirm: function () {
        var _onConfirm = _asyncToGenerator(
        /*#__PURE__*/
        _regeneratorRuntime.mark(function _callee2(isNew, formValue, done) {
          var data;
          return _regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  data = _objectSpread({}, formValue, this._extraBody);

                  if (this.isTree) {
                    data[this.treeParentKey] = isNew ? this.row[this.treeParentValue] : this.row[this.treeParentKey];
                  }

                  _context2.prev = 2;
                  _context2.next = 5;
                  return this.beforeConfirm(data, isNew);

                case 5:
                  if (!isNew) {
                    _context2.next = 10;
                    break;
                  }

                  _context2.next = 8;
                  return this.onNew(data, this.row);

                case 8:
                  _context2.next = 12;
                  break;

                case 10:
                  _context2.next = 12;
                  return this.onEdit(data, this.row);

                case 12:
                  this.getList();
                  this.onSuccess(isNew ? 'new' : 'edit', data);
                  done();
                  _context2.next = 20;
                  break;

                case 17:
                  _context2.prev = 17;
                  _context2.t0 = _context2["catch"](2);
                  // 出错则不关闭dialog
                  done(false);

                case 20:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2, this, [[2, 17]]);
        }));

        function onConfirm(_x, _x2, _x3) {
          return _onConfirm.apply(this, arguments);
        }

        return onConfirm;
      }(),

      /**
       * 完整的删除方法，流程如下：
       * 1. 弹出二次确认弹窗（使用 deleteMessage）；
       * 2. 执行 onDelete，过程中确认按钮保持 loading；
       * 3. 失败则报错误信息、弹窗不关闭；
       * 4. 成功则报成功信息、弹窗关闭、重新请求数据、并校正页码（详见 correctPage）；
       * @public
       * @param {object|object[]} - 要删除的数据对象或数组
       */
      onDefaultDelete: function onDefaultDelete(data) {
        var _this5 = this;

        return this.$confirm(this.deleteMessage(data), '提示', {
          type: 'warning',
          confirmButtonClass: 'el-button--danger',
          beforeClose: function () {
            var _beforeClose = _asyncToGenerator(
            /*#__PURE__*/
            _regeneratorRuntime.mark(function _callee3(action, instance, done) {
              return _regeneratorRuntime.wrap(function _callee3$(_context3) {
                while (1) {
                  switch (_context3.prev = _context3.next) {
                    case 0:
                      if (!(action !== 'confirm')) {
                        _context3.next = 2;
                        break;
                      }

                      return _context3.abrupt("return", done());

                    case 2:
                      instance.confirmButtonLoading = true;
                      _context3.prev = 3;
                      _context3.next = 6;
                      return _this5.onDelete(data);

                    case 6:
                      done();

                      _this5.onSuccess('delete', data);

                      _this5.correctPage();

                      _this5.getList();

                      _context3.next = 16;
                      break;

                    case 12:
                      _context3.prev = 12;
                      _context3.t0 = _context3["catch"](3);
                      console.warn(_context3.t0.message);
                      throw _context3.t0;

                    case 16:
                      _context3.prev = 16;
                      instance.confirmButtonLoading = false;
                      return _context3.finish(16);

                    case 19:
                    case "end":
                      return _context3.stop();
                  }
                }
              }, _callee3, null, [[3, 12, 16, 19]]);
            }));

            function beforeClose(_x4, _x5, _x6) {
              return _beforeClose.apply(this, arguments);
            }

            return beforeClose;
          }()
        })["catch"](function () {
          /*取消*/
        });
      },

      /**
       * 判断是否返回上一页
       * @public
       */
      correctPage: function correctPage() {
        var deleteCount = 1;

        if (this.hasSelect) {
          deleteCount = this.selected.length;
          this.clearSelection();
        }

        var remain = this.data.length - deleteCount;
        var lastPage = Math.ceil(this.total / this.size);
        if (remain === 0 && this.page === lastPage && this.page > defaultFirstPage) this.page--;
      },
      // 树形table相关
      // https://github.com/PanJiaChen/vue-element-admin/tree/master/src/components/TreeTable
      tree2Array: function tree2Array(data, expandAll) {
        var _this6 = this;

        var parent = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
        var level = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
        var tmp = [];
        data.forEach(function (record) {
          if (record._expanded === undefined) {
            _this6.$set(record, '_expanded', expandAll);
          }

          var _level = 0;

          if (level !== undefined && level !== null) {
            _level = level + 1;
          }

          _this6.$set(record, '_level', _level); // 如果有父元素


          if (parent) {
            Object.defineProperty(record, 'parent', {
              value: parent,
              enumerable: false
            });
          }

          tmp.push(record);

          if (record[_this6.treeChildKey] && record[_this6.treeChildKey].length > 0) {
            var children = _this6.tree2Array(record[_this6.treeChildKey], expandAll, record, _level);

            tmp = tmp.concat(children);
          }
        });
        return tmp;
      },
      rowClassName: function rowClassName() {
        var rcn = this.tableAttrs.rowClassName || this.tableAttrs['row-class-name'] || '';
        if (typeof rcn === 'function') rcn = rcn.apply(void 0, arguments);
        if (this.isTree) rcn += ' ' + this.showRow.apply(this, arguments);
        return rcn;
      },
      showRow: function showRow(_ref3) {
        var row = _ref3.row;
        var show = !row.parent || row.parent._expanded && row.parent._show;
        row._show = show;
        return show ? 'row-show' : 'row-hide';
      },
      // 切换下级是否展开
      toggleExpanded: function toggleExpanded(trIndex) {
        var record = this.data[trIndex];
        record._expanded = !record._expanded;
      },
      // 图标显示
      iconShow: function iconShow(index, record) {
        //      return index ===0 && record.children && record.children.length > 0;
        return record[this.treeChildKey] && record[this.treeChildKey].length > 0;
      }
    }
  };

  /* script */
  const __vue_script__$3 = script$3;

  /* template */
  var __vue_render__$3 = function() {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
      "div",
      { staticClass: "el-data-table" },
      [
        _vm.showNoData
          ? [_vm._t("no-data")]
          : [
              _vm.hasSearchForm
                ? _c(
                    "el-form-renderer",
                    {
                      ref: "searchForm",
                      staticClass: "search-form-container",
                      attrs: { content: _vm._searchForm, inline: "" },
                      nativeOn: {
                        submit: function($event) {
                          $event.preventDefault();
                        }
                      }
                    },
                    [
                      _vm._l(_vm.searchLocatedSlotKeys, function(slot) {
                        return _vm._t(slot, null, {
                          slot: slot.replace("search:", "id:")
                        })
                      }),
                      _vm._v(" "),
                      _vm._t("search"),
                      _vm._v(" "),
                      _c(
                        "el-form-item",
                        [
                          _c(
                            "el-button",
                            {
                              attrs: {
                                "native-type": "submit",
                                type: "primary",
                                size: _vm.buttonSize
                              },
                              on: { click: _vm.search }
                            },
                            [_vm._v("查询")]
                          ),
                          _vm._v(" "),
                          _c(
                            "el-button",
                            {
                              attrs: { size: _vm.buttonSize },
                              on: { click: _vm.resetSearch }
                            },
                            [_vm._v("重置")]
                          )
                        ],
                        1
                      )
                    ],
                    2
                  )
                : _vm._e(),
              _vm._v(" "),
              _vm.hasHeader
                ? _c(
                    "el-form",
                    [
                      _c(
                        "el-form-item",
                        { staticClass: "header-button-container" },
                        [
                          _vm.hasNew
                            ? _c(
                                "el-button",
                                {
                                  attrs: {
                                    type: "primary",
                                    size: _vm.buttonSize
                                  },
                                  on: { click: _vm.onDefaultNew }
                                },
                                [_vm._v(_vm._s(_vm.newText))]
                              )
                            : _vm._e(),
                          _vm._v(" "),
                          _vm._l(_vm.headerButtons, function(btn, i) {
                            return [
                              ("show" in btn
                              ? btn.show(_vm.selected)
                              : true)
                                ? _c(
                                    "self-loading-button",
                                    _vm._b(
                                      {
                                        key: i,
                                        attrs: {
                                          disabled:
                                            "disabled" in btn
                                              ? btn.disabled(_vm.selected)
                                              : false,
                                          click: btn.atClick,
                                          params: _vm.selected,
                                          callback: _vm.getList,
                                          size: _vm.buttonSize
                                        }
                                      },
                                      "self-loading-button",
                                      btn,
                                      false
                                    ),
                                    [
                                      _vm._v(
                                        "\n            " +
                                          _vm._s(
                                            typeof btn.text === "function"
                                              ? btn.text(_vm.selected)
                                              : btn.text
                                          ) +
                                          "\n          "
                                      )
                                    ]
                                  )
                                : _vm._e()
                            ]
                          }),
                          _vm._v(" "),
                          _vm.hasSelect && _vm.hasDelete
                            ? _c(
                                "el-button",
                                {
                                  attrs: {
                                    type: "danger",
                                    size: _vm.buttonSize,
                                    disabled:
                                      _vm.selected.length === 0 ||
                                      (_vm.single && _vm.selected.length > 1)
                                  },
                                  on: {
                                    click: function($event) {
                                      return _vm.onDefaultDelete(
                                        _vm.single
                                          ? _vm.selected[0]
                                          : _vm.selected
                                      )
                                    }
                                  }
                                },
                                [_vm._v(_vm._s(_vm.deleteText))]
                              )
                            : _vm._e(),
                          _vm._v(" "),
                          _vm._t("header", null, { selected: _vm.selected }),
                          _vm._v(" "),
                          _vm._t(
                            "collapse",
                            [
                              _vm.canSearchCollapse
                                ? _c(
                                    "el-button",
                                    {
                                      attrs: {
                                        type: "default",
                                        size: _vm.buttonSize,
                                        icon:
                                          "el-icon-arrow-" +
                                          (_vm.isSearchCollapse ? "down" : "up")
                                      },
                                      on: {
                                        click: function($event) {
                                          _vm.isSearchCollapse = !_vm.isSearchCollapse;
                                        }
                                      }
                                    },
                                    [
                                      _vm._v(
                                        _vm._s(
                                          _vm.isSearchCollapse ? "展开" : "折叠"
                                        ) + "搜索"
                                      )
                                    ]
                                  )
                                : _vm._e()
                            ],
                            { isSearchCollapse: _vm.isSearchCollapse }
                          )
                        ],
                        2
                      )
                    ],
                    1
                  )
                : _vm._e(),
              _vm._v(" "),
              _c(
                "el-table",
                _vm._g(
                  _vm._b(
                    {
                      directives: [
                        {
                          name: "loading",
                          rawName: "v-loading",
                          value: _vm.loading,
                          expression: "loading"
                        }
                      ],
                      ref: "table",
                      attrs: {
                        data: _vm.data,
                        "row-class-name": _vm.rowClassName
                      },
                      on: {
                        "selection-change": _vm.selectStrategy.onSelectionChange,
                        select: _vm.selectStrategy.onSelect,
                        "select-all": function($event) {
                          return _vm.selectStrategy.onSelectAll(
                            $event,
                            _vm.selectable
                          )
                        }
                      }
                    },
                    "el-table",
                    _vm.tableAttrs,
                    false
                  ),
                  _vm.tableEventHandlersInner
                ),
                [
                  _vm.isTree
                    ? [
                        _vm.hasSelect
                          ? [
                              _c(
                                "el-data-table-column",
                                _vm._b(
                                  { key: "selection-key" },
                                  "el-data-table-column",
                                  Object.assign(
                                    {},
                                    { align: _vm.columnsAlign },
                                    _vm.columns[0]
                                  ),
                                  false
                                )
                              ),
                              _vm._v(" "),
                              _c(
                                "el-data-table-column",
                                _vm._b(
                                  {
                                    key: "tree-ctrl",
                                    scopedSlots: _vm._u(
                                      [
                                        {
                                          key: "default",
                                          fn: function(scope) {
                                            return [
                                              _vm._l(scope.row._level, function(
                                                space
                                              ) {
                                                return _c("span", {
                                                  key: space,
                                                  staticClass: "ms-tree-space"
                                                })
                                              }),
                                              _vm._v(" "),
                                              _vm.iconShow(
                                                scope.$index,
                                                scope.row
                                              )
                                                ? _c(
                                                    "span",
                                                    {
                                                      staticClass: "tree-ctrl",
                                                      on: {
                                                        click: function($event) {
                                                          return _vm.toggleExpanded(
                                                            scope.$index
                                                          )
                                                        }
                                                      }
                                                    },
                                                    [
                                                      _c("i", {
                                                        class:
                                                          "el-icon-" +
                                                          (scope.row._expanded
                                                            ? "minus"
                                                            : "plus")
                                                      })
                                                    ]
                                                  )
                                                : _vm._e(),
                                              _vm._v(
                                                "\n              " +
                                                  _vm._s(
                                                    scope.row[_vm.columns[1].prop]
                                                  ) +
                                                  "\n            "
                                              )
                                            ]
                                          }
                                        }
                                      ],
                                      null,
                                      false,
                                      1266978847
                                    )
                                  },
                                  "el-data-table-column",
                                  Object.assign(
                                    {},
                                    { align: _vm.columnsAlign },
                                    _vm.columns[1]
                                  ),
                                  false
                                )
                              ),
                              _vm._v(" "),
                              _vm._l(
                                _vm.columns.filter(function(c, i) {
                                  return i !== 0 && i !== 1
                                }),
                                function(col) {
                                  return _c(
                                    "el-data-table-column",
                                    _vm._b(
                                      { key: col.prop },
                                      "el-data-table-column",
                                      Object.assign(
                                        {},
                                        { align: _vm.columnsAlign },
                                        col
                                      ),
                                      false
                                    )
                                  )
                                }
                              )
                            ]
                          : [
                              _c(
                                "el-data-table-column",
                                _vm._b(
                                  {
                                    key: "tree-ctrl",
                                    scopedSlots: _vm._u(
                                      [
                                        {
                                          key: "default",
                                          fn: function(scope) {
                                            return [
                                              _vm._l(scope.row._level, function(
                                                space
                                              ) {
                                                return _c("span", {
                                                  key: space,
                                                  staticClass: "ms-tree-space"
                                                })
                                              }),
                                              _vm._v(" "),
                                              _vm.iconShow(
                                                scope.$index,
                                                scope.row
                                              )
                                                ? _c(
                                                    "span",
                                                    {
                                                      staticClass: "tree-ctrl",
                                                      on: {
                                                        click: function($event) {
                                                          return _vm.toggleExpanded(
                                                            scope.$index
                                                          )
                                                        }
                                                      }
                                                    },
                                                    [
                                                      _c("i", {
                                                        class:
                                                          "el-icon-" +
                                                          (scope.row._expanded
                                                            ? "minus"
                                                            : "plus")
                                                      })
                                                    ]
                                                  )
                                                : _vm._e(),
                                              _vm._v(
                                                "\n              " +
                                                  _vm._s(
                                                    scope.row[_vm.columns[0].prop]
                                                  ) +
                                                  "\n            "
                                              )
                                            ]
                                          }
                                        }
                                      ],
                                      null,
                                      false,
                                      889764958
                                    )
                                  },
                                  "el-data-table-column",
                                  Object.assign(
                                    {},
                                    { align: _vm.columnsAlign },
                                    _vm.columns[0]
                                  ),
                                  false
                                )
                              ),
                              _vm._v(" "),
                              _vm._l(
                                _vm.columns.filter(function(c, i) {
                                  return i !== 0
                                }),
                                function(col) {
                                  return _c(
                                    "el-data-table-column",
                                    _vm._b(
                                      { key: col.prop },
                                      "el-data-table-column",
                                      Object.assign(
                                        {},
                                        { align: _vm.columnsAlign },
                                        col
                                      ),
                                      false
                                    )
                                  )
                                }
                              )
                            ]
                      ]
                    : _vm._l(_vm.columns, function(col) {
                        return _c(
                          "el-data-table-column",
                          _vm._b(
                            { key: col.prop },
                            "el-data-table-column",
                            Object.assign({}, { align: _vm.columnsAlign }, col),
                            false
                          )
                        )
                      }),
                  _vm._v(" "),
                  _vm.hasOperation
                    ? _c(
                        "el-data-table-column",
                        _vm._b(
                          {
                            attrs: { label: "操作" },
                            scopedSlots: _vm._u(
                              [
                                {
                                  key: "default",
                                  fn: function(scope) {
                                    return [
                                      _vm.isTree && _vm.hasNew
                                        ? _c(
                                            "self-loading-button",
                                            {
                                              attrs: {
                                                type: "primary",
                                                size:
                                                  _vm.operationButtonType ===
                                                  "text"
                                                    ? ""
                                                    : _vm.buttonSize,
                                                "is-text":
                                                  _vm.operationButtonType ===
                                                  "text"
                                              },
                                              on: {
                                                click: function($event) {
                                                  return _vm.onDefaultNew(
                                                    scope.row
                                                  )
                                                }
                                              }
                                            },
                                            [
                                              _vm._v(
                                                "\n            " +
                                                  _vm._s(_vm.newText) +
                                                  "\n          "
                                              )
                                            ]
                                          )
                                        : _vm._e(),
                                      _vm._v(" "),
                                      _vm.hasEdit
                                        ? _c(
                                            "self-loading-button",
                                            {
                                              attrs: {
                                                type: "primary",
                                                size:
                                                  _vm.operationButtonType ===
                                                  "text"
                                                    ? ""
                                                    : _vm.buttonSize,
                                                "is-text":
                                                  _vm.operationButtonType ===
                                                  "text"
                                              },
                                              on: {
                                                click: function($event) {
                                                  return _vm.onDefaultEdit(
                                                    scope.row
                                                  )
                                                }
                                              }
                                            },
                                            [
                                              _vm._v(
                                                "\n            " +
                                                  _vm._s(_vm.editText) +
                                                  "\n          "
                                              )
                                            ]
                                          )
                                        : _vm._e(),
                                      _vm._v(" "),
                                      _vm.hasView
                                        ? _c(
                                            "self-loading-button",
                                            {
                                              attrs: {
                                                type: "primary",
                                                size:
                                                  _vm.operationButtonType ===
                                                  "text"
                                                    ? ""
                                                    : _vm.buttonSize,
                                                "is-text":
                                                  _vm.operationButtonType ===
                                                  "text"
                                              },
                                              on: {
                                                click: function($event) {
                                                  return _vm.onDefaultView(
                                                    scope.row
                                                  )
                                                }
                                              }
                                            },
                                            [
                                              _vm._v(
                                                "\n            " +
                                                  _vm._s(_vm.viewText) +
                                                  "\n          "
                                              )
                                            ]
                                          )
                                        : _vm._e(),
                                      _vm._v(" "),
                                      _vm._l(_vm.extraButtons, function(btn, i) {
                                        return [
                                          ("show" in btn
                                          ? btn.show(scope.row)
                                          : true)
                                            ? _c(
                                                "self-loading-button",
                                                _vm._b(
                                                  {
                                                    key: i,
                                                    attrs: {
                                                      "is-text":
                                                        _vm.operationButtonType ===
                                                        "text",
                                                      click: btn.atClick,
                                                      params: scope.row,
                                                      callback: _vm.getList,
                                                      disabled:
                                                        "disabled" in btn
                                                          ? btn.disabled(
                                                              scope.row
                                                            )
                                                          : false
                                                    }
                                                  },
                                                  "self-loading-button",
                                                  btn,
                                                  false
                                                ),
                                                [
                                                  _vm._v(
                                                    "\n              " +
                                                      _vm._s(
                                                        typeof btn.text ===
                                                          "function"
                                                          ? btn.text(scope.row)
                                                          : btn.text
                                                      ) +
                                                      "\n            "
                                                  )
                                                ]
                                              )
                                            : _vm._e()
                                        ]
                                      }),
                                      _vm._v(" "),
                                      !_vm.hasSelect &&
                                      _vm.hasDelete &&
                                      _vm.canDelete(scope.row)
                                        ? _c(
                                            "self-loading-button",
                                            {
                                              attrs: {
                                                type: "danger",
                                                size:
                                                  _vm.operationButtonType ===
                                                  "text"
                                                    ? ""
                                                    : _vm.buttonSize,
                                                "is-text":
                                                  _vm.operationButtonType ===
                                                  "text"
                                              },
                                              on: {
                                                click: function($event) {
                                                  return _vm.onDefaultDelete(
                                                    scope.row
                                                  )
                                                }
                                              }
                                            },
                                            [
                                              _vm._v(
                                                "\n            " +
                                                  _vm._s(_vm.deleteText) +
                                                  "\n          "
                                              )
                                            ]
                                          )
                                        : _vm._e()
                                    ]
                                  }
                                }
                              ],
                              null,
                              false,
                              548599695
                            )
                          },
                          "el-data-table-column",
                          Object.assign(
                            {},
                            { align: _vm.columnsAlign },
                            _vm.operationAttrs
                          ),
                          false
                        )
                      )
                    : _vm._e(),
                  _vm._v(" "),
                  _vm._t("default")
                ],
                2
              ),
              _vm._v(" "),
              _vm.hasPagination
                ? _c("el-pagination", {
                    staticStyle: { "text-align": "right", padding: "10px 0" },
                    attrs: {
                      "current-page": _vm.page,
                      "page-sizes": _vm.paginationSizes,
                      "page-size": _vm.size,
                      total: _vm.total,
                      layout: _vm.paginationLayout
                    },
                    on: {
                      "size-change": _vm.handleSizeChange,
                      "current-change": _vm.handleCurrentChange
                    }
                  })
                : _vm._e(),
              _vm._v(" "),
              _c("the-dialog", {
                ref: "dialog",
                attrs: {
                  "new-title": _vm.dialogNewTitle,
                  "edit-title": _vm.dialogEditTitle,
                  "view-title": _vm.dialogViewTitle,
                  form: _vm.form,
                  "form-attrs": _vm.formAttrs,
                  "dialog-attrs": _vm.dialogAttrs,
                  "button-size": _vm.buttonSize
                },
                on: { confirm: _vm.onConfirm },
                scopedSlots: _vm._u(
                  [
                    {
                      key: "default",
                      fn: function(scope) {
                        return [_vm._t("form", null, { row: scope.row })]
                      }
                    }
                  ],
                  null,
                  true
                )
              })
            ]
      ],
      2
    )
  };
  var __vue_staticRenderFns__$3 = [];
  __vue_render__$3._withStripped = true;

    /* style */
    const __vue_inject_styles__$3 = function (inject) {
      if (!inject) return
      inject("data-v-aebdaad8_0", { source: ".el-data-table .ms-tree-space {\n  position: relative;\n  top: 1px;\n  display: inline-block;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 1;\n  width: 18px;\n  height: 14px;\n}\n.el-data-table .ms-tree-space::before {\n  content: '';\n}\n.el-data-table .tree-ctrl {\n  position: relative;\n  cursor: pointer;\n  color: #2196f3;\n}\n@keyframes treeTableShow {\nfrom {\n    opacity: 0;\n}\nto {\n    opacity: 1;\n}\n}\n.el-data-table .row-show {\n  animation: treeTableShow 1s;\n}\n.el-data-table .row-hide {\n  display: none;\n}\n", map: {"version":3,"sources":["el-data-table.vue"],"names":[],"mappings":"AAAA;EACE,kBAAkB;EAClB,QAAQ;EACR,qBAAqB;EACrB,kBAAkB;EAClB,gBAAgB;EAChB,cAAc;EACd,WAAW;EACX,YAAY;AACd;AACA;EACE,WAAW;AACb;AACA;EACE,kBAAkB;EAClB,eAAe;EACf,cAAc;AAChB;AACA;AACE;IACE,UAAU;AACZ;AACA;IACE,UAAU;AACZ;AACF;AACA;EACE,2BAA2B;AAC7B;AACA;EACE,aAAa;AACf","file":"el-data-table.vue","sourcesContent":[".el-data-table .ms-tree-space {\n  position: relative;\n  top: 1px;\n  display: inline-block;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 1;\n  width: 18px;\n  height: 14px;\n}\n.el-data-table .ms-tree-space::before {\n  content: '';\n}\n.el-data-table .tree-ctrl {\n  position: relative;\n  cursor: pointer;\n  color: #2196f3;\n}\n@keyframes treeTableShow {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n.el-data-table .row-show {\n  animation: treeTableShow 1s;\n}\n.el-data-table .row-hide {\n  display: none;\n}\n"]}, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$3 = undefined;
    /* module identifier */
    const __vue_module_identifier__$3 = undefined;
    /* functional template */
    const __vue_is_functional_template__$3 = false;
    /* style inject SSR */
    

    
    var component = normalizeComponent_1(
      { render: __vue_render__$3, staticRenderFns: __vue_staticRenderFns__$3 },
      __vue_inject_styles__$3,
      __vue_script__$3,
      __vue_scope_id__$3,
      __vue_is_functional_template__$3,
      __vue_module_identifier__$3,
      browser,
      undefined
    );

  // Import vue component
  // so calling it multiple times on the same plugin will install the plugin only once

  component.install = function (Vue) {
    Vue.component(component.name, component);
  }; // To auto-install when vue is found


  var GlobalVue = null;

  if (typeof window !== 'undefined') {
    GlobalVue = window.Vue;
  } else if (typeof global !== 'undefined') {
    GlobalVue = global.Vue;
  }

  if (GlobalVue) {
    GlobalVue.use(component);
  } // To allow use as module (npm/webpack/etc.) export component
  // also be used as directives, etc. - eg. import { RollupDemoDirective } from 'rollup-demo';
  // export const RollupDemoDirective = component;

  exports.default = component;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
