(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = global || self, factory(global.femtoTween = {}));
}(this, (function (exports) { 'use strict';

  // linear: no easing, no acceleration
  // easeIn*: accelerating from zero velocity
  // easeOut*: decelerating to zero velocity
  // easeInOut*: acceleration until halfway, then deceleration

  var EaseIn = function (power) { return function (t) { return Math.pow(t, power); }; };
  var EaseOut = function (power) { return function (t) { return 1 - Math.abs(Math.pow(t - 1, power)); }; };
  var EaseInOut = function (power) { return function (t) { return t < 0.5 ? EaseIn(power)(t * 2) / 2 : EaseOut(power)(t * 2 - 1) / 2 + 0.5; }; };

  var linear = EaseInOut(1);
  var easeInQuad = EaseIn(2);
  var easeOutQuad = EaseOut(2);
  var easeInOutQuad = EaseInOut(2);
  var easeInCubic = EaseIn(3);
  var easeOutCubic = EaseOut(3);
  var easeInOutCubic = EaseInOut(3);
  var easeInQuart = EaseIn(4);
  var easeOutQuart = EaseOut(4);
  var easeInOutQuart = EaseInOut(4);
  var easeInQuint = EaseIn(5);
  var easeOutQuint = EaseOut(5);
  var easeInOutQuint = EaseInOut(5);

  function tween(from, to, cb, ref) {
    if ( ref === void 0 ) ref = {};
    var time = ref.time;
    var done = ref.done;
    var easeFunc = ref.easeFunc;

    var stopped = false;
    var stop = function () { return stopped = true; };
    var ease = easeFunc || easeInOutQuart;
    var diff = from - to;
    var targetTime = time || 400;
    var start = null;
    function step(timestamp) {
      if (stopped) { return }
      if (!start) { start = timestamp; }
      var progress = timestamp - start;
      var percentage = Math.min(progress / targetTime, 1);
      cb(from - ease(percentage) * diff);
      if (progress < targetTime) {
        window && window.requestAnimationFrame(step);
      } else {
        cb(to);
        done && done();
      }
    }
    window && window.requestAnimationFrame(step);
    return stop
  }

  exports.easeInCubic = easeInCubic;
  exports.easeInOutCubic = easeInOutCubic;
  exports.easeInOutQuad = easeInOutQuad;
  exports.easeInOutQuart = easeInOutQuart;
  exports.easeInOutQuint = easeInOutQuint;
  exports.easeInQuad = easeInQuad;
  exports.easeInQuart = easeInQuart;
  exports.easeInQuint = easeInQuint;
  exports.easeOutCubic = easeOutCubic;
  exports.easeOutQuad = easeOutQuad;
  exports.easeOutQuart = easeOutQuart;
  exports.easeOutQuint = easeOutQuint;
  exports.linear = linear;
  exports.tween = tween;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=femtoTween.umd.js.map
