// linear: no easing, no acceleration
// easeIn*: accelerating from zero velocity
// easeOut*: decelerating to zero velocity
// easeInOut*: acceleration until halfway, then deceleration

const EaseIn = (power) => (t) => Math.pow(t, power);
const EaseOut = (power) => (t) => 1 - Math.abs(Math.pow(t - 1, power));
const EaseInOut = (power) => (t) => t < 0.5 ? EaseIn(power)(t * 2) / 2 : EaseOut(power)(t * 2 - 1) / 2 + 0.5;

const linear = EaseInOut(1);
const easeInQuad = EaseIn(2);
const easeOutQuad = EaseOut(2);
const easeInOutQuad = EaseInOut(2);
const easeInCubic = EaseIn(3);
const easeOutCubic = EaseOut(3);
const easeInOutCubic = EaseInOut(3);
const easeInQuart = EaseIn(4);
const easeOutQuart = EaseOut(4);
const easeInOutQuart = EaseInOut(4);
const easeInQuint = EaseIn(5);
const easeOutQuint = EaseOut(5);
const easeInOutQuint = EaseInOut(5);

function tween(from, to, cb, { time, done, easeFunc } = {}) {
  let stopped = false;
  const stop = () => stopped = true;
  const ease = easeFunc || easeInOutQuart;
  const diff = from - to;
  const targetTime = time || 400;
  let start = null;
  function step(timestamp) {
    if (stopped) return
    if (!start) start = timestamp;
    const progress = timestamp - start;
    const percentage = Math.min(progress / targetTime, 1);
    cb(from - ease(percentage) * diff);
    if (progress < targetTime) {
      window && window.requestAnimationFrame(step);
    } else {
      cb(to);
      done && done();
    }
  }
  window && window.requestAnimationFrame(step);
  return stop
}

export { easeInCubic, easeInOutCubic, easeInOutQuad, easeInOutQuart, easeInOutQuint, easeInQuad, easeInQuart, easeInQuint, easeOutCubic, easeOutQuad, easeOutQuart, easeOutQuint, linear, tween };
//# sourceMappingURL=femtoTween.esm.js.map
