export default class Blob {
    static [Symbol.hasInstance](object: any): boolean;
    /**
     * The Blob() constructor returns a new Blob object. The content
     * of the blob consists of the concatenation of the values given
     * in the parameter array.
     *
     * @param {*} blobParts
     * @param {{ type?: string }} [options]
     */
    constructor(blobParts?: any, options?: {
        type?: string;
    });
    /**
     * The Blob interface's size property returns the
     * size of the Blob in bytes.
     */
    get size(): number;
    /**
     * The type property of a Blob object returns the MIME type of the file.
     */
    get type(): string;
    /**
     * The text() method in the Blob interface returns a Promise
     * that resolves with a string containing the contents of
     * the blob, interpreted as UTF-8.
     *
     * @return {Promise<string>}
     */
    text(): Promise<string>;
    /**
     * The arrayBuffer() method in the Blob interface returns a
     * Promise that resolves with the contents of the blob as
     * binary data contained in an ArrayBuffer.
     *
     * @return {Promise<ArrayBuffer>}
     */
    arrayBuffer(): Promise<ArrayBuffer>;
    /**
     * The Blob stream() implements partial support of the whatwg stream
     * by only being async iterable.
     *
     * @returns {AsyncGenerator<Uint8Array>}
     */
    stream(): AsyncGenerator<Uint8Array>;
    /**
     * The Blob interface's slice() method creates and returns a
     * new Blob object which contains data from a subset of the
     * blob on which it's called.
     *
     * @param {number} [start]
     * @param {number} [end]
     * @param {string} [type]
     */
    slice(start?: number, end?: number, type?: string): Blob;
    get [Symbol.toStringTag](): string;
    #private;
}
