# find-file-up [![NPM version](https://img.shields.io/npm/v/find-file-up.svg?style=flat)](https://www.npmjs.com/package/find-file-up) [![NPM monthly downloads](https://img.shields.io/npm/dm/find-file-up.svg?style=flat)](https://npmjs.org/package/find-file-up) [![NPM total downloads](https://img.shields.io/npm/dt/find-file-up.svg?style=flat)](https://npmjs.org/package/find-file-up) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/find-file-up.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/find-file-up)

> Find a file, starting with the given cwd and recursively searching up one directory until it's found (or we run out of directories). Async and sync.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save find-file-up
```

## Usage

```js
var findFile = require('find-file-up');
```

### async

```js
// find `foo.txt` starting at the given directory
findFile('foo.txt', '.', function(err, fp) {
  //=> /Users/jonschlinkert/dev/find-file-up/fixtures/foo.txt
});

// search user home
findFile('foo.txt', '~/', function(err, fp) {
  //=> /Users/jonschlinkert/foo.txt
});
```

### sync

```js
var file = findFile.sync('foo.txt', 'a/b/c/');
```

## About

### Related projects

* [find-pkg](https://www.npmjs.com/package/find-pkg): Find the first directory with a package.json, recursing up, starting with the given directory. Similar… [more](https://github.com/jonschlinkert/find-pkg) | [homepage](https://github.com/jonschlinkert/find-pkg "Find the first directory with a package.json, recursing up, starting with the given directory. Similar to look-up but does not support globs and only searches for package.json. Async and sync.")
* [findup-sync](https://www.npmjs.com/package/findup-sync): Find the first file matching a given pattern in the current directory or the nearest… [more](https://github.com/cowboy/node-findup-sync) | [homepage](https://github.com/cowboy/node-findup-sync "Find the first file matching a given pattern in the current directory or the nearest ancestor directory.")
* [global-modules](https://www.npmjs.com/package/global-modules): The directory used by npm for globally installed npm modules. | [homepage](https://github.com/jonschlinkert/global-modules "The directory used by npm for globally installed npm modules.")
* [global-prefix](https://www.npmjs.com/package/global-prefix): Get the npm global path prefix. | [homepage](https://github.com/jonschlinkert/global-prefix "Get the npm global path prefix.")
* [load-module-pkg](https://www.npmjs.com/package/load-module-pkg): Load the package.json for any project currently installed in node_modules. | [homepage](https://github.com/jonschlinkert/load-module-pkg "Load the package.json for any project currently installed in node_modules.")
* [load-pkg](https://www.npmjs.com/package/load-pkg): Loads the package.json from the root of the user's current project. | [homepage](https://github.com/jonschlinkert/load-pkg "Loads the package.json from the root of the user's current project.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 19 | [jonschlinkert](https://github.com/jonschlinkert) |
| 1 | [pointnet](https://github.com/pointnet) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on May 20, 2017._