import type * as psp from "../../dist/pkg/perspective-js.d.ts";
/**
 * Create a new client connected exclusively to a new Web Worker instance of
 * the Perspective engine.
 * @param module
 * @returns
 */
export declare function worker(module: Promise<typeof psp>): Promise<psp.Client>;
/**
 * Create a new client connected via WebSocket to a server implemnting the
 * Perspective Protocol.
 * @param module
 * @param url
 * @returns
 */
export declare function websocket(module: Promise<typeof psp>, url: string | URL): Promise<psp.Client>;
declare const _default: {
    websocket: typeof websocket;
    worker: typeof worker;
};
export default _default;
