export type * from "../../dist/pkg/perspective-js.d.ts";
export interface EmscriptenServer {
}
export interface EmscriptenApi {
    HEAP8: Int8Array;
    HEAPU8: Uint8Array;
    HEAP16: Int16Array;
    HEAPU16: Uint16Array;
    HEAP32: Int32Array;
    HEAPU32: Uint32Array;
    _psp_alloc(size: number): number;
    _psp_free(ptr: number): void;
    _psp_new_server(): EmscriptenServer;
    _psp_delete_server(server: EmscriptenServer): void;
    _psp_handle_request(server: EmscriptenServer, client_id: number, buffer_ptr: number, buffer_len: number): number;
    _psp_poll(server: EmscriptenServer): number;
    _psp_new_session(server: EmscriptenServer): number;
    _psp_close_session(server: EmscriptenServer, client_id: number): void;
}
export declare function compile_perspective(compressed_binary: ArrayBuffer): Promise<EmscriptenApi>;
