import { EmscriptenApi, EmscriptenServer } from "./emscripten_api.ts";
export type ApiResponse = {
    client_id: number;
    data: Uint8Array;
};
export declare class PerspectiveServer {
    clients: Map<number, (buffer: Uint8Array) => Promise<void>>;
    id_gen: number;
    server: EmscriptenServer;
    module: EmscriptenApi;
    constructor(module: EmscriptenApi);
    /**
     * Helper function to create server emitter/receiver pairs
     */
    make_session(callback: (buffer: Uint8Array) => Promise<void>): PerspectiveSession;
    delete(): void;
}
export declare class PerspectiveSession {
    private mod;
    private server;
    private client_id;
    private client_map;
    constructor(mod: EmscriptenApi, server: EmscriptenServer, client_id: number, client_map: Map<number, (buffer: Uint8Array) => Promise<void>>);
    handle_request(view: Uint8Array): Promise<void>;
    poll(): void;
    close(): void;
}
