/// <reference types="node" />
export type * from "../../dist/pkg/perspective-js.d.ts";
export { PerspectiveServer } from "./engine.js";
import * as perspective_client from "../../dist/pkg/perspective-js.js";
import { WebSocketServer as HttpWebSocketServer } from "ws";
import http from "node:http";
import type { TableInitOptions } from "./ts-rs/TableInitOptions.js";
import { PerspectiveServer } from "./engine.js";
export declare function make_server(): PerspectiveServer;
export declare const make_session: (send_response: (buffer: Uint8Array) => Promise<void>) => Promise<import("./engine.js").PerspectiveSession>;
export declare function make_client(send_request: (buffer: Uint8Array) => void, close?: Function): perspective_client.Client;
/**
 * Host a Perspective server that hosts data, code files, etc.
 * Strip version numbers from the URL so we can handle CDN-like requests
 * of the form @[^~]major.minor.patch when testing local versions of
 * Perspective against Voila.
 */
export declare function cwd_static_file_handler(request: http.IncomingMessage, response: http.ServerResponse<http.IncomingMessage>, assets?: string[]): Promise<void>;
export declare class WebSocketServer {
    _server: http.Server | any;
    _wss: HttpWebSocketServer;
    constructor({ port, assets, server }?: {
        port?: number;
        assets?: string[];
        server?: any;
    });
    close(): Promise<void>;
}
export declare function get_hosted_table_names(): Promise<any>;
export declare function system_info(): Promise<any>;
/**
 * Create a table from the global Perspective instance.
 * @param init_data
 * @param options
 * @returns
 */
export declare function table(init_data: string | ArrayBuffer | Record<string, any> | Record<string, unknown>[], options?: TableInitOptions): Promise<perspective_client.Table>;
/**
 * Create a new client connected via WebSocket to a server implemnting the
 * Perspective Protocol.
 * @param module
 * @param url
 * @returns
 */
export declare function websocket(url: string): Promise<perspective_client.Client>;
declare const _default: {
    table: typeof table;
    websocket: typeof websocket;
    get_hosted_table_names: typeof get_hosted_table_names;
    system_info: typeof system_info;
    WebSocketServer: typeof WebSocketServer;
};
export default _default;
