/**
 * Options which impact the behavior of [`Client::table`], as well as
 * subsequent calls to [`Table::update`], even though this latter method
 * itself does not take [`TableInitOptions`] as an argument, since this
 * parameter is fixed at creation.
 */
export type TableInitOptions = {
    name?: string;
    /**
     * This [`Table`] should use the column named by the `index` parameter as
     * the `index`, which causes [`Table::update`] and [`Client::table`] input
     * to either insert or update existing rows based on `index` column
     * value equality.
     */
    index?: string;
    /**
     * This [`Table`] should be limited to `limit` rows, after which the
     * _earliest_ rows will be overwritten (where _earliest_ is defined as
     * relative to insertion order).
     */
    limit?: number;
};
