/// <reference types="express" />
import { Request, Response } from 'express';
export { Request, Response };
/** An event to be handled in a developer's Cloud Function */
export interface Event<T> {
    eventId?: string;
    timestamp?: string;
    eventType?: string;
    resource?: string;
    params?: {
        [option: string]: any;
    };
    data: T;
}
/** TriggerAnnotated is used internally by the firebase CLI to understand what type of Cloud Function to deploy. */
export interface TriggerAnnotated {
    __trigger: {
        httpsTrigger?: {};
        eventTrigger?: {
            eventType: string;
            resource: string;
        };
    };
}
/**
 * An HttpsFunction is both an object that exports its trigger definitions at __trigger and
 * can be called as a function that takes an express.js Request and Response object.
 */
export declare type HttpsFunction = TriggerAnnotated & ((req: Request, resp: Response) => void);
/**
 * A CloudFunction is both an object that exports its trigger definitions at __trigger and
 * can be called as a function using the raw JS API for Google Cloud Functions.
 */
export declare type CloudFunction<T> = TriggerAnnotated & ((event: Event<any> | Event<T>) => PromiseLike<any> | any);
