// The MIT License (MIT)
//
// Copyright (c) 2017 Firebase
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _ = require("lodash");
/** @internal */
function makeCloudFunction(_a) {
    var provider = _a.provider, eventType = _a.eventType, resource = _a.resource, _b = _a.dataConstructor, dataConstructor = _b === void 0 ? function (raw) { return raw.data; } : _b, handler = _a.handler, before = _a.before, after = _a.after;
    var cloudFunction = function (event) {
        return Promise.resolve(event)
            .then(before)
            .then(function () {
            var typedEvent = _.cloneDeep(event);
            typedEvent.data = dataConstructor(event);
            typedEvent.params = event.params || {};
            return handler(typedEvent);
        }).then(function (result) {
            if (after) {
                after(event);
            }
            return result;
        }, function (err) {
            if (after) {
                after(event);
            }
            return Promise.reject(err);
        });
    };
    cloudFunction.__trigger = {
        eventTrigger: {
            resource: resource,
            eventType: "providers/" + provider + "/eventTypes/" + eventType,
        },
    };
    return cloudFunction;
}
exports.makeCloudFunction = makeCloudFunction;
