import { Event, CloudFunction } from '../cloud-functions';
/**
 * The optional bucket function allows you to choose which buckets' events to handle.
 * This step can be bypassed by calling object() directly, which will use the bucket that
 * the Firebase SDK for Cloud Storage uses.
 */
export declare function bucket(bucket: string): BucketBuilder;
export declare function object(): ObjectBuilder;
export declare class BucketBuilder {
    private resource;
    /** Handle events for objects in this bucket. */
    object(): ObjectBuilder;
}
export declare class ObjectBuilder {
    private resource;
    /**
     * Handle any change to any object.
     */
    onChange(handler: (event: Event<ObjectMetadata>) => PromiseLike<any> | any): CloudFunction<ObjectMetadata>;
}
export interface ObjectMetadata {
    kind: string;
    id: string;
    selfLink?: string;
    name?: string;
    bucket: string;
    generation?: number;
    metageneration?: number;
    contentType?: string;
    timeCreated?: string;
    updated?: string;
    timeDeleted?: string;
    storageClass?: string;
    size?: number;
    md5Hash?: string;
    mediaLink?: string;
    contentEncoding?: string;
    contentDisposition?: string;
    contentLanguage?: string;
    cacheControl?: string;
    metadata?: {
        [key: string]: string;
    };
    crc32c?: string;
    componentCount?: number;
    customerEncryption?: {
        encryptionAlgorithm?: string;
        keySha256?: string;
    };
}
