/*! @license Firebase v4.1.1
Build: rev-ca0d1df
Terms: https://firebase.google.com/terms/ */

/**
* Copyright 2017 Google Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _errors = require('../../app/errors');

var _errors2 = require('../models/errors');

var _errors3 = _interopRequireDefault(_errors2);

var _tokenManager = require('../models/token-manager');

var _tokenManager2 = _interopRequireDefault(_tokenManager);

var _notificationPermission = require('../models/notification-permission');

var _notificationPermission2 = _interopRequireDefault(_notificationPermission);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var SENDER_ID_OPTION_NAME = 'messagingSenderId';

var ControllerInterface = function () {
    /**
     * An interface of the Messaging Service API
     * @param {!firebase.app.App} app
     */
    function ControllerInterface(app) {
        var _this = this;

        _classCallCheck(this, ControllerInterface);

        this.errorFactory_ = new _errors.ErrorFactory('messaging', 'Messaging', _errors3.default.map);
        if (!app.options[SENDER_ID_OPTION_NAME] || typeof app.options[SENDER_ID_OPTION_NAME] !== 'string') {
            throw this.errorFactory_.create(_errors3.default.codes.BAD_SENDER_ID);
        }
        this.messagingSenderId_ = app.options[SENDER_ID_OPTION_NAME];
        this.tokenManager_ = new _tokenManager2.default();
        this.app = app;
        this.INTERNAL = {};
        this.INTERNAL.delete = function () {
            return _this.delete;
        };
    }
    /**
     * @export
     * @return {Promise<string> | Promise<null>} Returns a promise that
     * resolves to an FCM token.
     */


    _createClass(ControllerInterface, [{
        key: 'getToken',
        value: function getToken() {
            var _this2 = this;

            // Check with permissions
            var currentPermission = this.getNotificationPermission_();
            if (currentPermission !== _notificationPermission2.default.granted) {
                if (currentPermission === _notificationPermission2.default.denied) {
                    return Promise.reject(this.errorFactory_.create(_errors3.default.codes.NOTIFICATIONS_BLOCKED));
                }
                // We must wait for permission to be granted
                return Promise.resolve(null);
            }
            return this.getSWRegistration_().then(function (registration) {
                return _this2.tokenManager_.getSavedToken(_this2.messagingSenderId_, registration).then(function (token) {
                    if (token) {
                        return token;
                    }
                    return _this2.tokenManager_.createToken(_this2.messagingSenderId_, registration);
                });
            });
        }
        /**
         * This method deletes tokens that the token manager looks after and then
         * unregisters the push subscription if it exists.
         * @export
         * @param {string} token
         * @return {Promise<void>}
         */

    }, {
        key: 'deleteToken',
        value: function deleteToken(token) {
            var _this3 = this;

            return this.tokenManager_.deleteToken(token).then(function () {
                return _this3.getSWRegistration_().then(function (registration) {
                    if (registration) {
                        return registration.pushManager.getSubscription();
                    }
                }).then(function (subscription) {
                    if (subscription) {
                        return subscription.unsubscribe();
                    }
                });
            });
        }
    }, {
        key: 'getSWRegistration_',
        value: function getSWRegistration_() {
            throw this.errorFactory_.create(_errors3.default.codes.SHOULD_BE_INHERITED);
        }
        //
        // The following methods should only be available in the window.
        //

    }, {
        key: 'requestPermission',
        value: function requestPermission() {
            throw this.errorFactory_.create(_errors3.default.codes.AVAILABLE_IN_WINDOW);
        }
        /**
         * @export
         * @param {!ServiceWorkerRegistration} registration
         */

    }, {
        key: 'useServiceWorker',
        value: function useServiceWorker() {
            throw this.errorFactory_.create(_errors3.default.codes.AVAILABLE_IN_WINDOW);
        }
        /**
         * @export
         * @param {!firebase.Observer|function(*)} nextOrObserver
         * @param {function(!Error)=} optError
         * @param {function()=} optCompleted
         * @return {!function()}
         */

    }, {
        key: 'onMessage',
        value: function onMessage() {
            throw this.errorFactory_.create(_errors3.default.codes.AVAILABLE_IN_WINDOW);
        }
        /**
         * @export
         * @param {!firebase.Observer|function()} nextOrObserver An observer object
         * or a function triggered on token refresh.
         * @param {function(!Error)=} optError Optional A function
         * triggered on token refresh error.
         * @param {function()=} optCompleted Optional function triggered when the
         * observer is removed.
         * @return {!function()} The unsubscribe function for the observer.
         */

    }, {
        key: 'onTokenRefresh',
        value: function onTokenRefresh() {
            throw this.errorFactory_.create(_errors3.default.codes.AVAILABLE_IN_WINDOW);
        }
        //
        // The following methods are used by the service worker only.
        //
        /**
         * @export
         * @param {function(Object)} callback
         */

    }, {
        key: 'setBackgroundMessageHandler',
        value: function setBackgroundMessageHandler() {
            throw this.errorFactory_.create(_errors3.default.codes.AVAILABLE_IN_SW);
        }
        //
        // The following methods are used by the service themselves and not exposed
        // publicly or not expected to be used by developers.
        //
        /**
         * This method is required to adhere to the Firebase interface.
         * It closes any currently open indexdb database connections.
         */

    }, {
        key: 'delete',
        value: function _delete() {
            this.tokenManager_.closeDatabase();
        }
        /**
         * Returns the current Notification Permission state.
         * @private
         * @return {string} The currenct permission state.
         */

    }, {
        key: 'getNotificationPermission_',
        value: function getNotificationPermission_() {
            return Notification.permission;
        }
        /**
         * @protected
         * @returns {TokenManager}
         */

    }, {
        key: 'getTokenManager',
        value: function getTokenManager() {
            return this.tokenManager_;
        }
    }]);

    return ControllerInterface;
}();

exports.default = ControllerInterface;
module.exports = exports['default'];
//# sourceMappingURL=controller-interface.js.map
