!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(require("@firebase/app")):"function"==typeof define&&define.amd?define(["@firebase/app"],t):t((e=e||self).firebase)}(this,function(We){"use strict";try{(function(){We=We&&We.hasOwnProperty("default")?We.default:We;var f="firebasestorage.googleapis.com",b=function(){function e(e,t){this.code_=r(e),this.message_="Firebase Storage: "+t,this.serverResponse_=null,this.name_="FirebaseError"}return e.prototype.codeProp=function(){return this.code},e.prototype.codeEquals=function(e){return r(e)===this.codeProp()},e.prototype.serverResponseProp=function(){return this.serverResponse_},e.prototype.setServerResponseProp=function(e){this.serverResponse_=e},Object.defineProperty(e.prototype,"name",{get:function(){return this.name_},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"code",{get:function(){return this.code_},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"message",{get:function(){return this.message_},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"serverResponse",{get:function(){return this.serverResponse_},enumerable:!0,configurable:!0}),e}(),m={UNKNOWN:"unknown",OBJECT_NOT_FOUND:"object-not-found",BUCKET_NOT_FOUND:"bucket-not-found",PROJECT_NOT_FOUND:"project-not-found",QUOTA_EXCEEDED:"quota-exceeded",UNAUTHENTICATED:"unauthenticated",UNAUTHORIZED:"unauthorized",RETRY_LIMIT_EXCEEDED:"retry-limit-exceeded",INVALID_CHECKSUM:"invalid-checksum",CANCELED:"canceled",INVALID_EVENT_NAME:"invalid-event-name",INVALID_URL:"invalid-url",INVALID_DEFAULT_BUCKET:"invalid-default-bucket",NO_DEFAULT_BUCKET:"no-default-bucket",CANNOT_SLICE_BLOB:"cannot-slice-blob",SERVER_FILE_WRONG_SIZE:"server-file-wrong-size",NO_DOWNLOAD_URL:"no-download-url",INVALID_ARGUMENT:"invalid-argument",INVALID_ARGUMENT_COUNT:"invalid-argument-count",APP_DELETED:"app-deleted",INVALID_ROOT_OPERATION:"invalid-root-operation",INVALID_FORMAT:"invalid-format",INTERNAL_ERROR:"internal-error"};function r(e){return"storage/"+e}function u(){return new b(m.UNKNOWN,"An unknown error occurred, please check the error payload for server response.")}function c(){return new b(m.CANCELED,"User canceled the upload/download.")}function y(){return new b(m.CANNOT_SLICE_BLOB,"Cannot slice blob for upload. Please retry the upload.")}function p(e,t,r){return new b(m.INVALID_ARGUMENT,"Invalid argument in `"+t+"` at index "+e+": "+r)}function l(){return new b(m.APP_DELETED,"The Firebase app was deleted.")}function h(e,t){return new b(m.INVALID_FORMAT,"String does not match format '"+e+"': "+t)}function i(e){throw new b(m.INTERNAL_ERROR,"Internal error: "+e)}var d={RAW:"raw",BASE64:"base64",BASE64URL:"base64url",DATA_URL:"data_url"};function a(e){switch(e){case d.RAW:case d.BASE64:case d.BASE64URL:case d.DATA_URL:return;default:throw"Expected one of the event types: ["+d.RAW+", "+d.BASE64+", "+d.BASE64URL+", "+d.DATA_URL+"]."}}var n=function(e,t){this.data=e,this.contentType=t||null};function _(e,t){switch(e){case d.RAW:return new n(o(t));case d.BASE64:case d.BASE64URL:return new n(s(e,t));case d.DATA_URL:return new n((r=new v(t)).base64?s(d.BASE64,r.rest):function(e){var t;try{t=decodeURIComponent(e)}catch(e){throw h(d.DATA_URL,"Malformed data URL.")}return o(t)}(r.rest),new v(t).contentType)}var r;throw u()}function o(e){for(var t=[],r=0;r<e.length;r++){var n=e.charCodeAt(r);if(n<=127)t.push(n);else if(n<=2047)t.push(192|n>>6,128|63&n);else if(55296==(64512&n))if(r<e.length-1&&56320==(64512&e.charCodeAt(r+1)))n=65536|(1023&n)<<10|1023&e.charCodeAt(++r),t.push(240|n>>18,128|n>>12&63,128|n>>6&63,128|63&n);else t.push(239,191,189);else 56320==(64512&n)?t.push(239,191,189):t.push(224|n>>12,128|n>>6&63,128|63&n)}return new Uint8Array(t)}function s(t,e){switch(t){case d.BASE64:var r=-1!==e.indexOf("-"),n=-1!==e.indexOf("_");if(r||n)throw h(t,"Invalid character '"+(r?"-":"_")+"' found: is it base64url encoded?");break;case d.BASE64URL:var o=-1!==e.indexOf("+"),i=-1!==e.indexOf("/");if(o||i)throw h(t,"Invalid character '"+(o?"+":"/")+"' found: is it base64 encoded?");e=e.replace(/-/g,"+").replace(/_/g,"/")}var a;try{a=atob(e)}catch(e){throw h(t,"Invalid character found")}for(var s=new Uint8Array(a.length),u=0;u<a.length;u++)s[u]=a.charCodeAt(u);return s}var v=function(e){this.base64=!1,this.contentType=null;var t=e.match(/^data:([^,]+)?,/);if(null===t)throw h(d.DATA_URL,"Must be formatted 'data:[<mediatype>][;base64],<data>");var r,n,o=t[1]||null;null!=o&&(this.base64=(n=";base64",(r=o).length>=n.length&&r.substring(r.length-n.length)===n),this.contentType=this.base64?o.substring(0,o.length-";base64".length):o),this.rest=e.substring(e.indexOf(",")+1)};var g,e,R={STATE_CHANGED:"state_changed"},w="running",T="pausing",E="paused",U="success",O="canceling",k="canceled",A="error",t={RUNNING:"running",PAUSED:"paused",SUCCESS:"success",CANCELED:"canceled",ERROR:"error"};function C(e){switch(e){case w:case T:case O:return t.RUNNING;case E:return t.PAUSED;case U:return t.SUCCESS;case k:return t.CANCELED;case A:default:return t.ERROR}}function S(e,t){for(var r in e)n=e,o=r,Object.prototype.hasOwnProperty.call(n,o)&&t(r,e[r]);var n,o}function N(e){if(null==e)return{};var r={};return S(e,function(e,t){r[e]=t}),r}function x(e){return new Promise(e)}function L(e){return Promise.resolve(e)}function P(e){return null!=e}function I(e){return void 0!==e}function D(e){return"function"==typeof e}function M(e){return"object"==typeof e}function W(e){return"string"==typeof e||e instanceof String}function B(e){return j()&&e instanceof Blob}function j(){return"undefined"!=typeof Blob}(e=g||(g={}))[e.NO_ERROR=0]="NO_ERROR",e[e.NETWORK_ERROR=1]="NETWORK_ERROR",e[e.ABORT=2]="ABORT";var q=function(){function e(){var r=this;this.sent_=!1,this.xhr_=new XMLHttpRequest,this.errorCode_=g.NO_ERROR,this.sendPromise_=x(function(t,e){r.xhr_.addEventListener("abort",function(e){r.errorCode_=g.ABORT,t(r)}),r.xhr_.addEventListener("error",function(e){r.errorCode_=g.NETWORK_ERROR,t(r)}),r.xhr_.addEventListener("load",function(e){t(r)})})}return e.prototype.send=function(e,t,r,n){var o=this;if(this.sent_)throw i("cannot .send() more than once");(this.sent_=!0,this.xhr_.open(t,e,!0),P(n))&&S(n,function(e,t){o.xhr_.setRequestHeader(e,t.toString())});return P(r)?this.xhr_.send(r):this.xhr_.send(),this.sendPromise_},e.prototype.getErrorCode=function(){if(!this.sent_)throw i("cannot .getErrorCode() before sending");return this.errorCode_},e.prototype.getStatus=function(){if(!this.sent_)throw i("cannot .getStatus() before sending");try{return this.xhr_.status}catch(e){return-1}},e.prototype.getResponseText=function(){if(!this.sent_)throw i("cannot .getResponseText() before sending");return this.xhr_.responseText},e.prototype.abort=function(){this.xhr_.abort()},e.prototype.getResponseHeader=function(e){return this.xhr_.getResponseHeader(e)},e.prototype.addUploadProgressListener=function(e){P(this.xhr_.upload)&&this.xhr_.upload.addEventListener("progress",e)},e.prototype.removeUploadProgressListener=function(e){P(this.xhr_.upload)&&this.xhr_.upload.removeEventListener("progress",e)},e}(),F=function(){function e(){}return e.prototype.createXhrIo=function(){return new q},e}();function H(e){var t,r;try{t=JSON.parse(e)}catch(e){return null}return M(r=t)&&!Array.isArray(r)?t:null}var z=function(){function p(e,t){this.bucket=e,this.path_=t}return Object.defineProperty(p.prototype,"path",{get:function(){return this.path_},enumerable:!0,configurable:!0}),p.prototype.fullServerUrl=function(){var e=encodeURIComponent;return"/b/"+e(this.bucket)+"/o/"+e(this.path)},p.prototype.bucketOnlyServerUrl=function(){return"/b/"+encodeURIComponent(this.bucket)+"/o"},p.makeFromBucketSpec=function(t){var e,r;try{e=p.makeFromUrl(t)}catch(e){return new p(t,"")}if(""===e.path)return e;throw r=t,new b(m.INVALID_DEFAULT_BUCKET,"Invalid default bucket '"+r+"'.")},p.makeFromUrl=function(e){var t=null,r="([A-Za-z0-9.\\-_]+)";var n=new RegExp("^gs://"+r+"(/(.*))?$","i");for(var o,i=f.replace(/[.]/g,"\\."),a=[{regex:n,indices:{bucket:1,path:3},postModify:function(e){"/"===e.path.charAt(e.path.length-1)&&(e.path_=e.path_.slice(0,-1))}},{regex:new RegExp("^https?://"+i+"/v[A-Za-z0-9_]+/b/"+r+"/o(/([^?#]*).*)?$","i"),indices:{bucket:1,path:3},postModify:function(e){e.path_=decodeURIComponent(e.path)}}],s=0;s<a.length;s++){var u=a[s],c=u.regex.exec(e);if(c){var l=c[u.indices.bucket],h=c[u.indices.path];h||(h=""),t=new p(l,h),u.postModify(t);break}}if(null==t)throw o=e,new b(m.INVALID_URL,"Invalid URL '"+o+"'.");return t},p}();function G(e){var t=e.lastIndexOf("/",e.length-2);return-1===t?e:e.slice(t+1)}function X(e){return"https://"+f+"/v0"+e}function V(e){var n=encodeURIComponent,o="?";return S(e,function(e,t){var r=n(e)+"="+n(t);o=o+r+"&"}),o=o.slice(0,-1)}function K(e,t){return t}var Z=function(e,t,r,n){this.server=e,this.local=t||e,this.writable=!!r,this.xform=n||K},J=null;function Q(){if(J)return J;var e=[];e.push(new Z("bucket")),e.push(new Z("generation")),e.push(new Z("metageneration")),e.push(new Z("name","fullPath",!0));var t=new Z("name");t.xform=function(e,t){return!W(r=t)||r.length<2?r:G(r=r);var r},e.push(t);var r=new Z("size");return r.xform=function(e,t){return P(t)?+t:t},e.push(r),e.push(new Z("timeCreated")),e.push(new Z("updated")),e.push(new Z("md5Hash",null,!0)),e.push(new Z("cacheControl",null,!0)),e.push(new Z("contentDisposition",null,!0)),e.push(new Z("contentEncoding",null,!0)),e.push(new Z("contentLanguage",null,!0)),e.push(new Z("contentType",null,!0)),e.push(new Z("metadata","customMetadata",!0)),J=e}function Y(e,t,r){for(var n,o,i={type:"file"},a=r.length,s=0;s<a;s++){var u=r[s];i[u.local]=u.xform(i,t[u.server])}return n=i,o=e,Object.defineProperty(n,"ref",{get:function(){var e=n.bucket,t=n.fullPath,r=new z(e,t);return o.makeStorageReference(r)}}),i}function $(e,t,r){var n=H(t);return null===n?null:Y(e,n,r)}function ee(e,t){for(var r={},n=t.length,o=0;o<n;o++){var i=t[o];i.writable&&(r[i.server]=e[i.local])}return JSON.stringify(r)}function te(e){var t;if(!(e&&M(e)))throw"Expected Metadata object.";for(var r in e){var n=e[r];if("customMetadata"===r){if(!M(n))throw"Expected object for 'customMetadata' mapping."}else if(M(t=n)&&null!==t)throw"Mapping for '"+r+"' cannot be an object."}}function re(t,e,r){for(var n=e.length,o=e.length,i=0;i<e.length;i++)if(e[i].optional){n=i;break}var a,s,u,c,l,h;if(!(n<=r.length&&r.length<=o))throw a=n,s=o,u=t,c=r.length,h=a===s?1===(l=a)?"argument":"arguments":(l="between "+a+" and "+s,"arguments"),new b(m.INVALID_ARGUMENT_COUNT,"Invalid argument count in `"+u+"`: Expected "+l+" "+h+", received "+c+".");for(i=0;i<r.length;i++)try{e[i].validator(r[i])}catch(e){throw e instanceof Error?p(i,t,e.message):p(i,t,e)}}var ne=function(t,e){var r=this;this.validator=function(e){r.optional&&!I(e)||t(e)},this.optional=!!e};function oe(e,t){function r(e){if(!W(e))throw"Expected string."}var n,o,i;return n=e?(o=r,i=e,function(e){o(e),i(e)}):r,new ne(n,t)}function ie(e){return new ne(te,e)}function ae(){return new ne(function(e){var t;if(!(("number"==typeof(t=e)||t instanceof Number)&&0<=e))throw"Expected a number 0 or greater."})}function se(t,e){return new ne(function(e){if(!(null===e||P(e)&&e instanceof Object))throw"Expected an Object.";null!=t&&t(e)},e)}function ue(e){return new ne(function(e){if(null!==e&&!D(e))throw"Expected a Function."},e)}function ce(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var r="undefined"!=typeof BlobBuilder?BlobBuilder:"undefined"!=typeof WebKitBlobBuilder?WebKitBlobBuilder:void 0;if(void 0!==r){for(var n=new r,o=0;o<e.length;o++)n.append(e[o]);return n.getBlob()}if(j())return new Blob(e);throw Error("This browser doesn't seem to support creating Blobs")}var le=function(){function s(e,t){var r=0,n="";B(e)?(r=(this.data_=e).size,n=e.type):e instanceof ArrayBuffer?(t?this.data_=new Uint8Array(e):(this.data_=new Uint8Array(e.byteLength),this.data_.set(new Uint8Array(e))),r=this.data_.length):e instanceof Uint8Array&&(t?this.data_=e:(this.data_=new Uint8Array(e.length),this.data_.set(e)),r=e.length),this.size_=r,this.type_=n}return s.prototype.size=function(){return this.size_},s.prototype.type=function(){return this.type_},s.prototype.slice=function(e,t){if(B(this.data_)){var r=this.data_,n=(i=e,a=t,(o=r).webkitSlice?o.webkitSlice(i,a):o.mozSlice?o.mozSlice(i,a):o.slice?o.slice(i,a):null);return null===n?null:new s(n)}var o,i,a;return new s(new Uint8Array(this.data_.buffer,e,t-e),!0)},s.getBlob=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];if(j()){var r=e.map(function(e){return e instanceof s?e.data_:e});return new s(ce.apply(null,r))}var n=e.map(function(e){return W(e)?_(d.RAW,e).data:e.data_}),o=0;n.forEach(function(e){o+=e.byteLength});var i=new Uint8Array(o),a=0;return n.forEach(function(e){for(var t=0;t<e.length;t++)i[a++]=e[t]}),new s(i,!0)},s.prototype.uploadData=function(){return this.data_},s}();function he(e,t){return-1!==e.indexOf(t)}var pe=function(e,t,r,n){this.url=e,this.method=t,this.handler=r,this.timeout=n,this.urlParams={},this.headers={},this.body=null,this.errorHandler=null,this.progressCallback=null,this.successCodes=[200],this.additionalRetryCodes=[]};function fe(e){if(!e)throw u()}function de(n,o){return function(e,t){var r=$(n,t,o);return fe(null!==r),r}}function _e(n,o){return function(e,t){var r=$(n,t,o);return fe(null!==r),function(n,e){var t=H(e);if(null===t)return null;if(!W(t.downloadTokens))return null;var r=t.downloadTokens;if(0===r.length)return null;var o=encodeURIComponent;return r.split(",").map(function(e){var t=n.bucket,r=n.fullPath;return X("/b/"+o(t)+"/o/"+o(r))+V({alt:"media",token:e})})[0]}(r,t)}}function ve(i){return function(e,t){var r,n,o;return(r=401===e.getStatus()?new b(m.UNAUTHENTICATED,"User is not authenticated, please authenticate using Firebase Authentication and try again."):402===e.getStatus()?(o=i.bucket,new b(m.QUOTA_EXCEEDED,"Quota for bucket '"+o+"' exceeded, please view quota on https://firebase.google.com/pricing/.")):403===e.getStatus()?(n=i.path,new b(m.UNAUTHORIZED,"User does not have permission to access '"+n+"'.")):t).setServerResponseProp(t.serverResponseProp()),r}}function be(o){var i=ve(o);return function(e,t){var r,n=i(e,t);return 404===e.getStatus()&&(r=o.path,n=new b(m.OBJECT_NOT_FOUND,"Object '"+r+"' does not exist.")),n.setServerResponseProp(t.serverResponseProp()),n}}function me(e,t,r){var n=X(t.fullServerUrl()),o=e.maxOperationRetryTime(),i=new pe(n,"GET",de(e,r),o);return i.errorHandler=be(t),i}function ye(e,t,r){var n,o,i=N(r);return i.fullPath=e.path,i.size=t.size(),i.contentType||(i.contentType=(o=t,(n=null)&&n.contentType||o&&o.type()||"application/octet-stream")),i}var ge=function(e,t,r,n){this.current=e,this.total=t,this.finalized=!!r,this.metadata=n||null};function Re(e,t){var r;try{r=e.getResponseHeader("X-Goog-Upload-Status")}catch(e){fe(!1)}return fe(he(t||["active"],r)),r}function we(e,a,t,s,r,u,n,o){var c=new ge(0,0);if(c.total=n?(c.current=n.current,n.total):(c.current=0,s.size()),s.size()!==c.total)throw new b(m.SERVER_FILE_WRONG_SIZE,"Server recorded incorrect upload file size, please retry the upload.");var i=c.total-c.current,l=i;0<r&&(l=Math.min(l,r));var h=c.current,p=h+l,f={"X-Goog-Upload-Command":l===i?"upload, finalize":"upload","X-Goog-Upload-Offset":c.current},d=s.slice(h,p);if(null===d)throw y();var _=a.maxUploadRetryTime(),v=new pe(t,"POST",function(e,t){var r,n=Re(e,["active","final"]),o=c.current+l,i=s.size();return r="final"===n?de(a,u)(e,t):null,new ge(o,i,"final"===n,r)},_);return v.headers=f,v.body=d.uploadData(),v.progressCallback=o||null,v.errorHandler=ve(e),v}var Te=function(e,t,r){if(D(e)||P(t)||P(r))this.next=e,this.error=t||null,this.complete=r||null;else{var n=e;this.next=n.next||null,this.error=n.error||null,this.complete=n.complete||null}},Ee=function(e,t,r,n,o,i){this.bytesTransferred=e,this.totalBytes=t,this.state=r,this.metadata=n,this.task=o,this.ref=i};function Ue(r){return function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];L(!0).then(function(){r.apply(null,e)})}}var Oe=function(){function e(e,t,r,n,o,i){void 0===i&&(i=null);var a=this;this.transferred_=0,this.needToFetchStatus_=!1,this.needToFetchMetadata_=!1,this.observers_=[],this.error_=null,this.uploadUrl_=null,this.request_=null,this.chunkMultiplier_=1,this.resolve_=null,this.reject_=null,this.ref_=e,this.authWrapper_=t,this.location_=r,this.blob_=o,this.metadata_=i,this.mappings_=n,this.resumable_=this.shouldDoResumable_(this.blob_),this.state_=w,this.errorHandler_=function(e){a.request_=null,a.chunkMultiplier_=1,e.codeEquals(m.CANCELED)?(a.needToFetchStatus_=!0,a.completeTransitions_()):(a.error_=e,a.transition_(A))},this.metadataErrorHandler_=function(e){a.request_=null,e.codeEquals(m.CANCELED)?a.completeTransitions_():(a.error_=e,a.transition_(A))},this.promise_=x(function(e,t){a.resolve_=e,a.reject_=t,a.start_()}),this.promise_.then(null,function(){})}return e.prototype.makeProgressCallback_=function(){var r=this,n=this.transferred_;return function(e,t){r.updateProgress_(n+e)}},e.prototype.shouldDoResumable_=function(e){return 262144<e.size()},e.prototype.start_=function(){this.state_===w&&null===this.request_&&(this.resumable_?null===this.uploadUrl_?this.createResumable_():this.needToFetchStatus_?this.fetchStatus_():this.needToFetchMetadata_?this.fetchMetadata_():this.continueUpload_():this.oneShotUpload_())},e.prototype.resolveToken_=function(t){var r=this;this.authWrapper_.getAuthToken().then(function(e){switch(r.state_){case w:t(e);break;case O:r.transition_(k);break;case T:r.transition_(E)}})},e.prototype.createResumable_=function(){var v=this;this.resolveToken_(function(e){var t,r,n,o,i,a,s,u,c,l,h,p,f,d=(t=v.authWrapper_,r=v.location_,n=v.mappings_,o=v.blob_,i=v.metadata_,a=r.bucketOnlyServerUrl(),s=ye(r,o,i),u={name:s.fullPath},c=X(a),l={"X-Goog-Upload-Protocol":"resumable","X-Goog-Upload-Command":"start","X-Goog-Upload-Header-Content-Length":o.size(),"X-Goog-Upload-Header-Content-Type":s.contentType,"Content-Type":"application/json; charset=utf-8"},h=ee(s,n),p=t.maxUploadRetryTime(),(f=new pe(c,"POST",function(e,t){var r;Re(e);try{r=e.getResponseHeader("X-Goog-Upload-URL")}catch(e){fe(!1)}return fe(W(r)),r},p)).urlParams=u,f.headers=l,f.body=h,f.errorHandler=ve(r),f),_=v.authWrapper_.makeRequest(d,e);(v.request_=_).getPromise().then(function(e){v.request_=null,v.uploadUrl_=e,v.needToFetchStatus_=!1,v.completeTransitions_()},v.errorHandler_)})},e.prototype.fetchStatus_=function(){var c=this,l=this.uploadUrl_;this.resolveToken_(function(e){var t,r,n,i,o,a,s=(t=c.authWrapper_,r=c.location_,n=l,i=c.blob_,o=t.maxUploadRetryTime(),(a=new pe(n,"POST",function(e,t){var r,n=Re(e,["active","final"]);try{r=e.getResponseHeader("X-Goog-Upload-Size-Received")}catch(e){fe(!1)}var o=parseInt(r,10);return fe(!isNaN(o)),new ge(o,i.size(),"final"===n)},o)).headers={"X-Goog-Upload-Command":"query"},a.errorHandler=ve(r),a),u=c.authWrapper_.makeRequest(s,e);(c.request_=u).getPromise().then(function(e){e=e,c.request_=null,c.updateProgress_(e.current),c.needToFetchStatus_=!1,e.finalized&&(c.needToFetchMetadata_=!0),c.completeTransitions_()},c.errorHandler_)})},e.prototype.continueUpload_=function(){var n=this,o=262144*this.chunkMultiplier_,i=new ge(this.transferred_,this.blob_.size()),a=this.uploadUrl_;this.resolveToken_(function(e){var t;try{t=we(n.location_,n.authWrapper_,a,n.blob_,o,n.mappings_,i,n.makeProgressCallback_())}catch(e){return n.error_=e,void n.transition_(A)}var r=n.authWrapper_.makeRequest(t,e);(n.request_=r).getPromise().then(function(e){n.increaseMultiplier_(),n.request_=null,n.updateProgress_(e.current),e.finalized?(n.metadata_=e.metadata,n.transition_(U)):n.completeTransitions_()},n.errorHandler_)})},e.prototype.increaseMultiplier_=function(){262144*this.chunkMultiplier_<33554432&&(this.chunkMultiplier_*=2)},e.prototype.fetchMetadata_=function(){var n=this;this.resolveToken_(function(e){var t=me(n.authWrapper_,n.location_,n.mappings_),r=n.authWrapper_.makeRequest(t,e);(n.request_=r).getPromise().then(function(e){n.request_=null,n.metadata_=e,n.transition_(U)},n.metadataErrorHandler_)})},e.prototype.oneShotUpload_=function(){var n=this;this.resolveToken_(function(e){var t=function(e,t,r,n,o){var i=t.bucketOnlyServerUrl(),a={"X-Goog-Upload-Protocol":"multipart"},s=function(){for(var e="",t=0;t<2;t++)e+=Math.random().toString().slice(2);return e}();a["Content-Type"]="multipart/related; boundary="+s;var u=ye(t,n,o),c="--"+s+"\r\nContent-Type: application/json; charset=utf-8\r\n\r\n"+ee(u,r)+"\r\n--"+s+"\r\nContent-Type: "+u.contentType+"\r\n\r\n",l="\r\n--"+s+"--",h=le.getBlob(c,n,l);if(null===h)throw y();var p={name:u.fullPath},f=X(i),d=e.maxUploadRetryTime(),_=new pe(f,"POST",de(e,r),d);return _.urlParams=p,_.headers=a,_.body=h.uploadData(),_.errorHandler=ve(t),_}(n.authWrapper_,n.location_,n.mappings_,n.blob_,n.metadata_),r=n.authWrapper_.makeRequest(t,e);(n.request_=r).getPromise().then(function(e){n.request_=null,n.metadata_=e,n.updateProgress_(n.blob_.size()),n.transition_(U)},n.errorHandler_)})},e.prototype.updateProgress_=function(e){var t=this.transferred_;this.transferred_=e,this.transferred_!==t&&this.notifyObservers_()},e.prototype.transition_=function(e){if(this.state_!==e)switch(e){case O:case T:this.state_=e,null!==this.request_&&this.request_.cancel();break;case w:var t=this.state_===E;this.state_=e,t&&(this.notifyObservers_(),this.start_());break;case E:this.state_=e,this.notifyObservers_();break;case k:this.error_=c(),this.state_=e,this.notifyObservers_();break;case A:case U:this.state_=e,this.notifyObservers_()}},e.prototype.completeTransitions_=function(){switch(this.state_){case T:this.transition_(E);break;case O:this.transition_(k);break;case w:this.start_()}},Object.defineProperty(e.prototype,"snapshot",{get:function(){var e=C(this.state_);return new Ee(this.transferred_,this.blob_.size(),e,this.metadata_,this,this.ref_)},enumerable:!0,configurable:!0}),e.prototype.on=function(t,e,r,i){void 0===e&&(e=void 0),void 0===r&&(r=void 0),void 0===i&&(i=void 0);var n="Expected a function or an Object with one of `next`, `error`, `complete` properties.",o=ue(!0).validator,a=se(null,!0).validator;function s(e){try{return void o(e)}catch(e){}try{if(a(e),!(I(e.next)||I(e.error)||I(e.complete)))throw"";return}catch(e){throw n}}re("on",[oe(function(e){if(t!==R.STATE_CHANGED)throw"Expected one of the event types: ["+R.STATE_CHANGED+"]."}),se(s,!0),ue(!0),ue(!0)],arguments);var u=this;function c(o){return function(e,t,r){null!==o&&re("on",o,arguments);var n=new Te(e,t,i);return u.addObserver_(n),function(){u.removeObserver_(n)}}}var l=[se(function(e){if(null===e)throw n;s(e)}),ue(!0),ue(!0)];return!(I(e)||I(r)||I(i))?c(l):c(null)(e,r,i)},e.prototype.then=function(e,t){return this.promise_.then(e,t)},e.prototype.catch=function(e){return this.then(null,e)},e.prototype.addObserver_=function(e){this.observers_.push(e),this.notifyObserver_(e)},e.prototype.removeObserver_=function(e){var t,r,n;t=this.observers_,r=e,-1!==(n=t.indexOf(r))&&t.splice(n,1)},e.prototype.notifyObservers_=function(){var e,t=this;this.finishPromise_(),(e=this.observers_,Array.prototype.slice.call(e)).forEach(function(e){t.notifyObserver_(e)})},e.prototype.finishPromise_=function(){if(null!==this.resolve_){var e=!0;switch(C(this.state_)){case t.SUCCESS:Ue(this.resolve_.bind(null,this.snapshot))();break;case t.CANCELED:case t.ERROR:Ue(this.reject_.bind(null,this.error_))();break;default:e=!1}e&&(this.resolve_=null,this.reject_=null)}},e.prototype.notifyObserver_=function(e){switch(C(this.state_)){case t.RUNNING:case t.PAUSED:null!==e.next&&Ue(e.next.bind(e,this.snapshot))();break;case t.SUCCESS:null!==e.complete&&Ue(e.complete.bind(e))();break;case t.CANCELED:case t.ERROR:null!==e.error&&Ue(e.error.bind(e,this.error_))();break;default:null!==e.error&&Ue(e.error.bind(e,this.error_))()}},e.prototype.resume=function(){re("resume",[],arguments);var e=this.state_===E||this.state_===T;return e&&this.transition_(w),e},e.prototype.pause=function(){re("pause",[],arguments);var e=this.state_===w;return e&&this.transition_(T),e},e.prototype.cancel=function(){re("cancel",[],arguments);var e=this.state_===w||this.state_===T;return e&&this.transition_(O),e},e}(),ke=function(){function r(e,t){this.authWrapper=e,this.location=t instanceof z?t:z.makeFromUrl(t)}return r.prototype.toString=function(){return re("toString",[],arguments),"gs://"+this.location.bucket+"/"+this.location.path},r.prototype.newRef=function(e,t){return new r(e,t)},r.prototype.mappings=function(){return Q()},r.prototype.child=function(e){re("child",[oe()],arguments);var t,r,n=(t=this.location.path,r=e.split("/").filter(function(e){return 0<e.length}).join("/"),0===t.length?r:t+"/"+r),o=new z(this.location.bucket,n);return this.newRef(this.authWrapper,o)},Object.defineProperty(r.prototype,"parent",{get:function(){var e=function(e){if(0==e.length)return null;var t=e.lastIndexOf("/");return-1===t?"":e.slice(0,t)}(this.location.path);if(null===e)return null;var t=new z(this.location.bucket,e);return this.newRef(this.authWrapper,t)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"root",{get:function(){var e=new z(this.location.bucket,"");return this.newRef(this.authWrapper,e)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"bucket",{get:function(){return this.location.bucket},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"fullPath",{get:function(){return this.location.path},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"name",{get:function(){return G(this.location.path)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"storage",{get:function(){return this.authWrapper.service()},enumerable:!0,configurable:!0}),r.prototype.put=function(e,t){return void 0===t&&(t=null),re("put",[new ne(function(e){if(!(e instanceof Uint8Array||e instanceof ArrayBuffer||j()&&e instanceof Blob))throw"Expected Blob or File."}),ie(!0)],arguments),this.throwIfRoot_("put"),new Oe(this,this.authWrapper,this.location,this.mappings(),new le(e),t)},r.prototype.putString=function(e,t,r){void 0===t&&(t=d.RAW),re("putString",[oe(),oe(a,!0),ie(!0)],arguments),this.throwIfRoot_("putString");var n=_(t,e),o=N(r);return!P(o.contentType)&&P(n.contentType)&&(o.contentType=n.contentType),new Oe(this,this.authWrapper,this.location,this.mappings(),new le(n.data,!0),o)},r.prototype.delete=function(){re("delete",[],arguments),this.throwIfRoot_("delete");var s=this;return this.authWrapper.getAuthToken().then(function(e){var t,r,n,o,i,a=(t=s.authWrapper,r=s.location,n=X(r.fullServerUrl()),o=t.maxOperationRetryTime(),(i=new pe(n,"DELETE",function(e,t){},o)).successCodes=[200,204],i.errorHandler=be(r),i);return s.authWrapper.makeRequest(a,e).getPromise()})},r.prototype.getMetadata=function(){re("getMetadata",[],arguments),this.throwIfRoot_("getMetadata");var r=this;return this.authWrapper.getAuthToken().then(function(e){var t=me(r.authWrapper,r.location,r.mappings());return r.authWrapper.makeRequest(t,e).getPromise()})},r.prototype.updateMetadata=function(l){re("updateMetadata",[ie()],arguments),this.throwIfRoot_("updateMetadata");var h=this;return this.authWrapper.getAuthToken().then(function(e){var t,r,n,o,i,a,s,u,c=(t=h.authWrapper,r=h.location,n=l,o=h.mappings(),i=X(r.fullServerUrl()),a=ee(n,o),s=t.maxOperationRetryTime(),(u=new pe(i,"PATCH",de(t,o),s)).headers={"Content-Type":"application/json; charset=utf-8"},u.body=a,u.errorHandler=be(r),u);return h.authWrapper.makeRequest(c,e).getPromise()})},r.prototype.getDownloadURL=function(){re("getDownloadURL",[],arguments),this.throwIfRoot_("getDownloadURL");var u=this;return this.authWrapper.getAuthToken().then(function(e){var t,r,n,o,i,a,s=(t=u.authWrapper,r=u.location,n=u.mappings(),o=X(r.fullServerUrl()),i=t.maxOperationRetryTime(),(a=new pe(o,"GET",_e(t,n),i)).errorHandler=be(r),a);return u.authWrapper.makeRequest(s,e).getPromise().then(function(e){if(null===e)throw new b(m.NO_DOWNLOAD_URL,"The given file does not have any download URLs.");return e})})},r.prototype.throwIfRoot_=function(e){if(""===this.location.path)throw t=e,new b(m.INVALID_ROOT_OPERATION,"The operation '"+t+"' cannot be performed on a root reference, create a non-root reference using child, such as .child('file.png').");var t},r}(),Ae=function(){function e(e){var t;this.promise_=(t=e,Promise.reject(t))}return e.prototype.getPromise=function(){return this.promise_},e.prototype.cancel=function(e){void 0===e&&(e=!1)},e}(),Ce=function(){function e(){this.map_={},this.id_=-9007199254740991}return e.prototype.addRequest=function(e){var t=this.id_;this.id_++,this.map_[t]=e;var r=this;function n(){delete r.map_[t]}e.getPromise().then(n,n)},e.prototype.clear=function(){S(this.map_,function(e,t){t&&t.cancel(!0)}),this.map_={}},e}(),Se=function(){function a(e,t,r,n,o){if(this.bucket_=null,this.deleted_=!1,this.app_=e,null!==this.app_){var i=this.app_.options;P(i)&&(this.bucket_=a.extractBucket_(i))}this.storageRefMaker_=t,this.requestMaker_=r,this.pool_=o,this.service_=n,this.maxOperationRetryTime_=12e4,this.maxUploadRetryTime_=6e4,this.requestMap_=new Ce}return a.extractBucket_=function(e){var t=e.storageBucket||null;return null==t?null:z.makeFromBucketSpec(t).bucket},a.prototype.getAuthToken=function(){return null!==this.app_&&P(this.app_.INTERNAL)&&P(this.app_.INTERNAL.getToken)?this.app_.INTERNAL.getToken().then(function(e){return null!==e?e.accessToken:null},function(e){return null}):L(null)},a.prototype.bucket=function(){if(this.deleted_)throw l();return this.bucket_},a.prototype.service=function(){return this.service_},a.prototype.makeStorageReference=function(e){return this.storageRefMaker_(this,e)},a.prototype.makeRequest=function(e,t){if(this.deleted_)return new Ae(l());var r=this.requestMaker_(e,t,this.pool_);return this.requestMap_.addRequest(r),r},a.prototype.deleteApp=function(){this.deleted_=!0,this.app_=null,this.requestMap_.clear()},a.prototype.maxUploadRetryTime=function(){return this.maxUploadRetryTime_},a.prototype.setMaxUploadRetryTime=function(e){this.maxUploadRetryTime_=e},a.prototype.maxOperationRetryTime=function(){return this.maxOperationRetryTime_},a.prototype.setMaxOperationRetryTime=function(e){this.maxOperationRetryTime_=e},a}();var Ne=function(){function e(e,t,r,n,o,i,a,s,u,c,l){this.pendingXhr_=null,this.backoffId_=null,this.resolve_=null,this.reject_=null,this.canceled_=!1,this.appDelete_=!1,this.url_=e,this.method_=t,this.headers_=r,this.body_=n,this.successCodes_=o.slice(),this.additionalRetryCodes_=i.slice(),this.callback_=a,this.errorCallback_=s,this.progressCallback_=c,this.timeout_=u,this.pool_=l;var h=this;this.promise_=x(function(e,t){h.resolve_=e,h.reject_=t,h.start_()})}return e.prototype.start_=function(){var s=this;function e(e,t){var r,n=s.resolve_,o=s.reject_,i=t.xhr;if(t.wasSuccessCode)try{var a=s.callback_(i,i.getResponseText());I(a)?n(a):n()}catch(e){o(e)}else null!==i?((r=u()).setServerResponseProp(i.getResponseText()),s.errorCallback_?o(s.errorCallback_(i,r)):o(r)):t.canceled?o(r=s.appDelete_?l():c()):o(r=new b(m.RETRY_LIMIT_EXCEEDED,"Max retry time for operation exceeded, please try again."))}this.canceled_?e(0,new xe(!1,null,!0)):this.backoffId_=function(t,e,r){var n=1,o=null,i=!1,a=0;function s(){return 2===a}var u=!1;function c(){u||(u=!0,e.apply(null,arguments))}function l(e){o=setTimeout(function(){o=null,t(h,s())},e)}function h(e){for(var t=[],r=1;r<arguments.length;r++)t[r-1]=arguments[r];u||(e?c.apply(null,arguments):s()||i?c.apply(null,arguments):(n<64&&(n*=2),l(1===a?(a=2,0):1e3*(n+Math.random()))))}var p=!1;function f(e){p||(p=!0,u||(null!==o?(e||(a=2),clearTimeout(o),l(0)):e||(a=1)))}return l(0),setTimeout(function(){f(i=!0)},r),f}(function(i,e){if(e)i(!1,new xe(!1,null,!0));else{var t=s.pool_.createXhrIo();s.pendingXhr_=t,null!==s.progressCallback_&&t.addUploadProgressListener(a),t.send(s.url_,s.method_,s.body_,s.headers_).then(function(e){null!==s.progressCallback_&&e.removeUploadProgressListener(a),s.pendingXhr_=null;var t=(e=e).getErrorCode()===g.NO_ERROR,r=e.getStatus();if(t&&!s.isRetryStatusCode_(r)){var n=he(s.successCodes_,r);i(!0,new xe(n,e))}else{var o=e.getErrorCode()===g.ABORT;i(!1,new xe(!1,null,o))}})}function a(e){var t=e.loaded,r=e.lengthComputable?e.total:-1;null!==s.progressCallback_&&s.progressCallback_(t,r)}},e,this.timeout_)},e.prototype.getPromise=function(){return this.promise_},e.prototype.cancel=function(e){this.canceled_=!0,this.appDelete_=e||!1,null!==this.backoffId_&&(0,this.backoffId_)(!1),null!==this.pendingXhr_&&this.pendingXhr_.abort()},e.prototype.isRetryStatusCode_=function(e){var t=500<=e&&e<600,r=he([408,429],e),n=he(this.additionalRetryCodes_,e);return t||r||n},e}(),xe=function(e,t,r){this.wasSuccessCode=e,this.xhr=t,this.canceled=!!r};function Le(e,t,r){var n,o,i,a,s=V(e.urlParams),u=e.url+s,c=N(e.headers);return n=c,null!==(o=t)&&0<o.length&&(n.Authorization="Firebase "+o),i=c,a=void 0!==We?We.SDK_VERSION:"AppManager",i["X-Firebase-Storage-Version"]="webjs/"+a,new Ne(u,e.method,c,e.body,e.successCodes,e.additionalRetryCodes,e.handler,e.errorHandler,e.timeout,e.progressCallback,r)}var Pe,Ie=function(){function e(e,t,r){if(this.bucket_=null,this.authWrapper_=new Se(e,function(e,t){return new ke(e,t)},Le,this,t),this.app_=e,null!=r)this.bucket_=z.makeFromBucketSpec(r);else{var n=this.authWrapper_.bucket();null!=n&&(this.bucket_=new z(n,""))}this.internals_=new De(this)}return e.prototype.ref=function(e){if(re("ref",[oe(function(e){if(/^[A-Za-z]+:\/\//.test(e))throw"Expected child path but got a URL, use refFromURL instead."},!0)],arguments),null==this.bucket_)throw new Error("No Storage Bucket defined in Firebase Options.");var t=new ke(this.authWrapper_,this.bucket_);return null!=e?t.child(e):t},e.prototype.refFromURL=function(e){return re("refFromURL",[oe(function(e){if(!/^[A-Za-z]+:\/\//.test(e))throw"Expected full URL but got a child path, use ref instead.";try{z.makeFromUrl(e)}catch(e){throw"Expected valid full URL but got an invalid one."}},!1)],arguments),new ke(this.authWrapper_,e)},Object.defineProperty(e.prototype,"maxUploadRetryTime",{get:function(){return this.authWrapper_.maxUploadRetryTime()},enumerable:!0,configurable:!0}),e.prototype.setMaxUploadRetryTime=function(e){re("setMaxUploadRetryTime",[ae()],arguments),this.authWrapper_.setMaxUploadRetryTime(e)},e.prototype.setMaxOperationRetryTime=function(e){re("setMaxOperationRetryTime",[ae()],arguments),this.authWrapper_.setMaxOperationRetryTime(e)},Object.defineProperty(e.prototype,"app",{get:function(){return this.app_},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"INTERNAL",{get:function(){return this.internals_},enumerable:!0,configurable:!0}),e}(),De=function(){function e(e){this.service_=e}return e.prototype.delete=function(){return this.service_.authWrapper_.deleteApp(),L(void 0)},e}();function Me(e,t,r){return new Ie(e,new F,r)}Pe={TaskState:t,TaskEvent:R,StringFormat:d,Storage:Ie,Reference:ke},We.INTERNAL.registerService("storage",Me,Pe,void 0,!0)}).apply(this,arguments)}catch(e){throw console.error(e),new Error("Cannot instantiate firebase-storage - be sure to load firebase-app.js first.")}});
//# sourceMappingURL=firebase-storage.js.map
