/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Implements a set with a count of elements.
 *
 * @template K, V
 */
export declare class CountedSet<K, V> {
    set: {
        [k: string]: V;
    };
    /**
     * @param {!K} item
     * @param {V} val
     */
    add(item: K, val: V): void;
    /**
     * @param {!K} key
     * @return {boolean}
     */
    contains(key: K): any;
    /**
     * @param {!K} item
     * @return {V}
     */
    get(item: K): V | void;
    /**
     * @param {!K} item
     */
    remove(item: K): void;
    /**
     * Deletes everything in the set
     */
    clear(): void;
    /**
     * True if there's nothing in the set
     * @return {boolean}
     */
    isEmpty(): boolean;
    /**
     * @return {number} The number of items in the set
     */
    count(): number;
    /**
     * Run a function on each k,v pair in the set
     * @param {function(K, V)} fn
     */
    each(fn: (k: K, v: V) => void): void;
    /**
     * Mostly for debugging
     * @return {Array.<K>} The keys present in this CountedSet
     */
    keys(): K[];
}
