/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { MaybeDocument } from '../model/document';
import { MutationBatch } from '../model/mutation_batch';
import { JsonProtoSerializer } from '../remote/serializer';
import { DocumentKeySet } from '../model/collections';
import { EncodedResourcePath } from './encoded_resource_path';
import { DbMutationBatch, DbRemoteDocument, DbTarget } from './indexeddb_schema';
import { QueryData } from './query_data';
/** Serializer for values stored in the LocalStore. */
export declare class LocalSerializer {
    private remoteSerializer;
    constructor(remoteSerializer: JsonProtoSerializer);
    /** Decodes a remote document from storage locally to a Document. */
    fromDbRemoteDocument(remoteDoc: DbRemoteDocument): MaybeDocument;
    /** Encodes a document for storage locally. */
    toDbRemoteDocument(maybeDoc: MaybeDocument): DbRemoteDocument;
    private toDbTimestamp;
    private fromDbTimestamp;
    /** Encodes a batch of mutations into a DbMutationBatch for local storage. */
    toDbMutationBatch(userId: string, batch: MutationBatch): DbMutationBatch;
    /** Decodes a DbMutationBatch into a MutationBatch */
    fromDbMutationBatch(dbBatch: DbMutationBatch): MutationBatch;
    toDbResourcePaths(keys: DocumentKeySet): EncodedResourcePath[];
    /** Decodes an array of EncodedResourcePaths into a set of document keys. */
    fromDbResourcePaths(encodedPaths: EncodedResourcePath[]): DocumentKeySet;
    /** Decodes a DbTarget into QueryData */
    fromDbTarget(dbTarget: DbTarget): QueryData;
    /** Encodes QueryData into a DbTarget for storage locally. */
    toDbTarget(queryData: QueryData): DbTarget;
}
