import { _getProvider as t, _removeServiceInstance as n, _registerComponent as e, registerVersion as s } from "@firebase/app";

import { Component as r } from "@firebase/component";

import { Logger as i, LogLevel as o } from "@firebase/logger";

import { base64 as u } from "@firebase/util";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Simple wrapper around a nullable UID. Mostly exists to make code more
 * readable.
 */
class c {
    constructor(t) {
        this.uid = t;
    }
    t() {
        return null != this.uid;
    }
    /**
     * Returns a key representing this user, suitable for inclusion in a
     * dictionary.
     */    i() {
        return this.t() ? "uid:" + this.uid : "anonymous-user";
    }
    isEqual(t) {
        return t.uid === this.uid;
    }
}

/** A user with a null UID. */ c.UNAUTHENTICATED = new c(null), 
// TODO(mikelehen): Look into getting a proper uid-equivalent for
// non-FirebaseAuth providers.
c.o = new c("google-credentials-uid"), c.u = new c("first-party-uid");

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const a = new i("@firebase/firestore");

/**
 * Sets the verbosity of Cloud Firestore logs (debug, error, or silent).
 *
 * @param logLevel - The verbosity you set for activity and error logging. Can
 *   be any of the following values:
 *
 *   <ul>
 *     <li>`debug` for the most verbose logging level, primarily for
 *     debugging.</li>
 *     <li>`error` to log errors only.</li>
 *     <li><code>`silent` to turn off logging.</li>
 *   </ul>
 */ function h(t) {
    a.setLogLevel(t);
}

function l(t, ...n) {
    if (a.logLevel <= o.DEBUG) {
        const e = n.map(_);
        a.debug("Firestore (8.2.5): " + t, ...e);
    }
}

function f(t, ...n) {
    if (a.logLevel <= o.ERROR) {
        const e = n.map(_);
        a.error("Firestore (8.2.5): " + t, ...e);
    }
}

function d(t, ...n) {
    if (a.logLevel <= o.WARN) {
        const e = n.map(_);
        a.warn("Firestore (8.2.5): " + t, ...e);
    }
}

/**
 * Converts an additional log parameter to a string representation.
 */ function _(t) {
    if ("string" == typeof t) return t;
    try {
        return n = t, JSON.stringify(n);
    } catch (n) {
        // Converting to JSON failed, just log the object directly
        return t;
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /** Formats an object as a JSON string, suitable for logging. */
    var n;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Unconditionally fails, throwing an Error with the given message.
 * Messages are stripped in production builds.
 *
 * Returns `never` and can be used in expressions:
 * @example
 * let futureVar = fail('not implemented yet');
 */ function w(t = "Unexpected state") {
    // Log the failure in addition to throw an exception, just in case the
    // exception is swallowed.
    const n = "FIRESTORE (8.2.5) INTERNAL ASSERTION FAILED: " + t;
    // NOTE: We don't use FirestoreError here because these are internal failures
    // that cannot be handled by the user. (Also it would create a circular
    // dependency between the error and assert modules which doesn't work.)
    throw f(n), new Error(n);
}

/**
 * Fails if the given assertion condition is false, throwing an Error with the
 * given message if it did.
 *
 * Messages are stripped in production builds.
 */ function m(t, n) {
    t || w();
}

/**
 * Casts `obj` to `T`. In non-production builds, verifies that `obj` is an
 * instance of `T` before casting.
 */ function p(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
n) {
    return t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const y = "ok", E = "cancelled", I = "unknown", T = "invalid-argument", A = "deadline-exceeded", P = "not-found", R = "already-exists", V = "permission-denied", g = "unauthenticated", v = "resource-exhausted", b = "failed-precondition", N = "aborted", D = "out-of-range", F = "unimplemented", $ = "internal", S = "unavailable", x = "data-loss";

/** An error returned by a Firestore operation. */ class q extends Error {
    /** @hideconstructor */
    constructor(t, n) {
        super(n), this.code = t, this.message = n, this.name = "FirebaseError", 
        // HACK: We write a toString property directly because Error is not a real
        // class and so inheritance does not work correctly. We could alternatively
        // do the same "back-door inheritance" trick that FirebaseError does.
        this.toString = () => `${this.name}: [code=${this.code}]: ${this.message}`;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class O {
    constructor(t, n) {
        this.user = n, this.type = "OAuth", this.h = {}, 
        // Set the headers using Object Literal notation to avoid minification
        this.h.Authorization = "Bearer " + t;
    }
}

/** A CredentialsProvider that always yields an empty token. */ class C {
    constructor() {
        /**
         * Stores the listener registered with setChangeListener()
         * This isn't actually necessary since the UID never changes, but we use this
         * to verify the listen contract is adhered to in tests.
         */
        this.l = null;
    }
    getToken() {
        return Promise.resolve(null);
    }
    _() {}
    m(t) {
        this.l = t, 
        // Fire with initial user.
        t(c.UNAUTHENTICATED);
    }
    p() {
        this.l = null;
    }
}

class L {
    constructor(t) {
        /**
         * The auth token listener registered with FirebaseApp, retained here so we
         * can unregister it.
         */
        this.I = null, 
        /** Tracks the current User. */
        this.currentUser = c.UNAUTHENTICATED, this.T = !1, 
        /**
         * Counter used to detect if the token changed while a getToken request was
         * outstanding.
         */
        this.A = 0, 
        /** The listener registered with setChangeListener(). */
        this.l = null, this.forceRefresh = !1, this.I = () => {
            this.A++, this.currentUser = this.P(), this.T = !0, this.l && this.l(this.currentUser);
        }, this.A = 0, this.auth = t.getImmediate({
            optional: !0
        }), this.auth ? this.auth.addAuthTokenListener(this.I) : (
        // if auth is not available, invoke tokenListener once with null token
        this.I(null), t.get().then((t => {
            this.auth = t, this.I && 
            // tokenListener can be removed by removeChangeListener()
            this.auth.addAuthTokenListener(this.I);
        }), (() => {})));
    }
    getToken() {
        // Take note of the current value of the tokenCounter so that this method
        // can fail (with an ABORTED error) if there is a token change while the
        // request is outstanding.
        const t = this.A, n = this.forceRefresh;
        return this.forceRefresh = !1, this.auth ? this.auth.getToken(n).then((n => 
        // Cancel the request since the token changed while the request was
        // outstanding so the response is potentially for a previous user (which
        // user, we can't be sure).
        this.A !== t ? (l("FirebaseCredentialsProvider", "getToken aborted due to token change."), 
        this.getToken()) : n ? (m("string" == typeof n.accessToken), new O(n.accessToken, this.currentUser)) : null)) : Promise.resolve(null);
    }
    _() {
        this.forceRefresh = !0;
    }
    m(t) {
        this.l = t, 
        // Fire the initial event
        this.T && t(this.currentUser);
    }
    p() {
        this.auth && this.auth.removeAuthTokenListener(this.I), this.I = null, this.l = null;
    }
    // Auth.getUid() can return null even with a user logged in. It is because
    // getUid() is synchronous, but the auth code populating Uid is asynchronous.
    // This method should only be called in the AuthTokenListener callback
    // to guarantee to get the actual user.
    P() {
        const t = this.auth && this.auth.getUid();
        return m(null === t || "string" == typeof t), new c(t);
    }
}

/*
 * FirstPartyToken provides a fresh token each time its value
 * is requested, because if the token is too old, requests will be rejected.
 * Technically this may no longer be necessary since the SDK should gracefully
 * recover from unauthenticated errors (see b/33147818 for context), but it's
 * safer to keep the implementation as-is.
 */ class U {
    constructor(t, n) {
        this.R = t, this.V = n, this.type = "FirstParty", this.user = c.u;
    }
    get h() {
        const t = {
            "X-Goog-AuthUser": this.V
        }, n = this.R.auth.getAuthHeaderValueForFirstParty([]);
        // Use array notation to prevent minification
                return n && (t.Authorization = n), t;
    }
}

/*
 * Provides user credentials required for the Firestore JavaScript SDK
 * to authenticate the user, using technique that is only available
 * to applications hosted by Google.
 */ class j {
    constructor(t, n) {
        this.R = t, this.V = n;
    }
    getToken() {
        return Promise.resolve(new U(this.R, this.V));
    }
    m(t) {
        // Fire with initial uid.
        t(c.u);
    }
    p() {}
    _() {}
}

/**
 * Builds a CredentialsProvider depending on the type of
 * the credentials passed in.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class M {
    /**
     * Constructs a DatabaseInfo using the provided host, databaseId and
     * persistenceKey.
     *
     * @param databaseId - The database to use.
     * @param persistenceKey - A unique identifier for this Firestore's local
     * storage (used in conjunction with the databaseId).
     * @param host - The Firestore backend host to connect to.
     * @param ssl - Whether to use SSL when connecting.
     * @param forceLongPolling - Whether to use the forceLongPolling option
     * when using WebChannel as the network transport.
     * @param autoDetectLongPolling - Whether to use the detectBufferingProxy
     * option when using WebChannel as the network transport.
     */
    constructor(t, n, e, s, r, i) {
        this.g = t, this.persistenceKey = n, this.host = e, this.ssl = s, this.forceLongPolling = r, 
        this.v = i;
    }
}

/** The default database name for a project. */
/** Represents the database ID a Firestore client is associated with. */
class B {
    constructor(t, n) {
        this.projectId = t, this.database = n || "(default)";
    }
    get N() {
        return "(default)" === this.database;
    }
    isEqual(t) {
        return t instanceof B && t.projectId === this.projectId && t.database === this.database;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Path represents an ordered sequence of string segments.
 */
class k {
    constructor(t, n, e) {
        void 0 === n ? n = 0 : n > t.length && w(), void 0 === e ? e = t.length - n : e > t.length - n && w(), 
        this.segments = t, this.offset = n, this.D = e;
    }
    get length() {
        return this.D;
    }
    isEqual(t) {
        return 0 === k.F(this, t);
    }
    child(t) {
        const n = this.segments.slice(this.offset, this.limit());
        return t instanceof k ? t.forEach((t => {
            n.push(t);
        })) : n.push(t), this.$(n);
    }
    /** The index of one past the last segment of the path. */    limit() {
        return this.offset + this.length;
    }
    S(t) {
        return t = void 0 === t ? 1 : t, this.$(this.segments, this.offset + t, this.length - t);
    }
    q() {
        return this.$(this.segments, this.offset, this.length - 1);
    }
    O() {
        return this.segments[this.offset];
    }
    C() {
        return this.get(this.length - 1);
    }
    get(t) {
        return this.segments[this.offset + t];
    }
    L() {
        return 0 === this.length;
    }
    U(t) {
        if (t.length < this.length) return !1;
        for (let n = 0; n < this.length; n++) if (this.get(n) !== t.get(n)) return !1;
        return !0;
    }
    j(t) {
        if (this.length + 1 !== t.length) return !1;
        for (let n = 0; n < this.length; n++) if (this.get(n) !== t.get(n)) return !1;
        return !0;
    }
    forEach(t) {
        for (let n = this.offset, e = this.limit(); n < e; n++) t(this.segments[n]);
    }
    M() {
        return this.segments.slice(this.offset, this.limit());
    }
    static F(t, n) {
        const e = Math.min(t.length, n.length);
        for (let s = 0; s < e; s++) {
            const e = t.get(s), r = n.get(s);
            if (e < r) return -1;
            if (e > r) return 1;
        }
        return t.length < n.length ? -1 : t.length > n.length ? 1 : 0;
    }
}

/**
 * A slash-separated path for navigating resources (documents and collections)
 * within Firestore.
 */ class Q extends k {
    $(t, n, e) {
        return new Q(t, n, e);
    }
    B() {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        return this.M().join("/");
    }
    toString() {
        return this.B();
    }
    /**
     * Creates a resource path from the given slash-delimited string. If multiple
     * arguments are provided, all components are combined. Leading and trailing
     * slashes from all components are ignored.
     */    static k(...t) {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        const n = [];
        for (const e of t) {
            if (e.indexOf("//") >= 0) throw new q(T, `Invalid segment (${e}). Paths must not contain // in them.`);
            // Strip leading and traling slashed.
                        n.push(...e.split("/").filter((t => t.length > 0)));
        }
        return new Q(n);
    }
    static W() {
        return new Q([]);
    }
}

const W = /^[_a-zA-Z][_a-zA-Z0-9]*$/;

/** A dot-separated path for navigating sub-objects within a document. */ class z extends k {
    $(t, n, e) {
        return new z(t, n, e);
    }
    /**
     * Returns true if the string could be used as a segment in a field path
     * without escaping.
     */    static G(t) {
        return W.test(t);
    }
    B() {
        return this.M().map((t => (t = t.replace(/\\/g, "\\\\").replace(/`/g, "\\`"), z.G(t) || (t = "`" + t + "`"), 
        t))).join(".");
    }
    toString() {
        return this.B();
    }
    /**
     * Returns true if this field references the key of a document.
     */    Y() {
        return 1 === this.length && "__name__" === this.get(0);
    }
    /**
     * The field designating the key of a document.
     */    static H() {
        return new z([ "__name__" ]);
    }
    /**
     * Parses a field string from the given server-formatted string.
     *
     * - Splitting the empty string is not allowed (for now at least).
     * - Empty segments within the string (e.g. if there are two consecutive
     *   separators) are not allowed.
     *
     * TODO(b/37244157): we should make this more strict. Right now, it allows
     * non-identifier path components, even if they aren't escaped.
     */    static K(t) {
        const n = [];
        let e = "", s = 0;
        const r = () => {
            if (0 === e.length) throw new q(T, `Invalid field path (${t}). Paths must not be empty, begin with '.', end with '.', or contain '..'`);
            n.push(e), e = "";
        };
        let i = !1;
        for (;s < t.length; ) {
            const n = t[s];
            if ("\\" === n) {
                if (s + 1 === t.length) throw new q(T, "Path has trailing escape character: " + t);
                const n = t[s + 1];
                if ("\\" !== n && "." !== n && "`" !== n) throw new q(T, "Path has invalid escape sequence: " + t);
                e += n, s += 2;
            } else "`" === n ? (i = !i, s++) : "." !== n || i ? (e += n, s++) : (r(), s++);
        }
        if (r(), i) throw new q(T, "Unterminated ` in path: " + t);
        return new z(n);
    }
    static W() {
        return new z([]);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class G {
    constructor(t) {
        this.path = t;
    }
    static J(t) {
        return new G(Q.k(t));
    }
    static Z(t) {
        return new G(Q.k(t).S(5));
    }
    /** Returns true if the document is in the specified collectionId. */    X(t) {
        return this.path.length >= 2 && this.path.get(this.path.length - 2) === t;
    }
    isEqual(t) {
        return null !== t && 0 === Q.F(this.path, t.path);
    }
    toString() {
        return this.path.toString();
    }
    static F(t, n) {
        return Q.F(t.path, n.path);
    }
    static tt(t) {
        return t.length % 2 == 0;
    }
    /**
     * Creates and returns a new document key with the given segments.
     *
     * @param segments - The segments of the path to the document
     * @returns A new instance of DocumentKey
     */    static nt(t) {
        return new G(new Q(t.slice()));
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function Y(t, n, e) {
    if (!e) throw new q(T, `Function ${t}() cannot be called with an empty ${n}.`);
}

/**
 * Validates that two boolean options are not set at the same time.
 */
/**
 * Validates that `path` refers to a document (indicated by the fact it contains
 * an even numbers of segments).
 */
function H(t) {
    if (!G.tt(t)) throw new q(T, `Invalid document reference. Document references must have an even number of segments, but ${t} has ${t.length}.`);
}

/**
 * Validates that `path` refers to a collection (indicated by the fact it
 * contains an odd numbers of segments).
 */ function K(t) {
    if (G.tt(t)) throw new q(T, `Invalid collection reference. Collection references must have an odd number of segments, but ${t} has ${t.length}.`);
}

/**
 * Returns true if it's a non-null object without a custom prototype
 * (i.e. excludes Array, Date, etc.).
 */
/** Returns a string describing the type / value of the provided input. */
function J(t) {
    if (void 0 === t) return "undefined";
    if (null === t) return "null";
    if ("string" == typeof t) return t.length > 20 && (t = t.substring(0, 20) + "..."), 
    JSON.stringify(t);
    if ("number" == typeof t || "boolean" == typeof t) return "" + t;
    if ("object" == typeof t) {
        if (t instanceof Array) return "an array";
        {
            const n = 
            /** Hacky method to try to get the constructor name for an object. */
            function(t) {
                if (t.constructor) {
                    const n = /function\s+([^\s(]+)\s*\(/.exec(t.constructor.toString());
                    if (n && n.length > 1) return n[1];
                }
                return null;
            }
            /**
 * Casts `obj` to `T`, optionally unwrapping Compat types to expose the
 * underlying instance. Throws if  `obj` is not an instance of `T`.
 *
 * This cast is used in the Lite and Full SDK to verify instance types for
 * arguments passed to the public API.
 */ (t);
            return n ? `a custom ${n} object` : "an object";
        }
    }
    return "function" == typeof t ? "a function" : w();
}

function Z(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
n) {
    if ("_delegate" in t && (
    // Unwrap Compat types
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    t = t.et), !(t instanceof n)) {
        if (n.name === t.constructor.name) throw new q(T, "Type does not match the expected instance. Did you pass a reference from a different Firestore SDK?");
        {
            const e = J(t);
            throw new q(T, `Expected type '${n.name}', but it was: ${e}`);
        }
    }
    return t;
}

function X(t, n) {
    if (n <= 0) throw new q(T, `Function ${t}() requires a positive number, but it was: ${n}.`);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns whether a variable is either undefined or null.
 */ function tt(t) {
    return null == t;
}

/** Returns whether the value represents -0. */ function nt(t) {
    // Detect if the value is -0.0. Based on polyfill from
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
    return 0 === t && 1 / t == -1 / 0;
}

/**
 * Returns whether a value is an integer and in the safe integer range
 * @param value - The value to test for being an integer and in the safe range
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const et = {
    BatchGetDocuments: "batchGet",
    Commit: "commit",
    RunQuery: "runQuery"
};

/**
 * Maps RPC names to the corresponding REST endpoint name.
 *
 * We use array notation to avoid mangling.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Error Codes describing the different ways GRPC can fail. These are copied
 * directly from GRPC's sources here:
 *
 * https://github.com/grpc/grpc/blob/bceec94ea4fc5f0085d81235d8e1c06798dc341a/include/grpc%2B%2B/impl/codegen/status_code_enum.h
 *
 * Important! The names of these identifiers matter because the string forms
 * are used for reverse lookups from the webchannel stream. Do NOT change the
 * names of these identifiers or change this into a const enum.
 */
var st, rt;

/**
 * Converts an HTTP Status Code to the equivalent error code.
 *
 * @param status - An HTTP Status Code, like 200, 404, 503, etc.
 * @returns The equivalent Code. Unknown status codes are mapped to
 *     Code.UNKNOWN.
 */
function it(t) {
    if (void 0 === t) return f("RPC_ERROR", "HTTP error has no status"), I;
    // The canonical error codes for Google APIs [1] specify mapping onto HTTP
    // status codes but the mapping is not bijective. In each case of ambiguity
    // this function chooses a primary error.
    
    // [1]
    // https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
        switch (t) {
      case 200:
        // OK
        return y;

      case 400:
        // Bad Request
        return b;

        // Other possibilities based on the forward mapping
        // return Code.INVALID_ARGUMENT;
        // return Code.OUT_OF_RANGE;
              case 401:
        // Unauthorized
        return g;

      case 403:
        // Forbidden
        return V;

      case 404:
        // Not Found
        return P;

      case 409:
        // Conflict
        return N;

        // Other possibilities:
        // return Code.ALREADY_EXISTS;
              case 416:
        // Range Not Satisfiable
        return D;

      case 429:
        // Too Many Requests
        return v;

      case 499:
        // Client Closed Request
        return E;

      case 500:
        // Internal Server Error
        return I;

        // Other possibilities:
        // return Code.INTERNAL;
        // return Code.DATA_LOSS;
              case 501:
        // Unimplemented
        return F;

      case 503:
        // Service Unavailable
        return S;

      case 504:
        // Gateway Timeout
        return A;

      default:
        return t >= 200 && t < 300 ? y : t >= 400 && t < 500 ? b : t >= 500 && t < 600 ? $ : I;
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A Rest-based connection that relies on the native HTTP stack
 * (e.g. `fetch` or a polyfill).
 */ (rt = st || (st = {}))[rt.OK = 0] = "OK", rt[rt.CANCELLED = 1] = "CANCELLED", 
rt[rt.UNKNOWN = 2] = "UNKNOWN", rt[rt.INVALID_ARGUMENT = 3] = "INVALID_ARGUMENT", 
rt[rt.DEADLINE_EXCEEDED = 4] = "DEADLINE_EXCEEDED", rt[rt.NOT_FOUND = 5] = "NOT_FOUND", 
rt[rt.ALREADY_EXISTS = 6] = "ALREADY_EXISTS", rt[rt.PERMISSION_DENIED = 7] = "PERMISSION_DENIED", 
rt[rt.UNAUTHENTICATED = 16] = "UNAUTHENTICATED", rt[rt.RESOURCE_EXHAUSTED = 8] = "RESOURCE_EXHAUSTED", 
rt[rt.FAILED_PRECONDITION = 9] = "FAILED_PRECONDITION", rt[rt.ABORTED = 10] = "ABORTED", 
rt[rt.OUT_OF_RANGE = 11] = "OUT_OF_RANGE", rt[rt.UNIMPLEMENTED = 12] = "UNIMPLEMENTED", 
rt[rt.INTERNAL = 13] = "INTERNAL", rt[rt.UNAVAILABLE = 14] = "UNAVAILABLE", rt[rt.DATA_LOSS = 15] = "DATA_LOSS";

class ot extends 
/**
 * Base class for all Rest-based connections to the backend (WebChannel and
 * HTTP).
 */
class {
    constructor(t) {
        this.st = t, this.g = t.g;
        const n = t.ssl ? "https" : "http";
        this.rt = n + "://" + t.host, this.it = "projects/" + this.g.projectId + "/databases/" + this.g.database + "/documents";
    }
    ot(t, n, e, s) {
        const r = this.ut(t, n);
        l("RestConnection", "Sending: ", r, e);
        const i = {};
        return this.ct(i, s), this.at(t, r, i, e).then((t => (l("RestConnection", "Received: ", t), 
        t)), (n => {
            throw d("RestConnection", t + " failed with error: ", n, "url: ", r, "request:", e), 
            n;
        }));
    }
    ht(t, n, e, s) {
        // The REST API automatically aggregates all of the streamed results, so we
        // can just use the normal invoke() method.
        return this.ot(t, n, e, s);
    }
    /**
     * Modifies the headers for a request, adding any authorization token if
     * present and any additional headers for the request.
     */    ct(t, n) {
        if (t["X-Goog-Api-Client"] = "gl-js/ fire/8.2.5", 
        // Content-Type: text/plain will avoid preflight requests which might
        // mess with CORS and redirects by proxies. If we add custom headers
        // we will need to change this code to potentially use the $httpOverwrite
        // parameter supported by ESF to avoid triggering preflight requests.
        t["Content-Type"] = "text/plain", n) for (const e in n.h) n.h.hasOwnProperty(e) && (t[e] = n.h[e]);
    }
    ut(t, n) {
        const e = et[t];
        return `${this.rt}/v1/${n}:${e}`;
    }
} {
    /**
     * @param databaseInfo - The connection info.
     * @param fetchImpl - `fetch` or a Polyfill that implements the fetch API.
     */
    constructor(t, n) {
        super(t), this.lt = n;
    }
    ft(t, n) {
        throw new Error("Not supported by FetchConnection");
    }
    async at(t, n, e, s) {
        const r = JSON.stringify(s);
        let i;
        try {
            i = await this.lt(n, {
                method: "POST",
                headers: e,
                body: r
            });
        } catch (t) {
            throw new q(it(t.status), "Request failed with error: " + t.statusText);
        }
        if (!i.ok) throw new q(it(i.status), "Request failed with error: " + i.statusText);
        return i.json();
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class ut {
    constructor() {
        this.promise = new Promise(((t, n) => {
            this.resolve = t, this.reject = n;
        }));
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Initializes the HTTP connection for the REST API. */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Generates `nBytes` of random bytes.
 *
 * If `nBytes < 0` , an error will be thrown.
 */
function ct(t) {
    // Polyfills for IE and WebWorker by using `self` and `msCrypto` when `crypto` is not available.
    const n = 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    "undefined" != typeof self && (self.crypto || self.msCrypto), e = new Uint8Array(t);
    if (n && "function" == typeof n.getRandomValues) n.getRandomValues(e); else 
    // Falls back to Math.random
    for (let n = 0; n < t; n++) e[n] = Math.floor(256 * Math.random());
    return e;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class at {
    static dt() {
        // Alphanumeric characters
        const t = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", n = Math.floor(256 / t.length) * t.length;
        // The largest byte value that is a multiple of `char.length`.
                let e = "";
        for (;e.length < 20; ) {
            const s = ct(40);
            for (let r = 0; r < s.length; ++r) 
            // Only accept values that are [0, maxMultiple), this ensures they can
            // be evenly mapped to indices of `chars` via a modulo operation.
            e.length < 20 && s[r] < n && (e += t.charAt(s[r] % t.length));
        }
        return e;
    }
}

function ht(t, n) {
    return t < n ? -1 : t > n ? 1 : 0;
}

/** Helper to compare arrays using isEqual(). */ function lt(t, n, e) {
    return t.length === n.length && t.every(((t, s) => e(t, n[s])));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// The earliest date supported by Firestore timestamps (0001-01-01T00:00:00Z).
/**
 * A `Timestamp` represents a point in time independent of any time zone or
 * calendar, represented as seconds and fractions of seconds at nanosecond
 * resolution in UTC Epoch time.
 *
 * It is encoded using the Proleptic Gregorian Calendar which extends the
 * Gregorian calendar backwards to year one. It is encoded assuming all minutes
 * are 60 seconds long, i.e. leap seconds are "smeared" so that no leap second
 * table is needed for interpretation. Range is from 0001-01-01T00:00:00Z to
 * 9999-12-31T23:59:59.999999999Z.
 *
 * @see https://github.com/google/protobuf/blob/master/src/google/protobuf/timestamp.proto
 */
class ft {
    /**
     * Creates a new timestamp.
     *
     * @param seconds - The number of seconds of UTC time since Unix epoch
     *     1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     *     9999-12-31T23:59:59Z inclusive.
     * @param nanoseconds - The non-negative fractions of a second at nanosecond
     *     resolution. Negative second values with fractions must still have
     *     non-negative nanoseconds values that count forward in time. Must be
     *     from 0 to 999,999,999 inclusive.
     */
    constructor(t, n) {
        if (this.seconds = t, this.nanoseconds = n, n < 0) throw new q(T, "Timestamp nanoseconds out of range: " + n);
        if (n >= 1e9) throw new q(T, "Timestamp nanoseconds out of range: " + n);
        if (t < -62135596800) throw new q(T, "Timestamp seconds out of range: " + t);
        // This will break in the year 10,000.
                if (t >= 253402300800) throw new q(T, "Timestamp seconds out of range: " + t);
    }
    /**
     * Creates a new timestamp with the current date, with millisecond precision.
     *
     * @returns a new timestamp representing the current date.
     */    static now() {
        return ft.fromMillis(Date.now());
    }
    /**
     * Creates a new timestamp from the given date.
     *
     * @param date - The date to initialize the `Timestamp` from.
     * @returns A new `Timestamp` representing the same point in time as the given
     *     date.
     */    static fromDate(t) {
        return ft.fromMillis(t.getTime());
    }
    /**
     * Creates a new timestamp from the given number of milliseconds.
     *
     * @param milliseconds - Number of milliseconds since Unix epoch
     *     1970-01-01T00:00:00Z.
     * @returns A new `Timestamp` representing the same point in time as the given
     *     number of milliseconds.
     */    static fromMillis(t) {
        const n = Math.floor(t / 1e3);
        return new ft(n, 1e6 * (t - 1e3 * n));
    }
    /**
     * Converts a `Timestamp` to a JavaScript `Date` object. This conversion causes
     * a loss of precision since `Date` objects only support millisecond precision.
     *
     * @returns JavaScript `Date` object representing the same point in time as
     *     this `Timestamp`, with millisecond precision.
     */    toDate() {
        return new Date(this.toMillis());
    }
    /**
     * Converts a `Timestamp` to a numeric timestamp (in milliseconds since
     * epoch). This operation causes a loss of precision.
     *
     * @returns The point in time corresponding to this timestamp, represented as
     *     the number of milliseconds since Unix epoch 1970-01-01T00:00:00Z.
     */    toMillis() {
        return 1e3 * this.seconds + this.nanoseconds / 1e6;
    }
    _t(t) {
        return this.seconds === t.seconds ? ht(this.nanoseconds, t.nanoseconds) : ht(this.seconds, t.seconds);
    }
    /**
     * Returns true if this `Timestamp` is equal to the provided one.
     *
     * @param other - The `Timestamp` to compare against.
     * @returns true if this `Timestamp` is equal to the provided one.
     */    isEqual(t) {
        return t.seconds === this.seconds && t.nanoseconds === this.nanoseconds;
    }
    toString() {
        return "Timestamp(seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + ")";
    }
    toJSON() {
        return {
            seconds: this.seconds,
            nanoseconds: this.nanoseconds
        };
    }
    /**
     * Converts this object to a primitive string, which allows Timestamp objects to be compared
     * using the `>`, `<=`, `>=` and `>` operators.
     */    valueOf() {
        // This method returns a string of the form <seconds>.<nanoseconds> where <seconds> is
        // translated to have a non-negative value and both <seconds> and <nanoseconds> are left-padded
        // with zeroes to be a consistent length. Strings with this format then have a lexiographical
        // ordering that matches the expected ordering. The <seconds> translation is done to avoid
        // having a leading negative sign (i.e. a leading '-' character) in its string representation,
        // which would affect its lexiographical ordering.
        const t = this.seconds - -62135596800;
        // Note: Up to 12 decimal digits are required to represent all valid 'seconds' values.
                return String(t).padStart(12, "0") + "." + String(this.nanoseconds).padStart(9, "0");
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A version of a document in Firestore. This corresponds to the version
 * timestamp, such as update_time or read_time.
 */ class dt {
    constructor(t) {
        this.timestamp = t;
    }
    static wt(t) {
        return new dt(t);
    }
    static min() {
        return new dt(new ft(0, 0));
    }
    yt(t) {
        return this.timestamp._t(t.timestamp);
    }
    isEqual(t) {
        return this.timestamp.isEqual(t.timestamp);
    }
    /** Returns a number representation of the version for use in spec tests. */    Et() {
        // Convert to microseconds.
        return 1e6 * this.timestamp.seconds + this.timestamp.nanoseconds / 1e3;
    }
    toString() {
        return "SnapshotVersion(" + this.timestamp.toString() + ")";
    }
    It() {
        return this.timestamp;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function _t(t) {
    let n = 0;
    for (const e in t) Object.prototype.hasOwnProperty.call(t, e) && n++;
    return n;
}

function wt(t, n) {
    for (const e in t) Object.prototype.hasOwnProperty.call(t, e) && n(e, t[e]);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides a set of fields that can be used to partially patch a document.
 * FieldMask is used in conjunction with ObjectValue.
 * Examples:
 *   foo - Overwrites foo entirely with the provided value. If foo is not
 *         present in the companion ObjectValue, the field is deleted.
 *   foo.bar - Overwrites only the field bar of the object foo.
 *             If foo is not an object, foo is replaced with an object
 *             containing foo
 */
class mt {
    constructor(t) {
        this.fields = t, 
        // TODO(dimond): validation of FieldMask
        // Sort the field mask to support `FieldMask.isEqual()` and assert below.
        t.sort(z.F);
    }
    /**
     * Verifies that `fieldPath` is included by at least one field in this field
     * mask.
     *
     * This is an O(n) operation, where `n` is the size of the field mask.
     */    Tt(t) {
        for (const n of this.fields) if (n.U(t)) return !0;
        return !1;
    }
    isEqual(t) {
        return lt(this.fields, t.fields, ((t, n) => t.isEqual(n)));
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// WebSafe uses a different URL-encoding safe alphabet that doesn't match
// the encoding used on the backend.
/** Converts a Base64 encoded string to a binary string. */
function pt(t) {
    return String.fromCharCode.apply(null, 
    // We use `decodeStringToByteArray()` instead of `decodeString()` since
    // `decodeString()` returns Unicode strings, which doesn't match the values
    // returned by `atob()`'s Latin1 representation.
    u.decodeStringToByteArray(t, false));
}

/** Converts a binary string to a Base64 encoded string. */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Immutable class that represents a "proto" byte string.
 *
 * Proto byte strings can either be Base64-encoded strings or Uint8Arrays when
 * sent on the wire. This class abstracts away this differentiation by holding
 * the proto byte string in a common class that must be converted into a string
 * before being sent as a proto.
 */
class yt {
    constructor(t) {
        this.At = t;
    }
    static fromBase64String(t) {
        const n = pt(t);
        return new yt(n);
    }
    static fromUint8Array(t) {
        const n = 
        /**
 * Helper function to convert an Uint8array to a binary string.
 */
        function(t) {
            let n = "";
            for (let e = 0; e < t.length; ++e) n += String.fromCharCode(t[e]);
            return n;
        }
        /**
 * Helper function to convert a binary string to an Uint8Array.
 */ (t);
        return new yt(n);
    }
    toBase64() {
        return function(t) {
            const n = [];
            for (let e = 0; e < t.length; e++) n[e] = t.charCodeAt(e);
            return u.encodeByteArray(n, !1);
        }(this.At);
    }
    toUint8Array() {
        return function(t) {
            const n = new Uint8Array(t.length);
            for (let e = 0; e < t.length; e++) n[e] = t.charCodeAt(e);
            return n;
        }
        /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
        // A RegExp matching ISO 8601 UTC timestamps with optional fraction.
        (this.At);
    }
    Pt() {
        return 2 * this.At.length;
    }
    yt(t) {
        return ht(this.At, t.At);
    }
    isEqual(t) {
        return this.At === t.At;
    }
}

yt.Rt = new yt("");

const Et = new RegExp(/^\d{4}-\d\d-\d\dT\d\d:\d\d:\d\d(?:\.(\d+))?Z$/);

/**
 * Converts the possible Proto values for a timestamp value into a "seconds and
 * nanos" representation.
 */ function It(t) {
    // The json interface (for the browser) will return an iso timestamp string,
    // while the proto js library (for node) will return a
    // google.protobuf.Timestamp instance.
    if (m(!!t), "string" == typeof t) {
        // The date string can have higher precision (nanos) than the Date class
        // (millis), so we do some custom parsing here.
        // Parse the nanos right out of the string.
        let n = 0;
        const e = Et.exec(t);
        if (m(!!e), e[1]) {
            // Pad the fraction out to 9 digits (nanos).
            let t = e[1];
            t = (t + "000000000").substr(0, 9), n = Number(t);
        }
        // Parse the date to get the seconds.
                const s = new Date(t);
        return {
            seconds: Math.floor(s.getTime() / 1e3),
            nanos: n
        };
    }
    return {
        seconds: Tt(t.seconds),
        nanos: Tt(t.nanos)
    };
}

/**
 * Converts the possible Proto types for numbers into a JavaScript number.
 * Returns 0 if the value is not numeric.
 */ function Tt(t) {
    // TODO(bjornick): Handle int64 greater than 53 bits.
    return "number" == typeof t ? t : "string" == typeof t ? Number(t) : 0;
}

/** Converts the possible Proto types for Blobs into a ByteString. */ function At(t) {
    return "string" == typeof t ? yt.fromBase64String(t) : yt.fromUint8Array(t);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents a locally-applied ServerTimestamp.
 *
 * Server Timestamps are backed by MapValues that contain an internal field
 * `__type__` with a value of `server_timestamp`. The previous value and local
 * write time are stored in its `__previous_value__` and `__local_write_time__`
 * fields respectively.
 *
 * Notes:
 * - ServerTimestampValue instances are created as the result of applying a
 *   transform. They can only exist in the local view of a document. Therefore
 *   they do not need to be parsed or serialized.
 * - When evaluated locally (e.g. for snapshot.data()), they by default
 *   evaluate to `null`. This behavior can be configured by passing custom
 *   FieldValueOptions to value().
 * - With respect to other ServerTimestampValues, they sort by their
 *   localWriteTime.
 */ function Pt(t) {
    var n, e;
    return "server_timestamp" === (null === (e = ((null === (n = null == t ? void 0 : t.mapValue) || void 0 === n ? void 0 : n.fields) || {}).__type__) || void 0 === e ? void 0 : e.stringValue);
}

/**
 * Returns the value of the field before this ServerTimestamp was set.
 *
 * Preserving the previous values allows the user to display the last resoled
 * value until the backend responds with the timestamp.
 */ function Rt(t) {
    const n = t.mapValue.fields.__previous_value__;
    return Pt(n) ? Rt(n) : n;
}

/**
 * Returns the local time at which this timestamp was first set.
 */ function Vt(t) {
    const n = It(t.mapValue.fields.__local_write_time__.timestampValue);
    return new ft(n.seconds, n.nanos);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Extracts the backend's type order for the provided value. */ function gt(t) {
    return "nullValue" in t ? 0 /* NullValue */ : "booleanValue" in t ? 1 /* BooleanValue */ : "integerValue" in t || "doubleValue" in t ? 2 /* NumberValue */ : "timestampValue" in t ? 3 /* TimestampValue */ : "stringValue" in t ? 5 /* StringValue */ : "bytesValue" in t ? 6 /* BlobValue */ : "referenceValue" in t ? 7 /* RefValue */ : "geoPointValue" in t ? 8 /* GeoPointValue */ : "arrayValue" in t ? 9 /* ArrayValue */ : "mapValue" in t ? Pt(t) ? 4 /* ServerTimestampValue */ : 10 /* ObjectValue */ : w();
}

/** Tests `left` and `right` for equality based on the backend semantics. */ function vt(t, n) {
    const e = gt(t);
    if (e !== gt(n)) return !1;
    switch (e) {
      case 0 /* NullValue */ :
        return !0;

      case 1 /* BooleanValue */ :
        return t.booleanValue === n.booleanValue;

      case 4 /* ServerTimestampValue */ :
        return Vt(t).isEqual(Vt(n));

      case 3 /* TimestampValue */ :
        return function(t, n) {
            if ("string" == typeof t.timestampValue && "string" == typeof n.timestampValue && t.timestampValue.length === n.timestampValue.length) 
            // Use string equality for ISO 8601 timestamps
            return t.timestampValue === n.timestampValue;
            const e = It(t.timestampValue), s = It(n.timestampValue);
            return e.seconds === s.seconds && e.nanos === s.nanos;
        }(t, n);

      case 5 /* StringValue */ :
        return t.stringValue === n.stringValue;

      case 6 /* BlobValue */ :
        return function(t, n) {
            return At(t.bytesValue).isEqual(At(n.bytesValue));
        }(t, n);

      case 7 /* RefValue */ :
        return t.referenceValue === n.referenceValue;

      case 8 /* GeoPointValue */ :
        return function(t, n) {
            return Tt(t.geoPointValue.latitude) === Tt(n.geoPointValue.latitude) && Tt(t.geoPointValue.longitude) === Tt(n.geoPointValue.longitude);
        }(t, n);

      case 2 /* NumberValue */ :
        return function(t, n) {
            if ("integerValue" in t && "integerValue" in n) return Tt(t.integerValue) === Tt(n.integerValue);
            if ("doubleValue" in t && "doubleValue" in n) {
                const e = Tt(t.doubleValue), s = Tt(n.doubleValue);
                return e === s ? nt(e) === nt(s) : isNaN(e) && isNaN(s);
            }
            return !1;
        }(t, n);

      case 9 /* ArrayValue */ :
        return lt(t.arrayValue.values || [], n.arrayValue.values || [], vt);

      case 10 /* ObjectValue */ :
        return function(t, n) {
            const e = t.mapValue.fields || {}, s = n.mapValue.fields || {};
            if (_t(e) !== _t(s)) return !1;
            for (const t in e) if (e.hasOwnProperty(t) && (void 0 === s[t] || !vt(e[t], s[t]))) return !1;
            return !0;
        }
        /** Returns true if the ArrayValue contains the specified element. */ (t, n);

      default:
        return w();
    }
}

function bt(t, n) {
    return void 0 !== (t.values || []).find((t => vt(t, n)));
}

function Nt(t, n) {
    const e = gt(t), s = gt(n);
    if (e !== s) return ht(e, s);
    switch (e) {
      case 0 /* NullValue */ :
        return 0;

      case 1 /* BooleanValue */ :
        return ht(t.booleanValue, n.booleanValue);

      case 2 /* NumberValue */ :
        return function(t, n) {
            const e = Tt(t.integerValue || t.doubleValue), s = Tt(n.integerValue || n.doubleValue);
            return e < s ? -1 : e > s ? 1 : e === s ? 0 : 
            // one or both are NaN.
            isNaN(e) ? isNaN(s) ? 0 : -1 : 1;
        }(t, n);

      case 3 /* TimestampValue */ :
        return Dt(t.timestampValue, n.timestampValue);

      case 4 /* ServerTimestampValue */ :
        return Dt(Vt(t), Vt(n));

      case 5 /* StringValue */ :
        return ht(t.stringValue, n.stringValue);

      case 6 /* BlobValue */ :
        return function(t, n) {
            const e = At(t), s = At(n);
            return e.yt(s);
        }(t.bytesValue, n.bytesValue);

      case 7 /* RefValue */ :
        return function(t, n) {
            const e = t.split("/"), s = n.split("/");
            for (let t = 0; t < e.length && t < s.length; t++) {
                const n = ht(e[t], s[t]);
                if (0 !== n) return n;
            }
            return ht(e.length, s.length);
        }(t.referenceValue, n.referenceValue);

      case 8 /* GeoPointValue */ :
        return function(t, n) {
            const e = ht(Tt(t.latitude), Tt(n.latitude));
            if (0 !== e) return e;
            return ht(Tt(t.longitude), Tt(n.longitude));
        }(t.geoPointValue, n.geoPointValue);

      case 9 /* ArrayValue */ :
        return function(t, n) {
            const e = t.values || [], s = n.values || [];
            for (let t = 0; t < e.length && t < s.length; ++t) {
                const n = Nt(e[t], s[t]);
                if (n) return n;
            }
            return ht(e.length, s.length);
        }(t.arrayValue, n.arrayValue);

      case 10 /* ObjectValue */ :
        return function(t, n) {
            const e = t.fields || {}, s = Object.keys(e), r = n.fields || {}, i = Object.keys(r);
            // Even though MapValues are likely sorted correctly based on their insertion
            // order (e.g. when received from the backend), local modifications can bring
            // elements out of order. We need to re-sort the elements to ensure that
            // canonical IDs are independent of insertion order.
            s.sort(), i.sort();
            for (let t = 0; t < s.length && t < i.length; ++t) {
                const n = ht(s[t], i[t]);
                if (0 !== n) return n;
                const o = Nt(e[s[t]], r[i[t]]);
                if (0 !== o) return o;
            }
            return ht(s.length, i.length);
        }
        /** Returns a reference value for the provided database and key. */ (t.mapValue, n.mapValue);

      default:
        throw w();
    }
}

function Dt(t, n) {
    if ("string" == typeof t && "string" == typeof n && t.length === n.length) return ht(t, n);
    const e = It(t), s = It(n), r = ht(e.seconds, s.seconds);
    return 0 !== r ? r : ht(e.nanos, s.nanos);
}

function Ft(t, n) {
    return {
        referenceValue: `projects/${t.projectId}/databases/${t.database}/documents/${n.path.B()}`
    };
}

/** Returns true if `value` is an ArrayValue. */ function $t(t) {
    return !!t && "arrayValue" in t;
}

/** Returns true if `value` is a NullValue. */ function St(t) {
    return !!t && "nullValue" in t;
}

/** Returns true if `value` is NaN. */ function xt(t) {
    return !!t && "doubleValue" in t && isNaN(Number(t.doubleValue));
}

/** Returns true if `value` is a MapValue. */ function qt(t) {
    return !!t && "mapValue" in t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An ObjectValue represents a MapValue in the Firestore Proto and offers the
 * ability to add and remove fields (via the ObjectValueBuilder).
 */ class Ot {
    constructor(t) {
        this.proto = t;
    }
    static empty() {
        return new Ot({
            mapValue: {}
        });
    }
    /**
     * Returns the value at the given path or null.
     *
     * @param path - the path to search
     * @returns The value at the path or if there it doesn't exist.
     */    field(t) {
        if (t.L()) return this.proto;
        {
            let n = this.proto;
            for (let e = 0; e < t.length - 1; ++e) {
                if (!n.mapValue.fields) return null;
                if (n = n.mapValue.fields[t.get(e)], !qt(n)) return null;
            }
            return n = (n.mapValue.fields || {})[t.C()], n || null;
        }
    }
    isEqual(t) {
        return vt(this.proto, t.proto);
    }
}

/**
 * An ObjectValueBuilder provides APIs to set and delete fields from an
 * ObjectValue.
 */ class Ct {
    /**
     * @param baseObject - The object to mutate.
     */
    constructor(t = Ot.empty()) {
        this.Vt = t, 
        /** A map that contains the accumulated changes in this builder. */
        this.gt = new Map;
    }
    /**
     * Sets the field to the provided value.
     *
     * @param path - The field path to set.
     * @param value - The value to set.
     * @returns The current Builder instance.
     */    set(t, n) {
        return this.vt(t, n), this;
    }
    /**
     * Removes the field at the specified path. If there is no field at the
     * specified path, nothing is changed.
     *
     * @param path - The field path to remove.
     * @returns The current Builder instance.
     */    delete(t) {
        return this.vt(t, null), this;
    }
    /**
     * Adds `value` to the overlay map at `path`. Creates nested map entries if
     * needed.
     */    vt(t, n) {
        let e = this.gt;
        for (let n = 0; n < t.length - 1; ++n) {
            const s = t.get(n);
            let r = e.get(s);
            r instanceof Map ? 
            // Re-use a previously created map
            e = r : r && 10 /* ObjectValue */ === gt(r) ? (
            // Convert the existing Protobuf MapValue into a map
            r = new Map(Object.entries(r.mapValue.fields || {})), e.set(s, r), e = r) : (
            // Create an empty map to represent the current nesting level
            r = new Map, e.set(s, r), e = r);
        }
        e.set(t.C(), n);
    }
    /** Returns an ObjectValue with all mutations applied. */    bt() {
        const t = this.Nt(z.W(), this.gt);
        return null != t ? new Ot(t) : this.Vt;
    }
    /**
     * Applies any overlays from `currentOverlays` that exist at `currentPath`
     * and returns the merged data at `currentPath` (or null if there were no
     * changes).
     *
     * @param currentPath - The path at the current nesting level. Can be set to
     * FieldValue.emptyPath() to represent the root.
     * @param currentOverlays - The overlays at the current nesting level in the
     * same format as `overlayMap`.
     * @returns The merged data at `currentPath` or null if no modifications
     * were applied.
     */    Nt(t, n) {
        let e = !1;
        const s = this.Vt.field(t), r = qt(s) ? // If there is already data at the current path, base our
        Object.assign({}, s.mapValue.fields) : {};
        return n.forEach(((n, s) => {
            if (n instanceof Map) {
                const i = this.Nt(t.child(s), n);
                null != i && (r[s] = i, e = !0);
            } else null !== n ? (r[s] = n, e = !0) : r.hasOwnProperty(s) && (delete r[s], e = !0);
        })), e ? {
            mapValue: {
                fields: r
            }
        } : null;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The result of a lookup for a given path may be an existing document or a
 * marker that this document does not exist at a given version.
 */ class Lt {
    constructor(t, n) {
        this.key = t, this.version = n;
    }
}

/**
 * Represents a document in Firestore with a key, version, data and whether the
 * data has local mutations applied to it.
 */ class Ut extends Lt {
    constructor(t, n, e, s) {
        super(t, n), this.Dt = e, this.Ft = !!s.Ft, this.hasCommittedMutations = !!s.hasCommittedMutations;
    }
    field(t) {
        return this.Dt.field(t);
    }
    data() {
        return this.Dt;
    }
    $t() {
        return this.Dt.proto;
    }
    isEqual(t) {
        return t instanceof Ut && this.key.isEqual(t.key) && this.version.isEqual(t.version) && this.Ft === t.Ft && this.hasCommittedMutations === t.hasCommittedMutations && this.Dt.isEqual(t.Dt);
    }
    toString() {
        return `Document(${this.key}, ${this.version}, ${this.Dt.toString()}, {hasLocalMutations: ${this.Ft}}), {hasCommittedMutations: ${this.hasCommittedMutations}})`;
    }
    get hasPendingWrites() {
        return this.Ft || this.hasCommittedMutations;
    }
}

/**
 * A class representing a deleted document.
 * Version is set to 0 if we don't point to any specific time, otherwise it
 * denotes time we know it didn't exist at.
 */ class jt extends Lt {
    constructor(t, n, e) {
        super(t, n), this.hasCommittedMutations = !(!e || !e.hasCommittedMutations);
    }
    toString() {
        return `NoDocument(${this.key}, ${this.version})`;
    }
    get hasPendingWrites() {
        return this.hasCommittedMutations;
    }
    isEqual(t) {
        return t instanceof jt && t.hasCommittedMutations === this.hasCommittedMutations && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Visible for testing
class Mt {
    constructor(t, n = null, e = [], s = [], r = null, i = null, o = null) {
        this.path = t, this.collectionGroup = n, this.orderBy = e, this.filters = s, this.limit = r, 
        this.startAt = i, this.endAt = o, this.St = null;
    }
}

/**
 * Initializes a Target with a path and optional additional query constraints.
 * Path must currently be empty if this is a collection group query.
 *
 * NOTE: you should always construct `Target` from `Query.toTarget` instead of
 * using this factory method, because `Query` provides an implicit `orderBy`
 * property.
 */ function Bt(t, n = null, e = [], s = [], r = null, i = null, o = null) {
    return new Mt(t, n, e, s, r, i, o);
}

class kt extends class {} {
    constructor(t, n, e) {
        super(), this.field = t, this.op = n, this.value = e;
    }
    /**
     * Creates a filter based on the provided arguments.
     */    static create(t, n, e) {
        return t.Y() ? "in" /* IN */ === n || "not-in" /* NOT_IN */ === n ? this.xt(t, n, e) : new Qt(t, n, e) : "array-contains" /* ARRAY_CONTAINS */ === n ? new Yt(t, e) : "in" /* IN */ === n ? new Ht(t, e) : "not-in" /* NOT_IN */ === n ? new Kt(t, e) : "array-contains-any" /* ARRAY_CONTAINS_ANY */ === n ? new Jt(t, e) : new kt(t, n, e);
    }
    static xt(t, n, e) {
        return "in" /* IN */ === n ? new Wt(t, e) : new zt(t, e);
    }
    matches(t) {
        const n = t.field(this.field);
        // Types do not have to match in NOT_EQUAL filters.
                return "!=" /* NOT_EQUAL */ === this.op ? null !== n && this.qt(Nt(n, this.value)) : null !== n && gt(this.value) === gt(n) && this.qt(Nt(n, this.value));
        // Only compare types with matching backend order (such as double and int).
        }
    qt(t) {
        switch (this.op) {
          case "<" /* LESS_THAN */ :
            return t < 0;

          case "<=" /* LESS_THAN_OR_EQUAL */ :
            return t <= 0;

          case "==" /* EQUAL */ :
            return 0 === t;

          case "!=" /* NOT_EQUAL */ :
            return 0 !== t;

          case ">" /* GREATER_THAN */ :
            return t > 0;

          case ">=" /* GREATER_THAN_OR_EQUAL */ :
            return t >= 0;

          default:
            return w();
        }
    }
    Ot() {
        return [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , ">=" /* GREATER_THAN_OR_EQUAL */ , "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ].indexOf(this.op) >= 0;
    }
}

/** Filter that matches on key fields (i.e. '__name__'). */
class Qt extends kt {
    constructor(t, n, e) {
        super(t, n, e), this.key = G.Z(e.referenceValue);
    }
    matches(t) {
        const n = G.F(t.key, this.key);
        return this.qt(n);
    }
}

/** Filter that matches on key fields within an array. */ class Wt extends kt {
    constructor(t, n) {
        super(t, "in" /* IN */ , n), this.keys = Gt("in" /* IN */ , n);
    }
    matches(t) {
        return this.keys.some((n => n.isEqual(t.key)));
    }
}

/** Filter that matches on key fields not present within an array. */ class zt extends kt {
    constructor(t, n) {
        super(t, "not-in" /* NOT_IN */ , n), this.keys = Gt("not-in" /* NOT_IN */ , n);
    }
    matches(t) {
        return !this.keys.some((n => n.isEqual(t.key)));
    }
}

function Gt(t, n) {
    var e;
    return ((null === (e = n.arrayValue) || void 0 === e ? void 0 : e.values) || []).map((t => G.Z(t.referenceValue)));
}

/** A Filter that implements the array-contains operator. */ class Yt extends kt {
    constructor(t, n) {
        super(t, "array-contains" /* ARRAY_CONTAINS */ , n);
    }
    matches(t) {
        const n = t.field(this.field);
        return $t(n) && bt(n.arrayValue, this.value);
    }
}

/** A Filter that implements the IN operator. */ class Ht extends kt {
    constructor(t, n) {
        super(t, "in" /* IN */ , n);
    }
    matches(t) {
        const n = t.field(this.field);
        return null !== n && bt(this.value.arrayValue, n);
    }
}

/** A Filter that implements the not-in operator. */ class Kt extends kt {
    constructor(t, n) {
        super(t, "not-in" /* NOT_IN */ , n);
    }
    matches(t) {
        if (bt(this.value.arrayValue, {
            nullValue: "NULL_VALUE"
        })) return !1;
        const n = t.field(this.field);
        return null !== n && !bt(this.value.arrayValue, n);
    }
}

/** A Filter that implements the array-contains-any operator. */ class Jt extends kt {
    constructor(t, n) {
        super(t, "array-contains-any" /* ARRAY_CONTAINS_ANY */ , n);
    }
    matches(t) {
        const n = t.field(this.field);
        return !(!$t(n) || !n.arrayValue.values) && n.arrayValue.values.some((t => bt(this.value.arrayValue, t)));
    }
}

/**
 * Represents a bound of a query.
 *
 * The bound is specified with the given components representing a position and
 * whether it's just before or just after the position (relative to whatever the
 * query order is).
 *
 * The position represents a logical index position for a query. It's a prefix
 * of values for the (potentially implicit) order by clauses of a query.
 *
 * Bound provides a function to determine whether a document comes before or
 * after a bound. This is influenced by whether the position is just before or
 * just after the provided values.
 */ class Zt {
    constructor(t, n) {
        this.position = t, this.before = n;
    }
}

/**
 * An ordering on a field, in some Direction. Direction defaults to ASCENDING.
 */ class Xt {
    constructor(t, n = "asc" /* ASCENDING */) {
        this.field = t, this.dir = n;
    }
}

function tn(t, n) {
    return t.dir === n.dir && t.field.isEqual(n.field);
}

function nn(t, n) {
    if (null === t) return null === n;
    if (null === n) return !1;
    if (t.before !== n.before || t.position.length !== n.position.length) return !1;
    for (let e = 0; e < t.position.length; e++) {
        if (!vt(t.position[e], n.position[e])) return !1;
    }
    return !0;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Query encapsulates all the query attributes we support in the SDK. It can
 * be run against the LocalStore, as well as be converted to a `Target` to
 * query the RemoteStore results.
 *
 * Visible for testing.
 */ class en {
    /**
     * Initializes a Query with a path and optional additional query constraints.
     * Path must currently be empty if this is a collection group query.
     */
    constructor(t, n = null, e = [], s = [], r = null, i = "F" /* First */ , o = null, u = null) {
        this.path = t, this.collectionGroup = n, this.Ct = e, this.filters = s, this.limit = r, 
        this.limitType = i, this.startAt = o, this.endAt = u, this.Lt = null, 
        // The corresponding `Target` of this `Query` instance.
        this.Ut = null, this.startAt, this.endAt;
    }
}

/** Creates a new Query for a query that matches all documents at `path` */ function sn(t) {
    return !tt(t.limit) && "L" /* Last */ === t.limitType;
}

function rn(t) {
    return t.Ct.length > 0 ? t.Ct[0].field : null;
}

function on(t) {
    for (const n of t.filters) if (n.Ot()) return n.field;
    return null;
}

/**
 * Checks if any of the provided Operators are included in the query and
 * returns the first one that is, or null if none are.
 */
/**
 * Returns whether the query matches a collection group rather than a specific
 * collection.
 */
function un(t) {
    return null !== t.collectionGroup;
}

/**
 * Returns the implicit order by constraint that is used to execute the Query,
 * which can be different from the order by constraints the user provided (e.g.
 * the SDK and backend always orders by `__name__`).
 */ function cn(t) {
    const n = p(t);
    if (null === n.Lt) {
        n.Lt = [];
        const t = on(n), e = rn(n);
        if (null !== t && null === e) 
        // In order to implicitly add key ordering, we must also add the
        // inequality filter field for it to be a valid query.
        // Note that the default inequality field and key ordering is ascending.
        t.Y() || n.Lt.push(new Xt(t)), n.Lt.push(new Xt(z.H(), "asc" /* ASCENDING */)); else {
            let t = !1;
            for (const e of n.Ct) n.Lt.push(e), e.field.Y() && (t = !0);
            if (!t) {
                // The order of the implicit key ordering always matches the last
                // explicit order by
                const t = n.Ct.length > 0 ? n.Ct[n.Ct.length - 1].dir : "asc" /* ASCENDING */;
                n.Lt.push(new Xt(z.H(), t));
            }
        }
    }
    return n.Lt;
}

/**
 * Converts this `Query` instance to it's corresponding `Target` representation.
 */ function an(t) {
    const n = p(t);
    if (!n.Ut) if ("F" /* First */ === n.limitType) n.Ut = Bt(n.path, n.collectionGroup, cn(n), n.filters, n.limit, n.startAt, n.endAt); else {
        // Flip the orderBy directions since we want the last results
        const t = [];
        for (const e of cn(n)) {
            const n = "desc" /* DESCENDING */ === e.dir ? "asc" /* ASCENDING */ : "desc" /* DESCENDING */;
            t.push(new Xt(e.field, n));
        }
        // We need to swap the cursors to match the now-flipped query ordering.
                const e = n.endAt ? new Zt(n.endAt.position, !n.endAt.before) : null, s = n.startAt ? new Zt(n.startAt.position, !n.startAt.before) : null;
        // Now return as a LimitType.First query.
        n.Ut = Bt(n.path, n.collectionGroup, t, n.filters, n.limit, e, s);
    }
    return n.Ut;
}

function hn(t, n) {
    return function(t, n) {
        if (t.limit !== n.limit) return !1;
        if (t.orderBy.length !== n.orderBy.length) return !1;
        for (let e = 0; e < t.orderBy.length; e++) if (!tn(t.orderBy[e], n.orderBy[e])) return !1;
        if (t.filters.length !== n.filters.length) return !1;
        for (let r = 0; r < t.filters.length; r++) if (e = t.filters[r], s = n.filters[r], 
        e.op !== s.op || !e.field.isEqual(s.field) || !vt(e.value, s.value)) return !1;
        var e, s;
        return t.collectionGroup === n.collectionGroup && !!t.path.isEqual(n.path) && !!nn(t.startAt, n.startAt) && nn(t.endAt, n.endAt);
    }(an(t), an(n)) && t.limitType === n.limitType;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns an DoubleValue for `value` that is encoded based the serializer's
 * `useProto3Json` setting.
 */
/**
 * Returns a value for a number that's appropriate to put into a proto.
 * The return value is an IntegerValue if it can safely represent the value,
 * otherwise a DoubleValue is returned.
 */
function ln(t, n) {
    return function(t) {
        return "number" == typeof t && Number.isInteger(t) && !nt(t) && t <= Number.MAX_SAFE_INTEGER && t >= Number.MIN_SAFE_INTEGER;
    }(n) ? 
    /**
 * Returns an IntegerValue for `value`.
 */
    function(t) {
        return {
            integerValue: "" + t
        };
    }(n) : function(t, n) {
        if (t.jt) {
            if (isNaN(n)) return {
                doubleValue: "NaN"
            };
            if (n === 1 / 0) return {
                doubleValue: "Infinity"
            };
            if (n === -1 / 0) return {
                doubleValue: "-Infinity"
            };
        }
        return {
            doubleValue: nt(n) ? "-0" : n
        };
    }(t, n);
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Used to represent a field transform on a mutation. */ class fn {
    constructor() {
        // Make sure that the structural type of `TransformOperation` is unique.
        // See https://github.com/microsoft/TypeScript/issues/5451
        this.Mt = void 0;
    }
}

/** Transforms a value into a server-generated timestamp. */ class dn extends fn {}

/** Transforms an array value via a union operation. */ class _n extends fn {
    constructor(t) {
        super(), this.elements = t;
    }
}

/** Transforms an array value via a remove operation. */ class wn extends fn {
    constructor(t) {
        super(), this.elements = t;
    }
}

/**
 * Implements the backend semantics for locally computed NUMERIC_ADD (increment)
 * transforms. Converts all field values to integers or doubles, but unlike the
 * backend does not cap integer values at 2^63. Instead, JavaScript number
 * arithmetic is used and precision loss can occur for values greater than 2^53.
 */ class mn extends fn {
    constructor(t, n) {
        super(), this.Bt = t, this.kt = n;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** A field path and the TransformOperation to perform upon it. */ class pn {
    constructor(t, n) {
        this.field = t, this.transform = n;
    }
}

/**
 * Encodes a precondition for a mutation. This follows the model that the
 * backend accepts with the special case of an explicit "empty" precondition
 * (meaning no precondition).
 */ class yn {
    constructor(t, n) {
        this.updateTime = t, this.exists = n;
    }
    /** Creates a new empty Precondition. */    static Qt() {
        return new yn;
    }
    /** Creates a new Precondition with an exists flag. */    static exists(t) {
        return new yn(void 0, t);
    }
    /** Creates a new Precondition based on a version a document exists at. */    static updateTime(t) {
        return new yn(t);
    }
    /** Returns whether this Precondition is empty. */    get Wt() {
        return void 0 === this.updateTime && void 0 === this.exists;
    }
    isEqual(t) {
        return this.exists === t.exists && (this.updateTime ? !!t.updateTime && this.updateTime.isEqual(t.updateTime) : !t.updateTime);
    }
}

/**
 * A mutation describes a self-contained change to a document. Mutations can
 * create, replace, delete, and update subsets of documents.
 *
 * Mutations not only act on the value of the document but also its version.
 *
 * For local mutations (mutations that haven't been committed yet), we preserve
 * the existing version for Set and Patch mutations. For Delete mutations, we
 * reset the version to 0.
 *
 * Here's the expected transition table.
 *
 * MUTATION           APPLIED TO            RESULTS IN
 *
 * SetMutation        Document(v3)          Document(v3)
 * SetMutation        NoDocument(v3)        Document(v0)
 * SetMutation        null                  Document(v0)
 * PatchMutation      Document(v3)          Document(v3)
 * PatchMutation      NoDocument(v3)        NoDocument(v3)
 * PatchMutation      null                  null
 * DeleteMutation     Document(v3)          NoDocument(v0)
 * DeleteMutation     NoDocument(v3)        NoDocument(v0)
 * DeleteMutation     null                  NoDocument(v0)
 *
 * For acknowledged mutations, we use the updateTime of the WriteResponse as
 * the resulting version for Set and Patch mutations. As deletes have no
 * explicit update time, we use the commitTime of the WriteResponse for
 * Delete mutations.
 *
 * If a mutation is acknowledged by the backend but fails the precondition check
 * locally, we return an `UnknownDocument` and rely on Watch to send us the
 * updated version.
 *
 * Field transforms are used only with Patch and Set Mutations. We use the
 * `updateTransforms` message to store transforms, rather than the `transforms`s
 * messages.
 *
 * ## Subclassing Notes
 *
 * Subclasses of Mutation need to implement applyToRemoteDocument() and
 * applyToLocalView() to implement the actual behavior of applying the mutation
 * to some source document.
 */ class En {}

/**
 * A mutation that creates or replaces the document at the given key with the
 * object value contents.
 */ class In extends En {
    constructor(t, n, e, s = []) {
        super(), this.key = t, this.value = n, this.zt = e, this.fieldTransforms = s, this.type = 0 /* Set */;
    }
}

/**
 * A mutation that modifies fields of the document at the given key with the
 * given values. The values are applied through a field mask:
 *
 *  * When a field is in both the mask and the values, the corresponding field
 *    is updated.
 *  * When a field is in neither the mask nor the values, the corresponding
 *    field is unmodified.
 *  * When a field is in the mask but not in the values, the corresponding field
 *    is deleted.
 *  * When a field is not in the mask but is in the values, the values map is
 *    ignored.
 */ class Tn extends En {
    constructor(t, n, e, s, r = []) {
        super(), this.key = t, this.data = n, this.Gt = e, this.zt = s, this.fieldTransforms = r, 
        this.type = 1 /* Patch */;
    }
}

/** A mutation that deletes the document at the given key. */ class An extends En {
    constructor(t, n) {
        super(), this.key = t, this.zt = n, this.type = 2 /* Delete */ , this.fieldTransforms = [];
    }
}

/**
 * A mutation that verifies the existence of the document at the given key with
 * the provided precondition.
 *
 * The `verify` operation is only used in Transactions, and this class serves
 * primarily to facilitate serialization into protos.
 */ class Pn extends En {
    constructor(t, n) {
        super(), this.key = t, this.zt = n, this.type = 3 /* Verify */ , this.fieldTransforms = [];
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const Rn = (() => {
    const t = {
        asc: "ASCENDING",
        desc: "DESCENDING"
    };
    return t;
})(), Vn = (() => {
    const t = {
        "<": "LESS_THAN",
        "<=": "LESS_THAN_OR_EQUAL",
        ">": "GREATER_THAN",
        ">=": "GREATER_THAN_OR_EQUAL",
        "==": "EQUAL",
        "!=": "NOT_EQUAL",
        "array-contains": "ARRAY_CONTAINS",
        in: "IN",
        "not-in": "NOT_IN",
        "array-contains-any": "ARRAY_CONTAINS_ANY"
    };
    return t;
})();

/**
 * This class generates JsonObject values for the Datastore API suitable for
 * sending to either GRPC stub methods or via the JSON/HTTP REST API.
 *
 * The serializer supports both Protobuf.js and Proto3 JSON formats. By
 * setting `useProto3Json` to true, the serializer will use the Proto3 JSON
 * format.
 *
 * For a description of the Proto3 JSON format check
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 *
 * TODO(klimt): We can remove the databaseId argument if we keep the full
 * resource name in documents.
 */
class gn {
    constructor(t, n) {
        this.g = t, this.jt = n;
    }
}

/**
 * Returns a value for a number (or null) that's appropriate to put into
 * a google.protobuf.Int32Value proto.
 * DO NOT USE THIS FOR ANYTHING ELSE.
 * This method cheats. It's typed as returning "number" because that's what
 * our generated proto interfaces say Int32Value must be. But GRPC actually
 * expects a { value: <number> } struct.
 */
/**
 * Returns a value for a Date that's appropriate to put into a proto.
 */
function vn(t, n) {
    if (t.jt) {
        return `${new Date(1e3 * n.seconds).toISOString().replace(/\.\d*/, "").replace("Z", "")}.${("000000000" + n.nanoseconds).slice(-9)}Z`;
    }
    return {
        seconds: "" + n.seconds,
        nanos: n.nanoseconds
    };
}

/**
 * Returns a value for bytes that's appropriate to put in a proto.
 *
 * Visible for testing.
 */
function bn(t, n) {
    return t.jt ? n.toBase64() : n.toUint8Array();
}

function Nn(t, n) {
    return vn(t, n.It());
}

function Dn(t) {
    return m(!!t), dt.wt(function(t) {
        const n = It(t);
        return new ft(n.seconds, n.nanos);
    }(t));
}

function Fn(t, n) {
    return function(t) {
        return new Q([ "projects", t.projectId, "databases", t.database ]);
    }(t).child("documents").child(n).B();
}

function $n(t, n) {
    return Fn(t.g, n.path);
}

function Sn(t, n) {
    const e = function(t) {
        const n = Q.k(t);
        return m(Wn(n)), n;
    }(n);
    if (e.get(1) !== t.g.projectId) throw new q(T, "Tried to deserialize key from different project: " + e.get(1) + " vs " + t.g.projectId);
    if (e.get(3) !== t.g.database) throw new q(T, "Tried to deserialize key from different database: " + e.get(3) + " vs " + t.g.database);
    return new G((m((s = e).length > 4 && "documents" === s.get(4)), s.S(5)));
    var s;
    /** Creates a Document proto from key and fields (but no create/update time) */}

function xn(t, n) {
    return Fn(t.g, n);
}

function qn(t) {
    return new Q([ "projects", t.g.projectId, "databases", t.g.database ]).B();
}

function On(t, n, e) {
    return {
        name: $n(t, n),
        fields: e.proto.mapValue.fields
    };
}

function Cn(t, n) {
    return "found" in n ? function(t, n) {
        m(!!n.found), n.found.name, n.found.updateTime;
        const e = Sn(t, n.found.name), s = Dn(n.found.updateTime), r = new Ot({
            mapValue: {
                fields: n.found.fields
            }
        });
        return new Ut(e, s, r, {});
    }(t, n) : "missing" in n ? function(t, n) {
        m(!!n.missing), m(!!n.readTime);
        const e = Sn(t, n.missing), s = Dn(n.readTime);
        return new jt(e, s);
    }(t, n) : w();
}

function Ln(t, n) {
    let e;
    if (n instanceof In) e = {
        update: On(t, n.key, n.value)
    }; else if (n instanceof An) e = {
        delete: $n(t, n.key)
    }; else if (n instanceof Tn) e = {
        update: On(t, n.key, n.data),
        updateMask: Qn(n.Gt)
    }; else {
        if (!(n instanceof Pn)) return w();
        e = {
            verify: $n(t, n.key)
        };
    }
    return n.fieldTransforms.length > 0 && (e.updateTransforms = n.fieldTransforms.map((t => function(t, n) {
        const e = n.transform;
        if (e instanceof dn) return {
            fieldPath: n.field.B(),
            setToServerValue: "REQUEST_TIME"
        };
        if (e instanceof _n) return {
            fieldPath: n.field.B(),
            appendMissingElements: {
                values: e.elements
            }
        };
        if (e instanceof wn) return {
            fieldPath: n.field.B(),
            removeAllFromArray: {
                values: e.elements
            }
        };
        if (e instanceof mn) return {
            fieldPath: n.field.B(),
            increment: e.kt
        };
        throw w();
    }(0, t)))), n.zt.Wt || (e.currentDocument = function(t, n) {
        return void 0 !== n.updateTime ? {
            updateTime: Nn(t, n.updateTime)
        } : void 0 !== n.exists ? {
            exists: n.exists
        } : w();
    }(t, n.zt)), e;
}

function Un(t, n) {
    // Dissect the path into parent, collectionId, and optional key filter.
    const e = {
        structuredQuery: {}
    }, s = n.path;
    null !== n.collectionGroup ? (e.parent = xn(t, s), e.structuredQuery.from = [ {
        collectionId: n.collectionGroup,
        allDescendants: !0
    } ]) : (e.parent = xn(t, s.q()), e.structuredQuery.from = [ {
        collectionId: s.C()
    } ]);
    const r = function(t) {
        if (0 === t.length) return;
        const n = t.map((t => 
        // visible for testing
        function(t) {
            if ("==" /* EQUAL */ === t.op) {
                if (xt(t.value)) return {
                    unaryFilter: {
                        field: kn(t.field),
                        op: "IS_NAN"
                    }
                };
                if (St(t.value)) return {
                    unaryFilter: {
                        field: kn(t.field),
                        op: "IS_NULL"
                    }
                };
            } else if ("!=" /* NOT_EQUAL */ === t.op) {
                if (xt(t.value)) return {
                    unaryFilter: {
                        field: kn(t.field),
                        op: "IS_NOT_NAN"
                    }
                };
                if (St(t.value)) return {
                    unaryFilter: {
                        field: kn(t.field),
                        op: "IS_NOT_NULL"
                    }
                };
            }
            return {
                fieldFilter: {
                    field: kn(t.field),
                    op: Bn(t.op),
                    value: t.value
                }
            };
        }(t)));
        if (1 === n.length) return n[0];
        return {
            compositeFilter: {
                op: "AND",
                filters: n
            }
        };
    }(n.filters);
    r && (e.structuredQuery.where = r);
    const i = function(t) {
        if (0 === t.length) return;
        return t.map((t => 
        // visible for testing
        function(t) {
            return {
                field: kn(t.field),
                direction: Mn(t.dir)
            };
        }(t)));
    }(n.orderBy);
    i && (e.structuredQuery.orderBy = i);
    const o = function(t, n) {
        return t.jt || tt(n) ? n : {
            value: n
        };
    }(t, n.limit);
    return null !== o && (e.structuredQuery.limit = o), n.startAt && (e.structuredQuery.startAt = jn(n.startAt)), 
    n.endAt && (e.structuredQuery.endAt = jn(n.endAt)), e;
}

function jn(t) {
    return {
        before: t.before,
        values: t.position
    };
}

// visible for testing
function Mn(t) {
    return Rn[t];
}

// visible for testing
function Bn(t) {
    return Vn[t];
}

function kn(t) {
    return {
        fieldPath: t.B()
    };
}

function Qn(t) {
    const n = [];
    return t.fields.forEach((t => n.push(t.B()))), {
        fieldPaths: n
    };
}

function Wn(t) {
    // Resource names have at least 4 components (project ID, database ID)
    return t.length >= 4 && "projects" === t.get(0) && "databases" === t.get(2);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function zn(t) {
    return new gn(t, /* useProto3Json= */ !0);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Verifies whether `e` is an IndexedDbTransactionError. */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents an operation scheduled to be run in the future on an AsyncQueue.
 *
 * It is created via DelayedOperation.createAndSchedule().
 *
 * Supports cancellation (via cancel()) and early execution (via skipDelay()).
 *
 * Note: We implement `PromiseLike` instead of `Promise`, as the `Promise` type
 * in newer versions of TypeScript defines `finally`, which is not available in
 * IE.
 */
class Gn {
    constructor(t, n, e, s, r) {
        this.Yt = t, this.Ht = n, this.Kt = e, this.op = s, this.Jt = r, this.Zt = new ut, 
        this.then = this.Zt.promise.then.bind(this.Zt.promise), 
        // It's normal for the deferred promise to be canceled (due to cancellation)
        // and so we attach a dummy catch callback to avoid
        // 'UnhandledPromiseRejectionWarning' log spam.
        this.Zt.promise.catch((t => {}));
    }
    /**
     * Creates and returns a DelayedOperation that has been scheduled to be
     * executed on the provided asyncQueue after the provided delayMs.
     *
     * @param asyncQueue - The queue to schedule the operation on.
     * @param id - A Timer ID identifying the type of operation this is.
     * @param delayMs - The delay (ms) before the operation should be scheduled.
     * @param op - The operation to run.
     * @param removalCallback - A callback to be called synchronously once the
     *   operation is executed or canceled, notifying the AsyncQueue to remove it
     *   from its delayedOperations list.
     *   PORTING NOTE: This exists to prevent making removeDelayedOperation() and
     *   the DelayedOperation class public.
     */    static Xt(t, n, e, s, r) {
        const i = Date.now() + e, o = new Gn(t, n, i, s, r);
        return o.start(e), o;
    }
    /**
     * Starts the timer. This is called immediately after construction by
     * createAndSchedule().
     */    start(t) {
        this.tn = setTimeout((() => this.nn()), t);
    }
    /**
     * Queues the operation to run immediately (if it hasn't already been run or
     * canceled).
     */    en() {
        return this.nn();
    }
    /**
     * Cancels the operation if it hasn't already been executed or canceled. The
     * promise will be rejected.
     *
     * As long as the operation has not yet been run, calling cancel() provides a
     * guarantee that the operation will not be run.
     */    cancel(t) {
        null !== this.tn && (this.clearTimeout(), this.Zt.reject(new q(E, "Operation cancelled" + (t ? ": " + t : ""))));
    }
    nn() {
        this.Yt.sn((() => null !== this.tn ? (this.clearTimeout(), this.op().then((t => this.Zt.resolve(t)))) : Promise.resolve()));
    }
    clearTimeout() {
        null !== this.tn && (this.Jt(this), clearTimeout(this.tn), this.tn = null);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A helper for running delayed tasks following an exponential backoff curve
 * between attempts.
 *
 * Each delay is made up of a "base" delay which follows the exponential
 * backoff curve, and a +/- 50% "jitter" that is calculated and added to the
 * base delay. This prevents clients from accidentally synchronizing their
 * delays causing spikes of load to the backend.
 */
class Yn {
    constructor(
    /**
     * The AsyncQueue to run backoff operations on.
     */
    t, 
    /**
     * The ID to use when scheduling backoff operations on the AsyncQueue.
     */
    n, 
    /**
     * The initial delay (used as the base delay on the first retry attempt).
     * Note that jitter will still be applied, so the actual delay could be as
     * little as 0.5*initialDelayMs.
     */
    e = 1e3
    /**
     * The multiplier to use to determine the extended base delay after each
     * attempt.
     */ , s = 1.5
    /**
     * The maximum base delay after which no further backoff is performed.
     * Note that jitter will still be applied, so the actual delay could be as
     * much as 1.5*maxDelayMs.
     */ , r = 6e4) {
        this.rn = t, this.Ht = n, this.on = e, this.un = s, this.cn = r, this.an = 0, this.hn = null, 
        /** The last backoff attempt, as epoch milliseconds. */
        this.ln = Date.now(), this.reset();
    }
    /**
     * Resets the backoff delay.
     *
     * The very next backoffAndWait() will have no delay. If it is called again
     * (i.e. due to an error), initialDelayMs (plus jitter) will be used, and
     * subsequent ones will increase according to the backoffFactor.
     */    reset() {
        this.an = 0;
    }
    /**
     * Resets the backoff delay to the maximum delay (e.g. for use after a
     * RESOURCE_EXHAUSTED error).
     */    fn() {
        this.an = this.cn;
    }
    /**
     * Returns a promise that resolves after currentDelayMs, and increases the
     * delay for any subsequent attempts. If there was a pending backoff operation
     * already, it will be canceled.
     */    dn(t) {
        // Cancel any pending backoff operation.
        this.cancel();
        // First schedule using the current base (which may be 0 and should be
        // honored as such).
        const n = Math.floor(this.an + this._n()), e = Math.max(0, Date.now() - this.ln), s = Math.max(0, n - e);
        // Guard against lastAttemptTime being in the future due to a clock change.
                s > 0 && l("ExponentialBackoff", `Backing off for ${s} ms (base delay: ${this.an} ms, delay with jitter: ${n} ms, last attempt: ${e} ms ago)`), 
        this.hn = this.rn.wn(this.Ht, s, (() => (this.ln = Date.now(), t()))), 
        // Apply backoff factor to determine next delay and ensure it is within
        // bounds.
        this.an *= this.un, this.an < this.on && (this.an = this.on), this.an > this.cn && (this.an = this.cn);
    }
    mn() {
        null !== this.hn && (this.hn.en(), this.hn = null);
    }
    cancel() {
        null !== this.hn && (this.hn.cancel(), this.hn = null);
    }
    /** Returns a random value in the range [-currentBaseMs/2, currentBaseMs/2] */    _n() {
        return (Math.random() - .5) * this.an;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Datastore and its related methods are a wrapper around the external Google
 * Cloud Datastore grpc API, which provides an interface that is more convenient
 * for the rest of the client SDK architecture to consume.
 */
/**
 * An implementation of Datastore that exposes additional state for internal
 * consumption.
 */
class Hn extends class {} {
    constructor(t, n, e) {
        super(), this.credentials = t, this.pn = n, this.Bt = e, this.yn = !1;
    }
    En() {
        if (this.yn) throw new q(b, "The client has already been terminated.");
    }
    /** Gets an auth token and invokes the provided RPC. */    ot(t, n, e) {
        return this.En(), this.credentials.getToken().then((s => this.pn.ot(t, n, e, s))).catch((t => {
            throw t.code === g && this.credentials._(), t;
        }));
    }
    /** Gets an auth token and invokes the provided RPC with streamed results. */    ht(t, n, e) {
        return this.En(), this.credentials.getToken().then((s => this.pn.ht(t, n, e, s))).catch((t => {
            throw t.code === g && this.credentials._(), t;
        }));
    }
    terminate() {
        this.yn = !1;
    }
}

// TODO(firestorexp): Make sure there is only one Datastore instance per
// firestore-exp client.
async function Kn(t, n) {
    const e = p(t), s = qn(e.Bt) + "/documents", r = {
        writes: n.map((t => Ln(e.Bt, t)))
    };
    await e.ot("Commit", s, r);
}

async function Jn(t, n) {
    const e = p(t), s = qn(e.Bt) + "/documents", r = {
        documents: n.map((t => $n(e.Bt, t)))
    }, i = await e.ht("BatchGetDocuments", s, r), o = new Map;
    i.forEach((t => {
        const n = Cn(e.Bt, t);
        o.set(n.key.toString(), n);
    }));
    const u = [];
    return n.forEach((t => {
        const n = o.get(t.toString());
        m(!!n), u.push(n);
    })), u;
}

async function Zn(t, n) {
    const e = p(t), s = Un(e.Bt, an(n));
    return (await e.ht("RunQuery", s.parent, {
        structuredQuery: s.structuredQuery
    })).filter((t => !!t.document)).map((t => function(t, n, e) {
        const s = Sn(t, n.name), r = Dn(n.updateTime), i = new Ot({
            mapValue: {
                fields: n.fields
            }
        });
        return new Ut(s, r, i, {
            hasCommittedMutations: !!e
        });
    }(e.Bt, t.document, void 0)));
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A concrete type describing all the values that can be applied via a
 * user-supplied firestore.Settings object. This is a separate type so that
 * defaults can be supplied and the value can be checked for equality.
 */
class Xn {
    constructor(t) {
        var n;
        if (void 0 === t.host) {
            if (void 0 !== t.ssl) throw new q(T, "Can't provide ssl option if host option is not set");
            this.host = "firestore.googleapis.com", this.ssl = true;
        } else this.host = t.host, this.ssl = null === (n = t.ssl) || void 0 === n || n;
        if (this.credentials = t.credentials, this.ignoreUndefinedProperties = !!t.ignoreUndefinedProperties, 
        void 0 === t.cacheSizeBytes) this.cacheSizeBytes = 41943040; else {
            if (-1 !== t.cacheSizeBytes && t.cacheSizeBytes < 1048576) throw new q(T, "cacheSizeBytes must be at least 1048576");
            this.cacheSizeBytes = t.cacheSizeBytes;
        }
        this.experimentalForceLongPolling = !!t.experimentalForceLongPolling, this.experimentalAutoDetectLongPolling = !!t.experimentalAutoDetectLongPolling, 
        function(t, n, e, s) {
            if (!0 === n && !0 === s) throw new q(T, `${t} and ${e} cannot be used together.`);
        }("experimentalForceLongPolling", t.experimentalForceLongPolling, "experimentalAutoDetectLongPolling", t.experimentalAutoDetectLongPolling);
    }
    isEqual(t) {
        return this.host === t.host && this.ssl === t.ssl && this.credentials === t.credentials && this.cacheSizeBytes === t.cacheSizeBytes && this.experimentalForceLongPolling === t.experimentalForceLongPolling && this.experimentalAutoDetectLongPolling === t.experimentalAutoDetectLongPolling && this.ignoreUndefinedProperties === t.ignoreUndefinedProperties;
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const te = new Map;

/**
 * An instance map that ensures only one Datastore exists per Firestore
 * instance.
 */
/**
 * Returns an initialized and started Datastore for the given Firestore
 * instance. Callers must invoke removeComponents() when the Firestore
 * instance is terminated.
 */
function ne(t) {
    if (t.In) throw new q(b, "The client has already been terminated.");
    if (!te.has(t)) {
        l("ComponentProvider", "Initializing Datastore");
        const r = function(t) {
            return new ot(t, fetch.bind(null));
        }((n = t.Tn, e = t.An, s = t.Pn(), new M(n, e, s.host, s.ssl, s.experimentalForceLongPolling, s.experimentalAutoDetectLongPolling))), i = zn(t.Tn), o = function(t, n, e) {
            return new Hn(t, n, e);
        }(t.Rn, r, i);
        te.set(t, o);
    }
    var n, e, s;
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * The Cloud Firestore service interface.
 *
 * Do not call this constructor directly. Instead, use {@link getFirestore}.
 */    return te.get(t);
}

/**
 * Removes all components associated with the provided instance. Must be called
 * when the `Firestore` instance is terminated.
 */ class ee {
    /** @hideconstructor */
    constructor(t, n) {
        this.An = "(lite)", this.Vn = new Xn({}), this.gn = !1, t instanceof B ? (this.Tn = t, 
        this.Rn = new C) : (this.vn = t, this.Tn = function(t) {
            if (!Object.prototype.hasOwnProperty.apply(t.options, [ "projectId" ])) throw new q(T, '"projectId" not provided in firebase.initializeApp.');
            return new B(t.options.projectId);
        }
        /**
 * Initializes a new instance of Cloud Firestore with the provided settings.
 * Can only be called before any other functions, including
 * {@link getFirestore}. If the custom settings are empty, this function is
 * equivalent to calling {@link getFirestore}.
 *
 * @param app - The {@link FirebaseApp} with which the `Firestore` instance will
 * be associated.
 * @param settings - A settings object to configure the `Firestore` instance.
 * @returns A newly initialized Firestore instance.
 */ (t), this.Rn = new L(n));
    }
    /**
     * The {@link FirebaseApp} associated with this `Firestore` service
     * instance.
     */    get app() {
        if (!this.vn) throw new q(b, "Firestore was not initialized using the Firebase SDK. 'app' is not available");
        return this.vn;
    }
    get bn() {
        return this.gn;
    }
    get In() {
        return void 0 !== this.Nn;
    }
    Dn(t) {
        if (this.gn) throw new q(b, "Firestore has already been started and its settings can no longer be changed. You can only modify settings before calling any other methods on a Firestore object.");
        this.Vn = new Xn(t), void 0 !== t.credentials && (this.Rn = function(t) {
            if (!t) return new C;
            switch (t.type) {
              case "gapi":
                const n = t.client;
                // Make sure this really is a Gapi client.
                                return m(!("object" != typeof n || null === n || !n.auth || !n.auth.getAuthHeaderValueForFirstParty)), 
                new j(n, t.sessionIndex || "0");

              case "provider":
                return t.client;

              default:
                throw new q(T, "makeCredentialsProvider failed due to invalid credential type");
            }
        }(t.credentials));
    }
    Fn() {
        return this.Vn;
    }
    Pn() {
        return this.gn = !0, this.Vn;
    }
    _delete() {
        return this.Nn || (this.Nn = this.$n()), this.Nn;
    }
    toJSON() {
        return {
            app: this.vn,
            g: this.Tn,
            settings: this.Vn
        };
    }
    /**
     * Terminates all components used by this client. Subclasses can override
     * this method to clean up their own dependencies, but must also call this
     * method.
     *
     * Only ever called once.
     */    $n() {
        return function(t) {
            const n = te.get(t);
            n && (l("ComponentProvider", "Removing Datastore"), te.delete(t), n.terminate());
        }(this), Promise.resolve();
    }
}

function se(n, e) {
    const s = t(n, "firestore/lite").getImmediate();
    return s.Dn(e), s;
}

/**
 * Returns the existing instance of Firestore that is associated with the
 * provided {@link FirebaseApp}. If no instance exists, initializes a new
 * instance with default settings.
 *
 * @param app - The {@link FirebaseApp} instance that the returned Firestore
 * instance is associated with.
 * @returns The `Firestore` instance of the provided app.
 */ function re(n) {
    return t(n, "firestore/lite").getImmediate();
}

/**
 * Modify this instance to communicate with the Cloud Firestore emulator.
 *
 * Note: This must be called before this instance has been used to do any
 * operations.
 *
 * @param firestore - The Firestore instance to configure to connect to the
 * emulator.
 * @param host - the emulator host (ex: localhost).
 * @param port - the emulator port (ex: 9000).
 */ function ie(t, n, e) {
    const s = (t = Z(t, ee)).Fn();
    "firestore.googleapis.com" !== s.host && s.host !== n && d("Host has been set in both settings() and useEmulator(), emulator host will be used"), 
    t.Dn(Object.assign(Object.assign({}, s), {
        host: `${n}:${e}`,
        ssl: !1
    }));
}

/**
 * Terminates the provided Firestore instance.
 *
 * After calling `terminate()` only the `clearIndexedDbPersistence()` functions
 * may be used. Any other function will throw a `FirestoreError`. Termination
 * does not cancel any pending writes, and any promises that are awaiting a
 * response from the server will not be resolved.
 *
 * To restart after termination, create a new instance of FirebaseFirestore with
 * {@link getFirestore}.
 *
 * Note: Under normal circumstances, calling `terminate()` is not required. This
 * function is useful only when you want to force this instance to release all of
 * its resources or in combination with {@link clearIndexedDbPersistence} to
 * ensure that all local state is destroyed between test runs.
 *
 * @param firestore - The Firestore instance to terminate.
 * @returns A promise that is resolved when the instance has been successfully
 * terminated.
 */ function oe(t) {
    return t = Z(t, ee), n(t.app, "firestore/lite"), t._delete();
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A class implemented by all API types of the legacy Firestore API which
 * contains a reference to the API type in the firestore-exp API. All internal
 * code unwraps these references, which allows us to only use firestore-exp
 * types in the SDK.
 */
class ue {
    constructor(t) {
        this.et = t;
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A `DocumentReference` refers to a document location in a Firestore database
 * and can be used to write, read, or listen to the location. The document at
 * the referenced location may or may not exist.
 */ class ce {
    /** @hideconstructor */
    constructor(t, n, e) {
        this.Sn = n, this.xn = e, 
        /** The type of this Firestore reference. */
        this.type = "document", this.firestore = t;
    }
    get qn() {
        return this.xn.path;
    }
    /**
     * The document's identifier within its collection.
     */    get id() {
        return this.xn.path.C();
    }
    /**
     * A string representing the path of the referenced document (relative
     * to the root of the database).
     */    get path() {
        return this.xn.path.B();
    }
    /**
     * The collection this `DocumentReference` belongs to.
     */    get parent() {
        return new he(this.firestore, this.Sn, this.xn.path.q());
    }
    /**
     * Applies a custom data converter to this `DocumentReference`, allowing you
     * to use your own custom model objects with Firestore. When you call {@link
     * setDoc}, {@link getDoc}, etc. with the returned `DocumentReference`
     * instance, the provided converter will convert between Firestore data and
     * your custom type `U`.
     *
     * @param converter - Converts objects to and from Firestore.
     * @returns A `DocumentReference<U>` that uses the provided converter.
     */    withConverter(t) {
        return new ce(this.firestore, t, this.xn);
    }
}

/**
 * A `Query` refers to a Query which you can read or listen to. You can also
 * construct refined `Query` objects by adding filters and ordering.
 */ class ae {
    // This is the lite version of the Query class in the main SDK.
    /** @hideconstructor protected */
    constructor(t, n, e) {
        this.Sn = n, this.On = e, 
        /** The type of this Firestore reference. */
        this.type = "query", this.firestore = t;
    }
    /**
     * Applies a custom data converter to this query, allowing you to use your own
     * custom model objects with Firestore. When you call {@link getDocs} with
     * the returned query, the provided converter will convert between Firestore
     * data and your custom type `U`.
     *
     * @param converter - Converts objects to and from Firestore.
     * @returns A `Query<U>` that uses the provided converter.
     */    withConverter(t) {
        return new ae(this.firestore, t, this.On);
    }
}

/**
 * A `CollectionReference` object can be used for adding documents, getting
 * document references, and querying for documents (using {@link query}).
 */ class he extends ae {
    /** @hideconstructor */
    constructor(t, n, e) {
        super(t, n, new en(e)), this.firestore = t, this.qn = e, this.type = "collection";
    }
    /** The collection's identifier. */    get id() {
        return this.On.path.C();
    }
    /**
     * A string representing the path of the referenced collection (relative
     * to the root of the database).
     */    get path() {
        return this.On.path.B();
    }
    /**
     * A reference to the containing `DocumentReference` if this is a
     * subcollection. If this isn't a subcollection, the reference is null.
     */    get parent() {
        const t = this.qn.q();
        return t.L() ? null : new ce(this.firestore, 
        /* converter= */ null, new G(t));
    }
    /**
     * Applies a custom data converter to this CollectionReference, allowing you
     * to use your own custom model objects with Firestore. When you call {@link
     * addDoc} with the returned `CollectionReference` instance, the provided
     * converter will convert between Firestore data and your custom type `U`.
     *
     * @param converter - Converts objects to and from Firestore.
     * @returns A `CollectionReference<U>` that uses the provided converter.
     */    withConverter(t) {
        return new he(this.firestore, t, this.qn);
    }
}

function le(t, n, ...e) {
    if (t instanceof ue && (t = t.et), Y("collection", "path", n), t instanceof ee) {
        const s = Q.k(n, ...e);
        return K(s), new he(t, /* converter= */ null, s);
    }
    {
        if (!(t instanceof ce || t instanceof he)) throw new q(T, "Expected first argument to collection() to be a CollectionReference, a DocumentReference or FirebaseFirestore");
        const s = Q.k(t.path, ...e).child(Q.k(n));
        return K(s), new he(t.firestore, 
        /* converter= */ null, s);
    }
}

// TODO(firestorelite): Consider using ErrorFactory -
// https://github.com/firebase/firebase-js-sdk/blob/0131e1f/packages/util/src/errors.ts#L106
/**
 * Creates and returns a new `Query` instance that includes all documents in the
 * database that are contained in a collection or subcollection with the
 * given `collectionId`.
 *
 * @param firestore - A reference to the root Firestore instance.
 * @param collectionId - Identifies the collections to query over. Every
 * collection or subcollection with this ID as the last segment of its path
 * will be included. Cannot contain a slash.
 * @returns The created `Query`.
 */ function fe(t, n) {
    if (t = Z(t, ee), Y("collectionGroup", "collection id", n), n.indexOf("/") >= 0) throw new q(T, `Invalid collection ID '${n}' passed to function collectionGroup(). Collection IDs must not contain '/'.`);
    return new ae(t, 
    /* converter= */ null, 
    /**
 * Creates a new Query for a collection group query that matches all documents
 * within the provided collection group.
 */
    function(t) {
        return new en(Q.W(), t);
    }(n));
}

function de(t, n, ...e) {
    if (t instanceof ue && (t = t.et), 
    // We allow omission of 'pathString' but explicitly prohibit passing in both
    // 'undefined' and 'null'.
    1 === arguments.length && (n = at.dt()), Y("doc", "path", n), t instanceof ee) {
        const s = Q.k(n, ...e);
        return H(s), new ce(t, 
        /* converter= */ null, new G(s));
    }
    {
        if (!(t instanceof ce || t instanceof he)) throw new q(T, "Expected first argument to collection() to be a CollectionReference, a DocumentReference or FirebaseFirestore");
        const s = t.qn.child(Q.k(n, ...e));
        return H(s), new ce(t.firestore, t instanceof he ? t.Sn : null, new G(s));
    }
}

/**
 * Returns true if the provided references are equal.
 *
 * @param left - A reference to compare.
 * @param right - A reference to compare.
 * @returns true if the references point to the same location in the same
 * Firestore database.
 */ function _e(t, n) {
    return t instanceof ue && (t = t.et), n instanceof ue && (n = n.et), (t instanceof ce || t instanceof he) && (n instanceof ce || n instanceof he) && (t.firestore === n.firestore && t.path === n.path && t.Sn === n.Sn);
}

/**
 * Returns true if the provided queries point to the same collection and apply
 * the same constraints.
 *
 * @param left - A `Query` to compare.
 * @param right - A `Query` to compare.
 * @returns true if the references point to the same location in the same
 * Firestore database.
 */ function we(t, n) {
    return t instanceof ue && (t = t.et), n instanceof ue && (n = n.et), t instanceof ae && n instanceof ae && (t.firestore === n.firestore && hn(t.On, n.On) && t.Sn === n.Sn);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An immutable object representing an array of bytes.
 */ class me {
    /** @hideconstructor */
    constructor(t) {
        this.Cn = t;
    }
    /**
     * Creates a new `Bytes` object from the given Base64 string, converting it to
     * bytes.
     *
     * @param base64 - The Base64 string used to create the `Bytes` object.
     */    static fromBase64String(t) {
        try {
            return new me(yt.fromBase64String(t));
        } catch (t) {
            throw new q(T, "Failed to construct data from Base64 string: " + t);
        }
    }
    /**
     * Creates a new `Bytes` object from the given Uint8Array.
     *
     * @param array - The Uint8Array used to create the `Bytes` object.
     */    static fromUint8Array(t) {
        return new me(yt.fromUint8Array(t));
    }
    /**
     * Returns the underlying bytes as a Base64-encoded string.
     *
     * @returns The Base64-encoded string created from the `Bytes` object.
     */    toBase64() {
        return this.Cn.toBase64();
    }
    /**
     * Returns the underlying bytes in a new `Uint8Array`.
     *
     * @returns The Uint8Array created from the `Bytes` object.
     */    toUint8Array() {
        return this.Cn.toUint8Array();
    }
    /**
     * Returns a string representation of the `Bytes` object.
     *
     * @returns A string representation of the `Bytes` object.
     */    toString() {
        return "Bytes(base64: " + this.toBase64() + ")";
    }
    /**
     * Returns true if this `Bytes` object is equal to the provided one.
     *
     * @param other - The `Bytes` object to compare against.
     * @returns true if this `Bytes` object is equal to the provided one.
     */    isEqual(t) {
        return this.Cn.isEqual(t.Cn);
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A `FieldPath` refers to a field in a document. The path may consist of a
 * single field name (referring to a top-level field in the document), or a
 * list of field names (referring to a nested field in the document).
 *
 * Create a `FieldPath` by providing field names. If more than one field
 * name is provided, the path will point to a nested field in a document.
 */ class pe {
    /**
     * Creates a FieldPath from the provided field names. If more than one field
     * name is provided, the path will point to a nested field in a document.
     *
     * @param fieldNames - A list of field names.
     */
    constructor(...t) {
        for (let n = 0; n < t.length; ++n) if (0 === t[n].length) throw new q(T, "Invalid field name at argument $(i + 1). Field names must not be empty.");
        this.Ln = new z(t);
    }
    /**
     * Returns true if this `FieldPath` is equal to the provided one.
     *
     * @param other - The `FieldPath` to compare against.
     * @returns true if this `FieldPath` is equal to the provided one.
     */    isEqual(t) {
        return this.Ln.isEqual(t.Ln);
    }
}

/**
 * Returns a special sentinel `FieldPath` to refer to the ID of a document.
 * It can be used in queries to sort or filter by the document ID.
 */ function ye() {
    return new pe("__name__");
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Sentinel values that can be used when writing document fields with `set()`
 * or `update()`.
 */ class Ee {
    /**
     * @param _methodName - The public API endpoint that returns this class.
     */
    constructor(t) {
        this._methodName = t;
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An immutable object representing a geographic location in Firestore. The
 * location is represented as latitude/longitude pair.
 *
 * Latitude values are in the range of [-90, 90].
 * Longitude values are in the range of [-180, 180].
 */ class Ie {
    /**
     * Creates a new immutable `GeoPoint` object with the provided latitude and
     * longitude values.
     * @param latitude - The latitude as number between -90 and 90.
     * @param longitude - The longitude as number between -180 and 180.
     */
    constructor(t, n) {
        if (!isFinite(t) || t < -90 || t > 90) throw new q(T, "Latitude must be a number between -90 and 90, but was: " + t);
        if (!isFinite(n) || n < -180 || n > 180) throw new q(T, "Longitude must be a number between -180 and 180, but was: " + n);
        this.Un = t, this.jn = n;
    }
    /**
     * The latitude of this `GeoPoint` instance.
     */    get latitude() {
        return this.Un;
    }
    /**
     * The longitude of this `GeoPoint` instance.
     */    get longitude() {
        return this.jn;
    }
    /**
     * Returns true if this `GeoPoint` is equal to the provided one.
     *
     * @param other - The `GeoPoint` to compare against.
     * @returns true if this `GeoPoint` is equal to the provided one.
     */    isEqual(t) {
        return this.Un === t.Un && this.jn === t.jn;
    }
    toJSON() {
        return {
            latitude: this.Un,
            longitude: this.jn
        };
    }
    /**
     * Actually private to JS consumers of our API, so this function is prefixed
     * with an underscore.
     */    _t(t) {
        return ht(this.Un, t.Un) || ht(this.jn, t.jn);
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const Te = /^__.*__$/;

/** The result of parsing document data (e.g. for a setData call). */ class Ae {
    constructor(t, n, e) {
        this.data = t, this.Gt = n, this.fieldTransforms = e;
    }
    Mn(t, n) {
        return null !== this.Gt ? new Tn(t, this.data, this.Gt, n, this.fieldTransforms) : new In(t, this.data, n, this.fieldTransforms);
    }
}

/** The result of parsing "update" data (i.e. for an updateData call). */ class Pe {
    constructor(t, 
    // The fieldMask does not include document transforms.
    n, e) {
        this.data = t, this.Gt = n, this.fieldTransforms = e;
    }
    Mn(t, n) {
        return new Tn(t, this.data, this.Gt, n, this.fieldTransforms);
    }
}

function Re(t) {
    switch (t) {
      case 0 /* Set */ :
 // fall through
              case 2 /* MergeSet */ :
 // fall through
              case 1 /* Update */ :
        return !0;

      case 3 /* Argument */ :
      case 4 /* ArrayArgument */ :
        return !1;

      default:
        throw w();
    }
}

/** A "context" object passed around while parsing user data. */ class Ve {
    /**
     * Initializes a ParseContext with the given source and path.
     *
     * @param settings - The settings for the parser.
     * @param databaseId - The database ID of the Firestore instance.
     * @param serializer - The serializer to use to generate the Value proto.
     * @param ignoreUndefinedProperties - Whether to ignore undefined properties
     * rather than throw.
     * @param fieldTransforms - A mutable list of field transforms encountered
     * while parsing the data.
     * @param fieldMask - A mutable list of field paths encountered while parsing
     * the data.
     *
     * TODO(b/34871131): We don't support array paths right now, so path can be
     * null to indicate the context represents any location within an array (in
     * which case certain features will not work and errors will be somewhat
     * compromised).
     */
    constructor(t, n, e, s, r, i) {
        this.settings = t, this.g = n, this.Bt = e, this.ignoreUndefinedProperties = s, 
        // Minor hack: If fieldTransforms is undefined, we assume this is an
        // external call and we need to validate the entire path.
        void 0 === r && this.Bn(), this.fieldTransforms = r || [], this.Gt = i || [];
    }
    get path() {
        return this.settings.path;
    }
    get kn() {
        return this.settings.kn;
    }
    /** Returns a new context with the specified settings overwritten. */    Qn(t) {
        return new Ve(Object.assign(Object.assign({}, this.settings), t), this.g, this.Bt, this.ignoreUndefinedProperties, this.fieldTransforms, this.Gt);
    }
    Wn(t) {
        var n;
        const e = null === (n = this.path) || void 0 === n ? void 0 : n.child(t), s = this.Qn({
            path: e,
            zn: !1
        });
        return s.Gn(t), s;
    }
    Yn(t) {
        var n;
        const e = null === (n = this.path) || void 0 === n ? void 0 : n.child(t), s = this.Qn({
            path: e,
            zn: !1
        });
        return s.Bn(), s;
    }
    Hn(t) {
        // TODO(b/34871131): We don't support array paths right now; so make path
        // undefined.
        return this.Qn({
            path: void 0,
            zn: !0
        });
    }
    Kn(t) {
        return We(t, this.settings.methodName, this.settings.Jn || !1, this.path, this.settings.Zn);
    }
    /** Returns 'true' if 'fieldPath' was traversed when creating this context. */    contains(t) {
        return void 0 !== this.Gt.find((n => t.U(n))) || void 0 !== this.fieldTransforms.find((n => t.U(n.field)));
    }
    Bn() {
        // TODO(b/34871131): Remove null check once we have proper paths for fields
        // within arrays.
        if (this.path) for (let t = 0; t < this.path.length; t++) this.Gn(this.path.get(t));
    }
    Gn(t) {
        if (0 === t.length) throw this.Kn("Document fields must not be empty");
        if (Re(this.kn) && Te.test(t)) throw this.Kn('Document fields cannot begin and end with "__"');
    }
}

/**
 * Helper for parsing raw user input (provided via the API) into internal model
 * classes.
 */ class ge {
    constructor(t, n, e) {
        this.g = t, this.ignoreUndefinedProperties = n, this.Bt = e || zn(t);
    }
    /** Creates a new top-level parse context. */    Xn(t, n, e, s = !1) {
        return new Ve({
            kn: t,
            methodName: n,
            Zn: e,
            path: z.W(),
            zn: !1,
            Jn: s
        }, this.g, this.Bt, this.ignoreUndefinedProperties);
    }
}

function ve(t) {
    const n = t.Pn(), e = zn(t.Tn);
    return new ge(t.Tn, !!n.ignoreUndefinedProperties, e);
}

/** Parse document data from a set() call. */ function be(t, n, e, s, r, i = {}) {
    const o = t.Xn(i.merge || i.mergeFields ? 2 /* MergeSet */ : 0 /* Set */ , n, e, r);
    Me("Data must be an object, but it was:", o, s);
    const u = Ue(s, o);
    let c, a;
    if (i.merge) c = new mt(o.Gt), a = o.fieldTransforms; else if (i.mergeFields) {
        const t = [];
        for (const s of i.mergeFields) {
            const r = Be(n, s, e);
            if (!o.contains(r)) throw new q(T, `Field '${r}' is specified in your field mask but missing from your input data.`);
            ze(t, r) || t.push(r);
        }
        c = new mt(t), a = o.fieldTransforms.filter((t => c.Tt(t.field)));
    } else c = null, a = o.fieldTransforms;
    return new Ae(new Ot(u), c, a);
}

class Ne extends Ee {
    te(t) {
        if (2 /* MergeSet */ !== t.kn) throw 1 /* Update */ === t.kn ? t.Kn(this._methodName + "() can only appear at the top level of your update data") : t.Kn(this._methodName + "() cannot be used with set() unless you pass {merge:true}");
        // No transform to add for a delete, but we need to add it to our
        // fieldMask so it gets deleted.
        return t.Gt.push(t.path), null;
    }
    isEqual(t) {
        return t instanceof Ne;
    }
}

/**
 * Creates a child context for parsing SerializableFieldValues.
 *
 * This is different than calling `ParseContext.contextWith` because it keeps
 * the fieldTransforms and fieldMask separate.
 *
 * The created context has its `dataSource` set to `UserDataSource.Argument`.
 * Although these values are used with writes, any elements in these FieldValues
 * are not considered writes since they cannot contain any FieldValue sentinels,
 * etc.
 *
 * @param fieldValue - The sentinel FieldValue for which to create a child
 *     context.
 * @param context - The parent context.
 * @param arrayElement - Whether or not the FieldValue has an array.
 */ function De(t, n, e) {
    return new Ve({
        kn: 3 /* Argument */ ,
        Zn: n.settings.Zn,
        methodName: t._methodName,
        zn: e
    }, n.g, n.Bt, n.ignoreUndefinedProperties);
}

class Fe extends Ee {
    te(t) {
        return new pn(t.path, new dn);
    }
    isEqual(t) {
        return t instanceof Fe;
    }
}

class $e extends Ee {
    constructor(t, n) {
        super(t), this.ne = n;
    }
    te(t) {
        const n = De(this, t, 
        /*array=*/ !0), e = this.ne.map((t => Le(t, n))), s = new _n(e);
        return new pn(t.path, s);
    }
    isEqual(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }
}

class Se extends Ee {
    constructor(t, n) {
        super(t), this.ne = n;
    }
    te(t) {
        const n = De(this, t, 
        /*array=*/ !0), e = this.ne.map((t => Le(t, n))), s = new wn(e);
        return new pn(t.path, s);
    }
    isEqual(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }
}

class xe extends Ee {
    constructor(t, n) {
        super(t), this.ee = n;
    }
    te(t) {
        const n = new mn(t.Bt, ln(t.Bt, this.ee));
        return new pn(t.path, n);
    }
    isEqual(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }
}

/** Parse update data from an update() call. */ function qe(t, n, e, s) {
    const r = t.Xn(1 /* Update */ , n, e);
    Me("Data must be an object, but it was:", r, s);
    const i = [], o = new Ct;
    wt(s, ((t, s) => {
        const u = Qe(n, t, e);
        // For Compat types, we have to "extract" the underlying types before
        // performing validation.
                s instanceof ue && (s = s.et);
        const c = r.Yn(u);
        if (s instanceof Ne) 
        // Add it to the field mask, but don't add anything to updateData.
        i.push(u); else {
            const t = Le(s, c);
            null != t && (i.push(u), o.set(u, t));
        }
    }));
    const u = new mt(i);
    return new Pe(o.bt(), u, r.fieldTransforms);
}

/** Parse update data from a list of field/value arguments. */ function Oe(t, n, e, s, r, i) {
    const o = t.Xn(1 /* Update */ , n, e), u = [ Be(n, s, e) ], c = [ r ];
    if (i.length % 2 != 0) throw new q(T, `Function ${n}() needs to be called with an even number of arguments that alternate between field names and values.`);
    for (let t = 0; t < i.length; t += 2) u.push(Be(n, i[t])), c.push(i[t + 1]);
    const a = [], h = new Ct;
    // We iterate in reverse order to pick the last value for a field if the
    // user specified the field multiple times.
    for (let t = u.length - 1; t >= 0; --t) if (!ze(a, u[t])) {
        const n = u[t];
        let e = c[t];
        // For Compat types, we have to "extract" the underlying types before
        // performing validation.
                e instanceof ue && (e = e.et);
        const s = o.Yn(n);
        if (e instanceof Ne) 
        // Add it to the field mask, but don't add anything to updateData.
        a.push(n); else {
            const t = Le(e, s);
            null != t && (a.push(n), h.set(n, t));
        }
    }
    const l = new mt(a);
    return new Pe(h.bt(), l, o.fieldTransforms);
}

/**
 * Parse a "query value" (e.g. value in a where filter or a value in a cursor
 * bound).
 *
 * @param allowArrays - Whether the query value is an array that may directly
 * contain additional arrays (e.g. the operand of an `in` query).
 */ function Ce(t, n, e, s = !1) {
    return Le(e, t.Xn(s ? 4 /* ArrayArgument */ : 3 /* Argument */ , n));
}

/**
 * Parses user data to Protobuf Values.
 *
 * @param input - Data to be parsed.
 * @param context - A context object representing the current path being parsed,
 * the source of the data being parsed, etc.
 * @returns The parsed value, or null if the value was a FieldValue sentinel
 * that should not be included in the resulting parsed data.
 */ function Le(t, n) {
    if (
    // Unwrap the API type from the Compat SDK. This will return the API type
    // from firestore-exp.
    t instanceof ue && (t = t.et), je(t)) return Me("Unsupported field value:", n, t), 
    Ue(t, n);
    if (t instanceof Ee) 
    // FieldValues usually parse into transforms (except FieldValue.delete())
    // in which case we do not want to include this field in our parsed data
    // (as doing so will overwrite the field directly prior to the transform
    // trying to transform it). So we don't add this location to
    // context.fieldMask and we return null as our parsing result.
    /**
 * "Parses" the provided FieldValueImpl, adding any necessary transforms to
 * context.fieldTransforms.
 */
    return function(t, n) {
        // Sentinels are only supported with writes, and not within arrays.
        if (!Re(n.kn)) throw n.Kn(t._methodName + "() can only be used with update() and set()");
        if (!n.path) throw n.Kn(t._methodName + "() is not currently supported inside arrays");
        const e = t.te(n);
        e && n.fieldTransforms.push(e);
    }
    /**
 * Helper to parse a scalar value (i.e. not an Object, Array, or FieldValue)
 *
 * @returns The parsed value
 */ (t, n), null;
    if (
    // If context.path is null we are inside an array and we don't support
    // field mask paths more granular than the top-level array.
    n.path && n.Gt.push(n.path), t instanceof Array) {
        // TODO(b/34871131): Include the path containing the array in the error
        // message.
        // In the case of IN queries, the parsed data is an array (representing
        // the set of values to be included for the IN query) that may directly
        // contain additional arrays (each representing an individual field
        // value), so we disable this validation.
        if (n.settings.zn && 4 /* ArrayArgument */ !== n.kn) throw n.Kn("Nested arrays are not supported");
        return function(t, n) {
            const e = [];
            let s = 0;
            for (const r of t) {
                let t = Le(r, n.Hn(s));
                null == t && (
                // Just include nulls in the array for fields being replaced with a
                // sentinel.
                t = {
                    nullValue: "NULL_VALUE"
                }), e.push(t), s++;
            }
            return {
                arrayValue: {
                    values: e
                }
            };
        }(t, n);
    }
    return function(t, n) {
        t instanceof ue && (t = t.et);
        if (null === t) return {
            nullValue: "NULL_VALUE"
        };
        if ("number" == typeof t) return ln(n.Bt, t);
        if ("boolean" == typeof t) return {
            booleanValue: t
        };
        if ("string" == typeof t) return {
            stringValue: t
        };
        if (t instanceof Date) {
            const e = ft.fromDate(t);
            return {
                timestampValue: vn(n.Bt, e)
            };
        }
        if (t instanceof ft) {
            // Firestore backend truncates precision down to microseconds. To ensure
            // offline mode works the same with regards to truncation, perform the
            // truncation immediately without waiting for the backend to do that.
            const e = new ft(t.seconds, 1e3 * Math.floor(t.nanoseconds / 1e3));
            return {
                timestampValue: vn(n.Bt, e)
            };
        }
        if (t instanceof Ie) return {
            geoPointValue: {
                latitude: t.latitude,
                longitude: t.longitude
            }
        };
        if (t instanceof me) return {
            bytesValue: bn(n.Bt, t.Cn)
        };
        if (t instanceof ce) {
            const e = n.g, s = t.firestore.Tn;
            if (!s.isEqual(e)) throw n.Kn(`Document reference is for database ${s.projectId}/${s.database} but should be for database ${e.projectId}/${e.database}`);
            return {
                referenceValue: Fn(t.firestore.Tn || n.g, t.xn.path)
            };
        }
        if (void 0 === t && n.ignoreUndefinedProperties) return null;
        throw n.Kn("Unsupported field value: " + J(t));
    }
    /**
 * Checks whether an object looks like a JSON object that should be converted
 * into a struct. Normal class/prototype instances are considered to look like
 * JSON objects since they should be converted to a struct value. Arrays, Dates,
 * GeoPoints, etc. are not considered to look like JSON objects since they map
 * to specific FieldValue types other than ObjectValue.
 */ (t, n);
}

function Ue(t, n) {
    const e = {};
    return !function(t) {
        for (const n in t) if (Object.prototype.hasOwnProperty.call(t, n)) return !1;
        return !0;
    }(t) ? wt(t, ((t, s) => {
        const r = Le(s, n.Wn(t));
        null != r && (e[t] = r);
    })) : 
    // If we encounter an empty object, we explicitly add it to the update
    // mask to ensure that the server creates a map entry.
    n.path && n.path.length > 0 && n.Gt.push(n.path), {
        mapValue: {
            fields: e
        }
    };
}

function je(t) {
    return !("object" != typeof t || null === t || t instanceof Array || t instanceof Date || t instanceof ft || t instanceof Ie || t instanceof me || t instanceof ce || t instanceof Ee);
}

function Me(t, n, e) {
    if (!je(e) || !function(t) {
        return "object" == typeof t && null !== t && (Object.getPrototypeOf(t) === Object.prototype || null === Object.getPrototypeOf(t));
    }(e)) {
        const s = J(e);
        throw "an object" === s ? n.Kn(t + " a custom object") : n.Kn(t + " " + s);
    }
}

/**
 * Helper that calls fromDotSeparatedString() but wraps any error thrown.
 */ function Be(t, n, e) {
    if (
    // If required, replace the FieldPath Compat class with with the firestore-exp
    // FieldPath.
    n instanceof ue && (n = n.et), n instanceof pe) return n.Ln;
    if ("string" == typeof n) return Qe(t, n);
    throw We("Field path arguments must be of type string or FieldPath.", t, 
    /* hasConverter= */ !1, 
    /* path= */ void 0, e);
}

/**
 * Matches any characters in a field path string that are reserved.
 */ const ke = new RegExp("[~\\*/\\[\\]]");

/**
 * Wraps fromDotSeparatedString with an error message about the method that
 * was thrown.
 * @param methodName - The publicly visible method name
 * @param path - The dot-separated string form of a field path which will be
 * split on dots.
 * @param targetDoc - The document against which the field path will be
 * evaluated.
 */ function Qe(t, n, e) {
    if (n.search(ke) >= 0) throw We(`Invalid field path (${n}). Paths must not contain '~', '*', '/', '[', or ']'`, t, 
    /* hasConverter= */ !1, 
    /* path= */ void 0, e);
    try {
        return new pe(...n.split(".")).Ln;
    } catch (s) {
        throw We(`Invalid field path (${n}). Paths must not be empty, begin with '.', end with '.', or contain '..'`, t, 
        /* hasConverter= */ !1, 
        /* path= */ void 0, e);
    }
}

function We(t, n, e, s, r) {
    const i = s && !s.L(), o = void 0 !== r;
    let u = `Function ${n}() called with invalid data`;
    e && (u += " (via `toFirestore()`)"), u += ". ";
    let c = "";
    return (i || o) && (c += " (found", i && (c += " in field " + s), o && (c += " in document " + r), 
    c += ")"), new q(T, u + t + c);
}

/** Checks `haystack` if FieldPath `needle` is present. Runs in O(n). */ function ze(t, n) {
    return t.some((t => t.isEqual(n)));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Converts Firestore's internal types to the JavaScript types that we expose
 * to the user.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A `DocumentSnapshot` contains data read from a document in your Firestore
 * database. The data can be extracted with `.data()` or `.get(<field>)` to
 * get a specific field.
 *
 * For a `DocumentSnapshot` that points to a non-existing document, any data
 * access will return 'undefined'. You can use the `exists()` method to
 * explicitly verify a document's existence.
 */
class Ge {
    // Note: This class is stripped down version of the DocumentSnapshot in
    // the legacy SDK. The changes are:
    // - No support for SnapshotMetadata.
    // - No support for SnapshotOptions.
    /** @hideconstructor protected */
    constructor(t, n, e, s, r) {
        this.se = t, this.re = n, this.xn = e, this.ie = s, this.Sn = r;
    }
    /** Property of the `DocumentSnapshot` that provides the document's ID. */    get id() {
        return this.xn.path.C();
    }
    /**
     * The `DocumentReference` for the document included in the `DocumentSnapshot`.
     */    get ref() {
        return new ce(this.se, this.Sn, this.xn);
    }
    /**
     * Signals whether or not the document at the snapshot's location exists.
     *
     * @returns true if the document exists.
     */    exists() {
        return null !== this.ie;
    }
    /**
     * Retrieves all fields in the document as an `Object`. Returns `undefined` if
     * the document doesn't exist.
     *
     * @returns An `Object` containing all fields in the document or `undefined`
     * if the document doesn't exist.
     */    data() {
        if (this.ie) {
            if (this.Sn) {
                // We only want to use the converter and create a new DocumentSnapshot
                // if a converter has been provided.
                const t = new Ye(this.se, this.re, this.xn, this.ie, 
                /* converter= */ null);
                return this.Sn.fromFirestore(t);
            }
            return this.re.oe(this.ie.$t());
        }
    }
    /**
     * Retrieves the field specified by `fieldPath`. Returns `undefined` if the
     * document or field doesn't exist.
     *
     * @param fieldPath - The path (for example 'foo' or 'foo.bar') to a specific
     * field.
     * @returns The data at the specified field location or undefined if no such
     * field exists in the document.
     */
    // We are using `any` here to avoid an explicit cast by our users.
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    get(t) {
        if (this.ie) {
            const n = this.ie.data().field(Je("DocumentSnapshot.get", t));
            if (null !== n) return this.re.oe(n);
        }
    }
}

/**
 * A `QueryDocumentSnapshot` contains data read from a document in your
 * Firestore database as part of a query. The document is guaranteed to exist
 * and its data can be extracted with `.data()` or `.get(<field>)` to get a
 * specific field.
 *
 * A `QueryDocumentSnapshot` offers the same API surface as a
 * `DocumentSnapshot`. Since query results contain only existing documents, the
 * `exists` property will always be true and `data()` will never return
 * 'undefined'.
 */ class Ye extends Ge {
    /**
     * Retrieves all fields in the document as an `Object`.
     *
     * @override
     * @returns An `Object` containing all fields in the document.
     */
    data() {
        return super.data();
    }
}

/**
 * A `QuerySnapshot` contains zero or more `DocumentSnapshot` objects
 * representing the results of a query. The documents can be accessed as an
 * array via the `docs` property or enumerated using the `forEach` method. The
 * number of documents can be determined via the `empty` and `size`
 * properties.
 */ class He {
    /** @hideconstructor */
    constructor(t, n) {
        this.ue = n, this.query = t;
    }
    /** An array of all the documents in the `QuerySnapshot`. */    get docs() {
        return [ ...this.ue ];
    }
    /** The number of documents in the `QuerySnapshot`. */    get size() {
        return this.docs.length;
    }
    /** True if there are no documents in the `QuerySnapshot`. */    get empty() {
        return 0 === this.docs.length;
    }
    /**
     * Enumerates all of the documents in the `QuerySnapshot`.
     *
     * @param callback - A callback to be called with a `QueryDocumentSnapshot` for
     * each document in the snapshot.
     * @param thisArg - The `this` binding for the callback.
     */    forEach(t, n) {
        this.ue.forEach(t, n);
    }
}

/**
 * Returns true if the provided snapshots are equal.
 *
 * @param left - A snapshot to compare.
 * @param right - A snapshot to compare.
 * @returns true if the snapshots are equal.
 */ function Ke(t, n) {
    return t instanceof ue && (t = t.et), n instanceof ue && (n = n.et), t instanceof Ge && n instanceof Ge ? t.se === n.se && t.xn.isEqual(n.xn) && (null === t.ie ? null === n.ie : t.ie.isEqual(n.ie)) && t.Sn === n.Sn : t instanceof He && n instanceof He && (we(t.query, n.query) && lt(t.docs, n.docs, Ke));
}

/**
 * Helper that calls fromDotSeparatedString() but wraps any error thrown.
 */ function Je(t, n) {
    return "string" == typeof n ? Qe(t, n) : n instanceof ue ? n.et.Ln : n.Ln;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A `QueryConstraint` is used to narrow the set of documents returned by a
 * Firestore query. `QueryConstraint`s are created by invoking {@link where},
 * {@link orderBy}, {@link startAt}, {@link startAfter}, {@link
 * endBefore}, {@link endAt}, {@link limit} or {@link limitToLast} and
 * can then be passed to {@link query} to create a new query instance that
 * also contains this `QueryConstraint`.
 */
class Ze {}

/**
 * Creates a new immutable instance of `query` that is extended to also include
 * additional query constraints.
 *
 * @param query - The query instance to use as a base for the new constraints.
 * @param queryConstraints - The list of `QueryConstraint`s to apply.
 * @throws if any of the provided query constraints cannot be combined with the
 * existing or new constraints.
 */ function Xe(t, ...n) {
    for (const e of n) t = e.ce(t);
    return t;
}

class ts extends Ze {
    constructor(t, n, e) {
        super(), this.ae = t, this.he = n, this.le = e, this.type = "where";
    }
    ce(t) {
        const n = ve(t.firestore), e = function(t, n, e, s, r, i, o) {
            let u;
            if (r.Y()) {
                if ("array-contains" /* ARRAY_CONTAINS */ === i || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === i) throw new q(T, `Invalid Query. You can't perform '${i}' queries on FieldPath.documentId().`);
                if ("in" /* IN */ === i || "not-in" /* NOT_IN */ === i) {
                    ws(o, i);
                    const n = [];
                    for (const e of o) n.push(_s(s, t, e));
                    u = {
                        arrayValue: {
                            values: n
                        }
                    };
                } else u = _s(s, t, o);
            } else "in" /* IN */ !== i && "not-in" /* NOT_IN */ !== i && "array-contains-any" /* ARRAY_CONTAINS_ANY */ !== i || ws(o, i), 
            u = Ce(e, n, o, 
            /* allowArrays= */ "in" /* IN */ === i || "not-in" /* NOT_IN */ === i);
            const c = kt.create(r, i, u);
            return function(t, n) {
                if (n.Ot()) {
                    const e = on(t);
                    if (null !== e && !e.isEqual(n.field)) throw new q(T, `Invalid query. All where filters with an inequality (<, <=, !=, not-in, >, or >=) must be on the same field. But you have inequality filters on '${e.toString()}' and '${n.field.toString()}'`);
                    const s = rn(t);
                    null !== s && ms(t, n.field, s);
                }
                const e = function(t, n) {
                    for (const e of t.filters) if (n.indexOf(e.op) >= 0) return e.op;
                    return null;
                }(t, 
                /**
 * Given an operator, returns the set of operators that cannot be used with it.
 *
 * Operators in a query must adhere to the following set of rules:
 * 1. Only one array operator is allowed.
 * 2. Only one disjunctive operator is allowed.
 * 3. NOT_EQUAL cannot be used with another NOT_EQUAL operator.
 * 4. NOT_IN cannot be used with array, disjunctive, or NOT_EQUAL operators.
 *
 * Array operators: ARRAY_CONTAINS, ARRAY_CONTAINS_ANY
 * Disjunctive operators: IN, ARRAY_CONTAINS_ANY, NOT_IN
 */
                function(t) {
                    switch (t) {
                      case "!=" /* NOT_EQUAL */ :
                        return [ "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ];

                      case "array-contains" /* ARRAY_CONTAINS */ :
                        return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ];

                      case "in" /* IN */ :
                        return [ "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

                      case "array-contains-any" /* ARRAY_CONTAINS_ANY */ :
                        return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

                      case "not-in" /* NOT_IN */ :
                        return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ , "!=" /* NOT_EQUAL */ ];

                      default:
                        return [];
                    }
                }(n.op));
                if (null !== e) 
                // Special case when it's a duplicate op to give a slightly clearer error message.
                throw e === n.op ? new q(T, `Invalid query. You cannot use more than one '${n.op.toString()}' filter.`) : new q(T, `Invalid query. You cannot use '${n.op.toString()}' filters with '${e.toString()}' filters.`);
            }(t, c), c;
        }(t.On, "where", n, t.firestore.Tn, this.ae, this.he, this.le);
        return new ae(t.firestore, t.Sn, function(t, n) {
            const e = t.filters.concat([ n ]);
            return new en(t.path, t.collectionGroup, t.Ct.slice(), e, t.limit, t.limitType, t.startAt, t.endAt);
        }(t.On, e));
    }
}

/**
 * Creates a `QueryConstraint` that enforces that documents must contain the
 * specified field and that the value should satisfy the relation constraint
 * provided.
 *
 * @param fieldPath - The path to compare
 * @param opStr - The operation string (e.g "&lt;", "&lt;=", "==", "&lt;",
 *   "&lt;=", "!=").
 * @param value - The value for comparison
 * @returns The created `Query`.
 */ function ns(t, n, e) {
    const s = n, r = Je("where", t);
    return new ts(r, s, e);
}

class es extends Ze {
    constructor(t, n) {
        super(), this.ae = t, this.fe = n, this.type = "orderBy";
    }
    ce(t) {
        const n = function(t, n, e) {
            if (null !== t.startAt) throw new q(T, "Invalid query. You must not call startAt() or startAfter() before calling orderBy().");
            if (null !== t.endAt) throw new q(T, "Invalid query. You must not call endAt() or endBefore() before calling orderBy().");
            const s = new Xt(n, e);
            return function(t, n) {
                if (null === rn(t)) {
                    // This is the first order by. It must match any inequality.
                    const e = on(t);
                    null !== e && ms(t, e, n.field);
                }
            }(t, s), s;
        }
        /**
 * Create a Bound from a query and a document.
 *
 * Note that the Bound will always include the key of the document
 * and so only the provided document will compare equal to the returned
 * position.
 *
 * Will throw if the document does not contain all fields of the order by
 * of the query or if any of the fields in the order by are an uncommitted
 * server timestamp.
 */ (t.On, this.ae, this.fe);
        return new ae(t.firestore, t.Sn, function(t, n) {
            // TODO(dimond): validate that orderBy does not list the same key twice.
            const e = t.Ct.concat([ n ]);
            return new en(t.path, t.collectionGroup, e, t.filters.slice(), t.limit, t.limitType, t.startAt, t.endAt);
        }(t.On, n));
    }
}

/**
 * Creates a `QueryConstraint` that sorts the query result by the
 * specified field, optionally in descending order instead of ascending.
 *
 * @param fieldPath - The field to sort by.
 * @param directionStr - Optional direction to sort by ('asc' or 'desc'). If
 * not specified, order will be ascending.
 * @returns The created `Query`.
 */ function ss(t, n = "asc") {
    const e = n, s = Je("orderBy", t);
    return new es(s, e);
}

class rs extends Ze {
    constructor(t, n, e) {
        super(), this.type = t, this.de = n, this._e = e;
    }
    ce(t) {
        return new ae(t.firestore, t.Sn, function(t, n, e) {
            return new en(t.path, t.collectionGroup, t.Ct.slice(), t.filters.slice(), n, e, t.startAt, t.endAt);
        }(t.On, this.de, this._e));
    }
}

/**
 * Creates a `QueryConstraint` that only returns the first matching documents.
 *
 * @param limit - The maximum number of items to return.
 * @returns The created `Query`.
 */ function is(t) {
    return X("limit", t), new rs("limit", t, "F" /* First */);
}

/**
 * Creates a `QueryConstraint` that only returns the last matching documents.
 *
 * You must specify at least one `orderBy` clause for `limitToLast` queries,
 * otherwise an exception will be thrown during execution.
 *
 * @param limit - The maximum number of items to return.
 * @returns The created `Query`.
 */ function os(t) {
    return X("limitToLast", t), new rs("limitToLast", t, "L" /* Last */);
}

class us extends Ze {
    constructor(t, n, e) {
        super(), this.type = t, this.we = n, this.me = e;
    }
    ce(t) {
        const n = ds(t, this.type, this.we, this.me);
        return new ae(t.firestore, t.Sn, function(t, n) {
            return new en(t.path, t.collectionGroup, t.Ct.slice(), t.filters.slice(), t.limit, t.limitType, n, t.endAt);
        }(t.On, n));
    }
}

function cs(...t) {
    return new us("startAt", t, /*before=*/ !0);
}

function as(...t) {
    return new us("startAfter", t, 
    /*before=*/ !1);
}

class hs extends Ze {
    constructor(t, n, e) {
        super(), this.type = t, this.we = n, this.me = e;
    }
    ce(t) {
        const n = ds(t, this.type, this.we, this.me);
        return new ae(t.firestore, t.Sn, function(t, n) {
            return new en(t.path, t.collectionGroup, t.Ct.slice(), t.filters.slice(), t.limit, t.limitType, t.startAt, n);
        }(t.On, n));
    }
}

function ls(...t) {
    return new hs("endBefore", t, /*before=*/ !0);
}

function fs(...t) {
    return new hs("endAt", t, /*before=*/ !1);
}

/** Helper function to create a bound from a document or fields */ function ds(t, n, e, s) {
    if (e[0] instanceof ue && (e[0] = e[0].et), e[0] instanceof Ge) return function(t, n, e, s, r) {
        if (!s) throw new q(P, "Can't use a DocumentSnapshot that doesn't exist for " + e + "().");
        const i = [];
        // Because people expect to continue/end a query at the exact document
        // provided, we need to use the implicit sort order rather than the explicit
        // sort order, because it's guaranteed to contain the document key. That way
        // the position becomes unambiguous and the query continues/ends exactly at
        // the provided document. Without the key (by using the explicit sort
        // orders), multiple documents could match the position, yielding duplicate
        // results.
                for (const e of cn(t)) if (e.field.Y()) i.push(Ft(n, s.key)); else {
            const t = s.field(e.field);
            if (Pt(t)) throw new q(T, 'Invalid query. You are trying to start or end a query using a document for which the field "' + e.field + '" is an uncommitted server timestamp. (Since the value of this field is unknown, you cannot start/end a query with it.)');
            if (null === t) {
                const t = e.field.B();
                throw new q(T, `Invalid query. You are trying to start or end a query using a document for which the field '${t}' (used as the orderBy) does not exist.`);
            }
            i.push(t);
        }
        return new Zt(i, r);
    }
    /**
 * Converts a list of field values to a Bound for the given query.
 */ (t.On, t.firestore.Tn, n, e[0].ie, s);
    {
        const r = ve(t.firestore);
        return function(t, n, e, s, r, i) {
            // Use explicit order by's because it has to match the query the user made
            const o = t.Ct;
            if (r.length > o.length) throw new q(T, `Too many arguments provided to ${s}(). The number of arguments must be less than or equal to the number of orderBy() clauses`);
            const u = [];
            for (let i = 0; i < r.length; i++) {
                const c = r[i];
                if (o[i].field.Y()) {
                    if ("string" != typeof c) throw new q(T, `Invalid query. Expected a string for document ID in ${s}(), but got a ${typeof c}`);
                    if (!un(t) && -1 !== c.indexOf("/")) throw new q(T, `Invalid query. When querying a collection and ordering by FieldPath.documentId(), the value passed to ${s}() must be a plain document ID, but '${c}' contains a slash.`);
                    const e = t.path.child(Q.k(c));
                    if (!G.tt(e)) throw new q(T, `Invalid query. When querying a collection group and ordering by FieldPath.documentId(), the value passed to ${s}() must result in a valid document path, but '${e}' is not because it contains an odd number of segments.`);
                    const r = new G(e);
                    u.push(Ft(n, r));
                } else {
                    const t = Ce(e, s, c);
                    u.push(t);
                }
            }
            return new Zt(u, i);
        }
        /**
 * Parses the given documentIdValue into a ReferenceValue, throwing
 * appropriate errors if the value is anything other than a DocumentReference
 * or String, or if the string is malformed.
 */ (t.On, t.firestore.Tn, r, n, e, s);
    }
}

function _s(t, n, e) {
    if (e instanceof ue && (e = e.et), "string" == typeof e) {
        if ("" === e) throw new q(T, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid document ID, but it was an empty string.");
        if (!un(n) && -1 !== e.indexOf("/")) throw new q(T, `Invalid query. When querying a collection by FieldPath.documentId(), you must provide a plain document ID, but '${e}' contains a '/' character.`);
        const s = n.path.child(Q.k(e));
        if (!G.tt(s)) throw new q(T, `Invalid query. When querying a collection group by FieldPath.documentId(), the value provided must result in a valid document path, but '${s}' is not because it has an odd number of segments (${s.length}).`);
        return Ft(t, new G(s));
    }
    if (e instanceof ce) return Ft(t, e.xn);
    throw new q(T, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid string or a DocumentReference, but it was: " + J(e) + ".");
}

/**
 * Validates that the value passed into a disjunctive filter satisfies all
 * array requirements.
 */ function ws(t, n) {
    if (!Array.isArray(t) || 0 === t.length) throw new q(T, `Invalid Query. A non-empty array is required for '${n.toString()}' filters.`);
    if (t.length > 10) throw new q(T, `Invalid Query. '${n.toString()}' filters support a maximum of 10 elements in the value array.`);
}

function ms(t, n, e) {
    if (!e.isEqual(n)) throw new q(T, `Invalid query. You have a where filter with an inequality (<, <=, !=, not-in, >, or >=) on field '${n.toString()}' and so you must also use '${n.toString()}' as your first argument to orderBy(), but your first orderBy() is on field '${e.toString()}' instead.`);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Converts custom model object of type T into DocumentData by applying the
 * converter if it exists.
 *
 * This function is used when converting user objects to DocumentData
 * because we want to provide the user with a more specific error message if
 * their set() or fails due to invalid data originating from a toFirestore()
 * call.
 */ function ps(t, n, e) {
    let s;
    // Cast to `any` in order to satisfy the union type constraint on
    // toFirestore().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return s = t ? e && (e.merge || e.mergeFields) ? t.toFirestore(n, e) : t.toFirestore(n) : n, 
    s;
}

class ys extends class {
    oe(t, n = "none") {
        switch (gt(t)) {
          case 0 /* NullValue */ :
            return null;

          case 1 /* BooleanValue */ :
            return t.booleanValue;

          case 2 /* NumberValue */ :
            return Tt(t.integerValue || t.doubleValue);

          case 3 /* TimestampValue */ :
            return this.pe(t.timestampValue);

          case 4 /* ServerTimestampValue */ :
            return this.ye(t, n);

          case 5 /* StringValue */ :
            return t.stringValue;

          case 6 /* BlobValue */ :
            return this.Ee(At(t.bytesValue));

          case 7 /* RefValue */ :
            return this.Ie(t.referenceValue);

          case 8 /* GeoPointValue */ :
            return this.Te(t.geoPointValue);

          case 9 /* ArrayValue */ :
            return this.Ae(t.arrayValue, n);

          case 10 /* ObjectValue */ :
            return this.Pe(t.mapValue, n);

          default:
            throw w();
        }
    }
    Pe(t, n) {
        const e = {};
        return wt(t.fields || {}, ((t, s) => {
            e[t] = this.oe(s, n);
        })), e;
    }
    Te(t) {
        return new Ie(Tt(t.latitude), Tt(t.longitude));
    }
    Ae(t, n) {
        return (t.values || []).map((t => this.oe(t, n)));
    }
    ye(t, n) {
        switch (n) {
          case "previous":
            const e = Rt(t);
            return null == e ? null : this.oe(e, n);

          case "estimate":
            return this.pe(Vt(t));

          default:
            return null;
        }
    }
    pe(t) {
        const n = It(t);
        return new ft(n.seconds, n.nanos);
    }
    Re(t, n) {
        const e = Q.k(t);
        m(Wn(e));
        const s = new B(e.get(1), e.get(3)), r = new G(e.S(5));
        return s.isEqual(n) || 
        // TODO(b/64130202): Somehow support foreign references.
        f(`Document ${r} contains a document reference within a different database (${s.projectId}/${s.database}) which is not supported. It will be treated as a reference in the current database (${n.projectId}/${n.database}) instead.`), 
        r;
    }
} {
    constructor(t) {
        super(), this.firestore = t;
    }
    Ee(t) {
        return new me(t);
    }
    Ie(t) {
        const n = this.Re(t, this.firestore.Tn);
        return new ce(this.firestore, /* converter= */ null, n);
    }
}

/**
 * Reads the document referred to by the specified document reference.
 *
 * All documents are directly fetched from the server, even if the document was
 * previously read or modified. Recent modifications are only reflected in the
 * retrieved `DocumentSnapshot` if they have already been applied by the
 * backend. If the client is offline, the read fails. If you like to use
 * caching or see local modifications, please use the full Firestore SDK.
 *
 * @param reference - The reference of the document to fetch.
 * @returns A Promise resolved with a `DocumentSnapshot` containing the current
 * document contents.
 */ function Es(t) {
    const n = ne((t = Z(t, ce)).firestore), e = new ys(t.firestore);
    return Jn(n, [ t.xn ]).then((n => {
        m(1 === n.length);
        const s = n[0];
        return new Ge(t.firestore, e, t.xn, s instanceof Ut ? s : null, t.Sn);
    }));
}

/**
 * Executes the query and returns the results as a {@link QuerySnapshot}.
 *
 * All queries are executed directly by the server, even if the the query was
 * previously executed. Recent modifications are only reflected in the retrieved
 * results if they have already been applied by the backend. If the client is
 * offline, the operation fails. To see previously cached result and local
 * modifications, use the full Firestore SDK.
 *
 * @param query - The `Query` to execute.
 * @returns A Promise that will be resolved with the results of the query.
 */ function Is(t) {
    !function(t) {
        if (sn(t) && 0 === t.Ct.length) throw new q(F, "limitToLast() queries require specifying at least one orderBy() clause");
    }((t = Z(t, ae)).On);
    const n = ne(t.firestore), e = new ys(t.firestore);
    return Zn(n, t.On).then((n => {
        const s = n.map((n => new Ye(t.firestore, e, n.key, n, t.Sn)));
        return sn(t.On) && 
        // Limit to last queries reverse the orderBy constraint that was
        // specified by the user. As such, we need to reverse the order of the
        // results to return the documents in the expected order.
        s.reverse(), new He(t, s);
    }));
}

function Ts(t, n, e) {
    const s = ps((t = Z(t, ce)).Sn, n, e), r = be(ve(t.firestore), "setDoc", t.xn, s, null !== t.Sn, e);
    return Kn(ne(t.firestore), [ r.Mn(t.xn, yn.Qt()) ]);
}

function As(t, n, e, ...s) {
    const r = ve((t = Z(t, ce)).firestore);
    // For Compat types, we have to "extract" the underlying types before
    // performing validation.
        let i;
    n instanceof ue && (n = n.et), i = "string" == typeof n || n instanceof pe ? Oe(r, "updateDoc", t.xn, n, e, s) : qe(r, "updateDoc", t.xn, n);
    return Kn(ne(t.firestore), [ i.Mn(t.xn, yn.exists(!0)) ]);
}

/**
 * Deletes the document referred to by the specified `DocumentReference`.
 *
 * The deletion will only be reflected in document reads that occur after the
 * returned Promise resolves. If the client is offline, the
 * delete fails. If you would like to see local modifications or buffer writes
 * until the client is online, use the full Firestore SDK.
 *
 * @param reference - A reference to the document to delete.
 * @returns A Promise resolved once the document has been successfully
 * deleted from the backend.
 */ function Ps(t) {
    return Kn(ne((t = Z(t, ce)).firestore), [ new An(t.xn, yn.Qt()) ]);
}

/**
 * Add a new document to specified `CollectionReference` with the given data,
 * assigning it a document ID automatically.
 *
 * The result of this write will only be reflected in document reads that occur
 * after the returned Promise resolves. If the client is offline, the
 * write fails. If you would like to see local modifications or buffer writes
 * until the client is online, use the full Firestore SDK.
 *
 * @param reference - A reference to the collection to add this document to.
 * @param data - An Object containing the data for the new document.
 * @returns A Promise resolved with a `DocumentReference` pointing to the
 * newly created document after it has been written to the backend.
 */ function Rs(t, n) {
    const e = de(t = Z(t, he)), s = ps(t.Sn, n), r = be(ve(t.firestore), "addDoc", e.xn, s, null !== e.Sn, {});
    return Kn(ne(t.firestore), [ r.Mn(e.xn, yn.exists(!1)) ]).then((() => e));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns a sentinel for use with {@link updateDoc} or
 * {@link setDoc} with `{merge: true}` to mark a field for deletion.
 */ function Vs() {
    return new Ne("deleteField");
}

/**
 * Returns a sentinel used with {@link setDoc} or {@link updateDoc} to
 * include a server-generated timestamp in the written data.
 */ function gs() {
    return new Fe("serverTimestamp");
}

/**
 * Returns a special value that can be used with {@link setDoc} or {@link
 * updateDoc} that tells the server to union the given elements with any array
 * value that already exists on the server. Each specified element that doesn't
 * already exist in the array will be added to the end. If the field being
 * modified is not already an array it will be overwritten with an array
 * containing exactly the specified elements.
 *
 * @param elements - The elements to union into the array.
 * @returns The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`.
 */ function vs(...t) {
    // NOTE: We don't actually parse the data until it's used in set() or
    // update() since we'd need the Firestore instance to do this.
    return new $e("arrayUnion", t);
}

/**
 * Returns a special value that can be used with {@link (setDoc:1)} or {@link
 * updateDoc} that tells the server to remove the given elements from any
 * array value that already exists on the server. All instances of each element
 * specified will be removed from the array. If the field being modified is not
 * already an array it will be overwritten with an empty array.
 *
 * @param elements - The elements to remove from the array.
 * @returns The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`
 */ function bs(...t) {
    // NOTE: We don't actually parse the data until it's used in set() or
    // update() since we'd need the Firestore instance to do this.
    return new Se("arrayRemove", t);
}

/**
 * Returns a special value that can be used with {@link setDoc} or {@link
 * updateDoc} that tells the server to increment the field's current value by
 * the given value.
 *
 * If either the operand or the current field value uses floating point
 * precision, all arithmetic follows IEEE 754 semantics. If both values are
 * integers, values outside of JavaScript's safe number range
 * (`Number.MIN_SAFE_INTEGER` to `Number.MAX_SAFE_INTEGER`) are also subject to
 * precision loss. Furthermore, once processed by the Firestore backend, all
 * integer operations are capped between -2^63 and 2^63-1.
 *
 * If the current field value is not of type `number`, or if the field does not
 * yet exist, the transformation sets the field to the given value.
 *
 * @param n - The value to increment by.
 * @returns The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`
 */ function Ns(t) {
    return new xe("increment", t);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A write batch, used to perform multiple writes as a single atomic unit.
 *
 * A `WriteBatch` object can be acquired by calling {@link writeBatch}. It
 * provides methods for adding writes to the write batch. None of the writes
 * will be committed (or visible locally) until {@link WriteBatch#commit} is
 * called.
 */ class Ds {
    /** @hideconstructor */
    constructor(t, n) {
        this.se = t, this.Ve = n, this.ge = [], this.ve = !1, this.be = ve(t);
    }
    set(t, n, e) {
        this.Ne();
        const s = Fs(t, this.se), r = ps(s.Sn, n, e), i = be(this.be, "WriteBatch.set", s.xn, r, null !== s.Sn, e);
        return this.ge.push(i.Mn(s.xn, yn.Qt())), this;
    }
    update(t, n, e, ...s) {
        this.Ne();
        const r = Fs(t, this.se);
        // For Compat types, we have to "extract" the underlying types before
        // performing validation.
                let i;
        return n instanceof ue && (n = n.et), i = "string" == typeof n || n instanceof pe ? Oe(this.be, "WriteBatch.update", r.xn, n, e, s) : qe(this.be, "WriteBatch.update", r.xn, n), 
        this.ge.push(i.Mn(r.xn, yn.exists(!0))), this;
    }
    /**
     * Deletes the document referred to by the provided {@link DocumentReference}.
     *
     * @param documentRef - A reference to the document to be deleted.
     * @returns This `WriteBatch` instance. Used for chaining method calls.
     */    delete(t) {
        this.Ne();
        const n = Fs(t, this.se);
        return this.ge = this.ge.concat(new An(n.xn, yn.Qt())), this;
    }
    /**
     * Commits all of the writes in this write batch as a single atomic unit.
     *
     * The result of these writes will only be reflected in document reads that
     * occur after the returned Promise resolves. If the client is offline, the
     * write fails. If you would like to see local modifications or buffer writes
     * until the client is online, use the full Firestore SDK.
     *
     * @returns A Promise resolved once all of the writes in the batch have been
     * successfully written to the backend as an atomic unit (note that it won't
     * resolve while you're offline).
     */    commit() {
        return this.Ne(), this.ve = !0, this.ge.length > 0 ? this.Ve(this.ge) : Promise.resolve();
    }
    Ne() {
        if (this.ve) throw new q(b, "A write batch can no longer be used after commit() has been called.");
    }
}

function Fs(t, n) {
    if (t instanceof ue && (t = t.et), t.firestore !== n) throw new q(T, "Provided document reference is from a different Firestore instance.");
    return t;
}

/**
 * Creates a write batch, used for performing multiple writes as a single
 * atomic operation. The maximum number of writes allowed in a single WriteBatch
 * is 500.
 *
 * The result of these writes will only be reflected in document reads that
 * occur after the returned Promise resolves. If the client is offline, the
 * write fails. If you would like to see local modifications or buffer writes
 * until the client is online, use the full Firestore SDK.
 *
 * @returns A `WriteBatch` that can be used to atomically execute multiple
 * writes.
 */ function $s(t) {
    const n = ne(t = Z(t, ee));
    return new Ds(t, (t => Kn(n, t)));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Internal transaction object responsible for accumulating the mutations to
 * perform and the base versions for any documents read.
 */ class Ss {
    constructor(t) {
        this.De = t, 
        // The version of each document that was read during this transaction.
        this.Fe = new Map, this.mutations = [], this.$e = !1, 
        /**
         * A deferred usage error that occurred previously in this transaction that
         * will cause the transaction to fail once it actually commits.
         */
        this.Se = null, 
        /**
         * Set of documents that have been written in the transaction.
         *
         * When there's more than one write to the same key in a transaction, any
         * writes after the first are handled differently.
         */
        this.xe = new Set;
    }
    async qe(t) {
        if (this.Oe(), this.mutations.length > 0) throw new q(T, "Firestore transactions require all reads to be executed before all writes.");
        const n = await Jn(this.De, t);
        return n.forEach((t => {
            t instanceof jt || t instanceof Ut ? this.Ce(t) : w();
        })), n;
    }
    set(t, n) {
        this.write(n.Mn(t, this.zt(t))), this.xe.add(t.toString());
    }
    update(t, n) {
        try {
            this.write(n.Mn(t, this.Le(t)));
        } catch (t) {
            this.Se = t;
        }
        this.xe.add(t.toString());
    }
    delete(t) {
        this.write(new An(t, this.zt(t))), this.xe.add(t.toString());
    }
    async commit() {
        if (this.Oe(), this.Se) throw this.Se;
        const t = this.Fe;
        // For each mutation, note that the doc was written.
                this.mutations.forEach((n => {
            t.delete(n.key.toString());
        })), 
        // For each document that was read but not written to, we want to perform
        // a `verify` operation.
        t.forEach(((t, n) => {
            const e = G.J(n);
            this.mutations.push(new Pn(e, this.zt(e)));
        })), await Kn(this.De, this.mutations), this.$e = !0;
    }
    Ce(t) {
        let n;
        if (t instanceof Ut) n = t.version; else {
            if (!(t instanceof jt)) throw w();
            // For deleted docs, we must use baseVersion 0 when we overwrite them.
            n = dt.min();
        }
        const e = this.Fe.get(t.key.toString());
        if (e) {
            if (!n.isEqual(e)) 
            // This transaction will fail no matter what.
            throw new q(N, "Document version changed between two reads.");
        } else this.Fe.set(t.key.toString(), n);
    }
    /**
     * Returns the version of this document when it was read in this transaction,
     * as a precondition, or no precondition if it was not read.
     */    zt(t) {
        const n = this.Fe.get(t.toString());
        return !this.xe.has(t.toString()) && n ? yn.updateTime(n) : yn.Qt();
    }
    /**
     * Returns the precondition for a document if the operation is an update.
     */    Le(t) {
        const n = this.Fe.get(t.toString());
        // The first time a document is written, we want to take into account the
        // read time and existence
                if (!this.xe.has(t.toString()) && n) {
            if (n.isEqual(dt.min())) 
            // The document doesn't exist, so fail the transaction.
            // This has to be validated locally because you can't send a
            // precondition that a document does not exist without changing the
            // semantics of the backend write to be an insert. This is the reverse
            // of what we want, since we want to assert that the document doesn't
            // exist but then send the update and have it fail. Since we can't
            // express that to the backend, we have to validate locally.
            // Note: this can change once we can send separate verify writes in the
            // transaction.
            throw new q(T, "Can't update a document that doesn't exist.");
            // Document exists, base precondition on document update time.
                        return yn.updateTime(n);
        }
        // Document was not read, so we just use the preconditions for a blind
        // update.
        return yn.exists(!0);
    }
    write(t) {
        this.Oe(), this.mutations.push(t);
    }
    Oe() {}
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * TransactionRunner encapsulates the logic needed to run and retry transactions
 * with backoff.
 */
class xs {
    constructor(t, n, e, s) {
        this.Yt = t, this.De = n, this.updateFunction = e, this.Zt = s, this.Ue = 5, this.je = new Yn(this.Yt, "transaction_retry" /* TransactionRetry */);
    }
    /** Runs the transaction and sets the result on deferred. */    run() {
        this.Me();
    }
    Me() {
        this.je.dn((async () => {
            const t = new Ss(this.De), n = this.Be(t);
            n && n.then((n => {
                this.Yt.sn((() => t.commit().then((() => {
                    this.Zt.resolve(n);
                })).catch((t => {
                    this.ke(t);
                }))));
            })).catch((t => {
                this.ke(t);
            }));
        }));
    }
    Be(t) {
        try {
            const n = this.updateFunction(t);
            return !tt(n) && n.catch && n.then ? n : (this.Zt.reject(Error("Transaction callback must return a Promise")), 
            null);
        } catch (t) {
            // Do not retry errors thrown by user provided updateFunction.
            return this.Zt.reject(t), null;
        }
    }
    ke(t) {
        this.Ue > 0 && this.Qe(t) ? (this.Ue -= 1, this.Yt.sn((() => (this.Me(), Promise.resolve())))) : this.Zt.reject(t);
    }
    Qe(t) {
        if ("FirebaseError" === t.name) {
            // In transactions, the backend will fail outdated reads with FAILED_PRECONDITION and
            // non-matching document versions with ABORTED. These errors should be retried.
            const n = t.code;
            return "aborted" === n || "failed-precondition" === n || !
            /**
 * Determines whether an error code represents a permanent error when received
 * in response to a non-write operation.
 *
 * See isPermanentWriteError for classifying write errors.
 */
            function(t) {
                switch (t) {
                  case y:
                    return w();

                  case E:
                  case I:
                  case A:
                  case v:
                  case $:
                  case S:
 // Unauthenticated means something went wrong with our token and we need
                    // to retry with new credentials which will happen automatically.
                                      case g:
                    return !1;

                  case T:
                  case P:
                  case R:
                  case V:
                  case b:
 // Aborted might be retried in some scenarios, but that is dependant on
                    // the context and should handled individually by the calling code.
                    // See https://cloud.google.com/apis/design/errors.
                                      case N:
                  case D:
                  case F:
                  case x:
                    return !0;

                  default:
                    return w();
                }
            }(n);
        }
        return !1;
    }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** The Platform's 'document' implementation or null if not available. */ function qs() {
    // `document` is not always available, e.g. in ReactNative and WebWorkers.
    // eslint-disable-next-line no-restricted-globals
    return "undefined" != typeof document ? document : null;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ class Os {
    constructor() {
        // The last promise in the queue.
        this.We = Promise.resolve(), 
        // A list of retryable operations. Retryable operations are run in order and
        // retried with backoff.
        this.ze = [], 
        // Is this AsyncQueue being shut down? Once it is set to true, it will not
        // be changed again.
        this.Ge = !1, 
        // Operations scheduled to be queued in the future. Operations are
        // automatically removed after they are run or canceled.
        this.Ye = [], 
        // visible for testing
        this.He = null, 
        // Flag set while there's an outstanding AsyncQueue operation, used for
        // assertion sanity-checks.
        this.Ke = !1, 
        // List of TimerIds to fast-forward delays for.
        this.Je = [], 
        // Backoff timer used to schedule retries for retryable operations
        this.je = new Yn(this, "async_queue_retry" /* AsyncQueueRetry */), 
        // Visibility handler that triggers an immediate retry of all retryable
        // operations. Meant to speed up recovery when we regain file system access
        // after page comes into foreground.
        this.Ze = () => {
            const t = qs();
            t && l("AsyncQueue", "Visibility state changed to " + t.visibilityState), this.je.mn();
        };
        const t = qs();
        t && "function" == typeof t.addEventListener && t.addEventListener("visibilitychange", this.Ze);
    }
    get Xe() {
        return this.Ge;
    }
    /**
     * Adds a new operation to the queue without waiting for it to complete (i.e.
     * we ignore the Promise result).
     */    sn(t) {
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.enqueue(t);
    }
    ts(t) {
        this.ns(), 
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.es(t);
    }
    ss() {
        if (!this.Ge) {
            this.Ge = !0;
            const t = qs();
            t && "function" == typeof t.removeEventListener && t.removeEventListener("visibilitychange", this.Ze);
        }
    }
    enqueue(t) {
        return this.ns(), this.Ge ? new Promise((t => {})) : this.es(t);
    }
    rs(t) {
        this.sn((() => (this.ze.push(t), this.os())));
    }
    /**
     * Runs the next operation from the retryable queue. If the operation fails,
     * reschedules with backoff.
     */    async os() {
        if (0 !== this.ze.length) {
            try {
                await this.ze[0](), this.ze.shift(), this.je.reset();
            } catch (t) {
                if (!function(t) {
                    // Use name equality, as instanceof checks on errors don't work with errors
                    // that wrap other errors.
                    return "IndexedDbTransactionError" === t.name;
                }(t)) throw t;
 // Failure will be handled by AsyncQueue
                                l("AsyncQueue", "Operation failed with retryable error: " + t);
            }
            this.ze.length > 0 && 
            // If there are additional operations, we re-schedule `retryNextOp()`.
            // This is necessary to run retryable operations that failed during
            // their initial attempt since we don't know whether they are already
            // enqueued. If, for example, `op1`, `op2`, `op3` are enqueued and `op1`
            // needs to  be re-run, we will run `op1`, `op1`, `op2` using the
            // already enqueued calls to `retryNextOp()`. `op3()` will then run in the
            // call scheduled here.
            // Since `backoffAndRun()` cancels an existing backoff and schedules a
            // new backoff on every call, there is only ever a single additional
            // operation in the queue.
            this.je.dn((() => this.os()));
        }
    }
    es(t) {
        const n = this.We.then((() => (this.Ke = !0, t().catch((t => {
            this.He = t, this.Ke = !1;
            // Re-throw the error so that this.tail becomes a rejected Promise and
            // all further attempts to chain (via .then) will just short-circuit
            // and return the rejected Promise.
            throw f("INTERNAL UNHANDLED ERROR: ", 
            /**
 * Chrome includes Error.message in Error.stack. Other browsers do not.
 * This returns expected output of message + stack when available.
 * @param error - Error or FirestoreError
 */
            function(t) {
                let n = t.message || "";
                t.stack && (n = t.stack.includes(t.message) ? t.stack : t.message + "\n" + t.stack);
                return n;
            }
            /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
            // TODO(mrschmidt) Consider using `BaseTransaction` as the base class in the
            // legacy SDK.
            /**
 * A reference to a transaction.
 *
 * The `Transaction` object passed to a transaction's `updateFunction` provides
 * the methods to read and write data within the transaction context. See
 * {@link runTransaction}.
 */ (t)), t;
        })).then((t => (this.Ke = !1, t))))));
        return this.We = n, n;
    }
    wn(t, n, e) {
        this.ns(), 
        // Fast-forward delays for timerIds that have been overriden.
        this.Je.indexOf(t) > -1 && (n = 0);
        const s = Gn.Xt(this, t, n, e, (t => this.us(t)));
        return this.Ye.push(s), s;
    }
    ns() {
        this.He && w();
    }
    cs() {}
    /**
     * Waits until all currently queued tasks are finished executing. Delayed
     * operations are not run.
     */    async hs() {
        // Operations in the queue prior to draining may have enqueued additional
        // operations. Keep draining the queue until the tail is no longer advanced,
        // which indicates that no more new operations were enqueued and that all
        // operations were executed.
        let t;
        do {
            t = this.We, await t;
        } while (t !== this.We);
    }
    /**
     * For Tests: Determine if a delayed operation with a particular TimerId
     * exists.
     */    ls(t) {
        for (const n of this.Ye) if (n.Ht === t) return !0;
        return !1;
    }
    /**
     * For Tests: Runs some or all delayed operations early.
     *
     * @param lastTimerId - Delayed operations up to and including this TimerId
     * will be drained. Pass TimerId.All to run all delayed operations.
     * @returns a Promise that resolves once all operations have been run.
     */    fs(t) {
        // Note that draining may generate more delayed ops, so we do that first.
        return this.hs().then((() => {
            // Run ops in the same order they'd run if they ran naturally.
            this.Ye.sort(((t, n) => t.Kt - n.Kt));
            for (const n of this.Ye) if (n.en(), "all" /* All */ !== t && n.Ht === t) break;
            return this.hs();
        }));
    }
    /**
     * For Tests: Skip all subsequent delays for a timer id.
     */    ds(t) {
        this.Je.push(t);
    }
    /** Called once a DelayedOperation is run or canceled. */    us(t) {
        // NOTE: indexOf / slice are O(n), but delayedOperations is expected to be small.
        const n = this.Ye.indexOf(t);
        this.Ye.splice(n, 1);
    }
}

class Cs {
    /** @hideconstructor */
    constructor(t, n) {
        this.se = t, this._s = n, this.be = ve(t);
    }
    /**
     * Reads the document referenced by the provided {@link DocumentReference}.
     *
     * @param documentRef - A reference to the document to be read.
     * @returns A `DocumentSnapshot` with the read data.
     */    get(t) {
        const n = Fs(t, this.se), e = new ys(this.se);
        return this._s.qe([ n.xn ]).then((t => {
            if (!t || 1 !== t.length) return w();
            const s = t[0];
            if (s instanceof jt) return new Ge(this.se, e, n.xn, null, n.Sn);
            if (s instanceof Ut) return new Ge(this.se, e, s.key, s, n.Sn);
            throw w();
        }));
    }
    set(t, n, e) {
        const s = Fs(t, this.se), r = ps(s.Sn, n, e), i = be(this.be, "Transaction.set", s.xn, r, null !== s.Sn, e);
        return this._s.set(s.xn, i), this;
    }
    update(t, n, e, ...s) {
        const r = Fs(t, this.se);
        // For Compat types, we have to "extract" the underlying types before
        // performing validation.
                let i;
        return n instanceof ue && (n = n.et), i = "string" == typeof n || n instanceof pe ? Oe(this.be, "Transaction.update", r.xn, n, e, s) : qe(this.be, "Transaction.update", r.xn, n), 
        this._s.update(r.xn, i), this;
    }
    /**
     * Deletes the document referred to by the provided {@link DocumentReference}.
     *
     * @param documentRef - A reference to the document to be deleted.
     * @returns This `Transaction` instance. Used for chaining method calls.
     */    delete(t) {
        const n = Fs(t, this.se);
        return this._s.delete(n.xn), this;
    }
}

/**
 * Executes the given `updateFunction` and then attempts to commit the changes
 * applied within the transaction. If any document read within the transaction
 * has changed, Cloud Firestore retries the `updateFunction`. If it fails to
 * commit after 5 attempts, the transaction fails.
 *
 * The maximum number of writes allowed in a single transaction is 500.
 *
 * @param firestore - A reference to the Firestore database to run this
 * transaction against.
 * @param updateFunction - The function to execute within the transaction
 * context.
 * @returns If the transaction completed successfully or was explicitly aborted
 * (the `updateFunction` returned a failed promise), the promise returned by the
 * `updateFunction `is returned here. Otherwise, if the transaction failed, a
 * rejected promise with the corresponding failure error is returned.
 */ function Ls(t, n) {
    const e = ne(t = Z(t, ee)), s = new ut;
    return new xs(new Os, e, (e => n(new Cs(t, e))), s).run(), s.promise;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ e(new r("firestore/lite", (t => ((t, n) => new ee(t, n))(t.getProvider("app-exp").getImmediate(), t.getProvider("auth-internal"))), "PUBLIC" /* PUBLIC */)), 
s("firestore-lite", "2.1.4", "node");

export { me as Bytes, he as CollectionReference, ce as DocumentReference, Ge as DocumentSnapshot, pe as FieldPath, Ee as FieldValue, ee as FirebaseFirestore, q as FirestoreError, Ie as GeoPoint, ae as Query, Ze as QueryConstraint, Ye as QueryDocumentSnapshot, He as QuerySnapshot, ft as Timestamp, Cs as Transaction, Ds as WriteBatch, Rs as addDoc, bs as arrayRemove, vs as arrayUnion, le as collection, fe as collectionGroup, Ps as deleteDoc, Vs as deleteField, de as doc, ye as documentId, fs as endAt, ls as endBefore, Es as getDoc, Is as getDocs, re as getFirestore, Ns as increment, se as initializeFirestore, is as limit, os as limitToLast, ss as orderBy, Xe as query, we as queryEqual, _e as refEqual, Ls as runTransaction, gs as serverTimestamp, Ts as setDoc, h as setLogLevel, Ke as snapshotEqual, as as startAfter, cs as startAt, oe as terminate, As as updateDoc, ie as useFirestoreEmulator, ns as where, $s as writeBatch };
//# sourceMappingURL=index.rn.esm2017.js.map
