import firebase from '@firebase/app';
import '@firebase/logger';
import '@firebase/util';
import '@firebase/webchannel-wrapper';
import { U as Uu, n as na, z, L, W as Wu, j as ju, a as zu, X as Xu, t as th, Z as Zu, b as nh, s as sh, r as rh, o as oh, K as Ku, c as Xa, d as Za, B as Bu } from './prebuilt-03753c24.js';
import { Component } from '@firebase/component';

const name = "@firebase/firestore";
const version = "2.1.4";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const firestoreNamespace = {
    Firestore: Uu,
    GeoPoint: na,
    Timestamp: z,
    Blob: L,
    Transaction: Wu,
    WriteBatch: ju,
    DocumentReference: zu,
    DocumentSnapshot: Xu,
    Query: th,
    QueryDocumentSnapshot: Zu,
    QuerySnapshot: nh,
    CollectionReference: sh,
    FieldPath: rh,
    FieldValue: oh,
    setLogLevel: Ku,
    CACHE_SIZE_UNLIMITED: Xa
};
/**
 * Configures Firestore as part of the Firebase SDK by calling registerService.
 *
 * @param firebase - The FirebaseNamespace to register Firestore with
 * @param firestoreFactory - A factory function that returns a new Firestore
 *    instance.
 */
function configureForFirebase(firebase, firestoreFactory) {
    firebase.INTERNAL.registerComponent(new Component('firestore', container => {
        const app = container.getProvider('app').getImmediate();
        return firestoreFactory(app, container.getProvider('auth-internal'));
    }, "PUBLIC" /* PUBLIC */).setServiceProps(Object.assign({}, firestoreNamespace)));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Registers the memory-only Firestore build with the components framework.
 */
function registerFirestore(instance) {
    configureForFirebase(instance, (app, auth) => new Uu(app, new Za(app, auth), new Bu()));
    instance.registerVersion(name, version);
}
registerFirestore(firebase);

export { registerFirestore };
//# sourceMappingURL=index.js.map
