import { Logger as t, LogLevel as e } from "@firebase/logger";

import { isMobileCordova as n, isReactNative as r, isElectron as i, isIE as o, isUWP as u, isBrowserExtension as s } from "@firebase/util";

import { XhrIo as a, EventType as c, ErrorCode as f, createWebChannelTransport as h, getStatEventTarget as l, WebChannel as p, Event as d, Stat as v } from "@firebase/webchannel-wrapper";

import { __awaiter as y, __generator as g, __spreadArrays as m, __extends as w } from "tslib";

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Converts a Base64 encoded string to a binary string. */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var b = new t("@firebase/firestore");

// Helper methods are needed because variables can't be exported as read/write
function _() {
    return b.logLevel;
}

/**
 * Sets the verbosity of Cloud Firestore logs (debug, error, or silent).
 *
 * @param logLevel - The verbosity you set for activity and error logging. Can
 *   be any of the following values:
 *
 *   <ul>
 *     <li>`debug` for the most verbose logging level, primarily for
 *     debugging.</li>
 *     <li>`error` to log errors only.</li>
 *     <li><code>`silent` to turn off logging.</li>
 *   </ul>
 */ function E(t) {
    for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
    if (b.logLevel <= e.DEBUG) {
        var i = n.map(N);
        b.debug.apply(b, m([ "Firestore (8.2.5): " + t ], i));
    }
}

function I(t) {
    for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
    if (b.logLevel <= e.ERROR) {
        var i = n.map(N);
        b.error.apply(b, m([ "Firestore (8.2.5): " + t ], i));
    }
}

function T(t) {
    for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
    if (b.logLevel <= e.WARN) {
        var i = n.map(N);
        b.warn.apply(b, m([ "Firestore (8.2.5): " + t ], i));
    }
}

/**
 * Converts an additional log parameter to a string representation.
 */ function N(t) {
    if ("string" == typeof t) return t;
    try {
        return e = t, JSON.stringify(e);
    } catch (e) {
        // Converting to JSON failed, just log the object directly
        return t;
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /** Formats an object as a JSON string, suitable for logging. */    var e;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Unconditionally fails, throwing an Error with the given message.
 * Messages are stripped in production builds.
 *
 * Returns `never` and can be used in expressions:
 * @example
 * let futureVar = fail('not implemented yet');
 */ function A(t) {
    void 0 === t && (t = "Unexpected state");
    // Log the failure in addition to throw an exception, just in case the
    // exception is swallowed.
        var e = "FIRESTORE (8.2.5) INTERNAL ASSERTION FAILED: " + t;
    // NOTE: We don't use FirestoreError here because these are internal failures
    // that cannot be handled by the user. (Also it would create a circular
    // dependency between the error and assert modules which doesn't work.)
        throw I(e), new Error(e)
    /**
 * Fails if the given assertion condition is false, throwing an Error with the
 * given message if it did.
 *
 * Messages are stripped in production builds.
 */;
}

function S(t, e) {
    t || A();
}

/**
 * Casts `obj` to `T`. In non-production builds, verifies that `obj` is an
 * instance of `T` before casting.
 */ function D(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
e) {
    return t;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Generates `nBytes` of random bytes.
 *
 * If `nBytes < 0` , an error will be thrown.
 */ function k(t) {
    // Polyfills for IE and WebWorker by using `self` and `msCrypto` when `crypto` is not available.
    var e = 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    "undefined" != typeof self && (self.crypto || self.msCrypto), n = new Uint8Array(t);
    if (e && "function" == typeof e.getRandomValues) e.getRandomValues(n); else 
    // Falls back to Math.random
    for (var r = 0; r < t; r++) n[r] = Math.floor(256 * Math.random());
    return n;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var O = /** @class */ function() {
    function t() {}
    return t.t = function() {
        for (
        // Alphanumeric characters
        var t = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", e = Math.floor(256 / t.length) * t.length, n = ""
        // The largest byte value that is a multiple of `char.length`.
        ; n.length < 20; ) for (var r = k(40), i = 0; i < r.length; ++i) 
        // Only accept values that are [0, maxMultiple), this ensures they can
        // be evenly mapped to indices of `chars` via a modulo operation.
        n.length < 20 && r[i] < e && (n += t.charAt(r[i] % t.length));
        return n;
    }, t;
}();

function C(t, e) {
    return t < e ? -1 : t > e ? 1 : 0;
}

/** Helper to compare arrays using isEqual(). */ function L(t, e, n) {
    return t.length === e.length && t.every((function(t, r) {
        return n(t, e[r]);
    }));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Immutable class that represents a "proto" byte string.
 *
 * Proto byte strings can either be Base64-encoded strings or Uint8Arrays when
 * sent on the wire. This class abstracts away this differentiation by holding
 * the proto byte string in a common class that must be converted into a string
 * before being sent as a proto.
 */ var V = /** @class */ function() {
    function t(t) {
        this.i = t;
    }
    return t.fromBase64String = function(e) {
        return new t(atob(e));
    }, t.fromUint8Array = function(e) {
        return new t(
        /**
 * Helper function to convert an Uint8array to a binary string.
 */
        function(t) {
            for (var e = "", n = 0; n < t.length; ++n) e += String.fromCharCode(t[n]);
            return e;
        }(e));
    }, t.prototype.toBase64 = function() {
        return t = this.i, btoa(t);
        /** Converts a binary string to a Base64 encoded string. */        var t;
        /** True if and only if the Base64 conversion functions are available. */    }, 
    t.prototype.toUint8Array = function() {
        return function(t) {
            for (var e = new Uint8Array(t.length), n = 0; n < t.length; n++) e[n] = t.charCodeAt(n);
            return e;
        }(this.i);
    }, t.prototype.o = function() {
        return 2 * this.i.length;
    }, t.prototype.u = function(t) {
        return C(this.i, t.i);
    }, t.prototype.isEqual = function(t) {
        return this.i === t.i;
    }, t;
}();

V.h = new V("");

var R = {
    // Causes are copied from:
    // https://github.com/grpc/grpc/blob/bceec94ea4fc5f0085d81235d8e1c06798dc341a/include/grpc%2B%2B/impl/codegen/status_code_enum.h
    /** Not an error; returned on success. */
    OK: "ok",
    /** The operation was cancelled (typically by the caller). */
    CANCELLED: "cancelled",
    /** Unknown error or an error from a different error domain. */
    UNKNOWN: "unknown",
    /**
     * Client specified an invalid argument. Note that this differs from
     * FAILED_PRECONDITION. INVALID_ARGUMENT indicates arguments that are
     * problematic regardless of the state of the system (e.g., a malformed file
     * name).
     */
    INVALID_ARGUMENT: "invalid-argument",
    /**
     * Deadline expired before operation could complete. For operations that
     * change the state of the system, this error may be returned even if the
     * operation has completed successfully. For example, a successful response
     * from a server could have been delayed long enough for the deadline to
     * expire.
     */
    DEADLINE_EXCEEDED: "deadline-exceeded",
    /** Some requested entity (e.g., file or directory) was not found. */
    NOT_FOUND: "not-found",
    /**
     * Some entity that we attempted to create (e.g., file or directory) already
     * exists.
     */
    ALREADY_EXISTS: "already-exists",
    /**
     * The caller does not have permission to execute the specified operation.
     * PERMISSION_DENIED must not be used for rejections caused by exhausting
     * some resource (use RESOURCE_EXHAUSTED instead for those errors).
     * PERMISSION_DENIED must not be used if the caller can not be identified
     * (use UNAUTHENTICATED instead for those errors).
     */
    PERMISSION_DENIED: "permission-denied",
    /**
     * The request does not have valid authentication credentials for the
     * operation.
     */
    UNAUTHENTICATED: "unauthenticated",
    /**
     * Some resource has been exhausted, perhaps a per-user quota, or perhaps the
     * entire file system is out of space.
     */
    RESOURCE_EXHAUSTED: "resource-exhausted",
    /**
     * Operation was rejected because the system is not in a state required for
     * the operation's execution. For example, directory to be deleted may be
     * non-empty, an rmdir operation is applied to a non-directory, etc.
     *
     * A litmus test that may help a service implementor in deciding
     * between FAILED_PRECONDITION, ABORTED, and UNAVAILABLE:
     *  (a) Use UNAVAILABLE if the client can retry just the failing call.
     *  (b) Use ABORTED if the client should retry at a higher-level
     *      (e.g., restarting a read-modify-write sequence).
     *  (c) Use FAILED_PRECONDITION if the client should not retry until
     *      the system state has been explicitly fixed. E.g., if an "rmdir"
     *      fails because the directory is non-empty, FAILED_PRECONDITION
     *      should be returned since the client should not retry unless
     *      they have first fixed up the directory by deleting files from it.
     *  (d) Use FAILED_PRECONDITION if the client performs conditional
     *      REST Get/Update/Delete on a resource and the resource on the
     *      server does not match the condition. E.g., conflicting
     *      read-modify-write on the same resource.
     */
    FAILED_PRECONDITION: "failed-precondition",
    /**
     * The operation was aborted, typically due to a concurrency issue like
     * sequencer check failures, transaction aborts, etc.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    ABORTED: "aborted",
    /**
     * Operation was attempted past the valid range. E.g., seeking or reading
     * past end of file.
     *
     * Unlike INVALID_ARGUMENT, this error indicates a problem that may be fixed
     * if the system state changes. For example, a 32-bit file system will
     * generate INVALID_ARGUMENT if asked to read at an offset that is not in the
     * range [0,2^32-1], but it will generate OUT_OF_RANGE if asked to read from
     * an offset past the current file size.
     *
     * There is a fair bit of overlap between FAILED_PRECONDITION and
     * OUT_OF_RANGE. We recommend using OUT_OF_RANGE (the more specific error)
     * when it applies so that callers who are iterating through a space can
     * easily look for an OUT_OF_RANGE error to detect when they are done.
     */
    OUT_OF_RANGE: "out-of-range",
    /** Operation is not implemented or not supported/enabled in this service. */
    UNIMPLEMENTED: "unimplemented",
    /**
     * Internal errors. Means some invariants expected by underlying System has
     * been broken. If you see one of these errors, Something is very broken.
     */
    INTERNAL: "internal",
    /**
     * The service is currently unavailable. This is a most likely a transient
     * condition and may be corrected by retrying with a backoff.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    UNAVAILABLE: "unavailable",
    /** Unrecoverable data loss or corruption. */
    DATA_LOSS: "data-loss"
}, P = /** @class */ function(t) {
    /** @hideconstructor */
    function e(e, n) {
        var r = this;
        return (r = t.call(this, n) || this).code = e, r.message = n, r.name = "FirebaseError", 
        // HACK: We write a toString property directly because Error is not a real
        // class and so inheritance does not work correctly. We could alternatively
        // do the same "back-door inheritance" trick that FirebaseError does.
        r.toString = function() {
            return r.name + ": [code=" + r.code + "]: " + r.message;
        }, r;
    }
    return w(e, t), e;
}(Error), U = /** @class */ function() {
    /** @hideconstructor */
    function t(t) {
        this.l = t;
    }
    /**
     * Creates a new `Bytes` object from the given Base64 string, converting it to
     * bytes.
     *
     * @param base64 - The Base64 string used to create the `Bytes` object.
     */    return t.fromBase64String = function(e) {
        try {
            return new t(V.fromBase64String(e));
        } catch (e) {
            throw new P(R.INVALID_ARGUMENT, "Failed to construct data from Base64 string: " + e);
        }
    }, 
    /**
     * Creates a new `Bytes` object from the given Uint8Array.
     *
     * @param array - The Uint8Array used to create the `Bytes` object.
     */
    t.fromUint8Array = function(e) {
        return new t(V.fromUint8Array(e));
    }, 
    /**
     * Returns the underlying bytes as a Base64-encoded string.
     *
     * @returns The Base64-encoded string created from the `Bytes` object.
     */
    t.prototype.toBase64 = function() {
        return this.l.toBase64();
    }, 
    /**
     * Returns the underlying bytes in a new `Uint8Array`.
     *
     * @returns The Uint8Array created from the `Bytes` object.
     */
    t.prototype.toUint8Array = function() {
        return this.l.toUint8Array();
    }, 
    /**
     * Returns a string representation of the `Bytes` object.
     *
     * @returns A string representation of the `Bytes` object.
     */
    t.prototype.toString = function() {
        return "Bytes(base64: " + this.toBase64() + ")";
    }, 
    /**
     * Returns true if this `Bytes` object is equal to the provided one.
     *
     * @param other - The `Bytes` object to compare against.
     * @returns true if this `Bytes` object is equal to the provided one.
     */
    t.prototype.isEqual = function(t) {
        return this.l.isEqual(t.l);
    }, t;
}(), x = function(t) {
    this._ = t;
};

/** An error returned by a Firestore operation. */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Helper function to assert Uint8Array is available at runtime. */ function q() {
    if ("undefined" == typeof Uint8Array) throw new P(R.UNIMPLEMENTED, "Uint8Arrays are not available in this environment.");
}

/** Helper function to assert Base64 functions are available at runtime. */ function M() {
    if ("undefined" == typeof atob) throw new P(R.UNIMPLEMENTED, "Blobs are unavailable in Firestore in this environment.");
}

/** Immutable class holding a blob (binary data) */ var F = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e.fromBase64String = function(t) {
        return M(), new e(U.fromBase64String(t));
    }, e.fromUint8Array = function(t) {
        return q(), new e(U.fromUint8Array(t));
    }, e.prototype.toBase64 = function() {
        return M(), this._.toBase64();
    }, e.prototype.toUint8Array = function() {
        return q(), this._.toUint8Array();
    }, e.prototype.isEqual = function(t) {
        return this._.isEqual(t._);
    }, e.prototype.toString = function() {
        return "Blob(base64: " + this.toBase64() + ")";
    }, e;
}(x), j = 
/**
     * Constructs a DatabaseInfo using the provided host, databaseId and
     * persistenceKey.
     *
     * @param databaseId - The database to use.
     * @param persistenceKey - A unique identifier for this Firestore's local
     * storage (used in conjunction with the databaseId).
     * @param host - The Firestore backend host to connect to.
     * @param ssl - Whether to use SSL when connecting.
     * @param forceLongPolling - Whether to use the forceLongPolling option
     * when using WebChannel as the network transport.
     * @param autoDetectLongPolling - Whether to use the detectBufferingProxy
     * option when using WebChannel as the network transport.
     */
function(t, e, n, r, i, o) {
    this.T = t, this.persistenceKey = e, this.host = n, this.ssl = r, this.forceLongPolling = i, 
    this.I = o;
}, z = /** @class */ function() {
    function t(t, e) {
        this.projectId = t, this.database = e || "(default)";
    }
    return Object.defineProperty(t.prototype, "m", {
        get: function() {
            return "(default)" === this.database;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        return e instanceof t && e.projectId === this.projectId && e.database === this.database;
    }, t;
}(), G = /** @class */ function() {
    function t(t) {
        this.uid = t;
    }
    return t.prototype.A = function() {
        return null != this.uid;
    }, 
    /**
     * Returns a key representing this user, suitable for inclusion in a
     * dictionary.
     */
    t.prototype.R = function() {
        return this.A() ? "uid:" + this.uid : "anonymous-user";
    }, t.prototype.isEqual = function(t) {
        return t.uid === this.uid;
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** A user with a null UID. */ G.UNAUTHENTICATED = new G(null), 
// TODO(mikelehen): Look into getting a proper uid-equivalent for
// non-FirebaseAuth providers.
G.P = new G("google-credentials-uid"), G.g = new G("first-party-uid");

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var H = function(t, e) {
    this.user = e, this.type = "OAuth", this.V = {}, 
    // Set the headers using Object Literal notation to avoid minification
    this.V.Authorization = "Bearer " + t;
}, B = /** @class */ function() {
    function t() {
        /**
         * Stores the listener registered with setChangeListener()
         * This isn't actually necessary since the UID never changes, but we use this
         * to verify the listen contract is adhered to in tests.
         */
        this.p = null;
    }
    return t.prototype.getToken = function() {
        return Promise.resolve(null);
    }, t.prototype.v = function() {}, t.prototype.S = function(t) {
        this.p = t, 
        // Fire with initial user.
        t(G.UNAUTHENTICATED);
    }, t.prototype.D = function() {
        this.p = null;
    }, t;
}(), K = /** @class */ function() {
    function t(t) {
        var e = this;
        /**
         * The auth token listener registered with FirebaseApp, retained here so we
         * can unregister it.
         */        this.C = null, 
        /** Tracks the current User. */
        this.currentUser = G.UNAUTHENTICATED, this.N = !1, 
        /**
             * Counter used to detect if the token changed while a getToken request was
             * outstanding.
             */
        this.F = 0, 
        /** The listener registered with setChangeListener(). */
        this.p = null, this.forceRefresh = !1, this.C = function() {
            e.F++, e.currentUser = e.O(), e.N = !0, e.p && e.p(e.currentUser);
        }, this.F = 0, this.auth = t.getImmediate({
            optional: !0
        }), this.auth ? this.auth.addAuthTokenListener(this.C) : (
        // if auth is not available, invoke tokenListener once with null token
        this.C(null), t.get().then((function(t) {
            e.auth = t, e.C && 
            // tokenListener can be removed by removeChangeListener()
            e.auth.addAuthTokenListener(e.C);
        }), (function() {})));
    }
    return t.prototype.getToken = function() {
        var t = this, e = this.F, n = this.forceRefresh;
        // Take note of the current value of the tokenCounter so that this method
        // can fail (with an ABORTED error) if there is a token change while the
        // request is outstanding.
                return this.forceRefresh = !1, this.auth ? this.auth.getToken(n).then((function(n) {
            // Cancel the request since the token changed while the request was
            // outstanding so the response is potentially for a previous user (which
            // user, we can't be sure).
            return t.F !== e ? (E("FirebaseCredentialsProvider", "getToken aborted due to token change."), 
            t.getToken()) : n ? (S("string" == typeof n.accessToken), new H(n.accessToken, t.currentUser)) : null;
        })) : Promise.resolve(null);
    }, t.prototype.v = function() {
        this.forceRefresh = !0;
    }, t.prototype.S = function(t) {
        this.p = t, 
        // Fire the initial event
        this.N && t(this.currentUser);
    }, t.prototype.D = function() {
        this.auth && this.auth.removeAuthTokenListener(this.C), this.C = null, this.p = null;
    }, 
    // Auth.getUid() can return null even with a user logged in. It is because
    // getUid() is synchronous, but the auth code populating Uid is asynchronous.
    // This method should only be called in the AuthTokenListener callback
    // to guarantee to get the actual user.
    t.prototype.O = function() {
        var t = this.auth && this.auth.getUid();
        return S(null === t || "string" == typeof t), new G(t);
    }, t;
}(), J = /** @class */ function() {
    function t(t, e) {
        this.k = t, this.M = e, this.type = "FirstParty", this.user = G.g;
    }
    return Object.defineProperty(t.prototype, "V", {
        get: function() {
            var t = {
                "X-Goog-AuthUser": this.M
            }, e = this.k.auth.getAuthHeaderValueForFirstParty([]);
            // Use array notation to prevent minification
                        return e && (t.Authorization = e), t;
        },
        enumerable: !1,
        configurable: !0
    }), t;
}(), W = /** @class */ function() {
    function t(t, e) {
        this.k = t, this.M = e;
    }
    return t.prototype.getToken = function() {
        return Promise.resolve(new J(this.k, this.M));
    }, t.prototype.S = function(t) {
        // Fire with initial uid.
        t(G.g);
    }, t.prototype.D = function() {}, t.prototype.v = function() {}, t;
}(), Q = /** @class */ function() {
    function t(t, e) {
        var n = this;
        this.previousValue = t, e && (e.L = function(t) {
            return n.$(t);
        }, this.B = function(t) {
            return e.q(t);
        });
    }
    return t.prototype.$ = function(t) {
        return this.previousValue = Math.max(t, this.previousValue), this.previousValue;
    }, t.prototype.next = function() {
        var t = ++this.previousValue;
        return this.B && this.B(t), t;
    }, t;
}();

/** A CredentialsProvider that always yields an empty token. */ Q.U = -1;

/**
 * A `Timestamp` represents a point in time independent of any time zone or
 * calendar, represented as seconds and fractions of seconds at nanosecond
 * resolution in UTC Epoch time.
 *
 * It is encoded using the Proleptic Gregorian Calendar which extends the
 * Gregorian calendar backwards to year one. It is encoded assuming all minutes
 * are 60 seconds long, i.e. leap seconds are "smeared" so that no leap second
 * table is needed for interpretation. Range is from 0001-01-01T00:00:00Z to
 * 9999-12-31T23:59:59.999999999Z.
 *
 * @see https://github.com/google/protobuf/blob/master/src/google/protobuf/timestamp.proto
 */
var Y = /** @class */ function() {
    /**
     * Creates a new timestamp.
     *
     * @param seconds - The number of seconds of UTC time since Unix epoch
     *     1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     *     9999-12-31T23:59:59Z inclusive.
     * @param nanoseconds - The non-negative fractions of a second at nanosecond
     *     resolution. Negative second values with fractions must still have
     *     non-negative nanoseconds values that count forward in time. Must be
     *     from 0 to 999,999,999 inclusive.
     */
    function t(t, e) {
        if (this.seconds = t, this.nanoseconds = e, e < 0) throw new P(R.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (e >= 1e9) throw new P(R.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (t < -62135596800) throw new P(R.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
        // This will break in the year 10,000.
                if (t >= 253402300800) throw new P(R.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
    }
    /**
     * Creates a new timestamp with the current date, with millisecond precision.
     *
     * @returns a new timestamp representing the current date.
     */    return t.now = function() {
        return t.fromMillis(Date.now());
    }, 
    /**
     * Creates a new timestamp from the given date.
     *
     * @param date - The date to initialize the `Timestamp` from.
     * @returns A new `Timestamp` representing the same point in time as the given
     *     date.
     */
    t.fromDate = function(e) {
        return t.fromMillis(e.getTime());
    }, 
    /**
     * Creates a new timestamp from the given number of milliseconds.
     *
     * @param milliseconds - Number of milliseconds since Unix epoch
     *     1970-01-01T00:00:00Z.
     * @returns A new `Timestamp` representing the same point in time as the given
     *     number of milliseconds.
     */
    t.fromMillis = function(e) {
        var n = Math.floor(e / 1e3);
        return new t(n, 1e6 * (e - 1e3 * n));
    }, 
    /**
     * Converts a `Timestamp` to a JavaScript `Date` object. This conversion causes
     * a loss of precision since `Date` objects only support millisecond precision.
     *
     * @returns JavaScript `Date` object representing the same point in time as
     *     this `Timestamp`, with millisecond precision.
     */
    t.prototype.toDate = function() {
        return new Date(this.toMillis());
    }, 
    /**
     * Converts a `Timestamp` to a numeric timestamp (in milliseconds since
     * epoch). This operation causes a loss of precision.
     *
     * @returns The point in time corresponding to this timestamp, represented as
     *     the number of milliseconds since Unix epoch 1970-01-01T00:00:00Z.
     */
    t.prototype.toMillis = function() {
        return 1e3 * this.seconds + this.nanoseconds / 1e6;
    }, t.prototype.K = function(t) {
        return this.seconds === t.seconds ? C(this.nanoseconds, t.nanoseconds) : C(this.seconds, t.seconds);
    }, 
    /**
     * Returns true if this `Timestamp` is equal to the provided one.
     *
     * @param other - The `Timestamp` to compare against.
     * @returns true if this `Timestamp` is equal to the provided one.
     */
    t.prototype.isEqual = function(t) {
        return t.seconds === this.seconds && t.nanoseconds === this.nanoseconds;
    }, t.prototype.toString = function() {
        return "Timestamp(seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + ")";
    }, t.prototype.toJSON = function() {
        return {
            seconds: this.seconds,
            nanoseconds: this.nanoseconds
        };
    }, 
    /**
     * Converts this object to a primitive string, which allows Timestamp objects to be compared
     * using the `>`, `<=`, `>=` and `>` operators.
     */
    t.prototype.valueOf = function() {
        // This method returns a string of the form <seconds>.<nanoseconds> where <seconds> is
        // translated to have a non-negative value and both <seconds> and <nanoseconds> are left-padded
        // with zeroes to be a consistent length. Strings with this format then have a lexiographical
        // ordering that matches the expected ordering. The <seconds> translation is done to avoid
        // having a leading negative sign (i.e. a leading '-' character) in its string representation,
        // which would affect its lexiographical ordering.
        var t = this.seconds - -62135596800;
        // Note: Up to 12 decimal digits are required to represent all valid 'seconds' values.
                return String(t).padStart(12, "0") + "." + String(this.nanoseconds).padStart(9, "0");
    }, t;
}(), X = /** @class */ function() {
    function t(t) {
        this.timestamp = t;
    }
    return t.W = function(e) {
        return new t(e);
    }, t.min = function() {
        return new t(new Y(0, 0));
    }, t.prototype.u = function(t) {
        return this.timestamp.K(t.timestamp);
    }, t.prototype.isEqual = function(t) {
        return this.timestamp.isEqual(t.timestamp);
    }, 
    /** Returns a number representation of the version for use in spec tests. */ t.prototype.j = function() {
        // Convert to microseconds.
        return 1e6 * this.timestamp.seconds + this.timestamp.nanoseconds / 1e3;
    }, t.prototype.toString = function() {
        return "SnapshotVersion(" + this.timestamp.toString() + ")";
    }, t.prototype.G = function() {
        return this.timestamp;
    }, t;
}(), Z = /** @class */ function() {
    function t(t, e, n) {
        void 0 === e ? e = 0 : e > t.length && A(), void 0 === n ? n = t.length - e : n > t.length - e && A(), 
        this.segments = t, this.offset = e, this.H = n;
    }
    return Object.defineProperty(t.prototype, "length", {
        get: function() {
            return this.H;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        return 0 === t.J(this, e);
    }, t.prototype.child = function(e) {
        var n = this.segments.slice(this.offset, this.limit());
        return e instanceof t ? e.forEach((function(t) {
            n.push(t);
        })) : n.push(e), this.Y(n);
    }, 
    /** The index of one past the last segment of the path. */ t.prototype.limit = function() {
        return this.offset + this.length;
    }, t.prototype.X = function(t) {
        return t = void 0 === t ? 1 : t, this.Y(this.segments, this.offset + t, this.length - t);
    }, t.prototype.Z = function() {
        return this.Y(this.segments, this.offset, this.length - 1);
    }, t.prototype.tt = function() {
        return this.segments[this.offset];
    }, t.prototype.et = function() {
        return this.get(this.length - 1);
    }, t.prototype.get = function(t) {
        return this.segments[this.offset + t];
    }, t.prototype.nt = function() {
        return 0 === this.length;
    }, t.prototype.st = function(t) {
        if (t.length < this.length) return !1;
        for (var e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }, t.prototype.it = function(t) {
        if (this.length + 1 !== t.length) return !1;
        for (var e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }, t.prototype.forEach = function(t) {
        for (var e = this.offset, n = this.limit(); e < n; e++) t(this.segments[e]);
    }, t.prototype.rt = function() {
        return this.segments.slice(this.offset, this.limit());
    }, t.J = function(t, e) {
        for (var n = Math.min(t.length, e.length), r = 0; r < n; r++) {
            var i = t.get(r), o = e.get(r);
            if (i < o) return -1;
            if (i > o) return 1;
        }
        return t.length < e.length ? -1 : t.length > e.length ? 1 : 0;
    }, t;
}(), $ = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e.prototype.Y = function(t, n, r) {
        return new e(t, n, r);
    }, e.prototype.ot = function() {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        return this.rt().join("/");
    }, e.prototype.toString = function() {
        return this.ot();
    }, 
    /**
     * Creates a resource path from the given slash-delimited string. If multiple
     * arguments are provided, all components are combined. Leading and trailing
     * slashes from all components are ignored.
     */
    e.ct = function() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
                for (var r = [], i = 0, o = t; i < o.length; i++) {
            var u = o[i];
            if (u.indexOf("//") >= 0) throw new P(R.INVALID_ARGUMENT, "Invalid segment (" + u + "). Paths must not contain // in them.");
            // Strip leading and traling slashed.
                        r.push.apply(r, u.split("/").filter((function(t) {
                return t.length > 0;
            })));
        }
        return new e(r);
    }, e.at = function() {
        return new e([]);
    }, e;
}(Z), tt = /^[_a-zA-Z][_a-zA-Z0-9]*$/, et = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e.prototype.Y = function(t, n, r) {
        return new e(t, n, r);
    }, 
    /**
     * Returns true if the string could be used as a segment in a field path
     * without escaping.
     */
    e.ut = function(t) {
        return tt.test(t);
    }, e.prototype.ot = function() {
        return this.rt().map((function(t) {
            return t = t.replace(/\\/g, "\\\\").replace(/`/g, "\\`"), e.ut(t) || (t = "`" + t + "`"), 
            t;
        })).join(".");
    }, e.prototype.toString = function() {
        return this.ot();
    }, 
    /**
     * Returns true if this field references the key of a document.
     */
    e.prototype.ht = function() {
        return 1 === this.length && "__name__" === this.get(0);
    }, 
    /**
     * The field designating the key of a document.
     */
    e.lt = function() {
        return new e([ "__name__" ]);
    }, 
    /**
     * Parses a field string from the given server-formatted string.
     *
     * - Splitting the empty string is not allowed (for now at least).
     * - Empty segments within the string (e.g. if there are two consecutive
     *   separators) are not allowed.
     *
     * TODO(b/37244157): we should make this more strict. Right now, it allows
     * non-identifier path components, even if they aren't escaped.
     */
    e._t = function(t) {
        for (var n = [], r = "", i = 0, o = function() {
            if (0 === r.length) throw new P(R.INVALID_ARGUMENT, "Invalid field path (" + t + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
            n.push(r), r = "";
        }, u = !1; i < t.length; ) {
            var s = t[i];
            if ("\\" === s) {
                if (i + 1 === t.length) throw new P(R.INVALID_ARGUMENT, "Path has trailing escape character: " + t);
                var a = t[i + 1];
                if ("\\" !== a && "." !== a && "`" !== a) throw new P(R.INVALID_ARGUMENT, "Path has invalid escape sequence: " + t);
                r += a, i += 2;
            } else "`" === s ? (u = !u, i++) : "." !== s || u ? (r += s, i++) : (o(), i++);
        }
        if (o(), u) throw new P(R.INVALID_ARGUMENT, "Unterminated ` in path: " + t);
        return new e(n);
    }, e.at = function() {
        return new e([]);
    }, e;
}(Z), nt = /** @class */ function() {
    function t(t) {
        this.path = t;
    }
    return t.ft = function(e) {
        return new t($.ct(e));
    }, t.dt = function(e) {
        return new t($.ct(e).X(5));
    }, 
    /** Returns true if the document is in the specified collectionId. */ t.prototype.wt = function(t) {
        return this.path.length >= 2 && this.path.get(this.path.length - 2) === t;
    }, t.prototype.isEqual = function(t) {
        return null !== t && 0 === $.J(this.path, t.path);
    }, t.prototype.toString = function() {
        return this.path.toString();
    }, t.J = function(t, e) {
        return $.J(t.path, e.path);
    }, t.Et = function(t) {
        return t.length % 2 == 0;
    }, 
    /**
     * Creates and returns a new document key with the given segments.
     *
     * @param segments - The segments of the path to the document
     * @returns A new instance of DocumentKey
     */
    t.Tt = function(e) {
        return new t(new $(e.slice()));
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A version of a document in Firestore. This corresponds to the version
 * timestamp, such as update_time or read_time.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function rt(t) {
    var e = 0;
    for (var n in t) Object.prototype.hasOwnProperty.call(t, n) && e++;
    return e;
}

function it(t, e) {
    for (var n in t) Object.prototype.hasOwnProperty.call(t, n) && e(n, t[n]);
}

function ot(t) {
    for (var e in t) if (Object.prototype.hasOwnProperty.call(t, e)) return !1;
    return !0;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides a set of fields that can be used to partially patch a document.
 * FieldMask is used in conjunction with ObjectValue.
 * Examples:
 *   foo - Overwrites foo entirely with the provided value. If foo is not
 *         present in the companion ObjectValue, the field is deleted.
 *   foo.bar - Overwrites only the field bar of the object foo.
 *             If foo is not an object, foo is replaced with an object
 *             containing foo
 */ var ut = /** @class */ function() {
    function t(t) {
        this.fields = t, 
        // TODO(dimond): validation of FieldMask
        // Sort the field mask to support `FieldMask.isEqual()` and assert below.
        t.sort(et.J)
        /**
     * Verifies that `fieldPath` is included by at least one field in this field
     * mask.
     *
     * This is an O(n) operation, where `n` is the size of the field mask.
     */;
    }
    return t.prototype.It = function(t) {
        for (var e = 0, n = this.fields; e < n.length; e++) {
            if (n[e].st(t)) return !0;
        }
        return !1;
    }, t.prototype.isEqual = function(t) {
        return L(this.fields, t.fields, (function(t, e) {
            return t.isEqual(e);
        }));
    }, t;
}(), st = new RegExp(/^\d{4}-\d\d-\d\dT\d\d:\d\d:\d\d(?:\.(\d+))?Z$/);

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// A RegExp matching ISO 8601 UTC timestamps with optional fraction.
/**
 * Converts the possible Proto values for a timestamp value into a "seconds and
 * nanos" representation.
 */
function at(t) {
    // The json interface (for the browser) will return an iso timestamp string,
    // while the proto js library (for node) will return a
    // google.protobuf.Timestamp instance.
    if (S(!!t), "string" == typeof t) {
        // The date string can have higher precision (nanos) than the Date class
        // (millis), so we do some custom parsing here.
        // Parse the nanos right out of the string.
        var e = 0, n = st.exec(t);
        if (S(!!n), n[1]) {
            // Pad the fraction out to 9 digits (nanos).
            var r = n[1];
            r = (r + "000000000").substr(0, 9), e = Number(r);
        }
        // Parse the date to get the seconds.
                var i = new Date(t);
        return {
            seconds: Math.floor(i.getTime() / 1e3),
            nanos: e
        };
    }
    return {
        seconds: ct(t.seconds),
        nanos: ct(t.nanos)
    };
}

/**
 * Converts the possible Proto types for numbers into a JavaScript number.
 * Returns 0 if the value is not numeric.
 */ function ct(t) {
    // TODO(bjornick): Handle int64 greater than 53 bits.
    return "number" == typeof t ? t : "string" == typeof t ? Number(t) : 0;
}

/** Converts the possible Proto types for Blobs into a ByteString. */ function ft(t) {
    return "string" == typeof t ? V.fromBase64String(t) : V.fromUint8Array(t);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents a locally-applied ServerTimestamp.
 *
 * Server Timestamps are backed by MapValues that contain an internal field
 * `__type__` with a value of `server_timestamp`. The previous value and local
 * write time are stored in its `__previous_value__` and `__local_write_time__`
 * fields respectively.
 *
 * Notes:
 * - ServerTimestampValue instances are created as the result of applying a
 *   transform. They can only exist in the local view of a document. Therefore
 *   they do not need to be parsed or serialized.
 * - When evaluated locally (e.g. for snapshot.data()), they by default
 *   evaluate to `null`. This behavior can be configured by passing custom
 *   FieldValueOptions to value().
 * - With respect to other ServerTimestampValues, they sort by their
 *   localWriteTime.
 */ function ht(t) {
    var e, n;
    return "server_timestamp" === (null === (n = ((null === (e = null == t ? void 0 : t.mapValue) || void 0 === e ? void 0 : e.fields) || {}).__type__) || void 0 === n ? void 0 : n.stringValue);
}

/**
 * Creates a new ServerTimestamp proto value (using the internal format).
 */
/**
 * Returns the value of the field before this ServerTimestamp was set.
 *
 * Preserving the previous values allows the user to display the last resoled
 * value until the backend responds with the timestamp.
 */ function lt(t) {
    var e = t.mapValue.fields.__previous_value__;
    return ht(e) ? lt(e) : e;
}

/**
 * Returns the local time at which this timestamp was first set.
 */ function pt(t) {
    var e = at(t.mapValue.fields.__local_write_time__.timestampValue);
    return new Y(e.seconds, e.nanos);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Sentinel value that sorts before any Mutation Batch ID. */
/**
 * Returns whether a variable is either undefined or null.
 */ function dt(t) {
    return null == t;
}

/** Returns whether the value represents -0. */ function vt(t) {
    // Detect if the value is -0.0. Based on polyfill from
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
    return 0 === t && 1 / t == -1 / 0;
}

/**
 * Returns whether a value is an integer and in the safe integer range
 * @param value - The value to test for being an integer and in the safe range
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Extracts the backend's type order for the provided value. */ function yt(t) {
    return "nullValue" in t ? 0 /* NullValue */ : "booleanValue" in t ? 1 /* BooleanValue */ : "integerValue" in t || "doubleValue" in t ? 2 /* NumberValue */ : "timestampValue" in t ? 3 /* TimestampValue */ : "stringValue" in t ? 5 /* StringValue */ : "bytesValue" in t ? 6 /* BlobValue */ : "referenceValue" in t ? 7 /* RefValue */ : "geoPointValue" in t ? 8 /* GeoPointValue */ : "arrayValue" in t ? 9 /* ArrayValue */ : "mapValue" in t ? ht(t) ? 4 /* ServerTimestampValue */ : 10 /* ObjectValue */ : A();
}

/** Tests `left` and `right` for equality based on the backend semantics. */ function gt(t, e) {
    var n = yt(t);
    if (n !== yt(e)) return !1;
    switch (n) {
      case 0 /* NullValue */ :
        return !0;

      case 1 /* BooleanValue */ :
        return t.booleanValue === e.booleanValue;

      case 4 /* ServerTimestampValue */ :
        return pt(t).isEqual(pt(e));

      case 3 /* TimestampValue */ :
        return function(t, e) {
            if ("string" == typeof t.timestampValue && "string" == typeof e.timestampValue && t.timestampValue.length === e.timestampValue.length) 
            // Use string equality for ISO 8601 timestamps
            return t.timestampValue === e.timestampValue;
            var n = at(t.timestampValue), r = at(e.timestampValue);
            return n.seconds === r.seconds && n.nanos === r.nanos;
        }(t, e);

      case 5 /* StringValue */ :
        return t.stringValue === e.stringValue;

      case 6 /* BlobValue */ :
        return function(t, e) {
            return ft(t.bytesValue).isEqual(ft(e.bytesValue));
        }(t, e);

      case 7 /* RefValue */ :
        return t.referenceValue === e.referenceValue;

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            return ct(t.geoPointValue.latitude) === ct(e.geoPointValue.latitude) && ct(t.geoPointValue.longitude) === ct(e.geoPointValue.longitude);
        }(t, e);

      case 2 /* NumberValue */ :
        return function(t, e) {
            if ("integerValue" in t && "integerValue" in e) return ct(t.integerValue) === ct(e.integerValue);
            if ("doubleValue" in t && "doubleValue" in e) {
                var n = ct(t.doubleValue), r = ct(e.doubleValue);
                return n === r ? vt(n) === vt(r) : isNaN(n) && isNaN(r);
            }
            return !1;
        }(t, e);

      case 9 /* ArrayValue */ :
        return L(t.arrayValue.values || [], e.arrayValue.values || [], gt);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            var n = t.mapValue.fields || {}, r = e.mapValue.fields || {};
            if (rt(n) !== rt(r)) return !1;
            for (var i in n) if (n.hasOwnProperty(i) && (void 0 === r[i] || !gt(n[i], r[i]))) return !1;
            return !0;
        }(t, e);

      default:
        return A();
    }
}

function mt(t, e) {
    return void 0 !== (t.values || []).find((function(t) {
        return gt(t, e);
    }));
}

function wt(t, e) {
    var n = yt(t), r = yt(e);
    if (n !== r) return C(n, r);
    switch (n) {
      case 0 /* NullValue */ :
        return 0;

      case 1 /* BooleanValue */ :
        return C(t.booleanValue, e.booleanValue);

      case 2 /* NumberValue */ :
        return function(t, e) {
            var n = ct(t.integerValue || t.doubleValue), r = ct(e.integerValue || e.doubleValue);
            return n < r ? -1 : n > r ? 1 : n === r ? 0 : 
            // one or both are NaN.
            isNaN(n) ? isNaN(r) ? 0 : -1 : 1;
        }(t, e);

      case 3 /* TimestampValue */ :
        return bt(t.timestampValue, e.timestampValue);

      case 4 /* ServerTimestampValue */ :
        return bt(pt(t), pt(e));

      case 5 /* StringValue */ :
        return C(t.stringValue, e.stringValue);

      case 6 /* BlobValue */ :
        return function(t, e) {
            var n = ft(t), r = ft(e);
            return n.u(r);
        }(t.bytesValue, e.bytesValue);

      case 7 /* RefValue */ :
        return function(t, e) {
            for (var n = t.split("/"), r = e.split("/"), i = 0; i < n.length && i < r.length; i++) {
                var o = C(n[i], r[i]);
                if (0 !== o) return o;
            }
            return C(n.length, r.length);
        }(t.referenceValue, e.referenceValue);

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            var n = C(ct(t.latitude), ct(e.latitude));
            return 0 !== n ? n : C(ct(t.longitude), ct(e.longitude));
        }(t.geoPointValue, e.geoPointValue);

      case 9 /* ArrayValue */ :
        return function(t, e) {
            for (var n = t.values || [], r = e.values || [], i = 0; i < n.length && i < r.length; ++i) {
                var o = wt(n[i], r[i]);
                if (o) return o;
            }
            return C(n.length, r.length);
        }(t.arrayValue, e.arrayValue);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            var n = t.fields || {}, r = Object.keys(n), i = e.fields || {}, o = Object.keys(i);
            // Even though MapValues are likely sorted correctly based on their insertion
            // order (e.g. when received from the backend), local modifications can bring
            // elements out of order. We need to re-sort the elements to ensure that
            // canonical IDs are independent of insertion order.
                        r.sort(), o.sort();
            for (var u = 0; u < r.length && u < o.length; ++u) {
                var s = C(r[u], o[u]);
                if (0 !== s) return s;
                var a = wt(n[r[u]], i[o[u]]);
                if (0 !== a) return a;
            }
            return C(r.length, o.length);
        }(t.mapValue, e.mapValue);

      default:
        throw A();
    }
}

function bt(t, e) {
    if ("string" == typeof t && "string" == typeof e && t.length === e.length) return C(t, e);
    var n = at(t), r = at(e), i = C(n.seconds, r.seconds);
    return 0 !== i ? i : C(n.nanos, r.nanos);
}

function _t(t) {
    return Et(t);
}

function Et(t) {
    return "nullValue" in t ? "null" : "booleanValue" in t ? "" + t.booleanValue : "integerValue" in t ? "" + t.integerValue : "doubleValue" in t ? "" + t.doubleValue : "timestampValue" in t ? function(t) {
        var e = at(t);
        return "time(" + e.seconds + "," + e.nanos + ")";
    }(t.timestampValue) : "stringValue" in t ? t.stringValue : "bytesValue" in t ? ft(t.bytesValue).toBase64() : "referenceValue" in t ? (n = t.referenceValue, 
    nt.dt(n).toString()) : "geoPointValue" in t ? "geo(" + (e = t.geoPointValue).latitude + "," + e.longitude + ")" : "arrayValue" in t ? function(t) {
        for (var e = "[", n = !0, r = 0, i = t.values || []; r < i.length; r++) {
            n ? n = !1 : e += ",", e += Et(i[r]);
        }
        return e + "]";
    }(t.arrayValue) : "mapValue" in t ? function(t) {
        for (
        // Iteration order in JavaScript is not guaranteed. To ensure that we generate
        // matching canonical IDs for identical maps, we need to sort the keys.
        var e = "{", n = !0, r = 0, i = Object.keys(t.fields || {}).sort(); r < i.length; r++) {
            var o = i[r];
            n ? n = !1 : e += ",", e += o + ":" + Et(t.fields[o]);
        }
        return e + "}";
    }(t.mapValue) : A();
    var e, n;
}

function It(t, e) {
    return {
        referenceValue: "projects/" + t.projectId + "/databases/" + t.database + "/documents/" + e.path.ot()
    };
}

/** Returns true if `value` is an IntegerValue . */ function Tt(t) {
    return !!t && "integerValue" in t;
}

/** Returns true if `value` is a DoubleValue. */
/** Returns true if `value` is an ArrayValue. */ function Nt(t) {
    return !!t && "arrayValue" in t;
}

/** Returns true if `value` is a NullValue. */ function At(t) {
    return !!t && "nullValue" in t;
}

/** Returns true if `value` is NaN. */ function St(t) {
    return !!t && "doubleValue" in t && isNaN(Number(t.doubleValue));
}

/** Returns true if `value` is a MapValue. */ function Dt(t) {
    return !!t && "mapValue" in t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An ObjectValue represents a MapValue in the Firestore Proto and offers the
 * ability to add and remove fields (via the ObjectValueBuilder).
 */ var kt = /** @class */ function() {
    function t(t) {
        this.proto = t;
    }
    return t.empty = function() {
        return new t({
            mapValue: {}
        });
    }, 
    /**
     * Returns the value at the given path or null.
     *
     * @param path - the path to search
     * @returns The value at the path or if there it doesn't exist.
     */
    t.prototype.field = function(t) {
        if (t.nt()) return this.proto;
        for (var e = this.proto, n = 0; n < t.length - 1; ++n) {
            if (!e.mapValue.fields) return null;
            if (!Dt(e = e.mapValue.fields[t.get(n)])) return null;
        }
        return (e = (e.mapValue.fields || {})[t.et()]) || null;
    }, t.prototype.isEqual = function(t) {
        return gt(this.proto, t.proto);
    }, t;
}(), Ot = /** @class */ function() {
    /**
     * @param baseObject - The object to mutate.
     */
    function t(t) {
        void 0 === t && (t = kt.empty()), this.At = t, 
        /** A map that contains the accumulated changes in this builder. */
        this.Rt = new Map;
    }
    /**
     * Sets the field to the provided value.
     *
     * @param path - The field path to set.
     * @param value - The value to set.
     * @returns The current Builder instance.
     */    return t.prototype.set = function(t, e) {
        return this.Pt(t, e), this;
    }, 
    /**
     * Removes the field at the specified path. If there is no field at the
     * specified path, nothing is changed.
     *
     * @param path - The field path to remove.
     * @returns The current Builder instance.
     */
    t.prototype.delete = function(t) {
        return this.Pt(t, null), this;
    }, 
    /**
     * Adds `value` to the overlay map at `path`. Creates nested map entries if
     * needed.
     */
    t.prototype.Pt = function(t, e) {
        for (var n = this.Rt, r = 0; r < t.length - 1; ++r) {
            var i = t.get(r), o = n.get(i);
            o instanceof Map ? 
            // Re-use a previously created map
            n = o : o && 10 /* ObjectValue */ === yt(o) ? (
            // Convert the existing Protobuf MapValue into a map
            o = new Map(Object.entries(o.mapValue.fields || {})), n.set(i, o), n = o) : (
            // Create an empty map to represent the current nesting level
            o = new Map, n.set(i, o), n = o);
        }
        n.set(t.et(), e);
    }, 
    /** Returns an ObjectValue with all mutations applied. */ t.prototype.yt = function() {
        var t = this.gt(et.at(), this.Rt);
        return null != t ? new kt(t) : this.At;
    }, 
    /**
     * Applies any overlays from `currentOverlays` that exist at `currentPath`
     * and returns the merged data at `currentPath` (or null if there were no
     * changes).
     *
     * @param currentPath - The path at the current nesting level. Can be set to
     * FieldValue.emptyPath() to represent the root.
     * @param currentOverlays - The overlays at the current nesting level in the
     * same format as `overlayMap`.
     * @returns The merged data at `currentPath` or null if no modifications
     * were applied.
     */
    t.prototype.gt = function(t, e) {
        var n = this, r = !1, i = this.At.field(t), o = Dt(i) ? // If there is already data at the current path, base our
        Object.assign({}, i.mapValue.fields) : {};
        return e.forEach((function(e, i) {
            if (e instanceof Map) {
                var u = n.gt(t.child(i), e);
                null != u && (o[i] = u, r = !0);
            } else null !== e ? (o[i] = e, r = !0) : o.hasOwnProperty(i) && (delete o[i], r = !0);
        })), r ? {
            mapValue: {
                fields: o
            }
        } : null;
    }, t;
}();

/**
 * An ObjectValueBuilder provides APIs to set and delete fields from an
 * ObjectValue.
 */
/**
 * Returns a FieldMask built from all fields in a MapValue.
 */
function Ct(t) {
    var e = [];
    return it(t.fields || {}, (function(t, n) {
        var r = new et([ t ]);
        if (Dt(n)) {
            var i = Ct(n.mapValue).fields;
            if (0 === i.length) 
            // Preserve the empty map by adding it to the FieldMask.
            e.push(r); else 
            // For nested and non-empty ObjectValues, add the FieldPath of the
            // leaf nodes.
            for (var o = 0, u = i; o < u.length; o++) {
                var s = u[o];
                e.push(r.child(s));
            }
        } else 
        // For nested and non-empty ObjectValues, add the FieldPath of the leaf
        // nodes.
        e.push(r);
    })), new ut(e)
    /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * The result of a lookup for a given path may be an existing document or a
 * marker that this document does not exist at a given version.
 */;
}

var Lt = function(t, e) {
    this.key = t, this.version = e;
}, Vt = /** @class */ function(t) {
    function e(e, n, r, i) {
        var o = this;
        return (o = t.call(this, e, n) || this).Vt = r, o.bt = !!i.bt, o.hasCommittedMutations = !!i.hasCommittedMutations, 
        o;
    }
    return w(e, t), e.prototype.field = function(t) {
        return this.Vt.field(t);
    }, e.prototype.data = function() {
        return this.Vt;
    }, e.prototype.vt = function() {
        return this.Vt.proto;
    }, e.prototype.isEqual = function(t) {
        return t instanceof e && this.key.isEqual(t.key) && this.version.isEqual(t.version) && this.bt === t.bt && this.hasCommittedMutations === t.hasCommittedMutations && this.Vt.isEqual(t.Vt);
    }, e.prototype.toString = function() {
        return "Document(" + this.key + ", " + this.version + ", " + this.Vt.toString() + ", {hasLocalMutations: " + this.bt + "}), {hasCommittedMutations: " + this.hasCommittedMutations + "})";
    }, Object.defineProperty(e.prototype, "hasPendingWrites", {
        get: function() {
            return this.bt || this.hasCommittedMutations;
        },
        enumerable: !1,
        configurable: !0
    }), e;
}(Lt), Rt = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this, e, n) || this).hasCommittedMutations = !(!r || !r.hasCommittedMutations), 
        i;
    }
    return w(e, t), e.prototype.toString = function() {
        return "NoDocument(" + this.key + ", " + this.version + ")";
    }, Object.defineProperty(e.prototype, "hasPendingWrites", {
        get: function() {
            return this.hasCommittedMutations;
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.isEqual = function(t) {
        return t instanceof e && t.hasCommittedMutations === this.hasCommittedMutations && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }, e;
}(Lt), Pt = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e.prototype.toString = function() {
        return "UnknownDocument(" + this.key + ", " + this.version + ")";
    }, Object.defineProperty(e.prototype, "hasPendingWrites", {
        get: function() {
            return !0;
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.isEqual = function(t) {
        return t instanceof e && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }, e;
}(Lt), Ut = function(t, e, n, r, i, o, u) {
    void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = null), void 0 === u && (u = null), 
    this.path = t, this.collectionGroup = e, this.orderBy = n, this.filters = r, this.limit = i, 
    this.startAt = o, this.endAt = u, this.St = null;
};

/**
 * Represents a document in Firestore with a key, version, data and whether the
 * data has local mutations applied to it.
 */
/**
 * Initializes a Target with a path and optional additional query constraints.
 * Path must currently be empty if this is a collection group query.
 *
 * NOTE: you should always construct `Target` from `Query.toTarget` instead of
 * using this factory method, because `Query` provides an implicit `orderBy`
 * property.
 */
function xt(t, e, n, r, i, o, u) {
    return void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = null), void 0 === u && (u = null), 
    new Ut(t, e, n, r, i, o, u);
}

function qt(t) {
    var e = D(t);
    if (null === e.St) {
        var n = e.path.ot();
        null !== e.collectionGroup && (n += "|cg:" + e.collectionGroup), n += "|f:", n += e.filters.map((function(t) {
            return function(t) {
                // TODO(b/29183165): Technically, this won't be unique if two values have
                // the same description, such as the int 3 and the string "3". So we should
                // add the types in here somehow, too.
                return t.field.ot() + t.op.toString() + _t(t.value);
            }(t);
        })).join(","), n += "|ob:", n += e.orderBy.map((function(t) {
            return function(t) {
                // TODO(b/29183165): Make this collision robust.
                return t.field.ot() + t.dir;
            }(t);
        })).join(","), dt(e.limit) || (n += "|l:", n += e.limit), e.startAt && (n += "|lb:", 
        n += Xt(e.startAt)), e.endAt && (n += "|ub:", n += Xt(e.endAt)), e.St = n;
    }
    return e.St;
}

function Mt(t, e) {
    if (t.limit !== e.limit) return !1;
    if (t.orderBy.length !== e.orderBy.length) return !1;
    for (var n = 0; n < t.orderBy.length; n++) if (!$t(t.orderBy[n], e.orderBy[n])) return !1;
    if (t.filters.length !== e.filters.length) return !1;
    for (var r = 0; r < t.filters.length; r++) if (i = t.filters[r], o = e.filters[r], 
    i.op !== o.op || !i.field.isEqual(o.field) || !gt(i.value, o.value)) return !1;
    var i, o;
    return t.collectionGroup === e.collectionGroup && !!t.path.isEqual(e.path) && !!ee(t.startAt, e.startAt) && ee(t.endAt, e.endAt);
}

function Ft(t) {
    return nt.Et(t.path) && null === t.collectionGroup && 0 === t.filters.length;
}

var jt = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this) || this).field = e, i.op = n, i.value = r, i;
    }
    /**
     * Creates a filter based on the provided arguments.
     */    return w(e, t), e.create = function(t, n, r) {
        return t.ht() ? "in" /* IN */ === n || "not-in" /* NOT_IN */ === n ? this.Dt(t, n, r) : new zt(t, n, r) : "array-contains" /* ARRAY_CONTAINS */ === n ? new Kt(t, r) : "in" /* IN */ === n ? new Jt(t, r) : "not-in" /* NOT_IN */ === n ? new Wt(t, r) : "array-contains-any" /* ARRAY_CONTAINS_ANY */ === n ? new Qt(t, r) : new e(t, n, r);
    }, e.Dt = function(t, e, n) {
        return "in" /* IN */ === e ? new Gt(t, n) : new Ht(t, n);
    }, e.prototype.matches = function(t) {
        var e = t.field(this.field);
        // Types do not have to match in NOT_EQUAL filters.
                return "!=" /* NOT_EQUAL */ === this.op ? null !== e && this.Ct(wt(e, this.value)) : null !== e && yt(this.value) === yt(e) && this.Ct(wt(e, this.value));
        // Only compare types with matching backend order (such as double and int).
        }, e.prototype.Ct = function(t) {
        switch (this.op) {
          case "<" /* LESS_THAN */ :
            return t < 0;

          case "<=" /* LESS_THAN_OR_EQUAL */ :
            return t <= 0;

          case "==" /* EQUAL */ :
            return 0 === t;

          case "!=" /* NOT_EQUAL */ :
            return 0 !== t;

          case ">" /* GREATER_THAN */ :
            return t > 0;

          case ">=" /* GREATER_THAN_OR_EQUAL */ :
            return t >= 0;

          default:
            return A();
        }
    }, e.prototype.xt = function() {
        return [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , ">=" /* GREATER_THAN_OR_EQUAL */ , "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ].indexOf(this.op) >= 0;
    }, e;
}((function() {}));

var zt = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this, e, n, r) || this).key = nt.dt(r.referenceValue), i;
    }
    return w(e, t), e.prototype.matches = function(t) {
        var e = nt.J(t.key, this.key);
        return this.Ct(e);
    }, e;
}(jt), Gt = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, e, "in" /* IN */ , n) || this).keys = Bt("in" /* IN */ , n), 
        r;
    }
    return w(e, t), e.prototype.matches = function(t) {
        return this.keys.some((function(e) {
            return e.isEqual(t.key);
        }));
    }, e;
}(jt), Ht = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, e, "not-in" /* NOT_IN */ , n) || this).keys = Bt("not-in" /* NOT_IN */ , n), 
        r;
    }
    return w(e, t), e.prototype.matches = function(t) {
        return !this.keys.some((function(e) {
            return e.isEqual(t.key);
        }));
    }, e;
}(jt);

/** Filter that matches on key fields within an array. */ function Bt(t, e) {
    var n;
    return ((null === (n = e.arrayValue) || void 0 === n ? void 0 : n.values) || []).map((function(t) {
        return nt.dt(t.referenceValue);
    }));
}

/** A Filter that implements the array-contains operator. */ var Kt = /** @class */ function(t) {
    function e(e, n) {
        return t.call(this, e, "array-contains" /* ARRAY_CONTAINS */ , n) || this;
    }
    return w(e, t), e.prototype.matches = function(t) {
        var e = t.field(this.field);
        return Nt(e) && mt(e.arrayValue, this.value);
    }, e;
}(jt), Jt = /** @class */ function(t) {
    function e(e, n) {
        return t.call(this, e, "in" /* IN */ , n) || this;
    }
    return w(e, t), e.prototype.matches = function(t) {
        var e = t.field(this.field);
        return null !== e && mt(this.value.arrayValue, e);
    }, e;
}(jt), Wt = /** @class */ function(t) {
    function e(e, n) {
        return t.call(this, e, "not-in" /* NOT_IN */ , n) || this;
    }
    return w(e, t), e.prototype.matches = function(t) {
        if (mt(this.value.arrayValue, {
            nullValue: "NULL_VALUE"
        })) return !1;
        var e = t.field(this.field);
        return null !== e && !mt(this.value.arrayValue, e);
    }, e;
}(jt), Qt = /** @class */ function(t) {
    function e(e, n) {
        return t.call(this, e, "array-contains-any" /* ARRAY_CONTAINS_ANY */ , n) || this;
    }
    return w(e, t), e.prototype.matches = function(t) {
        var e = this, n = t.field(this.field);
        return !(!Nt(n) || !n.arrayValue.values) && n.arrayValue.values.some((function(t) {
            return mt(e.value.arrayValue, t);
        }));
    }, e;
}(jt), Yt = function(t, e) {
    this.position = t, this.before = e;
};

/** A Filter that implements the IN operator. */ function Xt(t) {
    // TODO(b/29183165): Make this collision robust.
    return (t.before ? "b" : "a") + ":" + t.position.map((function(t) {
        return _t(t);
    })).join(",");
}

/**
 * An ordering on a field, in some Direction. Direction defaults to ASCENDING.
 */ var Zt = function(t, e /* ASCENDING */) {
    void 0 === e && (e = "asc"), this.field = t, this.dir = e;
};

function $t(t, e) {
    return t.dir === e.dir && t.field.isEqual(e.field);
}

/**
 * Returns true if a document sorts before a bound using the provided sort
 * order.
 */ function te(t, e, n) {
    for (var r = 0, i = 0; i < t.position.length; i++) {
        var o = e[i], u = t.position[i];
        if (r = o.field.ht() ? nt.J(nt.dt(u.referenceValue), n.key) : wt(u, n.field(o.field)), 
        "desc" /* DESCENDING */ === o.dir && (r *= -1), 0 !== r) break;
    }
    return t.before ? r <= 0 : r < 0;
}

function ee(t, e) {
    if (null === t) return null === e;
    if (null === e) return !1;
    if (t.before !== e.before || t.position.length !== e.position.length) return !1;
    for (var n = 0; n < t.position.length; n++) if (!gt(t.position[n], e.position[n])) return !1;
    return !0;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Query encapsulates all the query attributes we support in the SDK. It can
 * be run against the LocalStore, as well as be converted to a `Target` to
 * query the RemoteStore results.
 *
 * Visible for testing.
 */ var ne = 
/**
     * Initializes a Query with a path and optional additional query constraints.
     * Path must currently be empty if this is a collection group query.
     */
function(t, e, n, r, i, o /* First */ , u, s) {
    void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = "F"), void 0 === u && (u = null), 
    void 0 === s && (s = null), this.path = t, this.collectionGroup = e, this.Nt = n, 
    this.filters = r, this.limit = i, this.limitType = o, this.startAt = u, this.endAt = s, 
    this.Ft = null, 
    // The corresponding `Target` of this `Query` instance.
    this.Ot = null, this.startAt, this.endAt;
};

/** Creates a new Query instance with the options provided. */
/** Creates a new Query for a query that matches all documents at `path` */ function re(t) {
    return new ne(t);
}

/**
 * Helper to convert a collection group query into a collection query at a
 * specific path. This is used when executing collection group queries, since
 * we have to split the query into a set of collection queries at multiple
 * paths.
 */ function ie(t) {
    return !dt(t.limit) && "F" /* First */ === t.limitType;
}

function oe(t) {
    return !dt(t.limit) && "L" /* Last */ === t.limitType;
}

function ue(t) {
    return t.Nt.length > 0 ? t.Nt[0].field : null;
}

function se(t) {
    for (var e = 0, n = t.filters; e < n.length; e++) {
        var r = n[e];
        if (r.xt()) return r.field;
    }
    return null;
}

/**
 * Checks if any of the provided Operators are included in the query and
 * returns the first one that is, or null if none are.
 */
/**
 * Returns whether the query matches a collection group rather than a specific
 * collection.
 */ function ae(t) {
    return null !== t.collectionGroup;
}

/**
 * Returns the implicit order by constraint that is used to execute the Query,
 * which can be different from the order by constraints the user provided (e.g.
 * the SDK and backend always orders by `__name__`).
 */ function ce(t) {
    var e = D(t);
    if (null === e.Ft) {
        e.Ft = [];
        var n = se(e), r = ue(e);
        if (null !== n && null === r) 
        // In order to implicitly add key ordering, we must also add the
        // inequality filter field for it to be a valid query.
        // Note that the default inequality field and key ordering is ascending.
        n.ht() || e.Ft.push(new Zt(n)), e.Ft.push(new Zt(et.lt(), "asc" /* ASCENDING */)); else {
            for (var i = !1, o = 0, u = e.Nt; o < u.length; o++) {
                var s = u[o];
                e.Ft.push(s), s.field.ht() && (i = !0);
            }
            if (!i) {
                // The order of the implicit key ordering always matches the last
                // explicit order by
                var a = e.Nt.length > 0 ? e.Nt[e.Nt.length - 1].dir : "asc" /* ASCENDING */;
                e.Ft.push(new Zt(et.lt(), a));
            }
        }
    }
    return e.Ft;
}

/**
 * Converts this `Query` instance to it's corresponding `Target` representation.
 */ function fe(t) {
    var e = D(t);
    if (!e.Ot) if ("F" /* First */ === e.limitType) e.Ot = xt(e.path, e.collectionGroup, ce(e), e.filters, e.limit, e.startAt, e.endAt); else {
        for (
        // Flip the orderBy directions since we want the last results
        var n = [], r = 0, i = ce(e); r < i.length; r++) {
            var o = i[r], u = "desc" /* DESCENDING */ === o.dir ? "asc" /* ASCENDING */ : "desc" /* DESCENDING */;
            n.push(new Zt(o.field, u));
        }
        // We need to swap the cursors to match the now-flipped query ordering.
                var s = e.endAt ? new Yt(e.endAt.position, !e.endAt.before) : null, a = e.startAt ? new Yt(e.startAt.position, !e.startAt.before) : null;
        // Now return as a LimitType.First query.
                e.Ot = xt(e.path, e.collectionGroup, n, e.filters, e.limit, s, a);
    }
    return e.Ot;
}

function he(t, e, n) {
    return new ne(t.path, t.collectionGroup, t.Nt.slice(), t.filters.slice(), e, n, t.startAt, t.endAt);
}

function le(t, e) {
    return Mt(fe(t), fe(e)) && t.limitType === e.limitType;
}

// TODO(b/29183165): This is used to get a unique string from a query to, for
// example, use as a dictionary key, but the implementation is subject to
// collisions. Make it collision-free.
function pe(t) {
    return qt(fe(t)) + "|lt:" + t.limitType;
}

function de(t) {
    return "Query(target=" + function(t) {
        var e = t.path.ot();
        return null !== t.collectionGroup && (e += " collectionGroup=" + t.collectionGroup), 
        t.filters.length > 0 && (e += ", filters: [" + t.filters.map((function(t) {
            return (e = t).field.ot() + " " + e.op + " " + _t(e.value);
            /** Returns a debug description for `filter`. */            var e;
            /** Filter that matches on key fields (i.e. '__name__'). */        })).join(", ") + "]"), 
        dt(t.limit) || (e += ", limit: " + t.limit), t.orderBy.length > 0 && (e += ", orderBy: [" + t.orderBy.map((function(t) {
            return function(t) {
                return t.field.ot() + " (" + t.dir + ")";
            }(t);
        })).join(", ") + "]"), t.startAt && (e += ", startAt: " + Xt(t.startAt)), t.endAt && (e += ", endAt: " + Xt(t.endAt)), 
        "Target(" + e + ")";
    }(fe(t)) + "; limitType=" + t.limitType + ")";
}

/** Returns whether `doc` matches the constraints of `query`. */ function ve(t, e) {
    return function(t, e) {
        var n = e.key.path;
        return null !== t.collectionGroup ? e.key.wt(t.collectionGroup) && t.path.st(n) : nt.Et(t.path) ? t.path.isEqual(n) : t.path.it(n);
    }(t, e) && function(t, e) {
        for (var n = 0, r = t.Nt; n < r.length; n++) {
            var i = r[n];
            // order by key always matches
                        if (!i.field.ht() && null === e.field(i.field)) return !1;
        }
        return !0;
    }(t, e) && function(t, e) {
        for (var n = 0, r = t.filters; n < r.length; n++) {
            if (!r[n].matches(e)) return !1;
        }
        return !0;
    }(t, e) && function(t, e) {
        return !(t.startAt && !te(t.startAt, ce(t), e)) && (!t.endAt || !te(t.endAt, ce(t), e));
    }(t, e);
}

function ye(t) {
    return function(e, n) {
        for (var r = !1, i = 0, o = ce(t); i < o.length; i++) {
            var u = o[i], s = ge(u, e, n);
            if (0 !== s) return s;
            r = r || u.field.ht();
        }
        return 0;
    };
}

function ge(t, e, n) {
    var r = t.field.ht() ? nt.J(e.key, n.key) : function(t, e, n) {
        var r = e.field(t), i = n.field(t);
        return null !== r && null !== i ? wt(r, i) : A();
    }(t.field, e, n);
    switch (t.dir) {
      case "asc" /* ASCENDING */ :
        return r;

      case "desc" /* DESCENDING */ :
        return -1 * r;

      default:
        return A();
    }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An immutable set of metadata that the local store tracks for each target.
 */ var me = /** @class */ function() {
    function t(
    /** The target being listened to. */
    t, 
    /**
     * The target ID to which the target corresponds; Assigned by the
     * LocalStore for user listens and by the SyncEngine for limbo watches.
     */
    e, 
    /** The purpose of the target. */
    n, 
    /**
     * The sequence number of the last transaction during which this target data
     * was modified.
     */
    r, 
    /** The latest snapshot version seen for this target. */
    i
    /**
     * The maximum snapshot version at which the associated view
     * contained no limbo documents.
     */ , o
    /**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */ , u) {
        void 0 === i && (i = X.min()), void 0 === o && (o = X.min()), void 0 === u && (u = V.h), 
        this.target = t, this.targetId = e, this.kt = n, this.sequenceNumber = r, this.Mt = i, 
        this.lastLimboFreeSnapshotVersion = o, this.resumeToken = u;
    }
    /** Creates a new target data instance with an updated sequence number. */    return t.prototype.Lt = function(e) {
        return new t(this.target, this.targetId, this.kt, e, this.Mt, this.lastLimboFreeSnapshotVersion, this.resumeToken);
    }, 
    /**
     * Creates a new target data instance with an updated resume token and
     * snapshot version.
     */
    t.prototype.$t = function(e, n) {
        return new t(this.target, this.targetId, this.kt, this.sequenceNumber, n, this.lastLimboFreeSnapshotVersion, e);
    }, 
    /**
     * Creates a new target data instance with an updated last limbo free
     * snapshot version number.
     */
    t.prototype.Bt = function(e) {
        return new t(this.target, this.targetId, this.kt, this.sequenceNumber, this.Mt, e, this.resumeToken);
    }, t;
}();

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns an DoubleValue for `value` that is encoded based the serializer's
 * `useProto3Json` setting.
 */ function we(t, e) {
    if (t.qt) {
        if (isNaN(e)) return {
            doubleValue: "NaN"
        };
        if (e === 1 / 0) return {
            doubleValue: "Infinity"
        };
        if (e === -1 / 0) return {
            doubleValue: "-Infinity"
        };
    }
    return {
        doubleValue: vt(e) ? "-0" : e
    };
}

/**
 * Returns an IntegerValue for `value`.
 */ function be(t) {
    return {
        integerValue: "" + t
    };
}

/**
 * Returns a value for a number that's appropriate to put into a proto.
 * The return value is an IntegerValue if it can safely represent the value,
 * otherwise a DoubleValue is returned.
 */ function _e(t, e) {
    return function(t) {
        return "number" == typeof t && Number.isInteger(t) && !vt(t) && t <= Number.MAX_SAFE_INTEGER && t >= Number.MIN_SAFE_INTEGER;
    }(e) ? be(e) : we(t, e);
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Used to represent a field transform on a mutation. */ var Ee = function() {
    // Make sure that the structural type of `TransformOperation` is unique.
    // See https://github.com/microsoft/TypeScript/issues/5451
    this.Ut = void 0;
};

/**
 * Computes the local transform result against the provided `previousValue`,
 * optionally using the provided localWriteTime.
 */ function Ie(t, e, n) {
    return t instanceof Ae ? function(t, e) {
        var n = {
            fields: {
                __type__: {
                    stringValue: "server_timestamp"
                },
                __local_write_time__: {
                    timestampValue: {
                        seconds: t.seconds,
                        nanos: t.nanoseconds
                    }
                }
            }
        };
        return e && (n.fields.__previous_value__ = e), {
            mapValue: n
        };
    }(n, e) : t instanceof Se ? De(t, e) : t instanceof ke ? Oe(t, e) : function(t, e) {
        // PORTING NOTE: Since JavaScript's integer arithmetic is limited to 53 bit
        // precision and resolves overflows by reducing precision, we do not
        // manually cap overflows at 2^63.
        var n = Ne(t, e), r = Le(n) + Le(t.Qt);
        return Tt(n) && Tt(t.Qt) ? be(r) : we(t.Kt, r);
    }(t, e);
}

/**
 * Computes a final transform result after the transform has been acknowledged
 * by the server, potentially using the server-provided transformResult.
 */ function Te(t, e, n) {
    // The server just sends null as the transform result for array operations,
    // so we have to calculate a result the same as we do for local
    // applications.
    return t instanceof Se ? De(t, e) : t instanceof ke ? Oe(t, e) : n;
}

/**
 * If this transform operation is not idempotent, returns the base value to
 * persist for this transform. If a base value is returned, the transform
 * operation is always applied to this base value, even if document has
 * already been updated.
 *
 * Base values provide consistent behavior for non-idempotent transforms and
 * allow us to return the same latency-compensated value even if the backend
 * has already applied the transform operation. The base value is null for
 * idempotent transforms, as they can be re-played even if the backend has
 * already applied them.
 *
 * @returns a base value to store along with the mutation, or null for
 * idempotent transforms.
 */ function Ne(t, e) {
    return t instanceof Ce ? Tt(n = e) || function(t) {
        return !!t && "doubleValue" in t;
    }(n) ? e : {
        integerValue: 0
    } : null;
    var n;
}

/** Transforms a value into a server-generated timestamp. */ var Ae = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e;
}(Ee), Se = /** @class */ function(t) {
    function e(e) {
        var n = this;
        return (n = t.call(this) || this).elements = e, n;
    }
    return w(e, t), e;
}(Ee);

/** Transforms an array value via a union operation. */ function De(t, e) {
    for (var n = Ve(e), r = function(t) {
        n.some((function(e) {
            return gt(e, t);
        })) || n.push(t);
    }, i = 0, o = t.elements; i < o.length; i++) {
        r(o[i]);
    }
    return {
        arrayValue: {
            values: n
        }
    };
}

/** Transforms an array value via a remove operation. */ var ke = /** @class */ function(t) {
    function e(e) {
        var n = this;
        return (n = t.call(this) || this).elements = e, n;
    }
    return w(e, t), e;
}(Ee);

function Oe(t, e) {
    for (var n = Ve(e), r = function(t) {
        n = n.filter((function(e) {
            return !gt(e, t);
        }));
    }, i = 0, o = t.elements; i < o.length; i++) {
        r(o[i]);
    }
    return {
        arrayValue: {
            values: n
        }
    };
}

/**
 * Implements the backend semantics for locally computed NUMERIC_ADD (increment)
 * transforms. Converts all field values to integers or doubles, but unlike the
 * backend does not cap integer values at 2^63. Instead, JavaScript number
 * arithmetic is used and precision loss can occur for values greater than 2^53.
 */ var Ce = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this) || this).Kt = e, r.Qt = n, r;
    }
    return w(e, t), e;
}(Ee);

function Le(t) {
    return ct(t.integerValue || t.doubleValue);
}

function Ve(t) {
    return Nt(t) && t.arrayValue.values ? t.arrayValue.values.slice() : [];
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** A field path and the TransformOperation to perform upon it. */ var Re = function(t, e) {
    this.field = t, this.transform = e;
};

/** The result of successfully applying a mutation to the backend. */
var Pe = function(
/**
     * The version at which the mutation was committed:
     *
     * - For most operations, this is the updateTime in the WriteResult.
     * - For deletes, the commitTime of the WriteResponse (because deletes are
     *   not stored and have no updateTime).
     *
     * Note that these versions can be different: No-op writes will not change
     * the updateTime even though the commitTime advances.
     */
t, 
/**
     * The resulting fields returned from the backend after a mutation
     * containing field transforms has been committed. Contains one FieldValue
     * for each FieldTransform that was in the mutation.
     *
     * Will be null if the mutation did not contain any field transforms.
     */
e) {
    this.version = t, this.transformResults = e;
}, Ue = /** @class */ function() {
    function t(t, e) {
        this.updateTime = t, this.exists = e
        /** Creates a new empty Precondition. */;
    }
    return t.Wt = function() {
        return new t;
    }, 
    /** Creates a new Precondition with an exists flag. */ t.exists = function(e) {
        return new t(void 0, e);
    }, 
    /** Creates a new Precondition based on a version a document exists at. */ t.updateTime = function(e) {
        return new t(e);
    }, Object.defineProperty(t.prototype, "jt", {
        /** Returns whether this Precondition is empty. */ get: function() {
            return void 0 === this.updateTime && void 0 === this.exists;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(t) {
        return this.exists === t.exists && (this.updateTime ? !!t.updateTime && this.updateTime.isEqual(t.updateTime) : !t.updateTime);
    }, t;
}();

/**
 * Encodes a precondition for a mutation. This follows the model that the
 * backend accepts with the special case of an explicit "empty" precondition
 * (meaning no precondition).
 */
/**
 * Returns true if the preconditions is valid for the given document
 * (or null if no document is available).
 */
function xe(t, e) {
    return void 0 !== t.updateTime ? e instanceof Vt && e.version.isEqual(t.updateTime) : void 0 === t.exists || t.exists === e instanceof Vt;
}

/**
 * A mutation describes a self-contained change to a document. Mutations can
 * create, replace, delete, and update subsets of documents.
 *
 * Mutations not only act on the value of the document but also its version.
 *
 * For local mutations (mutations that haven't been committed yet), we preserve
 * the existing version for Set and Patch mutations. For Delete mutations, we
 * reset the version to 0.
 *
 * Here's the expected transition table.
 *
 * MUTATION           APPLIED TO            RESULTS IN
 *
 * SetMutation        Document(v3)          Document(v3)
 * SetMutation        NoDocument(v3)        Document(v0)
 * SetMutation        null                  Document(v0)
 * PatchMutation      Document(v3)          Document(v3)
 * PatchMutation      NoDocument(v3)        NoDocument(v3)
 * PatchMutation      null                  null
 * DeleteMutation     Document(v3)          NoDocument(v0)
 * DeleteMutation     NoDocument(v3)        NoDocument(v0)
 * DeleteMutation     null                  NoDocument(v0)
 *
 * For acknowledged mutations, we use the updateTime of the WriteResponse as
 * the resulting version for Set and Patch mutations. As deletes have no
 * explicit update time, we use the commitTime of the WriteResponse for
 * Delete mutations.
 *
 * If a mutation is acknowledged by the backend but fails the precondition check
 * locally, we return an `UnknownDocument` and rely on Watch to send us the
 * updated version.
 *
 * Field transforms are used only with Patch and Set Mutations. We use the
 * `updateTransforms` message to store transforms, rather than the `transforms`s
 * messages.
 *
 * ## Subclassing Notes
 *
 * Subclasses of Mutation need to implement applyToRemoteDocument() and
 * applyToLocalView() to implement the actual behavior of applying the mutation
 * to some source document.
 */ var qe = function() {};

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing a new remote document. If the input document doesn't match the
 * expected state (e.g. it is null or outdated), an `UnknownDocument` can be
 * returned.
 *
 * @param mutation - The mutation to apply.
 * @param maybeDoc - The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param mutationResult - The result of applying the mutation from the backend.
 * @returns The mutated document. The returned document may be an
 *     UnknownDocument if the mutation could not be applied to the locally
 *     cached base document.
 */ function Me(t, e, n) {
    return t instanceof He ? function(t, e, n) {
        // Unlike applySetMutationToLocalView, if we're applying a mutation to a
        // remote document the server has accepted the mutation so the precondition
        // must have held.
        var r = t.value;
        if (n.transformResults) {
            var i = Je(t.fieldTransforms, e, n.transformResults);
            r = Qe(t.fieldTransforms, r, i);
        }
        return new Vt(t.key, n.version, r, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : t instanceof Be ? function(t, e, n) {
        if (!xe(t.Gt, e)) 
        // Since the mutation was not rejected, we know that the precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new Pt(t.key, n.version);
        var r = Ke(t, e, n.transformResults ? Je(t.fieldTransforms, e, n.transformResults) : []);
        return new Vt(t.key, n.version, r, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : function(t, e, n) {
        // Unlike applyToLocalView, if we're applying a mutation to a remote
        // document the server has accepted the mutation so the precondition must
        // have held.
        return new Rt(t.key, n.version, {
            hasCommittedMutations: !0
        });
    }(t, 0, n);
}

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing the new local view of a document. Both the input and returned
 * documents can be null.
 *
 * @param mutation - The mutation to apply.
 * @param maybeDoc - The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param baseDoc - The state of the document prior to this mutation batch. The
 *     input document can be null if the client has no knowledge of the
 *     pre-mutation state of the document.
 * @param localWriteTime - A timestamp indicating the local write time of the
 *     batch this mutation is a part of.
 * @returns The mutated document. The returned document may be null, but only
 *     if maybeDoc was null and the mutation would not create a new document.
 */ function Fe(t, e, n, r) {
    return t instanceof He ? function(t, e, n, r) {
        if (!xe(t.Gt, e)) return e;
        var i = t.value, o = We(t.fieldTransforms, n, e);
        i = Qe(t.fieldTransforms, i, o);
        var u = Ge(e);
        return new Vt(t.key, u, i, {
            bt: !0
        });
    }(t, e, r) : t instanceof Be ? function(t, e, n, r) {
        if (!xe(t.Gt, e)) return e;
        var i = Ge(e), o = Ke(t, e, We(t.fieldTransforms, n, e));
        return new Vt(t.key, i, o, {
            bt: !0
        });
    }(t, e, r) : function(t, e) {
        return xe(t.Gt, e) ? new Rt(t.key, X.min()) : e;
    }(t, e);
}

/**
 * If this mutation is not idempotent, returns the base value to persist with
 * this mutation. If a base value is returned, the mutation is always applied
 * to this base value, even if document has already been updated.
 *
 * The base value is a sparse object that consists of only the document
 * fields for which this mutation contains a non-idempotent transformation
 * (e.g. a numeric increment). The provided value guarantees consistent
 * behavior for non-idempotent transforms and allow us to return the same
 * latency-compensated value even if the backend has already applied the
 * mutation. The base value is null for idempotent mutations, as they can be
 * re-played even if the backend has already applied them.
 *
 * @returns a base value to store along with the mutation, or null for
 * idempotent mutations.
 */ function je(t, e) {
    return function(t, e) {
        for (var n = null, r = 0, i = t; r < i.length; r++) {
            var o = i[r], u = e instanceof Vt ? e.field(o.field) : void 0, s = Ne(o.transform, u || null);
            null != s && (n = null == n ? (new Ot).set(o.field, s) : n.set(o.field, s));
        }
        return n ? n.yt() : null;
    }(t.fieldTransforms, e);
}

function ze(t, e) {
    return t.type === e.type && !!t.key.isEqual(e.key) && !!t.Gt.isEqual(e.Gt) && !!function(t, e) {
        return void 0 === t && void 0 === e || !(!t || !e) && L(t, e, (function(t, e) {
            return function(t, e) {
                return t.field.isEqual(e.field) && function(t, e) {
                    return t instanceof Se && e instanceof Se || t instanceof ke && e instanceof ke ? L(t.elements, e.elements, gt) : t instanceof Ce && e instanceof Ce ? gt(t.Qt, e.Qt) : t instanceof Ae && e instanceof Ae;
                }(t.transform, e.transform);
            }(t, e);
        }));
    }(t.fieldTransforms, e.fieldTransforms) && (0 /* Set */ === t.type ? t.value.isEqual(e.value) : 1 /* Patch */ !== t.type || t.data.isEqual(e.data) && t.zt.isEqual(e.zt));
}

/**
 * Returns the version from the given document for use as the result of a
 * mutation. Mutations are defined to return the version of the base document
 * only if it is an existing document. Deleted and unknown documents have a
 * post-mutation version of SnapshotVersion.min().
 */ function Ge(t) {
    return t instanceof Vt ? t.version : X.min();
}

/**
 * A mutation that creates or replaces the document at the given key with the
 * object value contents.
 */ var He = /** @class */ function(t) {
    function e(e, n, r, i) {
        void 0 === i && (i = []);
        var o = this;
        return (o = t.call(this) || this).key = e, o.value = n, o.Gt = r, o.fieldTransforms = i, 
        o.type = 0 /* Set */ , o;
    }
    return w(e, t), e;
}(qe), Be = /** @class */ function(t) {
    function e(e, n, r, i, o) {
        void 0 === o && (o = []);
        var u = this;
        return (u = t.call(this) || this).key = e, u.data = n, u.zt = r, u.Gt = i, u.fieldTransforms = o, 
        u.type = 1 /* Patch */ , u;
    }
    return w(e, t), e;
}(qe);

function Ke(t, e, n) {
    var r;
    return r = function(t, e) {
        var n = new Ot(e);
        return t.zt.fields.forEach((function(e) {
            if (!e.nt()) {
                var r = t.data.field(e);
                null !== r ? n.set(e, r) : n.delete(e);
            }
        })), n.yt();
    }(t, r = e instanceof Vt ? e.data() : kt.empty()), r = Qe(t.fieldTransforms, r, n);
}

function Je(t, e, n) {
    var r = [];
    S(t.length === n.length);
    for (var i = 0; i < n.length; i++) {
        var o = t[i], u = o.transform, s = null;
        e instanceof Vt && (s = e.field(o.field)), r.push(Te(u, s, n[i]));
    }
    return r;
}

/**
 * Creates a list of "transform results" (a transform result is a field value
 * representing the result of applying a transform) for use when applying a
 * transform locally.
 *
 * @param fieldTransforms - The field transforms to apply the result to.
 * @param localWriteTime - The local time of the mutation (used to
 *     generate ServerTimestampValues).
 * @param maybeDoc - The current state of the document after applying all
 *     previous mutations.
 * @param baseDoc - The document prior to applying this mutation batch.
 * @returns The transform results list.
 */ function We(t, e, n, r) {
    for (var i = [], o = 0, u = t; o < u.length; o++) {
        var s = u[o], a = s.transform, c = null;
        n instanceof Vt && (c = n.field(s.field)), i.push(Ie(a, c, e));
    }
    return i;
}

function Qe(t, e, n) {
    for (var r = new Ot(e), i = 0; i < t.length; i++) {
        var o = t[i];
        r.set(o.field, n[i]);
    }
    return r.yt();
}

/** A mutation that deletes the document at the given key. */ var Ye, Xe, Ze = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this) || this).key = e, r.Gt = n, r.type = 2 /* Delete */ , r.fieldTransforms = [], 
        r;
    }
    return w(e, t), e;
}(qe), $e = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this) || this).key = e, r.Gt = n, r.type = 3 /* Verify */ , r.fieldTransforms = [], 
        r;
    }
    return w(e, t), e;
}(qe), tn = 
// TODO(b/33078163): just use simplest form of existence filter for now
function(t) {
    this.count = t;
};

/**
 * Determines whether an error code represents a permanent error when received
 * in response to a non-write operation.
 *
 * See isPermanentWriteError for classifying write errors.
 */
function en(t) {
    switch (t) {
      case R.OK:
        return A();

      case R.CANCELLED:
      case R.UNKNOWN:
      case R.DEADLINE_EXCEEDED:
      case R.RESOURCE_EXHAUSTED:
      case R.INTERNAL:
      case R.UNAVAILABLE:
 // Unauthenticated means something went wrong with our token and we need
        // to retry with new credentials which will happen automatically.
              case R.UNAUTHENTICATED:
        return !1;

      case R.INVALID_ARGUMENT:
      case R.NOT_FOUND:
      case R.ALREADY_EXISTS:
      case R.PERMISSION_DENIED:
      case R.FAILED_PRECONDITION:
 // Aborted might be retried in some scenarios, but that is dependant on
        // the context and should handled individually by the calling code.
        // See https://cloud.google.com/apis/design/errors.
              case R.ABORTED:
      case R.OUT_OF_RANGE:
      case R.UNIMPLEMENTED:
      case R.DATA_LOSS:
        return !0;

      default:
        return A();
    }
}

/**
 * Determines whether an error code represents a permanent error when received
 * in response to a write operation.
 *
 * Write operations must be handled specially because as of b/119437764, ABORTED
 * errors on the write stream should be retried too (even though ABORTED errors
 * are not generally retryable).
 *
 * Note that during the initial handshake on the write stream an ABORTED error
 * signals that we should discard our stream token (i.e. it is permanent). This
 * means a handshake error should be classified with isPermanentError, above.
 */
/**
 * Maps an error Code from GRPC status code number, like 0, 1, or 14. These
 * are not the same as HTTP status codes.
 *
 * @returns The Code equivalent to the given GRPC status code. Fails if there
 *     is no match.
 */ function nn(t) {
    if (void 0 === t) 
    // This shouldn't normally happen, but in certain error cases (like trying
    // to send invalid proto messages) we may get an error with no GRPC code.
    return I("GRPC error has no .code"), R.UNKNOWN;
    switch (t) {
      case Ye.OK:
        return R.OK;

      case Ye.CANCELLED:
        return R.CANCELLED;

      case Ye.UNKNOWN:
        return R.UNKNOWN;

      case Ye.DEADLINE_EXCEEDED:
        return R.DEADLINE_EXCEEDED;

      case Ye.RESOURCE_EXHAUSTED:
        return R.RESOURCE_EXHAUSTED;

      case Ye.INTERNAL:
        return R.INTERNAL;

      case Ye.UNAVAILABLE:
        return R.UNAVAILABLE;

      case Ye.UNAUTHENTICATED:
        return R.UNAUTHENTICATED;

      case Ye.INVALID_ARGUMENT:
        return R.INVALID_ARGUMENT;

      case Ye.NOT_FOUND:
        return R.NOT_FOUND;

      case Ye.ALREADY_EXISTS:
        return R.ALREADY_EXISTS;

      case Ye.PERMISSION_DENIED:
        return R.PERMISSION_DENIED;

      case Ye.FAILED_PRECONDITION:
        return R.FAILED_PRECONDITION;

      case Ye.ABORTED:
        return R.ABORTED;

      case Ye.OUT_OF_RANGE:
        return R.OUT_OF_RANGE;

      case Ye.UNIMPLEMENTED:
        return R.UNIMPLEMENTED;

      case Ye.DATA_LOSS:
        return R.DATA_LOSS;

      default:
        return A();
    }
}

/**
 * Converts an HTTP response's error status to the equivalent error code.
 *
 * @param status - An HTTP error response status ("FAILED_PRECONDITION",
 * "UNKNOWN", etc.)
 * @returns The equivalent Code. Non-matching responses are mapped to
 *     Code.UNKNOWN.
 */ (Xe = Ye || (Ye = {}))[Xe.OK = 0] = "OK", Xe[Xe.CANCELLED = 1] = "CANCELLED", 
Xe[Xe.UNKNOWN = 2] = "UNKNOWN", Xe[Xe.INVALID_ARGUMENT = 3] = "INVALID_ARGUMENT", 
Xe[Xe.DEADLINE_EXCEEDED = 4] = "DEADLINE_EXCEEDED", Xe[Xe.NOT_FOUND = 5] = "NOT_FOUND", 
Xe[Xe.ALREADY_EXISTS = 6] = "ALREADY_EXISTS", Xe[Xe.PERMISSION_DENIED = 7] = "PERMISSION_DENIED", 
Xe[Xe.UNAUTHENTICATED = 16] = "UNAUTHENTICATED", Xe[Xe.RESOURCE_EXHAUSTED = 8] = "RESOURCE_EXHAUSTED", 
Xe[Xe.FAILED_PRECONDITION = 9] = "FAILED_PRECONDITION", Xe[Xe.ABORTED = 10] = "ABORTED", 
Xe[Xe.OUT_OF_RANGE = 11] = "OUT_OF_RANGE", Xe[Xe.UNIMPLEMENTED = 12] = "UNIMPLEMENTED", 
Xe[Xe.INTERNAL = 13] = "INTERNAL", Xe[Xe.UNAVAILABLE = 14] = "UNAVAILABLE", Xe[Xe.DATA_LOSS = 15] = "DATA_LOSS";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// An immutable sorted map implementation, based on a Left-leaning Red-Black
// tree.
var rn = /** @class */ function() {
    function t(t, e) {
        this.J = t, this.root = e || un.EMPTY;
    }
    // Returns a copy of the map, with the specified key/value added or replaced.
        return t.prototype.Ht = function(e, n) {
        return new t(this.J, this.root.Ht(e, n, this.J).copy(null, null, un.Jt, null, null));
    }, 
    // Returns a copy of the map, with the specified key removed.
    t.prototype.remove = function(e) {
        return new t(this.J, this.root.remove(e, this.J).copy(null, null, un.Jt, null, null));
    }, 
    // Returns the value of the node with the given key, or null.
    t.prototype.get = function(t) {
        for (var e = this.root; !e.nt(); ) {
            var n = this.J(t, e.key);
            if (0 === n) return e.value;
            n < 0 ? e = e.left : n > 0 && (e = e.right);
        }
        return null;
    }, 
    // Returns the index of the element in this sorted map, or -1 if it doesn't
    // exist.
    t.prototype.indexOf = function(t) {
        for (
        // Number of nodes that were pruned when descending right
        var e = 0, n = this.root; !n.nt(); ) {
            var r = this.J(t, n.key);
            if (0 === r) return e + n.left.size;
            r < 0 ? n = n.left : (
            // Count all nodes left of the node plus the node itself
            e += n.left.size + 1, n = n.right);
        }
        // Node not found
                return -1;
    }, t.prototype.nt = function() {
        return this.root.nt();
    }, Object.defineProperty(t.prototype, "size", {
        // Returns the total number of nodes in the map.
        get: function() {
            return this.root.size;
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Returns the minimum key in the map.
    t.prototype.Yt = function() {
        return this.root.Yt();
    }, 
    // Returns the maximum key in the map.
    t.prototype.Xt = function() {
        return this.root.Xt();
    }, 
    // Traverses the map in key order and calls the specified action function
    // for each key/value pair. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.Zt = function(t) {
        return this.root.Zt(t);
    }, t.prototype.forEach = function(t) {
        this.Zt((function(e, n) {
            return t(e, n), !1;
        }));
    }, t.prototype.toString = function() {
        var t = [];
        return this.Zt((function(e, n) {
            return t.push(e + ":" + n), !1;
        })), "{" + t.join(", ") + "}";
    }, 
    // Traverses the map in reverse key order and calls the specified action
    // function for each key/value pair. If action returns true, traversal is
    // aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.te = function(t) {
        return this.root.te(t);
    }, 
    // Returns an iterator over the SortedMap.
    t.prototype.ee = function() {
        return new on(this.root, null, this.J, !1);
    }, t.prototype.ne = function(t) {
        return new on(this.root, t, this.J, !1);
    }, t.prototype.se = function() {
        return new on(this.root, null, this.J, !0);
    }, t.prototype.ie = function(t) {
        return new on(this.root, t, this.J, !0);
    }, t;
}(), on = /** @class */ function() {
    function t(t, e, n, r) {
        this.re = r, this.oe = [];
        for (var i = 1; !t.nt(); ) if (i = e ? n(t.key, e) : 1, 
        // flip the comparison if we're going in reverse
        r && (i *= -1), i < 0) 
        // This node is less than our start key. ignore it
        t = this.re ? t.left : t.right; else {
            if (0 === i) {
                // This node is exactly equal to our start key. Push it on the stack,
                // but stop iterating;
                this.oe.push(t);
                break;
            }
            // This node is greater than our start key, add it to the stack and move
            // to the next one
                        this.oe.push(t), t = this.re ? t.right : t.left;
        }
    }
    return t.prototype.ce = function() {
        var t = this.oe.pop(), e = {
            key: t.key,
            value: t.value
        };
        if (this.re) for (t = t.left; !t.nt(); ) this.oe.push(t), t = t.right; else for (t = t.right; !t.nt(); ) this.oe.push(t), 
        t = t.left;
        return e;
    }, t.prototype.ae = function() {
        return this.oe.length > 0;
    }, t.prototype.ue = function() {
        if (0 === this.oe.length) return null;
        var t = this.oe[this.oe.length - 1];
        return {
            key: t.key,
            value: t.value
        };
    }, t;
}(), un = /** @class */ function() {
    function t(e, n, r, i, o) {
        this.key = e, this.value = n, this.color = null != r ? r : t.RED, this.left = null != i ? i : t.EMPTY, 
        this.right = null != o ? o : t.EMPTY, this.size = this.left.size + 1 + this.right.size;
    }
    // Returns a copy of the current node, optionally replacing pieces of it.
        return t.prototype.copy = function(e, n, r, i, o) {
        return new t(null != e ? e : this.key, null != n ? n : this.value, null != r ? r : this.color, null != i ? i : this.left, null != o ? o : this.right);
    }, t.prototype.nt = function() {
        return !1;
    }, 
    // Traverses the tree in key order and calls the specified action function
    // for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.Zt = function(t) {
        return this.left.Zt(t) || t(this.key, this.value) || this.right.Zt(t);
    }, 
    // Traverses the tree in reverse key order and calls the specified action
    // function for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.te = function(t) {
        return this.right.te(t) || t(this.key, this.value) || this.left.te(t);
    }, 
    // Returns the minimum node in the tree.
    t.prototype.min = function() {
        return this.left.nt() ? this : this.left.min();
    }, 
    // Returns the maximum key in the tree.
    t.prototype.Yt = function() {
        return this.min().key;
    }, 
    // Returns the maximum key in the tree.
    t.prototype.Xt = function() {
        return this.right.nt() ? this.key : this.right.Xt();
    }, 
    // Returns new tree, with the key/value added.
    t.prototype.Ht = function(t, e, n) {
        var r = this, i = n(t, r.key);
        return (r = i < 0 ? r.copy(null, null, null, r.left.Ht(t, e, n), null) : 0 === i ? r.copy(null, e, null, null, null) : r.copy(null, null, null, null, r.right.Ht(t, e, n))).he();
    }, t.prototype.le = function() {
        if (this.left.nt()) return t.EMPTY;
        var e = this;
        return e.left._e() || e.left.left._e() || (e = e.fe()), (e = e.copy(null, null, null, e.left.le(), null)).he();
    }, 
    // Returns new tree, with the specified item removed.
    t.prototype.remove = function(e, n) {
        var r, i = this;
        if (n(e, i.key) < 0) i.left.nt() || i.left._e() || i.left.left._e() || (i = i.fe()), 
        i = i.copy(null, null, null, i.left.remove(e, n), null); else {
            if (i.left._e() && (i = i.de()), i.right.nt() || i.right._e() || i.right.left._e() || (i = i.we()), 
            0 === n(e, i.key)) {
                if (i.right.nt()) return t.EMPTY;
                r = i.right.min(), i = i.copy(r.key, r.value, null, null, i.right.le());
            }
            i = i.copy(null, null, null, null, i.right.remove(e, n));
        }
        return i.he();
    }, t.prototype._e = function() {
        return this.color;
    }, 
    // Returns new tree after performing any needed rotations.
    t.prototype.he = function() {
        var t = this;
        return t.right._e() && !t.left._e() && (t = t.Ee()), t.left._e() && t.left.left._e() && (t = t.de()), 
        t.left._e() && t.right._e() && (t = t.Te()), t;
    }, t.prototype.fe = function() {
        var t = this.Te();
        return t.right.left._e() && (t = (t = (t = t.copy(null, null, null, null, t.right.de())).Ee()).Te()), 
        t;
    }, t.prototype.we = function() {
        var t = this.Te();
        return t.left.left._e() && (t = (t = t.de()).Te()), t;
    }, t.prototype.Ee = function() {
        var e = this.copy(null, null, t.RED, null, this.right.left);
        return this.right.copy(null, null, this.color, e, null);
    }, t.prototype.de = function() {
        var e = this.copy(null, null, t.RED, this.left.right, null);
        return this.left.copy(null, null, this.color, null, e);
    }, t.prototype.Te = function() {
        var t = this.left.copy(null, null, !this.left.color, null, null), e = this.right.copy(null, null, !this.right.color, null, null);
        return this.copy(null, null, !this.color, t, e);
    }, 
    // For testing.
    t.prototype.Ie = function() {
        var t = this.me();
        return Math.pow(2, t) <= this.size + 1;
    }, 
    // In a balanced RB tree, the black-depth (number of black nodes) from root to
    // leaves is equal on both sides.  This function verifies that or asserts.
    t.prototype.me = function() {
        if (this._e() && this.left._e()) throw A();
        if (this.right._e()) throw A();
        var t = this.left.me();
        if (t !== this.right.me()) throw A();
        return t + (this._e() ? 0 : 1);
    }, t;
}();

// end SortedMap
// An iterator over an LLRBNode.
// end LLRBNode
// Empty node is shared between all LLRB trees.
// eslint-disable-next-line @typescript-eslint/no-explicit-any
un.EMPTY = null, un.RED = !0, un.Jt = !1, 
// end LLRBEmptyNode
un.EMPTY = new (/** @class */ function() {
    function t() {
        this.size = 0;
    }
    return Object.defineProperty(t.prototype, "key", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "value", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "color", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "left", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "right", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Returns a copy of the current node.
    t.prototype.copy = function(t, e, n, r, i) {
        return this;
    }, 
    // Returns a copy of the tree, with the specified key/value added.
    t.prototype.Ht = function(t, e, n) {
        return new un(t, e);
    }, 
    // Returns a copy of the tree, with the specified key removed.
    t.prototype.remove = function(t, e) {
        return this;
    }, t.prototype.nt = function() {
        return !0;
    }, t.prototype.Zt = function(t) {
        return !1;
    }, t.prototype.te = function(t) {
        return !1;
    }, t.prototype.Yt = function() {
        return null;
    }, t.prototype.Xt = function() {
        return null;
    }, t.prototype._e = function() {
        return !1;
    }, 
    // For testing.
    t.prototype.Ie = function() {
        return !0;
    }, t.prototype.me = function() {
        return 0;
    }, t;
}());

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * SortedSet is an immutable (copy-on-write) collection that holds elements
 * in order specified by the provided comparator.
 *
 * NOTE: if provided comparator returns 0 for two elements, we consider them to
 * be equal!
 */
var sn = /** @class */ function() {
    function t(t) {
        this.J = t, this.data = new rn(this.J);
    }
    return t.prototype.has = function(t) {
        return null !== this.data.get(t);
    }, t.prototype.first = function() {
        return this.data.Yt();
    }, t.prototype.last = function() {
        return this.data.Xt();
    }, Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.data.size;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.indexOf = function(t) {
        return this.data.indexOf(t);
    }, 
    /** Iterates elements in order defined by "comparator" */ t.prototype.forEach = function(t) {
        this.data.Zt((function(e, n) {
            return t(e), !1;
        }));
    }, 
    /** Iterates over `elem`s such that: range[0] &lt;= elem &lt; range[1]. */ t.prototype.Ae = function(t, e) {
        for (var n = this.data.ne(t[0]); n.ae(); ) {
            var r = n.ce();
            if (this.J(r.key, t[1]) >= 0) return;
            e(r.key);
        }
    }, 
    /**
     * Iterates over `elem`s such that: start &lt;= elem until false is returned.
     */
    t.prototype.Re = function(t, e) {
        var n;
        for (n = void 0 !== e ? this.data.ne(e) : this.data.ee(); n.ae(); ) if (!t(n.ce().key)) return;
    }, 
    /** Finds the least element greater than or equal to `elem`. */ t.prototype.Pe = function(t) {
        var e = this.data.ne(t);
        return e.ae() ? e.ce().key : null;
    }, t.prototype.ee = function() {
        return new an(this.data.ee());
    }, t.prototype.ne = function(t) {
        return new an(this.data.ne(t));
    }, 
    /** Inserts or updates an element */ t.prototype.add = function(t) {
        return this.copy(this.data.remove(t).Ht(t, !0));
    }, 
    /** Deletes an element */ t.prototype.delete = function(t) {
        return this.has(t) ? this.copy(this.data.remove(t)) : this;
    }, t.prototype.nt = function() {
        return this.data.nt();
    }, t.prototype.ye = function(t) {
        var e = this;
        // Make sure `result` always refers to the larger one of the two sets.
                return e.size < t.size && (e = t, t = this), t.forEach((function(t) {
            e = e.add(t);
        })), e;
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) return !1;
        if (this.size !== e.size) return !1;
        for (var n = this.data.ee(), r = e.data.ee(); n.ae(); ) {
            var i = n.ce().key, o = r.ce().key;
            if (0 !== this.J(i, o)) return !1;
        }
        return !0;
    }, t.prototype.rt = function() {
        var t = [];
        return this.forEach((function(e) {
            t.push(e);
        })), t;
    }, t.prototype.toString = function() {
        var t = [];
        return this.forEach((function(e) {
            return t.push(e);
        })), "SortedSet(" + t.toString() + ")";
    }, t.prototype.copy = function(e) {
        var n = new t(this.J);
        return n.data = e, n;
    }, t;
}(), an = /** @class */ function() {
    function t(t) {
        this.ge = t;
    }
    return t.prototype.ce = function() {
        return this.ge.ce().key;
    }, t.prototype.ae = function() {
        return this.ge.ae();
    }, t;
}(), cn = new rn(nt.J);

function fn() {
    return cn;
}

function hn() {
    return fn();
}

var ln = new rn(nt.J);

function pn() {
    return ln;
}

var dn = new rn(nt.J);

function vn() {
    return dn;
}

var yn = new sn(nt.J);

function gn() {
    for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
    for (var n = yn, r = 0, i = t; r < i.length; r++) {
        var o = i[r];
        n = n.add(o);
    }
    return n;
}

var mn = new sn(C);

function wn() {
    return mn;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentSet is an immutable (copy-on-write) collection that holds documents
 * in order specified by the provided comparator. We always add a document key
 * comparator on top of what is provided to guarantee document equality based on
 * the key.
 */ var bn = /** @class */ function() {
    /** The default ordering is by key if the comparator is omitted */
    function t(t) {
        // We are adding document key comparator to the end as it's the only
        // guaranteed unique property of a document.
        this.J = t ? function(e, n) {
            return t(e, n) || nt.J(e.key, n.key);
        } : function(t, e) {
            return nt.J(t.key, e.key);
        }, this.Ve = pn(), this.pe = new rn(this.J)
        /**
     * Returns an empty copy of the existing DocumentSet, using the same
     * comparator.
     */;
    }
    return t.be = function(e) {
        return new t(e.J);
    }, t.prototype.has = function(t) {
        return null != this.Ve.get(t);
    }, t.prototype.get = function(t) {
        return this.Ve.get(t);
    }, t.prototype.first = function() {
        return this.pe.Yt();
    }, t.prototype.last = function() {
        return this.pe.Xt();
    }, t.prototype.nt = function() {
        return this.pe.nt();
    }, 
    /**
     * Returns the index of the provided key in the document set, or -1 if the
     * document key is not present in the set;
     */
    t.prototype.indexOf = function(t) {
        var e = this.Ve.get(t);
        return e ? this.pe.indexOf(e) : -1;
    }, Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.pe.size;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /** Iterates documents in order defined by "comparator" */ t.prototype.forEach = function(t) {
        this.pe.Zt((function(e, n) {
            return t(e), !1;
        }));
    }, 
    /** Inserts or updates a document with the same key */ t.prototype.add = function(t) {
        // First remove the element if we have it.
        var e = this.delete(t.key);
        return e.copy(e.Ve.Ht(t.key, t), e.pe.Ht(t, null));
    }, 
    /** Deletes a document with a given key */ t.prototype.delete = function(t) {
        var e = this.get(t);
        return e ? this.copy(this.Ve.remove(t), this.pe.remove(e)) : this;
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) return !1;
        if (this.size !== e.size) return !1;
        for (var n = this.pe.ee(), r = e.pe.ee(); n.ae(); ) {
            var i = n.ce().key, o = r.ce().key;
            if (!i.isEqual(o)) return !1;
        }
        return !0;
    }, t.prototype.toString = function() {
        var t = [];
        return this.forEach((function(e) {
            t.push(e.toString());
        })), 0 === t.length ? "DocumentSet ()" : "DocumentSet (\n  " + t.join("  \n") + "\n)";
    }, t.prototype.copy = function(e, n) {
        var r = new t;
        return r.J = this.J, r.Ve = e, r.pe = n, r;
    }, t;
}(), _n = /** @class */ function() {
    function t() {
        this.ve = new rn(nt.J);
    }
    return t.prototype.track = function(t) {
        var e = t.doc.key, n = this.ve.get(e);
        n ? 
        // Merge the new change with the existing change.
        0 /* Added */ !== t.type && 3 /* Metadata */ === n.type ? this.ve = this.ve.Ht(e, t) : 3 /* Metadata */ === t.type && 1 /* Removed */ !== n.type ? this.ve = this.ve.Ht(e, {
            type: n.type,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 2 /* Modified */ === n.type ? this.ve = this.ve.Ht(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 0 /* Added */ === n.type ? this.ve = this.ve.Ht(e, {
            type: 0 /* Added */ ,
            doc: t.doc
        }) : 1 /* Removed */ === t.type && 0 /* Added */ === n.type ? this.ve = this.ve.remove(e) : 1 /* Removed */ === t.type && 2 /* Modified */ === n.type ? this.ve = this.ve.Ht(e, {
            type: 1 /* Removed */ ,
            doc: n.doc
        }) : 0 /* Added */ === t.type && 1 /* Removed */ === n.type ? this.ve = this.ve.Ht(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 
        // This includes these cases, which don't make sense:
        // Added->Added
        // Removed->Removed
        // Modified->Added
        // Removed->Modified
        // Metadata->Added
        // Removed->Metadata
        A() : this.ve = this.ve.Ht(e, t);
    }, t.prototype.Se = function() {
        var t = [];
        return this.ve.Zt((function(e, n) {
            t.push(n);
        })), t;
    }, t;
}(), En = /** @class */ function() {
    function t(t, e, n, r, i, o, u, s) {
        this.query = t, this.docs = e, this.De = n, this.docChanges = r, this.Ce = i, this.fromCache = o, 
        this.xe = u, this.Ne = s
        /** Returns a view snapshot as if all documents in the snapshot were added. */;
    }
    return t.Fe = function(e, n, r, i) {
        var o = [];
        return n.forEach((function(t) {
            o.push({
                type: 0 /* Added */ ,
                doc: t
            });
        })), new t(e, n, bn.be(n), o, r, i, 
        /* syncStateChanged= */ !0, 
        /* excludesMetadataChanges= */ !1);
    }, Object.defineProperty(t.prototype, "hasPendingWrites", {
        get: function() {
            return !this.Ce.nt();
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(t) {
        if (!(this.fromCache === t.fromCache && this.xe === t.xe && this.Ce.isEqual(t.Ce) && le(this.query, t.query) && this.docs.isEqual(t.docs) && this.De.isEqual(t.De))) return !1;
        var e = this.docChanges, n = t.docChanges;
        if (e.length !== n.length) return !1;
        for (var r = 0; r < e.length; r++) if (e[r].type !== n[r].type || !e[r].doc.isEqual(n[r].doc)) return !1;
        return !0;
    }, t;
}(), In = /** @class */ function() {
    function t(
    /**
     * The snapshot version this event brings us up to, or MIN if not set.
     */
    t, 
    /**
     * A map from target to changes to the target. See TargetChange.
     */
    e, 
    /**
     * A set of targets that is known to be inconsistent. Listens for these
     * targets should be re-established without resume tokens.
     */
    n, 
    /**
     * A set of which documents have changed or been deleted, along with the
     * doc's new values (if not deleted).
     */
    r, 
    /**
     * A set of which document updates are due only to limbo resolution targets.
     */
    i) {
        this.Mt = t, this.Oe = e, this.ke = n, this.Me = r, this.Le = i;
    }
    /**
     * HACK: Views require RemoteEvents in order to determine whether the view is
     * CURRENT, but secondary tabs don't receive remote events. So this method is
     * used to create a synthesized RemoteEvent that can be used to apply a
     * CURRENT status change to a View, for queries executed in a different tab.
     */
    // PORTING NOTE: Multi-tab only
        return t.$e = function(e, n) {
        var r = new Map;
        return r.set(e, Tn.Be(e, n)), new t(X.min(), r, wn(), fn(), gn());
    }, t;
}(), Tn = /** @class */ function() {
    function t(
    /**
     * An opaque, server-assigned token that allows watching a query to be resumed
     * after disconnecting without retransmitting all the data that matches the
     * query. The resume token essentially identifies a point in time from which
     * the server should resume sending results.
     */
    t, 
    /**
     * The "current" (synced) status of this target. Note that "current"
     * has special meaning in the RPC protocol that implies that a target is
     * both up-to-date and consistent with the rest of the watch stream.
     */
    e, 
    /**
     * The set of documents that were newly assigned to this target as part of
     * this remote event.
     */
    n, 
    /**
     * The set of documents that were already assigned to this target but received
     * an update during this remote event.
     */
    r, 
    /**
     * The set of documents that were removed from this target as part of this
     * remote event.
     */
    i) {
        this.resumeToken = t, this.qe = e, this.Ue = n, this.Qe = r, this.Ke = i
        /**
     * This method is used to create a synthesized TargetChanges that can be used to
     * apply a CURRENT status change to a View (for queries executed in a different
     * tab) or for new queries (to raise snapshots with correct CURRENT status).
     */;
    }
    return t.Be = function(e, n) {
        return new t(V.h, n, gn(), gn(), gn());
    }, t;
}(), Nn = function(
/** The new document applies to all of these targets. */
t, 
/** The new document is removed from all of these targets. */
e, 
/** The key of the document for this change. */
n, 
/**
     * The new document or NoDocument if it was deleted. Is null if the
     * document went out of view without the server sending a new document.
     */
r) {
    this.We = t, this.removedTargetIds = e, this.key = n, this.je = r;
}, An = function(t, e) {
    this.targetId = t, this.Ge = e;
}, Sn = function(
/** What kind of change occurred to the watch target. */
t, 
/** The target IDs that were added/removed/set. */
e, 
/**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */
n
/** An RPC error indicating why the watch failed. */ , r) {
    void 0 === n && (n = V.h), void 0 === r && (r = null), this.state = t, this.targetIds = e, 
    this.resumeToken = n, this.cause = r;
}, Dn = /** @class */ function() {
    function t() {
        /**
         * The number of pending responses (adds or removes) that we are waiting on.
         * We only consider targets active that have no pending responses.
         */
        this.ze = 0, 
        /**
             * Keeps track of the document changes since the last raised snapshot.
             *
             * These changes are continuously updated as we receive document updates and
             * always reflect the current set of changes against the last issued snapshot.
             */
        this.He = Cn(), 
        /** See public getters for explanations of these fields. */
        this.Je = V.h, this.Ye = !1, 
        /**
             * Whether this target state should be included in the next snapshot. We
             * initialize to true so that newly-added targets are included in the next
             * RemoteEvent.
             */
        this.Xe = !0;
    }
    return Object.defineProperty(t.prototype, "qe", {
        /**
         * Whether this target has been marked 'current'.
         *
         * 'Current' has special meaning in the RPC protocol: It implies that the
         * Watch backend has sent us all changes up to the point at which the target
         * was added and that the target is consistent with the rest of the watch
         * stream.
         */
        get: function() {
            return this.Ye;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "resumeToken", {
        /** The last resume token sent to us for this target. */ get: function() {
            return this.Je;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "Ze", {
        /** Whether this target has pending target adds or target removes. */ get: function() {
            return 0 !== this.ze;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "tn", {
        /** Whether we have modified any state that should trigger a snapshot. */ get: function() {
            return this.Xe;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Applies the resume token to the TargetChange, but only when it has a new
     * value. Empty resumeTokens are discarded.
     */
    t.prototype.en = function(t) {
        t.o() > 0 && (this.Xe = !0, this.Je = t);
    }, 
    /**
     * Creates a target change from the current set of changes.
     *
     * To reset the document changes after raising this snapshot, call
     * `clearPendingChanges()`.
     */
    t.prototype.nn = function() {
        var t = gn(), e = gn(), n = gn();
        return this.He.forEach((function(r, i) {
            switch (i) {
              case 0 /* Added */ :
                t = t.add(r);
                break;

              case 2 /* Modified */ :
                e = e.add(r);
                break;

              case 1 /* Removed */ :
                n = n.add(r);
                break;

              default:
                A();
            }
        })), new Tn(this.Je, this.Ye, t, e, n);
    }, 
    /**
     * Resets the document changes and sets `hasPendingChanges` to false.
     */
    t.prototype.sn = function() {
        this.Xe = !1, this.He = Cn();
    }, t.prototype.rn = function(t, e) {
        this.Xe = !0, this.He = this.He.Ht(t, e);
    }, t.prototype.on = function(t) {
        this.Xe = !0, this.He = this.He.remove(t);
    }, t.prototype.cn = function() {
        this.ze += 1;
    }, t.prototype.an = function() {
        this.ze -= 1;
    }, t.prototype.un = function() {
        this.Xe = !0, this.Ye = !0;
    }, t;
}(), kn = /** @class */ function() {
    function t(t) {
        this.hn = t, 
        /** The internal state of all tracked targets. */
        this.ln = new Map, 
        /** Keeps track of the documents to update since the last raised snapshot. */
        this._n = fn(), 
        /** A mapping of document keys to their set of target IDs. */
        this.fn = On(), 
        /**
             * A list of targets with existence filter mismatches. These targets are
             * known to be inconsistent and their listens needs to be re-established by
             * RemoteStore.
             */
        this.dn = new sn(C)
        /**
     * Processes and adds the DocumentWatchChange to the current set of changes.
     */;
    }
    return t.prototype.wn = function(t) {
        for (var e = 0, n = t.We; e < n.length; e++) {
            var r = n[e];
            t.je instanceof Vt ? this.En(r, t.je) : t.je instanceof Rt && this.Tn(r, t.key, t.je);
        }
        for (var i = 0, o = t.removedTargetIds; i < o.length; i++) {
            r = o[i];
            this.Tn(r, t.key, t.je);
        }
    }, 
    /** Processes and adds the WatchTargetChange to the current set of changes. */ t.prototype.In = function(t) {
        var e = this;
        this.mn(t, (function(n) {
            var r = e.An(n);
            switch (t.state) {
              case 0 /* NoChange */ :
                e.Rn(n) && r.en(t.resumeToken);
                break;

              case 1 /* Added */ :
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                r.an(), r.Ze || 
                // We have a freshly added target, so we need to reset any state
                // that we had previously. This can happen e.g. when remove and add
                // back a target for existence filter mismatches.
                r.sn(), r.en(t.resumeToken);
                break;

              case 2 /* Removed */ :
                // We need to keep track of removed targets to we can post-filter and
                // remove any target changes.
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                r.an(), r.Ze || e.removeTarget(n);
                break;

              case 3 /* Current */ :
                e.Rn(n) && (r.un(), r.en(t.resumeToken));
                break;

              case 4 /* Reset */ :
                e.Rn(n) && (
                // Reset the target and synthesizes removes for all existing
                // documents. The backend will re-add any documents that still
                // match the target before it sends the next global snapshot.
                e.Pn(n), r.en(t.resumeToken));
                break;

              default:
                A();
            }
        }));
    }, 
    /**
     * Iterates over all targetIds that the watch change applies to: either the
     * targetIds explicitly listed in the change or the targetIds of all currently
     * active targets.
     */
    t.prototype.mn = function(t, e) {
        var n = this;
        t.targetIds.length > 0 ? t.targetIds.forEach(e) : this.ln.forEach((function(t, r) {
            n.Rn(r) && e(r);
        }));
    }, 
    /**
     * Handles existence filters and synthesizes deletes for filter mismatches.
     * Targets that are invalidated by filter mismatches are added to
     * `pendingTargetResets`.
     */
    t.prototype.yn = function(t) {
        var e = t.targetId, n = t.Ge.count, r = this.gn(e);
        if (r) {
            var i = r.target;
            if (Ft(i)) if (0 === n) {
                // The existence filter told us the document does not exist. We deduce
                // that this document does not exist and apply a deleted document to
                // our updates. Without applying this deleted document there might be
                // another query that will raise this document as part of a snapshot
                // until it is resolved, essentially exposing inconsistency between
                // queries.
                var o = new nt(i.path);
                this.Tn(e, o, new Rt(o, X.min()));
            } else S(1 === n); else this.Vn(e) !== n && (
            // Existence filter mismatch: We reset the mapping and raise a new
            // snapshot with `isFromCache:true`.
            this.Pn(e), this.dn = this.dn.add(e));
        }
    }, 
    /**
     * Converts the currently accumulated state into a remote event at the
     * provided snapshot version. Resets the accumulated changes before returning.
     */
    t.prototype.pn = function(t) {
        var e = this, n = new Map;
        this.ln.forEach((function(r, i) {
            var o = e.gn(i);
            if (o) {
                if (r.qe && Ft(o.target)) {
                    // Document queries for document that don't exist can produce an empty
                    // result set. To update our local cache, we synthesize a document
                    // delete if we have not previously received the document. This
                    // resolves the limbo state of the document, removing it from
                    // limboDocumentRefs.
                    // TODO(dimond): Ideally we would have an explicit lookup target
                    // instead resulting in an explicit delete message and we could
                    // remove this special logic.
                    var u = new nt(o.target.path);
                    null !== e._n.get(u) || e.bn(i, u) || e.Tn(i, u, new Rt(u, t));
                }
                r.tn && (n.set(i, r.nn()), r.sn());
            }
        }));
        var r = gn();
        // We extract the set of limbo-only document updates as the GC logic
        // special-cases documents that do not appear in the target cache.
        // TODO(gsoltis): Expand on this comment once GC is available in the JS
        // client.
                this.fn.forEach((function(t, n) {
            var i = !0;
            n.Re((function(t) {
                var n = e.gn(t);
                return !n || 2 /* LimboResolution */ === n.kt || (i = !1, !1);
            })), i && (r = r.add(t));
        }));
        var i = new In(t, n, this.dn, this._n, r);
        return this._n = fn(), this.fn = On(), this.dn = new sn(C), i;
    }, 
    /**
     * Adds the provided document to the internal list of document updates and
     * its document key to the given target's mapping.
     */
    // Visible for testing.
    t.prototype.En = function(t, e) {
        if (this.Rn(t)) {
            var n = this.bn(t, e.key) ? 2 /* Modified */ : 0 /* Added */;
            this.An(t).rn(e.key, n), this._n = this._n.Ht(e.key, e), this.fn = this.fn.Ht(e.key, this.vn(e.key).add(t));
        }
    }, 
    /**
     * Removes the provided document from the target mapping. If the
     * document no longer matches the target, but the document's state is still
     * known (e.g. we know that the document was deleted or we received the change
     * that caused the filter mismatch), the new document can be provided
     * to update the remote document cache.
     */
    // Visible for testing.
    t.prototype.Tn = function(t, e, n) {
        if (this.Rn(t)) {
            var r = this.An(t);
            this.bn(t, e) ? r.rn(e, 1 /* Removed */) : 
            // The document may have entered and left the target before we raised a
            // snapshot, so we can just ignore the change.
            r.on(e), this.fn = this.fn.Ht(e, this.vn(e).delete(t)), n && (this._n = this._n.Ht(e, n));
        }
    }, t.prototype.removeTarget = function(t) {
        this.ln.delete(t);
    }, 
    /**
     * Returns the current count of documents in the target. This includes both
     * the number of documents that the LocalStore considers to be part of the
     * target as well as any accumulated changes.
     */
    t.prototype.Vn = function(t) {
        var e = this.An(t).nn();
        return this.hn.Sn(t).size + e.Ue.size - e.Ke.size;
    }, 
    /**
     * Increment the number of acks needed from watch before we can consider the
     * server to be 'in-sync' with the client's active targets.
     */
    t.prototype.cn = function(t) {
        this.An(t).cn();
    }, t.prototype.An = function(t) {
        var e = this.ln.get(t);
        return e || (e = new Dn, this.ln.set(t, e)), e;
    }, t.prototype.vn = function(t) {
        var e = this.fn.get(t);
        return e || (e = new sn(C), this.fn = this.fn.Ht(t, e)), e;
    }, 
    /**
     * Verifies that the user is still interested in this target (by calling
     * `getTargetDataForTarget()`) and that we are not waiting for pending ADDs
     * from watch.
     */
    t.prototype.Rn = function(t) {
        var e = null !== this.gn(t);
        return e || E("WatchChangeAggregator", "Detected inactive target", t), e;
    }, 
    /**
     * Returns the TargetData for an active target (i.e. a target that the user
     * is still interested in that has no outstanding target change requests).
     */
    t.prototype.gn = function(t) {
        var e = this.ln.get(t);
        return e && e.Ze ? null : this.hn.Dn(t);
    }, 
    /**
     * Resets the state of a Watch target to its initial state (e.g. sets
     * 'current' to false, clears the resume token and removes its target mapping
     * from all documents).
     */
    t.prototype.Pn = function(t) {
        var e = this;
        this.ln.set(t, new Dn), this.hn.Sn(t).forEach((function(n) {
            e.Tn(t, n, /*updatedDocument=*/ null);
        }));
    }, 
    /**
     * Returns whether the LocalStore considers the document to be part of the
     * specified target.
     */
    t.prototype.bn = function(t, e) {
        return this.hn.Sn(t).has(e);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentChangeSet keeps track of a set of changes to docs in a query, merging
 * duplicate events for the same doc.
 */ function On() {
    return new rn(nt.J);
}

function Cn() {
    return new rn(nt.J);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var Ln = {
    asc: "ASCENDING",
    desc: "DESCENDING"
}, Vn = {
    "<": "LESS_THAN",
    "<=": "LESS_THAN_OR_EQUAL",
    ">": "GREATER_THAN",
    ">=": "GREATER_THAN_OR_EQUAL",
    "==": "EQUAL",
    "!=": "NOT_EQUAL",
    "array-contains": "ARRAY_CONTAINS",
    in: "IN",
    "not-in": "NOT_IN",
    "array-contains-any": "ARRAY_CONTAINS_ANY"
}, Rn = function(t, e) {
    this.T = t, this.qt = e;
};

/**
 * This class generates JsonObject values for the Datastore API suitable for
 * sending to either GRPC stub methods or via the JSON/HTTP REST API.
 *
 * The serializer supports both Protobuf.js and Proto3 JSON formats. By
 * setting `useProto3Json` to true, the serializer will use the Proto3 JSON
 * format.
 *
 * For a description of the Proto3 JSON format check
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 *
 * TODO(klimt): We can remove the databaseId argument if we keep the full
 * resource name in documents.
 */
/**
 * Returns a value for a Date that's appropriate to put into a proto.
 */
function Pn(t, e) {
    return t.qt ? new Date(1e3 * e.seconds).toISOString().replace(/\.\d*/, "").replace("Z", "") + "." + ("000000000" + e.nanoseconds).slice(-9) + "Z" : {
        seconds: "" + e.seconds,
        nanos: e.nanoseconds
    };
}

/**
 * Returns a value for bytes that's appropriate to put in a proto.
 *
 * Visible for testing.
 */ function Un(t, e) {
    return t.qt ? e.toBase64() : e.toUint8Array();
}

/**
 * Returns a ByteString based on the proto string value.
 */ function xn(t, e) {
    return Pn(t, e.G());
}

function qn(t) {
    return S(!!t), X.W(function(t) {
        var e = at(t);
        return new Y(e.seconds, e.nanos);
    }(t));
}

function Mn(t, e) {
    return function(t) {
        return new $([ "projects", t.projectId, "databases", t.database ]);
    }(t).child("documents").child(e).ot();
}

function Fn(t) {
    var e = $.ct(t);
    return S(sr(e)), e;
}

function jn(t, e) {
    return Mn(t.T, e.path);
}

function zn(t, e) {
    var n = Fn(e);
    if (n.get(1) !== t.T.projectId) throw new P(R.INVALID_ARGUMENT, "Tried to deserialize key from different project: " + n.get(1) + " vs " + t.T.projectId);
    if (n.get(3) !== t.T.database) throw new P(R.INVALID_ARGUMENT, "Tried to deserialize key from different database: " + n.get(3) + " vs " + t.T.database);
    return new nt(Bn(n));
}

function Gn(t, e) {
    return Mn(t.T, e);
}

function Hn(t) {
    return new $([ "projects", t.T.projectId, "databases", t.T.database ]).ot();
}

function Bn(t) {
    return S(t.length > 4 && "documents" === t.get(4)), t.X(5)
    /** Creates a Document proto from key and fields (but no create/update time) */;
}

function Kn(t, e, n) {
    return {
        name: jn(t, e),
        fields: n.proto.mapValue.fields
    };
}

function Jn(t, e) {
    var n;
    if (e instanceof He) n = {
        update: Kn(t, e.key, e.value)
    }; else if (e instanceof Ze) n = {
        delete: jn(t, e.key)
    }; else if (e instanceof Be) n = {
        update: Kn(t, e.key, e.data),
        updateMask: ur(e.zt)
    }; else {
        if (!(e instanceof $e)) return A();
        n = {
            verify: jn(t, e.key)
        };
    }
    return e.fieldTransforms.length > 0 && (n.updateTransforms = e.fieldTransforms.map((function(t) {
        return function(t, e) {
            var n = e.transform;
            if (n instanceof Ae) return {
                fieldPath: e.field.ot(),
                setToServerValue: "REQUEST_TIME"
            };
            if (n instanceof Se) return {
                fieldPath: e.field.ot(),
                appendMissingElements: {
                    values: n.elements
                }
            };
            if (n instanceof ke) return {
                fieldPath: e.field.ot(),
                removeAllFromArray: {
                    values: n.elements
                }
            };
            if (n instanceof Ce) return {
                fieldPath: e.field.ot(),
                increment: n.Qt
            };
            throw A();
        }(0, t);
    }))), e.Gt.jt || (n.currentDocument = function(t, e) {
        return void 0 !== e.updateTime ? {
            updateTime: xn(t, e.updateTime)
        } : void 0 !== e.exists ? {
            exists: e.exists
        } : A();
    }(t, e.Gt)), n;
}

function Wn(t, e) {
    return {
        documents: [ Gn(t, e.path) ]
    };
}

function Qn(t, e) {
    // Dissect the path into parent, collectionId, and optional key filter.
    var n = {
        structuredQuery: {}
    }, r = e.path;
    null !== e.collectionGroup ? (n.parent = Gn(t, r), n.structuredQuery.from = [ {
        collectionId: e.collectionGroup,
        allDescendants: !0
    } ]) : (n.parent = Gn(t, r.Z()), n.structuredQuery.from = [ {
        collectionId: r.et()
    } ]);
    var i = function(t) {
        if (0 !== t.length) {
            var e = t.map((function(t) {
                // visible for testing
                return function(t) {
                    if ("==" /* EQUAL */ === t.op) {
                        if (St(t.value)) return {
                            unaryFilter: {
                                field: nr(t.field),
                                op: "IS_NAN"
                            }
                        };
                        if (At(t.value)) return {
                            unaryFilter: {
                                field: nr(t.field),
                                op: "IS_NULL"
                            }
                        };
                    } else if ("!=" /* NOT_EQUAL */ === t.op) {
                        if (St(t.value)) return {
                            unaryFilter: {
                                field: nr(t.field),
                                op: "IS_NOT_NAN"
                            }
                        };
                        if (At(t.value)) return {
                            unaryFilter: {
                                field: nr(t.field),
                                op: "IS_NOT_NULL"
                            }
                        };
                    }
                    return {
                        fieldFilter: {
                            field: nr(t.field),
                            op: er(t.op),
                            value: t.value
                        }
                    };
                }(t);
            }));
            return 1 === e.length ? e[0] : {
                compositeFilter: {
                    op: "AND",
                    filters: e
                }
            };
        }
    }(e.filters);
    i && (n.structuredQuery.where = i);
    var o = function(t) {
        if (0 !== t.length) return t.map((function(t) {
            // visible for testing
            return function(t) {
                return {
                    field: nr(t.field),
                    direction: tr(t.dir)
                };
            }(t);
        }));
    }(e.orderBy);
    o && (n.structuredQuery.orderBy = o);
    var u = function(t, e) {
        return t.qt || dt(e) ? e : {
            value: e
        };
    }(t, e.limit);
    return null !== u && (n.structuredQuery.limit = u), e.startAt && (n.structuredQuery.startAt = Zn(e.startAt)), 
    e.endAt && (n.structuredQuery.endAt = Zn(e.endAt)), n;
}

function Yn(t) {
    var e = function(t) {
        var e = Fn(t);
        // In v1beta1 queries for collections at the root did not have a trailing
        // "/documents". In v1 all resource paths contain "/documents". Preserve the
        // ability to read the v1beta1 form for compatibility with queries persisted
        // in the local target cache.
                return 4 === e.length ? $.at() : Bn(e);
    }(t.parent), n = t.structuredQuery, r = n.from ? n.from.length : 0, i = null;
    if (r > 0) {
        S(1 === r);
        var o = n.from[0];
        o.allDescendants ? i = o.collectionId : e = e.child(o.collectionId);
    }
    var u = [];
    n.where && (u = Xn(n.where));
    var s = [];
    n.orderBy && (s = n.orderBy.map((function(t) {
        return function(t) {
            return new Zt(rr(t.field), 
            // visible for testing
            function(t) {
                switch (t) {
                  case "ASCENDING":
                    return "asc" /* ASCENDING */;

                  case "DESCENDING":
                    return "desc" /* DESCENDING */;

                  default:
                    return;
                }
            }(t.direction));
        }(t);
    })));
    var a = null;
    n.limit && (a = function(t) {
        var e;
        return dt(e = "object" == typeof t ? t.value : t) ? null : e;
    }(n.limit));
    var c = null;
    n.startAt && (c = $n(n.startAt));
    var f = null;
    return n.endAt && (f = $n(n.endAt)), function(t, e, n, r, i, o, u, s) {
        return new ne(t, e, n, r, i, o, u, s);
    }(e, i, s, u, a, "F" /* First */ , c, f);
}

function Xn(t) {
    return t ? void 0 !== t.unaryFilter ? [ or(t) ] : void 0 !== t.fieldFilter ? [ ir(t) ] : void 0 !== t.compositeFilter ? t.compositeFilter.filters.map((function(t) {
        return Xn(t);
    })).reduce((function(t, e) {
        return t.concat(e);
    })) : A() : [];
}

function Zn(t) {
    return {
        before: t.before,
        values: t.position
    };
}

function $n(t) {
    var e = !!t.before, n = t.values || [];
    return new Yt(n, e);
}

// visible for testing
function tr(t) {
    return Ln[t];
}

function er(t) {
    return Vn[t];
}

function nr(t) {
    return {
        fieldPath: t.ot()
    };
}

function rr(t) {
    return et._t(t.fieldPath);
}

function ir(t) {
    return jt.create(rr(t.fieldFilter.field), function(t) {
        switch (t) {
          case "EQUAL":
            return "==" /* EQUAL */;

          case "NOT_EQUAL":
            return "!=" /* NOT_EQUAL */;

          case "GREATER_THAN":
            return ">" /* GREATER_THAN */;

          case "GREATER_THAN_OR_EQUAL":
            return ">=" /* GREATER_THAN_OR_EQUAL */;

          case "LESS_THAN":
            return "<" /* LESS_THAN */;

          case "LESS_THAN_OR_EQUAL":
            return "<=" /* LESS_THAN_OR_EQUAL */;

          case "ARRAY_CONTAINS":
            return "array-contains" /* ARRAY_CONTAINS */;

          case "IN":
            return "in" /* IN */;

          case "NOT_IN":
            return "not-in" /* NOT_IN */;

          case "ARRAY_CONTAINS_ANY":
            return "array-contains-any" /* ARRAY_CONTAINS_ANY */;

          case "OPERATOR_UNSPECIFIED":
          default:
            return A();
        }
    }(t.fieldFilter.op), t.fieldFilter.value);
}

function or(t) {
    switch (t.unaryFilter.op) {
      case "IS_NAN":
        var e = rr(t.unaryFilter.field);
        return jt.create(e, "==" /* EQUAL */ , {
            doubleValue: NaN
        });

      case "IS_NULL":
        var n = rr(t.unaryFilter.field);
        return jt.create(n, "==" /* EQUAL */ , {
            nullValue: "NULL_VALUE"
        });

      case "IS_NOT_NAN":
        var r = rr(t.unaryFilter.field);
        return jt.create(r, "!=" /* NOT_EQUAL */ , {
            doubleValue: NaN
        });

      case "IS_NOT_NULL":
        var i = rr(t.unaryFilter.field);
        return jt.create(i, "!=" /* NOT_EQUAL */ , {
            nullValue: "NULL_VALUE"
        });

      case "OPERATOR_UNSPECIFIED":
      default:
        return A();
    }
}

function ur(t) {
    var e = [];
    return t.fields.forEach((function(t) {
        return e.push(t.ot());
    })), {
        fieldPaths: e
    };
}

function sr(t) {
    // Resource names have at least 4 components (project ID, database ID)
    return t.length >= 4 && "projects" === t.get(0) && "databases" === t.get(2);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var ar = function() {
    var t = this;
    this.promise = new Promise((function(e, n) {
        t.resolve = e, t.reject = n;
    }));
}, cr = /** @class */ function() {
    function t(t) {
        var e = this;
        // NOTE: next/catchCallback will always point to our own wrapper functions,
        // not the user's raw next() or catch() callbacks.
                this.Cn = null, this.xn = null, 
        // When the operation resolves, we'll set result or error and mark isDone.
        this.result = void 0, this.error = void 0, this.Nn = !1, 
        // Set to true when .then() or .catch() are called and prevents additional
        // chaining.
        this.Fn = !1, t((function(t) {
            e.Nn = !0, e.result = t, e.Cn && 
            // value should be defined unless T is Void, but we can't express
            // that in the type system.
            e.Cn(t);
        }), (function(t) {
            e.Nn = !0, e.error = t, e.xn && e.xn(t);
        }));
    }
    return t.prototype.catch = function(t) {
        return this.next(void 0, t);
    }, t.prototype.next = function(e, n) {
        var r = this;
        return this.Fn && A(), this.Fn = !0, this.Nn ? this.error ? this.On(n, this.error) : this.kn(e, this.result) : new t((function(t, i) {
            r.Cn = function(n) {
                r.kn(e, n).next(t, i);
            }, r.xn = function(e) {
                r.On(n, e).next(t, i);
            };
        }));
    }, t.prototype.Mn = function() {
        var t = this;
        return new Promise((function(e, n) {
            t.next(e, n);
        }));
    }, t.prototype.Ln = function(e) {
        try {
            var n = e();
            return n instanceof t ? n : t.resolve(n);
        } catch (e) {
            return t.reject(e);
        }
    }, t.prototype.kn = function(e, n) {
        return e ? this.Ln((function() {
            return e(n);
        })) : t.resolve(n);
    }, t.prototype.On = function(e, n) {
        return e ? this.Ln((function() {
            return e(n);
        })) : t.reject(n);
    }, t.resolve = function(e) {
        return new t((function(t, n) {
            t(e);
        }));
    }, t.reject = function(e) {
        return new t((function(t, n) {
            n(e);
        }));
    }, t.$n = function(
    // Accept all Promise types in waitFor().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    e) {
        return new t((function(t, n) {
            var r = 0, i = 0, o = !1;
            e.forEach((function(e) {
                ++r, e.next((function() {
                    ++i, o && i === r && t();
                }), (function(t) {
                    return n(t);
                }));
            })), o = !0, i === r && t();
        }));
    }, 
    /**
     * Given an array of predicate functions that asynchronously evaluate to a
     * boolean, implements a short-circuiting `or` between the results. Predicates
     * will be evaluated until one of them returns `true`, then stop. The final
     * result will be whether any of them returned `true`.
     */
    t.Bn = function(e) {
        for (var n = t.resolve(!1), r = function(e) {
            n = n.next((function(n) {
                return n ? t.resolve(n) : e();
            }));
        }, i = 0, o = e; i < o.length; i++) {
            r(o[i]);
        }
        return n;
    }, t.forEach = function(t, e) {
        var n = this, r = [];
        return t.forEach((function(t, i) {
            r.push(e.call(n, t, i));
        })), this.$n(r);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * PersistencePromise is essentially a re-implementation of Promise except
 * it has a .next() method instead of .then() and .next() and .catch() callbacks
 * are executed synchronously when a PersistencePromise resolves rather than
 * asynchronously (Promise implementations use setImmediate() or similar).
 *
 * This is necessary to interoperate with IndexedDB which will automatically
 * commit transactions if control is returned to the event loop without
 * synchronously initiating another operation on the transaction.
 *
 * NOTE: .then() and .catch() only allow a single consumer, unlike normal
 * Promises.
 */
/** Verifies whether `e` is an IndexedDbTransactionError. */ function fr(t) {
    // Use name equality, as instanceof checks on errors don't work with errors
    // that wrap other errors.
    return "IndexedDbTransactionError" === t.name;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents an operation scheduled to be run in the future on an AsyncQueue.
 *
 * It is created via DelayedOperation.createAndSchedule().
 *
 * Supports cancellation (via cancel()) and early execution (via skipDelay()).
 *
 * Note: We implement `PromiseLike` instead of `Promise`, as the `Promise` type
 * in newer versions of TypeScript defines `finally`, which is not available in
 * IE.
 */ var hr = /** @class */ function() {
    function t(t, e, n, r, i) {
        this.fs = t, this.ds = e, this.ws = n, this.op = r, this.Es = i, this.Ts = new ar, 
        this.then = this.Ts.promise.then.bind(this.Ts.promise), 
        // It's normal for the deferred promise to be canceled (due to cancellation)
        // and so we attach a dummy catch callback to avoid
        // 'UnhandledPromiseRejectionWarning' log spam.
        this.Ts.promise.catch((function(t) {}))
        /**
     * Creates and returns a DelayedOperation that has been scheduled to be
     * executed on the provided asyncQueue after the provided delayMs.
     *
     * @param asyncQueue - The queue to schedule the operation on.
     * @param id - A Timer ID identifying the type of operation this is.
     * @param delayMs - The delay (ms) before the operation should be scheduled.
     * @param op - The operation to run.
     * @param removalCallback - A callback to be called synchronously once the
     *   operation is executed or canceled, notifying the AsyncQueue to remove it
     *   from its delayedOperations list.
     *   PORTING NOTE: This exists to prevent making removeDelayedOperation() and
     *   the DelayedOperation class public.
     */;
    }
    return t.Is = function(e, n, r, i, o) {
        var u = new t(e, n, Date.now() + r, i, o);
        return u.start(r), u;
    }, 
    /**
     * Starts the timer. This is called immediately after construction by
     * createAndSchedule().
     */
    t.prototype.start = function(t) {
        var e = this;
        this.As = setTimeout((function() {
            return e.Rs();
        }), t);
    }, 
    /**
     * Queues the operation to run immediately (if it hasn't already been run or
     * canceled).
     */
    t.prototype.Ps = function() {
        return this.Rs();
    }, 
    /**
     * Cancels the operation if it hasn't already been executed or canceled. The
     * promise will be rejected.
     *
     * As long as the operation has not yet been run, calling cancel() provides a
     * guarantee that the operation will not be run.
     */
    t.prototype.cancel = function(t) {
        null !== this.As && (this.clearTimeout(), this.Ts.reject(new P(R.CANCELLED, "Operation cancelled" + (t ? ": " + t : ""))));
    }, t.prototype.Rs = function() {
        var t = this;
        this.fs.ys((function() {
            return null !== t.As ? (t.clearTimeout(), t.op().then((function(e) {
                return t.Ts.resolve(e);
            }))) : Promise.resolve();
        }));
    }, t.prototype.clearTimeout = function() {
        null !== this.As && (this.Es(this), clearTimeout(this.As), this.As = null);
    }, t;
}();

/**
 * Returns a FirestoreError that can be surfaced to the user if the provided
 * error is an IndexedDbTransactionError. Re-throws the error otherwise.
 */ function lr(t, e) {
    if (I("AsyncQueue", e + ": " + t), fr(t)) return new P(R.UNAVAILABLE, e + ": " + t);
    throw t;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var pr = /** @class */ function() {
    function t() {
        this.gs = [];
    }
    return t.prototype.Vs = function(t) {
        this.gs.push(t);
    }, t.prototype.ps = function() {
        this.gs.forEach((function(t) {
            return t();
        }));
    }, t;
}(), dr = /** @class */ function() {
    /**
     * @param batchId - The unique ID of this mutation batch.
     * @param localWriteTime - The original write time of this mutation.
     * @param baseMutations - Mutations that are used to populate the base
     * values when this mutation is applied locally. This can be used to locally
     * overwrite values that are persisted in the remote document cache. Base
     * mutations are never sent to the backend.
     * @param mutations - The user-provided mutations in this mutation batch.
     * User-provided mutations are applied both locally and remotely on the
     * backend.
     */
    function t(t, e, n, r) {
        this.batchId = t, this.Ss = e, this.baseMutations = n, this.mutations = r
        /**
     * Applies all the mutations in this MutationBatch to the specified document
     * to create a new remote document
     *
     * @param docKey - The key of the document to apply mutations to.
     * @param maybeDoc - The document to apply mutations to.
     * @param batchResult - The result of applying the MutationBatch to the
     * backend.
     */;
    }
    return t.prototype.Ds = function(t, e, n) {
        for (var r = n.Cs, i = 0; i < this.mutations.length; i++) {
            var o = this.mutations[i];
            o.key.isEqual(t) && (e = Me(o, e, r[i]));
        }
        return e;
    }, 
    /**
     * Computes the local view of a document given all the mutations in this
     * batch.
     *
     * @param docKey - The key of the document to apply mutations to.
     * @param maybeDoc - The document to apply mutations to.
     */
    t.prototype.xs = function(t, e) {
        // First, apply the base state. This allows us to apply non-idempotent
        // transform against a consistent set of values.
        for (var n = 0, r = this.baseMutations; n < r.length; n++) {
            (u = r[n]).key.isEqual(t) && (e = Fe(u, e, 0, this.Ss));
        }
        // Second, apply all user-provided mutations.
                for (var i = 0, o = this.mutations; i < o.length; i++) {
            var u;
            (u = o[i]).key.isEqual(t) && (e = Fe(u, e, 0, this.Ss));
        }
        return e;
    }, 
    /**
     * Computes the local view for all provided documents given the mutations in
     * this batch.
     */
    t.prototype.Ns = function(t) {
        var e = this, n = t;
        // TODO(mrschmidt): This implementation is O(n^2). If we apply the mutations
        // directly (as done in `applyToLocalView()`), we can reduce the complexity
        // to O(n).
                return this.mutations.forEach((function(r) {
            var i = e.xs(r.key, t.get(r.key));
            i && (n = n.Ht(r.key, i));
        })), n;
    }, t.prototype.keys = function() {
        return this.mutations.reduce((function(t, e) {
            return t.add(e.key);
        }), gn());
    }, t.prototype.isEqual = function(t) {
        return this.batchId === t.batchId && L(this.mutations, t.mutations, (function(t, e) {
            return ze(t, e);
        })) && L(this.baseMutations, t.baseMutations, (function(t, e) {
            return ze(t, e);
        }));
    }, t;
}(), vr = /** @class */ function() {
    function t(t, e, n, 
    /**
     * A pre-computed mapping from each mutated document to the resulting
     * version.
     */
    r) {
        this.batch = t, this.Fs = e, this.Cs = n, this.Os = r
        /**
     * Creates a new MutationBatchResult for the given batch and results. There
     * must be one result for each mutation in the batch. This static factory
     * caches a document=&gt;version mapping (docVersions).
     */;
    }
    return t.from = function(e, n, r) {
        S(e.mutations.length === r.length);
        for (var i = vn(), o = e.mutations, u = 0; u < o.length; u++) i = i.Ht(o[u].key, r[u].version);
        return new t(e, n, r, i);
    }, t;
}(), yr = function(t) {
    this.ks = t;
};

/**
 * A base class representing a persistence transaction, encapsulating both the
 * transaction's sequence numbers as well as a list of onCommitted listeners.
 *
 * When you call Persistence.runTransaction(), it will create a transaction and
 * pass it to your callback. You then pass it to any method that operates
 * on persistence.
 */
/**
 * A helper function for figuring out what kind of query has been stored.
 */
/**
 * Encodes a `BundledQuery` from bundle proto to a Query object.
 *
 * This reconstructs the original query used to build the bundle being loaded,
 * including features exists only in SDKs (for example: limit-to-last).
 */
function gr(t) {
    var e = Yn({
        parent: t.parent,
        structuredQuery: t.structuredQuery
    });
    return "LAST" === t.limitType ? he(e, e.limit, "L" /* Last */) : e;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An in-memory implementation of IndexManager.
 */ var mr = /** @class */ function() {
    function t() {
        this.qs = new wr;
    }
    return t.prototype.Us = function(t, e) {
        return this.qs.add(e), cr.resolve();
    }, t.prototype.Qs = function(t, e) {
        return cr.resolve(this.qs.getEntries(e));
    }, t;
}(), wr = /** @class */ function() {
    function t() {
        this.index = {};
    }
    // Returns false if the entry already existed.
        return t.prototype.add = function(t) {
        var e = t.et(), n = t.Z(), r = this.index[e] || new sn($.J), i = !r.has(n);
        return this.index[e] = r.add(n), i;
    }, t.prototype.has = function(t) {
        var e = t.et(), n = t.Z(), r = this.index[e];
        return r && r.has(n);
    }, t.prototype.getEntries = function(t) {
        return (this.index[t] || new sn($.J)).rt();
    }, t;
}();

/**
 * Internal implementation of the collection-parent index exposed by MemoryIndexManager.
 * Also used for in-memory caching by IndexedDbIndexManager and initial index population
 * in indexeddb_schema.ts
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Verifies the error thrown by a LocalStore operation. If a LocalStore
 * operation fails because the primary lease has been taken by another client,
 * we ignore the error (the persistence layer will immediately call
 * `applyPrimaryLease` to propagate the primary state change). All other errors
 * are re-thrown.
 *
 * @param err - An error returned by a LocalStore operation.
 * @returns A Promise that resolves after we recovered, or the original error.
 */
function br(t) {
    return y(this, void 0, void 0, (function() {
        return g(this, (function(e) {
            if (t.code !== R.FAILED_PRECONDITION || "The current tab is not in the required state to perform this operation. It might be necessary to refresh the browser tab." !== t.message) throw t;
            return E("LocalStore", "Unexpectedly lost primary lease"), [ 2 /*return*/ ];
        }));
    }));
}

var _r = /** @class */ function() {
    function t(t, e) {
        this.si = t, this.ii = e, 
        /**
             * The inner map for a key/value pair. Due to the possibility of collisions we
             * keep a list of entries that we do a linear search through to find an actual
             * match. Note that collisions should be rare, so we still expect near
             * constant time lookups in practice.
             */
        this.ri = {}
        /** Get a value for this key, or undefined if it does not exist. */;
    }
    return t.prototype.get = function(t) {
        var e = this.si(t), n = this.ri[e];
        if (void 0 !== n) for (var r = 0, i = n; r < i.length; r++) {
            var o = i[r], u = o[0], s = o[1];
            if (this.ii(u, t)) return s;
        }
    }, t.prototype.has = function(t) {
        return void 0 !== this.get(t);
    }, 
    /** Put this key and value in the map. */ t.prototype.set = function(t, e) {
        var n = this.si(t), r = this.ri[n];
        if (void 0 !== r) {
            for (var i = 0; i < r.length; i++) if (this.ii(r[i][0], t)) return void (r[i] = [ t, e ]);
            r.push([ t, e ]);
        } else this.ri[n] = [ [ t, e ] ];
    }, 
    /**
     * Remove this key from the map. Returns a boolean if anything was deleted.
     */
    t.prototype.delete = function(t) {
        var e = this.si(t), n = this.ri[e];
        if (void 0 === n) return !1;
        for (var r = 0; r < n.length; r++) if (this.ii(n[r][0], t)) return 1 === n.length ? delete this.ri[e] : n.splice(r, 1), 
        !0;
        return !1;
    }, t.prototype.forEach = function(t) {
        it(this.ri, (function(e, n) {
            for (var r = 0, i = n; r < i.length; r++) {
                var o = i[r], u = o[0], s = o[1];
                t(u, s);
            }
        }));
    }, t.prototype.nt = function() {
        return ot(this.ri);
    }, t;
}(), Er = /** @class */ function() {
    function t() {
        // A mapping of document key to the new cache entry that should be written (or null if any
        // existing cache entry should be removed).
        this.oi = new _r((function(t) {
            return t.toString();
        }), (function(t, e) {
            return t.isEqual(e);
        })), this.ci = !1;
    }
    return t.prototype.ai = function(t) {
        var e = this.oi.get(t);
        return e ? e.readTime : X.min();
    }, 
    /**
     * Buffers a `RemoteDocumentCache.addEntry()` call.
     *
     * You can only modify documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */
    t.prototype.ui = function(t, e) {
        this.hi(), this.oi.set(t.key, {
            li: t,
            readTime: e
        });
    }, 
    /**
     * Buffers a `RemoteDocumentCache.removeEntry()` call.
     *
     * You can only remove documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */
    t.prototype._i = function(t, e) {
        void 0 === e && (e = null), this.hi(), this.oi.set(t, {
            li: null,
            readTime: e
        });
    }, 
    /**
     * Looks up an entry in the cache. The buffered changes will first be checked,
     * and if no buffered change applies, this will forward to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction - The transaction in which to perform any persistence
     *     operations.
     * @param documentKey - The key of the entry to look up.
     * @returns The cached Document or NoDocument entry, or null if we have
     *     nothing cached.
     */
    t.prototype.fi = function(t, e) {
        this.hi();
        var n = this.oi.get(e);
        return void 0 !== n ? cr.resolve(n.li) : this.di(t, e);
    }, 
    /**
     * Looks up several entries in the cache, forwarding to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction - The transaction in which to perform any persistence
     *     operations.
     * @param documentKeys - The keys of the entries to look up.
     * @returns A map of cached `Document`s or `NoDocument`s, indexed by key. If
     *     an entry cannot be found, the corresponding key will be mapped to a
     *     null value.
     */
    t.prototype.getEntries = function(t, e) {
        return this.wi(t, e);
    }, 
    /**
     * Applies buffered changes to the underlying RemoteDocumentCache, using
     * the provided transaction.
     */
    t.prototype.apply = function(t) {
        return this.hi(), this.ci = !0, this.Ei(t);
    }, 
    /** Helper to assert this.changes is not null  */ t.prototype.hi = function() {}, 
    t;
}(), Ir = /** @class */ function() {
    function t(t) {
        this.Li = t;
    }
    return t.prototype.next = function() {
        return this.Li += 2, this.Li;
    }, t.$i = function() {
        // The target cache generator must return '2' in its first call to `next()`
        // as there is no differentiation in the protocol layer between an unset
        // number and the number '0'. If we were to sent a target with target ID
        // '0', the backend would consider it unset and replace it with its own ID.
        return new t(0);
    }, t.Bi = function() {
        // Sync engine assigns target IDs for limbo document detection.
        return new t(-1);
    }, t;
}(), Tr = function(t, e) {
    this.progress = t, this.zo = e;
}, Nr = /** @class */ function() {
    function t(t, e, n) {
        this.wo = t, this.Ho = e, this.Ti = n
        /**
     * Get the local view of the document identified by `key`.
     *
     * @returns Local view of the document or null if we don't have any cached
     * state for it.
     */;
    }
    return t.prototype.Jo = function(t, e) {
        var n = this;
        return this.Ho.vi(t, e).next((function(r) {
            return n.Yo(t, e, r);
        }));
    }, 
    /** Internal version of `getDocument` that allows reusing batches. */ t.prototype.Yo = function(t, e, n) {
        return this.wo.fi(t, e).next((function(t) {
            for (var r = 0, i = n; r < i.length; r++) {
                t = i[r].xs(e, t);
            }
            return t;
        }));
    }, 
    // Returns the view of the given `docs` as they would appear after applying
    // all mutations in the given `batches`.
    t.prototype.Xo = function(t, e, n) {
        var r = hn();
        return e.forEach((function(t, e) {
            for (var i = 0, o = n; i < o.length; i++) {
                e = o[i].xs(t, e);
            }
            r = r.Ht(t, e);
        })), r;
    }, 
    /**
     * Gets the local view of the documents identified by `keys`.
     *
     * If we don't have cached state for a document in `keys`, a NoDocument will
     * be stored for that key in the resulting set.
     */
    t.prototype.Zo = function(t, e) {
        var n = this;
        return this.wo.getEntries(t, e).next((function(e) {
            return n.tc(t, e);
        }));
    }, 
    /**
     * Similar to `getDocuments`, but creates the local view from the given
     * `baseDocs` without retrieving documents from the local store.
     */
    t.prototype.tc = function(t, e) {
        var n = this;
        return this.Ho.Si(t, e).next((function(r) {
            var i = n.Xo(t, e, r), o = fn();
            return i.forEach((function(t, e) {
                // TODO(http://b/32275378): Don't conflate missing / deleted.
                e || (e = new Rt(t, X.min())), o = o.Ht(t, e);
            })), o;
        }));
    }, 
    /**
     * Performs a query against the local view of all documents.
     *
     * @param transaction - The persistence transaction.
     * @param query - The query to match documents against.
     * @param sinceReadTime - If not set to SnapshotVersion.min(), return only
     *     documents that have been read since this snapshot version (exclusive).
     */
    t.prototype.Wr = function(t, e, n) {
        /**
 * Returns whether the query matches a single document by path (rather than a
 * collection).
 */
        return function(t) {
            return nt.Et(t.path) && null === t.collectionGroup && 0 === t.filters.length;
        }(e) ? this.ec(t, e.path) : ae(e) ? this.nc(t, e, n) : this.sc(t, e, n);
    }, t.prototype.ec = function(t, e) {
        // Just do a simple document lookup.
        return this.Jo(t, new nt(e)).next((function(t) {
            var e = pn();
            return t instanceof Vt && (e = e.Ht(t.key, t)), e;
        }));
    }, t.prototype.nc = function(t, e, n) {
        var r = this, i = e.collectionGroup, o = pn();
        return this.Ti.Qs(t, i).next((function(u) {
            return cr.forEach(u, (function(u) {
                var s = function(t, e) {
                    return new ne(e, 
                    /*collectionGroup=*/ null, t.Nt.slice(), t.filters.slice(), t.limit, t.limitType, t.startAt, t.endAt);
                }(e, u.child(i));
                return r.sc(t, s, n).next((function(t) {
                    t.forEach((function(t, e) {
                        o = o.Ht(t, e);
                    }));
                }));
            })).next((function() {
                return o;
            }));
        }));
    }, t.prototype.sc = function(t, e, n) {
        var r, i, o = this;
        // Query the remote documents and overlay mutations.
                return this.wo.Wr(t, e, n).next((function(n) {
            return r = n, o.Ho.Ci(t, e);
        })).next((function(e) {
            return i = e, o.ic(t, i, r).next((function(t) {
                r = t;
                for (var e = 0, n = i; e < n.length; e++) for (var o = n[e], u = 0, s = o.mutations; u < s.length; u++) {
                    var a = s[u], c = a.key, f = Fe(a, r.get(c), 0, o.Ss);
                    r = f instanceof Vt ? r.Ht(c, f) : r.remove(c);
                }
            }));
        })).next((function() {
            // Finally, filter out any documents that don't actually match
            // the query.
            return r.forEach((function(t, n) {
                ve(e, n) || (r = r.remove(t));
            })), r;
        }));
    }, t.prototype.ic = function(t, e, n) {
        for (var r = gn(), i = 0, o = e; i < o.length; i++) for (var u = 0, s = o[i].mutations; u < s.length; u++) {
            var a = s[u];
            a instanceof Be && null === n.get(a.key) && (r = r.add(a.key));
        }
        var c = n;
        return this.wo.getEntries(t, r).next((function(t) {
            return t.forEach((function(t, e) {
                null !== e && e instanceof Vt && (c = c.Ht(t, e));
            })), c;
        }));
    }, t;
}(), Ar = /** @class */ function() {
    function t(t, e, n, r) {
        this.targetId = t, this.fromCache = e, this.rc = n, this.oc = r;
    }
    return t.cc = function(e, n) {
        for (var r = gn(), i = gn(), o = 0, u = n.docChanges; o < u.length; o++) {
            var s = u[o];
            switch (s.type) {
              case 0 /* Added */ :
                r = r.add(s.doc.key);
                break;

              case 1 /* Removed */ :
                i = i.add(s.doc.key);
                // do nothing
                        }
        }
        return new t(e, n.fromCache, r, i);
    }, t;
}(), Sr = /** @class */ function() {
    function t() {}
    /** Sets the document view to query against. */    return t.prototype.ac = function(t) {
        this.uc = t;
    }, 
    /** Returns all local documents matching the specified query. */ t.prototype.Wr = function(t, n, r, i) {
        var o = this;
        // Queries that match all documents don't benefit from using
        // key-based lookups. It is more efficient to scan all documents in a
        // collection, rather than to perform individual lookups.
                return function(t) {
            return 0 === t.filters.length && null === t.limit && null == t.startAt && null == t.endAt && (0 === t.Nt.length || 1 === t.Nt.length && t.Nt[0].field.ht());
        }(n) || r.isEqual(X.min()) ? this.hc(t, n) : this.uc.Zo(t, i).next((function(u) {
            var s = o.lc(n, u);
            return (ie(n) || oe(n)) && o._c(n.limitType, s, i, r) ? o.hc(t, n) : (_() <= e.DEBUG && E("QueryEngine", "Re-using previous result from %s to execute query: %s", r.toString(), de(n)), 
            o.uc.Wr(t, n, r).next((function(t) {
                // We merge `previousResults` into `updateResults`, since
                // `updateResults` is already a DocumentMap. If a document is
                // contained in both lists, then its contents are the same.
                return s.forEach((function(e) {
                    t = t.Ht(e.key, e);
                })), t;
            })));
        }));
        // Queries that have never seen a snapshot without limbo free documents
        // should also be run as a full collection scan.
        }, 
    /** Applies the query filter and sorting to the provided documents.  */ t.prototype.lc = function(t, e) {
        // Sort the documents and re-apply the query filter since previously
        // matching documents do not necessarily still match the query.
        var n = new sn(ye(t));
        return e.forEach((function(e, r) {
            r instanceof Vt && ve(t, r) && (n = n.add(r));
        })), n;
    }, 
    /**
     * Determines if a limit query needs to be refilled from cache, making it
     * ineligible for index-free execution.
     *
     * @param sortedPreviousResults - The documents that matched the query when it
     * was last synchronized, sorted by the query's comparator.
     * @param remoteKeys - The document keys that matched the query at the last
     * snapshot.
     * @param limboFreeSnapshotVersion - The version of the snapshot when the
     * query was last synchronized.
     */
    t.prototype._c = function(t, e, n, r) {
        // The query needs to be refilled if a previously matching document no
        // longer matches.
        if (n.size !== e.size) return !0;
        // Limit queries are not eligible for index-free query execution if there is
        // a potential that an older document from cache now sorts before a document
        // that was previously part of the limit. This, however, can only happen if
        // the document at the edge of the limit goes out of limit.
        // If a document that is not the limit boundary sorts differently,
        // the boundary of the limit itself did not change and documents from cache
        // will continue to be "rejected" by this boundary. Therefore, we can ignore
        // any modifications that don't affect the last document.
                var i = "F" /* First */ === t ? e.last() : e.first();
        return !!i && (i.hasPendingWrites || i.version.u(r) > 0);
    }, t.prototype.hc = function(t, n) {
        return _() <= e.DEBUG && E("QueryEngine", "Using full collection scan to execute query:", de(n)), 
        this.uc.Wr(t, n, X.min());
    }, t;
}(), Dr = /** @class */ function() {
    function t(
    /** Manages our in-memory or durable persistence. */
    t, e, n, r) {
        this.persistence = t, this.fc = e, this.Kt = r, 
        /**
             * Maps a targetID to data about its target.
             *
             * PORTING NOTE: We are using an immutable data structure on Web to make re-runs
             * of `applyRemoteEvent()` idempotent.
             */
        this.dc = new rn(C), 
        /** Maps a target to its targetID. */
        // TODO(wuandy): Evaluate if TargetId can be part of Target.
        this.wc = new _r((function(t) {
            return qt(t);
        }), Mt), 
        /**
             * The read time of the last entry processed by `getNewDocumentChanges()`.
             *
             * PORTING NOTE: This is only used for multi-tab synchronization.
             */
        this.Ec = X.min(), this.Ho = t.Ko(n), this.Tc = t.Or(), this.fo = t.Dr(), this.Ic = new Nr(this.Tc, this.Ho, this.persistence.Wo()), 
        this.Eo = t.jo(), this.fc.ac(this.Ic);
    }
    return t.prototype.mr = function(t) {
        var e = this;
        return this.persistence.runTransaction("Collect garbage", "readwrite-primary", (function(n) {
            return t.pr(n, e.dc);
        }));
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An in-memory buffer of entries to be written to a RemoteDocumentCache.
 * It can be used to batch up a set of changes to be written to the cache, but
 * additionally supports reading entries back with the `getEntry()` method,
 * falling back to the underlying RemoteDocumentCache if no entry is
 * buffered.
 *
 * Entries added to the cache *must* be read first. This is to facilitate
 * calculating the size delta of the pending changes.
 *
 * PORTING NOTE: This class was implemented then removed from other platforms.
 * If byte-counting ends up being needed on the other platforms, consider
 * porting this class as part of that implementation work.
 */
/**
 * Tells the LocalStore that the currently authenticated user has changed.
 *
 * In response the local store switches the mutation queue to the new user and
 * returns any resulting document changes.
 */
// PORTING NOTE: Android and iOS only return the documents affected by the
// change.
function kr(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r, i, o;
        return g(this, (function(u) {
            switch (u.label) {
              case 0:
                return n = D(t), r = n.Ho, i = n.Ic, [ 4 /*yield*/ , n.persistence.runTransaction("Handle user change", "readonly", (function(t) {
                    // Swap out the mutation queue, grabbing the pending mutation batches
                    // before and after.
                    var o;
                    return n.Ho.bi(t).next((function(u) {
                        return o = u, r = n.persistence.Ko(e), 
                        // Recreate our LocalDocumentsView using the new
                        // MutationQueue.
                        i = new Nr(n.Tc, r, n.persistence.Wo()), r.bi(t);
                    })).next((function(e) {
                        for (var n = [], r = [], u = gn(), s = 0, a = o
                        // Union the old/new changed keys.
                        ; s < a.length; s++) {
                            var c = a[s];
                            n.push(c.batchId);
                            for (var f = 0, h = c.mutations; f < h.length; f++) {
                                var l = h[f];
                                u = u.add(l.key);
                            }
                        }
                        for (var p = 0, d = e; p < d.length; p++) {
                            var v = d[p];
                            r.push(v.batchId);
                            for (var y = 0, g = v.mutations; y < g.length; y++) {
                                var m = g[y];
                                u = u.add(m.key);
                            }
                        }
                        // Return the set of all (potentially) changed documents and the list
                        // of mutation batch IDs that were affected by change.
                                                return i.Zo(t, u).next((function(t) {
                            return {
                                mc: t,
                                Ac: n,
                                Rc: r
                            };
                        }));
                    }));
                })) ];

              case 1:
                return o = u.sent(), [ 2 /*return*/ , (n.Ho = r, n.Ic = i, n.fc.ac(n.Ic), o) ];
            }
        }));
    }));
}

/* Accepts locally generated Mutations and commit them to storage. */
/**
 * Acknowledges the given batch.
 *
 * On the happy path when a batch is acknowledged, the local store will
 *
 *  + remove the batch from the mutation queue;
 *  + apply the changes to the remote document cache;
 *  + recalculate the latency compensated view implied by those changes (there
 *    may be mutations in the queue that affect the documents but haven't been
 *    acknowledged yet); and
 *  + give the changed documents back the sync engine
 *
 * @returns The resulting (modified) documents.
 */ function Or(t, e) {
    var n = D(t);
    return n.persistence.runTransaction("Acknowledge batch", "readwrite-primary", (function(t) {
        var r = e.batch.keys(), i = n.Tc.Fr({
            jr: !0
        });
        return function(t, e, n, r) {
            var i = n.batch, o = i.keys(), u = cr.resolve();
            return o.forEach((function(t) {
                u = u.next((function() {
                    return r.fi(e, t);
                })).next((function(e) {
                    var o = e, u = n.Os.get(t);
                    S(null !== u), (!o || o.version.u(u) < 0) && ((o = i.Ds(t, o, n)) && 
                    // We use the commitVersion as the readTime rather than the
                    // document's updateTime since the updateTime is not advanced
                    // for updates that do not modify the underlying document.
                    r.ui(o, n.Fs));
                }));
            })), u.next((function() {
                return t.Ho.xi(e, i);
            }));
        }(n, t, e, i).next((function() {
            return i.apply(t);
        })).next((function() {
            return n.Ho.Oi(t);
        })).next((function() {
            return n.Ic.Zo(t, r);
        }));
    }));
}

/**
 * Removes mutations from the MutationQueue for the specified batch;
 * LocalDocuments will be recalculated.
 *
 * @returns The resulting modified documents.
 */
/**
 * Returns the last consistent snapshot processed (used by the RemoteStore to
 * determine whether to buffer incoming snapshots from the backend).
 */ function Cr(t) {
    var e = D(t);
    return e.persistence.runTransaction("Get last remote snapshot version", "readonly", (function(t) {
        return e.fo.Ki(t);
    }));
}

/**
 * Updates the "ground-state" (remote) documents. We assume that the remote
 * event reflects any write batches that have been acknowledged or rejected
 * (i.e. we do not re-apply local mutations to updates from this event).
 *
 * LocalDocuments are re-calculated if there are remaining mutations in the
 * queue.
 */ function Lr(t, e) {
    var n = D(t), r = e.Mt, i = n.dc;
    return n.persistence.runTransaction("Apply remote event", "readwrite-primary", (function(t) {
        var o = n.Tc.Fr({
            jr: !0
        });
        // Reset newTargetDataByTargetMap in case this transaction gets re-run.
                i = n.dc;
        var u = [];
        e.Oe.forEach((function(e, o) {
            var s = i.get(o);
            if (s) {
                // Only update the remote keys if the target is still active. This
                // ensures that we can persist the updated target data along with
                // the updated assignment.
                u.push(n.fo.ir(t, e.Ke, o).next((function() {
                    return n.fo.nr(t, e.Ue, o);
                })));
                var a = e.resumeToken;
                // Update the resume token if the change includes one.
                                if (a.o() > 0) {
                    var c = s.$t(a, r).Lt(t.vs);
                    i = i.Ht(o, c), 
                    // Update the target data if there are target changes (or if
                    // sufficient time has passed since the last update).
                    /**
     * Returns true if the newTargetData should be persisted during an update of
     * an active target. TargetData should always be persisted when a target is
     * being released and should not call this function.
     *
     * While the target is active, TargetData updates can be omitted when nothing
     * about the target has changed except metadata like the resume token or
     * snapshot version. Occasionally it's worth the extra write to prevent these
     * values from getting too stale after a crash, but this doesn't have to be
     * too frequent.
     */
                    function(t, e, n) {
                        // Always persist target data if we don't already have a resume token.
                        return S(e.resumeToken.o() > 0), 0 === t.resumeToken.o() || (
                        // Don't allow resume token changes to be buffered indefinitely. This
                        // allows us to be reasonably up-to-date after a crash and avoids needing
                        // to loop over all active queries on shutdown. Especially in the browser
                        // we may not get time to do anything interesting while the current tab is
                        // closing.
                        e.Mt.j() - t.Mt.j() >= 3e8 || n.Ue.size + n.Qe.size + n.Ke.size > 0);
                    }(s, c, e) && u.push(n.fo.Ji(t, c));
                }
            }
        }));
        var s = fn();
        // HACK: The only reason we allow a null snapshot version is so that we
        // can synthesize remote events when we get permission denied errors while
        // trying to resolve the state of a locally cached document that is in
        // limbo.
                if (e.Me.forEach((function(r, i) {
            e.Le.has(r) && u.push(n.persistence.Ii.kr(t, r));
        })), 
        // Each loop iteration only affects its "own" doc, so it's safe to get all the remote
        // documents in advance in a single call.
        u.push(Vr(t, o, e.Me, r, void 0).next((function(t) {
            s = t;
        }))), !r.isEqual(X.min())) {
            var a = n.fo.Ki(t).next((function(e) {
                return n.fo.ji(t, t.vs, r);
            }));
            u.push(a);
        }
        return cr.$n(u).next((function() {
            return o.apply(t);
        })).next((function() {
            return n.Ic.tc(t, s);
        }));
    })).then((function(t) {
        return n.dc = i, t;
    }));
}

/**
 * Populates document change buffer with documents from backend or a bundle.
 * Returns the document changes resulting from applying those documents.
 *
 * @param txn - Transaction to use to read existing documents from storage.
 * @param documentBuffer - Document buffer to collect the resulted changes to be
 *        applied to storage.
 * @param documents - Documents to be applied.
 * @param globalVersion - A `SnapshotVersion` representing the read time if all
 *        documents have the same read time.
 * @param documentVersions - A DocumentKey-to-SnapshotVersion map if documents
 *        have their own read time.
 *
 * Note: this function will use `documentVersions` if it is defined;
 * when it is not defined, resorts to `globalVersion`.
 */ function Vr(t, e, n, r, 
// TODO(wuandy): We could add `readTime` to MaybeDocument instead to remove
// this parameter.
i) {
    var o = gn();
    return n.forEach((function(t) {
        return o = o.add(t);
    })), e.getEntries(t, o).next((function(t) {
        var o = fn();
        return n.forEach((function(n, u) {
            var s = t.get(n), a = (null == i ? void 0 : i.get(n)) || r;
            // Note: The order of the steps below is important, since we want
            // to ensure that rejected limbo resolutions (which fabricate
            // NoDocuments with SnapshotVersion.min()) never add documents to
            // cache.
                        u instanceof Rt && u.version.isEqual(X.min()) ? (
            // NoDocuments with SnapshotVersion.min() are used in manufactured
            // events. We remove these documents from cache since we lost
            // access.
            e._i(n, a), o = o.Ht(n, u)) : null == s || u.version.u(s.version) > 0 || 0 === u.version.u(s.version) && s.hasPendingWrites ? (e.ui(u, a), 
            o = o.Ht(n, u)) : E("LocalStore", "Ignoring outdated watch update for ", n, ". Current version:", s.version, " Watch version:", u.version);
        })), o;
    }))
    /**
 * Gets the mutation batch after the passed in batchId in the mutation queue
 * or null if empty.
 * @param afterBatchId - If provided, the batch to search after.
 * @returns The next mutation or null if there wasn't one.
 */;
}

function Rr(t, e) {
    var n = D(t);
    return n.persistence.runTransaction("Get next mutation batch", "readonly", (function(t) {
        return void 0 === e && (e = -1), n.Ho.Vi(t, e);
    }));
}

/**
 * Reads the current value of a Document with a given key or null if not
 * found - used for testing.
 */
/**
 * Assigns the given target an internal ID so that its results can be pinned so
 * they don't get GC'd. A target must be allocated in the local store before
 * the store can be used to manage its view.
 *
 * Allocating an already allocated `Target` will return the existing `TargetData`
 * for that `Target`.
 */ function Pr(t, e) {
    var n = D(t);
    return n.persistence.runTransaction("Allocate target", "readwrite", (function(t) {
        var r;
        return n.fo.er(t, e).next((function(i) {
            return i ? (
            // This target has been listened to previously, so reuse the
            // previous targetID.
            // TODO(mcg): freshen last accessed date?
            r = i, cr.resolve(r)) : n.fo.qi(t).next((function(i) {
                return r = new me(e, i, 0 /* Listen */ , t.vs), n.fo.Gi(t, r).next((function() {
                    return r;
                }));
            }));
        }));
    })).then((function(t) {
        // If Multi-Tab is enabled, the existing target data may be newer than
        // the in-memory data
        var r = n.dc.get(t.targetId);
        return (null === r || t.Mt.u(r.Mt) > 0) && (n.dc = n.dc.Ht(t.targetId, t), n.wc.set(e, t.targetId)), 
        t;
    }));
}

/**
 * Returns the TargetData as seen by the LocalStore, including updates that may
 * have not yet been persisted to the TargetCache.
 */
// Visible for testing.
/**
 * Unpins all the documents associated with the given target. If
 * `keepPersistedTargetData` is set to false and Eager GC enabled, the method
 * directly removes the associated target data from the target cache.
 *
 * Releasing a non-existing `Target` is a no-op.
 */
// PORTING NOTE: `keepPersistedTargetData` is multi-tab only.
function Ur(t, e, n) {
    return y(this, void 0, void 0, (function() {
        var r, i, o, u;
        return g(this, (function(s) {
            switch (s.label) {
              case 0:
                r = D(t), i = r.dc.get(e), o = n ? "readwrite" : "readwrite-primary", s.label = 1;

              case 1:
                return s.trys.push([ 1, 4, , 5 ]), n ? [ 3 /*break*/ , 3 ] : [ 4 /*yield*/ , r.persistence.runTransaction("Release target", o, (function(t) {
                    return r.persistence.Ii.removeTarget(t, i);
                })) ];

              case 2:
                s.sent(), s.label = 3;

              case 3:
                return [ 3 /*break*/ , 5 ];

              case 4:
                if (!fr(u = s.sent())) throw u;
                // All `releaseTarget` does is record the final metadata state for the
                // target, but we've been recording this periodically during target
                // activity. If we lose this write this could cause a very slight
                // difference in the order of target deletion during GC, but we
                // don't define exact LRU semantics so this is acceptable.
                                return E("LocalStore", "Failed to update sequence numbers for target " + e + ": " + u), 
                [ 3 /*break*/ , 5 ];

              case 5:
                return r.dc = r.dc.remove(e), r.wc.delete(i.target), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Runs the specified query against the local store and returns the results,
 * potentially taking advantage of query data from previous executions (such
 * as the set of remote keys).
 *
 * @param usePreviousResults - Whether results from previous executions can
 * be used to optimize this query execution.
 */ function xr(t, e, n) {
    var r = D(t), i = X.min(), o = gn();
    return r.persistence.runTransaction("Execute query", "readonly", (function(t) {
        return function(t, e, n) {
            var r = D(t), i = r.wc.get(n);
            return void 0 !== i ? cr.resolve(r.dc.get(i)) : r.fo.er(e, n);
        }(r, t, fe(e)).next((function(e) {
            if (e) return i = e.lastLimboFreeSnapshotVersion, r.fo.cr(t, e.targetId).next((function(t) {
                o = t;
            }));
        })).next((function() {
            return r.fc.Wr(t, e, n ? i : X.min(), n ? o : gn());
        })).next((function(t) {
            return {
                documents: t,
                Pc: o
            };
        }));
    }));
}

/**
 * Creates a new target using the given bundle name, which will be used to
 * hold the keys of all documents from the bundle in query-document mappings.
 * This ensures that the loaded documents do not get garbage collected
 * right away.
 */
/**
 * Applies the documents from a bundle to the "ground-state" (remote)
 * documents.
 *
 * LocalDocuments are re-calculated if there are remaining mutations in the
 * queue.
 */ function qr(t, e, n, r) {
    return y(this, void 0, void 0, (function() {
        var i, o, u, s, a, c, f, h, l, p;
        return g(this, (function(d) {
            switch (d.label) {
              case 0:
                for (i = D(t), o = gn(), u = fn(), s = vn(), a = 0, c = n; a < c.length; a++) f = c[a], 
                h = e.yc(f.metadata.name), f.document && (o = o.add(h)), u = u.Ht(h, e.gc(f)), s = s.Ht(h, e.Vc(f.metadata.readTime));
                return l = i.Tc.Fr({
                    jr: !0
                }), [ 4 /*yield*/ , Pr(i, function(t) {
                    // It is OK that the path used for the query is not valid, because this will
                    // not be read and queried.
                    return fe(re($.ct("__bundle__/docs/" + t)));
                }(r)) ];

              case 1:
                // Allocates a target to hold all document keys from the bundle, such that
                // they will not get garbage collected right away.
                return p = d.sent(), [ 2 /*return*/ , i.persistence.runTransaction("Apply bundle documents", "readwrite", (function(t) {
                    return Vr(t, l, u, X.min(), s).next((function(e) {
                        return l.apply(t), e;
                    })).next((function(e) {
                        return i.fo.Xi(t, p.targetId).next((function() {
                            return i.fo.nr(t, o, p.targetId);
                        })).next((function() {
                            return i.Ic.tc(t, e);
                        }));
                    }));
                })) ];
            }
        }));
    }));
}

/**
 * Returns a promise of a boolean to indicate if the given bundle has already
 * been loaded and the create time is newer than the current loading bundle.
 */
/**
 * Saves the given `NamedQuery` to local persistence.
 */ function Mr(t, e, n) {
    return void 0 === n && (n = gn()), y(this, void 0, void 0, (function() {
        var r, i;
        return g(this, (function(o) {
            switch (o.label) {
              case 0:
                return [ 4 /*yield*/ , Pr(t, fe(gr(e.bundledQuery))) ];

              case 1:
                return r = o.sent(), [ 2 /*return*/ , (i = D(t)).persistence.runTransaction("Save named query", "readwrite", (function(t) {
                    var o = qn(e.readTime);
                    // Simply save the query itself if it is older than what the SDK already
                    // has.
                                        if (r.Mt.u(o) >= 0) return i.Eo.Bs(t, e);
                    // Update existing target data because the query from the bundle is newer.
                                        var u = r.$t(V.h, o);
                    return i.dc = i.dc.Ht(u.targetId, u), i.fo.Ji(t, u).next((function() {
                        return i.fo.Xi(t, r.targetId);
                    })).next((function() {
                        return i.fo.nr(t, n, r.targetId);
                    })).next((function() {
                        return i.Eo.Bs(t, e);
                    }));
                })) ];
            }
        }));
    }));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var Fr = /** @class */ function() {
    function t(t) {
        this.Kt = t, this.bc = new Map, this.vc = new Map;
    }
    return t.prototype.Ms = function(t, e) {
        return cr.resolve(this.bc.get(e));
    }, t.prototype.Ls = function(t, e) {
        /** Decodes a BundleMetadata proto into a BundleMetadata object. */
        var n;
        return this.bc.set(e.id, {
            id: (n = e).id,
            version: n.version,
            createTime: qn(n.createTime)
        }), cr.resolve();
    }, t.prototype.$s = function(t, e) {
        return cr.resolve(this.vc.get(e));
    }, t.prototype.Bs = function(t, e) {
        return this.vc.set(e.name, function(t) {
            return {
                name: t.name,
                query: gr(t.bundledQuery),
                readTime: qn(t.readTime)
            };
        }(e)), cr.resolve();
    }, t;
}(), jr = /** @class */ function() {
    function t() {
        // A set of outstanding references to a document sorted by key.
        this.Sc = new sn(zr.Dc), 
        // A set of outstanding references to a document sorted by target id.
        this.Cc = new sn(zr.xc)
        /** Returns true if the reference set contains no references. */;
    }
    return t.prototype.nt = function() {
        return this.Sc.nt();
    }, 
    /** Adds a reference to the given document key for the given ID. */ t.prototype.sr = function(t, e) {
        var n = new zr(t, e);
        this.Sc = this.Sc.add(n), this.Cc = this.Cc.add(n);
    }, 
    /** Add references to the given document keys for the given ID. */ t.prototype.Nc = function(t, e) {
        var n = this;
        t.forEach((function(t) {
            return n.sr(t, e);
        }));
    }, 
    /**
     * Removes a reference to the given document key for the given
     * ID.
     */
    t.prototype.rr = function(t, e) {
        this.Fc(new zr(t, e));
    }, t.prototype.Oc = function(t, e) {
        var n = this;
        t.forEach((function(t) {
            return n.rr(t, e);
        }));
    }, 
    /**
     * Clears all references with a given ID. Calls removeRef() for each key
     * removed.
     */
    t.prototype.kc = function(t) {
        var e = this, n = new nt(new $([])), r = new zr(n, t), i = new zr(n, t + 1), o = [];
        return this.Cc.Ae([ r, i ], (function(t) {
            e.Fc(t), o.push(t.key);
        })), o;
    }, t.prototype.Mc = function() {
        var t = this;
        this.Sc.forEach((function(e) {
            return t.Fc(e);
        }));
    }, t.prototype.Fc = function(t) {
        this.Sc = this.Sc.delete(t), this.Cc = this.Cc.delete(t);
    }, t.prototype.Lc = function(t) {
        var e = new nt(new $([])), n = new zr(e, t), r = new zr(e, t + 1), i = gn();
        return this.Cc.Ae([ n, r ], (function(t) {
            i = i.add(t.key);
        })), i;
    }, t.prototype.ki = function(t) {
        var e = new zr(t, 0), n = this.Sc.Pe(e);
        return null !== n && t.isEqual(n.key);
    }, t;
}(), zr = /** @class */ function() {
    function t(t, e) {
        this.key = t, this.$c = e
        /** Compare by key then by ID */;
    }
    return t.Dc = function(t, e) {
        return nt.J(t.key, e.key) || C(t.$c, e.$c);
    }, 
    /** Compare by ID then by key */ t.xc = function(t, e) {
        return C(t.$c, e.$c) || nt.J(t.key, e.key);
    }, t;
}(), Gr = /** @class */ function() {
    function t(t, e) {
        this.Ti = t, this.Ii = e, 
        /**
             * The set of all mutations that have been sent but not yet been applied to
             * the backend.
             */
        this.Ho = [], 
        /** Next value to use when assigning sequential IDs to each mutation batch. */
        this.Bc = 1, 
        /** An ordered mapping between documents and the mutations batch IDs. */
        this.qc = new sn(zr.Dc);
    }
    return t.prototype.Ri = function(t) {
        return cr.resolve(0 === this.Ho.length);
    }, t.prototype.Pi = function(t, e, n, r) {
        var i = this.Bc;
        this.Bc++, this.Ho.length > 0 && this.Ho[this.Ho.length - 1];
        var o = new dr(i, e, n, r);
        this.Ho.push(o);
        // Track references by document key and index collection parents.
        for (var u = 0, s = r; u < s.length; u++) {
            var a = s[u];
            this.qc = this.qc.add(new zr(a.key, i)), this.Ti.Us(t, a.key.path.Z());
        }
        return cr.resolve(o);
    }, t.prototype.yi = function(t, e) {
        return cr.resolve(this.Uc(e));
    }, t.prototype.Vi = function(t, e) {
        var n = e + 1, r = this.Qc(n), i = r < 0 ? 0 : r;
        // The requested batchId may still be out of range so normalize it to the
        // start of the queue.
                return cr.resolve(this.Ho.length > i ? this.Ho[i] : null);
    }, t.prototype.pi = function() {
        return cr.resolve(0 === this.Ho.length ? -1 : this.Bc - 1);
    }, t.prototype.bi = function(t) {
        return cr.resolve(this.Ho.slice());
    }, t.prototype.vi = function(t, e) {
        var n = this, r = new zr(e, 0), i = new zr(e, Number.POSITIVE_INFINITY), o = [];
        return this.qc.Ae([ r, i ], (function(t) {
            var e = n.Uc(t.$c);
            o.push(e);
        })), cr.resolve(o);
    }, t.prototype.Si = function(t, e) {
        var n = this, r = new sn(C);
        return e.forEach((function(t) {
            var e = new zr(t, 0), i = new zr(t, Number.POSITIVE_INFINITY);
            n.qc.Ae([ e, i ], (function(t) {
                r = r.add(t.$c);
            }));
        })), cr.resolve(this.Kc(r));
    }, t.prototype.Ci = function(t, e) {
        // Use the query path as a prefix for testing if a document matches the
        // query.
        var n = e.path, r = n.length + 1, i = n;
        // Construct a document reference for actually scanning the index. Unlike
        // the prefix the document key in this reference must have an even number of
        // segments. The empty segment can be used a suffix of the query path
        // because it precedes all other segments in an ordered traversal.
                nt.Et(i) || (i = i.child(""));
        var o = new zr(new nt(i), 0), u = new sn(C);
        // Find unique batchIDs referenced by all documents potentially matching the
        // query.
                return this.qc.Re((function(t) {
            var e = t.key.path;
            return !!n.st(e) && (
            // Rows with document keys more than one segment longer than the query
            // path can't be matches. For example, a query on 'rooms' can't match
            // the document /rooms/abc/messages/xyx.
            // TODO(mcg): we'll need a different scanner when we implement
            // ancestor queries.
            e.length === r && (u = u.add(t.$c)), !0);
        }), o), cr.resolve(this.Kc(u));
    }, t.prototype.Kc = function(t) {
        var e = this, n = [];
        // Construct an array of matching batches, sorted by batchID to ensure that
        // multiple mutations affecting the same document key are applied in order.
                return t.forEach((function(t) {
            var r = e.Uc(t);
            null !== r && n.push(r);
        })), n;
    }, t.prototype.xi = function(t, e) {
        var n = this;
        S(0 === this.Wc(e.batchId, "removed")), this.Ho.shift();
        var r = this.qc;
        return cr.forEach(e.mutations, (function(i) {
            var o = new zr(i.key, e.batchId);
            return r = r.delete(o), n.Ii.Fi(t, i.key);
        })).next((function() {
            n.qc = r;
        }));
    }, t.prototype.Ni = function(t) {
        // No-op since the memory mutation queue does not maintain a separate cache.
    }, t.prototype.ki = function(t, e) {
        var n = new zr(e, 0), r = this.qc.Pe(n);
        return cr.resolve(e.isEqual(r && r.key));
    }, t.prototype.Oi = function(t) {
        return this.Ho.length, cr.resolve();
    }, 
    /**
     * Finds the index of the given batchId in the mutation queue and asserts that
     * the resulting index is within the bounds of the queue.
     *
     * @param batchId - The batchId to search for
     * @param action - A description of what the caller is doing, phrased in passive
     * form (e.g. "acknowledged" in a routine that acknowledges batches).
     */
    t.prototype.Wc = function(t, e) {
        return this.Qc(t);
    }, 
    /**
     * Finds the index of the given batchId in the mutation queue. This operation
     * is O(1).
     *
     * @returns The computed index of the batch with the given batchId, based on
     * the state of the queue. Note this index can be negative if the requested
     * batchId has already been remvoed from the queue or past the end of the
     * queue if the batchId is larger than the last added batch.
     */
    t.prototype.Qc = function(t) {
        return 0 === this.Ho.length ? 0 : t - this.Ho[0].batchId;
        // Examine the front of the queue to figure out the difference between the
        // batchId and indexes in the array. Note that since the queue is ordered
        // by batchId, if the first batch has a larger batchId then the requested
        // batchId doesn't exist in the queue.
        }, 
    /**
     * A version of lookupMutationBatch that doesn't return a promise, this makes
     * other functions that uses this code easier to read and more efficent.
     */
    t.prototype.Uc = function(t) {
        var e = this.Qc(t);
        return e < 0 || e >= this.Ho.length ? null : this.Ho[e];
    }, t;
}(), Hr = /** @class */ function() {
    /**
     * @param sizer - Used to assess the size of a document. For eager GC, this is
     * expected to just return 0 to avoid unnecessarily doing the work of
     * calculating the size.
     */
    function t(t, e) {
        this.Ti = t, this.jc = e, 
        /** Underlying cache of documents and their read times. */
        this.docs = new rn(nt.J), 
        /** Size of all cached documents. */
        this.size = 0
        /**
     * Adds the supplied entry to the cache and updates the cache size as appropriate.
     *
     * All calls of `addEntry`  are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */;
    }
    return t.prototype.ui = function(t, e, n) {
        var r = e.key, i = this.docs.get(r), o = i ? i.size : 0, u = this.jc(e);
        return this.docs = this.docs.Ht(r, {
            li: e,
            size: u,
            readTime: n
        }), this.size += u - o, this.Ti.Us(t, r.path.Z());
    }, 
    /**
     * Removes the specified entry from the cache and updates the cache size as appropriate.
     *
     * All calls of `removeEntry` are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */
    t.prototype._i = function(t) {
        var e = this.docs.get(t);
        e && (this.docs = this.docs.remove(t), this.size -= e.size);
    }, t.prototype.fi = function(t, e) {
        var n = this.docs.get(e);
        return cr.resolve(n ? n.li : null);
    }, t.prototype.getEntries = function(t, e) {
        var n = this, r = hn();
        return e.forEach((function(t) {
            var e = n.docs.get(t);
            r = r.Ht(t, e ? e.li : null);
        })), cr.resolve(r);
    }, t.prototype.Wr = function(t, e, n) {
        for (var r = pn(), i = new nt(e.path.child("")), o = this.docs.ne(i)
        // Documents are ordered by key, so we can use a prefix scan to narrow down
        // the documents we need to match the query against.
        ; o.ae(); ) {
            var u = o.ce(), s = u.key, a = u.value, c = a.li, f = a.readTime;
            if (!e.path.st(s.path)) break;
            f.u(n) <= 0 || c instanceof Vt && ve(e, c) && (r = r.Ht(c.key, c));
        }
        return cr.resolve(r);
    }, t.prototype.Gc = function(t, e) {
        return cr.forEach(this.docs, (function(t) {
            return e(t);
        }));
    }, t.prototype.Fr = function(t) {
        // `trackRemovals` is ignores since the MemoryRemoteDocumentCache keeps
        // a separate changelog and does not need special handling for removals.
        return new Br(this);
    }, t.prototype.Mr = function(t) {
        return cr.resolve(this.size);
    }, t;
}(), Br = /** @class */ function(t) {
    function e(e) {
        var n = this;
        return (n = t.call(this) || this).Gr = e, n;
    }
    return w(e, t), e.prototype.Ei = function(t) {
        var e = this, n = [];
        return this.oi.forEach((function(r, i) {
            i && i.li ? n.push(e.Gr.ui(t, i.li, e.ai(r))) : e.Gr._i(r);
        })), cr.$n(n);
    }, e.prototype.di = function(t, e) {
        return this.Gr.fi(t, e);
    }, e.prototype.wi = function(t, e) {
        return this.Gr.getEntries(t, e);
    }, e;
}(Er), Kr = /** @class */ function() {
    function t(t) {
        this.persistence = t, 
        /**
             * Maps a target to the data about that target
             */
        this.zc = new _r((function(t) {
            return qt(t);
        }), Mt), 
        /** The last received snapshot version. */
        this.lastRemoteSnapshotVersion = X.min(), 
        /** The highest numbered target ID encountered. */
        this.highestTargetId = 0, 
        /** The highest sequence number encountered. */
        this.Hc = 0, 
        /**
             * A ordered bidirectional mapping between documents and the remote target
             * IDs.
             */
        this.Jc = new jr, this.targetCount = 0, this.Yc = Ir.$i();
    }
    return t.prototype.mn = function(t, e) {
        return this.zc.forEach((function(t, n) {
            return e(n);
        })), cr.resolve();
    }, t.prototype.Ki = function(t) {
        return cr.resolve(this.lastRemoteSnapshotVersion);
    }, t.prototype.Wi = function(t) {
        return cr.resolve(this.Hc);
    }, t.prototype.qi = function(t) {
        return this.highestTargetId = this.Yc.next(), cr.resolve(this.highestTargetId);
    }, t.prototype.ji = function(t, e, n) {
        return n && (this.lastRemoteSnapshotVersion = n), e > this.Hc && (this.Hc = e), 
        cr.resolve();
    }, t.prototype.zi = function(t) {
        this.zc.set(t.target, t);
        var e = t.targetId;
        e > this.highestTargetId && (this.Yc = new Ir(e), this.highestTargetId = e), t.sequenceNumber > this.Hc && (this.Hc = t.sequenceNumber);
    }, t.prototype.Gi = function(t, e) {
        return this.zi(e), this.targetCount += 1, cr.resolve();
    }, t.prototype.Ji = function(t, e) {
        return this.zi(e), cr.resolve();
    }, t.prototype.Yi = function(t, e) {
        return this.zc.delete(e.target), this.Jc.kc(e.targetId), this.targetCount -= 1, 
        cr.resolve();
    }, t.prototype.Zi = function(t, e, n) {
        var r = this, i = 0, o = [];
        return this.zc.forEach((function(u, s) {
            s.sequenceNumber <= e && null === n.get(s.targetId) && (r.zc.delete(u), o.push(r.Xi(t, s.targetId)), 
            i++);
        })), cr.$n(o).next((function() {
            return i;
        }));
    }, t.prototype.tr = function(t) {
        return cr.resolve(this.targetCount);
    }, t.prototype.er = function(t, e) {
        var n = this.zc.get(e) || null;
        return cr.resolve(n);
    }, t.prototype.nr = function(t, e, n) {
        return this.Jc.Nc(e, n), cr.resolve();
    }, t.prototype.ir = function(t, e, n) {
        this.Jc.Oc(e, n);
        var r = this.persistence.Ii, i = [];
        return r && e.forEach((function(e) {
            i.push(r.Fi(t, e));
        })), cr.$n(i);
    }, t.prototype.Xi = function(t, e) {
        return this.Jc.kc(e), cr.resolve();
    }, t.prototype.cr = function(t, e) {
        var n = this.Jc.Lc(e);
        return cr.resolve(n);
    }, t.prototype.ki = function(t, e) {
        return cr.resolve(this.Jc.ki(e));
    }, t;
}(), Jr = /** @class */ function() {
    /**
     * The constructor accepts a factory for creating a reference delegate. This
     * allows both the delegate and this instance to have strong references to
     * each other without having nullable fields that would then need to be
     * checked or asserted on every access.
     */
    function t(t, e) {
        var n = this;
        this.Xc = {}, this.io = new Q(0), this.ro = !1, this.ro = !0, this.Ii = t(this), 
        this.fo = new Kr(this), this.Ti = new mr, this.wo = function(t, e) {
            return new Hr(t, (function(t) {
                return n.Ii.Zc(t);
            }));
        }(this.Ti), this.Kt = new yr(e), this.Eo = new Fr(this.Kt);
    }
    return t.prototype.start = function() {
        return Promise.resolve();
    }, t.prototype.Lo = function() {
        // No durable state to ensure is closed on shutdown.
        return this.ro = !1, Promise.resolve();
    }, Object.defineProperty(t.prototype, "Tr", {
        get: function() {
            return this.ro;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.yo = function() {
        // No op.
    }, t.prototype.Vo = function() {
        // No op.
    }, t.prototype.Wo = function() {
        return this.Ti;
    }, t.prototype.Ko = function(t) {
        var e = this.Xc[t.R()];
        return e || (e = new Gr(this.Ti, this.Ii), this.Xc[t.R()] = e), e;
    }, t.prototype.Dr = function() {
        return this.fo;
    }, t.prototype.Or = function() {
        return this.wo;
    }, t.prototype.jo = function() {
        return this.Eo;
    }, t.prototype.runTransaction = function(t, e, n) {
        var r = this;
        E("MemoryPersistence", "Starting transaction:", t);
        var i = new Wr(this.io.next());
        return this.Ii.ta(), n(i).next((function(t) {
            return r.Ii.ea(i).next((function() {
                return t;
            }));
        })).Mn().then((function(t) {
            return i.ps(), t;
        }));
    }, t.prototype.na = function(t, e) {
        return cr.Bn(Object.values(this.Xc).map((function(n) {
            return function() {
                return n.ki(t, e);
            };
        })));
    }, t;
}(), Wr = /** @class */ function(t) {
    function e(e) {
        var n = this;
        return (n = t.call(this) || this).vs = e, n;
    }
    return w(e, t), e;
}(pr), Qr = /** @class */ function() {
    function t(t) {
        this.persistence = t, 
        /** Tracks all documents that are active in Query views. */
        this.sa = new jr, 
        /** The list of documents that are potentially GCed after each transaction. */
        this.ia = null;
    }
    return t.ra = function(e) {
        return new t(e);
    }, Object.defineProperty(t.prototype, "oa", {
        get: function() {
            if (this.ia) return this.ia;
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.sr = function(t, e, n) {
        return this.sa.sr(n, e), this.oa.delete(n.toString()), cr.resolve();
    }, t.prototype.rr = function(t, e, n) {
        return this.sa.rr(n, e), this.oa.add(n.toString()), cr.resolve();
    }, t.prototype.Fi = function(t, e) {
        return this.oa.add(e.toString()), cr.resolve();
    }, t.prototype.removeTarget = function(t, e) {
        var n = this;
        this.sa.kc(e.targetId).forEach((function(t) {
            return n.oa.add(t.toString());
        }));
        var r = this.persistence.Dr();
        return r.cr(t, e.targetId).next((function(t) {
            t.forEach((function(t) {
                return n.oa.add(t.toString());
            }));
        })).next((function() {
            return r.Yi(t, e);
        }));
    }, t.prototype.ta = function() {
        this.ia = new Set;
    }, t.prototype.ea = function(t) {
        var e = this, n = this.persistence.Or().Fr();
        // Remove newly orphaned documents.
                return cr.forEach(this.oa, (function(r) {
            var i = nt.ft(r);
            return e.ca(t, i).next((function(t) {
                t || n._i(i);
            }));
        })).next((function() {
            return e.ia = null, n.apply(t);
        }));
    }, t.prototype.kr = function(t, e) {
        var n = this;
        return this.ca(t, e).next((function(t) {
            t ? n.oa.delete(e.toString()) : n.oa.add(e.toString());
        }));
    }, t.prototype.Zc = function(t) {
        // For eager GC, we don't care about the document size, there are no size thresholds.
        return 0;
    }, t.prototype.ca = function(t, e) {
        var n = this;
        return cr.Bn([ function() {
            return cr.resolve(n.sa.ki(e));
        }, function() {
            return n.persistence.Dr().ki(t, e);
        }, function() {
            return n.persistence.na(t, e);
        } ]);
    }, t;
}(), Yr = /** @class */ function() {
    function t() {
        this.activeTargetIds = wn();
    }
    return t.prototype.ha = function(t) {
        this.activeTargetIds = this.activeTargetIds.add(t);
    }, t.prototype.la = function(t) {
        this.activeTargetIds = this.activeTargetIds.delete(t);
    }, 
    /**
     * Converts this entry into a JSON-encoded format we can use for WebStorage.
     * Does not encode `clientId` as it is part of the key in WebStorage.
     */
    t.prototype.ua = function() {
        var t = {
            activeTargetIds: this.activeTargetIds.rt(),
            updateTimeMs: Date.now()
        };
        return JSON.stringify(t);
    }, t;
}(), Xr = /** @class */ function() {
    function t() {
        this.ru = new Yr, this.ou = {}, this.da = null, this.L = null;
    }
    return t.prototype.xa = function(t) {
        // No op.
    }, t.prototype.Fa = function(t, e, n) {
        // No op.
    }, t.prototype.ka = function(t) {
        return this.ru.ha(t), this.ou[t] || "not-current";
    }, t.prototype.qa = function(t, e, n) {
        this.ou[t] = e;
    }, t.prototype.La = function(t) {
        this.ru.la(t);
    }, t.prototype.$a = function(t) {
        return this.ru.activeTargetIds.has(t);
    }, t.prototype.Ba = function(t) {
        delete this.ou[t];
    }, t.prototype.Sa = function() {
        return this.ru.activeTargetIds;
    }, t.prototype.Ca = function(t) {
        return this.ru.activeTargetIds.has(t);
    }, t.prototype.start = function() {
        return this.ru = new Yr, Promise.resolve();
    }, t.prototype.Qa = function(t, e, n) {
        // No op.
    }, t.prototype.Ka = function(t) {
        // No op.
    }, t.prototype.Lo = function() {}, t.prototype.q = function(t) {}, t.prototype.ja = function() {
        // No op.
    }, t;
}(), Zr = /** @class */ function() {
    function t() {}
    return t.prototype.cu = function(t) {
        // No-op.
    }, t.prototype.Lo = function() {
        // No-op.
    }, t;
}(), $r = /** @class */ function() {
    function t() {
        var t = this;
        this.au = function() {
            return t.uu();
        }, this.hu = function() {
            return t.lu();
        }, this._u = [], this.fu();
    }
    return t.prototype.cu = function(t) {
        this._u.push(t);
    }, t.prototype.Lo = function() {
        window.removeEventListener("online", this.au), window.removeEventListener("offline", this.hu);
    }, t.prototype.fu = function() {
        window.addEventListener("online", this.au), window.addEventListener("offline", this.hu);
    }, t.prototype.uu = function() {
        E("ConnectivityMonitor", "Network connectivity changed: AVAILABLE");
        for (var t = 0, e = this._u; t < e.length; t++) {
            (0, e[t])(0 /* AVAILABLE */);
        }
    }, t.prototype.lu = function() {
        E("ConnectivityMonitor", "Network connectivity changed: UNAVAILABLE");
        for (var t = 0, e = this._u; t < e.length; t++) {
            (0, e[t])(1 /* UNAVAILABLE */);
        }
    }, 
    // TODO(chenbrian): Consider passing in window either into this component or
    // here for testing via FakeWindow.
    /** Checks that all used attributes of window are available. */
    t.Wn = function() {
        return "undefined" != typeof window && void 0 !== window.addEventListener && void 0 !== window.removeEventListener;
    }, t;
}(), ti = {
    BatchGetDocuments: "batchGet",
    Commit: "commit",
    RunQuery: "runQuery"
}, ei = /** @class */ function() {
    function t(t) {
        this.du = t.du, this.wu = t.wu;
    }
    return t.prototype.Eu = function(t) {
        this.Tu = t;
    }, t.prototype.Iu = function(t) {
        this.mu = t;
    }, t.prototype.onMessage = function(t) {
        this.Au = t;
    }, t.prototype.close = function() {
        this.wu();
    }, t.prototype.send = function(t) {
        this.du(t);
    }, t.prototype.Ru = function() {
        this.Tu();
    }, t.prototype.Pu = function(t) {
        this.mu(t);
    }, t.prototype.yu = function(t) {
        this.Au(t);
    }, t;
}(), ni = /** @class */ function(t) {
    function e(e) {
        var n = this;
        return (n = t.call(this, e) || this).forceLongPolling = e.forceLongPolling, n.I = e.I, 
        n;
    }
    /**
     * Base class for all Rest-based connections to the backend (WebChannel and
     * HTTP).
     */
    return w(e, t), e.prototype.Du = function(t, e, n, r) {
        return new Promise((function(i, o) {
            var u = new a;
            u.listenOnce(c.COMPLETE, (function() {
                try {
                    switch (u.getLastErrorCode()) {
                      case f.NO_ERROR:
                        var e = u.getResponseJson();
                        E("Connection", "XHR received:", JSON.stringify(e)), i(e);
                        break;

                      case f.TIMEOUT:
                        E("Connection", 'RPC "' + t + '" timed out'), o(new P(R.DEADLINE_EXCEEDED, "Request time out"));
                        break;

                      case f.HTTP_ERROR:
                        var n = u.getStatus();
                        if (E("Connection", 'RPC "' + t + '" failed with status:', n, "response text:", u.getResponseText()), 
                        n > 0) {
                            var r = u.getResponseJson().error;
                            if (r && r.status && r.message) {
                                var s = function(t) {
                                    var e = t.toLowerCase().replace(/_/g, "-");
                                    return Object.values(R).indexOf(e) >= 0 ? e : R.UNKNOWN;
                                }(r.status);
                                o(new P(s, r.message));
                            } else o(new P(R.UNKNOWN, "Server responded with status " + u.getStatus()));
                        } else 
                        // If we received an HTTP_ERROR but there's no status code,
                        // it's most probably a connection issue
                        o(new P(R.UNAVAILABLE, "Connection failed."));
                        break;

                      default:
                        A();
                    }
                } finally {
                    E("Connection", 'RPC "' + t + '" completed.');
                }
            }));
            var s = JSON.stringify(r);
            u.send(e, "POST", s, n, 15);
        }));
    }, e.prototype.xu = function(t, e) {
        var a = [ this.Vu, "/", "google.firestore.v1.Firestore", "/", t, "/channel" ], c = h(), f = l(), y = {
            // Required for backend stickiness, routing behavior is based on this
            // parameter.
            httpSessionIdParam: "gsessionid",
            initMessageHeaders: {},
            messageUrlParams: {
                // This param is used to improve routing and project isolation by the
                // backend and must be included in every request.
                database: "projects/" + this.T.projectId + "/databases/" + this.T.database
            },
            sendRawJson: !0,
            supportsCrossDomainXhr: !0,
            internalChannelParams: {
                // Override the default timeout (randomized between 10-20 seconds) since
                // a large write batch on a slow internet connection may take a long
                // time to send to the backend. Rather than have WebChannel impose a
                // tight timeout which could lead to infinite timeouts and retries, we
                // set it very large (5-10 minutes) and rely on the browser's builtin
                // timeouts to kick in if the request isn't working.
                forwardChannelRequestTimeoutMs: 6e5
            },
            forceLongPolling: this.forceLongPolling,
            detectBufferingProxy: this.I
        };
        this.Su(y.initMessageHeaders, e), 
        // Sending the custom headers we just added to request.initMessageHeaders
        // (Authorization, etc.) will trigger the browser to make a CORS preflight
        // request because the XHR will no longer meet the criteria for a "simple"
        // CORS request:
        // https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Simple_requests
        // Therefore to avoid the CORS preflight request (an extra network
        // roundtrip), we use the httpHeadersOverwriteParam option to specify that
        // the headers should instead be encoded into a special "$httpHeaders" query
        // parameter, which is recognized by the webchannel backend. This is
        // formally defined here:
        // https://github.com/google/closure-library/blob/b0e1815b13fb92a46d7c9b3c30de5d6a396a3245/closure/goog/net/rpc/httpcors.js#L32
        // TODO(b/145624756): There is a backend bug where $httpHeaders isn't respected if the request
        // doesn't have an Origin header. So we have to exclude a few browser environments that are
        // known to (sometimes) not include an Origin. See
        // https://github.com/firebase/firebase-js-sdk/issues/1491.
        n() || r() || i() || o() || u() || s() || (y.httpHeadersOverwriteParam = "$httpHeaders");
        var g = a.join("");
        E("Connection", "Creating WebChannel: " + g, y);
        var m = c.createWebChannel(g, y), w = !1, b = !1, _ = new ei({
            du: function(t) {
                b ? E("Connection", "Not sending because WebChannel is closed:", t) : (w || (E("Connection", "Opening WebChannel transport."), 
                m.open(), w = !0), E("Connection", "WebChannel sending:", t), m.send(t));
            },
            wu: function() {
                return m.close();
            }
        }), I = function(t, e, n) {
            // TODO(dimond): closure typing seems broken because WebChannel does
            // not implement goog.events.Listenable
            t.listen(e, (function(t) {
                try {
                    n(t);
                } catch (t) {
                    setTimeout((function() {
                        throw t;
                    }), 0);
                }
            }));
        };
        // WebChannel supports sending the first message with the handshake - saving
        // a network round trip. However, it will have to call send in the same
        // JS event loop as open. In order to enforce this, we delay actually
        // opening the WebChannel until send is called. Whether we have called
        // open is tracked with this variable.
                // Closure events are guarded and exceptions are swallowed, so catch any
        // exception and rethrow using a setTimeout so they become visible again.
        // Note that eventually this function could go away if we are confident
        // enough the code is exception free.
        return I(m, p.EventType.OPEN, (function() {
            b || E("Connection", "WebChannel transport opened.");
        })), I(m, p.EventType.CLOSE, (function() {
            b || (b = !0, E("Connection", "WebChannel transport closed"), _.Pu());
        })), I(m, p.EventType.ERROR, (function(t) {
            b || (b = !0, T("Connection", "WebChannel transport errored:", t), _.Pu(new P(R.UNAVAILABLE, "The operation could not be completed")));
        })), I(m, p.EventType.MESSAGE, (function(t) {
            var e;
            if (!b) {
                var n = t.data[0];
                S(!!n);
                // TODO(b/35143891): There is a bug in One Platform that caused errors
                // (and only errors) to be wrapped in an extra array. To be forward
                // compatible with the bug we need to check either condition. The latter
                // can be removed once the fix has been rolled out.
                // Use any because msgData.error is not typed.
                var r = n, i = r.error || (null === (e = r[0]) || void 0 === e ? void 0 : e.error);
                if (i) {
                    E("Connection", "WebChannel received error:", i);
                    // error.status will be a string like 'OK' or 'NOT_FOUND'.
                    var o = i.status, u = 
                    /**
 * Maps an error Code from a GRPC status identifier like 'NOT_FOUND'.
 *
 * @returns The Code equivalent to the given status string or undefined if
 *     there is no match.
 */
                    function(t) {
                        // lookup by string
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        var e = Ye[t];
                        if (void 0 !== e) return nn(e);
                    }(o), s = i.message;
                    void 0 === u && (u = R.INTERNAL, s = "Unknown error status: " + o + " with message " + i.message), 
                    // Mark closed so no further events are propagated
                    b = !0, _.Pu(new P(u, s)), m.close();
                } else E("Connection", "WebChannel received:", n), _.yu(n);
            }
        })), I(f, d.STAT_EVENT, (function(t) {
            t.stat === v.PROXY ? E("Connection", "Detected buffering proxy") : t.stat === v.NOPROXY && E("Connection", "Detected no buffering proxy");
        })), setTimeout((function() {
            // Technically we could/should wait for the WebChannel opened event,
            // but because we want to send the first message with the WebChannel
            // handshake we pretend the channel opened here (asynchronously), and
            // then delay the actual open until the first message is sent.
            _.Ru();
        }), 0), _;
    }, e;
}(/** @class */ function() {
    function t(t) {
        this.gu = t, this.T = t.T;
        var e = t.ssl ? "https" : "http";
        this.Vu = e + "://" + t.host, this.pu = "projects/" + this.T.projectId + "/databases/" + this.T.database + "/documents";
    }
    return t.prototype.bu = function(t, e, n, r) {
        var i = this.vu(t, e);
        E("RestConnection", "Sending: ", i, n);
        var o = {};
        return this.Su(o, r), this.Du(t, i, o, n).then((function(t) {
            return E("RestConnection", "Received: ", t), t;
        }), (function(e) {
            throw T("RestConnection", t + " failed with error: ", e, "url: ", i, "request:", n), 
            e;
        }));
    }, t.prototype.Cu = function(t, e, n, r) {
        // The REST API automatically aggregates all of the streamed results, so we
        // can just use the normal invoke() method.
        return this.bu(t, e, n, r);
    }, 
    /**
     * Modifies the headers for a request, adding any authorization token if
     * present and any additional headers for the request.
     */
    t.prototype.Su = function(t, e) {
        if (t["X-Goog-Api-Client"] = "gl-js/ fire/8.2.5", 
        // Content-Type: text/plain will avoid preflight requests which might
        // mess with CORS and redirects by proxies. If we add custom headers
        // we will need to change this code to potentially use the $httpOverwrite
        // parameter supported by ESF to avoid triggering preflight requests.
        t["Content-Type"] = "text/plain", e) for (var n in e.V) e.V.hasOwnProperty(n) && (t[n] = e.V[n]);
    }, t.prototype.vu = function(t, e) {
        var n = ti[t];
        return this.Vu + "/v1/" + e + ":" + n;
    }, t;
}());

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A collection of references to a document from some kind of numbered entity
 * (either a target ID or batch ID). As references are added to or removed from
 * the set corresponding events are emitted to a registered garbage collector.
 *
 * Each reference is represented by a DocumentReference object. Each of them
 * contains enough information to uniquely identify the reference. They are all
 * stored primarily in a set sorted by key. A document is considered garbage if
 * there's no references in that set (this can be efficiently checked thanks to
 * sorting by key).
 *
 * ReferenceSet also keeps a secondary set that contains references sorted by
 * IDs. This one is used to efficiently implement removal of all references by
 * some target ID.
 */
/** The Platform's 'document' implementation or null if not available. */ function ri() {
    // `document` is not always available, e.g. in ReactNative and WebWorkers.
    // eslint-disable-next-line no-restricted-globals
    return "undefined" != typeof document ? document : null;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function ii(t) {
    return new Rn(t, /* useProto3Json= */ !0);
}

/**
 * An instance of the Platform's 'TextEncoder' implementation.
 */
/**
 * A helper for running delayed tasks following an exponential backoff curve
 * between attempts.
 *
 * Each delay is made up of a "base" delay which follows the exponential
 * backoff curve, and a +/- 50% "jitter" that is calculated and added to the
 * base delay. This prevents clients from accidentally synchronizing their
 * delays causing spikes of load to the backend.
 */ var oi = /** @class */ function() {
    function t(
    /**
     * The AsyncQueue to run backoff operations on.
     */
    t, 
    /**
     * The ID to use when scheduling backoff operations on the AsyncQueue.
     */
    e, 
    /**
     * The initial delay (used as the base delay on the first retry attempt).
     * Note that jitter will still be applied, so the actual delay could be as
     * little as 0.5*initialDelayMs.
     */
    n
    /**
     * The multiplier to use to determine the extended base delay after each
     * attempt.
     */ , r
    /**
     * The maximum base delay after which no further backoff is performed.
     * Note that jitter will still be applied, so the actual delay could be as
     * much as 1.5*maxDelayMs.
     */ , i) {
        void 0 === n && (n = 1e3), void 0 === r && (r = 1.5), void 0 === i && (i = 6e4), 
        this.eo = t, this.ds = e, this.Nu = n, this.Fu = r, this.Ou = i, this.ku = 0, this.Mu = null, 
        /** The last backoff attempt, as epoch milliseconds. */
        this.Lu = Date.now(), this.reset();
    }
    /**
     * Resets the backoff delay.
     *
     * The very next backoffAndWait() will have no delay. If it is called again
     * (i.e. due to an error), initialDelayMs (plus jitter) will be used, and
     * subsequent ones will increase according to the backoffFactor.
     */    return t.prototype.reset = function() {
        this.ku = 0;
    }, 
    /**
     * Resets the backoff delay to the maximum delay (e.g. for use after a
     * RESOURCE_EXHAUSTED error).
     */
    t.prototype.$u = function() {
        this.ku = this.Ou;
    }, 
    /**
     * Returns a promise that resolves after currentDelayMs, and increases the
     * delay for any subsequent attempts. If there was a pending backoff operation
     * already, it will be canceled.
     */
    t.prototype.Bu = function(t) {
        var e = this;
        // Cancel any pending backoff operation.
                this.cancel();
        // First schedule using the current base (which may be 0 and should be
        // honored as such).
        var n = Math.floor(this.ku + this.qu()), r = Math.max(0, Date.now() - this.Lu), i = Math.max(0, n - r);
        // Guard against lastAttemptTime being in the future due to a clock change.
                i > 0 && E("ExponentialBackoff", "Backing off for " + i + " ms (base delay: " + this.ku + " ms, delay with jitter: " + n + " ms, last attempt: " + r + " ms ago)"), 
        this.Mu = this.eo.Ir(this.ds, i, (function() {
            return e.Lu = Date.now(), t();
        })), 
        // Apply backoff factor to determine next delay and ensure it is within
        // bounds.
        this.ku *= this.Fu, this.ku < this.Nu && (this.ku = this.Nu), this.ku > this.Ou && (this.ku = this.Ou);
    }, t.prototype.Uu = function() {
        null !== this.Mu && (this.Mu.Ps(), this.Mu = null);
    }, t.prototype.cancel = function() {
        null !== this.Mu && (this.Mu.cancel(), this.Mu = null);
    }, 
    /** Returns a random value in the range [-currentBaseMs/2, currentBaseMs/2] */ t.prototype.qu = function() {
        return (Math.random() - .5) * this.ku;
    }, t;
}(), ui = /** @class */ function() {
    function t(t, e, n, r, i, o) {
        this.eo = t, this.Qu = n, this.Ku = r, this.Wu = i, this.listener = o, this.state = 0 /* Initial */ , 
        /**
             * A close count that's incremented every time the stream is closed; used by
             * getCloseGuardedDispatcher() to invalidate callbacks that happen after
             * close.
             */
        this.ju = 0, this.Gu = null, this.stream = null, this.zu = new oi(t, e)
        /**
     * Returns true if start() has been called and no error has occurred. True
     * indicates the stream is open or in the process of opening (which
     * encompasses respecting backoff, getting auth tokens, and starting the
     * actual RPC). Use isOpen() to determine if the stream is open and ready for
     * outbound requests.
     */;
    }
    return t.prototype.Hu = function() {
        return 1 /* Starting */ === this.state || 2 /* Open */ === this.state || 4 /* Backoff */ === this.state;
    }, 
    /**
     * Returns true if the underlying RPC is open (the onOpen() listener has been
     * called) and the stream is ready for outbound requests.
     */
    t.prototype.Ju = function() {
        return 2 /* Open */ === this.state;
    }, 
    /**
     * Starts the RPC. Only allowed if isStarted() returns false. The stream is
     * not immediately ready for use: onOpen() will be invoked when the RPC is
     * ready for outbound requests, at which point isOpen() will return true.
     *
     * When start returns, isStarted() will return true.
     */
    t.prototype.start = function() {
        3 /* Error */ !== this.state ? this.auth() : this.Yu();
    }, 
    /**
     * Stops the RPC. This call is idempotent and allowed regardless of the
     * current isStarted() state.
     *
     * When stop returns, isStarted() and isOpen() will both return false.
     */
    t.prototype.stop = function() {
        return y(this, void 0, void 0, (function() {
            return g(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.Hu() ? [ 4 /*yield*/ , this.close(0 /* Initial */) ] : [ 3 /*break*/ , 2 ];

                  case 1:
                    t.sent(), t.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * After an error the stream will usually back off on the next attempt to
     * start it. If the error warrants an immediate restart of the stream, the
     * sender can use this to indicate that the receiver should not back off.
     *
     * Each error will call the onClose() listener. That function can decide to
     * inhibit backoff if required.
     */
    t.prototype.Xu = function() {
        this.state = 0 /* Initial */ , this.zu.reset();
    }, 
    /**
     * Marks this stream as idle. If no further actions are performed on the
     * stream for one minute, the stream will automatically close itself and
     * notify the stream's onClose() handler with Status.OK. The stream will then
     * be in a !isStarted() state, requiring the caller to start the stream again
     * before further use.
     *
     * Only streams that are in state 'Open' can be marked idle, as all other
     * states imply pending network operations.
     */
    t.prototype.Zu = function() {
        var t = this;
        // Starts the idle time if we are in state 'Open' and are not yet already
        // running a timer (in which case the previous idle timeout still applies).
                this.Ju() && null === this.Gu && (this.Gu = this.eo.Ir(this.Qu, 6e4, (function() {
            return t.th();
        })));
    }, 
    /** Sends a message to the underlying stream. */ t.prototype.eh = function(t) {
        this.nh(), this.stream.send(t);
    }, 
    /** Called by the idle timer when the stream should close due to inactivity. */ t.prototype.th = function() {
        return y(this, void 0, void 0, (function() {
            return g(this, (function(t) {
                return this.Ju() ? [ 2 /*return*/ , this.close(0 /* Initial */) ] : [ 2 /*return*/ ];
            }));
        }));
    }, 
    /** Marks the stream as active again. */ t.prototype.nh = function() {
        this.Gu && (this.Gu.cancel(), this.Gu = null);
    }, 
    /**
     * Closes the stream and cleans up as necessary:
     *
     * * closes the underlying GRPC stream;
     * * calls the onClose handler with the given 'error';
     * * sets internal stream state to 'finalState';
     * * adjusts the backoff timer based on the error
     *
     * A new stream can be opened by calling start().
     *
     * @param finalState - the intended state of the stream after closing.
     * @param error - the error the connection was closed with.
     */
    t.prototype.close = function(t, e) {
        return y(this, void 0, void 0, (function() {
            return g(this, (function(n) {
                switch (n.label) {
                  case 0:
                    // Notify the listener that the stream closed.
                    // Cancel any outstanding timers (they're guaranteed not to execute).
                    return this.nh(), this.zu.cancel(), 
                    // Invalidates any stream-related callbacks (e.g. from auth or the
                    // underlying stream), guaranteeing they won't execute.
                    this.ju++, 3 /* Error */ !== t ? 
                    // If this is an intentional close ensure we don't delay our next connection attempt.
                    this.zu.reset() : e && e.code === R.RESOURCE_EXHAUSTED ? (
                    // Log the error. (Probably either 'quota exceeded' or 'max queue length reached'.)
                    I(e.toString()), I("Using maximum backoff delay to prevent overloading the backend."), 
                    this.zu.$u()) : e && e.code === R.UNAUTHENTICATED && 
                    // "unauthenticated" error means the token was rejected. Try force refreshing it in case it
                    // just expired.
                    this.Wu.v(), 
                    // Clean up the underlying stream because we are no longer interested in events.
                    null !== this.stream && (this.sh(), this.stream.close(), this.stream = null), 
                    // This state must be assigned before calling onClose() to allow the callback to
                    // inhibit backoff or otherwise manipulate the state in its non-started state.
                    this.state = t, [ 4 /*yield*/ , this.listener.Iu(e) ];

                  case 1:
                    // Cancel any outstanding timers (they're guaranteed not to execute).
                    // Notify the listener that the stream closed.
                    return n.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Can be overridden to perform additional cleanup before the stream is closed.
     * Calling super.tearDown() is not required.
     */
    t.prototype.sh = function() {}, t.prototype.auth = function() {
        var t = this;
        this.state = 1 /* Starting */;
        var e = this.ih(this.ju), n = this.ju;
        // TODO(mikelehen): Just use dispatchIfNotClosed, but see TODO below.
                this.Wu.getToken().then((function(e) {
            // Stream can be stopped while waiting for authentication.
            // TODO(mikelehen): We really should just use dispatchIfNotClosed
            // and let this dispatch onto the queue, but that opened a spec test can
            // of worms that I don't want to deal with in this PR.
            t.ju === n && 
            // Normally we'd have to schedule the callback on the AsyncQueue.
            // However, the following calls are safe to be called outside the
            // AsyncQueue since they don't chain asynchronous calls
            t.rh(e);
        }), (function(n) {
            e((function() {
                var e = new P(R.UNKNOWN, "Fetching auth token failed: " + n.message);
                return t.oh(e);
            }));
        }));
    }, t.prototype.rh = function(t) {
        var e = this, n = this.ih(this.ju);
        this.stream = this.ah(t), this.stream.Eu((function() {
            n((function() {
                return e.state = 2 /* Open */ , e.listener.Eu();
            }));
        })), this.stream.Iu((function(t) {
            n((function() {
                return e.oh(t);
            }));
        })), this.stream.onMessage((function(t) {
            n((function() {
                return e.onMessage(t);
            }));
        }));
    }, t.prototype.Yu = function() {
        var t = this;
        this.state = 4 /* Backoff */ , this.zu.Bu((function() {
            return y(t, void 0, void 0, (function() {
                return g(this, (function(t) {
                    return this.state = 0 /* Initial */ , this.start(), [ 2 /*return*/ ];
                }));
            }));
        }));
    }, 
    // Visible for tests
    t.prototype.oh = function(t) {
        // In theory the stream could close cleanly, however, in our current model
        // we never expect this to happen because if we stop a stream ourselves,
        // this callback will never be called. To prevent cases where we retry
        // without a backoff accidentally, we set the stream to error in all cases.
        return E("PersistentStream", "close with error: " + t), this.stream = null, this.close(3 /* Error */ , t);
    }, 
    /**
     * Returns a "dispatcher" function that dispatches operations onto the
     * AsyncQueue but only runs them if closeCount remains unchanged. This allows
     * us to turn auth / stream callbacks into no-ops if the stream is closed /
     * re-opened, etc.
     */
    t.prototype.ih = function(t) {
        var e = this;
        return function(n) {
            e.eo.ys((function() {
                return e.ju === t ? n() : (E("PersistentStream", "stream callback skipped by getCloseGuardedDispatcher."), 
                Promise.resolve());
            }));
        };
    }, t;
}(), si = /** @class */ function(t) {
    function e(e, n, r, i, o) {
        var u = this;
        return (u = t.call(this, e, "listen_stream_connection_backoff" /* ListenStreamConnectionBackoff */ , "listen_stream_idle" /* ListenStreamIdle */ , n, r, o) || this).Kt = i, 
        u;
    }
    return w(e, t), e.prototype.ah = function(t) {
        return this.Ku.xu("Listen", t);
    }, e.prototype.onMessage = function(t) {
        // A successful response means the stream is healthy
        this.zu.reset();
        var e = function(t, e) {
            var n;
            if ("targetChange" in e) {
                e.targetChange;
                // proto3 default value is unset in JSON (undefined), so use 'NO_CHANGE'
                // if unset
                var r = function(t) {
                    return "NO_CHANGE" === t ? 0 /* NoChange */ : "ADD" === t ? 1 /* Added */ : "REMOVE" === t ? 2 /* Removed */ : "CURRENT" === t ? 3 /* Current */ : "RESET" === t ? 4 /* Reset */ : A();
                }(e.targetChange.targetChangeType || "NO_CHANGE"), i = e.targetChange.targetIds || [], o = function(t, e) {
                    return t.qt ? (S(void 0 === e || "string" == typeof e), V.fromBase64String(e || "")) : (S(void 0 === e || e instanceof Uint8Array), 
                    V.fromUint8Array(e || new Uint8Array));
                }(t, e.targetChange.resumeToken), u = (s = e.targetChange.cause) && function(t) {
                    var e = void 0 === t.code ? R.UNKNOWN : nn(t.code);
                    return new P(e, t.message || "");
                }(s);
                n = new Sn(r, i, o, u || null);
            } else if ("documentChange" in e) {
                e.documentChange, (r = e.documentChange).document, r.document.name, r.document.updateTime, 
                i = zn(t, r.document.name), o = qn(r.document.updateTime);
                var s = new kt({
                    mapValue: {
                        fields: r.document.fields
                    }
                }), a = (u = new Vt(i, o, s, {}), r.targetIds || []), c = r.removedTargetIds || [];
                n = new Nn(a, c, u.key, u);
            } else if ("documentDelete" in e) e.documentDelete, (r = e.documentDelete).document, 
            i = zn(t, r.document), o = r.readTime ? qn(r.readTime) : X.min(), s = new Rt(i, o), 
            u = r.removedTargetIds || [], n = new Nn([], u, s.key, s); else if ("documentRemove" in e) e.documentRemove, 
            (r = e.documentRemove).document, i = zn(t, r.document), o = r.removedTargetIds || [], 
            n = new Nn([], o, i, null); else {
                if (!("filter" in e)) return A();
                e.filter;
                var f = e.filter;
                f.targetId, r = f.count || 0, i = new tn(r), o = f.targetId, n = new An(o, i);
            }
            return n;
        }(this.Kt, t), n = function(t) {
            // We have only reached a consistent snapshot for the entire stream if there
            // is a read_time set and it applies to all targets (i.e. the list of
            // targets is empty). The backend is guaranteed to send such responses.
            if (!("targetChange" in t)) return X.min();
            var e = t.targetChange;
            return e.targetIds && e.targetIds.length ? X.min() : e.readTime ? qn(e.readTime) : X.min();
        }(t);
        return this.listener.uh(e, n);
    }, 
    /**
     * Registers interest in the results of the given target. If the target
     * includes a resumeToken it will be included in the request. Results that
     * affect the target will be streamed back as WatchChange messages that
     * reference the targetId.
     */
    e.prototype.hh = function(t) {
        var e = {};
        e.database = Hn(this.Kt), e.addTarget = function(t, e) {
            var n, r = e.target;
            return (n = Ft(r) ? {
                documents: Wn(t, r)
            } : {
                query: Qn(t, r)
            }).targetId = e.targetId, e.resumeToken.o() > 0 ? n.resumeToken = Un(t, e.resumeToken) : e.Mt.u(X.min()) > 0 && (
            // TODO(wuandy): Consider removing above check because it is most likely true.
            // Right now, many tests depend on this behaviour though (leaving min() out
            // of serialization).
            n.readTime = Pn(t, e.Mt.G())), n;
        }(this.Kt, t);
        var n = function(t, e) {
            var n = function(t, e) {
                switch (e) {
                  case 0 /* Listen */ :
                    return null;

                  case 1 /* ExistenceFilterMismatch */ :
                    return "existence-filter-mismatch";

                  case 2 /* LimboResolution */ :
                    return "limbo-document";

                  default:
                    return A();
                }
            }(0, e.kt);
            return null == n ? null : {
                "goog-listen-tags": n
            };
        }(this.Kt, t);
        n && (e.labels = n), this.eh(e);
    }, 
    /**
     * Unregisters interest in the results of the target associated with the
     * given targetId.
     */
    e.prototype.lh = function(t) {
        var e = {};
        e.database = Hn(this.Kt), e.removeTarget = t, this.eh(e);
    }, e;
}(ui), ai = /** @class */ function(t) {
    function e(e, n, r, i, o) {
        var u = this;
        return (u = t.call(this, e, "write_stream_connection_backoff" /* WriteStreamConnectionBackoff */ , "write_stream_idle" /* WriteStreamIdle */ , n, r, o) || this).Kt = i, 
        u._h = !1, u;
    }
    return w(e, t), Object.defineProperty(e.prototype, "fh", {
        /**
         * Tracks whether or not a handshake has been successfully exchanged and
         * the stream is ready to accept mutations.
         */
        get: function() {
            return this._h;
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Override of PersistentStream.start
    e.prototype.start = function() {
        this._h = !1, this.lastStreamToken = void 0, t.prototype.start.call(this);
    }, e.prototype.sh = function() {
        this._h && this.dh([]);
    }, e.prototype.ah = function(t) {
        return this.Ku.xu("Write", t);
    }, e.prototype.onMessage = function(t) {
        if (
        // Always capture the last stream token.
        S(!!t.streamToken), this.lastStreamToken = t.streamToken, this._h) {
            // A successful first write response means the stream is healthy,
            // Note, that we could consider a successful handshake healthy, however,
            // the write itself might be causing an error we want to back off from.
            this.zu.reset();
            var e = function(t, e) {
                return t && t.length > 0 ? (S(void 0 !== e), t.map((function(t) {
                    return function(t, e) {
                        // NOTE: Deletes don't have an updateTime.
                        var n = t.updateTime ? qn(t.updateTime) : qn(e);
                        n.isEqual(X.min()) && (
                        // The Firestore Emulator currently returns an update time of 0 for
                        // deletes of non-existing documents (rather than null). This breaks the
                        // test "get deleted doc while offline with source=cache" as NoDocuments
                        // with version 0 are filtered by IndexedDb's RemoteDocumentCache.
                        // TODO(#2149): Remove this when Emulator is fixed
                        n = qn(e));
                        var r = null;
                        return t.transformResults && t.transformResults.length > 0 && (r = t.transformResults), 
                        new Pe(n, r);
                    }(t, e);
                }))) : [];
            }(t.writeResults, t.commitTime), n = qn(t.commitTime);
            return this.listener.wh(n, e);
        }
        // The first response is always the handshake response
                return S(!t.writeResults || 0 === t.writeResults.length), this._h = !0, 
        this.listener.Eh();
    }, 
    /**
     * Sends an initial streamToken to the server, performing the handshake
     * required to make the StreamingWrite RPC work. Subsequent
     * calls should wait until onHandshakeComplete was called.
     */
    e.prototype.Th = function() {
        // TODO(dimond): Support stream resumption. We intentionally do not set the
        // stream token on the handshake, ignoring any stream token we might have.
        var t = {};
        t.database = Hn(this.Kt), this.eh(t);
    }, 
    /** Sends a group of mutations to the Firestore backend to apply. */ e.prototype.dh = function(t) {
        var e = this, n = {
            streamToken: this.lastStreamToken,
            writes: t.map((function(t) {
                return Jn(e.Kt, t);
            }))
        };
        this.eh(n);
    }, e;
}(ui), ci = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this) || this).credentials = e, i.Ku = n, i.Kt = r, i.Ih = !1, 
        i;
    }
    return w(e, t), e.prototype.mh = function() {
        if (this.Ih) throw new P(R.FAILED_PRECONDITION, "The client has already been terminated.");
    }, 
    /** Gets an auth token and invokes the provided RPC. */ e.prototype.bu = function(t, e, n) {
        var r = this;
        return this.mh(), this.credentials.getToken().then((function(i) {
            return r.Ku.bu(t, e, n, i);
        })).catch((function(t) {
            throw t.code === R.UNAUTHENTICATED && r.credentials.v(), t;
        }));
    }, 
    /** Gets an auth token and invokes the provided RPC with streamed results. */ e.prototype.Cu = function(t, e, n) {
        var r = this;
        return this.mh(), this.credentials.getToken().then((function(i) {
            return r.Ku.Cu(t, e, n, i);
        })).catch((function(t) {
            throw t.code === R.UNAUTHENTICATED && r.credentials.v(), t;
        }));
    }, e.prototype.terminate = function() {
        this.Ih = !1;
    }, e;
}((function() {})), fi = /** @class */ function() {
    function t(t, e) {
        this.fs = t, this.da = e, 
        /** The current OnlineState. */
        this.state = "Unknown" /* Unknown */ , 
        /**
             * A count of consecutive failures to open the stream. If it reaches the
             * maximum defined by MAX_WATCH_STREAM_FAILURES, we'll set the OnlineState to
             * Offline.
             */
        this.Ah = 0, 
        /**
             * A timer that elapses after ONLINE_STATE_TIMEOUT_MS, at which point we
             * transition from OnlineState.Unknown to OnlineState.Offline without waiting
             * for the stream to actually fail (MAX_WATCH_STREAM_FAILURES times).
             */
        this.Rh = null, 
        /**
             * Whether the client should log a warning message if it fails to connect to
             * the backend (initially true, cleared after a successful stream, or if we've
             * logged the message already).
             */
        this.Ph = !0
        /**
     * Called by RemoteStore when a watch stream is started (including on each
     * backoff attempt).
     *
     * If this is the first attempt, it sets the OnlineState to Unknown and starts
     * the onlineStateTimer.
     */;
    }
    return t.prototype.yh = function() {
        var t = this;
        0 === this.Ah && (this.gh("Unknown" /* Unknown */), this.Rh = this.fs.Ir("online_state_timeout" /* OnlineStateTimeout */ , 1e4, (function() {
            return t.Rh = null, t.Vh("Backend didn't respond within 10 seconds."), t.gh("Offline" /* Offline */), 
            Promise.resolve();
        })));
    }, 
    /**
     * Updates our OnlineState as appropriate after the watch stream reports a
     * failure. The first failure moves us to the 'Unknown' state. We then may
     * allow multiple failures (based on MAX_WATCH_STREAM_FAILURES) before we
     * actually transition to the 'Offline' state.
     */
    t.prototype.ph = function(t) {
        "Online" /* Online */ === this.state ? this.gh("Unknown" /* Unknown */) : (this.Ah++, 
        this.Ah >= 1 && (this.bh(), this.Vh("Connection failed 1 times. Most recent error: " + t.toString()), 
        this.gh("Offline" /* Offline */)));
    }, 
    /**
     * Explicitly sets the OnlineState to the specified state.
     *
     * Note that this resets our timers / failure counters, etc. used by our
     * Offline heuristics, so must not be used in place of
     * handleWatchStreamStart() and handleWatchStreamFailure().
     */
    t.prototype.set = function(t) {
        this.bh(), this.Ah = 0, "Online" /* Online */ === t && (
        // We've connected to watch at least once. Don't warn the developer
        // about being offline going forward.
        this.Ph = !1), this.gh(t);
    }, t.prototype.gh = function(t) {
        t !== this.state && (this.state = t, this.da(t));
    }, t.prototype.Vh = function(t) {
        var e = "Could not reach Cloud Firestore backend. " + t + "\nThis typically indicates that your device does not have a healthy Internet connection at the moment. The client will operate in offline mode until it is able to successfully connect to the backend.";
        this.Ph ? (I(e), this.Ph = !1) : E("OnlineStateTracker", e);
    }, t.prototype.bh = function() {
        null !== this.Rh && (this.Rh.cancel(), this.Rh = null);
    }, t;
}(), hi = function(
/**
     * The local store, used to fill the write pipeline with outbound mutations.
     */
t, 
/** The client-side proxy for interacting with the backend. */
e, n, r, i) {
    var o = this;
    this.Sh = t, this.Dh = e, this.fs = n, this.Ch = {}, 
    /**
             * A list of up to MAX_PENDING_WRITES writes that we have fetched from the
             * LocalStore via fillWritePipeline() and have or will send to the write
             * stream.
             *
             * Whenever writePipeline.length > 0 the RemoteStore will attempt to start or
             * restart the write stream. When the stream is established the writes in the
             * pipeline will be sent in order.
             *
             * Writes remain in writePipeline until they are acknowledged by the backend
             * and thus will automatically be re-sent if the stream is interrupted /
             * restarted before they're acknowledged.
             *
             * Write responses from the backend are linked to their originating request
             * purely based on order, and so we can just shift() writes from the front of
             * the writePipeline as we receive responses.
             */
    this.xh = [], 
    /**
             * A mapping of watched targets that the client cares about tracking and the
             * user has explicitly called a 'listen' for this target.
             *
             * These targets may or may not have been sent to or acknowledged by the
             * server. On re-establishing the listen stream, these targets should be sent
             * to the server. The targets removed with unlistens are removed eagerly
             * without waiting for confirmation from the listen stream.
             */
    this.Nh = new Map, 
    /**
             * A set of reasons for why the RemoteStore may be offline. If empty, the
             * RemoteStore may start its network connections.
             */
    this.Fh = new Set, 
    /**
             * Event handlers that get called when the network is disabled or enabled.
             *
             * PORTING NOTE: These functions are used on the Web client to create the
             * underlying streams (to support tree-shakeable streams). On Android and iOS,
             * the streams are created during construction of RemoteStore.
             */
    this.Oh = [], this.kh = i, this.kh.cu((function(t) {
        n.ys((function() {
            return y(o, void 0, void 0, (function() {
                return g(this, (function(t) {
                    switch (t.label) {
                      case 0:
                        return bi(this) ? (E("RemoteStore", "Restarting streams for network reachability change."), 
                        [ 4 /*yield*/ , function(t) {
                            return y(this, void 0, void 0, (function() {
                                var e;
                                return g(this, (function(n) {
                                    switch (n.label) {
                                      case 0:
                                        return (e = D(t)).Fh.add(4 /* ConnectivityChange */), [ 4 /*yield*/ , pi(e) ];

                                      case 1:
                                        return n.sent(), e.Mh.set("Unknown" /* Unknown */), e.Fh.delete(4 /* ConnectivityChange */), 
                                        [ 4 /*yield*/ , li(e) ];

                                      case 2:
                                        return n.sent(), [ 2 /*return*/ ];
                                    }
                                }));
                            }));
                        }(this) ]) : [ 3 /*break*/ , 2 ];

                      case 1:
                        t.sent(), t.label = 2;

                      case 2:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        }));
    })), this.Mh = new fi(n, r);
};

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A PersistentStream is an abstract base class that represents a streaming RPC
 * to the Firestore backend. It's built on top of the connections own support
 * for streaming RPCs, and adds several critical features for our clients:
 *
 *   - Exponential backoff on failure
 *   - Authentication via CredentialsProvider
 *   - Dispatching all callbacks into the shared worker queue
 *   - Closing idle streams after 60 seconds of inactivity
 *
 * Subclasses of PersistentStream implement serialization of models to and
 * from the JSON representation of the protocol buffers for a specific
 * streaming RPC.
 *
 * ## Starting and Stopping
 *
 * Streaming RPCs are stateful and need to be start()ed before messages can
 * be sent and received. The PersistentStream will call the onOpen() function
 * of the listener once the stream is ready to accept requests.
 *
 * Should a start() fail, PersistentStream will call the registered onClose()
 * listener with a FirestoreError indicating what went wrong.
 *
 * A PersistentStream can be started and stopped repeatedly.
 *
 * Generic types:
 *  SendType: The type of the outgoing message of the underlying
 *    connection stream
 *  ReceiveType: The type of the incoming message of the underlying
 *    connection stream
 *  ListenerType: The type of the listener that will be used for callbacks
 */ function li(t) {
    return y(this, void 0, void 0, (function() {
        var e, n;
        return g(this, (function(r) {
            switch (r.label) {
              case 0:
                if (!bi(t)) return [ 3 /*break*/ , 4 ];
                e = 0, n = t.Oh, r.label = 1;

              case 1:
                return e < n.length ? [ 4 /*yield*/ , (0, n[e])(/* enabled= */ !0) ] : [ 3 /*break*/ , 4 ];

              case 2:
                r.sent(), r.label = 3;

              case 3:
                return e++, [ 3 /*break*/ , 1 ];

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Temporarily disables the network. The network can be re-enabled using
 * enableNetwork().
 */ function pi(t) {
    return y(this, void 0, void 0, (function() {
        var e, n;
        return g(this, (function(r) {
            switch (r.label) {
              case 0:
                e = 0, n = t.Oh, r.label = 1;

              case 1:
                return e < n.length ? [ 4 /*yield*/ , (0, n[e])(/* enabled= */ !1) ] : [ 3 /*break*/ , 4 ];

              case 2:
                r.sent(), r.label = 3;

              case 3:
                return e++, [ 3 /*break*/ , 1 ];

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Starts new listen for the given target. Uses resume token if provided. It
 * is a no-op if the target of given `TargetData` is already being listened to.
 */ function di(t, e) {
    var n = D(t);
    n.Nh.has(e.targetId) || (
    // Mark this as something the client is currently listening for.
    n.Nh.set(e.targetId, e), wi(n) ? 
    // The listen will be sent in onWatchStreamOpen
    mi(n) : Pi(n).Ju() && yi(n, e));
}

/**
 * Removes the listen from server. It is a no-op if the given target id is
 * not being listened to.
 */ function vi(t, e) {
    var n = D(t), r = Pi(n);
    n.Nh.delete(e), r.Ju() && gi(n, e), 0 === n.Nh.size && (r.Ju() ? r.Zu() : bi(n) && 
    // Revert to OnlineState.Unknown if the watch stream is not open and we
    // have no listeners, since without any listens to send we cannot
    // confirm if the stream is healthy and upgrade to OnlineState.Online.
    n.Mh.set("Unknown" /* Unknown */));
}

/**
 * We need to increment the the expected number of pending responses we're due
 * from watch so we wait for the ack to process any messages from this target.
 */ function yi(t, e) {
    t.Lh.cn(e.targetId), Pi(t).hh(e)
    /**
 * We need to increment the expected number of pending responses we're due
 * from watch so we wait for the removal on the server before we process any
 * messages from this target.
 */;
}

function gi(t, e) {
    t.Lh.cn(e), Pi(t).lh(e);
}

function mi(t) {
    t.Lh = new kn({
        Sn: function(e) {
            return t.Ch.Sn(e);
        },
        Dn: function(e) {
            return t.Nh.get(e) || null;
        }
    }), Pi(t).start(), t.Mh.yh()
    /**
 * Returns whether the watch stream should be started because it's necessary
 * and has not yet been started.
 */;
}

function wi(t) {
    return bi(t) && !Pi(t).Hu() && t.Nh.size > 0;
}

function bi(t) {
    return 0 === D(t).Fh.size;
}

function _i(t) {
    t.Lh = void 0;
}

function Ei(t) {
    return y(this, void 0, void 0, (function() {
        return g(this, (function(e) {
            return t.Nh.forEach((function(e, n) {
                yi(t, e);
            })), [ 2 /*return*/ ];
        }));
    }));
}

function Ii(t, e) {
    return y(this, void 0, void 0, (function() {
        return g(this, (function(n) {
            return _i(t), 
            // If we still need the watch stream, retry the connection.
            wi(t) ? (t.Mh.ph(e), mi(t)) : 
            // No need to restart watch stream because there are no active targets.
            // The online state is set to unknown because there is no active attempt
            // at establishing a connection
            t.Mh.set("Unknown" /* Unknown */), [ 2 /*return*/ ];
        }));
    }));
}

function Ti(t, e, n) {
    return y(this, void 0, void 0, (function() {
        var r, i, o;
        return g(this, (function(u) {
            switch (u.label) {
              case 0:
                if (t.Mh.set("Online" /* Online */), !(e instanceof Sn && 2 /* Removed */ === e.state && e.cause)) 
                // Mark the client as online since we got a message from the server
                return [ 3 /*break*/ , 6 ];
                u.label = 1;

              case 1:
                return u.trys.push([ 1, 3, , 5 ]), [ 4 /*yield*/ , 
                /** Handles an error on a target */
                function(t, e) {
                    return y(this, void 0, void 0, (function() {
                        var n, r, i, o;
                        return g(this, (function(u) {
                            switch (u.label) {
                              case 0:
                                n = e.cause, r = 0, i = e.targetIds, u.label = 1;

                              case 1:
                                return r < i.length ? (o = i[r], t.Nh.has(o) ? [ 4 /*yield*/ , t.Ch.$h(o, n) ] : [ 3 /*break*/ , 3 ]) : [ 3 /*break*/ , 5 ];

                              case 2:
                                u.sent(), t.Nh.delete(o), t.Lh.removeTarget(o), u.label = 3;

                              case 3:
                                u.label = 4;

                              case 4:
                                return r++, [ 3 /*break*/ , 1 ];

                              case 5:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(t, e) ];

              case 2:
                return u.sent(), [ 3 /*break*/ , 5 ];

              case 3:
                return r = u.sent(), E("RemoteStore", "Failed to remove targets %s: %s ", e.targetIds.join(","), r), 
                [ 4 /*yield*/ , Ni(t, r) ];

              case 4:
                return u.sent(), [ 3 /*break*/ , 5 ];

              case 5:
                return [ 3 /*break*/ , 13 ];

              case 6:
                if (e instanceof Nn ? t.Lh.wn(e) : e instanceof An ? t.Lh.yn(e) : t.Lh.In(e), n.isEqual(X.min())) return [ 3 /*break*/ , 13 ];
                u.label = 7;

              case 7:
                return u.trys.push([ 7, 11, , 13 ]), [ 4 /*yield*/ , Cr(t.Sh) ];

              case 8:
                return i = u.sent(), n.u(i) >= 0 ? [ 4 /*yield*/ , 
                /**
                 * Takes a batch of changes from the Datastore, repackages them as a
                 * RemoteEvent, and passes that on to the listener, which is typically the
                 * SyncEngine.
                 */
                function(t, e) {
                    var n = t.Lh.pn(e);
                    // Update in-memory resume tokens. LocalStore will update the
                    // persistent view of these when applying the completed RemoteEvent.
                                        return n.Oe.forEach((function(n, r) {
                        if (n.resumeToken.o() > 0) {
                            var i = t.Nh.get(r);
                            // A watched target might have been removed already.
                                                        i && t.Nh.set(r, i.$t(n.resumeToken, e));
                        }
                    })), 
                    // Re-establish listens for the targets that have been invalidated by
                    // existence filter mismatches.
                    n.ke.forEach((function(e) {
                        var n = t.Nh.get(e);
                        if (n) {
                            // Clear the resume token for the target, since we're in a known mismatch
                            // state.
                            t.Nh.set(e, n.$t(V.h, n.Mt)), 
                            // Cause a hard reset by unwatching and rewatching immediately, but
                            // deliberately don't send a resume token so that we get a full update.
                            gi(t, e);
                            // Mark the target we send as being on behalf of an existence filter
                            // mismatch, but don't actually retain that in listenTargets. This ensures
                            // that we flag the first re-listen this way without impacting future
                            // listens of this target (that might happen e.g. on reconnect).
                            var r = new me(n.target, e, 1 /* ExistenceFilterMismatch */ , n.sequenceNumber);
                            yi(t, r);
                        }
                    })), t.Ch.Bh(n);
                }(t, n) ] : [ 3 /*break*/ , 10 ];

                // We have received a target change with a global snapshot if the snapshot
                // version is not equal to SnapshotVersion.min().
                              case 9:
                // We have received a target change with a global snapshot if the snapshot
                // version is not equal to SnapshotVersion.min().
                u.sent(), u.label = 10;

              case 10:
                return [ 3 /*break*/ , 13 ];

              case 11:
                return E("RemoteStore", "Failed to raise snapshot:", o = u.sent()), [ 4 /*yield*/ , Ni(t, o) ];

              case 12:
                return u.sent(), [ 3 /*break*/ , 13 ];

              case 13:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Recovery logic for IndexedDB errors that takes the network offline until
 * `op` succeeds. Retries are scheduled with backoff using
 * `enqueueRetryable()`. If `op()` is not provided, IndexedDB access is
 * validated via a generic operation.
 *
 * The returned Promise is resolved once the network is disabled and before
 * any retry attempt.
 */ function Ni(t, e, n) {
    return y(this, void 0, void 0, (function() {
        var r = this;
        return g(this, (function(i) {
            switch (i.label) {
              case 0:
                if (!fr(e)) throw e;
                // Disable network and raise offline snapshots
                return t.Fh.add(1 /* IndexedDbFailed */), [ 4 /*yield*/ , pi(t) ];

              case 1:
                // Disable network and raise offline snapshots
                return i.sent(), t.Mh.set("Offline" /* Offline */), n || (
                // Use a simple read operation to determine if IndexedDB recovered.
                // Ideally, we would expose a health check directly on SimpleDb, but
                // RemoteStore only has access to persistence through LocalStore.
                n = function() {
                    return Cr(t.Sh);
                }), 
                // Probe IndexedDB periodically and re-enable network
                t.fs.bo((function() {
                    return y(r, void 0, void 0, (function() {
                        return g(this, (function(e) {
                            switch (e.label) {
                              case 0:
                                return E("RemoteStore", "Retrying IndexedDB access"), [ 4 /*yield*/ , n() ];

                              case 1:
                                return e.sent(), t.Fh.delete(1 /* IndexedDbFailed */), [ 4 /*yield*/ , li(t) ];

                              case 2:
                                return e.sent(), [ 2 /*return*/ ];
                            }
                        }));
                    }));
                })), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Executes `op`. If `op` fails, takes the network offline until `op`
 * succeeds. Returns after the first attempt.
 */ function Ai(t, e) {
    return e().catch((function(n) {
        return Ni(t, n, e);
    }));
}

function Si(t) {
    return y(this, void 0, void 0, (function() {
        var e, n, r, i, o;
        return g(this, (function(u) {
            switch (u.label) {
              case 0:
                e = D(t), n = Ui(e), r = e.xh.length > 0 ? e.xh[e.xh.length - 1].batchId : -1, u.label = 1;

              case 1:
                if (!
                /**
 * Returns true if we can add to the write pipeline (i.e. the network is
 * enabled and the write pipeline is not full).
 */
                function(t) {
                    return bi(t) && t.xh.length < 10;
                }
                /**
 * Queues additional writes to be sent to the write stream, sending them
 * immediately if the write stream is established.
 */ (e)) return [ 3 /*break*/ , 7 ];
                u.label = 2;

              case 2:
                return u.trys.push([ 2, 4, , 6 ]), [ 4 /*yield*/ , Rr(e.Sh, r) ];

              case 3:
                return null === (i = u.sent()) ? (0 === e.xh.length && n.Zu(), [ 3 /*break*/ , 7 ]) : (r = i.batchId, 
                function(t, e) {
                    t.xh.push(e);
                    var n = Ui(t);
                    n.Ju() && n.fh && n.dh(e.mutations);
                }(e, i), [ 3 /*break*/ , 6 ]);

              case 4:
                return o = u.sent(), [ 4 /*yield*/ , Ni(e, o) ];

              case 5:
                return u.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 3 /*break*/ , 1 ];

              case 7:
                return Di(e) && ki(e), [ 2 /*return*/ ];
            }
        }));
    }));
}

function Di(t) {
    return bi(t) && !Ui(t).Hu() && t.xh.length > 0;
}

function ki(t) {
    Ui(t).start();
}

function Oi(t) {
    return y(this, void 0, void 0, (function() {
        return g(this, (function(e) {
            return Ui(t).Th(), [ 2 /*return*/ ];
        }));
    }));
}

function Ci(t) {
    return y(this, void 0, void 0, (function() {
        var e, n, r, i;
        return g(this, (function(o) {
            // Send the write pipeline now that the stream is established.
            for (e = Ui(t), n = 0, r = t.xh; n < r.length; n++) i = r[n], e.dh(i.mutations);
            return [ 2 /*return*/ ];
        }));
    }));
}

function Li(t, e, n) {
    return y(this, void 0, void 0, (function() {
        var r, i;
        return g(this, (function(o) {
            switch (o.label) {
              case 0:
                return r = t.xh.shift(), i = vr.from(r, e, n), [ 4 /*yield*/ , Ai(t, (function() {
                    return t.Ch.qh(i);
                })) ];

              case 1:
                // It's possible that with the completion of this mutation another
                // slot has freed up.
                return o.sent(), [ 4 /*yield*/ , Si(t) ];

              case 2:
                // It's possible that with the completion of this mutation another
                // slot has freed up.
                return o.sent(), [ 2 /*return*/ ];
            }
        }));
    }));
}

function Vi(t, e) {
    return y(this, void 0, void 0, (function() {
        return g(this, (function(n) {
            switch (n.label) {
              case 0:
                return e && Ui(t).fh ? [ 4 /*yield*/ , function(t, e) {
                    return y(this, void 0, void 0, (function() {
                        var n, r;
                        return g(this, (function(i) {
                            switch (i.label) {
                              case 0:
                                return en(r = e.code) && r !== R.ABORTED ? (n = t.xh.shift(), 
                                // In this case it's also unlikely that the server itself is melting
                                // down -- this was just a bad request so inhibit backoff on the next
                                // restart.
                                Ui(t).Xu(), [ 4 /*yield*/ , Ai(t, (function() {
                                    return t.Ch.Uh(n.batchId, e);
                                })) ]) : [ 3 /*break*/ , 3 ];

                              case 1:
                                // It's possible that with the completion of this mutation
                                // another slot has freed up.
                                return i.sent(), [ 4 /*yield*/ , Si(t) ];

                              case 2:
                                // In this case it's also unlikely that the server itself is melting
                                // down -- this was just a bad request so inhibit backoff on the next
                                // restart.
                                // It's possible that with the completion of this mutation
                                // another slot has freed up.
                                i.sent(), i.label = 3;

                              case 3:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(t, e) ] : [ 3 /*break*/ , 2 ];

                // This error affects the actual write.
                              case 1:
                // This error affects the actual write.
                n.sent(), n.label = 2;

              case 2:
                // If the write stream closed after the write handshake completes, a write
                // operation failed and we fail the pending operation.
                // The write stream might have been started by refilling the write
                // pipeline for failed writes
                return Di(t) && ki(t), [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Toggles the network state when the client gains or loses its primary lease.
 */ function Ri(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r;
        return g(this, (function(i) {
            switch (i.label) {
              case 0:
                return n = D(t), e ? (n.Fh.delete(2 /* IsSecondary */), [ 4 /*yield*/ , li(n) ]) : [ 3 /*break*/ , 2 ];

              case 1:
                return i.sent(), [ 3 /*break*/ , 5 ];

              case 2:
                return (r = e) ? [ 3 /*break*/ , 4 ] : (n.Fh.add(2 /* IsSecondary */), [ 4 /*yield*/ , pi(n) ]);

              case 3:
                i.sent(), r = n.Mh.set("Unknown" /* Unknown */), i.label = 4;

              case 4:
                r, i.label = 5;

              case 5:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * If not yet initialized, registers the WatchStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WatchStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */ function Pi(t) {
    var e = this;
    return t.Qh || (
    // Create stream (but note that it is not started yet).
    t.Qh = function(t, e, n) {
        var r = D(t);
        return r.mh(), new si(e, r.Ku, r.credentials, r.Kt, n);
    }(t.Dh, t.fs, {
        Eu: Ei.bind(null, t),
        Iu: Ii.bind(null, t),
        uh: Ti.bind(null, t)
    }), t.Oh.push((function(n) {
        return y(e, void 0, void 0, (function() {
            return g(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return n ? (t.Qh.Xu(), wi(t) ? mi(t) : t.Mh.set("Unknown" /* Unknown */), [ 3 /*break*/ , 3 ]) : [ 3 /*break*/ , 1 ];

                  case 1:
                    return [ 4 /*yield*/ , t.Qh.stop() ];

                  case 2:
                    e.sent(), _i(t), e.label = 3;

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }))), t.Qh
    /**
 * If not yet initialized, registers the WriteStream and its network state
 * callback with `remoteStoreImpl`. Returns the existing stream if one is
 * already available.
 *
 * PORTING NOTE: On iOS and Android, the WriteStream gets registered on startup.
 * This is not done on Web to allow it to be tree-shaken.
 */;
}

function Ui(t) {
    var e = this;
    return t.Kh || (
    // Create stream (but note that it is not started yet).
    t.Kh = function(t, e, n) {
        var r = D(t);
        return r.mh(), new ai(e, r.Ku, r.credentials, r.Kt, n);
    }(t.Dh, t.fs, {
        Eu: Oi.bind(null, t),
        Iu: Vi.bind(null, t),
        Eh: Ci.bind(null, t),
        wh: Li.bind(null, t)
    }), t.Oh.push((function(n) {
        return y(e, void 0, void 0, (function() {
            return g(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return n ? (t.Kh.Xu(), [ 4 /*yield*/ , Si(t) ]) : [ 3 /*break*/ , 2 ];

                  case 1:
                    // This will start the write stream if necessary.
                    return e.sent(), [ 3 /*break*/ , 4 ];

                  case 2:
                    return [ 4 /*yield*/ , t.Kh.stop() ];

                  case 3:
                    e.sent(), t.xh.length > 0 && (E("RemoteStore", "Stopping write stream with " + t.xh.length + " pending writes"), 
                    t.xh = []), e.label = 4;

                  case 4:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }))), t.Kh
    /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * Holds the listeners and the last received ViewSnapshot for a query being
 * tracked by EventManager.
 */;
}

var xi = function() {
    this.Wh = void 0, this.listeners = [];
}, qi = function() {
    this.queries = new _r((function(t) {
        return pe(t);
    }), le), this.onlineState = "Unknown" /* Unknown */ , this.jh = new Set;
};

function Mi(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r, i, o, u, s, a;
        return g(this, (function(c) {
            switch (c.label) {
              case 0:
                if (n = D(t), r = e.query, i = !1, (o = n.queries.get(r)) || (i = !0, o = new xi), 
                !i) return [ 3 /*break*/ , 4 ];
                c.label = 1;

              case 1:
                return c.trys.push([ 1, 3, , 4 ]), u = o, [ 4 /*yield*/ , n.Gh(r) ];

              case 2:
                return u.Wh = c.sent(), [ 3 /*break*/ , 4 ];

              case 3:
                return s = c.sent(), a = lr(s, "Initialization of query '" + de(e.query) + "' failed"), 
                [ 2 /*return*/ , void e.onError(a) ];

              case 4:
                return n.queries.set(r, o), o.listeners.push(e), 
                // Run global snapshot listeners if a consistent snapshot has been emitted.
                e.zh(n.onlineState), o.Wh && e.Hh(o.Wh) && Gi(n), [ 2 /*return*/ ];
            }
        }));
    }));
}

function Fi(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r, i, o, u;
        return g(this, (function(s) {
            return n = D(t), r = e.query, i = !1, (o = n.queries.get(r)) && (u = o.listeners.indexOf(e)) >= 0 && (o.listeners.splice(u, 1), 
            i = 0 === o.listeners.length), i ? [ 2 /*return*/ , (n.queries.delete(r), n.Jh(r)) ] : [ 2 /*return*/ ];
        }));
    }));
}

function ji(t, e) {
    for (var n = D(t), r = !1, i = 0, o = e; i < o.length; i++) {
        var u = o[i], s = u.query, a = n.queries.get(s);
        if (a) {
            for (var c = 0, f = a.listeners; c < f.length; c++) {
                f[c].Hh(u) && (r = !0);
            }
            a.Wh = u;
        }
    }
    r && Gi(n);
}

function zi(t, e, n) {
    var r = D(t), i = r.queries.get(e);
    if (i) for (var o = 0, u = i.listeners; o < u.length; o++) {
        u[o].onError(n);
    }
    // Remove all listeners. NOTE: We don't need to call syncEngine.unlisten()
    // after an error.
        r.queries.delete(e);
}

// Call all global snapshot listeners that have been set.
function Gi(t) {
    t.jh.forEach((function(t) {
        t.next();
    }));
}

/**
 * QueryListener takes a series of internal view snapshots and determines
 * when to raise the event.
 *
 * It uses an Observer to dispatch events.
 */ var Hi = /** @class */ function() {
    function t(t, e, n) {
        this.query = t, this.Yh = e, 
        /**
             * Initial snapshots (e.g. from cache) may not be propagated to the wrapped
             * observer. This flag is set to true once we've actually raised an event.
             */
        this.Xh = !1, this.Zh = null, this.onlineState = "Unknown" /* Unknown */ , this.options = n || {}
        /**
     * Applies the new ViewSnapshot to this listener, raising a user-facing event
     * if applicable (depending on what changed, whether the user has opted into
     * metadata-only changes, etc.). Returns true if a user-facing event was
     * indeed raised.
     */;
    }
    return t.prototype.Hh = function(t) {
        if (!this.options.includeMetadataChanges) {
            for (
            // Remove the metadata only changes.
            var e = [], n = 0, r = t.docChanges; n < r.length; n++) {
                var i = r[n];
                3 /* Metadata */ !== i.type && e.push(i);
            }
            t = new En(t.query, t.docs, t.De, e, t.Ce, t.fromCache, t.xe, 
            /* excludesMetadataChanges= */ !0);
        }
        var o = !1;
        return this.Xh ? this.tl(t) && (this.Yh.next(t), o = !0) : this.el(t, this.onlineState) && (this.nl(t), 
        o = !0), this.Zh = t, o;
    }, t.prototype.onError = function(t) {
        this.Yh.error(t);
    }, 
    /** Returns whether a snapshot was raised. */ t.prototype.zh = function(t) {
        this.onlineState = t;
        var e = !1;
        return this.Zh && !this.Xh && this.el(this.Zh, t) && (this.nl(this.Zh), e = !0), 
        e;
    }, t.prototype.el = function(t, e) {
        // Always raise the first event when we're synced
        if (!t.fromCache) return !0;
        // NOTE: We consider OnlineState.Unknown as online (it should become Offline
        // or Online if we wait long enough).
                var n = "Offline" /* Offline */ !== e;
        // Don't raise the event if we're online, aren't synced yet (checked
        // above) and are waiting for a sync.
                return !(this.options.sl && n || t.docs.nt() && "Offline" /* Offline */ !== e);
        // Raise data from cache if we have any documents or we are offline
        }, t.prototype.tl = function(t) {
        // We don't need to handle includeDocumentMetadataChanges here because
        // the Metadata only changes have already been stripped out if needed.
        // At this point the only changes we will see are the ones we should
        // propagate.
        if (t.docChanges.length > 0) return !0;
        var e = this.Zh && this.Zh.hasPendingWrites !== t.hasPendingWrites;
        return !(!t.xe && !e) && !0 === this.options.includeMetadataChanges;
        // Generally we should have hit one of the cases above, but it's possible
        // to get here if there were only metadata docChanges and they got
        // stripped out.
        }, t.prototype.nl = function(t) {
        t = En.Fe(t.query, t.docs, t.Ce, t.fromCache), this.Xh = !0, this.Yh.next(t);
    }, t;
}(), Bi = /** @class */ function() {
    function t(t, 
    // How many bytes this element takes to store in the bundle.
    e) {
        this.payload = t, this.byteLength = e;
    }
    return t.prototype.il = function() {
        return "metadata" in this.payload;
    }, t;
}(), Ki = /** @class */ function() {
    function t(t) {
        this.Kt = t;
    }
    return t.prototype.yc = function(t) {
        return zn(this.Kt, t);
    }, 
    /**
     * Converts a BundleDocument to a MaybeDocument.
     */
    t.prototype.gc = function(t) {
        return t.metadata.exists ? function(t, e, n) {
            var r = zn(t, e.name), i = qn(e.updateTime), o = new kt({
                mapValue: {
                    fields: e.fields
                }
            });
            return new Vt(r, i, o, {
                hasCommittedMutations: !!n
            });
        }(this.Kt, t.document, !1) : new Rt(this.yc(t.metadata.name), this.Vc(t.metadata.readTime));
    }, t.prototype.Vc = function(t) {
        return qn(t);
    }, t;
}(), Ji = /** @class */ function() {
    function t(t, e, n) {
        this.rl = t, this.Sh = e, this.Kt = n, 
        /** Batched queries to be saved into storage */
        this.queries = [], 
        /** Batched documents to be saved into storage */
        this.documents = [], this.progress = Wi(t)
        /**
     * Adds an element from the bundle to the loader.
     *
     * Returns a new progress if adding the element leads to a new progress,
     * otherwise returns null.
     */;
    }
    return t.prototype.ol = function(t) {
        this.progress.bytesLoaded += t.byteLength;
        var e = this.progress.documentsLoaded;
        return t.payload.namedQuery ? this.queries.push(t.payload.namedQuery) : t.payload.documentMetadata ? (this.documents.push({
            metadata: t.payload.documentMetadata
        }), t.payload.documentMetadata.exists || ++e) : t.payload.document && (this.documents[this.documents.length - 1].document = t.payload.document, 
        ++e), e !== this.progress.documentsLoaded ? (this.progress.documentsLoaded = e, 
        Object.assign({}, this.progress)) : null;
    }, t.prototype.cl = function(t) {
        for (var e = new Map, n = new Ki(this.Kt), r = 0, i = t; r < i.length; r++) {
            var o = i[r];
            if (o.metadata.queries) for (var u = n.yc(o.metadata.name), s = 0, a = o.metadata.queries; s < a.length; s++) {
                var c = a[s], f = (e.get(c) || gn()).add(u);
                e.set(c, f);
            }
        }
        return e;
    }, 
    /**
     * Update the progress to 'Success' and return the updated progress.
     */
    t.prototype.complete = function() {
        return y(this, void 0, void 0, (function() {
            var t, e, n, r, i;
            return g(this, (function(o) {
                switch (o.label) {
                  case 0:
                    return [ 4 /*yield*/ , qr(this.Sh, new Ki(this.Kt), this.documents, this.rl.id) ];

                  case 1:
                    t = o.sent(), e = this.cl(this.documents), n = 0, r = this.queries, o.label = 2;

                  case 2:
                    return n < r.length ? (i = r[n], [ 4 /*yield*/ , Mr(this.Sh, i, e.get(i.name)) ]) : [ 3 /*break*/ , 5 ];

                  case 3:
                    o.sent(), o.label = 4;

                  case 4:
                    return n++, [ 3 /*break*/ , 2 ];

                  case 5:
                    return [ 2 /*return*/ , (this.progress.taskState = "Success", new Tr(Object.assign({}, this.progress), t)) ];
                }
            }));
        }));
    }, t;
}();

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A complete element in the bundle stream, together with the byte length it
 * occupies in the stream.
 */
/**
 * Returns a `LoadBundleTaskProgress` representing the initial progress of
 * loading a bundle.
 */
function Wi(t) {
    return {
        taskState: "Running",
        documentsLoaded: 0,
        bytesLoaded: 0,
        totalDocuments: t.totalDocuments,
        totalBytes: t.totalBytes
    };
}

/**
 * Returns a `LoadBundleTaskProgress` representing the progress that the loading
 * has succeeded.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var Qi = function(t) {
    this.key = t;
}, Yi = function(t) {
    this.key = t;
}, Xi = /** @class */ function() {
    function t(t, 
    /** Documents included in the remote target */
    e) {
        this.query = t, this.al = e, this.ul = null, 
        /**
             * A flag whether the view is current with the backend. A view is considered
             * current after it has seen the current flag from the backend and did not
             * lose consistency within the watch stream (e.g. because of an existence
             * filter mismatch).
             */
        this.qe = !1, 
        /** Documents in the view but not in the remote target */
        this.hl = gn(), 
        /** Document Keys that have local changes */
        this.Ce = gn(), this.ll = ye(t), this._l = new bn(this.ll);
    }
    return Object.defineProperty(t.prototype, "fl", {
        /**
         * The set of remote documents that the server has told us belongs to the target associated with
         * this view.
         */
        get: function() {
            return this.al;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Iterates over a set of doc changes, applies the query limit, and computes
     * what the new results should be, what the changes were, and whether we may
     * need to go back to the local cache for more results. Does not make any
     * changes to the view.
     * @param docChanges - The doc changes to apply to this view.
     * @param previousChanges - If this is being called with a refill, then start
     *        with this set of docs and changes instead of the current view.
     * @returns a new set of docs, changes, and refill flag.
     */
    t.prototype.dl = function(t, e) {
        var n = this, r = e ? e.wl : new _n, i = e ? e._l : this._l, o = e ? e.Ce : this.Ce, u = i, s = !1, a = ie(this.query) && i.size === this.query.limit ? i.last() : null, c = oe(this.query) && i.size === this.query.limit ? i.first() : null;
        // Drop documents out to meet limit/limitToLast requirement.
        if (t.Zt((function(t, e) {
            var f = i.get(t), h = e instanceof Vt ? e : null;
            h && (h = ve(n.query, h) ? h : null);
            var l = !!f && n.Ce.has(f.key), p = !!h && (h.bt || 
            // We only consider committed mutations for documents that were
            // mutated during the lifetime of the view.
            n.Ce.has(h.key) && h.hasCommittedMutations), d = !1;
            // Calculate change
            f && h ? f.data().isEqual(h.data()) ? l !== p && (r.track({
                type: 3 /* Metadata */ ,
                doc: h
            }), d = !0) : n.El(f, h) || (r.track({
                type: 2 /* Modified */ ,
                doc: h
            }), d = !0, (a && n.ll(h, a) > 0 || c && n.ll(h, c) < 0) && (
            // This doc moved from inside the limit to outside the limit.
            // That means there may be some other doc in the local cache
            // that should be included instead.
            s = !0)) : !f && h ? (r.track({
                type: 0 /* Added */ ,
                doc: h
            }), d = !0) : f && !h && (r.track({
                type: 1 /* Removed */ ,
                doc: f
            }), d = !0, (a || c) && (
            // A doc was removed from a full limit query. We'll need to
            // requery from the local cache to see if we know about some other
            // doc that should be in the results.
            s = !0)), d && (h ? (u = u.add(h), o = p ? o.add(t) : o.delete(t)) : (u = u.delete(t), 
            o = o.delete(t)));
        })), ie(this.query) || oe(this.query)) for (;u.size > this.query.limit; ) {
            var f = ie(this.query) ? u.last() : u.first();
            u = u.delete(f.key), o = o.delete(f.key), r.track({
                type: 1 /* Removed */ ,
                doc: f
            });
        }
        return {
            _l: u,
            wl: r,
            _c: s,
            Ce: o
        };
    }, t.prototype.El = function(t, e) {
        // We suppress the initial change event for documents that were modified as
        // part of a write acknowledgment (e.g. when the value of a server transform
        // is applied) as Watch will send us the same document again.
        // By suppressing the event, we only raise two user visible events (one with
        // `hasPendingWrites` and the final state of the document) instead of three
        // (one with `hasPendingWrites`, the modified document with
        // `hasPendingWrites` and the final state of the document).
        return t.bt && e.hasCommittedMutations && !e.bt;
    }, 
    /**
     * Updates the view with the given ViewDocumentChanges and optionally updates
     * limbo docs and sync state from the provided target change.
     * @param docChanges - The set of changes to make to the view's docs.
     * @param updateLimboDocuments - Whether to update limbo documents based on
     *        this change.
     * @param targetChange - A target change to apply for computing limbo docs and
     *        sync state.
     * @returns A new ViewChange with the given docs, changes, and sync state.
     */
    // PORTING NOTE: The iOS/Android clients always compute limbo document changes.
    t.prototype.Ei = function(t, e, n) {
        var r = this, i = this._l;
        this._l = t._l, this.Ce = t.Ce;
        // Sort changes based on type and query comparator
        var o = t.wl.Se();
        o.sort((function(t, e) {
            return function(t, e) {
                var n = function(t) {
                    switch (t) {
                      case 0 /* Added */ :
                        return 1;

                      case 2 /* Modified */ :
                      case 3 /* Metadata */ :
                        // A metadata change is converted to a modified change at the public
                        // api layer.  Since we sort by document key and then change type,
                        // metadata and modified changes must be sorted equivalently.
                        return 2;

                      case 1 /* Removed */ :
                        return 0;

                      default:
                        return A();
                    }
                };
                return n(t) - n(e);
            }(t.type, e.type) || r.ll(t.doc, e.doc);
        })), this.Tl(n);
        var u = e ? this.Il() : [], s = 0 === this.hl.size && this.qe ? 1 /* Synced */ : 0 /* Local */ , a = s !== this.ul;
        return this.ul = s, 0 !== o.length || a ? {
            snapshot: new En(this.query, t._l, i, o, t.Ce, 0 /* Local */ === s, a, 
            /* excludesMetadataChanges= */ !1),
            ml: u
        } : {
            ml: u
        };
        // no changes
        }, 
    /**
     * Applies an OnlineState change to the view, potentially generating a
     * ViewChange if the view's syncState changes as a result.
     */
    t.prototype.zh = function(t) {
        return this.qe && "Offline" /* Offline */ === t ? (
        // If we're offline, set `current` to false and then call applyChanges()
        // to refresh our syncState and generate a ViewChange as appropriate. We
        // are guaranteed to get a new TargetChange that sets `current` back to
        // true once the client is back online.
        this.qe = !1, this.Ei({
            _l: this._l,
            wl: new _n,
            Ce: this.Ce,
            _c: !1
        }, 
        /* updateLimboDocuments= */ !1)) : {
            ml: []
        };
    }, 
    /**
     * Returns whether the doc for the given key should be in limbo.
     */
    t.prototype.Al = function(t) {
        // If the remote end says it's part of this query, it's not in limbo.
        return !this.al.has(t) && 
        // The local store doesn't think it's a result, so it shouldn't be in limbo.
        !!this._l.has(t) && !this._l.get(t).bt;
    }, 
    /**
     * Updates syncedDocuments, current, and limbo docs based on the given change.
     * Returns the list of changes to which docs are in limbo.
     */
    t.prototype.Tl = function(t) {
        var e = this;
        t && (t.Ue.forEach((function(t) {
            return e.al = e.al.add(t);
        })), t.Qe.forEach((function(t) {})), t.Ke.forEach((function(t) {
            return e.al = e.al.delete(t);
        })), this.qe = t.qe);
    }, t.prototype.Il = function() {
        var t = this;
        // We can only determine limbo documents when we're in-sync with the server.
                if (!this.qe) return [];
        // TODO(klimt): Do this incrementally so that it's not quadratic when
        // updating many documents.
                var e = this.hl;
        this.hl = gn(), this._l.forEach((function(e) {
            t.Al(e.key) && (t.hl = t.hl.add(e.key));
        }));
        // Diff the new limbo docs with the old limbo docs.
        var n = [];
        return e.forEach((function(e) {
            t.hl.has(e) || n.push(new Yi(e));
        })), this.hl.forEach((function(t) {
            e.has(t) || n.push(new Qi(t));
        })), n;
    }, 
    /**
     * Update the in-memory state of the current view with the state read from
     * persistence.
     *
     * We update the query view whenever a client's primary status changes:
     * - When a client transitions from primary to secondary, it can miss
     *   LocalStorage updates and its query views may temporarily not be
     *   synchronized with the state on disk.
     * - For secondary to primary transitions, the client needs to update the list
     *   of `syncedDocuments` since secondary clients update their query views
     *   based purely on synthesized RemoteEvents.
     *
     * @param queryResult.documents - The documents that match the query according
     * to the LocalStore.
     * @param queryResult.remoteKeys - The keys of the documents that match the
     * query according to the backend.
     *
     * @returns The ViewChange that resulted from this synchronization.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Rl = function(t) {
        this.al = t.Pc, this.hl = gn();
        var e = this.dl(t.documents);
        return this.Ei(e, /*updateLimboDocuments=*/ !0);
    }, 
    /**
     * Returns a view snapshot as if this query was just listened to. Contains
     * a document add for every existing document and the `fromCache` and
     * `hasPendingWrites` status of the already established view.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Pl = function() {
        return En.Fe(this.query, this._l, this.Ce, 0 /* Local */ === this.ul);
    }, t;
}(), Zi = function(
/**
     * The query itself.
     */
t, 
/**
     * The target number created by the client that is used in the watch
     * stream to identify this query.
     */
e, 
/**
     * The view is responsible for computing the final merged truth of what
     * docs are in the query. It gets notified of local and remote changes,
     * and applies the query filters and limits to determine the most correct
     * possible results.
     */
n) {
    this.query = t, this.targetId = e, this.view = n;
}, $i = function(t) {
    this.key = t, 
    /**
             * Set to true once we've received a document. This is used in
             * getRemoteKeysForTarget() and ultimately used by WatchChangeAggregator to
             * decide whether it needs to manufacture a delete event for the target once
             * the target is CURRENT.
             */
    this.yl = !1;
}, to = /** @class */ function() {
    function t(t, e, n, 
    // PORTING NOTE: Manages state synchronization in multi-tab environments.
    r, i, o) {
        this.Sh = t, this.gl = e, this.Vl = n, this.pl = r, this.currentUser = i, this.bl = o, 
        this.vl = {}, this.Sl = new _r((function(t) {
            return pe(t);
        }), le), this.Dl = new Map, 
        /**
             * The keys of documents that are in limbo for which we haven't yet started a
             * limbo resolution query.
             */
        this.Cl = [], 
        /**
             * Keeps track of the target ID for each document that is in limbo with an
             * active target.
             */
        this.xl = new rn(nt.J), 
        /**
             * Keeps track of the information about an active limbo resolution for each
             * active target ID that was started for the purpose of limbo resolution.
             */
        this.Nl = new Map, this.Fl = new jr, 
        /** Stores user completion handlers, indexed by User and BatchId. */
        this.Ol = {}, 
        /** Stores user callbacks waiting for all pending writes to be acknowledged. */
        this.kl = new Map, this.Ml = Ir.Bi(), this.onlineState = "Unknown" /* Unknown */ , 
        // The primary state is set to `true` or `false` immediately after Firestore
        // startup. In the interim, a client should only be considered primary if
        // `isPrimary` is true.
        this.Ll = void 0;
    }
    return Object.defineProperty(t.prototype, "$l", {
        get: function() {
            return !0 === this.Ll;
        },
        enumerable: !1,
        configurable: !0
    }), t;
}();

/**
 * Initiates the new listen, resolves promise when listen enqueued to the
 * server. All the subsequent view snapshots or errors are sent to the
 * subscribed handlers. Returns the initial snapshot.
 */
function eo(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r, i, o, u, s;
        return g(this, (function(a) {
            switch (a.label) {
              case 0:
                return n = function(t) {
                    var e = D(t);
                    return e.gl.Ch.Bh = oo.bind(null, e), e.gl.Ch.Sn = _o.bind(null, e), e.gl.Ch.$h = so.bind(null, e), 
                    e.vl.uh = ji.bind(null, e.Vl), e.vl.ql = zi.bind(null, e.Vl), e;
                }(t), (o = n.Sl.get(e)) ? (
                // PORTING NOTE: With Multi-Tab Web, it is possible that a query view
                // already exists when EventManager calls us for the first time. This
                // happens when the primary tab is already listening to this query on
                // behalf of another tab and the user of the primary also starts listening
                // to the query. EventManager will not have an assigned target ID in this
                // case and calls `listen` to obtain this ID.
                r = o.targetId, n.pl.ka(r), i = o.view.Pl(), [ 3 /*break*/ , 4 ]) : [ 3 /*break*/ , 1 ];

              case 1:
                return [ 4 /*yield*/ , Pr(n.Sh, fe(e)) ];

              case 2:
                return u = a.sent(), s = n.pl.ka(u.targetId), r = u.targetId, [ 4 /*yield*/ , no(n, e, r, "current" === s) ];

              case 3:
                i = a.sent(), n.$l && di(n.gl, u), a.label = 4;

              case 4:
                return [ 2 /*return*/ , i ];
            }
        }));
    }));
}

/**
 * Registers a view for a previously unknown query and computes its initial
 * snapshot.
 */ function no(t, e, n, r) {
    return y(this, void 0, void 0, (function() {
        var i, o, u, s, a, c;
        return g(this, (function(f) {
            switch (f.label) {
              case 0:
                // PORTING NOTE: On Web only, we inject the code that registers new Limbo
                // targets based on view changes. This allows us to only depend on Limbo
                // changes when user code includes queries.
                return t.Bl = function(e, n, r) {
                    return function(t, e, n, r) {
                        return y(this, void 0, void 0, (function() {
                            var i, o, u;
                            return g(this, (function(s) {
                                switch (s.label) {
                                  case 0:
                                    return i = e.view.dl(n), i._c ? [ 4 /*yield*/ , xr(t.Sh, e.query, 
                                    /* usePreviousResults= */ !1).then((function(t) {
                                        var n = t.documents;
                                        return e.view.dl(n, i);
                                    })) ] : [ 3 /*break*/ , 2 ];

                                  case 1:
                                    // The query has a limit and some docs were removed, so we need
                                    // to re-run the query against the local store to make sure we
                                    // didn't lose any good docs that had been past the limit.
                                    i = s.sent(), s.label = 2;

                                  case 2:
                                    return o = r && r.Oe.get(e.targetId), u = e.view.Ei(i, 
                                    /* updateLimboDocuments= */ t.$l, o), [ 2 /*return*/ , (yo(t, e.targetId, u.ml), 
                                    u.snapshot) ];
                                }
                            }));
                        }));
                    }(t, e, n, r);
                }, [ 4 /*yield*/ , xr(t.Sh, e, 
                /* usePreviousResults= */ !0) ];

              case 1:
                return i = f.sent(), o = new Xi(e, i.Pc), u = o.dl(i.documents), s = Tn.Be(n, r && "Offline" /* Offline */ !== t.onlineState), 
                a = o.Ei(u, 
                /* updateLimboDocuments= */ t.$l, s), yo(t, n, a.ml), c = new Zi(e, n, o), [ 2 /*return*/ , (t.Sl.set(e, c), 
                t.Dl.has(n) ? t.Dl.get(n).push(e) : t.Dl.set(n, [ e ]), a.snapshot) ];
            }
        }));
    }));
}

/** Stops listening to the query. */ function ro(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r, i;
        return g(this, (function(o) {
            switch (o.label) {
              case 0:
                return n = D(t), r = n.Sl.get(e), (i = n.Dl.get(r.targetId)).length > 1 ? [ 2 /*return*/ , (n.Dl.set(r.targetId, i.filter((function(t) {
                    return !le(t, e);
                }))), void n.Sl.delete(e)) ] : n.$l ? (
                // We need to remove the local query target first to allow us to verify
                // whether any other client is still interested in this target.
                n.pl.La(r.targetId), n.pl.Ca(r.targetId) ? [ 3 /*break*/ , 2 ] : [ 4 /*yield*/ , Ur(n.Sh, r.targetId, 
                /*keepPersistedTargetData=*/ !1).then((function() {
                    n.pl.Ba(r.targetId), vi(n.gl, r.targetId), po(n, r.targetId);
                })).catch(br) ]) : [ 3 /*break*/ , 3 ];

              case 1:
                o.sent(), o.label = 2;

              case 2:
                return [ 3 /*break*/ , 5 ];

              case 3:
                return po(n, r.targetId), [ 4 /*yield*/ , Ur(n.Sh, r.targetId, 
                /*keepPersistedTargetData=*/ !0) ];

              case 4:
                o.sent(), o.label = 5;

              case 5:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Initiates the write of local mutation batch which involves adding the
 * writes to the mutation queue, notifying the remote store about new
 * mutations and raising events for any changes this write caused.
 *
 * The promise returned by this call is resolved when the above steps
 * have completed, *not* when the write was acked by the backend. The
 * userCallback is resolved once the write was acked/rejected by the
 * backend (or failed locally for any other reason).
 */ function io(t, e, n) {
    return y(this, void 0, void 0, (function() {
        var r, i, o, u;
        return g(this, (function(s) {
            switch (s.label) {
              case 0:
                r = function(t) {
                    var e = D(t);
                    return e.gl.Ch.qh = ao.bind(null, e), e.gl.Ch.Uh = co.bind(null, e), e
                    /**
 * Loads a Firestore bundle into the SDK. The returned promise resolves when
 * the bundle finished loading.
 *
 * @param syncEngine - SyncEngine to use.
 * @param bundleReader - Bundle to load into the SDK.
 * @param task - LoadBundleTask used to update the loading progress to public API.
 */;
                }(t), s.label = 1;

              case 1:
                return s.trys.push([ 1, 5, , 6 ]), [ 4 /*yield*/ , function(t, e) {
                    var n, r = D(t), i = Y.now(), o = e.reduce((function(t, e) {
                        return t.add(e.key);
                    }), gn());
                    return r.persistence.runTransaction("Locally write mutations", "readwrite", (function(t) {
                        return r.Ic.Zo(t, o).next((function(o) {
                            n = o;
                            for (
                            // For non-idempotent mutations (such as `FieldValue.increment()`),
                            // we record the base state in a separate patch mutation. This is
                            // later used to guarantee consistent values and prevents flicker
                            // even if the backend sends us an update that already includes our
                            // transform.
                            var u = [], s = 0, a = e; s < a.length; s++) {
                                var c = a[s], f = je(c, n.get(c.key));
                                null != f && 
                                // NOTE: The base state should only be applied if there's some
                                // existing document to override, so use a Precondition of
                                // exists=true
                                u.push(new Be(c.key, f, Ct(f.proto.mapValue), Ue.exists(!0)));
                            }
                            return r.Ho.Pi(t, i, u, e);
                        }));
                    })).then((function(t) {
                        var e = t.Ns(n);
                        return {
                            batchId: t.batchId,
                            oi: e
                        };
                    }));
                }(r.Sh, e) ];

              case 2:
                return i = s.sent(), r.pl.xa(i.batchId), function(t, e, n) {
                    var r = t.Ol[t.currentUser.R()];
                    r || (r = new rn(C)), r = r.Ht(e, n), t.Ol[t.currentUser.R()] = r;
                }(r, i.batchId, n), [ 4 /*yield*/ , wo(r, i.oi) ];

              case 3:
                return s.sent(), [ 4 /*yield*/ , Si(r.gl) ];

              case 4:
                return s.sent(), [ 3 /*break*/ , 6 ];

              case 5:
                return o = s.sent(), u = lr(o, "Failed to persist write"), n.reject(u), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Applies one remote event to the sync engine, notifying any views of the
 * changes, and releasing any pending mutation batches that would become
 * visible because of the snapshot version the remote event contains.
 */ function oo(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r;
        return g(this, (function(i) {
            switch (i.label) {
              case 0:
                n = D(t), i.label = 1;

              case 1:
                return i.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , Lr(n.Sh, e) ];

              case 2:
                return r = i.sent(), 
                // Update `receivedDocument` as appropriate for any limbo targets.
                e.Oe.forEach((function(t, e) {
                    var r = n.Nl.get(e);
                    r && (
                    // Since this is a limbo resolution lookup, it's for a single document
                    // and it could be added, modified, or removed, but not a combination.
                    S(t.Ue.size + t.Qe.size + t.Ke.size <= 1), t.Ue.size > 0 ? r.yl = !0 : t.Qe.size > 0 ? S(r.yl) : t.Ke.size > 0 && (S(r.yl), 
                    r.yl = !1));
                })), [ 4 /*yield*/ , wo(n, r, e) ];

              case 3:
                // Update `receivedDocument` as appropriate for any limbo targets.
                return i.sent(), [ 3 /*break*/ , 6 ];

              case 4:
                return [ 4 /*yield*/ , br(i.sent()) ];

              case 5:
                return i.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Applies an OnlineState change to the sync engine and notifies any views of
 * the change.
 */ function uo(t, e, n) {
    var r = D(t);
    // If we are the secondary client, we explicitly ignore the remote store's
    // online state (the local client may go offline, even though the primary
    // tab remains online) and only apply the primary tab's online state from
    // SharedClientState.
        if (r.$l && 0 /* RemoteStore */ === n || !r.$l && 1 /* SharedClientState */ === n) {
        var i = [];
        r.Sl.forEach((function(t, n) {
            var r = n.view.zh(e);
            r.snapshot && i.push(r.snapshot);
        })), function(t, e) {
            var n = D(t);
            n.onlineState = e;
            var r = !1;
            n.queries.forEach((function(t, n) {
                for (var i = 0, o = n.listeners; i < o.length; i++) {
                    // Run global snapshot listeners if a consistent snapshot has been emitted.
                    o[i].zh(e) && (r = !0);
                }
            })), r && Gi(n);
        }(r.Vl, e), i.length && r.vl.uh(i), r.onlineState = e, r.$l && r.pl.Ka(e);
    }
}

/**
 * Rejects the listen for the given targetID. This can be triggered by the
 * backend for any active target.
 *
 * @param syncEngine - The sync engine implementation.
 * @param targetId - The targetID corresponds to one previously initiated by the
 * user as part of TargetData passed to listen() on RemoteStore.
 * @param err - A description of the condition that has forced the rejection.
 * Nearly always this will be an indication that the user is no longer
 * authorized to see the data matching the target.
 */ function so(t, e, n) {
    return y(this, void 0, void 0, (function() {
        var r, i, o, u, s, a;
        return g(this, (function(c) {
            switch (c.label) {
              case 0:
                // PORTING NOTE: Multi-tab only.
                return (r = D(t)).pl.qa(e, "rejected", n), i = r.Nl.get(e), (o = i && i.key) ? (u = (u = new rn(nt.J)).Ht(o, new Rt(o, X.min())), 
                s = gn().add(o), a = new In(X.min(), 
                /* targetChanges= */ new Map, 
                /* targetMismatches= */ new sn(C), u, s), [ 4 /*yield*/ , oo(r, a) ]) : [ 3 /*break*/ , 2 ];

              case 1:
                return c.sent(), 
                // Since this query failed, we won't want to manually unlisten to it.
                // We only remove it from bookkeeping after we successfully applied the
                // RemoteEvent. If `applyRemoteEvent()` throws, we want to re-listen to
                // this query when the RemoteStore restarts the Watch stream, which should
                // re-trigger the target failure.
                r.xl = r.xl.remove(o), r.Nl.delete(e), mo(r), [ 3 /*break*/ , 4 ];

              case 2:
                return [ 4 /*yield*/ , Ur(r.Sh, e, 
                /* keepPersistedTargetData */ !1).then((function() {
                    return po(r, e, n);
                })).catch(br) ];

              case 3:
                c.sent(), c.label = 4;

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function ao(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r, i;
        return g(this, (function(o) {
            switch (o.label) {
              case 0:
                n = D(t), r = e.batch.batchId, o.label = 1;

              case 1:
                return o.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , Or(n.Sh, e) ];

              case 2:
                return i = o.sent(), 
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught
                // up), so we raise user callbacks first so that they consistently happen
                // before listen events.
                lo(n, r, /*error=*/ null), ho(n, r), n.pl.Fa(r, "acknowledged"), [ 4 /*yield*/ , wo(n, i) ];

              case 3:
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught
                // up), so we raise user callbacks first so that they consistently happen
                // before listen events.
                return o.sent(), [ 3 /*break*/ , 6 ];

              case 4:
                return [ 4 /*yield*/ , br(o.sent()) ];

              case 5:
                return o.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function co(t, e, n) {
    return y(this, void 0, void 0, (function() {
        var r, i;
        return g(this, (function(o) {
            switch (o.label) {
              case 0:
                r = D(t), o.label = 1;

              case 1:
                return o.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , function(t, e) {
                    var n = D(t);
                    return n.persistence.runTransaction("Reject batch", "readwrite-primary", (function(t) {
                        var r;
                        return n.Ho.yi(t, e).next((function(e) {
                            return S(null !== e), r = e.keys(), n.Ho.xi(t, e);
                        })).next((function() {
                            return n.Ho.Oi(t);
                        })).next((function() {
                            return n.Ic.Zo(t, r);
                        }));
                    }));
                }(r.Sh, e) ];

              case 2:
                return i = o.sent(), 
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught up),
                // so we raise user callbacks first so that they consistently happen before
                // listen events.
                lo(r, e, n), ho(r, e), r.pl.Fa(e, "rejected", n), [ 4 /*yield*/ , wo(r, i) ];

              case 3:
                // The local store may or may not be able to apply the write result and
                // raise events immediately (depending on whether the watcher is caught up),
                // so we raise user callbacks first so that they consistently happen before
                // listen events.
                return o.sent(), [ 3 /*break*/ , 6 ];

              case 4:
                return [ 4 /*yield*/ , br(o.sent()) ];

              case 5:
                return o.sent(), [ 3 /*break*/ , 6 ];

              case 6:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Registers a user callback that resolves when all pending mutations at the moment of calling
 * are acknowledged .
 */ function fo(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r, i, o, u;
        return g(this, (function(s) {
            switch (s.label) {
              case 0:
                bi((n = D(t)).gl) || E("SyncEngine", "The network is disabled. The task returned by 'awaitPendingWrites()' will not complete until the network is enabled."), 
                s.label = 1;

              case 1:
                return s.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , function(t) {
                    var e = D(t);
                    return e.persistence.runTransaction("Get highest unacknowledged batch id", "readonly", (function(t) {
                        return e.Ho.pi(t);
                    }));
                }(n.Sh) ];

              case 2:
                return -1 === (r = s.sent()) ? [ 2 /*return*/ , void e.resolve() ] : ((i = n.kl.get(r) || []).push(e), 
                n.kl.set(r, i), [ 3 /*break*/ , 4 ]);

              case 3:
                return o = s.sent(), u = lr(o, "Initialization of waitForPendingWrites() operation failed"), 
                e.reject(u), [ 3 /*break*/ , 4 ];

              case 4:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * Triggers the callbacks that are waiting for this batch id to get acknowledged by server,
 * if there are any.
 */ function ho(t, e) {
    (t.kl.get(e) || []).forEach((function(t) {
        t.resolve();
    })), t.kl.delete(e)
    /** Reject all outstanding callbacks waiting for pending writes to complete. */;
}

function lo(t, e, n) {
    var r = D(t), i = r.Ol[r.currentUser.R()];
    // NOTE: Mutations restored from persistence won't have callbacks, so it's
    // okay for there to be no callback for this ID.
    if (i) {
        var o = i.get(e);
        o && (n ? o.reject(n) : o.resolve(), i = i.remove(e)), r.Ol[r.currentUser.R()] = i;
    }
}

function po(t, e, n) {
    void 0 === n && (n = null), t.pl.La(e);
    for (var r = 0, i = t.Dl.get(e); r < i.length; r++) {
        var o = i[r];
        t.Sl.delete(o), n && t.vl.ql(o, n);
    }
    t.Dl.delete(e), t.$l && t.Fl.kc(e).forEach((function(e) {
        t.Fl.ki(e) || 
        // We removed the last reference for this key
        vo(t, e);
    }));
}

function vo(t, e) {
    // It's possible that the target already got removed because the query failed. In that case,
    // the key won't exist in `limboTargetsByKey`. Only do the cleanup if we still have the target.
    var n = t.xl.get(e);
    null !== n && (vi(t.gl, n), t.xl = t.xl.remove(e), t.Nl.delete(n), mo(t));
}

function yo(t, e, n) {
    for (var r = 0, i = n; r < i.length; r++) {
        var o = i[r];
        o instanceof Qi ? (t.Fl.sr(o.key, e), go(t, o)) : o instanceof Yi ? (E("SyncEngine", "Document no longer in limbo: " + o.key), 
        t.Fl.rr(o.key, e), t.Fl.ki(o.key) || 
        // We removed the last reference for this key
        vo(t, o.key)) : A();
    }
}

function go(t, e) {
    var n = e.key;
    t.xl.get(n) || (E("SyncEngine", "New document in limbo: " + n), t.Cl.push(n), mo(t));
}

/**
 * Starts listens for documents in limbo that are enqueued for resolution,
 * subject to a maximum number of concurrent resolutions.
 *
 * Without bounding the number of concurrent resolutions, the server can fail
 * with "resource exhausted" errors which can lead to pathological client
 * behavior as seen in https://github.com/firebase/firebase-js-sdk/issues/2683.
 */ function mo(t) {
    for (;t.Cl.length > 0 && t.xl.size < t.bl; ) {
        var e = t.Cl.shift(), n = t.Ml.next();
        t.Nl.set(n, new $i(e)), t.xl = t.xl.Ht(e, n), di(t.gl, new me(fe(re(e.path)), n, 2 /* LimboResolution */ , Q.U));
    }
}

function wo(t, e, n) {
    return y(this, void 0, void 0, (function() {
        var r, i, o, u;
        return g(this, (function(s) {
            switch (s.label) {
              case 0:
                return r = D(t), i = [], o = [], u = [], r.Sl.nt() ? [ 3 /*break*/ , 3 ] : (r.Sl.forEach((function(t, s) {
                    u.push(r.Bl(s, e, n).then((function(t) {
                        if (t) {
                            r.$l && r.pl.qa(s.targetId, t.fromCache ? "not-current" : "current"), i.push(t);
                            var e = Ar.cc(s.targetId, t);
                            o.push(e);
                        }
                    })));
                })), [ 4 /*yield*/ , Promise.all(u) ]);

              case 1:
                return s.sent(), r.vl.uh(i), [ 4 /*yield*/ , function(t, e) {
                    return y(this, void 0, void 0, (function() {
                        var n, r, i, o, u, s, a, c, f;
                        return g(this, (function(h) {
                            switch (h.label) {
                              case 0:
                                n = D(t), h.label = 1;

                              case 1:
                                return h.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , n.persistence.runTransaction("notifyLocalViewChanges", "readwrite", (function(t) {
                                    return cr.forEach(e, (function(e) {
                                        return cr.forEach(e.rc, (function(r) {
                                            return n.persistence.Ii.sr(t, e.targetId, r);
                                        })).next((function() {
                                            return cr.forEach(e.oc, (function(r) {
                                                return n.persistence.Ii.rr(t, e.targetId, r);
                                            }));
                                        }));
                                    }));
                                })) ];

                              case 2:
                                return h.sent(), [ 3 /*break*/ , 4 ];

                              case 3:
                                if (!fr(r = h.sent())) throw r;
                                // If `notifyLocalViewChanges` fails, we did not advance the sequence
                                // number for the documents that were included in this transaction.
                                // This might trigger them to be deleted earlier than they otherwise
                                // would have, but it should not invalidate the integrity of the data.
                                                                return E("LocalStore", "Failed to update sequence numbers: " + r), 
                                [ 3 /*break*/ , 4 ];

                              case 4:
                                for (i = 0, o = e; i < o.length; i++) u = o[i], s = u.targetId, u.fromCache || (a = n.dc.get(s), 
                                c = a.Mt, f = a.Bt(c), 
                                // Advance the last limbo free snapshot version
                                n.dc = n.dc.Ht(s, f));
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                }(r.Sh, o) ];

              case 2:
                s.sent(), s.label = 3;

              case 3:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function bo(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r;
        return g(this, (function(i) {
            switch (i.label) {
              case 0:
                return (n = D(t)).currentUser.isEqual(e) ? [ 3 /*break*/ , 3 ] : (E("SyncEngine", "User change. New user:", e.R()), 
                [ 4 /*yield*/ , kr(n.Sh, e) ]);

              case 1:
                return r = i.sent(), n.currentUser = e, 
                // Fails tasks waiting for pending writes requested by previous user.
                function(t, e) {
                    t.kl.forEach((function(t) {
                        t.forEach((function(t) {
                            t.reject(new P(R.CANCELLED, "'waitForPendingWrites' promise is rejected due to a user change."));
                        }));
                    })), t.kl.clear();
                }(n), 
                // TODO(b/114226417): Consider calling this only in the primary tab.
                n.pl.Qa(e, r.Ac, r.Rc), [ 4 /*yield*/ , wo(n, r.mc) ];

              case 2:
                i.sent(), i.label = 3;

              case 3:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function _o(t, e) {
    var n = D(t), r = n.Nl.get(e);
    if (r && r.yl) return gn().add(r.key);
    var i = gn(), o = n.Dl.get(e);
    if (!o) return i;
    for (var u = 0, s = o; u < s.length; u++) {
        var a = s[u], c = n.Sl.get(a);
        i = i.ye(c.view.fl);
    }
    return i;
}

function Eo(t, e, n) {
    var r = D(t);
    // eslint-disable-next-line @typescript-eslint/no-floating-promises
        (function(t, e, n) {
        return y(this, void 0, void 0, (function() {
            var r, i, o, u, s, a;
            return g(this, (function(c) {
                switch (c.label) {
                  case 0:
                    return c.trys.push([ 0, 14, , 15 ]), [ 4 /*yield*/ , e.getMetadata() ];

                  case 1:
                    return r = c.sent(), [ 4 /*yield*/ , function(t, e) {
                        var n = D(t), r = qn(e.createTime);
                        return n.persistence.runTransaction("hasNewerBundle", "readonly", (function(t) {
                            return n.Eo.Ms(t, e.id);
                        })).then((function(t) {
                            return !!t && t.createTime.u(r) >= 0;
                        }));
                    }(t.Sh, r) ];

                  case 2:
                    return c.sent() ? [ 4 /*yield*/ , e.close() ] : [ 3 /*break*/ , 4 ];

                  case 3:
                    return [ 2 /*return*/ , (c.sent(), void n.Ul(function(t) {
                        return {
                            taskState: "Success",
                            documentsLoaded: t.totalDocuments,
                            bytesLoaded: t.totalBytes,
                            totalDocuments: t.totalDocuments,
                            totalBytes: t.totalBytes
                        };
                    }(r))) ];

                  case 4:
                    return n.Ql(Wi(r)), i = new Ji(r, t.Sh, e.Kt), [ 4 /*yield*/ , e.Kl() ];

                  case 5:
                    o = c.sent(), c.label = 6;

                  case 6:
                    return o ? [ 4 /*yield*/ , i.ol(o) ] : [ 3 /*break*/ , 10 ];

                  case 7:
                    return (u = c.sent()) && n.Ql(u), [ 4 /*yield*/ , e.Kl() ];

                  case 8:
                    o = c.sent(), c.label = 9;

                  case 9:
                    return [ 3 /*break*/ , 6 ];

                  case 10:
                    return [ 4 /*yield*/ , i.complete() ];

                  case 11:
                    // TODO(b/160876443): This currently raises snapshots with
                    // `fromCache=false` if users already listen to some queries and bundles
                    // has newer version.
                    return s = c.sent(), [ 4 /*yield*/ , wo(t, s.zo, 
                    /* remoteEvent */ void 0) ];

                  case 12:
                    // Save metadata, so loading the same bundle will skip.
                    // TODO(b/160876443): This currently raises snapshots with
                    // `fromCache=false` if users already listen to some queries and bundles
                    // has newer version.
                    return c.sent(), [ 4 /*yield*/ , function(t, e) {
                        var n = D(t);
                        return n.persistence.runTransaction("Save bundle", "readwrite", (function(t) {
                            return n.Eo.Ls(t, e);
                        }));
                    }(t.Sh, r) ];

                  case 13:
                    // TODO(b/160876443): This currently raises snapshots with
                    // `fromCache=false` if users already listen to some queries and bundles
                    // has newer version.
                    // Save metadata, so loading the same bundle will skip.
                    return c.sent(), n.Ul(s.progress), [ 3 /*break*/ , 15 ];

                  case 14:
                    return T("SyncEngine", "Loading bundle failed with " + (a = c.sent())), n.Wl(a), 
                    [ 3 /*break*/ , 15 ];

                  case 15:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * Provides all components needed for Firestore with in-memory persistence.
 * Uses EagerGC garbage collection.
 */)(r, e, n).then((function() {
        r.pl.ja();
    }));
}

var Io = /** @class */ function() {
    function t() {
        this.synchronizeTabs = !1;
    }
    return t.prototype.initialize = function(t) {
        return y(this, void 0, void 0, (function() {
            return g(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return this.Kt = ii(t.gu.T), this.pl = this.jl(t), this.persistence = this.Gl(t), 
                    [ 4 /*yield*/ , this.persistence.start() ];

                  case 1:
                    return e.sent(), this.zl = this.Hl(t), this.Sh = this.Jl(t), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Hl = function(t) {
        return null;
    }, t.prototype.Jl = function(t) {
        return function(
        /** Manages our in-memory or durable persistence. */
        t, e, n, r) {
            return new Dr(t, e, n, r);
        }(this.persistence, new Sr, t.Yl, this.Kt);
    }, t.prototype.Gl = function(t) {
        return new Jr(Qr.ra, this.Kt);
    }, t.prototype.jl = function(t) {
        return new Xr;
    }, t.prototype.terminate = function() {
        return y(this, void 0, void 0, (function() {
            return g(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.zl && this.zl.stop(), [ 4 /*yield*/ , this.pl.Lo() ];

                  case 1:
                    return t.sent(), [ 4 /*yield*/ , this.persistence.Lo() ];

                  case 2:
                    return t.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t;
}(), To = /** @class */ function() {
    function t() {}
    return t.prototype.initialize = function(t, e) {
        return y(this, void 0, void 0, (function() {
            var n = this;
            return g(this, (function(r) {
                switch (r.label) {
                  case 0:
                    return this.Sh ? [ 3 /*break*/ , 2 ] : (this.Sh = t.Sh, this.pl = t.pl, this.Dh = this.Zl(e), 
                    this.gl = this.t_(e), this.Vl = this.e_(e), this.fa = this.n_(e, 
                    /* startAsPrimary=*/ !t.synchronizeTabs), this.pl.da = function(t) {
                        return uo(n.fa, t, 1 /* SharedClientState */);
                    }, this.gl.Ch.s_ = bo.bind(null, this.fa), [ 4 /*yield*/ , Ri(this.gl, this.fa.$l) ]);

                  case 1:
                    r.sent(), r.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.e_ = function(t) {
        return new qi;
    }, t.prototype.Zl = function(t) {
        var e, n = ii(t.gu.T), r = (e = t.gu, new ni(e));
        /** Return the Platform-specific connectivity monitor. */ return function(t, e, n) {
            return new ci(t, e, n);
        }(t.credentials, r, n);
    }, t.prototype.t_ = function(t) {
        var e, n, r, i, o, u = this;
        return e = this.Sh, n = this.Dh, r = t.fs, i = function(t) {
            return uo(u.fa, t, 0 /* RemoteStore */);
        }, o = $r.Wn() ? new $r : new Zr, new hi(e, n, r, i, o);
    }, t.prototype.n_ = function(t, e) {
        return function(t, e, n, 
        // PORTING NOTE: Manages state synchronization in multi-tab environments.
        r, i, o, u) {
            var s = new to(t, e, n, r, i, o);
            return u && (s.Ll = !0), s;
        }(this.Sh, this.gl, this.Vl, this.pl, t.Yl, t.bl, e);
    }, t.prototype.terminate = function() {
        return function(t) {
            return y(this, void 0, void 0, (function() {
                var e;
                return g(this, (function(n) {
                    switch (n.label) {
                      case 0:
                        return e = D(t), E("RemoteStore", "RemoteStore shutting down."), e.Fh.add(5 /* Shutdown */), 
                        [ 4 /*yield*/ , pi(e) ];

                      case 1:
                        return n.sent(), e.kh.Lo(), 
                        // Set the OnlineState to Unknown (rather than Offline) to avoid potentially
                        // triggering spurious listener events with cached data, etc.
                        e.Mh.set("Unknown" /* Unknown */), [ 2 /*return*/ ];
                    }
                }));
            }));
        }(this.gl);
    }, t;
}();

/**
 * Initializes and wires the components that are needed to interface with the
 * network.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * How many bytes to read each time when `ReadableStreamReader.read()` is
 * called. Only applicable for byte streams that we control (e.g. those backed
 * by an UInt8Array).
 */
/**
 * Builds a `ByteStreamReader` from a UInt8Array.
 * @param source - The data source to use.
 * @param bytesPerRead - How many bytes each `read()` from the returned reader
 *        will read.
 */
function No(t, e) {
    void 0 === e && (e = 10240);
    var n = 0;
    return {
        read: function() {
            return y(this, void 0, void 0, (function() {
                var r;
                return g(this, (function(i) {
                    return n < t.byteLength ? (r = {
                        value: t.slice(n, n + e),
                        done: !1
                    }, [ 2 /*return*/ , (n += e, r) ]) : [ 2 /*return*/ , {
                        done: !0
                    } ];
                    // TypesScript's lib.dom.d.ts doesn't have proper typings of
                    // ReadableStreamReadResult yet.
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                                }));
            }));
        },
        cancel: function() {
            return y(this, void 0, void 0, (function() {
                return g(this, (function(t) {
                    return [ 2 /*return*/ ];
                }));
            }));
        },
        releaseLock: function() {}
    };
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * On web, a `ReadableStream` is wrapped around by a `ByteStreamReader`.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * A wrapper implementation of Observer<T> that will dispatch events
 * asynchronously. To allow immediate silencing, a mute call is added which
 * causes events scheduled to no longer be raised.
 */ var Ao = /** @class */ function() {
    function t(t) {
        this.observer = t, 
        /**
             * When set to true, will not raise future events. Necessary to deal with
             * async detachment of listener.
             */
        this.muted = !1;
    }
    return t.prototype.next = function(t) {
        this.observer.next && this.i_(this.observer.next, t);
    }, t.prototype.error = function(t) {
        this.observer.error ? this.i_(this.observer.error, t) : console.error("Uncaught Error in snapshot listener:", t);
    }, t.prototype.r_ = function() {
        this.muted = !0;
    }, t.prototype.i_ = function(t, e) {
        var n = this;
        this.muted || setTimeout((function() {
            n.muted || t(e);
        }), 0);
    }, t;
}(), So = /** @class */ function() {
    function t(
    /** The reader to read from underlying binary bundle data source. */
    t, e) {
        var n = this;
        this.o_ = t, this.Kt = e, 
        /** Cached bundle metadata. */
        this.metadata = new ar, 
        /**
             * Internal buffer to hold bundle content, accumulating incomplete element
             * content.
             */
        this.buffer = new Uint8Array, this.c_ = new TextDecoder("utf-8"), 
        // Read the metadata (which is the first element).
        this.a_().then((function(t) {
            t && t.il() ? n.metadata.resolve(t.payload.metadata) : n.metadata.reject(new Error("The first element of the bundle is not a metadata, it is\n             " + JSON.stringify(null == t ? void 0 : t.payload)));
        }), (function(t) {
            return n.metadata.reject(t);
        }));
    }
    return t.prototype.close = function() {
        return this.o_.cancel();
    }, t.prototype.getMetadata = function() {
        return y(this, void 0, void 0, (function() {
            return g(this, (function(t) {
                return [ 2 /*return*/ , this.metadata.promise ];
            }));
        }));
    }, t.prototype.Kl = function() {
        return y(this, void 0, void 0, (function() {
            return g(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return [ 4 /*yield*/ , this.getMetadata() ];

                  case 1:
                    // Makes sure metadata is read before proceeding.
                    return [ 2 /*return*/ , (t.sent(), this.a_()) ];
                }
            }));
        }));
    }, 
    /**
     * Reads from the head of internal buffer, and pulling more data from
     * underlying stream if a complete element cannot be found, until an
     * element(including the prefixed length and the JSON string) is found.
     *
     * Once a complete element is read, it is dropped from internal buffer.
     *
     * Returns either the bundled element, or null if we have reached the end of
     * the stream.
     */
    t.prototype.a_ = function() {
        return y(this, void 0, void 0, (function() {
            var t, e, n, r;
            return g(this, (function(i) {
                switch (i.label) {
                  case 0:
                    return [ 4 /*yield*/ , this.u_() ];

                  case 1:
                    return null === (t = i.sent()) ? [ 2 /*return*/ , null ] : (e = this.c_.decode(t), 
                    n = Number(e), isNaN(n) && this.h_("length string (" + e + ") is not valid number"), 
                    [ 4 /*yield*/ , this.l_(n) ]);

                  case 2:
                    return r = i.sent(), [ 2 /*return*/ , new Bi(JSON.parse(r), t.length + n) ];
                }
            }));
        }));
    }, 
    /** First index of '{' from the underlying buffer. */ t.prototype.__ = function() {
        return this.buffer.findIndex((function(t) {
            return t === "{".charCodeAt(0);
        }));
    }, 
    /**
     * Reads from the beginning of the internal buffer, until the first '{', and
     * return the content.
     *
     * If reached end of the stream, returns a null.
     */
    t.prototype.u_ = function() {
        return y(this, void 0, void 0, (function() {
            var t, e;
            return g(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.__() < 0 ? [ 4 /*yield*/ , this.f_() ] : [ 3 /*break*/ , 3 ];

                  case 1:
                    if (n.sent()) return [ 3 /*break*/ , 3 ];
                    n.label = 2;

                  case 2:
                    return [ 3 /*break*/ , 0 ];

                  case 3:
                    // Broke out of the loop because underlying stream is closed, and there
                    // happens to be no more data to process.
                    return 0 === this.buffer.length ? [ 2 /*return*/ , null ] : (
                    // Broke out of the loop because underlying stream is closed, but still
                    // cannot find an open bracket.
                    (t = this.__()) < 0 && this.h_("Reached the end of bundle when a length string is expected."), 
                    e = this.buffer.slice(0, t), [ 2 /*return*/ , (this.buffer = this.buffer.slice(t), 
                    e) ]);
                }
            }));
        }));
    }, 
    /**
     * Reads from a specified position from the internal buffer, for a specified
     * number of bytes, pulling more data from the underlying stream if needed.
     *
     * Returns a string decoded from the read bytes.
     */
    t.prototype.l_ = function(t) {
        return y(this, void 0, void 0, (function() {
            var e;
            return g(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.buffer.length < t ? [ 4 /*yield*/ , this.f_() ] : [ 3 /*break*/ , 3 ];

                  case 1:
                    n.sent() && this.h_("Reached the end of bundle when more is expected."), n.label = 2;

                  case 2:
                    return [ 3 /*break*/ , 0 ];

                  case 3:
                    // Update the internal buffer to drop the read json string.
                    return e = this.c_.decode(this.buffer.slice(0, t)), [ 2 /*return*/ , (this.buffer = this.buffer.slice(t), 
                    e) ];
                }
            }));
        }));
    }, t.prototype.h_ = function(t) {
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        throw this.o_.cancel(), new Error("Invalid bundle format: " + t);
    }, 
    /**
     * Pulls more data from underlying stream to internal buffer.
     * Returns a boolean indicating whether the stream is finished.
     */
    t.prototype.f_ = function() {
        return y(this, void 0, void 0, (function() {
            var t, e;
            return g(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return [ 4 /*yield*/ , this.o_.read() ];

                  case 1:
                    return (t = n.sent()).done || ((e = new Uint8Array(this.buffer.length + t.value.length)).set(this.buffer), 
                    e.set(t.value, this.buffer.length), this.buffer = e), [ 2 /*return*/ , t.done ];
                }
            }));
        }));
    }, t;
}(), Do = /** @class */ function() {
    /**
     * Creates a FieldPath from the provided field names. If more than one field
     * name is provided, the path will point to a nested field in a document.
     *
     * @param fieldNames - A list of field names.
     */
    function t() {
        for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
        for (var n = 0; n < t.length; ++n) if (0 === t[n].length) throw new P(R.INVALID_ARGUMENT, "Invalid field name at argument $(i + 1). Field names must not be empty.");
        this.d_ = new et(t);
    }
    /**
     * Returns true if this `FieldPath` is equal to the provided one.
     *
     * @param other - The `FieldPath` to compare against.
     * @returns true if this `FieldPath` is equal to the provided one.
     */    return t.prototype.isEqual = function(t) {
        return this.d_.isEqual(t.d_);
    }, t;
}(), ko = 
/**
     * @param _methodName - The public API endpoint that returns this class.
     */
function(t) {
    this._methodName = t;
};

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A class representing a bundle.
 *
 * Takes a bundle stream or buffer, and presents abstractions to read bundled
 * elements out of the underlying content.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function Oo(t, e, n) {
    if (!n) throw new P(R.INVALID_ARGUMENT, "Function " + t + "() cannot be called with an empty " + e + ".");
}

function Co(t, e) {
    if (void 0 === e) return {
        merge: !1
    };
    if (void 0 !== e.mergeFields && void 0 !== e.merge) throw new P(R.INVALID_ARGUMENT, "Invalid options passed to function " + t + '(): You cannot specify both "merge" and "mergeFields".');
    return e;
}

/**
 * Validates that two boolean options are not set at the same time.
 */ function Lo(t, e, n, r) {
    if (!0 === e && !0 === r) throw new P(R.INVALID_ARGUMENT, t + " and " + n + " cannot be used together.");
}

/**
 * Validates that `path` refers to a document (indicated by the fact it contains
 * an even numbers of segments).
 */ function Vo(t) {
    if (!nt.Et(t)) throw new P(R.INVALID_ARGUMENT, "Invalid document reference. Document references must have an even number of segments, but " + t + " has " + t.length + ".");
}

/**
 * Validates that `path` refers to a collection (indicated by the fact it
 * contains an odd numbers of segments).
 */ function Ro(t) {
    if (nt.Et(t)) throw new P(R.INVALID_ARGUMENT, "Invalid collection reference. Collection references must have an odd number of segments, but " + t + " has " + t.length + ".");
}

/**
 * Returns true if it's a non-null object without a custom prototype
 * (i.e. excludes Array, Date, etc.).
 */
/** Returns a string describing the type / value of the provided input. */ function Po(t) {
    if (void 0 === t) return "undefined";
    if (null === t) return "null";
    if ("string" == typeof t) return t.length > 20 && (t = t.substring(0, 20) + "..."), 
    JSON.stringify(t);
    if ("number" == typeof t || "boolean" == typeof t) return "" + t;
    if ("object" == typeof t) {
        if (t instanceof Array) return "an array";
        var e = 
        /** Hacky method to try to get the constructor name for an object. */
        function(t) {
            if (t.constructor) {
                var e = /function\s+([^\s(]+)\s*\(/.exec(t.constructor.toString());
                if (e && e.length > 1) return e[1];
            }
            return null;
        }(t);
        return e ? "a custom " + e + " object" : "an object";
    }
    return "function" == typeof t ? "a function" : A();
}

function Uo(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
e) {
    if ("_delegate" in t && (
    // Unwrap Compat types
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    t = t._), !(t instanceof e)) {
        if (e.name === t.constructor.name) throw new P(R.INVALID_ARGUMENT, "Type does not match the expected instance. Did you pass a reference from a different Firestore SDK?");
        var n = Po(t);
        throw new P(R.INVALID_ARGUMENT, "Expected type '" + e.name + "', but it was: " + n);
    }
    return t;
}

function xo(t, e) {
    if (e <= 0) throw new P(R.INVALID_ARGUMENT, "Function " + t + "() requires a positive number, but it was: " + e + ".");
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// settings() defaults:
/**
 * A concrete type describing all the values that can be applied via a
 * user-supplied firestore.Settings object. This is a separate type so that
 * defaults can be supplied and the value can be checked for equality.
 */ var qo = /** @class */ function() {
    function t(t) {
        var e;
        if (void 0 === t.host) {
            if (void 0 !== t.ssl) throw new P(R.INVALID_ARGUMENT, "Can't provide ssl option if host option is not set");
            this.host = "firestore.googleapis.com", this.ssl = !0;
        } else this.host = t.host, this.ssl = null === (e = t.ssl) || void 0 === e || e;
        if (this.credentials = t.credentials, this.ignoreUndefinedProperties = !!t.ignoreUndefinedProperties, 
        void 0 === t.cacheSizeBytes) this.cacheSizeBytes = 41943040; else {
            if (-1 !== t.cacheSizeBytes && t.cacheSizeBytes < 1048576) throw new P(R.INVALID_ARGUMENT, "cacheSizeBytes must be at least 1048576");
            this.cacheSizeBytes = t.cacheSizeBytes;
        }
        this.experimentalForceLongPolling = !!t.experimentalForceLongPolling, this.experimentalAutoDetectLongPolling = !!t.experimentalAutoDetectLongPolling, 
        Lo("experimentalForceLongPolling", t.experimentalForceLongPolling, "experimentalAutoDetectLongPolling", t.experimentalAutoDetectLongPolling);
    }
    return t.prototype.isEqual = function(t) {
        return this.host === t.host && this.ssl === t.ssl && this.credentials === t.credentials && this.cacheSizeBytes === t.cacheSizeBytes && this.experimentalForceLongPolling === t.experimentalForceLongPolling && this.experimentalAutoDetectLongPolling === t.experimentalAutoDetectLongPolling && this.ignoreUndefinedProperties === t.ignoreUndefinedProperties;
    }, t;
}(), Mo = new Map, Fo = /** @class */ function() {
    /** @hideconstructor */
    function t(t, e) {
        this.w_ = "(lite)", this.E_ = new qo({}), this.T_ = !1, t instanceof z ? (this.I_ = t, 
        this.m_ = new B) : (this.A_ = t, this.I_ = function(t) {
            if (!Object.prototype.hasOwnProperty.apply(t.options, [ "projectId" ])) throw new P(R.INVALID_ARGUMENT, '"projectId" not provided in firebase.initializeApp.');
            return new z(t.options.projectId);
        }(t), this.m_ = new K(e));
    }
    return Object.defineProperty(t.prototype, "app", {
        /**
         * The {@link FirebaseApp} associated with this `Firestore` service
         * instance.
         */
        get: function() {
            if (!this.A_) throw new P(R.FAILED_PRECONDITION, "Firestore was not initialized using the Firebase SDK. 'app' is not available");
            return this.A_;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "R_", {
        get: function() {
            return this.T_;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "P_", {
        get: function() {
            return void 0 !== this.y_;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.g_ = function(t) {
        if (this.T_) throw new P(R.FAILED_PRECONDITION, "Firestore has already been started and its settings can no longer be changed. You can only modify settings before calling any other methods on a Firestore object.");
        this.E_ = new qo(t), void 0 !== t.credentials && (this.m_ = function(t) {
            if (!t) return new B;
            switch (t.type) {
              case "gapi":
                var e = t.client;
                // Make sure this really is a Gapi client.
                                return S(!("object" != typeof e || null === e || !e.auth || !e.auth.getAuthHeaderValueForFirstParty)), 
                new W(e, t.sessionIndex || "0");

              case "provider":
                return t.client;

              default:
                throw new P(R.INVALID_ARGUMENT, "makeCredentialsProvider failed due to invalid credential type");
            }
        }(t.credentials));
    }, t.prototype.V_ = function() {
        return this.E_;
    }, t.prototype.p_ = function() {
        return this.T_ = !0, this.E_;
    }, t.prototype._delete = function() {
        return this.y_ || (this.y_ = this.b_()), this.y_;
    }, t.prototype.toJSON = function() {
        return {
            app: this.A_,
            T: this.I_,
            settings: this.E_
        };
    }, 
    /**
     * Terminates all components used by this client. Subclasses can override
     * this method to clean up their own dependencies, but must also call this
     * method.
     *
     * Only ever called once.
     */
    t.prototype.b_ = function() {
        /**
 * Removes all components associated with the provided instance. Must be called
 * when the `Firestore` instance is terminated.
 */
        return t = this, (e = Mo.get(t)) && (E("ComponentProvider", "Removing Datastore"), 
        Mo.delete(t), e.terminate()), Promise.resolve();
        var t, e;
    }, t;
}(), jo = /** @class */ function() {
    /** @hideconstructor */
    function t(t, e, n) {
        this.v_ = e, this.S_ = n, 
        /** The type of this Firestore reference. */
        this.type = "document", this.firestore = t;
    }
    return Object.defineProperty(t.prototype, "D_", {
        get: function() {
            return this.S_.path;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "id", {
        /**
         * The document's identifier within its collection.
         */
        get: function() {
            return this.S_.path.et();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "path", {
        /**
         * A string representing the path of the referenced document (relative
         * to the root of the database).
         */
        get: function() {
            return this.S_.path.ot();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "parent", {
        /**
         * The collection this `DocumentReference` belongs to.
         */
        get: function() {
            return new Go(this.firestore, this.v_, this.S_.path.Z());
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Applies a custom data converter to this `DocumentReference`, allowing you
     * to use your own custom model objects with Firestore. When you call {@link
     * setDoc}, {@link getDoc}, etc. with the returned `DocumentReference`
     * instance, the provided converter will convert between Firestore data and
     * your custom type `U`.
     *
     * @param converter - Converts objects to and from Firestore.
     * @returns A `DocumentReference<U>` that uses the provided converter.
     */
    t.prototype.withConverter = function(e) {
        return new t(this.firestore, e, this.S_);
    }, t;
}(), zo = /** @class */ function() {
    // This is the lite version of the Query class in the main SDK.
    /** @hideconstructor protected */
    function t(t, e, n) {
        this.v_ = e, this.C_ = n, 
        /** The type of this Firestore reference. */
        this.type = "query", this.firestore = t
        /**
     * Applies a custom data converter to this query, allowing you to use your own
     * custom model objects with Firestore. When you call {@link getDocs} with
     * the returned query, the provided converter will convert between Firestore
     * data and your custom type `U`.
     *
     * @param converter - Converts objects to and from Firestore.
     * @returns A `Query<U>` that uses the provided converter.
     */;
    }
    return t.prototype.withConverter = function(e) {
        return new t(this.firestore, e, this.C_);
    }, t;
}(), Go = /** @class */ function(t) {
    /** @hideconstructor */
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this, e, n, re(r)) || this).firestore = e, i.D_ = r, i.type = "collection", 
        i;
    }
    return w(e, t), Object.defineProperty(e.prototype, "id", {
        /** The collection's identifier. */ get: function() {
            return this.C_.path.et();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "path", {
        /**
         * A string representing the path of the referenced collection (relative
         * to the root of the database).
         */
        get: function() {
            return this.C_.path.ot();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "parent", {
        /**
         * A reference to the containing `DocumentReference` if this is a
         * subcollection. If this isn't a subcollection, the reference is null.
         */
        get: function() {
            var t = this.D_.Z();
            return t.nt() ? null : new jo(this.firestore, 
            /* converter= */ null, new nt(t));
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Applies a custom data converter to this CollectionReference, allowing you
     * to use your own custom model objects with Firestore. When you call {@link
     * addDoc} with the returned `CollectionReference` instance, the provided
     * converter will convert between Firestore data and your custom type `U`.
     *
     * @param converter - Converts objects to and from Firestore.
     * @returns A `CollectionReference<U>` that uses the provided converter.
     */
    e.prototype.withConverter = function(t) {
        return new e(this.firestore, t, this.D_);
    }, e;
}(zo);

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function Ho(t, e) {
    for (var n, r = [], i = 2; i < arguments.length; i++) r[i - 2] = arguments[i];
    if (t instanceof x && (t = t._), Oo("collection", "path", e), t instanceof Fo) return Ro(n = $.ct.apply($, m([ e ], r))), 
    new Go(t, /* converter= */ null, n);
    if (!(t instanceof jo || t instanceof Go)) throw new P(R.INVALID_ARGUMENT, "Expected first argument to collection() to be a CollectionReference, a DocumentReference or FirebaseFirestore");
    return Ro(n = $.ct.apply($, m([ t.path ], r)).child($.ct(e))), new Go(t.firestore, 
    /* converter= */ null, n);
}

// TODO(firestorelite): Consider using ErrorFactory -
// https://github.com/firebase/firebase-js-sdk/blob/0131e1f/packages/util/src/errors.ts#L106
/**
 * Creates and returns a new `Query` instance that includes all documents in the
 * database that are contained in a collection or subcollection with the
 * given `collectionId`.
 *
 * @param firestore - A reference to the root Firestore instance.
 * @param collectionId - Identifies the collections to query over. Every
 * collection or subcollection with this ID as the last segment of its path
 * will be included. Cannot contain a slash.
 * @returns The created `Query`.
 */ function Bo(t, e) {
    for (var n, r = [], i = 2; i < arguments.length; i++) r[i - 2] = arguments[i];
    if (t instanceof x && (t = t._), 
    // We allow omission of 'pathString' but explicitly prohibit passing in both
    // 'undefined' and 'null'.
    1 === arguments.length && (e = O.t()), Oo("doc", "path", e), t instanceof Fo) return Vo(n = $.ct.apply($, m([ e ], r))), 
    new jo(t, 
    /* converter= */ null, new nt(n));
    if (!(t instanceof jo || t instanceof Go)) throw new P(R.INVALID_ARGUMENT, "Expected first argument to collection() to be a CollectionReference, a DocumentReference or FirebaseFirestore");
    return Vo(n = t.D_.child($.ct.apply($, m([ e ], r)))), new jo(t.firestore, t instanceof Go ? t.v_ : null, new nt(n));
}

/**
 * Returns true if the provided references are equal.
 *
 * @param left - A reference to compare.
 * @param right - A reference to compare.
 * @returns true if the references point to the same location in the same
 * Firestore database.
 */ function Ko(t, e) {
    return t instanceof x && (t = t._), e instanceof x && (e = e._), (t instanceof jo || t instanceof Go) && (e instanceof jo || e instanceof Go) && t.firestore === e.firestore && t.path === e.path && t.v_ === e.v_
    /**
 * Returns true if the provided queries point to the same collection and apply
 * the same constraints.
 *
 * @param left - A `Query` to compare.
 * @param right - A `Query` to compare.
 * @returns true if the references point to the same location in the same
 * Firestore database.
 */;
}

function Jo(t, e) {
    return t instanceof x && (t = t._), e instanceof x && (e = e._), t instanceof zo && e instanceof zo && t.firestore === e.firestore && le(t.C_, e.C_) && t.v_ === e.v_
    /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * An immutable object representing a geographic location in Firestore. The
 * location is represented as latitude/longitude pair.
 *
 * Latitude values are in the range of [-90, 90].
 * Longitude values are in the range of [-180, 180].
 */;
}

var Wo = /** @class */ function() {
    /**
     * Creates a new immutable `GeoPoint` object with the provided latitude and
     * longitude values.
     * @param latitude - The latitude as number between -90 and 90.
     * @param longitude - The longitude as number between -180 and 180.
     */
    function t(t, e) {
        if (!isFinite(t) || t < -90 || t > 90) throw new P(R.INVALID_ARGUMENT, "Latitude must be a number between -90 and 90, but was: " + t);
        if (!isFinite(e) || e < -180 || e > 180) throw new P(R.INVALID_ARGUMENT, "Longitude must be a number between -180 and 180, but was: " + e);
        this.x_ = t, this.N_ = e;
    }
    return Object.defineProperty(t.prototype, "latitude", {
        /**
         * The latitude of this `GeoPoint` instance.
         */
        get: function() {
            return this.x_;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "longitude", {
        /**
         * The longitude of this `GeoPoint` instance.
         */
        get: function() {
            return this.N_;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Returns true if this `GeoPoint` is equal to the provided one.
     *
     * @param other - The `GeoPoint` to compare against.
     * @returns true if this `GeoPoint` is equal to the provided one.
     */
    t.prototype.isEqual = function(t) {
        return this.x_ === t.x_ && this.N_ === t.N_;
    }, t.prototype.toJSON = function() {
        return {
            latitude: this.x_,
            longitude: this.N_
        };
    }, 
    /**
     * Actually private to JS consumers of our API, so this function is prefixed
     * with an underscore.
     */
    t.prototype.K = function(t) {
        return C(this.x_, t.x_) || C(this.N_, t.N_);
    }, t;
}(), Qo = /^__.*__$/, Yo = /** @class */ function() {
    function t(t, e, n) {
        this.data = t, this.zt = e, this.fieldTransforms = n;
    }
    return t.prototype.F_ = function(t, e) {
        return null !== this.zt ? new Be(t, this.data, this.zt, e, this.fieldTransforms) : new He(t, this.data, e, this.fieldTransforms);
    }, t;
}(), Xo = /** @class */ function() {
    function t(t, 
    // The fieldMask does not include document transforms.
    e, n) {
        this.data = t, this.zt = e, this.fieldTransforms = n;
    }
    return t.prototype.F_ = function(t, e) {
        return new Be(t, this.data, this.zt, e, this.fieldTransforms);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function Zo(t) {
    switch (t) {
      case 0 /* Set */ :
 // fall through
              case 2 /* MergeSet */ :
 // fall through
              case 1 /* Update */ :
        return !0;

      case 3 /* Argument */ :
      case 4 /* ArrayArgument */ :
        return !1;

      default:
        throw A();
    }
}

/** A "context" object passed around while parsing user data. */ var $o = /** @class */ function() {
    /**
     * Initializes a ParseContext with the given source and path.
     *
     * @param settings - The settings for the parser.
     * @param databaseId - The database ID of the Firestore instance.
     * @param serializer - The serializer to use to generate the Value proto.
     * @param ignoreUndefinedProperties - Whether to ignore undefined properties
     * rather than throw.
     * @param fieldTransforms - A mutable list of field transforms encountered
     * while parsing the data.
     * @param fieldMask - A mutable list of field paths encountered while parsing
     * the data.
     *
     * TODO(b/34871131): We don't support array paths right now, so path can be
     * null to indicate the context represents any location within an array (in
     * which case certain features will not work and errors will be somewhat
     * compromised).
     */
    function t(t, e, n, r, i, o) {
        this.settings = t, this.T = e, this.Kt = n, this.ignoreUndefinedProperties = r, 
        // Minor hack: If fieldTransforms is undefined, we assume this is an
        // external call and we need to validate the entire path.
        void 0 === i && this.O_(), this.fieldTransforms = i || [], this.zt = o || [];
    }
    return Object.defineProperty(t.prototype, "path", {
        get: function() {
            return this.settings.path;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "k_", {
        get: function() {
            return this.settings.k_;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /** Returns a new context with the specified settings overwritten. */ t.prototype.M_ = function(e) {
        return new t(Object.assign(Object.assign({}, this.settings), e), this.T, this.Kt, this.ignoreUndefinedProperties, this.fieldTransforms, this.zt);
    }, t.prototype.L_ = function(t) {
        var e, n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), r = this.M_({
            path: n,
            B_: !1
        });
        return r.q_(t), r;
    }, t.prototype.U_ = function(t) {
        var e, n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), r = this.M_({
            path: n,
            B_: !1
        });
        return r.O_(), r;
    }, t.prototype.Q_ = function(t) {
        // TODO(b/34871131): We don't support array paths right now; so make path
        // undefined.
        return this.M_({
            path: void 0,
            B_: !0
        });
    }, t.prototype.K_ = function(t) {
        return wu(t, this.settings.methodName, this.settings.W_ || !1, this.path, this.settings.j_);
    }, 
    /** Returns 'true' if 'fieldPath' was traversed when creating this context. */ t.prototype.contains = function(t) {
        return void 0 !== this.zt.find((function(e) {
            return t.st(e);
        })) || void 0 !== this.fieldTransforms.find((function(e) {
            return t.st(e.field);
        }));
    }, t.prototype.O_ = function() {
        // TODO(b/34871131): Remove null check once we have proper paths for fields
        // within arrays.
        if (this.path) for (var t = 0; t < this.path.length; t++) this.q_(this.path.get(t));
    }, t.prototype.q_ = function(t) {
        if (0 === t.length) throw this.K_("Document fields must not be empty");
        if (Zo(this.k_) && Qo.test(t)) throw this.K_('Document fields cannot begin and end with "__"');
    }, t;
}(), tu = /** @class */ function() {
    function t(t, e, n) {
        this.T = t, this.ignoreUndefinedProperties = e, this.Kt = n || ii(t)
        /** Creates a new top-level parse context. */;
    }
    return t.prototype.G_ = function(t, e, n, r) {
        return void 0 === r && (r = !1), new $o({
            k_: t,
            methodName: e,
            j_: n,
            path: et.at(),
            B_: !1,
            W_: r
        }, this.T, this.Kt, this.ignoreUndefinedProperties);
    }, t;
}();

/**
 * Helper for parsing raw user input (provided via the API) into internal model
 * classes.
 */ function eu(t) {
    var e = t.p_(), n = ii(t.I_);
    return new tu(t.I_, !!e.ignoreUndefinedProperties, n);
}

/** Parse document data from a set() call. */ function nu(t, e, n, r, i, o) {
    void 0 === o && (o = {});
    var u = t.G_(o.merge || o.mergeFields ? 2 /* MergeSet */ : 0 /* Set */ , e, n, i);
    vu("Data must be an object, but it was:", u, r);
    var s, a, c = pu(r, u);
    if (o.merge) s = new ut(u.zt), a = u.fieldTransforms; else if (o.mergeFields) {
        for (var f = [], h = 0, l = o.mergeFields; h < l.length; h++) {
            var p = yu(e, l[h], n);
            if (!u.contains(p)) throw new P(R.INVALID_ARGUMENT, "Field '" + p + "' is specified in your field mask but missing from your input data.");
            bu(f, p) || f.push(p);
        }
        s = new ut(f), a = u.fieldTransforms.filter((function(t) {
            return s.It(t.field);
        }));
    } else s = null, a = u.fieldTransforms;
    return new Yo(new kt(c), s, a);
}

var ru = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e.prototype.z_ = function(t) {
        if (2 /* MergeSet */ !== t.k_) throw 1 /* Update */ === t.k_ ? t.K_(this._methodName + "() can only appear at the top level of your update data") : t.K_(this._methodName + "() cannot be used with set() unless you pass {merge:true}");
        // No transform to add for a delete, but we need to add it to our
        // fieldMask so it gets deleted.
                return t.zt.push(t.path), null;
    }, e.prototype.isEqual = function(t) {
        return t instanceof e;
    }, e;
}(ko);

/**
 * Creates a child context for parsing SerializableFieldValues.
 *
 * This is different than calling `ParseContext.contextWith` because it keeps
 * the fieldTransforms and fieldMask separate.
 *
 * The created context has its `dataSource` set to `UserDataSource.Argument`.
 * Although these values are used with writes, any elements in these FieldValues
 * are not considered writes since they cannot contain any FieldValue sentinels,
 * etc.
 *
 * @param fieldValue - The sentinel FieldValue for which to create a child
 *     context.
 * @param context - The parent context.
 * @param arrayElement - Whether or not the FieldValue has an array.
 */ function iu(t, e, n) {
    return new $o({
        k_: 3 /* Argument */ ,
        j_: e.settings.j_,
        methodName: t._methodName,
        B_: n
    }, e.T, e.Kt, e.ignoreUndefinedProperties);
}

var ou = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e.prototype.z_ = function(t) {
        return new Re(t.path, new Ae);
    }, e.prototype.isEqual = function(t) {
        return t instanceof e;
    }, e;
}(ko), uu = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, e) || this).H_ = n, r;
    }
    return w(e, t), e.prototype.z_ = function(t) {
        var e = iu(this, t, 
        /*array=*/ !0), n = this.H_.map((function(t) {
            return lu(t, e);
        })), r = new Se(n);
        return new Re(t.path, r);
    }, e.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, e;
}(ko), su = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, e) || this).H_ = n, r;
    }
    return w(e, t), e.prototype.z_ = function(t) {
        var e = iu(this, t, 
        /*array=*/ !0), n = this.H_.map((function(t) {
            return lu(t, e);
        })), r = new ke(n);
        return new Re(t.path, r);
    }, e.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, e;
}(ko), au = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, e) || this).J_ = n, r;
    }
    return w(e, t), e.prototype.z_ = function(t) {
        var e = new Ce(t.Kt, _e(t.Kt, this.J_));
        return new Re(t.path, e);
    }, e.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, e;
}(ko);

/** Parse update data from an update() call. */ function cu(t, e, n, r) {
    var i = t.G_(1 /* Update */ , e, n);
    vu("Data must be an object, but it was:", i, r);
    var o = [], u = new Ot;
    it(r, (function(t, r) {
        var s = mu(e, t, n);
        // For Compat types, we have to "extract" the underlying types before
        // performing validation.
                r instanceof x && (r = r._);
        var a = i.U_(s);
        if (r instanceof ru) 
        // Add it to the field mask, but don't add anything to updateData.
        o.push(s); else {
            var c = lu(r, a);
            null != c && (o.push(s), u.set(s, c));
        }
    }));
    var s = new ut(o);
    return new Xo(u.yt(), s, i.fieldTransforms);
}

/** Parse update data from a list of field/value arguments. */ function fu(t, e, n, r, i, o) {
    var u = t.G_(1 /* Update */ , e, n), s = [ yu(e, r, n) ], a = [ i ];
    if (o.length % 2 != 0) throw new P(R.INVALID_ARGUMENT, "Function " + e + "() needs to be called with an even number of arguments that alternate between field names and values.");
    for (var c = 0; c < o.length; c += 2) s.push(yu(e, o[c])), a.push(o[c + 1]);
    // We iterate in reverse order to pick the last value for a field if the
    // user specified the field multiple times.
    for (var f = [], h = new Ot, l = s.length - 1; l >= 0; --l) if (!bu(f, s[l])) {
        var p = s[l], d = a[l];
        // For Compat types, we have to "extract" the underlying types before
        // performing validation.
        d instanceof x && (d = d._);
        var v = u.U_(p);
        if (d instanceof ru) 
        // Add it to the field mask, but don't add anything to updateData.
        f.push(p); else {
            var y = lu(d, v);
            null != y && (f.push(p), h.set(p, y));
        }
    }
    var g = new ut(f);
    return new Xo(h.yt(), g, u.fieldTransforms);
}

/**
 * Parse a "query value" (e.g. value in a where filter or a value in a cursor
 * bound).
 *
 * @param allowArrays - Whether the query value is an array that may directly
 * contain additional arrays (e.g. the operand of an `in` query).
 */ function hu(t, e, n, r) {
    return void 0 === r && (r = !1), lu(n, t.G_(r ? 4 /* ArrayArgument */ : 3 /* Argument */ , e));
}

/**
 * Parses user data to Protobuf Values.
 *
 * @param input - Data to be parsed.
 * @param context - A context object representing the current path being parsed,
 * the source of the data being parsed, etc.
 * @returns The parsed value, or null if the value was a FieldValue sentinel
 * that should not be included in the resulting parsed data.
 */ function lu(t, e) {
    if (
    // Unwrap the API type from the Compat SDK. This will return the API type
    // from firestore-exp.
    t instanceof x && (t = t._), du(t)) return vu("Unsupported field value:", e, t), 
    pu(t, e);
    if (t instanceof ko) 
    // FieldValues usually parse into transforms (except FieldValue.delete())
    // in which case we do not want to include this field in our parsed data
    // (as doing so will overwrite the field directly prior to the transform
    // trying to transform it). So we don't add this location to
    // context.fieldMask and we return null as our parsing result.
    /**
     * "Parses" the provided FieldValueImpl, adding any necessary transforms to
     * context.fieldTransforms.
     */
    return function(t, e) {
        // Sentinels are only supported with writes, and not within arrays.
        if (!Zo(e.k_)) throw e.K_(t._methodName + "() can only be used with update() and set()");
        if (!e.path) throw e.K_(t._methodName + "() is not currently supported inside arrays");
        var n = t.z_(e);
        n && e.fieldTransforms.push(n);
    }(t, e), null;
    if (
    // If context.path is null we are inside an array and we don't support
    // field mask paths more granular than the top-level array.
    e.path && e.zt.push(e.path), t instanceof Array) {
        // TODO(b/34871131): Include the path containing the array in the error
        // message.
        // In the case of IN queries, the parsed data is an array (representing
        // the set of values to be included for the IN query) that may directly
        // contain additional arrays (each representing an individual field
        // value), so we disable this validation.
        if (e.settings.B_ && 4 /* ArrayArgument */ !== e.k_) throw e.K_("Nested arrays are not supported");
        return function(t, e) {
            for (var n = [], r = 0, i = 0, o = t; i < o.length; i++) {
                var u = lu(o[i], e.Q_(r));
                null == u && (
                // Just include nulls in the array for fields being replaced with a
                // sentinel.
                u = {
                    nullValue: "NULL_VALUE"
                }), n.push(u), r++;
            }
            return {
                arrayValue: {
                    values: n
                }
            };
        }(t, e);
    }
    return function(t, e) {
        if (t instanceof x && (t = t._), null === t) return {
            nullValue: "NULL_VALUE"
        };
        if ("number" == typeof t) return _e(e.Kt, t);
        if ("boolean" == typeof t) return {
            booleanValue: t
        };
        if ("string" == typeof t) return {
            stringValue: t
        };
        if (t instanceof Date) {
            var n = Y.fromDate(t);
            return {
                timestampValue: Pn(e.Kt, n)
            };
        }
        if (t instanceof Y) {
            // Firestore backend truncates precision down to microseconds. To ensure
            // offline mode works the same with regards to truncation, perform the
            // truncation immediately without waiting for the backend to do that.
            n = new Y(t.seconds, 1e3 * Math.floor(t.nanoseconds / 1e3));
            return {
                timestampValue: Pn(e.Kt, n)
            };
        }
        if (t instanceof Wo) return {
            geoPointValue: {
                latitude: t.latitude,
                longitude: t.longitude
            }
        };
        if (t instanceof U) return {
            bytesValue: Un(e.Kt, t.l)
        };
        if (t instanceof jo) {
            n = e.T;
            var r = t.firestore.I_;
            if (!r.isEqual(n)) throw e.K_("Document reference is for database " + r.projectId + "/" + r.database + " but should be for database " + n.projectId + "/" + n.database);
            return {
                referenceValue: Mn(t.firestore.I_ || e.T, t.S_.path)
            };
        }
        if (void 0 === t && e.ignoreUndefinedProperties) return null;
        throw e.K_("Unsupported field value: " + Po(t));
    }(t, e);
}

function pu(t, e) {
    var n = {};
    return ot(t) ? 
    // If we encounter an empty object, we explicitly add it to the update
    // mask to ensure that the server creates a map entry.
    e.path && e.path.length > 0 && e.zt.push(e.path) : it(t, (function(t, r) {
        var i = lu(r, e.L_(t));
        null != i && (n[t] = i);
    })), {
        mapValue: {
            fields: n
        }
    };
}

function du(t) {
    return !("object" != typeof t || null === t || t instanceof Array || t instanceof Date || t instanceof Y || t instanceof Wo || t instanceof U || t instanceof jo || t instanceof ko);
}

function vu(t, e, n) {
    if (!du(n) || !function(t) {
        return "object" == typeof t && null !== t && (Object.getPrototypeOf(t) === Object.prototype || null === Object.getPrototypeOf(t));
    }(n)) {
        var r = Po(n);
        throw "an object" === r ? e.K_(t + " a custom object") : e.K_(t + " " + r);
    }
}

/**
 * Helper that calls fromDotSeparatedString() but wraps any error thrown.
 */ function yu(t, e, n) {
    if (
    // If required, replace the FieldPath Compat class with with the firestore-exp
    // FieldPath.
    e instanceof x && (e = e._), e instanceof Do) return e.d_;
    if ("string" == typeof e) return mu(t, e);
    throw wu("Field path arguments must be of type string or FieldPath.", t, 
    /* hasConverter= */ !1, 
    /* path= */ void 0, n);
}

/**
 * Matches any characters in a field path string that are reserved.
 */ var gu = new RegExp("[~\\*/\\[\\]]");

/**
 * Wraps fromDotSeparatedString with an error message about the method that
 * was thrown.
 * @param methodName - The publicly visible method name
 * @param path - The dot-separated string form of a field path which will be
 * split on dots.
 * @param targetDoc - The document against which the field path will be
 * evaluated.
 */ function mu(t, e, n) {
    if (e.search(gu) >= 0) throw wu("Invalid field path (" + e + "). Paths must not contain '~', '*', '/', '[', or ']'", t, 
    /* hasConverter= */ !1, 
    /* path= */ void 0, n);
    try {
        return (new (Do.bind.apply(Do, m([ void 0 ], e.split("."))))).d_;
    } catch (r) {
        throw wu("Invalid field path (" + e + "). Paths must not be empty, begin with '.', end with '.', or contain '..'", t, 
        /* hasConverter= */ !1, 
        /* path= */ void 0, n);
    }
}

function wu(t, e, n, r, i) {
    var o = r && !r.nt(), u = void 0 !== i, s = "Function " + e + "() called with invalid data";
    n && (s += " (via `toFirestore()`)");
    var a = "";
    return (o || u) && (a += " (found", o && (a += " in field " + r), u && (a += " in document " + i), 
    a += ")"), new P(R.INVALID_ARGUMENT, (s += ". ") + t + a)
    /** Checks `haystack` if FieldPath `needle` is present. Runs in O(n). */;
}

function bu(t, e) {
    return t.some((function(t) {
        return t.isEqual(e);
    }));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Internal transaction object responsible for accumulating the mutations to
 * perform and the base versions for any documents read.
 */ var _u = /** @class */ function() {
    function t(t) {
        this.Dh = t, 
        // The version of each document that was read during this transaction.
        this.Y_ = new Map, this.mutations = [], this.X_ = !1, 
        /**
             * A deferred usage error that occurred previously in this transaction that
             * will cause the transaction to fail once it actually commits.
             */
        this.Z_ = null, 
        /**
             * Set of documents that have been written in the transaction.
             *
             * When there's more than one write to the same key in a transaction, any
             * writes after the first are handled differently.
             */
        this.tf = new Set;
    }
    return t.prototype.ef = function(t) {
        return y(this, void 0, void 0, (function() {
            var e, n = this;
            return g(this, (function(r) {
                switch (r.label) {
                  case 0:
                    if (this.nf(), this.mutations.length > 0) throw new P(R.INVALID_ARGUMENT, "Firestore transactions require all reads to be executed before all writes.");
                    return [ 4 /*yield*/ , function(t, e) {
                        return y(this, void 0, void 0, (function() {
                            var n, r, i, o, u, s;
                            return g(this, (function(a) {
                                switch (a.label) {
                                  case 0:
                                    return n = D(t), r = Hn(n.Kt) + "/documents", i = {
                                        documents: e.map((function(t) {
                                            return jn(n.Kt, t);
                                        }))
                                    }, [ 4 /*yield*/ , n.Cu("BatchGetDocuments", r, i) ];

                                  case 1:
                                    return o = a.sent(), u = new Map, o.forEach((function(t) {
                                        var e = function(t, e) {
                                            return "found" in e ? function(t, e) {
                                                S(!!e.found), e.found.name, e.found.updateTime;
                                                var n = zn(t, e.found.name), r = qn(e.found.updateTime), i = new kt({
                                                    mapValue: {
                                                        fields: e.found.fields
                                                    }
                                                });
                                                return new Vt(n, r, i, {});
                                            }(t, e) : "missing" in e ? function(t, e) {
                                                S(!!e.missing), S(!!e.readTime);
                                                var n = zn(t, e.missing), r = qn(e.readTime);
                                                return new Rt(n, r);
                                            }(t, e) : A();
                                        }(n.Kt, t);
                                        u.set(e.key.toString(), e);
                                    })), s = [], [ 2 /*return*/ , (e.forEach((function(t) {
                                        var e = u.get(t.toString());
                                        S(!!e), s.push(e);
                                    })), s) ];
                                }
                            }));
                        }));
                    }(this.Dh, t) ];

                  case 1:
                    return [ 2 /*return*/ , ((e = r.sent()).forEach((function(t) {
                        t instanceof Rt || t instanceof Vt ? n.sf(t) : A();
                    })), e) ];
                }
            }));
        }));
    }, t.prototype.set = function(t, e) {
        this.write(e.F_(t, this.Gt(t))), this.tf.add(t.toString());
    }, t.prototype.update = function(t, e) {
        try {
            this.write(e.F_(t, this.rf(t)));
        } catch (t) {
            this.Z_ = t;
        }
        this.tf.add(t.toString());
    }, t.prototype.delete = function(t) {
        this.write(new Ze(t, this.Gt(t))), this.tf.add(t.toString());
    }, t.prototype.commit = function() {
        return y(this, void 0, void 0, (function() {
            var t, e = this;
            return g(this, (function(n) {
                switch (n.label) {
                  case 0:
                    if (this.nf(), this.Z_) throw this.Z_;
                    return t = this.Y_, 
                    // For each mutation, note that the doc was written.
                    this.mutations.forEach((function(e) {
                        t.delete(e.key.toString());
                    })), 
                    // For each document that was read but not written to, we want to perform
                    // a `verify` operation.
                    t.forEach((function(t, n) {
                        var r = nt.ft(n);
                        e.mutations.push(new $e(r, e.Gt(r)));
                    })), [ 4 /*yield*/ , function(t, e) {
                        return y(this, void 0, void 0, (function() {
                            var n, r, i;
                            return g(this, (function(o) {
                                switch (o.label) {
                                  case 0:
                                    return n = D(t), r = Hn(n.Kt) + "/documents", i = {
                                        writes: e.map((function(t) {
                                            return Jn(n.Kt, t);
                                        }))
                                    }, [ 4 /*yield*/ , n.bu("Commit", r, i) ];

                                  case 1:
                                    return o.sent(), [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    }(this.Dh, this.mutations) ];

                  case 1:
                    // For each mutation, note that the doc was written.
                    return n.sent(), this.X_ = !0, [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.sf = function(t) {
        var e;
        if (t instanceof Vt) e = t.version; else {
            if (!(t instanceof Rt)) throw A();
            // For deleted docs, we must use baseVersion 0 when we overwrite them.
                        e = X.min();
        }
        var n = this.Y_.get(t.key.toString());
        if (n) {
            if (!e.isEqual(n)) 
            // This transaction will fail no matter what.
            throw new P(R.ABORTED, "Document version changed between two reads.");
        } else this.Y_.set(t.key.toString(), e);
    }, 
    /**
     * Returns the version of this document when it was read in this transaction,
     * as a precondition, or no precondition if it was not read.
     */
    t.prototype.Gt = function(t) {
        var e = this.Y_.get(t.toString());
        return !this.tf.has(t.toString()) && e ? Ue.updateTime(e) : Ue.Wt();
    }, 
    /**
     * Returns the precondition for a document if the operation is an update.
     */
    t.prototype.rf = function(t) {
        var e = this.Y_.get(t.toString());
        // The first time a document is written, we want to take into account the
        // read time and existence
                if (!this.tf.has(t.toString()) && e) {
            if (e.isEqual(X.min())) 
            // The document doesn't exist, so fail the transaction.
            // This has to be validated locally because you can't send a
            // precondition that a document does not exist without changing the
            // semantics of the backend write to be an insert. This is the reverse
            // of what we want, since we want to assert that the document doesn't
            // exist but then send the update and have it fail. Since we can't
            // express that to the backend, we have to validate locally.
            // Note: this can change once we can send separate verify writes in the
            // transaction.
            throw new P(R.INVALID_ARGUMENT, "Can't update a document that doesn't exist.");
            // Document exists, base precondition on document update time.
                        return Ue.updateTime(e);
        }
        // Document was not read, so we just use the preconditions for a blind
        // update.
                return Ue.exists(!0);
    }, t.prototype.write = function(t) {
        this.nf(), this.mutations.push(t);
    }, t.prototype.nf = function() {}, t;
}(), Eu = /** @class */ function() {
    function t(t, e, n, r) {
        this.fs = t, this.Dh = e, this.updateFunction = n, this.Ts = r, this.cf = 5, this.zu = new oi(this.fs, "transaction_retry" /* TransactionRetry */)
        /** Runs the transaction and sets the result on deferred. */;
    }
    return t.prototype.run = function() {
        this.af();
    }, t.prototype.af = function() {
        var t = this;
        this.zu.Bu((function() {
            return y(t, void 0, void 0, (function() {
                var t, e, n = this;
                return g(this, (function(r) {
                    return t = new _u(this.Dh), (e = this.uf(t)) && e.then((function(e) {
                        n.fs.ys((function() {
                            return t.commit().then((function() {
                                n.Ts.resolve(e);
                            })).catch((function(t) {
                                n.hf(t);
                            }));
                        }));
                    })).catch((function(t) {
                        n.hf(t);
                    })), [ 2 /*return*/ ];
                }));
            }));
        }));
    }, t.prototype.uf = function(t) {
        try {
            var e = this.updateFunction(t);
            return !dt(e) && e.catch && e.then ? e : (this.Ts.reject(Error("Transaction callback must return a Promise")), 
            null);
        } catch (t) {
            // Do not retry errors thrown by user provided updateFunction.
            return this.Ts.reject(t), null;
        }
    }, t.prototype.hf = function(t) {
        var e = this;
        this.cf > 0 && this.lf(t) ? (this.cf -= 1, this.fs.ys((function() {
            return e.af(), Promise.resolve();
        }))) : this.Ts.reject(t);
    }, t.prototype.lf = function(t) {
        if ("FirebaseError" === t.name) {
            // In transactions, the backend will fail outdated reads with FAILED_PRECONDITION and
            // non-matching document versions with ABORTED. These errors should be retried.
            var e = t.code;
            return "aborted" === e || "failed-precondition" === e || !en(e);
        }
        return !1;
    }, t;
}(), Iu = /** @class */ function() {
    function t(t, 
    /**
     * Asynchronous queue responsible for all of our internal processing. When
     * we get incoming work from the user (via public API) or the network
     * (incoming GRPC messages), we should always schedule onto this queue.
     * This ensures all of our work is properly serialized (e.g. we don't
     * start processing a new operation while the previous one is waiting for
     * an async I/O to complete).
     */
    e, n) {
        var r = this;
        this.credentials = t, this.fs = e, this.gu = n, this.user = G.UNAUTHENTICATED, this.clientId = O.t(), 
        this._f = function() {}, this.N = new ar, this.credentials.S((function(t) {
            E("FirestoreClient", "Received user=", t.uid), r.user = t, r._f(t), r.N.resolve();
        }));
    }
    return t.prototype.getConfiguration = function() {
        return y(this, void 0, void 0, (function() {
            return g(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return [ 4 /*yield*/ , this.N.promise ];

                  case 1:
                    return [ 2 /*return*/ , (t.sent(), {
                        fs: this.fs,
                        gu: this.gu,
                        clientId: this.clientId,
                        credentials: this.credentials,
                        Yl: this.user,
                        bl: 100
                    }) ];
                }
            }));
        }));
    }, t.prototype.ff = function(t) {
        var e = this;
        this._f = t, 
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.N.promise.then((function() {
            return e._f(e.user);
        }));
    }, 
    /**
     * Checks that the client has not been terminated. Ensures that other methods on
     * this class cannot be called after the client is terminated.
     */
    t.prototype.df = function() {
        if (this.fs.wf) throw new P(R.FAILED_PRECONDITION, "The client has already been terminated.");
    }, t.prototype.terminate = function() {
        var t = this;
        this.fs.Ef();
        var e = new ar;
        return this.fs.Tf((function() {
            return y(t, void 0, void 0, (function() {
                var t, n;
                return g(this, (function(r) {
                    switch (r.label) {
                      case 0:
                        return r.trys.push([ 0, 5, , 6 ]), this.If ? [ 4 /*yield*/ , this.If.terminate() ] : [ 3 /*break*/ , 2 ];

                      case 1:
                        r.sent(), r.label = 2;

                      case 2:
                        return this.mf ? [ 4 /*yield*/ , this.mf.terminate() ] : [ 3 /*break*/ , 4 ];

                      case 3:
                        r.sent(), r.label = 4;

                      case 4:
                        // `removeChangeListener` must be called after shutting down the
                        // RemoteStore as it will prevent the RemoteStore from retrieving
                        // auth tokens.
                        return this.credentials.D(), e.resolve(), [ 3 /*break*/ , 6 ];

                      case 5:
                        return t = r.sent(), n = lr(t, "Failed to shutdown persistence"), e.reject(n), [ 3 /*break*/ , 6 ];

                      case 6:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        })), e.promise;
    }, t;
}();

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * TransactionRunner encapsulates the logic needed to run and retry transactions
 * with backoff.
 */ function Tu(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r, i = this;
        return g(this, (function(o) {
            switch (o.label) {
              case 0:
                return t.fs.Af(), E("FirestoreClient", "Initializing OfflineComponentProvider"), 
                [ 4 /*yield*/ , t.getConfiguration() ];

              case 1:
                return n = o.sent(), [ 4 /*yield*/ , e.initialize(n) ];

              case 2:
                return o.sent(), r = n.Yl, t.ff((function(n) {
                    r.isEqual(n) || (r = n, t.fs.bo((function() {
                        return y(i, void 0, void 0, (function() {
                            return g(this, (function(t) {
                                switch (t.label) {
                                  case 0:
                                    return [ 4 /*yield*/ , kr(e.Sh, n) ];

                                  case 1:
                                    return t.sent(), [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    })));
                })), 
                // When a user calls clearPersistence() in one client, all other clients
                // need to be terminated to allow the delete to succeed.
                e.persistence.yo((function() {
                    return t.terminate();
                })), t.mf = e, [ 2 /*return*/ ];
            }
        }));
    }));
}

function Nu(t, e) {
    return y(this, void 0, void 0, (function() {
        var n, r;
        return g(this, (function(i) {
            switch (i.label) {
              case 0:
                return t.fs.Af(), [ 4 /*yield*/ , Au(t) ];

              case 1:
                return n = i.sent(), E("FirestoreClient", "Initializing OnlineComponentProvider"), 
                [ 4 /*yield*/ , t.getConfiguration() ];

              case 2:
                return r = i.sent(), [ 4 /*yield*/ , e.initialize(n, r) ];

              case 3:
                return i.sent(), 
                // The CredentialChangeListener of the online component provider takes
                // precedence over the offline component provider.
                t.ff((function(n) {
                    return t.fs.bo((function() {
                        return function(t, e) {
                            return y(this, void 0, void 0, (function() {
                                var n, r;
                                return g(this, (function(i) {
                                    switch (i.label) {
                                      case 0:
                                        return (n = D(t)).fs.Af(), E("RemoteStore", "RemoteStore received new credentials"), 
                                        r = bi(n), 
                                        // Tear down and re-create our network streams. This will ensure we get a
                                        // fresh auth token for the new user and re-fill the write pipeline with
                                        // new mutations from the LocalStore (since mutations are per-user).
                                        n.Fh.add(3 /* CredentialChange */), [ 4 /*yield*/ , pi(n) ];

                                      case 1:
                                        return i.sent(), r && 
                                        // Don't set the network status to Unknown if we are offline.
                                        n.Mh.set("Unknown" /* Unknown */), [ 4 /*yield*/ , n.Ch.s_(e) ];

                                      case 2:
                                        return i.sent(), n.Fh.delete(3 /* CredentialChange */), [ 4 /*yield*/ , li(n) ];

                                      case 3:
                                        // Tear down and re-create our network streams. This will ensure we get a
                                        // fresh auth token for the new user and re-fill the write pipeline with
                                        // new mutations from the LocalStore (since mutations are per-user).
                                        return i.sent(), [ 2 /*return*/ ];
                                    }
                                }));
                            }));
                        }(e.gl, n);
                    }));
                })), t.If = e, [ 2 /*return*/ ];
            }
        }));
    }));
}

function Au(t) {
    return y(this, void 0, void 0, (function() {
        return g(this, (function(e) {
            switch (e.label) {
              case 0:
                return t.mf ? [ 3 /*break*/ , 2 ] : (E("FirestoreClient", "Using default OfflineComponentProvider"), 
                [ 4 /*yield*/ , Tu(t, new Io) ]);

              case 1:
                e.sent(), e.label = 2;

              case 2:
                return [ 2 /*return*/ , t.mf ];
            }
        }));
    }));
}

function Su(t) {
    return y(this, void 0, void 0, (function() {
        return g(this, (function(e) {
            switch (e.label) {
              case 0:
                return t.If ? [ 3 /*break*/ , 2 ] : (E("FirestoreClient", "Using default OnlineComponentProvider"), 
                [ 4 /*yield*/ , Nu(t, new To) ]);

              case 1:
                e.sent(), e.label = 2;

              case 2:
                return [ 2 /*return*/ , t.If ];
            }
        }));
    }));
}

function Du(t) {
    return Au(t).then((function(t) {
        return t.persistence;
    }));
}

function ku(t) {
    return Au(t).then((function(t) {
        return t.Sh;
    }));
}

function Ou(t) {
    return Su(t).then((function(t) {
        return t.gl;
    }));
}

function Cu(t) {
    return Su(t).then((function(t) {
        return t.fa;
    }));
}

function Lu(t) {
    return y(this, void 0, void 0, (function() {
        var e, n;
        return g(this, (function(r) {
            switch (r.label) {
              case 0:
                return [ 4 /*yield*/ , Su(t) ];

              case 1:
                return e = r.sent(), [ 2 /*return*/ , ((n = e.Vl).Gh = eo.bind(null, e.fa), n.Jh = ro.bind(null, e.fa), 
                n) ];
            }
        }));
    }));
}

/** Enables the network connection and re-enqueues all pending operations. */ function Vu(t, e, n) {
    var r = this;
    void 0 === n && (n = {});
    var i = new ar;
    return t.fs.ys((function() {
        return y(r, void 0, void 0, (function() {
            var r;
            return g(this, (function(o) {
                switch (o.label) {
                  case 0:
                    return r = function(t, e, n, r, i) {
                        var o = new Ao({
                            next: function(o) {
                                // Remove query first before passing event to user to avoid
                                // user actions affecting the now stale query.
                                e.ys((function() {
                                    return Fi(t, u);
                                }));
                                var s = o.docs.has(n);
                                !s && o.fromCache ? 
                                // TODO(dimond): If we're online and the document doesn't
                                // exist then we resolve with a doc.exists set to false. If
                                // we're offline however, we reject the Promise in this
                                // case. Two options: 1) Cache the negative response from
                                // the server so we can deliver that even when you're
                                // offline 2) Actually reject the Promise in the online case
                                // if the document doesn't exist.
                                i.reject(new P(R.UNAVAILABLE, "Failed to get document because the client is offline.")) : s && o.fromCache && r && "server" === r.source ? i.reject(new P(R.UNAVAILABLE, 'Failed to get document from server. (However, this document does exist in the local cache. Run again without setting source to "server" to retrieve the cached document.)')) : i.resolve(o);
                            },
                            error: function(t) {
                                return i.reject(t);
                            }
                        }), u = new Hi(re(n.path), o, {
                            includeMetadataChanges: !0,
                            sl: !0
                        });
                        return Mi(t, u);
                    }, [ 4 /*yield*/ , Lu(t) ];

                  case 1:
                    return [ 2 /*return*/ , r.apply(void 0, [ o.sent(), t.fs, e, n, i ]) ];
                }
            }));
        }));
    })), i.promise;
}

function Ru(t, e, n) {
    var r = this;
    void 0 === n && (n = {});
    var i = new ar;
    return t.fs.ys((function() {
        return y(r, void 0, void 0, (function() {
            var r;
            return g(this, (function(o) {
                switch (o.label) {
                  case 0:
                    return r = function(t, e, n, r, i) {
                        var o = new Ao({
                            next: function(n) {
                                // Remove query first before passing event to user to avoid
                                // user actions affecting the now stale query.
                                e.ys((function() {
                                    return Fi(t, u);
                                })), n.fromCache && "server" === r.source ? i.reject(new P(R.UNAVAILABLE, 'Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to "server" to retrieve the cached documents.)')) : i.resolve(n);
                            },
                            error: function(t) {
                                return i.reject(t);
                            }
                        }), u = new Hi(n, o, {
                            includeMetadataChanges: !0,
                            sl: !0
                        });
                        return Mi(t, u);
                    }, [ 4 /*yield*/ , Lu(t) ];

                  case 1:
                    return [ 2 /*return*/ , r.apply(void 0, [ o.sent(), t.fs, e, n, i ]) ];
                }
            }));
        }));
    })), i.promise;
}

var Pu = /** @class */ function() {
    function t() {
        var t = this;
        // The last promise in the queue.
                this.Rf = Promise.resolve(), 
        // A list of retryable operations. Retryable operations are run in order and
        // retried with backoff.
        this.Pf = [], 
        // Is this AsyncQueue being shut down? Once it is set to true, it will not
        // be changed again.
        this.yf = !1, 
        // Operations scheduled to be queued in the future. Operations are
        // automatically removed after they are run or canceled.
        this.gf = [], 
        // visible for testing
        this.Vf = null, 
        // Flag set while there's an outstanding AsyncQueue operation, used for
        // assertion sanity-checks.
        this.pf = !1, 
        // List of TimerIds to fast-forward delays for.
        this.bf = [], 
        // Backoff timer used to schedule retries for retryable operations
        this.zu = new oi(this, "async_queue_retry" /* AsyncQueueRetry */), 
        // Visibility handler that triggers an immediate retry of all retryable
        // operations. Meant to speed up recovery when we regain file system access
        // after page comes into foreground.
        this.vf = function() {
            var e = ri();
            e && E("AsyncQueue", "Visibility state changed to " + e.visibilityState), t.zu.Uu();
        };
        var e = ri();
        e && "function" == typeof e.addEventListener && e.addEventListener("visibilitychange", this.vf);
    }
    return Object.defineProperty(t.prototype, "wf", {
        get: function() {
            return this.yf;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Adds a new operation to the queue without waiting for it to complete (i.e.
     * we ignore the Promise result).
     */
    t.prototype.ys = function(t) {
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.enqueue(t);
    }, t.prototype.Tf = function(t) {
        this.Sf(), 
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.Df(t);
    }, t.prototype.Ef = function() {
        if (!this.yf) {
            this.yf = !0;
            var t = ri();
            t && "function" == typeof t.removeEventListener && t.removeEventListener("visibilitychange", this.vf);
        }
    }, t.prototype.enqueue = function(t) {
        return this.Sf(), this.yf ? new Promise((function(t) {})) : this.Df(t);
    }, t.prototype.bo = function(t) {
        var e = this;
        this.ys((function() {
            return e.Pf.push(t), e.Cf();
        }));
    }, 
    /**
     * Runs the next operation from the retryable queue. If the operation fails,
     * reschedules with backoff.
     */
    t.prototype.Cf = function() {
        return y(this, void 0, void 0, (function() {
            var t, e = this;
            return g(this, (function(n) {
                switch (n.label) {
                  case 0:
                    if (0 === this.Pf.length) return [ 3 /*break*/ , 5 ];
                    n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , this.Pf[0]() ];

                  case 2:
                    return n.sent(), this.Pf.shift(), this.zu.reset(), [ 3 /*break*/ , 4 ];

                  case 3:
                    if (!fr(t = n.sent())) throw t;
                    // Failure will be handled by AsyncQueue
                                        return E("AsyncQueue", "Operation failed with retryable error: " + t), 
                    [ 3 /*break*/ , 4 ];

                  case 4:
                    this.Pf.length > 0 && 
                    // If there are additional operations, we re-schedule `retryNextOp()`.
                    // This is necessary to run retryable operations that failed during
                    // their initial attempt since we don't know whether they are already
                    // enqueued. If, for example, `op1`, `op2`, `op3` are enqueued and `op1`
                    // needs to  be re-run, we will run `op1`, `op1`, `op2` using the
                    // already enqueued calls to `retryNextOp()`. `op3()` will then run in the
                    // call scheduled here.
                    // Since `backoffAndRun()` cancels an existing backoff and schedules a
                    // new backoff on every call, there is only ever a single additional
                    // operation in the queue.
                    this.zu.Bu((function() {
                        return e.Cf();
                    })), n.label = 5;

                  case 5:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Df = function(t) {
        var e = this, n = this.Rf.then((function() {
            return e.pf = !0, t().catch((function(t) {
                // Re-throw the error so that this.tail becomes a rejected Promise and
                // all further attempts to chain (via .then) will just short-circuit
                // and return the rejected Promise.
                throw e.Vf = t, e.pf = !1, I("INTERNAL UNHANDLED ERROR: ", 
                /**
 * Chrome includes Error.message in Error.stack. Other browsers do not.
 * This returns expected output of message + stack when available.
 * @param error - Error or FirestoreError
 */
                function(t) {
                    var e = t.message || "";
                    return t.stack && (e = t.stack.includes(t.message) ? t.stack : t.message + "\n" + t.stack), 
                    e;
                }(t)), t;
            })).then((function(t) {
                return e.pf = !1, t;
            }));
        }));
        return this.Rf = n, n;
    }, t.prototype.Ir = function(t, e, n) {
        var r = this;
        this.Sf(), 
        // Fast-forward delays for timerIds that have been overriden.
        this.bf.indexOf(t) > -1 && (e = 0);
        var i = hr.Is(this, t, e, n, (function(t) {
            return r.xf(t);
        }));
        return this.gf.push(i), i;
    }, t.prototype.Sf = function() {
        this.Vf && A();
    }, t.prototype.Af = function() {}, 
    /**
     * Waits until all currently queued tasks are finished executing. Delayed
     * operations are not run.
     */
    t.prototype.Nf = function() {
        return y(this, void 0, void 0, (function() {
            var t;
            return g(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return [ 4 /*yield*/ , t = this.Rf ];

                  case 1:
                    e.sent(), e.label = 2;

                  case 2:
                    if (t !== this.Rf) return [ 3 /*break*/ , 0 ];
                    e.label = 3;

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * For Tests: Determine if a delayed operation with a particular TimerId
     * exists.
     */
    t.prototype.Ff = function(t) {
        for (var e = 0, n = this.gf; e < n.length; e++) {
            if (n[e].ds === t) return !0;
        }
        return !1;
    }, 
    /**
     * For Tests: Runs some or all delayed operations early.
     *
     * @param lastTimerId - Delayed operations up to and including this TimerId
     * will be drained. Pass TimerId.All to run all delayed operations.
     * @returns a Promise that resolves once all operations have been run.
     */
    t.prototype.Of = function(t) {
        var e = this;
        // Note that draining may generate more delayed ops, so we do that first.
                return this.Nf().then((function() {
            // Run ops in the same order they'd run if they ran naturally.
            e.gf.sort((function(t, e) {
                return t.ws - e.ws;
            }));
            for (var n = 0, r = e.gf; n < r.length; n++) {
                var i = r[n];
                if (i.Ps(), "all" /* All */ !== t && i.ds === t) break;
            }
            return e.Nf();
        }));
    }, 
    /**
     * For Tests: Skip all subsequent delays for a timer id.
     */
    t.prototype.kf = function(t) {
        this.bf.push(t);
    }, 
    /** Called once a DelayedOperation is run or canceled. */ t.prototype.xf = function(t) {
        // NOTE: indexOf / slice are O(n), but delayedOperations is expected to be small.
        var e = this.gf.indexOf(t);
        this.gf.splice(e, 1);
    }, t;
}(), Uu = -1, xu = /** @class */ function(t) {
    /** @hideconstructor */
    function e(e, n) {
        var r = this;
        return (r = t.call(this, e, n) || this).Mf = new Pu, r.w_ = "name" in e ? e.name : "[DEFAULT]", 
        r;
    }
    return w(e, t), e.prototype.b_ = function() {
        return this.Lf || 
        // The client must be initialized to ensure that all subsequent API
        // usage throws an exception.
        Mu(this), this.Lf.terminate();
    }, e;
}(Fo);

function qu(t) {
    return t.Lf || Mu(t), t.Lf.df(), t.Lf;
}

function Mu(t) {
    var e = t.p_(), n = function(t, e, n) {
        return new j(t, e, n.host, n.ssl, n.experimentalForceLongPolling, n.experimentalAutoDetectLongPolling);
    }(t.I_, t.w_, e);
    t.Lf = new Iu(t.m_, t.Mf, n);
}

/**
 * Waits until all currently pending writes for the active user have been
 * acknowledged by the backend.
 *
 * The returned Promise resolves immediately if there are no outstanding writes.
 * Otherwise, the Promise waits for all previously issued writes (including
 * those written in a previous app session), but it does not wait for writes
 * that were added after the function is called. If you want to wait for
 * additional writes, call `waitForPendingWrites()` again.
 *
 * Any outstanding `waitForPendingWrites()` Promises are rejected during user
 * changes.
 *
 * @returns A Promise which resolves when all currently pending writes have been
 * acknowledged by the backend.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Converts Firestore's internal types to the JavaScript types that we expose
 * to the user.
 */
var Fu = /** @class */ function() {
    function t() {}
    return t.prototype.$f = function(t, e) {
        switch (void 0 === e && (e = "none"), yt(t)) {
          case 0 /* NullValue */ :
            return null;

          case 1 /* BooleanValue */ :
            return t.booleanValue;

          case 2 /* NumberValue */ :
            return ct(t.integerValue || t.doubleValue);

          case 3 /* TimestampValue */ :
            return this.Bf(t.timestampValue);

          case 4 /* ServerTimestampValue */ :
            return this.qf(t, e);

          case 5 /* StringValue */ :
            return t.stringValue;

          case 6 /* BlobValue */ :
            return this.Uf(ft(t.bytesValue));

          case 7 /* RefValue */ :
            return this.Qf(t.referenceValue);

          case 8 /* GeoPointValue */ :
            return this.Kf(t.geoPointValue);

          case 9 /* ArrayValue */ :
            return this.Wf(t.arrayValue, e);

          case 10 /* ObjectValue */ :
            return this.jf(t.mapValue, e);

          default:
            throw A();
        }
    }, t.prototype.jf = function(t, e) {
        var n = this, r = {};
        return it(t.fields || {}, (function(t, i) {
            r[t] = n.$f(i, e);
        })), r;
    }, t.prototype.Kf = function(t) {
        return new Wo(ct(t.latitude), ct(t.longitude));
    }, t.prototype.Wf = function(t, e) {
        var n = this;
        return (t.values || []).map((function(t) {
            return n.$f(t, e);
        }));
    }, t.prototype.qf = function(t, e) {
        switch (e) {
          case "previous":
            var n = lt(t);
            return null == n ? null : this.$f(n, e);

          case "estimate":
            return this.Bf(pt(t));

          default:
            return null;
        }
    }, t.prototype.Bf = function(t) {
        var e = at(t);
        return new Y(e.seconds, e.nanos);
    }, t.prototype.Gf = function(t, e) {
        var n = $.ct(t);
        S(sr(n));
        var r = new z(n.get(1), n.get(3)), i = new nt(n.X(5));
        return r.isEqual(e) || 
        // TODO(b/64130202): Somehow support foreign references.
        I("Document " + i + " contains a document reference within a different database (" + r.projectId + "/" + r.database + ") which is not supported. It will be treated as a reference in the current database (" + e.projectId + "/" + e.database + ") instead."), 
        i;
    }, t;
}(), ju = /** @class */ function() {
    // Note: This class is stripped down version of the DocumentSnapshot in
    // the legacy SDK. The changes are:
    // - No support for SnapshotMetadata.
    // - No support for SnapshotOptions.
    /** @hideconstructor protected */
    function t(t, e, n, r, i) {
        this.zf = t, this.Hf = e, this.S_ = n, this.Jf = r, this.v_ = i;
    }
    return Object.defineProperty(t.prototype, "id", {
        /** Property of the `DocumentSnapshot` that provides the document's ID. */ get: function() {
            return this.S_.path.et();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "ref", {
        /**
         * The `DocumentReference` for the document included in the `DocumentSnapshot`.
         */
        get: function() {
            return new jo(this.zf, this.v_, this.S_);
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Signals whether or not the document at the snapshot's location exists.
     *
     * @returns true if the document exists.
     */
    t.prototype.exists = function() {
        return null !== this.Jf;
    }, 
    /**
     * Retrieves all fields in the document as an `Object`. Returns `undefined` if
     * the document doesn't exist.
     *
     * @returns An `Object` containing all fields in the document or `undefined`
     * if the document doesn't exist.
     */
    t.prototype.data = function() {
        if (this.Jf) {
            if (this.v_) {
                // We only want to use the converter and create a new DocumentSnapshot
                // if a converter has been provided.
                var t = new zu(this.zf, this.Hf, this.S_, this.Jf, 
                /* converter= */ null);
                return this.v_.fromFirestore(t);
            }
            return this.Hf.$f(this.Jf.vt());
        }
    }, 
    /**
     * Retrieves the field specified by `fieldPath`. Returns `undefined` if the
     * document or field doesn't exist.
     *
     * @param fieldPath - The path (for example 'foo' or 'foo.bar') to a specific
     * field.
     * @returns The data at the specified field location or undefined if no such
     * field exists in the document.
     */
    // We are using `any` here to avoid an explicit cast by our users.
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    t.prototype.get = function(t) {
        if (this.Jf) {
            var e = this.Jf.data().field(Gu("DocumentSnapshot.get", t));
            if (null !== e) return this.Hf.$f(e);
        }
    }, t;
}(), zu = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    /**
     * Retrieves all fields in the document as an `Object`.
     *
     * @override
     * @returns An `Object` containing all fields in the document.
     */    return w(e, t), e.prototype.data = function() {
        return t.prototype.data.call(this);
    }, e;
}(ju);

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A `DocumentSnapshot` contains data read from a document in your Firestore
 * database. The data can be extracted with `.data()` or `.get(<field>)` to
 * get a specific field.
 *
 * For a `DocumentSnapshot` that points to a non-existing document, any data
 * access will return 'undefined'. You can use the `exists()` method to
 * explicitly verify a document's existence.
 */
/**
 * Helper that calls fromDotSeparatedString() but wraps any error thrown.
 */
function Gu(t, e) {
    return "string" == typeof e ? mu(t, e) : e instanceof x ? e._.d_ : e.d_;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function Hu(t) {
    if (oe(t) && 0 === t.Nt.length) throw new P(R.UNIMPLEMENTED, "limitToLast() queries require specifying at least one orderBy() clause");
}

/**
 * A `QueryConstraint` is used to narrow the set of documents returned by a
 * Firestore query. `QueryConstraint`s are created by invoking {@link where},
 * {@link orderBy}, {@link startAt}, {@link startAfter}, {@link
 * endBefore}, {@link endAt}, {@link limit} or {@link limitToLast} and
 * can then be passed to {@link query} to create a new query instance that
 * also contains this `QueryConstraint`.
 */ var Bu = function() {};

/**
 * Creates a new immutable instance of `query` that is extended to also include
 * additional query constraints.
 *
 * @param query - The query instance to use as a base for the new constraints.
 * @param queryConstraints - The list of `QueryConstraint`s to apply.
 * @throws if any of the provided query constraints cannot be combined with the
 * existing or new constraints.
 */ function Ku(t) {
    for (var e = [], n = 1; n < arguments.length; n++) e[n - 1] = arguments[n];
    for (var r = 0, i = e; r < i.length; r++) {
        var o = i[r];
        t = o.Yf(t);
    }
    return t;
}

var Ju = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this) || this).Xf = e, i.Zf = n, i.td = r, i.type = "where", 
        i;
    }
    return w(e, t), e.prototype.Yf = function(t) {
        var e = eu(t.firestore), n = function(t, e, n, r, i, o, u) {
            var s;
            if (i.ht()) {
                if ("array-contains" /* ARRAY_CONTAINS */ === o || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === o) throw new P(R.INVALID_ARGUMENT, "Invalid Query. You can't perform '" + o + "' queries on FieldPath.documentId().");
                if ("in" /* IN */ === o || "not-in" /* NOT_IN */ === o) {
                    ts(u, o);
                    for (var a = [], c = 0, f = u; c < f.length; c++) {
                        var h = f[c];
                        a.push($u(r, t, h));
                    }
                    s = {
                        arrayValue: {
                            values: a
                        }
                    };
                } else s = $u(r, t, u);
            } else "in" /* IN */ !== o && "not-in" /* NOT_IN */ !== o && "array-contains-any" /* ARRAY_CONTAINS_ANY */ !== o || ts(u, o), 
            s = hu(n, "where", u, 
            /* allowArrays= */ "in" /* IN */ === o || "not-in" /* NOT_IN */ === o);
            var l = jt.create(i, o, s);
            return function(t, e) {
                if (e.xt()) {
                    var n = se(t);
                    if (null !== n && !n.isEqual(e.field)) throw new P(R.INVALID_ARGUMENT, "Invalid query. All where filters with an inequality (<, <=, !=, not-in, >, or >=) must be on the same field. But you have inequality filters on '" + n.toString() + "' and '" + e.field.toString() + "'");
                    var r = ue(t);
                    null !== r && es(t, e.field, r);
                }
                var i = function(t, e) {
                    for (var n = 0, r = t.filters; n < r.length; n++) {
                        var i = r[n];
                        if (e.indexOf(i.op) >= 0) return i.op;
                    }
                    return null;
                }(t, 
                /**
 * Given an operator, returns the set of operators that cannot be used with it.
 *
 * Operators in a query must adhere to the following set of rules:
 * 1. Only one array operator is allowed.
 * 2. Only one disjunctive operator is allowed.
 * 3. NOT_EQUAL cannot be used with another NOT_EQUAL operator.
 * 4. NOT_IN cannot be used with array, disjunctive, or NOT_EQUAL operators.
 *
 * Array operators: ARRAY_CONTAINS, ARRAY_CONTAINS_ANY
 * Disjunctive operators: IN, ARRAY_CONTAINS_ANY, NOT_IN
 */
                function(t) {
                    switch (t) {
                      case "!=" /* NOT_EQUAL */ :
                        return [ "!=" /* NOT_EQUAL */ , "not-in" /* NOT_IN */ ];

                      case "array-contains" /* ARRAY_CONTAINS */ :
                        return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "not-in" /* NOT_IN */ ];

                      case "in" /* IN */ :
                        return [ "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

                      case "array-contains-any" /* ARRAY_CONTAINS_ANY */ :
                        return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ ];

                      case "not-in" /* NOT_IN */ :
                        return [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ , "in" /* IN */ , "not-in" /* NOT_IN */ , "!=" /* NOT_EQUAL */ ];

                      default:
                        return [];
                    }
                }(e.op));
                if (null !== i) 
                // Special case when it's a duplicate op to give a slightly clearer error message.
                throw i === e.op ? new P(R.INVALID_ARGUMENT, "Invalid query. You cannot use more than one '" + e.op.toString() + "' filter.") : new P(R.INVALID_ARGUMENT, "Invalid query. You cannot use '" + e.op.toString() + "' filters with '" + i.toString() + "' filters.");
            }(t, l), l;
        }(t.C_, 0, e, t.firestore.I_, this.Xf, this.Zf, this.td);
        return new zo(t.firestore, t.v_, function(t, e) {
            var n = t.filters.concat([ e ]);
            return new ne(t.path, t.collectionGroup, t.Nt.slice(), n, t.limit, t.limitType, t.startAt, t.endAt);
        }(t.C_, n));
    }, e;
}(Bu), Wu = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this) || this).Xf = e, r.ed = n, r.type = "orderBy", r;
    }
    return w(e, t), e.prototype.Yf = function(t) {
        var e = function(t, e, n) {
            if (null !== t.startAt) throw new P(R.INVALID_ARGUMENT, "Invalid query. You must not call startAt() or startAfter() before calling orderBy().");
            if (null !== t.endAt) throw new P(R.INVALID_ARGUMENT, "Invalid query. You must not call endAt() or endBefore() before calling orderBy().");
            var r = new Zt(e, n);
            return function(t, e) {
                if (null === ue(t)) {
                    // This is the first order by. It must match any inequality.
                    var n = se(t);
                    null !== n && es(t, n, e.field);
                }
            }(t, r), r;
        }(t.C_, this.Xf, this.ed);
        return new zo(t.firestore, t.v_, function(t, e) {
            // TODO(dimond): validate that orderBy does not list the same key twice.
            var n = t.Nt.concat([ e ]);
            return new ne(t.path, t.collectionGroup, n, t.filters.slice(), t.limit, t.limitType, t.startAt, t.endAt);
        }(t.C_, e));
    }, e;
}(Bu), Qu = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this) || this).type = e, i.nd = n, i.sd = r, i;
    }
    return w(e, t), e.prototype.Yf = function(t) {
        return new zo(t.firestore, t.v_, he(t.C_, this.nd, this.sd));
    }, e;
}(Bu), Yu = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this) || this).type = e, i.rd = n, i.od = r, i;
    }
    return w(e, t), e.prototype.Yf = function(t) {
        var e = Zu(t, this.type, this.rd, this.od);
        return new zo(t.firestore, t.v_, function(t, e) {
            return new ne(t.path, t.collectionGroup, t.Nt.slice(), t.filters.slice(), t.limit, t.limitType, e, t.endAt);
        }(t.C_, e));
    }, e;
}(Bu), Xu = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this) || this).type = e, i.rd = n, i.od = r, i;
    }
    return w(e, t), e.prototype.Yf = function(t) {
        var e = Zu(t, this.type, this.rd, this.od);
        return new zo(t.firestore, t.v_, function(t, e) {
            return new ne(t.path, t.collectionGroup, t.Nt.slice(), t.filters.slice(), t.limit, t.limitType, t.startAt, e);
        }(t.C_, e));
    }, e;
}(Bu);

/**
 * Creates a `QueryConstraint` that enforces that documents must contain the
 * specified field and that the value should satisfy the relation constraint
 * provided.
 *
 * @param fieldPath - The path to compare
 * @param opStr - The operation string (e.g "&lt;", "&lt;=", "==", "&lt;",
 *   "&lt;=", "!=").
 * @param value - The value for comparison
 * @returns The created `Query`.
 */
/** Helper function to create a bound from a document or fields */
function Zu(t, e, n, r) {
    if (n[0] instanceof x && (n[0] = n[0]._), n[0] instanceof ju) return function(t, e, n, r, i) {
        if (!r) throw new P(R.NOT_FOUND, "Can't use a DocumentSnapshot that doesn't exist for " + n + "().");
        // Because people expect to continue/end a query at the exact document
        // provided, we need to use the implicit sort order rather than the explicit
        // sort order, because it's guaranteed to contain the document key. That way
        // the position becomes unambiguous and the query continues/ends exactly at
        // the provided document. Without the key (by using the explicit sort
        // orders), multiple documents could match the position, yielding duplicate
        // results.
        for (var o = [], u = 0, s = ce(t); u < s.length; u++) {
            var a = s[u];
            if (a.field.ht()) o.push(It(e, r.key)); else {
                var c = r.field(a.field);
                if (ht(c)) throw new P(R.INVALID_ARGUMENT, 'Invalid query. You are trying to start or end a query using a document for which the field "' + a.field + '" is an uncommitted server timestamp. (Since the value of this field is unknown, you cannot start/end a query with it.)');
                if (null === c) {
                    var f = a.field.ot();
                    throw new P(R.INVALID_ARGUMENT, "Invalid query. You are trying to start or end a query using a document for which the field '" + f + "' (used as the orderBy) does not exist.");
                }
                o.push(c);
            }
        }
        return new Yt(o, i);
    }(t.C_, t.firestore.I_, e, n[0].Jf, r);
    var i = eu(t.firestore);
    return function(t, e, n, r, i, o) {
        // Use explicit order by's because it has to match the query the user made
        var u = t.Nt;
        if (i.length > u.length) throw new P(R.INVALID_ARGUMENT, "Too many arguments provided to " + r + "(). The number of arguments must be less than or equal to the number of orderBy() clauses");
        for (var s = [], a = 0; a < i.length; a++) {
            var c = i[a];
            if (u[a].field.ht()) {
                if ("string" != typeof c) throw new P(R.INVALID_ARGUMENT, "Invalid query. Expected a string for document ID in " + r + "(), but got a " + typeof c);
                if (!ae(t) && -1 !== c.indexOf("/")) throw new P(R.INVALID_ARGUMENT, "Invalid query. When querying a collection and ordering by FieldPath.documentId(), the value passed to " + r + "() must be a plain document ID, but '" + c + "' contains a slash.");
                var f = t.path.child($.ct(c));
                if (!nt.Et(f)) throw new P(R.INVALID_ARGUMENT, "Invalid query. When querying a collection group and ordering by FieldPath.documentId(), the value passed to " + r + "() must result in a valid document path, but '" + f + "' is not because it contains an odd number of segments.");
                var h = new nt(f);
                s.push(It(e, h));
            } else {
                var l = hu(n, r, c);
                s.push(l);
            }
        }
        return new Yt(s, o);
    }(t.C_, t.firestore.I_, i, e, n, r);
}

function $u(t, e, n) {
    if (n instanceof x && (n = n._), "string" == typeof n) {
        if ("" === n) throw new P(R.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid document ID, but it was an empty string.");
        if (!ae(e) && -1 !== n.indexOf("/")) throw new P(R.INVALID_ARGUMENT, "Invalid query. When querying a collection by FieldPath.documentId(), you must provide a plain document ID, but '" + n + "' contains a '/' character.");
        var r = e.path.child($.ct(n));
        if (!nt.Et(r)) throw new P(R.INVALID_ARGUMENT, "Invalid query. When querying a collection group by FieldPath.documentId(), the value provided must result in a valid document path, but '" + r + "' is not because it has an odd number of segments (" + r.length + ").");
        return It(t, new nt(r));
    }
    if (n instanceof jo) return It(t, n.S_);
    throw new P(R.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid string or a DocumentReference, but it was: " + Po(n) + ".");
}

/**
 * Validates that the value passed into a disjunctive filter satisfies all
 * array requirements.
 */ function ts(t, e) {
    if (!Array.isArray(t) || 0 === t.length) throw new P(R.INVALID_ARGUMENT, "Invalid Query. A non-empty array is required for '" + e.toString() + "' filters.");
    if (t.length > 10) throw new P(R.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters support a maximum of 10 elements in the value array.");
}

function es(t, e, n) {
    if (!n.isEqual(e)) throw new P(R.INVALID_ARGUMENT, "Invalid query. You have a where filter with an inequality (<, <=, !=, not-in, >, or >=) on field '" + e.toString() + "' and so you must also use '" + e.toString() + "' as your first argument to orderBy(), but your first orderBy() is on field '" + n.toString() + "' instead.");
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function ns(t) {
    /**
 * Returns true if obj is an object and contains at least one of the specified
 * methods.
 */
    return function(t, e) {
        if ("object" != typeof t || null === t) return !1;
        for (var n = t, r = 0, i = [ "next", "error", "complete" ]; r < i.length; r++) {
            var o = i[r];
            if (o in n && "function" == typeof n[o]) return !0;
        }
        return !1;
    }(t);
}

function rs(t, e, n) {
    // Cast to `any` in order to satisfy the union type constraint on
    // toFirestore().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return t ? n && (n.merge || n.mergeFields) ? t.toFirestore(e, n) : t.toFirestore(e) : e;
}

var is = /** @class */ function(t) {
    function e(e) {
        var n = this;
        return (n = t.call(this) || this).firestore = e, n;
    }
    return w(e, t), e.prototype.Uf = function(t) {
        return new U(t);
    }, e.prototype.Qf = function(t) {
        var e = this.Gf(t, this.firestore.I_);
        return new jo(this.firestore, /* converter= */ null, e);
    }, e;
}(Fu), os = /** @class */ function() {
    /** @hideconstructor */
    function t(t, e) {
        this.hasPendingWrites = t, this.fromCache = e
        /**
     * Returns true if this `SnapshotMetadata` is equal to the provided one.
     *
     * @param other - The `SnapshotMetadata` to compare against.
     * @returns true if this `SnapshotMetadata` is equal to the provided one.
     */;
    }
    return t.prototype.isEqual = function(t) {
        return this.hasPendingWrites === t.hasPendingWrites && this.fromCache === t.fromCache;
    }, t;
}(), us = /** @class */ function(t) {
    /** @hideconstructor protected */
    function e(e, n, r, i, o, u) {
        var s = this;
        return (s = t.call(this, e, n, r, i, u) || this).zf = e, s.ad = e, s.metadata = o, 
        s;
    }
    /**
     * Property of the `DocumentSnapshot` that signals whether or not the data
     * exists. True if the document exists.
     */    return w(e, t), e.prototype.exists = function() {
        return t.prototype.exists.call(this);
    }, 
    /**
     * Retrieves all fields in the document as an `Object`. Returns `undefined` if
     * the document doesn't exist.
     *
     * By default, `FieldValue.serverTimestamp()` values that have not yet been
     * set to their final value will be returned as `null`. You can override
     * this by passing an options object.
     *
     * @param options - An options object to configure how data is retrieved from
     * the snapshot (for example the desired behavior for server timestamps that
     * have not yet been set to their final value).
     * @returns An `Object` containing all fields in the document or `undefined` if
     * the document doesn't exist.
     */
    e.prototype.data = function(t) {
        if (void 0 === t && (t = {}), this.Jf) {
            if (this.v_) {
                // We only want to use the converter and create a new DocumentSnapshot
                // if a converter has been provided.
                var e = new ss(this.zf, this.Hf, this.S_, this.Jf, this.metadata, 
                /* converter= */ null);
                return this.v_.fromFirestore(e, t);
            }
            return this.Hf.$f(this.Jf.vt(), t.serverTimestamps);
        }
    }, 
    /**
     * Retrieves the field specified by `fieldPath`. Returns `undefined` if the
     * document or field doesn't exist.
     *
     * By default, a `FieldValue.serverTimestamp()` that has not yet been set to
     * its final value will be returned as `null`. You can override this by
     * passing an options object.
     *
     * @param fieldPath - The path (for example 'foo' or 'foo.bar') to a specific
     * field.
     * @param options - An options object to configure how the field is retrieved
     * from the snapshot (for example the desired behavior for server timestamps
     * that have not yet been set to their final value).
     * @returns The data at the specified field location or undefined if no such
     * field exists in the document.
     */
    // We are using `any` here to avoid an explicit cast by our users.
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    e.prototype.get = function(t, e) {
        if (void 0 === e && (e = {}), this.Jf) {
            var n = this.Jf.data().field(Gu("DocumentSnapshot.get", t));
            if (null !== n) return this.Hf.$f(n, e.serverTimestamps);
        }
    }, e;
}(ju), ss = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    /**
     * Retrieves all fields in the document as an `Object`.
     *
     * By default, `FieldValue.serverTimestamp()` values that have not yet been
     * set to their final value will be returned as `null`. You can override
     * this by passing an options object.
     *
     * @override
     * @param options - An options object to configure how data is retrieved from
     * the snapshot (for example the desired behavior for server timestamps that
     * have not yet been set to their final value).
     * @returns An `Object` containing all fields in the document.
     */    return w(e, t), e.prototype.data = function(e) {
        return void 0 === e && (e = {}), t.prototype.data.call(this, e);
    }, e;
}(us), as = /** @class */ function() {
    /** @hideconstructor */
    function t(t, e, n, r) {
        this.zf = t, this.Hf = e, this.ud = r, this.metadata = new os(r.hasPendingWrites, r.fromCache), 
        this.query = n;
    }
    return Object.defineProperty(t.prototype, "docs", {
        /** An array of all the documents in the `QuerySnapshot`. */ get: function() {
            var t = [];
            return this.forEach((function(e) {
                return t.push(e);
            })), t;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "size", {
        /** The number of documents in the `QuerySnapshot`. */ get: function() {
            return this.ud.docs.size;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "empty", {
        /** True if there are no documents in the `QuerySnapshot`. */ get: function() {
            return 0 === this.size;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Enumerates all of the documents in the `QuerySnapshot`.
     *
     * @param callback - A callback to be called with a `QueryDocumentSnapshot` for
     * each document in the snapshot.
     * @param thisArg - The `this` binding for the callback.
     */
    t.prototype.forEach = function(t, e) {
        var n = this;
        this.ud.docs.forEach((function(r) {
            t.call(e, new ss(n.zf, n.Hf, r.key, r, new os(n.ud.Ce.has(r.key), n.ud.fromCache), n.query.v_));
        }));
    }, 
    /**
     * Returns an array of the documents changes since the last snapshot. If this
     * is the first snapshot, all documents will be in the list as 'added'
     * changes.
     *
     * @param options - `SnapshotListenOptions` that control whether metadata-only
     * changes (i.e. only `DocumentSnapshot.metadata` changed) should trigger
     * snapshot events.
     */
    t.prototype.docChanges = function(t) {
        void 0 === t && (t = {});
        var e = !!t.includeMetadataChanges;
        if (e && this.ud.Ne) throw new P(R.INVALID_ARGUMENT, "To include metadata changes with your document changes, you must also pass { includeMetadataChanges:true } to onSnapshot().");
        return this.hd && this.ld === e || (this.hd = 
        /** Calculates the array of DocumentChanges for a given ViewSnapshot. */
        function(t, e) {
            if (t.ud.De.nt()) {
                // Special case the first snapshot because index calculation is easy and
                // fast
                var n = 0;
                return t.ud.docChanges.map((function(e) {
                    var r = new ss(t.zf, t.Hf, e.doc.key, e.doc, new os(t.ud.Ce.has(e.doc.key), t.ud.fromCache), t.query.v_);
                    return e.doc, {
                        type: "added",
                        doc: r,
                        oldIndex: -1,
                        newIndex: n++
                    };
                }));
            }
            // A DocumentSet that is updated incrementally as changes are applied to use
            // to lookup the index of a document.
            var r = t.ud.De;
            return t.ud.docChanges.filter((function(t) {
                return e || 3 /* Metadata */ !== t.type;
            })).map((function(e) {
                var n = new ss(t.zf, t.Hf, e.doc.key, e.doc, new os(t.ud.Ce.has(e.doc.key), t.ud.fromCache), t.query.v_), i = -1, o = -1;
                return 0 /* Added */ !== e.type && (i = r.indexOf(e.doc.key), r = r.delete(e.doc.key)), 
                1 /* Removed */ !== e.type && (o = (r = r.add(e.doc)).indexOf(e.doc.key)), {
                    type: cs(e.type),
                    doc: n,
                    oldIndex: i,
                    newIndex: o
                };
            }));
        }(this, e), this.ld = e), this.hd;
    }, t;
}();

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Metadata about a snapshot, describing the state of the snapshot.
 */ function cs(t) {
    switch (t) {
      case 0 /* Added */ :
        return "added";

      case 2 /* Modified */ :
      case 3 /* Metadata */ :
        return "modified";

      case 1 /* Removed */ :
        return "removed";

      default:
        return A();
    }
}

// TODO(firestoreexp): Add tests for snapshotEqual with different snapshot
// metadata
/**
 * Returns true if the provided snapshots are equal.
 *
 * @param left - A snapshot to compare.
 * @param right - A snapshot to compare.
 * @returns true if the snapshots are equal.
 */ function fs(t, e) {
    return t instanceof us && e instanceof us ? t.zf === e.zf && t.S_.isEqual(e.S_) && (null === t.Jf ? null === e.Jf : t.Jf.isEqual(e.Jf)) && t.v_ === e.v_ : t instanceof as && e instanceof as && t.zf === e.zf && Jo(t.query, e.query) && t.metadata.isEqual(e.metadata) && t.ud.isEqual(e.ud);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Reads the document referred to by this `DocumentReference`.
 *
 * Note: `getDoc()` attempts to provide up-to-date data when possible by waiting
 * for data from the server, but it may return cached data or fail if you are
 * offline and the server cannot be reached. To specify this behavior, invoke
 * {@link getDocFromCache} or {@link getDocFromServer}.
 *
 * @param reference - The reference of the document to fetch.
 * @returns A Promise resolved with a `DocumentSnapshot` containing the
 * current document contents.
 */ var hs = /** @class */ function(t) {
    function e(e) {
        var n = this;
        return (n = t.call(this) || this).firestore = e, n;
    }
    return w(e, t), e.prototype.Uf = function(t) {
        return new U(t);
    }, e.prototype.Qf = function(t) {
        var e = this.Gf(t, this.firestore.I_);
        return new jo(this.firestore, /* converter= */ null, e);
    }, e;
}(Fu);

/**
 * Reads the document referred to by this `DocumentReference` from cache.
 * Returns an error if the document is not currently cached.
 *
 * @returns A Promise resolved with a `DocumentSnapshot` containing the
 * current document contents.
 */ function ls(t, e, n) {
    for (var r = [], i = 3; i < arguments.length; i++) r[i - 3] = arguments[i];
    t = Uo(t, jo);
    var o = Uo(t.firestore, xu), u = eu(o);
    // For Compat types, we have to "extract" the underlying types before
    // performing validation.
    return e instanceof x && (e = e._), ds(o, [ ("string" == typeof e || e instanceof Do ? fu(u, "updateDoc", t.S_, e, n, r) : cu(u, "updateDoc", t.S_, e)).F_(t.S_, Ue.exists(!0)) ]);
}

/**
 * Deletes the document referred to by the specified `DocumentReference`.
 *
 * @param reference - A reference to the document to delete.
 * @returns A Promise resolved once the document has been successfully
 * deleted from the backend (note that it won't resolve while you're offline).
 */ function ps(t) {
    for (var e, n, r, i = [], o = 1; o < arguments.length; o++) i[o - 1] = arguments[o];
    t instanceof x && (t = t._);
    var u = {
        includeMetadataChanges: !1
    }, s = 0;
    "object" != typeof i[s] || ns(i[s]) || (u = i[s], s++);
    var a, c, f, h = {
        includeMetadataChanges: u.includeMetadataChanges
    };
    if (ns(i[s])) {
        var l = i[s];
        i[s] = null === (e = l.next) || void 0 === e ? void 0 : e.bind(l), i[s + 1] = null === (n = l.error) || void 0 === n ? void 0 : n.bind(l), 
        i[s + 2] = null === (r = l.complete) || void 0 === r ? void 0 : r.bind(l);
    }
    if (t instanceof jo) c = Uo(t.firestore, xu), f = re(t.S_.path), a = {
        next: function(e) {
            i[s] && i[s](vs(c, t, e));
        },
        error: i[s + 1],
        complete: i[s + 2]
    }; else {
        var p = Uo(t, zo);
        c = Uo(p.firestore, xu), f = p.C_;
        var d = new hs(c);
        a = {
            next: function(t) {
                i[s] && i[s](new as(c, d, p, t));
            },
            error: i[s + 1],
            complete: i[s + 2]
        }, Hu(t.C_);
    }
    return function(t, e, n, r) {
        var i = this, o = new Ao(r), u = new Hi(e, o, n);
        return t.fs.ys((function() {
            return y(i, void 0, void 0, (function() {
                var e;
                return g(this, (function(n) {
                    switch (n.label) {
                      case 0:
                        return e = Mi, [ 4 /*yield*/ , Lu(t) ];

                      case 1:
                        return [ 2 /*return*/ , e.apply(void 0, [ n.sent(), u ]) ];
                    }
                }));
            }));
        })), function() {
            o.r_(), t.fs.ys((function() {
                return y(i, void 0, void 0, (function() {
                    var e;
                    return g(this, (function(n) {
                        switch (n.label) {
                          case 0:
                            return e = Fi, [ 4 /*yield*/ , Lu(t) ];

                          case 1:
                            return [ 2 /*return*/ , e.apply(void 0, [ n.sent(), u ]) ];
                        }
                    }));
                }));
            }));
        };
    }(qu(c), f, h, a);
}

/** Locally writes `mutations` on the async queue. */ function ds(t, e) {
    return function(t, e) {
        var n = this, r = new ar;
        return t.fs.ys((function() {
            return y(n, void 0, void 0, (function() {
                var n;
                return g(this, (function(i) {
                    switch (i.label) {
                      case 0:
                        return n = io, [ 4 /*yield*/ , Cu(t) ];

                      case 1:
                        return [ 2 /*return*/ , n.apply(void 0, [ i.sent(), e, r ]) ];
                    }
                }));
            }));
        })), r.promise;
    }(qu(t), e);
}

/**
 * Converts a ViewSnapshot that contains the single document specified by `ref`
 * to a DocumentSnapshot.
 */ function vs(t, e, n) {
    var r = n.docs.get(e.S_), i = new hs(t);
    return new us(t, i, e.S_, r, new os(n.hasPendingWrites, n.fromCache), e.v_);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A write batch, used to perform multiple writes as a single atomic unit.
 *
 * A `WriteBatch` object can be acquired by calling {@link writeBatch}. It
 * provides methods for adding writes to the write batch. None of the writes
 * will be committed (or visible locally) until {@link WriteBatch#commit} is
 * called.
 */ var ys = /** @class */ function() {
    /** @hideconstructor */
    function t(t, e) {
        this.zf = t, this._d = e, this.fd = [], this.dd = !1, this.wd = eu(t);
    }
    return t.prototype.set = function(t, e, n) {
        this.Ed();
        var r = gs(t, this.zf), i = rs(r.v_, e, n), o = nu(this.wd, "WriteBatch.set", r.S_, i, null !== r.v_, n);
        return this.fd.push(o.F_(r.S_, Ue.Wt())), this;
    }, t.prototype.update = function(t, e, n) {
        for (var r = [], i = 3; i < arguments.length; i++) r[i - 3] = arguments[i];
        this.Ed();
        var o, u = gs(t, this.zf);
        // For Compat types, we have to "extract" the underlying types before
        // performing validation.
                return e instanceof x && (e = e._), o = "string" == typeof e || e instanceof Do ? fu(this.wd, "WriteBatch.update", u.S_, e, n, r) : cu(this.wd, "WriteBatch.update", u.S_, e), 
        this.fd.push(o.F_(u.S_, Ue.exists(!0))), this;
    }, 
    /**
     * Deletes the document referred to by the provided {@link DocumentReference}.
     *
     * @param documentRef - A reference to the document to be deleted.
     * @returns This `WriteBatch` instance. Used for chaining method calls.
     */
    t.prototype.delete = function(t) {
        this.Ed();
        var e = gs(t, this.zf);
        return this.fd = this.fd.concat(new Ze(e.S_, Ue.Wt())), this;
    }, 
    /**
     * Commits all of the writes in this write batch as a single atomic unit.
     *
     * The result of these writes will only be reflected in document reads that
     * occur after the returned Promise resolves. If the client is offline, the
     * write fails. If you would like to see local modifications or buffer writes
     * until the client is online, use the full Firestore SDK.
     *
     * @returns A Promise resolved once all of the writes in the batch have been
     * successfully written to the backend as an atomic unit (note that it won't
     * resolve while you're offline).
     */
    t.prototype.commit = function() {
        return this.Ed(), this.dd = !0, this.fd.length > 0 ? this._d(this.fd) : Promise.resolve();
    }, t.prototype.Ed = function() {
        if (this.dd) throw new P(R.FAILED_PRECONDITION, "A write batch can no longer be used after commit() has been called.");
    }, t;
}();

function gs(t, e) {
    if (t instanceof x && (t = t._), t.firestore !== e) throw new P(R.INVALID_ARGUMENT, "Provided document reference is from a different Firestore instance.");
    return t;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// TODO(mrschmidt) Consider using `BaseTransaction` as the base class in the
// legacy SDK.
/**
 * A reference to a transaction.
 *
 * The `Transaction` object passed to a transaction's `updateFunction` provides
 * the methods to read and write data within the transaction context. See
 * {@link runTransaction}.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A reference to a transaction.
 *
 * The `Transaction` object passed to a transaction's `updateFunction` provides
 * the methods to read and write data within the transaction context. See
 * {@link runTransaction}.
 */ var ms = /** @class */ function(t) {
    // This class implements the same logic as the Transaction API in the Lite SDK
    // but is subclassed in order to return its own DocumentSnapshot types.
    /** @hideconstructor */
    function e(e, n) {
        var r = this;
        return (r = t.call(this, e, n) || this).zf = e, r;
    }
    /**
     * Reads the document referenced by the provided {@link DocumentReference}.
     *
     * @param documentRef - A reference to the document to be read.
     * @returns A `DocumentSnapshot` with the read data.
     */    return w(e, t), e.prototype.get = function(e) {
        var n = this, r = gs(e, this.zf), i = new hs(this.zf);
        return t.prototype.get.call(this, e).then((function(t) {
            return new us(n.zf, i, r.S_, t.Jf, new os(
            /* hasPendingWrites= */ !1, 
            /* fromCache= */ !1), r.v_);
        }));
    }, e;
}(/** @class */ function() {
    /** @hideconstructor */
    function t(t, e) {
        this.zf = t, this.Td = e, this.wd = eu(t)
        /**
     * Reads the document referenced by the provided {@link DocumentReference}.
     *
     * @param documentRef - A reference to the document to be read.
     * @returns A `DocumentSnapshot` with the read data.
     */;
    }
    return t.prototype.get = function(t) {
        var e = this, n = gs(t, this.zf), r = new is(this.zf);
        return this.Td.ef([ n.S_ ]).then((function(t) {
            if (!t || 1 !== t.length) return A();
            var i = t[0];
            if (i instanceof Rt) return new ju(e.zf, r, n.S_, null, n.v_);
            if (i instanceof Vt) return new ju(e.zf, r, i.key, i, n.v_);
            throw A();
        }));
    }, t.prototype.set = function(t, e, n) {
        var r = gs(t, this.zf), i = rs(r.v_, e, n), o = nu(this.wd, "Transaction.set", r.S_, i, null !== r.v_, n);
        return this.Td.set(r.S_, o), this;
    }, t.prototype.update = function(t, e, n) {
        for (var r = [], i = 3; i < arguments.length; i++) r[i - 3] = arguments[i];
        var o, u = gs(t, this.zf);
        // For Compat types, we have to "extract" the underlying types before
        // performing validation.
                return e instanceof x && (e = e._), o = "string" == typeof e || e instanceof Do ? fu(this.wd, "Transaction.update", u.S_, e, n, r) : cu(this.wd, "Transaction.update", u.S_, e), 
        this.Td.update(u.S_, o), this;
    }, 
    /**
     * Deletes the document referred to by the provided {@link DocumentReference}.
     *
     * @param documentRef - A reference to the document to be deleted.
     * @returns This `Transaction` instance. Used for chaining method calls.
     */
    t.prototype.delete = function(t) {
        var e = gs(t, this.zf);
        return this.Td.delete(e.S_), this;
    }, t;
}()), ws = "You are using the memory-only build of Firestore. Persistence support is only available via the @firebase/firestore bundle or the firebase-firestore.js build.", bs = /** @class */ function() {
    function t() {}
    return t.prototype.enableIndexedDbPersistence = function(t, e) {
        throw new P(R.FAILED_PRECONDITION, ws);
    }, t.prototype.enableMultiTabIndexedDbPersistence = function(t) {
        throw new P(R.FAILED_PRECONDITION, ws);
    }, t.prototype.clearIndexedDbPersistence = function(t) {
        throw new P(R.FAILED_PRECONDITION, ws);
    }, t;
}(), _s = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this, n) || this).Id = r, i.INTERNAL = {
            delete: function() {
                return i.terminate();
            }
        }, e instanceof z || (i.md = e), i;
    }
    return w(e, t), Object.defineProperty(e.prototype, "I_", {
        get: function() {
            return this._.I_;
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.settings = function(t) {
        t.merge && 
        // Remove the property from the settings once the merge is completed
        delete (t = Object.assign(Object.assign({}, this._.V_()), t)).merge, this._.g_(t);
    }, e.prototype.useEmulator = function(t, e) {
        !function(t, e, n) {
            var r = (t = Uo(t, Fo)).V_();
            "firestore.googleapis.com" !== r.host && r.host !== e && T("Host has been set in both settings() and useEmulator(), emulator host will be used"), 
            t.g_(Object.assign(Object.assign({}, r), {
                host: e + ":" + n,
                ssl: !1
            }));
        }(this._, t, e);
    }, e.prototype.enableNetwork = function() {
        return function(t) {
            var e = this;
            return t.fs.enqueue((function() {
                return y(e, void 0, void 0, (function() {
                    var e, n;
                    return g(this, (function(r) {
                        switch (r.label) {
                          case 0:
                            return [ 4 /*yield*/ , Du(t) ];

                          case 1:
                            return e = r.sent(), [ 4 /*yield*/ , Ou(t) ];

                          case 2:
                            return n = r.sent(), [ 2 /*return*/ , (e.Vo(!0), function(t) {
                                var e = D(t);
                                return e.Fh.delete(0 /* UserDisabled */), li(e);
                            }(n)) ];
                        }
                    }));
                }));
            }));
        }
        /** Disables the network connection. Pending operations will not complete. */ (qu(Uo(this._, xu)));
    }, e.prototype.disableNetwork = function() {
        return function(t) {
            var e = this;
            return t.fs.enqueue((function() {
                return y(e, void 0, void 0, (function() {
                    var e, n;
                    return g(this, (function(r) {
                        switch (r.label) {
                          case 0:
                            return [ 4 /*yield*/ , Du(t) ];

                          case 1:
                            return e = r.sent(), [ 4 /*yield*/ , Ou(t) ];

                          case 2:
                            return n = r.sent(), [ 2 /*return*/ , (e.Vo(!1), function(t) {
                                return y(this, void 0, void 0, (function() {
                                    var e;
                                    return g(this, (function(n) {
                                        switch (n.label) {
                                          case 0:
                                            return (e = D(t)).Fh.add(0 /* UserDisabled */), [ 4 /*yield*/ , pi(e) ];

                                          case 1:
                                            return n.sent(), 
                                            // Set the OnlineState to Offline so get()s return from cache, etc.
                                            e.Mh.set("Offline" /* Offline */), [ 2 /*return*/ ];
                                        }
                                    }));
                                }));
                            }(n)) ];
                        }
                    }));
                }));
            }));
        }
        /**
 * Returns a Promise that resolves when all writes that were pending at the time
 * this method was called received server acknowledgement. An acknowledgement
 * can be either acceptance or rejection.
 */ (qu(Uo(this._, xu)));
    }, e.prototype.enablePersistence = function(t) {
        var e = !1, n = !1;
        return t && Lo("synchronizeTabs", e = !!t.synchronizeTabs, "experimentalForceOwningTab", n = !!t.experimentalForceOwningTab), 
        e ? this.Id.enableMultiTabIndexedDbPersistence(this) : this.Id.enableIndexedDbPersistence(this, n);
    }, e.prototype.clearPersistence = function() {
        return this.Id.clearIndexedDbPersistence(this);
    }, e.prototype.terminate = function() {
        return this.md && (this.md._removeServiceInstance("firestore"), this.md._removeServiceInstance("firestore-exp")), 
        this._._delete();
    }, e.prototype.waitForPendingWrites = function() {
        return function(t) {
            var e = this, n = new ar;
            return t.fs.ys((function() {
                return y(e, void 0, void 0, (function() {
                    var e;
                    return g(this, (function(r) {
                        switch (r.label) {
                          case 0:
                            return e = fo, [ 4 /*yield*/ , Cu(t) ];

                          case 1:
                            return [ 2 /*return*/ , e.apply(void 0, [ r.sent(), n ]) ];
                        }
                    }));
                }));
            })), n.promise;
        }(qu(Uo(this._, xu)));
    }, e.prototype.onSnapshotsInSync = function(t) {
        return function(t, e) {
            return function(t, e) {
                var n = this, r = new Ao(e);
                return t.fs.ys((function() {
                    return y(n, void 0, void 0, (function() {
                        var e;
                        return g(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                return e = function(t, e) {
                                    D(t).jh.add(e), 
                                    // Immediately fire an initial event, indicating all existing listeners
                                    // are in-sync.
                                    e.next();
                                }, [ 4 /*yield*/ , Lu(t) ];

                              case 1:
                                return [ 2 /*return*/ , e.apply(void 0, [ n.sent(), r ]) ];
                            }
                        }));
                    }));
                })), function() {
                    r.r_(), t.fs.ys((function() {
                        return y(n, void 0, void 0, (function() {
                            var e;
                            return g(this, (function(n) {
                                switch (n.label) {
                                  case 0:
                                    return e = function(t, e) {
                                        D(t).jh.delete(e);
                                    }, [ 4 /*yield*/ , Lu(t) ];

                                  case 1:
                                    return [ 2 /*return*/ , e.apply(void 0, [ n.sent(), r ]) ];
                                }
                            }));
                        }));
                    }));
                }
                /**
 * Takes an updateFunction in which a set of reads and writes can be performed
 * atomically. In the updateFunction, the client can read and write values
 * using the supplied transaction object. After the updateFunction, all
 * changes will be committed. If a retryable error occurs (ex: some other
 * client has changed any of the data referenced), then the updateFunction
 * will be called again after a backoff. If the updateFunction still fails
 * after all retries, then the transaction will be rejected.
 *
 * The transaction object passed to the updateFunction contains methods for
 * accessing documents and collections. Unlike other datastore access, data
 * accessed with the transaction will not reflect local changes that have not
 * been committed. For this reason, it is required that all reads are
 * performed before any writes. Transactions must be performed while online.
 */;
            }(qu(t = Uo(t, xu)), ns(e) ? e : {
                next: e
            });
        }(this._, t);
    }, Object.defineProperty(e.prototype, "app", {
        get: function() {
            if (!this.md) throw new P(R.FAILED_PRECONDITION, "Firestore was not initialized using the Firebase SDK. 'app' is not available");
            return this.md;
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.collection = function(t) {
        try {
            return new Us(this, Ho(this._, t));
        } catch (t) {
            throw Ds(t, "collection()", "Firestore.collection()");
        }
    }, e.prototype.doc = function(t) {
        try {
            return new Ss(this, Bo(this._, t));
        } catch (t) {
            throw Ds(t, "doc()", "Firestore.doc()");
        }
    }, e.prototype.collectionGroup = function(t) {
        try {
            return new Vs(this, function(t, e) {
                if (t = Uo(t, Fo), Oo("collectionGroup", "collection id", e), e.indexOf("/") >= 0) throw new P(R.INVALID_ARGUMENT, "Invalid collection ID '" + e + "' passed to function collectionGroup(). Collection IDs must not contain '/'.");
                return new zo(t, 
                /* converter= */ null, 
                /**
 * Creates a new Query for a collection group query that matches all documents
 * within the provided collection group.
 */
                function(t) {
                    return new ne($.at(), t);
                }(e));
            }(this._, t));
        } catch (t) {
            throw Ds(t, "collectionGroup()", "Firestore.collectionGroup()");
        }
    }, e.prototype.runTransaction = function(t) {
        var e = this;
        return function(t, e) {
            return function(t, e) {
                var n = this, r = new ar;
                return t.fs.ys((function() {
                    return y(n, void 0, void 0, (function() {
                        var n;
                        return g(this, (function(i) {
                            switch (i.label) {
                              case 0:
                                return [ 4 /*yield*/ , function(t) {
                                    return Su(t).then((function(t) {
                                        return t.Dh;
                                    }));
                                }(t) ];

                              case 1:
                                return n = i.sent(), new Eu(t.fs, n, e, r).run(), [ 2 /*return*/ ];
                            }
                        }));
                    }));
                })), r.promise;
            }(qu(t), (function(n) {
                return e(new ms(t, n));
            }));
        }(this._, (function(n) {
            return t(new Ts(e, n));
        }));
    }, e.prototype.batch = function() {
        var t = this;
        return qu(this._), new Ns(new ys(this._, (function(e) {
            return ds(t._, e);
        })));
    }, e.prototype.loadBundle = function(t) {
        throw new P(R.FAILED_PRECONDITION, '"loadBundle()" does not exist, have you imported "firebase/firestore/bundle"?');
    }, e.prototype.namedQuery = function(t) {
        throw new P(R.FAILED_PRECONDITION, '"namedQuery()" does not exist, have you imported "firebase/firestore/bundle"?');
    }, e;
}(x), Es = /** @class */ function(t) {
    function e(e) {
        var n = this;
        return (n = t.call(this) || this).firestore = e, n;
    }
    return w(e, t), e.prototype.Uf = function(t) {
        return new F(new U(t));
    }, e.prototype.Qf = function(t) {
        var e = this.Gf(t, this.firestore.I_);
        return Ss.Ad(e, this.firestore, /* converter= */ null);
    }, e;
}(Fu);

/**
 * Executes the given `updateFunction` and then attempts to commit the changes
 * applied within the transaction. If any document read within the transaction
 * has changed, Cloud Firestore retries the `updateFunction`. If it fails to
 * commit after 5 attempts, the transaction fails.
 *
 * The maximum number of writes allowed in a single transaction is 500.
 *
 * @param firestore - A reference to the Firestore database to run this
 * transaction against.
 * @param updateFunction - The function to execute within the transaction
 * context.
 * @returns If the transaction completed successfully or was explicitly aborted
 * (the `updateFunction` returned a failed promise), the promise returned by the
 * `updateFunction `is returned here. Otherwise, if the transaction failed, a
 * rejected promise with the corresponding failure error is returned.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function Is(t) {
    var e;
    e = t, b.setLogLevel(e);
}

/**
 * A reference to a transaction.
 */ var Ts = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, n) || this).zf = e, r.Hf = new Es(e), r;
    }
    return w(e, t), e.prototype.get = function(t) {
        var e = this, n = xs(t);
        return this._.get(n).then((function(t) {
            return new Cs(e.zf, new us(e.zf._, e.Hf, t.S_, t.Jf, t.metadata, n.v_));
        }));
    }, e.prototype.set = function(t, e, n) {
        var r = xs(t);
        return n ? (Co("Transaction.set", n), this._.set(r, e, n)) : this._.set(r, e), this;
    }, e.prototype.update = function(t, e, n) {
        for (var r, i = [], o = 3; o < arguments.length; o++) i[o - 3] = arguments[o];
        var u = xs(t);
        return 2 === arguments.length ? this._.update(u, e) : (r = this._).update.apply(r, m([ u, e, n ], i)), 
        this;
    }, e.prototype.delete = function(t) {
        var e = xs(t);
        return this._.delete(e), this;
    }, e;
}(x), Ns = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e.prototype.set = function(t, e, n) {
        var r = xs(t);
        return n ? (Co("WriteBatch.set", n), this._.set(r, e, n)) : this._.set(r, e), this;
    }, e.prototype.update = function(t, e, n) {
        for (var r, i = [], o = 3; o < arguments.length; o++) i[o - 3] = arguments[o];
        var u = xs(t);
        return 2 === arguments.length ? this._.update(u, e) : (r = this._).update.apply(r, m([ u, e, n ], i)), 
        this;
    }, e.prototype.delete = function(t) {
        var e = xs(t);
        return this._.delete(e), this;
    }, e.prototype.commit = function() {
        return this._.commit();
    }, e;
}(x), As = /** @class */ function(t) {
    function e(e, n, r) {
        var i = this;
        return (i = t.call(this, r) || this).zf = e, i.Hf = n, i;
    }
    return w(e, t), e.prototype.fromFirestore = function(t, e) {
        var n = new ss(this.zf._, this.Hf, t.S_, t.Jf, t.metadata, 
        /* converter= */ null);
        return this._.fromFirestore(new Ls(this.zf, n), null != e ? e : {});
    }, e.prototype.toFirestore = function(t, e) {
        return e ? this._.toFirestore(t, e) : this._.toFirestore(t);
    }, 
    // Use the same instance of `FirestoreDataConverter` for the given instances
    // of `Firestore` and `PublicFirestoreDataConverter` so that isEqual() will
    // compare equal for two objects created with the same converter instance.
    e.Rd = function(t, n) {
        var r = e.Pd, i = r.get(t);
        i || (i = new WeakMap, r.set(t, i));
        var o = i.get(n);
        return o || (o = new e(t, new Es(t), n), i.set(n, o)), o;
    }, e;
}(x);

As.Pd = new WeakMap;

/**
 * A reference to a particular document in a collection in the database.
 */
var Ss = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, n) || this).firestore = e, r.Hf = new Es(e), r;
    }
    return w(e, t), e.yd = function(t, n, r) {
        if (t.length % 2 != 0) throw new P(R.INVALID_ARGUMENT, "Invalid document reference. Document references must have an even number of segments, but " + t.ot() + " has " + t.length);
        return new e(n, new jo(n._, r, new nt(t)));
    }, e.Ad = function(t, n, r) {
        return new e(n, new jo(n._, r, t));
    }, Object.defineProperty(e.prototype, "id", {
        get: function() {
            return this._.id;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "parent", {
        get: function() {
            return new Us(this.firestore, this._.parent);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "path", {
        get: function() {
            return this._.path;
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.collection = function(t) {
        try {
            return new Us(this.firestore, Ho(this._, t));
        } catch (t) {
            throw Ds(t, "collection()", "DocumentReference.collection()");
        }
    }, e.prototype.isEqual = function(t) {
        return t instanceof x && (t = t._), t instanceof jo && Ko(this._, t);
    }, e.prototype.set = function(t, e) {
        e = Co("DocumentReference.set", e);
        try {
            return function(t, e, n) {
                t = Uo(t, jo);
                var r = Uo(t.firestore, xu), i = rs(t.v_, e, n);
                return ds(r, [ nu(eu(r), "setDoc", t.S_, i, null !== t.v_, n).F_(t.S_, Ue.Wt()) ]);
            }(this._, t, e);
        } catch (t) {
            throw Ds(t, "setDoc()", "DocumentReference.set()");
        }
    }, e.prototype.update = function(t, e) {
        for (var n = [], r = 2; r < arguments.length; r++) n[r - 2] = arguments[r];
        try {
            return 1 === arguments.length ? ls(this._, t) : ls.apply(void 0, m([ this._, t, e ], n));
        } catch (t) {
            throw Ds(t, "updateDoc()", "DocumentReference.update()");
        }
    }, e.prototype.delete = function() {
        return ds(Uo((t = this._).firestore, xu), [ new Ze(t.S_, Ue.Wt()) ]);
        var t;
        /**
 * Add a new document to specified `CollectionReference` with the given data,
 * assigning it a document ID automatically.
 *
 * @param reference - A reference to the collection to add this document to.
 * @param data - An Object containing the data for the new document.
 * @returns A Promise resolved with a `DocumentReference` pointing to the
 * newly created document after it has been written to the backend (Note that it
 * won't resolve while you're offline).
 */    }, e.prototype.onSnapshot = function() {
        for (var t = this, e = [], n = 0; n < arguments.length; n++) e[n] = arguments[n];
        var r = ks(e), i = Os(e, (function(e) {
            return new Cs(t.firestore, new us(t.firestore._, t.Hf, e.S_, e.Jf, e.metadata, t._.v_));
        }));
        return ps(this._, r, i);
    }, e.prototype.get = function(t) {
        var e = this;
        return ("cache" === (null == t ? void 0 : t.source) ? function(t) {
            t = Uo(t, jo);
            var e = Uo(t.firestore, xu), n = qu(e), r = new hs(e);
            return function(t, e) {
                var n = this, r = new ar;
                return t.fs.ys((function() {
                    return y(n, void 0, void 0, (function() {
                        var n;
                        return g(this, (function(i) {
                            switch (i.label) {
                              case 0:
                                return n = function(t, e, n) {
                                    return y(this, void 0, void 0, (function() {
                                        var r, i;
                                        return g(this, (function(o) {
                                            switch (o.label) {
                                              case 0:
                                                return o.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , function(t, e) {
                                                    var n = D(t);
                                                    return n.persistence.runTransaction("read document", "readonly", (function(t) {
                                                        return n.Ic.Jo(t, e);
                                                    }));
                                                }(t, e) ];

                                              case 1:
                                                return (i = o.sent()) instanceof Vt ? n.resolve(i) : i instanceof Rt ? n.resolve(null) : n.reject(new P(R.UNAVAILABLE, "Failed to get document from cache. (However, this document may exist on the server. Run again without setting 'source' in the GetOptions to attempt to retrieve the document from the server.)")), 
                                                [ 3 /*break*/ , 3 ];

                                              case 2:
                                                return r = o.sent(), i = lr(r, "Failed to get document '" + e + " from cache"), 
                                                n.reject(i), [ 3 /*break*/ , 3 ];

                                              case 3:
                                                return [ 2 /*return*/ ];
                                            }
                                        }));
                                    }));
                                }, [ 4 /*yield*/ , ku(t) ];

                              case 1:
                                return [ 2 /*return*/ , n.apply(void 0, [ i.sent(), e, r ]) ];
                            }
                        }));
                    }));
                })), r.promise;
            }(n, t.S_).then((function(n) {
                return new us(e, r, t.S_, n, new os(n instanceof Vt && n.bt, 
                /* fromCache= */ !0), t.v_);
            }));
        }(this._) : "server" === (null == t ? void 0 : t.source) ? function(t) {
            t = Uo(t, jo);
            var e = Uo(t.firestore, xu);
            return Vu(qu(e), t.S_, {
                source: "server"
            }).then((function(n) {
                return vs(e, t, n);
            }));
        }(this._) : function(t) {
            t = Uo(t, jo);
            var e = Uo(t.firestore, xu);
            return Vu(qu(e), t.S_).then((function(n) {
                return vs(e, t, n);
            }));
        }(this._)).then((function(t) {
            return new Cs(e.firestore, new us(e.firestore._, e.Hf, t.S_, t.Jf, t.metadata, e._.v_));
        }));
    }, e.prototype.withConverter = function(t) {
        return new e(this.firestore, this._.withConverter(As.Rd(this.firestore, t)));
    }, e;
}(x);

/**
 * Replaces the function name in an error thrown by the firestore-exp API
 * with the function names used in the classic API.
 */ function Ds(t, e, n) {
    return t.message = t.message.replace(e, n), t
    /**
 * Iterates the list of arguments from an `onSnapshot` call and returns the
 * first argument that may be an `SnapshotListenOptions` object. Returns an
 * empty object if none is found.
 */;
}

function ks(t) {
    for (var e = 0, n = t; e < n.length; e++) {
        var r = n[e];
        if ("object" == typeof r && !ns(r)) return r;
    }
    return {};
}

/**
 * Creates an observer that can be passed to the firestore-exp SDK. The
 * observer converts all observed values into the format expected by the classic
 * SDK.
 *
 * @param args - The list of arguments from an `onSnapshot` call.
 * @param wrapper - The function that converts the firestore-exp type into the
 * type used by this shim.
 */ function Os(t, e) {
    var n, r, i;
    return {
        next: function(t) {
            i.next && i.next(e(t));
        },
        error: null === (n = (i = ns(t[0]) ? t[0] : ns(t[1]) ? t[1] : "function" == typeof t[0] ? {
            next: t[0],
            error: t[1],
            complete: t[2]
        } : {
            next: t[1],
            error: t[2],
            complete: t[3]
        }).error) || void 0 === n ? void 0 : n.bind(i),
        complete: null === (r = i.complete) || void 0 === r ? void 0 : r.bind(i)
    };
}

var Cs = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, n) || this).zf = e, r;
    }
    return w(e, t), Object.defineProperty(e.prototype, "ref", {
        get: function() {
            return new Ss(this.zf, this._.ref);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "id", {
        get: function() {
            return this._.id;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "metadata", {
        get: function() {
            return this._.metadata;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "exists", {
        get: function() {
            return this._.exists();
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.data = function(t) {
        return this._.data(t);
    }, e.prototype.get = function(t, e) {
        return this._.get(t, e);
    }, e.prototype.isEqual = function(t) {
        return fs(this._, t._);
    }, e;
}(x), Ls = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e.prototype.data = function(t) {
        return this._.data(t);
    }, e;
}(Cs), Vs = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, n) || this).firestore = e, r.Hf = new Es(e), r;
    }
    return w(e, t), e.prototype.where = function(t, n, r) {
        try {
            // The "as string" cast is a little bit of a hack. `where` accepts the
            // FieldPath Compat type as input, but is not typed as such in order to
            // not expose this via our public typings file.
            return new e(this.firestore, Ku(this._, function(t, e, n) {
                var r = e, i = Gu("where", t);
                return new Ju(i, r, n);
            }(t, n, r)));
        } catch (t) {
            throw Ds(t, /(orderBy|where)\(\)/, "Query.$1()");
        }
    }, e.prototype.orderBy = function(t, n) {
        try {
            // The "as string" cast is a little bit of a hack. `orderBy` accepts the
            // FieldPath Compat type as input, but is not typed as such in order to
            // not expose this via our public typings file.
            return new e(this.firestore, Ku(this._, function(t, e) {
                void 0 === e && (e = "asc");
                var n = e, r = Gu("orderBy", t);
                return new Wu(r, n);
            }(t, n)));
        } catch (t) {
            throw Ds(t, /(orderBy|where)\(\)/, "Query.$1()");
        }
    }, e.prototype.limit = function(t) {
        try {
            return new e(this.firestore, Ku(this._, function(t) {
                return xo("limit", t), new Qu("limit", t, "F" /* First */);
            }(t)));
        } catch (t) {
            throw Ds(t, "limit()", "Query.limit()");
        }
    }, e.prototype.limitToLast = function(t) {
        try {
            return new e(this.firestore, Ku(this._, function(t) {
                return xo("limitToLast", t), new Qu("limitToLast", t, "L" /* Last */);
            }(t)));
        } catch (t) {
            throw Ds(t, "limitToLast()", "Query.limitToLast()");
        }
    }, e.prototype.startAt = function() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        try {
            return new e(this.firestore, Ku(this._, function() {
                for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
                return new Yu("startAt", t, /*before=*/ !0);
            }.apply(void 0, t)));
        } catch (t) {
            throw Ds(t, "startAt()", "Query.startAt()");
        }
    }, e.prototype.startAfter = function() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        try {
            return new e(this.firestore, Ku(this._, function() {
                for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
                return new Yu("startAfter", t, 
                /*before=*/ !1);
            }.apply(void 0, t)));
        } catch (t) {
            throw Ds(t, "startAfter()", "Query.startAfter()");
        }
    }, e.prototype.endBefore = function() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        try {
            return new e(this.firestore, Ku(this._, function() {
                for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
                return new Xu("endBefore", t, /*before=*/ !0);
            }.apply(void 0, t)));
        } catch (t) {
            throw Ds(t, "endBefore()", "Query.endBefore()");
        }
    }, e.prototype.endAt = function() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        try {
            return new e(this.firestore, Ku(this._, function() {
                for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
                return new Xu("endAt", t, /*before=*/ !1);
            }.apply(void 0, t)));
        } catch (t) {
            throw Ds(t, "endAt()", "Query.endAt()");
        }
    }, e.prototype.isEqual = function(t) {
        return Jo(this._, t._);
    }, e.prototype.get = function(t) {
        var e = this;
        return ("cache" === (null == t ? void 0 : t.source) ? 
        /**
     * Executes the query and returns the results as a `QuerySnapshot` from cache.
     * Returns an error if the document is not currently cached.
     *
     * @returns A Promise that will be resolved with the results of the query.
     */
        function(t) {
            t = Uo(t, zo);
            var e = Uo(t.firestore, xu), n = qu(e), r = new hs(e);
            return function(t, e) {
                var n = this, r = new ar;
                return t.fs.ys((function() {
                    return y(n, void 0, void 0, (function() {
                        var n;
                        return g(this, (function(i) {
                            switch (i.label) {
                              case 0:
                                return n = function(t, e, n) {
                                    return y(this, void 0, void 0, (function() {
                                        var r, i, o, u, s;
                                        return g(this, (function(a) {
                                            switch (a.label) {
                                              case 0:
                                                return a.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , xr(t, e, 
                                                /* usePreviousResults= */ !0) ];

                                              case 1:
                                                return s = a.sent(), r = new Xi(e, s.Pc), i = r.dl(s.documents), o = r.Ei(i, 
                                                /* updateLimboDocuments= */ !1), n.resolve(o.snapshot), [ 3 /*break*/ , 3 ];

                                              case 2:
                                                return u = a.sent(), s = lr(u, "Failed to execute query '" + e + " against cache"), 
                                                n.reject(s), [ 3 /*break*/ , 3 ];

                                              case 3:
                                                return [ 2 /*return*/ ];
                                            }
                                        }));
                                    }));
                                }, [ 4 /*yield*/ , ku(t) ];

                              case 1:
                                return [ 2 /*return*/ , n.apply(void 0, [ i.sent(), e, r ]) ];
                            }
                        }));
                    }));
                })), r.promise;
            }(n, t.C_).then((function(n) {
                return new as(e, r, t, n);
            }));
        }(this._) : "server" === (null == t ? void 0 : t.source) ? function(t) {
            t = Uo(t, zo);
            var e = Uo(t.firestore, xu), n = qu(e), r = new hs(e);
            return Ru(n, t.C_, {
                source: "server"
            }).then((function(n) {
                return new as(e, r, t, n);
            }));
        }(this._) : function(t) {
            t = Uo(t, zo);
            var e = Uo(t.firestore, xu), n = qu(e), r = new hs(e);
            return Hu(t.C_), Ru(n, t.C_).then((function(n) {
                return new as(e, r, t, n);
            }));
        }(this._)).then((function(t) {
            return new Ps(e.firestore, new as(e.firestore._, e.Hf, e._, t.ud));
        }));
    }, e.prototype.onSnapshot = function() {
        for (var t = this, e = [], n = 0; n < arguments.length; n++) e[n] = arguments[n];
        var r = ks(e), i = Os(e, (function(e) {
            return new Ps(t.firestore, new as(t.firestore._, t.Hf, t._, e.ud));
        }));
        return ps(this._, r, i);
    }, e.prototype.withConverter = function(t) {
        return new e(this.firestore, this._.withConverter(As.Rd(this.firestore, t)));
    }, e;
}(x), Rs = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, n) || this).zf = e, r;
    }
    return w(e, t), Object.defineProperty(e.prototype, "type", {
        get: function() {
            return this._.type;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "doc", {
        get: function() {
            return new Ls(this.zf, this._.doc);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "oldIndex", {
        get: function() {
            return this._.oldIndex;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "newIndex", {
        get: function() {
            return this._.newIndex;
        },
        enumerable: !1,
        configurable: !0
    }), e;
}(x), Ps = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, n) || this).zf = e, r;
    }
    return w(e, t), Object.defineProperty(e.prototype, "query", {
        get: function() {
            return new Vs(this.zf, this._.query);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "metadata", {
        get: function() {
            return this._.metadata;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "size", {
        get: function() {
            return this._.size;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "empty", {
        get: function() {
            return this._.empty;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "docs", {
        get: function() {
            var t = this;
            return this._.docs.map((function(e) {
                return new Ls(t.zf, e);
            }));
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.docChanges = function(t) {
        var e = this;
        return this._.docChanges(t).map((function(t) {
            return new Rs(e.zf, t);
        }));
    }, e.prototype.forEach = function(t, e) {
        var n = this;
        this._.forEach((function(r) {
            t.call(e, new Ls(n.zf, r));
        }));
    }, e.prototype.isEqual = function(t) {
        return fs(this._, t._);
    }, e;
}(x), Us = /** @class */ function(t) {
    function e(e, n) {
        var r = this;
        return (r = t.call(this, e, n) || this).firestore = e, r._ = n, r;
    }
    return w(e, t), Object.defineProperty(e.prototype, "id", {
        get: function() {
            return this._.id;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "path", {
        get: function() {
            return this._.path;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(e.prototype, "parent", {
        get: function() {
            var t = this._.parent;
            return t ? new Ss(this.firestore, t) : null;
        },
        enumerable: !1,
        configurable: !0
    }), e.prototype.doc = function(t) {
        try {
            return new Ss(this.firestore, void 0 === t ? Bo(this._) : Bo(this._, t));
        } catch (t) {
            throw Ds(t, "doc()", "CollectionReference.doc()");
        }
    }, e.prototype.add = function(t) {
        var e = this;
        return function(t, e) {
            var n = Uo(t.firestore, xu), r = Bo(t), i = rs(t.v_, e);
            return ds(n, [ nu(eu(t.firestore), "addDoc", r.S_, i, null !== t.v_, {}).F_(r.S_, Ue.exists(!1)) ]).then((function() {
                return r;
            }));
        }(this._, t).then((function(t) {
            return new Ss(e.firestore, t);
        }));
    }, e.prototype.isEqual = function(t) {
        return Ko(this._, t._);
    }, e.prototype.withConverter = function(t) {
        return new e(this.firestore, this._.withConverter(As.Rd(this.firestore, t)));
    }, e;
}(Vs);

function xs(t) {
    return t instanceof x && (t = t._), Uo(t, jo);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// The objects that are a part of this API are exposed to third-parties as
// compiled javascript so we want to flag our private members with a leading
// underscore to discourage their use.
/**
 * A `FieldPath` refers to a field in a document. The path may consist of a
 * single field name (referring to a top-level field in the document), or a list
 * of field names (referring to a nested field in the document).
 */ var qs = /** @class */ function(t) {
    /**
     * Creates a FieldPath from the provided field names. If more than one field
     * name is provided, the path will point to a nested field in a document.
     *
     * @param fieldNames - A list of field names.
     */
    function e() {
        for (var e = [], n = 0; n < arguments.length; n++) e[n] = arguments[n];
        return t.call(this, new (Do.bind.apply(Do, m([ void 0 ], e)))) || this;
    }
    return w(e, t), e.documentId = function() {
        /**
         * Internal Note: The backend doesn't technically support querying by
         * document ID. Instead it queries by the entire document name (full path
         * included), but in the cases we currently support documentId(), the net
         * effect is the same.
         */
        return new e(et.lt().ot());
    }, e.prototype.isEqual = function(t) {
        return t instanceof x && (t = t._), t instanceof Do && this._.d_.isEqual(t.d_);
    }, e;
}(x), Ms = /** @class */ function(t) {
    function e() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return w(e, t), e.serverTimestamp = function() {
        var t = new ou("serverTimestamp");
        return t._methodName = "FieldValue.serverTimestamp", new e(t);
    }, e.delete = function() {
        var t = new ru("deleteField");
        return t._methodName = "FieldValue.delete", new e(t);
    }, e.arrayUnion = function() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        var r = 
        /**
 * Returns a special value that can be used with {@link setDoc} or {@link
 * updateDoc} that tells the server to union the given elements with any array
 * value that already exists on the server. Each specified element that doesn't
 * already exist in the array will be added to the end. If the field being
 * modified is not already an array it will be overwritten with an array
 * containing exactly the specified elements.
 *
 * @param elements - The elements to union into the array.
 * @returns The `FieldValue` sentinel for use in a call to `setDoc()` or
 * `updateDoc()`.
 */
        function() {
            for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
                        return new uu("arrayUnion", t);
        }.apply(void 0, t);
        return r._methodName = "FieldValue.arrayUnion", new e(r);
    }, e.arrayRemove = function() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        var r = function() {
            for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
            // NOTE: We don't actually parse the data until it's used in set() or
            // update() since we'd need the Firestore instance to do this.
                        return new su("arrayRemove", t);
        }.apply(void 0, t);
        return r._methodName = "FieldValue.arrayRemove", new e(r);
    }, e.increment = function(t) {
        var n = function(t) {
            return new au("increment", t);
        }(t);
        return n._methodName = "FieldValue.increment", new e(n);
    }, e.prototype.isEqual = function(t) {
        return this._.isEqual(t._);
    }, e;
}(x), Fs = /** @class */ function() {
    function t() {
        this.gd = {}, this.Vd = new ar, this.pd = {
            taskState: "Running",
            totalBytes: 0,
            totalDocuments: 0,
            bytesLoaded: 0,
            documentsLoaded: 0
        };
    }
    return t.prototype.onProgress = function(t, e, n) {
        this.gd = {
            next: t,
            error: e,
            complete: n
        };
    }, t.prototype.catch = function(t) {
        return this.Vd.promise.catch(t);
    }, t.prototype.then = function(t, e) {
        return this.Vd.promise.then(t, e);
    }, 
    /**
     * Notifies all observers that bundle loading has completed, with a provided
     * `LoadBundleTaskProgress` object.
     */
    t.prototype.Ul = function(t) {
        this.Ql(t), this.gd.complete && this.gd.complete(), this.Vd.resolve(t);
    }, 
    /**
     * Notifies all observers that bundle loading has failed, with a provided
     * `Error` as the reason.
     */
    t.prototype.Wl = function(t) {
        this.pd.taskState = "Error", this.gd.next && this.gd.next(this.pd), this.gd.error && this.gd.error(t), 
        this.Vd.reject(t);
    }, 
    /**
     * Notifies a progress update of loading a bundle.
     * @param progress - The new progress.
     */
    t.prototype.Ql = function(t) {
        this.pd = t, this.gd.next && this.gd.next(t);
    }, t;
}();

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns a sentinel for use with {@link updateDoc} or
 * {@link setDoc} with `{merge: true}` to mark a field for deletion.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function js(t, e) {
    var n = new Fs;
    return function(t, e, n, r) {
        var i = this, o = function(t, e) {
            return function(t, e) {
                return new So(t, e);
            }(function(t, e) {
                if (t instanceof Uint8Array) return No(t, e);
                if (t instanceof ArrayBuffer) return No(new Uint8Array(t), e);
                if (t instanceof ReadableStream) return t.getReader();
                throw new Error("Source of `toByteStreamReader` has to be a ArrayBuffer or ReadableStream");
            }("string" == typeof t ? (new TextEncoder).encode(t) : t), e);
        }(n, ii(e));
        t.fs.ys((function() {
            return y(i, void 0, void 0, (function() {
                var e;
                return g(this, (function(n) {
                    switch (n.label) {
                      case 0:
                        return e = Eo, [ 4 /*yield*/ , Cu(t) ];

                      case 1:
                        return e.apply(void 0, [ n.sent(), o, r ]), [ 2 /*return*/ ];
                    }
                }));
            }));
        }));
    }(qu(t._), t.I_, e, n), n;
}

function zs(t, e) {
    return function(t, e) {
        var n = this;
        return t.fs.enqueue((function() {
            return y(n, void 0, void 0, (function() {
                var n;
                return g(this, (function(r) {
                    switch (r.label) {
                      case 0:
                        return n = function(t, e) {
                            var n = D(t);
                            return n.persistence.runTransaction("Get named query", "readonly", (function(t) {
                                return n.Eo.$s(t, e);
                            }));
                        }, [ 4 /*yield*/ , ku(t) ];

                      case 1:
                        return [ 2 /*return*/ , n.apply(void 0, [ r.sent(), e ]) ];
                    }
                }));
            }));
        }));
    }(qu(t._), e).then((function(e) {
        return e ? new Vs(t, new zo(t._, null, e.query)) : null;
    }));
}

export { bs as B, Is as K, F as L, _s as U, Ts as W, Cs as X, xu as Z, Ss as a, Ls as b, Ps as c, Uu as d, js as e, Ns as j, Wo as n, Ms as o, qs as r, Us as s, Vs as t, zs as u, Y as z };
//# sourceMappingURL=prebuilt-03753c24-1ef42ae9.js.map
