'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

require('tslib');
require('crypto');
require('@firebase/logger');
require('util');
require('@firebase/util');
require('@grpc/grpc-js');
require('@grpc/grpc-js/package.json');
require('path');
require('@grpc/proto-loader');
var databaseA420afb3 = require('./database-a420afb3-ec4c8b13.js');

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var LoadBundleTask = /** @class */ (function () {
    function LoadBundleTask() {
        this._progressObserver = {};
        this._taskCompletionResolver = new databaseA420afb3.Deferred();
        this._lastProgress = {
            taskState: 'Running',
            totalBytes: 0,
            totalDocuments: 0,
            bytesLoaded: 0,
            documentsLoaded: 0
        };
    }
    LoadBundleTask.prototype.onProgress = function (next, error, complete) {
        this._progressObserver = {
            next: next,
            error: error,
            complete: complete
        };
    };
    LoadBundleTask.prototype.catch = function (onRejected) {
        return this._taskCompletionResolver.promise.catch(onRejected);
    };
    LoadBundleTask.prototype.then = function (onFulfilled, onRejected) {
        return this._taskCompletionResolver.promise.then(onFulfilled, onRejected);
    };
    /**
     * Notifies all observers that bundle loading has completed, with a provided
     * `LoadBundleTaskProgress` object.
     */
    LoadBundleTask.prototype._completeWith = function (progress) {
        this._updateProgress(progress);
        if (this._progressObserver.complete) {
            this._progressObserver.complete();
        }
        this._taskCompletionResolver.resolve(progress);
    };
    /**
     * Notifies all observers that bundle loading has failed, with a provided
     * `Error` as the reason.
     */
    LoadBundleTask.prototype._failWith = function (error) {
        this._lastProgress.taskState = 'Error';
        if (this._progressObserver.next) {
            this._progressObserver.next(this._lastProgress);
        }
        if (this._progressObserver.error) {
            this._progressObserver.error(error);
        }
        this._taskCompletionResolver.reject(error);
    };
    /**
     * Notifies a progress update of loading a bundle.
     * @param progress - The new progress.
     */
    LoadBundleTask.prototype._updateProgress = function (progress) {
        this._lastProgress = progress;
        if (this._progressObserver.next) {
            this._progressObserver.next(progress);
        }
    };
    return LoadBundleTask;
}());
function loadBundle(db, bundleData) {
    var resultTask = new LoadBundleTask();
    databaseA420afb3.firestoreClientLoadBundle(databaseA420afb3.ensureFirestoreConfigured(db._delegate), db._databaseId, bundleData, resultTask);
    return resultTask;
}
function namedQuery(db, name) {
    return databaseA420afb3.firestoreClientGetNamedQuery(databaseA420afb3.ensureFirestoreConfigured(db._delegate), name).then(function (namedQuery) {
        if (!namedQuery) {
            return null;
        }
        return new databaseA420afb3.Query$1(db, new databaseA420afb3.Query(db._delegate, null, namedQuery.query));
    });
}
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Prototype patches bundle loading to Firestore.
 */
function registerBundle(instance) {
    instance.prototype.loadBundle = function (data) {
        return loadBundle(this, data);
    };
    instance.prototype.namedQuery = function (queryName) {
        return namedQuery(this, queryName);
    };
}
registerBundle(databaseA420afb3.Firestore);

exports.registerBundle = registerBundle;
//# sourceMappingURL=bundle.js.map
