export interface DirectoryReaderSync {
    readEntries: (entries: FileSystemEntry[]) => void;
}
export interface FileSystemEntry {
    isDirectory: boolean;
    createReader: () => DirectoryReaderSync;
}
export declare type DroppedCallback = (files: FileSystemEntry[]) => void;
export declare const getFilesFromItems: (items: DataTransferItemList) => Promise<FileSystemEntry[]>;
export declare const getFilesFromFileSystemEntries: (fileSystemEntries: FileSystemEntry[]) => Promise<File[]>;
export declare class FileFlattener {
    dropzone: Element;
    callback: DroppedCallback;
    constructor(dropzone: Element, callback: DroppedCallback);
    subscribe(): void;
    private onDragOver;
    private onDrop;
}
export declare const flatFiles: (dropzone: Element, callback: DroppedCallback) => void;
export default flatFiles;
