import { __awaiter, __generator } from "tslib";
var flatten = function (arr) { return [].concat.apply([], arr); };
var toArray = function (arr) { return [].slice.call(arr, 0); };
var readEntries = function (entry) {
    return new Promise(function (resolve) {
        var reader = entry.createReader();
        // TODO: Investigate typing mismatch
        reader.readEntries(resolve);
    });
};
var getFilesFromEntry = function (entry) {
    if (entry.isDirectory) {
        return readEntries(entry).then(function (entries) {
            var promises = entries.map(getFilesFromEntry);
            return Promise.all(promises).then(function (result) { return flatten(result); });
        });
    }
    else {
        return Promise.resolve([entry]);
    }
};
export var getFilesFromItems = function (items) {
    var promises = toArray(items).map(function (item) {
        var entry = item.webkitGetAsEntry(); // webkitGetAsEntry returns any :(
        return getFilesFromEntry(entry);
    });
    return Promise.all(promises).then(function (files) {
        return flatten(files);
    });
};
export var getFilesFromFileSystemEntries = function (fileSystemEntries) {
    return new Promise(function (resolve) {
        var files = [];
        fileSystemEntries.forEach(function (fileSystemEntry) {
            // TODO: file method doesn't have typings
            fileSystemEntry.file(function (file) {
                files.push(file);
                if (files.length === fileSystemEntries.length) {
                    resolve(files);
                }
            });
        });
    });
};
var FileFlattener = /** @class */ (function () {
    function FileFlattener(dropzone, callback) {
        var _this = this;
        this.onDrop = function (e) { return __awaiter(_this, void 0, void 0, function () {
            var callback, items, files;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        e.preventDefault();
                        callback = this.callback;
                        items = e.dataTransfer.items;
                        return [4 /*yield*/, getFilesFromItems(items)];
                    case 1:
                        files = _a.sent();
                        callback(files);
                        return [2 /*return*/];
                }
            });
        }); };
        this.dropzone = dropzone;
        this.callback = callback;
    }
    FileFlattener.prototype.subscribe = function () {
        var dropzone = this.dropzone;
        dropzone.addEventListener('dragover', this.onDragOver, false);
        dropzone.addEventListener('drop', this.onDrop);
    };
    FileFlattener.prototype.onDragOver = function (e) {
        e.preventDefault();
    };
    return FileFlattener;
}());
export { FileFlattener };
export var flatFiles = function (dropzone, callback) {
    var flattener = new FileFlattener(dropzone, callback);
    flattener.subscribe();
};
export default flatFiles;
