# [Flaticon <UICONS>](https://www.flaticon.com/uicons/interface-icons)

Open-source Over 4,000 SVG and web font-optimal vector-based icons available for web, iOS, and Android applications.

![css.gg](https://media.flaticon.com/dist/min/img/interface-icons/uicons.png)

#### 🔥 New Icons Brand

#### 🚀 Over 20,000 Icons

#### 🔥 SVG Icons

#### 🦄 Figma Components####

# Table of Contents

- [Get Started](#get-started)
- [HTML include](#html-include)
  - [1. All icons](#1-all-icons)
  - [2. Single icon](#2-single-icon)
- [CSS @import](#css--import)
  - [1. All icons](#1-all-icons-1)
  - [2. Single icon](#2-single-icon-1)
  - [3. Example](#3-example)
- [License Summary](#4-ĺicense-summary)
- [How to attribute](#5-how-to-attribute)

# Get Started

Install the latest version via npm

```shell
npm i @flaticon/flaticon-uicons
```

Using Package Manager \
This package contains the following directories and files:

| Path &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; | What it is                   |
| :----------------------------------------------------------------------------------------------------- | :--------------------------- |
| /css                                                                                                   | Stylesheets for Web Fonts    |

# HTML include

#### Go to the user guide that you can find in [Flaticon <UICONS>](https://www.flaticon.com/uicons/get-started)

# CSS @import

#### 1. All icons

```css
@import "~@flaticon/flaticon-uicons/css/all/all";
```

#### 2. Single style

```css
@import "~@flaticon/flaticon-uicons/css/{FONTWEIGHT}/{STYLENAME}";
@import "~@flaticon/flaticon-uicons/css/brands/all";
```

| WEIGHT &nbsp; | CORNER &nbsp; | PREFIX &nbsp; | EXAMPLE                                 |
| :------------ | :------------ | :------------ | :-------------------------------------- |
| Regular       | Rounded       | fi-rr         | `<i class="fi fi-rr-user"></i>`         |
| Bold          | Rounded       | fi-br         | `<i class="fi fi-br-user"></i>`         |
| Solid         | Rounded       | fi-sr         | `<i class="fi fi-sr-user"></i>`         |
| Regular       | Straight      | fi-rs         | `<i class="fi fi-rs-user"></i>`         |
| Bold          | Straight      | fi-bs         | `<i class="fi fi-bs-user"></i>`         |
| Solid         | Straight      | fi-ss         | `<i class="fi fi-ss-user"></i>`         |
| Brands        | Brands        | fi-brands     | `<i class="fi fi-brands-facebook"></i>` |
| Thin          | Rounded       | fi-tr         | `<i class="fi fi-tr-circle-user"></i>` |
| Thin          | Straight      | fi-ts         | `<i class="fi fi-ts-circle-user"></i>`         |

##### 3. Example

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Document</title>
  </head>
  <body>
    <i class="fi fi-rr-user"></i>
    <i class="fi fi-br-arrow-right"></i>
    <i class="fi fi-sr-book"></i>
    <i class="fi fi-rr-broom"></i>
  </body>
</html>
```

#### 4. License Summary

Our license allows you to use the content:

For commercial and personal projects
On digital or printed media
For an unlimited number of times and perpetually
Anywhere in the world
To make modifications and derived works

This text is a summary for information only. It does not constitute any contractual obligations. For more information, please read our [Term of use](#https://www.freepikcompany.com/legal?&_ga=2.24802994.967760339.1641199092-339376165.1634591523&_gl=1*o0lkwh*test_ga*MzM5Mzc2MTY1LjE2MzQ1OTE1MjM.*test_ga_523JXC6VL7*MTY0MTMwMDk0NC4xMzUuMS4xNjQxMzAzNTgyLjU2*fp_ga*MzM5Mzc2MTY1LjE2MzQ1OTE1MjM.*fp_ga_1ZY8468CQB*MTY0MTMwMDk0NC4zNy4xLjE2NDEzMDM1ODIuNTY.#nav-flaticon) before using the content

#### 5. How to attribute

Creating quality icons takes a lot of time and effort. We only ask you to add a small attribution link. Choose the medium in which you are going to use the resource.

Copy this link and paste it wherever it’s visible, close to where you’re using the resource. If that’s not possible, place it at the footer of your website, blog or newsletter, or in the credits section.

```
Uicons by <a href="https://www.flaticon.com/uicons">Flaticon</a>
```
