/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("react"), require("react-dom"));
	else if(typeof define === 'function' && define.amd)
		define(["react", "react-dom"], factory);
	else if(typeof exports === 'object')
		exports["FlexLayout"] = factory(require("react"), require("react-dom"));
	else
		root["FlexLayout"] = factory(root["React"], root["ReactDOM"]);
})(self, (__WEBPACK_EXTERNAL_MODULE_react__, __WEBPACK_EXTERNAL_MODULE_react_dom__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/Attribute.ts":
/*!**************************!*\
  !*** ./src/Attribute.ts ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Attribute\": () => (/* binding */ Attribute)\n/* harmony export */ });\n/** @internal */\r\nclass Attribute {\r\n    constructor(name, modelName, defaultValue, alwaysWriteJson) {\r\n        this.name = name;\r\n        this.modelName = modelName;\r\n        this.defaultValue = defaultValue;\r\n        this.alwaysWriteJson = alwaysWriteJson;\r\n        this.required = false;\r\n        this.fixed = false;\r\n        this.type = \"any\";\r\n    }\r\n    setType(value) {\r\n        this.type = value;\r\n        return this;\r\n    }\r\n    setRequired() {\r\n        this.required = true;\r\n        return this;\r\n    }\r\n    setFixed() {\r\n        this.fixed = true;\r\n        return this;\r\n    }\r\n}\r\nAttribute.NUMBER = \"number\";\r\nAttribute.STRING = \"string\";\r\nAttribute.BOOLEAN = \"boolean\";\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/Attribute.ts?");

/***/ }),

/***/ "./src/AttributeDefinitions.ts":
/*!*************************************!*\
  !*** ./src/AttributeDefinitions.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"AttributeDefinitions\": () => (/* binding */ AttributeDefinitions)\n/* harmony export */ });\n/* harmony import */ var _Attribute__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Attribute */ \"./src/Attribute.ts\");\n\r\n/** @internal */\r\nclass AttributeDefinitions {\r\n    constructor() {\r\n        this.attributes = [];\r\n        this.nameToAttribute = {};\r\n    }\r\n    addWithAll(name, modelName, defaultValue, alwaysWriteJson) {\r\n        const attr = new _Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute(name, modelName, defaultValue, alwaysWriteJson);\r\n        this.attributes.push(attr);\r\n        this.nameToAttribute[name] = attr;\r\n        return attr;\r\n    }\r\n    addInherited(name, modelName) {\r\n        return this.addWithAll(name, modelName, undefined, false);\r\n    }\r\n    add(name, defaultValue, alwaysWriteJson) {\r\n        return this.addWithAll(name, undefined, defaultValue, alwaysWriteJson);\r\n    }\r\n    getAttributes() {\r\n        return this.attributes;\r\n    }\r\n    getModelName(name) {\r\n        const conversion = this.nameToAttribute[name];\r\n        if (conversion !== undefined) {\r\n            return conversion.modelName;\r\n        }\r\n        return undefined;\r\n    }\r\n    toJson(jsonObj, obj) {\r\n        for (const attr of this.attributes) {\r\n            const fromValue = obj[attr.name];\r\n            if (attr.alwaysWriteJson || fromValue !== attr.defaultValue) {\r\n                jsonObj[attr.name] = fromValue;\r\n            }\r\n        }\r\n    }\r\n    fromJson(jsonObj, obj) {\r\n        for (const attr of this.attributes) {\r\n            const fromValue = jsonObj[attr.name];\r\n            if (fromValue === undefined) {\r\n                obj[attr.name] = attr.defaultValue;\r\n            }\r\n            else {\r\n                obj[attr.name] = fromValue;\r\n            }\r\n        }\r\n    }\r\n    update(jsonObj, obj) {\r\n        for (const attr of this.attributes) {\r\n            if (jsonObj.hasOwnProperty(attr.name)) {\r\n                const fromValue = jsonObj[attr.name];\r\n                if (fromValue === undefined) {\r\n                    delete obj[attr.name];\r\n                }\r\n                else {\r\n                    obj[attr.name] = fromValue;\r\n                }\r\n            }\r\n        }\r\n    }\r\n    setDefaults(obj) {\r\n        for (const attr of this.attributes) {\r\n            obj[attr.name] = attr.defaultValue;\r\n        }\r\n    }\r\n    toTypescriptInterface(name, parentAttributes) {\r\n        const lines = [];\r\n        const sorted = this.attributes.sort((a, b) => a.name.localeCompare(b.name));\r\n        // const sorted = this.attributes;\r\n        lines.push(\"export interface I\" + name + \"Attributes {\");\r\n        for (let i = 0; i < sorted.length; i++) {\r\n            const c = sorted[i];\r\n            let type = c.type;\r\n            let defaultValue = undefined;\r\n            let attr = c;\r\n            let inherited = undefined;\r\n            if (attr.defaultValue !== undefined) {\r\n                defaultValue = attr.defaultValue;\r\n            }\r\n            else if (attr.modelName !== undefined\r\n                && parentAttributes !== undefined\r\n                && parentAttributes.nameToAttribute[attr.modelName] !== undefined) {\r\n                inherited = attr.modelName;\r\n                attr = parentAttributes.nameToAttribute[attr.modelName];\r\n                defaultValue = attr.defaultValue;\r\n                type = attr.type;\r\n            }\r\n            let defValue = JSON.stringify(defaultValue);\r\n            const required = attr.required || attr.fixed ? \"\" : \"?\";\r\n            if (c.fixed) {\r\n                lines.push(\"\\t\" + c.name + \": \" + defValue + \";\");\r\n            }\r\n            else {\r\n                const comment = (defaultValue !== undefined ? \"default: \" + defValue : \"\") +\r\n                    (inherited !== undefined ? \" - inherited from global \" + inherited : \"\");\r\n                lines.push(\"\\t\" + c.name + required + \": \" + type + \";\" +\r\n                    (comment.length > 0 ? \" // \" + comment : \"\"));\r\n            }\r\n        }\r\n        lines.push(\"}\");\r\n        return lines.join(\"\\n\");\r\n    }\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/AttributeDefinitions.ts?");

/***/ }),

/***/ "./src/DockLocation.ts":
/*!*****************************!*\
  !*** ./src/DockLocation.ts ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DockLocation\": () => (/* binding */ DockLocation)\n/* harmony export */ });\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Rect */ \"./src/Rect.ts\");\n\r\n\r\nclass DockLocation {\r\n    /** @internal */\r\n    constructor(name, orientation, indexPlus) {\r\n        this._name = name;\r\n        this._orientation = orientation;\r\n        this._indexPlus = indexPlus;\r\n        DockLocation.values[this._name] = this;\r\n    }\r\n    /** @internal */\r\n    static getByName(name) {\r\n        return DockLocation.values[name];\r\n    }\r\n    /** @internal */\r\n    static getLocation(rect, x, y) {\r\n        x = (x - rect.x) / rect.width;\r\n        y = (y - rect.y) / rect.height;\r\n        if (x >= 0.25 && x < 0.75 && y >= 0.25 && y < 0.75) {\r\n            return DockLocation.CENTER;\r\n        }\r\n        // Whether or not the point is in the bottom-left half of the rect\r\n        // +-----+\r\n        // |\\    |\r\n        // |x\\   |\r\n        // |xx\\  |\r\n        // |xxx\\ |\r\n        // |xxxx\\|\r\n        // +-----+\r\n        const bl = y >= x;\r\n        // Whether or not the point is in the bottom-right half of the rect\r\n        // +-----+\r\n        // |    /|\r\n        // |   /x|\r\n        // |  /xx|\r\n        // | /xxx|\r\n        // |/xxxx|\r\n        // +-----+\r\n        const br = y >= 1 - x;\r\n        if (bl) {\r\n            return br ? DockLocation.BOTTOM : DockLocation.LEFT;\r\n        }\r\n        else {\r\n            return br ? DockLocation.RIGHT : DockLocation.TOP;\r\n        }\r\n    }\r\n    getName() {\r\n        return this._name;\r\n    }\r\n    getOrientation() {\r\n        return this._orientation;\r\n    }\r\n    /** @internal */\r\n    getDockRect(r) {\r\n        if (this === DockLocation.TOP) {\r\n            return new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(r.x, r.y, r.width, r.height / 2);\r\n        }\r\n        else if (this === DockLocation.BOTTOM) {\r\n            return new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(r.x, r.getBottom() - r.height / 2, r.width, r.height / 2);\r\n        }\r\n        if (this === DockLocation.LEFT) {\r\n            return new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(r.x, r.y, r.width / 2, r.height);\r\n        }\r\n        else if (this === DockLocation.RIGHT) {\r\n            return new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(r.getRight() - r.width / 2, r.y, r.width / 2, r.height);\r\n        }\r\n        else {\r\n            return r.clone();\r\n        }\r\n    }\r\n    /** @internal */\r\n    split(rect, size) {\r\n        if (this === DockLocation.TOP) {\r\n            const r1 = new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(rect.x, rect.y, rect.width, size);\r\n            const r2 = new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(rect.x, rect.y + size, rect.width, rect.height - size);\r\n            return { start: r1, end: r2 };\r\n        }\r\n        else if (this === DockLocation.LEFT) {\r\n            const r1 = new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(rect.x, rect.y, size, rect.height);\r\n            const r2 = new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(rect.x + size, rect.y, rect.width - size, rect.height);\r\n            return { start: r1, end: r2 };\r\n        }\r\n        if (this === DockLocation.RIGHT) {\r\n            const r1 = new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(rect.getRight() - size, rect.y, size, rect.height);\r\n            const r2 = new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(rect.x, rect.y, rect.width - size, rect.height);\r\n            return { start: r1, end: r2 };\r\n        }\r\n        else {\r\n            // if (this === DockLocation.BOTTOM) {\r\n            const r1 = new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(rect.x, rect.getBottom() - size, rect.width, size);\r\n            const r2 = new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(rect.x, rect.y, rect.width, rect.height - size);\r\n            return { start: r1, end: r2 };\r\n        }\r\n    }\r\n    /** @internal */\r\n    reflect() {\r\n        if (this === DockLocation.TOP) {\r\n            return DockLocation.BOTTOM;\r\n        }\r\n        else if (this === DockLocation.LEFT) {\r\n            return DockLocation.RIGHT;\r\n        }\r\n        if (this === DockLocation.RIGHT) {\r\n            return DockLocation.LEFT;\r\n        }\r\n        else {\r\n            // if (this === DockLocation.BOTTOM) {\r\n            return DockLocation.TOP;\r\n        }\r\n    }\r\n    toString() {\r\n        return \"(DockLocation: name=\" + this._name + \", orientation=\" + this._orientation + \")\";\r\n    }\r\n}\r\nDockLocation.values = {};\r\nDockLocation.TOP = new DockLocation(\"top\", _Orientation__WEBPACK_IMPORTED_MODULE_0__.Orientation.VERT, 0);\r\nDockLocation.BOTTOM = new DockLocation(\"bottom\", _Orientation__WEBPACK_IMPORTED_MODULE_0__.Orientation.VERT, 1);\r\nDockLocation.LEFT = new DockLocation(\"left\", _Orientation__WEBPACK_IMPORTED_MODULE_0__.Orientation.HORZ, 0);\r\nDockLocation.RIGHT = new DockLocation(\"right\", _Orientation__WEBPACK_IMPORTED_MODULE_0__.Orientation.HORZ, 1);\r\nDockLocation.CENTER = new DockLocation(\"center\", _Orientation__WEBPACK_IMPORTED_MODULE_0__.Orientation.VERT, 0);\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/DockLocation.ts?");

/***/ }),

/***/ "./src/DragDrop.ts":
/*!*************************!*\
  !*** ./src/DragDrop.ts ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DragDrop\": () => (/* binding */ DragDrop)\n/* harmony export */ });\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Rect */ \"./src/Rect.ts\");\n\r\n/** @internal */\r\nconst canUseDOM = !!(typeof window !== \"undefined\" && window.document && window.document.createElement);\r\nclass DragDrop {\r\n    /** @internal */\r\n    constructor() {\r\n        /** @internal */\r\n        this._manualGlassManagement = false;\r\n        /** @internal */\r\n        this._startX = 0;\r\n        /** @internal */\r\n        this._startY = 0;\r\n        /** @internal */\r\n        this._dragDepth = 0;\r\n        /** @internal */\r\n        this._glassShowing = false;\r\n        /** @internal */\r\n        this._dragging = false;\r\n        /** @internal */\r\n        this._active = false; // drag and drop is in progress, can be used on ios to prevent body scrolling (see demo)\r\n        if (canUseDOM) {\r\n            // check for serverside rendering\r\n            this._glass = document.createElement(\"div\");\r\n            this._glass.style.zIndex = \"998\";\r\n            this._glass.style.backgroundColor = \"transparent\";\r\n            this._glass.style.outline = \"none\";\r\n        }\r\n        this._defaultGlassCursor = \"default\";\r\n        this._onMouseMove = this._onMouseMove.bind(this);\r\n        this._onMouseUp = this._onMouseUp.bind(this);\r\n        this._onKeyPress = this._onKeyPress.bind(this);\r\n        this._onDragCancel = this._onDragCancel.bind(this);\r\n        this._onDragEnter = this._onDragEnter.bind(this);\r\n        this._onDragLeave = this._onDragLeave.bind(this);\r\n        this.resizeGlass = this.resizeGlass.bind(this);\r\n        this._lastClick = 0;\r\n        this._clickX = 0;\r\n        this._clickY = 0;\r\n    }\r\n    // if you add the glass pane then you should remove it\r\n    addGlass(fCancel) {\r\n        var _a;\r\n        if (!this._glassShowing) {\r\n            if (!this._document) {\r\n                this._document = window.document;\r\n            }\r\n            if (!this._rootElement) {\r\n                this._rootElement = this._document.body;\r\n            }\r\n            this.resizeGlass();\r\n            (_a = this._document.defaultView) === null || _a === void 0 ? void 0 : _a.addEventListener('resize', this.resizeGlass);\r\n            this._document.body.appendChild(this._glass);\r\n            this._glass.tabIndex = -1;\r\n            this._glass.focus();\r\n            this._glass.addEventListener(\"keydown\", this._onKeyPress);\r\n            this._glass.addEventListener(\"dragenter\", this._onDragEnter, { passive: false });\r\n            this._glass.addEventListener(\"dragover\", this._onMouseMove, { passive: false });\r\n            this._glass.addEventListener(\"dragleave\", this._onDragLeave, { passive: false });\r\n            this._glassShowing = true;\r\n            this._fDragCancel = fCancel;\r\n            this._manualGlassManagement = false;\r\n        }\r\n        else {\r\n            // second call to addGlass (via dragstart)\r\n            this._manualGlassManagement = true;\r\n        }\r\n    }\r\n    resizeGlass() {\r\n        const glassRect = _Rect__WEBPACK_IMPORTED_MODULE_0__.Rect.fromElement(this._rootElement);\r\n        glassRect.positionElement(this._glass, \"fixed\");\r\n    }\r\n    hideGlass() {\r\n        var _a;\r\n        if (this._glassShowing) {\r\n            this._document.body.removeChild(this._glass);\r\n            (_a = this._document.defaultView) === null || _a === void 0 ? void 0 : _a.removeEventListener('resize', this.resizeGlass);\r\n            this._glassShowing = false;\r\n            this._document = undefined;\r\n            this._rootElement = undefined;\r\n            this.setGlassCursorOverride(undefined);\r\n        }\r\n    }\r\n    /** @internal */\r\n    _updateGlassCursor() {\r\n        var _a;\r\n        this._glass.style.cursor = (_a = this._glassCursorOverride) !== null && _a !== void 0 ? _a : this._defaultGlassCursor;\r\n    }\r\n    /** @internal */\r\n    _setDefaultGlassCursor(cursor) {\r\n        this._defaultGlassCursor = cursor;\r\n        this._updateGlassCursor();\r\n    }\r\n    setGlassCursorOverride(cursor) {\r\n        this._glassCursorOverride = cursor;\r\n        this._updateGlassCursor();\r\n    }\r\n    startDrag(event, fDragStart, fDragMove, fDragEnd, fDragCancel, fClick, fDblClick, currentDocument, rootElement) {\r\n        // prevent 'duplicate' action (mouse event for same action as previous touch event (a fix for ios))\r\n        if (event && this._lastEvent && this._lastEvent.type.startsWith(\"touch\") && event.type.startsWith(\"mouse\") && event.timeStamp - this._lastEvent.timeStamp < 500) {\r\n            return;\r\n        }\r\n        this._lastEvent = event;\r\n        if (currentDocument) {\r\n            this._document = currentDocument;\r\n        }\r\n        else {\r\n            this._document = window.document;\r\n        }\r\n        if (rootElement) {\r\n            this._rootElement = rootElement;\r\n        }\r\n        else {\r\n            this._rootElement = this._document.body;\r\n        }\r\n        const posEvent = this._getLocationEvent(event);\r\n        this.addGlass(fDragCancel);\r\n        if (this._dragging) {\r\n            console.warn(\"this._dragging true on startDrag should never happen\");\r\n        }\r\n        if (event) {\r\n            this._startX = posEvent.clientX;\r\n            this._startY = posEvent.clientY;\r\n            if (!window.matchMedia || window.matchMedia(\"(pointer: fine)\").matches) {\r\n                this._setDefaultGlassCursor(getComputedStyle(event.target).cursor);\r\n            }\r\n            this._stopPropagation(event);\r\n            this._preventDefault(event);\r\n        }\r\n        else {\r\n            this._startX = 0;\r\n            this._startY = 0;\r\n            this._setDefaultGlassCursor(\"default\");\r\n        }\r\n        this._dragging = false;\r\n        this._fDragStart = fDragStart;\r\n        this._fDragMove = fDragMove;\r\n        this._fDragEnd = fDragEnd;\r\n        this._fDragCancel = fDragCancel;\r\n        this._fClick = fClick;\r\n        this._fDblClick = fDblClick;\r\n        this._active = true;\r\n        if ((event === null || event === void 0 ? void 0 : event.type) === 'dragenter') {\r\n            this._dragDepth = 1;\r\n            this._rootElement.addEventListener(\"dragenter\", this._onDragEnter, { passive: false });\r\n            this._rootElement.addEventListener(\"dragover\", this._onMouseMove, { passive: false });\r\n            this._rootElement.addEventListener(\"dragleave\", this._onDragLeave, { passive: false });\r\n            this._document.addEventListener(\"dragend\", this._onDragCancel, { passive: false });\r\n            this._document.addEventListener(\"drop\", this._onMouseUp, { passive: false });\r\n        }\r\n        else {\r\n            this._document.addEventListener(\"mouseup\", this._onMouseUp, { passive: false });\r\n            this._document.addEventListener(\"mousemove\", this._onMouseMove, { passive: false });\r\n            this._document.addEventListener(\"touchend\", this._onMouseUp, { passive: false });\r\n            this._document.addEventListener(\"touchmove\", this._onMouseMove, { passive: false });\r\n        }\r\n    }\r\n    isDragging() {\r\n        return this._dragging;\r\n    }\r\n    isActive() {\r\n        return this._active;\r\n    }\r\n    toString() {\r\n        const rtn = \"(DragDrop: \" + \"startX=\" + this._startX + \", startY=\" + this._startY + \", dragging=\" + this._dragging + \")\";\r\n        return rtn;\r\n    }\r\n    /** @internal */\r\n    _onKeyPress(event) {\r\n        if (event.keyCode === 27) {\r\n            // esc\r\n            this._onDragCancel();\r\n        }\r\n    }\r\n    /** @internal */\r\n    _onDragCancel() {\r\n        this._rootElement.removeEventListener(\"dragenter\", this._onDragEnter);\r\n        this._rootElement.removeEventListener(\"dragover\", this._onMouseMove);\r\n        this._rootElement.removeEventListener(\"dragleave\", this._onDragLeave);\r\n        this._document.removeEventListener(\"dragend\", this._onDragCancel);\r\n        this._document.removeEventListener(\"drop\", this._onMouseUp);\r\n        this._document.removeEventListener(\"mousemove\", this._onMouseMove);\r\n        this._document.removeEventListener(\"mouseup\", this._onMouseUp);\r\n        this._document.removeEventListener(\"touchend\", this._onMouseUp);\r\n        this._document.removeEventListener(\"touchmove\", this._onMouseMove);\r\n        this.hideGlass();\r\n        if (this._fDragCancel !== undefined) {\r\n            this._fDragCancel(this._dragging);\r\n        }\r\n        this._dragging = false;\r\n        this._active = false;\r\n    }\r\n    /** @internal */\r\n    _getLocationEvent(event) {\r\n        let posEvent = event;\r\n        if (event && event.touches) {\r\n            posEvent = event.touches[0];\r\n        }\r\n        return posEvent;\r\n    }\r\n    /** @internal */\r\n    _getLocationEventEnd(event) {\r\n        let posEvent = event;\r\n        if (event.changedTouches) {\r\n            posEvent = event.changedTouches[0];\r\n        }\r\n        return posEvent;\r\n    }\r\n    /** @internal */\r\n    _stopPropagation(event) {\r\n        if (event.stopPropagation) {\r\n            event.stopPropagation();\r\n        }\r\n    }\r\n    /** @internal */\r\n    _preventDefault(event) {\r\n        if (event.preventDefault && event.cancelable) {\r\n            event.preventDefault();\r\n        }\r\n        return event;\r\n    }\r\n    /** @internal */\r\n    _onMouseMove(event) {\r\n        this._lastEvent = event;\r\n        const posEvent = this._getLocationEvent(event);\r\n        this._stopPropagation(event);\r\n        this._preventDefault(event);\r\n        if (!this._dragging && (Math.abs(this._startX - posEvent.clientX) > 5 || Math.abs(this._startY - posEvent.clientY) > 5)) {\r\n            this._dragging = true;\r\n            if (this._fDragStart) {\r\n                this._setDefaultGlassCursor(\"move\");\r\n                this._dragging = this._fDragStart({ clientX: this._startX, clientY: this._startY });\r\n            }\r\n        }\r\n        if (this._dragging) {\r\n            if (this._fDragMove) {\r\n                this._fDragMove(posEvent);\r\n            }\r\n        }\r\n        return false;\r\n    }\r\n    /** @internal */\r\n    _onMouseUp(event) {\r\n        this._lastEvent = event;\r\n        const posEvent = this._getLocationEventEnd(event);\r\n        this._stopPropagation(event);\r\n        this._preventDefault(event);\r\n        this._active = false;\r\n        this._rootElement.removeEventListener(\"dragenter\", this._onDragEnter);\r\n        this._rootElement.removeEventListener(\"dragover\", this._onMouseMove);\r\n        this._rootElement.removeEventListener(\"dragleave\", this._onDragLeave);\r\n        this._document.removeEventListener(\"dragend\", this._onDragCancel);\r\n        this._document.removeEventListener(\"drop\", this._onMouseUp);\r\n        this._document.removeEventListener(\"mousemove\", this._onMouseMove);\r\n        this._document.removeEventListener(\"mouseup\", this._onMouseUp);\r\n        this._document.removeEventListener(\"touchend\", this._onMouseUp);\r\n        this._document.removeEventListener(\"touchmove\", this._onMouseMove);\r\n        if (!this._manualGlassManagement) {\r\n            this.hideGlass();\r\n        }\r\n        if (this._dragging) {\r\n            this._dragging = false;\r\n            if (this._fDragEnd) {\r\n                this._fDragEnd(event);\r\n            }\r\n            // dump(\"set dragging = false\\n\");\r\n        }\r\n        else {\r\n            if (this._fDragCancel) {\r\n                this._fDragCancel(this._dragging);\r\n            }\r\n            if (Math.abs(this._startX - posEvent.clientX) <= 5 && Math.abs(this._startY - posEvent.clientY) <= 5) {\r\n                let isDoubleClick = false;\r\n                const clickTime = new Date().getTime();\r\n                // check for double click\r\n                if (Math.abs(this._clickX - posEvent.clientX) <= 5 && Math.abs(this._clickY - posEvent.clientY) <= 5) {\r\n                    if (clickTime - this._lastClick < 500) {\r\n                        if (this._fDblClick) {\r\n                            this._fDblClick(event);\r\n                            isDoubleClick = true;\r\n                        }\r\n                    }\r\n                }\r\n                if (!isDoubleClick && this._fClick) {\r\n                    this._fClick(event);\r\n                }\r\n                this._lastClick = clickTime;\r\n                this._clickX = posEvent.clientX;\r\n                this._clickY = posEvent.clientY;\r\n            }\r\n        }\r\n        return false;\r\n    }\r\n    /** @internal */\r\n    _onDragEnter(event) {\r\n        this._preventDefault(event);\r\n        this._stopPropagation(event);\r\n        this._dragDepth++;\r\n        return false;\r\n    }\r\n    /** @internal */\r\n    _onDragLeave(event) {\r\n        this._preventDefault(event);\r\n        this._stopPropagation(event);\r\n        this._dragDepth--;\r\n        if (this._dragDepth <= 0) {\r\n            this._onDragCancel();\r\n        }\r\n        return false;\r\n    }\r\n}\r\nDragDrop.instance = new DragDrop();\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/DragDrop.ts?");

/***/ }),

/***/ "./src/DropInfo.ts":
/*!*************************!*\
  !*** ./src/DropInfo.ts ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DropInfo\": () => (/* binding */ DropInfo)\n/* harmony export */ });\nclass DropInfo {\r\n    constructor(node, rect, location, index, className) {\r\n        this.node = node;\r\n        this.rect = rect;\r\n        this.location = location;\r\n        this.index = index;\r\n        this.className = className;\r\n    }\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/DropInfo.ts?");

/***/ }),

/***/ "./src/I18nLabel.ts":
/*!**************************!*\
  !*** ./src/I18nLabel.ts ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"I18nLabel\": () => (/* binding */ I18nLabel)\n/* harmony export */ });\nvar I18nLabel;\r\n(function (I18nLabel) {\r\n    I18nLabel[\"Close_Tab\"] = \"Close\";\r\n    I18nLabel[\"Close_Tabset\"] = \"Close tabset\";\r\n    I18nLabel[\"Move_Tab\"] = \"Move: \";\r\n    I18nLabel[\"Move_Tabset\"] = \"Move tabset\";\r\n    I18nLabel[\"Maximize\"] = \"Maximize tabset\";\r\n    I18nLabel[\"Restore\"] = \"Restore tabset\";\r\n    I18nLabel[\"Float_Tab\"] = \"Show selected tab in floating window\";\r\n    I18nLabel[\"Overflow_Menu_Tooltip\"] = \"Hidden tabs\";\r\n    I18nLabel[\"Floating_Window_Message\"] = \"This panel is shown in a floating window\";\r\n    I18nLabel[\"Floating_Window_Show_Window\"] = \"Show window\";\r\n    I18nLabel[\"Floating_Window_Dock_Window\"] = \"Dock window\";\r\n    I18nLabel[\"Error_rendering_component\"] = \"Error rendering component\";\r\n})(I18nLabel || (I18nLabel = {}));\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/I18nLabel.ts?");

/***/ }),

/***/ "./src/Orientation.ts":
/*!****************************!*\
  !*** ./src/Orientation.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Orientation\": () => (/* binding */ Orientation)\n/* harmony export */ });\nclass Orientation {\r\n    /** @internal */\r\n    constructor(name) {\r\n        this._name = name;\r\n    }\r\n    static flip(from) {\r\n        if (from === Orientation.HORZ) {\r\n            return Orientation.VERT;\r\n        }\r\n        else {\r\n            return Orientation.HORZ;\r\n        }\r\n    }\r\n    getName() {\r\n        return this._name;\r\n    }\r\n    toString() {\r\n        return this._name;\r\n    }\r\n}\r\nOrientation.HORZ = new Orientation(\"horz\");\r\nOrientation.VERT = new Orientation(\"vert\");\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/Orientation.ts?");

/***/ }),

/***/ "./src/PopupMenu.tsx":
/*!***************************!*\
  !*** ./src/PopupMenu.tsx ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"showPopup\": () => (/* binding */ showPopup)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _DragDrop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DragDrop */ \"./src/DragDrop.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Types */ \"./src/Types.ts\");\n/* harmony import */ var _view_TabButtonStamp__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./view/TabButtonStamp */ \"./src/view/TabButtonStamp.tsx\");\n\r\n\r\n\r\n\r\n/** @internal */\r\nfunction showPopup(triggerElement, items, onSelect, layout, iconFactory, titleFactory) {\r\n    const layoutDiv = layout.getRootDiv();\r\n    const classNameMapper = layout.getClassName;\r\n    const currentDocument = triggerElement.ownerDocument;\r\n    const triggerRect = triggerElement.getBoundingClientRect();\r\n    const layoutRect = layoutDiv.getBoundingClientRect();\r\n    const elm = currentDocument.createElement(\"div\");\r\n    elm.className = classNameMapper(_Types__WEBPACK_IMPORTED_MODULE_2__.CLASSES.FLEXLAYOUT__POPUP_MENU_CONTAINER);\r\n    if (triggerRect.left < layoutRect.left + layoutRect.width / 2) {\r\n        elm.style.left = triggerRect.left - layoutRect.left + \"px\";\r\n    }\r\n    else {\r\n        elm.style.right = layoutRect.right - triggerRect.right + \"px\";\r\n    }\r\n    if (triggerRect.top < layoutRect.top + layoutRect.height / 2) {\r\n        elm.style.top = triggerRect.top - layoutRect.top + \"px\";\r\n    }\r\n    else {\r\n        elm.style.bottom = layoutRect.bottom - triggerRect.bottom + \"px\";\r\n    }\r\n    _DragDrop__WEBPACK_IMPORTED_MODULE_1__.DragDrop.instance.addGlass(() => onHide());\r\n    _DragDrop__WEBPACK_IMPORTED_MODULE_1__.DragDrop.instance.setGlassCursorOverride(\"default\");\r\n    layoutDiv.appendChild(elm);\r\n    const onHide = () => {\r\n        layout.hidePortal();\r\n        _DragDrop__WEBPACK_IMPORTED_MODULE_1__.DragDrop.instance.hideGlass();\r\n        layoutDiv.removeChild(elm);\r\n        elm.removeEventListener(\"mousedown\", onElementMouseDown);\r\n        currentDocument.removeEventListener(\"mousedown\", onDocMouseDown);\r\n    };\r\n    const onElementMouseDown = (event) => {\r\n        event.stopPropagation();\r\n    };\r\n    const onDocMouseDown = (event) => {\r\n        onHide();\r\n    };\r\n    elm.addEventListener(\"mousedown\", onElementMouseDown);\r\n    currentDocument.addEventListener(\"mousedown\", onDocMouseDown);\r\n    layout.showPortal(react__WEBPACK_IMPORTED_MODULE_0__.createElement(PopupMenu, { currentDocument: currentDocument, onSelect: onSelect, onHide: onHide, items: items, classNameMapper: classNameMapper, layout: layout, iconFactory: iconFactory, titleFactory: titleFactory }), elm);\r\n}\r\n/** @internal */\r\nconst PopupMenu = (props) => {\r\n    const { items, onHide, onSelect, classNameMapper, layout, iconFactory, titleFactory } = props;\r\n    const onItemClick = (item, event) => {\r\n        onSelect(item);\r\n        onHide();\r\n        event.stopPropagation();\r\n    };\r\n    const itemElements = items.map((item, i) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: item.index, className: classNameMapper(_Types__WEBPACK_IMPORTED_MODULE_2__.CLASSES.FLEXLAYOUT__POPUP_MENU_ITEM), \"data-layout-path\": \"/popup-menu/tb\" + i, onClick: (event) => onItemClick(item, event), title: item.node.getHelpText() }, item.node.getModel().isLegacyOverflowMenu() ?\r\n        item.node._getNameForOverflowMenu() :\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_view_TabButtonStamp__WEBPACK_IMPORTED_MODULE_3__.TabButtonStamp, { node: item.node, layout: layout, iconFactory: iconFactory, titleFactory: titleFactory }))));\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: classNameMapper(_Types__WEBPACK_IMPORTED_MODULE_2__.CLASSES.FLEXLAYOUT__POPUP_MENU), \"data-layout-path\": \"/popup-menu\" }, itemElements));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/PopupMenu.tsx?");

/***/ }),

/***/ "./src/Rect.ts":
/*!*********************!*\
  !*** ./src/Rect.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Rect\": () => (/* binding */ Rect)\n/* harmony export */ });\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Orientation */ \"./src/Orientation.ts\");\n\r\nclass Rect {\r\n    constructor(x, y, width, height) {\r\n        this.x = x;\r\n        this.y = y;\r\n        this.width = width;\r\n        this.height = height;\r\n    }\r\n    static empty() {\r\n        return new Rect(0, 0, 0, 0);\r\n    }\r\n    static fromElement(element) {\r\n        let { x, y, width, height } = element.getBoundingClientRect();\r\n        return new Rect(x, y, width, height);\r\n    }\r\n    clone() {\r\n        return new Rect(this.x, this.y, this.width, this.height);\r\n    }\r\n    equals(rect) {\r\n        if (this.x === rect.x && this.y === rect.y && this.width === rect.width && this.height === rect.height) {\r\n            return true;\r\n        }\r\n        else {\r\n            return false;\r\n        }\r\n    }\r\n    getBottom() {\r\n        return this.y + this.height;\r\n    }\r\n    getRight() {\r\n        return this.x + this.width;\r\n    }\r\n    getCenter() {\r\n        return { x: this.x + this.width / 2, y: this.y + this.height / 2 };\r\n    }\r\n    positionElement(element, position) {\r\n        this.styleWithPosition(element.style, position);\r\n    }\r\n    styleWithPosition(style, position = \"absolute\") {\r\n        style.left = this.x + \"px\";\r\n        style.top = this.y + \"px\";\r\n        style.width = Math.max(0, this.width) + \"px\"; // need Math.max to prevent -ve, cause error in IE\r\n        style.height = Math.max(0, this.height) + \"px\";\r\n        style.position = position;\r\n        return style;\r\n    }\r\n    contains(x, y) {\r\n        if (this.x <= x && x <= this.getRight() && this.y <= y && y <= this.getBottom()) {\r\n            return true;\r\n        }\r\n        else {\r\n            return false;\r\n        }\r\n    }\r\n    removeInsets(insets) {\r\n        return new Rect(this.x + insets.left, this.y + insets.top, Math.max(0, this.width - insets.left - insets.right), Math.max(0, this.height - insets.top - insets.bottom));\r\n    }\r\n    centerInRect(outerRect) {\r\n        this.x = (outerRect.width - this.width) / 2;\r\n        this.y = (outerRect.height - this.height) / 2;\r\n    }\r\n    /** @internal */\r\n    _getSize(orientation) {\r\n        let prefSize = this.width;\r\n        if (orientation === _Orientation__WEBPACK_IMPORTED_MODULE_0__.Orientation.VERT) {\r\n            prefSize = this.height;\r\n        }\r\n        return prefSize;\r\n    }\r\n    toString() {\r\n        return \"(Rect: x=\" + this.x + \", y=\" + this.y + \", width=\" + this.width + \", height=\" + this.height + \")\";\r\n    }\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/Rect.ts?");

/***/ }),

/***/ "./src/Types.ts":
/*!**********************!*\
  !*** ./src/Types.ts ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"CLASSES\": () => (/* binding */ CLASSES)\n/* harmony export */ });\nvar CLASSES;\r\n(function (CLASSES) {\r\n    CLASSES[\"FLEXLAYOUT__BORDER\"] = \"flexlayout__border\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_\"] = \"flexlayout__border_\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_BUTTON\"] = \"flexlayout__border_button\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_BUTTON_\"] = \"flexlayout__border_button_\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_BUTTON_CONTENT\"] = \"flexlayout__border_button_content\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_BUTTON_LEADING\"] = \"flexlayout__border_button_leading\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_BUTTON_TRAILING\"] = \"flexlayout__border_button_trailing\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_BUTTON__SELECTED\"] = \"flexlayout__border_button--selected\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_BUTTON__UNSELECTED\"] = \"flexlayout__border_button--unselected\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_TOOLBAR_BUTTON_OVERFLOW\"] = \"flexlayout__border_toolbar_button_overflow\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_TOOLBAR_BUTTON_OVERFLOW_\"] = \"flexlayout__border_toolbar_button_overflow_\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_INNER\"] = \"flexlayout__border_inner\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_INNER_\"] = \"flexlayout__border_inner_\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_INNER_TAB_CONTAINER\"] = \"flexlayout__border_inner_tab_container\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_INNER_TAB_CONTAINER_\"] = \"flexlayout__border_inner_tab_container_\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_TAB_DIVIDER\"] = \"flexlayout__border_tab_divider\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_SIZER\"] = \"flexlayout__border_sizer\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_TOOLBAR\"] = \"flexlayout__border_toolbar\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_TOOLBAR_\"] = \"flexlayout__border_toolbar_\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_TOOLBAR_BUTTON\"] = \"flexlayout__border_toolbar_button\";\r\n    CLASSES[\"FLEXLAYOUT__BORDER_TOOLBAR_BUTTON_FLOAT\"] = \"flexlayout__border_toolbar_button-float\";\r\n    CLASSES[\"FLEXLAYOUT__DRAG_RECT\"] = \"flexlayout__drag_rect\";\r\n    CLASSES[\"FLEXLAYOUT__EDGE_RECT\"] = \"flexlayout__edge_rect\";\r\n    CLASSES[\"FLEXLAYOUT__ERROR_BOUNDARY_CONTAINER\"] = \"flexlayout__error_boundary_container\";\r\n    CLASSES[\"FLEXLAYOUT__ERROR_BOUNDARY_CONTENT\"] = \"flexlayout__error_boundary_content\";\r\n    CLASSES[\"FLEXLAYOUT__FLOATING_WINDOW_CONTENT\"] = \"flexlayout__floating_window_content\";\r\n    CLASSES[\"FLEXLAYOUT__FLOATING_WINDOW_TAB\"] = \"flexlayout__floating_window_tab\";\r\n    CLASSES[\"FLEXLAYOUT__LAYOUT\"] = \"flexlayout__layout\";\r\n    CLASSES[\"FLEXLAYOUT__OUTLINE_RECT\"] = \"flexlayout__outline_rect\";\r\n    CLASSES[\"FLEXLAYOUT__OUTLINE_RECT_EDGE\"] = \"flexlayout__outline_rect_edge\";\r\n    CLASSES[\"FLEXLAYOUT__SPLITTER\"] = \"flexlayout__splitter\";\r\n    CLASSES[\"FLEXLAYOUT__SPLITTER_EXTRA\"] = \"flexlayout__splitter_extra\";\r\n    CLASSES[\"FLEXLAYOUT__SPLITTER_\"] = \"flexlayout__splitter_\";\r\n    CLASSES[\"FLEXLAYOUT__SPLITTER_BORDER\"] = \"flexlayout__splitter_border\";\r\n    CLASSES[\"FLEXLAYOUT__SPLITTER_DRAG\"] = \"flexlayout__splitter_drag\";\r\n    CLASSES[\"FLEXLAYOUT__TAB\"] = \"flexlayout__tab\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET\"] = \"flexlayout__tabset\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_HEADER\"] = \"flexlayout__tabset_header\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_HEADER_SIZER\"] = \"flexlayout__tabset_header_sizer\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_HEADER_CONTENT\"] = \"flexlayout__tabset_header_content\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_MAXIMIZED\"] = \"flexlayout__tabset-maximized\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_SELECTED\"] = \"flexlayout__tabset-selected\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_SIZER\"] = \"flexlayout__tabset_sizer\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_TAB_DIVIDER\"] = \"flexlayout__tabset_tab_divider\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_CONTENT\"] = \"flexlayout__tabset_content\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_TABBAR_INNER\"] = \"flexlayout__tabset_tabbar_inner\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_TABBAR_INNER_\"] = \"flexlayout__tabset_tabbar_inner_\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_TABBAR_INNER_TAB_CONTAINER\"] = \"flexlayout__tabset_tabbar_inner_tab_container\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_TABBAR_INNER_TAB_CONTAINER_\"] = \"flexlayout__tabset_tabbar_inner_tab_container_\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_TABBAR_OUTER\"] = \"flexlayout__tabset_tabbar_outer\";\r\n    CLASSES[\"FLEXLAYOUT__TABSET_TABBAR_OUTER_\"] = \"flexlayout__tabset_tabbar_outer_\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BORDER\"] = \"flexlayout__tab_border\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BORDER_\"] = \"flexlayout__tab_border_\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BUTTON\"] = \"flexlayout__tab_button\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BUTTON_CONTENT\"] = \"flexlayout__tab_button_content\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BUTTON_LEADING\"] = \"flexlayout__tab_button_leading\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BUTTON_OVERFLOW\"] = \"flexlayout__tab_button_overflow\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BUTTON_OVERFLOW_COUNT\"] = \"flexlayout__tab_button_overflow_count\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BUTTON_TEXTBOX\"] = \"flexlayout__tab_button_textbox\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BUTTON_TRAILING\"] = \"flexlayout__tab_button_trailing\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_BUTTON_STAMP\"] = \"flexlayout__tab_button_stamp\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_FLOATING\"] = \"flexlayout__tab_floating\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_FLOATING_INNER\"] = \"flexlayout__tab_floating_inner\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_TOOLBAR\"] = \"flexlayout__tab_toolbar\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_TOOLBAR_BUTTON\"] = \"flexlayout__tab_toolbar_button\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_TOOLBAR_BUTTON_\"] = \"flexlayout__tab_toolbar_button-\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_TOOLBAR_BUTTON_FLOAT\"] = \"flexlayout__tab_toolbar_button-float\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_TOOLBAR_STICKY_BUTTONS_CONTAINER\"] = \"flexlayout__tab_toolbar_sticky_buttons_container\";\r\n    CLASSES[\"FLEXLAYOUT__TAB_TOOLBAR_BUTTON_CLOSE\"] = \"flexlayout__tab_toolbar_button-close\";\r\n    CLASSES[\"FLEXLAYOUT__POPUP_MENU_CONTAINER\"] = \"flexlayout__popup_menu_container\";\r\n    CLASSES[\"FLEXLAYOUT__POPUP_MENU_ITEM\"] = \"flexlayout__popup_menu_item\";\r\n    CLASSES[\"FLEXLAYOUT__POPUP_MENU\"] = \"flexlayout__popup_menu\";\r\n})(CLASSES || (CLASSES = {}));\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/Types.ts?");

/***/ }),

/***/ "./src/index.ts":
/*!**********************!*\
  !*** ./src/index.ts ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Action\": () => (/* reexport safe */ _model_Action__WEBPACK_IMPORTED_MODULE_1__.Action),\n/* harmony export */   \"Actions\": () => (/* reexport safe */ _model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions),\n/* harmony export */   \"BorderNode\": () => (/* reexport safe */ _model_BorderNode__WEBPACK_IMPORTED_MODULE_3__.BorderNode),\n/* harmony export */   \"BorderSet\": () => (/* reexport safe */ _model_BorderSet__WEBPACK_IMPORTED_MODULE_4__.BorderSet),\n/* harmony export */   \"CLASSES\": () => (/* reexport safe */ _Types__WEBPACK_IMPORTED_MODULE_21__.CLASSES),\n/* harmony export */   \"DockLocation\": () => (/* reexport safe */ _DockLocation__WEBPACK_IMPORTED_MODULE_15__.DockLocation),\n/* harmony export */   \"DragDrop\": () => (/* reexport safe */ _DragDrop__WEBPACK_IMPORTED_MODULE_16__.DragDrop),\n/* harmony export */   \"DropInfo\": () => (/* reexport safe */ _DropInfo__WEBPACK_IMPORTED_MODULE_17__.DropInfo),\n/* harmony export */   \"I18nLabel\": () => (/* reexport safe */ _I18nLabel__WEBPACK_IMPORTED_MODULE_18__.I18nLabel),\n/* harmony export */   \"ICloseType\": () => (/* reexport safe */ _model_ICloseType__WEBPACK_IMPORTED_MODULE_5__.ICloseType),\n/* harmony export */   \"Layout\": () => (/* reexport safe */ _view_Layout__WEBPACK_IMPORTED_MODULE_0__.Layout),\n/* harmony export */   \"Model\": () => (/* reexport safe */ _model_Model__WEBPACK_IMPORTED_MODULE_9__.Model),\n/* harmony export */   \"Node\": () => (/* reexport safe */ _model_Node__WEBPACK_IMPORTED_MODULE_10__.Node),\n/* harmony export */   \"Orientation\": () => (/* reexport safe */ _Orientation__WEBPACK_IMPORTED_MODULE_19__.Orientation),\n/* harmony export */   \"Rect\": () => (/* reexport safe */ _Rect__WEBPACK_IMPORTED_MODULE_20__.Rect),\n/* harmony export */   \"RowNode\": () => (/* reexport safe */ _model_RowNode__WEBPACK_IMPORTED_MODULE_11__.RowNode),\n/* harmony export */   \"SplitterNode\": () => (/* reexport safe */ _model_SplitterNode__WEBPACK_IMPORTED_MODULE_12__.SplitterNode),\n/* harmony export */   \"TabNode\": () => (/* reexport safe */ _model_TabNode__WEBPACK_IMPORTED_MODULE_13__.TabNode),\n/* harmony export */   \"TabSetNode\": () => (/* reexport safe */ _model_TabSetNode__WEBPACK_IMPORTED_MODULE_14__.TabSetNode)\n/* harmony export */ });\n/* harmony import */ var _view_Layout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./view/Layout */ \"./src/view/Layout.tsx\");\n/* harmony import */ var _model_Action__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./model/Action */ \"./src/model/Action.ts\");\n/* harmony import */ var _model_Actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./model/Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _model_BorderNode__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./model/BorderNode */ \"./src/model/BorderNode.ts\");\n/* harmony import */ var _model_BorderSet__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./model/BorderSet */ \"./src/model/BorderSet.ts\");\n/* harmony import */ var _model_ICloseType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./model/ICloseType */ \"./src/model/ICloseType.ts\");\n/* harmony import */ var _model_IDraggable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./model/IDraggable */ \"./src/model/IDraggable.ts\");\n/* harmony import */ var _model_IDropTarget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./model/IDropTarget */ \"./src/model/IDropTarget.ts\");\n/* harmony import */ var _model_IJsonModel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./model/IJsonModel */ \"./src/model/IJsonModel.ts\");\n/* harmony import */ var _model_Model__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./model/Model */ \"./src/model/Model.ts\");\n/* harmony import */ var _model_Node__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./model/Node */ \"./src/model/Node.ts\");\n/* harmony import */ var _model_RowNode__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./model/RowNode */ \"./src/model/RowNode.ts\");\n/* harmony import */ var _model_SplitterNode__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./model/SplitterNode */ \"./src/model/SplitterNode.ts\");\n/* harmony import */ var _model_TabNode__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./model/TabNode */ \"./src/model/TabNode.ts\");\n/* harmony import */ var _model_TabSetNode__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./model/TabSetNode */ \"./src/model/TabSetNode.ts\");\n/* harmony import */ var _DockLocation__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./DockLocation */ \"./src/DockLocation.ts\");\n/* harmony import */ var _DragDrop__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./DragDrop */ \"./src/DragDrop.ts\");\n/* harmony import */ var _DropInfo__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./DropInfo */ \"./src/DropInfo.ts\");\n/* harmony import */ var _I18nLabel__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./I18nLabel */ \"./src/I18nLabel.ts\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Rect */ \"./src/Rect.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Types */ \"./src/Types.ts\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/index.ts?");

/***/ }),

/***/ "./src/model/Action.ts":
/*!*****************************!*\
  !*** ./src/model/Action.ts ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Action\": () => (/* binding */ Action)\n/* harmony export */ });\nclass Action {\r\n    constructor(type, data) {\r\n        this.type = type;\r\n        this.data = data;\r\n    }\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/Action.ts?");

/***/ }),

/***/ "./src/model/Actions.ts":
/*!******************************!*\
  !*** ./src/model/Actions.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Actions\": () => (/* binding */ Actions)\n/* harmony export */ });\n/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Action */ \"./src/model/Action.ts\");\n\r\n/**\r\n * The Action creator class for FlexLayout model actions\r\n */\r\nclass Actions {\r\n    /**\r\n     * Adds a tab node to the given tabset node\r\n     * @param json the json for the new tab node e.g {type:\"tab\", component:\"table\"}\r\n     * @param toNodeId the new tab node will be added to the tabset with this node id\r\n     * @param location the location where the new tab will be added, one of the DockLocation enum values.\r\n     * @param index for docking to the center this value is the index of the tab, use -1 to add to the end.\r\n     * @param select (optional) whether to select the new tab, overriding autoSelectTab\r\n     * @returns {Action} the action\r\n     */\r\n    static addNode(json, toNodeId, location, index, select) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.ADD_NODE, {\r\n            json,\r\n            toNode: toNodeId,\r\n            location: location.getName(),\r\n            index,\r\n            select,\r\n        });\r\n    }\r\n    /**\r\n     * Moves a node (tab or tabset) from one location to another\r\n     * @param fromNodeId the id of the node to move\r\n     * @param toNodeId the id of the node to receive the moved node\r\n     * @param location the location where the moved node will be added, one of the DockLocation enum values.\r\n     * @param index for docking to the center this value is the index of the tab, use -1 to add to the end.\r\n     * @param select (optional) whether to select the moved tab(s) in new tabset, overriding autoSelectTab\r\n     * @returns {Action} the action\r\n     */\r\n    static moveNode(fromNodeId, toNodeId, location, index, select) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.MOVE_NODE, {\r\n            fromNode: fromNodeId,\r\n            toNode: toNodeId,\r\n            location: location.getName(),\r\n            index,\r\n            select,\r\n        });\r\n    }\r\n    /**\r\n     * Deletes a tab node from the layout\r\n     * @param tabsetNodeId the id of the tab node to delete\r\n     * @returns {Action} the action\r\n     */\r\n    static deleteTab(tabNodeId) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.DELETE_TAB, { node: tabNodeId });\r\n    }\r\n    /**\r\n     * Deletes a tabset node and all it's child tab nodes from the layout\r\n     * @param tabsetNodeId the id of the tabset node to delete\r\n     * @returns {Action} the action\r\n     */\r\n    static deleteTabset(tabsetNodeId) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.DELETE_TABSET, { node: tabsetNodeId });\r\n    }\r\n    /**\r\n     * Change the given nodes tab text\r\n     * @param tabNodeId the id of the node to rename\r\n     * @param text the test of the tab\r\n     * @returns {Action} the action\r\n     */\r\n    static renameTab(tabNodeId, text) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.RENAME_TAB, { node: tabNodeId, text });\r\n    }\r\n    /**\r\n     * Selects the given tab in its parent tabset\r\n     * @param tabNodeId the id of the node to set selected\r\n     * @returns {Action} the action\r\n     */\r\n    static selectTab(tabNodeId) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.SELECT_TAB, { tabNode: tabNodeId });\r\n    }\r\n    /**\r\n     * Set the given tabset node as the active tabset\r\n     * @param tabsetNodeId the id of the tabset node to set as active\r\n     * @returns {Action} the action\r\n     */\r\n    static setActiveTabset(tabsetNodeId) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.SET_ACTIVE_TABSET, { tabsetNode: tabsetNodeId });\r\n    }\r\n    /**\r\n     * Adjust the splitter between two tabsets\r\n     * @example\r\n     *  Actions.adjustSplit({node1: \"1\", weight1:30, pixelWidth1:300, node2: \"2\", weight2:70, pixelWidth2:700});\r\n     *\r\n     * @param splitSpec an object the defines the new split between two tabsets, see example below.\r\n     * @returns {Action} the action\r\n     */\r\n    static adjustSplit(splitSpec) {\r\n        const node1 = splitSpec.node1Id;\r\n        const node2 = splitSpec.node2Id;\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.ADJUST_SPLIT, {\r\n            node1,\r\n            weight1: splitSpec.weight1,\r\n            pixelWidth1: splitSpec.pixelWidth1,\r\n            node2,\r\n            weight2: splitSpec.weight2,\r\n            pixelWidth2: splitSpec.pixelWidth2,\r\n        });\r\n    }\r\n    static adjustBorderSplit(nodeId, pos) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.ADJUST_BORDER_SPLIT, { node: nodeId, pos });\r\n    }\r\n    /**\r\n     * Maximizes the given tabset\r\n     * @param tabsetNodeId the id of the tabset to maximize\r\n     * @returns {Action} the action\r\n     */\r\n    static maximizeToggle(tabsetNodeId) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.MAXIMIZE_TOGGLE, { node: tabsetNodeId });\r\n    }\r\n    /**\r\n     * Updates the global model jsone attributes\r\n     * @param attributes the json for the model attributes to update (merge into the existing attributes)\r\n     * @returns {Action} the action\r\n     */\r\n    static updateModelAttributes(attributes) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.UPDATE_MODEL_ATTRIBUTES, { json: attributes });\r\n    }\r\n    /**\r\n     * Updates the given nodes json attributes\r\n     * @param nodeId the id of the node to update\r\n     * @param attributes the json attributes to update (merge with the existing attributes)\r\n     * @returns {Action} the action\r\n     */\r\n    static updateNodeAttributes(nodeId, attributes) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.UPDATE_NODE_ATTRIBUTES, { node: nodeId, json: attributes });\r\n    }\r\n    static floatTab(nodeId) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.FLOAT_TAB, { node: nodeId });\r\n    }\r\n    static unFloatTab(nodeId) {\r\n        return new _Action__WEBPACK_IMPORTED_MODULE_0__.Action(Actions.UNFLOAT_TAB, { node: nodeId });\r\n    }\r\n}\r\nActions.ADD_NODE = \"FlexLayout_AddNode\";\r\nActions.MOVE_NODE = \"FlexLayout_MoveNode\";\r\nActions.DELETE_TAB = \"FlexLayout_DeleteTab\";\r\nActions.DELETE_TABSET = \"FlexLayout_DeleteTabset\";\r\nActions.RENAME_TAB = \"FlexLayout_RenameTab\";\r\nActions.SELECT_TAB = \"FlexLayout_SelectTab\";\r\nActions.SET_ACTIVE_TABSET = \"FlexLayout_SetActiveTabset\";\r\nActions.ADJUST_SPLIT = \"FlexLayout_AdjustSplit\";\r\nActions.ADJUST_BORDER_SPLIT = \"FlexLayout_AdjustBorderSplit\";\r\nActions.MAXIMIZE_TOGGLE = \"FlexLayout_MaximizeToggle\";\r\nActions.UPDATE_MODEL_ATTRIBUTES = \"FlexLayout_UpdateModelAttributes\";\r\nActions.UPDATE_NODE_ATTRIBUTES = \"FlexLayout_UpdateNodeAttributes\";\r\nActions.FLOAT_TAB = \"FlexLayout_FloatTab\";\r\nActions.UNFLOAT_TAB = \"FlexLayout_UnFloatTab\";\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/Actions.ts?");

/***/ }),

/***/ "./src/model/BorderNode.ts":
/*!*********************************!*\
  !*** ./src/model/BorderNode.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BorderNode\": () => (/* binding */ BorderNode)\n/* harmony export */ });\n/* harmony import */ var _Attribute__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Attribute */ \"./src/Attribute.ts\");\n/* harmony import */ var _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AttributeDefinitions */ \"./src/AttributeDefinitions.ts\");\n/* harmony import */ var _DockLocation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DockLocation */ \"./src/DockLocation.ts\");\n/* harmony import */ var _DropInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../DropInfo */ \"./src/DropInfo.ts\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Rect */ \"./src/Rect.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _Node__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Node */ \"./src/model/Node.ts\");\n/* harmony import */ var _SplitterNode__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./SplitterNode */ \"./src/model/SplitterNode.ts\");\n/* harmony import */ var _TabNode__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./TabNode */ \"./src/model/TabNode.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Utils */ \"./src/model/Utils.ts\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nclass BorderNode extends _Node__WEBPACK_IMPORTED_MODULE_7__.Node {\r\n    /** @internal */\r\n    constructor(location, json, model) {\r\n        super(model);\r\n        /** @internal */\r\n        this._adjustedSize = 0;\r\n        /** @internal */\r\n        this._calculatedBorderBarSize = 0;\r\n        this._location = location;\r\n        this._drawChildren = [];\r\n        this._attributes.id = `border_${location.getName()}`;\r\n        BorderNode._attributeDefinitions.fromJson(json, this._attributes);\r\n        model._addNode(this);\r\n    }\r\n    /** @internal */\r\n    static _fromJson(json, model) {\r\n        const location = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.getByName(json.location);\r\n        const border = new BorderNode(location, json, model);\r\n        if (json.children) {\r\n            border._children = json.children.map((jsonChild) => {\r\n                const child = _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode._fromJson(jsonChild, model);\r\n                child._setParent(border);\r\n                return child;\r\n            });\r\n        }\r\n        return border;\r\n    }\r\n    /** @internal */\r\n    static _createAttributeDefinitions() {\r\n        const attributeDefinitions = new _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__.AttributeDefinitions();\r\n        attributeDefinitions.add(\"type\", BorderNode.TYPE, true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING).setFixed();\r\n        attributeDefinitions.add(\"selected\", -1).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"show\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"config\", undefined).setType(\"any\");\r\n        attributeDefinitions.addInherited(\"barSize\", \"borderBarSize\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.addInherited(\"enableDrop\", \"borderEnableDrop\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.addInherited(\"className\", \"borderClassName\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.addInherited(\"autoSelectTabWhenOpen\", \"borderAutoSelectTabWhenOpen\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.addInherited(\"autoSelectTabWhenClosed\", \"borderAutoSelectTabWhenClosed\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.addInherited(\"size\", \"borderSize\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.addInherited(\"minSize\", \"borderMinSize\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.addInherited(\"enableAutoHide\", \"borderEnableAutoHide\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        return attributeDefinitions;\r\n    }\r\n    getLocation() {\r\n        return this._location;\r\n    }\r\n    getTabHeaderRect() {\r\n        return this._tabHeaderRect;\r\n    }\r\n    getRect() {\r\n        return this._tabHeaderRect;\r\n    }\r\n    getContentRect() {\r\n        return this._contentRect;\r\n    }\r\n    isEnableDrop() {\r\n        return this._getAttr(\"enableDrop\");\r\n    }\r\n    isAutoSelectTab(whenOpen) {\r\n        if (whenOpen == null) {\r\n            whenOpen = this.getSelected() !== -1;\r\n        }\r\n        if (whenOpen) {\r\n            return this._getAttr(\"autoSelectTabWhenOpen\");\r\n        }\r\n        else {\r\n            return this._getAttr(\"autoSelectTabWhenClosed\");\r\n        }\r\n    }\r\n    getClassName() {\r\n        return this._getAttr(\"className\");\r\n    }\r\n    /** @internal */\r\n    calcBorderBarSize(metrics) {\r\n        const barSize = this._getAttr(\"barSize\");\r\n        if (barSize !== 0) {\r\n            // its defined\r\n            this._calculatedBorderBarSize = barSize;\r\n        }\r\n        else {\r\n            this._calculatedBorderBarSize = metrics.borderBarSize;\r\n        }\r\n    }\r\n    getBorderBarSize() {\r\n        return this._calculatedBorderBarSize;\r\n    }\r\n    getSize() {\r\n        const defaultSize = this._getAttr(\"size\");\r\n        const selected = this.getSelected();\r\n        if (selected === -1) {\r\n            return defaultSize;\r\n        }\r\n        else {\r\n            const tabNode = this._children[selected];\r\n            const tabBorderSize = (this._location._orientation === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ) ? tabNode._getAttr(\"borderWidth\") : tabNode._getAttr(\"borderHeight\");\r\n            if (tabBorderSize === -1) {\r\n                return defaultSize;\r\n            }\r\n            else {\r\n                return tabBorderSize;\r\n            }\r\n        }\r\n    }\r\n    getMinSize() {\r\n        return this._getAttr(\"minSize\");\r\n    }\r\n    getSelected() {\r\n        return this._attributes.selected;\r\n    }\r\n    getSelectedNode() {\r\n        if (this.getSelected() !== -1) {\r\n            return this._children[this.getSelected()];\r\n        }\r\n        return undefined;\r\n    }\r\n    getOrientation() {\r\n        return this._location.getOrientation();\r\n    }\r\n    /**\r\n     * Returns the config attribute that can be used to store node specific data that\r\n     * WILL be saved to the json. The config attribute should be changed via the action Actions.updateNodeAttributes rather\r\n     * than directly, for example:\r\n     * this.state.model.doAction(\r\n     *   FlexLayout.Actions.updateNodeAttributes(node.getId(), {config:myConfigObject}));\r\n     */\r\n    getConfig() {\r\n        return this._attributes.config;\r\n    }\r\n    isMaximized() {\r\n        return false;\r\n    }\r\n    isShowing() {\r\n        const show = this._attributes.show;\r\n        if (show) {\r\n            if (this._model._getShowHiddenBorder() !== this._location && this.isAutoHide() && this._children.length === 0) {\r\n                return false;\r\n            }\r\n            return true;\r\n        }\r\n        else {\r\n            return false;\r\n        }\r\n    }\r\n    isAutoHide() {\r\n        return this._getAttr(\"enableAutoHide\");\r\n    }\r\n    /** @internal */\r\n    _setSelected(index) {\r\n        this._attributes.selected = index;\r\n    }\r\n    /** @internal */\r\n    _setSize(pos) {\r\n        const selected = this.getSelected();\r\n        if (selected === -1) {\r\n            this._attributes.size = pos;\r\n        }\r\n        else {\r\n            const tabNode = this._children[selected];\r\n            const tabBorderSize = (this._location._orientation === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ) ? tabNode._getAttr(\"borderWidth\") : tabNode._getAttr(\"borderHeight\");\r\n            if (tabBorderSize === -1) {\r\n                this._attributes.size = pos;\r\n            }\r\n            else {\r\n                if (this._location._orientation === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ) {\r\n                    tabNode._setBorderWidth(pos);\r\n                }\r\n                else {\r\n                    tabNode._setBorderHeight(pos);\r\n                }\r\n            }\r\n        }\r\n    }\r\n    /** @internal */\r\n    _updateAttrs(json) {\r\n        BorderNode._attributeDefinitions.update(json, this._attributes);\r\n    }\r\n    /** @internal */\r\n    _getDrawChildren() {\r\n        return this._drawChildren;\r\n    }\r\n    /** @internal */\r\n    _setAdjustedSize(size) {\r\n        this._adjustedSize = size;\r\n    }\r\n    /** @internal */\r\n    _getAdjustedSize() {\r\n        return this._adjustedSize;\r\n    }\r\n    /** @internal */\r\n    _layoutBorderOuter(outer, metrics) {\r\n        this.calcBorderBarSize(metrics);\r\n        const split1 = this._location.split(outer, this.getBorderBarSize()); // split border outer\r\n        this._tabHeaderRect = split1.start;\r\n        return split1.end;\r\n    }\r\n    /** @internal */\r\n    _layoutBorderInner(inner, metrics) {\r\n        this._drawChildren = [];\r\n        const location = this._location;\r\n        const split1 = location.split(inner, this._adjustedSize + this._model.getSplitterSize()); // split off tab contents\r\n        const split2 = location.reflect().split(split1.start, this._model.getSplitterSize()); // split contents into content and splitter\r\n        this._contentRect = split2.end;\r\n        for (let i = 0; i < this._children.length; i++) {\r\n            const child = this._children[i];\r\n            child._layout(this._contentRect, metrics);\r\n            child._setVisible(i === this.getSelected());\r\n            this._drawChildren.push(child);\r\n        }\r\n        if (this.getSelected() === -1) {\r\n            return inner;\r\n        }\r\n        else {\r\n            const newSplitter = new _SplitterNode__WEBPACK_IMPORTED_MODULE_8__.SplitterNode(this._model);\r\n            newSplitter._setParent(this);\r\n            newSplitter._setRect(split2.start);\r\n            this._drawChildren.push(newSplitter);\r\n            return split1.end;\r\n        }\r\n    }\r\n    /** @internal */\r\n    _remove(node) {\r\n        const removedIndex = this._removeChild(node);\r\n        if (this.getSelected() !== -1) {\r\n            (0,_Utils__WEBPACK_IMPORTED_MODULE_10__.adjustSelectedIndex)(this, removedIndex);\r\n        }\r\n    }\r\n    /** @internal */\r\n    canDrop(dragNode, x, y) {\r\n        if (dragNode.getType() !== _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode.TYPE) {\r\n            return undefined;\r\n        }\r\n        let dropInfo;\r\n        const dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER;\r\n        if (this._tabHeaderRect.contains(x, y)) {\r\n            if (this._location._orientation === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.VERT) {\r\n                if (this._children.length > 0) {\r\n                    let child = this._children[0];\r\n                    let childRect = child.getTabRect();\r\n                    const childY = childRect.y;\r\n                    const childHeight = childRect.height;\r\n                    let pos = this._tabHeaderRect.x;\r\n                    let childCenter = 0;\r\n                    for (let i = 0; i < this._children.length; i++) {\r\n                        child = this._children[i];\r\n                        childRect = child.getTabRect();\r\n                        childCenter = childRect.x + childRect.width / 2;\r\n                        if (x >= pos && x < childCenter) {\r\n                            const outlineRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(childRect.x - 2, childY, 3, childHeight);\r\n                            dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, i, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n                            break;\r\n                        }\r\n                        pos = childCenter;\r\n                    }\r\n                    if (dropInfo == null) {\r\n                        const outlineRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(childRect.getRight() - 2, childY, 3, childHeight);\r\n                        dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, this._children.length, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n                    }\r\n                }\r\n                else {\r\n                    const outlineRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(this._tabHeaderRect.x + 1, this._tabHeaderRect.y + 2, 3, 18);\r\n                    dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, 0, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n                }\r\n            }\r\n            else {\r\n                if (this._children.length > 0) {\r\n                    let child = this._children[0];\r\n                    let childRect = child.getTabRect();\r\n                    const childX = childRect.x;\r\n                    const childWidth = childRect.width;\r\n                    let pos = this._tabHeaderRect.y;\r\n                    let childCenter = 0;\r\n                    for (let i = 0; i < this._children.length; i++) {\r\n                        child = this._children[i];\r\n                        childRect = child.getTabRect();\r\n                        childCenter = childRect.y + childRect.height / 2;\r\n                        if (y >= pos && y < childCenter) {\r\n                            const outlineRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(childX, childRect.y - 2, childWidth, 3);\r\n                            dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, i, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n                            break;\r\n                        }\r\n                        pos = childCenter;\r\n                    }\r\n                    if (dropInfo == null) {\r\n                        const outlineRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(childX, childRect.getBottom() - 2, childWidth, 3);\r\n                        dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, this._children.length, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n                    }\r\n                }\r\n                else {\r\n                    const outlineRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(this._tabHeaderRect.x + 2, this._tabHeaderRect.y + 1, 18, 3);\r\n                    dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, 0, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n                }\r\n            }\r\n            if (!dragNode._canDockInto(dragNode, dropInfo)) {\r\n                return undefined;\r\n            }\r\n        }\r\n        else if (this.getSelected() !== -1 && this._contentRect.contains(x, y)) {\r\n            const outlineRect = this._contentRect;\r\n            dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, -1, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n            if (!dragNode._canDockInto(dragNode, dropInfo)) {\r\n                return undefined;\r\n            }\r\n        }\r\n        return dropInfo;\r\n    }\r\n    /** @internal */\r\n    drop(dragNode, location, index, select) {\r\n        let fromIndex = 0;\r\n        const dragParent = dragNode.getParent();\r\n        if (dragParent !== undefined) {\r\n            fromIndex = dragParent._removeChild(dragNode);\r\n            // if selected node in border is being docked into a different border then deselect border tabs\r\n            if (dragParent !== this && dragParent instanceof BorderNode && dragParent.getSelected() === fromIndex) {\r\n                dragParent._setSelected(-1);\r\n            }\r\n            else {\r\n                (0,_Utils__WEBPACK_IMPORTED_MODULE_10__.adjustSelectedIndex)(dragParent, fromIndex);\r\n            }\r\n        }\r\n        // if dropping a tab back to same tabset and moving to forward position then reduce insertion index\r\n        if (dragNode.getType() === _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode.TYPE && dragParent === this && fromIndex < index && index > 0) {\r\n            index--;\r\n        }\r\n        // simple_bundled dock to existing tabset\r\n        let insertPos = index;\r\n        if (insertPos === -1) {\r\n            insertPos = this._children.length;\r\n        }\r\n        if (dragNode.getType() === _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode.TYPE) {\r\n            this._addChild(dragNode, insertPos);\r\n        }\r\n        if (select || (select !== false && this.isAutoSelectTab())) {\r\n            this._setSelected(insertPos);\r\n        }\r\n        this._model._tidy();\r\n    }\r\n    toJson() {\r\n        const json = {};\r\n        BorderNode._attributeDefinitions.toJson(json, this._attributes);\r\n        json.location = this._location.getName();\r\n        json.children = this._children.map((child) => child.toJson());\r\n        return json;\r\n    }\r\n    /** @internal */\r\n    _getSplitterBounds(splitter, useMinSize = false) {\r\n        const pBounds = [0, 0];\r\n        const minSize = useMinSize ? this.getMinSize() : 0;\r\n        const outerRect = this._model._getOuterInnerRects().outer;\r\n        const innerRect = this._model._getOuterInnerRects().inner;\r\n        const rootRow = this._model.getRoot();\r\n        if (this._location === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.TOP) {\r\n            pBounds[0] = outerRect.y + minSize;\r\n            pBounds[1] = Math.max(pBounds[0], innerRect.getBottom() - splitter.getHeight() - rootRow.getMinHeight());\r\n        }\r\n        else if (this._location === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.LEFT) {\r\n            pBounds[0] = outerRect.x + minSize;\r\n            pBounds[1] = Math.max(pBounds[0], innerRect.getRight() - splitter.getWidth() - rootRow.getMinWidth());\r\n        }\r\n        else if (this._location === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.BOTTOM) {\r\n            pBounds[1] = outerRect.getBottom() - splitter.getHeight() - minSize;\r\n            pBounds[0] = Math.min(pBounds[1], innerRect.y + rootRow.getMinHeight());\r\n        }\r\n        else if (this._location === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.RIGHT) {\r\n            pBounds[1] = outerRect.getRight() - splitter.getWidth() - minSize;\r\n            pBounds[0] = Math.min(pBounds[1], innerRect.x + rootRow.getMinWidth());\r\n        }\r\n        return pBounds;\r\n    }\r\n    /** @internal */\r\n    _calculateSplit(splitter, splitterPos) {\r\n        const pBounds = this._getSplitterBounds(splitter);\r\n        if (this._location === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.BOTTOM || this._location === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.RIGHT) {\r\n            return Math.max(0, pBounds[1] - splitterPos);\r\n        }\r\n        else {\r\n            return Math.max(0, splitterPos - pBounds[0]);\r\n        }\r\n    }\r\n    /** @internal */\r\n    _getAttributeDefinitions() {\r\n        return BorderNode._attributeDefinitions;\r\n    }\r\n    /** @internal */\r\n    static getAttributeDefinitions() {\r\n        return BorderNode._attributeDefinitions;\r\n    }\r\n}\r\nBorderNode.TYPE = \"border\";\r\n/** @internal */\r\nBorderNode._attributeDefinitions = BorderNode._createAttributeDefinitions();\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/BorderNode.ts?");

/***/ }),

/***/ "./src/model/BorderSet.ts":
/*!********************************!*\
  !*** ./src/model/BorderSet.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BorderSet\": () => (/* binding */ BorderSet)\n/* harmony export */ });\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _BorderNode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BorderNode */ \"./src/model/BorderNode.ts\");\n\r\n\r\nclass BorderSet {\r\n    /** @internal */\r\n    constructor(model) {\r\n        this._model = model;\r\n        this._borders = [];\r\n    }\r\n    /** @internal */\r\n    static _fromJson(json, model) {\r\n        const borderSet = new BorderSet(model);\r\n        borderSet._borders = json.map((borderJson) => _BorderNode__WEBPACK_IMPORTED_MODULE_1__.BorderNode._fromJson(borderJson, model));\r\n        return borderSet;\r\n    }\r\n    getBorders() {\r\n        return this._borders;\r\n    }\r\n    /** @internal */\r\n    _forEachNode(fn) {\r\n        for (const borderNode of this._borders) {\r\n            fn(borderNode, 0);\r\n            for (const node of borderNode.getChildren()) {\r\n                node._forEachNode(fn, 1);\r\n            }\r\n        }\r\n    }\r\n    /** @internal */\r\n    _toJson() {\r\n        return this._borders.map((borderNode) => borderNode.toJson());\r\n    }\r\n    /** @internal */\r\n    _layoutBorder(outerInnerRects, metrics) {\r\n        const rect = outerInnerRects.outer;\r\n        const rootRow = this._model.getRoot();\r\n        let height = Math.max(0, rect.height - rootRow.getMinHeight());\r\n        let width = Math.max(0, rect.width - rootRow.getMinWidth());\r\n        let sumHeight = 0;\r\n        let sumWidth = 0;\r\n        let adjustableHeight = 0;\r\n        let adjustableWidth = 0;\r\n        const showingBorders = this._borders.filter((border) => border.isShowing());\r\n        // sum size of borders to see they will fit\r\n        for (const border of showingBorders) {\r\n            border._setAdjustedSize(border.getSize());\r\n            const visible = border.getSelected() !== -1;\r\n            if (border.getLocation().getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_0__.Orientation.HORZ) {\r\n                sumWidth += border.getBorderBarSize();\r\n                if (visible) {\r\n                    width -= this._model.getSplitterSize();\r\n                    sumWidth += border.getSize();\r\n                    adjustableWidth += border.getSize();\r\n                }\r\n            }\r\n            else {\r\n                sumHeight += border.getBorderBarSize();\r\n                if (visible) {\r\n                    height -= this._model.getSplitterSize();\r\n                    sumHeight += border.getSize();\r\n                    adjustableHeight += border.getSize();\r\n                }\r\n            }\r\n        }\r\n        // adjust border sizes if too large\r\n        let j = 0;\r\n        let adjusted = false;\r\n        while ((sumWidth > width && adjustableWidth > 0) || (sumHeight > height && adjustableHeight > 0)) {\r\n            const border = showingBorders[j];\r\n            if (border.getSelected() !== -1) {\r\n                // visible\r\n                const size = border._getAdjustedSize();\r\n                if (sumWidth > width && adjustableWidth > 0 && border.getLocation().getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_0__.Orientation.HORZ && size > 0\r\n                    && size > border.getMinSize()) {\r\n                    border._setAdjustedSize(size - 1);\r\n                    sumWidth--;\r\n                    adjustableWidth--;\r\n                    adjusted = true;\r\n                }\r\n                else if (sumHeight > height && adjustableHeight > 0 && border.getLocation().getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_0__.Orientation.VERT && size > 0\r\n                    && size > border.getMinSize()) {\r\n                    border._setAdjustedSize(size - 1);\r\n                    sumHeight--;\r\n                    adjustableHeight--;\r\n                    adjusted = true;\r\n                }\r\n            }\r\n            j = (j + 1) % showingBorders.length;\r\n            if (j === 0) {\r\n                if (adjusted) {\r\n                    adjusted = false;\r\n                }\r\n                else {\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n        for (const border of showingBorders) {\r\n            outerInnerRects.outer = border._layoutBorderOuter(outerInnerRects.outer, metrics);\r\n        }\r\n        outerInnerRects.inner = outerInnerRects.outer;\r\n        for (const border of showingBorders) {\r\n            outerInnerRects.inner = border._layoutBorderInner(outerInnerRects.inner, metrics);\r\n        }\r\n        return outerInnerRects;\r\n    }\r\n    /** @internal */\r\n    _findDropTargetNode(dragNode, x, y) {\r\n        for (const border of this._borders) {\r\n            if (border.isShowing()) {\r\n                const dropInfo = border.canDrop(dragNode, x, y);\r\n                if (dropInfo !== undefined) {\r\n                    return dropInfo;\r\n                }\r\n            }\r\n        }\r\n        return undefined;\r\n    }\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/BorderSet.ts?");

/***/ }),

/***/ "./src/model/ICloseType.ts":
/*!*********************************!*\
  !*** ./src/model/ICloseType.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ICloseType\": () => (/* binding */ ICloseType)\n/* harmony export */ });\nvar ICloseType;\r\n(function (ICloseType) {\r\n    ICloseType[ICloseType[\"Visible\"] = 1] = \"Visible\";\r\n    ICloseType[ICloseType[\"Always\"] = 2] = \"Always\";\r\n    ICloseType[ICloseType[\"Selected\"] = 3] = \"Selected\";\r\n})(ICloseType || (ICloseType = {}));\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/ICloseType.ts?");

/***/ }),

/***/ "./src/model/IDraggable.ts":
/*!*********************************!*\
  !*** ./src/model/IDraggable.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/IDraggable.ts?");

/***/ }),

/***/ "./src/model/IDropTarget.ts":
/*!**********************************!*\
  !*** ./src/model/IDropTarget.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/IDropTarget.ts?");

/***/ }),

/***/ "./src/model/IJsonModel.ts":
/*!*********************************!*\
  !*** ./src/model/IJsonModel.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/IJsonModel.ts?");

/***/ }),

/***/ "./src/model/Model.ts":
/*!****************************!*\
  !*** ./src/model/Model.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Model\": () => (/* binding */ Model)\n/* harmony export */ });\n/* harmony import */ var _Attribute__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Attribute */ \"./src/Attribute.ts\");\n/* harmony import */ var _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AttributeDefinitions */ \"./src/AttributeDefinitions.ts\");\n/* harmony import */ var _DockLocation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DockLocation */ \"./src/DockLocation.ts\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Rect */ \"./src/Rect.ts\");\n/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _BorderNode__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./BorderNode */ \"./src/model/BorderNode.ts\");\n/* harmony import */ var _BorderSet__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./BorderSet */ \"./src/model/BorderSet.ts\");\n/* harmony import */ var _RowNode__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./RowNode */ \"./src/model/RowNode.ts\");\n/* harmony import */ var _TabNode__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./TabNode */ \"./src/model/TabNode.ts\");\n/* harmony import */ var _TabSetNode__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./TabSetNode */ \"./src/model/TabSetNode.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Utils */ \"./src/model/Utils.ts\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * Class containing the Tree of Nodes used by the FlexLayout component\r\n */\r\nclass Model {\r\n    /**\r\n     * 'private' constructor. Use the static method Model.fromJson(json) to create a model\r\n     *  @internal\r\n     */\r\n    constructor() {\r\n        /** @internal */\r\n        this._borderRects = { inner: _Rect__WEBPACK_IMPORTED_MODULE_4__.Rect.empty(), outer: _Rect__WEBPACK_IMPORTED_MODULE_4__.Rect.empty() };\r\n        this._attributes = {};\r\n        this._idMap = {};\r\n        this._borders = new _BorderSet__WEBPACK_IMPORTED_MODULE_7__.BorderSet(this);\r\n        this._pointerFine = true;\r\n        this._showHiddenBorder = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER;\r\n    }\r\n    /**\r\n     * Loads the model from the given json object\r\n     * @param json the json model to load\r\n     * @returns {Model} a new Model object\r\n     */\r\n    static fromJson(json) {\r\n        const model = new Model();\r\n        Model._attributeDefinitions.fromJson(json.global, model._attributes);\r\n        if (json.borders) {\r\n            model._borders = _BorderSet__WEBPACK_IMPORTED_MODULE_7__.BorderSet._fromJson(json.borders, model);\r\n        }\r\n        model._root = _RowNode__WEBPACK_IMPORTED_MODULE_8__.RowNode._fromJson(json.layout, model);\r\n        model._tidy(); // initial tidy of node tree\r\n        return model;\r\n    }\r\n    /** @internal */\r\n    static _createAttributeDefinitions() {\r\n        const attributeDefinitions = new _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__.AttributeDefinitions();\r\n        attributeDefinitions.add(\"legacyOverflowMenu\", false).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        // splitter\r\n        attributeDefinitions.add(\"splitterSize\", -1).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"splitterExtra\", 0).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"enableEdgeDock\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"rootOrientationVertical\", false).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"marginInsets\", { top: 0, right: 0, bottom: 0, left: 0 })\r\n            .setType(\"IInsets\");\r\n        attributeDefinitions.add(\"enableUseVisibility\", false).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        // tab\r\n        attributeDefinitions.add(\"tabEnableClose\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabCloseType\", 1).setType(\"ICloseType\");\r\n        attributeDefinitions.add(\"tabEnableFloat\", false).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabEnableDrag\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabEnableRename\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabClassName\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"tabIcon\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"tabEnableRenderOnDemand\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabDragSpeed\", 0.3).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"tabBorderWidth\", -1).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"tabBorderHeight\", -1).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        // tabset\r\n        attributeDefinitions.add(\"tabSetEnableDeleteWhenEmpty\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabSetEnableDrop\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabSetEnableDrag\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabSetEnableDivide\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabSetEnableMaximize\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabSetEnableClose\", false).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabSetAutoSelectTab\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabSetClassNameTabStrip\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"tabSetClassNameHeader\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"tabSetEnableTabStrip\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"tabSetHeaderHeight\", 0).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"tabSetTabStripHeight\", 0).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"tabSetMarginInsets\", { top: 0, right: 0, bottom: 0, left: 0 })\r\n            .setType(\"IInsets\");\r\n        attributeDefinitions.add(\"tabSetBorderInsets\", { top: 0, right: 0, bottom: 0, left: 0 })\r\n            .setType(\"IInsets\");\r\n        attributeDefinitions.add(\"tabSetTabLocation\", \"top\").setType(\"ITabLocation\");\r\n        attributeDefinitions.add(\"tabSetMinWidth\", 0).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"tabSetMinHeight\", 0).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        // border\r\n        attributeDefinitions.add(\"borderSize\", 200).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"borderMinSize\", 0).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"borderBarSize\", 0).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"borderEnableDrop\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"borderAutoSelectTabWhenOpen\", true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"borderAutoSelectTabWhenClosed\", false).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.add(\"borderClassName\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"borderEnableAutoHide\", false).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        return attributeDefinitions;\r\n    }\r\n    /** @internal */\r\n    _setChangeListener(listener) {\r\n        this._changeListener = listener;\r\n    }\r\n    /**\r\n     * Get the currently active tabset node\r\n     */\r\n    getActiveTabset() {\r\n        if (this._activeTabSet && this.getNodeById(this._activeTabSet.getId())) {\r\n            return this._activeTabSet;\r\n        }\r\n        else {\r\n            return undefined;\r\n        }\r\n    }\r\n    /** @internal */\r\n    _getShowHiddenBorder() {\r\n        return this._showHiddenBorder;\r\n    }\r\n    /** @internal */\r\n    _setShowHiddenBorder(location) {\r\n        this._showHiddenBorder = location;\r\n    }\r\n    /** @internal */\r\n    _setActiveTabset(tabsetNode) {\r\n        this._activeTabSet = tabsetNode;\r\n    }\r\n    /**\r\n     * Get the currently maximized tabset node\r\n     */\r\n    getMaximizedTabset() {\r\n        return this._maximizedTabSet;\r\n    }\r\n    /** @internal */\r\n    _setMaximizedTabset(tabsetNode) {\r\n        this._maximizedTabSet = tabsetNode;\r\n    }\r\n    /**\r\n     * Gets the root RowNode of the model\r\n     * @returns {RowNode}\r\n     */\r\n    getRoot() {\r\n        return this._root;\r\n    }\r\n    isRootOrientationVertical() {\r\n        return this._attributes.rootOrientationVertical;\r\n    }\r\n    isUseVisibility() {\r\n        return this._attributes.enableUseVisibility;\r\n    }\r\n    /**\r\n     * Gets the\r\n     * @returns {BorderSet|*}\r\n     */\r\n    getBorderSet() {\r\n        return this._borders;\r\n    }\r\n    /** @internal */\r\n    _getOuterInnerRects() {\r\n        return this._borderRects;\r\n    }\r\n    /** @internal */\r\n    _getPointerFine() {\r\n        return this._pointerFine;\r\n    }\r\n    /** @internal */\r\n    _setPointerFine(pointerFine) {\r\n        this._pointerFine = pointerFine;\r\n    }\r\n    /**\r\n     * Visits all the nodes in the model and calls the given function for each\r\n     * @param fn a function that takes visited node and a integer level as parameters\r\n     */\r\n    visitNodes(fn) {\r\n        this._borders._forEachNode(fn);\r\n        this._root._forEachNode(fn, 0);\r\n    }\r\n    /**\r\n     * Gets a node by its id\r\n     * @param id the id to find\r\n     */\r\n    getNodeById(id) {\r\n        return this._idMap[id];\r\n    }\r\n    /**\r\n     * Update the node tree by performing the given action,\r\n     * Actions should be generated via static methods on the Actions class\r\n     * @param action the action to perform\r\n     * @returns added Node for Actions.addNode; undefined otherwise\r\n     */\r\n    doAction(action) {\r\n        let returnVal = undefined;\r\n        // console.log(action);\r\n        switch (action.type) {\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.ADD_NODE: {\r\n                const newNode = new _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode(this, action.data.json, true);\r\n                const toNode = this._idMap[action.data.toNode];\r\n                if (toNode instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode || toNode instanceof _BorderNode__WEBPACK_IMPORTED_MODULE_6__.BorderNode || toNode instanceof _RowNode__WEBPACK_IMPORTED_MODULE_8__.RowNode) {\r\n                    toNode.drop(newNode, _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.getByName(action.data.location), action.data.index, action.data.select);\r\n                    returnVal = newNode;\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.MOVE_NODE: {\r\n                const fromNode = this._idMap[action.data.fromNode];\r\n                if (fromNode instanceof _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode || fromNode instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode) {\r\n                    const toNode = this._idMap[action.data.toNode];\r\n                    if (toNode instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode || toNode instanceof _BorderNode__WEBPACK_IMPORTED_MODULE_6__.BorderNode || toNode instanceof _RowNode__WEBPACK_IMPORTED_MODULE_8__.RowNode) {\r\n                        toNode.drop(fromNode, _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.getByName(action.data.location), action.data.index, action.data.select);\r\n                    }\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.DELETE_TAB: {\r\n                const node = this._idMap[action.data.node];\r\n                if (node instanceof _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode) {\r\n                    node._delete();\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.DELETE_TABSET: {\r\n                const node = this._idMap[action.data.node];\r\n                if (node instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode) {\r\n                    // first delete all child tabs that are closeable\r\n                    const children = [...node.getChildren()];\r\n                    for (let i = 0; i < children.length; i++) {\r\n                        const child = children[i];\r\n                        if (child.isEnableClose()) {\r\n                            child._delete();\r\n                        }\r\n                    }\r\n                    if (node.getChildren().length === 0) {\r\n                        node._delete();\r\n                    }\r\n                    this._tidy();\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.FLOAT_TAB: {\r\n                const node = this._idMap[action.data.node];\r\n                if (node instanceof _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode) {\r\n                    node._setFloating(true);\r\n                    (0,_Utils__WEBPACK_IMPORTED_MODULE_11__.adjustSelectedIndexAfterFloat)(node);\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.UNFLOAT_TAB: {\r\n                const node = this._idMap[action.data.node];\r\n                if (node instanceof _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode) {\r\n                    node._setFloating(false);\r\n                    (0,_Utils__WEBPACK_IMPORTED_MODULE_11__.adjustSelectedIndexAfterDock)(node);\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.RENAME_TAB: {\r\n                const node = this._idMap[action.data.node];\r\n                if (node instanceof _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode) {\r\n                    node._setName(action.data.text);\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.SELECT_TAB: {\r\n                const tabNode = this._idMap[action.data.tabNode];\r\n                if (tabNode instanceof _TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode) {\r\n                    const parent = tabNode.getParent();\r\n                    const pos = parent.getChildren().indexOf(tabNode);\r\n                    if (parent instanceof _BorderNode__WEBPACK_IMPORTED_MODULE_6__.BorderNode) {\r\n                        if (parent.getSelected() === pos) {\r\n                            parent._setSelected(-1);\r\n                        }\r\n                        else {\r\n                            parent._setSelected(pos);\r\n                        }\r\n                    }\r\n                    else if (parent instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode) {\r\n                        if (parent.getSelected() !== pos) {\r\n                            parent._setSelected(pos);\r\n                        }\r\n                        this._activeTabSet = parent;\r\n                    }\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.SET_ACTIVE_TABSET: {\r\n                const tabsetNode = this._idMap[action.data.tabsetNode];\r\n                if (tabsetNode instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode) {\r\n                    this._activeTabSet = tabsetNode;\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.ADJUST_SPLIT: {\r\n                const node1 = this._idMap[action.data.node1];\r\n                const node2 = this._idMap[action.data.node2];\r\n                if ((node1 instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode || node1 instanceof _RowNode__WEBPACK_IMPORTED_MODULE_8__.RowNode) && (node2 instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode || node2 instanceof _RowNode__WEBPACK_IMPORTED_MODULE_8__.RowNode)) {\r\n                    this._adjustSplitSide(node1, action.data.weight1, action.data.pixelWidth1);\r\n                    this._adjustSplitSide(node2, action.data.weight2, action.data.pixelWidth2);\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.ADJUST_BORDER_SPLIT: {\r\n                const node = this._idMap[action.data.node];\r\n                if (node instanceof _BorderNode__WEBPACK_IMPORTED_MODULE_6__.BorderNode) {\r\n                    node._setSize(action.data.pos);\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.MAXIMIZE_TOGGLE: {\r\n                const node = this._idMap[action.data.node];\r\n                if (node instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode) {\r\n                    if (node === this._maximizedTabSet) {\r\n                        this._maximizedTabSet = undefined;\r\n                    }\r\n                    else {\r\n                        this._maximizedTabSet = node;\r\n                        this._activeTabSet = node;\r\n                    }\r\n                }\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.UPDATE_MODEL_ATTRIBUTES: {\r\n                this._updateAttrs(action.data.json);\r\n                break;\r\n            }\r\n            case _Actions__WEBPACK_IMPORTED_MODULE_5__.Actions.UPDATE_NODE_ATTRIBUTES: {\r\n                const node = this._idMap[action.data.node];\r\n                node._updateAttrs(action.data.json);\r\n                break;\r\n            }\r\n            default:\r\n                break;\r\n        }\r\n        this._updateIdMap();\r\n        if (this._changeListener !== undefined) {\r\n            this._changeListener(action);\r\n        }\r\n        return returnVal;\r\n    }\r\n    /** @internal */\r\n    _updateIdMap() {\r\n        // regenerate idMap to stop it building up\r\n        this._idMap = {};\r\n        this.visitNodes((node) => (this._idMap[node.getId()] = node));\r\n        // console.log(JSON.stringify(Object.keys(this._idMap)));\r\n    }\r\n    /** @internal */\r\n    _adjustSplitSide(node, weight, pixels) {\r\n        node._setWeight(weight);\r\n        if (node.getWidth() != null && node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_3__.Orientation.VERT) {\r\n            node._updateAttrs({ width: pixels });\r\n        }\r\n        else if (node.getHeight() != null && node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_3__.Orientation.HORZ) {\r\n            node._updateAttrs({ height: pixels });\r\n        }\r\n    }\r\n    /**\r\n     * Converts the model to a json object\r\n     * @returns {IJsonModel} json object that represents this model\r\n     */\r\n    toJson() {\r\n        const global = {};\r\n        Model._attributeDefinitions.toJson(global, this._attributes);\r\n        // save state of nodes\r\n        this.visitNodes((node) => {\r\n            node._fireEvent(\"save\", undefined);\r\n        });\r\n        return { global, borders: this._borders._toJson(), layout: this._root.toJson() };\r\n    }\r\n    getSplitterSize() {\r\n        let splitterSize = this._attributes.splitterSize;\r\n        if (splitterSize === -1) {\r\n            // use defaults\r\n            splitterSize = this._pointerFine ? 8 : 12; // larger for mobile\r\n        }\r\n        return splitterSize;\r\n    }\r\n    isLegacyOverflowMenu() {\r\n        return this._attributes.legacyOverflowMenu;\r\n    }\r\n    getSplitterExtra() {\r\n        return this._attributes.splitterExtra;\r\n    }\r\n    isEnableEdgeDock() {\r\n        return this._attributes.enableEdgeDock;\r\n    }\r\n    /** @internal */\r\n    _addNode(node) {\r\n        const id = node.getId();\r\n        if (this._idMap[id] !== undefined) {\r\n            throw new Error(`Error: each node must have a unique id, duplicate id:${node.getId()}`);\r\n        }\r\n        if (node.getType() !== \"splitter\") {\r\n            this._idMap[id] = node;\r\n        }\r\n    }\r\n    /** @internal */\r\n    _layout(rect, metrics) {\r\n        var _a;\r\n        // let start = Date.now();\r\n        this._borderRects = this._borders._layoutBorder({ outer: rect, inner: rect }, metrics);\r\n        rect = this._borderRects.inner.removeInsets(this._getAttribute(\"marginInsets\"));\r\n        (_a = this._root) === null || _a === void 0 ? void 0 : _a.calcMinSize();\r\n        this._root._layout(rect, metrics);\r\n        // console.log(\"layout time: \" + (Date.now() - start));\r\n        return rect;\r\n    }\r\n    /** @internal */\r\n    _findDropTargetNode(dragNode, x, y) {\r\n        let node = this._root._findDropTargetNode(dragNode, x, y);\r\n        if (node === undefined) {\r\n            node = this._borders._findDropTargetNode(dragNode, x, y);\r\n        }\r\n        return node;\r\n    }\r\n    /** @internal */\r\n    _tidy() {\r\n        // console.log(\"before _tidy\", this.toString());\r\n        this._root._tidy();\r\n        // console.log(\"after _tidy\", this.toString());\r\n    }\r\n    /** @internal */\r\n    _updateAttrs(json) {\r\n        Model._attributeDefinitions.update(json, this._attributes);\r\n    }\r\n    /** @internal */\r\n    _nextUniqueId() {\r\n        return '#' + (0,_Utils__WEBPACK_IMPORTED_MODULE_11__.randomUUID)();\r\n    }\r\n    /** @internal */\r\n    _getAttribute(name) {\r\n        return this._attributes[name];\r\n    }\r\n    /**\r\n     * Sets a function to allow/deny dropping a node\r\n     * @param onAllowDrop function that takes the drag node and DropInfo and returns true if the drop is allowed\r\n     */\r\n    setOnAllowDrop(onAllowDrop) {\r\n        this._onAllowDrop = onAllowDrop;\r\n    }\r\n    /** @internal */\r\n    _getOnAllowDrop() {\r\n        return this._onAllowDrop;\r\n    }\r\n    /**\r\n     * set callback called when a new TabSet is created.\r\n     * The tabNode can be undefined if it's the auto created first tabset in the root row (when the last\r\n     * tab is deleted, the root tabset can be recreated)\r\n     * @param onCreateTabSet\r\n     */\r\n    setOnCreateTabSet(onCreateTabSet) {\r\n        this._onCreateTabSet = onCreateTabSet;\r\n    }\r\n    /** @internal */\r\n    _getOnCreateTabSet() {\r\n        return this._onCreateTabSet;\r\n    }\r\n    static toTypescriptInterfaces() {\r\n        console.log(Model._attributeDefinitions.toTypescriptInterface(\"Global\", undefined));\r\n        console.log(_RowNode__WEBPACK_IMPORTED_MODULE_8__.RowNode.getAttributeDefinitions().toTypescriptInterface(\"Row\", Model._attributeDefinitions));\r\n        console.log(_TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode.getAttributeDefinitions().toTypescriptInterface(\"TabSet\", Model._attributeDefinitions));\r\n        console.log(_TabNode__WEBPACK_IMPORTED_MODULE_9__.TabNode.getAttributeDefinitions().toTypescriptInterface(\"Tab\", Model._attributeDefinitions));\r\n        console.log(_BorderNode__WEBPACK_IMPORTED_MODULE_6__.BorderNode.getAttributeDefinitions().toTypescriptInterface(\"Border\", Model._attributeDefinitions));\r\n    }\r\n    toString() {\r\n        return JSON.stringify(this.toJson());\r\n    }\r\n}\r\n/** @internal */\r\nModel._attributeDefinitions = Model._createAttributeDefinitions();\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/Model.ts?");

/***/ }),

/***/ "./src/model/Node.ts":
/*!***************************!*\
  !*** ./src/model/Node.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Node\": () => (/* binding */ Node)\n/* harmony export */ });\n/* harmony import */ var _DockLocation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../DockLocation */ \"./src/DockLocation.ts\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Rect */ \"./src/Rect.ts\");\n\r\n\r\n\r\nclass Node {\r\n    /** @internal */\r\n    constructor(model) {\r\n        /** @internal */\r\n        this._dirty = false;\r\n        /** @internal */\r\n        this._tempSize = 0;\r\n        this._model = model;\r\n        this._attributes = {};\r\n        this._children = [];\r\n        this._fixed = false;\r\n        this._rect = _Rect__WEBPACK_IMPORTED_MODULE_2__.Rect.empty();\r\n        this._visible = false;\r\n        this._listeners = {};\r\n    }\r\n    getId() {\r\n        let id = this._attributes.id;\r\n        if (id !== undefined) {\r\n            return id;\r\n        }\r\n        id = this._model._nextUniqueId();\r\n        this._setId(id);\r\n        return id;\r\n    }\r\n    getModel() {\r\n        return this._model;\r\n    }\r\n    getType() {\r\n        return this._attributes.type;\r\n    }\r\n    getParent() {\r\n        return this._parent;\r\n    }\r\n    getChildren() {\r\n        return this._children;\r\n    }\r\n    getRect() {\r\n        return this._rect;\r\n    }\r\n    isVisible() {\r\n        return this._visible;\r\n    }\r\n    getOrientation() {\r\n        if (this._parent === undefined) {\r\n            return this._model.isRootOrientationVertical() ? _Orientation__WEBPACK_IMPORTED_MODULE_1__.Orientation.VERT : _Orientation__WEBPACK_IMPORTED_MODULE_1__.Orientation.HORZ;\r\n        }\r\n        else {\r\n            return _Orientation__WEBPACK_IMPORTED_MODULE_1__.Orientation.flip(this._parent.getOrientation());\r\n        }\r\n    }\r\n    // event can be: resize, visibility, maximize (on tabset), close\r\n    setEventListener(event, callback) {\r\n        this._listeners[event] = callback;\r\n    }\r\n    removeEventListener(event) {\r\n        delete this._listeners[event];\r\n    }\r\n    /** @internal */\r\n    _setId(id) {\r\n        this._attributes.id = id;\r\n    }\r\n    /** @internal */\r\n    _fireEvent(event, params) {\r\n        // console.log(this._type, \" fireEvent \" + event + \" \" + JSON.stringify(params));\r\n        if (this._listeners[event] !== undefined) {\r\n            this._listeners[event](params);\r\n        }\r\n    }\r\n    /** @internal */\r\n    _getAttr(name) {\r\n        let val = this._attributes[name];\r\n        if (val === undefined) {\r\n            const modelName = this._getAttributeDefinitions().getModelName(name);\r\n            if (modelName !== undefined) {\r\n                val = this._model._getAttribute(modelName);\r\n            }\r\n        }\r\n        // console.log(name + \"=\" + val);\r\n        return val;\r\n    }\r\n    /** @internal */\r\n    _forEachNode(fn, level) {\r\n        fn(this, level);\r\n        level++;\r\n        for (const node of this._children) {\r\n            node._forEachNode(fn, level);\r\n        }\r\n    }\r\n    /** @internal */\r\n    _setVisible(visible) {\r\n        if (visible !== this._visible) {\r\n            this._fireEvent(\"visibility\", { visible });\r\n            this._visible = visible;\r\n        }\r\n    }\r\n    /** @internal */\r\n    _getDrawChildren() {\r\n        return this._children;\r\n    }\r\n    /** @internal */\r\n    _setParent(parent) {\r\n        this._parent = parent;\r\n    }\r\n    /** @internal */\r\n    _setRect(rect) {\r\n        this._rect = rect;\r\n    }\r\n    /** @internal */\r\n    _setWeight(weight) {\r\n        this._attributes.weight = weight;\r\n    }\r\n    /** @internal */\r\n    _setSelected(index) {\r\n        this._attributes.selected = index;\r\n    }\r\n    /** @internal */\r\n    _isFixed() {\r\n        return this._fixed;\r\n    }\r\n    /** @internal */\r\n    _layout(rect, metrics) {\r\n        this._rect = rect;\r\n    }\r\n    /** @internal */\r\n    _findDropTargetNode(dragNode, x, y) {\r\n        let rtn;\r\n        if (this._rect.contains(x, y)) {\r\n            if (this._model.getMaximizedTabset() !== undefined) {\r\n                rtn = this._model.getMaximizedTabset().canDrop(dragNode, x, y);\r\n            }\r\n            else {\r\n                rtn = this.canDrop(dragNode, x, y);\r\n                if (rtn === undefined) {\r\n                    if (this._children.length !== 0) {\r\n                        for (const child of this._children) {\r\n                            rtn = child._findDropTargetNode(dragNode, x, y);\r\n                            if (rtn !== undefined) {\r\n                                break;\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        return rtn;\r\n    }\r\n    /** @internal */\r\n    canDrop(dragNode, x, y) {\r\n        return undefined;\r\n    }\r\n    /** @internal */\r\n    _canDockInto(dragNode, dropInfo) {\r\n        if (dropInfo != null) {\r\n            if (dropInfo.location === _DockLocation__WEBPACK_IMPORTED_MODULE_0__.DockLocation.CENTER && dropInfo.node.isEnableDrop() === false) {\r\n                return false;\r\n            }\r\n            // prevent named tabset docking into another tabset, since this would lose the header\r\n            if (dropInfo.location === _DockLocation__WEBPACK_IMPORTED_MODULE_0__.DockLocation.CENTER && dragNode.getType() === \"tabset\" && dragNode.getName() !== undefined) {\r\n                return false;\r\n            }\r\n            if (dropInfo.location !== _DockLocation__WEBPACK_IMPORTED_MODULE_0__.DockLocation.CENTER && dropInfo.node.isEnableDivide() === false) {\r\n                return false;\r\n            }\r\n            // finally check model callback to check if drop allowed\r\n            if (this._model._getOnAllowDrop()) {\r\n                return this._model._getOnAllowDrop()(dragNode, dropInfo);\r\n            }\r\n        }\r\n        return true;\r\n    }\r\n    /** @internal */\r\n    _removeChild(childNode) {\r\n        const pos = this._children.indexOf(childNode);\r\n        if (pos !== -1) {\r\n            this._children.splice(pos, 1);\r\n        }\r\n        this._dirty = true;\r\n        return pos;\r\n    }\r\n    /** @internal */\r\n    _addChild(childNode, pos) {\r\n        if (pos != null) {\r\n            this._children.splice(pos, 0, childNode);\r\n        }\r\n        else {\r\n            this._children.push(childNode);\r\n            pos = this._children.length - 1;\r\n        }\r\n        childNode._parent = this;\r\n        this._dirty = true;\r\n        return pos;\r\n    }\r\n    /** @internal */\r\n    _removeAll() {\r\n        this._children = [];\r\n        this._dirty = true;\r\n    }\r\n    /** @internal */\r\n    _styleWithPosition(style) {\r\n        if (style == null) {\r\n            style = {};\r\n        }\r\n        return this._rect.styleWithPosition(style);\r\n    }\r\n    /** @internal */\r\n    _getTempSize() {\r\n        return this._tempSize;\r\n    }\r\n    /** @internal */\r\n    _setTempSize(value) {\r\n        this._tempSize = value;\r\n    }\r\n    /** @internal */\r\n    isEnableDivide() {\r\n        return true;\r\n    }\r\n    /** @internal */\r\n    _toAttributeString() {\r\n        return JSON.stringify(this._attributes, undefined, \"\\t\");\r\n    }\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/Node.ts?");

/***/ }),

/***/ "./src/model/RowNode.ts":
/*!******************************!*\
  !*** ./src/model/RowNode.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"RowNode\": () => (/* binding */ RowNode)\n/* harmony export */ });\n/* harmony import */ var _Attribute__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Attribute */ \"./src/Attribute.ts\");\n/* harmony import */ var _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AttributeDefinitions */ \"./src/AttributeDefinitions.ts\");\n/* harmony import */ var _DockLocation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DockLocation */ \"./src/DockLocation.ts\");\n/* harmony import */ var _DropInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../DropInfo */ \"./src/DropInfo.ts\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Rect */ \"./src/Rect.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _BorderNode__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./BorderNode */ \"./src/model/BorderNode.ts\");\n/* harmony import */ var _Node__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Node */ \"./src/model/Node.ts\");\n/* harmony import */ var _SplitterNode__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./SplitterNode */ \"./src/model/SplitterNode.ts\");\n/* harmony import */ var _TabSetNode__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./TabSetNode */ \"./src/model/TabSetNode.ts\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nclass RowNode extends _Node__WEBPACK_IMPORTED_MODULE_8__.Node {\r\n    /** @internal */\r\n    constructor(model, json) {\r\n        super(model);\r\n        this._dirty = true;\r\n        this._drawChildren = [];\r\n        this._minHeight = 0;\r\n        this._minWidth = 0;\r\n        RowNode._attributeDefinitions.fromJson(json, this._attributes);\r\n        model._addNode(this);\r\n    }\r\n    /** @internal */\r\n    static _fromJson(json, model) {\r\n        const newLayoutNode = new RowNode(model, json);\r\n        if (json.children != null) {\r\n            for (const jsonChild of json.children) {\r\n                if (jsonChild.type === _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode.TYPE) {\r\n                    const child = _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode._fromJson(jsonChild, model);\r\n                    newLayoutNode._addChild(child);\r\n                }\r\n                else {\r\n                    const child = RowNode._fromJson(jsonChild, model);\r\n                    newLayoutNode._addChild(child);\r\n                }\r\n            }\r\n        }\r\n        return newLayoutNode;\r\n    }\r\n    /** @internal */\r\n    static _createAttributeDefinitions() {\r\n        const attributeDefinitions = new _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__.AttributeDefinitions();\r\n        attributeDefinitions.add(\"type\", RowNode.TYPE, true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING).setFixed();\r\n        attributeDefinitions.add(\"id\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"weight\", 100).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"width\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"height\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        return attributeDefinitions;\r\n    }\r\n    getWeight() {\r\n        return this._attributes.weight;\r\n    }\r\n    getWidth() {\r\n        return this._getAttr(\"width\");\r\n    }\r\n    getHeight() {\r\n        return this._getAttr(\"height\");\r\n    }\r\n    /** @internal */\r\n    _setWeight(weight) {\r\n        this._attributes.weight = weight;\r\n    }\r\n    /** @internal */\r\n    _layout(rect, metrics) {\r\n        super._layout(rect, metrics);\r\n        const pixelSize = this._rect._getSize(this.getOrientation());\r\n        let totalWeight = 0;\r\n        let fixedPixels = 0;\r\n        let prefPixels = 0;\r\n        let totalPrefWeight = 0;\r\n        const drawChildren = this._getDrawChildren();\r\n        for (const child of drawChildren) {\r\n            const prefSize = child._getPrefSize(this.getOrientation());\r\n            if (child._isFixed()) {\r\n                if (prefSize !== undefined) {\r\n                    fixedPixels += prefSize;\r\n                }\r\n            }\r\n            else {\r\n                if (prefSize === undefined) {\r\n                    totalWeight += child.getWeight();\r\n                }\r\n                else {\r\n                    prefPixels += prefSize;\r\n                    totalPrefWeight += child.getWeight();\r\n                }\r\n            }\r\n        }\r\n        let resizePreferred = false;\r\n        let availablePixels = pixelSize - fixedPixels - prefPixels;\r\n        if (availablePixels < 0) {\r\n            availablePixels = pixelSize - fixedPixels;\r\n            resizePreferred = true;\r\n            totalWeight += totalPrefWeight;\r\n        }\r\n        // assign actual pixel sizes\r\n        let totalSizeGiven = 0;\r\n        let variableSize = 0;\r\n        for (const child of drawChildren) {\r\n            const prefSize = child._getPrefSize(this.getOrientation());\r\n            if (child._isFixed()) {\r\n                if (prefSize !== undefined) {\r\n                    child._setTempSize(prefSize);\r\n                }\r\n            }\r\n            else {\r\n                if (prefSize == null || resizePreferred) {\r\n                    if (totalWeight === 0) {\r\n                        child._setTempSize(0);\r\n                    }\r\n                    else {\r\n                        const minSize = child.getMinSize(this.getOrientation());\r\n                        const size = Math.floor(availablePixels * (child.getWeight() / totalWeight));\r\n                        child._setTempSize(Math.max(minSize, size));\r\n                    }\r\n                    variableSize += child._getTempSize();\r\n                }\r\n                else {\r\n                    child._setTempSize(prefSize);\r\n                }\r\n            }\r\n            totalSizeGiven += child._getTempSize();\r\n        }\r\n        // adjust sizes to exactly fit\r\n        if (variableSize > 0) {\r\n            while (totalSizeGiven < pixelSize) {\r\n                for (const child of drawChildren) {\r\n                    if (!(child instanceof _SplitterNode__WEBPACK_IMPORTED_MODULE_9__.SplitterNode)) {\r\n                        const prefSize = child._getPrefSize(this.getOrientation());\r\n                        if (!child._isFixed() && (prefSize === undefined || resizePreferred) && totalSizeGiven < pixelSize) {\r\n                            child._setTempSize(child._getTempSize() + 1);\r\n                            totalSizeGiven++;\r\n                        }\r\n                    }\r\n                }\r\n            }\r\n            // decrease size using nodes not at there minimum\r\n            while (totalSizeGiven > pixelSize) {\r\n                let changed = false;\r\n                for (const child of drawChildren) {\r\n                    if (!(child instanceof _SplitterNode__WEBPACK_IMPORTED_MODULE_9__.SplitterNode)) {\r\n                        const minSize = child.getMinSize(this.getOrientation());\r\n                        const size = child._getTempSize();\r\n                        if (size > minSize && totalSizeGiven > pixelSize) {\r\n                            child._setTempSize(child._getTempSize() - 1);\r\n                            totalSizeGiven--;\r\n                            changed = true;\r\n                        }\r\n                    }\r\n                }\r\n                if (!changed) {\r\n                    // all children are at min values\r\n                    break;\r\n                }\r\n            }\r\n            // if still too big then simply reduce all nodes until fits\r\n            while (totalSizeGiven > pixelSize) {\r\n                let changed = false;\r\n                for (const child of drawChildren) {\r\n                    if (!(child instanceof _SplitterNode__WEBPACK_IMPORTED_MODULE_9__.SplitterNode)) {\r\n                        const size = child._getTempSize();\r\n                        if (size > 0 && totalSizeGiven > pixelSize) {\r\n                            child._setTempSize(child._getTempSize() - 1);\r\n                            totalSizeGiven--;\r\n                            changed = true;\r\n                        }\r\n                    }\r\n                }\r\n                if (!changed) {\r\n                    // all children are at 0 values\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n        // layout children\r\n        let p = 0;\r\n        for (const child of drawChildren) {\r\n            if (this.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ) {\r\n                child._layout(new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(this._rect.x + p, this._rect.y, child._getTempSize(), this._rect.height), metrics);\r\n            }\r\n            else {\r\n                child._layout(new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(this._rect.x, this._rect.y + p, this._rect.width, child._getTempSize()), metrics);\r\n            }\r\n            p += child._getTempSize();\r\n        }\r\n        return true;\r\n    }\r\n    /** @internal */\r\n    _getSplitterBounds(splitterNode, useMinSize = false) {\r\n        const pBounds = [0, 0];\r\n        const drawChildren = this._getDrawChildren();\r\n        const p = drawChildren.indexOf(splitterNode);\r\n        const node1 = drawChildren[p - 1];\r\n        const node2 = drawChildren[p + 1];\r\n        if (this.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ) {\r\n            const minSize1 = useMinSize ? node1.getMinWidth() : 0;\r\n            const minSize2 = useMinSize ? node2.getMinWidth() : 0;\r\n            pBounds[0] = node1.getRect().x + minSize1;\r\n            pBounds[1] = node2.getRect().getRight() - splitterNode.getWidth() - minSize2;\r\n        }\r\n        else {\r\n            const minSize1 = useMinSize ? node1.getMinHeight() : 0;\r\n            const minSize2 = useMinSize ? node2.getMinHeight() : 0;\r\n            pBounds[0] = node1.getRect().y + minSize1;\r\n            pBounds[1] = node2.getRect().getBottom() - splitterNode.getHeight() - minSize2;\r\n        }\r\n        return pBounds;\r\n    }\r\n    /** @internal */\r\n    _calculateSplit(splitter, splitterPos) {\r\n        let rtn;\r\n        const drawChildren = this._getDrawChildren();\r\n        const p = drawChildren.indexOf(splitter);\r\n        const pBounds = this._getSplitterBounds(splitter);\r\n        const weightedLength = drawChildren[p - 1].getWeight() + drawChildren[p + 1].getWeight();\r\n        const pixelWidth1 = Math.max(0, splitterPos - pBounds[0]);\r\n        const pixelWidth2 = Math.max(0, pBounds[1] - splitterPos);\r\n        if (pixelWidth1 + pixelWidth2 > 0) {\r\n            const weight1 = (pixelWidth1 * weightedLength) / (pixelWidth1 + pixelWidth2);\r\n            const weight2 = (pixelWidth2 * weightedLength) / (pixelWidth1 + pixelWidth2);\r\n            rtn = {\r\n                node1Id: drawChildren[p - 1].getId(),\r\n                weight1,\r\n                pixelWidth1,\r\n                node2Id: drawChildren[p + 1].getId(),\r\n                weight2,\r\n                pixelWidth2,\r\n            };\r\n        }\r\n        return rtn;\r\n    }\r\n    /** @internal */\r\n    _getDrawChildren() {\r\n        if (this._dirty) {\r\n            this._drawChildren = [];\r\n            for (let i = 0; i < this._children.length; i++) {\r\n                const child = this._children[i];\r\n                if (i !== 0) {\r\n                    const newSplitter = new _SplitterNode__WEBPACK_IMPORTED_MODULE_9__.SplitterNode(this._model);\r\n                    newSplitter._setParent(this);\r\n                    this._drawChildren.push(newSplitter);\r\n                }\r\n                this._drawChildren.push(child);\r\n            }\r\n            this._dirty = false;\r\n        }\r\n        return this._drawChildren;\r\n    }\r\n    /** @internal */\r\n    getMinSize(orientation) {\r\n        if (orientation === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ) {\r\n            return this.getMinWidth();\r\n        }\r\n        else {\r\n            return this.getMinHeight();\r\n        }\r\n    }\r\n    /** @internal */\r\n    getMinWidth() {\r\n        return this._minWidth;\r\n    }\r\n    /** @internal */\r\n    getMinHeight() {\r\n        return this._minHeight;\r\n    }\r\n    /** @internal */\r\n    calcMinSize() {\r\n        this._minHeight = 0;\r\n        this._minWidth = 0;\r\n        let first = true;\r\n        for (const child of this._children) {\r\n            const c = child;\r\n            if (c instanceof RowNode) {\r\n                c.calcMinSize();\r\n            }\r\n            if (this.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.VERT) {\r\n                this._minHeight += c.getMinHeight();\r\n                if (!first) {\r\n                    this._minHeight += this._model.getSplitterSize();\r\n                }\r\n                this._minWidth = Math.max(this._minWidth, c.getMinWidth());\r\n            }\r\n            else {\r\n                this._minWidth += c.getMinWidth();\r\n                if (!first) {\r\n                    this._minWidth += this._model.getSplitterSize();\r\n                }\r\n                this._minHeight = Math.max(this._minHeight, c.getMinHeight());\r\n            }\r\n            first = false;\r\n        }\r\n    }\r\n    /** @internal */\r\n    _tidy() {\r\n        let i = 0;\r\n        while (i < this._children.length) {\r\n            const child = this._children[i];\r\n            if (child instanceof RowNode) {\r\n                child._tidy();\r\n                const childChildren = child.getChildren();\r\n                if (childChildren.length === 0) {\r\n                    this._removeChild(child);\r\n                }\r\n                else if (childChildren.length === 1) {\r\n                    // hoist child/children up to this level\r\n                    const subchild = childChildren[0];\r\n                    this._removeChild(child);\r\n                    if (subchild instanceof RowNode) {\r\n                        let subChildrenTotal = 0;\r\n                        const subChildChildren = subchild.getChildren();\r\n                        for (const ssc of subChildChildren) {\r\n                            const subsubChild = ssc;\r\n                            subChildrenTotal += subsubChild.getWeight();\r\n                        }\r\n                        for (let j = 0; j < subChildChildren.length; j++) {\r\n                            const subsubChild = subChildChildren[j];\r\n                            subsubChild._setWeight((child.getWeight() * subsubChild.getWeight()) / subChildrenTotal);\r\n                            this._addChild(subsubChild, i + j);\r\n                        }\r\n                    }\r\n                    else {\r\n                        subchild._setWeight(child.getWeight());\r\n                        this._addChild(subchild, i);\r\n                    }\r\n                }\r\n                else {\r\n                    i++;\r\n                }\r\n            }\r\n            else if (child instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode && child.getChildren().length === 0) {\r\n                if (child.isEnableDeleteWhenEmpty()) {\r\n                    this._removeChild(child);\r\n                    if (child === this._model.getMaximizedTabset()) {\r\n                        this._model._setMaximizedTabset(undefined);\r\n                    }\r\n                }\r\n                else {\r\n                    i++;\r\n                }\r\n            }\r\n            else {\r\n                i++;\r\n            }\r\n        }\r\n        // add tabset into empty root\r\n        if (this === this._model.getRoot() && this._children.length === 0) {\r\n            const callback = this._model._getOnCreateTabSet();\r\n            let attrs = callback ? callback() : {};\r\n            attrs = Object.assign(Object.assign({}, attrs), { selected: -1 });\r\n            const child = new _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode(this._model, attrs);\r\n            this._model._setActiveTabset(child);\r\n            this._addChild(child);\r\n        }\r\n    }\r\n    /** @internal */\r\n    canDrop(dragNode, x, y) {\r\n        const yy = y - this._rect.y;\r\n        const xx = x - this._rect.x;\r\n        const w = this._rect.width;\r\n        const h = this._rect.height;\r\n        const margin = 10; // height of edge rect\r\n        const half = 50; // half width of edge rect\r\n        let dropInfo;\r\n        if (this._model.isEnableEdgeDock() && this._parent === undefined) {\r\n            // _root row\r\n            if (x < this._rect.x + margin && yy > h / 2 - half && yy < h / 2 + half) {\r\n                const dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.LEFT;\r\n                const outlineRect = dockLocation.getDockRect(this._rect);\r\n                outlineRect.width = outlineRect.width / 2;\r\n                dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, -1, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT_EDGE);\r\n            }\r\n            else if (x > this._rect.getRight() - margin && yy > h / 2 - half && yy < h / 2 + half) {\r\n                const dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.RIGHT;\r\n                const outlineRect = dockLocation.getDockRect(this._rect);\r\n                outlineRect.width = outlineRect.width / 2;\r\n                outlineRect.x += outlineRect.width;\r\n                dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, -1, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT_EDGE);\r\n            }\r\n            else if (y < this._rect.y + margin && xx > w / 2 - half && xx < w / 2 + half) {\r\n                const dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.TOP;\r\n                const outlineRect = dockLocation.getDockRect(this._rect);\r\n                outlineRect.height = outlineRect.height / 2;\r\n                dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, -1, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT_EDGE);\r\n            }\r\n            else if (y > this._rect.getBottom() - margin && xx > w / 2 - half && xx < w / 2 + half) {\r\n                const dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.BOTTOM;\r\n                const outlineRect = dockLocation.getDockRect(this._rect);\r\n                outlineRect.height = outlineRect.height / 2;\r\n                outlineRect.y += outlineRect.height;\r\n                dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, -1, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT_EDGE);\r\n            }\r\n            if (dropInfo !== undefined) {\r\n                if (!dragNode._canDockInto(dragNode, dropInfo)) {\r\n                    return undefined;\r\n                }\r\n            }\r\n        }\r\n        return dropInfo;\r\n    }\r\n    /** @internal */\r\n    drop(dragNode, location, index) {\r\n        const dockLocation = location;\r\n        const parent = dragNode.getParent();\r\n        if (parent) {\r\n            parent._removeChild(dragNode);\r\n        }\r\n        if (parent !== undefined && parent.getType() === _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode.TYPE) {\r\n            parent._setSelected(0);\r\n        }\r\n        if (parent !== undefined && parent.getType() === _BorderNode__WEBPACK_IMPORTED_MODULE_7__.BorderNode.TYPE) {\r\n            parent._setSelected(-1);\r\n        }\r\n        let tabSet;\r\n        if (dragNode instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode) {\r\n            tabSet = dragNode;\r\n        }\r\n        else {\r\n            const callback = this._model._getOnCreateTabSet();\r\n            tabSet = new _TabSetNode__WEBPACK_IMPORTED_MODULE_10__.TabSetNode(this._model, callback ? callback(dragNode) : {});\r\n            tabSet._addChild(dragNode);\r\n        }\r\n        let size = this._children.reduce((sum, child) => {\r\n            return sum + child.getWeight();\r\n        }, 0);\r\n        if (size === 0) {\r\n            size = 100;\r\n        }\r\n        tabSet._setWeight(size / 3);\r\n        const horz = !this._model.isRootOrientationVertical();\r\n        if (horz && dockLocation === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.LEFT || !horz && dockLocation === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.TOP) {\r\n            this._addChild(tabSet, 0);\r\n        }\r\n        else if (horz && dockLocation === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.RIGHT || !horz && dockLocation === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.BOTTOM) {\r\n            this._addChild(tabSet);\r\n        }\r\n        else if (horz && dockLocation === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.TOP || !horz && dockLocation === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.LEFT) {\r\n            const vrow = new RowNode(this._model, {});\r\n            const hrow = new RowNode(this._model, {});\r\n            hrow._setWeight(75);\r\n            tabSet._setWeight(25);\r\n            for (const child of this._children) {\r\n                hrow._addChild(child);\r\n            }\r\n            this._removeAll();\r\n            vrow._addChild(tabSet);\r\n            vrow._addChild(hrow);\r\n            this._addChild(vrow);\r\n        }\r\n        else if (horz && dockLocation === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.BOTTOM || !horz && dockLocation === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.RIGHT) {\r\n            const vrow = new RowNode(this._model, {});\r\n            const hrow = new RowNode(this._model, {});\r\n            hrow._setWeight(75);\r\n            tabSet._setWeight(25);\r\n            for (const child of this._children) {\r\n                hrow._addChild(child);\r\n            }\r\n            this._removeAll();\r\n            vrow._addChild(hrow);\r\n            vrow._addChild(tabSet);\r\n            this._addChild(vrow);\r\n        }\r\n        this._model._setActiveTabset(tabSet);\r\n        this._model._tidy();\r\n    }\r\n    toJson() {\r\n        const json = {};\r\n        RowNode._attributeDefinitions.toJson(json, this._attributes);\r\n        json.children = [];\r\n        for (const child of this._children) {\r\n            json.children.push(child.toJson());\r\n        }\r\n        return json;\r\n    }\r\n    isEnableDrop() {\r\n        return true;\r\n    }\r\n    /** @internal */\r\n    _getPrefSize(orientation) {\r\n        let prefSize = this.getWidth();\r\n        if (orientation === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.VERT) {\r\n            prefSize = this.getHeight();\r\n        }\r\n        return prefSize;\r\n    }\r\n    /** @internal */\r\n    _getAttributeDefinitions() {\r\n        return RowNode._attributeDefinitions;\r\n    }\r\n    /** @internal */\r\n    _updateAttrs(json) {\r\n        RowNode._attributeDefinitions.update(json, this._attributes);\r\n    }\r\n    /** @internal */\r\n    static getAttributeDefinitions() {\r\n        return RowNode._attributeDefinitions;\r\n    }\r\n}\r\nRowNode.TYPE = \"row\";\r\n/** @internal */\r\nRowNode._attributeDefinitions = RowNode._createAttributeDefinitions();\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/RowNode.ts?");

/***/ }),

/***/ "./src/model/SplitterNode.ts":
/*!***********************************!*\
  !*** ./src/model/SplitterNode.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"SplitterNode\": () => (/* binding */ SplitterNode)\n/* harmony export */ });\n/* harmony import */ var _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../AttributeDefinitions */ \"./src/AttributeDefinitions.ts\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Node */ \"./src/model/Node.ts\");\n\r\n\r\n\r\nclass SplitterNode extends _Node__WEBPACK_IMPORTED_MODULE_2__.Node {\r\n    /** @internal */\r\n    constructor(model) {\r\n        super(model);\r\n        this._fixed = true;\r\n        this._attributes.type = SplitterNode.TYPE;\r\n        model._addNode(this);\r\n    }\r\n    /** @internal */\r\n    getWidth() {\r\n        return this._model.getSplitterSize();\r\n    }\r\n    /** @internal */\r\n    getMinWidth() {\r\n        if (this.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_1__.Orientation.VERT) {\r\n            return this._model.getSplitterSize();\r\n        }\r\n        else {\r\n            return 0;\r\n        }\r\n    }\r\n    /** @internal */\r\n    getHeight() {\r\n        return this._model.getSplitterSize();\r\n    }\r\n    /** @internal */\r\n    getMinHeight() {\r\n        if (this.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_1__.Orientation.HORZ) {\r\n            return this._model.getSplitterSize();\r\n        }\r\n        else {\r\n            return 0;\r\n        }\r\n    }\r\n    /** @internal */\r\n    getMinSize(orientation) {\r\n        if (orientation === _Orientation__WEBPACK_IMPORTED_MODULE_1__.Orientation.HORZ) {\r\n            return this.getMinWidth();\r\n        }\r\n        else {\r\n            return this.getMinHeight();\r\n        }\r\n    }\r\n    /** @internal */\r\n    getWeight() {\r\n        return 0;\r\n    }\r\n    /** @internal */\r\n    _setWeight(value) { }\r\n    /** @internal */\r\n    _getPrefSize(orientation) {\r\n        return this._model.getSplitterSize();\r\n    }\r\n    /** @internal */\r\n    _updateAttrs(json) { }\r\n    /** @internal */\r\n    _getAttributeDefinitions() {\r\n        return new _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_0__.AttributeDefinitions();\r\n    }\r\n    toJson() {\r\n        return undefined;\r\n    }\r\n}\r\nSplitterNode.TYPE = \"splitter\";\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/SplitterNode.ts?");

/***/ }),

/***/ "./src/model/TabNode.ts":
/*!******************************!*\
  !*** ./src/model/TabNode.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"TabNode\": () => (/* binding */ TabNode)\n/* harmony export */ });\n/* harmony import */ var _Attribute__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Attribute */ \"./src/Attribute.ts\");\n/* harmony import */ var _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AttributeDefinitions */ \"./src/AttributeDefinitions.ts\");\n/* harmony import */ var _Node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Node */ \"./src/model/Node.ts\");\n\r\n\r\n\r\nclass TabNode extends _Node__WEBPACK_IMPORTED_MODULE_2__.Node {\r\n    /** @internal */\r\n    constructor(model, json, addToModel = true) {\r\n        super(model);\r\n        this._extra = {}; // extra data added to node not saved in json\r\n        TabNode._attributeDefinitions.fromJson(json, this._attributes);\r\n        if (addToModel === true) {\r\n            model._addNode(this);\r\n        }\r\n    }\r\n    /** @internal */\r\n    static _fromJson(json, model, addToModel = true) {\r\n        const newLayoutNode = new TabNode(model, json, addToModel);\r\n        return newLayoutNode;\r\n    }\r\n    /** @internal */\r\n    static _createAttributeDefinitions() {\r\n        const attributeDefinitions = new _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__.AttributeDefinitions();\r\n        attributeDefinitions.add(\"type\", TabNode.TYPE, true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"id\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"name\", \"[Unnamed Tab]\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"altName\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"helpText\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"component\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"config\", undefined).setType(\"any\");\r\n        attributeDefinitions.add(\"floating\", false).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.addInherited(\"enableClose\", \"tabEnableClose\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.addInherited(\"closeType\", \"tabCloseType\").setType(\"ICloseType\");\r\n        attributeDefinitions.addInherited(\"enableDrag\", \"tabEnableDrag\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.addInherited(\"enableRename\", \"tabEnableRename\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.addInherited(\"className\", \"tabClassName\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.addInherited(\"icon\", \"tabIcon\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.addInherited(\"enableRenderOnDemand\", \"tabEnableRenderOnDemand\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.addInherited(\"enableFloat\", \"tabEnableFloat\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        attributeDefinitions.addInherited(\"borderWidth\", \"tabBorderWidth\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.addInherited(\"borderHeight\", \"tabBorderHeight\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        return attributeDefinitions;\r\n    }\r\n    getWindow() {\r\n        return this._window;\r\n    }\r\n    getTabRect() {\r\n        return this._tabRect;\r\n    }\r\n    /** @internal */\r\n    _setTabRect(rect) {\r\n        this._tabRect = rect;\r\n    }\r\n    /** @internal */\r\n    _setRenderedName(name) {\r\n        this._renderedName = name;\r\n    }\r\n    /** @internal */\r\n    _getNameForOverflowMenu() {\r\n        const altName = this._getAttr(\"altName\");\r\n        if (altName !== undefined) {\r\n            return altName;\r\n        }\r\n        return this._renderedName;\r\n    }\r\n    getName() {\r\n        return this._getAttr(\"name\");\r\n    }\r\n    getHelpText() {\r\n        return this._getAttr(\"helpText\");\r\n    }\r\n    getComponent() {\r\n        return this._getAttr(\"component\");\r\n    }\r\n    /**\r\n     * Returns the config attribute that can be used to store node specific data that\r\n     * WILL be saved to the json. The config attribute should be changed via the action Actions.updateNodeAttributes rather\r\n     * than directly, for example:\r\n     * this.state.model.doAction(\r\n     *   FlexLayout.Actions.updateNodeAttributes(node.getId(), {config:myConfigObject}));\r\n     */\r\n    getConfig() {\r\n        return this._attributes.config;\r\n    }\r\n    /**\r\n     * Returns an object that can be used to store transient node specific data that will\r\n     * NOT be saved in the json.\r\n     */\r\n    getExtraData() {\r\n        return this._extra;\r\n    }\r\n    isFloating() {\r\n        return this._getAttr(\"floating\");\r\n    }\r\n    getIcon() {\r\n        return this._getAttr(\"icon\");\r\n    }\r\n    isEnableClose() {\r\n        return this._getAttr(\"enableClose\");\r\n    }\r\n    getCloseType() {\r\n        return this._getAttr(\"closeType\");\r\n    }\r\n    isEnableFloat() {\r\n        return this._getAttr(\"enableFloat\");\r\n    }\r\n    isEnableDrag() {\r\n        return this._getAttr(\"enableDrag\");\r\n    }\r\n    isEnableRename() {\r\n        return this._getAttr(\"enableRename\");\r\n    }\r\n    getClassName() {\r\n        return this._getAttr(\"className\");\r\n    }\r\n    isEnableRenderOnDemand() {\r\n        return this._getAttr(\"enableRenderOnDemand\");\r\n    }\r\n    /** @internal */\r\n    _setName(name) {\r\n        this._attributes.name = name;\r\n        if (this._window && this._window.document) {\r\n            this._window.document.title = name;\r\n        }\r\n    }\r\n    /** @internal */\r\n    _setFloating(float) {\r\n        this._attributes.floating = float;\r\n    }\r\n    /** @internal */\r\n    _layout(rect, metrics) {\r\n        if (!rect.equals(this._rect)) {\r\n            this._fireEvent(\"resize\", { rect });\r\n        }\r\n        this._rect = rect;\r\n    }\r\n    /** @internal */\r\n    _delete() {\r\n        this._parent._remove(this);\r\n        this._fireEvent(\"close\", {});\r\n    }\r\n    toJson() {\r\n        const json = {};\r\n        TabNode._attributeDefinitions.toJson(json, this._attributes);\r\n        return json;\r\n    }\r\n    /** @internal */\r\n    _updateAttrs(json) {\r\n        TabNode._attributeDefinitions.update(json, this._attributes);\r\n    }\r\n    /** @internal */\r\n    _getAttributeDefinitions() {\r\n        return TabNode._attributeDefinitions;\r\n    }\r\n    /** @internal */\r\n    _setWindow(window) {\r\n        this._window = window;\r\n    }\r\n    /** @internal */\r\n    _setBorderWidth(width) {\r\n        this._attributes.borderWidth = width;\r\n    }\r\n    /** @internal */\r\n    _setBorderHeight(height) {\r\n        this._attributes.borderHeight = height;\r\n    }\r\n    /** @internal */\r\n    static getAttributeDefinitions() {\r\n        return TabNode._attributeDefinitions;\r\n    }\r\n}\r\nTabNode.TYPE = \"tab\";\r\n/** @internal */\r\nTabNode._attributeDefinitions = TabNode._createAttributeDefinitions();\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/TabNode.ts?");

/***/ }),

/***/ "./src/model/TabSetNode.ts":
/*!*********************************!*\
  !*** ./src/model/TabSetNode.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"TabSetNode\": () => (/* binding */ TabSetNode)\n/* harmony export */ });\n/* harmony import */ var _Attribute__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Attribute */ \"./src/Attribute.ts\");\n/* harmony import */ var _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AttributeDefinitions */ \"./src/AttributeDefinitions.ts\");\n/* harmony import */ var _DockLocation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DockLocation */ \"./src/DockLocation.ts\");\n/* harmony import */ var _DropInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../DropInfo */ \"./src/DropInfo.ts\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Rect */ \"./src/Rect.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _BorderNode__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./BorderNode */ \"./src/model/BorderNode.ts\");\n/* harmony import */ var _Node__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Node */ \"./src/model/Node.ts\");\n/* harmony import */ var _RowNode__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./RowNode */ \"./src/model/RowNode.ts\");\n/* harmony import */ var _TabNode__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./TabNode */ \"./src/model/TabNode.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Utils */ \"./src/model/Utils.ts\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nclass TabSetNode extends _Node__WEBPACK_IMPORTED_MODULE_8__.Node {\r\n    /** @internal */\r\n    constructor(model, json) {\r\n        super(model);\r\n        TabSetNode._attributeDefinitions.fromJson(json, this._attributes);\r\n        model._addNode(this);\r\n        this._calculatedTabBarHeight = 0;\r\n        this._calculatedHeaderBarHeight = 0;\r\n    }\r\n    /** @internal */\r\n    static _fromJson(json, model) {\r\n        const newLayoutNode = new TabSetNode(model, json);\r\n        if (json.children != null) {\r\n            for (const jsonChild of json.children) {\r\n                const child = _TabNode__WEBPACK_IMPORTED_MODULE_10__.TabNode._fromJson(jsonChild, model);\r\n                newLayoutNode._addChild(child);\r\n            }\r\n        }\r\n        if (newLayoutNode._children.length === 0) {\r\n            newLayoutNode._setSelected(-1);\r\n        }\r\n        if (json.maximized && json.maximized === true) {\r\n            model._setMaximizedTabset(newLayoutNode);\r\n        }\r\n        if (json.active && json.active === true) {\r\n            model._setActiveTabset(newLayoutNode);\r\n        }\r\n        return newLayoutNode;\r\n    }\r\n    /** @internal */\r\n    static _createAttributeDefinitions() {\r\n        const attributeDefinitions = new _AttributeDefinitions__WEBPACK_IMPORTED_MODULE_1__.AttributeDefinitions();\r\n        attributeDefinitions.add(\"type\", TabSetNode.TYPE, true).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING).setFixed();\r\n        attributeDefinitions.add(\"id\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"weight\", 100).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"width\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"height\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"selected\", 0).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.NUMBER);\r\n        attributeDefinitions.add(\"name\", undefined).setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.STRING);\r\n        attributeDefinitions.add(\"config\", undefined).setType(\"any\");\r\n        attributeDefinitions.addInherited(\"enableDeleteWhenEmpty\", \"tabSetEnableDeleteWhenEmpty\");\r\n        attributeDefinitions.addInherited(\"enableDrop\", \"tabSetEnableDrop\");\r\n        attributeDefinitions.addInherited(\"enableDrag\", \"tabSetEnableDrag\");\r\n        attributeDefinitions.addInherited(\"enableDivide\", \"tabSetEnableDivide\");\r\n        attributeDefinitions.addInherited(\"enableMaximize\", \"tabSetEnableMaximize\");\r\n        attributeDefinitions.addInherited(\"enableClose\", \"tabSetEnableClose\");\r\n        attributeDefinitions.addInherited(\"classNameTabStrip\", \"tabSetClassNameTabStrip\");\r\n        attributeDefinitions.addInherited(\"classNameHeader\", \"tabSetClassNameHeader\");\r\n        attributeDefinitions.addInherited(\"enableTabStrip\", \"tabSetEnableTabStrip\");\r\n        attributeDefinitions.addInherited(\"borderInsets\", \"tabSetBorderInsets\");\r\n        attributeDefinitions.addInherited(\"marginInsets\", \"tabSetMarginInsets\");\r\n        attributeDefinitions.addInherited(\"minWidth\", \"tabSetMinWidth\");\r\n        attributeDefinitions.addInherited(\"minHeight\", \"tabSetMinHeight\");\r\n        attributeDefinitions.addInherited(\"headerHeight\", \"tabSetHeaderHeight\");\r\n        attributeDefinitions.addInherited(\"tabStripHeight\", \"tabSetTabStripHeight\");\r\n        attributeDefinitions.addInherited(\"tabLocation\", \"tabSetTabLocation\");\r\n        attributeDefinitions.addInherited(\"autoSelectTab\", \"tabSetAutoSelectTab\").setType(_Attribute__WEBPACK_IMPORTED_MODULE_0__.Attribute.BOOLEAN);\r\n        return attributeDefinitions;\r\n    }\r\n    getName() {\r\n        return this._getAttr(\"name\");\r\n    }\r\n    getSelected() {\r\n        const selected = this._attributes.selected;\r\n        if (selected !== undefined) {\r\n            return selected;\r\n        }\r\n        return -1;\r\n    }\r\n    getSelectedNode() {\r\n        const selected = this.getSelected();\r\n        if (selected !== -1) {\r\n            return this._children[selected];\r\n        }\r\n        return undefined;\r\n    }\r\n    getWeight() {\r\n        return this._getAttr(\"weight\");\r\n    }\r\n    getWidth() {\r\n        return this._getAttr(\"width\");\r\n    }\r\n    getMinWidth() {\r\n        return this._getAttr(\"minWidth\");\r\n    }\r\n    getHeight() {\r\n        return this._getAttr(\"height\");\r\n    }\r\n    getMinHeight() {\r\n        return this._getAttr(\"minHeight\");\r\n    }\r\n    /** @internal */\r\n    getMinSize(orientation) {\r\n        if (orientation === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ) {\r\n            return this.getMinWidth();\r\n        }\r\n        else {\r\n            return this.getMinHeight();\r\n        }\r\n    }\r\n    /**\r\n     * Returns the config attribute that can be used to store node specific data that\r\n     * WILL be saved to the json. The config attribute should be changed via the action Actions.updateNodeAttributes rather\r\n     * than directly, for example:\r\n     * this.state.model.doAction(\r\n     *   FlexLayout.Actions.updateNodeAttributes(node.getId(), {config:myConfigObject}));\r\n     */\r\n    getConfig() {\r\n        return this._attributes.config;\r\n    }\r\n    isMaximized() {\r\n        return this._model.getMaximizedTabset() === this;\r\n    }\r\n    isActive() {\r\n        return this._model.getActiveTabset() === this;\r\n    }\r\n    isEnableDeleteWhenEmpty() {\r\n        return this._getAttr(\"enableDeleteWhenEmpty\");\r\n    }\r\n    isEnableDrop() {\r\n        return this._getAttr(\"enableDrop\");\r\n    }\r\n    isEnableDrag() {\r\n        return this._getAttr(\"enableDrag\");\r\n    }\r\n    isEnableDivide() {\r\n        return this._getAttr(\"enableDivide\");\r\n    }\r\n    isEnableMaximize() {\r\n        return this._getAttr(\"enableMaximize\");\r\n    }\r\n    isEnableClose() {\r\n        return this._getAttr(\"enableClose\");\r\n    }\r\n    canMaximize() {\r\n        if (this.isEnableMaximize()) {\r\n            // always allow maximize toggle if already maximized\r\n            if (this.getModel().getMaximizedTabset() === this) {\r\n                return true;\r\n            }\r\n            // only one tabset, so disable\r\n            if (this.getParent() === this.getModel().getRoot() && this.getModel().getRoot().getChildren().length === 1) {\r\n                return false;\r\n            }\r\n            return true;\r\n        }\r\n        return false;\r\n    }\r\n    isEnableTabStrip() {\r\n        return this._getAttr(\"enableTabStrip\");\r\n    }\r\n    isAutoSelectTab() {\r\n        return this._getAttr(\"autoSelectTab\");\r\n    }\r\n    getClassNameTabStrip() {\r\n        return this._getAttr(\"classNameTabStrip\");\r\n    }\r\n    getClassNameHeader() {\r\n        return this._getAttr(\"classNameHeader\");\r\n    }\r\n    /** @internal */\r\n    calculateHeaderBarHeight(metrics) {\r\n        const headerBarHeight = this._getAttr(\"headerHeight\");\r\n        if (headerBarHeight !== 0) {\r\n            // its defined\r\n            this._calculatedHeaderBarHeight = headerBarHeight;\r\n        }\r\n        else {\r\n            this._calculatedHeaderBarHeight = metrics.headerBarSize;\r\n        }\r\n    }\r\n    /** @internal */\r\n    calculateTabBarHeight(metrics) {\r\n        const tabBarHeight = this._getAttr(\"tabStripHeight\");\r\n        if (tabBarHeight !== 0) {\r\n            // its defined\r\n            this._calculatedTabBarHeight = tabBarHeight;\r\n        }\r\n        else {\r\n            this._calculatedTabBarHeight = metrics.tabBarSize;\r\n        }\r\n    }\r\n    getHeaderHeight() {\r\n        return this._calculatedHeaderBarHeight;\r\n    }\r\n    getTabStripHeight() {\r\n        return this._calculatedTabBarHeight;\r\n    }\r\n    getTabLocation() {\r\n        return this._getAttr(\"tabLocation\");\r\n    }\r\n    /** @internal */\r\n    _setWeight(weight) {\r\n        this._attributes.weight = weight;\r\n    }\r\n    /** @internal */\r\n    _setSelected(index) {\r\n        this._attributes.selected = index;\r\n    }\r\n    /** @internal */\r\n    canDrop(dragNode, x, y) {\r\n        let dropInfo;\r\n        if (dragNode === this) {\r\n            const dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER;\r\n            const outlineRect = this._tabHeaderRect;\r\n            dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, -1, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n        }\r\n        else if (this._contentRect.contains(x, y)) {\r\n            let dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER;\r\n            if (this._model.getMaximizedTabset() === undefined) {\r\n                dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.getLocation(this._contentRect, x, y);\r\n            }\r\n            const outlineRect = dockLocation.getDockRect(this._rect);\r\n            dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, -1, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n        }\r\n        else if (this._tabHeaderRect != null && this._tabHeaderRect.contains(x, y)) {\r\n            let r;\r\n            let yy;\r\n            let h;\r\n            if (this._children.length === 0) {\r\n                r = this._tabHeaderRect.clone();\r\n                yy = r.y + 3;\r\n                h = r.height - 4;\r\n                r.width = 2;\r\n            }\r\n            else {\r\n                let child = this._children[0];\r\n                r = child.getTabRect();\r\n                yy = r.y;\r\n                h = r.height;\r\n                let p = this._tabHeaderRect.x;\r\n                let childCenter = 0;\r\n                for (let i = 0; i < this._children.length; i++) {\r\n                    child = this._children[i];\r\n                    r = child.getTabRect();\r\n                    childCenter = r.x + r.width / 2;\r\n                    if (x >= p && x < childCenter) {\r\n                        const dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER;\r\n                        const outlineRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(r.x - 2, yy, 3, h);\r\n                        dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, i, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n                        break;\r\n                    }\r\n                    p = childCenter;\r\n                }\r\n            }\r\n            if (dropInfo == null) {\r\n                const dockLocation = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER;\r\n                const outlineRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(r.getRight() - 2, yy, 3, h);\r\n                dropInfo = new _DropInfo__WEBPACK_IMPORTED_MODULE_3__.DropInfo(this, outlineRect, dockLocation, this._children.length, _Types__WEBPACK_IMPORTED_MODULE_6__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n            }\r\n        }\r\n        if (!dragNode._canDockInto(dragNode, dropInfo)) {\r\n            return undefined;\r\n        }\r\n        return dropInfo;\r\n    }\r\n    /** @internal */\r\n    _layout(rect, metrics) {\r\n        this.calculateHeaderBarHeight(metrics);\r\n        this.calculateTabBarHeight(metrics);\r\n        if (this.isMaximized()) {\r\n            rect = this._model.getRoot().getRect();\r\n        }\r\n        rect = rect.removeInsets(this._getAttr(\"marginInsets\"));\r\n        this._rect = rect;\r\n        rect = rect.removeInsets(this._getAttr(\"borderInsets\"));\r\n        const showHeader = this.getName() !== undefined;\r\n        let y = 0;\r\n        let h = 0;\r\n        if (showHeader) {\r\n            y += this._calculatedHeaderBarHeight;\r\n            h += this._calculatedHeaderBarHeight;\r\n        }\r\n        if (this.isEnableTabStrip()) {\r\n            if (this.getTabLocation() === \"top\") {\r\n                this._tabHeaderRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(rect.x, rect.y + y, rect.width, this._calculatedTabBarHeight);\r\n            }\r\n            else {\r\n                this._tabHeaderRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(rect.x, rect.y + rect.height - this._calculatedTabBarHeight, rect.width, this._calculatedTabBarHeight);\r\n            }\r\n            h += this._calculatedTabBarHeight;\r\n            if (this.getTabLocation() === \"top\") {\r\n                y += this._calculatedTabBarHeight;\r\n            }\r\n        }\r\n        this._contentRect = new _Rect__WEBPACK_IMPORTED_MODULE_5__.Rect(rect.x, rect.y + y, rect.width, rect.height - h);\r\n        for (let i = 0; i < this._children.length; i++) {\r\n            const child = this._children[i];\r\n            child._layout(this._contentRect, metrics);\r\n            child._setVisible(i === this.getSelected());\r\n        }\r\n    }\r\n    /** @internal */\r\n    _delete() {\r\n        this._parent._removeChild(this);\r\n    }\r\n    /** @internal */\r\n    _remove(node) {\r\n        const removedIndex = this._removeChild(node);\r\n        this._model._tidy();\r\n        (0,_Utils__WEBPACK_IMPORTED_MODULE_11__.adjustSelectedIndex)(this, removedIndex);\r\n    }\r\n    /** @internal */\r\n    drop(dragNode, location, index, select) {\r\n        const dockLocation = location;\r\n        if (this === dragNode) {\r\n            // tabset drop into itself\r\n            return; // dock back to itself\r\n        }\r\n        let dragParent = dragNode.getParent();\r\n        let fromIndex = 0;\r\n        if (dragParent !== undefined) {\r\n            fromIndex = dragParent._removeChild(dragNode);\r\n            // if selected node in border is being docked into tabset then deselect border tabs\r\n            if (dragParent instanceof _BorderNode__WEBPACK_IMPORTED_MODULE_7__.BorderNode && dragParent.getSelected() === fromIndex) {\r\n                dragParent._setSelected(-1);\r\n            }\r\n            else {\r\n                (0,_Utils__WEBPACK_IMPORTED_MODULE_11__.adjustSelectedIndex)(dragParent, fromIndex);\r\n            }\r\n        }\r\n        // if dropping a tab back to same tabset and moving to forward position then reduce insertion index\r\n        if (dragNode.getType() === _TabNode__WEBPACK_IMPORTED_MODULE_10__.TabNode.TYPE && dragParent === this && fromIndex < index && index > 0) {\r\n            index--;\r\n        }\r\n        // simple_bundled dock to existing tabset\r\n        if (dockLocation === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER) {\r\n            let insertPos = index;\r\n            if (insertPos === -1) {\r\n                insertPos = this._children.length;\r\n            }\r\n            if (dragNode.getType() === _TabNode__WEBPACK_IMPORTED_MODULE_10__.TabNode.TYPE) {\r\n                this._addChild(dragNode, insertPos);\r\n                if (select || (select !== false && this.isAutoSelectTab())) {\r\n                    this._setSelected(insertPos);\r\n                }\r\n                // console.log(\"added child at : \" + insertPos);\r\n            }\r\n            else {\r\n                for (let i = 0; i < dragNode.getChildren().length; i++) {\r\n                    const child = dragNode.getChildren()[i];\r\n                    this._addChild(child, insertPos);\r\n                    // console.log(\"added child at : \" + insertPos);\r\n                    insertPos++;\r\n                }\r\n                if (this.getSelected() === -1 && this._children.length > 0) {\r\n                    this._setSelected(0);\r\n                }\r\n            }\r\n            this._model._setActiveTabset(this);\r\n        }\r\n        else {\r\n            let tabSet;\r\n            if (dragNode instanceof _TabNode__WEBPACK_IMPORTED_MODULE_10__.TabNode) {\r\n                // create new tabset parent\r\n                // console.log(\"create a new tabset\");\r\n                const callback = this._model._getOnCreateTabSet();\r\n                tabSet = new TabSetNode(this._model, callback ? callback(dragNode) : {});\r\n                tabSet._addChild(dragNode);\r\n                // console.log(\"added child at end\");\r\n                dragParent = tabSet;\r\n            }\r\n            else {\r\n                tabSet = dragNode;\r\n            }\r\n            const parentRow = this._parent;\r\n            const pos = parentRow.getChildren().indexOf(this);\r\n            if (parentRow.getOrientation() === dockLocation._orientation) {\r\n                tabSet._setWeight(this.getWeight() / 2);\r\n                this._setWeight(this.getWeight() / 2);\r\n                // console.log(\"added child 50% size at: \" +  pos + dockLocation.indexPlus);\r\n                parentRow._addChild(tabSet, pos + dockLocation._indexPlus);\r\n            }\r\n            else {\r\n                // create a new row to host the new tabset (it will go in the opposite direction)\r\n                // console.log(\"create a new row\");\r\n                const newRow = new _RowNode__WEBPACK_IMPORTED_MODULE_9__.RowNode(this._model, {});\r\n                newRow._setWeight(this.getWeight());\r\n                newRow._addChild(this);\r\n                this._setWeight(50);\r\n                tabSet._setWeight(50);\r\n                // console.log(\"added child 50% size at: \" +  dockLocation.indexPlus);\r\n                newRow._addChild(tabSet, dockLocation._indexPlus);\r\n                parentRow._removeChild(this);\r\n                parentRow._addChild(newRow, pos);\r\n            }\r\n            this._model._setActiveTabset(tabSet);\r\n        }\r\n        this._model._tidy();\r\n    }\r\n    toJson() {\r\n        const json = {};\r\n        TabSetNode._attributeDefinitions.toJson(json, this._attributes);\r\n        json.children = this._children.map((child) => child.toJson());\r\n        if (this.isActive()) {\r\n            json.active = true;\r\n        }\r\n        if (this.isMaximized()) {\r\n            json.maximized = true;\r\n        }\r\n        return json;\r\n    }\r\n    /** @internal */\r\n    _updateAttrs(json) {\r\n        TabSetNode._attributeDefinitions.update(json, this._attributes);\r\n    }\r\n    /** @internal */\r\n    _getAttributeDefinitions() {\r\n        return TabSetNode._attributeDefinitions;\r\n    }\r\n    /** @internal */\r\n    _getPrefSize(orientation) {\r\n        let prefSize = this.getWidth();\r\n        if (orientation === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.VERT) {\r\n            prefSize = this.getHeight();\r\n        }\r\n        return prefSize;\r\n    }\r\n    /** @internal */\r\n    static getAttributeDefinitions() {\r\n        return TabSetNode._attributeDefinitions;\r\n    }\r\n}\r\nTabSetNode.TYPE = \"tabset\";\r\n/** @internal */\r\nTabSetNode._attributeDefinitions = TabSetNode._createAttributeDefinitions();\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/TabSetNode.ts?");

/***/ }),

/***/ "./src/model/Utils.ts":
/*!****************************!*\
  !*** ./src/model/Utils.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"adjustSelectedIndex\": () => (/* binding */ adjustSelectedIndex),\n/* harmony export */   \"adjustSelectedIndexAfterDock\": () => (/* binding */ adjustSelectedIndexAfterDock),\n/* harmony export */   \"adjustSelectedIndexAfterFloat\": () => (/* binding */ adjustSelectedIndexAfterFloat),\n/* harmony export */   \"randomUUID\": () => (/* binding */ randomUUID)\n/* harmony export */ });\n/* harmony import */ var _TabSetNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TabSetNode */ \"./src/model/TabSetNode.ts\");\n/* harmony import */ var _BorderNode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BorderNode */ \"./src/model/BorderNode.ts\");\n\r\n\r\n/** @internal */\r\nfunction adjustSelectedIndexAfterFloat(node) {\r\n    const parent = node.getParent();\r\n    if (parent !== null) {\r\n        if (parent instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_0__.TabSetNode) {\r\n            let found = false;\r\n            let newSelected = 0;\r\n            const children = parent.getChildren();\r\n            for (let i = 0; i < children.length; i++) {\r\n                const child = children[i];\r\n                if (child === node) {\r\n                    found = true;\r\n                }\r\n                else {\r\n                    if (!child.isFloating()) {\r\n                        newSelected = i;\r\n                        if (found)\r\n                            break;\r\n                    }\r\n                }\r\n            }\r\n            parent._setSelected(newSelected);\r\n        }\r\n        else if (parent instanceof _BorderNode__WEBPACK_IMPORTED_MODULE_1__.BorderNode) {\r\n            parent._setSelected(-1);\r\n        }\r\n    }\r\n}\r\n/** @internal */\r\nfunction adjustSelectedIndexAfterDock(node) {\r\n    const parent = node.getParent();\r\n    if (parent !== null && (parent instanceof _TabSetNode__WEBPACK_IMPORTED_MODULE_0__.TabSetNode || parent instanceof _BorderNode__WEBPACK_IMPORTED_MODULE_1__.BorderNode)) {\r\n        const children = parent.getChildren();\r\n        for (let i = 0; i < children.length; i++) {\r\n            const child = children[i];\r\n            if (child === node) {\r\n                parent._setSelected(i);\r\n                return;\r\n            }\r\n        }\r\n    }\r\n}\r\n/** @internal */\r\nfunction adjustSelectedIndex(parent, removedIndex) {\r\n    // for the tabset/border being removed from set the selected index\r\n    if (parent !== undefined && (parent.getType() === _TabSetNode__WEBPACK_IMPORTED_MODULE_0__.TabSetNode.TYPE || parent.getType() === _BorderNode__WEBPACK_IMPORTED_MODULE_1__.BorderNode.TYPE)) {\r\n        const selectedIndex = parent.getSelected();\r\n        if (selectedIndex !== -1) {\r\n            if (removedIndex === selectedIndex && parent.getChildren().length > 0) {\r\n                if (removedIndex >= parent.getChildren().length) {\r\n                    // removed last tab; select new last tab\r\n                    parent._setSelected(parent.getChildren().length - 1);\r\n                }\r\n                else {\r\n                    // leave selected index as is, selecting next tab after this one\r\n                }\r\n            }\r\n            else if (removedIndex < selectedIndex) {\r\n                parent._setSelected(selectedIndex - 1);\r\n            }\r\n            else if (removedIndex > selectedIndex) {\r\n                // leave selected index as is\r\n            }\r\n            else {\r\n                parent._setSelected(-1);\r\n            }\r\n        }\r\n    }\r\n}\r\nfunction randomUUID() {\r\n    // @ts-ignore\r\n    return ([1e7] + -1e3 + -4e3 + -8e3 + -1e11).replace(/[018]/g, c => (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16));\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/model/Utils.ts?");

/***/ }),

/***/ "./src/view/BorderButton.tsx":
/*!***********************************!*\
  !*** ./src/view/BorderButton.tsx ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BorderButton\": () => (/* binding */ BorderButton)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _I18nLabel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../I18nLabel */ \"./src/I18nLabel.ts\");\n/* harmony import */ var _model_Actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Rect */ \"./src/Rect.ts\");\n/* harmony import */ var _model_ICloseType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model/ICloseType */ \"./src/model/ICloseType.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Utils */ \"./src/view/Utils.tsx\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/** @internal */\r\nconst BorderButton = (props) => {\r\n    const { layout, node, selected, border, iconFactory, titleFactory, icons, path } = props;\r\n    const selfRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const contentRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const onMouseDown = (event) => {\r\n        if (!(0,_Utils__WEBPACK_IMPORTED_MODULE_6__.isAuxMouseEvent)(event) && !layout.getEditingTab()) {\r\n            layout.dragStart(event, undefined, node, node.isEnableDrag(), onClick, onDoubleClick);\r\n        }\r\n    };\r\n    const onAuxMouseClick = (event) => {\r\n        if ((0,_Utils__WEBPACK_IMPORTED_MODULE_6__.isAuxMouseEvent)(event)) {\r\n            layout.auxMouseClick(node, event);\r\n        }\r\n    };\r\n    const onContextMenu = (event) => {\r\n        layout.showContextMenu(node, event);\r\n    };\r\n    const onClick = () => {\r\n        layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.selectTab(node.getId()));\r\n    };\r\n    const onDoubleClick = (event) => {\r\n        // if (node.isEnableRename()) {\r\n        //     onRename();\r\n        // }\r\n    };\r\n    // const onRename = () => {\r\n    //     layout.setEditingTab(node);\r\n    //     layout.getCurrentDocument()!.body.addEventListener(\"mousedown\", onEndEdit);\r\n    //     layout.getCurrentDocument()!.body.addEventListener(\"touchstart\", onEndEdit);\r\n    // };\r\n    const onEndEdit = (event) => {\r\n        if (event.target !== contentRef.current) {\r\n            layout.getCurrentDocument().body.removeEventListener(\"mousedown\", onEndEdit);\r\n            layout.getCurrentDocument().body.removeEventListener(\"touchstart\", onEndEdit);\r\n            layout.setEditingTab(undefined);\r\n        }\r\n    };\r\n    const isClosable = () => {\r\n        const closeType = node.getCloseType();\r\n        if (selected || closeType === _model_ICloseType__WEBPACK_IMPORTED_MODULE_4__.ICloseType.Always) {\r\n            return true;\r\n        }\r\n        if (closeType === _model_ICloseType__WEBPACK_IMPORTED_MODULE_4__.ICloseType.Visible) {\r\n            // not selected but x should be visible due to hover\r\n            if (window.matchMedia && window.matchMedia(\"(hover: hover) and (pointer: fine)\").matches) {\r\n                return true;\r\n            }\r\n        }\r\n        return false;\r\n    };\r\n    const onClose = (event) => {\r\n        if (isClosable()) {\r\n            layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.deleteTab(node.getId()));\r\n        }\r\n        else {\r\n            onClick();\r\n        }\r\n    };\r\n    const onCloseMouseDown = (event) => {\r\n        event.stopPropagation();\r\n    };\r\n    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {\r\n        updateRect();\r\n        if (layout.getEditingTab() === node) {\r\n            contentRef.current.select();\r\n        }\r\n    });\r\n    const updateRect = () => {\r\n        // record position of tab in node\r\n        const layoutRect = layout.getDomRect();\r\n        const r = selfRef.current.getBoundingClientRect();\r\n        node._setTabRect(new _Rect__WEBPACK_IMPORTED_MODULE_3__.Rect(r.left - layoutRect.left, r.top - layoutRect.top, r.width, r.height));\r\n    };\r\n    const onTextBoxMouseDown = (event) => {\r\n        // console.log(\"onTextBoxMouseDown\");\r\n        event.stopPropagation();\r\n    };\r\n    const onTextBoxKeyPress = (event) => {\r\n        // console.log(event, event.keyCode);\r\n        if (event.keyCode === 27) {\r\n            // esc\r\n            layout.setEditingTab(undefined);\r\n        }\r\n        else if (event.keyCode === 13) {\r\n            // enter\r\n            layout.setEditingTab(undefined);\r\n            layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.renameTab(node.getId(), event.target.value));\r\n        }\r\n    };\r\n    const cm = layout.getClassName;\r\n    let classNames = cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__BORDER_BUTTON) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__BORDER_BUTTON_ + border);\r\n    if (selected) {\r\n        classNames += \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__BORDER_BUTTON__SELECTED);\r\n    }\r\n    else {\r\n        classNames += \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__BORDER_BUTTON__UNSELECTED);\r\n    }\r\n    if (node.getClassName() !== undefined) {\r\n        classNames += \" \" + node.getClassName();\r\n    }\r\n    const renderState = (0,_Utils__WEBPACK_IMPORTED_MODULE_6__.getRenderStateEx)(layout, node, iconFactory, titleFactory);\r\n    let content = renderState.content ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__BORDER_BUTTON_CONTENT) }, renderState.content)) : null;\r\n    const leading = renderState.leading ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__BORDER_BUTTON_LEADING) }, renderState.leading)) : null;\r\n    if (layout.getEditingTab() === node) {\r\n        content = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"input\", { ref: contentRef, className: cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__TAB_BUTTON_TEXTBOX), \"data-layout-path\": path + \"/textbox\", type: \"text\", autoFocus: true, defaultValue: node.getName(), onKeyDown: onTextBoxKeyPress, onMouseDown: onTextBoxMouseDown, onTouchStart: onTextBoxMouseDown }));\r\n    }\r\n    if (node.isEnableClose()) {\r\n        const closeTitle = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_1__.I18nLabel.Close_Tab);\r\n        renderState.buttons.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"close\", \"data-layout-path\": path + \"/button/close\", title: closeTitle, className: cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__BORDER_BUTTON_TRAILING), onMouseDown: onCloseMouseDown, onClick: onClose, onTouchStart: onCloseMouseDown }, (typeof icons.close === \"function\") ? icons.close(node) : icons.close));\r\n    }\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { ref: selfRef, \"data-layout-path\": path, className: classNames, onMouseDown: onMouseDown, onClick: onAuxMouseClick, onAuxClick: onAuxMouseClick, onContextMenu: onContextMenu, onTouchStart: onMouseDown, title: node.getHelpText() },\r\n        leading,\r\n        content,\r\n        renderState.buttons));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/BorderButton.tsx?");

/***/ }),

/***/ "./src/view/BorderTabSet.tsx":
/*!***********************************!*\
  !*** ./src/view/BorderTabSet.tsx ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BorderTabSet\": () => (/* binding */ BorderTabSet)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _DockLocation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../DockLocation */ \"./src/DockLocation.ts\");\n/* harmony import */ var _BorderButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BorderButton */ \"./src/view/BorderButton.tsx\");\n/* harmony import */ var _PopupMenu__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../PopupMenu */ \"./src/PopupMenu.tsx\");\n/* harmony import */ var _model_Actions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model/Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _I18nLabel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../I18nLabel */ \"./src/I18nLabel.ts\");\n/* harmony import */ var _TabOverflowHook__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./TabOverflowHook */ \"./src/view/TabOverflowHook.tsx\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Utils */ \"./src/view/Utils.tsx\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/** @internal */\r\nconst BorderTabSet = (props) => {\r\n    const { border, layout, iconFactory, titleFactory, icons, path } = props;\r\n    const toolbarRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const overflowbuttonRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const stickyButtonsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const { selfRef, position, userControlledLeft, hiddenTabs, onMouseWheel } = (0,_TabOverflowHook__WEBPACK_IMPORTED_MODULE_6__.useTabOverflow)(border, _Orientation__WEBPACK_IMPORTED_MODULE_7__.Orientation.flip(border.getOrientation()), toolbarRef, stickyButtonsRef);\r\n    const onAuxMouseClick = (event) => {\r\n        if ((0,_Utils__WEBPACK_IMPORTED_MODULE_9__.isAuxMouseEvent)(event)) {\r\n            layout.auxMouseClick(border, event);\r\n        }\r\n    };\r\n    const onContextMenu = (event) => {\r\n        layout.showContextMenu(border, event);\r\n    };\r\n    const onInterceptMouseDown = (event) => {\r\n        event.stopPropagation();\r\n    };\r\n    const onOverflowClick = (event) => {\r\n        const callback = layout.getShowOverflowMenu();\r\n        if (callback !== undefined) {\r\n            callback(border, event, hiddenTabs, onOverflowItemSelect);\r\n        }\r\n        else {\r\n            const element = overflowbuttonRef.current;\r\n            (0,_PopupMenu__WEBPACK_IMPORTED_MODULE_3__.showPopup)(element, hiddenTabs, onOverflowItemSelect, layout, iconFactory, titleFactory);\r\n        }\r\n        event.stopPropagation();\r\n    };\r\n    const onOverflowItemSelect = (item) => {\r\n        layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_4__.Actions.selectTab(item.node.getId()));\r\n        userControlledLeft.current = false;\r\n    };\r\n    const onFloatTab = (event) => {\r\n        const selectedTabNode = border.getChildren()[border.getSelected()];\r\n        if (selectedTabNode !== undefined) {\r\n            layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_4__.Actions.floatTab(selectedTabNode.getId()));\r\n        }\r\n        event.stopPropagation();\r\n    };\r\n    const cm = layout.getClassName;\r\n    let style = border.getTabHeaderRect().styleWithPosition({});\r\n    const tabs = [];\r\n    const layoutTab = (i) => {\r\n        let isSelected = border.getSelected() === i;\r\n        let child = border.getChildren()[i];\r\n        tabs.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BorderButton__WEBPACK_IMPORTED_MODULE_2__.BorderButton, { layout: layout, border: border.getLocation().getName(), node: child, path: path + \"/tb\" + i, key: child.getId(), selected: isSelected, iconFactory: iconFactory, titleFactory: titleFactory, icons: icons }));\r\n        if (i < border.getChildren().length - 1) {\r\n            tabs.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"divider\" + i, className: cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_TAB_DIVIDER) }));\r\n        }\r\n    };\r\n    for (let i = 0; i < border.getChildren().length; i++) {\r\n        layoutTab(i);\r\n    }\r\n    let borderClasses = cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_ + border.getLocation().getName());\r\n    if (border.getClassName() !== undefined) {\r\n        borderClasses += \" \" + border.getClassName();\r\n    }\r\n    // allow customization of tabset right/bottom buttons\r\n    let buttons = [];\r\n    const renderState = { headerContent: undefined, buttons, stickyButtons: [], headerButtons: [] };\r\n    layout.customizeTabSet(border, renderState);\r\n    buttons = renderState.buttons;\r\n    let toolbar;\r\n    if (hiddenTabs.length > 0) {\r\n        const overflowTitle = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_5__.I18nLabel.Overflow_Menu_Tooltip);\r\n        let overflowContent;\r\n        if (typeof icons.more === \"function\") {\r\n            overflowContent = icons.more(border, hiddenTabs);\r\n        }\r\n        else {\r\n            overflowContent = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,\r\n                icons.more,\r\n                react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__TAB_BUTTON_OVERFLOW_COUNT) }, hiddenTabs.length)));\r\n        }\r\n        buttons.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"button\", { key: \"overflowbutton\", ref: overflowbuttonRef, className: cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR_BUTTON) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR_BUTTON_OVERFLOW) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR_BUTTON_OVERFLOW_ + border.getLocation().getName()), title: overflowTitle, onClick: onOverflowClick, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, overflowContent));\r\n    }\r\n    const selectedIndex = border.getSelected();\r\n    if (selectedIndex !== -1) {\r\n        const selectedTabNode = border.getChildren()[selectedIndex];\r\n        if (selectedTabNode !== undefined && layout.isSupportsPopout() && selectedTabNode.isEnableFloat() && !selectedTabNode.isFloating()) {\r\n            const floatTitle = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_5__.I18nLabel.Float_Tab);\r\n            buttons.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"button\", { key: \"float\", title: floatTitle, className: cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR_BUTTON) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR_BUTTON_FLOAT), onClick: onFloatTab, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, (typeof icons.popout === \"function\") ? icons.popout(selectedTabNode) : icons.popout));\r\n        }\r\n    }\r\n    toolbar = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"toolbar\", ref: toolbarRef, className: cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR_ + border.getLocation().getName()) }, buttons));\r\n    style = layout.styleFont(style);\r\n    let innerStyle = {};\r\n    const borderHeight = border.getBorderBarSize() - 1;\r\n    if (border.getLocation() === _DockLocation__WEBPACK_IMPORTED_MODULE_1__.DockLocation.LEFT) {\r\n        innerStyle = { right: borderHeight, height: borderHeight, top: position };\r\n    }\r\n    else if (border.getLocation() === _DockLocation__WEBPACK_IMPORTED_MODULE_1__.DockLocation.RIGHT) {\r\n        innerStyle = { left: borderHeight, height: borderHeight, top: position };\r\n    }\r\n    else {\r\n        innerStyle = { height: borderHeight, left: position };\r\n    }\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { ref: selfRef, dir: \"ltr\", style: style, className: borderClasses, \"data-layout-path\": path, onClick: onAuxMouseClick, onAuxClick: onAuxMouseClick, onContextMenu: onContextMenu, onWheel: onMouseWheel },\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { style: { height: borderHeight }, className: cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_INNER) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_INNER_ + border.getLocation().getName()) },\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { style: innerStyle, className: cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_INNER_TAB_CONTAINER) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_8__.CLASSES.FLEXLAYOUT__BORDER_INNER_TAB_CONTAINER_ + border.getLocation().getName()) }, tabs)),\r\n        toolbar));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/BorderTabSet.tsx?");

/***/ }),

/***/ "./src/view/ErrorBoundary.tsx":
/*!************************************!*\
  !*** ./src/view/ErrorBoundary.tsx ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ErrorBoundary\": () => (/* binding */ ErrorBoundary)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n\r\n\r\n/** @internal */\r\nclass ErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {\r\n    constructor(props) {\r\n        super(props);\r\n        this.state = { hasError: false };\r\n    }\r\n    static getDerivedStateFromError(error) {\r\n        return { hasError: true };\r\n    }\r\n    componentDidCatch(error, errorInfo) {\r\n        console.debug(error);\r\n        console.debug(errorInfo);\r\n    }\r\n    render() {\r\n        if (this.state.hasError) {\r\n            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: _Types__WEBPACK_IMPORTED_MODULE_1__.CLASSES.FLEXLAYOUT__ERROR_BOUNDARY_CONTAINER },\r\n                react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: _Types__WEBPACK_IMPORTED_MODULE_1__.CLASSES.FLEXLAYOUT__ERROR_BOUNDARY_CONTENT }, this.props.message)));\r\n        }\r\n        return this.props.children;\r\n    }\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/ErrorBoundary.tsx?");

/***/ }),

/***/ "./src/view/FloatingWindow.tsx":
/*!*************************************!*\
  !*** ./src/view/FloatingWindow.tsx ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FloatingWindow\": () => (/* binding */ FloatingWindow)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ \"react-dom\");\n/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n\r\n\r\n\r\n/** @internal */\r\nconst FloatingWindow = (props) => {\r\n    const { title, id, url, rect, onCloseWindow, onSetWindow, children } = props;\r\n    const popoutWindow = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const timerId = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const [content, setContent] = react__WEBPACK_IMPORTED_MODULE_0__.useState(undefined);\r\n    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {\r\n        if (timerId.current) {\r\n            clearTimeout(timerId.current);\r\n        }\r\n        const r = rect;\r\n        // Make a local copy of the styles from the current window which will be passed into\r\n        // the floating window. window.document.styleSheets is mutable and we can't guarantee\r\n        // the styles will exist when 'popoutWindow.load' is called below.\r\n        const styles = Array.from(window.document.styleSheets).reduce((result, styleSheet) => {\r\n            let rules = undefined;\r\n            try {\r\n                rules = styleSheet.cssRules;\r\n            }\r\n            catch (e) {\r\n                // styleSheet.cssRules can throw security exception\r\n            }\r\n            try {\r\n                return [\r\n                    ...result,\r\n                    {\r\n                        href: styleSheet.href,\r\n                        type: styleSheet.type,\r\n                        rules: rules ? Array.from(rules).map(rule => rule.cssText) : null,\r\n                    }\r\n                ];\r\n            }\r\n            catch (e) {\r\n                return result;\r\n            }\r\n        }, []);\r\n        popoutWindow.current = window.open(url, id, `left=${r.x},top=${r.y},width=${r.width},height=${r.height}`);\r\n        if (popoutWindow.current !== null) {\r\n            onSetWindow(id, popoutWindow.current);\r\n            // listen for parent unloading to remove all popouts\r\n            window.addEventListener(\"beforeunload\", () => {\r\n                if (popoutWindow.current) {\r\n                    popoutWindow.current.close();\r\n                    popoutWindow.current = null;\r\n                }\r\n            });\r\n            popoutWindow.current.addEventListener(\"load\", () => {\r\n                const popoutDocument = popoutWindow.current.document;\r\n                popoutDocument.title = title;\r\n                const popoutContent = popoutDocument.createElement(\"div\");\r\n                popoutContent.className = _Types__WEBPACK_IMPORTED_MODULE_2__.CLASSES.FLEXLAYOUT__FLOATING_WINDOW_CONTENT;\r\n                popoutDocument.body.appendChild(popoutContent);\r\n                copyStyles(popoutDocument, styles).then(() => {\r\n                    setContent(popoutContent);\r\n                });\r\n                // listen for popout unloading (needs to be after load for safari)\r\n                popoutWindow.current.addEventListener(\"beforeunload\", () => {\r\n                    onCloseWindow(id);\r\n                });\r\n            });\r\n        }\r\n        else {\r\n            console.warn(`Unable to open window ${url}`);\r\n            onCloseWindow(id);\r\n        }\r\n        return () => {\r\n            // delay so refresh will close window\r\n            timerId.current = setTimeout(() => {\r\n                if (popoutWindow.current) {\r\n                    popoutWindow.current.close();\r\n                    popoutWindow.current = null;\r\n                }\r\n            }, 0);\r\n        };\r\n    }, []);\r\n    if (content !== undefined) {\r\n        return (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(children, content);\r\n    }\r\n    else {\r\n        return null;\r\n    }\r\n};\r\n/** @internal */\r\nfunction copyStyles(doc, styleSheets) {\r\n    const head = doc.head;\r\n    const promises = [];\r\n    for (const styleSheet of styleSheets) {\r\n        if (styleSheet.href) {\r\n            // prefer links since they will keep paths to images etc\r\n            const styleElement = doc.createElement(\"link\");\r\n            styleElement.type = styleSheet.type;\r\n            styleElement.rel = \"stylesheet\";\r\n            styleElement.href = styleSheet.href;\r\n            head.appendChild(styleElement);\r\n            promises.push(new Promise((resolve, reject) => {\r\n                styleElement.onload = () => resolve(true);\r\n            }));\r\n        }\r\n        else {\r\n            if (styleSheet.rules) {\r\n                const style = doc.createElement(\"style\");\r\n                for (const rule of styleSheet.rules) {\r\n                    style.appendChild(doc.createTextNode(rule));\r\n                }\r\n                head.appendChild(style);\r\n            }\r\n        }\r\n    }\r\n    return Promise.all(promises);\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/FloatingWindow.tsx?");

/***/ }),

/***/ "./src/view/FloatingWindowTab.tsx":
/*!****************************************!*\
  !*** ./src/view/FloatingWindowTab.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FloatingWindowTab\": () => (/* binding */ FloatingWindowTab)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _ErrorBoundary__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ErrorBoundary */ \"./src/view/ErrorBoundary.tsx\");\n/* harmony import */ var _I18nLabel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../I18nLabel */ \"./src/I18nLabel.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n\r\n\r\n\r\n\r\n\r\n/** @internal */\r\nconst FloatingWindowTab = (props) => {\r\n    const { layout, node, factory } = props;\r\n    const cm = layout.getClassName;\r\n    const child = factory(node);\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_3__.CLASSES.FLEXLAYOUT__FLOATING_WINDOW_TAB) },\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ErrorBoundary__WEBPACK_IMPORTED_MODULE_1__.ErrorBoundary, { message: props.layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_2__.I18nLabel.Error_rendering_component) },\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, child))));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/FloatingWindowTab.tsx?");

/***/ }),

/***/ "./src/view/Icons.tsx":
/*!****************************!*\
  !*** ./src/view/Icons.tsx ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"CloseIcon\": () => (/* binding */ CloseIcon),\n/* harmony export */   \"MaximizeIcon\": () => (/* binding */ MaximizeIcon),\n/* harmony export */   \"OverflowIcon\": () => (/* binding */ OverflowIcon),\n/* harmony export */   \"PopoutIcon\": () => (/* binding */ PopoutIcon),\n/* harmony export */   \"RestoreIcon\": () => (/* binding */ RestoreIcon)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n\r\nconst style = { width: \"1em\", height: \"1em\", display: \"flex\", alignItems: \"center\" };\r\nconst CloseIcon = () => {\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"svg\", { xmlns: \"http://www.w3.org/2000/svg\", style: style, viewBox: \"0 0 24 24\" },\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { fill: \"none\", d: \"M0 0h24v24H0z\" }),\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { stroke: \"var(--color-icon)\", fill: \"var(--color-icon)\", d: \"M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z\" })));\r\n};\r\nconst MaximizeIcon = () => {\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"svg\", { xmlns: \"http://www.w3.org/2000/svg\", style: style, viewBox: \"0 0 24 24\", fill: \"var(--color-icon)\" },\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { d: \"M0 0h24v24H0z\", fill: \"none\" }),\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { stroke: \"var(--color-icon)\", d: \"M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z\" })));\r\n};\r\nconst OverflowIcon = () => {\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"svg\", { xmlns: \"http://www.w3.org/2000/svg\", style: style, viewBox: \"0 0 24 24\", fill: \"var(--color-icon)\" },\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { d: \"M0 0h24v24H0z\", fill: \"none\" }),\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { stroke: \"var(--color-icon)\", d: \"M7 10l5 5 5-5z\" })));\r\n};\r\nconst PopoutIcon = () => {\r\n    return (\r\n    // <svg xmlns=\"http://www.w3.org/2000/svg\"  style={style}  viewBox=\"0 0 24 24\" fill=\"var(--color-icon)\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path stroke=\"var(--color-icon)\" d=\"M9 5v2h6.59L4 18.59 5.41 20 17 8.41V15h2V5z\"/></svg>\r\n    // <svg xmlns=\"http://www.w3.org/2000/svg\" style={style} fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"var(--color-icon)\" stroke-width=\"2\">\r\n    //     <path stroke-linecap=\"round\" stroke-linejoin=\"round\" d=\"M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14\" />\r\n    // </svg>\r\n    react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"svg\", { xmlns: \"http://www.w3.org/2000/svg\", style: style, viewBox: \"0 0 20 20\", fill: \"var(--color-icon)\" },\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { d: \"M11 3a1 1 0 100 2h2.586l-6.293 6.293a1 1 0 101.414 1.414L15 6.414V9a1 1 0 102 0V4a1 1 0 00-1-1h-5z\" }),\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { d: \"M5 5a2 2 0 00-2 2v8a2 2 0 002 2h8a2 2 0 002-2v-3a1 1 0 10-2 0v3H5V7h3a1 1 0 000-2H5z\" })));\r\n};\r\nconst RestoreIcon = () => {\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"svg\", { xmlns: \"http://www.w3.org/2000/svg\", style: style, viewBox: \"0 0 24 24\", fill: \"var(--color-icon)\" },\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { d: \"M0 0h24v24H0z\", fill: \"none\" }),\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"path\", { stroke: \"var(--color-icon)\", d: \"M5 16h3v3h2v-5H5v2zm3-8H5v2h5V5H8v3zm6 11h2v-3h3v-2h-5v5zm2-11V5h-2v5h5V8h-3z\" })));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/Icons.tsx?");

/***/ }),

/***/ "./src/view/Layout.tsx":
/*!*****************************!*\
  !*** ./src/view/Layout.tsx ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Layout\": () => (/* binding */ Layout)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ \"react-dom\");\n/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _DockLocation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DockLocation */ \"./src/DockLocation.ts\");\n/* harmony import */ var _DragDrop__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../DragDrop */ \"./src/DragDrop.ts\");\n/* harmony import */ var _model_Actions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model/Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _model_BorderNode__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../model/BorderNode */ \"./src/model/BorderNode.ts\");\n/* harmony import */ var _model_SplitterNode__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../model/SplitterNode */ \"./src/model/SplitterNode.ts\");\n/* harmony import */ var _model_TabNode__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../model/TabNode */ \"./src/model/TabNode.ts\");\n/* harmony import */ var _model_TabSetNode__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../model/TabSetNode */ \"./src/model/TabSetNode.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Rect */ \"./src/Rect.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _BorderTabSet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./BorderTabSet */ \"./src/view/BorderTabSet.tsx\");\n/* harmony import */ var _Splitter__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Splitter */ \"./src/view/Splitter.tsx\");\n/* harmony import */ var _Tab__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Tab */ \"./src/view/Tab.tsx\");\n/* harmony import */ var _TabSet__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./TabSet */ \"./src/view/TabSet.tsx\");\n/* harmony import */ var _FloatingWindow__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./FloatingWindow */ \"./src/view/FloatingWindow.tsx\");\n/* harmony import */ var _FloatingWindowTab__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./FloatingWindowTab */ \"./src/view/FloatingWindowTab.tsx\");\n/* harmony import */ var _TabFloating__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./TabFloating */ \"./src/view/TabFloating.tsx\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Icons__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Icons */ \"./src/view/Icons.tsx\");\n/* harmony import */ var _TabButtonStamp__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./TabButtonStamp */ \"./src/view/TabButtonStamp.tsx\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nconst defaultIcons = {\r\n    close: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icons__WEBPACK_IMPORTED_MODULE_19__.CloseIcon, null),\r\n    closeTabset: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icons__WEBPACK_IMPORTED_MODULE_19__.CloseIcon, null),\r\n    popout: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icons__WEBPACK_IMPORTED_MODULE_19__.PopoutIcon, null),\r\n    maximize: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icons__WEBPACK_IMPORTED_MODULE_19__.MaximizeIcon, null),\r\n    restore: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icons__WEBPACK_IMPORTED_MODULE_19__.RestoreIcon, null),\r\n    more: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icons__WEBPACK_IMPORTED_MODULE_19__.OverflowIcon, null),\r\n};\r\n// Popout windows work in latest browsers based on webkit (Chrome, Opera, Safari, latest Edge) and Firefox. They do\r\n// not work on any version if IE or the original Edge browser\r\n// Assume any recent desktop browser not IE or original Edge will work\r\n/** @internal */\r\n// @ts-ignore\r\nconst isIEorEdge = typeof window !== \"undefined\" && (window.document.documentMode || /Edge\\//.test(window.navigator.userAgent));\r\n/** @internal */\r\nconst isDesktop = typeof window !== \"undefined\" && window.matchMedia && window.matchMedia(\"(hover: hover) and (pointer: fine)\").matches;\r\n/** @internal */\r\nconst defaultSupportsPopout = isDesktop && !isIEorEdge;\r\n/**\r\n * A React component that hosts a multi-tabbed layout\r\n */\r\nclass Layout extends react__WEBPACK_IMPORTED_MODULE_0__.Component {\r\n    constructor(props) {\r\n        super(props);\r\n        /** @internal */\r\n        this.firstMove = false;\r\n        /** @internal */\r\n        this.dragRectRendered = true;\r\n        /** @internal */\r\n        this.dragDivText = undefined;\r\n        /** @internal */\r\n        this.edgeRectLength = 100;\r\n        /** @internal */\r\n        this.edgeRectWidth = 10;\r\n        /** @internal */\r\n        this.onModelChange = (action) => {\r\n            this.forceUpdate();\r\n            if (this.props.onModelChange) {\r\n                this.props.onModelChange(this.props.model, action);\r\n            }\r\n        };\r\n        /** @internal */\r\n        this.updateRect = (domRect = this.getDomRect()) => {\r\n            const rect = new _Rect__WEBPACK_IMPORTED_MODULE_9__.Rect(0, 0, domRect.width, domRect.height);\r\n            if (!rect.equals(this.state.rect) && rect.width !== 0 && rect.height !== 0) {\r\n                this.setState({ rect });\r\n            }\r\n        };\r\n        /** @internal */\r\n        this.updateLayoutMetrics = () => {\r\n            if (this.findHeaderBarSizeRef.current) {\r\n                const headerBarSize = this.findHeaderBarSizeRef.current.getBoundingClientRect().height;\r\n                if (headerBarSize !== this.state.calculatedHeaderBarSize) {\r\n                    this.setState({ calculatedHeaderBarSize: headerBarSize });\r\n                }\r\n            }\r\n            if (this.findTabBarSizeRef.current) {\r\n                const tabBarSize = this.findTabBarSizeRef.current.getBoundingClientRect().height;\r\n                if (tabBarSize !== this.state.calculatedTabBarSize) {\r\n                    this.setState({ calculatedTabBarSize: tabBarSize });\r\n                }\r\n            }\r\n            if (this.findBorderBarSizeRef.current) {\r\n                const borderBarSize = this.findBorderBarSizeRef.current.getBoundingClientRect().height;\r\n                if (borderBarSize !== this.state.calculatedBorderBarSize) {\r\n                    this.setState({ calculatedBorderBarSize: borderBarSize });\r\n                }\r\n            }\r\n        };\r\n        /** @internal */\r\n        this.getClassName = (defaultClassName) => {\r\n            if (this.props.classNameMapper === undefined) {\r\n                return defaultClassName;\r\n            }\r\n            else {\r\n                return this.props.classNameMapper(defaultClassName);\r\n            }\r\n        };\r\n        /** @internal */\r\n        this.onCloseWindow = (id) => {\r\n            this.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_4__.Actions.unFloatTab(id));\r\n            try {\r\n                this.props.model.getNodeById(id)._setWindow(undefined);\r\n            }\r\n            catch (e) {\r\n                // catch incase it was a model change\r\n            }\r\n        };\r\n        /** @internal */\r\n        this.onSetWindow = (id, window) => {\r\n            this.props.model.getNodeById(id)._setWindow(window);\r\n        };\r\n        /** @internal */\r\n        this.onCancelAdd = () => {\r\n            var _a, _b;\r\n            const rootdiv = this.selfRef.current;\r\n            rootdiv.removeChild(this.dragDiv);\r\n            this.dragDiv = undefined;\r\n            this.hidePortal();\r\n            if (this.fnNewNodeDropped != null) {\r\n                this.fnNewNodeDropped();\r\n                this.fnNewNodeDropped = undefined;\r\n            }\r\n            try {\r\n                (_b = (_a = this.customDrop) === null || _a === void 0 ? void 0 : _a.invalidated) === null || _b === void 0 ? void 0 : _b.call(_a);\r\n            }\r\n            catch (e) {\r\n                console.error(e);\r\n            }\r\n            _DragDrop__WEBPACK_IMPORTED_MODULE_3__.DragDrop.instance.hideGlass();\r\n            this.newTabJson = undefined;\r\n            this.customDrop = undefined;\r\n        };\r\n        /** @internal */\r\n        this.onCancelDrag = (wasDragging) => {\r\n            var _a, _b;\r\n            if (wasDragging) {\r\n                const rootdiv = this.selfRef.current;\r\n                try {\r\n                    rootdiv.removeChild(this.outlineDiv);\r\n                }\r\n                catch (e) { }\r\n                try {\r\n                    rootdiv.removeChild(this.dragDiv);\r\n                }\r\n                catch (e) { }\r\n                this.dragDiv = undefined;\r\n                this.hidePortal();\r\n                this.setState({ showEdges: false });\r\n                if (this.fnNewNodeDropped != null) {\r\n                    this.fnNewNodeDropped();\r\n                    this.fnNewNodeDropped = undefined;\r\n                }\r\n                try {\r\n                    (_b = (_a = this.customDrop) === null || _a === void 0 ? void 0 : _a.invalidated) === null || _b === void 0 ? void 0 : _b.call(_a);\r\n                }\r\n                catch (e) {\r\n                    console.error(e);\r\n                }\r\n                _DragDrop__WEBPACK_IMPORTED_MODULE_3__.DragDrop.instance.hideGlass();\r\n                this.newTabJson = undefined;\r\n                this.customDrop = undefined;\r\n            }\r\n            this.setState({ showHiddenBorder: _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER });\r\n        };\r\n        /** @internal */\r\n        this.onDragDivMouseDown = (event) => {\r\n            event.preventDefault();\r\n            this.dragStart(event, this.dragDivText, _model_TabNode__WEBPACK_IMPORTED_MODULE_7__.TabNode._fromJson(this.newTabJson, this.props.model, false), true, undefined, undefined);\r\n        };\r\n        /** @internal */\r\n        this.dragStart = (event, dragDivText, node, allowDrag, onClick, onDoubleClick) => {\r\n            if (!allowDrag) {\r\n                _DragDrop__WEBPACK_IMPORTED_MODULE_3__.DragDrop.instance.startDrag(event, undefined, undefined, undefined, undefined, onClick, onDoubleClick, this.currentDocument, this.selfRef.current);\r\n            }\r\n            else {\r\n                this.dragNode = node;\r\n                this.dragDivText = dragDivText;\r\n                _DragDrop__WEBPACK_IMPORTED_MODULE_3__.DragDrop.instance.startDrag(event, this.onDragStart, this.onDragMove, this.onDragEnd, this.onCancelDrag, onClick, onDoubleClick, this.currentDocument, this.selfRef.current);\r\n            }\r\n        };\r\n        /** @internal */\r\n        this.dragRectRender = (text, node, json, onRendered) => {\r\n            let content;\r\n            if (text !== undefined) {\r\n                content = react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { style: { whiteSpace: \"pre\" } }, text.replace(\"<br>\", \"\\n\"));\r\n            }\r\n            else {\r\n                if (node && node instanceof _model_TabNode__WEBPACK_IMPORTED_MODULE_7__.TabNode) {\r\n                    content = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TabButtonStamp__WEBPACK_IMPORTED_MODULE_20__.TabButtonStamp, { node: node, layout: this, iconFactory: this.props.iconFactory, titleFactory: this.props.titleFactory }));\r\n                }\r\n            }\r\n            if (this.props.onRenderDragRect !== undefined) {\r\n                const customContent = this.props.onRenderDragRect(content, node, json);\r\n                if (customContent !== undefined) {\r\n                    content = customContent;\r\n                }\r\n            }\r\n            // hide div until the render is complete\r\n            this.dragDiv.style.visibility = \"hidden\";\r\n            this.dragRectRendered = false;\r\n            this.showPortal(react__WEBPACK_IMPORTED_MODULE_0__.createElement(DragRectRenderWrapper\r\n            // wait for it to be rendered\r\n            , { \r\n                // wait for it to be rendered\r\n                onRendered: () => {\r\n                    this.dragRectRendered = true;\r\n                    onRendered === null || onRendered === void 0 ? void 0 : onRendered();\r\n                } }, content), this.dragDiv);\r\n        };\r\n        /** @internal */\r\n        this.showPortal = (control, element) => {\r\n            const portal = (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(control, element);\r\n            this.setState({ portal });\r\n        };\r\n        /** @internal */\r\n        this.hidePortal = () => {\r\n            this.setState({ portal: undefined });\r\n        };\r\n        /** @internal */\r\n        this.onDragStart = () => {\r\n            this.dropInfo = undefined;\r\n            this.customDrop = undefined;\r\n            const rootdiv = this.selfRef.current;\r\n            this.outlineDiv = this.currentDocument.createElement(\"div\");\r\n            this.outlineDiv.className = this.getClassName(_Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__OUTLINE_RECT);\r\n            this.outlineDiv.style.visibility = \"hidden\";\r\n            rootdiv.appendChild(this.outlineDiv);\r\n            if (this.dragDiv == null) {\r\n                this.dragDiv = this.currentDocument.createElement(\"div\");\r\n                this.dragDiv.className = this.getClassName(_Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__DRAG_RECT);\r\n                this.dragDiv.setAttribute(\"data-layout-path\", \"/drag-rectangle\");\r\n                this.dragRectRender(this.dragDivText, this.dragNode, this.newTabJson);\r\n                rootdiv.appendChild(this.dragDiv);\r\n            }\r\n            // add edge indicators\r\n            if (this.props.model.getMaximizedTabset() === undefined) {\r\n                this.setState({ showEdges: true });\r\n            }\r\n            if (this.dragNode !== undefined && this.dragNode instanceof _model_TabNode__WEBPACK_IMPORTED_MODULE_7__.TabNode && this.dragNode.getTabRect() !== undefined) {\r\n                this.dragNode.getTabRect().positionElement(this.outlineDiv);\r\n            }\r\n            this.firstMove = true;\r\n            return true;\r\n        };\r\n        /** @internal */\r\n        this.onDragMove = (event) => {\r\n            if (this.firstMove === false) {\r\n                const speed = this.props.model._getAttribute(\"tabDragSpeed\");\r\n                this.outlineDiv.style.transition = `top ${speed}s, left ${speed}s, width ${speed}s, height ${speed}s`;\r\n            }\r\n            this.firstMove = false;\r\n            const clientRect = this.selfRef.current.getBoundingClientRect();\r\n            const pos = {\r\n                x: event.clientX - clientRect.left,\r\n                y: event.clientY - clientRect.top,\r\n            };\r\n            this.checkForBorderToShow(pos.x, pos.y);\r\n            // keep it between left & right\r\n            const dragRect = this.dragDiv.getBoundingClientRect();\r\n            let newLeft = pos.x - dragRect.width / 2;\r\n            if (newLeft + dragRect.width > clientRect.width) {\r\n                newLeft = clientRect.width - dragRect.width;\r\n            }\r\n            newLeft = Math.max(0, newLeft);\r\n            this.dragDiv.style.left = newLeft + \"px\";\r\n            this.dragDiv.style.top = pos.y + 5 + \"px\";\r\n            if (this.dragRectRendered && this.dragDiv.style.visibility === \"hidden\") {\r\n                // make visible once the drag rect has been rendered\r\n                this.dragDiv.style.visibility = \"visible\";\r\n            }\r\n            let dropInfo = this.props.model._findDropTargetNode(this.dragNode, pos.x, pos.y);\r\n            if (dropInfo) {\r\n                if (this.props.onTabDrag) {\r\n                    this.handleCustomTabDrag(dropInfo, pos, event);\r\n                }\r\n                else {\r\n                    this.dropInfo = dropInfo;\r\n                    this.outlineDiv.className = this.getClassName(dropInfo.className);\r\n                    dropInfo.rect.positionElement(this.outlineDiv);\r\n                    this.outlineDiv.style.visibility = \"visible\";\r\n                }\r\n            }\r\n        };\r\n        /** @internal */\r\n        this.onDragEnd = (event) => {\r\n            const rootdiv = this.selfRef.current;\r\n            rootdiv.removeChild(this.outlineDiv);\r\n            rootdiv.removeChild(this.dragDiv);\r\n            this.dragDiv = undefined;\r\n            this.hidePortal();\r\n            this.setState({ showEdges: false });\r\n            _DragDrop__WEBPACK_IMPORTED_MODULE_3__.DragDrop.instance.hideGlass();\r\n            if (this.dropInfo) {\r\n                if (this.customDrop) {\r\n                    this.newTabJson = undefined;\r\n                    try {\r\n                        const { callback, dragging, over, x, y, location } = this.customDrop;\r\n                        callback(dragging, over, x, y, location);\r\n                        if (this.fnNewNodeDropped != null) {\r\n                            this.fnNewNodeDropped();\r\n                            this.fnNewNodeDropped = undefined;\r\n                        }\r\n                    }\r\n                    catch (e) {\r\n                        console.error(e);\r\n                    }\r\n                }\r\n                else if (this.newTabJson !== undefined) {\r\n                    const newNode = this.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_4__.Actions.addNode(this.newTabJson, this.dropInfo.node.getId(), this.dropInfo.location, this.dropInfo.index));\r\n                    if (this.fnNewNodeDropped != null) {\r\n                        this.fnNewNodeDropped(newNode, event);\r\n                        this.fnNewNodeDropped = undefined;\r\n                    }\r\n                    this.newTabJson = undefined;\r\n                }\r\n                else if (this.dragNode !== undefined) {\r\n                    this.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_4__.Actions.moveNode(this.dragNode.getId(), this.dropInfo.node.getId(), this.dropInfo.location, this.dropInfo.index));\r\n                }\r\n            }\r\n            this.setState({ showHiddenBorder: _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER });\r\n        };\r\n        this.props.model._setChangeListener(this.onModelChange);\r\n        this.tabIds = [];\r\n        this.selfRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();\r\n        this.findHeaderBarSizeRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();\r\n        this.findTabBarSizeRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();\r\n        this.findBorderBarSizeRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();\r\n        this.supportsPopout = props.supportsPopout !== undefined ? props.supportsPopout : defaultSupportsPopout;\r\n        this.popoutURL = props.popoutURL ? props.popoutURL : \"popout.html\";\r\n        this.icons = Object.assign(Object.assign({}, defaultIcons), props.icons);\r\n        this.state = {\r\n            rect: new _Rect__WEBPACK_IMPORTED_MODULE_9__.Rect(0, 0, 0, 0),\r\n            calculatedHeaderBarSize: 25,\r\n            calculatedTabBarSize: 26,\r\n            calculatedBorderBarSize: 30,\r\n            editingTab: undefined,\r\n            showHiddenBorder: _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER,\r\n            showEdges: false,\r\n        };\r\n        this.onDragEnter = this.onDragEnter.bind(this);\r\n    }\r\n    /** @internal */\r\n    styleFont(style) {\r\n        if (this.props.font) {\r\n            if (this.selfRef.current) {\r\n                if (this.props.font.size) {\r\n                    this.selfRef.current.style.setProperty(\"--font-size\", this.props.font.size);\r\n                }\r\n                if (this.props.font.family) {\r\n                    this.selfRef.current.style.setProperty(\"--font-family\", this.props.font.family);\r\n                }\r\n            }\r\n            if (this.props.font.style) {\r\n                style.fontStyle = this.props.font.style;\r\n            }\r\n            if (this.props.font.weight) {\r\n                style.fontWeight = this.props.font.weight;\r\n            }\r\n        }\r\n        return style;\r\n    }\r\n    /** @internal */\r\n    doAction(action) {\r\n        if (this.props.onAction !== undefined) {\r\n            const outcome = this.props.onAction(action);\r\n            if (outcome !== undefined) {\r\n                return this.props.model.doAction(outcome);\r\n            }\r\n            return undefined;\r\n        }\r\n        else {\r\n            return this.props.model.doAction(action);\r\n        }\r\n    }\r\n    /** @internal */\r\n    componentDidMount() {\r\n        this.updateRect();\r\n        this.updateLayoutMetrics();\r\n        // need to re-render if size changes\r\n        this.currentDocument = this.selfRef.current.ownerDocument;\r\n        this.currentWindow = this.currentDocument.defaultView;\r\n        this.resizeObserver = new ResizeObserver(entries => {\r\n            this.updateRect(entries[0].contentRect);\r\n        });\r\n        this.resizeObserver.observe(this.selfRef.current);\r\n    }\r\n    /** @internal */\r\n    componentDidUpdate() {\r\n        this.updateLayoutMetrics();\r\n        if (this.props.model !== this.previousModel) {\r\n            if (this.previousModel !== undefined) {\r\n                this.previousModel._setChangeListener(undefined); // stop listening to old model\r\n            }\r\n            this.props.model._setChangeListener(this.onModelChange);\r\n            this.previousModel = this.props.model;\r\n        }\r\n        // console.log(\"Layout time: \" + this.layoutTime + \"ms Render time: \" + (Date.now() - this.start) + \"ms\");\r\n    }\r\n    /** @internal */\r\n    getCurrentDocument() {\r\n        return this.currentDocument;\r\n    }\r\n    /** @internal */\r\n    getDomRect() {\r\n        return this.selfRef.current.getBoundingClientRect();\r\n    }\r\n    /** @internal */\r\n    getRootDiv() {\r\n        return this.selfRef.current;\r\n    }\r\n    /** @internal */\r\n    isSupportsPopout() {\r\n        return this.supportsPopout;\r\n    }\r\n    /** @internal */\r\n    isRealtimeResize() {\r\n        var _a;\r\n        return (_a = this.props.realtimeResize) !== null && _a !== void 0 ? _a : false;\r\n    }\r\n    /** @internal */\r\n    onTabDrag(...args) {\r\n        var _a, _b;\r\n        return (_b = (_a = this.props).onTabDrag) === null || _b === void 0 ? void 0 : _b.call(_a, ...args);\r\n    }\r\n    /** @internal */\r\n    getPopoutURL() {\r\n        return this.popoutURL;\r\n    }\r\n    /** @internal */\r\n    componentWillUnmount() {\r\n        var _a;\r\n        (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.unobserve(this.selfRef.current);\r\n    }\r\n    /** @internal */\r\n    setEditingTab(tabNode) {\r\n        this.setState({ editingTab: tabNode });\r\n    }\r\n    /** @internal */\r\n    getEditingTab() {\r\n        return this.state.editingTab;\r\n    }\r\n    /** @internal */\r\n    render() {\r\n        // first render will be used to find the size (via selfRef)\r\n        if (!this.selfRef.current) {\r\n            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { ref: this.selfRef, className: this.getClassName(_Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__LAYOUT) }, this.metricsElements()));\r\n        }\r\n        this.props.model._setPointerFine(window && window.matchMedia && window.matchMedia(\"(pointer: fine)\").matches);\r\n        // this.start = Date.now();\r\n        const borderComponents = [];\r\n        const tabSetComponents = [];\r\n        const floatingWindows = [];\r\n        const tabComponents = {};\r\n        const splitterComponents = [];\r\n        const metrics = {\r\n            headerBarSize: this.state.calculatedHeaderBarSize,\r\n            tabBarSize: this.state.calculatedTabBarSize,\r\n            borderBarSize: this.state.calculatedBorderBarSize\r\n        };\r\n        this.props.model._setShowHiddenBorder(this.state.showHiddenBorder);\r\n        this.centerRect = this.props.model._layout(this.state.rect, metrics);\r\n        this.renderBorder(this.props.model.getBorderSet(), borderComponents, tabComponents, floatingWindows, splitterComponents);\r\n        this.renderChildren(\"\", this.props.model.getRoot(), tabSetComponents, tabComponents, floatingWindows, splitterComponents);\r\n        const nextTopIds = [];\r\n        const nextTopIdsMap = {};\r\n        // Keep any previous tabs in the same DOM order as before, removing any that have been deleted\r\n        for (const t of this.tabIds) {\r\n            if (tabComponents[t]) {\r\n                nextTopIds.push(t);\r\n                nextTopIdsMap[t] = t;\r\n            }\r\n        }\r\n        this.tabIds = nextTopIds;\r\n        // Add tabs that have been added to the DOM\r\n        for (const t of Object.keys(tabComponents)) {\r\n            if (!nextTopIdsMap[t]) {\r\n                this.tabIds.push(t);\r\n            }\r\n        }\r\n        const edges = [];\r\n        if (this.state.showEdges) {\r\n            const r = this.centerRect;\r\n            const length = this.edgeRectLength;\r\n            const width = this.edgeRectWidth;\r\n            const offset = this.edgeRectLength / 2;\r\n            const className = this.getClassName(_Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__EDGE_RECT);\r\n            const radius = 50;\r\n            edges.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"North\", style: { top: r.y, left: r.x + r.width / 2 - offset, width: length, height: width, borderBottomLeftRadius: radius, borderBottomRightRadius: radius }, className: className }));\r\n            edges.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"West\", style: { top: r.y + r.height / 2 - offset, left: r.x, width: width, height: length, borderTopRightRadius: radius, borderBottomRightRadius: radius }, className: className }));\r\n            edges.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"South\", style: { top: r.y + r.height - width, left: r.x + r.width / 2 - offset, width: length, height: width, borderTopLeftRadius: radius, borderTopRightRadius: radius }, className: className }));\r\n            edges.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"East\", style: { top: r.y + r.height / 2 - offset, left: r.x + r.width - width, width: width, height: length, borderTopLeftRadius: radius, borderBottomLeftRadius: radius }, className: className }));\r\n        }\r\n        // this.layoutTime = (Date.now() - this.start);\r\n        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { ref: this.selfRef, className: this.getClassName(_Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__LAYOUT), onDragEnter: this.props.onExternalDrag ? this.onDragEnter : undefined },\r\n            tabSetComponents,\r\n            this.tabIds.map((t) => {\r\n                return tabComponents[t];\r\n            }),\r\n            borderComponents,\r\n            splitterComponents,\r\n            edges,\r\n            floatingWindows,\r\n            this.metricsElements(),\r\n            this.state.portal));\r\n    }\r\n    /** @internal */\r\n    metricsElements() {\r\n        // used to measure the tab and border tab sizes\r\n        const fontStyle = this.styleFont({ visibility: \"hidden\" });\r\n        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"findHeaderBarSize\", ref: this.findHeaderBarSizeRef, style: fontStyle, className: this.getClassName(_Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__TABSET_HEADER_SIZER) }, \"FindHeaderBarSize\"),\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"findTabBarSize\", ref: this.findTabBarSizeRef, style: fontStyle, className: this.getClassName(_Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__TABSET_SIZER) }, \"FindTabBarSize\"),\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"findBorderBarSize\", ref: this.findBorderBarSizeRef, style: fontStyle, className: this.getClassName(_Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__BORDER_SIZER) }, \"FindBorderBarSize\")));\r\n    }\r\n    /** @internal */\r\n    renderBorder(borderSet, borderComponents, tabComponents, floatingWindows, splitterComponents) {\r\n        for (const border of borderSet.getBorders()) {\r\n            const borderPath = `/border/${border.getLocation().getName()}`;\r\n            if (border.isShowing()) {\r\n                borderComponents.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BorderTabSet__WEBPACK_IMPORTED_MODULE_11__.BorderTabSet, { key: `border_${border.getLocation().getName()}`, path: borderPath, border: border, layout: this, iconFactory: this.props.iconFactory, titleFactory: this.props.titleFactory, icons: this.icons }));\r\n                const drawChildren = border._getDrawChildren();\r\n                let i = 0;\r\n                let tabCount = 0;\r\n                for (const child of drawChildren) {\r\n                    if (child instanceof _model_SplitterNode__WEBPACK_IMPORTED_MODULE_6__.SplitterNode) {\r\n                        let path = borderPath + \"/s\";\r\n                        splitterComponents.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Splitter__WEBPACK_IMPORTED_MODULE_12__.Splitter, { key: child.getId(), layout: this, node: child, path: path }));\r\n                    }\r\n                    else if (child instanceof _model_TabNode__WEBPACK_IMPORTED_MODULE_7__.TabNode) {\r\n                        let path = borderPath + \"/t\" + tabCount++;\r\n                        if (this.supportsPopout && child.isFloating()) {\r\n                            const rect = this._getScreenRect(child);\r\n                            floatingWindows.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FloatingWindow__WEBPACK_IMPORTED_MODULE_15__.FloatingWindow, { key: child.getId(), url: this.popoutURL, rect: rect, title: child.getName(), id: child.getId(), onSetWindow: this.onSetWindow, onCloseWindow: this.onCloseWindow },\r\n                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FloatingWindowTab__WEBPACK_IMPORTED_MODULE_16__.FloatingWindowTab, { layout: this, node: child, factory: this.props.factory })));\r\n                            tabComponents[child.getId()] = react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TabFloating__WEBPACK_IMPORTED_MODULE_17__.TabFloating, { key: child.getId(), layout: this, path: path, node: child, selected: i === border.getSelected() });\r\n                        }\r\n                        else {\r\n                            tabComponents[child.getId()] = react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tab__WEBPACK_IMPORTED_MODULE_13__.Tab, { key: child.getId(), layout: this, path: path, node: child, selected: i === border.getSelected(), factory: this.props.factory });\r\n                        }\r\n                    }\r\n                    i++;\r\n                }\r\n            }\r\n        }\r\n    }\r\n    /** @internal */\r\n    renderChildren(path, node, tabSetComponents, tabComponents, floatingWindows, splitterComponents) {\r\n        const drawChildren = node._getDrawChildren();\r\n        let splitterCount = 0;\r\n        let tabCount = 0;\r\n        let rowCount = 0;\r\n        for (const child of drawChildren) {\r\n            if (child instanceof _model_SplitterNode__WEBPACK_IMPORTED_MODULE_6__.SplitterNode) {\r\n                const newPath = path + \"/s\" + (splitterCount++);\r\n                splitterComponents.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Splitter__WEBPACK_IMPORTED_MODULE_12__.Splitter, { key: child.getId(), layout: this, path: newPath, node: child }));\r\n            }\r\n            else if (child instanceof _model_TabSetNode__WEBPACK_IMPORTED_MODULE_8__.TabSetNode) {\r\n                const newPath = path + \"/ts\" + (rowCount++);\r\n                tabSetComponents.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TabSet__WEBPACK_IMPORTED_MODULE_14__.TabSet, { key: child.getId(), layout: this, path: newPath, node: child, iconFactory: this.props.iconFactory, titleFactory: this.props.titleFactory, icons: this.icons }));\r\n                this.renderChildren(newPath, child, tabSetComponents, tabComponents, floatingWindows, splitterComponents);\r\n            }\r\n            else if (child instanceof _model_TabNode__WEBPACK_IMPORTED_MODULE_7__.TabNode) {\r\n                const newPath = path + \"/t\" + (tabCount++);\r\n                const selectedTab = child.getParent().getChildren()[child.getParent().getSelected()];\r\n                if (selectedTab === undefined) {\r\n                    // this should not happen!\r\n                    console.warn(\"undefined selectedTab should not happen\");\r\n                }\r\n                if (this.supportsPopout && child.isFloating()) {\r\n                    const rect = this._getScreenRect(child);\r\n                    floatingWindows.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FloatingWindow__WEBPACK_IMPORTED_MODULE_15__.FloatingWindow, { key: child.getId(), url: this.popoutURL, rect: rect, title: child.getName(), id: child.getId(), onSetWindow: this.onSetWindow, onCloseWindow: this.onCloseWindow },\r\n                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FloatingWindowTab__WEBPACK_IMPORTED_MODULE_16__.FloatingWindowTab, { layout: this, node: child, factory: this.props.factory })));\r\n                    tabComponents[child.getId()] = react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TabFloating__WEBPACK_IMPORTED_MODULE_17__.TabFloating, { key: child.getId(), layout: this, path: newPath, node: child, selected: child === selectedTab });\r\n                }\r\n                else {\r\n                    tabComponents[child.getId()] = react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tab__WEBPACK_IMPORTED_MODULE_13__.Tab, { key: child.getId(), layout: this, path: newPath, node: child, selected: child === selectedTab, factory: this.props.factory });\r\n                }\r\n            }\r\n            else {\r\n                // is row\r\n                const newPath = path + ((child.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_18__.Orientation.HORZ) ? \"/r\" : \"/c\") + (rowCount++);\r\n                this.renderChildren(newPath, child, tabSetComponents, tabComponents, floatingWindows, splitterComponents);\r\n            }\r\n        }\r\n    }\r\n    /** @internal */\r\n    _getScreenRect(node) {\r\n        const rect = node.getRect().clone();\r\n        const bodyRect = this.selfRef.current.getBoundingClientRect();\r\n        const navHeight = Math.min(80, this.currentWindow.outerHeight - this.currentWindow.innerHeight);\r\n        const navWidth = Math.min(80, this.currentWindow.outerWidth - this.currentWindow.innerWidth);\r\n        rect.x = rect.x + bodyRect.x + this.currentWindow.screenX + navWidth;\r\n        rect.y = rect.y + bodyRect.y + this.currentWindow.screenY + navHeight;\r\n        return rect;\r\n    }\r\n    /**\r\n     * Adds a new tab to the given tabset\r\n     * @param tabsetId the id of the tabset where the new tab will be added\r\n     * @param json the json for the new tab node\r\n     */\r\n    addTabToTabSet(tabsetId, json) {\r\n        const tabsetNode = this.props.model.getNodeById(tabsetId);\r\n        if (tabsetNode !== undefined) {\r\n            this.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_4__.Actions.addNode(json, tabsetId, _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER, -1));\r\n        }\r\n    }\r\n    /**\r\n     * Adds a new tab to the active tabset (if there is one)\r\n     * @param json the json for the new tab node\r\n     */\r\n    addTabToActiveTabSet(json) {\r\n        const tabsetNode = this.props.model.getActiveTabset();\r\n        if (tabsetNode !== undefined) {\r\n            this.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_4__.Actions.addNode(json, tabsetNode.getId(), _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER, -1));\r\n        }\r\n    }\r\n    /**\r\n     * Adds a new tab by dragging a labeled panel to the drop location, dragging starts immediatelly\r\n     * @param dragText the text to show on the drag panel\r\n     * @param json the json for the new tab node\r\n     * @param onDrop a callback to call when the drag is complete (node and event will be undefined if the drag was cancelled)\r\n     */\r\n    addTabWithDragAndDrop(dragText, json, onDrop) {\r\n        this.fnNewNodeDropped = onDrop;\r\n        this.newTabJson = json;\r\n        this.dragStart(undefined, dragText, _model_TabNode__WEBPACK_IMPORTED_MODULE_7__.TabNode._fromJson(json, this.props.model, false), true, undefined, undefined);\r\n    }\r\n    /**\r\n     * Move a tab/tabset using drag and drop\r\n     * @param node the tab or tabset to drag\r\n     * @param dragText the text to show on the drag panel\r\n     */\r\n    moveTabWithDragAndDrop(node, dragText) {\r\n        this.dragStart(undefined, dragText, node, true, undefined, undefined);\r\n    }\r\n    /**\r\n     * Adds a new tab by dragging a labeled panel to the drop location, dragging starts when you\r\n     * mouse down on the panel\r\n     *\r\n     * @param dragText the text to show on the drag panel\r\n     * @param json the json for the new tab node\r\n     * @param onDrop a callback to call when the drag is complete (node and event will be undefined if the drag was cancelled)\r\n     */\r\n    addTabWithDragAndDropIndirect(dragText, json, onDrop) {\r\n        this.fnNewNodeDropped = onDrop;\r\n        this.newTabJson = json;\r\n        _DragDrop__WEBPACK_IMPORTED_MODULE_3__.DragDrop.instance.addGlass(this.onCancelAdd);\r\n        this.dragDivText = dragText;\r\n        this.dragDiv = this.currentDocument.createElement(\"div\");\r\n        this.dragDiv.className = this.getClassName(_Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__DRAG_RECT);\r\n        this.dragDiv.addEventListener(\"mousedown\", this.onDragDivMouseDown);\r\n        this.dragDiv.addEventListener(\"touchstart\", this.onDragDivMouseDown, { passive: false });\r\n        this.dragRectRender(this.dragDivText, undefined, this.newTabJson, () => {\r\n            if (this.dragDiv) {\r\n                // now it's been rendered into the dom it can be centered\r\n                this.dragDiv.style.visibility = \"visible\";\r\n                const domRect = this.dragDiv.getBoundingClientRect();\r\n                const r = new _Rect__WEBPACK_IMPORTED_MODULE_9__.Rect(0, 0, domRect === null || domRect === void 0 ? void 0 : domRect.width, domRect === null || domRect === void 0 ? void 0 : domRect.height);\r\n                r.centerInRect(this.state.rect);\r\n                this.dragDiv.setAttribute(\"data-layout-path\", \"/drag-rectangle\");\r\n                this.dragDiv.style.left = r.x + \"px\";\r\n                this.dragDiv.style.top = r.y + \"px\";\r\n            }\r\n        });\r\n        const rootdiv = this.selfRef.current;\r\n        rootdiv.appendChild(this.dragDiv);\r\n    }\r\n    /** @internal */\r\n    handleCustomTabDrag(dropInfo, pos, event) {\r\n        var _a, _b, _c;\r\n        let invalidated = (_a = this.customDrop) === null || _a === void 0 ? void 0 : _a.invalidated;\r\n        const currentCallback = (_b = this.customDrop) === null || _b === void 0 ? void 0 : _b.callback;\r\n        this.customDrop = undefined;\r\n        const dragging = this.newTabJson || (this.dragNode instanceof _model_TabNode__WEBPACK_IMPORTED_MODULE_7__.TabNode ? this.dragNode : undefined);\r\n        if (dragging && (dropInfo.node instanceof _model_TabSetNode__WEBPACK_IMPORTED_MODULE_8__.TabSetNode || dropInfo.node instanceof _model_BorderNode__WEBPACK_IMPORTED_MODULE_5__.BorderNode) && dropInfo.index === -1) {\r\n            const selected = dropInfo.node.getSelectedNode();\r\n            const tabRect = selected === null || selected === void 0 ? void 0 : selected.getRect();\r\n            if (selected && (tabRect === null || tabRect === void 0 ? void 0 : tabRect.contains(pos.x, pos.y))) {\r\n                let customDrop = undefined;\r\n                try {\r\n                    const dest = this.onTabDrag(dragging, selected, pos.x - tabRect.x, pos.y - tabRect.y, dropInfo.location, () => this.onDragMove(event));\r\n                    if (dest) {\r\n                        customDrop = {\r\n                            rect: new _Rect__WEBPACK_IMPORTED_MODULE_9__.Rect(dest.x + tabRect.x, dest.y + tabRect.y, dest.width, dest.height),\r\n                            callback: dest.callback,\r\n                            invalidated: dest.invalidated,\r\n                            dragging: dragging,\r\n                            over: selected,\r\n                            x: pos.x - tabRect.x,\r\n                            y: pos.y - tabRect.y,\r\n                            location: dropInfo.location,\r\n                            cursor: dest.cursor\r\n                        };\r\n                    }\r\n                }\r\n                catch (e) {\r\n                    console.error(e);\r\n                }\r\n                if ((customDrop === null || customDrop === void 0 ? void 0 : customDrop.callback) === currentCallback) {\r\n                    invalidated = undefined;\r\n                }\r\n                this.customDrop = customDrop;\r\n            }\r\n        }\r\n        this.dropInfo = dropInfo;\r\n        this.outlineDiv.className = this.getClassName(this.customDrop ? _Types__WEBPACK_IMPORTED_MODULE_10__.CLASSES.FLEXLAYOUT__OUTLINE_RECT : dropInfo.className);\r\n        if (this.customDrop) {\r\n            this.customDrop.rect.positionElement(this.outlineDiv);\r\n        }\r\n        else {\r\n            dropInfo.rect.positionElement(this.outlineDiv);\r\n        }\r\n        _DragDrop__WEBPACK_IMPORTED_MODULE_3__.DragDrop.instance.setGlassCursorOverride((_c = this.customDrop) === null || _c === void 0 ? void 0 : _c.cursor);\r\n        this.outlineDiv.style.visibility = \"visible\";\r\n        try {\r\n            invalidated === null || invalidated === void 0 ? void 0 : invalidated();\r\n        }\r\n        catch (e) {\r\n            console.error(e);\r\n        }\r\n    }\r\n    /** @internal */\r\n    onDragEnter(event) {\r\n        // DragDrop keeps track of number of dragenters minus the number of\r\n        // dragleaves. Only start a new drag if there isn't one already.\r\n        if (_DragDrop__WEBPACK_IMPORTED_MODULE_3__.DragDrop.instance.isDragging())\r\n            return;\r\n        const drag = this.props.onExternalDrag(event);\r\n        if (drag) {\r\n            // Mimic addTabWithDragAndDrop, but pass in DragEvent\r\n            this.fnNewNodeDropped = drag.onDrop;\r\n            this.newTabJson = drag.json;\r\n            this.dragStart(event, drag.dragText, _model_TabNode__WEBPACK_IMPORTED_MODULE_7__.TabNode._fromJson(drag.json, this.props.model, false), true, undefined, undefined);\r\n        }\r\n    }\r\n    /** @internal */\r\n    checkForBorderToShow(x, y) {\r\n        const r = this.props.model._getOuterInnerRects().outer;\r\n        const c = r.getCenter();\r\n        const margin = this.edgeRectWidth;\r\n        const offset = this.edgeRectLength / 2;\r\n        let overEdge = false;\r\n        if (this.props.model.isEnableEdgeDock() && this.state.showHiddenBorder === _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER) {\r\n            if ((y > c.y - offset && y < c.y + offset) ||\r\n                (x > c.x - offset && x < c.x + offset)) {\r\n                overEdge = true;\r\n            }\r\n        }\r\n        let location = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.CENTER;\r\n        if (!overEdge) {\r\n            if (x <= r.x + margin) {\r\n                location = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.LEFT;\r\n            }\r\n            else if (x >= r.getRight() - margin) {\r\n                location = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.RIGHT;\r\n            }\r\n            else if (y <= r.y + margin) {\r\n                location = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.TOP;\r\n            }\r\n            else if (y >= r.getBottom() - margin) {\r\n                location = _DockLocation__WEBPACK_IMPORTED_MODULE_2__.DockLocation.BOTTOM;\r\n            }\r\n        }\r\n        if (location !== this.state.showHiddenBorder) {\r\n            this.setState({ showHiddenBorder: location });\r\n        }\r\n    }\r\n    /** @internal */\r\n    maximize(tabsetNode) {\r\n        this.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_4__.Actions.maximizeToggle(tabsetNode.getId()));\r\n    }\r\n    /** @internal */\r\n    customizeTab(tabNode, renderValues) {\r\n        if (this.props.onRenderTab) {\r\n            this.props.onRenderTab(tabNode, renderValues);\r\n        }\r\n    }\r\n    /** @internal */\r\n    customizeTabSet(tabSetNode, renderValues) {\r\n        if (this.props.onRenderTabSet) {\r\n            this.props.onRenderTabSet(tabSetNode, renderValues);\r\n        }\r\n    }\r\n    /** @internal */\r\n    i18nName(id, param) {\r\n        let message;\r\n        if (this.props.i18nMapper) {\r\n            message = this.props.i18nMapper(id, param);\r\n        }\r\n        if (message === undefined) {\r\n            message = id + (param === undefined ? \"\" : param);\r\n        }\r\n        return message;\r\n    }\r\n    /** @internal */\r\n    getOnRenderFloatingTabPlaceholder() {\r\n        return this.props.onRenderFloatingTabPlaceholder;\r\n    }\r\n    /** @internal */\r\n    getShowOverflowMenu() {\r\n        return this.props.onShowOverflowMenu;\r\n    }\r\n    /** @internal */\r\n    getTabSetPlaceHolderCallback() {\r\n        return this.props.onTabSetPlaceHolder;\r\n    }\r\n    /** @internal */\r\n    showContextMenu(node, event) {\r\n        if (this.props.onContextMenu) {\r\n            this.props.onContextMenu(node, event);\r\n        }\r\n    }\r\n    /** @internal */\r\n    auxMouseClick(node, event) {\r\n        if (this.props.onAuxMouseClick) {\r\n            this.props.onAuxMouseClick(node, event);\r\n        }\r\n    }\r\n}\r\n/** @internal */\r\nconst DragRectRenderWrapper = (props) => {\r\n    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {\r\n        var _a;\r\n        (_a = props.onRendered) === null || _a === void 0 ? void 0 : _a.call(props);\r\n    }, [props]);\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, props.children));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/Layout.tsx?");

/***/ }),

/***/ "./src/view/Splitter.tsx":
/*!*******************************!*\
  !*** ./src/view/Splitter.tsx ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Splitter\": () => (/* binding */ Splitter)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _DragDrop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../DragDrop */ \"./src/DragDrop.ts\");\n/* harmony import */ var _model_Actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _model_BorderNode__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../model/BorderNode */ \"./src/model/BorderNode.ts\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n\r\n\r\n\r\n\r\n\r\n\r\n/** @internal */\r\nconst Splitter = (props) => {\r\n    const { layout, node, path } = props;\r\n    const pBounds = react__WEBPACK_IMPORTED_MODULE_0__.useRef([]);\r\n    const outlineDiv = react__WEBPACK_IMPORTED_MODULE_0__.useRef(undefined);\r\n    const parentNode = node.getParent();\r\n    const onMouseDown = (event) => {\r\n        _DragDrop__WEBPACK_IMPORTED_MODULE_1__.DragDrop.instance.setGlassCursorOverride(node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ ? \"ns-resize\" : \"ew-resize\");\r\n        _DragDrop__WEBPACK_IMPORTED_MODULE_1__.DragDrop.instance.startDrag(event, onDragStart, onDragMove, onDragEnd, onDragCancel, undefined, undefined, layout.getCurrentDocument(), layout.getRootDiv());\r\n        pBounds.current = parentNode._getSplitterBounds(node, true);\r\n        const rootdiv = layout.getRootDiv();\r\n        outlineDiv.current = layout.getCurrentDocument().createElement(\"div\");\r\n        outlineDiv.current.style.position = \"absolute\";\r\n        outlineDiv.current.className = layout.getClassName(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__SPLITTER_DRAG);\r\n        outlineDiv.current.style.cursor = node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ ? \"ns-resize\" : \"ew-resize\";\r\n        const r = node.getRect();\r\n        if (node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.VERT && r.width < 2) {\r\n            r.width = 2;\r\n        }\r\n        else if (node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ && r.height < 2) {\r\n            r.height = 2;\r\n        }\r\n        r.positionElement(outlineDiv.current);\r\n        rootdiv.appendChild(outlineDiv.current);\r\n    };\r\n    const onDragCancel = (wasDragging) => {\r\n        const rootdiv = layout.getRootDiv();\r\n        rootdiv.removeChild(outlineDiv.current);\r\n    };\r\n    const onDragStart = () => {\r\n        return true;\r\n    };\r\n    const onDragMove = (event) => {\r\n        const clientRect = layout.getDomRect();\r\n        const pos = {\r\n            x: event.clientX - clientRect.left,\r\n            y: event.clientY - clientRect.top,\r\n        };\r\n        if (outlineDiv) {\r\n            if (node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ) {\r\n                outlineDiv.current.style.top = getBoundPosition(pos.y - 4) + \"px\";\r\n            }\r\n            else {\r\n                outlineDiv.current.style.left = getBoundPosition(pos.x - 4) + \"px\";\r\n            }\r\n        }\r\n        if (layout.isRealtimeResize()) {\r\n            updateLayout();\r\n        }\r\n    };\r\n    const updateLayout = () => {\r\n        let value = 0;\r\n        if (outlineDiv) {\r\n            if (node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ) {\r\n                value = outlineDiv.current.offsetTop;\r\n            }\r\n            else {\r\n                value = outlineDiv.current.offsetLeft;\r\n            }\r\n        }\r\n        if (parentNode instanceof _model_BorderNode__WEBPACK_IMPORTED_MODULE_3__.BorderNode) {\r\n            const pos = parentNode._calculateSplit(node, value);\r\n            layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.adjustBorderSplit(node.getParent().getId(), pos));\r\n        }\r\n        else {\r\n            const splitSpec = parentNode._calculateSplit(node, value);\r\n            if (splitSpec !== undefined) {\r\n                layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.adjustSplit(splitSpec));\r\n            }\r\n        }\r\n    };\r\n    const onDragEnd = () => {\r\n        updateLayout();\r\n        const rootdiv = layout.getRootDiv();\r\n        rootdiv.removeChild(outlineDiv.current);\r\n    };\r\n    const getBoundPosition = (p) => {\r\n        const bounds = pBounds.current;\r\n        let rtn = p;\r\n        if (p < bounds[0]) {\r\n            rtn = bounds[0];\r\n        }\r\n        if (p > bounds[1]) {\r\n            rtn = bounds[1];\r\n        }\r\n        return rtn;\r\n    };\r\n    const cm = layout.getClassName;\r\n    let r = node.getRect();\r\n    const style = r.styleWithPosition({\r\n        cursor: node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ ? \"ns-resize\" : \"ew-resize\",\r\n    });\r\n    let className = cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__SPLITTER) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__SPLITTER_ + node.getOrientation().getName());\r\n    if (parentNode instanceof _model_BorderNode__WEBPACK_IMPORTED_MODULE_3__.BorderNode) {\r\n        className += \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__SPLITTER_BORDER);\r\n    }\r\n    else {\r\n        if (node.getModel().getMaximizedTabset() !== undefined) {\r\n            style.display = \"none\";\r\n        }\r\n    }\r\n    const extra = node.getModel().getSplitterExtra();\r\n    if (extra === 0) {\r\n        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { style: style, \"data-layout-path\": path, className: className, onTouchStart: onMouseDown, onMouseDown: onMouseDown }));\r\n    }\r\n    else {\r\n        // add extended transparent div for hit testing\r\n        // extends forward only, so as not to interfere with scrollbars\r\n        let r2 = r.clone();\r\n        r2.x = 0;\r\n        r2.y = 0;\r\n        if (node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.VERT) {\r\n            r2.width += extra;\r\n        }\r\n        else {\r\n            r2.height += extra;\r\n        }\r\n        const style2 = r2.styleWithPosition({\r\n            cursor: node.getOrientation() === _Orientation__WEBPACK_IMPORTED_MODULE_4__.Orientation.HORZ ? \"ns-resize\" : \"ew-resize\"\r\n        });\r\n        const className2 = cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__SPLITTER_EXTRA);\r\n        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { style: style, \"data-layout-path\": path, className: className },\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { style: style2, className: className2, onTouchStart: onMouseDown, onMouseDown: onMouseDown })));\r\n    }\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/Splitter.tsx?");

/***/ }),

/***/ "./src/view/Tab.tsx":
/*!**************************!*\
  !*** ./src/view/Tab.tsx ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Tab\": () => (/* binding */ Tab)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _model_Actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _model_TabSetNode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/TabSetNode */ \"./src/model/TabSetNode.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _ErrorBoundary__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ErrorBoundary */ \"./src/view/ErrorBoundary.tsx\");\n/* harmony import */ var _I18nLabel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../I18nLabel */ \"./src/I18nLabel.ts\");\n/* harmony import */ var _model_BorderNode__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../model/BorderNode */ \"./src/model/BorderNode.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Utils */ \"./src/view/Utils.tsx\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/** @internal */\r\nconst Tab = (props) => {\r\n    const { layout, selected, node, factory, path } = props;\r\n    const [renderComponent, setRenderComponent] = react__WEBPACK_IMPORTED_MODULE_0__.useState(!props.node.isEnableRenderOnDemand() || props.selected);\r\n    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {\r\n        if (!renderComponent && selected) {\r\n            // load on demand\r\n            // console.log(\"load on demand: \" + node.getName());\r\n            setRenderComponent(true);\r\n        }\r\n    });\r\n    const onMouseDown = () => {\r\n        const parent = node.getParent();\r\n        if (parent.getType() === _model_TabSetNode__WEBPACK_IMPORTED_MODULE_2__.TabSetNode.TYPE) {\r\n            if (!parent.isActive()) {\r\n                layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_1__.Actions.setActiveTabset(parent.getId()));\r\n            }\r\n        }\r\n    };\r\n    const cm = layout.getClassName;\r\n    const useVisibility = node.getModel().isUseVisibility();\r\n    const parentNode = node.getParent();\r\n    const style = node._styleWithPosition();\r\n    if (!selected) {\r\n        (0,_Utils__WEBPACK_IMPORTED_MODULE_7__.hideElement)(style, useVisibility);\r\n    }\r\n    if (parentNode instanceof _model_TabSetNode__WEBPACK_IMPORTED_MODULE_2__.TabSetNode) {\r\n        if (node.getModel().getMaximizedTabset() !== undefined && !parentNode.isMaximized()) {\r\n            (0,_Utils__WEBPACK_IMPORTED_MODULE_7__.hideElement)(style, useVisibility);\r\n        }\r\n    }\r\n    let child;\r\n    if (renderComponent) {\r\n        child = factory(node);\r\n    }\r\n    let className = cm(_Types__WEBPACK_IMPORTED_MODULE_3__.CLASSES.FLEXLAYOUT__TAB);\r\n    if (parentNode instanceof _model_BorderNode__WEBPACK_IMPORTED_MODULE_6__.BorderNode) {\r\n        className += \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_3__.CLASSES.FLEXLAYOUT__TAB_BORDER);\r\n        className += \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_3__.CLASSES.FLEXLAYOUT__TAB_BORDER_ + parentNode.getLocation().getName());\r\n    }\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: className, \"data-layout-path\": path, onMouseDown: onMouseDown, onTouchStart: onMouseDown, style: style },\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ErrorBoundary__WEBPACK_IMPORTED_MODULE_4__.ErrorBoundary, { message: props.layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_5__.I18nLabel.Error_rendering_component) },\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, child))));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/Tab.tsx?");

/***/ }),

/***/ "./src/view/TabButton.tsx":
/*!********************************!*\
  !*** ./src/view/TabButton.tsx ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"TabButton\": () => (/* binding */ TabButton)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _I18nLabel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../I18nLabel */ \"./src/I18nLabel.ts\");\n/* harmony import */ var _model_Actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Rect */ \"./src/Rect.ts\");\n/* harmony import */ var _model_ICloseType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model/ICloseType */ \"./src/model/ICloseType.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Utils */ \"./src/view/Utils.tsx\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/** @internal */\r\nconst TabButton = (props) => {\r\n    const { layout, node, selected, iconFactory, titleFactory, icons, path } = props;\r\n    const selfRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const contentRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const onMouseDown = (event) => {\r\n        if (!(0,_Utils__WEBPACK_IMPORTED_MODULE_6__.isAuxMouseEvent)(event) && !layout.getEditingTab()) {\r\n            layout.dragStart(event, undefined, node, node.isEnableDrag(), onClick, onDoubleClick);\r\n        }\r\n    };\r\n    const onAuxMouseClick = (event) => {\r\n        if ((0,_Utils__WEBPACK_IMPORTED_MODULE_6__.isAuxMouseEvent)(event)) {\r\n            layout.auxMouseClick(node, event);\r\n        }\r\n    };\r\n    const onContextMenu = (event) => {\r\n        layout.showContextMenu(node, event);\r\n    };\r\n    const onClick = () => {\r\n        layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.selectTab(node.getId()));\r\n    };\r\n    const onDoubleClick = (event) => {\r\n        if (node.isEnableRename()) {\r\n            onRename();\r\n        }\r\n    };\r\n    const onRename = () => {\r\n        layout.setEditingTab(node);\r\n        layout.getCurrentDocument().body.addEventListener(\"mousedown\", onEndEdit);\r\n        layout.getCurrentDocument().body.addEventListener(\"touchstart\", onEndEdit);\r\n    };\r\n    const onEndEdit = (event) => {\r\n        if (event.target !== contentRef.current) {\r\n            layout.getCurrentDocument().body.removeEventListener(\"mousedown\", onEndEdit);\r\n            layout.getCurrentDocument().body.removeEventListener(\"touchstart\", onEndEdit);\r\n            layout.setEditingTab(undefined);\r\n        }\r\n    };\r\n    const isClosable = () => {\r\n        const closeType = node.getCloseType();\r\n        if (selected || closeType === _model_ICloseType__WEBPACK_IMPORTED_MODULE_4__.ICloseType.Always) {\r\n            return true;\r\n        }\r\n        if (closeType === _model_ICloseType__WEBPACK_IMPORTED_MODULE_4__.ICloseType.Visible) {\r\n            // not selected but x should be visible due to hover\r\n            if (window.matchMedia && window.matchMedia(\"(hover: hover) and (pointer: fine)\").matches) {\r\n                return true;\r\n            }\r\n        }\r\n        return false;\r\n    };\r\n    const onClose = (event) => {\r\n        if (isClosable()) {\r\n            layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.deleteTab(node.getId()));\r\n        }\r\n        else {\r\n            onClick();\r\n        }\r\n    };\r\n    const onCloseMouseDown = (event) => {\r\n        event.stopPropagation();\r\n    };\r\n    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {\r\n        updateRect();\r\n        if (layout.getEditingTab() === node) {\r\n            contentRef.current.select();\r\n        }\r\n    });\r\n    const updateRect = () => {\r\n        // record position of tab in node\r\n        const layoutRect = layout.getDomRect();\r\n        const r = selfRef.current.getBoundingClientRect();\r\n        node._setTabRect(new _Rect__WEBPACK_IMPORTED_MODULE_3__.Rect(r.left - layoutRect.left, r.top - layoutRect.top, r.width, r.height));\r\n    };\r\n    const onTextBoxMouseDown = (event) => {\r\n        // console.log(\"onTextBoxMouseDown\");\r\n        event.stopPropagation();\r\n    };\r\n    const onTextBoxKeyPress = (event) => {\r\n        // console.log(event, event.keyCode);\r\n        if (event.keyCode === 27) {\r\n            // esc\r\n            layout.setEditingTab(undefined);\r\n        }\r\n        else if (event.keyCode === 13) {\r\n            // enter\r\n            layout.setEditingTab(undefined);\r\n            layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.renameTab(node.getId(), event.target.value));\r\n        }\r\n    };\r\n    const cm = layout.getClassName;\r\n    const parentNode = node.getParent();\r\n    let baseClassName = _Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__TAB_BUTTON;\r\n    let classNames = cm(baseClassName);\r\n    classNames += \" \" + cm(baseClassName + \"_\" + parentNode.getTabLocation());\r\n    if (selected) {\r\n        classNames += \" \" + cm(baseClassName + \"--selected\");\r\n    }\r\n    else {\r\n        classNames += \" \" + cm(baseClassName + \"--unselected\");\r\n    }\r\n    if (node.getClassName() !== undefined) {\r\n        classNames += \" \" + node.getClassName();\r\n    }\r\n    const renderState = (0,_Utils__WEBPACK_IMPORTED_MODULE_6__.getRenderStateEx)(layout, node, iconFactory, titleFactory);\r\n    let content = renderState.content ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__TAB_BUTTON_CONTENT) }, renderState.content)) : null;\r\n    const leading = renderState.leading ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__TAB_BUTTON_LEADING) }, renderState.leading)) : null;\r\n    if (layout.getEditingTab() === node) {\r\n        content = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"input\", { ref: contentRef, className: cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__TAB_BUTTON_TEXTBOX), \"data-layout-path\": path + \"/textbox\", type: \"text\", autoFocus: true, defaultValue: node.getName(), onKeyDown: onTextBoxKeyPress, onMouseDown: onTextBoxMouseDown, onTouchStart: onTextBoxMouseDown }));\r\n    }\r\n    if (node.isEnableClose()) {\r\n        const closeTitle = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_1__.I18nLabel.Close_Tab);\r\n        renderState.buttons.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"close\", \"data-layout-path\": path + \"/button/close\", title: closeTitle, className: cm(_Types__WEBPACK_IMPORTED_MODULE_5__.CLASSES.FLEXLAYOUT__TAB_BUTTON_TRAILING), onMouseDown: onCloseMouseDown, onClick: onClose, onTouchStart: onCloseMouseDown }, (typeof icons.close === \"function\") ? icons.close(node) : icons.close));\r\n    }\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { ref: selfRef, \"data-layout-path\": path, className: classNames, onMouseDown: onMouseDown, onClick: onAuxMouseClick, onAuxClick: onAuxMouseClick, onContextMenu: onContextMenu, onTouchStart: onMouseDown, title: node.getHelpText() },\r\n        leading,\r\n        content,\r\n        renderState.buttons));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/TabButton.tsx?");

/***/ }),

/***/ "./src/view/TabButtonStamp.tsx":
/*!*************************************!*\
  !*** ./src/view/TabButtonStamp.tsx ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"TabButtonStamp\": () => (/* binding */ TabButtonStamp)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Utils */ \"./src/view/Utils.tsx\");\n\r\n\r\n\r\n/** @internal */\r\nconst TabButtonStamp = (props) => {\r\n    const { layout, node, iconFactory, titleFactory } = props;\r\n    const selfRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const cm = layout.getClassName;\r\n    let classNames = cm(_Types__WEBPACK_IMPORTED_MODULE_1__.CLASSES.FLEXLAYOUT__TAB_BUTTON_STAMP);\r\n    const renderState = (0,_Utils__WEBPACK_IMPORTED_MODULE_2__.getRenderStateEx)(layout, node, iconFactory, titleFactory);\r\n    let content = renderState.content ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_1__.CLASSES.FLEXLAYOUT__TAB_BUTTON_CONTENT) }, renderState.content))\r\n        : node._getNameForOverflowMenu();\r\n    const leading = renderState.leading ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_1__.CLASSES.FLEXLAYOUT__TAB_BUTTON_LEADING) }, renderState.leading)) : null;\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { ref: selfRef, className: classNames, title: node.getHelpText() },\r\n        leading,\r\n        content));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/TabButtonStamp.tsx?");

/***/ }),

/***/ "./src/view/TabFloating.tsx":
/*!**********************************!*\
  !*** ./src/view/TabFloating.tsx ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"TabFloating\": () => (/* binding */ TabFloating)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _model_Actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _model_TabSetNode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/TabSetNode */ \"./src/model/TabSetNode.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _I18nLabel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../I18nLabel */ \"./src/I18nLabel.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Utils */ \"./src/view/Utils.tsx\");\n\r\n\r\n\r\n\r\n\r\n\r\n/** @internal */\r\nconst TabFloating = (props) => {\r\n    const { layout, selected, node, path } = props;\r\n    const showPopout = () => {\r\n        if (node.getWindow()) {\r\n            node.getWindow().focus();\r\n        }\r\n    };\r\n    const dockPopout = () => {\r\n        layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_1__.Actions.unFloatTab(node.getId()));\r\n    };\r\n    const onMouseDown = () => {\r\n        const parent = node.getParent();\r\n        if (parent.getType() === _model_TabSetNode__WEBPACK_IMPORTED_MODULE_2__.TabSetNode.TYPE) {\r\n            if (!parent.isActive()) {\r\n                layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_1__.Actions.setActiveTabset(parent.getId()));\r\n            }\r\n        }\r\n    };\r\n    const onClickFocus = (event) => {\r\n        event.preventDefault();\r\n        showPopout();\r\n    };\r\n    const onClickDock = (event) => {\r\n        event.preventDefault();\r\n        dockPopout();\r\n    };\r\n    const cm = layout.getClassName;\r\n    const parentNode = node.getParent();\r\n    const style = node._styleWithPosition();\r\n    if (!selected) {\r\n        (0,_Utils__WEBPACK_IMPORTED_MODULE_5__.hideElement)(style, node.getModel().isUseVisibility());\r\n    }\r\n    if (parentNode instanceof _model_TabSetNode__WEBPACK_IMPORTED_MODULE_2__.TabSetNode) {\r\n        if (node.getModel().getMaximizedTabset() !== undefined && !parentNode.isMaximized()) {\r\n            (0,_Utils__WEBPACK_IMPORTED_MODULE_5__.hideElement)(style, node.getModel().isUseVisibility());\r\n        }\r\n    }\r\n    const message = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_4__.I18nLabel.Floating_Window_Message);\r\n    const showMessage = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_4__.I18nLabel.Floating_Window_Show_Window);\r\n    const dockMessage = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_4__.I18nLabel.Floating_Window_Dock_Window);\r\n    const customRenderCallback = layout.getOnRenderFloatingTabPlaceholder();\r\n    if (customRenderCallback) {\r\n        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_3__.CLASSES.FLEXLAYOUT__TAB_FLOATING), onMouseDown: onMouseDown, onTouchStart: onMouseDown, style: style }, customRenderCallback(dockPopout, showPopout)));\r\n    }\r\n    else {\r\n        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_3__.CLASSES.FLEXLAYOUT__TAB_FLOATING), \"data-layout-path\": path, onMouseDown: onMouseDown, onTouchStart: onMouseDown, style: style },\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_3__.CLASSES.FLEXLAYOUT__TAB_FLOATING_INNER) },\r\n                react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", null, message),\r\n                react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", null,\r\n                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"a\", { href: \"#\", onClick: onClickFocus }, showMessage)),\r\n                react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", null,\r\n                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"a\", { href: \"#\", onClick: onClickDock }, dockMessage)))));\r\n    }\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/TabFloating.tsx?");

/***/ }),

/***/ "./src/view/TabOverflowHook.tsx":
/*!**************************************!*\
  !*** ./src/view/TabOverflowHook.tsx ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"useTabOverflow\": () => (/* binding */ useTabOverflow)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Rect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Rect */ \"./src/Rect.ts\");\n/* harmony import */ var _model_TabSetNode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/TabSetNode */ \"./src/model/TabSetNode.ts\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n\r\n\r\n\r\n\r\n/** @internal */\r\nconst useTabOverflow = (node, orientation, toolbarRef, stickyButtonsRef) => {\r\n    const firstRender = react__WEBPACK_IMPORTED_MODULE_0__.useRef(true);\r\n    const tabsTruncated = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);\r\n    const lastRect = react__WEBPACK_IMPORTED_MODULE_0__.useRef(new _Rect__WEBPACK_IMPORTED_MODULE_1__.Rect(0, 0, 0, 0));\r\n    const selfRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const [position, setPosition] = react__WEBPACK_IMPORTED_MODULE_0__.useState(0);\r\n    const userControlledLeft = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);\r\n    const [hiddenTabs, setHiddenTabs] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);\r\n    const lastHiddenCount = react__WEBPACK_IMPORTED_MODULE_0__.useRef(0);\r\n    // if selected node or tabset/border rectangle change then unset usercontrolled (so selected tab will be kept in view)\r\n    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {\r\n        userControlledLeft.current = false;\r\n    }, [node.getSelectedNode(), node.getRect().width, node.getRect().height]);\r\n    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {\r\n        updateVisibleTabs();\r\n    });\r\n    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {\r\n        const instance = selfRef.current;\r\n        instance.addEventListener('wheel', onWheel, { passive: false });\r\n        return () => {\r\n            instance.removeEventListener('wheel', onWheel);\r\n        };\r\n    }, []);\r\n    // needed to prevent default mouse wheel over tabset/border (cannot do with react event?)\r\n    const onWheel = (event) => {\r\n        event.preventDefault();\r\n    };\r\n    const getNear = (rect) => {\r\n        if (orientation === _Orientation__WEBPACK_IMPORTED_MODULE_3__.Orientation.HORZ) {\r\n            return rect.x;\r\n        }\r\n        else {\r\n            return rect.y;\r\n        }\r\n    };\r\n    const getFar = (rect) => {\r\n        if (orientation === _Orientation__WEBPACK_IMPORTED_MODULE_3__.Orientation.HORZ) {\r\n            return rect.getRight();\r\n        }\r\n        else {\r\n            return rect.getBottom();\r\n        }\r\n    };\r\n    const getSize = (rect) => {\r\n        if (orientation === _Orientation__WEBPACK_IMPORTED_MODULE_3__.Orientation.HORZ) {\r\n            return rect.width;\r\n        }\r\n        else {\r\n            return rect.height;\r\n        }\r\n    };\r\n    const updateVisibleTabs = () => {\r\n        const tabMargin = 2;\r\n        if (firstRender.current === true) {\r\n            tabsTruncated.current = false;\r\n        }\r\n        const nodeRect = node instanceof _model_TabSetNode__WEBPACK_IMPORTED_MODULE_2__.TabSetNode ? node.getRect() : node.getTabHeaderRect();\r\n        let lastChild = node.getChildren()[node.getChildren().length - 1];\r\n        const stickyButtonsSize = stickyButtonsRef.current === null ? 0 : getSize(stickyButtonsRef.current.getBoundingClientRect());\r\n        if (firstRender.current === true ||\r\n            (lastHiddenCount.current === 0 && hiddenTabs.length !== 0) ||\r\n            nodeRect.width !== lastRect.current.width || // incase rect changed between first render and second\r\n            nodeRect.height !== lastRect.current.height) {\r\n            lastHiddenCount.current = hiddenTabs.length;\r\n            lastRect.current = nodeRect;\r\n            const enabled = node instanceof _model_TabSetNode__WEBPACK_IMPORTED_MODULE_2__.TabSetNode ? node.isEnableTabStrip() === true : true;\r\n            let endPos = getFar(nodeRect) - stickyButtonsSize;\r\n            if (toolbarRef.current !== null) {\r\n                endPos -= getSize(toolbarRef.current.getBoundingClientRect());\r\n            }\r\n            if (enabled && node.getChildren().length > 0) {\r\n                if (hiddenTabs.length === 0 && position === 0 && getFar(lastChild.getTabRect()) + tabMargin < endPos) {\r\n                    return; // nothing to do all tabs are shown in available space\r\n                }\r\n                let shiftPos = 0;\r\n                const selectedTab = node.getSelectedNode();\r\n                if (selectedTab && !userControlledLeft.current) {\r\n                    const selectedRect = selectedTab.getTabRect();\r\n                    const selectedStart = getNear(selectedRect) - tabMargin;\r\n                    const selectedEnd = getFar(selectedRect) + tabMargin;\r\n                    // when selected tab is larger than available space then align left\r\n                    if (getSize(selectedRect) + 2 * tabMargin >= endPos - getNear(nodeRect)) {\r\n                        shiftPos = getNear(nodeRect) - selectedStart;\r\n                    }\r\n                    else {\r\n                        if (selectedEnd > endPos || selectedStart < getNear(nodeRect)) {\r\n                            if (selectedStart < getNear(nodeRect)) {\r\n                                shiftPos = getNear(nodeRect) - selectedStart;\r\n                            }\r\n                            // use second if statement to prevent tab moving back then forwards if not enough space for single tab\r\n                            if (selectedEnd + shiftPos > endPos) {\r\n                                shiftPos = endPos - selectedEnd;\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n                const extraSpace = Math.max(0, endPos - (getFar(lastChild.getTabRect()) + tabMargin + shiftPos));\r\n                const newPosition = Math.min(0, position + shiftPos + extraSpace);\r\n                // find hidden tabs\r\n                const diff = newPosition - position;\r\n                const hidden = [];\r\n                for (let i = 0; i < node.getChildren().length; i++) {\r\n                    const child = node.getChildren()[i];\r\n                    if (getNear(child.getTabRect()) + diff < getNear(nodeRect) || getFar(child.getTabRect()) + diff > endPos) {\r\n                        hidden.push({ node: child, index: i });\r\n                    }\r\n                }\r\n                if (hidden.length > 0) {\r\n                    tabsTruncated.current = true;\r\n                }\r\n                firstRender.current = false; // need to do a second render\r\n                setHiddenTabs(hidden);\r\n                setPosition(newPosition);\r\n            }\r\n        }\r\n        else {\r\n            firstRender.current = true;\r\n        }\r\n    };\r\n    const onMouseWheel = (event) => {\r\n        let delta = 0;\r\n        if (Math.abs(event.deltaX) > Math.abs(event.deltaY)) {\r\n            delta = -event.deltaX;\r\n        }\r\n        else {\r\n            delta = -event.deltaY;\r\n        }\r\n        if (event.deltaMode === 1) {\r\n            // DOM_DELTA_LINE\t0x01\tThe delta values are specified in lines.\r\n            delta *= 40;\r\n        }\r\n        setPosition(position + delta);\r\n        userControlledLeft.current = true;\r\n        event.stopPropagation();\r\n    };\r\n    return { selfRef, position, userControlledLeft, hiddenTabs, onMouseWheel, tabsTruncated: tabsTruncated.current };\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/TabOverflowHook.tsx?");

/***/ }),

/***/ "./src/view/TabSet.tsx":
/*!*****************************!*\
  !*** ./src/view/TabSet.tsx ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"TabSet\": () => (/* binding */ TabSet)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _I18nLabel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../I18nLabel */ \"./src/I18nLabel.ts\");\n/* harmony import */ var _model_Actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/Actions */ \"./src/model/Actions.ts\");\n/* harmony import */ var _PopupMenu__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../PopupMenu */ \"./src/PopupMenu.tsx\");\n/* harmony import */ var _TabButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./TabButton */ \"./src/view/TabButton.tsx\");\n/* harmony import */ var _TabOverflowHook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./TabOverflowHook */ \"./src/view/TabOverflowHook.tsx\");\n/* harmony import */ var _Orientation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Orientation */ \"./src/Orientation.ts\");\n/* harmony import */ var _Types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Types */ \"./src/Types.ts\");\n/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Utils */ \"./src/view/Utils.tsx\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/** @internal */\r\nconst TabSet = (props) => {\r\n    const { node, layout, iconFactory, titleFactory, icons, path } = props;\r\n    const toolbarRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const overflowbuttonRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const tabbarInnerRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const stickyButtonsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);\r\n    const { selfRef, position, userControlledLeft, hiddenTabs, onMouseWheel, tabsTruncated } = (0,_TabOverflowHook__WEBPACK_IMPORTED_MODULE_5__.useTabOverflow)(node, _Orientation__WEBPACK_IMPORTED_MODULE_6__.Orientation.HORZ, toolbarRef, stickyButtonsRef);\r\n    const onOverflowClick = (event) => {\r\n        const callback = layout.getShowOverflowMenu();\r\n        if (callback !== undefined) {\r\n            callback(node, event, hiddenTabs, onOverflowItemSelect);\r\n        }\r\n        else {\r\n            const element = overflowbuttonRef.current;\r\n            (0,_PopupMenu__WEBPACK_IMPORTED_MODULE_3__.showPopup)(element, hiddenTabs, onOverflowItemSelect, layout, iconFactory, titleFactory);\r\n        }\r\n        event.stopPropagation();\r\n    };\r\n    const onOverflowItemSelect = (item) => {\r\n        layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.selectTab(item.node.getId()));\r\n        userControlledLeft.current = false;\r\n    };\r\n    const onMouseDown = (event) => {\r\n        if (!(0,_Utils__WEBPACK_IMPORTED_MODULE_8__.isAuxMouseEvent)(event)) {\r\n            let name = node.getName();\r\n            if (name === undefined) {\r\n                name = \"\";\r\n            }\r\n            else {\r\n                name = \": \" + name;\r\n            }\r\n            layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.setActiveTabset(node.getId()));\r\n            if (!layout.getEditingTab()) {\r\n                const message = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_1__.I18nLabel.Move_Tabset, name);\r\n                if (node.getModel().getMaximizedTabset() !== undefined) {\r\n                    layout.dragStart(event, message, node, false, (event2) => undefined, onDoubleClick);\r\n                }\r\n                else {\r\n                    layout.dragStart(event, message, node, node.isEnableDrag(), (event2) => undefined, onDoubleClick);\r\n                }\r\n            }\r\n        }\r\n    };\r\n    const onAuxMouseClick = (event) => {\r\n        if ((0,_Utils__WEBPACK_IMPORTED_MODULE_8__.isAuxMouseEvent)(event)) {\r\n            layout.auxMouseClick(node, event);\r\n        }\r\n    };\r\n    const onContextMenu = (event) => {\r\n        layout.showContextMenu(node, event);\r\n    };\r\n    const onInterceptMouseDown = (event) => {\r\n        event.stopPropagation();\r\n    };\r\n    const onMaximizeToggle = (event) => {\r\n        if (node.canMaximize()) {\r\n            layout.maximize(node);\r\n        }\r\n        event.stopPropagation();\r\n    };\r\n    const onClose = (event) => {\r\n        layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.deleteTabset(node.getId()));\r\n        event.stopPropagation();\r\n    };\r\n    const onFloatTab = (event) => {\r\n        if (selectedTabNode !== undefined) {\r\n            layout.doAction(_model_Actions__WEBPACK_IMPORTED_MODULE_2__.Actions.floatTab(selectedTabNode.getId()));\r\n        }\r\n        event.stopPropagation();\r\n    };\r\n    const onDoubleClick = (event) => {\r\n        if (node.canMaximize()) {\r\n            layout.maximize(node);\r\n        }\r\n    };\r\n    // Start Render\r\n    const cm = layout.getClassName;\r\n    // tabbar inner can get shifted left via tab rename, this resets scrollleft to 0\r\n    if (tabbarInnerRef.current !== null && tabbarInnerRef.current.scrollLeft !== 0) {\r\n        tabbarInnerRef.current.scrollLeft = 0;\r\n    }\r\n    const selectedTabNode = node.getSelectedNode();\r\n    let style = node._styleWithPosition();\r\n    if (node.getModel().getMaximizedTabset() !== undefined && !node.isMaximized()) {\r\n        (0,_Utils__WEBPACK_IMPORTED_MODULE_8__.hideElement)(style, node.getModel().isUseVisibility());\r\n    }\r\n    const tabs = [];\r\n    if (node.isEnableTabStrip()) {\r\n        for (let i = 0; i < node.getChildren().length; i++) {\r\n            const child = node.getChildren()[i];\r\n            let isSelected = node.getSelected() === i;\r\n            tabs.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TabButton__WEBPACK_IMPORTED_MODULE_4__.TabButton, { layout: layout, node: child, path: path + \"/tb\" + i, key: child.getId(), selected: isSelected, iconFactory: iconFactory, titleFactory: titleFactory, icons: icons }));\r\n            if (i < node.getChildren().length - 1) {\r\n                tabs.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"divider\" + i, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_TAB_DIVIDER) }));\r\n            }\r\n        }\r\n    }\r\n    const showHeader = node.getName() !== undefined;\r\n    let stickyButtons = [];\r\n    let buttons = [];\r\n    let headerButtons = [];\r\n    // allow customization of header contents and buttons\r\n    const renderState = { headerContent: node.getName(), stickyButtons, buttons, headerButtons };\r\n    layout.customizeTabSet(node, renderState);\r\n    const headerContent = renderState.headerContent;\r\n    stickyButtons = renderState.stickyButtons;\r\n    buttons = renderState.buttons;\r\n    headerButtons = renderState.headerButtons;\r\n    if (stickyButtons.length > 0) {\r\n        if (tabsTruncated) {\r\n            buttons = [...stickyButtons, ...buttons];\r\n        }\r\n        else {\r\n            tabs.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { ref: stickyButtonsRef, key: \"sticky_buttons_container\", onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown, onDragStart: (e) => { e.preventDefault(); }, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_STICKY_BUTTONS_CONTAINER) }, stickyButtons));\r\n        }\r\n    }\r\n    let toolbar;\r\n    if (hiddenTabs.length > 0) {\r\n        const overflowTitle = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_1__.I18nLabel.Overflow_Menu_Tooltip);\r\n        let overflowContent;\r\n        if (typeof icons.more === \"function\") {\r\n            overflowContent = icons.more(node, hiddenTabs);\r\n        }\r\n        else {\r\n            overflowContent = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,\r\n                icons.more,\r\n                react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_BUTTON_OVERFLOW_COUNT) }, hiddenTabs.length)));\r\n        }\r\n        buttons.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"button\", { key: \"overflowbutton\", \"data-layout-path\": path + \"/button/overflow\", ref: overflowbuttonRef, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_BUTTON_OVERFLOW), title: overflowTitle, onClick: onOverflowClick, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, overflowContent));\r\n    }\r\n    if (selectedTabNode !== undefined && layout.isSupportsPopout() && selectedTabNode.isEnableFloat() && !selectedTabNode.isFloating()) {\r\n        const floatTitle = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_1__.I18nLabel.Float_Tab);\r\n        buttons.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"button\", { key: \"float\", \"data-layout-path\": path + \"/button/float\", title: floatTitle, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON_FLOAT), onClick: onFloatTab, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, (typeof icons.popout === \"function\") ? icons.popout(selectedTabNode) : icons.popout));\r\n    }\r\n    if (node.canMaximize()) {\r\n        const minTitle = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_1__.I18nLabel.Restore);\r\n        const maxTitle = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_1__.I18nLabel.Maximize);\r\n        const btns = showHeader ? headerButtons : buttons;\r\n        btns.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"button\", { key: \"max\", \"data-layout-path\": path + \"/button/max\", title: node.isMaximized() ? minTitle : maxTitle, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON_ + (node.isMaximized() ? \"max\" : \"min\")), onClick: onMaximizeToggle, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, node.isMaximized() ?\r\n            (typeof icons.restore === \"function\") ? icons.restore(node) : icons.restore :\r\n            (typeof icons.maximize === \"function\") ? icons.maximize(node) : icons.maximize));\r\n    }\r\n    if (!node.isMaximized() && node.isEnableClose()) {\r\n        const title = layout.i18nName(_I18nLabel__WEBPACK_IMPORTED_MODULE_1__.I18nLabel.Close_Tabset);\r\n        const btns = showHeader ? headerButtons : buttons;\r\n        btns.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"button\", { key: \"close\", \"data-layout-path\": path + \"/button/close\", title: title, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON_CLOSE), onClick: onClose, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, (typeof icons.closeTabset === \"function\") ? icons.closeTabset(node) : icons.closeTabset));\r\n    }\r\n    toolbar = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"toolbar\", ref: toolbarRef, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR), onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown, onDragStart: (e) => { e.preventDefault(); } }, buttons));\r\n    let header;\r\n    let tabStrip;\r\n    let tabStripClasses = cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_TABBAR_OUTER);\r\n    if (node.getClassNameTabStrip() !== undefined) {\r\n        tabStripClasses += \" \" + node.getClassNameTabStrip();\r\n    }\r\n    tabStripClasses += \" \" + _Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_TABBAR_OUTER_ + node.getTabLocation();\r\n    if (node.isActive() && !showHeader) {\r\n        tabStripClasses += \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_SELECTED);\r\n    }\r\n    if (node.isMaximized() && !showHeader) {\r\n        tabStripClasses += \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_MAXIMIZED);\r\n    }\r\n    if (showHeader) {\r\n        const headerToolbar = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { key: \"toolbar\", ref: toolbarRef, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TAB_TOOLBAR), onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown, onDragStart: (e) => { e.preventDefault(); } }, headerButtons));\r\n        let tabHeaderClasses = cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_HEADER);\r\n        if (node.isActive()) {\r\n            tabHeaderClasses += \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_SELECTED);\r\n        }\r\n        if (node.isMaximized()) {\r\n            tabHeaderClasses += \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_MAXIMIZED);\r\n        }\r\n        if (node.getClassNameHeader() !== undefined) {\r\n            tabHeaderClasses += \" \" + node.getClassNameHeader();\r\n        }\r\n        header = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: tabHeaderClasses, style: { height: node.getHeaderHeight() + \"px\" }, \"data-layout-path\": path + \"/header\", onMouseDown: onMouseDown, onContextMenu: onContextMenu, onClick: onAuxMouseClick, onAuxClick: onAuxMouseClick, onTouchStart: onMouseDown },\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_HEADER_CONTENT) }, headerContent),\r\n            headerToolbar));\r\n    }\r\n    const tabStripStyle = { height: node.getTabStripHeight() + \"px\" };\r\n    tabStrip = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: tabStripClasses, style: tabStripStyle, \"data-layout-path\": path + \"/tabstrip\", onMouseDown: onMouseDown, onContextMenu: onContextMenu, onClick: onAuxMouseClick, onAuxClick: onAuxMouseClick, onTouchStart: onMouseDown },\r\n        react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { ref: tabbarInnerRef, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_TABBAR_INNER) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_TABBAR_INNER_ + node.getTabLocation()) },\r\n            react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { style: { left: position }, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_TABBAR_INNER_TAB_CONTAINER) + \" \" + cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_TABBAR_INNER_TAB_CONTAINER_ + node.getTabLocation()) }, tabs)),\r\n        toolbar));\r\n    style = layout.styleFont(style);\r\n    var placeHolder = undefined;\r\n    if (node.getChildren().length === 0) {\r\n        const placeHolderCallback = layout.getTabSetPlaceHolderCallback();\r\n        if (placeHolderCallback) {\r\n            placeHolder = placeHolderCallback(node);\r\n        }\r\n    }\r\n    const center = react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET_CONTENT) }, placeHolder);\r\n    var content;\r\n    if (node.getTabLocation() === \"top\") {\r\n        content = react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,\r\n            header,\r\n            tabStrip,\r\n            center);\r\n    }\r\n    else {\r\n        content = react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,\r\n            header,\r\n            center,\r\n            tabStrip);\r\n    }\r\n    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"div\", { ref: selfRef, dir: \"ltr\", \"data-layout-path\": path, style: style, className: cm(_Types__WEBPACK_IMPORTED_MODULE_7__.CLASSES.FLEXLAYOUT__TABSET), onWheel: onMouseWheel }, content));\r\n};\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/TabSet.tsx?");

/***/ }),

/***/ "./src/view/Utils.tsx":
/*!****************************!*\
  !*** ./src/view/Utils.tsx ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"getRenderStateEx\": () => (/* binding */ getRenderStateEx),\n/* harmony export */   \"hideElement\": () => (/* binding */ hideElement),\n/* harmony export */   \"isAuxMouseEvent\": () => (/* binding */ isAuxMouseEvent)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n\r\n/** @internal */\r\nfunction getRenderStateEx(layout, node, iconFactory, titleFactory) {\r\n    let leadingContent = iconFactory ? iconFactory(node) : undefined;\r\n    let titleContent = node.getName();\r\n    let name = node.getName();\r\n    function isTitleObject(obj) {\r\n        return obj.titleContent !== undefined;\r\n    }\r\n    if (titleFactory !== undefined) {\r\n        const titleObj = titleFactory(node);\r\n        if (titleObj !== undefined) {\r\n            if (typeof titleObj === \"string\") {\r\n                titleContent = titleObj;\r\n                name = titleObj;\r\n            }\r\n            else if (isTitleObject(titleObj)) {\r\n                titleContent = titleObj.titleContent;\r\n                name = titleObj.name;\r\n            }\r\n            else {\r\n                titleContent = titleObj;\r\n            }\r\n        }\r\n    }\r\n    if (leadingContent === undefined && node.getIcon() !== undefined) {\r\n        leadingContent = react__WEBPACK_IMPORTED_MODULE_0__.createElement(\"img\", { style: { width: \"1em\", height: \"1em\" }, src: node.getIcon(), alt: \"leadingContent\" });\r\n    }\r\n    let buttons = [];\r\n    // allow customization of leading contents (icon) and contents\r\n    const renderState = { leading: leadingContent, content: titleContent, name, buttons };\r\n    layout.customizeTab(node, renderState);\r\n    node._setRenderedName(renderState.name);\r\n    return renderState;\r\n}\r\n/** @internal */\r\nfunction hideElement(style, useVisibility) {\r\n    if (useVisibility) {\r\n        style.visibility = \"hidden\";\r\n    }\r\n    else {\r\n        style.display = \"none\";\r\n    }\r\n}\r\n/** @internal */\r\nfunction isAuxMouseEvent(event) {\r\n    let auxEvent = false;\r\n    if (event.nativeEvent instanceof MouseEvent) {\r\n        if (event.nativeEvent.button !== 0 || event.ctrlKey || event.altKey || event.metaKey || event.shiftKey) {\r\n            auxEvent = true;\r\n        }\r\n    }\r\n    return auxEvent;\r\n}\r\n\n\n//# sourceURL=webpack://FlexLayout/./src/view/Utils.tsx?");

/***/ }),

/***/ "react":
/*!**************************************************************************************!*\
  !*** external {"root":"React","commonjs":"react","commonjs2":"react","amd":"react"} ***!
  \**************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE_react__;

/***/ }),

/***/ "react-dom":
/*!*****************************************************************************************************!*\
  !*** external {"root":"ReactDOM","commonjs":"react-dom","commonjs2":"react-dom","amd":"react-dom"} ***!
  \*****************************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE_react_dom__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval devtool is used.
/******/ 	var __webpack_exports__ = __webpack_require__("./src/index.ts");
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});