import type { ElementProps, FloatingContext, ReferenceType } from '../types';
type AriaRole = 'tooltip' | 'dialog' | 'alertdialog' | 'menu' | 'listbox' | 'grid' | 'tree';
type ComponentRole = 'select' | 'label' | 'combobox';
export interface UseRoleProps {
    enabled?: boolean;
    role?: AriaRole | ComponentRole;
}
/**
 * Adds base screen reader props to the reference and floating elements for a
 * given floating element `role`.
 * @see https://floating-ui.com/docs/useRole
 */
export declare function useRole<RT extends ReferenceType = ReferenceType>(context: FloatingContext<RT>, props?: UseRoleProps): ElementProps;
export {};
