Upgrade Guide
=============

1.x -> 2.0
----------

### React Fluxxor

The React-specific parts of Fluxxor have moved to `fluxxor/react-fluxxor`. This includes

* `FluxMixin` and `StoreWatchMixin`
* The new higher-order components

React Fluxxor is designed to work with React 0.14+, and is designed to work with both `React.createClass`-based components as well as ES6 classes and functions-as-components. Fluxxor now only depends on the `react` package, while React Fluxxor depends on `react-dom`.

### `AppRoot`

React Fluxxor ships with a component called `AppRoot` which provides the flux object passed as its `flux` prop to its immediate children as a prop and down to the rest of the tree as context (similar to `FluxMixin`).

```javascript
const flux = new Fluxxor.Flux(...);

ReactDOM.render(
  <ReactFluxxor.AppRoot flux={flux}><MyApp /></ReactFluxxor.AppRoot>,
  container
);
```

### `StoreWatchMixin`

The API for `StoreWatchMixin` has changed a bit. It now takes an array of stores to watch, followed by an optional `options` object.

**1.x**

```javascript
StoreWatchMixin("store1", "store2")
```

**2.0**

```javascript
const options = { ... };

StoreWatchMixin(["store1", "store2], options)
```

The mixin options can include a `flux` option if you want to specify a `Flux` instance for the mixin to use.

### `FluxProps`

For people not using mixins, `FluxProps` is a higher-order component *and* an ES7 decorator (if you use those) for specifying how to turn data in stores into props for your component. This is recommended over using `StoreWatchMixin`.

**1.x**

```javascript
var MyComponent = React.createClass({
  mixins: [FluxMixin(React), StoreWatchMixin("store1", "store2")],

  getStateFromFlux: function() {
    return {
      someData: this.getFlux().store("store1").getSomeData(),
      someOtherData: this.getFlux().store("store2").getSomeOtherData()
    };
  },

  render: function() {
    return <div>{this.state.someData} and {this.state.someOtherData}</div>;
  }
});
```

**2.0**

```javascript
const MyComponent = ({someData, someOtherData}) => {
  return <div>{someData} and {someOtherData}</div>;
};

const fluxToProps = (flux) => {
  const [ store1, store2 ] = flux.getStores(["store1", "store2"]);
  return {
    someData: store1.getSomeData(),
    someOtherData: store2.getSomeOtherData()
  };
};

export default FluxProps(["store1", "store2"], [options], fluxToProps)(MyComponent);
```

or

```javascript
const fluxToProps = (flux) => {
  const { store1, store2 } = flux.getStores(); // also get individual stores?
  return {
    someData: store1.getSomeData(),
    someOtherData: store2.getSomeOtherData()
  };
};

@FluxProps(["store1", "store2"], [options], fluxToProps)
const MyComponent = ({someData, someOtherData}) => {
  return <div>{someData} and {someOtherData}</div>;
};

export default MyComponent;
```

Now, when `store1` or `store2` change (the first param to `FluxProps` is the same as `StoreWatchMixin`), `fluxToProps` will be called, and the resulting object will be passed as props to `MyComponent`.

##### TODO: this should support shouldComponentUpdate, and passing context, etc.
