"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFocusMerge = void 0;
var solver_1 = require("./solver");
var DOMutils_1 = require("./utils/DOMutils");
var all_affected_1 = require("./utils/all-affected");
var firstFocus_1 = require("./utils/firstFocus");
var getActiveElement_1 = require("./utils/getActiveElement");
var is_1 = require("./utils/is");
var parenting_1 = require("./utils/parenting");
var findAutoFocused = function (autoFocusables) {
    return function (node) { var _a; 
    // @ts-expect-error
    return node.autofocus || !!((_a = (0, is_1.getDataset)(node)) === null || _a === void 0 ? void 0 : _a.autofocus) || autoFocusables.indexOf(node) >= 0; };
};
var reorderNodes = function (srcNodes, dstNodes) {
    var remap = new Map();
    // no Set(dstNodes) for IE11 :(
    dstNodes.forEach(function (entity) { return remap.set(entity.node, entity); });
    // remap to dstNodes
    return srcNodes.map(function (node) { return remap.get(node); }).filter(is_1.isDefined);
};
/**
 * given top node(s) and the last active element return the element to be focused next
 * @param topNode
 * @param lastNode
 */
var getFocusMerge = function (topNode, lastNode) {
    var activeElement = document && (0, getActiveElement_1.getActiveElement)();
    var entries = (0, all_affected_1.getAllAffectedNodes)(topNode).filter(is_1.isNotAGuard);
    var commonParent = (0, parenting_1.getTopCommonParent)(activeElement || topNode, topNode, entries);
    var visibilityCache = new Map();
    var anyFocusable = (0, DOMutils_1.getAllTabbableNodes)(entries, visibilityCache);
    var innerElements = (0, DOMutils_1.getTabbableNodes)(entries, visibilityCache).filter(function (_a) {
        var node = _a.node;
        return (0, is_1.isNotAGuard)(node);
    });
    if (!innerElements[0]) {
        innerElements = anyFocusable;
        if (!innerElements[0]) {
            return undefined;
        }
    }
    var outerNodes = (0, DOMutils_1.getAllTabbableNodes)([commonParent], visibilityCache).map(function (_a) {
        var node = _a.node;
        return node;
    });
    var orderedInnerElements = reorderNodes(outerNodes, innerElements);
    var innerNodes = orderedInnerElements.map(function (_a) {
        var node = _a.node;
        return node;
    });
    var newId = (0, solver_1.newFocus)(innerNodes, outerNodes, activeElement, lastNode);
    if (newId === solver_1.NEW_FOCUS) {
        var autoFocusable = (0, DOMutils_1.filterAutoFocusable)(anyFocusable.map(function (_a) {
            var node = _a.node;
            return node;
        })).filter(findAutoFocused((0, parenting_1.allParentAutofocusables)(entries, visibilityCache)));
        return {
            node: autoFocusable && autoFocusable.length
                ? (0, firstFocus_1.pickFirstFocus)(autoFocusable)
                : (0, firstFocus_1.pickFirstFocus)((0, DOMutils_1.filterAutoFocusable)(innerNodes)),
        };
    }
    if (newId === undefined) {
        return newId;
    }
    return orderedInnerElements[newId];
};
exports.getFocusMerge = getFocusMerge;
