/*
 * # Fomantic UI - 2.9.1
 * https://github.com/fomantic/Fomantic-UI
 * https://fomantic-ui.com/
 *
 * Copyright 2023 Contributors
 * Released under the MIT license
 * https://opensource.org/licenses/MIT
 *
 */
!function(D,E,H){"use strict";function z(e){return"function"==typeof e&&"number"!=typeof e.nodeType}E=void 0!==E&&E.Math===Math?E:globalThis,D.fn.toast=function(x){var k,e=D(this),T=e.selector||"",I=Date.now(),P=[],O=x,M="string"==typeof O,A=[].slice.call(arguments,1);return e.each(function(){var t,o,a,s,i,c,l,e,r=D.isPlainObject(x)?D.extend(!0,{},D.fn.toast.settings,x):D.extend({},D.fn.toast.settings),d=r.className,u=r.selector,p=r.error,n=r.namespace,f=r.fields,g="."+n,m=n+"-module",h=D(this),v=r.context?[E,H].indexOf(r.context)<0?D(H).find(r.context):D(r.context):D("body"),b=h.hasClass("toast")||h.hasClass("message")||h.hasClass("card"),C=this,y=b?h.data(m):void 0,w={initialize:function(){w.verbose("Initializing element"),w.create.id(),w.has.container()||w.create.container(),(b||""!==r.message||""!==r.title||""!==w.get.iconClass()||r.showImage||w.has.configActions())&&("string"==typeof r.showProgress&&-1!==[d.top,d.bottom].indexOf(r.showProgress)||(r.showProgress=!1),w.create.toast(),r.closeOnClick&&(r.closeIcon||0<D(o).find(u.input).length||w.has.configActions())&&(r.closeOnClick=!1),r.closeOnClick||t.addClass(d.unclickable),w.bind.events()),w.instantiate(),t&&w.show()},instantiate:function(){w.verbose("Storing instance of toast"),y=w,h.data(m,y)},destroy:function(){t&&(w.debug("Removing toast",t),w.unbind.events(),t.remove(),c=o=t=void 0,r.onRemove.call(t,C),l=i=s=void 0),h.removeData(m)},show:function(e){!1===r.onShow.call(t,C)?w.debug("onShow callback returned false, cancelling toast animation"):(e=e||function(){},w.debug("Showing toast"),w.animate.show(e))},close:function(e){!1===r.onHide.call(t,C)?w.debug("onHide callback returned false, cancelling toast animation"):(e=e||function(){},w.debug("Closing toast"),w.remove.visible(),w.unbind.events(),w.animate.close(e))},create:{container:function(){w.verbose("Creating container"),v.append(D("<div/>",{class:r.position+" "+d.container+" "+(r.horizontal?d.horizontal:"")+" "+(r.context&&"body"!==r.context?d.absolute:"")}))},id:function(){e=(Math.random().toString(16)+"000000000").slice(2,10),w.verbose("Creating unique id for element",e)},toast:function(){t=D("<div/>",{class:d.box});var e,n=w.get.iconClass();b?(o=r.cloneModule?h.clone().removeAttr("id"):h,l=o.find("> i"+w.helpers.toClass(d.close)),r.closeIcon=0<l.length,""!==n&&o.find(u.icon).attr("class",n+" "+d.icon),r.showImage&&o.find(u.image).attr("src",r.showImage),""!==r.title&&o.find(u.title).html(w.helpers.escape(r.title,r.preserveHTML)),""!==r.message&&o.find(u.message).html(w.helpers.escape(r.message,r.preserveHTML))):(w.verbose("Creating toast"),o=D("<div/>",{role:"alert"}),e=D("<div/>",{class:d.content}),""!==n&&o.append(D("<i/>",{class:n+" "+d.icon})),r.showImage&&o.append(D("<img>",{class:d.image+" "+r.classImage,src:r.showImage})),""!==r.title&&(n="_"+w.get.id()+"title",o.attr("aria-labelledby",n),e.append(D("<div/>",{class:d.title,id:n,html:w.helpers.escape(r.title,r.preserveHTML)}))),n="_"+w.get.id()+"desc",o.attr("aria-describedby",n),e.append(D("<div/>",{class:d.message,id:n,html:w.helpers.escape(r.message,r.preserveHTML)})),o.addClass(r.class+" "+d.toast).append(e),o.css("opacity",String(r.opacity)),r.closeIcon&&((l=D("<i/>",{class:d.close+" "+("string"==typeof r.closeIcon?r.closeIcon:""),role:"button",tabindex:0,"aria-label":r.text.close})).hasClass(d.left)?o.prepend(l):o.append(l))),o.hasClass(d.compact)&&(r.compact=!0),o.hasClass("card")&&(r.compact=!1),a=o.find(".actions"),w.has.configActions()&&(0===a.length&&(a=D("<div/>",{class:d.actions+" "+(r.classActions||"")}).appendTo(o)),o.hasClass("card")&&!a.hasClass(d.attached)&&(a.addClass(d.extraContent),a.hasClass(d.vertical)&&(a.removeClass(d.vertical),w.error(p.verticalCard))),r.actions.forEach(function(e){var n=e[f.icon]?"<i "+(e[f.text]?'aria-hidden="true"':"")+' class="'+w.helpers.deQuote(e[f.icon])+' icon"></i>':"",t=w.helpers.escape(e[f.text]||"",r.preserveHTML),o=w.helpers.deQuote(e[f.class]||""),s=e[f.click]&&z(e[f.click])?e[f.click]:function(){};a.append(D("<button/>",{html:n+t,"aria-label":(e[f.text]||e[f.icon]||"").replace(/<[^>]+(>|$)/g,""),class:d.button+" "+o,on:{click:function(){var e=D(this);e.is(u.approve)||e.is(u.deny)||!1===s.call(C,h)||w.close()}}}))})),a&&a.hasClass(d.vertical)&&o.addClass(d.vertical),0<a.length&&!a.hasClass(d.attached)&&(!a||a.hasClass(d.basic)&&!a.hasClass(d.left)||o.addClass(d.actions)),"auto"===r.displayTime&&(r.displayTime=Math.max(r.minDisplayTime,o.text().split(" ").length/r.wordsPerMinute*6e4)),t.append(o),0<a.length&&a.hasClass(d.attached)&&(a.addClass(d.buttons),a.detach(),o.addClass(d.attached),a.hasClass(d.vertical)?(o.wrap(D("<div/>",{class:d.vertical+" "+d.attached+" "+(r.compact?d.compact:"")})),a.hasClass(d.left)?o.addClass(d.left).parent().addClass(d.left).prepend(a):o.parent().append(a)):a.hasClass(d.top)?(t.prepend(a),o.addClass(d.bottom)):(t.append(a),o.addClass(d.top))),h!==o&&(C=(h=o)[0]),0<r.displayTime&&(n=d.progressing+" "+(r.pauseOnHover?d.pausable:""),r.showProgress&&(s=D("<div/>",{class:d.progress+" "+(r.classProgress||r.class),"data-percent":""}),r.classProgress||(o.hasClass("toast")&&!o.hasClass(d.inverted)?s.addClass(d.inverted):s.removeClass(d.inverted)),i=D("<div/>",{class:"bar "+(r.progressUp?"up ":"down ")+n}),s.addClass(r.showProgress).append(i),s.hasClass(d.top)?t.prepend(s):t.append(s),i.css("animation-duration",r.displayTime/1e3+"s")),(c=D("<span/>",{class:"wait "+n})).css("animation-duration",r.displayTime/1e3+"s"),c.appendTo(o)),r.compact&&(t.addClass(d.compact),o.addClass(d.compact),s&&s.addClass(d.compact)),r.newestOnTop?t.prependTo(w.get.container()):t.appendTo(w.get.container())}},bind:{events:function(){w.debug("Binding events to toast"),r.closeIcon&&l.on("click"+g,w.event.close),o.on("click"+g,w.event.click),c&&c.on("animationend"+g,w.event.close),t.on("click"+g,u.approve,w.event.approve).on("click"+g,u.deny,w.event.deny)}},unbind:{events:function(){w.debug("Unbinding events to toast"),r.closeIcon&&l.off("click"+g),o.off("click"+g),c&&c.off("animationend"+g),t.off("click"+g)}},animate:{show:function(e){e=z(e)?e:function(){},r.transition&&w.can.useElement("transition")&&h.transition("is supported")&&(w.set.visible(),t.transition({animation:r.transition.showMethod+" in",queue:!1,debug:r.debug,verbose:r.verbose,silent:r.silent,duration:r.transition.showDuration,onComplete:function(){e.call(t,C),r.onVisible.call(t,C)}}))},close:function(e){e=z(e)?e:function(){},r.transition&&void 0!==D.fn.transition&&h.transition("is supported")?t.transition({animation:r.transition.hideMethod+" out",queue:!1,duration:r.transition.hideDuration,debug:r.debug,verbose:r.verbose,silent:r.silent,interval:50,onBeforeHide:function(e){e=z(e)?e:function(){},""!==r.transition.closeEasing?t&&(t.css("opacity","0"),t.wrap("<div/>").parent().hide(r.transition.closeDuration,r.transition.closeEasing,function(){t&&(t.parent().remove(),e.call(t))})):e.call(t)},onComplete:function(){e.call(t,C),r.onHidden.call(t,C),w.destroy()}}):w.error(p.noTransition)},pause:function(){c.css("animationPlayState","paused"),i&&i.css("animationPlayState","paused")},continue:function(){c.css("animationPlayState","running"),i&&i.css("animationPlayState","running")}},has:{container:function(){return w.verbose("Determining if there is already a container"),0<w.get.containers().length},toast:function(){return!!w.get.toast()},toasts:function(){return 0<w.get.toasts().length},configActions:function(){return Array.isArray(r.actions)&&0<r.actions.length}},get:{id:function(){return e},containers:function(){return v.children(w.helpers.toClass(r.position)+u.container+(r.horizontal?w.helpers.toClass(d.horizontal):":not("+w.helpers.toClass(d.horizontal)+")")+(r.context&&"body"!==r.context?w.helpers.toClass(d.absolute):":not("+w.helpers.toClass(d.absolute)+")"))},container:function(){return w.get.containers()[0]},toastBox:function(){return t||null},toast:function(){return o||null},toasts:function(){return D(w.get.container()).find(u.box)},iconClass:function(){return"string"==typeof r.showIcon?r.showIcon:r.showIcon&&r.icons[r.class]?r.icons[r.class]:""},remainingTime:function(){return c?c.css("opacity")*r.displayTime:0}},set:{visible:function(){o.addClass(d.visible)}},remove:{visible:function(){o.removeClass(d.visible)}},event:{close:function(){w.close()},click:function(e){0===D(e.target).closest(u.clickable).length&&(!1!==r.onClick.call(t,C)&&r.closeOnClick?w.close():w.verbose("Click callback returned false or close denied by setting cancelling close"))},approve:function(){!1===r.onApprove.call(C,h)?w.verbose("Approve callback returned false cancelling close"):w.close()},deny:function(){!1===r.onDeny.call(C,h)?w.verbose("Deny callback returned false cancelling close"):w.close()}},helpers:{toClass:function(e){var e=e.trim().split(/\s+/),n="";return e.forEach(function(e){n+="."+e}),n},deQuote:function(e){return String(e).replace(/"/g,"")},escape:function(e,n){if(n)return e;var t={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"};return/["&'<>`]/.test(e)?(e=e.replace(/&(?![\d#a-z]{1,12};)/gi,"&amp;")).replace(/["'<>`]/g,function(e){return t[e]}):e}},can:{useElement:function(e){return void 0!==D.fn[e]||(w.error(p.noElement.replace("{element}",e)),!1)}},setting:function(e,n){if(w.debug("Changing setting",e,n),D.isPlainObject(e))D.extend(!0,r,e);else{if(void 0===n)return r[e];D.isPlainObject(r[e])?D.extend(!0,r[e],n):r[e]=n}},internal:function(e,n){if(D.isPlainObject(e))D.extend(!0,w,e);else{if(void 0===n)return w[e];w[e]=n}},debug:function(){!r.silent&&r.debug&&(r.performance?w.performance.log(arguments):(w.debug=Function.prototype.bind.call(console.info,console,r.name+":"),w.debug.apply(console,arguments)))},verbose:function(){!r.silent&&r.verbose&&r.debug&&(r.performance?w.performance.log(arguments):(w.verbose=Function.prototype.bind.call(console.info,console,r.name+":"),w.verbose.apply(console,arguments)))},error:function(){r.silent||(w.error=Function.prototype.bind.call(console.error,console,r.name+":"),w.error.apply(console,arguments))},performance:{log:function(e){var n,t;r.performance&&(t=(n=Date.now())-(I||n),I=n,P.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:C,"Execution Time":t})),clearTimeout(w.performance.timer),w.performance.timer=setTimeout(w.performance.display,500)},display:function(){var e=r.name+":",t=0;I=!1,clearTimeout(w.performance.timer),D.each(P,function(e,n){t+=n["Execution Time"]}),e+=" "+t+"ms",T&&(e+=" '"+T+"'"),0<P.length&&(console.groupCollapsed(e),console.table?console.table(P):D.each(P,function(e,n){console.log(n.Name+": "+n["Execution Time"]+"ms")}),console.groupEnd()),P=[]}},invoke:function(o,e,n){var s,a,t,i=y;return e=e||A,n=n||C,"string"==typeof o&&void 0!==i&&(o=o.split(/[ .]/),s=o.length-1,D.each(o,function(e,n){var t=e!==s?n+o[e+1].charAt(0).toUpperCase()+o[e+1].slice(1):o;if(D.isPlainObject(i[t])&&e!==s)i=i[t];else{if(void 0!==i[t])return a=i[t],!1;{if(!D.isPlainObject(i[n])||e===s)return void 0!==i[n]?a=i[n]:w.error(p.method,o),!1;i=i[n]}}})),z(a)?t=a.apply(n,e):void 0!==a&&(t=a),Array.isArray(k)?k.push(t):void 0!==k?k=[k,t]:void 0!==t&&(k=t),a}};M?(void 0===y&&w.initialize(),w.invoke(O)):(void 0!==y&&y.invoke("destroy"),w.initialize(),k=h)}),void 0!==k?k:this},D.toast=D.fn.toast,D.fn.toast.settings={name:"Toast",namespace:"toast",silent:!1,debug:!1,verbose:!1,performance:!0,context:"body",position:"top right",horizontal:!1,class:"neutral",classProgress:!1,classActions:!1,classImage:"mini",title:"",message:"",displayTime:3e3,minDisplayTime:1e3,wordsPerMinute:120,showIcon:!1,newestOnTop:!1,showProgress:!1,pauseOnHover:!0,progressUp:!1,opacity:1,compact:!0,closeIcon:!1,closeOnClick:!0,cloneModule:!0,actions:!1,preserveHTML:!0,showImage:!1,transition:{showMethod:"scale",showDuration:500,hideMethod:"scale",hideDuration:500,closeEasing:"easeOutCubic",closeDuration:500},error:{method:"The method you called is not defined.",noElement:"This module requires ui {element}",verticalCard:"Vertical but not attached actions are not supported for card layout"},className:{container:"ui toast-container",absolute:"absolute",box:"floating toast-box",progress:"ui attached active progress",toast:"ui toast",icon:"centered icon",visible:"visible",content:"content",title:"ui header",message:"message",actions:"actions",extraContent:"extra content",button:"ui button",buttons:"ui buttons",close:"close icon",image:"ui image",vertical:"vertical",horizontal:"horizontal",attached:"attached",inverted:"inverted",compact:"compact",pausable:"pausable",progressing:"progressing",top:"top",bottom:"bottom",left:"left",basic:"basic",unclickable:"unclickable"},text:{close:"Close"},icons:{info:"info",success:"checkmark",warning:"warning",error:"times"},selector:{container:".ui.toast-container",box:".toast-box",toast:".ui.toast",title:".header",message:".message:not(.ui)",image:"> img.image, > .image > img",icon:"> i.icon",input:'input:not([type="hidden"]), textarea, select, button, .ui.button, ui.dropdown',clickable:"a, details, .ui.accordion",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel"},fields:{class:"class",text:"text",icon:"icon",click:"click"},onShow:function(){},onVisible:function(){},onClick:function(){},onHide:function(){},onHidden:function(){},onRemove:function(){},onApprove:function(){},onDeny:function(){}},D.extend(D.easing,{easeOutBounce:function(e){var n=7.5625,t=2.75;return e<1/t?n*e*e:e<2/t?n*(e-=1.5/t)*e+.75:e<2.5/t?n*(e-=2.25/t)*e+.9375:n*(e-=2.625/t)*e+.984375},easeOutCubic:function(e){return--e*e*e+1}})}(jQuery,window,document);