# Changelog

All notable changes to this project will be documented in this file. Dates are displayed in UTC.

Generated by [`auto-changelog`](https://github.com/CookPete/auto-changelog).


## [2.9.4](https://github.com/fomantic/Fomantic-UI/compare/2.9.3...2.9.4)

> 23 February 2025

## Changes and new Features

### Button

- circular icon button to appear round at minimum [`c7c2a5d`](https://github.com/fomantic/Fomantic-UI/commit/c7c2a5d5498ee84d59b058ff6c453788af3b5935)
- support circular (spaced) button (groups) [`e123cb8`](https://github.com/fomantic/Fomantic-UI/commit/e123cb8693a271e4f88659f02d636f0111c444ab)

### Calendar

- "get date" can return formatted date [`21d259d`](https://github.com/fomantic/Fomantic-UI/commit/21d259de5892df2d286b542b80c5225c7c0436ce)
- remove data values on destroy [`28e0212`](https://github.com/fomantic/Fomantic-UI/commit/28e02122a23aaea5abf6f045fcdbf32556075ad5)

### Dropdown

- collapse on clearable optional [`14bf847`](https://github.com/fomantic/Fomantic-UI/commit/14bf8479856d59b9006989cb7b5176f87662dfdb)
- highlightMatches option [`94e4e87`](https://github.com/fomantic/Fomantic-UI/commit/94e4e879664d32d912b9f20b4c9b829978827bce)
- support custom data attributes for items [`18b5554`](https://github.com/fomantic/Fomantic-UI/commit/18b5554360413938a997ee1b7139ccd79fb54923)
- support submenus for selection dropdown [`62260b0`](https://github.com/fomantic/Fomantic-UI/commit/62260b0976c5b24d075d68ea68720e9d133a8203)

### Embed

- add optional alt tag to placeholder [`a5363fb`](https://github.com/fomantic/Fomantic-UI/commit/a5363fba4a8e1b7506b93fe85af1246caa36b54e)

### Emoji

- update to emoji v15.1 [`aa0a7eb`](https://github.com/fomantic/Fomantic-UI/commit/aa0a7eb272aa76af90d2840fca02c30d27913953)

### Form

- deprecated and rename empty to notEmpty rule [`0224737`](https://github.com/fomantic/Fomantic-UI/commit/02247373979a1384fb990560fd1923982304444d)
- optional ignore native field validations [`392300a`](https://github.com/fomantic/Fomantic-UI/commit/392300ae292b6124a50fe90f894ec07b51eff86c)
- pass down element to prompt function call [`3c0904e`](https://github.com/fomantic/Fomantic-UI/commit/3c0904ebf75d8cb988403b41bf72e765ecca1110)
- support id only input fields for validation [`0c7e318`](https://github.com/fomantic/Fomantic-UI/commit/0c7e3187ef276bc3d87ca32cc8e70b3482f69fa2)

### Form Validation

- support prompt functions for settings value [`98a7652`](https://github.com/fomantic/Fomantic-UI/commit/98a76523ab21ccacdcd64bbb80b51d46f3c19394)

### Header

- seamless attached variant [`b198514`](https://github.com/fomantic/Fomantic-UI/commit/b19851433cef2feba58b036cc19dcc72da176f1b)

### Progress

- basic variant and support empty bar [`4c35b29`](https://github.com/fomantic/Fomantic-UI/commit/4c35b29bb6782b1ad89b7239e01e97666bf19140)

### Search

- support remove icon [`22d2d0d`](https://github.com/fomantic/Fomantic-UI/commit/22d2d0daaf6cd194c2eaaa7b1fd8209cfbc66344)

### Slider

- improve slider variants and gapratio [`24c0a2b`](https://github.com/fomantic/Fomantic-UI/commit/24c0a2b7669871859b86eb61853848a56cb2fd08)

### Step

- circular steps variant [`2ee930b`](https://github.com/fomantic/Fomantic-UI/commit/2ee930b1b4665920725d5038897eb7162350fb2f)


### Build Features

- customizable output filename [`1ecfaf3`](https://github.com/fomantic/Fomantic-UI/commit/1ecfaf3bbb44083646c3050816f9b00b050ff399)
- gulp 5 upgrade [`a2891ac`](https://github.com/fomantic/Fomantic-UI/commit/a2891ac9456b57b7d6e0ab313caafca454ebf7b4)
- optionally include version in released filename [`2bc983b`](https://github.com/fomantic/Fomantic-UI/commit/2bc983bb205dff19d41496ddd2efb96b4ee0737b)

### CI Features

- enforce NL before opening curly braces [`13b76ee`](https://github.com/fomantic/Fomantic-UI/commit/13b76ee714bba8efdeef8a6e402cda6774abce40)
- lint ts types using CI [`4effaa3`](https://github.com/fomantic/Fomantic-UI/commit/4effaa30f03cca0080fa04706f942f9ef28161dc)
- upgrade to prettier v3 [`7446b46`](https://github.com/fomantic/Fomantic-UI/commit/7446b4658c13f7a99e80c615c67ce0ac9a096bff)


## Bug Fixes

### Button

- circular spaced and circular icon group was not respected [`86f0306`](https://github.com/fomantic/Fomantic-UI/commit/86f030696b2891ccd72d05376695daeec76d26ad)

### Calendar

- shortyear handling was broken [`cf152e2`](https://github.com/fomantic/Fomantic-UI/commit/cf152e22c95a1e42e4a882b86f19a933b3535713)

### Checkbox

- disallow keynav on readonly radios [`d05c619`](https://github.com/fomantic/Fomantic-UI/commit/d05c619246d6b1f913bf0c4fab2a4213eaf1df20)

### Divider

- vertical in stackable mobile grid [`f120df6`](https://github.com/fomantic/Fomantic-UI/commit/f120df670a04e192fda60106f0c14b0e8277bd4a)

### Dropdown

- add given placeholder [`22d29e8`](https://github.com/fomantic/Fomantic-UI/commit/22d29e89166e9147f676ec12621d31d70c97098e)
- clearable icon was missing or misaligned [`0e39857`](https://github.com/fomantic/Fomantic-UI/commit/0e39857116a41b64aa5286dee68ed3d5570c804b)
- create label before changing value as in 2.8.8 [`34acb50`](https://github.com/fomantic/Fomantic-UI/commit/34acb501f006a4ed4425e1492ca4efc71c4f5ff4)
- fetch js error on non existing letter selections [`f0d7450`](https://github.com/fomantic/Fomantic-UI/commit/f0d7450e495a8cd100d220b94eb122410b6a73d7)
- fix map parameter on htmlentities [`9bf4620`](https://github.com/fomantic/Fomantic-UI/commit/9bf46203cd7eef67f1c065912173742a0d286d81)
- hidden cursor on form states [`be049d2`](https://github.com/fomantic/Fomantic-UI/commit/be049d2aa53d39f6b334a410f332a12dbaf913fe)
- keep searchterm in menu search [`6daf34d`](https://github.com/fomantic/Fomantic-UI/commit/6daf34d16395f8aa9b964719095c775fc8e4e95b)
- long/short variants were not working anymore [`fa62639`](https://github.com/fomantic/Fomantic-UI/commit/fa62639400ccdfed6f4a35ad9973375c99e0c321)
- make "set text" work for custom actions [`e4ff553`](https://github.com/fomantic/Fomantic-UI/commit/e4ff5533efb6b3cd06a40ba1ad96ebe46260b4a7)
- respect keepsearchterm on enter selection [`686c8b5`](https://github.com/fomantic/Fomantic-UI/commit/686c8b5df6aa89787d375a17bc2aa1a2100cfa8f)
- set placeholdertext regardless of values [`1d9a088`](https://github.com/fomantic/Fomantic-UI/commit/1d9a088bfe8bab1b7b0a852d81a5c6235657dcbd)
- support individual sizing inside forms [`4bdf123`](https://github.com/fomantic/Fomantic-UI/commit/4bdf12329cee389261fc0332caa6c113c4f876f9)
- support manual removed entries [`35a4548`](https://github.com/fomantic/Fomantic-UI/commit/35a4548be74c2a5c223264a1e338ec177f5d938e)
- unify focus, hover borders and icons [`2587ced`](https://github.com/fomantic/Fomantic-UI/commit/2587ced31bb1ae858bd9d29eab5007cef883e251)

### Feed

- inverted metadata actions [`8b6456b`](https://github.com/fomantic/Fomantic-UI/commit/8b6456b2350aea194fe7868eb867b76d1b55aa5f)

### Flag

- update macedonia flag name [`3d58f7f`](https://github.com/fomantic/Fomantic-UI/commit/3d58f7f369bf5fd16234207ef0fbbb5cc35dfe8d)
- use jdecked twemoji fork [`96ed453`](https://github.com/fomantic/Fomantic-UI/commit/96ed45371205b8437f1d0ec948e3ac39a6599009)

### Form

- dont add whitespace on empty required field labels [`3db5328`](https://github.com/fomantic/Fomantic-UI/commit/3db532891770e9e8a2beac490ff1e175ef7bfbd0)
- duplicate error displays on invalid form field value [`95d3bf8`](https://github.com/fomantic/Fomantic-UI/commit/95d3bf8b2aa2f5bd3df6600964def99b7816e212)
- inverted label color in grouped fields [`c721483`](https://github.com/fomantic/Fomantic-UI/commit/c7214832c04fc023be88b40cffe4f7f467673cd5)

### Form Validation

- improve disabled fields check [`6e78472`](https://github.com/fomantic/Fomantic-UI/commit/6e78472177302c1aa748865665713c0d1155a5f0)
- no error for missing field on autocheck [`9e5d2f7`](https://github.com/fomantic/Fomantic-UI/commit/9e5d2f7e277ac6b30bd97784faebc06a452ffbfd)

### Grid

- fix stackable inverted grid divider for mobile screen [`7259033`](https://github.com/fomantic/Fomantic-UI/commit/72590335676ac9665277e784b511d90a7d343f31)

### Label

- grouping image labels margin [`30a40f0`](https://github.com/fomantic/Fomantic-UI/commit/30a40f042ae76a0387a208d1516d9efe2b13aa97)

### Message

- compact message should not exceed max width [`10165a8`](https://github.com/fomantic/Fomantic-UI/commit/10165a861f61321e7e6f6d762aff50778695ebfa)

### Nag

- fetch missing event on manual dismiss call [`3f884b1`](https://github.com/fomantic/Fomantic-UI/commit/3f884b1b96a631e108da9f74503d31377113140e)

### Progress

- wider bar min width [`882ab06`](https://github.com/fomantic/Fomantic-UI/commit/882ab0657b5cd268c3f2c2cf6407e9c875d63040)

### Shape

- use classname alias to short variable access [`eadc3d1`](https://github.com/fomantic/Fomantic-UI/commit/eadc3d123941bc13bc9e4ac102105a07f23f170a)

### Slider

- resize ignored highlightrange setting [`08397dc`](https://github.com/fomantic/Fomantic-UI/commit/08397dc36d5f3c2ef2d1765b32f7109e1dfe5374)

### Step

- link cursor not working on a tags [`9cd8559`](https://github.com/fomantic/Fomantic-UI/commit/9cd8559e85fc29db1d24980a2656b6963d13ce8a)

### Table

- apply border-radius styles to last row of table footer [`6c16b5d`](https://github.com/fomantic/Fomantic-UI/commit/6c16b5db1374b6aef08f2977dff6aca6e57bc5f3)


### CI Fixes

- dont let job fail for latest node [`1a22e32`](https://github.com/fomantic/Fomantic-UI/commit/1a22e32024f8a123f2e8654f3f2cc9f44fde2ea2)


## Types

- alt + data support and search fields [`45d16a0`](https://github.com/fomantic/Fomantic-UI/commit/45d16a053f2074cff92070086968da302eb966e7)
- better declaration files [`a03991c`](https://github.com/fomantic/Fomantic-UI/commit/a03991ca351061b23c0f7bdfe9c0ef2c7c4f5f40)
- clear cache parameter in search module is optional [`6ca9e03`](https://github.com/fomantic/Fomantic-UI/commit/6ca9e0355ef34616a1c9bb8e06d05398fbbd7fba)
- correct transition behavior "set looping" [`fb2d8fc`](https://github.com/fomantic/Fomantic-UI/commit/fb2d8fcbc3f4de690f6df6a75a76452a8bf7e1a2)
- fix missing types on some module [`66bda79`](https://github.com/fomantic/Fomantic-UI/commit/66bda79da0cb40fac6ef024a94c0ffce7cdb8bb4)
- format parameters for calendars get date functions [`e61f418`](https://github.com/fomantic/Fomantic-UI/commit/e61f41884dfd3afaf9266660d19284f871b5ba6a)
- highlightmatches setting [`c98bcb7`](https://github.com/fomantic/Fomantic-UI/commit/c98bcb79e77b8b54ed0fc11cd41f51329801720f)
- missing and new option for slider [`9b313a5`](https://github.com/fomantic/Fomantic-UI/commit/9b313a5f7a3c7d281727df0825ec8ff1aee540fe)
- missing features from latest commits [`314613a`](https://github.com/fomantic/Fomantic-UI/commit/314613a3dae25603b988f8390386bdcdd076f007)
- missing/wrong types for modal. dropdown, popup, transition [`263c192`](https://github.com/fomantic/Fomantic-UI/commit/263c192a24e368b9a58e4017f05a253cf2af66dc)
- satisfy lint rule no-unsafe-function-type [`59d4729`](https://github.com/fomantic/Fomantic-UI/commit/59d4729367114bb079bfd9fc2ca573cb568b3d4e)

## Chore

- add gurubase.io badge [`51bc85c`](https://github.com/fomantic/Fomantic-UI/commit/51bc85c7b3fcb1cc36f8e10be9381e7ea6b3cd69)
- added asset font license files [`447c10b`](https://github.com/fomantic/Fomantic-UI/commit/447c10b51adaf65069c64f83e9763396cd49695a)
- dependency review [`d3131af`](https://github.com/fomantic/Fomantic-UI/commit/d3131afbb9f9d6d3b6aa106775bf722b412bcc15)
- fix missing types on some module [`66bda79`](https://github.com/fomantic/Fomantic-UI/commit/66bda79da0cb40fac6ef024a94c0ffce7cdb8bb4)
- new detailed changelog layout [`79d3af6`](https://github.com/fomantic/Fomantic-UI/commit/79d3af6b1c6ba08ba7a727fab71cdb21fa5ca14d)
- reduce CSS by removing :not() selectors if variation is disabled [`84fc179`](https://github.com/fomantic/Fomantic-UI/commit/84fc1792d5860e3e488b94bae58e95e0b92484a1)


## Dependency Updates

- bump @actions/core from 1.10.0 to 1.11.1 [`7fc83d7`](https://github.com/fomantic/Fomantic-UI/commit/7fc83d76de6a0961fb7986084d827f34253a0a83)
- bump actions/setup-node from 3 to 4 [`58b660f`](https://github.com/fomantic/Fomantic-UI/commit/58b660fac1b42af2fb6bf1be38152c16d9293bf1)
- bump auto-changelog from 2.4.0 to 2.5.0 [`7a268fc`](https://github.com/fomantic/Fomantic-UI/commit/7a268fc8dce5cc62c3547d0a45bbc8496fb25ed8)
- bump braces from 3.0.2 to 3.0.3 [`c48cd9d`](https://github.com/fomantic/Fomantic-UI/commit/c48cd9d6b80720fdcddbd81b62dc0b20f5e02022)
- bump browserslist from 4.21.10 to 4.24.4 [`16949e8`](https://github.com/fomantic/Fomantic-UI/commit/16949e825936cf81075fd75019e0634e9244606d)
- bump cross-spawn from 7.0.3 to 7.0.6 [`1c07019`](https://github.com/fomantic/Fomantic-UI/commit/1c070196033dba5c883f8ab08d1c75cb34b849f3)
- bump es5-ext from 0.10.59 to 0.10.63 [`0a95751`](https://github.com/fomantic/Fomantic-UI/commit/0a95751eabbf3a1b3a2f02c347a7880a5e3e597d)
- bump eslint from 8.48.0 to 8.57.1 [`e0c2e47`](https://github.com/fomantic/Fomantic-UI/commit/e0c2e47195095eff7c00ceb89fc7798fa4461edc)
- bump eslint-plugin-import from 2.28.1 to 2.31.0 [`4074b23`](https://github.com/fomantic/Fomantic-UI/commit/4074b238decfaf4b6fd25317e87af9f0d82e57d1)
- bump github/codeql-action from 2 to 3 [`f1e44f7`](https://github.com/fomantic/Fomantic-UI/commit/f1e44f7eaf25a473f371c3fb7e0e55b2024fd8cb)
- bump less from 4.2.0 to 4.2.2 [`94c52bd`](https://github.com/fomantic/Fomantic-UI/commit/94c52bd1ee36267315f94890de9436598bd4087d)
- bump micromatch from 4.0.5 to 4.0.8 [`18c9074`](https://github.com/fomantic/Fomantic-UI/commit/18c9074e31e07ea487fad1ff1110a4f751ace8d6)
- bump nanoid from 3.3.7 to 3.3.8 [`b478916`](https://github.com/fomantic/Fomantic-UI/commit/b478916cd3a97f61afc57ed227e936d46e61197f)
- bump postcss from 8.4.30 to 8.5.3 [`7b5640a`](https://github.com/fomantic/Fomantic-UI/commit/7b5640a8950a81f5cdafcc3e04f6934d525daa08)
- bump semver from 5.7.1 to 7.7.1 [`7f5f82a`](https://github.com/fomantic/Fomantic-UI/commit/7f5f82aebc2354ff557436c51a9da2c714e11647)
- dependency review [`d3131af`](https://github.com/fomantic/Fomantic-UI/commit/d3131afbb9f9d6d3b6aa106775bf722b412bcc15)
- downgrade ordered-read-streams [`0a955f4`](https://github.com/fomantic/Fomantic-UI/commit/0a955f434e0eab5d1785072c46b28a8ad402a6c3)
- remove re2 and url-regex through rework-import [`c6df31f`](https://github.com/fomantic/Fomantic-UI/commit/c6df31f1d4e4c0d2505b071db67792a93cfec94e)
- update to forked plugins removing high audit issues [`2f37293`](https://github.com/fomantic/Fomantic-UI/commit/2f37293a27c63c57861ddf5596fd655d212f76b4)

## Docs

- add gurubase.io badge [`51bc85c`](https://github.com/fomantic/Fomantic-UI/commit/51bc85c7b3fcb1cc36f8e10be9381e7ea6b3cd69)

## New contributors

- [`Festiis`](https://github.com/Festiis) for code [`1ee97d7`](https://github.com/fomantic/Fomantic-UI/commit/1ee97d7b38e9da4a53b4a9f625f9dacde311e594)
- [`alvarolm`](https://github.com/alvarolm) for code [`1220ca3`](https://github.com/fomantic/Fomantic-UI/commit/1220ca38c77368fdadeaa19504074b907fe65146)
- [`dreaming-augustin`](https://github.com/dreaming-augustin) for code [`16a9552`](https://github.com/fomantic/Fomantic-UI/commit/16a95529ae5d4e446ee8b0a421096a9411bdfdf1)



## [2.9.3](https://github.com/fomantic/Fomantic-UI/compare/2.9.2...2.9.3)

> 7 September 2023

## Changes and new Features

### Calendar

- add size variations [`1afaf65`](https://github.com/fomantic/Fomantic-UI/commit/1afaf65c866e3b0ac3631ab04251cc4863facd90)
- move hardcoded values to less variables [`9025236`](https://github.com/fomantic/Fomantic-UI/commit/9025236e98db6e21cb49ac2e495b7d64fdcad791)

### Checkbox

- invisible variant for text only [`9cfbc56`](https://github.com/fomantic/Fomantic-UI/commit/9cfbc56c0a202a6cbc9ec5f92aa6ef6e8244ee57)

### Dropdown

- optional keeping the searchterm [`7986b3f`](https://github.com/fomantic/Fomantic-UI/commit/7986b3f80df8fb52bd797431e4280991fa3cdfb1)
- simple temporary cache clear [`e19bdc5`](https://github.com/fomantic/Fomantic-UI/commit/e19bdc5a7ff4e132cf7d67598b4847a3ee65ee78)

### Emoji

- tweemoji v14 and joypixels v7 update [`db3ee2f`](https://github.com/fomantic/Fomantic-UI/commit/db3ee2fbaa72bd65afddf1403fe57c673f181f06)

### Feed

- connected, ordered, disabled, divided variant + inverted fix [`41577bc`](https://github.com/fomantic/Fomantic-UI/commit/41577bcbfff653772c8a9bacdefc800aaf9d785a)

### Flag

- add alias for czech [`d9a9b44`](https://github.com/fomantic/Fomantic-UI/commit/d9a9b44f401e10e82f4c382b4dfd3d6fd20c6fc3)

### Form

- optional limit the displayed error messages per field [`491b07a`](https://github.com/fomantic/Fomantic-UI/commit/491b07ab0c2b9097a27a32cf646698b2432e665d)

### Item

- disabled variants [`d5f0e18`](https://github.com/fomantic/Fomantic-UI/commit/d5f0e180171edfc4ca6dfcd634e77026c1e5021f)

### Label

- center and bottom ribbon [`3a3d6aa`](https://github.com/fomantic/Fomantic-UI/commit/3a3d6aa494151f270883e667348887199071b334)

### Menu

- simpler equal width [`edf4286`](https://github.com/fomantic/Fomantic-UI/commit/edf4286b3e3c1f08005d2bf16b57719e5c338bc3)

### Popup

- match tooltip appearance to default popups [`5da44d8`](https://github.com/fomantic/Fomantic-UI/commit/5da44d8025e56f705ba9dae27e21b0ecd516e683)
- use title attribute as very last option only [`11b4099`](https://github.com/fomantic/Fomantic-UI/commit/11b409973c82256dc5ce0acc168895576ccd10d5)

### Search

- horizontal category variant [`446d89e`](https://github.com/fomantic/Fomantic-UI/commit/446d89e330edeabb81c36028a9dbc722cf4b0488)
- onresults callback fromcache [`ef4ce34`](https://github.com/fomantic/Fomantic-UI/commit/ef4ce34634832a67e80135de78bff87b7782dc82)

### Segment

- colored inverted attached segment should not have a black border [`58863c1`](https://github.com/fomantic/Fomantic-UI/commit/58863c18a3cb322fbcd11603d7b25f84e15763df)
- loading segment should cover loading spinner [`b952467`](https://github.com/fomantic/Fomantic-UI/commit/b95246742556c66151b59b3fb9b6bcebfe5500ad)
- wrapping in addition to stackable [`17aa72d`](https://github.com/fomantic/Fomantic-UI/commit/17aa72d3a37a373c311296d09506f8e9ea427eec)

### Slider

- restrictedLabels, min/maxRange, always ticks, tooltip [`28fb68c`](https://github.com/fomantic/Fomantic-UI/commit/28fb68ccb3d7de6d66ed2cad62aec9feff6c2737)

### Table

- resizable scrolling [`1e3f606`](https://github.com/fomantic/Fomantic-UI/commit/1e3f606258431651b774cc982cf1ab694872a8ae)



## Bug Fixes

### API

- create regexp alias to fix snyk redos false positive [`bc1849c`](https://github.com/fomantic/Fomantic-UI/commit/bc1849cc215bdb646398a19efa3105924aa8bd3c)

### Calendar

- multimonth had margin [`85bc292`](https://github.com/fomantic/Fomantic-UI/commit/85bc292346a6b0dc644db49180a8ed49931780ee)

### Checkbox

- prevent readonly toggle via space [`c3eb045`](https://github.com/fomantic/Fomantic-UI/commit/c3eb045af344d472d8609aeff10c168289fda201)

### Dropdown

- adjust icon on multiple non selection non search [`b6b51ca`](https://github.com/fomantic/Fomantic-UI/commit/b6b51ca587041f112581c69c9aa42d0664b74bb9)
- double hide transition breaks upward out [`cd6c308`](https://github.com/fomantic/Fomantic-UI/commit/cd6c30873c581b83b57681cac7c38564dd1fd75e)
- encoded select values, multiple maxselections [`34abb0e`](https://github.com/fomantic/Fomantic-UI/commit/34abb0e422b74446172387c45246c6fddaa3442f)
- insert clearable at correct dom position [`f574a6b`](https://github.com/fomantic/Fomantic-UI/commit/f574a6bcff47fb623c92cdab1778e7cdc2f95d96)
- possible XSS through select option text [`be4492b`](https://github.com/fomantic/Fomantic-UI/commit/be4492b7b6acb853ae2d795a2add89d1b1102f66)
- remove clearable icon on disabeled or readonly [`09d0671`](https://github.com/fomantic/Fomantic-UI/commit/09d0671c23fa2710652efaaf0f716aaae85bf42f)
- support selection floating or pointing [`a8dd05e`](https://github.com/fomantic/Fomantic-UI/commit/a8dd05ea61a8d970107742102c6a34ab6b004558)

### Flag

- czech_republic alias [`c7d794b`](https://github.com/fomantic/Fomantic-UI/commit/c7d794b9072115464422e9ba81c5fc734d2bbbe5)

### Form

- add prompt while still animating [`7e5e3ff`](https://github.com/fomantic/Fomantic-UI/commit/7e5e3ff2f9135278c41508a4cf415d8f5ef075b5)
- support inline fields group label for required attribute [`e275dcb`](https://github.com/fomantic/Fomantic-UI/commit/e275dcb35733ce8e067aad424c27ecc9e87a4e73)
- use namespace to be able to destroy events [`72d102a`](https://github.com/fomantic/Fomantic-UI/commit/72d102a7628ac7f8ef86341420113a539c57da66)

### Form Validation

- support file inputs for validation [`880333c`](https://github.com/fomantic/Fomantic-UI/commit/880333c34845c544e7115bf0ce8779c8aceb9c35)
- support native validation, after submit only [`5e5da5d`](https://github.com/fomantic/Fomantic-UI/commit/5e5da5da032212ab718ce32bff72de69b64d6dec)

### Menu

- dont show right wrapping border on secondary [`f840753`](https://github.com/fomantic/Fomantic-UI/commit/f84075310cb6115a13590477b24b8b36dbbd491f)

### Modal

- autofocus fix for input and non focusable elements [`9f9137a`](https://github.com/fomantic/Fomantic-UI/commit/9f9137ad15d63c1235fe89e81472dacfc8424a02)
- fade inner dimmer [`4006122`](https://github.com/fomantic/Fomantic-UI/commit/40061220f76e4087b03e9207a49b5c94fd1ca1a9)
- ignore observed non inputs for autofocus [`1d7449f`](https://github.com/fomantic/Fomantic-UI/commit/1d7449f672cb508b65ece681d52d58d1935eaf5b)
- scrolling multple modals positioning [`81f7c2c`](https://github.com/fomantic/Fomantic-UI/commit/81f7c2cc5b37ff18926b3f5b30de328698127428)

### Segment

- piled segments under parent background, inverted variants [`980ea5e`](https://github.com/fomantic/Fomantic-UI/commit/980ea5e4f4c63a5d549f175f9974420bc4e07bb7)

### Sidebar

- remove unused ios checks [`c6956f2`](https://github.com/fomantic/Fomantic-UI/commit/c6956f2ac1a98dd4fc510c614de726609bc0c9eb)

### Slider

- also bind events on disabled variant [`cb680cb`](https://github.com/fomantic/Fomantic-UI/commit/cb680cba14c4251b9ad7c7fa92b5d97b46b80779)
- max value had js floating point issues [`4ae1b43`](https://github.com/fomantic/Fomantic-UI/commit/4ae1b43d4a8329d5ef7c6900596e6adcc626b9d4)

### Tab

- hash historytype did not work anymore [`8c329ba`](https://github.com/fomantic/Fomantic-UI/commit/8c329bab785d3d59dc2f884e99ef3d36c5abe125)

### Toast

- destroy toast after onremove callback [`2806406`](https://github.com/fomantic/Fomantic-UI/commit/280640609a60f06da0d64925653856ef75296155)


### Build Fixes

- removed never reached error handling [`344657e`](https://github.com/fomantic/Fomantic-UI/commit/344657ebcb270d12f443dc0c8debb9c00356632e)

### CI Fixes

- satisfy linting for import order [`2eabebd`](https://github.com/fomantic/Fomantic-UI/commit/2eabebdf30e7c14c0604f850bcbd2b4646559324)
- upgrade unicorn to 46 to fix eslint 8.40 [`eb16c99`](https://github.com/fomantic/Fomantic-UI/commit/eb16c9958d11fc62fe358e972d8d9cd7e3bc28ec)

## Theming Fixes

- check real colors to support css variables [`4f21527`](https://github.com/fomantic/Fomantic-UI/commit/4f21527c9d194457e3f2a8887d587994518dfd8b)
- variable inheritance without default imported twice [`41cbbfd`](https://github.com/fomantic/Fomantic-UI/commit/41cbbfdd05d6672b9a9804d5a935dbb7a7f3957e)


## Types

- allow JQueryAjaxSettings objects for modules using apiSettings [`5aee397`](https://github.com/fomantic/Fomantic-UI/commit/5aee3977e3eab2fdc62ea2195e54c48649f5e549)
- better readability, intellisense improvements, small fixes [`40a7aee`](https://github.com/fomantic/Fomantic-UI/commit/40a7aee3db1b3ef3404295afb34722b363fd5ba9)

## Chore

- added v2.9.x to security support [`a685a8c`](https://github.com/fomantic/Fomantic-UI/commit/a685a8c274f25e03813ca269e8c30ae41c60663d)
- adjust new username for core maintainer y0hami [`1c42354`](https://github.com/fomantic/Fomantic-UI/commit/1c423540e867ab7b579d705e0609a707c456a3b6)
- check if context exists in parent windows [`2321380`](https://github.com/fomantic/Fomantic-UI/commit/232138045e87b20cf915f9b233b67605a3ffeb8b)
- encapsulate settimeout [`afea456`](https://github.com/fomantic/Fomantic-UI/commit/afea456335687b89d6d802897fd3bd39be815ba6)
- remove openbase badge [`569cce1`](https://github.com/fomantic/Fomantic-UI/commit/569cce1891a4750f8616e08ee4b4c3562a87661e)
- removed selector api as removed in jquery 3 [`dc85362`](https://github.com/fomantic/Fomantic-UI/commit/dc8536229b8a78227a459fd2d78470c258243427)
- shorten specificity names [`3deb795`](https://github.com/fomantic/Fomantic-UI/commit/3deb795288e8985c4a38da3ae48ae44cdaea14ff)


## Dependency Updates

- bump actions/checkout from 3 to 4 [`9dc98bd`](https://github.com/fomantic/Fomantic-UI/commit/9dc98bd87ea54808e437fd110b0dfa4f895a1768)
- bump all-contributors-cli from 6.24.0 to 6.26.1 [`26c6796`](https://github.com/fomantic/Fomantic-UI/commit/26c679698a0d98019c7eec15105a0deff26a721b)
- bump browserslist from 4.21.5 to 4.21.10 [`29cb9be`](https://github.com/fomantic/Fomantic-UI/commit/29cb9be56744458a19dfe83b49b967d698311e61)
- bump eslint from 8.33.0 to 8.48.0 [`ad261fe`](https://github.com/fomantic/Fomantic-UI/commit/ad261fe5381ae5c4f21f44da2ca38be5fc2a6119)
- bump eslint-plugin-import from 2.27.5 to 2.28.1 [`939b102`](https://github.com/fomantic/Fomantic-UI/commit/939b102ab22811d765987cbd7ef5549edd9c2914)
- bump gulp-json-editor from 2.5.6 to 2.5.7 [`6f874c4`](https://github.com/fomantic/Fomantic-UI/commit/6f874c4023621b5d6c285e3e4aec412559ab7a49)
- bump inquirer from 8.2.5 to 8.2.6 [`de758dc`](https://github.com/fomantic/Fomantic-UI/commit/de758dcb3b4b51657623d43893bc5351aadaf942)
- bump jquery from 3.6.3 to 3.7.1 [`75021b9`](https://github.com/fomantic/Fomantic-UI/commit/75021b9d73aa5eeba0be5268e7bfa4857df657b2)
- bump less from 4.1.3 to 4.2.0 [`86a6537`](https://github.com/fomantic/Fomantic-UI/commit/86a6537cec66874effb6e376cf5819b06c997a28)
- bump node-fetch from 2.6.9 to 2.7.0 [`a41a0dc`](https://github.com/fomantic/Fomantic-UI/commit/a41a0dc23cf6c1e20f081a7cd5cf0e60cb0bd798)
- bump postcss from 8.4.21 to 8.4.29 [`f2aad7e`](https://github.com/fomantic/Fomantic-UI/commit/f2aad7e1c47a1e288359e448459c9155e53f2d9d)
- bump semver from 7.3.8 to 7.5.4 [`8d163fa`](https://github.com/fomantic/Fomantic-UI/commit/8d163faa72ca9709d38ded50fde59b3a572d122a)
- octokit v18 upgrade [`f52d42b`](https://github.com/fomantic/Fomantic-UI/commit/f52d42bdff73509c77876f8d2194f4e6a2b84489)

## Docs

- added v2.9.x to security support [`a685a8c`](https://github.com/fomantic/Fomantic-UI/commit/a685a8c274f25e03813ca269e8c30ae41c60663d)
- remove openbase badge [`569cce1`](https://github.com/fomantic/Fomantic-UI/commit/569cce1891a4750f8616e08ee4b4c3562a87661e)



## [2.9.2](https://github.com/fomantic/Fomantic-UI/compare/2.9.1...2.9.2)

> 3 February 2023

## Changes and new Features

### Checkbox

- remove !important [`b6cde0e`](https://github.com/fomantic/Fomantic-UI/commit/b6cde0e68a8c02e1e286ae8c3b2d5478a45c6fb5)

### Form Validation

- size rule to test string length range [`247703a`](https://github.com/fomantic/Fomantic-UI/commit/247703af614b84ff9bf7cb74e36022332964bb23)
- support object list in add errors [`3b0a796`](https://github.com/fomantic/Fomantic-UI/commit/3b0a796dcb78178b8228ee1b48ef7c69670b3ea9)

### Menu

- wrapping variant [`cf51e1c`](https://github.com/fomantic/Fomantic-UI/commit/cf51e1ca633a5618c6dc13b2315ab0d2f876ad89)

### Popup

- loading variant [`f3fb845`](https://github.com/fomantic/Fomantic-UI/commit/f3fb8451633c2ba0ce11fd0d92ab7bbb8f6f32c1)

### Segment

- left and right attached variant [`e1559e8`](https://github.com/fomantic/Fomantic-UI/commit/e1559e8dd71f56fff156d1cc40c0c961a6e7e5b8)
- seamless variant [`79582b2`](https://github.com/fomantic/Fomantic-UI/commit/79582b243684f469d0e6d6ab24b117c70178025c)


### CI Features

- upgrade prettier to 2.8.3-patched [`326e6cc`](https://github.com/fomantic/Fomantic-UI/commit/326e6ccfe227251c640368c86d2f56ca1c9ec673)


## Bug Fixes

### Dropdown

- compact menu items were cut [`6ae4c9d`](https://github.com/fomantic/Fomantic-UI/commit/6ae4c9d9167e70d99b25ca8306b50a124817e2f9)

### Modal

- avoid multiple autofocus on show animation [`5b497e3`](https://github.com/fomantic/Fomantic-UI/commit/5b497e3bad91c5ea5ce437df6f1194ce3ce2dc99)
- remove active class on hide [`27c5d2f`](https://github.com/fomantic/Fomantic-UI/commit/27c5d2f1d0bcdca80718e659da7a82ad87731c6c)

### Segment

- specificity and wrong selector [`16dfb7e`](https://github.com/fomantic/Fomantic-UI/commit/16dfb7efb3e67d3aa1df9515a36193e76cbf39c2)

### Transition

- reverted missing invoke method error [`ed8c5e9`](https://github.com/fomantic/Fomantic-UI/commit/ed8c5e98cf3f8778aa6b90b77798faa1f15e384f)


### Build Fixes

- allow gulp install from direct checkout folder [`2015119`](https://github.com/fomantic/Fomantic-UI/commit/2015119c1487609eaf28fc28abafe3db26668bb5)
- fix path creation to avoid always using default settings [`c9cbd9b`](https://github.com/fomantic/Fomantic-UI/commit/c9cbd9bdf65bba8c9588007d131120434cf981c6)
- missing _site files and check npm folder [`df306be`](https://github.com/fomantic/Fomantic-UI/commit/df306bebcdf65d64c3ebf113b70979713c019d19)

## Theming Fixes

- dont conditional import variables to avoid scoping [`f8f26a1`](https://github.com/fomantic/Fomantic-UI/commit/f8f26a1a30a4ca0f5472b63479f35defd080204e)


## Chore

- invalid css values [`bdc9edd`](https://github.com/fomantic/Fomantic-UI/commit/bdc9edd54c4e17f897af355cc83f83369d54b6c1)
- remove unneeded vendor prefixes [`8415a7a`](https://github.com/fomantic/Fomantic-UI/commit/8415a7a660cec01a35fb65536256792f16372af3)
- remove vendor checks [`8838309`](https://github.com/fomantic/Fomantic-UI/commit/883830993eba0035a91ca1f514680f3740bdc06a)
- unified template headers [`6d98ed1`](https://github.com/fomantic/Fomantic-UI/commit/6d98ed1fc7854d573b965d8f2169cb3017b00de4)


## Dependency Updates

- bump browserslist from 4.21.4 to 4.21.5 [`52801a7`](https://github.com/fomantic/Fomantic-UI/commit/52801a7e47ac865e48c82f1a9df2a4a747829413)
- bump eslint from 8.32.0 to 8.33.0 [`81e635b`](https://github.com/fomantic/Fomantic-UI/commit/81e635bb124914a99c93793e060746e53cb36a53)
- bump eslint-plugin-import from 2.27.4 to 2.27.5 [`7b0c4bd`](https://github.com/fomantic/Fomantic-UI/commit/7b0c4bdf071a66bd03969105089ff18ec4daabc5)
- bump node-fetch from 2.6.8 to 2.6.9 [`4816346`](https://github.com/fomantic/Fomantic-UI/commit/4816346cce15d2dbeea02280f7ec7c63738b2c2b)



## [2.9.1](https://github.com/fomantic/Fomantic-UI/compare/2.9.0...2.9.1)

> 16 January 2023

## Changes and new Features

### Button

- make consequences optional [`14a4f8c`](https://github.com/fomantic/Fomantic-UI/commit/14a4f8cc7c47a91cbed178be6bad1cf1154efc11)

### Calendar

- support context setting [`0533782`](https://github.com/fomantic/Fomantic-UI/commit/053378246ea15da19158c729cb7167cc228458f9)

### Dropdown

- dont animate labels when no transition is given [`0bffb4a`](https://github.com/fomantic/Fomantic-UI/commit/0bffb4ab4ad01425a90aa8e72b1812b403b84fe1)

### Icon

- support custom naming and selector [`4bab7d9`](https://github.com/fomantic/Fomantic-UI/commit/4bab7d93dcfeb02d5714bb054981b032cc737ebe)
- support duotone icons [`845150e`](https://github.com/fomantic/Fomantic-UI/commit/845150ee247059bacde5d24bd66becf61d2be763)

### Input

- make invalid pseudo class optional [`69527dc`](https://github.com/fomantic/Fomantic-UI/commit/69527dca2cf6c9da314f7127217c8bf1203c83d8)
- move pointer-events value into variable [`d459c42`](https://github.com/fomantic/Fomantic-UI/commit/d459c4269eec49f7b5b4e6459aba43738e3f67f8)

### Popup

- color variants [`a927bd2`](https://github.com/fomantic/Fomantic-UI/commit/a927bd2abafca0981864846a0bfe62ac62ee3280)
- multiline tooltip variation [`6dae584`](https://github.com/fomantic/Fomantic-UI/commit/6dae5847f7a6f1e8abf1855a9cdc03d92aba5107)

### Search

- all and some words for fullTextSearch [`a343501`](https://github.com/fomantic/Fomantic-UI/commit/a34350179af8449338949a50e1a24e482f61736b)

### Statistic

- fluid variant [`02b01ff`](https://github.com/fomantic/Fomantic-UI/commit/02b01ff33f2ea3f4ee9ca09af836736acf18bd42)

### Transition

- pulsating variant [`edc5e7e`](https://github.com/fomantic/Fomantic-UI/commit/edc5e7e114f270fe241a9575a69fe7fa6a75b115)


### Build Features

- adjust autoprefixer config to match 2.9.0 browser support [`70adac5`](https://github.com/fomantic/Fomantic-UI/commit/70adac5577f98245fcc6b175eec50679af208f00)
- improve error message for when semantic.json is not found [`51e0c45`](https://github.com/fomantic/Fomantic-UI/commit/51e0c4513f9514c665f32af7ee0fbf80c3fe08a9)

### CI Features

- add Airbnb and Unicorn eslint packages [`aa53fbd`](https://github.com/fomantic/Fomantic-UI/commit/aa53fbd497859a5a3cb2ef94b80910d214aac10a)
- add prettier formatter to assert LESS files whitespaces [`b3dc749`](https://github.com/fomantic/Fomantic-UI/commit/b3dc749053661539c02d33c7dd98810b9a0cd00e)
- add stylelint for LESS and normalize whitespaces [`d4987bf`](https://github.com/fomantic/Fomantic-UI/commit/d4987bfaca7a7447771e819d11d1b85f45c1eccc)
- add stylelint overrides and variation files [`ce26829`](https://github.com/fomantic/Fomantic-UI/commit/ce26829e4dd5d959410643b70a5d403367f6283d)
- adjust LESS whitespaces to match prettier format [`2ec6af4`](https://github.com/fomantic/Fomantic-UI/commit/2ec6af4a55f804dec8711abcc15f2e972dccd47b)
- check node 18 as well [`9773a1d`](https://github.com/fomantic/Fomantic-UI/commit/9773a1db04d6d275d4eadfe6a868faadd4bd1468)
- enforce LF line break in all JS and LESS files [`6a42d01`](https://github.com/fomantic/Fomantic-UI/commit/6a42d0144eb3fd9eb71a27e7de7c3032ac6aeaf0)
- fix else with return, unify ternary CS [`e684c62`](https://github.com/fomantic/Fomantic-UI/commit/e684c629b706a6c766a940989fd19b81ca4b87a3)
- fix global-require eslint rule [`3f3fee4`](https://github.com/fomantic/Fomantic-UI/commit/3f3fee4f1238dc05d77e9779f7fbbadde9f29c51)
- fix multiple rare eslint errors [`7498343`](https://github.com/fomantic/Fomantic-UI/commit/749834368898f9ff53b122c5f6e736abbd3d3501)
- fix various eslint rules [`27384cb`](https://github.com/fomantic/Fomantic-UI/commit/27384cb4cb827221c336e95974a2bfbfb7ed29ee)
- modernize/unify CSS but maintain IE11 compatibility [`6e2fa0f`](https://github.com/fomantic/Fomantic-UI/commit/6e2fa0f46ee260fdf139e887298f59bee181350d)
- nested ternary formatting and remove unneeded parentheses [`df82def`](https://github.com/fomantic/Fomantic-UI/commit/df82def2dc2c2eb7b640a59d64affd004002e342)
- remove global undefined variable shadow [`2753e1d`](https://github.com/fomantic/Fomantic-UI/commit/2753e1d4cd474b7ae4b5f2673cffa2ac3b61ee8a)
- remove unneeded parentheses around expressions [`029436f`](https://github.com/fomantic/Fomantic-UI/commit/029436fb4c0ca4ad40547cec54342fccb3aef35f)
- remove unneeded vendor prefixes [`b0a1399`](https://github.com/fomantic/Fomantic-UI/commit/b0a1399aacb793156f202b11d3f0781404b65e5a)
- type-safe equality operator when comparing literals [`89e62cc`](https://github.com/fomantic/Fomantic-UI/commit/89e62cc6f45f51f53aaeb2d142937ed8cb559180)
- unify LESS files whitespaces and string quotes [`fc431e8`](https://github.com/fomantic/Fomantic-UI/commit/fc431e8c06ca1c0514d6fb137a29b5b24063e831)
- unify number format in LESS [`b672789`](https://github.com/fomantic/Fomantic-UI/commit/b672789403772ecbf213ec5ac112c881870e6f1e)
- unify regex and .length check syntax [`b0f8d19`](https://github.com/fomantic/Fomantic-UI/commit/b0f8d194299469f937cf20d746c1f4e42a632150)
- unify/simplify typeof operator usage [`504f80d`](https://github.com/fomantic/Fomantic-UI/commit/504f80de9d6563617190ee236569fc49805810ed)
- use Date.now() instead of new Date().getTime() [`e658be3`](https://github.com/fomantic/Fomantic-UI/commit/e658be36562f43defc4b3b5f420055e76e38ad7b)


## Bug Fixes

### API

- explicite url setting should have priority over data url [`1084e98`](https://github.com/fomantic/Fomantic-UI/commit/1084e98df5d760a37908b9b66cf9879bc46fc313)
- support [] inside form names [`1a3de4b`](https://github.com/fomantic/Fomantic-UI/commit/1a3de4bb1764ecda9fe198074c0652d5fe2584d8)

### Button

- wrong extra inset [`27d0491`](https://github.com/fomantic/Fomantic-UI/commit/27d0491c7030afa1d1dbb26a847ddf49a29ff3ea)

### Calendar

- calendar breaks when initialDate is string [`2722e1b`](https://github.com/fomantic/Fomantic-UI/commit/2722e1b07e142e69597f49adc22d0621495ad32c)

### Dropdown

- dont reopen menu on forceselection and search blur [`d493189`](https://github.com/fomantic/Fomantic-UI/commit/d493189c1875858621d7a365b12f51d3285d1913)
- fix rounded corners on scrolling menu [`7259c34`](https://github.com/fomantic/Fomantic-UI/commit/7259c349e25122d7363277b793046333ec6b4fbc)
- keep overflow visible for non simple selection [`b4fc00c`](https://github.com/fomantic/Fomantic-UI/commit/b4fc00cdf77af3eda27de0a51c57ff0198c2809f)
- paste values as search query [`338898a`](https://github.com/fomantic/Fomantic-UI/commit/338898ad59dea9ea893f5bc61aaa59b506dbea68)
- reuse select tabindex [`3767ba8`](https://github.com/fomantic/Fomantic-UI/commit/3767ba89bfdd5cc5f959f09db50299919bf7182c)

### Emoji

- changing from maxcdn to jsdelivr cdn path [`0ac5353`](https://github.com/fomantic/Fomantic-UI/commit/0ac5353654df82e9273454c0bd15082109752a19)

### Flyout

- content height wrong without header [`8aa6c67`](https://github.com/fomantic/Fomantic-UI/commit/8aa6c675c42fcfb5d249d75b16bc388239939581)

### Form

- dynamic validation should't check deleted fields [`c245e0f`](https://github.com/fomantic/Fomantic-UI/commit/c245e0fd97e58858fd475bed4b2b2934dc853a61)

### Grid

- fix stackable nested grid [`99f067f`](https://github.com/fomantic/Fomantic-UI/commit/99f067fed42db738087dd4bbfae546ee7387bf89)

### Icon

- fix lighthouse warning [`d199521`](https://github.com/fomantic/Fomantic-UI/commit/d199521157fb5eb06ed33ce2ec4521a111e21bf5)
- removed duplicate icon selectors [`52582e1`](https://github.com/fomantic/Fomantic-UI/commit/52582e1a8714156547a206ee9581456800f2015a)
- unify icon font usage in themes [`42e4040`](https://github.com/fomantic/Fomantic-UI/commit/42e40407d3c4854064fe12804eec6c729f98c2bc)

### Input

- adjust padding in labeled dropdown icon inputs [`02082e2`](https://github.com/fomantic/Fomantic-UI/commit/02082e2856df0d27719dfd923a22dee2e0dfac22)

### Label

- disabled and centered label(s) [`d296b9a`](https://github.com/fomantic/Fomantic-UI/commit/d296b9a299b07890d7f1218f8a02b85f830045a6)

### Menu

- labeled right menu icon size [`9a0ff54`](https://github.com/fomantic/Fomantic-UI/commit/9a0ff54326e3cb35da52f10f7aee8f83424ca541)

### Modal

- do autofocus on content change [`1373e46`](https://github.com/fomantic/Fomantic-UI/commit/1373e464e6d168a07d2900cc869baea1f6fea110)

### Nag

- make sure value is string for all storage engines [`6515b88`](https://github.com/fomantic/Fomantic-UI/commit/6515b88b8843a78f98c3ad809f0fb889156c6762)
- overlay nags were always shown [`ea9251d`](https://github.com/fomantic/Fomantic-UI/commit/ea9251ddb6d04369b39356d60defff5cef0d4095)

### Rating

- partial rating specificity [`f5a64f3`](https://github.com/fomantic/Fomantic-UI/commit/f5a64f35cdab0b2cf4ef6241798d81b0bd495fdd)


### Build Fixes

- one single component does not build [`ead2efb`](https://github.com/fomantic/Fomantic-UI/commit/ead2efbbfebaf61c7156abfd54d0504b83ce869e)

### CI Fixes

- color git diff output [`63633b2`](https://github.com/fomantic/Fomantic-UI/commit/63633b2508e6e857d696b053e0f51486648331ec)


## Chore

- add lint using CI [`8a8d841`](https://github.com/fomantic/Fomantic-UI/commit/8a8d841a3eec3b1a103bb69be0350f1d7715c775)
- also use 3 layer logic for colors.less [`0b65a82`](https://github.com/fomantic/Fomantic-UI/commit/0b65a824be9d1117ace8d3ce7f3e7652dc18b4f5)
- dont assign exoego for autoreview anymore [`3ac5bf1`](https://github.com/fomantic/Fomantic-UI/commit/3ac5bf1c64e1d86187a396254a12e798d403f971)
- fix eslint default config major versions [`21db9e4`](https://github.com/fomantic/Fomantic-UI/commit/21db9e448e3a893d5e3d054a75f8c3159cc05cfa)
- https links [`c30ed51`](https://github.com/fomantic/Fomantic-UI/commit/c30ed51ca12fc1762b04c2fd1a83d087c0124d07)
- prevent overscrolling [`3979742`](https://github.com/fomantic/Fomantic-UI/commit/3979742c8f743ccf8d80e4b40c19b21b8d4a963a)
- references from SUI to FUI [`1d41122`](https://github.com/fomantic/Fomantic-UI/commit/1d411225e7087d7bd474513dcfa252f52adc1fba)
- remove old sui v1 unsupported and undocumented code [`1124496`](https://github.com/fomantic/Fomantic-UI/commit/1124496315e64a2b62b552809ad03486e14b0fac)
- remove unnecessary methods and prefixes [`5b012ba`](https://github.com/fomantic/Fomantic-UI/commit/5b012bac08d1e27b48345d2900821826050e9b0d)
- removed unused dependencies [`a1262ef`](https://github.com/fomantic/Fomantic-UI/commit/a1262eff881c4643bb22f1420846f9af970aec0d)
- rename to fomantic, update jquery, fix examples [`bda1099`](https://github.com/fomantic/Fomantic-UI/commit/bda109920babd6af467a794436ff303d0447b8c1)
- replace jquery deprecated methods [`7071e59`](https://github.com/fomantic/Fomantic-UI/commit/7071e5977705394994b87df42855435f4b357920)
- strip/adjust comment headers via config [`8f304c6`](https://github.com/fomantic/Fomantic-UI/commit/8f304c6b1c93a03cbb9b4a7a84e9b7dce0f553b5)
- support node12 on add [`dbb503f`](https://github.com/fomantic/Fomantic-UI/commit/dbb503f1dff89bc31712d54d3d3e96bb9c78aff8)
- typos found by eslint [`dbc8d11`](https://github.com/fomantic/Fomantic-UI/commit/dbc8d1192c63b646eeb14b59a24fa5dde158be14)
- unify invoke method, removed unused error strings [`dc9662f`](https://github.com/fomantic/Fomantic-UI/commit/dc9662ff67a5bde32774791e93ba4503896e4a9d)
- upgrade to del 6.1.1 [`304a637`](https://github.com/fomantic/Fomantic-UI/commit/304a637ec017ea0a3577798bcbcbdcd6489da969)
- use modern "let" instead of "var" in build scripts [`ae427cc`](https://github.com/fomantic/Fomantic-UI/commit/ae427cc727609089ca6c82eb93a3c30ba8ac8bfe)
- use modern globalThis [`e589cd1`](https://github.com/fomantic/Fomantic-UI/commit/e589cd1c5407d8a04f061898298d399e6f24c624)


## Dependency Updates

- bump all-contributors-cli from 6.23.1 to 6.24.0 [`ec04b4f`](https://github.com/fomantic/Fomantic-UI/commit/ec04b4f557f405d449709635f2325cd20179df7a)
- bump decode-uri-component from 0.2.0 to 0.2.2 [`935e235`](https://github.com/fomantic/Fomantic-UI/commit/935e235d376b55912edb6c3fcd3226a04d17a8e8)
- bump eslint from 8.28.0 to 8.32.0 [`43be9ab`](https://github.com/fomantic/Fomantic-UI/commit/43be9abf8b5e0a4198ab1afddef37b38125b6daf)
- bump eslint-plugin-import from 2.26.0 to 2.27.4 [`a417fa7`](https://github.com/fomantic/Fomantic-UI/commit/a417fa76e46a9072923139cb9ae370a59c9e26e2)
- bump gulp-autoprefixer from 6.1.0 to 8.0.0 [`7ece4ce`](https://github.com/fomantic/Fomantic-UI/commit/7ece4ce2e641de76d601b666925a72ef8a157cc3)
- bump gulp-chmod from 2.0.0 to 3.0.0 [`27e7996`](https://github.com/fomantic/Fomantic-UI/commit/27e7996332f6da0a4f85a7f612e749e81f6a9c60)
- bump gulp-notify from 3.2.0 to 4.0.0 [`edf743a`](https://github.com/fomantic/Fomantic-UI/commit/edf743a171943a6eb161facf631f01ce8201db0f)
- bump gulp-replace from 1.1.3 to 1.1.4 [`c959704`](https://github.com/fomantic/Fomantic-UI/commit/c95970489b20a861c360dc5f8178710e72eb0f3a)
- bump gulp-tap from 1.0.1 to 2.0.0 [`4b673d8`](https://github.com/fomantic/Fomantic-UI/commit/4b673d8a1495a4924be6d5e4f466a3f8257287f5)
- bump inquirer from 8.2.4 to 8.2.5 [`d0b9d94`](https://github.com/fomantic/Fomantic-UI/commit/d0b9d942922e37ad7fc33367601082e6958b5849)
- bump jquery from 3.6.1 to 3.6.3 [`3b7c177`](https://github.com/fomantic/Fomantic-UI/commit/3b7c17788c9581f4f2b0e36065798a4a9a43669d)
- bump json5 from 1.0.1 to 1.0.2 [`631ba7b`](https://github.com/fomantic/Fomantic-UI/commit/631ba7b803ebd4012671f42f9f84d4f3ed15bc3e)
- bump node-fetch from 2.6.7 to 2.6.8 [`344a77e`](https://github.com/fomantic/Fomantic-UI/commit/344a77e3f51657d8305337f1645cae88cbb398ec)
- bump postcss from 8.4.19 to 8.4.21 [`5bdafbe`](https://github.com/fomantic/Fomantic-UI/commit/5bdafbefa62cdc1c3a8d5e7cb8d5a1e19390fca1)
- bump stylelint from 14.16.0 to 14.16.1 [`c9626ca`](https://github.com/fomantic/Fomantic-UI/commit/c9626ca17a55eada9e5911eeeda4f4a6f7b1b595)
- removed unused dependencies [`a1262ef`](https://github.com/fomantic/Fomantic-UI/commit/a1262eff881c4643bb22f1420846f9af970aec0d)
- upgrade to del 6.1.1 [`304a637`](https://github.com/fomantic/Fomantic-UI/commit/304a637ec017ea0a3577798bcbcbdcd6489da969)



## [2.9.0](https://github.com/fomantic/Fomantic-UI/compare/2.8.8...2.9.0)

> 9 October 2022

## Changes and new Features

### Accordion

- add compact and very compact variations [`04f0521`](https://github.com/fomantic/Fomantic-UI/commit/04f0521e91db98571258305d106b46e93bc4de83)
- pure css, inverted, basic, right, tree, nested fixes [`adc8d1a`](https://github.com/fomantic/Fomantic-UI/commit/adc8d1af66f304d05bc52b623c7f290dc54a0050)

### API

- dont convert array response to object by default [`a0ba6f1`](https://github.com/fomantic/Fomantic-UI/commit/a0ba6f1114236369ea74464b1caca895f93bf66e)
- serializeObject, formdata, files [`acc903b`](https://github.com/fomantic/Fomantic-UI/commit/acc903b85036e890caa3311755d3fbc0ab33a06f)

### Button

- split tertiarylinepadding variable [`ef6ccc4`](https://github.com/fomantic/Fomantic-UI/commit/ef6ccc49dd5b2371ea01138384881f391fa50b54)
- wrapping and spaced variant [`ad505d1`](https://github.com/fomantic/Fomantic-UI/commit/ad505d1f266093134be2a4b0a0b76aca439a622e)

### Calendar

- disabledhours [`d77cc99`](https://github.com/fomantic/Fomantic-UI/commit/d77cc99172c75f3e807a60a3fbaf87cff6a8c872)
- multimonth, parser & modal usage fix [`8a331f0`](https://github.com/fomantic/Fomantic-UI/commit/8a331f0e62806964cfa00c271b09d54076f28df5)
- support token dateformats [`721e0ff`](https://github.com/fomantic/Fomantic-UI/commit/721e0ff77b9064adad04b3b11d8efa3b3e297a8e)
- trigger onSelect() event on enter key down [`4d86955`](https://github.com/fomantic/Fomantic-UI/commit/4d86955d931aca254c9aaadf2372743f671cf98f)

### Card

- basic variant [`e1fccff`](https://github.com/fomantic/Fomantic-UI/commit/e1fccffd12fdcf929a05fba36032950fbb722f40)

### Checkbox

- detect on as checked and add checkbox string values [`f55c2cd`](https://github.com/fomantic/Fomantic-UI/commit/f55c2cdb5a198ca0ada776a7d0603e1388876b42)
- use left/right to switch off/on toggle+slider variant [`f5931a0`](https://github.com/fomantic/Fomantic-UI/commit/f5931a0f1b5a8b4491d546a3d7d7f8f5064350ff)

### Container

- wide variant [`fc56242`](https://github.com/fomantic/Fomantic-UI/commit/fc562423f8ead4fd2915e553b8d157d32cf9e8f8)

### Dimmer

- add onVisible and onHidden callbacks [`70f7bc3`](https://github.com/fomantic/Fomantic-UI/commit/70f7bc39311e661ccb2e463cb1cb8fc0969265f5)
- use modern blurring to improve performance [`aad2a1f`](https://github.com/fomantic/Fomantic-UI/commit/aad2a1fd15bb78cb14cf3093794adfbe9449ca3a)

### Dropdown

- change forceSelection default to false [`ed58b7f`](https://github.com/fomantic/Fomantic-UI/commit/ed58b7f3a0a915916ab3c8ed585193593cd639bb)
- improve accessibility in relation to search dropdown [`44debc9`](https://github.com/fomantic/Fomantic-UI/commit/44debc94795691fbc3b085e4a0c9ac8b1c37d965)
- new default exact for fulltextsearch [`89fb963`](https://github.com/fomantic/Fomantic-UI/commit/89fb96339dc95fd66189a6a2cb3c698458433b5f)
- new default showonfocus false [`e7de6a5`](https://github.com/fomantic/Fomantic-UI/commit/e7de6a53cf74fce3928ca58c1ca15ac4e0b73e96)
- onActionable callback [`19bb9f1`](https://github.com/fomantic/Fomantic-UI/commit/19bb9f15d9ed8f081aa2f63f19b365c06af53823)
- optional stuck addition item [`75cb2d5`](https://github.com/fomantic/Fomantic-UI/commit/75cb2d5dac04b66836b1d84bd86e28c9a9fa2767)

### Emoji

- emoji 13.1 update [`4f01636`](https://github.com/fomantic/Fomantic-UI/commit/4f01636eb519473a8a0ed76a11c38254a7527981)
- use svg icons also for "twitter" theme [`db8910b`](https://github.com/fomantic/Fomantic-UI/commit/db8910b49ed653450a4df647155f72671d41f720)

### Flag

- use emoji svg flags with (auto) sizing [`3ca5ff5`](https://github.com/fomantic/Fomantic-UI/commit/3ca5ff5054ead5a4faf31062e5e890a5e3c394ee)

### Flyout

- initial release of flyout module [`9a105a8`](https://github.com/fomantic/Fomantic-UI/commit/9a105a8696c3268c4f1499a65eb982a1a41e3e12)
- support short notation $. [`01b81c0`](https://github.com/fomantic/Fomantic-UI/commit/01b81c03a2245da2e8f0c51dbfeb896c58d022d8)

### Form

- debug a warning if field identifier is not found [`9bd7e11`](https://github.com/fomantic/Fomantic-UI/commit/9bd7e1195733740cb24e112af13da8fc929970c8)
- error instead of debug if field not found [`facbca0`](https://github.com/fomantic/Fomantic-UI/commit/facbca003cf0da465af7d44af41462e736d3eb8b)
- new default true for errorfocus [`30d980c`](https://github.com/fomantic/Fomantic-UI/commit/30d980c591c1943ea5d771a05e27e76bd47989bb)
- optional support all field errors in inline prompt [`59db183`](https://github.com/fomantic/Fomantic-UI/commit/59db18341fdf705fbcdba6fcdf445ce4bf97ea7a)
- support month, week and color input [`4feac27`](https://github.com/fomantic/Fomantic-UI/commit/4feac2728d4e1940ed9769cda65edf5024cd4c40)

### Icon

- customizable icons by using maps [`80dca46`](https://github.com/fomantic/Fomantic-UI/commit/80dca46f8fa0e4440369bc073548c091e0ad6283)
- font awesome 5.15.4 update [`375d141`](https://github.com/fomantic/Fomantic-UI/commit/375d1416d1443c4c33fd07e4c4bb6a371bb06d43)
- make fontface import and icons optional separately [`ff6e030`](https://github.com/fomantic/Fomantic-UI/commit/ff6e0307f37c872654eac7b39e15a8e92a43197e)

### Input

- file input variant [`f14cf4b`](https://github.com/fomantic/Fomantic-UI/commit/f14cf4bed464ae6f356eda8f4959967a67dab999)
- support invalid pseudoclass [`d1c8d51`](https://github.com/fomantic/Fomantic-UI/commit/d1c8d5183a4d2594373b9e30855c70011c11b87f)

### Menu

- centered variant [`d601d62`](https://github.com/fomantic/Fomantic-UI/commit/d601d62ba78520e1464975350174d58771b694f8)

### Modal

- a11y support, tabbing in modal, close icon focus/keypress [`2ecf719`](https://github.com/fomantic/Fomantic-UI/commit/2ecf719c3ac9632772e8c7438e0a6cbc75c3c34e)
- basic header and basic left actions [`9bf5e5c`](https://github.com/fomantic/Fomantic-UI/commit/9bf5e5c6763a854c33a2e2ca69ea356510ebf89a)

### Progress

- onsuccess was not triggered on reset [`8cafd4c`](https://github.com/fomantic/Fomantic-UI/commit/8cafd4ca5bcdedf9989080f1e2a5a3001f6b4a54)

### Segment

- border to top instead of bottom for vertical variant [`d50fad4`](https://github.com/fomantic/Fomantic-UI/commit/d50fad4fa282952d5354cabdf16c0e21f82baf01)
- larger margin only for tab attached segment [`f451d15`](https://github.com/fomantic/Fomantic-UI/commit/f451d1549c1ec53f99c9d64f8482f913311e1a36)

### Tab

- callback to support tab change cancel [`b86479c`](https://github.com/fomantic/Fomantic-UI/commit/b86479c28c79f85faf7a31ea2ca30a2c9b0dd0db)

### Table

- all scroll stuck head foot first last variant [`46bc57a`](https://github.com/fomantic/Fomantic-UI/commit/46bc57a10bf930fda01605ff7415ee4c7388e96a)
- scrolling variant, thead and tfoot colors, inverted colors [`d2b76da`](https://github.com/fomantic/Fomantic-UI/commit/d2b76da388a2bf3d505cca90b48416a8ae31e14e)

### Toast

- allow clickable items without closing [`5c02143`](https://github.com/fomantic/Fomantic-UI/commit/5c0214391602e68d6c15473faca864e8da68b6e5)
- image variant, a11y support, title html, click support [`3426127`](https://github.com/fomantic/Fomantic-UI/commit/3426127e0d4803ff8fda1c3a652ca2edf39ada3b)
- new centered variant to display in the middle of the screen [`1871d28`](https://github.com/fomantic/Fomantic-UI/commit/1871d28abe9249b393b9e58ad8ec268e0b5d2b22)
- support short notation $. [`86121ef`](https://github.com/fomantic/Fomantic-UI/commit/86121efcc4508824f1f3ec21fffd1c8b3131ad44)


### Build Features

- group components in checkbox selection [`bfb3009`](https://github.com/fomantic/Fomantic-UI/commit/bfb30098c49bc80bb9cdf8ddc1f5b736da0b5ec8)
- require node 12 as minimum [`53c6abb`](https://github.com/fomantic/Fomantic-UI/commit/53c6abb35efbf0e8571586544134e841843374cd)

### CI Features

- fix ci should not stop when one action fails [`a9cbaec`](https://github.com/fomantic/Fomantic-UI/commit/a9cbaec9320f0925ea06322bbe95c3ed6d6bfd1e)

### Misc Changes

- remove un-used legacy code [`0f12e9b`](https://github.com/fomantic/Fomantic-UI/commit/0f12e9bcca50f56178c06ac3e08ee90616503170)


## Bug Fixes

### Accordion

- prevent ui dropdown icons in titles to animate [`126ed22`](https://github.com/fomantic/Fomantic-UI/commit/126ed226ddb65eadc86c40077171ff69a475c475)

### API

- empty dropdown data was overriden by previous data [`51a0425`](https://github.com/fomantic/Fomantic-UI/commit/51a042551ddd1fa4346d972ee8eec67da3348b32)
- fix inefficient RegExp that may cause ReDoS [`17bec4a`](https://github.com/fomantic/Fomantic-UI/commit/17bec4accec88bbeba598d32f6ddad96bdaa3fa0)
- reset existing formdata for proper renewing [`5cac1fa`](https://github.com/fomantic/Fomantic-UI/commit/5cac1fa2321dae9248d1b9d546436e7c3119448e)
- respect post vars for caching [`3edbfe3`](https://github.com/fomantic/Fomantic-UI/commit/3edbfe3f1a572d1bde767a5660a0997d33cce9c6)
- source typos [`61f0055`](https://github.com/fomantic/Fomantic-UI/commit/61f00559a1f23783fbf2af55fcb902640e24f5d0)

### Button

- grey tertiary should not saturate colors [`28948f4`](https://github.com/fomantic/Fomantic-UI/commit/28948f439b25ef0decd0df2661a08b9be0c6ad38)
- loading buttons still shows labels [`bcd29ea`](https://github.com/fomantic/Fomantic-UI/commit/bcd29ea61ee6cf1b9f6435962730ba36cf9b92db)

### Calendar

- adjust margin specificity for multimonth [`6de269e`](https://github.com/fomantic/Fomantic-UI/commit/6de269e40b760b07f399c0fda174db566298ed72)
- arrow keys on endCalendar when startCal has future month [`0f8087d`](https://github.com/fomantic/Fomantic-UI/commit/0f8087d116ae808b6bfacf6068b7188fdcf64911)
- blur input on hidden [`677a0ec`](https://github.com/fomantic/Fomantic-UI/commit/677a0ecf02dbc0e22c44350402c0bffbc599b962)
- change to listen to click event by default [`9088caa`](https://github.com/fomantic/Fomantic-UI/commit/9088caa23ed4dc9c01f651752765daea8544d55c)
- keep whitespace between date and time [`f9f3304`](https://github.com/fomantic/Fomantic-UI/commit/f9f33048522b6e010cba834f64e71930868884a9)

### Checkbox

- remove old v1 checkbox box code [`a254f59`](https://github.com/fomantic/Fomantic-UI/commit/a254f590d69673f8423cbe2193904befd26cf280)
- remove the change trigger for enable and disable behavior [`5d9a8bc`](https://github.com/fomantic/Fomantic-UI/commit/5d9a8bc3bebb6a7b0ca5c1c4d7853b41217bcef5)
- show pointer on css only linked labels [`440a62a`](https://github.com/fomantic/Fomantic-UI/commit/440a62ab7fddee2f8f13511c8e911d67b112b9c7)
- wrong variable usage [`bd3d3e4`](https://github.com/fomantic/Fomantic-UI/commit/bd3d3e49818886782ea2fcf50afa02b2bae505f8)

### Dropdown

- add namespace to sessionstorage [`3eadf38`](https://github.com/fomantic/Fomantic-UI/commit/3eadf3850dca9f0dce67585ca427443cf977fb7c)
- autocomplete affects all chrome based browser [`c747c9e`](https://github.com/fomantic/Fomantic-UI/commit/c747c9e92eda5cf76f4cf2508001f8c3f76549fe)
- fix simple upward variant [`344ec4c`](https://github.com/fomantic/Fomantic-UI/commit/344ec4c7df7e6e5e2e458c7861f2fc901a755836)
- floating shadow and radius on direct child menu only [`987c646`](https://github.com/fomantic/Fomantic-UI/commit/987c646e791333064e04cd7546b387dfeb9c95ba)
- generated id should not start with a number [`891101c`](https://github.com/fomantic/Fomantic-UI/commit/891101c5e6017764d3f58ba413bae95a67cc932d)
- hide menu on menu search blur [`8c71ecd`](https://github.com/fomantic/Fomantic-UI/commit/8c71ecd826b8f93f5fcc1ff0bcc2fdb3c1195859)
- input width specificity was same as form input [`6d6caed`](https://github.com/fomantic/Fomantic-UI/commit/6d6caedaca2e5c653c9d90ae498b13ac53369069)
- keep original values, also on remove and more fixes [`7441393`](https://github.com/fomantic/Fomantic-UI/commit/7441393c6d91783546c6c83e8f483d7e4df91657)
- legacyEdge cuts search input [`e4f0699`](https://github.com/fomantic/Fomantic-UI/commit/e4f06996233cba1b901def23e66025c18b9776c5)
- non selection and button upward variant border radius [`507e60a`](https://github.com/fomantic/Fomantic-UI/commit/507e60a2aa4ed3dc30e3964e2f632b8dc745a41e)
- observe select attribute changes [`3fc5491`](https://github.com/fomantic/Fomantic-UI/commit/3fc5491bff9c1bff52113d6479f1c92189dacc0d)
- onChange is fired on menu openeing when reselection=true [`b51d0d1`](https://github.com/fomantic/Fomantic-UI/commit/b51d0d1faa120d0a049c9993be18ecc79f9ac788)
- properly support preventchangetrigger [`b4551f6`](https://github.com/fomantic/Fomantic-UI/commit/b4551f68f9d2da33d8c7aff97059db68b6958f39)
- remove placeholderstyle when same as select text [`ad08d37`](https://github.com/fomantic/Fomantic-UI/commit/ad08d37f383167f1c101d64997217fd11c6a6455)
- search dropdown was not working on mobile [`6949971`](https://github.com/fomantic/Fomantic-UI/commit/69499714c52c4d99c7baff0d56878fb2e1f17a91)
- split delimiter values on paste [`56226ae`](https://github.com/fomantic/Fomantic-UI/commit/56226ae9922f26e592e25816d70c4cb60a1f6feb)
- support callbacks given inside apisettings [`f49946a`](https://github.com/fomantic/Fomantic-UI/commit/f49946a7f291343e0aba611d922f07440eb1d8fa)
- support preselected on value update for select tag [`04f70a7`](https://github.com/fomantic/Fomantic-UI/commit/04f70a7e0329c3342878885cf52f01b52b0f1fbf)
- use central delimiter char instead of key [`123b50f`](https://github.com/fomantic/Fomantic-UI/commit/123b50f824eb08f32d02e85257a7675a3548f087)

### Emoji

- default lineheight should meet text [`f005005`](https://github.com/fomantic/Fomantic-UI/commit/f005005a3bad7aaba82b47f4f8c831405c04f036)
- emojies/flags were not properly themeable [`2e4bd56`](https://github.com/fomantic/Fomantic-UI/commit/2e4bd56fe748b39aa7fb669e129a76d80dba35e9)
- removed unavailable twemoji resources [`5a384b7`](https://github.com/fomantic/Fomantic-UI/commit/5a384b763e653acd213778f6751b08121b8267b4)

### Flag

- ensure unique flag and a-z class names [`c4b3a74`](https://github.com/fomantic/Fomantic-UI/commit/c4b3a747ca2d58df81e11e41e9ccb42349e14ee5)

### Form

- avoid double submit on enterkey [`d5d7bab`](https://github.com/fomantic/Fomantic-UI/commit/d5d7bab218daac4f9c89f83337e41abf17392b4a)
- dont focus errorfield on blur or change [`6c7be26`](https://github.com/fomantic/Fomantic-UI/commit/6c7be262a4575cc56f582b1d01ade58f2831f58f)
- fetch range input prompt for numeric values only [`1c5931a`](https://github.com/fomantic/Fomantic-UI/commit/1c5931ad6696d99941cca1edd22c0622373cac48)
- inverted form labels were black [`a33107c`](https://github.com/fomantic/Fomantic-UI/commit/a33107cd4de588260d2be68ecc74c420a089aa7c)
- keep a compact dropdown compact [`a9bb462`](https://github.com/fomantic/Fomantic-UI/commit/a9bb4623fe7897c49680b692c085ae94d851295a)
- length is deprececated and doubled since 2.0.6 [`3a25bb5`](https://github.com/fomantic/Fomantic-UI/commit/3a25bb570d92e0fc88908935cf0c60bd36012228)
- make sure validation object is cloned [`125d1c6`](https://github.com/fomantic/Fomantic-UI/commit/125d1c6e74282d5439e40e60476df76fba534db6)
- rebind events on dynamic fields [`135cfd1`](https://github.com/fomantic/Fomantic-UI/commit/135cfd1f5f29030143ac36968894a52661013820)

### Grid

- stretched rows were broken on tablet size [`353515d`](https://github.com/fomantic/Fomantic-UI/commit/353515dac2bc6ad4b0b1e0f170599d691274f894)

### Header

- image icon support again [`74b9960`](https://github.com/fomantic/Fomantic-UI/commit/74b99607403bf72e90e8d0d2e4f383594789f7cb)

### Icon

- adjust icons width to match single icon [`344d349`](https://github.com/fomantic/Fomantic-UI/commit/344d34996d25ad343465d428278c3f2003ae8a28)

### Input

- date inputs were larger due to icon size [`1c5668a`](https://github.com/fomantic/Fomantic-UI/commit/1c5668af46c68420966c3670db7efbde7f3a52b7)
- support icon and corner labeled dropdown variant [`c315547`](https://github.com/fomantic/Fomantic-UI/commit/c3155473abb0aa7c9bdbdf1bd100b87dc9512cdf)

### Label

- left/right pointing interferes with icon [`da049ae`](https://github.com/fomantic/Fomantic-UI/commit/da049ae37a9bdebbb435fea7df7cfa1819621657)

### Menu

- attached text menu had borders [`f434400`](https://github.com/fomantic/Fomantic-UI/commit/f434400671d54c08c959bdb593ef736585d47faa)
- inverted tabular menu styling should match tab [`bdb3a49`](https://github.com/fomantic/Fomantic-UI/commit/bdb3a49c519ee344f6fbaa4213b1502f4087ddc7)
- vanish pointer on stacking vertical pointing menu [`3f2aae7`](https://github.com/fomantic/Fomantic-UI/commit/3f2aae723cc0a5056228b22f5e35d73f9146e76a)

### Modal

- avoid propagation of escape to modal [`7e93bcf`](https://github.com/fomantic/Fomantic-UI/commit/7e93bcfbbe4c0706859ce442cd40126fa38818ec)
- close text shadow appeared too early [`96ac111`](https://github.com/fomantic/Fomantic-UI/commit/96ac11140411f5d1aeefde53a321991520ba3c27)
- default templates handler was not working [`143371c`](https://github.com/fomantic/Fomantic-UI/commit/143371c53787b3041283b75237b81f614dcb984e)
- dynamic elements did not reference [`b4c60c1`](https://github.com/fomantic/Fomantic-UI/commit/b4c60c1edc334e8e75cfe65ad3f3b3ae481fc6cf)
- outside close button handling [`118ddb1`](https://github.com/fomantic/Fomantic-UI/commit/118ddb1853075d7fbeeb390ac953370a28e2d6d5)
- respect approve deny callback on js modals [`8672140`](https://github.com/fomantic/Fomantic-UI/commit/8672140d84ce7021605fcc8edb60ff802056cb16)
- support context properly [`ac16a50`](https://github.com/fomantic/Fomantic-UI/commit/ac16a5097cf726e43d2715368d387a84026cd080)

### Popup

- broken and unnecessary check for string [`b3c3d6d`](https://github.com/fomantic/Fomantic-UI/commit/b3c3d6d62ea593e782a373bfce708c388b623e52)
- detailed rtl check [`19b7d18`](https://github.com/fomantic/Fomantic-UI/commit/19b7d18b8749ad84e8a25209dda05aa356f45ee2)
- fix arrow position for bottom center [`c65b85c`](https://github.com/fomantic/Fomantic-UI/commit/c65b85c467d92e4d6c663aac284ecddb4227370d)
- tooltips cannot contain headers [`b83d59e`](https://github.com/fomantic/Fomantic-UI/commit/b83d59edd430c2630f1fad912059468b580d8b36)

### Rating

- partial rating needs webkit prefix [`6ceeeb8`](https://github.com/fomantic/Fomantic-UI/commit/6ceeeb86af5d0ea2407be6053dc0bb2bdbd68cc6)

### Search

- blur on escape and proper type usage [`e32d5af`](https://github.com/fomantic/Fomantic-UI/commit/e32d5af72dbb04201660b638b7fdd37ab5b11a62)
- missing default easing results in js error [`df9b52b`](https://github.com/fomantic/Fomantic-UI/commit/df9b52beb08ed30cfbdd22936a657419e017210a)

### Segment

- adjust inverted attached border color specificity [`a42b5d7`](https://github.com/fomantic/Fomantic-UI/commit/a42b5d7db06c5bb2a62961dc234b506369e71c8f)
- horizontal should use group variables [`6dea710`](https://github.com/fomantic/Fomantic-UI/commit/6dea710b26b349ba4ccf1ccc5fb4d1d1d42cf560)
- ignore attached border when basic [`398ed43`](https://github.com/fomantic/Fomantic-UI/commit/398ed431c355fbef9731b47b7b59192ce4965fb3)
- tabular menu border misaligned from 3rd tab [`bb53b03`](https://github.com/fomantic/Fomantic-UI/commit/bb53b033d0965887b5aa69b3febed67e36cfa89c)

### Sidebar

- make overflow hidden optional to support sticky [`5f0c9f1`](https://github.com/fomantic/Fomantic-UI/commit/5f0c9f1d77670893ead62d02c8231fce0719d381)
- missing identical features and fixes [`0740de8`](https://github.com/fomantic/Fomantic-UI/commit/0740de88774bb3171b0badb2481aea5bfe07461a)
- scrolllock and returnscroll [`116f84b`](https://github.com/fomantic/Fomantic-UI/commit/116f84bebbed0317fe1c112cc004d93feead3c80)

### Slider

- support mouse & touch all the time [`f964821`](https://github.com/fomantic/Fomantic-UI/commit/f964821effb0f743fb7c10d52ce28bbd43e0f5d1)

### Step

- unnecessary semicolon breaks webpack build [`8e287db`](https://github.com/fomantic/Fomantic-UI/commit/8e287db6529f05b41889e5d3a518ca1b6a6ffbd9)

### Sticky

- adopt SUI 2.5.0 fixes [`e146d70`](https://github.com/fomantic/Fomantic-UI/commit/e146d70fa7d4a4fe1652ebe19d3119b283f98d8c)

### Tab

- initializing active tab with historytype 'state' [`3eb748b`](https://github.com/fomantic/Fomantic-UI/commit/3eb748bc0a92f698e900bb55890b70cc086b7f4e)

### Table

- colored marked in colored cells [`83e6d77`](https://github.com/fomantic/Fomantic-UI/commit/83e6d777a88f9b86311343a665e19a1fcf56a316)
- links in compact selectable table cell get wrong padding [`f8f79e7`](https://github.com/fomantic/Fomantic-UI/commit/f8f79e7c6e1488208206518a7a48431aae17683d)
- sortable border only when celled [`89c816e`](https://github.com/fomantic/Fomantic-UI/commit/89c816eaded5738e11f543f95e617da910ff6134)

### Toast

- dedicated horizontal container [`bc6c8ad`](https://github.com/fomantic/Fomantic-UI/commit/bc6c8adddd2d51204ba27ff24ef4f02cd7c3cfda)
- enable smooth transition [`0963809`](https://github.com/fomantic/Fomantic-UI/commit/0963809a3408a7faef03588d9ce99985fefa1ee2)
- possible theme overrides were missing [`1eee7ed`](https://github.com/fomantic/Fomantic-UI/commit/1eee7ed511243f027f2db5d4e914eb4623df5a9f)
- respect approve deny callbacks in actions [`d11687d`](https://github.com/fomantic/Fomantic-UI/commit/d11687dde71e26847e6d014246813b3e856a626a)
- support context setting properly [`3e24a3d`](https://github.com/fomantic/Fomantic-UI/commit/3e24a3de23532e8abd53bb5e6c65292c9eb266dc)

### Transition

- firefox needs reattached node to recalculate CSS [`77bb2f2`](https://github.com/fomantic/Fomantic-UI/commit/77bb2f281d60113cb684071d66d308670e4ff770)


### Build Fixes

- support pnpm folder structure [`cdc3d1a`](https://github.com/fomantic/Fomantic-UI/commit/cdc3d1a69b8933d0dec1ddd70fc12c49c594e0ca)

## Theming Fixes

- less3/4 needs font import interpreted as raw css [`c77b750`](https://github.com/fomantic/Fomantic-UI/commit/c77b7508f386f357b5e50da9198933ba4771db14)
- material theme changed fontpath in site variables [`955ee7c`](https://github.com/fomantic/Fomantic-UI/commit/955ee7c65451a367954092e0f9f7c4990166654e)
- use only woff files and fix firefox font line gap warning [`1ff8bfd`](https://github.com/fomantic/Fomantic-UI/commit/1ff8bfdec9edc9abf7b5d5d5617578437c8707ce)


## Chore

- color list for each component separately [`cab3172`](https://github.com/fomantic/Fomantic-UI/commit/cab31721608de5b90332af2b0b7dd16eb88a94e6)
- consistent show/hide callbacks [`883f912`](https://github.com/fomantic/Fomantic-UI/commit/883f912d38cc1835d737df916f37cc81061e4797)
- enable codeql action [`9631798`](https://github.com/fomantic/Fomantic-UI/commit/9631798397e80fb59b409c6d15994fb0a4904d88)
- eol of text files CRLF to LF [`b3c0489`](https://github.com/fomantic/Fomantic-UI/commit/b3c04899eca991f38dd14db6516407d89b9b1777)
- fix codeql findings [`b9dabd5`](https://github.com/fomantic/Fomantic-UI/commit/b9dabd5b9bf3417677922bedd75debf2b38d8059)
- forward debug settings to transition on internal use [`baa8544`](https://github.com/fomantic/Fomantic-UI/commit/baa8544de4ff23fa213bf39afadc72f09e895b09)
- identical debug defaults for all modules [`e6828e7`](https://github.com/fomantic/Fomantic-UI/commit/e6828e7ba8b345ca5478a1130a0f6f2158ae186c)
- more variation options [`d2fed5f`](https://github.com/fomantic/Fomantic-UI/commit/d2fed5f4a38efc545deb2d00299e68f6ce81196a)
- move from npm to yarn [`377dad4`](https://github.com/fomantic/Fomantic-UI/commit/377dad4e4f5db294b01b5be5a722ed0e30cf8db1)
- optional compile for ie specific code [`4ee9307`](https://github.com/fomantic/Fomantic-UI/commit/4ee93079ab2c486404d86d43ca46d61d5821df5d)
- prevent possible xss [`1513222`](https://github.com/fomantic/Fomantic-UI/commit/15132228ead6c80e96e065e0f1e822e34eac5983)
- replace deprecated .substr() with .slice() [`86979a7`](https://github.com/fomantic/Fomantic-UI/commit/86979a784ad2d94bfb4bb366c71951d1765be5c7)
- reuse variables and quicker element access [`1f24f1d`](https://github.com/fomantic/Fomantic-UI/commit/1f24f1d71ff2ad8510fb66675333def74613a5bc)
- same custom scrollbars in chrome, FF and IE [`97d7039`](https://github.com/fomantic/Fomantic-UI/commit/97d7039fc2b1e5fead3722ea8d111b3ef9e9d642)
- set permissions for gitHub actions [`e0a0484`](https://github.com/fomantic/Fomantic-UI/commit/e0a0484fe72b7dedfd1f17a81d6a4e6fac22aa94)
- variable declaration and usage fixes and optimization [`6dec24a`](https://github.com/fomantic/Fomantic-UI/commit/6dec24a674780b3e287149c2178e8a6bf0de22fe)


## Dependency Updates

- bump @actions/core from 1.6.0 to 1.10.0 [`8b04a71`](https://github.com/fomantic/Fomantic-UI/commit/8b04a71a5fa7a31520d77f7b2e807ca84597f161)
- bump actions/checkout from 2 to 3 [`6d51cba`](https://github.com/fomantic/Fomantic-UI/commit/6d51cba658e139e7314f445e95b3c621c9d94ec2)
- bump actions/setup-node from 2 to 3 [`3682bdf`](https://github.com/fomantic/Fomantic-UI/commit/3682bdfdc206285a06c8549ebcc3598158025111)
- bump all-contributors-cli from 6.20.0 to 6.23.1 [`9360515`](https://github.com/fomantic/Fomantic-UI/commit/9360515c677db3ba4cadd001fd578609158f23dc)
- bump browserslist from 4.19.3 to 4.21.4 [`6a18b84`](https://github.com/fomantic/Fomantic-UI/commit/6a18b8401cfe50e2343b22fa48da2b89bc2ab609)
- bump copy-props from 2.0.4 to 2.0.5 [`5650cc0`](https://github.com/fomantic/Fomantic-UI/commit/5650cc08ec9b6af80afa71910b93df6916464267)
- bump gulp-rtlcss from 1.4.2 to 2.0.0 [`698ceb1`](https://github.com/fomantic/Fomantic-UI/commit/698ceb188fa2d9eedf51a122c87d616ae95e79ac)
- bump inquirer from 7.0.5 to 8.2.4 [`4f4f204`](https://github.com/fomantic/Fomantic-UI/commit/4f4f2046b794ae14a43d0a20b97783e10c20426d)
- bump jquery from 3.6.0 to 3.6.1 [`7c6ef28`](https://github.com/fomantic/Fomantic-UI/commit/7c6ef2853295984e845f8d05e8a1b8c263e3f93c)
- bump less from 4.1.1 to 4.1.3 [`786baef`](https://github.com/fomantic/Fomantic-UI/commit/786baefe374bcfb2707437b97bbc57f27d579b3f)
- bump mkdirp from 0.5.5 to 0.5.6 [`b076427`](https://github.com/fomantic/Fomantic-UI/commit/b076427c1da76cd8b34172fca72ad93e8a67ad9b)
- bump node-fetch from 2.6.1 to 2.6.6 [`951277d`](https://github.com/fomantic/Fomantic-UI/commit/951277df63cba02eeeb5628faef8a5b07bf0f21b)
- bump path-parse from 1.0.6 to 1.0.7 [`791a8a7`](https://github.com/fomantic/Fomantic-UI/commit/791a8a7b1285ca9038e167f9a5e4b7a7d7c6f578)
- bump semver from 7.3.5 to 7.3.8 [`c93e24a`](https://github.com/fomantic/Fomantic-UI/commit/c93e24a160a284599c29c99b3dccc7336c628163)
- make browserslists an own dependecy [`f0a2ebc`](https://github.com/fomantic/Fomantic-UI/commit/f0a2ebc20fdac03fae71cad0213c4b67ebecd04a)
- require octokit/core to avoid install warning [`0e4d021`](https://github.com/fomantic/Fomantic-UI/commit/0e4d0219a52b08c53352fc95fdf7ad07eff4ce23)
- security upgrade inquirer from 6.5.2 to 7.0.5 [`905f3a9`](https://github.com/fomantic/Fomantic-UI/commit/905f3a925ef5f471e2496f3bb1bf25d6be2c0293)
- update auto-changelog from 1.15.0 to 2.4.0 [`4d5303c`](https://github.com/fomantic/Fomantic-UI/commit/4d5303c154c58569d3776b57bf20b27841422b82)
- upgrade mkdirp to from 0.5.6 to 1.0.4 [`d31fe9a`](https://github.com/fomantic/Fomantic-UI/commit/d31fe9a0523bd45fcd7498a2811cb2b6fb79e7f0)
- upgrade semver from 6.3.0 to 7.3.5 [`27e745e`](https://github.com/fomantic/Fomantic-UI/commit/27e745e81a59b420aba6414fb5369bd36518fea9)

## Docs

- limit/clarify IE, old edge, old mobile support [`47db56d`](https://github.com/fomantic/Fomantic-UI/commit/47db56d32b77c6a069753b29bdd217b824f771cd)
- switched to github dependabot [`5c654c3`](https://github.com/fomantic/Fomantic-UI/commit/5c654c31031ea016b59f7c76d4507f2c4c347996)
- various typos [`32be6c7`](https://github.com/fomantic/Fomantic-UI/commit/32be6c79ce6106d82e5d782fab7782c26126821f)

## New contributors

- [`CommanderRoot`](https://github.com/CommanderRoot) for code [`4944543`](https://github.com/fomantic/Fomantic-UI/commit/49445435b362afa6d9662b55bfb4b53b6d46e0d8)
- [`Giandrop`](https://github.com/Giandrop) for code [`2077a3a`](https://github.com/fomantic/Fomantic-UI/commit/2077a3a1d756a1b2619110c95c45c12408e673a9)
- [`Inselhopper`](https://github.com/Inselhopper) for code, a11y [`89653dc`](https://github.com/fomantic/Fomantic-UI/commit/89653dc68a7c2e2672f792b58fc71d36b71bff0d)
- [`Lutonite`](https://github.com/Lutonite) for code [`9489d6b`](https://github.com/fomantic/Fomantic-UI/commit/9489d6b2f0a1d69ac75e75054ac025d6f44c6c0d)
- [`MrL1605`](https://github.com/MrL1605) for code [`5912755`](https://github.com/fomantic/Fomantic-UI/commit/5912755230e366c6b52df6f4abed271a67b129d4)
- [`TheJltres`](https://github.com/TheJltres) for code [`e79c83d`](https://github.com/fomantic/Fomantic-UI/commit/e79c83d5a6e5daad8a57498cf71a80af3ec529f0)
- [`WardLootens`](https://github.com/WardLootens) for code [`48de6f2`](https://github.com/fomantic/Fomantic-UI/commit/48de6f24a616a38d6fadad8f2734229b7e77457d)
- [`Yrlish`](https://github.com/Yrlish) for code [`724b19e`](https://github.com/fomantic/Fomantic-UI/commit/724b19eff62cb35b1f33ecfb88aab57f0f71ce41)
- [`byte916`](https://github.com/byte916) for code [`d4a78ea`](https://github.com/fomantic/Fomantic-UI/commit/d4a78ea34865288964d7cf53741dfc70ae7ea074)
- [`cmoeke`](https://github.com/cmoeke) for code [`e1e66f7`](https://github.com/fomantic/Fomantic-UI/commit/e1e66f75f05552ea016863cc9e7d1c70a89c72cb)
- [`das7pad`](https://github.com/das7pad) for code [`ee4902f`](https://github.com/fomantic/Fomantic-UI/commit/ee4902f785d7004ad200450ad3eb25fb1de95f78)
- [`eikek`](https://github.com/eikek) for code [`19991f2`](https://github.com/fomantic/Fomantic-UI/commit/19991f2a567b73cdb79b2e301a24ffa15964f724)
- [`elliotzlin`](https://github.com/elliotzlin) for code [`3e26ce9`](https://github.com/fomantic/Fomantic-UI/commit/3e26ce944b19189de95cbe9fc0b7cc39d2fd6ea6)
- [`grandeljay`](https://github.com/grandeljay) for code [`8ad0cce`](https://github.com/fomantic/Fomantic-UI/commit/8ad0cceba3eb5318232391e3bc2d39d7bd63b228)
- [`hugopeek`](https://github.com/hugopeek) for code [`3412999`](https://github.com/fomantic/Fomantic-UI/commit/341299945189aadf4d981cb7262f05e0aa60c256)
- [`jameschenjav`](https://github.com/jameschenjav) for code [`f4eef57`](https://github.com/fomantic/Fomantic-UI/commit/f4eef57be4ddd8c4bb5d18935ae385b7f504aa06)
- [`jamessampford`](https://github.com/jamessampford) for code [`b960a87`](https://github.com/fomantic/Fomantic-UI/commit/b960a87a25444d10e05d3b5d36d458feaa50eccc)
- [`jike212`](https://github.com/jike212) for code [`9515cb0`](https://github.com/fomantic/Fomantic-UI/commit/9515cb0e8192a4d579ab62d41496f8970a16d4c9)
- [`ko2in`](https://github.com/ko2in) for doc, review, bug [`1e91d10`](https://github.com/fomantic/Fomantic-UI/commit/1e91d109d1831fc72ec039039c10ebb2bd6f3e70)
- [`lubber-de`](https://github.com/lubber-de) for a11y, security, maintenance [`76dc367`](https://github.com/fomantic/Fomantic-UI/commit/76dc367719654af9f5542705d78154fdf44a5b30)
- [`mareeo`](https://github.com/mareeo) for code [`25c166b`](https://github.com/fomantic/Fomantic-UI/commit/25c166b03c83f0f4356964bd5a0f764280512df7)
- [`mat128`](https://github.com/mat128) for code [`4585cd0`](https://github.com/fomantic/Fomantic-UI/commit/4585cd047e5ccb1dbe6794dc84efddfd9aa01392)
- [`mvorisek`](https://github.com/mvorisek) for code [`c08d4aa`](https://github.com/fomantic/Fomantic-UI/commit/c08d4aa66dafd8e831180d68a1c551872a3dde15)
- [`naveensrinivasan`](https://github.com/naveensrinivasan) for security [`7dc12f7`](https://github.com/fomantic/Fomantic-UI/commit/7dc12f7cd1818dcb18b7e160619fba27fdad3963)
- [`patilkiranm`](https://github.com/patilkiranm) for code, doc [`d33179a`](https://github.com/fomantic/Fomantic-UI/commit/d33179a3f12caa0a0d42964c7e773244695b5417)
- [`rkomiyama`](https://github.com/rkomiyama) for code [`456a0d0`](https://github.com/fomantic/Fomantic-UI/commit/456a0d076e8b5cce7641f1e715994b7bdb70b323)
- [`shadoWalker89`](https://github.com/shadoWalker89) for code [`a1d8b9e`](https://github.com/fomantic/Fomantic-UI/commit/a1d8b9e587f51c8f7313eed0916d19064462cdb6)
- [`ucyildirim`](https://github.com/ucyildirim) for code [`e271e9b`](https://github.com/fomantic/Fomantic-UI/commit/e271e9bf336d41826e9dc5f4a5080ca493dee313)
- [`xamey`](https://github.com/xamey) for code [`42e68bc`](https://github.com/fomantic/Fomantic-UI/commit/42e68bc533e3008720efc67f046ecb1bd11a4f53)



## [2.8.8](https://github.com/fomantic/Fomantic-UI/compare/2.8.7...2.8.8)

> 24 June 2021

## Changes and new Features

### Button

- support stackable buttons [`943961b`](https://github.com/fomantic/Fomantic-UI/commit/943961bd65a851d476d5e3a097a02fcc664b041b)

### Card

- disabled and loading variant [`bedd965`](https://github.com/fomantic/Fomantic-UI/commit/bedd9651889cf2ef124aa9f22c59be647bd89b5a)

### Checkbox

- support right aligned position of checkbox variants [`db91227`](https://github.com/fomantic/Fomantic-UI/commit/db912274b24255d7f49fc6af48151f00383d6b98)

### Dimmer

- support individual show/hide duration [`68bf29f`](https://github.com/fomantic/Fomantic-UI/commit/68bf29fdf71b929eb4439445024250ca9ffc470a)
- support individual show/hide transition [`5992784`](https://github.com/fomantic/Fomantic-UI/commit/59927846208ae3b6e473690e3a76df54ff1f848d)

### Dropdown

- (vertical) descriptions to menu item template [`59eeee2`](https://github.com/fomantic/Fomantic-UI/commit/59eeee2cec53a6c06545001d3bb41dc55a9c6061)
- columns were ignored inside menus [`129b3bc`](https://github.com/fomantic/Fomantic-UI/commit/129b3bc6851f93dde0d3365a04b922cf7420ccd8)
- dropdown formatted with label [`65fe7e5`](https://github.com/fomantic/Fomantic-UI/commit/65fe7e50a9905cc8cab7c0388ffc11e4bf3b704d)
- onSearch callback [`04559bc`](https://github.com/fomantic/Fomantic-UI/commit/04559bc2e341901d629f76120cca94038d90e0a8)
- support icon groups margin [`2093c46`](https://github.com/fomantic/Fomantic-UI/commit/2093c46e1da1ea29d4afb015b06adb99d59d0400)
- support individual show and hide transition and duration [`a5d471c`](https://github.com/fomantic/Fomantic-UI/commit/a5d471c6071efc9a39ab0bd203c7e4886c66a6ce)
- support inverted menu in non-inverted dropdown [`46a91bb`](https://github.com/fomantic/Fomantic-UI/commit/46a91bb07e1b18a08367cc0430599bad098c133a)
- support preventChangeTrigger parameter for set.selected [`c15ebfa`](https://github.com/fomantic/Fomantic-UI/commit/c15ebfabaa6326a000c027894e31c1168de95aa0)
- support readonly variant [`185e234`](https://github.com/fomantic/Fomantic-UI/commit/185e234ce0a424f93f183b10f01628024d088d93)
- support separate transition displaytype [`8ae681c`](https://github.com/fomantic/Fomantic-UI/commit/8ae681cd6e4e6e91f7515a7de32361354f33a019)
- support submenu values [`cfc5a74`](https://github.com/fomantic/Fomantic-UI/commit/cfc5a748c7c5f3f2419eb4238c6e9e1a7fd0b082)

### Form

- added errorfocus option to focus first error field or dom node [`d10077a`](https://github.com/fomantic/Fomantic-UI/commit/d10077aa4182b04905cf89078d6d42879ca138e7)
- apply state color also to label class [`d092f48`](https://github.com/fomantic/Fomantic-UI/commit/d092f482109e43f60e68c48980f6390b3cc8fd43)
- escaped caused maximum callstack exceeded [`0f51c3f`](https://github.com/fomantic/Fomantic-UI/commit/0f51c3fea724ca82fe9bedb4cebe75328b47f9c5)
- set optional field behavior [`6397554`](https://github.com/fomantic/Fomantic-UI/commit/6397554f5bfdf504b52b9b901ea2540411b708b3)
- support range values for decimal and number validation [`6f8b533`](https://github.com/fomantic/Fomantic-UI/commit/6f8b533168df97966e1c171548acc539ce464072)
- support shouldtrim per fieldrule [`7da17f7`](https://github.com/fomantic/Fomantic-UI/commit/7da17f717bf67066e0e0ac3294663ad565e1081c)

### Header

- icon content was not aligned [`62dcda8`](https://github.com/fomantic/Fomantic-UI/commit/62dcda8f49926b971f1702c9b058d0e10fa6295d)

### Icon

- bordered and circular icon groups [`fc6d299`](https://github.com/fomantic/Fomantic-UI/commit/fc6d2995d405a4ae90f2af64392336ba189335b4)
- colored variant for bordered or circular [`ba420fe`](https://github.com/fomantic/Fomantic-UI/commit/ba420fea625ef2b287a629af9f2a6ab422a65cc7)
- support loading variant for icon groups [`4d9b24c`](https://github.com/fomantic/Fomantic-UI/commit/4d9b24c24b323d60f806c8ca2f405b02cbb6367b)
- use corner offset variables [`de42d96`](https://github.com/fomantic/Fomantic-UI/commit/de42d96e2b3a70fa25678d911de9129915ac20dc)

### Message

- support centered variant [`48c4716`](https://github.com/fomantic/Fomantic-UI/commit/48c47168b9fa6b405efafdc86b5b0c0ea6130432)

### Modal

- centered variant for any content [`aa04e6d`](https://github.com/fomantic/Fomantic-UI/commit/aa04e6d96d322c558020c11ba0f3668d0a6aa05f)
- dynamic modal content [`7e3e450`](https://github.com/fomantic/Fomantic-UI/commit/7e3e450791c7180c74d2133fd39a358ea51a6204)
- js config templates, alert, confirm, prompt [`bf2f280`](https://github.com/fomantic/Fomantic-UI/commit/bf2f28065ef5dc6b080a4180d0dea6892276c003)

### Progress

- support right aligned progress bar [`8bbda5f`](https://github.com/fomantic/Fomantic-UI/commit/8bbda5f51e9a5eb6ffe12555bd1dacc2155e36ec)

### Segment

- disabled, inverted and loading groups [`9ade8b7`](https://github.com/fomantic/Fomantic-UI/commit/9ade8b7cef894867d7937bf5fc9c9df08be2ad9d)
- prevent user selection on disabled and loading [`05955c0`](https://github.com/fomantic/Fomantic-UI/commit/05955c046cd0be135c57c7ba80dffe36e0c49276)
- support equal width [`c952da3`](https://github.com/fomantic/Fomantic-UI/commit/c952da38464f9c117da73f8ee4f40b472ddc497b)

### Slider

- support control over change trigger [`ce85cf3`](https://github.com/fomantic/Fomantic-UI/commit/ce85cf35b64d80c51482047581059c2c31fcea58)

### Toast

- horizontal variant and dynamic content support [`b41338d`](https://github.com/fomantic/Fomantic-UI/commit/b41338df93ba88063c1115e9d542db7d4ba2273e)
- top and bottom attached and centered support [`686529b`](https://github.com/fomantic/Fomantic-UI/commit/686529b0fbbca0c3e9c26d8f89e031ed4a40fdae)


### Build Features

- check node 13 and 14 for github actions [`750a192`](https://github.com/fomantic/Fomantic-UI/commit/750a1920da943ca449bd4a053d91012b351c294d)


## Bug Fixes

### Button

- labeled icon buttons have wrong margin [`6d5703e`](https://github.com/fomantic/Fomantic-UI/commit/6d5703eb5d6ef9e72b5077b9a1dbf9d823ddd7d1)

### Calendar

- disabled week days should not affect month and year view [`5ef2c23`](https://github.com/fomantic/Fomantic-UI/commit/5ef2c23b13b0d33534514dcc8809c171ee7ceb0d)
- return null instead of undefined in sanitizer [`de2ba9f`](https://github.com/fomantic/Fomantic-UI/commit/de2ba9fb62937ce5221dc79f691cb66111e5b9d6)
- show active and eventdates on enabled adjacent days [`9f54e14`](https://github.com/fomantic/Fomantic-UI/commit/9f54e143b3be3b0f96b9a54e8d9c7f59ca953767)

### Card

- inverted header links were not styled properly [`06fff10`](https://github.com/fomantic/Fomantic-UI/commit/06fff101f7197ca3afb987c15aea48a9d32b1025)
- leave auto height to prevent image stretch on chrome [`dbe6ee4`](https://github.com/fomantic/Fomantic-UI/commit/dbe6ee4046744d8b173aa324f96aaeae3006dcf2)
- top border thickness of horizontal card [`cd975ae`](https://github.com/fomantic/Fomantic-UI/commit/cd975aeae6d28a5d83d921d0d5d0241c71eb822b)

### Dimmer

- fix typo in dimmer.js [`bc87d77`](https://github.com/fomantic/Fomantic-UI/commit/bc87d77c849321365a9ddcd4c9bc1c296192f641)

### Dropdown

- autocomplete in chrome does not support "off" [`58b023c`](https://github.com/fomantic/Fomantic-UI/commit/58b023c24be10262583c25ae6a7377fa6436f55d)
- clearable inline support [`1d06e9d`](https://github.com/fomantic/Fomantic-UI/commit/1d06e9dabf5404bfc13d6fbd8f26be48c381dfc5)
- double declaration of name [`a432a81`](https://github.com/fomantic/Fomantic-UI/commit/a432a81acc9b5a7e2322f8ca7ebc7628d209723d)
- fix menu item refresh logic when using remote api [`c0e49df`](https://github.com/fomantic/Fomantic-UI/commit/c0e49dfd5cec9bd06d0932d44bd91ad9a8a949a9)
- fix menu show on mobile and api call [`1d8b2b1`](https://github.com/fomantic/Fomantic-UI/commit/1d8b2b18af5da5c32d414e33118975c2968f2a62)
- forceSelection trigger event with null addition [`9fc8329`](https://github.com/fomantic/Fomantic-UI/commit/9fc8329c8b416d085f443865ea0aa81277558b1d)
- multiselect values encoding, removing label [`19806d4`](https://github.com/fomantic/Fomantic-UI/commit/19806d490bca6a9e2ad57070a92f678bd786ea87)
- preventchangetrigger on clear for multiple [`8a6f11b`](https://github.com/fomantic/Fomantic-UI/commit/8a6f11b24f7e25387eca814257ddff1db7a8189d)
- respect submenu on up/downward height calculation [`6bab2e8`](https://github.com/fomantic/Fomantic-UI/commit/6bab2e88d4c5547de004913f4cdcce92014c14e8)
- show callback was ignored on remote api call [`68bd08f`](https://github.com/fomantic/Fomantic-UI/commit/68bd08f0bf37314cef4f95d60baf6dbb936b3df1)

### Form

- dropdown item description gets wrong state class [`5e92c42`](https://github.com/fomantic/Fomantic-UI/commit/5e92c42f1ed842b10b17e0cb938ef8e5cfbda1ab)
- file upload fields trigger error using jquery &gt; 3.4.0 [`fdc46e7`](https://github.com/fomantic/Fomantic-UI/commit/fdc46e7e952dfa6caf6fa5585164ff9d95f536e6)
- inverted state forms colors [`2f78f4e`](https://github.com/fomantic/Fomantic-UI/commit/2f78f4e1cc8c576145667f0c50aff87ba820d1bf)
- refresh module on re-initializaion [`0949b16`](https://github.com/fomantic/Fomantic-UI/commit/0949b16fdbb99fbddd6a4a159e73518e5d536a98)
- refresh on instance to fetch dom changes [`1408be0`](https://github.com/fomantic/Fomantic-UI/commit/1408be05462b532f23c7d9cee0c600e030fdbb34)
- separate dirty events trigger multiple native event calls [`6e4ff1d`](https://github.com/fomantic/Fomantic-UI/commit/6e4ff1d8633b6776d83fac452d8e6c750e01e442)
- simplify blur and respect revalidation [`214751b`](https://github.com/fomantic/Fomantic-UI/commit/214751bcda12bfdd74e39dc6a0d213eef90bafb2)
- support mix of shorthand and full object rules [`d1b6dea`](https://github.com/fomantic/Fomantic-UI/commit/d1b6dea09e19cb4b56ef0fa2dadb5679f44368b5)

### Grid

- incorrect margins in compact and very compact grid [`0354793`](https://github.com/fomantic/Fomantic-UI/commit/0354793368c5e08537b09c48b2c4cf6a9c8e4353)
- stackable grid had wrong with inside popup [`79b4eff`](https://github.com/fomantic/Fomantic-UI/commit/79b4effbbd9e185cd5c49d0939a66b21df35dd5f)

### Header

- icon headers should not have a left content padding [`cf7f222`](https://github.com/fomantic/Fomantic-UI/commit/cf7f222a1dafeedfdbc7f8bbf6e9a9ccb0a269e7)
- support icon groups [`271d062`](https://github.com/fomantic/Fomantic-UI/commit/271d06280a5f8153e38741513498238f81458d5d)

### Icon

- colored selector was wrongly placed [`91654b5`](https://github.com/fomantic/Fomantic-UI/commit/91654b54e02b9790af8ab7894ef0353d4349da9f)
- labels in icon groups where shown italic [`595367d`](https://github.com/fomantic/Fomantic-UI/commit/595367d25ec4936facf2e87eca431ffec5ef3242)
- support transformations in icon groups [`ab3d931`](https://github.com/fomantic/Fomantic-UI/commit/ab3d9310e24a4c7dcd76bac2abeff9a4b0d406d5)

### Input

- firefox has different placeholder opacity [`965d0ee`](https://github.com/fomantic/Fomantic-UI/commit/965d0ee9a1c20973b03e694a40df808bcab70202)

### Message

- support icon groups [`1af2588`](https://github.com/fomantic/Fomantic-UI/commit/1af2588246b45df1c1ab98ed2891a22649102e68)

### Modal

- bodyfixed selector did not work with existing padding [`ef3d810`](https://github.com/fomantic/Fomantic-UI/commit/ef3d8105f011362bd4a55f4163dd7597e761c161)
- dont stack same actions buttons [`3a235e6`](https://github.com/fomantic/Fomantic-UI/commit/3a235e6d076718fb5a1842a63e8a285f021ee556)

### Nag

- missing callbacks and fixed unused code [`6cbaa7b`](https://github.com/fomantic/Fomantic-UI/commit/6cbaa7bbbd3b929cc9bccd107153b07dc666ca26)
- refactored, colors, sizes, grouping [`6f2057f`](https://github.com/fomantic/Fomantic-UI/commit/6f2057fc0c5d5b98cf69c95b699aefee287b3de6)

### Popup

- bottom center tooltip was misaligned [`46713c6`](https://github.com/fomantic/Fomantic-UI/commit/46713c6adfc6e43fb05e308d217299ff13c8ac7c)

### Progress

- adjust center position [`467839f`](https://github.com/fomantic/Fomantic-UI/commit/467839fd0eb1b626ce0bb5c09d2adeeb3b000307)
- fix calculations when total &gt; 100 [`998c222`](https://github.com/fomantic/Fomantic-UI/commit/998c22207d8c5b03683150246add458915abead1)

### Rating

- disabled rating should not allow pointer events [`09d5711`](https://github.com/fomantic/Fomantic-UI/commit/09d57116868e3b0ad1f48663e88e745e7df7c471)

### Search

- dont set value when onselect returns false [`b1765a1`](https://github.com/fomantic/Fomantic-UI/commit/b1765a1c0c3dac4c442484374065419611aea69d)
- fetch "Cannot read property 'top' of undefined [`2d69a7c`](https://github.com/fomantic/Fomantic-UI/commit/2d69a7c58b798541372f8c6ce4a95bf2afd59eaf)

### Segment

- support placeholder segments for tab usage [`2138533`](https://github.com/fomantic/Fomantic-UI/commit/2138533060bec9d5c05a3455ea8a24f4fd58b802)

### Slider

- dividing by 0 leads into infinite loop [`ab3001c`](https://github.com/fomantic/Fomantic-UI/commit/ab3001c6121dfda5cf644391942b62d49b52833a)
- fix bottom aligned labels for size variations [`d5a27ef`](https://github.com/fomantic/Fomantic-UI/commit/d5a27ef1fad4e09ed88b0e1642b045683bc2ec10)
- less 4 support needs parenthesis [`1f8850b`](https://github.com/fomantic/Fomantic-UI/commit/1f8850b94436823eb72d3fdbed97a18b552d1ee1)
- no minimum step for label generator [`fcd221b`](https://github.com/fomantic/Fomantic-UI/commit/fcd221b001d45ec6bc820d5f43a3d8bcad377bf0)
- onchange is triggered without moving slider [`2f554c0`](https://github.com/fomantic/Fomantic-UI/commit/2f554c062420ba42f1913e3d6f1a64f4539dda21)
- remove old dist files for renamed slider (range) [`580a6e9`](https://github.com/fomantic/Fomantic-UI/commit/580a6e98a78a337e265aecf787c782a078595cca)

### Table

- allow pointer events for non empty top left cell in definition table [`82231f8`](https://github.com/fomantic/Fomantic-UI/commit/82231f85e25bff965e36f911e0ba0dd2a4aefad9)
- missing comma lead into wrong selector [`8e5b7d4`](https://github.com/fomantic/Fomantic-UI/commit/8e5b7d458bc499c30f34bd36c8b96983acd69da8)

### Toast

- attached toast margin and border [`a706ce9`](https://github.com/fomantic/Fomantic-UI/commit/a706ce9930b6c7ebfe983428825acc796c2b5204)


### Build Fixes

- upgrade css minify and remove specialcomments [`36c6aa0`](https://github.com/fomantic/Fomantic-UI/commit/36c6aa09dafede709450b6f184e11e82200e2304)
- use current year and implement version in header [`1b7159a`](https://github.com/fomantic/Fomantic-UI/commit/1b7159a94933a42e0ade530e43874368fa399a47)


## Chore

- add table search proposal to v3 roadmap [`cfe8022`](https://github.com/fomantic/Fomantic-UI/commit/cfe8022ae3aa54ac22cdd9e2a18e14327e335ded)
- milestones should be sorted [`4b5496c`](https://github.com/fomantic/Fomantic-UI/commit/4b5496c6453fdcc92895397843ac32cd88685a7d)
- remove support issue template in favor of using discussions [`5e93a11`](https://github.com/fomantic/Fomantic-UI/commit/5e93a1137dfcd13498ad44d97e5d4d8dbd592ef5)
- use url encoded semicolons so gulp-concat doesnt break [`6645c5f`](https://github.com/fomantic/Fomantic-UI/commit/6645c5f04b5fe5d3d60c51809c526e2d484e8d74)


## Dependency Updates

- [security] bump y18n from 3.2.1 to 3.2.2 [`176f54d`](https://github.com/fomantic/Fomantic-UI/commit/176f54da167742a79ebab308545c288d368319e8)
- [security] bump yargs-parser from 5.0.0 to 5.0.1 [`8ec0129`](https://github.com/fomantic/Fomantic-UI/commit/8ec0129796537b585c56f54105c183e85f257dba)
- bump all-contributors-cli from 6.17.2 to 6.20.0 [`4a10f16`](https://github.com/fomantic/Fomantic-UI/commit/4a10f16d895871434c9bce649c2a4bf53e7a2cd6)
- bump browserslist from 4.6.4 to 4.16.6 [`248c30c`](https://github.com/fomantic/Fomantic-UI/commit/248c30c77bb332289ff4b9d0fff9018c12e390f5)
- bump gulp-json-editor from 2.5.4 to 2.5.6 [`df7caef`](https://github.com/fomantic/Fomantic-UI/commit/df7caef97d86175ccc852b4c678c8bbc21ddc13f)
- bump gulp-replace from 1.0.0 to 1.1.3 [`68fdc41`](https://github.com/fomantic/Fomantic-UI/commit/68fdc41872acb84b9f3fef6cd8d14903cf34eedd)
- bump gulp-rtlcss from 1.4.1 to 1.4.2 [`f9f203a`](https://github.com/fomantic/Fomantic-UI/commit/f9f203a59e5d00f611b07e7a6bab87064c251ec8)
- bump handlebars from 4.7.5 to 4.7.7 [`4aa416b`](https://github.com/fomantic/Fomantic-UI/commit/4aa416bceca5e9c3c071797acfcdac41c2260d49)
- bump hosted-git-info from 2.7.1 to 2.8.9 [`c50b82b`](https://github.com/fomantic/Fomantic-UI/commit/c50b82bee81c881f5733ba297008a86aa5343065)
- bump jquery from 3.5.1 to 3.6.0 [`24eb27a`](https://github.com/fomantic/Fomantic-UI/commit/24eb27a1d86671ea6e3c44c9adf7e4f46bdc2628)
- bump less from 3.12.2 to 4.1.1 [`26eb499`](https://github.com/fomantic/Fomantic-UI/commit/26eb49958d70791ea86698cb60e03161de1a9138)
- bump lodash from 4.17.19 to 4.17.21 [`9760798`](https://github.com/fomantic/Fomantic-UI/commit/97607982a98899f68b431eca65c6e3b17d5e279f)
- support a possible installed v4 of less [`a246ad7`](https://github.com/fomantic/Fomantic-UI/commit/a246ad7e8f74fccb9d56d794bee358eb43241c58)
- upgrade gulp-less to fully support less 4 [`1f73afd`](https://github.com/fomantic/Fomantic-UI/commit/1f73afd1aa20146998fe9a25af0e9d9255456904)

## Docs

- grammar error [`245b087`](https://github.com/fomantic/Fomantic-UI/commit/245b087a9c037905560ae4a06e7b4213c7736b33)



## [2.8.7](https://github.com/fomantic/Fomantic-UI/compare/2.8.6...2.8.7)

> 7 September 2020

## Changes and new Features

### Button

- dedicated variables for toggle and circular [`3f0ceaa`](https://github.com/fomantic/Fomantic-UI/commit/3f0ceaacb337a4fc20a51045beacfff086553f05)

### Calendar

- added inverted variant [`a8cd1b0`](https://github.com/fomantic/Fomantic-UI/commit/a8cd1b0275d316277752d811b925f1bca60e9bf8)
- avoid unnecessary redraw [`339e7fe`](https://github.com/fomantic/Fomantic-UI/commit/339e7fe94d88fb688d2267301e1d7b83319dbbf5)

### Dimmer

- opacity setting created invalid value on rgb background [`0f558b9`](https://github.com/fomantic/Fomantic-UI/commit/0f558b9e1bfd818b7b4ff1d2ed3b4807ba552ac7)
- support other types of background beside color [`ecf370b`](https://github.com/fomantic/Fomantic-UI/commit/ecf370bcd048a1195753ed88ea9945e87b4b836e)

### Icon

- add the old two classes for linegraph and chartline for compatibility [`7445821`](https://github.com/fomantic/Fomantic-UI/commit/74458216193cbf22653784a98f58ce57b0fc0244)

### List

- icon buttons were misaligned [`0905ccf`](https://github.com/fomantic/Fomantic-UI/commit/0905ccfc4455bb7bbec4844a4950c725ea3f1abb)

### Progress

- total value of 0 was unsupported [`ef85c3d`](https://github.com/fomantic/Fomantic-UI/commit/ef85c3dadae407629355cfa49e307cde84925392)

### Slider

- added default value for interpretlabel setting [`589d382`](https://github.com/fomantic/Fomantic-UI/commit/589d38217303740636319535ef20733e71cf953b)
- support bottom aligned label and prevent line break [`eb3436f`](https://github.com/fomantic/Fomantic-UI/commit/eb3436f6ebd249938402fdf64663d586d0d02d77)

### Text

- support state colors [`f8302b7`](https://github.com/fomantic/Fomantic-UI/commit/f8302b7ff0f25d2abdb9c15858d604de4c76d60d)


### Build Features

- remove individuals from components [`e8bc467`](https://github.com/fomantic/Fomantic-UI/commit/e8bc4674ab5fa95929e30f7357740c7757c95148)


## Bug Fixes

### Button

- compact icon button had wrong padding [`bdf6e55`](https://github.com/fomantic/Fomantic-UI/commit/bdf6e55aa2c30ef4c2a6850ad1bf2fc37d4cd70f)

### Calendar

- adjust tooltip positions according to popup  position [`ae0b664`](https://github.com/fomantic/Fomantic-UI/commit/ae0b66459671c6e8f009290f012d5b1db65bdab9)
- do not pass numeric-only text to date constructor [`2239f64`](https://github.com/fomantic/Fomantic-UI/commit/2239f64603145ed8cab6d9b859c78b1d5fb40f0f)
- evenly divide cell widths [`ec510c8`](https://github.com/fomantic/Fomantic-UI/commit/ec510c81be4270bfda77b26d4d2768dc4084c141)
- support safari to accept yyyy-mm-dd format [`2ddcc7b`](https://github.com/fomantic/Fomantic-UI/commit/2ddcc7b3dd1c92c75aefa70b515e11149d11b9bc)
- trigger native change event on select [`9866014`](https://github.com/fomantic/Fomantic-UI/commit/9866014c31e9d0aa9feb49846364cdc01dcf07c5)

### Dropdown

- avoid tab to enter input on disabled variant [`9f496c3`](https://github.com/fomantic/Fomantic-UI/commit/9f496c37b8a055f417d6e41acfac3af019f60b67)
- columnar dropdowns on raw divs [`b2ae31b`](https://github.com/fomantic/Fomantic-UI/commit/b2ae31b2d523d270ac87033c7208758ee6d5b855)
- fix html for placeholder [`9bbd39f`](https://github.com/fomantic/Fomantic-UI/commit/9bbd39fd75de90739b231d8e6dd43bb5e150e9ea)
- multiple search button padding and wrapping [`7d48060`](https://github.com/fomantic/Fomantic-UI/commit/7d48060b3d2d713ffc48f739a12fc00bfe7e6528)
- optional scrollhint on ios devices or firefox mobile [`b10cf9d`](https://github.com/fomantic/Fomantic-UI/commit/b10cf9d302b310a09fa5b1ec616088909ab6f737)
- using different keyname for fields.values failed [`7225780`](https://github.com/fomantic/Fomantic-UI/commit/72257802e46f7eec3ce6c68a0519026dced695e2)
- very short menu had wrong order specificity [`891f6e6`](https://github.com/fomantic/Fomantic-UI/commit/891f6e6fc576ee3ddb414f7d5f7f62cfc6b62a75)

### Form

- adjust error prompt display in grouped inline fields [`57f919b`](https://github.com/fomantic/Fomantic-UI/commit/57f919b923f3ce8701f0dc4daf410386484149a7)
- adjust margin for field groups on mobile view [`ff40038`](https://github.com/fomantic/Fomantic-UI/commit/ff4003811cd2f1fbb5a1323dd399bc4fc0984f6c)
- dont bind events to dropdown search inputs [`77b9dbf`](https://github.com/fomantic/Fomantic-UI/commit/77b9dbfe37b6e8af7f9ea802dc62948644dbf858)
- isvalid should not delete error state and made optional now [`33397cc`](https://github.com/fomantic/Fomantic-UI/commit/33397ccb93d71c6693e80fd92a636d5e29db1d7f)
- multiple selects return arrays for dirtycheck [`182dd81`](https://github.com/fomantic/Fomantic-UI/commit/182dd81520b281a8a455d0059032bc2031bcb7da)
- remove errors on clear, reset and non inline revalidations [`0e6526d`](https://github.com/fomantic/Fomantic-UI/commit/0e6526d54e9831be377654bc3308b54de16dc52a)
- reset submitting flag when validation fails to keep dirtycheck [`e2d70af`](https://github.com/fomantic/Fomantic-UI/commit/e2d70afd0fe953e248e2ebec7bf65caff6e39f9c)

### Icon

- avoid conflictions with line icon aliases [`63d53f4`](https://github.com/fomantic/Fomantic-UI/commit/63d53f49e62ef9c679cbc8dc405fdcc4eefcba24)
- numeric classname to word [`dbeeca3`](https://github.com/fomantic/Fomantic-UI/commit/dbeeca3c61c8bb11770adcd349959f99cbbc1366)

### Image

- support centered div and adjusted aligned groups [`51ca1ed`](https://github.com/fomantic/Fomantic-UI/commit/51ca1ede9d19352bb84f8e203b9fe0e443e675b3)

### Input

- attached buttons and labels in grouped state fields [`e1a8393`](https://github.com/fomantic/Fomantic-UI/commit/e1a83936154ddf882ba0c8904a9ba3efbcb8acce)

### Menu

- fix icons position and alignment in submenus [`bb16207`](https://github.com/fomantic/Fomantic-UI/commit/bb16207e2dedf66905c28ff81f7a1a91c8dd0d7d)

### Popup

- left/right center tooltips were misaligned [`580d79b`](https://github.com/fomantic/Fomantic-UI/commit/580d79b9693ddea94ce174d41c5ae1951befa885)
- remove text-shadow to avoid inheritance from parent [`0b7630b`](https://github.com/fomantic/Fomantic-UI/commit/0b7630b906b3ad8b8a6d47ac91e424242923e338)

### Search

- avoid unneccesary double link navigation [`c35b4b1`](https://github.com/fomantic/Fomantic-UI/commit/c35b4b10444b227092863893f389a659602cf8b7)

### Segment

- horizontal segments lost rounded corners [`7cc71fd`](https://github.com/fomantic/Fomantic-UI/commit/7cc71fd7842e93a2b93980978a035095611107c6)

### Sidebar

- avoid scrollbar on non body pushable [`c8ad8b9`](https://github.com/fomantic/Fomantic-UI/commit/c8ad8b9e19bda084a5f7a51e65143388bab35e3f)

### Slider

- operation sometimes returns not rounded value [`b385330`](https://github.com/fomantic/Fomantic-UI/commit/b385330dbcb70522b7a7b5f6fce5c1e0d1bde164)

### Table

- inherit vertical align in table footer [`5a18189`](https://github.com/fomantic/Fomantic-UI/commit/5a181892dd2ac7e959efd0c16d5084cac574b4ce)

### Toast

- error progress bar lost visibility [`656dcfc`](https://github.com/fomantic/Fomantic-UI/commit/656dcfc434f00a81a9e82045da79a85b7d3e7877)


### Build Fixes

- single individuals element breaks build [`6957237`](https://github.com/fomantic/Fomantic-UI/commit/6957237ce75ba6c6965044bea999e85eaaabd9bd)


## Chore

- fix cdn default js file [`0c40022`](https://github.com/fomantic/Fomantic-UI/commit/0c40022d7b8eeaf848c771192529a945d353154a)


## Dependency Updates

- [security] bump lodash from 4.17.14 to 4.17.19 [`054976f`](https://github.com/fomantic/Fomantic-UI/commit/054976f7022f7cfdfbdd6df9654fd88955e04229)
- bump @octokit/rest from 16.43.1 to 16.43.2 [`4cff0d5`](https://github.com/fomantic/Fomantic-UI/commit/4cff0d50da9218e0c970532fb2f233edb8441230)
- bump all-contributors-cli from 6.16.0 to 6.17.2 [`04eca76`](https://github.com/fomantic/Fomantic-UI/commit/04eca764de1ccd553bf307b0ca8d3a4d32d594c6)
- bump less from 3.11.3 to 3.12.2 [`5c37067`](https://github.com/fomantic/Fomantic-UI/commit/5c3706709b28a1f8caa717d9d9f6b286fae486d0)
- bump node-fetch from 2.6.0 to 2.6.1 [`caea603`](https://github.com/fomantic/Fomantic-UI/commit/caea6032e401cba59da2227f4880f8cfeefa89ec)

## Docs

- add web components proposal to library implementations [`d5d9764`](https://github.com/fomantic/Fomantic-UI/commit/d5d9764b4bc73f1a84912fa623bd3ca130a6b9d7)
- added openbase.io badge [`da75c3c`](https://github.com/fomantic/Fomantic-UI/commit/da75c3c9c5ecd4ffeefd87569a07d91b8d765a3c)
- spelling fixed [`50822da`](https://github.com/fomantic/Fomantic-UI/commit/50822da562be8baad08bdeb7527fee141f757a0c)



## [2.8.6](https://github.com/fomantic/Fomantic-UI/compare/2.8.5...2.8.6)

> 17 June 2020

## Changes and new Features

### Transition

- make effects optional [`4187f1f`](https://github.com/fomantic/Fomantic-UI/commit/4187f1fed4eba1a90275be7c4c66152e3779fc07)



## Bug Fixes

### Calendar

- fix timezone issue when time is not given [`c96ba01`](https://github.com/fomantic/Fomantic-UI/commit/c96ba01018216cf92b2a3b15e86d108af283e8d6)
- popup should not close when its trigger event is not click [`83e45ad`](https://github.com/fomantic/Fomantic-UI/commit/83e45adfb4978cc7819748afe85a75f42ef50b6f)

### Dimmer

- page dimmer in firefox results in misaligned modals [`790587f`](https://github.com/fomantic/Fomantic-UI/commit/790587ffadac8f0d56d226190993c80e4f99acd1)

### Dropdown

- left and right menu positioning regression [`2cd5e9c`](https://github.com/fomantic/Fomantic-UI/commit/2cd5e9cb9b43cac42ede96650a52644a39bc1f78)
- sizer element is created every time dropdown is initialized [`b3be317`](https://github.com/fomantic/Fomantic-UI/commit/b3be31745c8ec0ec2dee93074059cf78b054bb5a)

### Grid

- very compact variation specificity and alignment [`bf8c159`](https://github.com/fomantic/Fomantic-UI/commit/bf8c159c28bf33fc694d7697b03d68f644247d02)

### Icon

- vertical position for unsized icons and sized text [`4ac35a7`](https://github.com/fomantic/Fomantic-UI/commit/4ac35a7fd39a02d34a175120195a6f77f00107c3)

### Label

- adjusted basic labels height and attached image labels [`170a07b`](https://github.com/fomantic/Fomantic-UI/commit/170a07b0369942eb2313c21021c415c26d7b029c)


### Build Fixes

- location parameter to avoid missing build number [`ffbb9ec`](https://github.com/fomantic/Fomantic-UI/commit/ffbb9ec056fc2e9252a0e400a3a187e76aae30eb)


## Chore

- autoassign ko2in for pr reviews [`1d6ea76`](https://github.com/fomantic/Fomantic-UI/commit/1d6ea76d31203dad9de571822ae5e2ea95fcac93)


## Dependency Updates

- bump all-contributors-cli from 6.15.0 to 6.16.0 [`1d7764d`](https://github.com/fomantic/Fomantic-UI/commit/1d7764d2bfe0b81d72b8fb3acb856c47e0aa9d23)
- bump less from 3.11.1 to 3.11.3 [`2f96b0b`](https://github.com/fomantic/Fomantic-UI/commit/2f96b0b1d6d60f88cd9c056102c059ad2f53e01d)



## [2.8.5](https://github.com/fomantic/Fomantic-UI/compare/2.8.4...2.8.5)

> 1 June 2020

## Changes and new Features

### Divider

- added variable for border style [`4929629`](https://github.com/fomantic/Fomantic-UI/commit/49296296035ead409ff13e493221968c11d9ec50)

### Icon

- update to FA 5.13.0 [`c9e768d`](https://github.com/fomantic/Fomantic-UI/commit/c9e768de50c91854c15fce8a6cc1e03005b6a629)

### Search

- scrollable search result [`7cca9f3`](https://github.com/fomantic/Fomantic-UI/commit/7cca9f3977e90f76af15fb700e56649f979da0b7)

### Step

- added right vertical steps variant having the arrow to the left side [`1986ea2`](https://github.com/fomantic/Fomantic-UI/commit/1986ea2c729555962d66cb47680756c08eb4af95)


### Build Features

- allow individual components to be build separately only [`9b1f9ef`](https://github.com/fomantic/Fomantic-UI/commit/9b1f9ef42b25bdf1939fc7cd088b9695b8229e57)


## Bug Fixes

### Button

- correct vertical align for icons within buttons [`defb29e`](https://github.com/fomantic/Fomantic-UI/commit/defb29e84339ca69f9f664e07000400b7bceb206)
- icon adjustments in animated button [`d580ef0`](https://github.com/fomantic/Fomantic-UI/commit/d580ef0e4081b00ea95fbab6d6c5166c44f5b471)

### Calendar

- fire onchange only when date selection is complete [`6ba815e`](https://github.com/fomantic/Fomantic-UI/commit/6ba815ee457f154801809bf2e2a407070c5c6d55)
- fix the popup show function getting called twice [`8bb477b`](https://github.com/fomantic/Fomantic-UI/commit/8bb477b581eb7422b20ae2c6145b59aef642bf9b)

### Dropdown

- dont trigger onchange event on initiaload when values are given [`544caec`](https://github.com/fomantic/Fomantic-UI/commit/544caec08bb329bbded70f5d58f6d2a8240d36a6)
- nested dropdown positioning [`8621c99`](https://github.com/fomantic/Fomantic-UI/commit/8621c9980b4d40c1d2a5720cf9a24e35e036f8bc)
- prevent showing the whole list if showOnFocus is false [`40642d3`](https://github.com/fomantic/Fomantic-UI/commit/40642d3d589fbed45f567bf60db76bfae03ecfe7)

### Form

- optimized disabled detection [`09e6d28`](https://github.com/fomantic/Fomantic-UI/commit/09e6d288c2124e36a3ad260c13073c8df50670d2)

### Icon

- medium/default font was missing general css properties [`fe44c89`](https://github.com/fomantic/Fomantic-UI/commit/fe44c8935241ca110efce58d3b17b6e8e23b7d10)

### Input

- better differ between left/right icon/action [`93605f5`](https://github.com/fomantic/Fomantic-UI/commit/93605f5935161265ea66078ddadb3a354dd385a5)

### Modal

- center fluid action buttons correctly [`5261482`](https://github.com/fomantic/Fomantic-UI/commit/526148272ae353d8705f6b096fc765599470cfe7)
- fix content css-inheritance on mobile [`3c70f9e`](https://github.com/fomantic/Fomantic-UI/commit/3c70f9e00ed7afe3a6879416336259d522d24957)

### Popup

- pre-existing popup positioning inside tables [`feed67a`](https://github.com/fomantic/Fomantic-UI/commit/feed67af269a4144c8dec9d70a21e5edb733ef6a)

### Progress

- wrong indicating background color on float percentage &lt; 10 [`85f8e03`](https://github.com/fomantic/Fomantic-UI/commit/85f8e03eb4f35522937f7f1ac64bf41d7b704c70)

### Tab

- make auto activation of tabs optional [`9f24338`](https://github.com/fomantic/Fomantic-UI/commit/9f24338e9794321ff1c808facff9255429c3d44f)

### Visibility

- jquery scrollleft is a function rather than a property [`ec615b3`](https://github.com/fomantic/Fomantic-UI/commit/ec615b366280b8380f8f0de5343254a4c4ca59e1)


### Build Fixes

- Import 'various' gulp task also in npm gulpfile [`eb8eefe`](https://github.com/fomantic/Fomantic-UI/commit/eb8eefed9e605a156de992af5820dc026b5a38b0)
- double check for existing object property [`0d6f106`](https://github.com/fomantic/Fomantic-UI/commit/0d6f1060e760d5ae88e92dfe541b6f2007ab5245)
- prevent gulp watch task from refreshing all components [`afbf492`](https://github.com/fomantic/Fomantic-UI/commit/afbf492215702d5a28f9c9987dc76a36af450e05)


## Chore

- add do sponsor content [`460566a`](https://github.com/fomantic/Fomantic-UI/commit/460566a8a38d5e03e8388005e18ffb20b75fd52e)
- add issue template config [`abaf09b`](https://github.com/fomantic/Fomantic-UI/commit/abaf09ba1c0eb533f2ca1910fb81e188e897d996)
- clean up old issue templates [`aab4be3`](https://github.com/fomantic/Fomantic-UI/commit/aab4be3afc9e12fc51b11e376135ab5aad6faea9)
- replace jquery trim with vanilla js [`323e608`](https://github.com/fomantic/Fomantic-UI/commit/323e608eb9eb3e1260771fbd7354b8ccef4fef19)
- search for semantic.json from current workspace path [`e0ccbfc`](https://github.com/fomantic/Fomantic-UI/commit/e0ccbfc34cf8b987836a24d833dd251826d4e477)
- update issue templates [`be0ed70`](https://github.com/fomantic/Fomantic-UI/commit/be0ed70837500b22de96b7ca8097037a5ff55bb1)


## Dependency Updates

- bump all-contributors-cli from 6.14.0 to 6.15.0 [`8193091`](https://github.com/fomantic/Fomantic-UI/commit/819309195c725a8b1a70e5dec1f1fdbee3da507f)
- bump auto-changelog from 1.16.2 to 1.16.4 [`ac35365`](https://github.com/fomantic/Fomantic-UI/commit/ac35365a5b6b249b2057ae704b9bbb7df001217c)
- bump gulp-git from 2.10.0 to 2.10.1 [`4d55b74`](https://github.com/fomantic/Fomantic-UI/commit/4d55b7462da7da4bdf12c0f3e441d190090a9af3)
- bump gulp-rtlcss from 1.4.0 to 1.4.1 [`bd7b981`](https://github.com/fomantic/Fomantic-UI/commit/bd7b981ffc67168d3f2cde979561c9fb898d00f6)
- bump jquery from 3.4.1 to 3.5.1 [`a08f089`](https://github.com/fomantic/Fomantic-UI/commit/a08f08989fe4ab3d450e8fb031aa753675686120)
- bump mkdirp from 0.5.1 to 0.5.5 [`7137827`](https://github.com/fomantic/Fomantic-UI/commit/71378278581fd4c02f722a7d2960fd915efb1b4f)
- bump replace-ext from 1.0.0 to 1.0.1 [`1a85afe`](https://github.com/fomantic/Fomantic-UI/commit/1a85afe0dcd0e70297efb481de8943618c6582bd)



## [2.8.4](https://github.com/fomantic/Fomantic-UI/compare/2.8.3...2.8.4)

> 24 February 2020

## Changes and new Features

### Calendar

- add ability to disable months and years [`ac115ac`](https://github.com/fomantic/Fomantic-UI/commit/ac115ac8a8a435fa1d756f834fdd4e62d5f55f70)

### Form

- auto add empty rule validation for required fields [`ca80dca`](https://github.com/fomantic/Fomantic-UI/commit/ca80dcabcbb8433b5feb6e9dd8d2cfcfd7b2e15e)
- replace all rule token instances in prompt message [`2538a8e`](https://github.com/fomantic/Fomantic-UI/commit/2538a8e7af2b2679d8e1ecde350074697c97daa7)

### Modal

- unsupported debug warning when useflex is used in ie or with detachable false [`c512cf2`](https://github.com/fomantic/Fomantic-UI/commit/c512cf243737f883caca134dac6aa4e101b37a48)



## Bug Fixes

### Checkbox

- dont show visual changes on disabled checkboxes [`4238b78`](https://github.com/fomantic/Fomantic-UI/commit/4238b78c215a5b7d4598fef1c231d7d0fc22f0da)

### Dropdown

- get item function now working properly with array of integers [`2930de5`](https://github.com/fomantic/Fomantic-UI/commit/2930de5137471b74b3a6baefd5384dbcde55c7b7)
- search field cursor was barely visible on field states [`a49c823`](https://github.com/fomantic/Fomantic-UI/commit/a49c82330af6715f4de6332d40ed80f2fb070dbc)

### Emoji

- disabled link emoji should not have pointer cursor [`51cfaa4`](https://github.com/fomantic/Fomantic-UI/commit/51cfaa49f500c697f21f50e1e23a0316ad6c8d0b)

### Form

- inline calendar fields did not display properly [`c2ce312`](https://github.com/fomantic/Fomantic-UI/commit/c2ce312fb2cd765f98977c6942300e6970a7e8ed)
- make a difference between value 0 and false for radio buttons [`e3468c7`](https://github.com/fomantic/Fomantic-UI/commit/e3468c7128ab4ae27f2381812bd6e4ba75fd53e8)

### Menu

- colored active items were not displayed colored [`03e9d7f`](https://github.com/fomantic/Fomantic-UI/commit/03e9d7f94bcf08b44bbae9d6efd592ef3cf38a31)

### Modal

- basic modal header should not have a border [`bd45cb0`](https://github.com/fomantic/Fomantic-UI/commit/bd45cb01209f26355b39e903f40fdd94a1c4021b)
- border radius for inner dimmer should inherit from the modal [`8ab6b89`](https://github.com/fomantic/Fomantic-UI/commit/8ab6b89248d4407aab3f2be03525da1f2dde425c)

### Segment

- sub headers in inverted labels were not changed to in some cases [`66a15cd`](https://github.com/fomantic/Fomantic-UI/commit/66a15cd641c692fe478dfecf875e2649a1789db9)

### Shape

- make sure chrome renders the z-translated faces properly [`37cdf31`](https://github.com/fomantic/Fomantic-UI/commit/37cdf31121e7b8a80f33b975174a790fd57b3570)

### Table

- invented a helper class to solve the styling logic when rowspan is used in tables [`1b20446`](https://github.com/fomantic/Fomantic-UI/commit/1b20446b04476517506777daf8a2da92751ace46)

### Toast

- make sure element does still exist before transition ends [`6a3eca1`](https://github.com/fomantic/Fomantic-UI/commit/6a3eca1dea3b2e443291c97ba3185bc9f70f3cfd)




## Dependency Updates

- bump @octokit/rest from 16.35.2 to 16.43.1 [`46f945f`](https://github.com/fomantic/Fomantic-UI/commit/46f945fd1bb298c46c7982c03da41e01a96df57c)
- bump all-contributors-cli from 6.13.0 to 6.14.0 [`4deee38`](https://github.com/fomantic/Fomantic-UI/commit/4deee388e5cf2a4f002ae5f190012f5d271e9575)
- bump less from 3.10.3 to 3.11.1 [`fc74780`](https://github.com/fomantic/Fomantic-UI/commit/fc74780c4170c5c11dbcdd75b10b53491a5e58ce)



## [2.8.3](https://github.com/fomantic/Fomantic-UI/compare/2.8.2...2.8.3)

> 23 December 2019

## Changes and new Features

### Dropdown

- add unfilterable item class for search input [`8b5625a`](https://github.com/fomantic/Fomantic-UI/commit/8b5625ad4d6df9188a280e800a2e61f9208d3a03)

### Icon

- update icons to FA 5.12.0 [`fea61f9`](https://github.com/fomantic/Fomantic-UI/commit/fea61f918e1d6c74549661e225f2d46be10c7049)

### Modal

- allow close icon to be inside header for small modals [`de0e2b8`](https://github.com/fomantic/Fomantic-UI/commit/de0e2b895f027ddf257097abffcf694442c60c91)



## Bug Fixes

### Checkbox

- ie11 support for non existing event [`e93abbe`](https://github.com/fomantic/Fomantic-UI/commit/e93abbe3c0a9cae037cf0e1d3dd44a20150dd6aa)

### Dimmer

- borders on partial segment dimmers are incorrect [`10b59be`](https://github.com/fomantic/Fomantic-UI/commit/10b59be18003e8ff0f49cef1222c93d4aa55bf11)

### Form

- add rule method overwrites existing rules [`70d538c`](https://github.com/fomantic/Fomantic-UI/commit/70d538c2527263f50dedab5d4ebf60e258cc279f)

### Popup

- tooltips don't work on safari &lt;= 12.1 [`dde63c4`](https://github.com/fomantic/Fomantic-UI/commit/dde63c4475acd56c33a49a532d88706bf0ac46e7)



## Chore

- update issue/pr templates [`c40be8d`](https://github.com/fomantic/Fomantic-UI/commit/c40be8dc10c09e3bd66074dcc48d3cee44035c6f)
- update readme contents [`9c6142f`](https://github.com/fomantic/Fomantic-UI/commit/9c6142f5158b61e35d4d2b8770aeb554a18fa1bb)


## Dependency Updates

- bump @octokit/rest from 16.35.0 to 16.35.2 [`6e7104c`](https://github.com/fomantic/Fomantic-UI/commit/6e7104c2820ae354519dbffdff1431a037fdd608)
- bump all-contributors-cli from 6.11.0 to 6.11.2 [`330562f`](https://github.com/fomantic/Fomantic-UI/commit/330562fb1baf544cecb38a283b872cce0a4a4c72)
- bump gulp-git from 2.9.0 to 2.10.0 [`091befd`](https://github.com/fomantic/Fomantic-UI/commit/091befdeba25b102f330281e49e6af1442f255dc)

## Docs

- add snyk badge [`2e6e1aa`](https://github.com/fomantic/Fomantic-UI/commit/2e6e1aad055caa39e11c7237a774da0e64a1d7de)

## New contributors

- [`LolHens`](https://github.com/LolHens) [`d285f16`](https://github.com/fomantic/Fomantic-UI/commit/d285f16fe3981a53602dedd6735a797a2f2cf8da)



## [2.8.2](https://github.com/fomantic/Fomantic-UI/compare/2.8.1...2.8.2)

> 18 November 2019



## Bug Fixes

### Emoji

- make emoji inherit font-size so they don't get cropped [`66c45d8`](https://github.com/fomantic/Fomantic-UI/commit/66c45d8a1adbbe31abd552ea33962647e6e54543)






## [2.8.1](https://github.com/fomantic/Fomantic-UI/compare/2.7.8...2.8.1)

> 13 November 2019

## Changes and new Features

### Calendar

- support type setting as metadata & initialize without JS [`c4221e4`](https://github.com/fomantic/Fomantic-UI/commit/c4221e4fb8a52790c51728fc40975a451b5c45dc)

### Emoji

- add emoji component using tweemoji & joypixels [`4c1d67c`](https://github.com/fomantic/Fomantic-UI/commit/4c1d67c1877546386f1f79894c8b11a36f483cfe)

### Icon

- update icons to FA 5.11.2 [`764ed35`](https://github.com/fomantic/Fomantic-UI/commit/764ed35710f3f895be103d97485f4fe956771526)

### Progress

- made setting to 100% optional when set error/warning [`c2646f1`](https://github.com/fomantic/Fomantic-UI/commit/c2646f176e6cd0f3931e4c330000c3afd78094ba)

### Rating

- float value ratings [`0583dcc`](https://github.com/fomantic/Fomantic-UI/commit/0583dcc1b5e10e9c89d4958487446b54347d6d2a)

### Slider

- add preventCrossover setting for range sliders [`4b1d548`](https://github.com/fomantic/Fomantic-UI/commit/4b1d54894c640896e6554358140e4578159a9bf4)

### Table

- add colored left & right row border [`ca7d653`](https://github.com/fomantic/Fomantic-UI/commit/ca7d653e1748e19eba04e94f92aa083df4623b57)
- color marked cells [`8d08ea2`](https://github.com/fomantic/Fomantic-UI/commit/8d08ea23e7db62f26656a04a5eb65d51d4ccdbe9)


### Misc Changes

- Merge pull request [`#1091`](https://github.com/fomantic/Fomantic-UI/issues/1091) from fomantic/dependabot/npm_and_yarn/develop/octokit/rest-16.33.1 [`fb7b98c`](https://github.com/fomantic/Fomantic-UI/commit/fb7b98c23c55e6cd0b20360fabe6e0e1baed3006)


## Bug Fixes

### API

- set context in beforesend to match docs [`e2b8a06`](https://github.com/fomantic/Fomantic-UI/commit/e2b8a060aa21c401e2bef7b10de0fbf13419109c)

### Card

- horizontal cards on mobile got cut [`7d07c8c`](https://github.com/fomantic/Fomantic-UI/commit/7d07c8ca982ee2878b205d78f80890e862a3b9aa)
- right image border in horizontal cards [`74d15b5`](https://github.com/fomantic/Fomantic-UI/commit/74d15b56cd3583d602c66b05f2f292d5501fca8c)

### Dimmer

- remove page dimmer border radius [`d5b66eb`](https://github.com/fomantic/Fomantic-UI/commit/d5b66eb242b8d0c5239956f9ba7a754a54911b78)

### Dropdown

- multiselect removing wasn't working [`327003f`](https://github.com/fomantic/Fomantic-UI/commit/327003fc68e00917176f51b797f26952eaa75cfd)
- parameter count resulted in wrong data for onchange [`bce515b`](https://github.com/fomantic/Fomantic-UI/commit/bce515b8f662d7d261b05993f9a9a122ff050c3d)
- remove required attribute from select [`00a87d2`](https://github.com/fomantic/Fomantic-UI/commit/00a87d28bb9f1ee2ddd4ec76e177fa0d39d6d486)
- setting value of dropdown did not remove search [`093b901`](https://github.com/fomantic/Fomantic-UI/commit/093b90164589a23304a84caa9612cf3e1a3e5233)
- value on empty selects [`3d329c2`](https://github.com/fomantic/Fomantic-UI/commit/3d329c2721cfd2c03f470b6b78532da1cddffae5)

### Emoji

- change emoji path to use svg [`9855d54`](https://github.com/fomantic/Fomantic-UI/commit/9855d54a1fa280baeeb4032b538a30527a8e43d5)

### Grid

- override grid container widths [`f0ba553`](https://github.com/fomantic/Fomantic-UI/commit/f0ba5531959e82cda9ad9e4ffea86febc83ba493)

### Input

- icon inputs have wrong padding when inside menus [`fdae269`](https://github.com/fomantic/Fomantic-UI/commit/fdae2697b319b5c06e2ab45d6dfa67b24e9537bc)

### List

- use hex for unicode character to avoid encoding errors [`6187bae`](https://github.com/fomantic/Fomantic-UI/commit/6187bae41c3e15cc01a80465878539ac9101dc73)

### Modal

- clicking on scrollbar with rtl enabled should not close the modal [`dd14fba`](https://github.com/fomantic/Fomantic-UI/commit/dd14fbafc3aec10345cc4178edc258f59bc7993d)
- dont close modal when scrollbar is clicked in rtl environment [`2d894f1`](https://github.com/fomantic/Fomantic-UI/commit/2d894f1ae20b86612965fd17962171d85afd81a5)
- fetch dimmer click if not detached [`49fddb1`](https://github.com/fomantic/Fomantic-UI/commit/49fddb19aa7b5dfc5c695c89a6b3ad38a5109857)
- support rtl left scrollbar behaviors [`3313552`](https://github.com/fomantic/Fomantic-UI/commit/3313552771e0e633a3fba388ae9e47b13a42aa64)

### Popup

- avoid detection of wrong existing popup [`4473b66`](https://github.com/fomantic/Fomantic-UI/commit/4473b66f71e8ba8ea6d7d1c3d93cc4f3053c9a56)

### Slider

- handle touchevent on devices using jquery2 [`3ecaec0`](https://github.com/fomantic/Fomantic-UI/commit/3ecaec0c5fc901342c07ef2c8716fc71b32cb1f9)
- hidden sliders cause browser freeze [`669c3b3`](https://github.com/fomantic/Fomantic-UI/commit/669c3b324751ab74e135067c4c3747fb11ba6beb)


### Build Fixes

- variables in @site.variables were ignored [`4d3f3e4`](https://github.com/fomantic/Fomantic-UI/commit/4d3f3e46ff19ca1395e480ad8f4862826d6eb907)


## Chore

- add labels to new issue to reduce triage effort [`7521889`](https://github.com/fomantic/Fomantic-UI/commit/7521889a33a0165430fdc53f06e81eb17787e517)
- merge master into develop [`0d0dcbf`](https://github.com/fomantic/Fomantic-UI/commit/0d0dcbf16e10a3cb45558f1948f12fcdae64c1e5)
- permission value should transform into octal [`2563aa6`](https://github.com/fomantic/Fomantic-UI/commit/2563aa67a5604066fdcb6490dfb538a8535fa1ea)


## Dependency Updates

- bump @octokit/rest from 16.28.7 to 16.34.1 [`e6fe26d`](https://github.com/fomantic/Fomantic-UI/commit/e6fe26d382a6ad50476631d22cdd13274a7870e4)
- bump all-contributors-cli from 6.8.1 to 6.10.0 [`7870214`](https://github.com/fomantic/Fomantic-UI/commit/78702149ee01a0410652630d0648a4eb0c8a1eff)
- bump auto-changelog from 1.15.0 to 1.16.1 [`d9e7f2d`](https://github.com/fomantic/Fomantic-UI/commit/d9e7f2d9e2f4e8a9b8a76adf5090ba3096898d90)

## Docs

- add 2.8 info [`723c3ba`](https://github.com/fomantic/Fomantic-UI/commit/723c3badb404698e48cacce232c6a27fa9d2c5b4)
- add lubber-de to funding info as suggested [`3573f61`](https://github.com/fomantic/Fomantic-UI/commit/3573f61fc1949c4c6d45613f50c4523cba821296)
- add nightly build info [`272b92a`](https://github.com/fomantic/Fomantic-UI/commit/272b92a396cf5e985212d83d7f0239cd23a78e62)
- update CONTRIBUTORS.md [`960c0ec`](https://github.com/fomantic/Fomantic-UI/commit/960c0ec66fbaf3845d6fd7dcc6744ed31261f578)
- update README.md [`a8a870a`](https://github.com/fomantic/Fomantic-UI/commit/a8a870ad72cea4f118c895a0ea7bd5f5b2df9348)

## New contributors

- [`HypertextPP`](https://github.com/HypertextPP) [`078d978`](https://github.com/fomantic/Fomantic-UI/commit/078d9780c8c6dec0daa2a13154f67283b3424bce)
- [`RShalman`](https://github.com/RShalman) [`cb8ec2d`](https://github.com/fomantic/Fomantic-UI/commit/cb8ec2d561e1816b65eababd812d7ebb1932313b)
- [`RenonDis`](https://github.com/RenonDis) [`301cbdc`](https://github.com/fomantic/Fomantic-UI/commit/301cbdce3bcc07957814e4ea75bdc73fa9188422)
- [`aardbol`](https://github.com/aardbol) [`15279f1`](https://github.com/fomantic/Fomantic-UI/commit/15279f1ff2139a11595bd8b7b1dbb8208d594678)
- [`aexvir`](https://github.com/aexvir) [`ffe203a`](https://github.com/fomantic/Fomantic-UI/commit/ffe203ab6bb6fce8c485238c83df20264a11a8fd)
- [`cruzdanilo`](https://github.com/cruzdanilo) [`0e95ebd`](https://github.com/fomantic/Fomantic-UI/commit/0e95ebd8b9b65270e182994cd76688205ce237f4)
- [`iwgx`](https://github.com/iwgx) [`42ce1ed`](https://github.com/fomantic/Fomantic-UI/commit/42ce1edafbe86192807ab9d083c4eebd8146d908)
- [`josejbarneto`](https://github.com/josejbarneto) [`9f4f857`](https://github.com/fomantic/Fomantic-UI/commit/9f4f857115e867813feb419695835026db2b9c71)
- [`justkey007`](https://github.com/justkey007) [`62978dd`](https://github.com/fomantic/Fomantic-UI/commit/62978dd97f498fc16f86ae6897247731b81db417)
- [`rmarchiori`](https://github.com/rmarchiori) [`8df2185`](https://github.com/fomantic/Fomantic-UI/commit/8df2185104b36c053d23fb7ca497b7dc6db876e3)
- [`ryamaguchi0220`](https://github.com/ryamaguchi0220) [`4b6034a`](https://github.com/fomantic/Fomantic-UI/commit/4b6034a8cf240a80d19e96497d977d37d20d0196)
- [`shui91`](https://github.com/shui91) [`ee8a3d3`](https://github.com/fomantic/Fomantic-UI/commit/ee8a3d31fde2c281b7235963be13b93d1777504c)
- [`simondarke`](https://github.com/simondarke) [`ef7f454`](https://github.com/fomantic/Fomantic-UI/commit/ef7f45497ae0a8cb4f0fb96c37b951c24b92261e)
- [`zombietfk`](https://github.com/zombietfk) [`7eae660`](https://github.com/fomantic/Fomantic-UI/commit/7eae660e0b8e467030d6a8491ad0b71463aafb80)



## [2.7.8](https://github.com/fomantic/Fomantic-UI/compare/2.7.7...2.7.8)

> 1 September 2019

## Changes and new Features

### Form

- check for existing calendar, dropdown or checkbox modules [`d0aecbe`](https://github.com/fomantic/Fomantic-UI/commit/d0aecbe3918d5ecff1d5f8ae08dd596b7003585d)

### Tab

- auto activate first tab if no active specified [`3e129a0`](https://github.com/fomantic/Fomantic-UI/commit/3e129a0de2acdf9142d5ec12ce8bfa5cf345f898)



## Bug Fixes

### Dropdown

- keep input field focus if it's an menu item [`1df7676`](https://github.com/fomantic/Fomantic-UI/commit/1df767622b25040fba2da65d675c4029c66536f8)
- sanitize initial values to prevent xss on firefox & ie [`f7c24ac`](https://github.com/fomantic/Fomantic-UI/commit/f7c24ace480ef0f98350d8192caff44f42adf0a9)




## Dependency Updates

- bump conventional-changelog-cli from 2.0.21 to… [`ddbaf51`](https://github.com/fomantic/Fomantic-UI/commit/ddbaf5143fb2aa561e4f5c1a87fafbcd7cf91e29)
- bump inquirer from 6.5.0 to 6.5.2 [`e5468c7`](https://github.com/fomantic/Fomantic-UI/commit/e5468c71ccdfc4d27e672d11d2b22fb2a157a9c7)
- bump less from 3.9.0 to 3.10.3 [`13dcab1`](https://github.com/fomantic/Fomantic-UI/commit/13dcab19f13bb1f01ecd0ff04afd7205da3e02f6)
- replace conventional-changelog [`c7ed685`](https://github.com/fomantic/Fomantic-UI/commit/c7ed685c4ce9f04904f97ed095643e8a8741c65c)

## Docs

- correct typo in example code [`a3974d1`](https://github.com/fomantic/Fomantic-UI/commit/a3974d1fba6532c7c8a4ba3438cf0487ab54f86f)
- replace build badge with GHA [`495dd56`](https://github.com/fomantic/Fomantic-UI/commit/495dd56c2ea836bd89a49d82d4065600c3983c22)

## New contributors

- [`0xflotus`](https://github.com/0xflotus) [`1375310`](https://github.com/fomantic/Fomantic-UI/commit/13753100ea2a73d1f6014c77a60b0f371142616f)
- [`GammaGames`](https://github.com/GammaGames) [`608a036`](https://github.com/fomantic/Fomantic-UI/commit/608a0363784f3396b379818bda4574176bc063d9)
- [`MikeyFriedChicken`](https://github.com/MikeyFriedChicken) [`42bba19`](https://github.com/fomantic/Fomantic-UI/commit/42bba199f7dcc666192384b1ac2fcd08a7e4ae22)
- [`bartocc`](https://github.com/bartocc) [`a3cf0ae`](https://github.com/fomantic/Fomantic-UI/commit/a3cf0ae702d2e7db46101824ded8d87e65e1b0ca)
- [`bborn`](https://github.com/bborn) [`f405b9b`](https://github.com/fomantic/Fomantic-UI/commit/f405b9b88ed92c52ce42edd314886145e0f8e7e6)
- [`danthedeckie`](https://github.com/danthedeckie) [`3c6bdf8`](https://github.com/fomantic/Fomantic-UI/commit/3c6bdf833f531678ffd0f2fc993197d7fe9a8ae8)
- [`douglasg14b`](https://github.com/douglasg14b) [`3cd7e8c`](https://github.com/fomantic/Fomantic-UI/commit/3cd7e8cef18572db534f9a3cdec5cf8776749221)
- [`dutrieux`](https://github.com/dutrieux) [`704490c`](https://github.com/fomantic/Fomantic-UI/commit/704490ccc4f5516d80ffccb052ee4b059f193d56)
- [`egoisticalgoat`](https://github.com/egoisticalgoat) [`2510762`](https://github.com/fomantic/Fomantic-UI/commit/251076267cf5dcb8d738bfed3aa221faa01d6b60)
- [`euangoddard`](https://github.com/euangoddard) [`c3e4d9e`](https://github.com/fomantic/Fomantic-UI/commit/c3e4d9e62d1a121ad3213d6a63a78b02e11942e0)
- [`globophobe`](https://github.com/globophobe) [`2268039`](https://github.com/fomantic/Fomantic-UI/commit/2268039367dcff38013d123f63819ada7463c685)
- [`iarspider`](https://github.com/iarspider) [`e1debec`](https://github.com/fomantic/Fomantic-UI/commit/e1debec30d57bb86ad1906a394fcbc7c42984f13)
- [`ko2in`](https://github.com/ko2in) [`7fe7f2c`](https://github.com/fomantic/Fomantic-UI/commit/7fe7f2c31f1fe46efa0a74a9507a565ddf26b14f)
- [`patilkiranm`](https://github.com/patilkiranm) [`0b14613`](https://github.com/fomantic/Fomantic-UI/commit/0b14613641cf5e89847170813afe3b9f2cbd1620)
- [`rubenhbaca`](https://github.com/rubenhbaca) [`b554539`](https://github.com/fomantic/Fomantic-UI/commit/b55453913b037a959dfd9a27d766bf6488c6f314)
- [`ryamaguchi0220`](https://github.com/ryamaguchi0220) [`24abc18`](https://github.com/fomantic/Fomantic-UI/commit/24abc187e69bbcae942df584e6a3b42e404c6a14)
- [`ventura-eesc`](https://github.com/ventura-eesc) [`bdbe099`](https://github.com/fomantic/Fomantic-UI/commit/bdbe099addfbddc002f497e17c13de0708ca72a9)
- fix contributors layout [`9b882bb`](https://github.com/fomantic/Fomantic-UI/commit/9b882bb91a874646dc0a0e316411978c7723cab3)



## [2.7.7](https://github.com/fomantic/Fomantic-UI/compare/2.7.6...2.7.7)

> 28 July 2019

## Changes and new Features

### Modal

- destroy should tear down mutation observer [`d880d35`](https://github.com/fomantic/Fomantic-UI/commit/d880d35664832786e59da027543bb240607133fa)


### Misc Changes

- remove whitespace [`cf440f4`](https://github.com/fomantic/Fomantic-UI/commit/cf440f4856ab7163914a8768a3e9cc1ed90e7341)


## Bug Fixes

### Form

- prompt template function [`cc97a30`](https://github.com/fomantic/Fomantic-UI/commit/cc97a304f16875dd9ba8157cf00d4ef0d5bd7c13)

### Image

- hidden images were still visible when used in image groups [`a0bf2b3`](https://github.com/fomantic/Fomantic-UI/commit/a0bf2b3ba72c1f15e13e889c9b38c2dbdf14a860)

### Label

- content margin after two attached labels [`2510ea9`](https://github.com/fomantic/Fomantic-UI/commit/2510ea90840e9208262df79c137ec61fb99ddb21)




## Dependency Updates

- [security] bump lodash from 4.17.11 to 4.17.14 [`265a206`](https://github.com/fomantic/Fomantic-UI/commit/265a2069c2c2ec5d3dddddde98ca166aaf9b1f68)
- [security] bump lodash.merge from 4.6.1 to 4.6.2 [`cc19442`](https://github.com/fomantic/Fomantic-UI/commit/cc19442222b2b0006c201cd013376e8f46c59754)
- bump @octokit/rest from 16.16.0 to 16.28.7 [`846b06f`](https://github.com/fomantic/Fomantic-UI/commit/846b06f322e52111cf91ec01423cf195823df44f)
- bump all-contributors-cli from 6.7.0 to 6.8.1 [`d772e55`](https://github.com/fomantic/Fomantic-UI/commit/d772e55991661f45ad740903b53fc2089b1834a4)
- bump gulp-autoprefixer from 6.0.0 to 6.1.0 [`fdea8ff`](https://github.com/fomantic/Fomantic-UI/commit/fdea8ffd091a6f07e49246383c9f2d01491e0431)
- bump gulp-header from 2.0.7 to 2.0.9 [`f71993c`](https://github.com/fomantic/Fomantic-UI/commit/f71993cec91e914f510f62445662e7a5be7f2fc7)
- bump gulp-json-editor from 2.5.0 to 2.5.3 [`7d0715d`](https://github.com/fomantic/Fomantic-UI/commit/7d0715d0a7a4d7e6a6de6abe025f208d3dba290e)
- bump gulp-print from 5.0.0 to 5.0.2 [`da41952`](https://github.com/fomantic/Fomantic-UI/commit/da4195203bd3573a857a4c147ab75bc1677eded9)
- bump gulp-rtlcss from 1.3.0 to 1.4.0 [`31b3bcf`](https://github.com/fomantic/Fomantic-UI/commit/31b3bcf21d137540c12781cf11c48d7f7f9bf5f2)
- bump gulp-uglify from 3.0.1 to 3.0.2 [`f599033`](https://github.com/fomantic/Fomantic-UI/commit/f599033eaa132ad1b4932f35bba1bfebae84602e)
- bump inquirer from 6.2.2 to 6.5.0 [`92414f0`](https://github.com/fomantic/Fomantic-UI/commit/92414f00f8690377d9e7d9d9a61ffca60afc0517)
- bump jquery from 3.4.0 to 3.4.1 [`28a6cd6`](https://github.com/fomantic/Fomantic-UI/commit/28a6cd6d8690a293e61aea39ff59b514b4d7265d)
- bump lodash from 4.17.11 to 4.17.14 [`98bdde6`](https://github.com/fomantic/Fomantic-UI/commit/98bdde63b9da992c03e61d7ebb3c31b6305a6534)
- bump lodash.merge from 4.6.1 to 4.6.2 [`669eb24`](https://github.com/fomantic/Fomantic-UI/commit/669eb2401931e0d781d3813f47f012082f81baff)
- bump merge-stream from 1.0.1 to 2.0.0 [`b3501f9`](https://github.com/fomantic/Fomantic-UI/commit/b3501f92cedf4407e9198dd931223b97d2159813)

## Docs

- fix formatting issue [`cb7b652`](https://github.com/fomantic/Fomantic-UI/commit/cb7b6522c178abd16e3c504fb824979d08d94473)
- fix repository typo [`9611bf0`](https://github.com/fomantic/Fomantic-UI/commit/9611bf03304cf09eb8f484374a62b2581dad5489)
- update badges and add other packages [`489e801`](https://github.com/fomantic/Fomantic-UI/commit/489e801f10410bb0d622ea6b658ffdb6b56a110f)
- update info [`adcfe60`](https://github.com/fomantic/Fomantic-UI/commit/adcfe601e7c474415692efcb7027156582633a38)

## New contributors

- add all-contributors [`b006c54`](https://github.com/fomantic/Fomantic-UI/commit/b006c5498e7f9e3230c8cafcd50bdcb6c09542b6)



## [2.7.6](https://github.com/fomantic/Fomantic-UI/compare/2.7.5...2.7.6)

> 16 June 2019

## Changes and new Features

### Progress

- add indeterminate states [`816fbbd`](https://github.com/fomantic/Fomantic-UI/commit/816fbbd257ba30a4c2b95299f12aac125268fb0b)


### Misc Changes

- clean up deprecated symbols [`601f504`](https://github.com/fomantic/Fomantic-UI/commit/601f50452c304adf03f4e2f55a7ae375e6806b30)


## Bug Fixes

### Button

- center text in fluid & vertically aligned button group [`bfd7c84`](https://github.com/fomantic/Fomantic-UI/commit/bfd7c8496e89158e63bcc93f46288733caa3c2b0)

### Form

- remove rule function lead to TypeError [`752827e`](https://github.com/fomantic/Fomantic-UI/commit/752827e5895e50d36a7c88202d85b138ea4c9ead)
- transparent input padding and texarea support [`dd561b5`](https://github.com/fomantic/Fomantic-UI/commit/dd561b5e7bb953f8c08ca27d58df798ae117c201)



## Chore

- add FUNDING file [`b132715`](https://github.com/fomantic/Fomantic-UI/commit/b1327153b6f227cd0abd3cec7f0168db150ab537)


## Docs

- add security policy [`2545595`](https://github.com/fomantic/Fomantic-UI/commit/2545595804f3c4b6c230ea04e952208a30c31190)
- update with more detail [`d95b0c7`](https://github.com/fomantic/Fomantic-UI/commit/d95b0c79956d9eb01233023fe2938250d95b9e54)



## [2.7.5](https://github.com/fomantic/Fomantic-UI/compare/2.7.4...2.7.5)

> 9 May 2019

## Changes and new Features

### Breadcrumb

- add inverted variant [`ff6ba2d`](https://github.com/fomantic/Fomantic-UI/commit/ff6ba2d0ab95c7f6d3c8b08ac5a4fd2b106a8245)

### Checkbox

- vertically align checkbox in fields [`dcf3976`](https://github.com/fomantic/Fomantic-UI/commit/dcf3976db08b338635340c6e5742a5aef9635a0c)

### Divider

- add horizontal divider alignment variation [`1981277`](https://github.com/fomantic/Fomantic-UI/commit/1981277500d62863a6aed1afddeca0b2e707b011)

### Dropdown

- add scrolling support for simple variant [`9c8f18f`](https://github.com/fomantic/Fomantic-UI/commit/9c8f18f09b3dcd9f04afc25379a039d895bb0999)

### Form

- add calendar input field [`8152b38`](https://github.com/fomantic/Fomantic-UI/commit/8152b38e4d7c85cfc3bbd27bafb45d1e63b110df)
- add dirty and clean states, and ability to cancel submit [`adf5937`](https://github.com/fomantic/Fomantic-UI/commit/adf593733e0ed463dcb18b697f651a5df91143e5)


### Misc Changes

- set context in beforesend to $module instead of possible stateContext to match docs [`57718ce`](https://github.com/fomantic/Fomantic-UI/commit/57718cee7998893703b1a4b492645d7f496f6054)


## Bug Fixes

### API

- module callback function typo [`43c2c8b`](https://github.com/fomantic/Fomantic-UI/commit/43c2c8b3b3eb8ba051abe0d7fd9fbb8c7799c80a)
- set context in beforesend to $module instead of possible stateContext to match docs [`004616f`](https://github.com/fomantic/Fomantic-UI/commit/004616ffabbefeab75818667d2f2e5d9f005433b)

### Breadcrumb

- increase line height for readability on wrapped content [`c7ca707`](https://github.com/fomantic/Fomantic-UI/commit/c7ca707233d352aefef9e0a6492ba458a5dab3e5)

### Calendar

- support dateobject given for parse.date as for initialDate setting [`1a4938a`](https://github.com/fomantic/Fomantic-UI/commit/1a4938a02a0746fe9dc05413f82a3ab001698959)

### Card

- word-wrap overflowing with long strings [`8b75f0f`](https://github.com/fomantic/Fomantic-UI/commit/8b75f0f44a865cfd2be5060a3e4d194e73eb76f9)

### Dimmer

- disable blur on popups [`f10dd0b`](https://github.com/fomantic/Fomantic-UI/commit/f10dd0b63b80824398f9400998bec21e08d1fb02)

### Dropdown

- correct alignment of image and icons within items [`72d3420`](https://github.com/fomantic/Fomantic-UI/commit/72d342091a1d6a98ecef185171fba78527480c2b)
- inverted pointing menu had white arrow [`124625c`](https://github.com/fomantic/Fomantic-UI/commit/124625c50d255a0ada3e2ba851055a854cc67c3c)
- margin missing on upward dropdown [`024f5d4`](https://github.com/fomantic/Fomantic-UI/commit/024f5d4516605cbe8aa4e6aee515c8605c5bc1e2)
- prevent submenu vanish for simple dropdowns [`6998edd`](https://github.com/fomantic/Fomantic-UI/commit/6998edd536baf1b6f1aa938e0a1cce6b13449ef1)

### Input

- error border didn't change input action border [`0aab16f`](https://github.com/fomantic/Fomantic-UI/commit/0aab16f34438ab957f2c9b2656ddb7ddf79cec9d)

### Menu

- correct submenu fix which broke right menus [`af98873`](https://github.com/fomantic/Fomantic-UI/commit/af988735dfbc3d73fc2749feb499a5670eedbf4a)

### Modal

- `autofocus` shouldn’t focus disabled inputs [`fadbc30`](https://github.com/fomantic/Fomantic-UI/commit/fadbc30b570b46dc69ec7316c134f5fa3a6c1313)
- dont close dimmer when another modal is still animating [`58cf41a`](https://github.com/fomantic/Fomantic-UI/commit/58cf41ae3732b4fe2846df56c6e28f32b66f2b37)
- dont wrap image content direct images [`5a59ae3`](https://github.com/fomantic/Fomantic-UI/commit/5a59ae3e5cb35f0021ecc835ecfd7ac8c7a1c7ef)
- support fixed menu, toast and sidebar to also not move when a modal is shown [`aeb3274`](https://github.com/fomantic/Fomantic-UI/commit/aeb32742b9a2fc116dd2ac29edd6c43ef700c4c2)
- use direct sibling for content selector [`e4fbb61`](https://github.com/fomantic/Fomantic-UI/commit/e4fbb6155f82220d4ccba8d3eeab74690a6ad017)

### Popup

- support iOS to recognize popup close on touch [`c978917`](https://github.com/fomantic/Fomantic-UI/commit/c978917310b8350330872c9aeaae69781e146e00)

### Progress

- display 0 valued progress bars [`a92b8ac`](https://github.com/fomantic/Fomantic-UI/commit/a92b8acec3e0e1219bae4b90fc19b3c6f0d5878a)

### Search

- undefined internal variable [`7b89336`](https://github.com/fomantic/Fomantic-UI/commit/7b893367050b43790e8a14226c10e46c16821f51)

### Table

- definition table footer had wrong box-shadow to the left [`96b97f3`](https://github.com/fomantic/Fomantic-UI/commit/96b97f3b77e09132b3fbdc10ae42dc49d0b5a832)
- don't break style when nested tables [`9760d91`](https://github.com/fomantic/Fomantic-UI/commit/9760d917a2275461a373ab5d1b86143084876999)
- selectable rows/cells should have pointing cursor [`7742fa3`](https://github.com/fomantic/Fomantic-UI/commit/7742fa319f24ceba1f23ff5b4f9541448efbad52)



## Chore

- add all reviewers and add exoego as reviewer [`12858b5`](https://github.com/fomantic/Fomantic-UI/commit/12858b50efc5e00fa722e4438d0c83593b8bf29e)
- clean up files and correct spelling and links [`25738d5`](https://github.com/fomantic/Fomantic-UI/commit/25738d5268a3488dc1f55b36dc4ef0deb8eae395)
- modify probot configs [`5aa461e`](https://github.com/fomantic/Fomantic-UI/commit/5aa461e27b115674af985180b8c45e482c4c3ea7)
- moved some core css to less files from default overrides and always include default overrides first [`2bfe9a5`](https://github.com/fomantic/Fomantic-UI/commit/2bfe9a5c78a0434ce0a6eb1425d6b31ad1a8177e)
- refactor field positions and add info [`bfa7873`](https://github.com/fomantic/Fomantic-UI/commit/bfa7873c2c95823c7fd4c69fe96eb83aa48a483e)
- switched comment blocks to Fomantic UI references [`72e5a24`](https://github.com/fomantic/Fomantic-UI/commit/72e5a247017a7f567d53c0ae007691379f2184ec)


## Dependency Updates

- add conventional-changelog-cli [`6cb4a67`](https://github.com/fomantic/Fomantic-UI/commit/6cb4a675e621c3a91bc486d503a40a9bf8334bd2)
- update jquery [`8cc8edd`](https://github.com/fomantic/Fomantic-UI/commit/8cc8edd6ad259c8b603ab038d1a76a44de3e78ba)

## Docs

- add jetbrains logo [`769c370`](https://github.com/fomantic/Fomantic-UI/commit/769c370d99a84cb3a1e65e407bf604dc33996850)
- fix "submitting" typo [`d75e851`](https://github.com/fomantic/Fomantic-UI/commit/d75e8511f14c3016997f2bbbe4ae3891575f9d5b)



## [2.7.4](https://github.com/fomantic/Fomantic-UI/compare/2.7.3...2.7.4)

> 2 April 2019








## [2.7.3](https://github.com/fomantic/Fomantic-UI/compare/2.7.2...2.7.3)

> 2 April 2019

## Changes and new Features

### API

- don't throw error on all 2xx status codes [`407446e`](https://github.com/fomantic/Fomantic-UI/commit/407446e3781fc7ddf55f75ba0e64bb22c6d12b82)

### Calendar

- ability to select adjacent month dates [`e21a158`](https://github.com/fomantic/Fomantic-UI/commit/e21a1580ca43a73cc49af122d3c45fcb0e49136f)
- expose week cell class setting [`85c0db2`](https://github.com/fomantic/Fomantic-UI/commit/85c0db28391fa4e660b679bde87c763416c92442)

### Checkbox

- visual support for indeterminate toggle [`07524f0`](https://github.com/fomantic/Fomantic-UI/commit/07524f077a4853cfae104c61d5c640d2fe88a13c)

### Modal

- don't move content and modal on dimmer when scrollbar hides [`63ddcdd`](https://github.com/fomantic/Fomantic-UI/commit/63ddcdd33764e1cb5188d9206405a5481b0e5203)

### Progress

- add multiple bars support [`c384e83`](https://github.com/fomantic/Fomantic-UI/commit/c384e8356181371804d8ad475e4a20a19d127ca6)

### Step

- add arrows in stacked steps [`3f913df`](https://github.com/fomantic/Fomantic-UI/commit/3f913dfdcf57f324d9826427435a1538c4fa86f1)



## Bug Fixes

### Button

- basic button loop always used primary for margin [`c44b09b`](https://github.com/fomantic/Fomantic-UI/commit/c44b09b6ca4225505c19412443cc64f0e814d91e)
- fluid labeled icon button padding [`c88cbb3`](https://github.com/fomantic/Fomantic-UI/commit/c88cbb318ae95859ca75813f0491f6d3dcb7e802)

### Calendar

- fix day calculation if year had 2-digit notation [`2ebca94`](https://github.com/fomantic/Fomantic-UI/commit/2ebca94e27c8fa66bc6f715df2e2bc23da8fb4c3)
- initialDate now update input [`7e30c28`](https://github.com/fomantic/Fomantic-UI/commit/7e30c280b334861b1d6ae219f976c9623ea2e38f)

### Card

- add missing inverted colors [`23b9594`](https://github.com/fomantic/Fomantic-UI/commit/23b9594ab78f97d6e79f4a8aa3831647364f0fe5)

### Checkbox

- prevent default events to avoid IE11/Edge resetting the checkbox [`00191d2`](https://github.com/fomantic/Fomantic-UI/commit/00191d266509575389f52f91875567039578fe06)

### Dimmer

- loader was still visible in dimmed dimmer [`549b75c`](https://github.com/fomantic/Fomantic-UI/commit/549b75c8f2cd7de9f7c73ee0b8a68eac22883f69)

### Dropdown

- allow a label to be clickable inside a dropdown button [`4707fa1`](https://github.com/fomantic/Fomantic-UI/commit/4707fa16e89688fc71bdfae9606ba30592687ca8)

### Form

- fields is undefined [`90be786`](https://github.com/fomantic/Fomantic-UI/commit/90be786b7230942564dbafe971e24112e56d82e6)

### Form Validation

- check if field is undefined before accessing [`f7c21e9`](https://github.com/fomantic/Fomantic-UI/commit/f7c21e9d23de6706ec6225c13612580eb2f5e5b9)
- safari didn't show errors [`c177443`](https://github.com/fomantic/Fomantic-UI/commit/c17744359b3438ce6be51166616306a9daefc0ce)

### Input

- add missing tiny size variant [`dc4bf77`](https://github.com/fomantic/Fomantic-UI/commit/dc4bf77b66e8420fefd5b43b4383225944565778)

### Label

- adjusted position of ribbon label used in tables [`9373ca9`](https://github.com/fomantic/Fomantic-UI/commit/9373ca918f8b68b8391b5b891436d292911a968f)

### Menu

- correct right item border in containers [`ab2a277`](https://github.com/fomantic/Fomantic-UI/commit/ab2a277380fca27815a9956a31c9554fd41918d2)

### Modal

- modal was not closable if opened by another modal for a second time [`ff454ad`](https://github.com/fomantic/Fomantic-UI/commit/ff454adc8f8797e6a6f8e738d809a808ea7b0de9)

### Popup

- onHide was called twice [`794a8b8`](https://github.com/fomantic/Fomantic-UI/commit/794a8b8d762716c0ae85116d48fc9dc9596c60f5)

### Progress

- fix 0 percent bars on colored progress [`b817ea7`](https://github.com/fomantic/Fomantic-UI/commit/b817ea737b91c8f328c9253b3353c71d77e97a50)
- inverted progress bars color [`90057fa`](https://github.com/fomantic/Fomantic-UI/commit/90057fa4fdfb6e8ae4132e321febc845c96d1f4e)

### Segment

- fix background for inverter,secondary,tertiary in horizontal group [`9f6ffb0`](https://github.com/fomantic/Fomantic-UI/commit/9f6ffb0d1026be9aaf530cf0a2594b23f492fb5e)
- fix clearing for stacked and piled segments [`c14e3f6`](https://github.com/fomantic/Fomantic-UI/commit/c14e3f67cb07ca590ed41b11f0d0c0b4fb792696)

### Shape

- fix 3D flip starting zoom, nested shapes, ignore child elements with class 'active' [`f5f3f2c`](https://github.com/fomantic/Fomantic-UI/commit/f5f3f2c2b4c08c2153ffd4bf3c778a9fd6c26b66)
- focused checkbox inside shape breaks animation [`1b4aa99`](https://github.com/fomantic/Fomantic-UI/commit/1b4aa99537485d35208d52cb1eb802de2b95b0e1)
- shape transition did not work when child also has a transition set [`76d10d3`](https://github.com/fomantic/Fomantic-UI/commit/76d10d3e658e78dc3b4cc1be090a563de7cf8d64)

### Slider

- don't conflict with checkbox [`9c3ee37`](https://github.com/fomantic/Fomantic-UI/commit/9c3ee376fb594537e35277db61fb59f49790ea5c)

### Tab

- should escape meta characters [`08f24a4`](https://github.com/fomantic/Fomantic-UI/commit/08f24a4c34f88e1ae55445db4cd648536a9d0b3f)

### Table

- inverted variation styles [`7bd4adb`](https://github.com/fomantic/Fomantic-UI/commit/7bd4adb25dd994e710f6ea6e87624eff0dff9586)

### Transition

- transitions made of hidden inline elements were not working anymore [`0a05e9f`](https://github.com/fomantic/Fomantic-UI/commit/0a05e9f97e1cad8ef3a3e14ddb595839fdcbc137)


### Build Fixes

- write metadata.json for docs [`6216d5f`](https://github.com/fomantic/Fomantic-UI/commit/6216d5f406c57fd7de2f5af1fd821bce84d31ba2)



## Dependency Updates

- refactor package dependencies [`a8351fe`](https://github.com/fomantic/Fomantic-UI/commit/a8351fe91743f7f10287c37054d1bfe48cd0063d)
- update bower jQuery dependency [`5958171`](https://github.com/fomantic/Fomantic-UI/commit/595817147f6d638b77191cc6b451521f360d1caf)

## Docs

- add link to merge intention comment [`783786b`](https://github.com/fomantic/Fomantic-UI/commit/783786b5c27bf0252dc47c0277746b4a695210ca)



## [2.7.2](https://github.com/fomantic/Fomantic-UI/compare/2.7.1...2.7.2)

> 5 February 2019

## Changes and new Features

### Dropdown

- add delete icon classname to settings instead of having it hardcoded [`bb32ee8`](https://github.com/fomantic/Fomantic-UI/commit/bb32ee89267e1e5f8a78e2f15925ffdb6a8e2a9a)
- support to ignore diacritics on search [`63a0855`](https://github.com/fomantic/Fomantic-UI/commit/63a08554dd30a49e95de40c12abaebba55895cd0)

### Label

- add left and right aligned floating label [`e1550b4`](https://github.com/fomantic/Fomantic-UI/commit/e1550b43d40da02bad6b5403f163dd31349f3a22)
- content in floating labels should not wrap whitespace [`12be9b1`](https://github.com/fomantic/Fomantic-UI/commit/12be9b150958d682a576d3c8a07294cb75cc2410)
- remove hardcoded color exception "not()" for menu item labels [`207e40e`](https://github.com/fomantic/Fomantic-UI/commit/207e40e167c08c3856f365fcd77c8e7b26c7dfac)
- right icon will be given correct margin when placed after text [`20d6389`](https://github.com/fomantic/Fomantic-UI/commit/20d638998e66dc784581169c6139c8e77669b0f3)

### List

- add suffixed ordered list variation [`6a7352b`](https://github.com/fomantic/Fomantic-UI/commit/6a7352bf1f772e45fac841cc7309d2c910308c0b)

### Loader

- default loader color settings in dimmers affected loaders in modals [`cdfc878`](https://github.com/fomantic/Fomantic-UI/commit/cdfc878a4506e954850be7433a6d5efac776126a)

### Modal

- on modal hide focus the last focused element before the modal was opened [`be9e4c3`](https://github.com/fomantic/Fomantic-UI/commit/be9e4c37de0d019c04a4a672d4576bdf5e75f1cf)

### Step

- steps will wrap by default unless specified as unstackable [`f04011b`](https://github.com/fomantic/Fomantic-UI/commit/f04011b40b0669a74f02d8208479c41f394ab62a)


### Misc Changes

- removed wrong markup and added missing semicolons [`280cad9`](https://github.com/fomantic/Fomantic-UI/commit/280cad9f7623e7fc303d6ef29c95a7cb183fe213)


## Bug Fixes

### Button

- increased size specificity to work with menu item buttons [`1489756`](https://github.com/fomantic/Fomantic-UI/commit/1489756270205e2832ff082f686fb826486f43f3)
- loading icon position in button was not rotating around center [`1f71602`](https://github.com/fomantic/Fomantic-UI/commit/1f7160203ee8a4c7c42dad2815113967571e97b9)
- z-index on attached buttons was shown above dropdown menu [`08e6406`](https://github.com/fomantic/Fomantic-UI/commit/08e6406da11f61875ce7bb244b3a09388e2bb181)

### Dimmer

- show proper webkit scrollbar on inverted variant [`249dfee`](https://github.com/fomantic/Fomantic-UI/commit/249dfeeadb5b049f1ba0d10bcb96c5efbb77a323)
- z-index impact when using blurring dimmer filter [`dbb7ad3`](https://github.com/fomantic/Fomantic-UI/commit/dbb7ad36507932777a1ab76241d68af4b8bc59db)

### Dropdown

- allow a real zero to be a selectable value [`dfa1ea1`](https://github.com/fomantic/Fomantic-UI/commit/dfa1ea14a35c179dc3eb1efff0a3951913cb0f42)
- fix simple dropdown positioning in vertical menus [`ba49f8f`](https://github.com/fomantic/Fomantic-UI/commit/ba49f8f0dbcf161343de989e0bb6ab1472c1e9d9)
- multi dropdown deletes last item when removing input/search text [`b84b814`](https://github.com/fomantic/Fomantic-UI/commit/b84b814f6d4d2c9577c1318e578792405257cabf)
- sanitize possible given text values [`8608a4d`](https://github.com/fomantic/Fomantic-UI/commit/8608a4df7f6758f1979edfa0a996c88056e757ef)
- templates should also use dynamic classnames from settings [`26d6689`](https://github.com/fomantic/Fomantic-UI/commit/26d66892cbee2c9cd952815e85fdf23bce91439b)

### Form

- checkbox and radio (with errors) were only reset if the first option was selected [`6e41efe`](https://github.com/fomantic/Fomantic-UI/commit/6e41efe893f9dd95f0d13d0bdd6b26daaca10396)

### Header

- should have same background color as other inverted components [`25f417e`](https://github.com/fomantic/Fomantic-UI/commit/25f417e4628c9cff1a478e33dc29025496d4b834)

### Icon

- make link and disabled work together correctly, also support icon groups [`cef454e`](https://github.com/fomantic/Fomantic-UI/commit/cef454ea37a812d3bbc7e1de18f24a2d02e75e93)

### Input

- make inverted transparent input in forms appear white [`3c0e6b7`](https://github.com/fomantic/Fomantic-UI/commit/3c0e6b7f6eb0a4de54190dd09f6285354134a57b)
- support error class on input action buttons [`3cbc515`](https://github.com/fomantic/Fomantic-UI/commit/3cbc5154768d7ba1ab1706c883522836190d0b7e)

### Label

- adjust image height of image labels in menu items [`7ac1cb3`](https://github.com/fomantic/Fomantic-UI/commit/7ac1cb3cf93b368cc5de0f0d81d9271853d89f89)
- link icon cursors in corner labels did not work [`f719689`](https://github.com/fomantic/Fomantic-UI/commit/f719689d9995f5f8b867225d04e575a3ce6f2d50)

### List

- adjust position when icon has loading class [`80df182`](https://github.com/fomantic/Fomantic-UI/commit/80df1820327456dbd85c48cc4ac6b46e11b51bf5)
- horizontal lists wrap nicely on small screens [`dbb489c`](https://github.com/fomantic/Fomantic-UI/commit/dbb489ca8d36e356b8513cc7379576734671db28)
- missing pseudo-class leads to invisible list item [`e1d2098`](https://github.com/fomantic/Fomantic-UI/commit/e1d2098fce501a97cab2a469fca4cfb66cdb2868)

### Loader

- elastic loader was not working in Firefox [`62fe856`](https://github.com/fomantic/Fomantic-UI/commit/62fe85672c5cc5ec5323104910db900d36056782)
- elastic style had wrong color applied [`df5701c`](https://github.com/fomantic/Fomantic-UI/commit/df5701c5f41a4a0e09a25ec9a2bb0e84962c9fd7)

### Menu

- corrected support for disabled items in inverted menus [`5318605`](https://github.com/fomantic/Fomantic-UI/commit/53186050fed066de80f7f32ac7b03eee545f9eeb)
- keep auto width for icon menu sizes [`7a204d4`](https://github.com/fomantic/Fomantic-UI/commit/7a204d4bc563b5a524c922d7cd944ce8f0c4e21a)
- labels in secondary pointing menu items were misaligned [`5d9f93a`](https://github.com/fomantic/Fomantic-UI/commit/5d9f93a7090c78c911aef756a8e399f3bbfce223)
- last item in secondary compact menu lost left top/bottom border radius [`b97bd06`](https://github.com/fomantic/Fomantic-UI/commit/b97bd06435ad4df2c43e37912ee6d52eac28053f)
- wrong styles applied to secondary menu [`1372242`](https://github.com/fomantic/Fomantic-UI/commit/1372242f51f3d14e5fbc06c2f078620834cb736b)

### Modal

- prevent closing the modal when webkit scrollbar has been dragged [`bdf30a8`](https://github.com/fomantic/Fomantic-UI/commit/bdf30a81b64044a1890f5e5976ec1407f8fdb8a7)
- reactivate approve/deny event handling if onHide returned false [`3bd454c`](https://github.com/fomantic/Fomantic-UI/commit/3bd454c96a8972f1a813f6cf62e2c8bcd1162b82)

### Popup

- display a popup over a checkbox slider completely [`6be2082`](https://github.com/fomantic/Fomantic-UI/commit/6be208202d80515777b6cf21df31b6b71c27bbd7)

### Progress

- fix 0% display and "inverted indicating" label color [`bad67cb`](https://github.com/fomantic/Fomantic-UI/commit/bad67cb8b4a0be882723909dcf3b0d9761a999fc)

### Search

- don't increase categoryindex if result was empty [`1d8c7ac`](https://github.com/fomantic/Fomantic-UI/commit/1d8c7ac8f4e56a0964ab0ee01e4ab07f99ca868b)

### Segment

- add stackable horizontal segments [`c391574`](https://github.com/fomantic/Fomantic-UI/commit/c3915748f7f612dd2fa6b98e391b75ac020b8ad5)

### Sidebar

- respect a change of closable setting [`4de7c51`](https://github.com/fomantic/Fomantic-UI/commit/4de7c5197b6cdd9bfc5e0582eedeb9737ad367ba)

### Step

- increase specificity of icon size [`23cafb3`](https://github.com/fomantic/Fomantic-UI/commit/23cafb3e7fc4fe5744313b74a2aa2341778c85e6)

### Transition

- remember inline display value and don't show default hidden tags [`73cd274`](https://github.com/fomantic/Fomantic-UI/commit/73cd27440bb366c5cabf856ef9351bb1d725bfb3)




## Docs

- add code of conduct [`4ce3c33`](https://github.com/fomantic/Fomantic-UI/commit/4ce3c3349838f56b83b2fa580a8458eea4da52bb)
- add env setup and change some sentences [`a98a32a`](https://github.com/fomantic/Fomantic-UI/commit/a98a32a9f6ad7bba24ab98c39c631d1894b6be14)
- add roadmap [`ecddf01`](https://github.com/fomantic/Fomantic-UI/commit/ecddf01cd28b5df123c04901cf75754b8e818a78)
- add v3 development message [`a8e7eee`](https://github.com/fomantic/Fomantic-UI/commit/a8e7eee7279d688a227f07473a829e8d96b3a738)
- docs(readme) add travis badge & change last commit branch [`4c9da88`](https://github.com/fomantic/Fomantic-UI/commit/4c9da88f38ba0bae2913b5d667b615c069709351)



## [2.7.1](https://github.com/fomantic/Fomantic-UI/compare/2.7.0...2.7.1)

> 24 December 2018



## Bug Fixes

### Loader

- elastic style had wrong color applied [`b19c2d1`](https://github.com/fomantic/Fomantic-UI/commit/b19c2d145d4f3dd4a09cb03026425ffa9558e445)






## [2.7.0](https://github.com/fomantic/Fomantic-UI/compare/2.6.4...2.7.0)

> 21 December 2018

## Changes and new Features

### API

- add ability to handle array responses in onResponse handler [`d5ec1f8`](https://github.com/fomantic/Fomantic-UI/commit/d5ec1f8636346fc1cea543cc4ccfc2c25ec2155e)

### Calendar

- add timegap setting to expand time selector [`cc639de`](https://github.com/fomantic/Fomantic-UI/commit/cc639de84ff835368ba4497b2d8420c6e16d4abd)

### Input

- support corner label and icon for textarea [`d2aa74d`](https://github.com/fomantic/Fomantic-UI/commit/d2aa74d9c2a4c599e83b2e4e03f8df8b363610f6)

### Loader

- add new variants, module support and refactor colors [`5bd8d2a`](https://github.com/fomantic/Fomantic-UI/commit/5bd8d2a52bb9a5d0a36c2083bcc7a8add1a60e03)

### Rating

- add individual icons and colors instead of fixed star & heart only [`a341fd9`](https://github.com/fomantic/Fomantic-UI/commit/a341fd9a827efd7f29ad4fa4878b789c6b907348)

### Toast

- changed title class to header [`128769f`](https://github.com/fomantic/Fomantic-UI/commit/128769f6b145d14844cfa1fee3430fdde0672f35)
- use the same color on every inverted toast [`deb1ec7`](https://github.com/fomantic/Fomantic-UI/commit/deb1ec7bf102d427c2744007764e759f98827a9f)


### Misc Changes

- improve consistency [`207e948`](https://github.com/fomantic/Fomantic-UI/commit/207e9483b36a384c0702e44609fde67905d8b50a)


## Bug Fixes

### Checkbox

- support onChange for cursor keynav [`3fec1ec`](https://github.com/fomantic/Fomantic-UI/commit/3fec1ecd191ffb362eb22b02062c531d50617f6c)

### Dropdown

- filter already selected items when using remote api [`fd3646a`](https://github.com/fomantic/Fomantic-UI/commit/fd3646ad05f0dd9e5630564002180463b6f59c78)
- filter preselected entries from [`#287`](https://github.com/fomantic/Fomantic-UI/issues/287) was not working for div-dropdowns [`fc000b7`](https://github.com/fomantic/Fomantic-UI/commit/fc000b74d038e13ff74bbef802d8ee02e2188a02)
- fixes submenu positioning [`26dbfe7`](https://github.com/fomantic/Fomantic-UI/commit/26dbfe70691ac668f36bb5ae1bd0dbd7b053b783)
- preselected values are ignored when data has individual value-name [`9f34023`](https://github.com/fomantic/Fomantic-UI/commit/9f34023f0b3d4c27981695a695a063ab9fed0171)
- show "no results" when filterRemoteData is false and response is empty [`b700b93`](https://github.com/fomantic/Fomantic-UI/commit/b700b93d4d9fbb67aeb116ccee720b2a0933ff0c)
- stop event on enterkey and multiple allowadditions to prevent form submission [`53267ee`](https://github.com/fomantic/Fomantic-UI/commit/53267ee7434d69b9c96580cb726469d4307e8ff0)

### List

- make sure list settings are not applied to any "list icon" [`fd63cc9`](https://github.com/fomantic/Fomantic-UI/commit/fd63cc943ff127f6c4ab7c5e76bda419386920b5)

### Menu

- hotfixes for 2.7 [`6e72bcc`](https://github.com/fomantic/Fomantic-UI/commit/6e72bcc4aaec3082790292e91db81221301ae03b)

### Message

- fixed compact icon message width [`c6d9334`](https://github.com/fomantic/Fomantic-UI/commit/c6d9334069c521aab1c53ceabc0cdf0bb407b6b1)

### Modal

- touch scrolling (dropdown, content, focussed input) fixed [`f7cc7b5`](https://github.com/fomantic/Fomantic-UI/commit/f7cc7b538a1217b6930ceb3055ff0f593a118ede)

### Placeholder

- Respect a possible 'image icon' not occupying the same space as a real image should [`c053e23`](https://github.com/fomantic/Fomantic-UI/commit/c053e232e9a51c136d5ff0906439c471edf433eb)

### Popup

- fix correct usage for addTouchEvents=false [`24fcf68`](https://github.com/fomantic/Fomantic-UI/commit/24fcf6897101abb7480485b75d5b7be256659737)

### Table

- restore default vertical alignment [`493fd7f`](https://github.com/fomantic/Fomantic-UI/commit/493fd7f149da83b365a57e628fbcf32f14797b1c)
- thead and tbody missed alignment inheritance [`18238f1`](https://github.com/fomantic/Fomantic-UI/commit/18238f1612f049689df236c87c927918b8209262)

### Text

- add text component to gulp tasks [`4ecfa02`](https://github.com/fomantic/Fomantic-UI/commit/4ecfa0251409ff586e38d9df7f497050469b3d53)




## Docs

- add gulp4 upgrade notice [`6ff5a07`](https://github.com/fomantic/Fomantic-UI/commit/6ff5a07529e4667203b4602d44e7424cf400b623)
- add package quality badge & change jsDelivr to rounded style [`fec8ae9`](https://github.com/fomantic/Fomantic-UI/commit/fec8ae94731b93535b6d38fcbdf9cdc65c0b427d)
- remove old template [`9f1cc00`](https://github.com/fomantic/Fomantic-UI/commit/9f1cc007ac4ed0ec7d03addf678fa1cc00710857)



## [2.6.4](https://github.com/fomantic/Fomantic-UI/compare/2.6.3...2.6.4)

> 15 November 2018

## Changes and new Features

### Calendar

- add `disabledDaysOfWeek` setting [`dd957bc`](https://github.com/fomantic/Fomantic-UI/commit/dd957bc5763eee3301697427195134e49b8c410c)
- add ability to disable specific date(s) [`3f7bc5d`](https://github.com/fomantic/Fomantic-UI/commit/3f7bc5d8aa7e604be3822e472fc6ab66bae0d727)
- add timegap setting to expand time selector [`2f05013`](https://github.com/fomantic/Fomantic-UI/commit/2f05013a12376fcd31e4cbc7197183ea2fcdf5b2)

### Dimmer

- add support for using dimmers only partially on top,center,bottom [`e85b8e5`](https://github.com/fomantic/Fomantic-UI/commit/e85b8e556b8bb38e4d70fd9b879dcf9a723bf26f)

### Item

- add inverted variant [`a52c665`](https://github.com/fomantic/Fomantic-UI/commit/a52c665425860fae10e4df45ad38f1df9f1e1dab)

### Popup

- add size modifiers to none javascript popup [`c284ecd`](https://github.com/fomantic/Fomantic-UI/commit/c284ecdc80dade7a3b95b4e8cf604d29ba7de5f8)

### Progress

- inverted colors text will black instead of white [`78dece2`](https://github.com/fomantic/Fomantic-UI/commit/78dece20e5a0ce7d6bd25ceffe8e6ff3b6a98949)

### Statistic

- add stackable variation [`dd04a90`](https://github.com/fomantic/Fomantic-UI/commit/dd04a90a6a64d70f97e66342ec74a8214098deed)



## Bug Fixes

### Dimmer

- make dimmer text more readable [`81e3934`](https://github.com/fomantic/Fomantic-UI/commit/81e3934a15e8929be3974579db86ed9cd6fef8a3)
- stop events when outside scope [`b9551d8`](https://github.com/fomantic/Fomantic-UI/commit/b9551d889f5a579e01c8679223fc0f3a03c917a4)

### Dropdown

- IE11 got focus on submenu selection again [`63bc9a8`](https://github.com/fomantic/Fomantic-UI/commit/63bc9a80cdf867675337bd39f1c75d27c301ebe2)
- fix for menu bubbling [`0620309`](https://github.com/fomantic/Fomantic-UI/commit/062030902c4eb3968e735063b2f933bbdcac107a)
- make sure to also clear filtered items when clearing [`6b39072`](https://github.com/fomantic/Fomantic-UI/commit/6b39072baa6dc805d5acc127ca8f23968ee3732a)
- prevent multiselection dropdown being pushed down [`de7134d`](https://github.com/fomantic/Fomantic-UI/commit/de7134dbf42011931b34d0a31fc68b658d179cf3)
- prevent user selection [`40374b8`](https://github.com/fomantic/Fomantic-UI/commit/40374b8914333084f60d57c937a4f3eb1cd5b27f)
- prevents close/open bubbling [`6ed8db1`](https://github.com/fomantic/Fomantic-UI/commit/6ed8db152e3ef678cfcb31a8cfb6d89722af0654)
- remove top margin from simple dropdown items to prevent submenu vanishing [`627e808`](https://github.com/fomantic/Fomantic-UI/commit/627e808a5cf3a841803c63bae05d5717d51b2c77)
- showOnFocus will not prevent dropdown opening [`22a25fa`](https://github.com/fomantic/Fomantic-UI/commit/22a25fa41b3a2ee216441954b06423bc91a4863c)

### Icon

- corner icon size in header icon [`f812030`](https://github.com/fomantic/Fomantic-UI/commit/f812030dc38675437d85c4dbec4179ded5b22feb)
- icon group alignment [`91ea667`](https://github.com/fomantic/Fomantic-UI/commit/91ea6678bad309753cf1b6aac72c4819bbfbd28a)

### List

- data-value on &lt;div&gt; list items is ignored [`6af1487`](https://github.com/fomantic/Fomantic-UI/commit/6af14871370b5ecbc6af3a29acad7b7b05353d19)
- icon and wrapped image were not inline and wrapped or wrongly aligned [`5b7ebae`](https://github.com/fomantic/Fomantic-UI/commit/5b7ebae9d999b453d70d31ac59a775c5dd9ed1d6)

### Menu

- dropdown inside menu should not reflect menu styling [`216f03f`](https://github.com/fomantic/Fomantic-UI/commit/216f03f42722e054be2491f67fc27cc0a86c0a3c)
- make the pointing tips in inverted menu reflecting menu background color [`ad2f57e`](https://github.com/fomantic/Fomantic-UI/commit/ad2f57e6ffdd3ccdb5a61c429938b10c7ad31e07)

### Modal

- basic modal and inverted modal on inverted dimmer had wrong close icon color [`c4c8037`](https://github.com/fomantic/Fomantic-UI/commit/c4c80374a7ec90e0cf05d7fdd26866f23030736f)
- image and content does not wrap [`83aa9e2`](https://github.com/fomantic/Fomantic-UI/commit/83aa9e2354612210004cc798fa3ded93711bd82d)

### Popup

- correct module.supports.svg method [`7828b2f`](https://github.com/fomantic/Fomantic-UI/commit/7828b2f7596e3eb63f4e03db4f4b8762e2197a99)






## [2.6.3](https://github.com/fomantic/Fomantic-UI/compare/2.6.2...2.6.3)

> 18 October 2018

## Changes and new Features

### Calendar

- add ability to set `minDate` and `maxDate` with HTML attributes [`a6a3323`](https://github.com/fomantic/Fomantic-UI/commit/a6a332308d08be5264e24aae1b4c3ed47274bdc8)
- add disabled state [`ab3532d`](https://github.com/fomantic/Fomantic-UI/commit/ab3532d55fc81fece1e11286f78cd5526c858d79)

### Toast

- add color variants [`36228f0`](https://github.com/fomantic/Fomantic-UI/commit/36228f0c1b8f830909bd0ed3bbf7ec4af09958d9)


### Misc Changes

- - Display error background for transparent input & textarea [`e0f54ea`](https://github.com/fomantic/Fomantic-UI/commit/e0f54eaeb6af8ca7fc33821e2c960748ba3b86fb)
- Always render parent 'text-box', support 'top attached progress', show icon only, if class exists [`ccf7ad0`](https://github.com/fomantic/Fomantic-UI/commit/ccf7ad077c0cd1fd5e178acec49ac7b04b940eaf)
- Make opacity an option (default 1), removed flat class [`00eb26a`](https://github.com/fomantic/Fomantic-UI/commit/00eb26a96a612ae36b2571f44065b8cb09cfd06f)
- Support hoverfloating for message aswell [`6a22d11`](https://github.com/fomantic/Fomantic-UI/commit/6a22d11c462c99c190b8df69abdcf0501d2c46bf)
- Support inverted transparent textarea [`31ed000`](https://github.com/fomantic/Fomantic-UI/commit/31ed0007b7133967b7ef2ad2d52cc8328acf4299)
- Support string for showIcon to use individual icons [`c4c35c6`](https://github.com/fomantic/Fomantic-UI/commit/c4c35c6e385ed418b96c68fa2dd131bbc638dcc2)
- Toast progressbar, closeEasing, Bugfixing, message support [`0653860`](https://github.com/fomantic/Fomantic-UI/commit/0653860976be03bbb8ebebf8a44c6846b6357174)
- animate scale instead of width [`dc2c5c8`](https://github.com/fomantic/Fomantic-UI/commit/dc2c5c829656c4ec31339cf4a056bba067975c65)
- better approach without using !important, thanks @ColinFrick [`05655ef`](https://github.com/fomantic/Fomantic-UI/commit/05655ef9f0311d64a166ffff44432733cf09d35b)
- finally simplified now... [`09140ba`](https://github.com/fomantic/Fomantic-UI/commit/09140ba939c1a7585e42c185dccbe535dfee00dd)
- force display:none, fixes SUI [`#6608`](https://github.com/fomantic/Fomantic-UI/issues/6608) where placeholder was overriding display:none [`1566bfb`](https://github.com/fomantic/Fomantic-UI/commit/1566bfb784daa8a4f299344b9353cd9fd6df1b85)
- less variables instead of fixed values [`ae61e96`](https://github.com/fomantic/Fomantic-UI/commit/ae61e96ed7f444d86dcbd271cde6d9751914fff8)
- moved declaration to proper position in less file [`6cce552`](https://github.com/fomantic/Fomantic-UI/commit/6cce552efe645631731fb5380723479fe798108d)
- moved to proper places. Increased specificity of medium and light to still work with "simple" [`e8d6058`](https://github.com/fomantic/Fomantic-UI/commit/e8d605882aa9d160223474b88e5d59223718c392)
- removed unnecessary whitespace [`74872b7`](https://github.com/fomantic/Fomantic-UI/commit/74872b72f04bfb1910dbcc506ec40ce9185c3f96)
- simplified again to existing transparent definition [`7f8fff2`](https://github.com/fomantic/Fomantic-UI/commit/7f8fff2f60cea0b674561e61dc6ca1c939550bbc)
- support true/false/'top'/'bottom' for showProgress parameter. No need to set the proper className for progress anymore [`f7bc317`](https://github.com/fomantic/Fomantic-UI/commit/f7bc317213bab165736f99a38e6ae581052f8f03)


## Bug Fixes

### Button

- support less 2.7 [`cc624fd`](https://github.com/fomantic/Fomantic-UI/commit/cc624fd0076f1e41867ce45c4d040f700cd7348c)

### Icon

- fix corner position when using some icons in group [`aeed770`](https://github.com/fomantic/Fomantic-UI/commit/aeed7705a78cb7e5757954255547229f7219db22)






## [2.6.2](https://github.com/fomantic/Fomantic-UI/compare/2.6.1...2.6.2)

> 2 October 2018


### Misc Changes

- Revert "Merge branch 'acc-upgrade-gulp4' of github.com:acconrad/Semantic-UI into beta" [`8ddac35`](https://github.com/fomantic/Fomantic-UI/commit/8ddac35878503f7c0e8e8c311ce47307fa86834b)







## [2.6.1](https://github.com/fomantic/Fomantic-UI/compare/2.6.0...2.6.1)

> 2 October 2018

## Changes and new Features

### Button

- move consequence variations to mixin [`be22acd`](https://github.com/fomantic/Fomantic-UI/commit/be22acd8725af95ed36178adb19e2d3454cafdf4)

### Dropdown

- Fix icon position over searchentry, stay focussed on keyboard entries [`7d0276f`](https://github.com/fomantic/Fomantic-UI/commit/7d0276f5de3270b13781e73c570dae17e088714e)


### Misc Changes

- Missing src file [`4ea71e5`](https://github.com/fomantic/Fomantic-UI/commit/4ea71e5ce7e48cd8a2c8891795dae00e5acef5a4)
- changing Composer package's name to Fomantic UI [`919ffd3`](https://github.com/fomantic/Fomantic-UI/commit/919ffd35dd7d42b505449e5235102bc96f697609)
- chaning Bower's package name [`7f50759`](https://github.com/fomantic/Fomantic-UI/commit/7f507591481f0a2f26540e0759c0cd52d523983b)


## Bug Fixes

### Modal

- increase importance of legacy modal class definition (scrolling) [`c4eed66`](https://github.com/fomantic/Fomantic-UI/commit/c4eed662b0f1df038e8f1042f7ec4931db08f8c1)






## [2.6.0](https://github.com/fomantic/Fomantic-UI/compare/2.5.0...2.6.0)

> 21 September 2018

## Changes and new Features

### Menu

- Fix the inconsistent icon-text spacing in labeled icon menu dropdown [`47406ec`](https://github.com/fomantic/Fomantic-UI/commit/47406ecdc8852dab2d34cf3615c71d220f6cc3ad)

### Toast

- :tada: Initial commit [`4229acb`](https://github.com/fomantic/Fomantic-UI/commit/4229acb5657e8234ef4b4459905bff244eef17b4)


### Misc Changes

- Disable clearable by default [`e468419`](https://github.com/fomantic/Fomantic-UI/commit/e468419074f8c7f21ae9b2aa1c90494b22149d4a)
- Finish adding legacy settings [`fa55d1f`](https://github.com/fomantic/Fomantic-UI/commit/fa55d1f1081bc499dec9ceba39da8a5c931c6949)
- Finish adding useFlex setting for dimmer/modal [`e609212`](https://github.com/fomantic/Fomantic-UI/commit/e60921288810a60870f0676b9e65e8e4e06d9576)
- Finish content loader [`d382de6`](https://github.com/fomantic/Fomantic-UI/commit/d382de69fc34f0e805a38551b8d65eff0b447b22)
- Finish content loader images [`a036608`](https://github.com/fomantic/Fomantic-UI/commit/a0366085fc4910eb304af6155dfefc2bf4200fc3)
- Finish refactor of modal to support legacy positioning for IE11 [`bbad430`](https://github.com/fomantic/Fomantic-UI/commit/bbad43026d0d0c6f52a62d2d1260039f4657b397)
- Force auto width/height for content loaders [`bd47451`](https://github.com/fomantic/Fomantic-UI/commit/bd47451f254ec84f3c89f18f21357a36c0d72c5b)
- Make content loaders support image aspect ratios [`9a3079b`](https://github.com/fomantic/Fomantic-UI/commit/9a3079ba58ea54534160cabfc7b6227a77e2665e)
- Make values relative [`2882706`](https://github.com/fomantic/Fomantic-UI/commit/288270661431f4abda0280acc7f3480d84d0e6a2)
- Move content loader to new component, placeholder. Modify placeholder segment to be 'empty segment' [`e83855c`](https://github.com/fomantic/Fomantic-UI/commit/e83855cdd351b752c988b5e608471ac6ae1882e7)
- Pressing the ESC key won't close all open modals anymore [`41180a7`](https://github.com/fomantic/Fomantic-UI/commit/41180a760436b2fa93f12b702f8250690298ddd3)
- Re-subset dropdown to include close [`35c583f`](https://github.com/fomantic/Fomantic-UI/commit/35c583f10ba8c82ddddfb998af3a5c7daebb37fa)
- Remove comment [`0c61a7e`](https://github.com/fomantic/Fomantic-UI/commit/0c61a7e72c61751a97bc694f47e1f920e386329b)
- Remove dupe in theme.config [`e95f0fb`](https://github.com/fomantic/Fomantic-UI/commit/e95f0fb16641fad5b37dc832f3fc14506762ec9a)
- Rename components to placeholder [`eedb182`](https://github.com/fomantic/Fomantic-UI/commit/eedb1829132395a73b2a2c561cd03b121249ccad)
- Respect useFlex settinng if its a boolean [`cddcc36`](https://github.com/fomantic/Fomantic-UI/commit/cddcc364c35c4d66f5e8e7a299562b68af1ea803)
- Rlsnote editing [`bf7e06f`](https://github.com/fomantic/Fomantic-UI/commit/bf7e06f2d838dd8c1b36bd53bf8053f3b21df491)
- Set dimmer variation at run-time [`b4861d1`](https://github.com/fomantic/Fomantic-UI/commit/b4861d1e492d9b1f7cba61cb7a16575a6ab8adb5)
- Simplest implementation of clearable dropdown [`33d08ec`](https://github.com/fomantic/Fomantic-UI/commit/33d08ec920c95b0ef9ee84bc31fbdb304916c212)
- Slightly modify inline dropdown icon right margin [`824fc8e`](https://github.com/fomantic/Fomantic-UI/commit/824fc8ed1a4d88523d90d91c007f083e117fc27c)
- Small fixes [`5f64787`](https://github.com/fomantic/Fomantic-UI/commit/5f64787ce4875b517cce764d771f1c713b6acf55)
- Spacing on theme config [`e0c03dd`](https://github.com/fomantic/Fomantic-UI/commit/e0c03ddbf54d6e9c65e2319d1d96528910562e45)
- Support optional Weeknumbers in Calendar Day View [`b44e647`](https://github.com/fomantic/Fomantic-UI/commit/b44e647422f7df14ef5d58746eeeb676da9ed868)
- Thanks [`#6531`](https://github.com/fomantic/Fomantic-UI/issues/6531)  [`14dc917`](https://github.com/fomantic/Fomantic-UI/commit/14dc9179c15b390fcd3644d0a6d68341565c0191)
- Tick version [`564d28b`](https://github.com/fomantic/Fomantic-UI/commit/564d28bb16e508b5bf3876fabf381964cfa1b7d4)
- Work on content loader [`0a560d8`](https://github.com/fomantic/Fomantic-UI/commit/0a560d8285a3256243c7c02b8336700b15bc9c97)
- Working on legacy setting for modals [`9707e40`](https://github.com/fomantic/Fomantic-UI/commit/9707e40448212aa24ed74a58b838c14dceca4120)
- [`#6218`](https://github.com/fomantic/Fomantic-UI/issues/6218) - Allow popup to use settings.closable without onclick [`06f2213`](https://github.com/fomantic/Fomantic-UI/commit/06f2213d4cff0e3d4396f31892a0b98b0b62e165)
- [`#6218`](https://github.com/fomantic/Fomantic-UI/issues/6218) - Reuse closable pattern from dimmer [`588ef9b`](https://github.com/fomantic/Fomantic-UI/commit/588ef9b4cf0614c7caf4879003073f58473eb602)
- [`#6363`](https://github.com/fomantic/Fomantic-UI/issues/6363) Fixes IE11 placeholder color [`b81abbd`](https://github.com/fomantic/Fomantic-UI/commit/b81abbdf01f2a72718683c3c5f18d281bde2763e)
- [`#6449`](https://github.com/fomantic/Fomantic-UI/issues/6449) #6495 - Adapt fix for dimmer scroll. Move to modal from dimmer. Blocking scroll requires determining content height which only modal can do [`d6ebab1`](https://github.com/fomantic/Fomantic-UI/commit/d6ebab1e6c171cd8870d903c7761ed4cc9b525f1)
- [`#6520`](https://github.com/fomantic/Fomantic-UI/issues/6520) - remove blurring on dimmer hide. Remove console logs. [`8a1ad49`](https://github.com/fomantic/Fomantic-UI/commit/8a1ad49be101a99987f4818eb4d37f967ccfac11)
- [`#6531`](https://github.com/fomantic/Fomantic-UI/issues/6531) - Add UK alias for united kingdom [`1626dc1`](https://github.com/fomantic/Fomantic-UI/commit/1626dc1a0808e72661ec863382ef9fffa8e8f645)
- hex case for disk [`#6556`](https://github.com/fomantic/Fomantic-UI/issues/6556)  [`4326ad8`](https://github.com/fomantic/Fomantic-UI/commit/4326ad8a060008207acfce1af0af4a507dd58157)


## Bug Fixes


### Misc Fixes

- Fix Multimonth display. table does not need/support to have semantic amount of column names to be specified [`3f98521`](https://github.com/fomantic/Fomantic-UI/commit/3f9852142e61ef1f051ce1411c12d74803dda4e8)
- Fix Week calculation display (needs to start with monday at least), moved calculation inside of get methods [`74f5d47`](https://github.com/fomantic/Fomantic-UI/commit/74f5d47e25bfa448908e78116ae4991ae5ca8f87)
- Fix alias for disk outline icon [`#6556`](https://github.com/fomantic/Fomantic-UI/issues/6556)  [`39a4348`](https://github.com/fomantic/Fomantic-UI/commit/39a4348d541ec6060d07bc72ae58a03c7d5999db)
- Fix component order [`e7e1c68`](https://github.com/fomantic/Fomantic-UI/commit/e7e1c6815aa1a7acfae31c9c7306b0efd006e674)
- Fix dropdown opening leftward inside menu [`56366b9`](https://github.com/fomantic/Fomantic-UI/commit/56366b96d31af4253eb8c4bfc37b6f2b376cec65)
- Fix for UI image in placeholder segment [`0e80d09`](https://github.com/fomantic/Fomantic-UI/commit/0e80d097d78d1799bad42bb4914ce49c924faba6)
- Fix interval on animation for placeholder [`b308c28`](https://github.com/fomantic/Fomantic-UI/commit/b308c282b741cf4053519b10f70a67ffce79a874)
- Fix legacy modals to support top aligned, fix bug in ie11 for swapping between top/middle aligned [`e35ce81`](https://github.com/fomantic/Fomantic-UI/commit/e35ce81e2777b37712982c4297866ef35ffb9a3c)
- Fix list issue where table-cell on content would cause content to collapse inappropriately [`6f2e1a8`](https://github.com/fomantic/Fomantic-UI/commit/6f2e1a85a07c198d13866dd1135677aa64583d07)



## Docs

- Fixed some typos [`c18f98a`](https://github.com/fomantic/Fomantic-UI/commit/c18f98a5ccfec1d0501597cdcee9a29efac6a9a4)
- remove trello link [`c2f61d7`](https://github.com/fomantic/Fomantic-UI/commit/c2f61d7ff397454bb5b2fc3eb5745b69b3f4a0f3)



## [2.5.0](https://github.com/fomantic/Fomantic-UI/compare/2.4.4...2.5.0)

> 3 September 2018

## Changes and new Features

### Card

- add horizontal variation [`60f10d5`](https://github.com/fomantic/Fomantic-UI/commit/60f10d5aa990e5eaeddfe18875aad41b0d89fa63)

### Icon

- add new icons [`2aaf0db`](https://github.com/fomantic/Fomantic-UI/commit/2aaf0db9207aeece5f32c46aef9bead91fc33e93)

### Menu

- Add center modifier for menu [`272827f`](https://github.com/fomantic/Fomantic-UI/commit/272827fb3cff8e84116048f3f3888a011a3a8816)

### Search

- add ability to disable link action [`5260a86`](https://github.com/fomantic/Fomantic-UI/commit/5260a86a909844283a7b4c048bc1d220bc3c0032)

### Tab

- Allow centered tab menu [`583989d`](https://github.com/fomantic/Fomantic-UI/commit/583989ddf6ca37dc824108ab4ac58ca2e05579a9)


### Misc Changes

- Created faq [`42137d0`](https://github.com/fomantic/Fomantic-UI/commit/42137d064f85618cf7e27a285d2afdd9b96cbc95)
- Implements inverted mode for standalone checkboxes [`1c80396`](https://github.com/fomantic/Fomantic-UI/commit/1c80396dd2f705e1963930e56aa92afee3472091)
- Initial calendar implementation [`d183143`](https://github.com/fomantic/Fomantic-UI/commit/d183143c994bfc0589851dceddc989078859e5f8)
- Remove weird colored css rules (seem to be useless) [`07d119b`](https://github.com/fomantic/Fomantic-UI/commit/07d119b7c546be40a53f146727924ae8ae05422a)
- Tweaking some mouse events [`4d1c0dd`](https://github.com/fomantic/Fomantic-UI/commit/4d1c0dd142d443c1ee7e31624854f41aec274513)


## Bug Fixes

### Card

- add border radius to left side [`e277095`](https://github.com/fomantic/Fomantic-UI/commit/e2770950ad7038a14ba5e1dfa315622169a82c79)

### Checkbox

- Set checked style class correctly on initial load [`85df5f6`](https://github.com/fomantic/Fomantic-UI/commit/85df5f6a448927ee4bd36c1d0bd06e611fc714a6)

### Label

- incorrect ribbon background on some labels [`a1aa3ba`](https://github.com/fomantic/Fomantic-UI/commit/a1aa3baecde436f1f8b77a60a3ddcffa704d9a84)

### Search

- set value inside onSelect callback [`d24d070`](https://github.com/fomantic/Fomantic-UI/commit/d24d070a07a032b86bf1c9bec05a05d81d362c3b)




## Docs

- made release dates consistent [`c1a1371`](https://github.com/fomantic/Fomantic-UI/commit/c1a13712107bc839a3952f281c7294676930d04e)
- update release notes [`92f0c3e`](https://github.com/fomantic/Fomantic-UI/commit/92f0c3ee06dd8304b8dd00f452b185d255a0930f)
- updated release notes [`4ff83d9`](https://github.com/fomantic/Fomantic-UI/commit/4ff83d947061b5feb847f3cb209271c64bcc7c47)
- updated release notes [`b9c559a`](https://github.com/fomantic/Fomantic-UI/commit/b9c559a9c318b52e3c5bc04f0476a1d92e88fab4)

## New contributors

- added profile links to contributors [`9973de0`](https://github.com/fomantic/Fomantic-UI/commit/9973de04a05eb254c7df381bdca66aaee3a65c6e)



## [2.4.4](https://github.com/fomantic/Fomantic-UI/compare/2.4.3...2.4.4)

> 26 July 2018

## Changes and new Features


### Misc Changes

- Bumped version [`661f24e`](https://github.com/fomantic/Fomantic-UI/commit/661f24eb96835bcb79e36861e49aa5685f436ad7)


## Bug Fixes


### Misc Fixes

- Fix icons position in a menu item when there's a group icon [`6ff8452`](https://github.com/fomantic/Fomantic-UI/commit/6ff84525fd673dd69c8469c2cafa406ed06d2937)
- Fix incorrect attached top header top margin [`aa2591f`](https://github.com/fomantic/Fomantic-UI/commit/aa2591f44edf5ff9a30aaeac5f84cff5c8a4f50d)
- Fix right margin inside button when there's an icon group [`342d7f9`](https://github.com/fomantic/Fomantic-UI/commit/342d7f9aef4dd4c19c957730c9ec5497adcec3dc)
- Fix the bad text margin when selected item text is very long [`c1407c3`](https://github.com/fomantic/Fomantic-UI/commit/c1407c3f74f95983449a0707fbc0c1f9e324b0af)





## [2.4.3](https://github.com/fomantic/Fomantic-UI/compare/2.4.2...2.4.3)

> 9 July 2018

## Changes and new Features


### Misc Changes

- Bumped version [`aaa7e44`](https://github.com/fomantic/Fomantic-UI/commit/aaa7e44aa4d487067c6e3bb7fbe3b8474294c89d)
- Move deprecated icons before normal rules to prevent improper inheritance [`403a377`](https://github.com/fomantic/Fomantic-UI/commit/403a37799030c246db46aa45302f0c915c17b610)
- Sign in/out alternate are actually duplicates [`363f283`](https://github.com/fomantic/Fomantic-UI/commit/363f283915619170366e41ad6dad70e1fce5fee2)
- [`#6428`](https://github.com/fomantic/Fomantic-UI/issues/6428) Deprecate several icons using in and out class [`ef77e8d`](https://github.com/fomantic/Fomantic-UI/commit/ef77e8dafa5065fbcdbe9f02898695a2e8ff5274)


## Bug Fixes


### Misc Fixes

- Fix api settings to pull cache from cache settings by default [`b45aafd`](https://github.com/fomantic/Fomantic-UI/commit/b45aafd441793361eafcc4e5a0461b54a56722b6)





## [2.4.2](https://github.com/fomantic/Fomantic-UI/compare/2.4.1...2.4.2)

> 4 July 2018

## Changes and new Features

### Icon

- Add halfway rotated and both flipped/rotated icon variations [`edfee96`](https://github.com/fomantic/Fomantic-UI/commit/edfee96cf04d620d1c9409955359ee1258883eae)


### Misc Changes

- Bumped version [`ddec4ca`](https://github.com/fomantic/Fomantic-UI/commit/ddec4ca81556e8f69b6a4b6089a54094bef1210f)
- Clean dropdown mutation code [`eae5001`](https://github.com/fomantic/Fomantic-UI/commit/eae5001ea2a65adb076749019334d2965e487f1c)
- Revert "Fix searchable dropdown that doesn't get focus on show" [`b460ba9`](https://github.com/fomantic/Fomantic-UI/commit/b460ba9e7bebc86be9762f8d8ac4ad67827f745a)


## Bug Fixes

### Label

- Replace :ActiveHover with :hover [`1d8d82d`](https://github.com/fomantic/Fomantic-UI/commit/1d8d82dc72e54f5fc6561dcfc1fe4de55de3306f)

### Modal

- Set position of modal element to relative [`446ea69`](https://github.com/fomantic/Fomantic-UI/commit/446ea69070a528667172ebae571e596f02b5c961)
- Split click event listener into mousedown / up [`fecb698`](https://github.com/fomantic/Fomantic-UI/commit/fecb698f81961315c8785d8162d9d4322fcc45b3)


### Misc Fixes

- Fix searchable dropdown that doesn't get focus on show [`d948892`](https://github.com/fomantic/Fomantic-UI/commit/d948892b9751729ed97f60525b3aa739ac57dd40)





## [2.4.1](https://github.com/fomantic/Fomantic-UI/compare/2.4.0...2.4.1)

> 20 June 2018

## Changes and new Features


### Misc Changes

- Bumped version [`8f87c09`](https://github.com/fomantic/Fomantic-UI/commit/8f87c09296447e4af3ba12dafe19f9f01ee1c452)
- Only select dividers if hideDividers option is true [`9b4e30f`](https://github.com/fomantic/Fomantic-UI/commit/9b4e30fb0bd08616a9b548f085b7bbfcc09d61a9)
- Update divider selector [`9b598cb`](https://github.com/fomantic/Fomantic-UI/commit/9b598cb1df24aa617a0c20cf40affc71e5787118)


## Bug Fixes

### List

- Typo in selection list item:hover selector [`80730e0`](https://github.com/fomantic/Fomantic-UI/commit/80730e0647032b4636b947b1ee3d701180e52abc)






#### 2.4.0

> 19 June 2018

## Changes and new Features

### Card

- Icon containing class "card" misbehaves [`49f9118`](https://github.com/fomantic/Fomantic-UI/commit/49f9118bb9cf7857ec34d94dc64e990a3d9d7a7f)

### Dropdown

- A fluid dropdown should be fluid [`7eb1b05`](https://github.com/fomantic/Fomantic-UI/commit/7eb1b058519566fb2d7bbc5948ab84a2c2af80bc)
- Add new hideDivider option [`5112bdd`](https://github.com/fomantic/Fomantic-UI/commit/5112bddb92571c3620e9892745644181f7c4694d)
- Extend sortSelect with 'natural' and custom function [`a1aff81`](https://github.com/fomantic/Fomantic-UI/commit/a1aff812a78788bd0be3b3d06859c236ba3614ab)
- [`#2403`](https://github.com/fomantic/Fomantic-UI/issues/2403) [Dropdown] Merge and organize metadata refresh [`913194c`](https://github.com/fomantic/Fomantic-UI/commit/913194ca6b53c89f94b2ceae387b871de88af135)
- feat(dropdown) add exact search - [`#3085`](https://github.com/fomantic/Fomantic-UI/issues/3085)  [`3e6a37f`](https://github.com/fomantic/Fomantic-UI/commit/3e6a37ffd7033e681fd0b9a0be61e8b7d6551193)

### Flag

- Adding Scotland and Walles [`a912dd6`](https://github.com/fomantic/Fomantic-UI/commit/a912dd615075c6173deee70149c72b60687d3ace)

### Form

- Add * required marker from the label itself [`8836c39`](https://github.com/fomantic/Fomantic-UI/commit/8836c39b88710434f2e8786a91619bf3298f2399)

### Form Validation

- Add an option that disallow trim before validation [`e6fcadd`](https://github.com/fomantic/Fomantic-UI/commit/e6fcadd0934385c35c90911b3dd5cbc874406bef)
- Avoid trim of values before validation [`0666053`](https://github.com/fomantic/Fomantic-UI/commit/0666053eb7f63d720d0b9fd5661e5238296413b5)

### Menu

- Fixes z-index to be just below modals for fixed menu [`#505`](https://github.com/fomantic/Fomantic-UI/issues/505)  [`0016012`](https://github.com/fomantic/Fomantic-UI/commit/0016012d30dad10bf76c4d4ce11657bba9ff9961)
- adds fixed menu coupling with grid [`#479`](https://github.com/fomantic/Fomantic-UI/issues/479)  [`656474f`](https://github.com/fomantic/Fomantic-UI/commit/656474fbe63cc8b65ef82bb2e3e068b66e5d9b91)
- removes vendor prefixed properties [`9f78a2d`](https://github.com/fomantic/Fomantic-UI/commit/9f78a2da2f3a3302d34e78ff227d7edaf4892a76)
- tiered menu bug [`e40bc14`](https://github.com/fomantic/Fomantic-UI/commit/e40bc14acdeecbdae848b938e0c1f79e954e9999)

### Modal

- Fixes IE detection, IE11 now reports navigator.appName as Netscape and not Microsoft Internet Explorer LOL [`00a9209`](https://github.com/fomantic/Fomantic-UI/commit/00a92094383dca9ceefd05cd2373c35afd789dae)
- adds support for multiple visible modals [`#491`](https://github.com/fomantic/Fomantic-UI/issues/491)  [`4b6b2da`](https://github.com/fomantic/Fomantic-UI/commit/4b6b2dad3a4c7eec51a1488cbd82c35f5030dbe8)
- fixes dimmer and modal to use two separate checks for active status [`1ea95cb`](https://github.com/fomantic/Fomantic-UI/commit/1ea95cbab2c336271ff8daa968123c9be5332f46)
- fixes modal content not taking full width when less than a line of content [`3743099`](https://github.com/fomantic/Fomantic-UI/commit/37430996c3e1da27c9d8c7563bfdfe93bafc1db4)
- makes dimmer appear before modal, for extra sexyness [`0cd0b67`](https://github.com/fomantic/Fomantic-UI/commit/0cd0b67d04cfcf876e603687f0c2e005aaa8d59a)

### Search

- add exactResults on duplicate check [`8842983`](https://github.com/fomantic/Fomantic-UI/commit/884298381e0bb46d5641a2facbfa4508606d8822)

### Segment

- A basic segment within .segments should be basic [`05d60e4`](https://github.com/fomantic/Fomantic-UI/commit/05d60e4efd1f60ced3731adf7459f7dcd074c11f)

### Table

- Fix priority for td .disabled class [`31959e8`](https://github.com/fomantic/Fomantic-UI/commit/31959e86b1f93628d9a2e23f391c6112662e1332)

### Transition

- prevents same animation from occurring twice by default [`4dcfe8a`](https://github.com/fomantic/Fomantic-UI/commit/4dcfe8aa40b703666c90e52bf12bac2f3acb1131)

### Visibility

- add ability to cancel callbacks, add new checkOnRefresh option [`cbdb60f`](https://github.com/fomantic/Fomantic-UI/commit/cbdb60ff5f73255eaca0a48b74c4619632fe1fef)


### Misc Changes

- #2143. Using title in injected styles causes issues... for some reason? [`3d92ed9`](https://github.com/fomantic/Fomantic-UI/commit/3d92ed9c20c9f56b027757ce3740cddcf14bd877)
- #3514: the fix for issue: 'The checking for semantic.json always fails when npm dependent package uses Semantic UI'. [`0800482`](https://github.com/fomantic/Fomantic-UI/commit/0800482ec9899193ea4415bdbac2509336707b2b)
- #3703- Fixes issue with dropdowns/buttons on the left side of a ui input when using 'action input [`4879fe4`](https://github.com/fomantic/Fomantic-UI/commit/4879fe482b12212de46848fb9f1e022090681c01)
- #3873- Fixes typo in green inverted button [`4426f5c`](https://github.com/fomantic/Fomantic-UI/commit/4426f5c861850c29b14f3a5c38ebf1754928125f)
- 'Merge branch 'master' of github.com:Semantic-Org/Semantic-UI into next [`9d5a31d`](https://github.com/fomantic/Fomantic-UI/commit/9d5a31df38934bc1c4a4e3af5c12c123eec7b191)
- (X) wide buttons no longer need to specify 'fluid' [`87da37b`](https://github.com/fomantic/Fomantic-UI/commit/87da37b1416016dca1d58e4d6fb6d127f90b8e2b)
- * Added metadata docs task to scrape *.html.eco files in docs repo for [`1acf816`](https://github.com/fomantic/Fomantic-UI/commit/1acf81622ba6aaf01280991fa2cab6f2f81102c0)
- 100% working component update script with no .git index lock issues [`139117d`](https://github.com/fomantic/Fomantic-UI/commit/139117d5d37792d79fce444ab205927b5fb3ea17)
- 3311 - Modifies several aliases [`27dc1c7`](https://github.com/fomantic/Fomantic-UI/commit/27dc1c79aa5e063ca345613aa998ba7faa2b65c0)
- 5122 allow dashed cc values [`31b28a1`](https://github.com/fomantic/Fomantic-UI/commit/31b28a1950364a56b8c08e4e715743cc288bbc48)
- 902e63b Merge branch 'master' of github.com:quirkyinc/semantic [`f7ae6ae`](https://github.com/fomantic/Fomantic-UI/commit/f7ae6ae7a0d3734916ddedd72d8b98a750fbb5cb)
- A lot of indecisive work on homepage [`b0dbdfe`](https://github.com/fomantic/Fomantic-UI/commit/b0dbdfe5a25ae6d40b2777011a259b5f0a13b563)
- ADds [`#3131`](https://github.com/fomantic/Fomantic-UI/issues/3131)  [`8369a58`](https://github.com/fomantic/Fomantic-UI/commit/8369a5820969bf17b4a2d10e191dcd85f04ae9f3)
- API Styles moved over from broken git repo [`9a0ba72`](https://github.com/fomantic/Fomantic-UI/commit/9a0ba7275061013b73b010f94b242314e24468ca)
- API no longer produces 'no action specified' error when defaulting to form action [`5f9a1ab`](https://github.com/fomantic/Fomantic-UI/commit/5f9a1ab7152b97acf35157ef43a370440b550889)
- API now adds real AJAXsettings to debug [`6ee12b2`](https://github.com/fomantic/Fomantic-UI/commit/6ee12b22605db059755aa14a7cdcfc1ed009d911)
- API now passes response to error handler when successTest fails [`a977c33`](https://github.com/fomantic/Fomantic-UI/commit/a977c331ea7c03947e807a7cfb1288c5d58fbbca)
- Ability to disable dropdown without destroy it. [`ed251dd`](https://github.com/fomantic/Fomantic-UI/commit/ed251dd226e86c9e9e35a64d9a3137048dc7c00f)
- Abstraction abstraction abstraction [`#1634`](https://github.com/fomantic/Fomantic-UI/issues/1634)  [`f8fa373`](https://github.com/fomantic/Fomantic-UI/commit/f8fa3734822e54442aa07d99c768b8fb46799cce)
- Accidental checkin of incomplete line [`4a8ecbf`](https://github.com/fomantic/Fomantic-UI/commit/4a8ecbf3135bf89409b0c02d1fba6c6ff673f0ea)
- Accidental merge conflict commit [`bf21ab9`](https://github.com/fomantic/Fomantic-UI/commit/bf21ab95e44651ab07ac945667248f3c5fb48010)
- Accordion can now close while opening [`cf28f60`](https://github.com/fomantic/Fomantic-UI/commit/cf28f602c30e091ef4f6108ffcc588a0dd0b9f38)
- Accordion docs had extra closing tag, adds progress docs for warning, updates details of development docs [`ea2adf9`](https://github.com/fomantic/Fomantic-UI/commit/ea2adf9e78a43d38356301520cb2925adf1aecbc)
- Actually fix the language modal not to show twice [`798fbe0`](https://github.com/fomantic/Fomantic-UI/commit/798fbe0e67b00803c4ad61ab0ebc48b1a4c4a7d4)
- Ad test advertisement [`77ab04e`](https://github.com/fomantic/Fomantic-UI/commit/77ab04e05100fa5cf970c28119de067a1b71a878)
- Adjust appearance of labeled icon menu [`c0f3c4f`](https://github.com/fomantic/Fomantic-UI/commit/c0f3c4ff01d8163c14a345d02de37f44011ef40a)
- Adjust arrow variables to automatically resize [`c6e78ae`](https://github.com/fomantic/Fomantic-UI/commit/c6e78ae909a12713235d6bb15b857281de1fca3d)
- Adjust breadcrumb divider spacing [`19b2ea9`](https://github.com/fomantic/Fomantic-UI/commit/19b2ea9e741bfc156dfc9fba610e3001597d93cc)
- Adjust cache type to be called local to allow for standard caching choices [`421fdad`](https://github.com/fomantic/Fomantic-UI/commit/421fdadd7634be4b25d0ee536d0aa2fe8d93eb64)
- Adjust card default theme, move github theme to classic, makes more sense [`f3f1ab8`](https://github.com/fomantic/Fomantic-UI/commit/f3f1ab82d052a56303a82fbea04dba9bafe855f5)
- Adjust default alphas to improve legibility [`042995d`](https://github.com/fomantic/Fomantic-UI/commit/042995d4e0ddf8d160c84828667a63618edfda3a)
- Adjust default colors [`4ca5a2f`](https://github.com/fomantic/Fomantic-UI/commit/4ca5a2ff85c5d7159bbca1a5e5253069d48985f0)
- Adjust default menu styles [`75973bb`](https://github.com/fomantic/Fomantic-UI/commit/75973bbdfd717d87a1bd55d12f216c13f8bcc4d7)
- Adjust default padded segment value [`e82c35d`](https://github.com/fomantic/Fomantic-UI/commit/e82c35da3c57877fb444247a965f846825829dcb)
- Adjust divider margin [`77232d6`](https://github.com/fomantic/Fomantic-UI/commit/77232d6a1c52f5a2079ec8757d43d096124d8932)
- Adjust dropdown vars [`5541e43`](https://github.com/fomantic/Fomantic-UI/commit/5541e439de9b1a89112c5267e4e5b58d94b931cf)
- Adjust example formatting [`f2547b1`](https://github.com/fomantic/Fomantic-UI/commit/f2547b1733f0c6564b6422a40bcb2df5f0a76aea)
- Adjust floating box shadow on dropdown menu [`06ad93e`](https://github.com/fomantic/Fomantic-UI/commit/06ad93e5eb636e44e8ee13b29d382c9a98744705)
- Adjust fonts in site.variables [`faf0192`](https://github.com/fomantic/Fomantic-UI/commit/faf0192241db8cb00874f5e2e13c458e987eb857)
- Adjust global disabled opacity [`caea209`](https://github.com/fomantic/Fomantic-UI/commit/caea209ed33cc0c4359423cde8f86c3e890ef042)
- Adjust icon header formatting, more visible icon, better alignment with text. Recalculate max icon width size [`e41820c`](https://github.com/fomantic/Fomantic-UI/commit/e41820c623cb2e8bd0d4fd1c108e0376aec9bb69)
- Adjust info colors slightly [`8d04937`](https://github.com/fomantic/Fomantic-UI/commit/8d049370c6a6788189d23f84b8df1d0d51d1b481)
- Adjust info/posi/negi again [`7aa9875`](https://github.com/fomantic/Fomantic-UI/commit/7aa9875cd9abc72bfea8e02cdaf0165e42777806)
- Adjust inline label align [`9d5d104`](https://github.com/fomantic/Fomantic-UI/commit/9d5d104f12adabca962829ecf96a37e64fcc8dd2)
- Adjust input flexbox [`2362bf4`](https://github.com/fomantic/Fomantic-UI/commit/2362bf47af8f8a516fd086b596ec2ead2965a76b)
- Adjust inverted menu styles [`8244f9b`](https://github.com/fomantic/Fomantic-UI/commit/8244f9b24bbf5967fe7764bdb668a60f6e9b27ee)
- Adjust inverted text color opacity [`8aa2338`](https://github.com/fomantic/Fomantic-UI/commit/8aa233821f9f9e2d4c139241f98bbd2c5e0a00fb)
- Adjust link color, menu border, dropdown item font-size [`ad674dd`](https://github.com/fomantic/Fomantic-UI/commit/ad674dd7a3d61130c7594f53e4ebd23c3a11e6a7)
- Adjust min width of progress bar [`c0f64a1`](https://github.com/fomantic/Fomantic-UI/commit/c0f64a12691d1eb90dc2b50f4c08efbe8e3c4f6b)
- Adjust modal scale in animation to be more subtle [`64f0be8`](https://github.com/fomantic/Fomantic-UI/commit/64f0be8ee74106fd608ffd56ac58aa10b277607c)
- Adjust ribbon label padding to be more spacious [`a05a388`](https://github.com/fomantic/Fomantic-UI/commit/a05a38892b8839e5822f37f4e974ad727e74eb0e)
- Adjust scale in animation globally, fade up/down [`4ed930f`](https://github.com/fomantic/Fomantic-UI/commit/4ed930f91c36261accd78fc0550400176d946db9)
- Adjust selected border color and floating shadow [`9ea18b3`](https://github.com/fomantic/Fomantic-UI/commit/9ea18b3fed8dc8521968aa01ef3a827bc67a66cc)
- Adjust selection padding [`2b54b0e`](https://github.com/fomantic/Fomantic-UI/commit/2b54b0ec1b0e096555e58913a310f1a73fe79b5e)
- Adjust small computer page grid gutter [`5823e92`](https://github.com/fomantic/Fomantic-UI/commit/5823e926cc9f7d3daf3c82e49a38c5f27ab837fb)
- Adjust some card variables [`e5186d5`](https://github.com/fomantic/Fomantic-UI/commit/e5186d553b5f9b95350b57f90ae89d71a4535fca)
- Adjust some underlying variables to have more comprehensible names [`a88ec27`](https://github.com/fomantic/Fomantic-UI/commit/a88ec27503b84621691e8134c583aa0f9907cc41)
- Adjust step example [`c28353a`](https://github.com/fomantic/Fomantic-UI/commit/c28353a53b8af20d44ea5f2891ba0c312fe34c8a)
- Adjust step variables, fix pointers [`b3749aa`](https://github.com/fomantic/Fomantic-UI/commit/b3749aa823fb7ffa57656ff799f21ec13078a13c)
- Adjust stripe color [`7ea65c0`](https://github.com/fomantic/Fomantic-UI/commit/7ea65c018db9d32fd7c5b13c0e03403deed6cacc)
- Adjust subtle colors [`5c310a8`](https://github.com/fomantic/Fomantic-UI/commit/5c310a85aee056d24163362ad2d7705bdff3d331)
- Adjust table header padding [`aa82e50`](https://github.com/fomantic/Fomantic-UI/commit/aa82e5040e7cfe1d06394e9f08d26985e1756998)
- Adjust text container paragraph settings [`6670978`](https://github.com/fomantic/Fomantic-UI/commit/66709782e55aad19df9b185fa1df81867d0c15f9)
- Adjusting message colors [`c1f43c1`](https://github.com/fomantic/Fomantic-UI/commit/c1f43c18b6338c1ecb2e7761f55a5262e1f2e2f2)
- Adjusting themes to match with changes in 2.0 [`7f4b39f`](https://github.com/fomantic/Fomantic-UI/commit/7f4b39f4ebc8eaef7ad01eb304314cb4d2e6e161)
- Adjustments to docs for kitchen sink [`1083493`](https://github.com/fomantic/Fomantic-UI/commit/1083493015253bb2e232da45328d268a09fe37b7)
- Adjusts breadcrumb spacing [`8f021e6`](https://github.com/fomantic/Fomantic-UI/commit/8f021e6a0b7e140b3dd5606b01c6acb5ed9b8f8b)
- Adjusts default button colors [`26446d1`](https://github.com/fomantic/Fomantic-UI/commit/26446d16b2ecf325beb179183e7e32c6795a93bd)
- Adjusts message colors [`658792e`](https://github.com/fomantic/Fomantic-UI/commit/658792edd05d2380d988931a897a90aec012e41a)
- Adjusts progress theme colors [`c59c017`](https://github.com/fomantic/Fomantic-UI/commit/c59c0176a6115bf91a259de22c2173c4b901ab47)
- Admin task iteration [`268b30a`](https://github.com/fomantic/Fomantic-UI/commit/268b30a017c6f72846627964079a63f39c3ef564)
- Admin tasks no longer pipe gulp stream (buggy), use mergeStream instead [`f7d69cd`](https://github.com/fomantic/Fomantic-UI/commit/f7d69cd283800432035093a75eff6a3b7274ed76)
- All icons are 1px too tall, uses same technique as bootstrap (offset1px on glyphicons) [`1817d93`](https://github.com/fomantic/Fomantic-UI/commit/1817d936388f0b9d15d2205202be0e61fb8805cd)
- All inputs now use flexbox, adjust flex-grow value to fix ie10 [`7a5654d`](https://github.com/fomantic/Fomantic-UI/commit/7a5654d9682f0f0836e547d986207efd3f4e995a)
- All paths are now resolved from semantic.json location [`bf8b8f0`](https://github.com/fomantic/Fomantic-UI/commit/bf8b8f0a0384074b2107a4b3d40463c0fa7d860b)
- All tests  for modal/dimmer should now be passing again [`c535a77`](https://github.com/fomantic/Fomantic-UI/commit/c535a77dcb5476278e885dbfa2422f17f4df9e4b)
- Allow `onHide` callbacks for dropdown prevent hiding [`4dfeaab`](https://github.com/fomantic/Fomantic-UI/commit/4dfeaabe9b63772dd72ec1a9d8058dcc07c8c0e2)
- Allow final display state to be specified in transition settings, fixes for search sizes [`779c8cf`](https://github.com/fomantic/Fomantic-UI/commit/779c8cfc19c5f45a47d3d5f7e0a842f29a54adf0)
- Allow first letter selection without selection dropdown [`989c8d5`](https://github.com/fomantic/Fomantic-UI/commit/989c8d582a6de3885873473584cb0f90c6c67e4e)
- Allow statistic label to be either on top or bottom [`4dea9ff`](https://github.com/fomantic/Fomantic-UI/commit/4dea9ffaa3fecb3413b52dee502f466cce7c0b98)
- Allow text labeled dropdowns to continue to search after max selections [`3b952c3`](https://github.com/fomantic/Fomantic-UI/commit/3b952c34d2a7cc0d77c42cfc094f0912c30c7b8b)
- Allows modules to work in environment with global other than window [`#3855`](https://github.com/fomantic/Fomantic-UI/issues/3855)  [`4292ab5`](https://github.com/fomantic/Fomantic-UI/commit/4292ab5aa1411ae016f879c469322cc72629eb08)
- Alphabetize and comment out validation rules [`#1396`](https://github.com/fomantic/Fomantic-UI/issues/1396)  [`0de927c`](https://github.com/fomantic/Fomantic-UI/commit/0de927c029d79a115f7c975c3bc92fbf1c7bf063)
- Alphabetize input rules, add time type [`#1721`](https://github.com/fomantic/Fomantic-UI/issues/1721)  [`4ef796f`](https://github.com/fomantic/Fomantic-UI/commit/4ef796f6dcddc9ccc2958cb9270b283ec8a59d86)
- Alternate fix for [`#1587`](https://github.com/fomantic/Fomantic-UI/issues/1587) Attached tabular menu [`26ac8fd`](https://github.com/fomantic/Fomantic-UI/commit/26ac8fda32cc2bc207dbf6b614d9d07db1e410f6)
- And derp [`#2072`](https://github.com/fomantic/Fomantic-UI/issues/2072)  [`784b440`](https://github.com/fomantic/Fomantic-UI/commit/784b4401b886f211c2d99b796159c7cc3548fd6c)
- Another install msg attempt [`11ee2c5`](https://github.com/fomantic/Fomantic-UI/commit/11ee2c5050b59b23ea4273430660f7d8d535bbe5)
- Arrows now use translateX/Y instead of @arrowOffset. Adds better arrow bg colors for pointing menu [`#1653`](https://github.com/fomantic/Fomantic-UI/issues/1653)  [`8de80fb`](https://github.com/fomantic/Fomantic-UI/commit/8de80fbc0e650f9dcd5477686c4694e08093f325)
- Attached msg back and forth [`8281c0c`](https://github.com/fomantic/Fomantic-UI/commit/8281c0c39108f04539a768740c8be16685e935c9)
- Attempt at README [`bdeca02`](https://github.com/fomantic/Fomantic-UI/commit/bdeca02aaed904ce54ea45b63f760a8ea6128d0f)
- Attempting to fix install message [`7e21869`](https://github.com/fomantic/Fomantic-UI/commit/7e218698920307453a5fd3f572a28bc766cc9d5b)
- Attempting to fix min-size issues with selection dropdown [`cd2a39a`](https://github.com/fomantic/Fomantic-UI/commit/cd2a39ac7ad42a55879981a3ec7dca6acafa9e2c)
- Attempting to fix overflow issues with sidebar [`cdb0bc6`](https://github.com/fomantic/Fomantic-UI/commit/cdb0bc644b4cc0f15b3720d06623d4b010f7ef05)
- Attempting to fix some performance issues with sidebar [`0451463`](https://github.com/fomantic/Fomantic-UI/commit/0451463a84913b31d6dc4d7a7879c99027b07b42)
- Attempting to move basic icon set to separate theme instead of subclassed [`743c721`](https://github.com/fomantic/Fomantic-UI/commit/743c7212e7d726288b9a6aac6385d6be6407b5d5)
- Avatar spacing fix [`c6a8864`](https://github.com/fomantic/Fomantic-UI/commit/c6a8864cec159e6a37f946ee1c72d295a8494029)
- Backport LESS repo fix [`561fa8c`](https://github.com/fomantic/Fomantic-UI/commit/561fa8c841be9bfaae9256b0748235cfed32ac9e)
- Backport fix in form validation [`291a2cd`](https://github.com/fomantic/Fomantic-UI/commit/291a2cd305e8abd9e2a33a1a01b9d507a66fee0c)
- Backport fix to message from 0.x.x [`874f4cf`](https://github.com/fomantic/Fomantic-UI/commit/874f4cfe840e6d8129c438f030134ea6cbb58acd)
- Backport flex fix for cards [`#2069`](https://github.com/fomantic/Fomantic-UI/issues/2069) #2021 #2105 [`05a7a32`](https://github.com/fomantic/Fomantic-UI/commit/05a7a320f2c364fb58c5cef923c6d81728fce563)
- Backports dropdown fixes [`776b654`](https://github.com/fomantic/Fomantic-UI/commit/776b6542d69e5f4e204ac5ecd3875a2fa780fcb7)
- Backports fix for dropdown headers in menus [`#2022`](https://github.com/fomantic/Fomantic-UI/issues/2022)  [`4e3fe4b`](https://github.com/fomantic/Fomantic-UI/commit/4e3fe4bf378b9e6e2469be87f84a1c6a1266e28d)
- Backports input definition to 1 [`61be84c`](https://github.com/fomantic/Fomantic-UI/commit/61be84ce02fa5ed3fe5cbbf80a072449a7c149b4)
- Basic colored button now grow their border size [`38949ab`](https://github.com/fomantic/Fomantic-UI/commit/38949ab2c16e1f862a0e595a142d0a4944a7535e)
- Begin API docs [`d677eef`](https://github.com/fomantic/Fomantic-UI/commit/d677eef3f53d583963a2c582b8280a29c51e96a0)
- Begin copy writing for contributions [`9a9c4b9`](https://github.com/fomantic/Fomantic-UI/commit/9a9c4b9d0d53e02ebd8a33e97c25e264e6cfabaf)
- Begin examples [`d8c300d`](https://github.com/fomantic/Fomantic-UI/commit/d8c300de3712d05abe091bb384a95a46f1cd6fce)
- Begin progress bar theming [`1833bc4`](https://github.com/fomantic/Fomantic-UI/commit/1833bc445797ec6f9d07022c002d4f7d9260a58b)
- Begin rewrite of icon overrides [`020b9b4`](https://github.com/fomantic/Fomantic-UI/commit/020b9b4c06ca113e87d7e2c4245a196d4b26a00e)
- Begin rewrite of popup calcs to cache correctly on each position check [`794d082`](https://github.com/fomantic/Fomantic-UI/commit/794d08221810860b58a39ce58e3f899caecaf4d3)
- Begin themeing of messages [`a83fe9f`](https://github.com/fomantic/Fomantic-UI/commit/a83fe9f9003a6565d58fe69b1e5005ee3ab0a9b4)
- Begin theming items [`55f51c0`](https://github.com/fomantic/Fomantic-UI/commit/55f51c06eb69804319ac9d953b0e0aeb1bc52e5e)
- Begin theming, updates to ui table [`4d3cebd`](https://github.com/fomantic/Fomantic-UI/commit/4d3cebd38e7d03525452abe7297b986aa5cc1b3c)
- Begin work at converting hard coded em values [`ba7d428`](https://github.com/fomantic/Fomantic-UI/commit/ba7d4288a42614e388accef402c55577137d7106)
- Begin work on customizer [`b7d243c`](https://github.com/fomantic/Fomantic-UI/commit/b7d243c1af49e47f38b8704ad11778f337264c31)
- Begin work on global variable list and starting to replace variables in button.less [`911ca00`](https://github.com/fomantic/Fomantic-UI/commit/911ca00dce11bc0dd557131dd1d216f7e467ba41)
- Begin work on wizard, which means writing out variations/states as YAML [`1924b69`](https://github.com/fomantic/Fomantic-UI/commit/1924b69e2ffd19d2f6f4890c40b3ec3dd9b8e204)
- Begin write of additional transitions, and example builder [`af02229`](https://github.com/fomantic/Fomantic-UI/commit/af022293ab42ff0ea36ae982c0f78cdafdf782c9)
- Begin writing of css and style guide [`81349d7`](https://github.com/fomantic/Fomantic-UI/commit/81349d711a68e1d47b1f02dbaf1107b758cbe890)
- Beginnig to redo demo content in docs [`4372569`](https://github.com/fomantic/Fomantic-UI/commit/43725695b326b02482684727d4849aa466379534)
- Beginning comment view, fixes to message colors [`912960c`](https://github.com/fomantic/Fomantic-UI/commit/912960c5c3adbac45943452a3e5f7e9992beac3c)
- Beginning multiselect rewrite [`a1d77ec`](https://github.com/fomantic/Fomantic-UI/commit/a1d77ec37400cfe2383b00cd7a25ce17b8dcaafc)
- Beginning progress bar variables [`2a6c613`](https://github.com/fomantic/Fomantic-UI/commit/2a6c61330a9b214e0a891046e01f2cbe7a7d2d06)
- Beginning refactoring of admin tasks [`068df99`](https://github.com/fomantic/Fomantic-UI/commit/068df994a2e0734898ec260f3a86a27b7e346883)
- Beginning to redo button with new variables [`57dd4e7`](https://github.com/fomantic/Fomantic-UI/commit/57dd4e77f8f1fbe14880508bfe2109ac1ab5eea4)
- Beginning to write alternative themes to menus [`640355c`](https://github.com/fomantic/Fomantic-UI/commit/640355c61039f74de8ef83088717e8948f990466)
- Begins work on allowAdditions, adds error messages, and ui message coupling [`3a9821c`](https://github.com/fomantic/Fomantic-UI/commit/3a9821ca46a2fb2fa53700b522863195f9bcea68)
- Better errors for attach events [`625ea52`](https://github.com/fomantic/Fomantic-UI/commit/625ea527eec9032ae1825bebeb743e8cd8fb51e6)
- Better fix for search input blur bug [`09f8ff0`](https://github.com/fomantic/Fomantic-UI/commit/09f8ff00548d2e7fafd3b9a050e9e4a73f157ce6)
- Better implementation of [`#6016`](https://github.com/fomantic/Fomantic-UI/issues/6016) passing value to callback [`e137ee1`](https://github.com/fomantic/Fomantic-UI/commit/e137ee1bfd5b89ac699efd9a1d56f9e27c16d93d)
- Bg pattern on body animate [`88ed78f`](https://github.com/fomantic/Fomantic-UI/commit/88ed78f4932dfc3d5ef86d87b141dac4d4a822c3)
- Big Change: Replace all derived em values with @px values. [`2f20aca`](https://github.com/fomantic/Fomantic-UI/commit/2f20acad7a7e69797d95c5df274d723638954d85)
- Big upgrades to checkbox, attach events, read-only, disabled, dom mutations [`2448b1f`](https://github.com/fomantic/Fomantic-UI/commit/2448b1f45a571a307d406f4196f94902101b17e6)
- Blind coding of css animation module [`2004e65`](https://github.com/fomantic/Fomantic-UI/commit/2004e65cebcbe9258e1bee20457ae164726ff7d1)
- Break it [`c70ed31`](https://github.com/fomantic/Fomantic-UI/commit/c70ed3139678dd485fec0306ea7ab73c886b98b0)
- Break out close events into separate methods [`775df0e`](https://github.com/fomantic/Fomantic-UI/commit/775df0e06179e5330a684379eb8b604718e41ed5)
- Bug fixes for grid, popup, adds visibility module [`6bc576e`](https://github.com/fomantic/Fomantic-UI/commit/6bc576e4311966c52bd45ba24602bee83a6b4520)
- Bug fixes for transition [`28c81f5`](https://github.com/fomantic/Fomantic-UI/commit/28c81f5801f85e416740ef8d911a3b3d9d7036ef)
- Bugs with remote [`6a95f19`](https://github.com/fomantic/Fomantic-UI/commit/6a95f1920beef05f28c52356956ae9a271908867)
- Bulleted horizontal list color variable [`91d1e7a`](https://github.com/fomantic/Fomantic-UI/commit/91d1e7a454f9e487bba4566e2a6018e071201466)
- Bumped version [`c18f4d0`](https://github.com/fomantic/Fomantic-UI/commit/c18f4d0499c2f6360564d1d7a274c6befcc5be76)
- Bunch of new doc writing [`c6c5040`](https://github.com/fomantic/Fomantic-UI/commit/c6c5040315f85d93866cf6ea6b09ce08f521795e)
- Button fixes icon height instead of using 0.9em icon height [`7464684`](https://github.com/fomantic/Fomantic-UI/commit/74646843d2d21103d395efe67e5d7416fb28bc0b)
- Button now inherits all sizes [`9675f9a`](https://github.com/fomantic/Fomantic-UI/commit/9675f9ab11f784245b73dbcbd1b0dfbffa62a693)
- Button now uses focus shadow from site.variables [`8d48a25`](https://github.com/fomantic/Fomantic-UI/commit/8d48a259457ed18dc24fdbd47a12d6596fcc130b)
- CSS indenting [`#3714`](https://github.com/fomantic/Fomantic-UI/issues/3714)  [`7ab6597`](https://github.com/fomantic/Fomantic-UI/commit/7ab65977e1577719270edad1a328c9ff9334a06f)
- Call order, params [`6a23d51`](https://github.com/fomantic/Fomantic-UI/commit/6a23d515070ac7916df1dd45db27f9459349ad2a)
- Calling show without animation now sets display type [`ecc3c8a`](https://github.com/fomantic/Fomantic-UI/commit/ecc3c8a3e04610c919510120f6465d958e9263ef)
- Card styles adjusted to be remove solid border shadow [`f5f8d0d`](https://github.com/fomantic/Fomantic-UI/commit/f5f8d0dbe12fe265384d7f469d7f6e5a4f126589)
- Cards can now have multiple content blocks, images not on top [`8147a77`](https://github.com/fomantic/Fomantic-UI/commit/8147a77e28f0daea908e962e0754038446f52a20)
- Category search no longer warns about maxResults [`#1850`](https://github.com/fomantic/Fomantic-UI/issues/1850)  [`0dec900`](https://github.com/fomantic/Fomantic-UI/commit/0dec90028ad6473165874dfddeabb2b33f52bc02)
- Change default sidebar settings for docs [`4106715`](https://github.com/fomantic/Fomantic-UI/commit/4106715fdea6a71aa627047b53947fd05d7e733f)
- Change default star rating to use unfilled stars instead of empty stars [`4d9cad3`](https://github.com/fomantic/Fomantic-UI/commit/4d9cad397e918d24a63cddb628c6820c1ec6c71a)
- Change lineheight to round corrrectly [`5f96357`](https://github.com/fomantic/Fomantic-UI/commit/5f963574954e68c54a6e17a0f1e09508f050ab84)
- Changed @solidFontName to @fontName [`75db2ed`](https://github.com/fomantic/Fomantic-UI/commit/75db2edc75abbccf02eec4f511e03a7767bb6bad)
- Changed i.icon font-family to @fontName instead of @solidFontName [`82226e6`](https://github.com/fomantic/Fomantic-UI/commit/82226e6ee175d0ad617ee31c496c20dd846b6a2a)
- Changes from yesterday [`0983ee0`](https://github.com/fomantic/Fomantic-UI/commit/0983ee03b4b5012e901cc972e9ad81113f0f36bf)
- Changes grids to allow padding for rowless columns, adds doubling variation [`3e5852e`](https://github.com/fomantic/Fomantic-UI/commit/3e5852e5be1a6065073d3c9881640913bf4ca573)
- Changes to docs [`f79c658`](https://github.com/fomantic/Fomantic-UI/commit/f79c658422860173d4149d504bc281a0993aac79)
- Changes to homepage mockup [`ea2313d`](https://github.com/fomantic/Fomantic-UI/commit/ea2313db44dc88ffa97ebb7e220792fd054c67e7)
- Checkbox does not need to blur input on check [`#2254`](https://github.com/fomantic/Fomantic-UI/issues/2254)  [`3d01c07`](https://github.com/fomantic/Fomantic-UI/commit/3d01c076f7af041d7391ea54f8c8e6b1aab685f1)
- Checkbox- Fixes issue where radio checkbox would uncheck itself mistakenly when unchecking other radios [`#2506`](https://github.com/fomantic/Fomantic-UI/issues/2506)  [`7d64b86`](https://github.com/fomantic/Fomantic-UI/commit/7d64b86c6cd66bb5e9a297f270d674b69624cbd7)
- Cherry pick [`#2816`](https://github.com/fomantic/Fomantic-UI/issues/2816) for patch [`b340a56`](https://github.com/fomantic/Fomantic-UI/commit/b340a5659cc69776de4194ca6d5329c5a2981ea6)
- Cherry pick locked down package.json [`201f724`](https://github.com/fomantic/Fomantic-UI/commit/201f724db439d239ef8fa741848540aabe212204)
- Chubby form theme [`fce4255`](https://github.com/fomantic/Fomantic-UI/commit/fce42557b814ad876e6a2efbd49157fd2e3cd61f)
- Circular images now have overflow [`a84ed02`](https://github.com/fomantic/Fomantic-UI/commit/a84ed020452b267a261e200a9a2ddef421fbdb5d)
- Clean checkbox code [`c63a348`](https://github.com/fomantic/Fomantic-UI/commit/c63a348b4eb74aa076e45e6168a8dd3ffadb1484)
- Clean up logic in onComplete for cogency  [`#2713`](https://github.com/fomantic/Fomantic-UI/issues/2713)  [`66c89ad`](https://github.com/fomantic/Fomantic-UI/commit/66c89add39b8b0a2db6a44fed5fb7211f9f9d614)
- Clean up spacing [`#1627`](https://github.com/fomantic/Fomantic-UI/issues/1627)  [`00b9b9d`](https://github.com/fomantic/Fomantic-UI/commit/00b9b9d4a370d80a4fe36779221306807f9b2b03)
- Cleans up SVG logic [`#3774`](https://github.com/fomantic/Fomantic-UI/issues/3774)  [`ccfb0cd`](https://github.com/fomantic/Fomantic-UI/commit/ccfb0cda1053beeb0c7a7d08ed405a15cd8926bd)
- Cleans up gruntfile a little [`f5ed5c3`](https://github.com/fomantic/Fomantic-UI/commit/f5ed5c3471a3cb3599bfa2663b2aab49684119d7)
- Cleanup code [`578b630`](https://github.com/fomantic/Fomantic-UI/commit/578b630cbaa4ace30ac1a2e170ac3dda3edd4294)
- Clears up logic around corner labeled input [`#2361`](https://github.com/fomantic/Fomantic-UI/issues/2361)  [`27bf60b`](https://github.com/fomantic/Fomantic-UI/commit/27bf60be160528911e7e0f4c6328b7748b0efdd7)
- Code formatting [`5889b94`](https://github.com/fomantic/Fomantic-UI/commit/5889b94b60faae05cedbd1022c65fc6b13b942d0)
- Code samples should now automatically resize when browser resizes, code samples now generate on first mousemove so as to avoid changes in html markup from interacting with examples [`74fe4a2`](https://github.com/fomantic/Fomantic-UI/commit/74fe4a28d7963f79f11a69237d3ed76d7095aaf3)
- Collapsing some grouped button rules, fixes inline-flex white space issues with grouped basic button [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280)  [`b0991d5`](https://github.com/fomantic/Fomantic-UI/commit/b0991d52c7be419ccc40b5d18ea0afd68cab53f7)
- Combine divider rules [`967a03b`](https://github.com/fomantic/Fomantic-UI/commit/967a03b99b4b8af0322acf6ad0fe1f3c2d314768)
- Combine rules [`#2955`](https://github.com/fomantic/Fomantic-UI/issues/2955)  [`a514d0a`](https://github.com/fomantic/Fomantic-UI/commit/a514d0ae0f76242b920940933678a45db126d49b)
- Comment [`cdce7f7`](https://github.com/fomantic/Fomantic-UI/commit/cdce7f72b1d332cb8b3404748ddee726255aefa4)
- Comment out language modal for friday night, too much trouble [`738d105`](https://github.com/fomantic/Fomantic-UI/commit/738d1050af9bb9d5923141ae0db72731d0919251)
- Comment unused sticky menu item [`5a0a2e0`](https://github.com/fomantic/Fomantic-UI/commit/5a0a2e04168ffbad9a0c7999b3a2b0954f973ff5)
- Commenting [`2de6a35`](https://github.com/fomantic/Fomantic-UI/commit/2de6a35b58e89d80985384ccd2906524dccae6d2)
- Comments in API js [`6bc7758`](https://github.com/fomantic/Fomantic-UI/commit/6bc77583e942b50aef1593ae8c7ca5fe2999e781)
- Commits dfa2e02 to 1.x, backports fix for column colors [`#2272`](https://github.com/fomantic/Fomantic-UI/issues/2272)  [`eee2c96`](https://github.com/fomantic/Fomantic-UI/commit/eee2c968c676ea7947aea6c71078385852886a8b)
- Committing visit behavior [`278752b`](https://github.com/fomantic/Fomantic-UI/commit/278752b13e4a8d427823b36eb0a7fc1e6a865560)
- Complete card theme, add basic view [`1c042e6`](https://github.com/fomantic/Fomantic-UI/commit/1c042e6f6fdd0094c61d4af876e811dd79c7ff1f)
- Complete docs tasks [`a9b9b07`](https://github.com/fomantic/Fomantic-UI/commit/a9b9b07514144491f36560f27cc78eaec05dcc5f)
- Complete first iteration of site module [`1095937`](https://github.com/fomantic/Fomantic-UI/commit/1095937280780a51109c9bd5651bde4b5802b1b9)
- Complete first pass of API integration with dropdown [`071d101`](https://github.com/fomantic/Fomantic-UI/commit/071d1012152d98a2f4a7b0bc374736a1f12b4490)
- Complete initial complete rewrite of sidebar [`63d80d1`](https://github.com/fomantic/Fomantic-UI/commit/63d80d1de5bd4939f6acacf0c10e583e56e5ed3b)
- Complete integration of autocomplete on ui search dropdown [`#1508`](https://github.com/fomantic/Fomantic-UI/issues/1508)  [`218083b`](https://github.com/fomantic/Fomantic-UI/commit/218083b5a35861cbaf28e4c993d11ed158f2df48)
- Complete item theming and documentation [`1369498`](https://github.com/fomantic/Fomantic-UI/commit/1369498b6cf33ee5db6729ecbfe30973b163efd9)
- Complete restructure of checkbox for comprehensivenesss, adds indeterminate state, new callbacks, [`#2440`](https://github.com/fomantic/Fomantic-UI/issues/2440)  [`9b3665e`](https://github.com/fomantic/Fomantic-UI/commit/9b3665eb013d457a42e41843478ca4d855c23b03)
- Complete rewrite of dropdown to support searchable dropdown, optimizations, better scroll selection, easier to fix tab index [`f56d415`](https://github.com/fomantic/Fomantic-UI/commit/f56d41575ab01b20869c0cba0fb3890fa5260d39)
- Complete rewrite of transition module, adds requestanimationframe, more granular behavior control, and caching optimizations for display/animation lookup [`b80c3a5`](https://github.com/fomantic/Fomantic-UI/commit/b80c3a5231207ffd926541ca31ce8b705d9294bc)
- Complete statistics variables [`f49b602`](https://github.com/fomantic/Fomantic-UI/commit/f49b602a4f65fc608b918c7ebc6ee77d5376301a)
- Complete user actions in gulp [`877288c`](https://github.com/fomantic/Fomantic-UI/commit/877288c0c4edcaf7a608e107df28ab831a329b00)
- Complete visibility [`e1b6add`](https://github.com/fomantic/Fomantic-UI/commit/e1b6addb106ce6f2be7c050542e1adc28e9223bd)
- Completes theme/enhancement of comment view [`e037734`](https://github.com/fomantic/Fomantic-UI/commit/e03773481e8aa5e76cb32114a61ca2d565a4cf1b)
- Completes theming director and include setup [`61d07e9`](https://github.com/fomantic/Fomantic-UI/commit/61d07e91a1c61a6d07716424b778ca718c284393)
- Computer breakpoint is now 992 instead of 998 (match bootstrap) [`20ecf56`](https://github.com/fomantic/Fomantic-UI/commit/20ecf5648e3b8aa085c2a8cdd05d1943215a0683)
- Config now extends defaults instead of replacing [`c6e11b5`](https://github.com/fomantic/Fomantic-UI/commit/c6e11b5e8030c5491dbea700fa411fe6f4bdf99b)
- Consider inline-block header to fix link hitbox [`644f331`](https://github.com/fomantic/Fomantic-UI/commit/644f3311227c70cbfa769cb60e251fd6d65775a5)
- Consolidate UI input logic inside form [`705d289`](https://github.com/fomantic/Fomantic-UI/commit/705d289f1adde5542b35997f9486ca6a1f510e3e)
- Consolidate and finish work on segment groups [`6258196`](https://github.com/fomantic/Fomantic-UI/commit/6258196a97a485db5800c4000a8015c535d942b1)
- Consolidate block rules [`#1428`](https://github.com/fomantic/Fomantic-UI/issues/1428)  [`0e645b2`](https://github.com/fomantic/Fomantic-UI/commit/0e645b23d10b5ad688a12440399c78cadfc50c0b)
- Consolidate input browser line height across components, fix multi select to match input height in all cases [`7e7d8ed`](https://github.com/fomantic/Fomantic-UI/commit/7e7d8ed3cce30fa004d90fd8a261ae6df783c80e)
- Consolidate styling for UUID across modules [`9170fad`](https://github.com/fomantic/Fomantic-UI/commit/9170fad1bd6e1e91c3a78aa391fe8516a32e8aee)
- Consolidate templatedURL behavior into one method [`f0dfe16`](https://github.com/fomantic/Fomantic-UI/commit/f0dfe16337a2eb025d61a8b2c4f87e17435a0d1b)
- Consolidate when logic [`6b27f37`](https://github.com/fomantic/Fomantic-UI/commit/6b27f376e103ae2726eb43de7717cc63084db133)
- Container shouldnt overwrite display [`86da57c`](https://github.com/fomantic/Fomantic-UI/commit/86da57cf20771f8c573cf2be13395f102b7faf3d)
- Container widths are now based off min gutter width [`3cd1049`](https://github.com/fomantic/Fomantic-UI/commit/3cd104968df25849618f9a7b876c17a839f924d5)
- Continue to work on the puzzle that is grids [`8382e2e`](https://github.com/fomantic/Fomantic-UI/commit/8382e2e093e0055c72768456e21653e299874eb4)
- Continued work on sidebar fixes, menu some other stuff [`3434ac8`](https://github.com/fomantic/Fomantic-UI/commit/3434ac83dd1b723d82d76d23fb8a86a76fff6cf2)
- Continues adding missing variables from form variations [`7d7500e`](https://github.com/fomantic/Fomantic-UI/commit/7d7500e676a6a548818e27486551dd7f2785396f)
- Continuing to debug issues with other UI elements when used inside 3d contexts [`10b5798`](https://github.com/fomantic/Fomantic-UI/commit/10b5798bc315cd4db8f2706081a099aa50096a0e)
- Continuing to expand on examples for list/item/card [`76b8899`](https://github.com/fomantic/Fomantic-UI/commit/76b8899a46d5774de7f95a2efb620e59b6410856)
- Continuing to fix tertiary buttons [`4d1b784`](https://github.com/fomantic/Fomantic-UI/commit/4d1b7849393b9be3c94dbe64490f225d5fd62a31)
- Continuing to iterate on gulpfile for install process [`71d6563`](https://github.com/fomantic/Fomantic-UI/commit/71d656309b1de9d39a2d79fa85499be572f497ad)
- Continuing to iterate on sidebar [`44daa6c`](https://github.com/fomantic/Fomantic-UI/commit/44daa6ce83ef8ce0f43283d64d7bc08adeba67de)
- Continuing to iterate on theming [`3025f72`](https://github.com/fomantic/Fomantic-UI/commit/3025f72a1e244c0544bf1d28352db7694030b763)
- Continuing to tweak corner label positions, fixes flud input example [`2cc9f06`](https://github.com/fomantic/Fomantic-UI/commit/2cc9f0696b39e27d57de77cc60dffd2d3417234c)
- Continuing to write copy [`d1c77d7`](https://github.com/fomantic/Fomantic-UI/commit/d1c77d72a952ad7b22cdea13c7b12bd3f46a4c1d)
- Continuing work on list variables, fixes for icon header alignment with line height [`17e0cdb`](https://github.com/fomantic/Fomantic-UI/commit/17e0cdbbd14c778114a345a0509364522fb7b3c4)
- Convert backslashes to slashes for Windows compatibility [`e69bfaa`](https://github.com/fomantic/Fomantic-UI/commit/e69bfaa3530c0d004b83132c9276c1ce5c0271ef)
- Convert steps to flexbox [`3ef8c72`](https://github.com/fomantic/Fomantic-UI/commit/3ef8c728a1fe01f53b454d186de63a58d2fea55f)
- Corner label should be em not rem [`8970819`](https://github.com/fomantic/Fomantic-UI/commit/897081955dce27e4163b33f6299a3031c8a97fcd)
- Correct watched path for .variables and .overrides files [`369817a`](https://github.com/fomantic/Fomantic-UI/commit/369817aa72a07831978ffd91f229c20840d9c436)
- Corrected for missing &lt;i&gt; selector [`3554462`](https://github.com/fomantic/Fomantic-UI/commit/355446213969bf2f829fa9b9b042e1ceb1d633da)
- Corrected the previous commit [`2ec4b57`](https://github.com/fomantic/Fomantic-UI/commit/2ec4b573cfba14c27c1bb0bfdb2a1ab77c43cffb)
- Corrected wrench config for `src/site` merges [`f8472c8`](https://github.com/fomantic/Fomantic-UI/commit/f8472c87ddbd54251e093bb045a1cd2e7768099f)
- Correcting name: yes, Wales [`cc8c2b9`](https://github.com/fomantic/Fomantic-UI/commit/cc8c2b9c41a378b5134b5d702ad6e43ed27510fb)
- Correction for inverted circular icons [`5ea6c1c`](https://github.com/fomantic/Fomantic-UI/commit/5ea6c1cd275461a86594bcfe01df3b0dfeed24e6)
- Corrections for submenu show while animating hide [`#1288`](https://github.com/fomantic/Fomantic-UI/issues/1288)  adjustments to failsafe [`f16131b`](https://github.com/fomantic/Fomantic-UI/commit/f16131b85b6340b6dbf9bd2eb2892e27dfd064fa)
- Correctly adds [`#3179`](https://github.com/fomantic/Fomantic-UI/issues/3179)  [`4adad40`](https://github.com/fomantic/Fomantic-UI/commit/4adad40d8947840f1f575b3a3d9d5fe2d0f14541)
- Correctly calculate offset when popup is in a different positioning context [`5e9535e`](https://github.com/fomantic/Fomantic-UI/commit/5e9535e1f0a041a1fcd923685548c09d2a486253)
- Couple bugfixes for scroll, inline grouped label margin fix [`ca52ee4`](https://github.com/fomantic/Fomantic-UI/commit/ca52ee430b655e0513db17e1dc19694ab6719d50)
- Couple more vars in progress [`3d49a31`](https://github.com/fomantic/Fomantic-UI/commit/3d49a3140d1cce4ce761b3012831443ebd8f56a0)
- Couple unnecessary lines [`fc28d64`](https://github.com/fomantic/Fomantic-UI/commit/fc28d6457738490260d1ea15144f848daf21237c)
- Create global input variables and center all other valus around them [`12b27c1`](https://github.com/fomantic/Fomantic-UI/commit/12b27c1968e86a83c50efe45e07b8f2be4c54730)
- Create stale.yml [`8c8ed1f`](https://github.com/fomantic/Fomantic-UI/commit/8c8ed1f76c55cb9d4e27be0f4a642a9429b959b0)
- Created custom collections to hopefully avoid the performance issues you were facing [`8b780ea`](https://github.com/fomantic/Fomantic-UI/commit/8b780ea7f3120f410bfda0eda6a8b68cbd6a2577)
- Creates amazon button theme [`3e7eda6`](https://github.com/fomantic/Fomantic-UI/commit/3e7eda690f0c3c2f10e9647451c5e646d3d00ced)
- Creds [`#2158`](https://github.com/fomantic/Fomantic-UI/issues/2158)  [`7b75800`](https://github.com/fomantic/Fomantic-UI/commit/7b75800b329660d9ad744cc7ea729d2f2d5c1e77)
- Customization page revisions [`855551e`](https://github.com/fomantic/Fomantic-UI/commit/855551e3ea6657af012ba631f5dd2b24d2d4f00c)
- Cut out deps? [`48057d2`](https://github.com/fomantic/Fomantic-UI/commit/48057d20b1bf57ef2c74453e9c5e6f8027bce7a3)
- Darken progress bar [`7be4d85`](https://github.com/fomantic/Fomantic-UI/commit/7be4d85d3572f34462ddafe7799460ed9bf01fd7)
- Darken toggle checkbox text [`a6447b1`](https://github.com/fomantic/Fomantic-UI/commit/a6447b11501d24598bd0864202e48bdbf9d78f7b)
- Darkens dropdown active color to make it more visible [`d0fc837`](https://github.com/fomantic/Fomantic-UI/commit/d0fc83759ce0dad6eed3144ba72cc9e68ef57d8b)
- Darkens global blacks [`ad13b92`](https://github.com/fomantic/Fomantic-UI/commit/ad13b92d25750f1ca748cfb5065e4feda1e2a2b4)
- Darkens link hover color [`4a58afd`](https://github.com/fomantic/Fomantic-UI/commit/4a58afdd140034f25c70883c01e31bcf56d5edd0)
- Darkens placeholder text color [`6806492`](https://github.com/fomantic/Fomantic-UI/commit/6806492c9f38921ee4c10657e0d6d2259f30ca50)
- Data-validate takes precedence on matching [`d48a9f0`](https://github.com/fomantic/Fomantic-UI/commit/d48a9f01a0a628bb1e21da1695e8141b715330f7)
- Date [`22acbc2`](https://github.com/fomantic/Fomantic-UI/commit/22acbc26714637a5f0e1248c22aea16622f9822e)
- Deal with type casting in a consistent way [`c43ea73`](https://github.com/fomantic/Fomantic-UI/commit/c43ea73f7f0622441dc13cbee067ecbb1114c5b9)
- Debug [`bb8f9d3`](https://github.com/fomantic/Fomantic-UI/commit/bb8f9d3ed7eb74f41c0d8589f49a906904375b32)
- Debug for radio [`4fb0f38`](https://github.com/fomantic/Fomantic-UI/commit/4fb0f38734fe2b4d3a459d9fad2ffe3ca271b7f3)
- Debug package.json [`48bae26`](https://github.com/fomantic/Fomantic-UI/commit/48bae264b2049e9703e50078bfebb220be6fd578)
- Debugging installer [`ea36185`](https://github.com/fomantic/Fomantic-UI/commit/ea36185cd2eb8ffa6def90a1460a1198fd36177c)
- Debugging update path [`2f80495`](https://github.com/fomantic/Fomantic-UI/commit/2f8049558e1bc88a5e19760feb26dad27b86b31f)
- Decrease dropdown transition duration, remove tweens on box shadow [`e897a18`](https://github.com/fomantic/Fomantic-UI/commit/e897a183500e7ae519830d9c65be2c8e6156c8d4)
- Default theme folder can be configured [`dedec07`](https://github.com/fomantic/Fomantic-UI/commit/dedec07aaa135f7b4ab557d7eb8e77da9cb7ff3d)
- Default to uncover for sidebar [`b257c39`](https://github.com/fomantic/Fomantic-UI/commit/b257c39820528947fe4a1cb2a8462bf75ad14735)
- Definitively fixes weird circular issues with radio checkboxes, fixes label alignment [`52d93fd`](https://github.com/fomantic/Fomantic-UI/commit/52d93fdd15f27b45e0498328742bf9ded14212b8)
- Delete GETTING-STARTED.md [`db6c0f2`](https://github.com/fomantic/Fomantic-UI/commit/db6c0f249331bd3327f49668aa6fe80ebf2372d0)
- Delete theme.less [`f606373`](https://github.com/fomantic/Fomantic-UI/commit/f60637375694808225946328aa1d797f0d932391)
- Demo [`e44d6e8`](https://github.com/fomantic/Fomantic-UI/commit/e44d6e88f66f1d85b48f1bee21c6de75a46013a9)
- Dependencies [`48f6468`](https://github.com/fomantic/Fomantic-UI/commit/48f64685fd50c5fbe9bdaeb7f294b840bb0bbc9f)
- Deploying beta updates [`fdf47fe`](https://github.com/fomantic/Fomantic-UI/commit/fdf47fed12feca5faa07b327a7511b2de176b47b)
- Deprecating Slack [`0e4e687`](https://github.com/fomantic/Fomantic-UI/commit/0e4e687a99a87fade1f97dcc68a66f7e58a6bc50)
- Desperately trying to fix 1px offset based on line height valign [`#2440`](https://github.com/fomantic/Fomantic-UI/issues/2440)  [`d5ba1b8`](https://github.com/fomantic/Fomantic-UI/commit/d5ba1b8b522771ae37c73f1279c2890e9bd8dd9e)
- Details [`326e1df`](https://github.com/fomantic/Fomantic-UI/commit/326e1df31bd1de4cf4085faa194feb4fd836ea38)
- Dimmer now can be clicked even before element has finished animating in, [`#1363`](https://github.com/fomantic/Fomantic-UI/issues/1363)  [`75b4f57`](https://github.com/fomantic/Fomantic-UI/commit/75b4f578ae9666fa8e3fbe8a2c15bfe15dc55a19)
- Dimmer now correctly removes variations in 'destroy' [`5d90243`](https://github.com/fomantic/Fomantic-UI/commit/5d90243f0e826e0372ce8ef4bd49a19c3c2111fc)
- Disable debug in state [`#1825`](https://github.com/fomantic/Fomantic-UI/issues/1825)  [`4a03003`](https://github.com/fomantic/Fomantic-UI/commit/4a0300362702ce3e54cf0615818b2296dcaa91bb)
- Disable feature detection on sidebar init [`3ea416e`](https://github.com/fomantic/Fomantic-UI/commit/3ea416eae3c73db3041b1a0b140a1f59b5326e6f)
- Disable ios resize [`2ed6218`](https://github.com/fomantic/Fomantic-UI/commit/2ed6218097cc754ddd10b1e48fe2349aff4024bf)
- Disable modal debug: [`46f14ab`](https://github.com/fomantic/Fomantic-UI/commit/46f14ab0e0a022f8960fca50822d779ed16369d5)
- Disable observe changes by default [`0c5c5da`](https://github.com/fomantic/Fomantic-UI/commit/0c5c5daf1bc6e4ef6f29c1a1b2e7b0da358a40b4)
- Disable progress debug [`4176c58`](https://github.com/fomantic/Fomantic-UI/commit/4176c588e9862efb0407fdab804d7d4c7930e4a0)
- Disable refreshing for non active/animated modals [`7a17e70`](https://github.com/fomantic/Fomantic-UI/commit/7a17e70dd6c5c96294d204982c305d1e5eed63b8)
- Disable sticky debug [`93a6c3f`](https://github.com/fomantic/Fomantic-UI/commit/93a6c3fd453e0200cc9b74505c34cf1cab67da84)
- Disable transition debug [`eed25a6`](https://github.com/fomantic/Fomantic-UI/commit/eed25a6dcbc4ee34354defc482df56edf9d74a49)
- Disabled fields disable pointer events [`#555`](https://github.com/fomantic/Fomantic-UI/issues/555)  [`baaf91c`](https://github.com/fomantic/Fomantic-UI/commit/baaf91c85c79a6090747864225114c52d9dea9fd)
- Disabled icon have pointer events again [`f6ba97a`](https://github.com/fomantic/Fomantic-UI/commit/f6ba97a3382c3b615176ce72a4822306dc28d883)
- Disables transition debug by default, too chatty [`339b236`](https://github.com/fomantic/Fomantic-UI/commit/339b2369e26bb7523597663142e6679aa02e9ec3)
- Divider docs update [`2bddddd`](https://github.com/fomantic/Fomantic-UI/commit/2bddddd96441c8d4b360a0b6732b5fb5ec3d1cdc)
- Docs for hybrid style init [`afe0754`](https://github.com/fomantic/Fomantic-UI/commit/afe0754f4a87371aeb56923ff9d59b231e34bec6)
- Dont do anything with outline/brand inside definition (this is part of override). Use existing names to avoid backwards compatability issues [`#6226`](https://github.com/fomantic/Fomantic-UI/issues/6226)  [`cf70177`](https://github.com/fomantic/Fomantic-UI/commit/cf70177a378746b202df30745638865b32c90b39)
- Dont initialize menu on mobile/tablet, fixes for responsive [`1767d93`](https://github.com/fomantic/Fomantic-UI/commit/1767d93bc2b06370473d9c82031be0ce1f2ccfe8)
- Double vertical spacing on vertically divided grid, remove body &gt; grid fix [`8b716df`](https://github.com/fomantic/Fomantic-UI/commit/8b716df1ad11e88a92702fc50148b34335a08927)
- Drastically improve performance of scroll position on menu show [`363ad36`](https://github.com/fomantic/Fomantic-UI/commit/363ad3634a83a590d4fb93b497290e39c71a2b6e)
- Dropdown 'is disabled' did not return a value [`#2699`](https://github.com/fomantic/Fomantic-UI/issues/2699)  [`f9c3a63`](https://github.com/fomantic/Fomantic-UI/commit/f9c3a632cf46adac8936482ce1029a9b537b11a6)
- Dropdown can now have behaviors invoked on select [`96a577d`](https://github.com/fomantic/Fomantic-UI/commit/96a577d2c9809ca9ef4469c3d4a8f3da08848fdc)
- Dropdown can now hide other input types [`#1752`](https://github.com/fomantic/Fomantic-UI/issues/1752)  [`db7f0cb`](https://github.com/fomantic/Fomantic-UI/commit/db7f0cbe25795a0e6e20331ec6ff1ca534edb16e)
- Dropdown clear now removes selected value [`b86b5ce`](https://github.com/fomantic/Fomantic-UI/commit/b86b5ced8651b29060be941451ae93d3c4261a7b)
- Dropdown menu tpl disabled attribute fix [`6acfabf`](https://github.com/fomantic/Fomantic-UI/commit/6acfabf80fba3512c9b173b4adebd6eee94e9e17)
- Dropdown now uses a loading class to calculate scroll position for active element before showing [`f9d3e54`](https://github.com/fomantic/Fomantic-UI/commit/f9d3e54fc1150cc6a0e4ef05989ad059c3280c86)
- Dropdown settings comments [`eb65cc3`](https://github.com/fomantic/Fomantic-UI/commit/eb65cc39cbcb670e8518844dccb7e16fb3f158e7)
- Dropdown will now show when only messsage in menu. Fixed maxSelections from hiding dropdown after selection. [`#2523`](https://github.com/fomantic/Fomantic-UI/issues/2523)  [`ecccaf5`](https://github.com/fomantic/Fomantic-UI/commit/ecccaf50a3c88b803252f076af11f8f12b6a349f)
- Dropdowns now use internalBorderColor global [`c85f27f`](https://github.com/fomantic/Fomantic-UI/commit/c85f27fec63f72782808cf0cf696553a97db4b13)
- Dupe rule [`a5c69dd`](https://github.com/fomantic/Fomantic-UI/commit/a5c69ddc7049008ead8fd1256c0df186d73474f7)
- Duration now available in shape, rewrite of core animation [`d5f4a3a`](https://github.com/fomantic/Fomantic-UI/commit/d5f4a3a43d65cca2ae07373f624d57712019b821)
- Edge cases [`7851d3a`](https://github.com/fomantic/Fomantic-UI/commit/7851d3ae42d7f98618df7c40ba43e759b3beedac)
- Embed- fix icons to work with other icons than 'play' [`815d528`](https://github.com/fomantic/Fomantic-UI/commit/815d5284e1aeb9333a64c942f5c1f2e2703938e9)
- Enable error message for offstage position, adjust lastResort to also allow true instead of specified position [`9b2b159`](https://github.com/fomantic/Fomantic-UI/commit/9b2b1590ed4fc35f37b55c687a0410d4f69cd73d)
- Enables API debug by default [`41790b2`](https://github.com/fomantic/Fomantic-UI/commit/41790b2a1978fa557ac2f7c99dc6cb66c171b582)
- Enhances appearance of action ui input [`a930cd9`](https://github.com/fomantic/Fomantic-UI/commit/a930cd92f28217b47bc8563456e3cb045e2245bc)
- Enhances grid docs, fixes some consistency issues, adds grid fixed width variables [`0a59fdc`](https://github.com/fomantic/Fomantic-UI/commit/0a59fdc3326dedf881f26225190aa0275d3288fe)
- Ensure animation order matches previous version to avoid regressions [`972e942`](https://github.com/fomantic/Fomantic-UI/commit/972e942d64f7a78da9289651f926a19176a2749e)
- Ensures actual utf sorting. [`1207e42`](https://github.com/fomantic/Fomantic-UI/commit/1207e4278b9ef272880619b5c6db1465455911cc)
- Equality on rtl [`8c5623d`](https://github.com/fomantic/Fomantic-UI/commit/8c5623d67f7ca461b0ecad45d8c178ff50a953a5)
- Error message variables, popup [`68b19d0`](https://github.com/fomantic/Fomantic-UI/commit/68b19d09a679552e64eccb4531321ae7e9093e04)
- Even more order. [`0a87a75`](https://github.com/fomantic/Fomantic-UI/commit/0a87a751bec2a57aa8ee928dff8cd5ff39ff7750)
- Everything getting moved around [`e5baeb9`](https://github.com/fomantic/Fomantic-UI/commit/e5baeb91f4f11046f6fe3a91a3495c281654aef1)
- Everything is golden [`5689680`](https://github.com/fomantic/Fomantic-UI/commit/568968065839ba187d6c7d55946e4b54d4d899fe)
- Example formatting [`4a4bcdc`](https://github.com/fomantic/Fomantic-UI/commit/4a4bcdc37004d757a945d99003d3675a2c9a3328)
- Examples [`ae8db4e`](https://github.com/fomantic/Fomantic-UI/commit/ae8db4e2efbc978e954d399bcac758af8559c64d)
- Examples with dropdown error state added to the documentation [`28709c6`](https://github.com/fomantic/Fomantic-UI/commit/28709c6c39c76790a801cd80ecf6721677ed3e4f)
- Exit process with explicit success code [`303b657`](https://github.com/fomantic/Fomantic-UI/commit/303b6579c69622112c123413a6b45258f3103c78)
- Exit processs [`1e6315e`](https://github.com/fomantic/Fomantic-UI/commit/1e6315e972f4108ac2307c184e99fd80975d2f39)
- Expand on basic example [`bed2cda`](https://github.com/fomantic/Fomantic-UI/commit/bed2cda48bf641236beea40b728b01543541da20)
- Expanded some list vars, content can now be top aligned [`#1273`](https://github.com/fomantic/Fomantic-UI/issues/1273)  [`0c4ae6c`](https://github.com/fomantic/Fomantic-UI/commit/0c4ae6c04567f7ad0e4446f009573f9b460a6a5c)
- Experimenting with deps [`d26385f`](https://github.com/fomantic/Fomantic-UI/commit/d26385f5a5224c55b7ddd761b413673d34dee746)
- Experimenting with different docs icon, beginning theming of popup [`3750099`](https://github.com/fomantic/Fomantic-UI/commit/37500993652ce5a58f40a2089d01b2a7740d1436)
- Experimenting with new header margins [`44e12e1`](https://github.com/fomantic/Fomantic-UI/commit/44e12e1872cdd5ac615c0daa6c7fb3bd57d41d50)
- Experimenting with no zindex again [`7be3645`](https://github.com/fomantic/Fomantic-UI/commit/7be36454ab7044da3ba8edee3dc7dcd7b2bbd856)
- Experimenting with theme loading structure [`843f140`](https://github.com/fomantic/Fomantic-UI/commit/843f140554729b89246aa840449139068645bdd6)
- Explain query is available in onSearchQuery [`a8d28c5`](https://github.com/fomantic/Fomantic-UI/commit/a8d28c5bd8a2b3578c665fd0f086b620fae26c33)
- Extend debug [`d1c7b48`](https://github.com/fomantic/Fomantic-UI/commit/d1c7b48583dfe37ffe6354a491e327fdef948a86)
- Extend sticky mutation observer wait period [`ff69bb8`](https://github.com/fomantic/Fomantic-UI/commit/ff69bb80ce69989856259fe0ecef0566e571f7b0)
- Extends dropdown to set default form value, more fixes [`4d0bfb2`](https://github.com/fomantic/Fomantic-UI/commit/4d0bfb2ef68eb8626defb73fd21a37d9c52e7d47)
- Feature stripe spacing [`22edfab`](https://github.com/fomantic/Fomantic-UI/commit/22edfab422d7cfd084f14420823b7a420a27cadf)
- Fewer hints the better [`5c4a75a`](https://github.com/fomantic/Fomantic-UI/commit/5c4a75ad95b9693c9f0bcf20bbd119472b06ce65)
- Final 2.1.8 [`118bf89`](https://github.com/fomantic/Fomantic-UI/commit/118bf897ae84630ee390e97fc7279b7eb6c7b629)
- Finalize card flexbox [`#1760`](https://github.com/fomantic/Fomantic-UI/issues/1760)  [`cc46869`](https://github.com/fomantic/Fomantic-UI/commit/cc46869465c110879ef4bd44f071ef50a2f617a6)
- Finalize folder structure [`0e9da27`](https://github.com/fomantic/Fomantic-UI/commit/0e9da27234b9dbb8d7a477d8e48067cafcbb1c1d)
- Finally add selection on keyboard shortcut [`1c8d229`](https://github.com/fomantic/Fomantic-UI/commit/1c8d229aeb5722d3952631905b2762a926d95f81)
- Finally fixes css animations, fill-mode was being overwritten by using shorthand in other rules [`25ab448`](https://github.com/fomantic/Fomantic-UI/commit/25ab44822fd132c6a2ac880d7cdd2c0d5184ee7a)
- Finish [`#3529`](https://github.com/fomantic/Fomantic-UI/issues/3529) dependent fields [`b75d5f4`](https://github.com/fomantic/Fomantic-UI/commit/b75d5f44e348724fbdf7fc8a7d697fb68cb6605e)
- Finish a good portion of grid enhancements, except word order [`1c299d2`](https://github.com/fomantic/Fomantic-UI/commit/1c299d259603a4f538591984aca2d6ef37148278)
- Finish breadcrumb theming [`f675f02`](https://github.com/fomantic/Fomantic-UI/commit/f675f0206511ab3a45428671080e8af94a6d69f1)
- Finish card doubling variation [`9fc417f`](https://github.com/fomantic/Fomantic-UI/commit/9fc417f1836d0d9e97652fe3de7fcaa0ee3126d9)
- Finish first completed draft of embed component [`00cb9c7`](https://github.com/fomantic/Fomantic-UI/commit/00cb9c7586faeba0926998a7779d28d1802f3761)
- Finish fixing scope in less [`af45f1a`](https://github.com/fomantic/Fomantic-UI/commit/af45f1a9a6f35c075166a8021cbcd112170d9d1a)
- Finish homepage mobile tweaks [`a0aac4e`](https://github.com/fomantic/Fomantic-UI/commit/a0aac4e92da0ef4d028504464ed1dea56d698249)
- Finish iteration [`d1fe145`](https://github.com/fomantic/Fomantic-UI/commit/d1fe1455166a5c57225825977d52871945bff6f0)
- Finish loader sizing [`285aeec`](https://github.com/fomantic/Fomantic-UI/commit/285aeec1e169c38f989247d4b42bccf3377be4c2)
- Finish notes [`9dd18d4`](https://github.com/fomantic/Fomantic-UI/commit/9dd18d41f883bd1e1e11bbcd480134bccc71a7cf)
- Finish popup animations on directional tooltips [`23ebac4`](https://github.com/fomantic/Fomantic-UI/commit/23ebac4cbb10599278ecc00b2a3ea6d4dc1202cd)
- Finish popup rewrite [`d4aa962`](https://github.com/fomantic/Fomantic-UI/commit/d4aa9623d7e580158193d367536bba0370c9dfc1)
- Finish porting of new FontAwessome [`b9e83b2`](https://github.com/fomantic/Fomantic-UI/commit/b9e83b2979f0d198407de29daabe3d4c5a8bc79b)
- Finish refactoring, search now returns result object in onSelect [`#1634`](https://github.com/fomantic/Fomantic-UI/issues/1634)  [`7322fe9`](https://github.com/fomantic/Fomantic-UI/commit/7322fe971d9d295b5bd49422ad263084dcce97b9)
- Finish rewrite of popup positioning [`#1605`](https://github.com/fomantic/Fomantic-UI/issues/1605)  [`81ab3b9`](https://github.com/fomantic/Fomantic-UI/commit/81ab3b98a6356f3bba5489681f0d3ede7464ef15)
- Finish theming popup, fix positioning variations to never escape boundaries of element [`40379b9`](https://github.com/fomantic/Fomantic-UI/commit/40379b9841973143c56fabe58171a060ad3648da)
- Finish variables for table [`26d61fe`](https://github.com/fomantic/Fomantic-UI/commit/26d61febe641ec095deb6d2c766c89321d8e896e)
- Finish width/height setting on shape [`6093973`](https://github.com/fomantic/Fomantic-UI/commit/6093973ec88c9b1917e46a598c4edf4abd4ab897)
- Finish working on basic label [`0f83ba0`](https://github.com/fomantic/Fomantic-UI/commit/0f83ba085cf3d5e95a27209671fd7594ffe1a4b4)
- Finished &lt;select&gt; generation for searchable dropdowns, bug fixes, docs changes [`f2d7d0c`](https://github.com/fomantic/Fomantic-UI/commit/f2d7d0c2446485d540b07b1d70154419bd1d34b6)
- Finished modifications to dropdown error states for form/dropdown [`295e225`](https://github.com/fomantic/Fomantic-UI/commit/295e225ae4454c5965184d6de9aae33ead29bfb0)
- Finishes @inputPlaceholderColor (was not applying global styles to dropdown). Remove missing variable [`#3975`](https://github.com/fomantic/Fomantic-UI/issues/3975)  [`a764af6`](https://github.com/fomantic/Fomantic-UI/commit/a764af62caa1fe0cced90676aa6edcdfd0858c16)
- Finishes [`#2610`](https://github.com/fomantic/Fomantic-UI/issues/2610) and #2607 issues with checkbox focus styles [`36bab3e`](https://github.com/fomantic/Fomantic-UI/commit/36bab3ec9654afb74154f2de3cbe1fc6158cdf16)
- Finishes embed component [`6c64098`](https://github.com/fomantic/Fomantic-UI/commit/6c640987b3d86f97e36a9bb1d5619c9d34385930)
- Finishes grunt config, sets up less config, makes everything super pretty, adds grunt tasks [`5fe4310`](https://github.com/fomantic/Fomantic-UI/commit/5fe4310126fa96b86010eebcbc22668b686894c6)
- Finishes homepage example [`1295e35`](https://github.com/fomantic/Fomantic-UI/commit/1295e35a30f5cae7c7545f8dc251662526ca2c56)
- Finishes list variables, adjustments/tweaks to image variables [`aafa618`](https://github.com/fomantic/Fomantic-UI/commit/aafa618a077ebaa3ee3f0a3922a72383d89ab4f0)
- Finishes math on ribbon triangle offset [`4a6d444`](https://github.com/fomantic/Fomantic-UI/commit/4a6d444f08553180e06ddc6d533baef6d1678446)
- Finishes new nav menu for docs [`c28dcfb`](https://github.com/fomantic/Fomantic-UI/commit/c28dcfb92c329aa78cd7699fa8070386bce54890)
- Finishes recode of mock and complete callbacks from API. Aims to improve comprensiveness of debug statements. Adds ability for mocked responses to use all the settings available to regular API requests like loadingDuration [`66f8090`](https://github.com/fomantic/Fomantic-UI/commit/66f809067d6586667edcefc4c6262c5e7927b91b)
- Finishes renames [`#3984`](https://github.com/fomantic/Fomantic-UI/issues/3984)  [`0749182`](https://github.com/fomantic/Fomantic-UI/commit/074918211e9306a9f5d132f47d4f7660ab6c9f32)
- Finishes rewrite of modules [`5542128`](https://github.com/fomantic/Fomantic-UI/commit/5542128edfb77ad5d7871451bf0fa339a9d84e26)
- Finishes showNoResults setting [`68b0074`](https://github.com/fomantic/Fomantic-UI/commit/68b007461a257d301b6c606992c3bbec451451f4)
- Finishing colored row/columns [`682a723`](https://github.com/fomantic/Fomantic-UI/commit/682a7231ed6dbcad001493e3174e864a4807f84f)
- Finishing first pass on css transition module, needs docs. Some animations need debugging. [`a1e1dd7`](https://github.com/fomantic/Fomantic-UI/commit/a1e1dd7ec6162183994dbe91985372722f15730e)
- Finishing theming of messages, adds github and google message themes [`e66ce4d`](https://github.com/fomantic/Fomantic-UI/commit/e66ce4dcdc808a5f7850d7847964982c99c646da)
- Finishing touches on table variables [`fa273ca`](https://github.com/fomantic/Fomantic-UI/commit/fa273cab8b8ef7c9284dcb5f2274937b3c7ad1dc)
- Finishing up grid overview [`efd0afa`](https://github.com/fomantic/Fomantic-UI/commit/efd0afa66601452017abe12faa8b443a06fbce60)
- First commit reveal and docs [`46cd5ee`](https://github.com/fomantic/Fomantic-UI/commit/46cd5eefdb3cd4dd56d04d74ad0e2bab2d32ee57)
- First pass at flags documentation [`2df6241`](https://github.com/fomantic/Fomantic-UI/commit/2df62411338cfaaf0ce85296517fa7a7d97d6a44)
- First pass simple material theme [`ea906db`](https://github.com/fomantic/Fomantic-UI/commit/ea906db4c53cd3bcff5b7eddb5f1a36483784a5c)
- First rough non-working pass at rapid writing carousel module [`d268212`](https://github.com/fomantic/Fomantic-UI/commit/d268212d9236837aa300a508ba6aba2e1580de33)
- First version of dimmer added [`1415a1a`](https://github.com/fomantic/Fomantic-UI/commit/1415a1a1bd7fff32cb6c3fb4fe14144d705a0af6)
- Flag overrides modified [`d3b2005`](https://github.com/fomantic/Fomantic-UI/commit/d3b20059dd033f36e64e2a19e20d939e78a04d25)
- Flexbox feeds [`4a7868a`](https://github.com/fomantic/Fomantic-UI/commit/4a7868abc5695f2371f08318f0ead9c2b11fc811)
- Font size is no longer 0 inside reveal when rem0 [`e5dfded`](https://github.com/fomantic/Fomantic-UI/commit/e5dfded813daf4774846566e7e0d450d67a20b11)
- Force HTTPS URLs [`2006131`](https://github.com/fomantic/Fomantic-UI/commit/200613183c6597682e87c91253b6559099529b79)
- Forces list items to clear floats [`48b3494`](https://github.com/fomantic/Fomantic-UI/commit/48b3494cb33b6a53e8852ad49db027fb24854e6c)
- Forces no negative margins on top level grids to avoid body overflow [`1ad5a0d`](https://github.com/fomantic/Fomantic-UI/commit/1ad5a0d75d8bed8fcb0a3ac073b0427a167495de)
- Forgetting implementing `both sides labeled` [`0d92b4f`](https://github.com/fomantic/Fomantic-UI/commit/0d92b4f6ac286c2bda5e089424348f2e681d1b5c)
- Forgot to update site ver # [`819b608`](https://github.com/fomantic/Fomantic-UI/commit/819b6084270332a05ff67bc52a065455268b7444)
- Fork inquirer [`c75f2e5`](https://github.com/fomantic/Fomantic-UI/commit/c75f2e57402d211311e78b92c41a366aabf7dcd4)
- Forked package typo [`0fb7242`](https://github.com/fomantic/Fomantic-UI/commit/0fb72422eccbc00eae1128772478ae4583480353)
- Form Data Set [`644daec`](https://github.com/fomantic/Fomantic-UI/commit/644daecfc2cb908929be9e188711ed09c307cddd)
- Form Validation: fix reset/clear triggering validation on checkbox. Fix form validation requiring checkbox js [`3a98342`](https://github.com/fomantic/Fomantic-UI/commit/3a98342ec7d53e54c6d4c3abb912a3b2b9ba4a48)
- Form fields (grouped field) now use negative margins like columns, this prevents middle rows in even sized fields being slightly smaller than other rows [`4db2dd5`](https://github.com/fomantic/Fomantic-UI/commit/4db2dd5ba671f8420e53ecd352d8bbac5de9c86a)
- Form variable beginning [`9f8c8e3`](https://github.com/fomantic/Fomantic-UI/commit/9f8c8e3f6e64449d84cfa00044992efeaf7af26e)
- Format gulpfile, dashes [`ddbe345`](https://github.com/fomantic/Fomantic-UI/commit/ddbe3458b49c8937891e927da8af3c01633ac82d)
- Formatting [`8b3b9d3`](https://github.com/fomantic/Fomantic-UI/commit/8b3b9d3b7fea2d29ce4945e9ae2b8b46cde672d4)
- Formatting for popup [`#1550`](https://github.com/fomantic/Fomantic-UI/issues/1550)  [`604ed9b`](https://github.com/fomantic/Fomantic-UI/commit/604ed9b6b63597fa16607f654b289714dce3f93e)
- Formatting for sidebar [`#1550`](https://github.com/fomantic/Fomantic-UI/issues/1550)  [`7d9f50a`](https://github.com/fomantic/Fomantic-UI/commit/7d9f50a451ca02e1facb96a0dcb033c5088779ca)
- Formatting on popup [`84c902a`](https://github.com/fomantic/Fomantic-UI/commit/84c902ac20ecd8dca65623989b701376bf189aee)
- Formatting on rtl [`a60deeb`](https://github.com/fomantic/Fomantic-UI/commit/a60deeba3623e0610253a1477a1b45f69007f32a)
- Further sidebar optimizations for mobile [`efac55c`](https://github.com/fomantic/Fomantic-UI/commit/efac55c23cc2724f17f6335b47e0ebfcad1bfea8)
- Fuzzy search no longer evaluates true on numerical matches. Fixed 'get result' when id is falsey i.e 0 [`74e5adb`](https://github.com/fomantic/Fomantic-UI/commit/74e5adbbd570e6a9ed6021ecaf395109df5a03ec)
- Get rid of unnecessary z index in segment loading [`af5355c`](https://github.com/fomantic/Fomantic-UI/commit/af5355c08747b588d4c8dd823b191b34411470d1)
- Gets progress module to a point where it is ready to be published [`41f2d01`](https://github.com/fomantic/Fomantic-UI/commit/41f2d0123ae372755d1089f8b5952f1dff3b0685)
- Github button theme [`5884a4b`](https://github.com/fomantic/Fomantic-UI/commit/5884a4b3e9ec4903bf7f25dbe226c96e56d1e7a8)
- Github buttons are using compact style! [`a548b63`](https://github.com/fomantic/Fomantic-UI/commit/a548b6361be211ccefc2bb7648cc420f20d4ecd9)
- Github themes [`df2ab07`](https://github.com/fomantic/Fomantic-UI/commit/df2ab0767bdc602a757d2abf9c05090eb26d7a58)
- Give Jack's @ a link [`f1f4987`](https://github.com/fomantic/Fomantic-UI/commit/f1f498750065c10222e75cc42001b71841045f7b)
- Google theme is now material, updates fadeup/down scale transitions to not be relative to size of element. Now specified in rem [`496eb98`](https://github.com/fomantic/Fomantic-UI/commit/496eb988be68d1f3071c4d6ca2d45cfb933300fa)
- Got that ish perfect [`72ce657`](https://github.com/fomantic/Fomantic-UI/commit/72ce657ffa368290b4b12bf3241b1f38234b885a)
- Greatly simplify stackable grid [`339b473`](https://github.com/fomantic/Fomantic-UI/commit/339b47398e32ba257f83320a53e53a6e3aedb4c5)
- Greatly speed up visiblity events [`1982c95`](https://github.com/fomantic/Fomantic-UI/commit/1982c95461823ff6d961eeca4d502347a7dd3397)
- Grid fixing foreva [`1932dca`](https://github.com/fomantic/Fomantic-UI/commit/1932dca4e7c95c2ef73a12b6bc3b2221e00b6598)
- Grids and containers inside menu should inherit valign [`77b924e`](https://github.com/fomantic/Fomantic-UI/commit/77b924ed9c87f66ca951179c379237772149cec3)
- Grouping selectors [`ef529b3`](https://github.com/fomantic/Fomantic-UI/commit/ef529b3a1db8d769bba30ff0891d9d4a4669aacb)
- Gulp iteration [`3fe7348`](https://github.com/fomantic/Fomantic-UI/commit/3fe734836348610cad8aa762863bb9b03802f93c)
- Gulping [`bb0d13d`](https://github.com/fomantic/Fomantic-UI/commit/bb0d13d25026599d81458d4c8b7d9f06fb85135b)
- Have to run, commit msg later [`bf8144c`](https://github.com/fomantic/Fomantic-UI/commit/bf8144c8e81d8fa6fbb66e4faa720d16d1625c2f)
- Header UI now inherits from site.variables [`6e474fb`](https://github.com/fomantic/Fomantic-UI/commit/6e474fb9c36825667500f991f2a2ac3c9dd2f45f)
- Header font missing from h1-h5 without ui header [`#1314`](https://github.com/fomantic/Fomantic-UI/issues/1314)  [`58a7038`](https://github.com/fomantic/Fomantic-UI/commit/58a7038e51e1301014ee5b77ee9af71729fbabe7)
- Header uses border color [`6aee3be`](https://github.com/fomantic/Fomantic-UI/commit/6aee3becc97df8f189b97f69a654fe3398398d7c)
- Header/button inherits fonts from global instead of redefining inside def [`32cfe8a`](https://github.com/fomantic/Fomantic-UI/commit/32cfe8a85a429cd7a86457cb2ab2dcc4fb89c691)
- Here goes  nothing [`908a16d`](https://github.com/fomantic/Fomantic-UI/commit/908a16ddffc4991d3426a6f56613287887a685b9)
- Hey we got it all working again! [`ae60b15`](https://github.com/fomantic/Fomantic-UI/commit/ae60b15302733ff96efa3668c925ae5421196e6b)
- Hoist install folder [`fc0e03d`](https://github.com/fomantic/Fomantic-UI/commit/fc0e03d98b5a62176e6e228c2f30d8df4feb573a)
- Holy calamity animations up the wazoo. Integrating transitions lib into [`ed6c935`](https://github.com/fomantic/Fomantic-UI/commit/ed6c93518dd004d2999cbf4e1de1981fe881703e)
- Homepage good enough to publish for now.. [`29a10aa`](https://github.com/fomantic/Fomantic-UI/commit/29a10aa367827712034ebca5e72ae40458d3405d)
- Horizontal dividers now have letter spacing variables, can use em spacing around text [`d20bff5`](https://github.com/fomantic/Fomantic-UI/commit/d20bff56df1a4296544896f5fd997cf93f691f12)
- Hotfix for typo [`a9cd492`](https://github.com/fomantic/Fomantic-UI/commit/a9cd4922279326128726e081a7a2f1c4314a5ff3)
- How many typos can one dev make? [`f61d34a`](https://github.com/fomantic/Fomantic-UI/commit/f61d34a7ae030ead85719577f8a53e2453448367)
- I bet you can guess whats in this commit [`cbc0600`](https://github.com/fomantic/Fomantic-UI/commit/cbc06001dc94e16492031bcfe26485209dd8a7c9)
- Icon header is now back to inline-block with clearing [`0adf1f1`](https://github.com/fomantic/Fomantic-UI/commit/0adf1f10a8cd8fe10bf93eea3d1f51177d1de6d6)
- Icon menu should be auto width when vertical [`ea250f3`](https://github.com/fomantic/Fomantic-UI/commit/ea250f3704544e30576b4cdbda2f1b443b685b4c)
- Icons no longer set height, better valign. [`777b802`](https://github.com/fomantic/Fomantic-UI/commit/777b8020ed1778d7ff6bd892b7ec3bb6c6de0508)
- If semantic.json was not found, exit with an error code. [`79e615a`](https://github.com/fomantic/Fomantic-UI/commit/79e615a0bbf0c3d2e6cd225514279be55a43e118)
- Ignore oauth.js [`7716024`](https://github.com/fomantic/Fomantic-UI/commit/7716024ffa4a439bb6df6a7c4bb0f6a89472341d)
- Ignoring some files types [`92701c5`](https://github.com/fomantic/Fomantic-UI/commit/92701c544f869603d99efe9a7edea6eb9903ebcc)
- Implement filter function for transforming server responses [`23dfec6`](https://github.com/fomantic/Fomantic-UI/commit/23dfec6f22862d5a0e15b7f8b4797cbf8be5c4c9)
- Implement inverted / inverted basic primary / secondary button [`16e4942`](https://github.com/fomantic/Fomantic-UI/commit/16e49424180363bbec3c6aa2994848daf83d483b)
- Implement prompt as a function [`#6016`](https://github.com/fomantic/Fomantic-UI/issues/6016)  [`9eb4ac3`](https://github.com/fomantic/Fomantic-UI/commit/9eb4ac3c20fd069034a9406bd3ea1e447c87c560)
- Implements [`#4224`](https://github.com/fomantic/Fomantic-UI/issues/4224) - justified centered grid fix [`d65d2e3`](https://github.com/fomantic/Fomantic-UI/commit/d65d2e3775c7d860c22fc9a506706f18f51b649c)
- Implements [`#4458`](https://github.com/fomantic/Fomantic-UI/issues/4458)  [`06e16f2`](https://github.com/fomantic/Fomantic-UI/commit/06e16f2ce540a94744e680ea711cce53ab1ff3a8)
- Implements onLabelRemove [`#3209`](https://github.com/fomantic/Fomantic-UI/issues/3209)  [`58e8f68`](https://github.com/fomantic/Fomantic-UI/commit/58e8f684aa9c03984f42709ea336e9976f8e2fc8)
- Implment reversed divided, reversed vertically divided, reversed celled, reversed internally celled grid [`#2685`](https://github.com/fomantic/Fomantic-UI/issues/2685)  [`e42fc29`](https://github.com/fomantic/Fomantic-UI/commit/e42fc29dc6fdb2840ada871a2e1e812eb6fa63c1)
- Improves queueing efficiency [`4a79213`](https://github.com/fomantic/Fomantic-UI/commit/4a7921398cd9ac1759d744f4be64d3b0b240965b)
- Improves vertical padding alignment on inputs, fixes bugs with descendors being cut off [`a784c62`](https://github.com/fomantic/Fomantic-UI/commit/a784c62a464a8b5fdc4ac590e2e87d90c5111cb0)
- In-Menu input action button corrections. [`81ac1c9`](https://github.com/fomantic/Fomantic-UI/commit/81ac1c91bbf602b52b35cde2501b60895980d871)
- Incomplete work [`d1ba07a`](https://github.com/fomantic/Fomantic-UI/commit/d1ba07aaf14b44d6810205de8490be245519a3c5)
- Incorrect error text [`364ad39`](https://github.com/fomantic/Fomantic-UI/commit/364ad398d86fed6b14a09d765c20d5f4c5ab9b9f)
- Increase contrast on button hover/down colors [`f2c9333`](https://github.com/fomantic/Fomantic-UI/commit/f2c9333b79a1a41058d09709c251dfa30bc236e4)
- Increase contrast on rating icons, hitbox on heart, remove console log [`f600977`](https://github.com/fomantic/Fomantic-UI/commit/f6009776edb4fdbb5c0c8e0213bcbde64764f3cf)
- Increase default message header spacing [`9276782`](https://github.com/fomantic/Fomantic-UI/commit/927678274ec98c8dfa67aecc199a28bfbb29f482)
- Increase delay between git push due to issues with flooding [`2b52ce3`](https://github.com/fomantic/Fomantic-UI/commit/2b52ce349f78f5cf5424d933d78dbdaaa459974e)
- Increase delay of performance logging [`3701bdc`](https://github.com/fomantic/Fomantic-UI/commit/3701bdc35f007228925545efa3d47cd52113540b)
- Increase divider spacing in breadcrumb [`eacab1c`](https://github.com/fomantic/Fomantic-UI/commit/eacab1c2cc33a2b6e837d942df7b1ce98ee8a89e)
- Increase font size of messages slightly [`cba19ca`](https://github.com/fomantic/Fomantic-UI/commit/cba19ca5b55799be3e3e4cb0b234df5e04e28dfe)
- Increase row spacing slightly [`9536dd4`](https://github.com/fomantic/Fomantic-UI/commit/9536dd49c3fbc7118a410527c7128f2dfc25ae6b)
- Increase sticky performance with scroll [`187e68f`](https://github.com/fomantic/Fomantic-UI/commit/187e68f9a28fb73418978501c07349880a33c701)
- Increase vertical pointing secondary menu horizotnal padding slightly [`8f3f966`](https://github.com/fomantic/Fomantic-UI/commit/8f3f966b099c6fc9f7ace4b0c7c83a3e1e36c60d)
- Increases focused button emphasis [`ecea8a0`](https://github.com/fomantic/Fomantic-UI/commit/ecea8a02acdf3f7f38460b8eb476b4c8d0cc83b2)
- Increases list item margin on message [`212935c`](https://github.com/fomantic/Fomantic-UI/commit/212935c0c619ba019a280ed79cbddebb67df4e58)
- Index updating [`f5be0a5`](https://github.com/fomantic/Fomantic-UI/commit/f5be0a5942cffe62dc5cd5668ac3129a4d33ede7)
- Infer composer.json version from tags [`#1853`](https://github.com/fomantic/Fomantic-UI/issues/1853) &lt;https://getcomposer.org/doc/02-libraries.md#tags&gt; [`a262f3b`](https://github.com/fomantic/Fomantic-UI/commit/a262f3bd72e0997393cab42c3c6727195046c349)
- Info messages are now visible inside forms [`51bfcbb`](https://github.com/fomantic/Fomantic-UI/commit/51bfcbb3a63ec6a88e3f77f18595b097fd7759ef)
- Initial commit [`d37520a`](https://github.com/fomantic/Fomantic-UI/commit/d37520a7de17b9f6659614c14e091a46ccc54d16)
- Initial commit blank container element [`8f3bffe`](https://github.com/fomantic/Fomantic-UI/commit/8f3bffeeb2eac466da64bf4df3a6fce95fa12821)
- Initial commit of global site config [`fa1b35a`](https://github.com/fomantic/Fomantic-UI/commit/fa1b35a3efeb662403a4600f0907780221ee087b)
- Initial commit of themed dropdowns [`99eecc2`](https://github.com/fomantic/Fomantic-UI/commit/99eecc2ddda9091fbe1b7c78eae8db9643476abf)
- Initial setup of docpad server in node [`375337c`](https://github.com/fomantic/Fomantic-UI/commit/375337ccc1d0b09c22b46cb7fe5ef8e365cbd59b)
- Initial test commit of travis.yml and node package [`8a93ee9`](https://github.com/fomantic/Fomantic-UI/commit/8a93ee9eb581441d2ebd9340d6dba3b1c58d1241)
- Initial wiring of API to dropdown [`5585502`](https://github.com/fomantic/Fomantic-UI/commit/5585502e2600844b0f5d464106db81cacfaeeb0c)
- Initial work on statistic doc [`d813776`](https://github.com/fomantic/Fomantic-UI/commit/d813776670cf0a202e8c6c02fb52289ab8907515)
- Initial write of progress module [`07ea079`](https://github.com/fomantic/Fomantic-UI/commit/07ea079fb54bac99a49ced8e3ecbe50d0f29fa96)
- Input selectors now require child selector to avoid inheritance issues [`#4157`](https://github.com/fomantic/Fomantic-UI/issues/4157)  [`282bdb9`](https://github.com/fomantic/Fomantic-UI/commit/282bdb984e5cfa5df1e14346c3075d2ae97cb7b0)
- Install [`d39cac3`](https://github.com/fomantic/Fomantic-UI/commit/d39cac35cca5084b12dc2a8b52a28da896c66702)
- Install message [`7027240`](https://github.com/fomantic/Fomantic-UI/commit/702724006f4566e770b5585b7c1249fee9e3d339)
- Install path changes [`#2101`](https://github.com/fomantic/Fomantic-UI/issues/2101)  [`d6e0ccb`](https://github.com/fomantic/Fomantic-UI/commit/d6e0ccbf23ca50b209bc067297e212aa7cc4d454)
- Instead of clearing on reset when no default was set, do nothing [`#2504`](https://github.com/fomantic/Fomantic-UI/issues/2504)  [`90b581f`](https://github.com/fomantic/Fomantic-UI/commit/90b581f05e2d29aea876f529c5ae13d6e4391274)
- Intermediary work on tagging [`4f6cd38`](https://github.com/fomantic/Fomantic-UI/commit/4f6cd3809ce09be39becc2f6afa9c7a15ae01492)
- Invoke now can translate ('make money') to makeMoney or make: { money: function(){}} [`036bce4`](https://github.com/fomantic/Fomantic-UI/commit/036bce4aa6294c013f0054725fc35393cd7e0786)
- It was all caused by using shallow extend! [`1c915c1`](https://github.com/fomantic/Fomantic-UI/commit/1c915c121067061245942f5b5817006bcae97870)
- Iterating on gulpfile [`fc2b545`](https://github.com/fomantic/Fomantic-UI/commit/fc2b545f361c69631b46261f71051d9290168749)
- Iterating on gulpfile restructure [`2bc5d6f`](https://github.com/fomantic/Fomantic-UI/commit/2bc5d6fd3fd850e548281eb6fcb772225fd21dfb)
- Iterating on header theming [`2d12d33`](https://github.com/fomantic/Fomantic-UI/commit/2d12d33c56d128d46e0db8d58beaaa17bc5c4c04)
- Iterating on homepage [`bb1be57`](https://github.com/fomantic/Fomantic-UI/commit/bb1be57d6fef0a4990e5fe290241d244a479d56d)
- Iterating on install [`42b176c`](https://github.com/fomantic/Fomantic-UI/commit/42b176cc7a986cb6ebb652d92be41c5cf21ad5a1)
- Iterating on install script [`01e1b7b`](https://github.com/fomantic/Fomantic-UI/commit/01e1b7b61648ff02e18e9544de7ce03dd243beaf)
- Iterating on module design pattern. Fixes to performance logging. Much work on dimmer class, new thoughts on fusion of dimmer and modal [`a4332c6`](https://github.com/fomantic/Fomantic-UI/commit/a4332c6095ac0e3576e73098a886210a7608b799)
- Iterating on multi select completion [`f76eb49`](https://github.com/fomantic/Fomantic-UI/commit/f76eb496c02e354308caf96988a1a686e46a069c)
- Iterating on multiselect fixes [`d5308d3`](https://github.com/fomantic/Fomantic-UI/commit/d5308d3438e016d21a98d4cd89296f86374c7fd8)
- Iterating on sidebar directions, default animations for directions, more features [`d46656a`](https://github.com/fomantic/Fomantic-UI/commit/d46656aee811349d333c0629131692baa2a20d6b)
- Iterating on variables in menu/button and themes [`d521324`](https://github.com/fomantic/Fomantic-UI/commit/d5213249400c44738a0ed7800d798af51c83a628)
- Iterating on word order dependencies across all UI [`#396`](https://github.com/fomantic/Fomantic-UI/issues/396)  [`b07fab0`](https://github.com/fomantic/Fomantic-UI/commit/b07fab059a3e89463a1c4ecc02967a408e85ba8e)
- Iteration on API docs [`a0e4dc9`](https://github.com/fomantic/Fomantic-UI/commit/a0e4dc930e03087cdae6009fdff519364398f21d)
- Iteration on allowAdditions setting for selection dropdown [`99924ad`](https://github.com/fomantic/Fomantic-UI/commit/99924ad7004374a07b8d1b8a39376f6889cd26c4)
- Iteration on buttons [`d373f1c`](https://github.com/fomantic/Fomantic-UI/commit/d373f1c3e4e4d2974c9e5a05209713fd1efa4348)
- Iteration on container [`2986331`](https://github.com/fomantic/Fomantic-UI/commit/29863318eb2d2f27c56825fe99db6b254e76ff23)
- Iteration on dropdown tweak list [`2198d01`](https://github.com/fomantic/Fomantic-UI/commit/2198d01247c01016f733f2741fa898d05f2f1c73)
- Iteration on embed [`25ba7f0`](https://github.com/fomantic/Fomantic-UI/commit/25ba7f03218b3b3567075ed963b73b2333c6e788)
- Iteration on embed rewrite [`26d2003`](https://github.com/fomantic/Fomantic-UI/commit/26d20037953eb567dd062cf316b9288cceba0943)
- Iteration on fixing onStart onComplete across all components using transition, trying to solve sidebar still [`98bc6b8`](https://github.com/fomantic/Fomantic-UI/commit/98bc6b82020f3549d536df0708025f59108c9811)
- Iteration on flexbox bugs in menu [`38cd215`](https://github.com/fomantic/Fomantic-UI/commit/38cd215ff617896e6be8b45c89eadd0cbdc2ab09)
- Iteration on git automation [`7881197`](https://github.com/fomantic/Fomantic-UI/commit/78811974e83dd655221f7b007b07136647adcbe8)
- Iteration on grid docs, and grid fixes [`a801642`](https://github.com/fomantic/Fomantic-UI/commit/a80164233acb5be96e0622020860f2dfd0da2582)
- Iteration on gulpfile [`0d0ffef`](https://github.com/fomantic/Fomantic-UI/commit/0d0ffef0ed24e15a4308d28ea339e5dbed72715a)
- Iteration on gulpfile design [`dc5e672`](https://github.com/fomantic/Fomantic-UI/commit/dc5e6724893ad6eb3a8f932daee09144c92d7af0)
- Iteration on homepage animations [`beb1689`](https://github.com/fomantic/Fomantic-UI/commit/beb1689b196777a00b0edd3262ecb28f6a383f35)
- Iteration on install [`93cd582`](https://github.com/fomantic/Fomantic-UI/commit/93cd582642230b4d76bd4aa9f43a3ea9a7ce829d)
- Iteration on install process [`627056f`](https://github.com/fomantic/Fomantic-UI/commit/627056f67a1adefa533d12fb9c17775adff005f4)
- Iteration on install rewrite [`6da6f18`](https://github.com/fomantic/Fomantic-UI/commit/6da6f186a40cae9241953707d0e39648e4f7e9d6)
- Iteration on install script [`65d037d`](https://github.com/fomantic/Fomantic-UI/commit/65d037dd666386b273f38c239211e96a11f67f18)
- Iteration on install scripts [`2295e50`](https://github.com/fomantic/Fomantic-UI/commit/2295e507f9b559d660cdf506aaceae144006fcf2)
- Iteration on kitchen [`f4e89fb`](https://github.com/fomantic/Fomantic-UI/commit/f4e89fb86f4c7b85f2daef28b52cc3fbc79c7cf8)
- Iteration on list variables [`4f45153`](https://github.com/fomantic/Fomantic-UI/commit/4f4515337d32124a5b54812a24d6a41490632a67)
- Iteration on menu fixes from border changes [`7b3a84f`](https://github.com/fomantic/Fomantic-UI/commit/7b3a84f861dc23e72a50f6ed830f851e5d9b065f)
- Iteration on menu fixes with flex, along with some design changes to make menu more neutral Fixes: [`#1281`](https://github.com/fomantic/Fomantic-UI/issues/1281)  #1475 [`5cc8f33`](https://github.com/fomantic/Fomantic-UI/commit/5cc8f33aebf3d6b7209e695422bb00a231d5bc71)
- Iteration on menu flex fixes [`2df8721`](https://github.com/fomantic/Fomantic-UI/commit/2df87210a03cfa4a444a0b279805fdda52f854d0)
- Iteration on multi select [`#847`](https://github.com/fomantic/Fomantic-UI/issues/847)  [`41a9f96`](https://github.com/fomantic/Fomantic-UI/commit/41a9f963948741c10c628af392e0b4c12b17f282)
- Iteration on multiselect [`#847`](https://github.com/fomantic/Fomantic-UI/issues/847)  [`52897fd`](https://github.com/fomantic/Fomantic-UI/commit/52897fdbc4d63973f119284fc70074bf9a1d8541)
- Iteration on multiselect [`5513680`](https://github.com/fomantic/Fomantic-UI/commit/5513680a9f1e8ce9eebb9e5d140d6111af17bbd6)
- Iteration on multiselect fixes [`02c9fb2`](https://github.com/fomantic/Fomantic-UI/commit/02c9fb2e8a84266afeaa8001b69c769b39463f80)
- Iteration on multiselect, adds label deletion, proper string delimiters [`78cee91`](https://github.com/fomantic/Fomantic-UI/commit/78cee91a532adc10cddc183f782634dbe4ffee10)
- Iteration on regex for comment replacement [`958cfcc`](https://github.com/fomantic/Fomantic-UI/commit/958cfcc456151664f137410fdb7735d87fe145df)
- Iteration on search fixes [`1d8a8e3`](https://github.com/fomantic/Fomantic-UI/commit/1d8a8e3fe74dec8a3b144951b3837e6c1735c44a)
- Iteration on searchable blur fix [`f34b952`](https://github.com/fomantic/Fomantic-UI/commit/f34b9521bb313879dd44fcc16b09f2d1bbb3522d)
- Iteration on settings inheritance [`00cfecd`](https://github.com/fomantic/Fomantic-UI/commit/00cfecdc9a8819f7249e83d40be9b2a114134631)
- Iteration on setup wiz [`368d6c5`](https://github.com/fomantic/Fomantic-UI/commit/368d6c5afd3424513f55f7919bd7f9cd0a7e716d)
- Iteration on sidebar [`7c8e338`](https://github.com/fomantic/Fomantic-UI/commit/7c8e338704f2c63a6bfc9627c81548a18b275914)
- Iteration on sidebar and other fixes [`745232d`](https://github.com/fomantic/Fomantic-UI/commit/745232d626964aa5a39bdb36c9bd7156985e7dc0)
- Iteration on single component deploys [`8e04de8`](https://github.com/fomantic/Fomantic-UI/commit/8e04de877025dfd204cb48c1fb7dca3f398994ab)
- Iteration on state and api docs [`8719779`](https://github.com/fomantic/Fomantic-UI/commit/8719779f00bde974a1a383294299aa6ebd839669)
- Iteration on tasks [`47bf0a9`](https://github.com/fomantic/Fomantic-UI/commit/47bf0a99f2536a5cab2fa37417d07301f9dd0b15)
- Iteration on theme site install [`57b35d2`](https://github.com/fomantic/Fomantic-UI/commit/57b35d2150f556ea91a334cc11a52f5289052583)
- Iterations on visibility, getting ready for docs [`dec01c0`](https://github.com/fomantic/Fomantic-UI/commit/dec01c0adabd56008c70bfb26cd60c3d4abbf1ba)
- JS formatting: implicit brackets, full words, removing meteor tasks from build/install [`ba2e1f6`](https://github.com/fomantic/Fomantic-UI/commit/ba2e1f6e499570495d9d8b34a87f6cde9fb9a347)
- Justified docs [`3d474c0`](https://github.com/fomantic/Fomantic-UI/commit/3d474c0ed11b17d577919addea6ab8db767b1a48)
- Keep blank values when placeholder is passed a string or false [`9b7ecef`](https://github.com/fomantic/Fomantic-UI/commit/9b7ecef679b1e01b5de6cb74bdcf55fc5a9b3866)
- Keep swapping icon button alignment, this fixes dropdown icon alignment [`e146f5e`](https://github.com/fomantic/Fomantic-UI/commit/e146f5e786e83ef3439dd5066d68c327d09367e8)
- Keeping Modal in place [`1021857`](https://github.com/fomantic/Fomantic-UI/commit/10218571004ea9c5fdd91b2aec5fa0a7b1de4c2d)
- LESS repo missing semantic.less [`f589173`](https://github.com/fomantic/Fomantic-UI/commit/f5891730ef6e9d4adca6dd923b00fe742e0cdbef)
- Label now have default img styles [`6374ad3`](https://github.com/fomantic/Fomantic-UI/commit/6374ad3506db0121be9dc05bdc5f62de697c0f81)
- Labeled buttons now vertically align labels, adds more label varaibles [`3500e36`](https://github.com/fomantic/Fomantic-UI/commit/3500e369f99fdeab9d90db1f3f3bc910fd7083ad)
- Labels now use metadata setting [`aa0c9ce`](https://github.com/fomantic/Fomantic-UI/commit/aa0c9ce453519bd339ea9adfd61f8763a0336c82)
- Labels now work inside attached segment [`48193f3`](https://github.com/fomantic/Fomantic-UI/commit/48193f37c2a017edc016a90796d8dddce920cd90)
- Language on grid [`b80f5a9`](https://github.com/fomantic/Fomantic-UI/commit/b80f5a9e939dee3f8e0cb9667084d2dbf0fdf347)
- Large monitor breakpoint now corresponds with container breakpoint [`781fa9d`](https://github.com/fomantic/Fomantic-UI/commit/781fa9d3d7881958b76dc19211b7b14243c8234c)
- Last minute regression fixes from leftward changes [`#4506`](https://github.com/fomantic/Fomantic-UI/issues/4506)  [`2c3511b`](https://github.com/fomantic/Fomantic-UI/commit/2c3511b99c420ae16ff844b9f2b1094a01568b96)
- Latest version [`0025844`](https://github.com/fomantic/Fomantic-UI/commit/00258448a53eae636acad9bfbe144464ca8f19f8)
- Latest work [`5999046`](https://github.com/fomantic/Fomantic-UI/commit/5999046530e7eeb001a3b7cad44d7fe3a09b82c6)
- Leaving search midway will now preserve filtered results, fixed issue with IE11 when all results filtered [`be99866`](https://github.com/fomantic/Fomantic-UI/commit/be99866ffaf40e4d46a3191fae7160a9c333382f)
- Leet fix for [`#1337`](https://github.com/fomantic/Fomantic-UI/issues/1337)  checkbox now supports multi-line label [`aac00f1`](https://github.com/fomantic/Fomantic-UI/commit/aac00f123b4740cd816cb4fba0d25afaa0c773ff)
- Let gulp tasks be run from any directory by using process.cwd, fix permissions q in install [`1e0ded8`](https://github.com/fomantic/Fomantic-UI/commit/1e0ded8af9c1af3ef3f01a855b58a6da797d3e4a)
- Light default formatting changes modal [`0466002`](https://github.com/fomantic/Fomantic-UI/commit/0466002f03e9ae03ea011dcc85bc54d5435946d1)
- Light reskin of beta homepage [`566767a`](https://github.com/fomantic/Fomantic-UI/commit/566767a307202863786e8da67325fb1ad5f6cc5d)
- Light updates to video and accordion styles [`1ed3fdc`](https://github.com/fomantic/Fomantic-UI/commit/1ed3fdcf275627d68e720325687883438a9cd088)
- Lighten dropdown error hover color [`1ce202f`](https://github.com/fomantic/Fomantic-UI/commit/1ce202ffae1062ac93c8aa37d999c06b4fe79464)
- Lightnes table headers again somewhat [`926b6f9`](https://github.com/fomantic/Fomantic-UI/commit/926b6f9ab0b68c1cf936f5717141effb4f810795)
- Linkify all issues [`517c41f`](https://github.com/fomantic/Fomantic-UI/commit/517c41f9b9b65d2b782e9bb55b999cd3d61e93bb)
- Links inside lists now use default styling, increases bullet leading [`4209cc2`](https://github.com/fomantic/Fomantic-UI/commit/4209cc2a09d7e381d4c01cbfb229bceee006e35c)
- Lists use rem for internal spacing (avoid overly padded out lists on large sizes) [`66ad886`](https://github.com/fomantic/Fomantic-UI/commit/66ad886b2c46a3b9e05bbd27a73bcb2b420888f9)
- Local cache disabled by default [`57702c1`](https://github.com/fomantic/Fomantic-UI/commit/57702c1eb4ed14e3230ce3264606933ac13c08c7)
- Lockdown deps and more lenient peer deps [`6184a9b`](https://github.com/fomantic/Fomantic-UI/commit/6184a9b5446601132896e3c28d9298399a435fb2)
- Look for inline popup in all siblings of target, not just immediate sibling. [`2fadf77`](https://github.com/fomantic/Fomantic-UI/commit/2fadf77f3754a9941c2aca86e962de61be9eb50f)
- Lots of fixes, new homepage [`3663a59`](https://github.com/fomantic/Fomantic-UI/commit/3663a5930babddca9eb10ac297119ecc22f218eb)
- Major updates to segment, header, table. [`ce405c6`](https://github.com/fomantic/Fomantic-UI/commit/ce405c60180ce018dc8b75d5d3b52f91bc759f43)
- Make bulleted/ordered list bullets unselectable [`eb2189b`](https://github.com/fomantic/Fomantic-UI/commit/eb2189bb06d6b9243fc10a691269b9fdd9936353)
- Make casing consistent [`#3774`](https://github.com/fomantic/Fomantic-UI/issues/3774)  [`465358b`](https://github.com/fomantic/Fomantic-UI/commit/465358bb789643964b35f79f9b97b3578f8081d3)
- Make examples slightly less crappy [`e3822fb`](https://github.com/fomantic/Fomantic-UI/commit/e3822fb7b93d216d342021bda85120887d1502cf)
- Make fixed menu word order dependent [`c492ca5`](https://github.com/fomantic/Fomantic-UI/commit/c492ca58ddb7948f2bb1452cec3a2cf0e8cc9adf)
- Make icon size round to exact pixel to avoid valign issues [`#1779`](https://github.com/fomantic/Fomantic-UI/issues/1779)  [`f37b2a8`](https://github.com/fomantic/Fomantic-UI/commit/f37b2a83ba4a52b58affcb4253c9fff6ff52a91b)
- Make input autofocus faster [`edd8f79`](https://github.com/fomantic/Fomantic-UI/commit/edd8f7996e8cd3ef2aeb1c2a9c0b1402440f3d3a)
- Make label sizes resolve to full pixels [`b13e0ca`](https://github.com/fomantic/Fomantic-UI/commit/b13e0ca205193dec56320c23a457a0f068bdf9ca)
- Make labels slightly larger inside headers in default theme [`cf235f0`](https://github.com/fomantic/Fomantic-UI/commit/cf235f0b8b57ccdf13f297a4d8ca19e244fd436a)
- Make modal mutation observers opt-in [`#2166`](https://github.com/fomantic/Fomantic-UI/issues/2166)  [`85282f5`](https://github.com/fomantic/Fomantic-UI/commit/85282f5a348f8ae14ef8b3a2527d2b67d82c8aba)
- Make overrides optional for packaged themes [`9965473`](https://github.com/fomantic/Fomantic-UI/commit/9965473ff8c6f5720083dfaab39422e25309338f)
- Make placeholder error color more consistent, fix input placeholder color [`#2786`](https://github.com/fomantic/Fomantic-UI/issues/2786)  [`b42aac8`](https://github.com/fomantic/Fomantic-UI/commit/b42aac829e13cedac9d24198eb0adc86571ff616)
- Make rating flex [`89969f8`](https://github.com/fomantic/Fomantic-UI/commit/89969f8cf3a23063574289f9e66a2a9d4cca3a96)
- Make segment REM for margin/radius [`1deb6eb`](https://github.com/fomantic/Fomantic-UI/commit/1deb6eb70de48c89e243288ba39bbbca437fe77a)
- Make shortcut key values a setting [`#3016`](https://github.com/fomantic/Fomantic-UI/issues/3016)  [`4ca20c4`](https://github.com/fomantic/Fomantic-UI/commit/4ca20c47cf1071ed92fb508b13151c013a4a1f39)
- Make site theme optional [`3df6034`](https://github.com/fomantic/Fomantic-UI/commit/3df6034a0b524202346ec9c5fe58a37e458788a7)
- Make stackable/mobile page grids use same gutter width as columns [`275eed5`](https://github.com/fomantic/Fomantic-UI/commit/275eed5d96b515d1b6f3284c7345a02d9e805f48)
- Make stretch optional variation, fix valign [`fb33a60`](https://github.com/fomantic/Fomantic-UI/commit/fb33a600d32af3a6693e535441b1be0960151b43)
- Make sure sticky does not reflow when setting same scroll [`ddd8f79`](https://github.com/fomantic/Fomantic-UI/commit/ddd8f796a2690dbe6c49dadb30fcfd139bb1cee9)
- Make travis only email on success/failure change [`773e100`](https://github.com/fomantic/Fomantic-UI/commit/773e100a337d2dd85ab679e748cb46edcb845662)
- Make useLegacy more obvious in sidebar, default to auto [`1a701e2`](https://github.com/fomantic/Fomantic-UI/commit/1a701e20ab6725c346376dab282b01b52ab3920b)
- Makes border radius integer for 15px font-size [`afc7a6e`](https://github.com/fomantic/Fomantic-UI/commit/afc7a6e39e3d8923020bd6a867f74a60e86dd5a8)
- Making JSHint happy [`1d5ee28`](https://github.com/fomantic/Fomantic-UI/commit/1d5ee28bb90c4ca45dcb049e889b436f107f7016)
- Mark legacy grid variables [`aea4341`](https://github.com/fomantic/Fomantic-UI/commit/aea4341e1d4824e5f690b8c6c032f4fa0e0eb618)
- Match formatting [`#3085`](https://github.com/fomantic/Fomantic-UI/issues/3085)  [`f87ae3d`](https://github.com/fomantic/Fomantic-UI/commit/f87ae3d6f61ad6850a017fade0ddd6c6f8792256)
- Match is slightly more performant [`79fb39b`](https://github.com/fomantic/Fomantic-UI/commit/79fb39bdd66a8b75fa71d1519f4c6b4fbc563178)
- Material design defaults [`075d296`](https://github.com/fomantic/Fomantic-UI/commit/075d2967842524b2d873fc8338081391c1eec310)
- Merge https://github.com/pcj/Semantic-UI into next [`04d8080`](https://github.com/fomantic/Fomantic-UI/commit/04d8080055fa90df3be76bc285277e37f8a1a814)
- Merge in PR and sort transitions alphabetically [`#1623`](https://github.com/fomantic/Fomantic-UI/issues/1623)  [`405db33`](https://github.com/fomantic/Fomantic-UI/commit/405db334f021d998f06929e1a300b50d98af8cf2)
- Merge in [`#1630`](https://github.com/fomantic/Fomantic-UI/issues/1630)  Match code style, remove mixed space/tabs, add debug statements. [`c3467ed`](https://github.com/fomantic/Fomantic-UI/commit/c3467ed808f28fe4486f44ca8b01c57bf0cc5e67)
- Merge in [`#1791`](https://github.com/fomantic/Fomantic-UI/issues/1791)  [`818b04f`](https://github.com/fomantic/Fomantic-UI/commit/818b04fc5286c6fc2874cca78e6ddd8e3d5f4e2d)
- Merge pull request [`#2597`](https://github.com/fomantic/Fomantic-UI/issues/2597) from jammiemountz/patch-1 [`c2f416d`](https://github.com/fomantic/Fomantic-UI/commit/c2f416d702b5b8caad5899502730b45bb6f05724)
- Merge sidebar background inherit rules [`5ac05dc`](https://github.com/fomantic/Fomantic-UI/commit/5ac05dcd153526b2a5eae0c52683281dee2a478f)
- Merges in [`#1453`](https://github.com/fomantic/Fomantic-UI/issues/1453)  or line height [`8ec88c9`](https://github.com/fomantic/Fomantic-UI/commit/8ec88c9f2c05077dd1308ce4dedb4db069502b14)
- Mergest master into css [`08d179c`](https://github.com/fomantic/Fomantic-UI/commit/08d179c6be3e782e7efc7692d1e733d314f7db5b)
- Messages are now relative em [`befef72`](https://github.com/fomantic/Fomantic-UI/commit/befef72ebdc545ceeb887ff11e41a9b8b15fc1b2)
- Messages no longer use REM, inputs use standard error colors [`1ee8007`](https://github.com/fomantic/Fomantic-UI/commit/1ee80073562ca20e2d7b7bd2045fa9a91884cc2e)
- Messaging [`6a94e11`](https://github.com/fomantic/Fomantic-UI/commit/6a94e11e14a98d0e4d294ec9547b0da4f8214aec)
- Messaging for install [`d640afc`](https://github.com/fomantic/Fomantic-UI/commit/d640afca4d74f422c392ae6c4c8c7155661ad294)
- Messing with gulpfile [`c25fbcf`](https://github.com/fomantic/Fomantic-UI/commit/c25fbcf5a0e1f5312f017dd3f683a92dbe442788)
- Metadata can now be used to parse content links in docs [`c7e16ef`](https://github.com/fomantic/Fomantic-UI/commit/c7e16efe3db9342ee29a6f7fd5655406bf56547a)
- Metadata in docs build [`a9e1580`](https://github.com/fomantic/Fomantic-UI/commit/a9e158014742cb537a8278c435c785306a628557)
- Midnight in a perfect world [`57aac1e`](https://github.com/fomantic/Fomantic-UI/commit/57aac1e6db954271231f99dca3434a96c5cd939a)
- Migrate corner label coupling to input to be able to use variables [`#2361`](https://github.com/fomantic/Fomantic-UI/issues/2361)  [`3ec6bef`](https://github.com/fomantic/Fomantic-UI/commit/3ec6beffd4ea0cf0805317d9f2e68b5337398dcd)
- Migrates item view to card view, in preperation for a more generic card view, extends docs on cards [`989528a`](https://github.com/fomantic/Fomantic-UI/commit/989528af91093640a20da86bc6fa54016724e053)
- Migrates to clean-css [`#4125`](https://github.com/fomantic/Fomantic-UI/issues/4125)  [`51993cb`](https://github.com/fomantic/Fomantic-UI/commit/51993cba533ebcd4fe81ea0c9ae3b250408688fe)
- Mind in the wrong place [`56c5664`](https://github.com/fomantic/Fomantic-UI/commit/56c56645d608eb141cf5ec3521db0c5d7e28ff69)
- Minor button theme change [`faa5e3b`](https://github.com/fomantic/Fomantic-UI/commit/faa5e3bfccd9f576e75a7fe4d3925cab96929403)
- Minor dropdown formatting [`16ae41d`](https://github.com/fomantic/Fomantic-UI/commit/16ae41d83e0024d79e5d9ff4c64f80fe6c08d03e)
- Minor re-ordering [`bdf1f0a`](https://github.com/fomantic/Fomantic-UI/commit/bdf1f0a387b4f0571af151fa2c4540162f681702)
- Missing closing tag in loader [`16bc53c`](https://github.com/fomantic/Fomantic-UI/commit/16bc53cf6dff776d627ce2e6de93f5292956c667)
- Missing comma [`815effc`](https://github.com/fomantic/Fomantic-UI/commit/815effc123e1b19e0bf1d0e949a66901acb00dd8)
- Missing comma in admin config  [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607)  [`27771e2`](https://github.com/fomantic/Fomantic-UI/commit/27771e216f58c11c6871c9de454187fcf0e3d5b9)
- Missing comma in list [`#1273`](https://github.com/fomantic/Fomantic-UI/issues/1273)  [`ddee7f7`](https://github.com/fomantic/Fomantic-UI/commit/ddee7f70ea5f2b0cbcb85c552c9a30a2925681c1)
- Missing dep [`6270124`](https://github.com/fomantic/Fomantic-UI/commit/62701243f85a14093f798eec4249f3d617c29502)
- Missing node module updates, adds missing intro docs [`bb69c0e`](https://github.com/fomantic/Fomantic-UI/commit/bb69c0e8aafadf94f26867e6688ae55acbfcafe6)
- Missing theme [`aad5d47`](https://github.com/fomantic/Fomantic-UI/commit/aad5d4715c2758fc19439e714750531cdbdfe739)
- Missing updates from home lost during last sick week [`171f433`](https://github.com/fomantic/Fomantic-UI/commit/171f433ed3c19095c281563c4f811aa5832e713b)
- Mistaken last border radius rule [`7d2f6bd`](https://github.com/fomantic/Fomantic-UI/commit/7d2f6bd9ba3ba03427d4a74a7564ae28492799a4)
- Mobile fixes [`622b16f`](https://github.com/fomantic/Fomantic-UI/commit/622b16f6dabf5de03dcd047ae639494b47e7a24c)
- Modal cache size on load [`5511ffb`](https://github.com/fomantic/Fomantic-UI/commit/5511ffb0a6bc5c7cef96dfbf5475ea29d3f8d049)
- Modal now only closes on approve or deny selector match [`eb0e67e`](https://github.com/fomantic/Fomantic-UI/commit/eb0e67ed59acff47ce34716912bf593e6642e4ee)
- Modal now uses requestAnimationFrame, properly detects for dimmer dependency [`71e6d3c`](https://github.com/fomantic/Fomantic-UI/commit/71e6d3c49cb5d86bc89566dd143d5865da0c30fb)
- Modal- add setting for keyboard shortcuts [`bd92491`](https://github.com/fomantic/Fomantic-UI/commit/bd924919d2e471929372dc1eb6fd4e38781c1188)
- Modal/dimmer now correctly handle several simultaneous animation conditions, showing while hiding, hiding others while showing, etc. Animations now use failsafe to avoid animationend race-conditions with webkit, and the same duration [`#1417`](https://github.com/fomantic/Fomantic-UI/issues/1417) #1432 [`51cf4f5`](https://github.com/fomantic/Fomantic-UI/commit/51cf4f5b5888c290446000a2c36da2399fe41c36)
- Modification to modal to account for changes in transition rewrite [`cdacbab`](https://github.com/fomantic/Fomantic-UI/commit/cdacbab2046d14bee8ecf4aabf43416d618544cb)
- Modification to popup to account for changes in transition rewrite [`6f4f52c`](https://github.com/fomantic/Fomantic-UI/commit/6f4f52c852603e7df6302fd6788b846ab667cbbd)
- Modifications to grid, addition of new container class. Variable fixes [`a18186b`](https://github.com/fomantic/Fomantic-UI/commit/a18186b57c38458bd0cdfcc5ada7eb09766bd415)
- Modified documentation. [`eadb752`](https://github.com/fomantic/Fomantic-UI/commit/eadb752105826bb9310ea31f86b35ba31b4345b6)
- Modifies attached header styles to be neutral, block header is now flat. Border used instead of box shadow due to issues with 1px box shadows looking like crap [`a623e44`](https://github.com/fomantic/Fomantic-UI/commit/a623e4411c1ff958610e7b9da2d84ef55ecd4ec9)
- Modifies basic colored style to be neutral before hover [`f9ecd26`](https://github.com/fomantic/Fomantic-UI/commit/f9ecd260c4c3bfbd8de6fb2722df65f581652dde)
- Modifies structure of package include [`7d4fdbe`](https://github.com/fomantic/Fomantic-UI/commit/7d4fdbe66384449a8952351d3654d43f9762c75b)
- Modifies transition repaint event [`e50a261`](https://github.com/fomantic/Fomantic-UI/commit/e50a2614289b71dc384fbaa30feb3b703c66b738)
- Modifies watch tasks, fixes paths in grunt [`12f9a03`](https://github.com/fomantic/Fomantic-UI/commit/12f9a039a7d5f1e0834736e25da11ab4443eb075)
- Modify advertisement to be called 'ad' [`8775ba8`](https://github.com/fomantic/Fomantic-UI/commit/8775ba8a6ad4b4213c237eabb30f75bd5731e02f)
- Modify default button theme to be flat, add old theme as 'classic', fix centered popup offset, modify example styles [`23509d6`](https://github.com/fomantic/Fomantic-UI/commit/23509d650fa9a92bf51a6f04dee314e4b0ddaedf)
- Modify distance for bounce to max at 1440P [`d705787`](https://github.com/fomantic/Fomantic-UI/commit/d705787ad2bf9d4e0c6f33b0f7a8ac54dd5c76ad)
- Modify fade up/down to be % based [`7a314d1`](https://github.com/fomantic/Fomantic-UI/commit/7a314d197c986a5bc73315dc3e8d7682ad7f5d4f)
- Modify header defaults, some docs [`0856ae0`](https://github.com/fomantic/Fomantic-UI/commit/0856ae052df333a7365ac90a49ad8766918dea5b)
- Modify multi-select dropdown behavior [`5f393f6`](https://github.com/fomantic/Fomantic-UI/commit/5f393f6c33a5365b927eba415bebc6071f871541)
- Modify page bg default [`73a5578`](https://github.com/fomantic/Fomantic-UI/commit/73a5578cfdf81339f6053ffd38d93dc39009facd)
- Modify some ui descriptions, fix container max-height and spacing [`fc75c80`](https://github.com/fomantic/Fomantic-UI/commit/fc75c809bba75fcc975d468a23559d853827f66a)
- Modify transition hidden to force display none [`e3b0a9f`](https://github.com/fomantic/Fomantic-UI/commit/e3b0a9f06da1e78294562aad81a491cd2ca5bd30)
- Modify use of $.proxy in checkbox [`74f3eeb`](https://github.com/fomantic/Fomantic-UI/commit/74f3eebd571242cb3af57999f0f3218973ec2937)
- Modify use of $.proxy in sticky [`d5a32a0`](https://github.com/fomantic/Fomantic-UI/commit/d5a32a01915840ab00b9f30a1bd04e948023e11a)
- More accurate arrow positioning in tooltips [`dfc0cff`](https://github.com/fomantic/Fomantic-UI/commit/dfc0cff5f90135fb97487f034a08dfe67c48429d)
- More debug [`0a23437`](https://github.com/fomantic/Fomantic-UI/commit/0a23437d75889263f273b87c14c4e78051bfc83a)
- More deps [`f80938e`](https://github.com/fomantic/Fomantic-UI/commit/f80938ef5b05cf0e176a8fc4442c3274b03c8f35)
- More examples, and more themes [`a810d65`](https://github.com/fomantic/Fomantic-UI/commit/a810d654840091e5583fe4dcf1216833f8722717)
- More fixes for [`#1173`](https://github.com/fomantic/Fomantic-UI/issues/1173)  [`56dd55f`](https://github.com/fomantic/Fomantic-UI/commit/56dd55fe08e8e1949083a07289e0ada5affc510c)
- More intelligent handling of multiple attached segments [`c52c4ee`](https://github.com/fomantic/Fomantic-UI/commit/c52c4ee4e745112f9a0334d8f956c30a11e33030)
- More name consolidation [`#2101`](https://github.com/fomantic/Fomantic-UI/issues/2101)  [`588d785`](https://github.com/fomantic/Fomantic-UI/commit/588d785edf4bcb61fe4e57c952cb60ab2e3287a7)
- More obvious name for merge copy [`#2101`](https://github.com/fomantic/Fomantic-UI/issues/2101)  [`77923da`](https://github.com/fomantic/Fomantic-UI/commit/77923dad447891a3d192a37f1fdefd9e69971060)
- More order. More. [`3ffbd81`](https://github.com/fomantic/Fomantic-UI/commit/3ffbd8193a27542d89828bd253b677e1bc828f36)
- More things to install [`c40c881`](https://github.com/fomantic/Fomantic-UI/commit/c40c881040cd0019415062db0c9f65840ce79304)
- More typos in install [`29a1062`](https://github.com/fomantic/Fomantic-UI/commit/29a10624937493e230f110ebc0d302fe20f5853e)
- Move accordion settings around [`9726dd0`](https://github.com/fomantic/Fomantic-UI/commit/9726dd0523dd60896110d516ec22a4adcdf89379)
- Move all callbacks to native js for slight performance increase [`d971ac6`](https://github.com/fomantic/Fomantic-UI/commit/d971ac6dc51b85cc3b4014eee6039ef402a85807)
- Move animating back to original position [`196197b`](https://github.com/fomantic/Fomantic-UI/commit/196197b736d55105315c501f0b6ea2c28841aa49)
- Move around some icons in docs [`3a7f115`](https://github.com/fomantic/Fomantic-UI/commit/3a7f115f1073a543cc4e4350f58e7943f21c68db)
- Move checkbox setup into method [`651c65a`](https://github.com/fomantic/Fomantic-UI/commit/651c65a025b6b3c5d2779411d8624b0873c39e34)
- Move code to source file [`36ba0fe`](https://github.com/fomantic/Fomantic-UI/commit/36ba0fe8a545e02600e157c17ccb043e46710338)
- Move column counts to global config, tweak default unselected colors [`d4c4d60`](https://github.com/fomantic/Fomantic-UI/commit/d4c4d6081bd60acc419149383ad83b70f0f8ba95)
- Move contents back to src [`cf2673e`](https://github.com/fomantic/Fomantic-UI/commit/cf2673ebf66a329a199088a390c0bfd163134e34)
- Move docs tasks [`2ac6d5f`](https://github.com/fomantic/Fomantic-UI/commit/2ac6d5fc6b95921f25fd087c25cd90334babf3fd)
- Move file permission to a setting [`#1574`](https://github.com/fomantic/Fomantic-UI/issues/1574)  [`347a791`](https://github.com/fomantic/Fomantic-UI/commit/347a79104740912f3122b537fb5f83dd910f7994)
- Move gulp walk over to admin task [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607)  [`c6371cc`](https://github.com/fomantic/Fomantic-UI/commit/c6371cc8d2942034a0712e8fb2d7cefb2ddc9bee)
- Move out theme loader from theme.config, use separate include [`99c80e3`](https://github.com/fomantic/Fomantic-UI/commit/99c80e3ca1b964f1cbbf3639f92c65f05fd9213d)
- Move reset variables to overrides to provide support for multiple reset styles [`760b216`](https://github.com/fomantic/Fomantic-UI/commit/760b2165d50bf9074060a83f2df3d99da8628dd0)
- Move section specific css into separate files [`8f7e0a9`](https://github.com/fomantic/Fomantic-UI/commit/8f7e0a9a1948d192b042e02b90ae42e34447365e)
- Move some variables over to bordercolor [`672413d`](https://github.com/fomantic/Fomantic-UI/commit/672413dfa24b6eb7069449e24d6e072a49cb3e37)
- Move tasks config to somewhere easier to find [`4470d05`](https://github.com/fomantic/Fomantic-UI/commit/4470d050001a6e840b7df6c9ba2e9bf759827dcb)
- Moves all regexp to a separate settings object [`f552fdb`](https://github.com/fomantic/Fomantic-UI/commit/f552fdb90fd8aaeb986c289657a9145e897ce4e6)
- Moves dimmer to use request animation frame instead of debouncing [`577681a`](https://github.com/fomantic/Fomantic-UI/commit/577681a924f9030e2c4d10f4a44f5d2efa8d1024)
- Moves forced repaint event only to dropdown [`06edf0d`](https://github.com/fomantic/Fomantic-UI/commit/06edf0dd82b52f494033a84c7ec5061a3136003e)
- Moves grouped steps to top of step docs [`7c30b76`](https://github.com/fomantic/Fomantic-UI/commit/7c30b765b6968b58fa10fe101427b82a875c9431)
- Moves gruntfile to top of project, adds testing to package.js for travis [`2f279aa`](https://github.com/fomantic/Fomantic-UI/commit/2f279aa589c4fd2ddcb89faecd521f2a05ce834b)
- Moves label coupling to label.less [`8f19744`](https://github.com/fomantic/Fomantic-UI/commit/8f19744afa9f4a053b809095e1ba398c23eb49e9)
- Moves some important logic from toggle to show in popup, so it can be called programmatically [`609b540`](https://github.com/fomantic/Fomantic-UI/commit/609b540117301209189b34f266c42bb91ac1e534)
- Moves test runner into grunt task for travis [`60fcad3`](https://github.com/fomantic/Fomantic-UI/commit/60fcad33ca0584ca2ffff160881776e911578f59)
- Moving around [`a80c154`](https://github.com/fomantic/Fomantic-UI/commit/a80c154fcf8bbc9fbaed89a9e3d3426ace04cdfe)
- Moving grunt tasks to package.json so compatible with npm test [`d3de0a8`](https://github.com/fomantic/Fomantic-UI/commit/d3de0a85deebaf4bae2fddaf55d2f70fae907d74)
- Moving more values to config [`ac8d0bc`](https://github.com/fomantic/Fomantic-UI/commit/ac8d0bc00bdc5bccb5a5590f503416d60b98251e)
- Moving whole grid to flex [`28b3a25`](https://github.com/fomantic/Fomantic-UI/commit/28b3a253e84cc839906669fc4af0afcd85f8a3dd)
- Multiple select dropdown now uses a sizer element to determine current text width, instead of estimating based on character count [`664a9d9`](https://github.com/fomantic/Fomantic-UI/commit/664a9d9032aa199b541a6829a0948c3370782899)
- NPM Update should only update default theme folder (not whole theme path) [`#2101`](https://github.com/fomantic/Fomantic-UI/issues/2101)  [`3d2fec4`](https://github.com/fomantic/Fomantic-UI/commit/3d2fec4461cb2f8f62ea80c0013dbd51808f92a6)
- Near complete rewrite of popup [`2928c95`](https://github.com/fomantic/Fomantic-UI/commit/2928c95f785dfd5354438152441e0af439e455a3)
- Near complete with theming structure [`19e1e81`](https://github.com/fomantic/Fomantic-UI/commit/19e1e817625965996af1c34f03d6db2a4886b20b)
- Nearingly done [`28051f2`](https://github.com/fomantic/Fomantic-UI/commit/28051f212a4688b3578379c9ef814d4ab7a4bf0a)
- Nearly done here [`ac50bec`](https://github.com/fomantic/Fomantic-UI/commit/ac50bec3eca93ce76a5819df49d2bdc67250b784)
- Needless formatting of gulpfile [`211bc4f`](https://github.com/fomantic/Fomantic-UI/commit/211bc4f44eba81f81802e8db932800271ef3deec)
- New additions to ratings, automatic generation of html from template [`d26aaab`](https://github.com/fomantic/Fomantic-UI/commit/d26aaabba6bd62f01a22359b9e1e668f8f33f29a)
- New examples [`df06ea3`](https://github.com/fomantic/Fomantic-UI/commit/df06ea37f4054c2c3cdff3962e70f10ecbc2224f)
- New homepage [`876d30e`](https://github.com/fomantic/Fomantic-UI/commit/876d30ecf2b4a84a1f9598a6739cb54bbc3a4f11)
- New input stylings and other things [`a7aafe4`](https://github.com/fomantic/Fomantic-UI/commit/a7aafe47657d8544fa2535c79cc9debdcd1d58f0)
- No event from watch [`14739ed`](https://github.com/fomantic/Fomantic-UI/commit/14739edbcdf5ca9bf9480cb1a5f5dc1c2902b875)
- No font-size on accordion [`c7f61ef`](https://github.com/fomantic/Fomantic-UI/commit/c7f61efd461cab8b86c67802259c2432426b4a96)
- No longer translate anchors [`be67a87`](https://github.com/fomantic/Fomantic-UI/commit/be67a8728ce64b949a4af893194521e3fd28930b)
- No really final positioning for loading dropdown [`8755da7`](https://github.com/fomantic/Fomantic-UI/commit/8755da70cfda8d64c41de38e7a3d31096913d03b)
- Non queued animations trigger complete event immediately [`a957a5c`](https://github.com/fomantic/Fomantic-UI/commit/a957a5cfde8fb587e69f21605f8022a005580a2d)
- Normalize paths for *nix [`#1264`](https://github.com/fomantic/Fomantic-UI/issues/1264) in gulpfile [`d44d41e`](https://github.com/fomantic/Fomantic-UI/commit/d44d41e822fd0018584c5a3bcdadd388c7751fcd)
- Note that docpad run depends on grunt build [`76854d5`](https://github.com/fomantic/Fomantic-UI/commit/76854d562ab29f2df90eadd2f4803590ac8f2578)
- Notes [`f205f4d`](https://github.com/fomantic/Fomantic-UI/commit/f205f4df4931b1d77b698c8caac9884e68377e8b)
- Notice on form validation [`cd63ad8`](https://github.com/fomantic/Fomantic-UI/commit/cd63ad891ddb1afa167b0cb86591dfdf25efcd28)
- Now cards can use colors too! [`075efb5`](https://github.com/fomantic/Fomantic-UI/commit/075efb506bbec2ef7dd5d387537e01170f0f3407)
- Observe changes now groups related mutations [`35de853`](https://github.com/fomantic/Fomantic-UI/commit/35de853327ba7d81cb5f14b4af2b6beaeaa1a399)
- Octicons rls [`e160b46`](https://github.com/fomantic/Fomantic-UI/commit/e160b46be7c15d096c78bffefd9b50229bea77da)
- Odds and end fixes for dropdown [`dcf0190`](https://github.com/fomantic/Fomantic-UI/commit/dcf0190a3f503f4a791657e1587c542c0b5d15e4)
- Ok now really [`85a69ae`](https://github.com/fomantic/Fomantic-UI/commit/85a69aeafb076b738356d9aeb39ed84ad7e14654)
- One last fix 1.12.0 [`ca030eb`](https://github.com/fomantic/Fomantic-UI/commit/ca030ebb332ab9249a9eafc2d158e49f48c294dc)
- Only call transition reset on modal dimmer hide when module available [`c036282`](https://github.com/fomantic/Fomantic-UI/commit/c036282550e1f3e463caef6126eafa589925f5e1)
- Only reposition the current menu element [`06aaeb0`](https://github.com/fomantic/Fomantic-UI/commit/06aaeb007a81553539def3dcae4ce6b4d8d8456a)
- Only require scrollTo(0,0) for iOS fix, fix margin on stackable divider [`e225d36`](https://github.com/fomantic/Fomantic-UI/commit/e225d36aed3cf1afa5cf010980079cf04e8295bb)
- Only set scroll position on selection dropdown, unnecessary tabindex [`4b07a2b`](https://github.com/fomantic/Fomantic-UI/commit/4b07a2bfb46cbfba4b83ace38632b9b876fd77df)
- Oops old dep [`6332f70`](https://github.com/fomantic/Fomantic-UI/commit/6332f70cbc1d66078a2f3944300be41de8710433)
- Optimizations to visibility [`c58553c`](https://github.com/fomantic/Fomantic-UI/commit/c58553cdce4a391fbe5461c32f6331c783e3772a)
- Optimizes modal dimmer init for performance [`1d9e140`](https://github.com/fomantic/Fomantic-UI/commit/1d9e14063c7fc294faa5b30e5174bb08a5aa8266)
- Optimizes modal display for mobile [`2f98471`](https://github.com/fomantic/Fomantic-UI/commit/2f984712cba926d14843f098669c14a208cd03e6)
- Ordered list does not invert number color. [`6addaf7`](https://github.com/fomantic/Fomantic-UI/commit/6addaf716033c6a6e97b7716b698464159f68681)
- Organize comments in gulpfile [`09a6e75`](https://github.com/fomantic/Fomantic-UI/commit/09a6e759b89a674053333d1eab302ef8820d7688)
- Organizing some settings objects [`ef0945f`](https://github.com/fomantic/Fomantic-UI/commit/ef0945fe4e1b1d1d04c786a140910f3808bd1d35)
- Package 1.10.0 [`373578a`](https://github.com/fomantic/Fomantic-UI/commit/373578a3eba519a8b3fec29c46def27bf66ba229)
- Package 1.7.2 [`7b8d7fa`](https://github.com/fomantic/Fomantic-UI/commit/7b8d7fa02780d14bff4844d9a617605adf5c8db1)
- Package 2.0.1 [`9362682`](https://github.com/fomantic/Fomantic-UI/commit/9362682f5ef07186ab87c6b1020b73b8bc9f6964)
- Package 2.1.7 [`74fea12`](https://github.com/fomantic/Fomantic-UI/commit/74fea12e1fd548cb870872ba5ed59f5acdcc57ba)
- Package lockfile [`dcadce0`](https://github.com/fomantic/Fomantic-UI/commit/dcadce079272bd069b7aab5b83e375a9dccc65f6)
- Padded grid no longer needs special rules for stackable [`#1495`](https://github.com/fomantic/Fomantic-UI/issues/1495)  [`cbe1fa0`](https://github.com/fomantic/Fomantic-UI/commit/cbe1fa0ab2be4328b1b22c64afe5a247ba95d59b)
- Partial fix for [`#1190`](https://github.com/fomantic/Fomantic-UI/issues/1190)  search selection in menu [`dbf67c1`](https://github.com/fomantic/Fomantic-UI/commit/dbf67c1e4024131b9eb4b2daee17fbd1f67f755c)
- Partial rewrite animation [`149b784`](https://github.com/fomantic/Fomantic-UI/commit/149b7844040514548475332a64e99f6f7b1591c0)
- Partially converted menu variables [`95b8802`](https://github.com/fomantic/Fomantic-UI/commit/95b88026e510c76ad2b0bf43efca2bfd3afb8502)
- Path fixes, rtl fixes [`1e0a71d`](https://github.com/fomantic/Fomantic-UI/commit/1e0a71d9e4c96aa0b65300a3f08b9314346c945a)
- Pin dev versions in package.json [`#1275`](https://github.com/fomantic/Fomantic-UI/issues/1275)  [`82ea119`](https://github.com/fomantic/Fomantic-UI/commit/82ea119a583693a8a483a4e7baa8d16be4078933)
- Popup displays module on error [`7eb0302`](https://github.com/fomantic/Fomantic-UI/commit/7eb0302dba6d49e4b63197cb412186c7b1f1fe97)
- Popup no longer uses backup transitions [`1a52cfe`](https://github.com/fomantic/Fomantic-UI/commit/1a52cfe0c19710363e9350c4947eb5e11ce00fce)
- Popup not exclusive by default [`70a79aa`](https://github.com/fomantic/Fomantic-UI/commit/70a79aacb38cc274cb6b36a4fb492e433c730219)
- Popup now doesnt queue animations, [`#1062`](https://github.com/fomantic/Fomantic-UI/issues/1062)  [`3d50353`](https://github.com/fomantic/Fomantic-UI/commit/3d503536afc814e700a6a0e03ae7d6b02252bc25)
- Popup now transitions on hide all [`fe83dad`](https://github.com/fomantic/Fomantic-UI/commit/fe83dad22e40fb17568351a8cd1fc93ec140be9c)
- Popup will not appear on hidden elements [`d0b4512`](https://github.com/fomantic/Fomantic-UI/commit/d0b451290b49e3691bc0df372444debea4c1cea3)
- Popup z-index going way up #1668. Add z-index variable for modal [`671948c`](https://github.com/fomantic/Fomantic-UI/commit/671948c25287ea3e0d135ee4a8eccd38193e81ee)
- Popup, fix transform origin order [`becbb7e`](https://github.com/fomantic/Fomantic-UI/commit/becbb7ef814b74bd18c10e8b44747069a827db37)
- Popup- Add ability for onShow and onHide to cancel popup show/hide [`c1cc319`](https://github.com/fomantic/Fomantic-UI/commit/c1cc319b07d1c72991c7d863bea359141341a1b2)
- Popup/dropdown now add debug settings to transition [`bb7ec25`](https://github.com/fomantic/Fomantic-UI/commit/bb7ec259dd687f8e7e911df14479780c7c46dcef)
- Popups now have default sizing [`84c7449`](https://github.com/fomantic/Fomantic-UI/commit/84c744989aa002ab24f4ca950a7bad3bb54cea41)
- Porting over $.proxy to native call for performance [`ba6d251`](https://github.com/fomantic/Fomantic-UI/commit/ba6d2514107ac460222580e8ae6f5d2fb9ae02c1)
- Ports sticky/visiblity from 2.x early xmas [`#2127`](https://github.com/fomantic/Fomantic-UI/issues/2127)  [`cd54328`](https://github.com/fomantic/Fomantic-UI/commit/cd54328cb9d919e311bfc5e04aa014b93204523b)
- Position "or" vertical aligned. [`c93e5c2`](https://github.com/fomantic/Fomantic-UI/commit/c93e5c2088fa1eafcd04d576c41971a4b557c9f7)
- Possible solve [`#1899`](https://github.com/fomantic/Fomantic-UI/issues/1899) Issues with blank string results evaluating as undefined when minCharacters = 0, issue with saved results not being retrieved when response pulled from cache [`2ed793a`](https://github.com/fomantic/Fomantic-UI/commit/2ed793a351476d569ab1b036f3e97c7f33dbee34)
- Preserve new lines from original src [`702052e`](https://github.com/fomantic/Fomantic-UI/commit/702052e254f709b5627bf98ec5fc4e512a542ec1)
- Prevent grey from turning red in saturate [`2015dae`](https://github.com/fomantic/Fomantic-UI/commit/2015dae9f64e0508e9a255d2c4ec759fde13463d)
- Prevent looping for values in multiple if no values set [`fcd8f69`](https://github.com/fomantic/Fomantic-UI/commit/fcd8f6910802250064640d61a22c45b7e8cfe5dc)
- Prevent menu button color inheritance. [`dd45a3c`](https://github.com/fomantic/Fomantic-UI/commit/dd45a3c724485de422fe600155dea7f08be10db9)
- Prevent sticky from calling .offsetParent() on every method call by finding container only in init [`923e3d4`](https://github.com/fomantic/Fomantic-UI/commit/923e3d40cf0318df2402cec0494ec3e944c31725)
- Probably better var name [`#2139`](https://github.com/fomantic/Fomantic-UI/issues/2139)  [`c480422`](https://github.com/fomantic/Fomantic-UI/commit/c4804220aaf714908f3dc379b0fd85332268cc8e)
- Proceed with questions for site variables [`3d3a3fb`](https://github.com/fomantic/Fomantic-UI/commit/3d3a3fbfde31fbcdb2a984814dee85b5914aa628)
- Progress bar now animates correctly when no width set [`44269aa`](https://github.com/fomantic/Fomantic-UI/commit/44269aae43047b21db97472fc69603d6c773814f)
- Proper rewrite of progress to support rapid updates [`95e2172`](https://github.com/fomantic/Fomantic-UI/commit/95e2172a5fe48df64c752783904416aafa7ba66b)
- Properly parse RTL question [`74eccd8`](https://github.com/fomantic/Fomantic-UI/commit/74eccd86fa8a02357d72cc0466b43dbefbc7e2ea)
- Prune [`#2944`](https://github.com/fomantic/Fomantic-UI/issues/2944)  [`0fece6a`](https://github.com/fomantic/Fomantic-UI/commit/0fece6a4c96ad94af9f52ee3e3ed9825b6648581)
- Pub/sub visibility? [`b90f8f7`](https://github.com/fomantic/Fomantic-UI/commit/b90f8f7b8d48de19aca382f3fb8c4b5aa3552a57)
- Publish tasks fail with latest git due to add syntax [`5ce21df`](https://github.com/fomantic/Fomantic-UI/commit/5ce21df071615368768235b7b4264b6dfdcf1fb7)
- Quick patch [`84acf04`](https://github.com/fomantic/Fomantic-UI/commit/84acf041640f603f0e0884d5320a42ee35511ced)
- RLSNOTES [`#2012`](https://github.com/fomantic/Fomantic-UI/issues/2012)  [`6675886`](https://github.com/fomantic/Fomantic-UI/commit/66758868b951bcb3e2443c28efed3d8fb3fd8b8b)
- RLSNOTES [`#2017`](https://github.com/fomantic/Fomantic-UI/issues/2017)  [`731e44d`](https://github.com/fomantic/Fomantic-UI/commit/731e44dd2b3124ceff24193bc0737f33067da6a1)
- RLSNOTES [`#2214`](https://github.com/fomantic/Fomantic-UI/issues/2214)  [`a7482f9`](https://github.com/fomantic/Fomantic-UI/commit/a7482f9c70d7211cb6449bfa2e3addc6225efa5f)
- RLSNOTES [`#2266`](https://github.com/fomantic/Fomantic-UI/issues/2266)  [`2ca57cd`](https://github.com/fomantic/Fomantic-UI/commit/2ca57cd2920e9a3054328dbc74470167337fcae8)
- RLSNOTES [`cf19a3e`](https://github.com/fomantic/Fomantic-UI/commit/cf19a3e77162f728683f5c2a85c9716f05d9887a)
- RLSNotes [`#2222`](https://github.com/fomantic/Fomantic-UI/issues/2222)  [`9f07ceb`](https://github.com/fomantic/Fomantic-UI/commit/9f07ceb8bcbe232d4f000857c92fb409ac4a311e)
- RLSNotes [`b3d5bbb`](https://github.com/fomantic/Fomantic-UI/commit/b3d5bbbcdb1aee3111ef0a121572fe873f87103d)
- RLSnotes [`#2534`](https://github.com/fomantic/Fomantic-UI/issues/2534)  [`1b87763`](https://github.com/fomantic/Fomantic-UI/commit/1b87763a747e409e86591e6d8c4eeeb2aa4c0b8b)
- RLSnotes [`f395784`](https://github.com/fomantic/Fomantic-UI/commit/f39578424af8197605f29016257b606283a443c3)
- RLsnotes [`19bf6da`](https://github.com/fomantic/Fomantic-UI/commit/19bf6da7072c34d5f4c6bff8eab1e1778f0974b8)
- RTL Gulp Task [`b1d29ef`](https://github.com/fomantic/Fomantic-UI/commit/b1d29ef1bcac282a8e9742494ab84a54b5467d75)
- RTL support for popup/sidebar [`cd13127`](https://github.com/fomantic/Fomantic-UI/commit/cd13127ccbd19eedb67a62b16ff90ecf3b7df0b6)
- Radio fix + Form serialize function [`d5ad7df`](https://github.com/fomantic/Fomantic-UI/commit/d5ad7dfa16e179c0e67a59af84538daee0c24a41)
- Rail is 100% height by default [`2c45285`](https://github.com/fomantic/Fomantic-UI/commit/2c45285ff57fed06fd74ca3bd601deefc0e3fe03)
- Rail should inherit @medium [`f46fd54`](https://github.com/fomantic/Fomantic-UI/commit/f46fd548f102a7577032687f1ca3d44b4f1f863c)
- Rating stars should not break to a new line [`33463b6`](https://github.com/fomantic/Fomantic-UI/commit/33463b6ddadae0f0da4643ac53f153917c38d793)
- Re-enable normal debug for search [`1b341b2`](https://github.com/fomantic/Fomantic-UI/commit/1b341b2e99fdcdbb3eaee0c25a573bece2d80c94)
- Re-order rules in form [`a5a7326`](https://github.com/fomantic/Fomantic-UI/commit/a5a7326c0808479f108dcbbe905ea663a374b4ae)
- Readme [`da494f8`](https://github.com/fomantic/Fomantic-UI/commit/da494f85c45cb2f8ecef55c339643829536aac41)
- Readme adjustments [`9a413cc`](https://github.com/fomantic/Fomantic-UI/commit/9a413cc136d5e1c2f75104f68b53d13c425a7cb8)
- Readme header consistency [`49c488b`](https://github.com/fomantic/Fomantic-UI/commit/49c488b95325705163621d58a27a7efcdbe103b1)
- Readme update [`1173fbb`](https://github.com/fomantic/Fomantic-UI/commit/1173fbb78b5d7ddf696e42da2151b3fd9931b04d)
- Real 0.9.5, adds circular segment variation [`391e90b`](https://github.com/fomantic/Fomantic-UI/commit/391e90ba8cf1bcffe47a1b2720a8b41a6717ed34)
- Real 2.2.11 build [`4c0c5ca`](https://github.com/fomantic/Fomantic-UI/commit/4c0c5caaec4353777bcb01c30d0447a73d3854a8)
- Recompile for build [`c7e88c2`](https://github.com/fomantic/Fomantic-UI/commit/c7e88c22252f55f817b5491538f86d441a9d1c6d)
- Redo icon font for indeterminate state, begin  js modifications [`5ddc887`](https://github.com/fomantic/Fomantic-UI/commit/5ddc8875c6ab10d907138a120c7bc1bae3347fed)
- Redo inverted colored menu styles [`fa099bd`](https://github.com/fomantic/Fomantic-UI/commit/fa099bd29e0ad14b8ac66e38fd787dc164e638b1)
- Redo pointing label to use transform to avoid line-height issues [`44f1adb`](https://github.com/fomantic/Fomantic-UI/commit/44f1adb0a77fcd680ed8eabacfed93c488de394d)
- Redo stackable grid divider to use table cell [`#2311`](https://github.com/fomantic/Fomantic-UI/issues/2311)  [`b7ccfa7`](https://github.com/fomantic/Fomantic-UI/commit/b7ccfa75f43b74344b7654256778a8115e76ba43)
- Redo ui loader to use css only [`9e5816b`](https://github.com/fomantic/Fomantic-UI/commit/9e5816bd73a0ef0b77fd0d4b884bdee176fde394)
- Redoes icon docs, adds internal grid example, adds social circular icon example [`e28814b`](https://github.com/fomantic/Fomantic-UI/commit/e28814b1276a070e4e280624bc8d06e2a36bc2e6)
- Redoes ui definition table as a type, adds much better formatting. Removes classic styles from table and ports to theme [`e8950b6`](https://github.com/fomantic/Fomantic-UI/commit/e8950b6c24b762a9d7060c39abc7385134a9ca2c)
- Reduce delay for popup show [`4b8b699`](https://github.com/fomantic/Fomantic-UI/commit/4b8b699375e1b28a7799be81b745c11a43db914f)
- Reduce large icon size and add big size [`cca1223`](https://github.com/fomantic/Fomantic-UI/commit/cca12232cc8edde8e6b7f72026b65aea2e46337f)
- Reduce secondary menu item horizontal padding [`a09ef01`](https://github.com/fomantic/Fomantic-UI/commit/a09ef0179c23908eca821e6336062b71f026528e)
- Reduce selected border color [`201e4b7`](https://github.com/fomantic/Fomantic-UI/commit/201e4b72fab94a52622054de9ab8bbd8d62b7cb0)
- Reduce transition duration to increase responsiveness [`752e9b0`](https://github.com/fomantic/Fomantic-UI/commit/752e9b08215a9ee38f265d6bcd6a8bc2fd2081c3)
- Reduces black to slightly more neutral [`f7f9f76`](https://github.com/fomantic/Fomantic-UI/commit/f7f9f7649bd4b97c1d9e723fcb1215eac306b975)
- Reduces the size of labeled icon buttons [`a96fac2`](https://github.com/fomantic/Fomantic-UI/commit/a96fac2e47d861b2b4e009ec4563320f1e2532d8)
- Reducing selection dropdown shadow [`732f9cc`](https://github.com/fomantic/Fomantic-UI/commit/732f9cc1e8da96e1860caedaf225077903e159ef)
- Refactor conditional [`85c7553`](https://github.com/fomantic/Fomantic-UI/commit/85c75534b9733c28a5ec732450f2c86f33c6797b)
- Refactoring config [`6943bfa`](https://github.com/fomantic/Fomantic-UI/commit/6943bfac53204bd8752913f2960004e01d66d71a)
- Refactors dimmer, adds 3d animation by default [`5f4522c`](https://github.com/fomantic/Fomantic-UI/commit/5f4522c182e98e31df1ae8276bdbe6c013244c7a)
- Refactors modal plugin, modals now have icons auto formatted. Removes selector count from popup [`df0777b`](https://github.com/fomantic/Fomantic-UI/commit/df0777b0daca01e154f4bf3c3a96cb4bf8a8bbae)
- Refix the transition fix, bobo mistake [`f123839`](https://github.com/fomantic/Fomantic-UI/commit/f1238398c07ec0321acba3fc3d4436644a2a7465)
- Regen package-lock [`5d4260e`](https://github.com/fomantic/Fomantic-UI/commit/5d4260eddc209ee2e10bb7888f509923cf2e2a1f)
- Related [`#1840`](https://github.com/fomantic/Fomantic-UI/issues/1840)  force removing duplicate slashes from path when auto: true [`32e32d3`](https://github.com/fomantic/Fomantic-UI/commit/32e32d3934d8aa0a77eaf35ce6ba0e48b8fc5d1d)
- Related [`#2014`](https://github.com/fomantic/Fomantic-UI/issues/2014)  separate css and javascript into separate tasks [`2457ca6`](https://github.com/fomantic/Fomantic-UI/commit/2457ca65ad657646b9828d318e841d9b2a7f9c10)
- Related [`#2605`](https://github.com/fomantic/Fomantic-UI/issues/2605)  sticky no longer uses bottomPadding for determining bottom edge of context. This is counterintuitive and in most cases wrong [`253bdc5`](https://github.com/fomantic/Fomantic-UI/commit/253bdc5c53aae3132715c103abc2a48461b11eae)
- Related [`#2713`](https://github.com/fomantic/Fomantic-UI/issues/2713) add XHR to all callbacks [`44bf836`](https://github.com/fomantic/Fomantic-UI/commit/44bf836651761e0e7c993df922f081bb2afba981)
- Relocate and better specify rule for step when only child [`8732d53`](https://github.com/fomantic/Fomantic-UI/commit/8732d53b583c06a7b0b7de88cc509611c6e90f60)
- Remote unused method [`#2260`](https://github.com/fomantic/Fomantic-UI/issues/2260)  [`1cddeba`](https://github.com/fomantic/Fomantic-UI/commit/1cddebabd49f31d279f9798fe6c3b9372b02ea2d)
- Removal observer always should use document to teardown [`250a465`](https://github.com/fomantic/Fomantic-UI/commit/250a465263232d89ac540bf3e68b62196ee5e5ae)
- Remove $.proxy calls from popup [`122a0e7`](https://github.com/fomantic/Fomantic-UI/commit/122a0e768444f784e3047fb00e15cc37b1a06c09)
- Remove $.proxy calls from visibility and accordion [`be617da`](https://github.com/fomantic/Fomantic-UI/commit/be617dacd352bf9b27ec44492b0e5f9c88de8b5f)
- Remove $.proxy from shape [`7ba4d5f`](https://github.com/fomantic/Fomantic-UI/commit/7ba4d5fb9be08f5c4af093b946af47c482aee43d)
- Remove 0% height from non simple dimmers [`9f48211`](https://github.com/fomantic/Fomantic-UI/commit/9f482118143a44d9d599fd26009f591d7509a270)
- Remove PM check from update scripts [`e51d09d`](https://github.com/fomantic/Fomantic-UI/commit/e51d09df109b71d3771ecfcb58a26521663f9f91)
- Remove RTL debug [`41b0c8b`](https://github.com/fomantic/Fomantic-UI/commit/41b0c8b093b278f4d4edb9fc4725f378b16f3e8a)
- Remove admin tasks from npm gulpfile [`7d80a0e`](https://github.com/fomantic/Fomantic-UI/commit/7d80a0ea99bef8e3e84728e53c957d0ef95931b1)
- Remove api doc draft, fix formatting [`d073c36`](https://github.com/fomantic/Fomantic-UI/commit/d073c368f6c4c94e6cf950577218537f91fd21d3)
- Remove autoprefixr test [`#2074`](https://github.com/fomantic/Fomantic-UI/issues/2074)  [`0aa0abd`](https://github.com/fomantic/Fomantic-UI/commit/0aa0abd78eaba94be61d25d314c98d1c04d94e3b)
- Remove background color from input, causes flash with autocomplete styles [`#2502`](https://github.com/fomantic/Fomantic-UI/issues/2502)  [`c1321e9`](https://github.com/fomantic/Fomantic-UI/commit/c1321e93652a05116c8db448b2c363c84e724059)
- Remove border color animation to avoid transition on responsive sizing [`12540e1`](https://github.com/fomantic/Fomantic-UI/commit/12540e1351878e2bd32e41f0f912bd17eda71645)
- Remove border on fixed menu [`60e6d35`](https://github.com/fomantic/Fomantic-UI/commit/60e6d35d5e20991acd7c636cfbea72ccc245d980)
- Remove borked copy and paste job [`2a43f4a`](https://github.com/fomantic/Fomantic-UI/commit/2a43f4a96a07d9aab1810c901c5cbdaf08556114)
- Remove cleanup from NPM install [`e7e867d`](https://github.com/fomantic/Fomantic-UI/commit/e7e867df7b42425b3a630bbccf24f97f175a2b7a)
- Remove clearfix from segment [`621fbf0`](https://github.com/fomantic/Fomantic-UI/commit/621fbf0ede373037367a31a6d1e1e14a2c764870)
- Remove closing &lt;/div&gt; element for which no opening elements exists [`90cbd99`](https://github.com/fomantic/Fomantic-UI/commit/90cbd99e50b7c5d73e90563c849fc858dbb0a980)
- Remove colored output from install [`ba38080`](https://github.com/fomantic/Fomantic-UI/commit/ba38080a51cab4f365a6565abeed6c6bf22fbc5c)
- Remove console [`05a2d1b`](https://github.com/fomantic/Fomantic-UI/commit/05a2d1bcdc1d2ba08b1f86a1949d5336fa7eb0d8)
- Remove console log [`#1611`](https://github.com/fomantic/Fomantic-UI/issues/1611)  [`45c0232`](https://github.com/fomantic/Fomantic-UI/commit/45c0232b0691524c2e292eb923639aaa641a0ee2)
- Remove console log [`#3466`](https://github.com/fomantic/Fomantic-UI/issues/3466) #3491 [`4468781`](https://github.com/fomantic/Fomantic-UI/commit/44687819ef55da6e3e43426958afb04acc646728)
- Remove console log [`#3744`](https://github.com/fomantic/Fomantic-UI/issues/3744)  [`43f2174`](https://github.com/fomantic/Fomantic-UI/commit/43f21749eb5147a7255b4ef521886524da1ae94a)
- Remove console log [`32a8344`](https://github.com/fomantic/Fomantic-UI/commit/32a8344288410a1b82974b2304860d8f4e07cbc4)
- Remove console log from modal [`49add36`](https://github.com/fomantic/Fomantic-UI/commit/49add3642aad631661c91b1ea8ac3e36c66a6440)
- Remove console log in transition [`e49aa0f`](https://github.com/fomantic/Fomantic-UI/commit/e49aa0f1373fccbf7d3ad287be2c61461e1ab6a3)
- Remove console log, fix watch task on definition [`f7b7ecf`](https://github.com/fomantic/Fomantic-UI/commit/f7b7ecfb62c1bfb8aa23abe63d7c982d9b5cc598)
- Remove console logs from dropdown, [`#1123`](https://github.com/fomantic/Fomantic-UI/issues/1123)  [`0219c60`](https://github.com/fomantic/Fomantic-UI/commit/0219c609b62952f4941ddc326a4e63f162c2f887)
- Remove console.log [`9528c17`](https://github.com/fomantic/Fomantic-UI/commit/9528c1764f9551ac97a3ad44b662086b53c4fcbe)
- Remove console.log from dropdown [`38b5431`](https://github.com/fomantic/Fomantic-UI/commit/38b5431aa6c8cfad2254184aaffbcc2d017a4984)
- Remove console.log from sticky [`#2107`](https://github.com/fomantic/Fomantic-UI/issues/2107)  [`fae8749`](https://github.com/fomantic/Fomantic-UI/commit/fae8749744cb7ac3fbe7ec572f9cd93d28c194e4)
- Remove console.log from tab [`0fb14e1`](https://github.com/fomantic/Fomantic-UI/commit/0fb14e107211b8ca155220e937f707249d0e340f)
- Remove corner text labels [`7e674a0`](https://github.com/fomantic/Fomantic-UI/commit/7e674a0c1f9cc7f3bdca7ff7b85687660282b542)
- Remove custom image font sizes [`672646b`](https://github.com/fomantic/Fomantic-UI/commit/672646b4505a9e76b85c7d83b2bf2c451dd5a5cd)
- Remove debug [`#1895`](https://github.com/fomantic/Fomantic-UI/issues/1895)  [`8260260`](https://github.com/fomantic/Fomantic-UI/commit/8260260f003275e14e627310a6c0f0a9d96dc130)
- Remove debug [`#2092`](https://github.com/fomantic/Fomantic-UI/issues/2092)  [`d926eaf`](https://github.com/fomantic/Fomantic-UI/commit/d926eaf25f8b3ddb6857b3e39538691f6bcc544e)
- Remove debug [`#2853`](https://github.com/fomantic/Fomantic-UI/issues/2853)  [`e954241`](https://github.com/fomantic/Fomantic-UI/commit/e95424107bb77adc3015668ca80a2fc913c837f7)
- Remove debug [`1440814`](https://github.com/fomantic/Fomantic-UI/commit/1440814609204eccbdc9affec0b2018bfc22d95c)
- Remove debug from transition [`affb406`](https://github.com/fomantic/Fomantic-UI/commit/affb40689e1f10d503d324ac0e23beb1ed6b7e02)
- Remove debug statement from dropdown [`39b375f`](https://github.com/fomantic/Fomantic-UI/commit/39b375f550bc9a695ec6d22ae4db7071cac554f3)
- Remove debugger statement [`c0f6e61`](https://github.com/fomantic/Fomantic-UI/commit/c0f6e6130187f0b0c5b897efc0f5e9ca45d3611d)
- Remove definition button from wrong pages [`dacbfb6`](https://github.com/fomantic/Fomantic-UI/commit/dacbfb61c55e0d2695c8934d8580537df6942a42)
- Remove dependency on ACE editor, redo all code samples, redo code colors [`3024db0`](https://github.com/fomantic/Fomantic-UI/commit/3024db0b737ef62e68e2ba2c6ab7482865a3f9c2)
- Remove detachable from lang selector [`f071900`](https://github.com/fomantic/Fomantic-UI/commit/f071900e163ed85d2f31d55371dee004568bf2c9)
- Remove docs from sui main repo [`02ae601`](https://github.com/fomantic/Fomantic-UI/commit/02ae60187f1354e07e15f2b3f810ccda90fdfcd4)
- Remove duplicate height definition [`31026d4`](https://github.com/fomantic/Fomantic-UI/commit/31026d4b0e9662d4b9ee73903200f4dd4f6d4a24)
- Remove duplicate variable [`82f07d6`](https://github.com/fomantic/Fomantic-UI/commit/82f07d61164fd5b0a19beb705e0fb5113760c845)
- Remove duplice definition file [`5291278`](https://github.com/fomantic/Fomantic-UI/commit/5291278140d377749fe812ec9508401cc1eacf5b)
- Remove empty rules from example [`512c3f5`](https://github.com/fomantic/Fomantic-UI/commit/512c3f578625d70df52044e4eb9baf89a93e0537)
- Remove errant console.log [`66b87c3`](https://github.com/fomantic/Fomantic-UI/commit/66b87c3e4926c5d085e844a0da204333406f4849)
- Remove errant console.log from API [`76f1f2d`](https://github.com/fomantic/Fomantic-UI/commit/76f1f2d024625e010921f12c702181c920d15a13)
- Remove erroneous pagination menu rule [`a2273f7`](https://github.com/fomantic/Fomantic-UI/commit/a2273f716d8f92ad5f73b26948ed3ad33a22f3d8)
- Remove error message for when popup cant find a position, its not really an error [`6576f0d`](https://github.com/fomantic/Fomantic-UI/commit/6576f0d59c4c8d2f40c41026cf4e985b4dc821d9)
- Remove error messages for repeated animations, too verbose [`0fe91e0`](https://github.com/fomantic/Fomantic-UI/commit/0fe91e083a0ed3bf6d37a192bcdc89645d2a6df5)
- Remove error when updating semantic.config during watch [`2478b77`](https://github.com/fomantic/Fomantic-UI/commit/2478b7768c609d60ecd71ca4c20a953ff7e1ff16)
- Remove excess icons, finish homepage tweaks [`0a270a5`](https://github.com/fomantic/Fomantic-UI/commit/0a270a5d55d9be9ff063dab18bec000239c9043d)
- Remove execute permission. [`3830f65`](https://github.com/fomantic/Fomantic-UI/commit/3830f6577d8545bfb5706e2f6aa31607ea4d3aae)
- Remove extra brace [`e1f25a2`](https://github.com/fomantic/Fomantic-UI/commit/e1f25a21d0643141f89cd42933561008cea2e9b4)
- Remove fallback js animations from modal [`6a76302`](https://github.com/fomantic/Fomantic-UI/commit/6a76302ce54d0d080f3ae12f00f64acf18fa8614)
- Remove faulty error conditions from search [`#2066`](https://github.com/fomantic/Fomantic-UI/issues/2066)  [`eacd01b`](https://github.com/fomantic/Fomantic-UI/commit/eacd01bb5a013382b347139dc06d49a2749c5a01)
- Remove form pointers [`3e79081`](https://github.com/fomantic/Fomantic-UI/commit/3e79081e02d42b6778d557f666cca95175f1748e)
- Remove grey buttons forced on disabled buton [`7db0aa3`](https://github.com/fomantic/Fomantic-UI/commit/7db0aa398936259d832d303bca84bcad9b4fc3db)
- Remove hidden checks from label [`4d5908f`](https://github.com/fomantic/Fomantic-UI/commit/4d5908f40dc7508e40f72bdabfaad32fc69f94f4)
- Remove hook [`4d11a1c`](https://github.com/fomantic/Fomantic-UI/commit/4d11a1cca8f27d8f8002dc4d27545b3360fe921c)
- Remove href attribute from div element [`ccaafae`](https://github.com/fomantic/Fomantic-UI/commit/ccaafae32ab816306f1c429d4bc49c364a1c0270)
- Remove indicating label colors [`1652f2c`](https://github.com/fomantic/Fomantic-UI/commit/1652f2c62fedeca7735f3f86e2d42e504a9068bc)
- Remove input blur on selection, breaks tabbing in webkit based browsers [`#1253`](https://github.com/fomantic/Fomantic-UI/issues/1253)  [`af1ba23`](https://github.com/fomantic/Fomantic-UI/commit/af1ba235ed1e02f80c947070daf43e6fc0bb7759)
- Remove kitchen sink link from css branch [`ff2b5de`](https://github.com/fomantic/Fomantic-UI/commit/ff2b5de6e9ff333ed2908205acaf1f1841b17f45)
- Remove label padding to work correctly with compact button [`a13cf04`](https://github.com/fomantic/Fomantic-UI/commit/a13cf04d235272e9677053a279ad1bca6d5e35c2)
- Remove legacy code from sidebar [`2229306`](https://github.com/fomantic/Fomantic-UI/commit/22293069205d2e68dbbe926481a99caa2682d1a0)
- Remove manual offsets for vertically centered buttons, instead use absolute positioning on icon [`609396e`](https://github.com/fomantic/Fomantic-UI/commit/609396eefe2af693ff872df798ba944ac80a5a2a)
- Remove meteor package.js [`8fe6b69`](https://github.com/fomantic/Fomantic-UI/commit/8fe6b698571db7549c619d0713faba38de2bf59d)
- Remove minwidth from grid [`c5127e5`](https://github.com/fomantic/Fomantic-UI/commit/c5127e5161e6a0174d9836793800abeee5bc4f0c)
- Remove mkdir on node_modules, add logs [`d06c2db`](https://github.com/fomantic/Fomantic-UI/commit/d06c2dbd75e12bdd87f5ca3c78d22ef7d437a7d0)
- Remove old image loaders [`880e5e5`](https://github.com/fomantic/Fomantic-UI/commit/880e5e5fd416c27c4f4fa242231a3f8e85e0f1ed)
- Remove onscroll [`9a290c9`](https://github.com/fomantic/Fomantic-UI/commit/9a290c9aba48046fd09d6c8653451da9efa1814f)
- Remove paragraph font size, not necessary, can cause inheritance issues [`3ef464f`](https://github.com/fomantic/Fomantic-UI/commit/3ef464fb81cd567563491a26bdd69f48fb76e73a)
- Remove performance timer testing [`310e5d4`](https://github.com/fomantic/Fomantic-UI/commit/310e5d4041f614b5d65733a8b141f7f966c92de3)
- Remove pressed submit button on form [`9395853`](https://github.com/fomantic/Fomantic-UI/commit/93958536dbb6ddd367ed8d5faba1c53f537df400)
- Remove proxy calls from dimmer [`b7b4e31`](https://github.com/fomantic/Fomantic-UI/commit/b7b4e310a15510ba2a207481a99b0ffb360c94b7)
- Remove proxy calls from form [`b2ccf06`](https://github.com/fomantic/Fomantic-UI/commit/b2ccf06b950b7b669d1a341fd67d329e9dea5c1d)
- Remove proxy calls from state [`b7db66b`](https://github.com/fomantic/Fomantic-UI/commit/b7db66bc6400e827aece08aa224a1188b418b5f3)
- Remove proxy calls from tab and visit [`87a11d6`](https://github.com/fomantic/Fomantic-UI/commit/87a11d6772909af55151bc98ab11820da199ef55)
- Remove queuing from modal animations, allow clicks on dimmer to close modal even while showing [`5860d65`](https://github.com/fomantic/Fomantic-UI/commit/5860d65fc24ecdc190e74e4bfdffa8a0fcd8cb2a)
- Remove redundant class set [`1d0918e`](https://github.com/fomantic/Fomantic-UI/commit/1d0918ea729cfd01b0cfdeffe428fde456817825)
- Remove remaining HTML from CONTRIBUTING.md [`fd2fae5`](https://github.com/fomantic/Fomantic-UI/commit/fd2fae53482a38d6dc640aa66da816d8fbb8eea8)
- Remove right padding from list items [`b54f6df`](https://github.com/fomantic/Fomantic-UI/commit/b54f6dfc298e5d8ad2e691fab7db46b2129a712d)
- Remove scoping, add to semantic.less [`9f750c2`](https://github.com/fomantic/Fomantic-UI/commit/9f750c262f832e979337d43c872f8a2c88c7d3b0)
- Remove some console logs [`77247a5`](https://github.com/fomantic/Fomantic-UI/commit/77247a510e11cfbc1303503c4e0b6e21f6f18cb4)
- Remove some css values, add variables for disabled dropdown [`#1615`](https://github.com/fomantic/Fomantic-UI/issues/1615)  [`ef43c1e`](https://github.com/fomantic/Fomantic-UI/commit/ef43c1e379b4597c1c86acb3c655ac947d919b31)
- Remove some debug [`960f592`](https://github.com/fomantic/Fomantic-UI/commit/960f5925453a2bd74636a8b91f0013562b584fa9)
- Remove some debug, minor adjustments [`d317b5d`](https://github.com/fomantic/Fomantic-UI/commit/d317b5d682702bca5596a07acdcbd24f6c80eb1c)
- Remove some unnecessary voodoo [`384ea12`](https://github.com/fomantic/Fomantic-UI/commit/384ea1226cf258f9d08efb48638af814e5902c49)
- Remove spaces from md names [`1f31e56`](https://github.com/fomantic/Fomantic-UI/commit/1f31e56227c4a3e798510350684f997f206dc2be)
- Remove stub oauth [`dc622c4`](https://github.com/fomantic/Fomantic-UI/commit/dc622c4dadd6bdbccc69064fec28ac96184a6185)
- Remove tertiary colors, update dropdown vars [`8a54c1e`](https://github.com/fomantic/Fomantic-UI/commit/8a54c1ebb93852e6ff4788a1cb5baa1c23c421dd)
- Remove travis, no testing hooks set into gulp yet [`431086f`](https://github.com/fomantic/Fomantic-UI/commit/431086f8def3dc3aaddb482dd9f3564296d479b3)
- Remove travisCI integration until we have tests for 1.0 [`a5e8a9b`](https://github.com/fomantic/Fomantic-UI/commit/a5e8a9b8f00b987d410f1d1fffaa2a2809c9fdb7)
- Remove ui namespace from dimmable, now transition, dimmable, and pushable are the only 3 free floating class names [`ebf3441`](https://github.com/fomantic/Fomantic-UI/commit/ebf344199436d0b13e6539b42ac2180d448a3b96)
- Remove undocumented components [`88ea864`](https://github.com/fomantic/Fomantic-UI/commit/88ea864a462e48680f172f448198f640f1431ab8)
- Remove unnecesary border radius rule from ui menu item [`789dc0b`](https://github.com/fomantic/Fomantic-UI/commit/789dc0b1cb7560dddefa9556e7a88bb9d7a70c35)
- Remove unnecessary calls [`e0f100e`](https://github.com/fomantic/Fomantic-UI/commit/e0f100ecca0f841147e3ca3aac04122e54df7a0d)
- Remove unnecessary easing setting [`a2edb6f`](https://github.com/fomantic/Fomantic-UI/commit/a2edb6f15c2ac525fac4b868267c465ef998a3b3)
- Remove unnecessary files from dist, fix bower.json to have main [`8d2f6a0`](https://github.com/fomantic/Fomantic-UI/commit/8d2f6a05665bc735145e497b2e24b355f210f25c)
- Remove unnecessary method call [`6fcd510`](https://github.com/fomantic/Fomantic-UI/commit/6fcd5108dbb46b571886e4b18e7a89963f3b7181)
- Remove unnecessary perspective from flip transition [`bd619a1`](https://github.com/fomantic/Fomantic-UI/commit/bd619a116e79b49389b4f8968003c0bb023a1283)
- Remove unnecessary ui from fixed sidebar elements [`d9d9b98`](https://github.com/fomantic/Fomantic-UI/commit/d9d9b98371effeb84ead2feadae116454c676424)
- Remove unnnecessary properties leftover from days before flexbox grid [`55fb4d5`](https://github.com/fomantic/Fomantic-UI/commit/55fb4d56c7b77bf76c315cf680a09c600a24deec)
- Remove unreachable code [`#4225`](https://github.com/fomantic/Fomantic-UI/issues/4225)  [`52a8b6b`](https://github.com/fomantic/Fomantic-UI/commit/52a8b6b4d1ca71e56009066dd7ba2100888f9007)
- Remove unused variables from input [`5a56b3e`](https://github.com/fomantic/Fomantic-UI/commit/5a56b3ec414aed9b7d402dba8c0f62f44c35ea34)
- Remove use of :visible, fix backspace on tag when tag is user value [`7dd5089`](https://github.com/fomantic/Fomantic-UI/commit/7dd508946fc048fcb1b408129da89a1251f6d683)
- Remove use of get() [`4765913`](https://github.com/fomantic/Fomantic-UI/commit/476591320fa1797ba3b1749db7682d563c4c3fc2)
- Remove variable size overrides [`e48e5ce`](https://github.com/fomantic/Fomantic-UI/commit/e48e5ce970fc83799ca7cd21b5eec646e970ca8a)
- Remove vendor prefix from transition (jq &gt; 1.8) [`e996b65`](https://github.com/fomantic/Fomantic-UI/commit/e996b655d469c6e18ebe0c82cbbeeef749517878)
- Remove vertical spacing from breadcrumb [`77f1d7c`](https://github.com/fomantic/Fomantic-UI/commit/77f1d7c4dde0d6b5a995739d188a790401bc94c7)
- Remove will-change from transition, causes 3d context to be created on element in chrome breaking position: fixed [`e442885`](https://github.com/fomantic/Fomantic-UI/commit/e4428857d56aa9791950f8dcd7913978be33e2d5)
- Remove word-wrap from label [`#3006`](https://github.com/fomantic/Fomantic-UI/issues/3006)  [`180f963`](https://github.com/fomantic/Fomantic-UI/commit/180f9639daa99ad4e65619090a0f3d8c4610e9ff)
- Removed stale.yml [`d64524c`](https://github.com/fomantic/Fomantic-UI/commit/d64524cc41f367b381cd9fbd39c285a4ad677062)
- Removed the unused `values` variable [`8c2ed75`](https://github.com/fomantic/Fomantic-UI/commit/8c2ed75b028a02eb6e7fb70f25ef54829fbd503b)
- Removed unneeded files & 2.4 build [`ca81e97`](https://github.com/fomantic/Fomantic-UI/commit/ca81e9796111ce846654c22b50b1498dc54df384)
- Removes all references to year from copyright notice (lets save some annoyance every january) [`e1e1a81`](https://github.com/fomantic/Fomantic-UI/commit/e1e1a81ab3187ec8ecefd2dc60bc078edf3e7ddc)
- Removes all uses of jquery waypoint for SUI sticky module [`e515b99`](https://github.com/fomantic/Fomantic-UI/commit/e515b99c3fb48f7d32e11c0b4115e45a985015f4)
- Removes animation-direction, adds in transitions for both directions for safari support [`bc865f0`](https://github.com/fomantic/Fomantic-UI/commit/bc865f0c8c050ca3bb8e11dc5d0fc7e417c83368)
- Removes awful background animation on sidebar, removes lato from src files [`2b1d585`](https://github.com/fomantic/Fomantic-UI/commit/2b1d585671ad2be95a73fe08dfd11512bfbddc18)
- Removes body margin fix, adds padding to vertically divided stackable [`b89aa28`](https://github.com/fomantic/Fomantic-UI/commit/b89aa28e4e5c96717e07027d2f4c5fd13fa5ac53)
- Removes button travel distance, f that ish [`b4c01a0`](https://github.com/fomantic/Fomantic-UI/commit/b4c01a077387b19a9b4f88aa206a8d29cfe0d0a1)
- Removes class reset from show [`6280bce`](https://github.com/fomantic/Fomantic-UI/commit/6280bce801775611680fe3e9746a6cc8122a7740)
- Removes container element [`9d8db12`](https://github.com/fomantic/Fomantic-UI/commit/9d8db1205d0d30c7a494c572b58741f8e92c79ab)
- Removes coverage adds translations to readme [`a2129f6`](https://github.com/fomantic/Fomantic-UI/commit/a2129f69a735d47cfde43a967256d5e67b8cb3a1)
- Removes css comment [`f51f3e9`](https://github.com/fomantic/Fomantic-UI/commit/f51f3e9224ad8c308052bc7be7ad8a401def8f17)
- Removes debug from behaviors, adds new visit behavior [`5f90a01`](https://github.com/fomantic/Fomantic-UI/commit/5f90a01da42eac423149500e8ad1bd1958c8f7ea)
- Removes debug from popup [`88a6dc6`](https://github.com/fomantic/Fomantic-UI/commit/88a6dc652c84c9babaf78997b4aa8bf3d5211546)
- Removes debug info from module [`5abf0b4`](https://github.com/fomantic/Fomantic-UI/commit/5abf0b4e278610edf19e680ab0b657282371b633)
- Removes dependency that no longer exists [`a584aa7`](https://github.com/fomantic/Fomantic-UI/commit/a584aa7bb11cb403091e446c0cb40e6c34cdab02)
- Removes divider rules from form [`#3092`](https://github.com/fomantic/Fomantic-UI/issues/3092)  [`377dfe2`](https://github.com/fomantic/Fomantic-UI/commit/377dfe20b40e7efda7623eef9b63a3336ed63015)
- Removes docpaddb file [`a0eb2f3`](https://github.com/fomantic/Fomantic-UI/commit/a0eb2f30526337125dbd5118d7ff11c02470ab67)
- Removes double border from table segment [`8b99d17`](https://github.com/fomantic/Fomantic-UI/commit/8b99d173686bb86e990c491823efab8d1ce6ada2)
- Removes empty rule [`532b904`](https://github.com/fomantic/Fomantic-UI/commit/532b904637cbcec5733627b44be738bde0c3cf9d)
- Removes erroneous description from menu docs [`6fbf1ed`](https://github.com/fomantic/Fomantic-UI/commit/6fbf1edef993b88544a0925d0b32ba1b19277285)
- Removes force repaint of dropdowns due to fixes in transition module [`be8dd23`](https://github.com/fomantic/Fomantic-UI/commit/be8dd23b3b2570ed58341e15644e1ce16ba22862)
- Removes hook for debug [`9f8eded`](https://github.com/fomantic/Fomantic-UI/commit/9f8eded2a4eee39b1b02d1a885b6771fe0ba8e91)
- Removes important from theme overrides [`3d40e98`](https://github.com/fomantic/Fomantic-UI/commit/3d40e98ae4ba10e55998fbb2739e08162bf49435)
- Removes label input padding, breaks valign with flex [`c713945`](https://github.com/fomantic/Fomantic-UI/commit/c7139458c6997c7aa741da51ff2cbff32f98c9be)
- Removes learn-semantic content from docs, redoes folder structure of project, adds grunt config [`1eefa16`](https://github.com/fomantic/Fomantic-UI/commit/1eefa169ff31b17bc6483b98b9c4229b411af6b7)
- Removes margin from buttons, messes with vertical align [`896a34e`](https://github.com/fomantic/Fomantic-UI/commit/896a34e57309500640814e865a8e94550f9d4c95)
- Removes margin from normal accordion content [`63ebc0f`](https://github.com/fomantic/Fomantic-UI/commit/63ebc0f5051092e6ca6dc7c80884e3b53518aa04)
- Removes min-width rule for mozilla [`f87c07f`](https://github.com/fomantic/Fomantic-UI/commit/f87c07fa4abf6ebabc5d821d6e4f450462c1bb14)
- Removes negative margin on adjacent segment [`#1587`](https://github.com/fomantic/Fomantic-UI/issues/1587)  [`fef80ad`](https://github.com/fomantic/Fomantic-UI/commit/fef80ad974f36f18cd41ec0d60e862f595bdca49)
- Removes node_modules [`f5b5079`](https://github.com/fomantic/Fomantic-UI/commit/f5b50794453904c2538cebaf426c519ded8cd9b0)
- Removes old theme.include [`354afdd`](https://github.com/fomantic/Fomantic-UI/commit/354afddab5f343c5c9466aa59db8cb6b8fe649d0)
- Removes opacity tween from action input to make colors match [`6bf33d2`](https://github.com/fomantic/Fomantic-UI/commit/6bf33d27a448c3ea3551c4b2c28b248013bb2ce6)
- Removes pointer events from disabled buttons, adds icon distance to labels, removes margin from bottom floated images [`7a165e8`](https://github.com/fomantic/Fomantic-UI/commit/7a165e87498c5cfb9fec10211b0a263f2a20e4e1)
- Removes popup from unit tests [`0aa7de2`](https://github.com/fomantic/Fomantic-UI/commit/0aa7de2515f3d0e16c728cd2788cc7667a7207f5)
- Removes position: relative, from dimmable when set to 'body' [`#3692`](https://github.com/fomantic/Fomantic-UI/issues/3692)  [`09fa415`](https://github.com/fomantic/Fomantic-UI/commit/09fa415ef6cecaa462b51ced167364302eb26e49)
- Removes prefixes from transition.less [`c2f7407`](https://github.com/fomantic/Fomantic-UI/commit/c2f7407ac379489344fd2475070c86c6f801d494)
- Removes previous changes for modal detachable to segment/dimmer. Fixed transition error message to make more sense [`9b2afb7`](https://github.com/fomantic/Fomantic-UI/commit/9b2afb7dacea610443a056b96a25278f599eb481)
- Removes quirky styles from sem-ui standard branch [`91941b5`](https://github.com/fomantic/Fomantic-UI/commit/91941b558561c5c871be09c86c1be075802a7e38)
- Removes references to performance.display(), out of scope! [`557163e`](https://github.com/fomantic/Fomantic-UI/commit/557163e48153eaed96a4696ea9b4b0faa3b0293c)
- Removes semantic.config from tracked files [`2aa16fb`](https://github.com/fomantic/Fomantic-UI/commit/2aa16fbba8b57725a972c8b399ed9a97443977c0)
- Removes square icon middle alignment [`c4cd2fd`](https://github.com/fomantic/Fomantic-UI/commit/c4cd2fd09637d1a10a32dda6ce402adbc2178286)
- Removes transparent border from inverted menu. Fixed vertical compact menu [`9794ece`](https://github.com/fomantic/Fomantic-UI/commit/9794ecefa66f8d3d541acc427f365c689c5c78ec)
- Removes undocumented loading class for menu [`3582a5a`](https://github.com/fomantic/Fomantic-UI/commit/3582a5a35a349e3acb2f2beabca95b4856f326cf)
- Removes unnecessary animation checks from dimmer, now handled in transition [`ef8a8ae`](https://github.com/fomantic/Fomantic-UI/commit/ef8a8ae6f4df3c31594dbeac61c180eb1f514a8d)
- Removes vendor prefixes from checkbox source, adds transform: none to avoid GPU acceleration triggers which might cause rendering issues with radio box circles [`0f742b7`](https://github.com/fomantic/Fomantic-UI/commit/0f742b7f8e8579799c3a843af4f1572f438402aa)
- Removes vendor prefixes grid [`85c3a8e`](https://github.com/fomantic/Fomantic-UI/commit/85c3a8eb8e56e30155e67065b4c1a76d91d2405c)
- Removes vertical align fix causes issues in chrome [`84abf6e`](https://github.com/fomantic/Fomantic-UI/commit/84abf6e264476193fd92b7b07ae85757357f09d3)
- Rename bounce as fly [`#1623`](https://github.com/fomantic/Fomantic-UI/issues/1623)  [`e7e73a1`](https://github.com/fomantic/Fomantic-UI/commit/e7e73a1a18815c2f312dd748bde7c031cbe02bc6)
- Rename localSearch to filterAPIResults [`#4815`](https://github.com/fomantic/Fomantic-UI/issues/4815)  [`a8bdf7d`](https://github.com/fomantic/Fomantic-UI/commit/a8bdf7d1053514f5eb6d9dfddb5bd0d7dc234170)
- Rename pressedTextColor var [`5527ce6`](https://github.com/fomantic/Fomantic-UI/commit/5527ce6c9a48c7c917bd9633a075ec62ba328506)
- Rename selectonShortcut [`7c01d21`](https://github.com/fomantic/Fomantic-UI/commit/7c01d212b889dcbf7a7de8685cad16b3288593c8)
- Rename setting to evaluateScripts [`0417374`](https://github.com/fomantic/Fomantic-UI/commit/041737482525b48d4e71e1ef838adfe2cb8902ff)
- Renamed 'rubberband' transition to 'jiggle' [`22097b9`](https://github.com/fomantic/Fomantic-UI/commit/22097b96069bbf3db684fe5b4531c8cf0c39ce66)
- Renames UI Block to message to be more explicit` [`87a8221`](https://github.com/fomantic/Fomantic-UI/commit/87a8221073c79725ec9ef05dd225d9d8a6e11998)
- Renames behavior dir to plural [`7b6f73c`](https://github.com/fomantic/Fomantic-UI/commit/7b6f73cc449a7dcbba11403a36b0f6e176dca681)
- Renames boilerplate to spec folder, adds commented and uncommented module spec [`76a424f`](https://github.com/fomantic/Fomantic-UI/commit/76a424f6857795c79038fe01ccfdc8194df754e0)
- Renames invoked response to returnedValue for clarity, fixes issue when non string values are returned in array [`032871e`](https://github.com/fomantic/Fomantic-UI/commit/032871e045649d4dad88c543264ae5af2d4f7b9b)
- Reorder site.variables for easier scannability, adjust highlighted text color [`3f14564`](https://github.com/fomantic/Fomantic-UI/commit/3f14564bfcff4c171a8b564aee234dc2d9e312c9)
- Reordering button.variables for legibility [`5e70c1e`](https://github.com/fomantic/Fomantic-UI/commit/5e70c1e2901d7bb6ce1bb84a12298609336baf25)
- Repackages files and version uptick to 0.10.2 [`8714d7b`](https://github.com/fomantic/Fomantic-UI/commit/8714d7bfae3d4d2476e6e6fdde53a619115be78b)
- Replace proxy calls in rating [`91d7163`](https://github.com/fomantic/Fomantic-UI/commit/91d71639aa8d99ef6306d764289f1248272e7d00)
- Reported FA5 using a new method [`b9b2e63`](https://github.com/fomantic/Fomantic-UI/commit/b9b2e63f25ee9f3a89aa7a8ae23f7a3694023c1f)
- Reset debug to false [`#2173`](https://github.com/fomantic/Fomantic-UI/issues/2173)  [`3345fd1`](https://github.com/fomantic/Fomantic-UI/commit/3345fd1213669bc79cd77b763d56e203ef673bf8)
- Reset hide delay to 0 [`#1852`](https://github.com/fomantic/Fomantic-UI/issues/1852)  [`0fb55e2`](https://github.com/fomantic/Fomantic-UI/commit/0fb55e2bddc04b6a623c6bd25ec17024b10d791d)
- Reset on destroy on video component [`e019520`](https://github.com/fomantic/Fomantic-UI/commit/e019520f6f60a6b8d3852eca72728c77505cf833)
- Reset some styles in tooltip [`6fea79b`](https://github.com/fomantic/Fomantic-UI/commit/6fea79b6698974e755e8cf450f1f9abe137c90bc)
- Resolve XHR error conditions for abort, with CORS [`d993d45`](https://github.com/fomantic/Fomantic-UI/commit/d993d45e90e8e4b057036f5403f84df804e15bc0)
- Resolve issues with line-height in ui input [`50dcb5e`](https://github.com/fomantic/Fomantic-UI/commit/50dcb5e35d083cd4ba5f9150b158339dd4851a88)
- Resolved cache problem for data attributes of dropdown options. [`7325170`](https://github.com/fomantic/Fomantic-UI/commit/73251701549e3d502da83117bcf2b94ead54e966)
- Resolved issues with inputs sizes not matching up due to line-height, several other fixes [`ae89c3b`](https://github.com/fomantic/Fomantic-UI/commit/ae89c3b874eda2326112d73851af35ed08e61e15)
- Resolves first/last margin on secondary menu [`142539c`](https://github.com/fomantic/Fomantic-UI/commit/142539cacb9fafaf0681b0605de6925df7fb7646)
- Responsive grids are now deprecated, all page grids are now responsive. [`60c00a6`](https://github.com/fomantic/Fomantic-UI/commit/60c00a60783132edb48c987c357c783a67224c17)
- Restore defaults now correctly clears previous values [`f022cd4`](https://github.com/fomantic/Fomantic-UI/commit/f022cd4910f09e3d241c54fe881ba4079c255f08)
- Restructure all behaviors in search to be sentence case, remove all proxy calls [`d5632f4`](https://github.com/fomantic/Fomantic-UI/commit/d5632f42eb63c023799873775022122930d35108)
- Restructure install steps [`7816f55`](https://github.com/fomantic/Fomantic-UI/commit/7816f55d49625e243e79c027a7b964c02acd95a0)
- Restructure test/ for meteor [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607)  [`8afab4a`](https://github.com/fomantic/Fomantic-UI/commit/8afab4af8d6c19e047c1986884250b5d69cba94e)
- Restructures site variables, fixes slider/toggle checkbox to not change with em (like radio and checkbox), adds several missing form variables [`0106cd3`](https://github.com/fomantic/Fomantic-UI/commit/0106cd3fb0978b9d40c5e7ea4dcfd8d83080f84f)
- Restructures theming folder to be more structured, renames user themes site theme. Fixes up semantic.config to only give example config with instructions to avoid overrwrite on update [`527dfe0`](https://github.com/fomantic/Fomantic-UI/commit/527dfe0202607ddc70197f175af226a417d21c6b)
- Restructuring readme [`b35dfca`](https://github.com/fomantic/Fomantic-UI/commit/b35dfca49f37e7ac9480ff73728ed37034111bd4)
- Restructuring site.variables files for easier comphrehensibility. [`acabab0`](https://github.com/fomantic/Fomantic-UI/commit/acabab0c4ebd7458e37c99d4ac1da824cf2bc56a)
- Restyle of basic buttons to be more tactile [`5b0682d`](https://github.com/fomantic/Fomantic-UI/commit/5b0682d664e3f770e8679e82f6517b67a0ab952d)
- Retheming of checkbox to use inline font file, and new styles for slider and toggle [`a26ab14`](https://github.com/fomantic/Fomantic-UI/commit/a26ab147439c70d0f4b36b6401f94654dc8039aa)
- Retooling of admin tasks [`c015875`](https://github.com/fomantic/Fomantic-UI/commit/c01587558e4395b2d0649502aaac131032e279b6)
- Reuse some code [`c6b47c7`](https://github.com/fomantic/Fomantic-UI/commit/c6b47c7a0f8f974c4e2f143ca691a40294c2db49)
- Revamp statistic styles, move to flex [`7b702fc`](https://github.com/fomantic/Fomantic-UI/commit/7b702fc606433b29353055588dd7a9933be049e6)
- Reveal modifications [`3da68db`](https://github.com/fomantic/Fomantic-UI/commit/3da68db432a4b009b9974e7be380b15d92423e1f)
- Reveal updates [`fee61b0`](https://github.com/fomantic/Fomantic-UI/commit/fee61b073c0bd38da857817ed0c51f53b8082ff1)
- Reverse tab case sensitivity [`#2455`](https://github.com/fomantic/Fomantic-UI/issues/2455)  [`4b14d45`](https://github.com/fomantic/Fomantic-UI/commit/4b14d4501f8d00c95e5397ad68cadc80bce23639)
- Reverse ternary to allow falsey values to evaluate as no precision [`525a61d`](https://github.com/fomantic/Fomantic-UI/commit/525a61dff90373e866d5155dc3854aa92e6fc5c7)
- Revert "Build JS files" [`d5c009e`](https://github.com/fomantic/Fomantic-UI/commit/d5c009eaa4da9ac65a83be4756604ff300991078)
- Revert "zone.js/issues/319 Loosen equality on undefined check for determining input event" [`1e8d01b`](https://github.com/fomantic/Fomantic-UI/commit/1e8d01b4a740973e31bdc3a78a6de6b5cbc1cc4e)
- Revert api change [`e54566b`](https://github.com/fomantic/Fomantic-UI/commit/e54566b8de59a6f4a84b91465a584faee237004e)
- Revert changes to install task [`0291b5d`](https://github.com/fomantic/Fomantic-UI/commit/0291b5dfdf28661ec903a276e2ff1af066e18de1)
- Revert flex on vertical menu, no real need, and causing issues with ios [`a16c140`](https://github.com/fomantic/Fomantic-UI/commit/a16c1402c8cf11b5e5dda74bd56b18a4c9f927d9)
- Revert the changes and increase the selector’s specificity. [`b13c972`](https://github.com/fomantic/Fomantic-UI/commit/b13c972c3d0b26d922dc642f3c73aff4d628fd3c)
- Revert themes until LESS.js inheritance works correctly in browser for theme preview [`641a837`](https://github.com/fomantic/Fomantic-UI/commit/641a837a99ebd5775967c87fb6a7b98beeb05c96)
- Revert transition changes, causes overlap issues in some animations like popup. [`60e1fa1`](https://github.com/fomantic/Fomantic-UI/commit/60e1fa13d06234ff2a7f9e7fdc78b5b437b3631b)
- Revert wrong deletion of the state module [`392854e`](https://github.com/fomantic/Fomantic-UI/commit/392854e2e5dff8850a052ba2f5ea972b9557772a)
- Reverts [`#2061`](https://github.com/fomantic/Fomantic-UI/issues/2061) scrollbar changes, adds blurring/inverted settings in modal settings [`46198c9`](https://github.com/fomantic/Fomantic-UI/commit/46198c9feae1d3105b9a3bdc9a26addda3a5420d)
- Reverts [`#423`](https://github.com/fomantic/Fomantic-UI/issues/423)  sidebar changes [`c85111d`](https://github.com/fomantic/Fomantic-UI/commit/c85111db987648cc4da45d6d26987b06e4253cf5)
- Reverts change to hidden transition, hidden transitions should not be removed from page flow [`157af2d`](https://github.com/fomantic/Fomantic-UI/commit/157af2df5aceabce0d016ca18ddea988ddfe8ade)
- Reverts menu system to sidr, too many overflow issues with using faked [`8855220`](https://github.com/fomantic/Fomantic-UI/commit/8855220d653ea00b8b0204316b0dd181658d8754)
- Revise clean/version tasks [`8b4c421`](https://github.com/fomantic/Fomantic-UI/commit/8b4c421711c86a22d9a8fc24d8e56b33f72e4080)
- Revise message definiton [`90f88ca`](https://github.com/fomantic/Fomantic-UI/commit/90f88cab90af673ee4dc00d18611eb9ecb5b8396)
- Revise segment docs, fix zindex issue with piled segment and add disclaimer [`5bcff31`](https://github.com/fomantic/Fomantic-UI/commit/5bcff317bc105628650734b80c254325e6f0a77e)
- Revisions from examples [`55273f0`](https://github.com/fomantic/Fomantic-UI/commit/55273f038a8d56276f667e4adedff694e91f32b7)
- Revisions to message/segment shadows, fixes for emotive colors, especially headers on warning/info/etc [`d9aa41e`](https://github.com/fomantic/Fomantic-UI/commit/d9aa41ed3252ed6da52e65e7665b19e05f7e5e9e)
- Revisits link colors inside lists [`f16db3f`](https://github.com/fomantic/Fomantic-UI/commit/f16db3f70abc554e88c6eaa1a7815cfd0c0ae41b)
- Rework card to be more neutral base theme, add GitHub theme. Fix list selection spacing [`e559707`](https://github.com/fomantic/Fomantic-UI/commit/e559707f89af47bd2e6c6b03c6af434c467ac5f5)
- Rework outline and brand icons to load from overrides, not define icons if not loaded (except brand which would require a refactor) [`#6226`](https://github.com/fomantic/Fomantic-UI/issues/6226)  [`7fab797`](https://github.com/fomantic/Fomantic-UI/commit/7fab7974a7ffa3a4c74ed760c41ae21d7407dc4e)
- Rework pointing / basic label for more accurate arrows [`b7667cf`](https://github.com/fomantic/Fomantic-UI/commit/b7667cfa5cdb9ef58cdc8205dfe4c974a06eb760)
- Reworking grid to use fixed gutters, and padding on page grid. Fixing grid docs [`dc786e2`](https://github.com/fomantic/Fomantic-UI/commit/dc786e2c58f0d4ee778b371ea7a5667af153d1b2)
- Reworking paths [`127c2ee`](https://github.com/fomantic/Fomantic-UI/commit/127c2eedf1ee4cebbc36077531bc5ed4a9f4a810)
- Rewrite admin tasks as export [`2f8a164`](https://github.com/fomantic/Fomantic-UI/commit/2f8a1643efaf2512d6001c5b4c1b87ce0d5bb0b0)
- Rewrite dropdown keyboard shortcuts to support sub-menus [`13886b2`](https://github.com/fomantic/Fomantic-UI/commit/13886b2eb54351a1ae661e2402ecc7f644f413ef)
- Rewrite of checkbox, new styles, css variables, font file embeds for legitness [`a30baa3`](https://github.com/fomantic/Fomantic-UI/commit/a30baa3bb015a3d7c4fe1aab833ec1242f137800)
- Rewrite of intro docs [`8906cba`](https://github.com/fomantic/Fomantic-UI/commit/8906cba6a607efdb1631d61817c7f7666bb2d9c1)
- Rewrite of sidebar to support sidebars visible on load [`#649`](https://github.com/fomantic/Fomantic-UI/issues/649)  [`fa05065`](https://github.com/fomantic/Fomantic-UI/commit/fa050650133d1ffac697657f2a580a73c741402b)
- Rewrite of sticky's crucial 'stick' function to be more coherent, deal with scrolling better. Fixes to grid/menu/list. Demo page footer [`1758250`](https://github.com/fomantic/Fomantic-UI/commit/1758250f399de14afcc60c3fc7081ec16cac3b23)
- Rewrites state to remove hover/focus other useless methods, fixes integration with API, removes auto margins on first and last child of some elements [`01e9a41`](https://github.com/fomantic/Fomantic-UI/commit/01e9a418828ab7685a915069641e9277ed3189e2)
- Rewrote a ton of shit in a ton of modules. [`82b4144`](https://github.com/fomantic/Fomantic-UI/commit/82b4144bca0739640d17997ef39206b9de4bbaf1)
- Ribbon labels now automatically position inside tables [`#1930`](https://github.com/fomantic/Fomantic-UI/issues/1930)  [`9f17381`](https://github.com/fomantic/Fomantic-UI/commit/9f173819c68988e7ebd37d97e9a8450974d63dc5)
- Rlsnote lang [`7491b94`](https://github.com/fomantic/Fomantic-UI/commit/7491b9455f116a5508e2d4caf40726ef843779a9)
- Rounded by default menu [`08b9607`](https://github.com/fomantic/Fomantic-UI/commit/08b96072dc406b2583aee37dd182f65ce99e5457)
- Rounding some header values [`24f1367`](https://github.com/fomantic/Fomantic-UI/commit/24f136794b8c6ed47264a82e9e20da185fa2edaa)
- Safely removes .field .field margin [`#2487`](https://github.com/fomantic/Fomantic-UI/issues/2487)  [`de53fd2`](https://github.com/fomantic/Fomantic-UI/commit/de53fd257d6edec58eeb600ba97db457249ad4d0)
- Same [`6a5135f`](https://github.com/fomantic/Fomantic-UI/commit/6a5135f4e7ccdf5ab1a5abe5e725906f93046099)
- Search IDs now not zero indexed [`bcd6ebe`](https://github.com/fomantic/Fomantic-UI/commit/bcd6ebe87ceb5a176f7e8c30ddda61ab5fc1be1e)
- Search dropdown is now more efficient, will only process text content for searching, and values. Not text html values [`7991372`](https://github.com/fomantic/Fomantic-UI/commit/7991372b62a13b8e0c84fd093ec026ac295327bb)
- Search dropdowns now work without using selection dropdown [`1e87f3d`](https://github.com/fomantic/Fomantic-UI/commit/1e87f3d618b0eed2badd93534c37ae4161f36dcb)
- Search remote data before showing if necessary [`#4041`](https://github.com/fomantic/Fomantic-UI/issues/4041)  fix typo in remote search setting [`6b759b7`](https://github.com/fomantic/Fomantic-UI/commit/6b759b74c0470164abd614e0a89bcfccbc8363b1)
- Search selection dropdown now forces ui dropdown class [`6769eb1`](https://github.com/fomantic/Fomantic-UI/commit/6769eb1220a5beb72e5a9afb415bb5502b04fa2c)
- Search selection now allows re-searching after selection [`05178b8`](https://github.com/fomantic/Fomantic-UI/commit/05178b8de231b73c246412f8ecdd5183d7d48266)
- Search will now create results container automatically, and add category search classname [`bb8a9f5`](https://github.com/fomantic/Fomantic-UI/commit/bb8a9f57eecf99b61fefe6b1443f5673e44042ff)
- Segment now uses the global floatedShadow value for raised segment [`9e5bee9`](https://github.com/fomantic/Fomantic-UI/commit/9e5bee97e29b0d4605d104c8f80d0e3660d5b997)
- Segments now use border not box-shadow, add new plural variations [`#2411`](https://github.com/fomantic/Fomantic-UI/issues/2411)  [`a34bd91`](https://github.com/fomantic/Fomantic-UI/commit/a34bd91704a144daba865cbfbfccccf5845cfb1e)
- Select fix [`39e48ba`](https://github.com/fomantic/Fomantic-UI/commit/39e48ba2c04b894696c2c3ead9077758aca2a9e5)
- Selector cache schange [`#3183`](https://github.com/fomantic/Fomantic-UI/issues/3183)  [`d8e505c`](https://github.com/fomantic/Fomantic-UI/commit/d8e505cd657a5eb4fb0fe69996be0eccab97f46b)
- Semantic.config is now theme.config, makes more sense. Fix comment banners in themes/site files to give context in compiled output. [`c129851`](https://github.com/fomantic/Fomantic-UI/commit/c129851f251941e136dbf32dac4dbe89d80d9ccb)
- Set all modules to verbose: false by default [`6f1bf2e`](https://github.com/fomantic/Fomantic-UI/commit/6f1bf2ea897d98e0e41334211970b3f545bef67e)
- Set path im example file to default install path [`9255603`](https://github.com/fomantic/Fomantic-UI/commit/9255603605007ea537c6d5f9b25cc204421688b9)
- Set transition duration to false by default, inherits from CSS [`3c9ea43`](https://github.com/fomantic/Fomantic-UI/commit/3c9ea4301e27f366cacd0081d7860b60b8f4330c)
- Set up remaining views with variable stubs, add correct copyright notice on all files [`7834c58`](https://github.com/fomantic/Fomantic-UI/commit/7834c584e66250330e4311b17d0ea94b8ed12a07)
- Sets a default flip for flipped icons [`b6f8784`](https://github.com/fomantic/Fomantic-UI/commit/b6f87847b0361c23b4d9932398afc400a8378f1e)
- Sets all debug to false [`b4fcb35`](https://github.com/fomantic/Fomantic-UI/commit/b4fcb35441e5cdcae5e96c1121f61bd40080cb94)
- Setting up gulpfile [`6a1c856`](https://github.com/fomantic/Fomantic-UI/commit/6a1c85675f3e011c6cfb0a5d8cc9c56e0615c51c)
- Setting up some more directory structure for tests [`d0f9d5f`](https://github.com/fomantic/Fomantic-UI/commit/d0f9d5fd13866db3f2bc9f3cd64569f826d05a23)
- Setup embed component, fix all contributors banners in src [`40fb074`](https://github.com/fomantic/Fomantic-UI/commit/40fb0743eb4062d9028f4f47494502458902578c)
- Setup forked prompt package [`f89dc9c`](https://github.com/fomantic/Fomantic-UI/commit/f89dc9c36c084605e787c77fc99290170b8f7b38)
- Several docs fixes to formatting, changes to raised button theme [`149cd66`](https://github.com/fomantic/Fomantic-UI/commit/149cd66b45a0ea3193e06a8889d83e88437cbe19)
- Several fixes for inversion with form, checkbox, segment, header [`4c424c3`](https://github.com/fomantic/Fomantic-UI/commit/4c424c3a795b92021a850cdf0ab6479ce69b5ec1)
- Several fixes for ui list, formatting changes. Redid list documentation [`4d0b8e5`](https://github.com/fomantic/Fomantic-UI/commit/4d0b8e565ed9ae8869d260ca8175edaabb8dfdcb)
- Several more fixes to formatting of standard response [`0f911e1`](https://github.com/fomantic/Fomantic-UI/commit/0f911e16d00d87316f8d6b41a80517ef4bde4689)
- Several more possible issues with missing package.json [`367ffb9`](https://github.com/fomantic/Fomantic-UI/commit/367ffb9fe5d3ca20de938dd5c7539dd5bbf46e53)
- Shapes now animate height/width on transition [`6611821`](https://github.com/fomantic/Fomantic-UI/commit/6611821d2ec3a1678519ca4dd529c45511194b1e)
- Sidebar now attaches to correct context, works in contexts other than body [`8e775d3`](https://github.com/fomantic/Fomantic-UI/commit/8e775d3e6f3e38ee855b5916bb4d8b7c6e78497b)
- Sidebar- default mobile animation is now overlay [`7a4faf7`](https://github.com/fomantic/Fomantic-UI/commit/7a4faf7aae721749c91cd99b99732f7baa148600)
- Silly update icons to FontAwesome v4.4 [`8c9bd9c`](https://github.com/fomantic/Fomantic-UI/commit/8c9bd9c2b11a0833f5b48b2044bae91e2b73ec58)
- Similar [`#2092`](https://github.com/fomantic/Fomantic-UI/issues/2092) add ability to mock server response using function [`e3f6d18`](https://github.com/fomantic/Fomantic-UI/commit/e3f6d18e403b049fd5c28d0b0589e75708ec089e)
- Simplifies header [`3c2158e`](https://github.com/fomantic/Fomantic-UI/commit/3c2158e662e63f93be8183b143e329f6b1c74b81)
- Simplifies test [`fb0222f`](https://github.com/fomantic/Fomantic-UI/commit/fb0222fbc1be26ceb0837004760afd6c31047161)
- Simplify debug on blur [`f3f2e7f`](https://github.com/fomantic/Fomantic-UI/commit/f3f2e7f50ee23aef2991a013395e081213bc0979)
- Simplify default API debug output for clarity [`58609bf`](https://github.com/fomantic/Fomantic-UI/commit/58609bf62ad33e90fd68b0e41fa6e2e02deb6eb1)
- Simplify dep ver [`3f690d6`](https://github.com/fomantic/Fomantic-UI/commit/3f690d6c9be6bb369f76d450a03d4fb7a399f3c2)
- Simplify input button/labels inside menus [`#1289`](https://github.com/fomantic/Fomantic-UI/issues/1289)  [`2391c7c`](https://github.com/fomantic/Fomantic-UI/commit/2391c7cb0c5e3793518a5724780198d1f0acd26a)
- Simplify label margin [`6d54ff0`](https://github.com/fomantic/Fomantic-UI/commit/6d54ff0d6dac326f1ae8757bae488595b7fa3d04)
- Simplify logic with parent context [`d1c47df`](https://github.com/fomantic/Fomantic-UI/commit/d1c47dfa57ebbdd20db74dc586473cd330f6308b)
- Simplify visibility/sticky to use .load instead of worrying about each image loading [`360f9dd`](https://github.com/fomantic/Fomantic-UI/commit/360f9ddbd72591af60751120eee1626ea2465c78)
- Slight formatting fixes table, fixes doubling grid spacing [`664e352`](https://github.com/fomantic/Fomantic-UI/commit/664e3522907f0a0cb1e8b43220244965ee9d7c50)
- Slight modification to remove looping [`089bf33`](https://github.com/fomantic/Fomantic-UI/commit/089bf334009ff145f09bdf23e1584dba312f9938)
- Slight tweak to attached header padding [`dd212ac`](https://github.com/fomantic/Fomantic-UI/commit/dd212ac40815b953adc317e27d5d147b8f0222a9)
- Slight update to input sizing inside menus [`#553`](https://github.com/fomantic/Fomantic-UI/issues/553)  [`d5d293d`](https://github.com/fomantic/Fomantic-UI/commit/d5d293ddf7ffd740fbdabfd04c74186b0ddff5b8)
- Slightly darken border colors [`a8cf810`](https://github.com/fomantic/Fomantic-UI/commit/a8cf810e01967dbd20d7910099c7adc943b7d6fe)
- Slightly darken grey [`caf2ad3`](https://github.com/fomantic/Fomantic-UI/commit/caf2ad3beb8d2d30118248d31e66741cf2244dc8)
- Slightly de-emphasize message border colors, fix emSize variable [`e17ed5b`](https://github.com/fomantic/Fomantic-UI/commit/e17ed5b1bc019e52ec70412b63870f9279931bed)
- Slightly increase sidebar animation speed [`32327b4`](https://github.com/fomantic/Fomantic-UI/commit/32327b45e77039a00c196ace408ed5702b22c73d)
- Slightly increases transparent icon spacing [`#1346`](https://github.com/fomantic/Fomantic-UI/issues/1346)  [`95e183e`](https://github.com/fomantic/Fomantic-UI/commit/95e183e5c782d9c4d92fdf1c80cb64c02be95a87)
- Slightly more efficient shape calcs [`21df81a`](https://github.com/fomantic/Fomantic-UI/commit/21df81ab40bbb88713a456f4242b3cca56f39a22)
- Small change, padding [`b4f5d54`](https://github.com/fomantic/Fomantic-UI/commit/b4f5d54545246721b242bb2b7031c91537eea592)
- Smaller size for menu fixed button [`5457b18`](https://github.com/fomantic/Fomantic-UI/commit/5457b186e380167cbf733fc0655dad5f6f3e1197)
- So much fun [`9b15303`](https://github.com/fomantic/Fomantic-UI/commit/9b15303b66471f39ac708a1c0be6447f18029b7f)
- Solidfying format of usage/settings tabs of module. Beginning verification all settings objects and behavior lists are up to date [`9831699`](https://github.com/fomantic/Fomantic-UI/commit/983169980fc86dc00fa99230bd540c0241084f89)
- Some UI missing load override [`#1637`](https://github.com/fomantic/Fomantic-UI/issues/1637)  [`98afd22`](https://github.com/fomantic/Fomantic-UI/commit/98afd2230d435271c3596d5b2ebf793d3d0b7888)
- Some cleanup [`a246807`](https://github.com/fomantic/Fomantic-UI/commit/a2468070ac3ca3cc062825f026f616e94a8a28c3)
- Some more doc fixes woo [`a253b0d`](https://github.com/fomantic/Fomantic-UI/commit/a253b0d348e9e242c7c884b2104ddce8b40f9e12)
- Somehow lost all docs? Fixed. Revisions from buglist [`5a41a62`](https://github.com/fomantic/Fomantic-UI/commit/5a41a62c4455252081278a4fb8869e373942e1e3)
- Sort out global variables to be in intuitive order and match definition, move font loading to theme.config (this means users might need to re-install) [`37202a5`](https://github.com/fomantic/Fomantic-UI/commit/37202a56a221854f828732e31f1fae339e9ffd2f)
- Spacing [`b208d6f`](https://github.com/fomantic/Fomantic-UI/commit/b208d6fd222eba17a884159b0b91bf89cebbcce0)
- Speed up get.item when null or undefined [`66ee664`](https://github.com/fomantic/Fomantic-UI/commit/66ee66477c6b66f82b3d66ea168bce024f922ba9)
- Spelling and link fixes [`3d49954`](https://github.com/fomantic/Fomantic-UI/commit/3d499541e8ad23a8d6e4875309f057e87f13a26f)
- Spruce up some examples [`0fcb0da`](https://github.com/fomantic/Fomantic-UI/commit/0fcb0da163a375d28aa1b21382665f823c88d8f8)
- Spruce up some styles in search [`846ee11`](https://github.com/fomantic/Fomantic-UI/commit/846ee11cd875023614cfec51ba644b82c557fe82)
- Spruce up video styles [`be7ef7e`](https://github.com/fomantic/Fomantic-UI/commit/be7ef7e298d5363e814810376743b6cb16354f31)
- Spruces up accordion styles, add chubby accordion theme, adds more accordion variables, spruces up docs sidebar menu [`d3dd994`](https://github.com/fomantic/Fomantic-UI/commit/d3dd994c9b79e5e39e921672c817446aaabb3f62)
- Stackable grid no longer sits flush on mobile [`9a659a1`](https://github.com/fomantic/Fomantic-UI/commit/9a659a194991b4720074801b181684761baf6fc1)
- Stackable grid now only has horizontal padding on page grids [`d817a9c`](https://github.com/fomantic/Fomantic-UI/commit/d817a9cc76b016941ffb2217d04ef5c28b961c75)
- Stackable grid now pads unless inside a segment or nested grid [`75fa024`](https://github.com/fomantic/Fomantic-UI/commit/75fa02411de8db021ccc355b91fac7d8b24829ee)
- Start coding simple dimmer [`eb9fe18`](https://github.com/fomantic/Fomantic-UI/commit/eb9fe1815d17226aea839377add958278fc555da)
- Steps now are horizontally pointing again (like 1.x), added many new variables to control [`6bceb47`](https://github.com/fomantic/Fomantic-UI/commit/6bceb47beba29a94e415eb8484d4a9cc75010c9f)
- Steps will appear correctly even if each step is a different height [`#1579`](https://github.com/fomantic/Fomantic-UI/issues/1579)  [`80e5495`](https://github.com/fomantic/Fomantic-UI/commit/80e5495d27d90fda9e25b30fbab868cd36bc85f5)
- Sticky component does not set height when already same height [`b4338c7`](https://github.com/fomantic/Fomantic-UI/commit/b4338c702eb38a03d22ff78119d789fa990491bc)
- Sticky now handles bottom edge conditions better [`29c4f82`](https://github.com/fomantic/Fomantic-UI/commit/29c4f821255b61398e672fddfe6bc940d5fb1e51)
- Still fiddling with list float issues [`75096d1`](https://github.com/fomantic/Fomantic-UI/commit/75096d1ebe9ea065a71622082a5fd1739692c4a9)
- Still tweaking white colors [`fba4ad1`](https://github.com/fomantic/Fomantic-UI/commit/fba4ad148e2f8e27f9be10f34d2bc431f847a333)
- Stopping point for night [`074cb71`](https://github.com/fomantic/Fomantic-UI/commit/074cb71a795d2375768eee6089fdb52b7ec22505)
- Stub material theme, no content [`620d5b0`](https://github.com/fomantic/Fomantic-UI/commit/620d5b03171104fce7e2379e156e538e151e7d44)
- Stubs out all missing task files [`5065dbd`](https://github.com/fomantic/Fomantic-UI/commit/5065dbd1fbfa9929d57128663b7bccead10dcf9a)
- Styling on example [`8cf0adb`](https://github.com/fomantic/Fomantic-UI/commit/8cf0adb8cd1d8592905baac36bc760bd35f38963)
- Sub header position [`d129c5d`](https://github.com/fomantic/Fomantic-UI/commit/d129c5d6c3616389a9e15536f2a0628a439a8736)
- Sub headers now force display: block [`#3020`](https://github.com/fomantic/Fomantic-UI/issues/3020)  [`df3ef37`](https://github.com/fomantic/Fomantic-UI/commit/df3ef37da8a2689f2cce2e116566e92aeb4f621c)
- Submodules now receieve same debug setting [`68ea260`](https://github.com/fomantic/Fomantic-UI/commit/68ea26012d5f0fad0b02594efdefcbcf0165bca3)
- Support labels attached on both sides for input [`9b53954`](https://github.com/fomantic/Fomantic-UI/commit/9b53954f7727d659885e5b1a20c00cc897b68e79)
- Support modification of 'closable' setting while modal is open [`e444af2`](https://github.com/fomantic/Fomantic-UI/commit/e444af24834cacd43dd25a4a988b352025a541d3)
- Swap aliases on thermometer, fix issue with scrolling dropdown right padding [`01dbc26`](https://github.com/fomantic/Fomantic-UI/commit/01dbc261cac3a891278b2993a09ee34f091e2a5d)
- Swap all proxy calls in dropdown [`01fa4fd`](https://github.com/fomantic/Fomantic-UI/commit/01fa4fd8b6979ed621ba3f393b95a116287a850f)
- Swap bigWidth with hugeWidth in sizes [`#5899`](https://github.com/fomantic/Fomantic-UI/issues/5899)  [`b9d5690`](https://github.com/fomantic/Fomantic-UI/commit/b9d5690df2361507a79e29fdf03f5df4116150e5)
- Swap deps backP [`9fa2908`](https://github.com/fomantic/Fomantic-UI/commit/9fa2908788d4299b5d221c17640444ca57f106be)
- Swap mix-in for & {} [`f7f1d19`](https://github.com/fomantic/Fomantic-UI/commit/f7f1d1939d731f877b41073afc9ad71d63887945)
- Swap out this reference for  in API [`6c80605`](https://github.com/fomantic/Fomantic-UI/commit/6c8060538a8e145358144c9f7836ab3be651edcd)
- Swap video module icon [`b747338`](https://github.com/fomantic/Fomantic-UI/commit/b7473385f725aba3cd48ac93a1e55f72e3223fff)
- Swaps hover/down color to lighten [`2e79701`](https://github.com/fomantic/Fomantic-UI/commit/2e79701187ed0f5b6d4e51aa407975d32c40de0f)
- Swaps out __dirname constant for path.resolve() [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607)  [`3a75bdc`](https://github.com/fomantic/Fomantic-UI/commit/3a75bdc8d14e2d6786fe0e51c72da34fa042a741)
- Swaps out all calls to trigger() [`#3108`](https://github.com/fomantic/Fomantic-UI/issues/3108)  [`2bae116`](https://github.com/fomantic/Fomantic-UI/commit/2bae11673d1752a0c2379c9b683427a052d5936b)
- Swaps reveal to use 3daccelerated transform instead of top/left [`161d1b1`](https://github.com/fomantic/Fomantic-UI/commit/161d1b137c2f11836cd14e84c8800dfa5d58bd75)
- Swaps transition calls to consistent format across modules, looking into issues with dimmer/modal when hiding during show [`05a8671`](https://github.com/fomantic/Fomantic-UI/commit/05a8671fcef1be5ec81cc801cdf0d08d412d5624)
- Switches attached segment/header to border from box-shadow [`5c7d5f1`](https://github.com/fomantic/Fomantic-UI/commit/5c7d5f13d83b25ec93b538f46e75835e1d7c2d98)
- Tab active now bold [`cb12543`](https://github.com/fomantic/Fomantic-UI/commit/cb1254343d5f771513d4071634aaabcaa09d2504)
- Tab css loader variables [`799e00f`](https://github.com/fomantic/Fomantic-UI/commit/799e00f62b1dc829748c895a22a4af0112ec76fa)
- Tab now correctly navigates to in page anchors in closed tabs [`856ba0a`](https://github.com/fomantic/Fomantic-UI/commit/856ba0ad298694cd8e219893490cdb0221029460)
- Table default to top align [`b238c3e`](https://github.com/fomantic/Fomantic-UI/commit/b238c3e074b4e13de59eab1a0ad928c674a4dc34)
- Table footers get bg color [`ae685c1`](https://github.com/fomantic/Fomantic-UI/commit/ae685c1bf57460e22c79b7920af6ac7e99070ac3)
- Tabs does not work properly for duplicate names [`6aba684`](https://github.com/fomantic/Fomantic-UI/commit/6aba6845079404408276814daa0d25e7c3e6ed32)
- Take border color down a notch [`790f2e5`](https://github.com/fomantic/Fomantic-UI/commit/790f2e5d122535d78b719f8b976344f9938993ea)
- Temporary fix for paging (show all in dropdown) [`89a14c4`](https://github.com/fomantic/Fomantic-UI/commit/89a14c4ffb36dedc5641ef53ddf21fe999d1def0)
- Test again [`909630a`](https://github.com/fomantic/Fomantic-UI/commit/909630a790d56d2396a26968a3b233fed88659ee)
- Test fix [`2a556bb`](https://github.com/fomantic/Fomantic-UI/commit/2a556bb660ef063e014a2693ff05bb8139e7d529)
- Test upgrade path [`dc2fe9c`](https://github.com/fomantic/Fomantic-UI/commit/dc2fe9c13d661c016382f40a01b469d73df10de4)
- Test version bump [`83415b2`](https://github.com/fomantic/Fomantic-UI/commit/83415b27d935fd32910f04786df9a602657049d1)
- Test versioning [`e9a29b6`](https://github.com/fomantic/Fomantic-UI/commit/e9a29b6c611a97df524fc406be6df345b0c7fe13)
- Tested versioning [`822acf2`](https://github.com/fomantic/Fomantic-UI/commit/822acf2ae9b85f560f1bece8f3694d48581f6b90)
- Testing [`f048f4a`](https://github.com/fomantic/Fomantic-UI/commit/f048f4a6e1dd86ee747cfe1edfc2af516034d1d9)
- Testing around [`3f18396`](https://github.com/fomantic/Fomantic-UI/commit/3f18396493c2b1dc330a13f68315548a0f3667de)
- Testing out dropdown errors [`dfcf947`](https://github.com/fomantic/Fomantic-UI/commit/dfcf947facebe7392581fd16648f2260609c3127)
- Testing update [`fc806c3`](https://github.com/fomantic/Fomantic-UI/commit/fc806c3dbe23d2e90d792a61ba3c4da031c173e7)
- Text menu not bold on active [`6e0bc8c`](https://github.com/fomantic/Fomantic-UI/commit/6e0bc8c44f4b3733e11b445d995d8a9d46153fd8)
- Text menu now uses padding for larger hitboxes [`f585d4c`](https://github.com/fomantic/Fomantic-UI/commit/f585d4cf16230456431c0258f9932e155aba29c4)
- Text menus are now inline block [`d1330a6`](https://github.com/fomantic/Fomantic-UI/commit/d1330a6ec7064ef12d0e6c41d30f5527f81f3b8f)
- Text width inheritance issue [`8915d9c`](https://github.com/fomantic/Fomantic-UI/commit/8915d9c46d0a2afc38be00d15934e8d190cd4beb)
- Thanks [`#4614`](https://github.com/fomantic/Fomantic-UI/issues/4614)  [`1ce9e1c`](https://github.com/fomantic/Fomantic-UI/commit/1ce9e1cc29779b5b4635e0b4e5df728d7398ca65)
- Thanks [`#4631`](https://github.com/fomantic/Fomantic-UI/issues/4631)  [`39f20bc`](https://github.com/fomantic/Fomantic-UI/commit/39f20bc2adc91355cd67e325be6f99e100cf4383)
- Thanks [`#5902`](https://github.com/fomantic/Fomantic-UI/issues/5902)  [`f85744f`](https://github.com/fomantic/Fomantic-UI/commit/f85744f0781e37f295be3d55e247b22a07205018)
- Thanks [`#6167`](https://github.com/fomantic/Fomantic-UI/issues/6167)  [`ac0f313`](https://github.com/fomantic/Fomantic-UI/commit/ac0f3130c601a323b938217e9e5318026df76543)
- The great button escapade of friday [`7c1b82f`](https://github.com/fomantic/Fomantic-UI/commit/7c1b82f1e2391580aa475c03d111ea832e7942ea)
- The width of inputs that are inside of a dropdown’s `.menu` should never be overridden [`dfc7599`](https://github.com/fomantic/Fomantic-UI/commit/dfc7599f6b9c6c730d6f750fb17105775c6aad35)
- Theme sidebar [`7dfe73d`](https://github.com/fomantic/Fomantic-UI/commit/7dfe73ddb68d6f5e0e86c997d90a2eaafa85577d)
- Themes UI rating, modifies clearable to be set to true when only one icon is used [`e23f7c5`](https://github.com/fomantic/Fomantic-UI/commit/e23f7c597e8342dd532bfc2bb3c02b6c0c41ff65)
- Themes breadcrumbs [`b6a4011`](https://github.com/fomantic/Fomantic-UI/commit/b6a4011ff906136cfd301502fe15878671acd132)
- Themes feed, adds timeline theme for feed [`27e27ee`](https://github.com/fomantic/Fomantic-UI/commit/27e27eefe26ef3bda1be2faa531d33f13d33533b)
- Themes nag [`a3e974e`](https://github.com/fomantic/Fomantic-UI/commit/a3e974e7c8898b79131e35bdf70a03893d5f785f)
- Themes shapes [`94e9c6f`](https://github.com/fomantic/Fomantic-UI/commit/94e9c6fbbf1e04f5a409f5e2c6ae7b68ad1864cf)
- Themes tabs [`9533858`](https://github.com/fomantic/Fomantic-UI/commit/9533858ef284c46b2eac31a22eaff4bae89173ae)
- This code is bananas [`3000178`](https://github.com/fomantic/Fomantic-UI/commit/3000178c23bcd901de20e4a8ff608d515d898635)
- This is the time where i need to go to bed` [`82746f9`](https://github.com/fomantic/Fomantic-UI/commit/82746f90c9fe1ac8c03aedb2d484e5f4c2701761)
- This will drive me bananas [`7fec295`](https://github.com/fomantic/Fomantic-UI/commit/7fec295c61a2cae7e30c3dba3d08bbd57ad7757f)
- Tick version [`c85c032`](https://github.com/fomantic/Fomantic-UI/commit/c85c032fd27d443f36d6e29de8c01c81418ab18e)
- Tick version, observechanges true by default sticky [`8cc32e1`](https://github.com/fomantic/Fomantic-UI/commit/8cc32e1293d2d777c4bdcbb5d42076d6cef3c388)
- Tiered menu: fixes active items to have top border like rest of menus [`0f2d33b`](https://github.com/fomantic/Fomantic-UI/commit/0f2d33bb1c91bb501333d3c41b49e684f4a9a566)
- Tighten responsive breakpoints for docs, tighten step padding a lil [`8fd9cab`](https://github.com/fomantic/Fomantic-UI/commit/8fd9cabe85d43eb3f7fb453b12cb3d9a11764406)
- Tighten scrolling margin [`a076374`](https://github.com/fomantic/Fomantic-UI/commit/a076374fd4d4d08bc4067ce459da893ef1c84383)
- Timer logic in wrong place [`3de60bc`](https://github.com/fomantic/Fomantic-UI/commit/3de60bc3adf3593587e523fe72fe9fc904487435)
- Tinkering with stackable grid [`87c3836`](https://github.com/fomantic/Fomantic-UI/commit/87c38362ef587827c751b220b2ea8006027dc59c)
- Toggle checkbox now use primary brand color for legibility [`2a2a3cf`](https://github.com/fomantic/Fomantic-UI/commit/2a2a3cf8df7bd3ae7f30ca0f4198a5b2a32a6685)
- Top/bottom no longer removed on refresh (issue with cantFit) [`b1f7450`](https://github.com/fomantic/Fomantic-UI/commit/b1f7450c308a69bf88eeda4d79ec4c66e39cf156)
- Toying with bower main path to test whether wildcard resolves correctly [`29fdf71`](https://github.com/fomantic/Fomantic-UI/commit/29fdf711995d5513b0cf2d37d0236a9d402d5565)
- Toying with deps [`634ef9a`](https://github.com/fomantic/Fomantic-UI/commit/634ef9a19c1ed9b2173283757dc95fcb75cb408f)
- Transform in .animating.transition causing display issues in new FF update [`2e9eb08`](https://github.com/fomantic/Fomantic-UI/commit/2e9eb0892f2499478dd3304407cc12a2b1b36465)
- Transition can now read final display state from metadata [`bf49cf4`](https://github.com/fomantic/Fomantic-UI/commit/bf49cf44d89e12243f1d16d65d3cfb20effe64fe)
- Transition hide now works correctly during an animation [`f7052b5`](https://github.com/fomantic/Fomantic-UI/commit/f7052b52fcd8a9296a776ab627c66669afe703e1)
- Transition no longer determines vendor prefixes for animation-name prop. Removed 2 unnecessary prop lookups from animation increasing performance [`10a88eb`](https://github.com/fomantic/Fomantic-UI/commit/10a88ebef4dcc8fe9d4379e12389386fd78636ce)
- Triaging some bugs, adding homepage animation stops when out of view [`6c7f3b8`](https://github.com/fomantic/Fomantic-UI/commit/6c7f3b8ce6804e73ece8706e626d9adc46eec2de)
- Try again with no transform on visible transition [`6b6b90b`](https://github.com/fomantic/Fomantic-UI/commit/6b6b90b81baf4a8a9c725f809799d6bb745f4fb1)
- Try diffent css @import to possibly resolve issues in some environments [`7c5d770`](https://github.com/fomantic/Fomantic-UI/commit/7c5d7703a9a0407a3b05dfc76cd09f89d34a26fb)
- Tryin to work through all the bugs and gotcha of sidebar with css transitions (headache central) [`c68c668`](https://github.com/fomantic/Fomantic-UI/commit/c68c6685e7740a30e93cf8df319c6214b29a5e75)
- Trying out new  extend [`0cf3212`](https://github.com/fomantic/Fomantic-UI/commit/0cf3212f5dc67586da6718d24bcd6231593ff439)
- Trying to fix travis [`7ecc868`](https://github.com/fomantic/Fomantic-UI/commit/7ecc868850b91ae4fe66ac68737dedd6d7cc7c49)
- Trying to stay sane [`fa002e8`](https://github.com/fomantic/Fomantic-UI/commit/fa002e87c04fa49ef3291fab163f1dc1f127ee27)
- Trying to sync animations between multiple [`a0042a5`](https://github.com/fomantic/Fomantic-UI/commit/a0042a5630decd6a75d953c57e37073f97744a67)
- Tweak dropdown example [`3582404`](https://github.com/fomantic/Fomantic-UI/commit/358240468032a65b2f2cc0d5b0e787ee417600db)
- Tweak some ui loader settings [`f32e7ed`](https://github.com/fomantic/Fomantic-UI/commit/f32e7ed21f3304958363b305ff3d04c5404b20dd)
- Tweak to circular icons valign 141 [`05e184b`](https://github.com/fomantic/Fomantic-UI/commit/05e184b8afafb42baff98776a737482314a1b5f7)
- Tweaking card shadows [`5b4c5c6`](https://github.com/fomantic/Fomantic-UI/commit/5b4c5c617cb8a657ba259ddf53e9be07ece894fb)
- Tweaking feed styles and redoing docs [`a8ec470`](https://github.com/fomantic/Fomantic-UI/commit/a8ec4705532d2ceb9561552f7ae5f159ff2ca823)
- Tweaking flex align settings [`db69f38`](https://github.com/fomantic/Fomantic-UI/commit/db69f38bb3402f27d6949ba838a8c801bac8988d)
- Tweaking some variables for button themes [`48fbde5`](https://github.com/fomantic/Fomantic-UI/commit/48fbde5557b6ea1e9126498c28d7c278acf93f72)
- Tweaks for undocumented nag component, add indicators for incomplete components to menu, updating incomplete component docs [`ad6c5ed`](https://github.com/fomantic/Fomantic-UI/commit/ad6c5eddde0b6f01fc964c29ebac376b3a6a9ed8)
- Tweaks to card/item sizing [`a663f2b`](https://github.com/fomantic/Fomantic-UI/commit/a663f2bdd75cd68e9ae59dc991f40a7f07d8811e)
- Tweaks to footer [`049d65a`](https://github.com/fomantic/Fomantic-UI/commit/049d65a414055279d7f2ba883a286b9639a8d241)
- Tweaks to homepage [`2db558c`](https://github.com/fomantic/Fomantic-UI/commit/2db558cb02143334d4572ef34ef33ae520632506)
- Tweaks to vertical steps, docs [`0342517`](https://github.com/fomantic/Fomantic-UI/commit/03425174289520ffa8c09d594288b759e82454b5)
- Type changes to docs [`9528bc5`](https://github.com/fomantic/Fomantic-UI/commit/9528bc594e278402cb5bfe46996f24e791143909)
- Typo [`7d76dae`](https://github.com/fomantic/Fomantic-UI/commit/7d76dae78fc5c3bff4fbea6593d1ceb2bd52f10b)
- Typo in checkbox lineheight [`7b9e800`](https://github.com/fomantic/Fomantic-UI/commit/7b9e800efcc1a8b71301327fe3d234bca322f79d)
- Typo in docs [`9386477`](https://github.com/fomantic/Fomantic-UI/commit/9386477bbd7e3547370354fc95944d6ca22df6f5)
- Typo in form rule [`9db2175`](https://github.com/fomantic/Fomantic-UI/commit/9db217558e769d8bf0f2471bffb5c5687b9edfc6)
- Typo in popup check for existence [`160e5ac`](https://github.com/fomantic/Fomantic-UI/commit/160e5ac935f7cf68235db7ec58dcf053acaa6116)
- Typo in progress [`5844e6b`](https://github.com/fomantic/Fomantic-UI/commit/5844e6bf41458408bf9034b8e6a690a4309dd308)
- Typo in semantic.config.example [`4a5e5cc`](https://github.com/fomantic/Fomantic-UI/commit/4a5e5cc457309abee56b90429c5b2d67cf0d3619)
- Typo in transition causes unknown animations to not be correctly caught [`5de9b72`](https://github.com/fomantic/Fomantic-UI/commit/5de9b72e3e8a91ef7fe54757fa14bb092dcf201f)
- UI Header inherits header font weight [`409f527`](https://github.com/fomantic/Fomantic-UI/commit/409f527eca21a4084e89460c11eea7f4883a4d3a)
- UI Transiutions now forces display on element during animation with important to avoid inheritance issues. Rewrite of some more form variables [`869115b`](https://github.com/fomantic/Fomantic-UI/commit/869115b2068f665352a8f44181a64cbef6ca21af)
- Undo unnecessary formatting [`3705e96`](https://github.com/fomantic/Fomantic-UI/commit/3705e960b984b55bda8fa913bf4bb5ac78e419e0)
- Units for margin on rating [`c749bf2`](https://github.com/fomantic/Fomantic-UI/commit/c749bf2593d30a3be957e2d28df07ef7856747a2)
- Unlike other use-case, container should not have any left/right padding when inside a menu on mobile sizes. [`6f6a7f9`](https://github.com/fomantic/Fomantic-UI/commit/6f6a7f95b0e5a232115e1131ec811546afd921d2)
- Unnecessary semicolon [`7ca5fdf`](https://github.com/fomantic/Fomantic-UI/commit/7ca5fdfbdcc594317adad9e5ec276f39fd7849e4)
- Updating animation css [`b10eca9`](https://github.com/fomantic/Fomantic-UI/commit/b10eca90db9d6612e057c15670ccc6138e8a8a50)
- Updating doc header to create theme button [`4215da2`](https://github.com/fomantic/Fomantic-UI/commit/4215da2ef4bf795fbe5bd6f5a9bb00f69537fe2c)
- Updating docs [`3287164`](https://github.com/fomantic/Fomantic-UI/commit/32871640c2c1314241438d0345b38e7796aba04a)
- Updating docs for card/item/popup [`e6153aa`](https://github.com/fomantic/Fomantic-UI/commit/e6153aa790d79514fb1f39ac7d3b4c5bc190ee9b)
- Updating docs for contributing, fixing various bugs on pages [`38e7783`](https://github.com/fomantic/Fomantic-UI/commit/38e7783bfcddf4c9b3571cb022b091a7854862ad)
- Updating docs pages to reflect correct settings [`0248cff`](https://github.com/fomantic/Fomantic-UI/commit/0248cff0019744262e6ba080b446100e0820b33d)
- Updating docs to include more tabbed navs [`2090798`](https://github.com/fomantic/Fomantic-UI/commit/20907985576547fd772e5fd6ba2eb4e223b4df56)
- Updating examples [`7c2552c`](https://github.com/fomantic/Fomantic-UI/commit/7c2552c4c5443a5a23b59dff18113140bc4c2fa0)
- Updating homepage example [`9bf762e`](https://github.com/fomantic/Fomantic-UI/commit/9bf762e357663dff1365bcccbd87fc43a2be66d1)
- Updating many components over weekend. [`eda1bd2`](https://github.com/fomantic/Fomantic-UI/commit/eda1bd2b139d977952daea90c06a2401c4ebe21c)
- Updating menu doc formatting for comprehensiveness [`85eee7d`](https://github.com/fomantic/Fomantic-UI/commit/85eee7d1340f2d737a745fb1d64d64c081bfbe8f)
- Updating modal/button variable defaults [`70ec2d9`](https://github.com/fomantic/Fomantic-UI/commit/70ec2d9e1f5fcbc9e2471464c9ca29c3a139979b)
- Updating readme [`95e634e`](https://github.com/fomantic/Fomantic-UI/commit/95e634e046d4d4e0d4ad105b1d07fe13c754134e)
- Updating regex for email validation [`57e4f72`](https://github.com/fomantic/Fomantic-UI/commit/57e4f72b9e115b9f2447bb6fa24a8a7c7b25f38f)
- Updating various examples [`d0d3ac6`](https://github.com/fomantic/Fomantic-UI/commit/d0d3ac66325a414b27c2b8b97fbd44d66f8b48d8)
- Upgrad to normalize 7.0 [`#4647`](https://github.com/fomantic/Fomantic-UI/issues/4647)  [`bd08e15`](https://github.com/fomantic/Fomantic-UI/commit/bd08e15b31c0e2d227d63380d5400e7523e25fa1)
- Upgrades FontAwesome to v4.7.0 [`ca893b6`](https://github.com/fomantic/Fomantic-UI/commit/ca893b6160d70125bf0d024acdf03367f9197996)
- Upgrading to FontAwesome v4.5.0 [`133101d`](https://github.com/fomantic/Fomantic-UI/commit/133101d8ce608551a4e0798f10098d23e804dd5b)
- Use @background value for arrow background color [`d807a54`](https://github.com/fomantic/Fomantic-UI/commit/d807a542d823d9905747d1c3106668bce19e64e5)
- Use grunt-newer to quickly package and minify modified watched files [`0d19a18`](https://github.com/fomantic/Fomantic-UI/commit/0d19a1890ba16b9fd0fee4c569bbd6e1d94b752c)
- Use hexadecimal literals istead of octal literals in install tasks [`a0e5980`](https://github.com/fomantic/Fomantic-UI/commit/a0e5980725cdb844be2fa4fa9b0a73aa2a75fedb)
- Use labels by default [`ec21326`](https://github.com/fomantic/Fomantic-UI/commit/ec2132601f0d52d165baddbdbd7a4a6fbcc22c5e)
- Use real flex for vertical menu [`883bcbd`](https://github.com/fomantic/Fomantic-UI/commit/883bcbda5ef0c5137bdf0bf4702f4b47b714b68e)
- Use single quotes for string literals [`ab535ba`](https://github.com/fomantic/Fomantic-UI/commit/ab535ba375e71e27aa41026e45b7aa4857d8c060)
- Use slightly more performant triggerHandler for pub/sub [`ecbfa1d`](https://github.com/fomantic/Fomantic-UI/commit/ecbfa1de9391d51173e1901e6e2e3167a7f138f1)
- Use slightly more performant triggerHandler, fix RLSNOTES [`747fe4b`](https://github.com/fomantic/Fomantic-UI/commit/747fe4bef8a1becfe87f14633d9b7ab47054f463)
- Username typo [`5cc4070`](https://github.com/fomantic/Fomantic-UI/commit/5cc40709fce2aac69b99c115459ab670846e3508)
- Uses floating shadow for popup, fixes mobile issues with reflow [`0e883ff`](https://github.com/fomantic/Fomantic-UI/commit/0e883ff404d58d800d8d525bf5f7b442abb9fe90)
- Var typo [`03f38f8`](https://github.com/fomantic/Fomantic-UI/commit/03f38f8487a92a7b7bd85345576c1a6fda6d6367)
- Variable name mismatch [`#2139`](https://github.com/fomantic/Fomantic-UI/issues/2139)  [`85d66ba`](https://github.com/fomantic/Fomantic-UI/commit/85d66bad45d35b431775ac333a8c8a1c727a791b)
- Variables now in chroma order, adds violet [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280)  [`6edcf51`](https://github.com/fomantic/Fomantic-UI/commit/6edcf5198a9302f34e956a3a967d9caf39c61c15)
- Various fixes to grid/menu [`d1c5672`](https://github.com/fomantic/Fomantic-UI/commit/d1c5672befe9dbc6c88943a53fb7e525c3fce7f3)
- Verifies context functionality [`738b896`](https://github.com/fomantic/Fomantic-UI/commit/738b8969aee692094f899c3ec77b24c2fb71674b)
- Version [`23a7efa`](https://github.com/fomantic/Fomantic-UI/commit/23a7efa3719dbab4d97a7c87b5bdea75179cf9cd)
- Version bump to 2.2.13 [`976a31e`](https://github.com/fomantic/Fomantic-UI/commit/976a31e23c44619d60ac19789eaadfd92737fd44)
- Version change [`f9b71d9`](https://github.com/fomantic/Fomantic-UI/commit/f9b71d970a1b47cddc9282c0c2c9e37db88ad81b)
- Version uptick [`b7bc2bc`](https://github.com/fomantic/Fomantic-UI/commit/b7bc2bce8f79d9b875d8e3e19b81ff40de21a01d)
- Version uptick and build [`efcf2ea`](https://github.com/fomantic/Fomantic-UI/commit/efcf2eabab3dc3a543c8e724b778bff40df11aec)
- Version uptick and package building [`fa114f2`](https://github.com/fomantic/Fomantic-UI/commit/fa114f2c43d81db1eaa679c8eeb8c13ea06b9b0e)
- Vertical list sizes are now relative [`6339d6c`](https://github.com/fomantic/Fomantic-UI/commit/6339d6cd7e5ce99f5900c4d042cda6a73cebc3d5)
- Vertical padding on basic accordion [`bb9bfba`](https://github.com/fomantic/Fomantic-UI/commit/bb9bfbab1dee5e21635e2f550f22274ed15e43b1)
- Visibility now watches for images loading and automatically refreshes afterward [`fad2d1b`](https://github.com/fomantic/Fomantic-UI/commit/fad2d1b57c6247d1da9cdc6678005dc04ff5e413)
- Visibility type: fixed now properly tears down on destroy [`#3548`](https://github.com/fomantic/Fomantic-UI/issues/3548)  [`ad8fb89`](https://github.com/fomantic/Fomantic-UI/commit/ad8fb89ec3ae21b59a474e57d72115f7d65b260c)
- Visible transition can now be triggered by class name only [`2671fff`](https://github.com/fomantic/Fomantic-UI/commit/2671fff60b17fcc1db148a907b25878b6cb0b937)
- WIP transition fixes for detection [`53584d8`](https://github.com/fomantic/Fomantic-UI/commit/53584d83be896ad434fb879f47b99bfe55afdc2f)
- Wasted day of noodling over rendering, and dealing with indeterminate state issues [`8926012`](https://github.com/fomantic/Fomantic-UI/commit/8926012364bdf6e7f78edf8730ebbcd467250e9a)
- Watch now compiles concat again [`74a52c5`](https://github.com/fomantic/Fomantic-UI/commit/74a52c5b305584ed613d9c7a3b57f5875915205f)
- Whitespace in comment banners [`bf8adfb`](https://github.com/fomantic/Fomantic-UI/commit/bf8adfb42d96b39ffe06e8e7d137eb9f41092d56)
- Work in progress commit of UI list variables [`1b7e00f`](https://github.com/fomantic/Fomantic-UI/commit/1b7e00f96889500d8950cdbe76edd7dc16519640)
- Work on API, and related behaviors [`d5bd827`](https://github.com/fomantic/Fomantic-UI/commit/d5bd827f151b353ef77a02fa60d2038bfba8ef25)
- Work on examples [`14b1a4f`](https://github.com/fomantic/Fomantic-UI/commit/14b1a4feab97b8d434e4956575187e3bee983dd8)
- Work on rating and tab updates. Tab documentation [`90b9f81`](https://github.com/fomantic/Fomantic-UI/commit/90b9f818c9e8294e0ff065eee3208d913ad4eb98)
- Work on ui input fixes [`0e127ea`](https://github.com/fomantic/Fomantic-UI/commit/0e127ea0b8476b8b6f0ca7d60412bcb37ae11725)
- Working on cards [`42bf450`](https://github.com/fomantic/Fomantic-UI/commit/42bf450d279b523824f7189293ee7e8a7adb86ed)
- Working on fixes for sidebar animations on mobile with changes to fixed. Updating breadcrumb docs [`9a1e04b`](https://github.com/fomantic/Fomantic-UI/commit/9a1e04bc08c9632230aa4b31613fff7139e1b1bc)
- Working on icon rewrite [`615a5be`](https://github.com/fomantic/Fomantic-UI/commit/615a5be6ea61641e5946123a121fcfeee72464d9)
- Working on inheritance flow for themes [`c0863a2`](https://github.com/fomantic/Fomantic-UI/commit/c0863a2a9c1b82af30352d1960a9e52f2babac9e)
- Working on sidebar rewrite [`a433a78`](https://github.com/fomantic/Fomantic-UI/commit/a433a781a46010a6f7cfc97520ee6869dabb3a77)
- Working on solve for IE11 dropdown issues, adding test case [`d772cd8`](https://github.com/fomantic/Fomantic-UI/commit/d772cd85c4400f04e8091805f04de32d8efa98af)
- Working on tab performance, and rewrite to allow for multiple tab groups to use HTML5 state together. CSS Variables for transitions [`5d14059`](https://github.com/fomantic/Fomantic-UI/commit/5d14059e681d4de96240b195184aba9f0755b092)
- Wow i suck [`d481304`](https://github.com/fomantic/Fomantic-UI/commit/d48130406f4d2b9bb370fc8d9be6aee8e6c197a5)
- Wrap more async into tasks [`a0887bb`](https://github.com/fomantic/Fomantic-UI/commit/a0887bbad729c2a7772937744375de8f0f159e36)
- Wrong boolean [`#1432`](https://github.com/fomantic/Fomantic-UI/issues/1432) #1417 [`20316e7`](https://github.com/fomantic/Fomantic-UI/commit/20316e73c4d73a8ed53f83085fdd62ef37847758)
- [`#1097`](https://github.com/fomantic/Fomantic-UI/issues/1097) Fixes issue with Piled Segment [`c984cce`](https://github.com/fomantic/Fomantic-UI/commit/c984ccefc32bd7ac59bbfd5485c5d4f019f27837)
- [`#1134`](https://github.com/fomantic/Fomantic-UI/issues/1134) issue with ui input not having valign but using table-cell [`d819d74`](https://github.com/fomantic/Fomantic-UI/commit/d819d74132cefca9aef5cd942c6f877772dd6e2e)
- [`#1214`](https://github.com/fomantic/Fomantic-UI/issues/1214)  Adds floated content to dropdown, adds description [`07eaacd`](https://github.com/fomantic/Fomantic-UI/commit/07eaacd1b98a26402f56aea2cb62b7e3dcbc1fdb)
- [`#1252`](https://github.com/fomantic/Fomantic-UI/issues/1252) Add fix for IE not obeying transform context [`753c587`](https://github.com/fomantic/Fomantic-UI/commit/753c587311c1f965c0d87377b6856ecc354e2a86)
- [`#1261`](https://github.com/fomantic/Fomantic-UI/issues/1261)  remove protocol from font loader [`327c9a6`](https://github.com/fomantic/Fomantic-UI/commit/327c9a6f2eaf036c7e9ee5e98a154b80e13aa029)
- [`#1272`](https://github.com/fomantic/Fomantic-UI/issues/1272)  another typo (too long a day) [`a28c218`](https://github.com/fomantic/Fomantic-UI/commit/a28c218ca366d831a2d927a056ef4acd93139ae7)
- [`#1273`](https://github.com/fomantic/Fomantic-UI/issues/1273)  loosen strictness of floats in list. Require word order, stat, header, list [`b59ac59`](https://github.com/fomantic/Fomantic-UI/commit/b59ac593b89136504ca24653615620ad83e0e68c)
- [`#1277`](https://github.com/fomantic/Fomantic-UI/issues/1277) remove cookie.js inlined dependency [`344870b`](https://github.com/fomantic/Fomantic-UI/commit/344870be142c89f90bed2acfd96ac474b5d92150)
- [`#1309`](https://github.com/fomantic/Fomantic-UI/issues/1309) Progress now continuously updates progress bar labels during animations at 30fps [`5099530`](https://github.com/fomantic/Fomantic-UI/commit/5099530e92cb8b80bd30176675ca2315d71c616e)
- [`#1355`](https://github.com/fomantic/Fomantic-UI/issues/1355) breaks up input variables [`1e2caa1`](https://github.com/fomantic/Fomantic-UI/commit/1e2caa10298bd569391f3b2a66c07f5920a7df99)
- [`#1369`](https://github.com/fomantic/Fomantic-UI/issues/1369) Popups should not preserve content by default [`ca3a301`](https://github.com/fomantic/Fomantic-UI/commit/ca3a3013a68eb005965e9a34df4ecff4eedefbdf)
- [`#1372`](https://github.com/fomantic/Fomantic-UI/issues/1372) Better fix for rem/em issue [`308bf2b`](https://github.com/fomantic/Fomantic-UI/commit/308bf2b9fa0d2005592b26a810a618785017ad45)
- [`#1377`](https://github.com/fomantic/Fomantic-UI/issues/1377) Fixes link formatting inside item to be less broad [`650a882`](https://github.com/fomantic/Fomantic-UI/commit/650a88208cf685948a7db25f44db22ade6168920)
- [`#1380`](https://github.com/fomantic/Fomantic-UI/issues/1380) #1138 Adds better event binding to dimmer for multiple open modals [`6e0fa16`](https://github.com/fomantic/Fomantic-UI/commit/6e0fa165e4899f43398ccda9223b55b695a94ed0)
- [`#1395`](https://github.com/fomantic/Fomantic-UI/issues/1395)  adds setting for limiting values above/below bounds [`1c3f4f0`](https://github.com/fomantic/Fomantic-UI/commit/1c3f4f0a09a99af9edb0c68d57ad987ee5cfa0e8)
- [`#1417`](https://github.com/fomantic/Fomantic-UI/issues/1417) #1432 #1420, typo in failSafe, should be useFailSafe. Adds animation queueing as a setting for modal [`04b63bf`](https://github.com/fomantic/Fomantic-UI/commit/04b63bfa106a8c4d2e7646390384b62c4e23a76f)
- [`#1425`](https://github.com/fomantic/Fomantic-UI/issues/1425) Add svg compatibility with ui image [`b53f2d1`](https://github.com/fomantic/Fomantic-UI/commit/b53f2d1fcb0b2c297d2bc453d17f494ebc3fc154)
- [`#1425`](https://github.com/fomantic/Fomantic-UI/issues/1425) adds svg to all image variations [`d912d06`](https://github.com/fomantic/Fomantic-UI/commit/d912d06eeb2fe298220f9baa11f9f441877cd6ab)
- [`#1470`](https://github.com/fomantic/Fomantic-UI/issues/1470)  remove popup should not error if called without popup [`135ff9e`](https://github.com/fomantic/Fomantic-UI/commit/135ff9ee0ee94b117ac53341b2a254a48d312318)
- [`#1475`](https://github.com/fomantic/Fomantic-UI/issues/1475)  quick fix before flexbox merge for dropdown hover [`f0109a0`](https://github.com/fomantic/Fomantic-UI/commit/f0109a06acd810062dd5b373af1e24af798d3aa5)
- [`#1476`](https://github.com/fomantic/Fomantic-UI/issues/1476)  adds error on no src path, gulp watch [`7234d60`](https://github.com/fomantic/Fomantic-UI/commit/7234d604ccd2a7c2d2607fef8564d5d57c8cd390)
- [`#1476`](https://github.com/fomantic/Fomantic-UI/issues/1476)  maintainer: watch now watches for changes in definition (regression in 0.13.0) [`ef2cfc4`](https://github.com/fomantic/Fomantic-UI/commit/ef2cfc4c3d72902c35b4dbbf833b03bbe3241a55)
- [`#1483`](https://github.com/fomantic/Fomantic-UI/issues/1483)  Fix bug with webkit button rollovers. Remove stale code of unknown origin related to position:relative on hover [`adfd541`](https://github.com/fomantic/Fomantic-UI/commit/adfd5417504e777985fc171e116e5c1cf08007f9)
- [`#1484`](https://github.com/fomantic/Fomantic-UI/issues/1484) #1403 #1261, default to HTTPS [`f771e31`](https://github.com/fomantic/Fomantic-UI/commit/f771e315da3c1d2c9405852921d23105f39e3789)
- [`#1495`](https://github.com/fomantic/Fomantic-UI/issues/1495)  stackable grid no longer uses negative margins. [`bac826a`](https://github.com/fomantic/Fomantic-UI/commit/bac826a5a2e55b20acf2ce9e218221ffc0b9c4c8)
- [`#1501`](https://github.com/fomantic/Fomantic-UI/issues/1501) Fix componentGlob when no components set [`7860d1c`](https://github.com/fomantic/Fomantic-UI/commit/7860d1c6fe5c0c65797b70c600f559731e0ba020)
- [`#1501`](https://github.com/fomantic/Fomantic-UI/issues/1501) semantic.json.example components should be absent not empty [`e38b77a`](https://github.com/fomantic/Fomantic-UI/commit/e38b77ab7f698cdb1d2ed8e033c6777e4105d864)
- [`#1509`](https://github.com/fomantic/Fomantic-UI/issues/1509) remove media query from ios scroll to support landscape ipad [`2ca95bb`](https://github.com/fomantic/Fomantic-UI/commit/2ca95bb4e8a97a76ca4f0eb8cd35b8b5646f98f3)
- [`#1549`](https://github.com/fomantic/Fomantic-UI/issues/1549) remove england alias from flag [`0a7e2cb`](https://github.com/fomantic/Fomantic-UI/commit/0a7e2cbbdfae95367ae525d625260f9fb23bdc56)
- [`#1587`](https://github.com/fomantic/Fomantic-UI/issues/1587) Fix bottom attached rule to only apply to next bottom attached, or multiple bottom attached [`d8bb137`](https://github.com/fomantic/Fomantic-UI/commit/d8bb1379c176c6bedc2a7b6777fa933cca7fc357)
- [`#1594`](https://github.com/fomantic/Fomantic-UI/issues/1594)  Fix element blur on popup hide [`7156e4d`](https://github.com/fomantic/Fomantic-UI/commit/7156e4d67a8adbdd8f6c920b9abde8b03ad85a1a)
- [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607) Fix components without assets not creating manifest lists correctly [`052d074`](https://github.com/fomantic/Fomantic-UI/commit/052d0743583a929cfbe0c5812f0548d2a3c924a4)
- [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607) Meteor version uses global version from package.json [`bf30fe0`](https://github.com/fomantic/Fomantic-UI/commit/bf30fe0e9f0fb1189a3b066282ea4cc99438c9c8)
- [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607) Regexp formatting [`6079676`](https://github.com/fomantic/Fomantic-UI/commit/6079676eb5d82a1709a482a9b1467d4de6db6461)
- [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607) Removes a bunch of files from addfiles [`5603db5`](https://github.com/fomantic/Fomantic-UI/commit/5603db5398ff7536ff2b15f9dacd12ca1df6c1b8)
- [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607) add npm require to package.js templates [`22a2b29`](https://github.com/fomantic/Fomantic-UI/commit/22a2b2901aef01eee458536d7689e7a3791c9b6c)
- [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607) formatting [`db25fb6`](https://github.com/fomantic/Fomantic-UI/commit/db25fb6f166beab19df01f48d360cb5b2cdad4db)
- [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607) missing theme.less from LESS repo [`6e6f6cd`](https://github.com/fomantic/Fomantic-UI/commit/6e6f6cd71c641ec6306d68c2c0202605b2bd0e53)
- [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607) remove client typo in package.js [`5e372c3`](https://github.com/fomantic/Fomantic-UI/commit/5e372c394d9b4dfdfb3aee7a4b52536b045c545f)
- [`#1612`](https://github.com/fomantic/Fomantic-UI/issues/1612) adds deprecation warnings for old callbacks [`b50c7da`](https://github.com/fomantic/Fomantic-UI/commit/b50c7da845460799fcaaa8eba23974fcc30abc57)
- [`#1613`](https://github.com/fomantic/Fomantic-UI/issues/1613)  Proper Fix for http [`ddc6c2c`](https://github.com/fomantic/Fomantic-UI/commit/ddc6c2ccc26875511239882421dc3f1cb263e24f)
- [`#1619`](https://github.com/fomantic/Fomantic-UI/issues/1619) fix columns to not be flex containers [`44328b5`](https://github.com/fomantic/Fomantic-UI/commit/44328b51d4b69747fa4ef5ca23ff5b7c6274d06f)
- [`#1630`](https://github.com/fomantic/Fomantic-UI/issues/1630) - Form set values will now validate forms after value set [`c8a203b`](https://github.com/fomantic/Fomantic-UI/commit/c8a203b3132fb1577a743b012fb460488a348155)
- [`#1630`](https://github.com/fomantic/Fomantic-UI/issues/1630) - Formatting on form serialize [`1bb3fe0`](https://github.com/fomantic/Fomantic-UI/commit/1bb3fe04ef263a5c2a33b1867ae6f1994961f0ab)
- [`#1630`](https://github.com/fomantic/Fomantic-UI/issues/1630) Adds form clear and dropdown clear behaviors [`7dffde0`](https://github.com/fomantic/Fomantic-UI/commit/7dffde0f825e723245d8415a14ec0497eaa60892)
- [`#1645`](https://github.com/fomantic/Fomantic-UI/issues/1645) Fix default component inheritance from defaults [`de4fef9`](https://github.com/fomantic/Fomantic-UI/commit/de4fef91e0b6737f67598bd2d6db158d11762a4f)
- [`#1655`](https://github.com/fomantic/Fomantic-UI/issues/1655) #1687 Collapsing margin on pusher inherits child margins [`de524c1`](https://github.com/fomantic/Fomantic-UI/commit/de524c134d24e14f0183aa38c68760548e8757de)
- [`#1681`](https://github.com/fomantic/Fomantic-UI/issues/1681)  Form now prevents keypress causing repeated form submit [`90992d9`](https://github.com/fomantic/Fomantic-UI/commit/90992d94b8e00a769ee0cf5ddc83be14bca7ab3c)
- [`#1683`](https://github.com/fomantic/Fomantic-UI/issues/1683)  iOS and Mobile match return false on 2nd+ matches due to use of regexp test [`2b79648`](https://github.com/fomantic/Fomantic-UI/commit/2b79648a11a56cda10c4838df295ff0ea5da92fa)
- [`#1687`](https://github.com/fomantic/Fomantic-UI/issues/1687) Clicking on fixed elements no longer closes sidebar [`d5d0a25`](https://github.com/fomantic/Fomantic-UI/commit/d5d0a25069f31cf083b144eaad01603e0232aa5c)
- [`#1698`](https://github.com/fomantic/Fomantic-UI/issues/1698) Remove basic modal border radius [`ecc121f`](https://github.com/fomantic/Fomantic-UI/commit/ecc121fc1ff90e62701b43f78985c22c2c4db5df)
- [`#1698`](https://github.com/fomantic/Fomantic-UI/issues/1698) Remove set.value calls from actions, add set value to set selected. [`3cf2db6`](https://github.com/fomantic/Fomantic-UI/commit/3cf2db6a4bfe5994a59e8dbbac394680f2c1fff5)
- [`#1709`](https://github.com/fomantic/Fomantic-UI/issues/1709)  force table-cell on ui labeled input, ui action input [`45b00b9`](https://github.com/fomantic/Fomantic-UI/commit/45b00b9fb930a19faba2bb60ce7586a86e235024)
- [`#1724`](https://github.com/fomantic/Fomantic-UI/issues/1724)  make sure any method invocation forces position recalculation in visibility api [`159ccfc`](https://github.com/fomantic/Fomantic-UI/commit/159ccfc879568ad0b1c520019deb9ff488ea6d85)
- [`#1724`](https://github.com/fomantic/Fomantic-UI/issues/1724) Added support for sub menus to check upward/downward independently of main menu, fix some styling on upward and left menu [`073f561`](https://github.com/fomantic/Fomantic-UI/commit/073f561ab2a291faf3d2073c66be91dca0bd2fc8)
- [`#1724`](https://github.com/fomantic/Fomantic-UI/issues/1724) Implements dropdown automatically changes direction when off screen using visibility api coupling [`58544f6`](https://github.com/fomantic/Fomantic-UI/commit/58544f6ca3413ccda04471609d255003f6192c83)
- [`#1724`](https://github.com/fomantic/Fomantic-UI/issues/1724) Minor fixes [`d3c1928`](https://github.com/fomantic/Fomantic-UI/commit/d3c192803347c1e631b31f874390f5b29c4b7866)
- [`#1724`](https://github.com/fomantic/Fomantic-UI/issues/1724) Remove debug, fix scrollTop [`4e73329`](https://github.com/fomantic/Fomantic-UI/commit/4e73329cfffc0b1baa9ce953981decb64a008a75)
- [`#1724`](https://github.com/fomantic/Fomantic-UI/issues/1724) err actualyl remove debug [`eb9f6f8`](https://github.com/fomantic/Fomantic-UI/commit/eb9f6f83ec8a37058e702cde16073fdbd6fa983c)
- [`#1729`](https://github.com/fomantic/Fomantic-UI/issues/1729)  Add cart aliases [`981cba6`](https://github.com/fomantic/Fomantic-UI/commit/981cba6405771de030a435d0eb4419c7332ceed7)
- [`#1729`](https://github.com/fomantic/Fomantic-UI/issues/1729)  Order by UTF, add aliases, icon naming [`dc144c5`](https://github.com/fomantic/Fomantic-UI/commit/dc144c5e5e1a2e94da4a6d0c612b2bdf3cbac135)
- [`#1729`](https://github.com/fomantic/Fomantic-UI/issues/1729) More icon renaming, aliases [`66c2412`](https://github.com/fomantic/Fomantic-UI/commit/66c2412137c91fc411018f90ee25c76fe138e418)
- [`#1753`](https://github.com/fomantic/Fomantic-UI/issues/1753)  Dropdown arrow is now clickable to hide dropdown in search selection dropdown [`3cb07f0`](https://github.com/fomantic/Fomantic-UI/commit/3cb07f0c8547ff665d31b690a878069f5791e29c)
- [`#1753`](https://github.com/fomantic/Fomantic-UI/issues/1753) #1368 Adds forceSelection option to force user to current search selection when element blurred [`4870dad`](https://github.com/fomantic/Fomantic-UI/commit/4870dad08611a46a6e7e8427aa5b11086e4e72cb)
- [`#1754`](https://github.com/fomantic/Fomantic-UI/issues/1754)  Fixes namespace being called out of order in transition init [`5653f6f`](https://github.com/fomantic/Fomantic-UI/commit/5653f6ff0911b63a07edae792172b14eafbff292)
- [`#1755`](https://github.com/fomantic/Fomantic-UI/issues/1755) #1744, adds additional variables for loading button, makes pointer events disabled in default theme [`f1b9da3`](https://github.com/fomantic/Fomantic-UI/commit/f1b9da3ce1774994a900d50401c2f9f8866bcce8)
- [`#1771`](https://github.com/fomantic/Fomantic-UI/issues/1771)  specificity match [`37757ca`](https://github.com/fomantic/Fomantic-UI/commit/37757ca6355b29a65341fdd5e33418df9bcf3145)
- [`#1771`](https://github.com/fomantic/Fomantic-UI/issues/1771) Fixes sidebar in IE with context. Makes all sidebar use position: absolute, instead of transform fix when not initialized in body [`4e71ee4`](https://github.com/fomantic/Fomantic-UI/commit/4e71ee417cb3a3d8cff311afa19484f5e7ba7c5a)
- [`#1784`](https://github.com/fomantic/Fomantic-UI/issues/1784) Updates Tab remote API syntax with changes in 1.x [`0b9edd1`](https://github.com/fomantic/Fomantic-UI/commit/0b9edd1eda44b5b7714f251848754254db974e7d)
- [`#1794`](https://github.com/fomantic/Fomantic-UI/issues/1794)  checkbox and dropdown now trigger blur event on controlled input [`4e2f0b0`](https://github.com/fomantic/Fomantic-UI/commit/4e2f0b02911d21f96342b06a861fd0d6ed0ebe43)
- [`#1804`](https://github.com/fomantic/Fomantic-UI/issues/1804)  Fix resize logic for scrolling modal to include padding [`dada633`](https://github.com/fomantic/Fomantic-UI/commit/dada633c7f1b025c985f191ab9a253204bb8582c)
- [`#1806`](https://github.com/fomantic/Fomantic-UI/issues/1806)  Add multiple select to set value, get value. [`181066e`](https://github.com/fomantic/Fomantic-UI/commit/181066e055e58516f0543ef426737d75b588e8d5)
- [`#1807`](https://github.com/fomantic/Fomantic-UI/issues/1807)  make labels have segment padding by default [`68f7408`](https://github.com/fomantic/Fomantic-UI/commit/68f740874cf8f7450bb23538ae4bf21f6d352026)
- [`#1814`](https://github.com/fomantic/Fomantic-UI/issues/1814)  Fixes valign inside equal height. Simplifies rules [`417172b`](https://github.com/fomantic/Fomantic-UI/commit/417172be5ab527edca2bc96766d311f306ced8d2)
- [`#1831`](https://github.com/fomantic/Fomantic-UI/issues/1831) #1875 Adds scrollbar size to global variables [`d36f38a`](https://github.com/fomantic/Fomantic-UI/commit/d36f38a55fbf13d4ffc9ddd8c23de86c75d6f287)
- [`#1844`](https://github.com/fomantic/Fomantic-UI/issues/1844) - Fix ui cards &gt; .ui.card to have correct margins, fix consecutive ui cards groups to preserve row spacing [`870794c`](https://github.com/fomantic/Fomantic-UI/commit/870794c9df1adc0e3271a022fe1aca8b7ca32ea5)
- [`#1845`](https://github.com/fomantic/Fomantic-UI/issues/1845)  move wrench to forked dep [`f8e4465`](https://github.com/fomantic/Fomantic-UI/commit/f8e4465e3c0fd5e743ea874ea149ba4a331832dd)
- [`#1845`](https://github.com/fomantic/Fomantic-UI/issues/1845) fix package.json format for git url [`b53005f`](https://github.com/fomantic/Fomantic-UI/commit/b53005f9d059615fad3a4076c9e5f4a03aea8eaf)
- [`#1846`](https://github.com/fomantic/Fomantic-UI/issues/1846) Equal height grids now automatically stretch column child elements to full width [`2bdabbc`](https://github.com/fomantic/Fomantic-UI/commit/2bdabbc1007f657bb4fe8e9f4382a0643529c4cb)
- [`#1853`](https://github.com/fomantic/Fomantic-UI/issues/1853) Fix some composer.json fields [`8da0414`](https://github.com/fomantic/Fomantic-UI/commit/8da0414acdea459563cddc8e174dd9125ce0c792)
- [`#1866`](https://github.com/fomantic/Fomantic-UI/issues/1866) - Adds more intelligent regexp version number replace, preserves component names in banners [`b423847`](https://github.com/fomantic/Fomantic-UI/commit/b42384752d7a644fd2c5b2921e0e5b5e46bc863d)
- [`#1880`](https://github.com/fomantic/Fomantic-UI/issues/1880) Fixes modal showing while another hiding unsucessfully attaches callback to 'hide others'. Dimmer no longer hides between modals appearances with allowMultiple [`aac5321`](https://github.com/fomantic/Fomantic-UI/commit/aac5321d47860d2fd3d3359292ad75187239ee3a)
- [`#1889`](https://github.com/fomantic/Fomantic-UI/issues/1889) serializeForm produces unnecessary error [`d3b4315`](https://github.com/fomantic/Fomantic-UI/commit/d3b43154138a5bd697cd3011aad79d002562b41a)
- [`#1894`](https://github.com/fomantic/Fomantic-UI/issues/1894) Fix basic icon paths to not try to load woff2, add src variable [`0d39fd6`](https://github.com/fomantic/Fomantic-UI/commit/0d39fd6637ce195e5cbc3a91cae0b04cbf3d06b4)
- [`#1896`](https://github.com/fomantic/Fomantic-UI/issues/1896)  add 'get id' to all modules with element namespace, move uniqueID generation to 'create id' [`91b2ffd`](https://github.com/fomantic/Fomantic-UI/commit/91b2ffdf49ee441eb7cd56beb0740d375e13fbe1)
- [`#1896`](https://github.com/fomantic/Fomantic-UI/issues/1896)  move over to element namespace [`7c839c9`](https://github.com/fomantic/Fomantic-UI/commit/7c839c938a4477765947e824cf69442d48ce48b4)
- [`#1896`](https://github.com/fomantic/Fomantic-UI/issues/1896) Add elementNamespace to other document/context events [`59e2f98`](https://github.com/fomantic/Fomantic-UI/commit/59e2f986ce4dc646856404589d275b6969ae8b1c)
- [`#1897`](https://github.com/fomantic/Fomantic-UI/issues/1897) removes log [`a5052e4`](https://github.com/fomantic/Fomantic-UI/commit/a5052e4db68f91f9dd0b4c395921e908378fbcc2)
- [`#1905`](https://github.com/fomantic/Fomantic-UI/issues/1905) min-width issue on material theme [`38f5993`](https://github.com/fomantic/Fomantic-UI/commit/38f59932ebcf30254dd9227f2209eac8b42ed1e7)
- [`#1908`](https://github.com/fomantic/Fomantic-UI/issues/1908) accordion can now specify a triggering element that is not title [`b4d0b8f`](https://github.com/fomantic/Fomantic-UI/commit/b4d0b8f3ecbae615a87928d123f962fd4313eefb)
- [`#1919`](https://github.com/fomantic/Fomantic-UI/issues/1919) Fixes issue with minification [`b5a5d9c`](https://github.com/fomantic/Fomantic-UI/commit/b5a5d9cb6961246b0bbf111b33adf9a904355674)
- [`#1927`](https://github.com/fomantic/Fomantic-UI/issues/1927)  remove transform from tnansition [`4862d43`](https://github.com/fomantic/Fomantic-UI/commit/4862d4369e5fe2ca14345e72c07f83eb85561471)
- [`#1927`](https://github.com/fomantic/Fomantic-UI/issues/1927) adds back in transform [`209db36`](https://github.com/fomantic/Fomantic-UI/commit/209db36bf20507dadc5d4a50d09f4ebbf7903a2e)
- [`#1933`](https://github.com/fomantic/Fomantic-UI/issues/1933)  more optimizations for sidebar [`243243a`](https://github.com/fomantic/Fomantic-UI/commit/243243a78a38c8ae591b639447a4c6fdfa3d930c)
- [`#1933`](https://github.com/fomantic/Fomantic-UI/issues/1933) Cache width/height/isRTL on load to improve animation performance of sidebar [`e064401`](https://github.com/fomantic/Fomantic-UI/commit/e064401708f15988ae1828557256ea11fb263431)
- [`#1968`](https://github.com/fomantic/Fomantic-UI/issues/1968) Fixes undetachable scrollable modal in ideal circumstances (not inside a container with z-index) [`d9850a0`](https://github.com/fomantic/Fomantic-UI/commit/d9850a0ba64fa879ac7fa87dc449acc5f69b36ff)
- [`#1987`](https://github.com/fomantic/Fomantic-UI/issues/1987) #1916 #1912 Correctly fixes onChange to fire only when value is adjusted [`bbcbf56`](https://github.com/fomantic/Fomantic-UI/commit/bbcbf5673d5b6ee6511c061d87b6e22a4fffd9ed)
- [`#1996`](https://github.com/fomantic/Fomantic-UI/issues/1996) #1992 issue with calc interpolation in dropdown LESS [`683b5aa`](https://github.com/fomantic/Fomantic-UI/commit/683b5aa5fcb14d181a140093aa925c629f4cc127)
- [`#2001`](https://github.com/fomantic/Fomantic-UI/issues/2001) actually fix icon and positioning [`43d02ea`](https://github.com/fomantic/Fomantic-UI/commit/43d02eac54875065e1b9b0e2cf1553cc9257bd0e)
- [`#2012`](https://github.com/fomantic/Fomantic-UI/issues/2012)  Search should pass along debug to API [`b03c7d3`](https://github.com/fomantic/Fomantic-UI/commit/b03c7d3faf1cfec39067f93fa626411247747765)
- [`#2020`](https://github.com/fomantic/Fomantic-UI/issues/2020) Fixes trim string method being called on non-string dropdown values [`7034230`](https://github.com/fomantic/Fomantic-UI/commit/703423013e7dfbad62c886cf2119e4f05fb9cbcf)
- [`#2041`](https://github.com/fomantic/Fomantic-UI/issues/2041) Adds showonFocus option to dropdown [`87b3cd0`](https://github.com/fomantic/Fomantic-UI/commit/87b3cd08c5c481de631c74150873e44f29ca4c62)
- [`#2042`](https://github.com/fomantic/Fomantic-UI/issues/2042) add delegated events to nag (stupid nag) [`e2593c9`](https://github.com/fomantic/Fomantic-UI/commit/e2593c98af31ced0979359a75d5ffebbacefe610)
- [`#2042`](https://github.com/fomantic/Fomantic-UI/issues/2042) add delegated events to rating [`3520e51`](https://github.com/fomantic/Fomantic-UI/commit/3520e510be79a7bf56f33771c282fd6e905d7cea)
- [`#2042`](https://github.com/fomantic/Fomantic-UI/issues/2042) add delegated events to search [`3f44b1c`](https://github.com/fomantic/Fomantic-UI/commit/3f44b1cad7ec8d25cbf59e4dfa16732add098809)
- [`#2042`](https://github.com/fomantic/Fomantic-UI/issues/2042) add delegated events to video, form. remove debug dimmer [`bfed8b3`](https://github.com/fomantic/Fomantic-UI/commit/bfed8b3a7db276386ee4924e1c140633ed3ce494)
- [`#2042`](https://github.com/fomantic/Fomantic-UI/issues/2042) addes delegated events to dimmer [`cd4cced`](https://github.com/fomantic/Fomantic-UI/commit/cd4cced83a523d97cf4967dff619c471785bcd2b)
- [`#2042`](https://github.com/fomantic/Fomantic-UI/issues/2042) missing delegated selector in search [`04df7b8`](https://github.com/fomantic/Fomantic-UI/commit/04df7b8101536482aa816ddecffa3be3acacd872)
- [`#2046`](https://github.com/fomantic/Fomantic-UI/issues/2046) First pass of grouped icons [`b21a566`](https://github.com/fomantic/Fomantic-UI/commit/b21a5669189999fc878f25d6708bfd66abc55b82)
- [`#2050`](https://github.com/fomantic/Fomantic-UI/issues/2050) - Fix doubling row in doubling grid. fix doubling grid column row [`6ccdc83`](https://github.com/fomantic/Fomantic-UI/commit/6ccdc83c28f1c0f3ee7498dcdb3933629b1e5f25)
- [`#2059`](https://github.com/fomantic/Fomantic-UI/issues/2059) Finish ability to mock responses in API [`e38a168`](https://github.com/fomantic/Fomantic-UI/commit/e38a168448dc0e822ce16eebe60a4b37f4be97fa)
- [`#2060`](https://github.com/fomantic/Fomantic-UI/issues/2060)  clean up debug, remove testing settings [`60db38e`](https://github.com/fomantic/Fomantic-UI/commit/60db38ea72619110fba96e3b4805acc6634ac74a)
- [`#2060`](https://github.com/fomantic/Fomantic-UI/issues/2060) fix escape keyboard shortcut not working correctly, add in debug to search keyboard shortcuts [`39ab200`](https://github.com/fomantic/Fomantic-UI/commit/39ab2002c2e6ec437d59d667ac86a93efb60c425)
- [`#2061`](https://github.com/fomantic/Fomantic-UI/issues/2061) set modal setting defaults, change blurring els [`7074e24`](https://github.com/fomantic/Fomantic-UI/commit/7074e24384403ba19c2ee1121f9aac627421e8c1)
- [`#2065`](https://github.com/fomantic/Fomantic-UI/issues/2065) add clear cache to search [`a0e7ba3`](https://github.com/fomantic/Fomantic-UI/commit/a0e7ba3666269c2a991b8688ad12b29c61737e73)
- [`#2070`](https://github.com/fomantic/Fomantic-UI/issues/2070) - dont continue loop unnecessarily, clarify variable names [`26fe5ba`](https://github.com/fomantic/Fomantic-UI/commit/26fe5ba81c6b3fd155adf870f71e7a3f841ffac6)
- [`#2079`](https://github.com/fomantic/Fomantic-UI/issues/2079) - Fix variable names [`07b83aa`](https://github.com/fomantic/Fomantic-UI/commit/07b83aa01a7d53c1b41efa22445dc30f3d7e287a)
- [`#2079`](https://github.com/fomantic/Fomantic-UI/issues/2079) - Make sure element is in DOM when determining close event [`a50b1ea`](https://github.com/fomantic/Fomantic-UI/commit/a50b1ea1168b1b89f12e945f558f6e7a11379905)
- [`#2083`](https://github.com/fomantic/Fomantic-UI/issues/2083) RLSNOTES [`fd36c1e`](https://github.com/fomantic/Fomantic-UI/commit/fd36c1eb19cee1b75071de2a109e8a51afce8e04)
- [`#2084`](https://github.com/fomantic/Fomantic-UI/issues/2084) setup reference does not query behavior after adjusting selectors [`b063a39`](https://github.com/fomantic/Fomantic-UI/commit/b063a3989665f61b91cd34f654fb60ef4989efbe)
- [`#2092`](https://github.com/fomantic/Fomantic-UI/issues/2092) Add onResponse callback to allow for response transformations [`e441beb`](https://github.com/fomantic/Fomantic-UI/commit/e441bebedd78c23b44604ae25764c4df54228e57)
- [`#2092`](https://github.com/fomantic/Fomantic-UI/issues/2092) RLSNOTES & Cred [`ffdd52b`](https://github.com/fomantic/Fomantic-UI/commit/ffdd52b9b053c74c12a72f50a11771c6dd159c68)
- [`#2101`](https://github.com/fomantic/Fomantic-UI/issues/2101) finish fix for npm install [`2df4e82`](https://github.com/fomantic/Fomantic-UI/commit/2df4e8232af5c64e175ff2c0439d982ac052d134)
- [`#2117`](https://github.com/fomantic/Fomantic-UI/issues/2117) #2096 backports fluid input fix to 1.x channel [`c051338`](https://github.com/fomantic/Fomantic-UI/commit/c05133874d38b7f3497cf212ce3fdc749e46f2b3)
- [`#2147`](https://github.com/fomantic/Fomantic-UI/issues/2147) fix sidebar not correctly overflowing when taller than page [`1b3ff05`](https://github.com/fomantic/Fomantic-UI/commit/1b3ff0538a85cfe84f57b1d0dc4b43123e53e8eb)
- [`#2153`](https://github.com/fomantic/Fomantic-UI/issues/2153)  fix stacked tables from removing sortable/warning/error styles. Add selectable table variation #1803 [`257be28`](https://github.com/fomantic/Fomantic-UI/commit/257be28220d6dc96db061af8a8707ffd414f5bbd)
- [`#2163`](https://github.com/fomantic/Fomantic-UI/issues/2163)  #2162. Create id now uses counters for index, in case results are returned as object instead of array [`1d481d2`](https://github.com/fomantic/Fomantic-UI/commit/1d481d23be975a08193a3ee33705a99d3ae2f9a2)
- [`#2163`](https://github.com/fomantic/Fomantic-UI/issues/2163) Logic error [`0498b4d`](https://github.com/fomantic/Fomantic-UI/commit/0498b4d405ef40c0c35277e113fc5bf2247c1da5)
- [`#2165`](https://github.com/fomantic/Fomantic-UI/issues/2165) adds parseScripts option to tabs, defaults to once [`994fedc`](https://github.com/fomantic/Fomantic-UI/commit/994fedcca9eb22abe5a9924c812e6bb2f2c06ad6)
- [`#2173`](https://github.com/fomantic/Fomantic-UI/issues/2173)  form does not allow immediate invocation of behaviors in 2.0 [`04c4fde`](https://github.com/fomantic/Fomantic-UI/commit/04c4fde067423dc438b7572dbb1d8e9036947953)
- [`#2175`](https://github.com/fomantic/Fomantic-UI/issues/2175) Form set value should not automatically validate form [`ec853a6`](https://github.com/fomantic/Fomantic-UI/commit/ec853a6affc27610bbac4efd0562e63d62afe1c1)
- [`#2180`](https://github.com/fomantic/Fomantic-UI/issues/2180) Remove repeat dom value lookups [`50ec6f7`](https://github.com/fomantic/Fomantic-UI/commit/50ec6f7b5ebf3ccebeb47b7651a4d6d3829fb7d6)
- [`#2180`](https://github.com/fomantic/Fomantic-UI/issues/2180) one last missing value [`8a94965`](https://github.com/fomantic/Fomantic-UI/commit/8a9496518f0525b1d238edb898a1cbe08078c21f)
- [`#2181`](https://github.com/fomantic/Fomantic-UI/issues/2181)  min width on circular [`e604aef`](https://github.com/fomantic/Fomantic-UI/commit/e604aefa1d026991b0d8132646b7b0de28b4677c)
- [`#2199`](https://github.com/fomantic/Fomantic-UI/issues/2199) Fixes preventDefault called even without sub menu [`89c1138`](https://github.com/fomantic/Fomantic-UI/commit/89c1138cd1bf5fc273c16eef660328515a910de8)
- [`#2213`](https://github.com/fomantic/Fomantic-UI/issues/2213)  user value uses .text.toLowercase() not stored metadata value [`5bcc49a`](https://github.com/fomantic/Fomantic-UI/commit/5bcc49acef9a454377f29a02a6b298672746b3e0)
- [`#2214`](https://github.com/fomantic/Fomantic-UI/issues/2214) Adds different[] validation, match not working correctly [`b9af864`](https://github.com/fomantic/Fomantic-UI/commit/b9af8643417b2bc59e4611995d02e36d86addcc5)
- [`#2218`](https://github.com/fomantic/Fomantic-UI/issues/2218) slightly reduce avatar image size [`b0c6d25`](https://github.com/fomantic/Fomantic-UI/commit/b0c6d25c851352260419cc32422e577df9a22c3c)
- [`#2222`](https://github.com/fomantic/Fomantic-UI/issues/2222) fix phone icon name [`16771df`](https://github.com/fomantic/Fomantic-UI/commit/16771dfe7f4d2fb802ff57654eee4097d176c8b4)
- [`#2237`](https://github.com/fomantic/Fomantic-UI/issues/2237)  [`8d9f4e6`](https://github.com/fomantic/Fomantic-UI/commit/8d9f4e684156e4f62f5ff8c2a2e65cb657d7949e)
- [`#2259`](https://github.com/fomantic/Fomantic-UI/issues/2259) - Fix get selection value returns 1 when null [`01e9f39`](https://github.com/fomantic/Fomantic-UI/commit/01e9f39242d4afa8a8b738ee060dbe750c6ce78e)
- [`#2263`](https://github.com/fomantic/Fomantic-UI/issues/2263)  tweaking inverted pointing [`d16290e`](https://github.com/fomantic/Fomantic-UI/commit/d16290eb87ad16799ff2bb657b4bd6cb8b9598e4)
- [`#2264`](https://github.com/fomantic/Fomantic-UI/issues/2264)  add focus colors to site, add focus rules for all possible button styles [`d7f7bab`](https://github.com/fomantic/Fomantic-UI/commit/d7f7babd314e6647925685f23de96fa3526980ac)
- [`#2266`](https://github.com/fomantic/Fomantic-UI/issues/2266)  minCharacterLength should be part of query, not throttled input event [`f1b8455`](https://github.com/fomantic/Fomantic-UI/commit/f1b84555cb98998e395a8dcd9fff0b8563a48ca0)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280)  add brown button styles for testing color [`e20b456`](https://github.com/fomantic/Fomantic-UI/commit/e20b456f66a80b69b8c1bac9feea5b5f14dc5671)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280) Add colored variations for labels [`70a87a2`](https://github.com/fomantic/Fomantic-UI/commit/70a87a20202e1eaacaad1ea89e532d019f01b181)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280) Add grey, make sure colored buttons use variable to determine text color swapping [`85e7956`](https://github.com/fomantic/Fomantic-UI/commit/85e7956928a4d104e9a926ceffd11ae4585e95a5)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280) Add icon color variations, fix bordered icon line height [`08f301c`](https://github.com/fomantic/Fomantic-UI/commit/08f301ccb595c1abe67f333de4374c66f38e50ec)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280) Add olive color, add other missing header colors [`b145912`](https://github.com/fomantic/Fomantic-UI/commit/b145912c6baa488dd5a5e8029b71785691e86b8c)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280) Add table colors [`348bd56`](https://github.com/fomantic/Fomantic-UI/commit/348bd56beddcd653caff3972f737eaf9cb886a22)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280) Fix segment colors [`8eb3a6b`](https://github.com/fomantic/Fomantic-UI/commit/8eb3a6bbd1498ef0ecf1f18049d587a587813446)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280) Grid colors, and reduce ruleset [`183679b`](https://github.com/fomantic/Fomantic-UI/commit/183679b11f32deb40d1a6bba78868e172fa6eff8)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280) Order message colors and add missing colors [`ac647e8`](https://github.com/fomantic/Fomantic-UI/commit/ac647e8fcb2f0b8e81e36b8344dac430ce3f1919)
- [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280) complete global variables, adjust neutral saturation on hover/down/active [`0b10a55`](https://github.com/fomantic/Fomantic-UI/commit/0b10a5503461ebecaf1e28510083e84b776b3859)
- [`#2287`](https://github.com/fomantic/Fomantic-UI/issues/2287) fix line height of groups [`73b0586`](https://github.com/fomantic/Fomantic-UI/commit/73b05865f93acb9f2b7eb92e82a658e5e2574e6b)
- [`#2288`](https://github.com/fomantic/Fomantic-UI/issues/2288) Fixes label word-wrap issue on dropdown [`ee33d26`](https://github.com/fomantic/Fomantic-UI/commit/ee33d26e36717254dacfc357511f6894d43a3718)
- [`#2288`](https://github.com/fomantic/Fomantic-UI/issues/2288) Typo [`ac2d474`](https://github.com/fomantic/Fomantic-UI/commit/ac2d47462a85e687d45be63a7964ed66701da978)
- [`#2289`](https://github.com/fomantic/Fomantic-UI/issues/2289) - github theme typo [`6e684ab`](https://github.com/fomantic/Fomantic-UI/commit/6e684ab84b4448a1bc8614e64d2dc9286ccedc7d)
- [`#2294`](https://github.com/fomantic/Fomantic-UI/issues/2294) fixes issue with icon line height on sizing [`1949377`](https://github.com/fomantic/Fomantic-UI/commit/1949377434499103d5e3d616a95e07c2007cc3b8)
- [`#2295`](https://github.com/fomantic/Fomantic-UI/issues/2295) Fix loading search showing double loader with icon button [`b11ae77`](https://github.com/fomantic/Fomantic-UI/commit/b11ae774acf7be020be32c0a38c9b763492a5255)
- [`#2299`](https://github.com/fomantic/Fomantic-UI/issues/2299) Fix rtl typo [`701426b`](https://github.com/fomantic/Fomantic-UI/commit/701426bcb37871051b5741f42b707e53a230b4ab)
- [`#2299`](https://github.com/fomantic/Fomantic-UI/issues/2299) fix conditions for RTL both [`283943b`](https://github.com/fomantic/Fomantic-UI/commit/283943bf5c0b39c85f54df82be962c8384e90487)
- [`#2308`](https://github.com/fomantic/Fomantic-UI/issues/2308)  Fix issue with metadata caching prop values [`be5ec63`](https://github.com/fomantic/Fomantic-UI/commit/be5ec6394bdc97c25ca2a2c21f2612159dd1db44)
- [`#2308`](https://github.com/fomantic/Fomantic-UI/issues/2308)  Fix rating module to refresh data attributes as well [`45ff8f8`](https://github.com/fomantic/Fomantic-UI/commit/45ff8f8e10ea6c59a0e4281b7dc1bb113d75c7bb)
- [`#2308`](https://github.com/fomantic/Fomantic-UI/issues/2308) RLSnotes [`ff68bbf`](https://github.com/fomantic/Fomantic-UI/commit/ff68bbff08a65113e1bce2ef748bd43a5af6b389)
- [`#2308`](https://github.com/fomantic/Fomantic-UI/issues/2308) Refactor as getters, to allow public API for retrieval [`544e92d`](https://github.com/fomantic/Fomantic-UI/commit/544e92d279c501e0ee8cdd922943d4bc903550b8)
- [`#2309`](https://github.com/fomantic/Fomantic-UI/issues/2309)  missing line height rule for massive icon [`5fb6c54`](https://github.com/fomantic/Fomantic-UI/commit/5fb6c541b798d55399809f080fad198bef233f63)
- [`#2313`](https://github.com/fomantic/Fomantic-UI/issues/2313)  remove value does not check selection count #2313 [`aadeb1d`](https://github.com/fomantic/Fomantic-UI/commit/aadeb1d437cfe48034915ecde53a9a5f083ab128)
- [`#2316`](https://github.com/fomantic/Fomantic-UI/issues/2316)  incorrect show rules for message in form [`457f9c5`](https://github.com/fomantic/Fomantic-UI/commit/457f9c5868fce946a4ac74493655e7d4139f031d)
- [`#2334`](https://github.com/fomantic/Fomantic-UI/issues/2334)  Re-organize attached code, fix attached button groups [`406a95c`](https://github.com/fomantic/Fomantic-UI/commit/406a95cfc7b444c99fed5ef27baad993255c4dd4)
- [`#2335`](https://github.com/fomantic/Fomantic-UI/issues/2335) Loosen item css for some menu types to allow for work with container. Tweak horizontal labeled icon sizing and spacing [`95702d3`](https://github.com/fomantic/Fomantic-UI/commit/95702d3895fb6e177cb0ca1f4aebb60f8712ffa1)
- [`#2336`](https://github.com/fomantic/Fomantic-UI/issues/2336) Add clearing segment variation [`2c801bc`](https://github.com/fomantic/Fomantic-UI/commit/2c801bcc16e3545280ea2984fc470e051d796899)
- [`#2340`](https://github.com/fomantic/Fomantic-UI/issues/2340)  in cases where context is automatically determined because it was not specified in settings, refresh on resize [`bd8824c`](https://github.com/fomantic/Fomantic-UI/commit/bd8824c11d8811262a29608b63ce9773a7759e2b)
- [`#2343`](https://github.com/fomantic/Fomantic-UI/issues/2343) Mobile container width should be 100% not auto [`a51e8c2`](https://github.com/fomantic/Fomantic-UI/commit/a51e8c2c04365f7f74b7600312872c5586c8005c)
- [`#2353`](https://github.com/fomantic/Fomantic-UI/issues/2353)  last field group should not have bottom margin [`b51de13`](https://github.com/fomantic/Fomantic-UI/commit/b51de13da8bcc4fe6912604ee5776eebce2e10ac)
- [`#2358`](https://github.com/fomantic/Fomantic-UI/issues/2358)  remove component glob from assets [`d0e4f74`](https://github.com/fomantic/Fomantic-UI/commit/d0e4f74cd10ed265abe19e2007be9c4146a82201)
- [`#2366`](https://github.com/fomantic/Fomantic-UI/issues/2366)  fixes when sticky content is larger than context height. Fixes margin bottom not clearing when pushing: true [`629eeff`](https://github.com/fomantic/Fomantic-UI/commit/629eeff8928b89168142fbaaa226c03bc19475a0)
- [`#2366`](https://github.com/fomantic/Fomantic-UI/issues/2366)  rail now uses border-box to ensure that height matches container by default. Added sizing variables for calculating width with padding [`c6a5e97`](https://github.com/fomantic/Fomantic-UI/commit/c6a5e97eed1c26b85e1cc7fb586b03f5e836a1c0)
- [`#2374`](https://github.com/fomantic/Fomantic-UI/issues/2374)  Dont set height of textarea with rows set [`f2623de`](https://github.com/fomantic/Fomantic-UI/commit/f2623de766a27fe2188bb756cb7f438f33a3f5d0)
- [`#2375`](https://github.com/fomantic/Fomantic-UI/issues/2375) Remove number variations from button [`a7e4c00`](https://github.com/fomantic/Fomantic-UI/commit/a7e4c00e88ae857d93ffc328e733f906fdf4b712)
- [`#2382`](https://github.com/fomantic/Fomantic-UI/issues/2382) Increase code coherence, restructure into new methods [`e3d4347`](https://github.com/fomantic/Fomantic-UI/commit/e3d43478b980204005139807bb19c2cb50dc8130)
- [`#2383`](https://github.com/fomantic/Fomantic-UI/issues/2383) Fix remove selected, and issues with placeholder selections being selected with multiple when value is empty string [`59ecddb`](https://github.com/fomantic/Fomantic-UI/commit/59ecddb1d54310146c6ed0a82d18dc6c957ca9f1)
- [`#2394`](https://github.com/fomantic/Fomantic-UI/issues/2394) URL values will now encode while avoiding double encoding [`fc6df94`](https://github.com/fomantic/Fomantic-UI/commit/fc6df94ea36435a582c63dc5aa2f9e90ce09b22a)
- [`#2396`](https://github.com/fomantic/Fomantic-UI/issues/2396)  look for disabled values when initializing select [`3582d1c`](https://github.com/fomantic/Fomantic-UI/commit/3582d1cb35bddaf7cc705668f0dc8b90b5c601db)
- [`#2402`](https://github.com/fomantic/Fomantic-UI/issues/2402) - further house cleaning with transition [`df934c0`](https://github.com/fomantic/Fomantic-UI/commit/df934c05596a23533ba2611c82843b8a8cd69886)
- [`#2411`](https://github.com/fomantic/Fomantic-UI/issues/2411) Adds horizontal segment groups [`f59c707`](https://github.com/fomantic/Fomantic-UI/commit/f59c7074bfd64e88f0da1e04aaf25104fd0f1718)
- [`#2426`](https://github.com/fomantic/Fomantic-UI/issues/2426)  onSelect did not correctly attach result metadata with category search [`a988e3e`](https://github.com/fomantic/Fomantic-UI/commit/a988e3e858f81b7fc7d054fcb3cd42ac8ef5b4a1)
- [`#2433`](https://github.com/fomantic/Fomantic-UI/issues/2433) Fix issue with basic segment rule [`1dd822b`](https://github.com/fomantic/Fomantic-UI/commit/1dd822b678d15d0e8c808b8b905ceb5dbdef8ad6)
- [`#2434`](https://github.com/fomantic/Fomantic-UI/issues/2434) - Checkbox no longer need any init/for to work [`291f143`](https://github.com/fomantic/Fomantic-UI/commit/291f14367b33f9bf1b6c01182f850e96ed892b93)
- [`#2434`](https://github.com/fomantic/Fomantic-UI/issues/2434) - Label no longer shows hand cursor unless initialized with JS, fixed destroy to return input z-index [`b42bcbd`](https://github.com/fomantic/Fomantic-UI/commit/b42bcbde1dbd20623cc52c3977b2656f6861f659)
- [`#2440`](https://github.com/fomantic/Fomantic-UI/issues/2440) Finish indeterminate, consolidate API to avoid confusion [`8db305a`](https://github.com/fomantic/Fomantic-UI/commit/8db305a460d4e7697e34221e84c9abf749a8b470)
- [`#2440`](https://github.com/fomantic/Fomantic-UI/issues/2440) continuous lineheight noodling [`859243f`](https://github.com/fomantic/Fomantic-UI/commit/859243fb60bb0db8cacae4a5411b6416e111eb97)
- [`#2445`](https://github.com/fomantic/Fomantic-UI/issues/2445) add width: auto to input in dropdown. [`38300ed`](https://github.com/fomantic/Fomantic-UI/commit/38300edd19fe2114da93a52c0225d16416d4776f)
- [`#2446`](https://github.com/fomantic/Fomantic-UI/issues/2446) issue in css selector in menu [`cec3cfc`](https://github.com/fomantic/Fomantic-UI/commit/cec3cfc967b872128d134c5f5d76b9aa971c97b6)
- [`#2455`](https://github.com/fomantic/Fomantic-UI/issues/2455) remove logging [`8f3adb4`](https://github.com/fomantic/Fomantic-UI/commit/8f3adb47bfa915454d17202cc579b58dc5a52754)
- [`#2456`](https://github.com/fomantic/Fomantic-UI/issues/2456)  specificity issue with vertical tabular border radius [`7e36f61`](https://github.com/fomantic/Fomantic-UI/commit/7e36f6154cf25458cd8706eb89bd1849ca455555)
- [`#2457`](https://github.com/fomantic/Fomantic-UI/issues/2457) child selector for label causes sibings() selector to fail [`dee9d09`](https://github.com/fomantic/Fomantic-UI/commit/dee9d09a665470d4a885ec46df5b42a0ccdde317)
- [`#2466`](https://github.com/fomantic/Fomantic-UI/issues/2466)  recode some of progress. Fix module.value to not be estimated when using a total. Fixed issue with values less than 1 displaying incorrectly [`62ae343`](https://github.com/fomantic/Fomantic-UI/commit/62ae343363f84c3d5774516f2b91b72cd0260a25)
- [`#2467`](https://github.com/fomantic/Fomantic-UI/issues/2467) - Add examples for many responsive element patterns [`07026da`](https://github.com/fomantic/Fomantic-UI/commit/07026da5dc45a878a0b9105c550de8bba07a5c0c)
- [`#2467`](https://github.com/fomantic/Fomantic-UI/issues/2467) Add examples with stackable using (x) column row and (x) wide [`5704621`](https://github.com/fomantic/Fomantic-UI/commit/5704621d7337afee2ea5ff263c28b0407327194b)
- [`#2469`](https://github.com/fomantic/Fomantic-UI/issues/2469) Fix issue with get animation when cache is undefined [`a942a27`](https://github.com/fomantic/Fomantic-UI/commit/a942a27ad6b16d0b722c5f18786c9b779e708072)
- [`#2472`](https://github.com/fomantic/Fomantic-UI/issues/2472) Add centered variation to card [`1ada042`](https://github.com/fomantic/Fomantic-UI/commit/1ada0429bf7ac0da47cd6d0fc3a7cd63bf7251d5)
- [`#2479`](https://github.com/fomantic/Fomantic-UI/issues/2479) Adds debug data for saving defaults [`c17e254`](https://github.com/fomantic/Fomantic-UI/commit/c17e254c966beaf445825fc29fa459d37755fab6)
- [`#2481`](https://github.com/fomantic/Fomantic-UI/issues/2481) remove styles no longer neceesary with rating with flex [`524937d`](https://github.com/fomantic/Fomantic-UI/commit/524937d6e7654f13f27767215bb26c3d9e71f637)
- [`#2486`](https://github.com/fomantic/Fomantic-UI/issues/2486)  Add @absoluteEM sizes to help clarify ambiguity in sizing, fix label sizing [`4f31c6d`](https://github.com/fomantic/Fomantic-UI/commit/4f31c6d7a2f484722644f310228ed26b813ea862)
- [`#2486`](https://github.com/fomantic/Fomantic-UI/issues/2486) Fix label inside input not rfesizing [`3bc76f9`](https://github.com/fomantic/Fomantic-UI/commit/3bc76f9f7353c7048283d3ef1048fe85d3037056)
- [`#2500`](https://github.com/fomantic/Fomantic-UI/issues/2500) Attached label border radius, add new variables [`d84c4d2`](https://github.com/fomantic/Fomantic-UI/commit/d84c4d24b5235ff96cebbc1d77c6754362fa81c6)
- [`#2505`](https://github.com/fomantic/Fomantic-UI/issues/2505) #2501 radio checkbox regression during fixes to #2610 [`7d5ea33`](https://github.com/fomantic/Fomantic-UI/commit/7d5ea33a0a21cd42d37c87e4e402b98dff23fba5)
- [`#2505`](https://github.com/fomantic/Fomantic-UI/issues/2505) Fixes indeterminate checkbox styles causing radios to appear checked when none selected [`f49c554`](https://github.com/fomantic/Fomantic-UI/commit/f49c554aa65d3b829e341aaf08670df62fb41fc0)
- [`#2510`](https://github.com/fomantic/Fomantic-UI/issues/2510) Fix dropdown icon to always toggle visibility of dropdown menu [`89e0512`](https://github.com/fomantic/Fomantic-UI/commit/89e05127d0b326a06b0d60cc42fea6c601972da7)
- [`#2510`](https://github.com/fomantic/Fomantic-UI/issues/2510) remove debug [`dbaac4f`](https://github.com/fomantic/Fomantic-UI/commit/dbaac4fc0f32e549ecc8afea918d13fe532e044d)
- [`#2516`](https://github.com/fomantic/Fomantic-UI/issues/2516) dropdown will now cycle between choices starting with a letter [`459194a`](https://github.com/fomantic/Fomantic-UI/commit/459194a750270b7db4a547eb899021bdca5677fd)
- [`#2518`](https://github.com/fomantic/Fomantic-UI/issues/2518) better check for hidden [`ee69a51`](https://github.com/fomantic/Fomantic-UI/commit/ee69a51921e03ee243c5a0f5db05d4c053f02707)
- [`#2522`](https://github.com/fomantic/Fomantic-UI/issues/2522)  less confusing variable usage [`540e629`](https://github.com/fomantic/Fomantic-UI/commit/540e629efbc34e487520d1bca582bd206cebb5a4)
- [`#2522`](https://github.com/fomantic/Fomantic-UI/issues/2522) Read metadata method does not set progress correctly. Debug should be off by default [`e35ca4d`](https://github.com/fomantic/Fomantic-UI/commit/e35ca4d2fa9ab7a0d8408f7811eaa378e0bb873d)
- [`#2524`](https://github.com/fomantic/Fomantic-UI/issues/2524)  clicking on labels will no longer trigger toggle behavior. Caused by detached dom element not being considered click inside module [`9b96a04`](https://github.com/fomantic/Fomantic-UI/commit/9b96a047df303461c3eeebc6751ec5bac1fd75b8)
- [`#2524`](https://github.com/fomantic/Fomantic-UI/issues/2524) - remove console log (actually) [`64b087d`](https://github.com/fomantic/Fomantic-UI/commit/64b087d6632e6a0942c47197c4dedc7a5bb8bd31)
- [`#2524`](https://github.com/fomantic/Fomantic-UI/issues/2524) - remove console log [`43b8be1`](https://github.com/fomantic/Fomantic-UI/commit/43b8be1934cc82eb3a04d61ce730ec2155b80035)
- [`#2525`](https://github.com/fomantic/Fomantic-UI/issues/2525) Remove toggle on multiple dropdown touchstart, fix tap color [`6e2938b`](https://github.com/fomantic/Fomantic-UI/commit/6e2938bb37df563f8ae3299d6360d43f11307aa3)
- [`#2526`](https://github.com/fomantic/Fomantic-UI/issues/2526) - Redo methods for determining boundaries exceeded to be more coherent [`d692dbc`](https://github.com/fomantic/Fomantic-UI/commit/d692dbc342890a0e72fd835c96e918ff32983f55)
- [`#2526`](https://github.com/fomantic/Fomantic-UI/issues/2526) Add jitter to deal with rounding issues when popup is adjacent to edge [`5b2b198`](https://github.com/fomantic/Fomantic-UI/commit/5b2b1981018722cdb3aab047011f1be94f97c178)
- [`#2526`](https://github.com/fomantic/Fomantic-UI/issues/2526) Increase jitter [`0775e8f`](https://github.com/fomantic/Fomantic-UI/commit/0775e8fffa7c072798fa5b403e734dba19ce4313)
- [`#2526`](https://github.com/fomantic/Fomantic-UI/issues/2526) Popup fluid width is now set by its parent DOM element, not its offsetContext (i.e. thing with position: relative) [`5d113c0`](https://github.com/fomantic/Fomantic-UI/commit/5d113c01a513a660896c4d0f800d48ee442f391f)
- [`#2526`](https://github.com/fomantic/Fomantic-UI/issues/2526) adjust comments [`bc736b2`](https://github.com/fomantic/Fomantic-UI/commit/bc736b2e5f55eae1269cd752d3a06d0f47194f2c)
- [`#2532`](https://github.com/fomantic/Fomantic-UI/issues/2532) rlnotes [`c55ed42`](https://github.com/fomantic/Fomantic-UI/commit/c55ed428b5a397209ebb05714c0cdd98d559a5d1)
- [`#2533`](https://github.com/fomantic/Fomantic-UI/issues/2533) - Fixes issue with hideAndClear when no maxSelection [`4514ac4`](https://github.com/fomantic/Fomantic-UI/commit/4514ac4089870a8d73d25a2a3cfdec32b2da52bc)
- [`#2534`](https://github.com/fomantic/Fomantic-UI/issues/2534) - Add cacheType setting, response or html. Response caches original response so that execution occurs in same way each load. HTML caches final html content after callbacks [`6b5c383`](https://github.com/fomantic/Fomantic-UI/commit/6b5c383dabfda853e6862a59a5b4edf9dda1c01e)
- [`#2534`](https://github.com/fomantic/Fomantic-UI/issues/2534) - adds new DOM caching, which preserves events and final rendered state [`d095ed1`](https://github.com/fomantic/Fomantic-UI/commit/d095ed18f1977ed907ad4ac3195a71c5eb90f5bf)
- [`#2534`](https://github.com/fomantic/Fomantic-UI/issues/2534) preserve original behavior [`7901e04`](https://github.com/fomantic/Fomantic-UI/commit/7901e04409b845171027de99d499e06ef2dd947f)
- [`#2538`](https://github.com/fomantic/Fomantic-UI/issues/2538) @size ratio values should always be expressed in terms of default em size, so that they scale with @emSize [`6e5755b`](https://github.com/fomantic/Fomantic-UI/commit/6e5755bd7c8d2fb813d5289d5d9d39a0d375a971)
- [`#2538`](https://github.com/fomantic/Fomantic-UI/issues/2538) Remove test emSize change [`4ca68e8`](https://github.com/fomantic/Fomantic-UI/commit/4ca68e818a0a98aaba2a19e4fed58969954e1a4f)
- [`#2539`](https://github.com/fomantic/Fomantic-UI/issues/2539)  update text before onChange [`77a1257`](https://github.com/fomantic/Fomantic-UI/commit/77a12579dae41b9b1641d15263a2956039ecb85e)
- [`#2550`](https://github.com/fomantic/Fomantic-UI/issues/2550) Fixes isssue with flex-basis in IE [`89ed5ef`](https://github.com/fomantic/Fomantic-UI/commit/89ed5effafb596adebd4417a6f8af367d62c365d)
- [`#2556`](https://github.com/fomantic/Fomantic-UI/issues/2556) Adds back black icons [`4b7a8fe`](https://github.com/fomantic/Fomantic-UI/commit/4b7a8fe19138c31893a8dfbe48b5a872eac92ae8)
- [`#2558`](https://github.com/fomantic/Fomantic-UI/issues/2558) Fixes vertical divider border right in stackable grid [`8bb7244`](https://github.com/fomantic/Fomantic-UI/commit/8bb724440e969a8e9f396dacc314b28818906474)
- [`#2573`](https://github.com/fomantic/Fomantic-UI/issues/2573)  refactoring add option value. Adds remove option value when deselected. Consolidated checks into has conditions [`54918e9`](https://github.com/fomantic/Fomantic-UI/commit/54918e9deb670b2d279a10c95aa19ae7e11c16fd)
- [`#2573`](https://github.com/fomantic/Fomantic-UI/issues/2573) Fix derp conditions of else [`4be9213`](https://github.com/fomantic/Fomantic-UI/commit/4be921336a3ce9695d856151d8b24d8e28ed1f4a)
- [`#2573`](https://github.com/fomantic/Fomantic-UI/issues/2573) Fixes &lt;select&gt; will not add option values with remote data. [`e61b39c`](https://github.com/fomantic/Fomantic-UI/commit/e61b39c16b73160d03165a185433b074a4be693f)
- [`#2576`](https://github.com/fomantic/Fomantic-UI/issues/2576) Modal will remove body style after hiding [`6fbabf4`](https://github.com/fomantic/Fomantic-UI/commit/6fbabf4c2bc996341c13995d220c47f4d20bce22)
- [`#2579`](https://github.com/fomantic/Fomantic-UI/issues/2579) make form identifiers optional [`3b109b2`](https://github.com/fomantic/Fomantic-UI/commit/3b109b2ed60cc973f52a4505dc6887f759042490)
- [`#2583`](https://github.com/fomantic/Fomantic-UI/issues/2583) Fixes onComplete is not called at true 'end of animation' [`bb9bbad`](https://github.com/fomantic/Fomantic-UI/commit/bb9bbad825adf121ff7b8e3ddfbe1b6fafce2aea)
- [`#2583`](https://github.com/fomantic/Fomantic-UI/issues/2583) onHide/onShow should be last as well [`cba22a8`](https://github.com/fomantic/Fomantic-UI/commit/cba22a865fe7a5f57b443dee70702be47a332449)
- [`#2586`](https://github.com/fomantic/Fomantic-UI/issues/2586) - Adds hideError setting, defaults to auto [`7ded1ac`](https://github.com/fomantic/Fomantic-UI/commit/7ded1ac6dade3907aed2e25b99973f8017626b1f)
- [`#2599`](https://github.com/fomantic/Fomantic-UI/issues/2599) Finish attached logic [`b5b1374`](https://github.com/fomantic/Fomantic-UI/commit/b5b137408f9285933f0dee59bee14089e9e8f374)
- [`#2599`](https://github.com/fomantic/Fomantic-UI/issues/2599) Fixes double borders in some attached cases, consolidates attached logic, adds attached examples [`62110fc`](https://github.com/fomantic/Fomantic-UI/commit/62110fc51fd8416fecdfe1ed08a5db76259bdee1)
- [`#2601`](https://github.com/fomantic/Fomantic-UI/issues/2601) fix issue where popups with variations will not correctly recieve class names if pre-existing content [`f307ef2`](https://github.com/fomantic/Fomantic-UI/commit/f307ef2069165fe63b47714b9eab7c3cb86929fc)
- [`#2605`](https://github.com/fomantic/Fomantic-UI/issues/2605) last scroll value should only be saved if element scroll position changes [`b61fef3`](https://github.com/fomantic/Fomantic-UI/commit/b61fef3205dfefe5a4832841dbeb625a968603fe)
- [`#2610`](https://github.com/fomantic/Fomantic-UI/issues/2610) and #2607 iterating on checkbox variable additions [`1e6e843`](https://github.com/fomantic/Fomantic-UI/commit/1e6e843919f58128e2c510fd61f0833792cf598f)
- [`#2610`](https://github.com/fomantic/Fomantic-UI/issues/2610) partial work on checkbox focus variables [`082a350`](https://github.com/fomantic/Fomantic-UI/commit/082a35065f963889cf15a3127f4fa9131882a663)
- [`#2615`](https://github.com/fomantic/Fomantic-UI/issues/2615) Adds missing default value for refreshOnResize [`2219ea8`](https://github.com/fomantic/Fomantic-UI/commit/2219ea88f2e7e0a8406685f8c0e06ba108141b8b)
- [`#2615`](https://github.com/fomantic/Fomantic-UI/issues/2615) re-order settings [`c091f50`](https://github.com/fomantic/Fomantic-UI/commit/c091f50aa7bef2371eda7c5f5cf9e5b3370e70f6)
- [`#2617`](https://github.com/fomantic/Fomantic-UI/issues/2617) Fixes unnecesssary use of flex with fluid button [`e5eca74`](https://github.com/fomantic/Fomantic-UI/commit/e5eca744d025c76afda58e1e0acf5b355828b3a4)
- [`#2626`](https://github.com/fomantic/Fomantic-UI/issues/2626) dropdown now updates selected values when input changes. Housecleaning with event binding [`12d6640`](https://github.com/fomantic/Fomantic-UI/commit/12d66408260db197659d8802deb27bccb5071ac3)
- [`#2629`](https://github.com/fomantic/Fomantic-UI/issues/2629) Fixes duck typing in form validation to check rules and id [`d2c4547`](https://github.com/fomantic/Fomantic-UI/commit/d2c4547dc04b79b274e6033d86ff076b34d52d6e)
- [`#2629`](https://github.com/fomantic/Fomantic-UI/issues/2629) Throw error when identifier is a non-string value [`b756bb5`](https://github.com/fomantic/Fomantic-UI/commit/b756bb52fe378fc95fb05b3a454aadb00ae12dcf)
- [`#2635`](https://github.com/fomantic/Fomantic-UI/issues/2635) Fixes issue with inverted active state not being defined, adds inverted focus state [`783b08c`](https://github.com/fomantic/Fomantic-UI/commit/783b08cbb66182e5c508f1e596a09e368f27f9ee)
- [`#2636`](https://github.com/fomantic/Fomantic-UI/issues/2636) Tests & Fixes 0, 1, and 2 conditions for minLength, maxLength and exactLength [`93a92d2`](https://github.com/fomantic/Fomantic-UI/commit/93a92d2bf067b4670d2eb7a389e348f8c75b24ff)
- [`#2637`](https://github.com/fomantic/Fomantic-UI/issues/2637) fixes issues with placeholder [`1900729`](https://github.com/fomantic/Fomantic-UI/commit/1900729083f63b0a16e66644a041f654dfd67259)
- [`#2637`](https://github.com/fomantic/Fomantic-UI/issues/2637) notes on added behaviors [`50264e3`](https://github.com/fomantic/Fomantic-UI/commit/50264e3602c27bb1d06222df92c7080772da59f4)
- [`#2638`](https://github.com/fomantic/Fomantic-UI/issues/2638) - Add doesntContain, doesntContainExactly rules [`750e9f1`](https://github.com/fomantic/Fomantic-UI/commit/750e9f1048f99bc8127f0289e70332065627a4fd)
- [`#2644`](https://github.com/fomantic/Fomantic-UI/issues/2644) remove unnecessary call to remove direction in destroy [`d74255f`](https://github.com/fomantic/Fomantic-UI/commit/d74255fe5709e4c49034450b189842b34e0d5a75)
- [`#2645`](https://github.com/fomantic/Fomantic-UI/issues/2645) adds fields array to dropdown [`ceb489e`](https://github.com/fomantic/Fomantic-UI/commit/ceb489e97654afd08c96b78349f21bec4c59c5a5)
- [`#2645`](https://github.com/fomantic/Fomantic-UI/issues/2645) adds fields parameter for using custom server responses with search [`57ee104`](https://github.com/fomantic/Fomantic-UI/commit/57ee1041f51794cc89ce49bf61c52ad708d24dd6)
- [`#2648`](https://github.com/fomantic/Fomantic-UI/issues/2648) - Fix issue when build/watch tasks are imported without sub-tasks defined [`021da85`](https://github.com/fomantic/Fomantic-UI/commit/021da85e3cfd90fa9ac8b2bc0172da4443de538b)
- [`#2649`](https://github.com/fomantic/Fomantic-UI/issues/2649) additional style pruning, remove two unnecessary scope uses from less [`db968a4`](https://github.com/fomantic/Fomantic-UI/commit/db968a4e05cd16bdae927468f87f3c12faad1382)
- [`#2655`](https://github.com/fomantic/Fomantic-UI/issues/2655) Fixes vertical basic buttons not aligned correctly [`79ca738`](https://github.com/fomantic/Fomantic-UI/commit/79ca738d05973ef4ea63424c1a14687dae775e30)
- [`#2656`](https://github.com/fomantic/Fomantic-UI/issues/2656) Adds before change callbacks for checkbox [`b2c0655`](https://github.com/fomantic/Fomantic-UI/commit/b2c0655b333c09153360a47fb3af28454308955f)
- [`#2656`](https://github.com/fomantic/Fomantic-UI/issues/2656) adds missing function defaults [`8c98ada`](https://github.com/fomantic/Fomantic-UI/commit/8c98ada923af961f5c180134484c4b79d2773657)
- [`#2659`](https://github.com/fomantic/Fomantic-UI/issues/2659) fix comments inside modal [`21139bd`](https://github.com/fomantic/Fomantic-UI/commit/21139bde54649fc7ec7870e6cc176d9c3066adf6)
- [`#2664`](https://github.com/fomantic/Fomantic-UI/issues/2664) Removes unnecessary right border on header item in secondary menu [`8e01074`](https://github.com/fomantic/Fomantic-UI/commit/8e010740692309deb6b69b6c6c80b8c67d4acf96)
- [`#2666`](https://github.com/fomantic/Fomantic-UI/issues/2666) - remove label does not correctly use get.values() internally, causing a type error with multiple [`14dea43`](https://github.com/fomantic/Fomantic-UI/commit/14dea43662f6302c4581e5d0917c6362d49b942e)
- [`#2666`](https://github.com/fomantic/Fomantic-UI/issues/2666) remove debug [`e906663`](https://github.com/fomantic/Fomantic-UI/commit/e906663f5f19779679a5bf0fda1dc6c37f2e6e14)
- [`#2676`](https://github.com/fomantic/Fomantic-UI/issues/2676) Checkbox now correctly prevent default event on keyup not keydown [`8f6bc3d`](https://github.com/fomantic/Fomantic-UI/commit/8f6bc3df803385dfb4c460a8a0129e6fcdf21727)
- [`#2681`](https://github.com/fomantic/Fomantic-UI/issues/2681) return length to functioning as minLength, add exact length [`208c9d6`](https://github.com/fomantic/Fomantic-UI/commit/208c9d6c59725911f1fee43a63fdcd0e274679a9)
- [`#2687`](https://github.com/fomantic/Fomantic-UI/issues/2687) Revise Readme [`0e9c3a2`](https://github.com/fomantic/Fomantic-UI/commit/0e9c3a211a6c830c7518ed4de5e9b874d6fc3721)
- [`#2689`](https://github.com/fomantic/Fomantic-UI/issues/2689) #2690 Fixes issues with restore defaults. Fixes issues with confusion over set selected [`46b5d53`](https://github.com/fomantic/Fomantic-UI/commit/46b5d53cc5cc2ce0a70efa2332659ae544956e72)
- [`#2694`](https://github.com/fomantic/Fomantic-UI/issues/2694) adds disabled state for input [`d6c6b68`](https://github.com/fomantic/Fomantic-UI/commit/d6c6b6896bf8ee2fa6bf4742c90fd43742f66c46)
- [`#2704`](https://github.com/fomantic/Fomantic-UI/issues/2704) remove unused variable [`938a32e`](https://github.com/fomantic/Fomantic-UI/commit/938a32e6b8d8972455a2c3590ef96da994a82ef6)
- [`#2710`](https://github.com/fomantic/Fomantic-UI/issues/2710) merge and modify this context [`09ecab6`](https://github.com/fomantic/Fomantic-UI/commit/09ecab67fc2f11a452b045e6530fae6e82067cbe)
- [`#2713`](https://github.com/fomantic/Fomantic-UI/issues/2713) Possible fix for complete returning XHR and not response [`039b549`](https://github.com/fomantic/Fomantic-UI/commit/039b5490ac51b9be906a7ad42ed9bf06dbc33cf2)
- [`#2729`](https://github.com/fomantic/Fomantic-UI/issues/2729) unimportant formatting [`643a330`](https://github.com/fomantic/Fomantic-UI/commit/643a3301e3eb18d67859951437bc7911cfd7c22e)
- [`#2737`](https://github.com/fomantic/Fomantic-UI/issues/2737) fix improper selector for autofocus setting, move setting check to outside function so it can be called manually [`a1ca414`](https://github.com/fomantic/Fomantic-UI/commit/a1ca41407647c13897142dd57b4b31a7413cc43b)
- [`#2737`](https://github.com/fomantic/Fomantic-UI/issues/2737) typo in code [`b6fa0b3`](https://github.com/fomantic/Fomantic-UI/commit/b6fa0b3020ce5f979cc7fe7a6d622eeaa2bd8f79)
- [`#2744`](https://github.com/fomantic/Fomantic-UI/issues/2744) Fixes issue with fluid container overflow [`7b2a696`](https://github.com/fomantic/Fomantic-UI/commit/7b2a696caeee6f4b607a86bfe906da87a79e34f8)
- [`#2754`](https://github.com/fomantic/Fomantic-UI/issues/2754)  fix issue with not using correct metadata setting for label value [`506f96f`](https://github.com/fomantic/Fomantic-UI/commit/506f96ffd77afff06b25522cdfa88650a6c1d779)
- [`#2758`](https://github.com/fomantic/Fomantic-UI/issues/2758) #2760 fix this context for transition callbacks [`0d23f97`](https://github.com/fomantic/Fomantic-UI/commit/0d23f9733568d501f29182650b2c94cd9b309510)
- [`#2760`](https://github.com/fomantic/Fomantic-UI/issues/2760) - remove console.log from embed [`145b4f5`](https://github.com/fomantic/Fomantic-UI/commit/145b4f526ccf9b776e1f1da7e41781b63c1c1168)
- [`#2765`](https://github.com/fomantic/Fomantic-UI/issues/2765) fixes bad icon utf value [`44be32a`](https://github.com/fomantic/Fomantic-UI/commit/44be32a0e728271c26f68c906e9e24f48ff5c298)
- [`#2766`](https://github.com/fomantic/Fomantic-UI/issues/2766)  concatenated stream removes dupes [`2c74b56`](https://github.com/fomantic/Fomantic-UI/commit/2c74b56cc13620ed35a150247e14a83fd591dc5e)
- [`#2769`](https://github.com/fomantic/Fomantic-UI/issues/2769) Fix logic in onHide, to only close when NOT false, add onShow [`81f50e0`](https://github.com/fomantic/Fomantic-UI/commit/81f50e0f7a2aae6e68683c17558b36e6bec0ce63)
- [`#2778`](https://github.com/fomantic/Fomantic-UI/issues/2778) fix issue with flex-direction on left dropdown menu in menu [`2c8aa03`](https://github.com/fomantic/Fomantic-UI/commit/2c8aa03bb4530e6b5bde3fd8fb915e7dac178a6e)
- [`#2779`](https://github.com/fomantic/Fomantic-UI/issues/2779) - remove redundancy [`f913a97`](https://github.com/fomantic/Fomantic-UI/commit/f913a97a90cadf78e3ce1686ea725550bd1e70a7)
- [`#2795`](https://github.com/fomantic/Fomantic-UI/issues/2795)  ignore change event on initial load when not fireOnInit [`bac6193`](https://github.com/fomantic/Fomantic-UI/commit/bac6193db40dc264172373e7c894d86641b73a9f)
- [`#2802`](https://github.com/fomantic/Fomantic-UI/issues/2802) - add support for attr value in ordered list [`e0724cb`](https://github.com/fomantic/Fomantic-UI/commit/e0724cb51699335ad4e36cba0d1ae58a7705f53a)
- [`#2812`](https://github.com/fomantic/Fomantic-UI/issues/2812)  improve settings docs for accordion [`c9c81e0`](https://github.com/fomantic/Fomantic-UI/commit/c9c81e005fac4ed0133d94d29bbfa35b73436b48)
- [`#2824`](https://github.com/fomantic/Fomantic-UI/issues/2824)  Fix issue where single search selection would filter active item and not re-display on cleared filter. Additionally fixes issue with forceSelection not working on pageLosesFocus #2824 [`3a15983`](https://github.com/fomantic/Fomantic-UI/commit/3a1598356b745dd1f0c1fb33c6969eedd20cadf7)
- [`#2825`](https://github.com/fomantic/Fomantic-UI/issues/2825) Fixes empty messages showing in form state [`8c82942`](https://github.com/fomantic/Fomantic-UI/commit/8c829425ea20746e087abdef7d39f65f9c746487)
- [`#2825`](https://github.com/fomantic/Fomantic-UI/issues/2825) empty form comment banner [`d89e9d9`](https://github.com/fomantic/Fomantic-UI/commit/d89e9d90f3e6a23d661a19e56f43caff1d71009e)
- [`#2836`](https://github.com/fomantic/Fomantic-UI/issues/2836) add run sequence & formatting [`8814f05`](https://github.com/fomantic/Fomantic-UI/commit/8814f051729d42771e784cf66e778d796e5a67af)
- [`#2838`](https://github.com/fomantic/Fomantic-UI/issues/2838) fixes missing variable grep, formatting [`d020528`](https://github.com/fomantic/Fomantic-UI/commit/d020528fedbe3e5093053f1d95960b36f34cb4e5)
- [`#2842`](https://github.com/fomantic/Fomantic-UI/issues/2842)  Calling show results does not require input to be focused [`d649872`](https://github.com/fomantic/Fomantic-UI/commit/d6498722ec262ac467bc75152c767de271edf4a6)
- [`#2842`](https://github.com/fomantic/Fomantic-UI/issues/2842) consolidate diners club [`d3b280b`](https://github.com/fomantic/Fomantic-UI/commit/d3b280b50063ab1203ea799ab81b0af21b50a9c2)
- [`#2862`](https://github.com/fomantic/Fomantic-UI/issues/2862) adds variables, and fixes spacing for sub menu in secondary menu and text menu [`1f74594`](https://github.com/fomantic/Fomantic-UI/commit/1f745948769ccb0d18bd6e03a9c588160b533541)
- [`#2866`](https://github.com/fomantic/Fomantic-UI/issues/2866) - Add unstackable fields, unstackable form variations [`1a1c3b4`](https://github.com/fomantic/Fomantic-UI/commit/1a1c3b4abb08c8ae44d4696d4c3b6d6daedb58dc)
- [`#2869`](https://github.com/fomantic/Fomantic-UI/issues/2869) merges fix for :only-child border radius with stylistic changes [`d553e8d`](https://github.com/fomantic/Fomantic-UI/commit/d553e8d4ff79dd35eb9211aa595a1c55eaf5208f)
- [`#2924`](https://github.com/fomantic/Fomantic-UI/issues/2924) update browser support in readme [`142ff6b`](https://github.com/fomantic/Fomantic-UI/commit/142ff6b56a544fdff01db8e18f91d929cf32a04f)
- [`#2934`](https://github.com/fomantic/Fomantic-UI/issues/2934)  fix onRemove firing when no popup removed [`6f4ac86`](https://github.com/fomantic/Fomantic-UI/commit/6f4ac8697b3488afe4582a7129cca61bb0eccc2c)
- [`#2959`](https://github.com/fomantic/Fomantic-UI/issues/2959) - fixes issue with inheritance with alignment and some table conditions [`92e0ee2`](https://github.com/fomantic/Fomantic-UI/commit/92e0ee2c54945590e900210d172a165d12dfec4e)
- [`#2973`](https://github.com/fomantic/Fomantic-UI/issues/2973) - fixes spacing on right icon inside labeled icon button [`ad4a057`](https://github.com/fomantic/Fomantic-UI/commit/ad4a057297dbe8066e00255c1c8c073735a9f093)
- [`#3001`](https://github.com/fomantic/Fomantic-UI/issues/3001) #2579, add new form validation shorthand, drastically simpler [`e364c16`](https://github.com/fomantic/Fomantic-UI/commit/e364c1658eb28f41f4d02655f454553d43abcb77)
- [`#3001`](https://github.com/fomantic/Fomantic-UI/issues/3001) Fixing all default prompts to use name [`ad62a7f`](https://github.com/fomantic/Fomantic-UI/commit/ad62a7f26111d7a9b1fda0cf4c514a66d82a4b41)
- [`#3001`](https://github.com/fomantic/Fomantic-UI/issues/3001) add support for more templated values [`4bb1d0d`](https://github.com/fomantic/Fomantic-UI/commit/4bb1d0d630bcaed1a1a5a3aa4827d9f291c45eee)
- [`#3002`](https://github.com/fomantic/Fomantic-UI/issues/3002)  fixes tab index broken on selection dropdown [`77954a2`](https://github.com/fomantic/Fomantic-UI/commit/77954a298c465601e43589bc06ba542fe7803015)
- [`#3009`](https://github.com/fomantic/Fomantic-UI/issues/3009)  fix issue where theme will fail building if packaged theme does not include site.variables [`afbd7d5`](https://github.com/fomantic/Fomantic-UI/commit/afbd7d5f88c5bb410aeab7e3ab199d5a4a772fe5)
- [`#3016`](https://github.com/fomantic/Fomantic-UI/issues/3016)  dont use delimiter key when not multiple with additions allowed [`f86b801`](https://github.com/fomantic/Fomantic-UI/commit/f86b8015b1fb2352ebd8cfa288e2e5254dcb230f)
- [`#3016`](https://github.com/fomantic/Fomantic-UI/issues/3016) fix comma not delimiting correctly [`fe7a246`](https://github.com/fomantic/Fomantic-UI/commit/fe7a2468336fa9926a547016c4643def8ff743cd)
- [`#3040`](https://github.com/fomantic/Fomantic-UI/issues/3040) rename transition error to be more reasonable #3040 [`2506edc`](https://github.com/fomantic/Fomantic-UI/commit/2506edc11ee56be638fe9919222cb0e4b7657116)
- [`#3096`](https://github.com/fomantic/Fomantic-UI/issues/3096)  adds autocomplete off to init [`af43ede`](https://github.com/fomantic/Fomantic-UI/commit/af43edea8f19eddeae9472d6503c66fd3e22e972)
- [`#3108`](https://github.com/fomantic/Fomantic-UI/issues/3108) Adds native change to dropdown [`528a510`](https://github.com/fomantic/Fomantic-UI/commit/528a510d6ce17f58cde27352a3f9993dc3599f4a)
- [`#3116`](https://github.com/fomantic/Fomantic-UI/issues/3116) - Fixes issue with inheritance of statistic font size in groups [`ff99741`](https://github.com/fomantic/Fomantic-UI/commit/ff9974102f0344e2696e42f6f5419e0b2029f714)
- [`#3122`](https://github.com/fomantic/Fomantic-UI/issues/3122) fixes issue with loading form styles [`d34b18b`](https://github.com/fomantic/Fomantic-UI/commit/d34b18b661b8186df2235973f82337b24dbbd629)
- [`#3148`](https://github.com/fomantic/Fomantic-UI/issues/3148) fixes default setting name for onEnabled to match typo name [`740b0d1`](https://github.com/fomantic/Fomantic-UI/commit/740b0d13e13bfb2eae4c353a0255bef3fbfec983)
- [`#3193`](https://github.com/fomantic/Fomantic-UI/issues/3193)  renames scroll to scrollContext for clarification internally, adds fits check [`697fcfe`](https://github.com/fomantic/Fomantic-UI/commit/697fcfe326c40c01aea3097e9a0e76de9992e4cc)
- [`#3200`](https://github.com/fomantic/Fomantic-UI/issues/3200) remove debug [`5816875`](https://github.com/fomantic/Fomantic-UI/commit/58168755d70491de1f74ac9bcc3e2603055346b2)
- [`#3272`](https://github.com/fomantic/Fomantic-UI/issues/3272) fixes comment [`f8b4e12`](https://github.com/fomantic/Fomantic-UI/commit/f8b4e129b2c4a8201f0ebe8af848a08484b4c2fb)
- [`#3300`](https://github.com/fomantic/Fomantic-UI/issues/3300) Fixes load order of very thin sidebar [`1062ce9`](https://github.com/fomantic/Fomantic-UI/commit/1062ce91101a4a532d191241c9152955535edf1b)
- [`#3306`](https://github.com/fomantic/Fomantic-UI/issues/3306) remove transform hack from sidebar [`e194140`](https://github.com/fomantic/Fomantic-UI/commit/e19414021079871aff9382afcc48843f3e684e91)
- [`#3311`](https://github.com/fomantic/Fomantic-UI/issues/3311) - Adds better organization for mobile/pc/filesystem icons [`d103841`](https://github.com/fomantic/Fomantic-UI/commit/d10384137ce5768f85096b8f754299f7f77654d9)
- [`#3311`](https://github.com/fomantic/Fomantic-UI/issues/3311) - Fixes talk aliases [`fe2d3ef`](https://github.com/fomantic/Fomantic-UI/commit/fe2d3efe2089ffa52337a5a617ea1bd30081baa4)
- [`#3311`](https://github.com/fomantic/Fomantic-UI/issues/3311) battery alises [`8a3a52e`](https://github.com/fomantic/Fomantic-UI/commit/8a3a52eeafe11de0872ad5afc53337607e7e721e)
- [`#3313`](https://github.com/fomantic/Fomantic-UI/issues/3313) remove logging [`4d01914`](https://github.com/fomantic/Fomantic-UI/commit/4d01914783363c90260ee269c789a5d6017e1535)
- [`#3370`](https://github.com/fomantic/Fomantic-UI/issues/3370) default to 10 [`970dffb`](https://github.com/fomantic/Fomantic-UI/commit/970dffbb68ee4bd2814ad37782d12bdedaf30f43)
- [`#3388`](https://github.com/fomantic/Fomantic-UI/issues/3388) adds unplaceable callback, fixes docs [`99b3228`](https://github.com/fomantic/Fomantic-UI/commit/99b3228a956569f06d0e44dc50f8c6cc83c25291)
- [`#3396`](https://github.com/fomantic/Fomantic-UI/issues/3396) modal close [`aa33138`](https://github.com/fomantic/Fomantic-UI/commit/aa331386d0b8bd7234d68485c1ae0b8fc4a96269)
- [`#3405`](https://github.com/fomantic/Fomantic-UI/issues/3405) - formatting [`db38c17`](https://github.com/fomantic/Fomantic-UI/commit/db38c1723b05ec9ad2b5fd936ffd2c6fc63a0958)
- [`#3405`](https://github.com/fomantic/Fomantic-UI/issues/3405) - more formatting [`0a84ca0`](https://github.com/fomantic/Fomantic-UI/commit/0a84ca0b703a09279aaf323f04af21d7470ab4d4)
- [`#3430`](https://github.com/fomantic/Fomantic-UI/issues/3430) Fixes issue with page scroll flickering due to bug in sticky when container height is defined by static sticky height [`52dbc62`](https://github.com/fomantic/Fomantic-UI/commit/52dbc6288e327d1b671b0d86019a23ef6d601bcc)
- [`#3432`](https://github.com/fomantic/Fomantic-UI/issues/3432) Simplifies setting name (derp), adds default to false [`32d47d6`](https://github.com/fomantic/Fomantic-UI/commit/32d47d60ef9b6da6db9a3e19afe71c7a717fbe04)
- [`#3432`](https://github.com/fomantic/Fomantic-UI/issues/3432) implement matching user addition case [`0fa5821`](https://github.com/fomantic/Fomantic-UI/commit/0fa58217adef109e22faa3722d2d4f30bef71ac5)
- [`#3475`](https://github.com/fomantic/Fomantic-UI/issues/3475) - Adds deactivate setting for tab used to determine what elements user would like to deactivate when a tab is selected [`1b982e1`](https://github.com/fomantic/Fomantic-UI/commit/1b982e1842810506e04e7baea99f8963307ff4f4)
- [`#3604`](https://github.com/fomantic/Fomantic-UI/issues/3604) - fixes issue with right menu / item including margin when stacked [`c46c170`](https://github.com/fomantic/Fomantic-UI/commit/c46c1704c40c62013cdf586c579acfb9c3330fb1)
- [`#3611`](https://github.com/fomantic/Fomantic-UI/issues/3611) - Adds relative pixel variables up to 40px [`caad06c`](https://github.com/fomantic/Fomantic-UI/commit/caad06c30bffad5864fa807e0f6a5afc69292ba4)
- [`#3616`](https://github.com/fomantic/Fomantic-UI/issues/3616) -  RLSNOTES [`cf84a74`](https://github.com/fomantic/Fomantic-UI/commit/cf84a740f91abafcd0eb5db4e60f68f4fa053c5d)
- [`#3616`](https://github.com/fomantic/Fomantic-UI/issues/3616) Adds autoInstall option to semantic.json, modifies installer to return correct questions object in autoinstall [`487c5cc`](https://github.com/fomantic/Fomantic-UI/commit/487c5cce539acee90ac5f56303a497cf874c0017)
- [`#3655`](https://github.com/fomantic/Fomantic-UI/issues/3655) Removes deprecated use of size() [`679ee67`](https://github.com/fomantic/Fomantic-UI/commit/679ee677725cb0ed234f0c136f1538b25c54a23f)
- [`#3660`](https://github.com/fomantic/Fomantic-UI/issues/3660) - Fixes issue with refactor where beforeSend cannot cancel request [`8f1233f`](https://github.com/fomantic/Fomantic-UI/commit/8f1233fe215ba5854177001f0d23508105a13968)
- [`#3710`](https://github.com/fomantic/Fomantic-UI/issues/3710) - Fixed issue with unnecessary padding on first and last items of divided and relaxed lists [`f10577c`](https://github.com/fomantic/Fomantic-UI/commit/f10577c4a390c417b03176b47cac1aa7380a56f6)
- [`#3712`](https://github.com/fomantic/Fomantic-UI/issues/3712) - Fixed issue with rating firing onRate on initial load [`44837fa`](https://github.com/fomantic/Fomantic-UI/commit/44837faf5793fdfc7394e9a0fbc3ced5e701d73e)
- [`#3713`](https://github.com/fomantic/Fomantic-UI/issues/3713) - adds silent option to all modules [`7040acd`](https://github.com/fomantic/Fomantic-UI/commit/7040acdc440a42e508142e58dc114bbab39cbade)
- [`#3715`](https://github.com/fomantic/Fomantic-UI/issues/3715) - fixed issue with bullets being affected by font weight [`7e4983e`](https://github.com/fomantic/Fomantic-UI/commit/7e4983e6993dd4b4e3a853176c2fc42931e065f7)
- [`#3724`](https://github.com/fomantic/Fomantic-UI/issues/3724)  fix relative paths to be prefixed with ./ [`0c3c410`](https://github.com/fomantic/Fomantic-UI/commit/0c3c41038c55d9cdb9fd1a114387ae6b63ba8a40)
- [`#3724`](https://github.com/fomantic/Fomantic-UI/issues/3724) fix concat css to not mess with paths replaced with regexp [`d9247de`](https://github.com/fomantic/Fomantic-UI/commit/d9247de8600ed93b1cc66c75413035845ec115c5)
- [`#3744`](https://github.com/fomantic/Fomantic-UI/issues/3744) one last console log [`9683df5`](https://github.com/fomantic/Fomantic-UI/commit/9683df5e909fe46ee9eaf57f8df81de9437ee0c1)
- [`#3766`](https://github.com/fomantic/Fomantic-UI/issues/3766) - Fixes issue with get value not returning proper value [`c4be1cb`](https://github.com/fomantic/Fomantic-UI/commit/c4be1cb694a31130f680f796006ba1c5ced595c6)
- [`#3779`](https://github.com/fomantic/Fomantic-UI/issues/3779) - Fixes issue where dropdown with user addition would keep input after selecting a choice [`ccb1c7f`](https://github.com/fomantic/Fomantic-UI/commit/ccb1c7fde48e500edfef57282a92166d1dac5b1b)
- [`#3788`](https://github.com/fomantic/Fomantic-UI/issues/3788) Fixes issue with search selection closing and reopening immediately [`79b9557`](https://github.com/fomantic/Fomantic-UI/commit/79b9557070a9b97c0cb950dea59e90f55254b9ef)
- [`#3789`](https://github.com/fomantic/Fomantic-UI/issues/3789) - Fix issue with label click making menu appeaR [`2e5ad7c`](https://github.com/fomantic/Fomantic-UI/commit/2e5ad7c71c6d879a5b55d9efe840856f3b698c17)
- [`#3856`](https://github.com/fomantic/Fomantic-UI/issues/3856) #3870 - Fixed issue where onSelect event would not prevent bubbled close event on blur. [`21d24a0`](https://github.com/fomantic/Fomantic-UI/commit/21d24a087cf4ee3ea4a01923514cbe47839ce6c1)
- [`#3879`](https://github.com/fomantic/Fomantic-UI/issues/3879) fixes item cache not updating after addition [`9fa00b9`](https://github.com/fomantic/Fomantic-UI/commit/9fa00b937980dab2cb510e71eadb8eb50a9f226b)
- [`#3886`](https://github.com/fomantic/Fomantic-UI/issues/3886) fix default [`4a8eef3`](https://github.com/fomantic/Fomantic-UI/commit/4a8eef36deedfafec3f488f93666ad9531ca2a79)
- [`#3932`](https://github.com/fomantic/Fomantic-UI/issues/3932) Fixes compatibility issues with jq 3.0 [`2afb4d9`](https://github.com/fomantic/Fomantic-UI/commit/2afb4d95d201f40fb7ea77cf5d580f1f82c4fb97)
- [`#394`](https://github.com/fomantic/Fomantic-UI/issues/394) extend checkbox theming variables to make colored variations simpler [`288a6dd`](https://github.com/fomantic/Fomantic-UI/commit/288a6dde1c54a40692b249c1b4cf8724f7fbe13d)
- [`#3960`](https://github.com/fomantic/Fomantic-UI/issues/3960)  provide hint on hiding error message in msg [`9f68638`](https://github.com/fomantic/Fomantic-UI/commit/9f686384007889805912ff28ecf83102b321b6f6)
- [`#396`](https://github.com/fomantic/Fomantic-UI/issues/396)  add word order dependency to all grid variations with multiple words [`18106ae`](https://github.com/fomantic/Fomantic-UI/commit/18106aee384fe8ac1781a3029af2f2035f2f2146)
- [`#4029`](https://github.com/fomantic/Fomantic-UI/issues/4029) Fixes issue with dropdown mutation observer not handling case where entire &lt;select&gt; is replaced. Update placeholder text usage. Add new values option for initialized dropdowns from js [`ef94ea8`](https://github.com/fomantic/Fomantic-UI/commit/ef94ea8e65ddd8639fd5c2aa30fd6ff8ad8d06af)
- [`#4051`](https://github.com/fomantic/Fomantic-UI/issues/4051) - Fixes paths to roboto in material theme [`dbafd8d`](https://github.com/fomantic/Fomantic-UI/commit/dbafd8d4f1a3eb3fc7c21925ba9b60ac870a0e9d)
- [`#4107`](https://github.com/fomantic/Fomantic-UI/issues/4107) Fixes only one vertical button [`0f48652`](https://github.com/fomantic/Fomantic-UI/commit/0f48652ba8306fe285f76ede1475b9c1de1fa433)
- [`#4163`](https://github.com/fomantic/Fomantic-UI/issues/4163) #4164 Fixes associative array name values not working correctly [`6e88af1`](https://github.com/fomantic/Fomantic-UI/commit/6e88af15b7cf356ca46f744d6de47fe592650860)
- [`#4163`](https://github.com/fomantic/Fomantic-UI/issues/4163) #4164 Forgot to rename one use [`6016da3`](https://github.com/fomantic/Fomantic-UI/commit/6016da337fc28ce0c0e4d30cd771992c3453254f)
- [`#4163`](https://github.com/fomantic/Fomantic-UI/issues/4163) #4164 More general fix that properly escapes string values for selectors [`6f19675`](https://github.com/fomantic/Fomantic-UI/commit/6f19675c526f2df31a676dcc22676554f2959e1b)
- [`#4167`](https://github.com/fomantic/Fomantic-UI/issues/4167) - Tabular menu now has correct bottom margin in all cases [`39ef156`](https://github.com/fomantic/Fomantic-UI/commit/39ef156decdf8e1e46034594229cad9af044d9a5)
- [`#4174`](https://github.com/fomantic/Fomantic-UI/issues/4174)  remove path.sep from paths [`961b4c9`](https://github.com/fomantic/Fomantic-UI/commit/961b4c90680e8d3c1e423fbf9c0fdaf20d1e87af)
- [`#4181`](https://github.com/fomantic/Fomantic-UI/issues/4181) fix issue with jQ 3.0 width calculations causing shape to break [`2b955e0`](https://github.com/fomantic/Fomantic-UI/commit/2b955e0f81cc134fcc6a3dbb020ad82e012c7c80)
- [`#4192`](https://github.com/fomantic/Fomantic-UI/issues/4192)  [`c9bbe21`](https://github.com/fomantic/Fomantic-UI/commit/c9bbe21ef704e13b37ee417fe731e2a08814bd42)
- [`#4211`](https://github.com/fomantic/Fomantic-UI/issues/4211) - Fix left pointing menu to swap sides with leftward [`9425380`](https://github.com/fomantic/Fomantic-UI/commit/942538047ed0a2028e7dd8f67f79821bf06b9afa)
- [`#4211`](https://github.com/fomantic/Fomantic-UI/issues/4211) Change is.fitWidth to can.openRightward, fix logic to work after setting leftward [`3b802c3`](https://github.com/fomantic/Fomantic-UI/commit/3b802c33c1aeb7473637e0362f26670c53158d3f)
- [`#4237`](https://github.com/fomantic/Fomantic-UI/issues/4237) remove console.log [`a26ee40`](https://github.com/fomantic/Fomantic-UI/commit/a26ee40612bd36431035afb1554e933fc4b60cb1)
- [`#4248`](https://github.com/fomantic/Fomantic-UI/issues/4248) Fix issue with attached item menu #4248 [`bdb1928`](https://github.com/fomantic/Fomantic-UI/commit/bdb1928465bcaa8f2c1b0288d2ec309820c73d30)
- [`#4267`](https://github.com/fomantic/Fomantic-UI/issues/4267) #5253 Adds new behaviors for form validation - Add rule, Add field, remove field, remove rule [`bd6e37c`](https://github.com/fomantic/Fomantic-UI/commit/bd6e37c5d0b1384e60ba552c9e517a1e938d26b6)
- [`#4267`](https://github.com/fomantic/Fomantic-UI/issues/4267) #5253 Fix some mistaken logic [`8f1409a`](https://github.com/fomantic/Fomantic-UI/commit/8f1409aeb5e540ae647670bca556996abbadbcfb)
- [`#4279`](https://github.com/fomantic/Fomantic-UI/issues/4279)  preserve em units for math, fix h1-h5 to use exact decimals as well [`00b7d08`](https://github.com/fomantic/Fomantic-UI/commit/00b7d089525ac5af6a15fa5075d8377489d1fc35)
- [`#4279`](https://github.com/fomantic/Fomantic-UI/issues/4279) Fixes off by 1px errors in any UI with inputs [`e01309c`](https://github.com/fomantic/Fomantic-UI/commit/e01309c90a07b994d63faca6461bba7a14486ba5)
- [`#4284`](https://github.com/fomantic/Fomantic-UI/issues/4284) - Fixes obvious brand colors.. tbd instagram [`faae37a`](https://github.com/fomantic/Fomantic-UI/commit/faae37a424eb5146d717d975c33a8d3bf22c4e2d)
- [`#4305`](https://github.com/fomantic/Fomantic-UI/issues/4305) Fixes issue with grid alignment inheritance [`7076fbe`](https://github.com/fomantic/Fomantic-UI/commit/7076fbe14fcf1007beeaaaa702e39810a11341e6)
- [`#4354`](https://github.com/fomantic/Fomantic-UI/issues/4354)  [`ad4e939`](https://github.com/fomantic/Fomantic-UI/commit/ad4e93919d5542119b06a69107a7b2846ef7d1f1)
- [`#4368`](https://github.com/fomantic/Fomantic-UI/issues/4368) - Dimmer will now reset settings before each modal show making it simpler to work with multiple modal types in same page [`28bf34e`](https://github.com/fomantic/Fomantic-UI/commit/28bf34ed8a9af485ed0673f6e90d4468c5fab20f)
- [`#4403`](https://github.com/fomantic/Fomantic-UI/issues/4403) cred [`d450ef7`](https://github.com/fomantic/Fomantic-UI/commit/d450ef7552c335ca383656af932ead5d5ad41b99)
- [`#4408`](https://github.com/fomantic/Fomantic-UI/issues/4408) - adds cred [`d849264`](https://github.com/fomantic/Fomantic-UI/commit/d849264b0b7c821ce8ca7701c820ebba32b69a78)
- [`#4412`](https://github.com/fomantic/Fomantic-UI/issues/4412)  redo paths to be more consistent with default theme [`2fd4846`](https://github.com/fomantic/Fomantic-UI/commit/2fd4846e999d6f54ce0054ef03afa2157bce8185)
- [`#4423`](https://github.com/fomantic/Fomantic-UI/issues/4423) Thx [`0992f41`](https://github.com/fomantic/Fomantic-UI/commit/0992f41e90c1cb9702c5b506af1549822d3bf912)
- [`#4423`](https://github.com/fomantic/Fomantic-UI/issues/4423) in next [`4cacf56`](https://github.com/fomantic/Fomantic-UI/commit/4cacf5603126028520a4b3c3bab481bd511c77ef)
- [`#4463`](https://github.com/fomantic/Fomantic-UI/issues/4463) - remove bad dep [`190e8e5`](https://github.com/fomantic/Fomantic-UI/commit/190e8e59bb3ebbaa35fbea6a7d540c09e36596e5)
- [`#4497`](https://github.com/fomantic/Fomantic-UI/issues/4497) check if validation rule is defined when revalidating [`9411e01`](https://github.com/fomantic/Fomantic-UI/commit/9411e0182e6803fd5bb8abd0ebea68ab336f48f9)
- [`#4506`](https://github.com/fomantic/Fomantic-UI/issues/4506) fix subtle overlap of leftward menu [`f584e12`](https://github.com/fomantic/Fomantic-UI/commit/f584e1234e58f4556c11d1bec873d067be0ee180)
- [`#4506`](https://github.com/fomantic/Fomantic-UI/issues/4506) leftward now only checks on rightward, so predefined leftward menus are not touched. Fixes spacing on left dropdown icon [`56865fd`](https://github.com/fomantic/Fomantic-UI/commit/56865fd40379843a2ed558c09c0e5297d383224d)
- [`#4616`](https://github.com/fomantic/Fomantic-UI/issues/4616) - fixes bug with results displaying when using showNoResults. Adds callbacks to many internal methods for better hooks [`9fa01f6`](https://github.com/fomantic/Fomantic-UI/commit/9fa01f607d4d4718c076f9d0d6a986f1a5ea2c14)
- [`#4688`](https://github.com/fomantic/Fomantic-UI/issues/4688) #4692 Fixes issue where backslash and other spcial characters may cause dropdown to fail [`152482a`](https://github.com/fomantic/Fomantic-UI/commit/152482a9e2298608eb81bdd517b53720cd473183)
- [`#4815`](https://github.com/fomantic/Fomantic-UI/issues/4815) change name for setting again to match other remote setting [`1f897b3`](https://github.com/fomantic/Fomantic-UI/commit/1f897b3bb17ef79a582231a17fd2143e94a6c088)
- [`#4872`](https://github.com/fomantic/Fomantic-UI/issues/4872) #4850 Fixes issue with icon offset in header and list [`48aaf9a`](https://github.com/fomantic/Fomantic-UI/commit/48aaf9a74a6bd414cf661048df071d098eed83bd)
- [`#5231`](https://github.com/fomantic/Fomantic-UI/issues/5231) #5809 Recursion in remote search when results are success but return no results on show [`b4edc1b`](https://github.com/fomantic/Fomantic-UI/commit/b4edc1b380fb630314bcdea8584b64569084618c)
- [`#5281`](https://github.com/fomantic/Fomantic-UI/issues/5281) fix issue with descendors cut-off in transparent input [`3a7d36f`](https://github.com/fomantic/Fomantic-UI/commit/3a7d36f343f6070f15142e9dc6e0ee91013e64d3)
- [`#5284`](https://github.com/fomantic/Fomantic-UI/issues/5284) - double disabled styling on inputs [`ae38450`](https://github.com/fomantic/Fomantic-UI/commit/ae3845032fd26c9b5652a49989aedbb8f32f0367)
- [`#5366`](https://github.com/fomantic/Fomantic-UI/issues/5366)  #5975 - Fixes issue with offset not available on window [`18ac909`](https://github.com/fomantic/Fomantic-UI/commit/18ac909518276804e998cf7d92be79f3e66c6647)
- [`#5366`](https://github.com/fomantic/Fomantic-UI/issues/5366)  #5975 - Fixes open rightward/leftward incorrectly adjusting to scroll context [`c598892`](https://github.com/fomantic/Fomantic-UI/commit/c5988929973156915e797f76b13a714ffbda4ae9)
- [`#5522`](https://github.com/fomantic/Fomantic-UI/issues/5522) update jsfiddle link to canonical [`073db05`](https://github.com/fomantic/Fomantic-UI/commit/073db057a98ac9237fc4b7e73f0dc2b4a4e8371a)
- [`#5549`](https://github.com/fomantic/Fomantic-UI/issues/5549) - Fix regression from offsetTarget change [`44b8222`](https://github.com/fomantic/Fomantic-UI/commit/44b82222b0aa5c60a949681def6c02902c86585a)
- [`#573`](https://github.com/fomantic/Fomantic-UI/issues/573)  checkbox example still missing label for [`527498b`](https://github.com/fomantic/Fomantic-UI/commit/527498bddf526b918c2e566a0d817d9cff6f3793)
- [`#5892`](https://github.com/fomantic/Fomantic-UI/issues/5892) - Add onChanging callback [`d168eab`](https://github.com/fomantic/Fomantic-UI/commit/d168eab1710affc262d5c56312fd2cdc993b0e95)
- [`#6043`](https://github.com/fomantic/Fomantic-UI/issues/6043) #5713 code formatting [`8b21e93`](https://github.com/fomantic/Fomantic-UI/commit/8b21e930fc33853dff911b3ab0420789f5ac8054)
- [`#6085`](https://github.com/fomantic/Fomantic-UI/issues/6085) dedupe icons from FA5 port [`1587c0b`](https://github.com/fomantic/Fomantic-UI/commit/1587c0be7e71193f6ec054fc6e6d026f1ce58939)
- [`#6192`](https://github.com/fomantic/Fomantic-UI/issues/6192) centering/bordered icons [`59be6ec`](https://github.com/fomantic/Fomantic-UI/commit/59be6ec5a15ca3ed920b7a3e5e47d1795e024386)
- [`#6192`](https://github.com/fomantic/Fomantic-UI/issues/6192) few missing aliases for outline #6232 [`3f5ca5a`](https://github.com/fomantic/Fomantic-UI/commit/3f5ca5a6954c8f4291794c80c4a9d243a24c2bb8)
- [`#6226`](https://github.com/fomantic/Fomantic-UI/issues/6226) remove testing variable as false [`ca05ebb`](https://github.com/fomantic/Fomantic-UI/commit/ca05ebbdfb52205e9316188b1a8f36fa92ea85de)
- [`#6269`](https://github.com/fomantic/Fomantic-UI/issues/6269) Actually do update for iframeresizer.js [`27ff17b`](https://github.com/fomantic/Fomantic-UI/commit/27ff17b55b2c3af03bf3c1fa7449a44a40f7bafe)
- [`#630`](https://github.com/fomantic/Fomantic-UI/issues/630) Fixes issue with right menu border [`dc50bec`](https://github.com/fomantic/Fomantic-UI/commit/dc50becdc9db2bf24186f0cccb283bfbce89ff15)
- [`#703`](https://github.com/fomantic/Fomantic-UI/issues/703) #4093 callbacks should not occur when using is valid [`d163b57`](https://github.com/fomantic/Fomantic-UI/commit/d163b57745b5b51db087b37c0310d80825b819f3)
- [`#703`](https://github.com/fomantic/Fomantic-UI/issues/703) #4093, is valid no longer triggers UI updates, adds ability to validate individual fields [`ad03335`](https://github.com/fomantic/Fomantic-UI/commit/ad03335509ed7083a908c1b705f07109db5651b3)
- [`#703`](https://github.com/fomantic/Fomantic-UI/issues/703) Adds form 'is valid' method [`9dabc86`](https://github.com/fomantic/Fomantic-UI/commit/9dabc86487dc49834b0cfc2f6d2688f84efff223)
- [`#703`](https://github.com/fomantic/Fomantic-UI/issues/703) RLSNOTES [`8598b65`](https://github.com/fomantic/Fomantic-UI/commit/8598b654de1723ee2f08412c0344ec7742a83891)
- [ref #4398] added hover styling to icon group [`90d4229`](https://github.com/fomantic/Fomantic-UI/commit/90d422942bc7602decfdf7701b6bac5509c6cfa4)
- [ref #904] added 4 positions for corner icons [`002752e`](https://github.com/fomantic/Fomantic-UI/commit/002752eb12debe5912fbb28d17751392b655d16c)
- a day of work.. menus, fixing sidebar floating menu, additions to labels, working labels to integrate with menus. stub for grid [`d293ce9`](https://github.com/fomantic/Fomantic-UI/commit/d293ce95133d6d9673a92f9cac17b230f247452e)
- accessible reveal [`2cfbd6a`](https://github.com/fomantic/Fomantic-UI/commit/2cfbd6a2694686e60b5bcc90b414b99347bf2805)
- accidental console.log in callback [`85bf31c`](https://github.com/fomantic/Fomantic-UI/commit/85bf31c7c3635464e3966eee5d08c6c829750743)
- active min width variable for progress [`265c5da`](https://github.com/fomantic/Fomantic-UI/commit/265c5dab9cdf78b4714a6667d5b696ad3dc9832b)
- actually make classes be inverted [`6745243`](https://github.com/fomantic/Fomantic-UI/commit/67452432cde80670719e842ef2ceea37160bd8cc)
- adjust hover box shadow [`f427697`](https://github.com/fomantic/Fomantic-UI/commit/f42769749280f042fd0fc4abf064512dae92afba)
- aesthetic changes, adds responsive styles [`a3725d6`](https://github.com/fomantic/Fomantic-UI/commit/a3725d692832ea737f50d0e19b81ea12123bd465)
- another broken icon on dropdown example [`0534a8a`](https://github.com/fomantic/Fomantic-UI/commit/0534a8ae8f0310e048efbaf86101c705be45c0d6)
- another extra comma in bower.json [`f59ddaf`](https://github.com/fomantic/Fomantic-UI/commit/f59ddafa5e9e449c9fdfa8617f143e8fba5b64c8)
- assets inside pacakge.js for flag and icon [`33d4cba`](https://github.com/fomantic/Fomantic-UI/commit/33d4cbaf5f363afa1c0c717d0b9ba1a673edb48d)
- attempt at simplifying gtravis [`5db4fa4`](https://github.com/fomantic/Fomantic-UI/commit/5db4fa446bba0331bbea4295a6dfe3e0bf20db4a)
- attempting code restructuring [`c359d4d`](https://github.com/fomantic/Fomantic-UI/commit/c359d4d30eed28b7d18f1587c6e44efa6031568c)
- avatar uses image spacing [`a1ffd02`](https://github.com/fomantic/Fomantic-UI/commit/a1ffd02e875688be475b9d294c9d6b2bc2018a2f)
- bad typo [`73615d5`](https://github.com/fomantic/Fomantic-UI/commit/73615d59105bc3c461e579b55146eff8d83e29b0)
- begin importing font-awesome [`50ef73c`](https://github.com/fomantic/Fomantic-UI/commit/50ef73c00a7318ebdeb7e354ab3d6208f6d87d78)
- better Meteor README [`8242abd`](https://github.com/fomantic/Fomantic-UI/commit/8242abd012f86e313fb3dc4f5782f08d634a6e64)
- better if without child selector. Class .image wont be use other way in .card .content [`edd8373`](https://github.com/fomantic/Fomantic-UI/commit/edd8373c4c41d13d6cd6669df6c60e13a72d2adf)
- better order [`01a1e1c`](https://github.com/fomantic/Fomantic-UI/commit/01a1e1c52d46fb00ad5a34c34fbe86528c38345f)
- better tasks for meteor package.js [`322c865`](https://github.com/fomantic/Fomantic-UI/commit/322c86558dedecf5a5c46b317962352e8f2b166b)
- black button missng hover styles [`a58539d`](https://github.com/fomantic/Fomantic-UI/commit/a58539d94a45ec2047cad9d0af67f04290689b78)
- block header now uses rgba [`158b9aa`](https://github.com/fomantic/Fomantic-UI/commit/158b9aae9266ae7948928375e8db64b3e6a2f2bc)
- brightens tag in highlighting [`bb6f7b1`](https://github.com/fomantic/Fomantic-UI/commit/bb6f7b13725fdc76950c54e5201e102bc97f9d17)
- button changes, default now dark [`8bc437b`](https://github.com/fomantic/Fomantic-UI/commit/8bc437b09caf1da2daba4520e5610d0842a9d167)
- case insensitive e-mail validation [`fede049`](https://github.com/fomantic/Fomantic-UI/commit/fede04934bfc4b556785d739cb9c5d4d430f799a)
- change header on toc [`b920fbe`](https://github.com/fomantic/Fomantic-UI/commit/b920fbe2d658d73c2098d374c4651faf3e69e144)
- changes from live site [`9ed768a`](https://github.com/fomantic/Fomantic-UI/commit/9ed768a0ee870d7e499a0db069d8008adfab0a0f)
- changes to comment [`9a5875d`](https://github.com/fomantic/Fomantic-UI/commit/9a5875d2b9760d9e1242647ef8a98f664e3d328c)
- changes to items [`b26e325`](https://github.com/fomantic/Fomantic-UI/commit/b26e3256eed25257cfdea52b684f1432245d0837)
- changing colors of positive and negative btns [`71fd496`](https://github.com/fomantic/Fomantic-UI/commit/71fd49608bf1beda9215eddfad6abbef09a3870a)
- checks in dropdown changes from iphone branch [`a84d57d`](https://github.com/fomantic/Fomantic-UI/commit/a84d57dcaccdb8a9389e0de1bea504cb5f79a512)
- classname changes to docs [`6752cc2`](https://github.com/fomantic/Fomantic-UI/commit/6752cc26a32b0c79169635224b98d19d69b72216)
- classname fix [`a540d37`](https://github.com/fomantic/Fomantic-UI/commit/a540d37d4ebe8c029f3aee0aa91226a587d765b6)
- cleans up docs on accordion settings [`bd65c26`](https://github.com/fomantic/Fomantic-UI/commit/bd65c2622e721c10e16f25c930feb62f1428dd17)
- cleanup [`7b8621e`](https://github.com/fomantic/Fomantic-UI/commit/7b8621edcb862e424a5773715bf088f14d42527e)
- code samples easier to see [`937bfcf`](https://github.com/fomantic/Fomantic-UI/commit/937bfcf75ca4b014077c80e8124ae45813022ece)
- coding a storm up the ui menu class [`cff2724`](https://github.com/fomantic/Fomantic-UI/commit/cff27242f91e01e09a7c5a1fba9740d8b3b1b451)
- comitting failed 3dtransform attempt for posterity [`9751764`](https://github.com/fomantic/Fomantic-UI/commit/97517646bc3fe75940e09e271f16cdf494913cec)
- comma instead of "or" [`f085f8c`](https://github.com/fomantic/Fomantic-UI/commit/f085f8c1fc305fcd02dc0717686a4b72594b7edd)
- completes button variables [`75b047b`](https://github.com/fomantic/Fomantic-UI/commit/75b047b7f4c62f2e14aa9336b622ed8448b95bfc)
- completion of viisibility module [`9c49fa4`](https://github.com/fomantic/Fomantic-UI/commit/9c49fa433547cc9d66a96182376a0f5b97e0f665)
- condition will never evaluate to true [`7e9e190`](https://github.com/fomantic/Fomantic-UI/commit/7e9e1904ff0423be2bef2df632bb56ea00974da8)
- connecting the missing dots [`6b1d205`](https://github.com/fomantic/Fomantic-UI/commit/6b1d2057f1cfaea293945707c230bb67fca29add)
- continues to make modules conform to design pattern [`f48e3c8`](https://github.com/fomantic/Fomantic-UI/commit/f48e3c851f9d888c4e7847f5ffdf9525e17ee9fd)
- continuing to fix ui input [`8029035`](https://github.com/fomantic/Fomantic-UI/commit/80290352b9c625349a8f0d91dac253780fa7b47d)
- continuing work on ui input positioning [`3d3c513`](https://github.com/fomantic/Fomantic-UI/commit/3d3c51389713158280725b6b1cfc9b14aa44f1d0)
- copy fixes [`6252ac5`](https://github.com/fomantic/Fomantic-UI/commit/6252ac5b707fad927856a6b9c75993b5ccada9be)
- corrected .yellow.card css [`21f4cc8`](https://github.com/fomantic/Fomantic-UI/commit/21f4cc8d10611914a911b82ac29722bcb1ecc39b)
- corrections to settings object [`29420f4`](https://github.com/fomantic/Fomantic-UI/commit/29420f42c8dfde0214bdde274ecc7ad3fc02c789)
- cosmetic error on homepage [`ebdf461`](https://github.com/fomantic/Fomantic-UI/commit/ebdf461a2d024e92a08c798ee607af7389be5ec3)
- day of iterating on header variations, tweaks to homepage, icons, menus [`1443aa6`](https://github.com/fomantic/Fomantic-UI/commit/1443aa6350ebf36f983b20e2deac025ed02a790b)
- days work on messages, icons, segments [`5cd94a1`](https://github.com/fomantic/Fomantic-UI/commit/5cd94a1ad14d5f519599572d24cd358a94564c76)
- dedupe [`dcceb36`](https://github.com/fomantic/Fomantic-UI/commit/dcceb369f0f03f9801f78e789a9cb2550d1276bb)
- default margins message [`8eb3f2c`](https://github.com/fomantic/Fomantic-UI/commit/8eb3f2c762444d7e61706e43577565762378d24c)
- deployed site now uses minified code [`295570d`](https://github.com/fomantic/Fomantic-UI/commit/295570d1bd100d63824b74f1ec2449ce721decd1)
- derping on travis [`2edc95e`](https://github.com/fomantic/Fomantic-UI/commit/2edc95e7756fbd9a9560645406b244f789569ab4)
- disables flex in IE for cards [`#2021`](https://github.com/fomantic/Fomantic-UI/issues/2021)  [`d420cb0`](https://github.com/fomantic/Fomantic-UI/commit/d420cb0908a54828068735025cc97f29726bdfce)
- docpad update [`3242a8f`](https://github.com/fomantic/Fomantic-UI/commit/3242a8fed843599cd809622aebf8224c83511ceb)
- downgrade to node 0.10 to deal with karma incompat [`f687041`](https://github.com/fomantic/Fomantic-UI/commit/f6870412153ab8850cb96ed5de114a9dde62551b)
- dramatically rewrites watch task to boost doc compile performance [`23698de`](https://github.com/fomantic/Fomantic-UI/commit/23698de03fc212bd64008ac3b75990bd6db09145)
- dropdown localsearch default to false [`634d2e0`](https://github.com/fomantic/Fomantic-UI/commit/634d2e0a08d0f905be4b6d6f7c3f025f474eed1c)
- errant console log removal and fixing right margin on labeled icon inputs [`ce9f96b`](https://github.com/fomantic/Fomantic-UI/commit/ce9f96b521b3c937af9075daccc4e6de6ac6581b)
- example fix [`ce956ac`](https://github.com/fomantic/Fomantic-UI/commit/ce956ac169be2627972d0ddad676f4e15e8c60e3)
- final build [`7e34c17`](https://github.com/fomantic/Fomantic-UI/commit/7e34c175f5c9314fbecc21a601254aa9280056e7)
- finalized package.js templates [`2a0c628`](https://github.com/fomantic/Fomantic-UI/commit/2a0c628d5f6e579f1618f4fc7ff914f6377a972f)
- finally fixes the top menu, issue with getCollections [`a618eda`](https://github.com/fomantic/Fomantic-UI/commit/a618eda91c451fc16418cee641cbcd063f91ee4b)
- finally uses legit dropdown for page chooser [`60d7756`](https://github.com/fomantic/Fomantic-UI/commit/60d77564d7929f29025f99549375235f06d25516)
- finish writing dev guide [`b75487d`](https://github.com/fomantic/Fomantic-UI/commit/b75487d544b0c24cf7927923f0da53a4f51d8a9d)
- finished form validation [`55b3712`](https://github.com/fomantic/Fomantic-UI/commit/55b3712847ea06ed28b5bf5a8b7b7bd6ee022c98)
- finishing up comments [`8f4f838`](https://github.com/fomantic/Fomantic-UI/commit/8f4f838d18a65b06b95ee26f1455ccd835a38db4)
- finishing up dropdown module [`5a4e295`](https://github.com/fomantic/Fomantic-UI/commit/5a4e2954d4332ff7286f0acc87b08db492056ad1)
- finishing up the text block page [`92d3bd6`](https://github.com/fomantic/Fomantic-UI/commit/92d3bd6fb3b66f0393b618501e361ac6ef76d196)
- first commit dropdown js [`77dd489`](https://github.com/fomantic/Fomantic-UI/commit/77dd489a7a84d2bc39254ee58db6810b7c20b8c3)
- fit height [`9b971a5`](https://github.com/fomantic/Fomantic-UI/commit/9b971a56ae94f76e6f6c71281467a52d3d910719)
- font awesome files [`dd977b6`](https://github.com/fomantic/Fomantic-UI/commit/dd977b67d6842886509f52c16170d352aa96262d)
- form changes [`85f3f57`](https://github.com/fomantic/Fomantic-UI/commit/85f3f570dac2b41aaa1cb375a9cad8ae0914170d)
- formatting [`5b3ff7e`](https://github.com/fomantic/Fomantic-UI/commit/5b3ff7e895f3b58c32f52a1a3087db284ffd4780)
- formatting fix [`4a1ad7c`](https://github.com/fomantic/Fomantic-UI/commit/4a1ad7c34d70c6be640ca859755c21679b8f8c7c)
- grid changes [`9767c87`](https://github.com/fomantic/Fomantic-UI/commit/9767c87f9c0383f177a1bbe6b043f1e42e4e3a01)
- grid fixes [`8bb2f32`](https://github.com/fomantic/Fomantic-UI/commit/8bb2f325724c68608846c44bb5fb7ffb173e43ee)
- grunt -- update and add bower and watch. [`4995a68`](https://github.com/fomantic/Fomantic-UI/commit/4995a687612037468325bd16ce041401a95dff80)
- header tweaks [`d3c7f19`](https://github.com/fomantic/Fomantic-UI/commit/d3c7f1955ebb2d2cddcd4704757af50e0eb26436)
- hey hey actually working late at night on this, i must really like it [`d9115b7`](https://github.com/fomantic/Fomantic-UI/commit/d9115b7ee9bc821f8c58f6f77f62f73e8cfcaff5)
- hey i got it all running! [`0d99acc`](https://github.com/fomantic/Fomantic-UI/commit/0d99accbb4667f681f6dceabc797bbd8d07a89ad)
- homepage language [`3589b4c`](https://github.com/fomantic/Fomantic-UI/commit/3589b4ccb7d622388a1f1aad8ca95b0547540eed)
- horizontal and vertical flips were reversed [`532d6fb`](https://github.com/fomantic/Fomantic-UI/commit/532d6fb6173fd7e0b8a1d3abcbac47e6ce7d1a78)
- http -&gt; https [`c325005`](https://github.com/fomantic/Fomantic-UI/commit/c325005722094571d62a97500b42e0a5e92918a6)
- icon inputs, and corner labels now color when field is errored [`f4f7a32`](https://github.com/fomantic/Fomantic-UI/commit/f4f7a3295179003dece392da6e4086637705a014)
- icon side [`3addcf6`](https://github.com/fomantic/Fomantic-UI/commit/3addcf6029c8d03545585922844e611dc0a554b9)
- icon, adds plus alias, builds files [`ac29c0e`](https://github.com/fomantic/Fomantic-UI/commit/ac29c0ede81a93faa21dba43b1c9afb4ff05eb4a)
- icons, capitalizations [`bba24b0`](https://github.com/fomantic/Fomantic-UI/commit/bba24b009229e53012545304cad9428d760cf1da)
- images with .image inside .content will display nicely [`0060fa8`](https://github.com/fomantic/Fomantic-UI/commit/0060fa800f16cfc99f8223e592c3e456a0a2f5be)
- increase icon distance slightly [`#2335`](https://github.com/fomantic/Fomantic-UI/issues/2335)  [`13d9d11`](https://github.com/fomantic/Fomantic-UI/commit/13d9d112867236680b49a94d9506c7eb357934a6)
- increase size of attached label padding [`a80e831`](https://github.com/fomantic/Fomantic-UI/commit/a80e831e9d6ed685589ac29c3dce2acd828cf083)
- increases opacity of icon message [`769554b`](https://github.com/fomantic/Fomantic-UI/commit/769554bb19587209889590b1011045df33ea96ef)
- item formatting [`fa9667a`](https://github.com/fomantic/Fomantic-UI/commit/fa9667a6b19ce10cc3ad6c6fdfb4a3a3e1b4c9c4)
- iterating on checkbox/module design pages, form fixes, table fixes, progress fixes [`53df49a`](https://github.com/fomantic/Fomantic-UI/commit/53df49a4c5c157c0dc2f62cf4f78f89ed55476ef)
- iterating on grid [`93fea69`](https://github.com/fomantic/Fomantic-UI/commit/93fea6995a6ff251d5dab78f1d3f2f89ed250601)
- iterating on header themes [`b04914c`](https://github.com/fomantic/Fomantic-UI/commit/b04914ca9e14cb7a8463a88676786490c142c0d1)
- iterating on icon font work [`2d43eb3`](https://github.com/fomantic/Fomantic-UI/commit/2d43eb3bc90d72fad6f04ef4f20deaeabc5d9e6a)
- iterating on intro docs [`f672b07`](https://github.com/fomantic/Fomantic-UI/commit/f672b074d94f66b346333af19990428b9738a1b1)
- iterating on text size issues, rem/em/px [`7bed0a8`](https://github.com/fomantic/Fomantic-UI/commit/7bed0a8aa1080114503e895ff9d44e326571f096)
- iterating on this ish [`cd72369`](https://github.com/fomantic/Fomantic-UI/commit/cd723696cb4bcd36260d8e3e95346f96a30dd622)
- iteration on all the stuffs [`9fe6db4`](https://github.com/fomantic/Fomantic-UI/commit/9fe6db47dfef1e4e0763949320ace4be92f1d95d)
- iteration on button variables [`542d206`](https://github.com/fomantic/Fomantic-UI/commit/542d20651c1a37ff28ddcee8f552710a013c5cb8)
- iteration on docs [`3761273`](https://github.com/fomantic/Fomantic-UI/commit/37612730d68e05adf07178abc0c5b685470df61b)
- iteration on feed, menu fixes for icons [`fc265d0`](https://github.com/fomantic/Fomantic-UI/commit/fc265d0dc194c7616c129e650a027f0f8f68a067)
- iteration on forms, and overall conformity of docs [`4b7c06e`](https://github.com/fomantic/Fomantic-UI/commit/4b7c06e6de84dc2f6f44a664535d5ba659eef5fa)
- iteration on global site module [`9bda901`](https://github.com/fomantic/Fomantic-UI/commit/9bda901d5a2aeb600481106f4677abd2bad960b0)
- iteration on icons [`6104ab5`](https://github.com/fomantic/Fomantic-UI/commit/6104ab5783a429d7c6a8fa5e17fe0304caaa6899)
- iteration on intro page [`a4fad21`](https://github.com/fomantic/Fomantic-UI/commit/a4fad21ea7535d1acd2532194d1c631420f66c8a)
- iteration on module docs [`23b82eb`](https://github.com/fomantic/Fomantic-UI/commit/23b82eb51570ddd444fa5dfe8d79535a06d7bb31)
- iteration on setup [`ed261c9`](https://github.com/fomantic/Fomantic-UI/commit/ed261c9627dd3b576971435ad016771e115d2a30)
- iteration on text menus, label menus [`859f61d`](https://github.com/fomantic/Fomantic-UI/commit/859f61d57260a0bd215ccd42f6dc3867378d4c74)
- label demo fixes [`facfef8`](https://github.com/fomantic/Fomantic-UI/commit/facfef86422620c56b59fb69b1da50d2ede7919f)
- labels [`6c03da4`](https://github.com/fomantic/Fomantic-UI/commit/6c03da4b5c2b1808de7799c837d7f2ffb1d0b6a7)
- language changes, sidebar fixes [`a486469`](https://github.com/fomantic/Fomantic-UI/commit/a486469211b3a99bf75c48afcf46292dde0f4776)
- language on module [`60d9dfe`](https://github.com/fomantic/Fomantic-UI/commit/60d9dfe19a963cb1b8ff652fce63c7f3e3b5f0b9)
- last time [`9ddf9da`](https://github.com/fomantic/Fomantic-UI/commit/9ddf9daf0259cba3bcf0b76503f2680bce1a6b97)
- last update to sidebar before kaputz [`b5c248c`](https://github.com/fomantic/Fomantic-UI/commit/b5c248c59a2ad34bb5b0e22905dbc70d82bd1534)
- late night changes [`491a3a3`](https://github.com/fomantic/Fomantic-UI/commit/491a3a39946bf44379265d616a8d20a7b9fd6811)
- latenight coding iuno why [`3a699d2`](https://github.com/fomantic/Fomantic-UI/commit/3a699d29d764290bc1ce1bbbc2a8f76d31ca2d4f)
- lazy commit of semantic module spec inside shape.. will edit out later [`efc8bdc`](https://github.com/fomantic/Fomantic-UI/commit/efc8bdc920ca4d87f4ab5972127664db6b5c9895)
- like a monkey with a miniature symbol [`d3d6adf`](https://github.com/fomantic/Fomantic-UI/commit/d3d6adf0ff6a7398e95de948f240c165f8a54573)
- lists like a baller [`82ba843`](https://github.com/fomantic/Fomantic-UI/commit/82ba84308a822bd1c05023dfd2c91fb73ef554dd)
- lost pull-requests [`128e2f5`](https://github.com/fomantic/Fomantic-UI/commit/128e2f5a13dc5eb821cdf73981debd63ce374ba1)
- lots of fixes to form and button, adds beginning of checkbox docs [`5f8d295`](https://github.com/fomantic/Fomantic-UI/commit/5f8d2956a8bac66e34431e683685987cde913e75)
- lots of iteration [`7ad57f1`](https://github.com/fomantic/Fomantic-UI/commit/7ad57f1eaefde9fbccea8824b2d77c2e214ec48e)
- lots of new stuff [`8f63998`](https://github.com/fomantic/Fomantic-UI/commit/8f63998a42f72378f167ca2ae7125094c2acc41b)
- lowers size of code icon [`5ae7c31`](https://github.com/fomantic/Fomantic-UI/commit/5ae7c310b36b24d090464ad284edc15cfe7fdef7)
- main package.js plus assets copy for components [`eb601a4`](https://github.com/fomantic/Fomantic-UI/commit/eb601a41c7ebf168a3ddc54754dce425704f1d15)
- make size variables usable [`0a15792`](https://github.com/fomantic/Fomantic-UI/commit/0a157922b6a05220265da5bf5b7ad5e2f3c0620d)
- makes mobile responsive grid integer [`b11541c`](https://github.com/fomantic/Fomantic-UI/commit/b11541c1085c3dd33911607755b568ca001ffd11)
- massive revisions to menu [`1cac5f5`](https://github.com/fomantic/Fomantic-UI/commit/1cac5f52c3ae19315dffd0472c3cf3a05da1ed04)
- matches classic to flat folder structure, removes shaded cause.. its too damn early to do a third theme [`cbaf271`](https://github.com/fomantic/Fomantic-UI/commit/cbaf271d85981a5277039b3b228f6143655a0e68)
- mend [`159d22d`](https://github.com/fomantic/Fomantic-UI/commit/159d22d90640bbe5678467f3ddd3b90aa168bf70)
- menu fixes [`9d4d1e2`](https://github.com/fomantic/Fomantic-UI/commit/9d4d1e21c4adef16324aa7e85ec490d687e9b591)
- menu, last checkin then hitting hay for real [`ecf8ac0`](https://github.com/fomantic/Fomantic-UI/commit/ecf8ac0ada815f1e9ab58bfc40218a8b281a3bae)
- minor fix [`22f4f5f`](https://github.com/fomantic/Fomantic-UI/commit/22f4f5f9e6778554479fdeb050b3535fa745d816)
- minor fix to margins on menu [`1c5f269`](https://github.com/fomantic/Fomantic-UI/commit/1c5f269870cc895b323696da5fcb88ae9cf0a7f1)
- minor menu issues [`92bfaa3`](https://github.com/fomantic/Fomantic-UI/commit/92bfaa378535103b8ad4d1cf636a90b28bdeb15f)
- minor modifications to variations doc [`aacc6da`](https://github.com/fomantic/Fomantic-UI/commit/aacc6da7b013bdb25efbaaefb64cb615dc3d9745)
- missed committing some files [`d38d5eb`](https://github.com/fomantic/Fomantic-UI/commit/d38d5ebc66f75ef7a79b909551acb6e3abd52f85)
- missing changes to reveal from before break [`5e424c6`](https://github.com/fomantic/Fomantic-UI/commit/5e424c665f714cb41d7dd4db834cdcc58bc0a0b7)
- missing closing tag [`638bfc0`](https://github.com/fomantic/Fomantic-UI/commit/638bfc0aa7512d8b83da7f2979b1fd79dbad38fc)
- missing else [`a659a4a`](https://github.com/fomantic/Fomantic-UI/commit/a659a4a20d74ab267bd8f97f90a97df3ae578d71)
- missing files [`8379559`](https://github.com/fomantic/Fomantic-UI/commit/83795598e3d31a622b43f0863b918d56844d0069)
- missing files for flat [`596ef48`](https://github.com/fomantic/Fomantic-UI/commit/596ef48f3fa008fb14bd9f024984f380e1b5b377)
- missing slash [`511f9d0`](https://github.com/fomantic/Fomantic-UI/commit/511f9d0c98dc30808c07d7492006f70025648f77)
- missing space in sentence [`e1d2b51`](https://github.com/fomantic/Fomantic-UI/commit/e1d2b517649fd086fe26c8679fcc4dcadf80f621)
- modal fixes [`ed4c1fc`](https://github.com/fomantic/Fomantic-UI/commit/ed4c1fc550126eaf6c7342935ee21712ff3187d6)
- modal fixes for css animation and other stuff [`184ad5a`](https://github.com/fomantic/Fomantic-UI/commit/184ad5adbc219d0340261efa6490052bfc724143)
- modifies doc 'peek'  menus to use &lt;a&gt; tags, so they can work with submenus [`750edf3`](https://github.com/fomantic/Fomantic-UI/commit/750edf3e21d04c72ddc02946b23b1d3614096f2f)
- module language [`8812b37`](https://github.com/fomantic/Fomantic-UI/commit/8812b37097d4d2676b163a060ef586d86c995b0d)
- mofo travis dying [`346cac5`](https://github.com/fomantic/Fomantic-UI/commit/346cac5bdb559df86a7abaa3d592dbad164dc285)
- more attemps to fix below/above reveal [`33dc001`](https://github.com/fomantic/Fomantic-UI/commit/33dc001333e409deeb82f7939e9dc014859be522)
- more debug [`25f700f`](https://github.com/fomantic/Fomantic-UI/commit/25f700fe289d2f6d9736bc74b2ebd9ba122faeef)
- more dropdown examples, tweaks to code [`459c5c7`](https://github.com/fomantic/Fomantic-UI/commit/459c5c70e839e07e854e8af690e2c138efe2fa07)
- more iteration on API docs [`5a00104`](https://github.com/fomantic/Fomantic-UI/commit/5a00104a28396f7d4120317d179c4e9218113878)
- more on icon spacing for list [`06473a2`](https://github.com/fomantic/Fomantic-UI/commit/06473a2872795ca829f336b048e0f92ef4a8711c)
- more updates to menu [`5fefaaf`](https://github.com/fomantic/Fomantic-UI/commit/5fefaaf8303f8d4d82d89367bc2745991b763a57)
- move grid variables into global [`181fd64`](https://github.com/fomantic/Fomantic-UI/commit/181fd64be5295ba1b70b655c9b4eec758f2f8944)
- move karma config to top level [`679abd3`](https://github.com/fomantic/Fomantic-UI/commit/679abd34985686f3fe392c6a63f775d6664903d2)
- moved save.conditions from module.create to module.show [`5239c8b`](https://github.com/fomantic/Fomantic-UI/commit/5239c8be8a784dee35cbed6ee089d154100a5d05)
- moves animate events into animate.show/animate.hide for popup [`97a09c3`](https://github.com/fomantic/Fomantic-UI/commit/97a09c3034c61312480026a1c51725b1621c28b3)
- moves attach events in sidebar to top level [`f78fc41`](https://github.com/fomantic/Fomantic-UI/commit/f78fc416fa0c43b50017ea33a53820d39a77cc8d)
- moves button and form to ems, NO MORE PIXELSgit status. Redoes checkbox class [`b2c751d`](https://github.com/fomantic/Fomantic-UI/commit/b2c751d9481537ed3370de420f0b93ad6eb04f9a)
- moves clickaway event till after show to prevent bubbling from toggle to doc [`c0c4690`](https://github.com/fomantic/Fomantic-UI/commit/c0c46909c8d7ec87247f5360806c18ef880a9ddc)
- moves example handlers to appropriate location, fixes swap style button [`0a19da0`](https://github.com/fomantic/Fomantic-UI/commit/0a19da0e61afb92c1da86a69eb3cbe3064c5500f)
- moves grid over to % based row height [`0e0c721`](https://github.com/fomantic/Fomantic-UI/commit/0e0c721647151c40539a2d7634869a6fcfa3ebbe)
- moves usage first for dimmers [`599e278`](https://github.com/fomantic/Fomantic-UI/commit/599e278455c7019f14fd60141cd9ba978496714b)
- moving steps over from em [`538694a`](https://github.com/fomantic/Fomantic-UI/commit/538694ace421a7b9ff45198ce2af99ce5deed73e)
- new intermediate size for icons [`7e49f3b`](https://github.com/fomantic/Fomantic-UI/commit/7e49f3be1db848cbf615519aacf1bfcad73be8bd)
- onFailure will now fire in API when XHR Error occurs [`af6934e`](https://github.com/fomantic/Fomantic-UI/commit/af6934e39a824ebaae54c7997903fdc5145f244c)
- onLabelUpdate is now called with the current state [`06c32bc`](https://github.com/fomantic/Fomantic-UI/commit/06c32bc46ef9b9e4ec672ab7e0450c996a70d594)
- one last typo example fix to dividers [`5b48158`](https://github.com/fomantic/Fomantic-UI/commit/5b481583ea1d6fbc839d76d2f3996098455e77c3)
- or text variable [`79caa95`](https://github.com/fomantic/Fomantic-UI/commit/79caa959416521b71c89b30e5a437ebe48b883d9)
- oups, forget to remove the line-height test in basic-icons's file [`912077a`](https://github.com/fomantic/Fomantic-UI/commit/912077a95cbf0a938f7a8e8345068b3e42bccbdd)
- over and over [`76805d0`](https://github.com/fomantic/Fomantic-UI/commit/76805d0f0263e1507ca54658a457d2c399de06db)
- packaging -- changed version to semver. removed deps folder. [`eb88b6f`](https://github.com/fomantic/Fomantic-UI/commit/eb88b6f0a383153f78c6f510976b156675573d30)
- packaging -- removing old deps from components. [`7cfb003`](https://github.com/fomantic/Fomantic-UI/commit/7cfb00314ae261f993f5f2d9b6bdc42e61533482)
- performance improvements to dropdown [`4aa4583`](https://github.com/fomantic/Fomantic-UI/commit/4aa45834f57cd0e1eacd3f56dc466354e1bba43d)
- possible typo [`2b2abeb`](https://github.com/fomantic/Fomantic-UI/commit/2b2abebc5d20c3f7bb70e9fbaa758070821eb0e4)
- preserves variable name styles for dropdown [`b4636cb`](https://github.com/fomantic/Fomantic-UI/commit/b4636cb1bc043974163d9f83304bea67973a5cba)
- ran spellcheck on docs :) [`40d9d00`](https://github.com/fomantic/Fomantic-UI/commit/40d9d001344d7c1728f2a64d38c9c718a37ef2c1)
- refactors icon sizing to allow for more variety [`d3eb647`](https://github.com/fomantic/Fomantic-UI/commit/d3eb647a95fe0e53c34424fc535c9628c2b4a412)
- regenerating [`208b235`](https://github.com/fomantic/Fomantic-UI/commit/208b23571c83b085e3d2188dfda72cf16953c415)
- remove console.log [`93baa5f`](https://github.com/fomantic/Fomantic-UI/commit/93baa5f165b3819711c8045ee6b5eafa69dbe986)
- remove debug [`cc78b80`](https://github.com/fomantic/Fomantic-UI/commit/cc78b803a5a48f9cc4e7b61f36ca74f7ae2b127a)
- remove karma task [`dffc420`](https://github.com/fomantic/Fomantic-UI/commit/dffc420d59bf4325b62c680e5e36ab87d61c54ad)
- remove rounding from other corners [`da6bdbd`](https://github.com/fomantic/Fomantic-UI/commit/da6bdbde430531b550245c9f737dcbaa1c86b3b6)
- remove some trailing spaces and add coverage badge to README [`d6ebd5b`](https://github.com/fomantic/Fomantic-UI/commit/d6ebd5b60ba89a7a6f97b34c71c122f70b6fc072)
- removed assets list [`7f34ff2`](https://github.com/fomantic/Fomantic-UI/commit/7f34ff23fd968732a02a688b9310ef1c9213ed1a)
- removed extra comma [`176185f`](https://github.com/fomantic/Fomantic-UI/commit/176185f88112fcb1340481c5b7c0343f49db872a)
- removed forgotten block [`52e7762`](https://github.com/fomantic/Fomantic-UI/commit/52e7762b2501a1c31bb1a307828cc996e7007bb6)
- removed quotes from keyframes icon-loading [`97e1e6e`](https://github.com/fomantic/Fomantic-UI/commit/97e1e6ea81c6105f4d9bb3961c878c237ad329a2)
- removed typo [`ed45c2a`](https://github.com/fomantic/Fomantic-UI/commit/ed45c2a842ec54f9a7def54de907fb7463ddd93c)
- removes 3d translate from final state of animatino to avoid rounding errors [`f523784`](https://github.com/fomantic/Fomantic-UI/commit/f523784638f9b8befa58a5ebb3aca902c1f46726)
- removes attempt on theme var overrides with lame LESS [`945467f`](https://github.com/fomantic/Fomantic-UI/commit/945467fcf9377a9acd45e11b52cfcb686a20546c)
- removes bold headers [`ee660d3`](https://github.com/fomantic/Fomantic-UI/commit/ee660d3a4c933cddeb40ed6c529367ae86278dce)
- removes box shadow from small sizes [`2512678`](https://github.com/fomantic/Fomantic-UI/commit/2512678168f033cb5abdb3e3c5958ce2e01fc502)
- removes center alignment [`e4330c6`](https://github.com/fomantic/Fomantic-UI/commit/e4330c69131f063c6f0c7a23f455d159435886bf)
- removes commented module definition until can rewrite with latest code [`9d69172`](https://github.com/fomantic/Fomantic-UI/commit/9d691724e1e8dd725b633c9f48c5d2e9aff17883)
- removes console.log [`7c13229`](https://github.com/fomantic/Fomantic-UI/commit/7c13229c339b0cd3ba84ae3d7164713e50952d18)
- removes debug statement [`b0c656a`](https://github.com/fomantic/Fomantic-UI/commit/b0c656a736f134b65955797332bf1b654db137bf)
- removes default select receiving text input stylings [`01e24b4`](https://github.com/fomantic/Fomantic-UI/commit/01e24b4b668f560b720762ed7b97287213843fd5)
- removes design/develop mode from pages that arent ui [`9bf6414`](https://github.com/fomantic/Fomantic-UI/commit/9bf64142ad91036d4a02d4d258ea364dbafc49f7)
- removes dimmer remove from destroy [`3674e28`](https://github.com/fomantic/Fomantic-UI/commit/3674e2833344b9e1824f8fd0e091f7b48c440380)
- removes double directories [`dc6c25e`](https://github.com/fomantic/Fomantic-UI/commit/dc6c25ee7812cf03ac0f6778d937f6510be77e21)
- removes double headers on styleguides [`80817a7`](https://github.com/fomantic/Fomantic-UI/commit/80817a7ffa5437f809bda8953501cf8ed05df6b8)
- removes float from selection dropdown icon, adds setting for touch delay [`2ea17ab`](https://github.com/fomantic/Fomantic-UI/commit/2ea17abdc5bad0822a5cb209db52a68b6957a28d)
- removes incomplete modules from download package [`730376b`](https://github.com/fomantic/Fomantic-UI/commit/730376b513a37bbd3955fe8d38b4244e6ef242d1)
- removes legacy column.css, adds page grid [`fc3aa3a`](https://github.com/fomantic/Fomantic-UI/commit/fc3aa3ac7ecdefc9a11316038975249f114d6232)
- removes loading icon, css spinner is too imprecise [`e6250ef`](https://github.com/fomantic/Fomantic-UI/commit/e6250ef964303586542dd308be6a39eff6868d8e)
- removes massive size, too large [`6a26376`](https://github.com/fomantic/Fomantic-UI/commit/6a263763727c9f7f711ba96a97435609c3d63b5b)
- removes mistaken headline commit (redub) [`73e8f2d`](https://github.com/fomantic/Fomantic-UI/commit/73e8f2dc9ac7e1863709d3571391744650c3d57c)
- removes mistaken headline commit [`eb5fed9`](https://github.com/fomantic/Fomantic-UI/commit/eb5fed9a37dcee5ca9781b39ad352a9669f10848)
- removes old files [`be6a9f8`](https://github.com/fomantic/Fomantic-UI/commit/be6a9f89b806c6d699d5f6052f3c942463a506a5)
- removes old fonts, moves draft elements to doc files [`19ab61f`](https://github.com/fomantic/Fomantic-UI/commit/19ab61ff9448eccef1a377b7ec7882bb547742df)
- removes redundant definition note [`899ece6`](https://github.com/fomantic/Fomantic-UI/commit/899ece6b12b35b6f8d0770ea7e3edc6c62079277)
- removes redundant flat directory from bower/node component, and from src folder. adds boilerplate folder for future boilerplate code [`e8432f3`](https://github.com/fomantic/Fomantic-UI/commit/e8432f3841586de4f92bdb75806ad1ec3f5445a5)
- removes redundant line [`33c9b89`](https://github.com/fomantic/Fomantic-UI/commit/33c9b89d7400aaacbf89c7eb240b1ba973fac48a)
- removes some inline debugging left in modal [`91577de`](https://github.com/fomantic/Fomantic-UI/commit/91577de9ce637a3e564b3b3669f777c8dcd343b7)
- removes undocumented error state for buttons, adds in draft components [`0be2499`](https://github.com/fomantic/Fomantic-UI/commit/0be249972d16701473a0ad8a200412eb8cab24fd)
- removes unnecessary example images [`134d1b9`](https://github.com/fomantic/Fomantic-UI/commit/134d1b9b8577e9fbebe1277383614a062f016dc0)
- removing all dropdown class from menu, changing automatic menu (without js) to be simple menu variation [`2c9cc46`](https://github.com/fomantic/Fomantic-UI/commit/2c9cc46bb982f3f5a231a3402cd12849f31ce2d1)
- removing verbose from tests [`63a7afb`](https://github.com/fomantic/Fomantic-UI/commit/63a7afb5fc24a18b3cb7bf80fbfea604f5d9a6d3)
- reskinning of panel for menus [`93a94f5`](https://github.com/fomantic/Fomantic-UI/commit/93a94f5c90bae909c612bdb7f504f1d79393d82c)
- reverts dropdown menu shift [`96b46a8`](https://github.com/fomantic/Fomantic-UI/commit/96b46a8de056a589cb74ccba2b46694265ad6cf4)
- revisions from working on quirky platform [`3a31239`](https://github.com/fomantic/Fomantic-UI/commit/3a31239ca268e89678c1570dc0f25c705e0d188b)
- revisions to css guide [`2130e96`](https://github.com/fomantic/Fomantic-UI/commit/2130e9644444452935591da9110210c1d38ef12c)
- reworking tags as ui label class [`4137024`](https://github.com/fomantic/Fomantic-UI/commit/41370242a301540fbaa7a720d34ccdb5d3dd512a)
- rtl hints [`c2a2138`](https://github.com/fomantic/Fomantic-UI/commit/c2a2138b5a67cc1e8fc4ebd852f67353ec516975)
- rtl hints updates [`c545fbe`](https://github.com/fomantic/Fomantic-UI/commit/c545fbe72025d60bffc4673e2b0ce14c2723ce01)
- run grunt-coveralls after travis testing [`32250fb`](https://github.com/fomantic/Fomantic-UI/commit/32250fb4f67c87e40936de2d77776b6dc849f319)
- see reddit: turns down the font weight of the damn buttons [`bf85682`](https://github.com/fomantic/Fomantic-UI/commit/bf856822c1968b6666f96174e789469c7cf61e52)
- set @tabularBackgroundColor value to transparent [`e53401f`](https://github.com/fomantic/Fomantic-UI/commit/e53401f57e69940bac1a9e77d37782f8064ce59e)
- set flex direction for grid align [`07eef3c`](https://github.com/fomantic/Fomantic-UI/commit/07eef3c42eb1b2bc36a0d0c082a3a402a922476d)
- sets border-radius when vertical buttons have a single child button [`3fb72fe`](https://github.com/fomantic/Fomantic-UI/commit/3fb72fe93f8c4d6d78653b9a5f9ed284112a45fd)
- several fixes for checkbox, updated form example [`81fb1e4`](https://github.com/fomantic/Fomantic-UI/commit/81fb1e4745c78eb5806df698be1f596965dbab59)
- shapes fix [`03ec02b`](https://github.com/fomantic/Fomantic-UI/commit/03ec02b9fa248951b0b5d03cbdc4c6e960ccd9c3)
- simple test files to ship a css pacakge with all UI [`761cc4f`](https://github.com/fomantic/Fomantic-UI/commit/761cc4f19b2d4eab63896577dd90d84e04ce32c6)
- slight tweak to spec json [`834e3ab`](https://github.com/fomantic/Fomantic-UI/commit/834e3abbd9c6ad3f4c88542925b0aab2c04756f4)
- src [`619bee1`](https://github.com/fomantic/Fomantic-UI/commit/619bee1fa41ce26a6b5e21502735b08d97aa18a1)
- starting on text blocks [`aa2a200`](https://github.com/fomantic/Fomantic-UI/commit/aa2a2003ccaba6e0b7f447e5c65922cc6112c428)
- still had url messed up for accordion [`b052bfd`](https://github.com/fomantic/Fomantic-UI/commit/b052bfdb698e41f3dd0d42ffab59583efd8a0fa7)
- structure -- altered component.json to match new file structure. [`ca5821a`](https://github.com/fomantic/Fomantic-UI/commit/ca5821a3ef2f081024f848e73ce7c44d9b901883)
- structure -- c style comments not part of json spec. [`0d94703`](https://github.com/fomantic/Fomantic-UI/commit/0d9470307e1ca10d285189b55c99bc335c645021)
- structure -- getting odd error about library name [`bf15586`](https://github.com/fomantic/Fomantic-UI/commit/bf1558685b14e0ebc530c3c5fb0cc6c5a74c7488)
- structure -- grunt watch and upgrade. [`3957c5a`](https://github.com/fomantic/Fomantic-UI/commit/3957c5ac3c287026e6e05e1233a373c5ea656066)
- structure -- ignore non source files. [`9aa4c0c`](https://github.com/fomantic/Fomantic-UI/commit/9aa4c0c3ea6b553ba63d1f40db1ffe7182a94410)
- structure -- include semantic bower package in docs. [`be91265`](https://github.com/fomantic/Fomantic-UI/commit/be912653bf015def4da657296980b8a901eed457)
- structure -- moved src from node project to main project. [`056ab46`](https://github.com/fomantic/Fomantic-UI/commit/056ab468f88994dc8bcfc623bd472b8268e4016a)
- structure -- slashes out of component. [`8e8a20b`](https://github.com/fomantic/Fomantic-UI/commit/8e8a20b713b8b5c89cff00f44ecf05948c68ac86)
- structure -- take out components folder. [`b8609a5`](https://github.com/fomantic/Fomantic-UI/commit/b8609a5f9dbd4c4f980112ab87eaa19f976b21f7)
- structure -- typo in component. [`9cdee47`](https://github.com/fomantic/Fomantic-UI/commit/9cdee479187fcc36e66c006e67b304d8d6f04bea)
- structure grunt watch task. [`e9f5d6e`](https://github.com/fomantic/Fomantic-UI/commit/e9f5d6eebc64f5b265742e34d15279c4e030432a)
- stuff jack forgot to commit [`ca51582`](https://github.com/fomantic/Fomantic-UI/commit/ca51582bebb1a80058b26da8b60cb7090c89cf08)
- sub classes basic icon set to avoid issues with concatenated version icons not working [`68f4dfb`](https://github.com/fomantic/Fomantic-UI/commit/68f4dfb15ef5c4dafde66b04fc10c2ae03ba1990)
- support advertisement added to homepage [`c230fc0`](https://github.com/fomantic/Fomantic-UI/commit/c230fc039d258419fc216de2bf00e8c9a2e629c7)
- swap conditional on dev packages [`eb60dfb`](https://github.com/fomantic/Fomantic-UI/commit/eb60dfb3a265f1e93efea5ab8ea0b084767c9cc5)
- swapping over sidebar to use touch events, no longer sidr lib [`b042bb4`](https://github.com/fomantic/Fomantic-UI/commit/b042bb478e8a3f6c3952a8cd5967cae4e8f35468)
- swaps all docs to use ui headers instead of h1-h6 [`6454356`](https://github.com/fomantic/Fomantic-UI/commit/64543560ffa84ba1d0f61eaa38a44b14c9d95481)
- swaps disabled/enabled state on rating [`7c4e053`](https://github.com/fomantic/Fomantic-UI/commit/7c4e053c153527cd69558de91a39b02d63cac1ce)
- switches grid back to start of day (% based gutters) [`5658b10`](https://github.com/fomantic/Fomantic-UI/commit/5658b10d1d69ed87d6947b0fc10410457c403c26)
- temporarily removes reference to roadmap [`5b93e21`](https://github.com/fomantic/Fomantic-UI/commit/5b93e2168dd9066f949ca83e092010d8b2685484)
- terrible grammar / typo fix [`fe70cf4`](https://github.com/fomantic/Fomantic-UI/commit/fe70cf462620f3e47bb724e4cc865f79f6fe0719)
- tertiary button borders [`64d4284`](https://github.com/fomantic/Fomantic-UI/commit/64d4284866f761475622c440074a3a1e480b661f)
- tertiary buttons fix [`37770fd`](https://github.com/fomantic/Fomantic-UI/commit/37770fdacf73d07c43c5fe430a0af8a5b33f8860)
- test ssh [`0e44f92`](https://github.com/fomantic/Fomantic-UI/commit/0e44f925b3d8d004d7dbeebd0299074d3bd6c443)
- test stuff [`c9feedd`](https://github.com/fomantic/Fomantic-UI/commit/c9feedd0f1f23dd36d8f1ad9631d2272e136b0ba)
- testing include order [`d99bd4e`](https://github.com/fomantic/Fomantic-UI/commit/d99bd4e747b0dde2800fe8cb2165da79a771e27e)
- testing new repo [`fab1dc1`](https://github.com/fomantic/Fomantic-UI/commit/fab1dc1369552a4c6699d632bc6b7340abd9b5f3)
- text menu: fixes box shadow from appearing [`75b69ce`](https://github.com/fomantic/Fomantic-UI/commit/75b69ce5cde4f815d42771615090a43d9ac4b84f)
- text on grid [`4ea100b`](https://github.com/fomantic/Fomantic-UI/commit/4ea100bdda83453976a5b161c17a7e7992da8217)
- the fallling asleep commit [`0879886`](https://github.com/fomantic/Fomantic-UI/commit/0879886a5e3294c73a56d0be13fa125bb028c6b3)
- tick up version [`c24b1df`](https://github.com/fomantic/Fomantic-UI/commit/c24b1df124afa2ddc8c8304777b9ab36f37015a9)
- tiered menu: fixes sub menu active item color [`f8f530c`](https://github.com/fomantic/Fomantic-UI/commit/f8f530ca99776b655694fd62e56cf8d0a666045e)
- tightens up modal so it sits now 4% inside of a page grid instead of flush along edge [`3dd8d94`](https://github.com/fomantic/Fomantic-UI/commit/3dd8d94af1c79b939b55d6fece14530bf8a25bf5)
- time to integrate menu [`a476ad6`](https://github.com/fomantic/Fomantic-UI/commit/a476ad6d10b5f65fb071d04477afc58d3d9b013f)
- tiny checkbox example update [`f60fa4a`](https://github.com/fomantic/Fomantic-UI/commit/f60fa4addc2a2db654c26484a624135be4c79f74)
- tiny example fixes [`d9dc4ca`](https://github.com/fomantic/Fomantic-UI/commit/d9dc4ca5e78ea6586c493ba2111e2a96be3a0cf0)
- tiny text fix [`e84560e`](https://github.com/fomantic/Fomantic-UI/commit/e84560e677168bd00c53fccd4c40054e95d6e9f9)
- transition buildP [`4305f72`](https://github.com/fomantic/Fomantic-UI/commit/4305f7232febeed02eb45759db05f434c7408ac9)
- transition requires repaint after animation [`700fda5`](https://github.com/fomantic/Fomantic-UI/commit/700fda509eaaca8c56679917d11611a8c399cd65)
- travis.yml now requires dot [`c93ab70`](https://github.com/fomantic/Fomantic-UI/commit/c93ab70351f7f74619dbb16eb1341ce27c9db48d)
- try updated deps [`c1d8bdc`](https://github.com/fomantic/Fomantic-UI/commit/c1d8bdc98738b7f166b62e767510c1e70a186c6b)
- tweaks on menus, removes flat legacy [`5cc1c2d`](https://github.com/fomantic/Fomantic-UI/commit/5cc1c2d834ea7e092a47b0f9a39a4cfe058a2c43)
- tweaks sizes of icons [`385bf69`](https://github.com/fomantic/Fomantic-UI/commit/385bf698991eae2a9704864f1aba9cfd06fa7159)
- tweaks to corner labels [`6a21d09`](https://github.com/fomantic/Fomantic-UI/commit/6a21d09cb439e04ba7b7b1cf82f461b9eda4a4f0)
- twiddling around with transition to fix in/out [`ace5a1f`](https://github.com/fomantic/Fomantic-UI/commit/ace5a1f411d81201ac34aded30e466cd4720e18b)
- typo [`d66ccdd`](https://github.com/fomantic/Fomantic-UI/commit/d66ccdda4224c57cabf2e19611ce6abd85c7197a)
- typo in css [`e6401fb`](https://github.com/fomantic/Fomantic-UI/commit/e6401fb252e861aa35b340adf70d550c09923640)
- typo in js [`c6ad59d`](https://github.com/fomantic/Fomantic-UI/commit/c6ad59d28b6498c98e2a9d67d08cd7e6e465a670)
- typo in popup docs [`333eb34`](https://github.com/fomantic/Fomantic-UI/commit/333eb34b43bdecad9d8df50d7618c2ec2752e7f6)
- typo in property name [`2081967`](https://github.com/fomantic/Fomantic-UI/commit/2081967faf0ae2fac35cd99637e54f2dc9672672)
- typo in sortable tables [`e46bde6`](https://github.com/fomantic/Fomantic-UI/commit/e46bde670b1c63af658db45147c18b115ea59aaf)
- updating form.js [`a2e8638`](https://github.com/fomantic/Fomantic-UI/commit/a2e863829d3c52a7b3052d43f7987d20c69aa29b)
- updating form/block class [`a8a36f0`](https://github.com/fomantic/Fomantic-UI/commit/a8a36f093914748ed9d937f9848ac866bff59586)
- updating structure of docs [`ed4f872`](https://github.com/fomantic/Fomantic-UI/commit/ed4f872ffc971e9d64666bea753d3db3a8dd6bd5)
- upgrades docpad [`f2115a7`](https://github.com/fomantic/Fomantic-UI/commit/f2115a7e9c57fa123817e630021a5d949740c313)
- use :only-child instead for tfoot fix [`cad08c5`](https://github.com/fomantic/Fomantic-UI/commit/cad08c555fb489839e29087830cf5dcac27d5157)
- version uptick on home [`249d9d2`](https://github.com/fomantic/Fomantic-UI/commit/249d9d2c1e5ba952671d54054cf75cb44f8d26c6)
- weekend updates [`cd94238`](https://github.com/fomantic/Fomantic-UI/commit/cd9423827ef6947eec84eedf8a6a67a3d3253f8f)
- whitespace [`3b4e3ea`](https://github.com/fomantic/Fomantic-UI/commit/3b4e3ea0071d7b0e0983853e08fe1e9794a0d765)
- why am i working on this all night [`0294abd`](https://github.com/fomantic/Fomantic-UI/commit/0294abd5f1eb5f3d1be7ea6314529387c4605aa0)
- wording on readme [`c5d67b3`](https://github.com/fomantic/Fomantic-UI/commit/c5d67b3d65e58fc60f291e2a7cd1ad8ec6362928)
- work on grid [`1f4a1db`](https://github.com/fomantic/Fomantic-UI/commit/1f4a1dbee4588c59da7df3434f51a178080a0886)
- work on menu docs [`9f4427d`](https://github.com/fomantic/Fomantic-UI/commit/9f4427d075049d48f800204339f7e72610668cad)
- working on fixing sidebar with new menu [`26c2fa8`](https://github.com/fomantic/Fomantic-UI/commit/26c2fa850e3254ac5515f2552805ce0efb6b4790)
- working on homepage example [`513c182`](https://github.com/fomantic/Fomantic-UI/commit/513c1828c5ea3520da4082a90588583df32c588a)
- working on tags, fixed all the old menus. 3am on a friday yeahh [`bdf6bad`](https://github.com/fomantic/Fomantic-UI/commit/bdf6bad38ddb5ce465c5d6793c230c7bafc93776)
- working sidemenu iphone style [`51cf3f3`](https://github.com/fomantic/Fomantic-UI/commit/51cf3f355e41f0ad19d9cc4145d328fe344f5734)
- writing docs for modules, fixing paths [`9d7f6cc`](https://github.com/fomantic/Fomantic-UI/commit/9d7f6ccda9bb5c11901112368e7866cbc9f553fd)
- xperimental rewrite of popup to use custom offsetParent [`#1605`](https://github.com/fomantic/Fomantic-UI/issues/1605)  [`91bdbb8`](https://github.com/fomantic/Fomantic-UI/commit/91bdbb8742cba410b3cea3be2951794b15f66536)
- zone.js/issues/319 Loosen equality on undefined check for determining input event [`d028ed1`](https://github.com/fomantic/Fomantic-UI/commit/d028ed19b06ec25ddb033476eff8cebf2338abd7)
- zzz [`165ea37`](https://github.com/fomantic/Fomantic-UI/commit/165ea370de356dbaed7360f5ba795e141a4d41ae)


## Bug Fixes

### Dropdown

- Check if search is active and focus/blur the search field when toggling the dropdown with the icon [`ba8aae5`](https://github.com/fomantic/Fomantic-UI/commit/ba8aae52bec367d2035f781bb6bdf9008d6333e1)
- Only check option value to determine if option is selected [`3a941ac`](https://github.com/fomantic/Fomantic-UI/commit/3a941ac09f4b892266625d3de9748557bcd3952d)
- Only update text if action is activate or combo [`c296538`](https://github.com/fomantic/Fomantic-UI/commit/c296538616b4d1d8522dd81bbccb9df84bc71cb6)
- display sub menu on the left when if cannot fit screen [`4d52d37`](https://github.com/fomantic/Fomantic-UI/commit/4d52d37e0c08cdaf4d81aebc2c5b3cde60e0cadb)

### Flag

- Fix wrong flag position for Myanmar / Burma [`e892ca0`](https://github.com/fomantic/Fomantic-UI/commit/e892ca080a0649579f2ecb7f8cec2421c7fc3a65)

### Form

- Set color in ms input placeholder pseudo selector to important [`8742826`](https://github.com/fomantic/Fomantic-UI/commit/8742826cb2ee724f73c4bb14279d7557f436a96a)


### Misc Fixes

- Fix &lt;body&gt; being set to position relative when dimmable class applied [`a74d21a`](https://github.com/fomantic/Fomantic-UI/commit/a74d21a2f32dbe7a5199fe3b089626afe28fb095)
- Fix &lt;select&gt; chained reference with dropdown init [`904caac`](https://github.com/fomantic/Fomantic-UI/commit/904caacb7afdcd99b5f05c993015f070cf886162)
- Fix &lt;select&gt; inside form &gt; inline field [`0690850`](https://github.com/fomantic/Fomantic-UI/commit/0690850b5deb3e8ebf63193df87d6a410b7d180b)
- Fix (x) item menu, labeled icon menu [`c7b4981`](https://github.com/fomantic/Fomantic-UI/commit/c7b4981f224383c966a7e2f2059db812dff89bed)
- Fix 1px offset on search selection input [`f69995d`](https://github.com/fomantic/Fomantic-UI/commit/f69995d8c0116015854845adc26abfa88ec65996)
- Fix 2.0 release date [`d72d351`](https://github.com/fomantic/Fomantic-UI/commit/d72d351986e5b7efd5dcb24447bcaffde8760320)
- Fix 2.0 to be backwards compatible with emsize variables from 1.0 [`e160570`](https://github.com/fomantic/Fomantic-UI/commit/e1605707a237ee8c2cef3d40d25cdb89418e722b)
- Fix @defaultEasing and @transitionEasing variable duplication, Fix @defaultDuration and @transitionDuration variable duplication [`663e2c2`](https://github.com/fomantic/Fomantic-UI/commit/663e2c2569937f11a48926b9dad3fda86a91b61d)
- Fix @type variable [`ab8fc99`](https://github.com/fomantic/Fomantic-UI/commit/ab8fc99cea4967efa2e930713b767666da2ecf19)
- Fix @yordis [`0b11360`](https://github.com/fomantic/Fomantic-UI/commit/0b11360752c3176bf0e9f1a7432cc566cb507798)
- Fix API abort to also resolve promise [`5a964f8`](https://github.com/fomantic/Fomantic-UI/commit/5a964f8385cd329763e73a60adeb8acf18c5f802)
- Fix API to use session storage for caching values so they are available across a session [`d951380`](https://github.com/fomantic/Fomantic-UI/commit/d951380b4048a2d88878e628dcd452d72579a96b)
- Fix FF dimmer issues with preserve-3d, horizontal/vertical flip work with just perspective prop anyway [`e674afa`](https://github.com/fomantic/Fomantic-UI/commit/e674afa101c4b59aa39a5f8f2863aa64046a32f0)
- Fix FontAwesome header version [`7a7f9c3`](https://github.com/fomantic/Fomantic-UI/commit/7a7f9c36e9cb2ebd20c6373df7d44457e68cedb6)
- Fix Menu dropdowns not closing in IE11 [`#409`](https://github.com/fomantic/Fomantic-UI/issues/409)  [`44b16bd`](https://github.com/fomantic/Fomantic-UI/commit/44b16bdb5da56a99629c6da8365d0c65a77d4bb6)
- Fix NPM update to not install unless new version [`d67ca95`](https://github.com/fomantic/Fomantic-UI/commit/d67ca956fce477ff300c5b630e8a302d5e1eab4d)
- Fix URL validation isssue with form [`00f17f7`](https://github.com/fomantic/Fomantic-UI/commit/00f17f73459ae6dc9449f097d434b36b7ad55456)
- Fix accidental revert of sidebaR [`33b1976`](https://github.com/fomantic/Fomantic-UI/commit/33b197621cde23df3f9fe3d6aebdf5a03b198ab1)
- Fix accidental use of ES6 function type. (I gotta stop doing this) [`1c0a565`](https://github.com/fomantic/Fomantic-UI/commit/1c0a5658825672335c8c852b1d7ac3e5d824fca6)
- Fix accordion menu formatting [`1eeb0c2`](https://github.com/fomantic/Fomantic-UI/commit/1eeb0c28409f541fbfe322d6f4bac264351ae917)
- Fix accordion transition in webkit to use useFailSafe [`71d8659`](https://github.com/fomantic/Fomantic-UI/commit/71d8659758b426c8e90c192f2c0bc601600c8464)
- Fix action input to allow for themes that change button padding [`e9d2f22`](https://github.com/fomantic/Fomantic-UI/commit/e9d2f22a6ce4c99d0ab5d6836caa905b0cadb1fd)
- Fix activator with settings.popup [`63561c5`](https://github.com/fomantic/Fomantic-UI/commit/63561c514f7961f36d3de3246285fd1ab9d33f30)
- Fix active hover color [`ab8d581`](https://github.com/fomantic/Fomantic-UI/commit/ab8d5812ab448a4fa15114c1098d0d4e80520279)
- Fix ad placement [`3fe8e84`](https://github.com/fomantic/Fomantic-UI/commit/3fe8e84fe23cfb5228bfb5da366d1241ffdcec7d)
- Fix admin flag set in example json! [`#2453`](https://github.com/fomantic/Fomantic-UI/issues/2453)  [`82d9c2d`](https://github.com/fomantic/Fomantic-UI/commit/82d9c2d9cfc43cbdcc42cab30c4e416e390ab37d)
- Fix admin issues [`d1c6b9b`](https://github.com/fomantic/Fomantic-UI/commit/d1c6b9b7bacd59ea30e3d53222e5767401985929)
- Fix admin tasks failing to create npm repos for single components [`82159da`](https://github.com/fomantic/Fomantic-UI/commit/82159dafeb4d6dbc6f2347a0d9fc7bd20f66f6d2)
- Fix admin tasks to use commit SHA of last release [`#1607`](https://github.com/fomantic/Fomantic-UI/issues/1607)  [`e3f66ec`](https://github.com/fomantic/Fomantic-UI/commit/e3f66ec2a0a69db2212d966a4d1c6c42d9cdd540)
- Fix advertisement overflow on mobile [`e19e801`](https://github.com/fomantic/Fomantic-UI/commit/e19e80173ebaeedc1c952f385a4c3e34e758fe69)
- Fix alignment inside flex containers for text and valign [`05fc0f8`](https://github.com/fomantic/Fomantic-UI/commit/05fc0f84ed02339298913300b85b91c274743444)
- Fix all the linting errors i forgot to check [`b3612b2`](https://github.com/fomantic/Fomantic-UI/commit/b3612b2792b8f1c564838a3a62d6025bc20e95a5)
- Fix animation in webkit [`1a0b94e`](https://github.com/fomantic/Fomantic-UI/commit/1a0b94e97a0a1f23ef4788167472675b6cde26bc)
- Fix animations to return to same direction, fix css for consistent formatting [`018fb85`](https://github.com/fomantic/Fomantic-UI/commit/018fb8503c3c868a4537fe158af35a07a937c5c1)
- Fix another example bug [`00f2be0`](https://github.com/fomantic/Fomantic-UI/commit/00f2be048afec9cfd59477aafffbea9935bc5a1b)
- Fix arrow inheritance [`a1f4fe4`](https://github.com/fomantic/Fomantic-UI/commit/a1f4fe4ecc7c85b9ed70db90e356b05ac39c820b)
- Fix attached fixed menu border [`3e6634b`](https://github.com/fomantic/Fomantic-UI/commit/3e6634bf4aee6e67be14e3c68e5b48b6e4aca13b)
- Fix attached label element pading [`512e7ad`](https://github.com/fomantic/Fomantic-UI/commit/512e7ad288c5a9a37a8a64ce8ed1aeb3b9ea8846)
- Fix attached message to segment [`80fb00a`](https://github.com/fomantic/Fomantic-UI/commit/80fb00a6364acbf28aba4ef84eb8ae6b0bb0f290)
- Fix attached segment to tabular menu [`49a8ea9`](https://github.com/fomantic/Fomantic-UI/commit/49a8ea9d7222a7846ae685362aa6282d090a5bba)
- Fix attached step spacing [`41cb709`](https://github.com/fomantic/Fomantic-UI/commit/41cb7095855fbb74cd662c8187fe5dd4938e1137)
- Fix attached tabular menu spacing, pointing active header color [`6ba4506`](https://github.com/fomantic/Fomantic-UI/commit/6ba4506300fd1f08f1641580f268759e04021cfa)
- Fix attached/block inheritance. Now works together well [`1013cf5`](https://github.com/fomantic/Fomantic-UI/commit/1013cf512d64aaafa8c27e11e410c4dcbdac54f1)
- Fix autoinstall breaks when param used after git clone of repo (no package manager) [`7afba22`](https://github.com/fomantic/Fomantic-UI/commit/7afba22cc77c409332c070fcaca61f1b1535e877)
- Fix avatars in list example [`b61f395`](https://github.com/fomantic/Fomantic-UI/commit/b61f3953ad2b51c0180ea2a2baec7fb1cb4950fe)
- Fix background colors with grids [`dfa2e02`](https://github.com/fomantic/Fomantic-UI/commit/dfa2e029d3a78634dd3ca50866c5680990577c41)
- Fix bad multi-edit on button [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280)  [`ff60600`](https://github.com/fomantic/Fomantic-UI/commit/ff60600e2f761e417fe6d82b95965d0e6dcf27c0)
- Fix basic inverted background color in default theme [`535a79f`](https://github.com/fomantic/Fomantic-UI/commit/535a79f58ea153dc697944c526d50415ec1e4170)
- Fix basic step theme [`260e15d`](https://github.com/fomantic/Fomantic-UI/commit/260e15dc6eb706a41d6c685296e58e74d30be4ca)
- Fix basic step theme, bring back old teal [`e7cb4f2`](https://github.com/fomantic/Fomantic-UI/commit/e7cb4f290eac00f52a900008827857100b20a4c6)
- Fix basic table segment [`6a42e3d`](https://github.com/fomantic/Fomantic-UI/commit/6a42e3dfb1434aaa1e5b5561b3f00a9ea2e43557)
- Fix basic table theme [`81abc21`](https://github.com/fomantic/Fomantic-UI/commit/81abc21172fe1868fb988e5752b87c84b7a1399f)
- Fix bookish/chubby theme font size variables [`f063d65`](https://github.com/fomantic/Fomantic-UI/commit/f063d6504e93584b42b35149eaf204dbe4fd16b0)
- Fix boolean flag for allowReselection being flipped [`ffc99e5`](https://github.com/fomantic/Fomantic-UI/commit/ffc99e5b66a0b90dd9c29d54412980ccf8d3a2d1)
- Fix border colors to match, add veryStrongTransparentBlack. Increase contrast on checkboxes [`ded08e3`](https://github.com/fomantic/Fomantic-UI/commit/ded08e39f77da048bfb774f0f0f0affb78e75cbc)
- Fix border radius on dropdowns in vertical menus [`85c73ab`](https://github.com/fomantic/Fomantic-UI/commit/85c73ab953de3449f1532fbef81f0a2e3e2e6f8f)
- Fix border radius on first item of attached menu [`5c54940`](https://github.com/fomantic/Fomantic-UI/commit/5c54940a949281598eaedf9c0ed37d084d910acb)
- Fix border radius on last inline-flex item [`ce76685`](https://github.com/fomantic/Fomantic-UI/commit/ce76685fc066ea4cc3302b51eabe3692bdf2e1df)
- Fix border radius to be absolute in labels [`c2000bc`](https://github.com/fomantic/Fomantic-UI/commit/c2000bc8d9a853f11ad875781951f5d3661901a3)
- Fix border radius transitoning on dropdown [`9edb9b4`](https://github.com/fomantic/Fomantic-UI/commit/9edb9b4c6dfe778eafeeea3cf2d5d3dbeaf10fd3)
- Fix border top on fixed bottom [`8d4b0f2`](https://github.com/fomantic/Fomantic-UI/commit/8d4b0f248b192f283a74c4ad362c391131065568)
- Fix border-top on accordion to not be removed with wrapping div [`0ce7eca`](https://github.com/fomantic/Fomantic-UI/commit/0ce7eca5d618fd1e96e47a611b52c0c4cfa36fa9)
- Fix bordered image selector [`547e8c5`](https://github.com/fomantic/Fomantic-UI/commit/547e8c551f0ce4a7be641740199574ad37d5b80f)
- Fix bottom attached buttons on card margin [`be5786d`](https://github.com/fomantic/Fomantic-UI/commit/be5786d3969fd2c557ef389e8d5b4f85f484c294)
- Fix bottom to use bottom-margin, instead of bottom prop [`c38cb19`](https://github.com/fomantic/Fomantic-UI/commit/c38cb190752b41efe48d77d29b3f87c2ce394a99)
- Fix bower.json [`a67e1db`](https://github.com/fomantic/Fomantic-UI/commit/a67e1db355817185f0d5e12c22203d14ec415d72)
- Fix breadcrumb em rounding [`9b2865f`](https://github.com/fomantic/Fomantic-UI/commit/9b2865f91667f5dc295cbee8b9403d5c674a56c6)
- Fix broken accordion due to ec029e3275d4a0c117b1b157e753e414f237abbf [`ee1df7c`](https://github.com/fomantic/Fomantic-UI/commit/ee1df7c90ea50bf08579f86628e1073c9f87709f)
- Fix bug in has direction that causes animations with name containing in/out to work incorrectly [`#1623`](https://github.com/fomantic/Fomantic-UI/issues/1623)  [`b66dfac`](https://github.com/fomantic/Fomantic-UI/commit/b66dfac9eab067c84fb2833301732c53c1ea87fb)
- Fix bug in mockResponseAsync [`89f35d3`](https://github.com/fomantic/Fomantic-UI/commit/89f35d3a49813f0446bd1cdd1ee59190865dd20b)
- Fix bug in mouseclick on menu item [`90d1215`](https://github.com/fomantic/Fomantic-UI/commit/90d1215f48a338d9167c25a7b2761a090f270082)
- Fix bug in nested icons in amazon button theme [`84ad0ea`](https://github.com/fomantic/Fomantic-UI/commit/84ad0eaf5a0f20c74ee4a0419320623630530de7)
- Fix bug in right labeled icons [`acd73ce`](https://github.com/fomantic/Fomantic-UI/commit/acd73cec414523f315415b47543cff60b2614223)
- Fix bug in search related to DOM fragment removed from document [`b8a14c2`](https://github.com/fomantic/Fomantic-UI/commit/b8a14c2917529f1343459a832a05c1920c7a87d1)
- Fix bug in segment only-child [`6a4ae27`](https://github.com/fomantic/Fomantic-UI/commit/6a4ae270a163253c154b49ee8ad53a1c809f713a)
- Fix bug in shape when passing jq object [`a4b6a79`](https://github.com/fomantic/Fomantic-UI/commit/a4b6a798ce5117f24ca7008274a62022e9043307)
- Fix bug in sticky when using offset setting [`7d0621c`](https://github.com/fomantic/Fomantic-UI/commit/7d0621c1c059c08cb48866a0bdc1c5027fa57fd9)
- Fix bug where equal height rows would always expand to 100% width [`7c6babf`](https://github.com/fomantic/Fomantic-UI/commit/7c6babff7905d2e6f5ab13265245b39d47eba629)
- Fix bug with autofocus modifying focus of modal fields [`dcf6a93`](https://github.com/fomantic/Fomantic-UI/commit/dcf6a933956a3cbc82a63a99fbf84ea84ce4b779)
- Fix bug with doubling grid setting width [`#1635`](https://github.com/fomantic/Fomantic-UI/issues/1635) [`#1716`](https://github.com/fomantic/Fomantic-UI/issues/1716)  [`3f7033d`](https://github.com/fomantic/Fomantic-UI/commit/3f7033df5cad7ce49b8e52978d3f1147a4403485)
- Fix bug with mobile grids that arent stackable or doubling [`773dd3a`](https://github.com/fomantic/Fomantic-UI/commit/773dd3a566cd1f9f4a02676a9474e7fcc461fac6)
- Fix bug with search input inside dropdown [`ccf830a`](https://github.com/fomantic/Fomantic-UI/commit/ccf830a6009bcf4a629b72ae9bf8d1971ab86781)
- Fix bug with top passed bottom passed in visibility [`415a67d`](https://github.com/fomantic/Fomantic-UI/commit/415a67dedbd1c04da01f43fed3680fa4c35a9903)
- Fix build error in minified css causing doc menus not to appear [`0521467`](https://github.com/fomantic/Fomantic-UI/commit/05214676cf621b85c27c8545667ec65be1347dbf)
- Fix build script for deploying repos to use correct url [`#1250`](https://github.com/fomantic/Fomantic-UI/issues/1250)  [`3280b21`](https://github.com/fomantic/Fomantic-UI/commit/3280b21891745ae3fd297530d031b50f1feca6f8)
- Fix build scripts to work again [`d3e7455`](https://github.com/fomantic/Fomantic-UI/commit/d3e745524c554580675291051019afc921fd2881)
- Fix build-docs task not requiring component name in filename [`#6226`](https://github.com/fomantic/Fomantic-UI/issues/6226)  [`295af5f`](https://github.com/fomantic/Fomantic-UI/commit/295af5f328c5072e779d6ad4a0caec24509d4294)
- Fix bullet sizing to match chrome native bullets, fix grid responsive style overrides, fix checkbox utf char reference, fix flags [`343af40`](https://github.com/fomantic/Fomantic-UI/commit/343af40625cd7b6cfcac0d3e7d8eef21353c9f64)
- Fix burma flag not having right sprite location [`a7f0df9`](https://github.com/fomantic/Fomantic-UI/commit/a7f0df91c98a7c6f58587dcb4ac6f051a91dddaa)
- Fix button docs header [`22653d7`](https://github.com/fomantic/Fomantic-UI/commit/22653d75dbe681f5489463bf1deaf0ddb326e369)
- Fix button loading style demo [`ab0aab4`](https://github.com/fomantic/Fomantic-UI/commit/ab0aab400709c4d2ed0bf93e678415678f0a0ffd)
- Fix buttons in action input, still 1px offset with buttons.. [`f347a66`](https://github.com/fomantic/Fomantic-UI/commit/f347a667a7751a67c2606bce28a79347c8332a84)
- Fix buttons in cards [`c1ce7f2`](https://github.com/fomantic/Fomantic-UI/commit/c1ce7f2c5ae9c94e4f34590bf8d727e26ffc4393)
- Fix callback names for start, complete in transition [`33b08e0`](https://github.com/fomantic/Fomantic-UI/commit/33b08e028da47a4b09cf59baa3c9a7e641e7cb00)
- Fix camelcase on var in modal [`15dc0bd`](https://github.com/fomantic/Fomantic-UI/commit/15dc0bdac64dd281f06b3c5a138ee50e39892f97)
- Fix card header [`7cd229f`](https://github.com/fomantic/Fomantic-UI/commit/7cd229f4f6fabe7bb688dc3949a384e780789626)
- Fix casing of scrollbarwidth [`9839741`](https://github.com/fomantic/Fomantic-UI/commit/9839741220cb03a8a57e0869c8d890ee7916647f)
- Fix cause of [`#1471`](https://github.com/fomantic/Fomantic-UI/issues/1471)  [`8e3a750`](https://github.com/fomantic/Fomantic-UI/commit/8e3a7503409226b9f1864db599e5ecb3845392a2)
- Fix celled grid container sizing [`b465f28`](https://github.com/fomantic/Fomantic-UI/commit/b465f285093fccc2daa157e4e5a52757ed801fbd)
- Fix celled grid width [`3a00b94`](https://github.com/fomantic/Fomantic-UI/commit/3a00b9409b4420f6ab76eb13018e5a2452aec054)
- Fix celled/divided ordered lists [`dabed3d`](https://github.com/fomantic/Fomantic-UI/commit/dabed3d61d373ff5b97d867a142e934010ea76a0)
- Fix cenered inline loader [`0b8d71a`](https://github.com/fomantic/Fomantic-UI/commit/0b8d71aeae37dd7e3927bac2220fd6643b162691)
- Fix change in video to work correctly [`8a1027d`](https://github.com/fomantic/Fomantic-UI/commit/8a1027d63a9534e0df4f5cac19c3497e307fd34b)
- Fix check install [`cce98f7`](https://github.com/fomantic/Fomantic-UI/commit/cce98f7b94ce12e8b3bb8ace61040298add34b2c)
- Fix checkbox needs slower transition [`6213cbb`](https://github.com/fomantic/Fomantic-UI/commit/6213cbb5dbfccc05d322508a356bcac7f0769db3)
- Fix chinese language code [`0fcc666`](https://github.com/fomantic/Fomantic-UI/commit/0fcc666fedcd1347ee3057d179988abe27b84f2f)
- Fix circular icon centering [`1764809`](https://github.com/fomantic/Fomantic-UI/commit/1764809062a3b067570c96b50634a4bdcbf69f3c)
- Fix cleanup questions for NPM [`ee159a2`](https://github.com/fomantic/Fomantic-UI/commit/ee159a2b4f5d620a3f6f8ac4059b52448cca110e)
- Fix code example copy and paste, add more kitchen sink examples [`4754fa9`](https://github.com/fomantic/Fomantic-UI/commit/4754fa97749e4eb9ff92c3cb884c904ccd61992b)
- Fix collapsed comment state [`927b5c1`](https://github.com/fomantic/Fomantic-UI/commit/927b5c1db1cd1a99099b8a04a019cc5436cda56d)
- Fix color tween loading issue with dropdowns [`9037829`](https://github.com/fomantic/Fomantic-UI/commit/90378294a2f4cd02f51e8e14eb6f3327f030f1ec)
- Fix colored checkbox bullet [`cdbc7b3`](https://github.com/fomantic/Fomantic-UI/commit/cdbc7b3447bc432db70be5fc9f6cd25b2881fd83)
- Fix colored theme transition [`d4ddfd4`](https://github.com/fomantic/Fomantic-UI/commit/d4ddfd4a57783be922d0b4f9ad8f390c35411921)
- Fix column row inside stackable grid [`0b78bd0`](https://github.com/fomantic/Fomantic-UI/commit/0b78bd028250423ecedf9b07f9ee160fe20c7465)
- Fix combo action [`af129c5`](https://github.com/fomantic/Fomantic-UI/commit/af129c52c9f3ca38d833d68749b8dcc8a5004744)
- Fix comitted merge conflict [`9445939`](https://github.com/fomantic/Fomantic-UI/commit/94459392416335a4e64e580b6de0f8da734b6787)
- Fix comments [`#4125`](https://github.com/fomantic/Fomantic-UI/issues/4125)  [`d38e863`](https://github.com/fomantic/Fomantic-UI/commit/d38e863afe5f35dfede31ec40b0e9c4ac5b7fb70)
- Fix condition where progress could continue firing interval indefinitely if removed from DOM [`ef5913b`](https://github.com/fomantic/Fomantic-UI/commit/ef5913ba1d4699584616eb3d94f529cc312403d8)
- Fix config comment replace regex not to be greedy [`5a1e347`](https://github.com/fomantic/Fomantic-UI/commit/5a1e347ed5471de7ce7b1583ccc277d1beec367c)
- Fix config load [`a11f709`](https://github.com/fomantic/Fomantic-UI/commit/a11f709391fe52748889f2929ad79cf50126a5e3)
- Fix config path [`8c27ff5`](https://github.com/fomantic/Fomantic-UI/commit/8c27ff5c0557de0ca87a095c447d03da835e5914)
- Fix confusing word order in button [`f9739f3`](https://github.com/fomantic/Fomantic-UI/commit/f9739f32f41a31b07b3bd02338af38f426ff7a9f)
- Fix consecutive grid spacing [`#2467`](https://github.com/fomantic/Fomantic-UI/issues/2467)  [`549f040`](https://github.com/fomantic/Fomantic-UI/commit/549f04009e7afed140a74e9a43724b09fbb21c2a)
- Fix container size method not called due to improper renaming to length [`5c4f79b`](https://github.com/fomantic/Fomantic-UI/commit/5c4f79b3c264f48d038ce3017c13a30aa064c814)
- Fix container width, should be auto unless flex (menu is flex) [`#2343`](https://github.com/fomantic/Fomantic-UI/issues/2343)  [`5b6e427`](https://github.com/fomantic/Fomantic-UI/commit/5b6e42717ddb804b96256123348c9e5322b8de56)
- Fix context for beforeSend [`a4ef6c1`](https://github.com/fomantic/Fomantic-UI/commit/a4ef6c1041f32941a6e110175a100438a2f6c88a)
- Fix contributor messages, fix icon spacing bug [`d86e66e`](https://github.com/fomantic/Fomantic-UI/commit/d86e66ec3c0e8d19b99d51e6a8ab8f0fb160e398)
- Fix corner label mouse selection [`9588488`](https://github.com/fomantic/Fomantic-UI/commit/958848847cd39e1efc8e69bcd06db067d3e277d5)
- Fix corner label size [`e0fbc0f`](https://github.com/fomantic/Fomantic-UI/commit/e0fbc0fa87e23fdb33725a5f78d8a4e9c45322c6)
- Fix corner labeled icon zindex issues [`98d55d0`](https://github.com/fomantic/Fomantic-UI/commit/98d55d0b9340c17f7a90ed5819ad9af2121b06ba)
- Fix critical typo breaking SUI [`65c3c94`](https://github.com/fomantic/Fomantic-UI/commit/65c3c94e74db539281f810c29ca019acaa928430)
- Fix cursor on search dropdown [`6962b7b`](https://github.com/fomantic/Fomantic-UI/commit/6962b7b859166e49995354e7f48ed3857a4e09c8)
- Fix date [`236f761`](https://github.com/fomantic/Fomantic-UI/commit/236f761cf69f52a7d4b71d86892d49e9101f8170)
- Fix debug  [`#2059`](https://github.com/fomantic/Fomantic-UI/issues/2059) [`#2070`](https://github.com/fomantic/Fomantic-UI/issues/2070)  [`618e783`](https://github.com/fomantic/Fomantic-UI/commit/618e7839a1478ea312b3966722dcfb92ba526fdf)
- Fix debug comment [`#1552`](https://github.com/fomantic/Fomantic-UI/issues/1552)  [`b6732c0`](https://github.com/fomantic/Fomantic-UI/commit/b6732c07fa787aed9f07b8b91ea57afc496091da)
- Fix debug msg position [`#3879`](https://github.com/fomantic/Fomantic-UI/issues/3879)  [`ad9ccbf`](https://github.com/fomantic/Fomantic-UI/commit/ad9ccbfe8cafa851d3354035ceb0cf8d56e0a2b6)
- Fix debug statements in shape [`638b42b`](https://github.com/fomantic/Fomantic-UI/commit/638b42b5510bf39fbe356770afef51898f40065c)
- Fix default blacks to be more consistent [`08cdd9e`](https://github.com/fomantic/Fomantic-UI/commit/08cdd9ef9d0cf59043b56e289f4c3e475066b77b)
- Fix default focused text rule to work with sizer [`#5633`](https://github.com/fomantic/Fomantic-UI/issues/5633)  [`f08a787`](https://github.com/fomantic/Fomantic-UI/commit/f08a78785d4c0d1333f48b7c3ebbb4f117556432)
- Fix description spacing without meta on item [`29e0507`](https://github.com/fomantic/Fomantic-UI/commit/29e05073d9779b24ff192f3a344f72b16bd9e442)
- Fix destroy method to not possibly unbind scroll evenit from window [`7d8646e`](https://github.com/fomantic/Fomantic-UI/commit/7d8646eb90a95d71cdded513d9734a16ec50247f)
- Fix destroy never being called before init [`#3798`](https://github.com/fomantic/Fomantic-UI/issues/3798)  [`05652ab`](https://github.com/fomantic/Fomantic-UI/commit/05652ab7cdaf937ce5aaecdaabdf898ab4b78dff)
- Fix dimmer from blurring on webkit [`07f0faf`](https://github.com/fomantic/Fomantic-UI/commit/07f0faf1c780865e07485ac17e12040fa7202fc0)
- Fix dimmer init issue [`42435f6`](https://github.com/fomantic/Fomantic-UI/commit/42435f692522cfd1dab6f71678c76f695dec941f)
- Fix dimmer with setting closable:false still closable [`e461c66`](https://github.com/fomantic/Fomantic-UI/commit/e461c66ec9a1d3bdcbc81450a39b786c93f0213a)
- Fix disabled checkbox override, wrap on search [`aea6ae8`](https://github.com/fomantic/Fomantic-UI/commit/aea6ae8393fe34845d5f16aa781f2c793fc92f6b)
- Fix disabled step bg [`5306800`](https://github.com/fomantic/Fomantic-UI/commit/5306800ef66a30b76d1e79d3db3310ca633a1c0e)
- Fix display: flex issues when content has no image [`57e5cba`](https://github.com/fomantic/Fomantic-UI/commit/57e5cba3a028f1bf0cec15a3d03bf5819ec2c89c)
- Fix dist versions to remove merge conflicts, fix immediate build on config [`d2dd222`](https://github.com/fomantic/Fomantic-UI/commit/d2dd2228286d0f8c461ea869cbc1aa9957aef91a)
- Fix divider colors on grid [`19e98a6`](https://github.com/fomantic/Fomantic-UI/commit/19e98a62465c5689009041728d02c10e8e2d4e17)
- Fix divider in grid with flexbox [`ef10f3e`](https://github.com/fomantic/Fomantic-UI/commit/ef10f3e69d24f722cbcfc86e119cdfb1263a892a)
- Fix divider on vertical basic button group [`#1677`](https://github.com/fomantic/Fomantic-UI/issues/1677)  [`99a3ba2`](https://github.com/fomantic/Fomantic-UI/commit/99a3ba222a8a34a2f1d21b86b79df8d62874b80c)
- Fix dividing rail variables [`21fd039`](https://github.com/fomantic/Fomantic-UI/commit/21fd03971d2bdeaf5b42d8d7b5f3b151214d5307)
- Fix dot-file dep, add postinstall [`e3d8766`](https://github.com/fomantic/Fomantic-UI/commit/e3d8766078b00f17ed28152905b8503c402fc5fb)
- Fix double hide issue in dropdown from force selection [`b2c4134`](https://github.com/fomantic/Fomantic-UI/commit/b2c41344867020671db41b5ec32d0b9e5c87dc17)
- Fix double margin on nested images [`#6224`](https://github.com/fomantic/Fomantic-UI/issues/6224)  [`b93737e`](https://github.com/fomantic/Fomantic-UI/commit/b93737e07189aa61b5326304d5e72448f6df2f16)
- Fix double negative variable in table [`ba52bec`](https://github.com/fomantic/Fomantic-UI/commit/ba52bec5dd1503da8cea32091c1bd659029e06d4)
- Fix double rtl extension, RTLCSS now occurs after prefix/less compilation in watch. [`#1552`](https://github.com/fomantic/Fomantic-UI/issues/1552)  [`56048bd`](https://github.com/fomantic/Fomantic-UI/commit/56048bd514b358ec824c05f172afa22796286c2b)
- Fix doubling grid overrides [`920b432`](https://github.com/fomantic/Fomantic-UI/commit/920b4327920be970a926d922c19f7bbdd7f30b27)
- Fix doubling stackable grid, text alignment on some elements [`f6b55de`](https://github.com/fomantic/Fomantic-UI/commit/f6b55debf696a704a8a54c6ad553b46eab6fc0b2)
- Fix dropdown direction: auto, to open downward when no space above or below. [`625c1a4`](https://github.com/fomantic/Fomantic-UI/commit/625c1a46b2f6e7477873f36256ed653a6f07215f)
- Fix dropdown examples [`9aa2a9b`](https://github.com/fomantic/Fomantic-UI/commit/9aa2a9bdc61d805d5df85d882e6facba4ed9c784)
- Fix dropdown focused but not hovered colors [`f85da30`](https://github.com/fomantic/Fomantic-UI/commit/f85da30ae7faf1548a7dc845b3b7a4778fac7c1a)
- Fix dropdown icon selection [`fd9d457`](https://github.com/fomantic/Fomantic-UI/commit/fd9d45749d2453350a4b120c79f3eeeec4335233)
- Fix dropdown icon size (slightly smaller), add variables [`5c79d13`](https://github.com/fomantic/Fomantic-UI/commit/5c79d13e78daa7b30eefa2eb94f00b86105ee9ac)
- Fix dropdown icon spacing, fix issues with selectOnKeydown when using text that includes html (like images) [`33ea63e`](https://github.com/fomantic/Fomantic-UI/commit/33ea63ec9139ffd3cc49ae492aeffd1666f8db63)
- Fix dropdown issues with min-width [`cfe3b2e`](https://github.com/fomantic/Fomantic-UI/commit/cfe3b2ec5645e0f89d9263e9c6da6f4b682fce72)
- Fix dropdown keyboard selection styles inside menu [`8680cad`](https://github.com/fomantic/Fomantic-UI/commit/8680cade64f0852d9aee2a66b5da2325a53a3f1b)
- Fix dropdown labels [`cef9e74`](https://github.com/fomantic/Fomantic-UI/commit/cef9e74d3c35497e0b60637d983d33161c923b94)
- Fix dropdown missing some namespaced events, fixes positive/negative/error on table to use site.variables, adds method to auto add tabindex in checkbox [`f1056cb`](https://github.com/fomantic/Fomantic-UI/commit/f1056cbfa0b9948539222a1d4b0c5676c3b37388)
- Fix dropdowns inside overflow containers [`619386e`](https://github.com/fomantic/Fomantic-UI/commit/619386ebbc714447e9c2ca4d50c7460ffcf98239)
- Fix dupe of module instanciation in checkbox [`cbf8d76`](https://github.com/fomantic/Fomantic-UI/commit/cbf8d76265df5987f60618d9ba0ae24900c7f573)
- Fix duped variables in theme.config.example [`5df2a39`](https://github.com/fomantic/Fomantic-UI/commit/5df2a392292ffe4e82d5aa6477eacfd59ae28437)
- Fix element structure [`6175d52`](https://github.com/fomantic/Fomantic-UI/commit/6175d523c19ac0da65554849832c484214160259)
- Fix enabled module list [`54ed25a`](https://github.com/fomantic/Fomantic-UI/commit/54ed25acd448d831e0996b14a6c82663700b8c9c)
- Fix equal width/height to now require row wrappers [`755d0bf`](https://github.com/fomantic/Fomantic-UI/commit/755d0bf2cd709fa32fc82d387a52ba300b4f12f0)
- Fix error in dropdown logic with hideAdditions, fix func call missing parens [`489588c`](https://github.com/fomantic/Fomantic-UI/commit/489588cfd59f3f0a9ba49ea6203a6e48cd80fb2c)
- Fix error which could cause popup to use wrong offset context when specifying popup manually [`8df7f2f`](https://github.com/fomantic/Fomantic-UI/commit/8df7f2f2c75cbdf68cc5134dd2357895c66fdd5c)
- Fix error with get xhr not returning promise, add abort method [`42cbd74`](https://github.com/fomantic/Fomantic-UI/commit/42cbd74d0233b70da4726f944c2ec3cf6a0fc95f)
- Fix errored dropdown styles inside forms [`1d5b258`](https://github.com/fomantic/Fomantic-UI/commit/1d5b25821b56959f3ed102e78a481c7aebfdd7de)
- Fix errored input border radius [`a39cf66`](https://github.com/fomantic/Fomantic-UI/commit/a39cf66afe8da22a262522c019ace80569abeca0)
- Fix errors in math from [`#2168`](https://github.com/fomantic/Fomantic-UI/issues/2168)  [`442839c`](https://github.com/fomantic/Fomantic-UI/commit/442839c3527ed3b28b6f96d971336e6bc684d27a)
- Fix escape key not working to close search [`738b9fa`](https://github.com/fomantic/Fomantic-UI/commit/738b9faa16a32bfc4bc9d0330f92becd3736e9b6)
- Fix eventNamespace in [`#3396`](https://github.com/fomantic/Fomantic-UI/issues/3396)  [`3827fd0`](https://github.com/fomantic/Fomantic-UI/commit/3827fd0a82ec4303874faf16439ffaa3a806540b)
- Fix example title [`152da4d`](https://github.com/fomantic/Fomantic-UI/commit/152da4d0190d5e961ab4800915b447cdec59054a)
- Fix exit conditions for search object [`3ed7ff7`](https://github.com/fomantic/Fomantic-UI/commit/3ed7ff7ba5fd51de8bd14294a2f4a59f2183dba5)
- Fix extension on oauth example js file [`97e3103`](https://github.com/fomantic/Fomantic-UI/commit/97e310364b456ff4750ebda743c87194ce0309c7)
- Fix feed divider [`590701f`](https://github.com/fomantic/Fomantic-UI/commit/590701febe0c634cc4776d3cf5ee8253b3a99efc)
- Fix feed example [`9fc83fe`](https://github.com/fomantic/Fomantic-UI/commit/9fc83fe758d0490ffd2f1a30752a255a06d0c854)
- Fix feed font sizes [`32b007e`](https://github.com/fomantic/Fomantic-UI/commit/32b007ecdf1c6dc11a33739fd4f79583af405303)
- Fix feed margin [`6cfd443`](https://github.com/fomantic/Fomantic-UI/commit/6cfd44359ce463892e38fe4c91b8e0e497267e1a)
- Fix fg-color on inverted forms in Flat theme. [`4a459b2`](https://github.com/fomantic/Fomantic-UI/commit/4a459b2e25a6dff12f98887c01e2984c37f5fd55)
- Fix fixed menu stuttering issue [`b30a87f`](https://github.com/fomantic/Fomantic-UI/commit/b30a87f35a155e3ebb09c15ff245aa6009c41681)
- Fix flag collision with ui flag, fix attached label borders [`5d7459b`](https://github.com/fomantic/Fomantic-UI/commit/5d7459b5e5df2516494a062425cf015c28155a5f)
- Fix flash of double scrollbar on modal [`#787`](https://github.com/fomantic/Fomantic-UI/issues/787)  [`644e2c6`](https://github.com/fomantic/Fomantic-UI/commit/644e2c69b137fa76848bff80552133f43254c720)
- Fix flat dropdown style [`d4dc873`](https://github.com/fomantic/Fomantic-UI/commit/d4dc873241d6a16f0a60292a1a794e636e609bdb)
- Fix flex fluid width [`6ceb7fd`](https://github.com/fomantic/Fomantic-UI/commit/6ceb7fd0b8c59fa1df8772932c23db95e9beb02f)
- Fix floated statistic styles [`60f2235`](https://github.com/fomantic/Fomantic-UI/commit/60f2235ac4cf19e9752f24696954d7ee1fd92618)
- Fix fluid flex, rounding of padding [`7d402ff`](https://github.com/fomantic/Fomantic-UI/commit/7d402ff4e8073019dcc7148ca4361ec5b78809c5)
- Fix fluid text menu [`281d3a4`](https://github.com/fomantic/Fomantic-UI/commit/281d3a4de25d9205089c9441b68dcb93b2293b7f)
- Fix focus color on basic button [`#2264`](https://github.com/fomantic/Fomantic-UI/issues/2264)  [`8cfcf56`](https://github.com/fomantic/Fomantic-UI/commit/8cfcf568e1d0ca58a82ac833a438a17f593d3c39)
- Fix focus styles not applying to selected checkbox [`6bb04f6`](https://github.com/fomantic/Fomantic-UI/commit/6bb04f6b1167f65b3145ba918819c4205e41c6fb)
- Fix following menu spacing [`38f8ac5`](https://github.com/fomantic/Fomantic-UI/commit/38f8ac597e477471cabb279095d530341846113e)
- Fix font family rule on :before [`2984026`](https://github.com/fomantic/Fomantic-UI/commit/2984026ec78da0ada86ed17a80358c36fd13368d)
- Fix for API time logging [`20357f4`](https://github.com/fomantic/Fomantic-UI/commit/20357f43e6e80890fa026fa8a2d56748f5ba8f3c)
- Fix for [`#1299`](https://github.com/fomantic/Fomantic-UI/issues/1299)  [`e6fc690`](https://github.com/fomantic/Fomantic-UI/commit/e6fc690165ec3a02cab846c1d16e3b29170fc7d9)
- Fix for [`#16644`](https://github.com/fomantic/Fomantic-UI/issues/16644) - Safari iOS fix for canvas resizing affecting Chrome iOS display of fixed content [`fe7e04e`](https://github.com/fomantic/Fomantic-UI/commit/fe7e04e6ac7fa7962651d7a6a330c3fbe3be138d)
- Fix for [`#5713`](https://github.com/fomantic/Fomantic-UI/issues/5713)  [`afff7b2`](https://github.com/fomantic/Fomantic-UI/commit/afff7b2535b497132acdd5150f8c2327b8d2ca6e)
- Fix for backface visibility on shapes [`9de8f8f`](https://github.com/fomantic/Fomantic-UI/commit/9de8f8f62bc379cf3a34b3a65366ccf1ce408102)
- Fix for clickaway unbinding if clicked during animation [`a791177`](https://github.com/fomantic/Fomantic-UI/commit/a79117742426c4204d8fb0a155470626fc1b01d1)
- Fix for dropdown destroy [`37f7dc9`](https://github.com/fomantic/Fomantic-UI/commit/37f7dc9bb9fd1adbdf907a66670a424541730dcd)
- Fix for filtered item override [`027ab45`](https://github.com/fomantic/Fomantic-UI/commit/027ab45c724f6763b854fc497f076fd299f4175b)
- Fix for header [`f224c08`](https://github.com/fomantic/Fomantic-UI/commit/f224c0812020ac9095efea7903cf5e6bb127c624)
- Fix for multiple labels [`6f70bd9`](https://github.com/fomantic/Fomantic-UI/commit/6f70bd9dc718d6cd8121e7a6d69f51acf0d7cd71)
- Fix for multiple labels again [`6fc8fb6`](https://github.com/fomantic/Fomantic-UI/commit/6fc8fb6b4f9bc63674b02fac4cbb18f2e211ecb1)
- Fix for non stackable grid at mobile width [`9e8975d`](https://github.com/fomantic/Fomantic-UI/commit/9e8975d797ba92382c10891b262c2100a7b482cb)
- Fix for object shadowing? [`eb223c6`](https://github.com/fomantic/Fomantic-UI/commit/eb223c6fad2de00dcdcd69184aa64747d6a47d07)
- Fix for sub menu zindex, fix for hiding sub menus when menu is hidden if no active item inside, fix for rapid alt tabbing keeps menu open, fix for hiding during show [`3b791db`](https://github.com/fomantic/Fomantic-UI/commit/3b791db69a23da39b64e5fc6bccb5064642a6624)
- Fix for transition class [`a147814`](https://github.com/fomantic/Fomantic-UI/commit/a1478149dc9f15bbf7f0ebff9c943dc1fe7c4ff5)
- Fix form validation name [`3d6985f`](https://github.com/fomantic/Fomantic-UI/commit/3d6985fedb80f51023705383f9ac5d512f1468dd)
- Fix formatting [`af8c4a5`](https://github.com/fomantic/Fomantic-UI/commit/af8c4a54549d4301fc51959c585881477313e3a4)
- Fix formatting with (x) column table segment [`80f1bd4`](https://github.com/fomantic/Fomantic-UI/commit/80f1bd450c50c889b690454b623d2eba4f0e6807)
- Fix fullscreen modal left margins [`17cfe99`](https://github.com/fomantic/Fomantic-UI/commit/17cfe99eed3a1d6adfbda90ff9a87c85ec6d80e7)
- Fix github message theme border colors, fix tabular segment spacing [`91939aa`](https://github.com/fomantic/Fomantic-UI/commit/91939aa4bc709c6b366ae8983b7b9416027f5120)
- Fix glob matching patterns for concat css [`ab393b3`](https://github.com/fomantic/Fomantic-UI/commit/ab393b3b825835bdca5fc0c82a011b92962be94d)
- Fix greyscale saturation turning red (caused by absolute saturate call) [`601aad9`](https://github.com/fomantic/Fomantic-UI/commit/601aad9c124a50dc8fcf1791271639330275bb74)
- Fix grid example [`0173292`](https://github.com/fomantic/Fomantic-UI/commit/0173292ce4fc6083333ea67f474a8b7cf08dec6b)
- Fix grid inside vertical segment [`782b61b`](https://github.com/fomantic/Fomantic-UI/commit/782b61b00771159ae8c3da2b962bda5880c8abcd)
- Fix grouped button aligment, icon message alignment [`7aa345d`](https://github.com/fomantic/Fomantic-UI/commit/7aa345dec7f3342d2c64f133f482b4e82a1ac6a2)
- Fix grouped field label [`d3775b4`](https://github.com/fomantic/Fomantic-UI/commit/d3775b4c95affa9992939602453c30d9962f4579)
- Fix gruntfile comments [`415f658`](https://github.com/fomantic/Fomantic-UI/commit/415f6581adacb55fc3f1fa149713d978b7317221)
- Fix gulp docs glob [`b2994d5`](https://github.com/fomantic/Fomantic-UI/commit/b2994d58d0a1e0d38dab0802fbea74fa57f7398f)
- Fix gulp install to add new files inside directories (was avoiding overwritin dir) [`53265f7`](https://github.com/fomantic/Fomantic-UI/commit/53265f76728b903f55be999b8a52c9704e68cfc5)
- Fix gulp issues [`c132434`](https://github.com/fomantic/Fomantic-UI/commit/c13243425d0c16dac06e3655081aca7244bf5903)
- Fix gulp mistake [`02ac6f7`](https://github.com/fomantic/Fomantic-UI/commit/02ac6f7e24e4b2d03df2cae0fadbc0f70b998824)
- Fix gulp watch not erroring out with legitimate errors [`8102cff`](https://github.com/fomantic/Fomantic-UI/commit/8102cff1846d695669e8d755aca7b9c384888fd8)
- Fix header border color to be internal [`46ea660`](https://github.com/fomantic/Fomantic-UI/commit/46ea66052c34eb855e24691c2aa0228a6b4ab776)
- Fix header font inheritance again. [`c3bc2c4`](https://github.com/fomantic/Fomantic-UI/commit/c3bc2c4c6c50314bc66df2697851555d49066d19)
- Fix header inheritance in modal [`6d48688`](https://github.com/fomantic/Fomantic-UI/commit/6d486888a6961ee7fd38261758df2ab038c61e6c)
- Fix header size again [`e4f4b2c`](https://github.com/fomantic/Fomantic-UI/commit/e4f4b2c19e1b9521156748913bbcf2c85db75584)
- Fix header sizes in chubby header theme [`3d3f058`](https://github.com/fomantic/Fomantic-UI/commit/3d3f0581754060dc4f4a63588e0db1c08594ee6f)
- Fix header using wrong @medium value [`1568c53`](https://github.com/fomantic/Fomantic-UI/commit/1568c5329d0a4a11d0e3c37095b76c4ff42ff576)
- Fix height of slider [`63530b2`](https://github.com/fomantic/Fomantic-UI/commit/63530b2e2266d650edf2605cb7d3569c50b0722b)
- Fix hide delay being less than show delay causing elements not to hide [`a0ea788`](https://github.com/fomantic/Fomantic-UI/commit/a0ea788f167c516536e72825ba66003797313109)
- Fix homepage animation [`5abd650`](https://github.com/fomantic/Fomantic-UI/commit/5abd65033008ffd3522290f5d666d1992dc4a143)
- Fix homepage menu [`5c18db1`](https://github.com/fomantic/Fomantic-UI/commit/5c18db157242f7b168182e17edb3da425fc4b81d)
- Fix horizontal align with image/icon in list [`faa17ec`](https://github.com/fomantic/Fomantic-UI/commit/faa17ec883c2dc4e78c7926aaee4f70bbc4188c8)
- Fix horizontal icon alignment with statistic [`e4e8aa5`](https://github.com/fomantic/Fomantic-UI/commit/e4e8aa5d1141370fdacc6b6a3aebd61c79d84b53)
- Fix horizontal segments inside grids [`05f4544`](https://github.com/fomantic/Fomantic-UI/commit/05f454447a562124a89052a0172198465b53413c)
- Fix hover color on pointing menu [`#2263`](https://github.com/fomantic/Fomantic-UI/issues/2263)  [`3022fa0`](https://github.com/fomantic/Fomantic-UI/commit/3022fa0ca9c2616cc627900c8d4f3442ba9656f3)
- Fix hoverable on inline content [`e085804`](https://github.com/fomantic/Fomantic-UI/commit/e08580498d03935758e95bac29ac84fa6bf071b2)
- Fix hybrid &lt;select&gt; init [`223bd3b`](https://github.com/fomantic/Fomantic-UI/commit/223bd3b0fdcbc35d045df2206c818596e83e1925)
- Fix icon alignment in timeline feed view [`9c36f83`](https://github.com/fomantic/Fomantic-UI/commit/9c36f833166dcaa6b7e509395626dd4c97f84938)
- Fix icon banner in icons, add visiblity to single component releases [`c7a1b47`](https://github.com/fomantic/Fomantic-UI/commit/c7a1b475996f69695b4346a1f72c8acdfd2e7dd1)
- Fix icon button centering [`4a4fc9b`](https://github.com/fomantic/Fomantic-UI/commit/4a4fc9b2a0f43a3dcbe2a4d7f6b7354342df99c4)
- Fix icon header content padding in some cases [`ae2373f`](https://github.com/fomantic/Fomantic-UI/commit/ae2373feab78e5c1cf4a09f50919cb43d6f74119)
- Fix icon header spacing [`919e893`](https://github.com/fomantic/Fomantic-UI/commit/919e89315d1fe23a7c58b7ac52616e928f90a405)
- Fix icon inside label inside a.item wrongly colored [`c0bdf53`](https://github.com/fomantic/Fomantic-UI/commit/c0bdf5300a980ff5db862d6fc1f1b38e76eca904)
- Fix icon item not centering if narrow icon in menu [`c1ace94`](https://github.com/fomantic/Fomantic-UI/commit/c1ace94d43077c8d600a01e6ae96f0b8b7552553)
- Fix icon line height in header/modal [`542e727`](https://github.com/fomantic/Fomantic-UI/commit/542e7273863740d289c90703a5492cc294c4917b)
- Fix icon menu appearing fluid [`13bea8f`](https://github.com/fomantic/Fomantic-UI/commit/13bea8fbda339158ee235bdbd0569ac51a63bb08)
- Fix icon message sizing [`a847e9c`](https://github.com/fomantic/Fomantic-UI/commit/a847e9c3bac88ba0dc011a0994b1d4247c912f10)
- Fix image label format [`1fd1b40`](https://github.com/fomantic/Fomantic-UI/commit/1fd1b404a09cc203c9c9f74f3c018e1e26d1f612)
- Fix image visibility to only occur when on screen [`c72f790`](https://github.com/fomantic/Fomantic-UI/commit/c72f790bb4dc8c58f26cee02b0b87592a62c938c)
- Fix image width on ui image in vertical menu [`0257c76`](https://github.com/fomantic/Fomantic-UI/commit/0257c764b39e35a670aa4f344b317485c8ab5d16)
- Fix img inside label [`93ca4b9`](https://github.com/fomantic/Fomantic-UI/commit/93ca4b9b88827144f0a654c0ee9107b304c65ed3)
- Fix in menu searchable from clearing text [`fd158c6`](https://github.com/fomantic/Fomantic-UI/commit/fd158c6c780edb9211638994f10bc2ceca3755d0)
- Fix incorrect css property, attached label segment coupling [`44ed053`](https://github.com/fomantic/Fomantic-UI/commit/44ed0534b8e84d49b60ed206fb8c4a43b0865f07)
- Fix incorrect margin on attached segment [`#2503`](https://github.com/fomantic/Fomantic-UI/issues/2503)  [`bd166b8`](https://github.com/fomantic/Fomantic-UI/commit/bd166b8fed927edf584ba5fa9a658162dcf00d8e)
- Fix increase/decrease example in header [`3babd67`](https://github.com/fomantic/Fomantic-UI/commit/3babd676044531673a99ca613df62febf4596eb6)
- Fix inheritance issue with segments [`#4013`](https://github.com/fomantic/Fomantic-UI/issues/4013)  [`f8e295f`](https://github.com/fomantic/Fomantic-UI/commit/f8e295fcffa77504896ffecf8fee0a82f56347c6)
- Fix inheritance of fonts in doc [`aa10511`](https://github.com/fomantic/Fomantic-UI/commit/aa1051137709a3a6e3db5875e9a2fe073b9e3dd9)
- Fix init issue when  is undefined [`#1272`](https://github.com/fomantic/Fomantic-UI/issues/1272)  [`6af1ba5`](https://github.com/fomantic/Fomantic-UI/commit/6af1ba5ffa9b9d3deb2fe72af99cbefcb66a9949)
- Fix inline dropdown alignment [`b1d8d03`](https://github.com/fomantic/Fomantic-UI/commit/b1d8d03ba933f0ab86572db44b010dfe9936c1e7)
- Fix inline form validation prompt styles [`8b19b0d`](https://github.com/fomantic/Fomantic-UI/commit/8b19b0d8f8fdb84ecabc0eae8ba7b3af2b316a60)
- Fix input in dropdown [`3f1d08a`](https://github.com/fomantic/Fomantic-UI/commit/3f1d08a92f72a3b37619ea5c5c681fb6e94aa673)
- Fix input size overflow [`0ecfd8a`](https://github.com/fomantic/Fomantic-UI/commit/0ecfd8adba61ea2e37623a3c965a063bdf4f0a12)
- Fix input spacing rule on dropdown, add colored box shadows, add border colors to message [`22fc884`](https://github.com/fomantic/Fomantic-UI/commit/22fc88442ef2637b6016250bec1cd8dfbcf191b6)
- Fix input to work with basic label, fix basic label hover, add left labeled button [`c2cfd76`](https://github.com/fomantic/Fomantic-UI/commit/c2cfd765f4e4d4d7cf5a28f41713e3072033f45b)
- Fix integer validation [`19ec0c8`](https://github.com/fomantic/Fomantic-UI/commit/19ec0c82a1b0360e92662902ce85443d6a7b78ed)
- Fix internal borders, remove border from fixed [`c248ccb`](https://github.com/fomantic/Fomantic-UI/commit/c248ccbe44b0cf83226c2d296da3100900109b26)
- Fix internally celled margin [`32940b2`](https://github.com/fomantic/Fomantic-UI/commit/32940b279ab1cd13bc37b5a86b40883e5f28b4b1)
- Fix interrupted animatinos [`91b72fe`](https://github.com/fomantic/Fomantic-UI/commit/91b72fe20bdbfd489cbe6f54be7f8ffd885c88c8)
- Fix inverted bordered icons [`b133398`](https://github.com/fomantic/Fomantic-UI/commit/b13339845c83e145fca342d35e0369a9a824cab8)
- Fix inverted button hover state, fix animated buttons not obeying changes in padding variable, fix button docs [`09e4b7c`](https://github.com/fomantic/Fomantic-UI/commit/09e4b7c5ff9d5291b897e75896e21da37a0db0f9)
- Fix inverted popup box shadow issue [`90e0553`](https://github.com/fomantic/Fomantic-UI/commit/90e05532a529673e00ec1028f0de6dce82d41da4)
- Fix inverted popup headers, working through bugs with multiple popups [`5631dc5`](https://github.com/fomantic/Fomantic-UI/commit/5631dc585fa030b88da953ffca7390736c054b46)
- Fix inverted scrollbars in inverted ui [`a528f20`](https://github.com/fomantic/Fomantic-UI/commit/a528f207387c4390e84326f9da1d2ddc301786a3)
- Fix inverted segments, block/attached header adjustments, fixes for responsive table headers [`0597663`](https://github.com/fomantic/Fomantic-UI/commit/059766396985e6fd230d84712e822eb49f7f55e8)
- Fix inverted text menu, fix active font weight [`3e19a5a`](https://github.com/fomantic/Fomantic-UI/commit/3e19a5ad0745d80a8d6391ac73d970fd2b3cb6ba)
- Fix isssues when using messages instead of labels, with max selection and display count [`4c1d7d0`](https://github.com/fomantic/Fomantic-UI/commit/4c1d7d0456f1187440a81f05fd02ca4cb5127b99)
- Fix issue [`#1569`](https://github.com/fomantic/Fomantic-UI/issues/1569) [`#1564`](https://github.com/fomantic/Fomantic-UI/issues/1564) #1560 - Popup issues in 1.5.x [`625ef8f`](https://github.com/fomantic/Fomantic-UI/commit/625ef8ffc06ba7b21f083728930e0a8d8f1d44a7)
- Fix issue from fix earlier today with multi select selecting blank quote values [`a9c94a1`](https://github.com/fomantic/Fomantic-UI/commit/a9c94a197221debb6d2573a74f5c66e078c0a686)
- Fix issue in chaining when dropdown inits on select [`1550b49`](https://github.com/fomantic/Fomantic-UI/commit/1550b4937e67edf2f1c5deb67adf52b819a03b2b)
- Fix issue in implementation of closable on dimmer, fix issue with not namespacing dimmer in modal [`fa08398`](https://github.com/fomantic/Fomantic-UI/commit/fa08398aad20f7764aa99afdea1e123a178b80a9)
- Fix issue in scrolling menu width in some cases [`6dedf83`](https://github.com/fomantic/Fomantic-UI/commit/6dedf83e8c6636ef46ce3ca40f52cd5cf97f512d)
- Fix issue where dropdown inside label wont open [`37ad56b`](https://github.com/fomantic/Fomantic-UI/commit/37ad56b62c71c4ce637a4a9fd6c1f28a11e330eb)
- Fix issue where dropdowns might animate outward two times on blur [`2c5cc6f`](https://github.com/fomantic/Fomantic-UI/commit/2c5cc6fc1c06130500db17cac948a6dd0c388d0c)
- Fix issue where multiple modal init order matters [`#5559`](https://github.com/fomantic/Fomantic-UI/issues/5559)  [`4ccf825`](https://github.com/fomantic/Fomantic-UI/commit/4ccf825e07c6fabe96b61dc5debb0cc7f068d8fb)
- Fix issue where refocusing search (to preserve position) could retrigger events [`2ebcc26`](https://github.com/fomantic/Fomantic-UI/commit/2ebcc2673444d371a3fa32e6ada1e0faf44d0236)
- Fix issue where selection dropdown would modify search selection on tab before query [`238ac3c`](https://github.com/fomantic/Fomantic-UI/commit/238ac3c8906330e0fcc1980fefeea0ae2dfb2bda)
- Fix issue where selection was borked for search inside menu [`4b6595d`](https://github.com/fomantic/Fomantic-UI/commit/4b6595dd9905df72befedf44b6cb920406f7ce29)
- Fix issue where userAdditions failed to recreate element when using single selection [`16a70cd`](https://github.com/fomantic/Fomantic-UI/commit/16a70cd597457c80a7aee1e1a22a08ca1c2337e8)
- Fix issue with  not being passed to offsetContext when using predefined popup [`6e6c92a`](https://github.com/fomantic/Fomantic-UI/commit/6e6c92a4790516d7797997561ce50769e2546f4b)
- Fix issue with 100% width on equal height row [`b756009`](https://github.com/fomantic/Fomantic-UI/commit/b756009ea578f0a5a2760f7da599b357b84f65fe)
- Fix issue with APIsettings not behaving correctly when restoring a value without session data, fixed some instances where empty message could appear with results when removing multiselect choice. Fixed forceSelection to work consistently with multiselect [`5a610c3`](https://github.com/fomantic/Fomantic-UI/commit/5a610c35f388af0000dcec488f47c901197dc93c)
- Fix issue with animated button [`319a534`](https://github.com/fomantic/Fomantic-UI/commit/319a53492573bb54cc970be2d1e429fdeeeca5c4)
- Fix issue with animations sometimes sticking due to restore conditions [`ec249ad`](https://github.com/fomantic/Fomantic-UI/commit/ec249ad00a56bf5a5a585ca12120dd9852b21029)
- Fix issue with bottom margin on stats [`18ecf15`](https://github.com/fomantic/Fomantic-UI/commit/18ecf158a355eaf8da8ff4844f0030aa72159d48)
- Fix issue with bottomPassed and topPassed [`3bbaf13`](https://github.com/fomantic/Fomantic-UI/commit/3bbaf137b575c660af12cc89d6b811a8ae15cb8c)
- Fix issue with checkbox src [`#1197`](https://github.com/fomantic/Fomantic-UI/issues/1197)  [`030aa39`](https://github.com/fomantic/Fomantic-UI/commit/030aa396075f13e86083d853d7e2c54e44d26e41)
- Fix issue with clickaway not closing sidebar on mobile [`eff5613`](https://github.com/fomantic/Fomantic-UI/commit/eff5613d263a300e3c404d012b99b6eafa7f3bc9)
- Fix issue with creating new repo when adding ui [`7799a80`](https://github.com/fomantic/Fomantic-UI/commit/7799a8085f930a14543b70860c09b9b9249d7706)
- Fix issue with credential caching in publish script due to https git urls [`3838710`](https://github.com/fomantic/Fomantic-UI/commit/383871090cda527df916e1751279b3de79b07480)
- Fix issue with css selector starting with number (invalid) [`#3311`](https://github.com/fomantic/Fomantic-UI/issues/3311)  [`479f4b2`](https://github.com/fomantic/Fomantic-UI/commit/479f4b21daff6b3b9d5e0854c51c269e7f10e54e)
- Fix issue with destroy in visibility [`b685c94`](https://github.com/fomantic/Fomantic-UI/commit/b685c948e0ae7f116ed059c2f87dfa3bb22e3a4b)
- Fix issue with divider descendors being cut off  [`#3585`](https://github.com/fomantic/Fomantic-UI/issues/3585)  [`45e4bd8`](https://github.com/fomantic/Fomantic-UI/commit/45e4bd84c1da0980899536cff34574352d6dda03)
- Fix issue with down arrow shortcut in dropdown [`7a5fb9e`](https://github.com/fomantic/Fomantic-UI/commit/7a5fb9e12a60c361cfa8c102ac24c2e7d68b6db7)
- Fix issue with dropdown menu not opening after select due to preserving focus, fix issue with one segment inside segments group [`fc8d3ef`](https://github.com/fomantic/Fomantic-UI/commit/fc8d3efdc6cf6b2a0ad48eea96ea34ab24d3297b)
- Fix issue with hideAdditions where enter key would not select value when typing rapidly [`77980c1`](https://github.com/fomantic/Fomantic-UI/commit/77980c1864abecd50ca2a64eba564c42c136f294)
- Fix issue with input form align [`#1161`](https://github.com/fomantic/Fomantic-UI/issues/1161)  [`f90ad00`](https://github.com/fomantic/Fomantic-UI/commit/f90ad00f99652f667393c095c0cfb2114a648a8c)
- Fix issue with install question requiring down arrow to select [`b6504ba`](https://github.com/fomantic/Fomantic-UI/commit/b6504ba1e02f7afd9c498227e55609943e28d7c1)
- Fix issue with layering [`35f7a14`](https://github.com/fomantic/Fomantic-UI/commit/35f7a14ca6e45208ac56e22132f20a33fe67971b)
- Fix issue with left/right floated [`d32ce3b`](https://github.com/fomantic/Fomantic-UI/commit/d32ce3b1a3b7fa55bbb959482e787ccea0ab4777)
- Fix issue with localization modal showing twice, update localization percentages. [`469666b`](https://github.com/fomantic/Fomantic-UI/commit/469666be07e356b4333c6b30e1c83f542a563617)
- Fix issue with modal double showing in chrome [`2324709`](https://github.com/fomantic/Fomantic-UI/commit/232470981e172a075d76251b04d9ea9ace1d8095)
- Fix issue with multiline checkbox [`7414407`](https://github.com/fomantic/Fomantic-UI/commit/7414407e4aeb27b8ae7f298ab630bd1aad576df2)
- Fix issue with next timer not being removed on complete [`a6c03f8`](https://github.com/fomantic/Fomantic-UI/commit/a6c03f8565ed115ffbc97264ee46c2fcc18d869d)
- Fix issue with not being able to press down to open dropdown with user additions [`7484df0`](https://github.com/fomantic/Fomantic-UI/commit/7484df0504c26d6b66960bfbb159e459d9badcb8)
- Fix issue with not pulling href from result [`#3409`](https://github.com/fomantic/Fomantic-UI/issues/3409)  [`6867f48`](https://github.com/fomantic/Fomantic-UI/commit/6867f48a06439d5bd0d1ad971854b1d9fe96ca29)
- Fix issue with overflow: scroll [`bcdc1f0`](https://github.com/fomantic/Fomantic-UI/commit/bcdc1f018cd88634bb022e2ffd54fe74848a6593)
- Fix issue with popup removal [`1ab7165`](https://github.com/fomantic/Fomantic-UI/commit/1ab71653ee5a606d6ae1d804b5b5eaecbd263de2)
- Fix issue with progress when current value exceeds total [`3328e08`](https://github.com/fomantic/Fomantic-UI/commit/3328e0837a6523e3f0ea794451100303c98469c6)
- Fix issue with refocusing menu [`ff7824f`](https://github.com/fomantic/Fomantic-UI/commit/ff7824f396a7f6fbc33f76c4816c420157dfbbec)
- Fix issue with responsive column widths [`d32505e`](https://github.com/fomantic/Fomantic-UI/commit/d32505e3b2fd8f505fee356144d4d99cbe3b0caa)
- Fix issue with scrolling modal and allowMultiple [`#2423`](https://github.com/fomantic/Fomantic-UI/issues/2423)  [`aa1d36b`](https://github.com/fomantic/Fomantic-UI/commit/aa1d36b232ef2cdf7f80f090f95e76d803bc4d07)
- Fix issue with search dropdown not working on menu click [`77e19fe`](https://github.com/fomantic/Fomantic-UI/commit/77e19fe64b89ff3de694294542b04bcba187b24c)
- Fix issue with search selection tabbing [`203a06c`](https://github.com/fomantic/Fomantic-UI/commit/203a06cdc129c099cf888266c3264bc8c4a6fe6f)
- Fix issue with selection refocus changes causing menu not to open with down arrow key [`c43d464`](https://github.com/fomantic/Fomantic-UI/commit/c43d464a82902fda70f9f32c5873a7f0f6e65882)
- Fix issue with stackable menu not dividing items correctly [`8ca2d00`](https://github.com/fomantic/Fomantic-UI/commit/8ca2d00a1677f417679c01eedb39d32becb6a300)
- Fix issue with using let [`4f4b6c1`](https://github.com/fomantic/Fomantic-UI/commit/4f4b6c1d5545a113a1901d857804e9fdd94c8c28)
- Fix issue with visiblity events refiring when once is true [`b8fe9d6`](https://github.com/fomantic/Fomantic-UI/commit/b8fe9d63dbb890fc5a4c03e1c968d03471601b78)
- Fix issue with whitespace wrapping in reveal [`4231bb2`](https://github.com/fomantic/Fomantic-UI/commit/4231bb269f1f6000ca027b3c845fcbdddb5a1ad1)
- Fix issues with ajax tabs not obeying cache [`#2493`](https://github.com/fomantic/Fomantic-UI/issues/2493)  [`7a53664`](https://github.com/fomantic/Fomantic-UI/commit/7a5366423c9be107e18cd05923db6f4f916434bb)
- Fix issues with attached tabular with changes to segment [`cdcb13d`](https://github.com/fomantic/Fomantic-UI/commit/cdcb13d423aa2cda689eba2f0e036d8b8565c79c)
- Fix issues with fonts on button theming, add bootstrap3 button theme [`0dc157f`](https://github.com/fomantic/Fomantic-UI/commit/0dc157f079fcc7e20f2b804b015b04ff6d1f6115)
- Fix issues with inverted secondary/tertiary segment, adjust lightness of inverted [`#2306`](https://github.com/fomantic/Fomantic-UI/issues/2306)  [`8f6a15a`](https://github.com/fomantic/Fomantic-UI/commit/8f6a15a323ce121df7a0d1ccec82648ab587de00)
- Fix issues with mocking caused by get templated url rewrite [`167faba`](https://github.com/fomantic/Fomantic-UI/commit/167fabad187081ec4b618ebb632a817a51ef6fd1)
- Fix issues with refocus causing animation on tab blur [`c18c3db`](https://github.com/fomantic/Fomantic-UI/commit/c18c3db936c1667fb7784d8f3c725db1aa124052)
- Fix issues with safari not automatically sizing icons when given height 0, fixes inputs in menu [`96e1727`](https://github.com/fomantic/Fomantic-UI/commit/96e17273f9efd98161a9b5f30be19cdf08813d62)
- Fix issues with secondary pointing offset [`562763b`](https://github.com/fomantic/Fomantic-UI/commit/562763b990c48a918ced920b953b1cd76a483a1a)
- Fix issues with shape backface visibility in chrome [`b65ecfc`](https://github.com/fomantic/Fomantic-UI/commit/b65ecfcc1482eb8af2ead3a88f898629cd27fb54)
- Fix issues with sticky when doesntFit scroll being slow [`1d47939`](https://github.com/fomantic/Fomantic-UI/commit/1d479395c2e44351ea16054028848fca033b2fef)
- Fix issues with tab module scoping caused by m initializeHistory. Fixes some minor jslint [`98de07d`](https://github.com/fomantic/Fomantic-UI/commit/98de07d98c379c5fd160e0ff0cbf6bf555113f7e)
- Fix issues with tasks caused by docs tasks [`0c99aa8`](https://github.com/fomantic/Fomantic-UI/commit/0c99aa85d300025cc3a8661bb4c1020f165c21b7)
- Fix issues with transition docs [`157bd3d`](https://github.com/fomantic/Fomantic-UI/commit/157bd3dc6092929e004cb5c37362e67091120345)
- Fix italicized checkbox check [`8f39d19`](https://github.com/fomantic/Fomantic-UI/commit/8f39d19ce0b445b5b7873c6f9b3c319bdef1daf9)
- Fix item menu item border [`c8eba15`](https://github.com/fomantic/Fomantic-UI/commit/c8eba15a6198a6e6ab67c8cd5cc19b8513968f26)
- Fix iterating [`a70ce06`](https://github.com/fomantic/Fomantic-UI/commit/a70ce06f4a60c39bff7ec8b916b3ce2db809d211)
- Fix jshint errors in search [`8278323`](https://github.com/fomantic/Fomantic-UI/commit/8278323cad3cd1e818309b3318ed5a458476ef0c)
- Fix keyboard selection after multi remove, settings comments [`bcc4809`](https://github.com/fomantic/Fomantic-UI/commit/bcc48092370ac18b05d231724c62b363f96d1429)
- Fix keyboard selection styles for errored form dropdown [`6e74de4`](https://github.com/fomantic/Fomantic-UI/commit/6e74de41ee13d772405b498a53d708ccdd3c8161)
- Fix keyboard shortcut bug in search [`80825b1`](https://github.com/fomantic/Fomantic-UI/commit/80825b1a681b270e99c612209d6b5cdac55bba0f)
- Fix label in example [`06ea60e`](https://github.com/fomantic/Fomantic-UI/commit/06ea60e558f0919a0a72cf3e6ca50760f3a5b8f1)
- Fix label size inside header [`be2b5cd`](https://github.com/fomantic/Fomantic-UI/commit/be2b5cdfe172d4e10ba524e6a6b32f845b3ff96e)
- Fix label to use rem [`e5a64dc`](https://github.com/fomantic/Fomantic-UI/commit/e5a64dcad19414fdaea83cfa9a84c611526c41aa)
- Fix label word wrap [`fa7d16e`](https://github.com/fomantic/Fomantic-UI/commit/fa7d16e608ac62d229bebf282c668f246a27aa73)
- Fix labeled input in form examples [`376bb8d`](https://github.com/fomantic/Fomantic-UI/commit/376bb8d9bbc133212d0a0c3a2e87e5ec8dc7f3af)
- Fix language in rlsnotes [`c9e8a08`](https://github.com/fomantic/Fomantic-UI/commit/c9e8a089f339dda47bc646f5d730ae2aa44da0cb)
- Fix language labels hiding on code samples [`44d62b8`](https://github.com/fomantic/Fomantic-UI/commit/44d62b874c95e4514459864470b5185213c25ab5)
- Fix language modal reappearing [`fd88c30`](https://github.com/fomantic/Fomantic-UI/commit/fd88c30ab1384409d174fb0f74c0f1b04bf24d6f)
- Fix last border on inline menus [`d8314fd`](https://github.com/fomantic/Fomantic-UI/commit/d8314fd659912c76dca1ede7c8fba748397145bd)
- Fix last path [`aeda6ab`](https://github.com/fomantic/Fomantic-UI/commit/aeda6abe1e3eff1804fd73daf7c67e7cd49cb876)
- Fix last tab inside container which does not have correct bottom margin [`87c8e52`](https://github.com/fomantic/Fomantic-UI/commit/87c8e526a70ce282f1a06e9c1142a02f4628639c)
- Fix link [`ce4b3c7`](https://github.com/fomantic/Fomantic-UI/commit/ce4b3c76e91b6627a81c93bd54f0fc7a7aa0cd72)
- Fix links in release notes [`8c0d3ab`](https://github.com/fomantic/Fomantic-UI/commit/8c0d3abc81bee5557594ad42c511a1c54df5839f)
- Fix links in src/ [`5ee82cc`](https://github.com/fomantic/Fomantic-UI/commit/5ee82cc4e08cca2efb238b9107f222d7f5438d39)
- Fix links to github issues [`ae592a9`](https://github.com/fomantic/Fomantic-UI/commit/ae592a9f61c71410eab345d24fcd8b9167877106)
- Fix list table layout resizing [`0a756c7`](https://github.com/fomantic/Fomantic-UI/commit/0a756c75115eff0522da1af985419d6277676064)
- Fix loading dropdown button, duplicate loading state, similar #2295. Fix search inside menu does not clear search term on select [`1a5010b`](https://github.com/fomantic/Fomantic-UI/commit/1a5010b36e1373d658b6adcb5a127d24fc8d950b)
- Fix loading dropdown rules [`dac96b4`](https://github.com/fomantic/Fomantic-UI/commit/dac96b485b1b3d01adb4b7612af03a570898c857)
- Fix loading dropdown spinner position [`2b2187c`](https://github.com/fomantic/Fomantic-UI/commit/2b2187c415d34ce586663fab1fe9455cfa171003)
- Fix loading styles to descend from site.variables for buttons, add back in conditional text fixes [`838ee42`](https://github.com/fomantic/Fomantic-UI/commit/838ee42d481f8908277bbdb9b9385106e217b843)
- Fix logic snafoo in API [`#3770`](https://github.com/fomantic/Fomantic-UI/issues/3770)  [`61e6d13`](https://github.com/fomantic/Fomantic-UI/commit/61e6d133c8251f5eeae5f4eac1cfd53b88318704)
- Fix logo link, anchor links [`398cbcb`](https://github.com/fomantic/Fomantic-UI/commit/398cbcbcb98f004d202a4fa1ba39e78980d6a742)
- Fix margin in secondary fluid menu [`3e7575d`](https://github.com/fomantic/Fomantic-UI/commit/3e7575ddde466459607c69be9675435008bd1b4d)
- Fix margin on buttons inside cards [`feb2135`](https://github.com/fomantic/Fomantic-UI/commit/feb2135b6633a967198dd864dc713f2bb5ecbfb1)
- Fix margin on fields with only one field [`fe24d4b`](https://github.com/fomantic/Fomantic-UI/commit/fe24d4bcd675b4e48132c6fcc5d31922c0aae2a3)
- Fix margin on header [`c4111c7`](https://github.com/fomantic/Fomantic-UI/commit/c4111c726666a95e642756af54b871fd9e7f5cc5)
- Fix margin on secondary pointing [`2ac6237`](https://github.com/fomantic/Fomantic-UI/commit/2ac623765f991b0047d6312517b50a1e5a39a440)
- Fix margin when floated content after top attached label [`2ed268a`](https://github.com/fomantic/Fomantic-UI/commit/2ed268a732f5c38f8835b8b34f9a29122a33a7b5)
- Fix material theme radius [`1a40b83`](https://github.com/fomantic/Fomantic-UI/commit/1a40b83c88cdfb76c2eb3f9d4402ac2ecd5ac881)
- Fix math on scroll context [`064477c`](https://github.com/fomantic/Fomantic-UI/commit/064477c47d9f48a41b086e09811bed8e0b0a7dea)
- Fix md spacing [`9133603`](https://github.com/fomantic/Fomantic-UI/commit/91336038a21dcf222f03d0b3f2acc9e74ecd849e)
- Fix menu dropdown border radius [`84da9ba`](https://github.com/fomantic/Fomantic-UI/commit/84da9ba97d30ee8de7628387912dfff48da8f8b7)
- Fix menu to have same border color on keyboard tab [`3510d96`](https://github.com/fomantic/Fomantic-UI/commit/3510d967df4f815cb3ee87def3f931474cc59d3f)
- Fix merge commit [`5ccf607`](https://github.com/fomantic/Fomantic-UI/commit/5ccf607e7acf99f9289a4af3203daa1f64638b66)
- Fix message header distance [`fd16dd2`](https://github.com/fomantic/Fomantic-UI/commit/fd16dd2e6cf11fef71a6f453399cbda7a4a34c25)
- Fix meteor repo link [`07626c1`](https://github.com/fomantic/Fomantic-UI/commit/07626c18b53f59425fb8f9ce1de1d6c5cd379016)
- Fix method not exist error on transition [`6a11e49`](https://github.com/fomantic/Fomantic-UI/commit/6a11e491f1eceb17010aced948cd51acbce72d3b)
- Fix min-width flex issue on item [`c239569`](https://github.com/fomantic/Fomantic-UI/commit/c239569802813f011ec2bf732d8c5687441d4820)
- Fix misnamed variables [`554069d`](https://github.com/fomantic/Fomantic-UI/commit/554069d7ee7e8df1fc553e0908c8818c62d53404)
- Fix mispelling, and adjusts homepage animation [`d4da386`](https://github.com/fomantic/Fomantic-UI/commit/d4da3862380c6e6a407cdcfe74c6c54628d45a15)
- Fix missing return from $.each in transition [`1270e03`](https://github.com/fomantic/Fomantic-UI/commit/1270e031fb26724faa664076410c1fa26a31458e)
- Fix missing selector in stretched grid [`0a651aa`](https://github.com/fomantic/Fomantic-UI/commit/0a651aaa9f2bf4972454fc1f1e80614f79b223ed)
- Fix missing table variables [`980db0e`](https://github.com/fomantic/Fomantic-UI/commit/980db0ec003753e092a49384505ba322a643d0fb)
- Fix missing variable in menu.less [`c8e41de`](https://github.com/fomantic/Fomantic-UI/commit/c8e41defbd97f69e259ff25c9cc008327e5f3bb7)
- Fix missing variables in input, updates bower.json [`c1a44b5`](https://github.com/fomantic/Fomantic-UI/commit/c1a44b5a5c54a63970d123ce8613acec3c88ff39)
- Fix mistaken use of variable [`a3a1763`](https://github.com/fomantic/Fomantic-UI/commit/a3a1763c8d2a9ad3ae4671c56d9f9f93929eb389)
- Fix mistaken variable in popup [`5550ba6`](https://github.com/fomantic/Fomantic-UI/commit/5550ba6e38f989755dda60dfaaf239f51521553b)
- Fix mobile example overflow with large images [`48eb9ab`](https://github.com/fomantic/Fomantic-UI/commit/48eb9ab060eb0f0e7db6ba8f9839eeb74c993b5f)
- Fix mobile form field spacing [`#3913`](https://github.com/fomantic/Fomantic-UI/issues/3913)  [`d8bdcaf`](https://github.com/fomantic/Fomantic-UI/commit/d8bdcafa8364aaa625beae4ddc60eca963a1f01e)
- Fix mobile menu init on not tab pages [`9a92cd6`](https://github.com/fomantic/Fomantic-UI/commit/9a92cd651c614625b4895b1f0dfb2cd705ec2c81)
- Fix mobile padding [`7ef4110`](https://github.com/fomantic/Fomantic-UI/commit/7ef41104da5dec159c3593a04bfdcf5203e0a92c)
- Fix mobile styles on docs [`0175699`](https://github.com/fomantic/Fomantic-UI/commit/01756998b368a3d9ec5376d5270ba5547f27b4bf)
- Fix mobile styles on homepage [`941c167`](https://github.com/fomantic/Fomantic-UI/commit/941c1674829204f27c7faf4e5538f81c489c7ee3)
- Fix mobile styling of 'image content' not appearing correctly [`c06a11e`](https://github.com/fomantic/Fomantic-UI/commit/c06a11e4ae29994f4b915e6064e412c2856c6204)
- Fix modal / sidebar incompatibilities [`12afde8`](https://github.com/fomantic/Fomantic-UI/commit/12afde89d65589ef35c4e2eb0df0d60fff52d161)
- Fix modal flex issue in IE11 [`92fa08f`](https://github.com/fomantic/Fomantic-UI/commit/92fa08f1f4006d02cb62a2bd8dea9d1f04018e21)
- Fix modal mobile sizes, add several new variables, add modal header lineheight [`7e1c9d4`](https://github.com/fomantic/Fomantic-UI/commit/7e1c9d41114a8e36f64c22e4049826c30e82e734)
- Fix module example text, fix ascending/descending arrows for sortable table [`66f7b72`](https://github.com/fomantic/Fomantic-UI/commit/66f7b724dcc3166dae36b5761397e175f77883d9)
- Fix most tooltip animations [`370cbdb`](https://github.com/fomantic/Fomantic-UI/commit/370cbdb62fad9da561f42255b39629bd4ef2035e)
- Fix move reveal timings [`88d1581`](https://github.com/fomantic/Fomantic-UI/commit/88d1581b9f8e170db1c31e962533a06a5e6eecf0)
- Fix multi dropdown icon spacing [`a7cab11`](https://github.com/fomantic/Fomantic-UI/commit/a7cab11bba882aeb37c3f7b46a70d4e08a4304e1)
- Fix multiple match for some rules [`ae74507`](https://github.com/fomantic/Fomantic-UI/commit/ae745077aa50b645258959fe0fed210985342b7b)
- Fix mutation observer check to not produce errors [`1711069`](https://github.com/fomantic/Fomantic-UI/commit/17110696b402cc63b81a381269f81ec73ee07e13)
- Fix needs docs rlsnotes [`5ab6b1d`](https://github.com/fomantic/Fomantic-UI/commit/5ab6b1d04fcb2190d77fbbc4bd40b1d6180d4f43)
- Fix next version # [`ab7b3be`](https://github.com/fomantic/Fomantic-UI/commit/ab7b3be53d9314e0f270ea8d7cffc5faa29e337f)
- Fix no results message when using scrolling menu [`432d39f`](https://github.com/fomantic/Fomantic-UI/commit/432d39f4e7416e3175db3e5a0565fa67eeed1d58)
- Fix npm gulpfile [`d1fc358`](https://github.com/fomantic/Fomantic-UI/commit/d1fc3588af5503a367491402fc98120898a8bf50)
- Fix npm package name to match 0.x.x branch [`7cb8f52`](https://github.com/fomantic/Fomantic-UI/commit/7cb8f52e09ddf2349ada597f9ff4b2dfb321905d)
- Fix observe changes not working correctly in popup [`549e61f`](https://github.com/fomantic/Fomantic-UI/commit/549e61f35e5b7bf5612ca1df7be7eb72014f82dd)
- Fix occurred being reset on browser resize [`c60cf06`](https://github.com/fomantic/Fomantic-UI/commit/c60cf0625727e930504ef1d52f7d11e2d4558420)
- Fix offset on bottom tabular menu [`5d11b3f`](https://github.com/fomantic/Fomantic-UI/commit/5d11b3f3709a437024c1edbf1ebfb69476a4b915)
- Fix one pixel offset on inverted menu due to lack of border [`784b0a4`](https://github.com/fomantic/Fomantic-UI/commit/784b0a495bf0ebfe2fd061b4afac9f099f61f2ab)
- Fix or variables to all be derived automatically from button padding, more or fixes [`62c0883`](https://github.com/fomantic/Fomantic-UI/commit/62c08830c531be8fede077cfb1a31d1d9ae6938c)
- Fix ordered step alignment [`c885e97`](https://github.com/fomantic/Fomantic-UI/commit/c885e971f7e68a7f563a9e56f962b7b96095886c)
- Fix othersActive check missing some cases with multiple modals [`ba315da`](https://github.com/fomantic/Fomantic-UI/commit/ba315da43937543e7e68cf56b2dcd6ede342073b)
- Fix overlap on basic grouped buttons so that hovered element always appears on top, fixes to progress docs [`914d262`](https://github.com/fomantic/Fomantic-UI/commit/914d2622ca0ce0c5cacd91a58bb449d9615b19de)
- Fix overlap when selecting dropdown choice with keyboard when useLabels: false [`40bf2ce`](https://github.com/fomantic/Fomantic-UI/commit/40bf2cea3566fdfd1981f341d8b2114fc28c6ad4)
- Fix package.json to point to 1.0 branch [`81df5ab`](https://github.com/fomantic/Fomantic-UI/commit/81df5abb1494d929e819e1e28916bca05cdbd660)
- Fix page down/up scrolling page when not search selection, simplify letter select shortcuts (first value with letter only) [`af56587`](https://github.com/fomantic/Fomantic-UI/commit/af565875e86bbd3e8b8d9e46035005a42b73dfb2)
- Fix page minheight with sidebar [`da16fd6`](https://github.com/fomantic/Fomantic-UI/commit/da16fd6fe73d3398a46bbeab2f4f13df232ff653)
- Fix parameters being encoded by default in tab, add encodeParameters setting to API [`#2752`](https://github.com/fomantic/Fomantic-UI/issues/2752)  [`1cac8a5`](https://github.com/fomantic/Fomantic-UI/commit/1cac8a53f910580d0df492f4e8c502c9f8699c66)
- Fix paths from sub-folder [`45de05e`](https://github.com/fomantic/Fomantic-UI/commit/45de05e2ce4db5d8589acedce7a316aef31e3e5f)
- Fix paths in gulp build [`beaf102`](https://github.com/fomantic/Fomantic-UI/commit/beaf1020eefdfcabbbcabdfbf7af3710efe5dae1)
- Fix paths in win [`a7c6cd3`](https://github.com/fomantic/Fomantic-UI/commit/a7c6cd3384305784e98174b00f12312bdd922159)
- Fix paths inside inquirer, updating less vars in install [`e5166aa`](https://github.com/fomantic/Fomantic-UI/commit/e5166aa0502fe943322eb75705bfec69893063e8)
- Fix paths issue [`8dafefd`](https://github.com/fomantic/Fomantic-UI/commit/8dafefd858f6e24b344dcab8768865996982aa2b)
- Fix permission Q [`10ba573`](https://github.com/fomantic/Fomantic-UI/commit/10ba573e1a26e7e8c796e67b87182d54a70d092a)
- Fix placeholder text when useLabels: false and 0 selected [`ade6ab5`](https://github.com/fomantic/Fomantic-UI/commit/ade6ab536b5443ae2999537e2cdc4d01e9227b94)
- Fix placeholder uses auto not boolean true [`#2072`](https://github.com/fomantic/Fomantic-UI/issues/2072)  [`3913c17`](https://github.com/fomantic/Fomantic-UI/commit/3913c17d931625eb054357198428b9ba84193a55)
- Fix placeholder vis [`d1c1e60`](https://github.com/fomantic/Fomantic-UI/commit/d1c1e603088e154ac95a4b3faa552114ac715e50)
- Fix point-events typo [`#4408`](https://github.com/fomantic/Fomantic-UI/issues/4408)  [`a551335`](https://github.com/fomantic/Fomantic-UI/commit/a551335b854681ddf279ca2827ed157191cf0198)
- Fix popup called with incorrect target or popup [`33cb715`](https://github.com/fomantic/Fomantic-UI/commit/33cb715a5ca380c5105b3cb0ef1c245aa8c48d42)
- Fix popup example [`6d870c1`](https://github.com/fomantic/Fomantic-UI/commit/6d870c11d7ec8d4d6b5092832f9cb3a50eb7c398)
- Fix popup in menu, add min-height [`e1499e6`](https://github.com/fomantic/Fomantic-UI/commit/e1499e61d6ffe9cf59b6b4336be4056f56ad8b13)
- Fix popup to use observeChanges instead of autoremove [`b7e317a`](https://github.com/fomantic/Fomantic-UI/commit/b7e317a5de5895b2bac2acb2590e31b7a039c746)
- Fix positioning [`50b8989`](https://github.com/fomantic/Fomantic-UI/commit/50b898910099d0bf0a23e051f1178dbf06c1881c)
- Fix positioning with loading/dropdown icon [`635a0ee`](https://github.com/fomantic/Fomantic-UI/commit/635a0eed735fb45370e08a4216b6d9d8ea0ef519)
- Fix positive/negative button color regression [`ecbd893`](https://github.com/fomantic/Fomantic-UI/commit/ecbd893ed4e918434bf3d654f6739243b70dccbe)
- Fix possible memory leak in popup/sticky/visibility [`34988c7`](https://github.com/fomantic/Fomantic-UI/commit/34988c7c4fd7adeb7688eb89829f1469572fb702)
- Fix prefixing of min-content [`e8aba03`](https://github.com/fomantic/Fomantic-UI/commit/e8aba032386d18b00c312d87b09dd81df1bf02b1)
- Fix preserve html setting [`874ef24`](https://github.com/fomantic/Fomantic-UI/commit/874ef24cf4051195376750275d66848312bdf19b)
- Fix progress text multiline flow, make default style more flat, fix some conditions on 100% complete [`514641e`](https://github.com/fomantic/Fomantic-UI/commit/514641ec8d2069ed30d606bc54574d790aa2825c)
- Fix progress to use update interval [`acf3cc5`](https://github.com/fomantic/Fomantic-UI/commit/acf3cc5a4fca56a7ada4d4c08907cba02b98297e)
- Fix quote encoding in dropdown [`f38237d`](https://github.com/fomantic/Fomantic-UI/commit/f38237d6f8d03bbfae26c1056b23aae99da24c00)
- Fix radio/checkbox output from serialize caused by formatting changes [`#1630`](https://github.com/fomantic/Fomantic-UI/issues/1630)  [`3de207e`](https://github.com/fomantic/Fomantic-UI/commit/3de207e0ad7a6a189a68d5e1099a0d44f574f6e1)
- Fix rating example, darken default page color [`8d2b9fc`](https://github.com/fomantic/Fomantic-UI/commit/8d2b9fc829ac06290596bb4a26b136faf7aef21b)
- Fix rating example, remove relaxed list header spacing [`16feb95`](https://github.com/fomantic/Fomantic-UI/commit/16feb9565f068e33fff252b629cc2028311d8625)
- Fix rating valign [`db2abcb`](https://github.com/fomantic/Fomantic-UI/commit/db2abcbd6b6bb8dce6d2d1690dff408abd84112a)
- Fix rating vertical alignment [`12d90eb`](https://github.com/fomantic/Fomantic-UI/commit/12d90eb5d35daad9d8a5312b373d91d8517d2fc5)
- Fix rebuild on site.variables debug [`8ce8f11`](https://github.com/fomantic/Fomantic-UI/commit/8ce8f11496008a889b9820dc9f647309d26fb838)
- Fix recording final display state as none [`54bd5af`](https://github.com/fomantic/Fomantic-UI/commit/54bd5afac69a5119c7e4b3c0eb663264a9360482)
- Fix regexp for theme changes [`13b62a9`](https://github.com/fomantic/Fomantic-UI/commit/13b62a9096c0e81efeaabfe7f603051a246fd22d)
- Fix regression, causing dimmer not to cover whole page when on mobile or scrolling dimmer content. [`f6b0155`](https://github.com/fomantic/Fomantic-UI/commit/f6b015564e10c52393626eb197e668949af402ac)
- Fix related to [`#1199`](https://github.com/fomantic/Fomantic-UI/issues/1199)  issue with using scrollbar causing dropdown to close [`c4635a7`](https://github.com/fomantic/Fomantic-UI/commit/c4635a741ee51a7efbb95e11edc2906224470e9b)
- Fix related to [`#1495`](https://github.com/fomantic/Fomantic-UI/issues/1495)  stackable equal height grid wrong width, add padding to divided stackable grid [`24e0332`](https://github.com/fomantic/Fomantic-UI/commit/24e03320d19d1be689781a0c44c5f16964ec3183)
- Fix relaxed/veryrelaxed grid container [`ffd2a73`](https://github.com/fomantic/Fomantic-UI/commit/ffd2a73c1dad674888607ea94b2c217fc2962032)
- Fix release note merge [`8448492`](https://github.com/fomantic/Fomantic-UI/commit/844849285d8f554c8abfadf602bf330a6f8e2dcd)
- Fix release notes formatting [`87566e9`](https://github.com/fomantic/Fomantic-UI/commit/87566e98eb5d3a19e1f51c01ce850aa37dcbd87b)
- Fix release notes link [`959c93d`](https://github.com/fomantic/Fomantic-UI/commit/959c93d96c9d9784be4bec6cc8800326f3e409f1)
- Fix releasenotes link [`2c65133`](https://github.com/fomantic/Fomantic-UI/commit/2c651336bb6e6f1b660aeaaf93cf04c045ff1b33)
- Fix rem sizing on icon [`#3782`](https://github.com/fomantic/Fomantic-UI/issues/3782)  [`6552df0`](https://github.com/fomantic/Fomantic-UI/commit/6552df01c835ff248856956cae7a614e5f23902d)
- Fix remaining issues [`#2335`](https://github.com/fomantic/Fomantic-UI/issues/2335)  [`7242cc3`](https://github.com/fomantic/Fomantic-UI/commit/7242cc33695673b0e4f4fef37dc1844786321686)
- Fix remove/add conditions for user additions [`e6194fb`](https://github.com/fomantic/Fomantic-UI/commit/e6194fb9af5962556879c15d7bcd81d744fd7aae)
- Fix responsive fluid step [`bc8100a`](https://github.com/fomantic/Fomantic-UI/commit/bc8100a547fc6f2efd0a0d76d5319f09b4741caa)
- Fix responsive sizing of definition table [`#1428`](https://github.com/fomantic/Fomantic-UI/issues/1428)  [`cf5e4b4`](https://github.com/fomantic/Fomantic-UI/commit/cf5e4b4da25d3a7ec284738bf328353f0f0f6bff)
- Fix responsive styling on steps with flexbox [`bf32621`](https://github.com/fomantic/Fomantic-UI/commit/bf32621d683a2b8f969b8ba7ae360f9369ef8b53)
- Fix reveal timing [`1e50b6d`](https://github.com/fomantic/Fomantic-UI/commit/1e50b6dc3336ffea91b96352a868c65a445a17bd)
- Fix reveal transition duration [`1855ea6`](https://github.com/fomantic/Fomantic-UI/commit/1855ea66fed93d25585d43f6cc6a83e9f565df94)
- Fix right menu item [`2aa7066`](https://github.com/fomantic/Fomantic-UI/commit/2aa70665008395614bb3ac6d60d958572e1e5e55)
- Fix rls [`6389e62`](https://github.com/fomantic/Fomantic-UI/commit/6389e62e204e1e6a792cdbb29cd23b65112947c1)
- Fix rlsnotes [`5bdde32`](https://github.com/fomantic/Fomantic-UI/commit/5bdde32e424a891cdab18d6a209dbc864101e6b3)
- Fix rounded and circular image [`93d68c9`](https://github.com/fomantic/Fomantic-UI/commit/93d68c956a1033e3bce1a33ea06bab0a18a722ad)
- Fix rounding of header line height [`7873189`](https://github.com/fomantic/Fomantic-UI/commit/7873189a28916f2b80611d5f23427e99cae59a49)
- Fix rounding of icon margins [`b39fadc`](https://github.com/fomantic/Fomantic-UI/commit/b39fadcf3b1e1aafd41cabda319f681baf5f42fe)
- Fix row padding on divided forms, remove console log, remove date fields from form [`5ba43c9`](https://github.com/fomantic/Fomantic-UI/commit/5ba43c9a35d0ecf31cc0867cd25e0bcf141870ca)
- Fix rtl css build [`3d81a91`](https://github.com/fomantic/Fomantic-UI/commit/3d81a91385aa4ebc35156371e17b50c0b5039d59)
- Fix scaledown not hiding page in some conditions [`fbf0f3a`](https://github.com/fomantic/Fomantic-UI/commit/fbf0f3ab9d1b1df40cec9de4c04eef46dd507866)
- Fix scrollbar width in IE [`b19a687`](https://github.com/fomantic/Fomantic-UI/commit/b19a6873647fc5fa1a74dbcb21a77972a2ceb419)
- Fix scrolling dropdown not to depend on a minimum width, calculate padding with scrollbar [`4e355a2`](https://github.com/fomantic/Fomantic-UI/commit/4e355a2afb3d2e48c5e5f6e53d8f3f29439a6ccd)
- Fix scrolling menu item height [`e5807f4`](https://github.com/fomantic/Fomantic-UI/commit/e5807f48aac0bdd7144a33c3743dd400ebbc8977)
- Fix scrolling modal spacing on mobile [`43b488f`](https://github.com/fomantic/Fomantic-UI/commit/43b488fcb66b0e0da46f43946828618bf04d55d6)
- Fix search button padding [`21d695c`](https://github.com/fomantic/Fomantic-UI/commit/21d695c46fee35b2f19f1c7c088ad8ddd6d441c0)
- Fix search dropdown to allow input to support bgcolors (autocomplete), fix lineheight offset on input in search selection so bged inputs do not overlap borders [`#1508`](https://github.com/fomantic/Fomantic-UI/issues/1508)  [`4f8b806`](https://github.com/fomantic/Fomantic-UI/commit/4f8b80648da33cc11caa01e1f247302989e40ca5)
- Fix search removes filter before hiding [`960c82c`](https://github.com/fomantic/Fomantic-UI/commit/960c82cad21a9c71e452292464ab7a00fcb00506)
- Fix search results close when change browser tab [`913aa77`](https://github.com/fomantic/Fomantic-UI/commit/913aa7744fd8a80999bd8652ebc69c98e860a23d)
- Fix search to use rem, add additional sizes [`#2421`](https://github.com/fomantic/Fomantic-UI/issues/2421)  [`7c26f94`](https://github.com/fomantic/Fomantic-UI/commit/7c26f944d6f7bbc6dc6911b2ab68b002dc0a58e9)
- Fix searchdelay could make results appear even after search has lost focus [`2a53a9f`](https://github.com/fomantic/Fomantic-UI/commit/2a53a9fbd02ff40074fbefcdf03e23ee57f693c3)
- Fix secondary bug in [`#1532`](https://github.com/fomantic/Fomantic-UI/issues/1532)  dropdown focus state in form gets input marker [`9c3b5e7`](https://github.com/fomantic/Fomantic-UI/commit/9c3b5e70b6f1a5509c8b3184a8feca85d1795092)
- Fix secondary pointing 'right item' [`1653135`](https://github.com/fomantic/Fomantic-UI/commit/16531356350d4bd53d3db044303be954d38776a7)
- Fix secondary pointing menu vertical margin [`4e41405`](https://github.com/fomantic/Fomantic-UI/commit/4e414059595074676f845479974800e5979d360e)
- Fix segment when used with grid [`0700c51`](https://github.com/fomantic/Fomantic-UI/commit/0700c51eb9ac68630d4f985d4ed826c2c12c039e)
- Fix selection dropdown inside menu [`484c282`](https://github.com/fomantic/Fomantic-UI/commit/484c282dab453931d1d0ff4f405c3ec045ae1f7a)
- Fix selection issue with &lt;select&gt; and userAdditions [`79c3108`](https://github.com/fomantic/Fomantic-UI/commit/79c31082b76c300cd6540b56e3dda7ee68300ceb)
- Fix selection min-height, fix pageup/down do not work when scrolling less than a page [`f77e001`](https://github.com/fomantic/Fomantic-UI/commit/f77e00174f29f2eef3581e965edf29ad2dd3213b)
- Fix semantic.json inheritance [`5040387`](https://github.com/fomantic/Fomantic-UI/commit/5040387b9c764d5c07d10dd0dea424bce4adcf4a)
- Fix seven column tablet [`#1716`](https://github.com/fomantic/Fomantic-UI/issues/1716)  [`9960580`](https://github.com/fomantic/Fomantic-UI/commit/99605806c69b1723cd137f0150e2f38b95d48278)
- Fix several bugs in inverted tables with celled, disabled content [`1b4ca20`](https://github.com/fomantic/Fomantic-UI/commit/1b4ca20721d57b1fd87b767dec8b9a07d6b07297)
- Fix several examples, and bug in tabbed pages with following menu [`e066be4`](https://github.com/fomantic/Fomantic-UI/commit/e066be47cb68c845a412940ac1683c857319b375)
- Fix several important edge cases for multiselect keyboard events [`8dd14e0`](https://github.com/fomantic/Fomantic-UI/commit/8dd14e08c5c6a286375770e1415e300c2ed51527)
- Fix several issues with API, including throttle on first request, moving interruptRequest to a setting, fixing loadingDuration not applying when using 'query' [`e88c529`](https://github.com/fomantic/Fomantic-UI/commit/e88c529af4e71730ba19630d58858cc92d5ac9e0)
- Fix several issues with selector refreshing in popup [`5cd5ae3`](https://github.com/fomantic/Fomantic-UI/commit/5cd5ae3947a8fe51b57ca6743d7a64f007e5a6c7)
- Fix several issues with shape, but not all.. [`d31c309`](https://github.com/fomantic/Fomantic-UI/commit/d31c3094ec20ea6fdcd4db8b0d259d57dd12d1e8)
- Fix several references to this in proxy to use variable 'element' to avoid keyword issues [`b30779e`](https://github.com/fomantic/Fomantic-UI/commit/b30779e3713907952eaf1528a50708237cb94d0a)
- Fix shape not removing clone [`2bc5c2e`](https://github.com/fomantic/Fomantic-UI/commit/2bc5c2e14de6c703793cf51c95785e35026157ad)
- Fix shimmering on basic modal in FF [`7b03c7e`](https://github.com/fomantic/Fomantic-UI/commit/7b03c7e870c383d0dfb5fed29fbf29cb899f6fee)
- Fix single select dropdown does not correctly save name/value pairs in session [`ea859db`](https://github.com/fomantic/Fomantic-UI/commit/ea859dba9bb228cc8c1abd228a5b2fed8bc30ce5)
- Fix site min-width issue [`970820e`](https://github.com/fomantic/Fomantic-UI/commit/970820ea5460f8ccbe3543f8e4243a9a2df0653f)
- Fix sizing in form/input [`efd9a07`](https://github.com/fomantic/Fomantic-UI/commit/efd9a07ac3e00c0aeaf32e21999f7436f8dd3f56)
- Fix some anchor links not working [`3bc6f3d`](https://github.com/fomantic/Fomantic-UI/commit/3bc6f3d7ecc84cdd8528e78e312e22c1af46caf2)
- Fix some conditions which caused dropdown to hide all results [`a2347d6`](https://github.com/fomantic/Fomantic-UI/commit/a2347d68b771ec42c37ea1a3db0fd00c576f6e1b)
- Fix some dropdown example inits [`df21c1a`](https://github.com/fomantic/Fomantic-UI/commit/df21c1a0eb49578d7c062e60a52b349534f43930)
- Fix some example links [`c10dce7`](https://github.com/fomantic/Fomantic-UI/commit/c10dce7d125ca211a6d757550cf416d10381ff44)
- Fix some examples [`365d41b`](https://github.com/fomantic/Fomantic-UI/commit/365d41bae0b905453f856b64cf645189c6d33bf9)
- Fix some flex input conditions [`3fca1e0`](https://github.com/fomantic/Fomantic-UI/commit/3fca1e0b3e30918678d15350c76f4363e85e6532)
- Fix some formatting in release task [`3d4610d`](https://github.com/fomantic/Fomantic-UI/commit/3d4610d57346d0467e615733b0754ae82ed8d40e)
- Fix some issues with scale down animation in sidebar [`4e46bce`](https://github.com/fomantic/Fomantic-UI/commit/4e46bce3911363d17653e737a69a194eafd2fd50)
- Fix some issues with using padding for text menu [`0ae0cbd`](https://github.com/fomantic/Fomantic-UI/commit/0ae0cbde521aba118c85fb0954fcd45657965143)
- Fix some layout issues [`97833c4`](https://github.com/fomantic/Fomantic-UI/commit/97833c449c4984e0d4cf61a031358e9bfa12554a)
- Fix some line height values to be exact px [`fe17f8e`](https://github.com/fomantic/Fomantic-UI/commit/fe17f8e35dcb7377cae3a4fea4acc48f6eabae1b)
- Fix some old comment banners pointing to wrong repo [`b5e73f7`](https://github.com/fomantic/Fomantic-UI/commit/b5e73f715f5f2d3a6721cecf66df3955f2c628fe)
- Fix some paths [`a7b8beb`](https://github.com/fomantic/Fomantic-UI/commit/a7b8beb8bc2b823a2d47d5f82eceaa9b473b3bdc)
- Fix some permissions values [`b435531`](https://github.com/fomantic/Fomantic-UI/commit/b435531df3a126009f121a31603aa850361dba57)
- Fix some placeholder text cases with multiple [`267d948`](https://github.com/fomantic/Fomantic-UI/commit/267d948b345966fbf21c7ce63e4ca02f0a5f04e1)
- Fix some popup examples [`9e5aacd`](https://github.com/fomantic/Fomantic-UI/commit/9e5aacd02536aa825c00bdb1fbca80fd2c3bf90c)
- Fix some search inheritance [`0570887`](https://github.com/fomantic/Fomantic-UI/commit/0570887f2db70de0963e0cc786ee0bf460621e54)
- Fix some variables in tooltip [`246aafe`](https://github.com/fomantic/Fomantic-UI/commit/246aafeec16d731077fa95bfc0325130324702a0)
- Fix some weird edge cases in sticky when doesnt fit [`e1cb9dd`](https://github.com/fomantic/Fomantic-UI/commit/e1cb9dd3140b4b15b6906429fd5e92a5d7867090)
- Fix spacing on image in dropdown [`aa6ecf9`](https://github.com/fomantic/Fomantic-UI/commit/aa6ecf951ce72d4cd8fbaa36e5d52c61e04d14f3)
- Fix specificity for column without row not overrriding grid [`7951b32`](https://github.com/fomantic/Fomantic-UI/commit/7951b32c19e9eefeefc86b51e3ad06fe68a967e7)
- Fix specificity of icon in list [`#1514`](https://github.com/fomantic/Fomantic-UI/issues/1514)  [`0a32e35`](https://github.com/fomantic/Fomantic-UI/commit/0a32e3551f4fef5bb65557a8dcd0c377ccbf8e3d)
- Fix stackable card margins [`4a731ef`](https://github.com/fomantic/Fomantic-UI/commit/4a731ef7bb0f90c56e3064a3fd91e5ea244ff975)
- Fix static transition not fixing display type [`bf70b90`](https://github.com/fomantic/Fomantic-UI/commit/bf70b90343e211660509a456b37b526770ba7182)
- Fix statistic border [`4ac91a2`](https://github.com/fomantic/Fomantic-UI/commit/4ac91a2ebb8ea15e987285bb661c3bd70def557f)
- Fix sticky transition properties [`6856a89`](https://github.com/fomantic/Fomantic-UI/commit/6856a8907995373887bfae1876b0471c224ae6e4)
- Fix storage.remove method localstorage check [`83563e2`](https://github.com/fomantic/Fomantic-UI/commit/83563e2cf93d70dc9693868c196921c77d3780b4)
- Fix sub header overriding first/last-child rules [`86e4f45`](https://github.com/fomantic/Fomantic-UI/commit/86e4f454de97e7438f2f8c99f5f788450ecdce5c)
- Fix succesful indicating progress, rating spacing [`636c8ee`](https://github.com/fomantic/Fomantic-UI/commit/636c8eeccebd731a56eaec232bc1a56ab79efb60)
- Fix tab selector [`5b4116c`](https://github.com/fomantic/Fomantic-UI/commit/5b4116c3767b136e40d7d16d4e26ab5eec6ce1aa)
- Fix tabindex issue [`15e109b`](https://github.com/fomantic/Fomantic-UI/commit/15e109b37387cf07600d1eff6f3a370c4835ff14)
- Fix table active hover color, fix top/botom margins [`3c0931b`](https://github.com/fomantic/Fomantic-UI/commit/3c0931b95beea160b36b3f74af752a5b336878f7)
- Fix table align issue, adjust white border opacity [`a789a07`](https://github.com/fomantic/Fomantic-UI/commit/a789a07889797f6d93f46972ae495ed1d8d6c090)
- Fix table escapes container at mobile [`2a21019`](https://github.com/fomantic/Fomantic-UI/commit/2a210192523d4ef835bc5b9626e583dfd508ff83)
- Fix table footers to not be italic [`8a4a7fe`](https://github.com/fomantic/Fomantic-UI/commit/8a4a7fe9d8618347e19884237a6ca6c6e37dac1d)
- Fix table margins, border radius on colored [`facedc3`](https://github.com/fomantic/Fomantic-UI/commit/facedc3f8471136f98a53d4fb01948841f192b70)
- Fix table responsive styles padding [`7c8c5ab`](https://github.com/fomantic/Fomantic-UI/commit/7c8c5ab5b3f4d3ae85ff58810eade828f121ee2d)
- Fix table segments missing border [`250e464`](https://github.com/fomantic/Fomantic-UI/commit/250e4643dc71ee27ece9a4ebff9069fc85442ad1)
- Fix tabular menu [`8b9e46c`](https://github.com/fomantic/Fomantic-UI/commit/8b9e46c618534fb0a98788ba4b383cfc0faf748a)
- Fix tabular menu valign issue in IE [`512abdf`](https://github.com/fomantic/Fomantic-UI/commit/512abdf83acf06114a23fa987b4190d561dd51a0)
- Fix tag label formatting, add form integration with api, add responsive video sizing without js [`3e99424`](https://github.com/fomantic/Fomantic-UI/commit/3e994241ca55ba5eeeece8d345f9d8ce008e31a4)
- Fix tag transition [`a266d55`](https://github.com/fomantic/Fomantic-UI/commit/a266d555630565ccbd28b72573b605871c96fb67)
- Fix target of child animate [`fbce1f1`](https://github.com/fomantic/Fomantic-UI/commit/fbce1f1c7c6f6a5f84c5d9bb123410f843b3c948)
- Fix tasks path in update [`098430f`](https://github.com/fomantic/Fomantic-UI/commit/098430f7ac5c55700f3ec564ab8ac8f21c3a7f1d)
- Fix text align [`82654d3`](https://github.com/fomantic/Fomantic-UI/commit/82654d314488b8f1ace9801fc4d377be2c7ea065)
- Fix text align for dropdown item in centered container [`fdf3354`](https://github.com/fomantic/Fomantic-UI/commit/fdf3354c8de374a5d906f8802f9b3e753b92712f)
- Fix text align of dropdown in icon menu [`61cf566`](https://github.com/fomantic/Fomantic-UI/commit/61cf566488d757fcc3d9690d5599ada0f9d7a030)
- Fix text menu sub menu position [`70797e9`](https://github.com/fomantic/Fomantic-UI/commit/70797e95ffc281be416968b59252fc62081ff725)
- Fix the 'ignoreCase' option when using multiselect to work with has.label [`#6123`](https://github.com/fomantic/Fomantic-UI/issues/6123)  [`6910893`](https://github.com/fomantic/Fomantic-UI/commit/691089301b0305168bdf9157515b3f13d771e77b)
- Fix the flex [`3874dbb`](https://github.com/fomantic/Fomantic-UI/commit/3874dbbc48f872208e58dd1539218db072ae02a2)
- Fix theme path [`#2101`](https://github.com/fomantic/Fomantic-UI/issues/2101)  [`13303c0`](https://github.com/fomantic/Fomantic-UI/commit/13303c04895179266eec9c0b5cf5c43a501580e9)
- Fix theme.config to load multiple [`3dea109`](https://github.com/fomantic/Fomantic-UI/commit/3dea10949e410dfe13b8b395eb1e676cf8383a28)
- Fix themes path backslash matching regex group (positive lookahead) [`419ffd8`](https://github.com/fomantic/Fomantic-UI/commit/419ffd8562fbc3ce380f313c53e575f486f4a4ca)
- Fix theming example colors [`233a651`](https://github.com/fomantic/Fomantic-UI/commit/233a65159e3b879e51a30d0095fb59aaf40cca42)
- Fix tiered menu sub menu border radius [`c4b99c1`](https://github.com/fomantic/Fomantic-UI/commit/c4b99c1e2fdc2646a9de41876e37c237aad9519e)
- Fix tiny little bug with overlay in sidebar [`0e8129f`](https://github.com/fomantic/Fomantic-UI/commit/0e8129f94938c27c84cb4c71d9bfa139cc2d2b9b)
- Fix toggle height [`670f4f7`](https://github.com/fomantic/Fomantic-UI/commit/670f4f71fc7fcfe8cbb60fb84a565dcb485fc832)
- Fix toggle variables, adjustments to theme [`f6a994a`](https://github.com/fomantic/Fomantic-UI/commit/f6a994a288e4e38768d476a517e66886dcd58d31)
- Fix tooltip case when no data-position is specified [`50306f8`](https://github.com/fomantic/Fomantic-UI/commit/50306f8eaf37706d641c8b21be3b786965d7e6bc)
- Fix top border on icon header [`ba47485`](https://github.com/fomantic/Fomantic-UI/commit/ba4748514ed541e2c17d6111c749d30089d31a8d)
- Fix top right pointing dropdown to move arrow when leftward [`#4211`](https://github.com/fomantic/Fomantic-UI/issues/4211)  [`b13bef1`](https://github.com/fomantic/Fomantic-UI/commit/b13bef17bca184d6b25525dead65ec27293b29ea)
- Fix trailing slash detection in install [`c91f962`](https://github.com/fomantic/Fomantic-UI/commit/c91f9628f281a4823adfafd37fd185a50d67aaf2)
- Fix transition duration in ui input to use site defaults [`0c3f5f4`](https://github.com/fomantic/Fomantic-UI/commit/0c3f5f4405da71200cc1c7df20dc4c36f4ee61f2)
- Fix transition example page [`63723e1`](https://github.com/fomantic/Fomantic-UI/commit/63723e1bf30a2b5d36181edf4dfda6f1dfe87d24)
- Fix transition sometimes keeping inline style unnecesarily [`30e6cb3`](https://github.com/fomantic/Fomantic-UI/commit/30e6cb3cc23c2b00334e9721fdf0dfab51adb957)
- Fix transition variables, adjust list padding to round numbers [`aea9953`](https://github.com/fomantic/Fomantic-UI/commit/aea99536f62723f8676418d45c257e1a14cdda91)
- Fix transitions on ui images &gt; .image [`e31ff0a`](https://github.com/fomantic/Fomantic-UI/commit/e31ff0a16c384ba18973f235a04b0e8006fd8968)
- Fix twitter theme icon colors [`5b32423`](https://github.com/fomantic/Fomantic-UI/commit/5b324236a53fd333a2164522f945b7665ab20c71)
- Fix typo from replace on svg image [`096f130`](https://github.com/fomantic/Fomantic-UI/commit/096f13071c5b096a97a5b200649c7214ea754333)
- Fix typo in Release Notes URL [`4fae429`](https://github.com/fomantic/Fomantic-UI/commit/4fae429d0f26ee4a25663fb0ac4d78f45d13c38d)
- Fix typo in config [`388a11b`](https://github.com/fomantic/Fomantic-UI/commit/388a11bb1499d01ad2604290b5b285d0c7ecbbcd)
- Fix typo in css declaration for .vertical.flip.transition.in [`f08ce76`](https://github.com/fomantic/Fomantic-UI/commit/f08ce768ea851f71f03aca95ae95ce79b534101a)
- Fix typo in grid docs, and adds more doc notes [`03df25b`](https://github.com/fomantic/Fomantic-UI/commit/03df25b75f4ebbae428bcce1c83dd21436194475)
- Fix typo in grid rules [`18b8e2f`](https://github.com/fomantic/Fomantic-UI/commit/18b8e2f7cf7197c051ac3cad6be61c97d9cbbe9b)
- Fix typo in header [`9d494d5`](https://github.com/fomantic/Fomantic-UI/commit/9d494d539db3eee3305e1d279a13101718fbfee3)
- Fix typo in icon menu [`96502c3`](https://github.com/fomantic/Fomantic-UI/commit/96502c31348c9905ff204339e6c71f7229877e71)
- Fix typo in menu [`f49b549`](https://github.com/fomantic/Fomantic-UI/commit/f49b5495e5a257cfa281896f7e9189f0e11eef83)
- Fix typo in popup [`b5fefb5`](https://github.com/fomantic/Fomantic-UI/commit/b5fefb578e0efdb491451623b41b7698a604a17a)
- Fix typo in popup, add new search setting selectFirstResult [`900f082`](https://github.com/fomantic/Fomantic-UI/commit/900f082387ba0614060008cbc2459c161312f27d)
- Fix typo in table [`4e47008`](https://github.com/fomantic/Fomantic-UI/commit/4e4700834dfe2ccdf36f9345b4eb5e251d005a46)
- Fix typo in timeline feed [`5a39510`](https://github.com/fomantic/Fomantic-UI/commit/5a395103c4240d315810af6a88055cfcfad429ad)
- Fix typo referring to gulp, add error for missing semantic.json [`168437c`](https://github.com/fomantic/Fomantic-UI/commit/168437c0b0cdb01cc8d788b92415b31736f45500)
- Fix typos from regex [`738edcc`](https://github.com/fomantic/Fomantic-UI/commit/738edccabb7c3ca323561913b7fc1c387fd7b68e)
- Fix typos in rlsnotes 2.2.3 [`60642e1`](https://github.com/fomantic/Fomantic-UI/commit/60642e10c01be421847c019dad55297558e86235)
- Fix ui list inside menu [`f52e2c7`](https://github.com/fomantic/Fomantic-UI/commit/f52e2c787aaf986b7984dbd0fd34073b3bf11826)
- Fix unchecked checkboxes not being accessible with get value [`688c645`](https://github.com/fomantic/Fomantic-UI/commit/688c64551a0bbedf602d9641e0ba8452bdbd4332)
- Fix undocumented components in theme.config.example [`16620b8`](https://github.com/fomantic/Fomantic-UI/commit/16620b81e049a99b4e54d50d04be7545a1cd1a5d)
- Fix unfinished release note [`32dd5d4`](https://github.com/fomantic/Fomantic-UI/commit/32dd5d4b97c9abd13bff777f4e5eccc9156e0b9a)
- Fix unnecessary classes in examples [`212d9da`](https://github.com/fomantic/Fomantic-UI/commit/212d9da67e95fed357ff298862f2264633b0bd1a)
- Fix unnecessasry line from rlsnotes [`056f074`](https://github.com/fomantic/Fomantic-UI/commit/056f074895c931c93e661210f1e4879e1f3f8688)
- Fix update path [`a52d1c0`](https://github.com/fomantic/Fomantic-UI/commit/a52d1c0bfe2a7a8deece84c4ed49f35eb4849d0d)
- Fix update paths [`19d50b6`](https://github.com/fomantic/Fomantic-UI/commit/19d50b6b476940d87de00acbc298d43313c58310)
- Fix using 'package' reserved keyword in JavaScript (ECMAScript 2) [`134ee18`](https://github.com/fomantic/Fomantic-UI/commit/134ee189345a9de97e3ed480041ebc6fa13b9e67)
- Fix valign again [`af05d23`](https://github.com/fomantic/Fomantic-UI/commit/af05d23d83e7493e38e64e91166d2e8768d02726)
- Fix valign of icon message [`93aa4b9`](https://github.com/fomantic/Fomantic-UI/commit/93aa4b9a1a2f1647b56330fda1a6a24ca274efb7)
- Fix valign on list automatically affecting content/image [`1adaa99`](https://github.com/fomantic/Fomantic-UI/commit/1adaa99e261db8767fa311361987838abb01753c)
- Fix variable addition for close/very close rail [`#3835`](https://github.com/fomantic/Fomantic-UI/issues/3835)  [`b0ca662`](https://github.com/fomantic/Fomantic-UI/commit/b0ca6625c8ca396d09114b8eb89876cb21c26a88)
- Fix variable order causing bugs in invoke in transition [`b62e8b8`](https://github.com/fomantic/Fomantic-UI/commit/b62e8b8a5a20c53d7872d322389b049594119ac7)
- Fix version [`94f9ced`](https://github.com/fomantic/Fomantic-UI/commit/94f9ced66e9713b998d853732eae27080f687e10)
- Fix version tock [`9cecdf0`](https://github.com/fomantic/Fomantic-UI/commit/9cecdf06a876bd1eb3369f29b7790b4332561fa4)
- Fix vertical arrow flicker [`a80a32d`](https://github.com/fomantic/Fomantic-UI/commit/a80a32d5aa99f070fcc780af3591cae54c715398)
- Fix vertical divider offset [`7e98967`](https://github.com/fomantic/Fomantic-UI/commit/7e989674d9787f4f3394cf3c3fa6ba8c4bbcdeff)
- Fix vertical flex align [`4695e6b`](https://github.com/fomantic/Fomantic-UI/commit/4695e6ba837f2ce064271bf6dc90eef9310c9546)
- Fix vertical input sizes, positioning inside menus. Add strict mode all modules [`06bf302`](https://github.com/fomantic/Fomantic-UI/commit/06bf3023ffda9de658f460b78a06c8fcc59812f3)
- Fix vertical inverted border radius [`2b4f415`](https://github.com/fomantic/Fomantic-UI/commit/2b4f415c1c580298f7a5aee945f1eb393e497ba9)
- Fix vertical menu flex [`72ffccb`](https://github.com/fomantic/Fomantic-UI/commit/72ffccb96ba2bc1cdb36f6be201280e1d93aa667)
- Fix vertical sub menu positioning bug [`1b027a1`](https://github.com/fomantic/Fomantic-UI/commit/1b027a1b64dadb61e28771cbb47a4a1eb91b0e9b)
- Fix vertically divided grid spacing in top row [`aa9304e`](https://github.com/fomantic/Fomantic-UI/commit/aa9304ec42478ca76facba16fd30f4ee8a443df6)
- Fix vertically stackable grid spacing [`#2467`](https://github.com/fomantic/Fomantic-UI/issues/2467)  [`cd7bf32`](https://github.com/fomantic/Fomantic-UI/commit/cd7bf32a21e082a11ce364b57e1ebfaf91ce3efc)
- Fix visibility inside scroll context [`b962d89`](https://github.com/fomantic/Fomantic-UI/commit/b962d899f1587fd8b4a84fa198b2c38e897911a7)
- Fix visibility issue with onScreen calculations for long elements [`b78dc75`](https://github.com/fomantic/Fomantic-UI/commit/b78dc75fc17c93996dc2c1164b1c756f606fb4bc)
- Fix warning color using background warning color [`80e529b`](https://github.com/fomantic/Fomantic-UI/commit/80e529b0b585d3dd007d16c9868d02e84006d1a8)
- Fix webkit bug causing transitions not to occur due to translation of animationduration to animation shorthand [`395dfbb`](https://github.com/fomantic/Fomantic-UI/commit/395dfbbe635b83177835d38278cc2b64c9680ae9)
- Fix weird 1px content issue with display: table in chrome on modal, [`#787`](https://github.com/fomantic/Fomantic-UI/issues/787)  [`c46531d`](https://github.com/fomantic/Fomantic-UI/commit/c46531d2f869864437ad088dbdd9b8a695bdffc5)
- Fix wide and very wide popup appear offscreen on mobile [`1177c23`](https://github.com/fomantic/Fomantic-UI/commit/1177c237895875b0a76a415f00503713b8b4971a)
- Fix wrench require statement [`47c61a4`](https://github.com/fomantic/Fomantic-UI/commit/47c61a4e58661eb01d08e5199536eed28c4adcf5)
- Fix wrong black header colors [`#2280`](https://github.com/fomantic/Fomantic-UI/issues/2280)  [`18c0fb7`](https://github.com/fomantic/Fomantic-UI/commit/18c0fb7a290eee7324ea3bb477214409c913133b)
- Fix x wide inside equal width/height [`5a5a360`](https://github.com/fomantic/Fomantic-UI/commit/5a5a360f06802adbb88d883046f8e1376c38057b)
- fix @inputLineHeight comment spelling error [`1f8d24e`](https://github.com/fomantic/Fomantic-UI/commit/1f8d24e7e4eaa84406e326295022c37029bbc684)
- fix accidental merge of orphaned docs branch [`3ef3295`](https://github.com/fomantic/Fomantic-UI/commit/3ef3295247e98af663f1e3660f32bb31dc35670d)
- fix debug settings for sidebar [`0bc4de0`](https://github.com/fomantic/Fomantic-UI/commit/0bc4de0b737802cdfcc98eb9184aeecd20e88834)
- fix dist files' permission [`6b8a2e1`](https://github.com/fomantic/Fomantic-UI/commit/6b8a2e15bd4756d060fc1a988d9f194bc648e9a0)
- fix example [`1247082`](https://github.com/fomantic/Fomantic-UI/commit/12470826c6cb97a45fedf5591ca60ca7ce539abe)
- fix for menu flyout [`6100429`](https://github.com/fomantic/Fomantic-UI/commit/610042936ab7bf12affbf3a436d5adb3010b2908)
- fix link paths [`1c5c14f`](https://github.com/fomantic/Fomantic-UI/commit/1c5c14f732fd3baaf6c853de06e9ffaaad8c927a)
- fix misspell of enable and disable method name [`bf367dc`](https://github.com/fomantic/Fomantic-UI/commit/bf367dc830c1e70cad3f59cca2a69f388c1346b0)
- fix placeholder typo in vendor prefix for IE [`bffda0b`](https://github.com/fomantic/Fomantic-UI/commit/bffda0b46ca05e7882dfc3a6dab6c305c39f852c)
- fix reversed hide/unhide basic icons [`aa79378`](https://github.com/fomantic/Fomantic-UI/commit/aa793789e2fd960e527b7085a9553561e7d8559a)
- fix similar problems some more [`8534da8`](https://github.com/fomantic/Fomantic-UI/commit/8534da878d351d268d5db2ea9d4b1635eff3624b)
- fix to floated items in menu, other fixes to docs [`8ed2b7c`](https://github.com/fomantic/Fomantic-UI/commit/8ed2b7c2d577e248e266199cde615fed81ad91d2)
- fix to steps [`af4b7dc`](https://github.com/fomantic/Fomantic-UI/commit/af4b7dc6d38b018561a9474d0517d914c4e32f5b)


## Chore

- update exempt labels [`862955b`](https://github.com/fomantic/Fomantic-UI/commit/862955bd65fa5ae79c2b648569a7dea4b5b1c09b)


## New contributors

- Fix contributor messages, fix icon spacing bug [`d86e66e`](https://github.com/fomantic/Fomantic-UI/commit/d86e66ec3c0e8d19b99d51e6a8ab8f0fb160e398)
- Setup embed component, fix all contributors banners in src [`40fb074`](https://github.com/fomantic/Fomantic-UI/commit/40fb0743eb4062d9028f4f47494502458902578c)
- contributors [`7b2b72a`](https://github.com/fomantic/Fomantic-UI/commit/7b2b72a9ba79b66dd2c773115ead24d55f16faf1)


