/*
 * # Fomantic UI - 2.9.4
 * https://github.com/fomantic/Fomantic-UI
 * https://fomantic-ui.com/
 *
 * Copyright 2025 Contributors
 * Released under the MIT license
 * https://opensource.org/licenses/MIT
 *
 */
!function(D,I,E){"use strict";function O(e){return"function"==typeof e&&"number"!=typeof e.nodeType}I=void 0!==I&&I.Math===Math?I:globalThis,D.fn.checkbox=function(c){var s,e=D(this),u=Date.now(),b=[],C=c,x="string"==typeof C,w=[].slice.call(arguments,1);return e.each(function(){var e,h=D.extend(!0,{},D.fn.checkbox.settings,c),g=h.className,n=h.namespace,p=h.selector,r=h.error,t="."+n,i="module-"+n,f=D(this),o=D(this).children(p.label),k=D(this).children(p.input),m=k[0],a=!1,v=!1,d=f.data(i),l=this,y={initialize:function(){y.verbose("Initializing checkbox",h),y.create.label(),y.bind.events(),y.set.tabbable(),y.hide.input(),y.observeChanges(),y.instantiate(),y.setup()},instantiate:function(){y.verbose("Storing instance of module",y),d=y,f.data(i,y)},destroy:function(){y.verbose("Destroying module"),y.unbind.events(),y.show.input(),f.removeData(i)},fix:{reference:function(){f.is(p.input)&&(y.debug("Behavior called on <input> adjusting invoked element"),f=f.closest(p.checkbox),y.refresh())}},setup:function(){y.set.initialLoad(),y.is.indeterminate()?(y.debug("Initial value is indeterminate"),y.indeterminate()):y.is.checked()?(y.debug("Initial value is checked"),y.check()):(y.debug("Initial value is unchecked"),y.uncheck()),y.remove.initialLoad()},refresh:function(){o=f.children(p.label),k=f.children(p.input),m=k[0]},hide:{input:function(){y.verbose("Modifying <input> z-index to be unselectable"),k.addClass(g.hidden)}},show:{input:function(){y.verbose("Modifying <input> z-index to be selectable"),k.removeClass(g.hidden)}},observeChanges:function(){"MutationObserver"in I&&((e=new MutationObserver(function(e){y.debug("DOM tree modified, updating selector cache"),y.refresh()})).observe(l,{childList:!0,subtree:!0}),y.debug("Setting up mutation observer",e))},attachEvents:function(e,n){var i=D(e);n=O(y[n])?y[n]:y.toggle,0<i.length?(y.debug("Attaching checkbox events to element",e,n),i.on("click"+t,n)):y.error(r.notFound)},preventDefaultOnInputTarget:function(){void 0!==event&&null!==event&&D(event.target).is(p.input)&&(y.verbose("Preventing default check action after manual check action"),event.preventDefault())},event:{change:function(e){y.should.ignoreCallbacks()||h.onChange.call(m)},click:function(e){var n=D(e.target);n.is(p.input)?y.verbose("Using default check action on initialized checkbox"):n.is(p.link)?y.debug("Clicking link inside checkbox, skipping toggle"):(y.toggle(),k.trigger("focus"),e.preventDefault())},keydown:function(e){var n=e.which,i=13,t=32,o=27,a=37,c=38,r=39,d=40,l=y.get.radios().not(p.disabled),s=l.index(f),u=l.length,b=!1;if(n===a||n===c?b=(0===s?u:s)-1:n!==r&&n!==d||(b=s===u-1?0:s+1),!y.should.ignoreCallbacks()&&!1!==b){if(!1===h.beforeUnchecked.apply(m))return y.verbose("Option not allowed to be unchecked, cancelling key navigation"),!1;c=D(l[b]),d=c.children(p.input);if(c.hasClass(g.readOnly)||d.prop("readonly")||!1===h.beforeChecked.apply(d[0]))return y.verbose("Next option should not allow check, cancelling key navigation"),!1}v=!1,n===o?(y.verbose("Escape key pressed blurring field"),k.trigger("blur"),v=!0,e.stopPropagation()):y.can.change()?e.ctrlKey||(n===t||n===i&&h.enableEnterKey?(y.verbose("Enter/space key pressed, toggling checkbox"),y.toggle(),v=!0):f.is(".toggle, .slider")&&!y.is.radio()&&(n===a&&y.is.checked()?(y.uncheck(),v=!0):n===r&&y.is.unchecked()&&(y.check(),v=!0))):v=!0},keyup:function(e){v&&e.preventDefault()}},check:function(){y.should.allowCheck()&&(y.debug("Checking checkbox",k),y.set.checked(),y.should.ignoreCallbacks()||(h.onChecked.call(m),y.trigger.change()),y.preventDefaultOnInputTarget())},uncheck:function(){y.should.allowUncheck()&&(y.debug("Unchecking checkbox"),y.set.unchecked(),y.should.ignoreCallbacks()||(h.onUnchecked.call(m),y.trigger.change()),y.preventDefaultOnInputTarget())},indeterminate:function(){y.should.allowIndeterminate()?y.debug("Checkbox is already indeterminate"):(y.debug("Making checkbox indeterminate"),y.set.indeterminate(),y.should.ignoreCallbacks()||(h.onIndeterminate.call(m),y.trigger.change()))},determinate:function(){y.should.allowDeterminate()?y.debug("Checkbox is already determinate"):(y.debug("Making checkbox determinate"),y.set.determinate(),y.should.ignoreCallbacks()||(h.onDeterminate.call(m),y.trigger.change()))},enable:function(){y.is.enabled()?y.debug("Checkbox is already enabled"):(y.debug("Enabling checkbox"),y.set.enabled(),y.should.ignoreCallbacks()||(h.onEnable.call(m),h.onEnabled.call(m)))},disable:function(){y.is.disabled()?y.debug("Checkbox is already disabled"):(y.debug("Disabling checkbox"),y.set.disabled(),y.should.ignoreCallbacks()||(h.onDisable.call(m),h.onDisabled.call(m)))},get:{radios:function(){var e=y.get.name();return D('input[name="'+e+'"]').closest(p.checkbox)},otherRadios:function(){return y.get.radios().not(f)},name:function(){return k.attr("name")}},is:{initialLoad:function(){return a},radio:function(){return k.hasClass(g.radio)||"radio"===k.attr("type")},indeterminate:function(){return void 0!==k.prop("indeterminate")&&k.prop("indeterminate")},checked:function(){return void 0!==k.prop("checked")&&k.prop("checked")},disabled:function(){return void 0!==k.prop("disabled")&&k.prop("disabled")},enabled:function(){return!y.is.disabled()},determinate:function(){return!y.is.indeterminate()},unchecked:function(){return!y.is.checked()}},should:{allowCheck:function(){return y.is.determinate()&&y.is.checked()&&!y.is.initialLoad()?(y.debug("Should not allow check, checkbox is already checked"),!1):!(!y.should.ignoreCallbacks()&&!1===h.beforeChecked.apply(m))||(y.debug("Should not allow check, beforeChecked cancelled"),!1)},allowUncheck:function(){return y.is.determinate()&&y.is.unchecked()&&!y.is.initialLoad()?(y.debug("Should not allow uncheck, checkbox is already unchecked"),!1):!(!y.should.ignoreCallbacks()&&!1===h.beforeUnchecked.apply(m))||(y.debug("Should not allow uncheck, beforeUnchecked cancelled"),!1)},allowIndeterminate:function(){return y.is.indeterminate()&&!y.is.initialLoad()?(y.debug("Should not allow indeterminate, checkbox is already indeterminate"),!1):!(!y.should.ignoreCallbacks()&&!1===h.beforeIndeterminate.apply(m))||(y.debug("Should not allow indeterminate, beforeIndeterminate cancelled"),!1)},allowDeterminate:function(){return y.is.determinate()&&!y.is.initialLoad()?(y.debug("Should not allow determinate, checkbox is already determinate"),!1):!(!y.should.ignoreCallbacks()&&!1===h.beforeDeterminate.apply(m))||(y.debug("Should not allow determinate, beforeDeterminate cancelled"),!1)},ignoreCallbacks:function(){return a&&!h.fireOnInit}},can:{change:function(){return!(f.hasClass(g.disabled)||f.hasClass(g.readOnly)||k.prop("disabled")||k.prop("readonly"))},uncheck:function(){return"boolean"==typeof h.uncheckable?h.uncheckable:!y.is.radio()}},set:{initialLoad:function(){a=!0},checked:function(){y.verbose("Setting class to checked"),f.removeClass(g.indeterminate).addClass(g.checked),y.is.radio()&&y.uncheckOthers(),!y.is.indeterminate()&&y.is.checked()?y.debug("Input is already checked, skipping input property change"):(y.verbose("Setting state to checked",m),k.prop("indeterminate",!1).prop("checked",!0))},unchecked:function(){y.verbose("Removing checked class"),f.removeClass(g.indeterminate).removeClass(g.checked),!y.is.indeterminate()&&y.is.unchecked()?y.debug("Input is already unchecked"):(y.debug("Setting state to unchecked"),k.prop("indeterminate",!1).prop("checked",!1))},indeterminate:function(){y.verbose("Setting class to indeterminate"),f.addClass(g.indeterminate),y.is.indeterminate()?y.debug("Input is already indeterminate, skipping input property change"):(y.debug("Setting state to indeterminate"),k.prop("indeterminate",!0))},determinate:function(){y.verbose("Removing indeterminate class"),f.removeClass(g.indeterminate),y.is.determinate()?y.debug("Input is already determinate, skipping input property change"):(y.debug("Setting state to determinate"),k.prop("indeterminate",!1))},disabled:function(){y.verbose("Setting class to disabled"),f.addClass(g.disabled),y.is.disabled()?y.debug("Input is already disabled, skipping input property change"):(y.debug("Setting state to disabled"),k.prop("disabled","disabled"))},enabled:function(){y.verbose("Removing disabled class"),f.removeClass(g.disabled),y.is.enabled()?y.debug("Input is already enabled, skipping input property change"):(y.debug("Setting state to enabled"),k.prop("disabled",!1))},tabbable:function(){y.verbose("Adding tabindex to checkbox"),void 0===k.attr("tabindex")&&k.attr("tabindex",0)}},remove:{initialLoad:function(){a=!1}},trigger:{change:function(){var e,n=k[0];n&&(e=E.createEvent("HTMLEvents"),y.verbose("Triggering native change event"),e.initEvent("change",!0,!1),n.dispatchEvent(e))}},create:{label:function(){0<k.prevAll(p.label).length?(k.prev(p.label).detach().insertAfter(k),y.debug("Moving existing label",o)):y.has.label()||(o=D("<label>").insertAfter(k),y.debug("Creating label",o))}},has:{label:function(){return 0<o.length}},bind:{events:function(){y.verbose("Attaching checkbox events"),f.on("click"+t,y.event.click).on("change"+t,y.event.change).on("keydown"+t,p.input,y.event.keydown).on("keyup"+t,p.input,y.event.keyup)}},unbind:{events:function(){y.debug("Removing events"),f.off(t)}},uncheckOthers:function(){var e=y.get.otherRadios();y.debug("Unchecking other radios",e),e.removeClass(g.checked)},toggle:function(){y.can.change()?y.is.indeterminate()||y.is.unchecked()?(y.debug("Currently unchecked"),y.check()):y.is.checked()&&y.can.uncheck()&&(y.debug("Currently checked"),y.uncheck()):y.is.radio()||y.debug("Checkbox is read-only or disabled, ignoring toggle")},setting:function(e,n){if(y.debug("Changing setting",e,n),D.isPlainObject(e))D.extend(!0,h,e);else{if(void 0===n)return h[e];D.isPlainObject(h[e])?D.extend(!0,h[e],n):h[e]=n}},internal:function(e,n){if(D.isPlainObject(e))D.extend(!0,y,e);else{if(void 0===n)return y[e];y[e]=n}},debug:function(){!h.silent&&h.debug&&(h.performance?y.performance.log(arguments):(y.debug=Function.prototype.bind.call(console.info,console,h.name+":"),y.debug.apply(console,arguments)))},verbose:function(){!h.silent&&h.verbose&&h.debug&&(h.performance?y.performance.log(arguments):(y.verbose=Function.prototype.bind.call(console.info,console,h.name+":"),y.verbose.apply(console,arguments)))},error:function(){h.silent||(y.error=Function.prototype.bind.call(console.error,console,h.name+":"),y.error.apply(console,arguments))},performance:{log:function(e){var n,i;h.performance&&(i=(n=Date.now())-(u||n),u=n,b.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:l,"Execution Time":i})),clearTimeout(y.performance.timer),y.performance.timer=setTimeout(function(){y.performance.display()},500)},display:function(){var e=h.name+":",i=0;u=!1,clearTimeout(y.performance.timer),D.each(b,function(e,n){i+=n["Execution Time"]}),e+=" "+i+"ms",0<b.length&&(console.groupCollapsed(e),console.table?console.table(b):D.each(b,function(e,n){console.log(n.Name+": "+n["Execution Time"]+"ms")}),console.groupEnd()),b=[]}},invoke:function(t,e,n){var o,a,i,c=d;return e=e||w,n=n||l,"string"==typeof t&&void 0!==c&&(t=t.split(/[ .]/),o=t.length-1,D.each(t,function(e,n){var i=e!==o?n+t[e+1].charAt(0).toUpperCase()+t[e+1].slice(1):t;if(D.isPlainObject(c[i])&&e!==o)c=c[i];else{if(void 0!==c[i])return a=c[i],!1;{if(!D.isPlainObject(c[n])||e===o)return void 0!==c[n]?a=c[n]:y.error(r.method,t),!1;c=c[n]}}})),O(a)?i=a.apply(n,e):void 0!==a&&(i=a),Array.isArray(s)?s.push(i):void 0!==s?s=[s,i]:void 0!==i&&(s=i),a}};x?(void 0===d&&y.initialize(),y.invoke(C)):(void 0!==d&&d.invoke("destroy"),y.initialize())}),void 0!==s?s:this},D.fn.checkbox.settings={name:"Checkbox",namespace:"checkbox",silent:!1,debug:!1,verbose:!1,performance:!0,uncheckable:"auto",fireOnInit:!1,enableEnterKey:!0,onChange:function(){},beforeChecked:function(){},beforeUnchecked:function(){},beforeDeterminate:function(){},beforeIndeterminate:function(){},onChecked:function(){},onUnchecked:function(){},onDeterminate:function(){},onIndeterminate:function(){},onEnable:function(){},onDisable:function(){},onEnabled:function(){},onDisabled:function(){},className:{checked:"checked",indeterminate:"indeterminate",disabled:"disabled",hidden:"hidden",radio:"radio",readOnly:"read-only"},error:{method:"The method you called is not defined"},selector:{checkbox:".ui.checkbox",disabled:".disabled, :has(input[disabled])",label:"label",input:'input[type="checkbox"], input[type="radio"]',link:"a[href]"}}}(jQuery,window,document);