// Generated by CoffeeScript 2.5.1
(function() {
  var HOST, apiRequest, fontello, fs, getSession, needle, open, path, process, unzip;

  fs = require('fs');

  needle = require('needle');

  open = require('open');

  path = require('path');

  process = require('process');

  unzip = require('unzipper');

  HOST = 'https://fontello.com';

  getSession = function(options, requestOptions, successCallback, errorCallback) {
    var data;
    console.log('Creating a new session'.green);
    data = {
      config: {
        file: options.config,
        content_type: 'application/json'
      }
    };
    return needle.post(options.host, data, requestOptions, function(error, response, body) {
      var sessionId, sessionUrl;
      if (error) {
        throw error;
      }
      sessionId = body;
      if (response.statusCode === 200) {
        fs.writeFile('.fontello-session', sessionId, function(err) {
          if (!err) {
            return console.log('Session was saved as .fontello-session \n'.green);
          } else {
            return console.error(err + "\n");
          }
        });
        sessionUrl = `${options.host}/${sessionId}`;
        return typeof successCallback === "function" ? successCallback(sessionUrl) : void 0;
      } else {
        return typeof errorCallback === "function" ? errorCallback(response) : void 0;
      }
    });
  };

  apiRequest = function(options, successCallback, errorCallback) {
    var requestOptions, sessionId, sessionUrl, stats, timeDiff;
    if (options.host == null) {
      options.host = HOST;
    }
    requestOptions = {
      multipart: true
    };
    if (options.proxy != null) {
      requestOptions.proxy = options.proxy;
    }
    if (fs.existsSync(".fontello-session")) {
      stats = fs.statSync(".fontello-session");
      timeDiff = Math.abs(new Date().getTime() - stats.mtime.getTime());
      if (timeDiff < (1000 * 3600 * 24)) {
        console.log('Using .fontello-session'.green);
        sessionId = fs.readFileSync('.fontello-session');
        sessionUrl = `${options.host}/${sessionId}`;
        return typeof successCallback === "function" ? successCallback(sessionUrl) : void 0;
      }
    }
    return getSession(options, requestOptions, successCallback, errorCallback);
  };

  fontello = {
    install: function(options) {
      // Begin the download

      return apiRequest(options, function(sessionUrl) {
        var requestOptions, zipFile;
        requestOptions = {
          follow: 10
        };
        if (options.proxy != null) {
          requestOptions.proxy = options.proxy;
        }
        zipFile = needle.get(`${sessionUrl}/get`, requestOptions, function(error, response, body) {
          if (error) {
            throw error;
          }
          if (response.statusCode !== 200) {
            throw "Failed. Response Code [${response.statusCode}] from ${sessionUrl}/get";
          }
        });
        // If css and font directories were provided, extract the contents of
        // the download to those directories. If not, extract the zip file as normal.

        if (options.css && options.font) {
          return zipFile.pipe(unzip.Parse()).on('entry', (function(entry) {
            var cssPath, dirName, fileName, fontPath, pathName, ref, type;
            ({
              path: pathName,
              type
            } = entry);
            if (type === 'File') {
              dirName = (ref = path.dirname(pathName).match(/\/([^\/]*)$/)) != null ? ref[1] : void 0;
              fileName = path.basename(pathName);
              switch (dirName) {
                case 'css':
                  cssPath = path.join(options.css, fileName);
                  return entry.pipe(fs.createWriteStream(cssPath));
                case 'font':
                  fontPath = path.join(options.font, fileName);
                  return entry.pipe(fs.createWriteStream(fontPath));
                default:
                  return entry.autodrain();
              }
            }
          })).on('finish', (function() {
            return console.log('Install complete.\n'.green);
          }));
        } else {
          return zipFile.pipe(unzip.Extract({
            path: process.cwd()
          })).on('finish', (function() {
            return console.log('Install complete.\n'.green);
          }));
        }
      });
    },
    open: function(options) {
      return apiRequest(options, (function(sessionUrl) {
        console.log(`Your browser should open itself, otherwise you can open the following URL manually: ${sessionUrl}\n`.green);
        return open(sessionUrl);
      }));
    }
  };

  module.exports = fontello;

}).call(this);
