;(function( win, doc ) {
	"use strict";

	var TEST_STRING = 'AxmTYklsjo190QW',
		SANS_SERIF_FONTS = 'sans-serif',
		SERIF_FONTS = 'serif',

		defaultOptions = {
			tolerance: 2, // px
			// TODO change back to 100
			delay: 500,
			weight: [ 400 ], // 100-900
			glyphs: '',
			success: function() {},
			error: function() {},
			timeout: 5000
		},

		// See https://github.com/typekit/webfontloader/blob/master/src/core/fontruler.js#L41
		style = [
			'display:block',
			'position:absolute',
			'top:0',
			'left:0',
			'font-size:48px',
			'width:auto',
			'height:auto',
			'line-height:normal',
			'margin:0',
			'padding:0',
			'font-variant:normal',
			'white-space:nowrap'
		],
		html = '<div style="%s">' + TEST_STRING + '</div>';

	var FontFaceOnloadInstance = function() {
		this.fontFamily = '';
		this.appended = false;
		this.serif = undefined;
		this.sansSerif = undefined;
		this.parent = undefined;
		this.options = {};
		this.weights = {};
		this.weightCount = 0;
	};

	FontFaceOnloadInstance.prototype.getMeasurements = function () {
		return {
			sansSerif: {
				width: this.sansSerif.offsetWidth,
				height: this.sansSerif.offsetHeight
			},
			serif: {
				width: this.serif.offsetWidth,
				height: this.serif.offsetHeight
			}
		};
	};

	FontFaceOnloadInstance.prototype.load = function () {
		var startTime = new Date(),
			that = this,
			serif = that.serif,
			sansSerif = that.sansSerif,
			parent = that.parent,
			appended = that.appended,
			dimensions,
			options = this.options,
			ref = options.reference;

		var sansSerifHtml = html.replace( /\%s/, style.concat( "font-family:" + SANS_SERIF_FONTS ).join( ";" ) ),
			serifHtml = html.replace( /\%s/, style.concat( "font-family:" + SERIF_FONTS ).join( ";" ) );

		if( !parent ) {
			parent = that.parent = doc.createElement( "div" );
		}

		parent.innerHTML = sansSerifHtml + serifHtml;
		sansSerif = that.sansSerif = parent.firstChild;
		serif = that.serif = sansSerif.nextSibling;

		if( options.glyphs ) {
			sansSerif.innerHTML += options.glyphs;
			serif.innerHTML += options.glyphs;
		}

		function hasNewDimensions( dims, el, tolerance ) {
			return Math.abs( dims.width - el.offsetWidth ) > tolerance ||
					Math.abs( dims.height - el.offsetHeight ) > tolerance;
		}

		function checkWeights() {
			var j,
				loadedCount = 0;

			// short circuit if only one weight, we already know the dimensions changed.
			// if( that.weightCount === 1 ) {
			// 	options.success( that.weights[ 0 ] );
			// 	return;
			// }

			sansSerif.style.fontWeight = serif.style.fontWeight = defaultOptions.weight[ 0 ];
			dimensions = that.getMeasurements();
console.log( that.weights );
			for( j in that.weights ) {
				sansSerif.style.fontWeight = serif.style.fontWeight = j;

console.log( 'after weight', j, dimensions.sansSerif.width, that.getMeasurements().sansSerif.width, dimensions.serif.width, that.getMeasurements().serif.width );
				if( hasNewDimensions( dimensions.sansSerif, sansSerif, 0 ) ||
						hasNewDimensions( dimensions.serif, serif, 0 ) ||
						+j === defaultOptions.weight[ 0 ] ) {

					loadedCount++;
				}
			}
console.log( loadedCount, that.weightCount );

			if( loadedCount === that.weightCount ) {
				for( j in that.weights ) {
					options.success( +j );
				}
				// ref.removeChild( parent );
			} else {
				setTimeout(function() {
					checkWeights();
				}, options.delay );
			}
		}

		(function checkDimensions() {
			if( !ref ) {
				ref = doc.body;
			}
			if( !appended && ref ) {
				ref.appendChild( parent );
				appended = that.appended = true;

				dimensions = that.getMeasurements();

				// Make sure we set the new font-family after we take our initial dimensions:
				// handles the case where FontFaceOnload is called after the font has already
				// loaded.
				sansSerif.style.fontFamily = that.fontFamily + ', ' + SANS_SERIF_FONTS;
				serif.style.fontFamily = that.fontFamily + ', ' + SERIF_FONTS;
			}

			if( appended && dimensions &&
				( hasNewDimensions( dimensions.sansSerif, sansSerif, options.tolerance ) ||
					hasNewDimensions( dimensions.serif, serif, options.tolerance ) ) ) {

				checkWeights();
			} else if( ( new Date() ).getTime() - startTime.getTime() > options.timeout ) {
				options.error();
			} else {
				if( !appended && "requestAnimationFrame" in window ) {
					win.requestAnimationFrame( checkDimensions );
				} else {
					win.setTimeout( checkDimensions, options.delay );
				}
			}
		})();
	}; // end load()

	FontFaceOnloadInstance.prototype.checkFontFaces = function( timeout ) {
		var _t = this,
			checkCount = 0;

		doc.fonts.forEach(function( font ) {
			if( font.family.toLowerCase() === _t.fontFamily.toLowerCase() &&
				this.weights[ ''+font.weight ] ) {
				checkCount++;
				font.load().then(function() {
					_t.options.success( font.weight );
					win.clearTimeout( timeout );
				});
			}
		});

		if( checkCount !== _t.options.weight.length ) {
			win.setTimeout(function() {
				_t.checkFontFaces( timeout );
			}, _t.options.delay );
		}
	};

	FontFaceOnloadInstance.prototype.initWeights = function() {
		var weights = this.options.weight;
		// this.weights[ defaultOptions.weight[ 0 ] ] = true;
		// this.weightCount = 1;

		for( var j = 0, k = weights.length; j < k; j++ ) {
			if( !this.weights[ '' + weights[ j ] ] ) {
				this.weights[ '' + weights[ j ] ] = true;
				this.weightCount++;
			}
		}
	};

	FontFaceOnloadInstance.prototype.init = function( fontFamily, options ) {
		var timeout;

		for( var j in defaultOptions ) {
			if( !options.hasOwnProperty( j ) ) {
				options[ j ] = defaultOptions[ j ];
			}
		}

		this.options = options;
		this.fontFamily = fontFamily;

		this.initWeights();

		// For some reason this was failing on afontgarde + icon fonts.
		if( !options.glyphs && "fonts" in doc ) {
			if( options.timeout ) {
				timeout = win.setTimeout(function() {
					options.error();
				}, options.timeout );
			}

			this.checkFontFaces( timeout );
		} else {
			this.load();
		}
	};

	var FontFaceOnload = function( fontFamily, options ) {
		var instance = new FontFaceOnloadInstance();
		instance.init(fontFamily, options);

		return instance;
	};

	// intentional global
	win.FontFaceOnload = FontFaceOnload;
})( this, this.document );
