/*!
 * form-create 可视化表单设计器
 * @form-create/designer v1.0.2
 * (c) 2021-2021 xaboy
 * Github https://github.com/xaboy/form-create-designer
 * Released under the MIT License.
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('vue'), require('@form-create/element-ui')) :
  typeof define === 'function' && define.amd ? define(['vue', '@form-create/element-ui'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.FcDesigner = factory(global.Vue, global.formCreate));
}(this, (function (Vue, formCreate) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var Vue__default = /*#__PURE__*/_interopDefaultLegacy(Vue);
  var formCreate__default = /*#__PURE__*/_interopDefaultLegacy(formCreate);

  function _defineProperty$1(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty$1(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _toConsumableArray$1(arr) {
    return _arrayWithoutHoles$1(arr) || _iterableToArray$1(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread$1();
  }

  function _arrayWithoutHoles$1(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray$1(iter) {
    if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread$1() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function form() {
    return [{
      type: 'radio',
      field: 'labelPosition',
      value: 'left',
      title: '标签位置',
      options: [{
        value: 'right',
        label: 'right'
      }, {
        value: 'left',
        label: 'left'
      }, {
        value: 'top',
        label: 'top'
      }]
    }, {
      type: 'radio',
      field: 'size',
      value: 'mini',
      title: '标签位置',
      options: [{
        value: 'medium',
        label: 'medium'
      }, {
        value: 'small',
        label: 'small'
      }, {
        value: 'mini',
        label: 'mini'
      }]
    }, {
      type: 'input',
      field: 'labelWidth',
      value: '125px',
      title: '标签宽度'
    }, {
      type: 'switch',
      field: 'hideRequiredAsterisk',
      value: false,
      title: '隐藏必填字段的标签旁边的红色星号'
    }, {
      type: 'switch',
      field: 'showMessage',
      value: true,
      title: '显示校验错误信息'
    }, {
      type: 'switch',
      field: 'inlineMessage',
      value: false,
      title: '以行内形式展示校验信息'
    }];
  }

  function field() {
    return [{
      type: 'input',
      field: 'field',
      value: '',
      title: '字段 ID'
    }, {
      type: 'input',
      field: 'title',
      value: '',
      title: '字段名称'
    }, {
      type: 'input',
      field: 'info',
      value: '',
      title: '提示信息'
    }, {
      type: 'Struct',
      field: '_control',
      value: [],
      title: '联动数据',
      props: {
        defaultValue: [],
        validate: function validate(val) {
          if (!Array.isArray(val)) { return false; }
          if (!val.length) { return true; }
          return !val.some(function (_ref) {
            var rule = _ref.rule;
            return !Array.isArray(rule);
          });
        }
      }
    }, {
      type: 'col',
      props: {
        span: 24
      },
      children: [{
        type: 'el-button',
        props: {
          type: 'primary',
          size: 'mini',
          icon: 'el-icon-delete'
        },
        inject: true,
        on: {
          click: function click(_ref2) {
            var $f = _ref2.$f;
            var rule = $f.activeRule;

            if (rule) {
              rule.__fc__.updateKey();

              rule.value = undefined;

              rule.__fc__.$api.sync(rule);
            }
          }
        },
        "native": true,
        children: ['清空值']
      }, {
        type: 'el-button',
        props: {
          type: 'success',
          size: 'mini',
          icon: 'el-icon-refresh'
        },
        inject: true,
        on: {
          click: function click(_ref3) {
            var $f = _ref3.$f;
            var rule = $f.activeRule;

            if (rule) {
              rule.__fc__.updateKey(true);

              rule.__fc__.$api.sync(rule);
            }
          }
        },
        "native": true,
        children: ['刷新']
      }]
    }];
  }

  function validate() {
    return [{
      type: 'validate',
      field: 'validate',
      value: []
    }];
  }

  function $set(target, field, value) {
      Vue__default['default'].set(target, field, value);
  }

  var is = {
      type: function type(arg, type$1) {
          return Object.prototype.toString.call(arg) === '[object ' + type$1 + ']'
      },
      Undef: function Undef(v) {
          return v === undefined || v === null
      },
      Element: function Element(arg) {
          return typeof arg === 'object' && arg !== null && arg.nodeType === 1 && !is.Object(arg)
      },
      trueArray: function trueArray(data) {
          return Array.isArray(data) && data.length > 0;
      }
  };

  ['Date', 'Object', 'Function', 'String', 'Boolean', ' Array', 'Number'].forEach(function (t) {
      is[t] = function (arg) {
          return is.type(arg, t);
      };
  });

  function deepExtend(origin, target, mode) {
      if ( target === void 0 ) target = {};

      var isArr = false;
      for (var key in target) {
          if (Object.prototype.hasOwnProperty.call(target, key)) {
              var clone = target[key];
              if ((isArr = Array.isArray(clone)) || is.Object(clone)) {
                  var nst = origin[key] === undefined;
                  if (isArr) {
                      isArr = false;
                      nst && $set(origin, key, []);
                  } else if (clone._clone && mode !== undefined) {
                      if (mode) {
                          clone = clone.getRule();
                          nst && $set(origin, key, {});
                      } else {
                          $set(origin, key, clone._clone());
                          continue;
                      }
                  } else {
                      nst && $set(origin, key, {});
                  }
                  origin[key] = deepExtend(origin[key], clone, mode);
              } else {
                  $set(origin, key, clone);
              }
          }
      }
      return (mode !== undefined && Array.isArray(origin)) ? origin.filter(function (v) { return !v || !v.__ctrl; }) : origin
  }

  function deepCopy(value) {
      return deepExtend({}, {value: value}).value;
  }

  function lower(str) {
      return str.replace(str[0], str[0].toLowerCase());
  }

  var id$1 = 0;

  function uniqueId() {
      return Math.random().toString(36).substr(3, 3) + Number(("" + (Date.now()) + (++id$1))).toString(36);
  }

  function makeOptionsRule(to) {
    return {
      type: 'radio',
      title: '选项数据',
      field: '_optionType',
      value: 0,
      options: [{
        'label': '静态数据',
        'value': 0
      }, {
        'label': '接口数据',
        'value': 1
      }],
      props: {
        type: 'button'
      },
      control: [{
        value: 0,
        rule: [{
          type: 'Struct',
          field: 'formCreate' + upper(to).replace('.', '>'),
          props: {
            defaultValue: []
          }
        }]
      }, {
        value: 1,
        rule: [{
          type: 'Fetch',
          field: 'formCreateEffect>fetch',
          props: {
            to: to
          }
        }]
      }]
    };
  }
  function upper(str) {
    return str.replace(str[0], str[0].toLocaleUpperCase());
  }

  var label$n = '单选框';
  var name$o = 'radio';
  var radio = {
    icon: 'icon-radio',
    label: label$n,
    name: name$o,
    rule: function rule() {
      return {
        type: name$o,
        field: uniqueId(),
        title: label$n,
        info: '',
        effect: {
          fetch: ''
        },
        props: {},
        options: [{
          value: '1',
          label: '选项1'
        }, {
          value: '2',
          label: '选项2'
        }]
      };
    },
    props: function props() {
      return [makeOptionsRule('options'), {
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }, {
        type: 'switch',
        field: 'type',
        title: '按钮形式',
        props: {
          activeValue: 'button',
          inactiveValue: 'default'
        }
      }, {
        type: 'input',
        field: 'textColor',
        title: '按钮形式的 Radio 激活时的文本颜色'
      }, {
        type: 'input',
        field: 'fill',
        title: '按钮形式的 Radio 激活时的填充色和边框色'
      }];
    }
  };

  var label$m = '多选框';
  var name$n = 'checkbox';
  var checkbox = {
    icon: 'icon-checkbox',
    label: label$m,
    name: name$n,
    rule: function rule() {
      return {
        type: name$n,
        field: uniqueId(),
        title: label$m,
        info: '',
        effect: {
          fetch: ''
        },
        props: {},
        options: [{
          value: '1',
          label: '选项1'
        }, {
          value: '2',
          label: '选项2'
        }]
      };
    },
    props: function props() {
      return [makeOptionsRule('options'), {
        type: 'switch',
        field: 'type',
        title: '按钮类型',
        props: {
          activeValue: 'button',
          inactiveValue: 'default'
        }
      }, {
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }, {
        type: 'inputNumber',
        field: 'min',
        title: '可被勾选的 checkbox 的最小数量'
      }, {
        type: 'inputNumber',
        field: 'max',
        title: '可被勾选的 checkbox 的最大数量'
      }, {
        type: 'input',
        field: 'textColor',
        title: '按钮形式的 Checkbox 激活时的文本颜色'
      }, {
        type: 'input',
        field: 'fill',
        title: '按钮形式的 Checkbox 激活时的填充色和边框色'
      }];
    }
  };

  var label$l = '输入框';
  var name$m = 'input';
  var input = {
    icon: 'icon-input',
    label: label$l,
    name: name$m,
    rule: function rule() {
      return {
        type: name$m,
        field: uniqueId(),
        title: label$l,
        info: '',
        props: {}
      };
    },
    props: function props() {
      return [{
        type: 'select',
        field: 'type',
        title: '类型',
        options: [{
          label: 'text',
          value: 'text'
        }, {
          label: 'textarea',
          value: 'textarea'
        }, {
          label: 'number',
          value: 'number'
        }, {
          label: 'password',
          value: 'password'
        }]
      }, {
        type: 'inputNumber',
        field: 'maxlength',
        title: '最大输入长度'
      }, {
        type: 'inputNumber',
        field: 'minlength',
        title: '最小输入长度'
      }, {
        type: 'switch',
        field: 'showWordLimit',
        title: '是否显示输入字数统计'
      }, {
        type: 'input',
        field: 'placeholder',
        title: '输入框占位文本'
      }, {
        type: 'switch',
        field: 'clearable',
        title: '是否可清空'
      }, {
        type: 'switch',
        field: 'showPassword',
        title: '是否显示切换密码图标'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '禁用'
      }, {
        type: 'input',
        field: 'prefixIcon',
        title: '输入框头部图标'
      }, {
        type: 'input',
        field: 'suffixIcon',
        title: '输入框尾部图标'
      }, {
        type: 'inputNumber',
        field: 'rows',
        info: '只对 type="textarea" 有效',
        title: '输入框行数'
      }, {
        type: 'select',
        field: 'autocomplete',
        title: '自动补全',
        options: [{
          label: 'on',
          value: 'on'
        }, {
          label: 'off',
          value: 'off'
        }]
      }, {
        type: 'switch',
        field: 'readonly',
        title: '是否只读'
      }, {
        type: 'select',
        field: 'resize',
        title: '控制是否能被用户缩放',
        options: [{
          label: 'none',
          value: 'none'
        }, {
          label: 'both',
          value: 'both'
        }, {
          label: 'horizontal',
          value: 'horizontal'
        }, {
          label: 'vertical',
          value: 'vertical'
        }]
      }, {
        type: 'switch',
        field: 'autofocus',
        title: '自动获取焦点'
      }];
    }
  };

  var label$k = '计数器';
  var name$l = 'inputNumber';
  var number = {
    icon: 'icon-number',
    label: label$k,
    name: name$l,
    rule: function rule() {
      return {
        type: name$l,
        field: uniqueId(),
        title: label$k,
        info: '',
        props: {}
      };
    },
    props: function props() {
      return [{
        type: 'inputNumber',
        field: 'min',
        title: '设置计数器允许的最小值'
      }, {
        type: 'inputNumber',
        field: 'max',
        title: '设置计数器允许的最大值'
      }, {
        type: 'inputNumber',
        field: 'step',
        title: '计数器步长'
      }, {
        type: 'switch',
        field: 'stepStrictly',
        title: '是否只能输入 step 的倍数'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '是否禁用计数器'
      }, {
        type: 'switch',
        field: 'controls',
        title: '是否使用控制按钮',
        value: true
      }, {
        type: 'select',
        field: 'controlsPosition',
        title: '控制按钮位置',
        options: [{
          label: 'default',
          value: 'default'
        }, {
          label: 'right',
          value: 'right'
        }]
      }, {
        type: 'input',
        field: 'placeholder',
        title: '输入框默认 placeholder'
      }];
    }
  };

  var label$j = '选择器';
  var name$k = 'select';
  var select = {
    icon: 'icon-select',
    label: label$j,
    name: name$k,
    rule: function rule() {
      return {
        type: name$k,
        field: uniqueId(),
        title: label$j,
        info: '',
        effect: {
          fetch: ''
        },
        props: {},
        options: [{
          value: '1',
          label: '选项1'
        }, {
          value: '2',
          label: '选项2'
        }]
      };
    },
    props: function props() {
      return [makeOptionsRule('options'), {
        type: 'switch',
        field: 'multiple',
        title: '是否多选'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }, {
        type: 'switch',
        field: 'clearable',
        title: '是否可以清空选项'
      }, {
        type: 'switch',
        field: 'collapseTags',
        title: '多选时是否将选中值按文字的形式展示'
      }, {
        type: 'inputNumber',
        field: 'multipleLimit',
        title: '多选时用户最多可以选择的项目数，为 0 则不限制'
      }, {
        type: 'input',
        field: 'autocomplete',
        title: 'autocomplete 属性'
      }, {
        type: 'input',
        field: 'placeholder',
        title: '占位符'
      }, {
        type: 'switch',
        field: 'filterable',
        title: '是否可搜索'
      }, {
        type: 'switch',
        field: 'allowCreate',
        title: '是否允许用户创建新条目'
      }, {
        type: 'input',
        field: 'noMatchText',
        title: '搜索条件无匹配时显示的文字'
      }, {
        type: 'input',
        field: 'noDataText',
        title: '选项为空时显示的文字'
      }, {
        type: 'switch',
        field: 'reserveKeyword',
        title: '多选且可搜索时，是否在选中一个选项后保留当前的搜索关键词'
      }, {
        type: 'switch',
        field: 'defaultFirstOption',
        title: '在输入框按下回车，选择第一个匹配项'
      }, {
        type: 'switch',
        field: 'popperAppendToBody',
        title: '是否将弹出框插入至 body 元素',
        value: true
      }, {
        type: 'switch',
        field: 'automaticDropdown',
        title: '对于不可搜索的 Select，是否在输入框获得焦点后自动弹出选项菜单'
      }];
    }
  };

  var label$i = '开关';
  var name$j = 'switch';
  var _switch = {
    icon: 'icon-switch',
    label: label$i,
    name: name$j,
    rule: function rule() {
      return {
        type: name$j,
        field: uniqueId(),
        title: label$i,
        info: '',
        props: {}
      };
    },
    props: function props() {
      return [{
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }, {
        type: 'inputNumber',
        field: 'width',
        title: '宽度（px）'
      }, {
        type: 'input',
        field: 'activeText',
        title: 'switch 打开时的文字描述'
      }, {
        type: 'input',
        field: 'inactiveText',
        title: 'switch 关闭时的文字描述'
      }, {
        type: 'input',
        field: 'activeValue',
        title: 'switch 打开时的值'
      }, {
        type: 'input',
        field: 'inactiveValue',
        title: 'switch 关闭时的值'
      }, {
        type: 'input',
        field: 'activeColor',
        title: 'switch 打开时的背景色'
      }, {
        type: 'input',
        field: 'inactiveColor',
        title: 'switch 关闭时的背景色'
      }];
    }
  };

  var label$h = '滑块';
  var name$i = 'slider';
  var slider = {
    icon: 'icon-slider',
    label: label$h,
    name: name$i,
    rule: function rule() {
      return {
        type: name$i,
        field: uniqueId(),
        title: label$h,
        info: '',
        props: {}
      };
    },
    props: function props() {
      return [{
        type: 'inputNumber',
        field: 'min',
        title: '最小值'
      }, {
        type: 'inputNumber',
        field: 'max',
        title: '最大值'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }, {
        type: 'inputNumber',
        field: 'step',
        title: '步长'
      }, {
        type: 'switch',
        field: 'showInput',
        title: '是否显示输入框，仅在非范围选择时有效'
      }, {
        type: 'switch',
        field: 'showInputControls',
        title: '在显示输入框的情况下，是否显示输入框的控制按钮',
        value: true
      }, {
        type: 'switch',
        field: 'showStops',
        title: '是否显示间断点'
      }, {
        type: 'switch',
        field: 'range',
        title: '是否为范围选择'
      }, {
        type: 'switch',
        field: 'vertical',
        title: '是否竖向模式'
      }, {
        type: 'input',
        field: 'height',
        title: 'Slider 高度，竖向模式时必填'
      }];
    }
  };

  var label$g = '时间选择器';
  var name$h = 'timePicker';
  var time = {
    icon: 'icon-time',
    label: label$g,
    name: name$h,
    rule: function rule() {
      return {
        type: name$h,
        field: uniqueId(),
        title: label$g,
        info: '',
        props: {}
      };
    },
    props: function props() {
      return [{
        type: 'Struct',
        field: 'pickerOptions',
        title: '当前时间日期选择器特有的选项',
        props: {
          defaultValue: {}
        }
      }, {
        type: 'switch',
        field: 'readonly',
        title: '完全只读'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '禁用'
      }, {
        type: 'switch',
        field: 'editable',
        title: '文本框可输入',
        value: true
      }, {
        type: 'switch',
        field: 'clearable',
        title: '是否显示清除按钮',
        value: true
      }, {
        type: 'input',
        field: 'placeholder',
        title: '非范围选择时的占位内容'
      }, {
        type: 'input',
        field: 'startPlaceholder',
        title: '范围选择时开始日期的占位内容'
      }, {
        type: 'input',
        field: 'endPlaceholder',
        title: '范围选择时开始日期的占位内容'
      }, {
        type: 'switch',
        field: 'isRange',
        title: '是否为时间范围选择'
      }, {
        type: 'switch',
        field: 'arrowControl',
        title: '是否使用箭头进行时间选择'
      }, {
        type: 'select',
        field: 'align',
        title: '对齐方式',
        options: [{
          label: 'left',
          value: 'left'
        }, {
          label: 'center',
          value: 'center'
        }, {
          label: 'right',
          value: 'right'
        }]
      }, {
        type: 'input',
        field: 'prefixIcon',
        title: '自定义头部图标的类名'
      }, {
        type: 'input',
        field: 'clearIcon',
        title: '自定义清空图标的类名'
      }];
    }
  };

  var label$f = '日期选择器';
  var name$g = 'datePicker';
  var date = {
    icon: 'icon-date',
    label: label$f,
    name: name$g,
    rule: function rule() {
      return {
        type: name$g,
        field: uniqueId(),
        title: label$f,
        info: '',
        props: {}
      };
    },
    props: function props() {
      return [{
        type: 'Struct',
        field: 'pickerOptions',
        title: '当前时间日期选择器特有的选项',
        props: {
          defaultValue: {}
        }
      }, {
        type: 'switch',
        field: 'readonly',
        title: '完全只读'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '禁用'
      }, {
        type: 'select',
        field: 'type',
        title: '显示类型',
        options: [{
          label: 'year',
          value: 'year'
        }, {
          label: 'month',
          value: 'month'
        }, {
          label: 'date',
          value: 'date'
        }, {
          label: 'dates',
          value: 'dates'
        }, {
          label: 'week',
          value: 'week'
        }, {
          label: 'datetime',
          value: 'datetime'
        }, {
          label: 'datetimerange',
          value: 'datetimerange'
        }, {
          label: 'daterange',
          value: 'daterange'
        }, {
          label: 'monthrange',
          value: 'monthrange'
        }]
      }, {
        type: 'switch',
        field: 'editable',
        title: '文本框可输入',
        value: true
      }, {
        type: 'switch',
        field: 'clearable',
        title: '是否显示清除按钮',
        value: true
      }, {
        type: 'input',
        field: 'placeholder',
        title: '非范围选择时的占位内容'
      }, {
        type: 'input',
        field: 'startPlaceholder',
        title: '范围选择时开始日期的占位内容'
      }, {
        type: 'input',
        field: 'endPlaceholder',
        title: '范围选择时结束日期的占位内容'
      }, {
        type: 'input',
        field: 'format',
        title: '显示在输入框中的格式'
      }, {
        type: 'select',
        field: 'align',
        title: '对齐方式',
        options: [{
          label: 'left',
          value: 'left'
        }, {
          label: 'center',
          value: 'center'
        }, {
          label: 'right',
          value: 'right'
        }, {
          label: 'left',
          value: 'left'
        }]
      }, {
        type: 'input',
        field: 'rangeSeparator',
        title: '选择范围时的分隔符'
      }, {
        type: 'switch',
        field: 'unlinkPanels',
        title: '在范围选择器里取消两个日期面板之间的联动'
      }, {
        type: 'input',
        field: 'prefixIcon',
        title: '自定义头部图标的类名'
      }, {
        type: 'input',
        field: 'clearIcon',
        title: '自定义清空图标的类名'
      }];
    }
  };

  var label$e = '评分';
  var name$f = 'rate';
  var rate = {
    icon: 'icon-rate',
    label: label$e,
    name: name$f,
    rule: function rule() {
      return {
        type: name$f,
        field: uniqueId(),
        title: label$e,
        info: '',
        props: {}
      };
    },
    props: function props() {
      return [{
        type: 'inputNumber',
        field: 'max',
        title: '最大分值'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '是否为只读'
      }, {
        type: 'switch',
        field: 'allowHalf',
        title: '是否允许半选'
      }, {
        type: 'input',
        field: 'voidColor',
        title: '未选中 icon 的颜色'
      }, {
        type: 'input',
        field: 'disabledVoidColor',
        title: '只读时未选中 icon 的颜色'
      }, {
        type: 'input',
        field: 'voidIconClass',
        title: '未选中 icon 的类名'
      }, {
        type: 'input',
        field: 'disabledVoidIconClass',
        title: '只读时未选中 icon 的类名'
      }, {
        type: 'switch',
        field: 'showScore',
        title: '是否显示当前分数，show-score 和 show-text 不能同时为真'
      }, {
        type: 'input',
        field: 'textColor',
        title: '辅助文字的颜色'
      }, {
        type: 'input',
        field: 'scoreTemplate',
        title: '分数显示模板'
      }];
    }
  };

  var label$d = '颜色选择器';
  var name$e = 'colorPicker';
  var color = {
    icon: 'icon-color',
    label: label$d,
    name: name$e,
    rule: function rule() {
      return {
        type: name$e,
        field: uniqueId(),
        title: label$d,
        info: '',
        props: {}
      };
    },
    props: function props() {
      return [{
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }, {
        type: 'switch',
        field: 'showAlpha',
        title: '是否支持透明度选择'
      }, {
        type: 'select',
        field: 'colorFormat',
        title: '颜色的格式',
        options: [{
          label: 'hsl',
          value: 'hsl'
        }, {
          label: 'hsv',
          value: 'hsv'
        }, {
          label: 'hex',
          value: 'hex'
        }, {
          label: 'rgb',
          value: 'rgb'
        }]
      }];
    }
  };

  var label$c = '栅格布局';
  var name$d = 'row';
  var row = {
    icon: 'icon-row',
    label: label$c,
    name: name$d,
    rule: function rule() {
      return {
        type: 'FcRow',
        props: {},
        children: []
      };
    },
    children: 'col',
    props: function props() {
      return [{
        type: 'inputNumber',
        field: 'gutter',
        title: '栅格间隔'
      }, {
        type: 'switch',
        field: 'type',
        title: 'flex布局模式',
        props: {
          activeValue: 'flex',
          inactiveValue: 'default'
        }
      }, {
        type: 'select',
        field: 'justify',
        title: 'flex 布局下的水平排列方式',
        options: [{
          label: 'start',
          value: 'start'
        }, {
          label: 'end',
          value: 'end'
        }, {
          label: 'center',
          value: 'center'
        }, {
          label: 'space-around',
          value: 'space-around'
        }, {
          label: 'space-between',
          value: 'space-between'
        }]
      }, {
        type: 'select',
        field: 'align',
        title: 'flex 布局下的垂直排列方式',
        options: [{
          label: 'top',
          value: 'top'
        }, {
          label: 'middle',
          value: 'middle'
        }, {
          label: 'bottom',
          value: 'bottom'
        }]
      }];
    }
  };

  var name$c = 'col';
  var col = {
    name: name$c,
    drag: true,
    dragBtn: false,
    inside: true,
    rule: function rule() {
      return {
        type: name$c,
        props: {
          span: 12
        },
        children: []
      };
    },
    props: function props() {
      return [{
        type: 'slider',
        field: 'span',
        title: '栅格占据的列数',
        value: 12,
        props: {
          min: 0,
          max: 24
        }
      }, {
        type: 'slider',
        field: 'offset',
        title: '栅格左侧的间隔格数',
        props: {
          min: 0,
          max: 24
        }
      }, {
        type: 'slider',
        field: 'push',
        title: '栅格向右移动格数',
        props: {
          min: 0,
          max: 24
        }
      }, {
        type: 'slider',
        field: 'pull',
        title: '栅格向左移动格数',
        props: {
          min: 0,
          max: 24
        }
      }];
    }
  };

  var label$b = '标签页';
  var name$b = 'tab-pane';
  var tabPane = {
    label: label$b,
    name: name$b,
    inside: true,
    drag: true,
    dragBtn: false,
    rule: function rule() {
      return {
        type: 'el-tab-pane',
        props: {
          label: '新标签页'
        },
        children: []
      };
    },
    props: function props() {
      return [{
        type: 'input',
        field: 'label',
        title: '选项卡标题'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }, {
        type: 'input',
        field: 'name',
        title: '与选项卡绑定值 value 对应的标识符，表示选项卡别名'
      }, {
        type: 'switch',
        field: 'lazy',
        title: '标签是否延迟渲染'
      }];
    }
  };

  var label$a = '分割线';
  var name$a = 'el-divider';
  var divider = {
    icon: 'icon-divider',
    label: label$a,
    name: name$a,
    rule: function rule() {
      return {
        type: name$a,
        props: {},
        wrap: {
          show: false
        },
        "native": false,
        children: ['']
      };
    },
    props: function props() {
      return [{
        type: 'select',
        field: 'direction',
        title: '设置分割线方向',
        options: [{
          label: 'horizontal',
          value: 'horizontal'
        }, {
          label: 'vertical',
          value: 'vertical'
        }]
      }, {
        type: 'input',
        field: 'formCreateChild',
        title: '设置分割线文案'
      }, {
        type: 'select',
        field: 'contentPosition',
        title: '设置分割线文案的位置',
        options: [{
          label: 'left',
          value: 'left'
        }, {
          label: 'right',
          value: 'right'
        }, {
          label: 'center',
          value: 'center'
        }]
      }];
    }
  };

  var label$9 = '级联选择器';
  var name$9 = 'cascader';
  var cascader = {
    icon: 'icon-cascader',
    label: label$9,
    name: name$9,
    rule: function rule() {
      return {
        type: name$9,
        field: uniqueId(),
        title: label$9,
        info: '',
        effect: {
          fetch: ''
        },
        props: {
          options: [{
            value: 'zhinan',
            label: '指南',
            children: [{
              value: 'shejiyuanze',
              label: '设计原则',
              children: [{
                value: 'yizhi',
                label: '一致'
              }, {
                value: 'fankui',
                label: '反馈'
              }, {
                value: 'xiaolv',
                label: '效率'
              }, {
                value: 'kekong',
                label: '可控'
              }]
            }, {
              value: 'daohang',
              label: '导航',
              children: [{
                value: 'cexiangdaohang',
                label: '侧向导航'
              }, {
                value: 'dingbudaohang',
                label: '顶部导航'
              }]
            }]
          }, {
            value: 'zujian',
            label: '组件',
            children: [{
              value: 'basic',
              label: 'Basic',
              children: [{
                value: 'layout',
                label: 'Layout 布局'
              }, {
                value: 'color',
                label: 'Color 色彩'
              }, {
                value: 'typography',
                label: 'Typography 字体'
              }, {
                value: 'icon',
                label: 'Icon 图标'
              }, {
                value: 'button',
                label: 'Button 按钮'
              }]
            }, {
              value: 'form',
              label: 'Form',
              children: [{
                value: 'radio',
                label: 'Radio 单选框'
              }, {
                value: 'checkbox',
                label: 'Checkbox 多选框'
              }, {
                value: 'input',
                label: 'Input 输入框'
              }, {
                value: 'input-number',
                label: 'InputNumber 计数器'
              }, {
                value: 'select',
                label: 'Select 选择器'
              }, {
                value: 'cascader',
                label: 'Cascader 级联选择器'
              }, {
                value: 'switch',
                label: 'Switch 开关'
              }, {
                value: 'slider',
                label: 'Slider 滑块'
              }, {
                value: 'time-picker',
                label: 'TimePicker 时间选择器'
              }, {
                value: 'date-picker',
                label: 'DatePicker 日期选择器'
              }, {
                value: 'datetime-picker',
                label: 'DateTimePicker 日期时间选择器'
              }, {
                value: 'upload',
                label: 'Upload 上传'
              }, {
                value: 'rate',
                label: 'Rate 评分'
              }, {
                value: 'form',
                label: 'Form 表单'
              }]
            }]
          }]
        }
      };
    },
    props: function props() {
      return [makeOptionsRule('props.options'), {
        type: 'Object',
        field: 'props',
        title: '配置选项',
        props: {
          rule: [{
            type: 'select',
            field: 'expandTrigger',
            title: '次级菜单的展开方式',
            options: [{
              label: 'click',
              value: 'click'
            }, {
              label: 'hover',
              value: 'hover'
            }]
          }, {
            type: 'switch',
            field: 'multiple',
            title: '是否多选'
          }, {
            type: 'switch',
            field: 'checkStrictly',
            title: '是否严格的遵守父子节点不互相关联'
          }, {
            type: 'switch',
            field: 'emitPath',
            title: '在选中节点改变时，是否返回由该节点所在的各级菜单的值所组成的数组，若设置 false，则只返回该节点的值',
            value: true
          }, {
            type: 'input',
            field: 'value',
            title: '指定选项的值为选项对象的某个属性值'
          }, {
            type: 'input',
            field: 'label',
            title: '指定选项标签为选项对象的某个属性值'
          }, {
            type: 'input',
            field: 'children',
            title: '指定选项的子选项为选项对象的某个属性值'
          }, {
            type: 'input',
            field: 'disabled',
            title: '指定选项的禁用为选项对象的某个属性值'
          }, {
            type: 'input',
            field: 'leaf',
            title: '指定选项的叶子节点的标志位为选项对象的某个属性值'
          }]
        }
      }, {
        type: 'select',
        field: 'size',
        title: '尺寸',
        options: [{
          label: 'medium',
          value: 'medium'
        }, {
          label: 'small',
          value: 'small'
        }, {
          label: 'mini',
          value: 'mini'
        }]
      }, {
        type: 'input',
        field: 'placeholder',
        title: '输入框占位文本'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }, {
        type: 'switch',
        field: 'clearable',
        title: '是否支持清空选项'
      }, {
        type: 'switch',
        field: 'showAllLevels',
        title: '输入框中是否显示选中值的完整路径',
        value: true
      }, {
        type: 'switch',
        field: 'collapseTags',
        title: '多选模式下是否折叠Tag'
      }, {
        type: 'input',
        field: 'separator',
        title: '选项分隔符'
      }];
    }
  };

  var label$8 = '上传';
  var name$8 = 'upload';
  var upload = {
    icon: 'icon-upload',
    label: label$8,
    name: name$8,
    rule: function rule() {
      return {
        type: name$8,
        field: uniqueId(),
        title: label$8,
        info: '',
        props: {
          action: '',
          onSuccess: function onSuccess(res, file) {
            file.url = res.data.url;
          }
        }
      };
    },
    props: function props() {
      return [{
        type: 'select',
        field: 'uploadType',
        title: '上传类型',
        value: 'image',
        options: [{
          label: '图片',
          value: 'image'
        }, {
          label: '文件',
          value: 'file'
        }]
      }, {
        type: 'input',
        field: 'action',
        title: '上传的地址(必填)'
      }, {
        type: 'Struct',
        field: 'headers',
        title: '设置上传的请求头部',
        props: {
          defaultValue: {}
        }
      }, {
        type: 'switch',
        field: 'multiple',
        title: '是否支持多选文件'
      }, {
        type: 'Struct',
        field: 'data',
        title: '上传时附带的额外参数',
        props: {
          defaultValue: {}
        }
      }, {
        type: 'input',
        field: 'name',
        title: '上传的文件字段名'
      }, {
        type: 'switch',
        field: 'withCredentials',
        title: '支持发送 cookie 凭证信息'
      }, {
        type: 'input',
        field: 'accept',
        title: '接受上传的文件类型（thumbnail-mode 模式下此参数无效）'
      }, {
        type: 'switch',
        field: 'autoUpload',
        title: '是否在选取文件后立即进行上传',
        value: true
      }, {
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }, {
        type: 'inputNumber',
        field: 'limit',
        title: '最大允许上传个数'
      }];
    }
  };

  var label$7 = '穿梭框';
  var name$7 = 'el-transfer';

  var generateData = function generateData(_) {
    var data = [];

    for (var i = 1; i <= 15; i++) {
      data.push({
        key: i,
        label: "\u5907\u9009\u9879 ".concat(i),
        disabled: i % 4 === 0
      });
    }

    return data;
  };

  var transfer = {
    icon: 'icon-transfer',
    label: label$7,
    name: name$7,
    rule: function rule() {
      return {
        type: name$7,
        field: uniqueId(),
        title: label$7,
        info: '',
        props: {
          data: generateData()
        }
      };
    },
    props: function props() {
      return [{
        type: 'Struct',
        field: 'data',
        title: 'Transfer 的数据源',
        props: {
          defaultValue: []
        }
      }, {
        type: 'switch',
        field: 'filterable',
        title: '是否可搜索'
      }, {
        type: 'input',
        field: 'filterPlaceholder',
        title: '搜索框占位符'
      }, {
        type: 'select',
        field: 'targetOrder',
        title: '右侧列表元素的排序策略',
        info: '若为 original，则保持与数据源相同的顺序；若为 push，则新加入的元素排在最后；若为 unshift，则新加入的元素排在最前',
        options: [{
          label: 'original',
          value: 'original'
        }, {
          label: 'push',
          value: 'push'
        }, {
          label: 'unshift',
          value: 'unshift'
        }]
      }, {
        type: 'Struct',
        field: 'titles',
        title: '自定义列表标题',
        props: {
          defaultValue: []
        }
      }, {
        type: 'Struct',
        field: 'buttonTexts',
        title: '自定义按钮文案',
        props: {
          defaultValue: []
        }
      }, {
        type: 'Struct',
        field: 'format',
        title: '列表顶部勾选状态文案',
        props: {
          defaultValue: {}
        }
      }, {
        type: 'Struct',
        field: 'props',
        title: '数据源的字段别名',
        props: {
          defaultValue: {}
        }
      }, {
        type: 'Struct',
        field: 'leftDefaultChecked',
        title: '初始状态下左侧列表的已勾选项的 key 数组',
        props: {
          defaultValue: []
        }
      }, {
        type: 'Struct',
        field: 'rightDefaultChecked',
        title: '初始状态下右侧列表的已勾选项的 key 数组',
        props: {
          defaultValue: []
        }
      }];
    }
  };

  var label$6 = '树形控件';
  var name$6 = 'tree';
  var tree = {
    icon: 'icon-tree',
    label: label$6,
    name: name$6,
    rule: function rule() {
      return {
        type: name$6,
        field: uniqueId(),
        title: label$6,
        info: '',
        effect: {
          fetch: ''
        },
        props: {
          props: {
            label: 'label'
          },
          showCheckbox: true,
          nodeKey: 'id',
          data: [{
            id: 1,
            label: '一级 1',
            children: [{
              id: 4,
              label: '二级 1-1',
              children: [{
                id: 9,
                label: '三级 1-1-1'
              }, {
                id: 10,
                label: '三级 1-1-2'
              }]
            }]
          }, {
            id: 2,
            label: '一级 2',
            children: [{
              id: 5,
              label: '二级 2-1'
            }, {
              id: 6,
              label: '二级 2-2'
            }]
          }, {
            id: 3,
            label: '一级 3',
            children: [{
              id: 7,
              label: '二级 3-1'
            }, {
              id: 8,
              label: '二级 3-2'
            }]
          }]
        }
      };
    },
    props: function props() {
      return [makeOptionsRule('props.data'), {
        type: 'input',
        field: 'emptyText',
        title: '内容为空的时候展示的文本'
      }, {
        type: 'Struct',
        field: 'props',
        title: '配置选项，具体看下表',
        props: {
          defaultValue: {}
        }
      }, {
        type: 'switch',
        field: 'renderAfterExpand',
        title: '是否在第一次展开某个树节点后才渲染其子节点',
        value: true
      }, {
        type: 'switch',
        field: 'defaultExpandAll',
        title: '是否默认展开所有节点'
      }, {
        type: 'switch',
        field: 'expandOnClickNode',
        title: '是否在点击节点的时候展开或者收缩节点， 默认值为 true，如果为 false，则只有点箭头图标的时候才会展开或者收缩节点。',
        value: true
      }, {
        type: 'switch',
        field: 'checkOnClickNode',
        title: '是否在点击节点的时候选中节点，默认值为 false，即只有在点击复选框时才会选中节点。'
      }, {
        type: 'switch',
        field: 'autoExpandParent',
        title: '展开子节点的时候是否自动展开父节点',
        value: true
      }, {
        type: 'switch',
        field: 'checkStrictly',
        title: '在显示复选框的情况下，是否严格的遵循父子不互相关联的做法，默认为 false'
      }, {
        type: 'switch',
        field: 'accordion',
        title: '是否每次只打开一个同级树节点展开'
      }, {
        type: 'inputNumber',
        field: 'indent',
        title: '相邻级节点间的水平缩进，单位为像素'
      }, {
        type: 'input',
        field: 'iconClass',
        title: '自定义树节点的图标'
      }, {
        type: 'input',
        field: 'nodeKey',
        title: '每个树节点用来作为唯一标识的属性，整棵树应该是唯一的'
      }];
    }
  };

  var label$5 = '提示';
  var name$5 = 'el-alert';
  var alert = {
    icon: 'icon-alert',
    label: label$5,
    name: name$5,
    rule: function rule() {
      return {
        type: name$5,
        props: {
          title: '提示',
          description: 'form-create',
          type: 'success',
          effect: 'dark'
        },
        children: []
      };
    },
    props: function props() {
      return [{
        type: 'input',
        field: 'title',
        title: '标题'
      }, {
        type: 'select',
        field: 'type',
        title: '主题',
        options: [{
          label: 'success',
          value: 'success'
        }, {
          label: 'warning',
          value: 'warning'
        }, {
          label: 'info',
          value: 'info'
        }, {
          label: 'error',
          value: 'error'
        }]
      }, {
        type: 'input',
        field: 'description',
        title: '辅助性文字'
      }, {
        type: 'switch',
        field: 'closable',
        title: '是否可关闭',
        value: true
      }, {
        type: 'switch',
        field: 'center',
        title: '文字是否居中',
        value: true
      }, {
        type: 'input',
        field: 'closeText',
        title: '关闭按钮自定义文本'
      }, {
        type: 'switch',
        field: 'showIcon',
        title: '是否显示图标'
      }, {
        type: 'select',
        field: 'effect',
        title: '选择提供的主题',
        options: [{
          label: 'light',
          value: 'light'
        }, {
          label: 'dark',
          value: 'dark'
        }]
      }];
    }
  };

  var label$4 = '文字';
  var name$4 = 'span';
  var span = {
    icon: 'icon-span',
    label: label$4,
    name: name$4,
    rule: function rule() {
      return {
        type: name$4,
        title: '文字',
        "native": false,
        children: ['这是一段文字']
      };
    },
    props: function props() {
      return [{
        type: 'input',
        field: 'formCreateTitle',
        title: 'title'
      }, {
        type: 'input',
        field: 'formCreateChild',
        title: '内容',
        props: {
          type: 'textarea'
        }
      }];
    }
  };

  var label$3 = '间距';
  var name$3 = 'div';
  var space = {
    icon: 'icon-space',
    label: label$3,
    name: name$3,
    rule: function rule() {
      return {
        type: name$3,
        wrap: {
          show: false
        },
        "native": false,
        style: {
          width: '100%',
          height: '20px'
        },
        children: []
      };
    },
    props: function props() {
      return [{
        type: 'object',
        field: 'formCreateStyle',
        "native": true,
        props: {
          rule: [{
            type: 'input',
            field: 'height',
            title: 'height'
          }]
        }
      }];
    }
  };

  var label$2 = '标签页';
  var name$2 = 'tab';
  var tab = {
    icon: 'icon-tab',
    label: label$2,
    name: name$2,
    children: 'tab-pane',
    rule: function rule() {
      return {
        type: 'el-tabs',
        children: []
      };
    },
    props: function props() {
      return [{
        type: 'select',
        field: 'type',
        title: '风格类型',
        options: [{
          label: 'default',
          value: 'default'
        }, {
          label: 'card',
          value: 'card'
        }, {
          label: 'border-card',
          value: 'border-card'
        }]
      }, {
        type: 'switch',
        field: 'closable',
        title: '标签是否可关闭'
      }, {
        type: 'select',
        field: 'tabPosition',
        title: '选项卡所在位置',
        options: [{
          label: 'top',
          value: 'top'
        }, {
          label: 'right',
          value: 'right'
        }, {
          label: 'left',
          value: 'left'
        }]
      }, {
        type: 'switch',
        field: 'stretch',
        title: '标签的宽度是否自撑开'
      }];
    }
  };

  var label$1 = '按钮';
  var name$1 = 'el-button';
  var button = {
    icon: 'icon-button',
    label: label$1,
    name: name$1,
    rule: function rule() {
      return {
        type: name$1,
        props: {},
        children: ['按钮']
      };
    },
    props: function props() {
      return [{
        type: 'input',
        field: 'formCreateChild',
        title: '内容'
      }, {
        type: 'select',
        field: 'size',
        title: '尺寸',
        options: [{
          label: 'medium',
          value: 'medium'
        }, {
          label: 'small',
          value: 'small'
        }, {
          label: 'mini',
          value: 'mini'
        }]
      }, {
        type: 'select',
        field: 'type',
        title: '类型',
        options: [{
          label: 'primary',
          value: 'primary'
        }, {
          label: 'success',
          value: 'success'
        }, {
          label: 'warning',
          value: 'warning'
        }, {
          label: 'danger',
          value: 'danger'
        }, {
          label: 'info',
          value: 'info'
        }, {
          label: 'text',
          value: 'text'
        }]
      }, {
        type: 'switch',
        field: 'plain',
        title: '是否朴素按钮'
      }, {
        type: 'switch',
        field: 'round',
        title: '是否圆角按钮'
      }, {
        type: 'switch',
        field: 'circle',
        title: '是否圆形按钮'
      }, {
        type: 'switch',
        field: 'loading',
        title: '是否加载中状态'
      }, {
        type: 'switch',
        field: 'disabled',
        title: '是否禁用状态'
      }, {
        type: 'input',
        field: 'icon',
        title: '图标类名'
      }];
    }
  };

  var label = '富文本框';
  var name = 'fc-editor';
  var editor = {
    icon: 'icon-editor',
    label: label,
    name: name,
    rule: function rule() {
      return {
        type: name,
        field: uniqueId(),
        title: label,
        info: '',
        props: {}
      };
    },
    props: function props() {
      return [{
        type: 'switch',
        field: 'disabled',
        title: '是否禁用'
      }];
    }
  };

  var _ruleList;
  var ruleList = (_ruleList = {}, _defineProperty$1(_ruleList, radio.name, radio), _defineProperty$1(_ruleList, checkbox.name, checkbox), _defineProperty$1(_ruleList, input.name, input), _defineProperty$1(_ruleList, number.name, number), _defineProperty$1(_ruleList, select.name, select), _defineProperty$1(_ruleList, _switch.name, _switch), _defineProperty$1(_ruleList, slider.name, slider), _defineProperty$1(_ruleList, time.name, time), _defineProperty$1(_ruleList, date.name, date), _defineProperty$1(_ruleList, rate.name, rate), _defineProperty$1(_ruleList, color.name, color), _defineProperty$1(_ruleList, row.name, row), _defineProperty$1(_ruleList, col.name, col), _defineProperty$1(_ruleList, tab.name, tab), _defineProperty$1(_ruleList, tabPane.name, tabPane), _defineProperty$1(_ruleList, divider.name, divider), _defineProperty$1(_ruleList, cascader.name, cascader), _defineProperty$1(_ruleList, upload.name, upload), _defineProperty$1(_ruleList, transfer.name, transfer), _defineProperty$1(_ruleList, tree.name, tree), _defineProperty$1(_ruleList, alert.name, alert), _defineProperty$1(_ruleList, span.name, span), _defineProperty$1(_ruleList, space.name, space), _defineProperty$1(_ruleList, button.name, button), _defineProperty$1(_ruleList, editor.name, editor), _ruleList);

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getDefaultExportFromCjs (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function getAugmentedNamespace(n) {
  	if (n.__esModule) return n;
  	var a = Object.defineProperty({}, '__esModule', {value: true});
  	Object.keys(n).forEach(function (k) {
  		var d = Object.getOwnPropertyDescriptor(n, k);
  		Object.defineProperty(a, k, d.get ? d : {
  			enumerable: true,
  			get: function () {
  				return n[k];
  			}
  		});
  	});
  	return a;
  }

  function createCommonjsModule(fn) {
    var module = { exports: {} };
  	return fn(module, module.exports), module.exports;
  }

  /**!
   * Sortable 1.10.2
   * @author	RubaXa   <trash@rubaxa.org>
   * @author	owenm    <owen23355@gmail.com>
   * @license MIT
   */
  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      var arguments$1 = arguments;

      for (var i = 1; i < arguments.length; i++) {
        var source = arguments$1[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectSpread(target) {
    var arguments$1 = arguments;

    for (var i = 1; i < arguments.length; i++) {
      var source = arguments$1[i] != null ? arguments$1[i] : {};
      var ownKeys = Object.keys(source);

      if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }

      ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) { return {}; }
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) { continue; }
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) { return {}; }

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) { continue; }
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) { continue; }
        target[key] = source[key];
      }
    }

    return target;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; }

      return arr2;
    }
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") { return Array.from(iter); }
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  var version = "1.10.2";

  function userAgent(pattern) {
    if (typeof window !== 'undefined' && window.navigator) {
      return !!
      /*@__PURE__*/
      navigator.userAgent.match(pattern);
    }
  }

  var IE11OrLess = userAgent(/(?:Trident.*rv[ :]?11\.|msie|iemobile|Windows Phone)/i);
  var Edge = userAgent(/Edge/i);
  var FireFox = userAgent(/firefox/i);
  var Safari = userAgent(/safari/i) && !userAgent(/chrome/i) && !userAgent(/android/i);
  var IOS = userAgent(/iP(ad|od|hone)/i);
  var ChromeForAndroid = userAgent(/chrome/i) && userAgent(/android/i);

  var captureMode = {
    capture: false,
    passive: false
  };

  function on(el, event, fn) {
    el.addEventListener(event, fn, !IE11OrLess && captureMode);
  }

  function off(el, event, fn) {
    el.removeEventListener(event, fn, !IE11OrLess && captureMode);
  }

  function matches(
  /**HTMLElement*/
  el,
  /**String*/
  selector) {
    if (!selector) { return; }
    selector[0] === '>' && (selector = selector.substring(1));

    if (el) {
      try {
        if (el.matches) {
          return el.matches(selector);
        } else if (el.msMatchesSelector) {
          return el.msMatchesSelector(selector);
        } else if (el.webkitMatchesSelector) {
          return el.webkitMatchesSelector(selector);
        }
      } catch (_) {
        return false;
      }
    }

    return false;
  }

  function getParentOrHost(el) {
    return el.host && el !== document && el.host.nodeType ? el.host : el.parentNode;
  }

  function closest(
  /**HTMLElement*/
  el,
  /**String*/
  selector,
  /**HTMLElement*/
  ctx, includeCTX) {
    if (el) {
      ctx = ctx || document;

      do {
        if (selector != null && (selector[0] === '>' ? el.parentNode === ctx && matches(el, selector) : matches(el, selector)) || includeCTX && el === ctx) {
          return el;
        }

        if (el === ctx) { break; }
        /* jshint boss:true */
      } while (el = getParentOrHost(el));
    }

    return null;
  }

  var R_SPACE = /\s+/g;

  function toggleClass(el, name, state) {
    if (el && name) {
      if (el.classList) {
        el.classList[state ? 'add' : 'remove'](name);
      } else {
        var className = (' ' + el.className + ' ').replace(R_SPACE, ' ').replace(' ' + name + ' ', ' ');
        el.className = (className + (state ? ' ' + name : '')).replace(R_SPACE, ' ');
      }
    }
  }

  function css(el, prop, val) {
    var style = el && el.style;

    if (style) {
      if (val === void 0) {
        if (document.defaultView && document.defaultView.getComputedStyle) {
          val = document.defaultView.getComputedStyle(el, '');
        } else if (el.currentStyle) {
          val = el.currentStyle;
        }

        return prop === void 0 ? val : val[prop];
      } else {
        if (!(prop in style) && prop.indexOf('webkit') === -1) {
          prop = '-webkit-' + prop;
        }

        style[prop] = val + (typeof val === 'string' ? '' : 'px');
      }
    }
  }

  function matrix(el, selfOnly) {
    var appliedTransforms = '';

    if (typeof el === 'string') {
      appliedTransforms = el;
    } else {
      do {
        var transform = css(el, 'transform');

        if (transform && transform !== 'none') {
          appliedTransforms = transform + ' ' + appliedTransforms;
        }
        /* jshint boss:true */

      } while (!selfOnly && (el = el.parentNode));
    }

    var matrixFn = window.DOMMatrix || window.WebKitCSSMatrix || window.CSSMatrix || window.MSCSSMatrix;
    /*jshint -W056 */

    return matrixFn && new matrixFn(appliedTransforms);
  }

  function find(ctx, tagName, iterator) {
    if (ctx) {
      var list = ctx.getElementsByTagName(tagName),
          i = 0,
          n = list.length;

      if (iterator) {
        for (; i < n; i++) {
          iterator(list[i], i);
        }
      }

      return list;
    }

    return [];
  }

  function getWindowScrollingElement() {
    var scrollingElement = document.scrollingElement;

    if (scrollingElement) {
      return scrollingElement;
    } else {
      return document.documentElement;
    }
  }
  /**
   * Returns the "bounding client rect" of given element
   * @param  {HTMLElement} el                       The element whose boundingClientRect is wanted
   * @param  {[Boolean]} relativeToContainingBlock  Whether the rect should be relative to the containing block of (including) the container
   * @param  {[Boolean]} relativeToNonStaticParent  Whether the rect should be relative to the relative parent of (including) the contaienr
   * @param  {[Boolean]} undoScale                  Whether the container's scale() should be undone
   * @param  {[HTMLElement]} container              The parent the element will be placed in
   * @return {Object}                               The boundingClientRect of el, with specified adjustments
   */


  function getRect(el, relativeToContainingBlock, relativeToNonStaticParent, undoScale, container) {
    if (!el.getBoundingClientRect && el !== window) { return; }
    var elRect, top, left, bottom, right, height, width;

    if (el !== window && el !== getWindowScrollingElement()) {
      elRect = el.getBoundingClientRect();
      top = elRect.top;
      left = elRect.left;
      bottom = elRect.bottom;
      right = elRect.right;
      height = elRect.height;
      width = elRect.width;
    } else {
      top = 0;
      left = 0;
      bottom = window.innerHeight;
      right = window.innerWidth;
      height = window.innerHeight;
      width = window.innerWidth;
    }

    if ((relativeToContainingBlock || relativeToNonStaticParent) && el !== window) {
      // Adjust for translate()
      container = container || el.parentNode; // solves #1123 (see: https://stackoverflow.com/a/37953806/6088312)
      // Not needed on <= IE11

      if (!IE11OrLess) {
        do {
          if (container && container.getBoundingClientRect && (css(container, 'transform') !== 'none' || relativeToNonStaticParent && css(container, 'position') !== 'static')) {
            var containerRect = container.getBoundingClientRect(); // Set relative to edges of padding box of container

            top -= containerRect.top + parseInt(css(container, 'border-top-width'));
            left -= containerRect.left + parseInt(css(container, 'border-left-width'));
            bottom = top + elRect.height;
            right = left + elRect.width;
            break;
          }
          /* jshint boss:true */

        } while (container = container.parentNode);
      }
    }

    if (undoScale && el !== window) {
      // Adjust for scale()
      var elMatrix = matrix(container || el),
          scaleX = elMatrix && elMatrix.a,
          scaleY = elMatrix && elMatrix.d;

      if (elMatrix) {
        top /= scaleY;
        left /= scaleX;
        width /= scaleX;
        height /= scaleY;
        bottom = top + height;
        right = left + width;
      }
    }

    return {
      top: top,
      left: left,
      bottom: bottom,
      right: right,
      width: width,
      height: height
    };
  }
  /**
   * Checks if a side of an element is scrolled past a side of its parents
   * @param  {HTMLElement}  el           The element who's side being scrolled out of view is in question
   * @param  {String}       elSide       Side of the element in question ('top', 'left', 'right', 'bottom')
   * @param  {String}       parentSide   Side of the parent in question ('top', 'left', 'right', 'bottom')
   * @return {HTMLElement}               The parent scroll element that the el's side is scrolled past, or null if there is no such element
   */


  function isScrolledPast(el, elSide, parentSide) {
    var parent = getParentAutoScrollElement(el, true),
        elSideVal = getRect(el)[elSide];
    /* jshint boss:true */

    while (parent) {
      var parentSideVal = getRect(parent)[parentSide],
          visible = void 0;

      if (parentSide === 'top' || parentSide === 'left') {
        visible = elSideVal >= parentSideVal;
      } else {
        visible = elSideVal <= parentSideVal;
      }

      if (!visible) { return parent; }
      if (parent === getWindowScrollingElement()) { break; }
      parent = getParentAutoScrollElement(parent, false);
    }

    return false;
  }
  /**
   * Gets nth child of el, ignoring hidden children, sortable's elements (does not ignore clone if it's visible)
   * and non-draggable elements
   * @param  {HTMLElement} el       The parent element
   * @param  {Number} childNum      The index of the child
   * @param  {Object} options       Parent Sortable's options
   * @return {HTMLElement}          The child at index childNum, or null if not found
   */


  function getChild(el, childNum, options) {
    var currentChild = 0,
        i = 0,
        children = el.children;

    while (i < children.length) {
      if (children[i].style.display !== 'none' && children[i] !== Sortable.ghost && children[i] !== Sortable.dragged && closest(children[i], options.draggable, el, false)) {
        if (currentChild === childNum) {
          return children[i];
        }

        currentChild++;
      }

      i++;
    }

    return null;
  }
  /**
   * Gets the last child in the el, ignoring ghostEl or invisible elements (clones)
   * @param  {HTMLElement} el       Parent element
   * @param  {selector} selector    Any other elements that should be ignored
   * @return {HTMLElement}          The last child, ignoring ghostEl
   */


  function lastChild(el, selector) {
    var last = el.lastElementChild;

    while (last && (last === Sortable.ghost || css(last, 'display') === 'none' || selector && !matches(last, selector))) {
      last = last.previousElementSibling;
    }

    return last || null;
  }
  /**
   * Returns the index of an element within its parent for a selected set of
   * elements
   * @param  {HTMLElement} el
   * @param  {selector} selector
   * @return {number}
   */


  function index(el, selector) {
    var index = 0;

    if (!el || !el.parentNode) {
      return -1;
    }
    /* jshint boss:true */


    while (el = el.previousElementSibling) {
      if (el.nodeName.toUpperCase() !== 'TEMPLATE' && el !== Sortable.clone && (!selector || matches(el, selector))) {
        index++;
      }
    }

    return index;
  }
  /**
   * Returns the scroll offset of the given element, added with all the scroll offsets of parent elements.
   * The value is returned in real pixels.
   * @param  {HTMLElement} el
   * @return {Array}             Offsets in the format of [left, top]
   */


  function getRelativeScrollOffset(el) {
    var offsetLeft = 0,
        offsetTop = 0,
        winScroller = getWindowScrollingElement();

    if (el) {
      do {
        var elMatrix = matrix(el),
            scaleX = elMatrix.a,
            scaleY = elMatrix.d;
        offsetLeft += el.scrollLeft * scaleX;
        offsetTop += el.scrollTop * scaleY;
      } while (el !== winScroller && (el = el.parentNode));
    }

    return [offsetLeft, offsetTop];
  }
  /**
   * Returns the index of the object within the given array
   * @param  {Array} arr   Array that may or may not hold the object
   * @param  {Object} obj  An object that has a key-value pair unique to and identical to a key-value pair in the object you want to find
   * @return {Number}      The index of the object in the array, or -1
   */


  function indexOfObject(arr, obj) {
    for (var i in arr) {
      if (!arr.hasOwnProperty(i)) { continue; }

      for (var key in obj) {
        if (obj.hasOwnProperty(key) && obj[key] === arr[i][key]) { return Number(i); }
      }
    }

    return -1;
  }

  function getParentAutoScrollElement(el, includeSelf) {
    // skip to window
    if (!el || !el.getBoundingClientRect) { return getWindowScrollingElement(); }
    var elem = el;
    var gotSelf = false;

    do {
      // we don't need to get elem css if it isn't even overflowing in the first place (performance)
      if (elem.clientWidth < elem.scrollWidth || elem.clientHeight < elem.scrollHeight) {
        var elemCSS = css(elem);

        if (elem.clientWidth < elem.scrollWidth && (elemCSS.overflowX == 'auto' || elemCSS.overflowX == 'scroll') || elem.clientHeight < elem.scrollHeight && (elemCSS.overflowY == 'auto' || elemCSS.overflowY == 'scroll')) {
          if (!elem.getBoundingClientRect || elem === document.body) { return getWindowScrollingElement(); }
          if (gotSelf || includeSelf) { return elem; }
          gotSelf = true;
        }
      }
      /* jshint boss:true */

    } while (elem = elem.parentNode);

    return getWindowScrollingElement();
  }

  function extend(dst, src) {
    if (dst && src) {
      for (var key in src) {
        if (src.hasOwnProperty(key)) {
          dst[key] = src[key];
        }
      }
    }

    return dst;
  }

  function isRectEqual(rect1, rect2) {
    return Math.round(rect1.top) === Math.round(rect2.top) && Math.round(rect1.left) === Math.round(rect2.left) && Math.round(rect1.height) === Math.round(rect2.height) && Math.round(rect1.width) === Math.round(rect2.width);
  }

  var _throttleTimeout;

  function throttle(callback, ms) {
    return function () {
      if (!_throttleTimeout) {
        var args = arguments,
            _this = this;

        if (args.length === 1) {
          callback.call(_this, args[0]);
        } else {
          callback.apply(_this, args);
        }

        _throttleTimeout = setTimeout(function () {
          _throttleTimeout = void 0;
        }, ms);
      }
    };
  }

  function cancelThrottle() {
    clearTimeout(_throttleTimeout);
    _throttleTimeout = void 0;
  }

  function scrollBy(el, x, y) {
    el.scrollLeft += x;
    el.scrollTop += y;
  }

  function clone(el) {
    var Polymer = window.Polymer;
    var $ = window.jQuery || window.Zepto;

    if (Polymer && Polymer.dom) {
      return Polymer.dom(el).cloneNode(true);
    } else if ($) {
      return $(el).clone(true)[0];
    } else {
      return el.cloneNode(true);
    }
  }

  function setRect(el, rect) {
    css(el, 'position', 'absolute');
    css(el, 'top', rect.top);
    css(el, 'left', rect.left);
    css(el, 'width', rect.width);
    css(el, 'height', rect.height);
  }

  function unsetRect(el) {
    css(el, 'position', '');
    css(el, 'top', '');
    css(el, 'left', '');
    css(el, 'width', '');
    css(el, 'height', '');
  }

  var expando = 'Sortable' + new Date().getTime();

  function AnimationStateManager() {
    var animationStates = [],
        animationCallbackId;
    return {
      captureAnimationState: function captureAnimationState() {
        animationStates = [];
        if (!this.options.animation) { return; }
        var children = [].slice.call(this.el.children);
        children.forEach(function (child) {
          if (css(child, 'display') === 'none' || child === Sortable.ghost) { return; }
          animationStates.push({
            target: child,
            rect: getRect(child)
          });

          var fromRect = _objectSpread({}, animationStates[animationStates.length - 1].rect); // If animating: compensate for current animation


          if (child.thisAnimationDuration) {
            var childMatrix = matrix(child, true);

            if (childMatrix) {
              fromRect.top -= childMatrix.f;
              fromRect.left -= childMatrix.e;
            }
          }

          child.fromRect = fromRect;
        });
      },
      addAnimationState: function addAnimationState(state) {
        animationStates.push(state);
      },
      removeAnimationState: function removeAnimationState(target) {
        animationStates.splice(indexOfObject(animationStates, {
          target: target
        }), 1);
      },
      animateAll: function animateAll(callback) {
        var _this = this;

        if (!this.options.animation) {
          clearTimeout(animationCallbackId);
          if (typeof callback === 'function') { callback(); }
          return;
        }

        var animating = false,
            animationTime = 0;
        animationStates.forEach(function (state) {
          var time = 0,
              target = state.target,
              fromRect = target.fromRect,
              toRect = getRect(target),
              prevFromRect = target.prevFromRect,
              prevToRect = target.prevToRect,
              animatingRect = state.rect,
              targetMatrix = matrix(target, true);

          if (targetMatrix) {
            // Compensate for current animation
            toRect.top -= targetMatrix.f;
            toRect.left -= targetMatrix.e;
          }

          target.toRect = toRect;

          if (target.thisAnimationDuration) {
            // Could also check if animatingRect is between fromRect and toRect
            if (isRectEqual(prevFromRect, toRect) && !isRectEqual(fromRect, toRect) && // Make sure animatingRect is on line between toRect & fromRect
            (animatingRect.top - toRect.top) / (animatingRect.left - toRect.left) === (fromRect.top - toRect.top) / (fromRect.left - toRect.left)) {
              // If returning to same place as started from animation and on same axis
              time = calculateRealTime(animatingRect, prevFromRect, prevToRect, _this.options);
            }
          } // if fromRect != toRect: animate


          if (!isRectEqual(toRect, fromRect)) {
            target.prevFromRect = fromRect;
            target.prevToRect = toRect;

            if (!time) {
              time = _this.options.animation;
            }

            _this.animate(target, animatingRect, toRect, time);
          }

          if (time) {
            animating = true;
            animationTime = Math.max(animationTime, time);
            clearTimeout(target.animationResetTimer);
            target.animationResetTimer = setTimeout(function () {
              target.animationTime = 0;
              target.prevFromRect = null;
              target.fromRect = null;
              target.prevToRect = null;
              target.thisAnimationDuration = null;
            }, time);
            target.thisAnimationDuration = time;
          }
        });
        clearTimeout(animationCallbackId);

        if (!animating) {
          if (typeof callback === 'function') { callback(); }
        } else {
          animationCallbackId = setTimeout(function () {
            if (typeof callback === 'function') { callback(); }
          }, animationTime);
        }

        animationStates = [];
      },
      animate: function animate(target, currentRect, toRect, duration) {
        if (duration) {
          css(target, 'transition', '');
          css(target, 'transform', '');
          var elMatrix = matrix(this.el),
              scaleX = elMatrix && elMatrix.a,
              scaleY = elMatrix && elMatrix.d,
              translateX = (currentRect.left - toRect.left) / (scaleX || 1),
              translateY = (currentRect.top - toRect.top) / (scaleY || 1);
          target.animatingX = !!translateX;
          target.animatingY = !!translateY;
          css(target, 'transform', 'translate3d(' + translateX + 'px,' + translateY + 'px,0)');
          repaint(target); // repaint

          css(target, 'transition', 'transform ' + duration + 'ms' + (this.options.easing ? ' ' + this.options.easing : ''));
          css(target, 'transform', 'translate3d(0,0,0)');
          typeof target.animated === 'number' && clearTimeout(target.animated);
          target.animated = setTimeout(function () {
            css(target, 'transition', '');
            css(target, 'transform', '');
            target.animated = false;
            target.animatingX = false;
            target.animatingY = false;
          }, duration);
        }
      }
    };
  }

  function repaint(target) {
    return target.offsetWidth;
  }

  function calculateRealTime(animatingRect, fromRect, toRect, options) {
    return Math.sqrt(Math.pow(fromRect.top - animatingRect.top, 2) + Math.pow(fromRect.left - animatingRect.left, 2)) / Math.sqrt(Math.pow(fromRect.top - toRect.top, 2) + Math.pow(fromRect.left - toRect.left, 2)) * options.animation;
  }

  var plugins = [];
  var defaults = {
    initializeByDefault: true
  };
  var PluginManager = {
    mount: function mount(plugin) {
      // Set default static properties
      for (var option in defaults) {
        if (defaults.hasOwnProperty(option) && !(option in plugin)) {
          plugin[option] = defaults[option];
        }
      }

      plugins.push(plugin);
    },
    pluginEvent: function pluginEvent(eventName, sortable, evt) {
      var _this = this;

      this.eventCanceled = false;

      evt.cancel = function () {
        _this.eventCanceled = true;
      };

      var eventNameGlobal = eventName + 'Global';
      plugins.forEach(function (plugin) {
        if (!sortable[plugin.pluginName]) { return; } // Fire global events if it exists in this sortable

        if (sortable[plugin.pluginName][eventNameGlobal]) {
          sortable[plugin.pluginName][eventNameGlobal](_objectSpread({
            sortable: sortable
          }, evt));
        } // Only fire plugin event if plugin is enabled in this sortable,
        // and plugin has event defined


        if (sortable.options[plugin.pluginName] && sortable[plugin.pluginName][eventName]) {
          sortable[plugin.pluginName][eventName](_objectSpread({
            sortable: sortable
          }, evt));
        }
      });
    },
    initializePlugins: function initializePlugins(sortable, el, defaults, options) {
      plugins.forEach(function (plugin) {
        var pluginName = plugin.pluginName;
        if (!sortable.options[pluginName] && !plugin.initializeByDefault) { return; }
        var initialized = new plugin(sortable, el, sortable.options);
        initialized.sortable = sortable;
        initialized.options = sortable.options;
        sortable[pluginName] = initialized; // Add default options from plugin

        _extends(defaults, initialized.defaults);
      });

      for (var option in sortable.options) {
        if (!sortable.options.hasOwnProperty(option)) { continue; }
        var modified = this.modifyOption(sortable, option, sortable.options[option]);

        if (typeof modified !== 'undefined') {
          sortable.options[option] = modified;
        }
      }
    },
    getEventProperties: function getEventProperties(name, sortable) {
      var eventProperties = {};
      plugins.forEach(function (plugin) {
        if (typeof plugin.eventProperties !== 'function') { return; }

        _extends(eventProperties, plugin.eventProperties.call(sortable[plugin.pluginName], name));
      });
      return eventProperties;
    },
    modifyOption: function modifyOption(sortable, name, value) {
      var modifiedValue;
      plugins.forEach(function (plugin) {
        // Plugin must exist on the Sortable
        if (!sortable[plugin.pluginName]) { return; } // If static option listener exists for this option, call in the context of the Sortable's instance of this plugin

        if (plugin.optionListeners && typeof plugin.optionListeners[name] === 'function') {
          modifiedValue = plugin.optionListeners[name].call(sortable[plugin.pluginName], value);
        }
      });
      return modifiedValue;
    }
  };

  function dispatchEvent(_ref) {
    var sortable = _ref.sortable,
        rootEl = _ref.rootEl,
        name = _ref.name,
        targetEl = _ref.targetEl,
        cloneEl = _ref.cloneEl,
        toEl = _ref.toEl,
        fromEl = _ref.fromEl,
        oldIndex = _ref.oldIndex,
        newIndex = _ref.newIndex,
        oldDraggableIndex = _ref.oldDraggableIndex,
        newDraggableIndex = _ref.newDraggableIndex,
        originalEvent = _ref.originalEvent,
        putSortable = _ref.putSortable,
        extraEventProperties = _ref.extraEventProperties;
    sortable = sortable || rootEl && rootEl[expando];
    if (!sortable) { return; }
    var evt,
        options = sortable.options,
        onName = 'on' + name.charAt(0).toUpperCase() + name.substr(1); // Support for new CustomEvent feature

    if (window.CustomEvent && !IE11OrLess && !Edge) {
      evt = new CustomEvent(name, {
        bubbles: true,
        cancelable: true
      });
    } else {
      evt = document.createEvent('Event');
      evt.initEvent(name, true, true);
    }

    evt.to = toEl || rootEl;
    evt.from = fromEl || rootEl;
    evt.item = targetEl || rootEl;
    evt.clone = cloneEl;
    evt.oldIndex = oldIndex;
    evt.newIndex = newIndex;
    evt.oldDraggableIndex = oldDraggableIndex;
    evt.newDraggableIndex = newDraggableIndex;
    evt.originalEvent = originalEvent;
    evt.pullMode = putSortable ? putSortable.lastPutMode : undefined;

    var allEventProperties = _objectSpread({}, extraEventProperties, PluginManager.getEventProperties(name, sortable));

    for (var option in allEventProperties) {
      evt[option] = allEventProperties[option];
    }

    if (rootEl) {
      rootEl.dispatchEvent(evt);
    }

    if (options[onName]) {
      options[onName].call(sortable, evt);
    }
  }

  var pluginEvent = function pluginEvent(eventName, sortable) {
    var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
        originalEvent = _ref.evt,
        data = _objectWithoutProperties(_ref, ["evt"]);

    PluginManager.pluginEvent.bind(Sortable)(eventName, sortable, _objectSpread({
      dragEl: dragEl,
      parentEl: parentEl,
      ghostEl: ghostEl,
      rootEl: rootEl,
      nextEl: nextEl,
      lastDownEl: lastDownEl,
      cloneEl: cloneEl,
      cloneHidden: cloneHidden,
      dragStarted: moved,
      putSortable: putSortable,
      activeSortable: Sortable.active,
      originalEvent: originalEvent,
      oldIndex: oldIndex,
      oldDraggableIndex: oldDraggableIndex,
      newIndex: newIndex,
      newDraggableIndex: newDraggableIndex,
      hideGhostForTarget: _hideGhostForTarget,
      unhideGhostForTarget: _unhideGhostForTarget,
      cloneNowHidden: function cloneNowHidden() {
        cloneHidden = true;
      },
      cloneNowShown: function cloneNowShown() {
        cloneHidden = false;
      },
      dispatchSortableEvent: function dispatchSortableEvent(name) {
        _dispatchEvent({
          sortable: sortable,
          name: name,
          originalEvent: originalEvent
        });
      }
    }, data));
  };

  function _dispatchEvent(info) {
    dispatchEvent(_objectSpread({
      putSortable: putSortable,
      cloneEl: cloneEl,
      targetEl: dragEl,
      rootEl: rootEl,
      oldIndex: oldIndex,
      oldDraggableIndex: oldDraggableIndex,
      newIndex: newIndex,
      newDraggableIndex: newDraggableIndex
    }, info));
  }

  var dragEl,
      parentEl,
      ghostEl,
      rootEl,
      nextEl,
      lastDownEl,
      cloneEl,
      cloneHidden,
      oldIndex,
      newIndex,
      oldDraggableIndex,
      newDraggableIndex,
      activeGroup,
      putSortable,
      awaitingDragStarted = false,
      ignoreNextClick = false,
      sortables = [],
      tapEvt,
      touchEvt,
      lastDx,
      lastDy,
      tapDistanceLeft,
      tapDistanceTop,
      moved,
      lastTarget,
      lastDirection,
      pastFirstInvertThresh = false,
      isCircumstantialInvert = false,
      targetMoveDistance,
      // For positioning ghost absolutely
  ghostRelativeParent,
      ghostRelativeParentInitialScroll = [],
      // (left, top)
  _silent = false,
      savedInputChecked = [];
  /** @const */

  var documentExists = typeof document !== 'undefined',
      PositionGhostAbsolutely = IOS,
      CSSFloatProperty = Edge || IE11OrLess ? 'cssFloat' : 'float',
      // This will not pass for IE9, because IE9 DnD only works on anchors
  supportDraggable = documentExists && !ChromeForAndroid && !IOS && 'draggable' in document.createElement('div'),
      supportCssPointerEvents = function () {
    if (!documentExists) { return; } // false when <= IE11

    if (IE11OrLess) {
      return false;
    }

    var el = document.createElement('x');
    el.style.cssText = 'pointer-events:auto';
    return el.style.pointerEvents === 'auto';
  }(),
      _detectDirection = function _detectDirection(el, options) {
    var elCSS = css(el),
        elWidth = parseInt(elCSS.width) - parseInt(elCSS.paddingLeft) - parseInt(elCSS.paddingRight) - parseInt(elCSS.borderLeftWidth) - parseInt(elCSS.borderRightWidth),
        child1 = getChild(el, 0, options),
        child2 = getChild(el, 1, options),
        firstChildCSS = child1 && css(child1),
        secondChildCSS = child2 && css(child2),
        firstChildWidth = firstChildCSS && parseInt(firstChildCSS.marginLeft) + parseInt(firstChildCSS.marginRight) + getRect(child1).width,
        secondChildWidth = secondChildCSS && parseInt(secondChildCSS.marginLeft) + parseInt(secondChildCSS.marginRight) + getRect(child2).width;

    if (elCSS.display === 'flex') {
      return elCSS.flexDirection === 'column' || elCSS.flexDirection === 'column-reverse' ? 'vertical' : 'horizontal';
    }

    if (elCSS.display === 'grid') {
      return elCSS.gridTemplateColumns.split(' ').length <= 1 ? 'vertical' : 'horizontal';
    }

    if (child1 && firstChildCSS["float"] && firstChildCSS["float"] !== 'none') {
      var touchingSideChild2 = firstChildCSS["float"] === 'left' ? 'left' : 'right';
      return child2 && (secondChildCSS.clear === 'both' || secondChildCSS.clear === touchingSideChild2) ? 'vertical' : 'horizontal';
    }

    return child1 && (firstChildCSS.display === 'block' || firstChildCSS.display === 'flex' || firstChildCSS.display === 'table' || firstChildCSS.display === 'grid' || firstChildWidth >= elWidth && elCSS[CSSFloatProperty] === 'none' || child2 && elCSS[CSSFloatProperty] === 'none' && firstChildWidth + secondChildWidth > elWidth) ? 'vertical' : 'horizontal';
  },
      _dragElInRowColumn = function _dragElInRowColumn(dragRect, targetRect, vertical) {
    var dragElS1Opp = vertical ? dragRect.left : dragRect.top,
        dragElS2Opp = vertical ? dragRect.right : dragRect.bottom,
        dragElOppLength = vertical ? dragRect.width : dragRect.height,
        targetS1Opp = vertical ? targetRect.left : targetRect.top,
        targetS2Opp = vertical ? targetRect.right : targetRect.bottom,
        targetOppLength = vertical ? targetRect.width : targetRect.height;
    return dragElS1Opp === targetS1Opp || dragElS2Opp === targetS2Opp || dragElS1Opp + dragElOppLength / 2 === targetS1Opp + targetOppLength / 2;
  },

  /**
   * Detects first nearest empty sortable to X and Y position using emptyInsertThreshold.
   * @param  {Number} x      X position
   * @param  {Number} y      Y position
   * @return {HTMLElement}   Element of the first found nearest Sortable
   */
  _detectNearestEmptySortable = function _detectNearestEmptySortable(x, y) {
    var ret;
    sortables.some(function (sortable) {
      if (lastChild(sortable)) { return; }
      var rect = getRect(sortable),
          threshold = sortable[expando].options.emptyInsertThreshold,
          insideHorizontally = x >= rect.left - threshold && x <= rect.right + threshold,
          insideVertically = y >= rect.top - threshold && y <= rect.bottom + threshold;

      if (threshold && insideHorizontally && insideVertically) {
        return ret = sortable;
      }
    });
    return ret;
  },
      _prepareGroup = function _prepareGroup(options) {
    function toFn(value, pull) {
      return function (to, from, dragEl, evt) {
        var sameGroup = to.options.group.name && from.options.group.name && to.options.group.name === from.options.group.name;

        if (value == null && (pull || sameGroup)) {
          // Default pull value
          // Default pull and put value if same group
          return true;
        } else if (value == null || value === false) {
          return false;
        } else if (pull && value === 'clone') {
          return value;
        } else if (typeof value === 'function') {
          return toFn(value(to, from, dragEl, evt), pull)(to, from, dragEl, evt);
        } else {
          var otherGroup = (pull ? to : from).options.group.name;
          return value === true || typeof value === 'string' && value === otherGroup || value.join && value.indexOf(otherGroup) > -1;
        }
      };
    }

    var group = {};
    var originalGroup = options.group;

    if (!originalGroup || _typeof(originalGroup) != 'object') {
      originalGroup = {
        name: originalGroup
      };
    }

    group.name = originalGroup.name;
    group.checkPull = toFn(originalGroup.pull, true);
    group.checkPut = toFn(originalGroup.put);
    group.revertClone = originalGroup.revertClone;
    options.group = group;
  },
      _hideGhostForTarget = function _hideGhostForTarget() {
    if (!supportCssPointerEvents && ghostEl) {
      css(ghostEl, 'display', 'none');
    }
  },
      _unhideGhostForTarget = function _unhideGhostForTarget() {
    if (!supportCssPointerEvents && ghostEl) {
      css(ghostEl, 'display', '');
    }
  }; // #1184 fix - Prevent click event on fallback if dragged but item not changed position


  if (documentExists) {
    document.addEventListener('click', function (evt) {
      if (ignoreNextClick) {
        evt.preventDefault();
        evt.stopPropagation && evt.stopPropagation();
        evt.stopImmediatePropagation && evt.stopImmediatePropagation();
        ignoreNextClick = false;
        return false;
      }
    }, true);
  }

  var nearestEmptyInsertDetectEvent = function nearestEmptyInsertDetectEvent(evt) {
    if (dragEl) {
      evt = evt.touches ? evt.touches[0] : evt;

      var nearest = _detectNearestEmptySortable(evt.clientX, evt.clientY);

      if (nearest) {
        // Create imitation event
        var event = {};

        for (var i in evt) {
          if (evt.hasOwnProperty(i)) {
            event[i] = evt[i];
          }
        }

        event.target = event.rootEl = nearest;
        event.preventDefault = void 0;
        event.stopPropagation = void 0;

        nearest[expando]._onDragOver(event);
      }
    }
  };

  var _checkOutsideTargetEl = function _checkOutsideTargetEl(evt) {
    if (dragEl) {
      dragEl.parentNode[expando]._isOutsideThisEl(evt.target);
    }
  };
  /**
   * @class  Sortable
   * @param  {HTMLElement}  el
   * @param  {Object}       [options]
   */


  function Sortable(el, options) {
    if (!(el && el.nodeType && el.nodeType === 1)) {
      throw "Sortable: `el` must be an HTMLElement, not ".concat({}.toString.call(el));
    }

    this.el = el; // root element

    this.options = options = _extends({}, options); // Export instance

    el[expando] = this;
    var defaults = {
      group: null,
      sort: true,
      disabled: false,
      store: null,
      handle: null,
      draggable: /^[uo]l$/i.test(el.nodeName) ? '>li' : '>*',
      swapThreshold: 1,
      // percentage; 0 <= x <= 1
      invertSwap: false,
      // invert always
      invertedSwapThreshold: null,
      // will be set to same as swapThreshold if default
      removeCloneOnHide: true,
      direction: function direction() {
        return _detectDirection(el, this.options);
      },
      ghostClass: 'sortable-ghost',
      chosenClass: 'sortable-chosen',
      dragClass: 'sortable-drag',
      ignore: 'a, img',
      filter: null,
      preventOnFilter: true,
      animation: 0,
      easing: null,
      setData: function setData(dataTransfer, dragEl) {
        dataTransfer.setData('Text', dragEl.textContent);
      },
      dropBubble: false,
      dragoverBubble: false,
      dataIdAttr: 'data-id',
      delay: 0,
      delayOnTouchOnly: false,
      touchStartThreshold: (Number.parseInt ? Number : window).parseInt(window.devicePixelRatio, 10) || 1,
      forceFallback: false,
      fallbackClass: 'sortable-fallback',
      fallbackOnBody: false,
      fallbackTolerance: 0,
      fallbackOffset: {
        x: 0,
        y: 0
      },
      supportPointer: Sortable.supportPointer !== false && 'PointerEvent' in window,
      emptyInsertThreshold: 5
    };
    PluginManager.initializePlugins(this, el, defaults); // Set default options

    for (var name in defaults) {
      !(name in options) && (options[name] = defaults[name]);
    }

    _prepareGroup(options); // Bind all private methods


    for (var fn in this) {
      if (fn.charAt(0) === '_' && typeof this[fn] === 'function') {
        this[fn] = this[fn].bind(this);
      }
    } // Setup drag mode


    this.nativeDraggable = options.forceFallback ? false : supportDraggable;

    if (this.nativeDraggable) {
      // Touch start threshold cannot be greater than the native dragstart threshold
      this.options.touchStartThreshold = 1;
    } // Bind events


    if (options.supportPointer) {
      on(el, 'pointerdown', this._onTapStart);
    } else {
      on(el, 'mousedown', this._onTapStart);
      on(el, 'touchstart', this._onTapStart);
    }

    if (this.nativeDraggable) {
      on(el, 'dragover', this);
      on(el, 'dragenter', this);
    }

    sortables.push(this.el); // Restore sorting

    options.store && options.store.get && this.sort(options.store.get(this) || []); // Add animation state manager

    _extends(this, AnimationStateManager());
  }

  Sortable.prototype =
  /** @lends Sortable.prototype */
  {
    constructor: Sortable,
    _isOutsideThisEl: function _isOutsideThisEl(target) {
      if (!this.el.contains(target) && target !== this.el) {
        lastTarget = null;
      }
    },
    _getDirection: function _getDirection(evt, target) {
      return typeof this.options.direction === 'function' ? this.options.direction.call(this, evt, target, dragEl) : this.options.direction;
    },
    _onTapStart: function _onTapStart(
    /** Event|TouchEvent */
    evt) {
      if (!evt.cancelable) { return; }

      var _this = this,
          el = this.el,
          options = this.options,
          preventOnFilter = options.preventOnFilter,
          type = evt.type,
          touch = evt.touches && evt.touches[0] || evt.pointerType && evt.pointerType === 'touch' && evt,
          target = (touch || evt).target,
          originalTarget = evt.target.shadowRoot && (evt.path && evt.path[0] || evt.composedPath && evt.composedPath()[0]) || target,
          filter = options.filter;

      _saveInputCheckedState(el); // Don't trigger start event when an element is been dragged, otherwise the evt.oldindex always wrong when set option.group.


      if (dragEl) {
        return;
      }

      if (/mousedown|pointerdown/.test(type) && evt.button !== 0 || options.disabled) {
        return; // only left button and enabled
      } // cancel dnd if original target is content editable


      if (originalTarget.isContentEditable) {
        return;
      }

      target = closest(target, options.draggable, el, false);

      if (target && target.animated) {
        return;
      }

      if (lastDownEl === target) {
        // Ignoring duplicate `down`
        return;
      } // Get the index of the dragged element within its parent


      oldIndex = index(target);
      oldDraggableIndex = index(target, options.draggable); // Check filter

      if (typeof filter === 'function') {
        if (filter.call(this, evt, target, this)) {
          _dispatchEvent({
            sortable: _this,
            rootEl: originalTarget,
            name: 'filter',
            targetEl: target,
            toEl: el,
            fromEl: el
          });

          pluginEvent('filter', _this, {
            evt: evt
          });
          preventOnFilter && evt.cancelable && evt.preventDefault();
          return; // cancel dnd
        }
      } else if (filter) {
        filter = filter.split(',').some(function (criteria) {
          criteria = closest(originalTarget, criteria.trim(), el, false);

          if (criteria) {
            _dispatchEvent({
              sortable: _this,
              rootEl: criteria,
              name: 'filter',
              targetEl: target,
              fromEl: el,
              toEl: el
            });

            pluginEvent('filter', _this, {
              evt: evt
            });
            return true;
          }
        });

        if (filter) {
          preventOnFilter && evt.cancelable && evt.preventDefault();
          return; // cancel dnd
        }
      }

      if (options.handle && !closest(originalTarget, options.handle, el, false)) {
        return;
      } // Prepare `dragstart`


      this._prepareDragStart(evt, touch, target);
    },
    _prepareDragStart: function _prepareDragStart(
    /** Event */
    evt,
    /** Touch */
    touch,
    /** HTMLElement */
    target) {
      var _this = this,
          el = _this.el,
          options = _this.options,
          ownerDocument = el.ownerDocument,
          dragStartFn;

      if (target && !dragEl && target.parentNode === el) {
        var dragRect = getRect(target);
        rootEl = el;
        dragEl = target;
        parentEl = dragEl.parentNode;
        nextEl = dragEl.nextSibling;
        lastDownEl = target;
        activeGroup = options.group;
        Sortable.dragged = dragEl;
        tapEvt = {
          target: dragEl,
          clientX: (touch || evt).clientX,
          clientY: (touch || evt).clientY
        };
        tapDistanceLeft = tapEvt.clientX - dragRect.left;
        tapDistanceTop = tapEvt.clientY - dragRect.top;
        this._lastX = (touch || evt).clientX;
        this._lastY = (touch || evt).clientY;
        dragEl.style['will-change'] = 'all';

        dragStartFn = function dragStartFn() {
          pluginEvent('delayEnded', _this, {
            evt: evt
          });

          if (Sortable.eventCanceled) {
            _this._onDrop();

            return;
          } // Delayed drag has been triggered
          // we can re-enable the events: touchmove/mousemove


          _this._disableDelayedDragEvents();

          if (!FireFox && _this.nativeDraggable) {
            dragEl.draggable = true;
          } // Bind the events: dragstart/dragend


          _this._triggerDragStart(evt, touch); // Drag start event


          _dispatchEvent({
            sortable: _this,
            name: 'choose',
            originalEvent: evt
          }); // Chosen item


          toggleClass(dragEl, options.chosenClass, true);
        }; // Disable "draggable"


        options.ignore.split(',').forEach(function (criteria) {
          find(dragEl, criteria.trim(), _disableDraggable);
        });
        on(ownerDocument, 'dragover', nearestEmptyInsertDetectEvent);
        on(ownerDocument, 'mousemove', nearestEmptyInsertDetectEvent);
        on(ownerDocument, 'touchmove', nearestEmptyInsertDetectEvent);
        on(ownerDocument, 'mouseup', _this._onDrop);
        on(ownerDocument, 'touchend', _this._onDrop);
        on(ownerDocument, 'touchcancel', _this._onDrop); // Make dragEl draggable (must be before delay for FireFox)

        if (FireFox && this.nativeDraggable) {
          this.options.touchStartThreshold = 4;
          dragEl.draggable = true;
        }

        pluginEvent('delayStart', this, {
          evt: evt
        }); // Delay is impossible for native DnD in Edge or IE

        if (options.delay && (!options.delayOnTouchOnly || touch) && (!this.nativeDraggable || !(Edge || IE11OrLess))) {
          if (Sortable.eventCanceled) {
            this._onDrop();

            return;
          } // If the user moves the pointer or let go the click or touch
          // before the delay has been reached:
          // disable the delayed drag


          on(ownerDocument, 'mouseup', _this._disableDelayedDrag);
          on(ownerDocument, 'touchend', _this._disableDelayedDrag);
          on(ownerDocument, 'touchcancel', _this._disableDelayedDrag);
          on(ownerDocument, 'mousemove', _this._delayedDragTouchMoveHandler);
          on(ownerDocument, 'touchmove', _this._delayedDragTouchMoveHandler);
          options.supportPointer && on(ownerDocument, 'pointermove', _this._delayedDragTouchMoveHandler);
          _this._dragStartTimer = setTimeout(dragStartFn, options.delay);
        } else {
          dragStartFn();
        }
      }
    },
    _delayedDragTouchMoveHandler: function _delayedDragTouchMoveHandler(
    /** TouchEvent|PointerEvent **/
    e) {
      var touch = e.touches ? e.touches[0] : e;

      if (Math.max(Math.abs(touch.clientX - this._lastX), Math.abs(touch.clientY - this._lastY)) >= Math.floor(this.options.touchStartThreshold / (this.nativeDraggable && window.devicePixelRatio || 1))) {
        this._disableDelayedDrag();
      }
    },
    _disableDelayedDrag: function _disableDelayedDrag() {
      dragEl && _disableDraggable(dragEl);
      clearTimeout(this._dragStartTimer);

      this._disableDelayedDragEvents();
    },
    _disableDelayedDragEvents: function _disableDelayedDragEvents() {
      var ownerDocument = this.el.ownerDocument;
      off(ownerDocument, 'mouseup', this._disableDelayedDrag);
      off(ownerDocument, 'touchend', this._disableDelayedDrag);
      off(ownerDocument, 'touchcancel', this._disableDelayedDrag);
      off(ownerDocument, 'mousemove', this._delayedDragTouchMoveHandler);
      off(ownerDocument, 'touchmove', this._delayedDragTouchMoveHandler);
      off(ownerDocument, 'pointermove', this._delayedDragTouchMoveHandler);
    },
    _triggerDragStart: function _triggerDragStart(
    /** Event */
    evt,
    /** Touch */
    touch) {
      touch = touch || evt.pointerType == 'touch' && evt;

      if (!this.nativeDraggable || touch) {
        if (this.options.supportPointer) {
          on(document, 'pointermove', this._onTouchMove);
        } else if (touch) {
          on(document, 'touchmove', this._onTouchMove);
        } else {
          on(document, 'mousemove', this._onTouchMove);
        }
      } else {
        on(dragEl, 'dragend', this);
        on(rootEl, 'dragstart', this._onDragStart);
      }

      try {
        if (document.selection) {
          // Timeout neccessary for IE9
          _nextTick(function () {
            document.selection.empty();
          });
        } else {
          window.getSelection().removeAllRanges();
        }
      } catch (err) {}
    },
    _dragStarted: function _dragStarted(fallback, evt) {

      awaitingDragStarted = false;

      if (rootEl && dragEl) {
        pluginEvent('dragStarted', this, {
          evt: evt
        });

        if (this.nativeDraggable) {
          on(document, 'dragover', _checkOutsideTargetEl);
        }

        var options = this.options; // Apply effect

        !fallback && toggleClass(dragEl, options.dragClass, false);
        toggleClass(dragEl, options.ghostClass, true);
        Sortable.active = this;
        fallback && this._appendGhost(); // Drag start event

        _dispatchEvent({
          sortable: this,
          name: 'start',
          originalEvent: evt
        });
      } else {
        this._nulling();
      }
    },
    _emulateDragOver: function _emulateDragOver() {
      if (touchEvt) {
        this._lastX = touchEvt.clientX;
        this._lastY = touchEvt.clientY;

        _hideGhostForTarget();

        var target = document.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
        var parent = target;

        while (target && target.shadowRoot) {
          target = target.shadowRoot.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
          if (target === parent) { break; }
          parent = target;
        }

        dragEl.parentNode[expando]._isOutsideThisEl(target);

        if (parent) {
          do {
            if (parent[expando]) {
              var inserted = void 0;
              inserted = parent[expando]._onDragOver({
                clientX: touchEvt.clientX,
                clientY: touchEvt.clientY,
                target: target,
                rootEl: parent
              });

              if (inserted && !this.options.dragoverBubble) {
                break;
              }
            }

            target = parent; // store last element
          }
          /* jshint boss:true */
          while (parent = parent.parentNode);
        }

        _unhideGhostForTarget();
      }
    },
    _onTouchMove: function _onTouchMove(
    /**TouchEvent*/
    evt) {
      if (tapEvt) {
        var options = this.options,
            fallbackTolerance = options.fallbackTolerance,
            fallbackOffset = options.fallbackOffset,
            touch = evt.touches ? evt.touches[0] : evt,
            ghostMatrix = ghostEl && matrix(ghostEl, true),
            scaleX = ghostEl && ghostMatrix && ghostMatrix.a,
            scaleY = ghostEl && ghostMatrix && ghostMatrix.d,
            relativeScrollOffset = PositionGhostAbsolutely && ghostRelativeParent && getRelativeScrollOffset(ghostRelativeParent),
            dx = (touch.clientX - tapEvt.clientX + fallbackOffset.x) / (scaleX || 1) + (relativeScrollOffset ? relativeScrollOffset[0] - ghostRelativeParentInitialScroll[0] : 0) / (scaleX || 1),
            dy = (touch.clientY - tapEvt.clientY + fallbackOffset.y) / (scaleY || 1) + (relativeScrollOffset ? relativeScrollOffset[1] - ghostRelativeParentInitialScroll[1] : 0) / (scaleY || 1); // only set the status to dragging, when we are actually dragging

        if (!Sortable.active && !awaitingDragStarted) {
          if (fallbackTolerance && Math.max(Math.abs(touch.clientX - this._lastX), Math.abs(touch.clientY - this._lastY)) < fallbackTolerance) {
            return;
          }

          this._onDragStart(evt, true);
        }

        if (ghostEl) {
          if (ghostMatrix) {
            ghostMatrix.e += dx - (lastDx || 0);
            ghostMatrix.f += dy - (lastDy || 0);
          } else {
            ghostMatrix = {
              a: 1,
              b: 0,
              c: 0,
              d: 1,
              e: dx,
              f: dy
            };
          }

          var cssMatrix = "matrix(".concat(ghostMatrix.a, ",").concat(ghostMatrix.b, ",").concat(ghostMatrix.c, ",").concat(ghostMatrix.d, ",").concat(ghostMatrix.e, ",").concat(ghostMatrix.f, ")");
          css(ghostEl, 'webkitTransform', cssMatrix);
          css(ghostEl, 'mozTransform', cssMatrix);
          css(ghostEl, 'msTransform', cssMatrix);
          css(ghostEl, 'transform', cssMatrix);
          lastDx = dx;
          lastDy = dy;
          touchEvt = touch;
        }

        evt.cancelable && evt.preventDefault();
      }
    },
    _appendGhost: function _appendGhost() {
      // Bug if using scale(): https://stackoverflow.com/questions/2637058
      // Not being adjusted for
      if (!ghostEl) {
        var container = this.options.fallbackOnBody ? document.body : rootEl,
            rect = getRect(dragEl, true, PositionGhostAbsolutely, true, container),
            options = this.options; // Position absolutely

        if (PositionGhostAbsolutely) {
          // Get relatively positioned parent
          ghostRelativeParent = container;

          while (css(ghostRelativeParent, 'position') === 'static' && css(ghostRelativeParent, 'transform') === 'none' && ghostRelativeParent !== document) {
            ghostRelativeParent = ghostRelativeParent.parentNode;
          }

          if (ghostRelativeParent !== document.body && ghostRelativeParent !== document.documentElement) {
            if (ghostRelativeParent === document) { ghostRelativeParent = getWindowScrollingElement(); }
            rect.top += ghostRelativeParent.scrollTop;
            rect.left += ghostRelativeParent.scrollLeft;
          } else {
            ghostRelativeParent = getWindowScrollingElement();
          }

          ghostRelativeParentInitialScroll = getRelativeScrollOffset(ghostRelativeParent);
        }

        ghostEl = dragEl.cloneNode(true);
        toggleClass(ghostEl, options.ghostClass, false);
        toggleClass(ghostEl, options.fallbackClass, true);
        toggleClass(ghostEl, options.dragClass, true);
        css(ghostEl, 'transition', '');
        css(ghostEl, 'transform', '');
        css(ghostEl, 'box-sizing', 'border-box');
        css(ghostEl, 'margin', 0);
        css(ghostEl, 'top', rect.top);
        css(ghostEl, 'left', rect.left);
        css(ghostEl, 'width', rect.width);
        css(ghostEl, 'height', rect.height);
        css(ghostEl, 'opacity', '0.8');
        css(ghostEl, 'position', PositionGhostAbsolutely ? 'absolute' : 'fixed');
        css(ghostEl, 'zIndex', '100000');
        css(ghostEl, 'pointerEvents', 'none');
        Sortable.ghost = ghostEl;
        container.appendChild(ghostEl); // Set transform-origin

        css(ghostEl, 'transform-origin', tapDistanceLeft / parseInt(ghostEl.style.width) * 100 + '% ' + tapDistanceTop / parseInt(ghostEl.style.height) * 100 + '%');
      }
    },
    _onDragStart: function _onDragStart(
    /**Event*/
    evt,
    /**boolean*/
    fallback) {
      var _this = this;

      var dataTransfer = evt.dataTransfer;
      var options = _this.options;
      pluginEvent('dragStart', this, {
        evt: evt
      });

      if (Sortable.eventCanceled) {
        this._onDrop();

        return;
      }

      pluginEvent('setupClone', this);

      if (!Sortable.eventCanceled) {
        cloneEl = clone(dragEl);
        cloneEl.draggable = false;
        cloneEl.style['will-change'] = '';

        this._hideClone();

        toggleClass(cloneEl, this.options.chosenClass, false);
        Sortable.clone = cloneEl;
      } // #1143: IFrame support workaround


      _this.cloneId = _nextTick(function () {
        pluginEvent('clone', _this);
        if (Sortable.eventCanceled) { return; }

        if (!_this.options.removeCloneOnHide) {
          rootEl.insertBefore(cloneEl, dragEl);
        }

        _this._hideClone();

        _dispatchEvent({
          sortable: _this,
          name: 'clone'
        });
      });
      !fallback && toggleClass(dragEl, options.dragClass, true); // Set proper drop events

      if (fallback) {
        ignoreNextClick = true;
        _this._loopId = setInterval(_this._emulateDragOver, 50);
      } else {
        // Undo what was set in _prepareDragStart before drag started
        off(document, 'mouseup', _this._onDrop);
        off(document, 'touchend', _this._onDrop);
        off(document, 'touchcancel', _this._onDrop);

        if (dataTransfer) {
          dataTransfer.effectAllowed = 'move';
          options.setData && options.setData.call(_this, dataTransfer, dragEl);
        }

        on(document, 'drop', _this); // #1276 fix:

        css(dragEl, 'transform', 'translateZ(0)');
      }

      awaitingDragStarted = true;
      _this._dragStartId = _nextTick(_this._dragStarted.bind(_this, fallback, evt));
      on(document, 'selectstart', _this);
      moved = true;

      if (Safari) {
        css(document.body, 'user-select', 'none');
      }
    },
    // Returns true - if no further action is needed (either inserted or another condition)
    _onDragOver: function _onDragOver(
    /**Event*/
    evt) {
      var el = this.el,
          target = evt.target,
          dragRect,
          targetRect,
          revert,
          options = this.options,
          group = options.group,
          activeSortable = Sortable.active,
          isOwner = activeGroup === group,
          canSort = options.sort,
          fromSortable = putSortable || activeSortable,
          vertical,
          _this = this,
          completedFired = false;

      if (_silent) { return; }

      function dragOverEvent(name, extra) {
        pluginEvent(name, _this, _objectSpread({
          evt: evt,
          isOwner: isOwner,
          axis: vertical ? 'vertical' : 'horizontal',
          revert: revert,
          dragRect: dragRect,
          targetRect: targetRect,
          canSort: canSort,
          fromSortable: fromSortable,
          target: target,
          completed: completed,
          onMove: function onMove(target, after) {
            return _onMove(rootEl, el, dragEl, dragRect, target, getRect(target), evt, after);
          },
          changed: changed
        }, extra));
      } // Capture animation state


      function capture() {
        dragOverEvent('dragOverAnimationCapture');

        _this.captureAnimationState();

        if (_this !== fromSortable) {
          fromSortable.captureAnimationState();
        }
      } // Return invocation when dragEl is inserted (or completed)


      function completed(insertion) {
        dragOverEvent('dragOverCompleted', {
          insertion: insertion
        });

        if (insertion) {
          // Clones must be hidden before folding animation to capture dragRectAbsolute properly
          if (isOwner) {
            activeSortable._hideClone();
          } else {
            activeSortable._showClone(_this);
          }

          if (_this !== fromSortable) {
            // Set ghost class to new sortable's ghost class
            toggleClass(dragEl, putSortable ? putSortable.options.ghostClass : activeSortable.options.ghostClass, false);
            toggleClass(dragEl, options.ghostClass, true);
          }

          if (putSortable !== _this && _this !== Sortable.active) {
            putSortable = _this;
          } else if (_this === Sortable.active && putSortable) {
            putSortable = null;
          } // Animation


          if (fromSortable === _this) {
            _this._ignoreWhileAnimating = target;
          }

          _this.animateAll(function () {
            dragOverEvent('dragOverAnimationComplete');
            _this._ignoreWhileAnimating = null;
          });

          if (_this !== fromSortable) {
            fromSortable.animateAll();
            fromSortable._ignoreWhileAnimating = null;
          }
        } // Null lastTarget if it is not inside a previously swapped element


        if (target === dragEl && !dragEl.animated || target === el && !target.animated) {
          lastTarget = null;
        } // no bubbling and not fallback


        if (!options.dragoverBubble && !evt.rootEl && target !== document) {
          dragEl.parentNode[expando]._isOutsideThisEl(evt.target); // Do not detect for empty insert if already inserted


          !insertion && nearestEmptyInsertDetectEvent(evt);
        }

        !options.dragoverBubble && evt.stopPropagation && evt.stopPropagation();
        return completedFired = true;
      } // Call when dragEl has been inserted


      function changed() {
        newIndex = index(dragEl);
        newDraggableIndex = index(dragEl, options.draggable);

        _dispatchEvent({
          sortable: _this,
          name: 'change',
          toEl: el,
          newIndex: newIndex,
          newDraggableIndex: newDraggableIndex,
          originalEvent: evt
        });
      }

      if (evt.preventDefault !== void 0) {
        evt.cancelable && evt.preventDefault();
      }

      target = closest(target, options.draggable, el, true);
      dragOverEvent('dragOver');
      if (Sortable.eventCanceled) { return completedFired; }

      if (dragEl.contains(evt.target) || target.animated && target.animatingX && target.animatingY || _this._ignoreWhileAnimating === target) {
        return completed(false);
      }

      ignoreNextClick = false;

      if (activeSortable && !options.disabled && (isOwner ? canSort || (revert = !rootEl.contains(dragEl)) // Reverting item into the original list
      : putSortable === this || (this.lastPutMode = activeGroup.checkPull(this, activeSortable, dragEl, evt)) && group.checkPut(this, activeSortable, dragEl, evt))) {
        vertical = this._getDirection(evt, target) === 'vertical';
        dragRect = getRect(dragEl);
        dragOverEvent('dragOverValid');
        if (Sortable.eventCanceled) { return completedFired; }

        if (revert) {
          parentEl = rootEl; // actualization

          capture();

          this._hideClone();

          dragOverEvent('revert');

          if (!Sortable.eventCanceled) {
            if (nextEl) {
              rootEl.insertBefore(dragEl, nextEl);
            } else {
              rootEl.appendChild(dragEl);
            }
          }

          return completed(true);
        }

        var elLastChild = lastChild(el, options.draggable);

        if (!elLastChild || _ghostIsLast(evt, vertical, this) && !elLastChild.animated) {
          // If already at end of list: Do not insert
          if (elLastChild === dragEl) {
            return completed(false);
          } // assign target only if condition is true


          if (elLastChild && el === evt.target) {
            target = elLastChild;
          }

          if (target) {
            targetRect = getRect(target);
          }

          if (_onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, !!target) !== false) {
            capture();
            el.appendChild(dragEl);
            parentEl = el; // actualization

            changed();
            return completed(true);
          }
        } else if (target.parentNode === el) {
          targetRect = getRect(target);
          var direction = 0,
              targetBeforeFirstSwap,
              differentLevel = dragEl.parentNode !== el,
              differentRowCol = !_dragElInRowColumn(dragEl.animated && dragEl.toRect || dragRect, target.animated && target.toRect || targetRect, vertical),
              side1 = vertical ? 'top' : 'left',
              scrolledPastTop = isScrolledPast(target, 'top', 'top') || isScrolledPast(dragEl, 'top', 'top'),
              scrollBefore = scrolledPastTop ? scrolledPastTop.scrollTop : void 0;

          if (lastTarget !== target) {
            targetBeforeFirstSwap = targetRect[side1];
            pastFirstInvertThresh = false;
            isCircumstantialInvert = !differentRowCol && options.invertSwap || differentLevel;
          }

          direction = _getSwapDirection(evt, target, targetRect, vertical, differentRowCol ? 1 : options.swapThreshold, options.invertedSwapThreshold == null ? options.swapThreshold : options.invertedSwapThreshold, isCircumstantialInvert, lastTarget === target);
          var sibling;

          if (direction !== 0) {
            // Check if target is beside dragEl in respective direction (ignoring hidden elements)
            var dragIndex = index(dragEl);

            do {
              dragIndex -= direction;
              sibling = parentEl.children[dragIndex];
            } while (sibling && (css(sibling, 'display') === 'none' || sibling === ghostEl));
          } // If dragEl is already beside target: Do not insert


          if (direction === 0 || sibling === target) {
            return completed(false);
          }

          lastTarget = target;
          lastDirection = direction;
          var nextSibling = target.nextElementSibling,
              after = false;
          after = direction === 1;

          var moveVector = _onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, after);

          if (moveVector !== false) {
            if (moveVector === 1 || moveVector === -1) {
              after = moveVector === 1;
            }

            _silent = true;
            setTimeout(_unsilent, 30);
            capture();

            if (after && !nextSibling) {
              el.appendChild(dragEl);
            } else {
              target.parentNode.insertBefore(dragEl, after ? nextSibling : target);
            } // Undo chrome's scroll adjustment (has no effect on other browsers)


            if (scrolledPastTop) {
              scrollBy(scrolledPastTop, 0, scrollBefore - scrolledPastTop.scrollTop);
            }

            parentEl = dragEl.parentNode; // actualization
            // must be done before animation

            if (targetBeforeFirstSwap !== undefined && !isCircumstantialInvert) {
              targetMoveDistance = Math.abs(targetBeforeFirstSwap - getRect(target)[side1]);
            }

            changed();
            return completed(true);
          }
        }

        if (el.contains(dragEl)) {
          return completed(false);
        }
      }

      return false;
    },
    _ignoreWhileAnimating: null,
    _offMoveEvents: function _offMoveEvents() {
      off(document, 'mousemove', this._onTouchMove);
      off(document, 'touchmove', this._onTouchMove);
      off(document, 'pointermove', this._onTouchMove);
      off(document, 'dragover', nearestEmptyInsertDetectEvent);
      off(document, 'mousemove', nearestEmptyInsertDetectEvent);
      off(document, 'touchmove', nearestEmptyInsertDetectEvent);
    },
    _offUpEvents: function _offUpEvents() {
      var ownerDocument = this.el.ownerDocument;
      off(ownerDocument, 'mouseup', this._onDrop);
      off(ownerDocument, 'touchend', this._onDrop);
      off(ownerDocument, 'pointerup', this._onDrop);
      off(ownerDocument, 'touchcancel', this._onDrop);
      off(document, 'selectstart', this);
    },
    _onDrop: function _onDrop(
    /**Event*/
    evt) {
      var el = this.el,
          options = this.options; // Get the index of the dragged element within its parent

      newIndex = index(dragEl);
      newDraggableIndex = index(dragEl, options.draggable);
      pluginEvent('drop', this, {
        evt: evt
      });
      parentEl = dragEl && dragEl.parentNode; // Get again after plugin event

      newIndex = index(dragEl);
      newDraggableIndex = index(dragEl, options.draggable);

      if (Sortable.eventCanceled) {
        this._nulling();

        return;
      }

      awaitingDragStarted = false;
      isCircumstantialInvert = false;
      pastFirstInvertThresh = false;
      clearInterval(this._loopId);
      clearTimeout(this._dragStartTimer);

      _cancelNextTick(this.cloneId);

      _cancelNextTick(this._dragStartId); // Unbind events


      if (this.nativeDraggable) {
        off(document, 'drop', this);
        off(el, 'dragstart', this._onDragStart);
      }

      this._offMoveEvents();

      this._offUpEvents();

      if (Safari) {
        css(document.body, 'user-select', '');
      }

      css(dragEl, 'transform', '');

      if (evt) {
        if (moved) {
          evt.cancelable && evt.preventDefault();
          !options.dropBubble && evt.stopPropagation();
        }

        ghostEl && ghostEl.parentNode && ghostEl.parentNode.removeChild(ghostEl);

        if (rootEl === parentEl || putSortable && putSortable.lastPutMode !== 'clone') {
          // Remove clone(s)
          cloneEl && cloneEl.parentNode && cloneEl.parentNode.removeChild(cloneEl);
        }

        if (dragEl) {
          if (this.nativeDraggable) {
            off(dragEl, 'dragend', this);
          }

          _disableDraggable(dragEl);

          dragEl.style['will-change'] = ''; // Remove classes
          // ghostClass is added in dragStarted

          if (moved && !awaitingDragStarted) {
            toggleClass(dragEl, putSortable ? putSortable.options.ghostClass : this.options.ghostClass, false);
          }

          toggleClass(dragEl, this.options.chosenClass, false); // Drag stop event

          _dispatchEvent({
            sortable: this,
            name: 'unchoose',
            toEl: parentEl,
            newIndex: null,
            newDraggableIndex: null,
            originalEvent: evt
          });

          if (rootEl !== parentEl) {
            if (newIndex >= 0) {
              // Add event
              _dispatchEvent({
                rootEl: parentEl,
                name: 'add',
                toEl: parentEl,
                fromEl: rootEl,
                originalEvent: evt
              }); // Remove event


              _dispatchEvent({
                sortable: this,
                name: 'remove',
                toEl: parentEl,
                originalEvent: evt
              }); // drag from one list and drop into another


              _dispatchEvent({
                rootEl: parentEl,
                name: 'sort',
                toEl: parentEl,
                fromEl: rootEl,
                originalEvent: evt
              });

              _dispatchEvent({
                sortable: this,
                name: 'sort',
                toEl: parentEl,
                originalEvent: evt
              });
            }

            putSortable && putSortable.save();
          } else {
            if (newIndex !== oldIndex) {
              if (newIndex >= 0) {
                // drag & drop within the same list
                _dispatchEvent({
                  sortable: this,
                  name: 'update',
                  toEl: parentEl,
                  originalEvent: evt
                });

                _dispatchEvent({
                  sortable: this,
                  name: 'sort',
                  toEl: parentEl,
                  originalEvent: evt
                });
              }
            }
          }

          if (Sortable.active) {
            /* jshint eqnull:true */
            if (newIndex == null || newIndex === -1) {
              newIndex = oldIndex;
              newDraggableIndex = oldDraggableIndex;
            }

            _dispatchEvent({
              sortable: this,
              name: 'end',
              toEl: parentEl,
              originalEvent: evt
            }); // Save sorting


            this.save();
          }
        }
      }

      this._nulling();
    },
    _nulling: function _nulling() {
      pluginEvent('nulling', this);
      rootEl = dragEl = parentEl = ghostEl = nextEl = cloneEl = lastDownEl = cloneHidden = tapEvt = touchEvt = moved = newIndex = newDraggableIndex = oldIndex = oldDraggableIndex = lastTarget = lastDirection = putSortable = activeGroup = Sortable.dragged = Sortable.ghost = Sortable.clone = Sortable.active = null;
      savedInputChecked.forEach(function (el) {
        el.checked = true;
      });
      savedInputChecked.length = lastDx = lastDy = 0;
    },
    handleEvent: function handleEvent(
    /**Event*/
    evt) {
      switch (evt.type) {
        case 'drop':
        case 'dragend':
          this._onDrop(evt);

          break;

        case 'dragenter':
        case 'dragover':
          if (dragEl) {
            this._onDragOver(evt);

            _globalDragOver(evt);
          }

          break;

        case 'selectstart':
          evt.preventDefault();
          break;
      }
    },

    /**
     * Serializes the item into an array of string.
     * @returns {String[]}
     */
    toArray: function toArray() {
      var order = [],
          el,
          children = this.el.children,
          i = 0,
          n = children.length,
          options = this.options;

      for (; i < n; i++) {
        el = children[i];

        if (closest(el, options.draggable, this.el, false)) {
          order.push(el.getAttribute(options.dataIdAttr) || _generateId(el));
        }
      }

      return order;
    },

    /**
     * Sorts the elements according to the array.
     * @param  {String[]}  order  order of the items
     */
    sort: function sort(order) {
      var items = {},
          rootEl = this.el;
      this.toArray().forEach(function (id, i) {
        var el = rootEl.children[i];

        if (closest(el, this.options.draggable, rootEl, false)) {
          items[id] = el;
        }
      }, this);
      order.forEach(function (id) {
        if (items[id]) {
          rootEl.removeChild(items[id]);
          rootEl.appendChild(items[id]);
        }
      });
    },

    /**
     * Save the current sorting
     */
    save: function save() {
      var store = this.options.store;
      store && store.set && store.set(this);
    },

    /**
     * For each element in the set, get the first element that matches the selector by testing the element itself and traversing up through its ancestors in the DOM tree.
     * @param   {HTMLElement}  el
     * @param   {String}       [selector]  default: `options.draggable`
     * @returns {HTMLElement|null}
     */
    closest: function closest$1(el, selector) {
      return closest(el, selector || this.options.draggable, this.el, false);
    },

    /**
     * Set/get option
     * @param   {string} name
     * @param   {*}      [value]
     * @returns {*}
     */
    option: function option(name, value) {
      var options = this.options;

      if (value === void 0) {
        return options[name];
      } else {
        var modifiedValue = PluginManager.modifyOption(this, name, value);

        if (typeof modifiedValue !== 'undefined') {
          options[name] = modifiedValue;
        } else {
          options[name] = value;
        }

        if (name === 'group') {
          _prepareGroup(options);
        }
      }
    },

    /**
     * Destroy
     */
    destroy: function destroy() {
      pluginEvent('destroy', this);
      var el = this.el;
      el[expando] = null;
      off(el, 'mousedown', this._onTapStart);
      off(el, 'touchstart', this._onTapStart);
      off(el, 'pointerdown', this._onTapStart);

      if (this.nativeDraggable) {
        off(el, 'dragover', this);
        off(el, 'dragenter', this);
      } // Remove draggable attributes


      Array.prototype.forEach.call(el.querySelectorAll('[draggable]'), function (el) {
        el.removeAttribute('draggable');
      });

      this._onDrop();

      this._disableDelayedDragEvents();

      sortables.splice(sortables.indexOf(this.el), 1);
      this.el = el = null;
    },
    _hideClone: function _hideClone() {
      if (!cloneHidden) {
        pluginEvent('hideClone', this);
        if (Sortable.eventCanceled) { return; }
        css(cloneEl, 'display', 'none');

        if (this.options.removeCloneOnHide && cloneEl.parentNode) {
          cloneEl.parentNode.removeChild(cloneEl);
        }

        cloneHidden = true;
      }
    },
    _showClone: function _showClone(putSortable) {
      if (putSortable.lastPutMode !== 'clone') {
        this._hideClone();

        return;
      }

      if (cloneHidden) {
        pluginEvent('showClone', this);
        if (Sortable.eventCanceled) { return; } // show clone at dragEl or original position

        if (rootEl.contains(dragEl) && !this.options.group.revertClone) {
          rootEl.insertBefore(cloneEl, dragEl);
        } else if (nextEl) {
          rootEl.insertBefore(cloneEl, nextEl);
        } else {
          rootEl.appendChild(cloneEl);
        }

        if (this.options.group.revertClone) {
          this.animate(dragEl, cloneEl);
        }

        css(cloneEl, 'display', '');
        cloneHidden = false;
      }
    }
  };

  function _globalDragOver(
  /**Event*/
  evt) {
    if (evt.dataTransfer) {
      evt.dataTransfer.dropEffect = 'move';
    }

    evt.cancelable && evt.preventDefault();
  }

  function _onMove(fromEl, toEl, dragEl, dragRect, targetEl, targetRect, originalEvent, willInsertAfter) {
    var evt,
        sortable = fromEl[expando],
        onMoveFn = sortable.options.onMove,
        retVal; // Support for new CustomEvent feature

    if (window.CustomEvent && !IE11OrLess && !Edge) {
      evt = new CustomEvent('move', {
        bubbles: true,
        cancelable: true
      });
    } else {
      evt = document.createEvent('Event');
      evt.initEvent('move', true, true);
    }

    evt.to = toEl;
    evt.from = fromEl;
    evt.dragged = dragEl;
    evt.draggedRect = dragRect;
    evt.related = targetEl || toEl;
    evt.relatedRect = targetRect || getRect(toEl);
    evt.willInsertAfter = willInsertAfter;
    evt.originalEvent = originalEvent;
    fromEl.dispatchEvent(evt);

    if (onMoveFn) {
      retVal = onMoveFn.call(sortable, evt, originalEvent);
    }

    return retVal;
  }

  function _disableDraggable(el) {
    el.draggable = false;
  }

  function _unsilent() {
    _silent = false;
  }

  function _ghostIsLast(evt, vertical, sortable) {
    var rect = getRect(lastChild(sortable.el, sortable.options.draggable));
    var spacer = 10;
    return vertical ? evt.clientX > rect.right + spacer || evt.clientX <= rect.right && evt.clientY > rect.bottom && evt.clientX >= rect.left : evt.clientX > rect.right && evt.clientY > rect.top || evt.clientX <= rect.right && evt.clientY > rect.bottom + spacer;
  }

  function _getSwapDirection(evt, target, targetRect, vertical, swapThreshold, invertedSwapThreshold, invertSwap, isLastTarget) {
    var mouseOnAxis = vertical ? evt.clientY : evt.clientX,
        targetLength = vertical ? targetRect.height : targetRect.width,
        targetS1 = vertical ? targetRect.top : targetRect.left,
        targetS2 = vertical ? targetRect.bottom : targetRect.right,
        invert = false;

    if (!invertSwap) {
      // Never invert or create dragEl shadow when target movemenet causes mouse to move past the end of regular swapThreshold
      if (isLastTarget && targetMoveDistance < targetLength * swapThreshold) {
        // multiplied only by swapThreshold because mouse will already be inside target by (1 - threshold) * targetLength / 2
        // check if past first invert threshold on side opposite of lastDirection
        if (!pastFirstInvertThresh && (lastDirection === 1 ? mouseOnAxis > targetS1 + targetLength * invertedSwapThreshold / 2 : mouseOnAxis < targetS2 - targetLength * invertedSwapThreshold / 2)) {
          // past first invert threshold, do not restrict inverted threshold to dragEl shadow
          pastFirstInvertThresh = true;
        }

        if (!pastFirstInvertThresh) {
          // dragEl shadow (target move distance shadow)
          if (lastDirection === 1 ? mouseOnAxis < targetS1 + targetMoveDistance // over dragEl shadow
          : mouseOnAxis > targetS2 - targetMoveDistance) {
            return -lastDirection;
          }
        } else {
          invert = true;
        }
      } else {
        // Regular
        if (mouseOnAxis > targetS1 + targetLength * (1 - swapThreshold) / 2 && mouseOnAxis < targetS2 - targetLength * (1 - swapThreshold) / 2) {
          return _getInsertDirection(target);
        }
      }
    }

    invert = invert || invertSwap;

    if (invert) {
      // Invert of regular
      if (mouseOnAxis < targetS1 + targetLength * invertedSwapThreshold / 2 || mouseOnAxis > targetS2 - targetLength * invertedSwapThreshold / 2) {
        return mouseOnAxis > targetS1 + targetLength / 2 ? 1 : -1;
      }
    }

    return 0;
  }
  /**
   * Gets the direction dragEl must be swapped relative to target in order to make it
   * seem that dragEl has been "inserted" into that element's position
   * @param  {HTMLElement} target       The target whose position dragEl is being inserted at
   * @return {Number}                   Direction dragEl must be swapped
   */


  function _getInsertDirection(target) {
    if (index(dragEl) < index(target)) {
      return 1;
    } else {
      return -1;
    }
  }
  /**
   * Generate id
   * @param   {HTMLElement} el
   * @returns {String}
   * @private
   */


  function _generateId(el) {
    var str = el.tagName + el.className + el.src + el.href + el.textContent,
        i = str.length,
        sum = 0;

    while (i--) {
      sum += str.charCodeAt(i);
    }

    return sum.toString(36);
  }

  function _saveInputCheckedState(root) {
    savedInputChecked.length = 0;
    var inputs = root.getElementsByTagName('input');
    var idx = inputs.length;

    while (idx--) {
      var el = inputs[idx];
      el.checked && savedInputChecked.push(el);
    }
  }

  function _nextTick(fn) {
    return setTimeout(fn, 0);
  }

  function _cancelNextTick(id) {
    return clearTimeout(id);
  } // Fixed #973:


  if (documentExists) {
    on(document, 'touchmove', function (evt) {
      if ((Sortable.active || awaitingDragStarted) && evt.cancelable) {
        evt.preventDefault();
      }
    });
  } // Export utils


  Sortable.utils = {
    on: on,
    off: off,
    css: css,
    find: find,
    is: function is(el, selector) {
      return !!closest(el, selector, el, false);
    },
    extend: extend,
    throttle: throttle,
    closest: closest,
    toggleClass: toggleClass,
    clone: clone,
    index: index,
    nextTick: _nextTick,
    cancelNextTick: _cancelNextTick,
    detectDirection: _detectDirection,
    getChild: getChild
  };
  /**
   * Get the Sortable instance of an element
   * @param  {HTMLElement} element The element
   * @return {Sortable|undefined}         The instance of Sortable
   */

  Sortable.get = function (element) {
    return element[expando];
  };
  /**
   * Mount a plugin to Sortable
   * @param  {...SortablePlugin|SortablePlugin[]} plugins       Plugins being mounted
   */


  Sortable.mount = function () {
    var arguments$1 = arguments;

    for (var _len = arguments.length, plugins = new Array(_len), _key = 0; _key < _len; _key++) {
      plugins[_key] = arguments$1[_key];
    }

    if (plugins[0].constructor === Array) { plugins = plugins[0]; }
    plugins.forEach(function (plugin) {
      if (!plugin.prototype || !plugin.prototype.constructor) {
        throw "Sortable: Mounted plugin must be a constructor function, not ".concat({}.toString.call(plugin));
      }

      if (plugin.utils) { Sortable.utils = _objectSpread({}, Sortable.utils, plugin.utils); }
      PluginManager.mount(plugin);
    });
  };
  /**
   * Create sortable instance
   * @param {HTMLElement}  el
   * @param {Object}      [options]
   */


  Sortable.create = function (el, options) {
    return new Sortable(el, options);
  }; // Export


  Sortable.version = version;

  var autoScrolls = [],
      scrollEl,
      scrollRootEl,
      scrolling = false,
      lastAutoScrollX,
      lastAutoScrollY,
      touchEvt$1,
      pointerElemChangedInterval;

  function AutoScrollPlugin() {
    function AutoScroll() {
      this.defaults = {
        scroll: true,
        scrollSensitivity: 30,
        scrollSpeed: 10,
        bubbleScroll: true
      }; // Bind all private methods

      for (var fn in this) {
        if (fn.charAt(0) === '_' && typeof this[fn] === 'function') {
          this[fn] = this[fn].bind(this);
        }
      }
    }

    AutoScroll.prototype = {
      dragStarted: function dragStarted(_ref) {
        var originalEvent = _ref.originalEvent;

        if (this.sortable.nativeDraggable) {
          on(document, 'dragover', this._handleAutoScroll);
        } else {
          if (this.options.supportPointer) {
            on(document, 'pointermove', this._handleFallbackAutoScroll);
          } else if (originalEvent.touches) {
            on(document, 'touchmove', this._handleFallbackAutoScroll);
          } else {
            on(document, 'mousemove', this._handleFallbackAutoScroll);
          }
        }
      },
      dragOverCompleted: function dragOverCompleted(_ref2) {
        var originalEvent = _ref2.originalEvent;

        // For when bubbling is canceled and using fallback (fallback 'touchmove' always reached)
        if (!this.options.dragOverBubble && !originalEvent.rootEl) {
          this._handleAutoScroll(originalEvent);
        }
      },
      drop: function drop() {
        if (this.sortable.nativeDraggable) {
          off(document, 'dragover', this._handleAutoScroll);
        } else {
          off(document, 'pointermove', this._handleFallbackAutoScroll);
          off(document, 'touchmove', this._handleFallbackAutoScroll);
          off(document, 'mousemove', this._handleFallbackAutoScroll);
        }

        clearPointerElemChangedInterval();
        clearAutoScrolls();
        cancelThrottle();
      },
      nulling: function nulling() {
        touchEvt$1 = scrollRootEl = scrollEl = scrolling = pointerElemChangedInterval = lastAutoScrollX = lastAutoScrollY = null;
        autoScrolls.length = 0;
      },
      _handleFallbackAutoScroll: function _handleFallbackAutoScroll(evt) {
        this._handleAutoScroll(evt, true);
      },
      _handleAutoScroll: function _handleAutoScroll(evt, fallback) {
        var _this = this;

        var x = (evt.touches ? evt.touches[0] : evt).clientX,
            y = (evt.touches ? evt.touches[0] : evt).clientY,
            elem = document.elementFromPoint(x, y);
        touchEvt$1 = evt; // IE does not seem to have native autoscroll,
        // Edge's autoscroll seems too conditional,
        // MACOS Safari does not have autoscroll,
        // Firefox and Chrome are good

        if (fallback || Edge || IE11OrLess || Safari) {
          autoScroll(evt, this.options, elem, fallback); // Listener for pointer element change

          var ogElemScroller = getParentAutoScrollElement(elem, true);

          if (scrolling && (!pointerElemChangedInterval || x !== lastAutoScrollX || y !== lastAutoScrollY)) {
            pointerElemChangedInterval && clearPointerElemChangedInterval(); // Detect for pointer elem change, emulating native DnD behaviour

            pointerElemChangedInterval = setInterval(function () {
              var newElem = getParentAutoScrollElement(document.elementFromPoint(x, y), true);

              if (newElem !== ogElemScroller) {
                ogElemScroller = newElem;
                clearAutoScrolls();
              }

              autoScroll(evt, _this.options, newElem, fallback);
            }, 10);
            lastAutoScrollX = x;
            lastAutoScrollY = y;
          }
        } else {
          // if DnD is enabled (and browser has good autoscrolling), first autoscroll will already scroll, so get parent autoscroll of first autoscroll
          if (!this.options.bubbleScroll || getParentAutoScrollElement(elem, true) === getWindowScrollingElement()) {
            clearAutoScrolls();
            return;
          }

          autoScroll(evt, this.options, getParentAutoScrollElement(elem, false), false);
        }
      }
    };
    return _extends(AutoScroll, {
      pluginName: 'scroll',
      initializeByDefault: true
    });
  }

  function clearAutoScrolls() {
    autoScrolls.forEach(function (autoScroll) {
      clearInterval(autoScroll.pid);
    });
    autoScrolls = [];
  }

  function clearPointerElemChangedInterval() {
    clearInterval(pointerElemChangedInterval);
  }

  var autoScroll = throttle(function (evt, options, rootEl, isFallback) {
    // Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=505521
    if (!options.scroll) { return; }
    var x = (evt.touches ? evt.touches[0] : evt).clientX,
        y = (evt.touches ? evt.touches[0] : evt).clientY,
        sens = options.scrollSensitivity,
        speed = options.scrollSpeed,
        winScroller = getWindowScrollingElement();
    var scrollThisInstance = false,
        scrollCustomFn; // New scroll root, set scrollEl

    if (scrollRootEl !== rootEl) {
      scrollRootEl = rootEl;
      clearAutoScrolls();
      scrollEl = options.scroll;
      scrollCustomFn = options.scrollFn;

      if (scrollEl === true) {
        scrollEl = getParentAutoScrollElement(rootEl, true);
      }
    }

    var layersOut = 0;
    var currentParent = scrollEl;

    do {
      var el = currentParent,
          rect = getRect(el),
          top = rect.top,
          bottom = rect.bottom,
          left = rect.left,
          right = rect.right,
          width = rect.width,
          height = rect.height,
          canScrollX = void 0,
          canScrollY = void 0,
          scrollWidth = el.scrollWidth,
          scrollHeight = el.scrollHeight,
          elCSS = css(el),
          scrollPosX = el.scrollLeft,
          scrollPosY = el.scrollTop;

      if (el === winScroller) {
        canScrollX = width < scrollWidth && (elCSS.overflowX === 'auto' || elCSS.overflowX === 'scroll' || elCSS.overflowX === 'visible');
        canScrollY = height < scrollHeight && (elCSS.overflowY === 'auto' || elCSS.overflowY === 'scroll' || elCSS.overflowY === 'visible');
      } else {
        canScrollX = width < scrollWidth && (elCSS.overflowX === 'auto' || elCSS.overflowX === 'scroll');
        canScrollY = height < scrollHeight && (elCSS.overflowY === 'auto' || elCSS.overflowY === 'scroll');
      }

      var vx = canScrollX && (Math.abs(right - x) <= sens && scrollPosX + width < scrollWidth) - (Math.abs(left - x) <= sens && !!scrollPosX);
      var vy = canScrollY && (Math.abs(bottom - y) <= sens && scrollPosY + height < scrollHeight) - (Math.abs(top - y) <= sens && !!scrollPosY);

      if (!autoScrolls[layersOut]) {
        for (var i = 0; i <= layersOut; i++) {
          if (!autoScrolls[i]) {
            autoScrolls[i] = {};
          }
        }
      }

      if (autoScrolls[layersOut].vx != vx || autoScrolls[layersOut].vy != vy || autoScrolls[layersOut].el !== el) {
        autoScrolls[layersOut].el = el;
        autoScrolls[layersOut].vx = vx;
        autoScrolls[layersOut].vy = vy;
        clearInterval(autoScrolls[layersOut].pid);

        if (vx != 0 || vy != 0) {
          scrollThisInstance = true;
          /* jshint loopfunc:true */

          autoScrolls[layersOut].pid = setInterval(function () {
            // emulate drag over during autoscroll (fallback), emulating native DnD behaviour
            if (isFallback && this.layer === 0) {
              Sortable.active._onTouchMove(touchEvt$1); // To move ghost if it is positioned absolutely

            }

            var scrollOffsetY = autoScrolls[this.layer].vy ? autoScrolls[this.layer].vy * speed : 0;
            var scrollOffsetX = autoScrolls[this.layer].vx ? autoScrolls[this.layer].vx * speed : 0;

            if (typeof scrollCustomFn === 'function') {
              if (scrollCustomFn.call(Sortable.dragged.parentNode[expando], scrollOffsetX, scrollOffsetY, evt, touchEvt$1, autoScrolls[this.layer].el) !== 'continue') {
                return;
              }
            }

            scrollBy(autoScrolls[this.layer].el, scrollOffsetX, scrollOffsetY);
          }.bind({
            layer: layersOut
          }), 24);
        }
      }

      layersOut++;
    } while (options.bubbleScroll && currentParent !== winScroller && (currentParent = getParentAutoScrollElement(currentParent, false)));

    scrolling = scrollThisInstance; // in case another function catches scrolling as false in between when it is not
  }, 30);

  var drop = function drop(_ref) {
    var originalEvent = _ref.originalEvent,
        putSortable = _ref.putSortable,
        dragEl = _ref.dragEl,
        activeSortable = _ref.activeSortable,
        dispatchSortableEvent = _ref.dispatchSortableEvent,
        hideGhostForTarget = _ref.hideGhostForTarget,
        unhideGhostForTarget = _ref.unhideGhostForTarget;
    if (!originalEvent) { return; }
    var toSortable = putSortable || activeSortable;
    hideGhostForTarget();
    var touch = originalEvent.changedTouches && originalEvent.changedTouches.length ? originalEvent.changedTouches[0] : originalEvent;
    var target = document.elementFromPoint(touch.clientX, touch.clientY);
    unhideGhostForTarget();

    if (toSortable && !toSortable.el.contains(target)) {
      dispatchSortableEvent('spill');
      this.onSpill({
        dragEl: dragEl,
        putSortable: putSortable
      });
    }
  };

  function Revert() {}

  Revert.prototype = {
    startIndex: null,
    dragStart: function dragStart(_ref2) {
      var oldDraggableIndex = _ref2.oldDraggableIndex;
      this.startIndex = oldDraggableIndex;
    },
    onSpill: function onSpill(_ref3) {
      var dragEl = _ref3.dragEl,
          putSortable = _ref3.putSortable;
      this.sortable.captureAnimationState();

      if (putSortable) {
        putSortable.captureAnimationState();
      }

      var nextSibling = getChild(this.sortable.el, this.startIndex, this.options);

      if (nextSibling) {
        this.sortable.el.insertBefore(dragEl, nextSibling);
      } else {
        this.sortable.el.appendChild(dragEl);
      }

      this.sortable.animateAll();

      if (putSortable) {
        putSortable.animateAll();
      }
    },
    drop: drop
  };

  _extends(Revert, {
    pluginName: 'revertOnSpill'
  });

  function Remove() {}

  Remove.prototype = {
    onSpill: function onSpill(_ref4) {
      var dragEl = _ref4.dragEl,
          putSortable = _ref4.putSortable;
      var parentSortable = putSortable || this.sortable;
      parentSortable.captureAnimationState();
      dragEl.parentNode && dragEl.parentNode.removeChild(dragEl);
      parentSortable.animateAll();
    },
    drop: drop
  };

  _extends(Remove, {
    pluginName: 'removeOnSpill'
  });

  var lastSwapEl;

  function SwapPlugin() {
    function Swap() {
      this.defaults = {
        swapClass: 'sortable-swap-highlight'
      };
    }

    Swap.prototype = {
      dragStart: function dragStart(_ref) {
        var dragEl = _ref.dragEl;
        lastSwapEl = dragEl;
      },
      dragOverValid: function dragOverValid(_ref2) {
        var completed = _ref2.completed,
            target = _ref2.target,
            onMove = _ref2.onMove,
            activeSortable = _ref2.activeSortable,
            changed = _ref2.changed,
            cancel = _ref2.cancel;
        if (!activeSortable.options.swap) { return; }
        var el = this.sortable.el,
            options = this.options;

        if (target && target !== el) {
          var prevSwapEl = lastSwapEl;

          if (onMove(target) !== false) {
            toggleClass(target, options.swapClass, true);
            lastSwapEl = target;
          } else {
            lastSwapEl = null;
          }

          if (prevSwapEl && prevSwapEl !== lastSwapEl) {
            toggleClass(prevSwapEl, options.swapClass, false);
          }
        }

        changed();
        completed(true);
        cancel();
      },
      drop: function drop(_ref3) {
        var activeSortable = _ref3.activeSortable,
            putSortable = _ref3.putSortable,
            dragEl = _ref3.dragEl;
        var toSortable = putSortable || this.sortable;
        var options = this.options;
        lastSwapEl && toggleClass(lastSwapEl, options.swapClass, false);

        if (lastSwapEl && (options.swap || putSortable && putSortable.options.swap)) {
          if (dragEl !== lastSwapEl) {
            toSortable.captureAnimationState();
            if (toSortable !== activeSortable) { activeSortable.captureAnimationState(); }
            swapNodes(dragEl, lastSwapEl);
            toSortable.animateAll();
            if (toSortable !== activeSortable) { activeSortable.animateAll(); }
          }
        }
      },
      nulling: function nulling() {
        lastSwapEl = null;
      }
    };
    return _extends(Swap, {
      pluginName: 'swap',
      eventProperties: function eventProperties() {
        return {
          swapItem: lastSwapEl
        };
      }
    });
  }

  function swapNodes(n1, n2) {
    var p1 = n1.parentNode,
        p2 = n2.parentNode,
        i1,
        i2;
    if (!p1 || !p2 || p1.isEqualNode(n2) || p2.isEqualNode(n1)) { return; }
    i1 = index(n1);
    i2 = index(n2);

    if (p1.isEqualNode(p2) && i1 < i2) {
      i2++;
    }

    p1.insertBefore(n2, p1.children[i1]);
    p2.insertBefore(n1, p2.children[i2]);
  }

  var multiDragElements = [],
      multiDragClones = [],
      lastMultiDragSelect,
      // for selection with modifier key down (SHIFT)
  multiDragSortable,
      initialFolding = false,
      // Initial multi-drag fold when drag started
  folding = false,
      // Folding any other time
  dragStarted = false,
      dragEl$1,
      clonesFromRect,
      clonesHidden;

  function MultiDragPlugin() {
    function MultiDrag(sortable) {
      // Bind all private methods
      for (var fn in this) {
        if (fn.charAt(0) === '_' && typeof this[fn] === 'function') {
          this[fn] = this[fn].bind(this);
        }
      }

      if (sortable.options.supportPointer) {
        on(document, 'pointerup', this._deselectMultiDrag);
      } else {
        on(document, 'mouseup', this._deselectMultiDrag);
        on(document, 'touchend', this._deselectMultiDrag);
      }

      on(document, 'keydown', this._checkKeyDown);
      on(document, 'keyup', this._checkKeyUp);
      this.defaults = {
        selectedClass: 'sortable-selected',
        multiDragKey: null,
        setData: function setData(dataTransfer, dragEl) {
          var data = '';

          if (multiDragElements.length && multiDragSortable === sortable) {
            multiDragElements.forEach(function (multiDragElement, i) {
              data += (!i ? '' : ', ') + multiDragElement.textContent;
            });
          } else {
            data = dragEl.textContent;
          }

          dataTransfer.setData('Text', data);
        }
      };
    }

    MultiDrag.prototype = {
      multiDragKeyDown: false,
      isMultiDrag: false,
      delayStartGlobal: function delayStartGlobal(_ref) {
        var dragged = _ref.dragEl;
        dragEl$1 = dragged;
      },
      delayEnded: function delayEnded() {
        this.isMultiDrag = ~multiDragElements.indexOf(dragEl$1);
      },
      setupClone: function setupClone(_ref2) {
        var sortable = _ref2.sortable,
            cancel = _ref2.cancel;
        if (!this.isMultiDrag) { return; }

        for (var i = 0; i < multiDragElements.length; i++) {
          multiDragClones.push(clone(multiDragElements[i]));
          multiDragClones[i].sortableIndex = multiDragElements[i].sortableIndex;
          multiDragClones[i].draggable = false;
          multiDragClones[i].style['will-change'] = '';
          toggleClass(multiDragClones[i], this.options.selectedClass, false);
          multiDragElements[i] === dragEl$1 && toggleClass(multiDragClones[i], this.options.chosenClass, false);
        }

        sortable._hideClone();

        cancel();
      },
      clone: function clone(_ref3) {
        var sortable = _ref3.sortable,
            rootEl = _ref3.rootEl,
            dispatchSortableEvent = _ref3.dispatchSortableEvent,
            cancel = _ref3.cancel;
        if (!this.isMultiDrag) { return; }

        if (!this.options.removeCloneOnHide) {
          if (multiDragElements.length && multiDragSortable === sortable) {
            insertMultiDragClones(true, rootEl);
            dispatchSortableEvent('clone');
            cancel();
          }
        }
      },
      showClone: function showClone(_ref4) {
        var cloneNowShown = _ref4.cloneNowShown,
            rootEl = _ref4.rootEl,
            cancel = _ref4.cancel;
        if (!this.isMultiDrag) { return; }
        insertMultiDragClones(false, rootEl);
        multiDragClones.forEach(function (clone) {
          css(clone, 'display', '');
        });
        cloneNowShown();
        clonesHidden = false;
        cancel();
      },
      hideClone: function hideClone(_ref5) {
        var _this = this;

        _ref5.sortable;
            var cloneNowHidden = _ref5.cloneNowHidden,
            cancel = _ref5.cancel;
        if (!this.isMultiDrag) { return; }
        multiDragClones.forEach(function (clone) {
          css(clone, 'display', 'none');

          if (_this.options.removeCloneOnHide && clone.parentNode) {
            clone.parentNode.removeChild(clone);
          }
        });
        cloneNowHidden();
        clonesHidden = true;
        cancel();
      },
      dragStartGlobal: function dragStartGlobal(_ref6) {
        _ref6.sortable;

        if (!this.isMultiDrag && multiDragSortable) {
          multiDragSortable.multiDrag._deselectMultiDrag();
        }

        multiDragElements.forEach(function (multiDragElement) {
          multiDragElement.sortableIndex = index(multiDragElement);
        }); // Sort multi-drag elements

        multiDragElements = multiDragElements.sort(function (a, b) {
          return a.sortableIndex - b.sortableIndex;
        });
        dragStarted = true;
      },
      dragStarted: function dragStarted(_ref7) {
        var _this2 = this;

        var sortable = _ref7.sortable;
        if (!this.isMultiDrag) { return; }

        if (this.options.sort) {
          // Capture rects,
          // hide multi drag elements (by positioning them absolute),
          // set multi drag elements rects to dragRect,
          // show multi drag elements,
          // animate to rects,
          // unset rects & remove from DOM
          sortable.captureAnimationState();

          if (this.options.animation) {
            multiDragElements.forEach(function (multiDragElement) {
              if (multiDragElement === dragEl$1) { return; }
              css(multiDragElement, 'position', 'absolute');
            });
            var dragRect = getRect(dragEl$1, false, true, true);
            multiDragElements.forEach(function (multiDragElement) {
              if (multiDragElement === dragEl$1) { return; }
              setRect(multiDragElement, dragRect);
            });
            folding = true;
            initialFolding = true;
          }
        }

        sortable.animateAll(function () {
          folding = false;
          initialFolding = false;

          if (_this2.options.animation) {
            multiDragElements.forEach(function (multiDragElement) {
              unsetRect(multiDragElement);
            });
          } // Remove all auxiliary multidrag items from el, if sorting enabled


          if (_this2.options.sort) {
            removeMultiDragElements();
          }
        });
      },
      dragOver: function dragOver(_ref8) {
        var target = _ref8.target,
            completed = _ref8.completed,
            cancel = _ref8.cancel;

        if (folding && ~multiDragElements.indexOf(target)) {
          completed(false);
          cancel();
        }
      },
      revert: function revert(_ref9) {
        var fromSortable = _ref9.fromSortable,
            rootEl = _ref9.rootEl,
            sortable = _ref9.sortable,
            dragRect = _ref9.dragRect;

        if (multiDragElements.length > 1) {
          // Setup unfold animation
          multiDragElements.forEach(function (multiDragElement) {
            sortable.addAnimationState({
              target: multiDragElement,
              rect: folding ? getRect(multiDragElement) : dragRect
            });
            unsetRect(multiDragElement);
            multiDragElement.fromRect = dragRect;
            fromSortable.removeAnimationState(multiDragElement);
          });
          folding = false;
          insertMultiDragElements(!this.options.removeCloneOnHide, rootEl);
        }
      },
      dragOverCompleted: function dragOverCompleted(_ref10) {
        var sortable = _ref10.sortable,
            isOwner = _ref10.isOwner,
            insertion = _ref10.insertion,
            activeSortable = _ref10.activeSortable,
            parentEl = _ref10.parentEl,
            putSortable = _ref10.putSortable;
        var options = this.options;

        if (insertion) {
          // Clones must be hidden before folding animation to capture dragRectAbsolute properly
          if (isOwner) {
            activeSortable._hideClone();
          }

          initialFolding = false; // If leaving sort:false root, or already folding - Fold to new location

          if (options.animation && multiDragElements.length > 1 && (folding || !isOwner && !activeSortable.options.sort && !putSortable)) {
            // Fold: Set all multi drag elements's rects to dragEl's rect when multi-drag elements are invisible
            var dragRectAbsolute = getRect(dragEl$1, false, true, true);
            multiDragElements.forEach(function (multiDragElement) {
              if (multiDragElement === dragEl$1) { return; }
              setRect(multiDragElement, dragRectAbsolute); // Move element(s) to end of parentEl so that it does not interfere with multi-drag clones insertion if they are inserted
              // while folding, and so that we can capture them again because old sortable will no longer be fromSortable

              parentEl.appendChild(multiDragElement);
            });
            folding = true;
          } // Clones must be shown (and check to remove multi drags) after folding when interfering multiDragElements are moved out


          if (!isOwner) {
            // Only remove if not folding (folding will remove them anyways)
            if (!folding) {
              removeMultiDragElements();
            }

            if (multiDragElements.length > 1) {
              var clonesHiddenBefore = clonesHidden;

              activeSortable._showClone(sortable); // Unfold animation for clones if showing from hidden


              if (activeSortable.options.animation && !clonesHidden && clonesHiddenBefore) {
                multiDragClones.forEach(function (clone) {
                  activeSortable.addAnimationState({
                    target: clone,
                    rect: clonesFromRect
                  });
                  clone.fromRect = clonesFromRect;
                  clone.thisAnimationDuration = null;
                });
              }
            } else {
              activeSortable._showClone(sortable);
            }
          }
        }
      },
      dragOverAnimationCapture: function dragOverAnimationCapture(_ref11) {
        var dragRect = _ref11.dragRect,
            isOwner = _ref11.isOwner,
            activeSortable = _ref11.activeSortable;
        multiDragElements.forEach(function (multiDragElement) {
          multiDragElement.thisAnimationDuration = null;
        });

        if (activeSortable.options.animation && !isOwner && activeSortable.multiDrag.isMultiDrag) {
          clonesFromRect = _extends({}, dragRect);
          var dragMatrix = matrix(dragEl$1, true);
          clonesFromRect.top -= dragMatrix.f;
          clonesFromRect.left -= dragMatrix.e;
        }
      },
      dragOverAnimationComplete: function dragOverAnimationComplete() {
        if (folding) {
          folding = false;
          removeMultiDragElements();
        }
      },
      drop: function drop(_ref12) {
        var evt = _ref12.originalEvent,
            rootEl = _ref12.rootEl,
            parentEl = _ref12.parentEl,
            sortable = _ref12.sortable,
            dispatchSortableEvent = _ref12.dispatchSortableEvent,
            oldIndex = _ref12.oldIndex,
            putSortable = _ref12.putSortable;
        var toSortable = putSortable || this.sortable;
        if (!evt) { return; }
        var options = this.options,
            children = parentEl.children; // Multi-drag selection

        if (!dragStarted) {
          if (options.multiDragKey && !this.multiDragKeyDown) {
            this._deselectMultiDrag();
          }

          toggleClass(dragEl$1, options.selectedClass, !~multiDragElements.indexOf(dragEl$1));

          if (!~multiDragElements.indexOf(dragEl$1)) {
            multiDragElements.push(dragEl$1);
            dispatchEvent({
              sortable: sortable,
              rootEl: rootEl,
              name: 'select',
              targetEl: dragEl$1,
              originalEvt: evt
            }); // Modifier activated, select from last to dragEl

            if (evt.shiftKey && lastMultiDragSelect && sortable.el.contains(lastMultiDragSelect)) {
              var lastIndex = index(lastMultiDragSelect),
                  currentIndex = index(dragEl$1);

              if (~lastIndex && ~currentIndex && lastIndex !== currentIndex) {
                // Must include lastMultiDragSelect (select it), in case modified selection from no selection
                // (but previous selection existed)
                var n, i;

                if (currentIndex > lastIndex) {
                  i = lastIndex;
                  n = currentIndex;
                } else {
                  i = currentIndex;
                  n = lastIndex + 1;
                }

                for (; i < n; i++) {
                  if (~multiDragElements.indexOf(children[i])) { continue; }
                  toggleClass(children[i], options.selectedClass, true);
                  multiDragElements.push(children[i]);
                  dispatchEvent({
                    sortable: sortable,
                    rootEl: rootEl,
                    name: 'select',
                    targetEl: children[i],
                    originalEvt: evt
                  });
                }
              }
            } else {
              lastMultiDragSelect = dragEl$1;
            }

            multiDragSortable = toSortable;
          } else {
            multiDragElements.splice(multiDragElements.indexOf(dragEl$1), 1);
            lastMultiDragSelect = null;
            dispatchEvent({
              sortable: sortable,
              rootEl: rootEl,
              name: 'deselect',
              targetEl: dragEl$1,
              originalEvt: evt
            });
          }
        } // Multi-drag drop


        if (dragStarted && this.isMultiDrag) {
          // Do not "unfold" after around dragEl if reverted
          if ((parentEl[expando].options.sort || parentEl !== rootEl) && multiDragElements.length > 1) {
            var dragRect = getRect(dragEl$1),
                multiDragIndex = index(dragEl$1, ':not(.' + this.options.selectedClass + ')');
            if (!initialFolding && options.animation) { dragEl$1.thisAnimationDuration = null; }
            toSortable.captureAnimationState();

            if (!initialFolding) {
              if (options.animation) {
                dragEl$1.fromRect = dragRect;
                multiDragElements.forEach(function (multiDragElement) {
                  multiDragElement.thisAnimationDuration = null;

                  if (multiDragElement !== dragEl$1) {
                    var rect = folding ? getRect(multiDragElement) : dragRect;
                    multiDragElement.fromRect = rect; // Prepare unfold animation

                    toSortable.addAnimationState({
                      target: multiDragElement,
                      rect: rect
                    });
                  }
                });
              } // Multi drag elements are not necessarily removed from the DOM on drop, so to reinsert
              // properly they must all be removed


              removeMultiDragElements();
              multiDragElements.forEach(function (multiDragElement) {
                if (children[multiDragIndex]) {
                  parentEl.insertBefore(multiDragElement, children[multiDragIndex]);
                } else {
                  parentEl.appendChild(multiDragElement);
                }

                multiDragIndex++;
              }); // If initial folding is done, the elements may have changed position because they are now
              // unfolding around dragEl, even though dragEl may not have his index changed, so update event
              // must be fired here as Sortable will not.

              if (oldIndex === index(dragEl$1)) {
                var update = false;
                multiDragElements.forEach(function (multiDragElement) {
                  if (multiDragElement.sortableIndex !== index(multiDragElement)) {
                    update = true;
                    return;
                  }
                });

                if (update) {
                  dispatchSortableEvent('update');
                }
              }
            } // Must be done after capturing individual rects (scroll bar)


            multiDragElements.forEach(function (multiDragElement) {
              unsetRect(multiDragElement);
            });
            toSortable.animateAll();
          }

          multiDragSortable = toSortable;
        } // Remove clones if necessary


        if (rootEl === parentEl || putSortable && putSortable.lastPutMode !== 'clone') {
          multiDragClones.forEach(function (clone) {
            clone.parentNode && clone.parentNode.removeChild(clone);
          });
        }
      },
      nullingGlobal: function nullingGlobal() {
        this.isMultiDrag = dragStarted = false;
        multiDragClones.length = 0;
      },
      destroyGlobal: function destroyGlobal() {
        this._deselectMultiDrag();

        off(document, 'pointerup', this._deselectMultiDrag);
        off(document, 'mouseup', this._deselectMultiDrag);
        off(document, 'touchend', this._deselectMultiDrag);
        off(document, 'keydown', this._checkKeyDown);
        off(document, 'keyup', this._checkKeyUp);
      },
      _deselectMultiDrag: function _deselectMultiDrag(evt) {
        if (typeof dragStarted !== "undefined" && dragStarted) { return; } // Only deselect if selection is in this sortable

        if (multiDragSortable !== this.sortable) { return; } // Only deselect if target is not item in this sortable

        if (evt && closest(evt.target, this.options.draggable, this.sortable.el, false)) { return; } // Only deselect if left click

        if (evt && evt.button !== 0) { return; }

        while (multiDragElements.length) {
          var el = multiDragElements[0];
          toggleClass(el, this.options.selectedClass, false);
          multiDragElements.shift();
          dispatchEvent({
            sortable: this.sortable,
            rootEl: this.sortable.el,
            name: 'deselect',
            targetEl: el,
            originalEvt: evt
          });
        }
      },
      _checkKeyDown: function _checkKeyDown(evt) {
        if (evt.key === this.options.multiDragKey) {
          this.multiDragKeyDown = true;
        }
      },
      _checkKeyUp: function _checkKeyUp(evt) {
        if (evt.key === this.options.multiDragKey) {
          this.multiDragKeyDown = false;
        }
      }
    };
    return _extends(MultiDrag, {
      // Static methods & properties
      pluginName: 'multiDrag',
      utils: {
        /**
         * Selects the provided multi-drag item
         * @param  {HTMLElement} el    The element to be selected
         */
        select: function select(el) {
          var sortable = el.parentNode[expando];
          if (!sortable || !sortable.options.multiDrag || ~multiDragElements.indexOf(el)) { return; }

          if (multiDragSortable && multiDragSortable !== sortable) {
            multiDragSortable.multiDrag._deselectMultiDrag();

            multiDragSortable = sortable;
          }

          toggleClass(el, sortable.options.selectedClass, true);
          multiDragElements.push(el);
        },

        /**
         * Deselects the provided multi-drag item
         * @param  {HTMLElement} el    The element to be deselected
         */
        deselect: function deselect(el) {
          var sortable = el.parentNode[expando],
              index = multiDragElements.indexOf(el);
          if (!sortable || !sortable.options.multiDrag || !~index) { return; }
          toggleClass(el, sortable.options.selectedClass, false);
          multiDragElements.splice(index, 1);
        }
      },
      eventProperties: function eventProperties() {
        var _this3 = this;

        var oldIndicies = [],
            newIndicies = [];
        multiDragElements.forEach(function (multiDragElement) {
          oldIndicies.push({
            multiDragElement: multiDragElement,
            index: multiDragElement.sortableIndex
          }); // multiDragElements will already be sorted if folding

          var newIndex;

          if (folding && multiDragElement !== dragEl$1) {
            newIndex = -1;
          } else if (folding) {
            newIndex = index(multiDragElement, ':not(.' + _this3.options.selectedClass + ')');
          } else {
            newIndex = index(multiDragElement);
          }

          newIndicies.push({
            multiDragElement: multiDragElement,
            index: newIndex
          });
        });
        return {
          items: _toConsumableArray(multiDragElements),
          clones: [].concat(multiDragClones),
          oldIndicies: oldIndicies,
          newIndicies: newIndicies
        };
      },
      optionListeners: {
        multiDragKey: function multiDragKey(key) {
          key = key.toLowerCase();

          if (key === 'ctrl') {
            key = 'Control';
          } else if (key.length > 1) {
            key = key.charAt(0).toUpperCase() + key.substr(1);
          }

          return key;
        }
      }
    });
  }

  function insertMultiDragElements(clonesInserted, rootEl) {
    multiDragElements.forEach(function (multiDragElement, i) {
      var target = rootEl.children[multiDragElement.sortableIndex + (clonesInserted ? Number(i) : 0)];

      if (target) {
        rootEl.insertBefore(multiDragElement, target);
      } else {
        rootEl.appendChild(multiDragElement);
      }
    });
  }
  /**
   * Insert multi-drag clones
   * @param  {[Boolean]} elementsInserted  Whether the multi-drag elements are inserted
   * @param  {HTMLElement} rootEl
   */


  function insertMultiDragClones(elementsInserted, rootEl) {
    multiDragClones.forEach(function (clone, i) {
      var target = rootEl.children[clone.sortableIndex + (elementsInserted ? Number(i) : 0)];

      if (target) {
        rootEl.insertBefore(clone, target);
      } else {
        rootEl.appendChild(clone);
      }
    });
  }

  function removeMultiDragElements() {
    multiDragElements.forEach(function (multiDragElement) {
      if (multiDragElement === dragEl$1) { return; }
      multiDragElement.parentNode && multiDragElement.parentNode.removeChild(multiDragElement);
    });
  }

  Sortable.mount(new AutoScrollPlugin());
  Sortable.mount(Remove, Revert);

  var sortable_esm = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': Sortable,
    MultiDrag: MultiDragPlugin,
    Sortable: Sortable,
    Swap: SwapPlugin
  });

  var require$$0 = /*@__PURE__*/getAugmentedNamespace(sortable_esm);

  var vuedraggable_umd = createCommonjsModule(function (module, exports) {
  (function webpackUniversalModuleDefinition(root, factory) {
  	{ module.exports = factory(require$$0); }
  })((typeof self !== 'undefined' ? self : commonjsGlobal), function(__WEBPACK_EXTERNAL_MODULE_a352__) {
  return /******/ (function(modules) { // webpackBootstrap
  /******/ 	// The module cache
  /******/ 	var installedModules = {};
  /******/
  /******/ 	// The require function
  /******/ 	function __webpack_require__(moduleId) {
  /******/
  /******/ 		// Check if module is in cache
  /******/ 		if(installedModules[moduleId]) {
  /******/ 			return installedModules[moduleId].exports;
  /******/ 		}
  /******/ 		// Create a new module (and put it into the cache)
  /******/ 		var module = installedModules[moduleId] = {
  /******/ 			i: moduleId,
  /******/ 			l: false,
  /******/ 			exports: {}
  /******/ 		};
  /******/
  /******/ 		// Execute the module function
  /******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
  /******/
  /******/ 		// Flag the module as loaded
  /******/ 		module.l = true;
  /******/
  /******/ 		// Return the exports of the module
  /******/ 		return module.exports;
  /******/ 	}
  /******/
  /******/
  /******/ 	// expose the modules object (__webpack_modules__)
  /******/ 	__webpack_require__.m = modules;
  /******/
  /******/ 	// expose the module cache
  /******/ 	__webpack_require__.c = installedModules;
  /******/
  /******/ 	// define getter function for harmony exports
  /******/ 	__webpack_require__.d = function(exports, name, getter) {
  /******/ 		if(!__webpack_require__.o(exports, name)) {
  /******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
  /******/ 		}
  /******/ 	};
  /******/
  /******/ 	// define __esModule on exports
  /******/ 	__webpack_require__.r = function(exports) {
  /******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
  /******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
  /******/ 		}
  /******/ 		Object.defineProperty(exports, '__esModule', { value: true });
  /******/ 	};
  /******/
  /******/ 	// create a fake namespace object
  /******/ 	// mode & 1: value is a module id, require it
  /******/ 	// mode & 2: merge all properties of value into the ns
  /******/ 	// mode & 4: return value when already ns object
  /******/ 	// mode & 8|1: behave like require
  /******/ 	__webpack_require__.t = function(value, mode) {
  /******/ 		if(mode & 1) { value = __webpack_require__(value); }
  /******/ 		if(mode & 8) { return value; }
  /******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) { return value; }
  /******/ 		var ns = Object.create(null);
  /******/ 		__webpack_require__.r(ns);
  /******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
  /******/ 		if(mode & 2 && typeof value != 'string') { for(var key in value) { __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key)); } }
  /******/ 		return ns;
  /******/ 	};
  /******/
  /******/ 	// getDefaultExport function for compatibility with non-harmony modules
  /******/ 	__webpack_require__.n = function(module) {
  /******/ 		var getter = module && module.__esModule ?
  /******/ 			function getDefault() { return module['default']; } :
  /******/ 			function getModuleExports() { return module; };
  /******/ 		__webpack_require__.d(getter, 'a', getter);
  /******/ 		return getter;
  /******/ 	};
  /******/
  /******/ 	// Object.prototype.hasOwnProperty.call
  /******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
  /******/
  /******/ 	// __webpack_public_path__
  /******/ 	__webpack_require__.p = "";
  /******/
  /******/
  /******/ 	// Load entry module and return exports
  /******/ 	return __webpack_require__(__webpack_require__.s = "fb15");
  /******/ })
  /************************************************************************/
  /******/ ({

  /***/ "01f9":
  /***/ (function(module, exports, __webpack_require__) {

  var LIBRARY = __webpack_require__("2d00");
  var $export = __webpack_require__("5ca1");
  var redefine = __webpack_require__("2aba");
  var hide = __webpack_require__("32e9");
  var Iterators = __webpack_require__("84f2");
  var $iterCreate = __webpack_require__("41a0");
  var setToStringTag = __webpack_require__("7f20");
  var getPrototypeOf = __webpack_require__("38fd");
  var ITERATOR = __webpack_require__("2b4c")('iterator');
  var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
  var FF_ITERATOR = '@@iterator';
  var KEYS = 'keys';
  var VALUES = 'values';

  var returnThis = function () { return this; };

  module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
    $iterCreate(Constructor, NAME, next);
    var getMethod = function (kind) {
      if (!BUGGY && kind in proto) { return proto[kind]; }
      switch (kind) {
        case KEYS: return function keys() { return new Constructor(this, kind); };
        case VALUES: return function values() { return new Constructor(this, kind); };
      } return function entries() { return new Constructor(this, kind); };
    };
    var TAG = NAME + ' Iterator';
    var DEF_VALUES = DEFAULT == VALUES;
    var VALUES_BUG = false;
    var proto = Base.prototype;
    var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
    var $default = $native || getMethod(DEFAULT);
    var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
    var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
    var methods, key, IteratorPrototype;
    // Fix native
    if ($anyNative) {
      IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
      if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
        // Set @@toStringTag to native iterators
        setToStringTag(IteratorPrototype, TAG, true);
        // fix for some old engines
        if (!LIBRARY && typeof IteratorPrototype[ITERATOR] != 'function') { hide(IteratorPrototype, ITERATOR, returnThis); }
      }
    }
    // fix Array#{values, @@iterator}.name in V8 / FF
    if (DEF_VALUES && $native && $native.name !== VALUES) {
      VALUES_BUG = true;
      $default = function values() { return $native.call(this); };
    }
    // Define iterator
    if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
      hide(proto, ITERATOR, $default);
    }
    // Plug for library
    Iterators[NAME] = $default;
    Iterators[TAG] = returnThis;
    if (DEFAULT) {
      methods = {
        values: DEF_VALUES ? $default : getMethod(VALUES),
        keys: IS_SET ? $default : getMethod(KEYS),
        entries: $entries
      };
      if (FORCED) { for (key in methods) {
        if (!(key in proto)) { redefine(proto, key, methods[key]); }
      } } else { $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods); }
    }
    return methods;
  };


  /***/ }),

  /***/ "02f4":
  /***/ (function(module, exports, __webpack_require__) {

  var toInteger = __webpack_require__("4588");
  var defined = __webpack_require__("be13");
  // true  -> String#at
  // false -> String#codePointAt
  module.exports = function (TO_STRING) {
    return function (that, pos) {
      var s = String(defined(that));
      var i = toInteger(pos);
      var l = s.length;
      var a, b;
      if (i < 0 || i >= l) { return TO_STRING ? '' : undefined; }
      a = s.charCodeAt(i);
      return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
        ? TO_STRING ? s.charAt(i) : a
        : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
    };
  };


  /***/ }),

  /***/ "0390":
  /***/ (function(module, exports, __webpack_require__) {

  var at = __webpack_require__("02f4")(true);

   // `AdvanceStringIndex` abstract operation
  // https://tc39.github.io/ecma262/#sec-advancestringindex
  module.exports = function (S, index, unicode) {
    return index + (unicode ? at(S, index).length : 1);
  };


  /***/ }),

  /***/ "0bfb":
  /***/ (function(module, exports, __webpack_require__) {

  // 21.2.5.3 get RegExp.prototype.flags
  var anObject = __webpack_require__("cb7c");
  module.exports = function () {
    var that = anObject(this);
    var result = '';
    if (that.global) { result += 'g'; }
    if (that.ignoreCase) { result += 'i'; }
    if (that.multiline) { result += 'm'; }
    if (that.unicode) { result += 'u'; }
    if (that.sticky) { result += 'y'; }
    return result;
  };


  /***/ }),

  /***/ "0d58":
  /***/ (function(module, exports, __webpack_require__) {

  // 19.1.2.14 / 15.2.3.14 Object.keys(O)
  var $keys = __webpack_require__("ce10");
  var enumBugKeys = __webpack_require__("e11e");

  module.exports = Object.keys || function keys(O) {
    return $keys(O, enumBugKeys);
  };


  /***/ }),

  /***/ "1495":
  /***/ (function(module, exports, __webpack_require__) {

  var dP = __webpack_require__("86cc");
  var anObject = __webpack_require__("cb7c");
  var getKeys = __webpack_require__("0d58");

  module.exports = __webpack_require__("9e1e") ? Object.defineProperties : function defineProperties(O, Properties) {
    anObject(O);
    var keys = getKeys(Properties);
    var length = keys.length;
    var i = 0;
    var P;
    while (length > i) { dP.f(O, P = keys[i++], Properties[P]); }
    return O;
  };


  /***/ }),

  /***/ "214f":
  /***/ (function(module, exports, __webpack_require__) {

  __webpack_require__("b0c5");
  var redefine = __webpack_require__("2aba");
  var hide = __webpack_require__("32e9");
  var fails = __webpack_require__("79e5");
  var defined = __webpack_require__("be13");
  var wks = __webpack_require__("2b4c");
  var regexpExec = __webpack_require__("520a");

  var SPECIES = wks('species');

  var REPLACE_SUPPORTS_NAMED_GROUPS = !fails(function () {
    // #replace needs built-in support for named groups.
    // #match works fine because it just return the exec results, even if it has
    // a "grops" property.
    var re = /./;
    re.exec = function () {
      var result = [];
      result.groups = { a: '7' };
      return result;
    };
    return ''.replace(re, '$<a>') !== '7';
  });

  var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = (function () {
    // Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
    var re = /(?:)/;
    var originalExec = re.exec;
    re.exec = function () { return originalExec.apply(this, arguments); };
    var result = 'ab'.split(re);
    return result.length === 2 && result[0] === 'a' && result[1] === 'b';
  })();

  module.exports = function (KEY, length, exec) {
    var SYMBOL = wks(KEY);

    var DELEGATES_TO_SYMBOL = !fails(function () {
      // String methods call symbol-named RegEp methods
      var O = {};
      O[SYMBOL] = function () { return 7; };
      return ''[KEY](O) != 7;
    });

    var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL ? !fails(function () {
      // Symbol-named RegExp methods call .exec
      var execCalled = false;
      var re = /a/;
      re.exec = function () { execCalled = true; return null; };
      if (KEY === 'split') {
        // RegExp[@@split] doesn't call the regex's exec method, but first creates
        // a new one. We need to return the patched regex when creating the new one.
        re.constructor = {};
        re.constructor[SPECIES] = function () { return re; };
      }
      re[SYMBOL]('');
      return !execCalled;
    }) : undefined;

    if (
      !DELEGATES_TO_SYMBOL ||
      !DELEGATES_TO_EXEC ||
      (KEY === 'replace' && !REPLACE_SUPPORTS_NAMED_GROUPS) ||
      (KEY === 'split' && !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC)
    ) {
      var nativeRegExpMethod = /./[SYMBOL];
      var fns = exec(
        defined,
        SYMBOL,
        ''[KEY],
        function maybeCallNative(nativeMethod, regexp, str, arg2, forceStringMethod) {
          if (regexp.exec === regexpExec) {
            if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
              // The native String method already delegates to @@method (this
              // polyfilled function), leasing to infinite recursion.
              // We avoid it by directly calling the native @@method method.
              return { done: true, value: nativeRegExpMethod.call(regexp, str, arg2) };
            }
            return { done: true, value: nativeMethod.call(str, regexp, arg2) };
          }
          return { done: false };
        }
      );
      var strfn = fns[0];
      var rxfn = fns[1];

      redefine(String.prototype, KEY, strfn);
      hide(RegExp.prototype, SYMBOL, length == 2
        // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)
        // 21.2.5.11 RegExp.prototype[@@split](string, limit)
        ? function (string, arg) { return rxfn.call(string, this, arg); }
        // 21.2.5.6 RegExp.prototype[@@match](string)
        // 21.2.5.9 RegExp.prototype[@@search](string)
        : function (string) { return rxfn.call(string, this); }
      );
    }
  };


  /***/ }),

  /***/ "230e":
  /***/ (function(module, exports, __webpack_require__) {

  var isObject = __webpack_require__("d3f4");
  var document = __webpack_require__("7726").document;
  // typeof document.createElement is 'object' in old IE
  var is = isObject(document) && isObject(document.createElement);
  module.exports = function (it) {
    return is ? document.createElement(it) : {};
  };


  /***/ }),

  /***/ "23c6":
  /***/ (function(module, exports, __webpack_require__) {

  // getting tag from 19.1.3.6 Object.prototype.toString()
  var cof = __webpack_require__("2d95");
  var TAG = __webpack_require__("2b4c")('toStringTag');
  // ES3 wrong here
  var ARG = cof(function () { return arguments; }()) == 'Arguments';

  // fallback for IE11 Script Access Denied error
  var tryGet = function (it, key) {
    try {
      return it[key];
    } catch (e) { /* empty */ }
  };

  module.exports = function (it) {
    var O, T, B;
    return it === undefined ? 'Undefined' : it === null ? 'Null'
      // @@toStringTag case
      : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
      // builtinTag case
      : ARG ? cof(O)
      // ES3 arguments fallback
      : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
  };


  /***/ }),

  /***/ "2621":
  /***/ (function(module, exports) {

  exports.f = Object.getOwnPropertySymbols;


  /***/ }),

  /***/ "2aba":
  /***/ (function(module, exports, __webpack_require__) {

  var global = __webpack_require__("7726");
  var hide = __webpack_require__("32e9");
  var has = __webpack_require__("69a8");
  var SRC = __webpack_require__("ca5a")('src');
  var $toString = __webpack_require__("fa5b");
  var TO_STRING = 'toString';
  var TPL = ('' + $toString).split(TO_STRING);

  __webpack_require__("8378").inspectSource = function (it) {
    return $toString.call(it);
  };

  (module.exports = function (O, key, val, safe) {
    var isFunction = typeof val == 'function';
    if (isFunction) { has(val, 'name') || hide(val, 'name', key); }
    if (O[key] === val) { return; }
    if (isFunction) { has(val, SRC) || hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key))); }
    if (O === global) {
      O[key] = val;
    } else if (!safe) {
      delete O[key];
      hide(O, key, val);
    } else if (O[key]) {
      O[key] = val;
    } else {
      hide(O, key, val);
    }
  // add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
  })(Function.prototype, TO_STRING, function toString() {
    return typeof this == 'function' && this[SRC] || $toString.call(this);
  });


  /***/ }),

  /***/ "2aeb":
  /***/ (function(module, exports, __webpack_require__) {

  // 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
  var anObject = __webpack_require__("cb7c");
  var dPs = __webpack_require__("1495");
  var enumBugKeys = __webpack_require__("e11e");
  var IE_PROTO = __webpack_require__("613b")('IE_PROTO');
  var Empty = function () { /* empty */ };
  var PROTOTYPE = 'prototype';

  // Create object with fake `null` prototype: use iframe Object with cleared prototype
  var createDict = function () {
    // Thrash, waste and sodomy: IE GC bug
    var iframe = __webpack_require__("230e")('iframe');
    var i = enumBugKeys.length;
    var lt = '<';
    var gt = '>';
    var iframeDocument;
    iframe.style.display = 'none';
    __webpack_require__("fab2").appendChild(iframe);
    iframe.src = 'javascript:'; // eslint-disable-line no-script-url
    // createDict = iframe.contentWindow.Object;
    // html.removeChild(iframe);
    iframeDocument = iframe.contentWindow.document;
    iframeDocument.open();
    iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
    iframeDocument.close();
    createDict = iframeDocument.F;
    while (i--) { delete createDict[PROTOTYPE][enumBugKeys[i]]; }
    return createDict();
  };

  module.exports = Object.create || function create(O, Properties) {
    var result;
    if (O !== null) {
      Empty[PROTOTYPE] = anObject(O);
      result = new Empty();
      Empty[PROTOTYPE] = null;
      // add "__proto__" for Object.getPrototypeOf polyfill
      result[IE_PROTO] = O;
    } else { result = createDict(); }
    return Properties === undefined ? result : dPs(result, Properties);
  };


  /***/ }),

  /***/ "2b4c":
  /***/ (function(module, exports, __webpack_require__) {

  var store = __webpack_require__("5537")('wks');
  var uid = __webpack_require__("ca5a");
  var Symbol = __webpack_require__("7726").Symbol;
  var USE_SYMBOL = typeof Symbol == 'function';

  var $exports = module.exports = function (name) {
    return store[name] || (store[name] =
      USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
  };

  $exports.store = store;


  /***/ }),

  /***/ "2d00":
  /***/ (function(module, exports) {

  module.exports = false;


  /***/ }),

  /***/ "2d95":
  /***/ (function(module, exports) {

  var toString = {}.toString;

  module.exports = function (it) {
    return toString.call(it).slice(8, -1);
  };


  /***/ }),

  /***/ "2fdb":
  /***/ (function(module, exports, __webpack_require__) {
  // 21.1.3.7 String.prototype.includes(searchString, position = 0)

  var $export = __webpack_require__("5ca1");
  var context = __webpack_require__("d2c8");
  var INCLUDES = 'includes';

  $export($export.P + $export.F * __webpack_require__("5147")(INCLUDES), 'String', {
    includes: function includes(searchString /* , position = 0 */) {
      return !!~context(this, searchString, INCLUDES)
        .indexOf(searchString, arguments.length > 1 ? arguments[1] : undefined);
    }
  });


  /***/ }),

  /***/ "32e9":
  /***/ (function(module, exports, __webpack_require__) {

  var dP = __webpack_require__("86cc");
  var createDesc = __webpack_require__("4630");
  module.exports = __webpack_require__("9e1e") ? function (object, key, value) {
    return dP.f(object, key, createDesc(1, value));
  } : function (object, key, value) {
    object[key] = value;
    return object;
  };


  /***/ }),

  /***/ "38fd":
  /***/ (function(module, exports, __webpack_require__) {

  // 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
  var has = __webpack_require__("69a8");
  var toObject = __webpack_require__("4bf8");
  var IE_PROTO = __webpack_require__("613b")('IE_PROTO');
  var ObjectProto = Object.prototype;

  module.exports = Object.getPrototypeOf || function (O) {
    O = toObject(O);
    if (has(O, IE_PROTO)) { return O[IE_PROTO]; }
    if (typeof O.constructor == 'function' && O instanceof O.constructor) {
      return O.constructor.prototype;
    } return O instanceof Object ? ObjectProto : null;
  };


  /***/ }),

  /***/ "41a0":
  /***/ (function(module, exports, __webpack_require__) {

  var create = __webpack_require__("2aeb");
  var descriptor = __webpack_require__("4630");
  var setToStringTag = __webpack_require__("7f20");
  var IteratorPrototype = {};

  // 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
  __webpack_require__("32e9")(IteratorPrototype, __webpack_require__("2b4c")('iterator'), function () { return this; });

  module.exports = function (Constructor, NAME, next) {
    Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });
    setToStringTag(Constructor, NAME + ' Iterator');
  };


  /***/ }),

  /***/ "456d":
  /***/ (function(module, exports, __webpack_require__) {

  // 19.1.2.14 Object.keys(O)
  var toObject = __webpack_require__("4bf8");
  var $keys = __webpack_require__("0d58");

  __webpack_require__("5eda")('keys', function () {
    return function keys(it) {
      return $keys(toObject(it));
    };
  });


  /***/ }),

  /***/ "4588":
  /***/ (function(module, exports) {

  // 7.1.4 ToInteger
  var ceil = Math.ceil;
  var floor = Math.floor;
  module.exports = function (it) {
    return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
  };


  /***/ }),

  /***/ "4630":
  /***/ (function(module, exports) {

  module.exports = function (bitmap, value) {
    return {
      enumerable: !(bitmap & 1),
      configurable: !(bitmap & 2),
      writable: !(bitmap & 4),
      value: value
    };
  };


  /***/ }),

  /***/ "4bf8":
  /***/ (function(module, exports, __webpack_require__) {

  // 7.1.13 ToObject(argument)
  var defined = __webpack_require__("be13");
  module.exports = function (it) {
    return Object(defined(it));
  };


  /***/ }),

  /***/ "5147":
  /***/ (function(module, exports, __webpack_require__) {

  var MATCH = __webpack_require__("2b4c")('match');
  module.exports = function (KEY) {
    var re = /./;
    try {
      '/./'[KEY](re);
    } catch (e) {
      try {
        re[MATCH] = false;
        return !'/./'[KEY](re);
      } catch (f) { /* empty */ }
    } return true;
  };


  /***/ }),

  /***/ "520a":
  /***/ (function(module, exports, __webpack_require__) {


  var regexpFlags = __webpack_require__("0bfb");

  var nativeExec = RegExp.prototype.exec;
  // This always refers to the native implementation, because the
  // String#replace polyfill uses ./fix-regexp-well-known-symbol-logic.js,
  // which loads this file before patching the method.
  var nativeReplace = String.prototype.replace;

  var patchedExec = nativeExec;

  var LAST_INDEX = 'lastIndex';

  var UPDATES_LAST_INDEX_WRONG = (function () {
    var re1 = /a/,
        re2 = /b*/g;
    nativeExec.call(re1, 'a');
    nativeExec.call(re2, 'a');
    return re1[LAST_INDEX] !== 0 || re2[LAST_INDEX] !== 0;
  })();

  // nonparticipating capturing group, copied from es5-shim's String#split patch.
  var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;

  var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED;

  if (PATCH) {
    patchedExec = function exec(str) {
      var re = this;
      var lastIndex, reCopy, match, i;

      if (NPCG_INCLUDED) {
        reCopy = new RegExp('^' + re.source + '$(?!\\s)', regexpFlags.call(re));
      }
      if (UPDATES_LAST_INDEX_WRONG) { lastIndex = re[LAST_INDEX]; }

      match = nativeExec.call(re, str);

      if (UPDATES_LAST_INDEX_WRONG && match) {
        re[LAST_INDEX] = re.global ? match.index + match[0].length : lastIndex;
      }
      if (NPCG_INCLUDED && match && match.length > 1) {
        // Fix browsers whose `exec` methods don't consistently return `undefined`
        // for NPCG, like IE8. NOTE: This doesn' work for /(.?)?/
        // eslint-disable-next-line no-loop-func
        nativeReplace.call(match[0], reCopy, function () {
          var arguments$1 = arguments;

          for (i = 1; i < arguments.length - 2; i++) {
            if (arguments$1[i] === undefined) { match[i] = undefined; }
          }
        });
      }

      return match;
    };
  }

  module.exports = patchedExec;


  /***/ }),

  /***/ "52a7":
  /***/ (function(module, exports) {

  exports.f = {}.propertyIsEnumerable;


  /***/ }),

  /***/ "5537":
  /***/ (function(module, exports, __webpack_require__) {

  var core = __webpack_require__("8378");
  var global = __webpack_require__("7726");
  var SHARED = '__core-js_shared__';
  var store = global[SHARED] || (global[SHARED] = {});

  (module.exports = function (key, value) {
    return store[key] || (store[key] = value !== undefined ? value : {});
  })('versions', []).push({
    version: core.version,
    mode: __webpack_require__("2d00") ? 'pure' : 'global',
    copyright: '© 2019 Denis Pushkarev (zloirock.ru)'
  });


  /***/ }),

  /***/ "5ca1":
  /***/ (function(module, exports, __webpack_require__) {

  var global = __webpack_require__("7726");
  var core = __webpack_require__("8378");
  var hide = __webpack_require__("32e9");
  var redefine = __webpack_require__("2aba");
  var ctx = __webpack_require__("9b43");
  var PROTOTYPE = 'prototype';

  var $export = function (type, name, source) {
    var IS_FORCED = type & $export.F;
    var IS_GLOBAL = type & $export.G;
    var IS_STATIC = type & $export.S;
    var IS_PROTO = type & $export.P;
    var IS_BIND = type & $export.B;
    var target = IS_GLOBAL ? global : IS_STATIC ? global[name] || (global[name] = {}) : (global[name] || {})[PROTOTYPE];
    var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
    var expProto = exports[PROTOTYPE] || (exports[PROTOTYPE] = {});
    var key, own, out, exp;
    if (IS_GLOBAL) { source = name; }
    for (key in source) {
      // contains in native
      own = !IS_FORCED && target && target[key] !== undefined;
      // export native or passed
      out = (own ? target : source)[key];
      // bind timers to global for call from export context
      exp = IS_BIND && own ? ctx(out, global) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
      // extend global
      if (target) { redefine(target, key, out, type & $export.U); }
      // export
      if (exports[key] != out) { hide(exports, key, exp); }
      if (IS_PROTO && expProto[key] != out) { expProto[key] = out; }
    }
  };
  global.core = core;
  // type bitmap
  $export.F = 1;   // forced
  $export.G = 2;   // global
  $export.S = 4;   // static
  $export.P = 8;   // proto
  $export.B = 16;  // bind
  $export.W = 32;  // wrap
  $export.U = 64;  // safe
  $export.R = 128; // real proto method for `library`
  module.exports = $export;


  /***/ }),

  /***/ "5eda":
  /***/ (function(module, exports, __webpack_require__) {

  // most Object methods by ES6 should accept primitives
  var $export = __webpack_require__("5ca1");
  var core = __webpack_require__("8378");
  var fails = __webpack_require__("79e5");
  module.exports = function (KEY, exec) {
    var fn = (core.Object || {})[KEY] || Object[KEY];
    var exp = {};
    exp[KEY] = exec(fn);
    $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
  };


  /***/ }),

  /***/ "5f1b":
  /***/ (function(module, exports, __webpack_require__) {


  var classof = __webpack_require__("23c6");
  var builtinExec = RegExp.prototype.exec;

   // `RegExpExec` abstract operation
  // https://tc39.github.io/ecma262/#sec-regexpexec
  module.exports = function (R, S) {
    var exec = R.exec;
    if (typeof exec === 'function') {
      var result = exec.call(R, S);
      if (typeof result !== 'object') {
        throw new TypeError('RegExp exec method returned something other than an Object or null');
      }
      return result;
    }
    if (classof(R) !== 'RegExp') {
      throw new TypeError('RegExp#exec called on incompatible receiver');
    }
    return builtinExec.call(R, S);
  };


  /***/ }),

  /***/ "613b":
  /***/ (function(module, exports, __webpack_require__) {

  var shared = __webpack_require__("5537")('keys');
  var uid = __webpack_require__("ca5a");
  module.exports = function (key) {
    return shared[key] || (shared[key] = uid(key));
  };


  /***/ }),

  /***/ "626a":
  /***/ (function(module, exports, __webpack_require__) {

  // fallback for non-array-like ES3 and non-enumerable old V8 strings
  var cof = __webpack_require__("2d95");
  // eslint-disable-next-line no-prototype-builtins
  module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
    return cof(it) == 'String' ? it.split('') : Object(it);
  };


  /***/ }),

  /***/ "6762":
  /***/ (function(module, exports, __webpack_require__) {

  // https://github.com/tc39/Array.prototype.includes
  var $export = __webpack_require__("5ca1");
  var $includes = __webpack_require__("c366")(true);

  $export($export.P, 'Array', {
    includes: function includes(el /* , fromIndex = 0 */) {
      return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
    }
  });

  __webpack_require__("9c6c")('includes');


  /***/ }),

  /***/ "6821":
  /***/ (function(module, exports, __webpack_require__) {

  // to indexed object, toObject with fallback for non-array-like ES3 strings
  var IObject = __webpack_require__("626a");
  var defined = __webpack_require__("be13");
  module.exports = function (it) {
    return IObject(defined(it));
  };


  /***/ }),

  /***/ "69a8":
  /***/ (function(module, exports) {

  var hasOwnProperty = {}.hasOwnProperty;
  module.exports = function (it, key) {
    return hasOwnProperty.call(it, key);
  };


  /***/ }),

  /***/ "6a99":
  /***/ (function(module, exports, __webpack_require__) {

  // 7.1.1 ToPrimitive(input [, PreferredType])
  var isObject = __webpack_require__("d3f4");
  // instead of the ES6 spec version, we didn't implement @@toPrimitive case
  // and the second argument - flag - preferred type is a string
  module.exports = function (it, S) {
    if (!isObject(it)) { return it; }
    var fn, val;
    if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) { return val; }
    if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) { return val; }
    if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) { return val; }
    throw TypeError("Can't convert object to primitive value");
  };


  /***/ }),

  /***/ "7333":
  /***/ (function(module, exports, __webpack_require__) {

  // 19.1.2.1 Object.assign(target, source, ...)
  var getKeys = __webpack_require__("0d58");
  var gOPS = __webpack_require__("2621");
  var pIE = __webpack_require__("52a7");
  var toObject = __webpack_require__("4bf8");
  var IObject = __webpack_require__("626a");
  var $assign = Object.assign;

  // should work with symbols and should have deterministic property order (V8 bug)
  module.exports = !$assign || __webpack_require__("79e5")(function () {
    var A = {};
    var B = {};
    // eslint-disable-next-line no-undef
    var S = Symbol();
    var K = 'abcdefghijklmnopqrst';
    A[S] = 7;
    K.split('').forEach(function (k) { B[k] = k; });
    return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
  }) ? function assign(target, source) {
    var arguments$1 = arguments;
   // eslint-disable-line no-unused-vars
    var T = toObject(target);
    var aLen = arguments.length;
    var index = 1;
    var getSymbols = gOPS.f;
    var isEnum = pIE.f;
    while (aLen > index) {
      var S = IObject(arguments$1[index++]);
      var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
      var length = keys.length;
      var j = 0;
      var key;
      while (length > j) { if (isEnum.call(S, key = keys[j++])) { T[key] = S[key]; } }
    } return T;
  } : $assign;


  /***/ }),

  /***/ "7726":
  /***/ (function(module, exports) {

  // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
  var global = module.exports = typeof window != 'undefined' && window.Math == Math
    ? window : typeof self != 'undefined' && self.Math == Math ? self
    // eslint-disable-next-line no-new-func
    : Function('return this')();
  if (typeof __g == 'number') { __g = global; } // eslint-disable-line no-undef


  /***/ }),

  /***/ "77f1":
  /***/ (function(module, exports, __webpack_require__) {

  var toInteger = __webpack_require__("4588");
  var max = Math.max;
  var min = Math.min;
  module.exports = function (index, length) {
    index = toInteger(index);
    return index < 0 ? max(index + length, 0) : min(index, length);
  };


  /***/ }),

  /***/ "79e5":
  /***/ (function(module, exports) {

  module.exports = function (exec) {
    try {
      return !!exec();
    } catch (e) {
      return true;
    }
  };


  /***/ }),

  /***/ "7f20":
  /***/ (function(module, exports, __webpack_require__) {

  var def = __webpack_require__("86cc").f;
  var has = __webpack_require__("69a8");
  var TAG = __webpack_require__("2b4c")('toStringTag');

  module.exports = function (it, tag, stat) {
    if (it && !has(it = stat ? it : it.prototype, TAG)) { def(it, TAG, { configurable: true, value: tag }); }
  };


  /***/ }),

  /***/ "8378":
  /***/ (function(module, exports) {

  var core = module.exports = { version: '2.6.5' };
  if (typeof __e == 'number') { __e = core; } // eslint-disable-line no-undef


  /***/ }),

  /***/ "84f2":
  /***/ (function(module, exports) {

  module.exports = {};


  /***/ }),

  /***/ "86cc":
  /***/ (function(module, exports, __webpack_require__) {

  var anObject = __webpack_require__("cb7c");
  var IE8_DOM_DEFINE = __webpack_require__("c69a");
  var toPrimitive = __webpack_require__("6a99");
  var dP = Object.defineProperty;

  exports.f = __webpack_require__("9e1e") ? Object.defineProperty : function defineProperty(O, P, Attributes) {
    anObject(O);
    P = toPrimitive(P, true);
    anObject(Attributes);
    if (IE8_DOM_DEFINE) { try {
      return dP(O, P, Attributes);
    } catch (e) { /* empty */ } }
    if ('get' in Attributes || 'set' in Attributes) { throw TypeError('Accessors not supported!'); }
    if ('value' in Attributes) { O[P] = Attributes.value; }
    return O;
  };


  /***/ }),

  /***/ "9b43":
  /***/ (function(module, exports, __webpack_require__) {

  // optional / simple context binding
  var aFunction = __webpack_require__("d8e8");
  module.exports = function (fn, that, length) {
    aFunction(fn);
    if (that === undefined) { return fn; }
    switch (length) {
      case 1: return function (a) {
        return fn.call(that, a);
      };
      case 2: return function (a, b) {
        return fn.call(that, a, b);
      };
      case 3: return function (a, b, c) {
        return fn.call(that, a, b, c);
      };
    }
    return function (/* ...args */) {
      return fn.apply(that, arguments);
    };
  };


  /***/ }),

  /***/ "9c6c":
  /***/ (function(module, exports, __webpack_require__) {

  // 22.1.3.31 Array.prototype[@@unscopables]
  var UNSCOPABLES = __webpack_require__("2b4c")('unscopables');
  var ArrayProto = Array.prototype;
  if (ArrayProto[UNSCOPABLES] == undefined) { __webpack_require__("32e9")(ArrayProto, UNSCOPABLES, {}); }
  module.exports = function (key) {
    ArrayProto[UNSCOPABLES][key] = true;
  };


  /***/ }),

  /***/ "9def":
  /***/ (function(module, exports, __webpack_require__) {

  // 7.1.15 ToLength
  var toInteger = __webpack_require__("4588");
  var min = Math.min;
  module.exports = function (it) {
    return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
  };


  /***/ }),

  /***/ "9e1e":
  /***/ (function(module, exports, __webpack_require__) {

  // Thank's IE8 for his funny defineProperty
  module.exports = !__webpack_require__("79e5")(function () {
    return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
  });


  /***/ }),

  /***/ "a352":
  /***/ (function(module, exports) {

  module.exports = __WEBPACK_EXTERNAL_MODULE_a352__;

  /***/ }),

  /***/ "a481":
  /***/ (function(module, exports, __webpack_require__) {


  var anObject = __webpack_require__("cb7c");
  var toObject = __webpack_require__("4bf8");
  var toLength = __webpack_require__("9def");
  var toInteger = __webpack_require__("4588");
  var advanceStringIndex = __webpack_require__("0390");
  var regExpExec = __webpack_require__("5f1b");
  var max = Math.max;
  var min = Math.min;
  var floor = Math.floor;
  var SUBSTITUTION_SYMBOLS = /\$([$&`']|\d\d?|<[^>]*>)/g;
  var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&`']|\d\d?)/g;

  var maybeToString = function (it) {
    return it === undefined ? it : String(it);
  };

  // @@replace logic
  __webpack_require__("214f")('replace', 2, function (defined, REPLACE, $replace, maybeCallNative) {
    return [
      // `String.prototype.replace` method
      // https://tc39.github.io/ecma262/#sec-string.prototype.replace
      function replace(searchValue, replaceValue) {
        var O = defined(this);
        var fn = searchValue == undefined ? undefined : searchValue[REPLACE];
        return fn !== undefined
          ? fn.call(searchValue, O, replaceValue)
          : $replace.call(String(O), searchValue, replaceValue);
      },
      // `RegExp.prototype[@@replace]` method
      // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@replace
      function (regexp, replaceValue) {
        var res = maybeCallNative($replace, regexp, this, replaceValue);
        if (res.done) { return res.value; }

        var rx = anObject(regexp);
        var S = String(this);
        var functionalReplace = typeof replaceValue === 'function';
        if (!functionalReplace) { replaceValue = String(replaceValue); }
        var global = rx.global;
        if (global) {
          var fullUnicode = rx.unicode;
          rx.lastIndex = 0;
        }
        var results = [];
        while (true) {
          var result = regExpExec(rx, S);
          if (result === null) { break; }
          results.push(result);
          if (!global) { break; }
          var matchStr = String(result[0]);
          if (matchStr === '') { rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode); }
        }
        var accumulatedResult = '';
        var nextSourcePosition = 0;
        for (var i = 0; i < results.length; i++) {
          result = results[i];
          var matched = String(result[0]);
          var position = max(min(toInteger(result.index), S.length), 0);
          var captures = [];
          // NOTE: This is equivalent to
          //   captures = result.slice(1).map(maybeToString)
          // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
          // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
          // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.
          for (var j = 1; j < result.length; j++) { captures.push(maybeToString(result[j])); }
          var namedCaptures = result.groups;
          if (functionalReplace) {
            var replacerArgs = [matched].concat(captures, position, S);
            if (namedCaptures !== undefined) { replacerArgs.push(namedCaptures); }
            var replacement = String(replaceValue.apply(undefined, replacerArgs));
          } else {
            replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
          }
          if (position >= nextSourcePosition) {
            accumulatedResult += S.slice(nextSourcePosition, position) + replacement;
            nextSourcePosition = position + matched.length;
          }
        }
        return accumulatedResult + S.slice(nextSourcePosition);
      }
    ];

      // https://tc39.github.io/ecma262/#sec-getsubstitution
    function getSubstitution(matched, str, position, captures, namedCaptures, replacement) {
      var tailPos = position + matched.length;
      var m = captures.length;
      var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
      if (namedCaptures !== undefined) {
        namedCaptures = toObject(namedCaptures);
        symbols = SUBSTITUTION_SYMBOLS;
      }
      return $replace.call(replacement, symbols, function (match, ch) {
        var capture;
        switch (ch.charAt(0)) {
          case '$': return '$';
          case '&': return matched;
          case '`': return str.slice(0, position);
          case "'": return str.slice(tailPos);
          case '<':
            capture = namedCaptures[ch.slice(1, -1)];
            break;
          default: // \d\d?
            var n = +ch;
            if (n === 0) { return match; }
            if (n > m) {
              var f = floor(n / 10);
              if (f === 0) { return match; }
              if (f <= m) { return captures[f - 1] === undefined ? ch.charAt(1) : captures[f - 1] + ch.charAt(1); }
              return match;
            }
            capture = captures[n - 1];
        }
        return capture === undefined ? '' : capture;
      });
    }
  });


  /***/ }),

  /***/ "aae3":
  /***/ (function(module, exports, __webpack_require__) {

  // 7.2.8 IsRegExp(argument)
  var isObject = __webpack_require__("d3f4");
  var cof = __webpack_require__("2d95");
  var MATCH = __webpack_require__("2b4c")('match');
  module.exports = function (it) {
    var isRegExp;
    return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : cof(it) == 'RegExp');
  };


  /***/ }),

  /***/ "ac6a":
  /***/ (function(module, exports, __webpack_require__) {

  var $iterators = __webpack_require__("cadf");
  var getKeys = __webpack_require__("0d58");
  var redefine = __webpack_require__("2aba");
  var global = __webpack_require__("7726");
  var hide = __webpack_require__("32e9");
  var Iterators = __webpack_require__("84f2");
  var wks = __webpack_require__("2b4c");
  var ITERATOR = wks('iterator');
  var TO_STRING_TAG = wks('toStringTag');
  var ArrayValues = Iterators.Array;

  var DOMIterables = {
    CSSRuleList: true, // TODO: Not spec compliant, should be false.
    CSSStyleDeclaration: false,
    CSSValueList: false,
    ClientRectList: false,
    DOMRectList: false,
    DOMStringList: false,
    DOMTokenList: true,
    DataTransferItemList: false,
    FileList: false,
    HTMLAllCollection: false,
    HTMLCollection: false,
    HTMLFormElement: false,
    HTMLSelectElement: false,
    MediaList: true, // TODO: Not spec compliant, should be false.
    MimeTypeArray: false,
    NamedNodeMap: false,
    NodeList: true,
    PaintRequestList: false,
    Plugin: false,
    PluginArray: false,
    SVGLengthList: false,
    SVGNumberList: false,
    SVGPathSegList: false,
    SVGPointList: false,
    SVGStringList: false,
    SVGTransformList: false,
    SourceBufferList: false,
    StyleSheetList: true, // TODO: Not spec compliant, should be false.
    TextTrackCueList: false,
    TextTrackList: false,
    TouchList: false
  };

  for (var collections = getKeys(DOMIterables), i = 0; i < collections.length; i++) {
    var NAME = collections[i];
    var explicit = DOMIterables[NAME];
    var Collection = global[NAME];
    var proto = Collection && Collection.prototype;
    var key;
    if (proto) {
      if (!proto[ITERATOR]) { hide(proto, ITERATOR, ArrayValues); }
      if (!proto[TO_STRING_TAG]) { hide(proto, TO_STRING_TAG, NAME); }
      Iterators[NAME] = ArrayValues;
      if (explicit) { for (key in $iterators) { if (!proto[key]) { redefine(proto, key, $iterators[key], true); } } }
    }
  }


  /***/ }),

  /***/ "b0c5":
  /***/ (function(module, exports, __webpack_require__) {

  var regexpExec = __webpack_require__("520a");
  __webpack_require__("5ca1")({
    target: 'RegExp',
    proto: true,
    forced: regexpExec !== /./.exec
  }, {
    exec: regexpExec
  });


  /***/ }),

  /***/ "be13":
  /***/ (function(module, exports) {

  // 7.2.1 RequireObjectCoercible(argument)
  module.exports = function (it) {
    if (it == undefined) { throw TypeError("Can't call method on  " + it); }
    return it;
  };


  /***/ }),

  /***/ "c366":
  /***/ (function(module, exports, __webpack_require__) {

  // false -> Array#indexOf
  // true  -> Array#includes
  var toIObject = __webpack_require__("6821");
  var toLength = __webpack_require__("9def");
  var toAbsoluteIndex = __webpack_require__("77f1");
  module.exports = function (IS_INCLUDES) {
    return function ($this, el, fromIndex) {
      var O = toIObject($this);
      var length = toLength(O.length);
      var index = toAbsoluteIndex(fromIndex, length);
      var value;
      // Array#includes uses SameValueZero equality algorithm
      // eslint-disable-next-line no-self-compare
      if (IS_INCLUDES && el != el) { while (length > index) {
        value = O[index++];
        // eslint-disable-next-line no-self-compare
        if (value != value) { return true; }
      // Array#indexOf ignores holes, Array#includes - not
      } } else { for (;length > index; index++) { if (IS_INCLUDES || index in O) {
        if (O[index] === el) { return IS_INCLUDES || index || 0; }
      } } } return !IS_INCLUDES && -1;
    };
  };


  /***/ }),

  /***/ "c649":
  /***/ (function(module, __webpack_exports__, __webpack_require__) {
  /* WEBPACK VAR INJECTION */(function(global) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return insertNodeAt; });
  /* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return camelize; });
  /* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return console; });
  /* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return removeNode; });
  /* harmony import */ __webpack_require__("a481");


  function getConsole() {
    if (typeof window !== "undefined") {
      return window.console;
    }

    return global.console;
  }

  var console = getConsole();

  function cached(fn) {
    var cache = Object.create(null);
    return function cachedFn(str) {
      var hit = cache[str];
      return hit || (cache[str] = fn(str));
    };
  }

  var regex = /-(\w)/g;
  var camelize = cached(function (str) {
    return str.replace(regex, function (_, c) {
      return c ? c.toUpperCase() : "";
    });
  });

  function removeNode(node) {
    if (node.parentElement !== null) {
      node.parentElement.removeChild(node);
    }
  }

  function insertNodeAt(fatherNode, node, position) {
    var refNode = position === 0 ? fatherNode.children[0] : fatherNode.children[position - 1].nextSibling;
    fatherNode.insertBefore(node, refNode);
  }


  /* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("c8ba")));

  /***/ }),

  /***/ "c69a":
  /***/ (function(module, exports, __webpack_require__) {

  module.exports = !__webpack_require__("9e1e") && !__webpack_require__("79e5")(function () {
    return Object.defineProperty(__webpack_require__("230e")('div'), 'a', { get: function () { return 7; } }).a != 7;
  });


  /***/ }),

  /***/ "c8ba":
  /***/ (function(module, exports) {

  var g;

  // This works in non-strict mode
  g = (function() {
  	return this;
  })();

  try {
  	// This works if eval is allowed (see CSP)
  	g = g || new Function("return this")();
  } catch (e) {
  	// This works if the window reference is available
  	if (typeof window === "object") { g = window; }
  }

  // g can still be undefined, but nothing to do about it...
  // We return undefined, instead of nothing here, so it's
  // easier to handle this case. if(!global) { ...}

  module.exports = g;


  /***/ }),

  /***/ "ca5a":
  /***/ (function(module, exports) {

  var id = 0;
  var px = Math.random();
  module.exports = function (key) {
    return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
  };


  /***/ }),

  /***/ "cadf":
  /***/ (function(module, exports, __webpack_require__) {

  var addToUnscopables = __webpack_require__("9c6c");
  var step = __webpack_require__("d53b");
  var Iterators = __webpack_require__("84f2");
  var toIObject = __webpack_require__("6821");

  // 22.1.3.4 Array.prototype.entries()
  // 22.1.3.13 Array.prototype.keys()
  // 22.1.3.29 Array.prototype.values()
  // 22.1.3.30 Array.prototype[@@iterator]()
  module.exports = __webpack_require__("01f9")(Array, 'Array', function (iterated, kind) {
    this._t = toIObject(iterated); // target
    this._i = 0;                   // next index
    this._k = kind;                // kind
  // 22.1.5.2.1 %ArrayIteratorPrototype%.next()
  }, function () {
    var O = this._t;
    var kind = this._k;
    var index = this._i++;
    if (!O || index >= O.length) {
      this._t = undefined;
      return step(1);
    }
    if (kind == 'keys') { return step(0, index); }
    if (kind == 'values') { return step(0, O[index]); }
    return step(0, [index, O[index]]);
  }, 'values');

  // argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
  Iterators.Arguments = Iterators.Array;

  addToUnscopables('keys');
  addToUnscopables('values');
  addToUnscopables('entries');


  /***/ }),

  /***/ "cb7c":
  /***/ (function(module, exports, __webpack_require__) {

  var isObject = __webpack_require__("d3f4");
  module.exports = function (it) {
    if (!isObject(it)) { throw TypeError(it + ' is not an object!'); }
    return it;
  };


  /***/ }),

  /***/ "ce10":
  /***/ (function(module, exports, __webpack_require__) {

  var has = __webpack_require__("69a8");
  var toIObject = __webpack_require__("6821");
  var arrayIndexOf = __webpack_require__("c366")(false);
  var IE_PROTO = __webpack_require__("613b")('IE_PROTO');

  module.exports = function (object, names) {
    var O = toIObject(object);
    var i = 0;
    var result = [];
    var key;
    for (key in O) { if (key != IE_PROTO) { has(O, key) && result.push(key); } }
    // Don't enum bug & hidden keys
    while (names.length > i) { if (has(O, key = names[i++])) {
      ~arrayIndexOf(result, key) || result.push(key);
    } }
    return result;
  };


  /***/ }),

  /***/ "d2c8":
  /***/ (function(module, exports, __webpack_require__) {

  // helper for String#{startsWith, endsWith, includes}
  var isRegExp = __webpack_require__("aae3");
  var defined = __webpack_require__("be13");

  module.exports = function (that, searchString, NAME) {
    if (isRegExp(searchString)) { throw TypeError('String#' + NAME + " doesn't accept regex!"); }
    return String(defined(that));
  };


  /***/ }),

  /***/ "d3f4":
  /***/ (function(module, exports) {

  module.exports = function (it) {
    return typeof it === 'object' ? it !== null : typeof it === 'function';
  };


  /***/ }),

  /***/ "d53b":
  /***/ (function(module, exports) {

  module.exports = function (done, value) {
    return { value: value, done: !!done };
  };


  /***/ }),

  /***/ "d8e8":
  /***/ (function(module, exports) {

  module.exports = function (it) {
    if (typeof it != 'function') { throw TypeError(it + ' is not a function!'); }
    return it;
  };


  /***/ }),

  /***/ "e11e":
  /***/ (function(module, exports) {

  // IE 8- don't enum bug keys
  module.exports = (
    'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
  ).split(',');


  /***/ }),

  /***/ "f559":
  /***/ (function(module, exports, __webpack_require__) {
  // 21.1.3.18 String.prototype.startsWith(searchString [, position ])

  var $export = __webpack_require__("5ca1");
  var toLength = __webpack_require__("9def");
  var context = __webpack_require__("d2c8");
  var STARTS_WITH = 'startsWith';
  var $startsWith = ''[STARTS_WITH];

  $export($export.P + $export.F * __webpack_require__("5147")(STARTS_WITH), 'String', {
    startsWith: function startsWith(searchString /* , position = 0 */) {
      var that = context(this, searchString, STARTS_WITH);
      var index = toLength(Math.min(arguments.length > 1 ? arguments[1] : undefined, that.length));
      var search = String(searchString);
      return $startsWith
        ? $startsWith.call(that, search, index)
        : that.slice(index, index + search.length) === search;
    }
  });


  /***/ }),

  /***/ "f6fd":
  /***/ (function(module, exports) {

  // document.currentScript polyfill by Adam Miller

  // MIT license

  (function(document){
    var currentScript = "currentScript",
        scripts = document.getElementsByTagName('script'); // Live NodeList collection

    // If browser needs currentScript polyfill, add get currentScript() to the document object
    if (!(currentScript in document)) {
      Object.defineProperty(document, currentScript, {
        get: function(){

          // IE 6-10 supports script readyState
          // IE 10+ support stack trace
          try { throw new Error(); }
          catch (err) {

            // Find the second match for the "at" string to get file src url from stack.
            // Specifically works with the format of stack traces in IE.
            var i, res = ((/.*at [^\(]*\((.*):.+:.+\)$/ig).exec(err.stack) || [false])[1];

            // For all scripts on the page, if src matches or if ready state is interactive, return the script tag
            for(i in scripts){
              if(scripts[i].src == res || scripts[i].readyState == "interactive"){
                return scripts[i];
              }
            }

            // If no match, return null
            return null;
          }
        }
      });
    }
  })(document);


  /***/ }),

  /***/ "f751":
  /***/ (function(module, exports, __webpack_require__) {

  // 19.1.3.1 Object.assign(target, source)
  var $export = __webpack_require__("5ca1");

  $export($export.S + $export.F, 'Object', { assign: __webpack_require__("7333") });


  /***/ }),

  /***/ "fa5b":
  /***/ (function(module, exports, __webpack_require__) {

  module.exports = __webpack_require__("5537")('native-function-to-string', Function.toString);


  /***/ }),

  /***/ "fab2":
  /***/ (function(module, exports, __webpack_require__) {

  var document = __webpack_require__("7726").document;
  module.exports = document && document.documentElement;


  /***/ }),

  /***/ "fb15":
  /***/ (function(module, __webpack_exports__, __webpack_require__) {
  // ESM COMPAT FLAG
  __webpack_require__.r(__webpack_exports__);

  // CONCATENATED MODULE: ./node_modules/@vue/cli-service/lib/commands/build/setPublicPath.js
  // This file is imported into lib/wc client bundles.

  if (typeof window !== 'undefined') {
    {
      __webpack_require__("f6fd");
    }

    var setPublicPath_i;
    if ((setPublicPath_i = window.document.currentScript) && (setPublicPath_i = setPublicPath_i.src.match(/(.+\/)[^/]+\.js(\?.*)?$/))) {
      __webpack_require__.p = setPublicPath_i[1]; // eslint-disable-line
    }
  }

  // EXTERNAL MODULE: ./node_modules/core-js/modules/es6.object.assign.js
  __webpack_require__("f751");

  // EXTERNAL MODULE: ./node_modules/core-js/modules/es6.string.starts-with.js
  __webpack_require__("f559");

  // EXTERNAL MODULE: ./node_modules/core-js/modules/web.dom.iterable.js
  __webpack_require__("ac6a");

  // EXTERNAL MODULE: ./node_modules/core-js/modules/es6.array.iterator.js
  __webpack_require__("cadf");

  // EXTERNAL MODULE: ./node_modules/core-js/modules/es6.object.keys.js
  __webpack_require__("456d");

  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/arrayWithHoles.js
  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) { return arr; }
  }
  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/iterableToArrayLimit.js
  function _iterableToArrayLimit(arr, i) {
    if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) { return; }
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;

    try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) { break; }
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) { _i["return"](); }
      } finally {
        if (_d) { throw _e; }
      }
    }

    return _arr;
  }
  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js
  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) { len = arr.length; }

    for (var i = 0, arr2 = new Array(len); i < len; i++) {
      arr2[i] = arr[i];
    }

    return arr2;
  }
  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) { return; }
    if (typeof o === "string") { return _arrayLikeToArray(o, minLen); }
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) { n = o.constructor.name; }
    if (n === "Map" || n === "Set") { return Array.from(o); }
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) { return _arrayLikeToArray(o, minLen); }
  }
  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/nonIterableRest.js
  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/slicedToArray.js




  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }
  // EXTERNAL MODULE: ./node_modules/core-js/modules/es7.array.includes.js
  __webpack_require__("6762");

  // EXTERNAL MODULE: ./node_modules/core-js/modules/es6.string.includes.js
  __webpack_require__("2fdb");

  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/arrayWithoutHoles.js

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) { return _arrayLikeToArray(arr); }
  }
  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/iterableToArray.js
  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) { return Array.from(iter); }
  }
  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/nonIterableSpread.js
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  // CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js




  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }
  // EXTERNAL MODULE: external {"commonjs":"sortablejs","commonjs2":"sortablejs","amd":"sortablejs","root":"Sortable"}
  var external_commonjs_sortablejs_commonjs2_sortablejs_amd_sortablejs_root_Sortable_ = __webpack_require__("a352");
  var external_commonjs_sortablejs_commonjs2_sortablejs_amd_sortablejs_root_Sortable_default = /*#__PURE__*/__webpack_require__.n(external_commonjs_sortablejs_commonjs2_sortablejs_amd_sortablejs_root_Sortable_);

  // EXTERNAL MODULE: ./src/util/helper.js
  var helper = __webpack_require__("c649");

  // CONCATENATED MODULE: ./src/vuedraggable.js












  function buildAttribute(object, propName, value) {
    if (value === undefined) {
      return object;
    }

    object = object || {};
    object[propName] = value;
    return object;
  }

  function computeVmIndex(vnodes, element) {
    return vnodes.map(function (elt) {
      return elt.elm;
    }).indexOf(element);
  }

  function _computeIndexes(slots, children, isTransition, footerOffset) {
    if (!slots) {
      return [];
    }

    var elmFromNodes = slots.map(function (elt) {
      return elt.elm;
    });
    var footerIndex = children.length - footerOffset;

    var rawIndexes = _toConsumableArray(children).map(function (elt, idx) {
      return idx >= footerIndex ? elmFromNodes.length : elmFromNodes.indexOf(elt);
    });

    return isTransition ? rawIndexes.filter(function (ind) {
      return ind !== -1;
    }) : rawIndexes;
  }

  function emit(evtName, evtData) {
    var _this = this;

    this.$nextTick(function () {
      return _this.$emit(evtName.toLowerCase(), evtData);
    });
  }

  function delegateAndEmit(evtName) {
    var _this2 = this;

    return function (evtData) {
      if (_this2.realList !== null) {
        _this2["onDrag" + evtName](evtData);
      }

      emit.call(_this2, evtName, evtData);
    };
  }

  function isTransitionName(name) {
    return ["transition-group", "TransitionGroup"].includes(name);
  }

  function vuedraggable_isTransition(slots) {
    if (!slots || slots.length !== 1) {
      return false;
    }

    var _slots = _slicedToArray(slots, 1),
        componentOptions = _slots[0].componentOptions;

    if (!componentOptions) {
      return false;
    }

    return isTransitionName(componentOptions.tag);
  }

  function getSlot(slot, scopedSlot, key) {
    return slot[key] || (scopedSlot[key] ? scopedSlot[key]() : undefined);
  }

  function computeChildrenAndOffsets(children, slot, scopedSlot) {
    var headerOffset = 0;
    var footerOffset = 0;
    var header = getSlot(slot, scopedSlot, "header");

    if (header) {
      headerOffset = header.length;
      children = children ? [].concat(_toConsumableArray(header), _toConsumableArray(children)) : _toConsumableArray(header);
    }

    var footer = getSlot(slot, scopedSlot, "footer");

    if (footer) {
      footerOffset = footer.length;
      children = children ? [].concat(_toConsumableArray(children), _toConsumableArray(footer)) : _toConsumableArray(footer);
    }

    return {
      children: children,
      headerOffset: headerOffset,
      footerOffset: footerOffset
    };
  }

  function getComponentAttributes($attrs, componentData) {
    var attributes = null;

    var update = function update(name, value) {
      attributes = buildAttribute(attributes, name, value);
    };

    var attrs = Object.keys($attrs).filter(function (key) {
      return key === "id" || key.startsWith("data-");
    }).reduce(function (res, key) {
      res[key] = $attrs[key];
      return res;
    }, {});
    update("attrs", attrs);

    if (!componentData) {
      return attributes;
    }

    var on = componentData.on,
        props = componentData.props,
        componentDataAttrs = componentData.attrs;
    update("on", on);
    update("props", props);
    Object.assign(attributes.attrs, componentDataAttrs);
    return attributes;
  }

  var eventsListened = ["Start", "Add", "Remove", "Update", "End"];
  var eventsToEmit = ["Choose", "Unchoose", "Sort", "Filter", "Clone"];
  var readonlyProperties = ["Move"].concat(eventsListened, eventsToEmit).map(function (evt) {
    return "on" + evt;
  });
  var draggingElement = null;
  var props = {
    options: Object,
    list: {
      type: Array,
      required: false,
      default: null
    },
    value: {
      type: Array,
      required: false,
      default: null
    },
    noTransitionOnDrag: {
      type: Boolean,
      default: false
    },
    clone: {
      type: Function,
      default: function _default(original) {
        return original;
      }
    },
    element: {
      type: String,
      default: "div"
    },
    tag: {
      type: String,
      default: null
    },
    move: {
      type: Function,
      default: null
    },
    componentData: {
      type: Object,
      required: false,
      default: null
    }
  };
  var draggableComponent = {
    name: "draggable",
    inheritAttrs: false,
    props: props,
    data: function data() {
      return {
        transitionMode: false,
        noneFunctionalComponentMode: false
      };
    },
    render: function render(h) {
      var slots = this.$slots.default;
      this.transitionMode = vuedraggable_isTransition(slots);

      var _computeChildrenAndOf = computeChildrenAndOffsets(slots, this.$slots, this.$scopedSlots),
          children = _computeChildrenAndOf.children,
          headerOffset = _computeChildrenAndOf.headerOffset,
          footerOffset = _computeChildrenAndOf.footerOffset;

      this.headerOffset = headerOffset;
      this.footerOffset = footerOffset;
      var attributes = getComponentAttributes(this.$attrs, this.componentData);
      return h(this.getTag(), attributes, children);
    },
    created: function created() {
      if (this.list !== null && this.value !== null) {
        helper["b" /* console */].error("Value and list props are mutually exclusive! Please set one or another.");
      }

      if (this.element !== "div") {
        helper["b" /* console */].warn("Element props is deprecated please use tag props instead. See https://github.com/SortableJS/Vue.Draggable/blob/master/documentation/migrate.md#element-props");
      }

      if (this.options !== undefined) {
        helper["b" /* console */].warn("Options props is deprecated, add sortable options directly as vue.draggable item, or use v-bind. See https://github.com/SortableJS/Vue.Draggable/blob/master/documentation/migrate.md#options-props");
      }
    },
    mounted: function mounted() {
      var _this3 = this;

      this.noneFunctionalComponentMode = this.getTag().toLowerCase() !== this.$el.nodeName.toLowerCase() && !this.getIsFunctional();

      if (this.noneFunctionalComponentMode && this.transitionMode) {
        throw new Error("Transition-group inside component is not supported. Please alter tag value or remove transition-group. Current tag value: ".concat(this.getTag()));
      }

      var optionsAdded = {};
      eventsListened.forEach(function (elt) {
        optionsAdded["on" + elt] = delegateAndEmit.call(_this3, elt);
      });
      eventsToEmit.forEach(function (elt) {
        optionsAdded["on" + elt] = emit.bind(_this3, elt);
      });
      var attributes = Object.keys(this.$attrs).reduce(function (res, key) {
        res[Object(helper["a" /* camelize */])(key)] = _this3.$attrs[key];
        return res;
      }, {});
      var options = Object.assign({}, this.options, attributes, optionsAdded, {
        onMove: function onMove(evt, originalEvent) {
          return _this3.onDragMove(evt, originalEvent);
        }
      });
      !("draggable" in options) && (options.draggable = ">*");
      this._sortable = new external_commonjs_sortablejs_commonjs2_sortablejs_amd_sortablejs_root_Sortable_default.a(this.rootContainer, options);
      this.computeIndexes();
    },
    beforeDestroy: function beforeDestroy() {
      if (this._sortable !== undefined) { this._sortable.destroy(); }
    },
    computed: {
      rootContainer: function rootContainer() {
        return this.transitionMode ? this.$el.children[0] : this.$el;
      },
      realList: function realList() {
        return this.list ? this.list : this.value;
      }
    },
    watch: {
      options: {
        handler: function handler(newOptionValue) {
          this.updateOptions(newOptionValue);
        },
        deep: true
      },
      $attrs: {
        handler: function handler(newOptionValue) {
          this.updateOptions(newOptionValue);
        },
        deep: true
      },
      realList: function realList() {
        this.computeIndexes();
      }
    },
    methods: {
      getIsFunctional: function getIsFunctional() {
        var fnOptions = this._vnode.fnOptions;
        return fnOptions && fnOptions.functional;
      },
      getTag: function getTag() {
        return this.tag || this.element;
      },
      updateOptions: function updateOptions(newOptionValue) {
        for (var property in newOptionValue) {
          var value = Object(helper["a" /* camelize */])(property);

          if (readonlyProperties.indexOf(value) === -1) {
            this._sortable.option(value, newOptionValue[property]);
          }
        }
      },
      getChildrenNodes: function getChildrenNodes() {
        if (this.noneFunctionalComponentMode) {
          return this.$children[0].$slots.default;
        }

        var rawNodes = this.$slots.default;
        return this.transitionMode ? rawNodes[0].child.$slots.default : rawNodes;
      },
      computeIndexes: function computeIndexes() {
        var _this4 = this;

        this.$nextTick(function () {
          _this4.visibleIndexes = _computeIndexes(_this4.getChildrenNodes(), _this4.rootContainer.children, _this4.transitionMode, _this4.footerOffset);
        });
      },
      getUnderlyingVm: function getUnderlyingVm(htmlElt) {
        var index = computeVmIndex(this.getChildrenNodes() || [], htmlElt);

        if (index === -1) {
          //Edge case during move callback: related element might be
          //an element different from collection
          return null;
        }

        var element = this.realList[index];
        return {
          index: index,
          element: element
        };
      },
      getUnderlyingPotencialDraggableComponent: function getUnderlyingPotencialDraggableComponent(_ref) {
        var vue = _ref.__vue__;

        if (!vue || !vue.$options || !isTransitionName(vue.$options._componentTag)) {
          if (!("realList" in vue) && vue.$children.length === 1 && "realList" in vue.$children[0]) { return vue.$children[0]; }
          return vue;
        }

        return vue.$parent;
      },
      emitChanges: function emitChanges(evt) {
        var _this5 = this;

        this.$nextTick(function () {
          _this5.$emit("change", evt);
        });
      },
      alterList: function alterList(onList) {
        if (this.list) {
          onList(this.list);
          return;
        }

        var newList = _toConsumableArray(this.value);

        onList(newList);
        this.$emit("input", newList);
      },
      spliceList: function spliceList() {
        var _arguments = arguments;

        var spliceList = function spliceList(list) {
          return list.splice.apply(list, _toConsumableArray(_arguments));
        };

        this.alterList(spliceList);
      },
      updatePosition: function updatePosition(oldIndex, newIndex) {
        var updatePosition = function updatePosition(list) {
          return list.splice(newIndex, 0, list.splice(oldIndex, 1)[0]);
        };

        this.alterList(updatePosition);
      },
      getRelatedContextFromMoveEvent: function getRelatedContextFromMoveEvent(_ref2) {
        var to = _ref2.to,
            related = _ref2.related;
        var component = this.getUnderlyingPotencialDraggableComponent(to);

        if (!component) {
          return {
            component: component
          };
        }

        var list = component.realList;
        var context = {
          list: list,
          component: component
        };

        if (to !== related && list && component.getUnderlyingVm) {
          var destination = component.getUnderlyingVm(related);

          if (destination) {
            return Object.assign(destination, context);
          }
        }

        return context;
      },
      getVmIndex: function getVmIndex(domIndex) {
        var indexes = this.visibleIndexes;
        var numberIndexes = indexes.length;
        return domIndex > numberIndexes - 1 ? numberIndexes : indexes[domIndex];
      },
      getComponent: function getComponent() {
        return this.$slots.default[0].componentInstance;
      },
      resetTransitionData: function resetTransitionData(index) {
        if (!this.noTransitionOnDrag || !this.transitionMode) {
          return;
        }

        var nodes = this.getChildrenNodes();
        nodes[index].data = null;
        var transitionContainer = this.getComponent();
        transitionContainer.children = [];
        transitionContainer.kept = undefined;
      },
      onDragStart: function onDragStart(evt) {
        this.context = this.getUnderlyingVm(evt.item);
        evt.item._underlying_vm_ = this.clone(this.context.element);
        draggingElement = evt.item;
      },
      onDragAdd: function onDragAdd(evt) {
        var element = evt.item._underlying_vm_;

        if (element === undefined) {
          return;
        }

        Object(helper["d" /* removeNode */])(evt.item);
        var newIndex = this.getVmIndex(evt.newIndex);
        this.spliceList(newIndex, 0, element);
        this.computeIndexes();
        var added = {
          element: element,
          newIndex: newIndex
        };
        this.emitChanges({
          added: added
        });
      },
      onDragRemove: function onDragRemove(evt) {
        Object(helper["c" /* insertNodeAt */])(this.rootContainer, evt.item, evt.oldIndex);

        if (evt.pullMode === "clone") {
          Object(helper["d" /* removeNode */])(evt.clone);
          return;
        }

        var oldIndex = this.context.index;
        this.spliceList(oldIndex, 1);
        var removed = {
          element: this.context.element,
          oldIndex: oldIndex
        };
        this.resetTransitionData(oldIndex);
        this.emitChanges({
          removed: removed
        });
      },
      onDragUpdate: function onDragUpdate(evt) {
        Object(helper["d" /* removeNode */])(evt.item);
        Object(helper["c" /* insertNodeAt */])(evt.from, evt.item, evt.oldIndex);
        var oldIndex = this.context.index;
        var newIndex = this.getVmIndex(evt.newIndex);
        this.updatePosition(oldIndex, newIndex);
        var moved = {
          element: this.context.element,
          oldIndex: oldIndex,
          newIndex: newIndex
        };
        this.emitChanges({
          moved: moved
        });
      },
      updateProperty: function updateProperty(evt, propertyName) {
        evt.hasOwnProperty(propertyName) && (evt[propertyName] += this.headerOffset);
      },
      computeFutureIndex: function computeFutureIndex(relatedContext, evt) {
        if (!relatedContext.element) {
          return 0;
        }

        var domChildren = _toConsumableArray(evt.to.children).filter(function (el) {
          return el.style["display"] !== "none";
        });

        var currentDOMIndex = domChildren.indexOf(evt.related);
        var currentIndex = relatedContext.component.getVmIndex(currentDOMIndex);
        var draggedInList = domChildren.indexOf(draggingElement) !== -1;
        return draggedInList || !evt.willInsertAfter ? currentIndex : currentIndex + 1;
      },
      onDragMove: function onDragMove(evt, originalEvent) {
        var onMove = this.move;

        if (!onMove || !this.realList) {
          return true;
        }

        var relatedContext = this.getRelatedContextFromMoveEvent(evt);
        var draggedContext = this.context;
        var futureIndex = this.computeFutureIndex(relatedContext, evt);
        Object.assign(draggedContext, {
          futureIndex: futureIndex
        });
        var sendEvt = Object.assign({}, evt, {
          relatedContext: relatedContext,
          draggedContext: draggedContext
        });
        return onMove(sendEvt, originalEvent);
      },
      onDragEnd: function onDragEnd() {
        this.computeIndexes();
        draggingElement = null;
      }
    }
  };

  if (typeof window !== "undefined" && "Vue" in window) {
    window.Vue.component("draggable", draggableComponent);
  }

  /* harmony default export */ var vuedraggable = (draggableComponent);
  // CONCATENATED MODULE: ./node_modules/@vue/cli-service/lib/commands/build/entry-lib.js


  /* harmony default export */ __webpack_exports__["default"] = (vuedraggable);



  /***/ })

  /******/ })["default"];
  });
  //# sourceMappingURL=vuedraggable.umd.js.map
  });

  var draggable = /*@__PURE__*/getDefaultExportFromCjs(vuedraggable_umd);

  function createMenu() {
    return [{
      name: 'main',
      title: '表单组件',
      list: [input, number, radio, checkbox, select, _switch, time, date, slider, rate, color, cascader, upload, transfer, tree, editor]
    }, {
      name: 'aide',
      title: '辅助组件',
      list: [alert, button, span, divider]
    }, {
      name: 'layout',
      title: '布局组件',
      list: [row,
      /*tab,*/
      space]
    }];
  }

  var script$5 = {
    name: 'FcDesigner',
    components: {
      draggable: draggable,
      FormCreate: formCreate__default['default'].$form()
    },
    props: ['menu', 'height'],
    computed: {
      height_: function height_() {
        var h = this.height;
        if (!h) { return '100%'; }
        return is.Number(h) ? "".concat(h, "px") : h;
      }
    },
    provide: function provide(_) {
      return {
        fcx: {
          active: null
        }
      };
    },
    data: function data() {
      var _this = this;

      var children = [];
      return {
        moveRule: null,
        addRule: null,
        added: null,
        activeTab: 'form',
        activeRule: null,
        children: children,
        menuList: this.menu || createMenu(),
        showBaseRule: false,
        visible: {
          preview: false
        },
        preview: {
          state: false,
          rule: [],
          option: {}
        },
        dragForm: {
          rule: this.makeDragRule(children),
          api: {}
        },
        form: {
          rule: form(),
          option: {
            form: {
              labelPosition: 'top',
              size: 'mini'
            },
            submitBtn: false
          },
          value: {
            form: {
              inline: false,
              hideRequiredAsterisk: false,
              labelPosition: 'right',
              size: 'mini',
              labelWidth: '125px'
            },
            submitBtn: false
          }
        },
        baseForm: {
          rule: field(),
          api: {},
          options: {
            form: {
              labelPosition: 'top',
              size: 'mini'
            },
            submitBtn: false,
            mounted: function mounted(fapi) {
              fapi.activeRule = _this.activeRule;
              fapi.setValue(fapi.options.formData || {});
            }
          }
        },
        validateForm: {
          rule: validate(),
          api: {},
          options: {
            form: {
              labelPosition: 'top',
              size: 'mini'
            },
            submitBtn: false,
            mounted: function mounted(fapi) {
              fapi.activeRule = _this.activeRule;
              fapi.setValue(fapi.options.formData || {});
            }
          }
        },
        propsForm: {
          rule: [],
          api: {},
          options: {
            form: {
              labelPosition: 'top',
              size: 'mini'
            },
            submitBtn: false,
            mounted: function mounted(fapi) {
              fapi.activeRule = _this.activeRule;
              fapi.setValue(fapi.options.formData || {});
            }
          }
        }
      };
    },
    watch: {
      'preview.state': function previewState(n) {
        var _this2 = this;

        if (!n) {
          this.$nextTick(function () {
            _this2.preview.rule = _this2.preview.option = null;
          });
        }
      }
    },
    methods: {
      addMenu: function addMenu(config) {
        var _this3 = this;

        if (!config.name || !config.list) { return; }
        var flag = true;
        this.menuList.forEach(function (v, i) {
          if (v.name === config.name) {
            _this3.$set(_this3.menuList, i, config);

            flag = false;
          }
        });

        if (flag) {
          this.menuList.push(config);
        }
      },
      removeMenu: function removeMenu(name) {
        var _this4 = this;

        _toConsumableArray$1(this.menuList).forEach(function (v, i) {
          if (v.name === name) {
            _this4.menuList.splice(i, 1);
          }
        });
      },
      setMenuItem: function setMenuItem(name, list) {
        this.menuList.forEach(function (v) {
          if (v.name === name) {
            v.list = list;
          }
        });
      },
      appendMenuItem: function appendMenuItem(name, item) {
        this.menuList.forEach(function (v) {
          if (v.name === name) {
            v.list.push(item);
          }
        });
      },
      removeMenuItem: function removeMenuItem(item) {
        this.menuList.forEach(function (v) {
          var idx;

          if (is.String(item)) {
            _toConsumableArray$1(v.list).forEach(function (menu, idx) {
              if (menu.name === item) {
                v.list.splice(idx, 1);
              }
            });
          } else {
            if ((idx = v.list.indexOf(item)) > -1) {
              v.list.splice(idx, 1);
            }
          }
        });
      },
      addComponent: function addComponent(data) {
        if (Array.isArray(data)) {
          data.forEach(function (v) {
            ruleList[v.name] = v;
          });
        } else {
          ruleList[data.name] = data;
        }
      },
      dragStart: function dragStart(children) {
        this.moveRule = children;
        this.added = false;
      },
      dragUnchoose: function dragUnchoose(children, evt) {
        this.addRule = {
          children: children,
          oldIndex: evt.oldIndex
        };
      },
      getParent: function getParent(rule) {
        var parent = rule.__fc__.parent.rule;
        var config = parent.config;

        if (config && config.config.inside) {
          rule = parent;
          parent = parent.__fc__.parent.rule;
        }

        return {
          root: parent,
          parent: rule
        };
      },
      makeDrag: function makeDrag(group, tag, children, on, subRule) {
        return {
          type: 'DragBox',
          wrap: {
            show: false
          },
          col: {
            show: false
          },
          inject: true,
          props: {
            rule: {
              props: {
                tag: 'el-col'
              },
              attrs: {
                group: group === true ? 'default' : group,
                ghostClass: 'ghost',
                animation: 150,
                handle: '._fc-drag-btn',
                emptyInsertThreshold: 0,
                direction: 'vertical'
              }
            },
            subRule: subRule || {
              props: {
                name: 'fade',
                tag: 'div'
              }
            },
            tag: tag
          },
          children: children,
          on: on
        };
      },
      clearDragRule: function clearDragRule() {
        this.setRule([]);
      },
      makeDragRule: function makeDragRule(children) {
        var _this5 = this;

        return [this.makeDrag(true, 'draggable', children, {
          add: function add(inject, evt) {
            return _this5.dragAdd(children, evt);
          },
          end: function end(inject, evt) {
            return _this5.dragEnd(children, evt);
          },
          start: function start(inject, evt) {
            return _this5.dragStart(children, evt);
          },
          unchoose: function unchoose(inject, evt) {
            return _this5.dragUnchoose(children, evt);
          }
        }, {
          props: {
            name: 'fade',
            tag: 'div'
          }
        })];
      },
      previewFc: function previewFc() {
        this.preview.state = true;
        this.preview.rule = this.getRule();
        this.preview.option = this.getOption();
      },
      getRule: function getRule() {
        return this.parseRule(deepCopy(this.dragForm.api.rule[0].children));
      },
      getJson: function getJson() {
        return formCreate__default['default'].toJson(this.getRule());
      },
      getOption: function getOption() {
        var option = deepCopy(this.form.value);
        delete option.submitBtn;
        return option;
      },
      setRule: function setRule(rules) {
        var children = this.loadRule(is.String(rules) ? formCreate__default['default'].parseJson(rules) : rules);
        this.children = children;
        this.clearActiveRule();
        this.dragForm.rule = this.makeDragRule(children);
      },
      clearActiveRule: function clearActiveRule() {
        this.activeRule = null;
        this.activeTab = 'form';
      },
      setOption: function setOption(option) {
        var _ = option;
        _.submitBtn = false;
        delete _.resetBtn;
        this.form.value = _;
      },
      loadRule: function loadRule(rules) {
        var _this6 = this;

        var loadRule = [];
        rules.forEach(function (rule) {
          if (is.String(rule)) {
            return loadRule.push(rule);
          }

          var config = ruleList[rule._fc_drag_tag] || ruleList[rule.type];
          var _children = rule.children;
          rule.children = [];

          if (rule.control) {
            rule._control = rule.control;
            delete rule.control;
          }

          if (config) {
            rule = _this6.makeRule(config, rule);

            if (_children) {
              var _children2;

              var children = rule.children[0].children;

              if (config.drag) {
                children = children[0].children;
              }

              (_children2 = children).push.apply(_children2, _toConsumableArray$1(_this6.loadRule(_children)));
            }
          } else if (_children) {
            rule.children = _this6.loadRule(_children);
          }

          loadRule.push(rule);
        });
        return loadRule;
      },
      parseRule: function parseRule(children) {
        var _this7 = this;

        return _toConsumableArray$1(children).reduce(function (initial, rule) {
          if (is.String(rule)) {
            initial.push(rule);
            return initial;
          } else if (rule.type === 'DragBox') {
            initial.push.apply(initial, _toConsumableArray$1(_this7.parseRule(rule.children)));
            return initial;
          } else if (rule.type === 'DragTool') {
            rule = rule.children[0];

            if (rule.type === 'DragBox') {
              initial.push.apply(initial, _toConsumableArray$1(_this7.parseRule(rule.children)));
              return initial;
            }
          }

          if (!rule) { return initial; }
          rule = _objectSpread2({}, rule);

          if (rule.children.length) {
            rule.children = _this7.parseRule(rule.children);
          }

          delete rule.id;

          if (rule.config) {
            delete rule.config.config;
          }

          if (rule.effect) {
            delete rule.effect._fc;
            delete rule.effect._fc_tool;
          }

          if (rule._control) {
            rule.control = rule._control;
            delete rule._control;
          }

          Object.keys(rule).filter(function (k) {
            return Array.isArray(rule[k]) && rule[k].length === 0 || is.Object(rule[k]) && Object.keys(rule[k]).length === 0;
          }).forEach(function (k) {
            delete rule[k];
          });
          initial.push(rule);
          return initial;
        }, []);
      },
      baseChange: function baseChange(field, value, _, fapi, flag) {
        if (!flag && this.activeRule && fapi.activeRule === this.activeRule) {
          this.$set(this.activeRule, field, value);
        }
      },
      propRemoveField: function propRemoveField(field, _, fapi) {
        if (this.activeRule && fapi.activeRule === this.activeRule) {
          this.dragForm.api.sync(this.activeRule);

          if (field.indexOf('formCreate') === 0) {
            field = field.replace('formCreate', '');
            if (!field) { return; }
            field = lower(field);

            if (field.indexOf('effect') === 0 && field.indexOf('>') > -1) {
              this.$delete(this.activeRule.effect, field.split('>')[1]);
            } else if (field.indexOf('props') === 0 && field.indexOf('>') > -1) {
              this.$delete(this.activeRule.props, field.split('>')[1]);
            } else if (field === 'child') {
              this.$delete(this.activeRule.children, 0);
            } else if (field) {
              this.$set(this.activeRule, field, undefined);
            }
          } else {
            this.$delete(this.activeRule.props, field);
          }
        }
      },
      propChange: function propChange(field, value, _, fapi, flag) {
        if (!flag && this.activeRule && fapi.activeRule === this.activeRule) {
          if (field.indexOf('formCreate') === 0) {
            field = field.replace('formCreate', '');
            if (!field) { return; }
            field = lower(field);

            if (field.indexOf('effect') === 0 && field.indexOf('>') > -1) {
              this.$set(this.activeRule.effect, field.split('>')[1], value);
            } else if (field.indexOf('props') === 0 && field.indexOf('>') > -1) {
              this.$set(this.activeRule.props, field.split('>')[1], value);
            } else if (field === 'child') {
              this.$set(this.activeRule.children, 0, value);
            } else {
              this.$set(this.activeRule, field, value);
            }
          } else {
            this.$set(this.activeRule.props, field, value);
          }
        }
      },
      validateChange: function validateChange(formData) {
        var _this8 = this;

        if (!this.activeRule || this.validateForm.api.activeRule !== this.activeRule) { return; }
        this.activeRule.validate = formData.validate || [];
        this.dragForm.api.refreshValidate();
        this.dragForm.api.nextTick(function () {
          _this8.dragForm.api.clearValidateState(_this8.activeRule.field);
        });
      },
      toolActive: function toolActive(rule) {
        var _this9 = this;

        this.$nextTick(function () {
          _this9.activeTab = 'props';
        });
        this.activeRule = rule;
        this.propsForm.api.activeRule = rule;
        this.baseForm.api.activeRule = rule;
        this.validateForm.api.activeRule = rule;
        this.propsForm.rule = rule.config.config.props();

        var formData = _objectSpread2(_objectSpread2({}, rule.props), {}, {
          formCreateChild: rule.children[0]
        });

        Object.keys(rule).forEach(function (k) {
          if (['effect', 'config', 'payload', 'id', 'type'].indexOf(k) < 0) { formData['formCreate' + upper(k)] = rule[k]; }
        });
        ['props', 'effect'].forEach(function (name) {
          rule[name] && Object.keys(rule[name]).forEach(function (k) {
            formData['formCreate' + upper(name) + '>' + k] = rule[name][k];
          });
        });
        this.propsForm.options.formData = formData;
        this.showBaseRule = !!rule.field;

        if (this.showBaseRule) {
          this.baseForm.options.formData = {
            field: rule.field,
            title: rule.title,
            info: rule.info,
            _control: rule._control
          };
          this.validateForm.options.formData = {
            validate: rule.validate ? _toConsumableArray$1(rule.validate) : []
          };
        }
      },
      dragAdd: function dragAdd(children, evt) {
        var newIndex = evt.newIndex;
        var menu = evt.item._underlying_vm_;

        if (!menu) {
          if (this.addRule) {
            var rule = this.addRule.children.splice(this.addRule.oldIndex, 1);
            children.splice(newIndex, 0, rule[0]);
          }
        } else {
          var _rule2 = this.makeRule(ruleList[menu.name]);

          children.splice(newIndex, 0, _rule2);
        }

        this.added = true;
      },
      dragEnd: function dragEnd(children, _ref) {
        var newIndex = _ref.newIndex,
            oldIndex = _ref.oldIndex;

        if (!this.added && !(this.moveRule === children && newIndex === oldIndex)) {
          var rule = this.moveRule.splice(oldIndex, 1);
          children.splice(newIndex, 0, rule[0]);
        }

        this.moveRule = null;
        this.addRule = null;
        this.added = false;
      },
      makeRule: function makeRule(config, _rule) {
        var _this10 = this;

        var rule = _rule || config.rule();

        rule.config = {
          config: config
        };
        if (!rule.effect) { rule.effect = {}; }
        rule.effect._fc = true;
        rule._fc_drag_tag = config.name;
        var drag;

        if (config.drag) {
          var children = [];
          rule.children.push(drag = this.makeDrag(config.drag, rule.type, children, {
            end: function end(inject, evt) {
              return _this10.dragEnd(inject.self.children, evt);
            },
            add: function add(inject, evt) {
              return _this10.dragAdd(inject.self.children, evt);
            },
            start: function start(inject, evt) {
              return _this10.dragStart(inject.self.children, evt);
            },
            unchoose: function unchoose(inject, evt) {
              return _this10.dragUnchoose(inject.self.children, evt);
            }
          }));
        }

        if (config.children && !_rule) {
          var child = this.makeRule(ruleList[config.children]);
          (drag || rule).children.push(child);
        }

        if (config.inside) {
          rule.children = [{
            type: 'DragTool',
            props: {
              dragBtn: config.dragBtn !== false,
              children: config.children
            },
            effect: {
              _fc_tool: true
            },
            inject: true,
            on: {
              "delete": function _delete(_ref2) {
                var self = _ref2.self;

                _this10.getParent(self).parent.__fc__.rm();

                _this10.clearActiveRule();
              },
              add: function add(_ref3) {
                var self = _ref3.self;

                var top = _this10.getParent(self);

                top.root.children.splice(top.root.children.indexOf(top.parent) + 1, 0, _this10.makeRule(top.parent.config.config));
              },
              addChild: function addChild(_ref4) {
                var self = _ref4.self;

                var top = _this10.getParent(self);

                var config = top.parent.config.config;
                var item = ruleList[config.children];
                if (!item) { return; }
                (!config.drag ? top.parent : top.parent.children[0]).children[0].children.push(_this10.makeRule(item));
              },
              copy: function copy(_ref5) {
                var self = _ref5.self;

                var top = _this10.getParent(self);

                top.root.children.splice(top.root.children.indexOf(top.parent) + 1, 0, formCreate__default['default'].copyRule(top.parent));
              },
              active: function active(_ref6) {
                var self = _ref6.self;

                _this10.toolActive(_this10.getParent(self).parent);
              }
            },
            children: rule.children
          }];
          return rule;
        } else {
          return {
            type: 'DragTool',
            props: {
              dragBtn: config.dragBtn !== false,
              children: config.children
            },
            effect: {
              _fc_tool: true
            },
            inject: true,
            on: {
              "delete": function _delete(_ref7) {
                var self = _ref7.self;

                self.__fc__.rm();

                _this10.clearActiveRule();
              },
              add: function add(_ref8) {
                var self = _ref8.self;

                var top = _this10.getParent(self);

                top.root.children.splice(top.root.children.indexOf(top.parent) + 1, 0, _this10.makeRule(self.children[0].config.config));
              },
              addChild: function addChild(_ref9) {
                var self = _ref9.self;
                var config = self.children[0].config.config;
                var item = ruleList[config.children];
                if (!item) { return; }
                (!config.drag ? self : self.children[0]).children[0].children.push(_this10.makeRule(item));
              },
              copy: function copy(_ref10) {
                var self = _ref10.self;

                var top = _this10.getParent(self);

                top.root.children.splice(top.root.children.indexOf(top.parent) + 1, 0, formCreate__default['default'].copyRule(top.parent));
              },
              active: function active(_ref11) {
                var self = _ref11.self;

                _this10.toolActive(self.children[0]);
              }
            },
            children: [rule]
          };
        }
      }
    },
    created: function created() {
      document.body.ondrop = function (e) {
        e.preventDefault();
        e.stopPropagation();
      };
    }
  };

  function styleInject(css, ref) {
    if ( ref === void 0 ) { ref = {}; }
    var insertAt = ref.insertAt;

    if (!css || typeof document === 'undefined') { return; }

    var head = document.head || document.getElementsByTagName('head')[0];
    var style = document.createElement('style');
    style.type = 'text/css';

    if (insertAt === 'top') {
      if (head.firstChild) {
        head.insertBefore(style, head.firstChild);
      } else {
        head.appendChild(style);
      }
    } else {
      head.appendChild(style);
    }

    if (style.styleSheet) {
      style.styleSheet.cssText = css;
    } else {
      style.appendChild(document.createTextNode(css));
    }
  }

  var css_248z$8 = "._fc-designer{height:100%;min-height:500px;overflow:hidden;cursor:default;position:relative}._fc-designer>.el-main{position:absolute;top:0;bottom:0;left:0;right:0;padding:0}._fc-m .form-create ._fc-l-item{background:#2e73ff;width:100%;height:10px;overflow:hidden;transition:all .3s ease}._fc-l,._fc-m,._fc-r{border-top:1px solid #ececec;box-sizing:border-box}._fc-l-group{padding:0 12px}._fc-l-title{font-weight:600;font-size:14px;margin:18px 0 5px}._fc-l-item{display:inline-block;background:#fff;color:#000;min-width:70px;width:33.33%;height:70px;line-height:1;text-align:center;transition:all .2s ease;cursor:pointer}._fc-l-item i{font-size:21px;display:inline-block}._fc-l-item ._fc-l-name{font-size:12px}._fc-l-item ._fc-l-icon{padding:10px 5px 12px}._fc-l-item:hover{background:#2e73ff;color:#fff}._fc-m-tools{height:40px;align-items:center;display:flex;justify-content:flex-end;border:1px solid #ececec;border-top:0}._fc-m-tools button.el-button{padding:5px 14px;display:flex;align-items:center}._fc-m-tools .fc-icon{font-size:14px;margin-right:2px}._fc-r .el-tabs__nav-wrap:after{height:1px;background-color:#ececec}._fc-r ._fc-r-tabs{display:flex;padding:0;border-bottom:1px solid #ececec}._fc-r ._fc-r-tab{height:40px;box-sizing:border-box;line-height:40px;display:inline-block;list-style:none;font-size:14px;font-weight:600;color:#303133;position:relative;flex:1;text-align:center}._fc-r ._fc-r-tab.active{color:#409eff;border-bottom:2px solid #409eff}.drag-box{min-height:60px}._fc-m-drag{overflow:auto;padding:2px;box-sizing:border-box}._fc-m-drag,.draggable-drag{background:#fff;height:100%;position:relative}._fc-m-drag>form,._fc-m-drag>form>.el-row{height:100%}";
  styleInject(css_248z$8);

  var css_248z$7 = "";
  styleInject(css_248z$7);

  function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier /* server only */, shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
      if (typeof shadowMode !== 'boolean') {
          createInjectorSSR = createInjector;
          createInjector = shadowMode;
          shadowMode = false;
      }
      // Vue.extend constructor export interop.
      var options = typeof script === 'function' ? script.options : script;
      // render functions
      if (template && template.render) {
          options.render = template.render;
          options.staticRenderFns = template.staticRenderFns;
          options._compiled = true;
          // functional template
          if (isFunctionalTemplate) {
              options.functional = true;
          }
      }
      // scopedId
      if (scopeId) {
          options._scopeId = scopeId;
      }
      var hook;
      if (moduleIdentifier) {
          // server build
          hook = function (context) {
              // 2.3 injection
              context =
                  context || // cached call
                      (this.$vnode && this.$vnode.ssrContext) || // stateful
                      (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext); // functional
              // 2.2 with runInNewContext: true
              if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
                  context = __VUE_SSR_CONTEXT__;
              }
              // inject component styles
              if (style) {
                  style.call(this, createInjectorSSR(context));
              }
              // register component module identifier for async chunk inference
              if (context && context._registeredComponents) {
                  context._registeredComponents.add(moduleIdentifier);
              }
          };
          // used by ssr in case component is cached and beforeCreate
          // never gets called
          options._ssrRegister = hook;
      }
      else if (style) {
          hook = shadowMode
              ? function (context) {
                  style.call(this, createInjectorShadow(context, this.$root.$options.shadowRoot));
              }
              : function (context) {
                  style.call(this, createInjector(context));
              };
      }
      if (hook) {
          if (options.functional) {
              // register for functional component in vue file
              var originalRender = options.render;
              options.render = function renderWithStyleInjection(h, context) {
                  hook.call(context);
                  return originalRender(h, context);
              };
          }
          else {
              // inject component registration as beforeCreate hook
              var existing = options.beforeCreate;
              options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
          }
      }
      return script;
  }

  /* script */
  var __vue_script__$5 = script$5;
  /* template */

  var __vue_render__$4 = function __vue_render__() {
    var _vm = this;

    var _h = _vm.$createElement;

    var _c = _vm._self._c || _h;

    return _c("ElContainer", {
      staticClass: "_fc-designer",
      style: "height:" + _vm.height_
    }, [_c("ElMain", [_c("ElContainer", {
      staticStyle: {
        height: "100%"
      }
    }, [_c("el-aside", {
      staticClass: "_fc-l",
      attrs: {
        width: "266px"
      }
    }, [_vm._l(_vm.menuList, function (item, index) {
      return [_c("div", {
        key: index,
        staticClass: "_fc-l-group"
      }, [_c("h4", {
        staticClass: "_fc-l-title"
      }, [_vm._v(_vm._s(item.title))]), _vm._v(" "), _c("draggable", {
        attrs: {
          group: {
            name: "default",
            pull: "clone",
            put: false
          },
          sort: false,
          list: item.list
        }
      }, _vm._l(item.list, function (data, index) {
        return _c("div", {
          key: index,
          staticClass: "_fc-l-item"
        }, [_c("div", {
          staticClass: "_fc-l-icon"
        }, [_c("i", {
          staticClass: "fc-icon",
          "class": data.icon || "icon-input"
        })]), _vm._v(" "), _c("span", {
          staticClass: "_fc-l-name"
        }, [_vm._v(_vm._s(data.label))])]);
      }), 0)], 1)];
    })], 2), _vm._v(" "), _c("ElContainer", {
      staticClass: "_fc-m"
    }, [_c("el-header", {
      staticClass: "_fc-m-tools",
      attrs: {
        height: "45"
      }
    }, [_vm._t("handle"), _vm._v(" "), _c("el-button", {
      attrs: {
        type: "primary",
        icon: "fc-icon icon-preview",
        plain: "",
        round: "",
        size: "mini"
      },
      on: {
        click: _vm.previewFc
      }
    }, [_vm._v("预 览\n          ")]), _vm._v(" "), _c("el-button", {
      attrs: {
        type: "danger",
        icon: "fc-icon icon-delete",
        plain: "",
        round: "",
        size: "mini"
      },
      on: {
        click: _vm.clearDragRule
      }
    }, [_vm._v("清 空\n          ")])], 2), _vm._v(" "), _c("ElMain", {
      staticStyle: {
        background: "#F5F5F5",
        padding: "20px"
      }
    }, [_c("div", {
      staticClass: "_fc-m-drag"
    }, [_c("FormCreate", {
      attrs: {
        rule: _vm.dragForm.rule,
        option: _vm.form.value
      },
      model: {
        value: _vm.dragForm.api,
        callback: function callback($$v) {
          _vm.$set(_vm.dragForm, "api", $$v);
        },
        expression: "dragForm.api"
      }
    })], 1)])], 1), _vm._v(" "), _c("ElAside", {
      staticClass: "_fc-r",
      attrs: {
        width: "320px"
      }
    }, [_c("ElContainer", {
      staticStyle: {
        height: "100%"
      }
    }, [_c("el-header", {
      staticClass: "_fc-r-tabs",
      attrs: {
        height: "40px"
      }
    }, [!!_vm.activeRule ? _c("div", {
      staticClass: "_fc-r-tab",
      "class": {
        active: _vm.activeTab === "props"
      },
      on: {
        click: function click($event) {
          _vm.activeTab = "props";
        }
      }
    }, [_vm._v("组件配置\n            ")]) : _vm._e(), _vm._v(" "), _c("div", {
      staticClass: "_fc-r-tab",
      "class": {
        active: _vm.activeTab === "form" && !!_vm.activeRule
      },
      on: {
        click: function click($event) {
          _vm.activeTab = "form";
        }
      }
    }, [_vm._v("表单配置\n            ")])]), _vm._v(" "), _c("ElMain", {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: _vm.activeTab === "form",
        expression: "activeTab==='form'"
      }]
    }, [_c("FormCreate", {
      attrs: {
        rule: _vm.form.rule,
        option: _vm.form.option,
        value: _vm.form.value.form
      },
      on: {
        "update:value": function updateValue($event) {
          return _vm.$set(_vm.form.value, "form", $event);
        }
      }
    })], 1), _vm._v(" "), _c("ElMain", {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: _vm.activeTab === "props",
        expression: "activeTab==='props'"
      }],
      key: _vm.activeRule ? _vm.activeRule.id : "",
      staticStyle: {
        padding: "0 20px"
      }
    }, [_c("div", [_vm.showBaseRule ? _c("ElDivider", [_vm._v("基础配置")]) : _vm._e(), _vm._v(" "), _c("FormCreate", {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: _vm.showBaseRule,
        expression: "showBaseRule"
      }],
      attrs: {
        rule: _vm.baseForm.rule,
        option: _vm.baseForm.options
      },
      on: {
        change: _vm.baseChange
      },
      model: {
        value: _vm.baseForm.api,
        callback: function callback($$v) {
          _vm.$set(_vm.baseForm, "api", $$v);
        },
        expression: "baseForm.api"
      }
    }), _vm._v(" "), _c("ElDivider", [_vm._v("属性配置")]), _vm._v(" "), _c("FormCreate", {
      attrs: {
        rule: _vm.propsForm.rule,
        option: _vm.propsForm.options
      },
      on: {
        change: _vm.propChange,
        removeField: _vm.propRemoveField
      },
      model: {
        value: _vm.propsForm.api,
        callback: function callback($$v) {
          _vm.$set(_vm.propsForm, "api", $$v);
        },
        expression: "propsForm.api"
      }
    }), _vm._v(" "), _vm.showBaseRule ? _c("ElDivider", [_vm._v("验证规则")]) : _vm._e(), _vm._v(" "), _c("FormCreate", {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: _vm.showBaseRule,
        expression: "showBaseRule"
      }],
      attrs: {
        rule: _vm.validateForm.rule,
        option: _vm.validateForm.options
      },
      on: {
        "update:value": _vm.validateChange
      },
      model: {
        value: _vm.validateForm.api,
        callback: function callback($$v) {
          _vm.$set(_vm.validateForm, "api", $$v);
        },
        expression: "validateForm.api"
      }
    })], 1)])], 1)], 1), _vm._v(" "), _c("ElDialog", {
      attrs: {
        visible: _vm.preview.state,
        width: "800px",
        "append-to-body": ""
      },
      on: {
        "update:visible": function updateVisible($event) {
          return _vm.$set(_vm.preview, "state", $event);
        }
      }
    }, [_vm.preview.state ? _c("FormCreate", {
      attrs: {
        rule: _vm.preview.rule,
        option: _vm.preview.option
      }
    }) : _vm._e()], 1)], 1)], 1)], 1);
  };

  var __vue_staticRenderFns__$4 = [];
  __vue_render__$4._withStripped = true;
  /* style */

  var __vue_inject_styles__$5 = undefined;
  /* scoped */

  var __vue_scope_id__$5 = undefined;
  /* module identifier */

  var __vue_module_identifier__$5 = undefined;
  /* functional template */

  var __vue_is_functional_template__$5 = false;
  /* style inject */

  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__$5 = /*#__PURE__*/normalizeComponent({
    render: __vue_render__$4,
    staticRenderFns: __vue_staticRenderFns__$4
  }, __vue_inject_styles__$5, __vue_script__$5, __vue_scope_id__$5, __vue_is_functional_template__$5, __vue_module_identifier__$5, false, undefined, undefined, undefined);

  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  var id = 1;
  var script$4 = {
    name: 'DragTool',
    inject: ['fcx'],
    props: ['dragBtn', 'children', 'unique'],
    data: function data() {
      return {
        id: this.unique || id++,
        state: this.fcx
      };
    },
    methods: {
      active: function active() {
        if (this.state.active === this.id) { return; }
        this.state.active = this.id;
        this.$emit('active');
      }
    },
    beforeDestroy: function beforeDestroy() {
      this.state = {};
    }
  };

  var css_248z$6 = ".drag-tool{position:relative;min-height:20px;box-sizing:border-box;padding:2px;outline:1px dashed #2e73ff;overflow:hidden;word-wrap:break-word;word-break:break-all}.drag-tool .drag-tool{margin:5px}.drag-tool+.drag-tool{margin-top:5px}.drag-tool.active{outline:2px solid #2e73ff}.drag-tool.active>div>.drag-btn{display:flex}.drag-tool .drag-btn{display:none}.drag-r{right:2px;bottom:2px}.drag-l,.drag-r{position:absolute;z-index:999}.drag-l{top:0;left:0}.drag-btn{height:18px;width:18px;color:#fff;background-color:#2e73ff;text-align:center;line-height:20px;padding-bottom:1px;float:left;cursor:pointer;justify-content:center}.drag-btn+.drag-btn{margin-left:2px}.drag-btn-danger{background-color:#ff2e2e}.drag-btn i{font-size:13px}";
  styleInject(css_248z$6);

  /* script */
  var __vue_script__$4 = script$4;
  /* template */

  var __vue_render__$3 = function __vue_render__() {
    var _vm = this;

    var _h = _vm.$createElement;

    var _c = _vm._self._c || _h;

    return _c("div", {
      staticClass: "drag-tool",
      "class": {
        active: _vm.state.active === _vm.id
      },
      on: {
        click: function click($event) {
          $event.stopPropagation();
          return _vm.active($event);
        }
      }
    }, [_c("div", {
      staticClass: "drag-l"
    }, [_vm.state.active === _vm.id && _vm.dragBtn !== false ? _c("div", {
      staticClass: "drag-btn _fc-drag-btn",
      staticStyle: {
        cursor: "move"
      }
    }, [_c("i", {
      staticClass: "fc-icon icon-move"
    })]) : _vm._e()]), _vm._v(" "), _c("div", {
      staticClass: "drag-r"
    }, [_c("div", {
      staticClass: "drag-btn",
      on: {
        click: function click($event) {
          return _vm.$emit("add");
        }
      }
    }, [_c("i", {
      staticClass: "fc-icon icon-add"
    })]), _vm._v(" "), _c("div", {
      staticClass: "drag-btn",
      on: {
        click: function click($event) {
          return _vm.$emit("copy");
        }
      }
    }, [_c("i", {
      staticClass: "fc-icon icon-copy"
    })]), _vm._v(" "), _vm.children ? _c("div", {
      staticClass: "drag-btn",
      on: {
        click: function click($event) {
          return _vm.$emit("addChild");
        }
      }
    }, [_c("i", {
      staticClass: "fc-icon icon-add-child"
    })]) : _vm._e(), _vm._v(" "), _c("div", {
      staticClass: "drag-btn drag-btn-danger",
      on: {
        click: function click($event) {
          return _vm.$emit("delete");
        }
      }
    }, [_c("i", {
      staticClass: "fc-icon icon-delete"
    })])]), _vm._v(" "), _vm._t("default")], 2);
  };

  var __vue_staticRenderFns__$3 = [];
  __vue_render__$3._withStripped = true;
  /* style */

  var __vue_inject_styles__$4 = undefined;
  /* scoped */

  var __vue_scope_id__$4 = undefined;
  /* module identifier */

  var __vue_module_identifier__$4 = undefined;
  /* functional template */

  var __vue_is_functional_template__$4 = false;
  /* style inject */

  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__$4 = /*#__PURE__*/normalizeComponent({
    render: __vue_render__$3,
    staticRenderFns: __vue_staticRenderFns__$3
  }, __vue_inject_styles__$4, __vue_script__$4, __vue_scope_id__$4, __vue_is_functional_template__$4, __vue_module_identifier__$4, false, undefined, undefined, undefined);

  var jsonlint_1 = createCommonjsModule(function (module) {
  var jsonlint = (function(){var require=true,module=false;var exports={};/*
      json_parse.js
      2016-05-02

      Public Domain.

      NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.

      This file creates a json_parse function.

          json_parse(text, reviver)
              This method parses a JSON text to produce an object or array.
              It can throw a SyntaxError exception.

              The optional reviver parameter is a function that can filter and
              transform the results. It receives each of the keys and values,
              and its return value is used instead of the original value.
              If it returns what it received, then the structure is not modified.
              If it returns undefined then the member is deleted.

              Example:

              // Parse the text. Values that look like ISO date strings will
              // be converted to Date objects.

              myData = json_parse(text, function (key, value) {
                  var a;
                  if (typeof value === "string") {
                      a =
  /^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}(?:\.\d*)?)Z$/.exec(value);
                      if (a) {
                          return new Date(Date.UTC(+a[1], +a[2] - 1, +a[3], +a[4],
                              +a[5], +a[6]));
                      }
                  }
                  return value;
              });

      This is a reference implementation. You are free to copy, modify, or
      redistribute.

      This code should be minified before deployment.
      See http://javascript.crockford.com/jsmin.html

      USE YOUR OWN COPY. IT IS EXTREMELY UNWISE TO LOAD CODE FROM SERVERS YOU DO
      NOT CONTROL.
  */

  /*jslint for */

  /*property
      at, b, call, charAt, f, fromCharCode, hasOwnProperty, message, n, name,
      prototype, push, r, t, text
  */

  var ___dougJSONParse = (function () {

  // This is a function that can parse a JSON text, producing a JavaScript
  // data structure. It is a simple, recursive descent parser. It does not use
  // eval or regular expressions, so it can be used as a model for implementing
  // a JSON parser in other languages.

  // We are defining the function inside of another function to avoid creating
  // global variables.

      var at;     // The index of the current character
      var ch;     // The current character
      var escapee = {
          "\"": "\"",
          "\\": "\\",
          "/": "/",
          b: "\b",
          f: "\f",
          n: "\n",
          r: "\r",
          t: "\t"
      };
      var text;

      var error = function (m) {

  // Call error when something is wrong.

          throw {
              name: "SyntaxError",
              message: m,
              at: at,
              text: text
          };
      };

      var next = function (c) {

  // If a c parameter is provided, verify that it matches the current character.

          if (c && c !== ch) {
              error("Expected '" + c + "' instead of '" + ch + "'");
          }

  // Get the next character. When there are no more characters,
  // return the empty string.

          ch = text.charAt(at);
          at += 1;
          return ch;
      };

      var number = function () {

  // Parse a number value.

          var value;
          var string = "";

          if (ch === "-") {
              string = "-";
              next("-");
          }
          while (ch >= "0" && ch <= "9") {
              string += ch;
              next();
          }
          if (ch === ".") {
              string += ".";
              while (next() && ch >= "0" && ch <= "9") {
                  string += ch;
              }
          }
          if (ch === "e" || ch === "E") {
              string += ch;
              next();
              if (ch === "-" || ch === "+") {
                  string += ch;
                  next();
              }
              while (ch >= "0" && ch <= "9") {
                  string += ch;
                  next();
              }
          }
          value = +string;
          if (!isFinite(value)) {
              error("Bad number");
          } else {
              return value;
          }
      };

      var string = function () {

  // Parse a string value.

          var hex;
          var i;
          var value = "";
          var uffff;

  // When parsing for string values, we must look for " and \ characters.

          if (ch === "\"") {
              while (next()) {
                  if (ch === "\"") {
                      next();
                      return value;
                  }
                  if (ch === "\\") {
                      next();
                      if (ch === "u") {
                          uffff = 0;
                          for (i = 0; i < 4; i += 1) {
                              hex = parseInt(next(), 16);
                              if (!isFinite(hex)) {
                                  break;
                              }
                              uffff = uffff * 16 + hex;
                          }
                          value += String.fromCharCode(uffff);
                      } else if (typeof escapee[ch] === "string") {
                          value += escapee[ch];
                      } else {
                          break;
                      }
                  } else {
                      value += ch;
                  }
              }
          }
          error("Bad string");
      };

      var white = function () {

  // Skip whitespace.

          while (ch && ch <= " ") {
              next();
          }
      };

      var word = function () {

  // true, false, or null.

          switch (ch) {
          case "t":
              next("t");
              next("r");
              next("u");
              next("e");
              return true;
          case "f":
              next("f");
              next("a");
              next("l");
              next("s");
              next("e");
              return false;
          case "n":
              next("n");
              next("u");
              next("l");
              next("l");
              return null;
          }
          error("Unexpected '" + ch + "'");
      };

      var value;  // Place holder for the value function.

      var array = function () {

  // Parse an array value.

          var arr = [];

          if (ch === "[") {
              next("[");
              white();
              if (ch === "]") {
                  next("]");
                  return arr;   // empty array
              }
              while (ch) {
                  arr.push(value());
                  white();
                  if (ch === "]") {
                      next("]");
                      return arr;
                  }
                  next(",");
                  white();
              }
          }
          error("Bad array");
      };

      var object = function () {

  // Parse an object value.

          var key;
          var obj = {};

          if (ch === "{") {
              next("{");
              white();
              if (ch === "}") {
                  next("}");
                  return obj;   // empty object
              }
              while (ch) {
                  key = string();
                  white();
                  next(":");
                  if (Object.hasOwnProperty.call(obj, key)) {
                      error("Duplicate key '" + key + "'");
                  }
                  obj[key] = value();
                  white();
                  if (ch === "}") {
                      next("}");
                      return obj;
                  }
                  next(",");
                  white();
              }
          }
          error("Bad object");
      };

      value = function () {

  // Parse a JSON value. It could be an object, an array, a string, a number,
  // or a word.

          white();
          switch (ch) {
          case "{":
              return object();
          case "[":
              return array();
          case "\"":
              return string();
          case "-":
              return number();
          default:
              return (ch >= "0" && ch <= "9")
                  ? number()
                  : word();
          }
      };

  // Return the json_parse function. It will have access to all of the above
  // functions and variables.

      return function (source, reviver) {
          var result;

          text = source;
          at = 0;
          ch = " ";
          result = value();
          white();
          if (ch) {
              error("Syntax error");
          }

  // If there is a reviver function, we recursively walk the new structure,
  // passing each name/value pair to the reviver function for possible
  // transformation, starting with a temporary root object that holds the result
  // in an empty key. If there is not a reviver function, we simply return the
  // result.

          return (typeof reviver === "function")
              ? (function walk(holder, key) {
                  var k;
                  var v;
                  var val = holder[key];
                  if (val && typeof val === "object") {
                      for (k in val) {
                          if (Object.prototype.hasOwnProperty.call(val, k)) {
                              v = walk(val, k);
                              if (v !== undefined) {
                                  val[k] = v;
                              } else {
                                  delete val[k];
                              }
                          }
                      }
                  }
                  return reviver.call(holder, key, val);
              }({"": result}, ""))
              : result;
      };
  }());
  /* Jison generated parser */
  var jsonlint = (function(){
  var parser = {trace: function trace() { },
  yy: {},
  symbols_: {"error":2,"JSONString":3,"STRING":4,"JSONNumber":5,"NUMBER":6,"JSONNullLiteral":7,"NULL":8,"JSONBooleanLiteral":9,"TRUE":10,"FALSE":11,"JSONText":12,"JSONValue":13,"EOF":14,"JSONObject":15,"JSONArray":16,"{":17,"}":18,"JSONMemberList":19,"JSONMember":20,":":21,",":22,"[":23,"]":24,"JSONElementList":25,"$accept":0,"$end":1},
  terminals_: {2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},
  productions_: [0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],
  performAction: function anonymous(yytext,yyleng,yylineno,yy,yystate,$$,_$) {

  var $0 = $$.length - 1;
  switch (yystate) {
  case 1: // replace escaped characters with actual character
            this.$ = yytext.replace(/\\(\\|")/g, "$"+"1")
                       .replace(/\\n/g,'\n')
                       .replace(/\\r/g,'\r')
                       .replace(/\\t/g,'\t')
                       .replace(/\\v/g,'\v')
                       .replace(/\\f/g,'\f')
                       .replace(/\\b/g,'\b');

  break;
  case 2:this.$ = Number(yytext);
  break;
  case 3:this.$ = null;
  break;
  case 4:this.$ = true;
  break;
  case 5:this.$ = false;
  break;
  case 6:return this.$ = $$[$0-1];
  case 13:this.$ = {};
  break;
  case 14:this.$ = $$[$0-1];
  break;
  case 15:this.$ = [$$[$0-2], $$[$0]];
  break;
  case 16:this.$ = {}; this.$[$$[$0][0]] = $$[$0][1];
  break;
  case 17:this.$ = $$[$0-2]; $$[$0-2][$$[$0][0]] = $$[$0][1];
  break;
  case 18:this.$ = [];
  break;
  case 19:this.$ = $$[$0-1];
  break;
  case 20:this.$ = [$$[$0]];
  break;
  case 21:this.$ = $$[$0-2]; $$[$0-2].push($$[$0]);
  break;
  }
  },
  table: [{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],
  defaultActions: {16:[2,6]},
  parseError: function parseError(str, hash) {
      throw new Error(str);
  },
  parse: function parse(input) {
      var self = this,
          stack = [0],
          vstack = [null], // semantic value stack
          lstack = [], // location stack
          table = this.table,
          yytext = '',
          yylineno = 0,
          yyleng = 0,
          recovering = 0,
          TERROR = 2,
          EOF = 1;

      //this.reductionCount = this.shiftCount = 0;

      this.lexer.setInput(input);
      this.lexer.yy = this.yy;
      this.yy.lexer = this.lexer;
      if (typeof this.lexer.yylloc == 'undefined')
          { this.lexer.yylloc = {}; }
      var yyloc = this.lexer.yylloc;
      lstack.push(yyloc);

      if (typeof this.yy.parseError === 'function')
          { this.parseError = this.yy.parseError; }

      function popStack (n) {
          stack.length = stack.length - 2*n;
          vstack.length = vstack.length - n;
          lstack.length = lstack.length - n;
      }

      function lex() {
          var token;
          token = self.lexer.lex() || 1; // $end = 1
          // if token isn't its numeric value, convert
          if (typeof token !== 'number') {
              token = self.symbols_[token] || token;
          }
          return token;
      }

      var symbol, preErrorSymbol, state, action, r, yyval={},p,len,newState, expected;
      while (true) {
          // retreive state number from top of stack
          state = stack[stack.length-1];

          // use default actions if available
          if (this.defaultActions[state]) {
              action = this.defaultActions[state];
          } else {
              if (symbol == null)
                  { symbol = lex(); }
              // read action for current state and first input
              action = table[state] && table[state][symbol];
          }

          // handle parse error
          if (typeof action === 'undefined' || !action.length || !action[0]) {

              if (!recovering) {
                  // Report error
                  expected = [];
                  for (p in table[state]) { if (this.terminals_[p] && p > 2) {
                      expected.push("'"+this.terminals_[p]+"'");
                  } }
                  var errStr = '';
                  if (this.lexer.showPosition) {
                      errStr = 'Parse error on line '+(yylineno+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + this.terminals_[symbol]+ "'";
                  } else {
                      errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                    (symbol == 1 /*EOF*/ ? "end of input" :
                                                ("'"+(this.terminals_[symbol] || symbol)+"'"));
                  }
                  this.parseError(errStr,
                      {text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected: expected});
              }

              // just recovered from another error
              if (recovering == 3) {
                  if (symbol == EOF) {
                      throw new Error(errStr || 'Parsing halted.');
                  }

                  // discard current lookahead and grab another
                  yyleng = this.lexer.yyleng;
                  yytext = this.lexer.yytext;
                  yylineno = this.lexer.yylineno;
                  yyloc = this.lexer.yylloc;
                  symbol = lex();
              }

              // try to recover from error
              while (1) {
                  // check for error recovery rule in this state
                  if ((TERROR.toString()) in table[state]) {
                      break;
                  }
                  if (state == 0) {
                      throw new Error(errStr || 'Parsing halted.');
                  }
                  popStack(1);
                  state = stack[stack.length-1];
              }

              preErrorSymbol = symbol; // save the lookahead token
              symbol = TERROR;         // insert generic error symbol as new lookahead
              state = stack[stack.length-1];
              action = table[state] && table[state][TERROR];
              recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
          }

          // this shouldn't happen, unless resolve defaults are off
          if (action[0] instanceof Array && action.length > 1) {
              throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
          }

          switch (action[0]) {

              case 1: // shift
                  //this.shiftCount++;

                  stack.push(symbol);
                  vstack.push(this.lexer.yytext);
                  lstack.push(this.lexer.yylloc);
                  stack.push(action[1]); // push state
                  symbol = null;
                  if (!preErrorSymbol) { // normal execution/no error
                      yyleng = this.lexer.yyleng;
                      yytext = this.lexer.yytext;
                      yylineno = this.lexer.yylineno;
                      yyloc = this.lexer.yylloc;
                      if (recovering > 0)
                          { recovering--; }
                  } else { // error just occurred, resume old lookahead f/ before error
                      symbol = preErrorSymbol;
                      preErrorSymbol = null;
                  }
                  break;

              case 2: // reduce
                  //this.reductionCount++;

                  len = this.productions_[action[1]][1];

                  // perform semantic action
                  yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                  // default location, uses first token for firsts, last for lasts
                  yyval._$ = {
                      first_line: lstack[lstack.length-(len||1)].first_line,
                      last_line: lstack[lstack.length-1].last_line,
                      first_column: lstack[lstack.length-(len||1)].first_column,
                      last_column: lstack[lstack.length-1].last_column
                  };
                  r = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);

                  if (typeof r !== 'undefined') {
                      return r;
                  }

                  // pop off stack
                  if (len) {
                      stack = stack.slice(0,-1*len*2);
                      vstack = vstack.slice(0, -1*len);
                      lstack = lstack.slice(0, -1*len);
                  }

                  stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                  vstack.push(yyval.$);
                  lstack.push(yyval._$);
                  // goto new state = table[STATE][NONTERMINAL]
                  newState = table[stack[stack.length-2]][stack[stack.length-1]];
                  stack.push(newState);
                  break;

              case 3: // accept
                  return true;
          }

      }

      return true;
  }};
  /* Jison generated lexer */
  var lexer = (function(){
  var lexer = ({EOF:1,
  parseError:function parseError(str, hash) {
          if (this.yy.parseError) {
              this.yy.parseError(str, hash);
          } else {
              throw new Error(str);
          }
      },
  setInput:function (input) {
          this._input = input;
          this._more = this._less = this.done = false;
          this.yylineno = this.yyleng = 0;
          this.yytext = this.matched = this.match = '';
          this.conditionStack = ['INITIAL'];
          this.yylloc = {first_line:1,first_column:0,last_line:1,last_column:0};
          return this;
      },
  input:function () {
          var ch = this._input[0];
          this.yytext+=ch;
          this.yyleng++;
          this.match+=ch;
          this.matched+=ch;
          var lines = ch.match(/\n/);
          if (lines) { this.yylineno++; }
          this._input = this._input.slice(1);
          return ch;
      },
  unput:function (ch) {
          this._input = ch + this._input;
          return this;
      },
  more:function () {
          this._more = true;
          return this;
      },
  less:function (n) {
          this._input = this.match.slice(n) + this._input;
      },
  pastInput:function () {
          var past = this.matched.substr(0, this.matched.length - this.match.length);
          return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
      },
  upcomingInput:function () {
          var next = this.match;
          if (next.length < 20) {
              next += this._input.substr(0, 20-next.length);
          }
          return (next.substr(0,20)+(next.length > 20 ? '...':'')).replace(/\n/g, "");
      },
  showPosition:function () {
          var pre = this.pastInput();
          var c = new Array(pre.length + 1).join("-");
          return pre + this.upcomingInput() + "\n" + c+"^";
      },
  next:function () {
          if (this.done) {
              return this.EOF;
          }
          if (!this._input) { this.done = true; }

          var token,
              match,
              tempMatch,
              index,
              lines;
          if (!this._more) {
              this.yytext = '';
              this.match = '';
          }
          var rules = this._currentRules();
          for (var i=0;i < rules.length; i++) {
              tempMatch = this._input.match(this.rules[rules[i]]);
              if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                  match = tempMatch;
                  index = i;
                  if (!this.options.flex) { break; }
              }
          }
          if (match) {
              lines = match[0].match(/\n.*/g);
              if (lines) { this.yylineno += lines.length; }
              this.yylloc = {first_line: this.yylloc.last_line,
                             last_line: this.yylineno+1,
                             first_column: this.yylloc.last_column,
                             last_column: lines ? lines[lines.length-1].length-1 : this.yylloc.last_column + match[0].length};
              this.yytext += match[0];
              this.match += match[0];
              this.yyleng = this.yytext.length;
              this._more = false;
              this._input = this._input.slice(match[0].length);
              this.matched += match[0];
              token = this.performAction.call(this, this.yy, this, rules[index],this.conditionStack[this.conditionStack.length-1]);
              if (this.done && this._input) { this.done = false; }
              if (token) { return token; }
              else { return; }
          }
          if (this._input === "") {
              return this.EOF;
          } else {
              this.parseError('Lexical error on line '+(this.yylineno+1)+'. Unrecognized text.\n'+this.showPosition(),
                      {text: "", token: null, line: this.yylineno});
          }
      },
  lex:function lex() {
          var r = this.next();
          if (typeof r !== 'undefined') {
              return r;
          } else {
              return this.lex();
          }
      },
  begin:function begin(condition) {
          this.conditionStack.push(condition);
      },
  popState:function popState() {
          return this.conditionStack.pop();
      },
  _currentRules:function _currentRules() {
          return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules;
      },
  topState:function () {
          return this.conditionStack[this.conditionStack.length-2];
      },
  pushState:function begin(condition) {
          this.begin(condition);
      }});
  lexer.options = {};
  lexer.performAction = function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {
  switch($avoiding_name_collisions) {
  case 0:/* skip whitespace */
  break;
  case 1:return 6
  case 2:yy_.yytext = yy_.yytext.substr(1,yy_.yyleng-2); return 4
  case 3:return 17
  case 4:return 18
  case 5:return 23
  case 6:return 24
  case 7:return 22
  case 8:return 21
  case 9:return 10
  case 10:return 11
  case 11:return 8
  case 12:return 14
  case 13:return 'INVALID'
  }
  };
  lexer.rules = [/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/];
  lexer.conditions = {"INITIAL":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13],"inclusive":true}};
  return lexer;})();
  parser.lexer = lexer;
  return parser;
  })();

  var origParse = jsonlint.parse;

  jsonlint.parse = function(input) {
      var result = origParse.call(jsonlint, input);
      var dougJSONParse = typeof ___dougJSONParse === 'undefined' ? require('./doug-json-parse') : ___dougJSONParse;
      try {
          dougJSONParse(input);
      } catch(e) {
          if(/Duplicate key|Bad string|Unexpected/.test(e.message)) {
              var linesUntilError = input.substring(0, e.at).split('\n');
              var line = linesUntilError.length;
              var col = linesUntilError[line - 1].length - 1;

              this.parseError(e.message, {line: line, col: col, message: e.message.replace(/./, function(l) { return l.toLowerCase(); })});
              throw SyntaxError(e.message + ' on line ' + line);
          }
      }

      return result;
  };

  if (typeof exports !== 'undefined') {
  exports.parser = jsonlint;
  exports.parse = function () { return jsonlint.parse.apply(jsonlint, arguments); };
  exports.main = function commonjsMain(args) {
      if (!args[1])
          { throw new Error('Usage: '+args[0]+' FILE'); }
      if (typeof process !== 'undefined') {
          var source = require('fs').readFileSync(require('path').join(process.cwd(), args[1]), "utf8");
      } else {
          var cwd = require("file").path(require("file").cwd());
          var source = cwd.join(args[1]).read({charset: "utf-8"});
      }
      return exports.parser.parse(source);
  };
  if (require.main === module) {
    exports.main(typeof process !== 'undefined' ? process.argv.slice(1) : require("system").args);
  }
  }
  return exports;})();if(module.exports) { module.exports = jsonlint; }
  });

  var css_248z$5 = ".CodeMirror{font-family:monospace;height:300px;color:#000;direction:ltr}.CodeMirror-lines{padding:4px 0}.CodeMirror pre.CodeMirror-line,.CodeMirror pre.CodeMirror-line-like{padding:0 4px}.CodeMirror-gutter-filler,.CodeMirror-scrollbar-filler{background-color:#fff}.CodeMirror-gutters{border-right:1px solid #ddd;background-color:#f7f7f7;white-space:nowrap}.CodeMirror-linenumber{padding:0 3px 0 5px;min-width:20px;text-align:right;color:#999;white-space:nowrap}.CodeMirror-guttermarker{color:#000}.CodeMirror-guttermarker-subtle{color:#999}.CodeMirror-cursor{border-left:1px solid #000;border-right:none;width:0}.CodeMirror div.CodeMirror-secondarycursor{border-left:1px solid silver}.cm-fat-cursor .CodeMirror-cursor{width:auto;border:0!important;background:#7e7}.cm-fat-cursor div.CodeMirror-cursors{z-index:1}.cm-fat-cursor-mark{background-color:rgba(20,255,20,.5)}.cm-animate-fat-cursor,.cm-fat-cursor-mark{-webkit-animation:blink 1.06s steps(1) infinite;-moz-animation:blink 1.06s steps(1) infinite;animation:blink 1.06s steps(1) infinite}.cm-animate-fat-cursor{width:auto;border:0;background-color:#7e7}@-moz-keyframes blink{50%{background-color:transparent}}@-webkit-keyframes blink{50%{background-color:transparent}}@keyframes blink{50%{background-color:transparent}}.cm-tab{display:inline-block;text-decoration:inherit}.CodeMirror-rulers{position:absolute;left:0;right:0;top:-50px;bottom:0;overflow:hidden}.CodeMirror-ruler{border-left:1px solid #ccc;top:0;bottom:0;position:absolute}.cm-s-default .cm-header{color:#00f}.cm-s-default .cm-quote{color:#090}.cm-negative{color:#d44}.cm-positive{color:#292}.cm-header,.cm-strong{font-weight:700}.cm-em{font-style:italic}.cm-link{text-decoration:underline}.cm-strikethrough{text-decoration:line-through}.cm-s-default .cm-keyword{color:#708}.cm-s-default .cm-atom{color:#219}.cm-s-default .cm-number{color:#164}.cm-s-default .cm-def{color:#00f}.cm-s-default .cm-variable-2{color:#05a}.cm-s-default .cm-type,.cm-s-default .cm-variable-3{color:#085}.cm-s-default .cm-comment{color:#a50}.cm-s-default .cm-string{color:#a11}.cm-s-default .cm-string-2{color:#f50}.cm-s-default .cm-meta,.cm-s-default .cm-qualifier{color:#555}.cm-s-default .cm-builtin{color:#30a}.cm-s-default .cm-bracket{color:#997}.cm-s-default .cm-tag{color:#170}.cm-s-default .cm-attribute{color:#00c}.cm-s-default .cm-hr{color:#999}.cm-s-default .cm-link{color:#00c}.cm-invalidchar,.cm-s-default .cm-error{color:red}.CodeMirror-composing{border-bottom:2px solid}div.CodeMirror span.CodeMirror-matchingbracket{color:#0b0}div.CodeMirror span.CodeMirror-nonmatchingbracket{color:#a22}.CodeMirror-matchingtag{background:rgba(255,150,0,.3)}.CodeMirror-activeline-background{background:#e8f2ff}.CodeMirror{position:relative;overflow:hidden;background:#fff}.CodeMirror-scroll{overflow:scroll!important;margin-bottom:-50px;margin-right:-50px;padding-bottom:50px;height:100%;outline:none;position:relative}.CodeMirror-sizer{position:relative;border-right:50px solid transparent}.CodeMirror-gutter-filler,.CodeMirror-hscrollbar,.CodeMirror-scrollbar-filler,.CodeMirror-vscrollbar{position:absolute;z-index:6;display:none;outline:none}.CodeMirror-vscrollbar{right:0;top:0;overflow-x:hidden;overflow-y:scroll}.CodeMirror-hscrollbar{bottom:0;left:0;overflow-y:hidden;overflow-x:scroll}.CodeMirror-scrollbar-filler{right:0;bottom:0}.CodeMirror-gutter-filler{left:0;bottom:0}.CodeMirror-gutters{position:absolute;left:0;top:0;min-height:100%;z-index:3}.CodeMirror-gutter{white-space:normal;height:100%;display:inline-block;vertical-align:top;margin-bottom:-50px}.CodeMirror-gutter-wrapper{position:absolute;z-index:4;background:none!important;border:none!important}.CodeMirror-gutter-background{position:absolute;top:0;bottom:0;z-index:4}.CodeMirror-gutter-elt{position:absolute;cursor:default;z-index:4}.CodeMirror-gutter-wrapper ::selection{background-color:transparent}.CodeMirror-gutter-wrapper ::-moz-selection{background-color:transparent}.CodeMirror-lines{cursor:text;min-height:1px}.CodeMirror pre.CodeMirror-line,.CodeMirror pre.CodeMirror-line-like{-moz-border-radius:0;-webkit-border-radius:0;border-radius:0;border-width:0;background:transparent;font-family:inherit;font-size:inherit;margin:0;white-space:pre;word-wrap:normal;line-height:inherit;color:inherit;z-index:2;position:relative;overflow:visible;-webkit-tap-highlight-color:transparent;-webkit-font-variant-ligatures:contextual;font-variant-ligatures:contextual}.CodeMirror-wrap pre.CodeMirror-line,.CodeMirror-wrap pre.CodeMirror-line-like{word-wrap:break-word;white-space:pre-wrap;word-break:normal}.CodeMirror-linebackground{position:absolute;left:0;right:0;top:0;bottom:0;z-index:0}.CodeMirror-linewidget{position:relative;z-index:2;padding:.1px}.CodeMirror-rtl pre{direction:rtl}.CodeMirror-code{outline:none}.CodeMirror-gutter,.CodeMirror-gutters,.CodeMirror-linenumber,.CodeMirror-scroll,.CodeMirror-sizer{-moz-box-sizing:content-box;box-sizing:content-box}.CodeMirror-measure{position:absolute;width:100%;height:0;overflow:hidden;visibility:hidden}.CodeMirror-cursor{position:absolute;pointer-events:none}.CodeMirror-measure pre{position:static}div.CodeMirror-cursors{visibility:hidden;position:relative;z-index:3}.CodeMirror-focused div.CodeMirror-cursors,div.CodeMirror-dragcursors{visibility:visible}.CodeMirror-selected{background:#d9d9d9}.CodeMirror-focused .CodeMirror-selected{background:#d7d4f0}.CodeMirror-crosshair{cursor:crosshair}.CodeMirror-line::selection,.CodeMirror-line>span::selection,.CodeMirror-line>span>span::selection{background:#d7d4f0}.CodeMirror-line::-moz-selection,.CodeMirror-line>span::-moz-selection,.CodeMirror-line>span>span::-moz-selection{background:#d7d4f0}.cm-searching{background-color:#ffa;background-color:rgba(255,255,0,.4)}.cm-force-border{padding-right:.1px}@media print{.CodeMirror div.CodeMirror-cursors{visibility:hidden}}.cm-tab-wrap-hack:after{content:\"\"}span.CodeMirror-selectedtext{background:none}";
  styleInject(css_248z$5);

  var css_248z$4 = ".CodeMirror-lint-markers{width:16px}.CodeMirror-lint-tooltip{background-color:#ffd;border:1px solid #000;border-radius:4px 4px 4px 4px;color:#000;font-family:monospace;font-size:10pt;overflow:hidden;padding:2px 5px;position:fixed;white-space:pre;white-space:pre-wrap;z-index:100;max-width:600px;opacity:0;transition:opacity .4s;-moz-transition:opacity .4s;-webkit-transition:opacity .4s;-o-transition:opacity .4s;-ms-transition:opacity .4s}.CodeMirror-lint-mark{background-position:0 100%;background-repeat:repeat-x}.CodeMirror-lint-mark-warning{background-image:url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAADCAYAAAC09K7GAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9sJFhQXEbhTg7YAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAAMklEQVQI12NkgIIvJ3QXMjAwdDN+OaEbysDA4MPAwNDNwMCwiOHLCd1zX07o6kBVGQEAKBANtobskNMAAAAASUVORK5CYII=\")}.CodeMirror-lint-mark-error{background-image:url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAADCAYAAAC09K7GAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9sJDw4cOCW1/KIAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAAHElEQVQI12NggIL/DAz/GdA5/xkY/qPKMDAwAADLZwf5rvm+LQAAAABJRU5ErkJggg==\")}.CodeMirror-lint-marker{background-position:50%;background-repeat:no-repeat;cursor:pointer;display:inline-block;height:16px;width:16px;vertical-align:middle;position:relative}.CodeMirror-lint-message{padding-left:18px;background-position:0 0;background-repeat:no-repeat}.CodeMirror-lint-marker-warning,.CodeMirror-lint-message-warning{background-image:url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAANlBMVEX/uwDvrwD/uwD/uwD/uwD/uwD/uwD/uwD/uwD6twD/uwAAAADurwD2tQD7uAD+ugAAAAD/uwDhmeTRAAAADHRSTlMJ8mN1EYcbmiixgACm7WbuAAAAVklEQVR42n3PUQqAIBBFUU1LLc3u/jdbOJoW1P08DA9Gba8+YWJ6gNJoNYIBzAA2chBth5kLmG9YUoG0NHAUwFXwO9LuBQL1giCQb8gC9Oro2vp5rncCIY8L8uEx5ZkAAAAASUVORK5CYII=\")}.CodeMirror-lint-marker-error,.CodeMirror-lint-message-error{background-image:url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAHlBMVEW7AAC7AACxAAC7AAC7AAAAAAC4AAC5AAD///+7AAAUdclpAAAABnRSTlMXnORSiwCK0ZKSAAAATUlEQVR42mWPOQ7AQAgDuQLx/z8csYRmPRIFIwRGnosRrpamvkKi0FTIiMASR3hhKW+hAN6/tIWhu9PDWiTGNEkTtIOucA5Oyr9ckPgAWm0GPBog6v4AAAAASUVORK5CYII=\")}.CodeMirror-lint-marker-multiple{background-image:url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAHCAMAAADzjKfhAAAACVBMVEUAAAAAAAC/v7914kyHAAAAAXRSTlMAQObYZgAAACNJREFUeNo1ioEJAAAIwmz/H90iFFSGJgFMe3gaLZ0od+9/AQZ0ADosbYraAAAAAElFTkSuQmCC\");background-repeat:no-repeat;background-position:100% 100%;width:100%;height:100%}";
  styleInject(css_248z$4);

  var codemirror = createCommonjsModule(function (module, exports) {
  // CodeMirror, copyright (c) by Marijn Haverbeke and others
  // Distributed under an MIT license: https://codemirror.net/LICENSE

  // This is CodeMirror (https://codemirror.net), a code editor
  // implemented in JavaScript on top of the browser's DOM.
  //
  // You can find some technical background for some of the code below
  // at http://marijnhaverbeke.nl/blog/#cm-internals .

  (function (global, factory) {
    module.exports = factory() ;
  }(commonjsGlobal, (function () {
    // Kludges for bugs and behavior differences that can't be feature
    // detected are enabled based on userAgent etc sniffing.
    var userAgent = navigator.userAgent;
    var platform = navigator.platform;

    var gecko = /gecko\/\d/i.test(userAgent);
    var ie_upto10 = /MSIE \d/.test(userAgent);
    var ie_11up = /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(userAgent);
    var edge = /Edge\/(\d+)/.exec(userAgent);
    var ie = ie_upto10 || ie_11up || edge;
    var ie_version = ie && (ie_upto10 ? document.documentMode || 6 : +(edge || ie_11up)[1]);
    var webkit = !edge && /WebKit\//.test(userAgent);
    var qtwebkit = webkit && /Qt\/\d+\.\d+/.test(userAgent);
    var chrome = !edge && /Chrome\//.test(userAgent);
    var presto = /Opera\//.test(userAgent);
    var safari = /Apple Computer/.test(navigator.vendor);
    var mac_geMountainLion = /Mac OS X 1\d\D([8-9]|\d\d)\D/.test(userAgent);
    var phantom = /PhantomJS/.test(userAgent);

    var ios = safari && (/Mobile\/\w+/.test(userAgent) || navigator.maxTouchPoints > 2);
    var android = /Android/.test(userAgent);
    // This is woefully incomplete. Suggestions for alternative methods welcome.
    var mobile = ios || android || /webOS|BlackBerry|Opera Mini|Opera Mobi|IEMobile/i.test(userAgent);
    var mac = ios || /Mac/.test(platform);
    var chromeOS = /\bCrOS\b/.test(userAgent);
    var windows = /win/i.test(platform);

    var presto_version = presto && userAgent.match(/Version\/(\d*\.\d*)/);
    if (presto_version) { presto_version = Number(presto_version[1]); }
    if (presto_version && presto_version >= 15) { presto = false; webkit = true; }
    // Some browsers use the wrong event properties to signal cmd/ctrl on OS X
    var flipCtrlCmd = mac && (qtwebkit || presto && (presto_version == null || presto_version < 12.11));
    var captureRightClick = gecko || (ie && ie_version >= 9);

    function classTest(cls) { return new RegExp("(^|\\s)" + cls + "(?:$|\\s)\\s*") }

    var rmClass = function(node, cls) {
      var current = node.className;
      var match = classTest(cls).exec(current);
      if (match) {
        var after = current.slice(match.index + match[0].length);
        node.className = current.slice(0, match.index) + (after ? match[1] + after : "");
      }
    };

    function removeChildren(e) {
      for (var count = e.childNodes.length; count > 0; --count)
        { e.removeChild(e.firstChild); }
      return e
    }

    function removeChildrenAndAdd(parent, e) {
      return removeChildren(parent).appendChild(e)
    }

    function elt(tag, content, className, style) {
      var e = document.createElement(tag);
      if (className) { e.className = className; }
      if (style) { e.style.cssText = style; }
      if (typeof content == "string") { e.appendChild(document.createTextNode(content)); }
      else if (content) { for (var i = 0; i < content.length; ++i) { e.appendChild(content[i]); } }
      return e
    }
    // wrapper for elt, which removes the elt from the accessibility tree
    function eltP(tag, content, className, style) {
      var e = elt(tag, content, className, style);
      e.setAttribute("role", "presentation");
      return e
    }

    var range;
    if (document.createRange) { range = function(node, start, end, endNode) {
      var r = document.createRange();
      r.setEnd(endNode || node, end);
      r.setStart(node, start);
      return r
    }; }
    else { range = function(node, start, end) {
      var r = document.body.createTextRange();
      try { r.moveToElementText(node.parentNode); }
      catch(e) { return r }
      r.collapse(true);
      r.moveEnd("character", end);
      r.moveStart("character", start);
      return r
    }; }

    function contains(parent, child) {
      if (child.nodeType == 3) // Android browser always returns false when child is a textnode
        { child = child.parentNode; }
      if (parent.contains)
        { return parent.contains(child) }
      do {
        if (child.nodeType == 11) { child = child.host; }
        if (child == parent) { return true }
      } while (child = child.parentNode)
    }

    function activeElt() {
      // IE and Edge may throw an "Unspecified Error" when accessing document.activeElement.
      // IE < 10 will throw when accessed while the page is loading or in an iframe.
      // IE > 9 and Edge will throw when accessed in an iframe if document.body is unavailable.
      var activeElement;
      try {
        activeElement = document.activeElement;
      } catch(e) {
        activeElement = document.body || null;
      }
      while (activeElement && activeElement.shadowRoot && activeElement.shadowRoot.activeElement)
        { activeElement = activeElement.shadowRoot.activeElement; }
      return activeElement
    }

    function addClass(node, cls) {
      var current = node.className;
      if (!classTest(cls).test(current)) { node.className += (current ? " " : "") + cls; }
    }
    function joinClasses(a, b) {
      var as = a.split(" ");
      for (var i = 0; i < as.length; i++)
        { if (as[i] && !classTest(as[i]).test(b)) { b += " " + as[i]; } }
      return b
    }

    var selectInput = function(node) { node.select(); };
    if (ios) // Mobile Safari apparently has a bug where select() is broken.
      { selectInput = function(node) { node.selectionStart = 0; node.selectionEnd = node.value.length; }; }
    else if (ie) // Suppress mysterious IE10 errors
      { selectInput = function(node) { try { node.select(); } catch(_e) {} }; }

    function bind(f) {
      var args = Array.prototype.slice.call(arguments, 1);
      return function(){return f.apply(null, args)}
    }

    function copyObj(obj, target, overwrite) {
      if (!target) { target = {}; }
      for (var prop in obj)
        { if (obj.hasOwnProperty(prop) && (overwrite !== false || !target.hasOwnProperty(prop)))
          { target[prop] = obj[prop]; } }
      return target
    }

    // Counts the column offset in a string, taking tabs into account.
    // Used mostly to find indentation.
    function countColumn(string, end, tabSize, startIndex, startValue) {
      if (end == null) {
        end = string.search(/[^\s\u00a0]/);
        if (end == -1) { end = string.length; }
      }
      for (var i = startIndex || 0, n = startValue || 0;;) {
        var nextTab = string.indexOf("\t", i);
        if (nextTab < 0 || nextTab >= end)
          { return n + (end - i) }
        n += nextTab - i;
        n += tabSize - (n % tabSize);
        i = nextTab + 1;
      }
    }

    var Delayed = function() {
      this.id = null;
      this.f = null;
      this.time = 0;
      this.handler = bind(this.onTimeout, this);
    };
    Delayed.prototype.onTimeout = function (self) {
      self.id = 0;
      if (self.time <= +new Date) {
        self.f();
      } else {
        setTimeout(self.handler, self.time - +new Date);
      }
    };
    Delayed.prototype.set = function (ms, f) {
      this.f = f;
      var time = +new Date + ms;
      if (!this.id || time < this.time) {
        clearTimeout(this.id);
        this.id = setTimeout(this.handler, ms);
        this.time = time;
      }
    };

    function indexOf(array, elt) {
      for (var i = 0; i < array.length; ++i)
        { if (array[i] == elt) { return i } }
      return -1
    }

    // Number of pixels added to scroller and sizer to hide scrollbar
    var scrollerGap = 50;

    // Returned or thrown by various protocols to signal 'I'm not
    // handling this'.
    var Pass = {toString: function(){return "CodeMirror.Pass"}};

    // Reused option objects for setSelection & friends
    var sel_dontScroll = {scroll: false}, sel_mouse = {origin: "*mouse"}, sel_move = {origin: "+move"};

    // The inverse of countColumn -- find the offset that corresponds to
    // a particular column.
    function findColumn(string, goal, tabSize) {
      for (var pos = 0, col = 0;;) {
        var nextTab = string.indexOf("\t", pos);
        if (nextTab == -1) { nextTab = string.length; }
        var skipped = nextTab - pos;
        if (nextTab == string.length || col + skipped >= goal)
          { return pos + Math.min(skipped, goal - col) }
        col += nextTab - pos;
        col += tabSize - (col % tabSize);
        pos = nextTab + 1;
        if (col >= goal) { return pos }
      }
    }

    var spaceStrs = [""];
    function spaceStr(n) {
      while (spaceStrs.length <= n)
        { spaceStrs.push(lst(spaceStrs) + " "); }
      return spaceStrs[n]
    }

    function lst(arr) { return arr[arr.length-1] }

    function map(array, f) {
      var out = [];
      for (var i = 0; i < array.length; i++) { out[i] = f(array[i], i); }
      return out
    }

    function insertSorted(array, value, score) {
      var pos = 0, priority = score(value);
      while (pos < array.length && score(array[pos]) <= priority) { pos++; }
      array.splice(pos, 0, value);
    }

    function nothing() {}

    function createObj(base, props) {
      var inst;
      if (Object.create) {
        inst = Object.create(base);
      } else {
        nothing.prototype = base;
        inst = new nothing();
      }
      if (props) { copyObj(props, inst); }
      return inst
    }

    var nonASCIISingleCaseWordChar = /[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;
    function isWordCharBasic(ch) {
      return /\w/.test(ch) || ch > "\x80" &&
        (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch))
    }
    function isWordChar(ch, helper) {
      if (!helper) { return isWordCharBasic(ch) }
      if (helper.source.indexOf("\\w") > -1 && isWordCharBasic(ch)) { return true }
      return helper.test(ch)
    }

    function isEmpty(obj) {
      for (var n in obj) { if (obj.hasOwnProperty(n) && obj[n]) { return false } }
      return true
    }

    // Extending unicode characters. A series of a non-extending char +
    // any number of extending chars is treated as a single unit as far
    // as editing and measuring is concerned. This is not fully correct,
    // since some scripts/fonts/browsers also treat other configurations
    // of code points as a group.
    var extendingChars = /[\u0300-\u036f\u0483-\u0489\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u065e\u0670\u06d6-\u06dc\u06de-\u06e4\u06e7\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0900-\u0902\u093c\u0941-\u0948\u094d\u0951-\u0955\u0962\u0963\u0981\u09bc\u09be\u09c1-\u09c4\u09cd\u09d7\u09e2\u09e3\u0a01\u0a02\u0a3c\u0a41\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a70\u0a71\u0a75\u0a81\u0a82\u0abc\u0ac1-\u0ac5\u0ac7\u0ac8\u0acd\u0ae2\u0ae3\u0b01\u0b3c\u0b3e\u0b3f\u0b41-\u0b44\u0b4d\u0b56\u0b57\u0b62\u0b63\u0b82\u0bbe\u0bc0\u0bcd\u0bd7\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0cbc\u0cbf\u0cc2\u0cc6\u0ccc\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0d3e\u0d41-\u0d44\u0d4d\u0d57\u0d62\u0d63\u0dca\u0dcf\u0dd2-\u0dd4\u0dd6\u0ddf\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0eb9\u0ebb\u0ebc\u0ec8-\u0ecd\u0f18\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86\u0f87\u0f90-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039\u103a\u103d\u103e\u1058\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085\u1086\u108d\u109d\u135f\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u18a9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193b\u1a17\u1a18\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80\u1b81\u1ba2-\u1ba5\u1ba8\u1ba9\u1c2c-\u1c33\u1c36\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1dc0-\u1de6\u1dfd-\u1dff\u200c\u200d\u20d0-\u20f0\u2cef-\u2cf1\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua66f-\ua672\ua67c\ua67d\ua6f0\ua6f1\ua802\ua806\ua80b\ua825\ua826\ua8c4\ua8e0-\ua8f1\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc\uaa29-\uaa2e\uaa31\uaa32\uaa35\uaa36\uaa43\uaa4c\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uabe5\uabe8\uabed\udc00-\udfff\ufb1e\ufe00-\ufe0f\ufe20-\ufe26\uff9e\uff9f]/;
    function isExtendingChar(ch) { return ch.charCodeAt(0) >= 768 && extendingChars.test(ch) }

    // Returns a number from the range [`0`; `str.length`] unless `pos` is outside that range.
    function skipExtendingChars(str, pos, dir) {
      while ((dir < 0 ? pos > 0 : pos < str.length) && isExtendingChar(str.charAt(pos))) { pos += dir; }
      return pos
    }

    // Returns the value from the range [`from`; `to`] that satisfies
    // `pred` and is closest to `from`. Assumes that at least `to`
    // satisfies `pred`. Supports `from` being greater than `to`.
    function findFirst(pred, from, to) {
      // At any point we are certain `to` satisfies `pred`, don't know
      // whether `from` does.
      var dir = from > to ? -1 : 1;
      for (;;) {
        if (from == to) { return from }
        var midF = (from + to) / 2, mid = dir < 0 ? Math.ceil(midF) : Math.floor(midF);
        if (mid == from) { return pred(mid) ? from : to }
        if (pred(mid)) { to = mid; }
        else { from = mid + dir; }
      }
    }

    // BIDI HELPERS

    function iterateBidiSections(order, from, to, f) {
      if (!order) { return f(from, to, "ltr", 0) }
      var found = false;
      for (var i = 0; i < order.length; ++i) {
        var part = order[i];
        if (part.from < to && part.to > from || from == to && part.to == from) {
          f(Math.max(part.from, from), Math.min(part.to, to), part.level == 1 ? "rtl" : "ltr", i);
          found = true;
        }
      }
      if (!found) { f(from, to, "ltr"); }
    }

    var bidiOther = null;
    function getBidiPartAt(order, ch, sticky) {
      var found;
      bidiOther = null;
      for (var i = 0; i < order.length; ++i) {
        var cur = order[i];
        if (cur.from < ch && cur.to > ch) { return i }
        if (cur.to == ch) {
          if (cur.from != cur.to && sticky == "before") { found = i; }
          else { bidiOther = i; }
        }
        if (cur.from == ch) {
          if (cur.from != cur.to && sticky != "before") { found = i; }
          else { bidiOther = i; }
        }
      }
      return found != null ? found : bidiOther
    }

    // Bidirectional ordering algorithm
    // See http://unicode.org/reports/tr9/tr9-13.html for the algorithm
    // that this (partially) implements.

    // One-char codes used for character types:
    // L (L):   Left-to-Right
    // R (R):   Right-to-Left
    // r (AL):  Right-to-Left Arabic
    // 1 (EN):  European Number
    // + (ES):  European Number Separator
    // % (ET):  European Number Terminator
    // n (AN):  Arabic Number
    // , (CS):  Common Number Separator
    // m (NSM): Non-Spacing Mark
    // b (BN):  Boundary Neutral
    // s (B):   Paragraph Separator
    // t (S):   Segment Separator
    // w (WS):  Whitespace
    // N (ON):  Other Neutrals

    // Returns null if characters are ordered as they appear
    // (left-to-right), or an array of sections ({from, to, level}
    // objects) in the order in which they occur visually.
    var bidiOrdering = (function() {
      // Character types for codepoints 0 to 0xff
      var lowTypes = "bbbbbbbbbtstwsbbbbbbbbbbbbbbssstwNN%%%NNNNNN,N,N1111111111NNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNbbbbbbsbbbbbbbbbbbbbbbbbbbbbbbbbb,N%%%%NNNNLNNNNN%%11NLNNN1LNNNNNLLLLLLLLLLLLLLLLLLLLLLLNLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLN";
      // Character types for codepoints 0x600 to 0x6f9
      var arabicTypes = "nnnnnnNNr%%r,rNNmmmmmmmmmmmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmmmmmmmmmmmmmmmnnnnnnnnnn%nnrrrmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmnNmmmmmmrrmmNmmmmrr1111111111";
      function charType(code) {
        if (code <= 0xf7) { return lowTypes.charAt(code) }
        else if (0x590 <= code && code <= 0x5f4) { return "R" }
        else if (0x600 <= code && code <= 0x6f9) { return arabicTypes.charAt(code - 0x600) }
        else if (0x6ee <= code && code <= 0x8ac) { return "r" }
        else if (0x2000 <= code && code <= 0x200b) { return "w" }
        else if (code == 0x200c) { return "b" }
        else { return "L" }
      }

      var bidiRE = /[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac]/;
      var isNeutral = /[stwN]/, isStrong = /[LRr]/, countsAsLeft = /[Lb1n]/, countsAsNum = /[1n]/;

      function BidiSpan(level, from, to) {
        this.level = level;
        this.from = from; this.to = to;
      }

      return function(str, direction) {
        var outerType = direction == "ltr" ? "L" : "R";

        if (str.length == 0 || direction == "ltr" && !bidiRE.test(str)) { return false }
        var len = str.length, types = [];
        for (var i = 0; i < len; ++i)
          { types.push(charType(str.charCodeAt(i))); }

        // W1. Examine each non-spacing mark (NSM) in the level run, and
        // change the type of the NSM to the type of the previous
        // character. If the NSM is at the start of the level run, it will
        // get the type of sor.
        for (var i$1 = 0, prev = outerType; i$1 < len; ++i$1) {
          var type = types[i$1];
          if (type == "m") { types[i$1] = prev; }
          else { prev = type; }
        }

        // W2. Search backwards from each instance of a European number
        // until the first strong type (R, L, AL, or sor) is found. If an
        // AL is found, change the type of the European number to Arabic
        // number.
        // W3. Change all ALs to R.
        for (var i$2 = 0, cur = outerType; i$2 < len; ++i$2) {
          var type$1 = types[i$2];
          if (type$1 == "1" && cur == "r") { types[i$2] = "n"; }
          else if (isStrong.test(type$1)) { cur = type$1; if (type$1 == "r") { types[i$2] = "R"; } }
        }

        // W4. A single European separator between two European numbers
        // changes to a European number. A single common separator between
        // two numbers of the same type changes to that type.
        for (var i$3 = 1, prev$1 = types[0]; i$3 < len - 1; ++i$3) {
          var type$2 = types[i$3];
          if (type$2 == "+" && prev$1 == "1" && types[i$3+1] == "1") { types[i$3] = "1"; }
          else if (type$2 == "," && prev$1 == types[i$3+1] &&
                   (prev$1 == "1" || prev$1 == "n")) { types[i$3] = prev$1; }
          prev$1 = type$2;
        }

        // W5. A sequence of European terminators adjacent to European
        // numbers changes to all European numbers.
        // W6. Otherwise, separators and terminators change to Other
        // Neutral.
        for (var i$4 = 0; i$4 < len; ++i$4) {
          var type$3 = types[i$4];
          if (type$3 == ",") { types[i$4] = "N"; }
          else if (type$3 == "%") {
            var end = (void 0);
            for (end = i$4 + 1; end < len && types[end] == "%"; ++end) {}
            var replace = (i$4 && types[i$4-1] == "!") || (end < len && types[end] == "1") ? "1" : "N";
            for (var j = i$4; j < end; ++j) { types[j] = replace; }
            i$4 = end - 1;
          }
        }

        // W7. Search backwards from each instance of a European number
        // until the first strong type (R, L, or sor) is found. If an L is
        // found, then change the type of the European number to L.
        for (var i$5 = 0, cur$1 = outerType; i$5 < len; ++i$5) {
          var type$4 = types[i$5];
          if (cur$1 == "L" && type$4 == "1") { types[i$5] = "L"; }
          else if (isStrong.test(type$4)) { cur$1 = type$4; }
        }

        // N1. A sequence of neutrals takes the direction of the
        // surrounding strong text if the text on both sides has the same
        // direction. European and Arabic numbers act as if they were R in
        // terms of their influence on neutrals. Start-of-level-run (sor)
        // and end-of-level-run (eor) are used at level run boundaries.
        // N2. Any remaining neutrals take the embedding direction.
        for (var i$6 = 0; i$6 < len; ++i$6) {
          if (isNeutral.test(types[i$6])) {
            var end$1 = (void 0);
            for (end$1 = i$6 + 1; end$1 < len && isNeutral.test(types[end$1]); ++end$1) {}
            var before = (i$6 ? types[i$6-1] : outerType) == "L";
            var after = (end$1 < len ? types[end$1] : outerType) == "L";
            var replace$1 = before == after ? (before ? "L" : "R") : outerType;
            for (var j$1 = i$6; j$1 < end$1; ++j$1) { types[j$1] = replace$1; }
            i$6 = end$1 - 1;
          }
        }

        // Here we depart from the documented algorithm, in order to avoid
        // building up an actual levels array. Since there are only three
        // levels (0, 1, 2) in an implementation that doesn't take
        // explicit embedding into account, we can build up the order on
        // the fly, without following the level-based algorithm.
        var order = [], m;
        for (var i$7 = 0; i$7 < len;) {
          if (countsAsLeft.test(types[i$7])) {
            var start = i$7;
            for (++i$7; i$7 < len && countsAsLeft.test(types[i$7]); ++i$7) {}
            order.push(new BidiSpan(0, start, i$7));
          } else {
            var pos = i$7, at = order.length, isRTL = direction == "rtl" ? 1 : 0;
            for (++i$7; i$7 < len && types[i$7] != "L"; ++i$7) {}
            for (var j$2 = pos; j$2 < i$7;) {
              if (countsAsNum.test(types[j$2])) {
                if (pos < j$2) { order.splice(at, 0, new BidiSpan(1, pos, j$2)); at += isRTL; }
                var nstart = j$2;
                for (++j$2; j$2 < i$7 && countsAsNum.test(types[j$2]); ++j$2) {}
                order.splice(at, 0, new BidiSpan(2, nstart, j$2));
                at += isRTL;
                pos = j$2;
              } else { ++j$2; }
            }
            if (pos < i$7) { order.splice(at, 0, new BidiSpan(1, pos, i$7)); }
          }
        }
        if (direction == "ltr") {
          if (order[0].level == 1 && (m = str.match(/^\s+/))) {
            order[0].from = m[0].length;
            order.unshift(new BidiSpan(0, 0, m[0].length));
          }
          if (lst(order).level == 1 && (m = str.match(/\s+$/))) {
            lst(order).to -= m[0].length;
            order.push(new BidiSpan(0, len - m[0].length, len));
          }
        }

        return direction == "rtl" ? order.reverse() : order
      }
    })();

    // Get the bidi ordering for the given line (and cache it). Returns
    // false for lines that are fully left-to-right, and an array of
    // BidiSpan objects otherwise.
    function getOrder(line, direction) {
      var order = line.order;
      if (order == null) { order = line.order = bidiOrdering(line.text, direction); }
      return order
    }

    // EVENT HANDLING

    // Lightweight event framework. on/off also work on DOM nodes,
    // registering native DOM handlers.

    var noHandlers = [];

    var on = function(emitter, type, f) {
      if (emitter.addEventListener) {
        emitter.addEventListener(type, f, false);
      } else if (emitter.attachEvent) {
        emitter.attachEvent("on" + type, f);
      } else {
        var map = emitter._handlers || (emitter._handlers = {});
        map[type] = (map[type] || noHandlers).concat(f);
      }
    };

    function getHandlers(emitter, type) {
      return emitter._handlers && emitter._handlers[type] || noHandlers
    }

    function off(emitter, type, f) {
      if (emitter.removeEventListener) {
        emitter.removeEventListener(type, f, false);
      } else if (emitter.detachEvent) {
        emitter.detachEvent("on" + type, f);
      } else {
        var map = emitter._handlers, arr = map && map[type];
        if (arr) {
          var index = indexOf(arr, f);
          if (index > -1)
            { map[type] = arr.slice(0, index).concat(arr.slice(index + 1)); }
        }
      }
    }

    function signal(emitter, type /*, values...*/) {
      var handlers = getHandlers(emitter, type);
      if (!handlers.length) { return }
      var args = Array.prototype.slice.call(arguments, 2);
      for (var i = 0; i < handlers.length; ++i) { handlers[i].apply(null, args); }
    }

    // The DOM events that CodeMirror handles can be overridden by
    // registering a (non-DOM) handler on the editor for the event name,
    // and preventDefault-ing the event in that handler.
    function signalDOMEvent(cm, e, override) {
      if (typeof e == "string")
        { e = {type: e, preventDefault: function() { this.defaultPrevented = true; }}; }
      signal(cm, override || e.type, cm, e);
      return e_defaultPrevented(e) || e.codemirrorIgnore
    }

    function signalCursorActivity(cm) {
      var arr = cm._handlers && cm._handlers.cursorActivity;
      if (!arr) { return }
      var set = cm.curOp.cursorActivityHandlers || (cm.curOp.cursorActivityHandlers = []);
      for (var i = 0; i < arr.length; ++i) { if (indexOf(set, arr[i]) == -1)
        { set.push(arr[i]); } }
    }

    function hasHandler(emitter, type) {
      return getHandlers(emitter, type).length > 0
    }

    // Add on and off methods to a constructor's prototype, to make
    // registering events on such objects more convenient.
    function eventMixin(ctor) {
      ctor.prototype.on = function(type, f) {on(this, type, f);};
      ctor.prototype.off = function(type, f) {off(this, type, f);};
    }

    // Due to the fact that we still support jurassic IE versions, some
    // compatibility wrappers are needed.

    function e_preventDefault(e) {
      if (e.preventDefault) { e.preventDefault(); }
      else { e.returnValue = false; }
    }
    function e_stopPropagation(e) {
      if (e.stopPropagation) { e.stopPropagation(); }
      else { e.cancelBubble = true; }
    }
    function e_defaultPrevented(e) {
      return e.defaultPrevented != null ? e.defaultPrevented : e.returnValue == false
    }
    function e_stop(e) {e_preventDefault(e); e_stopPropagation(e);}

    function e_target(e) {return e.target || e.srcElement}
    function e_button(e) {
      var b = e.which;
      if (b == null) {
        if (e.button & 1) { b = 1; }
        else if (e.button & 2) { b = 3; }
        else if (e.button & 4) { b = 2; }
      }
      if (mac && e.ctrlKey && b == 1) { b = 3; }
      return b
    }

    // Detect drag-and-drop
    var dragAndDrop = function() {
      // There is *some* kind of drag-and-drop support in IE6-8, but I
      // couldn't get it to work yet.
      if (ie && ie_version < 9) { return false }
      var div = elt('div');
      return "draggable" in div || "dragDrop" in div
    }();

    var zwspSupported;
    function zeroWidthElement(measure) {
      if (zwspSupported == null) {
        var test = elt("span", "\u200b");
        removeChildrenAndAdd(measure, elt("span", [test, document.createTextNode("x")]));
        if (measure.firstChild.offsetHeight != 0)
          { zwspSupported = test.offsetWidth <= 1 && test.offsetHeight > 2 && !(ie && ie_version < 8); }
      }
      var node = zwspSupported ? elt("span", "\u200b") :
        elt("span", "\u00a0", null, "display: inline-block; width: 1px; margin-right: -1px");
      node.setAttribute("cm-text", "");
      return node
    }

    // Feature-detect IE's crummy client rect reporting for bidi text
    var badBidiRects;
    function hasBadBidiRects(measure) {
      if (badBidiRects != null) { return badBidiRects }
      var txt = removeChildrenAndAdd(measure, document.createTextNode("A\u062eA"));
      var r0 = range(txt, 0, 1).getBoundingClientRect();
      var r1 = range(txt, 1, 2).getBoundingClientRect();
      removeChildren(measure);
      if (!r0 || r0.left == r0.right) { return false } // Safari returns null in some cases (#2780)
      return badBidiRects = (r1.right - r0.right < 3)
    }

    // See if "".split is the broken IE version, if so, provide an
    // alternative way to split lines.
    var splitLinesAuto = "\n\nb".split(/\n/).length != 3 ? function (string) {
      var pos = 0, result = [], l = string.length;
      while (pos <= l) {
        var nl = string.indexOf("\n", pos);
        if (nl == -1) { nl = string.length; }
        var line = string.slice(pos, string.charAt(nl - 1) == "\r" ? nl - 1 : nl);
        var rt = line.indexOf("\r");
        if (rt != -1) {
          result.push(line.slice(0, rt));
          pos += rt + 1;
        } else {
          result.push(line);
          pos = nl + 1;
        }
      }
      return result
    } : function (string) { return string.split(/\r\n?|\n/); };

    var hasSelection = window.getSelection ? function (te) {
      try { return te.selectionStart != te.selectionEnd }
      catch(e) { return false }
    } : function (te) {
      var range;
      try {range = te.ownerDocument.selection.createRange();}
      catch(e) {}
      if (!range || range.parentElement() != te) { return false }
      return range.compareEndPoints("StartToEnd", range) != 0
    };

    var hasCopyEvent = (function () {
      var e = elt("div");
      if ("oncopy" in e) { return true }
      e.setAttribute("oncopy", "return;");
      return typeof e.oncopy == "function"
    })();

    var badZoomedRects = null;
    function hasBadZoomedRects(measure) {
      if (badZoomedRects != null) { return badZoomedRects }
      var node = removeChildrenAndAdd(measure, elt("span", "x"));
      var normal = node.getBoundingClientRect();
      var fromRange = range(node, 0, 1).getBoundingClientRect();
      return badZoomedRects = Math.abs(normal.left - fromRange.left) > 1
    }

    // Known modes, by name and by MIME
    var modes = {}, mimeModes = {};

    // Extra arguments are stored as the mode's dependencies, which is
    // used by (legacy) mechanisms like loadmode.js to automatically
    // load a mode. (Preferred mechanism is the require/define calls.)
    function defineMode(name, mode) {
      if (arguments.length > 2)
        { mode.dependencies = Array.prototype.slice.call(arguments, 2); }
      modes[name] = mode;
    }

    function defineMIME(mime, spec) {
      mimeModes[mime] = spec;
    }

    // Given a MIME type, a {name, ...options} config object, or a name
    // string, return a mode config object.
    function resolveMode(spec) {
      if (typeof spec == "string" && mimeModes.hasOwnProperty(spec)) {
        spec = mimeModes[spec];
      } else if (spec && typeof spec.name == "string" && mimeModes.hasOwnProperty(spec.name)) {
        var found = mimeModes[spec.name];
        if (typeof found == "string") { found = {name: found}; }
        spec = createObj(found, spec);
        spec.name = found.name;
      } else if (typeof spec == "string" && /^[\w\-]+\/[\w\-]+\+xml$/.test(spec)) {
        return resolveMode("application/xml")
      } else if (typeof spec == "string" && /^[\w\-]+\/[\w\-]+\+json$/.test(spec)) {
        return resolveMode("application/json")
      }
      if (typeof spec == "string") { return {name: spec} }
      else { return spec || {name: "null"} }
    }

    // Given a mode spec (anything that resolveMode accepts), find and
    // initialize an actual mode object.
    function getMode(options, spec) {
      spec = resolveMode(spec);
      var mfactory = modes[spec.name];
      if (!mfactory) { return getMode(options, "text/plain") }
      var modeObj = mfactory(options, spec);
      if (modeExtensions.hasOwnProperty(spec.name)) {
        var exts = modeExtensions[spec.name];
        for (var prop in exts) {
          if (!exts.hasOwnProperty(prop)) { continue }
          if (modeObj.hasOwnProperty(prop)) { modeObj["_" + prop] = modeObj[prop]; }
          modeObj[prop] = exts[prop];
        }
      }
      modeObj.name = spec.name;
      if (spec.helperType) { modeObj.helperType = spec.helperType; }
      if (spec.modeProps) { for (var prop$1 in spec.modeProps)
        { modeObj[prop$1] = spec.modeProps[prop$1]; } }

      return modeObj
    }

    // This can be used to attach properties to mode objects from
    // outside the actual mode definition.
    var modeExtensions = {};
    function extendMode(mode, properties) {
      var exts = modeExtensions.hasOwnProperty(mode) ? modeExtensions[mode] : (modeExtensions[mode] = {});
      copyObj(properties, exts);
    }

    function copyState(mode, state) {
      if (state === true) { return state }
      if (mode.copyState) { return mode.copyState(state) }
      var nstate = {};
      for (var n in state) {
        var val = state[n];
        if (val instanceof Array) { val = val.concat([]); }
        nstate[n] = val;
      }
      return nstate
    }

    // Given a mode and a state (for that mode), find the inner mode and
    // state at the position that the state refers to.
    function innerMode(mode, state) {
      var info;
      while (mode.innerMode) {
        info = mode.innerMode(state);
        if (!info || info.mode == mode) { break }
        state = info.state;
        mode = info.mode;
      }
      return info || {mode: mode, state: state}
    }

    function startState(mode, a1, a2) {
      return mode.startState ? mode.startState(a1, a2) : true
    }

    // STRING STREAM

    // Fed to the mode parsers, provides helper functions to make
    // parsers more succinct.

    var StringStream = function(string, tabSize, lineOracle) {
      this.pos = this.start = 0;
      this.string = string;
      this.tabSize = tabSize || 8;
      this.lastColumnPos = this.lastColumnValue = 0;
      this.lineStart = 0;
      this.lineOracle = lineOracle;
    };

    StringStream.prototype.eol = function () {return this.pos >= this.string.length};
    StringStream.prototype.sol = function () {return this.pos == this.lineStart};
    StringStream.prototype.peek = function () {return this.string.charAt(this.pos) || undefined};
    StringStream.prototype.next = function () {
      if (this.pos < this.string.length)
        { return this.string.charAt(this.pos++) }
    };
    StringStream.prototype.eat = function (match) {
      var ch = this.string.charAt(this.pos);
      var ok;
      if (typeof match == "string") { ok = ch == match; }
      else { ok = ch && (match.test ? match.test(ch) : match(ch)); }
      if (ok) {++this.pos; return ch}
    };
    StringStream.prototype.eatWhile = function (match) {
      var start = this.pos;
      while (this.eat(match)){}
      return this.pos > start
    };
    StringStream.prototype.eatSpace = function () {
      var start = this.pos;
      while (/[\s\u00a0]/.test(this.string.charAt(this.pos))) { ++this.pos; }
      return this.pos > start
    };
    StringStream.prototype.skipToEnd = function () {this.pos = this.string.length;};
    StringStream.prototype.skipTo = function (ch) {
      var found = this.string.indexOf(ch, this.pos);
      if (found > -1) {this.pos = found; return true}
    };
    StringStream.prototype.backUp = function (n) {this.pos -= n;};
    StringStream.prototype.column = function () {
      if (this.lastColumnPos < this.start) {
        this.lastColumnValue = countColumn(this.string, this.start, this.tabSize, this.lastColumnPos, this.lastColumnValue);
        this.lastColumnPos = this.start;
      }
      return this.lastColumnValue - (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0)
    };
    StringStream.prototype.indentation = function () {
      return countColumn(this.string, null, this.tabSize) -
        (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0)
    };
    StringStream.prototype.match = function (pattern, consume, caseInsensitive) {
      if (typeof pattern == "string") {
        var cased = function (str) { return caseInsensitive ? str.toLowerCase() : str; };
        var substr = this.string.substr(this.pos, pattern.length);
        if (cased(substr) == cased(pattern)) {
          if (consume !== false) { this.pos += pattern.length; }
          return true
        }
      } else {
        var match = this.string.slice(this.pos).match(pattern);
        if (match && match.index > 0) { return null }
        if (match && consume !== false) { this.pos += match[0].length; }
        return match
      }
    };
    StringStream.prototype.current = function (){return this.string.slice(this.start, this.pos)};
    StringStream.prototype.hideFirstChars = function (n, inner) {
      this.lineStart += n;
      try { return inner() }
      finally { this.lineStart -= n; }
    };
    StringStream.prototype.lookAhead = function (n) {
      var oracle = this.lineOracle;
      return oracle && oracle.lookAhead(n)
    };
    StringStream.prototype.baseToken = function () {
      var oracle = this.lineOracle;
      return oracle && oracle.baseToken(this.pos)
    };

    // Find the line object corresponding to the given line number.
    function getLine(doc, n) {
      n -= doc.first;
      if (n < 0 || n >= doc.size) { throw new Error("There is no line " + (n + doc.first) + " in the document.") }
      var chunk = doc;
      while (!chunk.lines) {
        for (var i = 0;; ++i) {
          var child = chunk.children[i], sz = child.chunkSize();
          if (n < sz) { chunk = child; break }
          n -= sz;
        }
      }
      return chunk.lines[n]
    }

    // Get the part of a document between two positions, as an array of
    // strings.
    function getBetween(doc, start, end) {
      var out = [], n = start.line;
      doc.iter(start.line, end.line + 1, function (line) {
        var text = line.text;
        if (n == end.line) { text = text.slice(0, end.ch); }
        if (n == start.line) { text = text.slice(start.ch); }
        out.push(text);
        ++n;
      });
      return out
    }
    // Get the lines between from and to, as array of strings.
    function getLines(doc, from, to) {
      var out = [];
      doc.iter(from, to, function (line) { out.push(line.text); }); // iter aborts when callback returns truthy value
      return out
    }

    // Update the height of a line, propagating the height change
    // upwards to parent nodes.
    function updateLineHeight(line, height) {
      var diff = height - line.height;
      if (diff) { for (var n = line; n; n = n.parent) { n.height += diff; } }
    }

    // Given a line object, find its line number by walking up through
    // its parent links.
    function lineNo(line) {
      if (line.parent == null) { return null }
      var cur = line.parent, no = indexOf(cur.lines, line);
      for (var chunk = cur.parent; chunk; cur = chunk, chunk = chunk.parent) {
        for (var i = 0;; ++i) {
          if (chunk.children[i] == cur) { break }
          no += chunk.children[i].chunkSize();
        }
      }
      return no + cur.first
    }

    // Find the line at the given vertical position, using the height
    // information in the document tree.
    function lineAtHeight(chunk, h) {
      var n = chunk.first;
      outer: do {
        for (var i$1 = 0; i$1 < chunk.children.length; ++i$1) {
          var child = chunk.children[i$1], ch = child.height;
          if (h < ch) { chunk = child; continue outer }
          h -= ch;
          n += child.chunkSize();
        }
        return n
      } while (!chunk.lines)
      var i = 0;
      for (; i < chunk.lines.length; ++i) {
        var line = chunk.lines[i], lh = line.height;
        if (h < lh) { break }
        h -= lh;
      }
      return n + i
    }

    function isLine(doc, l) {return l >= doc.first && l < doc.first + doc.size}

    function lineNumberFor(options, i) {
      return String(options.lineNumberFormatter(i + options.firstLineNumber))
    }

    // A Pos instance represents a position within the text.
    function Pos(line, ch, sticky) {
      if ( sticky === void 0 ) { sticky = null; }

      if (!(this instanceof Pos)) { return new Pos(line, ch, sticky) }
      this.line = line;
      this.ch = ch;
      this.sticky = sticky;
    }

    // Compare two positions, return 0 if they are the same, a negative
    // number when a is less, and a positive number otherwise.
    function cmp(a, b) { return a.line - b.line || a.ch - b.ch }

    function equalCursorPos(a, b) { return a.sticky == b.sticky && cmp(a, b) == 0 }

    function copyPos(x) {return Pos(x.line, x.ch)}
    function maxPos(a, b) { return cmp(a, b) < 0 ? b : a }
    function minPos(a, b) { return cmp(a, b) < 0 ? a : b }

    // Most of the external API clips given positions to make sure they
    // actually exist within the document.
    function clipLine(doc, n) {return Math.max(doc.first, Math.min(n, doc.first + doc.size - 1))}
    function clipPos(doc, pos) {
      if (pos.line < doc.first) { return Pos(doc.first, 0) }
      var last = doc.first + doc.size - 1;
      if (pos.line > last) { return Pos(last, getLine(doc, last).text.length) }
      return clipToLen(pos, getLine(doc, pos.line).text.length)
    }
    function clipToLen(pos, linelen) {
      var ch = pos.ch;
      if (ch == null || ch > linelen) { return Pos(pos.line, linelen) }
      else if (ch < 0) { return Pos(pos.line, 0) }
      else { return pos }
    }
    function clipPosArray(doc, array) {
      var out = [];
      for (var i = 0; i < array.length; i++) { out[i] = clipPos(doc, array[i]); }
      return out
    }

    var SavedContext = function(state, lookAhead) {
      this.state = state;
      this.lookAhead = lookAhead;
    };

    var Context = function(doc, state, line, lookAhead) {
      this.state = state;
      this.doc = doc;
      this.line = line;
      this.maxLookAhead = lookAhead || 0;
      this.baseTokens = null;
      this.baseTokenPos = 1;
    };

    Context.prototype.lookAhead = function (n) {
      var line = this.doc.getLine(this.line + n);
      if (line != null && n > this.maxLookAhead) { this.maxLookAhead = n; }
      return line
    };

    Context.prototype.baseToken = function (n) {
      if (!this.baseTokens) { return null }
      while (this.baseTokens[this.baseTokenPos] <= n)
        { this.baseTokenPos += 2; }
      var type = this.baseTokens[this.baseTokenPos + 1];
      return {type: type && type.replace(/( |^)overlay .*/, ""),
              size: this.baseTokens[this.baseTokenPos] - n}
    };

    Context.prototype.nextLine = function () {
      this.line++;
      if (this.maxLookAhead > 0) { this.maxLookAhead--; }
    };

    Context.fromSaved = function (doc, saved, line) {
      if (saved instanceof SavedContext)
        { return new Context(doc, copyState(doc.mode, saved.state), line, saved.lookAhead) }
      else
        { return new Context(doc, copyState(doc.mode, saved), line) }
    };

    Context.prototype.save = function (copy) {
      var state = copy !== false ? copyState(this.doc.mode, this.state) : this.state;
      return this.maxLookAhead > 0 ? new SavedContext(state, this.maxLookAhead) : state
    };


    // Compute a style array (an array starting with a mode generation
    // -- for invalidation -- followed by pairs of end positions and
    // style strings), which is used to highlight the tokens on the
    // line.
    function highlightLine(cm, line, context, forceToEnd) {
      // A styles array always starts with a number identifying the
      // mode/overlays that it is based on (for easy invalidation).
      var st = [cm.state.modeGen], lineClasses = {};
      // Compute the base array of styles
      runMode(cm, line.text, cm.doc.mode, context, function (end, style) { return st.push(end, style); },
              lineClasses, forceToEnd);
      var state = context.state;

      // Run overlays, adjust style array.
      var loop = function ( o ) {
        context.baseTokens = st;
        var overlay = cm.state.overlays[o], i = 1, at = 0;
        context.state = true;
        runMode(cm, line.text, overlay.mode, context, function (end, style) {
          var start = i;
          // Ensure there's a token end at the current position, and that i points at it
          while (at < end) {
            var i_end = st[i];
            if (i_end > end)
              { st.splice(i, 1, end, st[i+1], i_end); }
            i += 2;
            at = Math.min(end, i_end);
          }
          if (!style) { return }
          if (overlay.opaque) {
            st.splice(start, i - start, end, "overlay " + style);
            i = start + 2;
          } else {
            for (; start < i; start += 2) {
              var cur = st[start+1];
              st[start+1] = (cur ? cur + " " : "") + "overlay " + style;
            }
          }
        }, lineClasses);
        context.state = state;
        context.baseTokens = null;
        context.baseTokenPos = 1;
      };

      for (var o = 0; o < cm.state.overlays.length; ++o) { loop( o ); }

      return {styles: st, classes: lineClasses.bgClass || lineClasses.textClass ? lineClasses : null}
    }

    function getLineStyles(cm, line, updateFrontier) {
      if (!line.styles || line.styles[0] != cm.state.modeGen) {
        var context = getContextBefore(cm, lineNo(line));
        var resetState = line.text.length > cm.options.maxHighlightLength && copyState(cm.doc.mode, context.state);
        var result = highlightLine(cm, line, context);
        if (resetState) { context.state = resetState; }
        line.stateAfter = context.save(!resetState);
        line.styles = result.styles;
        if (result.classes) { line.styleClasses = result.classes; }
        else if (line.styleClasses) { line.styleClasses = null; }
        if (updateFrontier === cm.doc.highlightFrontier)
          { cm.doc.modeFrontier = Math.max(cm.doc.modeFrontier, ++cm.doc.highlightFrontier); }
      }
      return line.styles
    }

    function getContextBefore(cm, n, precise) {
      var doc = cm.doc, display = cm.display;
      if (!doc.mode.startState) { return new Context(doc, true, n) }
      var start = findStartLine(cm, n, precise);
      var saved = start > doc.first && getLine(doc, start - 1).stateAfter;
      var context = saved ? Context.fromSaved(doc, saved, start) : new Context(doc, startState(doc.mode), start);

      doc.iter(start, n, function (line) {
        processLine(cm, line.text, context);
        var pos = context.line;
        line.stateAfter = pos == n - 1 || pos % 5 == 0 || pos >= display.viewFrom && pos < display.viewTo ? context.save() : null;
        context.nextLine();
      });
      if (precise) { doc.modeFrontier = context.line; }
      return context
    }

    // Lightweight form of highlight -- proceed over this line and
    // update state, but don't save a style array. Used for lines that
    // aren't currently visible.
    function processLine(cm, text, context, startAt) {
      var mode = cm.doc.mode;
      var stream = new StringStream(text, cm.options.tabSize, context);
      stream.start = stream.pos = startAt || 0;
      if (text == "") { callBlankLine(mode, context.state); }
      while (!stream.eol()) {
        readToken(mode, stream, context.state);
        stream.start = stream.pos;
      }
    }

    function callBlankLine(mode, state) {
      if (mode.blankLine) { return mode.blankLine(state) }
      if (!mode.innerMode) { return }
      var inner = innerMode(mode, state);
      if (inner.mode.blankLine) { return inner.mode.blankLine(inner.state) }
    }

    function readToken(mode, stream, state, inner) {
      for (var i = 0; i < 10; i++) {
        if (inner) { inner[0] = innerMode(mode, state).mode; }
        var style = mode.token(stream, state);
        if (stream.pos > stream.start) { return style }
      }
      throw new Error("Mode " + mode.name + " failed to advance stream.")
    }

    var Token = function(stream, type, state) {
      this.start = stream.start; this.end = stream.pos;
      this.string = stream.current();
      this.type = type || null;
      this.state = state;
    };

    // Utility for getTokenAt and getLineTokens
    function takeToken(cm, pos, precise, asArray) {
      var doc = cm.doc, mode = doc.mode, style;
      pos = clipPos(doc, pos);
      var line = getLine(doc, pos.line), context = getContextBefore(cm, pos.line, precise);
      var stream = new StringStream(line.text, cm.options.tabSize, context), tokens;
      if (asArray) { tokens = []; }
      while ((asArray || stream.pos < pos.ch) && !stream.eol()) {
        stream.start = stream.pos;
        style = readToken(mode, stream, context.state);
        if (asArray) { tokens.push(new Token(stream, style, copyState(doc.mode, context.state))); }
      }
      return asArray ? tokens : new Token(stream, style, context.state)
    }

    function extractLineClasses(type, output) {
      if (type) { for (;;) {
        var lineClass = type.match(/(?:^|\s+)line-(background-)?(\S+)/);
        if (!lineClass) { break }
        type = type.slice(0, lineClass.index) + type.slice(lineClass.index + lineClass[0].length);
        var prop = lineClass[1] ? "bgClass" : "textClass";
        if (output[prop] == null)
          { output[prop] = lineClass[2]; }
        else if (!(new RegExp("(?:^|\\s)" + lineClass[2] + "(?:$|\\s)")).test(output[prop]))
          { output[prop] += " " + lineClass[2]; }
      } }
      return type
    }

    // Run the given mode's parser over a line, calling f for each token.
    function runMode(cm, text, mode, context, f, lineClasses, forceToEnd) {
      var flattenSpans = mode.flattenSpans;
      if (flattenSpans == null) { flattenSpans = cm.options.flattenSpans; }
      var curStart = 0, curStyle = null;
      var stream = new StringStream(text, cm.options.tabSize, context), style;
      var inner = cm.options.addModeClass && [null];
      if (text == "") { extractLineClasses(callBlankLine(mode, context.state), lineClasses); }
      while (!stream.eol()) {
        if (stream.pos > cm.options.maxHighlightLength) {
          flattenSpans = false;
          if (forceToEnd) { processLine(cm, text, context, stream.pos); }
          stream.pos = text.length;
          style = null;
        } else {
          style = extractLineClasses(readToken(mode, stream, context.state, inner), lineClasses);
        }
        if (inner) {
          var mName = inner[0].name;
          if (mName) { style = "m-" + (style ? mName + " " + style : mName); }
        }
        if (!flattenSpans || curStyle != style) {
          while (curStart < stream.start) {
            curStart = Math.min(stream.start, curStart + 5000);
            f(curStart, curStyle);
          }
          curStyle = style;
        }
        stream.start = stream.pos;
      }
      while (curStart < stream.pos) {
        // Webkit seems to refuse to render text nodes longer than 57444
        // characters, and returns inaccurate measurements in nodes
        // starting around 5000 chars.
        var pos = Math.min(stream.pos, curStart + 5000);
        f(pos, curStyle);
        curStart = pos;
      }
    }

    // Finds the line to start with when starting a parse. Tries to
    // find a line with a stateAfter, so that it can start with a
    // valid state. If that fails, it returns the line with the
    // smallest indentation, which tends to need the least context to
    // parse correctly.
    function findStartLine(cm, n, precise) {
      var minindent, minline, doc = cm.doc;
      var lim = precise ? -1 : n - (cm.doc.mode.innerMode ? 1000 : 100);
      for (var search = n; search > lim; --search) {
        if (search <= doc.first) { return doc.first }
        var line = getLine(doc, search - 1), after = line.stateAfter;
        if (after && (!precise || search + (after instanceof SavedContext ? after.lookAhead : 0) <= doc.modeFrontier))
          { return search }
        var indented = countColumn(line.text, null, cm.options.tabSize);
        if (minline == null || minindent > indented) {
          minline = search - 1;
          minindent = indented;
        }
      }
      return minline
    }

    function retreatFrontier(doc, n) {
      doc.modeFrontier = Math.min(doc.modeFrontier, n);
      if (doc.highlightFrontier < n - 10) { return }
      var start = doc.first;
      for (var line = n - 1; line > start; line--) {
        var saved = getLine(doc, line).stateAfter;
        // change is on 3
        // state on line 1 looked ahead 2 -- so saw 3
        // test 1 + 2 < 3 should cover this
        if (saved && (!(saved instanceof SavedContext) || line + saved.lookAhead < n)) {
          start = line + 1;
          break
        }
      }
      doc.highlightFrontier = Math.min(doc.highlightFrontier, start);
    }

    // Optimize some code when these features are not used.
    var sawReadOnlySpans = false, sawCollapsedSpans = false;

    function seeReadOnlySpans() {
      sawReadOnlySpans = true;
    }

    function seeCollapsedSpans() {
      sawCollapsedSpans = true;
    }

    // TEXTMARKER SPANS

    function MarkedSpan(marker, from, to) {
      this.marker = marker;
      this.from = from; this.to = to;
    }

    // Search an array of spans for a span matching the given marker.
    function getMarkedSpanFor(spans, marker) {
      if (spans) { for (var i = 0; i < spans.length; ++i) {
        var span = spans[i];
        if (span.marker == marker) { return span }
      } }
    }
    // Remove a span from an array, returning undefined if no spans are
    // left (we don't store arrays for lines without spans).
    function removeMarkedSpan(spans, span) {
      var r;
      for (var i = 0; i < spans.length; ++i)
        { if (spans[i] != span) { (r || (r = [])).push(spans[i]); } }
      return r
    }
    // Add a span to a line.
    function addMarkedSpan(line, span) {
      line.markedSpans = line.markedSpans ? line.markedSpans.concat([span]) : [span];
      span.marker.attachLine(line);
    }

    // Used for the algorithm that adjusts markers for a change in the
    // document. These functions cut an array of spans at a given
    // character position, returning an array of remaining chunks (or
    // undefined if nothing remains).
    function markedSpansBefore(old, startCh, isInsert) {
      var nw;
      if (old) { for (var i = 0; i < old.length; ++i) {
        var span = old[i], marker = span.marker;
        var startsBefore = span.from == null || (marker.inclusiveLeft ? span.from <= startCh : span.from < startCh);
        if (startsBefore || span.from == startCh && marker.type == "bookmark" && (!isInsert || !span.marker.insertLeft)) {
          var endsAfter = span.to == null || (marker.inclusiveRight ? span.to >= startCh : span.to > startCh)
          ;(nw || (nw = [])).push(new MarkedSpan(marker, span.from, endsAfter ? null : span.to));
        }
      } }
      return nw
    }
    function markedSpansAfter(old, endCh, isInsert) {
      var nw;
      if (old) { for (var i = 0; i < old.length; ++i) {
        var span = old[i], marker = span.marker;
        var endsAfter = span.to == null || (marker.inclusiveRight ? span.to >= endCh : span.to > endCh);
        if (endsAfter || span.from == endCh && marker.type == "bookmark" && (!isInsert || span.marker.insertLeft)) {
          var startsBefore = span.from == null || (marker.inclusiveLeft ? span.from <= endCh : span.from < endCh)
          ;(nw || (nw = [])).push(new MarkedSpan(marker, startsBefore ? null : span.from - endCh,
                                                span.to == null ? null : span.to - endCh));
        }
      } }
      return nw
    }

    // Given a change object, compute the new set of marker spans that
    // cover the line in which the change took place. Removes spans
    // entirely within the change, reconnects spans belonging to the
    // same marker that appear on both sides of the change, and cuts off
    // spans partially within the change. Returns an array of span
    // arrays with one element for each line in (after) the change.
    function stretchSpansOverChange(doc, change) {
      if (change.full) { return null }
      var oldFirst = isLine(doc, change.from.line) && getLine(doc, change.from.line).markedSpans;
      var oldLast = isLine(doc, change.to.line) && getLine(doc, change.to.line).markedSpans;
      if (!oldFirst && !oldLast) { return null }

      var startCh = change.from.ch, endCh = change.to.ch, isInsert = cmp(change.from, change.to) == 0;
      // Get the spans that 'stick out' on both sides
      var first = markedSpansBefore(oldFirst, startCh, isInsert);
      var last = markedSpansAfter(oldLast, endCh, isInsert);

      // Next, merge those two ends
      var sameLine = change.text.length == 1, offset = lst(change.text).length + (sameLine ? startCh : 0);
      if (first) {
        // Fix up .to properties of first
        for (var i = 0; i < first.length; ++i) {
          var span = first[i];
          if (span.to == null) {
            var found = getMarkedSpanFor(last, span.marker);
            if (!found) { span.to = startCh; }
            else if (sameLine) { span.to = found.to == null ? null : found.to + offset; }
          }
        }
      }
      if (last) {
        // Fix up .from in last (or move them into first in case of sameLine)
        for (var i$1 = 0; i$1 < last.length; ++i$1) {
          var span$1 = last[i$1];
          if (span$1.to != null) { span$1.to += offset; }
          if (span$1.from == null) {
            var found$1 = getMarkedSpanFor(first, span$1.marker);
            if (!found$1) {
              span$1.from = offset;
              if (sameLine) { (first || (first = [])).push(span$1); }
            }
          } else {
            span$1.from += offset;
            if (sameLine) { (first || (first = [])).push(span$1); }
          }
        }
      }
      // Make sure we didn't create any zero-length spans
      if (first) { first = clearEmptySpans(first); }
      if (last && last != first) { last = clearEmptySpans(last); }

      var newMarkers = [first];
      if (!sameLine) {
        // Fill gap with whole-line-spans
        var gap = change.text.length - 2, gapMarkers;
        if (gap > 0 && first)
          { for (var i$2 = 0; i$2 < first.length; ++i$2)
            { if (first[i$2].to == null)
              { (gapMarkers || (gapMarkers = [])).push(new MarkedSpan(first[i$2].marker, null, null)); } } }
        for (var i$3 = 0; i$3 < gap; ++i$3)
          { newMarkers.push(gapMarkers); }
        newMarkers.push(last);
      }
      return newMarkers
    }

    // Remove spans that are empty and don't have a clearWhenEmpty
    // option of false.
    function clearEmptySpans(spans) {
      for (var i = 0; i < spans.length; ++i) {
        var span = spans[i];
        if (span.from != null && span.from == span.to && span.marker.clearWhenEmpty !== false)
          { spans.splice(i--, 1); }
      }
      if (!spans.length) { return null }
      return spans
    }

    // Used to 'clip' out readOnly ranges when making a change.
    function removeReadOnlyRanges(doc, from, to) {
      var markers = null;
      doc.iter(from.line, to.line + 1, function (line) {
        if (line.markedSpans) { for (var i = 0; i < line.markedSpans.length; ++i) {
          var mark = line.markedSpans[i].marker;
          if (mark.readOnly && (!markers || indexOf(markers, mark) == -1))
            { (markers || (markers = [])).push(mark); }
        } }
      });
      if (!markers) { return null }
      var parts = [{from: from, to: to}];
      for (var i = 0; i < markers.length; ++i) {
        var mk = markers[i], m = mk.find(0);
        for (var j = 0; j < parts.length; ++j) {
          var p = parts[j];
          if (cmp(p.to, m.from) < 0 || cmp(p.from, m.to) > 0) { continue }
          var newParts = [j, 1], dfrom = cmp(p.from, m.from), dto = cmp(p.to, m.to);
          if (dfrom < 0 || !mk.inclusiveLeft && !dfrom)
            { newParts.push({from: p.from, to: m.from}); }
          if (dto > 0 || !mk.inclusiveRight && !dto)
            { newParts.push({from: m.to, to: p.to}); }
          parts.splice.apply(parts, newParts);
          j += newParts.length - 3;
        }
      }
      return parts
    }

    // Connect or disconnect spans from a line.
    function detachMarkedSpans(line) {
      var spans = line.markedSpans;
      if (!spans) { return }
      for (var i = 0; i < spans.length; ++i)
        { spans[i].marker.detachLine(line); }
      line.markedSpans = null;
    }
    function attachMarkedSpans(line, spans) {
      if (!spans) { return }
      for (var i = 0; i < spans.length; ++i)
        { spans[i].marker.attachLine(line); }
      line.markedSpans = spans;
    }

    // Helpers used when computing which overlapping collapsed span
    // counts as the larger one.
    function extraLeft(marker) { return marker.inclusiveLeft ? -1 : 0 }
    function extraRight(marker) { return marker.inclusiveRight ? 1 : 0 }

    // Returns a number indicating which of two overlapping collapsed
    // spans is larger (and thus includes the other). Falls back to
    // comparing ids when the spans cover exactly the same range.
    function compareCollapsedMarkers(a, b) {
      var lenDiff = a.lines.length - b.lines.length;
      if (lenDiff != 0) { return lenDiff }
      var aPos = a.find(), bPos = b.find();
      var fromCmp = cmp(aPos.from, bPos.from) || extraLeft(a) - extraLeft(b);
      if (fromCmp) { return -fromCmp }
      var toCmp = cmp(aPos.to, bPos.to) || extraRight(a) - extraRight(b);
      if (toCmp) { return toCmp }
      return b.id - a.id
    }

    // Find out whether a line ends or starts in a collapsed span. If
    // so, return the marker for that span.
    function collapsedSpanAtSide(line, start) {
      var sps = sawCollapsedSpans && line.markedSpans, found;
      if (sps) { for (var sp = (void 0), i = 0; i < sps.length; ++i) {
        sp = sps[i];
        if (sp.marker.collapsed && (start ? sp.from : sp.to) == null &&
            (!found || compareCollapsedMarkers(found, sp.marker) < 0))
          { found = sp.marker; }
      } }
      return found
    }
    function collapsedSpanAtStart(line) { return collapsedSpanAtSide(line, true) }
    function collapsedSpanAtEnd(line) { return collapsedSpanAtSide(line, false) }

    function collapsedSpanAround(line, ch) {
      var sps = sawCollapsedSpans && line.markedSpans, found;
      if (sps) { for (var i = 0; i < sps.length; ++i) {
        var sp = sps[i];
        if (sp.marker.collapsed && (sp.from == null || sp.from < ch) && (sp.to == null || sp.to > ch) &&
            (!found || compareCollapsedMarkers(found, sp.marker) < 0)) { found = sp.marker; }
      } }
      return found
    }

    // Test whether there exists a collapsed span that partially
    // overlaps (covers the start or end, but not both) of a new span.
    // Such overlap is not allowed.
    function conflictingCollapsedRange(doc, lineNo, from, to, marker) {
      var line = getLine(doc, lineNo);
      var sps = sawCollapsedSpans && line.markedSpans;
      if (sps) { for (var i = 0; i < sps.length; ++i) {
        var sp = sps[i];
        if (!sp.marker.collapsed) { continue }
        var found = sp.marker.find(0);
        var fromCmp = cmp(found.from, from) || extraLeft(sp.marker) - extraLeft(marker);
        var toCmp = cmp(found.to, to) || extraRight(sp.marker) - extraRight(marker);
        if (fromCmp >= 0 && toCmp <= 0 || fromCmp <= 0 && toCmp >= 0) { continue }
        if (fromCmp <= 0 && (sp.marker.inclusiveRight && marker.inclusiveLeft ? cmp(found.to, from) >= 0 : cmp(found.to, from) > 0) ||
            fromCmp >= 0 && (sp.marker.inclusiveRight && marker.inclusiveLeft ? cmp(found.from, to) <= 0 : cmp(found.from, to) < 0))
          { return true }
      } }
    }

    // A visual line is a line as drawn on the screen. Folding, for
    // example, can cause multiple logical lines to appear on the same
    // visual line. This finds the start of the visual line that the
    // given line is part of (usually that is the line itself).
    function visualLine(line) {
      var merged;
      while (merged = collapsedSpanAtStart(line))
        { line = merged.find(-1, true).line; }
      return line
    }

    function visualLineEnd(line) {
      var merged;
      while (merged = collapsedSpanAtEnd(line))
        { line = merged.find(1, true).line; }
      return line
    }

    // Returns an array of logical lines that continue the visual line
    // started by the argument, or undefined if there are no such lines.
    function visualLineContinued(line) {
      var merged, lines;
      while (merged = collapsedSpanAtEnd(line)) {
        line = merged.find(1, true).line
        ;(lines || (lines = [])).push(line);
      }
      return lines
    }

    // Get the line number of the start of the visual line that the
    // given line number is part of.
    function visualLineNo(doc, lineN) {
      var line = getLine(doc, lineN), vis = visualLine(line);
      if (line == vis) { return lineN }
      return lineNo(vis)
    }

    // Get the line number of the start of the next visual line after
    // the given line.
    function visualLineEndNo(doc, lineN) {
      if (lineN > doc.lastLine()) { return lineN }
      var line = getLine(doc, lineN), merged;
      if (!lineIsHidden(doc, line)) { return lineN }
      while (merged = collapsedSpanAtEnd(line))
        { line = merged.find(1, true).line; }
      return lineNo(line) + 1
    }

    // Compute whether a line is hidden. Lines count as hidden when they
    // are part of a visual line that starts with another line, or when
    // they are entirely covered by collapsed, non-widget span.
    function lineIsHidden(doc, line) {
      var sps = sawCollapsedSpans && line.markedSpans;
      if (sps) { for (var sp = (void 0), i = 0; i < sps.length; ++i) {
        sp = sps[i];
        if (!sp.marker.collapsed) { continue }
        if (sp.from == null) { return true }
        if (sp.marker.widgetNode) { continue }
        if (sp.from == 0 && sp.marker.inclusiveLeft && lineIsHiddenInner(doc, line, sp))
          { return true }
      } }
    }
    function lineIsHiddenInner(doc, line, span) {
      if (span.to == null) {
        var end = span.marker.find(1, true);
        return lineIsHiddenInner(doc, end.line, getMarkedSpanFor(end.line.markedSpans, span.marker))
      }
      if (span.marker.inclusiveRight && span.to == line.text.length)
        { return true }
      for (var sp = (void 0), i = 0; i < line.markedSpans.length; ++i) {
        sp = line.markedSpans[i];
        if (sp.marker.collapsed && !sp.marker.widgetNode && sp.from == span.to &&
            (sp.to == null || sp.to != span.from) &&
            (sp.marker.inclusiveLeft || span.marker.inclusiveRight) &&
            lineIsHiddenInner(doc, line, sp)) { return true }
      }
    }

    // Find the height above the given line.
    function heightAtLine(lineObj) {
      lineObj = visualLine(lineObj);

      var h = 0, chunk = lineObj.parent;
      for (var i = 0; i < chunk.lines.length; ++i) {
        var line = chunk.lines[i];
        if (line == lineObj) { break }
        else { h += line.height; }
      }
      for (var p = chunk.parent; p; chunk = p, p = chunk.parent) {
        for (var i$1 = 0; i$1 < p.children.length; ++i$1) {
          var cur = p.children[i$1];
          if (cur == chunk) { break }
          else { h += cur.height; }
        }
      }
      return h
    }

    // Compute the character length of a line, taking into account
    // collapsed ranges (see markText) that might hide parts, and join
    // other lines onto it.
    function lineLength(line) {
      if (line.height == 0) { return 0 }
      var len = line.text.length, merged, cur = line;
      while (merged = collapsedSpanAtStart(cur)) {
        var found = merged.find(0, true);
        cur = found.from.line;
        len += found.from.ch - found.to.ch;
      }
      cur = line;
      while (merged = collapsedSpanAtEnd(cur)) {
        var found$1 = merged.find(0, true);
        len -= cur.text.length - found$1.from.ch;
        cur = found$1.to.line;
        len += cur.text.length - found$1.to.ch;
      }
      return len
    }

    // Find the longest line in the document.
    function findMaxLine(cm) {
      var d = cm.display, doc = cm.doc;
      d.maxLine = getLine(doc, doc.first);
      d.maxLineLength = lineLength(d.maxLine);
      d.maxLineChanged = true;
      doc.iter(function (line) {
        var len = lineLength(line);
        if (len > d.maxLineLength) {
          d.maxLineLength = len;
          d.maxLine = line;
        }
      });
    }

    // LINE DATA STRUCTURE

    // Line objects. These hold state related to a line, including
    // highlighting info (the styles array).
    var Line = function(text, markedSpans, estimateHeight) {
      this.text = text;
      attachMarkedSpans(this, markedSpans);
      this.height = estimateHeight ? estimateHeight(this) : 1;
    };

    Line.prototype.lineNo = function () { return lineNo(this) };
    eventMixin(Line);

    // Change the content (text, markers) of a line. Automatically
    // invalidates cached information and tries to re-estimate the
    // line's height.
    function updateLine(line, text, markedSpans, estimateHeight) {
      line.text = text;
      if (line.stateAfter) { line.stateAfter = null; }
      if (line.styles) { line.styles = null; }
      if (line.order != null) { line.order = null; }
      detachMarkedSpans(line);
      attachMarkedSpans(line, markedSpans);
      var estHeight = estimateHeight ? estimateHeight(line) : 1;
      if (estHeight != line.height) { updateLineHeight(line, estHeight); }
    }

    // Detach a line from the document tree and its markers.
    function cleanUpLine(line) {
      line.parent = null;
      detachMarkedSpans(line);
    }

    // Convert a style as returned by a mode (either null, or a string
    // containing one or more styles) to a CSS style. This is cached,
    // and also looks for line-wide styles.
    var styleToClassCache = {}, styleToClassCacheWithMode = {};
    function interpretTokenStyle(style, options) {
      if (!style || /^\s*$/.test(style)) { return null }
      var cache = options.addModeClass ? styleToClassCacheWithMode : styleToClassCache;
      return cache[style] ||
        (cache[style] = style.replace(/\S+/g, "cm-$&"))
    }

    // Render the DOM representation of the text of a line. Also builds
    // up a 'line map', which points at the DOM nodes that represent
    // specific stretches of text, and is used by the measuring code.
    // The returned object contains the DOM node, this map, and
    // information about line-wide styles that were set by the mode.
    function buildLineContent(cm, lineView) {
      // The padding-right forces the element to have a 'border', which
      // is needed on Webkit to be able to get line-level bounding
      // rectangles for it (in measureChar).
      var content = eltP("span", null, null, webkit ? "padding-right: .1px" : null);
      var builder = {pre: eltP("pre", [content], "CodeMirror-line"), content: content,
                     col: 0, pos: 0, cm: cm,
                     trailingSpace: false,
                     splitSpaces: cm.getOption("lineWrapping")};
      lineView.measure = {};

      // Iterate over the logical lines that make up this visual line.
      for (var i = 0; i <= (lineView.rest ? lineView.rest.length : 0); i++) {
        var line = i ? lineView.rest[i - 1] : lineView.line, order = (void 0);
        builder.pos = 0;
        builder.addToken = buildToken;
        // Optionally wire in some hacks into the token-rendering
        // algorithm, to deal with browser quirks.
        if (hasBadBidiRects(cm.display.measure) && (order = getOrder(line, cm.doc.direction)))
          { builder.addToken = buildTokenBadBidi(builder.addToken, order); }
        builder.map = [];
        var allowFrontierUpdate = lineView != cm.display.externalMeasured && lineNo(line);
        insertLineContent(line, builder, getLineStyles(cm, line, allowFrontierUpdate));
        if (line.styleClasses) {
          if (line.styleClasses.bgClass)
            { builder.bgClass = joinClasses(line.styleClasses.bgClass, builder.bgClass || ""); }
          if (line.styleClasses.textClass)
            { builder.textClass = joinClasses(line.styleClasses.textClass, builder.textClass || ""); }
        }

        // Ensure at least a single node is present, for measuring.
        if (builder.map.length == 0)
          { builder.map.push(0, 0, builder.content.appendChild(zeroWidthElement(cm.display.measure))); }

        // Store the map and a cache object for the current logical line
        if (i == 0) {
          lineView.measure.map = builder.map;
          lineView.measure.cache = {};
        } else {
    (lineView.measure.maps || (lineView.measure.maps = [])).push(builder.map)
          ;(lineView.measure.caches || (lineView.measure.caches = [])).push({});
        }
      }

      // See issue #2901
      if (webkit) {
        var last = builder.content.lastChild;
        if (/\bcm-tab\b/.test(last.className) || (last.querySelector && last.querySelector(".cm-tab")))
          { builder.content.className = "cm-tab-wrap-hack"; }
      }

      signal(cm, "renderLine", cm, lineView.line, builder.pre);
      if (builder.pre.className)
        { builder.textClass = joinClasses(builder.pre.className, builder.textClass || ""); }

      return builder
    }

    function defaultSpecialCharPlaceholder(ch) {
      var token = elt("span", "\u2022", "cm-invalidchar");
      token.title = "\\u" + ch.charCodeAt(0).toString(16);
      token.setAttribute("aria-label", token.title);
      return token
    }

    // Build up the DOM representation for a single token, and add it to
    // the line map. Takes care to render special characters separately.
    function buildToken(builder, text, style, startStyle, endStyle, css, attributes) {
      if (!text) { return }
      var displayText = builder.splitSpaces ? splitSpaces(text, builder.trailingSpace) : text;
      var special = builder.cm.state.specialChars, mustWrap = false;
      var content;
      if (!special.test(text)) {
        builder.col += text.length;
        content = document.createTextNode(displayText);
        builder.map.push(builder.pos, builder.pos + text.length, content);
        if (ie && ie_version < 9) { mustWrap = true; }
        builder.pos += text.length;
      } else {
        content = document.createDocumentFragment();
        var pos = 0;
        while (true) {
          special.lastIndex = pos;
          var m = special.exec(text);
          var skipped = m ? m.index - pos : text.length - pos;
          if (skipped) {
            var txt = document.createTextNode(displayText.slice(pos, pos + skipped));
            if (ie && ie_version < 9) { content.appendChild(elt("span", [txt])); }
            else { content.appendChild(txt); }
            builder.map.push(builder.pos, builder.pos + skipped, txt);
            builder.col += skipped;
            builder.pos += skipped;
          }
          if (!m) { break }
          pos += skipped + 1;
          var txt$1 = (void 0);
          if (m[0] == "\t") {
            var tabSize = builder.cm.options.tabSize, tabWidth = tabSize - builder.col % tabSize;
            txt$1 = content.appendChild(elt("span", spaceStr(tabWidth), "cm-tab"));
            txt$1.setAttribute("role", "presentation");
            txt$1.setAttribute("cm-text", "\t");
            builder.col += tabWidth;
          } else if (m[0] == "\r" || m[0] == "\n") {
            txt$1 = content.appendChild(elt("span", m[0] == "\r" ? "\u240d" : "\u2424", "cm-invalidchar"));
            txt$1.setAttribute("cm-text", m[0]);
            builder.col += 1;
          } else {
            txt$1 = builder.cm.options.specialCharPlaceholder(m[0]);
            txt$1.setAttribute("cm-text", m[0]);
            if (ie && ie_version < 9) { content.appendChild(elt("span", [txt$1])); }
            else { content.appendChild(txt$1); }
            builder.col += 1;
          }
          builder.map.push(builder.pos, builder.pos + 1, txt$1);
          builder.pos++;
        }
      }
      builder.trailingSpace = displayText.charCodeAt(text.length - 1) == 32;
      if (style || startStyle || endStyle || mustWrap || css || attributes) {
        var fullStyle = style || "";
        if (startStyle) { fullStyle += startStyle; }
        if (endStyle) { fullStyle += endStyle; }
        var token = elt("span", [content], fullStyle, css);
        if (attributes) {
          for (var attr in attributes) { if (attributes.hasOwnProperty(attr) && attr != "style" && attr != "class")
            { token.setAttribute(attr, attributes[attr]); } }
        }
        return builder.content.appendChild(token)
      }
      builder.content.appendChild(content);
    }

    // Change some spaces to NBSP to prevent the browser from collapsing
    // trailing spaces at the end of a line when rendering text (issue #1362).
    function splitSpaces(text, trailingBefore) {
      if (text.length > 1 && !/  /.test(text)) { return text }
      var spaceBefore = trailingBefore, result = "";
      for (var i = 0; i < text.length; i++) {
        var ch = text.charAt(i);
        if (ch == " " && spaceBefore && (i == text.length - 1 || text.charCodeAt(i + 1) == 32))
          { ch = "\u00a0"; }
        result += ch;
        spaceBefore = ch == " ";
      }
      return result
    }

    // Work around nonsense dimensions being reported for stretches of
    // right-to-left text.
    function buildTokenBadBidi(inner, order) {
      return function (builder, text, style, startStyle, endStyle, css, attributes) {
        style = style ? style + " cm-force-border" : "cm-force-border";
        var start = builder.pos, end = start + text.length;
        for (;;) {
          // Find the part that overlaps with the start of this text
          var part = (void 0);
          for (var i = 0; i < order.length; i++) {
            part = order[i];
            if (part.to > start && part.from <= start) { break }
          }
          if (part.to >= end) { return inner(builder, text, style, startStyle, endStyle, css, attributes) }
          inner(builder, text.slice(0, part.to - start), style, startStyle, null, css, attributes);
          startStyle = null;
          text = text.slice(part.to - start);
          start = part.to;
        }
      }
    }

    function buildCollapsedSpan(builder, size, marker, ignoreWidget) {
      var widget = !ignoreWidget && marker.widgetNode;
      if (widget) { builder.map.push(builder.pos, builder.pos + size, widget); }
      if (!ignoreWidget && builder.cm.display.input.needsContentAttribute) {
        if (!widget)
          { widget = builder.content.appendChild(document.createElement("span")); }
        widget.setAttribute("cm-marker", marker.id);
      }
      if (widget) {
        builder.cm.display.input.setUneditable(widget);
        builder.content.appendChild(widget);
      }
      builder.pos += size;
      builder.trailingSpace = false;
    }

    // Outputs a number of spans to make up a line, taking highlighting
    // and marked text into account.
    function insertLineContent(line, builder, styles) {
      var spans = line.markedSpans, allText = line.text, at = 0;
      if (!spans) {
        for (var i$1 = 1; i$1 < styles.length; i$1+=2)
          { builder.addToken(builder, allText.slice(at, at = styles[i$1]), interpretTokenStyle(styles[i$1+1], builder.cm.options)); }
        return
      }

      var len = allText.length, pos = 0, i = 1, text = "", style, css;
      var nextChange = 0, spanStyle, spanEndStyle, spanStartStyle, collapsed, attributes;
      for (;;) {
        if (nextChange == pos) { // Update current marker set
          spanStyle = spanEndStyle = spanStartStyle = css = "";
          attributes = null;
          collapsed = null; nextChange = Infinity;
          var foundBookmarks = [], endStyles = (void 0);
          for (var j = 0; j < spans.length; ++j) {
            var sp = spans[j], m = sp.marker;
            if (m.type == "bookmark" && sp.from == pos && m.widgetNode) {
              foundBookmarks.push(m);
            } else if (sp.from <= pos && (sp.to == null || sp.to > pos || m.collapsed && sp.to == pos && sp.from == pos)) {
              if (sp.to != null && sp.to != pos && nextChange > sp.to) {
                nextChange = sp.to;
                spanEndStyle = "";
              }
              if (m.className) { spanStyle += " " + m.className; }
              if (m.css) { css = (css ? css + ";" : "") + m.css; }
              if (m.startStyle && sp.from == pos) { spanStartStyle += " " + m.startStyle; }
              if (m.endStyle && sp.to == nextChange) { (endStyles || (endStyles = [])).push(m.endStyle, sp.to); }
              // support for the old title property
              // https://github.com/codemirror/CodeMirror/pull/5673
              if (m.title) { (attributes || (attributes = {})).title = m.title; }
              if (m.attributes) {
                for (var attr in m.attributes)
                  { (attributes || (attributes = {}))[attr] = m.attributes[attr]; }
              }
              if (m.collapsed && (!collapsed || compareCollapsedMarkers(collapsed.marker, m) < 0))
                { collapsed = sp; }
            } else if (sp.from > pos && nextChange > sp.from) {
              nextChange = sp.from;
            }
          }
          if (endStyles) { for (var j$1 = 0; j$1 < endStyles.length; j$1 += 2)
            { if (endStyles[j$1 + 1] == nextChange) { spanEndStyle += " " + endStyles[j$1]; } } }

          if (!collapsed || collapsed.from == pos) { for (var j$2 = 0; j$2 < foundBookmarks.length; ++j$2)
            { buildCollapsedSpan(builder, 0, foundBookmarks[j$2]); } }
          if (collapsed && (collapsed.from || 0) == pos) {
            buildCollapsedSpan(builder, (collapsed.to == null ? len + 1 : collapsed.to) - pos,
                               collapsed.marker, collapsed.from == null);
            if (collapsed.to == null) { return }
            if (collapsed.to == pos) { collapsed = false; }
          }
        }
        if (pos >= len) { break }

        var upto = Math.min(len, nextChange);
        while (true) {
          if (text) {
            var end = pos + text.length;
            if (!collapsed) {
              var tokenText = end > upto ? text.slice(0, upto - pos) : text;
              builder.addToken(builder, tokenText, style ? style + spanStyle : spanStyle,
                               spanStartStyle, pos + tokenText.length == nextChange ? spanEndStyle : "", css, attributes);
            }
            if (end >= upto) {text = text.slice(upto - pos); pos = upto; break}
            pos = end;
            spanStartStyle = "";
          }
          text = allText.slice(at, at = styles[i++]);
          style = interpretTokenStyle(styles[i++], builder.cm.options);
        }
      }
    }


    // These objects are used to represent the visible (currently drawn)
    // part of the document. A LineView may correspond to multiple
    // logical lines, if those are connected by collapsed ranges.
    function LineView(doc, line, lineN) {
      // The starting line
      this.line = line;
      // Continuing lines, if any
      this.rest = visualLineContinued(line);
      // Number of logical lines in this visual line
      this.size = this.rest ? lineNo(lst(this.rest)) - lineN + 1 : 1;
      this.node = this.text = null;
      this.hidden = lineIsHidden(doc, line);
    }

    // Create a range of LineView objects for the given lines.
    function buildViewArray(cm, from, to) {
      var array = [], nextPos;
      for (var pos = from; pos < to; pos = nextPos) {
        var view = new LineView(cm.doc, getLine(cm.doc, pos), pos);
        nextPos = pos + view.size;
        array.push(view);
      }
      return array
    }

    var operationGroup = null;

    function pushOperation(op) {
      if (operationGroup) {
        operationGroup.ops.push(op);
      } else {
        op.ownsGroup = operationGroup = {
          ops: [op],
          delayedCallbacks: []
        };
      }
    }

    function fireCallbacksForOps(group) {
      // Calls delayed callbacks and cursorActivity handlers until no
      // new ones appear
      var callbacks = group.delayedCallbacks, i = 0;
      do {
        for (; i < callbacks.length; i++)
          { callbacks[i].call(null); }
        for (var j = 0; j < group.ops.length; j++) {
          var op = group.ops[j];
          if (op.cursorActivityHandlers)
            { while (op.cursorActivityCalled < op.cursorActivityHandlers.length)
              { op.cursorActivityHandlers[op.cursorActivityCalled++].call(null, op.cm); } }
        }
      } while (i < callbacks.length)
    }

    function finishOperation(op, endCb) {
      var group = op.ownsGroup;
      if (!group) { return }

      try { fireCallbacksForOps(group); }
      finally {
        operationGroup = null;
        endCb(group);
      }
    }

    var orphanDelayedCallbacks = null;

    // Often, we want to signal events at a point where we are in the
    // middle of some work, but don't want the handler to start calling
    // other methods on the editor, which might be in an inconsistent
    // state or simply not expect any other events to happen.
    // signalLater looks whether there are any handlers, and schedules
    // them to be executed when the last operation ends, or, if no
    // operation is active, when a timeout fires.
    function signalLater(emitter, type /*, values...*/) {
      var arr = getHandlers(emitter, type);
      if (!arr.length) { return }
      var args = Array.prototype.slice.call(arguments, 2), list;
      if (operationGroup) {
        list = operationGroup.delayedCallbacks;
      } else if (orphanDelayedCallbacks) {
        list = orphanDelayedCallbacks;
      } else {
        list = orphanDelayedCallbacks = [];
        setTimeout(fireOrphanDelayed, 0);
      }
      var loop = function ( i ) {
        list.push(function () { return arr[i].apply(null, args); });
      };

      for (var i = 0; i < arr.length; ++i)
        { loop( i ); }
    }

    function fireOrphanDelayed() {
      var delayed = orphanDelayedCallbacks;
      orphanDelayedCallbacks = null;
      for (var i = 0; i < delayed.length; ++i) { delayed[i](); }
    }

    // When an aspect of a line changes, a string is added to
    // lineView.changes. This updates the relevant part of the line's
    // DOM structure.
    function updateLineForChanges(cm, lineView, lineN, dims) {
      for (var j = 0; j < lineView.changes.length; j++) {
        var type = lineView.changes[j];
        if (type == "text") { updateLineText(cm, lineView); }
        else if (type == "gutter") { updateLineGutter(cm, lineView, lineN, dims); }
        else if (type == "class") { updateLineClasses(cm, lineView); }
        else if (type == "widget") { updateLineWidgets(cm, lineView, dims); }
      }
      lineView.changes = null;
    }

    // Lines with gutter elements, widgets or a background class need to
    // be wrapped, and have the extra elements added to the wrapper div
    function ensureLineWrapped(lineView) {
      if (lineView.node == lineView.text) {
        lineView.node = elt("div", null, null, "position: relative");
        if (lineView.text.parentNode)
          { lineView.text.parentNode.replaceChild(lineView.node, lineView.text); }
        lineView.node.appendChild(lineView.text);
        if (ie && ie_version < 8) { lineView.node.style.zIndex = 2; }
      }
      return lineView.node
    }

    function updateLineBackground(cm, lineView) {
      var cls = lineView.bgClass ? lineView.bgClass + " " + (lineView.line.bgClass || "") : lineView.line.bgClass;
      if (cls) { cls += " CodeMirror-linebackground"; }
      if (lineView.background) {
        if (cls) { lineView.background.className = cls; }
        else { lineView.background.parentNode.removeChild(lineView.background); lineView.background = null; }
      } else if (cls) {
        var wrap = ensureLineWrapped(lineView);
        lineView.background = wrap.insertBefore(elt("div", null, cls), wrap.firstChild);
        cm.display.input.setUneditable(lineView.background);
      }
    }

    // Wrapper around buildLineContent which will reuse the structure
    // in display.externalMeasured when possible.
    function getLineContent(cm, lineView) {
      var ext = cm.display.externalMeasured;
      if (ext && ext.line == lineView.line) {
        cm.display.externalMeasured = null;
        lineView.measure = ext.measure;
        return ext.built
      }
      return buildLineContent(cm, lineView)
    }

    // Redraw the line's text. Interacts with the background and text
    // classes because the mode may output tokens that influence these
    // classes.
    function updateLineText(cm, lineView) {
      var cls = lineView.text.className;
      var built = getLineContent(cm, lineView);
      if (lineView.text == lineView.node) { lineView.node = built.pre; }
      lineView.text.parentNode.replaceChild(built.pre, lineView.text);
      lineView.text = built.pre;
      if (built.bgClass != lineView.bgClass || built.textClass != lineView.textClass) {
        lineView.bgClass = built.bgClass;
        lineView.textClass = built.textClass;
        updateLineClasses(cm, lineView);
      } else if (cls) {
        lineView.text.className = cls;
      }
    }

    function updateLineClasses(cm, lineView) {
      updateLineBackground(cm, lineView);
      if (lineView.line.wrapClass)
        { ensureLineWrapped(lineView).className = lineView.line.wrapClass; }
      else if (lineView.node != lineView.text)
        { lineView.node.className = ""; }
      var textClass = lineView.textClass ? lineView.textClass + " " + (lineView.line.textClass || "") : lineView.line.textClass;
      lineView.text.className = textClass || "";
    }

    function updateLineGutter(cm, lineView, lineN, dims) {
      if (lineView.gutter) {
        lineView.node.removeChild(lineView.gutter);
        lineView.gutter = null;
      }
      if (lineView.gutterBackground) {
        lineView.node.removeChild(lineView.gutterBackground);
        lineView.gutterBackground = null;
      }
      if (lineView.line.gutterClass) {
        var wrap = ensureLineWrapped(lineView);
        lineView.gutterBackground = elt("div", null, "CodeMirror-gutter-background " + lineView.line.gutterClass,
                                        ("left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px; width: " + (dims.gutterTotalWidth) + "px"));
        cm.display.input.setUneditable(lineView.gutterBackground);
        wrap.insertBefore(lineView.gutterBackground, lineView.text);
      }
      var markers = lineView.line.gutterMarkers;
      if (cm.options.lineNumbers || markers) {
        var wrap$1 = ensureLineWrapped(lineView);
        var gutterWrap = lineView.gutter = elt("div", null, "CodeMirror-gutter-wrapper", ("left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px"));
        cm.display.input.setUneditable(gutterWrap);
        wrap$1.insertBefore(gutterWrap, lineView.text);
        if (lineView.line.gutterClass)
          { gutterWrap.className += " " + lineView.line.gutterClass; }
        if (cm.options.lineNumbers && (!markers || !markers["CodeMirror-linenumbers"]))
          { lineView.lineNumber = gutterWrap.appendChild(
            elt("div", lineNumberFor(cm.options, lineN),
                "CodeMirror-linenumber CodeMirror-gutter-elt",
                ("left: " + (dims.gutterLeft["CodeMirror-linenumbers"]) + "px; width: " + (cm.display.lineNumInnerWidth) + "px"))); }
        if (markers) { for (var k = 0; k < cm.display.gutterSpecs.length; ++k) {
          var id = cm.display.gutterSpecs[k].className, found = markers.hasOwnProperty(id) && markers[id];
          if (found)
            { gutterWrap.appendChild(elt("div", [found], "CodeMirror-gutter-elt",
                                       ("left: " + (dims.gutterLeft[id]) + "px; width: " + (dims.gutterWidth[id]) + "px"))); }
        } }
      }
    }

    function updateLineWidgets(cm, lineView, dims) {
      if (lineView.alignable) { lineView.alignable = null; }
      var isWidget = classTest("CodeMirror-linewidget");
      for (var node = lineView.node.firstChild, next = (void 0); node; node = next) {
        next = node.nextSibling;
        if (isWidget.test(node.className)) { lineView.node.removeChild(node); }
      }
      insertLineWidgets(cm, lineView, dims);
    }

    // Build a line's DOM representation from scratch
    function buildLineElement(cm, lineView, lineN, dims) {
      var built = getLineContent(cm, lineView);
      lineView.text = lineView.node = built.pre;
      if (built.bgClass) { lineView.bgClass = built.bgClass; }
      if (built.textClass) { lineView.textClass = built.textClass; }

      updateLineClasses(cm, lineView);
      updateLineGutter(cm, lineView, lineN, dims);
      insertLineWidgets(cm, lineView, dims);
      return lineView.node
    }

    // A lineView may contain multiple logical lines (when merged by
    // collapsed spans). The widgets for all of them need to be drawn.
    function insertLineWidgets(cm, lineView, dims) {
      insertLineWidgetsFor(cm, lineView.line, lineView, dims, true);
      if (lineView.rest) { for (var i = 0; i < lineView.rest.length; i++)
        { insertLineWidgetsFor(cm, lineView.rest[i], lineView, dims, false); } }
    }

    function insertLineWidgetsFor(cm, line, lineView, dims, allowAbove) {
      if (!line.widgets) { return }
      var wrap = ensureLineWrapped(lineView);
      for (var i = 0, ws = line.widgets; i < ws.length; ++i) {
        var widget = ws[i], node = elt("div", [widget.node], "CodeMirror-linewidget" + (widget.className ? " " + widget.className : ""));
        if (!widget.handleMouseEvents) { node.setAttribute("cm-ignore-events", "true"); }
        positionLineWidget(widget, node, lineView, dims);
        cm.display.input.setUneditable(node);
        if (allowAbove && widget.above)
          { wrap.insertBefore(node, lineView.gutter || lineView.text); }
        else
          { wrap.appendChild(node); }
        signalLater(widget, "redraw");
      }
    }

    function positionLineWidget(widget, node, lineView, dims) {
      if (widget.noHScroll) {
    (lineView.alignable || (lineView.alignable = [])).push(node);
        var width = dims.wrapperWidth;
        node.style.left = dims.fixedPos + "px";
        if (!widget.coverGutter) {
          width -= dims.gutterTotalWidth;
          node.style.paddingLeft = dims.gutterTotalWidth + "px";
        }
        node.style.width = width + "px";
      }
      if (widget.coverGutter) {
        node.style.zIndex = 5;
        node.style.position = "relative";
        if (!widget.noHScroll) { node.style.marginLeft = -dims.gutterTotalWidth + "px"; }
      }
    }

    function widgetHeight(widget) {
      if (widget.height != null) { return widget.height }
      var cm = widget.doc.cm;
      if (!cm) { return 0 }
      if (!contains(document.body, widget.node)) {
        var parentStyle = "position: relative;";
        if (widget.coverGutter)
          { parentStyle += "margin-left: -" + cm.display.gutters.offsetWidth + "px;"; }
        if (widget.noHScroll)
          { parentStyle += "width: " + cm.display.wrapper.clientWidth + "px;"; }
        removeChildrenAndAdd(cm.display.measure, elt("div", [widget.node], null, parentStyle));
      }
      return widget.height = widget.node.parentNode.offsetHeight
    }

    // Return true when the given mouse event happened in a widget
    function eventInWidget(display, e) {
      for (var n = e_target(e); n != display.wrapper; n = n.parentNode) {
        if (!n || (n.nodeType == 1 && n.getAttribute("cm-ignore-events") == "true") ||
            (n.parentNode == display.sizer && n != display.mover))
          { return true }
      }
    }

    // POSITION MEASUREMENT

    function paddingTop(display) {return display.lineSpace.offsetTop}
    function paddingVert(display) {return display.mover.offsetHeight - display.lineSpace.offsetHeight}
    function paddingH(display) {
      if (display.cachedPaddingH) { return display.cachedPaddingH }
      var e = removeChildrenAndAdd(display.measure, elt("pre", "x", "CodeMirror-line-like"));
      var style = window.getComputedStyle ? window.getComputedStyle(e) : e.currentStyle;
      var data = {left: parseInt(style.paddingLeft), right: parseInt(style.paddingRight)};
      if (!isNaN(data.left) && !isNaN(data.right)) { display.cachedPaddingH = data; }
      return data
    }

    function scrollGap(cm) { return scrollerGap - cm.display.nativeBarWidth }
    function displayWidth(cm) {
      return cm.display.scroller.clientWidth - scrollGap(cm) - cm.display.barWidth
    }
    function displayHeight(cm) {
      return cm.display.scroller.clientHeight - scrollGap(cm) - cm.display.barHeight
    }

    // Ensure the lineView.wrapping.heights array is populated. This is
    // an array of bottom offsets for the lines that make up a drawn
    // line. When lineWrapping is on, there might be more than one
    // height.
    function ensureLineHeights(cm, lineView, rect) {
      var wrapping = cm.options.lineWrapping;
      var curWidth = wrapping && displayWidth(cm);
      if (!lineView.measure.heights || wrapping && lineView.measure.width != curWidth) {
        var heights = lineView.measure.heights = [];
        if (wrapping) {
          lineView.measure.width = curWidth;
          var rects = lineView.text.firstChild.getClientRects();
          for (var i = 0; i < rects.length - 1; i++) {
            var cur = rects[i], next = rects[i + 1];
            if (Math.abs(cur.bottom - next.bottom) > 2)
              { heights.push((cur.bottom + next.top) / 2 - rect.top); }
          }
        }
        heights.push(rect.bottom - rect.top);
      }
    }

    // Find a line map (mapping character offsets to text nodes) and a
    // measurement cache for the given line number. (A line view might
    // contain multiple lines when collapsed ranges are present.)
    function mapFromLineView(lineView, line, lineN) {
      if (lineView.line == line)
        { return {map: lineView.measure.map, cache: lineView.measure.cache} }
      for (var i = 0; i < lineView.rest.length; i++)
        { if (lineView.rest[i] == line)
          { return {map: lineView.measure.maps[i], cache: lineView.measure.caches[i]} } }
      for (var i$1 = 0; i$1 < lineView.rest.length; i$1++)
        { if (lineNo(lineView.rest[i$1]) > lineN)
          { return {map: lineView.measure.maps[i$1], cache: lineView.measure.caches[i$1], before: true} } }
    }

    // Render a line into the hidden node display.externalMeasured. Used
    // when measurement is needed for a line that's not in the viewport.
    function updateExternalMeasurement(cm, line) {
      line = visualLine(line);
      var lineN = lineNo(line);
      var view = cm.display.externalMeasured = new LineView(cm.doc, line, lineN);
      view.lineN = lineN;
      var built = view.built = buildLineContent(cm, view);
      view.text = built.pre;
      removeChildrenAndAdd(cm.display.lineMeasure, built.pre);
      return view
    }

    // Get a {top, bottom, left, right} box (in line-local coordinates)
    // for a given character.
    function measureChar(cm, line, ch, bias) {
      return measureCharPrepared(cm, prepareMeasureForLine(cm, line), ch, bias)
    }

    // Find a line view that corresponds to the given line number.
    function findViewForLine(cm, lineN) {
      if (lineN >= cm.display.viewFrom && lineN < cm.display.viewTo)
        { return cm.display.view[findViewIndex(cm, lineN)] }
      var ext = cm.display.externalMeasured;
      if (ext && lineN >= ext.lineN && lineN < ext.lineN + ext.size)
        { return ext }
    }

    // Measurement can be split in two steps, the set-up work that
    // applies to the whole line, and the measurement of the actual
    // character. Functions like coordsChar, that need to do a lot of
    // measurements in a row, can thus ensure that the set-up work is
    // only done once.
    function prepareMeasureForLine(cm, line) {
      var lineN = lineNo(line);
      var view = findViewForLine(cm, lineN);
      if (view && !view.text) {
        view = null;
      } else if (view && view.changes) {
        updateLineForChanges(cm, view, lineN, getDimensions(cm));
        cm.curOp.forceUpdate = true;
      }
      if (!view)
        { view = updateExternalMeasurement(cm, line); }

      var info = mapFromLineView(view, line, lineN);
      return {
        line: line, view: view, rect: null,
        map: info.map, cache: info.cache, before: info.before,
        hasHeights: false
      }
    }

    // Given a prepared measurement object, measures the position of an
    // actual character (or fetches it from the cache).
    function measureCharPrepared(cm, prepared, ch, bias, varHeight) {
      if (prepared.before) { ch = -1; }
      var key = ch + (bias || ""), found;
      if (prepared.cache.hasOwnProperty(key)) {
        found = prepared.cache[key];
      } else {
        if (!prepared.rect)
          { prepared.rect = prepared.view.text.getBoundingClientRect(); }
        if (!prepared.hasHeights) {
          ensureLineHeights(cm, prepared.view, prepared.rect);
          prepared.hasHeights = true;
        }
        found = measureCharInner(cm, prepared, ch, bias);
        if (!found.bogus) { prepared.cache[key] = found; }
      }
      return {left: found.left, right: found.right,
              top: varHeight ? found.rtop : found.top,
              bottom: varHeight ? found.rbottom : found.bottom}
    }

    var nullRect = {left: 0, right: 0, top: 0, bottom: 0};

    function nodeAndOffsetInLineMap(map, ch, bias) {
      var node, start, end, collapse, mStart, mEnd;
      // First, search the line map for the text node corresponding to,
      // or closest to, the target character.
      for (var i = 0; i < map.length; i += 3) {
        mStart = map[i];
        mEnd = map[i + 1];
        if (ch < mStart) {
          start = 0; end = 1;
          collapse = "left";
        } else if (ch < mEnd) {
          start = ch - mStart;
          end = start + 1;
        } else if (i == map.length - 3 || ch == mEnd && map[i + 3] > ch) {
          end = mEnd - mStart;
          start = end - 1;
          if (ch >= mEnd) { collapse = "right"; }
        }
        if (start != null) {
          node = map[i + 2];
          if (mStart == mEnd && bias == (node.insertLeft ? "left" : "right"))
            { collapse = bias; }
          if (bias == "left" && start == 0)
            { while (i && map[i - 2] == map[i - 3] && map[i - 1].insertLeft) {
              node = map[(i -= 3) + 2];
              collapse = "left";
            } }
          if (bias == "right" && start == mEnd - mStart)
            { while (i < map.length - 3 && map[i + 3] == map[i + 4] && !map[i + 5].insertLeft) {
              node = map[(i += 3) + 2];
              collapse = "right";
            } }
          break
        }
      }
      return {node: node, start: start, end: end, collapse: collapse, coverStart: mStart, coverEnd: mEnd}
    }

    function getUsefulRect(rects, bias) {
      var rect = nullRect;
      if (bias == "left") { for (var i = 0; i < rects.length; i++) {
        if ((rect = rects[i]).left != rect.right) { break }
      } } else { for (var i$1 = rects.length - 1; i$1 >= 0; i$1--) {
        if ((rect = rects[i$1]).left != rect.right) { break }
      } }
      return rect
    }

    function measureCharInner(cm, prepared, ch, bias) {
      var place = nodeAndOffsetInLineMap(prepared.map, ch, bias);
      var node = place.node, start = place.start, end = place.end, collapse = place.collapse;

      var rect;
      if (node.nodeType == 3) { // If it is a text node, use a range to retrieve the coordinates.
        for (var i$1 = 0; i$1 < 4; i$1++) { // Retry a maximum of 4 times when nonsense rectangles are returned
          while (start && isExtendingChar(prepared.line.text.charAt(place.coverStart + start))) { --start; }
          while (place.coverStart + end < place.coverEnd && isExtendingChar(prepared.line.text.charAt(place.coverStart + end))) { ++end; }
          if (ie && ie_version < 9 && start == 0 && end == place.coverEnd - place.coverStart)
            { rect = node.parentNode.getBoundingClientRect(); }
          else
            { rect = getUsefulRect(range(node, start, end).getClientRects(), bias); }
          if (rect.left || rect.right || start == 0) { break }
          end = start;
          start = start - 1;
          collapse = "right";
        }
        if (ie && ie_version < 11) { rect = maybeUpdateRectForZooming(cm.display.measure, rect); }
      } else { // If it is a widget, simply get the box for the whole widget.
        if (start > 0) { collapse = bias = "right"; }
        var rects;
        if (cm.options.lineWrapping && (rects = node.getClientRects()).length > 1)
          { rect = rects[bias == "right" ? rects.length - 1 : 0]; }
        else
          { rect = node.getBoundingClientRect(); }
      }
      if (ie && ie_version < 9 && !start && (!rect || !rect.left && !rect.right)) {
        var rSpan = node.parentNode.getClientRects()[0];
        if (rSpan)
          { rect = {left: rSpan.left, right: rSpan.left + charWidth(cm.display), top: rSpan.top, bottom: rSpan.bottom}; }
        else
          { rect = nullRect; }
      }

      var rtop = rect.top - prepared.rect.top, rbot = rect.bottom - prepared.rect.top;
      var mid = (rtop + rbot) / 2;
      var heights = prepared.view.measure.heights;
      var i = 0;
      for (; i < heights.length - 1; i++)
        { if (mid < heights[i]) { break } }
      var top = i ? heights[i - 1] : 0, bot = heights[i];
      var result = {left: (collapse == "right" ? rect.right : rect.left) - prepared.rect.left,
                    right: (collapse == "left" ? rect.left : rect.right) - prepared.rect.left,
                    top: top, bottom: bot};
      if (!rect.left && !rect.right) { result.bogus = true; }
      if (!cm.options.singleCursorHeightPerLine) { result.rtop = rtop; result.rbottom = rbot; }

      return result
    }

    // Work around problem with bounding client rects on ranges being
    // returned incorrectly when zoomed on IE10 and below.
    function maybeUpdateRectForZooming(measure, rect) {
      if (!window.screen || screen.logicalXDPI == null ||
          screen.logicalXDPI == screen.deviceXDPI || !hasBadZoomedRects(measure))
        { return rect }
      var scaleX = screen.logicalXDPI / screen.deviceXDPI;
      var scaleY = screen.logicalYDPI / screen.deviceYDPI;
      return {left: rect.left * scaleX, right: rect.right * scaleX,
              top: rect.top * scaleY, bottom: rect.bottom * scaleY}
    }

    function clearLineMeasurementCacheFor(lineView) {
      if (lineView.measure) {
        lineView.measure.cache = {};
        lineView.measure.heights = null;
        if (lineView.rest) { for (var i = 0; i < lineView.rest.length; i++)
          { lineView.measure.caches[i] = {}; } }
      }
    }

    function clearLineMeasurementCache(cm) {
      cm.display.externalMeasure = null;
      removeChildren(cm.display.lineMeasure);
      for (var i = 0; i < cm.display.view.length; i++)
        { clearLineMeasurementCacheFor(cm.display.view[i]); }
    }

    function clearCaches(cm) {
      clearLineMeasurementCache(cm);
      cm.display.cachedCharWidth = cm.display.cachedTextHeight = cm.display.cachedPaddingH = null;
      if (!cm.options.lineWrapping) { cm.display.maxLineChanged = true; }
      cm.display.lineNumChars = null;
    }

    function pageScrollX() {
      // Work around https://bugs.chromium.org/p/chromium/issues/detail?id=489206
      // which causes page_Offset and bounding client rects to use
      // different reference viewports and invalidate our calculations.
      if (chrome && android) { return -(document.body.getBoundingClientRect().left - parseInt(getComputedStyle(document.body).marginLeft)) }
      return window.pageXOffset || (document.documentElement || document.body).scrollLeft
    }
    function pageScrollY() {
      if (chrome && android) { return -(document.body.getBoundingClientRect().top - parseInt(getComputedStyle(document.body).marginTop)) }
      return window.pageYOffset || (document.documentElement || document.body).scrollTop
    }

    function widgetTopHeight(lineObj) {
      var height = 0;
      if (lineObj.widgets) { for (var i = 0; i < lineObj.widgets.length; ++i) { if (lineObj.widgets[i].above)
        { height += widgetHeight(lineObj.widgets[i]); } } }
      return height
    }

    // Converts a {top, bottom, left, right} box from line-local
    // coordinates into another coordinate system. Context may be one of
    // "line", "div" (display.lineDiv), "local"./null (editor), "window",
    // or "page".
    function intoCoordSystem(cm, lineObj, rect, context, includeWidgets) {
      if (!includeWidgets) {
        var height = widgetTopHeight(lineObj);
        rect.top += height; rect.bottom += height;
      }
      if (context == "line") { return rect }
      if (!context) { context = "local"; }
      var yOff = heightAtLine(lineObj);
      if (context == "local") { yOff += paddingTop(cm.display); }
      else { yOff -= cm.display.viewOffset; }
      if (context == "page" || context == "window") {
        var lOff = cm.display.lineSpace.getBoundingClientRect();
        yOff += lOff.top + (context == "window" ? 0 : pageScrollY());
        var xOff = lOff.left + (context == "window" ? 0 : pageScrollX());
        rect.left += xOff; rect.right += xOff;
      }
      rect.top += yOff; rect.bottom += yOff;
      return rect
    }

    // Coverts a box from "div" coords to another coordinate system.
    // Context may be "window", "page", "div", or "local"./null.
    function fromCoordSystem(cm, coords, context) {
      if (context == "div") { return coords }
      var left = coords.left, top = coords.top;
      // First move into "page" coordinate system
      if (context == "page") {
        left -= pageScrollX();
        top -= pageScrollY();
      } else if (context == "local" || !context) {
        var localBox = cm.display.sizer.getBoundingClientRect();
        left += localBox.left;
        top += localBox.top;
      }

      var lineSpaceBox = cm.display.lineSpace.getBoundingClientRect();
      return {left: left - lineSpaceBox.left, top: top - lineSpaceBox.top}
    }

    function charCoords(cm, pos, context, lineObj, bias) {
      if (!lineObj) { lineObj = getLine(cm.doc, pos.line); }
      return intoCoordSystem(cm, lineObj, measureChar(cm, lineObj, pos.ch, bias), context)
    }

    // Returns a box for a given cursor position, which may have an
    // 'other' property containing the position of the secondary cursor
    // on a bidi boundary.
    // A cursor Pos(line, char, "before") is on the same visual line as `char - 1`
    // and after `char - 1` in writing order of `char - 1`
    // A cursor Pos(line, char, "after") is on the same visual line as `char`
    // and before `char` in writing order of `char`
    // Examples (upper-case letters are RTL, lower-case are LTR):
    //     Pos(0, 1, ...)
    //     before   after
    // ab     a|b     a|b
    // aB     a|B     aB|
    // Ab     |Ab     A|b
    // AB     B|A     B|A
    // Every position after the last character on a line is considered to stick
    // to the last character on the line.
    function cursorCoords(cm, pos, context, lineObj, preparedMeasure, varHeight) {
      lineObj = lineObj || getLine(cm.doc, pos.line);
      if (!preparedMeasure) { preparedMeasure = prepareMeasureForLine(cm, lineObj); }
      function get(ch, right) {
        var m = measureCharPrepared(cm, preparedMeasure, ch, right ? "right" : "left", varHeight);
        if (right) { m.left = m.right; } else { m.right = m.left; }
        return intoCoordSystem(cm, lineObj, m, context)
      }
      var order = getOrder(lineObj, cm.doc.direction), ch = pos.ch, sticky = pos.sticky;
      if (ch >= lineObj.text.length) {
        ch = lineObj.text.length;
        sticky = "before";
      } else if (ch <= 0) {
        ch = 0;
        sticky = "after";
      }
      if (!order) { return get(sticky == "before" ? ch - 1 : ch, sticky == "before") }

      function getBidi(ch, partPos, invert) {
        var part = order[partPos], right = part.level == 1;
        return get(invert ? ch - 1 : ch, right != invert)
      }
      var partPos = getBidiPartAt(order, ch, sticky);
      var other = bidiOther;
      var val = getBidi(ch, partPos, sticky == "before");
      if (other != null) { val.other = getBidi(ch, other, sticky != "before"); }
      return val
    }

    // Used to cheaply estimate the coordinates for a position. Used for
    // intermediate scroll updates.
    function estimateCoords(cm, pos) {
      var left = 0;
      pos = clipPos(cm.doc, pos);
      if (!cm.options.lineWrapping) { left = charWidth(cm.display) * pos.ch; }
      var lineObj = getLine(cm.doc, pos.line);
      var top = heightAtLine(lineObj) + paddingTop(cm.display);
      return {left: left, right: left, top: top, bottom: top + lineObj.height}
    }

    // Positions returned by coordsChar contain some extra information.
    // xRel is the relative x position of the input coordinates compared
    // to the found position (so xRel > 0 means the coordinates are to
    // the right of the character position, for example). When outside
    // is true, that means the coordinates lie outside the line's
    // vertical range.
    function PosWithInfo(line, ch, sticky, outside, xRel) {
      var pos = Pos(line, ch, sticky);
      pos.xRel = xRel;
      if (outside) { pos.outside = outside; }
      return pos
    }

    // Compute the character position closest to the given coordinates.
    // Input must be lineSpace-local ("div" coordinate system).
    function coordsChar(cm, x, y) {
      var doc = cm.doc;
      y += cm.display.viewOffset;
      if (y < 0) { return PosWithInfo(doc.first, 0, null, -1, -1) }
      var lineN = lineAtHeight(doc, y), last = doc.first + doc.size - 1;
      if (lineN > last)
        { return PosWithInfo(doc.first + doc.size - 1, getLine(doc, last).text.length, null, 1, 1) }
      if (x < 0) { x = 0; }

      var lineObj = getLine(doc, lineN);
      for (;;) {
        var found = coordsCharInner(cm, lineObj, lineN, x, y);
        var collapsed = collapsedSpanAround(lineObj, found.ch + (found.xRel > 0 || found.outside > 0 ? 1 : 0));
        if (!collapsed) { return found }
        var rangeEnd = collapsed.find(1);
        if (rangeEnd.line == lineN) { return rangeEnd }
        lineObj = getLine(doc, lineN = rangeEnd.line);
      }
    }

    function wrappedLineExtent(cm, lineObj, preparedMeasure, y) {
      y -= widgetTopHeight(lineObj);
      var end = lineObj.text.length;
      var begin = findFirst(function (ch) { return measureCharPrepared(cm, preparedMeasure, ch - 1).bottom <= y; }, end, 0);
      end = findFirst(function (ch) { return measureCharPrepared(cm, preparedMeasure, ch).top > y; }, begin, end);
      return {begin: begin, end: end}
    }

    function wrappedLineExtentChar(cm, lineObj, preparedMeasure, target) {
      if (!preparedMeasure) { preparedMeasure = prepareMeasureForLine(cm, lineObj); }
      var targetTop = intoCoordSystem(cm, lineObj, measureCharPrepared(cm, preparedMeasure, target), "line").top;
      return wrappedLineExtent(cm, lineObj, preparedMeasure, targetTop)
    }

    // Returns true if the given side of a box is after the given
    // coordinates, in top-to-bottom, left-to-right order.
    function boxIsAfter(box, x, y, left) {
      return box.bottom <= y ? false : box.top > y ? true : (left ? box.left : box.right) > x
    }

    function coordsCharInner(cm, lineObj, lineNo, x, y) {
      // Move y into line-local coordinate space
      y -= heightAtLine(lineObj);
      var preparedMeasure = prepareMeasureForLine(cm, lineObj);
      // When directly calling `measureCharPrepared`, we have to adjust
      // for the widgets at this line.
      var widgetHeight = widgetTopHeight(lineObj);
      var begin = 0, end = lineObj.text.length, ltr = true;

      var order = getOrder(lineObj, cm.doc.direction);
      // If the line isn't plain left-to-right text, first figure out
      // which bidi section the coordinates fall into.
      if (order) {
        var part = (cm.options.lineWrapping ? coordsBidiPartWrapped : coordsBidiPart)
                     (cm, lineObj, lineNo, preparedMeasure, order, x, y);
        ltr = part.level != 1;
        // The awkward -1 offsets are needed because findFirst (called
        // on these below) will treat its first bound as inclusive,
        // second as exclusive, but we want to actually address the
        // characters in the part's range
        begin = ltr ? part.from : part.to - 1;
        end = ltr ? part.to : part.from - 1;
      }

      // A binary search to find the first character whose bounding box
      // starts after the coordinates. If we run across any whose box wrap
      // the coordinates, store that.
      var chAround = null, boxAround = null;
      var ch = findFirst(function (ch) {
        var box = measureCharPrepared(cm, preparedMeasure, ch);
        box.top += widgetHeight; box.bottom += widgetHeight;
        if (!boxIsAfter(box, x, y, false)) { return false }
        if (box.top <= y && box.left <= x) {
          chAround = ch;
          boxAround = box;
        }
        return true
      }, begin, end);

      var baseX, sticky, outside = false;
      // If a box around the coordinates was found, use that
      if (boxAround) {
        // Distinguish coordinates nearer to the left or right side of the box
        var atLeft = x - boxAround.left < boxAround.right - x, atStart = atLeft == ltr;
        ch = chAround + (atStart ? 0 : 1);
        sticky = atStart ? "after" : "before";
        baseX = atLeft ? boxAround.left : boxAround.right;
      } else {
        // (Adjust for extended bound, if necessary.)
        if (!ltr && (ch == end || ch == begin)) { ch++; }
        // To determine which side to associate with, get the box to the
        // left of the character and compare it's vertical position to the
        // coordinates
        sticky = ch == 0 ? "after" : ch == lineObj.text.length ? "before" :
          (measureCharPrepared(cm, preparedMeasure, ch - (ltr ? 1 : 0)).bottom + widgetHeight <= y) == ltr ?
          "after" : "before";
        // Now get accurate coordinates for this place, in order to get a
        // base X position
        var coords = cursorCoords(cm, Pos(lineNo, ch, sticky), "line", lineObj, preparedMeasure);
        baseX = coords.left;
        outside = y < coords.top ? -1 : y >= coords.bottom ? 1 : 0;
      }

      ch = skipExtendingChars(lineObj.text, ch, 1);
      return PosWithInfo(lineNo, ch, sticky, outside, x - baseX)
    }

    function coordsBidiPart(cm, lineObj, lineNo, preparedMeasure, order, x, y) {
      // Bidi parts are sorted left-to-right, and in a non-line-wrapping
      // situation, we can take this ordering to correspond to the visual
      // ordering. This finds the first part whose end is after the given
      // coordinates.
      var index = findFirst(function (i) {
        var part = order[i], ltr = part.level != 1;
        return boxIsAfter(cursorCoords(cm, Pos(lineNo, ltr ? part.to : part.from, ltr ? "before" : "after"),
                                       "line", lineObj, preparedMeasure), x, y, true)
      }, 0, order.length - 1);
      var part = order[index];
      // If this isn't the first part, the part's start is also after
      // the coordinates, and the coordinates aren't on the same line as
      // that start, move one part back.
      if (index > 0) {
        var ltr = part.level != 1;
        var start = cursorCoords(cm, Pos(lineNo, ltr ? part.from : part.to, ltr ? "after" : "before"),
                                 "line", lineObj, preparedMeasure);
        if (boxIsAfter(start, x, y, true) && start.top > y)
          { part = order[index - 1]; }
      }
      return part
    }

    function coordsBidiPartWrapped(cm, lineObj, _lineNo, preparedMeasure, order, x, y) {
      // In a wrapped line, rtl text on wrapping boundaries can do things
      // that don't correspond to the ordering in our `order` array at
      // all, so a binary search doesn't work, and we want to return a
      // part that only spans one line so that the binary search in
      // coordsCharInner is safe. As such, we first find the extent of the
      // wrapped line, and then do a flat search in which we discard any
      // spans that aren't on the line.
      var ref = wrappedLineExtent(cm, lineObj, preparedMeasure, y);
      var begin = ref.begin;
      var end = ref.end;
      if (/\s/.test(lineObj.text.charAt(end - 1))) { end--; }
      var part = null, closestDist = null;
      for (var i = 0; i < order.length; i++) {
        var p = order[i];
        if (p.from >= end || p.to <= begin) { continue }
        var ltr = p.level != 1;
        var endX = measureCharPrepared(cm, preparedMeasure, ltr ? Math.min(end, p.to) - 1 : Math.max(begin, p.from)).right;
        // Weigh against spans ending before this, so that they are only
        // picked if nothing ends after
        var dist = endX < x ? x - endX + 1e9 : endX - x;
        if (!part || closestDist > dist) {
          part = p;
          closestDist = dist;
        }
      }
      if (!part) { part = order[order.length - 1]; }
      // Clip the part to the wrapped line.
      if (part.from < begin) { part = {from: begin, to: part.to, level: part.level}; }
      if (part.to > end) { part = {from: part.from, to: end, level: part.level}; }
      return part
    }

    var measureText;
    // Compute the default text height.
    function textHeight(display) {
      if (display.cachedTextHeight != null) { return display.cachedTextHeight }
      if (measureText == null) {
        measureText = elt("pre", null, "CodeMirror-line-like");
        // Measure a bunch of lines, for browsers that compute
        // fractional heights.
        for (var i = 0; i < 49; ++i) {
          measureText.appendChild(document.createTextNode("x"));
          measureText.appendChild(elt("br"));
        }
        measureText.appendChild(document.createTextNode("x"));
      }
      removeChildrenAndAdd(display.measure, measureText);
      var height = measureText.offsetHeight / 50;
      if (height > 3) { display.cachedTextHeight = height; }
      removeChildren(display.measure);
      return height || 1
    }

    // Compute the default character width.
    function charWidth(display) {
      if (display.cachedCharWidth != null) { return display.cachedCharWidth }
      var anchor = elt("span", "xxxxxxxxxx");
      var pre = elt("pre", [anchor], "CodeMirror-line-like");
      removeChildrenAndAdd(display.measure, pre);
      var rect = anchor.getBoundingClientRect(), width = (rect.right - rect.left) / 10;
      if (width > 2) { display.cachedCharWidth = width; }
      return width || 10
    }

    // Do a bulk-read of the DOM positions and sizes needed to draw the
    // view, so that we don't interleave reading and writing to the DOM.
    function getDimensions(cm) {
      var d = cm.display, left = {}, width = {};
      var gutterLeft = d.gutters.clientLeft;
      for (var n = d.gutters.firstChild, i = 0; n; n = n.nextSibling, ++i) {
        var id = cm.display.gutterSpecs[i].className;
        left[id] = n.offsetLeft + n.clientLeft + gutterLeft;
        width[id] = n.clientWidth;
      }
      return {fixedPos: compensateForHScroll(d),
              gutterTotalWidth: d.gutters.offsetWidth,
              gutterLeft: left,
              gutterWidth: width,
              wrapperWidth: d.wrapper.clientWidth}
    }

    // Computes display.scroller.scrollLeft + display.gutters.offsetWidth,
    // but using getBoundingClientRect to get a sub-pixel-accurate
    // result.
    function compensateForHScroll(display) {
      return display.scroller.getBoundingClientRect().left - display.sizer.getBoundingClientRect().left
    }

    // Returns a function that estimates the height of a line, to use as
    // first approximation until the line becomes visible (and is thus
    // properly measurable).
    function estimateHeight(cm) {
      var th = textHeight(cm.display), wrapping = cm.options.lineWrapping;
      var perLine = wrapping && Math.max(5, cm.display.scroller.clientWidth / charWidth(cm.display) - 3);
      return function (line) {
        if (lineIsHidden(cm.doc, line)) { return 0 }

        var widgetsHeight = 0;
        if (line.widgets) { for (var i = 0; i < line.widgets.length; i++) {
          if (line.widgets[i].height) { widgetsHeight += line.widgets[i].height; }
        } }

        if (wrapping)
          { return widgetsHeight + (Math.ceil(line.text.length / perLine) || 1) * th }
        else
          { return widgetsHeight + th }
      }
    }

    function estimateLineHeights(cm) {
      var doc = cm.doc, est = estimateHeight(cm);
      doc.iter(function (line) {
        var estHeight = est(line);
        if (estHeight != line.height) { updateLineHeight(line, estHeight); }
      });
    }

    // Given a mouse event, find the corresponding position. If liberal
    // is false, it checks whether a gutter or scrollbar was clicked,
    // and returns null if it was. forRect is used by rectangular
    // selections, and tries to estimate a character position even for
    // coordinates beyond the right of the text.
    function posFromMouse(cm, e, liberal, forRect) {
      var display = cm.display;
      if (!liberal && e_target(e).getAttribute("cm-not-content") == "true") { return null }

      var x, y, space = display.lineSpace.getBoundingClientRect();
      // Fails unpredictably on IE[67] when mouse is dragged around quickly.
      try { x = e.clientX - space.left; y = e.clientY - space.top; }
      catch (e$1) { return null }
      var coords = coordsChar(cm, x, y), line;
      if (forRect && coords.xRel > 0 && (line = getLine(cm.doc, coords.line).text).length == coords.ch) {
        var colDiff = countColumn(line, line.length, cm.options.tabSize) - line.length;
        coords = Pos(coords.line, Math.max(0, Math.round((x - paddingH(cm.display).left) / charWidth(cm.display)) - colDiff));
      }
      return coords
    }

    // Find the view element corresponding to a given line. Return null
    // when the line isn't visible.
    function findViewIndex(cm, n) {
      if (n >= cm.display.viewTo) { return null }
      n -= cm.display.viewFrom;
      if (n < 0) { return null }
      var view = cm.display.view;
      for (var i = 0; i < view.length; i++) {
        n -= view[i].size;
        if (n < 0) { return i }
      }
    }

    // Updates the display.view data structure for a given change to the
    // document. From and to are in pre-change coordinates. Lendiff is
    // the amount of lines added or subtracted by the change. This is
    // used for changes that span multiple lines, or change the way
    // lines are divided into visual lines. regLineChange (below)
    // registers single-line changes.
    function regChange(cm, from, to, lendiff) {
      if (from == null) { from = cm.doc.first; }
      if (to == null) { to = cm.doc.first + cm.doc.size; }
      if (!lendiff) { lendiff = 0; }

      var display = cm.display;
      if (lendiff && to < display.viewTo &&
          (display.updateLineNumbers == null || display.updateLineNumbers > from))
        { display.updateLineNumbers = from; }

      cm.curOp.viewChanged = true;

      if (from >= display.viewTo) { // Change after
        if (sawCollapsedSpans && visualLineNo(cm.doc, from) < display.viewTo)
          { resetView(cm); }
      } else if (to <= display.viewFrom) { // Change before
        if (sawCollapsedSpans && visualLineEndNo(cm.doc, to + lendiff) > display.viewFrom) {
          resetView(cm);
        } else {
          display.viewFrom += lendiff;
          display.viewTo += lendiff;
        }
      } else if (from <= display.viewFrom && to >= display.viewTo) { // Full overlap
        resetView(cm);
      } else if (from <= display.viewFrom) { // Top overlap
        var cut = viewCuttingPoint(cm, to, to + lendiff, 1);
        if (cut) {
          display.view = display.view.slice(cut.index);
          display.viewFrom = cut.lineN;
          display.viewTo += lendiff;
        } else {
          resetView(cm);
        }
      } else if (to >= display.viewTo) { // Bottom overlap
        var cut$1 = viewCuttingPoint(cm, from, from, -1);
        if (cut$1) {
          display.view = display.view.slice(0, cut$1.index);
          display.viewTo = cut$1.lineN;
        } else {
          resetView(cm);
        }
      } else { // Gap in the middle
        var cutTop = viewCuttingPoint(cm, from, from, -1);
        var cutBot = viewCuttingPoint(cm, to, to + lendiff, 1);
        if (cutTop && cutBot) {
          display.view = display.view.slice(0, cutTop.index)
            .concat(buildViewArray(cm, cutTop.lineN, cutBot.lineN))
            .concat(display.view.slice(cutBot.index));
          display.viewTo += lendiff;
        } else {
          resetView(cm);
        }
      }

      var ext = display.externalMeasured;
      if (ext) {
        if (to < ext.lineN)
          { ext.lineN += lendiff; }
        else if (from < ext.lineN + ext.size)
          { display.externalMeasured = null; }
      }
    }

    // Register a change to a single line. Type must be one of "text",
    // "gutter", "class", "widget"
    function regLineChange(cm, line, type) {
      cm.curOp.viewChanged = true;
      var display = cm.display, ext = cm.display.externalMeasured;
      if (ext && line >= ext.lineN && line < ext.lineN + ext.size)
        { display.externalMeasured = null; }

      if (line < display.viewFrom || line >= display.viewTo) { return }
      var lineView = display.view[findViewIndex(cm, line)];
      if (lineView.node == null) { return }
      var arr = lineView.changes || (lineView.changes = []);
      if (indexOf(arr, type) == -1) { arr.push(type); }
    }

    // Clear the view.
    function resetView(cm) {
      cm.display.viewFrom = cm.display.viewTo = cm.doc.first;
      cm.display.view = [];
      cm.display.viewOffset = 0;
    }

    function viewCuttingPoint(cm, oldN, newN, dir) {
      var index = findViewIndex(cm, oldN), diff, view = cm.display.view;
      if (!sawCollapsedSpans || newN == cm.doc.first + cm.doc.size)
        { return {index: index, lineN: newN} }
      var n = cm.display.viewFrom;
      for (var i = 0; i < index; i++)
        { n += view[i].size; }
      if (n != oldN) {
        if (dir > 0) {
          if (index == view.length - 1) { return null }
          diff = (n + view[index].size) - oldN;
          index++;
        } else {
          diff = n - oldN;
        }
        oldN += diff; newN += diff;
      }
      while (visualLineNo(cm.doc, newN) != newN) {
        if (index == (dir < 0 ? 0 : view.length - 1)) { return null }
        newN += dir * view[index - (dir < 0 ? 1 : 0)].size;
        index += dir;
      }
      return {index: index, lineN: newN}
    }

    // Force the view to cover a given range, adding empty view element
    // or clipping off existing ones as needed.
    function adjustView(cm, from, to) {
      var display = cm.display, view = display.view;
      if (view.length == 0 || from >= display.viewTo || to <= display.viewFrom) {
        display.view = buildViewArray(cm, from, to);
        display.viewFrom = from;
      } else {
        if (display.viewFrom > from)
          { display.view = buildViewArray(cm, from, display.viewFrom).concat(display.view); }
        else if (display.viewFrom < from)
          { display.view = display.view.slice(findViewIndex(cm, from)); }
        display.viewFrom = from;
        if (display.viewTo < to)
          { display.view = display.view.concat(buildViewArray(cm, display.viewTo, to)); }
        else if (display.viewTo > to)
          { display.view = display.view.slice(0, findViewIndex(cm, to)); }
      }
      display.viewTo = to;
    }

    // Count the number of lines in the view whose DOM representation is
    // out of date (or nonexistent).
    function countDirtyView(cm) {
      var view = cm.display.view, dirty = 0;
      for (var i = 0; i < view.length; i++) {
        var lineView = view[i];
        if (!lineView.hidden && (!lineView.node || lineView.changes)) { ++dirty; }
      }
      return dirty
    }

    function updateSelection(cm) {
      cm.display.input.showSelection(cm.display.input.prepareSelection());
    }

    function prepareSelection(cm, primary) {
      if ( primary === void 0 ) { primary = true; }

      var doc = cm.doc, result = {};
      var curFragment = result.cursors = document.createDocumentFragment();
      var selFragment = result.selection = document.createDocumentFragment();

      for (var i = 0; i < doc.sel.ranges.length; i++) {
        if (!primary && i == doc.sel.primIndex) { continue }
        var range = doc.sel.ranges[i];
        if (range.from().line >= cm.display.viewTo || range.to().line < cm.display.viewFrom) { continue }
        var collapsed = range.empty();
        if (collapsed || cm.options.showCursorWhenSelecting)
          { drawSelectionCursor(cm, range.head, curFragment); }
        if (!collapsed)
          { drawSelectionRange(cm, range, selFragment); }
      }
      return result
    }

    // Draws a cursor for the given range
    function drawSelectionCursor(cm, head, output) {
      var pos = cursorCoords(cm, head, "div", null, null, !cm.options.singleCursorHeightPerLine);

      var cursor = output.appendChild(elt("div", "\u00a0", "CodeMirror-cursor"));
      cursor.style.left = pos.left + "px";
      cursor.style.top = pos.top + "px";
      cursor.style.height = Math.max(0, pos.bottom - pos.top) * cm.options.cursorHeight + "px";

      if (pos.other) {
        // Secondary cursor, shown when on a 'jump' in bi-directional text
        var otherCursor = output.appendChild(elt("div", "\u00a0", "CodeMirror-cursor CodeMirror-secondarycursor"));
        otherCursor.style.display = "";
        otherCursor.style.left = pos.other.left + "px";
        otherCursor.style.top = pos.other.top + "px";
        otherCursor.style.height = (pos.other.bottom - pos.other.top) * .85 + "px";
      }
    }

    function cmpCoords(a, b) { return a.top - b.top || a.left - b.left }

    // Draws the given range as a highlighted selection
    function drawSelectionRange(cm, range, output) {
      var display = cm.display, doc = cm.doc;
      var fragment = document.createDocumentFragment();
      var padding = paddingH(cm.display), leftSide = padding.left;
      var rightSide = Math.max(display.sizerWidth, displayWidth(cm) - display.sizer.offsetLeft) - padding.right;
      var docLTR = doc.direction == "ltr";

      function add(left, top, width, bottom) {
        if (top < 0) { top = 0; }
        top = Math.round(top);
        bottom = Math.round(bottom);
        fragment.appendChild(elt("div", null, "CodeMirror-selected", ("position: absolute; left: " + left + "px;\n                             top: " + top + "px; width: " + (width == null ? rightSide - left : width) + "px;\n                             height: " + (bottom - top) + "px")));
      }

      function drawForLine(line, fromArg, toArg) {
        var lineObj = getLine(doc, line);
        var lineLen = lineObj.text.length;
        var start, end;
        function coords(ch, bias) {
          return charCoords(cm, Pos(line, ch), "div", lineObj, bias)
        }

        function wrapX(pos, dir, side) {
          var extent = wrappedLineExtentChar(cm, lineObj, null, pos);
          var prop = (dir == "ltr") == (side == "after") ? "left" : "right";
          var ch = side == "after" ? extent.begin : extent.end - (/\s/.test(lineObj.text.charAt(extent.end - 1)) ? 2 : 1);
          return coords(ch, prop)[prop]
        }

        var order = getOrder(lineObj, doc.direction);
        iterateBidiSections(order, fromArg || 0, toArg == null ? lineLen : toArg, function (from, to, dir, i) {
          var ltr = dir == "ltr";
          var fromPos = coords(from, ltr ? "left" : "right");
          var toPos = coords(to - 1, ltr ? "right" : "left");

          var openStart = fromArg == null && from == 0, openEnd = toArg == null && to == lineLen;
          var first = i == 0, last = !order || i == order.length - 1;
          if (toPos.top - fromPos.top <= 3) { // Single line
            var openLeft = (docLTR ? openStart : openEnd) && first;
            var openRight = (docLTR ? openEnd : openStart) && last;
            var left = openLeft ? leftSide : (ltr ? fromPos : toPos).left;
            var right = openRight ? rightSide : (ltr ? toPos : fromPos).right;
            add(left, fromPos.top, right - left, fromPos.bottom);
          } else { // Multiple lines
            var topLeft, topRight, botLeft, botRight;
            if (ltr) {
              topLeft = docLTR && openStart && first ? leftSide : fromPos.left;
              topRight = docLTR ? rightSide : wrapX(from, dir, "before");
              botLeft = docLTR ? leftSide : wrapX(to, dir, "after");
              botRight = docLTR && openEnd && last ? rightSide : toPos.right;
            } else {
              topLeft = !docLTR ? leftSide : wrapX(from, dir, "before");
              topRight = !docLTR && openStart && first ? rightSide : fromPos.right;
              botLeft = !docLTR && openEnd && last ? leftSide : toPos.left;
              botRight = !docLTR ? rightSide : wrapX(to, dir, "after");
            }
            add(topLeft, fromPos.top, topRight - topLeft, fromPos.bottom);
            if (fromPos.bottom < toPos.top) { add(leftSide, fromPos.bottom, null, toPos.top); }
            add(botLeft, toPos.top, botRight - botLeft, toPos.bottom);
          }

          if (!start || cmpCoords(fromPos, start) < 0) { start = fromPos; }
          if (cmpCoords(toPos, start) < 0) { start = toPos; }
          if (!end || cmpCoords(fromPos, end) < 0) { end = fromPos; }
          if (cmpCoords(toPos, end) < 0) { end = toPos; }
        });
        return {start: start, end: end}
      }

      var sFrom = range.from(), sTo = range.to();
      if (sFrom.line == sTo.line) {
        drawForLine(sFrom.line, sFrom.ch, sTo.ch);
      } else {
        var fromLine = getLine(doc, sFrom.line), toLine = getLine(doc, sTo.line);
        var singleVLine = visualLine(fromLine) == visualLine(toLine);
        var leftEnd = drawForLine(sFrom.line, sFrom.ch, singleVLine ? fromLine.text.length + 1 : null).end;
        var rightStart = drawForLine(sTo.line, singleVLine ? 0 : null, sTo.ch).start;
        if (singleVLine) {
          if (leftEnd.top < rightStart.top - 2) {
            add(leftEnd.right, leftEnd.top, null, leftEnd.bottom);
            add(leftSide, rightStart.top, rightStart.left, rightStart.bottom);
          } else {
            add(leftEnd.right, leftEnd.top, rightStart.left - leftEnd.right, leftEnd.bottom);
          }
        }
        if (leftEnd.bottom < rightStart.top)
          { add(leftSide, leftEnd.bottom, null, rightStart.top); }
      }

      output.appendChild(fragment);
    }

    // Cursor-blinking
    function restartBlink(cm) {
      if (!cm.state.focused) { return }
      var display = cm.display;
      clearInterval(display.blinker);
      var on = true;
      display.cursorDiv.style.visibility = "";
      if (cm.options.cursorBlinkRate > 0)
        { display.blinker = setInterval(function () {
          if (!cm.hasFocus()) { onBlur(cm); }
          display.cursorDiv.style.visibility = (on = !on) ? "" : "hidden";
        }, cm.options.cursorBlinkRate); }
      else if (cm.options.cursorBlinkRate < 0)
        { display.cursorDiv.style.visibility = "hidden"; }
    }

    function ensureFocus(cm) {
      if (!cm.hasFocus()) {
        cm.display.input.focus();
        if (!cm.state.focused) { onFocus(cm); }
      }
    }

    function delayBlurEvent(cm) {
      cm.state.delayingBlurEvent = true;
      setTimeout(function () { if (cm.state.delayingBlurEvent) {
        cm.state.delayingBlurEvent = false;
        if (cm.state.focused) { onBlur(cm); }
      } }, 100);
    }

    function onFocus(cm, e) {
      if (cm.state.delayingBlurEvent && !cm.state.draggingText) { cm.state.delayingBlurEvent = false; }

      if (cm.options.readOnly == "nocursor") { return }
      if (!cm.state.focused) {
        signal(cm, "focus", cm, e);
        cm.state.focused = true;
        addClass(cm.display.wrapper, "CodeMirror-focused");
        // This test prevents this from firing when a context
        // menu is closed (since the input reset would kill the
        // select-all detection hack)
        if (!cm.curOp && cm.display.selForContextMenu != cm.doc.sel) {
          cm.display.input.reset();
          if (webkit) { setTimeout(function () { return cm.display.input.reset(true); }, 20); } // Issue #1730
        }
        cm.display.input.receivedFocus();
      }
      restartBlink(cm);
    }
    function onBlur(cm, e) {
      if (cm.state.delayingBlurEvent) { return }

      if (cm.state.focused) {
        signal(cm, "blur", cm, e);
        cm.state.focused = false;
        rmClass(cm.display.wrapper, "CodeMirror-focused");
      }
      clearInterval(cm.display.blinker);
      setTimeout(function () { if (!cm.state.focused) { cm.display.shift = false; } }, 150);
    }

    // Read the actual heights of the rendered lines, and update their
    // stored heights to match.
    function updateHeightsInViewport(cm) {
      var display = cm.display;
      var prevBottom = display.lineDiv.offsetTop;
      for (var i = 0; i < display.view.length; i++) {
        var cur = display.view[i], wrapping = cm.options.lineWrapping;
        var height = (void 0), width = 0;
        if (cur.hidden) { continue }
        if (ie && ie_version < 8) {
          var bot = cur.node.offsetTop + cur.node.offsetHeight;
          height = bot - prevBottom;
          prevBottom = bot;
        } else {
          var box = cur.node.getBoundingClientRect();
          height = box.bottom - box.top;
          // Check that lines don't extend past the right of the current
          // editor width
          if (!wrapping && cur.text.firstChild)
            { width = cur.text.firstChild.getBoundingClientRect().right - box.left - 1; }
        }
        var diff = cur.line.height - height;
        if (diff > .005 || diff < -.005) {
          updateLineHeight(cur.line, height);
          updateWidgetHeight(cur.line);
          if (cur.rest) { for (var j = 0; j < cur.rest.length; j++)
            { updateWidgetHeight(cur.rest[j]); } }
        }
        if (width > cm.display.sizerWidth) {
          var chWidth = Math.ceil(width / charWidth(cm.display));
          if (chWidth > cm.display.maxLineLength) {
            cm.display.maxLineLength = chWidth;
            cm.display.maxLine = cur.line;
            cm.display.maxLineChanged = true;
          }
        }
      }
    }

    // Read and store the height of line widgets associated with the
    // given line.
    function updateWidgetHeight(line) {
      if (line.widgets) { for (var i = 0; i < line.widgets.length; ++i) {
        var w = line.widgets[i], parent = w.node.parentNode;
        if (parent) { w.height = parent.offsetHeight; }
      } }
    }

    // Compute the lines that are visible in a given viewport (defaults
    // the the current scroll position). viewport may contain top,
    // height, and ensure (see op.scrollToPos) properties.
    function visibleLines(display, doc, viewport) {
      var top = viewport && viewport.top != null ? Math.max(0, viewport.top) : display.scroller.scrollTop;
      top = Math.floor(top - paddingTop(display));
      var bottom = viewport && viewport.bottom != null ? viewport.bottom : top + display.wrapper.clientHeight;

      var from = lineAtHeight(doc, top), to = lineAtHeight(doc, bottom);
      // Ensure is a {from: {line, ch}, to: {line, ch}} object, and
      // forces those lines into the viewport (if possible).
      if (viewport && viewport.ensure) {
        var ensureFrom = viewport.ensure.from.line, ensureTo = viewport.ensure.to.line;
        if (ensureFrom < from) {
          from = ensureFrom;
          to = lineAtHeight(doc, heightAtLine(getLine(doc, ensureFrom)) + display.wrapper.clientHeight);
        } else if (Math.min(ensureTo, doc.lastLine()) >= to) {
          from = lineAtHeight(doc, heightAtLine(getLine(doc, ensureTo)) - display.wrapper.clientHeight);
          to = ensureTo;
        }
      }
      return {from: from, to: Math.max(to, from + 1)}
    }

    // SCROLLING THINGS INTO VIEW

    // If an editor sits on the top or bottom of the window, partially
    // scrolled out of view, this ensures that the cursor is visible.
    function maybeScrollWindow(cm, rect) {
      if (signalDOMEvent(cm, "scrollCursorIntoView")) { return }

      var display = cm.display, box = display.sizer.getBoundingClientRect(), doScroll = null;
      if (rect.top + box.top < 0) { doScroll = true; }
      else if (rect.bottom + box.top > (window.innerHeight || document.documentElement.clientHeight)) { doScroll = false; }
      if (doScroll != null && !phantom) {
        var scrollNode = elt("div", "\u200b", null, ("position: absolute;\n                         top: " + (rect.top - display.viewOffset - paddingTop(cm.display)) + "px;\n                         height: " + (rect.bottom - rect.top + scrollGap(cm) + display.barHeight) + "px;\n                         left: " + (rect.left) + "px; width: " + (Math.max(2, rect.right - rect.left)) + "px;"));
        cm.display.lineSpace.appendChild(scrollNode);
        scrollNode.scrollIntoView(doScroll);
        cm.display.lineSpace.removeChild(scrollNode);
      }
    }

    // Scroll a given position into view (immediately), verifying that
    // it actually became visible (as line heights are accurately
    // measured, the position of something may 'drift' during drawing).
    function scrollPosIntoView(cm, pos, end, margin) {
      if (margin == null) { margin = 0; }
      var rect;
      if (!cm.options.lineWrapping && pos == end) {
        // Set pos and end to the cursor positions around the character pos sticks to
        // If pos.sticky == "before", that is around pos.ch - 1, otherwise around pos.ch
        // If pos == Pos(_, 0, "before"), pos and end are unchanged
        pos = pos.ch ? Pos(pos.line, pos.sticky == "before" ? pos.ch - 1 : pos.ch, "after") : pos;
        end = pos.sticky == "before" ? Pos(pos.line, pos.ch + 1, "before") : pos;
      }
      for (var limit = 0; limit < 5; limit++) {
        var changed = false;
        var coords = cursorCoords(cm, pos);
        var endCoords = !end || end == pos ? coords : cursorCoords(cm, end);
        rect = {left: Math.min(coords.left, endCoords.left),
                top: Math.min(coords.top, endCoords.top) - margin,
                right: Math.max(coords.left, endCoords.left),
                bottom: Math.max(coords.bottom, endCoords.bottom) + margin};
        var scrollPos = calculateScrollPos(cm, rect);
        var startTop = cm.doc.scrollTop, startLeft = cm.doc.scrollLeft;
        if (scrollPos.scrollTop != null) {
          updateScrollTop(cm, scrollPos.scrollTop);
          if (Math.abs(cm.doc.scrollTop - startTop) > 1) { changed = true; }
        }
        if (scrollPos.scrollLeft != null) {
          setScrollLeft(cm, scrollPos.scrollLeft);
          if (Math.abs(cm.doc.scrollLeft - startLeft) > 1) { changed = true; }
        }
        if (!changed) { break }
      }
      return rect
    }

    // Scroll a given set of coordinates into view (immediately).
    function scrollIntoView(cm, rect) {
      var scrollPos = calculateScrollPos(cm, rect);
      if (scrollPos.scrollTop != null) { updateScrollTop(cm, scrollPos.scrollTop); }
      if (scrollPos.scrollLeft != null) { setScrollLeft(cm, scrollPos.scrollLeft); }
    }

    // Calculate a new scroll position needed to scroll the given
    // rectangle into view. Returns an object with scrollTop and
    // scrollLeft properties. When these are undefined, the
    // vertical/horizontal position does not need to be adjusted.
    function calculateScrollPos(cm, rect) {
      var display = cm.display, snapMargin = textHeight(cm.display);
      if (rect.top < 0) { rect.top = 0; }
      var screentop = cm.curOp && cm.curOp.scrollTop != null ? cm.curOp.scrollTop : display.scroller.scrollTop;
      var screen = displayHeight(cm), result = {};
      if (rect.bottom - rect.top > screen) { rect.bottom = rect.top + screen; }
      var docBottom = cm.doc.height + paddingVert(display);
      var atTop = rect.top < snapMargin, atBottom = rect.bottom > docBottom - snapMargin;
      if (rect.top < screentop) {
        result.scrollTop = atTop ? 0 : rect.top;
      } else if (rect.bottom > screentop + screen) {
        var newTop = Math.min(rect.top, (atBottom ? docBottom : rect.bottom) - screen);
        if (newTop != screentop) { result.scrollTop = newTop; }
      }

      var gutterSpace = cm.options.fixedGutter ? 0 : display.gutters.offsetWidth;
      var screenleft = cm.curOp && cm.curOp.scrollLeft != null ? cm.curOp.scrollLeft : display.scroller.scrollLeft - gutterSpace;
      var screenw = displayWidth(cm) - display.gutters.offsetWidth;
      var tooWide = rect.right - rect.left > screenw;
      if (tooWide) { rect.right = rect.left + screenw; }
      if (rect.left < 10)
        { result.scrollLeft = 0; }
      else if (rect.left < screenleft)
        { result.scrollLeft = Math.max(0, rect.left + gutterSpace - (tooWide ? 0 : 10)); }
      else if (rect.right > screenw + screenleft - 3)
        { result.scrollLeft = rect.right + (tooWide ? 0 : 10) - screenw; }
      return result
    }

    // Store a relative adjustment to the scroll position in the current
    // operation (to be applied when the operation finishes).
    function addToScrollTop(cm, top) {
      if (top == null) { return }
      resolveScrollToPos(cm);
      cm.curOp.scrollTop = (cm.curOp.scrollTop == null ? cm.doc.scrollTop : cm.curOp.scrollTop) + top;
    }

    // Make sure that at the end of the operation the current cursor is
    // shown.
    function ensureCursorVisible(cm) {
      resolveScrollToPos(cm);
      var cur = cm.getCursor();
      cm.curOp.scrollToPos = {from: cur, to: cur, margin: cm.options.cursorScrollMargin};
    }

    function scrollToCoords(cm, x, y) {
      if (x != null || y != null) { resolveScrollToPos(cm); }
      if (x != null) { cm.curOp.scrollLeft = x; }
      if (y != null) { cm.curOp.scrollTop = y; }
    }

    function scrollToRange(cm, range) {
      resolveScrollToPos(cm);
      cm.curOp.scrollToPos = range;
    }

    // When an operation has its scrollToPos property set, and another
    // scroll action is applied before the end of the operation, this
    // 'simulates' scrolling that position into view in a cheap way, so
    // that the effect of intermediate scroll commands is not ignored.
    function resolveScrollToPos(cm) {
      var range = cm.curOp.scrollToPos;
      if (range) {
        cm.curOp.scrollToPos = null;
        var from = estimateCoords(cm, range.from), to = estimateCoords(cm, range.to);
        scrollToCoordsRange(cm, from, to, range.margin);
      }
    }

    function scrollToCoordsRange(cm, from, to, margin) {
      var sPos = calculateScrollPos(cm, {
        left: Math.min(from.left, to.left),
        top: Math.min(from.top, to.top) - margin,
        right: Math.max(from.right, to.right),
        bottom: Math.max(from.bottom, to.bottom) + margin
      });
      scrollToCoords(cm, sPos.scrollLeft, sPos.scrollTop);
    }

    // Sync the scrollable area and scrollbars, ensure the viewport
    // covers the visible area.
    function updateScrollTop(cm, val) {
      if (Math.abs(cm.doc.scrollTop - val) < 2) { return }
      if (!gecko) { updateDisplaySimple(cm, {top: val}); }
      setScrollTop(cm, val, true);
      if (gecko) { updateDisplaySimple(cm); }
      startWorker(cm, 100);
    }

    function setScrollTop(cm, val, forceScroll) {
      val = Math.max(0, Math.min(cm.display.scroller.scrollHeight - cm.display.scroller.clientHeight, val));
      if (cm.display.scroller.scrollTop == val && !forceScroll) { return }
      cm.doc.scrollTop = val;
      cm.display.scrollbars.setScrollTop(val);
      if (cm.display.scroller.scrollTop != val) { cm.display.scroller.scrollTop = val; }
    }

    // Sync scroller and scrollbar, ensure the gutter elements are
    // aligned.
    function setScrollLeft(cm, val, isScroller, forceScroll) {
      val = Math.max(0, Math.min(val, cm.display.scroller.scrollWidth - cm.display.scroller.clientWidth));
      if ((isScroller ? val == cm.doc.scrollLeft : Math.abs(cm.doc.scrollLeft - val) < 2) && !forceScroll) { return }
      cm.doc.scrollLeft = val;
      alignHorizontally(cm);
      if (cm.display.scroller.scrollLeft != val) { cm.display.scroller.scrollLeft = val; }
      cm.display.scrollbars.setScrollLeft(val);
    }

    // SCROLLBARS

    // Prepare DOM reads needed to update the scrollbars. Done in one
    // shot to minimize update/measure roundtrips.
    function measureForScrollbars(cm) {
      var d = cm.display, gutterW = d.gutters.offsetWidth;
      var docH = Math.round(cm.doc.height + paddingVert(cm.display));
      return {
        clientHeight: d.scroller.clientHeight,
        viewHeight: d.wrapper.clientHeight,
        scrollWidth: d.scroller.scrollWidth, clientWidth: d.scroller.clientWidth,
        viewWidth: d.wrapper.clientWidth,
        barLeft: cm.options.fixedGutter ? gutterW : 0,
        docHeight: docH,
        scrollHeight: docH + scrollGap(cm) + d.barHeight,
        nativeBarWidth: d.nativeBarWidth,
        gutterWidth: gutterW
      }
    }

    var NativeScrollbars = function(place, scroll, cm) {
      this.cm = cm;
      var vert = this.vert = elt("div", [elt("div", null, null, "min-width: 1px")], "CodeMirror-vscrollbar");
      var horiz = this.horiz = elt("div", [elt("div", null, null, "height: 100%; min-height: 1px")], "CodeMirror-hscrollbar");
      vert.tabIndex = horiz.tabIndex = -1;
      place(vert); place(horiz);

      on(vert, "scroll", function () {
        if (vert.clientHeight) { scroll(vert.scrollTop, "vertical"); }
      });
      on(horiz, "scroll", function () {
        if (horiz.clientWidth) { scroll(horiz.scrollLeft, "horizontal"); }
      });

      this.checkedZeroWidth = false;
      // Need to set a minimum width to see the scrollbar on IE7 (but must not set it on IE8).
      if (ie && ie_version < 8) { this.horiz.style.minHeight = this.vert.style.minWidth = "18px"; }
    };

    NativeScrollbars.prototype.update = function (measure) {
      var needsH = measure.scrollWidth > measure.clientWidth + 1;
      var needsV = measure.scrollHeight > measure.clientHeight + 1;
      var sWidth = measure.nativeBarWidth;

      if (needsV) {
        this.vert.style.display = "block";
        this.vert.style.bottom = needsH ? sWidth + "px" : "0";
        var totalHeight = measure.viewHeight - (needsH ? sWidth : 0);
        // A bug in IE8 can cause this value to be negative, so guard it.
        this.vert.firstChild.style.height =
          Math.max(0, measure.scrollHeight - measure.clientHeight + totalHeight) + "px";
      } else {
        this.vert.style.display = "";
        this.vert.firstChild.style.height = "0";
      }

      if (needsH) {
        this.horiz.style.display = "block";
        this.horiz.style.right = needsV ? sWidth + "px" : "0";
        this.horiz.style.left = measure.barLeft + "px";
        var totalWidth = measure.viewWidth - measure.barLeft - (needsV ? sWidth : 0);
        this.horiz.firstChild.style.width =
          Math.max(0, measure.scrollWidth - measure.clientWidth + totalWidth) + "px";
      } else {
        this.horiz.style.display = "";
        this.horiz.firstChild.style.width = "0";
      }

      if (!this.checkedZeroWidth && measure.clientHeight > 0) {
        if (sWidth == 0) { this.zeroWidthHack(); }
        this.checkedZeroWidth = true;
      }

      return {right: needsV ? sWidth : 0, bottom: needsH ? sWidth : 0}
    };

    NativeScrollbars.prototype.setScrollLeft = function (pos) {
      if (this.horiz.scrollLeft != pos) { this.horiz.scrollLeft = pos; }
      if (this.disableHoriz) { this.enableZeroWidthBar(this.horiz, this.disableHoriz, "horiz"); }
    };

    NativeScrollbars.prototype.setScrollTop = function (pos) {
      if (this.vert.scrollTop != pos) { this.vert.scrollTop = pos; }
      if (this.disableVert) { this.enableZeroWidthBar(this.vert, this.disableVert, "vert"); }
    };

    NativeScrollbars.prototype.zeroWidthHack = function () {
      var w = mac && !mac_geMountainLion ? "12px" : "18px";
      this.horiz.style.height = this.vert.style.width = w;
      this.horiz.style.pointerEvents = this.vert.style.pointerEvents = "none";
      this.disableHoriz = new Delayed;
      this.disableVert = new Delayed;
    };

    NativeScrollbars.prototype.enableZeroWidthBar = function (bar, delay, type) {
      bar.style.pointerEvents = "auto";
      function maybeDisable() {
        // To find out whether the scrollbar is still visible, we
        // check whether the element under the pixel in the bottom
        // right corner of the scrollbar box is the scrollbar box
        // itself (when the bar is still visible) or its filler child
        // (when the bar is hidden). If it is still visible, we keep
        // it enabled, if it's hidden, we disable pointer events.
        var box = bar.getBoundingClientRect();
        var elt = type == "vert" ? document.elementFromPoint(box.right - 1, (box.top + box.bottom) / 2)
            : document.elementFromPoint((box.right + box.left) / 2, box.bottom - 1);
        if (elt != bar) { bar.style.pointerEvents = "none"; }
        else { delay.set(1000, maybeDisable); }
      }
      delay.set(1000, maybeDisable);
    };

    NativeScrollbars.prototype.clear = function () {
      var parent = this.horiz.parentNode;
      parent.removeChild(this.horiz);
      parent.removeChild(this.vert);
    };

    var NullScrollbars = function () {};

    NullScrollbars.prototype.update = function () { return {bottom: 0, right: 0} };
    NullScrollbars.prototype.setScrollLeft = function () {};
    NullScrollbars.prototype.setScrollTop = function () {};
    NullScrollbars.prototype.clear = function () {};

    function updateScrollbars(cm, measure) {
      if (!measure) { measure = measureForScrollbars(cm); }
      var startWidth = cm.display.barWidth, startHeight = cm.display.barHeight;
      updateScrollbarsInner(cm, measure);
      for (var i = 0; i < 4 && startWidth != cm.display.barWidth || startHeight != cm.display.barHeight; i++) {
        if (startWidth != cm.display.barWidth && cm.options.lineWrapping)
          { updateHeightsInViewport(cm); }
        updateScrollbarsInner(cm, measureForScrollbars(cm));
        startWidth = cm.display.barWidth; startHeight = cm.display.barHeight;
      }
    }

    // Re-synchronize the fake scrollbars with the actual size of the
    // content.
    function updateScrollbarsInner(cm, measure) {
      var d = cm.display;
      var sizes = d.scrollbars.update(measure);

      d.sizer.style.paddingRight = (d.barWidth = sizes.right) + "px";
      d.sizer.style.paddingBottom = (d.barHeight = sizes.bottom) + "px";
      d.heightForcer.style.borderBottom = sizes.bottom + "px solid transparent";

      if (sizes.right && sizes.bottom) {
        d.scrollbarFiller.style.display = "block";
        d.scrollbarFiller.style.height = sizes.bottom + "px";
        d.scrollbarFiller.style.width = sizes.right + "px";
      } else { d.scrollbarFiller.style.display = ""; }
      if (sizes.bottom && cm.options.coverGutterNextToScrollbar && cm.options.fixedGutter) {
        d.gutterFiller.style.display = "block";
        d.gutterFiller.style.height = sizes.bottom + "px";
        d.gutterFiller.style.width = measure.gutterWidth + "px";
      } else { d.gutterFiller.style.display = ""; }
    }

    var scrollbarModel = {"native": NativeScrollbars, "null": NullScrollbars};

    function initScrollbars(cm) {
      if (cm.display.scrollbars) {
        cm.display.scrollbars.clear();
        if (cm.display.scrollbars.addClass)
          { rmClass(cm.display.wrapper, cm.display.scrollbars.addClass); }
      }

      cm.display.scrollbars = new scrollbarModel[cm.options.scrollbarStyle](function (node) {
        cm.display.wrapper.insertBefore(node, cm.display.scrollbarFiller);
        // Prevent clicks in the scrollbars from killing focus
        on(node, "mousedown", function () {
          if (cm.state.focused) { setTimeout(function () { return cm.display.input.focus(); }, 0); }
        });
        node.setAttribute("cm-not-content", "true");
      }, function (pos, axis) {
        if (axis == "horizontal") { setScrollLeft(cm, pos); }
        else { updateScrollTop(cm, pos); }
      }, cm);
      if (cm.display.scrollbars.addClass)
        { addClass(cm.display.wrapper, cm.display.scrollbars.addClass); }
    }

    // Operations are used to wrap a series of changes to the editor
    // state in such a way that each change won't have to update the
    // cursor and display (which would be awkward, slow, and
    // error-prone). Instead, display updates are batched and then all
    // combined and executed at once.

    var nextOpId = 0;
    // Start a new operation.
    function startOperation(cm) {
      cm.curOp = {
        cm: cm,
        viewChanged: false,      // Flag that indicates that lines might need to be redrawn
        startHeight: cm.doc.height, // Used to detect need to update scrollbar
        forceUpdate: false,      // Used to force a redraw
        updateInput: 0,       // Whether to reset the input textarea
        typing: false,           // Whether this reset should be careful to leave existing text (for compositing)
        changeObjs: null,        // Accumulated changes, for firing change events
        cursorActivityHandlers: null, // Set of handlers to fire cursorActivity on
        cursorActivityCalled: 0, // Tracks which cursorActivity handlers have been called already
        selectionChanged: false, // Whether the selection needs to be redrawn
        updateMaxLine: false,    // Set when the widest line needs to be determined anew
        scrollLeft: null, scrollTop: null, // Intermediate scroll position, not pushed to DOM yet
        scrollToPos: null,       // Used to scroll to a specific position
        focus: false,
        id: ++nextOpId           // Unique ID
      };
      pushOperation(cm.curOp);
    }

    // Finish an operation, updating the display and signalling delayed events
    function endOperation(cm) {
      var op = cm.curOp;
      if (op) { finishOperation(op, function (group) {
        for (var i = 0; i < group.ops.length; i++)
          { group.ops[i].cm.curOp = null; }
        endOperations(group);
      }); }
    }

    // The DOM updates done when an operation finishes are batched so
    // that the minimum number of relayouts are required.
    function endOperations(group) {
      var ops = group.ops;
      for (var i = 0; i < ops.length; i++) // Read DOM
        { endOperation_R1(ops[i]); }
      for (var i$1 = 0; i$1 < ops.length; i$1++) // Write DOM (maybe)
        { endOperation_W1(ops[i$1]); }
      for (var i$2 = 0; i$2 < ops.length; i$2++) // Read DOM
        { endOperation_R2(ops[i$2]); }
      for (var i$3 = 0; i$3 < ops.length; i$3++) // Write DOM (maybe)
        { endOperation_W2(ops[i$3]); }
      for (var i$4 = 0; i$4 < ops.length; i$4++) // Read DOM
        { endOperation_finish(ops[i$4]); }
    }

    function endOperation_R1(op) {
      var cm = op.cm, display = cm.display;
      maybeClipScrollbars(cm);
      if (op.updateMaxLine) { findMaxLine(cm); }

      op.mustUpdate = op.viewChanged || op.forceUpdate || op.scrollTop != null ||
        op.scrollToPos && (op.scrollToPos.from.line < display.viewFrom ||
                           op.scrollToPos.to.line >= display.viewTo) ||
        display.maxLineChanged && cm.options.lineWrapping;
      op.update = op.mustUpdate &&
        new DisplayUpdate(cm, op.mustUpdate && {top: op.scrollTop, ensure: op.scrollToPos}, op.forceUpdate);
    }

    function endOperation_W1(op) {
      op.updatedDisplay = op.mustUpdate && updateDisplayIfNeeded(op.cm, op.update);
    }

    function endOperation_R2(op) {
      var cm = op.cm, display = cm.display;
      if (op.updatedDisplay) { updateHeightsInViewport(cm); }

      op.barMeasure = measureForScrollbars(cm);

      // If the max line changed since it was last measured, measure it,
      // and ensure the document's width matches it.
      // updateDisplay_W2 will use these properties to do the actual resizing
      if (display.maxLineChanged && !cm.options.lineWrapping) {
        op.adjustWidthTo = measureChar(cm, display.maxLine, display.maxLine.text.length).left + 3;
        cm.display.sizerWidth = op.adjustWidthTo;
        op.barMeasure.scrollWidth =
          Math.max(display.scroller.clientWidth, display.sizer.offsetLeft + op.adjustWidthTo + scrollGap(cm) + cm.display.barWidth);
        op.maxScrollLeft = Math.max(0, display.sizer.offsetLeft + op.adjustWidthTo - displayWidth(cm));
      }

      if (op.updatedDisplay || op.selectionChanged)
        { op.preparedSelection = display.input.prepareSelection(); }
    }

    function endOperation_W2(op) {
      var cm = op.cm;

      if (op.adjustWidthTo != null) {
        cm.display.sizer.style.minWidth = op.adjustWidthTo + "px";
        if (op.maxScrollLeft < cm.doc.scrollLeft)
          { setScrollLeft(cm, Math.min(cm.display.scroller.scrollLeft, op.maxScrollLeft), true); }
        cm.display.maxLineChanged = false;
      }

      var takeFocus = op.focus && op.focus == activeElt();
      if (op.preparedSelection)
        { cm.display.input.showSelection(op.preparedSelection, takeFocus); }
      if (op.updatedDisplay || op.startHeight != cm.doc.height)
        { updateScrollbars(cm, op.barMeasure); }
      if (op.updatedDisplay)
        { setDocumentHeight(cm, op.barMeasure); }

      if (op.selectionChanged) { restartBlink(cm); }

      if (cm.state.focused && op.updateInput)
        { cm.display.input.reset(op.typing); }
      if (takeFocus) { ensureFocus(op.cm); }
    }

    function endOperation_finish(op) {
      var cm = op.cm, display = cm.display, doc = cm.doc;

      if (op.updatedDisplay) { postUpdateDisplay(cm, op.update); }

      // Abort mouse wheel delta measurement, when scrolling explicitly
      if (display.wheelStartX != null && (op.scrollTop != null || op.scrollLeft != null || op.scrollToPos))
        { display.wheelStartX = display.wheelStartY = null; }

      // Propagate the scroll position to the actual DOM scroller
      if (op.scrollTop != null) { setScrollTop(cm, op.scrollTop, op.forceScroll); }

      if (op.scrollLeft != null) { setScrollLeft(cm, op.scrollLeft, true, true); }
      // If we need to scroll a specific position into view, do so.
      if (op.scrollToPos) {
        var rect = scrollPosIntoView(cm, clipPos(doc, op.scrollToPos.from),
                                     clipPos(doc, op.scrollToPos.to), op.scrollToPos.margin);
        maybeScrollWindow(cm, rect);
      }

      // Fire events for markers that are hidden/unidden by editing or
      // undoing
      var hidden = op.maybeHiddenMarkers, unhidden = op.maybeUnhiddenMarkers;
      if (hidden) { for (var i = 0; i < hidden.length; ++i)
        { if (!hidden[i].lines.length) { signal(hidden[i], "hide"); } } }
      if (unhidden) { for (var i$1 = 0; i$1 < unhidden.length; ++i$1)
        { if (unhidden[i$1].lines.length) { signal(unhidden[i$1], "unhide"); } } }

      if (display.wrapper.offsetHeight)
        { doc.scrollTop = cm.display.scroller.scrollTop; }

      // Fire change events, and delayed event handlers
      if (op.changeObjs)
        { signal(cm, "changes", cm, op.changeObjs); }
      if (op.update)
        { op.update.finish(); }
    }

    // Run the given function in an operation
    function runInOp(cm, f) {
      if (cm.curOp) { return f() }
      startOperation(cm);
      try { return f() }
      finally { endOperation(cm); }
    }
    // Wraps a function in an operation. Returns the wrapped function.
    function operation(cm, f) {
      return function() {
        if (cm.curOp) { return f.apply(cm, arguments) }
        startOperation(cm);
        try { return f.apply(cm, arguments) }
        finally { endOperation(cm); }
      }
    }
    // Used to add methods to editor and doc instances, wrapping them in
    // operations.
    function methodOp(f) {
      return function() {
        if (this.curOp) { return f.apply(this, arguments) }
        startOperation(this);
        try { return f.apply(this, arguments) }
        finally { endOperation(this); }
      }
    }
    function docMethodOp(f) {
      return function() {
        var cm = this.cm;
        if (!cm || cm.curOp) { return f.apply(this, arguments) }
        startOperation(cm);
        try { return f.apply(this, arguments) }
        finally { endOperation(cm); }
      }
    }

    // HIGHLIGHT WORKER

    function startWorker(cm, time) {
      if (cm.doc.highlightFrontier < cm.display.viewTo)
        { cm.state.highlight.set(time, bind(highlightWorker, cm)); }
    }

    function highlightWorker(cm) {
      var doc = cm.doc;
      if (doc.highlightFrontier >= cm.display.viewTo) { return }
      var end = +new Date + cm.options.workTime;
      var context = getContextBefore(cm, doc.highlightFrontier);
      var changedLines = [];

      doc.iter(context.line, Math.min(doc.first + doc.size, cm.display.viewTo + 500), function (line) {
        if (context.line >= cm.display.viewFrom) { // Visible
          var oldStyles = line.styles;
          var resetState = line.text.length > cm.options.maxHighlightLength ? copyState(doc.mode, context.state) : null;
          var highlighted = highlightLine(cm, line, context, true);
          if (resetState) { context.state = resetState; }
          line.styles = highlighted.styles;
          var oldCls = line.styleClasses, newCls = highlighted.classes;
          if (newCls) { line.styleClasses = newCls; }
          else if (oldCls) { line.styleClasses = null; }
          var ischange = !oldStyles || oldStyles.length != line.styles.length ||
            oldCls != newCls && (!oldCls || !newCls || oldCls.bgClass != newCls.bgClass || oldCls.textClass != newCls.textClass);
          for (var i = 0; !ischange && i < oldStyles.length; ++i) { ischange = oldStyles[i] != line.styles[i]; }
          if (ischange) { changedLines.push(context.line); }
          line.stateAfter = context.save();
          context.nextLine();
        } else {
          if (line.text.length <= cm.options.maxHighlightLength)
            { processLine(cm, line.text, context); }
          line.stateAfter = context.line % 5 == 0 ? context.save() : null;
          context.nextLine();
        }
        if (+new Date > end) {
          startWorker(cm, cm.options.workDelay);
          return true
        }
      });
      doc.highlightFrontier = context.line;
      doc.modeFrontier = Math.max(doc.modeFrontier, context.line);
      if (changedLines.length) { runInOp(cm, function () {
        for (var i = 0; i < changedLines.length; i++)
          { regLineChange(cm, changedLines[i], "text"); }
      }); }
    }

    // DISPLAY DRAWING

    var DisplayUpdate = function(cm, viewport, force) {
      var display = cm.display;

      this.viewport = viewport;
      // Store some values that we'll need later (but don't want to force a relayout for)
      this.visible = visibleLines(display, cm.doc, viewport);
      this.editorIsHidden = !display.wrapper.offsetWidth;
      this.wrapperHeight = display.wrapper.clientHeight;
      this.wrapperWidth = display.wrapper.clientWidth;
      this.oldDisplayWidth = displayWidth(cm);
      this.force = force;
      this.dims = getDimensions(cm);
      this.events = [];
    };

    DisplayUpdate.prototype.signal = function (emitter, type) {
      if (hasHandler(emitter, type))
        { this.events.push(arguments); }
    };
    DisplayUpdate.prototype.finish = function () {
      for (var i = 0; i < this.events.length; i++)
        { signal.apply(null, this.events[i]); }
    };

    function maybeClipScrollbars(cm) {
      var display = cm.display;
      if (!display.scrollbarsClipped && display.scroller.offsetWidth) {
        display.nativeBarWidth = display.scroller.offsetWidth - display.scroller.clientWidth;
        display.heightForcer.style.height = scrollGap(cm) + "px";
        display.sizer.style.marginBottom = -display.nativeBarWidth + "px";
        display.sizer.style.borderRightWidth = scrollGap(cm) + "px";
        display.scrollbarsClipped = true;
      }
    }

    function selectionSnapshot(cm) {
      if (cm.hasFocus()) { return null }
      var active = activeElt();
      if (!active || !contains(cm.display.lineDiv, active)) { return null }
      var result = {activeElt: active};
      if (window.getSelection) {
        var sel = window.getSelection();
        if (sel.anchorNode && sel.extend && contains(cm.display.lineDiv, sel.anchorNode)) {
          result.anchorNode = sel.anchorNode;
          result.anchorOffset = sel.anchorOffset;
          result.focusNode = sel.focusNode;
          result.focusOffset = sel.focusOffset;
        }
      }
      return result
    }

    function restoreSelection(snapshot) {
      if (!snapshot || !snapshot.activeElt || snapshot.activeElt == activeElt()) { return }
      snapshot.activeElt.focus();
      if (!/^(INPUT|TEXTAREA)$/.test(snapshot.activeElt.nodeName) &&
          snapshot.anchorNode && contains(document.body, snapshot.anchorNode) && contains(document.body, snapshot.focusNode)) {
        var sel = window.getSelection(), range = document.createRange();
        range.setEnd(snapshot.anchorNode, snapshot.anchorOffset);
        range.collapse(false);
        sel.removeAllRanges();
        sel.addRange(range);
        sel.extend(snapshot.focusNode, snapshot.focusOffset);
      }
    }

    // Does the actual updating of the line display. Bails out
    // (returning false) when there is nothing to be done and forced is
    // false.
    function updateDisplayIfNeeded(cm, update) {
      var display = cm.display, doc = cm.doc;

      if (update.editorIsHidden) {
        resetView(cm);
        return false
      }

      // Bail out if the visible area is already rendered and nothing changed.
      if (!update.force &&
          update.visible.from >= display.viewFrom && update.visible.to <= display.viewTo &&
          (display.updateLineNumbers == null || display.updateLineNumbers >= display.viewTo) &&
          display.renderedView == display.view && countDirtyView(cm) == 0)
        { return false }

      if (maybeUpdateLineNumberWidth(cm)) {
        resetView(cm);
        update.dims = getDimensions(cm);
      }

      // Compute a suitable new viewport (from & to)
      var end = doc.first + doc.size;
      var from = Math.max(update.visible.from - cm.options.viewportMargin, doc.first);
      var to = Math.min(end, update.visible.to + cm.options.viewportMargin);
      if (display.viewFrom < from && from - display.viewFrom < 20) { from = Math.max(doc.first, display.viewFrom); }
      if (display.viewTo > to && display.viewTo - to < 20) { to = Math.min(end, display.viewTo); }
      if (sawCollapsedSpans) {
        from = visualLineNo(cm.doc, from);
        to = visualLineEndNo(cm.doc, to);
      }

      var different = from != display.viewFrom || to != display.viewTo ||
        display.lastWrapHeight != update.wrapperHeight || display.lastWrapWidth != update.wrapperWidth;
      adjustView(cm, from, to);

      display.viewOffset = heightAtLine(getLine(cm.doc, display.viewFrom));
      // Position the mover div to align with the current scroll position
      cm.display.mover.style.top = display.viewOffset + "px";

      var toUpdate = countDirtyView(cm);
      if (!different && toUpdate == 0 && !update.force && display.renderedView == display.view &&
          (display.updateLineNumbers == null || display.updateLineNumbers >= display.viewTo))
        { return false }

      // For big changes, we hide the enclosing element during the
      // update, since that speeds up the operations on most browsers.
      var selSnapshot = selectionSnapshot(cm);
      if (toUpdate > 4) { display.lineDiv.style.display = "none"; }
      patchDisplay(cm, display.updateLineNumbers, update.dims);
      if (toUpdate > 4) { display.lineDiv.style.display = ""; }
      display.renderedView = display.view;
      // There might have been a widget with a focused element that got
      // hidden or updated, if so re-focus it.
      restoreSelection(selSnapshot);

      // Prevent selection and cursors from interfering with the scroll
      // width and height.
      removeChildren(display.cursorDiv);
      removeChildren(display.selectionDiv);
      display.gutters.style.height = display.sizer.style.minHeight = 0;

      if (different) {
        display.lastWrapHeight = update.wrapperHeight;
        display.lastWrapWidth = update.wrapperWidth;
        startWorker(cm, 400);
      }

      display.updateLineNumbers = null;

      return true
    }

    function postUpdateDisplay(cm, update) {
      var viewport = update.viewport;

      for (var first = true;; first = false) {
        if (!first || !cm.options.lineWrapping || update.oldDisplayWidth == displayWidth(cm)) {
          // Clip forced viewport to actual scrollable area.
          if (viewport && viewport.top != null)
            { viewport = {top: Math.min(cm.doc.height + paddingVert(cm.display) - displayHeight(cm), viewport.top)}; }
          // Updated line heights might result in the drawn area not
          // actually covering the viewport. Keep looping until it does.
          update.visible = visibleLines(cm.display, cm.doc, viewport);
          if (update.visible.from >= cm.display.viewFrom && update.visible.to <= cm.display.viewTo)
            { break }
        } else if (first) {
          update.visible = visibleLines(cm.display, cm.doc, viewport);
        }
        if (!updateDisplayIfNeeded(cm, update)) { break }
        updateHeightsInViewport(cm);
        var barMeasure = measureForScrollbars(cm);
        updateSelection(cm);
        updateScrollbars(cm, barMeasure);
        setDocumentHeight(cm, barMeasure);
        update.force = false;
      }

      update.signal(cm, "update", cm);
      if (cm.display.viewFrom != cm.display.reportedViewFrom || cm.display.viewTo != cm.display.reportedViewTo) {
        update.signal(cm, "viewportChange", cm, cm.display.viewFrom, cm.display.viewTo);
        cm.display.reportedViewFrom = cm.display.viewFrom; cm.display.reportedViewTo = cm.display.viewTo;
      }
    }

    function updateDisplaySimple(cm, viewport) {
      var update = new DisplayUpdate(cm, viewport);
      if (updateDisplayIfNeeded(cm, update)) {
        updateHeightsInViewport(cm);
        postUpdateDisplay(cm, update);
        var barMeasure = measureForScrollbars(cm);
        updateSelection(cm);
        updateScrollbars(cm, barMeasure);
        setDocumentHeight(cm, barMeasure);
        update.finish();
      }
    }

    // Sync the actual display DOM structure with display.view, removing
    // nodes for lines that are no longer in view, and creating the ones
    // that are not there yet, and updating the ones that are out of
    // date.
    function patchDisplay(cm, updateNumbersFrom, dims) {
      var display = cm.display, lineNumbers = cm.options.lineNumbers;
      var container = display.lineDiv, cur = container.firstChild;

      function rm(node) {
        var next = node.nextSibling;
        // Works around a throw-scroll bug in OS X Webkit
        if (webkit && mac && cm.display.currentWheelTarget == node)
          { node.style.display = "none"; }
        else
          { node.parentNode.removeChild(node); }
        return next
      }

      var view = display.view, lineN = display.viewFrom;
      // Loop over the elements in the view, syncing cur (the DOM nodes
      // in display.lineDiv) with the view as we go.
      for (var i = 0; i < view.length; i++) {
        var lineView = view[i];
        if (lineView.hidden) ; else if (!lineView.node || lineView.node.parentNode != container) { // Not drawn yet
          var node = buildLineElement(cm, lineView, lineN, dims);
          container.insertBefore(node, cur);
        } else { // Already drawn
          while (cur != lineView.node) { cur = rm(cur); }
          var updateNumber = lineNumbers && updateNumbersFrom != null &&
            updateNumbersFrom <= lineN && lineView.lineNumber;
          if (lineView.changes) {
            if (indexOf(lineView.changes, "gutter") > -1) { updateNumber = false; }
            updateLineForChanges(cm, lineView, lineN, dims);
          }
          if (updateNumber) {
            removeChildren(lineView.lineNumber);
            lineView.lineNumber.appendChild(document.createTextNode(lineNumberFor(cm.options, lineN)));
          }
          cur = lineView.node.nextSibling;
        }
        lineN += lineView.size;
      }
      while (cur) { cur = rm(cur); }
    }

    function updateGutterSpace(display) {
      var width = display.gutters.offsetWidth;
      display.sizer.style.marginLeft = width + "px";
    }

    function setDocumentHeight(cm, measure) {
      cm.display.sizer.style.minHeight = measure.docHeight + "px";
      cm.display.heightForcer.style.top = measure.docHeight + "px";
      cm.display.gutters.style.height = (measure.docHeight + cm.display.barHeight + scrollGap(cm)) + "px";
    }

    // Re-align line numbers and gutter marks to compensate for
    // horizontal scrolling.
    function alignHorizontally(cm) {
      var display = cm.display, view = display.view;
      if (!display.alignWidgets && (!display.gutters.firstChild || !cm.options.fixedGutter)) { return }
      var comp = compensateForHScroll(display) - display.scroller.scrollLeft + cm.doc.scrollLeft;
      var gutterW = display.gutters.offsetWidth, left = comp + "px";
      for (var i = 0; i < view.length; i++) { if (!view[i].hidden) {
        if (cm.options.fixedGutter) {
          if (view[i].gutter)
            { view[i].gutter.style.left = left; }
          if (view[i].gutterBackground)
            { view[i].gutterBackground.style.left = left; }
        }
        var align = view[i].alignable;
        if (align) { for (var j = 0; j < align.length; j++)
          { align[j].style.left = left; } }
      } }
      if (cm.options.fixedGutter)
        { display.gutters.style.left = (comp + gutterW) + "px"; }
    }

    // Used to ensure that the line number gutter is still the right
    // size for the current document size. Returns true when an update
    // is needed.
    function maybeUpdateLineNumberWidth(cm) {
      if (!cm.options.lineNumbers) { return false }
      var doc = cm.doc, last = lineNumberFor(cm.options, doc.first + doc.size - 1), display = cm.display;
      if (last.length != display.lineNumChars) {
        var test = display.measure.appendChild(elt("div", [elt("div", last)],
                                                   "CodeMirror-linenumber CodeMirror-gutter-elt"));
        var innerW = test.firstChild.offsetWidth, padding = test.offsetWidth - innerW;
        display.lineGutter.style.width = "";
        display.lineNumInnerWidth = Math.max(innerW, display.lineGutter.offsetWidth - padding) + 1;
        display.lineNumWidth = display.lineNumInnerWidth + padding;
        display.lineNumChars = display.lineNumInnerWidth ? last.length : -1;
        display.lineGutter.style.width = display.lineNumWidth + "px";
        updateGutterSpace(cm.display);
        return true
      }
      return false
    }

    function getGutters(gutters, lineNumbers) {
      var result = [], sawLineNumbers = false;
      for (var i = 0; i < gutters.length; i++) {
        var name = gutters[i], style = null;
        if (typeof name != "string") { style = name.style; name = name.className; }
        if (name == "CodeMirror-linenumbers") {
          if (!lineNumbers) { continue }
          else { sawLineNumbers = true; }
        }
        result.push({className: name, style: style});
      }
      if (lineNumbers && !sawLineNumbers) { result.push({className: "CodeMirror-linenumbers", style: null}); }
      return result
    }

    // Rebuild the gutter elements, ensure the margin to the left of the
    // code matches their width.
    function renderGutters(display) {
      var gutters = display.gutters, specs = display.gutterSpecs;
      removeChildren(gutters);
      display.lineGutter = null;
      for (var i = 0; i < specs.length; ++i) {
        var ref = specs[i];
        var className = ref.className;
        var style = ref.style;
        var gElt = gutters.appendChild(elt("div", null, "CodeMirror-gutter " + className));
        if (style) { gElt.style.cssText = style; }
        if (className == "CodeMirror-linenumbers") {
          display.lineGutter = gElt;
          gElt.style.width = (display.lineNumWidth || 1) + "px";
        }
      }
      gutters.style.display = specs.length ? "" : "none";
      updateGutterSpace(display);
    }

    function updateGutters(cm) {
      renderGutters(cm.display);
      regChange(cm);
      alignHorizontally(cm);
    }

    // The display handles the DOM integration, both for input reading
    // and content drawing. It holds references to DOM nodes and
    // display-related state.

    function Display(place, doc, input, options) {
      var d = this;
      this.input = input;

      // Covers bottom-right square when both scrollbars are present.
      d.scrollbarFiller = elt("div", null, "CodeMirror-scrollbar-filler");
      d.scrollbarFiller.setAttribute("cm-not-content", "true");
      // Covers bottom of gutter when coverGutterNextToScrollbar is on
      // and h scrollbar is present.
      d.gutterFiller = elt("div", null, "CodeMirror-gutter-filler");
      d.gutterFiller.setAttribute("cm-not-content", "true");
      // Will contain the actual code, positioned to cover the viewport.
      d.lineDiv = eltP("div", null, "CodeMirror-code");
      // Elements are added to these to represent selection and cursors.
      d.selectionDiv = elt("div", null, null, "position: relative; z-index: 1");
      d.cursorDiv = elt("div", null, "CodeMirror-cursors");
      // A visibility: hidden element used to find the size of things.
      d.measure = elt("div", null, "CodeMirror-measure");
      // When lines outside of the viewport are measured, they are drawn in this.
      d.lineMeasure = elt("div", null, "CodeMirror-measure");
      // Wraps everything that needs to exist inside the vertically-padded coordinate system
      d.lineSpace = eltP("div", [d.measure, d.lineMeasure, d.selectionDiv, d.cursorDiv, d.lineDiv],
                        null, "position: relative; outline: none");
      var lines = eltP("div", [d.lineSpace], "CodeMirror-lines");
      // Moved around its parent to cover visible view.
      d.mover = elt("div", [lines], null, "position: relative");
      // Set to the height of the document, allowing scrolling.
      d.sizer = elt("div", [d.mover], "CodeMirror-sizer");
      d.sizerWidth = null;
      // Behavior of elts with overflow: auto and padding is
      // inconsistent across browsers. This is used to ensure the
      // scrollable area is big enough.
      d.heightForcer = elt("div", null, null, "position: absolute; height: " + scrollerGap + "px; width: 1px;");
      // Will contain the gutters, if any.
      d.gutters = elt("div", null, "CodeMirror-gutters");
      d.lineGutter = null;
      // Actual scrollable element.
      d.scroller = elt("div", [d.sizer, d.heightForcer, d.gutters], "CodeMirror-scroll");
      d.scroller.setAttribute("tabIndex", "-1");
      // The element in which the editor lives.
      d.wrapper = elt("div", [d.scrollbarFiller, d.gutterFiller, d.scroller], "CodeMirror");

      // Work around IE7 z-index bug (not perfect, hence IE7 not really being supported)
      if (ie && ie_version < 8) { d.gutters.style.zIndex = -1; d.scroller.style.paddingRight = 0; }
      if (!webkit && !(gecko && mobile)) { d.scroller.draggable = true; }

      if (place) {
        if (place.appendChild) { place.appendChild(d.wrapper); }
        else { place(d.wrapper); }
      }

      // Current rendered range (may be bigger than the view window).
      d.viewFrom = d.viewTo = doc.first;
      d.reportedViewFrom = d.reportedViewTo = doc.first;
      // Information about the rendered lines.
      d.view = [];
      d.renderedView = null;
      // Holds info about a single rendered line when it was rendered
      // for measurement, while not in view.
      d.externalMeasured = null;
      // Empty space (in pixels) above the view
      d.viewOffset = 0;
      d.lastWrapHeight = d.lastWrapWidth = 0;
      d.updateLineNumbers = null;

      d.nativeBarWidth = d.barHeight = d.barWidth = 0;
      d.scrollbarsClipped = false;

      // Used to only resize the line number gutter when necessary (when
      // the amount of lines crosses a boundary that makes its width change)
      d.lineNumWidth = d.lineNumInnerWidth = d.lineNumChars = null;
      // Set to true when a non-horizontal-scrolling line widget is
      // added. As an optimization, line widget aligning is skipped when
      // this is false.
      d.alignWidgets = false;

      d.cachedCharWidth = d.cachedTextHeight = d.cachedPaddingH = null;

      // Tracks the maximum line length so that the horizontal scrollbar
      // can be kept static when scrolling.
      d.maxLine = null;
      d.maxLineLength = 0;
      d.maxLineChanged = false;

      // Used for measuring wheel scrolling granularity
      d.wheelDX = d.wheelDY = d.wheelStartX = d.wheelStartY = null;

      // True when shift is held down.
      d.shift = false;

      // Used to track whether anything happened since the context menu
      // was opened.
      d.selForContextMenu = null;

      d.activeTouch = null;

      d.gutterSpecs = getGutters(options.gutters, options.lineNumbers);
      renderGutters(d);

      input.init(d);
    }

    // Since the delta values reported on mouse wheel events are
    // unstandardized between browsers and even browser versions, and
    // generally horribly unpredictable, this code starts by measuring
    // the scroll effect that the first few mouse wheel events have,
    // and, from that, detects the way it can convert deltas to pixel
    // offsets afterwards.
    //
    // The reason we want to know the amount a wheel event will scroll
    // is that it gives us a chance to update the display before the
    // actual scrolling happens, reducing flickering.

    var wheelSamples = 0, wheelPixelsPerUnit = null;
    // Fill in a browser-detected starting value on browsers where we
    // know one. These don't have to be accurate -- the result of them
    // being wrong would just be a slight flicker on the first wheel
    // scroll (if it is large enough).
    if (ie) { wheelPixelsPerUnit = -.53; }
    else if (gecko) { wheelPixelsPerUnit = 15; }
    else if (chrome) { wheelPixelsPerUnit = -.7; }
    else if (safari) { wheelPixelsPerUnit = -1/3; }

    function wheelEventDelta(e) {
      var dx = e.wheelDeltaX, dy = e.wheelDeltaY;
      if (dx == null && e.detail && e.axis == e.HORIZONTAL_AXIS) { dx = e.detail; }
      if (dy == null && e.detail && e.axis == e.VERTICAL_AXIS) { dy = e.detail; }
      else if (dy == null) { dy = e.wheelDelta; }
      return {x: dx, y: dy}
    }
    function wheelEventPixels(e) {
      var delta = wheelEventDelta(e);
      delta.x *= wheelPixelsPerUnit;
      delta.y *= wheelPixelsPerUnit;
      return delta
    }

    function onScrollWheel(cm, e) {
      var delta = wheelEventDelta(e), dx = delta.x, dy = delta.y;

      var display = cm.display, scroll = display.scroller;
      // Quit if there's nothing to scroll here
      var canScrollX = scroll.scrollWidth > scroll.clientWidth;
      var canScrollY = scroll.scrollHeight > scroll.clientHeight;
      if (!(dx && canScrollX || dy && canScrollY)) { return }

      // Webkit browsers on OS X abort momentum scrolls when the target
      // of the scroll event is removed from the scrollable element.
      // This hack (see related code in patchDisplay) makes sure the
      // element is kept around.
      if (dy && mac && webkit) {
        outer: for (var cur = e.target, view = display.view; cur != scroll; cur = cur.parentNode) {
          for (var i = 0; i < view.length; i++) {
            if (view[i].node == cur) {
              cm.display.currentWheelTarget = cur;
              break outer
            }
          }
        }
      }

      // On some browsers, horizontal scrolling will cause redraws to
      // happen before the gutter has been realigned, causing it to
      // wriggle around in a most unseemly way. When we have an
      // estimated pixels/delta value, we just handle horizontal
      // scrolling entirely here. It'll be slightly off from native, but
      // better than glitching out.
      if (dx && !gecko && !presto && wheelPixelsPerUnit != null) {
        if (dy && canScrollY)
          { updateScrollTop(cm, Math.max(0, scroll.scrollTop + dy * wheelPixelsPerUnit)); }
        setScrollLeft(cm, Math.max(0, scroll.scrollLeft + dx * wheelPixelsPerUnit));
        // Only prevent default scrolling if vertical scrolling is
        // actually possible. Otherwise, it causes vertical scroll
        // jitter on OSX trackpads when deltaX is small and deltaY
        // is large (issue #3579)
        if (!dy || (dy && canScrollY))
          { e_preventDefault(e); }
        display.wheelStartX = null; // Abort measurement, if in progress
        return
      }

      // 'Project' the visible viewport to cover the area that is being
      // scrolled into view (if we know enough to estimate it).
      if (dy && wheelPixelsPerUnit != null) {
        var pixels = dy * wheelPixelsPerUnit;
        var top = cm.doc.scrollTop, bot = top + display.wrapper.clientHeight;
        if (pixels < 0) { top = Math.max(0, top + pixels - 50); }
        else { bot = Math.min(cm.doc.height, bot + pixels + 50); }
        updateDisplaySimple(cm, {top: top, bottom: bot});
      }

      if (wheelSamples < 20) {
        if (display.wheelStartX == null) {
          display.wheelStartX = scroll.scrollLeft; display.wheelStartY = scroll.scrollTop;
          display.wheelDX = dx; display.wheelDY = dy;
          setTimeout(function () {
            if (display.wheelStartX == null) { return }
            var movedX = scroll.scrollLeft - display.wheelStartX;
            var movedY = scroll.scrollTop - display.wheelStartY;
            var sample = (movedY && display.wheelDY && movedY / display.wheelDY) ||
              (movedX && display.wheelDX && movedX / display.wheelDX);
            display.wheelStartX = display.wheelStartY = null;
            if (!sample) { return }
            wheelPixelsPerUnit = (wheelPixelsPerUnit * wheelSamples + sample) / (wheelSamples + 1);
            ++wheelSamples;
          }, 200);
        } else {
          display.wheelDX += dx; display.wheelDY += dy;
        }
      }
    }

    // Selection objects are immutable. A new one is created every time
    // the selection changes. A selection is one or more non-overlapping
    // (and non-touching) ranges, sorted, and an integer that indicates
    // which one is the primary selection (the one that's scrolled into
    // view, that getCursor returns, etc).
    var Selection = function(ranges, primIndex) {
      this.ranges = ranges;
      this.primIndex = primIndex;
    };

    Selection.prototype.primary = function () { return this.ranges[this.primIndex] };

    Selection.prototype.equals = function (other) {
      if (other == this) { return true }
      if (other.primIndex != this.primIndex || other.ranges.length != this.ranges.length) { return false }
      for (var i = 0; i < this.ranges.length; i++) {
        var here = this.ranges[i], there = other.ranges[i];
        if (!equalCursorPos(here.anchor, there.anchor) || !equalCursorPos(here.head, there.head)) { return false }
      }
      return true
    };

    Selection.prototype.deepCopy = function () {
      var out = [];
      for (var i = 0; i < this.ranges.length; i++)
        { out[i] = new Range(copyPos(this.ranges[i].anchor), copyPos(this.ranges[i].head)); }
      return new Selection(out, this.primIndex)
    };

    Selection.prototype.somethingSelected = function () {
      for (var i = 0; i < this.ranges.length; i++)
        { if (!this.ranges[i].empty()) { return true } }
      return false
    };

    Selection.prototype.contains = function (pos, end) {
      if (!end) { end = pos; }
      for (var i = 0; i < this.ranges.length; i++) {
        var range = this.ranges[i];
        if (cmp(end, range.from()) >= 0 && cmp(pos, range.to()) <= 0)
          { return i }
      }
      return -1
    };

    var Range = function(anchor, head) {
      this.anchor = anchor; this.head = head;
    };

    Range.prototype.from = function () { return minPos(this.anchor, this.head) };
    Range.prototype.to = function () { return maxPos(this.anchor, this.head) };
    Range.prototype.empty = function () { return this.head.line == this.anchor.line && this.head.ch == this.anchor.ch };

    // Take an unsorted, potentially overlapping set of ranges, and
    // build a selection out of it. 'Consumes' ranges array (modifying
    // it).
    function normalizeSelection(cm, ranges, primIndex) {
      var mayTouch = cm && cm.options.selectionsMayTouch;
      var prim = ranges[primIndex];
      ranges.sort(function (a, b) { return cmp(a.from(), b.from()); });
      primIndex = indexOf(ranges, prim);
      for (var i = 1; i < ranges.length; i++) {
        var cur = ranges[i], prev = ranges[i - 1];
        var diff = cmp(prev.to(), cur.from());
        if (mayTouch && !cur.empty() ? diff > 0 : diff >= 0) {
          var from = minPos(prev.from(), cur.from()), to = maxPos(prev.to(), cur.to());
          var inv = prev.empty() ? cur.from() == cur.head : prev.from() == prev.head;
          if (i <= primIndex) { --primIndex; }
          ranges.splice(--i, 2, new Range(inv ? to : from, inv ? from : to));
        }
      }
      return new Selection(ranges, primIndex)
    }

    function simpleSelection(anchor, head) {
      return new Selection([new Range(anchor, head || anchor)], 0)
    }

    // Compute the position of the end of a change (its 'to' property
    // refers to the pre-change end).
    function changeEnd(change) {
      if (!change.text) { return change.to }
      return Pos(change.from.line + change.text.length - 1,
                 lst(change.text).length + (change.text.length == 1 ? change.from.ch : 0))
    }

    // Adjust a position to refer to the post-change position of the
    // same text, or the end of the change if the change covers it.
    function adjustForChange(pos, change) {
      if (cmp(pos, change.from) < 0) { return pos }
      if (cmp(pos, change.to) <= 0) { return changeEnd(change) }

      var line = pos.line + change.text.length - (change.to.line - change.from.line) - 1, ch = pos.ch;
      if (pos.line == change.to.line) { ch += changeEnd(change).ch - change.to.ch; }
      return Pos(line, ch)
    }

    function computeSelAfterChange(doc, change) {
      var out = [];
      for (var i = 0; i < doc.sel.ranges.length; i++) {
        var range = doc.sel.ranges[i];
        out.push(new Range(adjustForChange(range.anchor, change),
                           adjustForChange(range.head, change)));
      }
      return normalizeSelection(doc.cm, out, doc.sel.primIndex)
    }

    function offsetPos(pos, old, nw) {
      if (pos.line == old.line)
        { return Pos(nw.line, pos.ch - old.ch + nw.ch) }
      else
        { return Pos(nw.line + (pos.line - old.line), pos.ch) }
    }

    // Used by replaceSelections to allow moving the selection to the
    // start or around the replaced test. Hint may be "start" or "around".
    function computeReplacedSel(doc, changes, hint) {
      var out = [];
      var oldPrev = Pos(doc.first, 0), newPrev = oldPrev;
      for (var i = 0; i < changes.length; i++) {
        var change = changes[i];
        var from = offsetPos(change.from, oldPrev, newPrev);
        var to = offsetPos(changeEnd(change), oldPrev, newPrev);
        oldPrev = change.to;
        newPrev = to;
        if (hint == "around") {
          var range = doc.sel.ranges[i], inv = cmp(range.head, range.anchor) < 0;
          out[i] = new Range(inv ? to : from, inv ? from : to);
        } else {
          out[i] = new Range(from, from);
        }
      }
      return new Selection(out, doc.sel.primIndex)
    }

    // Used to get the editor into a consistent state again when options change.

    function loadMode(cm) {
      cm.doc.mode = getMode(cm.options, cm.doc.modeOption);
      resetModeState(cm);
    }

    function resetModeState(cm) {
      cm.doc.iter(function (line) {
        if (line.stateAfter) { line.stateAfter = null; }
        if (line.styles) { line.styles = null; }
      });
      cm.doc.modeFrontier = cm.doc.highlightFrontier = cm.doc.first;
      startWorker(cm, 100);
      cm.state.modeGen++;
      if (cm.curOp) { regChange(cm); }
    }

    // DOCUMENT DATA STRUCTURE

    // By default, updates that start and end at the beginning of a line
    // are treated specially, in order to make the association of line
    // widgets and marker elements with the text behave more intuitive.
    function isWholeLineUpdate(doc, change) {
      return change.from.ch == 0 && change.to.ch == 0 && lst(change.text) == "" &&
        (!doc.cm || doc.cm.options.wholeLineUpdateBefore)
    }

    // Perform a change on the document data structure.
    function updateDoc(doc, change, markedSpans, estimateHeight) {
      function spansFor(n) {return markedSpans ? markedSpans[n] : null}
      function update(line, text, spans) {
        updateLine(line, text, spans, estimateHeight);
        signalLater(line, "change", line, change);
      }
      function linesFor(start, end) {
        var result = [];
        for (var i = start; i < end; ++i)
          { result.push(new Line(text[i], spansFor(i), estimateHeight)); }
        return result
      }

      var from = change.from, to = change.to, text = change.text;
      var firstLine = getLine(doc, from.line), lastLine = getLine(doc, to.line);
      var lastText = lst(text), lastSpans = spansFor(text.length - 1), nlines = to.line - from.line;

      // Adjust the line structure
      if (change.full) {
        doc.insert(0, linesFor(0, text.length));
        doc.remove(text.length, doc.size - text.length);
      } else if (isWholeLineUpdate(doc, change)) {
        // This is a whole-line replace. Treated specially to make
        // sure line objects move the way they are supposed to.
        var added = linesFor(0, text.length - 1);
        update(lastLine, lastLine.text, lastSpans);
        if (nlines) { doc.remove(from.line, nlines); }
        if (added.length) { doc.insert(from.line, added); }
      } else if (firstLine == lastLine) {
        if (text.length == 1) {
          update(firstLine, firstLine.text.slice(0, from.ch) + lastText + firstLine.text.slice(to.ch), lastSpans);
        } else {
          var added$1 = linesFor(1, text.length - 1);
          added$1.push(new Line(lastText + firstLine.text.slice(to.ch), lastSpans, estimateHeight));
          update(firstLine, firstLine.text.slice(0, from.ch) + text[0], spansFor(0));
          doc.insert(from.line + 1, added$1);
        }
      } else if (text.length == 1) {
        update(firstLine, firstLine.text.slice(0, from.ch) + text[0] + lastLine.text.slice(to.ch), spansFor(0));
        doc.remove(from.line + 1, nlines);
      } else {
        update(firstLine, firstLine.text.slice(0, from.ch) + text[0], spansFor(0));
        update(lastLine, lastText + lastLine.text.slice(to.ch), lastSpans);
        var added$2 = linesFor(1, text.length - 1);
        if (nlines > 1) { doc.remove(from.line + 1, nlines - 1); }
        doc.insert(from.line + 1, added$2);
      }

      signalLater(doc, "change", doc, change);
    }

    // Call f for all linked documents.
    function linkedDocs(doc, f, sharedHistOnly) {
      function propagate(doc, skip, sharedHist) {
        if (doc.linked) { for (var i = 0; i < doc.linked.length; ++i) {
          var rel = doc.linked[i];
          if (rel.doc == skip) { continue }
          var shared = sharedHist && rel.sharedHist;
          if (sharedHistOnly && !shared) { continue }
          f(rel.doc, shared);
          propagate(rel.doc, doc, shared);
        } }
      }
      propagate(doc, null, true);
    }

    // Attach a document to an editor.
    function attachDoc(cm, doc) {
      if (doc.cm) { throw new Error("This document is already in use.") }
      cm.doc = doc;
      doc.cm = cm;
      estimateLineHeights(cm);
      loadMode(cm);
      setDirectionClass(cm);
      if (!cm.options.lineWrapping) { findMaxLine(cm); }
      cm.options.mode = doc.modeOption;
      regChange(cm);
    }

    function setDirectionClass(cm) {
    (cm.doc.direction == "rtl" ? addClass : rmClass)(cm.display.lineDiv, "CodeMirror-rtl");
    }

    function directionChanged(cm) {
      runInOp(cm, function () {
        setDirectionClass(cm);
        regChange(cm);
      });
    }

    function History(prev) {
      // Arrays of change events and selections. Doing something adds an
      // event to done and clears undo. Undoing moves events from done
      // to undone, redoing moves them in the other direction.
      this.done = []; this.undone = [];
      this.undoDepth = prev ? prev.undoDepth : Infinity;
      // Used to track when changes can be merged into a single undo
      // event
      this.lastModTime = this.lastSelTime = 0;
      this.lastOp = this.lastSelOp = null;
      this.lastOrigin = this.lastSelOrigin = null;
      // Used by the isClean() method
      this.generation = this.maxGeneration = prev ? prev.maxGeneration : 1;
    }

    // Create a history change event from an updateDoc-style change
    // object.
    function historyChangeFromChange(doc, change) {
      var histChange = {from: copyPos(change.from), to: changeEnd(change), text: getBetween(doc, change.from, change.to)};
      attachLocalSpans(doc, histChange, change.from.line, change.to.line + 1);
      linkedDocs(doc, function (doc) { return attachLocalSpans(doc, histChange, change.from.line, change.to.line + 1); }, true);
      return histChange
    }

    // Pop all selection events off the end of a history array. Stop at
    // a change event.
    function clearSelectionEvents(array) {
      while (array.length) {
        var last = lst(array);
        if (last.ranges) { array.pop(); }
        else { break }
      }
    }

    // Find the top change event in the history. Pop off selection
    // events that are in the way.
    function lastChangeEvent(hist, force) {
      if (force) {
        clearSelectionEvents(hist.done);
        return lst(hist.done)
      } else if (hist.done.length && !lst(hist.done).ranges) {
        return lst(hist.done)
      } else if (hist.done.length > 1 && !hist.done[hist.done.length - 2].ranges) {
        hist.done.pop();
        return lst(hist.done)
      }
    }

    // Register a change in the history. Merges changes that are within
    // a single operation, or are close together with an origin that
    // allows merging (starting with "+") into a single event.
    function addChangeToHistory(doc, change, selAfter, opId) {
      var hist = doc.history;
      hist.undone.length = 0;
      var time = +new Date, cur;
      var last;

      if ((hist.lastOp == opId ||
           hist.lastOrigin == change.origin && change.origin &&
           ((change.origin.charAt(0) == "+" && hist.lastModTime > time - (doc.cm ? doc.cm.options.historyEventDelay : 500)) ||
            change.origin.charAt(0) == "*")) &&
          (cur = lastChangeEvent(hist, hist.lastOp == opId))) {
        // Merge this change into the last event
        last = lst(cur.changes);
        if (cmp(change.from, change.to) == 0 && cmp(change.from, last.to) == 0) {
          // Optimized case for simple insertion -- don't want to add
          // new changesets for every character typed
          last.to = changeEnd(change);
        } else {
          // Add new sub-event
          cur.changes.push(historyChangeFromChange(doc, change));
        }
      } else {
        // Can not be merged, start a new event.
        var before = lst(hist.done);
        if (!before || !before.ranges)
          { pushSelectionToHistory(doc.sel, hist.done); }
        cur = {changes: [historyChangeFromChange(doc, change)],
               generation: hist.generation};
        hist.done.push(cur);
        while (hist.done.length > hist.undoDepth) {
          hist.done.shift();
          if (!hist.done[0].ranges) { hist.done.shift(); }
        }
      }
      hist.done.push(selAfter);
      hist.generation = ++hist.maxGeneration;
      hist.lastModTime = hist.lastSelTime = time;
      hist.lastOp = hist.lastSelOp = opId;
      hist.lastOrigin = hist.lastSelOrigin = change.origin;

      if (!last) { signal(doc, "historyAdded"); }
    }

    function selectionEventCanBeMerged(doc, origin, prev, sel) {
      var ch = origin.charAt(0);
      return ch == "*" ||
        ch == "+" &&
        prev.ranges.length == sel.ranges.length &&
        prev.somethingSelected() == sel.somethingSelected() &&
        new Date - doc.history.lastSelTime <= (doc.cm ? doc.cm.options.historyEventDelay : 500)
    }

    // Called whenever the selection changes, sets the new selection as
    // the pending selection in the history, and pushes the old pending
    // selection into the 'done' array when it was significantly
    // different (in number of selected ranges, emptiness, or time).
    function addSelectionToHistory(doc, sel, opId, options) {
      var hist = doc.history, origin = options && options.origin;

      // A new event is started when the previous origin does not match
      // the current, or the origins don't allow matching. Origins
      // starting with * are always merged, those starting with + are
      // merged when similar and close together in time.
      if (opId == hist.lastSelOp ||
          (origin && hist.lastSelOrigin == origin &&
           (hist.lastModTime == hist.lastSelTime && hist.lastOrigin == origin ||
            selectionEventCanBeMerged(doc, origin, lst(hist.done), sel))))
        { hist.done[hist.done.length - 1] = sel; }
      else
        { pushSelectionToHistory(sel, hist.done); }

      hist.lastSelTime = +new Date;
      hist.lastSelOrigin = origin;
      hist.lastSelOp = opId;
      if (options && options.clearRedo !== false)
        { clearSelectionEvents(hist.undone); }
    }

    function pushSelectionToHistory(sel, dest) {
      var top = lst(dest);
      if (!(top && top.ranges && top.equals(sel)))
        { dest.push(sel); }
    }

    // Used to store marked span information in the history.
    function attachLocalSpans(doc, change, from, to) {
      var existing = change["spans_" + doc.id], n = 0;
      doc.iter(Math.max(doc.first, from), Math.min(doc.first + doc.size, to), function (line) {
        if (line.markedSpans)
          { (existing || (existing = change["spans_" + doc.id] = {}))[n] = line.markedSpans; }
        ++n;
      });
    }

    // When un/re-doing restores text containing marked spans, those
    // that have been explicitly cleared should not be restored.
    function removeClearedSpans(spans) {
      if (!spans) { return null }
      var out;
      for (var i = 0; i < spans.length; ++i) {
        if (spans[i].marker.explicitlyCleared) { if (!out) { out = spans.slice(0, i); } }
        else if (out) { out.push(spans[i]); }
      }
      return !out ? spans : out.length ? out : null
    }

    // Retrieve and filter the old marked spans stored in a change event.
    function getOldSpans(doc, change) {
      var found = change["spans_" + doc.id];
      if (!found) { return null }
      var nw = [];
      for (var i = 0; i < change.text.length; ++i)
        { nw.push(removeClearedSpans(found[i])); }
      return nw
    }

    // Used for un/re-doing changes from the history. Combines the
    // result of computing the existing spans with the set of spans that
    // existed in the history (so that deleting around a span and then
    // undoing brings back the span).
    function mergeOldSpans(doc, change) {
      var old = getOldSpans(doc, change);
      var stretched = stretchSpansOverChange(doc, change);
      if (!old) { return stretched }
      if (!stretched) { return old }

      for (var i = 0; i < old.length; ++i) {
        var oldCur = old[i], stretchCur = stretched[i];
        if (oldCur && stretchCur) {
          spans: for (var j = 0; j < stretchCur.length; ++j) {
            var span = stretchCur[j];
            for (var k = 0; k < oldCur.length; ++k)
              { if (oldCur[k].marker == span.marker) { continue spans } }
            oldCur.push(span);
          }
        } else if (stretchCur) {
          old[i] = stretchCur;
        }
      }
      return old
    }

    // Used both to provide a JSON-safe object in .getHistory, and, when
    // detaching a document, to split the history in two
    function copyHistoryArray(events, newGroup, instantiateSel) {
      var copy = [];
      for (var i = 0; i < events.length; ++i) {
        var event = events[i];
        if (event.ranges) {
          copy.push(instantiateSel ? Selection.prototype.deepCopy.call(event) : event);
          continue
        }
        var changes = event.changes, newChanges = [];
        copy.push({changes: newChanges});
        for (var j = 0; j < changes.length; ++j) {
          var change = changes[j], m = (void 0);
          newChanges.push({from: change.from, to: change.to, text: change.text});
          if (newGroup) { for (var prop in change) { if (m = prop.match(/^spans_(\d+)$/)) {
            if (indexOf(newGroup, Number(m[1])) > -1) {
              lst(newChanges)[prop] = change[prop];
              delete change[prop];
            }
          } } }
        }
      }
      return copy
    }

    // The 'scroll' parameter given to many of these indicated whether
    // the new cursor position should be scrolled into view after
    // modifying the selection.

    // If shift is held or the extend flag is set, extends a range to
    // include a given position (and optionally a second position).
    // Otherwise, simply returns the range between the given positions.
    // Used for cursor motion and such.
    function extendRange(range, head, other, extend) {
      if (extend) {
        var anchor = range.anchor;
        if (other) {
          var posBefore = cmp(head, anchor) < 0;
          if (posBefore != (cmp(other, anchor) < 0)) {
            anchor = head;
            head = other;
          } else if (posBefore != (cmp(head, other) < 0)) {
            head = other;
          }
        }
        return new Range(anchor, head)
      } else {
        return new Range(other || head, head)
      }
    }

    // Extend the primary selection range, discard the rest.
    function extendSelection(doc, head, other, options, extend) {
      if (extend == null) { extend = doc.cm && (doc.cm.display.shift || doc.extend); }
      setSelection(doc, new Selection([extendRange(doc.sel.primary(), head, other, extend)], 0), options);
    }

    // Extend all selections (pos is an array of selections with length
    // equal the number of selections)
    function extendSelections(doc, heads, options) {
      var out = [];
      var extend = doc.cm && (doc.cm.display.shift || doc.extend);
      for (var i = 0; i < doc.sel.ranges.length; i++)
        { out[i] = extendRange(doc.sel.ranges[i], heads[i], null, extend); }
      var newSel = normalizeSelection(doc.cm, out, doc.sel.primIndex);
      setSelection(doc, newSel, options);
    }

    // Updates a single range in the selection.
    function replaceOneSelection(doc, i, range, options) {
      var ranges = doc.sel.ranges.slice(0);
      ranges[i] = range;
      setSelection(doc, normalizeSelection(doc.cm, ranges, doc.sel.primIndex), options);
    }

    // Reset the selection to a single range.
    function setSimpleSelection(doc, anchor, head, options) {
      setSelection(doc, simpleSelection(anchor, head), options);
    }

    // Give beforeSelectionChange handlers a change to influence a
    // selection update.
    function filterSelectionChange(doc, sel, options) {
      var obj = {
        ranges: sel.ranges,
        update: function(ranges) {
          this.ranges = [];
          for (var i = 0; i < ranges.length; i++)
            { this.ranges[i] = new Range(clipPos(doc, ranges[i].anchor),
                                       clipPos(doc, ranges[i].head)); }
        },
        origin: options && options.origin
      };
      signal(doc, "beforeSelectionChange", doc, obj);
      if (doc.cm) { signal(doc.cm, "beforeSelectionChange", doc.cm, obj); }
      if (obj.ranges != sel.ranges) { return normalizeSelection(doc.cm, obj.ranges, obj.ranges.length - 1) }
      else { return sel }
    }

    function setSelectionReplaceHistory(doc, sel, options) {
      var done = doc.history.done, last = lst(done);
      if (last && last.ranges) {
        done[done.length - 1] = sel;
        setSelectionNoUndo(doc, sel, options);
      } else {
        setSelection(doc, sel, options);
      }
    }

    // Set a new selection.
    function setSelection(doc, sel, options) {
      setSelectionNoUndo(doc, sel, options);
      addSelectionToHistory(doc, doc.sel, doc.cm ? doc.cm.curOp.id : NaN, options);
    }

    function setSelectionNoUndo(doc, sel, options) {
      if (hasHandler(doc, "beforeSelectionChange") || doc.cm && hasHandler(doc.cm, "beforeSelectionChange"))
        { sel = filterSelectionChange(doc, sel, options); }

      var bias = options && options.bias ||
        (cmp(sel.primary().head, doc.sel.primary().head) < 0 ? -1 : 1);
      setSelectionInner(doc, skipAtomicInSelection(doc, sel, bias, true));

      if (!(options && options.scroll === false) && doc.cm && doc.cm.getOption("readOnly") != "nocursor")
        { ensureCursorVisible(doc.cm); }
    }

    function setSelectionInner(doc, sel) {
      if (sel.equals(doc.sel)) { return }

      doc.sel = sel;

      if (doc.cm) {
        doc.cm.curOp.updateInput = 1;
        doc.cm.curOp.selectionChanged = true;
        signalCursorActivity(doc.cm);
      }
      signalLater(doc, "cursorActivity", doc);
    }

    // Verify that the selection does not partially select any atomic
    // marked ranges.
    function reCheckSelection(doc) {
      setSelectionInner(doc, skipAtomicInSelection(doc, doc.sel, null, false));
    }

    // Return a selection that does not partially select any atomic
    // ranges.
    function skipAtomicInSelection(doc, sel, bias, mayClear) {
      var out;
      for (var i = 0; i < sel.ranges.length; i++) {
        var range = sel.ranges[i];
        var old = sel.ranges.length == doc.sel.ranges.length && doc.sel.ranges[i];
        var newAnchor = skipAtomic(doc, range.anchor, old && old.anchor, bias, mayClear);
        var newHead = skipAtomic(doc, range.head, old && old.head, bias, mayClear);
        if (out || newAnchor != range.anchor || newHead != range.head) {
          if (!out) { out = sel.ranges.slice(0, i); }
          out[i] = new Range(newAnchor, newHead);
        }
      }
      return out ? normalizeSelection(doc.cm, out, sel.primIndex) : sel
    }

    function skipAtomicInner(doc, pos, oldPos, dir, mayClear) {
      var line = getLine(doc, pos.line);
      if (line.markedSpans) { for (var i = 0; i < line.markedSpans.length; ++i) {
        var sp = line.markedSpans[i], m = sp.marker;

        // Determine if we should prevent the cursor being placed to the left/right of an atomic marker
        // Historically this was determined using the inclusiveLeft/Right option, but the new way to control it
        // is with selectLeft/Right
        var preventCursorLeft = ("selectLeft" in m) ? !m.selectLeft : m.inclusiveLeft;
        var preventCursorRight = ("selectRight" in m) ? !m.selectRight : m.inclusiveRight;

        if ((sp.from == null || (preventCursorLeft ? sp.from <= pos.ch : sp.from < pos.ch)) &&
            (sp.to == null || (preventCursorRight ? sp.to >= pos.ch : sp.to > pos.ch))) {
          if (mayClear) {
            signal(m, "beforeCursorEnter");
            if (m.explicitlyCleared) {
              if (!line.markedSpans) { break }
              else {--i; continue}
            }
          }
          if (!m.atomic) { continue }

          if (oldPos) {
            var near = m.find(dir < 0 ? 1 : -1), diff = (void 0);
            if (dir < 0 ? preventCursorRight : preventCursorLeft)
              { near = movePos(doc, near, -dir, near && near.line == pos.line ? line : null); }
            if (near && near.line == pos.line && (diff = cmp(near, oldPos)) && (dir < 0 ? diff < 0 : diff > 0))
              { return skipAtomicInner(doc, near, pos, dir, mayClear) }
          }

          var far = m.find(dir < 0 ? -1 : 1);
          if (dir < 0 ? preventCursorLeft : preventCursorRight)
            { far = movePos(doc, far, dir, far.line == pos.line ? line : null); }
          return far ? skipAtomicInner(doc, far, pos, dir, mayClear) : null
        }
      } }
      return pos
    }

    // Ensure a given position is not inside an atomic range.
    function skipAtomic(doc, pos, oldPos, bias, mayClear) {
      var dir = bias || 1;
      var found = skipAtomicInner(doc, pos, oldPos, dir, mayClear) ||
          (!mayClear && skipAtomicInner(doc, pos, oldPos, dir, true)) ||
          skipAtomicInner(doc, pos, oldPos, -dir, mayClear) ||
          (!mayClear && skipAtomicInner(doc, pos, oldPos, -dir, true));
      if (!found) {
        doc.cantEdit = true;
        return Pos(doc.first, 0)
      }
      return found
    }

    function movePos(doc, pos, dir, line) {
      if (dir < 0 && pos.ch == 0) {
        if (pos.line > doc.first) { return clipPos(doc, Pos(pos.line - 1)) }
        else { return null }
      } else if (dir > 0 && pos.ch == (line || getLine(doc, pos.line)).text.length) {
        if (pos.line < doc.first + doc.size - 1) { return Pos(pos.line + 1, 0) }
        else { return null }
      } else {
        return new Pos(pos.line, pos.ch + dir)
      }
    }

    function selectAll(cm) {
      cm.setSelection(Pos(cm.firstLine(), 0), Pos(cm.lastLine()), sel_dontScroll);
    }

    // UPDATING

    // Allow "beforeChange" event handlers to influence a change
    function filterChange(doc, change, update) {
      var obj = {
        canceled: false,
        from: change.from,
        to: change.to,
        text: change.text,
        origin: change.origin,
        cancel: function () { return obj.canceled = true; }
      };
      if (update) { obj.update = function (from, to, text, origin) {
        if (from) { obj.from = clipPos(doc, from); }
        if (to) { obj.to = clipPos(doc, to); }
        if (text) { obj.text = text; }
        if (origin !== undefined) { obj.origin = origin; }
      }; }
      signal(doc, "beforeChange", doc, obj);
      if (doc.cm) { signal(doc.cm, "beforeChange", doc.cm, obj); }

      if (obj.canceled) {
        if (doc.cm) { doc.cm.curOp.updateInput = 2; }
        return null
      }
      return {from: obj.from, to: obj.to, text: obj.text, origin: obj.origin}
    }

    // Apply a change to a document, and add it to the document's
    // history, and propagating it to all linked documents.
    function makeChange(doc, change, ignoreReadOnly) {
      if (doc.cm) {
        if (!doc.cm.curOp) { return operation(doc.cm, makeChange)(doc, change, ignoreReadOnly) }
        if (doc.cm.state.suppressEdits) { return }
      }

      if (hasHandler(doc, "beforeChange") || doc.cm && hasHandler(doc.cm, "beforeChange")) {
        change = filterChange(doc, change, true);
        if (!change) { return }
      }

      // Possibly split or suppress the update based on the presence
      // of read-only spans in its range.
      var split = sawReadOnlySpans && !ignoreReadOnly && removeReadOnlyRanges(doc, change.from, change.to);
      if (split) {
        for (var i = split.length - 1; i >= 0; --i)
          { makeChangeInner(doc, {from: split[i].from, to: split[i].to, text: i ? [""] : change.text, origin: change.origin}); }
      } else {
        makeChangeInner(doc, change);
      }
    }

    function makeChangeInner(doc, change) {
      if (change.text.length == 1 && change.text[0] == "" && cmp(change.from, change.to) == 0) { return }
      var selAfter = computeSelAfterChange(doc, change);
      addChangeToHistory(doc, change, selAfter, doc.cm ? doc.cm.curOp.id : NaN);

      makeChangeSingleDoc(doc, change, selAfter, stretchSpansOverChange(doc, change));
      var rebased = [];

      linkedDocs(doc, function (doc, sharedHist) {
        if (!sharedHist && indexOf(rebased, doc.history) == -1) {
          rebaseHist(doc.history, change);
          rebased.push(doc.history);
        }
        makeChangeSingleDoc(doc, change, null, stretchSpansOverChange(doc, change));
      });
    }

    // Revert a change stored in a document's history.
    function makeChangeFromHistory(doc, type, allowSelectionOnly) {
      var suppress = doc.cm && doc.cm.state.suppressEdits;
      if (suppress && !allowSelectionOnly) { return }

      var hist = doc.history, event, selAfter = doc.sel;
      var source = type == "undo" ? hist.done : hist.undone, dest = type == "undo" ? hist.undone : hist.done;

      // Verify that there is a useable event (so that ctrl-z won't
      // needlessly clear selection events)
      var i = 0;
      for (; i < source.length; i++) {
        event = source[i];
        if (allowSelectionOnly ? event.ranges && !event.equals(doc.sel) : !event.ranges)
          { break }
      }
      if (i == source.length) { return }
      hist.lastOrigin = hist.lastSelOrigin = null;

      for (;;) {
        event = source.pop();
        if (event.ranges) {
          pushSelectionToHistory(event, dest);
          if (allowSelectionOnly && !event.equals(doc.sel)) {
            setSelection(doc, event, {clearRedo: false});
            return
          }
          selAfter = event;
        } else if (suppress) {
          source.push(event);
          return
        } else { break }
      }

      // Build up a reverse change object to add to the opposite history
      // stack (redo when undoing, and vice versa).
      var antiChanges = [];
      pushSelectionToHistory(selAfter, dest);
      dest.push({changes: antiChanges, generation: hist.generation});
      hist.generation = event.generation || ++hist.maxGeneration;

      var filter = hasHandler(doc, "beforeChange") || doc.cm && hasHandler(doc.cm, "beforeChange");

      var loop = function ( i ) {
        var change = event.changes[i];
        change.origin = type;
        if (filter && !filterChange(doc, change, false)) {
          source.length = 0;
          return {}
        }

        antiChanges.push(historyChangeFromChange(doc, change));

        var after = i ? computeSelAfterChange(doc, change) : lst(source);
        makeChangeSingleDoc(doc, change, after, mergeOldSpans(doc, change));
        if (!i && doc.cm) { doc.cm.scrollIntoView({from: change.from, to: changeEnd(change)}); }
        var rebased = [];

        // Propagate to the linked documents
        linkedDocs(doc, function (doc, sharedHist) {
          if (!sharedHist && indexOf(rebased, doc.history) == -1) {
            rebaseHist(doc.history, change);
            rebased.push(doc.history);
          }
          makeChangeSingleDoc(doc, change, null, mergeOldSpans(doc, change));
        });
      };

      for (var i$1 = event.changes.length - 1; i$1 >= 0; --i$1) {
        var returned = loop( i$1 );

        if ( returned ) { return returned.v; }
      }
    }

    // Sub-views need their line numbers shifted when text is added
    // above or below them in the parent document.
    function shiftDoc(doc, distance) {
      if (distance == 0) { return }
      doc.first += distance;
      doc.sel = new Selection(map(doc.sel.ranges, function (range) { return new Range(
        Pos(range.anchor.line + distance, range.anchor.ch),
        Pos(range.head.line + distance, range.head.ch)
      ); }), doc.sel.primIndex);
      if (doc.cm) {
        regChange(doc.cm, doc.first, doc.first - distance, distance);
        for (var d = doc.cm.display, l = d.viewFrom; l < d.viewTo; l++)
          { regLineChange(doc.cm, l, "gutter"); }
      }
    }

    // More lower-level change function, handling only a single document
    // (not linked ones).
    function makeChangeSingleDoc(doc, change, selAfter, spans) {
      if (doc.cm && !doc.cm.curOp)
        { return operation(doc.cm, makeChangeSingleDoc)(doc, change, selAfter, spans) }

      if (change.to.line < doc.first) {
        shiftDoc(doc, change.text.length - 1 - (change.to.line - change.from.line));
        return
      }
      if (change.from.line > doc.lastLine()) { return }

      // Clip the change to the size of this doc
      if (change.from.line < doc.first) {
        var shift = change.text.length - 1 - (doc.first - change.from.line);
        shiftDoc(doc, shift);
        change = {from: Pos(doc.first, 0), to: Pos(change.to.line + shift, change.to.ch),
                  text: [lst(change.text)], origin: change.origin};
      }
      var last = doc.lastLine();
      if (change.to.line > last) {
        change = {from: change.from, to: Pos(last, getLine(doc, last).text.length),
                  text: [change.text[0]], origin: change.origin};
      }

      change.removed = getBetween(doc, change.from, change.to);

      if (!selAfter) { selAfter = computeSelAfterChange(doc, change); }
      if (doc.cm) { makeChangeSingleDocInEditor(doc.cm, change, spans); }
      else { updateDoc(doc, change, spans); }
      setSelectionNoUndo(doc, selAfter, sel_dontScroll);

      if (doc.cantEdit && skipAtomic(doc, Pos(doc.firstLine(), 0)))
        { doc.cantEdit = false; }
    }

    // Handle the interaction of a change to a document with the editor
    // that this document is part of.
    function makeChangeSingleDocInEditor(cm, change, spans) {
      var doc = cm.doc, display = cm.display, from = change.from, to = change.to;

      var recomputeMaxLength = false, checkWidthStart = from.line;
      if (!cm.options.lineWrapping) {
        checkWidthStart = lineNo(visualLine(getLine(doc, from.line)));
        doc.iter(checkWidthStart, to.line + 1, function (line) {
          if (line == display.maxLine) {
            recomputeMaxLength = true;
            return true
          }
        });
      }

      if (doc.sel.contains(change.from, change.to) > -1)
        { signalCursorActivity(cm); }

      updateDoc(doc, change, spans, estimateHeight(cm));

      if (!cm.options.lineWrapping) {
        doc.iter(checkWidthStart, from.line + change.text.length, function (line) {
          var len = lineLength(line);
          if (len > display.maxLineLength) {
            display.maxLine = line;
            display.maxLineLength = len;
            display.maxLineChanged = true;
            recomputeMaxLength = false;
          }
        });
        if (recomputeMaxLength) { cm.curOp.updateMaxLine = true; }
      }

      retreatFrontier(doc, from.line);
      startWorker(cm, 400);

      var lendiff = change.text.length - (to.line - from.line) - 1;
      // Remember that these lines changed, for updating the display
      if (change.full)
        { regChange(cm); }
      else if (from.line == to.line && change.text.length == 1 && !isWholeLineUpdate(cm.doc, change))
        { regLineChange(cm, from.line, "text"); }
      else
        { regChange(cm, from.line, to.line + 1, lendiff); }

      var changesHandler = hasHandler(cm, "changes"), changeHandler = hasHandler(cm, "change");
      if (changeHandler || changesHandler) {
        var obj = {
          from: from, to: to,
          text: change.text,
          removed: change.removed,
          origin: change.origin
        };
        if (changeHandler) { signalLater(cm, "change", cm, obj); }
        if (changesHandler) { (cm.curOp.changeObjs || (cm.curOp.changeObjs = [])).push(obj); }
      }
      cm.display.selForContextMenu = null;
    }

    function replaceRange(doc, code, from, to, origin) {
      var assign;

      if (!to) { to = from; }
      if (cmp(to, from) < 0) { (assign = [to, from], from = assign[0], to = assign[1]); }
      if (typeof code == "string") { code = doc.splitLines(code); }
      makeChange(doc, {from: from, to: to, text: code, origin: origin});
    }

    // Rebasing/resetting history to deal with externally-sourced changes

    function rebaseHistSelSingle(pos, from, to, diff) {
      if (to < pos.line) {
        pos.line += diff;
      } else if (from < pos.line) {
        pos.line = from;
        pos.ch = 0;
      }
    }

    // Tries to rebase an array of history events given a change in the
    // document. If the change touches the same lines as the event, the
    // event, and everything 'behind' it, is discarded. If the change is
    // before the event, the event's positions are updated. Uses a
    // copy-on-write scheme for the positions, to avoid having to
    // reallocate them all on every rebase, but also avoid problems with
    // shared position objects being unsafely updated.
    function rebaseHistArray(array, from, to, diff) {
      for (var i = 0; i < array.length; ++i) {
        var sub = array[i], ok = true;
        if (sub.ranges) {
          if (!sub.copied) { sub = array[i] = sub.deepCopy(); sub.copied = true; }
          for (var j = 0; j < sub.ranges.length; j++) {
            rebaseHistSelSingle(sub.ranges[j].anchor, from, to, diff);
            rebaseHistSelSingle(sub.ranges[j].head, from, to, diff);
          }
          continue
        }
        for (var j$1 = 0; j$1 < sub.changes.length; ++j$1) {
          var cur = sub.changes[j$1];
          if (to < cur.from.line) {
            cur.from = Pos(cur.from.line + diff, cur.from.ch);
            cur.to = Pos(cur.to.line + diff, cur.to.ch);
          } else if (from <= cur.to.line) {
            ok = false;
            break
          }
        }
        if (!ok) {
          array.splice(0, i + 1);
          i = 0;
        }
      }
    }

    function rebaseHist(hist, change) {
      var from = change.from.line, to = change.to.line, diff = change.text.length - (to - from) - 1;
      rebaseHistArray(hist.done, from, to, diff);
      rebaseHistArray(hist.undone, from, to, diff);
    }

    // Utility for applying a change to a line by handle or number,
    // returning the number and optionally registering the line as
    // changed.
    function changeLine(doc, handle, changeType, op) {
      var no = handle, line = handle;
      if (typeof handle == "number") { line = getLine(doc, clipLine(doc, handle)); }
      else { no = lineNo(handle); }
      if (no == null) { return null }
      if (op(line, no) && doc.cm) { regLineChange(doc.cm, no, changeType); }
      return line
    }

    // The document is represented as a BTree consisting of leaves, with
    // chunk of lines in them, and branches, with up to ten leaves or
    // other branch nodes below them. The top node is always a branch
    // node, and is the document object itself (meaning it has
    // additional methods and properties).
    //
    // All nodes have parent links. The tree is used both to go from
    // line numbers to line objects, and to go from objects to numbers.
    // It also indexes by height, and is used to convert between height
    // and line object, and to find the total height of the document.
    //
    // See also http://marijnhaverbeke.nl/blog/codemirror-line-tree.html

    function LeafChunk(lines) {
      this.lines = lines;
      this.parent = null;
      var height = 0;
      for (var i = 0; i < lines.length; ++i) {
        lines[i].parent = this;
        height += lines[i].height;
      }
      this.height = height;
    }

    LeafChunk.prototype = {
      chunkSize: function() { return this.lines.length },

      // Remove the n lines at offset 'at'.
      removeInner: function(at, n) {
        for (var i = at, e = at + n; i < e; ++i) {
          var line = this.lines[i];
          this.height -= line.height;
          cleanUpLine(line);
          signalLater(line, "delete");
        }
        this.lines.splice(at, n);
      },

      // Helper used to collapse a small branch into a single leaf.
      collapse: function(lines) {
        lines.push.apply(lines, this.lines);
      },

      // Insert the given array of lines at offset 'at', count them as
      // having the given height.
      insertInner: function(at, lines, height) {
        this.height += height;
        this.lines = this.lines.slice(0, at).concat(lines).concat(this.lines.slice(at));
        for (var i = 0; i < lines.length; ++i) { lines[i].parent = this; }
      },

      // Used to iterate over a part of the tree.
      iterN: function(at, n, op) {
        for (var e = at + n; at < e; ++at)
          { if (op(this.lines[at])) { return true } }
      }
    };

    function BranchChunk(children) {
      this.children = children;
      var size = 0, height = 0;
      for (var i = 0; i < children.length; ++i) {
        var ch = children[i];
        size += ch.chunkSize(); height += ch.height;
        ch.parent = this;
      }
      this.size = size;
      this.height = height;
      this.parent = null;
    }

    BranchChunk.prototype = {
      chunkSize: function() { return this.size },

      removeInner: function(at, n) {
        this.size -= n;
        for (var i = 0; i < this.children.length; ++i) {
          var child = this.children[i], sz = child.chunkSize();
          if (at < sz) {
            var rm = Math.min(n, sz - at), oldHeight = child.height;
            child.removeInner(at, rm);
            this.height -= oldHeight - child.height;
            if (sz == rm) { this.children.splice(i--, 1); child.parent = null; }
            if ((n -= rm) == 0) { break }
            at = 0;
          } else { at -= sz; }
        }
        // If the result is smaller than 25 lines, ensure that it is a
        // single leaf node.
        if (this.size - n < 25 &&
            (this.children.length > 1 || !(this.children[0] instanceof LeafChunk))) {
          var lines = [];
          this.collapse(lines);
          this.children = [new LeafChunk(lines)];
          this.children[0].parent = this;
        }
      },

      collapse: function(lines) {
        for (var i = 0; i < this.children.length; ++i) { this.children[i].collapse(lines); }
      },

      insertInner: function(at, lines, height) {
        this.size += lines.length;
        this.height += height;
        for (var i = 0; i < this.children.length; ++i) {
          var child = this.children[i], sz = child.chunkSize();
          if (at <= sz) {
            child.insertInner(at, lines, height);
            if (child.lines && child.lines.length > 50) {
              // To avoid memory thrashing when child.lines is huge (e.g. first view of a large file), it's never spliced.
              // Instead, small slices are taken. They're taken in order because sequential memory accesses are fastest.
              var remaining = child.lines.length % 25 + 25;
              for (var pos = remaining; pos < child.lines.length;) {
                var leaf = new LeafChunk(child.lines.slice(pos, pos += 25));
                child.height -= leaf.height;
                this.children.splice(++i, 0, leaf);
                leaf.parent = this;
              }
              child.lines = child.lines.slice(0, remaining);
              this.maybeSpill();
            }
            break
          }
          at -= sz;
        }
      },

      // When a node has grown, check whether it should be split.
      maybeSpill: function() {
        if (this.children.length <= 10) { return }
        var me = this;
        do {
          var spilled = me.children.splice(me.children.length - 5, 5);
          var sibling = new BranchChunk(spilled);
          if (!me.parent) { // Become the parent node
            var copy = new BranchChunk(me.children);
            copy.parent = me;
            me.children = [copy, sibling];
            me = copy;
         } else {
            me.size -= sibling.size;
            me.height -= sibling.height;
            var myIndex = indexOf(me.parent.children, me);
            me.parent.children.splice(myIndex + 1, 0, sibling);
          }
          sibling.parent = me.parent;
        } while (me.children.length > 10)
        me.parent.maybeSpill();
      },

      iterN: function(at, n, op) {
        for (var i = 0; i < this.children.length; ++i) {
          var child = this.children[i], sz = child.chunkSize();
          if (at < sz) {
            var used = Math.min(n, sz - at);
            if (child.iterN(at, used, op)) { return true }
            if ((n -= used) == 0) { break }
            at = 0;
          } else { at -= sz; }
        }
      }
    };

    // Line widgets are block elements displayed above or below a line.

    var LineWidget = function(doc, node, options) {
      if (options) { for (var opt in options) { if (options.hasOwnProperty(opt))
        { this[opt] = options[opt]; } } }
      this.doc = doc;
      this.node = node;
    };

    LineWidget.prototype.clear = function () {
      var cm = this.doc.cm, ws = this.line.widgets, line = this.line, no = lineNo(line);
      if (no == null || !ws) { return }
      for (var i = 0; i < ws.length; ++i) { if (ws[i] == this) { ws.splice(i--, 1); } }
      if (!ws.length) { line.widgets = null; }
      var height = widgetHeight(this);
      updateLineHeight(line, Math.max(0, line.height - height));
      if (cm) {
        runInOp(cm, function () {
          adjustScrollWhenAboveVisible(cm, line, -height);
          regLineChange(cm, no, "widget");
        });
        signalLater(cm, "lineWidgetCleared", cm, this, no);
      }
    };

    LineWidget.prototype.changed = function () {
        var this$1 = this;

      var oldH = this.height, cm = this.doc.cm, line = this.line;
      this.height = null;
      var diff = widgetHeight(this) - oldH;
      if (!diff) { return }
      if (!lineIsHidden(this.doc, line)) { updateLineHeight(line, line.height + diff); }
      if (cm) {
        runInOp(cm, function () {
          cm.curOp.forceUpdate = true;
          adjustScrollWhenAboveVisible(cm, line, diff);
          signalLater(cm, "lineWidgetChanged", cm, this$1, lineNo(line));
        });
      }
    };
    eventMixin(LineWidget);

    function adjustScrollWhenAboveVisible(cm, line, diff) {
      if (heightAtLine(line) < ((cm.curOp && cm.curOp.scrollTop) || cm.doc.scrollTop))
        { addToScrollTop(cm, diff); }
    }

    function addLineWidget(doc, handle, node, options) {
      var widget = new LineWidget(doc, node, options);
      var cm = doc.cm;
      if (cm && widget.noHScroll) { cm.display.alignWidgets = true; }
      changeLine(doc, handle, "widget", function (line) {
        var widgets = line.widgets || (line.widgets = []);
        if (widget.insertAt == null) { widgets.push(widget); }
        else { widgets.splice(Math.min(widgets.length, Math.max(0, widget.insertAt)), 0, widget); }
        widget.line = line;
        if (cm && !lineIsHidden(doc, line)) {
          var aboveVisible = heightAtLine(line) < doc.scrollTop;
          updateLineHeight(line, line.height + widgetHeight(widget));
          if (aboveVisible) { addToScrollTop(cm, widget.height); }
          cm.curOp.forceUpdate = true;
        }
        return true
      });
      if (cm) { signalLater(cm, "lineWidgetAdded", cm, widget, typeof handle == "number" ? handle : lineNo(handle)); }
      return widget
    }

    // TEXTMARKERS

    // Created with markText and setBookmark methods. A TextMarker is a
    // handle that can be used to clear or find a marked position in the
    // document. Line objects hold arrays (markedSpans) containing
    // {from, to, marker} object pointing to such marker objects, and
    // indicating that such a marker is present on that line. Multiple
    // lines may point to the same marker when it spans across lines.
    // The spans will have null for their from/to properties when the
    // marker continues beyond the start/end of the line. Markers have
    // links back to the lines they currently touch.

    // Collapsed markers have unique ids, in order to be able to order
    // them, which is needed for uniquely determining an outer marker
    // when they overlap (they may nest, but not partially overlap).
    var nextMarkerId = 0;

    var TextMarker = function(doc, type) {
      this.lines = [];
      this.type = type;
      this.doc = doc;
      this.id = ++nextMarkerId;
    };

    // Clear the marker.
    TextMarker.prototype.clear = function () {
      if (this.explicitlyCleared) { return }
      var cm = this.doc.cm, withOp = cm && !cm.curOp;
      if (withOp) { startOperation(cm); }
      if (hasHandler(this, "clear")) {
        var found = this.find();
        if (found) { signalLater(this, "clear", found.from, found.to); }
      }
      var min = null, max = null;
      for (var i = 0; i < this.lines.length; ++i) {
        var line = this.lines[i];
        var span = getMarkedSpanFor(line.markedSpans, this);
        if (cm && !this.collapsed) { regLineChange(cm, lineNo(line), "text"); }
        else if (cm) {
          if (span.to != null) { max = lineNo(line); }
          if (span.from != null) { min = lineNo(line); }
        }
        line.markedSpans = removeMarkedSpan(line.markedSpans, span);
        if (span.from == null && this.collapsed && !lineIsHidden(this.doc, line) && cm)
          { updateLineHeight(line, textHeight(cm.display)); }
      }
      if (cm && this.collapsed && !cm.options.lineWrapping) { for (var i$1 = 0; i$1 < this.lines.length; ++i$1) {
        var visual = visualLine(this.lines[i$1]), len = lineLength(visual);
        if (len > cm.display.maxLineLength) {
          cm.display.maxLine = visual;
          cm.display.maxLineLength = len;
          cm.display.maxLineChanged = true;
        }
      } }

      if (min != null && cm && this.collapsed) { regChange(cm, min, max + 1); }
      this.lines.length = 0;
      this.explicitlyCleared = true;
      if (this.atomic && this.doc.cantEdit) {
        this.doc.cantEdit = false;
        if (cm) { reCheckSelection(cm.doc); }
      }
      if (cm) { signalLater(cm, "markerCleared", cm, this, min, max); }
      if (withOp) { endOperation(cm); }
      if (this.parent) { this.parent.clear(); }
    };

    // Find the position of the marker in the document. Returns a {from,
    // to} object by default. Side can be passed to get a specific side
    // -- 0 (both), -1 (left), or 1 (right). When lineObj is true, the
    // Pos objects returned contain a line object, rather than a line
    // number (used to prevent looking up the same line twice).
    TextMarker.prototype.find = function (side, lineObj) {
      if (side == null && this.type == "bookmark") { side = 1; }
      var from, to;
      for (var i = 0; i < this.lines.length; ++i) {
        var line = this.lines[i];
        var span = getMarkedSpanFor(line.markedSpans, this);
        if (span.from != null) {
          from = Pos(lineObj ? line : lineNo(line), span.from);
          if (side == -1) { return from }
        }
        if (span.to != null) {
          to = Pos(lineObj ? line : lineNo(line), span.to);
          if (side == 1) { return to }
        }
      }
      return from && {from: from, to: to}
    };

    // Signals that the marker's widget changed, and surrounding layout
    // should be recomputed.
    TextMarker.prototype.changed = function () {
        var this$1 = this;

      var pos = this.find(-1, true), widget = this, cm = this.doc.cm;
      if (!pos || !cm) { return }
      runInOp(cm, function () {
        var line = pos.line, lineN = lineNo(pos.line);
        var view = findViewForLine(cm, lineN);
        if (view) {
          clearLineMeasurementCacheFor(view);
          cm.curOp.selectionChanged = cm.curOp.forceUpdate = true;
        }
        cm.curOp.updateMaxLine = true;
        if (!lineIsHidden(widget.doc, line) && widget.height != null) {
          var oldHeight = widget.height;
          widget.height = null;
          var dHeight = widgetHeight(widget) - oldHeight;
          if (dHeight)
            { updateLineHeight(line, line.height + dHeight); }
        }
        signalLater(cm, "markerChanged", cm, this$1);
      });
    };

    TextMarker.prototype.attachLine = function (line) {
      if (!this.lines.length && this.doc.cm) {
        var op = this.doc.cm.curOp;
        if (!op.maybeHiddenMarkers || indexOf(op.maybeHiddenMarkers, this) == -1)
          { (op.maybeUnhiddenMarkers || (op.maybeUnhiddenMarkers = [])).push(this); }
      }
      this.lines.push(line);
    };

    TextMarker.prototype.detachLine = function (line) {
      this.lines.splice(indexOf(this.lines, line), 1);
      if (!this.lines.length && this.doc.cm) {
        var op = this.doc.cm.curOp
        ;(op.maybeHiddenMarkers || (op.maybeHiddenMarkers = [])).push(this);
      }
    };
    eventMixin(TextMarker);

    // Create a marker, wire it up to the right lines, and
    function markText(doc, from, to, options, type) {
      // Shared markers (across linked documents) are handled separately
      // (markTextShared will call out to this again, once per
      // document).
      if (options && options.shared) { return markTextShared(doc, from, to, options, type) }
      // Ensure we are in an operation.
      if (doc.cm && !doc.cm.curOp) { return operation(doc.cm, markText)(doc, from, to, options, type) }

      var marker = new TextMarker(doc, type), diff = cmp(from, to);
      if (options) { copyObj(options, marker, false); }
      // Don't connect empty markers unless clearWhenEmpty is false
      if (diff > 0 || diff == 0 && marker.clearWhenEmpty !== false)
        { return marker }
      if (marker.replacedWith) {
        // Showing up as a widget implies collapsed (widget replaces text)
        marker.collapsed = true;
        marker.widgetNode = eltP("span", [marker.replacedWith], "CodeMirror-widget");
        if (!options.handleMouseEvents) { marker.widgetNode.setAttribute("cm-ignore-events", "true"); }
        if (options.insertLeft) { marker.widgetNode.insertLeft = true; }
      }
      if (marker.collapsed) {
        if (conflictingCollapsedRange(doc, from.line, from, to, marker) ||
            from.line != to.line && conflictingCollapsedRange(doc, to.line, from, to, marker))
          { throw new Error("Inserting collapsed marker partially overlapping an existing one") }
        seeCollapsedSpans();
      }

      if (marker.addToHistory)
        { addChangeToHistory(doc, {from: from, to: to, origin: "markText"}, doc.sel, NaN); }

      var curLine = from.line, cm = doc.cm, updateMaxLine;
      doc.iter(curLine, to.line + 1, function (line) {
        if (cm && marker.collapsed && !cm.options.lineWrapping && visualLine(line) == cm.display.maxLine)
          { updateMaxLine = true; }
        if (marker.collapsed && curLine != from.line) { updateLineHeight(line, 0); }
        addMarkedSpan(line, new MarkedSpan(marker,
                                           curLine == from.line ? from.ch : null,
                                           curLine == to.line ? to.ch : null));
        ++curLine;
      });
      // lineIsHidden depends on the presence of the spans, so needs a second pass
      if (marker.collapsed) { doc.iter(from.line, to.line + 1, function (line) {
        if (lineIsHidden(doc, line)) { updateLineHeight(line, 0); }
      }); }

      if (marker.clearOnEnter) { on(marker, "beforeCursorEnter", function () { return marker.clear(); }); }

      if (marker.readOnly) {
        seeReadOnlySpans();
        if (doc.history.done.length || doc.history.undone.length)
          { doc.clearHistory(); }
      }
      if (marker.collapsed) {
        marker.id = ++nextMarkerId;
        marker.atomic = true;
      }
      if (cm) {
        // Sync editor state
        if (updateMaxLine) { cm.curOp.updateMaxLine = true; }
        if (marker.collapsed)
          { regChange(cm, from.line, to.line + 1); }
        else if (marker.className || marker.startStyle || marker.endStyle || marker.css ||
                 marker.attributes || marker.title)
          { for (var i = from.line; i <= to.line; i++) { regLineChange(cm, i, "text"); } }
        if (marker.atomic) { reCheckSelection(cm.doc); }
        signalLater(cm, "markerAdded", cm, marker);
      }
      return marker
    }

    // SHARED TEXTMARKERS

    // A shared marker spans multiple linked documents. It is
    // implemented as a meta-marker-object controlling multiple normal
    // markers.
    var SharedTextMarker = function(markers, primary) {
      this.markers = markers;
      this.primary = primary;
      for (var i = 0; i < markers.length; ++i)
        { markers[i].parent = this; }
    };

    SharedTextMarker.prototype.clear = function () {
      if (this.explicitlyCleared) { return }
      this.explicitlyCleared = true;
      for (var i = 0; i < this.markers.length; ++i)
        { this.markers[i].clear(); }
      signalLater(this, "clear");
    };

    SharedTextMarker.prototype.find = function (side, lineObj) {
      return this.primary.find(side, lineObj)
    };
    eventMixin(SharedTextMarker);

    function markTextShared(doc, from, to, options, type) {
      options = copyObj(options);
      options.shared = false;
      var markers = [markText(doc, from, to, options, type)], primary = markers[0];
      var widget = options.widgetNode;
      linkedDocs(doc, function (doc) {
        if (widget) { options.widgetNode = widget.cloneNode(true); }
        markers.push(markText(doc, clipPos(doc, from), clipPos(doc, to), options, type));
        for (var i = 0; i < doc.linked.length; ++i)
          { if (doc.linked[i].isParent) { return } }
        primary = lst(markers);
      });
      return new SharedTextMarker(markers, primary)
    }

    function findSharedMarkers(doc) {
      return doc.findMarks(Pos(doc.first, 0), doc.clipPos(Pos(doc.lastLine())), function (m) { return m.parent; })
    }

    function copySharedMarkers(doc, markers) {
      for (var i = 0; i < markers.length; i++) {
        var marker = markers[i], pos = marker.find();
        var mFrom = doc.clipPos(pos.from), mTo = doc.clipPos(pos.to);
        if (cmp(mFrom, mTo)) {
          var subMark = markText(doc, mFrom, mTo, marker.primary, marker.primary.type);
          marker.markers.push(subMark);
          subMark.parent = marker;
        }
      }
    }

    function detachSharedMarkers(markers) {
      var loop = function ( i ) {
        var marker = markers[i], linked = [marker.primary.doc];
        linkedDocs(marker.primary.doc, function (d) { return linked.push(d); });
        for (var j = 0; j < marker.markers.length; j++) {
          var subMarker = marker.markers[j];
          if (indexOf(linked, subMarker.doc) == -1) {
            subMarker.parent = null;
            marker.markers.splice(j--, 1);
          }
        }
      };

      for (var i = 0; i < markers.length; i++) { loop( i ); }
    }

    var nextDocId = 0;
    var Doc = function(text, mode, firstLine, lineSep, direction) {
      if (!(this instanceof Doc)) { return new Doc(text, mode, firstLine, lineSep, direction) }
      if (firstLine == null) { firstLine = 0; }

      BranchChunk.call(this, [new LeafChunk([new Line("", null)])]);
      this.first = firstLine;
      this.scrollTop = this.scrollLeft = 0;
      this.cantEdit = false;
      this.cleanGeneration = 1;
      this.modeFrontier = this.highlightFrontier = firstLine;
      var start = Pos(firstLine, 0);
      this.sel = simpleSelection(start);
      this.history = new History(null);
      this.id = ++nextDocId;
      this.modeOption = mode;
      this.lineSep = lineSep;
      this.direction = (direction == "rtl") ? "rtl" : "ltr";
      this.extend = false;

      if (typeof text == "string") { text = this.splitLines(text); }
      updateDoc(this, {from: start, to: start, text: text});
      setSelection(this, simpleSelection(start), sel_dontScroll);
    };

    Doc.prototype = createObj(BranchChunk.prototype, {
      constructor: Doc,
      // Iterate over the document. Supports two forms -- with only one
      // argument, it calls that for each line in the document. With
      // three, it iterates over the range given by the first two (with
      // the second being non-inclusive).
      iter: function(from, to, op) {
        if (op) { this.iterN(from - this.first, to - from, op); }
        else { this.iterN(this.first, this.first + this.size, from); }
      },

      // Non-public interface for adding and removing lines.
      insert: function(at, lines) {
        var height = 0;
        for (var i = 0; i < lines.length; ++i) { height += lines[i].height; }
        this.insertInner(at - this.first, lines, height);
      },
      remove: function(at, n) { this.removeInner(at - this.first, n); },

      // From here, the methods are part of the public interface. Most
      // are also available from CodeMirror (editor) instances.

      getValue: function(lineSep) {
        var lines = getLines(this, this.first, this.first + this.size);
        if (lineSep === false) { return lines }
        return lines.join(lineSep || this.lineSeparator())
      },
      setValue: docMethodOp(function(code) {
        var top = Pos(this.first, 0), last = this.first + this.size - 1;
        makeChange(this, {from: top, to: Pos(last, getLine(this, last).text.length),
                          text: this.splitLines(code), origin: "setValue", full: true}, true);
        if (this.cm) { scrollToCoords(this.cm, 0, 0); }
        setSelection(this, simpleSelection(top), sel_dontScroll);
      }),
      replaceRange: function(code, from, to, origin) {
        from = clipPos(this, from);
        to = to ? clipPos(this, to) : from;
        replaceRange(this, code, from, to, origin);
      },
      getRange: function(from, to, lineSep) {
        var lines = getBetween(this, clipPos(this, from), clipPos(this, to));
        if (lineSep === false) { return lines }
        return lines.join(lineSep || this.lineSeparator())
      },

      getLine: function(line) {var l = this.getLineHandle(line); return l && l.text},

      getLineHandle: function(line) {if (isLine(this, line)) { return getLine(this, line) }},
      getLineNumber: function(line) {return lineNo(line)},

      getLineHandleVisualStart: function(line) {
        if (typeof line == "number") { line = getLine(this, line); }
        return visualLine(line)
      },

      lineCount: function() {return this.size},
      firstLine: function() {return this.first},
      lastLine: function() {return this.first + this.size - 1},

      clipPos: function(pos) {return clipPos(this, pos)},

      getCursor: function(start) {
        var range = this.sel.primary(), pos;
        if (start == null || start == "head") { pos = range.head; }
        else if (start == "anchor") { pos = range.anchor; }
        else if (start == "end" || start == "to" || start === false) { pos = range.to(); }
        else { pos = range.from(); }
        return pos
      },
      listSelections: function() { return this.sel.ranges },
      somethingSelected: function() {return this.sel.somethingSelected()},

      setCursor: docMethodOp(function(line, ch, options) {
        setSimpleSelection(this, clipPos(this, typeof line == "number" ? Pos(line, ch || 0) : line), null, options);
      }),
      setSelection: docMethodOp(function(anchor, head, options) {
        setSimpleSelection(this, clipPos(this, anchor), clipPos(this, head || anchor), options);
      }),
      extendSelection: docMethodOp(function(head, other, options) {
        extendSelection(this, clipPos(this, head), other && clipPos(this, other), options);
      }),
      extendSelections: docMethodOp(function(heads, options) {
        extendSelections(this, clipPosArray(this, heads), options);
      }),
      extendSelectionsBy: docMethodOp(function(f, options) {
        var heads = map(this.sel.ranges, f);
        extendSelections(this, clipPosArray(this, heads), options);
      }),
      setSelections: docMethodOp(function(ranges, primary, options) {
        if (!ranges.length) { return }
        var out = [];
        for (var i = 0; i < ranges.length; i++)
          { out[i] = new Range(clipPos(this, ranges[i].anchor),
                             clipPos(this, ranges[i].head || ranges[i].anchor)); }
        if (primary == null) { primary = Math.min(ranges.length - 1, this.sel.primIndex); }
        setSelection(this, normalizeSelection(this.cm, out, primary), options);
      }),
      addSelection: docMethodOp(function(anchor, head, options) {
        var ranges = this.sel.ranges.slice(0);
        ranges.push(new Range(clipPos(this, anchor), clipPos(this, head || anchor)));
        setSelection(this, normalizeSelection(this.cm, ranges, ranges.length - 1), options);
      }),

      getSelection: function(lineSep) {
        var ranges = this.sel.ranges, lines;
        for (var i = 0; i < ranges.length; i++) {
          var sel = getBetween(this, ranges[i].from(), ranges[i].to());
          lines = lines ? lines.concat(sel) : sel;
        }
        if (lineSep === false) { return lines }
        else { return lines.join(lineSep || this.lineSeparator()) }
      },
      getSelections: function(lineSep) {
        var parts = [], ranges = this.sel.ranges;
        for (var i = 0; i < ranges.length; i++) {
          var sel = getBetween(this, ranges[i].from(), ranges[i].to());
          if (lineSep !== false) { sel = sel.join(lineSep || this.lineSeparator()); }
          parts[i] = sel;
        }
        return parts
      },
      replaceSelection: function(code, collapse, origin) {
        var dup = [];
        for (var i = 0; i < this.sel.ranges.length; i++)
          { dup[i] = code; }
        this.replaceSelections(dup, collapse, origin || "+input");
      },
      replaceSelections: docMethodOp(function(code, collapse, origin) {
        var changes = [], sel = this.sel;
        for (var i = 0; i < sel.ranges.length; i++) {
          var range = sel.ranges[i];
          changes[i] = {from: range.from(), to: range.to(), text: this.splitLines(code[i]), origin: origin};
        }
        var newSel = collapse && collapse != "end" && computeReplacedSel(this, changes, collapse);
        for (var i$1 = changes.length - 1; i$1 >= 0; i$1--)
          { makeChange(this, changes[i$1]); }
        if (newSel) { setSelectionReplaceHistory(this, newSel); }
        else if (this.cm) { ensureCursorVisible(this.cm); }
      }),
      undo: docMethodOp(function() {makeChangeFromHistory(this, "undo");}),
      redo: docMethodOp(function() {makeChangeFromHistory(this, "redo");}),
      undoSelection: docMethodOp(function() {makeChangeFromHistory(this, "undo", true);}),
      redoSelection: docMethodOp(function() {makeChangeFromHistory(this, "redo", true);}),

      setExtending: function(val) {this.extend = val;},
      getExtending: function() {return this.extend},

      historySize: function() {
        var hist = this.history, done = 0, undone = 0;
        for (var i = 0; i < hist.done.length; i++) { if (!hist.done[i].ranges) { ++done; } }
        for (var i$1 = 0; i$1 < hist.undone.length; i$1++) { if (!hist.undone[i$1].ranges) { ++undone; } }
        return {undo: done, redo: undone}
      },
      clearHistory: function() {
        var this$1 = this;

        this.history = new History(this.history);
        linkedDocs(this, function (doc) { return doc.history = this$1.history; }, true);
      },

      markClean: function() {
        this.cleanGeneration = this.changeGeneration(true);
      },
      changeGeneration: function(forceSplit) {
        if (forceSplit)
          { this.history.lastOp = this.history.lastSelOp = this.history.lastOrigin = null; }
        return this.history.generation
      },
      isClean: function (gen) {
        return this.history.generation == (gen || this.cleanGeneration)
      },

      getHistory: function() {
        return {done: copyHistoryArray(this.history.done),
                undone: copyHistoryArray(this.history.undone)}
      },
      setHistory: function(histData) {
        var hist = this.history = new History(this.history);
        hist.done = copyHistoryArray(histData.done.slice(0), null, true);
        hist.undone = copyHistoryArray(histData.undone.slice(0), null, true);
      },

      setGutterMarker: docMethodOp(function(line, gutterID, value) {
        return changeLine(this, line, "gutter", function (line) {
          var markers = line.gutterMarkers || (line.gutterMarkers = {});
          markers[gutterID] = value;
          if (!value && isEmpty(markers)) { line.gutterMarkers = null; }
          return true
        })
      }),

      clearGutter: docMethodOp(function(gutterID) {
        var this$1 = this;

        this.iter(function (line) {
          if (line.gutterMarkers && line.gutterMarkers[gutterID]) {
            changeLine(this$1, line, "gutter", function () {
              line.gutterMarkers[gutterID] = null;
              if (isEmpty(line.gutterMarkers)) { line.gutterMarkers = null; }
              return true
            });
          }
        });
      }),

      lineInfo: function(line) {
        var n;
        if (typeof line == "number") {
          if (!isLine(this, line)) { return null }
          n = line;
          line = getLine(this, line);
          if (!line) { return null }
        } else {
          n = lineNo(line);
          if (n == null) { return null }
        }
        return {line: n, handle: line, text: line.text, gutterMarkers: line.gutterMarkers,
                textClass: line.textClass, bgClass: line.bgClass, wrapClass: line.wrapClass,
                widgets: line.widgets}
      },

      addLineClass: docMethodOp(function(handle, where, cls) {
        return changeLine(this, handle, where == "gutter" ? "gutter" : "class", function (line) {
          var prop = where == "text" ? "textClass"
                   : where == "background" ? "bgClass"
                   : where == "gutter" ? "gutterClass" : "wrapClass";
          if (!line[prop]) { line[prop] = cls; }
          else if (classTest(cls).test(line[prop])) { return false }
          else { line[prop] += " " + cls; }
          return true
        })
      }),
      removeLineClass: docMethodOp(function(handle, where, cls) {
        return changeLine(this, handle, where == "gutter" ? "gutter" : "class", function (line) {
          var prop = where == "text" ? "textClass"
                   : where == "background" ? "bgClass"
                   : where == "gutter" ? "gutterClass" : "wrapClass";
          var cur = line[prop];
          if (!cur) { return false }
          else if (cls == null) { line[prop] = null; }
          else {
            var found = cur.match(classTest(cls));
            if (!found) { return false }
            var end = found.index + found[0].length;
            line[prop] = cur.slice(0, found.index) + (!found.index || end == cur.length ? "" : " ") + cur.slice(end) || null;
          }
          return true
        })
      }),

      addLineWidget: docMethodOp(function(handle, node, options) {
        return addLineWidget(this, handle, node, options)
      }),
      removeLineWidget: function(widget) { widget.clear(); },

      markText: function(from, to, options) {
        return markText(this, clipPos(this, from), clipPos(this, to), options, options && options.type || "range")
      },
      setBookmark: function(pos, options) {
        var realOpts = {replacedWith: options && (options.nodeType == null ? options.widget : options),
                        insertLeft: options && options.insertLeft,
                        clearWhenEmpty: false, shared: options && options.shared,
                        handleMouseEvents: options && options.handleMouseEvents};
        pos = clipPos(this, pos);
        return markText(this, pos, pos, realOpts, "bookmark")
      },
      findMarksAt: function(pos) {
        pos = clipPos(this, pos);
        var markers = [], spans = getLine(this, pos.line).markedSpans;
        if (spans) { for (var i = 0; i < spans.length; ++i) {
          var span = spans[i];
          if ((span.from == null || span.from <= pos.ch) &&
              (span.to == null || span.to >= pos.ch))
            { markers.push(span.marker.parent || span.marker); }
        } }
        return markers
      },
      findMarks: function(from, to, filter) {
        from = clipPos(this, from); to = clipPos(this, to);
        var found = [], lineNo = from.line;
        this.iter(from.line, to.line + 1, function (line) {
          var spans = line.markedSpans;
          if (spans) { for (var i = 0; i < spans.length; i++) {
            var span = spans[i];
            if (!(span.to != null && lineNo == from.line && from.ch >= span.to ||
                  span.from == null && lineNo != from.line ||
                  span.from != null && lineNo == to.line && span.from >= to.ch) &&
                (!filter || filter(span.marker)))
              { found.push(span.marker.parent || span.marker); }
          } }
          ++lineNo;
        });
        return found
      },
      getAllMarks: function() {
        var markers = [];
        this.iter(function (line) {
          var sps = line.markedSpans;
          if (sps) { for (var i = 0; i < sps.length; ++i)
            { if (sps[i].from != null) { markers.push(sps[i].marker); } } }
        });
        return markers
      },

      posFromIndex: function(off) {
        var ch, lineNo = this.first, sepSize = this.lineSeparator().length;
        this.iter(function (line) {
          var sz = line.text.length + sepSize;
          if (sz > off) { ch = off; return true }
          off -= sz;
          ++lineNo;
        });
        return clipPos(this, Pos(lineNo, ch))
      },
      indexFromPos: function (coords) {
        coords = clipPos(this, coords);
        var index = coords.ch;
        if (coords.line < this.first || coords.ch < 0) { return 0 }
        var sepSize = this.lineSeparator().length;
        this.iter(this.first, coords.line, function (line) { // iter aborts when callback returns a truthy value
          index += line.text.length + sepSize;
        });
        return index
      },

      copy: function(copyHistory) {
        var doc = new Doc(getLines(this, this.first, this.first + this.size),
                          this.modeOption, this.first, this.lineSep, this.direction);
        doc.scrollTop = this.scrollTop; doc.scrollLeft = this.scrollLeft;
        doc.sel = this.sel;
        doc.extend = false;
        if (copyHistory) {
          doc.history.undoDepth = this.history.undoDepth;
          doc.setHistory(this.getHistory());
        }
        return doc
      },

      linkedDoc: function(options) {
        if (!options) { options = {}; }
        var from = this.first, to = this.first + this.size;
        if (options.from != null && options.from > from) { from = options.from; }
        if (options.to != null && options.to < to) { to = options.to; }
        var copy = new Doc(getLines(this, from, to), options.mode || this.modeOption, from, this.lineSep, this.direction);
        if (options.sharedHist) { copy.history = this.history
        ; }(this.linked || (this.linked = [])).push({doc: copy, sharedHist: options.sharedHist});
        copy.linked = [{doc: this, isParent: true, sharedHist: options.sharedHist}];
        copySharedMarkers(copy, findSharedMarkers(this));
        return copy
      },
      unlinkDoc: function(other) {
        if (other instanceof CodeMirror) { other = other.doc; }
        if (this.linked) { for (var i = 0; i < this.linked.length; ++i) {
          var link = this.linked[i];
          if (link.doc != other) { continue }
          this.linked.splice(i, 1);
          other.unlinkDoc(this);
          detachSharedMarkers(findSharedMarkers(this));
          break
        } }
        // If the histories were shared, split them again
        if (other.history == this.history) {
          var splitIds = [other.id];
          linkedDocs(other, function (doc) { return splitIds.push(doc.id); }, true);
          other.history = new History(null);
          other.history.done = copyHistoryArray(this.history.done, splitIds);
          other.history.undone = copyHistoryArray(this.history.undone, splitIds);
        }
      },
      iterLinkedDocs: function(f) {linkedDocs(this, f);},

      getMode: function() {return this.mode},
      getEditor: function() {return this.cm},

      splitLines: function(str) {
        if (this.lineSep) { return str.split(this.lineSep) }
        return splitLinesAuto(str)
      },
      lineSeparator: function() { return this.lineSep || "\n" },

      setDirection: docMethodOp(function (dir) {
        if (dir != "rtl") { dir = "ltr"; }
        if (dir == this.direction) { return }
        this.direction = dir;
        this.iter(function (line) { return line.order = null; });
        if (this.cm) { directionChanged(this.cm); }
      })
    });

    // Public alias.
    Doc.prototype.eachLine = Doc.prototype.iter;

    // Kludge to work around strange IE behavior where it'll sometimes
    // re-fire a series of drag-related events right after the drop (#1551)
    var lastDrop = 0;

    function onDrop(e) {
      var cm = this;
      clearDragCursor(cm);
      if (signalDOMEvent(cm, e) || eventInWidget(cm.display, e))
        { return }
      e_preventDefault(e);
      if (ie) { lastDrop = +new Date; }
      var pos = posFromMouse(cm, e, true), files = e.dataTransfer.files;
      if (!pos || cm.isReadOnly()) { return }
      // Might be a file drop, in which case we simply extract the text
      // and insert it.
      if (files && files.length && window.FileReader && window.File) {
        var n = files.length, text = Array(n), read = 0;
        var markAsReadAndPasteIfAllFilesAreRead = function () {
          if (++read == n) {
            operation(cm, function () {
              pos = clipPos(cm.doc, pos);
              var change = {from: pos, to: pos,
                            text: cm.doc.splitLines(
                                text.filter(function (t) { return t != null; }).join(cm.doc.lineSeparator())),
                            origin: "paste"};
              makeChange(cm.doc, change);
              setSelectionReplaceHistory(cm.doc, simpleSelection(clipPos(cm.doc, pos), clipPos(cm.doc, changeEnd(change))));
            })();
          }
        };
        var readTextFromFile = function (file, i) {
          if (cm.options.allowDropFileTypes &&
              indexOf(cm.options.allowDropFileTypes, file.type) == -1) {
            markAsReadAndPasteIfAllFilesAreRead();
            return
          }
          var reader = new FileReader;
          reader.onerror = function () { return markAsReadAndPasteIfAllFilesAreRead(); };
          reader.onload = function () {
            var content = reader.result;
            if (/[\x00-\x08\x0e-\x1f]{2}/.test(content)) {
              markAsReadAndPasteIfAllFilesAreRead();
              return
            }
            text[i] = content;
            markAsReadAndPasteIfAllFilesAreRead();
          };
          reader.readAsText(file);
        };
        for (var i = 0; i < files.length; i++) { readTextFromFile(files[i], i); }
      } else { // Normal drop
        // Don't do a replace if the drop happened inside of the selected text.
        if (cm.state.draggingText && cm.doc.sel.contains(pos) > -1) {
          cm.state.draggingText(e);
          // Ensure the editor is re-focused
          setTimeout(function () { return cm.display.input.focus(); }, 20);
          return
        }
        try {
          var text$1 = e.dataTransfer.getData("Text");
          if (text$1) {
            var selected;
            if (cm.state.draggingText && !cm.state.draggingText.copy)
              { selected = cm.listSelections(); }
            setSelectionNoUndo(cm.doc, simpleSelection(pos, pos));
            if (selected) { for (var i$1 = 0; i$1 < selected.length; ++i$1)
              { replaceRange(cm.doc, "", selected[i$1].anchor, selected[i$1].head, "drag"); } }
            cm.replaceSelection(text$1, "around", "paste");
            cm.display.input.focus();
          }
        }
        catch(e$1){}
      }
    }

    function onDragStart(cm, e) {
      if (ie && (!cm.state.draggingText || +new Date - lastDrop < 100)) { e_stop(e); return }
      if (signalDOMEvent(cm, e) || eventInWidget(cm.display, e)) { return }

      e.dataTransfer.setData("Text", cm.getSelection());
      e.dataTransfer.effectAllowed = "copyMove";

      // Use dummy image instead of default browsers image.
      // Recent Safari (~6.0.2) have a tendency to segfault when this happens, so we don't do it there.
      if (e.dataTransfer.setDragImage && !safari) {
        var img = elt("img", null, null, "position: fixed; left: 0; top: 0;");
        img.src = "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";
        if (presto) {
          img.width = img.height = 1;
          cm.display.wrapper.appendChild(img);
          // Force a relayout, or Opera won't use our image for some obscure reason
          img._top = img.offsetTop;
        }
        e.dataTransfer.setDragImage(img, 0, 0);
        if (presto) { img.parentNode.removeChild(img); }
      }
    }

    function onDragOver(cm, e) {
      var pos = posFromMouse(cm, e);
      if (!pos) { return }
      var frag = document.createDocumentFragment();
      drawSelectionCursor(cm, pos, frag);
      if (!cm.display.dragCursor) {
        cm.display.dragCursor = elt("div", null, "CodeMirror-cursors CodeMirror-dragcursors");
        cm.display.lineSpace.insertBefore(cm.display.dragCursor, cm.display.cursorDiv);
      }
      removeChildrenAndAdd(cm.display.dragCursor, frag);
    }

    function clearDragCursor(cm) {
      if (cm.display.dragCursor) {
        cm.display.lineSpace.removeChild(cm.display.dragCursor);
        cm.display.dragCursor = null;
      }
    }

    // These must be handled carefully, because naively registering a
    // handler for each editor will cause the editors to never be
    // garbage collected.

    function forEachCodeMirror(f) {
      if (!document.getElementsByClassName) { return }
      var byClass = document.getElementsByClassName("CodeMirror"), editors = [];
      for (var i = 0; i < byClass.length; i++) {
        var cm = byClass[i].CodeMirror;
        if (cm) { editors.push(cm); }
      }
      if (editors.length) { editors[0].operation(function () {
        for (var i = 0; i < editors.length; i++) { f(editors[i]); }
      }); }
    }

    var globalsRegistered = false;
    function ensureGlobalHandlers() {
      if (globalsRegistered) { return }
      registerGlobalHandlers();
      globalsRegistered = true;
    }
    function registerGlobalHandlers() {
      // When the window resizes, we need to refresh active editors.
      var resizeTimer;
      on(window, "resize", function () {
        if (resizeTimer == null) { resizeTimer = setTimeout(function () {
          resizeTimer = null;
          forEachCodeMirror(onResize);
        }, 100); }
      });
      // When the window loses focus, we want to show the editor as blurred
      on(window, "blur", function () { return forEachCodeMirror(onBlur); });
    }
    // Called when the window resizes
    function onResize(cm) {
      var d = cm.display;
      // Might be a text scaling operation, clear size caches.
      d.cachedCharWidth = d.cachedTextHeight = d.cachedPaddingH = null;
      d.scrollbarsClipped = false;
      cm.setSize();
    }

    var keyNames = {
      3: "Pause", 8: "Backspace", 9: "Tab", 13: "Enter", 16: "Shift", 17: "Ctrl", 18: "Alt",
      19: "Pause", 20: "CapsLock", 27: "Esc", 32: "Space", 33: "PageUp", 34: "PageDown", 35: "End",
      36: "Home", 37: "Left", 38: "Up", 39: "Right", 40: "Down", 44: "PrintScrn", 45: "Insert",
      46: "Delete", 59: ";", 61: "=", 91: "Mod", 92: "Mod", 93: "Mod",
      106: "*", 107: "=", 109: "-", 110: ".", 111: "/", 145: "ScrollLock",
      173: "-", 186: ";", 187: "=", 188: ",", 189: "-", 190: ".", 191: "/", 192: "`", 219: "[", 220: "\\",
      221: "]", 222: "'", 224: "Mod", 63232: "Up", 63233: "Down", 63234: "Left", 63235: "Right", 63272: "Delete",
      63273: "Home", 63275: "End", 63276: "PageUp", 63277: "PageDown", 63302: "Insert"
    };

    // Number keys
    for (var i = 0; i < 10; i++) { keyNames[i + 48] = keyNames[i + 96] = String(i); }
    // Alphabetic keys
    for (var i$1 = 65; i$1 <= 90; i$1++) { keyNames[i$1] = String.fromCharCode(i$1); }
    // Function keys
    for (var i$2 = 1; i$2 <= 12; i$2++) { keyNames[i$2 + 111] = keyNames[i$2 + 63235] = "F" + i$2; }

    var keyMap = {};

    keyMap.basic = {
      "Left": "goCharLeft", "Right": "goCharRight", "Up": "goLineUp", "Down": "goLineDown",
      "End": "goLineEnd", "Home": "goLineStartSmart", "PageUp": "goPageUp", "PageDown": "goPageDown",
      "Delete": "delCharAfter", "Backspace": "delCharBefore", "Shift-Backspace": "delCharBefore",
      "Tab": "defaultTab", "Shift-Tab": "indentAuto",
      "Enter": "newlineAndIndent", "Insert": "toggleOverwrite",
      "Esc": "singleSelection"
    };
    // Note that the save and find-related commands aren't defined by
    // default. User code or addons can define them. Unknown commands
    // are simply ignored.
    keyMap.pcDefault = {
      "Ctrl-A": "selectAll", "Ctrl-D": "deleteLine", "Ctrl-Z": "undo", "Shift-Ctrl-Z": "redo", "Ctrl-Y": "redo",
      "Ctrl-Home": "goDocStart", "Ctrl-End": "goDocEnd", "Ctrl-Up": "goLineUp", "Ctrl-Down": "goLineDown",
      "Ctrl-Left": "goGroupLeft", "Ctrl-Right": "goGroupRight", "Alt-Left": "goLineStart", "Alt-Right": "goLineEnd",
      "Ctrl-Backspace": "delGroupBefore", "Ctrl-Delete": "delGroupAfter", "Ctrl-S": "save", "Ctrl-F": "find",
      "Ctrl-G": "findNext", "Shift-Ctrl-G": "findPrev", "Shift-Ctrl-F": "replace", "Shift-Ctrl-R": "replaceAll",
      "Ctrl-[": "indentLess", "Ctrl-]": "indentMore",
      "Ctrl-U": "undoSelection", "Shift-Ctrl-U": "redoSelection", "Alt-U": "redoSelection",
      "fallthrough": "basic"
    };
    // Very basic readline/emacs-style bindings, which are standard on Mac.
    keyMap.emacsy = {
      "Ctrl-F": "goCharRight", "Ctrl-B": "goCharLeft", "Ctrl-P": "goLineUp", "Ctrl-N": "goLineDown",
      "Alt-F": "goWordRight", "Alt-B": "goWordLeft", "Ctrl-A": "goLineStart", "Ctrl-E": "goLineEnd",
      "Ctrl-V": "goPageDown", "Shift-Ctrl-V": "goPageUp", "Ctrl-D": "delCharAfter", "Ctrl-H": "delCharBefore",
      "Alt-D": "delWordAfter", "Alt-Backspace": "delWordBefore", "Ctrl-K": "killLine", "Ctrl-T": "transposeChars",
      "Ctrl-O": "openLine"
    };
    keyMap.macDefault = {
      "Cmd-A": "selectAll", "Cmd-D": "deleteLine", "Cmd-Z": "undo", "Shift-Cmd-Z": "redo", "Cmd-Y": "redo",
      "Cmd-Home": "goDocStart", "Cmd-Up": "goDocStart", "Cmd-End": "goDocEnd", "Cmd-Down": "goDocEnd", "Alt-Left": "goGroupLeft",
      "Alt-Right": "goGroupRight", "Cmd-Left": "goLineLeft", "Cmd-Right": "goLineRight", "Alt-Backspace": "delGroupBefore",
      "Ctrl-Alt-Backspace": "delGroupAfter", "Alt-Delete": "delGroupAfter", "Cmd-S": "save", "Cmd-F": "find",
      "Cmd-G": "findNext", "Shift-Cmd-G": "findPrev", "Cmd-Alt-F": "replace", "Shift-Cmd-Alt-F": "replaceAll",
      "Cmd-[": "indentLess", "Cmd-]": "indentMore", "Cmd-Backspace": "delWrappedLineLeft", "Cmd-Delete": "delWrappedLineRight",
      "Cmd-U": "undoSelection", "Shift-Cmd-U": "redoSelection", "Ctrl-Up": "goDocStart", "Ctrl-Down": "goDocEnd",
      "fallthrough": ["basic", "emacsy"]
    };
    keyMap["default"] = mac ? keyMap.macDefault : keyMap.pcDefault;

    // KEYMAP DISPATCH

    function normalizeKeyName(name) {
      var parts = name.split(/-(?!$)/);
      name = parts[parts.length - 1];
      var alt, ctrl, shift, cmd;
      for (var i = 0; i < parts.length - 1; i++) {
        var mod = parts[i];
        if (/^(cmd|meta|m)$/i.test(mod)) { cmd = true; }
        else if (/^a(lt)?$/i.test(mod)) { alt = true; }
        else if (/^(c|ctrl|control)$/i.test(mod)) { ctrl = true; }
        else if (/^s(hift)?$/i.test(mod)) { shift = true; }
        else { throw new Error("Unrecognized modifier name: " + mod) }
      }
      if (alt) { name = "Alt-" + name; }
      if (ctrl) { name = "Ctrl-" + name; }
      if (cmd) { name = "Cmd-" + name; }
      if (shift) { name = "Shift-" + name; }
      return name
    }

    // This is a kludge to keep keymaps mostly working as raw objects
    // (backwards compatibility) while at the same time support features
    // like normalization and multi-stroke key bindings. It compiles a
    // new normalized keymap, and then updates the old object to reflect
    // this.
    function normalizeKeyMap(keymap) {
      var copy = {};
      for (var keyname in keymap) { if (keymap.hasOwnProperty(keyname)) {
        var value = keymap[keyname];
        if (/^(name|fallthrough|(de|at)tach)$/.test(keyname)) { continue }
        if (value == "...") { delete keymap[keyname]; continue }

        var keys = map(keyname.split(" "), normalizeKeyName);
        for (var i = 0; i < keys.length; i++) {
          var val = (void 0), name = (void 0);
          if (i == keys.length - 1) {
            name = keys.join(" ");
            val = value;
          } else {
            name = keys.slice(0, i + 1).join(" ");
            val = "...";
          }
          var prev = copy[name];
          if (!prev) { copy[name] = val; }
          else if (prev != val) { throw new Error("Inconsistent bindings for " + name) }
        }
        delete keymap[keyname];
      } }
      for (var prop in copy) { keymap[prop] = copy[prop]; }
      return keymap
    }

    function lookupKey(key, map, handle, context) {
      map = getKeyMap(map);
      var found = map.call ? map.call(key, context) : map[key];
      if (found === false) { return "nothing" }
      if (found === "...") { return "multi" }
      if (found != null && handle(found)) { return "handled" }

      if (map.fallthrough) {
        if (Object.prototype.toString.call(map.fallthrough) != "[object Array]")
          { return lookupKey(key, map.fallthrough, handle, context) }
        for (var i = 0; i < map.fallthrough.length; i++) {
          var result = lookupKey(key, map.fallthrough[i], handle, context);
          if (result) { return result }
        }
      }
    }

    // Modifier key presses don't count as 'real' key presses for the
    // purpose of keymap fallthrough.
    function isModifierKey(value) {
      var name = typeof value == "string" ? value : keyNames[value.keyCode];
      return name == "Ctrl" || name == "Alt" || name == "Shift" || name == "Mod"
    }

    function addModifierNames(name, event, noShift) {
      var base = name;
      if (event.altKey && base != "Alt") { name = "Alt-" + name; }
      if ((flipCtrlCmd ? event.metaKey : event.ctrlKey) && base != "Ctrl") { name = "Ctrl-" + name; }
      if ((flipCtrlCmd ? event.ctrlKey : event.metaKey) && base != "Mod") { name = "Cmd-" + name; }
      if (!noShift && event.shiftKey && base != "Shift") { name = "Shift-" + name; }
      return name
    }

    // Look up the name of a key as indicated by an event object.
    function keyName(event, noShift) {
      if (presto && event.keyCode == 34 && event["char"]) { return false }
      var name = keyNames[event.keyCode];
      if (name == null || event.altGraphKey) { return false }
      // Ctrl-ScrollLock has keyCode 3, same as Ctrl-Pause,
      // so we'll use event.code when available (Chrome 48+, FF 38+, Safari 10.1+)
      if (event.keyCode == 3 && event.code) { name = event.code; }
      return addModifierNames(name, event, noShift)
    }

    function getKeyMap(val) {
      return typeof val == "string" ? keyMap[val] : val
    }

    // Helper for deleting text near the selection(s), used to implement
    // backspace, delete, and similar functionality.
    function deleteNearSelection(cm, compute) {
      var ranges = cm.doc.sel.ranges, kill = [];
      // Build up a set of ranges to kill first, merging overlapping
      // ranges.
      for (var i = 0; i < ranges.length; i++) {
        var toKill = compute(ranges[i]);
        while (kill.length && cmp(toKill.from, lst(kill).to) <= 0) {
          var replaced = kill.pop();
          if (cmp(replaced.from, toKill.from) < 0) {
            toKill.from = replaced.from;
            break
          }
        }
        kill.push(toKill);
      }
      // Next, remove those actual ranges.
      runInOp(cm, function () {
        for (var i = kill.length - 1; i >= 0; i--)
          { replaceRange(cm.doc, "", kill[i].from, kill[i].to, "+delete"); }
        ensureCursorVisible(cm);
      });
    }

    function moveCharLogically(line, ch, dir) {
      var target = skipExtendingChars(line.text, ch + dir, dir);
      return target < 0 || target > line.text.length ? null : target
    }

    function moveLogically(line, start, dir) {
      var ch = moveCharLogically(line, start.ch, dir);
      return ch == null ? null : new Pos(start.line, ch, dir < 0 ? "after" : "before")
    }

    function endOfLine(visually, cm, lineObj, lineNo, dir) {
      if (visually) {
        if (cm.doc.direction == "rtl") { dir = -dir; }
        var order = getOrder(lineObj, cm.doc.direction);
        if (order) {
          var part = dir < 0 ? lst(order) : order[0];
          var moveInStorageOrder = (dir < 0) == (part.level == 1);
          var sticky = moveInStorageOrder ? "after" : "before";
          var ch;
          // With a wrapped rtl chunk (possibly spanning multiple bidi parts),
          // it could be that the last bidi part is not on the last visual line,
          // since visual lines contain content order-consecutive chunks.
          // Thus, in rtl, we are looking for the first (content-order) character
          // in the rtl chunk that is on the last line (that is, the same line
          // as the last (content-order) character).
          if (part.level > 0 || cm.doc.direction == "rtl") {
            var prep = prepareMeasureForLine(cm, lineObj);
            ch = dir < 0 ? lineObj.text.length - 1 : 0;
            var targetTop = measureCharPrepared(cm, prep, ch).top;
            ch = findFirst(function (ch) { return measureCharPrepared(cm, prep, ch).top == targetTop; }, (dir < 0) == (part.level == 1) ? part.from : part.to - 1, ch);
            if (sticky == "before") { ch = moveCharLogically(lineObj, ch, 1); }
          } else { ch = dir < 0 ? part.to : part.from; }
          return new Pos(lineNo, ch, sticky)
        }
      }
      return new Pos(lineNo, dir < 0 ? lineObj.text.length : 0, dir < 0 ? "before" : "after")
    }

    function moveVisually(cm, line, start, dir) {
      var bidi = getOrder(line, cm.doc.direction);
      if (!bidi) { return moveLogically(line, start, dir) }
      if (start.ch >= line.text.length) {
        start.ch = line.text.length;
        start.sticky = "before";
      } else if (start.ch <= 0) {
        start.ch = 0;
        start.sticky = "after";
      }
      var partPos = getBidiPartAt(bidi, start.ch, start.sticky), part = bidi[partPos];
      if (cm.doc.direction == "ltr" && part.level % 2 == 0 && (dir > 0 ? part.to > start.ch : part.from < start.ch)) {
        // Case 1: We move within an ltr part in an ltr editor. Even with wrapped lines,
        // nothing interesting happens.
        return moveLogically(line, start, dir)
      }

      var mv = function (pos, dir) { return moveCharLogically(line, pos instanceof Pos ? pos.ch : pos, dir); };
      var prep;
      var getWrappedLineExtent = function (ch) {
        if (!cm.options.lineWrapping) { return {begin: 0, end: line.text.length} }
        prep = prep || prepareMeasureForLine(cm, line);
        return wrappedLineExtentChar(cm, line, prep, ch)
      };
      var wrappedLineExtent = getWrappedLineExtent(start.sticky == "before" ? mv(start, -1) : start.ch);

      if (cm.doc.direction == "rtl" || part.level == 1) {
        var moveInStorageOrder = (part.level == 1) == (dir < 0);
        var ch = mv(start, moveInStorageOrder ? 1 : -1);
        if (ch != null && (!moveInStorageOrder ? ch >= part.from && ch >= wrappedLineExtent.begin : ch <= part.to && ch <= wrappedLineExtent.end)) {
          // Case 2: We move within an rtl part or in an rtl editor on the same visual line
          var sticky = moveInStorageOrder ? "before" : "after";
          return new Pos(start.line, ch, sticky)
        }
      }

      // Case 3: Could not move within this bidi part in this visual line, so leave
      // the current bidi part

      var searchInVisualLine = function (partPos, dir, wrappedLineExtent) {
        var getRes = function (ch, moveInStorageOrder) { return moveInStorageOrder
          ? new Pos(start.line, mv(ch, 1), "before")
          : new Pos(start.line, ch, "after"); };

        for (; partPos >= 0 && partPos < bidi.length; partPos += dir) {
          var part = bidi[partPos];
          var moveInStorageOrder = (dir > 0) == (part.level != 1);
          var ch = moveInStorageOrder ? wrappedLineExtent.begin : mv(wrappedLineExtent.end, -1);
          if (part.from <= ch && ch < part.to) { return getRes(ch, moveInStorageOrder) }
          ch = moveInStorageOrder ? part.from : mv(part.to, -1);
          if (wrappedLineExtent.begin <= ch && ch < wrappedLineExtent.end) { return getRes(ch, moveInStorageOrder) }
        }
      };

      // Case 3a: Look for other bidi parts on the same visual line
      var res = searchInVisualLine(partPos + dir, dir, wrappedLineExtent);
      if (res) { return res }

      // Case 3b: Look for other bidi parts on the next visual line
      var nextCh = dir > 0 ? wrappedLineExtent.end : mv(wrappedLineExtent.begin, -1);
      if (nextCh != null && !(dir > 0 && nextCh == line.text.length)) {
        res = searchInVisualLine(dir > 0 ? 0 : bidi.length - 1, dir, getWrappedLineExtent(nextCh));
        if (res) { return res }
      }

      // Case 4: Nowhere to move
      return null
    }

    // Commands are parameter-less actions that can be performed on an
    // editor, mostly used for keybindings.
    var commands = {
      selectAll: selectAll,
      singleSelection: function (cm) { return cm.setSelection(cm.getCursor("anchor"), cm.getCursor("head"), sel_dontScroll); },
      killLine: function (cm) { return deleteNearSelection(cm, function (range) {
        if (range.empty()) {
          var len = getLine(cm.doc, range.head.line).text.length;
          if (range.head.ch == len && range.head.line < cm.lastLine())
            { return {from: range.head, to: Pos(range.head.line + 1, 0)} }
          else
            { return {from: range.head, to: Pos(range.head.line, len)} }
        } else {
          return {from: range.from(), to: range.to()}
        }
      }); },
      deleteLine: function (cm) { return deleteNearSelection(cm, function (range) { return ({
        from: Pos(range.from().line, 0),
        to: clipPos(cm.doc, Pos(range.to().line + 1, 0))
      }); }); },
      delLineLeft: function (cm) { return deleteNearSelection(cm, function (range) { return ({
        from: Pos(range.from().line, 0), to: range.from()
      }); }); },
      delWrappedLineLeft: function (cm) { return deleteNearSelection(cm, function (range) {
        var top = cm.charCoords(range.head, "div").top + 5;
        var leftPos = cm.coordsChar({left: 0, top: top}, "div");
        return {from: leftPos, to: range.from()}
      }); },
      delWrappedLineRight: function (cm) { return deleteNearSelection(cm, function (range) {
        var top = cm.charCoords(range.head, "div").top + 5;
        var rightPos = cm.coordsChar({left: cm.display.lineDiv.offsetWidth + 100, top: top}, "div");
        return {from: range.from(), to: rightPos }
      }); },
      undo: function (cm) { return cm.undo(); },
      redo: function (cm) { return cm.redo(); },
      undoSelection: function (cm) { return cm.undoSelection(); },
      redoSelection: function (cm) { return cm.redoSelection(); },
      goDocStart: function (cm) { return cm.extendSelection(Pos(cm.firstLine(), 0)); },
      goDocEnd: function (cm) { return cm.extendSelection(Pos(cm.lastLine())); },
      goLineStart: function (cm) { return cm.extendSelectionsBy(function (range) { return lineStart(cm, range.head.line); },
        {origin: "+move", bias: 1}
      ); },
      goLineStartSmart: function (cm) { return cm.extendSelectionsBy(function (range) { return lineStartSmart(cm, range.head); },
        {origin: "+move", bias: 1}
      ); },
      goLineEnd: function (cm) { return cm.extendSelectionsBy(function (range) { return lineEnd(cm, range.head.line); },
        {origin: "+move", bias: -1}
      ); },
      goLineRight: function (cm) { return cm.extendSelectionsBy(function (range) {
        var top = cm.cursorCoords(range.head, "div").top + 5;
        return cm.coordsChar({left: cm.display.lineDiv.offsetWidth + 100, top: top}, "div")
      }, sel_move); },
      goLineLeft: function (cm) { return cm.extendSelectionsBy(function (range) {
        var top = cm.cursorCoords(range.head, "div").top + 5;
        return cm.coordsChar({left: 0, top: top}, "div")
      }, sel_move); },
      goLineLeftSmart: function (cm) { return cm.extendSelectionsBy(function (range) {
        var top = cm.cursorCoords(range.head, "div").top + 5;
        var pos = cm.coordsChar({left: 0, top: top}, "div");
        if (pos.ch < cm.getLine(pos.line).search(/\S/)) { return lineStartSmart(cm, range.head) }
        return pos
      }, sel_move); },
      goLineUp: function (cm) { return cm.moveV(-1, "line"); },
      goLineDown: function (cm) { return cm.moveV(1, "line"); },
      goPageUp: function (cm) { return cm.moveV(-1, "page"); },
      goPageDown: function (cm) { return cm.moveV(1, "page"); },
      goCharLeft: function (cm) { return cm.moveH(-1, "char"); },
      goCharRight: function (cm) { return cm.moveH(1, "char"); },
      goColumnLeft: function (cm) { return cm.moveH(-1, "column"); },
      goColumnRight: function (cm) { return cm.moveH(1, "column"); },
      goWordLeft: function (cm) { return cm.moveH(-1, "word"); },
      goGroupRight: function (cm) { return cm.moveH(1, "group"); },
      goGroupLeft: function (cm) { return cm.moveH(-1, "group"); },
      goWordRight: function (cm) { return cm.moveH(1, "word"); },
      delCharBefore: function (cm) { return cm.deleteH(-1, "codepoint"); },
      delCharAfter: function (cm) { return cm.deleteH(1, "char"); },
      delWordBefore: function (cm) { return cm.deleteH(-1, "word"); },
      delWordAfter: function (cm) { return cm.deleteH(1, "word"); },
      delGroupBefore: function (cm) { return cm.deleteH(-1, "group"); },
      delGroupAfter: function (cm) { return cm.deleteH(1, "group"); },
      indentAuto: function (cm) { return cm.indentSelection("smart"); },
      indentMore: function (cm) { return cm.indentSelection("add"); },
      indentLess: function (cm) { return cm.indentSelection("subtract"); },
      insertTab: function (cm) { return cm.replaceSelection("\t"); },
      insertSoftTab: function (cm) {
        var spaces = [], ranges = cm.listSelections(), tabSize = cm.options.tabSize;
        for (var i = 0; i < ranges.length; i++) {
          var pos = ranges[i].from();
          var col = countColumn(cm.getLine(pos.line), pos.ch, tabSize);
          spaces.push(spaceStr(tabSize - col % tabSize));
        }
        cm.replaceSelections(spaces);
      },
      defaultTab: function (cm) {
        if (cm.somethingSelected()) { cm.indentSelection("add"); }
        else { cm.execCommand("insertTab"); }
      },
      // Swap the two chars left and right of each selection's head.
      // Move cursor behind the two swapped characters afterwards.
      //
      // Doesn't consider line feeds a character.
      // Doesn't scan more than one line above to find a character.
      // Doesn't do anything on an empty line.
      // Doesn't do anything with non-empty selections.
      transposeChars: function (cm) { return runInOp(cm, function () {
        var ranges = cm.listSelections(), newSel = [];
        for (var i = 0; i < ranges.length; i++) {
          if (!ranges[i].empty()) { continue }
          var cur = ranges[i].head, line = getLine(cm.doc, cur.line).text;
          if (line) {
            if (cur.ch == line.length) { cur = new Pos(cur.line, cur.ch - 1); }
            if (cur.ch > 0) {
              cur = new Pos(cur.line, cur.ch + 1);
              cm.replaceRange(line.charAt(cur.ch - 1) + line.charAt(cur.ch - 2),
                              Pos(cur.line, cur.ch - 2), cur, "+transpose");
            } else if (cur.line > cm.doc.first) {
              var prev = getLine(cm.doc, cur.line - 1).text;
              if (prev) {
                cur = new Pos(cur.line, 1);
                cm.replaceRange(line.charAt(0) + cm.doc.lineSeparator() +
                                prev.charAt(prev.length - 1),
                                Pos(cur.line - 1, prev.length - 1), cur, "+transpose");
              }
            }
          }
          newSel.push(new Range(cur, cur));
        }
        cm.setSelections(newSel);
      }); },
      newlineAndIndent: function (cm) { return runInOp(cm, function () {
        var sels = cm.listSelections();
        for (var i = sels.length - 1; i >= 0; i--)
          { cm.replaceRange(cm.doc.lineSeparator(), sels[i].anchor, sels[i].head, "+input"); }
        sels = cm.listSelections();
        for (var i$1 = 0; i$1 < sels.length; i$1++)
          { cm.indentLine(sels[i$1].from().line, null, true); }
        ensureCursorVisible(cm);
      }); },
      openLine: function (cm) { return cm.replaceSelection("\n", "start"); },
      toggleOverwrite: function (cm) { return cm.toggleOverwrite(); }
    };


    function lineStart(cm, lineN) {
      var line = getLine(cm.doc, lineN);
      var visual = visualLine(line);
      if (visual != line) { lineN = lineNo(visual); }
      return endOfLine(true, cm, visual, lineN, 1)
    }
    function lineEnd(cm, lineN) {
      var line = getLine(cm.doc, lineN);
      var visual = visualLineEnd(line);
      if (visual != line) { lineN = lineNo(visual); }
      return endOfLine(true, cm, line, lineN, -1)
    }
    function lineStartSmart(cm, pos) {
      var start = lineStart(cm, pos.line);
      var line = getLine(cm.doc, start.line);
      var order = getOrder(line, cm.doc.direction);
      if (!order || order[0].level == 0) {
        var firstNonWS = Math.max(start.ch, line.text.search(/\S/));
        var inWS = pos.line == start.line && pos.ch <= firstNonWS && pos.ch;
        return Pos(start.line, inWS ? 0 : firstNonWS, start.sticky)
      }
      return start
    }

    // Run a handler that was bound to a key.
    function doHandleBinding(cm, bound, dropShift) {
      if (typeof bound == "string") {
        bound = commands[bound];
        if (!bound) { return false }
      }
      // Ensure previous input has been read, so that the handler sees a
      // consistent view of the document
      cm.display.input.ensurePolled();
      var prevShift = cm.display.shift, done = false;
      try {
        if (cm.isReadOnly()) { cm.state.suppressEdits = true; }
        if (dropShift) { cm.display.shift = false; }
        done = bound(cm) != Pass;
      } finally {
        cm.display.shift = prevShift;
        cm.state.suppressEdits = false;
      }
      return done
    }

    function lookupKeyForEditor(cm, name, handle) {
      for (var i = 0; i < cm.state.keyMaps.length; i++) {
        var result = lookupKey(name, cm.state.keyMaps[i], handle, cm);
        if (result) { return result }
      }
      return (cm.options.extraKeys && lookupKey(name, cm.options.extraKeys, handle, cm))
        || lookupKey(name, cm.options.keyMap, handle, cm)
    }

    // Note that, despite the name, this function is also used to check
    // for bound mouse clicks.

    var stopSeq = new Delayed;

    function dispatchKey(cm, name, e, handle) {
      var seq = cm.state.keySeq;
      if (seq) {
        if (isModifierKey(name)) { return "handled" }
        if (/\'$/.test(name))
          { cm.state.keySeq = null; }
        else
          { stopSeq.set(50, function () {
            if (cm.state.keySeq == seq) {
              cm.state.keySeq = null;
              cm.display.input.reset();
            }
          }); }
        if (dispatchKeyInner(cm, seq + " " + name, e, handle)) { return true }
      }
      return dispatchKeyInner(cm, name, e, handle)
    }

    function dispatchKeyInner(cm, name, e, handle) {
      var result = lookupKeyForEditor(cm, name, handle);

      if (result == "multi")
        { cm.state.keySeq = name; }
      if (result == "handled")
        { signalLater(cm, "keyHandled", cm, name, e); }

      if (result == "handled" || result == "multi") {
        e_preventDefault(e);
        restartBlink(cm);
      }

      return !!result
    }

    // Handle a key from the keydown event.
    function handleKeyBinding(cm, e) {
      var name = keyName(e, true);
      if (!name) { return false }

      if (e.shiftKey && !cm.state.keySeq) {
        // First try to resolve full name (including 'Shift-'). Failing
        // that, see if there is a cursor-motion command (starting with
        // 'go') bound to the keyname without 'Shift-'.
        return dispatchKey(cm, "Shift-" + name, e, function (b) { return doHandleBinding(cm, b, true); })
            || dispatchKey(cm, name, e, function (b) {
                 if (typeof b == "string" ? /^go[A-Z]/.test(b) : b.motion)
                   { return doHandleBinding(cm, b) }
               })
      } else {
        return dispatchKey(cm, name, e, function (b) { return doHandleBinding(cm, b); })
      }
    }

    // Handle a key from the keypress event
    function handleCharBinding(cm, e, ch) {
      return dispatchKey(cm, "'" + ch + "'", e, function (b) { return doHandleBinding(cm, b, true); })
    }

    var lastStoppedKey = null;
    function onKeyDown(e) {
      var cm = this;
      if (e.target && e.target != cm.display.input.getField()) { return }
      cm.curOp.focus = activeElt();
      if (signalDOMEvent(cm, e)) { return }
      // IE does strange things with escape.
      if (ie && ie_version < 11 && e.keyCode == 27) { e.returnValue = false; }
      var code = e.keyCode;
      cm.display.shift = code == 16 || e.shiftKey;
      var handled = handleKeyBinding(cm, e);
      if (presto) {
        lastStoppedKey = handled ? code : null;
        // Opera has no cut event... we try to at least catch the key combo
        if (!handled && code == 88 && !hasCopyEvent && (mac ? e.metaKey : e.ctrlKey))
          { cm.replaceSelection("", null, "cut"); }
      }
      if (gecko && !mac && !handled && code == 46 && e.shiftKey && !e.ctrlKey && document.execCommand)
        { document.execCommand("cut"); }

      // Turn mouse into crosshair when Alt is held on Mac.
      if (code == 18 && !/\bCodeMirror-crosshair\b/.test(cm.display.lineDiv.className))
        { showCrossHair(cm); }
    }

    function showCrossHair(cm) {
      var lineDiv = cm.display.lineDiv;
      addClass(lineDiv, "CodeMirror-crosshair");

      function up(e) {
        if (e.keyCode == 18 || !e.altKey) {
          rmClass(lineDiv, "CodeMirror-crosshair");
          off(document, "keyup", up);
          off(document, "mouseover", up);
        }
      }
      on(document, "keyup", up);
      on(document, "mouseover", up);
    }

    function onKeyUp(e) {
      if (e.keyCode == 16) { this.doc.sel.shift = false; }
      signalDOMEvent(this, e);
    }

    function onKeyPress(e) {
      var cm = this;
      if (e.target && e.target != cm.display.input.getField()) { return }
      if (eventInWidget(cm.display, e) || signalDOMEvent(cm, e) || e.ctrlKey && !e.altKey || mac && e.metaKey) { return }
      var keyCode = e.keyCode, charCode = e.charCode;
      if (presto && keyCode == lastStoppedKey) {lastStoppedKey = null; e_preventDefault(e); return}
      if ((presto && (!e.which || e.which < 10)) && handleKeyBinding(cm, e)) { return }
      var ch = String.fromCharCode(charCode == null ? keyCode : charCode);
      // Some browsers fire keypress events for backspace
      if (ch == "\x08") { return }
      if (handleCharBinding(cm, e, ch)) { return }
      cm.display.input.onKeyPress(e);
    }

    var DOUBLECLICK_DELAY = 400;

    var PastClick = function(time, pos, button) {
      this.time = time;
      this.pos = pos;
      this.button = button;
    };

    PastClick.prototype.compare = function (time, pos, button) {
      return this.time + DOUBLECLICK_DELAY > time &&
        cmp(pos, this.pos) == 0 && button == this.button
    };

    var lastClick, lastDoubleClick;
    function clickRepeat(pos, button) {
      var now = +new Date;
      if (lastDoubleClick && lastDoubleClick.compare(now, pos, button)) {
        lastClick = lastDoubleClick = null;
        return "triple"
      } else if (lastClick && lastClick.compare(now, pos, button)) {
        lastDoubleClick = new PastClick(now, pos, button);
        lastClick = null;
        return "double"
      } else {
        lastClick = new PastClick(now, pos, button);
        lastDoubleClick = null;
        return "single"
      }
    }

    // A mouse down can be a single click, double click, triple click,
    // start of selection drag, start of text drag, new cursor
    // (ctrl-click), rectangle drag (alt-drag), or xwin
    // middle-click-paste. Or it might be a click on something we should
    // not interfere with, such as a scrollbar or widget.
    function onMouseDown(e) {
      var cm = this, display = cm.display;
      if (signalDOMEvent(cm, e) || display.activeTouch && display.input.supportsTouch()) { return }
      display.input.ensurePolled();
      display.shift = e.shiftKey;

      if (eventInWidget(display, e)) {
        if (!webkit) {
          // Briefly turn off draggability, to allow widgets to do
          // normal dragging things.
          display.scroller.draggable = false;
          setTimeout(function () { return display.scroller.draggable = true; }, 100);
        }
        return
      }
      if (clickInGutter(cm, e)) { return }
      var pos = posFromMouse(cm, e), button = e_button(e), repeat = pos ? clickRepeat(pos, button) : "single";
      window.focus();

      // #3261: make sure, that we're not starting a second selection
      if (button == 1 && cm.state.selectingText)
        { cm.state.selectingText(e); }

      if (pos && handleMappedButton(cm, button, pos, repeat, e)) { return }

      if (button == 1) {
        if (pos) { leftButtonDown(cm, pos, repeat, e); }
        else if (e_target(e) == display.scroller) { e_preventDefault(e); }
      } else if (button == 2) {
        if (pos) { extendSelection(cm.doc, pos); }
        setTimeout(function () { return display.input.focus(); }, 20);
      } else if (button == 3) {
        if (captureRightClick) { cm.display.input.onContextMenu(e); }
        else { delayBlurEvent(cm); }
      }
    }

    function handleMappedButton(cm, button, pos, repeat, event) {
      var name = "Click";
      if (repeat == "double") { name = "Double" + name; }
      else if (repeat == "triple") { name = "Triple" + name; }
      name = (button == 1 ? "Left" : button == 2 ? "Middle" : "Right") + name;

      return dispatchKey(cm,  addModifierNames(name, event), event, function (bound) {
        if (typeof bound == "string") { bound = commands[bound]; }
        if (!bound) { return false }
        var done = false;
        try {
          if (cm.isReadOnly()) { cm.state.suppressEdits = true; }
          done = bound(cm, pos) != Pass;
        } finally {
          cm.state.suppressEdits = false;
        }
        return done
      })
    }

    function configureMouse(cm, repeat, event) {
      var option = cm.getOption("configureMouse");
      var value = option ? option(cm, repeat, event) : {};
      if (value.unit == null) {
        var rect = chromeOS ? event.shiftKey && event.metaKey : event.altKey;
        value.unit = rect ? "rectangle" : repeat == "single" ? "char" : repeat == "double" ? "word" : "line";
      }
      if (value.extend == null || cm.doc.extend) { value.extend = cm.doc.extend || event.shiftKey; }
      if (value.addNew == null) { value.addNew = mac ? event.metaKey : event.ctrlKey; }
      if (value.moveOnDrag == null) { value.moveOnDrag = !(mac ? event.altKey : event.ctrlKey); }
      return value
    }

    function leftButtonDown(cm, pos, repeat, event) {
      if (ie) { setTimeout(bind(ensureFocus, cm), 0); }
      else { cm.curOp.focus = activeElt(); }

      var behavior = configureMouse(cm, repeat, event);

      var sel = cm.doc.sel, contained;
      if (cm.options.dragDrop && dragAndDrop && !cm.isReadOnly() &&
          repeat == "single" && (contained = sel.contains(pos)) > -1 &&
          (cmp((contained = sel.ranges[contained]).from(), pos) < 0 || pos.xRel > 0) &&
          (cmp(contained.to(), pos) > 0 || pos.xRel < 0))
        { leftButtonStartDrag(cm, event, pos, behavior); }
      else
        { leftButtonSelect(cm, event, pos, behavior); }
    }

    // Start a text drag. When it ends, see if any dragging actually
    // happen, and treat as a click if it didn't.
    function leftButtonStartDrag(cm, event, pos, behavior) {
      var display = cm.display, moved = false;
      var dragEnd = operation(cm, function (e) {
        if (webkit) { display.scroller.draggable = false; }
        cm.state.draggingText = false;
        if (cm.state.delayingBlurEvent) {
          if (cm.hasFocus()) { cm.state.delayingBlurEvent = false; }
          else { delayBlurEvent(cm); }
        }
        off(display.wrapper.ownerDocument, "mouseup", dragEnd);
        off(display.wrapper.ownerDocument, "mousemove", mouseMove);
        off(display.scroller, "dragstart", dragStart);
        off(display.scroller, "drop", dragEnd);
        if (!moved) {
          e_preventDefault(e);
          if (!behavior.addNew)
            { extendSelection(cm.doc, pos, null, null, behavior.extend); }
          // Work around unexplainable focus problem in IE9 (#2127) and Chrome (#3081)
          if ((webkit && !safari) || ie && ie_version == 9)
            { setTimeout(function () {display.wrapper.ownerDocument.body.focus({preventScroll: true}); display.input.focus();}, 20); }
          else
            { display.input.focus(); }
        }
      });
      var mouseMove = function(e2) {
        moved = moved || Math.abs(event.clientX - e2.clientX) + Math.abs(event.clientY - e2.clientY) >= 10;
      };
      var dragStart = function () { return moved = true; };
      // Let the drag handler handle this.
      if (webkit) { display.scroller.draggable = true; }
      cm.state.draggingText = dragEnd;
      dragEnd.copy = !behavior.moveOnDrag;
      on(display.wrapper.ownerDocument, "mouseup", dragEnd);
      on(display.wrapper.ownerDocument, "mousemove", mouseMove);
      on(display.scroller, "dragstart", dragStart);
      on(display.scroller, "drop", dragEnd);

      cm.state.delayingBlurEvent = true;
      setTimeout(function () { return display.input.focus(); }, 20);
      // IE's approach to draggable
      if (display.scroller.dragDrop) { display.scroller.dragDrop(); }
    }

    function rangeForUnit(cm, pos, unit) {
      if (unit == "char") { return new Range(pos, pos) }
      if (unit == "word") { return cm.findWordAt(pos) }
      if (unit == "line") { return new Range(Pos(pos.line, 0), clipPos(cm.doc, Pos(pos.line + 1, 0))) }
      var result = unit(cm, pos);
      return new Range(result.from, result.to)
    }

    // Normal selection, as opposed to text dragging.
    function leftButtonSelect(cm, event, start, behavior) {
      if (ie) { delayBlurEvent(cm); }
      var display = cm.display, doc = cm.doc;
      e_preventDefault(event);

      var ourRange, ourIndex, startSel = doc.sel, ranges = startSel.ranges;
      if (behavior.addNew && !behavior.extend) {
        ourIndex = doc.sel.contains(start);
        if (ourIndex > -1)
          { ourRange = ranges[ourIndex]; }
        else
          { ourRange = new Range(start, start); }
      } else {
        ourRange = doc.sel.primary();
        ourIndex = doc.sel.primIndex;
      }

      if (behavior.unit == "rectangle") {
        if (!behavior.addNew) { ourRange = new Range(start, start); }
        start = posFromMouse(cm, event, true, true);
        ourIndex = -1;
      } else {
        var range = rangeForUnit(cm, start, behavior.unit);
        if (behavior.extend)
          { ourRange = extendRange(ourRange, range.anchor, range.head, behavior.extend); }
        else
          { ourRange = range; }
      }

      if (!behavior.addNew) {
        ourIndex = 0;
        setSelection(doc, new Selection([ourRange], 0), sel_mouse);
        startSel = doc.sel;
      } else if (ourIndex == -1) {
        ourIndex = ranges.length;
        setSelection(doc, normalizeSelection(cm, ranges.concat([ourRange]), ourIndex),
                     {scroll: false, origin: "*mouse"});
      } else if (ranges.length > 1 && ranges[ourIndex].empty() && behavior.unit == "char" && !behavior.extend) {
        setSelection(doc, normalizeSelection(cm, ranges.slice(0, ourIndex).concat(ranges.slice(ourIndex + 1)), 0),
                     {scroll: false, origin: "*mouse"});
        startSel = doc.sel;
      } else {
        replaceOneSelection(doc, ourIndex, ourRange, sel_mouse);
      }

      var lastPos = start;
      function extendTo(pos) {
        if (cmp(lastPos, pos) == 0) { return }
        lastPos = pos;

        if (behavior.unit == "rectangle") {
          var ranges = [], tabSize = cm.options.tabSize;
          var startCol = countColumn(getLine(doc, start.line).text, start.ch, tabSize);
          var posCol = countColumn(getLine(doc, pos.line).text, pos.ch, tabSize);
          var left = Math.min(startCol, posCol), right = Math.max(startCol, posCol);
          for (var line = Math.min(start.line, pos.line), end = Math.min(cm.lastLine(), Math.max(start.line, pos.line));
               line <= end; line++) {
            var text = getLine(doc, line).text, leftPos = findColumn(text, left, tabSize);
            if (left == right)
              { ranges.push(new Range(Pos(line, leftPos), Pos(line, leftPos))); }
            else if (text.length > leftPos)
              { ranges.push(new Range(Pos(line, leftPos), Pos(line, findColumn(text, right, tabSize)))); }
          }
          if (!ranges.length) { ranges.push(new Range(start, start)); }
          setSelection(doc, normalizeSelection(cm, startSel.ranges.slice(0, ourIndex).concat(ranges), ourIndex),
                       {origin: "*mouse", scroll: false});
          cm.scrollIntoView(pos);
        } else {
          var oldRange = ourRange;
          var range = rangeForUnit(cm, pos, behavior.unit);
          var anchor = oldRange.anchor, head;
          if (cmp(range.anchor, anchor) > 0) {
            head = range.head;
            anchor = minPos(oldRange.from(), range.anchor);
          } else {
            head = range.anchor;
            anchor = maxPos(oldRange.to(), range.head);
          }
          var ranges$1 = startSel.ranges.slice(0);
          ranges$1[ourIndex] = bidiSimplify(cm, new Range(clipPos(doc, anchor), head));
          setSelection(doc, normalizeSelection(cm, ranges$1, ourIndex), sel_mouse);
        }
      }

      var editorSize = display.wrapper.getBoundingClientRect();
      // Used to ensure timeout re-tries don't fire when another extend
      // happened in the meantime (clearTimeout isn't reliable -- at
      // least on Chrome, the timeouts still happen even when cleared,
      // if the clear happens after their scheduled firing time).
      var counter = 0;

      function extend(e) {
        var curCount = ++counter;
        var cur = posFromMouse(cm, e, true, behavior.unit == "rectangle");
        if (!cur) { return }
        if (cmp(cur, lastPos) != 0) {
          cm.curOp.focus = activeElt();
          extendTo(cur);
          var visible = visibleLines(display, doc);
          if (cur.line >= visible.to || cur.line < visible.from)
            { setTimeout(operation(cm, function () {if (counter == curCount) { extend(e); }}), 150); }
        } else {
          var outside = e.clientY < editorSize.top ? -20 : e.clientY > editorSize.bottom ? 20 : 0;
          if (outside) { setTimeout(operation(cm, function () {
            if (counter != curCount) { return }
            display.scroller.scrollTop += outside;
            extend(e);
          }), 50); }
        }
      }

      function done(e) {
        cm.state.selectingText = false;
        counter = Infinity;
        // If e is null or undefined we interpret this as someone trying
        // to explicitly cancel the selection rather than the user
        // letting go of the mouse button.
        if (e) {
          e_preventDefault(e);
          display.input.focus();
        }
        off(display.wrapper.ownerDocument, "mousemove", move);
        off(display.wrapper.ownerDocument, "mouseup", up);
        doc.history.lastSelOrigin = null;
      }

      var move = operation(cm, function (e) {
        if (e.buttons === 0 || !e_button(e)) { done(e); }
        else { extend(e); }
      });
      var up = operation(cm, done);
      cm.state.selectingText = up;
      on(display.wrapper.ownerDocument, "mousemove", move);
      on(display.wrapper.ownerDocument, "mouseup", up);
    }

    // Used when mouse-selecting to adjust the anchor to the proper side
    // of a bidi jump depending on the visual position of the head.
    function bidiSimplify(cm, range) {
      var anchor = range.anchor;
      var head = range.head;
      var anchorLine = getLine(cm.doc, anchor.line);
      if (cmp(anchor, head) == 0 && anchor.sticky == head.sticky) { return range }
      var order = getOrder(anchorLine);
      if (!order) { return range }
      var index = getBidiPartAt(order, anchor.ch, anchor.sticky), part = order[index];
      if (part.from != anchor.ch && part.to != anchor.ch) { return range }
      var boundary = index + ((part.from == anchor.ch) == (part.level != 1) ? 0 : 1);
      if (boundary == 0 || boundary == order.length) { return range }

      // Compute the relative visual position of the head compared to the
      // anchor (<0 is to the left, >0 to the right)
      var leftSide;
      if (head.line != anchor.line) {
        leftSide = (head.line - anchor.line) * (cm.doc.direction == "ltr" ? 1 : -1) > 0;
      } else {
        var headIndex = getBidiPartAt(order, head.ch, head.sticky);
        var dir = headIndex - index || (head.ch - anchor.ch) * (part.level == 1 ? -1 : 1);
        if (headIndex == boundary - 1 || headIndex == boundary)
          { leftSide = dir < 0; }
        else
          { leftSide = dir > 0; }
      }

      var usePart = order[boundary + (leftSide ? -1 : 0)];
      var from = leftSide == (usePart.level == 1);
      var ch = from ? usePart.from : usePart.to, sticky = from ? "after" : "before";
      return anchor.ch == ch && anchor.sticky == sticky ? range : new Range(new Pos(anchor.line, ch, sticky), head)
    }


    // Determines whether an event happened in the gutter, and fires the
    // handlers for the corresponding event.
    function gutterEvent(cm, e, type, prevent) {
      var mX, mY;
      if (e.touches) {
        mX = e.touches[0].clientX;
        mY = e.touches[0].clientY;
      } else {
        try { mX = e.clientX; mY = e.clientY; }
        catch(e$1) { return false }
      }
      if (mX >= Math.floor(cm.display.gutters.getBoundingClientRect().right)) { return false }
      if (prevent) { e_preventDefault(e); }

      var display = cm.display;
      var lineBox = display.lineDiv.getBoundingClientRect();

      if (mY > lineBox.bottom || !hasHandler(cm, type)) { return e_defaultPrevented(e) }
      mY -= lineBox.top - display.viewOffset;

      for (var i = 0; i < cm.display.gutterSpecs.length; ++i) {
        var g = display.gutters.childNodes[i];
        if (g && g.getBoundingClientRect().right >= mX) {
          var line = lineAtHeight(cm.doc, mY);
          var gutter = cm.display.gutterSpecs[i];
          signal(cm, type, cm, line, gutter.className, e);
          return e_defaultPrevented(e)
        }
      }
    }

    function clickInGutter(cm, e) {
      return gutterEvent(cm, e, "gutterClick", true)
    }

    // CONTEXT MENU HANDLING

    // To make the context menu work, we need to briefly unhide the
    // textarea (making it as unobtrusive as possible) to let the
    // right-click take effect on it.
    function onContextMenu(cm, e) {
      if (eventInWidget(cm.display, e) || contextMenuInGutter(cm, e)) { return }
      if (signalDOMEvent(cm, e, "contextmenu")) { return }
      if (!captureRightClick) { cm.display.input.onContextMenu(e); }
    }

    function contextMenuInGutter(cm, e) {
      if (!hasHandler(cm, "gutterContextMenu")) { return false }
      return gutterEvent(cm, e, "gutterContextMenu", false)
    }

    function themeChanged(cm) {
      cm.display.wrapper.className = cm.display.wrapper.className.replace(/\s*cm-s-\S+/g, "") +
        cm.options.theme.replace(/(^|\s)\s*/g, " cm-s-");
      clearCaches(cm);
    }

    var Init = {toString: function(){return "CodeMirror.Init"}};

    var defaults = {};
    var optionHandlers = {};

    function defineOptions(CodeMirror) {
      var optionHandlers = CodeMirror.optionHandlers;

      function option(name, deflt, handle, notOnInit) {
        CodeMirror.defaults[name] = deflt;
        if (handle) { optionHandlers[name] =
          notOnInit ? function (cm, val, old) {if (old != Init) { handle(cm, val, old); }} : handle; }
      }

      CodeMirror.defineOption = option;

      // Passed to option handlers when there is no old value.
      CodeMirror.Init = Init;

      // These two are, on init, called from the constructor because they
      // have to be initialized before the editor can start at all.
      option("value", "", function (cm, val) { return cm.setValue(val); }, true);
      option("mode", null, function (cm, val) {
        cm.doc.modeOption = val;
        loadMode(cm);
      }, true);

      option("indentUnit", 2, loadMode, true);
      option("indentWithTabs", false);
      option("smartIndent", true);
      option("tabSize", 4, function (cm) {
        resetModeState(cm);
        clearCaches(cm);
        regChange(cm);
      }, true);

      option("lineSeparator", null, function (cm, val) {
        cm.doc.lineSep = val;
        if (!val) { return }
        var newBreaks = [], lineNo = cm.doc.first;
        cm.doc.iter(function (line) {
          for (var pos = 0;;) {
            var found = line.text.indexOf(val, pos);
            if (found == -1) { break }
            pos = found + val.length;
            newBreaks.push(Pos(lineNo, found));
          }
          lineNo++;
        });
        for (var i = newBreaks.length - 1; i >= 0; i--)
          { replaceRange(cm.doc, val, newBreaks[i], Pos(newBreaks[i].line, newBreaks[i].ch + val.length)); }
      });
      option("specialChars", /[\u0000-\u001f\u007f-\u009f\u00ad\u061c\u200b\u200e\u200f\u2028\u2029\ufeff\ufff9-\ufffc]/g, function (cm, val, old) {
        cm.state.specialChars = new RegExp(val.source + (val.test("\t") ? "" : "|\t"), "g");
        if (old != Init) { cm.refresh(); }
      });
      option("specialCharPlaceholder", defaultSpecialCharPlaceholder, function (cm) { return cm.refresh(); }, true);
      option("electricChars", true);
      option("inputStyle", mobile ? "contenteditable" : "textarea", function () {
        throw new Error("inputStyle can not (yet) be changed in a running editor") // FIXME
      }, true);
      option("spellcheck", false, function (cm, val) { return cm.getInputField().spellcheck = val; }, true);
      option("autocorrect", false, function (cm, val) { return cm.getInputField().autocorrect = val; }, true);
      option("autocapitalize", false, function (cm, val) { return cm.getInputField().autocapitalize = val; }, true);
      option("rtlMoveVisually", !windows);
      option("wholeLineUpdateBefore", true);

      option("theme", "default", function (cm) {
        themeChanged(cm);
        updateGutters(cm);
      }, true);
      option("keyMap", "default", function (cm, val, old) {
        var next = getKeyMap(val);
        var prev = old != Init && getKeyMap(old);
        if (prev && prev.detach) { prev.detach(cm, next); }
        if (next.attach) { next.attach(cm, prev || null); }
      });
      option("extraKeys", null);
      option("configureMouse", null);

      option("lineWrapping", false, wrappingChanged, true);
      option("gutters", [], function (cm, val) {
        cm.display.gutterSpecs = getGutters(val, cm.options.lineNumbers);
        updateGutters(cm);
      }, true);
      option("fixedGutter", true, function (cm, val) {
        cm.display.gutters.style.left = val ? compensateForHScroll(cm.display) + "px" : "0";
        cm.refresh();
      }, true);
      option("coverGutterNextToScrollbar", false, function (cm) { return updateScrollbars(cm); }, true);
      option("scrollbarStyle", "native", function (cm) {
        initScrollbars(cm);
        updateScrollbars(cm);
        cm.display.scrollbars.setScrollTop(cm.doc.scrollTop);
        cm.display.scrollbars.setScrollLeft(cm.doc.scrollLeft);
      }, true);
      option("lineNumbers", false, function (cm, val) {
        cm.display.gutterSpecs = getGutters(cm.options.gutters, val);
        updateGutters(cm);
      }, true);
      option("firstLineNumber", 1, updateGutters, true);
      option("lineNumberFormatter", function (integer) { return integer; }, updateGutters, true);
      option("showCursorWhenSelecting", false, updateSelection, true);

      option("resetSelectionOnContextMenu", true);
      option("lineWiseCopyCut", true);
      option("pasteLinesPerSelection", true);
      option("selectionsMayTouch", false);

      option("readOnly", false, function (cm, val) {
        if (val == "nocursor") {
          onBlur(cm);
          cm.display.input.blur();
        }
        cm.display.input.readOnlyChanged(val);
      });

      option("screenReaderLabel", null, function (cm, val) {
        val = (val === '') ? null : val;
        cm.display.input.screenReaderLabelChanged(val);
      });

      option("disableInput", false, function (cm, val) {if (!val) { cm.display.input.reset(); }}, true);
      option("dragDrop", true, dragDropChanged);
      option("allowDropFileTypes", null);

      option("cursorBlinkRate", 530);
      option("cursorScrollMargin", 0);
      option("cursorHeight", 1, updateSelection, true);
      option("singleCursorHeightPerLine", true, updateSelection, true);
      option("workTime", 100);
      option("workDelay", 100);
      option("flattenSpans", true, resetModeState, true);
      option("addModeClass", false, resetModeState, true);
      option("pollInterval", 100);
      option("undoDepth", 200, function (cm, val) { return cm.doc.history.undoDepth = val; });
      option("historyEventDelay", 1250);
      option("viewportMargin", 10, function (cm) { return cm.refresh(); }, true);
      option("maxHighlightLength", 10000, resetModeState, true);
      option("moveInputWithCursor", true, function (cm, val) {
        if (!val) { cm.display.input.resetPosition(); }
      });

      option("tabindex", null, function (cm, val) { return cm.display.input.getField().tabIndex = val || ""; });
      option("autofocus", null);
      option("direction", "ltr", function (cm, val) { return cm.doc.setDirection(val); }, true);
      option("phrases", null);
    }

    function dragDropChanged(cm, value, old) {
      var wasOn = old && old != Init;
      if (!value != !wasOn) {
        var funcs = cm.display.dragFunctions;
        var toggle = value ? on : off;
        toggle(cm.display.scroller, "dragstart", funcs.start);
        toggle(cm.display.scroller, "dragenter", funcs.enter);
        toggle(cm.display.scroller, "dragover", funcs.over);
        toggle(cm.display.scroller, "dragleave", funcs.leave);
        toggle(cm.display.scroller, "drop", funcs.drop);
      }
    }

    function wrappingChanged(cm) {
      if (cm.options.lineWrapping) {
        addClass(cm.display.wrapper, "CodeMirror-wrap");
        cm.display.sizer.style.minWidth = "";
        cm.display.sizerWidth = null;
      } else {
        rmClass(cm.display.wrapper, "CodeMirror-wrap");
        findMaxLine(cm);
      }
      estimateLineHeights(cm);
      regChange(cm);
      clearCaches(cm);
      setTimeout(function () { return updateScrollbars(cm); }, 100);
    }

    // A CodeMirror instance represents an editor. This is the object
    // that user code is usually dealing with.

    function CodeMirror(place, options) {
      var this$1 = this;

      if (!(this instanceof CodeMirror)) { return new CodeMirror(place, options) }

      this.options = options = options ? copyObj(options) : {};
      // Determine effective options based on given values and defaults.
      copyObj(defaults, options, false);

      var doc = options.value;
      if (typeof doc == "string") { doc = new Doc(doc, options.mode, null, options.lineSeparator, options.direction); }
      else if (options.mode) { doc.modeOption = options.mode; }
      this.doc = doc;

      var input = new CodeMirror.inputStyles[options.inputStyle](this);
      var display = this.display = new Display(place, doc, input, options);
      display.wrapper.CodeMirror = this;
      themeChanged(this);
      if (options.lineWrapping)
        { this.display.wrapper.className += " CodeMirror-wrap"; }
      initScrollbars(this);

      this.state = {
        keyMaps: [],  // stores maps added by addKeyMap
        overlays: [], // highlighting overlays, as added by addOverlay
        modeGen: 0,   // bumped when mode/overlay changes, used to invalidate highlighting info
        overwrite: false,
        delayingBlurEvent: false,
        focused: false,
        suppressEdits: false, // used to disable editing during key handlers when in readOnly mode
        pasteIncoming: -1, cutIncoming: -1, // help recognize paste/cut edits in input.poll
        selectingText: false,
        draggingText: false,
        highlight: new Delayed(), // stores highlight worker timeout
        keySeq: null,  // Unfinished key sequence
        specialChars: null
      };

      if (options.autofocus && !mobile) { display.input.focus(); }

      // Override magic textarea content restore that IE sometimes does
      // on our hidden textarea on reload
      if (ie && ie_version < 11) { setTimeout(function () { return this$1.display.input.reset(true); }, 20); }

      registerEventHandlers(this);
      ensureGlobalHandlers();

      startOperation(this);
      this.curOp.forceUpdate = true;
      attachDoc(this, doc);

      if ((options.autofocus && !mobile) || this.hasFocus())
        { setTimeout(function () {
          if (this$1.hasFocus() && !this$1.state.focused) { onFocus(this$1); }
        }, 20); }
      else
        { onBlur(this); }

      for (var opt in optionHandlers) { if (optionHandlers.hasOwnProperty(opt))
        { optionHandlers[opt](this, options[opt], Init); } }
      maybeUpdateLineNumberWidth(this);
      if (options.finishInit) { options.finishInit(this); }
      for (var i = 0; i < initHooks.length; ++i) { initHooks[i](this); }
      endOperation(this);
      // Suppress optimizelegibility in Webkit, since it breaks text
      // measuring on line wrapping boundaries.
      if (webkit && options.lineWrapping &&
          getComputedStyle(display.lineDiv).textRendering == "optimizelegibility")
        { display.lineDiv.style.textRendering = "auto"; }
    }

    // The default configuration options.
    CodeMirror.defaults = defaults;
    // Functions to run when options are changed.
    CodeMirror.optionHandlers = optionHandlers;

    // Attach the necessary event handlers when initializing the editor
    function registerEventHandlers(cm) {
      var d = cm.display;
      on(d.scroller, "mousedown", operation(cm, onMouseDown));
      // Older IE's will not fire a second mousedown for a double click
      if (ie && ie_version < 11)
        { on(d.scroller, "dblclick", operation(cm, function (e) {
          if (signalDOMEvent(cm, e)) { return }
          var pos = posFromMouse(cm, e);
          if (!pos || clickInGutter(cm, e) || eventInWidget(cm.display, e)) { return }
          e_preventDefault(e);
          var word = cm.findWordAt(pos);
          extendSelection(cm.doc, word.anchor, word.head);
        })); }
      else
        { on(d.scroller, "dblclick", function (e) { return signalDOMEvent(cm, e) || e_preventDefault(e); }); }
      // Some browsers fire contextmenu *after* opening the menu, at
      // which point we can't mess with it anymore. Context menu is
      // handled in onMouseDown for these browsers.
      on(d.scroller, "contextmenu", function (e) { return onContextMenu(cm, e); });
      on(d.input.getField(), "contextmenu", function (e) {
        if (!d.scroller.contains(e.target)) { onContextMenu(cm, e); }
      });

      // Used to suppress mouse event handling when a touch happens
      var touchFinished, prevTouch = {end: 0};
      function finishTouch() {
        if (d.activeTouch) {
          touchFinished = setTimeout(function () { return d.activeTouch = null; }, 1000);
          prevTouch = d.activeTouch;
          prevTouch.end = +new Date;
        }
      }
      function isMouseLikeTouchEvent(e) {
        if (e.touches.length != 1) { return false }
        var touch = e.touches[0];
        return touch.radiusX <= 1 && touch.radiusY <= 1
      }
      function farAway(touch, other) {
        if (other.left == null) { return true }
        var dx = other.left - touch.left, dy = other.top - touch.top;
        return dx * dx + dy * dy > 20 * 20
      }
      on(d.scroller, "touchstart", function (e) {
        if (!signalDOMEvent(cm, e) && !isMouseLikeTouchEvent(e) && !clickInGutter(cm, e)) {
          d.input.ensurePolled();
          clearTimeout(touchFinished);
          var now = +new Date;
          d.activeTouch = {start: now, moved: false,
                           prev: now - prevTouch.end <= 300 ? prevTouch : null};
          if (e.touches.length == 1) {
            d.activeTouch.left = e.touches[0].pageX;
            d.activeTouch.top = e.touches[0].pageY;
          }
        }
      });
      on(d.scroller, "touchmove", function () {
        if (d.activeTouch) { d.activeTouch.moved = true; }
      });
      on(d.scroller, "touchend", function (e) {
        var touch = d.activeTouch;
        if (touch && !eventInWidget(d, e) && touch.left != null &&
            !touch.moved && new Date - touch.start < 300) {
          var pos = cm.coordsChar(d.activeTouch, "page"), range;
          if (!touch.prev || farAway(touch, touch.prev)) // Single tap
            { range = new Range(pos, pos); }
          else if (!touch.prev.prev || farAway(touch, touch.prev.prev)) // Double tap
            { range = cm.findWordAt(pos); }
          else // Triple tap
            { range = new Range(Pos(pos.line, 0), clipPos(cm.doc, Pos(pos.line + 1, 0))); }
          cm.setSelection(range.anchor, range.head);
          cm.focus();
          e_preventDefault(e);
        }
        finishTouch();
      });
      on(d.scroller, "touchcancel", finishTouch);

      // Sync scrolling between fake scrollbars and real scrollable
      // area, ensure viewport is updated when scrolling.
      on(d.scroller, "scroll", function () {
        if (d.scroller.clientHeight) {
          updateScrollTop(cm, d.scroller.scrollTop);
          setScrollLeft(cm, d.scroller.scrollLeft, true);
          signal(cm, "scroll", cm);
        }
      });

      // Listen to wheel events in order to try and update the viewport on time.
      on(d.scroller, "mousewheel", function (e) { return onScrollWheel(cm, e); });
      on(d.scroller, "DOMMouseScroll", function (e) { return onScrollWheel(cm, e); });

      // Prevent wrapper from ever scrolling
      on(d.wrapper, "scroll", function () { return d.wrapper.scrollTop = d.wrapper.scrollLeft = 0; });

      d.dragFunctions = {
        enter: function (e) {if (!signalDOMEvent(cm, e)) { e_stop(e); }},
        over: function (e) {if (!signalDOMEvent(cm, e)) { onDragOver(cm, e); e_stop(e); }},
        start: function (e) { return onDragStart(cm, e); },
        drop: operation(cm, onDrop),
        leave: function (e) {if (!signalDOMEvent(cm, e)) { clearDragCursor(cm); }}
      };

      var inp = d.input.getField();
      on(inp, "keyup", function (e) { return onKeyUp.call(cm, e); });
      on(inp, "keydown", operation(cm, onKeyDown));
      on(inp, "keypress", operation(cm, onKeyPress));
      on(inp, "focus", function (e) { return onFocus(cm, e); });
      on(inp, "blur", function (e) { return onBlur(cm, e); });
    }

    var initHooks = [];
    CodeMirror.defineInitHook = function (f) { return initHooks.push(f); };

    // Indent the given line. The how parameter can be "smart",
    // "add"/null, "subtract", or "prev". When aggressive is false
    // (typically set to true for forced single-line indents), empty
    // lines are not indented, and places where the mode returns Pass
    // are left alone.
    function indentLine(cm, n, how, aggressive) {
      var doc = cm.doc, state;
      if (how == null) { how = "add"; }
      if (how == "smart") {
        // Fall back to "prev" when the mode doesn't have an indentation
        // method.
        if (!doc.mode.indent) { how = "prev"; }
        else { state = getContextBefore(cm, n).state; }
      }

      var tabSize = cm.options.tabSize;
      var line = getLine(doc, n), curSpace = countColumn(line.text, null, tabSize);
      if (line.stateAfter) { line.stateAfter = null; }
      var curSpaceString = line.text.match(/^\s*/)[0], indentation;
      if (!aggressive && !/\S/.test(line.text)) {
        indentation = 0;
        how = "not";
      } else if (how == "smart") {
        indentation = doc.mode.indent(state, line.text.slice(curSpaceString.length), line.text);
        if (indentation == Pass || indentation > 150) {
          if (!aggressive) { return }
          how = "prev";
        }
      }
      if (how == "prev") {
        if (n > doc.first) { indentation = countColumn(getLine(doc, n-1).text, null, tabSize); }
        else { indentation = 0; }
      } else if (how == "add") {
        indentation = curSpace + cm.options.indentUnit;
      } else if (how == "subtract") {
        indentation = curSpace - cm.options.indentUnit;
      } else if (typeof how == "number") {
        indentation = curSpace + how;
      }
      indentation = Math.max(0, indentation);

      var indentString = "", pos = 0;
      if (cm.options.indentWithTabs)
        { for (var i = Math.floor(indentation / tabSize); i; --i) {pos += tabSize; indentString += "\t";} }
      if (pos < indentation) { indentString += spaceStr(indentation - pos); }

      if (indentString != curSpaceString) {
        replaceRange(doc, indentString, Pos(n, 0), Pos(n, curSpaceString.length), "+input");
        line.stateAfter = null;
        return true
      } else {
        // Ensure that, if the cursor was in the whitespace at the start
        // of the line, it is moved to the end of that space.
        for (var i$1 = 0; i$1 < doc.sel.ranges.length; i$1++) {
          var range = doc.sel.ranges[i$1];
          if (range.head.line == n && range.head.ch < curSpaceString.length) {
            var pos$1 = Pos(n, curSpaceString.length);
            replaceOneSelection(doc, i$1, new Range(pos$1, pos$1));
            break
          }
        }
      }
    }

    // This will be set to a {lineWise: bool, text: [string]} object, so
    // that, when pasting, we know what kind of selections the copied
    // text was made out of.
    var lastCopied = null;

    function setLastCopied(newLastCopied) {
      lastCopied = newLastCopied;
    }

    function applyTextInput(cm, inserted, deleted, sel, origin) {
      var doc = cm.doc;
      cm.display.shift = false;
      if (!sel) { sel = doc.sel; }

      var recent = +new Date - 200;
      var paste = origin == "paste" || cm.state.pasteIncoming > recent;
      var textLines = splitLinesAuto(inserted), multiPaste = null;
      // When pasting N lines into N selections, insert one line per selection
      if (paste && sel.ranges.length > 1) {
        if (lastCopied && lastCopied.text.join("\n") == inserted) {
          if (sel.ranges.length % lastCopied.text.length == 0) {
            multiPaste = [];
            for (var i = 0; i < lastCopied.text.length; i++)
              { multiPaste.push(doc.splitLines(lastCopied.text[i])); }
          }
        } else if (textLines.length == sel.ranges.length && cm.options.pasteLinesPerSelection) {
          multiPaste = map(textLines, function (l) { return [l]; });
        }
      }

      var updateInput = cm.curOp.updateInput;
      // Normal behavior is to insert the new text into every selection
      for (var i$1 = sel.ranges.length - 1; i$1 >= 0; i$1--) {
        var range = sel.ranges[i$1];
        var from = range.from(), to = range.to();
        if (range.empty()) {
          if (deleted && deleted > 0) // Handle deletion
            { from = Pos(from.line, from.ch - deleted); }
          else if (cm.state.overwrite && !paste) // Handle overwrite
            { to = Pos(to.line, Math.min(getLine(doc, to.line).text.length, to.ch + lst(textLines).length)); }
          else if (paste && lastCopied && lastCopied.lineWise && lastCopied.text.join("\n") == textLines.join("\n"))
            { from = to = Pos(from.line, 0); }
        }
        var changeEvent = {from: from, to: to, text: multiPaste ? multiPaste[i$1 % multiPaste.length] : textLines,
                           origin: origin || (paste ? "paste" : cm.state.cutIncoming > recent ? "cut" : "+input")};
        makeChange(cm.doc, changeEvent);
        signalLater(cm, "inputRead", cm, changeEvent);
      }
      if (inserted && !paste)
        { triggerElectric(cm, inserted); }

      ensureCursorVisible(cm);
      if (cm.curOp.updateInput < 2) { cm.curOp.updateInput = updateInput; }
      cm.curOp.typing = true;
      cm.state.pasteIncoming = cm.state.cutIncoming = -1;
    }

    function handlePaste(e, cm) {
      var pasted = e.clipboardData && e.clipboardData.getData("Text");
      if (pasted) {
        e.preventDefault();
        if (!cm.isReadOnly() && !cm.options.disableInput)
          { runInOp(cm, function () { return applyTextInput(cm, pasted, 0, null, "paste"); }); }
        return true
      }
    }

    function triggerElectric(cm, inserted) {
      // When an 'electric' character is inserted, immediately trigger a reindent
      if (!cm.options.electricChars || !cm.options.smartIndent) { return }
      var sel = cm.doc.sel;

      for (var i = sel.ranges.length - 1; i >= 0; i--) {
        var range = sel.ranges[i];
        if (range.head.ch > 100 || (i && sel.ranges[i - 1].head.line == range.head.line)) { continue }
        var mode = cm.getModeAt(range.head);
        var indented = false;
        if (mode.electricChars) {
          for (var j = 0; j < mode.electricChars.length; j++)
            { if (inserted.indexOf(mode.electricChars.charAt(j)) > -1) {
              indented = indentLine(cm, range.head.line, "smart");
              break
            } }
        } else if (mode.electricInput) {
          if (mode.electricInput.test(getLine(cm.doc, range.head.line).text.slice(0, range.head.ch)))
            { indented = indentLine(cm, range.head.line, "smart"); }
        }
        if (indented) { signalLater(cm, "electricInput", cm, range.head.line); }
      }
    }

    function copyableRanges(cm) {
      var text = [], ranges = [];
      for (var i = 0; i < cm.doc.sel.ranges.length; i++) {
        var line = cm.doc.sel.ranges[i].head.line;
        var lineRange = {anchor: Pos(line, 0), head: Pos(line + 1, 0)};
        ranges.push(lineRange);
        text.push(cm.getRange(lineRange.anchor, lineRange.head));
      }
      return {text: text, ranges: ranges}
    }

    function disableBrowserMagic(field, spellcheck, autocorrect, autocapitalize) {
      field.setAttribute("autocorrect", autocorrect ? "" : "off");
      field.setAttribute("autocapitalize", autocapitalize ? "" : "off");
      field.setAttribute("spellcheck", !!spellcheck);
    }

    function hiddenTextarea() {
      var te = elt("textarea", null, null, "position: absolute; bottom: -1em; padding: 0; width: 1px; height: 1em; outline: none");
      var div = elt("div", [te], null, "overflow: hidden; position: relative; width: 3px; height: 0px;");
      // The textarea is kept positioned near the cursor to prevent the
      // fact that it'll be scrolled into view on input from scrolling
      // our fake cursor out of view. On webkit, when wrap=off, paste is
      // very slow. So make the area wide instead.
      if (webkit) { te.style.width = "1000px"; }
      else { te.setAttribute("wrap", "off"); }
      // If border: 0; -- iOS fails to open keyboard (issue #1287)
      if (ios) { te.style.border = "1px solid black"; }
      disableBrowserMagic(te);
      return div
    }

    // The publicly visible API. Note that methodOp(f) means
    // 'wrap f in an operation, performed on its `this` parameter'.

    // This is not the complete set of editor methods. Most of the
    // methods defined on the Doc type are also injected into
    // CodeMirror.prototype, for backwards compatibility and
    // convenience.

    function addEditorMethods(CodeMirror) {
      var optionHandlers = CodeMirror.optionHandlers;

      var helpers = CodeMirror.helpers = {};

      CodeMirror.prototype = {
        constructor: CodeMirror,
        focus: function(){window.focus(); this.display.input.focus();},

        setOption: function(option, value) {
          var options = this.options, old = options[option];
          if (options[option] == value && option != "mode") { return }
          options[option] = value;
          if (optionHandlers.hasOwnProperty(option))
            { operation(this, optionHandlers[option])(this, value, old); }
          signal(this, "optionChange", this, option);
        },

        getOption: function(option) {return this.options[option]},
        getDoc: function() {return this.doc},

        addKeyMap: function(map, bottom) {
          this.state.keyMaps[bottom ? "push" : "unshift"](getKeyMap(map));
        },
        removeKeyMap: function(map) {
          var maps = this.state.keyMaps;
          for (var i = 0; i < maps.length; ++i)
            { if (maps[i] == map || maps[i].name == map) {
              maps.splice(i, 1);
              return true
            } }
        },

        addOverlay: methodOp(function(spec, options) {
          var mode = spec.token ? spec : CodeMirror.getMode(this.options, spec);
          if (mode.startState) { throw new Error("Overlays may not be stateful.") }
          insertSorted(this.state.overlays,
                       {mode: mode, modeSpec: spec, opaque: options && options.opaque,
                        priority: (options && options.priority) || 0},
                       function (overlay) { return overlay.priority; });
          this.state.modeGen++;
          regChange(this);
        }),
        removeOverlay: methodOp(function(spec) {
          var overlays = this.state.overlays;
          for (var i = 0; i < overlays.length; ++i) {
            var cur = overlays[i].modeSpec;
            if (cur == spec || typeof spec == "string" && cur.name == spec) {
              overlays.splice(i, 1);
              this.state.modeGen++;
              regChange(this);
              return
            }
          }
        }),

        indentLine: methodOp(function(n, dir, aggressive) {
          if (typeof dir != "string" && typeof dir != "number") {
            if (dir == null) { dir = this.options.smartIndent ? "smart" : "prev"; }
            else { dir = dir ? "add" : "subtract"; }
          }
          if (isLine(this.doc, n)) { indentLine(this, n, dir, aggressive); }
        }),
        indentSelection: methodOp(function(how) {
          var ranges = this.doc.sel.ranges, end = -1;
          for (var i = 0; i < ranges.length; i++) {
            var range = ranges[i];
            if (!range.empty()) {
              var from = range.from(), to = range.to();
              var start = Math.max(end, from.line);
              end = Math.min(this.lastLine(), to.line - (to.ch ? 0 : 1)) + 1;
              for (var j = start; j < end; ++j)
                { indentLine(this, j, how); }
              var newRanges = this.doc.sel.ranges;
              if (from.ch == 0 && ranges.length == newRanges.length && newRanges[i].from().ch > 0)
                { replaceOneSelection(this.doc, i, new Range(from, newRanges[i].to()), sel_dontScroll); }
            } else if (range.head.line > end) {
              indentLine(this, range.head.line, how, true);
              end = range.head.line;
              if (i == this.doc.sel.primIndex) { ensureCursorVisible(this); }
            }
          }
        }),

        // Fetch the parser token for a given character. Useful for hacks
        // that want to inspect the mode state (say, for completion).
        getTokenAt: function(pos, precise) {
          return takeToken(this, pos, precise)
        },

        getLineTokens: function(line, precise) {
          return takeToken(this, Pos(line), precise, true)
        },

        getTokenTypeAt: function(pos) {
          pos = clipPos(this.doc, pos);
          var styles = getLineStyles(this, getLine(this.doc, pos.line));
          var before = 0, after = (styles.length - 1) / 2, ch = pos.ch;
          var type;
          if (ch == 0) { type = styles[2]; }
          else { for (;;) {
            var mid = (before + after) >> 1;
            if ((mid ? styles[mid * 2 - 1] : 0) >= ch) { after = mid; }
            else if (styles[mid * 2 + 1] < ch) { before = mid + 1; }
            else { type = styles[mid * 2 + 2]; break }
          } }
          var cut = type ? type.indexOf("overlay ") : -1;
          return cut < 0 ? type : cut == 0 ? null : type.slice(0, cut - 1)
        },

        getModeAt: function(pos) {
          var mode = this.doc.mode;
          if (!mode.innerMode) { return mode }
          return CodeMirror.innerMode(mode, this.getTokenAt(pos).state).mode
        },

        getHelper: function(pos, type) {
          return this.getHelpers(pos, type)[0]
        },

        getHelpers: function(pos, type) {
          var found = [];
          if (!helpers.hasOwnProperty(type)) { return found }
          var help = helpers[type], mode = this.getModeAt(pos);
          if (typeof mode[type] == "string") {
            if (help[mode[type]]) { found.push(help[mode[type]]); }
          } else if (mode[type]) {
            for (var i = 0; i < mode[type].length; i++) {
              var val = help[mode[type][i]];
              if (val) { found.push(val); }
            }
          } else if (mode.helperType && help[mode.helperType]) {
            found.push(help[mode.helperType]);
          } else if (help[mode.name]) {
            found.push(help[mode.name]);
          }
          for (var i$1 = 0; i$1 < help._global.length; i$1++) {
            var cur = help._global[i$1];
            if (cur.pred(mode, this) && indexOf(found, cur.val) == -1)
              { found.push(cur.val); }
          }
          return found
        },

        getStateAfter: function(line, precise) {
          var doc = this.doc;
          line = clipLine(doc, line == null ? doc.first + doc.size - 1: line);
          return getContextBefore(this, line + 1, precise).state
        },

        cursorCoords: function(start, mode) {
          var pos, range = this.doc.sel.primary();
          if (start == null) { pos = range.head; }
          else if (typeof start == "object") { pos = clipPos(this.doc, start); }
          else { pos = start ? range.from() : range.to(); }
          return cursorCoords(this, pos, mode || "page")
        },

        charCoords: function(pos, mode) {
          return charCoords(this, clipPos(this.doc, pos), mode || "page")
        },

        coordsChar: function(coords, mode) {
          coords = fromCoordSystem(this, coords, mode || "page");
          return coordsChar(this, coords.left, coords.top)
        },

        lineAtHeight: function(height, mode) {
          height = fromCoordSystem(this, {top: height, left: 0}, mode || "page").top;
          return lineAtHeight(this.doc, height + this.display.viewOffset)
        },
        heightAtLine: function(line, mode, includeWidgets) {
          var end = false, lineObj;
          if (typeof line == "number") {
            var last = this.doc.first + this.doc.size - 1;
            if (line < this.doc.first) { line = this.doc.first; }
            else if (line > last) { line = last; end = true; }
            lineObj = getLine(this.doc, line);
          } else {
            lineObj = line;
          }
          return intoCoordSystem(this, lineObj, {top: 0, left: 0}, mode || "page", includeWidgets || end).top +
            (end ? this.doc.height - heightAtLine(lineObj) : 0)
        },

        defaultTextHeight: function() { return textHeight(this.display) },
        defaultCharWidth: function() { return charWidth(this.display) },

        getViewport: function() { return {from: this.display.viewFrom, to: this.display.viewTo}},

        addWidget: function(pos, node, scroll, vert, horiz) {
          var display = this.display;
          pos = cursorCoords(this, clipPos(this.doc, pos));
          var top = pos.bottom, left = pos.left;
          node.style.position = "absolute";
          node.setAttribute("cm-ignore-events", "true");
          this.display.input.setUneditable(node);
          display.sizer.appendChild(node);
          if (vert == "over") {
            top = pos.top;
          } else if (vert == "above" || vert == "near") {
            var vspace = Math.max(display.wrapper.clientHeight, this.doc.height),
            hspace = Math.max(display.sizer.clientWidth, display.lineSpace.clientWidth);
            // Default to positioning above (if specified and possible); otherwise default to positioning below
            if ((vert == 'above' || pos.bottom + node.offsetHeight > vspace) && pos.top > node.offsetHeight)
              { top = pos.top - node.offsetHeight; }
            else if (pos.bottom + node.offsetHeight <= vspace)
              { top = pos.bottom; }
            if (left + node.offsetWidth > hspace)
              { left = hspace - node.offsetWidth; }
          }
          node.style.top = top + "px";
          node.style.left = node.style.right = "";
          if (horiz == "right") {
            left = display.sizer.clientWidth - node.offsetWidth;
            node.style.right = "0px";
          } else {
            if (horiz == "left") { left = 0; }
            else if (horiz == "middle") { left = (display.sizer.clientWidth - node.offsetWidth) / 2; }
            node.style.left = left + "px";
          }
          if (scroll)
            { scrollIntoView(this, {left: left, top: top, right: left + node.offsetWidth, bottom: top + node.offsetHeight}); }
        },

        triggerOnKeyDown: methodOp(onKeyDown),
        triggerOnKeyPress: methodOp(onKeyPress),
        triggerOnKeyUp: onKeyUp,
        triggerOnMouseDown: methodOp(onMouseDown),

        execCommand: function(cmd) {
          if (commands.hasOwnProperty(cmd))
            { return commands[cmd].call(null, this) }
        },

        triggerElectric: methodOp(function(text) { triggerElectric(this, text); }),

        findPosH: function(from, amount, unit, visually) {
          var dir = 1;
          if (amount < 0) { dir = -1; amount = -amount; }
          var cur = clipPos(this.doc, from);
          for (var i = 0; i < amount; ++i) {
            cur = findPosH(this.doc, cur, dir, unit, visually);
            if (cur.hitSide) { break }
          }
          return cur
        },

        moveH: methodOp(function(dir, unit) {
          var this$1 = this;

          this.extendSelectionsBy(function (range) {
            if (this$1.display.shift || this$1.doc.extend || range.empty())
              { return findPosH(this$1.doc, range.head, dir, unit, this$1.options.rtlMoveVisually) }
            else
              { return dir < 0 ? range.from() : range.to() }
          }, sel_move);
        }),

        deleteH: methodOp(function(dir, unit) {
          var sel = this.doc.sel, doc = this.doc;
          if (sel.somethingSelected())
            { doc.replaceSelection("", null, "+delete"); }
          else
            { deleteNearSelection(this, function (range) {
              var other = findPosH(doc, range.head, dir, unit, false);
              return dir < 0 ? {from: other, to: range.head} : {from: range.head, to: other}
            }); }
        }),

        findPosV: function(from, amount, unit, goalColumn) {
          var dir = 1, x = goalColumn;
          if (amount < 0) { dir = -1; amount = -amount; }
          var cur = clipPos(this.doc, from);
          for (var i = 0; i < amount; ++i) {
            var coords = cursorCoords(this, cur, "div");
            if (x == null) { x = coords.left; }
            else { coords.left = x; }
            cur = findPosV(this, coords, dir, unit);
            if (cur.hitSide) { break }
          }
          return cur
        },

        moveV: methodOp(function(dir, unit) {
          var this$1 = this;

          var doc = this.doc, goals = [];
          var collapse = !this.display.shift && !doc.extend && doc.sel.somethingSelected();
          doc.extendSelectionsBy(function (range) {
            if (collapse)
              { return dir < 0 ? range.from() : range.to() }
            var headPos = cursorCoords(this$1, range.head, "div");
            if (range.goalColumn != null) { headPos.left = range.goalColumn; }
            goals.push(headPos.left);
            var pos = findPosV(this$1, headPos, dir, unit);
            if (unit == "page" && range == doc.sel.primary())
              { addToScrollTop(this$1, charCoords(this$1, pos, "div").top - headPos.top); }
            return pos
          }, sel_move);
          if (goals.length) { for (var i = 0; i < doc.sel.ranges.length; i++)
            { doc.sel.ranges[i].goalColumn = goals[i]; } }
        }),

        // Find the word at the given position (as returned by coordsChar).
        findWordAt: function(pos) {
          var doc = this.doc, line = getLine(doc, pos.line).text;
          var start = pos.ch, end = pos.ch;
          if (line) {
            var helper = this.getHelper(pos, "wordChars");
            if ((pos.sticky == "before" || end == line.length) && start) { --start; } else { ++end; }
            var startChar = line.charAt(start);
            var check = isWordChar(startChar, helper)
              ? function (ch) { return isWordChar(ch, helper); }
              : /\s/.test(startChar) ? function (ch) { return /\s/.test(ch); }
              : function (ch) { return (!/\s/.test(ch) && !isWordChar(ch)); };
            while (start > 0 && check(line.charAt(start - 1))) { --start; }
            while (end < line.length && check(line.charAt(end))) { ++end; }
          }
          return new Range(Pos(pos.line, start), Pos(pos.line, end))
        },

        toggleOverwrite: function(value) {
          if (value != null && value == this.state.overwrite) { return }
          if (this.state.overwrite = !this.state.overwrite)
            { addClass(this.display.cursorDiv, "CodeMirror-overwrite"); }
          else
            { rmClass(this.display.cursorDiv, "CodeMirror-overwrite"); }

          signal(this, "overwriteToggle", this, this.state.overwrite);
        },
        hasFocus: function() { return this.display.input.getField() == activeElt() },
        isReadOnly: function() { return !!(this.options.readOnly || this.doc.cantEdit) },

        scrollTo: methodOp(function (x, y) { scrollToCoords(this, x, y); }),
        getScrollInfo: function() {
          var scroller = this.display.scroller;
          return {left: scroller.scrollLeft, top: scroller.scrollTop,
                  height: scroller.scrollHeight - scrollGap(this) - this.display.barHeight,
                  width: scroller.scrollWidth - scrollGap(this) - this.display.barWidth,
                  clientHeight: displayHeight(this), clientWidth: displayWidth(this)}
        },

        scrollIntoView: methodOp(function(range, margin) {
          if (range == null) {
            range = {from: this.doc.sel.primary().head, to: null};
            if (margin == null) { margin = this.options.cursorScrollMargin; }
          } else if (typeof range == "number") {
            range = {from: Pos(range, 0), to: null};
          } else if (range.from == null) {
            range = {from: range, to: null};
          }
          if (!range.to) { range.to = range.from; }
          range.margin = margin || 0;

          if (range.from.line != null) {
            scrollToRange(this, range);
          } else {
            scrollToCoordsRange(this, range.from, range.to, range.margin);
          }
        }),

        setSize: methodOp(function(width, height) {
          var this$1 = this;

          var interpret = function (val) { return typeof val == "number" || /^\d+$/.test(String(val)) ? val + "px" : val; };
          if (width != null) { this.display.wrapper.style.width = interpret(width); }
          if (height != null) { this.display.wrapper.style.height = interpret(height); }
          if (this.options.lineWrapping) { clearLineMeasurementCache(this); }
          var lineNo = this.display.viewFrom;
          this.doc.iter(lineNo, this.display.viewTo, function (line) {
            if (line.widgets) { for (var i = 0; i < line.widgets.length; i++)
              { if (line.widgets[i].noHScroll) { regLineChange(this$1, lineNo, "widget"); break } } }
            ++lineNo;
          });
          this.curOp.forceUpdate = true;
          signal(this, "refresh", this);
        }),

        operation: function(f){return runInOp(this, f)},
        startOperation: function(){return startOperation(this)},
        endOperation: function(){return endOperation(this)},

        refresh: methodOp(function() {
          var oldHeight = this.display.cachedTextHeight;
          regChange(this);
          this.curOp.forceUpdate = true;
          clearCaches(this);
          scrollToCoords(this, this.doc.scrollLeft, this.doc.scrollTop);
          updateGutterSpace(this.display);
          if (oldHeight == null || Math.abs(oldHeight - textHeight(this.display)) > .5 || this.options.lineWrapping)
            { estimateLineHeights(this); }
          signal(this, "refresh", this);
        }),

        swapDoc: methodOp(function(doc) {
          var old = this.doc;
          old.cm = null;
          // Cancel the current text selection if any (#5821)
          if (this.state.selectingText) { this.state.selectingText(); }
          attachDoc(this, doc);
          clearCaches(this);
          this.display.input.reset();
          scrollToCoords(this, doc.scrollLeft, doc.scrollTop);
          this.curOp.forceScroll = true;
          signalLater(this, "swapDoc", this, old);
          return old
        }),

        phrase: function(phraseText) {
          var phrases = this.options.phrases;
          return phrases && Object.prototype.hasOwnProperty.call(phrases, phraseText) ? phrases[phraseText] : phraseText
        },

        getInputField: function(){return this.display.input.getField()},
        getWrapperElement: function(){return this.display.wrapper},
        getScrollerElement: function(){return this.display.scroller},
        getGutterElement: function(){return this.display.gutters}
      };
      eventMixin(CodeMirror);

      CodeMirror.registerHelper = function(type, name, value) {
        if (!helpers.hasOwnProperty(type)) { helpers[type] = CodeMirror[type] = {_global: []}; }
        helpers[type][name] = value;
      };
      CodeMirror.registerGlobalHelper = function(type, name, predicate, value) {
        CodeMirror.registerHelper(type, name, value);
        helpers[type]._global.push({pred: predicate, val: value});
      };
    }

    // Used for horizontal relative motion. Dir is -1 or 1 (left or
    // right), unit can be "codepoint", "char", "column" (like char, but
    // doesn't cross line boundaries), "word" (across next word), or
    // "group" (to the start of next group of word or
    // non-word-non-whitespace chars). The visually param controls
    // whether, in right-to-left text, direction 1 means to move towards
    // the next index in the string, or towards the character to the right
    // of the current position. The resulting position will have a
    // hitSide=true property if it reached the end of the document.
    function findPosH(doc, pos, dir, unit, visually) {
      var oldPos = pos;
      var origDir = dir;
      var lineObj = getLine(doc, pos.line);
      var lineDir = visually && doc.direction == "rtl" ? -dir : dir;
      function findNextLine() {
        var l = pos.line + lineDir;
        if (l < doc.first || l >= doc.first + doc.size) { return false }
        pos = new Pos(l, pos.ch, pos.sticky);
        return lineObj = getLine(doc, l)
      }
      function moveOnce(boundToLine) {
        var next;
        if (unit == "codepoint") {
          var ch = lineObj.text.charCodeAt(pos.ch + (dir > 0 ? 0 : -1));
          if (isNaN(ch)) {
            next = null;
          } else {
            var astral = dir > 0 ? ch >= 0xD800 && ch < 0xDC00 : ch >= 0xDC00 && ch < 0xDFFF;
            next = new Pos(pos.line, Math.max(0, Math.min(lineObj.text.length, pos.ch + dir * (astral ? 2 : 1))), -dir);
          }
        } else if (visually) {
          next = moveVisually(doc.cm, lineObj, pos, dir);
        } else {
          next = moveLogically(lineObj, pos, dir);
        }
        if (next == null) {
          if (!boundToLine && findNextLine())
            { pos = endOfLine(visually, doc.cm, lineObj, pos.line, lineDir); }
          else
            { return false }
        } else {
          pos = next;
        }
        return true
      }

      if (unit == "char" || unit == "codepoint") {
        moveOnce();
      } else if (unit == "column") {
        moveOnce(true);
      } else if (unit == "word" || unit == "group") {
        var sawType = null, group = unit == "group";
        var helper = doc.cm && doc.cm.getHelper(pos, "wordChars");
        for (var first = true;; first = false) {
          if (dir < 0 && !moveOnce(!first)) { break }
          var cur = lineObj.text.charAt(pos.ch) || "\n";
          var type = isWordChar(cur, helper) ? "w"
            : group && cur == "\n" ? "n"
            : !group || /\s/.test(cur) ? null
            : "p";
          if (group && !first && !type) { type = "s"; }
          if (sawType && sawType != type) {
            if (dir < 0) {dir = 1; moveOnce(); pos.sticky = "after";}
            break
          }

          if (type) { sawType = type; }
          if (dir > 0 && !moveOnce(!first)) { break }
        }
      }
      var result = skipAtomic(doc, pos, oldPos, origDir, true);
      if (equalCursorPos(oldPos, result)) { result.hitSide = true; }
      return result
    }

    // For relative vertical movement. Dir may be -1 or 1. Unit can be
    // "page" or "line". The resulting position will have a hitSide=true
    // property if it reached the end of the document.
    function findPosV(cm, pos, dir, unit) {
      var doc = cm.doc, x = pos.left, y;
      if (unit == "page") {
        var pageSize = Math.min(cm.display.wrapper.clientHeight, window.innerHeight || document.documentElement.clientHeight);
        var moveAmount = Math.max(pageSize - .5 * textHeight(cm.display), 3);
        y = (dir > 0 ? pos.bottom : pos.top) + dir * moveAmount;

      } else if (unit == "line") {
        y = dir > 0 ? pos.bottom + 3 : pos.top - 3;
      }
      var target;
      for (;;) {
        target = coordsChar(cm, x, y);
        if (!target.outside) { break }
        if (dir < 0 ? y <= 0 : y >= doc.height) { target.hitSide = true; break }
        y += dir * 5;
      }
      return target
    }

    // CONTENTEDITABLE INPUT STYLE

    var ContentEditableInput = function(cm) {
      this.cm = cm;
      this.lastAnchorNode = this.lastAnchorOffset = this.lastFocusNode = this.lastFocusOffset = null;
      this.polling = new Delayed();
      this.composing = null;
      this.gracePeriod = false;
      this.readDOMTimeout = null;
    };

    ContentEditableInput.prototype.init = function (display) {
        var this$1 = this;

      var input = this, cm = input.cm;
      var div = input.div = display.lineDiv;
      div.contentEditable = true;
      disableBrowserMagic(div, cm.options.spellcheck, cm.options.autocorrect, cm.options.autocapitalize);

      function belongsToInput(e) {
        for (var t = e.target; t; t = t.parentNode) {
          if (t == div) { return true }
          if (/\bCodeMirror-(?:line)?widget\b/.test(t.className)) { break }
        }
        return false
      }

      on(div, "paste", function (e) {
        if (!belongsToInput(e) || signalDOMEvent(cm, e) || handlePaste(e, cm)) { return }
        // IE doesn't fire input events, so we schedule a read for the pasted content in this way
        if (ie_version <= 11) { setTimeout(operation(cm, function () { return this$1.updateFromDOM(); }), 20); }
      });

      on(div, "compositionstart", function (e) {
        this$1.composing = {data: e.data, done: false};
      });
      on(div, "compositionupdate", function (e) {
        if (!this$1.composing) { this$1.composing = {data: e.data, done: false}; }
      });
      on(div, "compositionend", function (e) {
        if (this$1.composing) {
          if (e.data != this$1.composing.data) { this$1.readFromDOMSoon(); }
          this$1.composing.done = true;
        }
      });

      on(div, "touchstart", function () { return input.forceCompositionEnd(); });

      on(div, "input", function () {
        if (!this$1.composing) { this$1.readFromDOMSoon(); }
      });

      function onCopyCut(e) {
        if (!belongsToInput(e) || signalDOMEvent(cm, e)) { return }
        if (cm.somethingSelected()) {
          setLastCopied({lineWise: false, text: cm.getSelections()});
          if (e.type == "cut") { cm.replaceSelection("", null, "cut"); }
        } else if (!cm.options.lineWiseCopyCut) {
          return
        } else {
          var ranges = copyableRanges(cm);
          setLastCopied({lineWise: true, text: ranges.text});
          if (e.type == "cut") {
            cm.operation(function () {
              cm.setSelections(ranges.ranges, 0, sel_dontScroll);
              cm.replaceSelection("", null, "cut");
            });
          }
        }
        if (e.clipboardData) {
          e.clipboardData.clearData();
          var content = lastCopied.text.join("\n");
          // iOS exposes the clipboard API, but seems to discard content inserted into it
          e.clipboardData.setData("Text", content);
          if (e.clipboardData.getData("Text") == content) {
            e.preventDefault();
            return
          }
        }
        // Old-fashioned briefly-focus-a-textarea hack
        var kludge = hiddenTextarea(), te = kludge.firstChild;
        cm.display.lineSpace.insertBefore(kludge, cm.display.lineSpace.firstChild);
        te.value = lastCopied.text.join("\n");
        var hadFocus = document.activeElement;
        selectInput(te);
        setTimeout(function () {
          cm.display.lineSpace.removeChild(kludge);
          hadFocus.focus();
          if (hadFocus == div) { input.showPrimarySelection(); }
        }, 50);
      }
      on(div, "copy", onCopyCut);
      on(div, "cut", onCopyCut);
    };

    ContentEditableInput.prototype.screenReaderLabelChanged = function (label) {
      // Label for screenreaders, accessibility
      if(label) {
        this.div.setAttribute('aria-label', label);
      } else {
        this.div.removeAttribute('aria-label');
      }
    };

    ContentEditableInput.prototype.prepareSelection = function () {
      var result = prepareSelection(this.cm, false);
      result.focus = document.activeElement == this.div;
      return result
    };

    ContentEditableInput.prototype.showSelection = function (info, takeFocus) {
      if (!info || !this.cm.display.view.length) { return }
      if (info.focus || takeFocus) { this.showPrimarySelection(); }
      this.showMultipleSelections(info);
    };

    ContentEditableInput.prototype.getSelection = function () {
      return this.cm.display.wrapper.ownerDocument.getSelection()
    };

    ContentEditableInput.prototype.showPrimarySelection = function () {
      var sel = this.getSelection(), cm = this.cm, prim = cm.doc.sel.primary();
      var from = prim.from(), to = prim.to();

      if (cm.display.viewTo == cm.display.viewFrom || from.line >= cm.display.viewTo || to.line < cm.display.viewFrom) {
        sel.removeAllRanges();
        return
      }

      var curAnchor = domToPos(cm, sel.anchorNode, sel.anchorOffset);
      var curFocus = domToPos(cm, sel.focusNode, sel.focusOffset);
      if (curAnchor && !curAnchor.bad && curFocus && !curFocus.bad &&
          cmp(minPos(curAnchor, curFocus), from) == 0 &&
          cmp(maxPos(curAnchor, curFocus), to) == 0)
        { return }

      var view = cm.display.view;
      var start = (from.line >= cm.display.viewFrom && posToDOM(cm, from)) ||
          {node: view[0].measure.map[2], offset: 0};
      var end = to.line < cm.display.viewTo && posToDOM(cm, to);
      if (!end) {
        var measure = view[view.length - 1].measure;
        var map = measure.maps ? measure.maps[measure.maps.length - 1] : measure.map;
        end = {node: map[map.length - 1], offset: map[map.length - 2] - map[map.length - 3]};
      }

      if (!start || !end) {
        sel.removeAllRanges();
        return
      }

      var old = sel.rangeCount && sel.getRangeAt(0), rng;
      try { rng = range(start.node, start.offset, end.offset, end.node); }
      catch(e) {} // Our model of the DOM might be outdated, in which case the range we try to set can be impossible
      if (rng) {
        if (!gecko && cm.state.focused) {
          sel.collapse(start.node, start.offset);
          if (!rng.collapsed) {
            sel.removeAllRanges();
            sel.addRange(rng);
          }
        } else {
          sel.removeAllRanges();
          sel.addRange(rng);
        }
        if (old && sel.anchorNode == null) { sel.addRange(old); }
        else if (gecko) { this.startGracePeriod(); }
      }
      this.rememberSelection();
    };

    ContentEditableInput.prototype.startGracePeriod = function () {
        var this$1 = this;

      clearTimeout(this.gracePeriod);
      this.gracePeriod = setTimeout(function () {
        this$1.gracePeriod = false;
        if (this$1.selectionChanged())
          { this$1.cm.operation(function () { return this$1.cm.curOp.selectionChanged = true; }); }
      }, 20);
    };

    ContentEditableInput.prototype.showMultipleSelections = function (info) {
      removeChildrenAndAdd(this.cm.display.cursorDiv, info.cursors);
      removeChildrenAndAdd(this.cm.display.selectionDiv, info.selection);
    };

    ContentEditableInput.prototype.rememberSelection = function () {
      var sel = this.getSelection();
      this.lastAnchorNode = sel.anchorNode; this.lastAnchorOffset = sel.anchorOffset;
      this.lastFocusNode = sel.focusNode; this.lastFocusOffset = sel.focusOffset;
    };

    ContentEditableInput.prototype.selectionInEditor = function () {
      var sel = this.getSelection();
      if (!sel.rangeCount) { return false }
      var node = sel.getRangeAt(0).commonAncestorContainer;
      return contains(this.div, node)
    };

    ContentEditableInput.prototype.focus = function () {
      if (this.cm.options.readOnly != "nocursor") {
        if (!this.selectionInEditor() || document.activeElement != this.div)
          { this.showSelection(this.prepareSelection(), true); }
        this.div.focus();
      }
    };
    ContentEditableInput.prototype.blur = function () { this.div.blur(); };
    ContentEditableInput.prototype.getField = function () { return this.div };

    ContentEditableInput.prototype.supportsTouch = function () { return true };

    ContentEditableInput.prototype.receivedFocus = function () {
      var input = this;
      if (this.selectionInEditor())
        { this.pollSelection(); }
      else
        { runInOp(this.cm, function () { return input.cm.curOp.selectionChanged = true; }); }

      function poll() {
        if (input.cm.state.focused) {
          input.pollSelection();
          input.polling.set(input.cm.options.pollInterval, poll);
        }
      }
      this.polling.set(this.cm.options.pollInterval, poll);
    };

    ContentEditableInput.prototype.selectionChanged = function () {
      var sel = this.getSelection();
      return sel.anchorNode != this.lastAnchorNode || sel.anchorOffset != this.lastAnchorOffset ||
        sel.focusNode != this.lastFocusNode || sel.focusOffset != this.lastFocusOffset
    };

    ContentEditableInput.prototype.pollSelection = function () {
      if (this.readDOMTimeout != null || this.gracePeriod || !this.selectionChanged()) { return }
      var sel = this.getSelection(), cm = this.cm;
      // On Android Chrome (version 56, at least), backspacing into an
      // uneditable block element will put the cursor in that element,
      // and then, because it's not editable, hide the virtual keyboard.
      // Because Android doesn't allow us to actually detect backspace
      // presses in a sane way, this code checks for when that happens
      // and simulates a backspace press in this case.
      if (android && chrome && this.cm.display.gutterSpecs.length && isInGutter(sel.anchorNode)) {
        this.cm.triggerOnKeyDown({type: "keydown", keyCode: 8, preventDefault: Math.abs});
        this.blur();
        this.focus();
        return
      }
      if (this.composing) { return }
      this.rememberSelection();
      var anchor = domToPos(cm, sel.anchorNode, sel.anchorOffset);
      var head = domToPos(cm, sel.focusNode, sel.focusOffset);
      if (anchor && head) { runInOp(cm, function () {
        setSelection(cm.doc, simpleSelection(anchor, head), sel_dontScroll);
        if (anchor.bad || head.bad) { cm.curOp.selectionChanged = true; }
      }); }
    };

    ContentEditableInput.prototype.pollContent = function () {
      if (this.readDOMTimeout != null) {
        clearTimeout(this.readDOMTimeout);
        this.readDOMTimeout = null;
      }

      var cm = this.cm, display = cm.display, sel = cm.doc.sel.primary();
      var from = sel.from(), to = sel.to();
      if (from.ch == 0 && from.line > cm.firstLine())
        { from = Pos(from.line - 1, getLine(cm.doc, from.line - 1).length); }
      if (to.ch == getLine(cm.doc, to.line).text.length && to.line < cm.lastLine())
        { to = Pos(to.line + 1, 0); }
      if (from.line < display.viewFrom || to.line > display.viewTo - 1) { return false }

      var fromIndex, fromLine, fromNode;
      if (from.line == display.viewFrom || (fromIndex = findViewIndex(cm, from.line)) == 0) {
        fromLine = lineNo(display.view[0].line);
        fromNode = display.view[0].node;
      } else {
        fromLine = lineNo(display.view[fromIndex].line);
        fromNode = display.view[fromIndex - 1].node.nextSibling;
      }
      var toIndex = findViewIndex(cm, to.line);
      var toLine, toNode;
      if (toIndex == display.view.length - 1) {
        toLine = display.viewTo - 1;
        toNode = display.lineDiv.lastChild;
      } else {
        toLine = lineNo(display.view[toIndex + 1].line) - 1;
        toNode = display.view[toIndex + 1].node.previousSibling;
      }

      if (!fromNode) { return false }
      var newText = cm.doc.splitLines(domTextBetween(cm, fromNode, toNode, fromLine, toLine));
      var oldText = getBetween(cm.doc, Pos(fromLine, 0), Pos(toLine, getLine(cm.doc, toLine).text.length));
      while (newText.length > 1 && oldText.length > 1) {
        if (lst(newText) == lst(oldText)) { newText.pop(); oldText.pop(); toLine--; }
        else if (newText[0] == oldText[0]) { newText.shift(); oldText.shift(); fromLine++; }
        else { break }
      }

      var cutFront = 0, cutEnd = 0;
      var newTop = newText[0], oldTop = oldText[0], maxCutFront = Math.min(newTop.length, oldTop.length);
      while (cutFront < maxCutFront && newTop.charCodeAt(cutFront) == oldTop.charCodeAt(cutFront))
        { ++cutFront; }
      var newBot = lst(newText), oldBot = lst(oldText);
      var maxCutEnd = Math.min(newBot.length - (newText.length == 1 ? cutFront : 0),
                               oldBot.length - (oldText.length == 1 ? cutFront : 0));
      while (cutEnd < maxCutEnd &&
             newBot.charCodeAt(newBot.length - cutEnd - 1) == oldBot.charCodeAt(oldBot.length - cutEnd - 1))
        { ++cutEnd; }
      // Try to move start of change to start of selection if ambiguous
      if (newText.length == 1 && oldText.length == 1 && fromLine == from.line) {
        while (cutFront && cutFront > from.ch &&
               newBot.charCodeAt(newBot.length - cutEnd - 1) == oldBot.charCodeAt(oldBot.length - cutEnd - 1)) {
          cutFront--;
          cutEnd++;
        }
      }

      newText[newText.length - 1] = newBot.slice(0, newBot.length - cutEnd).replace(/^\u200b+/, "");
      newText[0] = newText[0].slice(cutFront).replace(/\u200b+$/, "");

      var chFrom = Pos(fromLine, cutFront);
      var chTo = Pos(toLine, oldText.length ? lst(oldText).length - cutEnd : 0);
      if (newText.length > 1 || newText[0] || cmp(chFrom, chTo)) {
        replaceRange(cm.doc, newText, chFrom, chTo, "+input");
        return true
      }
    };

    ContentEditableInput.prototype.ensurePolled = function () {
      this.forceCompositionEnd();
    };
    ContentEditableInput.prototype.reset = function () {
      this.forceCompositionEnd();
    };
    ContentEditableInput.prototype.forceCompositionEnd = function () {
      if (!this.composing) { return }
      clearTimeout(this.readDOMTimeout);
      this.composing = null;
      this.updateFromDOM();
      this.div.blur();
      this.div.focus();
    };
    ContentEditableInput.prototype.readFromDOMSoon = function () {
        var this$1 = this;

      if (this.readDOMTimeout != null) { return }
      this.readDOMTimeout = setTimeout(function () {
        this$1.readDOMTimeout = null;
        if (this$1.composing) {
          if (this$1.composing.done) { this$1.composing = null; }
          else { return }
        }
        this$1.updateFromDOM();
      }, 80);
    };

    ContentEditableInput.prototype.updateFromDOM = function () {
        var this$1 = this;

      if (this.cm.isReadOnly() || !this.pollContent())
        { runInOp(this.cm, function () { return regChange(this$1.cm); }); }
    };

    ContentEditableInput.prototype.setUneditable = function (node) {
      node.contentEditable = "false";
    };

    ContentEditableInput.prototype.onKeyPress = function (e) {
      if (e.charCode == 0 || this.composing) { return }
      e.preventDefault();
      if (!this.cm.isReadOnly())
        { operation(this.cm, applyTextInput)(this.cm, String.fromCharCode(e.charCode == null ? e.keyCode : e.charCode), 0); }
    };

    ContentEditableInput.prototype.readOnlyChanged = function (val) {
      this.div.contentEditable = String(val != "nocursor");
    };

    ContentEditableInput.prototype.onContextMenu = function () {};
    ContentEditableInput.prototype.resetPosition = function () {};

    ContentEditableInput.prototype.needsContentAttribute = true;

    function posToDOM(cm, pos) {
      var view = findViewForLine(cm, pos.line);
      if (!view || view.hidden) { return null }
      var line = getLine(cm.doc, pos.line);
      var info = mapFromLineView(view, line, pos.line);

      var order = getOrder(line, cm.doc.direction), side = "left";
      if (order) {
        var partPos = getBidiPartAt(order, pos.ch);
        side = partPos % 2 ? "right" : "left";
      }
      var result = nodeAndOffsetInLineMap(info.map, pos.ch, side);
      result.offset = result.collapse == "right" ? result.end : result.start;
      return result
    }

    function isInGutter(node) {
      for (var scan = node; scan; scan = scan.parentNode)
        { if (/CodeMirror-gutter-wrapper/.test(scan.className)) { return true } }
      return false
    }

    function badPos(pos, bad) { if (bad) { pos.bad = true; } return pos }

    function domTextBetween(cm, from, to, fromLine, toLine) {
      var text = "", closing = false, lineSep = cm.doc.lineSeparator(), extraLinebreak = false;
      function recognizeMarker(id) { return function (marker) { return marker.id == id; } }
      function close() {
        if (closing) {
          text += lineSep;
          if (extraLinebreak) { text += lineSep; }
          closing = extraLinebreak = false;
        }
      }
      function addText(str) {
        if (str) {
          close();
          text += str;
        }
      }
      function walk(node) {
        if (node.nodeType == 1) {
          var cmText = node.getAttribute("cm-text");
          if (cmText) {
            addText(cmText);
            return
          }
          var markerID = node.getAttribute("cm-marker"), range;
          if (markerID) {
            var found = cm.findMarks(Pos(fromLine, 0), Pos(toLine + 1, 0), recognizeMarker(+markerID));
            if (found.length && (range = found[0].find(0)))
              { addText(getBetween(cm.doc, range.from, range.to).join(lineSep)); }
            return
          }
          if (node.getAttribute("contenteditable") == "false") { return }
          var isBlock = /^(pre|div|p|li|table|br)$/i.test(node.nodeName);
          if (!/^br$/i.test(node.nodeName) && node.textContent.length == 0) { return }

          if (isBlock) { close(); }
          for (var i = 0; i < node.childNodes.length; i++)
            { walk(node.childNodes[i]); }

          if (/^(pre|p)$/i.test(node.nodeName)) { extraLinebreak = true; }
          if (isBlock) { closing = true; }
        } else if (node.nodeType == 3) {
          addText(node.nodeValue.replace(/\u200b/g, "").replace(/\u00a0/g, " "));
        }
      }
      for (;;) {
        walk(from);
        if (from == to) { break }
        from = from.nextSibling;
        extraLinebreak = false;
      }
      return text
    }

    function domToPos(cm, node, offset) {
      var lineNode;
      if (node == cm.display.lineDiv) {
        lineNode = cm.display.lineDiv.childNodes[offset];
        if (!lineNode) { return badPos(cm.clipPos(Pos(cm.display.viewTo - 1)), true) }
        node = null; offset = 0;
      } else {
        for (lineNode = node;; lineNode = lineNode.parentNode) {
          if (!lineNode || lineNode == cm.display.lineDiv) { return null }
          if (lineNode.parentNode && lineNode.parentNode == cm.display.lineDiv) { break }
        }
      }
      for (var i = 0; i < cm.display.view.length; i++) {
        var lineView = cm.display.view[i];
        if (lineView.node == lineNode)
          { return locateNodeInLineView(lineView, node, offset) }
      }
    }

    function locateNodeInLineView(lineView, node, offset) {
      var wrapper = lineView.text.firstChild, bad = false;
      if (!node || !contains(wrapper, node)) { return badPos(Pos(lineNo(lineView.line), 0), true) }
      if (node == wrapper) {
        bad = true;
        node = wrapper.childNodes[offset];
        offset = 0;
        if (!node) {
          var line = lineView.rest ? lst(lineView.rest) : lineView.line;
          return badPos(Pos(lineNo(line), line.text.length), bad)
        }
      }

      var textNode = node.nodeType == 3 ? node : null, topNode = node;
      if (!textNode && node.childNodes.length == 1 && node.firstChild.nodeType == 3) {
        textNode = node.firstChild;
        if (offset) { offset = textNode.nodeValue.length; }
      }
      while (topNode.parentNode != wrapper) { topNode = topNode.parentNode; }
      var measure = lineView.measure, maps = measure.maps;

      function find(textNode, topNode, offset) {
        for (var i = -1; i < (maps ? maps.length : 0); i++) {
          var map = i < 0 ? measure.map : maps[i];
          for (var j = 0; j < map.length; j += 3) {
            var curNode = map[j + 2];
            if (curNode == textNode || curNode == topNode) {
              var line = lineNo(i < 0 ? lineView.line : lineView.rest[i]);
              var ch = map[j] + offset;
              if (offset < 0 || curNode != textNode) { ch = map[j + (offset ? 1 : 0)]; }
              return Pos(line, ch)
            }
          }
        }
      }
      var found = find(textNode, topNode, offset);
      if (found) { return badPos(found, bad) }

      // FIXME this is all really shaky. might handle the few cases it needs to handle, but likely to cause problems
      for (var after = topNode.nextSibling, dist = textNode ? textNode.nodeValue.length - offset : 0; after; after = after.nextSibling) {
        found = find(after, after.firstChild, 0);
        if (found)
          { return badPos(Pos(found.line, found.ch - dist), bad) }
        else
          { dist += after.textContent.length; }
      }
      for (var before = topNode.previousSibling, dist$1 = offset; before; before = before.previousSibling) {
        found = find(before, before.firstChild, -1);
        if (found)
          { return badPos(Pos(found.line, found.ch + dist$1), bad) }
        else
          { dist$1 += before.textContent.length; }
      }
    }

    // TEXTAREA INPUT STYLE

    var TextareaInput = function(cm) {
      this.cm = cm;
      // See input.poll and input.reset
      this.prevInput = "";

      // Flag that indicates whether we expect input to appear real soon
      // now (after some event like 'keypress' or 'input') and are
      // polling intensively.
      this.pollingFast = false;
      // Self-resetting timeout for the poller
      this.polling = new Delayed();
      // Used to work around IE issue with selection being forgotten when focus moves away from textarea
      this.hasSelection = false;
      this.composing = null;
    };

    TextareaInput.prototype.init = function (display) {
        var this$1 = this;

      var input = this, cm = this.cm;
      this.createField(display);
      var te = this.textarea;

      display.wrapper.insertBefore(this.wrapper, display.wrapper.firstChild);

      // Needed to hide big blue blinking cursor on Mobile Safari (doesn't seem to work in iOS 8 anymore)
      if (ios) { te.style.width = "0px"; }

      on(te, "input", function () {
        if (ie && ie_version >= 9 && this$1.hasSelection) { this$1.hasSelection = null; }
        input.poll();
      });

      on(te, "paste", function (e) {
        if (signalDOMEvent(cm, e) || handlePaste(e, cm)) { return }

        cm.state.pasteIncoming = +new Date;
        input.fastPoll();
      });

      function prepareCopyCut(e) {
        if (signalDOMEvent(cm, e)) { return }
        if (cm.somethingSelected()) {
          setLastCopied({lineWise: false, text: cm.getSelections()});
        } else if (!cm.options.lineWiseCopyCut) {
          return
        } else {
          var ranges = copyableRanges(cm);
          setLastCopied({lineWise: true, text: ranges.text});
          if (e.type == "cut") {
            cm.setSelections(ranges.ranges, null, sel_dontScroll);
          } else {
            input.prevInput = "";
            te.value = ranges.text.join("\n");
            selectInput(te);
          }
        }
        if (e.type == "cut") { cm.state.cutIncoming = +new Date; }
      }
      on(te, "cut", prepareCopyCut);
      on(te, "copy", prepareCopyCut);

      on(display.scroller, "paste", function (e) {
        if (eventInWidget(display, e) || signalDOMEvent(cm, e)) { return }
        if (!te.dispatchEvent) {
          cm.state.pasteIncoming = +new Date;
          input.focus();
          return
        }

        // Pass the `paste` event to the textarea so it's handled by its event listener.
        var event = new Event("paste");
        event.clipboardData = e.clipboardData;
        te.dispatchEvent(event);
      });

      // Prevent normal selection in the editor (we handle our own)
      on(display.lineSpace, "selectstart", function (e) {
        if (!eventInWidget(display, e)) { e_preventDefault(e); }
      });

      on(te, "compositionstart", function () {
        var start = cm.getCursor("from");
        if (input.composing) { input.composing.range.clear(); }
        input.composing = {
          start: start,
          range: cm.markText(start, cm.getCursor("to"), {className: "CodeMirror-composing"})
        };
      });
      on(te, "compositionend", function () {
        if (input.composing) {
          input.poll();
          input.composing.range.clear();
          input.composing = null;
        }
      });
    };

    TextareaInput.prototype.createField = function (_display) {
      // Wraps and hides input textarea
      this.wrapper = hiddenTextarea();
      // The semihidden textarea that is focused when the editor is
      // focused, and receives input.
      this.textarea = this.wrapper.firstChild;
    };

    TextareaInput.prototype.screenReaderLabelChanged = function (label) {
      // Label for screenreaders, accessibility
      if(label) {
        this.textarea.setAttribute('aria-label', label);
      } else {
        this.textarea.removeAttribute('aria-label');
      }
    };

    TextareaInput.prototype.prepareSelection = function () {
      // Redraw the selection and/or cursor
      var cm = this.cm, display = cm.display, doc = cm.doc;
      var result = prepareSelection(cm);

      // Move the hidden textarea near the cursor to prevent scrolling artifacts
      if (cm.options.moveInputWithCursor) {
        var headPos = cursorCoords(cm, doc.sel.primary().head, "div");
        var wrapOff = display.wrapper.getBoundingClientRect(), lineOff = display.lineDiv.getBoundingClientRect();
        result.teTop = Math.max(0, Math.min(display.wrapper.clientHeight - 10,
                                            headPos.top + lineOff.top - wrapOff.top));
        result.teLeft = Math.max(0, Math.min(display.wrapper.clientWidth - 10,
                                             headPos.left + lineOff.left - wrapOff.left));
      }

      return result
    };

    TextareaInput.prototype.showSelection = function (drawn) {
      var cm = this.cm, display = cm.display;
      removeChildrenAndAdd(display.cursorDiv, drawn.cursors);
      removeChildrenAndAdd(display.selectionDiv, drawn.selection);
      if (drawn.teTop != null) {
        this.wrapper.style.top = drawn.teTop + "px";
        this.wrapper.style.left = drawn.teLeft + "px";
      }
    };

    // Reset the input to correspond to the selection (or to be empty,
    // when not typing and nothing is selected)
    TextareaInput.prototype.reset = function (typing) {
      if (this.contextMenuPending || this.composing) { return }
      var cm = this.cm;
      if (cm.somethingSelected()) {
        this.prevInput = "";
        var content = cm.getSelection();
        this.textarea.value = content;
        if (cm.state.focused) { selectInput(this.textarea); }
        if (ie && ie_version >= 9) { this.hasSelection = content; }
      } else if (!typing) {
        this.prevInput = this.textarea.value = "";
        if (ie && ie_version >= 9) { this.hasSelection = null; }
      }
    };

    TextareaInput.prototype.getField = function () { return this.textarea };

    TextareaInput.prototype.supportsTouch = function () { return false };

    TextareaInput.prototype.focus = function () {
      if (this.cm.options.readOnly != "nocursor" && (!mobile || activeElt() != this.textarea)) {
        try { this.textarea.focus(); }
        catch (e) {} // IE8 will throw if the textarea is display: none or not in DOM
      }
    };

    TextareaInput.prototype.blur = function () { this.textarea.blur(); };

    TextareaInput.prototype.resetPosition = function () {
      this.wrapper.style.top = this.wrapper.style.left = 0;
    };

    TextareaInput.prototype.receivedFocus = function () { this.slowPoll(); };

    // Poll for input changes, using the normal rate of polling. This
    // runs as long as the editor is focused.
    TextareaInput.prototype.slowPoll = function () {
        var this$1 = this;

      if (this.pollingFast) { return }
      this.polling.set(this.cm.options.pollInterval, function () {
        this$1.poll();
        if (this$1.cm.state.focused) { this$1.slowPoll(); }
      });
    };

    // When an event has just come in that is likely to add or change
    // something in the input textarea, we poll faster, to ensure that
    // the change appears on the screen quickly.
    TextareaInput.prototype.fastPoll = function () {
      var missed = false, input = this;
      input.pollingFast = true;
      function p() {
        var changed = input.poll();
        if (!changed && !missed) {missed = true; input.polling.set(60, p);}
        else {input.pollingFast = false; input.slowPoll();}
      }
      input.polling.set(20, p);
    };

    // Read input from the textarea, and update the document to match.
    // When something is selected, it is present in the textarea, and
    // selected (unless it is huge, in which case a placeholder is
    // used). When nothing is selected, the cursor sits after previously
    // seen text (can be empty), which is stored in prevInput (we must
    // not reset the textarea when typing, because that breaks IME).
    TextareaInput.prototype.poll = function () {
        var this$1 = this;

      var cm = this.cm, input = this.textarea, prevInput = this.prevInput;
      // Since this is called a *lot*, try to bail out as cheaply as
      // possible when it is clear that nothing happened. hasSelection
      // will be the case when there is a lot of text in the textarea,
      // in which case reading its value would be expensive.
      if (this.contextMenuPending || !cm.state.focused ||
          (hasSelection(input) && !prevInput && !this.composing) ||
          cm.isReadOnly() || cm.options.disableInput || cm.state.keySeq)
        { return false }

      var text = input.value;
      // If nothing changed, bail.
      if (text == prevInput && !cm.somethingSelected()) { return false }
      // Work around nonsensical selection resetting in IE9/10, and
      // inexplicable appearance of private area unicode characters on
      // some key combos in Mac (#2689).
      if (ie && ie_version >= 9 && this.hasSelection === text ||
          mac && /[\uf700-\uf7ff]/.test(text)) {
        cm.display.input.reset();
        return false
      }

      if (cm.doc.sel == cm.display.selForContextMenu) {
        var first = text.charCodeAt(0);
        if (first == 0x200b && !prevInput) { prevInput = "\u200b"; }
        if (first == 0x21da) { this.reset(); return this.cm.execCommand("undo") }
      }
      // Find the part of the input that is actually new
      var same = 0, l = Math.min(prevInput.length, text.length);
      while (same < l && prevInput.charCodeAt(same) == text.charCodeAt(same)) { ++same; }

      runInOp(cm, function () {
        applyTextInput(cm, text.slice(same), prevInput.length - same,
                       null, this$1.composing ? "*compose" : null);

        // Don't leave long text in the textarea, since it makes further polling slow
        if (text.length > 1000 || text.indexOf("\n") > -1) { input.value = this$1.prevInput = ""; }
        else { this$1.prevInput = text; }

        if (this$1.composing) {
          this$1.composing.range.clear();
          this$1.composing.range = cm.markText(this$1.composing.start, cm.getCursor("to"),
                                             {className: "CodeMirror-composing"});
        }
      });
      return true
    };

    TextareaInput.prototype.ensurePolled = function () {
      if (this.pollingFast && this.poll()) { this.pollingFast = false; }
    };

    TextareaInput.prototype.onKeyPress = function () {
      if (ie && ie_version >= 9) { this.hasSelection = null; }
      this.fastPoll();
    };

    TextareaInput.prototype.onContextMenu = function (e) {
      var input = this, cm = input.cm, display = cm.display, te = input.textarea;
      if (input.contextMenuPending) { input.contextMenuPending(); }
      var pos = posFromMouse(cm, e), scrollPos = display.scroller.scrollTop;
      if (!pos || presto) { return } // Opera is difficult.

      // Reset the current text selection only if the click is done outside of the selection
      // and 'resetSelectionOnContextMenu' option is true.
      var reset = cm.options.resetSelectionOnContextMenu;
      if (reset && cm.doc.sel.contains(pos) == -1)
        { operation(cm, setSelection)(cm.doc, simpleSelection(pos), sel_dontScroll); }

      var oldCSS = te.style.cssText, oldWrapperCSS = input.wrapper.style.cssText;
      var wrapperBox = input.wrapper.offsetParent.getBoundingClientRect();
      input.wrapper.style.cssText = "position: static";
      te.style.cssText = "position: absolute; width: 30px; height: 30px;\n      top: " + (e.clientY - wrapperBox.top - 5) + "px; left: " + (e.clientX - wrapperBox.left - 5) + "px;\n      z-index: 1000; background: " + (ie ? "rgba(255, 255, 255, .05)" : "transparent") + ";\n      outline: none; border-width: 0; outline: none; overflow: hidden; opacity: .05; filter: alpha(opacity=5);";
      var oldScrollY;
      if (webkit) { oldScrollY = window.scrollY; } // Work around Chrome issue (#2712)
      display.input.focus();
      if (webkit) { window.scrollTo(null, oldScrollY); }
      display.input.reset();
      // Adds "Select all" to context menu in FF
      if (!cm.somethingSelected()) { te.value = input.prevInput = " "; }
      input.contextMenuPending = rehide;
      display.selForContextMenu = cm.doc.sel;
      clearTimeout(display.detectingSelectAll);

      // Select-all will be greyed out if there's nothing to select, so
      // this adds a zero-width space so that we can later check whether
      // it got selected.
      function prepareSelectAllHack() {
        if (te.selectionStart != null) {
          var selected = cm.somethingSelected();
          var extval = "\u200b" + (selected ? te.value : "");
          te.value = "\u21da"; // Used to catch context-menu undo
          te.value = extval;
          input.prevInput = selected ? "" : "\u200b";
          te.selectionStart = 1; te.selectionEnd = extval.length;
          // Re-set this, in case some other handler touched the
          // selection in the meantime.
          display.selForContextMenu = cm.doc.sel;
        }
      }
      function rehide() {
        if (input.contextMenuPending != rehide) { return }
        input.contextMenuPending = false;
        input.wrapper.style.cssText = oldWrapperCSS;
        te.style.cssText = oldCSS;
        if (ie && ie_version < 9) { display.scrollbars.setScrollTop(display.scroller.scrollTop = scrollPos); }

        // Try to detect the user choosing select-all
        if (te.selectionStart != null) {
          if (!ie || (ie && ie_version < 9)) { prepareSelectAllHack(); }
          var i = 0, poll = function () {
            if (display.selForContextMenu == cm.doc.sel && te.selectionStart == 0 &&
                te.selectionEnd > 0 && input.prevInput == "\u200b") {
              operation(cm, selectAll)(cm);
            } else if (i++ < 10) {
              display.detectingSelectAll = setTimeout(poll, 500);
            } else {
              display.selForContextMenu = null;
              display.input.reset();
            }
          };
          display.detectingSelectAll = setTimeout(poll, 200);
        }
      }

      if (ie && ie_version >= 9) { prepareSelectAllHack(); }
      if (captureRightClick) {
        e_stop(e);
        var mouseup = function () {
          off(window, "mouseup", mouseup);
          setTimeout(rehide, 20);
        };
        on(window, "mouseup", mouseup);
      } else {
        setTimeout(rehide, 50);
      }
    };

    TextareaInput.prototype.readOnlyChanged = function (val) {
      if (!val) { this.reset(); }
      this.textarea.disabled = val == "nocursor";
      this.textarea.readOnly = !!val;
    };

    TextareaInput.prototype.setUneditable = function () {};

    TextareaInput.prototype.needsContentAttribute = false;

    function fromTextArea(textarea, options) {
      options = options ? copyObj(options) : {};
      options.value = textarea.value;
      if (!options.tabindex && textarea.tabIndex)
        { options.tabindex = textarea.tabIndex; }
      if (!options.placeholder && textarea.placeholder)
        { options.placeholder = textarea.placeholder; }
      // Set autofocus to true if this textarea is focused, or if it has
      // autofocus and no other element is focused.
      if (options.autofocus == null) {
        var hasFocus = activeElt();
        options.autofocus = hasFocus == textarea ||
          textarea.getAttribute("autofocus") != null && hasFocus == document.body;
      }

      function save() {textarea.value = cm.getValue();}

      var realSubmit;
      if (textarea.form) {
        on(textarea.form, "submit", save);
        // Deplorable hack to make the submit method do the right thing.
        if (!options.leaveSubmitMethodAlone) {
          var form = textarea.form;
          realSubmit = form.submit;
          try {
            var wrappedSubmit = form.submit = function () {
              save();
              form.submit = realSubmit;
              form.submit();
              form.submit = wrappedSubmit;
            };
          } catch(e) {}
        }
      }

      options.finishInit = function (cm) {
        cm.save = save;
        cm.getTextArea = function () { return textarea; };
        cm.toTextArea = function () {
          cm.toTextArea = isNaN; // Prevent this from being ran twice
          save();
          textarea.parentNode.removeChild(cm.getWrapperElement());
          textarea.style.display = "";
          if (textarea.form) {
            off(textarea.form, "submit", save);
            if (!options.leaveSubmitMethodAlone && typeof textarea.form.submit == "function")
              { textarea.form.submit = realSubmit; }
          }
        };
      };

      textarea.style.display = "none";
      var cm = CodeMirror(function (node) { return textarea.parentNode.insertBefore(node, textarea.nextSibling); },
        options);
      return cm
    }

    function addLegacyProps(CodeMirror) {
      CodeMirror.off = off;
      CodeMirror.on = on;
      CodeMirror.wheelEventPixels = wheelEventPixels;
      CodeMirror.Doc = Doc;
      CodeMirror.splitLines = splitLinesAuto;
      CodeMirror.countColumn = countColumn;
      CodeMirror.findColumn = findColumn;
      CodeMirror.isWordChar = isWordCharBasic;
      CodeMirror.Pass = Pass;
      CodeMirror.signal = signal;
      CodeMirror.Line = Line;
      CodeMirror.changeEnd = changeEnd;
      CodeMirror.scrollbarModel = scrollbarModel;
      CodeMirror.Pos = Pos;
      CodeMirror.cmpPos = cmp;
      CodeMirror.modes = modes;
      CodeMirror.mimeModes = mimeModes;
      CodeMirror.resolveMode = resolveMode;
      CodeMirror.getMode = getMode;
      CodeMirror.modeExtensions = modeExtensions;
      CodeMirror.extendMode = extendMode;
      CodeMirror.copyState = copyState;
      CodeMirror.startState = startState;
      CodeMirror.innerMode = innerMode;
      CodeMirror.commands = commands;
      CodeMirror.keyMap = keyMap;
      CodeMirror.keyName = keyName;
      CodeMirror.isModifierKey = isModifierKey;
      CodeMirror.lookupKey = lookupKey;
      CodeMirror.normalizeKeyMap = normalizeKeyMap;
      CodeMirror.StringStream = StringStream;
      CodeMirror.SharedTextMarker = SharedTextMarker;
      CodeMirror.TextMarker = TextMarker;
      CodeMirror.LineWidget = LineWidget;
      CodeMirror.e_preventDefault = e_preventDefault;
      CodeMirror.e_stopPropagation = e_stopPropagation;
      CodeMirror.e_stop = e_stop;
      CodeMirror.addClass = addClass;
      CodeMirror.contains = contains;
      CodeMirror.rmClass = rmClass;
      CodeMirror.keyNames = keyNames;
    }

    // EDITOR CONSTRUCTOR

    defineOptions(CodeMirror);

    addEditorMethods(CodeMirror);

    // Set up methods on CodeMirror's prototype to redirect to the editor's document.
    var dontDelegate = "iter insert remove copy getEditor constructor".split(" ");
    for (var prop in Doc.prototype) { if (Doc.prototype.hasOwnProperty(prop) && indexOf(dontDelegate, prop) < 0)
      { CodeMirror.prototype[prop] = (function(method) {
        return function() {return method.apply(this.doc, arguments)}
      })(Doc.prototype[prop]); } }

    eventMixin(Doc);
    CodeMirror.inputStyles = {"textarea": TextareaInput, "contenteditable": ContentEditableInput};

    // Extra arguments are stored as the mode's dependencies, which is
    // used by (legacy) mechanisms like loadmode.js to automatically
    // load a mode. (Preferred mechanism is the require/define calls.)
    CodeMirror.defineMode = function(name/*, mode, …*/) {
      if (!CodeMirror.defaults.mode && name != "null") { CodeMirror.defaults.mode = name; }
      defineMode.apply(this, arguments);
    };

    CodeMirror.defineMIME = defineMIME;

    // Minimal default mode.
    CodeMirror.defineMode("null", function () { return ({token: function (stream) { return stream.skipToEnd(); }}); });
    CodeMirror.defineMIME("text/plain", "null");

    // EXTENSIONS

    CodeMirror.defineExtension = function (name, func) {
      CodeMirror.prototype[name] = func;
    };
    CodeMirror.defineDocExtension = function (name, func) {
      Doc.prototype[name] = func;
    };

    CodeMirror.fromTextArea = fromTextArea;

    addLegacyProps(CodeMirror);

    CodeMirror.version = "5.60.0";

    return CodeMirror;

  })));
  });

  createCommonjsModule(function (module, exports) {
  // CodeMirror, copyright (c) by Marijn Haverbeke and others
  // Distributed under an MIT license: https://codemirror.net/LICENSE

  (function(mod) {
    { mod(codemirror); }
  })(function(CodeMirror) {
    var GUTTER_ID = "CodeMirror-lint-markers";

    function showTooltip(cm, e, content) {
      var tt = document.createElement("div");
      tt.className = "CodeMirror-lint-tooltip cm-s-" + cm.options.theme;
      tt.appendChild(content.cloneNode(true));
      if (cm.state.lint.options.selfContain)
        { cm.getWrapperElement().appendChild(tt); }
      else
        { document.body.appendChild(tt); }

      function position(e) {
        if (!tt.parentNode) { return CodeMirror.off(document, "mousemove", position); }
        tt.style.top = Math.max(0, e.clientY - tt.offsetHeight - 5) + "px";
        tt.style.left = (e.clientX + 5) + "px";
      }
      CodeMirror.on(document, "mousemove", position);
      position(e);
      if (tt.style.opacity != null) { tt.style.opacity = 1; }
      return tt;
    }
    function rm(elt) {
      if (elt.parentNode) { elt.parentNode.removeChild(elt); }
    }
    function hideTooltip(tt) {
      if (!tt.parentNode) { return; }
      if (tt.style.opacity == null) { rm(tt); }
      tt.style.opacity = 0;
      setTimeout(function() { rm(tt); }, 600);
    }

    function showTooltipFor(cm, e, content, node) {
      var tooltip = showTooltip(cm, e, content);
      function hide() {
        CodeMirror.off(node, "mouseout", hide);
        if (tooltip) { hideTooltip(tooltip); tooltip = null; }
      }
      var poll = setInterval(function() {
        if (tooltip) { for (var n = node;; n = n.parentNode) {
          if (n && n.nodeType == 11) { n = n.host; }
          if (n == document.body) { return; }
          if (!n) { hide(); break; }
        } }
        if (!tooltip) { return clearInterval(poll); }
      }, 400);
      CodeMirror.on(node, "mouseout", hide);
    }

    function LintState(cm, options, hasGutter) {
      this.marked = [];
      this.options = options;
      this.timeout = null;
      this.hasGutter = hasGutter;
      this.onMouseOver = function(e) { onMouseOver(cm, e); };
      this.waitingFor = 0;
    }

    function parseOptions(_cm, options) {
      if (options instanceof Function) { return {getAnnotations: options}; }
      if (!options || options === true) { options = {}; }
      return options;
    }

    function clearMarks(cm) {
      var state = cm.state.lint;
      if (state.hasGutter) { cm.clearGutter(GUTTER_ID); }
      for (var i = 0; i < state.marked.length; ++i)
        { state.marked[i].clear(); }
      state.marked.length = 0;
    }

    function makeMarker(cm, labels, severity, multiple, tooltips) {
      var marker = document.createElement("div"), inner = marker;
      marker.className = "CodeMirror-lint-marker CodeMirror-lint-marker-" + severity;
      if (multiple) {
        inner = marker.appendChild(document.createElement("div"));
        inner.className = "CodeMirror-lint-marker CodeMirror-lint-marker-multiple";
      }

      if (tooltips != false) { CodeMirror.on(inner, "mouseover", function(e) {
        showTooltipFor(cm, e, labels, inner);
      }); }

      return marker;
    }

    function getMaxSeverity(a, b) {
      if (a == "error") { return a; }
      else { return b; }
    }

    function groupByLine(annotations) {
      var lines = [];
      for (var i = 0; i < annotations.length; ++i) {
        var ann = annotations[i], line = ann.from.line;
        (lines[line] || (lines[line] = [])).push(ann);
      }
      return lines;
    }

    function annotationTooltip(ann) {
      var severity = ann.severity;
      if (!severity) { severity = "error"; }
      var tip = document.createElement("div");
      tip.className = "CodeMirror-lint-message CodeMirror-lint-message-" + severity;
      if (typeof ann.messageHTML != 'undefined') {
        tip.innerHTML = ann.messageHTML;
      } else {
        tip.appendChild(document.createTextNode(ann.message));
      }
      return tip;
    }

    function lintAsync(cm, getAnnotations, passOptions) {
      var state = cm.state.lint;
      var id = ++state.waitingFor;
      function abort() {
        id = -1;
        cm.off("change", abort);
      }
      cm.on("change", abort);
      getAnnotations(cm.getValue(), function(annotations, arg2) {
        cm.off("change", abort);
        if (state.waitingFor != id) { return }
        if (arg2 && annotations instanceof CodeMirror) { annotations = arg2; }
        cm.operation(function() {updateLinting(cm, annotations);});
      }, passOptions, cm);
    }

    function startLinting(cm) {
      var state = cm.state.lint, options = state.options;
      /*
       * Passing rules in `options` property prevents JSHint (and other linters) from complaining
       * about unrecognized rules like `onUpdateLinting`, `delay`, `lintOnChange`, etc.
       */
      var passOptions = options.options || options;
      var getAnnotations = options.getAnnotations || cm.getHelper(CodeMirror.Pos(0, 0), "lint");
      if (!getAnnotations) { return; }
      if (options.async || getAnnotations.async) {
        lintAsync(cm, getAnnotations, passOptions);
      } else {
        var annotations = getAnnotations(cm.getValue(), passOptions, cm);
        if (!annotations) { return; }
        if (annotations.then) { annotations.then(function(issues) {
          cm.operation(function() {updateLinting(cm, issues);});
        }); }
        else { cm.operation(function() {updateLinting(cm, annotations);}); }
      }
    }

    function updateLinting(cm, annotationsNotSorted) {
      clearMarks(cm);
      var state = cm.state.lint, options = state.options;

      var annotations = groupByLine(annotationsNotSorted);

      for (var line = 0; line < annotations.length; ++line) {
        var anns = annotations[line];
        if (!anns) { continue; }

        // filter out duplicate messages
        var message = [];
        anns = anns.filter(function(item) { return message.indexOf(item.message) > -1 ? false : message.push(item.message) });

        var maxSeverity = null;
        var tipLabel = state.hasGutter && document.createDocumentFragment();

        for (var i = 0; i < anns.length; ++i) {
          var ann = anns[i];
          var severity = ann.severity;
          if (!severity) { severity = "error"; }
          maxSeverity = getMaxSeverity(maxSeverity, severity);

          if (options.formatAnnotation) { ann = options.formatAnnotation(ann); }
          if (state.hasGutter) { tipLabel.appendChild(annotationTooltip(ann)); }

          if (ann.to) { state.marked.push(cm.markText(ann.from, ann.to, {
            className: "CodeMirror-lint-mark CodeMirror-lint-mark-" + severity,
            __annotation: ann
          })); }
        }
        // use original annotations[line] to show multiple messages
        if (state.hasGutter)
          { cm.setGutterMarker(line, GUTTER_ID, makeMarker(cm, tipLabel, maxSeverity, annotations[line].length > 1,
                                                         state.options.tooltips)); }
      }
      if (options.onUpdateLinting) { options.onUpdateLinting(annotationsNotSorted, annotations, cm); }
    }

    function onChange(cm) {
      var state = cm.state.lint;
      if (!state) { return; }
      clearTimeout(state.timeout);
      state.timeout = setTimeout(function(){startLinting(cm);}, state.options.delay || 500);
    }

    function popupTooltips(cm, annotations, e) {
      var target = e.target || e.srcElement;
      var tooltip = document.createDocumentFragment();
      for (var i = 0; i < annotations.length; i++) {
        var ann = annotations[i];
        tooltip.appendChild(annotationTooltip(ann));
      }
      showTooltipFor(cm, e, tooltip, target);
    }

    function onMouseOver(cm, e) {
      var target = e.target || e.srcElement;
      if (!/\bCodeMirror-lint-mark-/.test(target.className)) { return; }
      var box = target.getBoundingClientRect(), x = (box.left + box.right) / 2, y = (box.top + box.bottom) / 2;
      var spans = cm.findMarksAt(cm.coordsChar({left: x, top: y}, "client"));

      var annotations = [];
      for (var i = 0; i < spans.length; ++i) {
        var ann = spans[i].__annotation;
        if (ann) { annotations.push(ann); }
      }
      if (annotations.length) { popupTooltips(cm, annotations, e); }
    }

    CodeMirror.defineOption("lint", false, function(cm, val, old) {
      if (old && old != CodeMirror.Init) {
        clearMarks(cm);
        if (cm.state.lint.options.lintOnChange !== false)
          { cm.off("change", onChange); }
        CodeMirror.off(cm.getWrapperElement(), "mouseover", cm.state.lint.onMouseOver);
        clearTimeout(cm.state.lint.timeout);
        delete cm.state.lint;
      }

      if (val) {
        var gutters = cm.getOption("gutters"), hasLintGutter = false;
        for (var i = 0; i < gutters.length; ++i) { if (gutters[i] == GUTTER_ID) { hasLintGutter = true; } }
        var state = cm.state.lint = new LintState(cm, parseOptions(cm, val), hasLintGutter);
        if (state.options.lintOnChange !== false)
          { cm.on("change", onChange); }
        if (state.options.tooltips != false && state.options.tooltips != "gutter")
          { CodeMirror.on(cm.getWrapperElement(), "mouseover", state.onMouseOver); }

        startLinting(cm);
      }
    });

    CodeMirror.defineExtension("performLint", function() {
      if (this.state.lint) { startLinting(this); }
    });
  });
  });

  createCommonjsModule(function (module, exports) {
  // CodeMirror, copyright (c) by Marijn Haverbeke and others
  // Distributed under an MIT license: https://codemirror.net/LICENSE

  // Depends on jsonlint.js from https://github.com/zaach/jsonlint

  // declare global: jsonlint

  (function(mod) {
    { mod(codemirror); }
  })(function(CodeMirror) {

  CodeMirror.registerHelper("lint", "json", function(text) {
    var found = [];
    if (!window.jsonlint) {
      if (window.console) {
        window.console.error("Error: window.jsonlint not defined, CodeMirror JSON linting cannot run.");
      }
      return found;
    }
    // for jsonlint's web dist jsonlint is exported as an object with a single property parser, of which parseError
    // is a subproperty
    var jsonlint = window.jsonlint.parser || window.jsonlint;
    jsonlint.parseError = function(str, hash) {
      var loc = hash.loc;
      found.push({from: CodeMirror.Pos(loc.first_line - 1, loc.first_column),
                  to: CodeMirror.Pos(loc.last_line - 1, loc.last_column),
                  message: str});
    };
    try { jsonlint.parse(text); }
    catch(e) {}
    return found;
  });

  });
  });

  createCommonjsModule(function (module, exports) {
  // CodeMirror, copyright (c) by Marijn Haverbeke and others
  // Distributed under an MIT license: https://codemirror.net/LICENSE

  (function(mod) {
    { mod(codemirror); }
  })(function(CodeMirror) {

  CodeMirror.defineMode("javascript", function(config, parserConfig) {
    var indentUnit = config.indentUnit;
    var statementIndent = parserConfig.statementIndent;
    var jsonldMode = parserConfig.jsonld;
    var jsonMode = parserConfig.json || jsonldMode;
    var isTS = parserConfig.typescript;
    var wordRE = parserConfig.wordCharacters || /[\w$\xa1-\uffff]/;

    // Tokenizer

    var keywords = function(){
      function kw(type) {return {type: type, style: "keyword"};}
      var A = kw("keyword a"), B = kw("keyword b"), C = kw("keyword c"), D = kw("keyword d");
      var operator = kw("operator"), atom = {type: "atom", style: "atom"};

      return {
        "if": kw("if"), "while": A, "with": A, "else": B, "do": B, "try": B, "finally": B,
        "return": D, "break": D, "continue": D, "new": kw("new"), "delete": C, "void": C, "throw": C,
        "debugger": kw("debugger"), "var": kw("var"), "const": kw("var"), "let": kw("var"),
        "function": kw("function"), "catch": kw("catch"),
        "for": kw("for"), "switch": kw("switch"), "case": kw("case"), "default": kw("default"),
        "in": operator, "typeof": operator, "instanceof": operator,
        "true": atom, "false": atom, "null": atom, "undefined": atom, "NaN": atom, "Infinity": atom,
        "this": kw("this"), "class": kw("class"), "super": kw("atom"),
        "yield": C, "export": kw("export"), "import": kw("import"), "extends": C,
        "await": C
      };
    }();

    var isOperatorChar = /[+\-*&%=<>!?|~^@]/;
    var isJsonldKeyword = /^@(context|id|value|language|type|container|list|set|reverse|index|base|vocab|graph)"/;

    function readRegexp(stream) {
      var escaped = false, next, inSet = false;
      while ((next = stream.next()) != null) {
        if (!escaped) {
          if (next == "/" && !inSet) { return; }
          if (next == "[") { inSet = true; }
          else if (inSet && next == "]") { inSet = false; }
        }
        escaped = !escaped && next == "\\";
      }
    }

    // Used as scratch variables to communicate multiple values without
    // consing up tons of objects.
    var type, content;
    function ret(tp, style, cont) {
      type = tp; content = cont;
      return style;
    }
    function tokenBase(stream, state) {
      var ch = stream.next();
      if (ch == '"' || ch == "'") {
        state.tokenize = tokenString(ch);
        return state.tokenize(stream, state);
      } else if (ch == "." && stream.match(/^\d[\d_]*(?:[eE][+\-]?[\d_]+)?/)) {
        return ret("number", "number");
      } else if (ch == "." && stream.match("..")) {
        return ret("spread", "meta");
      } else if (/[\[\]{}\(\),;\:\.]/.test(ch)) {
        return ret(ch);
      } else if (ch == "=" && stream.eat(">")) {
        return ret("=>", "operator");
      } else if (ch == "0" && stream.match(/^(?:x[\dA-Fa-f_]+|o[0-7_]+|b[01_]+)n?/)) {
        return ret("number", "number");
      } else if (/\d/.test(ch)) {
        stream.match(/^[\d_]*(?:n|(?:\.[\d_]*)?(?:[eE][+\-]?[\d_]+)?)?/);
        return ret("number", "number");
      } else if (ch == "/") {
        if (stream.eat("*")) {
          state.tokenize = tokenComment;
          return tokenComment(stream, state);
        } else if (stream.eat("/")) {
          stream.skipToEnd();
          return ret("comment", "comment");
        } else if (expressionAllowed(stream, state, 1)) {
          readRegexp(stream);
          stream.match(/^\b(([gimyus])(?![gimyus]*\2))+\b/);
          return ret("regexp", "string-2");
        } else {
          stream.eat("=");
          return ret("operator", "operator", stream.current());
        }
      } else if (ch == "`") {
        state.tokenize = tokenQuasi;
        return tokenQuasi(stream, state);
      } else if (ch == "#" && stream.peek() == "!") {
        stream.skipToEnd();
        return ret("meta", "meta");
      } else if (ch == "#" && stream.eatWhile(wordRE)) {
        return ret("variable", "property")
      } else if (ch == "<" && stream.match("!--") ||
                 (ch == "-" && stream.match("->") && !/\S/.test(stream.string.slice(0, stream.start)))) {
        stream.skipToEnd();
        return ret("comment", "comment")
      } else if (isOperatorChar.test(ch)) {
        if (ch != ">" || !state.lexical || state.lexical.type != ">") {
          if (stream.eat("=")) {
            if (ch == "!" || ch == "=") { stream.eat("="); }
          } else if (/[<>*+\-|&?]/.test(ch)) {
            stream.eat(ch);
            if (ch == ">") { stream.eat(ch); }
          }
        }
        if (ch == "?" && stream.eat(".")) { return ret(".") }
        return ret("operator", "operator", stream.current());
      } else if (wordRE.test(ch)) {
        stream.eatWhile(wordRE);
        var word = stream.current();
        if (state.lastType != ".") {
          if (keywords.propertyIsEnumerable(word)) {
            var kw = keywords[word];
            return ret(kw.type, kw.style, word)
          }
          if (word == "async" && stream.match(/^(\s|\/\*([^*]|\*(?!\/))*?\*\/)*[\[\(\w]/, false))
            { return ret("async", "keyword", word) }
        }
        return ret("variable", "variable", word)
      }
    }

    function tokenString(quote) {
      return function(stream, state) {
        var escaped = false, next;
        if (jsonldMode && stream.peek() == "@" && stream.match(isJsonldKeyword)){
          state.tokenize = tokenBase;
          return ret("jsonld-keyword", "meta");
        }
        while ((next = stream.next()) != null) {
          if (next == quote && !escaped) { break; }
          escaped = !escaped && next == "\\";
        }
        if (!escaped) { state.tokenize = tokenBase; }
        return ret("string", "string");
      };
    }

    function tokenComment(stream, state) {
      var maybeEnd = false, ch;
      while (ch = stream.next()) {
        if (ch == "/" && maybeEnd) {
          state.tokenize = tokenBase;
          break;
        }
        maybeEnd = (ch == "*");
      }
      return ret("comment", "comment");
    }

    function tokenQuasi(stream, state) {
      var escaped = false, next;
      while ((next = stream.next()) != null) {
        if (!escaped && (next == "`" || next == "$" && stream.eat("{"))) {
          state.tokenize = tokenBase;
          break;
        }
        escaped = !escaped && next == "\\";
      }
      return ret("quasi", "string-2", stream.current());
    }

    var brackets = "([{}])";
    // This is a crude lookahead trick to try and notice that we're
    // parsing the argument patterns for a fat-arrow function before we
    // actually hit the arrow token. It only works if the arrow is on
    // the same line as the arguments and there's no strange noise
    // (comments) in between. Fallback is to only notice when we hit the
    // arrow, and not declare the arguments as locals for the arrow
    // body.
    function findFatArrow(stream, state) {
      if (state.fatArrowAt) { state.fatArrowAt = null; }
      var arrow = stream.string.indexOf("=>", stream.start);
      if (arrow < 0) { return; }

      if (isTS) { // Try to skip TypeScript return type declarations after the arguments
        var m = /:\s*(?:\w+(?:<[^>]*>|\[\])?|\{[^}]*\})\s*$/.exec(stream.string.slice(stream.start, arrow));
        if (m) { arrow = m.index; }
      }

      var depth = 0, sawSomething = false;
      for (var pos = arrow - 1; pos >= 0; --pos) {
        var ch = stream.string.charAt(pos);
        var bracket = brackets.indexOf(ch);
        if (bracket >= 0 && bracket < 3) {
          if (!depth) { ++pos; break; }
          if (--depth == 0) { if (ch == "(") { sawSomething = true; } break; }
        } else if (bracket >= 3 && bracket < 6) {
          ++depth;
        } else if (wordRE.test(ch)) {
          sawSomething = true;
        } else if (/["'\/`]/.test(ch)) {
          for (;; --pos) {
            if (pos == 0) { return }
            var next = stream.string.charAt(pos - 1);
            if (next == ch && stream.string.charAt(pos - 2) != "\\") { pos--; break }
          }
        } else if (sawSomething && !depth) {
          ++pos;
          break;
        }
      }
      if (sawSomething && !depth) { state.fatArrowAt = pos; }
    }

    // Parser

    var atomicTypes = {"atom": true, "number": true, "variable": true, "string": true,
                       "regexp": true, "this": true, "import": true, "jsonld-keyword": true};

    function JSLexical(indented, column, type, align, prev, info) {
      this.indented = indented;
      this.column = column;
      this.type = type;
      this.prev = prev;
      this.info = info;
      if (align != null) { this.align = align; }
    }

    function inScope(state, varname) {
      for (var v = state.localVars; v; v = v.next)
        { if (v.name == varname) { return true; } }
      for (var cx = state.context; cx; cx = cx.prev) {
        for (var v = cx.vars; v; v = v.next)
          { if (v.name == varname) { return true; } }
      }
    }

    function parseJS(state, style, type, content, stream) {
      var cc = state.cc;
      // Communicate our context to the combinators.
      // (Less wasteful than consing up a hundred closures on every call.)
      cx.state = state; cx.stream = stream; cx.marked = null, cx.cc = cc; cx.style = style;

      if (!state.lexical.hasOwnProperty("align"))
        { state.lexical.align = true; }

      while(true) {
        var combinator = cc.length ? cc.pop() : jsonMode ? expression : statement;
        if (combinator(type, content)) {
          while(cc.length && cc[cc.length - 1].lex)
            { cc.pop()(); }
          if (cx.marked) { return cx.marked; }
          if (type == "variable" && inScope(state, content)) { return "variable-2"; }
          return style;
        }
      }
    }

    // Combinator utils

    var cx = {state: null, column: null, marked: null, cc: null};
    function pass() {
      var arguments$1 = arguments;

      for (var i = arguments.length - 1; i >= 0; i--) { cx.cc.push(arguments$1[i]); }
    }
    function cont() {
      pass.apply(null, arguments);
      return true;
    }
    function inList(name, list) {
      for (var v = list; v; v = v.next) { if (v.name == name) { return true } }
      return false;
    }
    function register(varname) {
      var state = cx.state;
      cx.marked = "def";
      if (state.context) {
        if (state.lexical.info == "var" && state.context && state.context.block) {
          // FIXME function decls are also not block scoped
          var newContext = registerVarScoped(varname, state.context);
          if (newContext != null) {
            state.context = newContext;
            return
          }
        } else if (!inList(varname, state.localVars)) {
          state.localVars = new Var(varname, state.localVars);
          return
        }
      }
      // Fall through means this is global
      if (parserConfig.globalVars && !inList(varname, state.globalVars))
        { state.globalVars = new Var(varname, state.globalVars); }
    }
    function registerVarScoped(varname, context) {
      if (!context) {
        return null
      } else if (context.block) {
        var inner = registerVarScoped(varname, context.prev);
        if (!inner) { return null }
        if (inner == context.prev) { return context }
        return new Context(inner, context.vars, true)
      } else if (inList(varname, context.vars)) {
        return context
      } else {
        return new Context(context.prev, new Var(varname, context.vars), false)
      }
    }

    function isModifier(name) {
      return name == "public" || name == "private" || name == "protected" || name == "abstract" || name == "readonly"
    }

    // Combinators

    function Context(prev, vars, block) { this.prev = prev; this.vars = vars; this.block = block; }
    function Var(name, next) { this.name = name; this.next = next; }

    var defaultVars = new Var("this", new Var("arguments", null));
    function pushcontext() {
      cx.state.context = new Context(cx.state.context, cx.state.localVars, false);
      cx.state.localVars = defaultVars;
    }
    function pushblockcontext() {
      cx.state.context = new Context(cx.state.context, cx.state.localVars, true);
      cx.state.localVars = null;
    }
    function popcontext() {
      cx.state.localVars = cx.state.context.vars;
      cx.state.context = cx.state.context.prev;
    }
    popcontext.lex = true;
    function pushlex(type, info) {
      var result = function() {
        var state = cx.state, indent = state.indented;
        if (state.lexical.type == "stat") { indent = state.lexical.indented; }
        else { for (var outer = state.lexical; outer && outer.type == ")" && outer.align; outer = outer.prev)
          { indent = outer.indented; } }
        state.lexical = new JSLexical(indent, cx.stream.column(), type, null, state.lexical, info);
      };
      result.lex = true;
      return result;
    }
    function poplex() {
      var state = cx.state;
      if (state.lexical.prev) {
        if (state.lexical.type == ")")
          { state.indented = state.lexical.indented; }
        state.lexical = state.lexical.prev;
      }
    }
    poplex.lex = true;

    function expect(wanted) {
      function exp(type) {
        if (type == wanted) { return cont(); }
        else if (wanted == ";" || type == "}" || type == ")" || type == "]") { return pass(); }
        else { return cont(exp); }
      }    return exp;
    }

    function statement(type, value) {
      if (type == "var") { return cont(pushlex("vardef", value), vardef, expect(";"), poplex); }
      if (type == "keyword a") { return cont(pushlex("form"), parenExpr, statement, poplex); }
      if (type == "keyword b") { return cont(pushlex("form"), statement, poplex); }
      if (type == "keyword d") { return cx.stream.match(/^\s*$/, false) ? cont() : cont(pushlex("stat"), maybeexpression, expect(";"), poplex); }
      if (type == "debugger") { return cont(expect(";")); }
      if (type == "{") { return cont(pushlex("}"), pushblockcontext, block, poplex, popcontext); }
      if (type == ";") { return cont(); }
      if (type == "if") {
        if (cx.state.lexical.info == "else" && cx.state.cc[cx.state.cc.length - 1] == poplex)
          { cx.state.cc.pop()(); }
        return cont(pushlex("form"), parenExpr, statement, poplex, maybeelse);
      }
      if (type == "function") { return cont(functiondef); }
      if (type == "for") { return cont(pushlex("form"), forspec, statement, poplex); }
      if (type == "class" || (isTS && value == "interface")) {
        cx.marked = "keyword";
        return cont(pushlex("form", type == "class" ? type : value), className, poplex)
      }
      if (type == "variable") {
        if (isTS && value == "declare") {
          cx.marked = "keyword";
          return cont(statement)
        } else if (isTS && (value == "module" || value == "enum" || value == "type") && cx.stream.match(/^\s*\w/, false)) {
          cx.marked = "keyword";
          if (value == "enum") { return cont(enumdef); }
          else if (value == "type") { return cont(typename, expect("operator"), typeexpr, expect(";")); }
          else { return cont(pushlex("form"), pattern, expect("{"), pushlex("}"), block, poplex, poplex) }
        } else if (isTS && value == "namespace") {
          cx.marked = "keyword";
          return cont(pushlex("form"), expression, statement, poplex)
        } else if (isTS && value == "abstract") {
          cx.marked = "keyword";
          return cont(statement)
        } else {
          return cont(pushlex("stat"), maybelabel);
        }
      }
      if (type == "switch") { return cont(pushlex("form"), parenExpr, expect("{"), pushlex("}", "switch"), pushblockcontext,
                                        block, poplex, poplex, popcontext); }
      if (type == "case") { return cont(expression, expect(":")); }
      if (type == "default") { return cont(expect(":")); }
      if (type == "catch") { return cont(pushlex("form"), pushcontext, maybeCatchBinding, statement, poplex, popcontext); }
      if (type == "export") { return cont(pushlex("stat"), afterExport, poplex); }
      if (type == "import") { return cont(pushlex("stat"), afterImport, poplex); }
      if (type == "async") { return cont(statement) }
      if (value == "@") { return cont(expression, statement) }
      return pass(pushlex("stat"), expression, expect(";"), poplex);
    }
    function maybeCatchBinding(type) {
      if (type == "(") { return cont(funarg, expect(")")) }
    }
    function expression(type, value) {
      return expressionInner(type, value, false);
    }
    function expressionNoComma(type, value) {
      return expressionInner(type, value, true);
    }
    function parenExpr(type) {
      if (type != "(") { return pass() }
      return cont(pushlex(")"), maybeexpression, expect(")"), poplex)
    }
    function expressionInner(type, value, noComma) {
      if (cx.state.fatArrowAt == cx.stream.start) {
        var body = noComma ? arrowBodyNoComma : arrowBody;
        if (type == "(") { return cont(pushcontext, pushlex(")"), commasep(funarg, ")"), poplex, expect("=>"), body, popcontext); }
        else if (type == "variable") { return pass(pushcontext, pattern, expect("=>"), body, popcontext); }
      }

      var maybeop = noComma ? maybeoperatorNoComma : maybeoperatorComma;
      if (atomicTypes.hasOwnProperty(type)) { return cont(maybeop); }
      if (type == "function") { return cont(functiondef, maybeop); }
      if (type == "class" || (isTS && value == "interface")) { cx.marked = "keyword"; return cont(pushlex("form"), classExpression, poplex); }
      if (type == "keyword c" || type == "async") { return cont(noComma ? expressionNoComma : expression); }
      if (type == "(") { return cont(pushlex(")"), maybeexpression, expect(")"), poplex, maybeop); }
      if (type == "operator" || type == "spread") { return cont(noComma ? expressionNoComma : expression); }
      if (type == "[") { return cont(pushlex("]"), arrayLiteral, poplex, maybeop); }
      if (type == "{") { return contCommasep(objprop, "}", null, maybeop); }
      if (type == "quasi") { return pass(quasi, maybeop); }
      if (type == "new") { return cont(maybeTarget(noComma)); }
      return cont();
    }
    function maybeexpression(type) {
      if (type.match(/[;\}\)\],]/)) { return pass(); }
      return pass(expression);
    }

    function maybeoperatorComma(type, value) {
      if (type == ",") { return cont(maybeexpression); }
      return maybeoperatorNoComma(type, value, false);
    }
    function maybeoperatorNoComma(type, value, noComma) {
      var me = noComma == false ? maybeoperatorComma : maybeoperatorNoComma;
      var expr = noComma == false ? expression : expressionNoComma;
      if (type == "=>") { return cont(pushcontext, noComma ? arrowBodyNoComma : arrowBody, popcontext); }
      if (type == "operator") {
        if (/\+\+|--/.test(value) || isTS && value == "!") { return cont(me); }
        if (isTS && value == "<" && cx.stream.match(/^([^<>]|<[^<>]*>)*>\s*\(/, false))
          { return cont(pushlex(">"), commasep(typeexpr, ">"), poplex, me); }
        if (value == "?") { return cont(expression, expect(":"), expr); }
        return cont(expr);
      }
      if (type == "quasi") { return pass(quasi, me); }
      if (type == ";") { return; }
      if (type == "(") { return contCommasep(expressionNoComma, ")", "call", me); }
      if (type == ".") { return cont(property, me); }
      if (type == "[") { return cont(pushlex("]"), maybeexpression, expect("]"), poplex, me); }
      if (isTS && value == "as") { cx.marked = "keyword"; return cont(typeexpr, me) }
      if (type == "regexp") {
        cx.state.lastType = cx.marked = "operator";
        cx.stream.backUp(cx.stream.pos - cx.stream.start - 1);
        return cont(expr)
      }
    }
    function quasi(type, value) {
      if (type != "quasi") { return pass(); }
      if (value.slice(value.length - 2) != "${") { return cont(quasi); }
      return cont(expression, continueQuasi);
    }
    function continueQuasi(type) {
      if (type == "}") {
        cx.marked = "string-2";
        cx.state.tokenize = tokenQuasi;
        return cont(quasi);
      }
    }
    function arrowBody(type) {
      findFatArrow(cx.stream, cx.state);
      return pass(type == "{" ? statement : expression);
    }
    function arrowBodyNoComma(type) {
      findFatArrow(cx.stream, cx.state);
      return pass(type == "{" ? statement : expressionNoComma);
    }
    function maybeTarget(noComma) {
      return function(type) {
        if (type == ".") { return cont(noComma ? targetNoComma : target); }
        else if (type == "variable" && isTS) { return cont(maybeTypeArgs, noComma ? maybeoperatorNoComma : maybeoperatorComma) }
        else { return pass(noComma ? expressionNoComma : expression); }
      };
    }
    function target(_, value) {
      if (value == "target") { cx.marked = "keyword"; return cont(maybeoperatorComma); }
    }
    function targetNoComma(_, value) {
      if (value == "target") { cx.marked = "keyword"; return cont(maybeoperatorNoComma); }
    }
    function maybelabel(type) {
      if (type == ":") { return cont(poplex, statement); }
      return pass(maybeoperatorComma, expect(";"), poplex);
    }
    function property(type) {
      if (type == "variable") {cx.marked = "property"; return cont();}
    }
    function objprop(type, value) {
      if (type == "async") {
        cx.marked = "property";
        return cont(objprop);
      } else if (type == "variable" || cx.style == "keyword") {
        cx.marked = "property";
        if (value == "get" || value == "set") { return cont(getterSetter); }
        var m; // Work around fat-arrow-detection complication for detecting typescript typed arrow params
        if (isTS && cx.state.fatArrowAt == cx.stream.start && (m = cx.stream.match(/^\s*:\s*/, false)))
          { cx.state.fatArrowAt = cx.stream.pos + m[0].length; }
        return cont(afterprop);
      } else if (type == "number" || type == "string") {
        cx.marked = jsonldMode ? "property" : (cx.style + " property");
        return cont(afterprop);
      } else if (type == "jsonld-keyword") {
        return cont(afterprop);
      } else if (isTS && isModifier(value)) {
        cx.marked = "keyword";
        return cont(objprop)
      } else if (type == "[") {
        return cont(expression, maybetype, expect("]"), afterprop);
      } else if (type == "spread") {
        return cont(expressionNoComma, afterprop);
      } else if (value == "*") {
        cx.marked = "keyword";
        return cont(objprop);
      } else if (type == ":") {
        return pass(afterprop)
      }
    }
    function getterSetter(type) {
      if (type != "variable") { return pass(afterprop); }
      cx.marked = "property";
      return cont(functiondef);
    }
    function afterprop(type) {
      if (type == ":") { return cont(expressionNoComma); }
      if (type == "(") { return pass(functiondef); }
    }
    function commasep(what, end, sep) {
      function proceed(type, value) {
        if (sep ? sep.indexOf(type) > -1 : type == ",") {
          var lex = cx.state.lexical;
          if (lex.info == "call") { lex.pos = (lex.pos || 0) + 1; }
          return cont(function(type, value) {
            if (type == end || value == end) { return pass() }
            return pass(what)
          }, proceed);
        }
        if (type == end || value == end) { return cont(); }
        if (sep && sep.indexOf(";") > -1) { return pass(what) }
        return cont(expect(end));
      }
      return function(type, value) {
        if (type == end || value == end) { return cont(); }
        return pass(what, proceed);
      };
    }
    function contCommasep(what, end, info) {
      var arguments$1 = arguments;

      for (var i = 3; i < arguments.length; i++)
        { cx.cc.push(arguments$1[i]); }
      return cont(pushlex(end, info), commasep(what, end), poplex);
    }
    function block(type) {
      if (type == "}") { return cont(); }
      return pass(statement, block);
    }
    function maybetype(type, value) {
      if (isTS) {
        if (type == ":") { return cont(typeexpr); }
        if (value == "?") { return cont(maybetype); }
      }
    }
    function maybetypeOrIn(type, value) {
      if (isTS && (type == ":" || value == "in")) { return cont(typeexpr) }
    }
    function mayberettype(type) {
      if (isTS && type == ":") {
        if (cx.stream.match(/^\s*\w+\s+is\b/, false)) { return cont(expression, isKW, typeexpr) }
        else { return cont(typeexpr) }
      }
    }
    function isKW(_, value) {
      if (value == "is") {
        cx.marked = "keyword";
        return cont()
      }
    }
    function typeexpr(type, value) {
      if (value == "keyof" || value == "typeof" || value == "infer" || value == "readonly") {
        cx.marked = "keyword";
        return cont(value == "typeof" ? expressionNoComma : typeexpr)
      }
      if (type == "variable" || value == "void") {
        cx.marked = "type";
        return cont(afterType)
      }
      if (value == "|" || value == "&") { return cont(typeexpr) }
      if (type == "string" || type == "number" || type == "atom") { return cont(afterType); }
      if (type == "[") { return cont(pushlex("]"), commasep(typeexpr, "]", ","), poplex, afterType) }
      if (type == "{") { return cont(pushlex("}"), typeprops, poplex, afterType) }
      if (type == "(") { return cont(commasep(typearg, ")"), maybeReturnType, afterType) }
      if (type == "<") { return cont(commasep(typeexpr, ">"), typeexpr) }
    }
    function maybeReturnType(type) {
      if (type == "=>") { return cont(typeexpr) }
    }
    function typeprops(type) {
      if (type.match(/[\}\)\]]/)) { return cont() }
      if (type == "," || type == ";") { return cont(typeprops) }
      return pass(typeprop, typeprops)
    }
    function typeprop(type, value) {
      if (type == "variable" || cx.style == "keyword") {
        cx.marked = "property";
        return cont(typeprop)
      } else if (value == "?" || type == "number" || type == "string") {
        return cont(typeprop)
      } else if (type == ":") {
        return cont(typeexpr)
      } else if (type == "[") {
        return cont(expect("variable"), maybetypeOrIn, expect("]"), typeprop)
      } else if (type == "(") {
        return pass(functiondecl, typeprop)
      } else if (!type.match(/[;\}\)\],]/)) {
        return cont()
      }
    }
    function typearg(type, value) {
      if (type == "variable" && cx.stream.match(/^\s*[?:]/, false) || value == "?") { return cont(typearg) }
      if (type == ":") { return cont(typeexpr) }
      if (type == "spread") { return cont(typearg) }
      return pass(typeexpr)
    }
    function afterType(type, value) {
      if (value == "<") { return cont(pushlex(">"), commasep(typeexpr, ">"), poplex, afterType) }
      if (value == "|" || type == "." || value == "&") { return cont(typeexpr) }
      if (type == "[") { return cont(typeexpr, expect("]"), afterType) }
      if (value == "extends" || value == "implements") { cx.marked = "keyword"; return cont(typeexpr) }
      if (value == "?") { return cont(typeexpr, expect(":"), typeexpr) }
    }
    function maybeTypeArgs(_, value) {
      if (value == "<") { return cont(pushlex(">"), commasep(typeexpr, ">"), poplex, afterType) }
    }
    function typeparam() {
      return pass(typeexpr, maybeTypeDefault)
    }
    function maybeTypeDefault(_, value) {
      if (value == "=") { return cont(typeexpr) }
    }
    function vardef(_, value) {
      if (value == "enum") {cx.marked = "keyword"; return cont(enumdef)}
      return pass(pattern, maybetype, maybeAssign, vardefCont);
    }
    function pattern(type, value) {
      if (isTS && isModifier(value)) { cx.marked = "keyword"; return cont(pattern) }
      if (type == "variable") { register(value); return cont(); }
      if (type == "spread") { return cont(pattern); }
      if (type == "[") { return contCommasep(eltpattern, "]"); }
      if (type == "{") { return contCommasep(proppattern, "}"); }
    }
    function proppattern(type, value) {
      if (type == "variable" && !cx.stream.match(/^\s*:/, false)) {
        register(value);
        return cont(maybeAssign);
      }
      if (type == "variable") { cx.marked = "property"; }
      if (type == "spread") { return cont(pattern); }
      if (type == "}") { return pass(); }
      if (type == "[") { return cont(expression, expect(']'), expect(':'), proppattern); }
      return cont(expect(":"), pattern, maybeAssign);
    }
    function eltpattern() {
      return pass(pattern, maybeAssign)
    }
    function maybeAssign(_type, value) {
      if (value == "=") { return cont(expressionNoComma); }
    }
    function vardefCont(type) {
      if (type == ",") { return cont(vardef); }
    }
    function maybeelse(type, value) {
      if (type == "keyword b" && value == "else") { return cont(pushlex("form", "else"), statement, poplex); }
    }
    function forspec(type, value) {
      if (value == "await") { return cont(forspec); }
      if (type == "(") { return cont(pushlex(")"), forspec1, poplex); }
    }
    function forspec1(type) {
      if (type == "var") { return cont(vardef, forspec2); }
      if (type == "variable") { return cont(forspec2); }
      return pass(forspec2)
    }
    function forspec2(type, value) {
      if (type == ")") { return cont() }
      if (type == ";") { return cont(forspec2) }
      if (value == "in" || value == "of") { cx.marked = "keyword"; return cont(expression, forspec2) }
      return pass(expression, forspec2)
    }
    function functiondef(type, value) {
      if (value == "*") {cx.marked = "keyword"; return cont(functiondef);}
      if (type == "variable") {register(value); return cont(functiondef);}
      if (type == "(") { return cont(pushcontext, pushlex(")"), commasep(funarg, ")"), poplex, mayberettype, statement, popcontext); }
      if (isTS && value == "<") { return cont(pushlex(">"), commasep(typeparam, ">"), poplex, functiondef) }
    }
    function functiondecl(type, value) {
      if (value == "*") {cx.marked = "keyword"; return cont(functiondecl);}
      if (type == "variable") {register(value); return cont(functiondecl);}
      if (type == "(") { return cont(pushcontext, pushlex(")"), commasep(funarg, ")"), poplex, mayberettype, popcontext); }
      if (isTS && value == "<") { return cont(pushlex(">"), commasep(typeparam, ">"), poplex, functiondecl) }
    }
    function typename(type, value) {
      if (type == "keyword" || type == "variable") {
        cx.marked = "type";
        return cont(typename)
      } else if (value == "<") {
        return cont(pushlex(">"), commasep(typeparam, ">"), poplex)
      }
    }
    function funarg(type, value) {
      if (value == "@") { cont(expression, funarg); }
      if (type == "spread") { return cont(funarg); }
      if (isTS && isModifier(value)) { cx.marked = "keyword"; return cont(funarg); }
      if (isTS && type == "this") { return cont(maybetype, maybeAssign) }
      return pass(pattern, maybetype, maybeAssign);
    }
    function classExpression(type, value) {
      // Class expressions may have an optional name.
      if (type == "variable") { return className(type, value); }
      return classNameAfter(type, value);
    }
    function className(type, value) {
      if (type == "variable") {register(value); return cont(classNameAfter);}
    }
    function classNameAfter(type, value) {
      if (value == "<") { return cont(pushlex(">"), commasep(typeparam, ">"), poplex, classNameAfter) }
      if (value == "extends" || value == "implements" || (isTS && type == ",")) {
        if (value == "implements") { cx.marked = "keyword"; }
        return cont(isTS ? typeexpr : expression, classNameAfter);
      }
      if (type == "{") { return cont(pushlex("}"), classBody, poplex); }
    }
    function classBody(type, value) {
      if (type == "async" ||
          (type == "variable" &&
           (value == "static" || value == "get" || value == "set" || (isTS && isModifier(value))) &&
           cx.stream.match(/^\s+[\w$\xa1-\uffff]/, false))) {
        cx.marked = "keyword";
        return cont(classBody);
      }
      if (type == "variable" || cx.style == "keyword") {
        cx.marked = "property";
        return cont(classfield, classBody);
      }
      if (type == "number" || type == "string") { return cont(classfield, classBody); }
      if (type == "[")
        { return cont(expression, maybetype, expect("]"), classfield, classBody) }
      if (value == "*") {
        cx.marked = "keyword";
        return cont(classBody);
      }
      if (isTS && type == "(") { return pass(functiondecl, classBody) }
      if (type == ";" || type == ",") { return cont(classBody); }
      if (type == "}") { return cont(); }
      if (value == "@") { return cont(expression, classBody) }
    }
    function classfield(type, value) {
      if (value == "?") { return cont(classfield) }
      if (type == ":") { return cont(typeexpr, maybeAssign) }
      if (value == "=") { return cont(expressionNoComma) }
      var context = cx.state.lexical.prev, isInterface = context && context.info == "interface";
      return pass(isInterface ? functiondecl : functiondef)
    }
    function afterExport(type, value) {
      if (value == "*") { cx.marked = "keyword"; return cont(maybeFrom, expect(";")); }
      if (value == "default") { cx.marked = "keyword"; return cont(expression, expect(";")); }
      if (type == "{") { return cont(commasep(exportField, "}"), maybeFrom, expect(";")); }
      return pass(statement);
    }
    function exportField(type, value) {
      if (value == "as") { cx.marked = "keyword"; return cont(expect("variable")); }
      if (type == "variable") { return pass(expressionNoComma, exportField); }
    }
    function afterImport(type) {
      if (type == "string") { return cont(); }
      if (type == "(") { return pass(expression); }
      if (type == ".") { return pass(maybeoperatorComma); }
      return pass(importSpec, maybeMoreImports, maybeFrom);
    }
    function importSpec(type, value) {
      if (type == "{") { return contCommasep(importSpec, "}"); }
      if (type == "variable") { register(value); }
      if (value == "*") { cx.marked = "keyword"; }
      return cont(maybeAs);
    }
    function maybeMoreImports(type) {
      if (type == ",") { return cont(importSpec, maybeMoreImports) }
    }
    function maybeAs(_type, value) {
      if (value == "as") { cx.marked = "keyword"; return cont(importSpec); }
    }
    function maybeFrom(_type, value) {
      if (value == "from") { cx.marked = "keyword"; return cont(expression); }
    }
    function arrayLiteral(type) {
      if (type == "]") { return cont(); }
      return pass(commasep(expressionNoComma, "]"));
    }
    function enumdef() {
      return pass(pushlex("form"), pattern, expect("{"), pushlex("}"), commasep(enummember, "}"), poplex, poplex)
    }
    function enummember() {
      return pass(pattern, maybeAssign);
    }

    function isContinuedStatement(state, textAfter) {
      return state.lastType == "operator" || state.lastType == "," ||
        isOperatorChar.test(textAfter.charAt(0)) ||
        /[,.]/.test(textAfter.charAt(0));
    }

    function expressionAllowed(stream, state, backUp) {
      return state.tokenize == tokenBase &&
        /^(?:operator|sof|keyword [bcd]|case|new|export|default|spread|[\[{}\(,;:]|=>)$/.test(state.lastType) ||
        (state.lastType == "quasi" && /\{\s*$/.test(stream.string.slice(0, stream.pos - (backUp || 0))))
    }

    // Interface

    return {
      startState: function(basecolumn) {
        var state = {
          tokenize: tokenBase,
          lastType: "sof",
          cc: [],
          lexical: new JSLexical((basecolumn || 0) - indentUnit, 0, "block", false),
          localVars: parserConfig.localVars,
          context: parserConfig.localVars && new Context(null, null, false),
          indented: basecolumn || 0
        };
        if (parserConfig.globalVars && typeof parserConfig.globalVars == "object")
          { state.globalVars = parserConfig.globalVars; }
        return state;
      },

      token: function(stream, state) {
        if (stream.sol()) {
          if (!state.lexical.hasOwnProperty("align"))
            { state.lexical.align = false; }
          state.indented = stream.indentation();
          findFatArrow(stream, state);
        }
        if (state.tokenize != tokenComment && stream.eatSpace()) { return null; }
        var style = state.tokenize(stream, state);
        if (type == "comment") { return style; }
        state.lastType = type == "operator" && (content == "++" || content == "--") ? "incdec" : type;
        return parseJS(state, style, type, content, stream);
      },

      indent: function(state, textAfter) {
        if (state.tokenize == tokenComment || state.tokenize == tokenQuasi) { return CodeMirror.Pass; }
        if (state.tokenize != tokenBase) { return 0; }
        var firstChar = textAfter && textAfter.charAt(0), lexical = state.lexical, top;
        // Kludge to prevent 'maybelse' from blocking lexical scope pops
        if (!/^\s*else\b/.test(textAfter)) { for (var i = state.cc.length - 1; i >= 0; --i) {
          var c = state.cc[i];
          if (c == poplex) { lexical = lexical.prev; }
          else if (c != maybeelse) { break; }
        } }
        while ((lexical.type == "stat" || lexical.type == "form") &&
               (firstChar == "}" || ((top = state.cc[state.cc.length - 1]) &&
                                     (top == maybeoperatorComma || top == maybeoperatorNoComma) &&
                                     !/^[,\.=+\-*:?[\(]/.test(textAfter))))
          { lexical = lexical.prev; }
        if (statementIndent && lexical.type == ")" && lexical.prev.type == "stat")
          { lexical = lexical.prev; }
        var type = lexical.type, closing = firstChar == type;

        if (type == "vardef") { return lexical.indented + (state.lastType == "operator" || state.lastType == "," ? lexical.info.length + 1 : 0); }
        else if (type == "form" && firstChar == "{") { return lexical.indented; }
        else if (type == "form") { return lexical.indented + indentUnit; }
        else if (type == "stat")
          { return lexical.indented + (isContinuedStatement(state, textAfter) ? statementIndent || indentUnit : 0); }
        else if (lexical.info == "switch" && !closing && parserConfig.doubleIndentSwitch != false)
          { return lexical.indented + (/^(?:case|default)\b/.test(textAfter) ? indentUnit : 2 * indentUnit); }
        else if (lexical.align) { return lexical.column + (closing ? 0 : 1); }
        else { return lexical.indented + (closing ? 0 : indentUnit); }
      },

      electricInput: /^\s*(?:case .*?:|default:|\{|\})$/,
      blockCommentStart: jsonMode ? null : "/*",
      blockCommentEnd: jsonMode ? null : "*/",
      blockCommentContinue: jsonMode ? null : " * ",
      lineComment: jsonMode ? null : "//",
      fold: "brace",
      closeBrackets: "()[]{}''\"\"``",

      helperType: jsonMode ? "json" : "javascript",
      jsonldMode: jsonldMode,
      jsonMode: jsonMode,

      expressionAllowed: expressionAllowed,

      skipExpression: function(state) {
        var top = state.cc[state.cc.length - 1];
        if (top == expression || top == expressionNoComma) { state.cc.pop(); }
      }
    };
  });

  CodeMirror.registerHelper("wordChars", "javascript", /[\w$]/);

  CodeMirror.defineMIME("text/javascript", "javascript");
  CodeMirror.defineMIME("text/ecmascript", "javascript");
  CodeMirror.defineMIME("application/javascript", "javascript");
  CodeMirror.defineMIME("application/x-javascript", "javascript");
  CodeMirror.defineMIME("application/ecmascript", "javascript");
  CodeMirror.defineMIME("application/json", { name: "javascript", json: true });
  CodeMirror.defineMIME("application/x-json", { name: "javascript", json: true });
  CodeMirror.defineMIME("application/manifest+json", { name: "javascript", json: true });
  CodeMirror.defineMIME("application/ld+json", { name: "javascript", jsonld: true });
  CodeMirror.defineMIME("text/typescript", { name: "javascript", typescript: true });
  CodeMirror.defineMIME("application/typescript", { name: "javascript", typescript: true });

  });
  });

  //
  var script$3 = {
    name: 'Struct',
    props: {
      value: [Object, Array],
      title: {
        type: String,
        "default": '编辑数据'
      },
      defaultValue: {
        require: false
      },
      validate: Function
    },
    data: function data() {
      return {
        editor: null,
        visible: false,
        err: false,
        oldVal: null
      };
    },
    watch: {
      value: function value() {
        this.load();
      },
      visible: function visible(n) {
        if (n) {
          this.load();
        } else {
          this.err = false;
        }
      }
    },
    methods: {
      load: function load() {
        var _this = this;

        var val = JSON.stringify(this.value || this.defaultValue, null, 2);
        this.oldVal = val;
        this.$nextTick(function () {
          _this.editor = codemirror(_this.$refs.editor, {
            lineNumbers: true,
            mode: 'application/json',
            gutters: ['CodeMirror-lint-markers'],
            lint: true,
            line: true,
            tabSize: 2,
            lineWrapping: true,
            value: val || ''
          });

          _this.editor.on('blur', function () {
            _this.err = _this.editor.state.lint.marked.length > 0;
          });
        });
      },
      onOk: function onOk() {
        if (this.err) { return; }
        var val = JSON.parse(this.editor.getValue());

        if (this.validate && false === this.validate(val)) {
          this.err = true;
          return;
        }

        this.visible = false;

        if (JSON.stringify(val, null, 2) !== this.oldVal) {
          this.$emit('input', val);
        }
      }
    },
    beforeCreate: function beforeCreate() {
      window.jsonlint = jsonlint_1;
    }
  };

  var css_248z$3 = "._fc_struct .CodeMirror{height:450px}._fc_struct .CodeMirror-line{line-height:16px!important;font-size:13px!important}.CodeMirror-lint-tooltip{z-index:2021!important}._fc_struct .el-dialog__body{padding:0 20px}";
  styleInject(css_248z$3);

  /* script */
  var __vue_script__$3 = script$3;
  /* template */

  var __vue_render__$2 = function __vue_render__() {
    var _vm = this;

    var _h = _vm.$createElement;

    var _c = _vm._self._c || _h;

    return _c("div", {
      staticClass: "_fc_struct"
    }, [_c("ElButton", {
      staticStyle: {
        width: "100%"
      },
      on: {
        click: function click($event) {
          _vm.visible = true;
        }
      }
    }, [_vm._v(_vm._s(_vm.title))]), _vm._v(" "), _c("ElDialog", {
      attrs: {
        title: _vm.title,
        visible: _vm.visible,
        "close-on-click-modal": false,
        "append-to-body": ""
      },
      on: {
        "update:visible": function updateVisible($event) {
          _vm.visible = $event;
        }
      }
    }, [_vm.visible ? _c("div", {
      ref: "editor"
    }) : _vm._e(), _vm._v(" "), _c("span", {
      staticClass: "dialog-footer",
      attrs: {
        slot: "footer"
      },
      slot: "footer"
    }, [_vm.err ? _c("span", {
      staticStyle: {
        color: "red",
        "float": "left"
      }
    }, [_vm._v("输入内容格式有误!")]) : _vm._e(), _vm._v(" "), _c("ElButton", {
      attrs: {
        size: "small"
      },
      on: {
        click: function click($event) {
          _vm.visible = false;
        }
      }
    }, [_vm._v("取 消")]), _vm._v(" "), _c("ElButton", {
      attrs: {
        type: "primary",
        size: "small"
      },
      on: {
        click: _vm.onOk
      }
    }, [_vm._v("确 定")])], 1)])], 1);
  };

  var __vue_staticRenderFns__$2 = [];
  __vue_render__$2._withStripped = true;
  /* style */

  var __vue_inject_styles__$3 = undefined;
  /* scoped */

  var __vue_scope_id__$3 = undefined;
  /* module identifier */

  var __vue_module_identifier__$3 = undefined;
  /* functional template */

  var __vue_is_functional_template__$3 = false;
  /* style inject */

  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__$3 = /*#__PURE__*/normalizeComponent({
    render: __vue_render__$2,
    staticRenderFns: __vue_staticRenderFns__$2
  }, __vue_inject_styles__$3, __vue_script__$3, __vue_scope_id__$3, __vue_is_functional_template__$3, __vue_module_identifier__$3, false, undefined, undefined, undefined);

  function debounce(fn, wait) {
      var timeout = null;
      return function () {
          var this$1 = this;
          var arg = [], len = arguments.length;
          while ( len-- ) arg[ len ] = arguments[ len ];

          if (timeout !== null)
              { clearTimeout(timeout); }
          timeout = setTimeout(function () { return fn.call.apply(fn, [ this$1 ].concat( arg )); }, wait);
      }
  }

  var script$2 = {
    name: 'Fetch',
    props: {
      value: [Object, String],
      to: String
    },
    computed: {
      formValue: function formValue() {
        var val = this.value;
        if (!val) { return {}; }

        if (is.String(val)) {
          return {
            action: val
          };
        }

        if (!val._parse && val.parse) {
          return _objectSpread2(_objectSpread2({}, val), {}, {
            _parse: '' + val.parse
          });
        } else if (is.Function(val._parse)) {
          return _objectSpread2(_objectSpread2({}, val), {}, {
            _parse: '' + val._parse
          });
        }

        return val;
      }
    },
    data: function data() {
      var _this = this;

      return {
        api: {},
        fetch: {},
        option: {
          form: {
            labelPosition: 'right',
            size: 'mini',
            labelWidth: '90px'
          },
          submitBtn: false
        },
        rule: [{
          type: 'input',
          field: 'action',
          title: '接口: ',
          validate: [{
            required: true,
            message: '请数据接口'
          }]
        }, {
          type: 'select',
          field: 'method',
          title: '请求方式: ',
          value: 'GET',
          options: [{
            label: 'GET',
            value: 'GET'
          }, {
            label: 'POST',
            value: 'POST'
          }]
        }, {
          type: 'Struct',
          field: 'data',
          title: '附带数据: ',
          value: {},
          props: {
            defaultValue: {}
          }
        }, {
          type: 'Struct',
          field: 'headers',
          title: 'header信息: ',
          value: {},
          props: {
            defaultValue: {}
          }
        }, {
          type: 'input',
          field: '_parse',
          title: '解析函数',
          info: '解析接口数据，返回组件所需的数据结构',
          value: 'function (res){\n   return res.data;\n}',
          props: {
            type: 'textarea',
            rows: 8
          },
          validate: [{
            validator: function validator(_, v, cb) {
              if (!v) { return cb(); }

              try {
                _this.parseFn(v);
              } catch (e) {
                return cb(false);
              }

              cb();
            },
            message: '请输入正确的解析函数'
          }]
        }]
      };
    },
    methods: {
      parseFn: function parseFn(v) {
        return eval("(function(){return ".concat(v, " })()"));
      },
      _input: function _input() {
        var _this2 = this;

        this.api.submit(function (formData) {
          formData.to = _this2.to || 'options';
          if (formData._parse) { formData.parse = _this2.parseFn(formData._parse); }

          _this2.$emit('input', formData);
        });
      },
      input: debounce(function () {
        this._input();
      }, 1500)
    },
    mounted: function mounted() {
      this._input();
    }
  };

  var css_248z$2 = "._fc_fetch .el-form-item__label{float:left;display:inline-block;text-align:right;padding-right:5px}._fc_fetch{background-color:#bfdaf7;padding:10px}";
  styleInject(css_248z$2);

  /* script */
  var __vue_script__$2 = script$2;
  /* template */

  var __vue_render__$1 = function __vue_render__() {
    var _vm = this;

    var _h = _vm.$createElement;

    var _c = _vm._self._c || _h;

    return _c("div", {
      staticClass: "_fc_fetch"
    }, [_c("form-create", {
      attrs: {
        value: _vm.formValue,
        rule: _vm.rule,
        option: _vm.option
      },
      on: {
        change: _vm.input
      },
      model: {
        value: _vm.api,
        callback: function callback($$v) {
          _vm.api = $$v;
        },
        expression: "api"
      }
    })], 1);
  };

  var __vue_staticRenderFns__$1 = [];
  __vue_render__$1._withStripped = true;
  /* style */

  var __vue_inject_styles__$2 = undefined;
  /* scoped */

  var __vue_scope_id__$2 = undefined;
  /* module identifier */

  var __vue_module_identifier__$2 = undefined;
  /* functional template */

  var __vue_is_functional_template__$2 = false;
  /* style inject */

  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__$2 = /*#__PURE__*/normalizeComponent({
    render: __vue_render__$1,
    staticRenderFns: __vue_staticRenderFns__$1
  }, __vue_inject_styles__$2, __vue_script__$2, __vue_scope_id__$2, __vue_is_functional_template__$2, __vue_module_identifier__$2, false, undefined, undefined, undefined);

  //
  //
  //
  //
  //
  var script$1 = {
    name: 'Validate',
    props: {
      value: Array
    },
    watch: {
      value: function value(n) {
        this.formValue = this.parseValue(n);
      }
    },
    data: function data() {
      return {
        formValue: {},
        option: {
          form: {
            labelPosition: 'top',
            size: 'mini',
            labelWidth: '90px'
          },
          submitBtn: false,
          formData: this.parseValue(this.value)
        },
        rule: [{
          type: 'select',
          field: 'type',
          value: undefined,
          title: '字段类型',
          options: [{
            value: undefined,
            label: '请选择'
          }, {
            value: 'string',
            label: 'String'
          }, {
            value: 'array',
            label: 'Array'
          }, {
            value: 'number',
            label: 'Number'
          }, {
            value: 'integer',
            label: 'Integer'
          }, {
            value: 'float',
            label: 'Float'
          }, {
            value: 'object',
            label: 'Object'
          }, {
            value: 'date',
            label: 'Date'
          }, {
            value: 'url',
            label: 'url'
          }, {
            value: 'hex',
            label: 'hex'
          }, {
            value: 'email',
            label: 'email'
          }],
          control: [{
            handle: function handle(v) {
              return !!v;
            },
            rule: [{
              type: 'group',
              field: 'validate',
              props: {
                expand: 1,
                rules: [{
                  type: 'select',
                  title: '触发方式',
                  field: 'trigger',
                  value: 'change',
                  options: [{
                    label: 'change',
                    value: 'change'
                  }, {
                    label: 'submit',
                    value: 'submit'
                  }, {
                    label: 'blur',
                    value: 'blur'
                  }]
                }, {
                  type: 'select',
                  title: '验证方式',
                  field: 'mode',
                  options: [{
                    value: 'required',
                    label: '必填'
                  }, {
                    value: 'pattern',
                    label: '正则表达式'
                  }, {
                    value: 'min',
                    label: '最小值'
                  }, {
                    value: 'max',
                    label: '最大值'
                  }, {
                    value: 'len',
                    label: '长度'
                  }],
                  value: '',
                  control: [{
                    value: 'required',
                    rule: [{
                      type: 'hidden',
                      field: 'required',
                      value: true
                    }]
                  }, {
                    value: 'pattern',
                    rule: [{
                      type: 'input',
                      field: 'pattern',
                      title: '正则表达式'
                    }]
                  }, {
                    value: 'min',
                    rule: [{
                      type: 'inputNumber',
                      field: 'min',
                      title: '最小值'
                    }]
                  }, {
                    value: 'max',
                    rule: [{
                      type: 'inputNumber',
                      field: 'max',
                      title: '最大值'
                    }]
                  }, {
                    value: 'len',
                    rule: [{
                      type: 'inputNumber',
                      field: 'len',
                      title: '长度'
                    }]
                  }]
                }, {
                  type: 'input',
                  title: '错误信息',
                  field: 'message',
                  value: ''
                }]
              },
              value: []
            }]
          }]
        }]
      };
    },
    methods: {
      onInput: function onInput(formData) {
        var val = [];
        var validate = formData.validate,
            type = formData.type;

        if (type && !validate) {
          return;
        } else if (type) {
          validate.forEach(function (v) {
            v.type = type;
          });
          val = _toConsumableArray$1(validate);
        }

        this.$emit('input', val);
      },
      parseValue: function parseValue(n) {
        var val = {
          validate: n ? _toConsumableArray$1(n) : [],
          type: n.length ? n[0].type : undefined
        };
        val.validate.forEach(function (v) {
          if (!v.mode) {
            Object.keys(v).forEach(function (k) {
              if (['message', 'type', 'trigger', 'mode'].indexOf(k) < 0) {
                v.mode = k;
              }
            });
          }
        });
        return val;
      }
    }
  };

  var css_248z$1 = "._fc-validate .form-create .el-form-item{margin-bottom:22px!important}";
  styleInject(css_248z$1);

  /* script */
  var __vue_script__$1 = script$1;
  /* template */

  var __vue_render__ = function __vue_render__() {
    var _vm = this;

    var _h = _vm.$createElement;

    var _c = _vm._self._c || _h;

    return _c("form-create", {
      staticClass: "_fc-validate",
      attrs: {
        rule: _vm.rule,
        option: _vm.option,
        value: _vm.formValue
      },
      on: {
        "update:value": _vm.onInput
      }
    });
  };

  var __vue_staticRenderFns__ = [];
  __vue_render__._withStripped = true;
  /* style */

  var __vue_inject_styles__$1 = undefined;
  /* scoped */

  var __vue_scope_id__$1 = undefined;
  /* module identifier */

  var __vue_module_identifier__$1 = undefined;
  /* functional template */

  var __vue_is_functional_template__$1 = false;
  /* style inject */

  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__$1 = /*#__PURE__*/normalizeComponent({
    render: __vue_render__,
    staticRenderFns: __vue_staticRenderFns__
  }, __vue_inject_styles__$1, __vue_script__$1, __vue_scope_id__$1, __vue_is_functional_template__$1, __vue_module_identifier__$1, false, undefined, undefined, undefined);

  var script = {
    name: 'DragBox',
    props: ['rule', 'subRule', 'tag'],
    components: {
      draggable: draggable
    },
    functional: true,
    render: function render(h, context) {
      var subRule = context.props.rule || {};

      var _class = context.props.tag + '-drag drag-box';

      if (!context.children.length) {
        _class += ' ' + context.props.tag + '-holder';
      }

      subRule["class"] = _class;
      return h('draggable', _objectSpread2(_objectSpread2({}, context.props.rule), {}, {
        on: context.listeners
      }), context.children);
    }
  };

  /* script */
  var __vue_script__ = script;
  /* template */

  /* style */

  var __vue_inject_styles__ = undefined;
  /* scoped */

  var __vue_scope_id__ = undefined;
  /* module identifier */

  var __vue_module_identifier__ = undefined;
  /* functional template */

  var __vue_is_functional_template__ = undefined;
  /* style inject */

  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__ = /*#__PURE__*/normalizeComponent({}, __vue_inject_styles__, __vue_script__, __vue_scope_id__, __vue_is_functional_template__, __vue_module_identifier__, false, undefined, undefined, undefined);

  /*!
   * @form-create/component-wangeditor v2.5.2
   * (c) 2018-2021 xaboy
   * Github https://github.com/xaboy/form-create with @form-create/component-wangeditor
   * Released under the MIT License.
   */

  var dist = createCommonjsModule(function (module, exports) {
  !function(e,t){module.exports=t();}(commonjsGlobal,function(){var e,t,n=(function(e,t){var n;n=function(){return function(e){var t={};function n(o){if(t[o]){ return t[o].exports; }var r=t[o]={i:o,l:!1,exports:{}};return e[o].call(r.exports,r,r.exports,n),r.l=!0,r.exports}return n.m=e,n.c=t,n.d=function(e,t,o){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:o});},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0});},n.t=function(e,t){if(1&t&&(e=n(e)),8&t){ return e; }if(4&t&&"object"==typeof e&&e&&e.__esModule){ return e; }var o=Object.create(null);if(n.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e){ for(var r in e){ n.d(o,r,function(t){return e[t]}.bind(null,r)); } }return o},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="",n(n.s=135)}([function(e,t){e.exports=function(e){return e&&e.__esModule?e:{default:e}},e.exports.default=e.exports,e.exports.__esModule=!0;},function(e,t,n){e.exports=n(136);},function(e,t,n){n.r(t),n.d(t,"__extends",function(){return r}),n.d(t,"__assign",function(){return i}),n.d(t,"__rest",function(){return a}),n.d(t,"__decorate",function(){return l}),n.d(t,"__param",function(){return u}),n.d(t,"__metadata",function(){return c}),n.d(t,"__awaiter",function(){return s}),n.d(t,"__generator",function(){return f}),n.d(t,"__createBinding",function(){return d}),n.d(t,"__exportStar",function(){return p}),n.d(t,"__values",function(){return v}),n.d(t,"__read",function(){return h}),n.d(t,"__spread",function(){return A}),n.d(t,"__spreadArrays",function(){return m}),n.d(t,"__spreadArray",function(){return g}),n.d(t,"__await",function(){return y}),n.d(t,"__asyncGenerator",function(){return w}),n.d(t,"__asyncDelegator",function(){return x}),n.d(t,"__asyncValues",function(){return _}),n.d(t,"__makeTemplateObject",function(){return E}),n.d(t,"__importStar",function(){return C}),n.d(t,"__importDefault",function(){return S}),n.d(t,"__classPrivateFieldGet",function(){return D}),n.d(t,"__classPrivateFieldSet",function(){return N});var o=function(e,t){return (o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t;}||function(e,t){for(var n in t){ Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n]); }})(e,t)};function r(e,t){if("function"!=typeof t&&null!==t){ throw new TypeError("Class extends value "+String(t)+" is not a constructor or null"); }function n(){this.constructor=e;}o(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n);}var i=function(){return (i=Object.assign||function(e){for(var t,n=1,o=arguments.length;n<o;n++){ for(var r in t=arguments[n]){ Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]); } }return e}).apply(this,arguments)};function a(e,t){var n={};for(var o in e){ Object.prototype.hasOwnProperty.call(e,o)&&t.indexOf(o)<0&&(n[o]=e[o]); }if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(o=Object.getOwnPropertySymbols(e);r<o.length;r++){ t.indexOf(o[r])<0&&Object.prototype.propertyIsEnumerable.call(e,o[r])&&(n[o[r]]=e[o[r]]); }}return n}function l(e,t,n,o){var r,i=arguments.length,a=i<3?t:null===o?o=Object.getOwnPropertyDescriptor(t,n):o;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate){ a=Reflect.decorate(e,t,n,o); }else { for(var l=e.length-1;l>=0;l--){ (r=e[l])&&(a=(i<3?r(a):i>3?r(t,n,a):r(t,n))||a); } }return i>3&&a&&Object.defineProperty(t,n,a),a}function u(e,t){return function(n,o){t(n,o,e);}}function c(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata){ return Reflect.metadata(e,t) }}function s(e,t,n,o){return new(n||(n=Promise))(function(r,i){function a(e){try{u(o.next(e));}catch(e$1){i(e$1);}}function l(e){try{u(o.throw(e));}catch(e$1){i(e$1);}}function u(e){var t;e.done?r(e.value):(t=e.value,t instanceof n?t:new n(function(e){e(t);})).then(a,l);}u((o=o.apply(e,t||[])).next());})}function f(e,t){var n,o,r,i,a={label:0,sent:function(){if(1&r[0]){ throw r[1]; }return r[1]},trys:[],ops:[]};return i={next:l(0),throw:l(1),return:l(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function l(i){return function(l){return function(i){if(n){ throw new TypeError("Generator is already executing."); }for(;a;){ try{if(n=1,o&&(r=2&i[0]?o.return:i[0]?o.throw||((r=o.return)&&r.call(o),0):o.next)&&!(r=r.call(o,i[1])).done){ return r; }switch(o=0,r&&(i=[2&i[0],r.value]),i[0]){case 0:case 1:r=i;break;case 4:return a.label++,{value:i[1],done:!1};case 5:a.label++,o=i[1],i=[0];continue;case 7:i=a.ops.pop(),a.trys.pop();continue;default:if(!(r=(r=a.trys).length>0&&r[r.length-1])&&(6===i[0]||2===i[0])){a=0;continue}if(3===i[0]&&(!r||i[1]>r[0]&&i[1]<r[3])){a.label=i[1];break}if(6===i[0]&&a.label<r[1]){a.label=r[1],r=i;break}if(r&&a.label<r[2]){a.label=r[2],a.ops.push(i);break}r[2]&&a.ops.pop(),a.trys.pop();continue}i=t.call(e,a);}catch(e$1){i=[6,e$1],o=0;}finally{n=r=0;} }if(5&i[0]){ throw i[1]; }return {value:i[0]?i[1]:void 0,done:!0}}([i,l])}}}var d=Object.create?function(e,t,n,o){void 0===o&&(o=n),Object.defineProperty(e,o,{enumerable:!0,get:function(){return t[n]}});}:function(e,t,n,o){void 0===o&&(o=n),e[o]=t[n];};function p(e,t){for(var n in e){ "default"===n||Object.prototype.hasOwnProperty.call(t,n)||d(t,e,n); }}function v(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],o=0;if(n){ return n.call(e); }if(e&&"number"==typeof e.length){ return {next:function(){return e&&o>=e.length&&(e=void 0),{value:e&&e[o++],done:!e}}}; }throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")}function h(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n){ return e; }var o,r,i=n.call(e),a=[];try{for(;(void 0===t||t-- >0)&&!(o=i.next()).done;){ a.push(o.value); }}catch(e$1){r={error:e$1};}finally{try{o&&!o.done&&(n=i.return)&&n.call(i);}finally{if(r){ throw r.error }}}return a}function A(){
  var arguments$1 = arguments;
  for(var e=[],t=0;t<arguments.length;t++){ e=e.concat(h(arguments$1[t])); }return e}function m(){
  var arguments$1 = arguments;
  for(var e=0,t=0,n=arguments.length;t<n;t++){ e+=arguments$1[t].length; }var o=Array(e),r=0;for(t=0;t<n;t++){ for(var i=arguments[t],a=0,l=i.length;a<l;a++,r++){ o[r]=i[a]; } }return o}function g(e,t){for(var n=0,o=t.length,r=e.length;n<o;n++,r++){ e[r]=t[n]; }return e}function y(e){return this instanceof y?(this.v=e,this):new y(e)}function w(e,t,n){if(!Symbol.asyncIterator){ throw new TypeError("Symbol.asyncIterator is not defined."); }var o,r=n.apply(e,t||[]),i=[];return o={},a("next"),a("throw"),a("return"),o[Symbol.asyncIterator]=function(){return this},o;function a(e){r[e]&&(o[e]=function(t){return new Promise(function(n,o){i.push([e,t,n,o])>1||l(e,t);})});}function l(e,t){try{(n=r[e](t)).value instanceof y?Promise.resolve(n.value.v).then(u,c):s(i[0][2],n);}catch(e$1){s(i[0][3],e$1);}var n;}function u(e){l("next",e);}function c(e){l("throw",e);}function s(e,t){e(t),i.shift(),i.length&&l(i[0][0],i[0][1]);}}function x(e){var t,n;return t={},o("next"),o("throw",function(e){throw e}),o("return"),t[Symbol.iterator]=function(){return this},t;function o(o,r){t[o]=e[o]?function(t){return (n=!n)?{value:y(e[o](t)),done:"return"===o}:r?r(t):t}:r;}}function _(e){if(!Symbol.asyncIterator){ throw new TypeError("Symbol.asyncIterator is not defined."); }var t,n=e[Symbol.asyncIterator];return n?n.call(e):(e=v(e),t={},o("next"),o("throw"),o("return"),t[Symbol.asyncIterator]=function(){return this},t);function o(n){t[n]=e[n]&&function(t){return new Promise(function(o,r){(function(e,t,n,o){Promise.resolve(o).then(function(t){e({value:t,done:n});},t);})(o,r,(t=e[n](t)).done,t.value);})};}}function E(e,t){return Object.defineProperty?Object.defineProperty(e,"raw",{value:t}):e.raw=t,e}var b=Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t});}:function(e,t){e.default=t;};function C(e){if(e&&e.__esModule){ return e; }var t={};if(null!=e){ for(var n in e){ "default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&d(t,e,n); } }return b(t,e),t}function S(e){return e&&e.__esModule?e:{default:e}}function D(e,t){if(!t.has(e)){ throw new TypeError("attempted to get private field on non-instance"); }return t.get(e)}function N(e,t,n){if(!t.has(e)){ throw new TypeError("attempted to set private field on non-instance"); }return t.set(e,n),n}},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(90)),a=o(n(4)),l=o(n(25)),u=o(n(19)),c=o(n(116)),s=o(n(26)),f=o(n(92)),d=o(n(72)),p=o(n(73)),v=o(n(53));(0, r.default)(t,"__esModule",{value:!0}),t.DomElement=void 0;var h=n(2),A=n(6),m=[];function g(e){var t=[],n=[];return t=(0, i.default)(e)?e:e.split(";"),(0, a.default)(t).call(t,function(e){var t,o=(0, l.default)(t=e.split(":")).call(t,function(e){return (0, u.default)(e).call(e)});2===o.length&&n.push(o[0]+":"+o[1]);}),n}var y=function(){function e(t){if(this.elems=[],this.length=this.elems.length,this.dataSource=new c.default,t){if(t instanceof e){ return t; }var n=[],o=t instanceof Node?t.nodeType:-1;if(this.selector=t,1===o||9===o){ n=[t]; }else if(function(e){return !!e&&(e instanceof HTMLCollection||e instanceof NodeList)}(t)){ n=A.toArray(t); }else if(t instanceof Array){ n=t; }else if("string"==typeof t){var r,i=(0, u.default)(r=t.replace("/\n/mg","")).call(r);n=0===(0, s.default)(i).call(i,"<")?function(e){var t=document.createElement("div");t.innerHTML=e;var n=t.children;return A.toArray(n)}(i):function(e){var t=document.querySelectorAll(e);return A.toArray(t)}(i);}var a=n.length;if(!a){ return this; }for(var l=0;l<a;l++){ this.elems.push(n[l]); }this.length=a;}}return (0, r.default)(e.prototype,"id",{get:function(){return this.elems[0].id},enumerable:!1,configurable:!0}),e.prototype.forEach=function(e){for(var t=0;t<this.length;t++){var n=this.elems[t];if(!1===e.call(n,n,t)){ break }}return this},e.prototype.clone=function(e){var t;void 0===e&&(e=!1);var n=[];return (0, a.default)(t=this.elems).call(t,function(t){n.push(t.cloneNode(!!e));}),w(n)},e.prototype.get=function(e){void 0===e&&(e=0);var t=this.length;return e>=t&&(e%=t),w(this.elems[e])},e.prototype.first=function(){return this.get(0)},e.prototype.last=function(){var e=this.length;return this.get(e-1)},e.prototype.on=function(e,t,n){var o;return e?("function"==typeof t&&(n=t,t=""),(0, a.default)(o=this).call(o,function(o){if(t){var r=function(e){var o=e.target;o.matches(t)&&n.call(o,e);};o.addEventListener(e,r),m.push({elem:o,selector:t,fn:n,agentFn:r});}else { o.addEventListener(e,n); }})):this},e.prototype.off=function(e,t,n){var o;return e?("function"==typeof t&&(n=t,t=""),(0, a.default)(o=this).call(o,function(o){if(t){for(var r=-1,i=0;i<m.length;i++){var a=m[i];if(a.selector===t&&a.fn===n&&a.elem===o){r=i;break}}if(-1!==r){var l=(0, f.default)(m).call(m,r,1)[0].agentFn;o.removeEventListener(e,l);}}else { o.removeEventListener(e,n); }})):this},e.prototype.attr=function(e,t){var n;return null==t?this.elems[0].getAttribute(e)||"":(0, a.default)(n=this).call(n,function(n){n.setAttribute(e,t);})},e.prototype.removeAttr=function(e){var t;(0, a.default)(t=this).call(t,function(t){t.removeAttribute(e);});},e.prototype.addClass=function(e){var t;return e?(0, a.default)(t=this).call(t,function(t){if(t.className){var n=t.className.split(/\s/);n=(0, d.default)(n).call(n,function(e){return !!(0, u.default)(e).call(e)}),(0, s.default)(n).call(n,e)<0&&n.push(e),t.className=n.join(" ");}else { t.className=e; }}):this},e.prototype.removeClass=function(e){var t;return e?(0, a.default)(t=this).call(t,function(t){if(t.className){var n=t.className.split(/\s/);n=(0, d.default)(n).call(n,function(t){return !(!(t=(0, u.default)(t).call(t))||t===e)}),t.className=n.join(" ");}}):this},e.prototype.hasClass=function(e){if(!e){ return !1; }var t=this.elems[0];if(!t.className){ return !1; }var n=t.className.split(/\s/);return (0, p.default)(n).call(n,e)},e.prototype.css=function(e,t){var n,o;return o=""==t?"":e+":"+t+";",(0, a.default)(n=this).call(n,function(t){var n,r=(0, u.default)(n=t.getAttribute("style")||"").call(n);if(r){var i=g(r);i=(0, l.default)(i).call(i,function(t){return 0===(0, s.default)(t).call(t,e)?o:t}),""!=o&&(0, s.default)(i).call(i,o)<0&&i.push(o),""==o&&(i=g(i)),t.setAttribute("style",i.join("; "));}else { t.setAttribute("style",o); }})},e.prototype.getBoundingClientRect=function(){return this.elems[0].getBoundingClientRect()},e.prototype.show=function(){return this.css("display","block")},e.prototype.hide=function(){return this.css("display","none")},e.prototype.children=function(){var e=this.elems[0];return e?w(e.children):null},e.prototype.childNodes=function(){var e=this.elems[0];return e?w(e.childNodes):null},e.prototype.replaceChildAll=function(e){for(var t=this.getNode(),n=this.elems[0];n.hasChildNodes();){ t.firstChild&&n.removeChild(t.firstChild); }this.append(e);},e.prototype.append=function(e){var t;return (0, a.default)(t=this).call(t,function(t){(0, a.default)(e).call(e,function(e){t.appendChild(e);});})},e.prototype.remove=function(){var e;return (0, a.default)(e=this).call(e,function(e){if(e.remove){ e.remove(); }else {var t=e.parentElement;t&&t.removeChild(e);}})},e.prototype.isContain=function(e){var t=this.elems[0],n=e.elems[0];return t.contains(n)},e.prototype.getNodeName=function(){return this.elems[0].nodeName},e.prototype.getNode=function(e){return void 0===e&&(e=0),this.elems[e]},e.prototype.find=function(e){return w(this.elems[0].querySelectorAll(e))},e.prototype.text=function(e){var t;return e?(0, a.default)(t=this).call(t,function(t){t.innerHTML=e;}):this.elems[0].innerHTML.replace(/<[^>]+>/g,function(){return ""})},e.prototype.html=function(e){var t=this.elems[0];return e?(t.innerHTML=e,this):t.innerHTML},e.prototype.val=function(){var e,t=this.elems[0];return (0, u.default)(e=t.value).call(e)},e.prototype.focus=function(){var e;return (0, a.default)(e=this).call(e,function(e){e.focus();})},e.prototype.prev=function(){return w(this.elems[0].previousElementSibling)},e.prototype.next=function(){return w(this.elems[0].nextElementSibling)},e.prototype.getNextSibling=function(){return w(this.elems[0].nextSibling)},e.prototype.parent=function(){return w(this.elems[0].parentElement)},e.prototype.parentUntil=function(e,t){var n=t||this.elems[0];if("BODY"===n.nodeName){ return null; }var o=n.parentElement;return null===o?null:o.matches(e)?w(o):this.parentUntil(e,o)},e.prototype.parentUntilEditor=function(e,t,n){var o=n||this.elems[0];if(w(o).equal(t.$textContainerElem)||w(o).equal(t.$toolbarElem)){ return null; }var r=o.parentElement;return null===r?null:r.matches(e)?w(r):this.parentUntilEditor(e,t,r)},e.prototype.equal=function(t){return t instanceof e?this.elems[0]===t.elems[0]:t instanceof HTMLElement&&this.elems[0]===t},e.prototype.insertBefore=function(e){var t,n=w(e).elems[0];return n?(0, a.default)(t=this).call(t,function(e){n.parentNode.insertBefore(e,n);}):this},e.prototype.insertAfter=function(e){var t,n=w(e).elems[0],o=n&&n.nextSibling;return n?(0, a.default)(t=this).call(t,function(e){var t=n.parentNode;o?t.insertBefore(e,o):t.appendChild(e);}):this},e.prototype.data=function(e,t){if(null==t){ return this.dataSource.get(e); }this.dataSource.set(e,t);},e.prototype.getNodeTop=function(e){if(this.length<1){ return this; }var t=this.parent();return e.$textElem.equal(this)||e.$textElem.equal(t)?this:(t.prior=this,t.getNodeTop(e))},e.prototype.getOffsetData=function(){var e=this.elems[0];return {top:e.offsetTop,left:e.offsetLeft,width:e.offsetWidth,height:e.offsetHeight,parent:e.offsetParent}},e.prototype.scrollTop=function(e){this.elems[0].scrollTo({top:e});},e}();function w(){
  var arguments$1 = arguments;
  for(var e=[],t=0;t<arguments.length;t++){ e[t]=arguments$1[t]; }return new((0, v.default)(y).apply(y,h.__spreadArray([void 0],e)))}t.DomElement=y,t.default=w;},function(e,t,n){e.exports=n(180);},function(e,t,n){var o=n(8),r=n(74).f,i=n(101),a=n(12),l=n(47),u=n(17),c=n(16),s=function(e){var t=function(t,n,o){if(this instanceof e){switch(arguments.length){case 0:return new e;case 1:return new e(t);case 2:return new e(t,n)}return new e(t,n,o)}return e.apply(this,arguments)};return t.prototype=e.prototype,t};e.exports=function(e,t){var n,f,d,p,v,h,A,m,g=e.target,y=e.global,w=e.stat,x=e.proto,_=y?o:w?o[g]:(o[g]||{}).prototype,E=y?a:a[g]||(a[g]={}),b=E.prototype;for(d in t){ n=!i(y?d:g+(w?".":"#")+d,e.forced)&&_&&c(_,d),v=E[d],n&&(h=e.noTargetGet?(m=r(_,d))&&m.value:_[d]),p=n&&h?h:t[d],n&&typeof v==typeof p||(A=e.bind&&n?l(p,o):e.wrap&&n?s(p):x&&"function"==typeof p?l(Function.call,p):p,(e.sham||p&&p.sham||v&&v.sham)&&u(A,"sham",!0),E[d]=A,x&&(c(a,f=g+"Prototype")||u(a,f,{}),a[f][d]=p,e.real&&b&&!b[d]&&u(b,d,p))); }};},function(e,t,n){var o=n(0),r=o(n(94)),i=o(n(1)),a=o(n(257)),l=o(n(43)),u=o(n(54)),c=o(n(90)),s=o(n(25));(0, i.default)(t,"__esModule",{value:!0}),t.hexToRgb=t.getRandomCode=t.toArray=t.deepClone=t.isFunction=t.debounce=t.throttle=t.arrForEach=t.forEach=t.replaceSpecialSymbol=t.replaceHtmlSymbol=t.getRandom=t.UA=void 0;var f=n(2),d=function(){function e(){this._ua=navigator.userAgent;var e=this._ua.match(/(Edge?)\/(\d+)/);this.isOldEdge=!!(e&&"Edge"==e[1]&&(0, a.default)(e[2])<19),this.isFirefox=!(!/Firefox\/\d+/.test(this._ua)||/Seamonkey\/\d+/.test(this._ua));}return e.prototype.isIE=function(){return "ActiveXObject"in window},e.prototype.isWebkit=function(){return /webkit/i.test(this._ua)},e}();t.UA=new d,t.getRandom=function(e){var t;return void 0===e&&(e=""),e+(0, l.default)(t=Math.random().toString()).call(t,2)},t.replaceHtmlSymbol=function(e){return e.replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;").replace(/(\r\n|\r|\n)/g,"<br/>")},t.replaceSpecialSymbol=function(e){return e.replace(/&lt;/gm,"<").replace(/&gt;/gm,">").replace(/&quot;/gm,'"')},t.forEach=function(e,t){for(var n in e){ if(Object.prototype.hasOwnProperty.call(e,n)&&!1===t(n,e[n])){ break } }},t.arrForEach=function(e,t){var n,o,r=e.length||0;for(n=0;n<r&&(o=e[n],!1!==t.call(e,o,n));n++){ }},t.throttle=function(e,t){void 0===t&&(t=200);var n=!1;return function(){
  var arguments$1 = arguments;
  for(var o=this,r=[],i=0;i<arguments.length;i++){ r[i]=arguments$1[i]; }n||(n=!0,(0, u.default)(function(){n=!1,e.call.apply(e,f.__spreadArray([o],r));},t));}},t.debounce=function(e,t){void 0===t&&(t=200);var n=0;return function(){
  var arguments$1 = arguments;
  for(var o=this,r=[],i=0;i<arguments.length;i++){ r[i]=arguments$1[i]; }n&&window.clearTimeout(n),n=(0, u.default)(function(){n=0,e.call.apply(e,f.__spreadArray([o],r));},t);}},t.isFunction=function(e){return "function"==typeof e},t.deepClone=function e(t){if("object"!==(0, r.default)(t)||"function"==typeof t||null===t){ return t; }var n;for(var o in (0, c.default)(t)&&(n=[]),(0, c.default)(t)||(n={}),t){ Object.prototype.hasOwnProperty.call(t,o)&&(n[o]=e(t[o])); }return n},t.toArray=function(e){return (0, l.default)(Array.prototype).call(e)},t.getRandomCode=function(){var e;return (0, l.default)(e=Math.random().toString(36)).call(e,-5)},t.hexToRgb=function(e){var t=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(e);if(null==t){ return null; }var n=(0, s.default)(t).call(t,function(e){return (0, a.default)(e,16)});return "rgb("+n[1]+", "+n[2]+", "+n[3]+")"};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.EMPTY_P_REGEX=t.EMPTY_P_LAST_REGEX=t.EMPTY_P=t.urlRegex=t.EMPTY_FN=void 0,t.EMPTY_FN=function(){},t.urlRegex=/^(http|ftp|https):\/\/[\w\-_]+(\.[\w\-_]+)+([\w\-.,@?^=%&amp;:/~+#]*[\w\-@?^=%&amp;/~+#])?/,t.EMPTY_P='<p data-we-empty-p=""><br></p>',t.EMPTY_P_LAST_REGEX=/<p data-we-empty-p=""><br\/?><\/p>$/gim,t.EMPTY_P_REGEX=/<p data-we-empty-p="">/gim;},function(e,t,n){(function(t){var n=function(e){return e&&e.Math==Math&&e};e.exports=n("object"==typeof globalThis&&globalThis)||n("object"==typeof window&&window)||n("object"==typeof self&&self)||n("object"==typeof t&&t)||function(){return this}()||Function("return this")();}).call(this,n(139));},function(e,t,n){var o=n(8),r=n(78),i=n(16),a=n(59),l=n(83),u=n(105),c=r("wks"),s=o.Symbol,f=u?s:s&&s.withoutSetter||a;e.exports=function(e){return i(c,e)&&(l||"string"==typeof c[e])||(l&&i(s,e)?c[e]=s[e]:c[e]=f("Symbol."+e)),c[e]};},function(e,t,n){var o=n(12),r=n(16),i=n(95),a=n(18).f;e.exports=function(e){var t=o.Symbol||(o.Symbol={});r(t,e)||a(t,e,{value:i.f(e)});};},function(e,t){e.exports=function(e){try{return !!e()}catch(e$1){return !0}};},function(e,t){e.exports={};},function(e,t){e.exports=function(e){return "object"==typeof e?null!==e:"function"==typeof e};},function(e,t,n){var o=n(12);e.exports=function(e){return o[e+"Prototype"]};},function(e,t,n){var o=n(11);e.exports=!o(function(){return 7!=Object.defineProperty({},1,{get:function(){return 7}})[1]});},function(e,t){var n={}.hasOwnProperty;e.exports=function(e,t){return n.call(e,t)};},function(e,t,n){var o=n(15),r=n(18),i=n(35);e.exports=o?function(e,t,n){return r.f(e,t,i(1,n))}:function(e,t,n){return e[t]=n,e};},function(e,t,n){var o=n(15),r=n(100),i=n(24),a=n(57),l=Object.defineProperty;t.f=o?l:function(e,t,n){if(i(e),t=a(t,!0),i(n),r){ try{return l(e,t,n)}catch(e$1){} }if("get"in n||"set"in n){ throw TypeError("Accessors not supported"); }return "value"in n&&(e[t]=n.value),e};},function(e,t,n){e.exports=n(192);},function(e,t,n){var o,r=function(){return void 0===o&&(o=Boolean(window&&document&&document.all&&!window.atob)),o},i=function(){var e={};return function(t){if(void 0===e[t]){var n=document.querySelector(t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement){ try{n=n.contentDocument.head;}catch(e$1){n=null;} }e[t]=n;}return e[t]}}(),a=[];function l(e){for(var t=-1,n=0;n<a.length;n++){ if(a[n].identifier===e){t=n;break} }return t}function u(e,t){for(var n={},o=[],r=0;r<e.length;r++){var i=e[r],u=t.base?i[0]+t.base:i[0],c=n[u]||0,s="".concat(u," ").concat(c);n[u]=c+1;var f=l(s),d={css:i[1],media:i[2],sourceMap:i[3]};-1!==f?(a[f].references++,a[f].updater(d)):a.push({identifier:s,updater:h(d,t),references:1}),o.push(s);}return o}function c(e){var t=document.createElement("style"),o=e.attributes||{};if(void 0===o.nonce){var r=n.nc;r&&(o.nonce=r);}if(Object.keys(o).forEach(function(e){t.setAttribute(e,o[e]);}),"function"==typeof e.insert){ e.insert(t); }else {var a=i(e.insert||"head");if(!a){ throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid."); }a.appendChild(t);}return t}var s,f=(s=[],function(e,t){return s[e]=t,s.filter(Boolean).join("\n")});function d(e,t,n,o){var r=n?"":o.media?"@media ".concat(o.media," {").concat(o.css,"}"):o.css;if(e.styleSheet){ e.styleSheet.cssText=f(t,r); }else {var i=document.createTextNode(r),a=e.childNodes;a[t]&&e.removeChild(a[t]),a.length?e.insertBefore(i,a[t]):e.appendChild(i);}}var p=null,v=0;function h(e,t){var n,o,r;if(t.singleton){var i=v++;n=p||(p=c(t)),o=d.bind(null,n,i,!1),r=d.bind(null,n,i,!0);}else { n=c(t),o=function(e,t,n){var o=n.css,r=n.media,i=n.sourceMap;if(r?e.setAttribute("media",r):e.removeAttribute("media"),i&&"undefined"!=typeof btoa&&(o+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(i))))," */")),e.styleSheet){ e.styleSheet.cssText=o; }else {for(;e.firstChild;){ e.removeChild(e.firstChild); }e.appendChild(document.createTextNode(o));}}.bind(null,n,t),r=function(){!function(e){if(null===e.parentNode){ return !1; }e.parentNode.removeChild(e);}(n);}; }return o(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap){ return; }o(e=t);}else { r(); }}}e.exports=function(e,t){(t=t||{}).singleton||"boolean"==typeof t.singleton||(t.singleton=r());var n=u(e=e||[],t);return function(e){if(e=e||[],"[object Array]"===Object.prototype.toString.call(e)){for(var o=0;o<n.length;o++){var r=l(n[o]);a[r].references--;}for(var i=u(e,t),c=0;c<n.length;c++){var s=l(n[c]);0===a[s].references&&(a[s].updater(),a.splice(s,1));}n=i;}}};},function(e,t,n){e.exports=function(e){var t=[];return t.toString=function(){return this.map(function(t){var n=function(e,t){var n=e[1]||"",o=e[3];if(!o){ return n; }if(t&&"function"==typeof btoa){var r=(a=o,l=btoa(unescape(encodeURIComponent(JSON.stringify(a)))),u="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(l),"/*# ".concat(u," */")),i=o.sources.map(function(e){return "/*# sourceURL=".concat(o.sourceRoot||"").concat(e," */")});return [n].concat(i).concat([r]).join("\n")}var a,l,u;return [n].join("\n")}(t,e);return t[2]?"@media ".concat(t[2]," {").concat(n,"}"):n}).join("")},t.i=function(e,n,o){"string"==typeof e&&(e=[[null,e,""]]);var r={};if(o){ for(var i=0;i<this.length;i++){var a=this[i][0];null!=a&&(r[a]=!0);} }for(var l=0;l<e.length;l++){var u=[].concat(e[l]);o&&r[u[0]]||(n&&(u[2]?u[2]="".concat(n," and ").concat(u[2]):u[2]=n),t.push(u));}},t};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=function(e){function t(t,n){return e.call(this,t,n)||this}return o.__extends(t,e),t}(o.__importDefault(n(96)).default);t.default=r;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4)),a=o(n(54));(0, r.default)(t,"__esModule",{value:!0});var l=n(2),u=l.__importDefault(n(3)),c=l.__importDefault(n(96)),s=l.__importDefault(n(128)),f=function(e){function t(t,n,o){var r=e.call(this,t,n)||this;o.title=n.i18next.t("menus.dropListMenu."+o.title);var l,c="zh-CN"===n.config.lang?"":"w-e-drop-list-tl";""!==c&&"list"===o.type&&(0, i.default)(l=o.list).call(l,function(e){var t=e.$elem,n=u.default(t.children());if(n.length>0){var o=null==n?void 0:n.getNodeName();o&&"I"===o&&t.addClass(c);}});var f=new s.default(r,o);return r.dropList=f,t.on("click",function(){var e;null!=n.selection.getRange()&&(t.css("z-index",n.zIndex.get("menu")),(0, i.default)(e=n.txt.eventHooks.dropListMenuHoverEvents).call(e,function(e){return e()}),f.show());}).on("mouseleave",function(){t.css("z-index","auto"),f.hideTimeoutId=(0, a.default)(function(){f.hide();});}),r}return l.__extends(t,e),t}(c.default);t.default=f;},function(e,t,n){var o=n(13);e.exports=function(e){if(!o(e)){ throw TypeError(String(e)+" is not an object"); }return e};},function(e,t,n){e.exports=n(188);},function(e,t,n){e.exports=n(201);},function(e,t,n){var o=n(75),r=n(46);e.exports=function(e){return o(r(e))};},function(e,t,n){var o=n(12),r=n(8),i=function(e){return "function"==typeof e?e:void 0};e.exports=function(e,t){return arguments.length<2?i(o[e])||i(r[e]):o[e]&&o[e][t]||r[e]&&r[e][t]};},function(e,t,n){var o=n(47),r=n(75),i=n(36),a=n(38),l=n(89),u=[].push,c=function(e){var t=1==e,n=2==e,c=3==e,s=4==e,f=6==e,d=7==e,p=5==e||f;return function(v,h,A,m){for(var g,y,w=i(v),x=r(w),_=o(h,A,3),E=a(x.length),b=0,C=m||l,S=t?C(v,E):n||d?C(v,0):void 0;E>b;b++){ if((p||b in x)&&(y=_(g=x[b],b,w),e)){ if(t){ S[b]=y; }else if(y){ switch(e){case 3:return !0;case 5:return g;case 6:return b;case 2:u.call(S,g);} }else { switch(e){case 4:return !1;case 7:u.call(S,g);} } } }return f?-1:c||s?s:S}};e.exports={forEach:c(0),map:c(1),filter:c(2),some:c(3),every:c(4),find:c(5),findIndex:c(6),filterOut:c(7)};},function(e,t,n){e.exports=n(286);},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4)),a=o(n(30)),l=o(n(125));(0, r.default)(t,"__esModule",{value:!0});var u=n(2),c=u.__importDefault(n(3)),s=n(7),f=function(){function e(t,n){this.menu=t,this.conf=n,this.$container=c.default('<div class="w-e-panel-container"></div>');var o=t.editor;o.txt.eventHooks.clickEvents.push(e.hideCurAllPanels),o.txt.eventHooks.toolbarClickEvents.push(e.hideCurAllPanels),o.txt.eventHooks.dropListMenuHoverEvents.push(e.hideCurAllPanels);}return e.prototype.create=function(){var t=this,n=this.menu;if(!e.createdMenus.has(n)){var o=this.conf,r=this.$container,l=o.width||300,f=n.editor.$toolbarElem.getBoundingClientRect(),d=n.$elem.getBoundingClientRect(),p=f.height+f.top-d.top,v=(f.width-l)/2+f.left-d.left;r.css("width",l+"px").css("margin-top",p+"px").css("margin-left",v+"px").css("z-index",n.editor.zIndex.get("panel"));var h=c.default('<i class="w-e-icon-close w-e-panel-close"></i>');r.append(h),h.on("click",function(){t.remove();});var A=c.default('<ul class="w-e-panel-tab-title"></ul>'),m=c.default('<div class="w-e-panel-tab-content"></div>');r.append(A).append(m);var g=o.height;g&&m.css("height",g+"px").css("overflow-y","auto");var y=o.tabs||[],w=[],x=[];(0, i.default)(y).call(y,function(e,t){if(e){var n=e.title||"",o=e.tpl||"",r=c.default('<li class="w-e-item">'+n+"</li>");A.append(r);var a=c.default(o);m.append(a),w.push(r),x.push(a),0===t?(r.data("active",!0),r.addClass("w-e-active")):a.hide(),r.on("click",function(){r.data("active")||((0, i.default)(w).call(w,function(e){e.data("active",!1),e.removeClass("w-e-active");}),(0, i.default)(x).call(x,function(e){e.hide();}),r.data("active",!0),r.addClass("w-e-active"),a.show());});}}),r.on("click",function(e){e.stopPropagation();}),n.$elem.append(r),(0, i.default)(y).call(y,function(e,n){if(e){var o=e.events||[];(0, i.default)(o).call(o,function(e){var o=e.selector,r=e.type,i=e.fn||s.EMPTY_FN,l=x[n];(0, a.default)(l).call(l,o).on(r,function(e){return u.__awaiter(t,void 0,void 0,function(){return u.__generator(this,function(t){switch(t.label){case 0:return e.stopPropagation(),[4,i(e)];case 1:return t.sent()&&this.remove(),[2]}})})});});}});var _=(0, a.default)(r).call(r,"input[type=text],textarea");_.length&&_.get(0).focus(),e.hideCurAllPanels(),n.setPanel(this),e.createdMenus.add(n);}},e.prototype.remove=function(){var t=this.menu,n=this.$container;n&&n.remove(),e.createdMenus.delete(t);},e.hideCurAllPanels=function(){var t;0!==e.createdMenus.size&&(0, i.default)(t=e.createdMenus).call(t,function(e){var t=e.panel;t&&t.remove();});},e.createdMenus=new l.default,e}();t.default=f;},function(e,t){e.exports=function(e){if("function"!=typeof e){ throw TypeError(String(e)+" is not a function"); }return e};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=function(e){function t(t,n){return e.call(this,t,n)||this}return o.__extends(t,e),t.prototype.setPanel=function(e){this.panel=e;},t}(o.__importDefault(n(96)).default);t.default=r;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4)),a=o(n(53));(0, r.default)(t,"__esModule",{value:!0});var l=n(2).__importDefault(n(3)),u=function(){function e(e,t,n){this.editor=e,this.$targetElem=t,this.conf=n,this._show=!1,this._isInsertTextContainer=!1;var o=l.default("<div></div>");o.addClass("w-e-tooltip"),this.$container=o;}return e.prototype.getPositionData=function(){var e=this.$container,t=0,n=0,o=document.documentElement.scrollTop,r=this.$targetElem.getBoundingClientRect(),i=this.editor.$textElem.getBoundingClientRect(),a=this.$targetElem.getOffsetData(),u=l.default(a.parent),c=this.editor.$textElem.elems[0].scrollTop;if(this._isInsertTextContainer=u.equal(this.editor.$textContainerElem),this._isInsertTextContainer){var s=u.getBoundingClientRect().height,f=a.top,d=a.left,p=a.height,v=f-c;v>25?(t=v-20-15,e.addClass("w-e-tooltip-up")):v+p+20<s?(t=v+p+10,e.addClass("w-e-tooltip-down")):(t=(v>0?v:0)+20+10,e.addClass("w-e-tooltip-down")),n=d<0?0:d;}else { r.top<20?(t=r.bottom+o+5,e.addClass("w-e-tooltip-down")):r.top-i.top<20?(t=r.bottom+o+5,e.addClass("w-e-tooltip-down")):(t=r.top+o-20-15,e.addClass("w-e-tooltip-up")),n=r.left<0?0:r.left; }return {top:t,left:n}},e.prototype.appendMenus=function(){var e=this,t=this.conf,n=this.editor,o=this.$targetElem,r=this.$container;(0, i.default)(t).call(t,function(t,i){var a=t.$elem,u=l.default("<div></div>");u.addClass("w-e-tooltip-item-wrapper "),u.append(a),r.append(u),a.on("click",function(r){r.preventDefault(),t.onClick(n,o)&&e.remove();});});},e.prototype.create=function(){var e,t,n=this.editor,o=this.$container;this.appendMenus();var r=this.getPositionData(),i=r.top,u=r.left;o.css("top",i+"px"),o.css("left",u+"px"),o.css("z-index",n.zIndex.get("tooltip")),this._isInsertTextContainer?this.editor.$textContainerElem.append(o):l.default("body").append(o),this._show=!0,n.beforeDestroy((0, a.default)(e=this.remove).call(e,this)),n.txt.eventHooks.onBlurEvents.push((0, a.default)(t=this.remove).call(t,this));},e.prototype.remove=function(){this.$container.remove(),this._show=!1;},(0, r.default)(e.prototype,"isShow",{get:function(){return this._show},enumerable:!1,configurable:!0}),e}();t.default=u;},function(e,t){e.exports=function(e,t){return {enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}};},function(e,t,n){var o=n(46);e.exports=function(e){return Object(o(e))};},function(e,t){e.exports=!0;},function(e,t,n){var o=n(62),r=Math.min;e.exports=function(e){return e>0?r(o(e),9007199254740991):0};},function(e,t,n){var o=n(24),r=n(163),i=n(38),a=n(47),l=n(164),u=n(165),c=function(e,t){this.stopped=e,this.result=t;};e.exports=function(e,t,n){var s,f,d,p,v,h,A,m=n&&n.that,g=!(!n||!n.AS_ENTRIES),y=!(!n||!n.IS_ITERATOR),w=!(!n||!n.INTERRUPTED),x=a(t,m,1+g+w),_=function(e){return s&&u(s),new c(!0,e)},E=function(e){return g?(o(e),w?x(e[0],e[1],_):x(e[0],e[1])):w?x(e,_):x(e)};if(y){ s=e; }else {if("function"!=typeof(f=l(e))){ throw TypeError("Target is not iterable"); }if(r(f)){for(d=0,p=i(e.length);p>d;d++){ if((v=E(e[d]))&&v instanceof c){ return v; } }return new c(!1)}s=f.call(e);}for(h=s.next;!(A=h.call(s)).done;){try{v=E(A.value);}catch(e$1){throw u(s),e$1}if("object"==typeof v&&v&&v instanceof c){ return v }}return new c(!1)};},function(e,t){e.exports={};},function(e,t,n){var o=n(84),r=n(18).f,i=n(17),a=n(16),l=n(167),u=n(9)("toStringTag");e.exports=function(e,t,n,c){if(e){var s=n?e:e.prototype;a(s,u)||r(s,u,{configurable:!0,value:t}),c&&!o&&i(s,"toString",l);}};},function(e,t,n){var o,r,i,a=n(172),l=n(8),u=n(13),c=n(17),s=n(16),f=n(79),d=n(58),p=n(48),v=l.WeakMap;if(a){var h=f.state||(f.state=new v),A=h.get,m=h.has,g=h.set;o=function(e,t){return t.facade=e,g.call(h,e,t),t},r=function(e){return A.call(h,e)||{}},i=function(e){return m.call(h,e)};}else {var y=d("state");p[y]=!0,o=function(e,t){return t.facade=e,c(e,y,t),t},r=function(e){return s(e,y)?e[y]:{}},i=function(e){return s(e,y)};}e.exports={set:o,get:r,has:i,enforce:function(e){return i(e)?r(e):o(e,{})},getterFor:function(e){return function(t){var n;if(!u(t)||(n=r(t)).type!==e){ throw TypeError("Incompatible receiver, "+e+" required"); }return n}}};},function(e,t,n){e.exports=n(262);},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4));(0, r.default)(t,"__esModule",{value:!0}),t.createElementFragment=t.createDocumentFragment=t.createElement=t.insertBefore=t.getEndPoint=t.getStartPoint=t.updateRange=t.filterSelectionNodes=void 0;var a=n(2),l=n(132),u=a.__importDefault(n(3));function c(e){return document.createElement(e)}t.filterSelectionNodes=function(e){var t=[];return (0, i.default)(e).call(e,function(e){var n=e.getNodeName();if(n!==l.ListType.OrderedList&&n!==l.ListType.UnorderedList){ t.push(e); }else if(e.prior){ t.push(e.prior); }else {var o=e.children();null==o||(0, i.default)(o).call(o,function(e){t.push(u.default(e));});}}),t},t.updateRange=function(e,t,n){var o=e.selection,r=document.createRange();t.length>1?(r.setStart(t.elems[0],0),r.setEnd(t.elems[t.length-1],t.elems[t.length-1].childNodes.length)):r.selectNodeContents(t.elems[0]),n&&r.collapse(!1),o.saveRange(r),o.restoreSelection();},t.getStartPoint=function(e){var t;return e.prior?e.prior:u.default(null===(t=e.children())||void 0===t?void 0:t.elems[0])},t.getEndPoint=function(e){var t;return e.prior?e.prior:u.default(null===(t=e.children())||void 0===t?void 0:t.last().elems[0])},t.insertBefore=function(e,t,n){void 0===n&&(n=null),e.parent().elems[0].insertBefore(t,n);},t.createElement=c,t.createDocumentFragment=function(){return document.createDocumentFragment()},t.createElementFragment=function(e,t,n){return void 0===n&&(n="li"),(0, i.default)(e).call(e,function(e){var o=c(n);o.innerHTML=e.html(),t.append(o),e.remove();}),t};},function(e,t){var n={}.toString;e.exports=function(e){return n.call(e).slice(8,-1)};},function(e,t){e.exports=function(e){if(null==e){ throw TypeError("Can't call method on "+e); }return e};},function(e,t,n){var o=n(32);e.exports=function(e,t,n){if(o(e),void 0===t){ return e; }switch(n){case 0:return function(){return e.call(t)};case 1:return function(n){return e.call(t,n)};case 2:return function(n,o){return e.call(t,n,o)};case 3:return function(n,o,r){return e.call(t,n,o,r)}}return function(){return e.apply(t,arguments)}};},function(e,t){e.exports={};},function(e,t,n){var o=n(17);e.exports=function(e,t,n,r){r&&r.enumerable?e[t]=n:o(e,t,n);};},function(e,t,n){n(178);var o=n(179),r=n(8),i=n(66),a=n(17),l=n(40),u=n(9)("toStringTag");for(var c in o){var s=r[c],f=s&&s.prototype;f&&i(f)!==u&&a(f,u,c),l[c]=l.Array;}},function(e,t,n){var o=n(45);e.exports=Array.isArray||function(e){return "Array"==o(e)};},function(e,t,n){var o=n(11),r=n(9),i=n(64),a=r("species");e.exports=function(e){return i>=51||!o(function(){var t=[];return (t.constructor={})[a]=function(){return {foo:1}},1!==t[e](Boolean).foo})};},function(e,t,n){e.exports=n(222);},function(e,t,n){e.exports=n(266);},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.ListHandle=void 0;var o=n(2).__importDefault(n(370)),r=function(){return function(e){this.options=e,this.selectionRangeElem=new o.default;}}();t.ListHandle=r;},function(e,t,n){var o={}.propertyIsEnumerable,r=Object.getOwnPropertyDescriptor,i=r&&!o.call({1:2},1);t.f=i?function(e){var t=r(this,e);return !!t&&t.enumerable}:o;},function(e,t,n){var o=n(13);e.exports=function(e,t){if(!o(e)){ return e; }var n,r;if(t&&"function"==typeof(n=e.toString)&&!o(r=n.call(e))){ return r; }if("function"==typeof(n=e.valueOf)&&!o(r=n.call(e))){ return r; }if(!t&&"function"==typeof(n=e.toString)&&!o(r=n.call(e))){ return r; }throw TypeError("Can't convert object to primitive value")};},function(e,t,n){var o=n(78),r=n(59),i=o("keys");e.exports=function(e){return i[e]||(i[e]=r(e))};},function(e,t){var n=0,o=Math.random();e.exports=function(e){return "Symbol("+String(void 0===e?"":e)+")_"+(++n+o).toString(36)};},function(e,t,n){var o,r=n(24),i=n(162),a=n(82),l=n(48),u=n(104),c=n(76),s=n(58),f=s("IE_PROTO"),d=function(){},p=function(e){return "<script>"+e+"<\/script>"},v=function(){try{o=document.domain&&new ActiveXObject("htmlfile");}catch(e$1){}var e,t;v=o?function(e){e.write(p("")),e.close();var t=e.parentWindow.Object;return e=null,t}(o):((t=c("iframe")).style.display="none",u.appendChild(t),t.src=String("javascript:"),(e=t.contentWindow.document).open(),e.write(p("document.F=Object")),e.close(),e.F);for(var n=a.length;n--;){ delete v.prototype[a[n]]; }return v()};l[f]=!0,e.exports=Object.create||function(e,t){var n;return null!==e?(d.prototype=r(e),n=new d,d.prototype=null,n[f]=e):n=v(),void 0===t?n:i(n,t)};},function(e,t,n){var o=n(103),r=n(82);e.exports=Object.keys||function(e){return o(e,r)};},function(e,t){var n=Math.ceil,o=Math.floor;e.exports=function(e){return isNaN(e=+e)?0:(e>0?o:n)(e)};},function(e,t,n){var o=n(45),r=n(8);e.exports="process"==o(r.process);},function(e,t,n){var o,r,i=n(8),a=n(65),l=i.process,u=l&&l.versions,c=u&&u.v8;c?r=(o=c.split("."))[0]+o[1]:a&&(!(o=a.match(/Edge\/(\d+)/))||o[1]>=74)&&(o=a.match(/Chrome\/(\d+)/))&&(r=o[1]),e.exports=r&&+r;},function(e,t,n){var o=n(28);e.exports=o("navigator","userAgent")||"";},function(e,t,n){var o=n(84),r=n(45),i=n(9)("toStringTag"),a="Arguments"==r(function(){return arguments}());e.exports=o?r:function(e){var t,n,o;return void 0===e?"Undefined":null===e?"Null":"string"==typeof(n=function(e,t){try{return e[t]}catch(e$1){}}(t=Object(e),i))?n:a?r(t):"Object"==(o=r(t))&&"function"==typeof t.callee?"Arguments":o};},function(e,t){},function(e,t,n){var o=n(32),r=function(e){var t,n;this.promise=new e(function(e,o){if(void 0!==t||void 0!==n){ throw TypeError("Bad Promise constructor"); }t=e,n=o;}),this.resolve=o(t),this.reject=o(n);};e.exports.f=function(e){return new r(e)};},function(e,t,n){var o=n(176).charAt,r=n(42),i=n(87),a=r.set,l=r.getterFor("String Iterator");i(String,"String",function(e){a(this,{type:"String Iterator",string:String(e),index:0});},function(){var e,t=l(this),n=t.string,r=t.index;return r>=n.length?{value:void 0,done:!0}:(e=o(n,r),t.index+=e.length,{value:e,done:!1})});},function(e,t,n){var o=n(11);e.exports=function(e,t){var n=[][e];return !!n&&o(function(){n.call(null,t||function(){throw 1},1);})};},function(e,t){e.exports="\t\n\v\f\r                　\u2028\u2029\ufeff";},function(e,t,n){e.exports=n(209);},function(e,t,n){e.exports=n(213);},function(e,t,n){var o=n(15),r=n(56),i=n(35),a=n(27),l=n(57),u=n(16),c=n(100),s=Object.getOwnPropertyDescriptor;t.f=o?s:function(e,t){if(e=a(e),t=l(t,!0),c){ try{return s(e,t)}catch(e$1){} }if(u(e,t)){ return i(!r.f.call(e,t),e[t]) }};},function(e,t,n){var o=n(11),r=n(45),i="".split;e.exports=o(function(){return !Object("z").propertyIsEnumerable(0)})?function(e){return "String"==r(e)?i.call(e,""):Object(e)}:Object;},function(e,t,n){var o=n(8),r=n(13),i=o.document,a=r(i)&&r(i.createElement);e.exports=function(e){return a?i.createElement(e):{}};},function(e,t,n){var o=n(16),r=n(36),i=n(58),a=n(160),l=i("IE_PROTO"),u=Object.prototype;e.exports=a?Object.getPrototypeOf:function(e){return e=r(e),o(e,l)?e[l]:"function"==typeof e.constructor&&e instanceof e.constructor?e.constructor.prototype:e instanceof Object?u:null};},function(e,t,n){var o=n(37),r=n(79);(e.exports=function(e,t){return r[e]||(r[e]=void 0!==t?t:{})})("versions",[]).push({version:"3.9.1",mode:o?"pure":"global",copyright:"© 2021 Denis Pushkarev (zloirock.ru)"});},function(e,t,n){var o=n(8),r=n(159),i=o["__core-js_shared__"]||r("__core-js_shared__",{});e.exports=i;},function(e,t,n){var o=n(27),r=n(38),i=n(81),a=function(e){return function(t,n,a){var l,u=o(t),c=r(u.length),s=i(a,c);if(e&&n!=n){for(;c>s;){ if((l=u[s++])!=l){ return !0 } }}else { for(;c>s;s++){ if((e||s in u)&&u[s]===n){ return e||s||0; } } }return !e&&-1}};e.exports={includes:a(!0),indexOf:a(!1)};},function(e,t,n){var o=n(62),r=Math.max,i=Math.min;e.exports=function(e,t){var n=o(e);return n<0?r(n+t,0):i(n,t)};},function(e,t){e.exports=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"];},function(e,t,n){var o=n(63),r=n(64),i=n(11);e.exports=!!Object.getOwnPropertySymbols&&!i(function(){return !Symbol.sham&&(o?38===r:r>37&&r<41)});},function(e,t,n){var o={};o[n(9)("toStringTag")]="z",e.exports="[object z]"===String(o);},function(e,t){e.exports=function(e,t,n){if(!(e instanceof t)){ throw TypeError("Incorrect "+(n?n+" ":"")+"invocation"); }return e};},function(e,t){e.exports=function(e){try{return {error:!1,value:e()}}catch(e$1){return {error:!0,value:e$1}}};},function(e,t,n){var o=n(5),r=n(177),i=n(77),a=n(102),l=n(41),u=n(17),c=n(49),s=n(9),f=n(37),d=n(40),p=n(114),v=p.IteratorPrototype,h=p.BUGGY_SAFARI_ITERATORS,A=s("iterator"),m=function(){return this};e.exports=function(e,t,n,s,p,g,y){r(n,t,s);var w,x,_,E=function(e){if(e===p&&N){ return N; }if(!h&&e in S){ return S[e]; }switch(e){case"keys":case"values":case"entries":return function(){return new n(this,e)}}return function(){return new n(this)}},b=t+" Iterator",C=!1,S=e.prototype,D=S[A]||S["@@iterator"]||p&&S[p],N=!h&&D||E(p),M="Array"==t&&S.entries||D;if(M&&(w=i(M.call(new e)),v!==Object.prototype&&w.next&&(f||i(w)===v||(a?a(w,v):"function"!=typeof w[A]&&u(w,A,m)),l(w,b,!0,!0),f&&(d[b]=m))),"values"==p&&D&&"values"!==D.name&&(C=!0,N=function(){return D.call(this)}),f&&!y||S[A]===N||u(S,A,N),d[t]=N,p){ if(x={values:E("values"),keys:g?N:E("keys"),entries:E("entries")},y){ for(_ in x){ !h&&!C&&_ in S||c(S,_,x[_]); } }else { o({target:t,proto:!0,forced:h||C},x); } }return x};},function(e,t){e.exports=function(){};},function(e,t,n){var o=n(13),r=n(51),i=n(9)("species");e.exports=function(e,t){var n;return r(e)&&("function"!=typeof(n=e.constructor)||n!==Array&&!r(n.prototype)?o(n)&&null===(n=n[i])&&(n=void 0):n=void 0),new(void 0===n?Array:n)(0===t?0:t)};},function(e,t,n){e.exports=n(185);},function(e,t,n){var o=n(46),r="["+n(71)+"]",i=RegExp("^"+r+r+"*"),a=RegExp(r+r+"*$"),l=function(e){return function(t){var n=String(o(t));return 1&e&&(n=n.replace(i,"")),2&e&&(n=n.replace(a,"")),n}};e.exports={start:l(1),end:l(2),trim:l(3)};},function(e,t,n){e.exports=n(205);},function(e,t,n){var o=n(57),r=n(18),i=n(35);e.exports=function(e,t,n){var a=o(t);a in e?r.f(e,a,i(0,n)):e[a]=n;};},function(e,t,n){var o=n(227),r=n(254);function i(t){return "function"==typeof o&&"symbol"==typeof r?(e.exports=i=function(e){return typeof e},e.exports.default=e.exports,e.exports.__esModule=!0):(e.exports=i=function(e){return e&&"function"==typeof o&&e.constructor===o&&e!==o.prototype?"symbol":typeof e},e.exports.default=e.exports,e.exports.__esModule=!0),i(t)}e.exports=i,e.exports.default=e.exports,e.exports.__esModule=!0;},function(e,t,n){var o=n(9);t.f=o;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4));(0, r.default)(t,"__esModule",{value:!0});var a=n(2).__importDefault(n(31)),l=function(){function e(e,t){var n=this;this.$elem=e,this.editor=t,this._active=!1,e.on("click",function(e){var o;a.default.hideCurAllPanels(),(0, i.default)(o=t.txt.eventHooks.menuClickEvents).call(o,function(e){return e()}),e.stopPropagation(),null!=t.selection.getRange()&&n.clickHandler(e);});}return e.prototype.clickHandler=function(e){},e.prototype.active=function(){this._active=!0,this.$elem.addClass("w-e-active");},e.prototype.unActive=function(){this._active=!1,this.$elem.removeClass("w-e-active");},(0, r.default)(e.prototype,"isActive",{get:function(){return this._active},enumerable:!1,configurable:!0}),e}();t.default=l;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(53)),a=o(n(4)),l=o(n(26));(0, r.default)(t,"__esModule",{value:!0});var u=n(2),c=n(6),s=u.__importDefault(n(130)),f=u.__importDefault(n(131)),d=function(){function e(e){this.editor=e;}return e.prototype.insertImg=function(e,t,n){var o=this.editor,r=o.config,i=function(e,t){return void 0===t&&(t="validate."),o.i18next.t(t+e)},a=t?'alt="'+t+'" ':"",l=n?'data-href="'+encodeURIComponent(n)+'" ':"";o.cmd.do("insertHTML",'<img src="'+e+'" '+a+l+'style="max-width:100%;"/>'),r.linkImgCallback(e,t,n);var u=document.createElement("img");u.onload=function(){u=null;},u.onerror=function(){r.customAlert(i("插入图片错误"),"error","wangEditor: "+i("插入图片错误")+"，"+i("图片链接")+' "'+e+'"，'+i("下载链接失败")),u=null;},u.onabort=function(){return u=null},u.src=e;},e.prototype.uploadImg=function(e){var t=this;if(e.length){var n=this.editor,o=n.config,r=function(e){return n.i18next.t("validate."+e)},u=o.uploadImgServer,d=o.uploadImgShowBase64,p=o.uploadImgMaxSize,v=p/1024/1024,h=o.uploadImgMaxLength,A=o.uploadFileName,m=o.uploadImgParams,g=o.uploadImgParamsWithUrl,y=o.uploadImgHeaders,w=o.uploadImgHooks,x=o.uploadImgTimeout,_=o.withCredentials,E=o.customUploadImg;if(E||u||d){var b=[],C=[];if(c.arrForEach(e,function(e){var t=e.name,o=e.size;if(t&&o){var i=n.config.uploadImgAccept.join("|");!1!==new RegExp(".("+i+")$","i").test(t)?p<o?C.push("【"+t+"】"+r("大于")+" "+v+"M"):b.push(e):C.push("【"+t+"】"+r("不是图片"));}}),C.length){ o.customAlert(r("图片验证未通过")+": \n"+C.join("\n"),"warning"); }else if(0!==b.length){ if(b.length>h){ o.customAlert(r("一次最多上传")+h+r("张图片"),"warning"); }else if(E&&"function"==typeof E){var S;E(b,(0, i.default)(S=this.insertImg).call(S,this));}else {var D=new FormData;if((0, a.default)(b).call(b,function(e,t){var n=A||e.name;b.length>1&&(n+=t+1),D.append(n,e);}),u){var N=u.split("#");u=N[0];var M=N[1]||"";(0, a.default)(c).call(c,m,function(e,t){g&&((0, l.default)(u).call(u,"?")>0?u+="&":u+="?",u=u+e+"="+t),D.append(e,t);}),M&&(u+="#"+M);var k=s.default(u,{timeout:x,formData:D,headers:y,withCredentials:!!_,beforeSend:function(e){if(w.before){ return w.before(e,n,b) }},onTimeout:function(e){o.customAlert(r("上传图片超时"),"error"),w.timeout&&w.timeout(e,n);},onProgress:function(e,t){var o=new f.default(n);t.lengthComputable&&(e=t.loaded/t.total,o.show(e));},onError:function(e){o.customAlert(r("上传图片错误"),"error",r("上传图片错误")+"，"+r("服务器返回状态")+": "+e.status),w.error&&w.error(e,n);},onFail:function(e,t){o.customAlert(r("上传图片失败"),"error",r("上传图片返回结果错误")+"，"+r("返回结果")+": "+t),w.fail&&w.fail(e,n,t);},onSuccess:function(e,l){if(w.customInsert){var u;w.customInsert((0, i.default)(u=t.insertImg).call(u,t),l,n);}else {if("0"!=l.errno){ return o.customAlert(r("上传图片失败"),"error",r("上传图片返回结果错误")+"，"+r("返回结果")+" errno="+l.errno),void(w.fail&&w.fail(e,n,l)); }var c=l.data;(0, a.default)(c).call(c,function(e){"string"==typeof e?t.insertImg(e):t.insertImg(e.url,e.alt,e.href);}),w.success&&w.success(e,n,l);}}});"string"==typeof k&&o.customAlert(k,"error");}else { d&&c.arrForEach(e,function(e){var n=t,o=new FileReader;o.readAsDataURL(e),o.onload=function(){if(this.result){var e=this.result.toString();n.insertImg(e,e);}};}); }} }else { o.customAlert(r("传入的文件不合法"),"warning"); }}}},e}();t.default=d;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(403)),a=o(n(4)),l=o(n(43));function u(e){return !!e.length&&"w-e-todo"===e.attr("class")}function c(e,t){return 3===e.nodeType?e.nodeValue===t.nodeValue:e.contains(t)}function s(e,t,n){void 0===n&&(n=!0);var o=e.nodeValue,r=null==o?void 0:(0, l.default)(o).call(o,0,t);if(o=null==o?void 0:(0, l.default)(o).call(o,t),!n){var i=o;o=r,r=i;}return e.nodeValue=r,o}(0, r.default)(t,"__esModule",{value:!0}),t.dealTextNode=t.isAllTodo=t.isTodo=t.getCursorNextNode=void 0,t.isTodo=u,t.isAllTodo=function(e){var t=e.selection.getSelectionRangeTopNodes();if(0!==t.length){ return (0, i.default)(t).call(t,function(e){return u(e)}) }},t.getCursorNextNode=function e(t,n,o){var r;if(t.hasChildNodes()){var i=t.cloneNode(),l=!1;""===n.nodeValue&&(l=!0);var u=[];return (0, a.default)(r=t.childNodes).call(r,function(t){if(!c(t,n)&&l&&(i.appendChild(t.cloneNode(!0)),"BR"!==t.nodeName&&u.push(t)),c(t,n)){if(1===t.nodeType){var r=e(t,n,o);r&&""!==r.textContent&&(null==i||i.appendChild(r));}if(3===t.nodeType&&n.isEqualNode(t)){var a=s(t,o);i.textContent=a;}l=!0;}}),(0, a.default)(u).call(u,function(e){e.remove();}),i}},t.dealTextNode=s;},function(e,t,n){var o=n(0)(n(1));(0, o.default)(t,"__esModule",{value:!0});var r=n(423),i=function(){function e(e){this.maxSize=e,this.isRe=!1,this.data=new r.CeilStack(e),this.revokeData=new r.CeilStack(e);}return (0, o.default)(e.prototype,"size",{get:function(){return [this.data.size,this.revokeData.size]},enumerable:!1,configurable:!0}),e.prototype.resetMaxSize=function(e){this.data.resetMax(e),this.revokeData.resetMax(e);},e.prototype.save=function(e){return this.isRe&&(this.revokeData.clear(),this.isRe=!1),this.data.instack(e),this},e.prototype.revoke=function(e){!this.isRe&&(this.isRe=!0);var t=this.data.outstack();return !!t&&(this.revokeData.instack(t),e(t),!0)},e.prototype.restore=function(e){!this.isRe&&(this.isRe=!0);var t=this.revokeData.outstack();return !!t&&(this.data.instack(t),e(t),!0)},e}();t.default=i;},function(e,t,n){var o=n(15),r=n(11),i=n(76);e.exports=!o&&!r(function(){return 7!=Object.defineProperty(i("div"),"a",{get:function(){return 7}}).a});},function(e,t,n){var o=n(11),r=/#|\.prototype\./,i=function(e,t){var n=l[a(e)];return n==c||n!=u&&("function"==typeof t?o(t):!!t)},a=i.normalize=function(e){return String(e).replace(r,".").toLowerCase()},l=i.data={},u=i.NATIVE="N",c=i.POLYFILL="P";e.exports=i;},function(e,t,n){var o=n(24),r=n(161);e.exports=Object.setPrototypeOf||("__proto__"in{}?function(){var e,t=!1,n={};try{(e=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__").set).call(n,[]),t=n instanceof Array;}catch(e$1){}return function(n,i){return o(n),r(i),t?e.call(n,i):n.__proto__=i,n}}():void 0);},function(e,t,n){var o=n(16),r=n(27),i=n(80).indexOf,a=n(48);e.exports=function(e,t){var n,l=r(e),u=0,c=[];for(n in l){ !o(a,n)&&o(l,n)&&c.push(n); }for(;t.length>u;){ o(l,n=t[u++])&&(~i(c,n)||c.push(n)); }return c};},function(e,t,n){var o=n(28);e.exports=o("document","documentElement");},function(e,t,n){var o=n(83);e.exports=o&&!Symbol.sham&&"symbol"==typeof Symbol.iterator;},function(e,t,n){var o=n(8);e.exports=o.Promise;},function(e,t,n){var o=n(49);e.exports=function(e,t,n){for(var r in t){ n&&n.unsafe&&e[r]?e[r]=t[r]:o(e,r,t[r],n); }return e};},function(e,t,n){var o=n(28),r=n(18),i=n(9),a=n(15),l=i("species");e.exports=function(e){var t=o(e),n=r.f;a&&t&&!t[l]&&n(t,l,{configurable:!0,get:function(){return this}});};},function(e,t,n){var o=n(79),r=Function.toString;"function"!=typeof o.inspectSource&&(o.inspectSource=function(e){return r.call(e)}),e.exports=o.inspectSource;},function(e,t,n){var o=n(24),r=n(32),i=n(9)("species");e.exports=function(e,t){var n,a=o(e).constructor;return void 0===a||null==(n=o(a)[i])?t:r(n)};},function(e,t,n){var o,r,i,a=n(8),l=n(11),u=n(47),c=n(104),s=n(76),f=n(112),d=n(63),p=a.location,v=a.setImmediate,h=a.clearImmediate,A=a.process,m=a.MessageChannel,g=a.Dispatch,y=0,w={},x=function(e){if(w.hasOwnProperty(e)){var t=w[e];delete w[e],t();}},_=function(e){return function(){x(e);}},E=function(e){x(e.data);},b=function(e){a.postMessage(e+"",p.protocol+"//"+p.host);};v&&h||(v=function(e){
  var arguments$1 = arguments;
  for(var t=[],n=1;arguments.length>n;){ t.push(arguments$1[n++]); }return w[++y]=function(){("function"==typeof e?e:Function(e)).apply(void 0,t);},o(y),y},h=function(e){delete w[e];},d?o=function(e){A.nextTick(_(e));}:g&&g.now?o=function(e){g.now(_(e));}:m&&!f?(i=(r=new m).port2,r.port1.onmessage=E,o=u(i.postMessage,i,1)):a.addEventListener&&"function"==typeof postMessage&&!a.importScripts&&p&&"file:"!==p.protocol&&!l(b)?(o=b,a.addEventListener("message",E,!1)):o="onreadystatechange"in s("script")?function(e){c.appendChild(s("script")).onreadystatechange=function(){c.removeChild(this),x(e);};}:function(e){setTimeout(_(e),0);}),e.exports={set:v,clear:h};},function(e,t,n){var o=n(65);e.exports=/(iphone|ipod|ipad).*applewebkit/i.test(o);},function(e,t,n){var o=n(24),r=n(13),i=n(68);e.exports=function(e,t){if(o(e),r(t)&&t.constructor===e){ return t; }var n=i.f(e);return (0, n.resolve)(t),n.promise};},function(e,t,n){var o,r,i,a=n(11),l=n(77),u=n(17),c=n(16),s=n(9),f=n(37),d=s("iterator"),p=!1;[].keys&&("next"in(i=[].keys())?(r=l(l(i)))!==Object.prototype&&(o=r):p=!0);var v=null==o||a(function(){var e={};return o[d].call(e)!==e});v&&(o={}),f&&!v||c(o,d)||u(o,d,function(){return this}),e.exports={IteratorPrototype:o,BUGGY_SAFARI_ITERATORS:p};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=a.__importDefault(n(3)),u=n(6),c=a.__importDefault(n(268)),s=a.__importDefault(n(283)),f=a.__importDefault(n(284)),d=a.__importDefault(n(285)),p=a.__importDefault(n(304)),v=a.__importDefault(n(409)),h=a.__importDefault(n(410)),A=a.__importDefault(n(411)),m=a.__importDefault(n(412)),g=a.__importStar(n(413)),y=a.__importDefault(n(416)),w=a.__importDefault(n(417)),x=a.__importDefault(n(418)),_=a.__importDefault(n(420)),E=a.__importDefault(n(430)),b=a.__importDefault(n(22)),C=a.__importDefault(n(128)),S=a.__importDefault(n(23)),D=a.__importDefault(n(31)),N=a.__importDefault(n(33)),M=a.__importDefault(n(34)),k=1,T=function(){function e(e,t){if(this.beforeDestroyHooks=[],this.id="wangEditor-"+k++,this.toolbarSelector=e,this.textSelector=t,null==e){ throw new Error("错误：初始化编辑器时候未传入任何参数，请查阅文档"); }this.config=u.deepClone(c.default),this.$toolbarElem=l.default("<div></div>"),this.$textContainerElem=l.default("<div></div>"),this.$textElem=l.default("<div></div>"),this.toolbarElemId="",this.textElemId="",this.isFocus=!1,this.isComposing=!1,this.isCompatibleMode=!1,this.selection=new s.default(this),this.cmd=new f.default(this),this.txt=new d.default(this),this.menus=new p.default(this),this.zIndex=new w.default,this.change=new x.default(this),this.history=new _.default(this);var n=E.default(this),o=n.disable,r=n.enable;this.disable=o,this.enable=r;}return e.prototype.initSelection=function(e){h.default(this,e);},e.prototype.create=function(){this.zIndex.init(this),this.isCompatibleMode=this.config.compatibleMode(),this.isCompatibleMode||(this.config.onchangeTimeout=30),m.default(this),v.default(this),this.txt.init(),this.menus.init(),g.default(this),this.initSelection(!0),A.default(this),this.change.observe(),this.history.observe();},e.prototype.beforeDestroy=function(e){return this.beforeDestroyHooks.push(e),this},e.prototype.destroy=function(){var e,t=this;(0, i.default)(e=this.beforeDestroyHooks).call(e,function(e){return e.call(t)}),this.$toolbarElem.remove(),this.$textContainerElem.remove();},e.prototype.fullScreen=function(){g.setFullScreen(this);},e.prototype.unFullScreen=function(){g.setUnFullScreen(this);},e.prototype.scrollToHead=function(e){y.default(this,e);},e.registerMenu=function(t,n){n&&"function"==typeof n&&(e.globalCustomMenuConstructorList[t]=n);},e.$=l.default,e.BtnMenu=b.default,e.DropList=C.default,e.DropListMenu=S.default,e.Panel=D.default,e.PanelMenu=N.default,e.Tooltip=M.default,e.globalCustomMenuConstructorList={},e}();t.default=T;},function(e,t,n){e.exports=n(197);},function(e,t,n){var o=n(5),r=n(8),i=n(118),a=n(11),l=n(17),u=n(39),c=n(85),s=n(13),f=n(41),d=n(18).f,p=n(29).forEach,v=n(15),h=n(42),A=h.set,m=h.getterFor;e.exports=function(e,t,n){var h,g=-1!==e.indexOf("Map"),y=-1!==e.indexOf("Weak"),w=g?"set":"add",x=r[e],_=x&&x.prototype,E={};if(v&&"function"==typeof x&&(y||_.forEach&&!a(function(){(new x).entries().next();}))){h=t(function(t,n){A(c(t,h,e),{type:e,collection:new x}),null!=n&&u(n,t[w],{that:t,AS_ENTRIES:g});});var b=m(e);p(["add","clear","delete","forEach","get","has","set","keys","values","entries"],function(e){var t="add"==e||"set"==e;e in _&&(!y||"clear"!=e)&&l(h.prototype,e,function(n,o){var r=b(this).collection;if(!t&&y&&!s(n)){ return "get"==e&&void 0; }var i=r[e](0===n?0:n,o);return t?this:i});}),y||d(h.prototype,"size",{configurable:!0,get:function(){return b(this).collection.size}});}else { h=n.getConstructor(t,e,g,w),i.REQUIRED=!0; }return f(h,e,!1,!0),E[e]=h,o({global:!0,forced:!0},E),y||n.setStrong(h,e,g),h};},function(e,t,n){var o=n(48),r=n(13),i=n(16),a=n(18).f,l=n(59),u=n(200),c=l("meta"),s=0,f=Object.isExtensible||function(){return !0},d=function(e){a(e,c,{value:{objectID:"O"+ ++s,weakData:{}}});},p=e.exports={REQUIRED:!1,fastKey:function(e,t){if(!r(e)){ return "symbol"==typeof e?e:("string"==typeof e?"S":"P")+e; }if(!i(e,c)){if(!f(e)){ return "F"; }if(!t){ return "E"; }d(e);}return e[c].objectID},getWeakData:function(e,t){if(!i(e,c)){if(!f(e)){ return !0; }if(!t){ return !1; }d(e);}return e[c].weakData},onFreeze:function(e){return u&&p.REQUIRED&&f(e)&&!i(e,c)&&d(e),e}};o[c]=!0;},function(e,t,n){var o=n(18).f,r=n(60),i=n(107),a=n(47),l=n(85),u=n(39),c=n(87),s=n(108),f=n(15),d=n(118).fastKey,p=n(42),v=p.set,h=p.getterFor;e.exports={getConstructor:function(e,t,n,c){var s=e(function(e,o){l(e,s,t),v(e,{type:t,index:r(null),first:void 0,last:void 0,size:0}),f||(e.size=0),null!=o&&u(o,e[c],{that:e,AS_ENTRIES:n});}),p=h(t),A=function(e,t,n){var o,r,i=p(e),a=m(e,t);return a?a.value=n:(i.last=a={index:r=d(t,!0),key:t,value:n,previous:o=i.last,next:void 0,removed:!1},i.first||(i.first=a),o&&(o.next=a),f?i.size++:e.size++,"F"!==r&&(i.index[r]=a)),e},m=function(e,t){var n,o=p(e),r=d(t);if("F"!==r){ return o.index[r]; }for(n=o.first;n;n=n.next){ if(n.key==t){ return n } }};return i(s.prototype,{clear:function(){for(var e=p(this),t=e.index,n=e.first;n;){ n.removed=!0,n.previous&&(n.previous=n.previous.next=void 0),delete t[n.index],n=n.next; }e.first=e.last=void 0,f?e.size=0:this.size=0;},delete:function(e){var t=p(this),n=m(this,e);if(n){var o=n.next,r=n.previous;delete t.index[n.index],n.removed=!0,r&&(r.next=o),o&&(o.previous=r),t.first==n&&(t.first=o),t.last==n&&(t.last=r),f?t.size--:this.size--;}return !!n},forEach:function(e){for(var t,n=p(this),o=a(e,arguments.length>1?arguments[1]:void 0,3);t=t?t.next:n.first;){ for(o(t.value,t.key,this);t&&t.removed;){ t=t.previous; } }},has:function(e){return !!m(this,e)}}),i(s.prototype,n?{get:function(e){var t=m(this,e);return t&&t.value},set:function(e,t){return A(this,0===e?0:e,t)}}:{add:function(e){return A(this,e=0===e?0:e,e)}}),f&&o(s.prototype,"size",{get:function(){return p(this).size}}),s},setStrong:function(e,t,n){var o=t+" Iterator",r=h(t),i=h(o);c(e,t,function(e,t){v(this,{type:o,target:e,state:r(e),kind:t,last:void 0});},function(){for(var e=i(this),t=e.kind,n=e.last;n&&n.removed;){ n=n.previous; }return e.target&&(e.last=n=n?n.next:e.state.first)?"keys"==t?{value:n.key,done:!1}:"values"==t?{value:n.value,done:!1}:{value:[n.key,n.value],done:!1}:(e.target=void 0,{value:void 0,done:!0})},n?"entries":"values",!n,!0),s(t);}};},function(e,t,n){var o=n(103),r=n(82).concat("length","prototype");t.f=Object.getOwnPropertyNames||function(e){return o(e,r)};},function(e,t){t.f=Object.getOwnPropertySymbols;},function(e,t,n){n(10)("iterator");},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default={zIndex:1e4};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4));(0, r.default)(t,"__esModule",{value:!0}),t.getPasteImgs=t.getPasteHtml=t.getPasteText=void 0;var a=n(2),l=n(6),u=a.__importDefault(n(295));function c(e){var t=e.clipboardData,n="";return n=null==t?window.clipboardData&&window.clipboardData.getData("text"):t.getData("text/plain"),l.replaceHtmlSymbol(n)}t.getPasteText=c,t.getPasteHtml=function(e,t,n){void 0===t&&(t=!0),void 0===n&&(n=!1);var o=e.clipboardData,r="";if(o&&(r=o.getData("text/html")),!r){var i=c(e);if(!i){ return ""; }r="<p>"+i+"</p>";}return r=u.default(r,t,n)},t.getPasteImgs=function(e){var t,n=[];if(c(e)){ return n; }var o=null===(t=e.clipboardData)||void 0===t?void 0:t.items;return o?((0, i.default)(l).call(l,o,function(e,t){var o=t.type;/image/i.test(o)&&n.push(t.getAsFile());}),n):n};},function(e,t,n){e.exports=n(297);},function(e,t,n){e.exports=n(305);},function(e,t,n){e.exports=n(309);},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4)),a=o(n(54));(0, r.default)(t,"__esModule",{value:!0});var l=n(2).__importDefault(n(3)),u=n(7),c=function(){function e(e,t){var n=this;this.hideTimeoutId=0,this.menu=e,this.conf=t;var o=l.default('<div class="w-e-droplist"></div>'),r=l.default("<p>"+t.title+"</p>");r.addClass("w-e-dp-title"),o.append(r);var c=t.list||[],s=t.type||"list",f=t.clickHandler||u.EMPTY_FN,d=l.default('<ul class="'+("list"===s?"w-e-list":"w-e-block")+'"></ul>');(0, i.default)(c).call(c,function(e){var t=e.$elem,o=e.value,r=l.default('<li class="w-e-item"></li>');t&&(r.append(t),d.append(r),r.on("click",function(e){f(o),e.stopPropagation(),n.hideTimeoutId=(0, a.default)(function(){n.hide();});}));}),o.append(d),o.on("mouseleave",function(){n.hideTimeoutId=(0, a.default)(function(){n.hide();});}),this.$container=o,this.rendered=!1,this._show=!1;}return e.prototype.show=function(){this.hideTimeoutId&&clearTimeout(this.hideTimeoutId);var e=this.menu.$elem,t=this.$container;if(!this._show){if(this.rendered){ t.show(); }else {var n=e.getBoundingClientRect().height||0,o=this.conf.width||100;t.css("margin-top",n+"px").css("width",o+"px"),e.append(t),this.rendered=!0;}this._show=!0;}},e.prototype.hide=function(){var e=this.$container;this._show&&(e.hide(),this._show=!1);},(0, r.default)(e.prototype,"isShow",{get:function(){return this._show},enumerable:!1,configurable:!0}),e}();t.default=c;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default=function(e){var t=e.selection.getSelectionContainerElem();return !(null==t||!t.length)&&"A"===t.getNodeName()};},function(e,t,n){var o=n(0),r=o(n(94)),i=o(n(1)),a=o(n(4));(0, i.default)(t,"__esModule",{value:!0});var l=n(6);t.default=function(e,t){var n=new XMLHttpRequest;if(n.open("POST",e),n.timeout=t.timeout||1e4,n.ontimeout=function(){console.error("wangEditor - 请求超时"),t.onTimeout&&t.onTimeout(n);},n.upload&&(n.upload.onprogress=function(e){var n=e.loaded/e.total;t.onProgress&&t.onProgress(n,e);}),t.headers&&(0, a.default)(l).call(l,t.headers,function(e,t){n.setRequestHeader(e,t);}),n.withCredentials=!!t.withCredentials,t.beforeSend){var o=t.beforeSend(n);if(o&&"object"===(0, r.default)(o)&&o.prevent){ return o.msg }}return n.onreadystatechange=function(){if(4===n.readyState){var e=n.status;if(!(e<200||e>=300&&e<400)){if(e>=400){ return console.error("wangEditor - XHR 报错，状态码 "+e),void(t.onError&&t.onError(n)); }var o,i=n.responseText;if("object"!==(0, r.default)(i)){ try{o=JSON.parse(i);}catch(e$1){return console.error("wangEditor - 返回结果不是 JSON 格式",i),void(t.onFail&&t.onFail(n,i))} }else { o=i; }t.onSuccess(n,o);}}},n.send(t.formData||null),n};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(341)),a=o(n(54));(0, r.default)(t,"__esModule",{value:!0});var l=n(2).__importDefault(n(3)),u=function(){function e(e){this.editor=e,this.$textContainer=e.$textContainerElem,this.$bar=l.default('<div class="w-e-progress"></div>'),this.isShow=!1,this.time=0,this.timeoutId=0;}return e.prototype.show=function(e){var t=this;if(!this.isShow){this.isShow=!0;var n=this.$bar;this.$textContainer.append(n),(0, i.default)()-this.time>100&&e<=1&&(n.css("width",100*e+"%"),this.time=(0, i.default)());var o=this.timeoutId;o&&clearTimeout(o),this.timeoutId=(0, a.default)(function(){t.hide();},500);}},e.prototype.hide=function(){this.$bar.remove(),this.isShow=!1,this.time=0,this.timeoutId=0;},e}();t.default=u;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.ListType=void 0;var o,r=n(2),i=r.__importDefault(n(3)),a=r.__importDefault(n(23)),l=n(44),u=r.__importStar(n(368));!function(e){e.OrderedList="OL",e.UnorderedList="UL";}(o=t.ListType||(t.ListType={}));var c=function(e){function t(t){var n=this,r=i.default('<div class="w-e-menu" data-title="序列">\n                <i class="w-e-icon-list2"></i>\n            </div>'),a={width:130,title:"序列",type:"list",list:[{$elem:i.default('\n                        <p>\n                            <i class="w-e-icon-list2 w-e-drop-list-item"></i>\n                            '+t.i18next.t("menus.dropListMenu.list.无序列表")+"\n                        <p>"),value:o.UnorderedList},{$elem:i.default('<p>\n                            <i class="w-e-icon-list-numbered w-e-drop-list-item"></i>\n                            '+t.i18next.t("menus.dropListMenu.list.有序列表")+"\n                        <p>"),value:o.OrderedList}],clickHandler:function(e){n.command(e);}};return n=e.call(this,r,t,a)||this}return r.__extends(t,e),t.prototype.command=function(e){void 0!==this.editor.selection.getSelectionContainerElem()&&(this.handleSelectionRangeNodes(e),this.tryChangeActive());},t.prototype.validator=function(e,t,n){return !(!e.length||!t.length||n.equal(e)||n.equal(t))},t.prototype.handleSelectionRangeNodes=function(e){var t=this.editor,n=t.selection,o=e.toLowerCase(),r=n.getSelectionContainerElem(),i=n.getSelectionStartElem().getNodeTop(t),a=n.getSelectionEndElem().getNodeTop(t);if(this.validator(i,a,t.$textElem)){var c=n.getRange(),s=null==c?void 0:c.collapsed;t.$textElem.equal(r)||(r=r.getNodeTop(t));var f,d={editor:t,listType:e,listTarget:o,$selectionElem:r,$startElem:i,$endElem:a};f=this.isOrderElem(r)?u.ClassType.Wrap:this.isOrderElem(i)&&this.isOrderElem(a)?u.ClassType.Join:this.isOrderElem(i)?u.ClassType.StartJoin:this.isOrderElem(a)?u.ClassType.EndJoin:u.ClassType.Other;var p=new u.default(u.createListHandle(f,d,c));l.updateRange(t,p.getSelectionRangeElem(),!!s);}},t.prototype.isOrderElem=function(e){var t=e.getNodeName();return t===o.OrderedList||t===o.UnorderedList},t.prototype.tryChangeActive=function(){},t}(a.default);t.default=c;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default=function(e){var t=e.selection.getSelectionContainerElem();return !(null==t||!t.length||"CODE"!=t.getNodeName()&&"PRE"!=t.getNodeName()&&"CODE"!=t.parent().getNodeName()&&"PRE"!=t.parent().getNodeName()&&!/hljs/.test(t.parent().attr("class")))};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(30));(0, r.default)(t,"__esModule",{value:!0}),t.todo=void 0;var a=n(2).__importDefault(n(3)),l=function(){function e(e){var t;this.template='<ul class="w-e-todo"><li><span contenteditable="false"><input type="checkbox"></span></li></ul>',this.checked=!1,this.$todo=a.default(this.template),this.$child=null===(t=null==e?void 0:e.childNodes())||void 0===t?void 0:t.clone(!0);}return e.prototype.init=function(){var e=this,t=this.getInput(),n=this.$child,o=this.getInputContainer();n&&n.insertAfter(o),t.on("click",function(){e.checked?null==t||t.removeAttr("checked"):null==t||t.attr("checked",""),e.checked=!e.checked;});},e.prototype.getInput=function(){var e=this.$todo;return (0, i.default)(e).call(e,"input")},e.prototype.getInputContainer=function(){return this.getInput().parent()},e.prototype.getTodo=function(){return this.$todo},e}();t.todo=l,t.default=function(e){var t=new l(e);return t.init(),t};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2);n(140),n(142),n(146),n(148),n(150),n(152),n(154);var r=o.__importDefault(n(115));o.__exportStar(n(433),t),t.default=r.default;},function(e,t,n){var o=n(137);e.exports=o;},function(e,t,n){n(138);var o=n(12).Object,r=e.exports=function(e,t,n){return o.defineProperty(e,t,n)};o.defineProperty.sham&&(r.sham=!0);},function(e,t,n){var o=n(5),r=n(15);o({target:"Object",stat:!0,forced:!r,sham:!r},{defineProperty:n(18).f});},function(e,t){var n;n=function(){return this}();try{n=n||new Function("return this")();}catch(e$1){"object"==typeof window&&(n=window);}e.exports=n;},function(e,t,n){var o=n(20),r=n(141);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[e.i,r,""]]);var i={insert:"head",singleton:!1};o(r,i);e.exports=r.locals||{};},function(e,t,n){(t=n(21)(!1)).push([e.i,'.w-e-toolbar,\n.w-e-text-container,\n.w-e-menu-panel {\n  padding: 0;\n  margin: 0;\n  box-sizing: border-box;\n  background-color: #fff;\n  /*表情菜单样式*/\n  /*分割线样式*/\n}\n.w-e-toolbar h1,\n.w-e-text-container h1,\n.w-e-menu-panel h1 {\n  font-size: 2em !important;\n}\n.w-e-toolbar h2,\n.w-e-text-container h2,\n.w-e-menu-panel h2 {\n  font-size: 1.5em !important;\n}\n.w-e-toolbar h3,\n.w-e-text-container h3,\n.w-e-menu-panel h3 {\n  font-size: 1.17em !important;\n}\n.w-e-toolbar h4,\n.w-e-text-container h4,\n.w-e-menu-panel h4 {\n  font-size: 1em !important;\n}\n.w-e-toolbar h5,\n.w-e-text-container h5,\n.w-e-menu-panel h5 {\n  font-size: 0.83em !important;\n}\n.w-e-toolbar p,\n.w-e-text-container p,\n.w-e-menu-panel p {\n  font-size: 1em !important;\n}\n.w-e-toolbar .eleImg,\n.w-e-text-container .eleImg,\n.w-e-menu-panel .eleImg {\n  cursor: pointer;\n  display: inline-block;\n  font-size: 18px;\n  padding: 0 3px;\n}\n.w-e-toolbar *,\n.w-e-text-container *,\n.w-e-menu-panel * {\n  padding: 0;\n  margin: 0;\n  box-sizing: border-box;\n}\n.w-e-toolbar hr,\n.w-e-text-container hr,\n.w-e-menu-panel hr {\n  cursor: pointer;\n  display: block;\n  height: 0px;\n  border: 0;\n  border-top: 3px solid #ccc;\n  margin: 20px 0;\n}\n.w-e-clear-fix:after {\n  content: "";\n  display: table;\n  clear: both;\n}\n.w-e-drop-list-item {\n  position: relative;\n  top: 1px;\n  padding-right: 7px;\n  color: #333 !important;\n}\n.w-e-drop-list-tl {\n  padding-left: 10px;\n  text-align: left;\n}\n',""]),e.exports=t;},function(e,t,n){var o=n(20),r=n(143);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[e.i,r,""]]);var i={insert:"head",singleton:!1};o(r,i);e.exports=r.locals||{};},function(e,t,n){var o=n(21),r=n(144),i=n(145);t=o(!1);var a=r(i);t.push([e.i,"@font-face {\n  font-family: 'w-e-icon';\n  src: url("+a+') format(\'truetype\');\n  font-weight: normal;\n  font-style: normal;\n}\n[class^="w-e-icon-"],\n[class*=" w-e-icon-"] {\n  /* use !important to prevent issues with browser extensions that change fonts */\n  font-family: \'w-e-icon\' !important;\n  speak: none;\n  font-style: normal;\n  font-weight: normal;\n  font-variant: normal;\n  text-transform: none;\n  line-height: 1;\n  /* Better Font Rendering =========== */\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n.w-e-icon-close:before {\n  content: "\\f00d";\n}\n.w-e-icon-upload2:before {\n  content: "\\e9c6";\n}\n.w-e-icon-trash-o:before {\n  content: "\\f014";\n}\n.w-e-icon-header:before {\n  content: "\\f1dc";\n}\n.w-e-icon-pencil2:before {\n  content: "\\e906";\n}\n.w-e-icon-paint-brush:before {\n  content: "\\f1fc";\n}\n.w-e-icon-image:before {\n  content: "\\e90d";\n}\n.w-e-icon-play:before {\n  content: "\\e912";\n}\n.w-e-icon-location:before {\n  content: "\\e947";\n}\n.w-e-icon-undo:before {\n  content: "\\e965";\n}\n.w-e-icon-redo:before {\n  content: "\\e966";\n}\n.w-e-icon-quotes-left:before {\n  content: "\\e977";\n}\n.w-e-icon-list-numbered:before {\n  content: "\\e9b9";\n}\n.w-e-icon-list2:before {\n  content: "\\e9bb";\n}\n.w-e-icon-link:before {\n  content: "\\e9cb";\n}\n.w-e-icon-happy:before {\n  content: "\\e9df";\n}\n.w-e-icon-bold:before {\n  content: "\\ea62";\n}\n.w-e-icon-underline:before {\n  content: "\\ea63";\n}\n.w-e-icon-italic:before {\n  content: "\\ea64";\n}\n.w-e-icon-strikethrough:before {\n  content: "\\ea65";\n}\n.w-e-icon-table2:before {\n  content: "\\ea71";\n}\n.w-e-icon-paragraph-left:before {\n  content: "\\ea77";\n}\n.w-e-icon-paragraph-center:before {\n  content: "\\ea78";\n}\n.w-e-icon-paragraph-right:before {\n  content: "\\ea79";\n}\n.w-e-icon-paragraph-justify:before {\n  content: "\\ea7a";\n}\n.w-e-icon-terminal:before {\n  content: "\\f120";\n}\n.w-e-icon-page-break:before {\n  content: "\\ea68";\n}\n.w-e-icon-cancel-circle:before {\n  content: "\\ea0d";\n}\n.w-e-icon-font:before {\n  content: "\\ea5c";\n}\n.w-e-icon-text-heigh:before {\n  content: "\\ea5f";\n}\n.w-e-icon-paint-format:before {\n  content: "\\e90c";\n}\n.w-e-icon-indent-increase:before {\n  content: "\\ea7b";\n}\n.w-e-icon-indent-decrease:before {\n  content: "\\ea7c";\n}\n.w-e-icon-row-height:before {\n  content: "\\e9be";\n}\n.w-e-icon-fullscreen_exit:before {\n  content: "\\e900";\n}\n.w-e-icon-fullscreen:before {\n  content: "\\e901";\n}\n.w-e-icon-split-line:before {\n  content: "\\ea0b";\n}\n.w-e-icon-checkbox-checked:before {\n  content: "\\ea52";\n}\n',""]),e.exports=t;},function(e,t,n){e.exports=function(e,t){return t||(t={}),"string"!=typeof(e=e&&e.__esModule?e.default:e)?e:(/^['"].*['"]$/.test(e)&&(e=e.slice(1,-1)),t.hash&&(e+=t.hash),/["'() \t\n]/.test(e)||t.needQuotes?'"'.concat(e.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):e)};},function(e,t,n){n.r(t),t.default="data:font/woff;base64,d09GRgABAAAAABskAAsAAAAAGtgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABPUy8yAAABCAAAAGAAAABgDxIPFWNtYXAAAAFoAAABHAAAARz2mfAgZ2FzcAAAAoQAAAAIAAAACAAAABBnbHlmAAACjAAAFXwAABV8IH7+mGhlYWQAABgIAAAANgAAADYb6gumaGhlYQAAGEAAAAAkAAAAJAkjBWlobXR4AAAYZAAAAKQAAACkmYcEbmxvY2EAABkIAAAAVAAAAFReAmKYbWF4cAAAGVwAAAAgAAAAIAA0ALZuYW1lAAAZfAAAAYYAAAGGmUoJ+3Bvc3QAABsEAAAAIAAAACAAAwAAAAMD7wGQAAUAAAKZAswAAACPApkCzAAAAesAMwEJAAAAAAAAAAAAAAAAAAAAARAAAAAAAAAAAAAAAAAAAAAAQAAA8fwDwP/AAEADwABAAAAAAQAAAAAAAAAAAAAAIAAAAAAAAwAAAAMAAAAcAAEAAwAAABwAAwABAAAAHAAEAQAAAAA8ACAABAAcAAEAIOkB6QbpDekS6UfpZul36bnpu+m+6cbpy+nf6gvqDepS6lzqX+pl6nHqfPAN8BTxIPHc8fz//f//AAAAAAAg6QDpBukM6RLpR+ll6Xfpuem76b7pxunL6d/qC+oN6lLqXOpf6mLqcep38A3wFPEg8dzx/P/9//8AAf/jFwQXABb7FvcWwxamFpYWVRZUFlIWSxZHFjQWCRYIFcQVuxW5FbcVrBWnEBcQEQ8GDksOLAADAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAB//8ADwABAAAAAAAAAAAAAgAANzkBAAAAAAEAAAAAAAAAAAACAAA3OQEAAAAAAQAAAAAAAAAAAAIAADc5AQAAAAAEAEEAAQO/A38ABQALABEAFwAAATMVIREzAxEhFSMVATUzESE1ETUhESM1Av/A/sJ+fgE+wP4Cfv7CAT5+Ar9+AT78ggE+fsACvsD+wn7+An7+wsAAAAAABABBAAEDvwN/AAUACwARABcAAAEhESM1IxM1MxEhNQERIRUjFREVMxUhEQKBAT5+wMB+/sL9wAE+wMD+wgN//sLA/X7A/sJ+AcIBPn7A/v7AfgE+AAAAAAIAAP/ABAADwAAEABMAAAE3AScBAy4BJxM3ASMBAyUBNQEHAYCAAcBA/kCfFzsyY4ABgMD+gMACgAGA/oBOAUBAAcBA/kD+nTI7FwERTgGA/oD9gMABgMD+gIAAAgAA/8AEAAOAACkALQAAAREjNTQmIyEiBh0BFBYzITI2PQEzESEVIyIGFREUFjsBMjY1ETQmKwE1ASE1IQQAwCYa/UAaJiYaAsAaJoD9wCANExMNgA0TEw0gAUD9QALAAYABgEAaJiYawBomJhpA/wCAEw3+wA0TEw0BQA0TQAGAQAAABAAAAAAEAAOAABAAIQAtADQAAAE4ATEROAExITgBMRE4ATEhNSEiBhURFBYzITI2NRE0JiMHFAYjIiY1NDYzMhYTITUTATM3A8D8gAOA/IAaJiYaA4AaJiYagDgoKDg4KCg4QP0A4AEAQOADQP0AAwBAJhr9ABomJhoDABom4Cg4OCgoODj9uIABgP7AwAAAAgAAAEAEAANAADgAPAAAASYnLgEnJiMiBw4BBwYHBgcOAQcGFRQXHgEXFhcWFx4BFxYzMjc+ATc2NzY3PgE3NjU0Jy4BJyYnARENAQPVNjg5djw9Pz89PHY5ODYLBwgLAwMDAwsIBws2ODl2PD0/Pz08djk4NgsHCAsDAwMDCwgHC/2rAUD+wAMgCAYGCAICAgIIBgYIKSoqWS0uLy8uLVkqKikIBgYIAgICAggGBggpKipZLS4vLy4tWSoqKf3gAYDAwAAAAAACAMD/wANAA8AAGwAnAAABIgcOAQcGFRQXHgEXFjEwNz4BNzY1NCcuAScmAyImNTQ2MzIWFRQGAgBCOzpXGRkyMngyMjIyeDIyGRlXOjtCUHBwUFBwcAPAGRlXOjtCeH19zEFBQUHMfX14Qjs6VxkZ/gBwUFBwcFBQcAAAAQAAAAAEAAOAACsAAAEiBw4BBwYHJxEhJz4BMzIXHgEXFhUUBw4BBwYHFzY3PgE3NjU0Jy4BJyYjAgA1MjJcKSkjlgGAkDWLUFBFRmkeHgkJIhgYHlUoICAtDAwoKIteXWoDgAoLJxscI5b+gJA0PB4eaUZFUCsoKUkgIRpgIysrYjY2OWpdXosoKAABAAAAAAQAA4AAKgAAExQXHgEXFhc3JicuAScmNTQ3PgE3NjMyFhcHIREHJicuAScmIyIHDgEHBgAMDC0gIChVHhgYIgkJHh5pRkVQUIs1kAGAliMpKVwyMjVqXV6LKCgBgDk2NmIrKyNgGiEgSSkoK1BFRmkeHjw0kAGAliMcGycLCigoi15dAAAAAAIAAABABAEDAAAmAE0AABMyFx4BFxYVFAcOAQcGIyInLgEnJjUnNDc+ATc2MxUiBgcOAQc+ASEyFx4BFxYVFAcOAQcGIyInLgEnJjUnNDc+ATc2MxUiBgcOAQc+AeEuKSk9ERISET0pKS4uKSk9ERIBIyN6UlFdQHUtCRAHCBICSS4pKT0REhIRPSkpLi4pKT0REgEjI3pSUV1AdS0JEAcIEgIAEhE9KSkuLikpPRESEhE9KSkuIF1RUnojI4AwLggTCgIBEhE9KSkuLikpPRESEhE9KSkuIF1RUnojI4AwLggTCgIBAAAGAED/wAQAA8AAAwAHAAsAEQAdACkAACUhFSERIRUhESEVIScRIzUjNRMVMxUjNTc1IzUzFRURIzUzNSM1MzUjNQGAAoD9gAKA/YACgP2AwEBAQIDAgIDAwICAgICAgAIAgAIAgMD/AMBA/fIyQJI8MkCS7v7AQEBAQEAABgAA/8AEAAPAAAMABwALABcAIwAvAAABIRUhESEVIREhFSEBNDYzMhYVFAYjIiYRNDYzMhYVFAYjIiYRNDYzMhYVFAYjIiYBgAKA/YACgP2AAoD9gP6ASzU1S0s1NUtLNTVLSzU1S0s1NUtLNTVLA4CA/wCA/wCAA0A1S0s1NUtL/rU1S0s1NUtL/rU1S0s1NUtLAAUAAABABWADAAADAAcACwAOABEAABMhFSEVIRUhFSEVIQEXNzUnBwADgPyAA4D8gAOA/IAD4MDAwMADAMBAwEDAAUDAwEDAwAAAAAADAAAAAAQAA6AAAwANABQAADchFSElFSE1EyEVITUhJQkBIxEjEQAEAPwABAD8AIABAAEAAQD9YAEgASDggEBAwEBAAQCAgMABIP7g/wABAAAAAAACAB7/zAPiA7QAMwBkAAABIiYnJicmNDc2PwE+ATMyFhcWFxYUBwYPAQYiJyY0PwE2NCcuASMiBg8BBhQXFhQHDgEjAyImJyYnJjQ3Nj8BNjIXFhQPAQYUFx4BMzI2PwE2NCcmNDc2MhcWFxYUBwYPAQ4BIwG4ChMIIxISEhIjwCNZMTFZIyMSEhISI1gPLA8PD1gpKRQzHBwzFMApKQ8PCBMKuDFZIyMSEhISI1gPLA8PD1gpKRQzHBwzFMApKQ8PDysQIxISEhIjwCNZMQFECAckLS1eLS0kwCIlJSIkLS1eLS0kVxAQDysPWCl0KRQVFRTAKXQpDysQBwj+iCUiJC0tXi0tJFcQEA8rD1gpdCkUFRUUwCl0KQ8rEA8PJC0tXi0tJMAiJQAAAAAFAAD/wAQAA8AAGwA3AFMAXwBrAAAFMjc+ATc2NTQnLgEnJiMiBw4BBwYVFBceARcWEzIXHgEXFhUUBw4BBwYjIicuAScmNTQ3PgE3NhMyNz4BNzY3BgcOAQcGIyInLgEnJicWFx4BFxYnNDYzMhYVFAYjIiYlNDYzMhYVFAYjIiYCAGpdXosoKCgoi15dampdXosoKCgoi15dalZMTHEgISEgcUxMVlZMTHEgISEgcUxMVisrKlEmJiMFHBtWODc/Pzc4VhscBSMmJlEqK9UlGxslJRsbJQGAJRsbJSUbGyVAKCiLXl1qal1eiygoKCiLXl1qal1eiygoA6AhIHFMTFZWTExxICEhIHFMTFZWTExxICH+CQYGFRAQFEM6OlYYGRkYVjo6QxQQEBUGBvcoODgoKDg4KCg4OCgoODgAAAEAAAFABAACQAAPAAATFRQWMyEyNj0BNCYjISIGABMNA8ANExMN/EANEwIgwA0TEw3ADRMTAAAAAwAA/8AEAAPAABsANwBDAAABIgcOAQcGFRQXHgEXFjMyNz4BNzY1NCcuAScmAyInLgEnJjU0Nz4BNzYzMhceARcWFRQHDgEHBhMHJwcXBxc3FzcnNwIAal1eiygoKCiLXl1qal1eiygoKCiLXl1qVkxMcSAhISBxTExWVkxMcSAhISBxTExKoKBgoKBgoKBgoKADwCgoi15dampdXosoKCgoi15dampdXosoKPxgISBxTExWVkxMcSAhISBxTExWVkxMcSAhAqCgoGCgoGCgoGCgoAACAAD/wAQAA8AADwAVAAABISIGFREUFjMhMjY1ETQmASc3FwEXA4D9ADVLSzUDADVLS/4L7VqTATNaA8BLNf0ANUtLNQMANUv85e5akgEyWgAAAAABAGX/wAObA8AAKQAAASImIyIHDgEHBhUUFjMuATU0NjcwBwYCBwYHFSETMzcjNx4BMzI2Nw4BAyBEaEZxU1RtGhtJSAYNZUoQEEs8PFkBPWzGLNc0LVUmLlAYHT0DsBAeHWE+P0FNOwsmN5lvA31+/sWPkCMZAgCA9gkPN2sJBwAAAAACAAAAAAQAA4AACQAXAAAlMwcnMxEjNxcjJREnIxEzFSE1MxEjBxEDgICgoICAoKCA/wBAwID+gIDAQMDAwAIAwMDA/wCA/UBAQALAgAEAAAMAwAAAA0ADgAAWAB8AKAAAAT4BNTQnLgEnJiMhESEyNz4BNzY1NCYBMzIWFRQGKwETIxEzMhYVFAYCxBwgFBRGLi81/sABgDUvLkYUFET+hGUqPDwpZp+fnyw+PgHbIlQvNS8uRhQU/IAUFEYuLzVGdAFGSzU1S/6AAQBLNTVLAAAAAAIAwAAAA0ADgAAfACMAAAEzERQHDgEHBiMiJy4BJyY1ETMRFBYXHgEzMjY3PgE1ASEVIQLAgBkZVzo7QkI7OlcZGYAbGBxJKChJHBgb/gACgP2AA4D+YDw0NU4WFxcWTjU0PAGg/mAeOBcYGxsYFzge/qCAAAAAAAEAgAAAA4ADgAALAAABFSMBMxUhNTMBIzUDgID+wID+QIABQIADgED9AEBAAwBAAAEAAAAABAADgAA9AAABFSMeARUUBgcOASMiJicuATUzFBYzMjY1NCYjITUhLgEnLgE1NDY3PgEzMhYXHgEVIzQmIyIGFRQWMzIWFwQA6xUWNTAscT4+cSwwNYByTk5yck7+AAEsAgQBMDU1MCxxPj5xLDA1gHJOTnJyTjtuKwHAQB1BIjViJCEkJCEkYjU0TEw0NExAAQMBJGI1NWIkISQkISRiNTRMTDQ0TCEfAAAACgAAAAAEAAOAAAMABwALAA8AEwAXABsAHwAjACcAABMRIREBNSEVHQEhNQEVITUjFSE1ESEVISUhFSERNSEVASEVISE1IRUABAD9gAEA/wABAP8AQP8AAQD/AAKAAQD/AAEA/IABAP8AAoABAAOA/IADgP3AwMBAwMACAMDAwMD/AMDAwAEAwMD+wMDAwAAABQAAAAAEAAOAAAMABwALAA8AEwAAEyEVIRUhFSERIRUhESEVIREhFSEABAD8AAKA/YACgP2ABAD8AAQA/AADgIBAgP8AgAFAgP8AgAAAAAAFAAAAAAQAA4AAAwAHAAsADwATAAATIRUhFyEVIREhFSEDIRUhESEVIQAEAPwAwAKA/YACgP2AwAQA/AAEAPwAA4CAQID/AIABQID/AIAAAAUAAAAABAADgAADAAcACwAPABMAABMhFSEFIRUhESEVIQEhFSERIRUhAAQA/AABgAKA/YACgP2A/oAEAPwABAD8AAOAgECA/wCAAUCA/wCAAAAAAAUAAAAABAADgAADAAcACwAPABMAABMhFSEVIRUhFSEVIRUhFSEVIRUhAAQA/AAEAPwABAD8AAQA/AAEAPwAA4CAQIBAgECAQIAAAAAGAAAAAAQAA4AAAwAHAAsADwATABYAABMhFSEFIRUhFSEVIRUhFSEFIRUhGQEFAAQA/AABgAKA/YACgP2AAoD9gP6ABAD8AAEAA4CAQIBAgECAQIABAAGAwAAAAAYAAAAABAADgAADAAcACwAPABMAFgAAEyEVIQUhFSEVIRUhFSEVIQUhFSEBESUABAD8AAGAAoD9gAKA/YACgP2A/oAEAPwAAQD/AAOAgECAQIBAgECAAoD+gMAAAQA/AD8C5gLmACwAACUUDwEGIyIvAQcGIyIvASY1ND8BJyY1ND8BNjMyHwE3NjMyHwEWFRQPARcWFQLmEE4QFxcQqKgQFxYQThAQqKgQEE4QFhcQqKgQFxcQThAQqKgQwxYQThAQqKgQEE4QFhcQqKgQFxcQThAQqKgQEE4QFxcQqKgQFwAAAAYAAAAAAyUDbgAUACgAPABNAFUAggAAAREUBwYrASInJjURNDc2OwEyFxYVMxEUBwYrASInJjURNDc2OwEyFxYXERQHBisBIicmNRE0NzY7ATIXFhMRIREUFxYXFjMhMjc2NzY1ASEnJicjBgcFFRQHBisBERQHBiMhIicmNREjIicmPQE0NzY7ATc2NzY7ATIXFh8BMzIXFhUBJQYFCCQIBQYGBQgkCAUGkgUFCCUIBQUFBQglCAUFkgUFCCUIBQUFBQglCAUFSf4ABAQFBAIB2wIEBAQE/oABABsEBrUGBAH3BgUINxobJv4lJhsbNwgFBQUFCLEoCBcWF7cXFhYJKLAIBQYCEv63CAUFBQUIAUkIBQYGBQj+twgFBQUFCAFJCAUGBgUI/rcIBQUFBQgBSQgFBgYF/lsCHf3jDQsKBQUFBQoLDQJmQwUCAgVVJAgGBf3jMCIjISIvAiAFBggkCAUFYBUPDw8PFWAFBQgAAgAHAEkDtwKvABoALgAACQEGIyIvASY1ND8BJyY1ND8BNjMyFwEWFRQHARUUBwYjISInJj0BNDc2MyEyFxYBTv72BgcIBR0GBuHhBgYdBQgHBgEKBgYCaQUFCP3bCAUFBQUIAiUIBQUBhf72BgYcBggHBuDhBgcHBh0FBf71BQgHBv77JQgFBQUFCCUIBQUFBQAAAAEAIwAAA90DbgCzAAAlIicmIyIHBiMiJyY1NDc2NzY3Njc2PQE0JyYjISIHBh0BFBcWFxYzFhcWFRQHBiMiJyYjIgcGIyInJjU0NzY3Njc2NzY9ARE0NTQ1NCc0JyYnJicmJyYnJiMiJyY1NDc2MzIXFjMyNzYzMhcWFRQHBiMGBwYHBh0BFBcWMyEyNzY9ATQnJicmJyY1NDc2MzIXFjMyNzYzMhcWFRQHBgciBwYHBhURFBcWFxYXMhcWFRQHBiMDwRkzMhoZMjMZDQgHCQoNDBEQChIBBxX+fhYHARUJEhMODgwLBwcOGzU1GhgxMRgNBwcJCQsMEA8JEgECAQIDBAQFCBIRDQ0KCwcHDho1NRoYMDEYDgcHCQoMDRAQCBQBBw8BkA4HARQKFxcPDgcHDhkzMhkZMTEZDgcHCgoNDRARCBQUCRERDg0KCwcHDgACAgICDAsPEQkJAQEDAwUMROAMBQMDBQzUUQ0GAQIBCAgSDwwNAgICAgwMDhEICQECAwMFDUUhAdACDQ0ICA4OCgoLCwcHAwYBAQgIEg8MDQICAgINDA8RCAgBAgEGDFC2DAcBAQcMtlAMBgEBBgcWDwwNAgICAg0MDxEICAEBAgYNT/3mRAwGAgIBCQgRDwwNAAACAAD/twP/A7cAEwA5AAABMhcWFRQHAgcGIyInJjU0NwE2MwEWFxYfARYHBiMiJyYnJicmNRYXFhcWFxYzMjc2NzY3Njc2NzY3A5soHh4avkw3RUg0NDUBbSEp/fgXJicvAQJMTHtHNjYhIRARBBMUEBASEQkXCA8SExUVHR0eHikDtxsaKCQz/plGNDU0SUkwAUsf/bErHx8NKHpNTBobLi86OkQDDw4LCwoKFiUbGhERCgsEBAIAAQAAAAAAAIWwaoFfDzz1AAsEAAAAAADbteOZAAAAANu145kAAP+3BWADwAAAAAgAAgAAAAAAAAABAAADwP/AAAAFgAAA//8FYAABAAAAAAAAAAAAAAAAAAAAKQQAAAAAAAAAAAAAAAIAAAAEAABBBAAAQQQAAAAEAAAABAAAAAQAAAAEAADABAAAAAQAAAAEAAAABAAAQAQAAAAFgAAABAAAAAQAAB4EAAAABAAAAAQAAAAEAAAABAAAZQQAAAAEAADABAAAwAQAAIAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAMlAD8DJQAAA74ABwQAACMD/wAAAAAAAAAKABQAHgBKAHYApADmAS4BkgHQAhYCXALQAw4DWAN+A6gEPgTeBPoFZAWOBdAF+AY6BnYGjgbmBy4HVgd+B6gHzgf8CCoIbgkmCXAKYgq+AAEAAAApALQACgAAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAOAK4AAQAAAAAAAQAHAAAAAQAAAAAAAgAHAGAAAQAAAAAAAwAHADYAAQAAAAAABAAHAHUAAQAAAAAABQALABUAAQAAAAAABgAHAEsAAQAAAAAACgAaAIoAAwABBAkAAQAOAAcAAwABBAkAAgAOAGcAAwABBAkAAwAOAD0AAwABBAkABAAOAHwAAwABBAkABQAWACAAAwABBAkABgAOAFIAAwABBAkACgA0AKRpY29tb29uAGkAYwBvAG0AbwBvAG5WZXJzaW9uIDEuMABWAGUAcgBzAGkAbwBuACAAMQAuADBpY29tb29uAGkAYwBvAG0AbwBvAG5pY29tb29uAGkAYwBvAG0AbwBvAG5SZWd1bGFyAFIAZQBnAHUAbABhAHJpY29tb29uAGkAYwBvAG0AbwBvAG5Gb250IGdlbmVyYXRlZCBieSBJY29Nb29uLgBGAG8AbgB0ACAAZwBlAG4AZQByAGEAdABlAGQAIABiAHkAIABJAGMAbwBNAG8AbwBuAC4AAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";},function(e,t,n){var o=n(20),r=n(147);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[e.i,r,""]]);var i={insert:"head",singleton:!1};o(r,i);e.exports=r.locals||{};},function(e,t,n){(t=n(21)(!1)).push([e.i,'.w-e-toolbar {\n  display: flex;\n  padding: 0 6px;\n  flex-wrap: wrap;\n  position: relative;\n  /* 单个菜单 */\n}\n.w-e-toolbar .w-e-menu {\n  position: relative;\n  display: flex;\n  width: 40px;\n  height: 40px;\n  align-items: center;\n  justify-content: center;\n  text-align: center;\n  cursor: pointer;\n}\n.w-e-toolbar .w-e-menu i {\n  color: #999;\n}\n.w-e-toolbar .w-e-menu:hover {\n  background-color: #F6F6F6;\n}\n.w-e-toolbar .w-e-menu:hover i {\n  color: #333;\n}\n.w-e-toolbar .w-e-active i {\n  color: #1e88e5;\n}\n.w-e-toolbar .w-e-active:hover i {\n  color: #1e88e5;\n}\n.w-e-menu-tooltip {\n  position: absolute;\n  display: flex;\n  color: #f1f1f1;\n  background-color: rgba(0, 0, 0, 0.75);\n  box-shadow: 0 2px 8px 0 rgba(0, 0, 0, 0.15);\n  border-radius: 4px;\n  padding: 4px 5px 6px;\n  justify-content: center;\n  align-items: center;\n}\n.w-e-menu-tooltip-up::after {\n  content: "";\n  position: absolute;\n  top: 100%;\n  left: 50%;\n  margin-left: -5px;\n  border: 5px solid rgba(0, 0, 0, 0);\n  border-top-color: rgba(0, 0, 0, 0.73);\n}\n.w-e-menu-tooltip-down::after {\n  content: "";\n  position: absolute;\n  bottom: 100%;\n  left: 50%;\n  margin-left: -5px;\n  border: 5px solid rgba(0, 0, 0, 0);\n  border-bottom-color: rgba(0, 0, 0, 0.73);\n}\n.w-e-menu-tooltip-item-wrapper {\n  font-size: 14px;\n  margin: 0 5px;\n}\n',""]),e.exports=t;},function(e,t,n){var o=n(20),r=n(149);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[e.i,r,""]]);var i={insert:"head",singleton:!1};o(r,i);e.exports=r.locals||{};},function(e,t,n){(t=n(21)(!1)).push([e.i,'.w-e-text-container {\n  position: relative;\n  height: 100%;\n}\n.w-e-text-container .w-e-progress {\n  position: absolute;\n  background-color: #1e88e5;\n  top: 0;\n  left: 0;\n  height: 1px;\n}\n.w-e-text-container .placeholder {\n  color: #D4D4D4;\n  position: absolute;\n  font-size: 11pt;\n  line-height: 22px;\n  left: 10px;\n  top: 10px;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n  z-index: -1;\n}\n.w-e-text {\n  padding: 0 10px;\n  overflow-y: auto;\n}\n.w-e-text p,\n.w-e-text h1,\n.w-e-text h2,\n.w-e-text h3,\n.w-e-text h4,\n.w-e-text h5,\n.w-e-text table,\n.w-e-text pre {\n  margin: 10px 0;\n  line-height: 1.5;\n}\n.w-e-text ul,\n.w-e-text ol {\n  margin: 10px 0 10px 20px;\n}\n.w-e-text blockquote {\n  display: block;\n  border-left: 8px solid #d0e5f2;\n  padding: 5px 10px;\n  margin: 10px 0;\n  line-height: 1.4;\n  font-size: 100%;\n  background-color: #f1f1f1;\n}\n.w-e-text code {\n  display: inline-block;\n  background-color: #f1f1f1;\n  border-radius: 3px;\n  padding: 3px 5px;\n  margin: 0 3px;\n}\n.w-e-text pre code {\n  display: block;\n}\n.w-e-text table {\n  border-top: 1px solid #ccc;\n  border-left: 1px solid #ccc;\n}\n.w-e-text table td,\n.w-e-text table th {\n  border-bottom: 1px solid #ccc;\n  border-right: 1px solid #ccc;\n  padding: 3px 5px;\n  min-height: 30px;\n}\n.w-e-text table th {\n  border-bottom: 2px solid #ccc;\n  text-align: center;\n  background-color: #f1f1f1;\n}\n.w-e-text:focus {\n  outline: none;\n}\n.w-e-text img {\n  cursor: pointer;\n}\n.w-e-text img:hover {\n  box-shadow: 0 0 5px #333;\n}\n.w-e-text .w-e-todo {\n  margin: 0 0 0 20px;\n}\n.w-e-text .w-e-todo li {\n  list-style: none;\n  font-size: 1em;\n}\n.w-e-text .w-e-todo li span:nth-child(1) {\n  position: relative;\n  left: -18px;\n}\n.w-e-text .w-e-todo li span:nth-child(1) input {\n  position: absolute;\n  margin-right: 3px;\n}\n.w-e-text .w-e-todo li span:nth-child(1) input[type=checkbox] {\n  top: 50%;\n  margin-top: -6px;\n}\n.w-e-tooltip {\n  position: absolute;\n  display: flex;\n  color: #f1f1f1;\n  background-color: rgba(0, 0, 0, 0.75);\n  box-shadow: 0 2px 8px 0 rgba(0, 0, 0, 0.15);\n  border-radius: 4px;\n  padding: 4px 5px 6px;\n  justify-content: center;\n  align-items: center;\n}\n.w-e-tooltip-up::after {\n  content: "";\n  position: absolute;\n  top: 100%;\n  left: 50%;\n  margin-left: -5px;\n  border: 5px solid rgba(0, 0, 0, 0);\n  border-top-color: rgba(0, 0, 0, 0.73);\n}\n.w-e-tooltip-down::after {\n  content: "";\n  position: absolute;\n  bottom: 100%;\n  left: 50%;\n  margin-left: -5px;\n  border: 5px solid rgba(0, 0, 0, 0);\n  border-bottom-color: rgba(0, 0, 0, 0.73);\n}\n.w-e-tooltip-item-wrapper {\n  cursor: pointer;\n  font-size: 14px;\n  margin: 0 5px;\n}\n.w-e-tooltip-item-wrapper:hover {\n  color: #ccc;\n  text-decoration: underline;\n}\n',""]),e.exports=t;},function(e,t,n){var o=n(20),r=n(151);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[e.i,r,""]]);var i={insert:"head",singleton:!1};o(r,i);e.exports=r.locals||{};},function(e,t,n){(t=n(21)(!1)).push([e.i,'.w-e-menu .w-e-panel-container {\n  position: absolute;\n  top: 0;\n  left: 50%;\n  border: 1px solid #ccc;\n  border-top: 0;\n  box-shadow: 1px 1px 2px #ccc;\n  color: #333;\n  background-color: #fff;\n  text-align: left;\n  /* 为 emotion panel 定制的样式 */\n  /* 上传图片、上传视频的 panel 定制样式 */\n}\n.w-e-menu .w-e-panel-container .w-e-panel-close {\n  position: absolute;\n  right: 0;\n  top: 0;\n  padding: 5px;\n  margin: 2px 5px 0 0;\n  cursor: pointer;\n  color: #999;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-close:hover {\n  color: #333;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-title {\n  list-style: none;\n  display: flex;\n  font-size: 14px;\n  margin: 2px 10px 0 10px;\n  border-bottom: 1px solid #f1f1f1;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-title .w-e-item {\n  padding: 3px 5px;\n  color: #999;\n  cursor: pointer;\n  margin: 0 3px;\n  position: relative;\n  top: 1px;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-title .w-e-active {\n  color: #333;\n  border-bottom: 1px solid #333;\n  cursor: default;\n  font-weight: 700;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content {\n  padding: 10px 15px 10px 15px;\n  font-size: 16px;\n  /* 输入框的样式 */\n  /* 按钮的样式 */\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content input:focus,\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content textarea:focus,\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content button:focus {\n  outline: none;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content textarea {\n  width: 100%;\n  border: 1px solid #ccc;\n  padding: 5px;\n  margin-top: 10px;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content textarea:focus {\n  border-color: #1e88e5;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content input[type=text] {\n  border: none;\n  border-bottom: 1px solid #ccc;\n  font-size: 14px;\n  height: 20px;\n  color: #333;\n  text-align: left;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content input[type=text].small {\n  width: 30px;\n  text-align: center;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content input[type=text].block {\n  display: block;\n  width: 100%;\n  margin: 10px 0;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content input[type=text]:focus {\n  border-bottom: 2px solid #1e88e5;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content .w-e-button-container button {\n  font-size: 14px;\n  color: #1e88e5;\n  border: none;\n  padding: 5px 10px;\n  background-color: #fff;\n  cursor: pointer;\n  border-radius: 3px;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content .w-e-button-container button.left {\n  float: left;\n  margin-right: 10px;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content .w-e-button-container button.right {\n  float: right;\n  margin-left: 10px;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content .w-e-button-container button.gray {\n  color: #999;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content .w-e-button-container button.red {\n  color: #c24f4a;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content .w-e-button-container button:hover {\n  background-color: #f1f1f1;\n}\n.w-e-menu .w-e-panel-container .w-e-panel-tab-content .w-e-button-container:after {\n  content: "";\n  display: table;\n  clear: both;\n}\n.w-e-menu .w-e-panel-container .w-e-emoticon-container .w-e-item {\n  cursor: pointer;\n  font-size: 18px;\n  padding: 0 3px;\n  display: inline-block;\n}\n.w-e-menu .w-e-panel-container .w-e-up-img-container,\n.w-e-menu .w-e-panel-container .w-e-up-video-container {\n  text-align: center;\n}\n.w-e-menu .w-e-panel-container .w-e-up-img-container .w-e-up-btn,\n.w-e-menu .w-e-panel-container .w-e-up-video-container .w-e-up-btn {\n  display: inline-block;\n  color: #999;\n  cursor: pointer;\n  font-size: 60px;\n  line-height: 1;\n}\n.w-e-menu .w-e-panel-container .w-e-up-img-container .w-e-up-btn:hover,\n.w-e-menu .w-e-panel-container .w-e-up-video-container .w-e-up-btn:hover {\n  color: #333;\n}\n',""]),e.exports=t;},function(e,t,n){var o=n(20),r=n(153);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[e.i,r,""]]);var i={insert:"head",singleton:!1};o(r,i);e.exports=r.locals||{};},function(e,t,n){(t=n(21)(!1)).push([e.i,".w-e-toolbar .w-e-droplist {\n  position: absolute;\n  left: 0;\n  top: 0;\n  background-color: #fff;\n  border: 1px solid #f1f1f1;\n  border-right-color: #ccc;\n  border-bottom-color: #ccc;\n}\n.w-e-toolbar .w-e-droplist .w-e-dp-title {\n  text-align: center;\n  color: #999;\n  line-height: 2;\n  border-bottom: 1px solid #f1f1f1;\n  font-size: 13px;\n}\n.w-e-toolbar .w-e-droplist ul.w-e-list {\n  list-style: none;\n  line-height: 1;\n}\n.w-e-toolbar .w-e-droplist ul.w-e-list li.w-e-item {\n  color: #333;\n  padding: 5px 0;\n}\n.w-e-toolbar .w-e-droplist ul.w-e-list li.w-e-item:hover {\n  background-color: #f1f1f1;\n}\n.w-e-toolbar .w-e-droplist ul.w-e-block {\n  list-style: none;\n  text-align: left;\n  padding: 5px;\n}\n.w-e-toolbar .w-e-droplist ul.w-e-block li.w-e-item {\n  display: inline-block;\n  padding: 3px 5px;\n}\n.w-e-toolbar .w-e-droplist ul.w-e-block li.w-e-item:hover {\n  background-color: #f1f1f1;\n}\n",""]),e.exports=t;},function(e,t,n){var o=n(0)(n(155));Element.prototype.matches||(Element.prototype.matches=function(e){for(var t=this.ownerDocument.querySelectorAll(e),n=t.length;n>=0&&t.item(n)!==this;n--){ }return n>-1}),o.default||(window.Promise=o.default);},function(e,t,n){e.exports=n(156);},function(e,t,n){var o=n(157);e.exports=o;},function(e,t,n){n(158),n(67),n(166),n(173),n(174),n(175),n(69),n(50);var o=n(12);e.exports=o.Promise;},function(e,t,n){var o=n(5),r=n(77),i=n(102),a=n(60),l=n(17),u=n(35),c=n(39),s=function(e,t){var n=this;if(!(n instanceof s)){ return new s(e,t); }i&&(n=i(new Error(void 0),r(n))),void 0!==t&&l(n,"message",String(t));var o=[];return c(e,o.push,{that:o}),l(n,"errors",o),n};s.prototype=a(Error.prototype,{constructor:u(5,s),message:u(5,""),name:u(5,"AggregateError")}),o({global:!0},{AggregateError:s});},function(e,t,n){var o=n(8),r=n(17);e.exports=function(e,t){try{r(o,e,t);}catch(n){o[e]=t;}return t};},function(e,t,n){var o=n(11);e.exports=!o(function(){function e(){}return e.prototype.constructor=null,Object.getPrototypeOf(new e)!==e.prototype});},function(e,t,n){var o=n(13);e.exports=function(e){if(!o(e)&&null!==e){ throw TypeError("Can't set "+String(e)+" as a prototype"); }return e};},function(e,t,n){var o=n(15),r=n(18),i=n(24),a=n(61);e.exports=o?Object.defineProperties:function(e,t){i(e);for(var n,o=a(t),l=o.length,u=0;l>u;){ r.f(e,n=o[u++],t[n]); }return e};},function(e,t,n){var o=n(9),r=n(40),i=o("iterator"),a=Array.prototype;e.exports=function(e){return void 0!==e&&(r.Array===e||a[i]===e)};},function(e,t,n){var o=n(66),r=n(40),i=n(9)("iterator");e.exports=function(e){if(null!=e){ return e[i]||e["@@iterator"]||r[o(e)] }};},function(e,t,n){var o=n(24);e.exports=function(e){var t=e.return;if(void 0!==t){ return o(t.call(e)).value }};},function(e,t,n){var o,r,i,a,l=n(5),u=n(37),c=n(8),s=n(28),f=n(106),d=n(49),p=n(107),v=n(41),h=n(108),A=n(13),m=n(32),g=n(85),y=n(109),w=n(39),x=n(168),_=n(110),E=n(111).set,b=n(169),C=n(113),S=n(171),D=n(68),N=n(86),M=n(42),k=n(101),T=n(9),B=n(63),I=n(64),R=T("species"),P="Promise",H=M.get,F=M.set,L=M.getterFor(P),Q=f,O=c.TypeError,U=c.document,j=c.process,Y=s("fetch"),z=D.f,$=z,V=!!(U&&U.createEvent&&c.dispatchEvent),G="function"==typeof PromiseRejectionEvent,J=k(P,function(){if(!(y(Q)!==String(Q))){if(66===I){ return !0; }if(!B&&!G){ return !0 }}if(u&&!Q.prototype.finally){ return !0; }if(I>=51&&/native code/.test(Q)){ return !1; }var e=Q.resolve(1),t=function(e){e(function(){},function(){});};return (e.constructor={})[R]=t,!(e.then(function(){})instanceof t)}),K=J||!x(function(e){Q.all(e).catch(function(){});}),W=function(e){var t;return !(!A(e)||"function"!=typeof(t=e.then))&&t},q=function(e,t){if(!e.notified){e.notified=!0;var n=e.reactions;b(function(){for(var o=e.value,r=1==e.state,i=0;n.length>i;){var a,l,u,c=n[i++],s=r?c.ok:c.fail,f=c.resolve,d=c.reject,p=c.domain;try{s?(r||(2===e.rejection&&te(e),e.rejection=1),!0===s?a=o:(p&&p.enter(),a=s(o),p&&(p.exit(),u=!0)),a===c.promise?d(O("Promise-chain cycle")):(l=W(a))?l.call(a,f,d):f(a)):d(o);}catch(e$1){p&&!u&&p.exit(),d(e$1);}}e.reactions=[],e.notified=!1,t&&!e.rejection&&Z(e);});}},X=function(e,t,n){var o,r;V?((o=U.createEvent("Event")).promise=t,o.reason=n,o.initEvent(e,!1,!0),c.dispatchEvent(o)):o={promise:t,reason:n},!G&&(r=c["on"+e])?r(o):"unhandledrejection"===e&&S("Unhandled promise rejection",n);},Z=function(e){E.call(c,function(){var t,n=e.facade,o=e.value;if(ee(e)&&(t=N(function(){B?j.emit("unhandledRejection",o,n):X("unhandledrejection",n,o);}),e.rejection=B||ee(e)?2:1,t.error)){ throw t.value }});},ee=function(e){return 1!==e.rejection&&!e.parent},te=function(e){E.call(c,function(){var t=e.facade;B?j.emit("rejectionHandled",t):X("rejectionhandled",t,e.value);});},ne=function(e,t,n){return function(o){e(t,o,n);}},oe=function(e,t,n){e.done||(e.done=!0,n&&(e=n),e.value=t,e.state=2,q(e,!0));},re=function(e,t,n){if(!e.done){e.done=!0,n&&(e=n);try{if(e.facade===t){ throw O("Promise can't be resolved itself"); }var o=W(t);o?b(function(){var n={done:!1};try{o.call(t,ne(re,n,e),ne(oe,n,e));}catch(t$1){oe(n,t$1,e);}}):(e.value=t,e.state=1,q(e,!1));}catch(t$1){oe({done:!1},t$1,e);}}};J&&(Q=function(e){g(this,Q,P),m(e),o.call(this);var t=H(this);try{e(ne(re,t),ne(oe,t));}catch(e$1){oe(t,e$1);}},(o=function(e){F(this,{type:P,done:!1,notified:!1,parent:!1,reactions:[],rejection:!1,state:0,value:void 0});}).prototype=p(Q.prototype,{then:function(e,t){var n=L(this),o=z(_(this,Q));return o.ok="function"!=typeof e||e,o.fail="function"==typeof t&&t,o.domain=B?j.domain:void 0,n.parent=!0,n.reactions.push(o),0!=n.state&&q(n,!1),o.promise},catch:function(e){return this.then(void 0,e)}}),r=function(){var e=new o,t=H(e);this.promise=e,this.resolve=ne(re,t),this.reject=ne(oe,t);},D.f=z=function(e){return e===Q||e===i?new r(e):$(e)},u||"function"!=typeof f||(a=f.prototype.then,d(f.prototype,"then",function(e,t){var n=this;return new Q(function(e,t){a.call(n,e,t);}).then(e,t)},{unsafe:!0}),"function"==typeof Y&&l({global:!0,enumerable:!0,forced:!0},{fetch:function(e){return C(Q,Y.apply(c,arguments))}}))),l({global:!0,wrap:!0,forced:J},{Promise:Q}),v(Q,P,!1,!0),h(P),i=s(P),l({target:P,stat:!0,forced:J},{reject:function(e){var t=z(this);return t.reject.call(void 0,e),t.promise}}),l({target:P,stat:!0,forced:u||J},{resolve:function(e){return C(u&&this===i?Q:this,e)}}),l({target:P,stat:!0,forced:K},{all:function(e){var t=this,n=z(t),o=n.resolve,r=n.reject,i=N(function(){var n=m(t.resolve),i=[],a=0,l=1;w(e,function(e){var u=a++,c=!1;i.push(void 0),l++,n.call(t,e).then(function(e){c||(c=!0,i[u]=e,--l||o(i));},r);}),--l||o(i);});return i.error&&r(i.value),n.promise},race:function(e){var t=this,n=z(t),o=n.reject,r=N(function(){var r=m(t.resolve);w(e,function(e){r.call(t,e).then(n.resolve,o);});});return r.error&&o(r.value),n.promise}});},function(e,t,n){var o=n(84),r=n(66);e.exports=o?{}.toString:function(){return "[object "+r(this)+"]"};},function(e,t,n){var o=n(9)("iterator"),r=!1;try{var i=0,a={next:function(){return {done:!!i++}},return:function(){r=!0;}};a[o]=function(){return this},Array.from(a,function(){throw 2});}catch(e$1){}e.exports=function(e,t){if(!t&&!r){ return !1; }var n=!1;try{var i={};i[o]=function(){return {next:function(){return {done:n=!0}}}},e(i);}catch(e$1){}return n};},function(e,t,n){var o,r,i,a,l,u,c,s,f=n(8),d=n(74).f,p=n(111).set,v=n(112),h=n(170),A=n(63),m=f.MutationObserver||f.WebKitMutationObserver,g=f.document,y=f.process,w=f.Promise,x=d(f,"queueMicrotask"),_=x&&x.value;_||(o=function(){var e,t;for(A&&(e=y.domain)&&e.exit();r;){t=r.fn,r=r.next;try{t();}catch(e$1){throw r?a():i=void 0,e$1}}i=void 0,e&&e.enter();},v||A||h||!m||!g?w&&w.resolve?(c=w.resolve(void 0),s=c.then,a=function(){s.call(c,o);}):a=A?function(){y.nextTick(o);}:function(){p.call(f,o);}:(l=!0,u=g.createTextNode(""),new m(o).observe(u,{characterData:!0}),a=function(){u.data=l=!l;})),e.exports=_||function(e){var t={fn:e,next:void 0};i&&(i.next=t),r||(r=t,a()),i=t;};},function(e,t,n){var o=n(65);e.exports=/web0s(?!.*chrome)/i.test(o);},function(e,t,n){var o=n(8);e.exports=function(e,t){var n=o.console;n&&n.error&&(1===arguments.length?n.error(e):n.error(e,t));};},function(e,t,n){var o=n(8),r=n(109),i=o.WeakMap;e.exports="function"==typeof i&&/native code/.test(r(i));},function(e,t,n){var o=n(5),r=n(32),i=n(68),a=n(86),l=n(39);o({target:"Promise",stat:!0},{allSettled:function(e){var t=this,n=i.f(t),o=n.resolve,u=n.reject,c=a(function(){var n=r(t.resolve),i=[],a=0,u=1;l(e,function(e){var r=a++,l=!1;i.push(void 0),u++,n.call(t,e).then(function(e){l||(l=!0,i[r]={status:"fulfilled",value:e},--u||o(i));},function(e){l||(l=!0,i[r]={status:"rejected",reason:e},--u||o(i));});}),--u||o(i);});return c.error&&u(c.value),n.promise}});},function(e,t,n){var o=n(5),r=n(32),i=n(28),a=n(68),l=n(86),u=n(39);o({target:"Promise",stat:!0},{any:function(e){var t=this,n=a.f(t),o=n.resolve,c=n.reject,s=l(function(){var n=r(t.resolve),a=[],l=0,s=1,f=!1;u(e,function(e){var r=l++,u=!1;a.push(void 0),s++,n.call(t,e).then(function(e){u||f||(f=!0,o(e));},function(e){u||f||(u=!0,a[r]=e,--s||c(new(i("AggregateError"))(a,"No one promise resolved")));});}),--s||c(new(i("AggregateError"))(a,"No one promise resolved"));});return s.error&&c(s.value),n.promise}});},function(e,t,n){var o=n(5),r=n(37),i=n(106),a=n(11),l=n(28),u=n(110),c=n(113),s=n(49);o({target:"Promise",proto:!0,real:!0,forced:!!i&&a(function(){i.prototype.finally.call({then:function(){}},function(){});})},{finally:function(e){var t=u(this,l("Promise")),n="function"==typeof e;return this.then(n?function(n){return c(t,e()).then(function(){return n})}:e,n?function(n){return c(t,e()).then(function(){throw n})}:e)}}),r||"function"!=typeof i||i.prototype.finally||s(i.prototype,"finally",l("Promise").prototype.finally);},function(e,t,n){var o=n(62),r=n(46),i=function(e){return function(t,n){var i,a,l=String(r(t)),u=o(n),c=l.length;return u<0||u>=c?e?"":void 0:(i=l.charCodeAt(u))<55296||i>56319||u+1===c||(a=l.charCodeAt(u+1))<56320||a>57343?e?l.charAt(u):i:e?l.slice(u,u+2):a-56320+(i-55296<<10)+65536}};e.exports={codeAt:i(!1),charAt:i(!0)};},function(e,t,n){var o=n(114).IteratorPrototype,r=n(60),i=n(35),a=n(41),l=n(40),u=function(){return this};e.exports=function(e,t,n){var c=t+" Iterator";return e.prototype=r(o,{next:i(1,n)}),a(e,c,!1,!0),l[c]=u,e};},function(e,t,n){var o=n(27),r=n(88),i=n(40),a=n(42),l=n(87),u=a.set,c=a.getterFor("Array Iterator");e.exports=l(Array,"Array",function(e,t){u(this,{type:"Array Iterator",target:o(e),index:0,kind:t});},function(){var e=c(this),t=e.target,n=e.kind,o=e.index++;return !t||o>=t.length?(e.target=void 0,{value:void 0,done:!0}):"keys"==n?{value:o,done:!1}:"values"==n?{value:t[o],done:!1}:{value:[o,t[o]],done:!1}},"values"),i.Arguments=i.Array,r("keys"),r("values"),r("entries");},function(e,t){e.exports={CSSRuleList:0,CSSStyleDeclaration:0,CSSValueList:0,ClientRectList:0,DOMRectList:0,DOMStringList:0,DOMTokenList:1,DataTransferItemList:0,FileList:0,HTMLAllCollection:0,HTMLCollection:0,HTMLFormElement:0,HTMLSelectElement:0,MediaList:0,MimeTypeArray:0,NamedNodeMap:0,NodeList:1,PaintRequestList:0,Plugin:0,PluginArray:0,SVGLengthList:0,SVGNumberList:0,SVGPathSegList:0,SVGPointList:0,SVGStringList:0,SVGTransformList:0,SourceBufferList:0,StyleSheetList:0,TextTrackCueList:0,TextTrackList:0,TouchList:0};},function(e,t,n){n(50);var o=n(181),r=n(66),i=Array.prototype,a={DOMTokenList:!0,NodeList:!0};e.exports=function(e){var t=e.forEach;return e===i||e instanceof Array&&t===i.forEach||a.hasOwnProperty(r(e))?o:t};},function(e,t,n){var o=n(182);e.exports=o;},function(e,t,n){n(183);var o=n(14);e.exports=o("Array").forEach;},function(e,t,n){var o=n(5),r=n(184);o({target:"Array",proto:!0,forced:[].forEach!=r},{forEach:r});},function(e,t,n){var o=n(29).forEach,r=n(70)("forEach");e.exports=r?[].forEach:function(e){return o(this,e,arguments.length>1?arguments[1]:void 0)};},function(e,t,n){var o=n(186);e.exports=o;},function(e,t,n){n(187);var o=n(12);e.exports=o.Array.isArray;},function(e,t,n){n(5)({target:"Array",stat:!0},{isArray:n(51)});},function(e,t,n){var o=n(189);e.exports=o;},function(e,t,n){var o=n(190),r=Array.prototype;e.exports=function(e){var t=e.map;return e===r||e instanceof Array&&t===r.map?o:t};},function(e,t,n){n(191);var o=n(14);e.exports=o("Array").map;},function(e,t,n){var o=n(5),r=n(29).map;o({target:"Array",proto:!0,forced:!n(52)("map")},{map:function(e){return r(this,e,arguments.length>1?arguments[1]:void 0)}});},function(e,t,n){var o=n(193);e.exports=o;},function(e,t,n){var o=n(194),r=String.prototype;e.exports=function(e){var t=e.trim;return "string"==typeof e||e===r||e instanceof String&&t===r.trim?o:t};},function(e,t,n){n(195);var o=n(14);e.exports=o("String").trim;},function(e,t,n){var o=n(5),r=n(91).trim;o({target:"String",proto:!0,forced:n(196)("trim")},{trim:function(){return r(this)}});},function(e,t,n){var o=n(11),r=n(71);e.exports=function(e){return o(function(){return !!r[e]()||"​᠎"!="​᠎"[e]()||r[e].name!==e})};},function(e,t,n){var o=n(198);e.exports=o;},function(e,t,n){n(199),n(67),n(69),n(50);var o=n(12);e.exports=o.Map;},function(e,t,n){var o=n(117),r=n(119);e.exports=o("Map",function(e){return function(){return e(this,arguments.length?arguments[0]:void 0)}},r);},function(e,t,n){var o=n(11);e.exports=!o(function(){return Object.isExtensible(Object.preventExtensions({}))});},function(e,t,n){var o=n(202);e.exports=o;},function(e,t,n){var o=n(203),r=Array.prototype;e.exports=function(e){var t=e.indexOf;return e===r||e instanceof Array&&t===r.indexOf?o:t};},function(e,t,n){n(204);var o=n(14);e.exports=o("Array").indexOf;},function(e,t,n){var o=n(5),r=n(80).indexOf,i=n(70),a=[].indexOf,l=!!a&&1/[1].indexOf(1,-0)<0,u=i("indexOf");o({target:"Array",proto:!0,forced:l||!u},{indexOf:function(e){return l?a.apply(this,arguments)||0:r(this,e,arguments.length>1?arguments[1]:void 0)}});},function(e,t,n){var o=n(206);e.exports=o;},function(e,t,n){var o=n(207),r=Array.prototype;e.exports=function(e){var t=e.splice;return e===r||e instanceof Array&&t===r.splice?o:t};},function(e,t,n){n(208);var o=n(14);e.exports=o("Array").splice;},function(e,t,n){var o=n(5),r=n(81),i=n(62),a=n(38),l=n(36),u=n(89),c=n(93),s=n(52)("splice"),f=Math.max,d=Math.min;o({target:"Array",proto:!0,forced:!s},{splice:function(e,t){
  var arguments$1 = arguments;
  var n,o,s,p,v,h,A=l(this),m=a(A.length),g=r(e,m),y=arguments.length;if(0===y?n=o=0:1===y?(n=0,o=m-g):(n=y-2,o=d(f(i(t),0),m-g)),m+n-o>9007199254740991){ throw TypeError("Maximum allowed length exceeded"); }for(s=u(A,o),p=0;p<o;p++){ (v=g+p)in A&&c(s,p,A[v]); }if(s.length=o,n<o){for(p=g;p<m-o;p++){ h=p+n,(v=p+o)in A?A[h]=A[v]:delete A[h]; }for(p=m;p>m-o+n;p--){ delete A[p-1]; }}else if(n>o){ for(p=m-o;p>g;p--){ h=p+n-1,(v=p+o-1)in A?A[h]=A[v]:delete A[h]; } }for(p=0;p<n;p++){ A[p+g]=arguments$1[p+2]; }return A.length=m-o+n,s}});},function(e,t,n){var o=n(210);e.exports=o;},function(e,t,n){var o=n(211),r=Array.prototype;e.exports=function(e){var t=e.filter;return e===r||e instanceof Array&&t===r.filter?o:t};},function(e,t,n){n(212);var o=n(14);e.exports=o("Array").filter;},function(e,t,n){var o=n(5),r=n(29).filter;o({target:"Array",proto:!0,forced:!n(52)("filter")},{filter:function(e){return r(this,e,arguments.length>1?arguments[1]:void 0)}});},function(e,t,n){var o=n(214);e.exports=o;},function(e,t,n){var o=n(215),r=n(217),i=Array.prototype,a=String.prototype;e.exports=function(e){var t=e.includes;return e===i||e instanceof Array&&t===i.includes?o:"string"==typeof e||e===a||e instanceof String&&t===a.includes?r:t};},function(e,t,n){n(216);var o=n(14);e.exports=o("Array").includes;},function(e,t,n){var o=n(5),r=n(80).includes,i=n(88);o({target:"Array",proto:!0},{includes:function(e){return r(this,e,arguments.length>1?arguments[1]:void 0)}}),i("includes");},function(e,t,n){n(218);var o=n(14);e.exports=o("String").includes;},function(e,t,n){var o=n(5),r=n(219),i=n(46);o({target:"String",proto:!0,forced:!n(221)("includes")},{includes:function(e){return !!~String(i(this)).indexOf(r(e),arguments.length>1?arguments[1]:void 0)}});},function(e,t,n){var o=n(220);e.exports=function(e){if(o(e)){ throw TypeError("The method doesn't accept regular expressions"); }return e};},function(e,t,n){var o=n(13),r=n(45),i=n(9)("match");e.exports=function(e){var t;return o(e)&&(void 0!==(t=e[i])?!!t:"RegExp"==r(e))};},function(e,t,n){var o=n(9)("match");e.exports=function(e){var t=/./;try{"/./"[e](t);}catch(n){try{return t[o]=!1,"/./"[e](t)}catch(e$1){}}return !1};},function(e,t,n){var o=n(223);e.exports=o;},function(e,t,n){var o=n(224),r=Function.prototype;e.exports=function(e){var t=e.bind;return e===r||e instanceof Function&&t===r.bind?o:t};},function(e,t,n){n(225);var o=n(14);e.exports=o("Function").bind;},function(e,t,n){n(5)({target:"Function",proto:!0},{bind:n(226)});},function(e,t,n){var o=n(32),r=n(13),i=[].slice,a={};e.exports=Function.bind||function(e){var t=o(this),n=i.call(arguments,1),l=function(){var o=n.concat(i.call(arguments));return this instanceof l?function(e,t,n){if(!(t in a)){for(var o=[],r=0;r<t;r++){ o[r]="a["+r+"]"; }a[t]=Function("C,a","return new C("+o.join(",")+")");}return a[t](e,n)}(t,o.length,o):t.apply(e,o)};return r(t.prototype)&&(l.prototype=t.prototype),l};},function(e,t,n){e.exports=n(228);},function(e,t,n){var o=n(229);n(249),n(250),n(251),n(252),n(253),e.exports=o;},function(e,t,n){n(230),n(67),n(231),n(233),n(234),n(235),n(236),n(122),n(237),n(238),n(239),n(240),n(241),n(242),n(243),n(244),n(245),n(246),n(247),n(248);var o=n(12);e.exports=o.Symbol;},function(e,t,n){var o=n(5),r=n(11),i=n(51),a=n(13),l=n(36),u=n(38),c=n(93),s=n(89),f=n(52),d=n(9),p=n(64),v=d("isConcatSpreadable"),h=p>=51||!r(function(){var e=[];return e[v]=!1,e.concat()[0]!==e}),A=f("concat"),m=function(e){if(!a(e)){ return !1; }var t=e[v];return void 0!==t?!!t:i(e)};o({target:"Array",proto:!0,forced:!h||!A},{concat:function(e){
  var arguments$1 = arguments;
  var t,n,o,r,i,a=l(this),f=s(a,0),d=0;for(t=-1,o=arguments.length;t<o;t++){ if(i=-1===t?a:arguments$1[t],m(i)){if(d+(r=u(i.length))>9007199254740991){ throw TypeError("Maximum allowed index exceeded"); }for(n=0;n<r;n++,d++){ n in i&&c(f,d,i[n]); }}else {if(d>=9007199254740991){ throw TypeError("Maximum allowed index exceeded"); }c(f,d++,i);} }return f.length=d,f}});},function(e,t,n){var o=n(5),r=n(8),i=n(28),a=n(37),l=n(15),u=n(83),c=n(105),s=n(11),f=n(16),d=n(51),p=n(13),v=n(24),h=n(36),A=n(27),m=n(57),g=n(35),y=n(60),w=n(61),x=n(120),_=n(232),E=n(121),b=n(74),C=n(18),S=n(56),D=n(17),N=n(49),M=n(78),k=n(58),T=n(48),B=n(59),I=n(9),R=n(95),P=n(10),H=n(41),F=n(42),L=n(29).forEach,Q=k("hidden"),O=I("toPrimitive"),U=F.set,j=F.getterFor("Symbol"),Y=Object.prototype,z=r.Symbol,$=i("JSON","stringify"),V=b.f,G=C.f,J=_.f,K=S.f,W=M("symbols"),q=M("op-symbols"),X=M("string-to-symbol-registry"),Z=M("symbol-to-string-registry"),ee=M("wks"),te=r.QObject,ne=!te||!te.prototype||!te.prototype.findChild,oe=l&&s(function(){return 7!=y(G({},"a",{get:function(){return G(this,"a",{value:7}).a}})).a})?function(e,t,n){var o=V(Y,t);o&&delete Y[t],G(e,t,n),o&&e!==Y&&G(Y,t,o);}:G,re=function(e,t){var n=W[e]=y(z.prototype);return U(n,{type:"Symbol",tag:e,description:t}),l||(n.description=t),n},ie=c?function(e){return "symbol"==typeof e}:function(e){return Object(e)instanceof z},ae=function(e,t,n){e===Y&&ae(q,t,n),v(e);var o=m(t,!0);return v(n),f(W,o)?(n.enumerable?(f(e,Q)&&e[Q][o]&&(e[Q][o]=!1),n=y(n,{enumerable:g(0,!1)})):(f(e,Q)||G(e,Q,g(1,{})),e[Q][o]=!0),oe(e,o,n)):G(e,o,n)},le=function(e,t){v(e);var n=A(t),o=w(n).concat(fe(n));return L(o,function(t){l&&!ue.call(n,t)||ae(e,t,n[t]);}),e},ue=function(e){var t=m(e,!0),n=K.call(this,t);return !(this===Y&&f(W,t)&&!f(q,t))&&(!(n||!f(this,t)||!f(W,t)||f(this,Q)&&this[Q][t])||n)},ce=function(e,t){var n=A(e),o=m(t,!0);if(n!==Y||!f(W,o)||f(q,o)){var r=V(n,o);return !r||!f(W,o)||f(n,Q)&&n[Q][o]||(r.enumerable=!0),r}},se=function(e){var t=J(A(e)),n=[];return L(t,function(e){f(W,e)||f(T,e)||n.push(e);}),n},fe=function(e){var t=e===Y,n=J(t?q:A(e)),o=[];return L(n,function(e){!f(W,e)||t&&!f(Y,e)||o.push(W[e]);}),o};(u||(N((z=function(){if(this instanceof z){ throw TypeError("Symbol is not a constructor"); }var e=arguments.length&&void 0!==arguments[0]?String(arguments[0]):void 0,t=B(e),n=function(e){this===Y&&n.call(q,e),f(this,Q)&&f(this[Q],t)&&(this[Q][t]=!1),oe(this,t,g(1,e));};return l&&ne&&oe(Y,t,{configurable:!0,set:n}),re(t,e)}).prototype,"toString",function(){return j(this).tag}),N(z,"withoutSetter",function(e){return re(B(e),e)}),S.f=ue,C.f=ae,b.f=ce,x.f=_.f=se,E.f=fe,R.f=function(e){return re(I(e),e)},l&&(G(z.prototype,"description",{configurable:!0,get:function(){return j(this).description}}),a||N(Y,"propertyIsEnumerable",ue,{unsafe:!0}))),o({global:!0,wrap:!0,forced:!u,sham:!u},{Symbol:z}),L(w(ee),function(e){P(e);}),o({target:"Symbol",stat:!0,forced:!u},{for:function(e){var t=String(e);if(f(X,t)){ return X[t]; }var n=z(t);return X[t]=n,Z[n]=t,n},keyFor:function(e){if(!ie(e)){ throw TypeError(e+" is not a symbol"); }if(f(Z,e)){ return Z[e] }},useSetter:function(){ne=!0;},useSimple:function(){ne=!1;}}),o({target:"Object",stat:!0,forced:!u,sham:!l},{create:function(e,t){return void 0===t?y(e):le(y(e),t)},defineProperty:ae,defineProperties:le,getOwnPropertyDescriptor:ce}),o({target:"Object",stat:!0,forced:!u},{getOwnPropertyNames:se,getOwnPropertySymbols:fe}),o({target:"Object",stat:!0,forced:s(function(){E.f(1);})},{getOwnPropertySymbols:function(e){return E.f(h(e))}}),$)&&o({target:"JSON",stat:!0,forced:!u||s(function(){var e=z();return "[null]"!=$([e])||"{}"!=$({a:e})||"{}"!=$(Object(e))})},{stringify:function(e,t,n){
  var arguments$1 = arguments;
  for(var o,r=[e],i=1;arguments.length>i;){ r.push(arguments$1[i++]); }if(o=t,(p(t)||void 0!==e)&&!ie(e)){ return d(t)||(t=function(e,t){if("function"==typeof o&&(t=o.call(this,e,t)),!ie(t)){ return t }}),r[1]=t,$.apply(null,r) }}});z.prototype[O]||D(z.prototype,O,z.prototype.valueOf),H(z,"Symbol"),T[Q]=!0;},function(e,t,n){var o=n(27),r=n(120).f,i={}.toString,a="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[];e.exports.f=function(e){return a&&"[object Window]"==i.call(e)?function(e){try{return r(e)}catch(e$1){return a.slice()}}(e):r(o(e))};},function(e,t,n){n(10)("asyncIterator");},function(e,t){},function(e,t,n){n(10)("hasInstance");},function(e,t,n){n(10)("isConcatSpreadable");},function(e,t,n){n(10)("match");},function(e,t,n){n(10)("matchAll");},function(e,t,n){n(10)("replace");},function(e,t,n){n(10)("search");},function(e,t,n){n(10)("species");},function(e,t,n){n(10)("split");},function(e,t,n){n(10)("toPrimitive");},function(e,t,n){n(10)("toStringTag");},function(e,t,n){n(10)("unscopables");},function(e,t,n){var o=n(8);n(41)(o.JSON,"JSON",!0);},function(e,t){},function(e,t){},function(e,t,n){n(10)("asyncDispose");},function(e,t,n){n(10)("dispose");},function(e,t,n){n(10)("observable");},function(e,t,n){n(10)("patternMatch");},function(e,t,n){n(10)("replaceAll");},function(e,t,n){e.exports=n(255);},function(e,t,n){var o=n(256);e.exports=o;},function(e,t,n){n(122),n(69),n(50);var o=n(95);e.exports=o.f("iterator");},function(e,t,n){e.exports=n(258);},function(e,t,n){var o=n(259);e.exports=o;},function(e,t,n){n(260);var o=n(12);e.exports=o.parseInt;},function(e,t,n){var o=n(5),r=n(261);o({global:!0,forced:parseInt!=r},{parseInt:r});},function(e,t,n){var o=n(8),r=n(91).trim,i=n(71),a=o.parseInt,l=/^[+-]?0[Xx]/,u=8!==a(i+"08")||22!==a(i+"0x16");e.exports=u?function(e,t){var n=r(String(e));return a(n,t>>>0||(l.test(n)?16:10))}:a;},function(e,t,n){var o=n(263);e.exports=o;},function(e,t,n){var o=n(264),r=Array.prototype;e.exports=function(e){var t=e.slice;return e===r||e instanceof Array&&t===r.slice?o:t};},function(e,t,n){n(265);var o=n(14);e.exports=o("Array").slice;},function(e,t,n){var o=n(5),r=n(13),i=n(51),a=n(81),l=n(38),u=n(27),c=n(93),s=n(9),f=n(52)("slice"),d=s("species"),p=[].slice,v=Math.max;o({target:"Array",proto:!0,forced:!f},{slice:function(e,t){var n,o,s,f=u(this),h=l(f.length),A=a(e,h),m=a(void 0===t?h:t,h);if(i(f)&&("function"!=typeof(n=f.constructor)||n!==Array&&!i(n.prototype)?r(n)&&null===(n=n[d])&&(n=void 0):n=void 0,n===Array||void 0===n)){ return p.call(f,A,m); }for(o=new(void 0===n?Array:n)(v(m-A,0)),s=0;A<m;A++,s++){ A in f&&c(o,s,f[A]); }return o.length=s,o}});},function(e,t,n){n(267);var o=n(12);e.exports=o.setTimeout;},function(e,t,n){var o=n(5),r=n(8),i=n(65),a=[].slice,l=function(e){return function(t,n){var o=arguments.length>2,r=o?a.call(arguments,2):void 0;return e(o?function(){("function"==typeof t?t:Function(t)).apply(this,r);}:t,n)}};o({global:!0,bind:!0,forced:/MSIE .\./.test(i)},{setTimeout:l(r.setTimeout),setInterval:l(r.setInterval)});},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(269));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=a.__importDefault(n(274)),u=a.__importDefault(n(275)),c=a.__importDefault(n(123)),s=a.__importDefault(n(276)),f=a.__importDefault(n(277)),d=a.__importDefault(n(278)),p=a.__importDefault(n(279)),v=a.__importDefault(n(280)),h=a.__importDefault(n(281)),A=a.__importDefault(n(282)),m=(0, i.default)({},l.default,u.default,c.default,f.default,s.default,d.default,p.default,v.default,h.default,A.default,{linkCheck:function(e,t){return !0}});t.default=m;},function(e,t,n){e.exports=n(270);},function(e,t,n){var o=n(271);e.exports=o;},function(e,t,n){n(272);var o=n(12);e.exports=o.Object.assign;},function(e,t,n){var o=n(5),r=n(273);o({target:"Object",stat:!0,forced:Object.assign!==r},{assign:r});},function(e,t,n){var o=n(15),r=n(11),i=n(61),a=n(121),l=n(56),u=n(36),c=n(75),s=Object.assign,f=Object.defineProperty;e.exports=!s||r(function(){if(o&&1!==s({b:1},s(f({},"a",{enumerable:!0,get:function(){f(this,"b",{value:3,enumerable:!1});}}),{b:2})).b){ return !0; }var e={},t={},n=Symbol();return e[n]=7,"abcdefghijklmnopqrst".split("").forEach(function(e){t[e]=e;}),7!=s({},e)[n]||"abcdefghijklmnopqrst"!=i(s({},t)).join("")})?function(e,t){for(var n=u(e),r=arguments.length,s=1,f=a.f,d=l.f;r>s;){ for(var p,v=c(arguments[s++]),h=f?i(v).concat(f(v)):i(v),A=h.length,m=0;A>m;){ p=h[m++],o&&!d.call(v,p)||(n[p]=v[p]); } }return n}:s;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default={menus:["head","bold","fontSize","fontName","italic","underline","strikeThrough","indent","lineHeight","foreColor","backColor","link","list","todo","justify","quote","emoticon","image","video","table","code","splitLine","undo","redo"],fontNames:["黑体","仿宋","楷体","标楷体","华文仿宋","华文楷体","宋体","微软雅黑","Arial","Tahoma","Verdana","Times New Roman","Courier New"],fontSizes:{"x-small":{name:"10px",value:"1"},small:{name:"13px",value:"2"},normal:{name:"16px",value:"3"},large:{name:"18px",value:"4"},"x-large":{name:"24px",value:"5"},"xx-large":{name:"32px",value:"6"},"xxx-large":{name:"48px",value:"7"}},colors:["#000000","#ffffff","#eeece0","#1c487f","#4d80bf","#c24f4a","#8baa4a","#7b5ba1","#46acc8","#f9963b"],languageType:["Bash","C","C#","C++","CSS","Java","JavaScript","JSON","TypeScript","Plain text","Html","XML","SQL","Go","Kotlin","Lua","Markdown","PHP","Python","Shell Session","Ruby"],languageTab:"　　　　",emotions:[{title:"表情",type:"emoji",content:"😀 😃 😄 😁 😆 😅 😂 🤣 😊 😇 🙂 🙃 😉 😌 😍 😘 😗 😙 😚 😋 😛 😝 😜 🤓 😎 😏 😒 😞 😔 😟 😕 🙁 😣 😖 😫 😩 😢 😭 😤 😠 😡 😳 😱 😨 🤗 🤔 😶 😑 😬 🙄 😯 😴 😷 🤑 😈 🤡 💩 👻 💀 👀 👣".split(/\s/)},{title:"手势",type:"emoji",content:"👐 🙌 👏 🤝 👍 👎 👊 ✊ 🤛 🤜 🤞 ✌️ 🤘 👌 👈 👉 👆 👇 ☝️ ✋ 🤚 🖐 🖖 👋 🤙 💪 🖕 ✍️ 🙏".split(/\s/)}],lineHeights:["1","1.15","1.6","2","2.5","3"],undoLimit:20,indentation:"2em",showMenuTooltips:!0,menuTooltipPosition:"up"};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(7);t.default={onchangeTimeout:200,onchange:null,onfocus:o.EMPTY_FN,onblur:o.EMPTY_FN,onCatalogChange:null,customAlert:function(e,t,n){window.alert(e),n&&console.error("wangEditor: "+n);}};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default={pasteFilterStyle:!0,pasteIgnoreImg:!1,pasteTextHandle:function(e){return e}};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default={styleWithCSS:!1};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(7);t.default={linkImgCheck:function(e,t,n){return !0},showLinkImg:!0,showLinkImgAlt:!0,showLinkImgHref:!0,linkImgCallback:o.EMPTY_FN,uploadImgAccept:["jpg","jpeg","png","gif","bmp"],uploadImgServer:"",uploadImgShowBase64:!1,uploadImgMaxSize:5242880,uploadImgMaxLength:100,uploadFileName:"",uploadImgParams:{},uploadImgParamsWithUrl:!1,uploadImgHeaders:{},uploadImgHooks:{},uploadImgTimeout:1e4,withCredentials:!1,customUploadImg:null};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default={focus:!0,height:300,placeholder:"请输入正文",zIndexFullScreen:10002,showFullScreen:!0};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default={lang:"zh-CN",languages:{"zh-CN":{wangEditor:{"重置":"重置","插入":"插入","默认":"默认","创建":"创建","修改":"修改","如":"如","请输入正文":"请输入正文",menus:{title:{"标题":"标题","加粗":"加粗","字号":"字号","字体":"字体","斜体":"斜体","下划线":"下划线","删除线":"删除线","缩进":"缩进","行高":"行高","文字颜色":"文字颜色","背景色":"背景色","链接":"链接","序列":"序列","对齐":"对齐","引用":"引用","表情":"表情","图片":"图片","视频":"视频","表格":"表格","代码":"代码","分割线":"分割线","恢复":"恢复","撤销":"撤销","全屏":"全屏","取消全屏":"取消全屏","待办事项":"待办事项"},dropListMenu:{"设置标题":"设置标题","背景颜色":"背景颜色","文字颜色":"文字颜色","设置字号":"设置字号","设置字体":"设置字体","设置缩进":"设置缩进","对齐方式":"对齐方式","设置行高":"设置行高","序列":"序列",head:{"正文":"正文"},indent:{"增加缩进":"增加缩进","减少缩进":"减少缩进"},justify:{"靠左":"靠左","居中":"居中","靠右":"靠右","两端":"两端"},list:{"无序列表":"无序列表","有序列表":"有序列表"}},panelMenus:{emoticon:{"默认":"默认","新浪":"新浪",emoji:"emoji","手势":"手势"},image:{"上传图片":"上传图片","网络图片":"网络图片","图片地址":"图片地址","图片文字说明":"图片文字说明","跳转链接":"跳转链接"},link:{"链接":"链接","链接文字":"链接文字","取消链接":"取消链接","查看链接":"查看链接"},video:{"插入视频":"插入视频","上传视频":"上传视频"},table:{"行":"行","列":"列","的":"的","表格":"表格","添加行":"添加行","删除行":"删除行","添加列":"添加列","删除列":"删除列","设置表头":"设置表头","取消表头":"取消表头","插入表格":"插入表格","删除表格":"删除表格"},code:{"删除代码":"删除代码","修改代码":"修改代码","插入代码":"插入代码"}}},validate:{"张图片":"张图片","大于":"大于","图片链接":"图片链接","不是图片":"不是图片","返回结果":"返回结果","上传图片超时":"上传图片超时","上传图片错误":"上传图片错误","上传图片失败":"上传图片失败","插入图片错误":"插入图片错误","一次最多上传":"一次最多上传","下载链接失败":"下载链接失败","图片验证未通过":"图片验证未通过","服务器返回状态":"服务器返回状态","上传图片返回结果错误":"上传图片返回结果错误","请替换为支持的图片类型":"请替换为支持的图片类型","您插入的网络图片无法识别":"您插入的网络图片无法识别","您刚才插入的图片链接未通过编辑器校验":"您刚才插入的图片链接未通过编辑器校验","插入视频错误":"插入视频错误","视频链接":"视频链接","不是视频":"不是视频","视频验证未通过":"视频验证未通过","个视频":"个视频","上传视频超时":"上传视频超时","上传视频错误":"上传视频错误","上传视频失败":"上传视频失败","上传视频返回结果错误":"上传视频返回结果错误"}}},en:{wangEditor:{"重置":"reset","插入":"insert","默认":"default","创建":"create","修改":"edit","如":"like","请输入正文":"please enter the text",menus:{title:{"标题":"head","加粗":"bold","字号":"font size","字体":"font family","斜体":"italic","下划线":"underline","删除线":"strikethrough","缩进":"indent","行高":"line heihgt","文字颜色":"font color","背景色":"background","链接":"link","序列":"numbered list","对齐":"align","引用":"quote","表情":"emoticons","图片":"image","视频":"media","表格":"table","代码":"code","分割线":"split line","恢复":"undo","撤销":"redo","全屏":"fullscreen","取消全屏":"cancel fullscreen","待办事项":"todo"},dropListMenu:{"设置标题":"title","背景颜色":"background","文字颜色":"font color","设置字号":"font size","设置字体":"font family","设置缩进":"indent","对齐方式":"align","设置行高":"line heihgt","序列":"list",head:{"正文":"text"},indent:{"增加缩进":"indent","减少缩进":"outdent"},justify:{"靠左":"left","居中":"center","靠右":"right","两端":"justify"},list:{"无序列表":"unordered","有序列表":"ordered"}},panelMenus:{emoticon:{"表情":"emoji","手势":"gesture"},image:{"上传图片":"upload image","网络图片":"network image","图片地址":"image link","图片文字说明":"image alt","跳转链接":"hyperlink"},link:{"链接":"link","链接文字":"link text","取消链接":"unlink","查看链接":"view links"},video:{"插入视频":"insert video","上传视频":"upload local video"},table:{"行":"rows","列":"columns","的":" ","表格":"table","添加行":"insert row","删除行":"delete row","添加列":"insert column","删除列":"delete column","设置表头":"set header","取消表头":"cancel header","插入表格":"insert table","删除表格":"delete table"},code:{"删除代码":"delete code","修改代码":"edit code","插入代码":"insert code"}}},validate:{"张图片":"images","大于":"greater than","图片链接":"image link","不是图片":"is not image","返回结果":"return results","上传图片超时":"upload image timeout","上传图片错误":"upload image error","上传图片失败":"upload image failed","插入图片错误":"insert image error","一次最多上传":"once most at upload","下载链接失败":"download link failed","图片验证未通过":"image validate failed","服务器返回状态":"server return status","上传图片返回结果错误":"upload image return results error","请替换为支持的图片类型":"please replace with a supported image type","您插入的网络图片无法识别":"the network picture you inserted is not recognized","您刚才插入的图片链接未通过编辑器校验":"the image link you just inserted did not pass the editor verification","插入视频错误":"insert video error","视频链接":"video link","不是视频":"is not video","视频验证未通过":"video validate failed","个视频":"videos","上传视频超时":"upload video timeout","上传视频错误":"upload video error","上传视频失败":"upload video failed","上传视频返回结果错误":"upload video return results error"}}}}};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(6);t.default={compatibleMode:function(){return !(!o.UA.isIE()&&!o.UA.isOldEdge)},historyMaxSize:30};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(7);t.default={onlineVideoCheck:function(e){return !0},onlineVideoCallback:o.EMPTY_FN,showLinkVideo:!0,uploadVideoAccept:["mp4"],uploadVideoServer:"",uploadVideoMaxSize:1073741824,uploadVideoName:"",uploadVideoParams:{},uploadVideoParamsWithUrl:!1,uploadVideoHeaders:{},uploadVideoHooks:{},uploadVideoTimeout:72e5,withVideoCredentials:!1,customUploadVideo:null,customInsertVideo:null};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(19));(0, r.default)(t,"__esModule",{value:!0});var a=n(2).__importDefault(n(3)),l=n(6),u=n(7),c=function(){function e(e){this._currentRange=null,this.editor=e;}return e.prototype.getRange=function(){return this._currentRange},e.prototype.saveRange=function(e){if(e){ this._currentRange=e; }else {var t=window.getSelection();if(0!==t.rangeCount){var n=t.getRangeAt(0),o=this.getSelectionContainerElem(n);if((null==o?void 0:o.length)&&"false"!==o.attr("contenteditable")&&!o.parentUntil("[contenteditable=false]")){var r=this.editor,a=r.$textElem;if(a.isContain(o)){var l;if(a.elems[0]===o.elems[0]){ if((0, i.default)(l=a.html()).call(l)===u.EMPTY_P){var c=a.children(),s=null==c?void 0:c.last();r.selection.createRangeByElem(s,!0,!0),r.selection.restoreSelection();} }this._currentRange=n;}}}}},e.prototype.collapseRange=function(e){void 0===e&&(e=!1);var t=this._currentRange;t&&t.collapse(e);},e.prototype.getSelectionText=function(){var e=this._currentRange;return e?e.toString():""},e.prototype.getSelectionContainerElem=function(e){var t,n;if(t=e||this._currentRange){ return n=t.commonAncestorContainer,a.default(1===n.nodeType?n:n.parentNode) }},e.prototype.getSelectionStartElem=function(e){var t,n;if(t=e||this._currentRange){ return n=t.startContainer,a.default(1===n.nodeType?n:n.parentNode) }},e.prototype.getSelectionEndElem=function(e){var t,n;if(t=e||this._currentRange){ return n=t.endContainer,a.default(1===n.nodeType?n:n.parentNode) }},e.prototype.isSelectionEmpty=function(){var e=this._currentRange;return !(!e||!e.startContainer||e.startContainer!==e.endContainer||e.startOffset!==e.endOffset)},e.prototype.restoreSelection=function(){var e=window.getSelection(),t=this._currentRange;e&&t&&(e.removeAllRanges(),e.addRange(t));},e.prototype.createEmptyRange=function(){var e,t=this.editor,n=this.getRange();if(n&&this.isSelectionEmpty()){ try{l.UA.isWebkit()?(t.cmd.do("insertHTML","&#8203;"),n.setEnd(n.endContainer,n.endOffset+1),this.saveRange(n)):(e=a.default("<strong>&#8203;</strong>"),t.cmd.do("insertElem",e),this.createRangeByElem(e,!0));}catch(e$1){} }},e.prototype.createRangeByElems=function(e,t){var n=window.getSelection?window.getSelection():document.getSelection();null==n||n.removeAllRanges();var o=document.createRange();o.setStart(e,0),o.setEnd(t,t.childNodes.length||1),this.saveRange(o),this.restoreSelection();},e.prototype.createRangeByElem=function(e,t,n){if(e.length){var o=e.elems[0],r=document.createRange();n?r.selectNodeContents(o):r.selectNode(o),null!=t&&(r.collapse(t),t||(this.saveRange(r),this.editor.selection.moveCursor(o))),this.saveRange(r);}},e.prototype.getSelectionRangeTopNodes=function(){var e,t,n=null===(e=this.getSelectionStartElem())||void 0===e?void 0:e.getNodeTop(this.editor),o=null===(t=this.getSelectionEndElem())||void 0===t?void 0:t.getNodeTop(this.editor);return this.recordSelectionNodes(a.default(n),a.default(o))},e.prototype.moveCursor=function(e,t){var n,o=this.getRange(),r=3===e.nodeType?null===(n=e.nodeValue)||void 0===n?void 0:n.length:e.childNodes.length;(l.UA.isFirefox||l.UA.isIE())&&0!==r&&(3!==e.nodeType&&"BR"!==e.childNodes[r-1].nodeName||(r-=1));var i=null!=t?t:r;o&&e&&(o.setStart(e,i),o.setEnd(e,i),this.restoreSelection());},e.prototype.getCursorPos=function(){var e=window.getSelection();return null==e?void 0:e.anchorOffset},e.prototype.clearWindowSelectionRange=function(){var e=window.getSelection();e&&e.removeAllRanges();},e.prototype.recordSelectionNodes=function(e,t){for(var n=[],o=e,r=this.editor.$textElem,i=!0;i;){var l=null==o?void 0:o.getNodeTop(this.editor);"BODY"===l.getNodeName()&&(i=!1),l.length>0&&(n.push(a.default(o)),(null==t?void 0:t.equal(l))||r.equal(l)?i=!1:o=l.getNextSibling());}return n},e.prototype.setRangeToContainerElem=function(e){var t=this.getRange();null==t||t.setStart(e,0),null==t||t.setEnd(e,0);},e}();t.default=c;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2).__importDefault(n(3)),r=function(){function e(e){this.editor=e;}return e.prototype.do=function(e,t){var n=this.editor;n.config.styleWithCSS&&document.execCommand("styleWithCSS",!1,"true");var o=n.selection;if(o.getRange()){switch(o.restoreSelection(),e){case"insertHTML":this.insertHTML(t);break;case"insertElem":this.insertElem(t);break;default:this.execCommand(e,t);}n.menus.changeActive(),o.saveRange(),o.restoreSelection();}},e.prototype.insertHTML=function(e){var t=this.editor,n=t.selection.getRange();if(null!=n){ if(this.queryCommandSupported("insertHTML")){ this.execCommand("insertHTML",e); }else if(n.insertNode){if(n.deleteContents(),o.default(e).elems.length>0){ n.insertNode(o.default(e).elems[0]); }else {var r=document.createElement("p");r.appendChild(document.createTextNode(e)),n.insertNode(r);}t.selection.collapseRange();} }},e.prototype.insertElem=function(e){var t=this.editor.selection.getRange();null!=t&&t.insertNode&&(t.deleteContents(),t.insertNode(e.elems[0]));},e.prototype.execCommand=function(e,t){document.execCommand(e,!1,t);},e.prototype.queryCommandValue=function(e){return document.queryCommandValue(e)},e.prototype.queryCommandState=function(e){return document.queryCommandState(e)},e.prototype.queryCommandSupported=function(e){return document.queryCommandSupported(e)},e}();t.default=r;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(30)),a=o(n(4)),l=o(n(19)),u=o(n(26));(0, r.default)(t,"__esModule",{value:!0});var c=n(2),s=c.__importDefault(n(3)),f=c.__importDefault(n(290)),d=n(6),p=c.__importDefault(n(302)),v=c.__importDefault(n(303)),h=n(7),A=function(){function e(e){this.editor=e,this.eventHooks={onBlurEvents:[],changeEvents:[],dropEvents:[],clickEvents:[],keydownEvents:[],keyupEvents:[],tabUpEvents:[],tabDownEvents:[],enterUpEvents:[],enterDownEvents:[],deleteUpEvents:[],deleteDownEvents:[],pasteEvents:[],linkClickEvents:[],codeClickEvents:[],textScrollEvents:[],toolbarClickEvents:[],imgClickEvents:[],imgDragBarMouseDownEvents:[],tableClickEvents:[],menuClickEvents:[],dropListMenuHoverEvents:[],splitLineEvents:[],videoClickEvents:[]};}return e.prototype.init=function(){this._saveRange(),this._bindEventHooks(),f.default(this);},e.prototype.togglePlaceholder=function(){var e,t=this.html(),n=(0, i.default)(e=this.editor.$textContainerElem).call(e,".placeholder");n.hide(),t&&" "!==t||n.show();},e.prototype.clear=function(){this.html(h.EMPTY_P);},e.prototype.html=function(e){var t=this.editor,n=t.$textElem;if(null==e){var o=n.html(),r=(o=(o=(o=(o=o.replace(/\u200b/gm,"")).replace(/<p><\/p>/gim,"")).replace(h.EMPTY_P_LAST_REGEX,"")).replace(h.EMPTY_P_REGEX,"<p>")).match(/<(img|br|hr|input)[^>]*>/gi);return null!==r&&(0, a.default)(r).call(r,function(e){e.match(/\/>/)||(o=o.replace(e,e.substring(0,e.length-1)+"/>"));}),o}""===(e=(0, l.default)(e).call(e))&&(e=h.EMPTY_P),0!==(0, u.default)(e).call(e,"<")&&(e="<p>"+e+"</p>"),e=e.replace(/\s+</g,"<"),n.html(e),t.initSelection();},e.prototype.setJSON=function(e){var t=v.default(e).children(),n=this.editor.$textElem;t&&n.replaceChildAll(t);},e.prototype.getJSON=function(){var e=this.editor.$textElem;return p.default(e)},e.prototype.text=function(e){var t=this.editor,n=t.$textElem;if(null==e){var o=n.text();return o=o.replace(/\u200b/gm,"")}n.text("<p>"+e+"</p>"),t.initSelection();},e.prototype.append=function(e){var t=this.editor;0!==(0, u.default)(e).call(e,"<")&&(e="<p>"+e+"</p>"),this.html(this.html()+e),t.initSelection();},e.prototype._saveRange=function(){var e=this.editor,t=e.$textElem,n=s.default(document);function o(){e.selection.saveRange(),e.menus.changeActive();}function r(){o(),n.off("mouseup",r);}function i(){n.on("mouseup",r),t.off("mouseleave",i);}t.on("keyup",o),t.on("click",function e(){o(),t.off("click",e);}),t.on("mousedown",function(){t.on("mouseleave",i);}),t.on("mouseup",function(n){t.off("mouseleave",i),null!==e.selection.getRange()&&o();});},e.prototype._bindEventHooks=function(){var e=this.editor,t=e.$textElem,n=this.eventHooks;function o(e){e.preventDefault();}t.on("click",function(e){var t=n.clickEvents;(0, a.default)(t).call(t,function(t){return t(e)});}),t.on("keyup",function(e){if(13===e.keyCode){var t=n.enterUpEvents;(0, a.default)(t).call(t,function(t){return t(e)});}}),t.on("keyup",function(e){var t=n.keyupEvents;(0, a.default)(t).call(t,function(t){return t(e)});}),t.on("keydown",function(e){var t=n.keydownEvents;(0, a.default)(t).call(t,function(t){return t(e)});}),t.on("keyup",function(e){if(8===e.keyCode){var t=n.deleteUpEvents;(0, a.default)(t).call(t,function(t){return t(e)});}}),t.on("keydown",function(e){if(8===e.keyCode){var t=n.deleteDownEvents;(0, a.default)(t).call(t,function(t){return t(e)});}}),t.on("paste",function(e){if(!d.UA.isIE()){e.preventDefault();var t=n.pasteEvents;(0, a.default)(t).call(t,function(t){return t(e)});}}),t.on("keydown",function(t){(e.isFocus||e.isCompatibleMode)&&(t.ctrlKey||t.metaKey)&&90===t.keyCode&&(t.preventDefault(),t.shiftKey?e.history.restore():e.history.revoke());}),t.on("keyup",function(e){if(9===e.keyCode){e.preventDefault();var t=n.tabUpEvents;(0, a.default)(t).call(t,function(t){return t(e)});}}),t.on("keydown",function(e){if(9===e.keyCode){e.preventDefault();var t=n.tabDownEvents;(0, a.default)(t).call(t,function(t){return t(e)});}}),t.on("scroll",d.throttle(function(e){var t=n.textScrollEvents;(0, a.default)(t).call(t,function(t){return t(e)});},100)),s.default(document).on("dragleave",o).on("drop",o).on("dragenter",o).on("dragover",o),e.beforeDestroy(function(){s.default(document).off("dragleave",o).off("drop",o).off("dragenter",o).off("dragover",o);}),t.on("drop",function(e){e.preventDefault();var t=n.dropEvents;(0, a.default)(t).call(t,function(t){return t(e)});}),t.on("click",function(e){var t=null,o=e.target,r=s.default(o);if("A"===r.getNodeName()){ t=r; }else {var i=r.parentUntil("a");null!=i&&(t=i);}if(t){var l=n.linkClickEvents;(0, a.default)(l).call(l,function(e){return e(t)});}}),t.on("click",function(e){var t=null,o=e.target,r=s.default(o);if("IMG"!==r.getNodeName()||r.elems[0].getAttribute("data-emoji")||(e.stopPropagation(),t=r),t){var i=n.imgClickEvents;(0, a.default)(i).call(i,function(e){return e(t)});}}),t.on("click",function(e){var t=null,o=e.target,r=s.default(o);if("PRE"===r.getNodeName()){ t=r; }else {var i=r.parentUntil("pre");null!==i&&(t=i);}if(t){var l=n.codeClickEvents;(0, a.default)(l).call(l,function(e){return e(t)});}}),t.on("click",function(t){var o=null,r=t.target,i=s.default(r);if("HR"===i.getNodeName()&&(o=i),o){e.selection.createRangeByElem(o),e.selection.restoreSelection();var l=n.splitLineEvents;(0, a.default)(l).call(l,function(e){return e(o)});}}),e.$toolbarElem.on("click",function(e){var t=n.toolbarClickEvents;(0, a.default)(t).call(t,function(t){return t(e)});}),e.$textContainerElem.on("mousedown",function(e){var t=e.target;if(s.default(t).hasClass("w-e-img-drag-rb")){var o=n.imgDragBarMouseDownEvents;(0, a.default)(o).call(o,function(e){return e()});}}),t.on("click",function(t){var o,r=t.target;if(o=s.default(r).parentUntilEditor("TABLE",e,r)){var i=n.tableClickEvents;(0, a.default)(i).call(i,function(e){return e(o)});}}),t.on("keydown",function(e){if(13===e.keyCode){var t=n.enterDownEvents;(0, a.default)(t).call(t,function(t){return t(e)});}}),t.on("click",function(e){var t=null,o=e.target,r=s.default(o);if("VIDEO"===r.getNodeName()&&(e.stopPropagation(),t=r),t){var i=n.videoClickEvents;(0, a.default)(i).call(i,function(e){return e(t)});}});},e}();t.default=A;},function(e,t,n){var o=n(287);e.exports=o;},function(e,t,n){var o=n(288),r=Array.prototype;e.exports=function(e){var t=e.find;return e===r||e instanceof Array&&t===r.find?o:t};},function(e,t,n){n(289);var o=n(14);e.exports=o("Array").find;},function(e,t,n){var o=n(5),r=n(29).find,i=n(88),a=!0;"find"in[]&&Array(1).find(function(){a=!1;}),o({target:"Array",proto:!0,forced:a},{find:function(e){return r(this,e,arguments.length>1?arguments[1]:void 0)}}),i("find");},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(291)),i=o.__importDefault(n(292)),a=o.__importDefault(n(293)),l=o.__importDefault(n(294)),u=o.__importDefault(n(301));t.default=function(e){var t=e.editor,n=e.eventHooks;r.default(t,n.enterUpEvents,n.enterDownEvents),i.default(t,n.deleteUpEvents,n.deleteDownEvents),a.default(t,n.tabDownEvents),l.default(t,n.pasteEvents),u.default(t,n.imgClickEvents);};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(26));(0, r.default)(t,"__esModule",{value:!0});var a=n(2).__importDefault(n(3));t.default=function(e,t,n){function o(t){var n,o=a.default("<p><br></p>");o.insertBefore(t),(0, i.default)(n=t.html()).call(n,"<img")>=0?o.remove():(e.selection.createRangeByElem(o,!0,!0),e.selection.restoreSelection(),t.remove());}t.push(function(){var t=e.$textElem,n=e.selection.getSelectionContainerElem(),r=n.parent();"<code><br></code>"!==r.html()?r.equal(t)&&("P"===n.getNodeName()&&null===n.attr("data-we-empty-p")||n.text()||o(n)):o(n);}),n.push(function(t){var n;e.selection.saveRange(null===(n=getSelection())||void 0===n?void 0:n.getRangeAt(0)),e.selection.getSelectionContainerElem().id===e.textElemId&&(t.preventDefault(),e.cmd.do("insertHTML","<p><br></p>"));});};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(19));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=n(7),u=a.__importDefault(n(3));t.default=function(e,t,n){t.push(function(){var t,n=e.$textElem,o=(0, i.default)(t=n.html().toLowerCase()).call(t);if(!o||"<br>"===o){var r=u.default(l.EMPTY_P);n.html(" "),n.append(r),e.selection.createRangeByElem(r,!1,!0),e.selection.restoreSelection(),e.selection.moveCursor(r.getNode(),0);}}),n.push(function(t){var n,o=e.$textElem;(0, i.default)(n=o.html().toLowerCase()).call(n)!==l.EMPTY_P||t.preventDefault();});};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default=function(e,t){t.push(function(){if(e.cmd.queryCommandSupported("insertHTML")){var t=e.selection.getSelectionContainerElem();if(t){var n=t.parent(),o=t.getNodeName(),r=n.getNodeName();"CODE"==o||"CODE"===r||"PRE"===r||/hljs/.test(r)?e.cmd.do("insertHTML",e.config.languageTab):e.cmd.do("insertHTML","&nbsp;&nbsp;&nbsp;&nbsp;");}}});};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(19));(0, r.default)(t,"__esModule",{value:!0});var a=n(124),l=n(6),u=n(7);function c(e){var t=e;return t=(t=t.replace(/<div>/gim,"<p>").replace(/<\/div>/gim,"</p>")).replace(/<p><\/p>/gim,"<p><br></p>"),(0, i.default)(t).call(t)}t.default=function(e,t){t.push(function(t){var n=e.config,o=n.pasteFilterStyle,r=n.pasteIgnoreImg,i=n.pasteTextHandle,s=a.getPasteHtml(t,o,r),f=a.getPasteText(t);f=f.replace(/\n/gm,"<br>");var d=e.selection.getSelectionContainerElem();if(d){var p,v=null==d?void 0:d.getNodeName(),h=null==d?void 0:d.getNodeTop(e),A="";if(h.elems[0]&&(A=null==h?void 0:h.getNodeName()),"CODE"===v||"PRE"===A){ return i&&l.isFunction(i)&&(f=""+(i(f)||"")),void e.cmd.do("insertHTML",(p=f,p.replace(/<br>|<br\/>/gm,"\n").replace(/<[^>]+>/gm,""))); }if(u.urlRegex.test(f)&&o){ return e.cmd.do("insertHTML",'<a href="'+f+'" target="_blank">'+f+"</a>"); }if(s){ try{if(i&&l.isFunction(i)&&(s=""+(i(s)||"")),/[\.\#\@]?\w+[ ]+\{[^}]*\}/.test(s)&&o){ e.cmd.do("insertHTML",""+c(f)); }else {var m=c(s);if(function(e){var t;if(""===e){ return !1; }var n=document.createElement("div");return n.innerHTML=e,"P"===(null===(t=n.firstChild)||void 0===t?void 0:t.nodeName)}(m)){var g=e.$textElem;if(e.cmd.do("insertHTML",m),g.equal(d)){ return void e.selection.createEmptyRange(); }(function(e){if(!(null==e?void 0:e.length)){ return !1; }var t=e.elems[0];return "P"===t.nodeName&&"<br>"===t.innerHTML})(h)&&h.remove();}else { e.cmd.do("insertHTML",m); }}}catch(t$1){i&&l.isFunction(i)&&(f=""+(i(f)||"")),e.cmd.do("insertHTML",""+c(f));} }}});};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(19)),a=o(n(4)),l=o(n(73));(0, r.default)(t,"__esModule",{value:!0});var u=n(2),c=n(296),s=u.__importDefault(n(300));function f(e,t){var n;return e=(0, i.default)(n=e.toLowerCase()).call(n),!!c.IGNORE_TAGS.has(e)||!(!t||"img"!==e)}t.default=function(e,t,n){void 0===t&&(t=!0),void 0===n&&(n=!1);var o=[],r="";(new s.default).parse(e,{startElement:function(e,u){if(function(e){(e=(0, i.default)(e).call(e))&&(c.EMPTY_TAGS.has(e)||(r=e));}(e),!f(e,n)){var s=c.NECESSARY_ATTRS.get(e)||[],d=[];(0, a.default)(u).call(u,function(e){var n=e.name;"style"!==n?!1!==(0, l.default)(s).call(s,n)&&d.push(e):t||d.push(e);});var p=function(e,t){var n="";n="<"+e;var o=[];return (0, a.default)(t).call(t,function(e){o.push(e.name+'="'+e.value+'"');}),o.length>0&&(n=n+" "+o.join(" ")),n=n+(c.EMPTY_TAGS.has(e)?"/":"")+">"}(e,d);o.push(p);}},characters:function(e){e&&(f(r,n)||o.push(e));},endElement:function(e){if(!f(e,n)){var t=function(e){return "</"+e+">"}(e);o.push(t),r="";}},comment:function(e){}});var u=o.join("");return u=function(e){var t=/<span>(.*?)<\/span>/;return e.replace(/<span>.*?<\/span>/gi,function(e){var n=e.match(t);return null==n?"":n[1]})}(u)};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(125)),a=o(n(116));(0, r.default)(t,"__esModule",{value:!0}),t.TOP_LEVEL_TAGS=t.EMPTY_TAGS=t.NECESSARY_ATTRS=t.IGNORE_TAGS=void 0,t.IGNORE_TAGS=new i.default(["doctype","!doctype","html","head","meta","body","script","style","link","frame","iframe","title","svg","center","o:p"]),t.NECESSARY_ATTRS=new a.default([["img",["src","alt"]],["a",["href","target"]],["td",["colspan","rowspan"]],["th",["colspan","rowspan"]]]),t.EMPTY_TAGS=new i.default(["area","base","basefont","br","col","hr","img","input","isindex","embed"]),t.TOP_LEVEL_TAGS=new i.default(["h1","h2","h3","h4","h5","p","ul","ol","table","blockquote","pre","hr","form"]);},function(e,t,n){var o=n(298);e.exports=o;},function(e,t,n){n(299),n(67),n(69),n(50);var o=n(12);e.exports=o.Set;},function(e,t,n){var o=n(117),r=n(119);e.exports=o("Set",function(e){return function(){return e(this,arguments.length?arguments[0]:void 0)}},r);},function(e,t){function n(){}n.prototype={handler:null,startTagRe:/^<([^>\s\/]+)((\s+[^=>\s]+(\s*=\s*((\"[^"]*\")|(\'[^']*\')|[^>\s]+))?)*)\s*\/?\s*>/m,endTagRe:/^<\/([^>\s]+)[^>]*>/m,attrRe:/([^=\s]+)(\s*=\s*((\"([^"]*)\")|(\'([^']*)\')|[^>\s]+))?/gm,parse:function(e,t){var n,o,r;t&&(this.contentHandler=t);for(var i=!1,a=this;e.length>0;){ "\x3c!--"==e.substring(0,4)?-1!=(r=e.indexOf("--\x3e"))?(this.contentHandler.comment(e.substring(4,r)),e=e.substring(r+3),i=!1):i=!0:"</"==e.substring(0,2)?this.endTagRe.test(e)?(n=RegExp.lastMatch,o=RegExp.rightContext,n.replace(this.endTagRe,function(){return a.parseEndTag.apply(a,arguments)}),e=o,i=!1):i=!0:"<"==e.charAt(0)&&(this.startTagRe.test(e)?(n=RegExp.lastMatch,o=RegExp.rightContext,n.replace(this.startTagRe,function(){return a.parseStartTag.apply(a,arguments)}),e=o,i=!1):i=!0),i&&(-1==(r=e.indexOf("<"))?(this.contentHandler.characters(e),e=""):(this.contentHandler.characters(e.substring(0,r)),e=e.substring(r))),i=!0; }},parseStartTag:function(e,t,n){var o=this.parseAttributes(t,n);this.contentHandler.startElement(t,o);},parseEndTag:function(e,t){this.contentHandler.endElement(t);},parseAttributes:function(e,t){var n=this,o=[];return t.replace(this.attrRe,function(t,r,i,a,l,u,c,s){o.push(n.parseAttribute(e,t,r,i,a,l,u,c,s));}),o},parseAttribute:function(e,t,n){var o="";return arguments[7]?o=arguments[8]:arguments[5]?o=arguments[6]:arguments[3]&&(o=arguments[4]),{name:n,value:!o&&!arguments[3]?null:o}}},e.exports=n;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.default=function(e,t){t.push(function(t){e.selection.createRangeByElem(t),e.selection.restoreSelection();});};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=n(6),u=a.__importDefault(n(3));t.default=function e(t){var n=[],o=t.childNodes()||[];return (0, i.default)(o).call(o,function(t){var o,r=t.nodeType;if(3===r&&(o=t.textContent||"",o=l.replaceHtmlSymbol(o)),1===r){(o=o={}).tag=t.nodeName.toLowerCase();for(var i=[],a=t.attributes,c=a.length||0,s=0;s<c;s++){var f=a[s];i.push({name:f.name,value:f.value});}o.attrs=i,o.children=e(u.default(t));}o&&n.push(o);}),n};},function(e,t,n){var o=n(0),r=o(n(94)),i=o(n(1)),a=o(n(4));(0, i.default)(t,"__esModule",{value:!0});var l=n(2).__importDefault(n(3));t.default=function e(t,n){void 0===n&&(n=document.createElement("div"));var o=n;return (0, a.default)(t).call(t,function(t){var n,i;"string"==typeof t&&(n=document.createTextNode(t)),"object"===(0, r.default)(t)&&(n=document.createElement(t.tag),(0, a.default)(i=t.attrs).call(i,function(e){l.default(n).attr(e.name,e.value);}),t.children&&t.children.length>0&&e(t.children,n.getRootNode())),n&&o.appendChild(n);}),l.default(o)};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(90)),a=o(n(72)),l=o(n(73)),u=o(n(4)),c=o(n(126)),s=o(n(127)),f=o(n(54)),d=o(n(53));(0, r.default)(t,"__esModule",{value:!0});var p=n(2),v=p.__importDefault(n(115)),h=p.__importDefault(n(313)),A=p.__importDefault(n(3)),m=function(){function e(e){this.editor=e,this.menuList=[],this.constructorList=h.default;}return e.prototype.extend=function(e,t){t&&"function"==typeof t&&(this.constructorList[e]=t);},e.prototype.init=function(){var e,t,n=this,o=this.editor.config,r=o.excludeMenus;!1===(0, i.default)(r)&&(r=[]),o.menus=(0, a.default)(e=o.menus).call(e,function(e){return !1===(0, l.default)(r).call(r,e)}),(0, u.default)(t=o.menus).call(t,function(e){var t=n.constructorList[e];n._initMenuList(e,t);});for(var s=0,f=(0, c.default)(v.default.globalCustomMenuConstructorList);s<f.length;s++){var d=f[s],p=d[0],h=d[1];this._initMenuList(p,h);}this._addToToolbar(),o.showMenuTooltips&&this._bindMenuTooltips();},e.prototype._initMenuList=function(e,t){var n;if(null!=t&&"function"==typeof t){ if((0, s.default)(n=this.menuList).call(n,function(t){return t.key===e})){ console.warn("菜单名称重复:"+e); }else {var o=new t(this.editor);o.key=e,this.menuList.push(o);} }},e.prototype._bindMenuTooltips=function(){var e=this.editor,t=e.$toolbarElem,n=e.config.menuTooltipPosition,o=A.default('<div class="w-e-menu-tooltip w-e-menu-tooltip-'+n+'">\n            <div class="w-e-menu-tooltip-item-wrapper">\n              <div></div>\n            </div>\n          </div>');o.css("visibility","hidden"),t.append(o),o.css("z-index",e.zIndex.get("tooltip"));var r=0;function i(){r&&clearTimeout(r);}function a(){i(),o.css("visibility","hidden");}t.on("mouseover",function(l){var u,c,s=l.target,d=A.default(s);if(d.isContain(t)){ a(); }else {if(null!=d.parentUntil(".w-e-droplist")){ a(); }else if(d.attr("data-title")){ u=d.attr("data-title"),c=d; }else {var p=d.parentUntil(".w-e-menu");null!=p&&(u=p.attr("data-title"),c=p);}if(u&&c){i();var v=c.getOffsetData();o.text(e.i18next.t("menus.title."+u));var h=o.getOffsetData(),m=v.left+v.width/2-h.width/2;o.css("left",m+"px"),"up"===n?o.css("top",v.top-h.height-8+"px"):"down"===n&&o.css("top",v.top+v.height+8+"px"),r=(0, f.default)(function(){o.css("visibility","visible");},200);}else { a(); }}}).on("mouseleave",function(){a();});},e.prototype._addToToolbar=function(){var e,t=this.editor.$toolbarElem;(0, u.default)(e=this.menuList).call(e,function(e){var n=e.$elem;n&&t.append(n);});},e.prototype.menuFind=function(e){for(var t=this.menuList,n=0,o=t.length;n<o;n++){ if(t[n].key===e){ return t[n]; } }return t[0]},e.prototype.changeActive=function(){var e;(0, u.default)(e=this.menuList).call(e,function(e){var t;(0, f.default)((0, d.default)(t=e.tryChangeActive).call(t,e),100);});},e}();t.default=m;},function(e,t,n){var o=n(306);e.exports=o;},function(e,t,n){n(307);var o=n(12);e.exports=o.Object.entries;},function(e,t,n){var o=n(5),r=n(308).entries;o({target:"Object",stat:!0},{entries:function(e){return r(e)}});},function(e,t,n){var o=n(15),r=n(61),i=n(27),a=n(56).f,l=function(e){return function(t){for(var n,l=i(t),u=r(l),c=u.length,s=0,f=[];c>s;){ n=u[s++],o&&!a.call(l,n)||f.push(e?[n,l[n]]:l[n]); }return f}};e.exports={entries:l(!0),values:l(!1)};},function(e,t,n){var o=n(310);e.exports=o;},function(e,t,n){var o=n(311),r=Array.prototype;e.exports=function(e){var t=e.some;return e===r||e instanceof Array&&t===r.some?o:t};},function(e,t,n){n(312);var o=n(14);e.exports=o("Array").some;},function(e,t,n){var o=n(5),r=n(29).some;o({target:"Array",proto:!0,forced:!n(70)("some")},{some:function(e){return r(this,e,arguments.length>1?arguments[1]:void 0)}});},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(314)),i=o.__importDefault(n(315)),a=o.__importDefault(n(320)),l=o.__importDefault(n(325)),u=o.__importDefault(n(326)),c=o.__importDefault(n(327)),s=o.__importDefault(n(328)),f=o.__importDefault(n(330)),d=o.__importDefault(n(332)),p=o.__importDefault(n(333)),v=o.__importDefault(n(336)),h=o.__importDefault(n(337)),A=o.__importDefault(n(338)),m=o.__importDefault(n(348)),g=o.__importDefault(n(362)),y=o.__importDefault(n(366)),w=o.__importDefault(n(132)),x=o.__importDefault(n(375)),_=o.__importDefault(n(377)),E=o.__importDefault(n(378)),b=o.__importDefault(n(379)),C=o.__importDefault(n(394)),S=o.__importDefault(n(399)),D=o.__importDefault(n(402));t.default={bold:r.default,head:i.default,italic:l.default,link:a.default,underline:u.default,strikeThrough:c.default,fontName:s.default,fontSize:f.default,justify:d.default,quote:p.default,backColor:v.default,foreColor:h.default,video:A.default,image:m.default,indent:g.default,emoticon:y.default,list:w.default,lineHeight:x.default,undo:_.default,redo:E.default,table:b.default,code:C.default,splitLine:S.default,todo:D.default};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(22)),i=o.__importDefault(n(3)),a=function(e){function t(t){var n=i.default('<div class="w-e-menu" data-title="加粗">\n                <i class="w-e-icon-bold"></i>\n            </div>');return e.call(this,n,t)||this}return o.__extends(t,e),t.prototype.clickHandler=function(){var e=this.editor,t=e.selection.isSelectionEmpty();t&&e.selection.createEmptyRange(),e.cmd.do("bold"),t&&(e.selection.collapseRange(),e.selection.restoreSelection());},t.prototype.tryChangeActive=function(){this.editor.cmd.queryCommandState("bold")?this.active():this.unActive();},t}(r.default);t.default=a;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(26)),a=o(n(30)),l=o(n(4)),u=o(n(316)),c=o(n(73));(0, r.default)(t,"__esModule",{value:!0});var s=n(2),f=s.__importDefault(n(23)),d=s.__importDefault(n(3)),p=n(6),v=n(7),h=function(e){function t(t){var n=this,o=d.default('<div class="w-e-menu" data-title="标题"><i class="w-e-icon-header"></i></div>'),r={width:100,title:"设置标题",type:"list",list:[{$elem:d.default("<h1>H1</h1>"),value:"<h1>"},{$elem:d.default("<h2>H2</h2>"),value:"<h2>"},{$elem:d.default("<h3>H3</h3>"),value:"<h3>"},{$elem:d.default("<h4>H4</h4>"),value:"<h4>"},{$elem:d.default("<h5>H5</h5>"),value:"<h5>"},{$elem:d.default("<p>"+t.i18next.t("menus.dropListMenu.head.正文")+"</p>"),value:"<p>"}],clickHandler:function(e){n.command(e);}};return n=e.call(this,o,t,r)||this,t.config.onCatalogChange&&(n.oldCatalogs=[],n.addListenerCatalog(),n.getCatalogs()),n}return s.__extends(t,e),t.prototype.command=function(e){var t=this.editor,n=t.selection.getSelectionContainerElem();if(n&&t.$textElem.equal(n)){ this.setMultilineHead(e); }else {var o;if((0, i.default)(o=["OL","UL","LI","TABLE","TH","TR","CODE","HR"]).call(o,d.default(n).getNodeName())>-1){ return; }t.cmd.do("formatBlock",e);}"<p>"!==e&&this.addUidForSelectionElem();},t.prototype.addUidForSelectionElem=function(){var e=this.editor.selection.getSelectionContainerElem(),t=p.getRandomCode();d.default(e).attr("id",t);},t.prototype.addListenerCatalog=function(){var e=this;this.editor.txt.eventHooks.changeEvents.push(function(){e.getCatalogs();});},t.prototype.getCatalogs=function(){var e=this.editor,t=this.editor.$textElem,n=e.config.onCatalogChange,o=(0, a.default)(t).call(t,"h1,h2,h3,h4,h5"),r=[];(0, l.default)(o).call(o,function(e,t){var n=d.default(e),o=n.attr("id"),i=n.getNodeName(),a=n.text();o||(o=p.getRandomCode(),n.attr("id",o)),a&&r.push({tag:i,id:o,text:a});}),(0, u.default)(this.oldCatalogs)!==(0, u.default)(r)&&(this.oldCatalogs=r,n&&n(r));},t.prototype.setMultilineHead=function(e){var t,n,o=this,r=this.editor,i=r.selection,a=null===(t=i.getSelectionContainerElem())||void 0===t?void 0:t.elems[0],u=["IMG","VIDEO","TABLE","TH","TR","UL","OL","PRE","HR","BLOCKQUOTE"],c=d.default(i.getSelectionStartElem()),s=d.default(i.getSelectionEndElem());s.elems[0].outerHTML!==d.default(v.EMPTY_P).elems[0].outerHTML||s.elems[0].nextSibling||(s=s.prev());var f=[];f.push(c.getNodeTop(r));var p=[],h=null===(n=i.getRange())||void 0===n?void 0:n.commonAncestorContainer.childNodes;null==h||(0, l.default)(h).call(h,function(e,t){e===f[0].getNode()&&p.push(t),e===s.getNodeTop(r).getNode()&&p.push(t);});for(var A=0;f[A].getNode()!==s.getNodeTop(r).getNode();){if(!f[A].elems[0]){ return; }var m=d.default(f[A].next().getNode());f.push(m),A++;}null==f||(0, l.default)(f).call(f,function(t,n){if(!o.hasTag(t,u)){var r=d.default(e),i=t.parent().getNode();r.html(""+t.html()),i.insertBefore(r.getNode(),t.getNode()),t.remove();}}),i.createRangeByElems(a.children[p[0]],a.children[p[1]]);},t.prototype.hasTag=function(e,t){var n,o=this;if(!e){ return !1; }if((0, c.default)(t).call(t,null==e?void 0:e.getNodeName())){ return !0; }var r=!1;return null===(n=e.children())||void 0===n||(0, l.default)(n).call(n,function(e){r=o.hasTag(d.default(e),t);}),r},t.prototype.tryChangeActive=function(){var e=this.editor.cmd.queryCommandValue("formatBlock");/^h/i.test(e)?this.active():this.unActive();},t}(f.default);t.default=h;},function(e,t,n){e.exports=n(317);},function(e,t,n){var o=n(318);e.exports=o;},function(e,t,n){n(319);var o=n(12);o.JSON||(o.JSON={stringify:JSON.stringify}),e.exports=function(e,t,n){return o.JSON.stringify.apply(null,arguments)};},function(e,t,n){var o=n(5),r=n(28),i=n(11),a=r("JSON","stringify"),l=/[\uD800-\uDFFF]/g,u=/^[\uD800-\uDBFF]$/,c=/^[\uDC00-\uDFFF]$/,s=function(e,t,n){var o=n.charAt(t-1),r=n.charAt(t+1);return u.test(e)&&!c.test(r)||c.test(e)&&!u.test(o)?"\\u"+e.charCodeAt(0).toString(16):e},f=i(function(){return '"\\udf06\\ud834"'!==a("\udf06\ud834")||'"\\udead"'!==a("\udead")});a&&o({target:"JSON",stat:!0,forced:f},{stringify:function(e,t,n){var o=a.apply(null,arguments);return "string"==typeof o?o.replace(l,s):o}});},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(33)),i=o.__importDefault(n(3)),a=o.__importDefault(n(321)),l=o.__importDefault(n(129)),u=o.__importDefault(n(31)),c=o.__importDefault(n(323)),s=function(e){function t(t){var n,o=i.default('<div class="w-e-menu" data-title="链接"><i class="w-e-icon-link"></i></div>');return n=e.call(this,o,t)||this,c.default(t),n}return o.__extends(t,e),t.prototype.clickHandler=function(){var e,t=this.editor;if(this.isActive){if(!(e=t.selection.getSelectionContainerElem())){ return; }this.createPanel(e.text(),e.attr("href"));}else { t.selection.isSelectionEmpty()?this.createPanel("",""):this.createPanel(t.selection.getSelectionText(),""); }},t.prototype.createPanel=function(e,t){var n=a.default(this.editor,e,t);new u.default(this,n).create();},t.prototype.tryChangeActive=function(){var e=this.editor;l.default(e)?this.active():this.unActive();},t}(r.default);t.default=s;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(19));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=n(6),u=a.__importDefault(n(3)),c=a.__importDefault(n(129)),s=n(322);t.default=function(e,t,n){var o,r=l.getRandom("input-link"),a=l.getRandom("input-text"),f=l.getRandom("btn-ok"),d=l.getRandom("btn-del"),p=c.default(e)?"inline-block":"none";function v(){if(c.default(e)){var t=e.selection.getSelectionContainerElem();t&&(e.selection.createRangeByElem(t),e.selection.restoreSelection(),o=t);}}return {width:300,height:0,tabs:[{title:e.i18next.t("menus.panelMenus.link.链接"),tpl:'<div>\n                        <input\n                            id="'+a+'"\n                            type="text"\n                            class="block"\n                            value="'+t+'"\n                            placeholder="'+e.i18next.t("menus.panelMenus.link.链接文字")+'"/>\n                        </td>\n                        <input\n                            id="'+r+'"\n                            type="text"\n                            class="block"\n                            value="'+n+'"\n                            placeholder="'+e.i18next.t("如")+' https://..."/>\n                        </td>\n                        <div class="w-e-button-container">\n                            <button type="button" id="'+f+'" class="right">\n                                '+e.i18next.t("插入")+'\n                            </button>\n                            <button type="button" id="'+d+'" class="gray right" style="display:'+p+'">\n                                '+e.i18next.t("menus.panelMenus.link.取消链接")+"\n                            </button>\n                        </div>\n                    </div>",events:[{selector:"#"+f,type:"click",fn:function(){var t,n,o,l;e.selection.restoreSelection();var f=e.selection.getSelectionRangeTopNodes()[0].getNode(),d=window.getSelection(),p=u.default("#"+r),h=u.default("#"+a),A=(0, i.default)(t=p.val()).call(t),m=(0, i.default)(n=h.val()).call(n),g="";d&&!(null==d?void 0:d.isCollapsed)&&(g=null===(o=s.insertHtml(d,f))||void 0===o?void 0:(0, i.default)(o).call(o));var y=null==g?void 0:g.replace(/<.*?>/g,""),w=null!==(l=null==y?void 0:y.length)&&void 0!==l?l:0;if(w<=m.length){var x=m.substring(0,w),_=m.substring(w);y===x&&(m=g+_);}if(A&&(m||(m=A),function(t,n){var o=e.config.linkCheck(t,n);if(void 0===o);else {if(!0===o){ return !0; }e.config.customAlert(o,"warning");}return !1}(m,A))){ return function(t,n){c.default(e)?(v(),e.cmd.do("insertHTML",'<a href="'+n+'" target="_blank">'+t+"</a>")):e.cmd.do("insertHTML",'<a href="'+n+'" target="_blank">'+t+"</a>");}(m,A),!0 }}},{selector:"#"+d,type:"click",fn:function(){return function(){if(c.default(e)){v();var t=o.text();e.cmd.do("insertHTML","<span>"+t+"</span>");}}(),!0}}]}]}};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4));function a(e,t){var n=e,o=e;do{if(n.textContent===t){ break; }o=n,n.parentNode&&(n=null==n?void 0:n.parentNode);}while("P"!==(null==n?void 0:n.nodeName));return o}function l(e,t){var n=e.nodeName,o="";if(3===e.nodeType){ return t; }if(1===e.nodeType){var r=e.getAttribute("style"),i=e.getAttribute("face"),a=e.getAttribute("color");r&&(o=o+' style="'+r+'"'),i&&(o=o+' face="'+i+'"'),a&&(o=o+' color="'+a+'"');}return "<"+(n=n.toLowerCase())+o+">"+t+"</"+n+">"}function u(e,t,n,o){var r,i=null===(r=t.textContent)||void 0===r?void 0:r.substring(n,o),a=t,u="";do{i=u=l(a,null!=i?i:""),a.parentElement&&(a=null==a?void 0:a.parentElement);}while(a.textContent!==e);return u}function c(e,t){return (0, i.default)(e).call(e,function(e){t=l(e,t);}),t}(0, r.default)(t,"__esModule",{value:!0}),t.insertHtml=t.createPartHtml=t.makeHtmlString=t.getTopNode=void 0,t.getTopNode=a,t.makeHtmlString=l,t.createPartHtml=u,t.insertHtml=function(e,t){var n,o,r,i,s,f=e.anchorNode,d=e.focusNode,p=e.anchorOffset,v=e.focusOffset,h=null!==(n=t.textContent)&&void 0!==n?n:"",A=function(e){for(var t,n=null!==(t=e.textContent)&&void 0!==t?t:"",o=[];(null==e?void 0:e.textContent)===n;){ "P"!==e.nodeName&&o.push(e),e=e.childNodes[0]; }return o}(t),m="",g="",y="",w=f,x=d,_=f;if(null==f?void 0:f.isEqualNode(null!=d?d:null)){var E=u(h,f,p,v);return E=c(A,E)}for(f&&(m=u(h,f,null!=p?p:0)),d&&(y=u(h,d,0,v)),f&&(w=a(f,h)),d&&(x=a(d,h)),_=null!==(o=null==w?void 0:w.nextSibling)&&void 0!==o?o:f;!(null==_?void 0:_.isEqualNode(null!=x?x:null));){if("#text"===(null==_?void 0:_.nodeName)){ g+=null==_?void 0:_.textContent; }else {var b=null===(i=null===(r=null==_?void 0:_.firstChild)||void 0===r?void 0:r.parentElement)||void 0===i?void 0:i.innerHTML;_&&(g+=l(_,null!=b?b:""));}_=null!==(s=null==_?void 0:_.nextSibling)&&void 0!==s?s:_;}return c(A,""+m+g+y)};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2).__importDefault(n(324));t.default=function(e){o.default(e);};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(3)),i=o.__importDefault(n(34));t.default=function(e){var t=function(e){var t;return {showLinkTooltip:function(n){var o=[{$elem:r.default("<span>"+e.i18next.t("menus.panelMenus.link.查看链接")+"</span>"),onClick:function(e,t){var n=t.attr("href");return window.open(n,"_target"),!0}},{$elem:r.default("<span>"+e.i18next.t("menus.panelMenus.link.取消链接")+"</span>"),onClick:function(e,t){e.selection.createRangeByElem(t),e.selection.restoreSelection();var n=t.text();return e.cmd.do("insertHTML","<span>"+n+"</span>"),!0}}];(t=new i.default(e,n,o)).create();},hideLinkTooltip:function(){t&&(t.remove(),t=null);}}}(e),n=t.showLinkTooltip,o=t.hideLinkTooltip;e.txt.eventHooks.linkClickEvents.push(n),e.txt.eventHooks.clickEvents.push(o),e.txt.eventHooks.keyupEvents.push(o),e.txt.eventHooks.toolbarClickEvents.push(o),e.txt.eventHooks.menuClickEvents.push(o),e.txt.eventHooks.textScrollEvents.push(o);};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(22)),i=o.__importDefault(n(3)),a=function(e){function t(t){var n=i.default('<div class="w-e-menu" data-title="斜体">\n                <i class="w-e-icon-italic"></i>\n            </div>');return e.call(this,n,t)||this}return o.__extends(t,e),t.prototype.clickHandler=function(){var e=this.editor,t=e.selection.isSelectionEmpty();t&&e.selection.createEmptyRange(),e.cmd.do("italic"),t&&(e.selection.collapseRange(),e.selection.restoreSelection());},t.prototype.tryChangeActive=function(){this.editor.cmd.queryCommandState("italic")?this.active():this.unActive();},t}(r.default);t.default=a;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(22)),i=o.__importDefault(n(3)),a=function(e){function t(t){var n=i.default('<div class="w-e-menu" data-title="下划线">\n                <i class="w-e-icon-underline"></i>\n            </div>');return e.call(this,n,t)||this}return o.__extends(t,e),t.prototype.clickHandler=function(){var e=this.editor,t=e.selection.isSelectionEmpty();t&&e.selection.createEmptyRange(),e.cmd.do("underline"),t&&(e.selection.collapseRange(),e.selection.restoreSelection());},t.prototype.tryChangeActive=function(){this.editor.cmd.queryCommandState("underline")?this.active():this.unActive();},t}(r.default);t.default=a;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(22)),i=o.__importDefault(n(3)),a=function(e){function t(t){var n=i.default('<div class="w-e-menu" data-title="删除线">\n                <i class="w-e-icon-strikethrough"></i>\n            </div>');return e.call(this,n,t)||this}return o.__extends(t,e),t.prototype.clickHandler=function(){var e=this.editor,t=e.selection.isSelectionEmpty();t&&e.selection.createEmptyRange(),e.cmd.do("strikeThrough"),t&&(e.selection.collapseRange(),e.selection.restoreSelection());},t.prototype.tryChangeActive=function(){this.editor.cmd.queryCommandState("strikeThrough")?this.active():this.unActive();},t}(r.default);t.default=a;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(23)),i=o.__importDefault(n(3)),a=o.__importDefault(n(329)),l=function(e){function t(t){var n=this,o=i.default('<div class="w-e-menu" data-title="字体">\n                <i class="w-e-icon-font"></i>\n            </div>'),r={width:100,title:"设置字体",type:"list",list:new a.default(t.config.fontNames).getItemList(),clickHandler:function(e){n.command(e);}};return n=e.call(this,o,t,r)||this}return o.__extends(t,e),t.prototype.command=function(e){var t,n=this.editor,o=n.selection.isSelectionEmpty(),r=null===(t=n.selection.getSelectionContainerElem())||void 0===t?void 0:t.elems[0];if(null!=r){var i="p"!==(null==r?void 0:r.nodeName.toLowerCase()),a=(null==r?void 0:r.getAttribute("face"))===e;if(o){if(i&&!a){var l=n.selection.getSelectionRangeTopNodes();n.selection.createRangeByElem(l[0]),n.selection.moveCursor(l[0].elems[0]);}n.selection.setRangeToContainerElem(r),n.selection.createEmptyRange();}n.cmd.do("fontName",e),o&&(n.selection.collapseRange(),n.selection.restoreSelection());}},t.prototype.tryChangeActive=function(){},t}(r.default);t.default=l;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4));(0, r.default)(t,"__esModule",{value:!0});var a=n(2).__importDefault(n(3)),l=function(){function e(e){var t=this;this.itemList=[],(0, i.default)(e).call(e,function(e){t.itemList.push({$elem:a.default("<p style=\"font-family:'"+e+"'\">"+e+"</p>"),value:e});});}return e.prototype.getItemList=function(){return this.itemList},e}();t.default=l;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(23)),i=o.__importDefault(n(3)),a=o.__importDefault(n(331)),l=function(e){function t(t){var n=this,o=i.default('<div class="w-e-menu" data-title="字号">\n                <i class="w-e-icon-text-heigh"></i>\n            </div>'),r={width:160,title:"设置字号",type:"list",list:new a.default(t.config.fontSizes).getItemList(),clickHandler:function(e){n.command(e);}};return n=e.call(this,o,t,r)||this}return o.__extends(t,e),t.prototype.command=function(e){var t,n=this.editor,o=n.selection.isSelectionEmpty(),r=null===(t=n.selection.getSelectionContainerElem())||void 0===t?void 0:t.elems[0];if(null!=r){var i="p"!==(null==r?void 0:r.nodeName.toLowerCase()),a=(null==r?void 0:r.getAttribute("size"))===e;if(o){if(i&&!a){var l=n.selection.getSelectionRangeTopNodes();n.selection.createRangeByElem(l[0]),n.selection.moveCursor(l[0].elems[0]);}n.selection.setRangeToContainerElem(r),n.selection.createEmptyRange();}n.cmd.do("fontSize",e),o&&(n.selection.collapseRange(),n.selection.restoreSelection());}},t.prototype.tryChangeActive=function(){},t}(r.default);t.default=l;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2).__importDefault(n(3)),r=function(){function e(e){for(var t in this.itemList=[],e){var n=e[t];this.itemList.push({$elem:o.default('<p style="font-size:'+t+'">'+n.name+"</p>"),value:n.value});}}return e.prototype.getItemList=function(){return this.itemList},e}();t.default=r;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4)),a=o(n(26));(0, r.default)(t,"__esModule",{value:!0});var l=n(2),u=l.__importDefault(n(23)),c=l.__importDefault(n(3)),s=["LI"],f=["UL","BLOCKQUOTE"],d=function(e){function t(t){var n=this,o=c.default('<div class="w-e-menu" data-title="对齐"><i class="w-e-icon-paragraph-left"></i></div>'),r={width:100,title:"对齐方式",type:"list",list:[{$elem:c.default('<p>\n                            <i class="w-e-icon-paragraph-left w-e-drop-list-item"></i>\n                            '+t.i18next.t("menus.dropListMenu.justify.靠左")+"\n                        </p>"),value:"left"},{$elem:c.default('<p>\n                            <i class="w-e-icon-paragraph-center w-e-drop-list-item"></i>\n                            '+t.i18next.t("menus.dropListMenu.justify.居中")+"\n                        </p>"),value:"center"},{$elem:c.default('<p>\n                            <i class="w-e-icon-paragraph-right w-e-drop-list-item"></i>\n                            '+t.i18next.t("menus.dropListMenu.justify.靠右")+"\n                        </p>"),value:"right"},{$elem:c.default('<p>\n                            <i class="w-e-icon-paragraph-justify w-e-drop-list-item"></i>\n                            '+t.i18next.t("menus.dropListMenu.justify.两端")+"\n                        </p>"),value:"justify"}],clickHandler:function(e){n.command(e);}};return n=e.call(this,o,t,r)||this}return l.__extends(t,e),t.prototype.command=function(e){var t=this.editor,n=t.selection,o=n.getSelectionContainerElem();n.saveRange();var r=t.selection.getSelectionRangeTopNodes();if(null==o?void 0:o.length){ if(this.isSpecialNode(o,r[0])||this.isSpecialTopNode(r[0])){var a=this.getSpecialNodeUntilTop(o,r[0]);if(null==a){ return; }c.default(a).css("text-align",e);}else { (0, i.default)(r).call(r,function(t){t.css("text-align",e);}); } }n.restoreSelection();},t.prototype.getSpecialNodeUntilTop=function(e,t){for(var n=e.elems[0],o=t.elems[0];null!=n;){if(-1!==(0, a.default)(s).call(s,null==n?void 0:n.nodeName)){ return n; }if(n.parentNode===o){ return n; }n=n.parentNode;}return n},t.prototype.isSpecialNode=function(e,t){var n=this.getSpecialNodeUntilTop(e,t);return null!=n&&-1!==(0, a.default)(s).call(s,n.nodeName)},t.prototype.isSpecialTopNode=function(e){var t;return null!=e&&-1!==(0, a.default)(f).call(f,null===(t=e.elems[0])||void 0===t?void 0:t.nodeName)},t.prototype.tryChangeActive=function(){},t}(u.default);t.default=d;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=a.__importDefault(n(3)),u=a.__importDefault(n(22)),c=a.__importDefault(n(334)),s=a.__importDefault(n(335)),f=n(7),d=function(e){function t(t){var n,o=l.default('<div class="w-e-menu" data-title="引用">\n                <i class="w-e-icon-quotes-left"></i>\n            </div>');return n=e.call(this,o,t)||this,c.default(t),n}return a.__extends(t,e),t.prototype.clickHandler=function(){var e,t=this.editor,n=t.selection.isSelectionEmpty(),o=t.selection.getSelectionRangeTopNodes(),r=o[o.length-1];if("BLOCKQUOTE"!==this.getTopNodeName()){var a=s.default(o);a.insertAfter(r),this.delSelectNode(o);var u=null===(e=a.childNodes())||void 0===e?void 0:e.last().getNode();if(null==u){ return; }return u.textContent?t.selection.moveCursor(u):t.selection.moveCursor(u,0),this.tryChangeActive(),void l.default(f.EMPTY_P).insertAfter(a)}var c=l.default(r.childNodes()),d=c.length,p=r;(0, i.default)(c).call(c,function(e){var t=l.default(e);t.insertAfter(p),p=t;}),r.remove(),t.selection.moveCursor(c.elems[d-1]),this.tryChangeActive(),n&&(t.selection.collapseRange(),t.selection.restoreSelection());},t.prototype.tryChangeActive=function(){var e;"BLOCKQUOTE"===(null===(e=this.editor.selection.getSelectionRangeTopNodes()[0])||void 0===e?void 0:e.getNodeName())?this.active():this.unActive();},t.prototype.getTopNodeName=function(){var e=this.editor.selection.getSelectionRangeTopNodes()[0];return null==e?void 0:e.getNodeName()},t.prototype.delSelectNode=function(e){(0, i.default)(e).call(e,function(e){e.remove();});},t}(u.default);t.default=d;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=n(7),i=o.__importDefault(n(3));t.default=function(e){e.txt.eventHooks.enterDownEvents.push(function(t){var n,o=e.selection.getSelectionContainerElem(),a=e.selection.getSelectionRangeTopNodes()[0];if("BLOCKQUOTE"===(null==a?void 0:a.getNodeName())){if("BLOCKQUOTE"===o.getNodeName()){var l=null===(n=o.childNodes())||void 0===n?void 0:n.getNode();e.selection.moveCursor(l);}if(""===o.text()){t.preventDefault(),o.remove();var u=i.default(r.EMPTY_P);u.insertAfter(a),e.selection.moveCursor(u.getNode(),0);}""===a.text()&&a.remove();}});};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(4));(0, r.default)(t,"__esModule",{value:!0});var a=n(2).__importDefault(n(3));t.default=function(e){var t=a.default("<blockquote></blockquote>");return (0, i.default)(e).call(e,function(e){t.append(e.clone(!0));}),t};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(25));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=a.__importDefault(n(23)),u=a.__importDefault(n(3)),c=n(6),s=function(e){function t(t){var n,o=this,r=u.default('<div class="w-e-menu" data-title="背景色">\n                <i class="w-e-icon-paint-brush"></i>\n            </div>'),a={width:120,title:"背景颜色",type:"inline-block",list:(0, i.default)(n=t.config.colors).call(n,function(e){return {$elem:u.default('<i style="color:'+e+';" class="w-e-icon-paint-brush"></i>'),value:e}}),clickHandler:function(e){o.command(e);}};return o=e.call(this,r,t,a)||this}return a.__extends(t,e),t.prototype.command=function(e){var t,n=this.editor,o=n.selection.isSelectionEmpty(),r=null===(t=n.selection.getSelectionContainerElem())||void 0===t?void 0:t.elems[0];if(null!=r){var i="p"!==(null==r?void 0:r.nodeName.toLowerCase()),a=null==r?void 0:r.style.backgroundColor,l=c.hexToRgb(e)===a;if(o){if(i&&!l){var u=n.selection.getSelectionRangeTopNodes();n.selection.createRangeByElem(u[0]),n.selection.moveCursor(u[0].elems[0]);}n.selection.createEmptyRange();}n.cmd.do("backColor",e),o&&(n.selection.collapseRange(),n.selection.restoreSelection());}},t.prototype.tryChangeActive=function(){},t}(l.default);t.default=s;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(25));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=a.__importDefault(n(23)),u=a.__importDefault(n(3)),c=function(e){function t(t){var n,o=this,r=u.default('<div class="w-e-menu" data-title="文字颜色">\n                <i class="w-e-icon-pencil2"></i>\n            </div>'),a={width:120,title:"文字颜色",type:"inline-block",list:(0, i.default)(n=t.config.colors).call(n,function(e){return {$elem:u.default('<i style="color:'+e+';" class="w-e-icon-pencil2"></i>'),value:e}}),clickHandler:function(e){o.command(e);}};return o=e.call(this,r,t,a)||this}return a.__extends(t,e),t.prototype.command=function(e){var t,n=this.editor,o=n.selection.isSelectionEmpty(),r=null===(t=n.selection.getSelectionContainerElem())||void 0===t?void 0:t.elems[0];if(null!=r){var i="p"!==(null==r?void 0:r.nodeName.toLowerCase()),a=(null==r?void 0:r.getAttribute("color"))===e;if(o){if(i&&!a){var l=n.selection.getSelectionRangeTopNodes();n.selection.createRangeByElem(l[0]),n.selection.moveCursor(l[0].elems[0]);}n.selection.setRangeToContainerElem(r),n.selection.createEmptyRange();}var c=n.selection.getSelectionText();if("A"===r.nodeName&&r.textContent===c){var s=u.default("<span>&#8203;</span>").getNode();r.appendChild(s);}n.cmd.do("foreColor",e),o&&(n.selection.collapseRange(),n.selection.restoreSelection());}},t.prototype.tryChangeActive=function(){},t}(l.default);t.default=c;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(3)),i=o.__importDefault(n(31)),a=o.__importDefault(n(33)),l=o.__importDefault(n(339)),u=o.__importDefault(n(345)),c=function(e){function t(t){var n,o=r.default('<div class="w-e-menu" data-title="视频">\n                <i class="w-e-icon-play"></i>\n            </div>');return n=e.call(this,o,t)||this,u.default(t),n}return o.__extends(t,e),t.prototype.clickHandler=function(){this.createPanel("");},t.prototype.createPanel=function(e){var t=l.default(this.editor,e);new i.default(this,t).create();},t.prototype.tryChangeActive=function(){},t}(a.default);t.default=c;},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(19));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=n(6),u=a.__importDefault(n(3)),c=a.__importDefault(n(340)),s=n(7);t.default=function(e,t){var n=e.config,o=new c.default(e),r=l.getRandom("input-iframe"),a=l.getRandom("btn-ok"),f=l.getRandom("input-upload"),d=l.getRandom("btn-local-ok"),p=[{title:e.i18next.t("menus.panelMenus.video.上传视频"),tpl:'<div class="w-e-up-video-container">\n                    <div id="'+d+'" class="w-e-up-btn">\n                        <i class="w-e-icon-upload2"></i>\n                    </div>\n                    <div style="display:none;">\n                        <input id="'+f+'" type="file" accept="video/*"/>\n                    </div>\n                 </div>',events:[{selector:"#"+d,type:"click",fn:function(){var e=u.default("#"+f).elems[0];if(!e){ return !0; }e.click();}},{selector:"#"+f,type:"change",fn:function(){var e=u.default("#"+f).elems[0];if(!e){ return !0; }var t=e.files;return t.length&&o.uploadVideo(t),!0}}]},{title:e.i18next.t("menus.panelMenus.video.插入视频"),tpl:'<div>\n                    <input \n                        id="'+r+'" \n                        type="text" \n                        class="block" \n                        placeholder="'+e.i18next.t("如")+'：<iframe src=... ></iframe>"/>\n                    </td>\n                    <div class="w-e-button-container">\n                        <button type="button" id="'+a+'" class="right">\n                            '+e.i18next.t("插入")+"\n                        </button>\n                    </div>\n                </div>",events:[{selector:"#"+a,type:"click",fn:function(){var t,n=u.default("#"+r),o=(0, i.default)(t=n.val()).call(t);if(o&&function(t){var n=e.config.onlineVideoCheck(t);return !0===n||("string"==typeof n&&e.config.customAlert(n,"error"),!1)}(o)){ return function(t){e.cmd.do("insertHTML",t+s.EMPTY_P),e.config.onlineVideoCallback(t);}(o),!0 }}}]}],v={width:300,height:0,tabs:[]};return window.FileReader&&(n.uploadVideoServer||n.customUploadVideo)&&v.tabs.push(p[0]),n.showLinkVideo&&v.tabs.push(p[1]),v};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(127)),a=o(n(53)),l=o(n(4)),u=o(n(26));(0, r.default)(t,"__esModule",{value:!0});var c=n(2),s=n(6),f=c.__importDefault(n(130)),d=c.__importDefault(n(131)),p=n(7),v=n(6),h=function(){function e(e){this.editor=e;}return e.prototype.uploadVideo=function(e){var t=this;if(e.length){var n=this.editor,o=n.config,r=function(e){return n.i18next.t("validate."+e)},c=o.uploadVideoServer,p=o.uploadVideoMaxSize/1024,v=o.uploadVideoName,h=o.uploadVideoParams,A=o.uploadVideoParamsWithUrl,m=o.uploadVideoHeaders,g=o.uploadVideoHooks,y=o.uploadVideoTimeout,w=o.withVideoCredentials,x=o.customUploadVideo,_=o.uploadVideoAccept,E=[],b=[];if(s.arrForEach(e,function(e){var t=e.name,n=e.size/1024/1024;t&&n&&(_ instanceof Array?(0, i.default)(_).call(_,function(e){return e===t.split(".")[t.split(".").length-1]})?p<n?b.push("【"+t+"】"+r("大于")+" "+p+"M"):E.push(e):b.push("【"+t+"】"+r("不是视频")):b.push("【"+_+"】"+r("uploadVideoAccept 不是Array")));}),b.length){ o.customAlert(r("视频验证未通过")+": \n"+b.join("\n"),"warning"); }else if(0!==E.length){ if(x&&"function"==typeof x){var C;x(E,(0, a.default)(C=this.insertVideo).call(C,this));}else {var S=new FormData;if((0, l.default)(E).call(E,function(e,t){var n=v||e.name;E.length>1&&(n+=t+1),S.append(n,e);}),c){var D=c.split("#");c=D[0];var N=D[1]||"";(0, l.default)(s).call(s,h,function(e,t){A&&((0, u.default)(c).call(c,"?")>0?c+="&":c+="?",c=c+e+"="+t),S.append(e,t);}),N&&(c+="#"+N);var M=f.default(c,{timeout:y,formData:S,headers:m,withCredentials:!!w,beforeSend:function(e){if(g.before){ return g.before(e,n,E) }},onTimeout:function(e){o.customAlert(r("上传视频超时"),"error"),g.timeout&&g.timeout(e,n);},onProgress:function(e,t){var o=new d.default(n);t.lengthComputable&&(e=t.loaded/t.total,o.show(e));},onError:function(e){o.customAlert(r("上传视频错误"),"error",r("上传视频错误")+"，"+r("服务器返回状态")+": "+e.status),g.error&&g.error(e,n);},onFail:function(e,t){o.customAlert(r("上传视频失败"),"error",r("上传视频返回结果错误")+"，"+r("返回结果")+": "+t),g.fail&&g.fail(e,n,t);},onSuccess:function(e,i){if(g.customInsert){var l;g.customInsert((0, a.default)(l=t.insertVideo).call(l,t),i,n);}else {if("0"!=i.errno){ return o.customAlert(r("上传视频失败"),"error",r("上传视频返回结果错误")+"，"+r("返回结果")+" errno="+i.errno),void(g.fail&&g.fail(e,n,i)); }var u=i.data;t.insertVideo(u.url),g.success&&g.success(e,n,i);}}});"string"==typeof M&&o.customAlert(M,"error");}} }else { o.customAlert(r("传入的文件不合法"),"warning"); }}},e.prototype.insertVideo=function(e){var t=this.editor,n=t.config,o=function(e,n){return void 0===n&&(n="validate."),t.i18next.t(n+e)};if(n.customInsertVideo){ n.customInsertVideo(e); }else {v.UA.isFirefox?t.cmd.do("insertHTML",'<p data-we-video-p="true"><video src="'+e+'" controls="controls" style="max-width:100%"></video></p><p>&#8203</p>'):t.cmd.do("insertHTML",'<video src="'+e+'" controls="controls" style="max-width:100%"></video>'+p.EMPTY_P);var r=document.createElement("video");r.onload=function(){r=null;},r.onerror=function(){n.customAlert(o("插入视频错误"),"error","wangEditor: "+o("插入视频错误")+"，"+o("视频链接")+' "'+e+'"，'+o("下载链接失败")),r=null;},r.onabort=function(){return r=null},r.src=e;}},e}();t.default=h;},function(e,t,n){e.exports=n(342);},function(e,t,n){var o=n(343);e.exports=o;},function(e,t,n){n(344);var o=n(12);e.exports=o.Date.now;},function(e,t,n){n(5)({target:"Date",stat:!0},{now:function(){return (new Date).getTime()}});},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(346)),i=o.__importDefault(n(347));t.default=function(e){r.default(e),i.default(e);};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.createShowHideFn=void 0;var o=n(2),r=o.__importDefault(n(3)),i=o.__importDefault(n(34));function a(e){var t,n=function(t,n){return void 0===n&&(n=""),e.i18next.t(n+t)};return {showVideoTooltip:function(o){var a=[{$elem:r.default("<span class='w-e-icon-trash-o'></span>"),onClick:function(e,t){return t.remove(),!0}},{$elem:r.default("<span>100%</span>"),onClick:function(e,t){return t.attr("width","100%"),t.removeAttr("height"),!0}},{$elem:r.default("<span>50%</span>"),onClick:function(e,t){return t.attr("width","50%"),t.removeAttr("height"),!0}},{$elem:r.default("<span>30%</span>"),onClick:function(e,t){return t.attr("width","30%"),t.removeAttr("height"),!0}},{$elem:r.default("<span>"+n("重置")+"</span>"),onClick:function(e,t){return t.removeAttr("width"),t.removeAttr("height"),!0}}];(t=new i.default(e,o,a)).create();},hideVideoTooltip:function(){t&&(t.remove(),t=null);}}}t.createShowHideFn=a,t.default=function(e){var t=a(e),n=t.showVideoTooltip,o=t.hideVideoTooltip;e.txt.eventHooks.videoClickEvents.push(n),e.txt.eventHooks.clickEvents.push(o),e.txt.eventHooks.keyupEvents.push(o),e.txt.eventHooks.toolbarClickEvents.push(o),e.txt.eventHooks.menuClickEvents.push(o),e.txt.eventHooks.textScrollEvents.push(o),e.txt.eventHooks.changeEvents.push(o);};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(6);t.default=function(e){if(o.UA.isFirefox){var t=e.txt,n=e.selection;t.eventHooks.keydownEvents.push(function(t){var o=n.getSelectionContainerElem();if(o){var r=o.getNodeTop(e),i=r.length&&r.prev().length?r.prev():null;i&&i.attr("data-we-video-p")&&0===n.getCursorPos()&&8===t.keyCode&&i.remove();}});}};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(25));(0, r.default)(t,"__esModule",{value:!0});var a=n(2),l=n(7),u=a.__importDefault(n(3)),c=a.__importDefault(n(31)),s=a.__importDefault(n(33)),f=a.__importDefault(n(349)),d=a.__importDefault(n(361)),p=function(e){function t(t){var n,o=this,r=u.default('<div class="w-e-menu" data-title="图片"><i class="w-e-icon-image"></i></div>'),a=d.default(t);a.onlyUploadConf&&(r=a.onlyUploadConf.$elem,(0, i.default)(n=a.onlyUploadConf.events).call(n,function(e){var t=e.type,n=e.fn||l.EMPTY_FN;r.on(t,function(e){e.stopPropagation(),n(e);});}));return (o=e.call(this,r,t)||this).imgPanelConfig=a,f.default(t),o}return a.__extends(t,e),t.prototype.clickHandler=function(){this.imgPanelConfig.onlyUploadConf||this.createPanel();},t.prototype.createPanel=function(){var e=this.imgPanelConfig,t=new c.default(this,e);this.setPanel(t),t.create();},t.prototype.tryChangeActive=function(){},t}(s.default);t.default=p;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=o.__importDefault(n(350)),i=o.__importDefault(n(351)),a=o.__importDefault(n(352)),l=o.__importDefault(n(360));t.default=function(e){r.default(e),i.default(e),a.default(e),l.default(e);};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2),r=n(124),i=o.__importDefault(n(97));function a(e,t){if(function(e,t){for(var n,o=(null===(n=t.clipboardData)||void 0===n?void 0:n.types)||[],r=0;r<o.length;r++){ if("Files"===o[r]){ return !0; } }return !1}(0,e)||!function(e,t){var n=e.config,o=n.pasteFilterStyle,i=n.pasteIgnoreImg;return !!r.getPasteHtml(t,o,i)||!!r.getPasteText(t)}(t,e)){var n=r.getPasteImgs(e);if(n.length){ new i.default(t).uploadImg(n); }}}t.default=function(e){e.txt.eventHooks.pasteEvents.unshift(function(t){a(t,e);});};},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0});var o=n(2).__importDefault(n(97));t.default=function(e){e.txt.eventHooks.dropEvents.push(function(t){var n=t.dataTransfer&&t.dataTransfer.files;n&&n.length&&new o.default(e).uploadImg(n);});};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(30)),a=o(n(353));(0, r.default)(t,"__esModule",{value:!0}),t.createShowHideFn=void 0;var l=n(2).__importDefault(n(3));n(358);var u=n(6);function c(e,t,n,o,r){e.attr("style","width:"+t+"px; height:"+n+"px; left:"+o+"px; top:"+r+"px;");}function s(e){var t,n=e.$textContainerElem,o=function(e,t){var n=l.default('<div class="w-e-img-drag-mask">\n            <div class="w-e-img-drag-show-size"></div>\n            <div class="w-e-img-drag-rb"></div>\n         </div>');return n.hide(),t.append(n),n}(0,n);function r(){(0, i.default)(n).call(n,".w-e-img-drag-mask").hide();}return function(e,n){e.on("click",function(e){e.stopPropagation();}),e.on("mousedown",".w-e-img-drag-rb",function(o){if(o.preventDefault(),t){var r=o.clientX,u=o.clientY,s=n.getBoundingClientRect(),f=t.getBoundingClientRect(),d=f.width,p=f.height,v=f.left-s.left,h=f.top-s.top,A=d/p,m=d,g=p,y=l.default(document);y.on("mousemove",x),y.on("mouseup",_),y.on("mouseleave",w);}function w(){y.off("mousemove",x),y.off("mouseup",_);}function x(t){t.stopPropagation(),t.preventDefault(),m=d+(t.clientX-r),g=p+(t.clientY-u),m/g!=A&&(g=m/A),m=(0, a.default)(m.toFixed(2)),g=(0, a.default)(g.toFixed(2)),(0, i.default)(e).call(e,".w-e-img-drag-show-size").text(m.toFixed(2).replace(".00","")+"px * "+g.toFixed(2).replace(".00","")+"px"),c(e,m,g,v,h);}function _(){t.attr("width",m+""),t.attr("height",g+"");var n=t.getBoundingClientRect();c(e,m,g,n.left-s.left,n.top-s.top),w();}});}(o,n),l.default(document).on("click",r),e.beforeDestroy(function(){l.default(document).off("click",r);}),{showDrag:function(e){if(u.UA.isIE()){ return !1; }e&&function(e,t,n){var o=e.getBoundingClientRect(),r=n.getBoundingClientRect(),l=r.width.toFixed(2),u=r.height.toFixed(2);(0, i.default)(t).call(t,".w-e-img-drag-show-size").text(l+"px * "+u+"px"),c(t,(0, a.default)(l),(0, a.default)(u),r.left-o.left,r.top-o.top),t.show();}(n,o,t=e);},hideDrag:r}}t.createShowHideFn=s,t.default=function(e){var t=s(e),n=t.showDrag,o=t.hideDrag;e.txt.eventHooks.imgClickEvents.push(n),e.txt.eventHooks.textScrollEvents.push(o),e.txt.eventHooks.keyupEvents.push(o),e.txt.eventHooks.toolbarClickEvents.push(o),e.txt.eventHooks.menuClickEvents.push(o),e.txt.eventHooks.changeEvents.push(o);};},function(e,t,n){e.exports=n(354);},function(e,t,n){var o=n(355);e.exports=o;},function(e,t,n){n(356);var o=n(12);e.exports=o.parseFloat;},function(e,t,n){var o=n(5),r=n(357);o({global:!0,forced:parseFloat!=r},{parseFloat:r});},function(e,t,n){var o=n(8),r=n(91).trim,i=n(71),a=o.parseFloat,l=1/a(i+"-0")!=-1/0;e.exports=l?function(e){var t=r(String(e)),n=a(t);return 0===n&&"-"==t.charAt(0)?-0:n}:a;},function(e,t,n){var o=n(20),r=n(359);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[e.i,r,""]]);var i={insert:"head",singleton:!1};o(r,i);e.exports=r.locals||{};},function(e,t,n){(t=n(21)(!1)).push([e.i,".w-e-text-container {\n  overflow: hidden;\n}\n.w-e-img-drag-mask {\n  position: absolute;\n  z-index: 1;\n  border: 1px dashed #ccc;\n  box-sizing: border-box;\n}\n.w-e-img-drag-mask .w-e-img-drag-rb {\n  position: absolute;\n  right: -5px;\n  bottom: -5px;\n  width: 16px;\n  height: 16px;\n  border-radius: 50%;\n  background: #ccc;\n  cursor: se-resize;\n}\n.w-e-img-drag-mask .w-e-img-drag-show-size {\n  min-width: 110px;\n  height: 22px;\n  line-height: 22px;\n  font-size: 14px;\n  color: #999;\n  position: absolute;\n  left: 0;\n  top: 0;\n  background-color: #999;\n  color: #fff;\n  border-radius: 2px;\n  padding: 0 5px;\n}\n",""]),e.exports=t;},function(e,t,n){(0, n(0)(n(1)).default)(t,"__esModule",{value:!0}),t.createShowHideFn=void 0;var o=n(2),r=o.__importDefault(n(3)),i=o.__importDefault(n(34));function a(e){var t,n=function(t,n){return void 0===n&&(n=""),e.i18next.t(n+t)};return {showImgTooltip:function(o){var a=[{$elem:r.default("<span class='w-e-icon-trash-o'></span>"),onClick:function(e,t){return e.selection.createRangeByElem(t),e.selection.restoreSelection(),e.cmd.do("delete"),!0}},{$elem:r.default("<span>30%</span>"),onClick:function(e,t){return t.attr("width","30%"),t.removeAttr("height"),!0}},{$elem:r.default("<span>50%</span>"),onClick:function(e,t){return t.attr("width","50%"),t.removeAttr("height"),!0}},{$elem:r.default("<span>100%</span>"),onClick:function(e,t){return t.attr("width","100%"),t.removeAttr("height"),!0}}];a.push({$elem:r.default("<span>"+n("重置")+"</span>"),onClick:function(e,t){return t.removeAttr("width"),t.removeAttr("height"),!0}}),o.attr("data-href")&&a.push({$elem:r.default("<span>"+n("查看链接")+"</span>"),onClick:function(e,t){var n=t.attr("data-href");return n&&(n=decodeURIComponent(n),window.open(n,"_target")),!0}}),(t=new i.default(e,o,a)).create();},hideImgTooltip:function(){t&&(t.remove(),t=null);}}}t.createShowHideFn=a,t.default=function(e){var t=a(e),n=t.showImgTooltip,o=t.hideImgTooltip;e.txt.eventHooks.imgClickEvents.push(n),e.txt.eventHooks.clickEvents.push(o),e.txt.eventHooks.keyupEvents.push(o),e.txt.eventHooks.toolbarClickEvents.push(o),e.txt.eventHooks.menuClickEvents.push(o),e.txt.eventHooks.textScrollEvents.push(o),e.txt.eventHooks.imgDragBarMouseDownEvents.push(o),e.txt.eventHooks.changeEvents.push(o);};},function(e,t,n){var o=n(0),r=o(n(1)),i=o(n(25)),a=o(n(19));(0, r.default)(t,"__esModule",{value:!0});var l=n(2),u=l.__importDefault(n(3)),c=n(6),s=l.__importDefault(n(97));t.default=function(e){var t,n=e.config,o=new s.default(e),r=c.getRandom("up-trigger-id"),l=c.getRandom("up-file-id"),f=c.getRandom("input-link-url"),d=c.getRandom("input-link-url-alt"),p=c.getRandom("input-link-url-href"),v=c.getRandom("btn-link"),h=function(t,n){return void 0===n&&(n="menus.panelMenus.image."),e.i18next.t(n+t)},A=1===n.uploadImgMaxLength?"":'multiple="multiple"',m=(0, i.default)(t=n.uploadImgAccept).call(t,function(e){return "image/"+e}).join(","),g=function(e,t,n){return '<div class="'+e+'" data-title="'+n+'">\n            <div id="'+r+'" class="w-e-up-btn">\n                <i class="'+t+'"></i>\n            </div>\n            <div style="display:none;">\n                <input id="'+l+'" type="file" '+A+' accept="'+m+'"/>\n            </div>\n        </div>'},y=[{selector:"#"+r,type:"click",fn:function(){var e=u.default("#"+l).elems[0];if(!e){ return !0; }e.click();}},{selector:"#"+l,type:"change",fn:function(){var e=u.default("#"+l).elems[0];if(!e){ return !0; }var t=e.files;return (null==t?void 0:t.length)&&o.uploadImg(t),!0}}],w=['<input\n            id="'+f+'"\n            type="text"\n            class="block"\n            placeholder="'+h("图片地址")+'"/>'];n.showLinkImgAlt&&w.push('\n        <input\n            id="'+d+'"\n            type="text"\n            class="block"\n            placeholder="'+h("图片文字说明")+'"/>'),n.showLinkImgHref&&w.push('\n        <input\n            id="'+p+'"\n            type="text"\n            class="block"\n            placeholder="'+h("跳转链接")+'"/>');var x=[{title:h("上传图片"),tpl:g("w-e-up-img-container","w-e-icon-upload2",""),events:y},{title:h("网络图片"),tpl:"<div>\n                    "+w.join("")+'\n                    <div class="w-e-button-container">\n                        <button type="button" id="'+v+'" class="right">'+h("插入","")+"</button>\n                    </div>\n                </div>",events:[{selector:"#"+v,type:"click",fn:function(){var e,t,r,i,l,c,s,v=u.default("#"+f),h=(0, a.default)(e=v.val()).call(e);if(h&&(n.showLinkImgAlt&&(t=(0, a.default)(r=u.default("#"+d).val()).call(r)),n.showLinkImgHref&&(i=(0, a.default)(l=u.default("#"+p).val()).call(l)),c=h,!0===(s=n.linkImgCheck(c))||("string"==typeof s&&n.customAlert(s,"error"),0))){ return o.insertImg(h,t,i),!0 }}}]}],_={width:300,height:0,tabs:[],onlyUploadConf:{$elem:u.default(g("w-e-menu","w-e-icon-image","图片")),events:y}};return window.FileReader&&(n.uploadImgShowBase64||n.uploadImgServer||n.customUploadImg)&&_.tabs.push(x[0]),n.