"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _Encoder_instances, _Encoder_CRLF, _Encoder_CRLF_BYTES, _Encoder_CRLF_BYTES_LENGTH, _Encoder_DASHES, _Encoder_encoder, _Encoder_footer, _Encoder_form, _Encoder_getFieldHeader;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Encoder = void 0;
const createBoundary_1 = __importDefault(require("./util/createBoundary"));
const escapeName_1 = __importDefault(require("./util/escapeName"));
const isFormData_1 = __importDefault(require("./util/isFormData"));
const isFile_1 = __importDefault(require("./util/isFile"));
class Encoder {
    constructor(form, boundary = createBoundary_1.default(16)) {
        _Encoder_instances.add(this);
        _Encoder_CRLF.set(this, void 0);
        _Encoder_CRLF_BYTES.set(this, void 0);
        _Encoder_CRLF_BYTES_LENGTH.set(this, void 0);
        _Encoder_DASHES.set(this, "-".repeat(2));
        _Encoder_encoder.set(this, void 0);
        _Encoder_footer.set(this, void 0);
        _Encoder_form.set(this, void 0);
        if (!isFormData_1.default(form)) {
            throw new TypeError("Expected first argument to be a FormData instance.");
        }
        if (typeof boundary !== "string") {
            throw new TypeError("Expected boundary to be a string.");
        }
        this.boundary = `form-data-boundary-${boundary}`;
        this.contentType = `multipart/form-data; boundary=${this.boundary}`;
        __classPrivateFieldSet(this, _Encoder_encoder, new TextEncoder(), "f");
        __classPrivateFieldSet(this, _Encoder_CRLF, "\r\n", "f");
        __classPrivateFieldSet(this, _Encoder_CRLF_BYTES, __classPrivateFieldGet(this, _Encoder_encoder, "f").encode(__classPrivateFieldGet(this, _Encoder_CRLF, "f")), "f");
        __classPrivateFieldSet(this, _Encoder_CRLF_BYTES_LENGTH, __classPrivateFieldGet(this, _Encoder_CRLF_BYTES, "f").byteLength, "f");
        __classPrivateFieldSet(this, _Encoder_form, form, "f");
        __classPrivateFieldSet(this, _Encoder_footer, __classPrivateFieldGet(this, _Encoder_encoder, "f").encode(`${__classPrivateFieldGet(this, _Encoder_DASHES, "f")}${this.boundary}${__classPrivateFieldGet(this, _Encoder_DASHES, "f")}${__classPrivateFieldGet(this, _Encoder_CRLF, "f").repeat(2)}`), "f");
        this.headers = Object.freeze({
            "Content-Type": this.contentType,
            "Content-Length": this.getContentLength()
        });
    }
    getContentLength() {
        let length = 0;
        for (const [name, value] of __classPrivateFieldGet(this, _Encoder_form, "f")) {
            length += __classPrivateFieldGet(this, _Encoder_instances, "m", _Encoder_getFieldHeader).call(this, name, value).byteLength;
            length += isFile_1.default(value)
                ? value.size
                : __classPrivateFieldGet(this, _Encoder_encoder, "f").encode(String(value)).byteLength;
            length += __classPrivateFieldGet(this, _Encoder_CRLF_BYTES_LENGTH, "f");
        }
        return length + __classPrivateFieldGet(this, _Encoder_footer, "f").byteLength;
    }
    *values() {
        for (const [name, value] of __classPrivateFieldGet(this, _Encoder_form, "f").entries()) {
            yield __classPrivateFieldGet(this, _Encoder_instances, "m", _Encoder_getFieldHeader).call(this, name, value);
            yield isFile_1.default(value) ? value : __classPrivateFieldGet(this, _Encoder_encoder, "f").encode(String(value));
            yield __classPrivateFieldGet(this, _Encoder_CRLF_BYTES, "f");
        }
        yield __classPrivateFieldGet(this, _Encoder_footer, "f");
    }
    async *encode() {
        for (const part of this.values()) {
            if (isFile_1.default(part)) {
                yield* part.stream();
            }
            else {
                yield part;
            }
        }
    }
    [(_Encoder_CRLF = new WeakMap(), _Encoder_CRLF_BYTES = new WeakMap(), _Encoder_CRLF_BYTES_LENGTH = new WeakMap(), _Encoder_DASHES = new WeakMap(), _Encoder_encoder = new WeakMap(), _Encoder_footer = new WeakMap(), _Encoder_form = new WeakMap(), _Encoder_instances = new WeakSet(), _Encoder_getFieldHeader = function _Encoder_getFieldHeader(name, value) {
        let header = "";
        header += `${__classPrivateFieldGet(this, _Encoder_DASHES, "f")}${this.boundary}${__classPrivateFieldGet(this, _Encoder_CRLF, "f")}`;
        header += `Content-Disposition: form-data; name="${escapeName_1.default(name)}"`;
        if (isFile_1.default(value)) {
            header += `; filename="${escapeName_1.default(value.name)}"${__classPrivateFieldGet(this, _Encoder_CRLF, "f")}`;
            header += `Content-Type: ${value.type || "application/octet-stream"}`;
        }
        return __classPrivateFieldGet(this, _Encoder_encoder, "f").encode(`${header}${__classPrivateFieldGet(this, _Encoder_CRLF, "f").repeat(2)}`);
    }, Symbol.iterator)]() {
        return this.values();
    }
    [Symbol.asyncIterator]() {
        return this.encode();
    }
}
exports.Encoder = Encoder;
